--[[--
	by ALA
--]]--

local __addon, __private = ...;
local MT = __private.MT;
local CT = __private.CT;
local VT = __private.VT;
local DT = __private.DT;

if not CT.ISCLASSIC then
	return;
end

local DataAgent = DT.DataAgent;

DataAgent.__DataVersion = 241102;

DataAgent.CURPHASE = 6;
DataAgent.MAXPHASE = 6;
DataAgent.MAXRANK = 300;
DataAgent.DBMINPID = 1;
DataAgent.DBMAXPID = 14;

--[==[--
	by ALA
	RECIPES DATA CREDITS ATLASLOOT & MTSL. DATA QUERIED FROM 'db.nfuwow.com'. API QUERIED FROM 'wow.gamepedia.com/World_of_Warcraft_API'
	配方数据来源于AtlasLoot和MissingTradeSkillList, 修改数据来源于nfu数据库, API查询自gamepedia
	请勿加密、乱码、删除空格tab换行符、设置加载依赖
	##	2019-11-27
		Initial release
	##	2020-01-10
		New Feature: Standalone Profit List
	##	2020-02-18
		Modify recipe:	Dark Iron Boots	黑铁长靴	sid = 24399, pid = 2, cid = 20039, MOD: phase = 3
	##	2020-02-29
		Support Auctionator, AUX, AuctionFaster, AuctionMaster now.
	##	2020-04-08
		Rebuild: Using spellId instead of itemId.	!!!Assuming that combination { tradeskill, spellName, itemId } is unique!!!
	##	2020-04-14
		New Feature: Explorer List, Tradeskill Tab
	##	2020-05-09
		Communication: Query who can craft by sid. Broadcast pid to guild.
	##	2020-05-13
		Config Frame
	##	2020-05-27
		Wide Frame, Flat Style, Regular Exp, More setting options.
	##	2020-05-30
		DEL
			pid = 3, sid = 10550	夜色披风
			pid = 9, sid = 28327	蒸汽车控制器	existence and phase?	temporily del
		REAGENTS		checked all
			Tailoring		12091	regeant:	{ 4339, 8343, }, { 5, 3, } >> { 4339, 8343, 2324, }, { 5, 3, 1, }
		LEARN_RANK		checked by recipe tip
			pid = 2, sid = 6517     115 >> 110,
			pid = 2, sid = 3491     100 >> 105,
			pid = 2, sid = 9931     205 >> 210,
			pid = 2, sid = 9954     240 >> 225,
			pid = 8, sid = 8776     10 >> 15,
			pid = 9, sid = 12754	225 >> 235
			pid = 9, sid = 12758	235 >> 245
			pid = 9, sid = 12907    215 >> 235,
			pid = 9, sid = 12895    200 >> 205,
		YELLOW_GREEN_GREY_RANK
			pid = 9, sid = 12716	205, 205, 205 >> 225, 235, 245,		LEARN_RANK need validate
		PHASE
			Tailoring		22813,22866,22867,22868,22869,22870,22902: 1>>2		27658:	5>>1	27660: 1>>5
			Cooking			22761:	1>>2		24801:	1>>4
			Blacksmithing	16742,16744,16745:	1>>2
			Mining			22967:	1>>3
			Engineering		23079:	1>>2
			Leatherworking	22921,22922,22923,22926,22927,22928:	1>>2
			Alchemy			24266:	1>>4
		OTHER
			Engineering		8895 trainer, price: 2200
	##	2020-06-05
		pid = 4, sid = 3450		add trainer
	##	2020-06-10
		New feature: what can be crafted by tip item
	##	2020-06-13
		LERN_RANK
			pid = 3, sid = 10548	235 >> 230
		TRAIN_PRICE
	##	2020-07-01
		Leatrix_Plus	Fired on VARIABLES_LOADED: LeaPlusDB["EnhanceProfessions"] = "Off"
	##	2020-07-28
		28461, 28462, 28463		phase 5 >> 6
--]==]--

local bitclass = {
	["WARRIOR"] = 1,
	["PALADIN"] = 2,
	["HUNTER"] = 4,
	["ROGUE"] = 8,
	["PRIEST"] = 16,
	["SHAMAN"] = 64,
	["MAGE"] = 128,
	["WARLOCK"] = 256,
	["DRUID"] = 1024,
};
DataAgent.USELFCLASSBIT = bitclass[CT.SELFCLASS];

--[==[
	--	P1	MC ONYX
	--	P2	
	--	P3	ZUG
	--	P4	BWL
	--	P5	TAQ RAQ
	--	P6	NAXX
	防具锻造	9788
	武器锻造	9787
		宗师级铸剑	17039
		宗师级铸锤	17040
		宗师级铸斧	17041
	部落制皮	10660
	龙鳞制皮	10656
	元素制皮	10658
	侏儒工程学	20219
	地精工程学	20222
--]==]

DataAgent.T_TradeSkill_ID = {
	[1] = 3273,		--	FirstAid
	[2] = 2018,		--	Blacksmithing
	[3] = 2108,		--	Leatherworking
	[4] = 2259,		--	Alchemy
	[5] = 2383,		--	Herbalism		--	UNUSED
	[6] = 2550,		--	Cooking
	[7] = 2575,		--	Mining
	[8] = 3908,		--	Tailoring
	[9] = 4036,		--	Engineering
	[10] = 7411,	--	Enchanting
	[11] = 7620,	--	Fishing			--	UNUSED
	[12] = 8613,	--	Skinning		--	UNUSED
	[13] = 2842,	--	Poisons			--	Rogue
	[14] = 5149,	--	Beast Training	--	UNUSED	--	Hunter
	-- [15] = 25229,	--	Jewelcrafting
};
DataAgent.T_TradeSkill_Texture = {
	[1] = "Interface\\Icons\\spell_holy_sealofsacrifice",
	[2] = "Interface\\Icons\\trade_blacksmithing",
	[3] = "Interface\\Icons\\trade_leatherworking",
	[4] = "Interface\\Icons\\trade_alchemy",
	[5] = "Interface\\Icons\\trade_herbalism",
	[6] = "Interface\\Icons\\inv_misc_food_15",
	[7] = "Interface\\Icons\\trade_mining",
	[8] = "Interface\\Icons\\trade_tailoring",
	[9] = "Interface\\Icons\\trade_engineering",
	[10] = "Interface\\Icons\\trade_engraving",
	[11] = "Interface\\Icons\\trade_fishing",
	[12] = "Interface\\Icons\\inv_misc_pelt_wolf_01",
	[13] = "Interface\\Icons\\trade_brewpoison",
	[14] = 132162,
	-- [15] = 134071,
};
DataAgent.T_TradeSkill_CheckID = {		--	[pid] = p_check_sid
	[1] = 3273,		--	FirstAid
	[2] = 2018,		--	Blacksmithing
	[3] = 2108,		--	Leatherworking
	[4] = 2259,		--	Alchemy
	[5] = 2383,		--	Herbalism		--	UNUSED
	[6] = 2550,		--	Cooking
	[7] = 2656,		--	Mining
	[8] = 3908,		--	Tailoring
	[9] = 4036,		--	Engineering
	[10] = 7411,	--	Enchanting
	[11] = 7620,	--	Fishing			--	UNUSED
	[12] = 8613,	--	Skinning		--	UNUSED
	[13] = 2842,	--	Poisons			--	Rogue
	[14] = 5149,	--	Beast Training	--	UNUSED	--	Hunter
	-- [15] = 25229,	--	Jewelcrafting
};
DataAgent.T_TradeSkill_HasUI = {		--	[pid] = bool
	[1] = true,		--	FirstAid
	[2] = true,		--	Blacksmithing
	[3] = true,		--	Leatherworking
	[4] = true,		--	Alchemy
	[5] = false,	--	Herbalism		--	UNUSED
	[6] = true,		--	Cooking
	[7] = true,		--	Mining
	[8] = true,		--	Tailoring
	[9] = true,		--	Engineering
	[10] = true,	--	Enchanting
	[11] = false,	--	Fishing			--	UNUSED
	[12] = false,	--	Skinning		--	UNUSED
	[13] = true,	--	Poisons			--	Rogue
	[14] = true,	--	Beast Training	--	UNUSED	--	Hunter
	-- [15] = true,	--	Jewelcrafting
};

-->		Index
	local index_validated = 1;
	local index_phase = 2;
	local index_pid = 3;
	local index_sid = 4;
	local index_cid = 5;
	local index_learn_rank = 6;
	local index_yellow_rank = 7;
	local index_green_rank = 8;
	local index_grey_rank = 9;
	local index_num_made_min = 10;
	local index_num_made_max = 11;
	local index_reagents_id = 12;
	local index_reagents_count = 13;
	local index_trainer = 14;
	local index_train_price = 15;
	local index_recipe = 16;
	local index_quest = 17;
	local index_object = 18;
	local index_class = 19;
	local index_spec = 20;
-->

local T_Recipe_Data = {
--	TradeSkill
	--[[
		SpellEffect.db2
			sid = [36AJ] SpellID
			cid = [14N] EffectItemType
			base = [9I] EffectBasePoints
			side = [13M] EffectDieSides
				side == 0
					min = max(base, 1)
					max = min
				side >0
					min = base + 1
					max = min + side - 1
		SpellReagents.db2
			sid = [2B] SpellID
			reagent = [3C] Reagent...10
			num = [11K] ReagentCount...19
		SkillLineAbility.db2
			通过3SkillLine查表SkillLine.db2得技能名筛选
			sid = [4D] SpellID
			pid = *([3C] SkillLine)
			Grey = [10J] TrivialSkillLineRankLow
			Yellow = [9I] TrivialSkillLineRankHigh
		SkillLine.db2
			[6F] SkillLine
			[1A] DisplayName_lang
		ItemEffect.db2
			[3C] TriggerType == 6 (OnLearn)
			sid = [8H] SpellID
			recipe = [10J] ParentItemID * SpellName
			--	Skip Spell:843
	--]]
	--------------.-PHA-PID-----SID-----CID-LEARN--Y--GREEN-GREY-MIN--MAX---------R-------N--TRAINER-PRICE-RECIPE-QUEST-OBJ-CLASS-SPEC
	--------------1--2---3-------4-------5----6----7----8----9---10---11---------12------13---14-------15-----16---17---18---19----20
--
	--
	[19566] = { nil, 1,  3,  19566,  15409, 250, 250, 250, 250,   1,   1, { 8150, }, { 1, }, },
	[3275]  = { nil, 1,  1,   3275,   1251,   1,  30,  45,  60,   1,   1, { 2589, }, { 1, }, },
	[3276]  = { nil, 1,  1,   3276,   2581,  40,  50,  75, 100,   1,   1, { 2589, }, { 2, }, true, 100, },
	[7934]  = { nil, 1,  1,   7934,   6452,  80,  80, 115, 150,   3,   3, { 1475, }, { 1, }, true, 250, },
	[3277]  = { nil, 1,  1,   3277,   3530,  80,  80, 115, 150,   1,   1, { 2592, }, { 1, }, true, 250, },
	[3278]  = { nil, 1,  1,   3278,   3531, 115, 115, 150, 185,   1,   1, { 2592, }, { 2, }, true, 1000, },
	[7935]  = { nil, 1,  1,   7935,   6453, 130, 130, 165, 200,   3,   3, { 1288, }, { 1, }, nil, nil, { 6454, }, },
	[7928]  = { nil, 1,  1,   7928,   6450, 150, 150, 180, 210,   1,   1, { 4306, }, { 1, }, true, 5000, },
	[7929]  = { nil, 1,  1,   7929,   6451, 180, 180, 210, 240,   1,   1, { 4306, }, { 2, }, nil, nil, { 16112, }, },
	[10840] = { nil, 1,  1,  10840,   8544, 210, 210, 240, 270,   1,   1, { 4338, }, { 1, }, nil, nil, { 16113, }, },
	[10841] = { nil, 1,  1,  10841,   8545, 240, 240, 270, 300,   1,   1, { 4338, }, { 2, }, true, 0, },
	[18629] = { nil, 1,  1,  18629,  14529, 260, 260, 290, 320,   1,   1, { 14047, }, { 1, }, true, 0, },
	[18630] = { nil, 1,  1,  18630,  14530, 290, 290, 320, 350,   1,   1, { 14047, }, { 2, }, true, 0, },
	[23787] = { nil, 3,  1,  23787,  19440, 300, 300, 330, 360,   1,   1, { 19441, }, { 1, }, nil, nil, { 19442, }, },
	[3115]  = { nil, 1,  2,   3115,   3239,   1,  15,  35,  55,   1,   1, { 2835, 2589, }, { 1, 1, }, },
	[2663]  = { nil, 1,  2,   2663,   2853,   1,  20,  40,  60,   1,   1, { 2840, }, { 2, }, },
	[2660]  = { nil, 1,  2,   2660,   2862,   1,  15,  35,  55,   1,   1, { 2835, }, { 1, }, },
	[12260] = { nil, 1,  2,  12260,  10421,   1,  15,  35,  55,   1,   1, { 2840, }, { 4, }, },
	[2662]  = { nil, 1,  2,   2662,   2852,   1,  50,  70,  90,   1,   1, { 2840, }, { 4, }, true, 50, },
	[2737]  = { nil, 1,  2,   2737,   2844,  15,  55,  75,  95,   1,   1, { 2840, 2880, 2589, }, { 6, 1, 2, }, true, 50, },
	[2738]  = { nil, 1,  2,   2738,   2845,  20,  60,  80, 100,   1,   1, { 2840, 2880, 2589, }, { 6, 1, 2, }, true, 50, },
	[3319]  = { nil, 1,  2,   3319,   3469,  20,  60,  80, 100,   1,   1, { 2840, }, { 8, }, true, 50, },
	[2739]  = { nil, 1,  2,   2739,   2847,  25,  65,  85, 105,   1,   1, { 2840, 2880, 2589, }, { 6, 1, 2, }, true, 50, },
	[3320]  = { nil, 1,  2,   3320,   3470,  25,  45,  65,  85,   1,   1, { 2835, }, { 2, }, true, 100, },
	[8880]  = { nil, 1,  2,   8880,   7166,  30,  70,  90, 110,   1,   1, { 2840, 2880, 3470, 2318, }, { 6, 1, 1, 1, }, true, 100, },
	[9983]  = { nil, 1,  2,   9983,   7955,  30,  70,  90, 110,   1,   1, { 2840, 2880, 3470, 2318, }, { 10, 2, 1, 1, }, true, 100, },
	[3293]  = { nil, 1,  2,   3293,   3488,  35,  75,  95, 115,   1,   1, { 2840, 2880, 774, 3470, 2318, }, { 12, 2, 2, 2, 2, }, true, 250, },
	[2661]  = { nil, 1,  2,   2661,   2851,  35,  75,  95, 115,   1,   1, { 2840, }, { 6, }, true, 100, },
	[3321]  = { nil, 1,  2,   3321,   3471,  35,  75,  95, 115,   1,   1, { 2840, 774, 3470, }, { 8, 1, 2, }, nil, nil, { 3609, }, },
	[3323]  = { nil, 1,  2,   3323,   3472,  40,  80, 100, 120,   1,   1, { 2840, 3470, }, { 8, 2, }, true, 100, },
	[3324]  = { nil, 1,  2,   3324,   3473,  45,  85, 105, 125,   1,   1, { 2840, 2321, 3470, }, { 8, 2, 3, }, true, 200, },
	[3325]  = { nil, 1,  2,   3325,   3474,  60, 100, 120, 140,   1,   1, { 2840, 818, 774, }, { 8, 1, 1, }, nil, nil, { 3610, }, },
	[7408]  = { nil, 1,  2,   7408,   6214,  65, 105, 125, 145,   1,   1, { 2840, 2880, 2318, }, { 12, 2, 2, }, true, 300, },
	[2665]  = { nil, 1,  2,   2665,   2863,  65,  65,  72,  80,   1,   1, { 2836, }, { 1, }, true, 100, },
	[3116]  = { nil, 1,  2,   3116,   3240,  65,  65,  72,  80,   1,   1, { 2836, 2592, }, { 1, 1, }, true, 100, },
	[3294]  = { nil, 1,  2,   3294,   3489,  70, 110, 130, 150,   1,   1, { 2840, 2880, 2842, 3470, 2318, }, { 10, 2, 2, 2, 2, }, true, 500, },
	[2666]  = { nil, 1,  2,   2666,   2857,  70, 110, 130, 150,   1,   1, { 2840, }, { 10, }, true, 200, },
	[3326]  = { nil, 1,  2,   3326,   3478,  75,  75,  87, 100,   1,   1, { 2836, }, { 2, }, true, 250, },
	[2667]  = { nil, 1,  2,   2667,   2864,  80, 120, 140, 160,   1,   1, { 2840, 1210, 3470, }, { 12, 1, 2, }, nil, nil, { 2881, }, },
	[2664]  = { nil, 1,  2,   2664,   2854,  90, 115, 127, 140,   1,   1, { 2840, 3470, }, { 10, 3, }, true, 500, },
	[7817]  = { nil, 1,  2,   7817,   6350,  95, 125, 140, 155,   1,   1, { 2841, 3470, }, { 6, 6, }, true, 200, },
	[3292]  = { nil, 1,  2,   3292,   3487,  95, 135, 155, 175,   1,   1, { 2840, 2880, 818, 2319, }, { 14, 2, 2, 2, }, true, 500, },
	[19666] = { nil, 1,  2,  19666,  15869, 100, 100, 110, 120,   2,   2, { 2842, 3470, }, { 1, 1, }, true, 100, },
	[3491]  = { nil, 1,  2,   3491,   3848, 105, 135, 150, 165,   1,   1, { 2841, 2880, 3470, 818, 2319, }, { 6, 4, 2, 1, 1, }, true, 600, },
	[8367]  = { nil, 1,  2,   8367,   6731, 100, 140, 160, 180,   1,   1, { 2840, 818, 3470, }, { 16, 2, 3, }, nil, nil, { 6735, }, },
	[7818]  = { nil, 1,  2,   7818,   6338, 100, 105, 107, 110,   1,   1, { 2842, 3470, }, { 1, 2, }, true, 100, },
	[2668]  = { nil, 1,  2,   2668,   2865, 105, 145, 160, 175,   1,   1, { 2841, }, { 6, }, true, 300, },
	[2670]  = { nil, 1,  2,   2670,   2866, 105, 145, 160, 175,   1,   1, { 2841, }, { 7, }, true, 500, },
	[2740]  = { nil, 1,  2,   2740,   2848, 110, 140, 155, 170,   1,   1, { 2841, 2880, 2319, }, { 6, 4, 1, }, true, 200, },
	[3328]  = { nil, 1,  2,   3328,   3480, 110, 140, 155, 170,   1,   1, { 2841, 1210, 3478, }, { 5, 1, 1, }, true, 500, },
	[2741]  = { nil, 1,  2,   2741,   2849, 115, 145, 160, 175,   1,   1, { 2841, 2880, 2319, }, { 7, 4, 1, }, true, 200, },
	[6517]  = { nil, 1,  2,   6517,   5540, 110, 140, 155, 170,   1,   1, { 2841, 3466, 5498, 3478, }, { 6, 1, 2, 2, }, true, 800, },
	[2672]  = { nil, 1,  2,   2672,   2868, 120, 150, 165, 180,   1,   1, { 2841, 3478, }, { 5, 2, }, true, 500, },
	[2742]  = { nil, 1,  2,   2742,   2850, 120, 150, 165, 180,   1,   1, { 2841, 2880, 2319, }, { 5, 4, 2, }, true, 200, },
	[9985]  = { nil, 1,  2,   9985,   7956, 125, 155, 170, 185,   1,   1, { 2841, 3466, 2319, }, { 8, 1, 1, }, true, 250, },
	[2674]  = { nil, 1,  2,   2674,   2871, 125, 125, 132, 140,   1,   1, { 2838, }, { 1, }, true, 1000, },
	[3330]  = { nil, 1,  2,   3330,   3481, 125, 155, 170, 185,   1,   1, { 2841, 2842, 3478, }, { 8, 2, 2, }, nil, nil, { 2882, }, },
	[3117]  = { nil, 1,  2,   3117,   3241, 125, 125, 132, 140,   1,   1, { 2838, 2592, }, { 1, 1, }, true, 1000, },
	[3295]  = { nil, 1,  2,   3295,   3490, 125, 155, 170, 185,   1,   1, { 2841, 3466, 2459, 1210, 3478, 2319, }, { 4, 1, 1, 2, 2, 2, }, nil, nil, { 2883, }, },
	[3337]  = { nil, 1,  2,   3337,   3486, 125, 125, 137, 150,   1,   1, { 2838, }, { 3, }, true, 1000, },
	[3331]  = { nil, 1,  2,   3331,   3482, 130, 160, 175, 190,   1,   1, { 2841, 2842, 3478, }, { 6, 1, 2, }, true, 500, },
	[9986]  = { nil, 1,  2,   9986,   7957, 130, 160, 175, 190,   1,   1, { 2841, 3466, 2319, }, { 12, 2, 2, }, true, 500, },
	[3296]  = { nil, 1,  2,   3296,   3491, 130, 160, 175, 190,   1,   1, { 2841, 3466, 1206, 1210, 3478, 2319, }, { 8, 1, 1, 1, 2, 2, }, true, 1000, },
	[2673]  = { nil, 1,  2,   2673,   2869, 130, 160, 175, 190,   1,   1, { 2841, 2842, 3478, 1705, }, { 10, 2, 2, 1, }, nil, nil, { 5578, }, },
	[9987]  = { nil, 1,  2,   9987,   7958, 135, 165, 180, 195,   1,   1, { 2841, 3466, 2319, }, { 14, 1, 2, }, true, 500, },
	[3333]  = { nil, 1,  2,   3333,   3483, 135, 165, 180, 195,   1,   1, { 2841, 2842, 3478, }, { 8, 1, 2, }, true, 1000, },
	[6518]  = { nil, 1,  2,   6518,   5541, 140, 170, 185, 200,   1,   1, { 2841, 3466, 5500, 3478, 2319, }, { 10, 1, 1, 2, 2, }, nil, nil, { 5543, }, },
	[3297]  = { nil, 1,  2,   3297,   3492, 145, 175, 190, 205,   1,   1, { 3575, 3466, 3391, 1705, 3478, 2319, }, { 6, 2, 1, 2, 2, 2, }, nil, nil, { 3608, }, },
	[3334]  = { nil, 1,  2,   3334,   3484, 145, 175, 190, 205,   1,   1, { 3575, 1705, 3478, 2605, }, { 4, 2, 2, 1, }, nil, nil, { 3611, }, },
	[2675]  = { nil, 1,  2,   2675,   2870, 145, 175, 190, 205,   1,   1, { 2841, 1206, 1705, 5500, 2842, }, { 20, 2, 2, 2, 4, }, true, 1000, },
	[14379] = { nil, 1,  2,  14379,  11128, 150, 155, 157, 160,   1,   1, { 3577, 3478, }, { 1, 2, }, true, 250, },
	[8768]  = { nil, 1,  2,   8768,   7071, 150, 150, 152, 155,   2,   2, { 3575, }, { 1, }, true, 250, },
	[3336]  = { nil, 1,  2,   3336,   3485, 150, 180, 195, 210,   1,   1, { 3575, 5498, 3478, 2605, }, { 4, 2, 2, 1, }, nil, nil, { 3612, }, },
	[7221]  = { nil, 1,  2,   7221,   6042, 150, 180, 195, 210,   1,   1, { 3575, 3478, }, { 6, 4, }, nil, nil, { 6044, }, },
	[19667] = { nil, 1,  2,  19667,  15870, 150, 150, 160, 170,   2,   2, { 3577, 3486, }, { 1, 1, }, true, 250, },
	[3506]  = { nil, 1,  2,   3506,   3842, 155, 180, 192, 205,   1,   1, { 3575, 3486, 2605, }, { 8, 1, 1, }, true, 5000, },
	[3494]  = { nil, 1,  2,   3494,   3851, 155, 180, 192, 205,   1,   1, { 3575, 3466, 3486, 2842, 4234, }, { 8, 2, 1, 4, 2, }, nil, nil, { 10858, }, },
	[12259] = { nil, 1,  2,  12259,  10423, 155, 180, 192, 205,   1,   1, { 2841, 2842, 3478, }, { 12, 4, 2, }, nil, nil, { 10424, }, },
	[3492]  = { nil, 1,  2,   3492,   3849, 160, 185, 197, 210,   1,   1, { 3575, 3466, 3486, 1705, 4234, }, { 6, 2, 1, 2, 3, }, nil, nil, { 12162, }, },
	[3504]  = { nil, 1,  2,   3504,   3840, 160, 185, 197, 210,   1,   1, { 3575, 3486, 2605, }, { 7, 1, 1, }, nil, nil, { 3870, }, },
	[9813]  = { nil, 1,  2,   9813,   7914, 160, 185, 197, 210,   1,   1, { 3575, 3486, }, { 20, 4, }, nil, nil, { 7979, }, },
	[9811]  = { nil, 1,  2,   9811,   7913, 160, 185, 197, 210,   1,   1, { 3575, 5635, 1210, 3486, }, { 8, 4, 2, 2, }, nil, nil, { 7978, }, },
	[7222]  = { nil, 1,  2,   7222,   6043, 165, 190, 202, 215,   1,   1, { 3575, 3478, 1705, }, { 4, 2, 1, }, nil, nil, { 6045, }, },
	[3501]  = { nil, 1,  2,   3501,   3835, 165, 190, 202, 215,   1,   1, { 3575, 2605, }, { 6, 1, }, true, 1000, },
	[3495]  = { nil, 1,  2,   3495,   3852, 170, 195, 207, 220,   1,   1, { 3575, 3577, 1705, 3466, 4234, 3486, }, { 10, 4, 2, 2, 2, 2, }, nil, nil, { 3867, }, },
	[3502]  = { nil, 1,  2,   3502,   3836, 170, 195, 207, 220,   1,   1, { 3575, 3864, 2605, }, { 12, 1, 1, }, true, 1250, },
	[3507]  = { nil, 1,  2,   3507,   3843, 170, 195, 207, 220,   1,   1, { 3575, 3577, 3486, }, { 10, 2, 1, }, nil, nil, { 3872, }, },
	[9814]  = { nil, 1,  2,   9814,   7915, 175, 200, 212, 225,   1,   1, { 3575, 5637, 5635, }, { 10, 2, 2, }, nil, nil, { 7980, }, },
	[3505]  = { nil, 1,  2,   3505,   3841, 175, 200, 212, 225,   1,   1, { 3859, 3577, 3486, }, { 6, 2, 1, }, nil, nil, { 3871, }, },
	[3493]  = { nil, 1,  2,   3493,   3850, 175, 200, 212, 225,   1,   1, { 3575, 3466, 3486, 1529, 4234, }, { 8, 2, 2, 2, 3, }, nil, nil, { 3866, }, },
	[3496]  = { nil, 1,  2,   3496,   3853, 180, 205, 217, 230,   1,   1, { 3859, 3466, 3486, 1705, 4234, }, { 8, 2, 2, 3, 3, }, nil, nil, { 12163, }, },
	[3508]  = { nil, 1,  2,   3508,   3844, 180, 205, 217, 230,   1,   1, { 3575, 3486, 1529, 1206, 4255, }, { 20, 4, 2, 2, 1, }, true, 7500, },
	[15972] = { nil, 1,  2,  15972,  12259, 180, 205, 217, 230,   1,   1, { 3859, 3466, 1206, 7067, 4234, }, { 10, 2, 1, 1, 1, }, true, 7500, },
	[9818]  = { nil, 1,  2,   9818,   7916, 180, 205, 217, 230,   1,   1, { 3575, 5637, 818, 3486, }, { 12, 4, 4, 2, }, nil, nil, { 7981, }, },
	[3498]  = { nil, 1,  2,   3498,   3855, 185, 210, 222, 235,   1,   1, { 3575, 3466, 3486, 3577, 4234, }, { 14, 2, 2, 4, 2, }, nil, nil, { 12164, }, },
	[9820]  = { nil, 1,  2,   9820,   7917, 185, 210, 222, 235,   1,   1, { 3575, 3486, 5637, }, { 14, 3, 2, }, nil, nil, { 7982, }, },
	[3513]  = { nil, 1,  2,   3513,   3846, 185, 210, 222, 235,   1,   1, { 3859, 3864, 1705, 3486, }, { 8, 1, 1, 2, }, nil, nil, { 3874, }, },
	[7223]  = { nil, 1,  2,   7223,   6040, 185, 210, 222, 235,   1,   1, { 3859, 3486, }, { 5, 2, }, true, 1000, },
	[7224]  = { nil, 1,  2,   7224,   6041, 190, 215, 227, 240,   1,   1, { 3859, 3486, 4234, }, { 8, 2, 4, }, nil, nil, { 6046, }, },
	[21913] = { nil, 1,  2,  21913,  17704, 190, 215, 227, 240,   1,   1, { 3859, 3829, 7070, 7069, 4234, }, { 10, 1, 2, 2, 2, }, nil, nil, { 17706, }, },
	[3503]  = { nil, 1,  2,   3503,   3837, 190, 215, 227, 240,   1,   1, { 3859, 3577, 3486, }, { 8, 2, 2, }, nil, nil, { 6047, }, },
	[15973] = { nil, 1,  2,  15973,  12260, 190, 215, 227, 240,   1,   1, { 3859, 3577, 7068, 4234, }, { 10, 4, 2, 2, }, nil, nil, { 12261, }, },
	[3511]  = { nil, 1,  2,   3511,   3845, 195, 220, 232, 245,   1,   1, { 3859, 3577, 3486, 1529, }, { 12, 2, 4, 2, }, nil, nil, { 3873, }, },
	[9916]  = { nil, 1,  2,   9916,   7963, 200, 225, 237, 250,   1,   1, { 3859, 3486, }, { 16, 3, }, true, 2500, },
	[9920]  = { nil, 1,  2,   9920,   7966, 200, 200, 205, 210,   1,   1, { 7912, }, { 4, }, true, 2500, },
	[9918]  = { nil, 1,  2,   9918,   7964, 200, 200, 205, 210,   1,   1, { 7912, }, { 1, }, true, 2500, },
	[19668] = { nil, 1,  2,  19668,  15871, 200, 200, 210, 220,   2,   2, { 6037, 7966, }, { 1, 1, }, true, 2500, },
	[9921]  = { nil, 1,  2,   9921,   7965, 200, 200, 205, 210,   1,   1, { 7912, 4306, }, { 1, 1, }, true, 2500, },
	[3497]  = { nil, 1,  2,   3497,   3854, 200, 225, 237, 250,   1,   1, { 3859, 3466, 3486, 1529, 3829, 4234, }, { 8, 2, 2, 2, 1, 4, }, nil, nil, { 3868, }, },
	[11454] = { nil, 1,  2,  11454,   9060, 200, 225, 237, 250,   1,   1, { 3860, 3577, 6037, }, { 5, 1, 1, }, nil, nil, { 10713, }, },
	[14380] = { nil, 1,  2,  14380,  11144, 200, 205, 207, 210,   1,   1, { 6037, 3486, }, { 1, 1, }, true, 2500, },
	[3500]  = { nil, 1,  2,   3500,   3856, 200, 225, 237, 250,   1,   1, { 3859, 3466, 3486, 3864, 3824, 4234, }, { 10, 2, 3, 2, 1, 3, }, nil, nil, { 3869, }, },
	[3515]  = { nil, 1,  2,   3515,   3847, 200, 225, 237, 250,   1,   1, { 3859, 3577, 3486, 3864, }, { 10, 4, 4, 1, }, nil, nil, { 3875, }, },
	[11643] = { nil, 1,  2,  11643,   9366, 205, 225, 235, 245,   1,   1, { 3859, 3577, 3486, 3864, }, { 10, 4, 4, 1, }, nil, nil, { 9367, }, },
	[9928]  = { nil, 1,  2,   9928,   7919, 205, 225, 235, 245,   1,   1, { 3860, 4338, }, { 6, 4, }, true, 5000, },
	[9926]  = { nil, 1,  2,   9926,   7918, 205, 225, 235, 245,   1,   1, { 3860, 4234, }, { 8, 6, }, true, 5000, },
	[9931]  = { nil, 1,  2,   9931,   7920, 210, 230, 240, 250,   1,   1, { 3860, }, { 12, }, true, 5000, },
	[9933]  = { nil, 1,  2,   9933,   7921, 210, 230, 240, 250,   1,   1, { 3860, 1705, }, { 10, 2, }, nil, nil, { 7975, }, },
	[9980]  = { nil, 1,  2,   9980,   7937, 210, 265, 275, 285,   1,   1, { 3860, 6037, 7971, 7966, }, { 16, 2, 1, 1, }, nil, nil, nil, { 2771, }, },
	[9993]  = { nil, 1,  2,   9993,   7941, 210, 235, 247, 260,   1,   1, { 3860, 3864, 7966, 4234, }, { 12, 2, 1, 4, }, true, 10000, },
	[9972]  = { nil, 1,  2,   9972,   7935, 210, 260, 270, 280,   1,   1, { 3860, 6037, 7077, 7966, }, { 16, 6, 1, 1, }, nil, nil, nil, { 2773, }, },
	[9979]  = { nil, 1,  2,   9979,   7936, 210, 265, 275, 285,   1,   1, { 3860, 6037, 4304, 7966, 7909, }, { 14, 2, 4, 1, 1, }, nil, nil, nil, { 2772, }, },
	[9937]  = { nil, 1,  2,   9937,   7924, 215, 235, 245, 255,   1,   1, { 3860, 3864, }, { 8, 2, }, nil, nil, { 7995, }, },
	[9935]  = { nil, 1,  2,   9935,   7922, 215, 235, 245, 255,   1,   1, { 3859, 7966, }, { 14, 1, }, true, 5000, },
	[9957]  = { nil, 1,  2,   9957,   7929, 215, 250, 260, 270,   1,   1, { 3860, 7067, }, { 12, 1, }, nil, nil, nil, { 2756, }, },
	[9939]  = { nil, 1,  2,   9939,   7967, 215, 235, 245, 255,   1,   1, { 3860, 6037, 7966, }, { 4, 2, 4, }, nil, nil, { 7976, }, },
	[9945]  = { nil, 1,  2,   9945,   7926, 220, 240, 250, 260,   1,   1, { 3860, 6037, 7966, 7909, }, { 12, 1, 1, 1, }, nil, nil, { 7983, }, },
	[9950]  = { nil, 1,  2,   9950,   7927, 220, 240, 250, 260,   1,   1, { 3860, 4338, 6037, 7966, }, { 10, 6, 1, 1, }, nil, nil, { 7984, }, },
	[9995]  = { nil, 1,  2,   9995,   7942, 220, 245, 257, 270,   1,   1, { 3860, 7909, 7966, 4304, }, { 16, 2, 1, 4, }, nil, nil, { 7992, }, },
	[9952]  = { nil, 1,  2,   9952,   7928, 225, 245, 255, 265,   1,   1, { 3860, 6037, 4304, }, { 12, 1, 6, }, nil, nil, { 7985, }, },
	[9997]  = { nil, 1,  2,   9997,   7943, 225, 250, 262, 275,   1,   1, { 3860, 6037, 7966, 4304, }, { 14, 4, 1, 2, }, nil, nil, { 8029, }, },
	[9961]  = { nil, 1,  2,   9961,   7931, 230, 250, 260, 270,   1,   1, { 3860, 4338, }, { 10, 6, }, true, 15000, },
	[10001] = { nil, 1,  2,  10001,   7945, 230, 255, 267, 280,   1,   1, { 3860, 7971, 1210, 7966, 4304, }, { 16, 1, 4, 1, 2, }, true, 15000, },
	[9959]  = { nil, 1,  2,   9959,   7930, 230, 250, 260, 270,   1,   1, { 3860, }, { 16, }, true, 15000, },
	[9964]  = { nil, 1,  2,   9964,   7969, 235, 255, 265, 275,   1,   1, { 3860, 7966, }, { 4, 3, }, nil, nil, { 7989, }, },
	[10003] = { nil, 1,  2,  10003,   7954, 235, 260, 272, 285,   1,   1, { 3860, 7075, 6037, 3864, 1529, 7966, 4304, }, { 24, 4, 6, 5, 5, 4, 4, }, true, 13500, nil, nil, nil, nil, 9787, },
	[9968]  = { nil, 1,  2,   9968,   7933, 235, 255, 265, 275,   1,   1, { 3860, 4304, }, { 14, 4, }, true, 20000, },
	[9966]  = { nil, 1,  2,   9966,   7932, 235, 255, 265, 275,   1,   1, { 3860, 4304, 3864, }, { 14, 4, 4, }, nil, nil, { 7991, }, },
	[10005] = { nil, 1,  2,  10005,   7944, 240, 265, 277, 290,   1,   1, { 3860, 7909, 1705, 1206, 7966, 4338, }, { 14, 1, 2, 2, 1, 2, }, nil, nil, { 7993, }, },
	[9954]  = { nil, 1,  2,   9954,   7938, 225, 245, 255, 265,   1,   1, { 3860, 6037, 7909, 3864, 5966, 7966, }, { 10, 8, 3, 3, 1, 2, }, true, 10000, nil, nil, nil, nil, 9788, },
	[10007] = { nil, 1,  2,  10007,   7961, 245, 270, 282, 295,   1,   1, { 3860, 7081, 6037, 3823, 7909, 7966, 4304, }, { 28, 6, 8, 2, 6, 4, 2, }, true, 13500, nil, nil, nil, nil, 9787, },
	[9970]  = { nil, 1,  2,   9970,   7934, 245, 255, 265, 275,   1,   1, { 3860, 7909, }, { 14, 1, }, nil, nil, { 7990, }, },
	[10009] = { nil, 1,  2,  10009,   7946, 245, 270, 282, 295,   1,   1, { 3860, 7075, 7966, 4304, }, { 18, 2, 1, 4, }, nil, nil, { 8028, }, },
	[9974]  = { nil, 1,  2,   9974,   7939, 245, 265, 275, 285,   1,   1, { 3860, 6037, 7910, 7971, 7966, }, { 12, 24, 4, 4, 2, }, true, 10000, nil, nil, nil, nil, 9788, },
	[16639] = { nil, 1,  2,  16639,  12644, 250, 255, 257, 260,   1,   1, { 12365, }, { 4, }, true, 10000, },
	[16643] = { nil, 1,  2,  16643,  12406, 250, 270, 280, 290,   1,   1, { 12359, 11186, }, { 12, 4, }, nil, nil, { 12683, }, },
	[16641] = { nil, 1,  2,  16641,  12404, 250, 255, 257, 260,   1,   1, { 12365, }, { 1, }, true, 10000, },
	[16642] = { nil, 1,  2,  16642,  12405, 250, 270, 280, 290,   1,   1, { 12359, 12361, 11188, }, { 16, 1, 4, }, nil, nil, { 12682, }, },
	[16640] = { nil, 1,  2,  16640,  12643, 250, 255, 257, 260,   1,   1, { 12365, 14047, }, { 1, 1, }, true, 10000, },
	[10011] = { nil, 1,  2,  10011,   7959, 250, 275, 287, 300,   1,   1, { 3860, 7972, 6037, 7966, 4304, }, { 28, 10, 10, 6, 6, }, true, 13500, nil, nil, nil, nil, 9787, },
	[10013] = { nil, 1,  2,  10013,   7947, 255, 280, 292, 305,   1,   1, { 3860, 6037, 7910, 7966, 4304, }, { 12, 6, 2, 1, 2, }, nil, nil, { 8030, }, },
	[16644] = { nil, 1,  2,  16644,  12408, 255, 275, 285, 295,   1,   1, { 12359, 11184, }, { 12, 4, }, nil, nil, { 12684, }, },
	[16645] = { nil, 1,  2,  16645,  12416, 260, 280, 290, 300,   1,   1, { 12359, 7077, }, { 10, 2, }, nil, nil, { 12685, }, },
	[10015] = { nil, 1,  2,  10015,   7960, 260, 285, 297, 310,   1,   1, { 3860, 6037, 7910, 7081, 7966, 4304, }, { 30, 16, 6, 4, 8, 6, }, true, 13500, nil, nil, nil, nil, 9787, },
	[15292] = { nil, 1,  2,  15292,  11608, 265, 285, 295, 305,   1,   1, { 11371, 7077, }, { 18, 4, }, nil, nil, { 11610, }, nil, nil, nil, 9787, },
	[16647] = { nil, 1,  2,  16647,  12424, 265, 285, 295, 305,   1,   1, { 12359, 8170, 7909, }, { 22, 6, 1, }, nil, nil, { 12688, }, },
	[16646] = { nil, 1,  2,  16646,  12428, 265, 285, 295, 305,   1,   1, { 12359, 8170, 3864, }, { 24, 6, 2, }, nil, nil, { 12687, }, },
	[16648] = { nil, 1,  2,  16648,  12415, 270, 290, 300, 310,   1,   1, { 12359, 7077, 7910, }, { 18, 2, 1, }, nil, nil, { 12689, }, },
	[16649] = { nil, 1,  2,  16649,  12425, 270, 290, 300, 310,   1,   1, { 12359, 7910, }, { 20, 1, }, nil, nil, { 12690, }, },
	[16650] = { nil, 1,  2,  16650,  12624, 270, 290, 300, 310,   1,   1, { 12359, 12655, 12803, 8153, 12364, }, { 40, 2, 4, 4, 1, }, nil, nil, { 12691, }, nil, nil, nil, 9788, },
	[15293] = { nil, 1,  2,  15293,  11606, 270, 290, 300, 310,   1,   1, { 11371, 7077, }, { 10, 2, }, nil, nil, { 11614, }, },
	[16970] = { nil, 1,  2,  16970,  12774, 275, 300, 312, 325,   1,   1, { 12359, 12655, 7910, 12361, 12644, 8170, }, { 30, 4, 4, 4, 2, 4, }, nil, nil, { 12821, }, nil, nil, nil, 17041, },
	[16969] = { nil, 1,  2,  16969,  12773, 275, 300, 312, 325,   1,   1, { 12359, 12799, 12644, 8170, }, { 20, 2, 2, 4, }, nil, nil, { 12819, }, },
	[20201] = { nil, 1,  2,  20201,  16206, 275, 275, 280, 285,   1,   1, { 12360, 12644, }, { 3, 1, }, true, 10000, },
	[16651] = { nil, 1,  2,  16651,  12645, 275, 295, 305, 315,   1,   1, { 12359, 12644, 7076, }, { 4, 4, 2, }, nil, nil, { 12692, }, },
	[19669] = { nil, 1,  2,  19669,  15872, 275, 275, 280, 285,   2,   2, { 12360, 12644, }, { 1, 1, }, true, 10000, },
	[15294] = { nil, 1,  2,  15294,  11607, 275, 295, 305, 315,   1,   1, { 11371, 7077, }, { 26, 4, }, nil, nil, { 11611, }, nil, nil, nil, 9787, },
	[15295] = { nil, 1,  2,  15295,  11605, 280, 300, 310, 320,   1,   1, { 11371, 7077, }, { 6, 1, }, nil, nil, { 11615, }, },
	[16973] = { nil, 1,  2,  16973,  12776, 280, 305, 317, 330,   1,   1, { 12359, 12655, 12364, 12804, 8170, }, { 20, 6, 2, 4, 4, }, nil, nil, { 12824, }, nil, nil, nil, 17040, },
	[16653] = { nil, 1,  2,  16653,  12410, 280, 300, 310, 320,   1,   1, { 12359, 7910, 11188, }, { 24, 1, 4, }, nil, nil, { 12694, }, },
	[16971] = { nil, 1,  2,  16971,  12775, 280, 305, 317, 330,   1,   1, { 12359, 12644, 8170, }, { 40, 6, 6, }, nil, nil, { 12823, }, },
	[16978] = { nil, 1,  2,  16978,  12777, 280, 305, 317, 330,   1,   1, { 12655, 7078, 7077, 12800, 12644, }, { 10, 4, 4, 2, 2, }, nil, nil, { 12825, }, nil, nil, nil, 17039, },
	[16652] = { nil, 1,  2,  16652,  12409, 280, 300, 310, 320,   1,   1, { 12359, 8170, 11185, }, { 20, 8, 4, }, nil, nil, { 12693, }, },
	[15296] = { nil, 1,  2,  15296,  11604, 285, 305, 315, 325,   1,   1, { 11371, 7077, }, { 20, 8, }, nil, nil, { 11612, }, nil, nil, nil, 9788, },
	[16667] = { nil, 1,  2,  16667,  12628, 285, 305, 315, 325,   1,   1, { 12359, 12662, 12361, 7910, }, { 40, 10, 4, 4, }, nil, nil, { 12696, }, nil, nil, nil, 9788, },
	[16983] = { nil, 1,  2,  16983,  12781, 285, 310, 322, 335,   1,   1, { 12655, 12360, 12804, 12799, 12361, 12364, }, { 6, 2, 4, 2, 2, 1, }, nil, nil, { 12827, }, nil, nil, nil, 17040, },
	[16654] = { nil, 1,  2,  16654,  12418, 285, 305, 315, 325,   1,   1, { 12359, 7077, }, { 18, 4, }, nil, nil, { 12695, }, },
	[16660] = { nil, 1,  2,  16660,  12625, 290, 310, 320, 330,   1,   1, { 12359, 12360, 12364, 7080, }, { 20, 4, 2, 2, }, nil, nil, { 12698, }, },
	[23632] = { nil, 3,  2,  23632,  19051, 290, 310, 320, 330,   1,   1, { 12359, 6037, 12811, }, { 8, 6, 1, }, nil, nil, { 19203, }, },
	[16984] = { nil, 1,  2,  16984,  12792, 290, 315, 327, 340,   1,   1, { 12359, 7077, 7910, 8170, }, { 30, 4, 4, 4, }, nil, nil, { 12828, }, },
	[16656] = { nil, 1,  2,  16656,  12419, 290, 310, 320, 330,   1,   1, { 12359, 7077, }, { 14, 4, }, nil, nil, { 12697, }, },
	[16655] = { nil, 1,  2,  16655,  12631, 290, 310, 320, 330,   1,   1, { 12359, 12655, 7078, 7910, }, { 20, 6, 2, 4, }, nil, nil, { 12699, }, nil, nil, nil, 9788, },
	[23628] = { nil, 3,  2,  23628,  19043, 290, 310, 320, 330,   1,   1, { 12359, 7076, 12803, }, { 12, 3, 3, }, nil, nil, { 19202, }, },
	[16985] = { nil, 1,  2,  16985,  12782, 290, 315, 327, 340,   1,   1, { 12359, 12360, 12662, 12808, 12361, 12644, 8170, }, { 40, 2, 16, 8, 2, 2, 4, }, nil, nil, { 12830, }, nil, nil, nil, 17039, },
	[16658] = { nil, 1,  2,  16658,  12427, 295, 315, 325, 335,   1,   1, { 12359, 7910, }, { 34, 2, }, nil, nil, { 12701, }, },
	[16659] = { nil, 1,  2,  16659,  12417, 295, 315, 325, 335,   1,   1, { 12359, 7077, }, { 18, 4, }, nil, nil, { 12702, }, },
	[16661] = { nil, 1,  2,  16661,  12632, 295, 315, 325, 335,   1,   1, { 12359, 12655, 7080, 12361, }, { 20, 4, 4, 4, }, nil, nil, { 12703, }, nil, nil, nil, 9788, },
	[20874] = { nil, 1,  2,  20874,  17014, 295, 315, 325, 335,   1,   1, { 11371, 17010, 17011, }, { 4, 2, 2, }, nil, nil, { 17051, }, nil, nil, nil, 9788, },
	[20872] = { nil, 1,  2,  20872,  16989, 295, 315, 325, 335,   1,   1, { 11371, 17010, 17011, }, { 6, 3, 3, }, nil, nil, { 17049, }, nil, nil, nil, 9788, },
	[16657] = { nil, 1,  2,  16657,  12426, 295, 315, 325, 335,   1,   1, { 12359, 7910, 7909, }, { 34, 1, 1, }, nil, nil, { 12700, }, },
	[28461] = { nil, 6,  2,  28461,  22762, 300, 320, 330, 340,   1,   1, { 12655, 19726, 12360, 12803, }, { 12, 2, 2, 2, }, nil, nil, { 22766, }, },
	[23652] = { nil, 3,  2,  23652,  19168, 300, 320, 330, 340,   1,   1, { 17011, 17010, 12360, 11371, 12809, }, { 6, 6, 10, 6, 12, }, nil, nil, { 19211, }, nil, nil, nil, 17039, },
	[23650] = { nil, 3,  2,  23650,  19170, 300, 320, 330, 340,   1,   1, { 17011, 17010, 12360, 11371, 12800, }, { 4, 7, 12, 8, 4, }, nil, nil, { 19210, }, nil, nil, nil, 17040, },
	[28463] = { nil, 6,  2,  28463,  22764, 300, 320, 330, 340,   1,   1, { 12655, 12803, }, { 6, 2, }, nil, nil, { 22768, }, },
	[16993] = { nil, 1,  2,  16993,  12794, 300, 320, 330, 340,   1,   1, { 12655, 12364, 12799, 7076, 12810, }, { 20, 8, 8, 6, 4, }, nil, nil, { 12837, }, nil, nil, nil, 17040, },
	[22757] = { nil, 1,  2,  22757,  18262, 300, 300, 310, 320,   1,   1, { 7067, 12365, }, { 2, 3, }, nil, nil, { 18264, }, },
	[16988] = { nil, 1,  2,  16988,  12796, 300, 320, 330, 340,   1,   1, { 12359, 12360, 12809, 12810, 7076, }, { 50, 15, 4, 6, 10, }, nil, nil, { 12833, }, nil, nil, nil, 17040, },
	[28244] = { nil, 6,  2,  28244,  22671, 300, 320, 330, 340,   1,   1, { 22682, 12359, 12360, 7080, }, { 4, 12, 2, 2, }, true, 0, nil, { 9233, }, },
	[16742] = { nil, 2,  2,  16742,  12620, 300, 320, 330, 340,   1,   1, { 12360, 12655, 7076, 12799, 12800, }, { 6, 16, 6, 2, 1, }, nil, nil, { 12725, }, nil, nil, nil, 9788, },
	[27585] = { nil, 5,  2,  27585,  22197, 300, 320, 330, 340,   1,   1, { 22202, 12655, 7076, }, { 14, 4, 2, }, nil, nil, { 22209, }, },
	[27830] = { nil, 5,  2,  27830,  22384, 300, 320, 330, 340,   1,   1, { 12360, 11371, 12808, 20520, 15417, 12753, }, { 15, 10, 20, 20, 10, 2, }, nil, nil, { 22390, }, nil, nil, nil, 17040, },
	[16732] = { nil, 1,  2,  16732,  12614, 300, 320, 330, 340,   1,   1, { 12359, 12360, 7910, }, { 40, 2, 1, }, nil, nil, { 12719, }, },
	[27832] = { nil, 5,  2,  27832,  22383, 300, 320, 330, 340,   1,   1, { 12360, 20725, 13512, 12810, }, { 12, 2, 2, 4, }, nil, nil, { 22389, }, nil, nil, nil, 17039, },
	[16741] = { nil, 1,  2,  16741,  12639, 300, 320, 330, 340,   1,   1, { 12360, 12655, 7076, 12361, 12799, }, { 15, 20, 10, 4, 4, }, nil, nil, { 12720, }, nil, nil, nil, 9788, },
	[16744] = { nil, 2,  2,  16744,  12619, 300, 320, 330, 340,   1,   1, { 12360, 12655, 7080, 12361, 12364, }, { 10, 20, 6, 2, 1, }, nil, nil, { 12726, }, nil, nil, nil, 9788, },
	[27587] = { nil, 5,  2,  27587,  22196, 300, 320, 330, 340,   1,   1, { 22203, 22202, 12655, 7076, 12364, }, { 18, 40, 12, 10, 4, }, nil, nil, { 22222, }, },
	[27588] = { nil, 5,  2,  27588,  22195, 300, 320, 330, 340,   1,   1, { 22202, 12810, }, { 14, 4, }, nil, nil, { 22214, }, },
	[16731] = { nil, 1,  2,  16731,  12613, 300, 320, 330, 340,   1,   1, { 12359, 12360, 7910, }, { 40, 2, 1, }, nil, nil, { 12718, }, },
	[16995] = { nil, 1,  2,  16995,  12783, 300, 320, 330, 340,   1,   1, { 12360, 12655, 12810, 7910, 12800, 12799, 12644, }, { 10, 10, 2, 6, 6, 6, 4, }, nil, nil, { 12839, }, nil, nil, nil, 9787, },
	[20890] = { nil, 1,  2,  20890,  17015, 300, 320, 330, 340,   1,   1, { 11371, 17010, 11382, 12810, }, { 16, 12, 2, 2, }, nil, nil, { 17059, }, nil, nil, nil, 17039, },
	[16729] = { nil, 1,  2,  16729,  12640, 300, 320, 330, 340,   1,   1, { 12359, 12360, 8146, 12361, 12800, }, { 80, 12, 40, 10, 4, }, nil, nil, { 12717, }, nil, nil, nil, 9788, },
	[27829] = { nil, 5,  2,  27829,  22385, 300, 320, 330, 340,   1,   1, { 12360, 12655, 7076, 13510, }, { 12, 20, 10, 2, }, nil, nil, { 22388, }, nil, nil, nil, 9788, },
	[16746] = { nil, 1,  2,  16746,  12641, 300, 320, 330, 340,   1,   1, { 12360, 12655, 12364, 12800, }, { 30, 30, 6, 6, }, nil, nil, { 12728, }, nil, nil, nil, 9788, },
	[20876] = { nil, 1,  2,  20876,  17013, 300, 320, 330, 340,   1,   1, { 11371, 17010, 17011, }, { 16, 4, 6, }, nil, nil, { 17052, }, nil, nil, nil, 9788, },
	[23633] = { nil, 3,  2,  23633,  19057, 300, 320, 330, 340,   1,   1, { 12360, 6037, 12811, }, { 2, 10, 1, }, nil, nil, { 19205, }, },
	[23629] = { nil, 3,  2,  23629,  19048, 300, 320, 330, 340,   1,   1, { 12360, 7076, 12803, }, { 4, 6, 6, }, nil, nil, { 19204, }, },
	[20897] = { nil, 1,  2,  20897,  17016, 300, 320, 330, 340,   1,   1, { 11371, 17011, 11382, 12810, }, { 18, 12, 2, 2, }, nil, nil, { 17060, }, nil, nil, nil, 17041, },
	[16664] = { nil, 1,  2,  16664,  12610, 300, 320, 330, 340,   1,   1, { 12359, 12360, 3577, }, { 20, 2, 6, }, nil, nil, { 12706, }, },
	[24136] = { nil, 4,  2,  24136,  19690, 300, 320, 330, 340,   1,   1, { 12359, 19774, 19726, 7910, }, { 20, 10, 2, 2, }, nil, nil, { 19776, }, },
	[23636] = { nil, 3,  2,  23636,  19148, 300, 320, 330, 340,   1,   1, { 17011, 17010, 11371, }, { 4, 2, 4, }, nil, nil, { 19206, }, nil, nil, nil, 9788, },
	[20873] = { nil, 1,  2,  20873,  16988, 300, 320, 330, 340,   1,   1, { 11371, 17010, 17011, }, { 16, 4, 5, }, nil, nil, { 17053, }, nil, nil, nil, 9788, },
	[21161] = { nil, 1,  2,  21161,  17193, 300, 325, 337, 350,   1,   1, { 17203, 11371, 12360, 7078, 11382, 17011, 17010, }, { 8, 20, 50, 25, 10, 10, 10, }, nil, nil, { 18592, }, },
	[23637] = { nil, 3,  2,  23637,  19164, 300, 320, 330, 340,   1,   1, { 17011, 17010, 17012, 11371, 11382, }, { 3, 5, 4, 4, 2, }, nil, nil, { 19207, }, nil, nil, nil, 9788, },
	[24141] = { nil, 4,  2,  24141,  19695, 300, 320, 330, 340,   1,   1, { 12359, 19774, 12799, }, { 16, 10, 1, }, nil, nil, { 19781, }, },
	[23653] = { nil, 3,  2,  23653,  19169, 300, 320, 330, 340,   1,   1, { 17011, 17010, 12360, 11371, 12364, }, { 8, 5, 10, 12, 4, }, nil, nil, { 19212, }, nil, nil, nil, 17041, },
	[16745] = { nil, 2,  2,  16745,  12618, 300, 320, 330, 340,   1,   1, { 12360, 12655, 7076, 7080, 12364, 12800, }, { 8, 24, 4, 4, 2, 2, }, nil, nil, { 12727, }, nil, nil, nil, 9788, },
	[16994] = { nil, 1,  2,  16994,  12784, 300, 320, 330, 340,   1,   1, { 12360, 12810, 12644, }, { 20, 6, 2, }, nil, nil, { 12838, }, nil, nil, nil, 17041, },
	[16728] = { nil, 1,  2,  16728,  12636, 300, 320, 330, 340,   1,   1, { 12359, 12655, 8168, 12799, 12364, }, { 40, 4, 60, 6, 2, }, nil, nil, { 12716, }, nil, nil, nil, 9788, },
	[16726] = { nil, 1,  2,  16726,  12612, 300, 320, 330, 340,   1,   1, { 12359, 12360, 6037, 12364, }, { 30, 2, 2, 1, }, nil, nil, { 12714, }, },
	[16725] = { nil, 1,  2,  16725,  12420, 300, 320, 330, 340,   1,   1, { 12359, 7077, }, { 20, 4, }, nil, nil, { 12713, }, },
	[16724] = { nil, 1,  2,  16724,  12633, 300, 320, 330, 340,   1,   1, { 12359, 12655, 6037, 3577, 12800, }, { 20, 4, 6, 6, 2, }, nil, nil, { 12711, }, nil, nil, nil, 9788, },
	[16991] = { nil, 1,  2,  16991,  12798, 300, 320, 330, 340,   1,   1, { 12359, 12360, 12808, 12364, 12644, 12810, }, { 40, 12, 10, 8, 2, 4, }, nil, nil, { 12835, }, nil, nil, nil, 17041, },
	[16662] = { nil, 1,  2,  16662,  12414, 300, 320, 330, 340,   1,   1, { 12359, 11186, }, { 26, 4, }, nil, nil, { 12704, }, },
	[16663] = { nil, 1,  2,  16663,  12422, 300, 320, 330, 340,   1,   1, { 12359, 7910, }, { 40, 2, }, nil, nil, { 12705, }, },
	[16990] = { nil, 1,  2,  16990,  12790, 300, 320, 330, 340,   1,   1, { 12360, 12800, 12811, 12799, 12810, 12644, }, { 15, 8, 1, 4, 8, 2, }, nil, nil, { 12834, }, nil, nil, nil, 17039, },
	[16992] = { nil, 1,  2,  16992,  12797, 300, 320, 330, 340,   1,   1, { 12360, 12361, 12800, 7080, 12644, 12810, }, { 18, 8, 8, 4, 2, 4, }, nil, nil, { 12836, }, nil, nil, nil, 17039, },
	[28243] = { nil, 6,  2,  28243,  22670, 300, 320, 330, 340,   1,   1, { 22682, 12359, 12360, 7080, }, { 5, 12, 2, 2, }, true, 0, nil, { 9233, }, },
	[24139] = { nil, 4,  2,  24139,  19693, 300, 320, 330, 340,   1,   1, { 12359, 19774, 12799, }, { 20, 14, 2, }, nil, nil, { 19779, }, },
	[28462] = { nil, 6,  2,  28462,  22763, 300, 320, 330, 340,   1,   1, { 12655, 19726, 12803, }, { 8, 1, 2, }, nil, nil, { 22767, }, },
	[24914] = { nil, 4,  2,  24914,  20550, 300, 320, 330, 340,   1,   1, { 12359, 20520, 6037, }, { 20, 10, 10, }, nil, nil, { 20554, }, },
	[24137] = { nil, 4,  2,  24137,  19691, 300, 320, 330, 340,   1,   1, { 12359, 19774, 19726, 7910, }, { 16, 8, 2, 1, }, nil, nil, { 19777, }, },
	[16730] = { nil, 1,  2,  16730,  12429, 300, 320, 330, 340,   1,   1, { 12359, 7910, }, { 44, 2, }, nil, nil, { 12715, }, },
	[24138] = { nil, 4,  2,  24138,  19692, 300, 320, 330, 340,   1,   1, { 12359, 19774, 19726, 12810, }, { 12, 6, 2, 4, }, nil, nil, { 19778, }, },
	[23638] = { nil, 3,  2,  23638,  19166, 300, 320, 330, 340,   1,   1, { 17011, 17010, 12360, 11382, 11371, }, { 3, 6, 12, 1, 4, }, nil, nil, { 19208, }, nil, nil, nil, 9787, },
	[27586] = { nil, 5,  2,  27586,  22198, 300, 320, 330, 340,   1,   1, { 22203, 22202, 12655, 7076, }, { 8, 24, 8, 4, }, nil, nil, { 22219, }, },
	[27589] = { nil, 5,  2,  27589,  22194, 300, 320, 330, 340,   1,   1, { 22203, 22202, 12810, 13512, }, { 8, 24, 8, 1, }, nil, nil, { 22220, }, },
	[24140] = { nil, 4,  2,  24140,  19694, 300, 320, 330, 340,   1,   1, { 12359, 19774, 12799, }, { 18, 12, 2, }, nil, nil, { 19780, }, },
	[24913] = { nil, 4,  2,  24913,  20551, 300, 320, 330, 340,   1,   1, { 12359, 20520, 6037, 11754, }, { 16, 8, 8, 1, }, nil, nil, { 20555, }, },
	[28242] = { nil, 6,  2,  28242,  22669, 300, 320, 330, 340,   1,   1, { 22682, 12359, 12360, 7080, }, { 7, 16, 2, 4, }, true, 0, nil, { 9233, }, },
	[16665] = { nil, 1,  2,  16665,  12611, 300, 320, 330, 340,   1,   1, { 12359, 12360, 2842, }, { 20, 2, 10, }, nil, nil, { 12707, }, },
	[24912] = { nil, 4,  2,  24912,  20549, 300, 320, 330, 340,   1,   1, { 12359, 20520, 6037, 12810, }, { 12, 6, 6, 2, }, nil, nil, { 20553, }, },
	[24399] = { nil, 3,  2,  24399,  20039, 300, 320, 330, 340,   1,   1, { 17011, 17010, 17012, 11371, }, { 3, 3, 4, 6, }, nil, nil, { 20040, }, nil, nil, nil, 9788, },
	[23639] = { nil, 3,  2,  23639,  19167, 300, 320, 330, 340,   1,   1, { 17011, 17010, 12360, 11371, }, { 5, 2, 16, 6, }, nil, nil, { 19209, }, nil, nil, nil, 9787, },
	[27590] = { nil, 5,  2,  27590,  22191, 300, 320, 330, 340,   1,   1, { 22203, 22202, 12810, 12809, 12800, }, { 15, 36, 12, 10, 4, }, nil, nil, { 22221, }, },
	[2881]  = { nil, 1,  3,   2881,   2318,   1,  20,  30,  40,   1,   1, { 2934, }, { 3, }, },
	[7126]  = { nil, 1,  3,   7126,   5957,   1,  40,  55,  70,   1,   1, { 2318, 2320, }, { 3, 1, }, },
	[9058]  = { nil, 1,  3,   9058,   7276,   1,  40,  55,  70,   1,   1, { 2318, 2320, }, { 2, 1, }, },
	[9059]  = { nil, 1,  3,   9059,   7277,   1,  40,  55,  70,   1,   1, { 2318, 2320, }, { 2, 3, }, },
	[2152]  = { nil, 1,  3,   2152,   2304,   1,  30,  45,  60,   1,   1, { 2318, }, { 1, }, },
	[2149]  = { nil, 1,  3,   2149,   2302,   1,  40,  55,  70,   1,   1, { 2318, 2320, }, { 2, 1, }, },
	[2153]  = { nil, 1,  3,   2153,   2303,  15,  45,  60,  75,   1,   1, { 2318, 2320, }, { 4, 1, }, true, 50, },
	[3753]  = { nil, 1,  3,   3753,   4237,  25,  55,  70,  85,   1,   1, { 2318, 2320, }, { 6, 1, }, true, 75, },
	[9060]  = { nil, 1,  3,   9060,   7278,  30,  60,  75,  90,   1,   1, { 2318, 2320, }, { 4, 2, }, true, 100, },
	[9062]  = { nil, 1,  3,   9062,   7279,  30,  60,  75,  90,   1,   1, { 2318, 2320, }, { 3, 4, }, true, 100, },
	[9064]  = { nil, 1,  3,   9064,   7280,  35,  65,  80,  95,   1,   1, { 2318, 2320, }, { 5, 5, }, nil, nil, { 7288, }, },
	[3816]  = { nil, 1,  3,   3816,   4231,  35,  55,  65,  75,   1,   1, { 783, 4289, }, { 1, 1, }, true, 50, },
	[2160]  = { nil, 1,  3,   2160,   2300,  40,  70,  85, 100,   1,   1, { 2318, 2320, }, { 8, 4, }, true, 100, },
	[5244]  = { nil, 1,  3,   5244,   5081,  40,  70,  85, 100,   1,   1, { 5082, 2318, 2320, }, { 3, 4, 1, }, nil, nil, { 5083, }, },
	[2161]  = { nil, 1,  3,   2161,   2309,  55,  85, 100, 115,   1,   1, { 2318, 2320, }, { 8, 5, }, true, 100, },
	[3756]  = { nil, 1,  3,   3756,   4239,  55,  85, 100, 115,   1,   1, { 2318, 2320, }, { 3, 2, }, true, 150, },
	[2163]  = { nil, 1,  3,   2163,   2311,  60,  90, 105, 120,   1,   1, { 2318, 2320, 2324, }, { 8, 2, 1, }, nil, nil, { 2407, }, },
	[2162]  = { nil, 1,  3,   2162,   2310,  60,  90, 105, 120,   1,   1, { 2318, 2320, }, { 5, 2, }, true, 100, },
	[9065]  = { nil, 1,  3,   9065,   7281,  70, 100, 115, 130,   1,   1, { 2318, 2320, }, { 6, 4, }, true, 150, },
	[3759]  = { nil, 1,  3,   3759,   4242,  75, 105, 120, 135,   1,   1, { 4231, 2318, 2320, }, { 1, 6, 2, }, true, 200, },
	[2164]  = { nil, 1,  3,   2164,   2312,  75, 105, 120, 135,   1,   1, { 4231, 2318, 2320, }, { 1, 4, 2, }, nil, nil, { 2408, }, },
	[3763]  = { nil, 1,  3,   3763,   4246,  80, 110, 125, 140,   1,   1, { 2318, 2320, }, { 6, 2, }, true, 300, },
	[2159]  = { nil, 1,  3,   2159,   2308,  85, 105, 120, 135,   1,   1, { 2318, 2321, }, { 10, 2, }, true, 250, },
	[3761]  = { nil, 1,  3,   3761,   4243,  85, 115, 130, 145,   1,   1, { 4231, 2318, 2320, }, { 3, 6, 4, }, true, 350, },
	[8322]  = { nil, 1,  3,   8322,   6709,  90, 115, 130, 145,   1,   1, { 2318, 4231, 2320, 5498, }, { 6, 1, 4, 1, }, nil, nil, { 6710, }, },
	[2158]  = { nil, 1,  3,   2158,   2307,  90, 120, 135, 150,   1,   1, { 2318, 2320, }, { 7, 2, }, nil, nil, { 2406, }, },
	[7953]  = { nil, 1,  3,   7953,   6466,  90, 120, 135, 150,   1,   1, { 6470, 4231, 2321, }, { 8, 1, 1, }, nil, nil, { 6474, }, },
	[6702]  = { nil, 1,  3,   6702,   5780,  90, 120, 135, 150,   1,   1, { 5784, 2318, 2321, }, { 8, 6, 1, }, nil, nil, { 5786, }, },
	[6703]  = { nil, 1,  3,   6703,   5781,  95, 125, 140, 155,   1,   1, { 5784, 4231, 2318, 2321, }, { 12, 1, 8, 1, }, nil, nil, { 5787, }, },
	[9068]  = { nil, 1,  3,   9068,   7282,  95, 125, 140, 155,   1,   1, { 2318, 4231, 2321, }, { 10, 1, 1, }, true, 400, },
	[2167]  = { nil, 1,  3,   2167,   2315, 100, 125, 137, 150,   1,   1, { 2319, 2321, 4340, }, { 4, 2, 1, }, true, 350, },
	[3762]  = { nil, 1,  3,   3762,   4244, 100, 125, 137, 150,   1,   1, { 4243, 4231, 2320, }, { 1, 2, 2, }, nil, nil, { 4293, }, },
	[2169]  = { nil, 1,  3,   2169,   2317, 100, 125, 137, 150,   1,   1, { 2319, 2321, 4340, }, { 6, 1, 1, }, nil, nil, { 2409, }, },
	[20648] = { nil, 1,  3,  20648,   2319, 100, 100, 105, 110,   1,   1, { 2318, }, { 4, }, true, 500, },
	[9070]  = { nil, 1,  3,   9070,   7283, 100, 125, 137, 150,   1,   1, { 7286, 2319, 2321, }, { 12, 4, 1, }, nil, nil, { 7289, }, },
	[3817]  = { nil, 1,  3,   3817,   4233, 100, 115, 122, 130,   1,   1, { 4232, 4289, }, { 1, 1, }, true, 200, },
	[24940] = { nil, 1,  3,  24940,  20575, 100, 125, 137, 150,   1,   1, { 2319, 7286, 4231, 2321, }, { 8, 8, 1, 2, }, nil, nil, { 20576, }, },
	[2165]  = { nil, 1,  3,   2165,   2313, 100, 115, 122, 130,   1,   1, { 2319, 2320, }, { 4, 1, }, true, 250, },
	[7133]  = { nil, 1,  3,   7133,   5958, 105, 130, 142, 155,   1,   1, { 2319, 2997, 2321, }, { 8, 1, 1, }, nil, nil, { 5972, }, },
	[7954]  = { nil, 1,  3,   7954,   6467, 105, 130, 142, 155,   1,   1, { 6471, 6470, 2321, }, { 2, 6, 2, }, nil, nil, { 6475, }, },
	[2168]  = { nil, 1,  3,   2168,   2316, 110, 135, 147, 160,   1,   1, { 2319, 2321, 4340, }, { 8, 1, 1, }, true, 350, },
	[7135]  = { nil, 1,  3,   7135,   5961, 115, 140, 152, 165,   1,   1, { 2319, 4340, 2321, }, { 12, 1, 1, }, true, 400, },
	[7955]  = { nil, 1,  3,   7955,   6468, 115, 140, 152, 165,   1,   1, { 6471, 6470, 2321, }, { 10, 10, 2, }, nil, nil, { 6476, }, },
	[3765]  = { nil, 1,  3,   3765,   4248, 120, 155, 167, 180,   1,   1, { 2312, 4233, 2321, 4340, }, { 1, 1, 1, 1, }, nil, nil, { 7360, }, },
	[2166]  = { nil, 1,  3,   2166,   2314, 120, 145, 157, 170,   1,   1, { 2319, 4231, 2321, }, { 10, 2, 2, }, true, 450, },
	[9074]  = { nil, 1,  3,   9074,   7285, 120, 145, 157, 170,   1,   1, { 2457, 2319, 2321, }, { 1, 6, 1, }, true, 500, },
	[3767]  = { nil, 1,  3,   3767,   4250, 120, 145, 157, 170,   1,   1, { 2319, 3383, 2321, }, { 8, 1, 2, }, nil, nil, { 4294, }, },
	[9072]  = { nil, 1,  3,   9072,   7284, 120, 145, 157, 170,   1,   1, { 7287, 2319, 2321, }, { 6, 4, 1, }, nil, nil, { 7290, }, },
	[9145]  = { nil, 1,  3,   9145,   7348, 125, 150, 162, 175,   1,   1, { 2319, 5116, 2321, }, { 8, 4, 2, }, true, 500, },
	[3766]  = { nil, 1,  3,   3766,   4249, 125, 150, 162, 175,   1,   1, { 4246, 4233, 2321, 4340, }, { 1, 1, 2, 1, }, true, 400, },
	[3768]  = { nil, 1,  3,   3768,   4251, 130, 155, 167, 180,   1,   1, { 4233, 2319, 2321, }, { 1, 4, 1, }, true, 500, },
	[3770]  = { nil, 1,  3,   3770,   4253, 135, 160, 172, 185,   1,   1, { 2319, 4233, 3389, 3182, 2321, }, { 4, 2, 2, 2, 2, }, true, 500, },
	[9146]  = { nil, 1,  3,   9146,   7349, 135, 160, 172, 185,   1,   1, { 2319, 3356, 2321, }, { 8, 4, 2, }, nil, nil, { 7361, }, },
	[9147]  = { nil, 1,  3,   9147,   7352, 135, 160, 172, 185,   1,   1, { 2319, 7067, 2321, }, { 6, 1, 2, }, nil, nil, { 7362, }, },
	[3769]  = { nil, 1,  3,   3769,   4252, 140, 165, 177, 190,   1,   1, { 2319, 3390, 4340, 2321, }, { 12, 1, 1, 2, }, nil, nil, { 4296, }, },
	[9148]  = { nil, 1,  3,   9148,   7358, 140, 165, 177, 190,   1,   1, { 2319, 5373, 2321, }, { 10, 2, 2, }, nil, nil, { 7363, }, },
	[3764]  = { nil, 1,  3,   3764,   4247, 145, 170, 182, 195,   1,   1, { 2319, 2321, }, { 14, 4, }, true, 500, },
	[9149]  = { nil, 1,  3,   9149,   7359, 145, 170, 182, 195,   1,   1, { 2319, 7067, 2997, 2321, }, { 12, 2, 2, 2, }, nil, nil, { 7364, }, },
	[9194]  = { nil, 1,  3,   9194,   7372, 150, 170, 180, 190,   1,   1, { 4234, 2321, }, { 8, 2, }, true, 500, },
	[20649] = { nil, 1,  3,  20649,   4234, 150, 150, 155, 160,   1,   1, { 2319, }, { 5, }, true, 1000, },
	[23190] = { nil, 2,  3,  23190,  18662, 150, 150, 155, 160,   1,   1, { 4234, 2321, }, { 2, 1, }, nil, nil, { 18731, }, },
	[3771]  = { nil, 1,  3,   3771,   4254, 150, 170, 180, 190,   1,   1, { 4234, 5637, 2321, }, { 6, 2, 1, }, nil, nil, { 4297, }, },
	[3818]  = { nil, 1,  3,   3818,   4236, 150, 160, 165, 170,   1,   1, { 4235, 4289, }, { 1, 3, }, true, 500, },
	[3760]  = { nil, 1,  3,   3760,   3719, 150, 170, 180, 190,   1,   1, { 4234, 2321, }, { 5, 2, }, true, 600, },
	[9193]  = { nil, 1,  3,   9193,   7371, 150, 170, 180, 190,   1,   1, { 4234, 2321, }, { 8, 2, }, true, 500, },
	[3780]  = { nil, 1,  3,   3780,   4265, 150, 170, 180, 190,   1,   1, { 4234, 2321, }, { 5, 1, }, true, 750, },
	[23399] = { nil, 1,  3,  23399,  18948, 155, 175, 185, 195,   1,   1, { 4234, 4236, 5498, 4461, 5637, }, { 8, 2, 4, 1, 4, }, nil, nil, { 18949, }, },
	[3772]  = { nil, 1,  3,   3772,   4255, 155, 175, 185, 195,   1,   1, { 4234, 2605, 2321, }, { 9, 2, 4, }, nil, nil, { 7613, }, },
	[7147]  = { nil, 1,  3,   7147,   5962, 160, 180, 190, 200,   1,   1, { 4234, 4305, 2321, }, { 12, 2, 2, }, true, 1000, },
	[3774]  = { nil, 1,  3,   3774,   4257, 160, 180, 190, 200,   1,   1, { 4236, 4234, 2321, 2605, 7071, }, { 1, 5, 1, 1, 1, }, true, 1000, },
	[4096]  = { nil, 1,  3,   4096,   4455, 165, 185, 195, 205,   1,   1, { 4461, 4234, 2321, }, { 6, 4, 2, }, nil, nil, { 13287, }, },
	[9195]  = { nil, 1,  3,   9195,   7373, 165, 185, 195, 205,   1,   1, { 4234, 2325, 2321, }, { 10, 1, 2, }, nil, nil, { 7449, }, },
	[4097]  = { nil, 1,  3,   4097,   4456, 165, 185, 195, 205,   1,   1, { 4461, 4234, 2321, }, { 4, 4, 2, }, nil, nil, { 13288, }, },
	[6704]  = { nil, 1,  3,   6704,   5782, 170, 190, 200, 210,   1,   1, { 5785, 4236, 4234, 2321, }, { 12, 1, 10, 3, }, nil, nil, { 5788, }, },
	[7149]  = { nil, 1,  3,   7149,   5963, 170, 190, 200, 210,   1,   1, { 4234, 2321, 1206, }, { 10, 2, 1, }, nil, nil, { 5973, }, },
	[3775]  = { nil, 1,  3,   3775,   4258, 170, 190, 200, 210,   1,   1, { 4236, 4234, 2321, 7071, }, { 2, 4, 1, 1, }, nil, nil, { 4298, }, },
	[7151]  = { nil, 1,  3,   7151,   5964, 175, 195, 205, 215,   1,   1, { 4234, 4236, 2321, }, { 8, 1, 2, }, true, 1200, },
	[9196]  = { nil, 1,  3,   9196,   7374, 175, 195, 205, 215,   1,   1, { 4234, 3824, 2321, }, { 10, 1, 2, }, true, 1500, },
	[9197]  = { nil, 1,  3,   9197,   7375, 175, 195, 205, 215,   1,   1, { 7392, 4234, 2321, }, { 4, 10, 2, }, nil, nil, { 7450, }, },
	[3773]  = { nil, 1,  3,   3773,   4256, 175, 195, 205, 215,   1,   1, { 4236, 4234, 3824, 2321, }, { 2, 12, 1, 2, }, nil, nil, { 4299, }, },
	[3776]  = { nil, 1,  3,   3776,   4259, 180, 200, 210, 220,   1,   1, { 4236, 4234, 2605, 2321, }, { 2, 6, 1, 1, }, true, 1200, },
	[9198]  = { nil, 1,  3,   9198,   7377, 180, 200, 210, 220,   1,   1, { 4234, 7067, 7070, 2321, }, { 6, 2, 2, 2, }, true, 2000, },
	[3778]  = { nil, 1,  3,   3778,   4262, 185, 205, 215, 225,   1,   1, { 4236, 5500, 1529, 3864, 2321, }, { 4, 2, 2, 1, 1, }, nil, nil, { 14635, }, },
	[9201]  = { nil, 1,  3,   9201,   7378, 185, 205, 215, 225,   1,   1, { 4234, 2325, 4291, }, { 16, 1, 2, }, true, 2000, },
	[7153]  = { nil, 1,  3,   7153,   5965, 185, 205, 215, 225,   1,   1, { 4234, 4305, 4291, }, { 14, 2, 2, }, nil, nil, { 5974, }, },
	[6661]  = { nil, 1,  3,   6661,   5739, 190, 210, 220, 230,   1,   1, { 4234, 2321, 7071, }, { 14, 2, 1, }, true, 2000, },
	[21943] = { nil, 1,  3,  21943,  17721, 190, 210, 220, 230,   1,   1, { 4234, 7067, 4291, }, { 8, 4, 1, }, nil, nil, { 17722, }, },
	[6705]  = { nil, 1,  3,   6705,   5783, 190, 210, 220, 230,   1,   1, { 5785, 4236, 4234, 4291, }, { 16, 1, 14, 1, }, nil, nil, { 5789, }, },
	[9202]  = { nil, 1,  3,   9202,   7386, 190, 210, 220, 230,   1,   1, { 7392, 4234, 4291, }, { 6, 8, 2, }, nil, nil, { 7451, }, },
	[7156]  = { nil, 1,  3,   7156,   5966, 190, 210, 220, 230,   1,   1, { 4234, 4236, 4291, }, { 4, 1, 1, }, true, 2400, },
	[3777]  = { nil, 1,  3,   3777,   4260, 195, 215, 225, 235,   1,   1, { 4234, 4236, 4291, }, { 6, 2, 1, }, nil, nil, { 4300, }, },
	[9206]  = { nil, 1,  3,   9206,   7387, 195, 215, 225, 235,   1,   1, { 4234, 4305, 2325, 7071, }, { 10, 2, 2, 1, }, true, 2500, },
	[3779]  = { nil, 1,  3,   3779,   4264, 200, 220, 230, 240,   1,   1, { 4234, 4236, 4096, 5633, 4291, 7071, }, { 6, 2, 2, 1, 1, 1, }, nil, nil, { 4301, }, },
	[10490] = { nil, 1,  3,  10490,   8174, 200, 220, 230, 240,   1,   1, { 4234, 4236, 4291, }, { 12, 2, 2, }, nil, nil, { 8384, }, },
	[22711] = { nil, 2,  3,  22711,  18238, 200, 210, 220, 230,   1,   1, { 4304, 7428, 7971, 4236, 1210, 8343, }, { 6, 8, 2, 2, 4, 1, }, nil, nil, { 18239, }, },
	[10487] = { nil, 1,  3,  10487,   8173, 200, 220, 230, 240,   1,   1, { 4304, 4291, }, { 5, 1, }, true, 2000, },
	[9208]  = { nil, 1,  3,   9208,   7391, 200, 220, 230, 240,   1,   1, { 4234, 2459, 4337, 4291, }, { 10, 2, 2, 1, }, nil, nil, { 7453, }, },
	[9207]  = { nil, 1,  3,   9207,   7390, 200, 220, 230, 240,   1,   1, { 4234, 7428, 3824, 4291, }, { 8, 2, 1, 2, }, nil, nil, { 7452, }, },
	[10482] = { nil, 1,  3,  10482,   8172, 200, 200, 200, 200,   1,   1, { 8169, 8150, }, { 1, 1, }, true, 2000, },
	[20650] = { nil, 1,  3,  20650,   4304, 200, 200, 202, 205,   1,   1, { 4234, }, { 6, }, true, 4000, },
	[10499] = { nil, 1,  3,  10499,   8175, 205, 225, 235, 245,   1,   1, { 4304, 4291, }, { 7, 2, }, true, 3000, },
	[10509] = { nil, 1,  3,  10509,   8187, 205, 225, 235, 245,   1,   1, { 4304, 8167, 8343, }, { 6, 8, 1, }, nil, nil, { 8385, }, },
	[10507] = { nil, 1,  3,  10507,   8176, 205, 225, 235, 245,   1,   1, { 4304, 4291, }, { 5, 2, }, true, 3000, },
	[10518] = { nil, 1,  3,  10518,   8198, 210, 230, 240, 250,   1,   1, { 4304, 8167, 8343, }, { 8, 12, 1, }, true, 3500, },
	[10516] = { nil, 1,  3,  10516,   8192, 210, 230, 240, 250,   1,   1, { 4304, 4338, 4291, }, { 8, 6, 3, }, nil, nil, { 8409, }, },
	[10511] = { nil, 1,  3,  10511,   8189, 210, 230, 240, 250,   1,   1, { 4304, 8167, 8343, }, { 6, 12, 1, }, true, 3000, },
	[10520] = { nil, 1,  3,  10520,   8200, 215, 235, 245, 255,   1,   1, { 4304, 8151, 8343, }, { 10, 4, 1, }, nil, nil, { 8386, }, },
	[10529] = { nil, 1,  3,  10529,   8210, 220, 240, 250, 260,   1,   1, { 4304, 8153, 8172, }, { 10, 1, 1, }, nil, nil, { 8403, }, },
	[10533] = { nil, 1,  3,  10533,   8205, 220, 240, 250, 260,   1,   1, { 4304, 8154, 4291, }, { 10, 4, 2, }, nil, nil, { 8397, }, },
	[10525] = { nil, 1,  3,  10525,   8203, 220, 240, 250, 260,   1,   1, { 4304, 8154, 4291, }, { 12, 12, 4, }, nil, nil, { 8395, }, },
	[10531] = { nil, 1,  3,  10531,   8201, 220, 240, 250, 260,   1,   1, { 4304, 8151, 8343, }, { 8, 6, 1, }, nil, nil, { 8387, }, },
	[14930] = { nil, 1,  3,  14930,   8217, 225, 245, 255, 265,   1,   1, { 4304, 8172, 8949, 4291, }, { 12, 1, 1, 4, }, true, 3600, },
	[10542] = { nil, 1,  3,  10542,   8204, 225, 245, 255, 265,   1,   1, { 4304, 8154, 4291, }, { 6, 8, 2, }, nil, nil, { 8398, }, },
	[10621] = { nil, 1,  3,  10621,   8345, 225, 245, 255, 265,   1,   1, { 4304, 8368, 8146, 8343, 8172, }, { 18, 2, 8, 4, 2, }, true, 9000, nil, nil, nil, nil, 10660, },
	[10544] = { nil, 1,  3,  10544,   8211, 225, 245, 255, 265,   1,   1, { 4304, 8153, 8172, }, { 12, 2, 1, }, nil, nil, { 8404, }, },
	[10619] = { nil, 1,  3,  10619,   8347, 225, 245, 255, 265,   1,   1, { 4304, 8165, 8343, 8172, }, { 24, 12, 4, 2, }, true, 9000, nil, nil, nil, nil, 10656, },
	[10546] = { nil, 1,  3,  10546,   8214, 225, 245, 255, 265,   1,   1, { 4304, 8153, 8172, }, { 10, 2, 1, }, nil, nil, { 8405, }, },
	[14932] = { nil, 1,  3,  14932,   8218, 225, 245, 255, 265,   1,   1, { 4304, 8172, 8951, 4291, }, { 10, 1, 1, 6, }, true, 3600, },
	[10630] = { nil, 1,  3,  10630,   8346, 230, 250, 260, 270,   1,   1, { 4304, 7079, 7075, 8172, 8343, }, { 20, 8, 2, 1, 4, }, true, 9000, nil, nil, nil, nil, 10658, },
	[10552] = { nil, 1,  3,  10552,   8191, 230, 250, 260, 270,   1,   1, { 4304, 8167, 8343, }, { 14, 24, 1, }, true, 4000, },
	[10558] = { nil, 1,  3,  10558,   8197, 235, 255, 265, 275,   1,   1, { 4304, 8343, }, { 16, 2, }, true, 4500, },
	[10554] = { nil, 1,  3,  10554,   8209, 235, 255, 265, 275,   1,   1, { 4304, 8154, 4291, }, { 12, 12, 6, }, nil, nil, { 8399, }, },
	[10548] = { nil, 1,  3,  10548,   8193, 230, 250, 260, 270,   1,   1, { 4304, 4291, }, { 14, 4, }, true, 4000, },
	[10556] = { nil, 1,  3,  10556,   8185, 235, 255, 265, 275,   1,   1, { 4304, 8167, 8343, }, { 14, 28, 1, }, true, 4500, },
	[10564] = { nil, 1,  3,  10564,   8207, 240, 260, 270, 280,   1,   1, { 4304, 8154, 8343, }, { 12, 16, 2, }, nil, nil, { 8400, }, },
	[10560] = { nil, 1,  3,  10560,   8202, 240, 260, 270, 280,   1,   1, { 4304, 8152, 8343, }, { 10, 6, 2, }, nil, nil, { 8389, }, },
	[10562] = { nil, 1,  3,  10562,   8216, 240, 260, 270, 280,   1,   1, { 4304, 8152, 8343, }, { 14, 4, 2, }, nil, nil, { 8390, }, },
	[10566] = { nil, 1,  3,  10566,   8213, 245, 265, 275, 285,   1,   1, { 4304, 8153, 8172, }, { 14, 4, 2, }, nil, nil, { 8406, }, },
	[10568] = { nil, 1,  3,  10568,   8206, 245, 265, 275, 285,   1,   1, { 4304, 8154, 8343, }, { 14, 8, 2, }, nil, nil, { 8401, }, },
	[10572] = { nil, 1,  3,  10572,   8212, 250, 270, 280, 290,   1,   1, { 4304, 8153, 8172, }, { 16, 6, 2, }, nil, nil, { 8407, }, },
	[10632] = { nil, 1,  3,  10632,   8348, 250, 270, 280, 290,   1,   1, { 4304, 7077, 7075, 8172, 8343, }, { 40, 8, 4, 2, 4, }, true, 0, nil, nil, nil, nil, 10658, },
	[10570] = { nil, 1,  3,  10570,   8208, 250, 270, 280, 290,   1,   1, { 4304, 8154, 8343, }, { 10, 20, 2, }, nil, nil, { 8402, }, },
	[10647] = { nil, 1,  3,  10647,   8349, 250, 270, 280, 290,   1,   1, { 4304, 8168, 7971, 8172, 8343, }, { 40, 40, 2, 4, 4, }, true, 5500, nil, nil, nil, nil, 10660, },
	[19047] = { nil, 1,  3,  19047,  15407, 250, 250, 255, 260,   1,   1, { 8171, 15409, }, { 1, 1, }, true, 5000, },
	[10574] = { nil, 1,  3,  10574,   8215, 250, 270, 280, 290,   1,   1, { 4304, 8153, 8172, }, { 16, 6, 2, }, nil, nil, { 8408, }, },
	[19058] = { nil, 1,  3,  19058,  15564, 250, 250, 260, 270,   1,   1, { 8170, }, { 5, }, true, 5000, },
	[22331] = { nil, 1,  3,  22331,   8170, 250, 250, 250, 250,   1,   1, { 4304, }, { 6, }, true, 5000, },
	[19048] = { nil, 1,  3,  19048,  15077, 255, 275, 285, 295,   1,   1, { 8170, 15408, 14341, }, { 4, 4, 1, }, nil, nil, { 15724, }, },
	[10650] = { nil, 1,  3,  10650,   8367, 255, 275, 285, 295,   1,   1, { 4304, 8165, 8343, 8172, }, { 40, 30, 4, 4, }, true, 0, nil, nil, nil, nil, 10656, },
	[19050] = { nil, 1,  3,  19050,  15045, 260, 280, 290, 300,   1,   1, { 8170, 15412, 14341, }, { 20, 25, 2, }, nil, nil, { 15726, }, nil, nil, nil, 10656, },
	[19049] = { nil, 1,  3,  19049,  15083, 260, 280, 290, 300,   1,   1, { 8170, 2325, 14341, }, { 8, 1, 1, }, nil, nil, { 15725, }, },
	[19053] = { nil, 1,  3,  19053,  15074, 265, 285, 295, 305,   1,   1, { 8170, 15423, 14341, }, { 6, 6, 1, }, nil, nil, { 15729, }, nil, nil, nil, 10660, },
	[19051] = { nil, 1,  3,  19051,  15076, 265, 285, 295, 305,   1,   1, { 8170, 15408, 14341, }, { 6, 6, 1, }, nil, nil, { 15727, }, },
	[19052] = { nil, 1,  3,  19052,  15084, 265, 285, 295, 305,   1,   1, { 8170, 2325, 14341, }, { 8, 1, 1, }, nil, nil, { 15728, }, },
	[19055] = { nil, 1,  3,  19055,  15091, 270, 290, 300, 310,   1,   1, { 8170, 14047, 14341, }, { 10, 6, 1, }, nil, nil, { 15731, }, },
	[19062] = { nil, 1,  3,  19062,  15067, 270, 290, 300, 310,   1,   1, { 8170, 15420, 1529, 14341, }, { 24, 80, 2, 1, }, nil, nil, { 15735, }, nil, nil, nil, 10660, },
	[19060] = { nil, 1,  3,  19060,  15046, 270, 290, 300, 310,   1,   1, { 8170, 15412, 14341, }, { 20, 25, 1, }, nil, nil, { 15733, }, nil, nil, nil, 10656, },
	[19059] = { nil, 1,  3,  19059,  15054, 270, 290, 300, 310,   1,   1, { 8170, 7078, 7075, 14341, }, { 6, 1, 1, 1, }, nil, nil, { 15732, }, nil, nil, nil, 10658, },
	[19061] = { nil, 1,  3,  19061,  15061, 270, 290, 300, 310,   1,   1, { 8170, 12803, 14341, }, { 12, 4, 1, }, nil, nil, { 15734, }, nil, nil, nil, 10658, },
	[19067] = { nil, 1,  3,  19067,  15057, 275, 295, 305, 315,   1,   1, { 8170, 7080, 7082, 14341, }, { 16, 2, 2, 1, }, nil, nil, { 15741, }, nil, nil, nil, 10658, },
	[19064] = { nil, 1,  3,  19064,  15078, 275, 295, 305, 315,   1,   1, { 8170, 15408, 14341, }, { 6, 8, 1, }, nil, nil, { 15738, }, },
	[19065] = { nil, 1,  3,  19065,  15092, 275, 295, 305, 315,   1,   1, { 8170, 7971, 14047, 14341, }, { 6, 1, 6, 1, }, nil, nil, { 15739, }, },
	[19063] = { nil, 1,  3,  19063,  15073, 275, 295, 305, 315,   1,   1, { 8170, 15423, 14341, }, { 4, 8, 1, }, nil, nil, { 15737, }, nil, nil, nil, 10660, },
	[19066] = { nil, 1,  3,  19066,  15071, 275, 295, 305, 315,   1,   1, { 8170, 15422, 14341, }, { 4, 6, 1, }, nil, nil, { 15740, }, nil, nil, nil, 10660, },
	[19068] = { nil, 1,  3,  19068,  15064, 275, 295, 305, 315,   1,   1, { 8170, 15419, 14341, }, { 28, 12, 1, }, nil, nil, { 20253, }, nil, nil, nil, 10660, },
	[19073] = { nil, 1,  3,  19073,  15072, 280, 300, 310, 320,   1,   1, { 8170, 15423, 14341, }, { 8, 8, 1, }, nil, nil, { 15746, }, nil, nil, nil, 10660, },
	[19072] = { nil, 1,  3,  19072,  15093, 280, 300, 310, 320,   1,   1, { 8170, 14047, 14341, }, { 12, 10, 1, }, nil, nil, { 15745, }, },
	[19071] = { nil, 1,  3,  19071,  15086, 280, 300, 310, 320,   1,   1, { 8170, 2325, 14341, }, { 12, 1, 1, }, nil, nil, { 15744, }, },
	[19070] = { nil, 1,  3,  19070,  15082, 280, 300, 310, 320,   1,   1, { 8170, 15408, 14341, }, { 6, 8, 1, }, nil, nil, { 15743, }, },
	[24655] = { nil, 1,  3,  24655,  20296, 280, 300, 310, 320,   1,   1, { 8170, 15412, 15407, 14341, }, { 20, 30, 1, 2, }, true, 0, nil, nil, nil, nil, 10656, },
	[19080] = { nil, 1,  3,  19080,  15065, 285, 305, 315, 325,   1,   1, { 8170, 15419, 14341, }, { 24, 14, 1, }, nil, nil, { 20254, }, nil, nil, nil, 10660, },
	[19074] = { nil, 1,  3,  19074,  15069, 285, 305, 315, 325,   1,   1, { 8170, 15422, 14341, }, { 6, 8, 1, }, nil, nil, { 15747, }, nil, nil, nil, 10660, },
	[19078] = { nil, 1,  3,  19078,  15060, 285, 305, 315, 325,   1,   1, { 8170, 12803, 15407, 14341, }, { 16, 6, 1, 1, }, nil, nil, { 15752, }, nil, nil, nil, 10658, },
	[19079] = { nil, 1,  3,  19079,  15056, 285, 305, 315, 325,   1,   1, { 8170, 7080, 7082, 15407, 14341, }, { 16, 3, 3, 1, 1, }, nil, nil, { 15753, }, nil, nil, nil, 10658, },
	[22815] = { nil, 1,  3,  22815,  18258, 285, 285, 290, 295,   1,   1, { 8170, 14048, 18240, 14341, }, { 4, 2, 1, 1, }, nil, nil, nil, { 5518, }, },
	[19076] = { nil, 1,  3,  19076,  15053, 285, 305, 315, 325,   1,   1, { 8170, 7078, 7076, 14341, }, { 8, 1, 1, 1, }, nil, nil, { 15749, }, nil, nil, nil, 10658, },
	[19077] = { nil, 1,  3,  19077,  15048, 285, 305, 315, 325,   1,   1, { 8170, 15415, 15407, 14341, }, { 28, 30, 1, 1, }, nil, nil, { 15751, }, nil, nil, nil, 10656, },
	[19075] = { nil, 1,  3,  19075,  15079, 285, 305, 315, 325,   1,   1, { 8170, 15408, 14341, }, { 8, 12, 1, }, nil, nil, { 15748, }, },
	[19086] = { nil, 1,  3,  19086,  15066, 290, 310, 320, 330,   1,   1, { 8170, 15420, 1529, 15407, 14341, }, { 40, 120, 1, 1, 1, }, nil, nil, { 15760, }, nil, nil, nil, 10660, },
	[19084] = { nil, 1,  3,  19084,  15063, 290, 310, 320, 330,   1,   1, { 8170, 15417, 14341, }, { 30, 8, 1, }, nil, nil, { 15758, }, nil, nil, nil, 10660, },
	[19081] = { nil, 1,  3,  19081,  15075, 290, 310, 320, 330,   1,   1, { 8170, 15423, 14341, }, { 10, 10, 1, }, nil, nil, { 15755, }, nil, nil, nil, 10660, },
	[23703] = { nil, 3,  3,  23703,  19044, 290, 310, 320, 330,   1,   1, { 8170, 12804, 12803, 15407, 14341, }, { 30, 2, 4, 2, 2, }, nil, nil, { 19326, }, },
	[23705] = { nil, 3,  3,  23705,  19052, 290, 310, 320, 330,   1,   1, { 8170, 12809, 7080, 15407, 14341, }, { 30, 2, 4, 2, 2, }, nil, nil, { 19328, }, },
	[19082] = { nil, 1,  3,  19082,  15094, 290, 310, 320, 330,   1,   1, { 8170, 14047, 14341, }, { 14, 10, 1, }, nil, nil, { 15756, }, },
	[19085] = { nil, 1,  3,  19085,  15050, 290, 310, 320, 330,   1,   1, { 8170, 15416, 15407, 14341, }, { 40, 60, 1, 2, }, nil, nil, { 15759, }, nil, nil, nil, 10656, },
	[19083] = { nil, 1,  3,  19083,  15087, 290, 310, 320, 330,   1,   1, { 8170, 15407, 2325, 14341, }, { 16, 1, 3, 1, }, nil, nil, { 15757, }, },
	[20853] = { nil, 1,  3,  20853,  16982, 295, 315, 325, 335,   1,   1, { 17012, 17010, 17011, 14341, }, { 20, 6, 2, 2, }, nil, nil, { 17022, }, nil, nil, nil, 10660, },
	[19088] = { nil, 1,  3,  19088,  15080, 295, 315, 325, 335,   1,   1, { 8170, 15408, 15407, 14341, }, { 8, 12, 1, 1, }, nil, nil, { 15762, }, },
	[19089] = { nil, 1,  3,  19089,  15049, 295, 315, 325, 335,   1,   1, { 8170, 15415, 12810, 15407, 14341, }, { 28, 30, 2, 1, 1, }, nil, nil, { 15763, }, nil, nil, nil, 10656, },
	[19090] = { nil, 1,  3,  19090,  15058, 295, 315, 325, 335,   1,   1, { 8170, 7080, 7082, 12810, 14341, }, { 12, 3, 3, 2, 1, }, nil, nil, { 15764, }, nil, nil, nil, 10658, },
	[19087] = { nil, 1,  3,  19087,  15070, 295, 315, 325, 335,   1,   1, { 8170, 15422, 14341, }, { 6, 10, 1, }, nil, nil, { 15761, }, nil, nil, nil, 10660, },
	[24846] = { nil, 5,  3,  24846,  20481, 300, 320, 330, 340,   1,   1, { 20500, 20498, 7078, }, { 1, 20, 2, }, nil, nil, { 20506, }, },
	[19094] = { nil, 1,  3,  19094,  15051, 300, 320, 330, 340,   1,   1, { 8170, 15416, 12810, 15407, 14341, }, { 44, 45, 2, 1, 1, }, nil, nil, { 15770, }, nil, nil, nil, 10656, },
	[24121] = { nil, 4,  3,  24121,  19685, 300, 320, 330, 340,   1,   1, { 19767, 15407, 12803, 14341, }, { 14, 5, 4, 4, }, nil, nil, { 19769, }, },
	[19092] = { nil, 1,  3,  19092,  15088, 300, 320, 330, 340,   1,   1, { 8170, 2325, 14341, }, { 14, 2, 2, }, nil, nil, { 15768, }, },
	[19100] = { nil, 1,  3,  19100,  15081, 300, 320, 330, 340,   1,   1, { 8170, 15408, 15407, 14341, }, { 14, 14, 1, 2, }, nil, nil, { 15774, }, },
	[23708] = { nil, 3,  3,  23708,  19157, 300, 320, 330, 340,   1,   1, { 17010, 17011, 17012, 12607, 15407, 14227, }, { 5, 2, 4, 4, 4, 4, }, nil, nil, { 19331, }, nil, nil, nil, 10656, },
	[23706] = { nil, 3,  3,  23706,  19058, 300, 320, 330, 340,   1,   1, { 12810, 12803, 12809, 15407, 14341, }, { 8, 4, 4, 2, 2, }, nil, nil, { 19329, }, },
	[24850] = { nil, 5,  3,  24850,  20477, 300, 320, 330, 340,   1,   1, { 20501, 20498, 18512, 15407, }, { 2, 30, 2, 1, }, nil, nil, { 20510, }, },
	[19091] = { nil, 1,  3,  19091,  15095, 300, 320, 330, 340,   1,   1, { 8170, 14047, 12810, 14341, }, { 18, 12, 2, 1, }, nil, nil, { 15765, }, },
	[28219] = { nil, 6,  3,  28219,  22661, 300, 320, 330, 340,   1,   1, { 22682, 12810, 7080, 15407, 14227, }, { 7, 16, 2, 4, 4, }, true, 0, nil, { 9233, }, },
	[19098] = { nil, 1,  3,  19098,  15085, 300, 320, 330, 340,   1,   1, { 8170, 15407, 14256, 2325, 14341, }, { 20, 2, 6, 4, 2, }, nil, nil, { 15773, }, },
	[24848] = { nil, 5,  3,  24848,  20479, 300, 320, 330, 340,   1,   1, { 20500, 20498, 7078, 15407, }, { 3, 40, 2, 2, }, nil, nil, { 20508, }, },
	[24849] = { nil, 5,  3,  24849,  20476, 300, 320, 330, 340,   1,   1, { 20501, 20498, 18512, }, { 1, 20, 2, }, nil, nil, { 20509, }, },
	[24851] = { nil, 5,  3,  24851,  20478, 300, 320, 330, 340,   1,   1, { 20501, 20498, 18512, 15407, }, { 3, 40, 2, 2, }, nil, nil, { 20511, }, },
	[28220] = { nil, 6,  3,  28220,  22662, 300, 320, 330, 340,   1,   1, { 22682, 12810, 7080, 15407, 14227, }, { 5, 12, 2, 3, 4, }, true, 0, nil, { 9233, }, },
	[28224] = { nil, 6,  3,  28224,  22665, 300, 320, 330, 340,   1,   1, { 22682, 15408, 7080, 15407, 14227, }, { 4, 16, 2, 2, 4, }, true, 0, nil, { 9233, }, },
	[28472] = { nil, 6,  3,  28472,  22759, 300, 320, 330, 340,   1,   1, { 12810, 19726, 12803, 15407, }, { 12, 2, 2, 2, }, nil, nil, { 22771, }, },
	[28221] = { nil, 6,  3,  28221,  22663, 300, 320, 330, 340,   1,   1, { 22682, 12810, 7080, 15407, 14227, }, { 4, 12, 2, 2, 4, }, true, 0, nil, { 9233, }, },
	[28223] = { nil, 6,  3,  28223,  22666, 300, 320, 330, 340,   1,   1, { 22682, 15408, 7080, 15407, 14227, }, { 5, 16, 2, 3, 4, }, true, 0, nil, { 9233, }, },
	[28473] = { nil, 6,  3,  28473,  22760, 300, 320, 330, 340,   1,   1, { 12810, 18512, 12803, 15407, }, { 6, 2, 2, 2, }, nil, nil, { 22770, }, },
	[28222] = { nil, 6,  3,  28222,  22664, 300, 320, 330, 340,   1,   1, { 22682, 15408, 7080, 15407, 14227, }, { 7, 24, 2, 4, 4, }, true, 0, nil, { 9233, }, },
	[23704] = { nil, 3,  3,  23704,  19049, 300, 320, 330, 340,   1,   1, { 12810, 12804, 12803, 15407, 14227, }, { 8, 6, 6, 2, 2, }, nil, nil, { 19327, }, },
	[24703] = { nil, 5,  3,  24703,  20380, 300, 320, 330, 340,   1,   1, { 12810, 20381, 12803, 15407, 14227, }, { 12, 6, 4, 4, 6, }, nil, nil, { 20382, }, nil, nil, nil, 10656, },
	[24123] = { nil, 4,  3,  24123,  19687, 300, 320, 330, 340,   1,   1, { 19767, 15407, 12803, 14341, }, { 8, 3, 4, 3, }, nil, nil, { 19771, }, },
	[22727] = { nil, 1,  3,  22727,  18251, 300, 320, 330, 340,   1,   1, { 17012, 14341, }, { 3, 2, }, nil, nil, { 18252, }, },
	[23707] = { nil, 3,  3,  23707,  19149, 300, 320, 330, 340,   1,   1, { 17011, 15407, 14227, }, { 5, 4, 4, }, nil, nil, { 19330, }, },
	[20855] = { nil, 1,  3,  20855,  16984, 300, 320, 330, 340,   1,   1, { 12810, 15416, 17010, 17011, 14341, }, { 6, 30, 4, 3, 2, }, nil, nil, { 17025, }, nil, nil, nil, 10656, },
	[22928] = { nil, 2,  3,  22928,  18511, 300, 320, 330, 340,   1,   1, { 8170, 7082, 12753, 12809, 15407, 14341, }, { 30, 12, 4, 8, 4, 8, }, nil, nil, { 18519, }, nil, nil, nil, 10658, },
	[20854] = { nil, 1,  3,  20854,  16983, 300, 320, 330, 340,   1,   1, { 17012, 17010, 17011, 14341, }, { 15, 3, 6, 2, }, nil, nil, { 17023, }, nil, nil, nil, 10658, },
	[22926] = { nil, 2,  3,  22926,  18509, 300, 320, 330, 340,   1,   1, { 8170, 12607, 15416, 15414, 15407, 14341, }, { 30, 12, 30, 30, 5, 8, }, nil, nil, { 18517, }, nil, nil, nil, 10656, },
	[26279] = { nil, 5,  3,  26279,  21278, 300, 320, 330, 340,   1,   1, { 12810, 7080, 7082, 15407, 14227, }, { 6, 4, 4, 2, 2, }, nil, nil, { 21548, }, nil, nil, nil, 10658, },
	[22923] = { nil, 2,  3,  22923,  18508, 300, 320, 330, 340,   1,   1, { 8170, 18512, 15420, 15407, 14341, }, { 12, 8, 60, 4, 4, }, nil, nil, { 18516, }, },
	[22922] = { nil, 2,  3,  22922,  18506, 300, 320, 330, 340,   1,   1, { 8170, 7082, 11754, 15407, 14341, }, { 12, 6, 4, 2, 4, }, nil, nil, { 18515, }, },
	[24124] = { nil, 4,  3,  24124,  19688, 300, 320, 330, 340,   1,   1, { 19768, 19726, 15407, 14341, }, { 35, 2, 3, 3, }, nil, nil, { 19772, }, },
	[24847] = { nil, 5,  3,  24847,  20480, 300, 320, 330, 340,   1,   1, { 20500, 20498, 7078, 15407, }, { 2, 30, 2, 1, }, nil, nil, { 20507, }, },
	[24125] = { nil, 4,  3,  24125,  19689, 300, 320, 330, 340,   1,   1, { 19768, 19726, 15407, 14341, }, { 25, 2, 3, 3, }, nil, nil, { 19773, }, },
	[22921] = { nil, 2,  3,  22921,  18504, 300, 320, 330, 340,   1,   1, { 8170, 12804, 15407, 14341, }, { 12, 12, 2, 4, }, nil, nil, { 18514, }, },
	[24122] = { nil, 4,  3,  24122,  19686, 300, 320, 330, 340,   1,   1, { 19767, 15407, 12803, 14341, }, { 10, 4, 4, 3, }, nil, nil, { 19770, }, },
	[28474] = { nil, 5,  3,  28474,  22761, 300, 320, 330, 340,   1,   1, { 12810, 12803, 15407, }, { 4, 2, 1, }, nil, nil, { 22769, }, },
	[19102] = { nil, 1,  3,  19102,  15090, 300, 320, 330, 340,   1,   1, { 8170, 12810, 14047, 15407, 14341, }, { 22, 4, 16, 1, 2, }, nil, nil, { 15776, }, },
	[19101] = { nil, 1,  3,  19101,  15055, 300, 320, 330, 340,   1,   1, { 8170, 7078, 7076, 14341, }, { 10, 1, 1, 2, }, nil, nil, { 15775, }, nil, nil, nil, 10658, },
	[22927] = { nil, 2,  3,  22927,  18510, 300, 320, 330, 340,   1,   1, { 8170, 12803, 7080, 18512, 15407, 14341, }, { 30, 12, 10, 8, 3, 8, }, nil, nil, { 18518, }, nil, nil, nil, 10660, },
	[19093] = { nil, 1,  3,  19093,  15138, 300, 320, 330, 340,   1,   1, { 15410, 14044, 14341, }, { 1, 1, 1, }, nil, nil, nil, { 7493, 7497, }, },
	[19104] = { nil, 1,  3,  19104,  15068, 300, 320, 330, 340,   1,   1, { 8170, 15422, 15407, 14341, }, { 12, 12, 1, 2, }, nil, nil, { 15779, }, nil, nil, nil, 10660, },
	[19097] = { nil, 1,  3,  19097,  15062, 300, 320, 330, 340,   1,   1, { 8170, 15417, 15407, 14341, }, { 30, 14, 1, 1, }, nil, nil, { 15772, }, nil, nil, nil, 10660, },
	[19107] = { nil, 1,  3,  19107,  15052, 300, 320, 330, 340,   1,   1, { 8170, 15416, 12810, 15407, 14341, }, { 40, 60, 4, 1, 2, }, nil, nil, { 15781, }, nil, nil, nil, 10656, },
	[23710] = { nil, 3,  3,  23710,  19163, 300, 320, 330, 340,   1,   1, { 17010, 17011, 7076, 15407, 14227, }, { 2, 7, 6, 4, 4, }, nil, nil, { 19333, }, nil, nil, nil, 10658, },
	[19103] = { nil, 1,  3,  19103,  15096, 300, 320, 330, 340,   1,   1, { 8170, 12810, 14047, 15407, 14341, }, { 16, 4, 18, 1, 2, }, nil, nil, { 15777, }, },
	[19095] = { nil, 1,  3,  19095,  15059, 300, 320, 330, 340,   1,   1, { 8170, 12803, 14342, 15407, 14341, }, { 16, 8, 2, 1, 2, }, nil, nil, { 15771, }, nil, nil, nil, 10658, },
	[23709] = { nil, 3,  3,  23709,  19162, 300, 320, 330, 340,   1,   1, { 17010, 17012, 12810, 15407, 14227, }, { 8, 12, 10, 4, 4, }, nil, nil, { 19332, }, nil, nil, nil, 10660, },
	[19054] = { nil, 1,  3,  19054,  15047, 300, 320, 330, 340,   1,   1, { 8170, 15414, 14341, }, { 40, 30, 1, }, nil, nil, { 15730, }, nil, nil, nil, 10656, },
	[24654] = { nil, 1,  3,  24654,  20295, 300, 320, 330, 340,   1,   1, { 8170, 15415, 15407, 14341, }, { 28, 36, 2, 2, }, true, 0, nil, nil, nil, nil, 10656, },
	[7183]  = { nil, 1,  4,   7183,   5997,   1,  55,  75,  95,   1,   1, { 765, 3371, }, { 2, 1, }, },
	[2330]  = { nil, 1,  4,   2330,    118,   1,  55,  75,  95,   1,   1, { 2447, 765, 3371, }, { 1, 1, 1, }, },
	[2329]  = { nil, 1,  4,   2329,   2454,   1,  55,  75,  95,   1,   1, { 2449, 765, 3371, }, { 1, 1, 1, }, },
	[3170]  = { nil, 1,  4,   3170,   3382,  15,  60,  80, 100,   1,   1, { 2447, 2449, 3371, }, { 1, 2, 1, }, true, 50, },
	[2331]  = { nil, 1,  4,   2331,   2455,  25,  65,  85, 105,   1,   1, { 785, 765, 3371, }, { 1, 1, 1, }, true, 100, },
	[2332]  = { nil, 1,  4,   2332,   2456,  40,  70,  90, 110,   1,   1, { 785, 2447, 3371, }, { 2, 1, 1, }, true, 150, },
	[4508]  = { nil, 1,  4,   4508,   4596,  50,  80, 100, 120,   1,   1, { 3164, 2447, 3371, }, { 1, 1, 1, }, nil, nil, { 4597, }, },
	[2334]  = { nil, 1,  4,   2334,   2458,  50,  80, 100, 120,   1,   1, { 2449, 2447, 3371, }, { 2, 1, 1, }, true, 250, },
	[3230]  = { nil, 1,  4,   3230,   2457,  50,  80, 100, 120,   1,   1, { 2452, 765, 3371, }, { 1, 1, 1, }, nil, nil, { 2553, }, },
	[2337]  = { nil, 1,  4,   2337,    858,  55,  85, 105, 125,   1,   1, { 118, 2450, }, { 1, 1, }, true, 1000, },
	[6617]  = { nil, 1,  4,   6617,   5631,  60,  90, 110, 130,   1,   1, { 5635, 2450, 3371, }, { 1, 1, 1, }, nil, nil, { 5640, }, },
	[2335]  = { nil, 1,  4,   2335,   2459,  60,  90, 110, 130,   1,   1, { 2452, 2450, 3371, }, { 1, 1, 1, }, nil, nil, { 2555, }, },
	[7836]  = { nil, 1,  4,   7836,   6370,  80,  80,  90, 100,   1,   1, { 6358, 3371, }, { 2, 1, }, true, 250, },
	[8240]  = { nil, 1,  4,   8240,   6662,  90, 120, 140, 160,   1,   1, { 6522, 2449, 3371, }, { 1, 1, 1, }, nil, nil, { 6663, }, },
	[3171]  = { nil, 1,  4,   3171,   3383,  90, 120, 140, 160,   1,   1, { 785, 2450, 3371, }, { 1, 2, 1, }, true, 500, },
	[7179]  = { nil, 1,  4,   7179,   5996,  90, 120, 140, 160,   1,   1, { 3820, 6370, 3371, }, { 1, 2, 1, }, true, 450, },
	[7255]  = { nil, 1,  4,   7255,   6051, 100, 130, 150, 170,   1,   1, { 2453, 2452, 3371, }, { 1, 1, 1, }, nil, nil, { 6053, }, },
	[7841]  = { nil, 1,  4,   7841,   6372, 100, 130, 150, 170,   1,   1, { 2452, 6370, 3371, }, { 1, 1, 1, }, true, 1000, },
	[3172]  = { nil, 1,  4,   3172,   3384, 110, 135, 155, 175,   1,   1, { 785, 3355, 3371, }, { 3, 1, 1, }, nil, nil, { 3393, }, },
	[3447]  = { nil, 1,  4,   3447,    929, 110, 135, 155, 175,   1,   1, { 2453, 2450, 3372, }, { 1, 1, 1, }, true, 4000, },
	[3173]  = { nil, 1,  4,   3173,   3385, 120, 145, 165, 185,   1,   1, { 785, 3820, 3371, }, { 1, 1, 1, }, true, 1500, },
	[3174]  = { nil, 1,  4,   3174,   3386, 120, 145, 165, 185,   1,   1, { 1288, 2453, 3372, }, { 1, 1, 1, }, nil, nil, { 3394, }, },
	[3176]  = { nil, 1,  4,   3176,   3388, 125, 150, 170, 190,   1,   1, { 2453, 2450, 3372, }, { 2, 2, 1, }, true, 1500, },
	[7837]  = { nil, 1,  4,   7837,   6371, 130, 150, 160, 170,   1,   1, { 6359, 3371, }, { 2, 1, }, true, 1000, },
	[3177]  = { nil, 1,  4,   3177,   3389, 130, 155, 175, 195,   1,   1, { 3355, 3820, 3372, }, { 1, 1, 1, }, true, 2000, },
	[7256]  = { nil, 1,  4,   7256,   6048, 135, 160, 180, 200,   1,   1, { 3369, 3356, 3372, }, { 1, 1, 1, }, nil, nil, { 6054, }, },
	[2333]  = { nil, 1,  4,   2333,   3390, 140, 165, 185, 205,   1,   1, { 3355, 2452, 3372, }, { 1, 1, 1, }, nil, nil, { 3396, }, },
	[7845]  = { nil, 1,  4,   7845,   6373, 140, 165, 185, 205,   1,   1, { 6371, 3356, 3372, }, { 2, 1, 1, }, true, 3000, },
	[3188]  = { nil, 1,  4,   3188,   3391, 150, 175, 195, 215,   1,   1, { 2449, 3356, 3372, }, { 1, 1, 1, }, nil, nil, { 6211, }, },
	[6624]  = { nil, 1,  4,   6624,   5634, 150, 175, 195, 215,   1,   1, { 6370, 3820, 3372, }, { 2, 1, 1, }, nil, nil, { 5642, }, },
	[7181]  = { nil, 1,  4,   7181,   1710, 155, 175, 195, 215,   1,   1, { 3357, 3356, 3372, }, { 1, 1, 1, }, true, 5000, },
	[3452]  = { nil, 1,  4,   3452,   3827, 160, 180, 200, 220,   1,   1, { 3820, 3356, 3372, }, { 1, 1, 1, }, true, 5000, },
	[7257]  = { nil, 1,  4,   7257,   6049, 165, 210, 230, 250,   1,   1, { 4402, 6371, 3372, }, { 1, 1, 1, }, nil, nil, { 6055, }, },
	[3448]  = { nil, 1,  4,   3448,   3823, 165, 185, 205, 225,   1,   1, { 3818, 3355, 3372, }, { 1, 1, 1, }, true, 5000, },
	[3449]  = { nil, 1,  4,   3449,   3824, 165, 190, 210, 230,   1,   1, { 3818, 3369, 3372, }, { 4, 4, 1, }, nil, nil, { 6068, }, },
	[6618]  = { nil, 1,  4,   6618,   5633, 175, 195, 215, 235,   1,   1, { 5637, 3356, 3372, }, { 1, 1, 1, }, nil, nil, { 5643, }, },
	[3450]  = { nil, 1,  4,   3450,   3825, 175, 195, 215, 235,   1,   1, { 3355, 3821, 3372, }, { 1, 1, 1, }, true, 6000, { 3830, }, },
	[3451]  = { nil, 1,  4,   3451,   3826, 180, 200, 220, 240,   1,   1, { 3357, 2453, 3372, }, { 1, 1, 1, }, nil, nil, { 3831, }, },
	[11449] = { nil, 1,  4,  11449,   8949, 185, 205, 225, 245,   1,   1, { 3820, 3821, 3372, }, { 1, 1, 1, }, true, 6500, },
	[21923] = { nil, 1,  4,  21923,  17708, 190, 210, 230, 250,   1,   1, { 3819, 3358, 3372, }, { 2, 1, 1, }, nil, nil, { 17709, }, },
	[7258]  = { nil, 1,  4,   7258,   6050, 190, 205, 225, 245,   1,   1, { 3819, 3821, 3372, }, { 1, 1, 1, }, nil, nil, { 6056, }, },
	[7259]  = { nil, 1,  4,   7259,   6052, 190, 210, 230, 250,   1,   1, { 3357, 3820, 3372, }, { 1, 1, 1, }, nil, nil, { 6057, }, },
	[3453]  = { nil, 1,  4,   3453,   3828, 195, 215, 235, 255,   1,   1, { 3358, 3818, 3372, }, { 1, 1, 1, }, nil, nil, { 3832, }, },
	[11450] = { nil, 1,  4,  11450,   8951, 195, 215, 235, 255,   1,   1, { 3355, 3821, 3372, }, { 1, 1, 1, }, true, 7500, },
	[3454]  = { nil, 1,  4,   3454,   3829, 200, 220, 240, 260,   1,   1, { 3358, 3819, 3372, }, { 4, 2, 1, }, nil, nil, { 14634, }, },
	[12609] = { nil, 1,  4,  12609,  10592, 200, 220, 240, 260,   1,   1, { 3821, 3818, 3372, }, { 1, 1, 1, }, true, 8000, },
	[11448] = { nil, 1,  4,  11448,   6149, 205, 220, 240, 260,   1,   1, { 3358, 3821, 3372, }, { 1, 1, 1, }, true, 9000, },
	[11451] = { nil, 1,  4,  11451,   8956, 205, 220, 240, 260,   1,   1, { 4625, 3821, 8925, }, { 1, 1, 1, }, true, 8000, },
	[11452] = { nil, 1,  4,  11452,   9030, 210, 225, 245, 265,   1,   1, { 7067, 3821, 8925, }, { 1, 1, 1, }, nil, nil, nil, { 2203, 2501, }, },
	[11453] = { nil, 1,  4,  11453,   9036, 210, 225, 245, 265,   1,   1, { 3358, 8831, 8925, }, { 1, 1, 1, }, nil, nil, { 9293, }, },
	[11456] = { nil, 1,  4,  11456,   9061, 210, 225, 245, 265,   1,   1, { 4625, 9260, 3372, }, { 1, 1, 1, }, nil, nil, { 10644, }, },
	[4942]  = { nil, 1,  4,   4942,   4623, 215, 230, 250, 270,   1,   1, { 3858, 3821, 3372, }, { 1, 1, 1, }, nil, nil, { 4624, }, },
	[22808] = { nil, 1,  4,  22808,  18294, 215, 230, 250, 270,   1,   1, { 7972, 8831, 8925, }, { 1, 2, 1, }, true, 10000, },
	[11457] = { nil, 1,  4,  11457,   3928, 215, 230, 250, 270,   1,   1, { 8838, 3358, 8925, }, { 1, 1, 1, }, true, 10000, },
	[11459] = { nil, 1,  4,  11459,   9149, 225, 240, 260, 280,   1,   1, { 3575, 9262, 8831, 4625, }, { 4, 1, 4, 4, }, nil, nil, { 9303, }, },
	[11480] = { nil, 1,  4,  11480,   6037, 225, 240, 260, 280,   1,   1, { 3860, }, { 1, }, nil, nil, { 9305, }, },
	[11479] = { nil, 1,  4,  11479,   3577, 225, 240, 260, 280,   1,   1, { 3575, }, { 1, }, nil, nil, { 9304, }, },
	[11458] = { nil, 1,  4,  11458,   9144, 225, 240, 260, 280,   1,   1, { 8153, 8831, 8925, }, { 1, 1, 1, }, nil, nil, { 9294, }, },
	[11460] = { nil, 1,  4,  11460,   9154, 230, 245, 265, 285,   1,   1, { 8836, 8925, }, { 1, 1, }, true, 5000, },
	[15833] = { nil, 1,  4,  15833,  12190, 230, 245, 265, 285,   1,   1, { 8831, 8925, }, { 3, 1, }, true, 10000, },
	[11464] = { nil, 1,  4,  11464,   9172, 235, 250, 270, 290,   1,   1, { 8845, 8838, 8925, }, { 1, 1, 1, }, nil, nil, { 9295, }, },
	[11465] = { nil, 1,  4,  11465,   9179, 235, 250, 270, 290,   1,   1, { 8839, 3358, 8925, }, { 1, 1, 1, }, true, 12000, },
	[11461] = { nil, 1,  4,  11461,   9155, 235, 250, 270, 290,   1,   1, { 8839, 3821, 8925, }, { 1, 1, 1, }, true, 10000, },
	[11466] = { nil, 1,  4,  11466,   9088, 240, 255, 275, 295,   1,   1, { 8836, 8839, 8925, }, { 1, 1, 1, }, nil, nil, { 9296, }, },
	[11468] = { nil, 1,  4,  11468,   9197, 240, 255, 275, 295,   1,   1, { 8831, 8925, }, { 3, 1, }, nil, nil, { 9297, }, },
	[11467] = { nil, 1,  4,  11467,   9187, 240, 255, 275, 295,   1,   1, { 8838, 3821, 8925, }, { 1, 1, 1, }, true, 12000, },
	[11473] = { nil, 1,  4,  11473,   9210, 245, 260, 280, 300,   1,   1, { 8845, 4342, 8925, }, { 2, 1, 1, }, nil, nil, { 9302, }, },
	[11472] = { nil, 1,  4,  11472,   9206, 245, 260, 280, 300,   1,   1, { 8838, 8846, 8925, }, { 1, 1, 1, }, nil, nil, { 9298, }, },
	[11478] = { nil, 1,  4,  11478,   9233, 250, 265, 285, 305,   1,   1, { 8846, 8925, }, { 2, 1, }, true, 14000, },
	[3175]  = { nil, 1,  4,   3175,   3387, 250, 275, 295, 315,   1,   1, { 8839, 8845, 8925, }, { 2, 1, 1, }, nil, nil, { 3395, }, },
	[11477] = { nil, 1,  4,  11477,   9224, 250, 265, 285, 305,   1,   1, { 8846, 8845, 8925, }, { 1, 1, 1, }, nil, nil, { 9300, }, },
	[11476] = { nil, 1,  4,  11476,   9264, 250, 265, 285, 305,   1,   1, { 8845, 8925, }, { 3, 1, }, nil, nil, { 9301, }, },
	[26277] = { nil, 5,  4,  26277,  21546, 250, 265, 285, 305,   1,   1, { 6371, 4625, 8925, }, { 3, 3, 1, }, nil, nil, { 21547, }, },
	[17551] = { nil, 1,  4,  17551,  13423, 250, 250, 255, 260,   1,   1, { 13422, 3372, }, { 1, 1, }, true, 15000, },
	[17552] = { nil, 1,  4,  17552,  13442, 255, 270, 290, 310,   1,   1, { 8846, 8925, }, { 3, 1, }, nil, nil, { 13476, }, },
	[17553] = { nil, 1,  4,  17553,  13443, 260, 275, 295, 315,   1,   1, { 8838, 8839, 8925, }, { 2, 2, 1, }, nil, nil, { 13477, }, },
	[17554] = { nil, 1,  4,  17554,  13445, 265, 280, 300, 320,   1,   1, { 13423, 8838, 8925, }, { 2, 1, 1, }, nil, nil, { 13478, }, },
	[17555] = { nil, 1,  4,  17555,  13447, 270, 285, 305, 325,   1,   1, { 13463, 13466, 8925, }, { 1, 2, 1, }, nil, nil, { 13479, }, },
	[17556] = { nil, 1,  4,  17556,  13446, 275, 290, 310, 330,   1,   1, { 13464, 13465, 8925, }, { 2, 1, 1, }, nil, nil, { 13480, }, },
	[17557] = { nil, 1,  4,  17557,  13453, 275, 290, 310, 330,   1,   1, { 8846, 13466, 8925, }, { 2, 2, 1, }, nil, nil, { 13481, }, },
	[17559] = { nil, 1,  4,  17559,   7078, 275, 275, 282, 290,   1,   1, { 7082, }, { 1, }, nil, nil, { 13482, }, },
	[17560] = { nil, 1,  4,  17560,   7076, 275, 275, 282, 290,   1,   1, { 7078, }, { 1, }, nil, nil, { 13483, }, },
	[17561] = { nil, 1,  4,  17561,   7080, 275, 275, 282, 290,   1,   1, { 7076, }, { 1, }, nil, nil, { 13484, }, },
	[17562] = { nil, 1,  4,  17562,   7082, 275, 275, 282, 290,   1,   1, { 7080, }, { 1, }, nil, nil, { 13485, }, },
	[17563] = { nil, 1,  4,  17563,   7080, 275, 275, 282, 290,   1,   1, { 12808, }, { 1, }, nil, nil, { 13486, }, },
	[17564] = { nil, 1,  4,  17564,  12808, 275, 275, 282, 290,   1,   1, { 7080, }, { 1, }, nil, nil, { 13487, }, },
	[17565] = { nil, 1,  4,  17565,   7076, 275, 275, 282, 290,   1,   1, { 12803, }, { 1, }, nil, nil, { 13488, }, },
	[17566] = { nil, 1,  4,  17566,  12803, 275, 275, 282, 290,   1,   1, { 7076, }, { 1, }, nil, nil, { 13489, }, },
	[17187] = { nil, 1,  4,  17187,  12360, 275, 275, 282, 290,   1,   1, { 12359, 12363, }, { 1, 1, }, nil, nil, { 12958, }, },
	[24365] = { nil, 4,  4,  24365,  20007, 275, 290, 310, 330,   1,   1, { 13463, 13466, 8925, }, { 1, 2, 1, }, nil, nil, { 20011, }, },
	[24366] = { nil, 4,  4,  24366,  20002, 275, 290, 310, 330,   1,   1, { 13463, 13464, 8925, }, { 2, 1, 1, }, nil, nil, { 20012, }, },
	[17571] = { nil, 1,  4,  17571,  13452, 280, 295, 315, 335,   1,   1, { 13465, 13466, 8925, }, { 2, 2, 1, }, nil, nil, { 13491, }, },
	[17570] = { nil, 1,  4,  17570,  13455, 280, 295, 315, 335,   1,   1, { 13423, 10620, 8925, }, { 3, 1, 1, }, nil, nil, { 13490, }, },
	[24367] = { nil, 4,  4,  24367,  20008, 285, 300, 320, 340,   1,   1, { 13467, 13465, 10286, 8925, }, { 2, 2, 2, 1, }, nil, nil, { 20013, }, },
	[17572] = { nil, 1,  4,  17572,  13462, 285, 300, 320, 340,   1,   1, { 13467, 13466, 8925, }, { 2, 2, 1, }, nil, nil, { 13492, }, },
	[17573] = { nil, 1,  4,  17573,  13454, 285, 300, 320, 340,   1,   1, { 13463, 13465, 8925, }, { 3, 1, 1, }, nil, nil, { 13493, }, },
	[17575] = { nil, 1,  4,  17575,  13456, 290, 305, 325, 345,   1,   1, { 7070, 13463, 8925, }, { 1, 1, 1, }, nil, nil, { 13495, }, },
	[17577] = { nil, 1,  4,  17577,  13461, 290, 305, 325, 345,   1,   1, { 11176, 13463, 8925, }, { 1, 1, 1, }, nil, nil, { 13497, }, },
	[17578] = { nil, 1,  4,  17578,  13459, 290, 305, 325, 345,   1,   1, { 3824, 13463, 8925, }, { 1, 1, 1, }, nil, nil, { 13499, }, },
	[17574] = { nil, 1,  4,  17574,  13457, 290, 305, 325, 345,   1,   1, { 7068, 13463, 8925, }, { 1, 1, 1, }, nil, nil, { 13494, }, },
	[24368] = { nil, 4,  4,  24368,  20004, 290, 305, 325, 345,   1,   1, { 8846, 13466, 8925, }, { 1, 2, 1, }, nil, nil, { 20014, }, },
	[17576] = { nil, 1,  4,  17576,  13458, 290, 305, 325, 345,   1,   1, { 7067, 13463, 8925, }, { 1, 1, 1, }, nil, nil, { 13496, }, },
	[17580] = { nil, 1,  4,  17580,  13444, 295, 310, 330, 350,   1,   1, { 13463, 13467, 8925, }, { 3, 2, 1, }, nil, nil, { 13501, }, },
	[17634] = { nil, 1,  4,  17634,  13506, 300, 315, 322, 330,   1,   1, { 13423, 13465, 13468, 8925, }, { 30, 10, 1, 1, }, nil, nil, { 13518, }, },
	[17635] = { nil, 1,  4,  17635,  13510, 300, 315, 322, 330,   1,   1, { 8846, 13423, 13468, 8925, }, { 30, 10, 1, 1, }, nil, nil, { 13519, }, },
	[22732] = { nil, 1,  4,  22732,  18253, 300, 310, 320, 330,   1,   1, { 10286, 13464, 13463, 18256, }, { 1, 4, 4, 1, }, nil, nil, { 18257, }, },
	[17637] = { nil, 1,  4,  17637,  13512, 300, 315, 322, 330,   1,   1, { 13463, 13465, 13468, 8925, }, { 30, 10, 1, 1, }, nil, nil, { 13521, }, },
	[17636] = { nil, 1,  4,  17636,  13511, 300, 315, 322, 330,   1,   1, { 13463, 13467, 13468, 8925, }, { 30, 10, 1, 1, }, nil, nil, { 13520, }, },
	[25146] = { nil, 5,  4,  25146,   7068, 300, 301, 305, 310,   3,   3, { 7077, }, { 1, }, nil, nil, { 20761, }, },
	[24266] = { nil, 4,  4,  24266,  19931, 300, 315, 322, 330,   3,   3, { 12938, 19943, 12804, 13468, }, { 1, 1, 6, 1, }, nil, nil, nil, nil, 180368, },
	[17638] = { nil, 1,  4,  17638,  13513, 300, 315, 322, 330,   1,   1, { 13467, 13465, 13468, 8925, }, { 30, 10, 1, 1, }, nil, nil, { 13522, }, },
	[2540]  = { nil, 1,  6,   2540,   2681,   1,  45,  65,  85,   1,   1, { 769, }, { 1, }, },
	[7752]  = { nil, 1,  6,   7752,    787,   1,  45,  65,  85,   1,   1, { 6303, }, { 1, }, nil, nil, { 6326, }, },
	[7751]  = { nil, 1,  6,   7751,   6290,   1,  45,  65,  85,   1,   1, { 6291, }, { 1, }, nil, nil, { 6325, }, },
	[15935] = { nil, 1,  6,  15935,  12224,   1,  45,  65,  85,   1,   1, { 12223, 2678, }, { 1, 1, }, nil, nil, { 12226, }, },
	[21143] = { nil, 1,  6,  21143,  17197,   1,  45,  65,  85,   1,   1, { 6889, 17194, }, { 1, 1, }, nil, nil, { 17200, }, },
	[2538]  = { nil, 1,  6,   2538,   2679,   1,  45,  65,  85,   1,   1, { 2672, }, { 1, }, },
	[8604]  = { nil, 1,  6,   8604,   6888,   1,  45,  65,  85,   1,   1, { 6889, 2678, }, { 1, 1, }, },
	[2539]  = { nil, 1,  6,   2539,   2680,  10,  50,  70,  90,   1,   1, { 2672, 2678, }, { 1, 1, }, true, 50, },
	[6412]  = { nil, 1,  6,   6412,   5472,  10,  50,  70,  90,   1,   1, { 5465, }, { 1, }, nil, nil, { 5482, }, },
	[6413]  = { nil, 1,  6,   6413,   5473,  20,  60,  80, 100,   1,   1, { 5466, }, { 1, }, nil, nil, { 5483, }, },
	[2795]  = { nil, 1,  6,   2795,   2888,  25,  60,  80, 100,   1,   1, { 2886, 2894, }, { 1, 1, }, nil, nil, { 2889, }, },
	[6414]  = { nil, 1,  6,   6414,   5474,  35,  75,  95, 115,   2,   2, { 5467, 2678, }, { 1, 1, }, nil, nil, { 5484, }, },
	[21144] = { nil, 1,  6,  21144,  17198,  35,  75,  95, 115,   1,   1, { 6889, 1179, 17196, 17194, }, { 1, 1, 1, 1, }, nil, nil, { 17201, }, },
	[8607]  = { nil, 1,  6,   8607,   6890,  40,  80, 100, 120,   1,   1, { 3173, }, { 1, }, nil, nil, { 6892, }, },
	[2541]  = { nil, 1,  6,   2541,   2684,  50,  90, 110, 130,   1,   1, { 2673, }, { 1, }, true, 100, },
	[7754]  = { nil, 1,  6,   7754,   6316,  50,  90, 110, 130,   1,   1, { 6317, 2678, }, { 1, 1, }, nil, nil, { 6329, }, },
	[6416]  = { nil, 1,  6,   6416,   5477,  50,  90, 110, 130,   2,   2, { 5469, 4536, }, { 1, 1, }, nil, nil, { 5486, }, },
	[6415]  = { nil, 1,  6,   6415,   5476,  50,  90, 110, 130,   2,   2, { 5468, 2678, }, { 1, 1, }, nil, nil, { 5485, }, },
	[7753]  = { nil, 1,  6,   7753,   4592,  50,  90, 110, 130,   1,   1, { 6289, }, { 1, }, nil, nil, { 6328, }, },
	[7827]  = { nil, 1,  6,   7827,   5095,  50,  90, 110, 130,   1,   1, { 6361, }, { 1, }, nil, nil, { 6368, }, },
	[2542]  = { nil, 1,  6,   2542,    724,  50,  90, 110, 130,   1,   1, { 723, 2678, }, { 1, 1, }, nil, nil, { 2697, }, },
	[6499]  = { nil, 1,  6,   6499,   5525,  50,  90, 110, 130,   1,   1, { 5503, 159, }, { 1, 1, }, true, 100, },
	[9513]  = { nil, 1,  6,   9513,   7676,  60, 100, 120, 140,   1,   1, { 2452, 159, }, { 1, 1, }, nil, nil, { 18160, }, nil, nil, 8, },
	[3371]  = { nil, 1,  6,   3371,   3220,  60, 100, 120, 140,   2,   2, { 3173, 3172, 3174, }, { 1, 1, 1, }, nil, nil, { 3679, }, },
	[2543]  = { nil, 1,  6,   2543,    733,  75, 115, 135, 155,   1,   1, { 729, 730, 731, }, { 1, 1, 1, }, nil, nil, { 728, }, },
	[2544]  = { nil, 1,  6,   2544,   2683,  75, 115, 135, 155,   1,   1, { 2674, 2678, }, { 1, 1, }, true, 200, },
	[25704] = { nil, 1,  6,  25704,  21072,  80, 120, 140, 160,   1,   1, { 21071, 2678, }, { 1, 1, }, nil, nil, { 21099, }, },
	[3370]  = { nil, 1,  6,   3370,   3662,  80, 120, 140, 160,   1,   1, { 2924, 2678, }, { 1, 1, }, nil, nil, { 3678, }, },
	[2546]  = { nil, 1,  6,   2546,   2687,  80, 120, 140, 160,   1,   1, { 2677, 2678, }, { 1, 1, }, true, 150, },
	[8238]  = { nil, 1,  6,   8238,   6657,  85, 125, 145, 165,   1,   1, { 6522, 2678, }, { 1, 1, }, nil, nil, { 6661, }, },
	[2545]  = { nil, 1,  6,   2545,   2682,  85, 125, 145, 165,   1,   1, { 2675, 2678, }, { 1, 1, }, nil, nil, { 2698, }, },
	[3372]  = { nil, 1,  6,   3372,   3663,  90, 130, 150, 170,   1,   1, { 1468, 2692, }, { 2, 1, }, nil, nil, { 3680, }, },
	[6417]  = { nil, 1,  6,   6417,   5478,  90, 130, 150, 170,   2,   2, { 5051, }, { 1, }, nil, nil, { 5487, }, },
	[6501]  = { nil, 1,  6,   6501,   5526,  90, 130, 150, 170,   1,   1, { 5503, 1179, 2678, }, { 1, 1, 1, }, nil, nil, { 5528, }, },
	[2547]  = { nil, 1,  6,   2547,   1082, 100, 135, 155, 175,   1,   1, { 1081, 1080, }, { 1, 1, }, nil, nil, { 2699, }, },
	[7755]  = { nil, 1,  6,   7755,   4593, 100, 140, 160, 180,   1,   1, { 6308, }, { 1, }, nil, nil, { 6330, }, },
	[2549]  = { nil, 1,  6,   2549,   1017, 100, 140, 160, 180,   3,   3, { 1015, 2665, }, { 2, 1, }, nil, nil, { 2701, }, },
	[6418]  = { nil, 1,  6,   6418,   5479, 100, 140, 160, 180,   2,   2, { 5470, 2692, }, { 1, 1, }, nil, nil, { 5488, }, },
	[3397]  = { nil, 1,  6,   3397,   3726, 110, 150, 170, 190,   1,   1, { 3730, 2692, }, { 1, 1, }, nil, nil, { 3734, }, },
	[3377]  = { nil, 1,  6,   3377,   3666, 110, 150, 170, 190,   1,   1, { 2251, 2692, }, { 2, 1, }, nil, nil, { 3683, }, },
	[2548]  = { nil, 1,  6,   2548,   2685, 110, 130, 150, 170,   1,   1, { 2677, 2692, }, { 2, 1, }, nil, nil, { 2700, }, },
	[6419]  = { nil, 1,  6,   6419,   5480, 110, 150, 170, 190,   2,   2, { 5471, 2678, }, { 1, 4, }, nil, nil, { 5489, }, },
	[3373]  = { nil, 1,  6,   3373,   3664, 120, 160, 180, 200,   1,   1, { 3667, 2692, }, { 1, 1, }, nil, nil, { 3681, }, },
	[15853] = { nil, 1,  6,  15853,  12209, 125, 165, 185, 205,   1,   1, { 1015, 2678, }, { 1, 1, }, nil, nil, { 12227, }, },
	[13028] = { nil, 1,  6,  13028,  10841, 125, 215, 235, 255,   4,   4, { 3821, 159, }, { 1, 1, }, true, 0, },
	[3398]  = { nil, 1,  6,   3398,   3727, 125, 175, 195, 215,   1,   1, { 3731, 2692, }, { 1, 1, }, nil, nil, { 3735, }, },
	[6500]  = { nil, 1,  6,   6500,   5527, 125, 165, 185, 205,   1,   1, { 5504, 2692, }, { 1, 1, }, true, 300, },
	[3376]  = { nil, 1,  6,   3376,   3665, 130, 170, 190, 210,   1,   1, { 3685, 2692, }, { 1, 1, }, nil, nil, { 3682, }, },
	[24418] = { nil, 1,  6,  24418,  20074, 150, 160, 180, 200,   1,   1, { 3667, 3713, }, { 2, 1, }, nil, nil, { 20075, }, },
	[3399]  = { nil, 1,  6,   3399,   3728, 150, 190, 210, 230,   1,   1, { 3731, 3713, }, { 2, 1, }, nil, nil, { 3736, }, },
	[15865] = { nil, 1,  6,  15865,  12214, 175, 215, 235, 255,   1,   1, { 12037, 2596, }, { 1, 1, }, nil, nil, { 12233, }, },
	[15863] = { nil, 1,  6,  15863,  12213, 175, 215, 235, 255,   1,   1, { 12037, 2692, }, { 1, 1, }, nil, nil, { 12232, }, },
	[25954] = { nil, 1,  6,  25954,  21217, 175, 215, 235, 255,   1,   1, { 21153, 2692, }, { 1, 1, }, nil, nil, { 21219, }, },
	[4094]  = { nil, 1,  6,   4094,   4457, 175, 215, 235, 255,   1,   1, { 3404, 2692, }, { 1, 1, }, nil, nil, { 4609, }, },
	[20916] = { nil, 1,  6,  20916,   8364, 175, 215, 235, 255,   1,   1, { 8365, }, { 1, }, nil, nil, { 17062, }, },
	[3400]  = { nil, 1,  6,   3400,   3729, 175, 215, 235, 255,   1,   1, { 3712, 3713, }, { 1, 1, }, nil, nil, { 3737, }, },
	[7213]  = { nil, 1,  6,   7213,   6038, 175, 215, 235, 255,   1,   1, { 4655, 2692, }, { 1, 1, }, nil, nil, { 6039, }, },
	[7828]  = { nil, 1,  6,   7828,   4594, 175, 190, 210, 230,   1,   1, { 6362, }, { 1, }, nil, nil, { 6369, }, },
	[15855] = { nil, 1,  6,  15855,  12210, 175, 215, 235, 255,   1,   1, { 12184, 2692, }, { 1, 1, }, nil, nil, { 12228, }, },
	[15861] = { nil, 1,  6,  15861,  12212, 175, 215, 235, 255,   2,   2, { 12202, 159, 4536, }, { 1, 1, 2, }, nil, nil, { 12231, }, },
	[15856] = { nil, 1,  6,  15856,  13851, 175, 215, 235, 255,   1,   1, { 12203, 2692, }, { 1, 1, }, nil, nil, { 12229, }, },
	[21175] = { nil, 1,  6,  21175,  17222, 200, 240, 260, 280,   1,   1, { 12205, }, { 2, }, true, 4000, },
	[15910] = { nil, 1,  6,  15910,  12215, 200, 240, 260, 280,   2,   2, { 12204, 3713, 159, }, { 2, 1, 1, }, nil, nil, { 12240, }, },
	[15906] = { nil, 1,  6,  15906,  12217, 200, 240, 260, 280,   1,   1, { 12037, 4402, 2692, }, { 1, 1, 1, }, nil, nil, { 12239, }, },
	[15933] = { nil, 1,  6,  15933,  12218, 225, 265, 285, 305,   1,   1, { 12207, 3713, }, { 1, 2, }, nil, nil, { 16110, }, },
	[18241] = { nil, 1,  6,  18241,  13930, 225, 265, 285, 305,   1,   1, { 13758, }, { 1, }, nil, nil, { 13941, }, },
	[18238] = { nil, 1,  6,  18238,   6887, 225, 265, 285, 305,   1,   1, { 4603, }, { 1, }, nil, nil, { 13939, }, },
	[15915] = { nil, 1,  6,  15915,  12216, 225, 265, 285, 305,   1,   1, { 12206, 2692, }, { 1, 2, }, nil, nil, { 16111, }, },
	[22480] = { nil, 1,  6,  22480,  18045, 225, 265, 285, 305,   1,   1, { 12208, 3713, }, { 1, 1, }, nil, nil, { 18046, }, },
	[20626] = { nil, 1,  6,  20626,  16766, 225, 265, 285, 305,   2,   2, { 7974, 2692, 1179, }, { 2, 1, 1, }, nil, nil, { 16767, }, },
	[18239] = { nil, 1,  6,  18239,  13927, 225, 265, 285, 305,   1,   1, { 13754, 3713, }, { 1, 1, }, nil, nil, { 13940, }, },
	[18240] = { nil, 1,  6,  18240,  13928, 240, 280, 300, 320,   1,   1, { 13755, 3713, }, { 1, 1, }, nil, nil, { 13942, }, },
	[18242] = { nil, 1,  6,  18242,  13929, 240, 280, 300, 320,   1,   1, { 13756, 2692, }, { 1, 2, }, nil, nil, { 13943, }, },
	[18244] = { nil, 1,  6,  18244,  13932, 250, 290, 310, 330,   1,   1, { 13760, }, { 1, }, nil, nil, { 13946, }, },
	[18243] = { nil, 1,  6,  18243,  13931, 250, 290, 310, 330,   1,   1, { 13759, 159, }, { 1, 1, }, nil, nil, { 13945, }, },
	[18245] = { nil, 1,  6,  18245,  13933, 275, 315, 335, 355,   1,   1, { 13888, 159, }, { 1, 1, }, nil, nil, { 13947, }, },
	[22761] = { nil, 2,  6,  22761,  18254, 275, 315, 335, 355,   1,   1, { 18255, 3713, }, { 1, 1, }, nil, nil, { 18267, }, },
	[18247] = { nil, 1,  6,  18247,  13935, 275, 315, 335, 355,   1,   1, { 13889, 3713, }, { 1, 1, }, nil, nil, { 13949, }, },
	[18246] = { nil, 1,  6,  18246,  13934, 275, 315, 335, 355,   1,   1, { 13893, 2692, 3713, }, { 1, 1, 1, }, nil, nil, { 13948, }, },
	[24801] = { nil, 4,  6,  24801,  20452, 285, 325, 345, 365,   1,   1, { 20424, 3713, }, { 1, 1, }, nil, nil, nil, { 8313, }, },
	[25659] = { nil, 5,  6,  25659,  21023, 300, 325, 345, 365,   5,   5, { 2692, 9061, 8150, 21024, }, { 1, 1, 1, 1, }, nil, nil, { 21025, }, },
	[2657]  = { nil, 1,  7,   2657,   2840,   1,  25,  47,  70,   1,   1, { 2770, }, { 1, }, },
	[2659]  = { nil, 1,  7,   2659,   2841,  65,  65,  90, 115,   2,   2, { 2840, 3576, }, { 1, 1, }, true, 200, },
	[3304]  = { nil, 1,  7,   3304,   3576,  65,  65,  62,  75,   1,   1, { 2771, }, { 1, }, true, 50, },
	[2658]  = { nil, 1,  7,   2658,   2842,  75, 100, 112, 125,   1,   1, { 2775, }, { 1, }, true, 200, },
	[3307]  = { nil, 1,  7,   3307,   3575, 125, 130, 135, 140,   1,   1, { 2772, }, { 1, }, true, 500, },
	[3308]  = { nil, 1,  7,   3308,   3577, 155, 170, 177, 185,   1,   1, { 2776, }, { 1, }, true, 2500, },
	[3569]  = { nil, 1,  7,   3569,   3859, 165, 165, 165, 165,   1,   1, { 3575, 3857, }, { 1, 1, }, true, 2500, },
	[10097] = { nil, 1,  7,  10097,   3860, 175, 175, 175, 175,   1,   1, { 3858, }, { 1, }, true, 5000, },
	[10098] = { nil, 1,  7,  10098,   6037, 230, 230, 230, 230,   1,   1, { 7911, }, { 1, }, true, 10000, },
	[14891] = { nil, 1,  7,  14891,  11371, 230, 230, 230, 230,   1,   1, { 11370, }, { 8, }, nil, nil, nil, { 4083, }, },
	[16153] = { nil, 1,  7,  16153,  12359, 250, 250, 250, 250,   1,   1, { 10620, }, { 1, }, true, 20000, },
	[22967] = { nil, 3,  7,  22967,  17771, 300, 310, 315, 320,   1,   1, { 18562, 12360, 17010, 18567, }, { 1, 10, 1, 3, }, true, 0, },
	[2387]  = { nil, 1,  8,   2387,   2570,   1,  35,  47,  60,   1,   1, { 2996, 2320, }, { 1, 1, }, },
	[2393]  = { nil, 1,  8,   2393,   2576,   1,  35,  47,  60,   1,   1, { 2996, 2320, 2324, }, { 1, 1, 1, }, true, 25, },
	[2963]  = { nil, 1,  8,   2963,   2996,   1,  25,  37,  50,   1,   1, { 2589, }, { 2, }, },
	[12044] = { nil, 1,  8,  12044,  10045,   1,  35,  47,  60,   1,   1, { 2996, 2320, }, { 1, 1, }, },
	[3915]  = { nil, 1,  8,   3915,   4344,   1,  35,  47,  60,   1,   1, { 2996, 2320, }, { 1, 1, }, },
	[2385]  = { nil, 1,  8,   2385,   2568,  10,  45,  57,  70,   1,   1, { 2996, 2320, }, { 1, 1, }, true, 50, },
	[8776]  = { nil, 1,  8,   8776,   7026,  15,  50,  67,  85,   1,   1, { 2996, 2320, }, { 1, 1, }, true, 50, },
	[12045] = { nil, 1,  8,  12045,  10046,  20,  50,  67,  85,   1,   1, { 2996, 2318, 2320, }, { 2, 1, 1, }, true, 50, },
	[7624]  = { nil, 1,  8,   7624,   6241,  30,  55,  72,  90,   1,   1, { 2996, 2320, 2324, }, { 3, 1, 1, }, true, 50, },
	[7623]  = { nil, 1,  8,   7623,   6238,  30,  55,  72,  90,   1,   1, { 2996, 2320, }, { 3, 1, }, true, 50, },
	[3914]  = { nil, 1,  8,   3914,   4343,  30,  55,  72,  90,   1,   1, { 2996, 2320, }, { 2, 1, }, true, 50, },
	[3840]  = { nil, 1,  8,   3840,   4307,  35,  60,  77,  95,   1,   1, { 2996, 2320, }, { 2, 1, }, true, 100, },
	[2392]  = { nil, 1,  8,   2392,   2575,  40,  65,  82, 100,   1,   1, { 2996, 2320, 2604, }, { 2, 1, 1, }, true, 50, },
	[2394]  = { nil, 1,  8,   2394,   2577,  40,  65,  82, 100,   1,   1, { 2996, 2320, 6260, }, { 2, 1, 1, }, true, 50, },
	[8465]  = { nil, 1,  8,   8465,   6786,  40,  65,  82, 100,   1,   1, { 2996, 2320, 6260, 2324, }, { 2, 1, 1, 1, }, true, 50, },
	[2389]  = { nil, 1,  8,   2389,   2572,  40,  65,  82, 100,   1,   1, { 2996, 2320, 2604, }, { 3, 2, 2, }, nil, nil, { 2598, }, },
	[3755]  = { nil, 1,  8,   3755,   4238,  45,  70,  87, 105,   1,   1, { 2996, 2320, }, { 3, 3, }, true, 100, },
	[7629]  = { nil, 1,  8,   7629,   6239,  55,  80,  97, 115,   1,   1, { 2996, 2320, 2604, }, { 3, 1, 1, }, nil, nil, { 6271, }, },
	[7630]  = { nil, 1,  8,   7630,   6240,  55,  80,  97, 115,   1,   1, { 2996, 2320, 6260, }, { 3, 1, 1, }, nil, nil, { 6270, }, },
	[2397]  = { nil, 1,  8,   2397,   2580,  60,  85, 102, 120,   1,   1, { 2996, 2320, }, { 2, 3, }, true, 200, },
	[3841]  = { nil, 1,  8,   3841,   4308,  60,  85, 102, 120,   1,   1, { 2996, 2320, 2605, }, { 3, 2, 1, }, true, 200, },
	[2386]  = { nil, 1,  8,   2386,   2569,  65,  90, 107, 125,   1,   1, { 2996, 2320, 2318, }, { 3, 1, 1, }, true, 200, },
	[7633]  = { nil, 1,  8,   7633,   6242,  70,  95, 112, 130,   1,   1, { 2996, 2320, 6260, }, { 4, 2, 2, }, nil, nil, { 6272, }, },
	[2396]  = { nil, 1,  8,   2396,   2579,  70,  95, 112, 130,   1,   1, { 2996, 2321, 2605, }, { 3, 1, 1, }, true, 200, },
	[3842]  = { nil, 1,  8,   3842,   4309,  70,  95, 112, 130,   1,   1, { 2996, 2321, }, { 4, 2, }, true, 300, },
	[2395]  = { nil, 1,  8,   2395,   2578,  70,  95, 112, 130,   1,   1, { 2996, 2318, 2321, }, { 4, 1, 1, }, true, 300, },
	[6686]  = { nil, 1,  8,   6686,   5762,  70,  95, 112, 130,   1,   1, { 2996, 2321, 2604, }, { 4, 1, 1, }, nil, nil, { 5771, }, },
	[2964]  = { nil, 1,  8,   2964,   2997,  75,  90,  97, 105,   1,   1, { 2592, }, { 3, }, true, 100, },
	[2402]  = { nil, 1,  8,   2402,   2584,  75, 100, 117, 135,   1,   1, { 2997, 2321, }, { 1, 1, }, true, 250, },
	[12046] = { nil, 1,  8,  12046,  10047,  75, 100, 117, 135,   1,   1, { 2996, 2321, }, { 4, 1, }, true, 300, },
	[3845]  = { nil, 1,  8,   3845,   4312,  80, 105, 122, 140,   1,   1, { 2996, 2318, 2321, }, { 5, 2, 1, }, true, 300, },
	[3757]  = { nil, 1,  8,   3757,   4240,  80, 105, 122, 140,   1,   1, { 2997, 2321, }, { 3, 1, }, true, 200, },
	[2399]  = { nil, 1,  8,   2399,   2582,  85, 110, 127, 145,   1,   1, { 2997, 2321, 2605, }, { 2, 2, 1, }, true, 300, },
	[3843]  = { nil, 1,  8,   3843,   4310,  85, 110, 127, 145,   1,   1, { 2997, 2321, }, { 3, 1, }, true, 400, },
	[6521]  = { nil, 1,  8,   6521,   5542,  90, 115, 132, 150,   1,   1, { 2997, 2321, 5498, }, { 3, 2, 1, }, true, 400, },
	[3758]  = { nil, 1,  8,   3758,   4241,  95, 120, 137, 155,   1,   1, { 2997, 2605, 2321, }, { 4, 1, 1, }, nil, nil, { 4292, }, },
	[2401]  = { nil, 1,  8,   2401,   2583,  95, 120, 137, 155,   1,   1, { 2997, 2321, 2318, }, { 4, 2, 2, }, true, 300, },
	[3847]  = { nil, 1,  8,   3847,   4313,  95, 120, 137, 155,   1,   1, { 2997, 2318, 2321, 2604, }, { 4, 2, 1, 2, }, nil, nil, { 4345, }, },
	[3844]  = { nil, 1,  8,   3844,   4311, 100, 125, 142, 160,   1,   1, { 2997, 2321, 5498, }, { 3, 2, 2, }, nil, nil, { 4346, }, },
	[7639]  = { nil, 1,  8,   7639,   6263, 100, 125, 142, 160,   1,   1, { 2997, 2321, 6260, }, { 4, 2, 2, }, nil, nil, { 6274, }, },
	[2406]  = { nil, 1,  8,   2406,   2587, 100, 110, 120, 130,   1,   1, { 2997, 2321, 4340, }, { 2, 1, 1, }, true, 200, },
	[2403]  = { nil, 1,  8,   2403,   2585, 105, 130, 147, 165,   1,   1, { 2997, 2321, 4340, }, { 4, 3, 1, }, nil, nil, { 2601, }, },
	[3850]  = { nil, 1,  8,   3850,   4316, 110, 135, 152, 170,   1,   1, { 2997, 2321, }, { 5, 4, }, true, 500, },
	[3866]  = { nil, 1,  8,   3866,   4330, 110, 135, 152, 170,   1,   1, { 2997, 2604, 2321, }, { 3, 2, 1, }, true, 250, },
	[3848]  = { nil, 1,  8,   3848,   4314, 110, 135, 152, 170,   1,   1, { 2997, 2321, }, { 3, 2, }, true, 500, },
	[8467]  = { nil, 1,  8,   8467,   6787, 110, 135, 152, 170,   1,   1, { 2997, 2324, 2321, }, { 3, 4, 1, }, true, 250, },
	[7643]  = { nil, 1,  8,   7643,   6264, 115, 140, 157, 175,   1,   1, { 2997, 2321, 2604, }, { 5, 3, 3, }, nil, nil, { 6275, }, },
	[6688]  = { nil, 1,  8,   6688,   5763, 115, 140, 157, 175,   1,   1, { 2997, 2604, 2321, }, { 4, 1, 1, }, nil, nil, { 5772, }, },
	[12047] = { nil, 1,  8,  12047,  10048, 120, 145, 162, 180,   1,   1, { 2997, 2604, 2321, }, { 5, 3, 1, }, nil, nil, { 10316, }, },
	[3849]  = { nil, 1,  8,   3849,   4315, 120, 145, 162, 180,   1,   1, { 2997, 2319, 2321, }, { 6, 2, 2, }, nil, nil, { 4347, }, },
	[7892]  = { nil, 1,  8,   7892,   6384, 120, 145, 162, 180,   1,   1, { 2997, 6260, 4340, 2321, }, { 4, 2, 1, 1, }, nil, nil, { 6390, }, },
	[7893]  = { nil, 1,  8,   7893,   6385, 120, 145, 162, 180,   1,   1, { 2997, 2605, 4340, 2321, }, { 4, 2, 1, 1, }, nil, nil, { 6391, }, },
	[3851]  = { nil, 1,  8,   3851,   4317, 125, 150, 167, 185,   1,   1, { 2997, 5500, 2321, }, { 6, 1, 3, }, nil, nil, { 4349, }, },
	[3839]  = { nil, 1,  8,   3839,   4305, 125, 135, 140, 145,   1,   1, { 4306, }, { 4, }, true, 500, },
	[3868]  = { nil, 1,  8,   3868,   4331, 125, 150, 167, 185,   1,   1, { 2997, 5500, 2321, 2324, }, { 4, 1, 4, 2, }, nil, nil, { 4348, }, },
	[3855]  = { nil, 1,  8,   3855,   4320, 125, 150, 167, 185,   1,   1, { 4305, 2319, 3182, 5500, }, { 2, 4, 4, 2, }, true, 750, },
	[3852]  = { nil, 1,  8,   3852,   4318, 130, 150, 165, 180,   1,   1, { 2997, 2321, 3383, }, { 4, 3, 1, }, true, 750, },
	[3869]  = { nil, 1,  8,   3869,   4332, 135, 145, 150, 155,   1,   1, { 4305, 4341, 2321, }, { 1, 1, 1, }, nil, nil, { 14627, }, },
	[6690]  = { nil, 1,  8,   6690,   5766, 135, 155, 170, 185,   1,   1, { 4305, 2321, 3182, }, { 2, 2, 2, }, true, 1000, },
	[8758]  = { nil, 1,  8,   8758,   7046, 140, 160, 175, 190,   1,   1, { 4305, 6260, 2321, }, { 4, 2, 3, }, true, 600, },
	[3856]  = { nil, 1,  8,   3856,   4321, 140, 160, 175, 190,   1,   1, { 4305, 3182, 2321, }, { 3, 1, 2, }, nil, nil, { 4350, }, },
	[8760]  = { nil, 1,  8,   8760,   7048, 145, 155, 160, 165,   1,   1, { 4305, 6260, 2321, }, { 2, 2, 1, }, true, 600, },
	[3854]  = { nil, 1,  8,   3854,   4319, 145, 165, 180, 195,   1,   1, { 4305, 4234, 6260, 2321, }, { 3, 2, 2, 2, }, nil, nil, { 7114, }, },
	[8780]  = { nil, 1,  8,   8780,   7047, 145, 165, 180, 195,   1,   1, { 4305, 4234, 6048, 2321, }, { 3, 2, 2, 2, }, nil, nil, { 7092, }, },
	[3859]  = { nil, 1,  8,   3859,   4324, 150, 170, 185, 200,   1,   1, { 4305, 6260, }, { 5, 4, }, true, 750, },
	[8782]  = { nil, 1,  8,   8782,   7049, 150, 170, 185, 200,   1,   1, { 4305, 4234, 929, 2321, }, { 3, 2, 4, 1, }, nil, nil, { 7091, }, },
	[6692]  = { nil, 1,  8,   6692,   5770, 150, 170, 185, 200,   1,   1, { 4305, 2321, 3182, }, { 4, 2, 2, }, nil, nil, { 5773, }, },
	[3813]  = { nil, 1,  8,   3813,   4245, 150, 170, 185, 200,   1,   1, { 4305, 4234, 2321, }, { 3, 2, 3, }, true, 800, },
	[3870]  = { nil, 1,  8,   3870,   4333, 155, 165, 170, 175,   1,   1, { 4305, 4340, 2321, }, { 2, 2, 1, }, nil, nil, { 6401, }, },
	[8762]  = { nil, 1,  8,   8762,   7050, 160, 170, 175, 180,   1,   1, { 4305, 2321, }, { 3, 2, }, true, 750, },
	[8483]  = { nil, 1,  8,   8483,   6795, 160, 170, 175, 180,   1,   1, { 4305, 2324, 4291, }, { 3, 2, 1, }, true, 500, },
	[3857]  = { nil, 1,  8,   3857,   4322, 165, 185, 200, 215,   1,   1, { 4305, 2321, 4337, }, { 3, 2, 2, }, nil, nil, { 14630, }, },
	[8784]  = { nil, 1,  8,   8784,   7065, 165, 185, 200, 215,   1,   1, { 4305, 2605, 4291, }, { 5, 2, 1, }, nil, nil, { 7090, }, },
	[8764]  = { nil, 1,  8,   8764,   7051, 170, 190, 205, 220,   1,   1, { 4305, 7067, 2321, }, { 3, 1, 2, }, true, 900, },
	[3858]  = { nil, 1,  8,   3858,   4323, 170, 190, 205, 220,   1,   1, { 4305, 4291, 3824, }, { 4, 1, 1, }, nil, nil, { 4351, }, },
	[3871]  = { nil, 1,  8,   3871,   4334, 170, 180, 185, 190,   1,   1, { 4305, 2324, 2321, }, { 3, 2, 1, }, true, 500, },
	[8489]  = { nil, 1,  8,   8489,   6796, 175, 185, 190, 195,   1,   1, { 4305, 2604, 4291, }, { 3, 2, 1, }, true, 750, },
	[8772]  = { nil, 1,  8,   8772,   7055, 175, 195, 210, 225,   1,   1, { 4305, 7071, 2604, 4291, }, { 4, 1, 2, 1, }, true, 1000, },
	[8786]  = { nil, 1,  8,   8786,   7053, 175, 195, 210, 225,   1,   1, { 4305, 6260, 2321, }, { 3, 2, 2, }, nil, nil, { 7089, }, },
	[3860]  = { nil, 1,  8,   3860,   4325, 175, 195, 210, 225,   1,   1, { 4305, 4291, 4337, }, { 4, 1, 2, }, nil, nil, { 4352, }, },
	[8766]  = { nil, 1,  8,   8766,   7052, 175, 195, 210, 225,   1,   1, { 4305, 7070, 6260, 2321, 7071, }, { 4, 1, 2, 2, 1, }, true, 1000, },
	[6693]  = { nil, 1,  8,   6693,   5764, 175, 195, 210, 225,   1,   1, { 4305, 4234, 2321, 2605, }, { 4, 3, 3, 1, }, nil, nil, { 5774, }, },
	[3865]  = { nil, 1,  8,   3865,   4339, 175, 180, 182, 185,   1,   1, { 4338, }, { 5, }, true, 1000, },
	[3863]  = { nil, 1,  8,   3863,   4328, 180, 200, 215, 230,   1,   1, { 4305, 4337, 7071, }, { 4, 2, 1, }, nil, nil, { 4353, }, },
	[8774]  = { nil, 1,  8,   8774,   7057, 180, 200, 215, 230,   1,   1, { 4305, 4291, }, { 5, 2, }, true, 1000, },
	[8789]  = { nil, 1,  8,   8789,   7056, 180, 200, 215, 230,   1,   1, { 4305, 2604, 6371, 4291, }, { 5, 2, 2, 1, }, nil, nil, { 7087, }, },
	[6695]  = { nil, 1,  8,   6695,   5765, 185, 205, 220, 235,   1,   1, { 4305, 2325, 2321, }, { 5, 1, 4, }, nil, nil, { 5775, }, },
	[8791]  = { nil, 1,  8,   8791,   7058, 185, 205, 215, 225,   1,   1, { 4305, 2604, 2321, }, { 4, 2, 2, }, true, 2500, },
	[3861]  = { nil, 1,  8,   3861,   4326, 185, 205, 220, 235,   1,   1, { 4305, 3827, 4291, }, { 4, 1, 1, }, true, 1000, },
	[3872]  = { nil, 1,  8,   3872,   4335, 185, 195, 200, 205,   1,   1, { 4305, 4342, 4291, }, { 4, 1, 1, }, nil, nil, { 4354, }, },
	[8793]  = { nil, 1,  8,   8793,   7059, 190, 210, 225, 240,   1,   1, { 4305, 6371, 2604, 4291, }, { 5, 2, 2, 2, }, nil, nil, { 7084, }, },
	[21945] = { nil, 1,  8,  21945,  17723, 190, 200, 205, 210,   1,   1, { 4305, 2605, 4291, }, { 5, 4, 1, }, nil, nil, { 17724, }, },
	[8795]  = { nil, 1,  8,   8795,   7060, 190, 210, 225, 240,   1,   1, { 4305, 7072, 6260, 4291, }, { 6, 2, 2, 2, }, nil, nil, { 7085, }, },
	[8770]  = { nil, 1,  8,   8770,   7054, 190, 210, 225, 240,   1,   1, { 4339, 7067, 7070, 7068, 7069, 4291, }, { 2, 2, 2, 2, 2, 2, }, true, 1000, },
	[8799]  = { nil, 1,  8,   8799,   7062, 195, 215, 225, 235,   1,   1, { 4305, 2604, 4291, }, { 4, 2, 2, }, true, 3000, },
	[8797]  = { nil, 1,  8,   8797,   7061, 195, 215, 230, 245,   1,   1, { 4305, 7067, 4234, 7071, 4291, }, { 5, 4, 4, 1, 2, }, nil, nil, { 7086, }, },
	[3862]  = { nil, 1,  8,   3862,   4327, 200, 220, 235, 250,   1,   1, { 4339, 4291, 3829, 4337, }, { 3, 2, 1, 2, }, nil, nil, { 4355, }, },
	[3864]  = { nil, 1,  8,   3864,   4329, 200, 220, 235, 250,   1,   1, { 4339, 4234, 3864, 7071, 4291, }, { 4, 4, 1, 1, 1, }, nil, nil, { 4356, }, },
	[3873]  = { nil, 1,  8,   3873,   4336, 200, 210, 215, 220,   1,   1, { 4305, 2325, 4291, }, { 5, 1, 1, }, nil, nil, { 10728, }, },
	[8802]  = { nil, 1,  8,   8802,   7063, 205, 220, 235, 250,   1,   1, { 4305, 7068, 3827, 2604, 4291, }, { 8, 4, 2, 4, 1, }, nil, nil, { 7088, }, },
	[12048] = { nil, 1,  8,  12048,   9998, 205, 220, 235, 250,   1,   1, { 4339, 4291, }, { 2, 3, }, true, 4000, },
	[12049] = { nil, 1,  8,  12049,   9999, 205, 220, 235, 250,   1,   1, { 4339, 4291, }, { 2, 3, }, true, 4000, },
	[12052] = { nil, 1,  8,  12052,  10002, 210, 225, 240, 255,   1,   1, { 4339, 10285, 8343, }, { 3, 2, 1, }, true, 4050, },
	[12050] = { nil, 1,  8,  12050,  10001, 210, 225, 240, 255,   1,   1, { 4339, 8343, }, { 3, 1, }, true, 4000, },
	[8804]  = { nil, 1,  8,   8804,   7064, 210, 225, 240, 255,   1,   1, { 4305, 7068, 6371, 4304, 2604, 4291, }, { 6, 2, 2, 2, 4, 2, }, true, 5000, },
	[12060] = { nil, 1,  8,  12060,  10009, 215, 230, 245, 260,   1,   1, { 4339, 2604, 8343, }, { 3, 2, 1, }, nil, nil, { 10302, }, },
	[12055] = { nil, 1,  8,  12055,  10004, 215, 230, 245, 260,   1,   1, { 4339, 10285, 8343, }, { 3, 2, 1, }, true, 4455, },
	[12056] = { nil, 1,  8,  12056,  10007, 215, 230, 245, 260,   1,   1, { 4339, 2604, 8343, }, { 3, 2, 1, }, nil, nil, { 10300, }, },
	[12061] = { nil, 1,  8,  12061,  10056, 215, 220, 225, 230,   1,   1, { 4339, 6261, 8343, }, { 1, 1, 1, }, true, 2500, },
	[12059] = { nil, 1,  8,  12059,  10008, 215, 220, 225, 230,   1,   1, { 4339, 2324, 8343, }, { 1, 1, 1, }, nil, nil, { 10301, }, },
	[12053] = { nil, 1,  8,  12053,  10003, 215, 230, 245, 260,   1,   1, { 4339, 8343, }, { 2, 2, }, true, 5000, },
	[12064] = { nil, 1,  8,  12064,  10052, 220, 225, 230, 235,   1,   1, { 4339, 6261, 8343, }, { 2, 2, 1, }, nil, nil, { 10311, }, },
	[12070] = { nil, 1,  8,  12070,  10021, 225, 240, 255, 270,   1,   1, { 4339, 8153, 10286, 8343, }, { 6, 6, 2, 2, }, true, 5000, },
	[12066] = { nil, 1,  8,  12066,  10018, 225, 240, 255, 270,   1,   1, { 4339, 2604, 8343, }, { 3, 2, 2, }, nil, nil, { 10312, }, },
	[12065] = { nil, 1,  8,  12065,  10050, 225, 240, 255, 270,   1,   1, { 4339, 4291, }, { 4, 2, }, true, 5000, },
	[12067] = { nil, 1,  8,  12067,  10019, 225, 240, 255, 270,   1,   1, { 4339, 8153, 10286, 8343, }, { 4, 4, 2, 2, }, true, 5000, },
	[27658] = { nil, 1,  8,  27658,  22246, 225, 240, 255, 270,   1,   1, { 4339, 11137, 8343, }, { 4, 4, 2, }, nil, nil, { 22307, }, },
	[12069] = { nil, 1,  8,  12069,  10042, 225, 240, 255, 270,   1,   1, { 4339, 7077, 8343, }, { 5, 2, 2, }, true, 5000, },
	[12071] = { nil, 1,  8,  12071,  10023, 225, 240, 255, 270,   1,   1, { 4339, 10285, 8343, }, { 5, 5, 2, }, true, 4860, },
	[12075] = { nil, 1,  8,  12075,  10054, 230, 235, 240, 245,   1,   1, { 4339, 4342, 8343, }, { 2, 2, 2, }, nil, nil, { 10314, }, },
	[12074] = { nil, 1,  8,  12074,  10027, 230, 245, 260, 275,   1,   1, { 4339, 8343, }, { 3, 2, }, true, 6000, },
	[12072] = { nil, 1,  8,  12072,  10024, 230, 245, 260, 275,   1,   1, { 4339, 8343, }, { 3, 2, }, true, 6000, },
	[12073] = { nil, 1,  8,  12073,  10026, 230, 245, 260, 275,   1,   1, { 4339, 8343, 4304, }, { 3, 2, 2, }, true, 6000, },
	[12078] = { nil, 1,  8,  12078,  10029, 235, 250, 265, 280,   1,   1, { 4339, 2604, 8343, }, { 4, 2, 3, }, nil, nil, { 10315, }, },
	[12077] = { nil, 1,  8,  12077,  10053, 235, 240, 245, 250,   1,   1, { 4339, 2325, 8343, 2324, }, { 3, 1, 1, 1, }, true, 5000, },
	[12076] = { nil, 1,  8,  12076,  10028, 235, 250, 265, 280,   1,   1, { 4339, 10285, 8343, }, { 5, 4, 2, }, true, 5265, },
	[12080] = { nil, 1,  8,  12080,  10055, 235, 240, 245, 250,   1,   1, { 4339, 10290, 8343, }, { 3, 1, 1, }, nil, nil, { 10317, }, },
	[12079] = { nil, 1,  8,  12079,  10051, 235, 250, 265, 280,   1,   1, { 4339, 2604, 8343, }, { 4, 2, 2, }, true, 6500, },
	[12082] = { nil, 1,  8,  12082,  10031, 240, 255, 270, 285,   1,   1, { 4339, 10285, 8343, 4304, }, { 6, 6, 3, 2, }, true, 5670, },
	[12084] = { nil, 1,  8,  12084,  10033, 240, 255, 270, 285,   1,   1, { 4339, 2604, 8343, }, { 4, 2, 2, }, nil, nil, { 10320, }, },
	[12085] = { nil, 1,  8,  12085,  10034, 240, 245, 250, 255,   1,   1, { 4339, 8343, }, { 4, 2, }, nil, nil, { 10321, }, },
	[12081] = { nil, 1,  8,  12081,  10030, 240, 255, 270, 285,   1,   1, { 4339, 4589, 8343, }, { 3, 6, 2, }, nil, nil, { 10318, }, },
	[12089] = { nil, 1,  8,  12089,  10035, 245, 250, 255, 260,   1,   1, { 4339, 8343, }, { 4, 3, }, nil, nil, { 10323, }, },
	[12088] = { nil, 1,  8,  12088,  10044, 245, 260, 275, 290,   1,   1, { 4339, 7077, 8343, 4304, }, { 5, 1, 3, 2, }, true, 7500, },
	[12086] = { nil, 1,  8,  12086,  10025, 245, 260, 275, 290,   1,   1, { 4339, 10285, 8343, }, { 2, 8, 2, }, nil, nil, { 10463, }, },
	[26407] = { nil, 1,  8,  26407,  21542, 250, 265, 280, 295,   1,   1, { 14048, 4625, 2604, 14341, }, { 4, 2, 2, 1, }, nil, nil, { 21723, }, },
	[12093] = { nil, 1,  8,  12093,  10036, 250, 265, 280, 295,   1,   1, { 4339, 8343, }, { 5, 3, }, nil, nil, { 10326, }, },
	[18560] = { nil, 1,  8,  18560,  14342, 250, 290, 305, 320,   1,   1, { 14256, }, { 2, }, nil, nil, { 14526, }, },
	[26403] = { nil, 1,  8,  26403,  21154, 250, 265, 280, 295,   1,   1, { 14048, 4625, 2604, 14341, }, { 4, 2, 2, 1, }, nil, nil, { 21722, }, },
	[18401] = { nil, 1,  8,  18401,  14048, 250, 255, 257, 260,   1,   1, { 14047, }, { 5, }, true, 10000, },
	[12092] = { nil, 1,  8,  12092,  10041, 250, 265, 280, 295,   1,   1, { 4339, 8153, 10286, 8343, 6037, 1529, }, { 8, 4, 2, 3, 1, 1, }, true, 7500, },
	[12091] = { nil, 1,  8,  12091,  10040, 250, 255, 260, 265,   1,   1, { 4339, 8343, 2324, }, { 5, 3, 1, }, nil, nil, { 10325, }, },
	[18403] = { nil, 1,  8,  18403,  13869, 255, 270, 285, 300,   1,   1, { 14048, 7079, 14341, }, { 5, 2, 1, }, nil, nil, { 14466, }, },
	[18402] = { nil, 1,  8,  18402,  13856, 255, 270, 285, 300,   1,   1, { 14048, 14341, }, { 3, 1, }, true, 10000, },
	[18404] = { nil, 1,  8,  18404,  13868, 255, 270, 285, 300,   1,   1, { 14048, 7079, 14341, }, { 5, 2, 1, }, nil, nil, { 14467, }, },
	[18408] = { nil, 1,  8,  18408,  14042, 260, 275, 290, 305,   1,   1, { 14048, 7077, 14341, }, { 5, 3, 1, }, nil, nil, { 14471, }, },
	[26085] = { nil, 1,  8,  26085,  21340, 260, 275, 290, 305,   1,   1, { 14048, 8170, 7972, 14341, }, { 6, 4, 2, 1, }, nil, nil, { 21358, }, },
	[18407] = { nil, 1,  8,  18407,  13857, 260, 275, 290, 305,   1,   1, { 14048, 14227, 14341, }, { 5, 1, 1, }, nil, nil, { 14470, }, },
	[18406] = { nil, 1,  8,  18406,  13858, 260, 275, 290, 305,   1,   1, { 14048, 14227, 14341, }, { 5, 1, 1, }, nil, nil, { 14469, }, },
	[18405] = { nil, 1,  8,  18405,  14046, 260, 275, 290, 305,   1,   1, { 14048, 8170, 14341, }, { 5, 2, 1, }, nil, nil, { 14468, }, },
	[18411] = { nil, 1,  8,  18411,  13870, 265, 280, 295, 310,   1,   1, { 14048, 7080, 14341, }, { 3, 1, 1, }, nil, nil, { 14474, }, },
	[18410] = { nil, 1,  8,  18410,  14143, 265, 280, 295, 310,   1,   1, { 14048, 9210, 14227, 14341, }, { 3, 2, 1, 1, }, nil, nil, { 14473, }, },
	[18409] = { nil, 1,  8,  18409,  13860, 265, 280, 295, 310,   1,   1, { 14048, 14227, 14341, }, { 4, 1, 1, }, nil, nil, { 14472, }, },
	[18412] = { nil, 1,  8,  18412,  14043, 270, 285, 300, 315,   1,   1, { 14048, 7077, 14341, }, { 4, 3, 1, }, nil, nil, { 14476, }, },
	[18415] = { nil, 1,  8,  18415,  14101, 270, 285, 300, 315,   1,   1, { 14048, 3577, 14341, }, { 4, 2, 1, }, nil, nil, { 14479, }, },
	[18413] = { nil, 1,  8,  18413,  14142, 270, 285, 300, 315,   1,   1, { 14048, 9210, 14227, 14341, }, { 4, 2, 1, 1, }, nil, nil, { 14477, }, },
	[18414] = { nil, 1,  8,  18414,  14100, 270, 285, 300, 315,   1,   1, { 14048, 3577, 14341, }, { 5, 2, 1, }, nil, nil, { 14478, }, },
	[18420] = { nil, 1,  8,  18420,  14103, 275, 290, 305, 320,   1,   1, { 14048, 3577, 14341, }, { 4, 2, 1, }, nil, nil, { 14484, }, },
	[18418] = { nil, 1,  8,  18418,  14044, 275, 290, 305, 320,   1,   1, { 14048, 7078, 14341, }, { 5, 1, 1, }, nil, nil, { 14482, }, },
	[18416] = { nil, 1,  8,  18416,  14141, 275, 290, 305, 320,   1,   1, { 14048, 9210, 14227, 14341, }, { 6, 4, 1, 1, }, nil, nil, { 14480, }, },
	[18422] = { nil, 1,  8,  18422,  14134, 275, 290, 305, 320,   1,   1, { 14048, 7078, 7077, 7068, 14341, }, { 6, 4, 4, 4, 1, }, nil, nil, { 14486, }, },
	[27724] = { nil, 5,  8,  27724,  22251, 275, 290, 305, 320,   1,   1, { 14048, 8831, 11040, 14341, }, { 5, 10, 8, 2, }, nil, nil, { 22310, }, },
	[27659] = { nil, 5,  8,  27659,  22248, 275, 290, 305, 320,   1,   1, { 14048, 16203, 14341, }, { 5, 2, 2, }, nil, nil, { 22308, }, },
	[18419] = { nil, 1,  8,  18419,  14107, 275, 290, 305, 320,   1,   1, { 14048, 14256, 14341, }, { 5, 4, 1, }, nil, nil, { 14483, }, },
	[18417] = { nil, 1,  8,  18417,  13863, 275, 290, 305, 320,   1,   1, { 14048, 8170, 14341, }, { 4, 4, 1, }, nil, nil, { 14481, }, },
	[18421] = { nil, 1,  8,  18421,  14132, 275, 290, 305, 320,   1,   1, { 14048, 11176, 14341, }, { 6, 1, 1, }, nil, nil, { 14485, }, },
	[18434] = { nil, 1,  8,  18434,  14045, 280, 295, 310, 325,   1,   1, { 14048, 7078, 14341, }, { 6, 1, 1, }, nil, nil, { 14490, }, },
	[18423] = { nil, 1,  8,  18423,  13864, 280, 295, 310, 325,   1,   1, { 14048, 14227, 8170, 14341, }, { 4, 2, 4, 1, }, nil, nil, { 14488, }, },
	[18424] = { nil, 1,  8,  18424,  13871, 280, 295, 310, 325,   1,   1, { 14048, 7080, 14341, }, { 6, 1, 1, }, nil, nil, { 14489, }, },
	[22813] = { nil, 2,  8,  22813,  18258, 285, 285, 290, 295,   1,   1, { 14048, 8170, 18240, 14341, }, { 2, 4, 1, 1, }, nil, nil, nil, { 5519, }, },
	[26086] = { nil, 1,  8,  26086,  21341, 285, 300, 315, 330,   1,   1, { 14256, 12810, 20520, 14227, }, { 12, 6, 2, 4, }, nil, nil, nil, nil, 180794, },
	[18436] = { nil, 1,  8,  18436,  14136, 285, 300, 315, 330,   1,   1, { 14048, 14256, 12808, 7080, 14341, }, { 10, 12, 4, 4, 1, }, nil, nil, { 14493, }, },
	[18438] = { nil, 1,  8,  18438,  13865, 285, 300, 315, 330,   1,   1, { 14048, 14227, 14341, }, { 6, 2, 1, }, nil, nil, { 14491, }, },
	[18437] = { nil, 1,  8,  18437,  14108, 285, 300, 315, 330,   1,   1, { 14048, 14256, 8170, 14341, }, { 6, 4, 4, 1, }, nil, nil, { 14492, }, },
	[23662] = { nil, 3,  8,  23662,  19047, 290, 305, 320, 335,   1,   1, { 14048, 7076, 12803, 14227, }, { 8, 3, 3, 2, }, nil, nil, { 19215, }, },
	[19435] = { nil, 1,  8,  19435,  15802, 290, 295, 310, 325,   1,   1, { 14048, 14342, 7971, 14341, }, { 6, 4, 2, 1, }, nil, nil, nil, { 6032, }, },
	[18442] = { nil, 1,  8,  18442,  14111, 290, 305, 320, 335,   1,   1, { 14048, 14256, 14341, }, { 5, 4, 1, }, nil, nil, { 14496, }, },
	[23664] = { nil, 3,  8,  23664,  19056, 290, 305, 320, 335,   1,   1, { 14048, 12810, 13926, 12809, 14227, }, { 6, 4, 2, 2, 2, }, nil, nil, { 19216, }, },
	[18439] = { nil, 1,  8,  18439,  14104, 290, 305, 320, 335,   1,   1, { 14048, 3577, 14227, 14341, }, { 6, 4, 1, 1, }, nil, nil, { 14494, }, },
	[18440] = { nil, 1,  8,  18440,  14137, 290, 305, 320, 335,   1,   1, { 14048, 14342, 14341, }, { 6, 4, 1, }, nil, nil, { 14497, }, },
	[18441] = { nil, 1,  8,  18441,  14144, 290, 305, 320, 335,   1,   1, { 14048, 9210, 14341, }, { 6, 4, 1, }, nil, nil, { 14495, }, },
	[18444] = { nil, 1,  8,  18444,  13866, 295, 310, 325, 340,   1,   1, { 14048, 14227, 14341, }, { 4, 2, 1, }, nil, nil, { 14498, }, },
	[27725] = { nil, 5,  8,  27725,  22252, 300, 315, 330, 345,   1,   1, { 14048, 14342, 13468, 14227, }, { 6, 2, 1, 4, }, nil, nil, { 22312, }, },
	[24903] = { nil, 4,  8,  24903,  20537, 300, 315, 330, 345,   1,   1, { 14048, 20520, 14256, 12810, 14227, }, { 4, 6, 4, 2, 2, }, nil, nil, { 20547, }, },
	[18452] = { nil, 1,  8,  18452,  14140, 300, 315, 330, 345,   1,   1, { 14048, 14342, 12800, 12810, 14341, }, { 4, 6, 1, 2, 2, }, nil, nil, { 14509, }, },
	[26087] = { nil, 1,  8,  26087,  21342, 300, 315, 330, 345,   1,   1, { 14256, 17012, 19726, 7078, 14227, }, { 20, 16, 8, 4, 4, }, nil, nil, { 21371, }, },
	[24902] = { nil, 4,  8,  24902,  20539, 300, 315, 330, 345,   1,   1, { 14048, 20520, 14256, 12810, 14227, }, { 2, 6, 2, 2, 2, }, nil, nil, { 20548, }, },
	[18457] = { nil, 1,  8,  18457,  14152, 300, 315, 330, 345,   1,   1, { 14048, 7078, 7082, 7076, 7080, 14341, }, { 12, 10, 10, 10, 10, 2, }, nil, nil, { 14513, }, },
	[28209] = { nil, 6,  8,  28209,  22655, 300, 315, 330, 345,   1,   1, { 22682, 14048, 7080, 14227, }, { 4, 2, 2, 4, }, true, 0, nil, { 9233, }, },
	[22866] = { nil, 2,  8,  22866,  18405, 300, 315, 330, 345,   1,   1, { 14048, 9210, 14342, 7080, 7078, 14344, 14341, }, { 16, 10, 10, 12, 12, 6, 6, }, nil, nil, { 18414, }, },
	[23665] = { nil, 3,  8,  23665,  19059, 300, 315, 330, 345,   1,   1, { 14342, 12809, 14227, }, { 5, 2, 2, }, nil, nil, { 19217, }, },
	[24901] = { nil, 4,  8,  24901,  20538, 300, 315, 330, 345,   1,   1, { 14048, 20520, 14256, 14227, }, { 6, 8, 6, 2, }, nil, nil, { 20546, }, },
	[28482] = { nil, 6,  8,  28482,  22758, 300, 315, 330, 345,   1,   1, { 14048, 12803, 14227, }, { 2, 4, 2, }, nil, nil, { 22772, }, },
	[18454] = { nil, 1,  8,  18454,  14146, 300, 315, 330, 345,   1,   1, { 14048, 14342, 9210, 13926, 12364, 12810, 14341, }, { 10, 10, 10, 6, 6, 8, 2, }, nil, nil, { 14511, }, },
	[22867] = { nil, 2,  8,  22867,  18407, 300, 315, 330, 345,   1,   1, { 14048, 14256, 12662, 12808, 14341, }, { 12, 20, 6, 8, 2, }, nil, nil, { 18415, }, },
	[22870] = { nil, 2,  8,  22870,  18413, 300, 315, 330, 345,   1,   1, { 14048, 12809, 12360, 14341, }, { 12, 4, 1, 2, }, nil, nil, { 18418, }, },
	[18458] = { nil, 1,  8,  18458,  14153, 300, 315, 330, 345,   1,   1, { 14048, 12662, 14256, 7078, 12808, 14341, }, { 12, 20, 40, 12, 12, 2, }, nil, nil, { 14514, }, },
	[28208] = { nil, 6,  8,  28208,  22658, 300, 315, 330, 345,   1,   1, { 22682, 14048, 7080, 14227, }, { 5, 4, 2, 4, }, true, 0, nil, { 9233, }, },
	[20848] = { nil, 1,  8,  20848,  16980, 300, 315, 330, 345,   1,   1, { 14048, 17010, 17011, 12810, 14341, }, { 12, 4, 4, 6, 2, }, nil, nil, { 17017, }, },
	[28481] = { nil, 6,  8,  28481,  22757, 300, 315, 330, 345,   1,   1, { 14048, 14342, 12803, 14227, }, { 4, 2, 2, 2, }, nil, nil, { 22773, }, },
	[22759] = { nil, 1,  8,  22759,  18263, 300, 320, 335, 350,   1,   1, { 14342, 17010, 7078, 12810, 14341, }, { 6, 8, 2, 6, 4, }, nil, nil, { 18265, }, },
	[24091] = { nil, 4,  8,  24091,  19682, 300, 315, 330, 345,   1,   1, { 14342, 19726, 12804, 14048, 14227, }, { 3, 5, 4, 4, 2, }, nil, nil, { 19764, }, },
	[18453] = { nil, 1,  8,  18453,  14112, 300, 315, 330, 345,   1,   1, { 14048, 14256, 12662, 8170, 14341, }, { 7, 6, 4, 4, 2, }, nil, nil, { 14508, }, },
	[28210] = { nil, 6,  8,  28210,  22660, 300, 315, 330, 345,   1,   1, { 19726, 14342, 12803, 14227, }, { 1, 2, 4, 4, }, nil, nil, { 22683, }, },
	[18446] = { nil, 1,  8,  18446,  14128, 300, 315, 330, 345,   1,   1, { 14048, 11176, 14341, }, { 8, 2, 1, }, nil, nil, { 14500, }, },
	[28480] = { nil, 6,  8,  28480,  22756, 300, 315, 330, 345,   1,   1, { 14048, 19726, 12803, 14227, }, { 4, 2, 2, 2, }, nil, nil, { 22774, }, },
	[23663] = { nil, 3,  8,  23663,  19050, 300, 315, 330, 345,   1,   1, { 14342, 7076, 12803, 14227, }, { 5, 5, 5, 2, }, nil, nil, { 19218, }, },
	[18449] = { nil, 1,  8,  18449,  13867, 300, 315, 330, 345,   1,   1, { 14048, 14227, 8170, 14341, }, { 7, 2, 4, 1, }, nil, nil, { 14504, }, },
	[28207] = { nil, 6,  8,  28207,  22652, 300, 315, 330, 345,   1,   1, { 22682, 14048, 7080, 14227, }, { 7, 8, 6, 8, }, true, 0, nil, { 9233, }, },
	[23666] = { nil, 3,  8,  23666,  19156, 300, 315, 330, 345,   1,   1, { 14342, 17010, 17011, 7078, 14227, }, { 10, 2, 3, 6, 4, }, nil, nil, { 19219, }, },
	[18455] = { nil, 1,  8,  18455,  14156, 300, 315, 330, 345,   1,   1, { 14048, 14342, 14344, 17012, 14341, }, { 8, 12, 2, 2, 2, }, nil, nil, { 14510, }, },
	[23667] = { nil, 3,  8,  23667,  19165, 300, 315, 330, 345,   1,   1, { 14342, 17010, 17011, 7078, 14227, }, { 8, 5, 3, 10, 4, }, nil, nil, { 19220, }, },
	[18448] = { nil, 1,  8,  18448,  14139, 300, 315, 330, 345,   1,   1, { 14048, 14342, 14341, }, { 5, 5, 1, }, nil, nil, { 14507, }, },
	[28205] = { nil, 6,  8,  28205,  22654, 300, 315, 330, 345,   1,   1, { 22682, 14048, 7080, 14227, }, { 5, 4, 4, 4, }, true, 0, nil, { 9233, }, },
	[24092] = { nil, 4,  8,  24092,  19683, 300, 315, 330, 345,   1,   1, { 14342, 19726, 12804, 14048, 14227, }, { 4, 4, 4, 4, 2, }, nil, nil, { 19765, }, },
	[18450] = { nil, 1,  8,  18450,  14130, 300, 315, 330, 345,   1,   1, { 14048, 11176, 7910, 14341, }, { 6, 4, 1, 1, }, nil, nil, { 14505, }, },
	[18447] = { nil, 1,  8,  18447,  14138, 300, 315, 330, 345,   1,   1, { 14048, 14342, 14341, }, { 6, 4, 1, }, nil, nil, { 14501, }, },
	[24093] = { nil, 4,  8,  24093,  19684, 300, 315, 330, 345,   1,   1, { 14342, 19726, 12810, 14048, 14227, }, { 3, 3, 4, 4, 4, }, nil, nil, { 19766, }, },
	[22902] = { nil, 2,  8,  22902,  18486, 300, 315, 330, 345,   1,   1, { 14048, 14342, 13926, 14341, }, { 6, 4, 2, 2, }, nil, nil, { 18487, }, },
	[22868] = { nil, 2,  8,  22868,  18408, 300, 315, 330, 345,   1,   1, { 14048, 7078, 7910, 14341, }, { 12, 10, 2, 2, }, nil, nil, { 18416, }, },
	[18456] = { nil, 1,  8,  18456,  14154, 300, 315, 330, 345,   1,   1, { 14048, 14342, 12811, 13926, 9210, 14341, }, { 12, 10, 4, 4, 10, 2, }, nil, nil, { 14512, }, },
	[18451] = { nil, 1,  8,  18451,  14106, 300, 315, 330, 345,   1,   1, { 14048, 14256, 12662, 14341, }, { 8, 8, 4, 2, }, nil, nil, { 14506, }, },
	[22869] = { nil, 2,  8,  22869,  18409, 300, 315, 330, 345,   1,   1, { 14048, 14342, 13926, 14341, }, { 12, 6, 2, 2, }, nil, nil, { 18417, }, },
	[20849] = { nil, 1,  8,  20849,  16979, 300, 315, 330, 345,   1,   1, { 14048, 17010, 7078, 12810, 14341, }, { 8, 6, 4, 2, 2, }, nil, nil, { 17018, }, },
	[18445] = { nil, 1,  8,  18445,  14155, 300, 315, 330, 345,   1,   1, { 14048, 14342, 14341, }, { 4, 1, 1, }, nil, nil, { 14499, }, },
	[27660] = { nil, 5,  8,  27660,  22249, 300, 315, 330, 345,   1,   1, { 14048, 14344, 12810, 14227, }, { 6, 4, 4, 4, }, nil, nil, { 22309, }, },
	[3919]  = { nil, 1,  9,   3919,   4358,   1,  30,  45,  60,   2,   2, { 4357, 2589, }, { 2, 1, }, },
	[3918]  = { nil, 1,  9,   3918,   4357,   1,  20,  30,  40,   1,   1, { 2835, }, { 1, }, },
	[3920]  = { nil, 1,  9,   3920,   8067,   1,  30,  45,  60, 200, 200, { 4357, 2840, }, { 1, 1, }, },
	[3923]  = { nil, 1,  9,   3923,   4360,  30,  60,  75,  90,   2,   2, { 2840, 4359, 4357, 2589, }, { 1, 1, 2, 1, }, true, 130, },
	[3922]  = { nil, 1,  9,   3922,   4359,  30,  45,  52,  60,   1,   1, { 2840, }, { 1, }, true, 115, },
	[3924]  = { nil, 1,  9,   3924,   4361,  50,  80,  95, 110,   1,   1, { 2840, 2880, }, { 2, 1, }, true, 150, },
	[3925]  = { nil, 1,  9,   3925,   4362,  50,  80,  95, 110,   1,   1, { 4361, 4359, 4399, }, { 1, 1, 1, }, true, 150, },
	[7430]  = { nil, 1,  9,   7430,   6219,  50,  70,  80,  90,   1,   1, { 2840, }, { 6, }, true, 150, },
	[3977]  = { nil, 1,  9,   3977,   4405,  60,  90, 105, 120,   1,   1, { 4361, 774, 4359, }, { 1, 1, 1, }, true, 200, },
	[3926]  = { nil, 1,  9,   3926,   4363,  65,  95, 110, 125,   1,   1, { 4359, 2840, 2589, }, { 2, 1, 2, }, true, 225, },
	[3928]  = { nil, 1,  9,   3928,   4401,  75, 105, 120, 135,   1,   1, { 4363, 4359, 2840, 774, }, { 1, 1, 1, 2, }, nil, nil, { 4408, }, },
	[3929]  = { nil, 1,  9,   3929,   4364,  75,  85,  90,  95,   1,   1, { 2836, }, { 1, }, true, 250, },
	[3931]  = { nil, 1,  9,   3931,   4365,  75,  90,  97, 105,   1,   3, { 4364, 2589, }, { 3, 1, }, true, 250, },
	[3930]  = { nil, 1,  9,   3930,   8068,  75,  85,  90,  95, 200, 200, { 4364, 2840, }, { 1, 1, }, true, 250, },
	[3932]  = { nil, 1,  9,   3932,   4366,  85, 115, 130, 145,   1,   1, { 4363, 4359, 2841, 2592, }, { 1, 2, 1, 1, }, true, 300, },
	[3973]  = { nil, 1,  9,   3973,   4404,  90, 110, 125, 140,   5,   5, { 2842, }, { 1, }, true, 300, },
	[3934]  = { nil, 1,  9,   3934,   4368, 100, 130, 145, 160,   1,   1, { 2318, 818, }, { 6, 2, }, true, 400, },
	[8339]  = { nil, 1,  9,   8339,   6714, 100, 115, 122, 130,   1,   3, { 4364, 2592, }, { 4, 1, }, nil, nil, { 6716, }, },
	[3933]  = { nil, 1,  9,   3933,   4367, 100, 130, 145, 160,   1,   1, { 4364, 4363, 2318, 159, }, { 2, 1, 1, 1, }, nil, nil, { 4409, }, },
	[8334]  = { nil, 1,  9,   8334,   6712, 100, 115, 122, 130,   1,   1, { 2841, 4359, 2880, }, { 1, 2, 1, }, true, 300, },
	[3938]  = { nil, 1,  9,   3938,   4371, 105, 105, 130, 155,   1,   1, { 2841, 2880, }, { 2, 1, }, true, 450, },
	[3937]  = { nil, 1,  9,   3937,   4370, 105, 105, 130, 155,   2,   4, { 2840, 4364, 4404, }, { 3, 4, 1, }, true, 450, },
	[3936]  = { nil, 1,  9,   3936,   4369, 105, 130, 142, 155,   1,   1, { 4361, 4359, 4399, 2319, }, { 2, 4, 1, 2, }, true, 420, },
	[3978]  = { nil, 1,  9,   3978,   4406, 110, 135, 147, 160,   1,   1, { 4371, 1206, }, { 1, 1, }, true, 475, },
	[3941]  = { nil, 1,  9,   3941,   4374, 120, 120, 145, 170,   1,   3, { 4364, 2841, 4404, 2592, }, { 4, 2, 1, 1, }, true, 500, },
	[3939]  = { nil, 1,  9,   3939,   4372, 120, 145, 157, 170,   1,   1, { 4371, 4359, 4400, 1206, }, { 2, 2, 1, 3, }, nil, nil, { 13309, }, },
	[3940]  = { nil, 1,  9,   3940,   4373, 120, 145, 157, 170,   1,   1, { 2319, 1210, }, { 4, 2, }, nil, nil, { 4410, }, },
	[3942]  = { nil, 1,  9,   3942,   4375, 125, 125, 150, 175,   1,   1, { 2841, 2592, }, { 2, 1, }, true, 500, },
	[3944]  = { nil, 1,  9,   3944,   4376, 125, 125, 150, 175,   1,   1, { 4375, 4402, }, { 1, 1, }, nil, nil, { 4411, }, },
	[26418] = { nil, 1,  9,  26418,  21557, 125, 125, 137, 150,   3,   3, { 4364, 2319, }, { 1, 1, }, nil, nil, { 21726, }, },
	[3946]  = { nil, 1,  9,   3946,   4378, 125, 125, 135, 145,   1,   5, { 4377, 2592, }, { 2, 1, }, true, 500, },
	[9269]  = { nil, 1,  9,   9269,   7506, 125, 150, 162, 175,   1,   1, { 2841, 4375, 814, 818, 774, }, { 6, 1, 2, 1, 1, }, nil, nil, { 7560, }, },
	[26417] = { nil, 1,  9,  26417,  21559, 125, 125, 137, 150,   3,   3, { 4364, 2319, }, { 1, 1, }, nil, nil, { 21725, }, },
	[3947]  = { nil, 1,  9,   3947,   8069, 125, 125, 135, 145, 200, 200, { 4377, 2841, }, { 1, 1, }, true, 300, },
	[26416] = { nil, 1,  9,  26416,  21558, 125, 125, 137, 150,   3,   3, { 4364, 2319, }, { 1, 1, }, nil, nil, { 21724, }, },
	[3945]  = { nil, 1,  9,   3945,   4377, 125, 125, 135, 145,   1,   1, { 2838, }, { 1, }, true, 500, },
	[3949]  = { nil, 1,  9,   3949,   4379, 130, 155, 167, 180,   1,   1, { 4371, 4375, 4400, 2842, }, { 2, 2, 1, 3, }, true, 550, },
	[6458]  = { nil, 1,  9,   6458,   5507, 135, 160, 172, 185,   1,   1, { 4371, 4375, 4363, 1206, }, { 2, 2, 1, 1, }, true, 400, },
	[3950]  = { nil, 1,  9,   3950,   4380, 140, 140, 165, 190,   2,   4, { 4377, 2841, 4404, }, { 2, 3, 1, }, true, 600, },
	[3952]  = { nil, 1,  9,   3952,   4381, 140, 165, 177, 190,   1,   1, { 4371, 4375, 2319, 1206, }, { 1, 2, 2, 1, }, nil, nil, { 14639, }, },
	[3953]  = { nil, 1,  9,   3953,   4382, 145, 145, 170, 195,   1,   1, { 2841, 2319, 2592, }, { 2, 1, 1, }, true, 600, },
	[3954]  = { nil, 1,  9,   3954,   4383, 145, 170, 182, 195,   1,   1, { 4371, 4375, 4400, 1705, }, { 3, 3, 1, 2, }, nil, nil, { 4412, }, },
	[3956]  = { nil, 1,  9,   3956,   4385, 150, 175, 187, 200,   1,   1, { 2319, 1206, 4368, }, { 4, 2, 1, }, true, 750, },
	[23066] = { nil, 1,  9,  23066,   9318, 150, 150, 162, 175,   3,   3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 18647, }, },
	[23067] = { nil, 1,  9,  23067,   9312, 150, 150, 162, 175,   3,   3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 18649, }, },
	[12584] = { nil, 1,  9,  12584,  10558, 150, 150, 170, 190,   3,   3, { 3577, }, { 1, }, true, 1000, },
	[3955]  = { nil, 1,  9,   3955,   4384, 150, 175, 187, 200,   1,   1, { 4382, 4375, 4377, 2592, }, { 1, 1, 2, 2, }, true, 750, },
	[9271]  = { nil, 1,  9,   9271,   6533, 150, 150, 160, 170,   3,   3, { 2841, 6530, 4364, }, { 2, 1, 1, }, true, 500, },
	[23068] = { nil, 1,  9,  23068,   9313, 150, 150, 162, 175,   3,   3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 18648, }, },
	[3957]  = { nil, 1,  9,   3957,   4386, 155, 175, 185, 195,   1,   1, { 4375, 3829, }, { 1, 1, }, nil, nil, { 13308, }, },
	[3959]  = { nil, 1,  9,   3959,   4388, 160, 180, 190, 200,   1,   1, { 4375, 4306, 1529, 4371, }, { 3, 2, 1, 1, }, nil, nil, { 4413, }, },
	[3958]  = { nil, 1,  9,   3958,   4387, 160, 160, 170, 180,   1,   1, { 3575, }, { 2, }, true, 800, },
	[3960]  = { nil, 1,  9,   3960,   4403, 165, 185, 195, 205,   1,   1, { 4371, 4387, 4377, 2319, }, { 4, 1, 4, 4, }, nil, nil, { 4414, }, },
	[9273]  = { nil, 1,  9,   9273,   7148, 165, 160, 180, 200,   1,   1, { 3575, 4375, 814, 4306, 1210, 7191, }, { 6, 2, 2, 2, 2, 1, }, nil, nil, { 7561, }, },
	[3961]  = { nil, 1,  9,   3961,   4389, 170, 170, 190, 210,   1,   1, { 3575, 10558, }, { 1, 1, }, true, 900, },
	[26421] = { nil, 1,  9,  26421,  21590, 175, 175, 187, 200,   3,   3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 21728, }, },
	[12587] = { nil, 1,  9,  12587,  10499, 175, 195, 205, 215,   1,   1, { 4234, 3864, }, { 6, 2, }, nil, nil, { 10601, }, },
	[26420] = { nil, 1,  9,  26420,  21589, 175, 175, 187, 200,   3,   3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 21727, }, },
	[3963]  = { nil, 1,  9,   3963,   4391, 175, 175, 195, 215,   1,   1, { 4387, 4382, 4389, 4234, }, { 2, 1, 2, 4, }, true, 1000, },
	[12586] = { nil, 1,  9,  12586,  10507, 175, 175, 185, 195,   2,   2, { 10505, 4306, }, { 1, 1, }, true, 1000, },
	[12585] = { nil, 1,  9,  12585,  10505, 175, 175, 185, 195,   1,   1, { 7912, }, { 2, }, true, 1000, },
	[12590] = { nil, 1,  9,  12590,  10498, 175, 175, 195, 215,   1,   1, { 3859, }, { 4, }, true, 1000, },
	[3962]  = { nil, 1,  9,   3962,   4390, 175, 175, 195, 215,   2,   4, { 3575, 4377, 4306, }, { 1, 1, 1, }, true, 1000, },
	[26422] = { nil, 1,  9,  26422,  21592, 175, 175, 187, 200,   3,   3, { 4377, 4234, }, { 1, 1, }, nil, nil, { 21729, }, },
	[3979]  = { nil, 1,  9,   3979,   4407, 180, 200, 210, 220,   1,   1, { 4371, 1529, 3864, }, { 1, 1, 1, }, nil, nil, { 13310, }, },
	[3965]  = { nil, 1,  9,   3965,   4392, 185, 185, 205, 225,   1,   1, { 4387, 4382, 4389, 4234, }, { 1, 1, 1, 4, }, true, 1200, },
	[8243]  = { nil, 1,  9,   8243,   4852, 185, 185, 205, 225,   1,   1, { 4611, 4377, 4306, }, { 1, 1, 1, }, nil, nil, { 6672, }, },
	[3966]  = { nil, 1,  9,   3966,   4393, 185, 205, 215, 225,   1,   1, { 4234, 3864, }, { 6, 2, }, nil, nil, { 4415, }, },
	[3967]  = { nil, 1,  9,   3967,   4394, 190, 190, 210, 230,   2,   2, { 3575, 4377, 4404, }, { 3, 3, 1, }, true, 1400, },
	[21940] = { nil, 1,  9,  21940,  17716, 190, 190, 210, 230,   1,   1, { 3860, 4389, 17202, 3829, }, { 8, 4, 4, 1, }, nil, nil, { 17720, }, },
	[3968]  = { nil, 1,  9,   3968,   4395, 195, 215, 225, 235,   1,   1, { 4377, 3575, 4389, }, { 3, 2, 1, }, nil, nil, { 4416, }, },
	[12589] = { nil, 1,  9,  12589,  10559, 195, 195, 215, 235,   1,   1, { 3860, }, { 3, }, true, 1300, },
	[12895] = { nil, 1,  9,  12895,  10713, 205, 205, 205, 205,   1,   1, { 10648, 10647, }, { 1, 1, }, true, 1500, nil, nil, nil, nil, 20219, },
	[15255] = { nil, 1,  9,  15255,  11590, 200, 200, 220, 240,   1,   1, { 3860, 4338, 10505, }, { 1, 1, 1, }, true, 1500, },
	[23069] = { nil, 1,  9,  23069,  18588, 200, 200, 210, 220,   1,   1, { 10505, 4338, }, { 1, 2, }, nil, nil, { 18650, }, },
	[3971]  = { nil, 1,  9,   3971,   4397, 200, 220, 230, 240,   1,   1, { 4389, 1529, 1705, 3864, 7191, }, { 4, 2, 2, 2, 1, }, nil, nil, { 7742, }, },
	[3969]  = { nil, 1,  9,   3969,   4396, 200, 220, 230, 240,   1,   1, { 4382, 4387, 4389, 3864, 7191, }, { 1, 4, 4, 2, 1, }, nil, nil, { 13311, }, },
	[3972]  = { nil, 1,  9,   3972,   4398, 200, 200, 220, 240,   1,   1, { 10505, 4234, 159, }, { 2, 2, 1, }, nil, nil, { 4417, }, },
	[12591] = { nil, 1,  9,  12591,  10560, 200, 200, 220, 240,   1,   1, { 3860, 4338, 10505, }, { 1, 1, 1, }, true, 1500, },
	[12715] = { nil, 1,  9,  12715,  10644, 205, 205, 205, 205,   1,   1, { 10648, 10647, }, { 1, 1, }, true, 1000, nil, nil, nil, nil, 20222, },
	[12594] = { nil, 1,  9,  12594,  10500, 205, 225, 235, 245,   1,   1, { 4385, 3864, 7068, 4234, }, { 1, 2, 2, 4, }, true, 1600, },
	[12760] = { nil, 1,  9,  12760,  10646, 205, 205, 225, 245,   1,   1, { 4338, 10505, 10560, }, { 1, 3, 1, }, true, 1500, nil, nil, nil, nil, 20222, },
	[15628] = { nil, 1,  9,  15628,  11825, 205, 205, 205, 205,   1,   1, { 4394, 7077, 7191, 3860, }, { 1, 1, 1, 6, }, nil, nil, { 11828, }, nil, nil, nil, 20222, },
	[12717] = { nil, 1,  9,  12717,  10542, 205, 225, 235, 245,   1,   1, { 3860, 3864, 7067, }, { 8, 1, 4, }, true, 1500, nil, nil, nil, nil, 20222, },
	[12899] = { nil, 1,  9,  12899,  10716, 205, 225, 235, 245,   1,   1, { 10559, 10560, 3860, 8151, 1529, }, { 1, 1, 4, 4, 2, }, true, 1500, nil, nil, nil, nil, 20219, },
	[13240] = { nil, 1,  9,  13240,  10577, 205, 225, 235, 245,   1,   1, { 10577, 3860, 10505, }, { 1, 1, 3, }, true, 0, nil, nil, nil, nil, 20222, },
	[12716] = { nil, 1,  9,  12716,  10577, 205, 225, 235, 245,   1,   1, { 10559, 3860, 10505, 10558, 7068, }, { 2, 4, 5, 1, 1, }, true, 1500, nil, nil, nil, nil, 20222, },
	[15633] = { nil, 1,  9,  15633,  11826, 205, 205, 205, 205,   1,   1, { 7075, 4389, 7191, 3860, 6037, }, { 1, 2, 1, 2, 1, }, nil, nil, { 11827, }, nil, nil, nil, 20219, },
	[12718] = { nil, 1,  9,  12718,  10543, 205, 225, 235, 245,   1,   1, { 3860, 3864, 7068, }, { 8, 1, 4, }, true, 1500, nil, nil, nil, nil, 20222, },
	[12595] = { nil, 1,  9,  12595,  10508, 205, 225, 235, 245,   1,   1, { 10559, 10560, 4400, 3860, 7068, }, { 1, 1, 1, 4, 2, }, true, 1600, },
	[12596] = { nil, 1,  9,  12596,  10512, 210, 210, 230, 250, 200, 200, { 3860, 10505, }, { 1, 1, }, true, 1700, },
	[12897] = { nil, 1,  9,  12897,  10545, 210, 230, 240, 250,   1,   1, { 10500, 10559, 10558, 8151, 4234, }, { 1, 1, 2, 2, 2, }, true, 1500, nil, nil, nil, nil, 20219, },
	[12902] = { nil, 1,  9,  12902,  10720, 210, 230, 240, 250,   1,   1, { 10559, 10285, 4337, 10505, 3860, }, { 1, 2, 4, 2, 4, }, true, 1800, nil, nil, nil, nil, 20219, },
	[12597] = { nil, 1,  9,  12597,  10546, 210, 230, 240, 250,   1,   1, { 10559, 7909, 4304, }, { 1, 2, 2, }, nil, nil, { 10602, }, },
	[12599] = { nil, 1,  9,  12599,  10561, 215, 215, 235, 255,   1,   1, { 3860, }, { 3, }, true, 1800, },
	[12907] = { nil, 1,  9,  12907,  10726, 235, 255, 265, 275,   1,   1, { 3860, 6037, 10558, 7910, 4338, }, { 10, 4, 1, 2, 4, }, true, 2600, nil, nil, nil, nil, 20219, },
	[12903] = { nil, 1,  9,  12903,  10721, 215, 235, 245, 255,   1,   1, { 7387, 3860, 6037, 10560, 7909, }, { 1, 4, 2, 1, 2, }, true, 2000, nil, nil, nil, nil, 20219, },
	[12603] = { nil, 1,  9,  12603,  10514, 215, 215, 235, 255,   3,   3, { 10561, 10560, 10505, }, { 1, 1, 1, }, true, 1800, },
	[12614] = { nil, 1,  9,  12614,  10510, 220, 240, 250, 260,   1,   1, { 10559, 10560, 4400, 3860, 3864, }, { 2, 1, 1, 6, 2, }, nil, nil, { 10604, }, },
	[12607] = { nil, 1,  9,  12607,  10501, 220, 240, 250, 260,   1,   1, { 4304, 7909, 10592, }, { 4, 2, 1, }, nil, nil, { 10603, }, },
	[26442] = { nil, 1,  9,  26442,  21569, 225, 245, 255, 265,   1,   1, { 9060, 9061, 10560, 10561, }, { 1, 1, 1, 1, }, nil, nil, { 21738, }, },
	[12616] = { nil, 1,  9,  12616,  10518, 225, 245, 255, 265,   1,   1, { 4339, 10285, 10560, 10505, }, { 4, 2, 1, 4, }, nil, nil, { 10606, }, },
	[12905] = { nil, 1,  9,  12905,  10724, 225, 245, 255, 265,   1,   1, { 10026, 10559, 4234, 10505, 4389, }, { 1, 2, 4, 8, 4, }, true, 2200, nil, nil, nil, nil, 20219, },
	[12615] = { nil, 1,  9,  12615,  10502, 225, 245, 255, 265,   1,   1, { 4304, 7910, }, { 4, 2, }, nil, nil, { 10605, }, },
	[26423] = { nil, 1,  9,  26423,  21571, 225, 225, 237, 250,   3,   3, { 10505, 4304, }, { 1, 1, }, nil, nil, { 21730, }, },
	[12754] = { nil, 1,  9,  12754,  10586, 235, 235, 255, 275,   2,   2, { 10561, 9061, 10507, 10560, }, { 1, 1, 6, 1, }, true, 2600, nil, nil, nil, nil, 20222, },
	[8895]  = { nil, 1,  9,   8895,   7189, 225, 245, 255, 265,   1,   1, { 10026, 10559, 4234, 9061, 10560, }, { 1, 2, 4, 2, 1, }, true, 2200, },
	[26425] = { nil, 1,  9,  26425,  21576, 225, 225, 237, 250,   3,   3, { 10505, 4304, }, { 1, 1, }, nil, nil, { 21732, }, },
	[26424] = { nil, 1,  9,  26424,  21574, 225, 225, 237, 250,   3,   3, { 10505, 4304, }, { 1, 1, }, nil, nil, { 21731, }, },
	[12906] = { nil, 1,  9,  12906,  10725, 230, 250, 260, 270,   1,   1, { 10561, 6037, 3860, 9060, 10558, 1529, }, { 1, 6, 6, 2, 1, 2, }, true, 2400, nil, nil, nil, nil, 20219, },
	[12617] = { nil, 1,  9,  12617,  10506, 230, 250, 260, 270,   1,   1, { 3860, 10561, 6037, 818, 774, }, { 8, 1, 1, 4, 4, }, nil, nil, { 10607, }, },
	[12618] = { nil, 1,  9,  12618,  10503, 230, 250, 260, 270,   1,   1, { 4304, 7910, }, { 6, 2, }, true, 2200, },
	[12755] = { nil, 1,  9,  12755,  10587, 230, 230, 250, 270,   1,   1, { 10561, 10505, 6037, 10560, 4407, }, { 2, 4, 6, 1, 2, }, true, 2400, nil, nil, nil, nil, 20222, },
	[12619] = { nil, 1,  9,  12619,  10562, 235, 235, 255, 275,   4,   4, { 10561, 10560, 10505, }, { 2, 1, 2, }, true, 2400, },
	[12758] = { nil, 1,  9,  12758,  10588, 245, 265, 275, 285,   1,   1, { 10543, 9061, 3860, 10560, }, { 1, 4, 4, 1, }, true, 3000, nil, nil, nil, nil, 20222, },
	[12908] = { nil, 1,  9,  12908,  10727, 240, 260, 270, 280,   1,   1, { 10559, 9061, 3860, 6037, 10560, }, { 2, 4, 6, 6, 1, }, true, 2800, nil, nil, nil, nil, 20222, },
	[12620] = { nil, 1,  9,  12620,  10548, 240, 260, 270, 280,   1,   1, { 10559, 7910, 6037, }, { 1, 1, 2, }, nil, nil, { 10608, }, },
	[12759] = { nil, 1,  9,  12759,  10645, 240, 260, 270, 280,   1,   1, { 10559, 10560, 12808, 7972, 9060, }, { 2, 1, 1, 4, 1, }, true, 2800, nil, nil, nil, nil, 20219, },
	[12621] = { nil, 1,  9,  12621,  10513, 245, 245, 265, 285, 200, 200, { 3860, 10505, }, { 2, 2, }, true, 2800, },
	[12622] = { nil, 1,  9,  12622,  10504, 245, 265, 275, 285,   1,   1, { 4304, 1529, 7909, 10286, 8153, }, { 8, 3, 3, 2, 2, }, true, 2800, },
	[23070] = { nil, 1,  9,  23070,  18641, 250, 250, 260, 270,   2,   2, { 15992, 14047, }, { 2, 3, }, true, 5000, },
	[23507] = { nil, 1,  9,  23507,  19026, 250, 250, 260, 270,   4,   4, { 15992, 14047, 8150, }, { 2, 2, 1, }, nil, nil, { 19027, }, },
	[19567] = { nil, 1,  9,  19567,  15846, 250, 270, 280, 290,   1,   1, { 10561, 12359, 10558, 10560, }, { 1, 6, 1, 4, }, true, 4000, },
	[12624] = { nil, 1,  9,  12624,  10576, 250, 270, 280, 290,   1,   1, { 3860, 7077, 6037, 9060, 9061, 7910, }, { 14, 4, 4, 2, 2, 2, }, nil, nil, { 10609, }, },
	[26011] = { nil, 1,  9,  26011,  21277, 250, 320, 330, 340,   1,   1, { 15407, 15994, 7079, 18631, 10558, }, { 1, 4, 2, 2, 1, }, nil, nil, nil, { 8798, }, },
	[19788] = { nil, 1,  9,  19788,  15992, 250, 250, 255, 260,   1,   1, { 12365, }, { 2, }, true, 4000, },
	[19790] = { nil, 1,  9,  19790,  15993, 260, 280, 290, 300,   3,   3, { 15994, 12359, 15992, 14047, }, { 1, 3, 3, 3, }, nil, nil, { 16041, }, },
	[23486] = { nil, 1,  9,  23486,  18984, 260, 285, 295, 305,   1,   1, { 3860, 18631, 7077, 7910, 10586, }, { 10, 1, 4, 2, 1, }, true, 0, nil, nil, nil, nil, 20222, },
	[23129] = { nil, 1,  9,  23129,  18660, 260, 260, 265, 270,   1,   1, { 10561, 15994, 10558, 10560, 3864, }, { 1, 2, 1, 1, 1, }, nil, nil, { 18661, }, nil, nil, nil, 20219, },
	[23077] = { nil, 1,  9,  23077,  18634, 260, 280, 290, 300,   1,   1, { 15994, 18631, 12361, 7078, 3829, 13467, }, { 6, 2, 2, 4, 2, 4, }, nil, nil, { 18652, }, },
	[19792] = { nil, 1,  9,  19792,  15995, 260, 280, 290, 300,   1,   1, { 10559, 10561, 15994, 12359, 10546, }, { 2, 2, 2, 4, 1, }, nil, nil, { 16043, }, },
	[23071] = { nil, 1,  9,  23071,  18631, 260, 270, 275, 280,   1,   1, { 6037, 7067, 7069, }, { 2, 2, 1, }, nil, nil, { 18651, }, },
	[19791] = { nil, 1,  9,  19791,  15994, 260, 280, 290, 300,   1,   1, { 12359, 14047, }, { 3, 1, }, nil, nil, { 16042, }, },
	[23489] = { nil, 1,  9,  23489,  18986, 260, 285, 295, 305,   1,   1, { 3860, 18631, 7075, 7079, 7909, 9060, }, { 12, 2, 4, 2, 4, 1, }, true, 0, nil, nil, nil, nil, 20219, },
	[23078] = { nil, 1,  9,  23078,  18587, 265, 285, 295, 305,   1,   1, { 15994, 18631, 7191, 14227, 7910, }, { 2, 2, 2, 2, 2, }, nil, nil, { 18653, }, nil, nil, nil, 20222, },
	[19793] = { nil, 1,  9,  19793,  15996, 265, 285, 295, 305,   1,   1, { 12803, 15994, 10558, 8170, }, { 1, 4, 1, 1, }, nil, nil, { 16044, }, },
	[23096] = { nil, 1,  9,  23096,  18645, 265, 275, 280, 285,   1,   1, { 12359, 15994, 8170, 7910, 7191, }, { 4, 2, 4, 1, 1, }, nil, nil, { 18654, }, nil, nil, nil, 20219, },
	[19794] = { nil, 1,  9,  19794,  15999, 270, 290, 300, 310,   1,   1, { 10502, 7910, 12810, 14047, }, { 1, 4, 2, 8, }, nil, nil, { 16045, }, },
	[19814] = { nil, 1,  9,  19814,  16023, 275, 295, 305, 315,   1,   1, { 10561, 16000, 15994, 6037, 8170, 14047, }, { 1, 1, 2, 1, 2, 4, }, nil, nil, { 16046, }, },
	[26427] = { nil, 1,  9,  26427,  21716, 275, 275, 280, 285,   3,   3, { 15992, 8170, }, { 1, 1, }, nil, nil, { 21734, }, },
	[23079] = { nil, 2,  9,  23079,  18637, 275, 285, 290, 295,   1,   1, { 16000, 18631, 14047, }, { 2, 1, 2, }, nil, nil, { 18655, }, },
	[26443] = { nil, 1,  9,  26443,  21570, 275, 295, 305, 315,   1,   1, { 9060, 9061, 18631, 10561, }, { 4, 4, 2, 1, }, nil, nil, { 21737, }, },
	[19795] = { nil, 1,  9,  19795,  16000, 275, 295, 305, 315,   1,   1, { 12359, }, { 6, }, nil, nil, { 16047, }, },
	[26428] = { nil, 1,  9,  26428,  21718, 275, 275, 280, 285,   3,   3, { 15992, 8170, }, { 1, 1, }, nil, nil, { 21735, }, },
	[19796] = { nil, 1,  9,  19796,  16004, 275, 295, 305, 315,   1,   1, { 16000, 11371, 10546, 12361, 12799, 8170, }, { 2, 6, 2, 2, 2, 4, }, nil, nil, { 16048, }, },
	[26426] = { nil, 1,  9,  26426,  21714, 275, 275, 280, 285,   3,   3, { 15992, 8170, }, { 1, 1, }, nil, nil, { 21733, }, },
	[23080] = { nil, 1,  9,  23080,  18594, 275, 275, 285, 295,   1,   1, { 15994, 15992, 8170, 159, }, { 2, 3, 2, 1, }, nil, nil, { 18656, }, },
	[19800] = { nil, 1,  9,  19800,  15997, 285, 305, 315, 325, 200, 200, { 12359, 15992, }, { 2, 1, }, nil, nil, { 16051, }, },
	[19815] = { nil, 1,  9,  19815,  16006, 285, 305, 315, 325,   1,   1, { 12360, 14227, }, { 1, 1, }, nil, nil, { 16050, }, },
	[19799] = { nil, 1,  9,  19799,  16005, 285, 305, 315, 325,   3,   3, { 15994, 11371, 15992, 14047, }, { 2, 1, 3, 3, }, nil, nil, { 16049, }, },
	[23081] = { nil, 1,  9,  23081,  18638, 290, 310, 320, 330,   1,   1, { 11371, 18631, 7080, 7910, 12800, }, { 4, 3, 6, 4, 2, }, nil, nil, { 18657, }, },
	[19825] = { nil, 1,  9,  19825,  16008, 290, 310, 320, 330,   1,   1, { 10500, 12364, 12810, }, { 1, 2, 4, }, nil, nil, { 16053, }, },
	[19819] = { nil, 1,  9,  19819,  16009, 290, 310, 320, 330,   1,   1, { 16006, 10558, 15994, 12799, }, { 2, 1, 1, 1, }, nil, nil, { 16052, }, },
	[23082] = { nil, 1,  9,  23082,  18639, 300, 320, 330, 340,   1,   1, { 11371, 18631, 12803, 12808, 12800, 12799, }, { 8, 4, 6, 4, 2, 2, }, nil, nil, { 18658, }, },
	[19831] = { nil, 1,  9,  19831,  16040, 300, 320, 330, 340,   3,   3, { 16006, 12359, 14047, }, { 1, 3, 1, }, nil, nil, { 16055, }, },
	[22797] = { nil, 1,  9,  22797,  18168, 300, 320, 330, 340,   1,   1, { 12360, 16006, 7082, 12803, 7076, }, { 6, 2, 8, 12, 8, }, nil, nil, { 18291, }, },
	[22795] = { nil, 1,  9,  22795,  18282, 300, 320, 330, 340,   1,   1, { 17010, 17011, 12360, 16006, 16000, }, { 4, 2, 6, 2, 2, }, nil, nil, { 18292, }, },
	[22793] = { nil, 1,  9,  22793,  18283, 300, 320, 330, 340,   1,   1, { 17011, 7076, 16006, 11371, 16000, }, { 2, 2, 4, 6, 1, }, nil, nil, { 18290, }, },
	[19830] = { nil, 1,  9,  19830,  16022, 300, 320, 330, 340,   1,   1, { 10576, 16006, 12655, 15994, 10558, 12810, }, { 1, 8, 10, 6, 4, 6, }, nil, nil, { 16054, }, },
	[19833] = { nil, 1,  9,  19833,  16007, 300, 320, 330, 340,   1,   1, { 12360, 16000, 7078, 7076, 12800, 12810, }, { 10, 2, 2, 2, 2, 2, }, nil, nil, { 16056, }, },
	[22704] = { nil, 1,  9,  22704,  18232, 300, 320, 330, 340,   1,   1, { 12359, 8170, 7191, 7067, 7068, }, { 12, 4, 1, 2, 1, }, nil, nil, { 18235, }, },
	[24356] = { nil, 4,  9,  24356,  19999, 300, 320, 330, 340,   1,   1, { 19726, 19774, 16006, 12804, 12810, }, { 4, 5, 2, 8, 4, }, nil, nil, { 20000, }, },
	[24357] = { nil, 4,  9,  24357,  19998, 300, 320, 330, 340,   1,   1, { 19726, 19774, 16006, 12804, 12810, }, { 5, 5, 1, 8, 4, }, nil, nil, { 20001, }, },
	[7421]  = { nil, 1, 10,   7421,   6218,   1,   5,   7,  10,   1,   1, { 6217, 10940, 10938, }, { 1, 1, 1, }, },
	[7418]  = { nil, 1, 10,   7418,    nil,   1,  70,  90, 110,   1,   1, { 10940, }, { 1, }, },
	[7428]  = { nil, 1, 10,   7428,    nil,   1,  80, 100, 120,   1,   1, { 10938, 10940, }, { 1, 1, }, },
	[14293] = { nil, 1, 10,  14293,  11287,  10,  75,  95, 115,   1,   1, { 4470, 10938, }, { 1, 1, }, true, 50, },
	[7420]  = { nil, 1, 10,   7420,    nil,  15,  70,  90, 110,   1,   1, { 10940, }, { 1, }, true, 50, },
	[7443]  = { nil, 1, 10,   7443,    nil,  20,  80, 100, 120,   1,   1, { 10938, }, { 1, }, nil, nil, { 6342, }, },
	[7426]  = { nil, 1, 10,   7426,    nil,  40,  90, 110, 130,   1,   1, { 10940, 10938, }, { 2, 1, }, true, 100, },
	[7454]  = { nil, 1, 10,   7454,    nil,  45,  95, 115, 135,   1,   1, { 10940, 10938, }, { 1, 2, }, true, 100, },
	[25124] = { nil, 5, 10,  25124,  20744,  45,  55,  65,  75,   1,   1, { 10940, 17034, 3371, }, { 2, 1, 1, }, nil, nil, { 20758, }, },
	[7457]  = { nil, 1, 10,   7457,    nil,  50, 100, 120, 140,   1,   1, { 10940, }, { 3, }, true, 250, },
	[7748]  = { nil, 1, 10,   7748,    nil,  60, 105, 125, 145,   1,   1, { 10940, 10938, }, { 2, 2, }, true, 250, },
	[7766]  = { nil, 1, 10,   7766,    nil,  60, 105, 125, 145,   1,   1, { 10938, }, { 2, }, nil, nil, { 6344, }, },
	[14807] = { nil, 1, 10,  14807,  11288,  70, 110, 130, 150,   1,   1, { 4470, 10939, }, { 1, 1, }, true, 200, },
	[7771]  = { nil, 1, 10,   7771,    nil,  70, 110, 130, 150,   1,   1, { 10940, 10939, }, { 3, 1, }, true, 200, },
	[7776]  = { nil, 1, 10,   7776,    nil,  80, 115, 135, 155,   1,   1, { 10939, 10938, }, { 1, 1, }, nil, nil, { 6346, }, },
	[7782]  = { nil, 1, 10,   7782,    nil,  80, 115, 135, 155,   1,   1, { 10940, }, { 5, }, nil, nil, { 6347, }, },
	[7779]  = { nil, 1, 10,   7779,    nil,  80, 115, 135, 155,   1,   1, { 10940, 10939, }, { 2, 1, }, true, 400, },
	[7788]  = { nil, 1, 10,   7788,    nil,  90, 120, 140, 160,   1,   1, { 10940, 10939, 10978, }, { 2, 1, 1, }, true, 500, },
	[7786]  = { nil, 1, 10,   7786,    nil,  90, 120, 140, 160,   1,   1, { 10940, 10939, }, { 4, 2, }, nil, nil, { 6348, }, },
	[7793]  = { nil, 1, 10,   7793,    nil, 100, 130, 150, 170,   1,   1, { 10939, }, { 3, }, nil, nil, { 6349, }, },
	[7795]  = { nil, 1, 10,   7795,   6339, 100, 130, 150, 170,   1,   1, { 6338, 10940, 10939, 1210, }, { 1, 6, 3, 1, }, true, 1000, },
	[7745]  = { nil, 1, 10,   7745,    nil, 100, 130, 150, 170,   1,   1, { 10940, 10978, }, { 4, 1, }, true, 500, },
	[13378] = { nil, 1, 10,  13378,    nil, 105, 130, 150, 170,   1,   1, { 10998, 10940, }, { 1, 2, }, true, 600, },
	[13419] = { nil, 1, 10,  13419,    nil, 110, 135, 155, 175,   1,   1, { 10998, }, { 1, }, nil, nil, { 11039, }, },
	[13380] = { nil, 1, 10,  13380,    nil, 110, 135, 155, 175,   1,   1, { 10998, 10940, }, { 1, 6, }, nil, nil, { 11038, }, },
	[13464] = { nil, 1, 10,  13464,    nil, 115, 140, 160, 180,   1,   1, { 10998, 10940, 10978, }, { 1, 1, 1, }, nil, nil, { 11081, }, },
	[13421] = { nil, 1, 10,  13421,    nil, 115, 140, 160, 180,   1,   1, { 10940, 10978, }, { 6, 1, }, true, 800, },
	[7857]  = { nil, 1, 10,   7857,    nil, 120, 145, 165, 185,   1,   1, { 10940, 10998, }, { 4, 1, }, true, 1000, },
	[7859]  = { nil, 1, 10,   7859,    nil, 120, 145, 165, 185,   1,   1, { 10998, }, { 2, }, nil, nil, { 6375, }, },
	[7861]  = { nil, 1, 10,   7861,    nil, 125, 150, 170, 190,   1,   1, { 6371, 10998, }, { 1, 1, }, true, 1250, },
	[7863]  = { nil, 1, 10,   7863,    nil, 125, 150, 170, 190,   1,   1, { 10940, }, { 8, }, true, 1400, },
	[7867]  = { nil, 1, 10,   7867,    nil, 125, 150, 170, 190,   1,   1, { 10940, 10998, }, { 6, 2, }, nil, nil, { 6377, }, },
	[13501] = { nil, 1, 10,  13501,    nil, 130, 155, 175, 195,   1,   1, { 11083, }, { 2, }, true, 1500, },
	[13485] = { nil, 1, 10,  13485,    nil, 130, 155, 175, 195,   1,   1, { 10998, 10940, }, { 2, 4, }, true, 1500, },
	[13522] = { nil, 1, 10,  13522,    nil, 135, 160, 180, 200,   1,   1, { 11082, 6048, }, { 1, 1, }, nil, nil, { 11098, }, },
	[13503] = { nil, 1, 10,  13503,    nil, 140, 165, 185, 205,   1,   1, { 11083, 11084, }, { 2, 1, }, true, 2000, },
	[13536] = { nil, 1, 10,  13536,    nil, 140, 165, 185, 205,   1,   1, { 11083, }, { 2, }, nil, nil, { 11101, }, },
	[13538] = { nil, 1, 10,  13538,    nil, 140, 165, 185, 205,   1,   1, { 10940, 11082, 11084, }, { 2, 1, 1, }, true, 2500, },
	[13617] = { nil, 1, 10,  13617,    nil, 145, 170, 190, 210,   1,   1, { 11083, 3356, }, { 1, 3, }, nil, nil, { 11151, }, },
	[13620] = { nil, 1, 10,  13620,    nil, 145, 170, 190, 210,   1,   1, { 11083, 6370, }, { 1, 3, }, nil, nil, { 11152, }, },
	[13529] = { nil, 1, 10,  13529,    nil, 145, 170, 190, 210,   1,   1, { 11083, 11084, }, { 3, 1, }, true, 2400, },
	[13607] = { nil, 1, 10,  13607,    nil, 145, 170, 190, 210,   1,   1, { 11082, 10998, }, { 1, 2, }, true, 2400, },
	[13612] = { nil, 1, 10,  13612,    nil, 145, 170, 190, 210,   1,   1, { 11083, 2772, }, { 1, 3, }, nil, nil, { 11150, }, },
	[13628] = { nil, 1, 10,  13628,  11130, 150, 175, 195, 215,   1,   1, { 11128, 5500, 11082, 11083, }, { 1, 1, 2, 2, }, true, 2500, },
	[25125] = { nil, 5, 10,  25125,  20745, 150, 160, 170, 180,   1,   1, { 11083, 17034, 3372, }, { 3, 2, 1, }, nil, nil, { 20752, }, },
	[13622] = { nil, 1, 10,  13622,    nil, 150, 175, 195, 215,   1,   1, { 11082, }, { 2, }, true, 2500, },
	[13626] = { nil, 1, 10,  13626,    nil, 150, 175, 195, 215,   1,   1, { 11082, 11083, 11084, }, { 1, 1, 1, }, true, 2500, },
	[14809] = { nil, 1, 10,  14809,  11289, 155, 175, 195, 215,   1,   1, { 11291, 11134, 11083, }, { 1, 1, 1, }, true, 2600, },
	[13631] = { nil, 1, 10,  13631,    nil, 155, 175, 195, 215,   1,   1, { 11134, 11083, }, { 1, 1, }, true, 2600, },
	[13635] = { nil, 1, 10,  13635,    nil, 155, 175, 195, 215,   1,   1, { 11138, 11083, }, { 1, 3, }, true, 2600, },
	[13640] = { nil, 1, 10,  13640,    nil, 160, 180, 200, 220,   1,   1, { 11083, }, { 3, }, true, 2700, },
	[13637] = { nil, 1, 10,  13637,    nil, 160, 180, 200, 220,   1,   1, { 11083, 11134, }, { 1, 1, }, true, 2800, },
	[13642] = { nil, 1, 10,  13642,    nil, 165, 185, 205, 225,   1,   1, { 11134, }, { 1, }, true, 2800, },
	[13648] = { nil, 1, 10,  13648,    nil, 170, 190, 210, 230,   1,   1, { 11083, }, { 6, }, true, 2800, },
	[13646] = { nil, 1, 10,  13646,    nil, 170, 190, 210, 230,   1,   1, { 11134, 11083, }, { 1, 2, }, nil, nil, { 11163, }, },
	[13644] = { nil, 1, 10,  13644,    nil, 170, 190, 210, 230,   1,   1, { 11083, }, { 4, }, true, 2800, },
	[13655] = { nil, 1, 10,  13655,    nil, 175, 195, 215, 235,   1,   1, { 11134, 7067, 11138, }, { 1, 1, 1, }, nil, nil, { 11165, }, },
	[13657] = { nil, 1, 10,  13657,    nil, 175, 195, 215, 235,   1,   1, { 11134, 7068, }, { 1, 1, }, true, 3000, },
	[14810] = { nil, 1, 10,  14810,  11290, 175, 195, 215, 235,   1,   1, { 11291, 11135, 11137, }, { 1, 1, 1, }, true, 3000, },
	[13653] = { nil, 1, 10,  13653,    nil, 175, 195, 215, 235,   1,   1, { 11134, 5637, 11138, }, { 1, 2, 1, }, nil, nil, { 11164, }, },
	[13661] = { nil, 1, 10,  13661,    nil, 180, 200, 220, 240,   1,   1, { 11137, }, { 1, }, true, 3600, },
	[13659] = { nil, 1, 10,  13659,    nil, 180, 200, 220, 240,   1,   1, { 11135, 11137, }, { 1, 1, }, true, 3200, },
	[13663] = { nil, 1, 10,  13663,    nil, 185, 205, 225, 245,   1,   1, { 11135, }, { 1, }, true, 3800, },
	[21931] = { nil, 1, 10,  21931,    nil, 190, 210, 230, 250,   1,   1, { 11135, 11137, 11139, 3819, }, { 3, 3, 1, 2, }, nil, nil, { 17725, }, },
	[13687] = { nil, 1, 10,  13687,    nil, 190, 210, 230, 250,   1,   1, { 11135, 11134, }, { 1, 2, }, nil, nil, { 11167, }, },
	[13693] = { nil, 1, 10,  13693,    nil, 195, 215, 235, 255,   1,   1, { 11135, 11139, }, { 2, 1, }, true, 4000, },
	[13689] = { nil, 1, 10,  13689,    nil, 195, 215, 235, 255,   1,   1, { 11135, 11137, 11139, }, { 2, 2, 1, }, nil, nil, { 11168, }, },
	[13702] = { nil, 1, 10,  13702,  11145, 200, 220, 240, 260,   1,   1, { 11144, 7971, 11135, 11137, }, { 1, 1, 2, 2, }, true, 4000, },
	[13695] = { nil, 1, 10,  13695,    nil, 200, 220, 240, 260,   1,   1, { 11137, 11139, }, { 4, 1, }, true, 4000, },
	[25126] = { nil, 5, 10,  25126,  20746, 200, 210, 220, 230,   1,   1, { 11137, 17035, 3372, }, { 3, 2, 1, }, nil, nil, { 20753, }, },
	[13700] = { nil, 1, 10,  13700,    nil, 200, 220, 240, 260,   1,   1, { 11135, 11137, 11139, }, { 2, 2, 1, }, true, 4000, },
	[13698] = { nil, 1, 10,  13698,    nil, 200, 220, 240, 260,   1,   1, { 11137, 7392, }, { 1, 3, }, nil, nil, { 11166, }, },
	[13746] = { nil, 1, 10,  13746,    nil, 205, 225, 245, 265,   1,   1, { 11137, }, { 3, }, true, 4200, },
	[13794] = { nil, 1, 10,  13794,    nil, 205, 225, 245, 265,   1,   1, { 11174, }, { 1, }, true, 4200, },
	[13817] = { nil, 1, 10,  13817,    nil, 210, 230, 250, 270,   1,   1, { 11137, }, { 5, }, nil, nil, { 11202, }, },
	[13815] = { nil, 1, 10,  13815,    nil, 210, 230, 250, 270,   1,   1, { 11174, 11137, }, { 1, 1, }, true, 4400, },
	[13822] = { nil, 1, 10,  13822,    nil, 210, 230, 250, 270,   1,   1, { 11174, }, { 2, }, true, 4400, },
	[13841] = { nil, 1, 10,  13841,    nil, 215, 235, 255, 275,   1,   1, { 11137, 6037, }, { 3, 3, }, nil, nil, { 11203, }, },
	[13836] = { nil, 1, 10,  13836,    nil, 215, 235, 255, 275,   1,   1, { 11137, }, { 5, }, true, 4600, },
	[13846] = { nil, 1, 10,  13846,    nil, 220, 240, 260, 280,   1,   1, { 11174, 11137, }, { 3, 1, }, nil, nil, { 11204, }, },
	[13858] = { nil, 1, 10,  13858,    nil, 220, 240, 260, 280,   1,   1, { 11137, }, { 6, }, true, 4800, },
	[13890] = { nil, 1, 10,  13890,    nil, 225, 245, 265, 285,   1,   1, { 11177, 7909, 11174, }, { 1, 1, 1, }, true, 5000, },
	[13882] = { nil, 1, 10,  13882,    nil, 225, 245, 265, 285,   1,   1, { 11174, }, { 2, }, nil, nil, { 11206, }, },
	[13887] = { nil, 1, 10,  13887,    nil, 225, 245, 265, 285,   1,   1, { 11174, 11137, }, { 2, 3, }, true, 5000, },
	[13868] = { nil, 1, 10,  13868,    nil, 225, 245, 265, 285,   1,   1, { 11137, 8838, }, { 3, 3, }, nil, nil, { 11205, }, },
	[13917] = { nil, 1, 10,  13917,    nil, 230, 250, 270, 290,   1,   1, { 11175, 11174, }, { 1, 2, }, true, 5400, },
	[13915] = { nil, 1, 10,  13915,    nil, 230, 250, 270, 290,   1,   1, { 11177, 11176, 9224, }, { 1, 2, 1, }, nil, nil, { 11208, }, },
	[13905] = { nil, 1, 10,  13905,    nil, 230, 250, 270, 290,   1,   1, { 11175, 11176, }, { 1, 2, }, true, 5400, },
	[13935] = { nil, 1, 10,  13935,    nil, 235, 255, 275, 295,   1,   1, { 11175, }, { 2, }, true, 5800, },
	[13931] = { nil, 1, 10,  13931,    nil, 235, 255, 275, 295,   1,   1, { 11175, 11176, }, { 1, 2, }, nil, nil, { 11223, }, },
	[13933] = { nil, 1, 10,  13933,    nil, 235, 255, 275, 295,   1,   1, { 11178, 3829, }, { 1, 1, }, nil, nil, { 11224, }, },
	[13937] = { nil, 1, 10,  13937,    nil, 240, 260, 280, 300,   1,   1, { 11178, 11176, }, { 2, 2, }, true, 6200, },
	[13939] = { nil, 1, 10,  13939,    nil, 240, 260, 280, 300,   1,   1, { 11176, 11175, }, { 2, 1, }, true, 6200, },
	[13943] = { nil, 1, 10,  13943,    nil, 245, 265, 285, 305,   1,   1, { 11178, 11175, }, { 2, 2, }, true, 6200, },
	[13945] = { nil, 1, 10,  13945,    nil, 245, 265, 285, 305,   1,   1, { 11176, }, { 5, }, nil, nil, { 11225, }, },
	[13941] = { nil, 1, 10,  13941,    nil, 245, 265, 285, 305,   1,   1, { 11178, 11176, 11175, }, { 1, 3, 2, }, true, 6200, },
	[17181] = { nil, 1, 10,  17181,  12810, 250, 250, 255, 260,   1,   1, { 8170, 16202, }, { 1, 1, }, true, 10000, },
	[25127] = { nil, 5, 10,  25127,  20747, 250, 260, 270, 280,   1,   1, { 11176, 8831, 8925, }, { 3, 2, 1, }, nil, nil, { 20754, }, },
	[13947] = { nil, 1, 10,  13947,    nil, 250, 270, 290, 310,   1,   1, { 11178, 11176, }, { 2, 3, }, nil, nil, { 11226, }, },
	[17180] = { nil, 1, 10,  17180,  12655, 250, 250, 255, 260,   1,   1, { 12359, 11176, }, { 1, 3, }, true, 10000, },
	[13948] = { nil, 1, 10,  13948,    nil, 250, 270, 290, 310,   1,   1, { 11178, 8153, }, { 2, 2, }, true, 6500, },
	[20008] = { nil, 1, 10,  20008,    nil, 255, 275, 295, 315,   1,   1, { 16202, }, { 3, }, nil, nil, { 16214, }, },
	[20020] = { nil, 1, 10,  20020,    nil, 260, 280, 300, 320,   1,   1, { 11176, }, { 10, }, nil, nil, { 16215, }, },
	[20014] = { nil, 1, 10,  20014,    nil, 265, 285, 305, 325,   1,   1, { 16202, 7077, 7075, 7079, 7081, 7972, }, { 2, 1, 1, 1, 1, 1, }, nil, nil, { 16216, }, },
	[20017] = { nil, 1, 10,  20017,    nil, 265, 285, 305, 325,   1,   1, { 11176, }, { 10, }, nil, nil, { 16217, }, },
	[15596] = { nil, 1, 10,  15596,  11811, 265, 285, 305, 325,   1,   1, { 11382, 7078, 14343, }, { 1, 1, 3, }, nil, nil, { 11813, }, },
	[13898] = { nil, 1, 10,  13898,    nil, 265, 285, 305, 325,   1,   1, { 11177, 7078, }, { 4, 1, }, nil, nil, { 11207, }, },
	[20012] = { nil, 1, 10,  20012,    nil, 270, 290, 310, 330,   1,   1, { 16202, 16204, }, { 3, 3, }, nil, nil, { 16219, }, },
	[20009] = { nil, 1, 10,  20009,    nil, 270, 290, 310, 330,   1,   1, { 16202, 11176, }, { 3, 10, }, nil, nil, { 16218, }, },
	[20026] = { nil, 1, 10,  20026,    nil, 275, 295, 315, 335,   1,   1, { 16204, 14343, }, { 6, 1, }, nil, nil, { 16221, }, },
	[20024] = { nil, 1, 10,  20024,    nil, 275, 295, 315, 335,   1,   1, { 16203, 16202, }, { 2, 1, }, nil, nil, { 16220, }, },
	[25128] = { nil, 5, 10,  25128,  20750, 275, 285, 295, 305,   1,   1, { 16204, 4625, 8925, }, { 3, 2, 1, }, nil, nil, { 20755, }, },
	[20016] = { nil, 1, 10,  20016,    nil, 280, 300, 320, 340,   1,   1, { 16203, 16204, }, { 2, 4, }, nil, nil, { 16222, }, },
	[20029] = { nil, 1, 10,  20029,    nil, 285, 305, 325, 345,   1,   1, { 14343, 7080, 7082, 13467, }, { 4, 1, 1, 1, }, nil, nil, { 16223, }, },
	[20015] = { nil, 1, 10,  20015,    nil, 285, 305, 325, 345,   1,   1, { 16204, }, { 8, }, nil, nil, { 16224, }, },
	[20051] = { nil, 1, 10,  20051,  16207, 290, 310, 330, 350,   1,   1, { 16206, 13926, 16204, 16203, 14343, 14344, }, { 1, 1, 10, 4, 4, 2, }, nil, nil, { 16243, }, },
	[23799] = { nil, 3, 10,  23799,    nil, 290, 310, 330, 350,   1,   1, { 14344, 16203, 16204, 7076, }, { 6, 6, 4, 2, }, nil, nil, { 19444, }, },
	[23801] = { nil, 3, 10,  23801,    nil, 290, 310, 330, 350,   1,   1, { 16204, 16203, 7080, }, { 16, 4, 2, }, nil, nil, { 19446, }, },
	[20028] = { nil, 1, 10,  20028,    nil, 290, 310, 330, 350,   1,   1, { 16203, 14343, }, { 3, 1, }, nil, nil, { 16242, }, },
	[27837] = { nil, 5, 10,  27837,    nil, 290, 310, 330, 350,   1,   1, { 14344, 16203, 16204, 7082, }, { 10, 6, 14, 4, }, nil, nil, { 22392, }, },
	[23800] = { nil, 3, 10,  23800,    nil, 290, 310, 330, 350,   1,   1, { 14344, 16203, 16204, 7082, }, { 6, 6, 4, 2, }, nil, nil, { 19445, }, },
	[20010] = { nil, 1, 10,  20010,    nil, 295, 315, 335, 355,   1,   1, { 16204, 16203, }, { 6, 6, }, nil, nil, { 16246, }, },
	[20030] = { nil, 1, 10,  20030,    nil, 295, 315, 335, 355,   1,   1, { 14344, 16204, }, { 4, 10, }, nil, nil, { 16247, }, },
	[20033] = { nil, 1, 10,  20033,    nil, 295, 315, 335, 355,   1,   1, { 14344, 12808, }, { 4, 4, }, nil, nil, { 16248, }, },
	[20013] = { nil, 1, 10,  20013,    nil, 295, 315, 335, 355,   1,   1, { 16203, 16204, }, { 4, 4, }, nil, nil, { 16244, }, },
	[20023] = { nil, 1, 10,  20023,    nil, 295, 315, 335, 355,   1,   1, { 16203, }, { 8, }, nil, nil, { 16245, }, },
	[25074] = { nil, 5, 10,  25074,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 7080, }, { 3, 10, 4, }, nil, nil, { 20728, }, },
	[22750] = { nil, 1, 10,  22750,    nil, 300, 320, 340, 360,   1,   1, { 14344, 16203, 12803, 7080, 12811, }, { 4, 8, 6, 6, 1, }, nil, nil, { 18260, }, },
	[20031] = { nil, 1, 10,  20031,    nil, 300, 320, 340, 360,   1,   1, { 14344, 16203, }, { 2, 10, }, nil, nil, { 16250, }, },
	[20034] = { nil, 1, 10,  20034,    nil, 300, 320, 340, 360,   1,   1, { 14344, 12811, }, { 4, 2, }, nil, nil, { 16252, }, },
	[25080] = { nil, 5, 10,  25080,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 7082, }, { 3, 8, 4, }, nil, nil, { 20731, }, },
	[25072] = { nil, 5, 10,  25072,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 18512, }, { 4, 6, 8, }, nil, nil, { 20726, }, },
	[20011] = { nil, 1, 10,  20011,    nil, 300, 320, 340, 360,   1,   1, { 16204, }, { 15, }, nil, nil, { 16251, }, },
	[22749] = { nil, 1, 10,  22749,    nil, 300, 320, 340, 360,   1,   1, { 14344, 16203, 7078, 7080, 7082, 13926, }, { 4, 12, 4, 4, 4, 2, }, nil, nil, { 18259, }, },
	[25079] = { nil, 5, 10,  25079,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 12811, }, { 3, 8, 1, }, nil, nil, { 20730, }, },
	[25073] = { nil, 5, 10,  25073,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 12808, }, { 3, 10, 6, }, nil, nil, { 20727, }, },
	[23803] = { nil, 3, 10,  23803,    nil, 300, 320, 340, 360,   1,   1, { 14344, 16203, 16204, }, { 10, 8, 15, }, nil, nil, { 19448, }, },
	[25083] = { nil, 5, 10,  25083,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 13468, }, { 3, 8, 2, }, nil, nil, { 20734, }, },
	[20032] = { nil, 1, 10,  20032,    nil, 300, 320, 340, 360,   1,   1, { 14344, 12808, 12803, }, { 6, 6, 6, }, nil, nil, { 16254, }, },
	[25129] = { nil, 5, 10,  25129,  20749, 300, 310, 320, 330,   1,   1, { 14344, 4625, 18256, }, { 2, 3, 1, }, nil, nil, { 20756, }, },
	[25130] = { nil, 5, 10,  25130,  20748, 300, 310, 320, 330,   1,   1, { 14344, 8831, 18256, }, { 2, 3, 1, }, nil, nil, { 20757, }, },
	[25078] = { nil, 5, 10,  25078,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 7078, }, { 2, 10, 4, }, nil, nil, { 20729, }, },
	[20035] = { nil, 1, 10,  20035,    nil, 300, 320, 340, 360,   1,   1, { 16203, 14344, }, { 12, 2, }, nil, nil, { 16255, }, },
	[25082] = { nil, 5, 10,  25082,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 12803, }, { 2, 8, 4, }, nil, nil, { 20733, }, },
	[23802] = { nil, 3, 10,  23802,    nil, 300, 320, 340, 360,   1,   1, { 14344, 16204, 16203, 12803, }, { 2, 20, 4, 6, }, nil, nil, { 19447, }, },
	[25084] = { nil, 5, 10,  25084,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 11754, }, { 4, 6, 2, }, nil, nil, { 20735, }, },
	[20036] = { nil, 1, 10,  20036,    nil, 300, 320, 340, 360,   1,   1, { 16203, 14344, }, { 12, 2, }, nil, nil, { 16249, }, },
	[23804] = { nil, 3, 10,  23804,    nil, 300, 320, 340, 360,   1,   1, { 14344, 16203, 16204, }, { 15, 12, 20, }, nil, nil, { 19449, }, },
	[25081] = { nil, 5, 10,  25081,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 7078, }, { 3, 8, 4, }, nil, nil, { 20732, }, },
	[20025] = { nil, 1, 10,  20025,    nil, 300, 320, 340, 360,   1,   1, { 14344, 16204, 16203, }, { 4, 15, 10, }, nil, nil, { 16253, }, },
	[25086] = { nil, 5, 10,  25086,    nil, 300, 320, 340, 360,   1,   1, { 20725, 14344, 12809, }, { 3, 8, 8, }, nil, nil, { 20736, }, },
	[3420]  = { nil, 1, 13,   3420,   3775,   1, 125, 150, 175,   1,   1, { 2930, 3371, }, { 1, 1, }, true, 3000, },
	[8681]  = { nil, 1, 13,   8681,   6947,   1, 125, 150, 175,   1,   1, { 2928, 3371, }, { 1, 1, }, true, 0, },
	[5763]  = { nil, 1, 13,   5763,   5237, 100, 150, 175, 200,   1,   1, { 2928, 2930, 3371, }, { 1, 1, 1, }, true, 5000, },
	[8687]  = { nil, 1, 13,   8687,   6949, 120, 165, 190, 215,   1,   1, { 2928, 3372, }, { 3, 1, }, true, 8000, },
	[2835]  = { nil, 1, 13,   2835,   2892, 130, 175, 200, 225,   1,   1, { 5173, 3372, }, { 1, 1, }, true, 10000, },
	[13220] = { nil, 1, 13,  13220,  10918, 140, 185, 210, 235,   1,   1, { 2930, 5173, 3372, }, { 1, 1, 1, }, true, 12000, },
	[6510]  = { nil, 1, 13,   6510,   5530, 150, 170, 195, 220,   3,   3, { 3818, }, { 1, }, true, 14000, },
	[8691]  = { nil, 1, 13,   8691,   6950, 160, 205, 230, 255,   1,   1, { 8924, 3372, }, { 1, 1, }, true, 16000, },
	[2837]  = { nil, 1, 13,   2837,   2893, 170, 215, 240, 265,   1,   1, { 5173, 3372, }, { 2, 1, }, true, 18000, },
	[8694]  = { nil, 1, 13,   8694,   6951, 170, 215, 240, 265,   1,   1, { 2928, 2930, 3372, }, { 4, 4, 1, }, true, 18000, },
	[13228] = { nil, 1, 13,  13228,  10920, 180, 225, 250, 275,   1,   1, { 2930, 5173, 3372, }, { 1, 2, 1, }, true, 20000, },
	[11341] = { nil, 1, 13,  11341,   8926, 200, 245, 270, 295,   1,   1, { 8924, 8925, }, { 2, 1, }, true, 29000, },
	[11357] = { nil, 1, 13,  11357,   8984, 210, 255, 280, 305,   1,   1, { 5173, 8925, }, { 3, 1, }, true, 31000, },
	[13229] = { nil, 1, 13,  13229,  10921, 220, 265, 290, 315,   1,   1, { 8923, 5173, 8925, }, { 1, 2, 1, }, true, 33000, },
	[3421]  = { nil, 1, 13,   3421,   3776, 230, 275, 300, 325,   1,   1, { 8923, 8925, }, { 3, 1, }, true, 35000, },
	[11400] = { nil, 1, 13,  11400,   9186, 240, 285, 310, 335,   1,   1, { 8924, 8923, 8925, }, { 2, 2, 1, }, true, 46000, },
	[11342] = { nil, 1, 13,  11342,   8927, 240, 285, 310, 335,   1,   1, { 8924, 8925, }, { 3, 1, }, true, 46000, },
	[11358] = { nil, 1, 13,  11358,   8985, 250, 295, 320, 345,   1,   1, { 5173, 8925, }, { 5, 1, }, true, 48000, },
	[13230] = { nil, 1, 13,  13230,  10922, 260, 305, 330, 355,   1,   1, { 8923, 5173, 8925, }, { 2, 2, 1, }, true, 50000, },
	[11343] = { nil, 1, 13,  11343,   8928, 280, 325, 350, 375,   1,   1, { 8924, 8925, }, { 4, 1, }, true, 54000, },
	[25347] = { nil, 5, 13,  25347,  20844, 300, 300, 325, 350,   1,   1, { 5173, 8925, }, { 7, 1, }, nil, nil, { 21302, }, },

--	Extra
	[19566] = { nil, 1,  3,  19566,  15409, 275, 275, 275, 275,   1,   1, { 8150, }, { 1, }, },

--	Other
	--	套牌
	[23677] = { nil, 1, -1,  23677,  19228,   0,   0,   0,   0,   1,   1, { 19227, 19230, 19231, 19232, 19233, 19234, 19235, 19236, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	野兽
	[23678] = { nil, 1, -1,  23678,  19257,   0,   0,   0,   0,   1,   1, { 19258, 19259, 19260, 19261, 19262, 19263, 19264, 19265, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	督军
	[23679] = { nil, 1, -1,  23679,  19267,   0,   0,   0,   0,   1,   1, { 19268, 19269, 19270, 19271, 19272, 19273, 19274, 19275, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	元素
	[23680] = { nil, 1, -1,  23680,  19277,   0,   0,   0,   0,   1,   1, { 19276, 19278, 19279, 19280, 19281, 19282, 19283, 19284, }, { 1, 1, 1, 1, 1, 1, 1, 1, }, },	--	入口
	--	高级铸甲技术
	[23231] = { nil, 1, -1,  23231,  18769,   0,   0,   0,   0,   1,   1, { 18779, 18780, }, { 1, 1, }, },
	[23232] = { nil, 1, -1,  23232,  18770,   0,   0,   0,   0,   1,   1, { 18781, 18782, }, { 1, 1, }, },
	[23233] = { nil, 1, -1,  23233,  18771,   0,   0,   0,   0,   1,   1, { 18783, 18784, }, { 1, 1, }, },
	--	祈福
	[23151] = { nil, 1, -1,  23151,  18608,   0,   0,   0,   0,   1,   1, { 18646, 18659, 18665, }, { 1, 1, 1, }, },
	--	伦鲁迪洛尔，上古守护者的长弓
	-- [23192] = { nil, 1, -1,  23192,  18713,   0,   0,   0,   0,   1,   1, { 18707, 18724, }, { 1, 1, }, },
	--	科尔戈的藏宝图
	[11438] = { nil, 1, -1,  11438,   9254,   0,   0,   0,   0,   1,   1, { 9251, 9252, 9253, }, { 1, 1, 1, }, },
};
DataAgent.T_Recipe_Data = T_Recipe_Data;
-- local T_TradeSkill_RecipeList = {  };	--	[pid] = { sid }
-- for sid, info in next, T_Recipe_Data do
-- 	local pid = info[3];
-- 	T_TradeSkill_RecipeList[pid] = T_TradeSkill_RecipeList[pid] or {  };
-- 	tinsert(T_TradeSkill_RecipeList[pid], sid);
-- end
local T_TradeSkill_RecipeList = {	--	[pid] = { sid }
	[1] = {
		3275,
		3276,
		7934,
		3277,
		3278,
		7935,
		7928,
		7929,
		10840,
		10841,
		18629,
		18630,
		23787,
	},
	[2] = {
		3115,
		2663,
		2660,
		12260,
		2662,
		2737,
		2738,
		3319,
		2739,
		3320,
		8880,
		9983,
		3293,
		2661,
		3321,
		3323,
		3324,
		3325,
		7408,
		2665,
		3116,
		3294,
		2666,
		3326,
		2667,
		2664,
		7817,
		3292,
		19666,
		3491,
		8367,
		7818,
		2668,
		2670,
		2740,
		3328,
		2741,
		6517,
		2672,
		2742,
		9985,
		2674,
		3330,
		3117,
		3295,
		3337,
		3331,
		9986,
		3296,
		2673,
		9987,
		3333,
		6518,
		3297,
		3334,
		2675,
		14379,
		8768,
		3336,
		7221,
		19667,
		3506,
		3494,
		12259,
		3492,
		3504,
		9813,
		9811,
		7222,
		3501,
		3495,
		3502,
		3507,
		9814,
		3505,
		3493,
		3496,
		3508,
		15972,
		9818,
		3498,
		9820,
		3513,
		7223,
		7224,
		21913,
		3503,
		15973,
		3511,
		9916,
		9920,
		9918,
		19668,
		9921,
		3497,
		11454,
		14380,
		3500,
		3515,
		11643,
		9928,
		9926,
		9931,
		9933,
		9980,
		9993,
		9972,
		9979,
		9937,
		9935,
		9957,
		9939,
		9945,
		9950,
		9995,
		9952,
		9997,
		9961,
		10001,
		9959,
		9964,
		10003,
		9968,
		9966,
		10005,
		9954,
		10007,
		9970,
		10009,
		9974,
		16639,
		16643,
		16641,
		16642,
		16640,
		10011,
		10013,
		16644,
		16645,
		10015,
		15292,
		16647,
		16646,
		16648,
		16649,
		16650,
		15293,
		16970,
		16969,
		20201,
		16651,
		19669,
		15294,
		15295,
		16973,
		16653,
		16971,
		16978,
		16652,
		15296,
		16667,
		16983,
		16654,
		16660,
		23632,
		16984,
		16656,
		16655,
		23628,
		16985,
		16658,
		16659,
		16661,
		20874,
		20872,
		16657,
		28461,
		23652,
		23650,
		28463,
		16993,
		22757,
		16988,
		28244,
		16742,
		27585,
		27830,
		16732,
		27832,
		16741,
		16744,
		27587,
		27588,
		16731,
		16995,
		20890,
		16729,
		27829,
		16746,
		20876,
		23633,
		23629,
		20897,
		16664,
		24136,
		23636,
		20873,
		21161,
		23637,
		24141,
		23653,
		16745,
		16994,
		16728,
		16726,
		16725,
		16724,
		16991,
		16662,
		16663,
		16990,
		16992,
		28243,
		24139,
		28462,
		24914,
		24137,
		16730,
		24138,
		23638,
		27586,
		27589,
		24140,
		24913,
		28242,
		16665,
		24912,
		24399,
		23639,
		27590,
	},
	[3] = {
		2881,
		7126,
		9058,
		9059,
		2152,
		2149,
		2153,
		3753,
		9060,
		9062,
		9064,
		3816,
		2160,
		5244,
		2161,
		3756,
		2163,
		2162,
		9065,
		3759,
		2164,
		3763,
		2159,
		3761,
		8322,
		2158,
		7953,
		6702,
		6703,
		9068,
		2167,
		3762,
		2169,
		20648,
		9070,
		3817,
		24940,
		2165,
		7133,
		7954,
		2168,
		7135,
		7955,
		3765,
		2166,
		9074,
		3767,
		9072,
		9145,
		3766,
		3768,
		3770,
		9146,
		9147,
		3769,
		9148,
		3764,
		9149,
		9194,
		20649,
		23190,
		3771,
		3818,
		3760,
		9193,
		3780,
		23399,
		3772,
		7147,
		3774,
		4096,
		9195,
		4097,
		6704,
		7149,
		3775,
		7151,
		9196,
		9197,
		3773,
		3776,
		9198,
		3778,
		9201,
		7153,
		6661,
		21943,
		6705,
		9202,
		7156,
		3777,
		9206,
		3779,
		10490,
		22711,
		10487,
		9208,
		9207,
		10482,
		20650,
		10499,
		10509,
		10507,
		10518,
		10516,
		10511,
		10520,
		10529,
		10533,
		10525,
		10531,
		14930,
		10542,
		10621,
		10544,
		10619,
		10546,
		14932,
		10630,
		10552,
		10558,
		10554,
		10548,
		10556,
		10564,
		10560,
		10562,
		10566,
		10568,
		10572,
		10632,
		10570,
		10647,
		19047,
		10574,
		19058,
		22331,
		19048,
		10650,
		19050,
		19049,
		19053,
		19051,
		19052,
		19055,
		19062,
		19060,
		19059,
		19061,
		19067,
		19064,
		19065,
		19063,
		19066,
		19068,
		19073,
		19072,
		19071,
		19070,
		24655,
		19080,
		19074,
		19078,
		19079,
		22815,
		19076,
		19077,
		19075,
		19086,
		19084,
		19081,
		23703,
		23705,
		19082,
		19085,
		19083,
		20853,
		19088,
		19089,
		19090,
		19087,
		24846,
		19094,
		24121,
		19092,
		19100,
		23708,
		23706,
		24850,
		19091,
		28219,
		19098,
		24848,
		24849,
		24851,
		28220,
		28224,
		28472,
		28221,
		28223,
		28473,
		28222,
		23704,
		24703,
		24123,
		22727,
		23707,
		20855,
		22928,
		20854,
		22926,
		26279,
		22923,
		22922,
		24124,
		24847,
		24125,
		22921,
		24122,
		28474,
		19102,
		19101,
		22927,
		19093,
		19104,
		19097,
		19107,
		23710,
		19103,
		19095,
		23709,
		19054,
		24654,
	},
	[4] = {
		7183,
		2330,
		2329,
		3170,
		2331,
		2332,
		4508,
		2334,
		3230,
		2337,
		6617,
		2335,
		7836,
		8240,
		3171,
		7179,
		7255,
		7841,
		3172,
		3447,
		3173,
		3174,
		3176,
		7837,
		3177,
		7256,
		2333,
		7845,
		3188,
		6624,
		7181,
		3452,
		7257,
		3448,
		3449,
		6618,
		3450,
		3451,
		11449,
		21923,
		7258,
		7259,
		3453,
		11450,
		3454,
		12609,
		11448,
		11451,
		11452,
		11453,
		11456,
		4942,
		22808,
		11457,
		11459,
		11480,
		11479,
		11458,
		11460,
		15833,
		11464,
		11465,
		11461,
		11466,
		11468,
		11467,
		11473,
		11472,
		11478,
		3175,
		11477,
		11476,
		26277,
		17551,
		17552,
		17553,
		17554,
		17555,
		17556,
		17557,
		17559,
		17560,
		17561,
		17562,
		17563,
		17564,
		17565,
		17566,
		17187,
		24365,
		24366,
		17571,
		17570,
		24367,
		17572,
		17573,
		17575,
		17577,
		17578,
		17574,
		24368,
		17576,
		17580,
		17634,
		17635,
		22732,
		17637,
		17636,
		25146,
		24266,
		17638,
	},
	[6] = {
		2540,
		7752,
		7751,
		15935,
		21143,
		2538,
		8604,
		2539,
		6412,
		6413,
		2795,
		6414,
		21144,
		8607,
		2541,
		7754,
		6416,
		6415,
		7753,
		7827,
		2542,
		6499,
		9513,
		3371,
		2543,
		2544,
		25704,
		3370,
		2546,
		8238,
		2545,
		3372,
		6417,
		6501,
		2547,
		7755,
		2549,
		6418,
		3397,
		3377,
		2548,
		6419,
		3373,
		15853,
		13028,
		3398,
		6500,
		3376,
		24418,
		3399,
		15865,
		15863,
		25954,
		4094,
		20916,
		3400,
		7213,
		7828,
		15855,
		15861,
		15856,
		21175,
		15910,
		15906,
		15933,
		18241,
		18238,
		15915,
		22480,
		20626,
		18239,
		18240,
		18242,
		18244,
		18243,
		18245,
		22761,
		18247,
		18246,
		24801,
		25659,
	},
	[7] = {
		2657,
		2659,
		3304,
		2658,
		3307,
		3308,
		3569,
		10097,
		10098,
		14891,
		16153,
		22967,
	},
	[8] = {
		2387,
		2393,
		2963,
		12044,
		3915,
		2385,
		8776,
		12045,
		7624,
		7623,
		3914,
		3840,
		2392,
		2394,
		8465,
		2389,
		3755,
		7629,
		7630,
		2397,
		3841,
		2386,
		7633,
		2396,
		3842,
		2395,
		6686,
		2964,
		2402,
		12046,
		3845,
		3757,
		2399,
		3843,
		6521,
		3758,
		2401,
		3847,
		3844,
		7639,
		2406,
		2403,
		3850,
		3866,
		3848,
		8467,
		7643,
		6688,
		12047,
		3849,
		7892,
		7893,
		3851,
		3839,
		3868,
		3855,
		3852,
		3869,
		6690,
		8758,
		3856,
		8760,
		3854,
		8780,
		3859,
		8782,
		6692,
		3813,
		3870,
		8762,
		8483,
		3857,
		8784,
		8764,
		3858,
		3871,
		8489,
		8772,
		8786,
		3860,
		8766,
		6693,
		3865,
		3863,
		8774,
		8789,
		6695,
		8791,
		3861,
		3872,
		8793,
		21945,
		8795,
		8770,
		8799,
		8797,
		3862,
		3864,
		3873,
		8802,
		12048,
		12049,
		12052,
		12050,
		8804,
		12060,
		12055,
		12056,
		12061,
		12059,
		12053,
		12064,
		12070,
		12066,
		12065,
		12067,
		27658,
		12069,
		12071,
		12075,
		12074,
		12072,
		12073,
		12078,
		12077,
		12076,
		12080,
		12079,
		12082,
		12084,
		12085,
		12081,
		12089,
		12088,
		12086,
		26407,
		12093,
		18560,
		26403,
		18401,
		12092,
		12091,
		18403,
		18402,
		18404,
		18408,
		26085,
		18407,
		18406,
		18405,
		18411,
		18410,
		18409,
		18412,
		18415,
		18413,
		18414,
		18420,
		18418,
		18416,
		18422,
		27724,
		27659,
		18419,
		18417,
		18421,
		18434,
		18423,
		18424,
		22813,
		26086,
		18436,
		18438,
		18437,
		23662,
		19435,
		18442,
		23664,
		18439,
		18440,
		18441,
		18444,
		27725,
		24903,
		18452,
		26087,
		24902,
		18457,
		28209,
		22866,
		23665,
		24901,
		28482,
		18454,
		22867,
		22870,
		18458,
		28208,
		20848,
		28481,
		22759,
		24091,
		18453,
		28210,
		18446,
		28480,
		23663,
		18449,
		28207,
		23666,
		18455,
		23667,
		18448,
		28205,
		24092,
		18450,
		18447,
		24093,
		22902,
		22868,
		18456,
		18451,
		22869,
		20849,
		18445,
		27660,
	},
	[9] = {
		3919,
		3918,
		3920,
		3923,
		3922,
		3924,
		3925,
		7430,
		3977,
		3926,
		3928,
		3929,
		3931,
		3930,
		3932,
		3973,
		3934,
		8339,
		3933,
		8334,
		3938,
		3937,
		3936,
		3978,
		3941,
		3939,
		3940,
		3942,
		3944,
		26418,
		3946,
		9269,
		26417,
		3947,
		26416,
		3945,
		3949,
		6458,
		3950,
		3952,
		3953,
		3954,
		3956,
		23066,
		23067,
		12584,
		3955,
		9271,
		23068,
		3957,
		3959,
		3958,
		3960,
		9273,
		3961,
		26421,
		12587,
		26420,
		3963,
		12586,
		12585,
		12590,
		3962,
		26422,
		3979,
		3965,
		8243,
		3966,
		3967,
		21940,
		3968,
		12589,
		12895,
		15255,
		23069,
		3971,
		3969,
		3972,
		12591,
		12715,
		12594,
		12760,
		15628,
		12717,
		12899,
		13240,
		12716,
		15633,
		12718,
		12595,
		12596,
		12897,
		12902,
		12597,
		12599,
		12907,
		12903,
		12603,
		12614,
		12607,
		26442,
		12616,
		12905,
		12615,
		26423,
		12754,
		8895,
		26425,
		26424,
		12906,
		12617,
		12618,
		12755,
		12619,
		12758,
		12908,
		12620,
		12759,
		12621,
		12622,
		23070,
		23507,
		19567,
		12624,
		26011,
		19788,
		19790,
		23486,
		23129,
		23077,
		19792,
		23071,
		19791,
		23489,
		23078,
		19793,
		23096,
		19794,
		19814,
		26427,
		23079,
		26443,
		19795,
		-- 28327,
		26428,
		19796,
		26426,
		23080,
		19800,
		19815,
		19799,
		23081,
		19825,
		19819,
		23082,
		19831,
		22797,
		22795,
		22793,
		19830,
		19833,
		22704,
		24356,
		24357,
	},
	[10] = {
		7421,
		7418,
		14293,
		7420,
		7443,
		7426,
		7454,
		25124,
		7457,
		7748,
		7766,
		14807,
		7771,
		7776,
		7428,
		7782,
		7779,
		7788,
		7786,
		7793,
		7795,
		7745,
		13378,
		13419,
		13380,
		13464,
		13421,
		7857,
		7859,
		7861,
		7863,
		7867,
		13501,
		13485,
		13522,
		13503,
		13536,
		13538,
		13617,
		13620,
		13529,
		13607,
		13612,
		13628,
		25125,
		13622,
		13626,
		14809,
		13631,
		13635,
		13640,
		13637,
		13642,
		13648,
		13646,
		13644,
		13655,
		13657,
		14810,
		13653,
		13661,
		13659,
		13663,
		21931,
		13687,
		13693,
		13689,
		13702,
		13695,
		25126,
		13700,
		13698,
		13746,
		13794,
		13817,
		13815,
		13822,
		13841,
		13836,
		13846,
		13858,
		13890,
		13882,
		13887,
		13868,
		13917,
		13915,
		13905,
		13935,
		13931,
		13933,
		13937,
		13939,
		13943,
		13945,
		13941,
		17181,
		25127,
		13947,
		17180,
		13948,
		20008,
		20020,
		20014,
		20017,
		15596,
		13898,
		20012,
		20009,
		20026,
		20024,
		25128,
		20016,
		20029,
		20015,
		20051,
		23799,
		23801,
		20028,
		27837,
		23800,
		20010,
		20030,
		20033,
		20013,
		20023,
		25074,
		22750,
		20031,
		20034,
		25080,
		25072,
		20011,
		22749,
		25079,
		25073,
		23803,
		25083,
		20032,
		25129,
		25130,
		25078,
		20035,
		25082,
		23802,
		25084,
		20036,
		23804,
		25081,
		20025,
		25086,
	},
	[13] = {
		3420,
		8681,
		5763,
		8687,
		2835,
		13220,
		6510,
		8691,
		2837,
		8694,
		13228,
		11341,
		11357,
		13229,
		3421,
		11400,
		11342,
		11358,
		13230,
		11343,
		25347,
	},
	[-1] = {
		--	套牌
		23677,
		23678,
		23679,
		23680,
		--	高级铸甲技术
		23231,
		23232,
		23233,
		--	祈福
		23151,
		--	伦鲁迪洛尔，上古守护者的长弓
		-- 23192,
		--	科尔戈的藏宝图
		11438,
	},
};
DataAgent.T_TradeSkill_RecipeList = T_TradeSkill_RecipeList;

local T_TradeSkill_Spec2Pid = {  };
for sid, info in next, T_Recipe_Data do
	local spec = info[index_spec];
	if spec then
		T_TradeSkill_Spec2Pid[spec] = info[index_pid];
	end
end
DataAgent.T_TradeSkill_Spec2Pid = T_TradeSkill_Spec2Pid;

DataAgent.T_TradeSkill_CooldownList = {
	[3] = {
		{ 19566, 250, },	--	筛盐器
	},
	[4] = {
		-- { 17563, },	--	死灵化水	--	17562	点水成气	17561	转土成水	17565	生命归土	17560	点火成土
		{ 17187, },	--	转化：奥金
	},
	[8] = {
		{ 18560, },	--	月布
	},
};

DataAgent.T_PriceSpellBlackList = {
--	炼金
	--	元素精华
	[17559] = 1,	--	7078
	[17560] = 1,	--	7076
	[17561] = 1,	--	7080
	[17562] = 1,	--	7082
	[17563] = 1,	--	7080
	[17564] = 1,	--	12808
	[17565] = 1,	--	7076
	[17566] = 1,	--	12803
	--	奥金锭
	[17187] = 1,	--	12360
--	裁缝
	--	月布
	[18560] = 1,	--	14342
--	制皮
	--	熟化毛皮
	[19047] = 1,	--	15407
};
DataAgent.T_PriceItemBlackList = {
--	炼金
	--	元素精华
	[7076] = 1,
	[7078] = 1,
	[7080] = 1,
	[7082] = 1,
	[12803] = 1,
	[12808] = 1,
	--	奥金锭
	[12360] = 1,
--	裁缝
	--	月布
	[14342] = 1,
--	制皮
	--	熟化毛皮
	[15407] = 1,
};

DataAgent.T_MaterialVendorPrice = {
	--	BLACKSMITHING	ENGINEERING
	-- [5956] = 18,		-- 铁匠之锤
	-- [2901] = 81,		-- 矿工锄
	[2880] = 100,		-- 弱效助熔剂
	[3466] = 2000,		-- 强效助熔剂
	[3857] = 500,		-- 煤块
	[18567] = 150000,	-- 元素助熔剂
	[4399] = 200,		-- 木柴
	[4400] = 2000,		-- 沉重的树干
	[10648] = 500,		-- 空白的羊皮纸
	[10647] = 2000,		-- 墨水
	[6530] = 100,		-- 夜色虫
	--	ALCHEMY
	[3371] = 4,			-- 空瓶
	[3372] = 40,		-- 铅瓶
	[8925] = 500,		-- 水晶瓶
	[18256] = 6000,		-- 灌魔之瓶
	--	ENCHANGING
	[6217] = 124,		-- 铜棒
	[4470] = 38,		-- 普通木柴
	[11291] = 4500,		-- 星木
	--	TAILORING	LEATHERWORKING
	[2320] = 10,		-- 粗线
	[2321] = 100,		-- 细线
	[4291] = 500,		-- 丝线
	[8343] = 2000,		-- 粗丝线
	[14341] = 5000,		-- 符文线
	[2324] = 25,		-- 漂白剂
	[2604] = 50,		-- 红色染料
	[6260] = 50,		-- 蓝色染料
	[2605] = 100,		-- 绿色染料
	[4341] = 500,		-- 黄色染料
	[4340] = 350,		-- 灰色染料
	[6261] = 1000,		-- 橙色染料
	[2325] = 1000,		-- 灰色染料
	[4342] = 2500,		-- 紫色染料
	[10290] = 2500,		-- 粉红燃料
	[4289] = 50,		-- 盐
	--	COOKING
	[159] = 5,			-- 清凉的泉水
	[1179] = 125,		-- 冰镇牛奶
	[2678] = 2,			-- 甜香料
	[2692] = 40,		-- 辣椒
	[3713] = 160,		-- 舒心草
	[2596] = 120,		-- 矮人烈酒
	--	POISION
	[2928] = 20,		--	蚀骨灰
	[5140] = 25,		--	闪光粉
	[2930] = 50,		--	痛苦精华
	[8924] = 100,		--	堕落之尘
	[5173] = 100,		--	丧命草
	[8923] = 200,		--	苦楚精华
	--
	[5565] = 5000,		--	地狱火石
	[16583] = 10000,	--	恶魔雕像
	[17020] = 1000,		--	魔粉
	[17021] = 700,		--	野生浆果
	[17026] = 1000,		--	野生棘根草
	[17028] = 700,		--	圣洁蜡烛
	[17029] = 1000,		--	神圣蜡烛
	[17030] = 2000,		--	十字章
	[17031] = 1000,		--	传送符文
	[17032] = 2000,		--	传送门符文
	[17033] = 2000,		--	神圣符印
	[17034] = 200,		--	枫树种子
	[17035] = 400,		--	荆棘种子
	[17036] = 800,		--	灰木种子
	[17037] = 1400,		--	角树种子
	[17038] = 2000,		--	铁木种子
	[21177] = 300,		--	王者印记
};

--[==[
--	ID	Race.raceName (enUS)	Race.clientFileString	Faction.name (enUS)		Faction.groupTag
	1	Human					Human					Alliance	Alliance,
	2	Orc						Orc						Horde		Horde,
	3	Dwarf					Dwarf					Alliance	Alliance,
	4	Night Elf				NightElf				Alliance	Alliance,
	5	Undead					Scourge					Horde		Horde,
	6	Tauren					Tauren					Horde		Horde,
	7	Gnome					Gnome					Alliance	Alliance,
	8	Troll					Troll					Horde		Horde,
	9	Goblin					Goblin					Horde		Horde,
	10	Blood Elf				BloodElf				Horde		Horde,
	11	Draenei					Draenei					Alliance	Alliance,
	12	Fel Orc					FelOrc					Alliance	Alliance,
	13	Naga					Naga_					Alliance	Alliance,
	14	Broken					Broken					Alliance	Alliance,
	15	Skeleton				Skeleton				Alliance	Alliance,
	16	Vrykul					Vrykul					Alliance	Alliance,
	17	Tuskarr					Tuskarr					Alliance	Alliance,
	18	Forest Troll			ForestTroll				Alliance	Alliance,
	19	Taunka					Taunka					Alliance	Alliance,
	20	Northrend Skeleton		NorthrendSkeleton		Alliance	Alliance,
	21	Ice Troll				IceTroll				Alliance	Alliance,
	22	Worgen					Worgen					Alliance	Alliance,
	23	Gilnean					Human					Alliance	Alliance,
	24	Pandaren				Pandaren							Neutral,
	25	Pandaren				Pandaren				Alliance	Alliance,
	26	Pandaren				Pandaren				Horde		Horde,
	27	Nightborne				Nightborne				Horde		Horde,
	28	Highmountain Tauren		HighmountainTauren		Horde		Horde,
	29	Void Elf				VoidElf					Alliance	Alliance,
	30	Lightforged Draenei		LightforgedDraenei		Alliance	Alliance,
	31	Zandalari Troll			ZandalariTroll			Horde		Horde,
	32	Kul Tiran				KulTiran				Alliance	Alliance,
	33	Human					ThinHuman				Alliance	Alliance,
	34	Dark Iron Dwarf			DarkIronDwarf			Alliance	Alliance,
	35	Vulpera					Vulpera					Horde		Horde,
	36	Mag'har Orc				MagharOrc				Horde		Horde,
	37	Mechagnome				Mechagnome				Alliance	Alliance,
]==]

DataAgent.T_RaceBonus = {
	--	Gnome
	[7] = {
		[9] = 15,
	},
};

DataAgent.T_SkillTools = {  };

--[[DataAgent.Trainer = {
	[8483] = { 1346, 2399, 4576, 11052, 11557, },
	[12072] = { 2399, 11052, 11557, },
	[12076] = { 4578, 9584, },
	[12591] = { 5174, 8736, 11017, },
	[28224] = { 16365, },
	[24655] = { 7866, 7867, },
	[12092] = { 2399, 11052, 11557, },
	[19058] = { 7870, 11097, 11098, },
	[13637] = { 11072, 11073, 11074, },
	[12619] = { 8736, },
	[13657] = { 11072, 11073, 11074, },
	[9062] = { 223, 1466, 1632, 3008, 3069, 3549, 3605, 5784, 5811, 11083, 11096, },
	[9074] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 8153, 11081, 11084, },
	[10619] = { 7866, 7867, },
	[13693] = { 11072, 11073, 11074, },
	[7623] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[2539] = { 1355, 1382, 1430, 1699, 3026, 3067, 3087, 3399, 4210, 4552, 5159, 5482, 6286, 8306, },
	[2541] = { 1355, 1382, 1430, 1699, 3026, 3067, 3087, 3399, 4210, 4552, 5159, 5482, 6286, 8306, },
	[10647] = { 7870, 7871, 11097, 11098, },
	[2544] = { 1355, 1382, 1430, 1699, 3026, 3067, 3087, 3399, 4210, 4552, 5159, 5482, 6286, 8306, },
	[2546] = { 1355, 1382, 1430, 1699, 3026, 3067, 3087, 3399, 4210, 4552, 5159, 5482, 6286, 8306, },
	[3569] = { 1681, 1701, 3001, 3137, 3175, 3357, 3555, 4254, 4598, 5392, 5513, 6297, 8128, },
	[12715] = { 8126, 8738, },
	[13230] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[12755] = { 8126, 8738, },
	[12759] = { 7406, 7944, },
	[7156] = { 3007, 4212, },
	[15833] = { 1386, 7948, },
	[9194] = { 3007, 4212, },
	[9198] = { 3007, 4212, },
	[8691] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[9206] = { 3007, 4212, },
	[6661] = { 3007, 4212, },
	[28209] = { 16365, },
	[14380] = { 2836, 3355, 4258, },
	[13378] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[11342] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[8791] = { 1346, 2399, 4576, 11052, 11557, },
	[13905] = { 11073, },
	[8799] = { 1346, 2399, 4576, 11052, 11557, },
	[11358] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[20648] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 8153, 11081, 11084, },
	[12899] = { 7406, 7944, },
	[21175] = { 1355, 1382, 1430, 1699, 3026, 3067, 3087, 3399, 4210, 4552, 5159, 5482, 6286, 8306, },
	[12907] = { 7406, 7944, },
	[19666] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[7745] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[20201] = { 2836, },
	[16640] = { 2836, },
	[3116] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[3117] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[7771] = { 1317, 3011, 3345, 3606, 4213, 4616, 5157, 5695, 7949, 11065, 11066, 11067, 11068, 11070, 11071, 11072, 11073, 11074, },
	[11450] = { 1386, 4160, 4611, 7948, },
	[9921] = { 2836, 3355, 4258, },
	[11478] = { 1386, 7948, },
	[7795] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[9961] = { 2836, },
	[3337] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[2665] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[5763] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[8687] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[9985] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[10511] = { 7870, 11097, 11098, },
	[9993] = { 2836, 3355, 4258, },
	[7817] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[12045] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[12049] = { 1346, 2399, 4576, 11052, 11557, },
	[12053] = { 1346, 2399, 4576, 11052, 11557, },
	[12895] = { 7406, 7944, 8738, },
	[12061] = { 1346, 2399, 4576, 11052, 11557, },
	[16153] = { 1681, 1701, 3001, 3137, 3175, 3357, 3555, 4254, 4598, 5392, 5513, 6297, 8128, },
	[12069] = { 1346, 2399, 4576, 11052, 11557, },
	[12073] = { 2399, 11052, 11557, },
	[12077] = { 2399, 11052, 11557, },
	[10548] = { 7870, 11097, 11098, },
	[10552] = { 7870, 11097, 11098, },
	[10556] = { 7870, 11097, 11098, },
	[28242] = { 16365, },
	[7845] = { 1386, 2391, 2837, 3009, 3347, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 7948, 11042, },
	[2159] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 7866, 7867, 7868, 7869, 8153, 11081, 11084, },
	[15255] = { 5174, 8736, 11017, },
	[13642] = { 11072, 11073, 11074, },
	[17551] = { 1386, 7948, },
	[7151] = { 3007, 4212, },
	[7857] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[2666] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[20649] = { 3007, 4212, },
	[2658] = { 1681, 1701, 3001, 3137, 3175, 3357, 3555, 4254, 4598, 5392, 5513, 6297, 8128, },
	[3170] = { 1215, 1246, 1386, 1470, 2132, 2391, 2837, 3184, 3347, 3603, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 5500, 7948, 11041, 11042, 11044, 11046, 11047, },
	[3171] = { 1386, 2391, 2837, 3009, 3347, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 7948, 11042, },
	[2661] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[19667] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[13822] = { 11072, 11073, 11074, },
	[2153] = { 223, 1466, 1632, 3008, 3069, 3549, 3605, 5784, 5811, 7866, 7867, 7868, 7869, 11083, 11096, },
	[3176] = { 1386, 2391, 2837, 3009, 3347, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 7948, 11042, },
	[10632] = { 7868, 7869, },
	[16641] = { 2836, },
	[2668] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[13746] = { 11072, 11073, 11074, },
	[2670] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[2160] = { 223, 1466, 1632, 3008, 3069, 3549, 3605, 5784, 5811, 7866, 7867, 7868, 7869, 11083, 11096, },
	[2672] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[2162] = { 223, 1466, 1632, 3008, 3069, 3549, 3605, 5784, 5811, 11083, 11096, },
	[2674] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[2675] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[2165] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 8153, 11081, 11084, },
	[2166] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 7866, 7867, 7868, 7869, 8153, 11081, 11084, },
	[2167] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 7866, 7867, 7868, 7869, 8153, 11081, 11084, },
	[2168] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 8153, 11081, 11084, },
	[13702] = { 11072, 11073, 11074, },
	[3177] = { 1386, 2391, 2837, 3009, 3347, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 7948, 11042, },
	[13648] = { 11072, 11073, 11074, },
	[2392] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[6517] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[18629] = { 12920, 12939, },
	[7408] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[12760] = { 8126, 8738, },
	[6500] = { 1355, 1382, 1430, 1699, 3026, 3067, 3087, 3399, 4210, 4552, 5159, 5482, 6286, 8306, },
	[7841] = { 1386, 2391, 2837, 3009, 3347, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 7948, 11042, },
	[13794] = { 11072, 11073, 11074, },
	[2659] = { 1681, 1701, 3001, 3137, 3175, 3357, 3555, 4254, 4598, 5392, 5513, 6297, 8128, },
	[7420] = { 1317, 3011, 3345, 3606, 4213, 4616, 5157, 5695, 7949, 11065, 11066, 11067, 11068, 11070, 11071, 11072, 11073, 11074, },
	[8895] = { 8126, 8738, },
	[11461] = { 1386, 7948, },
	[7426] = { 1317, 3011, 3345, 3606, 4213, 4616, 5157, 5695, 7949, 11065, 11066, 11067, 11068, 11070, 11071, 11072, 11073, 11074, },
	[11457] = { 1386, 4160, 4611, 7948, },
	[7430] = { 1702, 2857, 3290, 3412, 3494, 4586, 5174, 5518, 8736, 10993, 11017, 11025, 11026, 11028, 11029, 11031, 11037, },
	[13538] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[9916] = { 2836, 3355, 4258, },
	[7863] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[7861] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[22331] = { 11097, 11098, },
	[3776] = { 3007, 4212, },
	[9918] = { 2836, 3355, 4258, },
	[3774] = { 3007, 4212, },
	[13858] = { 11072, 11073, 11074, },
	[9060] = { 223, 1466, 1632, 3008, 3069, 3549, 3605, 5784, 5811, 7866, 7867, 7868, 7869, 11083, 11096, },
	[3501] = { 2836, 3355, 4258, },
	[28219] = { 16365, },
	[8764] = { 1346, 2399, 4576, 11052, 11557, },
	[8768] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[28243] = { 16365, },
	[8776] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[13890] = { 11072, 11073, 11074, },
	[2664] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[11343] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[3763] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 8153, 11081, 11084, },
	[11449] = { 1386, 4160, 4611, 7948, },
	[14932] = { 7870, 11097, 11098, },
	[8804] = { 1346, 2399, 4576, 11052, 11557, },
	[20650] = { 3007, 4212, },
	[6458] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[2742] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[18630] = { 12920, 12939, },
	[12074] = { 2399, 4578, 9584, 11052, 11557, },
	[19668] = { 2836, 3355, 4258, },
	[3818] = { 3007, 4212, },
	[2738] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[8880] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[22967] = { 14401, },
	[3753] = { 223, 1466, 1632, 3008, 3069, 3549, 3605, 5784, 5811, 7866, 7867, 7868, 7869, 11083, 11096, },
	[3491] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[3755] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[3756] = { 223, 1466, 1632, 3008, 3069, 3549, 3605, 5784, 5811, 11083, 11096, },
	[3757] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[15972] = { 2836, 3355, 4258, },
	[3759] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 8153, 11081, 11084, },
	[3760] = { 3007, 4212, },
	[3761] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 8153, 11081, 11084, },
	[2740] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[2741] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[3764] = { 3007, 4212, },
	[11451] = { 1386, 4160, 4611, 7948, },
	[3766] = { 3007, 4212, },
	[9926] = { 2836, 3355, 4258, },
	[3768] = { 3007, 4212, },
	[11467] = { 1386, 7948, },
	[6510] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[12618] = { 8736, },
	[2964] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[9065] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 7866, 7867, 7868, 7869, 8153, 11081, 11084, },
	[9954] = { 5164, 7230, 11177, },
	[3842] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[13028] = { 8696, },
	[3845] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[7837] = { 1386, 2391, 2837, 3009, 3347, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 7948, 11042, },
	[9974] = { 5164, 7230, 11177, },
	[3780] = { 3007, 4212, },
	[13503] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[9986] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[12903] = { 7406, 7944, },
	[2739] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[8465] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[12046] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[3276] = { 2326, 2327, 2329, 2798, 3181, 3373, 4211, 4591, 5150, 5759, 5939, 5943, 6094, },
	[3277] = { 2326, 2327, 2329, 2798, 3181, 3373, 4211, 4591, 5150, 5759, 5939, 5943, 6094, },
	[3278] = { 2326, 2327, 2329, 2798, 3181, 3373, 4211, 4591, 5150, 5759, 5939, 5943, 6094, },
	[23070] = { 8736, },
	[8489] = { 1346, 2399, 4576, 11052, 11557, },
	[12070] = { 1346, 2399, 4576, 11052, 11557, },
	[13607] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[12589] = { 5174, 8736, 11017, },
	[28220] = { 16365, },
	[13941] = { 11073, },
	[28205] = { 16365, },
	[28244] = { 16365, },
	[13631] = { 11072, 11073, 11074, },
	[13635] = { 11072, 11073, 11074, },
	[28221] = { 16365, },
	[12621] = { 8736, },
	[3292] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[3293] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[3294] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[13659] = { 11072, 11073, 11074, },
	[13663] = { 11072, 11073, 11074, },
	[9068] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 7866, 7867, 7868, 7869, 8153, 11081, 11084, },
	[24654] = { 7866, 7867, },
	[10098] = { 1681, 1701, 3001, 3137, 3175, 3357, 3555, 4254, 4598, 5392, 5513, 6297, 8128, },
	[28223] = { 16365, },
	[19669] = { 2836, },
	[10621] = { 7870, 7871, },
	[14379] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[13695] = { 11072, 11073, 11074, },
	[7624] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[3817] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 8153, 11081, 11084, },
	[3307] = { 1681, 1701, 3001, 3137, 3175, 3357, 3555, 4254, 4598, 5392, 5513, 6297, 8128, },
	[3308] = { 1681, 1701, 3001, 3137, 3175, 3357, 3555, 4254, 4598, 5392, 5513, 6297, 8128, },
	[12595] = { 5174, 8736, 11017, },
	[3859] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[16639] = { 2836, },
	[10007] = { 7231, 7232, 11146, 11178, },
	[13220] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[10003] = { 7231, 7232, 11146, 11178, },
	[13228] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[7135] = { 1385, 3365, 3703, 3967, 4588, 5127, 5564, 8153, 11081, 11084, },
	[10001] = { 2836, },
	[13240] = { 8126, },
	[3319] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[3320] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[2332] = { 1215, 1246, 1386, 1470, 2132, 2391, 2837, 3184, 3347, 3603, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 5500, 7948, 11041, 11042, 11044, 11046, 11047, },
	[7147] = { 3007, 4212, },
	[3323] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[3324] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[3978] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[3326] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[14809] = { 11072, 11073, 11074, },
	[8681] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[9196] = { 3007, 4212, },
	[3841] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[23486] = { 8736, },
	[3843] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[3333] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[13815] = { 11072, 11073, 11074, },
	[3963] = { 5174, 8736, 11017, },
	[3850] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[3848] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[7179] = { 1386, 2391, 2837, 3009, 3347, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 7948, 11042, },
	[7181] = { 1386, 4160, 4611, 7948, },
	[3839] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[3852] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[2662] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[18402] = { 2399, 11052, 11557, },
	[3855] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[8772] = { 1346, 2399, 4576, 11052, 11557, },
	[2835] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[3871] = { 1346, 2399, 4576, 11052, 11557, },
	[2837] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[6690] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[3861] = { 1346, 2399, 4576, 11052, 11557, },
	[19047] = { 7870, 11097, 11098, },
	[13887] = { 11072, 11073, 11074, },
	[2331] = { 1215, 1246, 1386, 1470, 2132, 2391, 2837, 3184, 3347, 3603, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 5500, 7948, 11041, 11042, 11044, 11046, 11047, },
	[3865] = { 1346, 2399, 4576, 11052, 11557, },
	[3866] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[2334] = { 1215, 1246, 1386, 1470, 2132, 2391, 2837, 3184, 3347, 3603, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 5500, 7948, 11041, 11042, 11044, 11046, 11047, },
	[10841] = { 12920, 12939, },
	[28208] = { 16365, },
	[2337] = { 1215, 1246, 1470, 2132, 2391, 2837, 3009, 3184, 3347, 3603, 3964, 4609, 4900, 5177, 5499, 5500, 11041, 11042, 11044, 11046, 11047, },
	[12897] = { 7406, 7944, },
	[3922] = { 1676, 1702, 2857, 3290, 3412, 3494, 4586, 5174, 5518, 8736, 10993, 11017, 11025, 11026, 11028, 11029, 11031, 11037, },
	[12905] = { 7406, 7944, },
	[2161] = { 223, 1466, 1632, 3008, 3069, 3549, 3605, 5784, 5811, 7866, 7867, 7868, 7869, 11083, 11096, },
	[13935] = { 11073, },
	[13939] = { 11073, },
	[13943] = { 11073, },
	[7748] = { 1317, 3011, 3345, 3606, 4213, 4616, 5157, 5695, 7949, 11065, 11066, 11067, 11068, 11070, 11071, 11072, 11073, 11074, },
	[9193] = { 3007, 4212, },
	[11400] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[3930] = { 1676, 1702, 2857, 3290, 3412, 3494, 4586, 5174, 5518, 8736, 10993, 11017, 11025, 11026, 11028, 11029, 11031, 11037, },
	[3929] = { 1702, 2857, 3290, 3412, 3494, 4586, 5174, 5518, 8736, 10993, 11017, 11025, 11026, 11028, 11029, 11031, 11037, },
	[9983] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10266, 10276, 10277, 10278, },
	[3452] = { 1386, 4160, 4611, 7948, },
	[22808] = { 1386, 4160, 4611, 7948, },
	[3926] = { 1702, 2857, 3290, 3412, 3494, 4586, 5174, 5518, 8736, 10993, 11017, 11025, 11026, 11028, 11029, 11031, 11037, },
	[3450] = { 1386, 4160, 4611, 7948, },
	[3331] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[2386] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[3447] = { 1386, 2391, 2837, 3009, 3347, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 7948, 11042, },
	[12050] = { 1346, 2399, 4576, 11052, 11557, },
	[11448] = { 1386, 4160, 4611, 7948, },
	[28222] = { 16365, },
	[9145] = { 3007, 4212, },
	[11460] = { 1386, 7948, },
	[9931] = { 2836, 3355, 4258, },
	[9935] = { 2836, 3355, 4258, },
	[7788] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[12718] = { 8126, 8738, },
	[10558] = { 7870, 11097, 11098, },
	[12079] = { 2399, 11052, 11557, },
	[12082] = { 4578, 9584, },
	[9959] = { 2836, },
	[2396] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[2397] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[10482] = { 3007, 4212, },
	[10650] = { 7866, 7867, },
	[3931] = { 1676, 1702, 2857, 3290, 3412, 3494, 4586, 5174, 5518, 8736, 10993, 11017, 11025, 11026, 11028, 11029, 11031, 11037, },
	[18401] = { 2399, 11052, 11557, },
	[9987] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[2399] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[3932] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[7818] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[3914] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[10518] = { 7870, 11097, 11098, },
	[12055] = { 4578, 9584, },
	[10015] = { 7231, 7232, 11146, 11178, },
	[2385] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[12067] = { 1346, 2399, 4576, 11052, 11557, },
	[12071] = { 4578, 9584, },
	[12586] = { 5174, 8736, 11017, },
	[12590] = { 5174, 8736, 11017, },
	[3923] = { 1702, 2857, 3290, 3412, 3494, 4586, 5174, 5518, 8736, 10993, 11017, 11025, 11026, 11028, 11029, 11031, 11037, },
	[3924] = { 1702, 2857, 3290, 3412, 3494, 4586, 5174, 5518, 8736, 10993, 11017, 11025, 11026, 11028, 11029, 11031, 11037, },
	[3925] = { 1702, 2857, 3290, 3412, 3494, 4586, 5174, 5518, 8736, 10993, 11017, 11025, 11026, 11028, 11029, 11031, 11037, },
	[13628] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[19567] = { 8736, },
	[2395] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[13640] = { 11072, 11073, 11074, },
	[12622] = { 8736, },
	[3420] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[3421] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[2401] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[3934] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[2402] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[3936] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[3937] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[3938] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[2406] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[3816] = { 223, 1466, 1632, 3008, 3069, 3549, 3605, 5784, 5811, 7866, 7867, 7868, 7869, 11083, 11096, },
	[3941] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[3942] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[10630] = { 7868, 7869, },
	[13700] = { 11072, 11073, 11074, },
	[3945] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[3946] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[3947] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[17180] = { 11073, },
	[3949] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[3950] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[2394] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[2393] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[3953] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[13229] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[3955] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[3956] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[7836] = { 1386, 2391, 2837, 3009, 3347, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 7948, 11042, },
	[3958] = { 5174, 8736, 11017, },
	[3448] = { 1386, 4160, 4611, 7948, },
	[10011] = { 7231, 7232, 11146, 11178, },
	[3961] = { 5174, 8736, 11017, },
	[3962] = { 5174, 8736, 11017, },
	[12754] = { 8126, 8738, },
	[12758] = { 8126, 8738, },
	[3965] = { 5174, 8736, 11017, },
	[14810] = { 11072, 11073, 11074, },
	[3967] = { 5174, 8736, 11017, },
	[7928] = { 2326, 2327, 2329, 2798, 3181, 3373, 4211, 4591, 5150, 5759, 5939, 5943, 6094, },
	[9201] = { 3007, 4212, },
	[8694] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[7934] = { 2326, 2327, 2329, 2798, 3181, 3373, 4211, 4591, 5150, 5759, 5939, 5943, 6094, },
	[3813] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[3973] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[12088] = { 2399, 11052, 11557, },
	[12584] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[9271] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[3977] = { 1702, 2857, 3290, 3412, 3494, 4586, 5174, 5518, 8736, 10993, 11017, 11025, 11026, 11028, 11029, 11031, 11037, },
	[13836] = { 11072, 11073, 11074, },
	[12585] = { 5174, 8736, 11017, },
	[8334] = { 1676, 3412, 5174, 5518, 8736, 11017, 11029, 11031, },
	[3840] = { 1103, 1300, 1346, 1703, 2399, 2627, 2855, 3004, 3363, 3484, 3523, 3704, 4159, 4193, 4576, 5153, 5567, 11048, 11049, 11050, 11051, 11052, 11557, },
	[12594] = { 5174, 8736, 11017, },
	[12065] = { 1346, 2399, 4576, 11052, 11557, },
	[7223] = { 2836, 3355, 4258, },
	[28207] = { 16365, },
	[8758] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[8762] = { 1346, 2399, 4576, 11052, 11557, },
	[8766] = { 1346, 2399, 4576, 11052, 11557, },
	[8770] = { 1346, 2399, 4576, 11052, 11557, },
	[8774] = { 1346, 2399, 4576, 11052, 11557, },
	[10097] = { 1681, 1701, 3001, 3137, 3175, 3357, 3555, 4254, 4598, 5392, 5513, 6297, 8128, },
	[12599] = { 5174, 8736, 11017, },
	[11341] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[12603] = { 5174, 8736, 11017, },
	[12716] = { 8126, 8738, },
	[14930] = { 7870, 11097, 11098, },
	[11357] = { 917, 918, 1234, 1411, 2130, 3170, 3327, 3328, 3401, 3599, 4163, 4214, 4215, 4582, 4583, 4585, 5165, 5166, 5167, 6707, 13283, },
	[3328] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[12717] = { 8126, 8738, },
	[12902] = { 7406, 7944, },
	[12906] = { 7406, 7944, },
	[13421] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[12908] = { 8126, 8738, },
	[19788] = { 8736, },
	[3173] = { 1386, 2391, 2837, 3009, 3347, 3964, 4160, 4609, 4611, 4900, 5177, 5499, 7948, 11042, },
	[13948] = { 11073, },
	[3304] = { 1681, 1701, 3001, 3137, 3175, 3357, 3555, 4254, 4598, 5392, 5513, 6297, 8128, },
	[14293] = { 1317, 3011, 3345, 3606, 4213, 4616, 5157, 5695, 7949, 11065, 11066, 11067, 11068, 11070, 11071, 11072, 11073, 11074, },
	[7454] = { 1317, 3011, 3345, 3606, 4213, 4616, 5157, 5695, 7949, 11065, 11066, 11067, 11068, 11070, 11071, 11072, 11073, 11074, },
	[7457] = { 1317, 3011, 3345, 3606, 4213, 4616, 5157, 5695, 7949, 11065, 11066, 11067, 11068, 11070, 11071, 11072, 11073, 11074, },
	[3296] = { 1383, 2836, 2998, 3136, 3355, 3478, 4258, 4596, 5511, 10276, },
	[17181] = { 11073, },
	[3502] = { 2836, 3355, 4258, },
	[8760] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[12609] = { 1386, 4160, 4611, 7948, },
	[7779] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[3506] = { 2836, 3355, 4258, },
	[13485] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[3508] = { 2836, 3355, 4258, },
	[6499] = { 1355, 1382, 1430, 1699, 3026, 3067, 3087, 3399, 4210, 4552, 5159, 5482, 6286, 8306, },
	[9920] = { 2836, 3355, 4258, },
	[13501] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[9928] = { 2836, 3355, 4258, },
	[11465] = { 1386, 7948, },
	[3770] = { 3007, 4212, },
	[2737] = { 514, 957, 1241, 1383, 2836, 2998, 3136, 3174, 3355, 3478, 3557, 4258, 4596, 4605, 5511, 6299, 10266, 10276, 10277, 10278, },
	[13622] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[13626] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[13529] = { 1317, 3011, 3345, 4213, 4616, 5157, 7949, 11072, 11073, 11074, },
	[14807] = { 1317, 3011, 3345, 3606, 4213, 4616, 5157, 5695, 7949, 11065, 11066, 11067, 11068, 11070, 11071, 11072, 11073, 11074, },
	[6521] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[13644] = { 11072, 11073, 11074, },
	[9968] = { 2836, },
	[23489] = { 8736, },
	[10487] = { 3007, 4212, },
	[12596] = { 5174, 8736, 11017, },
	[13917] = { 11073, },
	[10499] = { 11097, 11098, },
	[13937] = { 11073, },
	[10507] = { 11097, 11098, },
	[8467] = { 1346, 2399, 2627, 3004, 3363, 3704, 4159, 4576, 5153, 5567, 11049, 11052, 11557, },
	[12048] = { 1346, 2399, 4576, 11052, 11557, },
	[12052] = { 4578, 9584, },
	[13661] = { 11072, 11073, 11074, },
};--]]

--[[local InvalidData = {
	[2671]    = { nil, 1,  2,    2671,    2867, 100, 145, 160, 175,   1,   1, { 2841, }, { 4, }, nil, nil, { 5577, }, },
	[6619]    = { nil, 1,  4,    6619,    5632, 125, 150, 170, 190,   1,   1, { 5636, 3356, 3372, }, { 1, 1, 1, }, nil, nil, { 5641, }, },
	[7636]    = { nil, 1,  8,    7636,    6243,  90, 115, 132, 150,   1,   1, { 2997, 2321, 2605, }, { 3, 2, 1, }, nil, nil, { 6273, }, },
	[8366]    = { nil, 1,  2,    8366,    6730,  70, 110, 130, 150,   1,   1, { 2840, 774, 3470, }, { 12, 2, 2, }, nil, nil, { 6734, }, },
	[8368]    = { nil, 1,  2,    8368,    6733, 140, 170, 185, 200,   1,   1, { 2841, 1210, 3478, }, { 8, 3, 4, }, nil, nil, { 6736, }, },
	[8778]    = { nil, 1,  8,    8778,    7027, 140, 160, 175, 190,   1,   1, { 4305, 2319, 6048, 2321, }, { 3, 2, 1, 2, }, nil, nil, { 7093, }, },
	[9942]    = { nil, 1,  2,    9942,    7925, 220, 240, 250, 260,   1,   1, { 3860, 4234, 4338, }, { 8, 6, 4, }, nil, nil, { 7977, }, },
	[10550]   = { nil, 1,  3,   10550,    8195, 230, 250, 260, 270,   1,   1, { 4304, 4291, }, { 12, 4, }, nil, nil, { 8388, }, },
	-- [11447]   = { nil, 1,  4,   11447,    8827,   0, 190, 210, 230,   1,   1, { 6370, 3357, 3372, }, { 1, 1, 1, }, },	-- invalid skill
	[12062]   = { nil, 1,  8,   12062,   10010, 220, 235, 250, 265,   1,   1, { 4339, 7079, 8343, }, { 4, 2, 2, }, nil, nil, { 10303, }, },
	[12063]   = { nil, 1,  8,   12063,   10011, 220, 235, 250, 265,   1,   1, { 4339, 7079, 8343, }, { 3, 2, 2, }, nil, nil, { 10304, }, },
	[12068]   = { nil, 1,  8,   12068,   10020, 225, 240, 255, 270,   1,   1, { 4339, 7079, 8343, }, { 5, 3, 2, }, nil, nil, { 10313, }, },
	[12083]   = { nil, 1,  8,   12083,   10032, 240, 255, 270, 285,   1,   1, { 4339, 7079, 8343, }, { 4, 4, 2, }, nil, nil, { 10319, }, },
	[12087]   = { nil, 1,  8,   12087,   10038, 245, 260, 275, 290,   1,   1, { 4339, 7079, 8343, }, { 5, 6, 3, }, nil, nil, { 10322, }, },
	[12090]   = { nil, 1,  8,   12090,   10039, 250, 265, 280, 295,   1,   1, { 4339, 7079, 8343, 4304, }, { 6, 6, 3, 2, }, nil, nil, { 10324, }, },
	-- [12719]   = { nil, 1,  9,   12719,   10579,   0, 210, 230, 250, 100, 100, { 3030, 10505, 3860, }, { 100, 2, 2, }, },	-- invalid skill
	-- [12720]   = { nil, 1,  9,   12720,   10580,   0, 235, 245, 255,   1,   1, { 10561, 10505, 10558, 3860, }, { 1, 2, 1, 2, }, },	-- invalid skill
	-- [12722]   = { nil, 1,  9,   12722,   10585,   0, 240, 250, 260,   1,   1, { 10561, 3860, 4389, 10560, }, { 1, 2, 1, 1, }, },	-- invalid skill
	-- [12900]   = { nil, 1,  9,   12900,   10719,   0, 205, 225, 245,   1,   1, { 10559, 10560, 3860, }, { 1, 1, 4, }, },	-- invalid skill
	-- [12904]   = { nil, 1,  9,   12904,   10723,   0, 240, 250, 260,   1,   1, { 10561, 3860, 4389, 10560, }, { 1, 2, 1, 1, }, },	-- invalid skill
	[16960]   = { nil, 1,  2,   16960,   12764, 260, 285, 297, 310,   1,   1, { 12359, 12644, 8170, }, { 16, 2, 4, }, nil, nil, { 12816, }, },
	[16965]   = { nil, 1,  2,   16965,   12769, 270, 295, 307, 320,   1,   1, { 12359, 12803, 8153, 12799, 12644, }, { 30, 6, 6, 6, 2, }, nil, nil, { 12817, }, },
	[16967]   = { nil, 1,  2,   16967,   12772, 270, 295, 307, 320,   1,   1, { 12359, 3577, 6037, 12361, 8170, }, { 30, 4, 2, 2, 4, }, nil, nil, { 12818, }, },
	[16980]   = { nil, 1,  2,   16980,   12779, 285, 310, 322, 335,   1,   1, { 12359, 12799, 12644, 8170, }, { 30, 2, 2, 4, }, nil, nil, { 12826, }, },
	[16986]   = { nil, 1,  2,   16986,   12795, 300, 325, 337, 350,   1,   1, { 12655, 12360, 12662, 7910, 12644, }, { 10, 10, 8, 10, 2, }, nil, nil, { 12831, }, },
	[16987]   = { nil, 1,  2,   16987,   12802, 300, 325, 337, 350,   1,   1, { 12655, 12804, 12364, 12800, 12644, }, { 20, 20, 2, 2, 2, }, nil, nil, { 12832, }, },
	[17579]   = { nil, 1,  4,   17579,   13460, 290, 305, 325, 345,   1,   1, { 7069, 13463, 8925, }, { 1, 1, 1, }, nil, nil, { 13500, }, },
	[17632]   = { nil, 1,  4,   17632,   13503, 300, 315, 322, 330,   1,   1, { 7078, 7076, 7082, 7080, 12803, }, { 8, 8, 8, 8, 8, }, nil, nil, { 13517, }, },
	[19106]   = { nil, 1,  3,   19106,   15141, 300, 320, 330, 340,   1,   1, { 8170, 15410, 15416, 14341, }, { 40, 12, 60, 2, }, nil, nil, { 15780, }, },
	-- [22430]   = { nil, 1,  4,   22430,   17967,   0, 315, 322, 330,   1,   0, { 15410, }, { 1, }, },	-- invalid skill
	-- [22434]   = { nil, 1, 10,   22434,   17968,   0, 320, 315, 310,   1,   1, { 17967, 16204, 16203, }, { 1, 2, 2, }, },	-- invalid skill
	[28327]   = { nil, 1,  9,   28327,   22728, 275, 295, 305, 315,   1,   1, { 15994, 10561, 10558, }, { 2, 1, 1, }, nil, nil, { 22729, }, },
	[30021]   = { nil, 1,  1,   30021,   23684, 300, 300, 330, 360,   4,   4, { 23567, 14047, }, { 1, 10, }, nil, nil, { 23689, }, },
	[30047]   = { nil, 1,  6,   30047,   23683, 300, 325, 345, 365,   2,   2, { 23567, 8150, }, { 1, 1, }, nil, nil, { 23690, }, },
};--]]

if CT.SEASON == Enum.SeasonID.SeasonOfDiscovery then
	DataAgent.SoDData  =  { 
		[470349]  = { nil, 6,  1,  470349,  232433, 300, 315, 327, 340,   1,   1, { 14530, }, { 2, }, nil, nil, { 232434, }, },

		--	mod old
		[439120]  = { nil, 1,  2,  439120,  217273, 205, 225, 235, 245,   1,   1, { 3859, 3577, 3486, 3864, }, { 10, 4, 4, 1, }, nil, nil, { 217274, }, },
		[439122]  = { nil, 1,  2,  439122,  217275, 200, 225, 237, 250,   1,   1, { 3859, 3577, 3486, 3864, }, { 10, 4, 4, 1, }, nil, nil, { 217276, }, },
		[439124]  = { nil, 1,  2,  439124,  217277, 195, 220, 232, 245,   1,   1, { 3859, 3577, 3486, 1529, }, { 12, 2, 4, 2, }, nil, nil, { 217278, }, },
		[439126]  = { nil, 1,  2,  439126,  217279, 190, 215, 227, 240,   1,   1, { 3859, 3577, 3486, }, { 8, 2, 2, }, nil, nil, { 217280, }, },
		[439130]  = { nil, 1,  2,  439130,  217283, 175, 200, 212, 225,   1,   1, { 3859, 3577, 3486, }, { 6, 2, 1, }, nil, nil, { 217284, }, },
		[439132]  = { nil, 1,  2,  439132,  217285, 170, 195, 207, 220,   1,   1, { 3575, 3577, 3486, }, { 10, 2, 1, }, nil, nil, { 217286, }, },
		[439128]  = { nil, 1,  2,  439128,  217281, 180, 205, 217, 230,   1,   1, { 3859, 3466, 3486, 1705, 4234, }, { 8, 2, 2, 3, 3, }, nil, nil, { 217282, }, },
		[461651]  = { nil, 1,  2,  461651,  227865, 290, 310, 320, 330,   1,   1, { 12359, 12655, 7078, 7910, }, { 20, 6, 2, 4, }, nil, nil, { 227909, }, },
		--	new
		[430397]  = { nil, 1,  2,  430397,  211845, 100, 100, 110, 120,   1,   1, { 2863, 10938, }, { 1, 1, }, nil, nil, { 211846, }, },
		[427061]  = { nil, 1,  2,  427061,  210773, 150, 140, 150, 160,   1,   1, { 2841, 1206, 1705, 5500, 2842, }, { 20, 2, 2, 2, 4, }, nil, nil, { 210779, }, },
		[429348]  = { nil, 1,  2,  429348,  210794, 100, 175, 190, 205,   1,   1, { 2870, 211422, }, { 1, 1, }, }, --Quest when rank100
		[435910]  = { nil, 2,  2,  435910,  213376, 200, 200, 210, 220,   1,   1, { 6037, 213373, }, { 1, 5, }, nil, nil, { 215384, }, },
		[435908]  = { nil, 2,  2,  435908,  215161, 225, 225, 230, 235,   1,   1, { 3860, 213376, 213379, 213369, }, { 25, 4, 1, 2, }, nil, nil, { 215155, }, },
		[435906]  = { nil, 2,  2,  435906,  215167, 225, 225, 230, 235,   1,   1, { 3860, 213376, 213379, 213383, }, { 25, 4, 2, 1, }, nil, nil, { 215383, }, },
		[446191]  = { nil, 3,  2,  446191,  220739, 250, 250, 255, 260,   1,   1, { 221021, 220688, }, { 10, 1, }, },
		[446188]  = { nil, 3,  2,  446188,  220740, 250, 250, 255, 260,   1,   1, { 221021, 220688, }, { 10, 1, }, },
		[446179]  = { nil, 3,  2,  446179,  220738, 250, 250, 255, 260,   1,   1, { 221021, 220688, }, { 10, 1, }, },
		[461733]  = { nil, 4,  2,  461733,  227880, 280, 305, 317, 330,   1,   1, { 12359, 12655, 12364, 12804, 8170, }, { 20, 6, 2, 4, 4, }, nil, nil, { 228311, }, },
		[461667]  = { nil, 4,  2,  461667,  227871, 285, 305, 315, 325,   1,   1, { 11371, 7077, }, { 20, 8, }, nil, nil, { 227901, }, },
		[461718]  = { nil, 4,  2,  461718,  227881, 285, 310, 322, 335,   1,   1, { 12655, 12360, 12804, 12799, 12361, }, { 6, 2, 4, 2, 2, }, nil, nil, { 228308, }, },
		[461714]  = { nil, 4,  2,  461714,  227857, 290, 315, 327, 340,   1,   1, { 12359, 12360, 12662, 12808, 12361, }, { 40, 2, 16, 8, 2, }, nil, nil, { 228306, }, },
		[461737]  = { nil, 4,  2,  461737,  227870, 295, 315, 325, 335,   1,   1, { 12359, 12655, 7080, 12361, }, { 20, 4, 4, 4, }, nil, nil, { 228313, }, },
		[460460]  = { nil, 4,  2,  460460,  227684, 300, 325, 337, 350,   1,   1, { 17203, 11371, 12360, 7078, 11382, }, { 8, 20, 50, 25, 10, }, nil, nil, { 227727, }, },
		[461647]  = { nil, 4,  2,  461647,  227886, 300, 320, 330, 340,   1,   1, { 12794, 18262, 12360, }, { 1, 10, 15, }, nil, nil, { 227905, }, },
		[461712]  = { nil, 4,  2,  461712,  228230, 300, 320, 330, 340,   1,   1, { 12796, 18262, }, { 1, 10, }, nil, nil, { 228305, }, },
		[461716]  = { nil, 4,  2,  461716,  227884, 300, 320, 330, 340,   1,   1, { 12360, 12655, 12810, 7910, 12800, }, { 10, 10, 2, 6, 6, }, nil, nil, { 228307, }, },
		[461675]  = { nil, 4,  2,  461675,  227845, 300, 320, 330, 340,   1,   1, { 12784, 18262, }, { 1, 10, }, nil, nil, { 228114, }, },
		[461669]  = { nil, 4,  2,  461669,  228125, 300, 320, 330, 340,   1,   1, { 12790, 18262, }, { 1, 10, }, nil, nil, { 228117, }, },
		[461730]  = { nil, 4,  2,  461730,  227887, 300, 320, 330, 340,   1,   1, { 12797, 18262, }, { 1, 10, }, nil, nil, { 228310, }, },
		[461735]  = { nil, 4,  2,  461735,  227876, 300, 320, 330, 340,   1,   1, { 12360, 12655, 12364, 12800, }, { 30, 30, 6, 6, }, nil, nil, { 228312, }, },
		[461671]  = { nil, 4,  2,  461671,  227885, 300, 320, 330, 340,   1,   1, { 12360, 12655, 7076, 12361, 12799, }, { 15, 20, 10, 4, 4, }, nil, nil, { 228250, }, },
		[461739]  = { nil, 4,  2,  461739,  227872, 300, 320, 330, 340,   1,   1, { 12359, 12655, 8168, 12799, 12364, }, { 40, 4, 60, 6, 2, }, nil, nil, { 228314, }, },
		[461743]  = { nil, 4,  2,  461743,  227850, 300, 320, 330, 340,   1,   1, { 12360, 20725, 13512, 12810, }, { 12, 2, 2, 4, }, nil, nil, { 228315, }, },
		[1213643] = { nil, 6,  2, 1213643,  234004, 300, 315, 322, 330,   1,   1, { 22202, }, { 5, }, nil, nil, { 234279, }, },
		[1213709] = { nil, 6,  2, 1213709,  234288, 300, 320, 330, 340,   1,   1, { 12655, 12803, 19726, }, { 8, 4, 4, }, nil, nil, { 234289, }, },
		[1213711] = { nil, 6,  2, 1213711,  234290, 300, 320, 330, 340,   1,   1, { 12655, 19726, 12803, }, { 12, 4, 2, }, nil, nil, { 234291, }, },
		[1213715] = { nil, 6,  2, 1213715,  234292, 300, 320, 330, 340,   1,   1, { 12655, 19726, 12360, 12803, }, { 14, 8, 8, 4, }, nil, nil, { 234293, }, },
		[1213748] = { nil, 6,  2, 1213748,  234321, 300, 320, 330, 340,   1,   1, { 22202, 12810, 19726, }, { 14, 6, 4, }, nil, nil, { 234322, }, },
		[1213746] = { nil, 6,  2, 1213746,  234319, 300, 320, 330, 340,   1,   1, { 22202, 12655, 7076, 19726, }, { 14, 4, 2, 4, }, nil, nil, { 234320, }, },
		[1213481] = { nil, 6,  2, 1213481,  233795, 300, 320, 330, 340,   1,   1, { 12360, 234003, 12810, 8146, 234006, }, { 20, 5, 4, 10, 4, }, nil, nil, { 234220, }, },
		[1213484] = { nil, 6,  2, 1213484,  233793, 300, 320, 330, 340,   1,   1, { 12360, 234003, 12810, 8146, 234006, }, { 20, 5, 4, 10, 4, }, nil, nil, { 234221, }, },
		[1213490] = { nil, 6,  2, 1213490,  233492, 300, 320, 330, 340,   1,   1, { 12360, 234003, 12810, 8146, 234006, }, { 30, 8, 4, 10, 8, }, nil, nil, { 234222, }, },
		[1213492] = { nil, 6,  2, 1213492,  233491, 300, 320, 330, 340,   1,   1, { 12360, 234003, 12810, 234004, 20873, }, { 40, 10, 8, 6, 4, }, nil, nil, { 234223, }, },
		[1213498] = { nil, 6,  2, 1213498,  233490, 300, 320, 330, 340,   1,   1, { 12360, 234003, 12810, 234004, 20872, }, { 40, 10, 8, 6, 4, }, nil, nil, { 234224, }, },
		[1213500] = { nil, 6,  2, 1213500,  233796, 300, 320, 330, 340,   1,   1, { 12360, 234003, 234004, 20873, 20872, }, { 40, 10, 8, 4, 4, }, nil, nil, { 234225, }, },
		[1213502] = { nil, 6,  2, 1213502,  233797, 300, 320, 330, 340,   1,   1, { 12360, 234003, 12810, 234004, 20871, }, { 30, 8, 5, 6, 3, }, nil, nil, { 234226, }, },
		[1213504] = { nil, 6,  2, 1213504,  233798, 300, 320, 330, 340,   1,   1, { 12360, 234003, 20725, 234004, 20871, }, { 30, 8, 3, 3, 3, }, nil, nil, { 234227, }, },
		[1213506] = { nil, 6,  2, 1213506,  233801, 300, 320, 330, 340,   1,   1, { 12360, 234003, 234004, 20872, 20871, }, { 30, 8, 6, 3, 3, }, nil, nil, { 234228, }, },
		[1214137] = { nil, 6,  2, 1214137,  234428, 300, 320, 330, 340,   1,   1, { 12360, 234003, 234004, 20871, 20867, }, { 30, 8, 6, 3, 3, }, nil, nil, { 234429, }, },
		[1214257] = { nil, 6,  2, 1214257,  234086, 300, 320, 330, 340,   1,   1, { 22203, 22202, 12810, 13512, }, { 8, 24, 8, 1, }, nil, nil, { 234085, }, },
		[1214270] = { nil, 6,  2, 1214270,  234459, 300, 320, 330, 340,   1,   1, { 22203, 22202, 12655, 7076, }, { 8, 24, 8, 4, }, nil, nil, { 234458, }, },
		[1214274] = { nil, 6,  2, 1214274,  234460, 300, 320, 330, 340,   1,   1, { 22203, 22202, 12810, 12809, 12800, }, { 15, 36, 12, 10, 4, }, nil, nil, { 234461, }, },
		[1214309] = { nil, 6,  2, 1214309,  234487, 300, 320, 330, 340,   1,   1, { 12360, 12810, 8146, 20381, 12803, }, { 20, 4, 8, 8, 4, }, nil, nil, { 234488, }, },
		[1215507] = { nil, 6,  2, 1215507,  235040, 300, 320, 330, 340,   1,   1, { 22203, 22202, 12655, 7076, 12364, }, { 18, 40, 12, 10, 4, }, nil, nil, { 235039, }, },

		-- [451706]  = { nil, 1,  3,  451706,  220741,   0, 250, 255, 260,   1,   1, { 221021, 220688, 15412, 8170, }, { 10, 1, 5, 10, }, },	-- invalid skill
		--	 mod old
		[439105]  = { nil, 1,  3,  439105,  217259, 220, 240, 250, 260,   1,   1, { 4304, 8151, 8343, }, { 8, 6, 1, }, nil, nil, { 217260, }, },
		[439108]  = { nil, 1,  3,  439108,  217261, 215, 235, 245, 255,   1,   1, { 4304, 8151, 8343, }, { 10, 4, 1, }, nil, nil, { 217262, }, },
		[439110]  = { nil, 1,  3,  439110,  217263, 195, 215, 225, 235,   1,   1, { 4234, 4236, 4291, }, { 6, 2, 1, }, nil, nil, { 217264, }, },
		[439112]  = { nil, 1,  3,  439112,  217265, 170, 190, 200, 210,   1,   1, { 4236, 4234, 2321, 7071, }, { 2, 4, 1, 1, }, nil, nil, { 217266, }, },
		[439114]  = { nil, 1,  3,  439114,  217267, 160, 180, 190, 200,   1,   1, { 4234, 4305, 2321, }, { 12, 2, 2, }, }, --copy its original skill rank
		[439116]  = { nil, 1,  3,  439116,  217268, 210, 230, 240, 250,   1,   1, { 4304, 8167, 8343, }, { 6, 12, 1, }, }, --copy its original skill rank
		[439118]  = { nil, 1,  3,  439118,  217270, 205, 225, 235, 245,   1,   1, { 4304, 8167, 8343, }, { 6, 8, 1, }, nil, nil, { 217271, }, },
		[461692]  = { nil, 1,  3,  461692,  227855, 285, 285, 290, 295,   1,   1, { 8170, 14048, 18240, 14341, }, { 4, 2, 1, 1, }, nil, nil, { 228115, }, },--copy its original skill rank
		--	new
		[429354]  = { nil, 1,  3,  429354,  211423, 100, 160, 172, 185,   1,   1, { 211422, 4253, }, { 1, 1, }, }, --Quest when rank100
		[429869]  = { nil, 1,  3,  429869,  211502, 100, 160, 172, 185,   1,   1, { 211422, 4253, }, { 1, 1, }, }, --Quest when rank100
		[435819]  = { nil, 2,  3,  435819,  213369, 200, 200, 210, 220,   1,   1, { 8172, 213370, }, { 1, 5, }, nil, nil, { 215367, }, },
		[435953]  = { nil, 2,  3,  435953,  215382, 235, 225, 230, 235,   1,   1, { 213376, 8172, 213369, 213372, }, { 1, 5, 5, 1, }, nil, nil, { 215424, }, },
		[435904]  = { nil, 2,  3,  435904,  215166, 235, 225, 230, 235,   1,   1, { 213379, 8172, 4291, 213369, }, { 1, 5, 2, 5, }, nil, nil, { 215152, }, },
		[435951]  = { nil, 2,  3,  435951,  215381, 235, 225, 230, 235,   1,   1, { 213372, 8172, 213369, 213379, }, { 1, 5, 5, 1, }, nil, nil, { 215423, }, },
		[435949]  = { nil, 2,  3,  435949,  215114, 235, 225, 230, 235,   1,   1, { 213376, 5785, 213369, 213372, }, { 1, 10, 5, 1, }, nil, nil, { 215422, }, },
		[446186]  = { nil, 3,  3,  446186,  220743, 250, 250, 255, 260,   1,   1, { 221021, 220688, 15416, 8170, }, { 10, 1, 4, 10, }, },
		[446192]  = { nil, 3,  3,  446192,  220745, 250, 250, 255, 260,   1,   1, { 221021, 220688, 15407, 8170, }, { 10, 1, 2, 6, }, },
		[446183]  = { nil, 3,  3,  446183,  220747, 250, 250, 255, 260,   1,   1, { 221021, 220688, 15423, 8170, }, { 10, 1, 8, 4, }, },
		[446189]  = { nil, 3,  3,  446189,  220748, 250, 250, 255, 260,   1,   1, { 221021, 220688, 7080, 8170, }, { 10, 1, 1, 12, }, },
		[446185]  = { nil, 3,  3,  446185,  220742, 250, 250, 255, 260,   1,   1, { 221021, 220688, 15416, 8170, }, { 10, 1, 8, 8, }, },
		[446190]  = { nil, 3,  3,  446190,  220744, 250, 250, 255, 260,   1,   1, { 221021, 220688, 15412, 8170, }, { 10, 1, 8, 8, }, },
		[461720]  = { nil, 4,  3,  461720,  227879, 260, 280, 290, 300,   1,   1, { 8170, 15412, 14341, }, { 20, 25, 2, }, nil, nil, { 228309, }, },
		[461665]  = { nil, 4,  3,  461665,  227867, 270, 290, 300, 310,   1,   1, { 8170, 7078, 7075, 14341, }, { 6, 1, 1, 1, }, nil, nil, { 227908, }, },
		[461649]  = { nil, 4,  3,  461649,  227877, 270, 290, 300, 310,   1,   1, { 8170, 15412, 14341, }, { 20, 25, 1, }, nil, nil, { 227900, }, },
		[461677]  = { nil, 4,  3,  461677,  227878, 270, 300, 310, 320,   1,   1, { 8170, 15412, 14341, }, { 20, 25, 1, }, nil, nil, { 228251, }, },
		[461661]  = { nil, 4,  3,  461661,  227868, 285, 305, 315, 325,   1,   1, { 8170, 7078, 7076, 14341, }, { 8, 1, 1, 1, }, nil, nil, { 227906, }, },
		[461673]  = { nil, 4,  3,  461673,  227875, 285, 305, 315, 325,   1,   1, { 8170, 15415, 15407, 14341, }, { 28, 30, 1, 1, }, nil, nil, { 227898, }, },
		[461722]  = { nil, 4,  3,  461722,  227848, 290, 310, 320, 330,   1,   1, { 8170, 15417, 14341, 7078, }, { 30, 8, 1, 8, }, nil, nil, { 228119, }, },
		[461655]  = { nil, 4,  3,  461655,  227851, 290, 310, 320, 330,   1,   1, { 8170, 15416, 15407, 14341, }, { 40, 60, 1, 2, }, nil, nil, { 227902, }, },
		[461645]  = { nil, 4,  3,  461645,  227873, 295, 315, 325, 335,   1,   1, { 8170, 15415, 12810, 15407, 14341, }, { 28, 30, 2, 1, 1, }, nil, nil, { 227899, }, },
		[462227]  = { nil, 4,  3,  462227,  227874, 300, 320, 330, 340,   1,   1, { 8170, 15415, 15407, 14341, }, { 28, 36, 2, 2, }, },
		[461659]  = { nil, 4,  3,  461659,  227853, 300, 320, 330, 340,   1,   1, { 8170, 15416, 12810, 15407, 14341, }, { 44, 45, 2, 1, 1, }, nil, nil, { 227904, }, },
		[461657]  = { nil, 4,  3,  461657,  227852, 300, 320, 330, 340,   1,   1, { 8170, 15416, 12810, 15407, 14341, }, { 40, 60, 4, 1, 2, }, nil, nil, { 227903, }, },
		[461663]  = { nil, 4,  3,  461663,  227866, 300, 320, 330, 340,   1,   1, { 8170, 7078, 7076, 14341, }, { 10, 1, 1, 2, }, nil, nil, { 227907, }, },
		[461653]  = { nil, 4,  3,  461653,  227869, 300, 320, 330, 340,   1,   1, { 8170, 12607, 15416, 15414, 15407, }, { 30, 12, 30, 30, 5, }, nil, nil, { 227910, }, },
		[461690]  = { nil, 4,  3,  461690,  227854, 300, 320, 330, 340,   1,   1, { 8170, 7082, 12753, 12809, 15407, }, { 30, 12, 4, 8, 4, }, nil, nil, { 228276, }, },
		[461754]  = { nil, 4,  3,  461754,  227882, 300, 320, 330, 340,   1,   1, { 8170, 12804, 15407, 14341, }, { 12, 12, 2, 4, }, nil, nil, { 228319, }, },
		[461706]  = { nil, 4,  3,  461706,  227883, 300, 320, 330, 340,   1,   1, { 8170, 18512, 15420, 15407, 14341, }, { 12, 8, 60, 4, 4, }, nil, nil, { 228301, }, },
		[461724]  = { nil, 4,  3,  461724,  227847, 300, 320, 330, 340,   1,   1, { 8170, 15417, 15407, 14341, 7078, }, { 30, 20, 1, 1, 10, }, nil, nil, { 228120, }, },
		[1213717] = { nil, 6,  3, 1213717,  234294, 300, 320, 330, 340,   1,   1, { 20501, 20498, 18512, 19726, }, { 2, 20, 4, 4, }, nil, nil, { 234295, }, },
		[1213720] = { nil, 6,  3, 1213720,  234296, 300, 320, 330, 340,   1,   1, { 20501, 20498, 18512, 15407, 19726, }, { 4, 30, 4, 2, 6, }, nil, nil, { 234297, }, },
		[1213723] = { nil, 6,  3, 1213723,  234298, 300, 320, 330, 340,   1,   1, { 20501, 20498, 18512, 15407, 19726, }, { 5, 40, 4, 4, 8, }, nil, nil, { 234299, }, },
		[1213726] = { nil, 6,  3, 1213726,  234300, 300, 320, 330, 340,   1,   1, { 20500, 20498, 7078, 19726, }, { 2, 20, 2, 4, }, nil, nil, { 234301, }, },
		[1213728] = { nil, 6,  3, 1213728,  234302, 300, 320, 330, 340,   1,   1, { 20500, 20498, 7078, 15407, 19726, }, { 3, 30, 2, 2, 6, }, nil, nil, { 234303, }, },
		[1213731] = { nil, 6,  3, 1213731,  234304, 300, 320, 330, 340,   1,   1, { 20500, 20498, 7078, 15407, 19726, }, { 4, 40, 2, 4, 8, }, nil, nil, { 234305, }, },
		[1213734] = { nil, 6,  3, 1213734,  234306, 300, 320, 330, 340,   1,   1, { 12810, 12803, 15407, 19726, }, { 6, 4, 2, 4, }, nil, nil, { 234307, }, },
		[1213736] = { nil, 6,  3, 1213736,  234308, 300, 320, 330, 340,   1,   1, { 12810, 18512, 12803, 15407, 19726, }, { 6, 3, 4, 4, 6, }, nil, nil, { 234309, }, },
		[1213738] = { nil, 6,  3, 1213738,  234310, 300, 320, 330, 340,   1,   1, { 12810, 19726, 12803, 15407, }, { 14, 7, 4, 4, }, nil, nil, { 234311, }, },
		[1213751] = { nil, 6,  3, 1213751,  234324, 300, 320, 330, 340,   1,   1, { 12810, 20381, 12803, 15407, 14227, }, { 12, 6, 4, 4, 6, }, nil, nil, { 234325, }, },
		[1213513] = { nil, 6,  3, 1213513,  233802, 300, 320, 330, 340,   1,   1, { 234007, 14342, 18251, }, { 5, 5, 5, }, nil, nil, { 234235, }, },
		[1213519] = { nil, 6,  3, 1213519,  233803, 300, 320, 330, 340,   1,   1, { 234007, 15407, 18251, }, { 5, 5, 5, }, nil, nil, { 234236, }, },
		[1213521] = { nil, 6,  3, 1213521,  233808, 300, 320, 330, 340,   1,   1, { 234007, 12810, 234009, 15407, }, { 15, 8, 8, 8, }, nil, nil, { 234237, }, },
		[1213523] = { nil, 6,  3, 1213523,  233804, 300, 320, 330, 340,   1,   1, { 234007, 12810, 234009, 15407, }, { 15, 8, 8, 8, }, nil, nil, { 234238, }, },
		[1213525] = { nil, 6,  3, 1213525,  233813, 300, 320, 330, 340,   1,   1, { 234007, 12810, 234009, 15407, }, { 22, 12, 12, 12, }, nil, nil, { 234239, }, },
		[1214303] = { nil, 6,  3, 1214303,  234482, 300, 320, 330, 340,   1,   1, { 12810, 20381, 12803, 15407, 14227, }, { 12, 6, 4, 4, 6, }, nil, nil, { 234481, }, },

		[426607]  = { nil, 1,  4,  426607,  210708,  90,  90, 100, 110,   1,   1, { 3820, 3372, 3369, 11083, }, { 5, 1, 5, 1, }, nil, nil, { 210709, }, },
		[439960]  = { nil, 2,  4,  439960,  217398, 190, 210, 212, 215,   1,   1, { 3356, 3821, 8925, }, { 1, 1, 1, }, nil, nil, { 217399, }, },
		[435969]  = { nil, 2,  4,  435969,  213372, 200, 200, 210, 220,   1,   1, { 3372, 213371, }, { 1, 5, }, nil, nil, { 215433, }, },
		[435971]  = { nil, 2,  4,  435971,  215162, 225, 225, 230, 235,   6,   5, { 213371, 2456, 215430, 8925, }, { 1, 1, 3, 5, }, nil, nil, { 215163, }, },
		[446226]  = { nil, 3,  4,  446226,  221024, 250, 250, 255, 260,   1,   1, { 221021, 220688, 8925, }, { 10, 1, 1, }, },
		[446851]  = { nil, 3,  4,  446851,  221313, 250, 250, 255, 260,   1,   1, { 221021, 8925, 221312, }, { 5, 1, 5, }, },
		[448085]  = { nil, 3,  4,  448085,  222952, 250, 250, 255, 260,   1,   1, { 221021, 220688, 8925, }, { 10, 1, 1, }, },
		[1213544] = { nil, 6,  4, 1213544,  233966, 300, 315, 322, 330,   1,   1, { 16203, 234012, 13511, 8925, }, { 1, 1, 1, 1, }, nil, nil, { 234252, }, },
		[1213548] = { nil, 6,  4, 1213548,  233965, 300, 315, 322, 330,   1,   1, { 16203, 234006, 13510, 8925, }, { 1, 1, 1, 1, }, nil, nil, { 234255, }, },
		[1213546] = { nil, 6,  4, 1213546,  233964, 300, 315, 322, 330,   1,   1, { 16203, 234011, 13512, 8925, }, { 1, 1, 1, 1, }, nil, nil, { 234253, }, },
		[1213552] = { nil, 6,  4, 1213552,  233962, 300, 315, 322, 330,   1,   1, { 16203, 234010, 13513, 8925, }, { 1, 1, 1, 1, }, nil, nil, { 234256, }, },
		[1213559] = { nil, 6,  4, 1213559,  233967, 300, 315, 322, 330,   1,   1, { 13465, 234012, 234011, 8925, }, { 2, 2, 1, 1, }, nil, nil, { 234257, }, },
		[1213563] = { nil, 6,  4, 1213563,  233968, 300, 315, 322, 330,   1,   1, { 13466, 234012, 234011, 8925, }, { 2, 2, 1, 1, }, nil, nil, { 234258, }, },
		[1213565] = { nil, 6,  4, 1213565,  233969, 300, 315, 322, 330,   1,   1, { 13467, 234012, 234011, 8925, }, { 2, 2, 1, 1, }, nil, nil, { 234259, }, },
		[1213571] = { nil, 6,  4, 1213571,  233977, 300, 315, 322, 330,   1,   1, { 13463, 234012, 234011, 8925, }, { 2, 2, 1, 1, }, nil, nil, { 234260, }, },

		[470359]  = { nil, 6,  6,  470359,  232436, 300, 325, 345, 365,   1,   1, { 13888, 227813, }, { 1, 1, }, nil, nil, { 232437, }, },
		[470370]  = { nil, 6,  6,  470370,  232438, 300, 325, 345, 365,   1,   1, { 13758, }, { 1, }, nil, nil, { 232443, }, },

		[1213638] = { nil, 6,  7, 1213638,  234003, 300, 315, 322, 330,   1,   1, { 12655, 22203, }, { 2, 2, }, nil, nil, { 234278, }, },

		--	mod old
		[439085]  = { nil, 1,  8,  439085,  217245, 205, 220, 235, 250,   1,   1, { 4305, 7068, 3827, 2604, 4291, }, { 8, 4, 2, 4, 1, }, nil, nil, { 217244, }, },
		[439086]  = { nil, 1,  8,  439086,  217246, 205, 220, 235, 250,   1,   1, { 4339, 4291, }, { 2, 3, }, }, --copy its original skill rank
		[439088]  = { nil, 1,  8,  439088,  217247, 205, 220, 235, 250,   1,   1, { 4339, 4291, }, { 2, 3, }, }, --copy its original skill rank
		[439091]  = { nil, 1,  8,  439091,  217248, 195, 215, 230, 245,   1,   1, { 4305, 7067, 4234, 7071, 4291, }, { 5, 4, 4, 1, 2, }, nil, nil, { 217249, }, },
		[439093]  = { nil, 1,  8,  439093,  217250, 190, 210, 225, 240,   1,   1, { 4305, 6371, 2604, 4291, }, { 5, 2, 2, 2, }, nil, nil, { 217251, }, },
		[439094]  = { nil, 1,  8,  439094,  217252, 185, 205, 220, 235,   1,   1, { 4305, 3827, 4291, }, { 4, 1, 1, }, }, --copy its original skill rank
		[439097]  = { nil, 1,  8,  439097,  217253, 175, 195, 210, 225,   1,   1, { 4305, 4291, 4337, }, { 4, 1, 2, }, nil, nil, { 217254, }, },
		[439098]  = { nil, 1,  8,  439098,  217255, 175, 195, 210, 225,   1,   1, { 4305, 7071, 2604, 4291, }, { 4, 1, 2, 1, }, }, --copy its original skill rank
		[439100]  = { nil, 1,  8,  439100,  217256, 170, 190, 205, 220,   1,   1, { 4305, 7067, 2321, }, { 3, 1, 2, }, }, --copy its original skill rank
		[439102]  = { nil, 1,  8,  439102,  217257, 165, 185, 200, 215,   1,   1, { 4305, 2321, 4337, }, { 3, 2, 2, }, nil, nil, { 217158, }, },
		[461692]  = { nil, 1,  8,  461692,  227855, 285, 285, 290, 295,   1,   1, { 8170, 14048, 18240, 14341, }, { 4, 2, 1, 1, }, nil, nil, { 228115, }, },--copy its original skill rank
		[461727]  = { nil, 1,  8,  461727,  227844, 300, 315, 330, 345,   1,   1, { 14048, 8170, 14341, 15407, }, { 5, 2, 1, 1, }, nil, nil, { 228121, }, },
		[463972]  = { nil, 1,  8,  463972,  228994, 300, 315, 330, 345,   1,   1, { 14048, 14342, 14344, 17012, 14341, }, { 8, 12, 2, 2, 2, }, nil, nil, { 228993, }, },
		--	new
		[428424]  = { nil, 1,  8,  428424,  210781, 125, 125, 137, 150,   1,   1, { 2997, 814, 2321, }, { 6, 2, 2, }, nil, nil, { 211247, }, },
		[435848]  = { nil, 1,  8,  435848,  215365, 150, 170, 185, 200,   1,   1, { 4305, 4340, 2321, 6260, }, { 4, 4, 1, 4, }, nil, nil, { 215370, }, },
		[435841]  = { nil, 1,  8,  435841,  215366, 150, 170, 185, 200,   1,   1, { 4305, 1210, 2321, 4340, }, { 3, 1, 1, 1, }, nil, nil, { 215369, }, },
		[429351]  = { nil, 1,  8,  429351,  210795, 100, 150, 167, 185,   1,   1, { 211422, 4320, }, { 1, 1, }, }, --Quest when rank100
		[435827]  = { nil, 2,  8,  435827,  213379, 200, 200, 210, 220,   1,   1, { 4339, 213378, 8343, }, { 2, 5, 5, }, nil, nil, { 215368, }, },
		[435610]  = { nil, 2,  8,  435610,  215111, 225, 225, 230, 235,   1,   1, { 213379, 213369, 213372, 11137, 4339, }, { 5, 1, 1, 10, 10, }, nil, nil, { 215149, }, },
		[446193]  = { nil, 3,  8,  446193,  220750, 250, 250, 255, 260,   1,   1, { 221021, 220688, 14256, 14048, }, { 10, 1, 8, 8, }, },
		[446194]  = { nil, 3,  8,  446194,  220749, 250, 250, 255, 260,   1,   1, { 221021, 220688, 12803, 14048, }, { 10, 1, 4, 10, }, },
		[446195]  = { nil, 3,  8,  446195,  220751, 250, 250, 255, 260,   1,   1, { 221021, 220688, 14256, 7080, 14048, }, { 10, 1, 6, 1, 3, }, },
		[461752]  = { nil, 4,  8,  461752,  227864, 290, 305, 320, 335,   1,   1, { 14048, 14342, 14341, }, { 6, 4, 1, }, nil, nil, { 228318, }, },
		[461708]  = { nil, 4,  8,  461708,  227861, 300, 315, 330, 345,   1,   1, { 14048, 14342, 13926, 14341, }, { 6, 4, 2, 2, }, nil, nil, { 228303, }, },
		[461747]  = { nil, 4,  8,  461747,  227860, 300, 315, 330, 345,   1,   1, { 14048, 14342, 14341, }, { 6, 4, 1, }, nil, nil, { 228316, }, },
		[461750]  = { nil, 4,  8,  461750,  227863, 300, 315, 330, 345,   1,   1, { 14048, 14342, 12800, 12810, 14341, }, { 4, 6, 1, 2, 2, }, nil, nil, { 228317, }, },
		[462282]  = { nil, 4,  8,  462282,  228476, 300, 315, 330, 345,   1,   1, { 14048, 9210, 14342, 7080, 7078, }, { 16, 10, 10, 12, 12, }, nil, nil, { 228477, }, },
		[1214173] = { nil, 6,  8, 1214173,  234009, 300, 315, 322, 330,   1,   1, { 234008, }, { 5, }, nil, nil, { 234445, }, },
		[1213740] = { nil, 6,  8, 1213740,  234312, 300, 315, 330, 345,   1,   1, { 14048, 12803, 14227, 19726, }, { 4, 4, 4, 3, }, nil, nil, { 234314, }, },
		[1213742] = { nil, 6,  8, 1213742,  234315, 300, 315, 330, 345,   1,   1, { 14048, 14342, 12803, 14227, 19726, }, { 4, 4, 3, 3, 4, }, nil, nil, { 234316, }, },
		[1213744] = { nil, 6,  8, 1213744,  234317, 300, 315, 330, 345,   1,   1, { 14048, 19726, 12803, 14227, 14342, }, { 4, 3, 2, 3, 4, }, nil, nil, { 234318, }, },
		[1213532] = { nil, 6,  8, 1213532,  233837, 300, 315, 330, 345,   1,   1, { 234009, 14342, 12810, 14341, }, { 25, 12, 12, 1, }, nil, nil, { 234242, }, },
		[1213530] = { nil, 6,  8, 1213530,  233833, 300, 315, 330, 345,   1,   1, { 234009, 14342, 12810, 14341, }, { 15, 8, 8, 1, }, nil, nil, { 234241, }, },
		[1213527] = { nil, 6,  8, 1213527,  233826, 300, 315, 330, 345,   1,   1, { 234009, 14342, 12810, 14341, }, { 15, 8, 8, 1, }, nil, nil, { 234240, }, },
		[1213536] = { nil, 6,  8, 1213536,  233958, 300, 320, 330, 340,   1,   1, { 234009, 234007, 15407, 12810, 14341, }, { 12, 8, 8, 8, 1, }, nil, nil, { 234249, }, },
		[1213538] = { nil, 6,  8, 1213538,  233959, 300, 320, 330, 340,   1,   1, { 234009, 234007, 15407, 12810, 14341, }, { 12, 8, 8, 8, 1, }, nil, nil, { 234250, }, },
		[1213540] = { nil, 6,  8, 1213540,  233960, 300, 320, 330, 340,   1,   1, { 234009, 234007, 15407, 12810, 14341, }, { 12, 8, 8, 8, 1, }, nil, nil, { 234251, }, },
		[1213534] = { nil, 6,  8, 1213534,  233956, 300, 320, 330, 340,   1,   1, { 234009, 234007, 15407, 12810, 14341, }, { 12, 8, 8, 8, 1, }, nil, nil, { 234244, }, },
		[1214306] = { nil, 6,  8, 1214306,  234484, 300, 320, 330, 340,   1,   1, { 14048, 20381, 12803, 14342, 14227, }, { 30, 4, 4, 4, 6, }, nil, nil, { 234483, }, },
		[1214307] = { nil, 6,  8, 1214307,  234485, 300, 320, 330, 340,   1,   1, { 14048, 20381, 12803, 14342, 14227, }, { 30, 5, 4, 4, 6, }, nil, nil, { 234486, }, },

		[424641]  = { nil, 1,  9,  424641,  210147, 135, 135, 140, 145,   1,   1, { 4382, 4375, 4234, }, { 1, 2, 1, }, },
		[435956]  = { nil, 2,  9,  435956,  213383, 200, 200, 210, 220,   1,   1, { 6037, 213381, }, { 1, 5, }, nil, nil, { 215429, }, },
		[431362]  = { nil, 2,  9,  431362,  211427, 205, 205, 210, 215,   1,   1, { 1210, 9262, 16583, }, { 4, 1, 1, }, nil, nil, { 212230, }, },
		[435966]  = { nil, 2,  9,  435966,  215168, 225, 225, 230, 235,   2,   5, { 10505, 215430, 3860, }, { 2, 1, 2, }, nil, nil, { 215432, }, },
		[435964]  = { nil, 2,  9,  435964,  215127, 225, 225, 230, 235,   2,   5, { 10505, 215430, 3860, }, { 1, 1, 2, }, nil, nil, { 215431, }, },
		[435960]  = { nil, 2,  9,  435960,  215115, 225, 225, 230, 235,   1,   1, { 213383, 213379, 213369, 3577, }, { 3, 3, 1, 10, }, nil, nil, { 215156, }, },
		[435958]  = { nil, 2,  9,  435958,  213390, 225, 225, 232, 240,   1,   1, { 213376, 213383, 213369, 10561, 4389, }, { 3, 5, 2, 2, 2, }, nil, nil, { 215153, }, },
		[446236]  = { nil, 3,  9,  446236,  221025, 250, 250, 255, 260,   1,   1, { 221021, 220688, 220689, 10558, 15994, }, { 10, 1, 1, 2, 2, }, },
		[446238]  = { nil, 3,  9,  446238,  221027, 250, 250, 255, 260,   1,   1, { 221021, 220688, 220689, 10558, 16000, }, { 10, 1, 1, 2, 2, }, },
		[446237]  = { nil, 3,  9,  446237,  221026, 250, 250, 255, 260,   1,   1, { 221021, 220688, 220689, 15992, 7910, }, { 10, 1, 1, 3, 2, }, },
		[461710]  = { nil, 4,  9,  461710,  227849, 300, 320, 330, 340,   1,   1, { 17010, 17011, 12360, 16006, 16000, }, { 4, 2, 6, 2, 2, }, nil, nil, { 228304, }, },
		-- [1217207] = { nil, 6,  9, 1217207,  235529,   0, 320, 330, 340,   1,   1, { 16000, 12363, 234003, }, { 1, 1, 3, }, },	-- maybe unexist
		[1213573] = { nil, 6,  9, 1213573,  233984, 300, 315, 322, 330,   6,   5, { 16006, 20725, 14047, }, { 1, 1, 1, }, nil, nil, { 234261, }, },
		[1213576] = { nil, 6,  9, 1213576,  233985, 300, 315, 322, 330,   1,   1, { 234011, 234005, 14047, }, { 1, 2, 1, }, nil, nil, { 234262, }, },
		[1213578] = { nil, 6,  9, 1213578,  233986, 300, 315, 322, 330,   4,   3, { 234005, 234007, 234008, 12365, }, { 3, 1, 1, 1, }, nil, nil, { 234263, }, },
		-- [1213586] = { nil, 6,  9, 1213586,  233987, 300, 315, 322, 330,   2,   1, { 234005, 234012, 234009, 234011, 234010, }, { 20, 30, 8, 8, 8, }, nil, nil, { 234264, }, },	-- maybe unexist
		[1213588] = { nil, 6,  9, 1213588,  233988, 300, 315, 322, 330,   2,   1, { 18168, 234007, 234003, 234005, }, { 1, 4, 10, 10, }, nil, nil, { 234265, }, },
		[1213646] = { nil, 6,  9, 1213646,  234005, 300, 315, 322, 330,   2,   1, { 22202, }, { 2, }, nil, nil, { 234280, }, },
		[1214145] = { nil, 6,  9, 1214145,  234434, 300, 320, 330, 340,   1,   1, { 12360, 234003, 20725, 20868, 20870, }, { 30, 8, 3, 3, 3, }, nil, nil, { 234435, }, },

		--	mod old
		[439134]  = { nil, 1, 10,  439134,  217287, 175, 195, 215, 235,   1,   1, { 11291, 11135, 11137, }, { 1, 1, 1, }, }, --copy its original skill rank
		-- [439505]  = { nil, 1, 13,  439505,  217346,   0, 300, 325, 350,   1,   1, { 8924, 8925, 8923, }, { 3, 1, 1, }, },	-- invalid skill
		-- [439503]  = { nil, 1, 13,  439503,  217347,   0, 300, 325, 350,   1,   1, { 8924, 8925, }, { 7, 1, }, },	-- invalid skill
		-- [439500]  = { nil, 1, 13,  439500,  217345,   0, 300, 325, 350,   1,   1, { 8923, 8925, }, { 4, 1, }, },	-- invalid skill
		[1213616] = { nil, 1, 10, 1213616,     nil, 300, 320, 340, 360,   0,   0, { 20725, 16204, 16203, 13458, 234011, }, { 2, 8, 5, 10, 2, }, nil, nil, { 233997, }, },
		[1213622] = { nil, 1, 10, 1213622,     nil, 300, 320, 340, 360,   0,   0, { 20725, 14344, 13180, 12735, }, { 2, 5, 5, 2, }, nil, nil, { 233998, }, },
		[1213626] = { nil, 1, 10, 1213626,     nil, 300, 320, 340, 360,   0,   0, { 20725, 14344, 12753, }, { 2, 5, 2, }, nil, nil, { 233999, }, },
		--	new
		[430409]  = { nil, 1, 10,  430409,  211848, 100, 100, 110, 120,   1,   0, { 3372, 10939, 10940, }, { 1, 1, 5, }, nil, nil, { 211849, }, },
		[435481]  = { nil, 2, 10,  435481,     nil, 225, 200, 217, 235,   0,   0, { 11174, 5637, 11177, }, { 4, 2, 2, }, nil, nil, { 215129, }, },
		[435903]  = { nil, 2, 10,  435903,     nil, 225, 200, 220, 240,   0,   0, { 11177, 11176, }, { 1, 2, }, nil, nil, { 215138, }, },
		[439156]  = { nil, 2, 10,  439156,  217308, 225, 225, 227, 230,   1,   1, { 11137, }, { 5, }, nil, nil, { 215141, }, },
		[448624]  = { nil, 3, 10,  448624,  220792, 120, 120, 125, 130,   1,   1, { 4470, 10940, }, { 1, 4, }, },
		[446243]  = { nil, 3, 10,  446243,  221028, 250, 250, 255, 260,   1,   1, { 11176, }, { 5, }, },
		[463869]  = { nil, 4, 10,  463869,  228980, 275, 285, 295, 305,   1,   0, { 16204, 4625, 8925, }, { 2, 1, 1, }, nil, nil, { 228981, }, },
		[463866]  = { nil, 4, 10,  463866,  228978, 290, 305, 312, 320,   1,   1, { 16204, }, { 1, }, nil, nil, { 228979, }, },
		[463871]  = { nil, 4, 10,  463871,     nil, 300, 320, 340, 360,   0,   0, { 14344, 16203, 7078, 7080, 7076, }, { 4, 12, 4, 4, 1, }, nil, nil, { 228982, }, },
		-- [1217189] = { nil, 6, 10, 1217189,     nil,   0, 320, 340, 360,   0,   0, { 14344, 16204, 16203, 7080, 7078, }, { 2, 20, 4, 2, 2, }, },	-- invalid skill
		-- [1217203] = { nil, 6, 10, 1217203,     nil,   0, 320, 340, 360,   0,   0, { 20725, 16204, 16203, 7082, }, { 2, 10, 2, 2, }, },	-- invalid skill
		[471400]  = { nil, 6, 10,  471400,  232611, 300, 310, 320, 330,   1,   0, { 8151, 8152, 14344, 18256, }, { 3, 3, 2, 1, }, nil, nil, { 232610, }, },
		[1213593] = { nil, 6, 10, 1213593,  233990, 300, 320, 340, 360,   1,   0, { 234006, 234010, 20725, 234004, 2452, }, { 10, 10, 6, 6, 20, }, nil, nil, { 234266, }, },
		[1213595] = { nil, 6, 10, 1213595,  233991, 300, 320, 340, 360,   1,   0, { 234006, 234010, 20725, 234003, 234012, }, { 10, 10, 6, 10, 10, }, nil, nil, { 234267, }, },
		[1213598] = { nil, 6, 10, 1213598,  233992, 300, 320, 340, 360,   1,   0, { 234007, 234010, 20725, 234003, 234011, }, { 10, 5, 6, 15, 10, }, nil, nil, { 234268, }, },
		[1213600] = { nil, 6, 10, 1213600,  233993, 300, 320, 340, 360,   1,   0, { 234003, 234005, 14344, 2459, }, { 12, 9, 6, 3, }, nil, nil, { 234269, }, },
		[1213603] = { nil, 6, 10, 1213603,  233994, 300, 320, 340, 360,   1,   0, { 234007, 234010, 20725, 234003, 234012, }, { 10, 5, 6, 10, 10, }, nil, nil, { 234270, }, },
		[1213607] = { nil, 6, 10, 1213607,  233995, 300, 320, 340, 360,   1,   1, { 16203, 14047, }, { 1, 1, }, nil, nil, { 234271, }, },
		[1213610] = { nil, 6, 10, 1213610,  233996, 300, 320, 340, 360,   1,   0, { 234011, 234012, 16204, }, { 3, 3, 2, }, nil, nil, { 234272, }, },
		[1213628] = { nil, 6, 10, 1213628,  234000, 300, 320, 340, 360,   1,   0, { 20725, 234008, 234003, 12810, }, { 3, 10, 2, 4, }, nil, nil, { 234275, }, },
		[1213633] = { nil, 6, 10, 1213633,  234001, 300, 320, 340, 360,   1,   0, { 20725, 234012, 234003, 12810, }, { 3, 10, 4, 3, }, nil, nil, { 234276, }, },
		[1213635] = { nil, 6, 10, 1213635,  234002, 300, 320, 340, 360,   1,   0, { 20725, 234012, 12810, 234011, 234010, }, { 2, 20, 3, 4, 4, }, nil, nil, { 234277, }, },
		[1216005] = { nil, 6, 10, 1216005,  234477, 300, 320, 340, 360,   1,   0, { 20725, 234008, 234003, 12810, }, { 3, 10, 2, 4, }, nil, nil, { 235133, }, },
		[1216007] = { nil, 6, 10, 1216007,  234475, 300, 320, 340, 360,   1,   0, { 20725, 234008, 234003, 12810, }, { 3, 10, 2, 4, }, nil, nil, { 235134, }, },
		[1216010] = { nil, 6, 10, 1216010,  234476, 300, 320, 340, 360,   1,   0, { 20725, 234008, 234003, 12810, }, { 3, 10, 2, 4, }, nil, nil, { 235135, }, },
		[1216014] = { nil, 6, 10, 1216014,  234480, 300, 320, 340, 360,   1,   0, { 20725, 234012, 234003, 12810, }, { 3, 10, 4, 3, }, nil, nil, { 235136, }, },
		[1216016] = { nil, 6, 10, 1216016,  234478, 300, 320, 340, 360,   1,   0, { 20725, 234012, 234003, 12810, }, { 3, 10, 4, 3, }, nil, nil, { 235137, }, },
		[1216018] = { nil, 6, 10, 1216018,  234479, 300, 320, 340, 360,   1,   0, { 20725, 234012, 234003, 12810, }, { 3, 10, 4, 3, }, nil, nil, { 235138, }, },
		[1216020] = { nil, 6, 10, 1216020,  234474, 300, 320, 340, 360,   1,   0, { 20725, 234012, 12810, 234011, 234010, }, { 2, 20, 3, 4, 4, }, nil, nil, { 235139, }, },
		[1216022] = { nil, 6, 10, 1216022,  234469, 300, 320, 340, 360,   1,   0, { 20725, 234012, 12810, 234011, 234010, }, { 2, 20, 3, 4, 4, }, nil, nil, { 235140, }, },
		[1216024] = { nil, 6, 10, 1216024,  234468, 300, 320, 340, 360,   1,   0, { 20725, 234012, 12810, 234011, 234010, }, { 2, 20, 3, 4, 4, }, nil, nil, { 235141, }, },

		[458822]  = { nil, 1, 13,  458822,  226374, 270, 295, 320, 345,   1,   1, { 5173, 8925, 8923, }, { 5, 1, 5, }, },
		[1214168] = { nil, 6, 13, 1214168,  234444, 300, 300, 325, 350,   1,   1, { 5173, 8925, }, { 7, 1, }, nil, nil, { 234124, }, },
	};
	for sid, info in next, DataAgent.SoDData do
		T_Recipe_Data[sid] = info;
		local pid = info[index_pid];
		local list = T_TradeSkill_RecipeList[pid];
		if list then
			list[#list + 1] = sid;
		end
	end
	local function sortmethod(i, j)
		local x = T_Recipe_Data[i];
		local y = T_Recipe_Data[j];
		if x[index_learn_rank] < y[index_learn_rank] then
			return true;
		elseif x[index_learn_rank] == y[index_learn_rank] then
			if x[index_yellow_rank] < y[index_yellow_rank] then
				return true;
			elseif x[index_yellow_rank] == y[index_yellow_rank] then
				if x[index_green_rank] < y[index_green_rank] then
					return true;
				elseif x[index_green_rank] == y[index_green_rank] then
					if x[index_grey_rank] < y[index_grey_rank] then
						return true;
					elseif x[index_grey_rank] == y[index_grey_rank] then
						return i < j;
					else
						return false;
					end
				else
					return false;
				end
			else
				return false;
			end
		else
			return false;
		end
	end
	for pid = DataAgent.DBMINPID, DataAgent.DBMAXPID do
		local list = T_TradeSkill_RecipeList[pid];
		if list then
			sort(list, sortmethod);
		end
	end
end
