## SpellActivationOverlay Changelog

#### v2.5.7 (2025-07-15)

Thank you to our amazing contributors for helping out. Thanks!
- Jumpsuitpally for sending feedback about Paladin and Monk
- Krablord for sending feedback about Rogue and Shaman
- Bruni for reporting an issue that triggered false positive unknown effects
- omeletteman91, Adal4, Yume and Nait292 for reporting unsupported effects
- Fractale for helping on resolving an unsupported effect

Options Panel
- In Mists of Pandaria, players are asked to disable game's spell alerts
- This question is answered at first start and the addon remembers the answer
- If the player disabled game's spell alerts, the addon will re-check later
- But if the player asked to keep them, the question is gone forever
- There is now a checkbox in the Options Panel to check again at each start
- Checking at each start will *not* necessarily ask the question every time
- It will only ask the question again when the addon detects a conflict

New Spell Alerts
- Hunter's Focus Fire (Mists of Pandaria)
- Monk's Vital Mists (Mists of Pandaria)

Updated Spell Alerts
- Monk's Blackout Kick is now only displayed right (Mists of Pandaria)
- Monk's Tiger Palm is now green-ish and displayed left (Mists of Pandaria)
- Paladin's Infusion of Light now uses Daybreak visuals\* (Mists of Pandaria)
- Paladin's Daybreak now uses Sun-like visuals\* (Mists of Pandaria)

\* With these changes, Infusion of Light now matches the reference client

New Glowing Buttons
- Rogue's Dispatch, when the target has less than 35% hp (Mists of Pandaria)
- Shaman's Lava Burst, as combat-only counter (Mists of Pandaria)

Removed Glowing Buttons\*\*
- Paladin's Hammer of Wrath (Mists of Pandaria)
- Paladin's Holy Shock, during Daybreak (Mists of Pandaria)
- Paladin's Divine Light, during Infusion of Light (Mists of Pandaria)
- Paladin's Holy Light, during Infusion of Light (Mists of Pandaria)
- Paladin's Holy Radiance, during Infusion of Light (Mists of Pandaria)
- Paladin's Avenger's Shield, during Grand Crusader (Mists of Pandaria)

\*\* These buttons are already glowing by the game client

Bug Fixes
- Text from the lower-right box of the Options Panel could display squares
- This affected non-ASCII characters e.g., accents or non-Latin characters
- Known effects should no longer be reported as unknown (Mists of Pandaria)
- In very rare cases, glowing a button could trigger a Lua error

Ghosts\*\*\* Busted
- Hunter's Mongoose Bite (Classic Era, The Burning Crusade)
- Hunter's Flanking Strike (Season of Discovery)
- Shaman's Rolling Thunder  (Season of Discovery, The Burning Crusade)
- Shaman's Molten Blast (Season of Discovery)
- Shaman's Fulmination (Cataclysm, Mists of Pandaria)
- Shaman's Lava Surge (Cataclysm, Mists of Pandaria)

\*\*\*A Ghost is an overlay that fades out then reappears out of nowhere

Miscellaneous
- All checkboxes are now translated at the bottom of the Options Panel

#### v2.5.6 (2025-07-05)

Thank you to our amazing contributors for reporting issues. Thanks!
- jokke and mistik911 for reporting the Warrior's Overpower issue
- Adal4 for reporting the Paladin's The Art of War issue
- Amanthuul and kakukembo for reporting the Druid's Eclipse issue

New Spell Alert
- Paladin's The Art of War (Mists of Pandaria)

Bug Fixes
- Druids no longer get Eclipse textures errors at start (Mists of Pandaria)
- Counters would not always glow at Rank 2 and higher (Era, TBC, Wrath)

Here is the complete list of counters affected by the latter issue
- Hunter's Counterattack (Era, TBC, Wrath)
- Hunter's Kill Shot (Wrath)
- Hunter's Mongoose Bite (Era, TBC)
- Paladin's Exorcism (Era, TBC, Wrath)
- Paladin's Hammer of Wrath (Era, TBC, Wrath)
- Paladin's Holy Shock (Era, TBC, Wrath)
- Warrior's Execute (Era, TBC, Wrath)
- Warrior's Overpower (Era, TBC)
- Warrior's Revenge (Era, TBC, Wrath)

#### v2.5.5 (2025-07-01)

There is now a Universal build that works for all flavors: Era, Cataclysm, etc.
Players are still encouraged to install optimized build for each flavor
Universal is provided for convenience to players who install addons manually

New Spell Alerts
- Soulburn (Cataclysm)
- Demonic Rebirth (Cataclysm)

Miscellaneous
- The addon's license has been updated

#### v2.5.4 (2025-06-23)

Thank you to our amazing contributors for sending feedback. Thanks!
- Amanthuul
- TeamRemix
- Jumpsuitpally
- Optimizer2347

Options Panel
- The class name is now displayed once in the options panel

New Spell Alerts
- Warlock's Eye of Kilrogg
- Warlock's Nightfall (Mists of Pandaria)
- Warlock's Soulburn (Mists of Pandaria)
- Warlock's Molten Core (Mists of Pandaria)
- Warlock's Demonic Rebirth (Mists of Pandaria)
- Warlock's Backlash (Mists of Pandaria)
- Warlock's Fire and Brimstone (Mists of Pandaria)
- Warrior's Victory Rush (Mists of Pandaria)
- Warrior's Taste for Blood (Mists of Pandaria)
- Warrior's Sudden Death (Mists of Pandaria)
- Warrior's Bloodsurge (Mists of Pandaria)
- Warrior's Sword and Board (Mists of Pandaria)
- Warrior's Ultimatum (Mists of Pandaria)

New Glowing Buttons
- Warlocks's Drain Soul, when the target has 20% health or less (MoP)
- Warlocks's Incinerate, during Backdraft (Mists of Pandaria)
- Warlocks's Chaos Bolt, during Backdraft (Mists of Pandaria)
- Warlocks's Incinerate, during Fire and Brimstone (Mists of Pandaria)
- Warlocks's Immolate, during Fire and Brimstone (Mists of Pandaria)
- Warlocks's Conflagrate, during Fire and Brimstone (Mists of Pandaria)
- Warlocks's Curse of the Elements, during Fire and Brimstone (MoP)
- Warlocks's Curse of Enfeeblement, during Fire and Brimstone (MoP)
- Warrior's Overpower, during Taste for Blood (Mists of Pandaria)
- Warrior's Victory Rush, during Victorious (Mists of Pandaria)
- Warrior's Impending Victory, during Victorious (Mists of Pandaria)

Bug Fixes
- Restored options to disable buttons of Mage's Freeze (Mists of Pandaria)
- Fixed animations of Shaman's Fulmination (Cataclysm, Mists of Pandaria)
- Fixed animations of Shaman's Rolling Thunder (Season of Discovery)

Miscellaneous
- Spell alerts disappear after leaving combat for more than 60 secs, up from 30

#### v2.5.3 (2025-06-17)

SpellActivationOverlay vs. SpellActivationOverlay
- The game's spell alert options are now checked at start (Mists of Pandaria)
- You will be asked to disable the game's spell alert to avoid conflicts
- With the current state of the game, it is best to disable them for now

Unsupported Spell Alerts (Mists of Pandaria)
- A message is displayed when detecting an unsupported spell alert
- You are encouraged to report them, thank you in advance for your help :)
- Such messages are enabled by default and can be disabled in the options panel

New Spell Alerts
- Monk's Combo Breaker: Blackout Kick
- Monk's Combo Breaker: Tiger Palm
- Rogue's Blindside (Mists of Pandaria)

Internationalization
- Traditional Chinese (zh-TW) is now fully supported
- This does not include Debug messages which are almost always in English
- This does not include Necrosis warnings, which are not supposed to happen

Miscellaneous
- The addon flavor is now displayed in the options panel
- Players are warned when they install the wrong flavor for their game client

#### v2.5.2 (2025-06-13)

Thank you to Bison for sending feedback about Feral druids. Thanks!

Options Panel
- 'Toggle Test' now previews spell alerts on top of the options panel
- Moving the mouse over a spell alert in the options panel also previews on top

New Spell Alerts
- Dream of Cenarius, in Guardian specialization (Mists of Pandaria)
- Dream of Cenarius, in Feral specialization (Mists of Pandaria)
- Hunter's Master Marksman (Mists of Pandaria)
- Hunter's Lock and Load (Mists of Pandaria)
- Hunter's Thrill of the Hunt (Mists of Pandaria)

Updated Spell Alerts
- Druid's Omen of Clarity (Feral) has been scaled down (Mists of Pandaria)
- Hunter's Lock and Load is slightly dimmer at 1 stack (Wrath, Cataclysm)

Bug Fixes
- The addon should no longer conflict with the game client (Mists of Pandaria)
- Hunter's Lock and Load no longer plays a sound at 1 stack (Wrath, Cataclysm)
- Paladins no longer have an error at start about Eternal Flame (Cataclysm)

Miscellaneous
- The addon is now capable of overlapping spell alerts with a predictable order

#### v2.5.1 (2025-06-10)

Thank you to Siegester03 for helping a great deal with Mage. Many thanks!

New Spell Alerts
- Druid's Lunar Eclipse and Solar Eclipse (Mists of Pandaria)
- Druid's Shooting Stars (Mists of Pandaria)
- Druid's Tooth and Claw (Mists of Pandaria)
- Druid's Predatory Swiftness (Mists of Pandaria)
- Druid's Omen of Clarity, for Feral and Restoration (Mists of Pandaria)
- Mage's Arcane Missiles (Mists of Pandaria)
- Mage's Heating Up (Mists of Pandaria)
- Mage's Hot Streak (Mists of Pandaria)
- Mage's Brain Freeze (Mists of Pandaria)
- Mage's Fingers of Frost (Mists of Pandaria)

New Glowing Buttons
- Druid's Entangling Roots, during Predatory Swiftness (Mists of Pandaria)
- Druid's Healing Touch, during Predatory Swiftness (Mists of Pandaria)
- Druid's Hibernate, during Predatory Swiftness (Mists of Pandaria)
- Druid's Rebirth, during Predatory Swiftness (Mists of Pandaria)
- Mage's Arcane Missiles, during Arcane Missiles (Mists of Pandaria)
- Mage's Inferno Blast, during Heating Up (Mists of Pandaria)
- Mage's Pyroblast, during Hot Streak (Mists of Pandaria)
- Mage's Frostfire Bolt, during Brain Freeze (Mists of Pandaria)
- Mage's Deep Freeze, during Fingers of Frost (Mists of Pandaria)
- Mage's Ice Lance, during Fingers of Frost (Mists of Pandaria)
- Priest's Devouring Plague, at 3 Shadow Orbs (Mists of Pandaria)

Known Limitations
- Priest's Devouring Plague may glow up to 30 seconds after leaving combat

#### v2.5.0 (2025-06-08)

Thank you to Katalina for sending feedback and testing Paladin. Appreciated!

New Spell Alerts
- Paladin's charges of Holy Power (Mists of Pandaria)
- Paladin's Infusion of Light (Mists of Pandaria)
- Paladin's Daybreak (Mists of Pandaria)
- Paladin's Grand Crusader (Mists of Pandaria)
- Paladin's Divine Purpose (Mists of Pandaria)
- Priest's Divine Insight: Discipline (Mists of Pandaria)
- Priest's Divine Insight: Holy (Mists of Pandaria)
- Priest's Divine Insight: Shadow (Mists of Pandaria)
- Priest's Surge of Light (Mists of Pandaria)
- Priest's Surge of Darkness (Mists of Pandaria)

New Glowing Buttons
- Paladin's Divine Storm, at 3 charges of Holy Power (Mists of Pandaria)
- Paladin's Eternal Flame, at 3 charges of Holy Power (Mists of Pandaria)
- Paladin's Inquisition, at 3 charges of Holy Power (Mists of Pandaria)
- Paladin's Light of Dawn, at 3 Holy Power (Mists of Pandaria)
- Paladin's Shield of the Righteous, at 3 Holy Power (Mists of Pandaria)
- Paladin's Templar's Verdict, at 3 Holy Power (Mists of Pandaria)
- Paladin's Word of Glory, at 3 Holy Power (Mists of Pandaria)
- Paladin's Divine Light, during Infusion of Light (Mists of Pandaria)
- Paladin's Holy Light, during Infusion of Light (Mists of Pandaria)
- Paladin's Holy Radiance, during Infusion of Light (Mists of Pandaria)
- Paladin's Holy Shock, during Daybreak (Mists of Pandaria)
- Paladin's Avenger's Shield, during Grand Crusader (Mists of Pandaria)
- Paladin's Divine Storm, during Divine Purpose (Mists of Pandaria)
- Paladin's Eternal Flame, during Divine Purpose (Mists of Pandaria)
- Paladin's Inquisition, during Divine Purpose (Mists of Pandaria)
- Paladin's Light of Dawn, during Divine Purpose (Mists of Pandaria)
- Paladin's Shield of the Righteous, during Divine Purpose (Mists of Pandaria)
- Paladin's Templar's Verdict, during Divine Purpose (Mists of Pandaria)
- Paladin's Word of Glory, during Divine Purpose (Mists of Pandaria)
- Paladin's Flash of Light, during Supplication (Mists of Pandaria)
- Priest's Greater Heal, at 2 stacks of Serendipity (Mists of Pandaria)
- Priest's Prayer of Healing, at 2 stacks of Serendipity (Mists of Pandaria)
- Priest's Flash Heal, during Surge of Light (Mists of Pandaria)
- Priest's Mind Spike, during Surge of Darkness (Mists of Pandaria)
- Priest's Mind Blast, during Glyph of Mind Spike (Mists of Pandaria)

Bug Fixes
- When glowing duplicate buttons, all buttons should now glow (Cataclysm)
- Buttons which switch instantly are now un-glowed when the effect is lost
- Buttons that stop glowing should no longer have a brief re-glow effect
- ElvUI users now benefit from ElvUI's Action Button Glow settings
- Mage's Pyroblast un-glows when cast during Hot Streak (Cataclysm)
- Priest's Flash Heal un-glows when cast during Surge of Light (Cataclysm)
- Priests should no longer have an error at start about Shadowform

#### v2.4.3 (2024-06-02)

Bug Fixes
- Buttons now un-glow as intended when effects end (Classic Era, Cataclysm)

#### v2.4.2 (2025-06-02)

Special thanks to Amanthuul once again for his work on the Shaman class. Kudos!

New Spell Alerts
- Shaman's Elemental Focus (Mists of Pandaria)
- Shaman's Fulmination, with 7 Lightning Shield stacks (Mists of Pandaria)
- Shaman's Lava Surge (Mists of Pandaria)
- Shaman's Maelstrom Weapon (Mists of Pandaria)
- Shaman's Tidal Waves (Mists of Pandaria)

New Glowing Buttons
- Death Knight's Death Strike, during Glyph of Dark Succor (Cataclysm)
- Shaman's Earth Shock, with 7 Lightning Shield stacks (Mists of Pandaria)
- Shaman's Elemental Blast, during Maelstrom Weapon (Mists of Pandaria)
- Shaman's Chain Heal, during Maelstrom Weapon (Mists of Pandaria)
- Shaman's Chain Lightning, during Maelstrom Weapon (Mists of Pandaria)
- Shaman's Greater Healing Wave, during Maelstrom Weapon (Mists of Pandaria)
- Shaman's Healing Rain, during Maelstrom Weapon (Mists of Pandaria)
- Shaman's Healing Surge, during Maelstrom Weapon (Mists of Pandaria)
- Shaman's Healing Wave, during Maelstrom Weapon (Mists of Pandaria)
- Shaman's Hex, during Maelstrom Weapon (Mists of Pandaria)
- Shaman's Lightning Bolt, during Maelstrom Weapon (Mists of Pandaria)
- Shaman's Greater Healing Wave, during Tidal Waves (Mists of Pandaria)
- Shaman's Healing Surge, during Tidal Waves (Mists of Pandaria)
- Shaman's Healing Wave, during Tidal Waves (Mists of Pandaria)

Bug Fixes
- Glowing Buttons no longer conflict with the game client's glow (MoP)
- Death Knight's Dark Tranformation now displays the overlay as intended (MoP)
- During Dark Succor, Death Strike button only glows in Frost/Unholy presence

#### v2.4.1 (2025-05-29)

Shout-out to Flow who designed Shaman's 6-10 Maelstrom Weapon textures. Thanks!

New Spell Alert
- Warrior's Regicide (Season of Discovery)

New Glowing Buttons
- Warrior's Execute, during Regicide (Season of Discovery)
- Warrior's Heroic Strike, during Incite (Cataclysm)

Introducting Mists of Pandaria flavor!
- The addon is still in very early stage
- Support for Death Knight's Crimson Scourge
- Support for Death Knight's Will of the Necropolis
- Support for Death Knight's Rime
- Support for Death Knight's Killing Machine
- Support for Death Knight's Dark Transformation
- Support for Death Knight's Sudden Doom
- Support for Death Knight's Glyph of Dark Succor
- Support for Mage's Freeze debuff
- Support for Paladin's Hammer of Wrath
- Support for Paladin's Exorcism
- Support for Paladin's Holy Shock
- Support for Priest's Shadowform
- Support for Warrior's Overpower
- Support for Warrior's Execute
- Support for Warrior's Revenge
- Support for Warrior's Victory Rush
- Support for Warrior's Glyph of Incite

Known Limitations
- Dark Transformation does not display an overlay, due to a game client issue
- Dark Succor will glow Death Strike in all presences, including Blood Presence
- Mage's Freeze debuff does not track Shaman's Freeze debuff, from Frozen Power

There were significant changes which, hopefully, should not break anything.
But in case it did break something, please to report issues. Thank you :)

#### v2.4.0 (2025-05-11)

Shout-out to fellow developers Skyward, Vanheden and Adal4. Thanks!
Special thanks to Amanthuul once again for his work on the Shaman class. Kudos!

Bump in TOC file for Scarlet Enclave update (Classic Era)
Bump in TOC file for Dragon Soul patch (Cataclysm)

New Spell Alert
- Druid's Swiftbloom (Scarlet Enclave 2pc, Season of Discovery)
- Hunter's Burning Adrenaline (Firelands 4pc, Cataclysm)
- Shaman's Maelstrom Weapon can stack up to 10 times (Season of Discovery)

New Glowing Buttons
- Druid's Nourish, during Fury of Stormrage (Season of Discovery)
- Druid's Healing Touch, during Swiftbloom (Season of Discovery)
- Druid's Nourish, during Swiftbloom (Season of Discovery)
- Druid's Regrowth, during Swiftbloom (Season of Discovery)
- Priest's Binding Heal, during Surge of Light (Season of Discovery)
- Shaman's Chain Heal, during Power Surge\* (Season of Discovery)

Removed Glowing Button
- Shaman's Chain Heal, during Power Surge\* (Season of Discovery)

\* Chain Heal has been moved from Power Surge DPS buff to Healer buff

Miscellaneous
- The 'Recently Updated' option note has been withdrawn from old updates

#### v2.3.4 (2025-12-06)

Bump in TOC file for Anniversary update (Classic Era)
Bump in TOC file for Firelands patch (Cataclysm)

Bug Fixes:
- Restored size of "Toggle Test" button in options panel
- Loading both SpellActivationOverlay and Necrosis could cause a Lua error
- Prevent taint from (unofficial) Cataclysm release of v2.3.3

#### v2.3.3 (2024-09-28)

Bump in TOC file for Season of Discovery update (Classic Era)

Bug Fixes
- The options panel was broken since last patch (Classic Era)
- Toggle Test used wrong orientation for top texture (Classic Era)

#### v2.3.2 (2024-09-15)

New Spell Alert
- Hunter's Mongoose Bite (Era, TBC)

Updated Glowing Button
- Shaman's Molten Blast no longer glows infinitely after leaving combat (SoD)

Removed Effect
- Priest's Mind Spike has been removed temporarily until it is resolved (SoD)

Bug Fixes
- The options panel has been fixed for Firelands' PTR (Cataclysm)

#### v2.3.1 (2024-08-04)

New runes for Season of Discovery:
- New SAO: Rogues's Cutthroat
- New SAO: Warlock's Decimation
- New SAO: Warrior's Sudden Death
- New GAB: Rogues's Ambush, during Cutthroat
- New GAB: Warlock's Drain Soul, with Soul Siphon rune
- New GAB: Warlock's Soul Fire, during Decimation
- New GAB: Warrior's Execute, during Sudden Death

Updated runes for Season of Discovery:
- Mage's Hot Streak triggers from Balefire Bolt
- Mage's Hot Streak triggers from Overheat's Fire Blast
- Warlock's Shadow Cleave glows during Shadow Trance (a.k.a. Nightfall)

Bug Fixes
- Mage's Hot Streak was not detected correctly since last patch of Classic Era

#### v2.3.0 (2024-07-17)

Bump in TOC file for Season of Discovery update (Classic Era)

Mage
- Mage's Impact effect is hidden when Fire Blast misses (Wrath, Cataclysm)

Shaman
- Shaman's Molten Blast option was displayed twice (Season of Discovery)
- Shaman's Maelstrom Weapon no longer empowers Chain Heal (SoD)
- Shaman's Maelstrom Weapon no longer empowers Healing Wave (SoD)

Bug Fixes
- Lua errors caused by action buttons should no longer happen
- This should fix the infinite action bar switch on Malygos, Nefarian, etc.

#### v2.2.0 (2024-06-17)

Necrosis
- Recently, Necrosis has started to include SpellActivationOverlay
- There were issues when both SpellActivationOverlay and Necrosis are installed
- Players who have not installed Necrosis were unaffected
- Players who log in with a class other than Warlock were unaffected
- Please update both SpellActivationOverlay and Necrosis to fix these issues

Options Panel
- A special mode "Disabled" has been introduced, blocking the options panel
- On top of blocking the options panel, effects can no longer trigger
- Players can opt in to disable SpellActivationOverlay when Necrosis is loaded
- This option is available only for Warlocks who have installed Necrosis

Bug Fixes
- Lua errors caused by 'OverrideActionBarButton' should no longer happen
- Lua errors caused by other action buttons should happen less often

#### v2.1.1 (2024-06-10)

New Spell Alert:
- Death Knight's Dark Transformation (Cataclysm)

New Glowing Button:
- Death Knight's Dark Transformation (Cataclysm)

Bug Fixes
- Effects based on Holy Power can no longer trigger before level 9 (Cataclysm)
- Mage's Arcane Missiles timer should now refresh correctly (Cataclysm)

The Arcane Missiles issue is most likely a bug from the game client
Until Blizzard fixes it, the addon exceptionally implements a local fix

#### v2.1.0 (2024-06-03)

Options Panel
- A new option "responsive mode" is available in the options panel
- In some cases, it detects procs slightly sooner
- In most situations, it makes no difference
- The option is disabled by default to favor performance

Updated effects:
- Death Knight's Bone Shield is now combat-only (Cataclysm)
- Druid's Eclipses are now combat-only (Season of Discovery, Wrath, Cataclysm)
- Paladin's Infusion of Light texture matches the reference client (Cataclysm)
- Updated texture and size of Paladin's Charges of Holy Power (Cataclysm)
- Paladin's Charges of Holy Power is no longer combat-only (Cataclysm)
- Paladin's Daybreak is displayed only when Holy Shock is usable (Cataclysm)\*

\* Exceptionally, this does not match the reference client, on purpose

It felt weird to see Daybreak proc, try to cast Holy Shock but fail, due to CD

New Spell Alert:
- Warlock's Fel Spark, from tier 11 set bonus (Cataclysm)

New Glowing Buttons:
- Judgement when Judgements of the Pure buff is missing (Wrath, Cataclysm)
- Priest's Inner Fire, when the buff is missing (Wrath, Cataclysm)\*\*
- Priest's Shadowform, when not assuming the shadowform
- Priest's Shadow Word: Death, when the enemy has low hp (Cataclysm)
- Rogue's Backstab, with Murderous Intent when the enemy has low hp (Cataclysm)
- Warlock's Fel Flame, during Fel Spark, from tier 11 set bonus (Cataclysm)
- Warlock's Shadowburn, when the spell is usable (Cataclysm)\*\*\*

\*\* Inner Fire existed before, but has become very important only since Wrath

\*\*\* Shadowburn existed before, but costs no soul shards only since Cataclysm

Bug Fixes
- Effects gained or lost during a loading screen are correctly updated
- Soul Preserver overlays are now slightly dimmer (Wrath)
- Mage's Clearcasting overlay is now slightly dimmer
- Mage's Finger of Frost overlay is now slightly dimmer (Cataclysm)
- Mage's Missile Barrage overlay is now blue-ish (Season of Discovery)
- Priest's Mind Spike overlay is now purple-ish (Season of Discovery)

Known Issues
- Druid's Eclipse buttons do not stop glowing after leaving combat (Cataclysm)
- This issue was already there and has not been introduced with this release

#### v2.0.0 (2024-05-27)

This release marks a major overhaul of the effect system

New effects:
- New SAO: Paladin's charges of Holy Power (Cataclysm)
- New GAB: Death Knight's Bone Shield, when the buff is missing (Cataclysm)
- New GAB: Paladin's Inquisition, at 3 charges of Holy Power (Cataclysm)
- New GAB: Paladin's Light of Dawn, at 3 Holy Power (Cataclysm)
- New GAB: Paladin's Templar's Verdict, at 3 Holy Power (Cataclysm)
- New GAB: Paladin's Shield of the Righteous, at 3 Holy Power (Cataclysm)
- New GAB: Paladin's Word of Glory, at 3 Holy Power (Cataclysm)

Bug Fixes
- Buffs should now be detected a bit more efficiently (Season of Discovery)
- Checking a checkbox in options panel refreshes their effects immediately

Known Issues
- Rare effects still do not refresh immediately after changing their option

#### v1.4.4 (2024-05-20)

Shout-out to fellow developer stako. Thanks!

Bug Fixes
- Hunter's Master Marksman should now trigger correctly (Cataclysm)
- Mage's Heating Up during Hot Streak has been reinstated (Cataclysm)

#### v1.4.3 (2024-05-12)

New Glowing Buttons:
- New GAB: Priest's Mind Blast, with 2 stacks of Mind Melt (Cataclysm)
- New GAB: Hunter's Kill Command, during Killing Streak (Cataclysm)
- New GAB: Warrior's Cleave, during Battle Trance (Cataclysm)
- New GAB: Warrior's Heroic Strike, during Battle Trance (Cataclysm)

Bug Fixes
- Spell Alerts should no longer display a visual timer shorter than intended
- Combat-only Spell Alerts should no longer flicker when entering combat
- Glowing button settings are more visible when there are more than 12 buttons
- Mage's Frozen debuff had incorrect texture orientation (Cataclysm)
- Mage's Improved Cone of Cold did not trigger Frozen debuff (Cataclysm)
- Mage's Ring of Frost did not trigger Frozen debuff (Cataclysm)
- Mage's Arcane Potency at 1 stack did not fade out after combat (Cataclysm)
- Warlock's Backdraft was not triggered correctly (Cataclysm)

Known Issues
- Mage's Pyroblast! glow is not previewed when hovering the mouse in options
- Priest's Flash Heal glow is not previewed when hovering the mouse in options

#### v1.4.2 (2024-05-10)

Bug Fixes
- Unnecessary information was written to the game chat

#### v1.4.1 (2024-05-09)

New effects:
- New SAO: Paladin's Daybreak (Cataclysm)
- New SAO: Paladin's Divine Purpose (Cataclysm)
- New SAO: Paladin's Grand Crusader (Cataclysm)
- New GAB: Paladin's Inquisition, during Divine Purpose (Cataclysm)
- New GAB: Paladin's Templar's Verdict, during Divine Purpose (Cataclysm)
- New GAB: Paladin's Word of Glory, during Divine Purpose (Cataclysm)
- New GAB: Paladin's Zealotry, during Divine Purpose (Cataclysm)
- New GAB: Paladin's Holy Light, during Crusade (Cataclysm)
- New GAB: Paladin's Holy Shock, during Daybreak (Cataclysm)
- New GAB: Paladin's Avenger's Shield, during Grand Crusader (Cataclysm)

Bug Fixes
- Some effects triggered immediately upon login would not glow their buttons

Glowing Buttons would only glow rank 1 of the following spells and abilities:
- Death Knight's Frost Strike (Wrath)
- Death Knight's Howling Blast (Wrath)
- Death Knight's Icy Touch (Wrath)
- Druid's Cyclone (Wrath)
- Druid's Entangling Roots (Wrath)
- Druid's Healing Touch (Season of Discovery, Wrath)
- Druid's Hibernate (Wrath)
- Druid's Nourish (Wrath)
- Druid's Rebirth (Wrath)
- Druid's Regrowth (Wrath)
- Druid's Starfire (Wrath)
- Druid's Wrath (Wrath)
- Hunter's Aimed Shot (Wrath)
- Hunter's Arcane Shot (Wrath)
- Hunter's Counterattack (Era, TBC, Wrath)
- Hunter's Explosive Shot (Wrath)
- Hunter's Kill Shot (Wrath)
- Hunter's Mongoose Bite (Era, TBC)
- Shaman's Chain Heal (Season of Discovery, Wrath)
- Shaman's Chain Lightning (Season of Discovery, Wrath)
- Shaman's Lesser Healing Wave (Season of Discovery, Wrath)
- Shaman's Lightning Bolt (Season of Discovery, Wrath)
- Shaman's Healing Wave (Season of Discovery, Wrath)
- Warlock's Incinerate (TBC, Wrath)
- Warlock's Shadow Bolt (Era, TBC, Wrath)
- Warlock's Soul Fire (Wrath)

#### v1.4.0 (2024-05-06)

Shout-out to fellow developers Amanthuul and espionn. Thanks!

New effects:
- New SAO: Druid's Fury of Stormrage (Cataclysm)
- New SAO: Hunter's Master Marksman (Cataclysm)
- New SAO: Priest's Serendipity (Cataclysm)
- New SAO: Shaman's Fulmination, with 6-9 Lightning Shield stacks (Cataclysm)
- New SAO: Shaman's Maelstrom Weapon (Cataclysm)
- New SAO: Shaman's Tidal Waves (Cataclysm)
- New SAO: Warrior's Bladestorm (Wrath, Cataclysm)
- New GAB: Druid's Starfire, during Fury of Stormrage (Cataclysm)
- New GAB: Hunter's Aimed Shot!, during Master Marksman (Cataclysm)
- New GAB: Warlock's Drain Soul, when the enemy has low HP (Cataclysm)
- New GAB: Priest's Greater Heal, during Serendipity (Cataclysm)
- New GAB: Priest's Prayer of Healing, during Serendipity (Cataclysm)
- New GAB: Shaman's Lava Burst, with Lava Surge talent (Cataclysm)
- New GAB: Shaman's Earth Shock, with 6-9 Lightning Shield stacks (Cataclysm)
- New GAB: Shaman's Chain Heal, during Maelstrom Weapon (Cataclysm)
- New GAB: Shaman's Chain Lightning, during Maelstrom Weapon (Cataclysm)
- New GAB: Shaman's Greater Healing Wave, during Maelstrom Weapon (Cataclysm)
- New GAB: Shaman's Healing Rain, during Maelstrom Weapon (Cataclysm)
- New GAB: Shaman's Healing Surge, during Maelstrom Weapon (Cataclysm)
- New GAB: Shaman's Healing Wave, during Maelstrom Weapon (Cataclysm)
- New GAB: Shaman's Hex, during Maelstrom Weapon (Cataclysm)
- New GAB: Shaman's Lightning Bolt, during Maelstrom Weapon (Cataclysm)
- New GAB: Shaman's Healing Surge, during Tidal Waves (Cataclysm)
- New GAB: Shaman's Healing Wave, during Tidal Waves (Cataclysm)
- New GAB: Shaman's Greater Healing Wave, during Tidal Waves (Cataclysm)
- New GAB: Warlock's Chaos Bolt, during Backdraft (Cataclysm)
- New GAB: Warlock's Incinerate, during Backdraft (Cataclysm)
- New GAB: Warlock's Shadow Bolt, during Backdraft (Cataclysm)
- New GAB: Warlock's Soul Fire, during Empowered Imp (Cataclysm)

Updated Effects:
- Shaman's Elemental Focus spell alert uses a more discreet texture (Cataclysm)

Removed effects:
- Death Knight's Rune Strike no longer glows (Cataclysm)
- Druid's Nature's Grace has been removed (Cataclysm)
- Hunter's Arcane Shot no longer glows during Lock and Load (Cataclysm)
- Hunter's Improved Steady Shot has been removed (Cataclysm)
- Rogue's Riposte has been removed (Cataclysm)
- Warlock's Soul Fire no longer glows during Molten Core (Cataclysm)

Sounds are no longer played for minor alerts, including:
- Mage's Clearcasting
- Mage's Frozen debuff
- Mage's Heating Up (Season of Discovery, Wrath, Cataclysm)
- Mage's Arcane Blast at 1-3 stacks (Season of Discovery)
- Paladin's The Art of War with only 1 talent point (Wrath)
- Priest's Serendipity at 1-2 stacks (Season of Discovery, TBC, Wrath)
- Priest's Mind Spike at 1-2 stacks (Season of Discovery)
- Shaman's Elemental Focus
- Shaman's Maelstrom Weapon at 1-4 stacks (Season of Discovery, Wrath)
- Shaman's Rolling Thunder at 7-9 Lightning Shield stacks (Season of Discovery)

UI Improvements
- Classes with no Spell Alerts now have a "None" text in their options panel
- Classes with no Glowing Buttons now have a "None" text in their options panel

Bug Fixes
- Spell Alerts could sometimes not pulse when previewing in the options panel
- Spell Alert during Toggle Test had incorrect texture orientation (Cataclysm)
- Mage's Fringers of Frost had incorrect texture orientation (Cataclysm)
- Mage's Frozen debuff had incorrect texture orientation (Cataclysm)
- Mage's Brain Freeze had incorrect texture orientation (Cataclysm)
- Mage's Pyroblast! is no longer counted for triggering Heating Up (Cataclysm)
- Warlock's Drain Soul spec names in options displayed numbers (Cataclysm)

Known issues
- Some classes have too many options to fit in the options panel
- Spell Alerts with distinct stack effects may display a short visual timer
- Bladestorm textures may flip horizontally after changing race or body type

#### v1.3.2 (2024-04-30)

The Death Knight class experiments the upcoming rework for Cataclysm.

Make sure to report issues you would encounter, thank you :)

New effects:
- New SAO: Death Knight's Crimson Scourge (Cataclysm)
- New SAO: Death Knight's Sudden Doom (Cataclysm)
- New SAO: Death Knight's Will of the Necropolis (Cataclysm)
- New SAO: Druid's Lunar and Solar Eclipse (Cataclysm)
- New SAO: Druid's Shooting Stars (Cataclysm)
- New SAO: Hunter's Lock and Load (Season of Discovery)
- New SAO: Warrior's Bloodsurge (Cataclysm)
- New SAO: Warrior's Sudden Death (Cataclysm)
- New SAO: Warrior's Sword and Board (Cataclysm)
- New SAO: Warrior's Sword and Board (Season of Discovery)
- New GAB: Death Knight's Blood Boil, during Crimson Scourge (Cataclysm)
- New GAB: Death Knight's Death Coil, during Sudden Doom (Cataclysm)
- New GAB: Death Knight's Icy Touch, during Rime (Cataclysm)
- New GAB: Death Knight's Obliterate, during Killing Machine (Cataclysm)
- New GAB: Death Knight's Rune Tap, during Will of the Necropolis (Cataclysm)
- New GAB: Druid's Starfire, during Lunar Eclipse (Cataclysm)
- New GAB: Druid's Wrath, during Solar Eclipse (Cataclysm)
- New GAB: Druid's Starsurge, during Shooting Stars (Cataclysm)
- New GAB: Paladin's Holy Shock, as combat-only counter
- New GAB: Paladin's Flash of Light, during Infusion of Light (Cataclysm)
- New GAB: Paladin's Holy Light, during Infusion of Light (Cataclysm)
- New GAB: Paladin's Divine Light, during Infusion of Light (Cataclysm)
- New GAB: Paladin's Holy Radiance, during Infusion of Light (Cataclysm)
- New GAB: Paladin's Exorcism, during The Art of War (Cataclysm)
- New GAB: Warrior's Slam, during Bloodsurge (Cataclysm)
- New GAB: Warrior's Colossus Smash, during Sudden Death (Cataclysm)
- New GAB: Warrior's Shield Slam, during Sword and Board (Cataclysm)
- New GAB: Warrior's Shield Slam, during Sword and Board (Season of Discovery)
- New GAB: Warrior's Overpower, during Taste for Blood\* (Season of Discovery)

\* As in Wrath, there is no dedicated Taste for Blood option

Taste for Blood shares its option with Overpower

Updated effects:
- Druid's Nature's Grace now has a fixed texture
- Druid's Nature's Grace texture has been scaled to 70% (down from 100%)

Removed effects:
- Druid's Wrath of Elune has been removed (Cataclysm)
- Druid's Elune Wrath has been removed (Cataclysm)

Bug fixes
- Death Knight's Killing Machine (Cataclysm) no longer glows Icy Touch
- Death Knight's Killing Machine (Cataclysm) no longer glows Howling Blast
- Druid's Lunar or Solar Eclipse spell alert is displayed upon login if needed
- Hungering Cold is now tagged as Frozen debuff for Mages
- Warrior's Blood Surge (Season of Discovery) did not trigger correctly
- Warrior's Bloodsurge (Wrath) did not preview from the options panel
- Warrior's Sudden Death (Wrath) did not preview from the options panel

#### v1.3.1 (2024-04-22)

Shout-out to fellow developers Amanthuul and steijner. Thanks!

Options:
- New option to play a sound effect when triggering a spell alert
- The option is enabled by default for Cataclysm, which had this sound
- The option is disabled by default for Classic Era and Wrath
- It would be confusing to add sounds overnight to Era and Wrath players
- To enable or disable it, please open the options panel by entering /sao

New effect for Wrath Classic:
- New GAB: Paladin's Divine Storm, as combat-only counter

New effects for Season of Discovery:
- New SAO: Shaman's Rolling Thunder with 7-9 Lightning Shield stacks
- New SAO: Shaman's Tidal Waves
- New SAO: Priest's Mind Spike
- New GAB: Mage's Deep Freeze, during Fingers of Frost
- New GAB: Mage's Deep Freeze, when the target is Frozen
- New GAB: Paladin's Divine Storm, as combat-only counter
- New GAB: Priest's Mind Blast, during Mind Spike at 3 stacks
- New GAB: Shaman's Earth Shock, with 7-9 Lightning Shield stacks
- New GAB: Shaman's Healing Wave, during Tidal Waves
- New GAB: Shaman's Lesser Healing Wave, during Tidal Waves

Introducing Cataclysm flavor!
- The addon is in very early stage, currently in alpha
- Support for Mage's Arcane Missiles
- Support for Mage's Arcane Potency
- Support for Mage's Brain Freeze
- Support for Mage's Clearcasting
- Support for Mage's Deep Freeze
- Support for Mage's Fingers of Frost
- Support for Mage's Frozen debuff
- Support for Mage's Heating Up and Hot Streak
- Support for Mage's Impact

Bug Fixes
- Spell Alerts of counters are instantly hidden when the counter is un-learned

#### v1.3.0 (2024-04-17)

Bump in TOC file for Season of Discovery update (Classic Era)

- New GAB: Paladin's Exorcism
- New SAO: Priest's Surge of Light (Season of Discovery)
- New GAB: Priest's Flash Heal button glows during Surge of Light (SoD)
- New GAB: Priest's Smite button glows during Surge of Light (SoD)

Combat-only counters:
- Hunter's Flanking Strike now fades out after leaving combat
- Mage's Heating Up now fades out after leaving combat
- Paladin's Exorcism fades out after leaving combat
- Shaman's Molten Blast now fades out after leaving combat

Bug Fixes
- Counters are no longer flagged as unavailable during GCD (Classic Era)
- Druid's Eclipse now refreshes its visual timer when gaining a stack

#### v1.2.0 (2024-03-19)

Bump in TOC file for Season of Discovery and Hardcore update (Classic Era)

Shout-out to fellow developers abecks, Amanthuul and AboveAzureSkies. Thanks!

Talent update:
- New SAO: Druid's Nature's Grace (Classic Era)

New runes for Season of Discovery:
- New SAO: Druid's Eclipse
- New GAB: Druid's Starfire button glows during Lunar Eclipse
- New GAB: Druid's Wrath button glows during Solar Eclipse
- New SAO: Mage's Hot Streak
- New GAB: Mage's Pyroblast button glows during Hot Streak
- New SAO: Mage's Missile Barrage, blue-ish tint to differ from Arcane Blast
- New GAB: Mage's Arcane Missiles button glows during Missile Barrage
- New SAO: Mage's Brain Freeze
- New GAB: Mage's Fireball button glows during Brain Freeze
- New GAB: Mage's Spellfrost Bolt button glows during Brain Freeze
- New GAB: Mage's Frostfire Bolt button glows during Brain Freeze
- New SAO: Shaman's Maelstrom Weapon
- New GAB: Shaman's Lightning Bolt glows during Maelstrom Weapon
- New GAB: Shaman's Chain Lightning glows during Maelstrom Weapon
- New GAB: Shaman's Lesser Healing Wave glows during Maelstrom Weapon
- New GAB: Shaman's Healing Wave glows during Maelstrom Weapon
- New GAB: Shaman's Chain Heal glows during Maelstrom Weapon
- New GAB: Shaman's Lava Burst glows during Maelstrom Weapon
- New SAO: Shaman's Power Surge
- New GAB: Shaman's Chain Lightning glows during Power Surge
- New GAB: Shaman's Chain Heal glows during Power Surge
- New GAB: Shaman's Lava Burst glows during Power Surge
- New SAO: Warrior's Bloodsurge
- New GAB: Warrior's Slam glows during Bloodsurge

#### v1.1.4 (2024-01-23)

- Rune list is refreshed explicitly, so that detection no longer fails
- Runes are checked every 10 secs until one is found, to detect them sooner

#### v1.1.3 (2023-12-13)

Effects based on stackable auras could sometimes not be triggered correctly:
- Hunter's Cobra Strikes (Season of Discovery)
- Hunter's Lock and Load (Wrath Classic)
- Mage's Arcane Blast (Season of Discovery)
- Mage's Fingers of Frost (Wrath Classic, Season of Discovery)
- Priest's Serendipity (Wrath Classic, Season of Discovery)
- Shaman's Maelstrom Weapon (Wrath Classic)
- Shaman's Tidal Waves (Wrath Classic)
- Warlock's Molten Core (Wrath Classic)
- Warrior's Bloodsurge (Wrath Classic)
- Warrior's Sudden Death (Wrath Classic)

#### v1.1.2 (2023-12-12)

- Seasonal effects are no longer displayed as options in non-Seasonal realms
- Updated SAO: Rogue's Riposte can now trigger independently of cooldown
- Updated GAB: Rogue's Riposte can now trigger independently of cooldown
- Rogue's new options are independent; make sure to enable both, if needed
- Rogue new options are disabled by default, similar to Warrior stance options
- Mage's Arcane Blast should now trigger correctly (Season of Discovery only)
- Season of Discovery action counters should now glow correctly

The action counter fix includes the following spells and abilities:
- Hunter's Flanking Strike
- Shaman's Molten Blast
- Warrior's Raging Blow
- Warrior's Victory Rush (fixed for Season of Discovery only, Wrath was fine)

#### v1.1.1 (2023-12-05)

- New SAO: Mage's Arcane Blast
- New GAB: Mage's Arcane Missiles, during Arcane Blast
- New GAB: Mage's Arcane Explosion, during Arcane Blast
- Updated SAO: Mage's Clearcasting is back to 150% size, to avoid overlap
- Hunter's Flanking Strike Spell Alert is no longer always displayed upon login
- Shaman's Molten Blast Spell Alert is no longer always displayed upon login

#### v1.1.0-beta (2023-12-01)

This release focuses on supporting runes introduced in Season of Discovery
- New SAO: Druid's Fury of Stormrage
- New SAO: Hunter's Flanking Strike
- New SAO: Hunter's Cobra Strikes
- New SAO: Mage's Fingers of Frost
- New SAO: Priest's Serendipity
- New SAO: Shaman's Molten Blast
- New SAO: Warrior's Raging Blow
- New GAB: Druid's Healing Touch, during Fury of Stormrage
- New GAB: Hunter's Flanking Strike, when the action is usable
- New GAB: Mage's Ice Lance, during Fingers of Frost
- New GAB: Mage's Ice Lance, when the enemy target is Frozen
- New GAB: Priest's Lesser Heal, during Serendipity
- New GAB: Priest's Heal, during Serendipity
- New GAB: Priest's Greater Heal, during Serendipity
- New GAB: Priest's Prayer of Healing, during Serendipity
- New GAB: Shaman's Molten Blast, when the action is usable
- New GAB: Warrior's Raging Blow, when the action is usable
- New GAB: Warrior's Victory Rush, when the action is usable

Bug Fixes
- In rare circumstances, glowing buttons would never glow
- Reloading the UI would always fix the issue, until next log out

#### v1.0.0 (2023-12-01)

Spell Alerts have a shrinking effect to know when the alert is about to fade
- This effect is enabled by default; enter /sao to enable or disable it
- Feel free to report spell alerts that should have but do not have this effect
- Please note, some effects never fade on purpose, such as Mage's Heating Up

Bug Fixes
- Mage's Deep Freeze debuff now counts as a Frozen effect (Wrath Classic only)
- Mage's Heating Up lingered after 4 critical strikes without casting Pyroblast

This release bumps TOC file for Season of Discovery patch (Classic Era)
- Runes of Season of Discovery will be supported over time
- To support them, we need technical information not always available day 1
- Make sure to head over GitHub or Discord to help us, thank you :)

#### v0.9.5 (2023-11-07)

- Buttons should glow correctly when using AzeriteUI
- New SAOs: Healing Trance / Soul Preserver, for all healing classes
- New GAB: Hunter's Mongoose Bite (Classic Era only)
- Warriors can hold 2 charges of Sudden Death thanks to tier 10 set bonus
- Warriors can hold 2 charges of Bloodsurge thanks to tier 10 set bonus

#### v0.9.4 (2023-11-01)

- Bump in TOC file for Icecrown Citadel patch (Wrath Classic)
- New SAO: Mage's Frozen when the target is under a Frozen effect
- New GAB: Mage's Ice Lance button glows during Fingers of Frost
- New GAB: Mage's Deep Freeze button glows during Fingers of Frost
- New GAB: Mage's Ice Lance button glows when the target is Frozen
- New GAB: Mage's Deep Freeze button glows when the target is Frozen

List of spells that trigger the Frozen effect:
- Mage's Frost Nova
- Mage's Frostbite (Frost talent)
- Mage's Shattered Barrier (Frost talent, Wrath Classic only)
- Mage's Frost Elemental's Freeze spell (Wrath Classic only)
- Hunter's Freezing Trap

#### v0.9.3 (2023-09-02)

- Bump in TOC file for Classic Hardcore patch (Classic Era)
- Druid's Omen of Clarity was no longer working since Classic Era last patch
- Warrior's Overpower button could glow for too long after the target dodged
- Warrior's Overpower button glows during Taste for Blood
- The 'baseline' Overpower can only be cast on the target who dodged
- Taste for Blood, on the other hand, allows to cast Overpower on any target
- Taste for Blood is available on Wrath Classic only

The bug that happened to druids may also happen to other classes

Please report bugs to the addon's Discord, GitHub or CurseForge

#### v0.9.2 (2023-06-21)

- Bump in TOC file for Trial of the Grand Crusader patch (Wrath Classic)
- The options window is compatible with the new settings UI

#### v0.9.1 (2023-05-28)

- Mage's Clearcasting is now enabled by default on Classic Era
- Mage's Clearcasting has been scaled to 100% (down from 150%) on Classic Era
- New GAB: Warlock's Drain Soul when the enemy has low HP
- The Drain Soul option is available for Wrath Classic only
- Warrior's Overpower has an option to be detected in any stance
- Warrior's Revenge has an option to be detected in any stance
- Warrior's Execute has an option to be detected in any stance

Please enter /sao to enable or disable these options

#### v0.9.0 (2023-05-01)

- Support for Classic Era, although many WotLK spells and talents are missing
- Mage's Heating Up effect is now hidden when the talent is lost e.g., respec
- Fixed an issue where paladin and warrior buttons would sometimes not glow
- The addon should now use a bit less CPU than before

#### v0.8.4 (2023-04-28)

- New SAO: Druid's Wrath of Elune (4p set bonus of PvP season 5-6-7-8)
- New SAO: Druid's Elune's Wrath (4p set bonus of tier 8)
- New SAO: Mage's Heating Up and Hot Streak at the same time
- New GAB: Druid's Starfire button glows during Wrath of Elune
- New GAB: Druid's Starfire button glows during Elune's Wrath

Enter /sao to enable or disable these options

#### v0.8.3 (2023-01-29)

- Glowing buttons work again with ProjectAzilroka, after Ulduar patch
- Mage's Heating Up works again with ProjectAzilroka, after Ulduar patch
- Other features may also work back to normal for ProjectAzilroka users
- These fixes also apply to addons embedding an outdated LibButtonGlow
- If there is no fallback solution, glowing buttons are temporarily disabled

#### v0.8.2 (2023-01-18)

- Bump in TOC file for Ulduar patch

#### v0.8.1 (2022-11-13)

- The default glowing button library is now LibButtonGlow for ElvUI 13

#### v0.8.0 (2022-11-08)

- SAOs and GABs can be previewed by moving the cursor over their options
- SAOs may have variants when e.g. there is no obvious texture to use
- New SAO: Druid's Nature's Grace, optional
- New SAO: Mage's Arcane Concentration (a.k.a. Clearcasting), optional
- New SAO: Shaman's Tidal Waves, optional
- New GAB: Shaman's Lesser Healing Wave button may glow during Tidal Waves
- New GAB: Shaman's Healing Wave button may glow during Tidal Waves

#### v0.7.0 (2022-10-09)

- Spell Alerts may now be enabled or disabled individually
- Glowing buttons may now be enabled or disabled individually
- Options panel is opened by entering /sao or /spellactivationoverlay

#### v0.6.5 (2022-10-05)

- Entering a vehicle should no longer cause a Lua error
- Spending 1 point out of 2 in Art of War now has a SAO and GABs

#### v0.6.4 (2022-09-29)

- Spell Alerts fade out after being out of combat for 30 seconds
- Spell Alerts triggering out-of-combat are not dimmed for 5 seconds
- SAOs and GABs should disappear if their triggers fade during a loading screen
- Lua errors of 'ipairs' should no longer occur after a loading screen
- Pulse animations should no longer start earlier thn expected

#### v0.6.3 (2022-09-20)

- New SAO: Warlock's Decimation
- New GAB: Warlock's Soul Fire button glows during Decimation
- Changed SAO: Warlock's Molten Core SAO no longer displays the 3rd charge
- Rogue's Riposte SAO should no longer trigger without the talent

#### v0.6.2 (2022-09-13)

Shout-out to MartGon once again for his contribution to the code. Thanks!

- Glowing buttons no longer "un-glow" during the Global Cooldown (GCD)
- Glowing buttons no longer "un-glow" due to the lack of rage, energy, or RP
- New SAO: Druid's Predatory Strikes, based on Predatory Swiftness from Retail
- New SAO: Mage's Firestarter, which uses texture of Impact
- New GAB: Mage's Flamestrike button glows during Firestarter
- Changed SAO: Mage's Impact uses texture of Lock and Load instead of Impact

#### v0.6.1 (2022-09-06)

Shout-out to MartGon and xHashii for their contribution to the code. Thanks!

- Buttons should glow correctly when using Bartender, ElvUI or Dominos
- New GAB: Hunter's Kill Shot button glows when the target has low HP
- New GAB: Paladin's Hammer of Wrath button glows when the target has low HP
- New GAB: Warrior's Execute button glows when the target has low HP
- New GAB: Warrior's Victory Rush button glows after killing an enemy
- Riposte should display its SAO as intended
- Reload UI should no longer cause a Lua error because of options
- Glowing Buttons checkbox should now apply the option correctly

#### v0.6.0 (2022-09-04)

- After extensive testing, SpellActivationOverlay now leaves its Beta phase!
- Options Panel, available from Interface > AddOns > SpellActivationOverlay
- Options for Spell Alerts: opacity, scale factor, offset
- Options for Glowing Buttons: on/off
- A "Toggle Test" button displays fake Spell Alerts for testing interactively

#### v0.5.0-beta (2022-08-31)

SpellActivationOverlay now has a Discord server!

Make sure to check it out at https://discord.gg/xJmGfGcd4M

Support for Glowing Action Buttons (GABs), making some actions glow, namely:
- Death Knight's Rune Strike button glows after parrying or dodging an attack
- Death Knight's Howling Blast button glows during Rime
- DK's Icy Touch/Frost Strike/Howling Blast buttons glow during Killing Machine
- Druid's Wrath button glows during Solar Eclipse
- Druid's Starfire button glows during Lunar Eclipse
- Hunter's Counterattack button glows after parrying an attack, unless on CD
- Hunter's Aimed/Arcane/Chimera Shot buttons glow during Improved Steady Shot
- Hunter's Arcane/Explosive Shot buttons glow during Lock and Load
- Mage's Arcane Missiles button glows during Missile Barrage
- Mage's Pyroblast button glows during Hot Streak
- Mage's Fire Blast button glows during Impact
- Mage's Fireball and Frostfire Bolt buttons glow during Brain Freeze
- Paladin's Flash of Light and Holy Light buttons glow during Infusion of Light
- Paladin's Flash of Light and Exorcism buttons glow during The Art of War
- Priest's Smite and Flash Heal buttons glow during Surge of Light
- Priest's Greater Heal and Prayer of Healing glow at 3 stacks of Serendipity
- Rogue's Riposte button glows after parrying an attack, unless on cooldown
- Warlock's Shadow Bolt button glows during Nightfall, a.k.a. Shadow Trance
- Warlock's Shadow Bolt and Incinerate buttons glow during Backlash
- Warlock's Incinerate and Soul Fire buttons glow during Molten Core
- Warrior's Overpower button glows after the enemy dodges, if in Battle Stance
- Warrior's Revenge button glows after parry/dodge/block in Defensive Stance
- Warrior's Execute button glows during Sudden Death
- Warrior's Slam button glows during Bloodsurge
- Warrior's Shield Slam button glows during Sword and Board

- New SAO: Rogue's Riposte
- SAOs should now always show up on ReloadUI

#### v0.4.2-beta (2022-08-05)

- Mage's Heating Up is no longer lost on death
- Alpha is reduced by 50% when out of combat
- SAOs are shown uplon login if player already has the corresponding buffs
- Currently, this includes all SAOs but Heating Up, which is not a buff

#### v0.4.1-beta (2022-08-05)

- New SAO: Paladin's Infusion of Light
- Textures should keep pulsing after gaining/losing stacks
- Mage's Heating Up does not pulse anymore
- Shamans's Maelstrom Weapon does not pulse at stacks 1-4

#### v0.4.0-beta (2022-07-31)

- Because all classes are supported, the addon now enters its Beta phase!
- New classes: Druid, Hunter, Rogue
- New SAO: Druid's Lunar Eclipse
- New SAO: Druid's Solar Eclipse
- New SAO: Druid's Omen of Clarity
- New SAO: Hunter's Improved Steady Shot
- New SAO: Hunter's Lock and Load
- New SAO: Mage's Impact
- New SAO: Shaman's Elemental Focus
- The Rogue class, although supported, currently doesn't have any SAO

#### v0.3.4-alpha (2022-07-31)

- New class: Warlock
- New SAO: Warlock's Backlash
- New SAO: Warlock's Empowered Imp
- New SAO: Warlock's Molten Core
- New SAO: Warlock's Nightfall, a.k.a. Shadow Trance

#### v0.3.3-alpha (2022-07-29)

- New classes: Shaman, Warrior
- New SAO: Priest's Serendipity
- New SAO: Shaman's Maelstrom Weapon
- New SAO: Warrior's Bloodsurge
- New SAO: Warrior's Sudden Death
- New SAO: Warrior's Sword and Board

#### v0.3.2-alpha (2022-07-27)

- New classes: Priest, Paladin
- New SAO: Priest's Surge of Light
- New SAO: Paladin's Art of War

#### v0.3.1-alpha (2022-07-26)

- New SAO: Mage's Missile Barrage
- New SAO: Mage's Brain Freeze

#### v0.3.0-alpha (2022-07-25)

- New SAO: Mage's Fingers of Frost
- Major changes to how stackable auras, such as Fingers of Frost, are handled
- Due to a game limitation, stackable auras rely a bit less on combat logs
- Talent checks could fail during login
- This addon no longer stores data to the game client local storage

#### v0.2.0-alpha (2022-07-24)

- Major changes to how custom code can be implemented, on a per-class basis
- Mage's Heating Up is now fully functional
- Mage's Heating Up now triggers only for mages who picked Hot Streak talent

#### v0.1.2-alpha (2022-07-24)

- New SAO: Mage's Heating Up, barely functional because Wrath has no such buff
- Factorized code in common.lua

#### v0.1.1-alpha (2022-07-24)

- New class: Mage
- New SAO: Mage's Hot Streak

#### v0.1.0-alpha (2020-07-24)

- SpellActivationOverlay is now public!
- Addon hosted on Curse https://www.curseforge.com/wow/addons/spellactivationoverlay
- Source code is available on GitHub https://github.com/ennvina/spellactivationoverlay
- This release mostly focuses on cleaning up some files before sharing them

#### v0.0.5-alpha (2022-07-24)

- Track combat event log instead of unit auras
- Support for stackable effects, although no stackable example is written yet

#### v0.0.4-alpha (2022-07-23)

- Utility functions are now centralized in common.lua
- First working Spell Activation Overlays (SAOs): DK's Rime and Killing Machine

#### v0.0.3-alpha (2022-07-23)

- Custom code for initializing new frame members
- Extra caution to ensure Blizzard original code changes as little as possible
- Utility functions to work around auras; defined in a separate source file

#### v0.0.2-alpha (2022-07-23)

- Re-use WeakAuras "Blizzard Alert" category for listing textures
- Map texture IDs to a local texture name in the addon folder

#### v0.0.1-alpha (2022-07-23)

- Re-use Blizzard code from Retail's FrameXML source code
- Re-use Rime and Killing Machine textures from Retail
- Ignore displaySpellActivationOverlays cvariable, unavailable in Classic
