---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local raceLocales = {
    ["Human"] = {
        ["enUS"] = true,
        ["deDE"] = "Mensch",
        ["esES"] = "Humano",
        ["esMX"] = "Humano",
        ["frFR"] = "Humain",
        ["koKR"] = "인간",
        ["ptBR"] = "Humano",
        ["ruRU"] = "Человек",
        ["zhCN"] = "人类",
        ["zhTW"] = "人類",
    },
    ["Orc"] = {
        ["enUS"] = true,
        ["deDE"] = "Ork",
        ["esES"] = "Orco",
        ["esMX"] = "Orco",
        ["frFR"] = true,
        ["koKR"] = "오크",
        ["ptBR"] = true,
        ["ruRU"] = "Орк",
        ["zhCN"] = "兽人",
        ["zhTW"] = "獸人",
    },
    ["Dwarf"] = {
        ["enUS"] = true,
        ["deDE"] = "Zwerg",
        ["esES"] = "Enano",
        ["esMX"] = "Enano",
        ["frFR"] = "Nain",
        ["koKR"] = "드워프",
        ["ptBR"] = "Anão",
        ["ruRU"] = "Дворф",
        ["zhCN"] = "矮人",
        ["zhTW"] = "矮人",
    },
    ["Nightelf"] = {
        ["enUS"] = true,
        ["deDE"] = "Nachtelf",
        ["esES"] = "Elfo de la Noche",
        ["esMX"] = "Elfo de la Noche",
        ["frFR"] = "Elfe de la nuit",
        ["koKR"] = "나이트 엘프",
        ["ptBR"] = "Elfo Noturno",
        ["ruRU"] = "Ночной эльф",
        ["zhCN"] = "暗夜精灵",
        ["zhTW"] = "夜精靈",
    },
    ["Undead"] = {
        ["enUS"] = true,
        ["deDE"] = "Untoter",
        ["esES"] = "No-Muerto",
        ["esMX"] = "No-Muerto",
        ["frFR"] = "Mort-viant",
        ["koKR"] = "언데드",
        ["ptBR"] = "Morto-vivo",
        ["ruRU"] = "Нежить",
        ["zhCN"] = "亡灵",
        ["zhTW"] = "不死族",
    },
    ["Tauren"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "타우렌",
        ["ptBR"] = true,
        ["ruRU"] = "Таурен",
        ["zhCN"] = "牛头人",
        ["zhTW"] = "牛頭人",
    },
    ["Gnome"] = {
        ["enUS"] = true,
        ["deDE"] = "Gnom",
        ["esES"] = "Gnomo",
        ["esMX"] = "Gnomo",
        ["frFR"] = true,
        ["koKR"] = "노움",
        ["ptBR"] = "Gnomo",
        ["ruRU"] = "Гном",
        ["zhCN"] = "侏儒",
        ["zhTW"] = "地精",
    },
    ["Troll"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Trol",
        ["esMX"] = "Trol",
        ["frFR"] = true,
        ["koKR"] = "트롤",
        ["ptBR"] = true,
        ["ruRU"] = "Тролль",
        ["zhCN"] = "巨魔",
        ["zhTW"] = "食人妖",
    },
    ["Goblin"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = "Gobelin",
        ["koKR"] = "고블린",
        ["ptBR"] = true,
        ["ruRU"] = "Гоблин",
        ["zhCN"] = "地精",
        ["zhTW"] = "哥布林",
    },
    ["Draenei"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = "Draeneï",
        ["koKR"] = "드레나이",
        ["ptBR"] = true,
        ["ruRU"] = "Дреней",
        ["zhCN"] = "德莱尼",
        ["zhTW"] = "德萊尼",
    },
    ["Blood Elf"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutelf",
        ["esES"] = "Elfo de sangre",
        ["esMX"] = "Elfo de Sangre",
        ["frFR"] = "Elfe de sang",
        ["koKR"] = "블러드 엘프",
        ["ptBR"] = "Elfo Sangrento",
        ["ruRU"] = "Эльф крови",
        ["zhCN"] = "血精灵",
        ["zhTW"] = "血精靈",
    },
    ["Worgen"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Huargen",
        ["esMX"] = "Huargen",
        ["frFR"] = true,
        ["koKR"] = "늑대인간",
        ["ptBR"] = true,
        ["ruRU"] = "Ворген",
        ["zhCN"] = "狼人",
        ["zhTW"] = "狼人",
    },
}

for k, v in pairs(raceLocales) do
    l10n.translations[k] = v
end
