---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local minimapOptionsLocales = {
    ["Minimap"] = {
        ["enUS"] = true,
        ["deDE"] = "Minimap",
        ["esES"] = "Minimapa",
        ["esMX"] = "Minimapa",
        ["frFR"] = "Minicarte",
        ["koKR"] = "미니맵",
        ["ptBR"] = "Minimapa",
        ["ruRU"] = "Миникарта",
        ["zhCN"] = "小地图",
        ["zhTW"] = "小地圖",
    },
    ["Minimap Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Minimap-Einstellungen",
        ["esES"] = "Opciones del minimapa",
        ["esMX"] = "Opciones del minimapa",
        ["frFR"] = "Options de la minicarte",
        ["koKR"] = "미니맵 설정",
        ["ptBR"] = "Opções do minimapa",
        ["ruRU"] = "Настройки миникарты",
        ["zhCN"] = "小地图选项",
        ["zhTW"] = "小地圖選項",
    },
    ["Minimap Icons Glow"] = {
        ["enUS"] = true,
        ["deDE"] = "Minimap-Icons immer leuchten lassen",
        ["esES"] = "Resplandecer iconos en el minimapa",
        ["esMX"] = "Resplandecer iconos en el minimapa",
        ["frFR"] = "Illuminer les icônes sur la minicarte",
        ["koKR"] = "미니맵 아이콘 반짝임 사용",
        ["ptBR"] = "Iluminar ícones no minimapa",
        ["ruRU"] = "Подсветка значков",
        ["zhCN"] = "总是使小地图标记高亮",
        ["zhTW"] = "小地圖圖示發光",
    },
    ["Draw a glow texture behind minimap icons, colored unique to each quest."] = {
        ["enUS"] = true,
        ["deDE"] = "Zeichnet eine leuchtende Textur hinter die Minimap-Icons. Farblich einzigartig für jede Quest.",
        ["esES"] = "Resplandece los iconos en el minimapa con colores únicos para cada misión.",
        ["esMX"] = "Resplandece los iconos en el minimapa con colores únicos para cada misión.",
        ["frFR"] = "Illumine les icônes sur la minicarte, colorié différemment pour chaque quête.",
        ["koKR"] = "미니맵 아이콘에 반짝이는 효과를 표시합니다. 퀘스트마다 각각 다른 색상을 지닙니다.",
        ["ptBR"] = "Ilumina os ícones mínimos no mapa, com cores exclusivas para cada missão.",
        ["ruRU"] = "Показать/скрыть цветной ореол вокруг значков на миникарте",
        ["zhCN"] = "替小地图标记显示一圈光晕，且不同任务有不同的颜色",
        ["zhTW"] = "在小地圖圖示的後面繪製發光材質，每個任務都可以有不同的顏色。",
    },
    ["Unique Minimap Icon Colors"] = {
        ["enUS"] = true,
        ["deDE"] = "Minimap-Icons für jede Quest unterschiedlich färben",
        ["esES"] = "Colores únicos de iconos del minimapa",
        ["esMX"] = "Colores únicos de iconos del minimapa",
        ["frFR"] = "Couleurs uniques des icônes de la minicarte",
        ["koKR"] = "고유 미니맵 아이콘 색상",
        ["ptBR"] = "Cores únicas de ícones do minimapa",
        ["ruRU"] = "Различные цвета значков",
        ["zhCN"] = "每个任务使用不同的颜色",
        ["zhTW"] = "每個任務使用不同的顏色",
    },
    ["Show minimap icons with colors that are randomly generated based on quest ID."] = {
        ["enUS"] = true,
        ["deDE"] = "Zeigt Minimap-Icons mit zufälligen Farben für jede Quest.",
        ["esES"] = "Muestra iconos del minimapa con colores que se generan aleatoriamente en función de la ID de la misión.",
        ["esMX"] = "Muestra iconos del minimapa con colores que se generan aleatoriamente en función de la ID de la misión.",
        ["frFR"] = "Affiche les icônes de la minicarte avec couleurs aléatoires en fonction de l'ID des quêtes.",
        ["koKR"] = "미니맵에서 각 퀘스트별로 각각 다른 아이콘 색상을 사용할지 설정합니다.",
        ["ptBR"] = "Mostra ícones do minimapa com cores geradas de maneira aleatoriamente com base na ID da missão.",
        ["ruRU"] = "Для каждого задания генерируется свой цвет значков на миникарте",
        ["zhCN"] = "在小地图上显示图标，图标颜色是根据任务 ID 随机生成的。",
        ["zhTW"] = "依據任務 ID 隨機產生不同的顏色來顯示小地圖圖示。",
    },
    ["Minimap Note Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Minimap-Notiz-Einstellungen",
        ["esES"] = "Opciones de las notas del minimapa",
        ["esMX"] = "Opciones de las notas del minimapa",
        ["frFR"] = "Options des icônes sur la minicarte",
        ["koKR"] = "미니맵 아이콘 설정",
        ["ptBR"] = "Opções de notas do minimapa",
        ["ruRU"] = "Настройки значков",
        ["zhCN"] = "小地图图标选项",
        ["zhTW"] = "小地圖圖示選項",
    },
    ["How large the minimap icons are.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Skaliert wie groß die Minimap-Icons sind.\n(Standard: %s)",
        ["esES"] = "Define la escala de los iconos en el minimapa.\n(Predeterminado: %s)",
        ["esMX"] = "Define la escala de los iconos en el minimapa.\n(Predeterminado: %s)",
        ["frFR"] = "Définis la taille des icônes sur la minicarte.\n(Par défaut : %s)",
        ["koKR"] = "미니맵 아이콘의 크기를 설정합니다.\n(기본값: %s)",
        ["ptBR"] = "Qual é o tamanho dos ícones do minimapa.\n(Padrão: %s)",
        ["ruRU"] = "Одновременная регулировка размера всех значков на миникарте\n(по умолчанию: %s)",
        ["zhCN"] = "调整小度图标记图标的缩放比例\n（预设：%s）",
        ["zhTW"] = "小地圖上圖示的大小。\n(預設值: %s)",
    },
    ["Fade Icons over Player"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons nahe des Spielers verblassen",
        ["esES"] = "Transparencia con respecto al jugador",
        ["esMX"] = "Transparencia con respecto al jugador",
        ["frFR"] = "Disparition à proximité du joueur",
        ["koKR"] = "플레이어 주변 아이콘 흐릿하게 표시",
        ["ptBR"] = "Transparência em relação ao jogador",
        ["ruRU"] = "Блеклость значков рядом с игроком",
        ["zhCN"] = "淡出与玩家重叠的标记",
        ["zhTW"] = "淡出和玩家重疊的圖示",
    },
    ["Minimap Icon Fade Distance"] = {
        ["enUS"] = true,
        ["deDE"] = "Distanz der verblassenden Ziele",
        ["esES"] = "Distancia de desvanecimiento de iconos del minimapa",
        ["esMX"] = "Distancia de desvanecimiento de iconos del minimapa",
        ["frFR"] = "Distance de disparition des icônes de la minicarte",
        ["koKR"] = "퀘스트 아이콘 사라짐 거리 설정",
        ["ptBR"] = "Distância de desvanecimento de ícones do minimapa",
        ["ruRU"] = "Дистанция блеклости",
        ["zhCN"] = "远离目标的淡出隐距离",
        ["zhTW"] = "依距離淡出任務目標",
    },
    ["How much objective icons should fade depending on distance.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Wie viele Ziele verblassen abhängig von der Distanz.\n(Standard: %s)",
        ["esES"] = "Cuanta transparencia tendrian que tener los iconos de objetivo con respecto a la distancia a ellos.\n(Predeterminado: %s)",
        ["esMX"] = "Cuanta transparencia tendrian que tener los iconos de objetivo con respecto a la distancia a ellos.\n(Predeterminado: %s)",
        ["frFR"] = "Définis la distance à partir de laquelle les icônes des objectifs commencent à apparaître.\n(Par défaut : %s)",
        ["koKR"] = "얼마나 많은 퀘스트 아이콘을 거리에 따라 사라지게할지 설정합니다.\n(기본값: %s)",
        ["ptBR"] = "Quantos ícones do objectivo devem desaparecer dependendo da distância.\n(Padrão: %s)",
        ["ruRU"] = "Дистанция, на которой отдаленные значки на миникарте будут блекнуть\n(по умолчанию: %s)",
        ["zhCN"] = "根据距离，任务目标图标应淡化的程度。（默认：%s）",
        ["zhTW"] = "根據距離，任務目標圖示應淡化的程度。（預設：%s）",
    },
    ["Fades icons on the minimap when your player walks near them."] = {
        ["enUS"] = true,
        ["deDE"] = "Lässt Icons auf der Minimap verblassen, wenn der Spieler ihnen zu nahe kommt.",
        ["esES"] = "Los iconos se desvanecen cuando el jugador se mueve cerca de ellos.",
        ["esMX"] = "Los iconos se desvanecen cuando el jugador se mueve cerca de ellos.",
        ["frFR"] = "Active la disparition des icônes sur la minicarte lorsque le joueur est à proximité.",
        ["koKR"] = "플레이어 주변의 퀘스트 아이콘을 흐릿하게 표시합니다.",
        ["ptBR"] = "Desvanece os ícones no minimapa quando o jogador passa por perto.",
        ["ruRU"] = "Значки на миникарте блекнут, если игрок находится рядом с ними",
        ["zhCN"] = "当你靠近一个目标或与之重叠时，使标记淡出，避免遮住小地图上的玩家自身标记。",
        ["zhTW"] = "當你靠近時淡出小地圖上的圖示。",
    },
    ["Fade over Player Distance"] = {
        ["enUS"] = true,
        ["deDE"] = "Distanz ehe Ziele verblassen",
        ["esES"] = "Distancia del jugador para desvanecer",
        ["esMX"] = "Distancia del jugador para desvanecer",
        ["frFR"] = "Distance avant réapparition",
        ["koKR"] = "흐릿하게 표시하는 거리 설정",
        ["ptBR"] = "Desvanecer-se sobre a distância do jogador",
        ["ruRU"] = "Дистанция блеклости",
        ["zhCN"] = "靠近目标的淡出距离",
        ["zhTW"] = "和玩家重疊的淡出距離",
    },
    ["Fade over Player Amount"] = {
        ["enUS"] = true,
        ["deDE"] = "Stärke des Verblassens",
        ["esES"] = "Transparencia sobre el jugador",
        ["esMX"] = "Transparencia sobre el jugador",
        ["frFR"] = "Opacité des icônes proches",
        ["koKR"] = "흐릿하게 표시하는 개수 설정",
        ["ptBR"] = "Transparência sobre o jogador",
        ["ruRU"] = "Степень блеклости",
        ["zhCN"] = "淡出透明度",
        ["zhTW"] = "和玩家重疊的淡出透明度",
    },
    ["How far from player should icons start to fade.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Distanz zum Spieler ab der Icons anfangen zu verblassen.\n(Standard: %s)",
        ["esES"] = "La distancia a la que tienen que estar los iconos del jugador para que se desvanezcan.\n(Predeterminado: %s)",
        ["esMX"] = "La distancia a la que tienen que estar los iconos del jugador para que se desvanezcan.\n(Predeterminado: %s)",
        ["frFR"] = "Définis la distance à partir de laquelle les icônes proches commencent à réapparaître.\n(Par défaut : %s)",
        ["koKR"] = "플레이어와 얼마나 멀리에 있는 퀘스트까지 흐릿하게 표시할지 설정합니다.\n(기본값: %s)",
        ["ptBR"] = "A que distância do jogador os ícones começam a desaparecer.\n(Padrão: %s)",
        ["ruRU"] = "Дистанция, на которой значки на миникарте рядом с игроком будут блекнуть\n(по умолчанию: %s)",
        ["zhCN"] = "目标距离你多近时，开始将其标记淡出\n（预设：%s）",
        ["zhTW"] = "距離玩家多近的圖示要開始淡出。\n(預設值: %s)",
    },
    ["How much should the icons around the player fade.\n(Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Wie stark die Icons um den Spieler herum verblassen sollen.\n(Standard: %s)",
        ["esES"] = "Cuando deberían desvanecerse los iconos alrededor del jugador.\n(Predeterminado: %s)",
        ["esMX"] = "Cuando deberían desvanecerse los iconos alrededor del jugador.\n(Predeterminado: %s)",
        ["frFR"] = "Définis l'opacité des icônes proches du joueur.\n(Par défaut : %s)",
        ["koKR"] = "얼마나 많은 퀘스트 아이콘을 흐릿하게 표시할지 설정합니다.\n(기본값: %s)",
        ["ptBR"] = "Quantos ícones ao redor do jogador devem desaparecer.\n(Padrão: %s)",
        ["ruRU"] = "Настройка степени блеклости значков на миникарте рядом с игроком\n(по умолчанию: %s)",
        ["zhCN"] = "靠近或与玩家重叠的标记，其淡出的透明度数值\n（预设：%s）",
        ["zhTW"] = "玩家附近的圖示要多透明。\n(預設值: %s)",
    },
    ["Show Minimap Coordinates"] = {
        ["enUS"] = true,
        ["deDE"] = "Minimap-Koordinanten",
        ["esES"] = "Coordenadas en el minimapa",
        ["esMX"] = "Coordenadas en el minimapa",
        ["frFR"] = "Coordonnées sur la minicarte",
        ["koKR"] = "미니맵 좌표",
        ["ptBR"] = "Coordenadas no minimapa",
        ["ruRU"] = "Координаты",
        ["zhCN"] = "小地图座标",
        ["zhTW"] = "顯示小地圖坐標",
    },
    ["Player coordinates on the Minimap"] = {
        ["enUS"] = true,
        ["deDE"] = "Spieler-Koordinaten auf der Minimap",
        ["esES"] = "Coordenadas del jugador en el minimapa",
        ["esMX"] = "Coordenadas del jugador en el minimapa",
        ["frFR"] = "Coordonnées du joueur sur la minicarte",
        ["koKR"] = "미니맵에 좌표 표시",
        ["ptBR"] = "Coordenadas do jogador no minimapa",
        ["ruRU"] = "Координаты игрока",
        ["zhCN"] = "启用小地图座标",
        ["zhTW"] = "小地圖顯示玩家坐標",
    },
    ["Place the Player's coordinates on the Minimap title."] = {
        ["enUS"] = true,
        ["deDE"] = "Zeigt die Spieler-Koordinanten an der Minimap.",
        ["esES"] = "Muestra las coordenadas del jugador en el título del minimapa.",
        ["esMX"] = "Muestra las coordenadas del jugador en el título del minimapa.",
        ["frFR"] = "Affiche les coordonnées du joueur dans le titre de la minicarte.",
        ["koKR"] = "미니맵 제목 영역에 플레이어의 좌표를 표시합니다.",
        ["ptBR"] = "Mostra as coordenadas do jogador no título do minimapa.",
        ["ruRU"] = "Показать/скрыть координаты игрока в заголовке миникарты",
        ["zhCN"] = "在小地图标题上显示玩家座标。",
        ["zhTW"] = "在小地圖的標題中顯示玩家坐標。",
    },
}

for k, v in pairs(minimapOptionsLocales) do
    l10n.translations[k] = v
end
