---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local iconOptionsLocales = {
    ["Enable Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons aktivieren",
        ["esES"] = "Activar iconos",
        ["esMX"] = "Activar iconos",
        ["frFR"] = "Activer les icônes",
        ["koKR"] = "아이콘 활성화",
        ["ptBR"] = "Ativar ícones",
        ["ruRU"] = "Значки Questie",
        ["zhCN"] = "启用图标",
        ["zhTW"] = "啟用圖示",
    },
    ["Shows or hides the icons that Questie draws on the world map and minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktivieren/Deaktivieren der Questie-Icons",
        ["esES"] = "Activa o desactiva los iconos.",
        ["esMX"] = "Activa o desactiva los iconos.",
        ["frFR"] = "Active l'affichage des icônes.",
        ["koKR"] = "Questie 아이콘을 활성화합니다.",
        ["ptBR"] = "Ativa ou desativa os ícones.",
        ["ruRU"] = "Показать/скрыть значки Questie",
        ["zhCN"] = "在小地图和大地图上启用或禁用Questie图标",
        ["zhTW"] = "啟用或停用任務位置提示的圖示。",
    },
    ["Config Tracking Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracking Icons konfigurieren",
        ["esES"] = "Configurar iconos de seguimiento",
        ["esMX"] = "Configurar iconos de seguimiento",
        ["frFR"] = "Configurer les icônes de suivi",
        ["koKR"] = "추적 아이콘 설정",
        ["ptBR"] = "Configurar ícones de rastreamento",
        ["ruRU"] = "Отслеживаемые значки",
        ["zhCN"] = "显示追踪图标",
        ["zhTW"] = "設定追蹤圖示",
    },
    ["Allows to select which tracking icons (like Mailbox, Repair-NPCs) to show on the map and minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Ermöglicht das Konfigurieren der Tracking Icons (z.B. Briefkästen, Reparatur-NPCs) auf der Karte und Minimap.",
        ["esES"] = "Permite seleccionar qué iconos de seguimiento (como buzón, PNJ de reparación) se mostrarán en el mapa y el minimapa.",
        ["esMX"] = "Permite seleccionar qué iconos de seguimiento (como buzón, PNJ de reparación) se mostrarán en el mapa y el minimapa.",
        ["frFR"] = "Permet de sélectionner les icônes de suivi (comme la boîte aux lettres, les PNJ de réparation) à afficher sur la carte et la minicarte.",
        ["koKR"] = "지도에 표시할 추적 아이콘(예: 우체통, 수리NPC)을 선택할 수 있습니다.",
        ["ptBR"] = "Permite selecionar quais ícones de rastreamento (como caixa de correio, NPC de conserto) mostrar no mapa e minimapa.",
        ["ruRU"] = "Позволяет выбрать, какие полезные значки (почтовый ящик, ремонт и проч.) отображать на карте и миникарте",
        ["zhCN"] = "允许在地图和小地图上选择显示追踪图标（例如“邮箱”，“修理”）。",
        ["zhTW"] = "可以選擇哪些追蹤圖示 (例如郵箱、修理商人) 要顯示在地圖和小地圖上。",
    },
    ["Allows to select which profession trainers to show on the map and minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Ermöglicht das Konfigurieren der Berufe-Lehrer auf der Karte und Minimap.",
        ["esES"] = "Permite seleccionar qué instructores de profesión se mostrarán en el mapa y minimapa.",
        ["esMX"] = "Permite seleccionar qué instructores de profesión se mostrarán en el mapa y minimapa.",
        ["frFR"] = "Permet de sélectionner les maîtres de profession à afficher sur la carte et la minicarte.",
        ["koKR"] = "특정 직업 훈련사를 지도와 미니맵에 표시할지 선택할 수 있습니다.",
        ["ptBR"] = "Permite selecionar quais instrutores de profissão mostrar no mapa e minimapa.",
        ["ruRU"] = "Позволяет выбрать, каких учителей профессий отображать на карте и миникарте",
        ["zhCN"] = "允许在地图和小地图上选择显示专业训练师",
        ["zhTW"] = "可以選擇哪些專業訓練師要顯示在地圖和小地圖上。",
    },
    ["Allows to select which vendors to show on the map and minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Ermöglicht das Konfigurieren der Händler auf der Karte und Minimap.",
        ["esES"] = "Permite seleccionar qué vendedores se mostrarán en el mapa y minimapa.",
        ["esMX"] = "Permite seleccionar qué vendedores se mostrarán en el mapa y minimapa.",
        ["frFR"] = "Permet de sélectionner quels marchands afficher sur la carte et la minicarte.",
        ["koKR"] = "특정 상인을 지도와 미니맵에 표시할지 선택할 수 있습니다.",
        ["ptBR"] = "Permite selecionar quais comerciantes mostrar no mapa e minimapa.",
        ["ruRU"] = "Позволяет выбрать, каких продавцов отображать на карте и миникарте",
        ["zhCN"] = "允许在地图和小地图上选择显示商人",
        ["zhTW"] = "可以選擇哪些商人要顯示在地圖和小地圖上。",
    },
    ["Icon Types"] = {
        ["enUS"] = true,
        ["deDE"] = "Icon-Arten",
        ["esES"] = "Tipos de icono",
        ["esMX"] = "Tipos de icono",
        ["frFR"] = "Types d'icône",
        ["koKR"] = "아이콘 유형",
        ["ptBR"] = "Tipos de ícone",
        ["ruRU"] = "Типы значков",
        ["zhCN"] = "图标类别",
        ["zhTW"] = "圖示類型",
    },
    ["When this is enabled, the quest turn-in locations will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der abgeschlossenen Quests auf der Karte/Minimap.",
        ["esES"] = "Si está activado, la ubicación de misiones completadas se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de misiones completadas se mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes terminées sur la carte et la minicarte.",
        ["koKR"] = "퀘스트 완료 아이콘을 지도와 미니맵에 표시합니다.",
        ["ptBR"] = "Se ativado, a localização de missões concluídas será exibida no mapa e minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения выполненных заданий на карте и миникарте",
        ["zhCN"] = "若启用，在地图上标记提交任务的地点",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示回任務的位置。",
    },
    ["Enable Map Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Karten-Icons anzeigen",
        ["esES"] = "Activar iconos en el mapa",
        ["esMX"] = "Activar iconos en el mapa",
        ["frFR"] = "Activer les icônes sur la carte",
        ["koKR"] = "지도 아이콘 활성화",
        ["ptBR"] = "Ativar ícones no mapa",
        ["ruRU"] = "Значки на карте",
        ["zhCN"] = "启用大地图图标",
        ["zhTW"] = "啟用大地圖圖示",
    },
    ["Show/hide all icons from the main map."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert alle Icons auf der Karte",
        ["esES"] = "Activa o desactiva todos los iconos en el mapa.",
        ["esMX"] = "Activa o desactiva todos los iconos en el mapa.",
        ["frFR"] = "Active l'affichage de toutes les icônes sur la carte.",
        ["koKR"] = "세계 지도에 퀘스트 아이콘을 표시합니다.",
        ["ptBR"] = "Ativa ou desativa todos os ícones no mapa.",
        ["ruRU"] = "Показать/скрыть все значки на карте",
        ["zhCN"] = "启用或停用大地图上的所有图标",
        ["zhTW"] = "顯示/隱藏大地圖上的所有圖示。",
    },
    ["Enable Minimap Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Minimap-Icons anzeigen",
        ["esES"] = "Activar iconos en el minimapa",
        ["esMX"] = "Activar iconos en el minimapa",
        ["frFR"] = "Activer les icônes sur la minicarte",
        ["koKR"] = "미니맵 아이콘 활성화",
        ["ptBR"] = "Ativar ícones no minimapa",
        ["ruRU"] = "Значки на миникарте",
        ["zhCN"] = "启用小地图标记",
        ["zhTW"] = "啟用小地圖圖示",
    },
    ["Show/hide all icons from the minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert alle Icons auf der Minimap",
        ["esES"] = "Activa o desactiva todos los iconos en el minimapa.",
        ["esMX"] = "Activa o desactiva todos los iconos en el minimapa.",
        ["frFR"] = "Active l'affichage de toutes les icônes sur la minicarte.",
        ["koKR"] = "미니맵에 퀘스트 아이콘을 표시합니다.",
        ["ptBR"] = "Ativa ou desativa todos os ícones no minimapa.",
        ["ruRU"] = "Показать/скрыть все значки на миникарте",
        ["zhCN"] = "启用或停用小地图上的所有图标",
        ["zhTW"] = "顯示/隱藏小地圖上的所有圖示。",
    },
    ["Hide Icons in Unexplored Areas"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons in nicht entdeckten Gebieten verbergen",
        ["esES"] = "Ocultar iconos en áreas inexploradas",
        ["esMX"] = "Ocultar iconos en áreas inexploradas",
        ["frFR"] = "Cacher les icônes dans les zones inexplorées",
        ["koKR"] = "미탐험 지역 아이콘 가리기",
        ["ptBR"] = "Ocultar ícones em áreas inexploradas",
        ["ruRU"] = "Значки неисследованных зон",
        ["zhCN"] = "隐藏未探测区域图标",
        ["zhTW"] = "隱藏未探索區域的圖示",
    },
    ["Hide icons in unexplored map regions."] = {
        ["enUS"] = true,
        ["deDE"] = "Verbirgt die Questie Icons in nicht entdeckten Gebieten.",
        ["esES"] = "Oculta iconos en áreas inexploradas.",
        ["esMX"] = "Oculta iconos en áreas inexploradas.",
        ["frFR"] = "Désactive l'affichage des icônes dans les zones inexplorées.",
        ["koKR"] = "미탐험 지역의 아이콘을 가립니다.",
        ["ptBR"] = "Oculta ícones em áreas inexploradas.",
        ["ruRU"] = "Показать/скрыть значки в неисследованных областях карты",
        ["zhCN"] = "隐藏未探测区域中的图标",
        ["zhTW"] = "隱藏在尚未探索的區域內的圖示。",
    },
    ["Hide icons of untracked quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons nicht getrackter Quests verbergen",
        ["esES"] = "Ocultar iconos de misiones sin seguimiento",
        ["esMX"] = "Ocultar iconos de misiones sin seguimiento",
        ["frFR"] = "Cacher les icônes des quêtes non suivies",
        ["koKR"] = "추적되지 않은 퀘스트의 아이콘 숨기기",
        ["ptBR"] = "Ocultar ícones de missões não rastreadas",
        ["ruRU"] = "Значки неотслеживаемых заданий",
        ["zhCN"] = "隐藏未追踪的任务图标",
        ["zhTW"] = "隱藏未追蹤任務的圖示",
    },
    ["Hide icons for quests that are not tracked."] = {
        ["enUS"] = true,
        ["deDE"] = "Verbirgt die Icons aller Quests die nicht vom Tracker getrackt werden.",
        ["esES"] = "Oculta los iconos de las misiones que no se rastrean.",
        ["esMX"] = "Oculta los iconos de las misiones que no se rastrean.",
        ["frFR"] = "Cache les icônes pour les quêtes qui ne sont pas suivies.",
        ["koKR"] = "추적되지 않은 퀘스트의 아이콘을 숨깁니다.",
        ["ptBR"] = "Oculta ícones para missões que não são rastreadas.",
        ["ruRU"] = "Показать/скрыть значки заданий, которые не отслеживаются в трекере",
        ["zhCN"] = "隐藏追踪器上未追踪的任务图标",
        ["zhTW"] = "隱藏沒有在任務追蹤清單中的任務的圖示。",
    },
    ["Show custom quest frame icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeige angepasste Icons in Quest-Fenster",
        ["esES"] = "Mostrar iconos personalizados",
        ["esMX"] = "Mostrar iconos personalizados",
        ["frFR"] = "Afficher les icônes personnalisés",
        ["koKR"] = "커스텀 퀘스트 프레임 아이콘 표시",
        ["ptBR"] = "Mostrar ícones personalizados",
        ["ruRU"] = "Значки пользователя в диалогах",
        ["zhCN"] = "显示自定义任务窗口图标",
        ["zhTW"] = "顯示自訂任務視窗圖示",
    },
    ["Use custom Questie icons for NPC dialogs, reflecting the status and type of each quest."] = {
        ["enUS"] = true,
        ["deDE"] = "Questie zeigt in NPC-Dialogen angepasste Icons, die den Status und Typ jeder Quest widerspiegeln.",
        ["esES"] = "Utiliza iconos de Questie personalizados para los diálogos de PNJ, que reflejen el estado y el tipo de cada misión.",
        ["esMX"] = "Utiliza iconos de Questie personalizados para los diálogos de PNJ, que reflejen el estado y el tipo de cada misión.",
        ["frFR"] = "Utilise les icônes de Questie personnalisées pour les dialogues des PNJ, reflétant le statut et le type de chaque quête.",
        ["koKR"] = "각 퀘스트의 상태와 유형을 반영하는 커스텀 Questie 아이콘을 NPC 대화 상자에 사용합니다.",
        ["ptBR"] = "Use ícones personalizados de Questie para diálogos de NPCs, refletindo o status e o tipo de cada missão.",
        ["ruRU"] = "Показать/скрыть пользовательские значки, отражающие статус и тип каждого задания, во время диалога с NPC",
        ["zhCN"] = "NPC 对话框显示任务位置提示插件的自定义图标，反应出每个任务的状态和类型。",
        ["zhTW"] = "NPC 對話框顯示任務位置提示插件的自訂圖示，反應出每個任務的狀態和類型。",
    },
    ["Enable Available Quest Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons zu verfügbaren Quests anzeigen",
        ["esES"] = "Activar iconos de misión disponible",
        ["esMX"] = "Activar iconos de misión disponible",
        ["frFR"] = "Icônes des quêtes disponibles",
        ["koKR"] = "수행 가능한 퀘스트 아이콘 활성화",
        ["ptBR"] = "Ativar ícones de missões disponíveis",
        ["ruRU"] = "Значки доступных заданий",
        ["zhCN"] = "启用可接任务图标",
        ["zhTW"] = "啟用可接的任務圖示",
    },
    ["When this is enabled, the locations of available quests will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der verfügbaren Quests auf der Karte/Minimap.",
        ["esES"] = "Si está activado, la ubicación de misiones disponibles se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de misiones disponibles se mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes disponibles sur la carte et la minicarte.",
        ["koKR"] = "수행 가능한 퀘스트 아이콘을 지도와 미니맵에 표시합니다.",
        ["ptBR"] = "Se ativado, a localização de missões disponíveis será exibida no mapa e minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения доступных заданий на карте и миникарте",
        ["zhCN"] = "若启用，在地图上标记可接任务的地点",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示可取得任務的位置。",
    },
    ["Enable Event Quest Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Event-Quest anzeigen",
        ["esES"] = "Activar iconos de misiones de evento",
        ["esMX"] = "Activar iconos de misiones de evento",
        ["frFR"] = "Icônes des quêtes d'évènement",
        ["koKR"] = "이벤트 퀘스트 아이콘 활성화",
        ["ptBR"] = "Ativar ícones da missão de evento",
        ["ruRU"] = "Значки заданий игровых событий",
        ["zhCN"] = "启用事件任务图标",
        ["zhTW"] = "啟用事件任務圖示",
    },
    ["When this is enabled, the locations of active event quests will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Event-Quests auf der Karte/Minimap.",
        ["esES"] = "Si está activado, la ubicación de misiones de evento se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de misiones de evento se mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes des évènements mondiaux sur la carte et la minicarte.",
        ["koKR"] = "아이콘을 활성화시, 이벤트 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["ptBR"] = "Se ativado, a localização de missões de evento será exibida no mapa e minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий игровых событий на карте и миникарте",
        ["zhCN"] = "启用此功能后，事件任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示可取得事件任務的位置。",
    },
    ["Enable Objective Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons zu Questzielen anzeigen",
        ["esES"] = "Activar iconos de objetivo",
        ["esMX"] = "Activar iconos de objetivo",
        ["frFR"] = "Icônes des objectifs",
        ["koKR"] = "퀘스트 목표 아이콘 활성화",
        ["ptBR"] = "Ativar ícones do objectivo",
        ["ruRU"] = "Значки целей заданий",
        ["zhCN"] = "启用目标图标",
        ["zhTW"] = "啟用目標圖示",
    },
    ["When this is enabled, quest objective icons will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der Questziele auf der Karte/Minimap.",
        ["esES"] = "Si está activado, la ubicación de objetivos de misión se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de objetivos de misión se mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des objectifs de quête sur la carte et la minicarte.",
        ["koKR"] = "퀘스트 목표 아이콘을 지도와 미니맵에 표시합니다.",
        ["ptBR"] = "Se ativado, a localização de objetivos de missão será exibida no mapa e minimapa.",
        ["ruRU"] = "Показать/скрыть значки целей заданий на карте и миникарте",
        ["zhCN"] = "当启用此项时，任务目标图标会显示在地图/小地图上。",
        ["zhTW"] = "當啟用此項時，任務目標圖示將會顯示在地圖/小地圖上。",
    },
    ["Enable Repeatable Quest Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Wiederholbare Quests anzeigen",
        ["esES"] = "Mostrar misiones repetibles",
        ["esMX"] = "Mostrar misiones repetibles",
        ["frFR"] = "Quêtes répétables sur la carte",
        ["koKR"] = "지도에 반복 퀘스트를 표시",
        ["ptBR"] = "Mostrar missões repetíveis no mapa",
        ["ruRU"] = "Значки повторяемых заданий",
        ["zhCN"] = "启用重复的任务图标",
        ["zhTW"] = "顯示可重覆接取的任務圖示",
    },
    ["When this is enabled, the locations of repeatable quests will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von wiederholbaren Quests auf der Karte/Minimap.",
        ["esES"] = "Si está activado, la ubicación de misiones repetibles se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de misiones repetibles se mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes répétables sur la carte et la minicarte.",
        ["koKR"] = "지도나 미니맵에 반복 퀘스트를 표시할지 말지 선택합니다.",
        ["ptBR"] = "Se ativado, a localização de missões repetíveis será exibida no mapa e minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения повторяемых заданий на карте и миникарте",
        ["zhCN"] = "启用此功能后，重复任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示可以重覆接取的任務。",
    },
    ["Enable Raid Quest Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Raid-Quests anzeigen",
        ["esES"] = "Activar iconos de misiones de bandas",
        ["esMX"] = "Activar iconos de misiones de bandas",
        ["frFR"] = "Icônes des quêtes de raid",
        ["koKR"] = "레이드 퀘스트 아이콘 활성화",
        ["ptBR"] = "Ativar ícones de missões de raide",
        ["ruRU"] = "Значки рейдовых заданий",
        ["zhCN"] = "启用团队任务图标",
        ["zhTW"] = "啟用團隊任務圖示",
    },
    ["When this is enabled, the locations of raid quests will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Raid-Quests auf der Karte/Minimap.",
        ["esES"] = "Si está activado, la ubicación de misiones de banda se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de misiones de banda se mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de raid sur la carte et la minicarte.",
        ["koKR"] = "아이콘을 활성화시, 레이드 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["ptBR"] = "Se ativado, a localização de missões de raide será exibida no mapa e minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения рейдовых заданий на карте и миникарте",
        ["zhCN"] = "启用此功能后，团队任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示團隊任務。",
    },
    ["Enable Dungeon Quest Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Dungeon-Quests anzeigen",
        ["esES"] = "Activar iconos de misiones de mazmorra",
        ["esMX"] = "Activar iconos de misiones de calabozo",
        ["frFR"] = "Icônes des quêtes de donjon",
        ["koKR"] = "던전 퀘스트 활성화",
        ["ptBR"] = "Ativar ícones de missões de masmorra",
        ["ruRU"] = "Значки заданий подземелий",
        ["zhCN"] = "启用副本任务图标",
        ["zhTW"] = "啟用地城任務圖示",
    },
    ["When this is enabled, the locations of dungeon quests will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Dungeon-Quests auf der Karte/Minimap.",
        ["esES"] = "Si está activado, la ubicación de misiones de mazmorra se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de misiones de calabozo se mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de donjon sur la carte et la minicarte.",
        ["koKR"] = "아이콘을 활성화시, 던전 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["ptBR"] = "Se ativado, a localização de missões de masmorra será exibida no mapa e minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий подземелий на карте и миникарте",
        ["zhCN"] = "启用此功能后，副本任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示地城任務。",
    },
    ["Enable Completed Quest Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons zu abgeschlossenen Quests anzeigen",
        ["esES"] = "Activar iconos de misión completada",
        ["esMX"] = "Activar iconos de misión completada",
        ["frFR"] = "Icônes des quêtes terminées",
        ["koKR"] = "퀘스트 완료 아이콘 활성화",
        ["ptBR"] = "Ativar ícones de missões concluídas",
        ["ruRU"] = "Значки выполненных заданий",
        ["zhCN"] = "启用提交任务标记",
        ["zhTW"] = "啟用已完成的任務圖示",
    },
    ["Enable PvP Quest Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "PvP-Quests anzeigen",
        ["esES"] = "Activar iconos de misiones de JcJ",
        ["esMX"] = "Activar iconos de misiones de JcJ",
        ["frFR"] = "Icônes des quêtes JcJ",
        ["koKR"] = "PVP 퀘스트 아이콘 활성화",
        ["ptBR"] = "Ativar ícones de missões de JxJ",
        ["ruRU"] = "Значки PvP-заданий",
        ["zhCN"] = "启用PVP任务图标",
        ["zhTW"] = "啟用 PvP 任務圖示",
    },
    ["When this is enabled, the locations of PvP quests will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von PvP-Quests auf der Karte/Minimap.",
        ["esES"] = "Si está activado, la ubicación de misiones de JcJ se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de misiones de JcJ se mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes JcJ sur la carte et la minicarte.",
        ["koKR"] = "아이콘을 활성화시, PVP 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["ptBR"] = "Se ativado, a localização de missões de JxJ será exibida no mapa e minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения PvP-заданий на карте и миникарте",
        ["zhCN"] = "启用此功能后，PVP任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示 PvP 任務。",
    },
    ["Available AQ War Effort Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "AQ Kriegsanstrengungen Quests anzeigen",
        ["esES"] = "El esfuerzo de guerra de Ahn'Qiraj",
        ["esMX"] = "La campaña de guerra de Ahn'Qiraj",
        ["frFR"] = "L'effort de guerre d'Ahn'Qiraj",
        ["koKR"] = "안퀴라즈 반납 퀘스트 아이콘 활성화",
        ["ptBR"] = "O Esforço de Guerra de Ahn'Qiraj",
        ["ruRU"] = "Значки военной кампании Ан'Киража",
        ["zhCN"] = "启用安其拉战备任务图标",
        ["zhTW"] = "啟用安其拉之門戰火任務圖示",
    },
    ["When this is enabled, the locations of the AQ War Effort quests will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der AQ Kriegsanstrengungen Quests auf der Karte/Minimap.",
        ["esES"] = "Si está activado, la ubicación de misiones del esfuerzo de guerra de Ahn'Qiraj se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de misiones de la campaña de guerra de Ahn'Qiraj se mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de l'effort de guerre d'Ahn'Qiraj sur la carte et la minicarte.",
        ["koKR"] = "아이콘을 활성화시, 안퀴라즈 반납 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["ptBR"] = "Se ativado, a localização de missões do Esforço de Guerra de Ahn'Qiraj será exibida no mapa e minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий военной кампании Ан'Киража на карте и миникарте",
        ["zhCN"] = "启用此功能后，安其拉战备任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示安其拉之門戰火任務。",
    },
    ["The AQ War Effort quests are shown for you. If your server is done you can hide those quests in the Icons settings of Questie!"] = {
        ["enUS"] = true,
        ["deDE"] = "Die AQ Kriegsanstrengungen-Quests werden für dich angezeigt. Wenn dein Server fertig ist, kannst du diese Quests in den Icons-Einstellungen von Questie ausblenden!",
        ["esES"] = "Las misiones del esfuerzo de guerra de Ahn'Qiraj se muestran para ti. Si tu servidor ya terminó, puedes ocultarlas en la configuración de iconos de Questie.",
        ["esMX"] = "Las misiones de la campaña de guerra de Ahn'Qiraj se muestran para ti. Si tu servidor ya terminó, puedes ocultarlas en la configuración de iconos de Questie.",
        ["frFR"] = "Les quêtes de l’effort de guerre d’Ahn'Qiraj sont affichées pour vous. Si votre serveur a terminé, vous pouvez les cacher dans les paramètres des icônes de Questie.",
        ["koKR"] = "안퀴라즈 반납 퀘스트가 표시됩니다. 만약 당신의 서버가 해당 퀘스트를 완료했다면, Questie 아이콘 설정에서 이를 숨길 수 있습니다.",
        ["ptBR"] = "As missões do Esforço de Guerra de Ahn'Qiraj estão sendo exibidas para você. Se o seu servidor já concluiu, você pode ocultá-las nas configurações de ícones de Questie.",
        ["ruRU"] = "Задания войны в Ан'Кираже отображаются для вас. Если на вашем сервере это завершено, то вы можете скрыть эти задания в настройках значков Questie!",
        ["zhCN"] = false,
        ["zhTW"] = "已經為你顯示『安其拉戰線』任務。如果你的伺服器已經完成這些任務，可以在 Questie 的圖示設定中隱藏這些任務！",
    },
    ["Toggle pfQuest/ClassicCodex icon style"] = {
        ["enUS"] = true,
        ["deDE"] = "pfQuest/ClassicCodex Iconstil umschalten",
        ["esES"] = "Alternar estilo de icono pfQuest/ClassicCodex",
        ["esMX"] = "Alternar estilo de icono pfQuest/ClassicCodex",
        ["frFR"] = "Basculer le style d'icône de pfQuest/ClassicCodex",
        ["koKR"] = "pfQuest/ClassicCodex 아이콘 스타일 전환",
        ["ptBR"] = "Alternar o estilo de ícone do pfQuest/ClassicCodex",
        ["ruRU"] = "Значки pfQuest/ClassicCodex",
        ["zhCN"] = "切换 pfQuest/ClassicCodex 图标样式",
        ["zhTW"] = "切換 pfQuest/ClassicCodex 圖示風格",
    },
    ["Toggles between Questie icon style and pfQuest/ClassicCodex icon style.\n\nToggling affects the following settings:\n\n- Objective icons\n- "] = {
        ["enUS"] = true,
        ["deDE"] = "Schaltet zwischen Questie Iconstil und pfQuest/ClassicCodex Iconstil um.\n\nUmschalten beeinflusst die folgenden Einstellungen:\n\n- Zielicons\n- ",
        ["esES"] = "Alterna entre el estilo de icono Questie y el estilo de icono pfQuest/ClassicCodex.\n\nLa alternancia afecta las siguientes configuraciones:\n\n- Iconos de objetivos\n- ",
        ["esMX"] = "Alterna entre el estilo de icono Questie y el estilo de icono pfQuest/ClassicCodex.\n\nLa alternancia afecta las siguientes configuraciones:\n\n- Iconos de objetivos\n- ",
        ["frFR"] = "Basculer entre le style d'icône de Questie et le style d'icône de pfQuest/ClassicCodex.\n\nLe basculement affecte les paramètres suivants :\n\n- Icônes d'objectifs\n-",
        ["koKR"] = "Questie 아이콘 스타일과 pfQuest/ClassicCodex 아이콘 스타일 간 전환\n\n전환은 다음 설정에 영향을 미칩니다:\n\n- 목표 아이콘\n- ",
        ["ptBR"] = "Alterna entre o estilo de ícone de Questie e o estilo de ícone do pfQuest/ClassicCodex.\n\nAlternar afeta as seguintes configurações:\n\n- Ícones de objetivo\n-",
        ["ruRU"] = "Переключает между стилями значков Questie или pfQuest/ClassicCodex.\n\nЭто влияет на:\n\n- Значки целей заданий\n- ",
        ["zhCN"] = "在 Questie 图标风格与 pfQuest/ClassicCodex 图标样式之间切换。\n\n切换会影响以下设置：\n\n- 目标图标\n- ",
        ["zhTW"] = "在 Questie 圖示風格與 pfQuest/ClassicCodex 圖示風格之間切換。\n\n切換會影響以下設定：\n\n- 目標圖示\n- ",
    },
    ["Icon Overrides (show/hide)"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons überschreiben",
        ["esES"] = "Anulación de iconos (mostrar/ocultar)",
        ["esMX"] = "Anulación de iconos (mostrar/ocultar)",
        ["frFR"] = "Remplacements d'icônes (afficher/cacher)",
        ["koKR"] = "아이콘 오버라이드(표시/숨기기)",
        ["ptBR"] = "Sobreposições de ícones (mostrar/ocultar)",
        ["ruRU"] = "Переопределение значков",
        ["zhCN"] = "覆盖图标 （显示/隐藏）",
        ["zhTW"] = "顯示/隱藏圖示",
    },
    ["Slay objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Tötungsziele",
        ["esES"] = "Objetivos de matanza",
        ["esMX"] = "Objetivos de matanza",
        ["frFR"] = "Objectifs de tuerie",
        ["koKR"] = "처치 목표",
        ["ptBR"] = "Objetivos de matança",
        ["ruRU"] = "Убийство",
        ["zhCN"] = "击杀目标",
        ["zhTW"] = "擊殺目標",
    },
    ["The icon that is displayed for quest objectives where you need to kill an NPC"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für Questziele wo du jemanden töten musst angezeigt wird",
        ["esES"] = "El icono que se muestra para los objetivos de misión en los que necesitas matar a un PNJ.",
        ["esMX"] = "El icono que se muestra para los objetivos de misión en los que necesitas matar a un PNJ.",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez tuer un PNJ.",
        ["koKR"] = "NPC를 처치해야 하는 퀘스트 목표에 표시되는 아이콘",
        ["ptBR"] = "O ícone mostrado para os objetivos da missão onde você precisa matar um NPC.",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно убить NPC",
        ["zhCN"] = "用于需要击杀 NPC 的任务目标上所显示的图标",
        ["zhTW"] = "用於需要擊殺 NPC 的任務目標上所顯示的圖示",
    },
    ["Loot objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Beuteziele",
        ["esES"] = "Objetivos de botín",
        ["esMX"] = "Objetivos de botín",
        ["frFR"] = "Objectifs de butin",
        ["koKR"] = "아이템 수집 목표",
        ["ptBR"] = "Objetivos de saque",
        ["ruRU"] = "Добыча",
        ["zhCN"] = "拾取目标",
        ["zhTW"] = "拾取目標",
    },
    ["The icon that is displayed for quest objectives where you need to loot an item"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für Questziele wo du etwas plündern musst angezeigt wird",
        ["esES"] = "El icono que se muestra para los objetivos de misión en los que necesitas despojar un objeto.",
        ["esMX"] = "El icono que se muestra para los objetivos de misión en los que necesitas despojar un objeto.",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez fouiller un objet.",
        ["koKR"] = "아이템을 수집해야 하는 퀘스트 목표에 표시되는 아이콘",
        ["ptBR"] = "O ícone mostrado para os objetivos da missão onde você precisa saquear um item.",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно добыть предмет",
        ["zhCN"] = "用于需要拾取物品的任务目标上所显示的图标",
        ["zhTW"] = "用於需要拾取物品的任務目標上所顯示的圖示",
    },
    ["Object objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Objektziele",
        ["esES"] = "Objetivos de objeto",
        ["esMX"] = "Objetivos de objeto",
        ["frFR"] = "Objectifs d'objet",
        ["koKR"] = "객체 상호작용 목표",
        ["ptBR"] = "Objetivos de objeto",
        ["ruRU"] = "Объект",
        ["zhCN"] = "物体目标",
        ["zhTW"] = "物體目標",
    },
    ["The icon that is displayed for quest objectives where you need to interact with an object"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für Questziele wo du mit einem Objekt interagieren musst angezeigt wird",
        ["esES"] = "El icono que se muestra para los objetivos de misión en los que necesitas interactuar con un objeto.",
        ["esMX"] = "El icono que se muestra para los objetivos de misión en los que necesitas interactuar con un objeto.",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez interagir avec un objet.",
        ["koKR"] = "객체와 상호작용해야 하는 퀘스트 목표에 표시되는 아이콘",
        ["ptBR"] = "O ícone mostrado para os objetivos da missão onde você precisa interagir com um objeto.",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно провзаимодействовать с объектом",
        ["zhCN"] = "用于需要与物体互动的任务目标上所显示的图标",
        ["zhTW"] = "用於需要與物體互動的任務目標上所顯示的圖示",
    },
    ["Event objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Ereignisziele",
        ["esES"] = "Objetivos de evento",
        ["esMX"] = "Objetivos de evento",
        ["frFR"] = "Objectifs d'événement",
        ["koKR"] = "이벤트 목표",
        ["ptBR"] = "Objetivos de evento",
        ["ruRU"] = "Событие",
        ["zhCN"] = "事件目标",
        ["zhTW"] = "事件目標",
    },
    ["The icon that is displayed for quest objectives where you need to do something in a certain area, like exploring it or casting a spell there"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für Questziele angezeigt wird wo du in einem bestimmten Gebiet etwas machen musst, wie es zu erkunden oder dort einen Zauberspruch zu benutzen",
        ["esES"] = "El icono que se muestra para los objetivos de misión en los que necesitas hacer algo en un área determinada, como explorarla o lanzar un hechizo allí.",
        ["esMX"] = "El icono que se muestra para los objetivos de misión en los que necesitas hacer algo en un área determinada, como explorarla o lanzar un hechizo allí.",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez faire quelque chose dans une certaine zone.",
        ["koKR"] = "특정 지역에서 무언가를 해야 하는 퀘스트 목표에 표시되는 아이콘 (예: 탐험 또는 주문 시전)",
        ["ptBR"] = "O ícone mostrado para os objetivos da missão onde você precisa fazer algo em uma área específica.",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно сделать что-либо в определенной области, например, исследовать ее или произнести там заклинание",
        ["zhCN"] = "用于需要在特定区域内执行操作（例如探索该区域或在该区域施放法术）的任务目标上所显示的图标",
        ["zhTW"] = "用於需要在特定區域內執行操作（例如探索該區域或在該區域施放法術）的任務目標上所顯示的圖示",
    },
    ["Talk objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Gesprächsziele",
        ["esES"] = "Objetivos de habla",
        ["esMX"] = "Objetivos de habla",
        ["frFR"] = "Objectifs de parole",
        ["koKR"] = "NPC 대화 목표",
        ["ptBR"] = "Objetivos de fala",
        ["ruRU"] = "Разговор",
        ["zhCN"] = "对话目标",
        ["zhTW"] = "對話目標",
    },
    ["The icon that is displayed for quest objectives where you need to talk to an NPC"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für Questziele wo du mit einem NPC sprechen musst angezeigt wird",
        ["esES"] = "El icono que se muestra para los objetivos de misión en los que necesitas hablar con un PNJ.",
        ["esMX"] = "El icono que se muestra para los objetivos de misión en los que necesitas hablar con un PNJ.",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez parler à un PNJ.",
        ["koKR"] = "NPC와 대화해야 하는 퀘스트 목표에 표시되는 아이콘",
        ["ptBR"] = "O ícone mostrado para os objetivos da missão onde você precisa falar com um NPC.",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно поговорить с NPC",
        ["zhCN"] = "用于需要与 NPC 对话的任务目标上所显示的图标",
        ["zhTW"] = "用於需要與 NPC 對話的任務目標上所顯示的圖示",
    },
    ["Normal Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Normale Quests",
        ["esES"] = "Misiones normales",
        ["esMX"] = "Misiones normales",
        ["frFR"] = "Quêtes normales",
        ["koKR"] = "일반 퀘스트",
        ["ptBR"] = "Missões normais",
        ["ruRU"] = "Обычные задания",
        ["zhCN"] = "一般任务",
        ["zhTW"] = "一般任務",
    },
    ["Available quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare Quests",
        ["esES"] = "Misiones disponibles",
        ["esMX"] = "Misiones disponibles",
        ["frFR"] = "Quêtes disponibles",
        ["koKR"] = "실행 가능한 퀘스트",
        ["ptBR"] = "Missões disponíveis",
        ["ruRU"] = "Доступные",
        ["zhCN"] = "可接的任务",
        ["zhTW"] = "可接的任務",
    },
    ["The icon that is displayed for available quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für verfügbare Quests angezeigt wird",
        ["esES"] = "El icono que se muestra para las misiones disponibles.",
        ["esMX"] = "El icono que se muestra para las misiones disponibles.",
        ["frFR"] = "L'icône affichée pour les quêtes disponibles.",
        ["koKR"] = "실행 가능한 퀘스트에 표시되는 아이콘",
        ["ptBR"] = "O ícone exibido para as missões disponíveis.",
        ["ruRU"] = "Значок для доступных заданий",
        ["zhCN"] = "可接取的任务显示的图标",
        ["zhTW"] = "可取得的任務所顯示的圖示。",
    },
    ["Unavailable and trivial quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Nicht verfügbare und triviale Quests",
        ["esES"] = "Misiones no disponibles y triviales",
        ["esMX"] = "Misiones no disponibles y triviales",
        ["frFR"] = "Quêtes non disponibles et triviales",
        ["koKR"] = "실행 불가능 및 저레벨 퀘스트",
        ["ptBR"] = "Missões não disponíveis e triviais",
        ["ruRU"] = "Серые",
        ["zhCN"] = "无法接取和低等任务",
        ["zhTW"] = "無法取得和低等任務",
    },
    ["The icon that is displayed for quests that require additional conditions to be met before they can be accepted, or are so low level they don't reward experience"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für Quests angezeigt wird die zusätzliche Bedingungen haben bevor sie akzeptiert werden können, oder so niedriglevelig sind, dass sie keine Erfahrung gewähren",
        ["esES"] = "El icono que se muestra para misiones que requieren que se cumplan condiciones adicionales antes de poder ser aceptadas, o que son de un nivel tan bajo que no recompensan la experiencia.",
        ["esMX"] = "El icono que se muestra para misiones que requieren que se cumplan condiciones adicionales antes de poder ser aceptadas, o que son de un nivel tan bajo que no recompensan la experiencia.",
        ["frFR"] = "L'icône affichée pour les quêtes qui nécessitent des conditions supplémentaires à remplir avant de pouvoir être acceptées, ou qui sont de si bas niveau qu'elles ne donnent pas d'expérience en récompense.",
        ["koKR"] = "추가 조건이 충족되어야 수락할 수 있는 퀘스트 또는 경험치를 보상하지 않는 저레벨 퀘스트에 표시되는 아이콘",
        ["ptBR"] = "O ícone mostrado para missões que requerem condições adicionais a serem cumpridas antes de poderem ser aceitas, ou que são de nível tão baixo que não concedem experiência como recompensa.",
        ["ruRU"] = "Значок для серых заданий: недоступные (для принятия которых требуются определенные условия) и низкоуровневые (за выполнение которых вы не получите опыт)",
        ["zhCN"] = "需要额外条件才能接取的任务，或者是等级太低没有经验值的任务图标。",
        ["zhTW"] = "需要額外條件才能接取的任務，或是等級太低沒有經驗值的任務圖示。",
    },
    ["Complete quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossene Quests",
        ["esES"] = "Misiones completadas",
        ["esMX"] = "Misiones completadas",
        ["frFR"] = "Quêtes terminées",
        ["koKR"] = "완료된 퀘스트",
        ["ptBR"] = "Missões concluídas",
        ["ruRU"] = "Выполненные",
        ["zhCN"] = "完成任务",
        ["zhTW"] = "完成任務",
    },
    ["The icon that is displayed for completed quests that can be handed in"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für abgeschlossene Quests angezeigt wird",
        ["esES"] = "El icono que se muestra para las misiones completadas que se pueden entregar.",
        ["esMX"] = "El icono que se muestra para las misiones completadas que se pueden entregar.",
        ["frFR"] = "L'icône affichée pour les quêtes terminées qui peuvent être remises.",
        ["koKR"] = "완료되어 제출할 수 있는 퀘스트에 표시되는 아이콘",
        ["ptBR"] = "O ícone mostrado para missões concluída que podem ser entregues.",
        ["ruRU"] = "Значок для выполненных заданий",
        ["zhCN"] = "已完成，可以交回的任务图标。",
        ["zhTW"] = "已完成，可以交回的任務圖示。",
    },
    ["Repeatable Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Wiederholbare Quests",
        ["esES"] = "Misiones repetibles",
        ["esMX"] = "Misiones repetibles",
        ["frFR"] = "Quêtes répétables",
        ["koKR"] = "반복 가능한 퀘스트",
        ["ptBR"] = "Missões repetíveis",
        ["ruRU"] = "Повторяемые задания",
        ["zhCN"] = "重复性任务",
        ["zhTW"] = "重覆性任務",
    },
    ["Available repeatable quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare wiederholbare Quests",
        ["esES"] = "Misiones repetibles disponibles",
        ["esMX"] = "Misiones repetibles disponibles",
        ["frFR"] = "Quêtes répétables disponibles",
        ["koKR"] = "실행 가능한 반복 가능한 퀘스트",
        ["ptBR"] = "Missões repetíveis disponíveis",
        ["ruRU"] = "Доступные",
        ["zhCN"] = "可接的重复性任务",
        ["zhTW"] = "可接的重覆性任務",
    },
    ["The icon that is displayed for available repeatable quests like dailies"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für verfügbare wiederholbare Quests angezeigt wird",
        ["esES"] = "El icono que se muestra para las misiones repetibles disponibles, como las diarias.",
        ["esMX"] = "El icono que se muestra para las misiones repetibles disponibles, como las diarias.",
        ["frFR"] = "L'icône affichée pour les quêtes répétables disponibles comme les quotidiennes.",
        ["koKR"] = "실행 가능한 반복 가능한 퀘스트(일일 퀘스트 등)에 표시되는 아이콘",
        ["ptBR"] = "O ícone mostrado para missões repetíveis disponíveis, como as diárias.",
        ["ruRU"] = "Значок для повторяемых заданий типа ежедневных",
        ["zhCN"] = "可接取的重复性任务图标，例如：每日。",
        ["zhTW"] = "可取得的重覆性任務的圖示，例如每日。",
    },
    ["Complete repeatable quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossene wiederholbare Quests",
        ["esES"] = "Misiones repetibles completadas",
        ["esMX"] = "Misiones repetibles completadas",
        ["frFR"] = "Quêtes répétables terminées",
        ["koKR"] = "완료된 반복 가능한 퀘스트",
        ["ptBR"] = "Missões repetíveis completadas",
        ["ruRU"] = "Выполненные",
        ["zhCN"] = "完成重复性任务",
        ["zhTW"] = "完成重覆性任務",
    },
    ["The icon that is displayed for repeatable quests that can be handed in"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für wiederholbare Quests angezeigt wird, die abgegeben werden können",
        ["esES"] = "El icono que se muestra para las misiones repetibles que se pueden entregar.",
        ["esMX"] = "El icono que se muestra para las misiones repetibles que se pueden entregar.",
        ["frFR"] = "L'icône affichée pour les quêtes répétables terminées qui peuvent être remises.",
        ["koKR"] = "완료되어 제출할 수 있는 반복 가능한 퀘스트에 표시되는 아이콘",
        ["ptBR"] = "O ícone exibido para missões repetíveis completadas que podem ser entregues.",
        ["ruRU"] = "Значок для выполненных повторяемых заданий типа ежедневных",
        ["zhCN"] = "可以交回的重复性任务图标。",
        ["zhTW"] = "可以交回的重覆性任務圖示。",
    },
    ["Event Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Event-Quests",
        ["esES"] = "Misiones de evento",
        ["esMX"] = "Misiones de evento",
        ["frFR"] = "Quêtes d'événement",
        ["koKR"] = "이벤트 퀘스트",
        ["ptBR"] = "Missões de evento",
        ["ruRU"] = "Игровые события",
        ["zhCN"] = "节日任务",
        ["zhTW"] = "節慶任務",
    },
    ["Available event quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare Event-Quests",
        ["esES"] = "Misiones de evento disponibles",
        ["esMX"] = "Misiones de evento disponibles",
        ["frFR"] = "Quêtes d'événement disponibles",
        ["koKR"] = "실행 가능한 이벤트 퀘스트",
        ["ptBR"] = "Missões de evento disponíveis",
        ["ruRU"] = "Доступные",
        ["zhCN"] = "可接的节日任务",
        ["zhTW"] = "可接的節慶任務",
    },
    ["The icon that is displayed for available event quests during holidays"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für verfügbare Event-Quests angezeigt wird",
        ["esES"] = "El icono que se muestra para las misiones de evento disponibles durante las fiestas.",
        ["esMX"] = "El icono que se muestra para las misiones de evento disponibles durante las fiestas.",
        ["frFR"] = "L'icône affichée pour les quêtes d'événement disponibles pendant les fêtes.",
        ["koKR"] = "휴일 동안 실행 가능한 이벤트 퀘스트에 표시되는 아이콘",
        ["ptBR"] = "O ícone mostrado para missões de evento disponíveis durante feriados.",
        ["ruRU"] = "Значок для доступных заданий игровых событий во время праздников",
        ["zhCN"] = "节庆期间可以取得的节日任务",
        ["zhTW"] = "節慶期間可以取得的活動任務。",
    },
    ["Complete event quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossene Event-Quests",
        ["esES"] = "Misiones de evento completadas",
        ["esMX"] = "Misiones de evento completadas",
        ["frFR"] = "Quêtes d'événement terminées",
        ["koKR"] = "완료된 이벤트 퀘스트",
        ["ptBR"] = "Missões de evento completadas",
        ["ruRU"] = "Выполненные",
        ["zhCN"] = "完成节日任务",
        ["zhTW"] = "完成節慶任務",
    },
    ["The icon that is displayed for event quests that can be handed in"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für Event-Quests angezeigt wird, die abgegeben werden können",
        ["esES"] = "El icono que se muestra para las misiones de evento que se pueden entregar.",
        ["esMX"] = "El icono que se muestra para las misiones de evento que se pueden entregar.",
        ["frFR"] = "L'icône affichée pour les quêtes d'événement terminées qui peuvent être remises.",
        ["koKR"] = "완료되어 제출할 수 있는 이벤트 퀘스트에 표시되는 아이콘",
        ["ptBR"] = "O ícone exibido para missões de evento completadas que podem ser entregues.",
        ["ruRU"] = "Значок для выполненных заданий игровых событий во время праздников",
        ["zhCN"] = "可以交回的节日任务图标。",
        ["zhTW"] = "可以交回的節慶任務圖示。",
    },
    ["PvP Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "PvP-Quests",
        ["esES"] = "Misiones de JcJ",
        ["esMX"] = "Misiones de JcJ",
        ["frFR"] = "Quêtes JcJ",
        ["koKR"] = "PvP 퀘스트",
        ["ptBR"] = "Missões JxJ",
        ["ruRU"] = "PvP-задания",
        ["zhCN"] = "PVP 任务",
        ["zhTW"] = "PvP 任務",
    },
    ["Available PvP quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare PvP-Quests",
        ["esES"] = "Misiones de JcJ disponibles",
        ["esMX"] = "Misiones de JcJ disponibles",
        ["frFR"] = "Quêtes JcJ disponibles",
        ["koKR"] = "실행 가능한 PvP 퀘스트",
        ["ptBR"] = "Missões JxJ disponíveis",
        ["ruRU"] = "Доступные",
        ["zhCN"] = "可接的 PVP 任务",
        ["zhTW"] = "可接的 PvP 任務",
    },
    ["The icon that is displayed for available PvP quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für verfügbare PvP-Quests angezeigt wird",
        ["esES"] = "El icono que se muestra para las misiones de JcJ disponibles.",
        ["esMX"] = "El icono que se muestra para las misiones de JcJ disponibles.",
        ["frFR"] = "L'icône affichée pour les quêtes JcJ disponibles.",
        ["koKR"] = "실행 가능한 PvP 퀘스트에 표시되는 아이콘",
        ["ptBR"] = "O ícone mostrado para as missões JxJ disponíveis.",
        ["ruRU"] = "Значок для доступных PVP-заданий",
        ["zhCN"] = "可取得的 PVP 任务图标。",
        ["zhTW"] = "可取得的 PvP 任務圖示。",
    },
    ["Complete PvP quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossene PvP-Quests",
        ["esES"] = "Misiones de JcJ completadas",
        ["esMX"] = "Misiones de JcJ completadas",
        ["frFR"] = "Quêtes JcJ terminées",
        ["koKR"] = "완료된 PvP 퀘스트",
        ["ptBR"] = "Missões JxJ completadas",
        ["ruRU"] = "Выполненные",
        ["zhCN"] = "完成 PVP 任务",
        ["zhTW"] = "完成 PvP 任務",
    },
    ["The icon that is displayed for PvP quests that can be handed in"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für PvP-Quests angezeigt wird, die abgegeben werden können",
        ["esES"] = "El icono que se muestra para las misiones de JcJ que se pueden entregar.",
        ["esMX"] = "El icono que se muestra para las misiones de JcJ que se pueden entregar.",
        ["frFR"] = "L'icône affichée pour les quêtes JcJ terminées qui peuvent être remises.",
        ["koKR"] = "완료되어 제출할 수 있는 PvP 퀘스트에 표시되는 아이콘",
        ["ptBR"] = "O ícone mostrado para missões JxJ completadas que podem ser entregues.",
        ["ruRU"] = "Значок для выполненных PVP-заданий",
        ["zhCN"] = "可以交回的 PVP 任务图标。",
        ["zhTW"] = "可以交回的 PvP 任務圖示。",
    },
    ["Icons"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Iconos",
        ["esMX"] = "Iconos",
        ["frFR"] = "Icônes",
        ["koKR"] = "아이콘",
        ["ptBR"] = "Ícones",
        ["ruRU"] = "Значки",
        ["zhCN"] = "图标",
        ["zhTW"] = "圖示",
    },
    ["Icon Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Icon-Optionen",
        ["esES"] = "Opciones de iconos",
        ["esMX"] = "Opciones de iconos",
        ["frFR"] = "Options d'icône",
        ["koKR"] = "아이콘 옵션",
        ["ptBR"] = "Opções de ícone",
        ["ruRU"] = "Настройки значков",
        ["zhCN"] = "图标选项",
        ["zhTW"] = "圖示選項",
    },
    ["Show icons for..."] = {
        ["enUS"] = true,
        ["deDE"] = "Zeige Icons für...",
        ["esES"] = "Mostrar iconos para...",
        ["esMX"] = "Mostrar iconos para...",
        ["frFR"] = "Afficher les icônes pour...",
        ["koKR"] = "다음에 대한 아이콘 표시",
        ["ptBR"] = "Mostrar ícones para...",
        ["ruRU"] = "Отображать значки для...",
        ["zhCN"] = "显示...图标",
        ["zhTW"] = "顯示圖示...",
    },
    ["Available Normal Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare normale Quests",
        ["esES"] = "Misiones normales disponibles",
        ["esMX"] = "Misiones normales disponibles",
        ["frFR"] = "Quêtes normales disponibles",
        ["koKR"] = "실행 가능한 일반 퀘스트",
        ["ptBR"] = "Missões normais disponíveis",
        ["ruRU"] = "Обычные задания",
        ["zhCN"] = "可接受的一般任务",
        ["zhTW"] = "可接的一般任務",
    },
    ["Available Quests from Items"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare Quests von Gegenständen",
        ["esES"] = "Misiones disponibles a partir de objetos",
        ["esMX"] = "Misiones disponibles a partir de objetos",
        ["frFR"] = "Quêtes disponibles à partir d'objets",
        ["koKR"] = "아이템으로 실행 가능한 퀘스트",
        ["ptBR"] = "Missões disponíveis a partir de itens",
        ["ruRU"] = "Доступные задания от предметов",
        ["zhCN"] = "可从物品接取的任务",
        ["zhTW"] = "可從物品接到的任務",
    },
    ["When this is enabled, the locations of item drops that start quests will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn dies aktiviert ist werden die Orte wo man Gegenstände plündern kann die Quest starten auf der Karte/Minikarte angezeigt.",
        ["esES"] = "Si está activado, la ubicación de los objetos que inician misiones se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de los objetos que inician misiones se mostrará en el mapa y minimapa.",
        ["frFR"] = "Si cette option est activée, les emplacements des objets déposés qui déclenchent des quêtes seront affichés sur la carte et la minicarte.",
        ["koKR"] = "이 기능을 활성화하면 퀘스트를 시작하는 아이템 드롭 위치가 지도/미니맵에 표시됩니다.",
        ["ptBR"] = "Se ativado, as localizações dos itens que iniciam missões serão exibidas no mapa e minimapa.",
        ["ruRU"] = "Когда включено, местоположения выпадения предметов, начинающих задания, будут отображаться на карте/миникарте",
        ["zhCN"] = "当启用时，开始任务的物品掉落位置将显示在地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示開始任務的物品。",
    },
    ["Available Event Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare Event-Quests",
        ["esES"] = "Misiones de evento disponibles",
        ["esMX"] = "Misiones de evento disponibles",
        ["frFR"] = "Quêtes d'événement disponibles",
        ["koKR"] = "실행 가능한 이벤트 퀘스트",
        ["ptBR"] = "Missões de evento disponíveis",
        ["ruRU"] = "Игровые события",
        ["zhCN"] = "可接受的节日任务",
        ["zhTW"] = "可接的節慶任務",
    },
    ["Available Repeatable Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare Wiederholbare-Quests",
        ["esES"] = "Misiones repetibles disponibles",
        ["esMX"] = "Misiones repetibles disponibles",
        ["frFR"] = "Quêtes répétables disponibles",
        ["koKR"] = "실행 가능한 반복 퀘스트",
        ["ptBR"] = "Missões repetíveis disponíveis",
        ["ruRU"] = "Повторяемые задания",
        ["zhCN"] = "可接受的重复任务",
        ["zhTW"] = "可接的重覆性任務",
    },
    ["Available PvP Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare PvP-Quests",
        ["esES"] = "Misiones de JcJ disponibles",
        ["esMX"] = "Misiones de JcJ disponibles",
        ["frFR"] = "Quêtes JcJ disponibles",
        ["koKR"] = "실행 가능한 PvP 퀘스트",
        ["ptBR"] = "Missões JxJ disponíveis",
        ["ruRU"] = "PVP-задания",
        ["zhCN"] = "可接受的PVP任务",
        ["zhTW"] = "可接的 PvP 任務",
    },
    ["Available Dungeon Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare Dungeon-Quests",
        ["esES"] = "Misiones de mazmorra disponibles",
        ["esMX"] = "Misiones de calabozo disponibles",
        ["frFR"] = "Quêtes de donjon disponibles",
        ["koKR"] = "실행 가능한 던전 퀘스트",
        ["ptBR"] = "Missões de masmorra disponíveis",
        ["ruRU"] = "Задания подземелий",
        ["zhCN"] = "可接受的5人本任务",
        ["zhTW"] = "可接的地城任務",
    },
    ["Available Raid Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbare Raid-Quests",
        ["esES"] = "Misiones de banda disponibles",
        ["esMX"] = "Misiones de banda disponibles",
        ["frFR"] = "Quêtes de raid disponibles",
        ["koKR"] = "실행 가능한 레이드 퀘스트",
        ["ptBR"] = "Missões de raide disponíveis",
        ["ruRU"] = "Рейдовые задания",
        ["zhCN"] = "可接受的团队任务",
        ["zhTW"] = "可接的團隊任務",
    },
    ["Icon Scales"] = {
        ["enUS"] = true,
        ["deDE"] = "Icon-Skalierung",
        ["esES"] = "Escala de iconos",
        ["esMX"] = "Escala de iconos",
        ["frFR"] = "Échelle d'icônes",
        ["koKR"] = "아이콘 크기",
        ["ptBR"] = "Escala de ícones",
        ["ruRU"] = "Размер значков",
        ["zhCN"] = "图标大小",
        ["zhTW"] = "圖示大小",
    },
    ["Map Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Karten-Icons",
        ["esES"] = "Iconos del mapa",
        ["esMX"] = "Iconos del mapa",
        ["frFR"] = "Icônes de la carte",
        ["koKR"] = "지도 아이콘",
        ["ptBR"] = "Ícones do mapa",
        ["ruRU"] = "На карте",
        ["zhCN"] = "大地图图标",
        ["zhTW"] = "大地圖圖示",
    },
    ["Minimap Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Minimap-Icons",
        ["esES"] = "Iconos del minimapa",
        ["esMX"] = "Iconos del minimapa",
        ["frFR"] = "Icônes de la minicarte",
        ["koKR"] = "미니맵 아이콘",
        ["ptBR"] = "Ícones do minimapa",
        ["ruRU"] = "На миникарте",
        ["zhCN"] = "小地图图标",
        ["zhTW"] = "小地圖圖示",
    },
    ["Quest Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Icons",
        ["esES"] = "Iconos de misión",
        ["esMX"] = "Iconos de misión",
        ["frFR"] = "Icônes de quête",
        ["koKR"] = "퀘스트 아이콘",
        ["ptBR"] = "Ícones de missão",
        ["ruRU"] = "Задания",
        ["zhCN"] = "任务图标",
        ["zhTW"] = "任務圖示",
    },
    ["Icon Overrides"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons überschreiben",
        ["esES"] = "Anulación de iconos",
        ["esMX"] = "Anulación de iconos",
        ["frFR"] = "Remplacements d'icônes",
        ["koKR"] = "아이콘 오버라이드",
        ["ptBR"] = "Sobreposições de ícones",
        ["ruRU"] = "Переназначение значков",
        ["zhCN"] = "图标覆盖",
        ["zhTW"] = "自訂圖示",
    },
    ["Hide Icons on Continent Map"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons auf Kontinentkarte ausblenden",
        ["esES"] = "Ocultar iconos en el mapa continental",
        ["esMX"] = "Ocultar iconos en el mapa continental",
        ["frFR"] = "Cacher les icônes sur la carte du continent",
        ["koKR"] = "대륙 지도에서 아이콘 숨기기",
        ["ptBR"] = "Ocultar ícones no mapa do continente",
        ["ruRU"] = "Скрыть на континенте",
        ["zhCN"] = "隐藏大陆地图上的图标",
        ["zhTW"] = "隱藏大陸地圖上的圖示",
    },
    ["Hide icons on the continent map, when not viewing a specific zone."] = {
        ["enUS"] = true,
        ["deDE"] = "Blendet Icons auf der Kontinentkarte aus, wenn keine Zone ausgewählt ist.",
        ["esES"] = "Oculta iconos en el mapa del continente cuando no estés viendo una zona específica.",
        ["esMX"] = "Oculta iconos en el mapa del continente cuando no estés viendo una zona específica.",
        ["frFR"] = "Cache les icônes sur la carte du continent lorsque aucune zone spécifique n'est affichée.",
        ["koKR"] = "특정 지역을 보고 있지 않을 때 대륙 지도에서 아이콘을 숨깁니다.",
        ["ptBR"] = "Oculta ícones no mapa do continente quando nenhuma zona específica está sendo visualizada.",
        ["ruRU"] = "Скрывает значки на карте континента",
        ["zhCN"] = "当不查阅特定区域时，颖仓大陆地图上的图标",
        ["zhTW"] = "不是檢視特定區域時，隱藏大陸地圖上的圖示。",
    },
    ["Objective Icon Theme"] = {
        ["enUS"] = true,
        ["deDE"] = "Ziel-Icon-Style",
        ["esES"] = "Tema de icono de objetivo",
        ["esMX"] = "Tema de icono de objetivo",
        ["frFR"] = "Thème des icônes d'objectif",
        ["koKR"] = "목표 아이콘 테마",
        ["ptBR"] = "Tema dos ícones de objetivo",
        ["ruRU"] = "Стиль значков целей",
        ["zhCN"] = "目标图标主题",
        ["zhTW"] = "目標圖示主題",
    },
    ["Other Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Andere Icons",
        ["esES"] = "Otros iconos",
        ["esMX"] = "Otros iconos",
        ["frFR"] = "Autres icônes",
        ["koKR"] = "기타 아이콘",
        ["ptBR"] = "Outros ícones",
        ["ruRU"] = "Другие значки",
        ["zhCN"] = "其他图标",
        ["zhTW"] = "其他圖示",
    },
    ["Profession Trainers"] = {
        ["enUS"] = true,
        ["deDE"] = "Berufe-Lehrer",
        ["esES"] = "Instructores de profesión",
        ["esMX"] = "Instructores de profesión",
        ["frFR"] = "Maîtres de profession",
        ["koKR"] = "직업 훈련사",
        ["ptBR"] = "Instrutores de profissões",
        ["ruRU"] = "Учителя профессий",
        ["zhCN"] = "专业训练师",
        ["zhTW"] = "專業訓練師",
    },
    ["Change between themes for objective icons."] = {
        ["enUS"] = true,
        ["deDE"] = "Wähle den Ziel-Icon-Style.",
        ["esES"] = "Cambia entre temas para iconos de objetivo.",
        ["esMX"] = "Cambia entre temas para iconos de objetivo.",
        ["frFR"] = "Change entre les thèmes pour les icônes d'objectif.",
        ["koKR"] = "목표 아이콘의 테마 변경",
        ["ptBR"] = "Altera entre temas para ícones de objetivo.",
        ["ruRU"] = "Выбор стиля значков для целей заданий",
        ["zhCN"] = "切换目标图标主题。",
        ["zhTW"] = "切換目標圖示主題。",
    },
    ["Custom"] = {
        ["enUS"] = true,
        ["deDE"] = "Benutzerdefiniert",
        ["esES"] = "Personalizado",
        ["esMX"] = "Personalizado",
        ["frFR"] = "Personnalisé",
        ["koKR"] = "사용자 정의",
        ["ptBR"] = "Personalizado",
        ["ruRU"] = "Пользовательский",
        ["zhCN"] = "自定义",
        ["zhTW"] = "自訂",
    },
    ["Season of Discovery Runes"] = {
        ["enUS"] = true,
        ["deDE"] = "Runen der Saison der Entdeckung",
        ["esES"] = "Runas de Temporada de descubrimiento",
        ["esMX"] = "Runas de Temporada de descubrimiento",
        ["frFR"] = "Runes de Saison de Découverte",
        ["koKR"] = "발견의 시즌 룬",
        ["ptBR"] = "Runas da Temporada da Descoberta",
        ["ruRU"] = "Руны Сезона Открытий",
        ["zhCN"] = "探索赛季符文",
        ["zhTW"] = "探索賽季符文",
    },
    ["Show Runes"] = {
        ["enUS"] = true,
        ["deDE"] = "Runen anzeigen",
        ["esES"] = "Mostrar runas",
        ["esMX"] = "Mostrar runas",
        ["frFR"] = "Afficher les runes",
        ["koKR"] = "룬 표시",
        ["ptBR"] = "Mostrar runas",
        ["ruRU"] = "Показать руны",
        ["zhCN"] = "显示符文",
        ["zhTW"] = "顯示符文",
    },
    ["When this is enabled, the locations of Season of Discovery Runes and Rune quests will be shown on the map/minimap."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn aktiv, werden die Positionen der Runen der Saison der Entdeckung und Runen-Quests auf der Karte/Minikarte angezeigt.",
        ["esES"] = "Si está activado, la ubicación de las runas de la Temporada de descubrimiento y las misiones de runas se mostrará en el mapa y minimapa.",
        ["esMX"] = "Si está activado, la ubicación de las runas de la Temporada de descubrimiento y las misiones de runas se mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des emplacements des runes de la Saison de la Découverte et des quêtes de runes sur la carte et la minicarte.",
        ["koKR"] = "이 옵션이 활성화되면 발견의 시즌 룬과 룬 퀘스트의 위치가 지도/미니맵에 표시됩니다.",
        ["ptBR"] = "Se ativado, a localização das runas da Temporada de Descoberta e das missões de runas será exibida no mapa e minimapa.",
        ["ruRU"] = "Когда включено, местоположения рун Сезона Открытий и рун заданий будут отображаться на карте и миникарте",
        ["zhCN"] = "启用后，会在大地图和小地图上显示探索符文和符文任务的图标",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示探索賽季符文和符文任務。",
    },
    ["Phase 1"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Fase 1",
        ["esMX"] = "Fase 1",
        ["frFR"] = true,
        ["koKR"] = "1 단계",
        ["ptBR"] = "Fase 1",
        ["ruRU"] = "Фаза 1",
        ["zhCN"] = "第 1 阶段",
        ["zhTW"] = "階段 1",
    },
    ["Phase 2"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Fase 2",
        ["esMX"] = "Fase 2",
        ["frFR"] = true,
        ["koKR"] = "2 단계",
        ["ptBR"] = "Fase 2",
        ["ruRU"] = "Фаза 2",
        ["zhCN"] = "第 2 阶段",
        ["zhTW"] = "階段 2",
    },
    ["Phase 3"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Fase 3",
        ["esMX"] = "Fase 3",
        ["frFR"] = true,
        ["koKR"] = "3 단계",
        ["ptBR"] = "Fase 3",
        ["ruRU"] = "Фаза 3",
        ["zhCN"] = "第 3 阶段",
        ["zhTW"] = "階段 3",
    },
    ["Phase 4"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Fase 4",
        ["esMX"] = "Fase 4",
        ["frFR"] = true,
        ["koKR"] = "4 단계",
        ["ptBR"] = "Fase 4",
        ["ruRU"] = "Фаза 4",
        ["zhCN"] = "第 4 阶段",
        ["zhTW"] = "階段 4",
    },
    ["Interact objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Interaktionsziele",
        ["esES"] = "Objetivos de interacción",
        ["esMX"] = "Objetivos de interacción",
        ["frFR"] = "Objectifs d'interaction",
        ["koKR"] = "상호작용 목표",
        ["ptBR"] = "Objetivos de interação",
        ["ruRU"] = "Взаимодействие",
        ["zhCN"] = "互动目标",
        ["zhTW"] = "互動目標",
    },
    ["The icon that is displayed for quest objectives where you need to use an item or interact with an NPC"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Icon welches für Questziele angezeigt wird, für die du einen Gegenstand auf einen NPC nutzen oder mit ihm anderweitig interagieren musst",
        ["esES"] = "El icono que se muestra para objetivos de misiones donde necesitas usar un objeto o interactuar con un PNJ",
        ["esMX"] = "El icono que se muestra para objetivos de misiones donde necesitas usar un objeto o interactuar con un PNJ",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez utiliser un objet ou interagir avec un PNJ",
        ["koKR"] = "아이템을 사용하거나 NPC와 상호작용해야 하는 퀘스트 목표에 표시되는 아이콘",
        ["ptBR"] = "O ícone exibido para objetivos de missão onde você precisa usar um item ou interagir com um NPC",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно использовать предмет или взаимодействовать с NPC",
        ["zhCN"] = "用于需要使用物品或与 NPC 互动的任务目标上所显示的图标",
        ["zhTW"] = "用於需要使用物品或與 NPC 互動的任務目標上所顯示的圖示",
    },
}

for k, v in pairs(iconOptionsLocales) do
    l10n.translations[k] = v
end
