---@type QuestieDBPrivate
local _QuestieDB = QuestieLoader:ImportModule("QuestieDB").private

---@type Expansions
local Expansions = QuestieLoader:ImportModule("Expansions")
---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")


--- Tag corrections for quests for which the GetQuestTagInfo API returns the wrong values.
function _QuestieDB.InitializeQuestTagInfoCorrections()

    ---@type table<number, {[1]: QuestTagIds, [2]: string}>
    _QuestieDB.questTagCorrections = {
        [208] = Expansions.Current < Expansions.Cata and {1, l10n("Elite")} or nil,
        [373] = {81, l10n("Dungeon")},
        [644] = Expansions.Current == Expansions.Era and {1, l10n("Elite")} or nil,
        [645] = Expansions.Current == Expansions.Era and {1, l10n("Elite")} or nil,
        [646] = Expansions.Current == Expansions.Era and {1, l10n("Elite")} or nil,
        [4146] = {81, l10n("Dungeon")},
        [4601] = {81, l10n("Dungeon")},
        [4602] = {81, l10n("Dungeon")},
        [4603] = {81, l10n("Dungeon")},
        [4604] = {81, l10n("Dungeon")},
        [4605] = {81, l10n("Dungeon")},
        [4606] = {81, l10n("Dungeon")},
        [5342] = {0, ""},
        [5344] = {0, ""},
        [6846] = {41, l10n("PvP")},
        [6901] = {41, l10n("PvP")},
        [7001] = {41, l10n("PvP")},
        [7027] = {41, l10n("PvP")},
        [7161] = {41, l10n("PvP")},
        [7162] = {41, l10n("PvP")},
        [7737] = {0, ""},
        [7841] = {0, ""},
        [7842] = {0, ""},
        [7843] = {0, ""},
        [8122] = {41, l10n("PvP")},
        [8367] = {41, l10n("PvP")},
        [8371] = {41, l10n("PvP")},
        [8375] = {41, l10n("PvP")},
        [8383] = {41, l10n("PvP")},
        [8385] = {41, l10n("PvP")},
        [8386] = {41, l10n("PvP")},
        [8387] = {41, l10n("PvP")},
        [8388] = {41, l10n("PvP")},
        [8404] = {41, l10n("PvP")},
        [8405] = {41, l10n("PvP")},
        [8406] = {41, l10n("PvP")},
        [8407] = {41, l10n("PvP")},
        [8408] = {41, l10n("PvP")},
        [12170] = {41, l10n("PvP")},
        [12244] = {41, l10n("PvP")},
        [12268] = {41, l10n("PvP")},
        [12270] = {41, l10n("PvP")},
        [12280] = {41, l10n("PvP")},
        [12284] = {41, l10n("PvP")},
        [12288] = {41, l10n("PvP")},
        [12289] = {41, l10n("PvP")},
        [12296] = {41, l10n("PvP")},
        [12314] = {41, l10n("PvP")},
        [12315] = {41, l10n("PvP")},
        [12316] = {41, l10n("PvP")},
        [12317] = {41, l10n("PvP")},
        [12323] = {41, l10n("PvP")},
        [12324] = {41, l10n("PvP")},
        [12432] = {41, l10n("PvP")},
        [12433] = {41, l10n("PvP")},
        [12434] = {41, l10n("PvP")},
        [12437] = {41, l10n("PvP")},
        [12443] = {41, l10n("PvP")},
        [12446] = {41, l10n("PvP")},
        [13129] = {81, l10n("Dungeon")},
        [13199] = {41, l10n("PvP")},
        [13662] = {0, ""},
        [26452] = {41, l10n("PvP")},
        [26856] = {81, l10n("Dungeon")},
        [26858] = {81, l10n("Dungeon")},
        [26862] = {81, l10n("Dungeon")},
        [26866] = {81, l10n("Dungeon")},
        [26962] = {81, l10n("Dungeon")},
        [26967] = {81, l10n("Dungeon")},
        [27848] = {81, l10n("Dungeon")},
        [27850] = {81, l10n("Dungeon")},
        [28735] = {81, l10n("Dungeon")},
        [28737] = {81, l10n("Dungeon")},
        [28738] = {81, l10n("Dungeon")},
        [28740] = {81, l10n("Dungeon")},
        [28760] = {81, l10n("Dungeon")},
        [28814] = {81, l10n("Dungeon")},
        [28845] = {81, l10n("Dungeon")},
        [29135] = {62, l10n("Raid")},
        [29153] = {81, l10n("Dungeon")},
        [29154] = {81, l10n("Dungeon")},
        [29172] = {81, l10n("Dungeon")},
        [29173] = {81, l10n("Dungeon")},
        [29175] = {81, l10n("Dungeon")},
        [29208] = {81, l10n("Dungeon")},
        [29241] = {81, l10n("Dungeon")},
        [29242] = {81, l10n("Dungeon")},
        [29251] = {81, l10n("Dungeon")},
        [29252] = {81, l10n("Dungeon")},
        [78680] = {1, l10n("Elite")},
        [78681] = {1, l10n("Elite")},
        [78684] = {1, l10n("Elite")},
        [80098] = {1, l10n("Elite")},
        [80147] = {1, l10n("Elite")},
        [80148] = {1, l10n("Elite")},
        [80149] = {1, l10n("Elite")},
        [80150] = {1, l10n("Elite")},
        [80151] = {1, l10n("Elite")},
        [80152] = {1, l10n("Elite")},
        [90014] = {1, l10n("Elite")},
        [90054] = {1, l10n("Elite")},
        [90070] = {1, l10n("Elite")},
        [90081] = {1, l10n("Elite")},
        [90091] = {1, l10n("Elite")},
        [90094] = {1, l10n("Elite")},
        [90113] = {1, l10n("Elite")},
        [90114] = {1, l10n("Elite")},
        [90119] = {1, l10n("Elite")},
        [90122] = {1, l10n("Elite")},
        [90151] = {1, l10n("Elite")},
        [90152] = {1, l10n("Elite")},
        [90159] = {1, l10n("Elite")},
        [90163] = {1, l10n("Elite")},
        [90166] = {1, l10n("Elite")},
        [90169] = {1, l10n("Elite")},
        [90175] = {1, l10n("Elite")},
        [90190] = {1, l10n("Elite")},
        [90202] = {1, l10n("Elite")},
        [90204] = {1, l10n("Elite")},
        [90221] = {1, l10n("Elite")},
        [90225] = {1, l10n("Elite")},
        [90230] = {1, l10n("Elite")},
        [90269] = {1, l10n("Elite")},
        [90271] = {1, l10n("Elite")},
        [90281] = {1, l10n("Elite")},
        [90282] = {1, l10n("Elite")},
        [90287] = {1, l10n("Elite")},
        [90288] = {1, l10n("Elite")},
        [90289] = {1, l10n("Elite")},
        [90308] = {1, l10n("Elite")},
        [90312] = {1, l10n("Elite")},
        [90334] = {1, l10n("Elite")},
        [90335] = {1, l10n("Elite")},
        [90339] = {1, l10n("Elite")},
        [90343] = {1, l10n("Elite")},
        [90344] = {1, l10n("Elite")},
        [90353] = {1, l10n("Elite")},

        -- PvP quest manual overwrite for Anniversary servers
        [236] = {41, l10n("PvP")},
        [1657] = {41, l10n("PvP")},
        [5892] = {41, l10n("PvP")},
        [5893] = {41, l10n("PvP")},
        [6741] = {41, l10n("PvP")},
        [6781] = {41, l10n("PvP")},
        [6801] = {41, l10n("PvP")},
        [6825] = {41, l10n("PvP")},
        [6826] = {41, l10n("PvP")},
        [6827] = {41, l10n("PvP")},
        [6847] = {41, l10n("PvP")},
        [6848] = {41, l10n("PvP")},
        [6861] = {41, l10n("PvP")},
        [6862] = {41, l10n("PvP")},
        [6881] = {41, l10n("PvP")},
        [6941] = {41, l10n("PvP")},
        [6942] = {41, l10n("PvP")},
        [6943] = {41, l10n("PvP")},
        [6982] = {41, l10n("PvP")},
        [6985] = {41, l10n("PvP")},
        [7002] = {41, l10n("PvP")},
        [7026] = {41, l10n("PvP")},
        [7081] = {41, l10n("PvP")},
        [7082] = {41, l10n("PvP")},
        [7101] = {41, l10n("PvP")},
        [7102] = {41, l10n("PvP")},
        [7121] = {41, l10n("PvP")},
        [7122] = {41, l10n("PvP")},
        [7123] = {41, l10n("PvP")},
        [7124] = {41, l10n("PvP")},
        [7141] = {41, l10n("PvP")},
        [7142] = {41, l10n("PvP")},
        [7163] = {41, l10n("PvP")},
        [7164] = {41, l10n("PvP")},
        [7165] = {41, l10n("PvP")},
        [7166] = {41, l10n("PvP")},
        [7167] = {41, l10n("PvP")},
        [7168] = {41, l10n("PvP")},
        [7169] = {41, l10n("PvP")},
        [7170] = {41, l10n("PvP")},
        [7171] = {41, l10n("PvP")},
        [7172] = {41, l10n("PvP")},
        [7181] = {41, l10n("PvP")},
        [7202] = {41, l10n("PvP")},
        [7221] = {41, l10n("PvP")},
        [7222] = {41, l10n("PvP")},
        [7223] = {41, l10n("PvP")},
        [7224] = {41, l10n("PvP")},
        [7241] = {41, l10n("PvP")},
        [7261] = {41, l10n("PvP")},
        [7281] = {41, l10n("PvP")},
        [7282] = {41, l10n("PvP")},
        [7301] = {41, l10n("PvP")},
        [7302] = {41, l10n("PvP")},
        [7361] = {41, l10n("PvP")},
        [7362] = {41, l10n("PvP")},
        [7363] = {41, l10n("PvP")},
        [7364] = {41, l10n("PvP")},
        [7365] = {41, l10n("PvP")},
        [7366] = {41, l10n("PvP")},
        [7367] = {41, l10n("PvP")},
        [7368] = {41, l10n("PvP")},
        [7381] = {41, l10n("PvP")},
        [7382] = {41, l10n("PvP")},
        [7385] = {41, l10n("PvP")},
        [7386] = {41, l10n("PvP")},
        [7401] = {41, l10n("PvP")},
        [7402] = {41, l10n("PvP")},
        [7421] = {41, l10n("PvP")},
        [7422] = {41, l10n("PvP")},
        [7423] = {41, l10n("PvP")},
        [7424] = {41, l10n("PvP")},
        [7425] = {41, l10n("PvP")},
        [7426] = {41, l10n("PvP")},
        [7427] = {41, l10n("PvP")},
        [7428] = {41, l10n("PvP")},
        [7788] = {41, l10n("PvP")},
        [7789] = {41, l10n("PvP")},
        [7810] = {41, l10n("PvP")},
        [7871] = {41, l10n("PvP")},
        [7872] = {41, l10n("PvP")},
        [7873] = {41, l10n("PvP")},
        [7874] = {41, l10n("PvP")},
        [7875] = {41, l10n("PvP")},
        [7876] = {41, l10n("PvP")},
        [7886] = {41, l10n("PvP")},
        [7887] = {41, l10n("PvP")},
        [7888] = {41, l10n("PvP")},
        [7908] = {41, l10n("PvP")},
        [7921] = {41, l10n("PvP")},
        [7922] = {41, l10n("PvP")},
        [7923] = {41, l10n("PvP")},
        [7924] = {41, l10n("PvP")},
        [7925] = {41, l10n("PvP")},
        [8001] = {41, l10n("PvP")},
        [8002] = {41, l10n("PvP")},
        [8080] = {41, l10n("PvP")},
        [8081] = {41, l10n("PvP")},
        [8105] = {41, l10n("PvP")},
        [8114] = {41, l10n("PvP")},
        [8115] = {41, l10n("PvP")},
        [8120] = {41, l10n("PvP")},
        [8121] = {41, l10n("PvP")},
        [8123] = {41, l10n("PvP")},
        [8124] = {41, l10n("PvP")},
        [8154] = {41, l10n("PvP")},
        [8155] = {41, l10n("PvP")},
        [8156] = {41, l10n("PvP")},
        [8157] = {41, l10n("PvP")},
        [8158] = {41, l10n("PvP")},
        [8159] = {41, l10n("PvP")},
        [8160] = {41, l10n("PvP")},
        [8161] = {41, l10n("PvP")},
        [8162] = {41, l10n("PvP")},
        [8163] = {41, l10n("PvP")},
        [8164] = {41, l10n("PvP")},
        [8165] = {41, l10n("PvP")},
        [8166] = {41, l10n("PvP")},
        [8167] = {41, l10n("PvP")},
        [8168] = {41, l10n("PvP")},
        [8169] = {41, l10n("PvP")},
        [8170] = {41, l10n("PvP")},
        [8171] = {41, l10n("PvP")},
        [8260] = {41, l10n("PvP")},
        [8261] = {41, l10n("PvP")},
        [8262] = {41, l10n("PvP")},
        [8263] = {41, l10n("PvP")},
        [8264] = {41, l10n("PvP")},
        [8265] = {41, l10n("PvP")},
        [8266] = {41, l10n("PvP")},
        [8267] = {41, l10n("PvP")},
        [8268] = {41, l10n("PvP")},
        [8269] = {41, l10n("PvP")},
        [8271] = {41, l10n("PvP")},
        [8272] = {41, l10n("PvP")},
        [8289] = {41, l10n("PvP")},
        [8290] = {41, l10n("PvP")},
        [8291] = {41, l10n("PvP")},
        [8292] = {41, l10n("PvP")},
        [8293] = {41, l10n("PvP")},
        [8294] = {41, l10n("PvP")},
        [8295] = {41, l10n("PvP")},
        [8296] = {41, l10n("PvP")},
        [8297] = {41, l10n("PvP")},
        [8298] = {41, l10n("PvP")},
        [8299] = {41, l10n("PvP")},
        [8300] = {41, l10n("PvP")},
        [8322] = {41, l10n("PvP")},
        [8368] = {41, l10n("PvP")},
        [8369] = {41, l10n("PvP")},
        [8370] = {41, l10n("PvP")},
        [8372] = {41, l10n("PvP")},
        [8373] = {41, l10n("PvP")},
        [8374] = {41, l10n("PvP")},
        [8384] = {41, l10n("PvP")},
        [8389] = {41, l10n("PvP")},
        [8390] = {41, l10n("PvP")},
        [8391] = {41, l10n("PvP")},
        [8392] = {41, l10n("PvP")},
        [8393] = {41, l10n("PvP")},
        [8394] = {41, l10n("PvP")},
        [8395] = {41, l10n("PvP")},
        [8396] = {41, l10n("PvP")},
        [8397] = {41, l10n("PvP")},
        [8398] = {41, l10n("PvP")},
        [8399] = {41, l10n("PvP")},
        [8400] = {41, l10n("PvP")},
        [8401] = {41, l10n("PvP")},
        [8402] = {41, l10n("PvP")},
        [8403] = {41, l10n("PvP")},
        [8409] = {41, l10n("PvP")},
        [8426] = {41, l10n("PvP")},
        [8427] = {41, l10n("PvP")},
        [8428] = {41, l10n("PvP")},
        [8429] = {41, l10n("PvP")},
        [8430] = {41, l10n("PvP")},
        [8431] = {41, l10n("PvP")},
        [8432] = {41, l10n("PvP")},
        [8433] = {41, l10n("PvP")},
        [8434] = {41, l10n("PvP")},
        [8435] = {41, l10n("PvP")},
        [8436] = {41, l10n("PvP")},
        [8437] = {41, l10n("PvP")},
        [8438] = {41, l10n("PvP")},
        [8439] = {41, l10n("PvP")},
        [8440] = {41, l10n("PvP")},
        [8441] = {41, l10n("PvP")},
        [8442] = {41, l10n("PvP")},
        [8443] = {41, l10n("PvP")},
        [9419] = {41, l10n("PvP")},
        [9422] = {41, l10n("PvP")},
        [9664] = {41, l10n("PvP")},
        [9665] = {41, l10n("PvP")},

        -- MoP quests
        [30567] = {98, l10n("Scenario")},
        [31058] = {98, l10n("Scenario")},
        [31454] = {83, l10n("Legendary")},
        [31468] = {83, l10n("Legendary")},
        [31473] = {83, l10n("Legendary")},
        [31488] = {83, l10n("Legendary")},
        [31489] = {83, l10n("Legendary")},
        [31519] = {85, l10n("Heroic")},
        [31520] = {85, l10n("Heroic")},
        [31522] = {85, l10n("Heroic")},
        [31523] = {85, l10n("Heroic")},
        [31524] = {85, l10n("Heroic")},
        [31525] = {85, l10n("Heroic")},
        [31526] = {85, l10n("Heroic")},
        [31527] = {85, l10n("Heroic")},
        [31528] = {85, l10n("Heroic")},
        [31611] = {98, l10n("Scenario")},
        [31613] = {98, l10n("Scenario")},
        [31917] = {102, l10n("Account")},
        [31918] = {102, l10n("Account")},
        [31975] = {102, l10n("Account")},
        [31976] = {102, l10n("Account")},
        [31977] = {102, l10n("Account")},
        [31980] = {102, l10n("Account")},
        [31981] = {102, l10n("Account")},
        [31982] = {102, l10n("Account")},
        [31983] = {102, l10n("Account")},
        [31984] = {102, l10n("Account")},
        [31985] = {102, l10n("Account")},
        [31986] = {102, l10n("Account")},
        [31998] = {85, l10n("Heroic")},
        [32000] = {85, l10n("Heroic")},
        [32001] = {85, l10n("Heroic")},
        [32002] = {85, l10n("Heroic")},
        [32003] = {85, l10n("Heroic")},
        [32004] = {85, l10n("Heroic")},
        [32005] = {85, l10n("Heroic")},
        [32006] = {85, l10n("Heroic")},
        [32007] = {85, l10n("Heroic")},
        [91701] = {294, l10n("Celestial")},
        [91702] = {294, l10n("Celestial")},
        [91703] = {294, l10n("Celestial")},
        [91704] = {294, l10n("Celestial")},
        [91705] = {294, l10n("Celestial")},
        [91706] = {294, l10n("Celestial")},
        [91707] = {294, l10n("Celestial")},
        [91708] = {294, l10n("Celestial")},
        [91709] = {294, l10n("Celestial")},
        [91710] = {294, l10n("Celestial")},
        [91711] = {294, l10n("Celestial")},
        [91712] = {294, l10n("Celestial")},
        [91713] = {294, l10n("Celestial")},
        [91714] = {294, l10n("Celestial")},
        [91715] = {294, l10n("Celestial")},
        [91716] = {294, l10n("Celestial")},
        [91717] = {294, l10n("Celestial")},
        [91718] = {294, l10n("Celestial")},
        [91786] = {294, l10n("Celestial")},
    }
end
