local L = LibStub("AceLocale-3.0"):GetLocale("PallyPower")

PallyPower.commPrefix = "PLPWR"
C_ChatInfo.RegisterAddonMessagePrefix(PallyPower.commPrefix)

PallyPower.petsShareBaseClass = PallyPower.isBCC or PallyPower.isWrath

PALLYPOWER_MAXCLASSES = PallyPower.isWrath and 10 or 9
PALLYPOWER_MAXPERCLASS = 15
PALLYPOWER_NORMALBLESSINGDURATION = (PallyPower.isBCC or PallyPower.isWrath) and (10 * 60) or (5 * 60)
PALLYPOWER_GREATERBLESSINGDURATION = (PallyPower.isBCC or PallyPower.isWrath) and (30 * 60) or (15 * 60)
PALLYPOWER_MAXAURAS = PallyPower.isBCC and 8 or 7

PALLYPOWER_DEFAULT_VALUES = {
	profile = {
		aura = 1,
		auras = true,
		autobuff = {
			autobutton = true,
			waitforpeople = true
		},
		border = "None",
		buffscale = 0.90,
		cBuffNeedAll = {r = 1.0, g = 0.0, b = 0.0, t = 0.5},
		cBuffNeedSome = {r = 1.0, g = 1.0, b = 0.5, t = 0.5},
		cBuffNeedSpecial = {r = 0.0, g = 0.0, b = 1.0, t = 0.5},
		cBuffGood = {r = 0.0, g = 0.7, b = 0.0, t = 0.5},
		configscale = 0.90,
		display = {
			buffDuration = true,
			buttonWidth = 100,
			buttonHeight = 34,
			enableDragHandle = true,
			frameLocked = false,
			HideKeyText = false,
			HideCount = false,
			HideCountText = false,
			HideTimerText = false,
			LockBuffBars = false,
			showPlayerButtons = true,
			showClassButtons = true
		},
		enabled = true,
		layout = "Layout 2",
		mainTank = false,
		mainTankGSpellsDP = 4,
		mainTankSpellsDP = 7,
		mainTankGSpellsW = 4,
		mainTankSpellsW = 7,
		mainAssist = false,
		mainAssistGSpellsDP = 4,
		mainAssistSpellsDP = 7,
		mainAssistGSpellsW = 4,
		mainAssistSpellsW = 7,
		minimap = {
			["minimapPos"] = 190,
			["show"] = true,
		},
		ReportChannel = 0,
		rfbuff = true,
		SalvInCombat = false,
		seal = 4,
		ShowInParty = true,
		ShowPets = true,
		ShowTooltips = true,
		ShowWhenSolo = true,
		skin = "Blizzard Tooltip",
		SmartBuffs = true,
		WrathTransition = false,
	}
}

PALLYPOWER_OTHER_VALUES = {
	profile = {
		aura = 0,
		auras = false,
		autobuff = {
			autobutton = false,
			waitforpeople = false
		},
		border = "None",
		buffscale = 0.90,
		cBuffNeedAll = {r = 1.0, g = 0.0, b = 0.0, t = 0.5},
		cBuffNeedSome = {r = 1.0, g = 1.0, b = 0.5, t = 0.5},
		cBuffNeedSpecial = {r = 0.0, g = 0.0, b = 1.0, t = 0.5},
		cBuffGood = {r = 0.0, g = 0.7, b = 0.0, t = 0.5},
		configscale = 0.90,
		display = {
			buffDuration = false,
			buttonWidth = 100,
			buttonHeight = 34,
			enableDragHandle = false,
			frameLocked = false,
			HideKeyText = false,
			HideCount = false,
			HideCountText = false,
			HideTimerText = false,
			LockBuffBars = false,
			showPlayerButtons = false,
			showClassButtons = false
		},
		enabled = true,
		layout = "Layout 2",
		mainTank = false,
		mainTankGSpellsDP = 0,
		mainTankSpellsDP = 0,
		mainTankGSpellsW = 0,
		mainTankSpellsW = 0,
		mainAssist = false,
		mainAssistGSpellsDP = 0,
		mainAssistSpellsDP = 0,
		mainAssistGSpellsW = 0,
		mainAssistSpellsW = 0,
		minimap = {
			["minimapPos"] = 190,
			["show"] = true,
		},
		ReportChannel = 0,
		rfbuff = false,
		SalvInCombat = false,
		seal = 0,
		ShowInParty = true,
		ShowPets = true,
		ShowTooltips = true,
		ShowWhenSolo = true,
		skin = "Blizzard Tooltip",
		SmartBuffs = false,
		WrathTransition = false,
	}
}

PallyPower.BuffBarTitle = "Pally Buffs (%d)"

PallyPower.ClassID = PallyPower.isWrath and {
	[1] = "WARRIOR",
	[2] = "ROGUE",
	[3] = "PRIEST",
	[4] = "DRUID",
	[5] = "PALADIN",
	[6] = "HUNTER",
	[7] = "MAGE",
	[8] = "WARLOCK",
	[9] = "SHAMAN",
	[10] = "DEATHKNIGHT",
} or PallyPower.isBCC and {
	[1] = "WARRIOR",
	[2] = "ROGUE",
	[3] = "PRIEST",
	[4] = "DRUID",
	[5] = "PALADIN",
	[6] = "HUNTER",
	[7] = "MAGE",
	[8] = "WARLOCK",
	[9] = "SHAMAN",
} or {
	[1] = "WARRIOR",
	[2] = "ROGUE",
	[3] = "PRIEST",
	[4] = "DRUID",
	[5] = "PALADIN",
	[6] = "HUNTER",
	[7] = "MAGE",
	[8] = "WARLOCK",
	[9] = "PET"
}

PallyPower.ClassToID = PallyPower.isWrath and {
	["WARRIOR"] = 1,
	["ROGUE"] = 2,
	["PRIEST"] = 3,
	["DRUID"] = 4,
	["PALADIN"] = 5,
	["HUNTER"] = 6,
	["MAGE"] = 7,
	["WARLOCK"] = 8,
	["SHAMAN"] = 9,
	["DEATHKNIGHT"] = 10,
} or PallyPower.isBCC and {
	["WARRIOR"] = 1,
	["ROGUE"] = 2,
	["PRIEST"] = 3,
	["DRUID"] = 4,
	["PALADIN"] = 5,
	["HUNTER"] = 6,
	["MAGE"] = 7,
	["WARLOCK"] = 8,
	["SHAMAN"] = 9,
} or {
	["WARRIOR"] = 1,
	["ROGUE"] = 2,
	["PRIEST"] = 3,
	["DRUID"] = 4,
	["PALADIN"] = 5,
	["HUNTER"] = 6,
	["MAGE"] = 7,
	["WARLOCK"] = 8,
	["PET"] = 9
}

PallyPower.ClassIcons = PallyPower.isWrath and {
	[1] = "Interface\\Icons\\ClassIcon_Warrior",
	[2] = "Interface\\Icons\\ClassIcon_Rogue",
	[3] = "Interface\\Icons\\ClassIcon_Priest",
	[4] = "Interface\\Icons\\ClassIcon_Druid",
	[5] = "Interface\\Icons\\ClassIcon_Paladin",
	[6] = "Interface\\Icons\\ClassIcon_Hunter",
	[7] = "Interface\\Icons\\ClassIcon_Mage",
	[8] = "Interface\\Icons\\ClassIcon_Warlock",
	[9] = "Interface\\Icons\\ClassIcon_Shaman",
	[10] = "Interface\\Icons\\Spell_deathknight_classicon",
} or PallyPower.isBCC and {
	[1] = "Interface\\Icons\\ClassIcon_Warrior",
	[2] = "Interface\\Icons\\ClassIcon_Rogue",
	[3] = "Interface\\Icons\\ClassIcon_Priest",
	[4] = "Interface\\Icons\\ClassIcon_Druid",
	[5] = "Interface\\Icons\\ClassIcon_Paladin",
	[6] = "Interface\\Icons\\ClassIcon_Hunter",
	[7] = "Interface\\Icons\\ClassIcon_Mage",
	[8] = "Interface\\Icons\\ClassIcon_Warlock",
	[9] = "Interface\\Icons\\ClassIcon_Shaman",
} or {
	[1] = "Interface\\Icons\\ClassIcon_Warrior",
	[2] = "Interface\\Icons\\ClassIcon_Rogue",
	[3] = "Interface\\Icons\\ClassIcon_Priest",
	[4] = "Interface\\Icons\\ClassIcon_Druid",
	[5] = "Interface\\Icons\\ClassIcon_Paladin",
	[6] = "Interface\\Icons\\ClassIcon_Hunter",
	[7] = "Interface\\Icons\\ClassIcon_Mage",
	[8] = "Interface\\Icons\\ClassIcon_Warlock",
	[9] = "Interface\\Icons\\Ability_Mount_JungleTiger"
}

PallyPower.BlessingIcons = PallyPower.isWrath and {
	[-1] = "",
	[1] = "Interface\\Icons\\Spell_Holy_GreaterBlessingofWisdom",
	[2] = "Interface\\Icons\\Spell_Holy_GreaterBlessingofKings",
	[3] = "Interface\\Icons\\Spell_Magic_GreaterBlessingofKings",
	[4] = "Interface\\Icons\\Spell_Holy_GreaterBlessingofSanctuary"
} or {
	[-1] = "",
	[1] = "Interface\\Icons\\Spell_Holy_GreaterBlessingofWisdom",
	[2] = "Interface\\Icons\\Spell_Holy_GreaterBlessingofKings",
	[3] = "Interface\\Icons\\Spell_Magic_GreaterBlessingofKings",
	[4] = "Interface\\Icons\\Spell_Holy_GreaterBlessingofSalvation",
	[5] = "Interface\\Icons\\Spell_Holy_GreaterBlessingofLight",
	[6] = "Interface\\Icons\\Spell_Holy_GreaterBlessingofSanctuary",
	[7] = "Interface\\Icons\\Spell_Holy_SealOfSacrifice"
}

PallyPower.NormalBlessingIcons = PallyPower.isWrath and {
	[-1] = "",
	[1] = "Interface\\Icons\\Spell_Holy_SealOfWisdom",
	[2] = "Interface\\Icons\\Spell_Holy_FistOfJustice",
	[3] = "Interface\\Icons\\Spell_Magic_MageArmor",
	[4] = "Interface\\Icons\\Spell_Nature_LightningShield",
} or {
	[-1] = "",
	[1] = "Interface\\Icons\\Spell_Holy_SealOfWisdom",
	[2] = "Interface\\Icons\\Spell_Holy_FistOfJustice",
	[3] = "Interface\\Icons\\Spell_Magic_MageArmor",
	[4] = "Interface\\Icons\\Spell_Holy_SealOfSalvation",
	[5] = "Interface\\Icons\\Spell_Holy_PrayerOfHealing02",
	[6] = "Interface\\Icons\\Spell_Nature_LightningShield",
	[7] = "Interface\\Icons\\Spell_Holy_SealOfSacrifice"
}

PallyPower.AuraIcons = PallyPower.isWrath and {
	[-1] = "",
	[1] = "Interface\\Icons\\Spell_Holy_DevotionAura",
	[2] = "Interface\\Icons\\Spell_Holy_AuraOfLight",
	[3] = "Interface\\Icons\\Spell_Holy_MindSooth",
	[4] = "Interface\\Icons\\Spell_Shadow_SealOfKings",
	[5] = "Interface\\Icons\\Spell_Frost_WizardMark",
	[6] = "Interface\\Icons\\Spell_Fire_SealOfFire",
	[7] = "Interface\\Icons\\Spell_Holy_CrusaderAura"
} or {
	[-1] = "",
	[1] = "Interface\\Icons\\Spell_Holy_DevotionAura",
	[2] = "Interface\\Icons\\Spell_Holy_AuraOfLight",
	[3] = "Interface\\Icons\\Spell_Holy_MindSooth",
	[4] = "Interface\\Icons\\Spell_Shadow_SealOfKings",
	[5] = "Interface\\Icons\\Spell_Frost_WizardMark",
	[6] = "Interface\\Icons\\Spell_Fire_SealOfFire",
	[7] = "Interface\\Icons\\Spell_Holy_MindVision",
	[8] = "Interface\\Icons\\Spell_Holy_CrusaderAura"
}

-- XML Aliases
do
	local version = string.trim(GetAddOnMetadata("PallyPower", "Version"))
	if version == ("@project-".."version@") then -- split string so it doesn't get replaced by packager
		version = "Development version"
	end
	PALLYPOWER_NAME = "  " .. L["PallyPower Classic"] .. " (" .. version .. ")"
end
PALLYPOWER_KEYCAT = L["PallyPower Classic"]
PALLYPOWER_CLEAR = L["Clear"]
PALLYPOWER_CLEAR_DESC = L["PP_CLEAR_TOOLTIP"]
PALLYPOWER_REFRESH = L["Refresh"]
PALLYPOWER_REFRESH_DESC = L["PP_REFRESH_TOOLTIP"]
PALLYPOWER_AUTOASSIGN = L["Auto-Assign"]
PALLYPOWER_AUTOASSIGN_DESC = L["AUTO_ASSIGN_TOOLTIP"]
PALLYPOWER_PRESET = L["Preset"]
PALLYPOWER_PRESET_DESC = L["PRESET_TOOLTIP"]
PALLYPOWER_REPORT = L["Blessings Report"]
PALLYPOWER_REPORT_DESC = L["BLESSING_REPORT_TOOLTIP"]
PALLYPOWER_FREEASSIGN = L["Free Assignment"]
PALLYPOWER_FREEASSIGN_DESC = L["FREE_ASSIGN_TOOLTIP"]
PALLYPOWER_OPTIONS = L["Options"]
PALLYPOWER_OPTIONS_DESC = L["OPTIONS_BUTTON_TOOLTIP"]

PallyPower.CONFIG_DRAGHANDLE = L["DRAGHANDLE_TOOLTIP"]
PallyPower.CONFIG_RESIZEGRIP = L["RESIZEGRIP_TOOLTIP"]

BINDING_NAME_AUTOKEY1 = L["Auto Normal Blessing Key"]
BINDING_NAME_AUTOKEY2 = L["Auto Greater Blessing Key"]

-------------------------------------------------------------------
-- Spell Settings
-------------------------------------------------------------------
PallyPower.Spells = PallyPower.isWrath and {
	[0] = "",
	[1] = GetSpellInfo(19742),	-- Blessing of Wisdom
	[2] = GetSpellInfo(19740),	-- Blessing of Might
	[3] = GetSpellInfo(20217),	-- Blessing of Kings
	[4] = GetSpellInfo(20911),	-- Blessing of Sanctuary
} or {
	[0] = "",
	[1] = GetSpellInfo(19742),	-- Blessing of Wisdom
	[2] = GetSpellInfo(19740),	-- Blessing of Might
	[3] = GetSpellInfo(20217),	-- Blessing of Kings
	[4] = GetSpellInfo(1038),	-- Blessing of Salvation
	[5] = GetSpellInfo(19977),	-- Blessing of Light
	[6] = GetSpellInfo(20911),	-- Blessing of Sanctuary
	[7] = GetSpellInfo(6940),	-- Blessing of Sacrifice
}

PallyPower.GSpells = PallyPower.isWrath and {
	[0] = "",
	[1] = GetSpellInfo(25894),	-- Greater Blessing of Wisdom (R1:54, R2:60)
	[2] = GetSpellInfo(25782),	-- Greater Blessing of Might (R1:52, R2:60)
	[3] = GetSpellInfo(25898),	-- Greater Blessing of Kings
	[4] = GetSpellInfo(25899),	-- Greater Blessing of Sanctuary
} or {
	[0] = "",
	[1] = GetSpellInfo(25894),	-- Greater Blessing of Wisdom (R1:54, R2:60)
	[2] = GetSpellInfo(25782),	-- Greater Blessing of Might (R1:52, R2:60)
	[3] = GetSpellInfo(25898),	-- Greater Blessing of Kings
	[4] = GetSpellInfo(25895),	-- Greater Blessing of Salvation
	[5] = GetSpellInfo(25890),	-- Greater Blessing of Light
	[6] = GetSpellInfo(25899),	-- Greater Blessing of Sanctuary
}

-- Spell Ranks
PallyPower.NormalBuffs = PallyPower.isWrath and {
	[1] = {{67, 48936}, {61, 48935}, {55, 27142}, {50, 25290}, {44, 19854}, {34, 19853}, {24, 19852}, {14, 19850}, {4, 19742}},
	[2] = {{69, 48932}, {63, 48931}, {60, 27140}, {50, 25291}, {42, 19838}, {32, 19837}, {22, 19836}, {12, 19835}, {4, 19834}, {0, 19740}},
	[3] = {{10, 20217}},
	[4] = {{20, 20911}},
} or {
	[1] = {{55, 27142}, {50, 25290}, {44, 19854}, {34, 19853}, {24, 19852}, {14, 19850}, {4, 19742}},
	[2] = {{60, 27140}, {50, 25291}, {42, 19838}, {32, 19837}, {22, 19836}, {12, 19835}, {4, 19834}, {0, 19740}},
	[3] = {{10, 20217}},
	[4] = {{16, 1038}},
	[5] = {{59, 27144}, {50, 19979}, {40, 19978}, {30, 19977}},
	[6] = {{60, 27168}, {50, 20914}, {40, 20913}, {30, 20912}, {20, 20911}},
	[7] = {{60, 27148}, {52, 27147}, {44, 20729}, {36, 6940}},
}

PallyPower.GreaterBuffs = PallyPower.isWrath and {
	[1] = {{67, 48938}, {61, 48937}, {55, 27143}, {50, 25918}, {44, 25894}},
	[2] = {{69, 48934}, {63, 48933}, {60, 27141}, {50, 25916}, {42, 25782}},
	[3] = {{50, 25898}},
	[4] = {{50, 25899}},
} or {
	[1] = {{55, 27143}, {50, 25918}, {44, 25894}},
	[2] = {{60, 27141}, {50, 25916}, {42, 25782}},
	[3] = {{50, 25898}},
	[4] = {{50, 25895}},
	[5] = {{59, 27145}, {50, 25890}},
	[6] = {{60, 27169}, {50, 25899}},
}

PallyPower.RFSpell = GetSpellInfo(25780)	-- Righteous Fury
PallyPower.HLSpell = GetSpellInfo(635)		-- Holy Light

PallyPower.Seals = PallyPower.isWrath and {
	[0] = "",
	[1] = GetSpellInfo(20164),		-- Seal of Justice
	[2] = GetSpellInfo(20165),		-- Seal of Light
	[3] = GetSpellInfo(20166),		-- Seal of Wisdom
	[4] = GetSpellInfo(21084),		-- Seal of Righteousness
	[5] = GetSpellInfo(20375),		-- Seal of Command
	[6] = GetSpellInfo(31801),		-- Seal of Vengeance (Alliance)
	[7] = GetSpellInfo(31892),		-- Seal of Blood (Horde)
	[8] = GetSpellInfo(348700),		-- Seal of the Martyr (Alliance)
	[9] = GetSpellInfo(348704),		-- Seal of Corruption (Horde)
} or {
	[0] = "",
	[1] = GetSpellInfo(20164),		-- Seal of Justice
	[2] = GetSpellInfo(20165),		-- Seal of Light
	[3] = GetSpellInfo(20166),		-- Seal of Wisdom
	[4] = GetSpellInfo(21084),		-- Seal of Righteousness
	[5] = GetSpellInfo(21082),		-- Seal of the Crusader
	[6] = GetSpellInfo(20375),		-- Seal of Command
	[7] = GetSpellInfo(31801),		-- Seal of Vengeance (Alliance)
	[8] = GetSpellInfo(31892),		-- Seal of Blood (Horde)
	[9] = GetSpellInfo(348700),		-- Seal of the Martyr (Alliance)
	[10] = GetSpellInfo(348704),	-- Seal of Corruption (Horde)
}

PallyPower.Auras = PallyPower.isWrath and {
	[0] = "",
	[1] = GetSpellInfo(465),	-- Devotion Aura
	[2] = GetSpellInfo(7294),	-- Retribution Aura
	[3] = GetSpellInfo(19746),	-- Concentration Aura
	[4] = GetSpellInfo(19876),	-- Shadow Resistance Aura
	[5] = GetSpellInfo(19888),	-- Frost Resistance Aura
	[6] = GetSpellInfo(19891),	-- Fire Resistance Aura
	[7] = GetSpellInfo(32223),	-- Crusader Aura
} or {
	[0] = "",
	[1] = GetSpellInfo(465),	-- Devotion Aura
	[2] = GetSpellInfo(7294),	-- Retribution Aura
	[3] = GetSpellInfo(19746),	-- Concentration Aura
	[4] = GetSpellInfo(19876),	-- Shadow Resistance Aura
	[5] = GetSpellInfo(19888),	-- Frost Resistance Aura
	[6] = GetSpellInfo(19891),	-- Fire Resistance Aura
	[7] = GetSpellInfo(20218),	-- Sanctity Aura
	[8] = GetSpellInfo(32223),	-- Crusader Aura
}

PallyPower.Cooldowns = {
	[1] = {633, 2800, 10310, 27154, 48788},	-- Lay On Hands
	[2] = {19752},							-- Divine Intervention
}

-------------------------------------------------------------------
-- Interface Settings
-------------------------------------------------------------------
PallyPower.Skins = {
	["None"]			= "Interface\\Tooltips\\UI-Tooltip-Background",
	["Banto"]			= "Interface\\AddOns\\PallyPower\\Skins\\Banto",
	["BantoBarReverse"]	= "Interface\\AddOns\\PallyPower\\Skins\\BantoBarReverse",
	["Glaze"]			= "Interface\\AddOns\\PallyPower\\Skins\\Glaze",
	["Gloss"]			= "Interface\\AddOns\\PallyPower\\Skins\\Gloss",
	["Healbot"]			= "Interface\\AddOns\\PallyPower\\Skins\\Healbot",
	["oCB"]				= "Interface\\AddOns\\PallyPower\\Skins\\oCB",
	["Smooth"]			= "Interface\\AddOns\\PallyPower\\Skins\\Smooth"
}

PallyPower.Edge = "Interface\\Tooltips\\UI-Tooltip-Border"

-- Buff templates
-- Table [1] is for a single Paladin but not all Paladins have Kings and if it's not there it defaults to the next prio so something gets assigned so on and so forth down the list of tables.

-- Paladin Battleground Templates
PallyPower.BattleGroundTemplates = PallyPower.isWrath and {
	[1] = {
		[1] = {3, 2, 4},
		[2] = {3, 2, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {3, 2, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {3, 2, 4},
		[11] = {3, 2, 1, 4},
	},
	[2] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
	[3] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
	[4] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
} or {
	[1] = {
		[1] = {3, 2, 6, 5},
		[2] = {2, 3, 6, 5},
		[3] = {3, 1, 6, 5},
		[4] = {3, 2, 6, 1, 5},
		[5] = {3, 2, 6, 1, 5},
		[6] = {3, 1, 6, 5},
		[7] = {3, 1, 6, 5},
		[8] = {3, 1, 6, 5},
		[9] = {3, 2, 6, 1, 5},
		[10] = {3, 2, 6, 5},
		[11] = {3, 2, 6, 5},
	},
	[2] = {
		[1] = {3, 2, 6, 5},
		[2] = {3, 2, 6, 5},
		[3] = {3, 1, 6, 5},
		[4] = {3, 2, 6, 1, 5},
		[5] = {3, 2, 6, 1, 5},
		[6] = {3, 1, 6, 5},
		[7] = {3, 1, 6, 5},
		[8] = {3, 1, 6, 5},
		[9] = {3, 2, 6, 1, 5},
		[10] = {3, 2, 6, 5},
		[11] = {3, 2, 6, 5},
	},
	[3] = {
		[1] = {3, 2, 6, 5},
		[2] = {3, 2, 6, 5},
		[3] = {3, 1, 6, 5},
		[4] = {3, 2, 6, 1, 5},
		[5] = {3, 2, 6, 1, 5},
		[6] = {3, 1, 6, 5},
		[7] = {3, 1, 6, 5},
		[8] = {3, 1, 6, 5},
		[9] = {3, 2, 6, 1, 5},
		[10] = {3, 2, 6, 5},
		[11] = {3, 2, 6, 5},
	},
	[4] = {
		[1] = {3, 2, 6, 5},
		[2] = {3, 2, 6, 5},
		[3] = {3, 1, 6, 5},
		[4] = {3, 2, 6, 1, 5},
		[5] = {3, 2, 6, 1, 5},
		[6] = {3, 1, 6, 5},
		[7] = {3, 1, 6, 5},
		[8] = {3, 1, 6, 5},
		[9] = {3, 2, 6, 1, 5},
		[10] = {3, 2, 6, 5},
		[11] = {3, 2, 6, 5},
	},
	[5] = {
		[1] = {3, 2, 6, 5},
		[2] = {3, 2, 6, 5},
		[3] = {3, 1, 6, 5},
		[4] = {3, 2, 6, 1, 5},
		[5] = {3, 2, 6, 1, 5},
		[6] = {3, 1, 6, 5},
		[7] = {3, 1, 6, 5},
		[8] = {3, 1, 6, 5},
		[9] = {3, 2, 6, 1, 5},
		[10] = {3, 2, 6, 5},
		[11] = {3, 2, 6, 5},
	},
	[6] = {
		[1] = {3, 2, 0, 6, 5},
		[2] = {3, 2, 0, 6, 5},
		[3] = {3, 0, 1, 6, 5},
		[4] = {3, 2, 1, 6, 5},
		[5] = {3, 2, 1, 6, 5},
		[6] = {3, 0, 1, 6, 5},
		[7] = {3, 0, 1, 6, 5},
		[8] = {3, 0, 1, 6, 5},
		[9] = {3, 2, 1, 6, 5},
		[10] = {3, 2, 0, 6, 5},
		[11] = {3, 2, 0, 6, 5},
	},
}

-- Paladin Raid Templates
PallyPower.RaidTemplates = PallyPower.isWrath and {
	[1] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
	[2] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
	[3] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
	[4] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
} or {
	[1] = {
		[1] = {4, 3, 2},
		[2] = {4, 2, 3},
		[3] = {4, 3, 1},
		[4] = {4, 3, 1, 2},
		[5] = {4, 3, 1, 2},
		[6] = {4, 3, 1},
		[7] = {4, 3, 1},
		[8] = {4, 3, 1},
		[9] = {4, 3, 1, 2},
		[10] = {4, 3, 2},
		[11] = {4, 3, 2},
	},
	[2] = {
		[1] = {4, 3, 2, 6, 5},
		[2] = {4, 2, 3, 6, 5},
		[3] = {4, 3, 1, 6, 5},
		[4] = {4, 3, 1, 2, 6, 5},
		[5] = {4, 3, 1, 2, 6, 5},
		[6] = {4, 3, 1, 6, 5},
		[7] = {4, 3, 1, 6, 5},
		[8] = {4, 3, 1, 6, 5},
		[9] = {4, 3, 1, 2, 6, 5},
		[10] = {4, 3, 2, 6, 5},
		[11] = {4, 3, 2, 6, 5},
	},
	[3] = {
		[1] = {4, 3, 2, 6, 5},
		[2] = {4, 3, 2, 6, 5},
		[3] = {4, 3, 1, 6, 5},
		[4] = {4, 3, 1, 2, 6, 5},
		[5] = {4, 3, 1, 2, 6, 5},
		[6] = {4, 3, 1, 6, 5},
		[7] = {4, 3, 1, 6, 5},
		[8] = {4, 3, 1, 6, 5},
		[9] = {4, 3, 1, 2, 6, 5},
		[10] = {4, 3, 2, 6, 5},
		[11] = {4, 3, 2, 6, 5},
	},
	[4] = {
		[1] = {6, 4, 3, 2, 5},
		[2] = {6, 4, 3, 2, 5},
		[3] = {6, 4, 3, 1, 5},
		[4] = {6, 4, 3, 1, 2, 5},
		[5] = {6, 4, 3, 1, 2, 5},
		[6] = {6, 4, 3, 1, 5},
		[7] = {6, 4, 3, 1, 5},
		[8] = {6, 4, 3, 1, 5},
		[9] = {6, 4, 3, 1, 2, 5},
		[10] = {6, 4, 3, 2, 5},
		[11] = {6, 4, 3, 2, 5},
	},
	[5] = {
		[1] = {6, 4, 3, 2, 5},
		[2] = {6, 4, 3, 2, 5},
		[3] = {6, 4, 3, 1, 5},
		[4] = {6, 4, 3, 1, 2, 5},
		[5] = {6, 4, 3, 1, 2, 5},
		[6] = {6, 4, 3, 1, 5},
		[7] = {6, 4, 3, 1, 5},
		[8] = {6, 4, 3, 1, 5},
		[9] = {6, 4, 3, 1, 2, 5},
		[10] = {6, 4, 3, 2, 5},
		[11] = {6, 4, 3, 2, 5},
	},
	[6] = {
		[1] = {6, 4, 3, 2, 0, 5},
		[2] = {6, 4, 3, 2, 0, 5},
		[3] = {6, 4, 3, 0, 1, 5},
		[4] = {6, 4, 3, 2, 1, 5},
		[5] = {6, 4, 3, 2, 1, 5},
		[6] = {6, 4, 3, 0, 1, 5},
		[7] = {6, 4, 3, 0, 1, 5},
		[8] = {6, 4, 3, 0, 1, 5},
		[9] = {6, 4, 3, 2, 1, 5},
		[10] = {6, 4, 3, 2, 0, 5},
		[11] = {6, 4, 3, 2, 0, 5},
	},
}
-- Normal Paladin Templates
PallyPower.Templates = PallyPower.isWrath and {
	[1] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
	[2] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
	[3] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
	[4] = {
		[1] = {2, 3, 4},
		[2] = {2, 3, 4},
		[3] = {3, 1, 4},
		[4] = {3, 2, 1, 4},
		[5] = {3, 2, 1, 4},
		[6] = {2, 3, 1, 4},
		[7] = {3, 1, 4},
		[8] = {3, 1, 4},
		[9] = {3, 2, 1, 4},
		[10] = {2, 3, 4},
		[11] = {2, 3, 1, 4},
	},
} or {
	[1] = {
		[1] = {3, 2, 4, 5},
		[2] = {2, 3, 4, 5},
		[3] = {3, 1, 4, 5},
		[4] = {3, 1, 4, 2, 5},
		[5] = {3, 1, 4, 2, 5},
		[6] = {3, 1, 4, 5},
		[7] = {3, 1, 4, 5},
		[8] = {3, 1, 4, 5},
		[9] = {3, 1, 4, 2, 5},
		[10] = {3, 2, 4, 1, 5},
		[11] = {3, 2, 4, 1, 5},
	},
	[2] = {
		[1] = {3, 2, 4, 5},
		[2] = {3, 2, 4, 5},
		[3] = {3, 1, 4, 5},
		[4] = {3, 1, 4, 2, 5},
		[5] = {3, 1, 4, 2, 5},
		[6] = {3, 1, 4, 5},
		[7] = {3, 1, 4, 5},
		[8] = {3, 1, 4, 5},
		[9] = {3, 1, 4, 2, 5},
		[10] = {3, 2, 4, 1, 5},
		[11] = {3, 2, 4, 1, 5},
	},
	[3] = {
		[1] = {3, 2, 4, 5},
		[2] = {3, 2, 4, 5},
		[3] = {3, 1, 4, 5},
		[4] = {3, 1, 4, 2, 5},
		[5] = {3, 1, 4, 2, 5},
		[6] = {3, 1, 4, 5},
		[7] = {3, 1, 4, 5},
		[8] = {3, 1, 4, 5},
		[9] = {3, 1, 4, 2, 5},
		[10] = {3, 2, 4, 1, 5},
		[11] = {3, 2, 4, 1, 5},
	},
	[4] = {
		[1] = {6, 4, 3, 2, 5},
		[2] = {6, 4, 3, 2, 5},
		[3] = {6, 4, 3, 1, 5},
		[4] = {6, 4, 3, 1, 2, 5},
		[5] = {6, 4, 3, 1, 2, 5},
		[6] = {6, 4, 3, 1, 5},
		[7] = {6, 4, 3, 1, 5},
		[8] = {6, 4, 3, 1, 5},
		[9] = {6, 4, 3, 1, 2, 5},
		[10] = {6, 4, 3, 2, 1, 5},
		[11] = {6, 4, 3, 2, 1, 5},
	},
	[5] = {
		[1] = {6, 4, 3, 2, 5},
		[2] = {6, 4, 3, 2, 5},
		[3] = {6, 4, 3, 1, 5},
		[4] = {6, 4, 3, 1, 2, 5},
		[5] = {6, 4, 3, 1, 2, 5},
		[6] = {6, 4, 3, 1, 5},
		[7] = {6, 4, 3, 1, 5},
		[8] = {6, 4, 3, 1, 5},
		[9] = {6, 4, 3, 1, 2, 5},
		[10] = {6, 4, 3, 2, 1, 5},
		[11] = {6, 4, 3, 2, 1, 5},
	},
	[6] = {
		[1] = {6, 4, 3, 2, 0, 5},
		[2] = {6, 4, 3, 2, 0, 5},
		[3] = {6, 4, 3, 0, 1, 5},
		[4] = {6, 4, 3, 2, 1, 5},
		[5] = {6, 4, 3, 2, 1, 5},
		[6] = {6, 4, 3, 0, 1, 5},
		[7] = {6, 4, 3, 0, 1, 5},
		[8] = {6, 4, 3, 0, 1, 5},
		[9] = {6, 4, 3, 2, 1, 5},
		[10] = {6, 4, 3, 2, 0, 5},
		[11] = {6, 4, 3, 2, 0, 5},
	},
}

-- Layouts
PallyPower.Layouts = {
	-- Vertical Down | Right
	["Layout 1"] = {
		c = {
			[1] = {
				x = 0,
				y = 0,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
			[2] = {
				x = 0,
				y = -1,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
			[3] = {
				x = 0,
				y = -2,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
			[4] = {
				x = 0,
				y = -3,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
			[5] = {
				x = 0,
				y = -4,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
			[6] = {
				x = 0,
				y = -5,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
			[7] = {
				x = 0,
				y = -6,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
			[8] = {
				x = 0,
				y = -7,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
			[9] = {
				x = 0,
				y = -8,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
			[10] = {
				x = 0,
				y = -9,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
			[11] = {
				x = 0,
				y = -10,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = -1},
					[3] = {x = 1, y = -2},
					[4] = {x = 1, y = -3},
					[5] = {x = 1, y = -4},
					[6] = {x = 1, y = -5},
					[7] = {x = 1, y = -6},
					[8] = {x = 1, y = -7},
					[9] = {x = 1, y = -8},
					[10] = {x = 1, y = -9},
					[11] = {x = 1, y = -10},
					[12] = {x = 1, y = -11},
					[13] = {x = 1, y = -12},
					[14] = {x = 1, y = -13},
					[15] = {x = 1, y = -14},
				},
			},
		},
		ab = {x = 0, y = 1},
		rf = {x = 0, y = 2},
		rfd = {x = 0, y = 1},
		au = {x = 0, y = 3},
		aud1 = {x = 0, y = 2},
		aud2 = {x = 0, y = 1},
	},
	-- Vertical Down | Left
	["Layout 2"] = {
		c = {
			[1] = {
				x = 0,
				y = 0,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
			[2] = {
				x = 0,
				y = -1,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
			[3] = {
				x = 0,
				y = -2,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
			[4] = {
				x = 0,
				y = -3,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
			[5] = {
				x = 0,
				y = -4,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
			[6] = {
				x = 0,
				y = -5,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
			[7] = {
				x = 0,
				y = -6,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
			[8] = {
				x = 0,
				y = -7,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
			[9] = {
				x = 0,
				y = -8,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
			[10] = {
				x = 0,
				y = -9,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
			[11] = {
				x = 0,
				y = -10,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = -1},
					[3] = {x = -1, y = -2},
					[4] = {x = -1, y = -3},
					[5] = {x = -1, y = -4},
					[6] = {x = -1, y = -5},
					[7] = {x = -1, y = -6},
					[8] = {x = -1, y = -7},
					[9] = {x = -1, y = -8},
					[10] = {x = -1, y = -9},
					[11] = {x = -1, y = -10},
					[12] = {x = -1, y = -11},
					[13] = {x = -1, y = -12},
					[14] = {x = -1, y = -13},
					[15] = {x = -1, y = -14},
				},
			},
		},
		ab = {x = 0, y = 1},
		rf = {x = 0, y = 2},
		rfd = {x = 0, y = 1},
		au = {x = 0, y = 3},
		aud1 = {x = 0, y = 2},
		aud2 = {x = 0, y = 1},
	},
	-- Vertical Up | Right
	["Layout 3"] = {
		c = {
			[1] = {
				x = 0,
				y = 1,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
			[2] = {
				x = 0,
				y = 2,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
			[3] = {
				x = 0,
				y = 3,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
			[4] = {
				x = 0,
				y = 4,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
			[5] = {
				x = 0,
				y = 5,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
			[6] = {
				x = 0,
				y = 6,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
			[7] = {
				x = 0,
				y = 7,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
			[8] = {
				x = 0,
				y = 8,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
			[9] = {
				x = 0,
				y = 9,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
			[10] = {
				x = 0,
				y = 10,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
			[11] = {
				x = 0,
				y = 11,
				p = {
					[1] = {x = 1, y = 0},
					[2] = {x = 1, y = 1},
					[3] = {x = 1, y = 2},
					[4] = {x = 1, y = 3},
					[5] = {x = 1, y = 4},
					[6] = {x = 1, y = 5},
					[7] = {x = 1, y = 6},
					[8] = {x = 1, y = 7},
					[9] = {x = 1, y = 8},
					[10] = {x = 1, y = 9},
					[11] = {x = 1, y = 10},
					[12] = {x = 1, y = 11},
					[13] = {x = 1, y = 12},
					[14] = {x = 1, y = 13},
					[15] = {x = 1, y = 14},
				},
			},
		},
		ab = {x = 0, y = 0},
		rf = {x = 0, y = -1},
		rfd = {x = 0, y = 0},
		au = {x = 0, y = -2},
		aud1 = {x = 0, y = -1},
		aud2 = {x = 0, y = 0},
	},
	-- Vertical Up | Left
	["Layout 4"] = {
		c = {
			[1] = {
				x = 0,
				y = 1,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
			[2] = {
				x = 0,
				y = 2,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
			[3] = {
				x = 0,
				y = 3,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
			[4] = {
				x = 0,
				y = 4,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
			[5] = {
				x = 0,
				y = 5,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
			[6] = {
				x = 0,
				y = 6,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
			[7] = {
				x = 0,
				y = 7,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
			[8] = {
				x = 0,
				y = 8,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
			[9] = {
				x = 0,
				y = 9,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
			[10] = {
				x = 0,
				y = 10,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
			[11] = {
				x = 0,
				y = 11,
				p = {
					[1] = {x = -1, y = 0},
					[2] = {x = -1, y = 1},
					[3] = {x = -1, y = 2},
					[4] = {x = -1, y = 3},
					[5] = {x = -1, y = 4},
					[6] = {x = -1, y = 5},
					[7] = {x = -1, y = 6},
					[8] = {x = -1, y = 7},
					[9] = {x = -1, y = 8},
					[10] = {x = -1, y = 9},
					[11] = {x = -1, y = 10},
					[12] = {x = -1, y = 11},
					[13] = {x = -1, y = 12},
					[14] = {x = -1, y = 13},
					[15] = {x = -1, y = 14},
				},
			},
		},
		ab = {x = 0, y = 0},
		rf = {x = 0, y = -1},
		rfd = {x = 0, y = 0},
		au = {x = 0, y = -2},
		aud1 = {x = 0, y = -1},
		aud2 = {x = 0, y = 0},
	},
	-- Horizontal Right | Down
	["Layout 5"] = {
		c = {
			[1] = {
				x = 0,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[2] = {
				x = 1,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[3] = {
				x = 2,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[4] = {
				x = 3,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[5] = {
				x = 4,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[6] = {
				x = 5,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[7] = {
				x = 6,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[8] = {
				x = 7,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[9] = {
				x = 8,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[10] = {
				x = 9,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[11] = {
				x = 10,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
		},
		ab = {x = -1, y = 0},
		rf = {x = -2, y = 0},
		rfd = {x = -1, y = 0},
		au = {x = -3, y = 0},
		aud1 = {x = -2, y = 0},
		aud2 = {x = -1, y = 0},
	},
	-- Horizontal Right | Up
	["Layout 6"] = {
		c = {
			[1] = {
				x = 0,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[2] = {
				x = 1,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[3] = {
				x = 2,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[4] = {
				x = 3,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[5] = {
				x = 4,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[6] = {
				x = 5,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[7] = {
				x = 6,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[8] = {
				x = 7,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[9] = {
				x = 8,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[10] = {
				x = 9,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[11] = {
				x = 10,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
		},
		ab = {x = -1, y = 0},
		rf = {x = -2, y = 0},
		rfd = {x = -1, y = 0},
		au = {x = -3, y = 0},
		aud1 = {x = -2, y = 0},
		aud2 = {x = -1, y = 0},
	},
	-- Horizontal Left | Down
	["Layout 7"] = {
		c = {
			[1] = {
				x = -1,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[2] = {
				x = -2,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[3] = {
				x = -3,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[4] = {
				x = -4,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[5] = {
				x = -5,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[6] = {
				x = -6,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[7] = {
				x = -7,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[8] = {
				x = -8,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[9] = {
				x = -9,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[10] = {
				x = -10,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
			[11] = {
				x = -11,
				y = 0,
				p = {
					[1] = {x = 0, y = -1},
					[2] = {x = 0, y = -2},
					[3] = {x = 0, y = -3},
					[4] = {x = 0, y = -4},
					[5] = {x = 0, y = -5},
					[6] = {x = 0, y = -6},
					[7] = {x = 0, y = -7},
					[8] = {x = 0, y = -8},
					[9] = {x = 0, y = -9},
					[10] = {x = 0, y = -10},
					[11] = {x = 0, y = -11},
					[12] = {x = 0, y = -12},
					[13] = {x = 0, y = -13},
					[14] = {x = 0, y = -14},
					[15] = {x = 0, y = -15},
				},
			},
		},
		ab = {x = 0, y = 0},
		rf = {x = 1, y = 0},
		rfd = {x = 0, y = 0},
		au = {x = 2, y = 0},
		aud1 = {x = 1, y = 0},
		aud2 = {x = 0, y = 0},
	},
	-- Horizontal Left | Up
	["Layout 8"] = {
		c = {
			[1] = {
				x = -1,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[2] = {
				x = -2,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[3] = {
				x = -3,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[4] = {
				x = -4,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[5] = {
				x = -5,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[6] = {
				x = -6,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[7] = {
				x = -7,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[8] = {
				x = -8,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[9] = {
				x = -9,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[10] = {
				x = -10,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
			[11] = {
				x = -11,
				y = 0,
				p = {
					[1] = {x = 0, y = 1},
					[2] = {x = 0, y = 2},
					[3] = {x = 0, y = 3},
					[4] = {x = 0, y = 4},
					[5] = {x = 0, y = 5},
					[6] = {x = 0, y = 6},
					[7] = {x = 0, y = 7},
					[8] = {x = 0, y = 8},
					[9] = {x = 0, y = 9},
					[10] = {x = 0, y = 10},
					[11] = {x = 0, y = 11},
					[12] = {x = 0, y = 12},
					[13] = {x = 0, y = 13},
					[14] = {x = 0, y = 14},
					[15] = {x = 0, y = 15},
				},
			},
		},
		ab = {x = 0, y = 0},
		rf = {x = 1, y = 0},
		rfd = {x = 0, y = 0},
		au = {x = 2, y = 0},
		aud1 = {x = 1, y = 0},
		aud2 = {x = 0, y = 0},
	},
}
