local _, addonTable = ...

local GetSpellInfo = GetSpellInfo or function(spellId)
    if C_Spell and C_Spell.GetSpellInfo then
        return C_Spell.GetSpellInfo(spellId).name
    end
end

addonTable.localization = addonTable.localization or {
    msg =  {},
    tts =  {},
    chat = {},
}
local localization = addonTable.localization

addonTable.localization.msg['zhCN'] = {
    -- [BWD] Berserk
    ["[BWD] Berserk"] = 'Berserk',

    -- [BWD] Icons
    ["[Nefarian] Stolen Power Buff"]                = "+伤害/治疗",
    ["[Nefarian] Free Your Mind Buff"]              = "+120%\n移动速度",
    ["[Nefarian] Shadow of Cowardice Debuff"]       = "+受到\n暗影伤害",
    ["[Maloriak] Dark Sludge Debuff"]               = "快躲开",
    ["[Maloriak] Engulfing Darkness Debuff"]        = "-100%\n受治疗量",
    ["[Maloriak] Steal Remedy"]                     = "偷取\nBoss回春",
    ["[Atramedes] Pestered!"]                       = "转火小鬼",
    ["[Atramedes] Searing Flame"]                   = "团队AOE",
    ["[Atramedes] Roaring Flame Debuff"]            = "火焰DoT",
    ["[Chimaeron] Caustic Slime"]                   = "-75% 命中",
    ["[Chimaeron] Missing Finkle's Mixture Debuff"] = "缺少免死BUFF",
    ["[Chimaeron] Mocking Shadows (2nd phase)"]     = "环境AOE",
    ["[Chimaeron] Mortality (2nd phase)"]           = "至死方休",
    ["[ODS] Power Generator Debuff"]                = "+伤害",
    ["[ODS] Power Generator Missing [DPS]"]         = "去找蓝圈",
    ["[ODS] Steal Converted Power"]                 = "快偷BOSS",
    ["[ODS] Chemical Cloud Debuff"]                 = "+受到伤害",
    ["[ODS] Soaked in Poison Debuff"]               = "驱散中毒",
    ["[Magmaw] Parasitic Infection Debuff"]         = "被寄生",
    ["[Trash] Debuff - Magma (BWD)"]                = "+受到伤害",
    ["[Trash] Debuff - Flame Buffet_1"]             = '火焰DoT',
    ["[Trash] Debuff - Flame Buffet_2"]             = '+受到伤害',
    ["[Trash] Debuff - Shadowflame"]                = "暗影DoT",
    ["[Trash] Debuff - Flash Bomb"]                 = "昏迷",
    ["[Trash] Debuff - Burden of the Crown_1"]      = "停手",
    ["[Trash] Debuff - Burden of the Crown_2"]      = '+伤害',

    -- [BWD] Big Icons
    ["[Nefarian] Debuff - Explosive Cinders"]       = "准备出人群",
    ["[Nefarian] Debuff - Dominion"]                = "心控",
    ["[Maloriak] Debuff - Flash Freeze"]            = "冰冻",
    ["[Maloriak] Debuff - Biting Chill"]            = "分散",
    ["[Maloriak] Debuff - Consuming Flames"]        = "出人群",
    ["[Artamedes] Debuff - Tracking"]               = "风筝BOSS",
    ["[Artamedes] Debuff - Boss Stun"]              = "BOSS昏迷",
    ["[Atramedes] Noisy"]                           = "快消音波值！",
    ["[ODS] Overcharged Power Generator Debuff_1"]  = "快出圈",
    ["[ODS] Overcharged Power Generator Debuff_2"]  = "+100%伤害",
    ["[ODS] Debuff - Shadow Infusion"]              = "回大团",
    ["[ODS] Debuff - Shadow Conductor"]             = "回大团",
    ["[ODS] Debuff - Lightning Conductor"]          = "出人群",
    ["[ODS] Debuff - Encasing Shadow"]              = "无法移动",
    ["[ODS] Debuff - Acquiring Target"]             = "调整BOSS朝向",
    ["[ODS] Debuff - Fixated"]                      = "小软锁定",
    ["[Magmaw] Debuff - Mangle"]                    = "被吃了",
    ["[Magmaw] Debuff - Shadow Breath"]             = "分散站位",
    ["[Trash] Debuff - Piercing Grip"]              = "被吃了",
    ["[Trash] Debuff - Aura of Dead"]               = "分散站位",

    -- [BWD] Progress Bars
    ["[Nefarian] Nefarian Roleplay"]                = "奈法利安激活",
    ["[Nefarian] Nefarian Landing"]                 = "奈法利安降落",
    ["[Nefarian] Electrocute"]                      = "通电 (团队AOE)",
    ["[Maloriak] Debilitating Slime"]               = "衰弱软泥（单位承伤+100%）",
    ["[Maloriak] Engulfing Darkness_1"]             = "快治疗",
    ["[Maloriak] Engulfing Darkness_2"]             = "-100%受治疗",
    ["[Maloriak] Arcane Storm"]                     = "团队AOE",
    ["[Maloriak] Release Abberation"]               = "释放畸变怪",
    ["[Atramedes] Air Phase Duration"]              = "空中阶段",
    ["[Atramedes] Searing Flames"]                  = "敲钟（巨量团队AOE）",
    ["[Chimaeron] Reroute Power"]                   = "机器人停机",
    ["[Chimaeron] Fight Start"]                     = "争执开始",
    ["[ODS] Shadow Infusion"]                       = "人群集合",
    ["[ODS] Incineration Security Measure"]         = "副本AOE",
    ["[ODS] Poison Protocol"]                       = "毒液炸弹出现",
    ["[Magmaw] Lava Spew [Healer]"]                 = "副本AOE",
    ["[Magmaw] Armageddon Cast"]                    = "集火构造体!",
    ["[Magmaw] Head Exposed"]                       = "集火BOSS头",
    ["[Magmaw] Molten Tantrum Buff"]                = "BOSS伤害增加",
    ["[Trash] Shadowflame Cast"]                    = "躲开头前",
    ["[Trash] Sacrifice Debuff"]                    = "打断",
    ["[Trash] Whirlwind Cast"]                      = "躲开旋风",

    -- [BWD] Alternative Powers
    ["[Atramedes] Alternative Power - Loud"]        = "音波值",
    ["[Maloriak] Counter - Abberations_1"]          = "黑瓶阶段",
    ["[Maloriak] Counter - Abberations_2"]          = "蓝瓶阶段",
    ["[Maloriak] Counter - Abberations_3"]          = "红瓶阶段",
    ["[Maloriak] Counter - Abberations_4"]          = "绿瓶阶段",

    -- [BWD] Little Progress Bars
    ["[Nefarian] Shadowblaze Spark PreWarning"]     = GetSpellInfo(81031),

    -- [BWD] Cooldowns
    ["[Nefarian] CD - Shadowblaze Spark"]           = GetSpellInfo(81031),
    ["[Nefarian] CD - Explosive Cinders"]           = GetSpellInfo(79339),
    ["[Nefarian] CD - Dominion"]                    = "心控",
    ["[Nefarian] CD - Lightning Discharge"]         = GetSpellInfo(77939),
    ["[Nefarian] CD - Shadowflame Breath [Tank]"]   = "吐息",
    ["[Nefarian] CD - Tail Lash [Tank]"]            = GetSpellInfo(77827),
    ["[Maloriak] Next Phase Dark (Heroic)"]         = "黑瓶阶段",
    ["[Maloriak] Next Phase Blue or Red"]           = "蓝/红瓶阶段",
    ["[Maloriak] Next Phase Blue"]                  = "蓝瓶阶段",
    ["[Maloriak] Next Phase Red"]                   = "红瓶阶段",
    ["[Maloriak] Next Phase Green"]                 = "绿瓶阶段",
    ["[Maloriak] CD - Arcane Storm"]                = GetSpellInfo(77896),
    ["[Maloriak] CD - Release Abberation"]          = GetSpellInfo(77569),
    ["[Maloriak] CD - Flash Freeze"]                = GetSpellInfo(77699),
    ["[Maloriak] CD - Debilitating Slime"]          = "+伤害",
    ["[Maloriak] CD - Scorching Blast"]             = "团队AOE",
    ["[Maloriak] CD - Consuming Flames"]            = GetSpellInfo(77786),
    ["[Maloriak] CD - Magma Jets"]                  = "躲开头前",
    ["[Maloriak] CD - Absolute Zero"]               = "冰球",
    ["[Maloriak] CD - Engulfing Darkness"]          = "注意BOSS朝向",
    ["[Atramedes] CD - Air Phase"]                  = "空中阶段",
    ["[Atramedes] CD - Searing Flames"]             = "巨量团队AOE",
    ["[Atramedes] CD - Sonic Breath"]               = "注意BOSS朝向",
    ["[Atramedes] CD - Modulation"]                 = "团队AOE",
    ["[Atramedes] CD - Sonar Pulse"]                = "躲圈",
    ["[Chimaeron] CD - Massacre"]                   = "屠杀",
    ["[Chimaeron] CD - Systems Failure"]            = GetSpellInfo(88853),
    ["[Chimaeron] CD - Break [Tank]"]               = GetSpellInfo(82881),
    ["[Chimaeron] CD - Caustic Slime"]              = GetSpellInfo(82935),
    ["[ODS] CD - Next Activation"]                  = "新金刚激活",
    ["[ODS] CD - Nefarian Special Ability"]         = "奈法特殊技能",
    ["[ODS] CD - Power Generator (Arcanotron)"]     = "蓝圈",
    ["[ODS] CD - Lightning Conductor (Electron)"]   = GetSpellInfo(79888),
    ["[ODS] CD - Chemical Bomb (Toxitron)"]         = GetSpellInfo(80157),
    ["[ODS] CD - Poison Protocol (Toxitron)"]       = "软泥生成",
    ["[ODS] CD - Incineration Security Measure (Magmatron)"] = "团队AOE",
    ["[ODS] CD - Acquiring Target (Magmatron)"]     = "注意BOSS朝向",
    ["[Magmaw] CD - Pillar of Flame"]               = GetSpellInfo(78006),
    ["[Magmaw] CD - Inferno"]                       = "构造体出现",
    ["[Magmaw] CD - Lava Spew"]                     = "团队AOE",
    ["[Magmaw] CD - Mangle"]                        = GetSpellInfo(89773),
    ["[Trash] CD - Chain Lightning"]                = GetSpellInfo(80646),
    ["[Trash] CD - Drakonid Rush"]                  = GetSpellInfo(79630),
    ["[Trash] CD - Enrage"]                         = GetSpellInfo(80084),
    ["[Trash] CD - Piercing Grip"]                  = GetSpellInfo(80145),
    ["[Trash] CD - Shadowflame"]                    = GetSpellInfo(79921),
    ["[Trash] CD - Laser Strike"]                   = GetSpellInfo(81063),
    ["[Trash] CD - Flash Bomb"]                     = GetSpellInfo(81056),

    -- [BWD] Warnings
    ["[Nefarian] W - Phase 2"]                      = "二阶段",
    ["[Nefarian] W - Phase 3"]                      = "三阶段",
    ["[Nefarian] W - Explosive Cinders"]            = GetSpellInfo(79339),
    ["[Nefarian] W - Dominion"]                     = "心控",
    ["[Maloriak] W - Absolute Zero"]                = "冰球出现",
    ["[Maloriak] W - Consuming Flames"]             = GetSpellInfo(77786),
    ["[Maloriak] W - Phase 2"]                      = "二阶段",
    ["[Maloriak] W - Phase 2 Soon"]                 = "三阶段",
    ["[Maloriak] W - Red Phase"]                    = "红瓶阶段",
    ["[Maloriak] W - Blue Phase"]                   = "蓝瓶阶段",
    ["[Maloriak] W - Green Phase"]                  = "绿瓶阶段",
    ["[Maloriak] W - Dark Phase"]                   = "黑瓶阶段",
    ["[Atramedes] W - Shield Used By"]              = "盾被使用",
    ["[Atramedes] W - Tracking"]                    = GetSpellInfo(78092),
    ["[Atramedes] W - Air Phase"]                   = "空中阶段",
    ["[Chimaeron] W - Phase 2"]                     = "二阶段",
    ["[Chimearon] W - Phase 2 Soon"]                = "二阶段准备，还有",
    ["[Chimaeron] W - Break [Tank]"]                = GetSpellInfo(82881),
    ["[Chimaeron] W - Double Attack [Tank]"]        = GetSpellInfo(88826),
    ["[ODS] W - Boss Activated"]                    = "金刚激活",
    ["[ODS] W - Acquiring Target"]                  = "BOSS面朝",
    ["[ODS] W - Lightning Conductor"]               = "快躲开",
    ["[ODS] W - Power Generator"]                   = "踩蓝圈",
    ["[Trash] W - Laser Strike"]                    = "快躲开",
    ["[Trash] W - Flash Bomb"]                      = "快躲开",
    ["[Trash] W - Enrage"]                          = GetSpellInfo(80084),
    ["[Trash] W - Sacrifice"]                       = "处决",

    -- [BWD] Special Warnings
    ["[Nefarian] GTFO - Shadowblaze"]               = "快躲开",
    ["[Nefarian] Shadowblaze Spark"]                = GetSpellInfo(81031),
    ["[Maloriak] GTFO - Dark Sludge"]               = "快躲开",
    ["[Maloriak] SW - Remedy Dispel"]               = "驱散",
    ["[Atramedes] SW - Sonic Breath"]               = GetSpellInfo(78075),
    ["[Atramedes] SW - Searing Flames"]             = GetSpellInfo(77840),
    ["[Atramedes] SW - Sonar Pulse"]                = "躲圈",
    ["[Atramedes] SW - Switch on Imp"]              = "转火小鬼",
    ["[Chimaeron] SW - Systems Failure"]            = GetSpellInfo(88853),
    ["[Chimaeron] SW - Double Attack [Tank]"]       = GetSpellInfo(88826),
    ["[ODS] SW - GTFO"]                             = "快躲开",
    ["[ODS] SW - Stop Attacking"]                   = "停手",
    ["[ODS] SW - Power Generator @ Boss [Tank]"]    = "拉开BOSS",
    ["[Magmaw] SW - Jump Now"]                      = "跳上虫头",
    ["[Magmaw] SW - Jump on Head Countdown"]        = "距离上头还有",
    ["[Magmaw] SW - Pillar of Flame"]               = "躲开寄生虫！",
    ["[Magmaw] SW - Inferno"]                       = "构造体出现",
    ["[Magmaw] SW - GTFO: Ignition"]                = "快躲开",
    ["[Trash] GTFO - Flame Breath"]                 = "快躲开",
    ["[Trash] GTFO - Laser Strike"]                 = "快躲开",
    ["[Trash] GTFO - Flash Bomb"]                   = "快躲开",

    -- [BWD] Circled Textures
    ["[Nefarian] Circled Texture"]                  = "准备心控",
    ["[Maloriak] Circled Texture_1"]                = "准备黑暗阶段",
    ["[Maloriak] Circled Texture_2"]                = "准备红/蓝阶段",
    ["[Maloriak] Circled Texture_3"]                = "即将蓝阶段\n准备分散!",
    ["[Maloriak] Circled Texture_4"]                = "即将红阶段\n准备集合",
    ["[Maloriak] Circled Texture_5"]                = "准备绿阶段",
    ["[Maloriak] Circled Texture_6"]                = "移动BOSS!",
    ["[Chimaeron] Circled Texture_1"]               = "准备屠杀",
    ["[Chimaeron] Circled Texture_2"]               = "屠杀",
    ["[Chimaeron] Circled Texture_3"]               = "争执开始",
    ["[Atramedes] Circled Texture_1"]               = "准备吐息",
    ["[Atramedes] Circled Texture_2"]               = "地面阶段",
    ["[ODS] Circled Texture_1"]                     = "死亡之握",
    ["[ODS] Circled Texture_2"]                     = "爆炸快躲",
    ["[Magmaw] Circled Texture"]                    = "烈焰火柱准备",
    ["[Trash] Circled Texture"]                     = "头前技能准备",

    -- [BWD] @Nameplates
    ["[Magmaw] Nameplate Text - Targetted by Worm"] = "目标是你",

    -- [T4W] Berserking
    ["[BWD] Berserk"] = '狂暴',

    -- [T4W] Icon
    ["[Al'Akir] Debuff - Acid Raid"]                              = "受到伤害",
    ["[Al'Akir] Buff - Eye of the Storm"]                         = "移速",
    ["[Conclave] Debuff - Hurricane"]                             = "自然&掉落伤害",
    ["[Conclave] Debuff - Ice Path"]                              = "快躲开",
    ["[Conclave] Debuff - [Anshal] Toxic Spores"]                 = "DoT",
    ["[Conclave] Debuff - [Anshal] Withering Winds (Alone)_1"]    = "-100%治疗",
    ["[Conclave] Debuff - [Anshal] Withering Winds (Alone)_2"]    = "安舍尔",
    ["[Conclave] Debuff - [Rohash] Deafing Winds (Alone)_1"]      = "沉默",
    ["[Conclave] Debuff - [Rohash] Deafing Winds (Alone)_2"]      = "洛哈西",
    ["[Conclave] Debuff - [Nezir] Chilling Winds (Alone)_1"]      = "-500%急速",
    ["[Conclave] Debuff - [Nezir] Chilling Winds (Alone)_2"]      = "尼希尔",
    ["[T4W] Debuff - Jet Stream"]                                 = "旋风气流\n冷却",

    -- [T4W] Big Icons
    ["[Al'Akir] Debuff - Lightning Rod"]        = "飞离人群!",
    ["[Al'Akir] Debuff - Ice Storm"]            = "快躲开",
    ["[Al'Akir] Debuff - Electrocute"]          = "去近战范围",
    ["[Al'Akir] Debuff - Squall Line"]          = "注意风眼",
    ["[Conclave] Debuff - Soothing Breeze"]     = "快躲绿圈",

    -- [T4W] Progress Bars
    ["[Al'Akir] Lightning Rod"]                = "造成AOE",
    ["[Al'Akir] Feedback"]                     = "+BOSS受到伤害",
    ["[Conclave] Special"]                     = "特殊技能",
    ["[Conclave] [Rohash] Wind Blast"]         = GetSpellInfo(86193),

    -- [T4W] Little Progress Bars
    ["[Conclave] Anfall Revive"]         = "安舍尔复活",
    ["[Conclave] Nezir Revive"]          = "尼希尔复活",
    ["[Conclave] Rohash Revive"]         = "洛哈西复活",
    ["[Al'Akir] Next Acid Rain"]         = GetSpellInfo(88301),

    -- [T4W] Cooldowns
    ["[Al'Akir] CD - Ice Storm"]                            = "暴风雪",
    ["[Al'Akir] CD - Wind Burst"]                           = "击退",
    ["[Al'Akir] CD - Squad Line"]                           = "飓风",
    ["[Al'Akir] CD - Stormling"]                            = "小怪出现",
    ["[Al'Akir] CD - Lightning Clouds"]                     = GetSpellInfo(89588),
    ["[Al'Akir] CD - Lightning Rod"]                        = "Debuff (飞离人群)",
    ["[Conclave] CD - Special"]                             = "特殊技能",
    ["[Conclave] CD - [Anshal] Soothing Breeze"]            = "绿圈",
    ["[Conclave] CD - [Anshal] Nurture"]                    = "小花",
    ["[Conclave] CD - [Anshal] Toxic Spores"]               = GetSpellInfo(86281),
    ["[Conclave] CD - [Nezir] Wind Chill"]                  = "团队AOE",
    ["[Conclave] CD - [Nezir] Ice Patch"]                   = GetSpellInfo(86111),
    ["[Conclave] CD - [Nezir] Perma Frost"]                 = "BOSS头前",
    ["[Conclave] CD - Wind Blast"]                          = GetSpellInfo(86193),
    ["[Conclave] CD - Storm Shield"]                        = GetSpellInfo(93059),

    -- [T4W] Circled Textures
    ["[Conclave] Circled Texture_1"]                        = "快找BOSS背!",
    ["[Conclave] Circled Texture_2"]                        = "即将特殊技能",
    ["[Al'Akir] Circled Texture_1"]                         = "击退",
    ["[Al'Akir] Circled Texture_2"]                         = GetSpellInfo(89588),

    -- [T4W] Warnings
    ["[Al'Akir] W - Phase 3"]                            = "阶段3",
    ["[Al'Akir] W - Phase 2"]                            = "阶段2",
    ["[Al'Akir] W - Phase 2 Soon"]                       = "阶段2 还有",
    ["[Al'Akir] W - Phase 3 Soon"]                       = "阶段3 还有",
    ["[Al'Akir] W - [Phase 1] Ice Storm"]                = "小心暴风雪!",
    ["[Al'Akir] W - [Phase 1/2] Squad Line"]             = "小心风眼!",
    ["[Al'Akir] W - [Phase 2] Stormling"]                = "小怪出现",
    ["[Al'Akir] W - [Phase 2] Feedback"]                 = "目标BOSS",
    ["[Al'Akir] W - [Phase 3] Lightning Rod"]            = GetSpellInfo(89668),
    ["[Conclave] W - [Anshal] Nurture"]                  = "小花",
    ["[Conclave] W - [Nezir] Ice Patch"]                 = "快躲开",
    ["[Conclave] W - [Anshall] Toxic Spores"]            = GetSpellInfo(86281),

    -- [T4W] Special Warnings
    ["[Al'Akir] SW - [Phase 3] Short Distance"]           = "近云层",
    ["[Al'Akir] SW - [Phase 3] Long Distance"]            = "远云层",
    ["[Al'Akir] SW - Wind Burst"]                         = GetSpellInfo(87770),
    ["[Al'Akir] SW - GTFO [Lightning Clouds]"]            = "快躲开",
    ["[Al'Akir] SW - GTFO [Ice Storm]"]                   = "快躲开",
    ["[Al'Akir] SW - Lightning Rod_1"]                    = GetSpellInfo(89668),
    ["[Al'Akir] SW - Lightning Rod_2"]                    = "目标是你",
    ["[Conclave] SW - GTFO"]                              = "快躲开",
    ["[Conclave] SW - [Rohash] Storm Shield"]             = GetSpellInfo(93059),
    ["[Conclave] SW - [Rohash] Summon Tornados"]          = "小心风眼!",
    ["[Conclave] SW - [Rohash] Wind Blast"]               = "小心头前",
    ["[Conclave] SW - [Anshal] Move Boss"]                = "拉走BOSS",

    -- Bastion [Berserk]
    ["[Bastion] Berserk CD"] = "狂暴",

    -- Bastion [Icons]
    ["[Sinestra] Buff - Fiery Barrier_01"]                  = "护盾消失",
    ["[Sinestra] Buff - Fiery Barrier_02"]                  = "-99%\n受到暗影伤害",
    ["[Sinestra] Buff - Essence of the Red"]                = "+100%急速",
    ["[Chogal] Debuff - [Phase 2] Debilitating Beam_01"]    = "-75%伤害&治疗",
    ["[Chogal] Debuff - [Phase 2] Debilitating Beam_02"]    = "眼棱目标是你",
    ["[Council] Debuff - [Phase 1] Water Bomb_01"]          = "-25%移动速度",
    ["[Council] Debuff - [Phase 1] Water Bomb_02"]          = "快踩火",
    ["[Council] Debuff - [Phase 1] Heart of Ice"]           = "近战!",
    ["[Council] Debuff - [Phase 1] Burning Blood"]          = "远程!",
    ["[Council] Buff - [Phase 1] Frost Imbued"]             = "+对火王伤害",
    ["[Council] Buff - [Phase 1] Flame Imbued"]             = "+对水王伤害",
    ["[Council] Debuff - [Phase 2] Magnetic Pull"]          = "-50%激动速度",
    ["[Council] Debuff - [Phase 3] Gravity Crush"]          = "昏迷",
    ["[T&V] Twilight Zone Debuff"]                          = "受到暗影伤害",
    ["[Halfus] Furious Roar Debuff"]                        = "昏迷",
    ["[Trash] Debuff - Shockwave"]                          = "昏迷",
    ["[Trash] Debuff - Entomb"]                             = "找风BUFF",
    ["[Trash] Debuff - Rending Gale"]                       = "找土BUFF",
    ["[Trash] Debuff - Dark Pool"]                          = "快躲开",
    ["[Trash] Debuff - Vaporize"]                           = "-100%护甲",
    ["[Trash] Debuff - Cold-Touched"]                       = "免疫/去找火BUFF",
    ["[Trash] Debuff - Tremors"]                            = "快躲开",
    ["[Trash] Debuff - Stasis Strike"]                      = "昏迷",
    ["[Trash] Debuff - Soul Blade"]                         = "DoT",
    ["[Trash] Debuff - Phased Burn"]                        = "目标是你",
    ["[Trash] Debuff - Magma [Bastion]"]                    = "受到伤害",

    -- Bastion [Big Icons]
    ["[Sinestra] Orb Chasing You"]                      = "注意宝珠目标",
    ["[Sinestra] Debuff - Wrack"]                       = "毁灭 DoT",
    ["[Chogal] Debuff - Worshipping"]                   = "被心控",
    ["[Chogal] Debuff - Corruption Absolute"]           = "+100%伤害\n-100%治疗",
    ["[Chogal] Debuff - Corruption Malformation"]       = "分散站位",
    ["[Chogal] Debuff - Corruption Accelerated"]        = "速度驱散！",
    ["[Council] Debuff - [Phase 1] Static Overload_01"] = "分散站位",
    ["[Council] Debuff - [Phase 1] Static Overload_02"] = "快去找 {rt2}",
    ["[Council] Debuff - [Phase 1] Gravity Core_01"]    = "分散站位",
    ["[Council] Debuff - [Phase 1] Gravity Core_02"]    = "快去找 {rt6}",
    ["[Council] Debuff - [Phase 2] Lightning Rod_01"]   = GetSpellInfo(83099),
    ["[Council] Debuff - [Phase 2] Lightning Rod_02"]   = "快出人群",
    ["[Council] Debuff - [Phase 2] Lightning Rod_03"]   = "安全安全",
    ["[Council] Debuff - [Phase 2] Frost Beacon"]       = "带冰球找火！",
    ["[Council] Debuff - Frozen"]                       = "冻结",
    ["[T&V] Debuff - Blackout"]                         = "找人分担!",
    ["[T&V] Debuff - Meteor"]                           = "找人分担!",
    ["[T&V] Debuff - Exploding"]                        = "快出人群\n停止施法",

    -- Bastion [Alternative Power]
    ["[Chogal] Corruption Blood (Alternate Power)"]     = "腐蚀等级",
    ["[Sinestra] [Phase 2] Calen - Health"]             = "卡伦生命值",
    ["[Sinestra] [Phase 2] Sinestra Mana Barrier"]      = "龙母法力护盾",

    -- Bastion [Progress Bars]
    ["[Sinestra] Shadow Orbs Duration"]                 = "暗影宝珠持续时间",
    ["[Sinestra] Twilight Extinction Duration"]         = "-99% BOSS伤害",
    ["[Sinestra] Mana Barrier"]                         = "法力护盾",
    ["[Chogal] Empowered Shadows Buff (Healers)"]       = "团队AOE",
    ["[Chogal] Flaming Destruction"]                    = "烈焰破坏",
    ["[Chogal] Phasing"]                                = "二阶段",
    ["[Council] Glaciate Cast"]                         = "团队AOE",
    ["[Council] Gravity Crush"]                         = GetSpellInfo(84948),
    ["[T&V] Blackout Duration"]                         = "分担眩晕伤害",
    ["[T&V] Devouring Flames Cast"]                     = "躲开头前!",
    ["[Halifus] Scorching Breath Duration_01"]          = "团队AOE",
    ["[Halifus] Scorching Breath Duration_02"]          = GetSpellInfo(83855),
    ["[Halifus] Furious Roar"]                          = "昏迷",
    ["[Halifus] Fireball Barrage"]                      = GetSpellInfo(83706),

    -- Bastion [Little Progress Bars]
    ["[Sinestra] Egg Weaken Duration"]                  = "龙蛋虚弱",
    ["[Halfus] Scorching Breath Incoming [Healer]"]     = GetSpellInfo(83855),
    
    -- Bastion [Cooldowns]
    ["[Sinestra] CD - [Phase 1] Whelps"]                                = "暮光幼龙",
    ["[Sinestra] CD - [Phase 1] Flame Breath"]                          = GetSpellInfo(90125),
    ["[Sinestra] CD - [Phase 1] Shadow Orbs"]                           = "暗影宝珠",
    ["[Chogal] CD - [Phase 1] Worship"]                                 = "心控",
    ["[Chogal] CD - [Phase 1] Flame Orders_01"]                         = "火元素出现",
    ["[Chogal] CD - [Phase 1] Flame Orders_02"]                         = "火元素出现",
    ["[Chogal] CD - [Phase 1] Shadow Orders_01"]                        = "暗元素出现",
    ["[Chogal] CD - [Phase 1] Shadow Orders_02"]                        = "暗元素出现",
    ["[Chogal] CD - [Phase 1] Fury [Tank/Healer]"]                      = GetSpellInfo(82524),
    ["[Chogal] CD - [Phase 1] Adherent"]                                = "腐蚀信徒出现",
    ["[Chogal] CD - [Phase 1] Fester Blood"]                            = GetSpellInfo(82299),
    ["[Council] CD - [Phase 1] Glaciate (Feludius)"]                    = "团队AOE",
    ["[Council] CD - [Phase 1] Hydro Lance (Feludius) [Healer]"]        = "单体伤害",
    ["[Council] CD - [Phase 1] Water Bomb (Feludius)"]                  = GetSpellInfo(82699),
    ["[Council] CD - [Phase 1] Aegis of Flames (Ignacious)"]            = "烈火之盾",
    ["[Council] CD - [Phase 1] Gravity Core (Inactive - Arion)"]        = GetSpellInfo(92075),
    ["[Council] CD - [Phase 1] Static Overload (Inactive - Terrastra)"] = GetSpellInfo(92067),
    ["[Council] CD - [Phase 2] Harden Skin (Terrastra)"]                = "硬化外皮",
    ["[Council] CD - [Phase 2] Gravity Well (Terrastra)"]               = GetSpellInfo(83578),
    ["[Council] CD - [Phase 2] Call Winds (Arion)"]                     = GetSpellInfo(83491),
    ["[Council] CD - [Phase 2] Flame Strike (Inactive - Ignacious)"]    = "火圈",
    ["[Council] CD - [Phase 3] Gravity Crush"]                          = GetSpellInfo(84948),
    ["[Council] CD - [Phase 3] Lava Seed"]                              = GetSpellInfo(84913),
    ["[T&V] CD - Next Swap"]                                            = "BOSS交换",
    ["[T&V] CD - Twilight Shift [Tank]"]                                = GetSpellInfo(93051),
    ["[T&V] CD - Devouring Flames (Valiona @Ground)"]                   = "头前吐息",
    ["[T&V] CD - Blackout (Valiona @Ground)"]                           = "集合分担",
    ["[T&V] CD - Dazzling Destruction (Theralion @Air)"]                = "三连彩圈",
    ["[T&V] CD - Fabulous Flames (Theralion @Ground)"]                  = GetSpellInfo(86505),
    ["[T&V] CD - Engulfing Magic (Theralion @Ground)"]                  = "Debuff出人群",
    ["[T&V] CD - Deep Breath (Valiona @Air)"]                           = GetSpellInfo(86059),
    ["[Halifus] CD - Breath"]                                           = "团队AOE",
    ["[Halifus] CD - Shadow Nova"]                                      = "击退",
    ["[Halifus] CD - Furious Roar"]                                     = "三连昏迷",
    ["[Halifus] CD - Paralysis"]                                        = "BOSS麻痹",
    
    -- Bastion [Circled Textures]
    ["[Sinestra] Circled Texture_01"] = "暗影宝珠准备",
    ["[Sinestra] Circled Texture_02"] = "转火龙蛋",
    ["[Chogall] Circled Texture_01"]  = "腐蚀信徒准备",
    ["[Chogall] Circled Texture_02"]  = "远离大团准备",
    ["[Chogall] Circled Texture_03"]  = "出人群",
    ["[Council] Circled Texture_01"]  = "准备打断土王",
    ["[Council] Circled Texture_02"]  = "重力碾压",
    ["[Council] Circled Texture_03"]  = "三阶段准备",
    ["[T&V] Circled Texture_01"]      = "头前吐息准备",
    ["[T&V] Circled Texture_02"]      = "观察深呼吸方向",
    ["[Halfus] Circled Texture_01"]   = "BOSS即将昏迷",
    ["[Halfus] Circled Texture_02"]   = "转火BOSS",
    
    -- Bastion [Warnings]
    ["[Sinestra] W - Phase 3"]                                     = "三阶段",
    ["[Sinestra] W - Phase 2"]                                     = "二阶段",
    ["[Sinestra] W - Phase 2 Soon"]                                = "二阶段还有",
    ["[Sinestra] Whelps"]                                          = "召唤暮光幼龙",
    ["[Chogall] W - Phase 2"]                                      = "二阶段",
    ["[Chogall] W - 85% Soon"]                                     = "腐蚀信徒刷新还有",
    ["[Chogall] Warning - [Phase 1] Spilled Blood"]                = "召唤脓血",
    ["[Chogall] Warning - [Phase 1] Interrupt Worship"]            = "打断! ",
    ["[Chogall] Warning - [Phase 1] Fire Elemental Portal"]        = "火元素出现 ",
    ["[Chogall] Warning - [Phase 1] Shadow Elemental Portal"]      = "暗影元素出现",
    ["[Council] Warning - Static Overload"]                         = GetSpellInfo(92067),
    ["[Council] Warning - Gravity Core"]                            = GetSpellInfo(92075),
    ["[Council] Warning - Heart of Ice"]                            = GetSpellInfo(82665),
    ["[Council] Warning - Frost Beacon"]                            = "冰冻宝珠",
    ["[Council] W - Phase 3"]                                      = "三阶段",
    ["[Council] W - Phase 2"]                                      = "二阶段",
    ["[T&V] W - Twilight Shift [Tank]"]                            = GetSpellInfo(93051),
    ["[T&V] W - Dazzling Destruction"]                             = "小心脚下",
    ["[T&V] SW - Deep Breath"]                                     = GetSpellInfo(86059),
    ["[T&V] W - Valiona Landed"]                                   = "瓦里昂娜降落",
    ["[T&V] W - Theralion Landed"]                                 = "瑟纳利昂降落",
    
    -- Bastion [Special Warnings]
    ["[Sinestra] SW - Egg Shield"]                      = "龙蛋鳞片",
    ["[Sinestra] SW - Eggs Weaken"]                     = "集火龙蛋",
    ["[Sinestra] SW - GTFO"]                            = "快躲开",
    ["[Sinestra] SW - Flame Breath"]                    = GetSpellInfo(90125),
    ["[Chogall] SW - GTFO: Blaze"]                      = "快躲开",
    ["[Chogall] SW - GTFO: Spilled Blood"]              = "快躲开",
    ["[Chogall] SW - Adherent Spawn"]                   = "腐蚀信徒出现",
    ["[Chogall] SW - Corrupting Crash on You"]          = "暗影冲击，快躲",
    ["[Chogall] SW - Corrupting Crash Near"]            = "暗影冲击附近",
    ["[Council] SW - Glaciate"]                         = "团队AOE",
    ["[Council] SW - Aegis of Flame"]                   = GetSpellInfo(82631),
    ["[Council] SW - Dodge Water Bomb"]                 = "躲开水泡!",
    ["[Council] SW - Dodge Lava Seeds"]                 = "躲开熔岩",
    ["[Council] SW - Glaciate Range Check_01"]          = "冻结，保持水王距离",
    ["[Council] SW - Glaciate Range Check_02"]          = "远离水王",
    ["[Council] SW - Glaciate Range Check_03"]          = "安全安全",
    ["[Council] SW - GTFO"]                             = "快躲开",
    ["[T&V] SW - GTFO"]                                 = "快躲开",
    ["[T&V] SW - Twilight Zone"]                        = GetSpellInfo(86214),
    ["[T&V] SW - Wrong Target_01"]                      = "转换目标",
    ["[T&V] SW - Wrong Target_02"]                      = "瓦里昂娜",
    ["[T&V] SW - Blackout"]                             = "集合!",
    ["[T&V] SW - Fabulous Flames On You"]               = "躲开火圈!",
    ["[T&V] SW - Devouring Flames"]                     = "躲开头前吐息",
    ["[Halifus] SW - Furious Roar"]                     = "三连昏迷",
    
    -- Bastion [@Nameplates]
    ["[Sinestra] Face Away"]                              = "头前站位",
    ["[Sinestra] Stop the Cast!"]                         = "停止施法",
    ["[Chogall] Targetted by Ooze"]                       = "目标是你",
    ["[Chogall] Mind Controlled"]                         = "打断",
    ["[Chogall] Depravity (Adherent Cast)"]               = "打断",
    ["[Council] SW - Interrupt Rising Flames"]            = "打断",
    ["[Council] SW - Interrupt Harden Skin"]              = "打断",
    ["[Trash] Focus Mob (Portal) @Nameplate"]             = "打断",
    ["[Trash] I hate this cast please do something"]      = "",
    ["[Sinestra] Indomitable Enrage_01"]                  = "驱散",
    ["[Sinestra] Indomitable Enrage_02"]                  = "激怒",
    
    -- Bastion [@Nameplates Cooldowns]
    ["[Trash] @Nameplate Cooldowns"]                       = "",
    ["[Sinestra] @Nameplate - Twilight Breath CD"]         = "头前",
    ["[Council] @Nameplate - Flame Torrent CD"]            = "头前",
    ["[Halfus] @Nameplate - Shadow Nova CD"]               = "击退",
    ["[Council] @Nameplate - Inferno Leap CD"]             = "冲锋",
    ["[Council] @Nameplate - Hydro Lance CD"]              = "打断",
    ["[Council] @Nameplate - Eruption CD"]                 = "击飞",
    ["[Council] @Nameplate - Disperse CD"]                 = "闪现",
    
    -- Bastion [Lists [RL/Assist]]
    ["[Council] Frost Imbued - Counter"]     = "+对火王伤害",
    ["[Council] Flame Imbued - Counter"]     = "+对水王伤害",

    -- Bastion [Alternative Widgets]
    ["[Council] Quake_01"]                   = GetSpellInfo(83565),
    ["[Council] Quake_02"]                   = "快拿风!",
    ["[Council] Thundershock_01"]            = GetSpellInfo(83067),
    ["[Council] Thundershock_02"]            = "快拿土!",

    -- Firelands [Icons]
    ["[Firelands-Trash] Debuff - Conflagration"] = '恐惧',
    ["[Firelands-Trash] Debuff - Ensnare"] = '诱捕',
    ["[Firelands-Trash] Debuff - Dinner Time"] = '挤压',
    ["[Firelands-Trash] Debuff - Terryifing Roar"] = '恐惧',
    ["[Firelands-Trash] Buff - Disciplinary Action"] = '火妖监工\n强化！',
    ["[Firelands-Trash] Debuff - Ignite"] = '30000',
    ["[Firelands-Trash] Debuff - Soul Burn"] = '沉默',
    ["[Shannox] Debuff - Face Rage"] = '击倒',
    ["[Beth'tilac] Debuff - Volatile Poison"] = '陷阱',
    ["[Beth'tilac] Debuff - Fiery Web Spin"] = '束缚',
    ["[Beth'tilac] Debuff - Ember Flare CD"] = '余烬之火',
    ["[Shannox] Buff - Feeding Frenzy [Rageface]"] = '狂脸',
    ["[Shannox] Buff - Feeding Frenzy [Riplimb]"] = '裂肢',
    ["[Alysrazor] Buff - Wings of Flame"] = '烈焰之翼',
    ["[Alysrazor] Buff - Blazing Power"] = '急速',
    ["[Alysrazor] Debuff - Alysra's Razor"] = '暴击',
    ["[Alysrazor] Buff - Molten Feather"] = "羽毛",
    ["[Rhyolith] Buff - Internal Rage"] = '伤害加成',
    ["[Rhyolith] Buff - Superheated"] = 'Boss增伤',
    ["[Baleroc] Buff - Vital Flame"] = '+治疗量',
    ["[Baleroc] Buff - Vital Spark"] = 'Stacks',
    ["[Baleroc] Debuff - Tormented"] = '远离人群',
    ["[Majordomo] Debuff - Burning Orb"] = "燃烧宝珠",
    ["[Majordomo] Debuff - Searing Seeds [1]"] = "灼热之种准备",
    ["[Majordomo] Debuff - Searing Seeds [2]"] = "远离人群",
    ["[Majordomo] Debuff - Concentration Buff"] = "|cffffffff伤害|r",
    ["[Ragnaros] Debuff - Deluge"] = "去踩火",
    ["[Ragnaros] Debuff - Superheated"] = "DoT",
    ["[Ragnaros] Debuff - Magma Trap Vulnerability"] = "+50% \n陷阱伤害",
    ["[Ragnaros] Debuff - Breadth of Frost"] = '安全',
    ["[Ragnaros] Debuff - Lava Wave"] = 'DoT',
    ["[Ragnaros] Debuff - Magma"] = '火焰伤害',

    -- Firelands [Big Icons]
    ["[Firelands-Trash] Debuff - Blistering Wound"] = '快治疗',
    ["[Beth'tilac] Debuff - Fixate"] = "被凝视 \n注意朝向",
    ["[Alysrazor] Debuff - Harsh Winds"] = "靠近Boss",
    ["[Alysrazor] Debuff - Imprinted [Non-Tank]"] = '小鸟看你',
    ["[Rhyolith] Debuff - Magma"] = 'Run Out',
    ["[Baleroc] Debuff - Countdown"] = '连线集合',
    ["[Majordomo] Orbs Timers"] = '宝珠激活',
    ["[Ragnaros] Debuff - Blazing Heat"] = "|cffccff00炽炎点名|r\n放火",
    ["[Ragnaros] Debuff - Magma Blast"] = "快去近战范围！",
    ["[Ragnaros] Debuff - Fixate"] = "|cffccff00流星|r\n点你",
    ["[Ragnaros] Debuff - Seed on You"] = "|cffccff00种子|r\n点你",

    -- Firelands [Progress Bar]
    ["[Firelands-Trash] Kneel to the flame"] = GetSpellInfo(99705),
    ["[Firelands-Trash] Raise Lava"] = GetSpellInfo(99503),
    ["[Firelands-Trash] Cast - Flame Breath"] = GetSpellInfo(99736),
    ["[Alysrazor] First Combat Start"] = "战斗开始",
    ["[Alysrazor] Fiery Storm"] = GetSpellInfo(99794),
    ["[Alysrazor] Boss Burnout"] = 'Boss易伤 +50%',
    ["[Alysrazor] Boss Ignited"] = 'Boss AoE',
    ["[Rhyolith] Timer - Magma Flow"] = GetSpellInfo(97225),
    ["[Rhyolith] Timer - Heated Volcano"] = GetSpellInfo(98493),
    ["[Majordomo] Active - Burning Orbs"] = '宝珠激活',
    ["[Ragnaros] Cast - Sulfuras Smash"] = '火墙火墙',
    ["[Ragnaros] Timer - Transmission"] = '转阶段',
    ["[Ragnaros] Cast - Engulfing Flames [1]"] = '近',
    ["[Ragnaros] Cast - Engulfing Flames [2]"] = '中',
    ["[Ragnaros] Cast - Engulfing Flames [3]"] = '远',
    ["[Ragnaros] Timer - Seeds Explosion"] = '种子爆炸',

    -- Firelands [Little Progress Bar]
    ["[Alysrazor] CD - Hatch Eggs [Tank]"] = "小鸟孵化",
    ["[Ragnaros] Transmission 1 Enter"] = "转阶段一",
    ["[Ragnaros] Transmission 2 Enter"] = "转阶段二",
    ["[Ragnaros] Phase 4 Enter"] = "四阶段",
    ["[Ragnaros] Hit the Boss"] = "集火Boss",
    ["[Baleroc] Decimation Blade Strike"] = "暗刀阶段",
    ["[Baleroc] Inferno Blade Strike"] = "火刀阶段",
    ["[Ragnaros] Buff - Entrapping Roots"] = "螺丝易伤+50%",
    ["[Ragnaros] Buff - Meteor Increased Damage"] = "流星易伤+50%",
    ["[Ragnaros] Ragnaros Emerge"] = "拉格纳罗斯出现",

    -- Firelands [Warnings]
    ["[Beth'tilac] W - Spiderlings Spawned"] = "小蜘蛛刷新",
    ["[Beth'tilac] W - Spinners Spawned"] = "中蜘蛛刷新",
    ["[Beth'tilac] W - The Widow's Kiss"] = GetSpellInfo(99476),
    ["[Shannox] W - Crystal Prison"] = '水晶牢笼',
    ["[Shannox] W - Immolation Trap"] = '献祭陷阱',
    ["[Alysrazor] W - Initiates Spawned"] = "新兵刷新",
    ["[Alysrazor] W - Firestorm Soon"] = "即将火焰飓风",
    ["[Alysrazor] W - Molting"] = GetSpellInfo(99464),
    ["[Alysrazor] W - Blazing Power Gain [1]"] = "向左移动5码",
    ["[Alysrazor] W - Blazing Power Gain [2]"] = "层数已满",
    ["[Rhyiolith] W - Heated Volcano"] = "点燃火山",
    ["[Rhyiolith] W - Phase 2 Soon"] = "即将二阶段",
    ["[Rhyiolith] W - Molten Armor"] = GetSpellInfo(98255),
    ["[Rhyiolith] W - Spark Spawn"] = GetSpellInfo(98552),
    ["[Rhyiolith] W - Adds Spawn"] = GetSpellInfo(98136),
    ["[Baleroc] W - Countdown Targets"] = GetSpellInfo(99516),
    ["[Majordomo] W - Adrenaline"] = GetSpellInfo(97238),
    ["[Majordomo] W - Leap"] = GetSpellInfo(98476),
    ["[Ragnaros] W - Blazing Heat"] = GetSpellInfo(99126),
    ["[Ragnaros] W - Magma Trap"] = '熔岩陷阱',
    ["[Ragnaros] W - Hand of Ragnaros"] = '近战击退',
    ["[Ragnaros] W - Wrath of Ragnaros"] = '远程击退',
    ["[Ragnaros] W - Breadth of Frost"] = GetSpellInfo(100479),
    ["[Ragnaros] W - Entraping Roots"] = GetSpellInfo(100646),
    ["[Ragnaros] W - Empower Sulfuras [non-Tank]"] = GetSpellInfo(100604),
    ["[Ragnaros] W - Dreadflames"] = GetSpellInfo(100675),
    ["[Ragnaros] W - Cloudburst"] = GetSpellInfo(100714),
    ["[Ragnaros] W - GTFO"] = "快躲开",

    -- Firelands [Special Warning]
    ["[Firelands-Trash] W - Lava Jets"] = "小心脚下",
    ["[Firelands-Trash] Shannox Spawned"] = "沙恩诺克斯激活",
    ["[Firelands-Trash] Leap of the Flame on You"] = "飞扑点你",
    ["[Firelands-Trash] W - Conduit"] = string.upper(GetSpellInfo(100732)),
    ["[Beth'tilac] W - Phase 2 Announcement"] = "二阶段",
    ["[Beth'tilac] W - The Widow's Kiss On You"] = "寡妇之吻点你",
    ["[Shannox] W - Crystal Prison on Me"] = "水晶牢笼点你",
    ["[Shannox] W - Immolation Trap on Me"] = "献祭陷阱点你",
    ["[Baleroc] W - Shards of Torment"] = 'SHARDS',
    ["[Alysrazor] W - Blazing Claw"] = "躲开头前",
    ["[Alysrazor] W - Cataclysm"] = "流星",
    ["[Alysrazor] W - Phase Announcement [1]"] = "一阶段",
    ["[Alysrazor] W - Phase Announcement [2]"] = "二阶段",
    ["[Alysrazor] W - Phase Announcement [3]"] = "三阶段",
    ["[Alysrazor] W - Phase Announcement [4]"] = "四阶段",
    ["[Alysrazor] W - Dance!"] = "跳舞",
    ["[Alysrazor] W - Tantrum"] = string.upper(GetSpellInfo(99362)),
    ["[Alysrazor] W - Firestorm"] = string.upper(GetSpellInfo(100744)),
    ["[Alysrazor] GTFO - Firestorm"] = "躲进流星",
    ["[Alysrazor] GTFO - Lava Spew"] = "小心喷吐",
    ["[Alysrazor] GTFO - Brushfire"] = "小心火球",
    ["[Alysrazor] W - Taunt Now! [Tank]"] = "嘲讽！",
    ["[Rhyiolith] W - Magma Flow"] = string.upper(GetSpellInfo(97225)),
    ["[Rhyiolith] W - Phase Announcement"] = "二阶段",
    ["[Majordomo] W - Leap On You"] = "飞扑点你！",
    ["[Majordomo] Spread!"] = "分散",
    ["[Majordomo] Stack!"] = "集合",
    ["[Ragnaros] W - Phase Announcement [1]"] = "二阶段",
    ["[Ragnaros] W - Phase Announcement [2]"] = "三阶段",
    ["[Ragnaros] W - Phase Announcement [3]"] = "四阶段",
    ["[Ragnaros] W - Sulfuras Smash"] = "火墙火墙火墙",
    ["[Ragnaros] W - Trap on You"] = "陷阱点你",
    ["[Ragnaros] W - Molten Seeds"] = string.upper(GetSpellInfo(98333)),
    ["[Ragnaros] W - Empower Sulfuras [Tank]"] = string.upper(GetSpellInfo(100604)),
    ["[Ragnaros] W - Meteor on You"] = '流星点你',
    ["[Ragnaros] -  Seed On You"] = '种子点你',
    ["[Ragnaros] W - Pet Attacks Last Son"] = "召回宝宝",
    ["[Ragnaros] W - Dreadflames for Soakers"] = "火苗生成快吸",
    ["[Ragnaros] W - Pet on Meteor"] = "宝宝打流星",
    ["[Ragnaros] W - Meteor Spawned"] = "流星注意！",

    -- Firelands [Cooldowns]
    ["[Firelands-Trash] CD - Lava Jets"] = GetSpellInfo(99555),
    ["[Firelands-Trash] CD - Shockwave"] = GetSpellInfo(99610),
    ["[Firelands-Trash] CD - Terrifying Roar"] = "恐惧",
    ["[Firelands-Trash] CD - Flame Breath"] = GetSpellInfo(99736),
    ["[Firelands-Trash] CD - Dinner Time"] = GetSpellInfo(99693),
    ["[Firelands-Trash] CD - Flaming Cleave"] = GetSpellInfo(100431),
    ["[Firelands-Trash] CD - Summon Elemental"] = '召唤元素',
    ["[Firelands-Trash] CD - Lava Surge"] = GetSpellInfo(100549),
    ["[Firelands-Trash] CD - Releasse the Hounds!"] = GetSpellInfo(100778),
    ["[Firelands-Trash] CD - Summon Lava Spawn"] = GetSpellInfo(99575),
    ["[Firelands-Trash] CD - Volcano"] = GetSpellInfo(99571),
    ["[Firelands-Trash] CD - Magma Conduit"] = '火山',
    ["[Firelands-Trash] CD - Stopcast"] = '停止施法',
    ["[Firelands-Trash] CD - Eruption"] = '‘击退',
    ["[Firelands-Trash] CD - Molten Volley"] = '范围伤害',
    ["[Firelands-Trash] CD - Roots [Volcanus]"] = GetSpellInfo(100146),
    ["[Shannox] CD - Hurl Spear"] = GetSpellInfo(100002),
    ["[Shannox] CD - Crystal Prison"] = GetSpellInfo(99836),
    ["[Shannox] CD - Face Rage"] = GetSpellInfo(99947),
    ["[Shannox] CD - Magma Rupture"] = GetSpellInfo(99840),
    ["[Alysrazor] CD - Fiery Vortex"] = GetSpellInfo(99794),
    ["[Alysrazor] CD - Firestorm"] = GetSpellInfo(100744),
    ["[Beth'tilac] CD - Ember Flare"] = GetSpellInfo(98934),
    ["[Beth'tilac] CD - Spiderlings"] = "小蜘蛛",
    ["[Beth'tilac] CD - Spinners"] = "中蜘蛛",
    ["[Beth'tilac] CD - Drone"] = "大蜘蛛",
    ["[Beth'tilac] CD - Smoldering Devastation"] = '阴燃毁灭',
    ["[Beth'tilac] CD - Phase 2"] = "二阶段",
    ["[Beth'tilac] CD - Widow Kiss"] = GetSpellInfo(99476),
    ["[Beth'tilac] CD - Frenzy"] = GetSpellInfo(99497),
    ["[Alysrazor] CD - Initiates"] = "炽炎新兵",
    ["[Alysrazor] CD - Cataclysm (Meteor)"] = "流星",
    ["Side: Both"] = '全场',
    ["Side: East"] = "右半场",
    ["Side: West"] = "左半场",
    ["[Rhyolith] CD - Summon Spark of Rhyolith"] = "小怪刷新",
    ["[Rhyolith] CD - Heated Volcano"] = GetSpellInfo(98493),
    ["[Rhyolith] CD - Concussive Stomp"] = GetSpellInfo(97282),
    ["[Rhyolith] CD - Superheated"] = GetSpellInfo(101304),
    ["[Baleroc] CD - Next Blade"] = "下一次拔刀",
    ["[Baleroc] CD - Shards of Torment"] = GetSpellInfo(99259),
    ["[Baleroc] CD - Countdown"] = GetSpellInfo(99516),
    ["[Baleroc] CD - Blaze of Glory"] = GetSpellInfo(99252),
    ["[Ragnaros] W - Blazing Heat"] = GetSpellInfo(99126),
    ["[Ragnaros] CD - Magma Trap"] = '熔岩陷阱',
    ["[Ragnaros] CD - Hand of Ragnaros"] = '近战击退',
    ["[Ragnaros] CD - Wrath of Ragnaros"] = '远程击退',
    ["[Ragnaros] CD - Sulfuras Smash"] = '火墙火墙',
    ["[Ragnaros] CD - Engulfing Flames"] = '噬体烈焰',
    ["[Ragnaros] CD - Engulfing Flames (Normal)"] = GetSpellInfo(99235),
    ["[Ragnaros] CD - World in Flames (Heroic)"] = GetSpellInfo(100171),
    ["[Ragnaros] CD - Molten Seeds"] = GetSpellInfo(98333),
    ["[Ragnaros] CD - Transmission Phase"] = '转阶段结束',
    ["[Ragnaros] CD - Lava Bolt"] = GetSpellInfo(98981),
    ["[Ragnaros] CD - Living Meteor"] = GetSpellInfo(99268),
    ["[Ragnaros] CD - Blazing Heat"] = GetSpellInfo(100460),
    ["[Ragnaros] CD - Breadth of Frost"] = GetSpellInfo(100479),
    ["[Ragnaros] CD - Entraping Roots"] = GetSpellInfo(100646),
    ["[Ragnaros] CD - Empowered Sulfuras"] = GetSpellInfo(100604),
    ["[Ragnaros] CD - Dreadflames"] = GetSpellInfo(100675),
    ["[Ragnaros] CD - Cloudburst"] = GetSpellInfo(100714),

    -- [""] = ,

    -- Firelands [Circled Texture]
    ["[Firelands-Trash] Earthquake"] = "停止施法！",
    ["[Tormented Protector] Blazing Stomp Soon"] = "Dispel Soon",
    ["[Shannox] Circled Texture [1]"] = GetSpellInfo(100002),
    ["[Beth'tilac] Circled Texture [1]"] = "即将Boss AoE",
    ["[Beth'tilac] Circled Texture [2]"] = "远离人群自爆",
    ["[Alysrazor] Circled Texture [1]"] = "流星降落",
    ["[Alysrazor] Circled Texture [2]"] = "即将火焰飓风", 
    ["[Alysrazor] Circled Texture [3]"] = "准备跳舞",
    ["[Rhyolith] Circled Texture [1]"] = GetSpellInfo(97282),
    ["[Baleroc] Circled Textures [1]"] = '下一次拔刀',
    ["[Majordomo] Circled Texture"] = '远离人群爆炸',
    ["[Ragnaros] Circled Texture [1]"] = GetSpellInfo(98333),
    ["[Ragnaros] Circled Texture [2]"] = '跳舞',
    ["[Ragnaros] Circled Texture [3]"] = GetSpellInfo(99268),
    ["[Ragnaros] Circled Texture [4]"] = GetSpellInfo(100646),
    ["[Ragnaros] Circled Texture - For Soakers"] = "火苗生成快吸",
    ["[Ragnaros] Circled Texture - For Tanks [1]"] = "新纠缠根须",
    ["[Ragnaros] Circled Texture - For Tanks [2]"] = "强化萨弗拉斯",
    ["[Ragnaros] Casters [Phase 1 Interrupt Melee]"] = "近战击退",

    -- Firelands [Nameplates Elements]
    ["[Beth'tilac] Nameplate Text - Targetted by Spider"] = "",

    -- Firelands [Misc]
    ["[Rhyolith] Timer - Fragments Explosion"] = '爆炸',
    ["[Rhyolith] Counter - Fragments of Rhyolith"] = '碎片',
    ["[Majordomo] Next Human Form Ability [1]"] = '|cff2eff00灼热之种|r',
    ["[Majordomo] Next Human Form Ability [2]"] = '|cffff7f00燃烧宝珠|r',
    ["[Ragnaros] SB - Left"] = '左',
    ["[Ragnaros] SB - Middle"] = '中',
    ["[Ragnaros] SB - Right"] = '右',
    ["[Ragnaros] Counter - Sons of Flame"] = "烈焰之子",
    ["[Ragnaros] Meteor Knockable"] = "可击退",
    ["[Ragnaros] Active Timer - Breadth of Frost"] = '冰障',
    ["[Beth'tilac] Head - Fiery Web Silk "] = '上网组',

    -- Firelands [Lists]
    ["[Firelands-Trash] Active Volcano"] = "火山激活",
    --
}

addonTable.localization.tts['zhCN'] = {
}

addonTable.localization.chat['zhCN'] = {
    -- BWD
    ['Cleared'] = 'Cleared',
    ['cleared'] = 'cleared',
    ['{rt8} RUN OUT! IM STUCKED {rt8}'] = '{rt8} 我被强化点名 {rt8}',
    ['{rt8} Frontal on me {rt8}'] = '{rt8} 吐息点我 {rt8}',
    ['{rt6} AoE {rt6}'] = '{rt6} AoE {rt6}',
    ['%s AoE %s'] = '%s AoE %s',
    ['+Frost Damage'] = '+冰霜伤害',
    ['+Fire Damage'] = '+火焰伤害',
    ['{rt6} Frozen Orb {rt6}'] = '{rt6} 寒冰宝珠 {rt6}',
    ['{rt1} Out {rt1}'] = '{rt1} Out {rt1}',
}

-- Replica to Localized Text
MerfinLocalize = function(replica)
    local source = localization.msg[Merfin.GetLocale()] or localization.msg['zhCN']
    return (source and source[replica]) or replica
end

-- Replica to localized Text and Text to Speech
MerfinChatMSG = function(message, chatType, ...)
    local locale = Merfin.GetLocale()
    local source = localization.chat[locale] or localization.chat['zhCN']
    message = (source and source[message]) or message
    
    -- Форматирование сообщения с дополнительными аргументами, если они есть
    if ... then
        message = string.format(message, ...)
    end

    -- Проверка на наличие маркеров от {rt1} до {rt8} и замена их на локализованные значения, если локализация 'ruRU'
    if locale == 'ruRU' then
        message = message:gsub("({rt%d})", function(marker)
            -- Печать для отладки, чтобы видеть маркер перед заменой
            return addonTable.localization.chat['ruRU'][marker] or marker
        end)
        -- Печать для отладки, чтобы видеть итоговое сообщение
    end

    -- Отправка сообщения в чат
    SendChatMessage(message, chatType or 'SAY')
end