﻿----------------------------------------------------------------------
-- 	Leatrix Plus Locale
----------------------------------------------------------------------

-- Create locale structure
local GameLocale = GetLocale()
local void, Leatrix_Plus = ...
local function localeFunc(L, key) return key end
local L = setmetatable({}, {__index = localeFunc})
Leatrix_Plus.L = L

if LeatrixGlobalDisableLocalisation then return end

-- Locale override (enUS, zhCN, zhTW, ruRU, koKR, deDE, esMX, frFR, itIT, ptBR)
-- GameLocale = "enUS"

-- zhCN: Simplified Chinese
if GameLocale == "zhCN" then
L["+"] = "+"
L["A Donation of Mageweave"] = "捐献魔纹布"
L["A Donation of Runecloth"] = "捐献符文布"
L["A Donation of Silk"] = "捐献丝绸"
L["A Donation of Wool"] = "捐献毛料"
L["A friend request from"] = "你有一个好友申请，来自"
L["Accept available quests automatically"] = "自动接受任务"
L["Accept resurrection"] = "自动接受战复"
L["Accept summon"] = "自动接受召唤"
L["A'dal"] = "阿达尔"
L["Resurrection not accepted.  Someone in your group has a charge debuff."] = "未接受复活。你的队伍中有人带有电荷减益效果。"
L["Additional Runecloth"] = "更多的符文布"
L["Addon"] = "插件"
L["Aerie Peak"] = "鹰巢山"
L["Ahn'Qiraj"] = "安其拉"
L["ALT"] = "ALT"
L["Alterac Mountains"] = "奥特兰克山脉"
L["Anchor"] = "锚点"
L["Angelic"] = "主题：天使"
L["Arathi Highlands"] = "阿拉希高地"
L["Ashenvale"] = "灰谷"
L["Astranaar"] = "阿斯特兰纳"
L["Auberdine"] = "奥伯丁"
L["Auto loot is now enabled."] = "自动拾取已启用。"
L["AutoFollow"] = "自动跟随"
L["AutoFollow disabled."] = "已关闭自动跟随。"
L["Automate gossip"] = "对话自动交互"
L["Automate quests"] = "任务自动交接"
L["Automatic Release Cancelled"] = "自动释放已取消"
L["Automation"] = "自动交互"
L["Azshara"] = "艾萨拉"
L["Azuremyst Isle"] = "秘蓝岛"
L["B"] = "B"
L["Back to Main Menu"] = "返回"
L["Bad ID"] = "损坏的ID"
L["Badlands"] = "荒芜之地"
L["Barrens"] = "南贫瘠之地"
L["Battle"] = "主题：战争"
L["Battle of Warsong Gulch"] = "峡谷中的战斗"
L["Battlegrounds"] = "战场"
L["BCC"] = "燃烧的远征"
L["Black Morass"] = "黑暗沼泽"
L["Black Temple"] = "黑暗神殿"
L["Blackfathom Deeps"] = "黑暗深渊"
L["Blackrock Depths"] = "黑石深渊"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade's Edge Mountains"] = "刀锋山"
L["Blasted Lands"] = "诅咒之地"
L["Block drunken spam"] = "屏蔽醉酒提示"
L["Block duel spam"] = "屏蔽决斗提示"
L["Block duels"] = "屏蔽决斗信息"
L["Block friend requests"] = "屏蔽好友申请"
L["Block party invites"] = "屏蔽队伍邀请"
L["Brooms"] = "扫帚"
L["Block shared quests"] = "屏蔽共享任务"
L["Block spell links during combat"] = "屏蔽战斗中的法术链接"
L["Blocks"] = "屏蔽"
L["Bloodmyst Isle"] = "秘血岛"
L["Booty Bay"] = "藏宝海湾"
L["Bottom"] = "底部"
L["Brackenwall Village"] = "蕨墙村"
L["Buffs"] = "Buffs"
L["Burning Crusade"] = "燃烧的远征"
L["Burning Crusade Classic"] = "燃烧的远征-旧世经典"
L["Burning Steppes"] = "燃烧平原"
L["Buttons"] = "按钮"
L["Buttons for the addons listed below will remain visible."] = "下面列出的插件按钮将保持可见"
L["Buyout Only"] = "仅限一口价"
L["by Leatrix Plus"] = "by Leatrix Plus"
L["C"] = "披风"
L["Camera distance"] = "镜头距离"
L["Camp Mojache"] = "莫沙彻营地"
L["Camp Taurajo"] = "陶拉霍营"
L["Cannot announce in this zone."] = "无法在这个地区通报。"
L["Cannot find General chat channel."] = "无法找到可用的默认聊天频道。"
L["Cenarion Hold"] = "塞纳里奥要塞"
L["Chain style"] = "边框样式"
L["Character"] = "角色"
L["Chat"] = "聊天功能"
L["Chat Frame"] = "聊天窗口"
L["Checkbox labels are Ok."] = "复选框信息检查通过"
L["Chillwind Camp"] = "冰风岗"
L["Chillwind E'ko"] = "冰风魂精"
L["Chimes"] = "钟声"
L["Cinematics"] = "过场动画"
L["Claiming Arathi Basin"] = "占领阿拉希盆地"
L["Class colored frames"] = "框体职业染色"
L["Class icon portraits"] = "职业图标替换"
L["Classic"] = "经典"
L["click here for new selection"] = "点击此处跳转下一曲目"
L["Click to configure the settings for this option."] = "点击进行额外的选项设置"
L["Click to disable Titan Panel screen adjust.  Your UI will be reloaded."] = "点击以禁用泰坦条窗口自适应，你的插件将重新载入。"
L["Click to reset the settings on this page."] = "点击重置此页面的设置。"
L["Click to resize the screen to fit between the top and bottom borders."] = "点击重设屏幕尺寸以适配上下边框"
L["Click to return to the main menu."] = "点击返回到主菜单"
L["Click to toggle the addon buttons editor."] = "点击以切换插件按钮编辑器"
L["Cloak"] = "披风"
L["Close"] = "关闭"
L["Cluster scale"] = "集群缩放"
L["Coilfang Reservoir"] = "盘牙水库"
L["Combat log cannot be hidden while undocked."] = "战斗记录窗口被分离时无法隐藏。"
L["Combat plates"] = "自动开关姓名板"
L["Combine addon buttons"] = "合并插件按钮"
L["Completed."] = "已完成。"
L["Concerted Efforts"] = "共同的努力"
L["Configuration Panel"] = "设置面板"
L["Connections for"] = "连接到"
L["Conquering Arathi Basin"] = "征服阿拉希盆地"
L["CONTROL"] = "CTRL"
L["Credits"] = "Credits"
L["Crossroads"] = "十字路口"
L["Cursor"] = "光标"
L["Cursor Left"] = "光标左侧"
L["Cursor Right"] = "光标右侧"
L["D"] = "地城"
L["Darkmoon Faire"] = "暗月马戏团"
L["Darkshire"] = "夜色镇"
L["Darkshore"] = "黑海岸"
L["Deadmines"] = "死亡矿井"
L["Deadwind Pass"] = "逆风小径"
L["Delay"] = "延迟"
L["Desolace"] = "凄凉之地"
L["Dire Maul"] = "厄运之槌"
L["Disable bag automation"] = "禁用自动背包"
L["Disable chat fade"] = "禁用聊天窗口淡出"
L["Disable loot warnings"] = "禁用拾取通报"
L["Disable screen effects"] = "禁用屏幕特效"
L["Disable screen glow"] = "禁用屏幕泛光"
L["Disable sticky chat"] = "禁用聊天频道粘滞"
L["Dismount me"] = "自动解散坐骑"
L["Dismount when casting a spell while moving"] = "移动中施法时解锁坐骑"
L["Dismount when clicking a flight destination"] = "选择飞行目的地时解锁坐骑"
L["Dismount when not enough rage, mana or energy"] = "当怒气、魔法或能量不足时解锁坐骑"
L["Dismount when the flight map opens"] = "当飞行地图打开时解散坐骑"
L["Drag the frame overlay to position the frame."] = "拖动框体边框来移动。"
L["Drag the frame overlay to position the frame.|n|nThis panel will close automatically if you enter combat."] = "拖动面板边框来移动它。|n|n这个面板会在进入战斗时自动隐藏。"
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "移动面板来定位框体。|n|n如果想要改变框体尺寸，你需选定面板，然后移动滑块来选择。|n|n你一旦进入战斗，这个框体会自动关闭。"
L["Drag to set the buffs frame scale."] = "拖动以调整Buff框体缩放。"
L["Drag to set the cluster scale.|n|nNote: Adjusting the cluster scale affects the entire cluster including frames attached to it such as the buffs frame and objectives tracker.|n|nIt will also cause the default UI right-side action bars to scale when you login.  If you use the default UI right-side action bars, you may want to leave this at 100%."] = "拖动以设置小地图集群缩放。|n|n调整此选项会影响诸多依附于该集群的UI元素，比如Buff框体以及任务框体。|n|n这个也会在你登录游戏时影响默认的右侧动作条的缩放。如果你使用默认动作条，建议将此选项设置为100%。"
L["Drag to set the cursor X offset."] = "拖拽以设置光标横向偏移。"
L["Drag to set the cursor Y offset."] = "拖拽以设置光标纵向偏移。"
L["Drag to set the density of weather effects."] = "拖动以调整天气效果的密度。"
L["Drag to set the focus frame scale."] = "拖动以调整焦点框体尺寸。"
L["Drag to set the font size of book text."] = "拖动以调整文本字体的大小。"
L["Drag to set the font size of mail text."] = "拖动以调整邮件文本大小。"
L["Drag to set the font size of quest text."] = "拖动以调整任务文本大小。"
L["Drag to set the minimap scale.|n|nAdjusting this slider makes the minimap and all the elements bigger."] = "拖动以设置小地图缩放。|n|n调整这个滑块，会让小地图以及附着的相关元素同步缩放。"
L["Drag to set the number of milliseconds before you are automatically released.|n|nYou can hold down shift as the timer is ending to cancel the automatic release."] = "拖动以设置自动释放的延迟数值。|n|n你可以在延迟计时结束前按住Shift以终止本次释放。"
L["Drag to set the scale of the Leatrix Plus panel."] = "拖动以调整LeatrixPlus面板缩放。"
L["Drag to set the scale of the selected frame."] = "拖动以调整所选中面板的缩放。"
L["Drag to set the size of the bottom border."] = "拖动以调整底部边框。"
L["Drag to set the size of the left border."] = "拖动以调整左侧边框。"
L["Drag to set the size of the right border."] = "拖动以调整右侧边框。"
L["Drag to set the size of the top border."] = "拖动以调整顶部边框。"
L["Drag to set the square minimap size.|n|nAdjusting this slider makes the minimap bigger but keeps the elements the same size."] = "拖动以设置小地图尺寸。|n|n调整滑块可以修改小地图的尺寸，但是不会修改相关附着元素的尺寸。"
L["Drag to set the tooltip scale."] = "拖动以调整鼠标提示的缩放。"
L["Drag to set the transparency of the borders."] = "拖动以调整边框透明度。"
L["Drag to set the transparency of the Leatrix Plus panel."] = "拖动以调整LeatrixPlus面板的透明度。"
L["Drag to set the widget scale."] = "拖动以调整微件框体缩放。"
L["Drag to size"] = "拖动尺寸"
L["Dun Morogh"] = "丹莫罗"
L["Dungeons"] = "地下城"
L["Dup ID"] = "复制的ID"
L["durability"] = "耐久度"
L["Durability"] = "耐久度"
L["Duration"] = "持续时间"
L["Durotar"] = "杜隆塔尔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "尘泥沼泽"
L["Eastern Kingdoms"] = "东部王国"
L["Eastern Plaguelands"] = "东瘟疫之地"
L["Easy item destroy"] = "快速物品摧毁"
L["ELITE"] = "精英"
L["Elwynn Forest"] = "艾尔文森林"
L["Enable viewport"] = "画面视口"
L["Enhance dressup"] = "增强换装预览"
L["Enhance minimap"] = "小地图增强"
L["Enhance professions"] = "专业面板增强"
L["Enhance quest log"] = "任务面板拓展"
L["Enhance tooltip"] = "鼠标提示增强"
L["Enhance trainers"] = "增强训练面板"
L["Enhancements"] = "增强功能"
L["Enter"] = "输入"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "输入你想要监控的法术ID。|n|n如果这个法术来自于你的宠物，请勾选宠物复选框。|n|n法术图标会按职业进行保存。"
L["enter zone or track name"] = "输入区域或者曲目名称"
L["Error messages will be hidden"] = "错误信息已屏蔽。"
L["Error messages will be shown"] = "错误信息已显示。"
L["Events"] = "事件"
L["Everlook"] = "永望镇"
L["Eversong Woods"] = "永歌森林"
L["Exclude Alterac Valley"] = "不含奥特兰克山谷"
L["Exclude BugSack"] = "不含BugSack"
L["Exclude combat resurrection"] = "不包括战复"
L["Extras"] = "其他"
L["False"] = "错误"
L["Faster auto loot"] = "加速自动拾取"
L["Faster movie skip"] = "快速跳过短片"
L["Feathermoon"] = "羽月要塞"
L["Features"] = "功能"
L["Felwood"] = "费伍德森林"
L["Feralas"] = "菲拉斯"
L["Fight for Warsong Gulch"] = "战歌峡谷之战"
L["Filter chat messages"] = "过滤聊天信息"
L["Find Item"] = "查找物品"
L["Firewing Signets"] = "火翼徽记"
L["Fizzle"] = "嘶鸣"
L["Flame Crest"] = "烈焰峰"
L["Flight details"] = "飞行信息"
L["Focus"] = "焦点"
L["For all of the social options above, you can treat guild members as friends too."] = "对于上面的所有社交设置，你可以处理好友的方式处理公会成员。"
L["For Great Honor"] = "无上的荣耀"
L["Frames"] = "框体相关"
L["Freewind Post"] = "乱风岗"
L["Frostmaul E'ko"] = "霜槌魂精"
L["Frostsaber E'ko"] = "霜刃魂精"
L["Gadgetzan"] = "加基森"
L["Game Options"] = "游戏设置"
L["General"] = "通用"
L["Ghost"] = "灵魂状态框体"
L["Ghostlands"] = "幽魂之地"
L["Gloomy"] = "主题：阴暗"
L["Gnomeregan"] = "诺莫瑞根"
L["Gold Only"] = "仅输入金币"
L["Graphics and Sound"] = "界面和音效"
L["Grom'gol"] = "格罗姆高"
L["Groups"] = "队伍"
L["Guild"] = "公会"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "古拉巴什、邪枝和枯木硬币"
L["Gyrocopters"] = "螺旋机"
L["H"] = "头盔"
L["Hammerfall"] = "落锤镇"
L["Haunted"] = "主题：鬼怪"
L["Have mats?"] = "材料齐备"
L["Hellfire Peninsula"] = "地狱火半岛"
L["Hellfire Ramparts"] = "地狱火城墙"
L["Helm"] = "头盔"
L["Help"] = "帮助"
L["Hide action button text"] = "隐藏动作条文本"
L["Hide addon buttons"] = "隐藏插件按钮"
L["Hide alerts"] = "隐藏通知"
L["Hide chat buttons"] = "隐藏聊天窗口按钮"
L["Hide cooldown duration numbers (if enabled)"] = "隐藏冷却计时（若启用）"
L["Hide error messages"] = "隐藏错误信息"
L["Hide gryphons"] = "隐藏动作条狮鹫"
L["Hide keybind text"] = "隐藏快捷键文字"
L["Hide macro text"] = "隐藏宏文字"
L["Hide portrait numbers"] = "隐藏头像数字"
L["Hide stance bar"] = "隐藏姿态条"
L["Hide the combat log"] = "隐藏战斗记录窗口"
L["Hide the world map button"] = "隐藏世界地图按钮"
L["Hide the zone text bar"] = "隐藏区域信息"
L["Hide the zoom buttons"] = "隐藏缩放按钮"
L["Hide tooltips"] = "隐藏工具提示"
L["Hide tooltips for world units during combat"] = "战斗中隐藏窗口"
L["Hide zone text"] = "隐藏区域文本"
L["High"] = "高"
L["Hillsbrad Foothills"] = "希尔斯布莱德丘陵"
L["Hinterlands"] = "辛特兰"
L["Home"] = "主页"
L["Hover the pointer over a button."] = "在按钮上指向指示器。"
L["Hyjal Summit"] = "海加尔山"
L["Ice Thistle E'ko"] = "冰草魂精"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "勾选后，会在背包及银行界面显示搜索框。"
L["If checked, a button will be added to the character frame which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "勾选后，一个按钮会显示在角色框体，其鼠标提示信息会显示身上的装备耐久度。|n|n当你死后，你的整体耐久度也会显示在聊天框体。"
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant and not queued for a battleground.|n|nFriends who message the keyword using Battle.net will not be sent a group invite if they are appearing offline.  They need to either change their online status or use character whispers."] = "勾选后，当你不在队伍中，或者有队伍管理权限时，自动邀请那些对你发送密语关键词的玩家。当你在处于随机队列中不生效。|n|n当好友处于隐身时发送战网消息，不会触发邀请。需要其修改在线状态或者使用角色密语时才能生效。"
L["If checked, a master volume slider will be shown in the character frame."] = "勾选后，一个音量调整滑块会显示在你角色页面。"
L["If checked, a power bar will be shown in the player frame when you are playing a shapeshifted druid."] = "勾选后，对于切换形态的德鲁伊，在玩家框体下方显示能量条。"
L["If checked, a repair summary will be shown in chat when your gear is automatically repaired."] = "勾选后，当你自动修理后会在聊天窗口打印本次修理结算。"
L["If checked, a vendor summary will be shown in chat when junk is automatically sold."] = "勾选后，当你的垃圾物品自动售出后会在聊天窗口打印本次售出结算。"
L["If checked, A'dal in Shattrath City will be muted."] = "勾选后，静音沙塔斯的阿达尔音效。"
L["If checked, additional font sizes will be available in the chat frame font size menu."] = "勾选后，你可以在聊天框设置更多的字体尺寸。"
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "勾选后，会增强你的拍卖行窗口。|n|n一口价：商品上架时自动同步起拍价和一口价。|n|n取整：自动将铜币与银币设置为99。|n|n搜索：搜索拍卖行中你正售卖的物品。|n|n额外的，拍卖持续时间将设置为账号共享。"
L["If checked, addon buttons will be combined into a single button frame which you can toggle by right-clicking the minimap.|n|nNote that enabling this option will lock out the 'Hide addon buttons' setting."] = "勾选后，插件按钮会被整合在一起，你可以右键点击小地图打开它。|n|n启用这个选项会锁定设置“隐藏插件按钮”。"
L["If checked, addon buttons will be hidden while the pointer is not over the minimap."] = "勾选后，插件按钮仅当你指向小地图时显示。"
L["If checked, alert frames will not be shown."] = "勾选后，通知提示框体不再显示。"
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾选后，当你访问商贩时将自动出售背包中的杂物。|n|n当你访问时按住Shift键，可以暂时忽略该功能。"
L["If checked, an animation slider will be shown in the dressing room."] = "勾选后，一个动画滑块会显示在试衣间。"
L["If checked, available quests will be accepted automatically."] = "勾选后，你将自动接受可用的任务。"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "勾选后，信息窗口的边框会更改为蓝色（右方）或者红色（敌方）。"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "勾选后，战网好友申请会自动屏蔽。|n|n启用后，当前待处理的申请会自动拒绝。"
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "勾选后，聊天窗口的按钮会被隐藏。|n|n点击窗口标签会自动显示最新的消息。|n|n使用鼠标滚轮可以查看历史消息。按住SHIFT进行消息页面跳转，按住CTRL将滚动至消息页首/页尾。"
L["If checked, chat text will not fade out after a time period."] = "勾选后，聊天信息不会在一定时间后淡出。"
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "勾选后，会在玩家、目标和焦点面板启用职业颜色。"
L["If checked, class colors will be used in the chat frame."] = "勾选后，职业颜色将应用于聊天窗口。"
L["If checked, class icons will be shown in the portrait frames.|n|nNote that this option may reduce framerate while the target of target window is showing."] = "勾选后，职业图标会替换显示在头像框体上。|n|n当目标的目标显示时，这个选项可能会导致些许帧数下降。"
L["If checked, clock hourly chimes will be muted."] = "勾选后，静音每小时的钟声音效。"
L["If checked, completed quests will be turned-in automatically."] = "勾选后，已完成的任务会自动提交。"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "勾选后，当你选择Roll点或者想要出售/邮寄一个可交易物品时，不再显示确认信息。"
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "勾选后，冷却计时数字不再显示。|n|n如果未勾选，在界面-动作条中启用冷却计时后，在相关的冷却中的法术图标会显示计时数字。"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "勾选后，在玩家头像和宠物头像上的伤害及治疗数字不再显示。"
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "勾选后，对锁定的聊天窗口进行拖动，会使其竖直拉伸。|n|n对已解锁的聊天窗口进行拖动，会使其移动。"
L["If checked, drunken messages will be blocked unless they apply to your character.|n|nThis applies to the system channel."] = "勾选后，屏蔽他人的醉酒提示。|n|n这个生效于系统消息频道。"
L["If checked, duel requests will be blocked unless the player requesting the duel is a friend."] = "勾选后，屏蔽陌生人的决斗提示。"
L["If checked, duel victory and retreat messages will be blocked unless your character took part in the duel.|n|nThis applies to the system channel."] = "勾选后，屏蔽他人的决斗胜负信息。|n|n这个作用于系统消息频道。"
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "勾选后，当你休息或处于黑铁酒吧时，禁用表情音效。|n|n在其他状态下，将恢复表情音效。"
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "勾选后，敌对姓名板会在战斗中自动开启，离开战斗后关闭。"
L["If checked, flight times will be shown in the flight map and when you take a flight."] = "勾选后，当你使用飞行交通时，会在飞行地图上显示行程耗时。"
L["If checked, group invites will only be sent to friends.|n|nIf unchecked, group invites will be sent to everyone."] = "勾选后，仅对好友发送组队邀请。|n|n若未勾选，则发送邀请给所有人。"
L["If checked, guild ranks will be shown for players in your guild."] = "勾选后，显示公会成员的会阶等级。"
L["If checked, guild ranks will be shown for players who are not in your guild."] = "勾选后，显示非公会成员的会阶等级。"
L["If checked, gyrocopters will be muted.|n|nThis applies to the engineering flying machine mounts."] = "勾选后，螺旋机的音效将静音。|n|n这主要应用于工程的螺旋机坐骑。"
L["If checked, helm and cloak toggle checkboxes will be shown in the character frame.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "勾选后，会在角色面板显示头盔及披风的开关复选框。|n|n你可以按住Shift键的同时，右键点击复选框切换排列。"
L["If checked, holiday event sounds will be muted.|n|nThis applies to Headless Horseman."] = "勾选后，节日事件声音将静音。|n|n这个应用于无头骑士。"
L["If checked, item buttons will be shown in the dressing room.  You can click the item buttons to remove individual items from the model."] = "勾选后，在试衣间添加一个物品按钮。你可以点击该按钮从角色模型上移除物品。"
L["If checked, macro and keybind text will not be shown on action buttons."] = "勾选后，隐藏动作条上的宏及快捷键文本。"
L["If checked, members of your guild will be treated as friends for all of the options on this page."] = "勾选后，对于本页所有选项，你将以处理好友的方式处理公会成员。"
L["If checked, messages containing spell links will be blocked while you are in combat.|n|nThis is useful for blocking spell interrupt spam.|n|nThis applies to the say, party, raid, instance and emote channels."] = "勾选后，当你在战斗中时，屏蔽所有法术链接。|n|n这个主要用于屏蔽打断提示的刷屏。|n|n这个作用于说话、小队、团队、副本及表情频道。"
L["If checked, non-standard minimap buttons will be replaced with standard LibDBIcon buttons.|n|nThis will fix the problems with non-standard buttons such as not hiding automatically, not following the minimap shape and not being placed in the button frame.|n|nNote that enabling or disabling non-standard buttons may require a UI reload to take effect.|n|nMost addons already use the standard LibDBIcon library and will not be affected by this setting but a few addons still use non-standard buttons.|n|nPlease ask addon authors to use the standard LibDBIcon library for their minimap buttons then this setting won't be necessary."] = "勾选后，不标准的小地图按钮会以LibDBIcon为基准进行替换。|n|n主要用于修复无法自动隐藏，不会跟随地图形状移动的小地图图标。|n|n每次切换开关，你需要重新载入插件方可生效。|n|n对于绝大多数小地图图标，都是基于LibDBIcon的标准。|n|n请联系那些未使用LibDBIcon的插件作者改进这个情况。"
L["If checked, party invitations from friends will be automatically accepted unless you are queued for a battleground."] = "勾选后，当你不处于战场队列中时，自动接收来自好友的组队邀请。"
L["If checked, party invitations will be blocked unless the player inviting you is a friend."] = "勾选后，屏蔽陌生人的组队邀请。"
L["If checked, quest levels will be shown."] = "勾选后，显示任务等级。"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically."] = "勾选后，任务会自动交接。|n|n需上缴金币的任务不会自动交接。"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "勾选后，团队和副本聊天信息会改为蓝色（与小队一致）。"
L["If checked, resurrection requests will be accepted automatically."] = "勾选后，自动接收战复。"
L["If checked, resurrection requests will not be automatically accepted if the player resurrecting you is in combat."] = "勾选后，在战斗中自动接受战复。"
L["If checked, Screech will be muted.|n|nThis is a spell used by some flying pets."] = "勾选后，静音尖叫音效。|n|n这个用于一些飞行宠物的音效。"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "勾选后，在Buff框体和目标头像下方的相关法术图标的鼠标提示框中，会显示它们的法术ID。"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "勾选后，会禁用聊天频道的粘滞。|n|n此选项不会影响临时对话窗口。"
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "勾选后，当你不处于战斗状态时会自动接受召唤。"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "勾选后，插件列表（游戏菜单处）会显示默认的对角色生效的插件。"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "勾选后，自动拾取的耗时将会明显降低。"
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "勾选后，背包及银行的整理按钮不再显示。"
L["If checked, the BugSack addon minimap button will always be visible if you have BugSack installed and the minimap button enabled."] = "勾选后，BugSack图标将始终可见，不会被收纳进图标收集。"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "勾选后，打开团队信息的按钮会显示在左侧团队管理框体的上方，而不是在其内部。|n|n此选项让你无需打开团队管理框体，就可以切换团队框体。"
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "勾选后，战斗记录会被隐藏。|n|n战斗记录窗口必须未被分离时才能生效。|n|n如果战斗记录窗口被分离了，你可以拖动其合并至主窗口（然后重载插件），或者在聊天设置中重置设置。"
L["If checked, the editbox will be moved to the top of the chat frame."] = "勾选后文本框会被移动至聊天窗口上方。"
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "勾选后，将关闭死亡后的灵魂世界特效和渐隐时的特殊光效。"
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "勾选后，界面、聊天标签以及游戏菜单的按钮点击音效将静音。"
L["If checked, the main bar gryphons will not be shown."] = "勾选后，动作条两边的狮鹫不再显示。"
L["If checked, the minimap shape will be square."] = "勾选后，小地图尺寸调整为方形。"
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "勾选后，会在行囊图标处显示剩余背包空间。"
L["If checked, the player frame background will be shown in class color."] = "勾选后，玩家头像面板的背景将用职业颜色染色。"
L["If checked, the professions frame will be larger."] = "勾选后，将拓展专业面板。"
L["If checked, the ready check sound will be muted."] = "勾选后，去除就位确认的音效。"
L["If checked, the scale slider will apply to the entire minimap cluster.|n|nNote that if you are using the default action bars, rescaling the cluster will also rescale the right action bars at startup so you may want to leave the scale slider at 100%.|n|nIf unchecked, the scale slider will only apply to the minimap."] = "勾选后，缩放的滑块设置生效于小地图集群。|n|n如果你启用了默认的动作条，缩放小地图集群会同时修改右侧动作条的缩放。所以最好将缩放设置为100%。|n|n若未勾选，则缩放只生效于小地图。"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "勾选后，屏幕泛光会被禁用。|n|n启用这个选项的同时，也会关闭醉酒时的泛光效果。"
L["If checked, the skill trainer frame will be larger and feature a train all skills button."] = "勾选后，拓宽训练师面板，并添加一个学习全部配方的按钮。"
L["If checked, the spell fizzle sounds will be muted."] = "勾选后，去除法术施放音效。"
L["If checked, the stance bar will not be shown."] = "勾选后，姿态条不再显示。"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "勾选后，对话面板不再显示。|n|n当NPC与你交流时，该框体通常出现在界面下方。"
L["If checked, the target frame background and focus frame background will be shown in class color."] = "勾选后，目标和焦点框体的背景会以职业颜色显示。"
L["If checked, the target frame background will be shown in class color."] = "勾选后，目标头像面板的背景将用职业颜色染色。"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "勾选后，鼠标信息会被着色，你可以设置他的布局和大小尺寸。"
L["If checked, the vendor price will be shown in item tooltips."] = "勾选后，将在物品的鼠标提示中显示其卖价。"
L["If checked, the world map button will be hidden."] = "勾选后，隐藏世界地图按钮。"
L["If checked, the zone text bar will be hidden."] = "勾选后，隐藏区域文本信息。"
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "勾选后，缩放按钮会被隐藏。你可以使用鼠标滚来来对小地图进行缩放。"
L["If checked, train sounds will be muted."] = "勾选后，去除火车音效。"
L["If checked, unit targets will be shown."] = "勾选后，目标的目标会显示在信息窗口上。"
L["If checked, when someone pings the minimap, their name will be shown.  This does not apply to your pings."] = "勾选后，显示谁点击了小地图。如果是你自己点击的，则不显示相关信息。"
L["If checked, Wowhead links will go directly to the comments section."] = "勾选后，wowhead链接直接调整至备注。"
L["If checked, yawns from hunter pet cats will be muted."] = "勾选后，屏蔽猎人猫科宠物的打哈欠音效。"
L["If checked, you can block spell links, drunken spam and duel spam."] = "勾选后，你可以屏蔽法术链接，醉酒提示以及决斗信息。"
L["If checked, you can hold alt and drag the minimap to move it."] = "勾选后，你可以按住Alt键来拖动小地图。"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "勾选后，你可以按住CTRL键，点击聊天标签来打开相应的历史记录窗口，以供复制。"
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "勾选后，你可以使用方向键移动文本框中的光标。|n|n如果未被勾选，方向键将保持它所绑定的按键功能。"
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "勾选后，你无需确认即可快速跳过过场短片。"
L["If checked, you will be able to change the font size of book text."] = "勾选后，你可以调整文本字体的大小。"
L["If checked, you will be able to change the font size of quest text."] = "勾选后，你可以调整任务文本的字体大小。"
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "勾选后，你可以更改邮件文本的字体大小。|n|n这个选项不会影响系统邮件模版（例如拍卖行的收据信息）。"
L["If checked, you will be able to change the position and scale of the buffs frame."] = "勾选后，你可以修改Buff框体的位置和缩放。"
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "勾选后，你可以修改微件框体的缩放和位置。|n|n微件框体通常用于显示PVP占点计时以及目标追踪等。"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "勾选后，你会生成一个画面视口，这个可以在游戏界面周围增加黑色的边框背景。|n|n边框的层级是处于游戏界面和插件之间，所以你仍可以放置插件元素在上面。"
L["If checked, you will be able to customise the minimap."] = "勾选后，你可以开启小地图相关的自定义选项。"
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "勾选后，你可以把聊天窗口拖动到屏幕边缘。"
L["If checked, you will be able to mute a selection of game sounds."] = "勾选后，你可以去除部分游戏音效。"
L["If checked, you will be able to pan (right-button) and zoom (mousewheel) in the character frame, dressup frame and inspect frame.|n|nA toggle stats button will be shown in the character frame.  You can also middle-click the character model to toggle stats.|n|nModel rotation controls will be hidden.  Buttons to toggle gear will be added to the dressup frame."] = "If checked, you will be able to pan (right-button) and zoom (mousewheel) in the character frame, dressup frame and inspect frame.|n|nA toggle stats button will be shown in the character frame.  You can also middle-click the character model to toggle stats.|n|nModel rotation controls will be hidden.  Buttons to toggle gear will be added to the dressup frame."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "勾选后，你可以在目标框体上方监控至多5个的法术监控。"
L["If checked, you will be able to reposition the tooltip."] = "勾选后，你可以重新给鼠标提示框设置锚点。"
L["If checked, you will be able to set some additional rules for when your character is automatically dismounted."] = "勾选后，你可以为自动解锁坐骑设定一些额外的规则。"
L["If checked, you will be able to set the density of weather effects."] = "勾选后，你可以调整天气密度。"
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "勾选后，会在玩家框体显示稀有、精英或者稀有精英的边框。"
L["If checked, you will be able to zoom out to a greater distance."] = "勾选后，你可以加大镜头的缩放距离。"
L["If checked, you will be dismounted when you attempt to cast a non-instant cast spell while moving."] = "勾选后，当你处于移动中时，释放一个非瞬发法术会自动解锁坐骑。"
L["If checked, you will be dismounted when you attempt to cast a spell but don't have the rage, mana or energy to cast it."] = "勾选后，当你的职业资源不足以施法时，会自动解锁坐骑。"
L["If checked, you will be dismounted when you click a flight destination."] = "勾选后，当你选择一个飞行目的地时，自动解锁坐骑。"
L["If checked, you will be dismounted when you instruct a flight master to open the flight map."] = "勾选后，当你和飞行管理员对话，并打开飞行地图时，自动解锁坐骑。"
L["If checked, you will need to hold the override key down for quests to be automated.|n|nIf unchecked, holding the override key will prevent quests from being automated."] = "勾选后，你需要按住预设按键来自动交互任务。|n|n若未勾选，则按住预设键会阻止任务自动交接。"
L["If checked, you will no longer need to type delete when destroying a superior quality item.|n|nIn addition, item links will be shown in all item destroy confirmation windows."] = "勾选后，当你摧毁高品质物品时不再需要输入DELETE。|n|n同时，物品链接会显示在摧毁确认窗口。"
L["If checked, you will not release automatically in Alterac Valley."] = "勾选后，你不再在奥特兰克山谷中自动释放尸体。"
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "勾选后，当你在战场中阵亡时会自动进行释放。|n|n如果你有复生能力，则不会进行自动释放。"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "勾选后，你的聊天历史记录会增涨至4096行。如果未被勾选，会保持在默认的128行。|n|n启用这个设置可能会在登录时会隐藏一些聊天信息。"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾选后，当你打开一个可供修理的商贩时，会自动修理身上的装备。|n|n当你打开商贩时，按住SHIFT键会让你当下忽略此项功能。"
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "勾选后，区域文本不再显示。"
L["If you use the 'Hide addon buttons' or 'Combine addon buttons' settings but you want some addon buttons to remain visible around the minimap, enter the addon names into the editbox separated by a comma.|n|nThe editbox tooltip shows the addon names that you can enter.  The names must match exactly with the names shown in the editbox tooltip though case does not matter.|n|nChanges to the list will require a UI reload to take effect."] = "If you use the 'Hide addon buttons' or 'Combine addon buttons' settings but you want some addon buttons to remain visible around the minimap, enter the addon names into the editbox separated by a comma.|n|nThe editbox tooltip shows the addon names that you can enter.  The names must match exactly with the names shown in the editbox tooltip though case does not matter.|n|nChanges to the list will require a UI reload to take effect."
L["Increase chat history"] = "增加聊天历史记录"
L["Interface"] = "界面设置"
L["Invaders of Alterac Valley"] = "奥特兰克的入侵者"
L["Login"] = "登录"
L["Invalid console variable."] = "无效控制台缓存。"
L["Invalid parameter."] = "无效参数"
L["Invalid quest ID."] = "无效的任务ID。"
L["Invalid sound ID"] = "无效的声音ID"
L["Invalid taint level."] = "无效的污染等级。"
L["Invalid target."] = "无效目标。"
L["Invite from whispers"] = "密语邀请"
L["Ironforge"] = "铁炉堡"
L["Kalimdor"] = "卡利姆多"
L["Karazhan"] = "卡拉赞"
L["Kargath"] = "卡加斯"
L["Keep audio synced"] = "保持音频同步"
L["Keyword"] = "关键词"
L["Lakeshire"] = "湖畔镇"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "下次登出时不会清空LeatrixPlus的插件缓存。"
L["Levels"] = "等级"
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "警告：你使用了错误的LeatrixPlus插件版本。"
L["Left"] = "左边"
L["Lifetime honorable kills"] = "荣誉击杀总数"
L["Light's Hope Chapel"] = "圣光之愿礼拜堂"
L["Links go directly to the comments section"] = "链接调整至备注"
L["Loch Modan"] = "洛克莫丹"
L["Lockout sharing"] = "成就共享锁定"
L["Low"] = "低"
L["M"] = "M"
L["Magic"] = "主题：魔法"
L["Magisters' Terrace"] = "魔导师平台"
L["Main Titles"] = "主题音乐"
L["Manage buffs"] = "Buff框体管理"
L["Manage durability"] = "耐久度管理"
L["Manage focus"] = "焦点管理"
L["Manage frames"] = "框架面板管理"
L["Manage timer"] = "计时条管理"
L["Manage vehicle"] = "载具管理"
L["Manage widget"] = "微件管理"
L["Managed by Leatrix Plus"] = "LeatrixPlus托管"
L["Map"] = "地图"
L["Maraudon"] = "玛拉顿"
L["Marks of Kil'jaeden"] = "基尔加丹印记"
L["Marks of Sargeras"] = "萨格拉斯印记"
L["Marshal's Refuge"] = "马绍尔营地"
L["Max camera zoom"] = "最大镜头距离"
L["Mechanics"] = "特性设置"
L["Mechstriders"] = "机械陆行鸟"
L["Mechsteps"] = "机械脚步声"
L["Media"] = "媒体"
L["Netherdrakes"] = "虚空龙"
L["Medium"] = "中"
L["Memory Usage"] = "内存占用"
L["Menethil Harbor"] = "米奈希尔港"
L["message shown."] = "信息显示。"
L["Messages"] = "消息"
L["messages shown."] = "信息显示。"
L["Misc"] = "杂项"
L["Missing console variable."] = "丢失控制台缓存。"
L["Missing mount name."] = "坐骑名字缺失。"
L["Missing movie ID."] = "影片编号不存在。"
L["Missing quest ID."] = "缺少任务ID。"
L["Missing sound file parameter."] = "缺失音频文件参数"
L["Missing sound ID."] = "缺少声音ID。"
L["Molten Core"] = "熔火之心"
L["Moonglade"] = "月光林地"
L["More Firewing Signets"] = "更多火翼徽记"
L["More font sizes"] = "更多字体尺寸"
L["More Marks of Kil'jaeden"] = "更多基尔加丹印记"
L["More Marks of Sargeras"] = "更多萨格拉斯印记"
L["More Sunfury Signets"] = "更多日怒徽记"
L["Morgan's Vigil"] = "摩根的岗哨"
L["Mount not found."] = "无法找到该坐骑。"
L["Mounts"] = "坐骑"
L["Move editbox to top"] = "把文本框移动上方"
L["Mute"] = "静音"
L["Movie not playable."] = "无法播放该影片。"
L["Movie number"] = "影片编号"
L["Movies"] = "电影"
L["Mulgore"] = "莫高雷"
L["Music"] = "音乐"
L["Musical Moments"] = "音乐主题时刻"
L["Mute custom sounds"] = "静音自定义音效"
L["Mute game sounds"] = "静音游戏音效"
L["Mystery"] = "主题：神秘"
L["N"] = "N"
L["Nagrand"] = "纳格兰"
L["Narration"] = "旁白"
L["Naxxramas"] = "纳克萨玛斯"
L["Nethergarde Keep"] = "守望堡"
L["Netherstorm"] = "虚空风暴"
L["Nijel's Point"] = "尼耶尔前哨站"
L["No bad sound IDs found."] = "没有发现损坏的ID。"
L["No help is available for this page."] = "此页面没有帮助信息。"
L["No items with durability equipped."] = "尚未装备任何带有耐久度的物品。"
L["No media duplicates found."] = "没有发现媒体的副本。"
L["No supported addons."] = "没有支持的插件"
L["Not minimap"] = "非小地图"
L["No tooltip showing."] = "目前没有任何提示信息。"
L["None"] = "无"
L["Not completed."] = "未完成。"
L["Note that this will not reset settings that require a UI reload."] = "这个不会重置那些需要重载插件的设置。"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "注意！|n你必须重新启动游戏客户端才可以正确加载新版本的Leatrix Plus。"
L["Nude"] = "隐藏着装"
L["Okay, disable screen adjust for me"] = "好的，禁用窗口自适应"
L["Old Hillsbrad Foothills"] = "旧希尔斯布莱德丘陵"
L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
L["or click the minimap button to open Leatrix Plus."] = "或点击小地图按钮打开Leatrix Maps。"
L["Orgrimmar"] = "奥格瑞玛"
L["Outland"] = "外域"
L["Overall"] = "总计"
L["Overlay"] = "边框"
L["Override key"] = "预设功能键"
L["Particle density"] = "粒子密度"
L["Party from friends"] = "好友组队邀请"
L["Pet"] = "宠物"
L["Pets"] = "宠物"
L["Player"] = "玩家框体"
L["Please ask the addon author to use LibDBIcon."] = "请联系插件作者支持LibDBIcon库。"
L["Play"] = "播放"
L["Power"] = "能量"
L["Press CTRL/C to copy."] = "按住CTRL+C复制"
L["Queue from friends"] = "好友队列申请"
L["R"] = "R"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "团队副本"
L["Raid frame toggle"] = "切换团队框体"
L["Random"] = "随机"
L["RARE"] = "稀有"
L["RARE ELITE"] = "稀有精英"
L["Ratchet"] = "棘齿城"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼泽"
L["Ready"] = "已就位"
L["Rhonin"] = "罗宁"
L["Ripper"] = "劫夺者"
L["Recent chat window"] = "临时聊天窗口"
L["Redridge Mountains"] = "赤脊山"
L["Refuge Pointe"] = "避难谷地"
L["Release in PvP"] = "PvP自动释放尸体"
L["Reload"] = "重载插件"
L["Remember Alterac Valley!"] = "铭记奥特兰克！"
L["Remove all items"] = "移除所有物品"
L["Remove tabard"] = "移除战袍"
L["Repair automatically"] = "自动修理装备"
L["Repaired for"] = "修理花费"
L["Replace non-standard buttons"] = "替换不标准按钮"
L["Reposition the tooltip"] = "重设提示框锚点"
L["Require override key for quest automation"] = "需要按住预设功能键来自动交互"
L["Requires UI reload."] = "需要重载插件"
L["Reset"] = "重置"
L["Resize book text"] = "文本字体调整"
L["Resize mail text"] = "重设邮件文本"
L["Resize quest text"] = "重设任务文本"
L["Resize Screen"] = "屏幕缩放"
L["Rested bubbles"] = "休息气泡信息"
L["Restore chat messages"] = "恢复聊天信息"
L["Restrict to friends"] = "好友限定"
L["result"] = "结果"
L["results"] = "结果"
L["Return"] = "返回"
L["Revantusk Village"] = "恶齿村"
L["Right"] = "右边"
L["Right-click to close"] = "右键关闭"
L["Right-click to close."] = "右键点击关闭。"
L["right-click to go back"] = "右键点击返回"
L["Ruins of Ahn'Qiraj"] = "安其拉废墟"
L["Rut'theran Village"] = "鲁瑟兰村"
L["Sacred"] = "主题：恐怖"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "沙怒、碎颅和血顶硬币"
L["Scale"] = "尺寸"
L["Scale entire cluster"] = "缩放整个集群"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通灵学院"
L["Screech"] = "尖啸"
L["Search"] = "搜索"
L["Search mats?"] = "搜索材料"
L["Searing Gorge"] = "灼热峡谷"
L["seconds"] = "秒"
L["seconds does not match the saved flight time of"] = "耗时不匹配预设的飞行计时"
L["Select the settings that you want to use."] = "选择你想启用的设置。"
L["Selection of music tracks"] = "音乐列表的选择"
L["Self Markers Allowed"] = "允许自我标记"
L["Self Markers Blocked"] = "屏蔽自我标记"
L["Sell junk automatically"] = "自动出售杂物"
L["SELLING JUNK"] = "出售杂物"
L["Sentinel Hill"] = "哨兵岭"
L["Set weather density"] = "调整天气密度"
L["Settings"] = "设置"
L["Shaders"] = "阴影"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Valley"] = "影月谷"
L["Shadowprey Village"] = "葬影村"
L["Shardtooth E'ko"] = "碎齿魂精"
L["SHIFT"] = "SHIFT"
L["Show animation slider"] = "显示动效滑块"
L["Show auction controls"] = "显示拍卖行控制"
L["Show bag search box"] = "显示背包搜索框"
L["Show character addons"] = "显示角色插件"
L["Show cooldowns"] = "显示冷却计时"
L["Show cooldowns above the player frame"] = "显示冷却计时在玩家框体上方"
L["Show druid power bar"] = "显示德鲁伊能量条"
L["Show durability status"] = "显示耐久度"
L["Show flight times"] = "显示飞行时间"
L["Show free bag slots"] = "显示背包剩余空间"
L["Show guild names"] = "显示公会名字"
L["Show guild ranks for other guilds"] = "显示非公会成员会阶"
L["Show guild ranks for your guild"] = "显示公会会阶"
L["Show item buttons"] = "显示物品按钮"
L["Show me"] = "显示玩家"
L["Show minimap button"] = "显示小地图按钮"
L["Show player chain"] = "显示玩家边框"
L["Show player frame in class color"] = "玩家头像职业染色"
L["Show quest levels"] = "显示任务等级"
L["Show raid button"] = "显示团队按钮"
L["Show ready timer"] = "显示准备计时"
L["Show repair summary in chat"] = "显示修理结算"
L["Show target model"] = "显示目标模型"
L["Show the spell ID in buff icon tooltips"] = "显示法术ID"
L["Show train all skills button"] = "显示训练所有技能按钮"
L["Show toggle headers button"] = "显示切换标题按钮"
L["Show cancel form button on flight map"] = "在飞行地图上显示取消变形按钮"
L["Show unit targets"] = "显示单位目标"
L["Show vanity controls"] = "显示模型控制"
L["Show vendor price"] = "显示物品卖价"
L["Show vendor summary in chat"] = "显示垃圾售卖结算"
L["Show volume slider"] = "显示音量控制"
L["Show who pinged"] = "显示谁点击小地图"
L["Show Wowhead links"] = "显示wowhead链接"
L["Silence rested emotes"] = "表情禁音"
L["Silithus"] = "希利苏斯"
L["Silverpine Forest"] = "银松森林"
L["Single Mark of Sargeras"] = "单枚萨格拉斯印记"
L["Single Sunfury Signet"] = "单枚日怒徽记"
L["Social"] = "社交信息"
L["Sold junk for"] = "杂物出售总计"
L["Sound system restarted."] = "声音系统已重启。"
L["Sound Limit"] = "声音限制"
L["Southshore"] = "南海镇"
L["Spell ID"] = "法术ID"
L["Splintertree Post"] = "碎木岗哨"
L["Spooky"] = "主题：阴森"
L["SET LIMIT"] = "设置限制"
L["MUTE ALL"] = "全部静音"
L["UNMUTE ALL"] = "取消全部静音"
L["Square minimap"] = "方形地图"
L["Square size"] = "方形尺寸"
L["Stockade"] = "暴风城监狱"
L["Stonard"] = "斯通纳德"
L["Stonetalon Mountains"] = "石爪山脉"
L["Stonetalon Peak"] = "石爪峰"
L["Stop"] = "停止"
L["Stormwind"] = "暴风城"
L["Stranglethorn Vale"] = "荆棘谷"
L["Stratholme"] = "斯坦索姆"
L["Sun Rock Retreat"] = "烈日石居"
L["Sunfury Signets"] = "日怒徽记"
L["Sunken Temple"] = "沉没的神庙"
L["Sunwell Plateau"] = "太阳之井高地"
L["Support"] = "帮助支持"
L["www.leatrix.com"] = "www.leatrix.com"
L["Supported Addons"] = "支持的插件"
L["Swamp"] = "主题：沼泽"
L["Swamp of Sorrows"] = "悲伤沼泽"
L["System"] = "系统设置"
L["T"] = "T"
L["Tabard"] = "隐藏战袍"
L["Taint level: Basic (1)."] = "污染等级：基本(1)。"
L["Taint level: Disabled (0)."] = "污染等级：禁用(0)。"
L["Taint level: Full (2)."] = "污染等级：全面(2)。"
L["Talonbranch Glade"] = "刺枝林地"
L["Talrendis Point"] = "塔伦迪斯营地"
L["Tanaris"] = "塔纳利斯"
L["Target"] = "目标框体"
L["Target Tracking Disabled"] = "禁用目标追踪"
L["Target Tracking Enabled"] = "启用目标追踪"
L["Tarren Mill"] = "塔伦米尔"
L["Teldrassil"] = "泰达希尔"
L["Tempest Keep"] = "风暴要塞"
L["Temple of Ahn'Qiraj"] = "安其拉神殿"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神庙"
L["Ten Years of Warcraft"] = "魔兽十周年"
L["Terokkar Forest"] = "泰罗卡森林"
L["Text"] = "文本信息"
L["Text size"] = "字体尺寸"
L["Text Size"] = "字体尺寸"
L["Thalanaar"] = "萨兰纳尔"
L["The game will dismount you if you successfully cast a spell without addons.  These settings let you set some additional dismount rules."] = "游戏内自带设置即可让你施法时自动解锁坐骑。这个选项让你可以添加一些额外规则。"
L["The Sepulcher"] = "瑟伯切尔"
L["The square minimap will always show the new covenant button."] = "方形地图将始终显示新盟约图标。"
L["The summon from"] = "召唤来自"
L["Thelsamar"] = "塞尔萨玛"
L["Themes"] = "主题"
L["Theramore"] = "塞拉摩"
L["There is a helpful guide on leatrix.com."] = "你可以在leatrix.com上查看帮助。"
L["This flight does not exist in the database."] = "这次的飞行尚未记录在数据库中。"
L["This flight does not have a saved duration in the database."] = "这次的飞行时间尚未记录在数据库中。"
L["This flight's actual time of"] = "这次飞行的真实耗时"
L["This is a custom button."] = "这是一个自定义按钮。"
L["This panel will close automatically if you enter combat."] = "此面板在你进入战斗后自动关闭。"
L["This slider requires 'Square minimap' to be enabled."] = "这个滑块需要启用“方形地图”选项。"
L["Thorium Point"] = "瑟银哨塔"
L["Thousand Needles"] = "千针石林"
L["Thunder Bluff"] = "雷霆崖"
L["Timer"] = "计时框体"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["Titan Panel screen adjust needs to be disabled for the frame to be saved correctly."] = "为了能正确的保存此框体，泰坦框体自适应需要被禁用。"
L["to"] = "至"
L["To begin, choose an options page."] = "请选择一项开始使用"
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "你需要禁用ElvUI的聊天模块以隐藏战斗记录。"
L["To move the minimap, hold down the alt key and drag it."] = "按住Alt键并点击拖动小地图。"
L["To move the minimap, hold down the alt key and drag it.|n|nIf you toggle an addon minimap button, you may need to reload your UI for the change to take effect.  This only affects a few addons that use custom buttons.|n|nThis panel will close automatically if you enter combat."] = "你可以按住Alt键并点击以拖动小地图。|n|n如果你开关一个小地图按钮，你需要重载插件以生效改动。这个只影响部分使用自定义图标的插件。|n|n当你进入战斗后，这个面板会自动关闭。"
L["To use the Find Item button, you need to deselect the WoW Token category."] = "你必须取消魔兽货币分类以启用寻找物品的按钮。"
L["Toggle buttons"] = "开关按钮"
L["Toggle character stats"] = "切换角色统计信息"
L["Toggle Grid"] = "切换对齐网格"
L["took"] = "花费"
L["Tooltip"] = "鼠标信息窗口"
L["Tooltip title color"] = "鼠标提示信息颜色"
L["Top"] = "顶部"
L["Top Center"] = "顶级中心"
L["Tracing started."] = "追踪开始。"
L["Tracing stopped."] = "追踪停止。"
L["Trains"] = "火车"
L["Transmogrify character preview"] = "幻化角色预览"
L["Transparency"] = "透明度"
L["Travelers"] = "旅行商人"
L["True"] = "正确"
L["Turn-in completed quests automatically"] = "自动提交任务"
L["Uldaman"] = "奥达曼"
L["Unclamp chat frame"] = "不限制窗口位置"
L["Undercity"] = "幽暗城"
L["Unmute"] = "取消静音"
L["Un'Goro Crater"] = "安戈洛环形山"
L["Universal group color"] = "统一队伍颜色"
L["Unlock the minimap"] = "解锁小地图"
L["Use arrow keys in chat"] = "允许使用方向键"
L["Use class colors in chat"] = "聊天窗口启用职业颜色"
L["Use easy resizing"] = "使用简单拉伸"
L["Valormok"] = "瓦罗莫克"
L["Value must be a number."] = "该参数必须为数字。"
L["Various"] = "其他"
L["Vendors"] = "商贩"
L["Version"] = "版本"
L["Very Low"] = "低"
L["Video"] = "视频"
L["Visibility"] = "可见性"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Warning"] = "警告"
L["was automatically declined."] = "已经自动拒绝。"
L["Weather density"] = "天气密度"
L["Welcome to Leatrix Plus."] = "欢迎使用Leatrix Plus"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "湿地"
L["Widget"] = "窗口小部件"
L["Wider character preview"] = "更宽的角色预览"
L["Wildkin E'ko"] = "枭兽魂精"
L["will be automatically accepted in 10 seconds unless cancelled."] = "将在10秒内自动接受（除非主动取消）。"
L["Winter"] = "冬日"
L["Winterfall E'ko"] = "寒水魂精"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft"] = "魔兽世界"
L["X Offset"] = "横向偏移"
L["Y Offset"] = "纵向偏移"
L["Yawns"] = "打哈欠"
L["YOU"] = "你"
L["You cannot do that in combat."] = "你无法在战斗中进行该项操作。"
L["You should keybind web link!"] = "你应该按键绑定网页链接！"
L["Zoom speed"] = "缩放速度"
L["You have"] = "你有"
L["You need to be group leader."] = "需要你是队长。"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "你需要进行重载插件后才能使部分设置生效。|n|n你无需立即点击重载插件按钮，但是你完成设置并希望其生效时，必须点击它。"
L["Your UI needs to be reloaded."] = "你的插件需要重新载入。"
L["Zangarmarsh"] = "赞加沼泽"
L["Zones"] = "区域"
L["Zoram'gar Outpost"] = "佐拉姆加前哨站"
L["Zul'Aman"] = "祖阿曼"
L["Zul'Farrak"] = "祖尔法拉克"
L["Zul'Gurub"] = "祖尔格拉布"
L["Zulian, Razzashi, and Hakkari Coins"] = "祖利安、拉扎什和哈卡莱硬币"
L["Zygor addon not found."] = "你尚未安装Zygor插件。"
L["Leatrix Plus Help"] = "Leatrix Plus 帮助"
L["Click to unmute every sound in the game."] = "点击以取消游戏中所有声音的静音。"
L["Toggle opttions panel."] = "切换选项面板。"
L["Reset addon panel position and scale."] = "重置插件面板位置和尺寸。"
L["Wipe all addon settings (reloads UI)."] = "清除所有插件设置（将重载界面）。"
L["Show realms connected to yours."] = "显示与你连接的服务器。"
L["Show number of rested XP bubbles remaining."] = "显示剩余的休息经验气泡数量。"
L["Show quest completion status for <quest id>."] = "显示任务完成状态（需要任务ID）。"
L["Wipe your quest log."] = "清除你的任务日志。"
L["Toggle a frame alignment grid."] = "切换框架对齐网格。"
L["Show a web link for whatever the pointer is over."] = "显示鼠标指针所在位置的网页链接。"
L["Toggle the Zygor addon (reloads UI)."] = "切换 Zygor 插件（将重载界面）。"
L["Play a movie by its ID."] = "通过ID播放电影。"
L["Block target markers (toggle) (requires assistant or leader in raid)."] = "阻止目标标记（切换）（需要团队助理或队长权限）。"
L["Restart the sound system."] = "重启声音系统。"
L["Announce target in General chat channel (useful for rares)."] = "在综合聊天频道中通报目标（对稀有怪有用）。"
L["Launch the developer console with a large font."] = "使用大字体启动开发者控制台。"
L["Reload the UI."] = "重载界面。"
L["Click to mute sounds in the list."] = "点击以静音列表中的声音。"
L["Click to unmute sounds in the list."] = "点击以取消列表中的声音静音。"
L["Click to toggle the frame alignment grid."] = "点击以切换框架对齐网格。"
L["Click to set the sound file limit.  Use the mousewheel on the editbox along with the step buttons below to adjust the sound limit.  Acceptable range is from 1 to 3000000.  Sound files higher than this limit will be muted."] = "点击以设置声音文件限制。使用鼠标滚轮在编辑框中，配合下方的步进按钮来调整声音限制。可接受范围为 1 到 3000000。高于此限制的声音文件将被静音。"
L["Click to mute every sound in the game."] = "点击以静音游戏中的所有声音。"
L["Set the editbox step value to 1000000."] = "将编辑框步进值设置为 1000000。"
L["Set the editbox step value to 100000."] = "将编辑框步进值设置为 100000。"
L["Set the editbox step value to 10000."] = "将编辑框步进值设置为 10000。"
L["Set the editbox step value to 1000."] = "将编辑框步进值设置为 1000。"
L["Set the editbox step value to 100."] = "将编辑框步进值设置为 100。"
L["Set the editbox step value to 10."] = "将编辑框步进值设置为 10。"
L["Set the editbox step value to 1."] = "将编辑框步进值设置为 1。"
L["You should set a keybind for the web link feature.  It's very useful.|n|nOpen the key bindings window (accessible from the game menu) and click Leatrix Plus.|n|nSet a keybind for Show web link.|n|nNow when your pointer is over an item, NPC or spell (and more), press your keybind to get a web link."] = "你应该为网页链接功能设置一个按键绑定。它非常有用。|n|n打开按键绑定窗口（可从游戏菜单访问）并点击 Leatrix Plus。|n|n为显示网页链接设置按键绑定。|n|n现在，当你的指针在物品、NPC 或法术（以及更多）上时，按下你的按键绑定以获取网页链接。"
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT-click - Toggle music.|n|nALT-click - Toggle errors (if enabled).|n|nCTRL/SHIFT-click - Toggle windowed mode.|n|nCTRL/ALT-click - Toggle Zygor (if installed)."] = "勾选后，小地图按钮将可用。|n|n点击 - 切换选项面板。|n|nSHIFT点击 - 切换音乐。|n|nALT点击 - 切换错误（如果启用）。|n|nCTRL/SHIFT点击 - 切换窗口模式。|n|nCTRL/ALT点击 - 切换 Zygor（如果已安装）。"
L["Drag to set the vehicle seat indicator frame scale."] = "拖动以设置载具座位指示器框架缩放。"
L["Drag to set the durability frame scale."] = "拖动以设置耐久度框架缩放。"
L["Drag to set the timer bar scale."] = "拖动以设置计时器框架缩放。"
L["Drag to set the cluster scale.|n|nNote: Adjusting the cluster scale affects the entire cluster including frames attached to it such as the quest watch frame.|n|nIt will also cause the default UI right-side action bars to scale when you login.  If you use the default UI right-side action bars, you may want to leave this at 100%."] = "拖动以设置小地图集群缩放。|n|n注意：调整此选项会影响诸多依附于该集群的UI元素，比如任务监控框架。|n|n这个也会在你登录游戏时影响默认的右侧动作条的缩放。如果你使用默认动作条，建议将此选项设置为100%。"
L["Drag to set the character model zoom speed."] = "拖动以设置角色模型缩放速度。"
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer, vendor, battlemaster or stable master, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "勾选后，你可以在打开对话窗口时按住 alt 键自动选择单个对话项目。|n|n如果对话项目类型是银行员、飞行点、训练师、商贩、战场军官或兽栏管理员，对话将被跳过而无需按住 alt 键。你可以按住 shift 键来防止这种情况发生。"
L["If checked, shared quests will be declined unless the player sharing the quest is a friend."] = "勾选后，除非分享任务的玩家是好友，否则任务分享将被拒绝。"
L["If checked, raid chat will be colored blue (to match the default party chat color)."] = "勾选后，团队聊天将显示为蓝色（以匹配默认的小队聊天颜色）。"
L["If checked, recent chat will be restored when you reload your interface."] = "勾选后，当你重新载入界面时，最近的聊天将被恢复。"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the alt key and click it to toggle error messages without affecting this setting."] = "勾选后，大多数错误消息（例如'怒气不足'）将不会显示。一些重要的错误被排除在外。|n|n如果你启用了小地图按钮，你可以按住 alt 键并点击它来切换错误消息，而不会影响此设置。"
L["If checked, keybind text will not be shown on action buttons."] = "勾选后，动作按钮上将不会显示快捷键文字。"
L["If checked, macro text will not be shown on action buttons."] = "勾选后，动作按钮上将不会显示宏文字。"
L["If checked, you will be able to pan (right-button) and zoom (mousewheel) in the character frame, dressup frame and inspect frame.|n|nA toggle stats button will be shown in the character frame.  You can also middle-click the character model to toggle stats.|n|nModel rotation controls will be hidden.  Buttons to toggle gear will be added to the dressup frame."] = "勾选后，你将能够在角色框架、试衣框架和观察框架中平移（右键）和缩放（鼠标滚轮）。|n|n一个切换统计按钮将显示在角色框架中。你也可以中键点击角色模型来切换统计。|n|n模型旋转控件将被隐藏。切换装备的按钮将添加到试衣框架中。"
L["If checked, you will be able to customise the quest log frame."] = "勾选后，你将能够自定义任务日志框架。"
L["If checked, a timer will be shown under the dungeon ready frame and the PvP encounter ready frame so that you know how long you have left to click the enter button."] = "勾选后，将在副本准备框架和 PvP 遭遇准备框架下显示一个计时器，以便你知道还有多长时间可以点击进入按钮。"
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "勾选后，Wowhead 链接将显示在世界地图框架和成就框架中。"
L["If checked, you will be able to change the position and scale of the player frame and target frame.|n|nNote that enabling this option will prevent you from using the default UI to move the player and target frames."] = "勾选后，你将能够更改玩家框架和目标框架的位置和缩放。|n|n请注意，启用此选项将阻止你使用默认 UI 来移动玩家和目标框架。"
L["If checked, you will be able to change the position and scale of the focus frame.|n|nNote that enabling this option will prevent you from using the default UI to move the focus frame."] = "勾选后，你将能够更改焦点框架的位置和缩放。|n|n请注意，启用此选项将阻止你使用默认 UI 来移动焦点框架。"
L["If checked, you will be able to change the position and scale of the timer bar.|n|nThe timer bar is used for showing remaining breath when underwater as well as other things."] = "勾选后，你将能够更改计时条的位置和缩放。|n|n计时条用于显示水下时的剩余呼吸以及其他内容。"
L["If checked, you will be able to change the position and scale of the armored man durability frame."] = "勾选后，你将能够更改耐久度框架的位置和缩放。"
L["If checked, you will be able to change the position and scale of the vehicle seat indicator frame."] = "勾选后，你将能够更改载具座位指示器框架的位置和缩放。"
L["If checked, alert frames will not be shown.|n|nWhen you earn an achievement, a message will be shown in chat instead."] = "勾选后，通知框架将不会显示。|n|n当你获得成就时，会在聊天中显示一条消息。"
L["If checked, when you change the audio output device in your operating system, the game audio output device will change automatically.|n|nFor this to work, the game audio output device will be set to system default."] = "勾选后，当你在操作系统中更改音频输出设备时，游戏音频输出设备将自动更改。|n|n为此，游戏音频输出设备将设置为系统默认值。"
L["If checked, you will be able to mute your own choice of sounds."] = "勾选后，你将能够静音自己选择的声音。"
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant or bank."] = "勾选后，当你与商贩或银行交互时，你的背包将不会自动打开或关闭。"

end

-- zhTW: Traditional Chinese
if GameLocale == "zhTW" then
L["+"] = "+"
L["A Donation of Mageweave"] = "捐獻魔紋布"
L["A Donation of Runecloth"] = "捐獻符文布"
L["A Donation of Silk"] = "捐獻絲綢"
L["A Donation of Wool"] = "捐獻毛料"
L["A friend request from"] = "你有一個好友申請，來自"
L["Accept available quests automatically"] = "自動接受可用任務"
L["Accept resurrection"] = "自動接受復活"
L["Accept summon"] = "自動接受召喚"
L["A'dal"] = "阿達歐"
L["Additional Runecloth"] = "更多的符文布"
L["Addon"] = "插件"
L["Aerie Peak"] = "鷹巢山"
L["Ahn'kahet (Old Kingdom)"] = "安卡罕特：古王國"
L["Ahn'Qiraj"] = "安其拉"
L["ALT"] = "ALT"
L["Alterac Mountains"] = "奧特蘭克山脈"
L["Anchor"] = "定位點"
L["Angelic"] = "天使"
L["Announce rare"] = "通告稀有"
L["Arathi Highlands"] = "阿拉希高地"
L["Ashenvale"] = "梣谷"
L["Astranaar"] = "阿斯特蘭納"
L["Auberdine"] = "奧伯丁"
L["Auto loot is now enabled."] = "自動拾取現在已啟動。"
L["AutoFollow"] = "自動跟隨"
L["AutoFollow disabled."] = "自動跟隨已停用。"
L["Automate gossip"] = "自動對話"
L["Automate quests"] = "任務自動化"
L["Automatic Release Cancelled"] = "自動釋放已被取消"
L["Automation"] = "自動化"
L["Azjol-Nerub"] = "阿茲歐奈幽"
L["Azshara"] = "艾薩拉"
L["Azuremyst Isle"] = "藍謎島"
L["B"] = "B"
L["Back to Main Menu"] = "返回"
L["Bad ID"] = "損壞的ID"
L["Badlands"] = "荒蕪之地"
L["Barrens"] = "南貧瘠之地"
L["Battle"] = "戰爭"
L["Battle of Warsong Gulch"] = "峽谷之戰"
L["Battlegrounds"] = "戰場"
L["BCC"] = "BCC"
L["Bikes"] = "摩托車"
L["Black Morass"] = "黑暗沼澤"
L["Black Temple"] = "黑暗神廟"
L["Blackfathom Deeps"] = "黑澗深淵"
L["Blackrock Depths"] = "黑石深淵"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade's Edge Mountains"] = "劍刃山脈"
L["Blasted Lands"] = "詛咒之地"
L["Block drunken spam"] = "阻擋酒醉訊息"
L["Block duel spam"] = "阻擋決鬥訊息"
L["Block duels"] = "拒絕決鬥"
L["Block friend requests"] = "封鎖好友邀請"
L["Block party invites"] = "封鎖隊伍邀請"
L["Block shared quests"] = "阻擋任務分享"
L["Block spell links during combat"] = "阻擋法術連結當戰鬥中"
L["Blocks"] = "封鎖"
L["Bloodmyst Isle"] = "血謎島"
L["Booty Bay"] = "藏寶海灣"
L["Borean Tundra"] = "北風凍原"
L["Bottom"] = "底部"
L["Brackenwall Village"] = "蕨牆村"
L["Brooms"] = "掃帚"
L["Buffs"] = "增益"
L["Burning Crusade"] = "燃燒的遠征"
L["Burning Crusade Classic"] = "經典-燃燒的遠征"
L["Burning Steppes"] = "燃燒平原"
L["Buttons"] = "按鈕"
L["Buttons for the addons listed below will remain visible."] = "下面列出的插件按鈕將保持可見。"
L["Buyout Only"] = "僅限直購價"
L["by Leatrix Plus"] = "由 Leatrix Plus"
L["C"] = "披"
L["Camera distance"] = "鏡頭距離"
L["Camp Mojache"] = "莫沙徹營地"
L["Camp Taurajo"] = "陶拉祖營地"
L["Cannot announce in this zone."] = "無法在此區域通告。"
L["Cannot be sold"] = "無法出售"
L["Cannot find General chat channel."] = "無法找到綜合聊天頻道。"
L["Cannot use this with your locale."] = "不能在您的語言環境中使用它。"
L["Cenarion Hold"] = "塞納里奧城堡"
L["Chain style"] = "邊框樣式"
L["Character"] = "角色"
L["Chat"] = "聊天功能"
L["Chat Frame"] = "聊天視窗"
L["Checkbox labels are Ok."] = "複選框標籤是OK的。"
L["Chillwind Camp"] = "冰風崗"
L["Chillwind E'ko"] = "冰風魂精"
L["Chimes"] = "鐘聲"
L["Cinematics"] = "過場動畫"
L["Claiming Arathi Basin"] = "資源競賽"
L["Class colored frames"] = "框架職業染色"
L["Class icon portraits"] = "職業圖示頭像"
L["Classic"] = "經典"
L["click here for new selection"] = "點擊這裡跳轉新選擇"
L["Click to close the currently active flight progress bar."] = "點擊以關閉當前啟用的飛行進度條。"
L["Click to configure the settings for this option."] = "點擊進行額外的選項設置"
L["Click to disable Titan Panel screen adjust.  Your UI will be reloaded."] = "點擊來取消泰坦面板的螢幕調整。您的介面將會重載。"
L["Click to mute sounds in the list."] = "點擊來使列表中的聲音靜音。"
L["Click to reset the settings on this page."] = "點擊重置此頁面的設置。"
L["Click to resize the screen to fit between the top and bottom borders."] = "點擊來重設螢幕大小以適配上下邊框。"
L["Click to return to the main menu."] = "點擊返回到主選單"
L["Click to toggle the addon buttons editor."] = "點擊以切換插件按鈕編輯器。"
L["Click to toggle the frame alignment grid."] = "點擊以切換框架對齊網格。"
L["Click to unmute sounds in the list."] = "點擊來使列表中的聲音解除靜音。"
L["Cloak"] = "披風"
L["Close"] = "關閉"
L["Close Bar"] = "關閉條"
L["Cluster scale"] = "群組縮放"
L["CMD (MAC)"] = "指令 (MAC)"
L["Coilfang Reservoir"] = "盤牙水庫"
L["Collapse"] = "收起"
L["Combat log cannot be hidden while undocked."] = "戰鬥記錄視窗被分離時無法隱藏。"
L["Combat plates"] = "自動開關姓名板"
L["Combine addon buttons"] = "合併插件按鈕"
L["Completed."] = "已完成。"
L["Concerted Efforts"] = "共同的努力"
L["Configuration Panel"] = "設置面板"
L["Connections for"] = "連結在"
L["Conquering Arathi Basin"] = "戰爭的動力"
L["Contribute"] = "貢獻"
L["CONTROL"] = "CTRL"
L["Copied to clipboard."] = "複製到剪貼簿。"
L["Credits"] = "有功人員"
L["Crossroads"] = "十字路口"
L["Crystalsong Forest"] = "水晶之歌森林"
L["Culling of Stratholme"] = "淨化斯坦索姆"
L["Cursor"] = "鼠標"
L["Cursor Left"] = "鼠標左側"
L["Cursor Right"] = "鼠標右側"
L["D"] = "地城"
L["Darkmoon Faire"] = "暗月馬戲團"
L["Darkshire"] = "夜色鎮"
L["Darkshore"] = "黑海岸"
L["Deadmines"] = "死亡礦坑"
L["Deadwind Pass"] = "逆風小徑"
L["Delay"] = "延遲"
L["Desolace"] = "淒涼之地"
L["Dire Maul"] = "厄運之槌"
L["Disable bag automation"] = "停用背包自動開啟"
L["Disable chat fade"] = "停用聊天視窗淡出"
L["Disable loot warnings"] = "停用拾取通報"
L["Disable screen effects"] = "停用螢幕特效"
L["Disable screen glow"] = "停用螢幕光暈"
L["Disable sticky chat"] = "停用聊天頻道粘附"
L["Dismount me"] = "讓我下坐騎"
L["Dismount when casting a spell while moving"] = "移動中施法時下坐騎"
L["Dismount when clicking a flight destination"] = "點擊一個飛行點目的地時下坐騎"
L["Dismount when not enough rage, mana or energy"] = "怒氣、法力或能量不足時下坐騎"
L["Dismount when the flight map opens"] = "當開啟飛行地圖時下坐騎"
L["Do you want to use Leatrix Plus Enhanced Minimap or ElvUI Minimap?"] = "你想使用Leatrix Plus來增強小地圖還是ElvUI小地圖呢？"
L["Drag the frame overlay to position the frame."] = "拖曳框架的遮罩以定位此框架。"
L["Drag the frame overlay to position the frame.|n|nThis panel will close automatically if you enter combat."] = "拖動框架圖層以定位框架。|n|n如果您進入戰鬥，此面板將自動關閉。"
L["Drag the frame overlay with the left button to position it freely or with the right button to position it using snap-to-grid."] = "使用左鍵拖動框架圖層以自由定位，或使用右鍵使用對齊網格進行定位。"
L["Drag the frame overlay with the left button to position it freely or with the right button to position it using snap-to-grid.|n|nThis panel will close automatically if you enter combat."] = "使用左鍵拖動框架圖層以自由定位，或使用右鍵使用對齊網格來定位它。|n|n如果您進入戰鬥，此面板將自動關閉。"
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "移動面板來定位框架。|n|n如果想要改變框架尺寸，你需選定面板，然後移動滑塊來選擇。|n|n你一旦進入戰鬥，這個框架會自動關閉。"
L["Drag the frame overlays with the left button to position them freely or with the right button to position them using snap-to-grid.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "使用左鍵拖動框架圖層以自由定位它們，或使用右鍵使用對齊網格來定位它們。|n|n要更改框架的大小，請單擊它以選擇它，然後調整縮放卷軸。| n|n如果您進入戰鬥，此面板將自動關閉。"
L["Drag to set the buffs frame scale."] = "拖拉來設定增益框架大小。"
L["Drag to set the cluster scale.|n|nNote: Adjusting the cluster scale affects the entire cluster including frames attached to it such as the buffs frame and objectives tracker.|n|nIt will also cause the default UI right-side action bars to scale when you login.  If you use the default UI right-side action bars, you may want to leave this at 100%."] = "拖動以設置群組縮放。|n|n注意：調整群組縮放會影響整個群組，包括附加到它的框架，例如增益框架和任務目標追蹤器。|n|n當你登入時它還會導致預設的UI右側動作列縮放。如果您使用預設的UI右側動作列，您可能希望將其保留為 100%。"
L["Drag to set the cluster scale.|n|nNote: Adjusting the cluster scale affects the entire cluster including frames attached to it such as the quest watch frame.|n|nIt will also cause the default UI right-side action bars to scale when you login.  If you use the default UI right-side action bars, you may want to leave this at 100%."] = "拖動以設置群組規模。|n|n注意：調整群組規模會影響整個群組，包括附加到它的框架，例如任務監控框架。|n|n當您登入時，它還會導致預設的介面右側動作列縮放。如果您使用預設的介面右側動作列，您可能希望將其保留為 100%。"
L["Drag to set the cursor X offset."] = "拖拉來設置鼠標水平偏移量。"
L["Drag to set the cursor Y offset."] = "拖拉來設置鼠標垂直偏移量。"
L["Drag to set the density of weather effects."] = "拖動來設定天氣效果的密度。"
L["Drag to set the durability frame scale."] = "拖動以設置耐久度框架縮放。"
L["Drag to set the flight progress bar scale."] = "拖動以設置飛行進度條縮放大小。"
L["Drag to set the flight progress bar width."] = "拖動以設置飛行進度條寬度。"
L["Drag to set the focus frame scale."] = "拖動以設置焦點框架大小。"
L["Drag to set the font size of book text."] = "拖拉來設定書籍文字大小。"
L["Drag to set the font size of mail text."] = "拖動以設置郵件文字的字體大小。"
L["Drag to set the font size of quest text."] = "拖動以設置任務文字的字體大小。"
L["Drag to set the minimap scale.|n|nAdjusting this slider makes the minimap and all the elements bigger."] = "拖動以設置小地圖縮放比例。|n|n調整此卷軸會使小地圖和所有元件變大。"
L["Drag to set the number of milliseconds before you are automatically released.|n|nYou can hold down shift as the timer is ending to cancel the automatic release."] = "拖動以設置自動釋放之前的毫秒數。|n|n您可以在計時器結束時按住 shift 以取消自動釋放。"
L["Drag to set the scale of the Leatrix Plus panel."] = "拖動以設置Leatrix Plus面板的縮放比例。"
L["Drag to set the scale of the selected frame."] = "拖動以設置所選框架的縮放比例。"
L["Drag to set the size of the bottom border."] = "拖動以設置底部邊框的大小。"
L["Drag to set the size of the left border."] = "拖動以設置左側邊框的大小。"
L["Drag to set the size of the right border."] = "拖動以設置右側邊框的大小。"
L["Drag to set the size of the top border."] = "拖動以設置頂部邊框的大小。"
L["Drag to set the square minimap size.|n|nAdjusting this slider makes the minimap bigger but keeps the elements the same size."] = "拖動以設置方形小地圖大小。|n|n調整此卷軸會使小地圖更大，但元件保持相同大小。"
L["Drag to set the timer bar scale."] = "拖動以設置計時器框架縮放。"
L["Drag to set the tooltip scale."] = "拖動以設置工具提示的縮放比例。"
L["Drag to set the transparency of the borders."] = "拖動以設置邊框的透明度。"
L["Drag to set the transparency of the Leatrix Plus panel."] = "拖動以設置Leatrix Plus面板的透明度。"
L["Drag to set the vehicle seat indicator frame scale."] = "拖曳以設定載具座位指示器框架比例。"
L["Drag to set the widget scale."] = "拖動以設置組件大小。"
L["Drag to size"] = "拖拉改變大小"
L["Dragonblight"] = "龍骨荒野"
L["Drak'Tharon Keep"] = "徳拉克薩隆要塞"
L["Dun Morogh"] = "丹莫洛"
L["Dungeons"] = "地下城"
L["Dup ID"] = "重複的ID"
L["Duplicates"] = "重複"
L["durability"] = "耐久度"
L["Durability"] = "耐久度"
L["Duration"] = "耗時"
L["Durotar"] = "杜洛塔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "塵泥沼澤"
L["Eastern Kingdoms"] = "東部王國"
L["Eastern Plaguelands"] = "東瘟疫之地"
L["Easy item destroy"] = "簡易物品摧毀"
L["Editor"] = "編輯器"
L["Eight minutes"] = "八分鐘"
L["ELITE"] = "精英"
L["ElvUI"] = "ElvUI"
L["Elwynn Forest"] = "艾爾文森林"
L["Enable viewport"] = "啟用視窗背景"
L["Enhance dressup"] = "增強試衣間"
L["Enhance minimap"] = "增強小地圖"
L["Enhance professions"] = "增強專業"
L["Enhance quest log"] = "增強任務日誌"
L["Enhance tooltip"] = "增強工具提示"
L["Enhance trainers"] = "加強技能訓練"
L["Enhancements"] = "增強功能"
L["Enter"] = "進入"
L["Enter item IDs separated by commas.  Item IDs can be found in item tooltips while this panel is showing.|n|nJunk items entered here will not be sold automatically.|n|nWhite items entered here will be sold automatically.|n|nThe editbox tooltip will show you more information about the items you have entered."] = "輸入以逗號分隔的物品ID。顯示此面板時，可以在物品工具提示中找到物品ID。|n|n此處輸入的垃圾物品不會自動出售。|n|n此處輸入的白色物品將自動出售。|n|n編輯框工具提示將顯示有關您輸入的物品的更多訊息。"
L["Enter junk item IDs separated by commas."] = "輸入垃圾物品ID並以逗號分隔。"
L["Enter sound file IDs separated by comma then click the Mute button.|n|nIf you wish, you can enter a brief note for each file ID but do not include numbers in your notes.|n|nFor example, you can enter 'DevAura 569679, RetAura 568744' to mute the Devotion Aura and Retribution Aura spells.|n|nUse Leatrix Sounds to find, test and play sound file IDs."] = "輸入以逗號分隔的聲音檔案ID，然後單擊靜音按鈕。|n|n如果願意，您可以為每個檔案ID輸入一個簡短的註釋，但不要在註釋中包含數字。|n|n例如，您可以輸入“DevAura 569679、RetAura 568744”來靜音 Devotion Aura 和 Retribution Aura 法術。|n|n使用 Leatrix Sounds 查找、測試和播放聲音檔案ID。"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "輸入您要查看的冷卻圖示的法術ID。|n|n如果想要寵物框架下正常出現冷卻圖示，請選中寵物複選框。|n|n冷卻圖示會依據您的職業保存。"
L["enter zone or track name"] = "輸入區域或曲目名稱"
L["Error messages will be hidden"] = "錯誤訊息將會隱藏"
L["Error messages will be shown"] = "錯誤訊息將會顯示"
L["Events"] = "事件"
L["Everlook"] = "永望鎮"
L["Eversong Woods"] = "永歌森林"
L["Exclude Alterac Valley"] = "排除奧特蘭山谷"
L["Exclude BugSack"] = "排除 BugSack"
L["Exclude combat resurrection"] = "排除戰鬥復活"
L["Exclusions"] = "例外"
L["Expand"] = "擴展"
L["Extras"] = "其他"
L["Eye of Eternity"] = "永恆之眼"
L["False"] = "虛假"
L["Faster auto loot"] = "加速自動拾取"
L["Faster movie skip"] = "快速動畫跳過"
L["Feathermoon"] = "羽月要塞"
L["Features"] = "功能"
L["Felwood"] = "費伍德森林"
L["Feralas"] = "菲拉斯"
L["Fight for Warsong Gulch"] = "自然屏障"
L["Fill instead of drain"] = "填滿而非排空"
L["Filter chat messages"] = "過濾聊天訊息"
L["Find Item"] = "搜尋物品"
L["Firewing Signets"] = "火翼徽章"
L["Five minutes"] = "五分鐘"
L["Fizzle"] = "嘶叫聲"
L["Flame Crest"] = "烈焰峰"
L["Flight commenced."] = "飛航開始。"
L["Flight details"] = "飛航詳情"
L["Focus"] = "焦點"
L["For all of the social options above, you can treat guild members as friends too."] = "對於所有以上社交選項，您也可以將公會成員和社群成員視為好友。"
L["For Great Honor"] = "無上的榮耀"
L["Forge of Souls"] = "眾魂熔爐"
L["Four minutes"] = "四分鐘"
L["Frames"] = "框架相關"
L["Freewind Post"] = "亂風崗"
L["Frostmaul E'ko"] = "霜槌魂精"
L["Frostsaber E'ko"] = "霜刃魂精"
L["Gadgetzan"] = "加基森"
L["Game Options"] = "游戲設置"
L["General"] = "一般"
L["Ghost"] = "靈魂狀態框架"
L["Ghostlands"] = "鬼魂之地"
L["Gloomy"] = "黑暗"
L["Gnomeregan"] = "諾姆瑞根"
L["Gold Only"] = "僅輸入金幣"
L["Graphics and Sound"] = "圖形和音效"
L["Grizzly Hills"] = "灰白之丘"
L["Grom'gol"] = "格羅姆高"
L["Groups"] = "隊伍"
L["Guild"] = "公會"
L["Gundrak"] = "剛德拉克"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "古拉巴什、邪枝和枯木硬幣"
L["Gyrocopters"] = "直升機"
L["H"] = "頭"
L["Halls of Lightning"] = "雷光大廳"
L["Halls of Reflection"] = "鏡像大廳"
L["Halls of Stone"] = "石之大廳"
L["Hammerfall"] = "落錘鎮"
L["Haunted"] = "鬧鬼的"
L["Have mats?"] = "有材料？"
L["Hellfire Peninsula"] = "地獄火半島"
L["Hellfire Ramparts"] = "地獄火城牆"
L["Helm"] = "頭盔"
L["Help"] = "幫助"
L["Help contribute flight times"] = "幫助提供飛行時間"
L["Hide action button text"] = "隱藏動作列按鈕文字"
L["Hide addon buttons"] = "隱藏插件按鈕"
L["Hide alerts"] = "隱藏警告"
L["Hide chat buttons"] = "隱藏聊天視窗按鈕"
L["Hide cooldown duration numbers (if enabled)"] = "隱藏冷卻持續時間數字(如果啟用)"
L["Hide error messages"] = "隱藏錯誤訊息"
L["Hide gryphons"] = "隱藏動作條獅鷲"
L["Hide keybind text"] = "隱藏快捷鍵文字"
L["Hide macro text"] = "隱藏巨集文字"
L["Hide portrait numbers"] = "隱藏頭像數字"
L["Hide stance bar"] = "隱藏姿態條"
L["Hide the combat log"] = "隱藏戰鬥記錄視窗"
L["Hide the health bar"] = "隱藏血量條"
L["Hide the tracking button"] = "隱藏追蹤按鈕"
L["Hide the world map button"] = "隱藏世界地圖按鈕"
L["Hide the zone text bar"] = "隱藏區域文字列"
L["Hide the zoom buttons"] = "隱藏縮放按紐"
L["Hide tooltips for world units during combat"] = "戰鬥中隱藏視窗"
L["Hide zone text"] = "隱藏區域文字"
L["High"] = "高"
L["Hillsbrad Foothills"] = "希爾斯布萊德丘陵"
L["Hinterlands"] = "辛特蘭"
L["Home"] = "首頁"
L["Hover the pointer over a button."] = "將指針停留在按鈕上。"
L["Howling Fjord"] = "凜風峽灣"
L["Hyjal Summit"] = "海加爾山之戰"
L["Ice Thistle E'ko"] = "冰草魂精"
L["Icecrown"] = "寒冰皇冠"
L["Icecrown Citadel"] = "冰冠城寨"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "勾選後，背包搜尋框會顯示在背包與銀行視窗上。"
L["If checked, a button will be added to the character frame which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "勾選後，一個按鈕會顯示在角色框架，其鼠標提示訊息會顯示身上的裝備耐久度。|n|n當你死後，你的整體耐久度也會顯示在聊天框架。"
L["If checked, a cancel form button will be shown on the flight map while you are playing as a shapeshifted druid or shaman."] = "勾選後，當您玩變形的德魯伊或薩滿時，飛行地圖上會顯示一個取消變形按鈕。"
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant and not queued for a battleground.|n|nFriends who message the keyword using Battle.net will not be sent a group invite if they are appearing offline.  They need to either change their online status or use character whispers."] = "勾選後，當你未組隊或為隊長或團隊助理，並且沒有在地下城與團隊的佇列中時，任何密語你預設的關鍵字的人將會被組隊邀請。|n|n使用戰網發送關鍵字訊息的好友如果處於離線狀態，將不會收到組隊邀請。他們需要更改在線狀態或使用角色密語。"
L["If checked, a master volume slider will be shown in the character frame."] = "勾選後，主要聲道的調整滑桿將出現在角色視窗。"
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT-click - Toggle music.|n|nALT-click - Toggle errors (if enabled).|n|nCTRL/SHIFT-click - Toggle windowed mode.|n|nCTRL/ALT-click - Toggle Zygor (if installed)."] = "勾選後。小地圖按鈕將可用。|n|n點擊 - 切換選項面板。|n|nSHIFT點擊 - 切換音樂。|n|nALT點擊 - 切換錯誤（如果啟用）。|n|nCTRL/SHIFT點擊 - 切換視窗模式。|n|nCTRL/ALT點擊 - 切換 Zygor（如果已安裝）。"
L["If checked, a power bar will be shown in the player frame when you are playing a shapeshifted druid."] = "勾選後，當您玩變形的德魯伊時，玩家框架中將顯示一個能量條。"
L["If checked, a repair summary will be shown in chat when your gear is automatically repaired."] = "勾選後，當您的裝備自動修理時，將在聊天中顯示修理總結。"
L["If checked, a timer will be shown under the PvP encounter ready frame so that you know how long you have left to click the enter button."] = "勾選後，在 PvP 開戰準備確認框架下方將顯示一個計時器，以便您知道您可以點擊進入按鈕還有多長時間。"
L["If checked, a train all skills button will be shown in the skill trainer frame allowing you to train all available skills instantly."] = "勾選後，訓練所有技能按鈕將顯示在技能訓練視窗中，讓您可以立即訓練所有可用技能。"
L["If checked, a vendor summary will be shown in chat when junk is automatically sold."] = "勾選後，當您的垃圾自動出售時，將在聊天中顯示商店總結。"
L["If checked, A'dal in Shattrath City will be muted."] = "勾選後，撒塔斯城的阿達歐將被靜音。"
L["If checked, additional font sizes will be available in the chat frame font size menu."] = "勾選後，聊天框字體大小選單中將提供額外字體尺寸。"
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "勾選後，拍賣場將加入額外功能。|n|n僅限直購 - 在不填寫起始價格的情況下建立直購拍賣。|n|n僅限金幣 - 將銅和銀價格定在99，以加快新的拍賣。|n|n搜尋物品 - 在拍賣行搜尋您正在銷售的商品。|n|n除此以外，拍賣持續時間設置將保存為帳戶通用。"
L["If checked, addon buttons will be combined into a single button frame which you can toggle by right-clicking the minimap.|n|nNote that enabling this option will lock out the 'Hide addon buttons' setting."] = "勾選後，插件按鈕將合併為一個按鈕框架，您可以通過右鍵單擊小地圖來切換該框架。|n|n請注意，啟用此選項將鎖定“隱藏插件按鈕”設置。"
L["If checked, addon buttons will be hidden while the pointer is not over the minimap."] = "勾選後，當指針不在小地圖上時，插件按鈕將被隱藏。"
L["If checked, adjusting the cluster scale will not affect the minimap scale."] = "勾選後，調整群組縮放不會影響小地圖縮放。"
L["If checked, alert frames will not be shown."] = "勾選後，警告框架將不會顯示。"
L["If checked, alert frames will not be shown.|n|nWhen you earn an achievement, a message will be shown in chat instead."] = "勾選後，警告框架將不顯示。n|n當您獲得成就時，會在聊天中顯示一條訊息。"
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾選後，當你訪問商販時將自動出售背包中的垃圾。|n|n當你訪問時按住Shift鍵，可以暫時忽略該功能。"
L["If checked, an animation slider will be shown in the dressing room."] = "勾選後，試衣間中將顯示動作卷軸。"
L["If checked, available quests will be accepted automatically."] = "勾選後，可用的任務將會自動接受。"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "勾選後，訊息視窗的邊框會更改為藍色（友方）或者紅色（敵方）。"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "勾選後，戰網好友邀請會自動拒絕。|n|n啟用後，當前待處理的邀請會自動拒絕。"
L["If checked, bike mount sounds will be muted.|n|nThis applies to Mekgineer's Chopper and Mechano-hog."] = "勾選後，摩托車坐騎聲音將被靜音。|n|n這會套用於機械工程摩托車以及機械豬。"
L["If checked, broom mounts will be muted."] = "勾選後，掃帚坐騎將被靜音。"
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "勾選後，聊天視窗的按鈕會被隱藏。|n|n點擊視窗標簽會自動顯示最新的消息。|n|n使用鼠標滾輪可以查看歷史訊息。按住SHIFT進行訊息頁面跳轉，按住CTRL將滾動至訊息頁首/頁尾。"
L["If checked, chat text will not fade out after a time period."] = "勾選後，聊天訊息不會在一定時間後淡出。"
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "勾選後，玩家、目標以及焦點框架將使用職業著色。"
L["If checked, class colors will be used in the chat frame."] = "勾選後，聊天框架將使用職業著色。"
L["If checked, class icons will be shown in the portrait frames.|n|nNote that this option may reduce framerate while the target of target window is showing."] = "勾選後，頭像框架將會顯示職業圖示。|n|n請注意，此選項可能會在顯示目標的目標視窗時降低幀數。"
L["If checked, clock hourly chimes will be muted."] = "勾選後，整點的鐘聲將被靜音。"
L["If checked, completed quests will be turned-in automatically."] = "勾選後，完成的任務會自動交付。"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "勾選後，當你選擇一個擲骰選項或是試圖出售或郵寄可交易物品將不再確認。"
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "勾選後，冷卻持續時間數字將不顯示在冷卻上。|n|n取消勾選後，冷卻持續時間數字將會顯示在冷卻上如果已在遊戲選項面板中啟用('動作條'選單)。"
L["If checked, cooldown icons will be shown above the player frame instead of the target frame.|n|nIf unchecked, cooldown icons will be shown above the target frame."] = "勾選後，冷卻圖示將顯示在玩家框架而不是目標框架上方。|n|n如未勾選，冷卻圖示將顯示在目標框架上方。"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "勾選後，在玩家頭像和寵物頭像上的傷害及治療數字不再顯示。"
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "勾選後，對鎖定的聊天視窗進行拖動，會使其豎直拉伸。|n|n對已解鎖的聊天視窗進行拖動，會使其移動。"
L["If checked, drunken messages will be blocked unless they apply to your character.|n|nThis applies to the system channel."] = "勾選後，酒醉訊息將被阻擋，除非是生效於您的角色。|n|n這適用於系統頻道。"
L["If checked, duel requests will be blocked unless the player requesting the duel is a friend."] = "勾選後，除非請求決鬥的玩家是好友，否則決鬥請求將被阻擋。"
L["If checked, duel victory and retreat messages will be blocked unless your character took part in the duel.|n|nThis applies to the system channel."] = "勾選後，除非您的角色參加了決鬥，否則決鬥勝利和落敗消息將被阻擋。|n|n這適用於系統頻道。"
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "勾選後，當您的角色在黑鐵酒吧休息時表情音效將靜音。|n|n其他所有時間都會啟用表情音效。"
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "勾選後，敵對姓名板會在戰鬥中自動開啟，離開戰鬥後關閉。"
L["If checked, flight times will be shown in the flight map and when you take a flight."] = "勾選後，飛行時間將顯示在飛行地圖和您搭乘的時間。"
L["If checked, footsteps for mechanical mounts will be muted."] = "勾選後，機械坐騎的腳步聲將被靜音。"
L["If checked, group invites will only be sent to friends.|n|nIf unchecked, group invites will be sent to everyone."] = "勾選後，隊伍邀請只會發送給好友。|n|n如果取消勾選，隊伍邀請將發送給所有人。"
L["If checked, guild ranks will be shown for players in your guild."] = "勾選後，將為您公會中的玩家顯示公會等級。"
L["If checked, guild ranks will be shown for players who are not in your guild."] = "勾選後，那些不在你公會中的玩家也會顯示公會階級。"
L["If checked, gyrocopters will be muted.|n|nThis applies to the engineering flying machine mounts."] = "勾選後，直升機的音效將靜音。|n|n這主要應用於工程的直升機坐騎。"
L["If checked, helm and cloak toggle checkboxes will be shown in the character frame.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "勾選後，角色視窗會顯示頭盔與披風切換複選框。|n|n您可以按住Shift以及右鍵點擊複選框來切換布局。"
L["If checked, holiday event sounds will be muted.|n|nThis applies to Headless Horseman."] = "勾選後，節日事件音效將被靜音。|n|n這會套用在無頭騎士上。"
L["If checked, item buttons will be shown in the dressing room.  You can click the item buttons to remove individual items from the model."] = "勾選後，物品按鈕將顯示在試衣間中。您可以點擊物品按鈕從模型中刪除單個物品。"
L["If checked, keybind text will not be shown on action buttons."] = "勾選後，動作列上的快捷鍵文字將不顯示。"
L["If checked, login screen sounds will be muted when you logout of the game.|n|nNote that login screen sounds will not be muted when you initially launch the game.|n|nThey will only be muted when you logout of the game.  This includes manually logging out as well as being forcefully logged out by the game server for reasons such as being away for an extended period of time.|n|nNo more dragons roaring when you fall asleep while the game is running!"] = "勾選後，當您登出遊戲時，登入螢幕聲音將被靜音。|n|n請注意，當您最初啟動遊戲時，登入螢幕的聲音不會被靜音。|n|n只有當您退出遊戲時，它們才會被靜音。包括手動退出，以及因長時間離開等原因被遊戲服務器強制退出。|n|n當您在遊戲運行時睡著時不再有巨龍咆哮！"
L["If checked, macro and keybind text will not be shown on action buttons."] = "勾選後，巨集和按鍵綁定文字不會顯示在動作列按鈕上。"
L["If checked, macro text will not be shown on action buttons."] = "勾選後，動作列上的巨集文字將不顯示。"
L["If checked, mechanostriders will be quieter."] = "勾選後，機械陸行鳥會更安靜。"
L["If checked, members of your guild will be treated as friends for all of the options on this page."] = "勾選後，對於此頁面上的所有選項，您的公會成員將被視為好友。"
L["If checked, messages containing spell links will be blocked while you are in combat.|n|nThis is useful for blocking spell interrupt spam.|n|nThis applies to the say, party, raid, emote and yell channels."] = "勾選後，當你在戰鬥中時，包含法術連結的訊息將被阻擋。|n|n這對於施法中斷垃圾訊息非常有用。|n|n這適用於說、小隊、團隊、表情和大喊頻道。"
L["If checked, messages containing spell links will be blocked while you are in combat.|n|nThis is useful for blocking spell interrupt spam.|n|nThis applies to the say, party, raid, instance and emote channels."] = "勾選後，當您在戰鬥中時，包含法術連結的訊息將被阻擋。|n|n這對於阻擋法術打斷刷頻訊息很有用。|n|n這適用於說、小隊、團隊、副本和表情頻道。"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the alt key and click it to toggle error messages without affecting this setting."] = "勾選後，大多數錯誤訊息（例如“怒氣不足”）將不會顯示。一些重要的錯誤被排除。|n|n如果您啟用了小地圖按鈕，您可以按住 alt 鍵並單擊它來切換錯誤訊息，而不會影響此設定。"
L["If checked, netherdrakes will be quieter."] = "勾選後，幽冥龍會更安靜。"
L["If checked, non-standard minimap buttons will be replaced with standard LibDBIcon buttons.|n|nThis will fix the problems with non-standard buttons such as not hiding automatically, not following the minimap shape and not being placed in the button frame.|n|nNote that enabling or disabling non-standard buttons may require a UI reload to take effect.|n|nMost addons already use the standard LibDBIcon library and will not be affected by this setting but a few addons still use non-standard buttons.|n|nPlease ask addon authors to use the standard LibDBIcon library for their minimap buttons then this setting won't be necessary."] = "勾選後，非標準的小地圖按鈕將被標準的 LibDBIcon 按鈕替換。|n|n這將解決非標準按鈕的問題，例如不自動隱藏、不跟隨小地圖形狀和未放置在按鈕框架中。|n|n請注意，啟用或禁用非標準按鈕可能需要重新載入UI才能生效。|n|n大多數插件已經使用標準 LibDBIcon 庫並且不會受到此設置的影響，但一些插件仍然使用非標準按鈕。|n |n請詢問插件作者為他們的小地圖按鈕使用標準的 LibDBIcon 庫，那麼這個設置就沒有必要了。"
L["If checked, party invitations from friends will be automatically accepted unless you are queued for a battleground."] = "勾選後，除非您在尋求組隊佇列中，否則來自好友的隊伍邀請將被自動接受。"
L["If checked, party invitations will be blocked unless the player inviting you is a friend."] = "勾選後，除非邀請您的玩家是好友，否則隊伍邀請將被阻擋。"
L["If checked, quest levels will be shown."] = "勾選後，任務等級將會顯示。"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically."] = "勾選後，任務將被自動選擇、接受和完成。|n|n有金幣要求的任務不會自動完成。"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "勾選後，團隊和副本聊天訊息會改為藍色（與小隊一致）。"
L["If checked, raid chat will be colored blue (to match the default party chat color)."] = "勾選後，團隊和副本聊天訊息會改為藍色（與小隊一致）。"
L["If checked, recent chat will be restored when you reload your interface."] = "勾選後，重新載入界面時將恢復最近的聊天。"
L["If checked, repair costs will be taken from guild funds for characters that are guilded and have permission to repair."] = "勾選後，對於已加入公會並有權維修的角色，維修費用將從公會資金中扣除。"
L["If checked, resurrection requests will be accepted automatically."] = "勾選後，復活請求將被自動接受。"
L["If checked, resurrection requests will not be automatically accepted if the player resurrecting you is in combat."] = "勾選後，如果復活您的玩家在戰鬥中，則不會自動接受復活請求。"
L["If checked, Rhonin will be muted."] = "勾選後，羅甯將被靜音。"
L["If checked, Screech will be muted.|n|nThis is a spell used by some flying pets."] = "勾選後，尖嘯聲將被靜音。|n|n這是某些飛行寵物使用的法術。"
L["If checked, shared quests will be declined unless the player sharing the quest is a friend."] = "勾選後，除非分享任務的玩家是好友，否則任務分享將被拒絕。"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "勾選後，位於增益框架與目標框架之下的增益圖標提示會顯示法術ID。"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "勾選後，會停用聊天頻道的粘附。|n|n此選項不會影響臨時視窗的對話。"
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "勾選後，當你不處於戰鬥狀態時會自動接受召喚。"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "勾選後，插件列表（游戲選單處）會顯示預設的對角色生效的插件。"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "勾選後，自動拾取所需的時間將大幅減少。"
L["If checked, the Arcanite Ripper guitar sound will be muted."] = "勾選後，Arcanite Ripper 吉他聲音將被靜音。"
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "勾選後，背包及銀行的整理按鈕不再顯示。"
L["If checked, the BugSack addon minimap button will always be visible if you have BugSack installed and the minimap button enabled."] = "勾選後，如果您安裝了BugSack並啟用了小地圖按鈕，則BugSack插件小地圖按鈕將始終可見。"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "勾選後，打開團隊訊息的按鈕會顯示在左側團隊管理框架的上方，而不是在其內部。|n|n此選項讓你無需打開團隊管理框架，就可以切換團隊框架。"
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "勾選後，戰鬥記錄會被隱藏。|n|n戰鬥記錄視窗必須未被分離時才能生效。|n|n如果戰鬥記錄視窗被分離了，你可以拖動其合併至主視窗（然後重載插件），或者在聊天設置中重置設置。"
L["If checked, the editbox will be moved to the top of the chat frame."] = "勾選後輸入框會被移動至聊天視窗上方。"
L["If checked, the flight progress bar background texture will be shown."] = "勾選後，將顯示飛行進度條背景材質。"
L["If checked, the flight progress bar background will fill instead of drain."] = "勾選後，飛行進度條背景將為填滿而不是排空。"
L["If checked, the flight progress bar destination will be shown."] = "勾選後，將顯示目的地的飛行進度條。"
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "勾選後，死亡後的灰色螢幕以及靈魂世界特效將會停用。"
L["If checked, the health bar will not be shown."] = "勾選後，血量調將不顯示。"
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "勾選後，介面按鈕音效，聊天框架標籤點及音效以及遊戲選單切換音效都將被靜音。"
L["If checked, the main bar gryphons will not be shown."] = "勾選後，動作條兩邊的獅鷲不再顯示。"
L["If checked, the mechanical guild vault idle sound will be muted."] = "勾選後，機械公會金庫的空閒聲音將被靜音。"
L["If checked, the minimap shape will be square."] = "勾選後，小地圖形狀將是方形的。"
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "勾選後，背包的空餘格數會顯示在背包按鈕以及提示上。"
L["If checked, the player frame background will be shown in class color."] = "勾選後，玩家框架背景將會顯示職業顏色。"
L["If checked, the professions frame will be larger."] = "勾選後，專業技能視窗將會放大。"
L["If checked, the quest difficulty will be shown next to the quest level in the quest log list.|n|nThis will indicate whether the quest requires a group (+), dungeon (D), raid (R) or PvP (P).|n|nThe quest difficulty will always be shown in the quest log detail pane regardless of this setting."] = "勾選後，任務難度將顯示在任務日誌列表中的任務級別旁邊。|n|n這將指示任務是否需要隊伍 (+)、地下城 (D)、團隊 (R) 或 PvP (P)。|n|n無論此設置如何，任務難度都將始終顯示在任務日誌詳細訊息視窗中。"
L["If checked, the quest log frame will be taller."] = "勾選後，任務日誌框架會更高。"
L["If checked, the ready check sound will be muted."] = "勾選後，準備確認音效將被靜音。"
L["If checked, the remaining flight time will be spoken using text to speech.|n|nChanges to this setting will take effect on the next flight you take."] = "勾選後，剩餘的飛行時間將使用文字轉語音進行。|n|n此設置的更改將於您採用的下階段航班生效。"
L["If checked, the scale slider will apply to the entire minimap cluster.|n|nNote that if you are using the default action bars, rescaling the cluster will also rescale the right action bars at startup so you may want to leave the scale slider at 100%.|n|nIf unchecked, the scale slider will only apply to the minimap."] = "勾選後，縮放卷軸將應用於整個小地圖群組。|n|n請注意，如果您使用預設動作列，重新縮放群組也會在啟動時重新縮放正常的動作列，因此您可能希望將縮放卷軸保留為 100%。|n|n如果未勾選，縮放卷軸將僅適用於小地圖。"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "勾選後，螢幕光暈將停用。|n|n啟用此選項同時也停用醉酒霧霾效果。"
L["If checked, the skill trainer frame will be larger and feature a train all skills button."] = "勾選後，技能學習框架將會略為放大，並且加入一個全部學習的按鈕。"
L["If checked, the spell fizzle sounds will be muted."] = "勾選後，法術嘶嘶聲將被靜音。"
L["If checked, the stance bar will not be shown."] = "勾選後，姿態條不再顯示。"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "勾選後，對話面板不再顯示。|n|n當NPC與你交流時，該框架通常出現在界面下方。"
L["If checked, the target frame background and focus frame background will be shown in class color."] = "勾選後，目標框架背景和焦點框架背景將以職業顏色顯示。"
L["If checked, the target frame background will be shown in class color."] = "勾選後，目標框架背景將會顯示職業顏色。"
L["If checked, the toggle headers button will be shown."] = "勾選後，將顯示切換標題按鈕。"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "勾選後，提示訊息會被著色，你可以設置他的佈局和大小尺寸。"
L["If checked, the tracking button will be hidden while the pointer is not over the minimap."] = "勾選後，當指針不在小地圖上時，跟踪按鈕將被隱藏。"
L["If checked, the vendor price will be shown in item tooltips."] = "勾選後，物品提示中將顯示商店售價。"
L["If checked, the world map button will be hidden."] = "勾選後，世界地圖按鈕將被隱藏。"
L["If checked, the zone text bar will be hidden."] = "勾選後，區域文字條將被隱藏。"
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "勾選後，縮放按鈕將隱藏。無論此設置如何，您都可以使用滑鼠滾輪進行縮放。"
L["If checked, tooltips for world units will be hidden during combat."] = "勾選後，世界單位的工具提示將在戰鬥中隱藏。"
L["If checked, train sounds will be muted."] = "勾選後，火車音效將被靜音。"
L["If checked, traveling merchant greetings and farewells will be muted.|n|nThis applies to Traveler's Tundra Mammoth."] = "勾選後，旅行商人的問候和告別將被靜音。|n|n這適用於旅行者的凍原猛獁象。"
L["If checked, unit targets will be shown."] = "勾選後，目標的目標會顯示在訊息視窗上。"
L["If checked, when someone pings the minimap, their name will be shown.  This does not apply to your pings."] = "勾選後，當有人敲擊小地圖時，會顯示他們的名字。這不適用於您的敲擊。"
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "勾選後，Wowhead 鏈接將顯示在世界地圖框架和成就框架中。"
L["If checked, Wowhead links will go directly to the comments section."] = "勾選後，Wowhead連結將直接轉到評論部分。"
L["If checked, yawns from hunter pet cats will be muted."] = "勾選後，獵人寵物貓的哈欠將被靜音。"
L["If checked, you can block spell links, drunken spam and duel spam."] = "勾選後，您可以阻擋法術連結、酒醉以及決鬥垃圾訊息。"
L["If checked, you can hold alt and drag the minimap to move it."] = "勾選後，你可以按住 alt 並拖動小地圖來移動它。"
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip item.|n|nIf the gossip item type is banker, taxi, trainer, vendor, battlemaster or stable master, gossip will be skipped without needing to hold the alt key.  You can hold the shift key down to prevent this."] = "勾選後，您可以在打開對話窗口時按住 alt 鍵自動選擇單個對話項目。|n|n如果對話項目類型是銀行員、鳥點、訓練師、商店、戰鬥大師或獸欄，對話將被跳過而無需按住 alt 鍵。您可以按住 shift 鍵來防止這種情況發生。"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "勾選後，你可以在點擊聊天標籤時按下Ctrl鍵，在易於複製的視窗中查看最近的聊天。"
L["If checked, you can hold shift while tooltips are hidden to show them temporarily."] = "勾選後，您可以在隱藏工具提示時按住shift以暫時顯示它們。"
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "勾選後，你可以使用方向鍵移動聊天框中的輸入點。|n|n如果未被勾選，方向鍵將保持它所綁定的按鍵功能。"
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "勾選後，你可以取消動畫而不經確認。"
L["If checked, you will be able to change the font size of book text."] = "勾選後，您將可以更改書籍中文字的大小。"
L["If checked, you will be able to change the font size of quest text."] = "勾選後，您將可以改變任務文字的字體大小。"
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "勾選後，你可以更改郵件文字的字體大小。|n|n這個選項不會影響使用系統範本的郵件（例如拍賣行的收據訊息）。"
L["If checked, you will be able to change the position and scale of the armored man durability frame."] = "勾選後，您將能夠更改裝甲人形耐久度框架的位置和縮放大小。"
L["If checked, you will be able to change the position and scale of the buffs frame."] = "勾選後，您將可以改變增益框架的位置與大小。"
L["If checked, you will be able to change the position and scale of the focus frame.|n|nNote that enabling this option will prevent you from using the default UI to move the focus frame."] = "勾選後，您將能夠更改焦點框架的位置和比例。|n|n請注意，啟用此選項將阻止您使用預設介面移動焦點框架。"
L["If checked, you will be able to change the position and scale of the player frame and target frame.|n|nNote that enabling this option will prevent you from using the default UI to move the player and target frames."] = "勾選後，您將能夠更改玩家框架和目標框架的位置和比例。|n|n請注意，啟用此選項將阻止您使用預設介面來移動玩家和目標框架。"
L["If checked, you will be able to change the position and scale of the timer bar.|n|nThe timer bar is used for showing remaining breath when underwater as well as other things."] = "勾選後，您將能夠更改計時器條的位置和大小。|n|n計時器條用於顯示水下時的剩餘呼吸以及其他內容。"
L["If checked, you will be able to change the position and scale of the vehicle seat indicator frame."] = "勾選後，您將能夠更改載具座椅指示器框架的位置和大小。"
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "勾選後，您將可以改變組件框架的位置與大小。|n|n此組件框架通常用於顯示PvP分數和追蹤的任務目標。"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "勾選後，你會生成一個視窗背景，這個可以在游戲界面周圍增加黑色的邊框背景。|n|n邊框的層級是處於游戲界面和插件之間，所以你仍可以放置插件元素在上面。"
L["If checked, you will be able to customise the minimap."] = "勾選後，您將可以自定義小地圖。"
L["If checked, you will be able to customise the quest log frame."] = "勾選後，您將能夠自定義任務日誌框架。"
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "勾選後，你可以把聊天視窗拖動到屏幕邊緣。"
L["If checked, you will be able to mute a selection of game sounds."] = "勾選後，您將可以靜音某些選擇的遊戲音效。"
L["If checked, you will be able to mute your own choice of sounds."] = "勾選後，您將能夠將自己選擇的聲音靜音。"
L["If checked, you will be able to pan (right-button) and zoom (mousewheel) in the character frame, dressup frame and inspect frame.|n|nA toggle stats button will be shown in the character frame.  You can also middle-click the character model to toggle stats.|n|nModel rotation controls will be hidden.  Buttons to toggle gear will be added to the dressup frame."] = "勾選後，您將能夠在角色視窗、試衣框架和觀察框架中平移（右鍵）和縮放（滑鼠滾輪）。|n|n一個切換統計按鈕將顯示在角色視窗中。您還可以中鍵單擊角色模型來切換屬性。|n|n模型旋轉控件將被隱藏。切換裝備的按鈕將添加到試衣框架中。"
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "勾選後，你可以在目標框架上放置最多5個有用的冷卻圖標。"
L["If checked, you will be able to reposition the tooltip."] = "勾選後，您可以重新定位工具提示。"
L["If checked, you will be able to set some additional rules for when your character is automatically dismounted."] = "勾選後，您將能夠為您的角色何時自動下坐騎設置一些額外的規則。"
L["If checked, you will be able to set the density of weather effects."] = "勾選後，您將可以設置天氣效果的密度。"
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "勾選後，會在玩家框架顯示稀有、精英或者稀有精英的邊框。"
L["If checked, you will be able to zoom out to a greater distance."] = "勾選後，你可以將鏡頭拉遠到更遠的距離。"
L["If checked, you will be dismounted when you attempt to cast a non-instant cast spell while moving."] = "勾選後，當您在移動時嘗試施放非即時施法法術時將會下坐騎。"
L["If checked, you will be dismounted when you attempt to cast a spell but don't have the rage, mana or energy to cast it."] = "勾選後，當您嘗試施展法術但沒有足夠的怒氣、法力或能量來施法時，將會下坐騎。"
L["If checked, you will be dismounted when you click a flight destination."] = "勾選後，當您點擊飛行目的地時將會下坐騎。"
L["If checked, you will be dismounted when you instruct a flight master to open the flight map."] = "勾選後，當您互動飛行管理員打開飛行地圖時，將會下坐騎。"
L["If checked, you will be prompted to submit missing flight times."] = "勾選後，系統將提示您提交缺失的航班時間。"
L["If checked, you will need to hold the override key down for quests to be automated.|n|nIf unchecked, holding the override key will prevent quests from being automated."] = "勾選後，您需要按住覆蓋鍵才能自動執行任務。|n|n如果未勾選，按住覆蓋鍵將阻止任務自動執行。"
L["If checked, you will no longer need to type delete when destroying a superior quality item.|n|nIn addition, item links will be shown in all item destroy confirmation windows."] = "勾選後，您在摧毀優良物品時無須再輸入delete。|n|n此外，物品連結將顯示在所有物品摧毀確認視窗中。"
L["If checked, you will not release automatically in Alterac Valley."] = "勾選後，您將不會在奧特蘭山谷中自動釋放。"
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "勾選後，您在戰場死亡時將會自動釋放。|n|n如果您具有自我復活的技能，則不會自動釋放。"
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant or bank."] = "勾選後，當你打開商店、銀行或者郵箱時，背包不會自動開啟或者關閉。"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "勾選後，你的聊天歷史記錄會增漲至4096行。如果未被勾選，會保持在預設的128行。|n|n啟用這個設置可能會在登錄時會隱藏一些聊天訊息。"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾選後，當你訪問適用的商店時，裝備將自動修理。|n|n當你開啟商店時可以按下Shift鍵以無視此設置。"
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "勾選後，區域文字不再顯示。"
L["If you use the 'Hide addon buttons' or 'Combine addon buttons' settings but you want some addon buttons to remain visible around the minimap, enter the addon names into the editbox separated by a comma.|n|nThe editbox tooltip shows the addon names that you can enter.  The names must match exactly with the names shown in the editbox tooltip though case does not matter.|n|nChanges to the list will require a UI reload to take effect."] = "如果您使用“隱藏插件按鈕”或“合併插件按鈕”設置，但希望一些插件按鈕在小地圖周圍保持可見，請在編輯框中輸入插件名稱，以逗號分隔。|n|n編輯框工具提示顯示您可以輸入的插件名稱。儘管大小寫無關緊要，但名稱必須與編輯框工具提示中顯示的名稱完全匹配。|n|n對列表的更改需要重載 UI 才能生效。"
L["If you want to listen to a sound file, enter the sound file ID into the editbox and click the play button.|n|nYou can scroll the mousewheel over the editbox to play neighbouring sound files."] = "如果要收聽聲音文件，請在編輯框中輸入聲音檔案ID，然後單擊播放按鈕。|n|n您可以在編輯框上滾動鼠標滾輪來播放相鄰的聲音文件。"
L["Incompatible"] = "不相容"
L["Increase chat history"] = "增加聊天歷史記錄"
L["Interface"] = "界面設置"
L["Invaders of Alterac Valley"] = "奧特蘭克的入侵者"
L["Invalid console variable."] = "無效控制台變量。"
L["Invalid parameter."] = "無效參數"
L["Invalid quest ID."] = "無效任務ID。"
L["Invalid sound ID"] = "無效聲音ID"
L["Invalid taint level."] = "無效的汙染等級。"
L["Invalid target."] = "無效的目標。"
L["Invite from whispers"] = "密語邀請"
L["Ironforge"] = "鐵爐堡"
L["Item"] = "物品"
L["Item ID"] = "物品ID"
L["Item IDs can be found in item toolips."] = "物品ID可以在物品工具提示上找到。"
L["Kalimdor"] = "卡林多"
L["Karazhan"] = "卡拉贊"
L["Kargath"] = "卡加斯"
L["Keep"] = "保留"
L["Keyword"] = "關鍵字"
L["Lakeshire"] = "湖畔鎮"
L["Leatrix Plus"] = "Leatrix Plus"
L["Leatrix Plus needs to be updated with the flight details.  Press CTRL/C to copy the flight details below then paste them into an email to flight@leatrix.com.  When your report is received, Leatrix Plus will be updated and you will never see this window again for this flight."] = "Leatrix Plus 需要更新飛航詳細資訊。按 CTRL/C 複製下面的飛航詳細訊息，然後將它們粘貼到電子郵件中至 flight@leatrix.com。收到您的報告後，Leatrix Plus 將更新，您將永遠不會再看到此航班的視窗。"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus將會在下次登出時覆寫LeaPlus數據庫。"
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: 安裝了錯誤的版本！"
L["Left"] = "左側"
L["Lifetime honorable kills"] = "榮譽擊殺總數"
L["Light's Hope Chapel"] = "聖光之願禮拜堂"
L["Link will search Wowhead"] = "連結將搜尋Wowhead"
L["Links go directly to the comments section"] = "連結直接轉到評論部分"
L["Loch Modan"] = "洛克莫丹"
L["Lockout sharing"] = "成就共享鎖定"
L["Login"] = "登入"
L["Low"] = "低"
L["M"] = "M"
L["Magic"] = "魔法"
L["Magisters' Terrace"] = "博學者殿堂"
L["Main Titles"] = "主標題"
L["Manage buffs"] = "管理增益"
L["Manage durability"] = "管理耐久度"
L["Manage focus"] = "操控焦點"
L["Manage frames"] = "管理框架面板"
L["Manage timer"] = "管理計時條"
L["Manage vehicle"] = "管理載具"
L["Manage widget"] = "管理組件"
L["Managed by Leatrix Plus"] = "由Leatrix Plus管理"
L["Map"] = "地圖"
L["Maraudon"] = "瑪拉頓"
L["Marks of Kil'jaeden"] = "基爾加丹印記"
L["Marks of Sargeras"] = "薩格拉斯印記"
L["Marshal's Refuge"] = "馬紹爾營地"
L["Max camera zoom"] = "最大鏡頭縮放"
L["Mechanics"] = "特性設置"
L["Mechsteps"] = "機械腳步"
L["Mechstriders"] = "機械陸行鳥"
L["Media"] = "音樂"
L["Medium"] = "中"
L["Memory Usage"] = "記憶體占用"
L["Menethil Harbor"] = "米奈希爾港"
L["message"] = "訊息"
L["message from previous session"] = "上個階段的訊息"
L["message shown."] = "顯示訊息。"
L["Messages"] = "訊息"
L["messages from previous session"] = "上個階段的訊息"
L["messages shown."] = "顯示訊息。"
L["Misc"] = "雜項"
L["Missing console variable."] = "缺少控制台變量。"
L["Missing mount name."] = "缺少坐騎名稱。"
L["Missing movie ID."] = "缺少動畫ID。"
L["Missing quest ID."] = "缺少任務ID。"
L["Missing sound file parameter."] = "缺少聲音檔案參數。"
L["Missing sound ID."] = "缺少聲音ID。"
L["Molten Core"] = "熔火之心"
L["Moonglade"] = "月光林地"
L["More Firewing Signets"] = "更多的火翼徽章"
L["More font sizes"] = "更多文字尺寸"
L["More Marks of Kil'jaeden"] = "更多的基爾加丹印記"
L["More Marks of Sargeras"] = "更多的薩格拉斯印記"
L["More Sunfury Signets"] = "更多的日怒徽章"
L["Morgan's Vigil"] = "摩根的崗哨"
L["Mount not found."] = "坐騎未找到。"
L["Mounts"] = "坐騎"
L["Move editbox to top"] = "輸入框移動至頂部"
L["Movie not playable."] = "動畫不可播放。"
L["Movie number"] = "動畫編號"
L["Movies"] = "動畫"
L["Mulgore"] = "莫高雷"
L["Music"] = "音樂"
L["Musical Moments"] = "音樂時刻"
L["Mute"] = "靜音"
L["Mute custom sounds"] = "靜音自定義聲音"
L["Mute game sounds"] = "遊戲音效靜音"
L["Muted"] = "已靜音"
L["Mystery"] = "秘法"
L["N"] = "N"
L["Nagrand"] = "納葛蘭"
L["Narration"] = "解說"
L["Naxxramas"] = "納克薩瑪斯"
L["Netherdrakes"] = "幽冥龍"
L["Nethergarde Keep"] = "守望堡"
L["Netherstorm"] = "虛空風暴"
L["Nijel's Point"] = "尼耶爾前哨站"
L["Nine minutes"] = "九分鐘"
L["No bad sound IDs found."] = "沒有發現損壞的聲音ID。"
L["No help is available for this page."] = "此頁面沒有幫助訊息。"
L["No items with durability equipped."] = "沒有裝備有耐久度的物品。"
L["No media duplicates found."] = "未找到重複的媒體檔。"
L["No supported addons."] = "不支援的插件。"
L["No tooltip showing."] = "目前沒有任何提示訊息。"
L["None"] = "無"
L["Not completed."] = "未完成。"
L["Not minimap"] = "不是小地圖"
L["Note that this will not reset settings that require a UI reload."] = "請注意，這不會重置需要重新載入UI的設定。"
L["Note that this will not reset your exclusions list."] = "請注意，這不會重置您的例外清單。"
L["Nothing to see here."] = "這沒東西可看。"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "警示！|n您必須完全重新啟動遊戲客戶端才能使用此版本的Leatrix Plus。"
L["NPC"] = "NPC"
L["Nude"] = "脫光"
L["Obsidian Sanctum"] = "黑曜聖所"
L["Oculus"] = "奧核之眼"
L["Okay, disable screen adjust for me"] = "好的，為我禁用螢幕調整"
L["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址"
L["One minute"] = "一分鐘"
L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
L["or click the minimap button to open Leatrix Plus."] = "或是點擊小地圖按鈕來開啟Leatrix Maps。"
L["Orgrimmar"] = "奧格瑪"
L["Outland"] = "外域"
L["Overall"] = "整體"
L["Overlay"] = "覆蓋"
L["Override key"] = "覆蓋鍵"
L["Particle density"] = "粒子密度"
L["Party from friends"] = "好友組隊邀請"
L["Pet"] = "寵物"
L["Pets"] = "寵物"
L["Pit of Saron"] = "薩隆陷坑"
L["Play"] = "播放"
L["Player"] = "玩家框架"
L["Please ask the addon author to use LibDBIcon."] = "請要求插件作者使用LibDB圖示。"
L["Power"] = "能量"
L["Press CTRL/C to copy"] = "按下CTRL/C來複製。"
L["Press CTRL/C to copy."] = "按下CTRL/C來複製。"
L["Queue from friends"] = "好友佇列申請"
L["R"] = "團隊"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "團隊副本"
L["Raid frame toggle"] = "切換團隊框架"
L["Random"] = "隨機"
L["RARE"] = "稀有"
L["RARE ELITE"] = "稀有精英"
L["Ratchet"] = "棘齒城"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼澤"
L["Ready"] = "預備"
L["Recent chat window"] = "最近聊天視窗"
L["Redridge Mountains"] = "赤脊山"
L["Refuge Pointe"] = "避難谷地"
L["Release in PvP"] = "PvP自動釋放屍體"
L["Reload"] = "重載插件"
L["Remember Alterac Valley!"] = "銘記奧特蘭克！"
L["Remove all items"] = "移除全部物品"
L["Remove tabard"] = "移除外袍"
L["Repair automatically"] = "自動修理裝備"
L["Repair using guild funds if available"] = "使用公會資金進行維修（如果有權限）"
L["Repaired for"] = "修理花費"
L["Replace non-standard buttons"] = "更換非標準按鈕"
L["Reposition the tooltip"] = "重新定位工具提示"
L["Require override key for quest automation"] = "任務自動化需要覆蓋鍵"
L["Requires UI reload."] = "需要重載插件"
L["Reset"] = "重置"
L["Resize book text"] = "書籍文字大小改變"
L["Resize mail text"] = "重設郵件文字"
L["Resize quest text"] = "重設任務文字"
L["Resize Screen"] = "螢幕縮放"
L["Rested bubbles"] = "休息氣泡訊息"
L["Restore chat messages"] = "恢復聊天訊息"
L["Restored"] = "已恢復"
L["Restrict to friends"] = "僅限好友"
L["result"] = "結果"
L["results"] = "結果"
L["Return"] = "返回"
L["Revantusk Village"] = "惡齒村"
L["Rhonin"] = "羅甯"
L["Right"] = "右側"
L["Right-click to close"] = "右鍵點擊來關閉"
L["Right-click to close."] = "右鍵點擊來關閉。"
L["right-click to go back"] = "右鍵點擊返回"
L["Ripper"] = "劫奪者"
L["Ruby Sanctum"] = "晶紅聖所"
L["Ruins of Ahn'Qiraj"] = "安琪拉廢墟"
L["Rut'theran Village"] = "魯瑟蘭村"
L["Sacred"] = "神聖"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "沙怒、劈顱和血頂硬幣"
L["Scale"] = "尺寸"
L["Scale entire cluster"] = "縮放整個群組"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通靈學院"
L["Screech"] = "尖嘯"
L["Search"] = "搜尋"
L["Search mats?"] = "搜尋材料？"
L["Searing Gorge"] = "灼熱峽谷"
L["seconds"] = "秒"
L["seconds does not match the saved flight time of"] = "保存的飛行時間秒數不符合"
L["Select the settings that you want to use."] = "選擇你想啟用的設置。"
L["Selection of music tracks"] = "選擇的音樂曲目"
L["Self Markers Allowed"] = "允許自身標記"
L["Self Markers Blocked"] = "阻擋自身標記"
L["Sell"] = "出售"
L["Sell junk automatically"] = "自動出售垃圾"
L["SELLING JUNK"] = "出售垃圾"
L["Sentinel Hill"] = "哨兵嶺"
L["Set weather density"] = "設置天氣效果密度"
L["Settings"] = "設置"
L["Seven minutes"] = "七分鐘"
L["Shaders"] = "陰影"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Valley"] = "影月谷"
L["Shadowprey Village"] = "葬影村"
L["Shardtooth E'ko"] = "碎齒魂精"
L["SHIFT"] = "SHIFT"
L["Sholazar Basin"] = "休拉薩盆地"
L["Show animation slider"] = "顯示動作卷軸"
L["Show auction controls"] = "顯示拍賣行控制"
L["Show background"] = "顯示背景"
L["Show bag search box"] = "顯示背包搜尋框"
L["Show cancel form button on flight map"] = "在飛行地圖上顯示取消變形按鈕"
L["Show character addons"] = "顯示角色插件"
L["Show cooldowns"] = "顯示冷卻"
L["Show cooldowns above the player frame"] = "在玩家框架上方顯示冷卻時間"
L["Show destination"] = "顯示目的地"
L["Show druid power bar"] = "顯示德魯伊能量條"
L["Show durability status"] = "顯示耐久度"
L["Show flight times"] = "顯示飛行時間"
L["Show free bag slots"] = "顯示背包空餘格數"
L["Show guild names"] = "顯示公會名稱"
L["Show guild ranks for other guilds"] = "顯示其他公會的公會階級"
L["Show guild ranks for your guild"] = "顯示您公會的公會等級"
L["Show item buttons"] = "顯示物品按鈕"
L["Show me"] = "顯示我"
L["Show minimap button"] = "顯示小地圖按鈕"
L["Show player chain"] = "顯示玩家邊框"
L["Show player frame in class color"] = "玩家框架顯示職業顏色"
L["Show quest difficulty in quest log list"] = "在任務日誌列表中顯示任務難度"
L["Show quest levels"] = "顯示任務等級"
L["Show raid button"] = "顯示團隊按鈕"
L["Show ready timer"] = "顯示準備確認計時器"
L["Show repair summary in chat"] = "在聊天中顯示修理總結"
L["Show target frame and focus frame in class color"] = "以職業顏色顯示目標框和焦點框"
L["Show target model"] = "顯示目標模組"
L["Show the spell ID in buff icon tooltips"] = "在增益圖標提示顯示法術ID"
L["Show toggle headers button"] = "顯示切換標題按鈕"
L["Show tooltips with shift key"] = "使用shift鍵顯示工具提示"
L["Show train all skills button"] = "顯示訓練所有技能按鈕"
L["Show unit targets"] = "顯示單位目標"
L["Show vanity controls"] = "顯示外觀控制鍵"
L["Show vendor price"] = "顯示商店售價"
L["Show vendor summary in chat"] = "在聊天中顯示商店總結"
L["Show volume slider"] = "顯示音量控制"
L["Show web link"] = "顯示網頁連結"
L["Show who pinged"] = "顯示誰敲擊小地圖"
L["Show Wowhead links"] = "顯示Wowhead連結"
L["Silence rested emotes"] = "表情靜音"
L["Silithus"] = "希利蘇斯"
L["Silverpine Forest"] = "銀松森林"
L["Single Mark of Sargeras"] = "一個薩格拉斯印記"
L["Single Sunfury Signet"] = "一個日怒徽章"
L["Six minutes"] = "六分鐘"
L["skill for"] = "技能 "
L["skills for"] = "技能 "
L["Social"] = "社交訊息"
L["Sold junk for"] = "賣出垃圾為"
L["sound"] = "聲音"
L["Sound system restarted."] = "聲音系統已重啟。"
L["Southshore"] = "南海鎮"
L["Speak the remaining time"] = "說出剩餘時間"
L["Spell"] = "法術"
L["Spell ID"] = "法術ID"
L["Splintertree Post"] = "碎木崗哨"
L["Spooky"] = "幽靈"
L["Square minimap"] = "方形小地圖"
L["Square size"] = "方形大小"
L["Stockade"] = "暴風城監獄"
L["Stonard"] = "斯通納德"
L["Stonetalon Mountains"] = "石爪山脈"
L["Stonetalon Peak"] = "石爪峰"
L["Stop"] = "停止"
L["Storm Peaks"] = "風暴群山"
L["Stormwind"] = "暴風城"
L["Stranglethorn Vale"] = "荊棘谷"
L["Stratholme"] = "斯坦索姆"
L["Sun Rock Retreat"] = "烈日石居"
L["Sunfury Signets"] = "日怒徽章"
L["Sunken Temple"] = "沉沒的神廟"
L["Sunwell Plateau"] = "太陽之井高地"
L["Support"] = "支援"
L["Supported Addons"] = "支援的插件"
L["Swamp"] = "沼澤"
L["Swamp of Sorrows"] = "悲傷沼澤"
L["System"] = "系統設置"
L["T"] = "T"
L["Tabard"] = "隱藏戰袍"
L["Taint level: Basic (1)."] = "汙染等級：基本(1)"
L["Taint level: Disabled (0)."] = "汙染等級：停用(0)"
L["Taint level: Full (2)."] = "汙染等級：完整(2)"
L["Taller quest log frame"] = "更高的任務日誌框架"
L["Talonbranch Glade"] = "刺枝林地"
L["Talrendis Point"] = "塔倫迪斯營地"
L["Tanaris"] = "塔納利斯"
L["Target"] = "目標框架"
L["Target Tracking Disabled"] = "停用目標追蹤"
L["Target Tracking Enabled"] = "啟用目標追蹤"
L["Tarren Mill"] = "塔倫米爾"
L["Teldrassil"] = "泰達希爾"
L["Tempest Keep"] = "風暴要塞"
L["Temple of Ahn'Qiraj"] = "安琪拉神廟"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神廟"
L["Ten minutes"] = "十分鐘"
L["Ten seconds"] = "十秒"
L["Ten Years of Warcraft"] = "魔獸十周年"
L["Terokkar Forest"] = "泰洛卡森林"
L["Text"] = "文字訊息"
L["Text size"] = "字體尺寸"
L["Text Size"] = "字體尺寸"
L["Thalanaar"] = "薩蘭納爾"
L["The Burning Crusade"] = "燃燒的遠征"
L["The game will dismount you if you successfully cast a spell without addons.  These settings let you set some additional dismount rules."] = "在沒有插件下如果您成功施放法術，遊戲將使您下坐騎。這些設置讓您可以設置一些額外的下坐騎規則。"
L["The Sepulcher"] = "瑟伯切爾"
L["The square minimap will always show the new covenant button."] = "方形小地圖將始終顯示新誓盟按鈕。"
L["The summon from"] = "召喚來自"
L["Thelsamar"] = "塞爾薩瑪"
L["Themes"] = "主題"
L["Theramore"] = "塞拉摩"
L["There is a helpful guide on leatrix.com."] = "leatrix.com 上有一個有用的指南。"
L["These items will not be sold."] = "這些物品將不會出售。"
L["Thirty seconds"] = "三十秒"
L["This flight does not exist in the database."] = "該航班在數據庫中不存在。"
L["This flight does not have a saved duration in the database."] = "此航班在數據庫中沒有保存的持續時間。"
L["This flight's actual time of"] = "該航班的實際時間"
L["This is a custom button."] = "這是一個自定義按鈕。"
L["This panel will close automatically if you enter combat."] = "此面板將在你進入戰鬥後自動關閉。"
L["This slider requires 'Square minimap' to be enabled."] = "此卷軸需要啟用 '方形小地圖'。"
L["Thorium Point"] = "瑟銀哨塔"
L["Thousand Needles"] = "千針石林"
L["Three minutes"] = "三分鐘"
L["Thunder Bluff"] = "雷霆崖"
L["Timer"] = "計時框架"
L["Tirisfal Glades"] = "提里斯法林地"
L["Titan Panel screen adjust needs to be disabled for the frame to be saved correctly."] = "需要禁用 Titan Panel 螢幕調整才能正確保存框架。"
L["to"] = "到"
L["To begin, choose an options page."] = "請選擇一個選項開始使用"
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "你需要禁用ElvUI的聊天模塊以隱藏戰鬥記錄。"
L["To move the minimap, hold down the alt key and drag it."] = "要移動小地圖，請按住 alt 鍵並拖動它。"
L["To move the minimap, hold down the alt key and drag it.|n|nIf you toggle an addon minimap button, you may need to reload your UI for the change to take effect.  This only affects a few addons that use custom buttons.|n|nThis panel will close automatically if you enter combat."] = "要移動小地圖，請按住 alt 鍵並拖動它。|n|n如果您切換插件小地圖按鈕，您可能需要重新載入UI以使更改生效。這只會影響一些使用自定義按鈕的插件。|n|n如果您進入戰鬥，此面板將自動關閉。"
L["To use the Find Item button, you need to deselect the WoW Token category."] = "要使用此搜尋物品按鈕，您需要取消選擇WoW的代幣類別"
L["Toggle buttons"] = "切換按鈕"
L["Toggle character stats"] = "切換角色屬性"
L["Toggle Grid"] = "切換對齊網格"
L["Toggle panel"] = "切換面板"
L["took"] = "接著"
L["Tooltip"] = "提示訊息"
L["Tooltip title color"] = "鼠標提示訊息顏色。"
L["Top"] = "頂部"
L["Top Center"] = "頂級中心"
L["Tracing started."] = "追蹤已開始。"
L["Tracing stopped."] = "追蹤已停止。"
L["Train"] = "學習"
L["Train All"] = "全部學習"
L["Trains"] = "火車"
L["Transparency"] = "透明度"
L["Travelers"] = "旅行商人"
L["True"] = "真實"
L["Turn-in completed quests automatically"] = "自動交付完成的任務"
L["Twenty seconds"] = "二十秒"
L["Two minutes"] = "二分鐘"
L["Uldaman"] = "奧達曼"
L["Ulduar"] = "奧杜亞"
L["Unclamp chat frame"] = "不限制視窗位置"
L["Undercity"] = "幽暗城"
L["Un'Goro Crater"] = "安戈洛環形山"
L["Universal group color"] = "通用的隊伍著色"
L["Unlock the minimap"] = "解鎖小地圖"
L["Unmute"] = "未靜音"
L["Use arrow keys in chat"] = "允許使用方向鍵"
L["Use class colors in chat"] = "在聊天中使用職業著色"
L["Use easy resizing"] = "使用簡單拉伸"
L["Utgarde Keep"] = "俄特加德要塞"
L["Utgarde Pinnacle"] = "俄特加德之巔"
L["Valormok"] = "瓦羅莫克"
L["Value must be a number."] = "值必須為數字。"
L["Various"] = "雜項"
L["Vault of Archavon"] = "亞夏梵穹殿"
L["Vaults"] = "金庫"
L["Vendors"] = "商店"
L["Version"] = "版本"
L["Very Low"] = "非常低"
L["Video"] = "影像"
L["Visibility"] = "可見性"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Warning"] = "警告"
L["was automatically declined."] = "已經自動拒絕。"
L["Weather density"] = "天氣密度"
L["Welcome to Leatrix Plus."] = "歡迎使用Leatrix Plus"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "濕地"
L["Widget"] = "窗口小部件"
L["Width"] = "寬度"
L["Wildkin E'ko"] = "梟獸魂精"
L["will be automatically accepted in 10 seconds unless cancelled."] = "除非取消否則將會在10秒內自動接受。"
L["Winter"] = "寒冬"
L["Winterfall E'ko"] = "寒水魂精"
L["Wintergrasp"] = "冬之握"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft"] = "魔獸世界"
L["Wrath of the Lich King"] = "巫妖王之怒"
L["Wrath of the Lich King Classic"] = "巫妖王之怒經典版"
L["X Offset"] = "水平偏移"
L["Y Offset"] = "垂直偏移"
L["Yawns"] = "哈欠"
L["YOU"] = "你"
L["You cannot do that in combat."] = "你無法在戰鬥中進行該項操作。"
L["You have"] = "你有"
L["You need to be group leader."] = "你需要成為隊長。"
L["You should keybind web link!"] = "你應該按鍵綁定網頁連結！"
L["You should set a keybind for the web link feature.  It's very useful.|n|nOpen the key bindings window (accessible from the game menu) and click Leatrix Plus.|n|nSet a keybind for Show web link.|n|nNow when your pointer is over an item, NPC or spell (and more), press your keybind to get a web link."] = "您應該為網頁連結功能設置一個按鍵綁定。它非常有用。|n|n打開按鍵綁定視窗（可從遊戲選單訪問）並單擊Leatrix Plus。|n|n為顯示網頁連結設置按鍵綁定。|n|n現在，當您的指針在物品、NPC 或法術（以及更多）上時，按下您的按鍵綁定以獲取網頁連結。"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "你需要進行重載插件後才能使部分設置生效。|n|n你無需立即點擊重載插件按鈕，但是你完成設置並希望其生效時，必須點擊它。"
L["Your UI needs to be reloaded."] = "你的插件需要重新載入。"
L["Zangarmarsh"] = "贊格沼澤"
L["Zones"] = "區域"
L["Zoram'gar Outpost"] = "左拉姆加前哨站"
L["Zul'Aman"] = "祖阿曼"
L["Zul'Drak"] = "祖爾德拉克"
L["Zul'Farrak"] = "祖爾法拉克"
L["Zul'Gurub"] = "祖爾格拉布"
L["Zulian, Razzashi, and Hakkari Coins"] = "祖利安、拉札希和哈卡萊硬幣"
L["Zygor addon not found."] = "你尚未安裝Zygor插件。"

end

-- ruRU: Russian
if GameLocale == "ruRU" then
L["+"] = "+"
L["A Donation of Mageweave"] = "Пожертвование: магическая ткань"
L["A Donation of Runecloth"] = "Пожертвование: рунная ткань"
L["A Donation of Silk"] = "Пожертвование: шелк"
L["A Donation of Wool"] = "Пожертвование: шерсть"
L["A friend request from"] = "Запрос дружбы от"
L["Accept available quests automatically"] = "Принимать доступные квесты автоматически"
L["Accept resurrection"] = "Принятие воскрешения"
L["Accept summon"] = "Принятие призыва"
L["A'dal"] = "А'дал"
L["Additional Runecloth"] = "Больше рунной ткани"
L["Addon"] = "Модификация"
L["Aerie Peak"] = "Заоблачный пик"
L["Ahn'kahet (Old Kingdom)"] = "Ан'кахет (Старое Королевство)"
L["Ahn'Qiraj"] = "Ан'Кираж"
L["ALT"] = "ALT"
L["Alterac Mountains"] = "Альтеракские горы"
L["Anchor"] = "Якорь"
L["Angelic"] = "Ангельский"
L["Announce rare"] = "Оповещать о рарниках"
L["Arathi Highlands"] = "Нагорье Арати"
L["Ashenvale"] = "Ясеневый лес"
L["Astranaar"] = "Астранаар"
L["Auberdine"] = "Аубердин"
L["Auto loot is now enabled."] = "Автоматическая добыча включена."
L["AutoFollow"] = "Автоматическое следование"
L["AutoFollow disabled."] = "Автоматическое следование выключено"
L["Automate gossip"] = "Автоматизация общения"
L["Automate quests"] = "Автоматизация квестов"
L["Automatic Release Cancelled"] = "Отмена авто. воскрешения"
L["Automation"] = "Автоматизация"
L["Azjol-Nerub"] = "Азжол-Неруб"
L["Azshara"] = "Азшара"
L["Azuremyst Isle"] = "Остров Лазурной Дымки"
L["B"] = "B"
L["Back to Main Menu"] = "В главное меню"
L["Bad ID"] = "Плохой id"
L["Badlands"] = "Бесплодные земли"
L["Barrens"] = "Южные степи"
L["Battle"] = "Боевой"
L["Battle of Warsong Gulch"] = "Битва за Ущелье Песни Войны"
L["Battlegrounds"] = "Поля боя"
L["BCC"] = "BCC"
L["Bikes"] = "Мотоцикл"
L["Black Morass"] = "Черные топи"
L["Black Temple"] = "Черный храм"
L["Blackfathom Deeps"] = "Непроглядная Пучина"
L["Blackrock Depths"] = "Глубины Черной горы"
L["Blackwing Lair"] = "Логово Крыла Тьмы"
L["Blade's Edge Mountains"] = "Острогорье"
L["Blasted Lands"] = "Выжженные земли"
L["Block drunken spam"] = "Блок пьяного спама"
L["Block duel spam"] = "Блок спама дуэли"
L["Block duels"] = "Блок дуэлей"
L["Block friend requests"] = "Блок запросов дружбы"
L["Block party invites"] = "Блок приглашений в группу"
L["Block shared quests"] = "Заблокировать предложение заданий"
L["Block spell links during combat"] = "Блок ссылок на заклинания во время боя"
L["Blocks"] = "Блокировки"
L["Bloodmyst Isle"] = "Остров Кровавой Дымки"
L["Booty Bay"] = "Пиратская бухта"
L["Borean Tundra"] = "Борейская тундра"
L["Bottom"] = "Нижняя"
L["Brackenwall Village"] = "Деревня Гиблотопь"
L["Brooms"] = "Метлы"
L["Buffs"] = "Бафы"
L["Burning Crusade"] = "Burning Crusade"
L["Burning Crusade Classic"] = "Burning Crusade Classic"
L["Burning Steppes"] = "Пылающие степи"
L["Buttons"] = "Кнопки"
L["Buttons for the addons listed below will remain visible."] = "Кнопки для перечисленных ниже аддонов останутся видимыми."
L["Buyout Only"] = "Только выкуп"
L["by Leatrix Plus"] = "от Leatrix Plus"
L["C"] = "C"
L["Camera distance"] = "Дистанция камеры"
L["Camp Mojache"] = "Лагерь Мохаче"
L["Camp Taurajo"] = "Лагерь Таурахо"
L["Cannot announce in this zone."] = "Не могу объявить в этой зоне."
L["Cannot be sold"] = "Не может быть продан"
L["Cannot find General chat channel."] = "Не удаётся найти общий канал чата."
L["Cannot use this with your locale."] = "Невозможно использовать с вашей локализацией."
L["Cenarion Hold"] = "Крепость Кенария"
L["Chain style"] = "Стиль контура"
L["Character"] = "Персонаж"
L["Chat"] = "Чат"
L["Chat Frame"] = "Окно чата"
L["Checkbox labels are Ok."] = "Сокращать описания."
L["Chillwind Camp"] = "Лагерь Промозглого Ветра"
L["Chillwind E'ko"] = "Э'ко стылодыхов"
L["Chimes"] = "Куранты"
L["Cinematics"] = "Видеоролики"
L["Claiming Arathi Basin"] = "Завоевание Низины Арати"
L["Class colored frames"] = "Фон имени в цвете класса"
L["Class icon portraits"] = "Изображение класса в портрете"
L["Classic"] = "Классик"
L["click here for new selection"] = "Нажмите сюда для создания новой подборки"
L["Click to close the currently active flight progress bar."] = "Нажмите, чтобы закрыть текущий индикатор времени полета."
L["Click to configure the settings for this option."] = "Нажмите, чтобы перейти к интерфейсу дополнительных параметров этой настройки."
L["Click to disable Titan Panel screen adjust.  Your UI will be reloaded."] = "Нажмите, чтобы отключить подстройку экрана от Титан Панели. Ваш интерфейс будет перезагружен."
L["Click to mute sounds in the list."] = "Нажмите, чтобы отключить звуки в списке."
L["Click to reset the settings on this page."] = "Нажмите, чтобы сбросить настройки на этой странице."
L["Click to resize the screen to fit between the top and bottom borders."] = "Нажмите, чтобы оптимизировать размер экрана."
L["Click to return to the main menu."] = "Нажмите, чтобы вернуться в главное меню."
L["Click to toggle the addon buttons editor."] = "Нажмите, чтобы переключить редактор кнопок аддонов."
L["Click to toggle the frame alignment grid."] = "Нажмите, чтобы переключить сетку выравнивания."
L["Click to unmute sounds in the list."] = "Щелкните, чтобы отключить звуки в списке."
L["Cloak"] = "Плащ"
L["Close"] = "Закрыть"
L["Close Bar"] = "Закрыть панель"
L["Cluster scale"] = "Масштаб кластера"
L["CMD (MAC)"] = "CMD"
L["Coilfang Reservoir"] = "Резервуар Кривого Клыка"
L["Collapse"] = "Коллапс"
L["Combat log cannot be hidden while undocked."] = "Журнал боя не может быть скрыт, пока он не закреплен"
L["Combat plates"] = "Индикаторы"
L["Combine addon buttons"] = "Объединить кнопки аддона"
L["Completed."] = "Завершено."
L["Concerted Efforts"] = "В едином порыве"
L["Configuration Panel"] = "Панель настроек"
L["Connections for"] = "Соединения с"
L["Conquering Arathi Basin"] = "Завоевание Низины Арати"
L["Contribute"] = "Способствовать"
L["CONTROL"] = "CONTROL"
L["Copied to clipboard."] = "Скопировано в буфер обмена."
L["Credits"] = "Благодарности"
L["Crossroads"] = "Перекресток"
L["Crystalsong Forest"] = "Лес Хрустальной Песни"
L["Culling of Stratholme"] = "Очищение Стратхольма"
L["Cursor"] = "Курсор"
L["Cursor Left"] = "Курсор слева"
L["Cursor Right"] = "Курсор вправо"
L["D"] = "П"
L["Darkmoon Faire"] = "Ярмарка Новолуния"
L["Darkshire"] = "Темнолесье"
L["Darkshore"] = "Темные берега"
L["Deadmines"] = "Пещеры Стенаний"
L["Deadwind Pass"] = "Перевал Мертвого Ветра"
L["Delay"] = "Задержка"
L["Desolace"] = "Пустоши"
L["Dire Maul"] = "Забытый Город"
L["Disable bag automation"] = "Деавтоматизация сумок"
L["Disable chat fade"] = "Откл. исчезание текста"
L["Disable loot warnings"] = "Отключить предупреждения о добыче"
L["Disable screen effects"] = "Откл. экранные эффекты"
L["Disable screen glow"] = "Откл. свечение экрана"
L["Disable sticky chat"] = "Отключить липкий чат"
L["Dismount me"] = "Спешивать меня"
L["Dismount when casting a spell while moving"] = "При произнесении заклинания во время движения"
L["Dismount when clicking a flight destination"] = "При выборе конечной точки перелёта"
L["Dismount when not enough rage, mana or energy"] = "Если не достаточно ярости, маны или энергии"
L["Dismount when the flight map opens"] = "При открытии окна карты"
L["Do you want to use Leatrix Plus Enhanced Minimap or ElvUI Minimap?"] = "Вы хотите использовать улучшенную миникарту Leatrix Plus или миникарту ElvUI?"
L["Drag the frame overlay to position the frame."] = "Переместите рамку, чтобы изменить позицию фрейма."
L["Drag the frame overlay to position the frame.|n|nThis panel will close automatically if you enter combat."] = "Перемещайте слой фрейма, чтобы установить его положение.|n|nЭта панель закроется автоматически, если вы вступите в бой."
L["Drag the frame overlay with the left button to position it freely or with the right button to position it using snap-to-grid."] = "Переместите рамку, с помощью левой кнопки, для свободного перемещения, или с помощью правой кнопки, для перемещения с использованием привязки к сетке."
L["Drag the frame overlay with the left button to position it freely or with the right button to position it using snap-to-grid.|n|nThis panel will close automatically if you enter combat."] = "Переместите рамку, с помощью левой кнопки, для свободного перемещения, или с помощью правой кнопки, для перемещения с использованием привязки к сетке.|n|nЭта панель скроется автоматически, если вы вступите в бой."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Перетащите фрейм, чтобы изменить позицию. Чтобы изменить масштаб окна, щелкните по его рамке, а затем отрегулируйте масштаб ползунком на странице настроек.Эта панель закроется автоматически, если Вы начнёте бой."
L["Drag the frame overlays with the left button to position them freely or with the right button to position them using snap-to-grid.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Переместите рамку, с помощью левой кнопки, для свободного перемещения, или с помощью правой кнопки, для перемещения с использованием привязки к сетке.|n|nЧтобы изменить масштаб рамки, щелкните по ней, чтобы выделить, а затем отрегулируйте ползунок масштаба.|n|nЭта панель закроется автоматически, если вы вступите в бой."
L["Drag to set the buffs frame scale."] = "Переместите ползунок влево или вправо, чтобы установить размер фрейма баффов"
L["Drag to set the cluster scale.|n|nNote: Adjusting the cluster scale affects the entire cluster including frames attached to it such as the buffs frame and objectives tracker.|n|nIt will also cause the default UI right-side action bars to scale when you login.  If you use the default UI right-side action bars, you may want to leave this at 100%."] = "Переместите ползунок, чтобы установить масштаб кластера.|n|nПримечание: Настройка масштаба кластера влияет на весь кластер, включая прикрепленные к нему фреймы, такие как фрейм баффов и трекер целей.|n|nЭто также приведет к изменению масштаба правых панелей действий пользовательского интерфейса по умолчанию при входе в систему. Если вы используете стандартные правые панели действий пользовательского интерфейса, вам лучше оставить значение 100%."
L["Drag to set the cluster scale.|n|nNote: Adjusting the cluster scale affects the entire cluster including frames attached to it such as the quest watch frame.|n|nIt will also cause the default UI right-side action bars to scale when you login.  If you use the default UI right-side action bars, you may want to leave this at 100%."] = "Перетащите, чтобы установить масштаб кластера.|n|nПримечание: Изменение масштаба кластера влияет на весь кластер, включая прикрепленные к нему элементы, такие как панель отслеживания заданий.|n|nЭто также вызовет масштабирование стандартных боковых панелей действий интерфейса при входе в систему. Если вы используете стандартные боковые панели действий интерфейса, вам может потребоваться оставить это значение на 100%."
L["Drag to set the cursor X offset."] = "Переместите ползунок влево или вправо, чтобы установить смещение курсора по оси X."
L["Drag to set the cursor Y offset."] = "Переместите ползунок влево или вправо, чтобы установить смещение курсора по оси Y."
L["Drag to set the density of weather effects."] = "Переместите ползунок влево или вправо, чтобы установить желаемую плотность погодных эффектов."
L["Drag to set the durability frame scale."] = "Переместите, чтобы установить масштаб прочности."
L["Drag to set the flight progress bar scale."] = "Переместите, чтобы установить масштаб панели полёта."
L["Drag to set the flight progress bar width."] = "Переместите, чтобы установить ширину панели полёта."
L["Drag to set the focus frame scale."] = "Перемещайте ползунок, чтобы установить масштаб фрейма."
L["Drag to set the font size of book text."] = "Переместите ползунок влево или вправо, чтобы установить размер шрифта текста книги."
L["Drag to set the font size of mail text."] = "Переместите ползунок влево или вправо, чтобы установить размер шрифта для текста почтовых сообщений"
L["Drag to set the font size of quest text."] = "Переместите ползунок влево или вправо, чтобы установить размер шрифта для текста квестов."
L["Drag to set the minimap scale.|n|nAdjusting this slider makes the minimap and all the elements bigger."] = "Переместите ползунок, чтобы установить масштаб миникарты.|n|nПри перемещении этого ползунка и сама миникарта и все её элементы становятся больше."
L["Drag to set the number of milliseconds before you are automatically released.|n|nYou can hold down shift as the timer is ending to cancel the automatic release."] = "Переместите ползунок влево или вправо, чтобы установить задержку перед автоматическим оживлением в миллисекундах.|n|nВы можете удерживать нажатой клавишу Shift до истечения таймера, чтобы отменить автоматическое воскрешение."
L["Drag to set the scale of the Leatrix Plus panel."] = "Переместите ползунок влево или вправо, чтобы установить масштаб панели Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Переместите ползунок влево или вправо, чтобы установить масштаб выбранного фрейма."
L["Drag to set the size of the bottom border."] = "Перемещайте, чтобы установить размер нижней границы."
L["Drag to set the size of the left border."] = "Перемещайте, чтобы установить размер левой границы."
L["Drag to set the size of the right border."] = "Перемещайте, чтобы установить размер правой границы."
L["Drag to set the size of the top border."] = "Перемещайте, чтобы установить размер верхней границы."
L["Drag to set the square minimap size.|n|nAdjusting this slider makes the minimap bigger but keeps the elements the same size."] = "Переместите ползунок, чтобы установить размер квадратной миникарты.|n|nПри перемещении этого ползунка сама миникарта становится больше, но её элементы остаются прежнего размера."
L["Drag to set the timer bar scale."] = "Переместите, чтобы установить масштаб таймера."
L["Drag to set the tooltip scale."] = "Переместите ползунок влево или вправо, чтобы установить масштаб всплывающей подсказки."
L["Drag to set the transparency of the borders."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность границ."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность панели Leatrix Plus."
L["Drag to set the vehicle seat indicator frame scale."] = "Переместите, чтобы установить размер фрейма сёдел для транспорта. "
L["Drag to set the widget scale."] = "Переместите ползунок, чтобы установить масштаб виджета."
L["Drag to size"] = "Перетащите до размера"
L["Dragonblight"] = "Драконий Погост"
L["Drak'Tharon Keep"] = "Крепость Драк'Тарон"
L["Dun Morogh"] = "Дун Морог"
L["Dungeons"] = "Подземелья"
L["Dup ID"] = "Копия id"
L["Duplicates"] = "Дубликаты"
L["durability"] = "прочность"
L["Durability"] = "Прочность"
L["Duration"] = "Продолжительность"
L["Durotar"] = "Дуротар"
L["Duskwood"] = "Сумеречный лес"
L["Dustwallow Marsh"] = "Пылевые топи"
L["Eastern Kingdoms"] = "Восточные королевства"
L["Eastern Plaguelands"] = "Восточные Чумные земли"
L["Easy item destroy"] = "Лёгкое уничтожение"
L["Editor"] = "Редактор"
L["Eight minutes"] = "Восемь минут"
L["ELITE"] = "Элитный"
L["ElvUI"] = "ElvUI"
L["Elwynn Forest"] = "Элвиннский лес"
L["Enable viewport"] = "Включить полосы"
L["Enhance dressup"] = "Улучшить примерочную"
L["Enhance minimap"] = "Улучшить миникарту"
L["Enhance professions"] = "Улучшить окно профессий"
L["Enhance quest log"] = "Улучшить журнал заданий"
L["Enhance tooltip"] = "Улучшить подсказки"
L["Enhance trainers"] = "Улучшить окно тренера"
L["Enhancements"] = "Улучшения"
L["Enter"] = "Войти"
L["Enter item IDs separated by commas.  Item IDs can be found in item tooltips while this panel is showing.|n|nJunk items entered here will not be sold automatically.|n|nWhite items entered here will be sold automatically.|n|nThe editbox tooltip will show you more information about the items you have entered."] = "Введите ID предметов, разделенные запятыми. ID предметов можно найти в вслывающей подсказке предметов во время отображения этой панели.|n|nХлам, введенный здесь, не будет продаваться автоматически.|n|nБелые предметы, введенные здесь, будут продаваться автоматически.|n|Всплывающая nподсказка окна редактирования, покажет вам более подробную информацию о введенных вами предметах."
L["Enter junk item IDs separated by commas."] = "Введите ID хлама, разделенного запятыми."
L["Enter sound file IDs separated by comma then click the Mute button.|n|nIf you wish, you can enter a brief note for each file ID but do not include numbers in your notes.|n|nFor example, you can enter 'DevAura 569679, RetAura 568744' to mute the Devotion Aura and Retribution Aura spells.|n|nUse Leatrix Sounds to find, test and play sound file IDs."] = "Введите идентификаторы звуковых файлов через запятую и нажмите кнопку Заглушить.|n|nПри желании вы можете ввести краткое примечание к каждому идентификатору файла, но не включайте в примечания цифры.|n|nНапример, вы можете ввести 'DevAura 569679, RetAura 568744', чтобы отключить заклинания Devotion Aura и Retribution Aura.|n|nИспользуйте Leatrix Sounds для поиска, тестирования и воспроизведения идентификаторов звуковых файлов."
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Введите ID заклинаний, иконки которых хотите видеть. Если значок перезарядки появляется под рамкой питомца, то нажмите галочку. Иконки восстановления сохраняются для вашего класса."
L["enter zone or track name"] = "введите название зоны или трека"
L["Error messages will be hidden"] = "Сообщения об ошибках будут скрыты"
L["Error messages will be shown"] = "Сообщения об ошибках будут показаны"
L["Events"] = "События"
L["Everlook"] = "Круговзор"
L["Eversong Woods"] = "Леса Вечной Песни"
L["Exclude Alterac Valley"] = "Иключить Альтеракскую Долину"
L["Exclude BugSack"] = "Исключить BugSack"
L["Exclude combat resurrection"] = "Исключить воскрешение в бою"
L["Exclusions"] = "Исключения"
L["Expand"] = "Раскрыть"
L["Extras"] = "Дополнения"
L["Eye of Eternity"] = "Око Вечности"
L["False"] = "Ложь"
L["Faster auto loot"] = "Быстрый сбор добычи"
L["Faster movie skip"] = "Пропуск видеороликов"
L["Feathermoon"] = "Лунное Перо"
L["Features"] = "Особенности"
L["Felwood"] = "Оскверненный лес"
L["Feralas"] = "Фералас"
L["Fight for Warsong Gulch"] = "Битва за Ущелье Песни Войны"
L["Fill instead of drain"] = "Заполнить вместо слива"
L["Filter chat messages"] = "Фильтр сообщений чата"
L["Find Item"] = "Найти предмет"
L["Firewing Signets"] = "Перстни Огнекрылов"
L["Five minutes"] = "Пять минут"
L["Fizzle"] = "Шипение"
L["Flame Crest"] = "Пламенеющий Стяг"
L["Flight commenced."] = "Полет начался."
L["Flight details"] = "Детали полета"
L["Focus"] = "Фокус"
L["For all of the social options above, you can treat guild members as friends too."] = "Во всех вышеперечисленных социальных опциях вы можете рассматривать членов гильдий и членов ваших сообществ как друзей."
L["For Great Honor"] = "Ради славы"
L["Forge of Souls"] = "Кузня Душ"
L["Four minutes"] = "Четыре минуты"
L["Frames"] = "Фреймы"
L["Freewind Post"] = "Застава Вольного Ветра"
L["Frostmaul E'ko"] = "Э'ко великанов"
L["Frostsaber E'ko"] = "Э'ко ледопардов"
L["Gadgetzan"] = "Прибамбасск"
L["Game Options"] = "Настройки игры"
L["General"] = "Основное"
L["Ghost"] = "Призрак"
L["Ghostlands"] = "Призрачные земли"
L["Gloomy"] = "Угрюмый"
L["Gnomeregan"] = "Гномреган"
L["Gold Only"] = "Только золото"
L["Graphics and Sound"] = "Графика и звук"
L["Grizzly Hills"] = "Седые холмы"
L["Grom'gol"] = "Лагерь Гром'гол"
L["Groups"] = "Группы"
L["Guild"] = "Гильдия"
L["Gundrak"] = "Гундрак"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "Монеты племен: Гурубаши, Порочная Ветвь и Сухокожие"
L["Gyrocopters"] = "Гирокоптеры"
L["H"] = "H"
L["Halls of Lightning"] = "Чертоги Молний"
L["Halls of Reflection"] = "Залы Отражений"
L["Halls of Stone"] = "Чертоги Камня"
L["Hammerfall"] = "Павший Молот"
L["Haunted"] = "Преследуемый"
L["Have mats?"] = "Есть ингредиенты?"
L["Hellfire Peninsula"] = "Полуостров Адского Пламени"
L["Hellfire Ramparts"] = "Бастионы Адского Пламени"
L["Helm"] = "Шлем"
L["Help"] = "Справка"
L["Help contribute flight times"] = "Помогите внести информацию о времени полета"
L["Hide action button text"] = "Скрыть текст кнопки действия"
L["Hide addon buttons"] = "Скрыть кнопки аддона"
L["Hide alerts"] = "Скрыть оповещения"
L["Hide chat buttons"] = "Скрыть кнопки чата"
L["Hide cooldown duration numbers (if enabled)"] = "Скрыть длительность перезарядки (если включено)"
L["Hide error messages"] = "Скр. сообщ. об ошибках"
L["Hide gryphons"] = "Скрыть грифонов"
L["Hide keybind text"] = "Скрыть текст привязки"
L["Hide macro text"] = "Скрыть название макроса"
L["Hide portrait numbers"] = "Скрыть числа на портрете"
L["Hide stance bar"] = "Скрыть панель стоек"
L["Hide the combat log"] = "Скрыть журнал боя"
L["Hide the health bar"] = "Скрыть полосу здоровья"
L["Hide the tracking button"] = "Скрыть кнопку отслеживания"
L["Hide the world map button"] = "Скрыть кнопку мировой карты"
L["Hide the zone text bar"] = "Скрыть текстовую панель с названием зоны"
L["Hide the zoom buttons"] = "Скрыть кнопки масштабирования"
L["Hide tooltips for world units during combat"] = "Скрыть подсказки для мировых боссов во время боя"
L["Hide zone text"] = "Скрыть название зоны"
L["High"] = "Высокая"
L["Hillsbrad Foothills"] = "Предгорья Хилсбрада"
L["Hinterlands"] = "Внутренние земли"
L["Home"] = "Главная"
L["Hover the pointer over a button."] = "Наведите указатель на кнопку"
L["Howling Fjord"] = "Ревущий Фьорд"
L["Hyjal Summit"] = "Вершина Хиджала"
L["Ice Thistle E'ko"] = "Э'ко йети"
L["Icecrown"] = "Ледяная Корона"
L["Icecrown Citadel"] = "Цитадель Ледяной Короны"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Если флажок установлен, в рюкзаке и банке будет отображаться строка поиска в сумке."
L["If checked, a button will be added to the character frame which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Если флажок установлен, то в окне отображения информации о персонаже будет добавлена кнопка, при наведении указателя мыши на которую, будет показана прочность всей экипировки персонжа.|n|nКроме того, при смерти вашего персонажа, общий процент прочности будет показан сообщением в окне чата."
L["If checked, a cancel form button will be shown on the flight map while you are playing as a shapeshifted druid or shaman."] = "Если флажок установлен, кнопка отмены формы будет показана на карте полетов, пока вы играете в облике друида или шамана."
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant and not queued for a battleground.|n|nFriends who message the keyword using Battle.net will not be sent a group invite if they are appearing offline.  They need to either change their online status or use character whispers."] = "Если флажок установлен, то приглашение в группу будет отправлено любому кто шепнёт вам ключевое (предустановленное) слово, при условии, что вы не находитесь в группе, либо находитесь в группе но являетесь её лидером, либо находитесь в группе рейда и имеете назначенное право помощника рейд-лидера, и при этом не находитесь в очереди на поле боя.|n|nВаши друзья отправившие вам ключевое слово средствами чата Battle.net, не получат приглашения в группу, если они находятся в автономном (скрытом) режиме. Им нужно либо изменить свой сетевой статус, либо воспользоваться внутриигровым чатом, шепнув вам ключевое слово от имени своего персонажа."
L["If checked, a master volume slider will be shown in the character frame."] = "Если флажок установлен, то в окне отображения информации о персонаже будет отображаться регулятор (ползунок) общей громкости."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT-click - Toggle music.|n|nALT-click - Toggle errors (if enabled).|n|nCTRL/SHIFT-click - Toggle windowed mode.|n|nCTRL/ALT-click - Toggle Zygor (if installed)."] = "Если флажок установлен, кнопка на миникарте будет доступна.|n|nКлик - Включить/выключить панель опций.|n|nSHIFT-клик - Включить/выключить музыку.|n|nALT-клик - Включить/выключить сообщения об ошибках (если включено).|n|nCTRL/SHIFT-клик - Переключить в оконный режим.|n|nCTRL/ALT-клик - Переключить Zygor (если установлен)."
L["If checked, a power bar will be shown in the player frame when you are playing a shapeshifted druid."] = "Если флажок установлен, в фрейме персонажа будет отображаться панель силы, когда вы играете друидом в соответствующей форме."
L["If checked, a repair summary will be shown in chat when your gear is automatically repaired."] = "Если флажок установлен, то в чате будет отображаться сводная информация о ремонте вашей экипировки, после того как она будет автоматически отремонтирована."
L["If checked, a timer will be shown under the PvP encounter ready frame so that you know how long you have left to click the enter button."] = "Если флажок установлен, будет отображаться таймер под рамкой готовности к PvP, чтобы вы знали, сколько времени у вас осталось, чтобы нажать кнопку входа."
L["If checked, a train all skills button will be shown in the skill trainer frame allowing you to train all available skills instantly."] = "Если флажок установлен, в рамке тренера умений появится кнопка тренировки всех умений, позволяющая мгновенно тренировать все доступные умения."
L["If checked, a vendor summary will be shown in chat when junk is automatically sold."] = "Если флажок установлен, то в чате будет отображаться сводная информация о мусоре, автоматически проданном вами продавцу."
L["If checked, A'dal in Shattrath City will be muted."] = "Если флажок установлен, А'дал в Шаттрате будет заглушен."
L["If checked, additional font sizes will be available in the chat frame font size menu."] = "Если флажок установлен, то в меню выбора размера шрифта чата будут доступны дополнительные размеры."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "Если флажок установлен, то на аукцион будут добавлены новые функции:|n|nТолько выкуп - создание аукционов выкупа без указания начальной цены.|n|nТолько золото - установите цены на медь и серебро 99, чтобы ускорить продажу новых лотов.|n|nНайти предмет - найдите в аукционе предмет, который вы продаете.|n|nКроме того, настройка длительности лотов будет сохранена для всего аккаунта."
L["If checked, addon buttons will be combined into a single button frame which you can toggle by right-clicking the minimap.|n|nNote that enabling this option will lock out the 'Hide addon buttons' setting."] = "Если флажок установлен, кнопки аддонов будут объединены в одну рамку, отображение которой можно переключать щелчком правой кнопки мыши по миникарте.|n|nОбратите внимание, что включение этой опции заблокирует настройку Скрывать кнопки аддонов."
L["If checked, addon buttons will be hidden while the pointer is not over the minimap."] = "Если флажок установлен, кнопки аддонов будут скрыты, пока указатель мыши не будет находиться над картой."
L["If checked, adjusting the cluster scale will not affect the minimap scale."] = "Если флажок установлен, регулировка масштаба кластера не влияет на масштаб карты."
L["If checked, alert frames will not be shown."] = "Если флажок установлен, то фреймы с предупреждениями не будут отображаться."
L["If checked, alert frames will not be shown.|n|nWhen you earn an achievement, a message will be shown in chat instead."] = "Если флажок установлен, рамки оповещений не будут показаны.|n|nКогда вы получаете достижение, сообщение будет показано в чате."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Если флажок установлен, то все предметы серого качества, находящиеся в ваших сумках, будут автоматически проданы при посещении торговца.|n|nВы можете удерживать клавишу SHIFT во время общения с торговцем для временного игнорирования этой опции."
L["If checked, an animation slider will be shown in the dressing room."] = "Если флажок установлен, в окне примерочной будет показан слайдер анимации."
L["If checked, available quests will be accepted automatically."] = "Если установлен этот флажок, доступные для вас квесты будут приниматься автоматически"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Если флажок установлен, то фон подсказки будет синим (дружественная цель) или красным (враждебная цель)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Если флажок установлен, то запросы дружбы по BattleTag и Real ID будут автоматически отклоняться.|n|nВключение этого параметра автоматически отклонит любые ожидающие запросы."
L["If checked, bike mount sounds will be muted.|n|nThis applies to Mekgineer's Chopper and Mechano-hog."] = "Если флажок установлен, звуки мотоциклов будут заглушены.|n|nЭто относится к Анжинерский чоппер и Механоцикл."
L["If checked, broom mounts will be muted."] = "Если флажок установлен, звуки транспорта метлы будут заглушены."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Если флажок установлен, то кнопки чата будут скрыты.|n|nКлик по вкладке чата автоматически покажет последние сообщения.|n|nИспользуйте колесо мыши для прокрутки истории чата. Удерживайте клавишу SHIFT для перехода на другую страницу чата или CTRL, для перехода к верхней или нижней части истории чата."
L["If checked, chat text will not fade out after a time period."] = "Если флажок установлен, то текст чата не будет исчезать спустя некоторое время."
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "Если флажок установлен, то имена персонажей, в окне персонажа, цели и фокуса, будут выделены цветом их класса."
L["If checked, class colors will be used in the chat frame."] = "Если флажок установлен, то имена персонажей, в окне чата, будут выделены цветом их класса."
L["If checked, class icons will be shown in the portrait frames.|n|nNote that this option may reduce framerate while the target of target window is showing."] = "Если флажок установлен, то в фреймах персонажей, вместо портретов, будут отображаться значки классов.|n|nУчтите, то это может снизить частоту кадров, если вы используете режим отображения цель цели."
L["If checked, clock hourly chimes will be muted."] = "Если флажок установлен, то куранты больше не будут беспокоить вас своим боем каждый час."
L["If checked, completed quests will be turned-in automatically."] = "Если установлен этот флажок, выполненные квесты будут сдаваться автоматически"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Если флажок установлен, то больше не будет предупреждений когда вы разыгрываете (роллите) предмет или пересылаете по почте предмет, который можно передать."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Если флажок установлен, то не будут отображаться цифры длительности перезарядки.|n|nЕсли не установлен, то длительность перезарядки будет показываться в перезарядках, если они включены в настройках игры."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Если флажок установлен, то цифры урона и лечения на фреймах игрока и питомца будут скрыты."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Если флажок установлен, то перетаскивание вкладки Общий чата, когда окно чата заблокировано, развернет окно чата.|n|nЕсли окно чата разблокировано, то перетаскивание вкладки Общий приведет к перемещению окна чата."
L["If checked, drunken messages will be blocked unless they apply to your character.|n|nThis applies to the system channel."] = "Если флажок установлен, пьяные сообщения будут блокироваться, если они не относятся к вашему персонажу.|n|nЭто относится к системному каналу."
L["If checked, duel requests will be blocked unless the player requesting the duel is a friend."] = "Если флажок установлен, то все вызовы на дуэль, кроме брошенных вам от ваших друзей, - будут блокироваться."
L["If checked, duel victory and retreat messages will be blocked unless your character took part in the duel.|n|nThis applies to the system channel."] = "Если флажок установлен, все сообщения о победах и поражениях в дуэлях будут блокироваться, если это не ваш персонаж участвовал в дуэли.|n|nЭто относится к системному каналу."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Если флажок установлен, то звуки эмоций будут заглушаться, пока ваш персонаж отдыхает или находится в Трактире Угрюмый обжора.|n|nВ любое другое время звуки будут включены."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Если флажок установлен, то индикаторы здоровья будут отображены только во время боя и скрыты после его завершения."
L["If checked, flight times will be shown in the flight map and when you take a flight."] = "Если флажок установлен, время полета будет отображаться как на карте полетов, так и во время вашего полёта."
L["If checked, footsteps for mechanical mounts will be muted."] = "Если флажок установлен, шаги механического транспорта будут заглушены."
L["If checked, group invites will only be sent to friends.|n|nIf unchecked, group invites will be sent to everyone."] = "Если флажок установлен, то приглашения в группу будут отправляться только друзьям.|n|nЕсли флажок снят, приглашения в группу будут отправляться всем."
L["If checked, guild ranks will be shown for players in your guild."] = "Если этот флажок установлен, для игроков в вашей гильдии будут отображаться ранги гильдии."
L["If checked, guild ranks will be shown for players who are not in your guild."] = "Если этот флажок установлен, для игроков не являющихся членами вашей гильдии будут отображаться ваши гильдейские ранги."
L["If checked, gyrocopters will be muted.|n|nThis applies to the engineering flying machine mounts."] = "Если флажок установлен, то у гирокоптера будет отключен звук.|n|nЭто затронет всех инженерских летающих маунтов."
L["If checked, helm and cloak toggle checkboxes will be shown in the character frame.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Если флажок установлен, флажки переключения головы и плаща будут отображаться на листе символов.|n|nВы можете удерживать клавишу SHIFT и щелкнуть правой кнопкой мыши по флажкам, чтобы переключить раскладки."
L["If checked, holiday event sounds will be muted.|n|nThis applies to Headless Horseman."] = "Если этот флажок установлен, звуки праздничных событий будут отключены.|n|nЭто относится к Всаднику без головы."
L["If checked, item buttons will be shown in the dressing room.  You can click the item buttons to remove individual items from the model."] = "Если флажок установлен, то в окне примерочной будут отображаться кнопки предметов. Вы можете нажать на кнопки предметов, чтобы удалить отдельные предметы из модели."
L["If checked, keybind text will not be shown on action buttons."] = "Если флажок установлен, текст комбинаций клавиш не будет отображаться на панели команд."
L["If checked, login screen sounds will be muted when you logout of the game.|n|nNote that login screen sounds will not be muted when you initially launch the game.|n|nThey will only be muted when you logout of the game.  This includes manually logging out as well as being forcefully logged out by the game server for reasons such as being away for an extended period of time.|n|nNo more dragons roaring when you fall asleep while the game is running!"] = "Если флажок установлен, звуки экрана входа будут заглушены при выходе из игры.|n|nОбратите внимание, что звуки экрана входа не будут заглушены при первом запуске игры.|n|nОни будут заглушены только при выходе из игры. Это включает в себя как ручной выход из игры, так и принудительный выход из игры сервером по причинам, таким как отсутствие в течение продолжительного времени.|n|nБольше не будет слышно рыкающих драконов, когда вы уснете, оставив игру запущенной!"
L["If checked, macro and keybind text will not be shown on action buttons."] = "Если флажок установлен, то текст макроса и сопоставления (биндинга) клавиш не будет отображаться на кнопках действий."
L["If checked, macro text will not be shown on action buttons."] = "Если флажок установлен, текст макросов не будет отображаться на панели команд."
L["If checked, mechanostriders will be quieter."] = "Если флажок установлен, механодолгоноги будут тише."
L["If checked, members of your guild will be treated as friends for all of the options on this page."] = "Если флажок установлен, члены вашей гильдии будут рассматриваться как друзья для всех опций на этой странице."
L["If checked, messages containing spell links will be blocked while you are in combat.|n|nThis is useful for blocking spell interrupt spam.|n|nThis applies to the say, party, raid, instance and emote channels."] = "Если флажок установлен, сообщения содержащие ссылки на заклинания, будут блокироваться, пока вы находитесь в бою.|n|nЭто полезно для блокирования спама, связанного с прерыванием заклинаний.|n|nЭто относится к каналам: сказать, группа, рейд, подземелье и эмоция."
L["If checked, non-standard minimap buttons will be replaced with standard LibDBIcon buttons.|n|nThis will fix the problems with non-standard buttons such as not hiding automatically, not following the minimap shape and not being placed in the button frame.|n|nNote that enabling or disabling non-standard buttons may require a UI reload to take effect.|n|nMost addons already use the standard LibDBIcon library and will not be affected by this setting but a few addons still use non-standard buttons.|n|nPlease ask addon authors to use the standard LibDBIcon library for their minimap buttons then this setting won't be necessary."] = "Если флажок установлен, нестандартные кнопки миникарты будут заменены на стандартные кнопки библиотеки LibDBIcon.|n|nЭто устранит проблемы с нестандартными кнопками, такие как отсутствие автоматического скрытия, несоблюдение формы миникарты и не размещение в рамке кнопки.|n|nОбратите внимание, что включение или отключение нестандартных кнопок может потребовать перезагрузки пользовательского интерфейса для вступления в силу.|n|nБольшинство аддонов уже используют стандартную библиотеку LibDBIcon и не будут затронуты этой настройкой, но некоторые аддоны все еще используют собственные нестандартные кнопки.|n|nПросьба к авторам аддонов использовать стандартную библиотеку LibDBIcon для своих кнопок миникарты, чтобы эта настройка не понадобилась."
L["If checked, party invitations from friends will be automatically accepted unless you are queued for a battleground."] = "Если флажок установлен, то приглашения в группу от друзей будут приниматься автоматически, если вы не стоите в очереди на поле боя."
L["If checked, party invitations will be blocked unless the player inviting you is a friend."] = "Если флажок установлен, приглашения в группу будут блокироваться, если приглашающий вас игрок не является вашим другом."
L["If checked, quest levels will be shown."] = "Если флажок установлен, то для заданий будет отображаться их уровень."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold requirement will not be turned-in automatically."] = "Если флажок установлен, задания будут автоматически выбираться, приниматься и сдаваться|n|nЗадания требующие от вас отдать некоторое количество золотых монет - не будут сдаваться автоматически!"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Если флажок установлен, то чаты рейдов и подземелий будут окрашены в синий цвет (чтобы они сочетались по цвету)."
L["If checked, resurrection requests will be accepted automatically."] = "Если флажок установлен, запросы на воскрешение будут приниматься автоматически."
L["If checked, resurrection requests will not be automatically accepted if the player resurrecting you is in combat."] = "Если флажок установлен, запросы на воскрешение не будут автоматически приниматься, если воскрешающий вас игрок находится в бою."
L["If checked, Screech will be muted.|n|nThis is a spell used by some flying pets."] = "Если флажок установлен, крик будет приглушен.|n|nЭто заклинание используют некоторые летающие питомцы."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Если флажок установлен, то во всплывающих подсказках на фрейме с бафами, а также на целях персонажа будут отображаться ID заклинаний."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Если флажок установлен, то липкий чат будет отключен.|n|nПримечание: эта настройка не будет работать для временных чатов."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Если флажок установлен и вы не находитесь в бою, то запрос на ваш призыв будет принят автоматически."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Если флажок установлен, то список модификаций (доступный из меню игры) будет отображать по умолчанию список модификации для этого персонажа."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Если флажок установлен, то время необходимое для поднятие добычи значительно сократится."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Если флажок установлен, то кнопка сортировки вещей в сумках и в банке не будет отображаться."
L["If checked, the BugSack addon minimap button will always be visible if you have BugSack installed and the minimap button enabled."] = "Если флажок установлен, кнопка миникарты аддона BugSack будет видна всегда, если у вас установлен этот аддон и включено отображение его кнопки миникарты."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Если флажок установлен, то кнопка для переключения контейнера рейда будет отображена над его окном управления (c левой стороны), а не на самом окне управления.|n|nЭто позволит переключать рамку контейнера рейда без необходимости открывать окно его управления."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Если флажок установлен, то закладка Журнал боя в окне чата будет скрыта.|n|nЧтобы эта настройка сработала, закладка Журнал боя должна находиться в окне чата.|n|n Если закладка откреплена, Вы можете закрепить её перетащив на вкладку чата (после этого необходимо перезагрузить UI) или сбросить настройки окна чата (из соответствующего меню)."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Если флажок установлен, то поле ввода текста будет перемещено в верхнюю часть окна чата. По умолчанию, оно находится в нижней части."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Если флажок установлен, то серый экран смерти и другие эффекты будут отключены."
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "Если этот флажок установлен, звук кнопки интерфейса, звук щелчка по вкладке окна чата и звук переключения игрового меню будет отключен."
L["If checked, the main bar gryphons will not be shown."] = "Если флажок установлен, то панель с грифонами не будет отображаться."
L["If checked, the minimap shape will be square."] = "Если флажок установлен, форма окна миникарты будет квадратной."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Если флажок установлен, количество свободных мест в сумке будет отображаться в значке кнопки рюкзака и во всплывающей подсказке."
L["If checked, the player frame background will be shown in class color."] = "Если флажок установлен, фон окна игрока будет отображаться в цвете класса."
L["If checked, the professions frame will be larger."] = "Если флажок установлен, то окно профессий будет больше."
L["If checked, the quest log frame will be taller."] = "Если флажок установлен, рамка журнала заданий будет выше."
L["If checked, the ready check sound will be muted."] = "Если флажок установлен, то будет отключен звук проверки готовности."
L["If checked, the scale slider will apply to the entire minimap cluster.|n|nNote that if you are using the default action bars, rescaling the cluster will also rescale the right action bars at startup so you may want to leave the scale slider at 100%.|n|nIf unchecked, the scale slider will only apply to the minimap."] = "Если флажок установлен, ползунок масштаба будет применяться ко всему кластеру (зоне) мини-карты.n|nОбратите внимание, что если вы используете стандартные панели действий, изменение масштаба кластера также изменит масштаб правых панелей действий при запуске, поэтому вы можете пожелать оставить ползунок масштаба на уровне 100%.|n|nЕсли флажок не установлен, изменение масштаба этим ползунком будет применяться только к мини-карте."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Если флажок установлен, то свечение экрана будет отключено.|n|nВключение этой опции также отключит эффект пьяной дымки."
L["If checked, the skill trainer frame will be larger and feature a train all skills button."] = "Если флажок установлен, рамка тренера навыков будет больше и будет иметь кнопку обучения всем навыкам."
L["If checked, the spell fizzle sounds will be muted."] = "Если этот флажок установлен, шипящие звуки заклинаний будут отключены."
L["If checked, the stance bar will not be shown."] = "Если флажок установлен, то панель стоек не будет отображаться."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Если флажок установлен, то окно разговоров не будет показываться.|n|nОкно разговоров появляется обычно в нижней части экрана, в процессе общения с некоторыми НПС."
L["If checked, the target frame background and focus frame background will be shown in class color."] = "Если флажок установлен, фон рамок цели и фокуса будет отображаться по цвету класса."
L["If checked, the target frame background will be shown in class color."] = "Если флажок установлен, фон окна цели будет отображаться в цвете класса цели."
L["If checked, the toggle headers button will be shown."] = "Если флажок установлен, будет отображаться кнопка переключения заголовков."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Если флажок установлен, то всплывающие подсказки будут выделяться цветом, и у Вас появится возможность менять их расположение и размер."
L["If checked, the tracking button will be hidden while the pointer is not over the minimap."] = "Если флажок установлен, кнопка отслеживания будет скрыта, пока указатель мыши не находится на мини-карте."
L["If checked, the vendor price will be shown in item tooltips."] = "Если флажок установлен, то во всплывающих подсказках предметов будет отображаться цена у продавца."
L["If checked, the world map button will be hidden."] = "Если флажок установлен, кнопка карты мира будет скрыта."
L["If checked, the zone text bar will be hidden."] = "Если флажок установлен, текстовая панель с названием зоны будет скрыта."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Если флажок установлен, то кнопки увеличения и уменьшения масштаба у миникарты будут скрыты. Независимо от этой настройки, вы сможете использовать колесо мыши для изменения масштаба."
L["If checked, tooltips for world units will be hidden during combat."] = "Если флажок установлен, всплывающие подсказки для мировых юнитов будут скрыты во время боя."
L["If checked, train sounds will be muted."] = "Если этот флажок установлен, звуки поезда будут отключены."
L["If checked, traveling merchant greetings and farewells will be muted.|n|nThis applies to Traveler's Tundra Mammoth."] = "Если флажок установлен, приветствия и прощания странствующего торговца будут отключены.|n|nЭто относится к тундровому мамонту путешественника."
L["If checked, unit targets will be shown."] = "Если флажок установлен, то будет отображаться цель цели."
L["If checked, Wowhead links will go directly to the comments section."] = "Если флажок установлен, ссылки на Wowhead будут вести непосредственно в раздел комментариев."
L["If checked, yawns from hunter pet cats will be muted."] = "Если флажок установлен, то домашние кошки охотников будут зевать молча."
L["If checked, you can block spell links, drunken spam and duel spam."] = "Если флажок установлен, вы можете блокировать ссылки на заклинания, пьяный спам и спам от дуэлей."
L["If checked, you can hold alt and drag the minimap to move it."] = "Если флажок установлен, вы сможете перемещать карту удерживая одновременно кнопку Alt и кнопку мыши (перетаскивание)."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Если флажок установлен, то удерживая нажатой клавишу CTRL и щелкнув по закладке чата, вы сможете просмотреть последние записи чата в отдельном окне, из которого сможете легко скопировать текст."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Если флажок установлен, то Вы сможете нажимать кнопки со стрелками для перемещения курсора влево и вправо, в строке ввода текста, в окне чата.|n|nЕсли флажок снят, то клавиши со стрелками будут использовать настройки назначения клавиш по умолчанию."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Если флажок установлен, то вы сможете пропускать ролики без подтверждения."
L["If checked, you will be able to change the font size of book text."] = "Если флажок установлен, вы сможете изменять размер шрифта текста в книгах."
L["If checked, you will be able to change the font size of quest text."] = "Если флажок установлен, вы сможете изменять размер шрифта текста квестов."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Если флажок установлен, вы сможете изменить размер шрифта текста в почтовых сообщениях (письмах).|n|nЭта настройка не будет иметь силы для писем созданных по шаблону (к примеру писем с аукциона)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Если этот флажок установлен, у вас будет возможность изменять расположение и размеры фрейма баффов"
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "Если флажок установлен, то вы сможете управлять положением и масштабом виджетов.|n|nВиджеты обычно используются для отображения результатов PvP и отслеживания целей."
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Если флажок установлен, вы сможете создать зону видимости. Создание такой зоны - добавляет сверху и снизу основного экрана игры черные полосы.|n|nНа этих полосах вы сможете разместить элементы интерфейса, тем самым не перекрывая обзор основного экрана игры."
L["If checked, you will be able to customise the minimap."] = "Если флажок установлен, вы сможете настроить миникарту."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Если флажок установлен, то вы сможете переместить фрейм чата к краю экрана."
L["If checked, you will be able to mute a selection of game sounds."] = "Если этот флажок установлен, вы сможете отключить некоторые звуки игры."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Если флажок установлен, вы сможете разместить над фреймом цели дополнительно до пяти пиктограмм отображающих таймеры восстановления."
L["If checked, you will be able to reposition the tooltip."] = "Если флажок установлен, вы сможете изменить положение всплывающей подсказки."
L["If checked, you will be able to set some additional rules for when your character is automatically dismounted."] = "Если флажок установлен, вы сможете установить дополнительные условия, при которых ваш персонаж должен будет автоматически спешиваться."
L["If checked, you will be able to set the density of weather effects."] = "Если флажок установлен, вы сможете установить плотность погодных эффектов."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Если флажок установлен, то вы сможете изменить контур рамки своего персонажа с обычного на редкий, элитный или редко-элитный."
L["If checked, you will be able to zoom out to a greater distance."] = "Если флажок установлен, вы сможете максимально далеко отдалять камеру.|nПримечание: Это может приводить к неожиданным результатам, так как мир классического WoW не был на это рассчитан."
L["If checked, you will be dismounted when you attempt to cast a non-instant cast spell while moving."] = "Если флажок установлен, вы будете автоматически спешиваться в случае если вы попытаетесь произнести не моментальное заклинание в движении."
L["If checked, you will be dismounted when you attempt to cast a spell but don't have the rage, mana or energy to cast it."] = "Если флажок установлен, вы будете автоматически спешиваться в случае если вы попытаетесь произнести заклинание, но у вас будет не достаточно для этого ярости, маны или энергии."
L["If checked, you will be dismounted when you click a flight destination."] = "Если флажок установлен, вы будете автоматически спешиваться в случае если вы выберете конечную точку вашего перелёта на карте полётов."
L["If checked, you will be dismounted when you instruct a flight master to open the flight map."] = "Если флажок установлен, вы будете автоматически спешиваться в случае если вы попросите мастера полётов открыть карту полётов."
L["If checked, you will be prompted to submit missing flight times."] = "Если флажок установлен, вам будет предложено указать пропущенное время полета."
L["If checked, you will need to hold the override key down for quests to be automated.|n|nIf unchecked, holding the override key will prevent quests from being automated."] = "Если флажок установлен, то для автоматизации сдачи и/или принятия квестов вам нужно будет удерживать клавишу замены.|n|nЕсли флажок снят, удерживание клавиши замены запретит автоматизацию квестов."
L["If checked, you will no longer need to type delete when destroying a superior quality item.|n|nIn addition, item links will be shown in all item destroy confirmation windows."] = "Если флажок установлен, то вам больше не потребуется вводить слово УДАЛИТЬ в отдельных всплывающих окнах подтверждения уничтожения предметов высшего качества.|n|nКроме того, во всех таких окнах подтверждения удаления - будут отображаться ссылки на эти предметы."
L["If checked, you will not release automatically in Alterac Valley."] = "Если флажок установлен, на поле боя Альтеракская Долина - вы никогда не будете воскрешены автоматически."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Если флажок установлен, то вы будете автоматически покидать тело после смерти на поле битвы.|n|nОднако, вы не возродитесь автоматически, если у вас есть возможность самовоскрешения (камень души, реинкарнация и т. д.)."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Если флажок установлен, история чата увеличится до 4096 строк. Если флажок снят, будут использовать настройки по умолчанию (128 строк).|n|nВключение этой настройки может помешать отображению некоторого текста во время входа в игру."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Если флажок установлен, то ваше снаряжение будет починено автоматически, когда вы поговорите с подходящим торговцем.|n|nВы можете удерживать клавишу SHIFT, перед разговором, чтобы временно игнорировать эту настройку."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Если флажок установлен, то текст названия зоны не будет отображаться (например Стальгорн)."
L["If you use the 'Hide addon buttons' or 'Combine addon buttons' settings but you want some addon buttons to remain visible around the minimap, enter the addon names into the editbox separated by a comma.|n|nThe editbox tooltip shows the addon names that you can enter.  The names must match exactly with the names shown in the editbox tooltip though case does not matter.|n|nChanges to the list will require a UI reload to take effect."] = "Если вы используете настройку Скрыть кнопки аддонов или Объединить кнопки аддонов, но вы хотите, чтобы некоторые кнопки аддонов остались видимыми вокруг миникарты, введите название аддонов в поле редактирования, разделенные запятой.|n|nВо всплывающей подсказке окна редактирования отображаются имена аддонов, которые вы можете ввести. Названия должны точно совпадать с названиями, показанными во всплывающей подсказке окна редактирования, регистр значения не имеет.|n|nИзменение в списке потребует перезагрузки UI."
L["Incompatible"] = "Несовместимо"
L["Increase chat history"] = "Увеличить историю чата"
L["Interface"] = "Интерфейс"
L["Invaders of Alterac Valley"] = "Вторжение в Альтеракскую долину"
L["Invalid console variable."] = "Недопустимая консольная переменная."
L["Invalid parameter."] = "Неверный параметр."
L["Invalid quest ID."] = "Неверный id квеста"
L["Invalid sound ID"] = "Неверный id звука"
L["Invalid taint level."] = "Неверный уровень taint."
L["Invalid target."] = "Неверная цель."
L["Invite from whispers"] = "Приглашать по шепоту"
L["Ironforge"] = "Стальгорн"
L["Item"] = "Предмет"
L["Item ID"] = "ID предмета"
L["Item IDs can be found in item toolips."] = "ID предмета может быть найдено в всплывающей подсказке."
L["Kalimdor"] = "Калимдор"
L["Karazhan"] = "Каражан"
L["Kargath"] = "Каргат"
L["Keep"] = "Хранить"
L["Keyword"] = "Ключевое слово"
L["Lakeshire"] = "Приозерье"
L["Leatrix Plus"] = "Leatrix Plus"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus не будет перезаписывать LeaPlusDB при следующем выходе из системы."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: УСТАНОВЛЕНА НЕПРАВИЛЬНАЯ ВЕРСИЯ!"
L["Left"] = "Левая"
L["Lifetime honorable kills"] = "Всего почетных побед"
L["Light's Hope Chapel"] = "Часовня Последней Надежды"
L["Link will search Wowhead"] = "Ссылка для поиска на Wowhead"
L["Links go directly to the comments section"] = "Ссылки в раздел комментариев"
L["Loch Modan"] = "Лок Модан"
L["Lockout sharing"] = "Совместная блокировка"
L["Low"] = "Низкий"
L["M"] = "M"
L["Magic"] = "Магия"
L["Magisters' Terrace"] = "Терраса Магистров"
L["Main Titles"] = "Главные названия"
L["Manage buffs"] = "Управление баффами"
L["Manage durability"] = "Управление прочностью"
L["Manage focus"] = "Управление фокусом"
L["Manage frames"] = "Управление рамками"
L["Manage timer"] = "Управление таймером"
L["Manage widget"] = "Управление виджетами"
L["Managed by Leatrix Plus"] = "Настройки Leatrix Plus"
L["Map"] = "Карта"
L["Maraudon"] = "Мародон"
L["Marks of Kil'jaeden"] = "Знаки Кил'джедена"
L["Marks of Sargeras"] = "Знаки Саргераса"
L["Marshal's Refuge"] = "Укрытие Маршалла"
L["Max camera zoom"] = "Max отдаление камеры"
L["Mechanics"] = "Механики"
L["Mechsteps"] = "Мехошаги"
L["Mechstriders"] = "Механодолгоноги"
L["Media"] = "Медиа"
L["Medium"] = "Средняя"
L["Memory Usage"] = "Использовано памяти"
L["Menethil Harbor"] = "Гавань Менетилов"
L["message"] = "сообщение"
L["message from previous session"] = "сообщение с предыдущей сессии"
L["message shown."] = "сообщение показано."
L["Messages"] = "Сообщения"
L["messages from previous session"] = "сообщения с предыдущей сессии"
L["messages shown."] = "сообщения показаны."
L["Misc"] = "Разное"
L["Missing console variable."] = "Отсутствует переменная консоли."
L["Missing mount name."] = "Отсутствует имя маунта."
L["Missing movie ID."] = "Отсутствует ID видео-ролика."
L["Missing quest ID."] = "Отсутствует идентификатор квеста."
L["Missing sound file parameter."] = "Отсутствует параметр звукового файла."
L["Missing sound ID."] = "ID ролика не найден."
L["Molten Core"] = "Огненные Недра"
L["Moonglade"] = "Лунная поляна"
L["More Firewing Signets"] = "Больше перстней Огнекрылов"
L["More font sizes"] = "Доп.размеры шрифта"
L["More Marks of Kil'jaeden"] = "Больше знаков Кил'джедена"
L["More Marks of Sargeras"] = "Больше знаков Саргераса"
L["More Sunfury Signets"] = "Больше перстней Ярости Солнца"
L["Morgan's Vigil"] = "Дозор Моргана"
L["Mount not found."] = "Маунт не найден."
L["Mounts"] = "Маунты"
L["Move editbox to top"] = "Поле ввода над чатом"
L["Movie not playable."] = "Видео-ролик не может быть воспроизведён."
L["Movie number"] = "Номер видео-ролика"
L["Movies"] = "Видео-ролики"
L["Mulgore"] = "Мулгор"
L["Music"] = "Музыка"
L["Musical Moments"] = "Музыкальные Моменты"
L["Mute game sounds"] = "Отключить звуки игры"
L["Mystery"] = "Тайна"
L["N"] = "N"
L["Nagrand"] = "Награнд"
L["Narration"] = "Повествование"
L["Naxxramas"] = "Наксрамас"
L["Netherdrakes"] = "Драконы Пустоты"
L["Nethergarde Keep"] = "Крепость Стражей Пустоты"
L["Netherstorm"] = "Пустоверть"
L["Nexus"] = "Нексус"
L["Nijel's Point"] = "Высота Найджела"
L["Nine minutes"] = "Девять минут"
L["No bad sound IDs found."] = "Не найдено неверных звуковых id."
L["No help is available for this page."] = "Справка недоступна для этой страницы."
L["No items with durability equipped."] = "Нет экипированных предметов с прочностью."
L["No media duplicates found."] = "Дубликаты медиа не найдены."
L["No supported addons."] = "Нет поддерживаемых аддонов."
L["No tooltip showing."] = "Подсказки не показываются."
L["None"] = "Нет"
L["Not completed."] = "Не завершено."
L["Not minimap"] = "Не миникарта"
L["Note that this will not reset settings that require a UI reload."] = "Обратите внимание, что при этом не сбрасываются настройки, требующие перезагрузки пользовательского интерфейса."
L["Note that this will not reset your exclusions list."] = "Обратите внимание, что это не приведет к сбросу вашего списка исключений."
L["Nothing to see here."] = "Здесь нечего смотреть."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "ВНИМАНИЕ!|nВы должны полностью перезапустить свой игровой клиент, прежде чем использовать эту версию Leatrix Plus."
L["NPC"] = "NPC"
L["Nude"] = "Снять"
L["Obsidian Sanctum"] = "Обсидиановое святилище"
L["Oculus"] = "Окулус"
L["Okay, disable screen adjust for me"] = "Хорошо, отключи для меня настройку экрана"
L["Old Hillsbrad Foothills"] = "Старые предгорья Хилсбрада"
L["One minute"] = "Одна минута"
L["Onyxia's Lair"] = "Логово Ониксии"
L["or click the minimap button to open Leatrix Plus."] = "или нажмите на кнопку у миникарты, чтобы открыть Leatrix Plus."
L["Orgrimmar"] = "Оргриммар"
L["Outland"] = "Запределье"
L["Overall"] = "Всего"
L["Overlay"] = "Оверлей"
L["Override key"] = "Кнопка замены"
L["Particle density"] = "Плотность частиц"
L["Party from friends"] = "Приглашения от друзей"
L["Pet"] = "Питомец"
L["Pets"] = "Питомцы"
L["Pit of Saron"] = "Яма Сарона"
L["Player"] = "Персонаж"
L["Please ask the addon author to use LibDBIcon."] = "Обратитесь к разработчику аддона, чтобы он начал использовать библиотеку LibDBIcon."
L["Power"] = "Мощность"
L["Press CTRL/C to copy."] = "Нажмите CTRL C, чтобы скопировать."
L["Queue from friends"] = "Очереди от друзей"
L["R"] = "Р"
L["Ragefire Chasm"] = "Огненная Пропасть"
L["Raid"] = "Рейд"
L["Raid frame toggle"] = "Вкл выкл рейдовые рамки"
L["Random"] = "Случайно"
L["RARE"] = "Редкий"
L["RARE ELITE"] = "Редкий элитный"
L["Ratchet"] = "Кабестан"
L["Razorfen Downs"] = "Курганы Иглошкурых"
L["Razorfen Kraul"] = "Лабиринты Иглошкурых"
L["Ready"] = "Готовность"
L["Recent chat window"] = "Окно недавнего чата"
L["Redridge Mountains"] = "Красногорье"
L["Refuge Pointe"] = "Опорный пункт"
L["Release in PvP"] = "Покидание тела в PvP"
L["Reload"] = "Перезагрузить"
L["Remember Alterac Valley!"] = "Помни Альтеракскую долину!"
L["Remove all items"] = "Убрать все предметы"
L["Remove tabard"] = "Убрать накидку"
L["Repair automatically"] = "Ремонт снаряжения"
L["Repair using guild funds if available"] = "Ремонт за счет средств гильдии, если возможно"
L["Repaired for"] = "Стоимость ремонта"
L["Replace non-standard buttons"] = "Замена нестандартный кнопок"
L["Reposition the tooltip"] = "Переместите подсказку"
L["Require override key for quest automation"] = "Требуется кнопка замены для автоматизации квестов"
L["Requires UI reload."] = "Требуется перезагрузка интерфейса (UI)."
L["Reset"] = "Сброс настроек"
L["Resize book text"] = "Изменить размер книги"
L["Resize mail text"] = "Размер текста писем"
L["Resize quest text"] = "Размер текста заданий"
L["Resize Screen"] = "Изменить размер экрана"
L["Rested bubbles"] = "Бонус отдыха"
L["Restore chat messages"] = "Восстановление сообщений в чате"
L["Restored"] = "Восстановлено"
L["Restrict to friends"] = "Ограничение для друзей"
L["result"] = "Результат"
L["results"] = "Результаты"
L["Return"] = "Назад"
L["Revantusk Village"] = "Деревня Сломанного Клыка"
L["Right"] = "Правая"
L["Right-click to close"] = "Щелчок ПКМ, чтобы закрыть"
L["Right-click to close."] = "Щелчок ПКМ, чтобы закрыть."
L["right-click to go back"] = "Щелчок ПКМ, чтобы вернуться"
L["Ripper"] = "Потрошитель"
L["Ruby Sanctum"] = "Рубиновое святилище"
L["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража"
L["Rut'theran Village"] = "Деревня Рут'теран"
L["Sacred"] = "Священный"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "Монеты племен: Песчаная Буря, Дробители Черепов и Кровавый Скальп"
L["Scale"] = "Масштаб"
L["Scale entire cluster"] = "Масштаб всего кластера"
L["Scarlet Monastery"] = "Монастырь Алого ордена"
L["Scholomance"] = "Некроситет"
L["Screech"] = "Крик"
L["Search"] = "Поиск"
L["Search mats?"] = "Искать ингредиенты?"
L["Searing Gorge"] = "Тлеющее ущелье"
L["seconds"] = "секунд"
L["seconds does not match the saved flight time of"] = "секунд не соответствует сохраненному времени полета"
L["Select the settings that you want to use."] = "Выберите параметры, которые вы хотите использовать."
L["Selection of music tracks"] = "Подборка музыкальных треков"
L["Self Markers Allowed"] = "Разрешены самомаркировки"
L["Self Markers Blocked"] = "Самомаркировки запрещены"
L["Sell"] = "Продавать"
L["Sell junk automatically"] = "Продажа хлама из сумок"
L["SELLING JUNK"] = "Продаю хлам"
L["Sentinel Hill"] = "Сторожевой холм"
L["Set weather density"] = "Плотность погодных эффектов"
L["Settings"] = "Параметры"
L["Seven minutes"] = "Семь минут"
L["Shaders"] = "Тени"
L["Shadowfang Keep"] = "Крепость Темного Клыка"
L["Shadowmoon Valley"] = "Долина Призрачной Луны"
L["Shadowprey Village"] = "Деревня Ночных Охотников"
L["Shardtooth E'ko"] = "Э'ко щербозубов"
L["SHIFT"] = "SHIFT"
L["Sholazar Basin"] = "Низина Шолазар"
L["Show animation slider"] = "Показать ползунок анимации"
L["Show auction controls"] = "Отображать элементы управления аукционом"
L["Show background"] = "Показать фон"
L["Show bag search box"] = "Показать строку поиска в сумки"
L["Show cancel form button on flight map"] = "Показать кнопку отмены формы на карте полета"
L["Show character addons"] = "Показывать модификации персонажа"
L["Show cooldowns"] = "Показать кулдауны"
L["Show cooldowns above the player frame"] = "Показывать кулдауны над рамкой игрока."
L["Show destination"] = "Показать пункт назначения"
L["Show druid power bar"] = "Отображать панель силы друида"
L["Show durability status"] = "Прочность экипировки"
L["Show flight times"] = "Показывать время перелёта"
L["Show free bag slots"] = "Показать свободные слоты для сумок"
L["Show guild names"] = "Показать названия гильдий"
L["Show guild ranks for other guilds"] = "Показывать ранги гильдии для других гильдий."
L["Show guild ranks for your guild"] = "Показать звания гильдии для вашей гильдии"
L["Show item buttons"] = "Показать кнопки предметов"
L["Show me"] = "Показать мне"
L["Show minimap button"] = "Кнопка у миникарты"
L["Show player chain"] = "Контур рамки персонажа"
L["Show player frame in class color"] = "Показать окно персонажа в цвете класса"
L["Show quest difficulty in quest log list"] = "Отображать сложность в списке заданий"
L["Show quest levels"] = "Показывать уровень заданий"
L["Show raid button"] = "Показать кнопку рейда"
L["Show ready timer"] = "Показать таймер готовности"
L["Show repair summary in chat"] = "Информация о ремонте в чат"
L["Show target frame and focus frame in class color"] = "Показывать фреймы цели и фокуса в цвете класса"
L["Show target model"] = "Показать модель цели"
L["Show the spell ID in buff icon tooltips"] = "Отображать ID заклинаний в подсказках"
L["Show toggle headers button"] = "Показать кнопку переключения заголовков"
L["Show tooltips with shift key"] = "Показывать всплывающие подсказки с помощью клавиши Shift"
L["Show train all skills button"] = "Показать кнопку изучить все навыки"
L["Show unit targets"] = "Показывать цели врагов"
L["Show vanity controls"] = "Показать настройки тщеславия"
L["Show vendor price"] = "Показывать цену у торговца"
L["Show vendor summary in chat"] = "Информация о продаже в чат"
L["Show volume slider"] = "Регулятор громкости"
L["Show web link"] = "Показать веб-ссылку"
L["Show who pinged"] = "Показать кто щелкает по миникарте"
L["Show Wowhead links"] = "Ссылки на Wowhead"
L["Silence rested emotes"] = "Заглушать звуки эмоций"
L["Silithus"] = "Силитус"
L["Silverpine Forest"] = "Серебряный бор"
L["Single Mark of Sargeras"] = "Знак Саргераса"
L["Single Sunfury Signet"] = "Перстень Ярости Солнца"
L["Six minutes"] = "Шесть минут"
L["Social"] = "Общение"
L["Sold junk for"] = "Продать мусор за"
L["Sound system restarted."] = "Звуковая система перезапустилась."
L["Southshore"] = "Южнобережье"
L["Speak the remaining time"] = "Говорить оставшееся время"
L["Spell"] = "Заклинание"
L["Spell ID"] = "ID заклинания"
L["Splintertree Post"] = "Застава Расщепленного Дерева"
L["Spooky"] = "Ужасный"
L["Square minimap"] = "Квадратная миникарта"
L["Square size"] = "Размер квадрата"
L["Stockade"] = "Тюрьма"
L["Stonard"] = "Каменор"
L["Stonetalon Mountains"] = "Когтистые горы"
L["Stonetalon Peak"] = "Пик Каменного Когтя"
L["Stop"] = "Стоп"
L["Storm Peaks"] = "Грозовая гряда"
L["Stormwind"] = "Штормград"
L["Stranglethorn Vale"] = "Тернистая долина"
L["Stratholme"] = "Стратхольм"
L["Sun Rock Retreat"] = "Приют у Солнечного Камня"
L["Sunfury Signets"] = "Перстни Ярости Солнца"
L["Sunken Temple"] = "Затонувший храм"
L["Sunwell Plateau"] = "Плато Солнечного Колодца"
L["Support"] = "Поддержка"
L["Supported Addons"] = "Поддерживаемые аддоны"
L["Swamp"] = "Болотный"
L["Swamp of Sorrows"] = "Болото печали"
L["System"] = "Система"
L["T"] = "T"
L["Tabard"] = "Накидка"
L["Taint level: Basic (1)."] = "Уровень заражения: Базовый (1)."
L["Taint level: Disabled (0)."] = "Уровень заражения: Отключен (0)."
L["Taint level: Full (2)."] = "Уровень заражения: Полный (2)."
L["Taller quest log frame"] = "Более высокий фрейм заданий"
L["Talonbranch Glade"] = "Поляна Когтистых Ветвей"
L["Talrendis Point"] = "Застава Талрендис"
L["Tanaris"] = "Танарис"
L["Target"] = "Цель"
L["Target Tracking Disabled"] = "Отслеживание цели отключено"
L["Target Tracking Enabled"] = "Отслеживание цели включено"
L["Tarren Mill"] = "Мельница Таррен"
L["Teldrassil"] = "Тельдрассил"
L["Tempest Keep"] = "Крепость Бурь"
L["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж"
L["Temple of Atal'Hakkar"] = "Храм Атал'Хаккара"
L["Ten minutes"] = "Десять минут"
L["Ten seconds"] = "Десять секунд"
L["Ten Years of Warcraft"] = "Десять лет варкрафта"
L["Terokkar Forest"] = "Лес Тероккар"
L["Text"] = "Текст"
L["Text size"] = "Размер текста"
L["Text Size"] = "Размер текста"
L["Thalanaar"] = "Таланаар"
L["The Burning Crusade"] = "The Burning Crusade"
L["The game will dismount you if you successfully cast a spell without addons.  These settings let you set some additional dismount rules."] = "Игра и без дополнительных аддонов спешивает вашего персонажа в том случае, если вы успешно произнесете заклинание. Эти настройки позволяют вам установить некоторые дополнительные правила спешивания."
L["The Sepulcher"] = "Гробница"
L["The square minimap will always show the new covenant button."] = "Прямоугольная миникарта будет всегда показывать новую кнопку ковенантов."
L["The summon from"] = "Призыв для"
L["Thelsamar"] = "Телcамар"
L["Themes"] = "Темы"
L["Theramore"] = "Терамор"
L["There is a helpful guide on leatrix.com."] = "На сайте leatrix.com есть полезное руководство."
L["These items will not be sold."] = "Эти предметы не будут проданы."
L["Thirty seconds"] = "Тридцать секунд"
L["This flight does not exist in the database."] = "Этот маршрут не существует в базе данных."
L["This flight does not have a saved duration in the database."] = "У этого маршрута еще нет сохраненной информации о продолжительности в базе данных."
L["This flight's actual time of"] = "Фактическое время полета"
L["This is a custom button."] = "Это настраиваемая кнопка."
L["This panel will close automatically if you enter combat."] = "Это окно будет автоматически закрыто, если Вы вступите в бой."
L["This slider requires 'Square minimap' to be enabled."] = "Этот переключатель требует включенного режима квадратной миникарты"
L["Thorium Point"] = "Лагерь Братства Тория"
L["Thousand Needles"] = "Тысяча Игл"
L["Three minutes"] = "Три минуты"
L["Thunder Bluff"] = "Громовой Утес"
L["Timer"] = "Таймер"
L["Tirisfal Glades"] = "Тирисфальские леса"
L["Titan Panel screen adjust needs to be disabled for the frame to be saved correctly."] = "Чтобы настройки фрэйма были правильно сохранены, нужно отключить настройку экрана от аддона Титан Панель."
L["to"] = "до"
L["To begin, choose an options page."] = "Чтобы начать, выберите страницу настроек."
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "Чтобы скрыть журнал боя, вам нужно отключить модуль чата в ElvUI."
L["To move the minimap, hold down the alt key and drag it."] = "Чтобы переместить миникарту, перемещайте её при помощи мыши и одновременно удерживая клавишу Alt."
L["To move the minimap, hold down the alt key and drag it.|n|nIf you toggle an addon minimap button, you may need to reload your UI for the change to take effect.  This only affects a few addons that use custom buttons.|n|nThis panel will close automatically if you enter combat."] = "Чтобы переместить миникарту, переместите её мышью, удерживайте нажатой клавишу alt.|n|nЕсли вы переключите кнопку аддона на миникарте, вам может потребоваться перезагрузить пользовательский интерфейс, чтобы изменения вступили в силу. Это касается только некоторых аддонов, использующих кнопки собственной разработки, а не из системной библиотеки.|n|nЭта панель автоматически закроется, если вы вступите в бой."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Чтобы использовать кнопку «Найти предмет», вам нужно отменить выбор категории токена."
L["Toggle buttons"] = "Переключение кнопок"
L["Toggle character stats"] = "Переключить характеристики персонажа"
L["Toggle Grid"] = "Переключить сетку"
L["Toggle panel"] = "Переключить панель"
L["took"] = "взять"
L["Tooltip"] = "Подсказка"
L["Tooltip title color"] = "Цвет заголовка подсказки"
L["Top"] = "Верхняя"
L["Top Center"] = "Верхний центральный"
L["Tracing started."] = "Отслеживание началось."
L["Tracing stopped."] = "Слежение остановилась."
L["Trains"] = "Поезда"
L["Transparency"] = "Прозрачность"
L["Travelers"] = "Путешественники"
L["True"] = "Правда"
L["Turn-in completed quests automatically"] = "Сдавать выполненные квесты автоматически"
L["Twenty seconds"] = "Двадцать секунд"
L["Two minutes"] = "Две минуты"
L["Uldaman"] = "Ульдаман"
L["Ulduar"] = "Ульдуар"
L["Unclamp chat frame"] = "Открепить окно чата"
L["Undercity"] = "Подгород"
L["Un'Goro Crater"] = "Кратер Ун'Горо"
L["Universal group color"] = "Единый цвет текста групп"
L["Unlock the minimap"] = "Разблокировать миникарту"
L["Use arrow keys in chat"] = "Клавиши курсора в чате"
L["Use class colors in chat"] = "Имена в цвете класса"
L["Use easy resizing"] = "Лёгкое изменение размера"
L["Utgarde Keep"] = "Крепость Утгард"
L["Utgarde Pinnacle"] = "Вершина Утгард"
L["Valormok"] = "Храбростан"
L["Value must be a number."] = "Значение должно быть числом."
L["Various"] = "Разное"
L["Vault of Archavon"] = "Хранилище Аркавона"
L["Vaults"] = "Хранилища"
L["Vendors"] = "Торговцы"
L["Version"] = "Версия"
L["Very Low"] = "Очень низко"
L["Video"] = "Видео"
L["Visibility"] = "Видимость"
L["Wailing Caverns"] = "Пещеры Стенаний"
L["Warning"] = "Предупреждение"
L["was automatically declined."] = "был автоматически отклонён."
L["Weather density"] = "Плотность погодных эффектов"
L["Welcome to Leatrix Plus."] = "Добро пожаловать в Leatrix Plus."
L["Western Plaguelands"] = "Западные Чумные земли"
L["Westfall"] = "Западный Край"
L["Wetlands"] = "Болотина"
L["Widget"] = "Виджет"
L["Width"] = "Ширина"
L["Wildkin E'ko"] = "Э'ко диких совухов"
L["will be automatically accepted in 10 seconds unless cancelled."] = "будет автоматически принят в течение 10 секунд, если не будет отменен."
L["Winter"] = "Зима"
L["Winterfall E'ko"] = "Э'ко фурболгов племени Зимней Спячки"
L["Wintergrasp"] = "Озеро Ледяных Оков"
L["Winterspring"] = "Зимние Ключи"
L["World of Warcraft"] = "World of Warcraft"
L["Wrath of the Lich King"] = "Гнев Короля Лича"
L["Wrath of the Lich King Classic"] = "Гнев Короля Лича Классика"
L["X Offset"] = "Х Смещение"
L["Y Offset"] = "Y Смещение"
L["Yawns"] = "Зевание"
L["YOU"] = "ВЫ"
L["You cannot do that in combat."] = "Вы не можете сделать это в бою."
L["You have"] = "У Вас"
L["You need to be group leader."] = "Вы должны быть лидером группы"
L["You should keybind web link!"] = "Вы должны привязать веб-ссылку!"
L["You should set a keybind for the web link feature.  It's very useful.|n|nOpen the key bindings window (accessible from the game menu) and click Leatrix Plus.|n|nSet a keybind for Show web link.|n|nNow when your pointer is over an item, NPC or spell (and more), press your keybind to get a web link."] = "Вы должны привязать клавишу для функции веб-ссылки. Это очень полезно.|n|nОткройте окно привязки клавиш (доступно из меню игры) и нажмите Leatrix Plus.|n|nПривяжите клавишу для отображения веб-ссылки.|n|nТеперь, когда ваш указатель находится над предметом, NPC, заклинанием (и многим другим), нажмите привязанную клавишу, чтобы получить веб-ссылку."
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Вам нужно перезагрузить пользовательский интерфейс (UI), чтобы некоторые внесенные вами изменения вступили в силу.|n|nВы можете выполнить перезагрузку не сразу, а когда полностью завершите работу с настройками."
L["Your UI needs to be reloaded."] = "Вам необходимо перезагрузить пользовательский интерфейс."
L["Zangarmarsh"] = "Зангартопь"
L["Zones"] = "Зоны"
L["Zoram'gar Outpost"] = "Застава Зорам'гар"
L["Zul'Aman"] = "Зул'Аман"
L["Zul'Drak"] = "Зул'Драк"
L["Zul'Farrak"] = "Зул'Фаррак"
L["Zul'Gurub"] = "Зул'Гуруб"
L["Zulian, Razzashi, and Hakkari Coins"] = "Монеты племен: Зулиан, Раззаши и Хаккари"
L["Zygor addon not found."] = "Модификация Zygor не найдена."

end

-- koKR: Korean
if GameLocale == "koKR" then
L["+"] = "+"
L["A Donation of Mageweave"] = "마법 옷감 기부"
L["A Donation of Runecloth"] = "룬무늬 옷감 기부"
L["A Donation of Silk"] = "비단 옷감 기부"
L["A Donation of Wool"] = "양모 옷감 기부"
L["A friend request from"] = "친구 신청"
L["Accept available quests automatically"] = "퀘스트 자동 수락"
L["Accept resurrection"] = "부활 수락"
L["Accept summon"] = "소환 수락"
L["Additional Runecloth"] = "룬무늬 옷감 추가 기부"
L["Addon"] = "애드온"
L["Aerie Peak"] = "맹금의 봉우리"
L["Ahn'Qiraj"] = "안퀴라즈"
L["Alterac Mountains"] = "알터랙 산맥"
L["Anchor"] = "이동"
L["Angelic"] = "천사"
L["Arathi Highlands"] = "아라시 고원"
L["Ashenvale"] = "잿빛 골짜기"
L["Astranaar"] = "아스트라나르"
L["Auberdine"] = "아우버다인"
L["Auto loot is now enabled."] = "자동 전리품이 활성화되었습니다."
L["AutoFollow"] = "따라가기 설정됨"
L["AutoFollow disabled."] = "따라가기 해제."
L["Automate gossip"] = "대화 자동 넘김"
L["Automate quests"] = "퀘스트 자동 수락"
L["Automation"] = "자동화"
L["Azshara"] = "아즈샤라"
L["Azuremyst Isle"] = "하늘안개섬"
L["Back to Main Menu"] = "주 메뉴로 돌아가기"
L["Bad ID"] = "잘못된 ID"
L["Badlands"] = "황야의 땅"
L["Barrens"] = "남부 불모의 땅"
L["Battle"] = "전투"
L["Battle of Warsong Gulch"] = "전쟁노래 협곡 전투"
L["Battlegrounds"] = "전장"
L["Black Morass"] = "검은늪"
L["Black Temple"] = "검은사원"
L["Blackfathom Deeps"] = "검은 심연 나락"
L["Blackrock Depths"] = "검은바위 나락"
L["Blackwing Lair"] = "검은날개 둥지"
L["Blade's Edge Mountains"] = "칼날산맥"
L["Blasted Lands"] = "저주받은 땅"
L["Block duels"] = "결투 차단"
L["Block friend requests"] = "친구요청 차단"
L["Block party invites"] = "파티초대 차단"
L["Blocks"] = "차단"
L["Bloodmyst Isle"] = "핏빛안개 섬"
L["Booty Bay"] = "무법항"
L["Bottom"] = "하단"
L["Brackenwall Village"] = "담쟁이 마을"
L["Buffs"] = "버프"
L["Burning Crusade"] = "불타는 성전"
L["Burning Crusade Classic"] = "불타는 성전 클래식"
L["Burning Steppes"] = "불타는 평원"
L["Buyout Only"] = "즉시구입가 만!"
L["by Leatrix Plus"] = "by Leatrix Plus"
L["C"] = "C"
L["Camera distance"] = "카메라 거리"
L["Camp Mojache"] = "모자케 야영지"
L["Camp Taurajo"] = "타우라조 야영지"
L["Cannot announce in this zone."] = "이곳에서는 알림을 사용할수 없습니다."
L["Cannot find General chat channel."] = "일반 채팅 채널을 찾을 수 없습니다."
L["Cenarion Hold"] = "세나리온 요새"
L["Chain style"] = "테두리 스타일"
L["Character"] = "캐릭터"
L["Chat"] = "채팅"
L["Chat Frame"] = "채팅창"
L["Checkbox labels are Ok."] = "체크박스를 확인합니다."
L["Chillwind Camp"] = "서리바람 야영지"
L["Chillwind E'ko"] = "서리바람 키메라의 에코"
L["Cinematics"] = "시네마틱"
L["Claiming Arathi Basin"] = "아라시 분지 공격"
L["Class colored frames"] = "유닛프레임 직업색상"
L["Class icon portraits"] = "초상화 직업아이콘"
L["Classic"] = "클래식"
L["click here for new selection"] = "목록을 갱신하려면 여기를 클릭하세요."
L["Click to configure the settings for this option."] = "설정을 구성하려면 클릭합니다."
L["Click to reset the settings on this page."] = "이 페이지를 재설정 하려면 클릭합니다."
L["Click to resize the screen to fit between the top and bottom borders."] = "상,하단간 화면에 맞게 화면 크기를 설정합니다. "
L["Click to return to the main menu."] = "주 메뉴 돌아가기 클릭"
L["Cloak"] = "망토"
L["Coilfang Reservoir"] = "갈퀴송곳니 저수지"
L["Combat log cannot be hidden while undocked."] = "** 창(일반 전투) 연결이 해제되면 숨길수 없습니다."
L["Combat plates"] = "전투시 이름표 표시"
L["Completed."] = "완료"
L["Concerted Efforts"] = "공동의 노력"
L["Configuration Panel"] = "설정창"
L["Connections for"] = "연결된 서버"
L["Conquering Arathi Basin"] = "아라시 분지 정복"
L["Credits"] = "크레딧"
L["Crossroads"] = "십자로"
L["Cursor"] = "커서"
L["Cursor Left"] = "커서 왼쪽"
L["Cursor Right"] = "커서 오른쪽"
L["D"] = "D"
L["Darkmoon Faire"] = "다크문 축제"
L["Darkshire"] = "다크샤이어"
L["Darkshore"] = "어둠해안"
L["Deadmines"] = "죽음의 폐광"
L["Deadwind Pass"] = "죽음의 고개"
L["Desolace"] = "잊혀진 땅"
L["Dire Maul"] = "혈투의 전장"
L["Disable bag automation"] = "가방 자동열림 비활성"
L["Disable chat fade"] = "챗 사라짐 비활성"
L["Disable loot warnings"] = "전리품 경고 비활성"
L["Disable screen effects"] = "이펙트 비활성"
L["Disable screen glow"] = "빛 효과 비활성"
L["Disable sticky chat"] = "채널고정 사용안함"
L["Drag the frame overlay to position the frame."] = "위치 변경은 프레임 드레그 이동하세요."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "위치는 드레그 이동, 크기는 슬라이더 조정 설정."
L["Drag to set the buffs frame scale."] = "버프 프레임 스케일을 설정하려면 드래그하십시오."
L["Drag to set the cursor X offset."] = "드래그하여 커서 X 오프셋을 설정합니다."
L["Drag to set the cursor Y offset."] = "드래그하여 커서 Y 오프셋을 설정합니다."
L["Drag to set the density of weather effects."] = "날씨효과 밀도를 설정합니다."
L["Drag to set the font size of book text."] = "책 텍스트의 글꼴 크기를 설정하려면 드래그하십시오."
L["Drag to set the font size of mail text."] = "드래그하여 우편 글꼴 크기를 설정하십시오."
L["Drag to set the font size of quest text."] = "드래그하여 퀘스트 글꼴 크기를 설정하십시오."
L["Drag to set the scale of the Leatrix Plus panel."] = "드래그하여 Leatrix Plus 패널 크기를 설정하십시오."
L["Drag to set the scale of the selected frame."] = "드래그하여 선택된 프레임의 크기를 설정하십시오."
L["Drag to set the size of the bottom border."] = "드래그하여 아래쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the left border."] = "드래그하여 왼쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the right border."] = "드래그하여 오른쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the top border."] = "드래그하여 윗쪽 테두리의 크기를 설정하십시오."
L["Drag to set the tooltip scale."] = "드래그하여 툴팁 크기를 설정하십시오."
L["Drag to set the transparency of the borders."] = "드래그하여  테두리의 투명도를 설정하십시오."
L["Drag to set the transparency of the Leatrix Plus panel."] = "드래그하여 Leatrix Plus 패널의 투명도를 설정하십시요."
L["Drag to size"] = "Drag to size"
L["Dun Morogh"] = "던 모로"
L["Dungeons"] = "던전"
L["Dup ID"] = "중복ID"
L["durability"] = "당신의"
L["Durability"] = "내구도"
L["Durotar"] = "듀로타"
L["Duskwood"] = "그늘숲"
L["Dustwallow Marsh"] = "먼지진흙 습지대"
L["Eastern Kingdoms"] = "동부 왕국"
L["Eastern Plaguelands"] = "동부 역병지대"
L["Easy item destroy"] = "쉬운 아이템 파괴"
L["ELITE"] = "정예"
L["Elwynn Forest"] = "엘윈 숲"
L["Enable viewport"] = "뷰포트 사용"
L["Enhance dressup"] = "미리보기 설정"
L["Enhance minimap"] = "미니맵 설정"
L["Enhance professions"] = "전문기술창 확장"
L["Enhance quest log"] = "퀘스트창 확장"
L["Enhance tooltip"] = "툴팁 설정"
L["Enhance trainers"] = "트레이너 확장"
L["Enhancements"] = "기능 향상"
L["Enter"] = "Enter"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "표시할 주문 ID를 입력하세요.|n|n소환수 프레임 아래 표시하려면 소환수 박스를 체크하세요.|n|n쿨다운아이콘은 직업으로 저장됩니다."
L["enter zone or track name"] = "지역 또는 트랙이름을 입력하세요."
L["Error messages will be hidden"] = "오류메시지 숨김"
L["Error messages will be shown"] = "오류메시지 표시"
L["Events"] = "이벤트"
L["Everlook"] = "눈망루 마을"
L["Eversong Woods"] = "영원노래 숲"
L["Extras"] = "기타"
L["False"] = "거짓"
L["Faster auto loot"] = "빠른 전리품 획득"
L["Faster movie skip"] = "빠른 무비 넘김"
L["Feathermoon"] = "페더문 요새"
L["Features"] = "특징"
L["Felwood"] = "악령숲"
L["Feralas"] = "페랄라스"
L["Fight for Warsong Gulch"] = "전쟁노래 협곡 전투"
L["Find Item"] = "아이템찾기"
L["Firewing Signets"] = "불꽃날개 인장"
L["Flame Crest"] = "화염 마루"
L["For Great Honor"] = "커다란 영광을 위하여"
L["Frames"] = "프레임"
L["Freewind Post"] = "높새바람 봉우리"
L["Frostmaul E'ko"] = "서리망치거인의 에코"
L["Frostsaber E'ko"] = "눈호랑이의 에코"
L["Gadgetzan"] = "가젯잔"
L["Game Options"] = "게임 설정"
L["Ghost"] = "유령"
L["Ghostlands"] = "유령의 땅"
L["Gloomy"] = "Gloomy"
L["Gnomeregan"] = "놈리건"
L["Gold Only"] = "골드 만!"
L["Graphics and Sound"] = "그래픽,소리"
L["Grom'gol"] = "그롬골"
L["Groups"] = "그룹"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "구루바시, 썩은가지, 마른나무껍질부족 주화"
L["H"] = "H"
L["Hammerfall"] = "망치 주둔지"
L["Haunted"] = "Haunted"
L["Hellfire Peninsula"] = "지옥불 반도"
L["Hellfire Ramparts"] = "지옥불 성루"
L["Helm"] = "투구"
L["Help"] = "도움말"
L["Hide chat buttons"] = "채팅 버튼 숨김"
L["Hide cooldown duration numbers (if enabled)"] = "주문 지속시간 숨김"
L["Hide error messages"] = "에러메시지 숨김"
L["Hide gryphons"] = "그리핀 문양 숨김"
L["Hide portrait numbers"] = "초상화 전투수치 숨김"
L["Hide stance bar"] = "태세바 숨김"
L["Hide the combat log"] = "전투기록 숨김"
L["Hide the zone text bar"] = "지역명 숨김"
L["Hide the zoom buttons"] = "확대축소 버튼 숨김"
L["Hide tooltips for world units during combat"] = "전투중 월드유닛 툴팁 숨김"
L["Hide zone text"] = "지역명 숨김"
L["High"] = "높음"
L["Hillsbrad Foothills"] = "언덕마루 구릉지"
L["Hinterlands"] = "동부 내륙지"
L["Home"] = "홈"
L["Hyjal Summit"] = "하이잘 정상"
L["Ice Thistle E'ko"] = "얼음엉겅퀴설인의 에코"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "가방 검색 창이 가방 프레임과 은행 프레임에 표시됩니다."
L["If checked, a button will be added to the character frame which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "케릭창에 내구도 정보 추가"
L["If checked, a master volume slider will be shown in the character frame."] = "마스터 볼륨 조절이 케릭터 정보 하단에 표시됩니다."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "경매창의 추가 기능. |n|n즉시구입가 만! :시작가 없이 즉구가 입력만 생성.|n|n골드 만! :경매 99은99동 자동입력. |n|n아이템찾기 :경매에 아이템찾기 버튼 생성. |n|n경매 유형,기간 설정은 계정전체에 저장됩니다."
L["If checked, alert frames will not be shown."] = "경고,알림 프레임이 표시되지 않습니다."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "상인과 대화시 가방에 있는 모든 회색템이 자동 판매됩니다. |n|n이 설정을 무시하려면 shift 누르고 대화 합니다."
L["If checked, available quests will be accepted automatically."] = "사용 가능한 퀘스트는 자동으로 수락됩니다."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "적대적-붉은색, 우호적-파란색"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "BattleTag과 실명ID 친구 요청이 자동으로 거절됩니다."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "채팅창의 버튼을 숨깁니다. 최근메시지 표시-탭 클릭. 마우스휠 사용가능."
L["If checked, chat text will not fade out after a time period."] = "채팅글이 일정시간후 사라짐 비활성."
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "직업 색상은 플레이어, 대상, 주시 프레임에서 사용됩니다."
L["If checked, class colors will be used in the chat frame."] = "이 옵션을 선택하면 채팅 프레임에서 직업색상이 사용됩니다."
L["If checked, completed quests will be turned-in automatically."] = "퀘스트 자동 완료(..."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "전리품 판매,우편발송 시 확인경고 표시안함."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "주문 지속시간 숨김"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "유닛프레임 초상화에 표시되는 데미지,힐 수치 표시 숨김."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "채팅창 잠긴 경우 탭(일반 전투)드레그로 위쪽을 길이 조절 할수있습니다."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "케릭터가 다음 경우 감정표현이 음소거:|n|n- 휴식.|n- 애완동물 대전.|n- 언덕골 시장.|n- 주정뱅이 선술집.|n|n감정표현 소리는 위의 상황에 적용되지 않을때 활성화 됩니다."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "전투시에만 이름표가 표시되고 비전투시 표시되지 않습니다."
L["If checked, guild ranks will be shown for players in your guild."] = "길드에 속한 플레이어의 길드 등급이 표시됩니다."
L["If checked, helm and cloak toggle checkboxes will be shown in the character frame.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "투구(H) 및 망토(C) 전환 체크박스가 케릭터 정보창에 표시됩니다.  체크박스를 Shift + 마우스 오른쪽 버튼으로 클릭하여 레이아웃을 변경 할 수 있습니다."
L["If checked, holiday event sounds will be muted.|n|nThis applies to Headless Horseman."] = "주간 이벤트 소리가 음소거됩니다.|n이것은 저주받은 기사(할로윈 축제) 에게 적용됩니다."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "파티,공격대 챗색상 모두 같은색(파티)으로"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "버프,디버프 툴팁에 주문id 표시"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "길드,파티,공격대..대화채널을 고정 되지 않게합니다."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "비전투시 소환 자동수락"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "게임옵션의 애드온 열때 해당 케릭터의 목록 표시(기본-전체)"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "자동 전리품 획득 시간이 크게 줄어듭니다."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "소지품,은행 정리버튼 숨김"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "블리자드 공격대 프레임을 토글(숨김 표시)하는 버튼을  공격대 관리 창 (화면의 왼쪽)  위에 표시됩니다."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "전투 로그 창을 숨깁니다."
L["If checked, the editbox will be moved to the top of the chat frame."] = "채팅입력창을 프레임 상단으로 이동 설정됩니다."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "죽음시 회색화면과 netherworld 효과가 비활성화됩니다."
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "인터페이스 버튼 소리, 채팅창 탭 클릭 소리 및 게임 메뉴 토글 소리가 음소거됩니다."
L["If checked, the main bar gryphons will not be shown."] = "스킬바의 그리핀 문양 제거"
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "사용 가능한 가방 슬롯 수는 배낭 버튼 아이콘 및 툴팁에 표시됩니다."
L["If checked, the player frame background will be shown in class color."] = "플레이어 프레임이 클래스 색상으로 표시됩니다."
L["If checked, the professions frame will be larger."] = "전문기술창이 더 커집니다."
L["If checked, the ready check sound will be muted."] = "준비 확인 소리가 음소거됩니다."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "빛 효과가 비활성 됩니다.|n|n사용시 술취한 어지럼 효과가 비활성 됩니다."
L["If checked, the spell fizzle sounds will be muted."] = "스킬 연타? 소리가 음소거됩니다."
L["If checked, the stance bar will not be shown."] = "태세바 숨김.(전사,도적,성기사,드루...)"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "화면 하단의 NPC 대화 프레임 숨김"
L["If checked, the target frame background will be shown in class color."] = "대상 프레임이 클래스 색상으로 표시됩니다."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "툴팁의 크기,위치,배경색 설정"
L["If checked, the vendor price will be shown in item tooltips."] = "상점 판매 가격이 아이템 툴팁에 표시 됩니다."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "줌 버튼을 숨깁니다.설정과 상관없이 마우스휠로 확대 축소 할수있습니다."
L["If checked, train sounds will be muted."] = "기차 소리가 음소거됩니다."
L["If checked, unit targets will be shown."] = "대상의 대상 표시"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Ctrl키를 누른 상태에서 채팅창 탭을 클릭하면 복사하기 쉬운 최근의 채팅을 볼수 있습니다."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "채팅 입력에서 삽입 포인터를 방향키로 이동 할수 있습니다."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "재생 중지 확인 없이 무비를 취소 할수 있습니다."
L["If checked, you will be able to change the font size of book text."] = "책 텍스트의 글꼴 크기를 변경할 수 있습니다."
L["If checked, you will be able to change the font size of quest text."] = "퀘스트 텍스트의 글꼴 크기를 변경할 수 있습니다."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "우편글자 크기를 변경할수 있습니다."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "버프 프레임의 위치와 스케일을 변경할 수 있습니다."
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "위젯 프레임의 위치와 크기를 변경할 수 있습니다. |n위젯 프레임은 일반적으로 PvP 점수 및 추적 목표를 표시하는 데 사용됩니다."
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "UI배치를 위한 상.하 검은색 배경 생성"
L["If checked, you will be able to customise the minimap."] = "미니맵을 사용자 정의 할 수 있습니다."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "화면 모서리로 채팅창을 옮길수 있습니다."
L["If checked, you will be able to mute a selection of game sounds."] = "선택한 게임 소리를 음소거 할 수 있습니다."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "대상창(기본프레임) 위에 최대 5개의 쿨다운(버프류) 아이콘을 배치 할 수 있습니다."
L["If checked, you will be able to reposition the tooltip."] = "툴팁의 위치를 변경할수 있습니다."
L["If checked, you will be able to set the density of weather effects."] = "날씨 효과의 밀도를 설정할 수 있습니다."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "플레이어 프레임에 희귀,정예 문양 표시"
L["If checked, you will be able to zoom out to a greater distance."] = "사용시 게임설정-시점-최대시야거리: Max 고정."
L["If checked, you will no longer need to type delete when destroying a superior quality item.|n|nIn addition, item links will be shown in all item destroy confirmation windows."] = "아이템을 파괴 할 때 지금파괴. 입력없이 사용할수 있습니다. |n|n아이템 파괴 확인 창에 아이템 링크가 표시됩니다."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "전장에서 사망 한 후 자동으로 해제됩니다. |n|n 자기 부활 능력이 있으면 자동으로 해제되지 않습니다."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "기본 128행을 4096행으로 증가"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "상인을 방문 할때 장비가 자동으로 수리됩니다.|n|nShift키 누른채 대화시 자동 무시."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "화면 가운데 표시되는 지역명 숨김. (예: 아이언포지)"
L["Increase chat history"] = "채팅 기록 증가"
L["Interface"] = "인터페이스"
L["Invaders of Alterac Valley"] = "알터랙 계곡의 침략자"
L["Invalid console variable."] = "잘못된 콘솔 변수."
L["Invalid parameter."] = "잘못된 매개변수"
L["Invalid quest ID."] = "잘못된 퀘스트ID"
L["Invalid sound ID"] = "잘못된 사운드 ID"
L["Invalid taint level."] = "잘못된 오염 레벨입니다."
L["Invalid target."] = "잘못된 대상"
L["Invite from whispers"] = "귓속말 초대"
L["Ironforge"] = "아이언포지"
L["Kalimdor"] = "칼림도어"
L["Karazhan"] = "카라잔"
L["Kargath"] = "카르가스"
L["Keyword"] = "키워드"
L["Lakeshire"] = "레이크샤이어"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus는 다음 로그 아웃시 LeaPlusDB를 덮어 쓰지 않습니다."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS : 잘못된 버전이 설치되었습니다!"
L["Left"] = "왼쪽"
L["Lifetime honorable kills"] = "전체 명예 승수"
L["Light's Hope Chapel"] = "희망의 빛 예배당"
L["Loch Modan"] = "모단 호수"
L["Lockout sharing"] = "업적공유 잠금"
L["Low"] = "Low"
L["Magic"] = "Magic"
L["Magisters' Terrace"] = "마법학자의 정원"
L["Main Titles"] = "메인 타이틀"
L["Manage buffs"] = "버프 설정"
L["Manage focus"] = "주시 설정"
L["Manage frames"] = "프레임 설정"
L["Manage widget"] = "위젯 설정"
L["Managed by Leatrix Plus"] = "Leatrix Plus 에서 설정"
L["Map"] = "지도"
L["Maraudon"] = "마라우돈"
L["Marks of Kil'jaeden"] = "킬제덴의 징표"
L["Marks of Sargeras"] = "살게라스의 징표"
L["Marshal's Refuge"] = "마샬의 야영지"
L["Max camera zoom"] = "시야거리 최대 고정"
L["Mechanics"] = "기능"
L["Media"] = "미디어"
L["Medium"] = "중간"
L["Memory Usage"] = "메모리 사용"
L["Menethil Harbor"] = "메네실 항구"
L["message shown."] = "메시지가 표시됩니다."
L["Messages"] = "메시지"
L["messages shown."] = "메시지가 표시됩니다."
L["Missing console variable."] = "누락된 콘솔 변수."
L["Missing mount name."] = "누락된 탈거."
L["Missing movie ID."] = "잘못된 무비 ID."
L["Missing quest ID."] = "퀘스트ID 없음"
L["Missing sound file parameter."] = "소리 파일 매개변수 에러"
L["Missing sound ID."] = "누락 된 사운드 ID."
L["Molten Core"] = "화산 심장부"
L["Moonglade"] = "달의 숲"
L["More Firewing Signets"] = "불꽃날개 인장 추가 수집"
L["More Marks of Kil'jaeden"] = "킬제덴의 징표 추가 수집"
L["More Marks of Sargeras"] = "살게라스의 징표 추가 수집"
L["More Sunfury Signets"] = "성난태양 인장 추가 수집"
L["Morgan's Vigil"] = "모건의 망루"
L["Mount not found."] = "탈거를 찾을수 없습니다."
L["Move editbox to top"] = "입력창 상단"
L["Movie not playable."] = "무비를 재생할수 없습니다."
L["Movie number"] = "무비 번호"
L["Movies"] = "무비"
L["Mulgore"] = "멀고어"
L["Music"] = "배경음악"
L["Musical Moments"] = "Musical Moments"
L["Mute game sounds"] = "게임 소리 음소거"
L["Mystery"] = "Mystery"
L["Nagrand"] = "나그란드"
L["Narration"] = "Narration"
L["Naxxramas"] = "낙스라마스"
L["Nethergarde Keep"] = "네더가드 요새"
L["Netherstorm"] = "황천의 폭풍"
L["Nijel's Point"] = "나이젤의 야영지"
L["No bad sound IDs found."] = "잘못된 ID를 찾을수 없습니다."
L["No help is available for this page."] = "도움말을 사용할수 없습니다."
L["No items with durability equipped."] = "내구성 갖춘 아이템이 없습니다."
L["No media duplicates found."] = "중복된 미디어가 없습니다."
L["No tooltip showing."] = "툴팁이 없습니다."
L["None"] = "없음"
L["Not completed."] = "미완료"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "주의!|nLeatrix Plus 이 버전을 적용하려면 게임 클라이언트를 다시 시작해야합니다."
L["Nude"] = "옷벗기"
L["Old Hillsbrad Foothills"] = "옛 언덕마루 구릉지"
L["Onyxia's Lair"] = "오닉시아의 둥지"
L["or click the minimap button to open Leatrix Plus."] = "미니 맵 버튼을 클릭하여 Leatrix Maps를 엽니 다."
L["Orgrimmar"] = "오그리마"
L["Outland"] = "아웃랜드"
L["Overall"] = "전체"
L["Overlay"] = "오버레이"
L["Particle density"] = "입자 밀도"
L["Party from friends"] = "친구의 파티"
L["Pet"] = "소환수"
L["Player"] = "플레이어"
L["Power"] = "파워"
L["Press CTRL/C to copy."] = "Ctrl C 를 눌러 복사."
L["Queue from friends"] = "친구의 대기열"
L["R"] = "R"
L["Ragefire Chasm"] = "성난불길 협곡"
L["Raid"] = "공격대"
L["Raid frame toggle"] = "레이드 프레임 토글"
L["Random"] = "무작위 재생"
L["RARE"] = "희귀"
L["RARE ELITE"] = "희귀 정예"
L["Ratchet"] = "톱니항"
L["Razorfen Downs"] = "가시덩굴 구릉"
L["Razorfen Kraul"] = "가시덩굴 우리"
L["Recent chat window"] = "최근 채팅 창"
L["Redridge Mountains"] = "붉은마루 산맥"
L["Refuge Pointe"] = "임시 주둔지"
L["Release in PvP"] = "PvP지역 부활 수락 해제"
L["Reload"] = "리로드"
L["Remember Alterac Valley!"] = "잊지 말자, 알터랙 계곡!"
L["Repair automatically"] = "자동 수리"
L["Repaired for"] = "수리비"
L["Reposition the tooltip"] = "툴팁 위치 설정"
L["Requires UI reload."] = "UI 리로드 필요."
L["Reset"] = "재설정"
L["Resize book text"] = "책 글꼴크기 변경"
L["Resize mail text"] = "우편 글자 설정"
L["Resize quest text"] = "퀘스트 글자 설정"
L["Resize Screen"] = "화면 크기 조정"
L["Rested bubbles"] = "휴식 버블"
L["result"] = "결과"
L["results"] = "결과들"
L["Revantusk Village"] = "깨진엄니 마을"
L["Right"] = "오른쪽"
L["Right-click to close"] = "창닫기:우클릭."
L["Right-click to close."] = "창닫기:우클릭. ."
L["right-click to go back"] = "마우스 오른쪽 클릭으로 뒤로 이동."
L["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허"
L["Rut'theran Village"] = "루테란 마을"
L["Sacred"] = "Sacred"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "성난모래, 백골가루, 붉은머리부족 주화"
L["Scale"] = "크기"
L["Scarlet Monastery"] = "붉은십자군 수도원"
L["Scholomance"] = "스칼로맨스"
L["Search"] = "검색"
L["Searing Gorge"] = "이글거리는 협곡"
L["Select the settings that you want to use."] = "사용하려는 설정을 선택합니다."
L["Selection of music tracks"] = "음악 트랙 선택"
L["Self Markers Allowed"] = "전술 징표 허용 "
L["Self Markers Blocked"] = "전술 징표 차단"
L["Sell junk automatically"] = "회색템 자동 판매"
L["SELLING JUNK"] = "자동판매"
L["Sentinel Hill"] = "감시의 언덕"
L["Set weather density"] = "날씨 밀도 설정"
L["Settings"] = "설정"
L["Shaders"] = "쉐이더"
L["Shadowfang Keep"] = "그림자송곳니 성채"
L["Shadowmoon Valley"] = "어둠달 골짜기"
L["Shadowprey Village"] = "그늘수렵 마을"
L["Shardtooth E'ko"] = "톱니이빨곰의 에코"
L["Show auction controls"] = "경매 추가 기능"
L["Show bag search box"] = "가방 검색창 표시"
L["Show character addons"] = "케릭터 애드온 표시"
L["Show cooldowns"] = "쿨다운 아이콘 표시"
L["Show cooldowns above the player frame"] = "Show cooldowns above the player frame"
L["Show durability status"] = "내구도 표시"
L["Show free bag slots"] = "가방 빈칸 수 표시"
L["Show guild names"] = "길드명 표시"
L["Show guild ranks for your guild"] = "길드등급 표시"
L["Show minimap button"] = "미니맵 버튼 표시"
L["Show player chain"] = "플레이어 테두리 표시"
L["Show player frame in class color"] = "플레이어 프레임 직업색상 표시"
L["Show raid button"] = "공격대 버튼 표시"
L["Show the spell ID in buff icon tooltips"] = "툴팁 주문ID 표시"
L["Show unit targets"] = "Show unit targets"
L["Show vanity controls"] = "투구,망토 설정 표시"
L["Show vendor price"] = "상점 판매가 표시"
L["Show volume slider"] = "소리 조절 표시"
L["Show Wowhead links"] = "와우헤드 링크 표시"
L["Silence rested emotes"] = "감정표현 음소거"
L["Silithus"] = "실리더스"
L["Silverpine Forest"] = "은빛소나무 숲"
L["Single Mark of Sargeras"] = "살게라스의 징표 하나"
L["Single Sunfury Signet"] = "성난태양 인장 하나"
L["Social"] = "소셜"
L["Sold junk for"] = "회색템 판매"
L["Sound system restarted."] = "사운드 시스템 재시작."
L["Southshore"] = "사우스쇼어"
L["Spell ID"] = "주문 ID"
L["Splintertree Post"] = "토막나무 주둔지"
L["Spooky"] = "Spooky"
L["Stockade"] = "스톰윈드 지하감옥"
L["Stonard"] = "스토나드"
L["Stonetalon Mountains"] = "돌발톱 산맥"
L["Stonetalon Peak"] = "돌발톱 봉우리"
L["Stop"] = "중지"
L["Stormwind"] = "스톰윈드"
L["Stranglethorn Vale"] = "가시덤불 골짜기"
L["Stratholme"] = "스트라솔름"
L["Sun Rock Retreat"] = "해바위 야영지"
L["Sunfury Signets"] = "성난태양 인장"
L["Sunken Temple"] = "가라앉은 사원"
L["Sunwell Plateau"] = "태양샘 고원"
L["Support"] = "지원"
L["Swamp"] = "Swamp"
L["Swamp of Sorrows"] = "슬픔의 늪"
L["System"] = "시스템"
L["Tabard"] = "휘장숨김"
L["Taint level: Basic (1)."] = "오염 레벨: Basic (1)"
L["Taint level: Disabled (0)."] = "오염 레벨: 비활성(0)"
L["Taint level: Full (2)."] = "오염 레벨: Full (2)"
L["Talonbranch Glade"] = "갈퀴가지 숲"
L["Talrendis Point"] = "탈렌디스 초소"
L["Tanaris"] = "타나리스"
L["Target"] = "대상"
L["Target Tracking Disabled"] = "대상 추적 사용안함"
L["Target Tracking Enabled"] = "대상 추적 사용"
L["Tarren Mill"] = "타렌 제분소"
L["Teldrassil"] = "텔드랏실"
L["Tempest Keep"] = "폭풍우 요새"
L["Temple of Ahn'Qiraj"] = "안퀴라즈"
L["Temple of Atal'Hakkar"] = "아탈학카르 신전"
L["Ten Years of Warcraft"] = "워크래프트 10주년"
L["Terokkar Forest"] = "테로카르 숲"
L["Text"] = "글자"
L["Text size"] = "글자 크기"
L["Text Size"] = "글자 크기"
L["Thalanaar"] = "탈라나르"
L["The Sepulcher"] = "공동묘지"
L["The summon from"] = "당신을 소환하는 자"
L["Thelsamar"] = "텔사마"
L["Themes"] = "테마"
L["Theramore"] = "테라모어 섬"
L["This panel will close automatically if you enter combat."] = "전투시 자동으로 닫힙니다."
L["Thorium Point"] = "토륨 거점"
L["Thousand Needles"] = "버섯구름 봉우리"
L["Thunder Bluff"] = "썬더 블러프"
L["Timer"] = "미러바"
L["Tirisfal Glades"] = "티리스팔 숲"
L["To begin, choose an options page."] = "설정 페이지를 선택합니다."
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "전투 기록을 숨기려면 ElvUI에서 채팅 모듈을 비활성화해야합니다."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "아이템찾기 사용하려면, 'WoW토큰' 카테고리 선택을 취소 해야 합니다. "
L["Tooltip"] = "툴팁"
L["Tooltip title color"] = "툴팁 제목 색상"
L["Top"] = "상단"
L["Top Center"] = "탑 센터"
L["Tracing started."] = "추적 시작."
L["Tracing stopped."] = "추적 중지."
L["Transparency"] = "투명도"
L["True"] = "참된"
L["Turn-in completed quests automatically"] = "퀘스트 자동 완료"
L["Uldaman"] = "울다만"
L["Unclamp chat frame"] = "채팅창 고정 해제"
L["Undercity"] = "언더시티"
L["Un'Goro Crater"] = "운고로 분화구"
L["Universal group color"] = "그룹 색상 통합"
L["Use arrow keys in chat"] = "방향키 사용"
L["Use class colors in chat"] = "채팅 직업색상 사용"
L["Use easy resizing"] = "쉬운 크기조절"
L["Valormok"] = "발로르모크"
L["Value must be a number."] = "값은 숫자 이여야 합니다."
L["Various"] = "기타"
L["Vendors"] = "상인"
L["Version"] = "버전"
L["Very Low"] = "아주 낮음"
L["Video"] = "비디오"
L["Visibility"] = "가시성"
L["Wailing Caverns"] = "통곡의 동굴"
L["was automatically declined."] = "자동으로 거절되었습니다."
L["Weather density"] = "기상 밀도"
L["Welcome to Leatrix Plus."] = "Leatrix Plus 에 오신 것을 환영합니다."
L["Western Plaguelands"] = "서부 역병지대"
L["Westfall"] = "서부 몰락지대"
L["Wetlands"] = "저습지"
L["Widget"] = "위젯"
L["Wildkin E'ko"] = "올빼미야수의 에코"
L["will be automatically accepted in 10 seconds unless cancelled."] = "취소하지 않으면 10 초 후에 자동으로 수락됩니다."
L["Winter"] = "겨울"
L["Winterfall E'ko"] = "눈사태일족의 에코"
L["Winterspring"] = "여명의 설원"
L["World of Warcraft"] = "월드 오브 워크래프트"
L["X Offset"] = "X 오프셋"
L["Y Offset"] = "Y 오프셋"
L["YOU"] = "당신"
L["You cannot do that in combat."] = "전투중으로 할수 없습니다."
L["You have"] = "장비 내구도"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "일부 변경사항을 적용하려면 UI를 다시 로드 하여야 합니다. 요구시 리로드 버튼 활성화."
L["Your UI needs to be reloaded."] = "당신의 UI는 다시 로드 해야 합니다."
L["Zangarmarsh"] = "장가르 습지대"
L["Zones"] = "지역"
L["Zoram'gar Outpost"] = "조람가르 전초기지"
L["Zul'Aman"] = "줄아만"
L["Zul'Farrak"] = "줄파락"
L["Zul'Gurub"] = "줄구룹"
L["Zulian, Razzashi, and Hakkari Coins"] = "줄리안, 래즈자쉬, 학카리부족 주화"
L["Zygor addon not found."] = "Zygor 애드온 찾을수 없음."

end

-- deDE: German
if GameLocale == "deDE" then
	L["+"] = "+"
L["A Donation of Mageweave"] = "Spendet Magiestoff"
L["A Donation of Runecloth"] = "Spendet Runenstoff"
L["A Donation of Silk"] = "Spendet Seide"
L["A Donation of Wool"] = "Spendet Wolle"
L["A friend request from"] = "Eine Freundschaftsanfrage von"
L["Accept available quests automatically"] = "Automatisch verfügbare Quests akzeptieren"
L["Accept resurrection"] = "Wiederbelebung annehmen"
L["Accept summon"] = "Beschwörung annehmen"
L["Additional Runecloth"] = "Noch mehr Runenstoff"
L["Addon"] = "Erweiterung"
L["Aerie Peak"] = "Nistgipfel"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alterac Mountains"] = "Alteracgebirge"
L["Anchor"] = "Anker"
L["Angelic"] = "Engels"
L["Arathi Highlands"] = "Arathihochland"
L["Ashenvale"] = "Ashenvale"
L["Auto loot is now enabled."] = "Automatisches Plündern ist nun aktiv."
L["AutoFollow"] = "Automatisches verfolgen"
L["AutoFollow disabled."] = "Automatisches verfolgen ausgeschaltet."
L["Automate gossip"] = "Automatischer Verkauf von Müll"
L["Automate quests"] = "Automatische Questannahme"
L["Automation"] = "Auto"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Azurmythosinsel"
L["Back to Main Menu"] = "Zurück zum Hauptmenü"
L["Bad ID"] = "Schlechte ID"
L["Badlands"] = "Ödland"
L["Barrens"] = "Brachland"
L["Battle"] = "Schlacht"
L["Battle of Warsong Gulch"] = "Schlacht der Warsongschlucht"
L["Battlegrounds"] = "Kampfgebiete"
L["Black Morass"] = "Schwarze Morast"
L["Black Temple"] = "Der Schwarze Tempel"
L["Blackfathom Deeps"] = "Blackfathom-Tiefe"
L["Blackrock Depths"] = "Blackrocktiefen"
L["Blackwing Lair"] = "Pechschwingenhort"
L["Blade's Edge Mountains"] = "Schergrat"
L["Blasted Lands"] = "Verwüstete Lande"
L["Block duels"] = "Duelle blockieren"
L["Block friend requests"] = "Freundschaftsanfragen blockieren"
L["Block party invites"] = "Gruppeneinladungen blockieren"
L["Blocks"] = "Blocken"
L["Bloodmyst Isle"] = "Blutmythosinsel"
L["Booty Bay"] = "Beutebucht"
L["Bottom"] = "Unterseite"
L["Brackenwall Village"] = "Brackenwall"
L["Buffs"] = "Buffs"
L["Burning Crusade"] = "Burning Crusade"
L["Burning Crusade Classic"] = "Burning Crusade Classic"
L["Burning Steppes"] = "Brennende Steppe"
L["Buyout Only"] = "nur Sofortkauf"
L["by Leatrix Plus"] = "von Leatrix Plus"
L["C"] = "C"
L["Camera distance"] = "Kamera-Distanz"
L["Cannot announce in this zone."] = "Kann in dieser Zone nicht ankündigen werde."
L["Cannot find General chat channel."] = "Allgemein-Kanal kann nicht gefunden werden."
L["Cenarion Hold"] = "Burg Cenarius"
L["Chain style"] = "Ketten Stil"
L["Character"] = "Charakter"
L["Chat"] = "Chat"
L["Chat Frame"] = "Chat-Fenster"
L["Checkbox labels are Ok."] = "Kontrollkästchen Bezeichnungen sind OK."
L["Chillwind Camp"] = "Zugwindlager"
L["Chillwind E'ko"] = "E'ko der Eiswindschimären"
L["Cinematics"] = "Film"
L["Claiming Arathi Basin"] = "Inbesitznahme des Arathibeckens"
L["Class colored frames"] = "Fenster in Klassenfarben"
L["Class icon portraits"] = "Klassen Icon Portraits"
L["Classic"] = "Classic"
L["click here for new selection"] = "für eine neue Auswahl hier klicken"
L["Click to configure the settings for this option."] = "Klicken um die Einstellungen für diese Option anzupassen."
L["Click to disable Titan Panel screen adjust.  Your UI will be reloaded."] = "Klicken Sie hier, um die Bildschirmanpassung von Titan Panel zu deaktivieren. Ihre Benutzeroberfläche wird neu geladen."
L["Click to reset the settings on this page."] = "Hier klicken um die Einstellungen dieser Seite zurückzusetzen."
L["Click to resize the screen to fit between the top and bottom borders."] = "Klicken, um die Größe des Bildschirms so zu ändern, dass er zwischen den oberen und unteren Rändern passt. "
L["Click to return to the main menu."] = "Hier klicken um zurück zum Hauptmenü zu gelangen."
L["Cloak"] = "Umhang"
L["Coilfang Reservoir"] = "Der Echsenkessel"
L["Combat log cannot be hidden while undocked."] = "Kampflog kann nicht versteckt werden währenddem er freigegeben ist."
L["Combat plates"] = "Kampf Namensplaketten"
L["Completed."] = "Abgeschlossen."
L["Concerted Efforts"] = "Gemeinsames Bestreben"
L["Configuration Panel"] = "Einstellungen"
L["Connections for"] = "Verbindungen für"
L["Conquering Arathi Basin"] = "Eroberung des Arathibeckens"
L["Credits"] = "Credits"
L["Crossroads"] = "Das Wegekreuz"
L["Cursor"] = "Cursor"
L["Cursor Left"] = "Cursor Links"
L["Cursor Right"] = "Cursor Rechts"
L["D"] = "D"
L["Darkmoon Faire"] = "Dunkelmond-Jahrmarkt"
L["Darkshire"] = "Dunkelhain"
L["Darkshore"] = "Die Dunkelküste"
L["Deadmines"] = "Todesminen"
L["Deadwind Pass"] = "Gebirgspass der Totenwinde"
L["Desolace"] = "Desolace"
L["Dire Maul"] = "Düsterbruch"
L["Disable bag automation"] = "Automatisches öffnen aller Taschen deaktivieren "
L["Disable chat fade"] = "Ausblenden des Chats deaktivieren"
L["Disable loot warnings"] = "Loot-Warnungen deaktivieren"
L["Disable screen effects"] = "Bildschirmeffekte deaktivieren"
L["Disable screen glow"] = "Aufleuchten des Bildschirms deaktivieren "
L["Disable sticky chat"] = "Stick Chat deaktvieren"
L["Dismount me"] = "Absteigen"
L["Dismount when casting a spell while moving"] = "Steigt automatisch ab, wenn du auf dem Reittier einen Zauber wirkst."
L["Dismount when clicking a flight destination"] = "Steigt automatisch ab, wenn du auf dem Reittier einen Flugmeister ansprichst."
L["Dismount when not enough rage, mana or energy"] = "Steigt automatisch ab, wenn nicht genug Wut, Mana oder Energie vorhanden ist."
L["Dismount when the flight map opens"] = "Steigt automatisch ab, wenn du auf dem Reittier die Flugkarte öffnest."
L["Drag the frame overlay to position the frame."] = "Verschieben um die Position des Fenster Overlay anzupassen."
L["Drag the frame overlay to position the frame.|n|nThis panel will close automatically if you enter combat."] = "Ziehe die Rahmenanzeige, um den Rahmen zu positionieren.|n|nDieses Fenster wird automatisch geschlossen, wenn du im Kampf bist."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Verschieben um die Position des Fenster Overlays anzupassen.|n|nAnklicken und verschieben un die Größe des Fenster ändern.|n|nDieses Menü wird sich automatisch schließen wenn du im Kampf bist."
L["Drag to set the buffs frame scale."] = "Verschieben um die Größe der Stärkungszauber-Leiste anzupassen."
L["Drag to set the cursor X offset."] = "Verschieben um den Cursor X Versatz/Offset anzupassen."
L["Drag to set the cursor Y offset."] = "Verschieben um den Cursor Y Versatz/Offset anzupassen."
L["Drag to set the density of weather effects."] = "Verschieben um die Dichte der Wetter Effekte anzupassen."
L["Drag to set the focus frame scale."] = "Ziehen, um die Skalierung des Fokusrahmens festzulegen."
L["Drag to set the font size of book text."] = "Ziehen, um die Schriftgröße des Buchtexts festzulegen. "
L["Drag to set the font size of mail text."] = "Verschieben um die Schriftgröße des Post Texts anzupassen."
L["Drag to set the font size of quest text."] = "Verschieben um die Schriftgröße des Quest Texts anzupassen."
L["Drag to set the scale of the Leatrix Plus panel."] = "Verschieben um die Größe des Leatrix Plus Fensters anzupassen."
L["Drag to set the scale of the selected frame."] = "Verschieben um die Größe des ausgewählen Fensters anzupassen."
L["Drag to set the size of the bottom border."] = "Verschieben um die Größe vom unterem Rahmen anzupassen."
L["Drag to set the size of the left border."] = "Verschieben um die Größe vom linkem Rahmen anzupassen."
L["Drag to set the size of the right border."] = "Verschieben um die Größe vom rechten Rahmen anzupassen."
L["Drag to set the size of the top border."] = "Verschieben um die Größe vom oberen Rahmen anzupassen."
L["Drag to set the tooltip scale."] = "Verschieben um die Größe des Tooltips anzupassen."
L["Drag to set the transparency of the borders."] = "Verschieben um die Transparenz der Rahmen anzupassen."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Verschieben um die Transparenz des Leatrix Plus Fensters anzupassen."
L["Drag to set the widget scale."] = "Ziehen, um die Widget-Skalierung festzulegen."
L["Drag to size"] = "Auf Größe ziehen"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeons"] = "Dungeons"
L["Dup ID"] = "Dup ID"
L["durability"] = "haltbarkeit"
L["Durability"] = "Haltbarkeit"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Dämmerwald"
L["Dustwallow Marsh"] = "Marschen von Dustwallow"
L["Eastern Kingdoms"] = "Östliche Königreiche"
L["Eastern Plaguelands"] = "Östliche Pestländer"
L["Easy item destroy"] = "Gegenstands-Zerstörung"
L["ELITE"] = "ELITE"
L["Elwynn Forest"] = "Wald von Elwynn"
L["Enable viewport"] = "Ansichtsfenster aktivieren."
L["Enhance dressup"] = "Anprobe erweitern"
L["Enhance minimap"] = "Minimap erweitern"
L["Enhance professions"] = "Berufsfenster erweitern"
L["Enhance quest log"] = "Questfenster erweitern"
L["Enhance tooltip"] = "Tooltip erweitern"
L["Enhance trainers"] = "Lehrerfenster erweitern"
L["Enhancements"] = "Verbesserungen"
L["Enter"] = "Eingeben"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Zauber IDs eingeben um die Icons für die Abklingzeiten anzuzeigen.|n|nBegleiter Kontrollkästchen anwählen, wenn ein Abklingzeit-Icon normalerweise unter dem Begleiter-Fenster auftaucht.|n|nDiese Icons werden für ihre Klasse."
L["enter zone or track name"] = "Zone oder Verfolgungsname eingeben"
L["Error messages will be hidden"] = "Fehlermeldungen werden versteckt"
L["Error messages will be shown"] = "Fehlermeldungen werden angezeigt"
L["Events"] = "Veranstaltungen"
L["Everlook"] = "Ewige Warte"
L["Eversong Woods"] = "Immersangwald"
L["Extras"] = "Extras"
L["False"] = "Falsch"
L["Faster auto loot"] = "Schnelleres Auto looten"
L["Faster movie skip"] = "Schnelleres überspringen von Filmsequenzen"
L["Feathermoon"] = "Mondfederfeste"
L["Features"] = "Features"
L["Felwood"] = "Teufelswald"
L["Feralas"] = "Feralas"
L["Fight for Warsong Gulch"] = "Kampf um die Warsongschlucht"
L["Find Item"] = "Gegenstand finden"
L["Firewing Signets"] = "Siegel der Feuerschwingen"
L["Flame Crest"] = "Flammenkamm"
L["Focus"] = "Fokus"
L["For Great Honor"] = "Große Ehre"
L["Frames"] = "Fenster"
L["Freewind Post"] = "Freiwindposten"
L["Frostmaul E'ko"] = "E'ko der Frosthagelriesen"
L["Frostsaber E'ko"] = "E'ko der Frostsäbler"
L["Game Options"] = "Spieloptionen"
L["Ghost"] = "Geist"
L["Ghostlands"] = "Geisterlande"
L["Gloomy"] = "Düster"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Ausschließlich Gold"
L["Graphics and Sound"] = "Grafik und Sound"
L["Groups"] = "Gruppen"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "Münzen der Gurubashi, Vilebranch und Witherbark"
L["H"] = "H"
L["Haunted"] = "Verfolgt"
L["Hellfire Peninsula"] = "Höllenfeuerhalbinsel"
L["Hellfire Ramparts"] = "Höllenfeuerbollwerk"
L["Helm"] = "Helm"
L["Help"] = "Hilfe"
L["Hide chat buttons"] = "Chat-Buttons verstecken"
L["Hide cooldown duration numbers (if enabled)"] = "Nummern der Cooldown Anzeige verbergen (wenn aktiviert)"
L["Hide error messages"] = "Fehlermeldungen verstecken"
L["Hide gryphons"] = "Greifenpaar verstecken"
L["Hide portrait numbers"] = "Portraitnummern verbergen"
L["Hide stance bar"] = "Haltungsleiste verstecken"
L["Hide the combat log"] = "Kampflog verstecken"
L["Hide the zone text bar"] = "Verstecke die Zonen-Text Leiste"
L["Hide the zoom buttons"] = "Zoom Buttons verbergen"
L["Hide tooltips for world units during combat"] = "Im Kampf Tooltips für Welt Einheiten verstecken"
L["Hide zone text"] = "Gebietstext verbergen"
L["High"] = "Hoch"
L["Hillsbrad Foothills"] = "Vorgebirge des Hügellands"
L["Hinterlands"] = "Hinterlande"
L["Home"] = "Home"
L["Hyjal Summit"] = "Hyjalgipfel"
L["Ice Thistle E'ko"] = "E'ko der Eisdistelyetis"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Wenn diese Option aktiviert ist, wird im Rucksackrahmen und im Bankrahmen ein Taschen-Suchfeld angezeigt."
L["If checked, a button will be added to the character frame which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Wenn ausgewählt, wird ein Button zum Charakter-Fenster hinzugefügt. Wenn der Mousezeiger über diesem Button ist, wird die Ausrüstungs Haltbarkeit angezeigt.|n|nZusätzlich wird beim Sterben, ein Gesamt-Prozentsatz Wert im Chat ausgegeben."
L["If checked, a master volume slider will be shown in the character frame."] = "Wenn ausgewählt, wird ein Gesamtlautstärke-Regler im Charakter-Fenster angezeigt."
L["If checked, alert frames will not be shown."] = "Wenn ausgewählt, werden keine Alarm Fenster mehr angezeigt."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Wenn ausgewählt, werden alle grauen Gegenstände in deinen Taschen automatisch verkauft wenn du mit einem Händler sprichst.|n|nHalte die SHIFT-Taste gedrückt wenn du mit einem Händler sprichst um diese Funktion aufzuheben."
L["If checked, available quests will be accepted automatically."] = "Wenn ausgewählt, werden verfügbare Quests automatisch akzeptiert."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Wenn ausgewählt, wird der Hintergrund blau (freundlich) oder rot (feindlich) eingefärbt."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Wenn ausgewählt, werden BattleTag und Real ID Freundschaftsanfragen automatisch abgelehnt.|n|nDurch das Aktivieren der Option, werden alle ausstehenden Anfragen automatisch abgelehnt."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Wenn ausgewählt, werden die Chat-Fenster Buttons versteckt.|n|nBei einem Klick auf die Chat Reiter/Tabs werden automatisch die letzten Nachrichten angezeigt.|n|nBenutz das Mausrad um durch den Chat Verlauf zu scrollen. Halte die SHIFT-Taste um einen Seite weit zu springen, oder die STRG-Taste um zum Anfang oder Ende des Chat Verlaufs zu springen."
L["If checked, chat text will not fade out after a time period."] = "Wenn ausgewählt, wird der Chat Text nach einer Zeit nicht mehr automatisch verblassen."
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "Wenn ausgewählt, wird die Klassenfarbe für das Spieler, Ziel und Fokus-Fenster benutzt."
L["If checked, class colors will be used in the chat frame."] = "Wenn diese Option aktiviert ist, werden im Chatfenster Klassenfarben verwendet. "
L["If checked, completed quests will be turned-in automatically."] = "Wenn ausgewählt, werden abgeschlossene Quests automatisch abgegeben."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Wenn ausgewählt, werden Bestätigungen nicht länger angezeigt wenn du auf einen erbeuteten Gegenstand würfelst oder einen handelbaren Gegenstand verkaufst oder per Post verschickst."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Wenn ausgewählt, werden keine Zahlen für Abklingzeiten angezeigt.|n|nWenn nicht ausgewählt, wird ein numerischer Countdown für Abklingzeiten angezeigt, sofern es auch in den Interface Optionen ('Aktionsleisten' Menü) aktiviert ist."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Wenn ausgewählt, werden Schadens und Heilungszahlen am Spieler und Begleiter-Fenster versteckt."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Wenn ausgewählt, wird das Chat-Fenster nach oben erweitert wenn es fixiert ist aber am Reiter/Tab gezogen wird.|n|nFalls das Chat-Fenster freigegeben ist, wird es durch das ziehen bewegt."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Wenn ausgewählt, werden Sprach-Emotes stumm geschalten währendem dein Charakter:|n|n- sich ausruht|n- im Grimmigen Säufer ist|n|nSofern keines davon zutritt, sind Sprach-Emotes aktiviert."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Wenn ausgewählt, werden feindliche Namensplaketten während dem Kampf angezeigt aber außerhalb des Kampfs versteckt."
L["If checked, helm and cloak toggle checkboxes will be shown in the character frame.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Wenn diese Option aktiviert ist, werden im Charakterfenster Kontrollkästchen zum Umschalten von Helm und Umhang angezeigt. |n|nSie können die Umschalttaste gedrückt halten und mit der rechten Maustaste auf die Kontrollkästchen klicken, um die Ansicht zu wechseln. "
L["If checked, holiday event sounds will be muted.|n|nThis applies to Headless Horseman."] = "Wenn ausgewählt, werden Feiertags Event Sounds stumm geschalten.|n|nDas trifft zu für den kopflosen Reiter."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Wenn ausgewählt, werden Schlachtzugs und Instanz Chats in blau angezeigt (um mit der Standard Gruppenchat Frabe übereinzustimmen)."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Wenn ausgewählt, werden Zauber IDs in den Tooltips der Stärkunszauber Leiste und unter dem Ziel-Fenster angezeigt."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Wenn ausgewählt, wird das sticky Chat Verhalten deaktviert.|n|nBeachte, dass dies für temporäre Chat-Fenster nicht funktioniert."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Wenn ausgewählt, werden Beschwörungs-Anfragen standardmäßig akzeptiert sofern du dich nicht im Kampf befindest."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Wenn ausgewählt, wird die Addon-Liste (erreichbar durch das Spielmenü) standardmäßig Addons für den Charakter anzeigen."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Wenn ausgewählt, wird die benötigte Zeit zum Kreaturen Plündern erheblich verkürzt."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Wenn ausgewählt, wird der Taschen & Bank aufräumen Knopf nicht angezeigt."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Wenn ausgewählt, wird der Button zum Schlachtzugsfenster anzeigen/verstecken oberhalb des Schlachtzugs-Managements Fenster (auf der linken Seite des Bildschirms) angezeigt - statt innerhalb des Menüs.|n|nDas erlaubt das anzeigen/verstecken des Schlachtzugsfenster ohne das Menü öffnen zu müssen."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Wenn ausgewählt, wird der Kampflog versteckt.|n|nDamit diese Option richtig funktioniert muss der Kampflog fixiert sein.|n|nFalls das Chat-Fenster des Kampflogs freigegeben ist, kannst du es wieder fixieren indem du den Tab/Reiter zurück ziehst oder in dem du vom Chat Menü aus die Chat-Fenster zurücksetzt."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Wenn ausgewählt, wird das Chat-Fenster zum Nachrichten Verfassen am oberen Rand des Chat-Fenster geöffnet."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Wenn ausgewählt, wird der graue Geister Bildschirm Effekt und der Jenseits Effekt deaktiviert."
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "Wenn ausgewählt, werden der Interface Button Sound, der Chat-Fenster Tab/Reiter Klick Ton und der Spielmenü Öffnungs & Schließungs Sound stumm geschalten."
L["If checked, the main bar gryphons will not be shown."] = "Wenn ausgewählt, wird das Greifenpaar von der Haupt-Aktionsleiste nicht angezeigt."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Wenn diese Option aktiviert ist, wird die Anzahl der freien Gepäckfächer im Symbol für die Rucksackschaltfläche und im Tooltip angezeigt. "
L["If checked, the player frame background will be shown in class color."] = "Wenn ausgewählt, wird der Hintergrund vom Spieler Fenster in Klassenfarbe angezeigt."
L["If checked, the professions frame will be larger."] = "Wenn diese Option aktiviert ist, wird der Rahmen für Berufe größer. "
L["If checked, the ready check sound will be muted."] = "Wenn ausgewählt, wird der Ton vom Bereitschaftscheck stumm geschalten."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Wenn ausgewählt, wird das Bildschirm leuchten/Schimmer deaktviert.|n|nDurch das Aktivieren der Option wird auch die Betrunkenheits-Trübung deaktiviert."
L["If checked, the spell fizzle sounds will be muted."] = "Wenn ausgewählt, werden die fizzle/missglückt Sounds von Zauber stumm geschalten."
L["If checked, the stance bar will not be shown."] = "Wenn ausgewählt, wird die Haltungsleiste versteckt."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Wenn ausgewählt, wird das Unterhaltung Fenster versteckt.|n|nDas Unterhaltung Fenster wird normalerweise im unteren Teil des Bildschirms angezeigt wenn manche NPCs mit dir kommunizieren."
L["If checked, the target frame background will be shown in class color."] = "Wenn ausgewählt, wird der Hintergrund des Ziel Fensters in Klassenfarbe angezeigt."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Wenn ausgewählt, wird der Tooltip farbkodiert und du kannst das Layout sowieso die Größe ändern."
L["If checked, the vendor price will be shown in item tooltips."] = "Wenn diese Option aktiviert ist, wird der Händlerverkaufspreis in den Tooltips angezeigt. "
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Wenn ausgewählt, werden die Zoom Buttons versteckt. Das Mausrad kann weiterhin zum Zoomen verwendet werden."
L["If checked, train sounds will be muted."] = "Wenn ausgewählt, werden Töne von Bahnen stumm geschalten."
L["If checked, unit targets will be shown."] = "Wenn ausgewählt, werden die Ziele der Einheit angezeigt."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Wenn ausgewählt, kannst du per STRG-Klick auf den Chat Reiter/Tab ein Fenster öffnen um kürzliche Nachrichten einfach zu kopieren."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Wenn ausgewählt, können die Pfeiltasten im Chat verwendet werden um den Cursor nach links oder rechts zu bewegen.|n|nWenn nicht ausgewählt, werden die Pfeiltasten die Standard Tastenbelegung verwenden."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Wenn ausgewählt, kannst du Cinematics ohne Bestätigung abbrechen."
L["If checked, you will be able to change the font size of book text."] = "Wenn diese Option aktiviert ist, können Sie die Schriftgröße des Buchtexts ändern. "
L["If checked, you will be able to change the font size of quest text."] = "Wenn ausgewählt, kannst du die Quest Text Schriftgröße ändern."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Wenn ausgewählt, kannst du die Standard Schriftgröße von Brieftexten ändern.|n|nDas funktioniert nicht für Briefe die aus einer Vorlage erstellt wurden (sowie Auktionshaus Briefe)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Wenn ausgewählt, kannst du die Position und Größe der Stärkungszauber Leiste ändern."
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "Wenn ausgewählt, kannst du die Position und Größe des Widget-Rahmen ändern.|n|nDer Widget-Rahmen wird für gewöhnlich benutzt um den PvP Punktestand und Ziele zu verfolgen."
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Wenn diese Option aktiviert ist, können Sie ein Ansichtsfenster erstellen. Ein Ansichtsfenster fügt anpassbare schwarze Ränder um die Spielwelt hinzu. |n|nDie Ränder werden über der Spielwelt, aber unter der Benutzeroberfläche platziert, sodass Sie Benutzeroberflächenelemente darüber platzieren können. "
L["If checked, you will be able to customise the minimap."] = "Wenn ausgewählt, kannst du die Minimap anpassen."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Wenn ausgewählt, kannst du das Chat-Fenster bis zum Rand des Bildschirms verschieben."
L["If checked, you will be able to mute a selection of game sounds."] = "Wenn ausgewählt, kannst du eine Auswahl an Spielsounds stummschalten."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Wenn ausgewählt, kannst du bis zu 5 positive Abklingzeiteiten über dem Ziel-Fenster anzeigen."
L["If checked, you will be able to reposition the tooltip."] = "Wenn ausgewählt, kannst du das Tooltip Fenster verschieben."
L["If checked, you will be able to set the density of weather effects."] = "Wenn ausgewählt, kannst du die Intensität der Wetter Effekte bestimmen."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Wenn ausgewählt, kannst du dein Spieler Portrait mit einem Rare, Elite oder Rare Elite Rahmen dekorieren."
L["If checked, you will be able to zoom out to a greater distance."] = "Wenn ausgewählt, kannst du auf weitere Distanz herauszoomen."
L["If checked, you will no longer need to type delete when destroying a superior quality item.|n|nIn addition, item links will be shown in all item destroy confirmation windows."] = "Wenn ausgewählt, musst du nicht mehr löschen schreiben sofern du einen Gegenstand mit Überragendender Qualität zerstören möchtest.|n|nZusätzlich werden Gegenstands Verlinkungen in allen Zerstörungs-Bestätigungs Fenster angezeigt."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Wenn ausgewählt, wird der Geist automatisch freigelassen falls du in einem Schlachtfeld stirbst."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Wenn ausgewählt, wird der Chat Verlauf auf 4096 Zeilen erweitert. Wenn nicht ausgewählt, wird der Standard von 128 Zeilen benutzt.|n|nDas Aktivieren der Option wird möglicherweise die Anzeige von Chat Text während dem Login verhindern."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Wenn du einen passenden Händler aufsuchst wird deine Rüstung automatisch repariert, falls aktiviert.|n|nWenn, während der Händler angesprochen wird, die Shift Taste gedrückt gehalten wird, kann diese Einstellung überschrieben werden."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Gebietstext (z.B, 'Eisenschmiede') wird nicht angezeigt, falls ausgewählt."
L["Increase chat history"] = "Chat Verlauf erweitern"
L["Interface"] = "Interface"
L["Invaders of Alterac Valley"] = "Die Invasoren des Alteractals"
L["Invalid console variable."] = "Ungültige Konsolen Variable"
L["Invalid parameter."] = "Ungültiger Parameter."
L["Invalid quest ID."] = "Ungültige Quest ID."
L["Invalid sound ID"] = "Ungültige Sound ID"
L["Invalid taint level."] = "Ungültiger taint level"
L["Invalid target."] = "Ungültiges Ziel."
L["Invite from whispers"] = "Einladen via flüstern"
L["Ironforge"] = "Eisenschmiede"
L["Kalimdor"] = "Kalimdor"
L["Karazhan"] = "Karazhan"
L["Keyword"] = "Stichwort"
L["Lakeshire"] = "Seenhain"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Beim nächsten Logout wird LeaPlusDB nicht durch Leatrix Plus überschrieben."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: FALSCHE VERSION INSTALLIERT!"
L["Left"] = "Links"
L["Lifetime honorable kills"] = "Gesamte Ehrenhafte Siege"
L["Light's Hope Chapel"] = "Kapelle des hoffnungsvollen Lichts"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Lockout sharing"
L["Low"] = "Niedrige "
L["Magic"] = "Magie"
L["Magisters' Terrace"] = "Terrasse der Magister"
L["Main Titles"] = "Haupttitel"
L["Manage buffs"] = "Buffs verwalten"
L["Manage focus"] = "Fokus einstellen"
L["Manage frames"] = "Fenster verwalten"
L["Manage widget"] = "Widget verwalten"
L["Managed by Leatrix Plus"] = "Verwaltet durch Leatrix Plus"
L["Map"] = "Karte"
L["Maraudon"] = "Maraudon"
L["Marks of Kil'jaeden"] = "Male von Kil'jaeden"
L["Marks of Sargeras"] = "Male des Sargeras"
L["Marshal's Refuge"] = "Marschalls Zuflucht"
L["Max camera zoom"] = "Maximaler Kamera-Zoom"
L["Mechanics"] = "Mechaniken"
L["Media"] = "Medien"
L["Medium"] = "Mittel"
L["Memory Usage"] = "Speicherverbrauch"
L["Menethil Harbor"] = "Hafen von Menethil"
L["message shown."] = "nachricht angezeigt."
L["Messages"] = "Nachrichten"
L["messages shown."] = "angezeigte Nachrichten."
L["Missing console variable."] = "Fehlende Consolen Variable."
L["Missing mount name."] = "Fehlender Mountname."
L["Missing movie ID."] = "Fehlende Film ID."
L["Missing quest ID."] = "Fehlende Quest ID."
L["Missing sound file parameter."] = "Fehlender Sound Datei Parameter."
L["Missing sound ID."] = "Fehlende Sound ID."
L["Molten Core"] = "Geschmolzener Kern"
L["Moonglade"] = "Mondlichtung"
L["More Firewing Signets"] = "Mehr Siegel der Feuerschwingen"
L["More Marks of Kil'jaeden"] = "Mehr Male von Kil'jaeden"
L["More Marks of Sargeras"] = "Mehr Male des Sargeras"
L["More Sunfury Signets"] = "Mehr Siegel des Sonnenzorns"
L["Morgan's Vigil"] = "Morgans Wacht"
L["Mount not found."] = "Reittier nicht gefunden."
L["Move editbox to top"] = "Texteingabe über Chat"
L["Movie not playable."] = "Film nicht abspielbar."
L["Movie number"] = "Filmnummer"
L["Movies"] = "Filme"
L["Mulgore"] = "Mulgore"
L["Music"] = "Musik"
L["Musical Moments"] = "Musikalische Momente"
L["Mute game sounds"] = "Sounds stummschalten"
L["Mystery"] = "Geheimnis"
L["Nagrand"] = "Nagrand"
L["Narration"] = "Erzählung"
L["Naxxramas"] = "Naxxramas"
L["Nethergarde Keep"] = "Burg Nethergarde"
L["Netherstorm"] = "Nethersturm"
L["Nijel's Point"] = "Die Nijelspitze"
L["No bad sound IDs found."] = "Es wurden keine fehlerhaften Sound IDs gefunden."
L["No help is available for this page."] = "Für diese Seite ist keine Hilfe verfügbar."
L["No items with durability equipped."] = "Keine Gegenstände mit Haltbarkeit ausgerüstet."
L["No media duplicates found."] = "Keine Media Duplikate gefunden."
L["No tooltip showing."] = "Kein Tooltip gezeigt"
L["None"] = "Keiner"
L["Not completed."] = "Nicht abgeschlossen"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "WICHTIG|nDu musst deinen Spielclient komplett neu starten, bevor du diese Version von Leatrix Plus nutzen kannst."
L["Nude"] = "Nackt"
L["Old Hillsbrad Foothills"] = "Vorgebirge des Alten Hügellands"
L["Onyxia's Lair"] = "Onyxias Hort"
L["or click the minimap button to open Leatrix Plus."] = "oder klicke auf den Button an der Minikarte."
L["Orgrimmar"] = "Orgrimmar"
L["Outland"] = "Scherbenwelt"
L["Overall"] = "Insgesamt"
L["Overlay"] = "Überlagerung"
L["Particle density"] = "Partikeldichte"
L["Party from friends"] = "Gruppen von Freunden"
L["Pet"] = "Haustier"
L["Player"] = "Spieler"
L["Power"] = "Leistung"
L["Press CTRL/C to copy."] = "Zum kopieren STRG+C drücken."
L["Queue from friends"] = "Warteschlange von Freunden"
L["R"] = "S"
L["Ragefire Chasm"] = "Der Flammenschlund"
L["Raid"] = "Schlachtzüge"
L["Raid frame toggle"] = "Schlachtzugsfenster umschalten"
L["Random"] = "Zufällig"
L["RARE"] = "SELTENER"
L["RARE ELITE"] = "SELTENER ELITE"
L["Ratchet"] = "Ratschet"
L["Razorfen Downs"] = "Hügel der Klingenhauer"
L["Razorfen Kraul"] = "Kral der Klingenhauer"
L["Recent chat window"] = "Kürzliches Chat Fenster"
L["Redridge Mountains"] = "Rotkammgebirge"
L["Refuge Pointe"] = "Die Zuflucht"
L["Release in PvP"] = "Geist im PvP freilassen"
L["Reload"] = "Neu laden"
L["Remember Alterac Valley!"] = "Vergesst das Alteractal nicht!"
L["Repair automatically"] = "Automatisch reparieren"
L["Repaired for"] = "Repariert für"
L["Reposition the tooltip"] = "Tooltip neu positionieren"
L["Requires UI reload."] = "Erfordert das neu laden des UI."
L["Reset"] = "Zurücksetzen"
L["Resize book text"] = "Größe des Buchtextes"
L["Resize mail text"] = "Mail-Text Größe"
L["Resize quest text"] = "Quest-Text Größe"
L["Resize Screen"] = "Größe der Fenster"
L["Rested bubbles"] = "Rested bubbles"
L["result"] = "Ergebnis"
L["results"] = "Ergebnisse"
L["Revantusk Village"] = "Dorf der Bruchhauer"
L["Right"] = "Rechts"
L["Right-click to close"] = "Rechtsklick zum schließen"
L["Right-click to close."] = "Rechtsklick zum schließen."
L["right-click to go back"] = "Rechtsklick um zurück zu gelangen"
L["Ruins of Ahn'Qiraj"] = "Die Ruinen von Ahn'Qiraj"
L["Rut'theran Village"] = "Rut'theran"
L["Sacred"] = "Heilig"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "Münzen der Sandfury, Skullsplitter und Bloodscalp"
L["Scale"] = "Rahmen"
L["Scarlet Monastery"] = "Das Scharlachrote Kloster"
L["Scholomance"] = "Scholomance"
L["Search"] = "Suche"
L["Searing Gorge"] = "Sengende Schlucht"
L["Select the settings that you want to use."] = "Auswahl der bevorzugten Einstellung."
L["Selection of music tracks"] = "Auswahl an Musikspur"
L["Self Markers Allowed"] = "Selbst-Markierung erlaubt"
L["Self Markers Blocked"] = "Selbst-Markierung blockiert"
L["Sell junk automatically"] = "Automatisch verkaufen"
L["SELLING JUNK"] = "RAMSCH VERKAUFEN"
L["Sentinel Hill"] = "Späherkuppe"
L["Set weather density"] = "Setze Wetter Dichte"
L["Settings"] = "Einstellungen"
L["Shaders"] = "Shaders"
L["Shadowfang Keep"] = "Burg Shadowfang"
L["Shadowmoon Valley"] = "Schattenmondtal"
L["Shadowprey Village"] = "Schattenflucht"
L["Shardtooth E'ko"] = "E'ko eines Splitterzahns"
L["Show bag search box"] = "Taschen-Suchfeld anzeigen"
L["Show character addons"] = "Zeige Charakter Addons"
L["Show cooldowns"] = "Zeige Abklingzeiten"
L["Show cooldowns above the player frame"] = "Abklingzeiten über dem Spielerrahmen anzeigen"
L["Show durability status"] = "Zeige Haltbarkeit Status"
L["Show free bag slots"] = "Zeige freie Taschenplätze an "
L["Show guild names"] = "Gildennamen anzeigen"
L["Show guild ranks for other guilds"] = "Zeige Gildenränge anderer Gilden"
L["Show guild ranks for your guild"] = "Zeige Gildenränge der eigenen Gilde"
L["Show minimap button"] = "Minimap Button anzeigen"
L["Show player chain"] = "Zeige Ketten um das Spieler Fenster Spieler Portrait Rahmen"
L["Show player frame in class color"] = "Färbe das Spieler Fenster in Klassenfarbe"
L["Show raid button"] = "Schlachtzugs Button"
L["Show the spell ID in buff icon tooltips"] = "Zauber ID im Buff Icon Tooltip anzeigen"
L["Show unit targets"] = "Einheitenziele anzeigen"
L["Show vendor price"] = "Händlerverkaufspreis anzeigen"
L["Show volume slider"] = "Zeige Lautstärkeregler"
L["Show Wowhead links"] = "Zeige Wowhead Links"
L["Silence rested emotes"] = "rested emotes stummschalten"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Silberwald"
L["Single Mark of Sargeras"] = "Einzelne Male des Sargeras"
L["Single Sunfury Signet"] = "Einzelne Siegel des Sonnenzorns"
L["Social"] = "Kontakte"
L["Sold junk for"] = "Ramsch verkauft für"
L["Sound system restarted."] = "Sound System neugestartet."
L["Southshore"] = "Süderstade"
L["Spell ID"] = "Zauber ID"
L["Splintertree Post"] = "Splitterholzposten"
L["Spooky"] = "Gruslig"
L["Stockade"] = "Verlies"
L["Stonard"] = "Steinard"
L["Stonetalon Mountains"] = "Steinkrallengebirge"
L["Stonetalon Peak"] = "Steinkrallengipfel"
L["Stop"] = "Stop"
L["Stormwind"] = "Sturmwind"
L["Stranglethorn Vale"] = "Schlingendorntal"
L["Stratholme"] = "Stratholme"
L["Sun Rock Retreat"] = "Sonnenfels"
L["Sunfury Signets"] = "Siegel des Sonnenzorns"
L["Sunken Temple"] = "Versunkener Tempel"
L["Sunwell Plateau"] = "Sonnenbrunnenplateau"
L["Support"] = "Support"
L["Swamp"] = "Sümpfe"
L["Swamp of Sorrows"] = "Sümpfe des Elends"
L["System"] = "System"
L["Tabard"] = "Wappenrock"
L["Taint level: Basic (1)."] = "Taint level: einfach (1)."
L["Taint level: Disabled (0)."] = "Taint level: deaktiviert (0)."
L["Taint level: Full (2)."] = "Taint level: gesamt (2)."
L["Talonbranch Glade"] = "Nachtlaublichtung"
L["Talrendis Point"] = "Talrendisspitze"
L["Tanaris"] = "Tanaris"
L["Target"] = "Ziel"
L["Target Tracking Disabled"] = "Ziel erfolgung deaktiviert"
L["Target Tracking Enabled"] = "Ziel Verfolgung aktiviert"
L["Tarren Mill"] = "Tarrens Mühle"
L["Teldrassil"] = "Teldrassil"
L["Tempest Keep"] = "Die Festung der Stürme"
L["Temple of Ahn'Qiraj"] = "Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Der Tempel von Atal'Hakkar"
L["Ten Years of Warcraft"] = "Zehn Jahre Warcraft"
L["Terokkar Forest"] = "Wälder von Terokkar"
L["Text"] = "Text"
L["Text size"] = "Textgröße"
L["Text Size"] = "Textgröße"
L["The Sepulcher"] = "Das Grabmal"
L["The summon from"] = "Beschwörung von"
L["Themes"] = "Themes"
L["This panel will close automatically if you enter combat."] = "Dieses Fenster schließt sich im Kampf automatisch."
L["Thorium Point"] = "Thoriumspitze"
L["Thousand Needles"] = "Tausend Nadeln"
L["Thunder Bluff"] = "Donnerfels"
L["Timer"] = "Timer"
L["Tirisfal Glades"] = "Tirisfal"
L["To begin, choose an options page."] = "Wähle zum Starten eine Options Seite."
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "Du musst zuerst das Chat Modul in ElvUI deaktivieren um den Kampflog zu verstecken."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Du musst zuerst die WoW Token Kategorie abwählen um den Gegenstands-Suche Button zu verwenden."
L["Tooltip"] = "Tooltip"
L["Tooltip title color"] = "Tooltip Titel Farbe"
L["Top"] = "oben"
L["Top Center"] = "Oben in der Mitte"
L["Tracing started."] = "Nachverfolgung gestartet."
L["Tracing stopped."] = "Nachverfolgung gestoppt."
L["Transparency"] = "Transparenz"
L["True"] = "Wahr"
L["Turn-in completed quests automatically"] = "Abgeschlossene Quests automatisch abgeben"
L["Uldaman"] = "Uldaman"
L["Unclamp chat frame"] = "Chat Fenster freigeben"
L["Undercity"] = "Unterstadt"
L["Un'Goro Crater"] = "Un'Goro-Krater"
L["Universal group color"] = "Gruppen-Farbe"
L["Use arrow keys in chat"] = "Pfeiltasten benutzen"
L["Use class colors in chat"] = "Verwendet Klassenfarben im Chat"
L["Use easy resizing"] = "Einfache Größenänderung"
L["Value must be a number."] = "Wert muss eine Nummer sein."
L["Various"] = "Verschiedenes"
L["Vendors"] = "Anbieter"
L["Version"] = "Version"
L["Very Low"] = "Sehr Niedrig"
L["Video"] = "Video"
L["Visibility"] = "Sichtbarkeit"
L["Wailing Caverns"] = "Die Höhlen des Wehklagens"
L["Warning"] = "Warnung"
L["was automatically declined."] = "wurde automatisch abgebrochen."
L["Weather density"] = "Wetter Dichte"
L["Welcome to Leatrix Plus."] = "Willkommen zu Leatrix Plus."
L["Western Plaguelands"] = "Westliche Pestländer"
L["Westfall"] = "Westfall"
L["Wetlands"] = "Sumpfland"
L["Widget"] = "Widget"
L["Wildkin E'ko"] = "E'ko der Wildekin"
L["will be automatically accepted in 10 seconds unless cancelled."] = "wird in 10 Sekunden automatisch akzeptiert, sofern nicht abgebrochen"
L["Winter"] = "Winter"
L["Winterfall E'ko"] = "E'ko der Winterfelle"
L["Winterspring"] = "Winterspring"
L["World of Warcraft"] = "World of Warcraft"
L["X Offset"] = "X-Abstand"
L["Y Offset"] = "Y-Abstand"
L["YOU"] = "DU"
L["You cannot do that in combat."] = "Dies kannst du in einem Kampf nicht tun."
L["You have"] = "Du hast"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Damit gewisse Änderungen aktiv werden, muss das UI neu geladen werden.|n|nDu musst nicht gleich auf den Neuladen Button klicken, du kannst zuerst deine Änderungen fertig stellen und dann neuladen um sie zu übernehmen."
L["Your UI needs to be reloaded."] = "Das UI muss neu geladen werden."
L["Zangarmarsh"] = "Zangarmarschen"
L["Zones"] = "Gebiete"
L["Zoram'gar Outpost"] = "Außenposten von Zoram'gar"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zulian, Razzashi, and Hakkari Coins"] = "Münzen der Razzashi, Hakkari und zulianische Münzen"
L["Zygor addon not found."] = "Das Addon Zygor wurde nicht gefunden."

end

-- esMX: Latin American Spanish
if GameLocale == "esMX" then
L["+"] = "+"
L["A Donation of Mageweave"] = "Un donativo de tejido mágico"
L["A Donation of Runecloth"] = "Un donativo de paño rúnico"
L["A Donation of Silk"] = "Un donativo de seda"
L["A Donation of Wool"] = "Un donativo de lana"
L["A friend request from"] = "Una solicitud de amistad de"
L["Accept available quests automatically"] = "Aceptar misiones disponibles automáticamente"
L["Accept resurrection"] = "Aceptar resucitación"
L["Accept summon"] = "Aceptar invocación"
L["Additional Runecloth"] = "Un donativo extra de paño rúnico"
L["Addon"] = "Addon"
L["Aerie Peak"] = "Pico Nidal"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Anchor"] = "Anclar"
L["Angelic"] = "Angélico"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Ashenvale"] = "Vallefresno"
L["Auto loot is now enabled."] = "Despojar automáticamente se ha habilitado."
L["AutoFollow"] = "Seguir automáticamente"
L["AutoFollow disabled."] = "Seguir automáticamente se ha deshabilitado"
L["Automate gossip"] = "Automatizar diálogo"
L["Automate quests"] = "Automatizar misiones"
L["Automation"] = "Automatizar"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Isla Bruma Azur"
L["Back to Main Menu"] = "Volver a menú principal"
L["Bad ID"] = "ID inválida"
L["Badlands"] = "Tierras Inhóspitas"
L["Barrens"] = "Los Baldíos"
L["Battle"] = "Batalla"
L["Battle of Warsong Gulch"] = "La batalla por Garganta Grito de Guerra"
L["Battlegrounds"] = "Campos de Batalla"
L["Black Morass"] = "La Ciénaga Negra"
L["Black Temple"] = "Templo Oscuro"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blade's Edge Mountains"] = "Montañas Filospada"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Block duels"] = "Duelos"
L["Block friend requests"] = "Solicitudes de amistad"
L["Block party invites"] = "Invitaciones de grupo"
L["Blocks"] = "Rechazar"
L["Bloodmyst Isle"] = "Isla Bruma de Sangre"
L["Booty Bay"] = "Bahía del Botín"
L["Bottom"] = "Inferior"
L["Brackenwall Village"] = "Poblado Murohelecho"
L["Buffs"] = "Buffs"
L["Burning Crusade"] = "Burning Crusade"
L["Burning Crusade Classic"] = "Burning Crusade Clásico"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Buyout Only"] = "Sola compra"
L["by Leatrix Plus"] = "por Leatrix Plus"
L["C"] = "C"
L["Camera distance"] = "Distancia de cámara"
L["Camp Mojache"] = "Campamento Mojache"
L["Camp Taurajo"] = "Campamento Taurajo"
L["Cannot announce in this zone."] = "No se puede anunciar en esta zona."
L["Cannot find General chat channel."] = "No se puede encontrar el canal de chat general."
L["Cenarion Hold"] = "Fuerte Cenarion"
L["Chain style"] = "Estilo de cadena"
L["Character"] = "Personaje"
L["Chat"] = "Chat"
L["Chat Frame"] = "Marco de chat"
L["Checkbox labels are Ok."] = "Las etiquetas de las casillas de verificación están bien."
L["Chillwind Camp"] = "Campamento del Orvallo"
L["Chillwind E'ko"] = "E'ko Orvallo"
L["Cinematics"] = "Cinemáticas"
L["Claiming Arathi Basin"] = "Reclamo por la Cuenca de Arathi"
L["Class colored frames"] = "Marcos coloreados"
L["Class icon portraits"] = "Retratos de clase"
L["Classic"] = "Clásico"
L["click here for new selection"] = "haga clic para nueva selección"
L["Click to configure the settings for this option."] = "Haga clic para configurar la configuración para esta opción"
L["Click to reset the settings on this page."] = "Haga clic para restablecer la configuración en esta página"
L["Click to resize the screen to fit between the top and bottom borders."] = "Haga clic para cambiar el tamaño de la pantalla para que se ajuste entre los bordes superior e inferior."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal"
L["Cloak"] = "Espalda"
L["Coilfang Reservoir"] = "Reserva de Colmillo Torcido"
L["Combat log cannot be hidden while undocked."] = "El registro de combate no se puede ocultar mientras está desacoplado."
L["Combat plates"] = "Placas de combate"
L["Completed."] = "Completado."
L["Concerted Efforts"] = "Esfuerzos concertados"
L["Configuration Panel"] = "Panel de Configuración"
L["Connections for"] = "Conexiones de"
L["Conquering Arathi Basin"] = "La conquista de la Cuenca de Arathi"
L["Credits"] = "Créditos"
L["Crossroads"] = "El Cruce"
L["Cursor"] = "Cursor"
L["Cursor Left"] = "Cursor izquierdo"
L["Cursor Right"] = "Cursor derecho"
L["D"] = "C"
L["Darkmoon Faire"] = "Feria de la Luna Negra"
L["Darkshire"] = "Villa Oscura"
L["Darkshore"] = "Costa Oscura"
L["Deadmines"] = "Minas de la Muerte"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Desolace"] = "Desolace"
L["Dire Maul"] = "La Masacre"
L["Disable bag automation"] = "Bolsas"
L["Disable chat fade"] = "Desvanecimiento"
L["Disable loot warnings"] = "Advertencias del botín"
L["Disable screen effects"] = "Efectos de pantalla"
L["Disable screen glow"] = "Brillo de pantalla"
L["Disable sticky chat"] = "Chat pegajoso"
L["Drag the frame overlay to position the frame."] = "Arrastra la superposición del marco para colocar el marco."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Arrastra la superposición de los marco para colocar los marcos.|n|nPara cambiar la escala de un marco, haga clic para seleccionarlo y luego ajuste el control deslizante de escala.|n|nEste panel se cerrará automáticamente si entras en combate."
L["Drag to set the buffs frame scale."] = "Arrastra para establecer la escala del marco de los bufos."
L["Drag to set the cursor X offset."] = "Arrastra para establecer el desplazamiento del cursor X."
L["Drag to set the cursor Y offset."] = "Arrastra para establecer el desplazamiento del cursor Y."
L["Drag to set the density of weather effects."] = "Arrastra para establecer la densidad de los efectos entornos."
L["Drag to set the font size of book text."] = "Arrastra para establecer el tamaño de fuente del texto de libro."
L["Drag to set the font size of mail text."] = "Arrastra para establecer el tamaño de fuente del texto de correo."
L["Drag to set the font size of quest text."] = "Arrastra para establecer el tamaño de fuente del texto de misión."
L["Drag to set the scale of the Leatrix Plus panel."] = "Arrastra para establecer la escala del panel Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Arrastra para establecer la escala del marco seleccionado."
L["Drag to set the size of the bottom border."] = "Arrastra para establecer el tamaño del borde inferior."
L["Drag to set the size of the left border."] = "Arrastra para establecer el tamaño del borde izquierdo."
L["Drag to set the size of the right border."] = "Arrastra para establecer el tamaño del borde derecho."
L["Drag to set the size of the top border."] = "Arrastra para establecer el tamaño del borde superior."
L["Drag to set the tooltip scale."] = "Arrastra para establecer la escala del tooltip."
L["Drag to set the transparency of the borders."] = "Arrastra para establecer la transparencia de los bordes."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Arrastra para establecer la transparencia del panel Leatrix Plus."
L["Drag to size"] = "Arrastra para ajustar el tamaño"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeons"] = "Calabozos"
L["Dup ID"] = "ID Copia"
L["durability"] = "durabilidad"
L["Durability"] = "Durabilidad"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Eastern Kingdoms"] = "Reinos del Este"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["Easy item destroy"] = "Fácil eliminación de objetos"
L["ELITE"] = "ÉLITE"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Enable viewport"] = "Vista de ventana"
L["Enhance dressup"] = "Probador"
L["Enhance minimap"] = "Minimapa"
L["Enhance professions"] = "Profesiones"
L["Enhance quest log"] = "Registro de misiones"
L["Enhance tooltip"] = "Tooltip"
L["Enhance trainers"] = "Instructores"
L["Enhancements"] = "Mejoras"
L["Enter"] = "Entrar"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Entra la ID de hechizo para los iconos de reutilización que desea ver.|n|nSi normalmente aparece un icono de reutilización debajo del marco de la mascota, marca la casilla de verificación mascota.|n|Los iconos de reutilización se guardan en tu clase."
L["enter zone or track name"] = "entra zona o rastrea el nombre"
L["Error messages will be hidden"] = "Mensajes de error se ocultarán"
L["Error messages will be shown"] = "Mensajes de error se mostrarán"
L["Events"] = "Eventos"
L["Everlook"] = "Vista Eterna"
L["Eversong Woods"] = "Bosque Cancion Eterna"
L["Extras"] = "Excesos"
L["False"] = "Falso"
L["Faster auto loot"] = "Despojar rápido"
L["Faster movie skip"] = "Saltar película rápido"
L["Feathermoon"] = "Plumaluna"
L["Features"] = "Caracteristicas"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Fight for Warsong Gulch"] = "Lucha por Garganta Grito de Guerra"
L["Find Item"] = "Buscar objeto"
L["Firewing Signets"] = "Sellos Ala de Fuego"
L["Flame Crest"] = "Peñasco Llamarada"
L["For Great Honor"] = "Cuestión de honor"
L["Frames"] = "Marcos"
L["Freewind Post"] = "Poblado Viento Libre"
L["Frostmaul E'ko"] = "E'ko de los Machacahielo"
L["Frostsaber E'ko"] = "E'ko de sable de hielo"
L["Game Options"] = "Opciones de juego"
L["Ghost"] = "Fantasma"
L["Ghostlands"] = "Tierras Fantasmas"
L["Gloomy"] = "Melancólico"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Solo oro"
L["Graphics and Sound"] = "Gráficos y sonido"
L["Groups"] = "Grupos"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "Las monedas Gurubashi, Vilrama y Secacorteza"
L["H"] = "H"
L["Hammerfall"] = "Sentencia"
L["Haunted"] = "Encantado"
L["Hellfire Peninsula"] = "Peninsula de Fuego infernal"
L["Hellfire Ramparts"] = "Murallas del Fuego Infernal"
L["Helm"] = "Cabeza"
L["Help"] = "Ayuda"
L["Hide chat buttons"] = "Botones de chat"
L["Hide cooldown duration numbers (if enabled)"] = "Ocultar números de reutilización (si habilitado)"
L["Hide error messages"] = "Mensajes de error"
L["Hide gryphons"] = "Grifos"
L["Hide portrait numbers"] = "Números del retrato"
L["Hide stance bar"] = "Barra de actitud"
L["Hide the combat log"] = "Registro de combate"
L["Hide the zone text bar"] = "Ocultar texto de zona"
L["Hide the zoom buttons"] = "Ocultar los botones de acercar alejar"
L["Hide tooltips for world units during combat"] = "Ocultar tooltips para unidades del mundo si estés en combate"
L["Hide zone text"] = "Texto de zona"
L["High"] = "Alto"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Hinterlands"] = "Tierras del Interior"
L["Home"] = "Principal"
L["Hyjal Summit"] = "La Cima Hyjal"
L["Ice Thistle E'ko"] = "E'ko de los Cardo Nevado"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Si está seleccionado, se mostrará un cuadro de búsqueda de bolsas en el marco de la mochila y el marco del banco."
L["If checked, a button will be added to the character frame which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Si está seleccionado, se agregará un botón a la información del personaje que mostrará la durabilidad de su equipo cuando pase el puntero sobre él.|n|nAdemás, se mostrará un porcentaje general en el marco del chat cuando muera."
L["If checked, a master volume slider will be shown in the character frame."] = "Si está seleccionado, se mostrará un control deslizante de volumen maestro en la información del personaje."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "Si está seleccionado, se agregará funcionalidad adicional a la casa de subastas.|n|nSolo compra: cree subastas de compra sin completar el precio inicial.|n|nSolo oro: establezca los precios del cobre y la plata en 99 para acelerar las nuevas subastas.|n|nBuscar objeto: busca en la casa de subastas el objeto que estás vendiendo.|n|nAdemás, la configuración de duración de la subasta se guardará en toda la cuenta."
L["If checked, alert frames will not be shown."] = "Si está seleccionado, no se mostrarán los marcos de alerta."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si está seleccionado, todos los objetos de calidad pobre en sus bolsas se venderán automáticamente cuando visite a un mercader.|n|nPuede mantener presionada la tecla shift cuando hable con un mercader para anular esta configuración."
L["If checked, available quests will be accepted automatically."] = "Si está seleccionado, las misiones disponibles se aceptarán automáticamente."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Si está seleccionado, los fondos se teñirán de azul (amigable) o rojo (hostil)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Si está seleccionado, las solicitudes de amistad de BattleTag y Real ID se rechazarán automáticamente.|n|nHabilitar esta opción rechazará automáticamente cualquier solicitud pendiente."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Si está seleccionado, los botones del marco de chat estarán ocultos.|n|nAl hacer clic en las pestañas de chat, se mostrarán automáticamente los últimos mensajes.|n|nUsa la rueda del ratón para desplazarse por el historial de chat. Mantenga presionada la tecla shift para saltar de página o Ctrl para saltar a la parte superior o inferior del historial de chat."
L["If checked, chat text will not fade out after a time period."] = "Si está seleccionado, el texto del chat no se desvanecerá después de un período de tiempo."
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "Si está marcada, se utilizará el color de la clase en el marco del jugador, en el marco del objetivo y en el marco de enfoque."
L["If checked, class colors will be used in the chat frame."] = "Si está seleccionado, los colores de la clase se usarán en el marco del chat."
L["If checked, completed quests will be turned-in automatically."] = "Si está seleccionado, las misiones completadas se entregarán automáticamente."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Si está seleccionado, las confirmaciones ya no aparecerán cuando elija una opción de botín o cuando intente vender o enviar un objeto comercializable."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Si está seleccionado, los números de reutilización no se mostrarán sobre el hechizo.|n|nSi no está marcado, los números de reutilización se mostrarán sobre el hechizo si están habilitados en el panel de opciones del juego (menú 'Barras de Acción')."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Si está seleccionado, se ocultarán los números de daño y sanación en los marcos de retrato de jugador y mascota."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Si está seleccionado, arrastrando la pestaña de chat General mientras el marco de chat está bloqueado expandirá el marco de chat hacia arriba.|n|nSi el marco de chat está desbloqueado, arrastrando la pestaña de chat General se moverá el marco de chat."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Si está seleccionado, los sonidos de emoción se silenciarán mientras tu personaje esté descansando o en El Tragapenas.|n|nLos sonidos de emoción se habilitarán en cualquier otro momento."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Si está seleccionado, las placas identificativas del enemigo se mostrarán durante el combate y se ocultarán cuando finalice el combate."
L["If checked, guild ranks will be shown for players in your guild."] = "Si está seleccionado, los rangos de la hermandad se mostrarán para los jugadores de tu hermandad."
L["If checked, helm and cloak toggle checkboxes will be shown in the character frame.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Si está seleccionado, las casillas de alternar cabeza y espalda se mostrarán en la información del personaje.|n|nPuede mantener presionada la tecla shift y hacer clic con el botón derecho en las casillas de verificación para cambiar de visualización."
L["If checked, holiday event sounds will be muted.|n|nThis applies to Headless Horseman."] = "Si se marca, los sonidos de los eventos festivos se silenciarán.|n|nEsto se aplica a Jinete decapitado."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Si está seleccionado, el chat de banda y el chat de instancia serán de color azul (para que coincida con el color predeterminado del chat del grupo)."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Si está seleccionado, la ID de hechizo se mostrarán en el tooltip del icono de buff ubicado en el marco de buff y debajo del marco de objetivo."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Si está seleccionado, el chat pegajoso se deshabilitará.|n|nTenga en cuenta que esto no se aplica a las ventanas de chat temporales."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Si está seleccionado, las solicitudes de invocación serán aceptadas automáticamente a menos que estés en combate."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Si está seleccionado, la lista de addons (accesible desde el menú del juego) mostrará addons basados en personajes de forma predeterminada."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Si está seleccionado, el tiempo que se tarda en despojar automáticamente a las criaturas se reducirá significativamente."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Si está seleccionado, el botón de limpieza de la mochila y el botón de limpieza del marco del banco no se mostrarán."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Si está seleccionado, el botón para alternar el marco del contenedor de banda se mostrará justo encima del marco de administración de banda (lado izquierdo de la pantalla) en lugar de en el marco de administración de banda en sí.|n|nEsto le permite alternar el marco del contenedor de banda sin necesidad de abrir el marco de administración de banda."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Si está seleccionado, el registro de combate estará oculto.|n|nEl registro de combate debe estar acoplado para que esta opción funcione.|n|nSi el registro de combate está desacoplado, puedes acoplarlo arrastrando la pestaña (y recargando tu IU) o restableciendo las ventanas de chat (desde el menú de chat)."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Si está seleccionado, el cuadro de edición se moverá a la parte superior del marco de chat."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Si está seleccionado, la pantalla gris de la muerte y el efecto del inframundo se deshabilitarán."
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "Si está seleccionado, el sonido del botón de la interfaz, el sonido del clic de la pestaña del marco del chat y el sonido de alternancia del menú del juego se silenciarán."
L["If checked, the main bar gryphons will not be shown."] = "Si está seleccionado, no se mostrarán los grifos de la barra principal."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Si está seleccionado, la cantidad de casillas para bolsas disponibles se mostrará en el icono del botón de la mochila y en el tooltip."
L["If checked, the player frame background will be shown in class color."] = "Si está seleccionado, el fondo del marco del jugador se mostrará en color de clase."
L["If checked, the professions frame will be larger."] = "Si está seleccionado, el marco de profesiones será más grande."
L["If checked, the ready check sound will be muted."] = "Si está seleccionado, el sonido de comprobación de listo se silenciará."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Si está seleccionado, el brillo de la pantalla se deshabilitará.|n|nHabilitar esta opción también deshabilitará el efecto de borracho."
L["If checked, the spell fizzle sounds will be muted."] = "Si está seleccionado, los sonidos del hechizo fizzle serán silenciados."
L["If checked, the stance bar will not be shown."] = "Si está seleccionado, la barra de actitud no mostrará."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Si está seleccionado, el marco de conversación no se mostrará.|n|nEl marco de conversación normalmente aparece en la parte inferior de la pantalla cuando ciertos PNJs se comunican con usted."
L["If checked, the target frame background will be shown in class color."] = "Si está seleccionado, el fondo del marco de objetivo se mostrará en color de clase."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Si está seleccionado, el tooltip estará codificada por colores y podrá modificar la visualización y la escala del tooltip."
L["If checked, the vendor price will be shown in item tooltips."] = "Si está seleccionado, el precio de venta se mostrará en el tooltip del objeto."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Si está seleccionado, los botones de acercar alejar estarán ocultos. Puede usar la rueda del ratón para acercar independientemente de esta configuración."
L["If checked, train sounds will be muted."] = "Si está seleccionado, los sonidos del tren se silenciarán."
L["If checked, unit targets will be shown."] = "Si está seleccionado, se mostrarán los objetivos de la unidad."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Si está seleccionado, puede mantener presionada la tecla de control y hacer clic en una pestaña de chat para ver el chat reciente en una ventana fácil de copiar."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Si está seleccionado, puede presionar las teclas de flecha para mover el punto de inserción hacia la izquierda y hacia la derecha en el marco del chat.|n|nSi no está marcado, las teclas de flecha utilizarán la configuración predeterminada del teclado."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Si está seleccionado, podrá cancelar cinemáticas sin que se le solicite confirmación."
L["If checked, you will be able to change the font size of book text."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de libro."
L["If checked, you will be able to change the font size of quest text."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de misión."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de correo.|n|nEsto no afecta el correo creado con plantillas (como las facturas de la casa de subastas)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Si está seleccionado, podrá cambiar la posición y la escala del marco de los bufos."
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "Si está marcado, podrá cambiar la posición y la escala del marco del artilugio.|n|nEl marco del artilugio se usa comúnmente para mostrar las puntuaciones JcJ y los objetivos de seguimiento."
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Si está seleccionado, podrá crear una ventana de vista. Una ventana de vista agrega bordes negros ajustables alrededor del mundo del juego.|n|nLos bordes se colocan en la parte superior del mundo del juego pero debajo de la interfaz de usuario para que pueda colocar elementos de la interfaz de usuario sobre ellos."
L["If checked, you will be able to customise the minimap."] = "Si está seleccionado, podrá personalizar el minimapa."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Si está seleccionado, podrá arrastrar el marco del chat al borde de la pantalla."
L["If checked, you will be able to mute a selection of game sounds."] = "Si está seleccionado, podrá silenciar una selección de sonidos del juego."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Si está seleccionado, podrá colocar hasta cinco iconos de reutilización sobre el marco del objetivo."
L["If checked, you will be able to reposition the tooltip."] = "Si está seleccionado, podrá reposicionar el tooltip."
L["If checked, you will be able to set the density of weather effects."] = "Si está seleccionado, podrá establecer la densidad de los efectos entornos."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Si está seleccionado, podrá mostrar una cadena de élite rara, élite o rara alrededor del marco del jugador."
L["If checked, you will be able to zoom out to a greater distance."] = "Si está seleccionado, podrá alejarse a una distancia mayor."
L["If checked, you will no longer need to type delete when destroying a superior quality item.|n|nIn addition, item links will be shown in all item destroy confirmation windows."] = "Si está marcado, ya no necesitará escribir eliminar al destruir un objeto de calidad superior.|n|nAdemás, los enlaces de objetos se mostrarán en todas las ventanas de confirmación de eliminación de objetos."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Si está seleccionado, liberarás automáticamente después de morir en un campo de batalla.|n|nNo lo liberarás automáticamente si tienes la capacidad de resucitarte a ti mismo."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Si está seleccionado, su historial de chat aumentará a 4096 líneas. Si no está marcado, se usará el valor predeterminado (128 líneas).|n|nHabilitar esta opción puede evitar que se muestre texto de chat durante el inicio de sesión."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si está seleccionado, su equipo se reparará automáticamente cuando visite a un mercader adecuado.|n|nPuede mantener presionada la tecla shift cuando hable con un mercader para anular esta configuración."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Si está seleccionado, el texto de la zona no se mostrará (por ejemplo, 'Forjaz')."
L["Increase chat history"] = "Aumentar el historial"
L["Interface"] = "Interfaz"
L["Invaders of Alterac Valley"] = "Invasores del Valle de Alterac"
L["Invalid console variable."] = "Consola variable inválida."
L["Invalid parameter."] = "Parámetro inválido"
L["Invalid quest ID."] = "ID de misión inválida"
L["Invalid sound ID"] = "ID de sonido inválida"
L["Invalid taint level."] = "Nivel de contaminación inválido."
L["Invalid target."] = "Objetivo inválido"
L["Invite from whispers"] = "Invitación de susurros"
L["Ironforge"] = "Forjaz"
L["Kalimdor"] = "Kalimdor"
L["Karazhan"] = "Karazhan"
L["Keyword"] = "Palabra clave"
L["Lakeshire"] = "Villa del Lago"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus no sobrescribirá LeaPlusDB en el próximo cierre de sesión."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Left"] = "Izquierdo"
L["Lifetime honorable kills"] = "Muertes con honor de vida"
L["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Bloquear compartiendo"
L["Low"] = "Bajo"
L["Magic"] = "Magia"
L["Magisters' Terrace"] = "Bancal del Magister"
L["Main Titles"] = "Títulos principales"
L["Manage buffs"] = "Gestionar bufos"
L["Manage focus"] = "Gestionar enfoque"
L["Manage frames"] = "Gestionar marcos"
L["Manage widget"] = "Gestionar artilugio"
L["Managed by Leatrix Plus"] = "Gestionado por LeatrixPlus"
L["Map"] = "Mapa"
L["Maraudon"] = "Maraudon"
L["Marks of Kil'jaeden"] = "Marcas de Kil'jaeden"
L["Marks of Sargeras"] = "Marcas de Sargeras"
L["Marshal's Refuge"] = "Refugio de Marshal"
L["Max camera zoom"] = "Distancia máxima de cámara"
L["Mechanics"] = "Mecánicas"
L["Media"] = "Media"
L["Medium"] = "Medio"
L["Memory Usage"] = "Uso de Memoria"
L["Menethil Harbor"] = "Puerto de Menethil"
L["message shown."] = "mensaje mostrado."
L["Messages"] = "Mensajes"
L["messages shown."] = "mensajes mostrados."
L["Missing console variable."] = "Falta variable de consola"
L["Missing mount name."] = "Falta nombre de montura"
L["Missing movie ID."] = "Falta ID de película"
L["Missing quest ID."] = "Falta ID de hechizo"
L["Missing sound file parameter."] = "Falta el parámetro del archivo de sonido."
L["Missing sound ID."] = "Falta ID de sonido."
L["Molten Core"] = "Núcleo de Magma"
L["Moonglade"] = "Claro de la Luna"
L["More Firewing Signets"] = "Más sellos Ala de Fuego"
L["More Marks of Kil'jaeden"] = "Más marcas de Kil'jaeden"
L["More Marks of Sargeras"] = "Más marcas de Sargeras"
L["More Sunfury Signets"] = "Más sellos Furia del Sol"
L["Morgan's Vigil"] = "Vigilia de Morgan"
L["Mount not found."] = "No se busca montura."
L["Move editbox to top"] = "Cuadro de edición"
L["Movie not playable."] = "Película no jugable."
L["Movie number"] = "Número de la película"
L["Movies"] = "Películas"
L["Mulgore"] = "Mulgore"
L["Music"] = "Música"
L["Musical Moments"] = "Momentos musicales"
L["Mute game sounds"] = "Silenciar los sonidos del juego"
L["Mystery"] = "Misterio"
L["Nagrand"] = "Nangrand"
L["Narration"] = "Narración"
L["Naxxramas"] = "Naxxramas"
L["Nethergarde Keep"] = "Castillo de Nethergarde"
L["Netherstorm"] = "Tormenta Abisal"
L["Nijel's Point"] = "Punta de Nijel"
L["No bad sound IDs found."] = "No se encontraron ID de sonido inválidos."
L["No help is available for this page."] = "No hay ayuda disponible para esta página."
L["No items with durability equipped."] = "No hay objetos con durabilidad equipados."
L["No media duplicates found."] = "No se encontraron duplicados de medios."
L["No tooltip showing."] = "No se muestra tooltip."
L["None"] = "Ninguno"
L["Not completed."] = "No completado."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "¡AVISO!|nDebe reiniciar completamente su cliente de juego antes de poder usar esta versión de Leatrix Plus."
L["Nude"] = "Nudo"
L["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["or click the minimap button to open Leatrix Plus."] = "o haga clic el botón minimapa para abrir Leatrix Plus."
L["Orgrimmar"] = "Orgrimmar"
L["Outland"] = "Terrallende"
L["Overall"] = "Todo"
L["Overlay"] = "Superposición"
L["Particle density"] = "Densidad de particula"
L["Party from friends"] = "Grupo de amigos"
L["Pet"] = "Mascota"
L["Player"] = "Jugador"
L["Power"] = "Poder"
L["Press CTRL/C to copy."] = "Pulsa Ctrl C para copiar."
L["Queue from friends"] = "Cola de amigos"
L["R"] = "B"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Raid frame toggle"] = "Marco de banda"
L["Random"] = "Aleatorio"
L["RARE"] = "RARO"
L["RARE ELITE"] = "ÉLITE RARO"
L["Ratchet"] = "Trinquete"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Recent chat window"] = "Chat reciente"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Refuge Pointe"] = "Refugio de la Zaga"
L["Release in PvP"] = "Liberar espíritu en JcJ"
L["Reload"] = "Recargar"
L["Remember Alterac Valley!"] = "¡Recuerda el Valle de Alterac!"
L["Repair automatically"] = "Reparar"
L["Repaired for"] = "Reparado por"
L["Reposition the tooltip"] = "Reposicionar el tooltip"
L["Requires UI reload."] = "Requiere recargar la IU."
L["Reset"] = "Restablecer"
L["Resize book text"] = "Texto de libro"
L["Resize mail text"] = "Texto de correo"
L["Resize quest text"] = "Texto de misión"
L["Resize Screen"] = "Redimensionar pantalla"
L["Rested bubbles"] = "Burbujas descansadas"
L["result"] = "resultado"
L["results"] = "resultados"
L["Revantusk Village"] = "Poblado Sañadiente"
L["Right"] = "Derecho"
L["Right-click to close"] = "Haga clic derecho para cerrar"
L["Right-click to close."] = "Haga clic derecho para cerrar."
L["right-click to go back"] = "haga clic derecho para volver"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Rut'theran Village"] = "Aldea Rut'theran"
L["Sacred"] = "Sagrado"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "Las monedas Furiarena, Machacacráneos y Sangrapellejo"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Search"] = "Buscar"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Select the settings that you want to use."] = "Selecciona la configuración que desea usar."
L["Selection of music tracks"] = "Selección de pistas de música"
L["Self Markers Allowed"] = "Auto marcadores permitidos"
L["Self Markers Blocked"] = "Auto marcadores bloqueados"
L["Sell junk automatically"] = "Vender objetos pobres"
L["SELLING JUNK"] = "Vendiendo objetos pobres"
L["Sentinel Hill"] = "Colina del Centinela"
L["Set weather density"] = "Densidad del entorno"
L["Settings"] = "Configuración"
L["Shaders"] = "Sombreadores"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowmoon Valley"] = "Valle Sombraluna"
L["Shadowprey Village"] = "Aldea Cazasombras"
L["Shardtooth E'ko"] = "E'ko Dentoesquirla"
L["Show auction controls"] = "Subasta"
L["Show bag search box"] = "Búsqueda de bolsas"
L["Show character addons"] = "Addons del personaje"
L["Show cooldowns"] = "Reutilización"
L["Show cooldowns above the player frame"] = "Mostrar tiempos de reutilización sobre el marco del jugador"
L["Show durability status"] = "Durabilidad"
L["Show free bag slots"] = "Casillas de bolsas vacías"
L["Show guild names"] = "Mostrar nombres de hermandad"
L["Show guild ranks for your guild"] = "Mostrar rangos de hermandad para tu hermandad"
L["Show minimap button"] = "Botón del minimapa"
L["Show player chain"] = "Cadena de jugador"
L["Show player frame in class color"] = "Mostrar marco de jugador en color de clase"
L["Show raid button"] = "Mostrar botón de banda"
L["Show the spell ID in buff icon tooltips"] = "Mostrar ID de hechizo en tooltips del icono de buff"
L["Show unit targets"] = "Mostrar objetivos de unidad"
L["Show vanity controls"] = "Vanidad"
L["Show vendor price"] = "Precio de venta"
L["Show volume slider"] = "Volumen"
L["Show Wowhead links"] = "Enlaces de Wowhead"
L["Silence rested emotes"] = "Emociones de descanso"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Single Mark of Sargeras"] = "Marca de Sargeras única"
L["Single Sunfury Signet"] = "Sello Furia del Sol único"
L["Social"] = "Social"
L["Sold junk for"] = "Objetos pobres vendido por"
L["Sound system restarted."] = "Sistema de sonido reiniciado."
L["Southshore"] = "Costasur"
L["Spell ID"] = "ID de hechizo"
L["Splintertree Post"] = "Puesto del Hachazo"
L["Spooky"] = "Escalofriante"
L["Stockade"] = "Las Mazmorras"
L["Stonard"] = "Rocal"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stonetalon Peak"] = "Cima del Espolón"
L["Stop"] = "Parar"
L["Stormwind"] = "Ventormenta"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme"] = "Stratholme"
L["Sun Rock Retreat"] = "Refugio Roca del Sol"
L["Sunfury Signets"] = "Sellos Furia del Sol"
L["Sunken Temple"] = "Templo Sumergido"
L["Sunwell Plateau"] = "Meseta de la Fuente del Sol"
L["Support"] = "Soporte"
L["Swamp"] = "Pantano"
L["Swamp of Sorrows"] = "Pantano de las Penas"
L["System"] = "Sistema"
L["Tabard"] = "Tabardo"
L["Taint level: Basic (1)."] = "Nivel de contaminación: básico (1)."
L["Taint level: Disabled (0)."] = "Nivel de contaminación: deshabilitado (0)."
L["Taint level: Full (2)."] = "Nivel de contaminación: lleno (2)."
L["Talonbranch Glade"] = "Claro Ramaespolón"
L["Talrendis Point"] = "Punta Talrendis"
L["Tanaris"] = "Tanaris"
L["Target"] = "Objetivo"
L["Target Tracking Disabled"] = "Rastreo de objetivo se ha deshabilitado"
L["Target Tracking Enabled"] = "Rastreo de objetivo se ha habilitado"
L["Tarren Mill"] = "Molino Tarren"
L["Teldrassil"] = "Teldrassil"
L["Tempest Keep"] = "El Castillo de la Tempestad"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Ten Years of Warcraft"] = "Diez años de Warcraft"
L["Terokkar Forest"] = "Bosque de Terrokar"
L["Text"] = "Texto"
L["Text size"] = "Tamaño de texto"
L["Text Size"] = "Tamaño de texto"
L["The Sepulcher"] = "El Sepulcro"
L["The summon from"] = "La invocación de"
L["Themes"] = "Temas"
L["This panel will close automatically if you enter combat."] = "Este panel se cerrará automáticamente si entras en combate."
L["Thorium Point"] = "Puesto del Torio"
L["Thousand Needles"] = "Las Mil Agujas"
L["Thunder Bluff"] = "Cima del Trueno"
L["Timer"] = "Temporizador"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["To begin, choose an options page."] = "Para comenzar, elija una pestaña de opciones."
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "Para ocultar el registro de combate, debes deshabilitar el módulo de chat en ElvUI."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Para usar el botón Buscar objeto, debe anular la selección de la categoría Token de WoW."
L["Tooltip"] = "Tooltip"
L["Tooltip title color"] = "Color de título del tooltip"
L["Top"] = "Superior"
L["Top Center"] = "Central Superior"
L["Tracing started."] = "El seguimiento comenzó."
L["Tracing stopped."] = "El seguimiento se detuvo."
L["Transparency"] = "Transparencia"
L["True"] = "Cierto"
L["Turn-in completed quests automatically"] = "Entregar misiones completadas automáticamente"
L["Uldaman"] = "Uldaman"
L["Unclamp chat frame"] = "Desbloquear el marco"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Universal group color"] = "Color de grupo universal"
L["Use arrow keys in chat"] = "Teclas de flecha"
L["Use class colors in chat"] = "Colores de clase"
L["Use easy resizing"] = "Cambio de tamaño"
L["Value must be a number."] = "Valor debe ser un número."
L["Various"] = "Varios"
L["Vendors"] = "Vendedores"
L["Version"] = "Versión"
L["Very Low"] = "Muy Bajo"
L["Video"] = "Vídeo"
L["Visibility"] = "Visibilidad"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["was automatically declined."] = "fue rechazado automáticamente."
L["Weather density"] = "Densidad del entorno"
L["Welcome to Leatrix Plus."] = "Bienvenido a Leatrix Plus"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Wetlands"] = "Los Humedales"
L["Widget"] = "Artilugio"
L["Wildkin E'ko"] = "E'ko de lechúcico salvaje"
L["will be automatically accepted in 10 seconds unless cancelled."] = "será aceptado automáticamente en 10 segundos a menos que se cancele."
L["Winter"] = "Invierno"
L["Winterfall E'ko"] = "E'ko Nevada"
L["Winterspring"] = "Cuna del Invierno"
L["World of Warcraft"] = "World of Warcraft"
L["X Offset"] = "Compensación X"
L["Y Offset"] = "Compensación Y"
L["YOU"] = "Tú"
L["You cannot do that in combat."] = "No puedes hacerlo mientras estés en combate."
L["You have"] = "Tienes"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su IU necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga de inmediato, pero debe hacer clic en él cuando haya terminado de hacer cambios y desea que los cambios surtan efecto."
L["Your UI needs to be reloaded."] = "Tiene que recargar la IU."
L["Zangarmarsh"] = "Zangarmarsh"
L["Zones"] = "Zonas"
L["Zoram'gar Outpost"] = "Avanzada de Zoram'gar"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zulian, Razzashi, and Hakkari Coins"] = "Las monedas Zulian, Razzashi y Hakkari"
L["Zygor addon not found."] = "No se encuentra el addon Zygor."

end

-- esES: European Spanish
if GameLocale == "esES" then
L["+"] = "+"
L["A Donation of Mageweave"] = "Un donativo de tejido mágico"
L["A Donation of Runecloth"] = "Un donativo de paño rúnico"
L["A Donation of Silk"] = "Un donativo de seda"
L["A Donation of Wool"] = "Un donativo de lana"
L["A friend request from"] = "Una solicitud de amistad de"
L["Accept available quests automatically"] = "Aceptar misiones disponibles automáticamente"
L["Accept resurrection"] = "Aceptar resucitación"
L["Accept summon"] = "Aceptar invocación"
L["Additional Runecloth"] = "Un donativo extra de paño rúnico"
L["Addon"] = "Addon"
L["Aerie Peak"] = "Pico Nidal"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alterac Mountains"] = "Montañas de Alterac"
L["Anchor"] = "Anclar"
L["Angelic"] = "Angélico"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Ashenvale"] = "Vallefresno"
L["Auto loot is now enabled."] = "Despojar automáticamente se ha habilitado."
L["AutoFollow"] = "Seguir automáticamente"
L["AutoFollow disabled."] = "Seguir automáticamente se ha deshabilitado"
L["Automate gossip"] = "Automatizar diálogo"
L["Automate quests"] = "Automatizar misiones"
L["Automation"] = "Automatizar"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Isla Bruma Azur"
L["Back to Main Menu"] = "Volver a menú principal"
L["Bad ID"] = "ID inválida"
L["Badlands"] = "Tierras Inhóspitas"
L["Barrens"] = "Los Baldíos"
L["Battle"] = "Batalla"
L["Battle of Warsong Gulch"] = "La batalla por Garganta Grito de Guerra"
L["Battlegrounds"] = "Campos de Batalla"
L["Black Morass"] = "La Ciénaga Negra"
L["Black Temple"] = "Templo Oscuro"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackwing Lair"] = "Guarida de Alanegra"
L["Blade's Edge Mountains"] = "Montañas Filospada"
L["Blasted Lands"] = "Las Tierras Devastadas"
L["Block duels"] = "Duelos"
L["Block friend requests"] = "Solicitudes de amistad"
L["Block party invites"] = "Invitaciones de grupo"
L["Blocks"] = "Rechazar"
L["Bloodmyst Isle"] = "Isla Bruma de Sangre"
L["Booty Bay"] = "Bahía del Botín"
L["Bottom"] = "Inferior"
L["Brackenwall Village"] = "Poblado Murohelecho"
L["Buffs"] = "Buffs"
L["Burning Crusade"] = "Burning Crusade"
L["Burning Crusade Classic"] = "Burning Crusade Clásico"
L["Burning Steppes"] = "Las Estepas Ardientes"
L["Buyout Only"] = "Sola compra"
L["by Leatrix Plus"] = "por Leatrix Plus"
L["C"] = "C"
L["Camera distance"] = "Distancia de cámara"
L["Camp Mojache"] = "Campamento Mojache"
L["Camp Taurajo"] = "Campamento Taurajo"
L["Cannot announce in this zone."] = "No se puede anunciar en esta zona."
L["Cannot find General chat channel."] = "No se puede encontrar el canal de chat general."
L["Cenarion Hold"] = "Fuerte Cenarion"
L["Chain style"] = "Estilo de cadena"
L["Character"] = "Personaje"
L["Chat"] = "Chat"
L["Chat Frame"] = "Marco de chat"
L["Checkbox labels are Ok."] = "Las etiquetas de las casillas de verificación están bien."
L["Chillwind Camp"] = "Campamento del Orvallo"
L["Chillwind E'ko"] = "E'ko Orvallo"
L["Cinematics"] = "Cinemáticas"
L["Claiming Arathi Basin"] = "Reclamo por la Cuenca de Arathi"
L["Class colored frames"] = "Marcos coloreados"
L["Class icon portraits"] = "Retratos de clase"
L["Classic"] = "Clásico"
L["click here for new selection"] = "haga clic para nueva selección"
L["Click to configure the settings for this option."] = "Haga clic para configurar la configuración para esta opción"
L["Click to reset the settings on this page."] = "Haga clic para restablecer la configuración en esta página"
L["Click to resize the screen to fit between the top and bottom borders."] = "Haga clic para cambiar el tamaño de la pantalla para que se ajuste entre los bordes superior e inferior."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal"
L["Cloak"] = "Espalda"
L["Coilfang Reservoir"] = "Reserva de Colmillo Torcido"
L["Combat log cannot be hidden while undocked."] = "El registro de combate no se puede ocultar mientras está desacoplado."
L["Combat plates"] = "Placas de combate"
L["Completed."] = "Completado."
L["Concerted Efforts"] = "Esfuerzos concertados"
L["Configuration Panel"] = "Panel de Configuración"
L["Connections for"] = "Conexiones de"
L["Conquering Arathi Basin"] = "La conquista de la Cuenca de Arathi"
L["Credits"] = "Créditos"
L["Crossroads"] = "El Cruce"
L["Cursor"] = "Cursor"
L["Cursor Left"] = "Cursor izquierdo"
L["Cursor Right"] = "Cursor derecho"
L["D"] = "C"
L["Darkmoon Faire"] = "Feria de la Luna Negra"
L["Darkshire"] = "Villa Oscura"
L["Darkshore"] = "Costa Oscura"
L["Deadmines"] = "Minas de la Muerte"
L["Deadwind Pass"] = "Paso de la Muerte"
L["Desolace"] = "Desolace"
L["Dire Maul"] = "La Masacre"
L["Disable bag automation"] = "Bolsas"
L["Disable chat fade"] = "Desvanecimiento"
L["Disable loot warnings"] = "Advertencias del botín"
L["Disable screen effects"] = "Efectos de pantalla"
L["Disable screen glow"] = "Brillo de pantalla"
L["Disable sticky chat"] = "Chat pegajoso"
L["Drag the frame overlay to position the frame."] = "Arrastra la superposición del marco para colocar el marco."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Arrastra la superposición de los marco para colocar los marcos.|n|nPara cambiar la escala de un marco, haga clic para seleccionarlo y luego ajuste el control deslizante de escala.|n|nEste panel se cerrará automáticamente si entras en combate."
L["Drag to set the buffs frame scale."] = "Arrastra para establecer la escala del marco de los bufos."
L["Drag to set the cursor X offset."] = "Arrastra para establecer el desplazamiento del cursor X."
L["Drag to set the cursor Y offset."] = "Arrastra para establecer el desplazamiento del cursor Y."
L["Drag to set the density of weather effects."] = "Arrastra para establecer la densidad de los efectos entornos."
L["Drag to set the font size of book text."] = "Arrastra para establecer el tamaño de fuente del texto de libro."
L["Drag to set the font size of mail text."] = "Arrastra para establecer el tamaño de fuente del texto de correo."
L["Drag to set the font size of quest text."] = "Arrastra para establecer el tamaño de fuente del texto de misión."
L["Drag to set the scale of the Leatrix Plus panel."] = "Arrastra para establecer la escala del panel Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Arrastra para establecer la escala del marco seleccionado."
L["Drag to set the size of the bottom border."] = "Arrastra para establecer el tamaño del borde inferior."
L["Drag to set the size of the left border."] = "Arrastra para establecer el tamaño del borde izquierdo."
L["Drag to set the size of the right border."] = "Arrastra para establecer el tamaño del borde derecho."
L["Drag to set the size of the top border."] = "Arrastra para establecer el tamaño del borde superior."
L["Drag to set the tooltip scale."] = "Arrastra para establecer la escala del tooltip."
L["Drag to set the transparency of the borders."] = "Arrastra para establecer la transparencia de los bordes."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Arrastra para establecer la transparencia del panel Leatrix Plus."
L["Drag to size"] = "Arrastra para ajustar el tamaño"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeons"] = "Calabozos"
L["Dup ID"] = "ID Copia"
L["durability"] = "durabilidad"
L["Durability"] = "Durabilidad"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Eastern Kingdoms"] = "Reinos del Este"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["Easy item destroy"] = "Fácil eliminación de objetos"
L["ELITE"] = "ÉLITE"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Enable viewport"] = "Vista de ventana"
L["Enhance dressup"] = "Probador"
L["Enhance minimap"] = "Minimapa"
L["Enhance professions"] = "Profesiones"
L["Enhance quest log"] = "Registro de misiones"
L["Enhance tooltip"] = "Tooltip"
L["Enhance trainers"] = "Instructores"
L["Enhancements"] = "Mejoras"
L["Enter"] = "Entrar"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Entra la ID de hechizo para los iconos de reutilización que desea ver.|n|nSi normalmente aparece un icono de reutilización debajo del marco de la mascota, marca la casilla de verificación mascota.|n|Los iconos de reutilización se guardan en tu clase."
L["enter zone or track name"] = "entra zona o rastrea el nombre"
L["Error messages will be hidden"] = "Mensajes de error se ocultarán"
L["Error messages will be shown"] = "Mensajes de error se mostrarán"
L["Events"] = "Eventos"
L["Everlook"] = "Vista Eterna"
L["Eversong Woods"] = "Bosque Cancion Eterna"
L["Extras"] = "Excesos"
L["False"] = "Falso"
L["Faster auto loot"] = "Despojar rápido"
L["Faster movie skip"] = "Saltar película rápido"
L["Feathermoon"] = "Plumaluna"
L["Features"] = "Caracteristicas"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Fight for Warsong Gulch"] = "Lucha por Garganta Grito de Guerra"
L["Find Item"] = "Buscar objeto"
L["Firewing Signets"] = "Sellos Ala de Fuego"
L["Flame Crest"] = "Peñasco Llamarada"
L["For Great Honor"] = "Cuestión de honor"
L["Frames"] = "Marcos"
L["Freewind Post"] = "Poblado Viento Libre"
L["Frostmaul E'ko"] = "E'ko de los Machacahielo"
L["Frostsaber E'ko"] = "E'ko de sable de hielo"
L["Game Options"] = "Opciones de juego"
L["Ghost"] = "Fantasma"
L["Ghostlands"] = "Tierras Fantasmas"
L["Gloomy"] = "Melancólico"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Solo oro"
L["Graphics and Sound"] = "Gráficos y sonido"
L["Groups"] = "Grupos"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "Las monedas Gurubashi, Vilrama y Secacorteza"
L["H"] = "H"
L["Hammerfall"] = "Sentencia"
L["Haunted"] = "Encantado"
L["Hellfire Peninsula"] = "Península del Fuego Infernal"
L["Hellfire Ramparts"] = "Murallas del Fuego Infernal"
L["Helm"] = "Cabeza"
L["Help"] = "Ayuda"
L["Hide chat buttons"] = "Botones de chat"
L["Hide cooldown duration numbers (if enabled)"] = "Ocultar números de reutilización (si habilitado)"
L["Hide error messages"] = "Mensajes de error"
L["Hide gryphons"] = "Grifos"
L["Hide portrait numbers"] = "Números del retrato"
L["Hide stance bar"] = "Barra de actitud"
L["Hide the combat log"] = "Registro de combate"
L["Hide the zone text bar"] = "Ocultar texto de zona"
L["Hide the zoom buttons"] = "Ocultar los botones de acercar/alejar"
L["Hide tooltips for world units during combat"] = "Ocultar tooltips para unidades del mundo si estés en combate"
L["Hide zone text"] = "Texto de zona"
L["High"] = "Alto"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Hinterlands"] = "Tierras del Interior"
L["Home"] = "Principal"
L["Hyjal Summit"] = "La Cima Hyjal"
L["Ice Thistle E'ko"] = "E'ko de los Cardo Nevado"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Si está seleccionado, se mostrará un cuadro de búsqueda de bolsas en el marco de la mochila y el marco del banco."
L["If checked, a button will be added to the character frame which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Si está seleccionado, se agregará un botón a la información del personaje que mostrará la durabilidad de su equipo cuando pase el puntero sobre él.|n|nAdemás, se mostrará un porcentaje general en el marco del chat cuando muera."
L["If checked, a master volume slider will be shown in the character frame."] = "Si está seleccionado, se mostrará un control deslizante de volumen maestro en la información del personaje."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "Si está seleccionado, se agregará funcionalidad adicional a la casa de subastas.|n|nSolo compra: cree subastas de compra sin completar el precio inicial.|n|nSolo oro: establezca los precios del cobre y la plata en 99 para acelerar las nuevas subastas.|n|nBuscar objeto: busca en la casa de subastas el objeto que estás vendiendo.|n|nAdemás, la configuración de duración de la subasta se guardará en toda la cuenta."
L["If checked, alert frames will not be shown."] = "Si está seleccionado, no se mostrarán los marcos de alerta."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si está seleccionado, todos los objetos de calidad pobre en sus bolsas se venderán automáticamente cuando visite a un mercader.|n|nPuede mantener presionada la tecla shift cuando hable con un mercader para anular esta configuración."
L["If checked, available quests will be accepted automatically."] = "Si está seleccionado, las misiones disponibles se aceptarán automáticamente."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Si está seleccionado, los fondos se teñirán de azul (amigable) o rojo (hostil)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Si está seleccionado, las solicitudes de amistad de BattleTag y Real ID se rechazarán automáticamente.|n|nHabilitar esta opción rechazará automáticamente cualquier solicitud pendiente."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Si está seleccionado, los botones del marco de chat estarán ocultos.|n|nAl hacer clic en las pestañas de chat, se mostrarán automáticamente los últimos mensajes.|n|nUsa la rueda del ratón para desplazarse por el historial de chat. Mantenga presionada la tecla shift para saltar de página o Ctrl para saltar a la parte superior o inferior del historial de chat."
L["If checked, chat text will not fade out after a time period."] = "Si está seleccionado, el texto del chat no se desvanecerá después de un período de tiempo."
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "Si está marcada, se utilizará el color de la clase en el marco del jugador, en el marco del objetivo y en el marco de enfoque."
L["If checked, class colors will be used in the chat frame."] = "Si está seleccionado, los colores de la clase se usarán en el marco del chat."
L["If checked, completed quests will be turned-in automatically."] = "Si está seleccionado, las misiones completadas se entregarán automáticamente."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Si está seleccionado, las confirmaciones ya no aparecerán cuando elija una opción de botín o cuando intente vender o enviar un objeto comercializable."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Si está seleccionado, los números de reutilización no se mostrarán sobre el hechizo.|n|nSi no está marcado, los números de reutilización se mostrarán sobre el hechizo si están habilitados en el panel de opciones del juego (menú 'Barras de Acción')."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Si está seleccionado, se ocultarán los números de daño y sanación en los marcos de retrato de jugador y mascota."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Si está seleccionado, arrastrando la pestaña de chat General mientras el marco de chat está bloqueado expandirá el marco de chat hacia arriba.|n|nSi el marco de chat está desbloqueado, arrastrando la pestaña de chat General se moverá el marco de chat."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Si está seleccionado, los sonidos de emoción se silenciarán mientras tu personaje esté descansando o en El Tragapenas.|n|nLos sonidos de emoción se habilitarán en cualquier otro momento."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Si está seleccionado, las placas identificativas del enemigo se mostrarán durante el combate y se ocultarán cuando finalice el combate."
L["If checked, guild ranks will be shown for players in your guild."] = "Si está seleccionado, los rangos de la hermandad se mostrarán para los jugadores de tu hermandad."
L["If checked, helm and cloak toggle checkboxes will be shown in the character frame.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Si está seleccionado, las casillas de alternar cabeza y espalda se mostrarán en la información del personaje.|n|nPuede mantener presionada la tecla shift y hacer clic con el botón derecho en las casillas de verificación para cambiar de visualización."
L["If checked, holiday event sounds will be muted.|n|nThis applies to Headless Horseman."] = "Si se marca, los sonidos de los eventos festivos se silenciarán.|n|nEsto se aplica a Jinete decapitado."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Si está seleccionado, el chat de banda y el chat de instancia serán de color azul (para que coincida con el color predeterminado del chat del grupo)."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Si está seleccionado, la ID de hechizo se mostrarán en el tooltip del icono de buff ubicado en el marco de buff y debajo del marco de objetivo."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Si está seleccionado, el chat pegajoso se deshabilitará.|n|nTenga en cuenta que esto no se aplica a las ventanas de chat temporales."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Si está seleccionado, las solicitudes de invocación serán aceptadas automáticamente a menos que estés en combate."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Si está seleccionado, la lista de addons (accesible desde el menú del juego) mostrará addons basados en personajes de forma predeterminada."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Si está seleccionado, el tiempo que se tarda en despojar automáticamente a las criaturas se reducirá significativamente."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Si está seleccionado, el botón de limpieza de la mochila y el botón de limpieza del marco del banco no se mostrarán."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Si está seleccionado, el botón para alternar el marco del contenedor de banda se mostrará justo encima del marco de administración de banda (lado izquierdo de la pantalla) en lugar de en el marco de administración de banda en sí.|n|nEsto le permite alternar el marco del contenedor de banda sin necesidad de abrir el marco de administración de banda."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Si está seleccionado, el registro de combate estará oculto.|n|nEl registro de combate debe estar acoplado para que esta opción funcione.|n|nSi el registro de combate está desacoplado, puedes acoplarlo arrastrando la pestaña (y recargando tu IU) o restableciendo las ventanas de chat (desde el menú de chat)."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Si está seleccionado, el cuadro de edición se moverá a la parte superior del marco de chat."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Si está seleccionado, la pantalla gris de la muerte y el efecto del inframundo se deshabilitarán."
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "Si está seleccionado, el sonido del botón de la interfaz, el sonido del clic de la pestaña del marco del chat y el sonido de alternancia del menú del juego se silenciarán."
L["If checked, the main bar gryphons will not be shown."] = "Si está seleccionado, no se mostrarán los grifos de la barra principal."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Si está seleccionado, la cantidad de casillas para bolsas disponibles se mostrará en el icono del botón de la mochila y en el tooltip."
L["If checked, the player frame background will be shown in class color."] = "Si está seleccionado, el fondo del marco del jugador se mostrará en color de clase."
L["If checked, the professions frame will be larger."] = "Si está seleccionado, el marco de profesiones será más grande."
L["If checked, the ready check sound will be muted."] = "Si está seleccionado, el sonido de comprobación de listo se silenciará."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Si está seleccionado, el brillo de la pantalla se deshabilitará.|n|nHabilitar esta opción también deshabilitará el efecto de borracho."
L["If checked, the spell fizzle sounds will be muted."] = "Si está seleccionado, los sonidos del hechizo fizzle serán silenciados."
L["If checked, the stance bar will not be shown."] = "Si está seleccionado, la barra de actitud no mostrará."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Si está seleccionado, el marco de conversación no se mostrará.|n|nEl marco de conversación normalmente aparece en la parte inferior de la pantalla cuando ciertos PNJs se comunican con usted."
L["If checked, the target frame background will be shown in class color."] = "Si está seleccionado, el fondo del marco de objetivo se mostrará en color de clase."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Si está seleccionado, el tooltip estará codificada por colores y podrá modificar la visualización y la escala del tooltip."
L["If checked, the vendor price will be shown in item tooltips."] = "Si está seleccionado, el precio de venta se mostrará en el tooltip del objeto."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Si está seleccionado, los botones de acercar/alejar estarán ocultos. Puede usar la rueda del ratón para acercar independientemente de esta configuración."
L["If checked, train sounds will be muted."] = "Si está seleccionado, los sonidos del tren se silenciarán."
L["If checked, unit targets will be shown."] = "Si está seleccionado, se mostrarán los objetivos de la unidad."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Si está seleccionado, puede mantener presionada la tecla de control y hacer clic en una pestaña de chat para ver el chat reciente en una ventana fácil de copiar."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Si está seleccionado, puede presionar las teclas de flecha para mover el punto de inserción hacia la izquierda y hacia la derecha en el marco del chat.|n|nSi no está marcado, las teclas de flecha utilizarán la configuración predeterminada del teclado."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Si está seleccionado, podrá cancelar cinemáticas sin que se le solicite confirmación."
L["If checked, you will be able to change the font size of book text."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de libro."
L["If checked, you will be able to change the font size of quest text."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de misión."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Si está seleccionado, podrá cambiar el tamaño de fuente del texto de correo.|n|nEsto no afecta el correo creado con plantillas (como las facturas de la casa de subastas)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Si está seleccionado, podrá cambiar la posición y la escala del marco de los bufos."
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "Si está marcado, podrá cambiar la posición y la escala del marco del artilugio.|n|nEl marco del artilugio se usa comúnmente para mostrar las puntuaciones JcJ y los objetivos de seguimiento."
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Si está seleccionado, podrá crear una ventana de vista. Una ventana de vista agrega bordes negros ajustables alrededor del mundo del juego.|n|nLos bordes se colocan en la parte superior del mundo del juego pero debajo de la interfaz de usuario para que pueda colocar elementos de la interfaz de usuario sobre ellos."
L["If checked, you will be able to customise the minimap."] = "Si está seleccionado, podrá personalizar el minimapa."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Si está seleccionado, podrá arrastrar el marco del chat al borde de la pantalla."
L["If checked, you will be able to mute a selection of game sounds."] = "Si está seleccionado, podrá silenciar una selección de sonidos del juego."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Si está seleccionado, podrá colocar hasta cinco iconos de reutilización sobre el marco del objetivo."
L["If checked, you will be able to reposition the tooltip."] = "Si está seleccionado, podrá reposicionar el tooltip."
L["If checked, you will be able to set the density of weather effects."] = "Si está seleccionado, podrá establecer la densidad de los efectos entornos."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Si está seleccionado, podrá mostrar una cadena de élite rara, élite o rara alrededor del marco del jugador."
L["If checked, you will be able to zoom out to a greater distance."] = "Si está seleccionado, podrá alejarse a una distancia mayor."
L["If checked, you will no longer need to type delete when destroying a superior quality item.|n|nIn addition, item links will be shown in all item destroy confirmation windows."] = "Si está marcado, ya no necesitará escribir eliminar al destruir un objeto de calidad superior.|n|nAdemás, los enlaces de objetos se mostrarán en todas las ventanas de confirmación de eliminación de objetos."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Si está seleccionado, liberarás automáticamente después de morir en un campo de batalla.|n|nNo lo liberarás automáticamente si tienes la capacidad de resucitarte a ti mismo."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Si está seleccionado, su historial de chat aumentará a 4096 líneas. Si no está marcado, se usará el valor predeterminado (128 líneas).|n|nHabilitar esta opción puede evitar que se muestre texto de chat durante el inicio de sesión."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si está seleccionado, su equipo se reparará automáticamente cuando visite a un mercader adecuado.|n|nPuede mantener presionada la tecla shift cuando hable con un mercader para anular esta configuración."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Si está seleccionado, el texto de la zona no se mostrará (por ejemplo, 'Forjaz')."
L["Increase chat history"] = "Aumentar el historial"
L["Interface"] = "Interfaz"
L["Invaders of Alterac Valley"] = "Invasores del Valle de Alterac"
L["Invalid console variable."] = "Consola variable inválida."
L["Invalid parameter."] = "Parámetro inválido"
L["Invalid quest ID."] = "ID de misión inválida"
L["Invalid sound ID"] = "ID de sonido inválida"
L["Invalid taint level."] = "Nivel de contaminación inválido."
L["Invalid target."] = "Objetivo inválido"
L["Invite from whispers"] = "Invitación de susurros"
L["Ironforge"] = "Forjaz"
L["Kalimdor"] = "Kalimdor"
L["Karazhan"] = "Karazhan"
L["Keyword"] = "Palabra clave"
L["Lakeshire"] = "Villa del Lago"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus no sobrescribirá LeaPlusDB en el próximo cierre de sesión."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Left"] = "Izquierdo"
L["Lifetime honorable kills"] = "Muertes con honor de vida"
L["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Bloquear compartiendo"
L["Low"] = "Bajo"
L["Magic"] = "Magia"
L["Magisters' Terrace"] = "Bancal del Magister"
L["Main Titles"] = "Títulos principales"
L["Manage buffs"] = "Gestionar bufos"
L["Manage focus"] = "Gestionar enfoque"
L["Manage frames"] = "Gestionar marcos"
L["Manage widget"] = "Gestionar artilugio"
L["Managed by Leatrix Plus"] = "Gestionado por LeatrixPlus"
L["Map"] = "Mapa"
L["Maraudon"] = "Maraudon"
L["Marks of Kil'jaeden"] = "Marcas de Kil'jaeden"
L["Marks of Sargeras"] = "Marcas de Sargeras"
L["Marshal's Refuge"] = "Refugio de Marshal"
L["Max camera zoom"] = "Distancia máxima de cámara"
L["Mechanics"] = "Mecánicas"
L["Media"] = "Media"
L["Medium"] = "Medio"
L["Memory Usage"] = "Uso de Memoria"
L["Menethil Harbor"] = "Puerto de Menethil"
L["message shown."] = "mensaje mostrado."
L["Messages"] = "Mensajes"
L["messages shown."] = "mensajes mostrados."
L["Missing console variable."] = "Falta variable de consola"
L["Missing mount name."] = "Falta nombre de montura"
L["Missing movie ID."] = "Falta ID de película"
L["Missing quest ID."] = "Falta ID de hechizo"
L["Missing sound file parameter."] = "Falta el parámetro del archivo de sonido."
L["Missing sound ID."] = "Falta ID de sonido."
L["Molten Core"] = "Núcleo de Magma"
L["Moonglade"] = "Claro de la Luna"
L["More Firewing Signets"] = "Más sellos Ala de Fuego"
L["More Marks of Kil'jaeden"] = "Más marcas de Kil'jaeden"
L["More Marks of Sargeras"] = "Más marcas de Sargeras"
L["More Sunfury Signets"] = "Más sellos Furia del Sol"
L["Morgan's Vigil"] = "Vigilia de Morgan"
L["Mount not found."] = "No se busca montura."
L["Move editbox to top"] = "Cuadro de edición"
L["Movie not playable."] = "Película no jugable."
L["Movie number"] = "Número de la película"
L["Movies"] = "Películas"
L["Mulgore"] = "Mulgore"
L["Music"] = "Música"
L["Musical Moments"] = "Momentos musicales"
L["Mute game sounds"] = "Silenciar los sonidos del juego"
L["Mystery"] = "Misterio"
L["Nagrand"] = "Nangrand"
L["Narration"] = "Narración"
L["Naxxramas"] = "Naxxramas"
L["Nethergarde Keep"] = "Castillo de Nethergarde"
L["Netherstorm"] = "Tormenta Abisal"
L["Nijel's Point"] = "Punta de Nijel"
L["No bad sound IDs found."] = "No se encontraron ID de sonido inválidos."
L["No help is available for this page."] = "No hay ayuda disponible para esta página."
L["No items with durability equipped."] = "No hay objetos con durabilidad equipados."
L["No media duplicates found."] = "No se encontraron duplicados de medios."
L["No tooltip showing."] = "No se muestra tooltip."
L["None"] = "Ninguno"
L["Not completed."] = "No completado."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "¡AVISO!|nDebe reiniciar completamente su cliente de juego antes de poder usar esta versión de Leatrix Plus."
L["Nude"] = "Nudo"
L["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["or click the minimap button to open Leatrix Plus."] = "o haga clic el botón minimapa para abrir Leatrix Plus."
L["Orgrimmar"] = "Orgrimmar"
L["Outland"] = "Terrallende"
L["Overall"] = "Todo"
L["Overlay"] = "Superposición"
L["Particle density"] = "Densidad de particula"
L["Party from friends"] = "Grupo de amigos"
L["Pet"] = "Mascota"
L["Player"] = "Jugador"
L["Power"] = "Poder"
L["Press CTRL/C to copy."] = "Pulsa Ctrl+C para copiar."
L["Queue from friends"] = "Cola de amigos"
L["R"] = "B"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Raid frame toggle"] = "Marco de banda"
L["Random"] = "Aleatorio"
L["RARE"] = "RARO"
L["RARE ELITE"] = "ÉLITE RARO"
L["Ratchet"] = "Trinquete"
L["Razorfen Downs"] = "Zahúrda Rajacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Recent chat window"] = "Chat reciente"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Refuge Pointe"] = "Refugio de la Zaga"
L["Release in PvP"] = "Liberar espíritu en JcJ"
L["Reload"] = "Recargar"
L["Remember Alterac Valley!"] = "¡Recuerda el Valle de Alterac!"
L["Repair automatically"] = "Reparar"
L["Repaired for"] = "Reparado por"
L["Reposition the tooltip"] = "Reposicionar el tooltip"
L["Requires UI reload."] = "Requiere recargar la IU."
L["Reset"] = "Restablecer"
L["Resize book text"] = "Texto de libro"
L["Resize mail text"] = "Texto de correo"
L["Resize quest text"] = "Texto de misión"
L["Resize Screen"] = "Redimensionar pantalla"
L["Rested bubbles"] = "Burbujas descansadas"
L["result"] = "resultado"
L["results"] = "resultados"
L["Revantusk Village"] = "Poblado Sañadiente"
L["Right"] = "Derecho"
L["Right-click to close"] = "Haga clic derecho para cerrar"
L["Right-click to close."] = "Haga clic derecho para cerrar."
L["right-click to go back"] = "haga clic derecho para volver"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Rut'theran Village"] = "Aldea Rut'theran"
L["Sacred"] = "Sagrado"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "Las monedas Furiarena, Machacacráneos y Sangrapellejo"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Search"] = "Buscar"
L["Searing Gorge"] = "La Garganta de Fuego"
L["Select the settings that you want to use."] = "Selecciona la configuración que desea usar."
L["Selection of music tracks"] = "Selección de pistas de música"
L["Self Markers Allowed"] = "Auto marcadores permitidos"
L["Self Markers Blocked"] = "Auto marcadores bloqueados"
L["Sell junk automatically"] = "Vender objetos pobres"
L["SELLING JUNK"] = "Vendiendo objetos pobres"
L["Sentinel Hill"] = "Colina del Centinela"
L["Set weather density"] = "Densidad del entorno"
L["Settings"] = "Configuración"
L["Shaders"] = "Sombreadores"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowmoon Valley"] = "Valle Sombraluna"
L["Shadowprey Village"] = "Aldea Cazasombras"
L["Shardtooth E'ko"] = "E'ko Dentoesquirla"
L["Show auction controls"] = "Subasta"
L["Show bag search box"] = "Búsqueda de bolsas"
L["Show character addons"] = "Addons del personaje"
L["Show cooldowns"] = "Reutilización"
L["Show cooldowns above the player frame"] = "Mostrar tiempos de reutilización sobre el marco del jugador"
L["Show durability status"] = "Durabilidad"
L["Show free bag slots"] = "Casillas de bolsas vacías"
L["Show guild names"] = "Mostrar nombres de hermandad"
L["Show guild ranks for your guild"] = "Mostrar rangos de hermandad para tu hermandad"
L["Show minimap button"] = "Botón del minimapa"
L["Show player chain"] = "Cadena de jugador"
L["Show player frame in class color"] = "Mostrar marco de jugador en color de clase"
L["Show raid button"] = "Mostrar botón de banda"
L["Show the spell ID in buff icon tooltips"] = "Mostrar ID de hechizo en tooltips del icono de buff"
L["Show unit targets"] = "Mostrar objetivos de unidad"
L["Show vanity controls"] = "Vanidad"
L["Show vendor price"] = "Precio de venta"
L["Show volume slider"] = "Volumen"
L["Show Wowhead links"] = "Enlaces de Wowhead"
L["Silence rested emotes"] = "Emociones de descanso"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Bosque de Argénteos"
L["Single Mark of Sargeras"] = "Marca de Sargeras única"
L["Single Sunfury Signet"] = "Sello Furia del Sol único"
L["Social"] = "Social"
L["Sold junk for"] = "Objetos pobres vendido por"
L["Sound system restarted."] = "Sistema de sonido reiniciado."
L["Southshore"] = "Costasur"
L["Spell ID"] = "ID de hechizo"
L["Splintertree Post"] = "Puesto del Hachazo"
L["Spooky"] = "Escalofriante"
L["Stockade"] = "Las Mazmorras"
L["Stonard"] = "Rocal"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stonetalon Peak"] = "Cima del Espolón"
L["Stop"] = "Parar"
L["Stormwind"] = "Ventormenta"
L["Stranglethorn Vale"] = "Vega de Tuercespina"
L["Stratholme"] = "Stratholme"
L["Sun Rock Retreat"] = "Refugio Roca del Sol"
L["Sunfury Signets"] = "Sellos Furia del Sol"
L["Sunken Temple"] = "Templo Sumergido"
L["Sunwell Plateau"] = "Meseta de la Fuente del Sol"
L["Support"] = "Soporte"
L["Swamp"] = "Pantano"
L["Swamp of Sorrows"] = "Pantano de las Penas"
L["System"] = "Sistema"
L["Tabard"] = "Tabardo"
L["Taint level: Basic (1)."] = "Nivel de contaminación: básico (1)."
L["Taint level: Disabled (0)."] = "Nivel de contaminación: deshabilitado (0)."
L["Taint level: Full (2)."] = "Nivel de contaminación: lleno (2)."
L["Talonbranch Glade"] = "Claro Ramaespolón"
L["Talrendis Point"] = "Punta Talrendis"
L["Tanaris"] = "Tanaris"
L["Target"] = "Objetivo"
L["Target Tracking Disabled"] = "Rastreo de objetivo se ha deshabilitado"
L["Target Tracking Enabled"] = "Rastreo de objetivo se ha habilitado"
L["Tarren Mill"] = "Molino Tarren"
L["Teldrassil"] = "Teldrassil"
L["Tempest Keep"] = "El Castillo de la Tempestad"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Ten Years of Warcraft"] = "Diez años de Warcraft"
L["Terokkar Forest"] = "Bosque de Terrokar"
L["Text"] = "Texto"
L["Text size"] = "Tamaño de texto"
L["Text Size"] = "Tamaño de texto"
L["The Sepulcher"] = "El Sepulcro"
L["The summon from"] = "La invocación de"
L["Themes"] = "Temas"
L["This panel will close automatically if you enter combat."] = "Este panel se cerrará automáticamente si entras en combate."
L["Thorium Point"] = "Puesto del Torio"
L["Thousand Needles"] = "Las Mil Agujas"
L["Thunder Bluff"] = "Cima del Trueno"
L["Timer"] = "Temporizador"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["To begin, choose an options page."] = "Para comenzar, elija una pestaña de opciones."
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "Para ocultar el registro de combate, debes deshabilitar el módulo de chat en ElvUI."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Para usar el botón Buscar objeto, debe anular la selección de la categoría Token de WoW."
L["Tooltip"] = "Tooltip"
L["Tooltip title color"] = "Color de título del tooltip"
L["Top"] = "Superior"
L["Top Center"] = "Central Superior"
L["Tracing started."] = "El seguimiento comenzó."
L["Tracing stopped."] = "El seguimiento se detuvo."
L["Transparency"] = "Transparencia"
L["True"] = "Cierto"
L["Turn-in completed quests automatically"] = "Entregar misiones completadas automáticamente"
L["Uldaman"] = "Uldaman"
L["Unclamp chat frame"] = "Desbloquear el marco"
L["Undercity"] = "Entrañas"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Universal group color"] = "Color de grupo universal"
L["Use arrow keys in chat"] = "Teclas de flecha"
L["Use class colors in chat"] = "Colores de clase"
L["Use easy resizing"] = "Cambio de tamaño"
L["Value must be a number."] = "Valor debe ser un número."
L["Various"] = "Varios"
L["Vendors"] = "Vendedores"
L["Version"] = "Versión"
L["Very Low"] = "Muy Bajo"
L["Video"] = "Vídeo"
L["Visibility"] = "Visibilidad"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["was automatically declined."] = "fue rechazado automáticamente."
L["Weather density"] = "Densidad del entorno"
L["Welcome to Leatrix Plus."] = "Bienvenido a Leatrix Plus"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Wetlands"] = "Los Humedales"
L["Widget"] = "Artilugio"
L["Wildkin E'ko"] = "E'ko de lechúcico salvaje"
L["will be automatically accepted in 10 seconds unless cancelled."] = "será aceptado automáticamente en 10 segundos a menos que se cancele."
L["Winter"] = "Invierno"
L["Winterfall E'ko"] = "E'ko Nevada"
L["Winterspring"] = "Cuna del Invierno"
L["World of Warcraft"] = "World of Warcraft"
L["X Offset"] = "Compensación X"
L["Y Offset"] = "Compensación Y"
L["YOU"] = "Tú"
L["You cannot do that in combat."] = "No puedes hacerlo mientras estés en combate."
L["You have"] = "Tienes"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su IU necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga de inmediato, pero debe hacer clic en él cuando haya terminado de hacer cambios y desea que los cambios surtan efecto."
L["Your UI needs to be reloaded."] = "Tiene que recargar la IU."
L["Zangarmarsh"] = "Zangarmarsh"
L["Zones"] = "Zonas"
L["Zoram'gar Outpost"] = "Avanzada de Zoram'gar"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zulian, Razzashi, and Hakkari Coins"] = "Las monedas Zulian, Razzashi y Hakkari"
L["Zygor addon not found."] = "No se encuentra el addon Zygor."

end

-- frFR: French
if GameLocale == "frFR" then
L["+"] = "+"
L["A Donation of Mageweave"] = "Un don de tisse-mage"
L["A Donation of Runecloth"] = "Un don d'étoffe runique"
L["A Donation of Silk"] = "Un don de soie"
L["A Donation of Wool"] = "Un don de laine"
L["A friend request from"] = "Une demande de contact de"
L["Accept available quests automatically"] = "Accepter automatiquement les quêtes disponibles"
L["Accept resurrection"] = "Accepter ressuscitation"
L["Accept summon"] = "Accepter invocation"
L["Additional Runecloth"] = "Encore de l'étoffe runique"
L["Addon"] = "Add-on"
L["Aerie Peak"] = "Nid-de-l'Aigle"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alterac Mountains"] = "Montagnes d'Alterac"
L["Anchor"] = "Ancre"
L["Angelic"] = "Angélique"
L["Arathi Highlands"] = "Hautes-terres d'Arathi"
L["Ashenvale"] = "Orneval"
L["Auto loot is now enabled."] = "La fouille automatique est maintenant activée."
L["AutoFollow"] = "Suivi automatique"
L["AutoFollow disabled."] = "Suivi automatique désactivé"
L["Automate gossip"] = "Automatiser le dialogue"
L["Automate quests"] = "Automatiser les quêtes"
L["Automation"] = "Automatisation"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Île de Brume-Azur"
L["Back to Main Menu"] = "Retour au menu principal"
L["Bad ID"] = "ID incorrect"
L["Badlands"] = "Terres ingrates"
L["Barrens"] = "Les Tarides"
L["Battle"] = "Bataille"
L["Battle of Warsong Gulch"] = "La bataille du goulet des Warsong"
L["Battlegrounds"] = "Champs de bataille"
L["Black Morass"] = "Le Noir marécage"
L["Black Temple"] = "Le Temple noir"
L["Blackfathom Deeps"] = "Profondeurs de Brassenoire"
L["Blackrock Depths"] = "Profondeurs de Blackrock"
L["Blackwing Lair"] = "Repaire de l'Aile noire"
L["Blade's Edge Mountains"] = "Les Tranchantes"
L["Blasted Lands"] = "Terres foudroyées"
L["Block duels"] = "Duels"
L["Block friend requests"] = "Demandes de contact"
L["Block party invites"] = "Invitations de groupe"
L["Blocks"] = "Bloquer"
L["Bloodmyst Isle"] = "Île de Brume-Sang"
L["Booty Bay"] = "Baie-du-Butin"
L["Bottom"] = "Bas"
L["Brackenwall Village"] = "Mur-de-Fougères"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "Steppes ardentes"
L["Buyout Only"] = "Acheter seulement"
L["by Leatrix Plus"] = "par Leatrix Plus"
L["C"] = "C"
L["Camera distance"] = "Distance de la caméra"
L["Cannot announce in this zone."] = "Impossible d'annoncer dans cette zone."
L["Cannot find General chat channel."] = "Impossible de trouver le canal de discussion général."
L["Cenarion Hold"] = "Fort Cénarien"
L["Chain style"] = "Style de chaîne"
L["Character"] = "Personnage"
L["Chat"] = "Discussion"
L["Chat Frame"] = "Cadre de discussion"
L["Checkbox labels are Ok."] = "Les étiquettes des cases à cocher sont correctes."
L["Chillwind Camp"] = "Camp du Noroît"
L["Chillwind E'ko"] = "L'E'ko de Noroît"
L["Cinematics"] = "Cinématique"
L["Claiming Arathi Basin"] = "La revendication du bassin d'Arathi"
L["Class colored frames"] = "Cadres colorés"
L["Class icon portraits"] = "Portraits de classe"
L["Classic"] = "Classique"
L["click here for new selection"] = "cliquez ici pour une nouvelle sélection"
L["Click to configure the settings for this option."] = "Cliquez pour configurer les paramètres de cette option."
L["Click to reset the settings on this page."] = "Cliquez pour réinitialiser les paramètres de cette page."
L["Click to resize the screen to fit between the top and bottom borders."] = "Cliquez pour redimensionner l'écran pour qu'il s'adapte entre les bordures supérieure et inférieure."
L["Click to return to the main menu."] = "Cliquez pour revenir au menu principal."
L["Cloak"] = "Manteau"
L["Coilfang Reservoir"] = "Réservoir de Glissecroc"
L["Combat log cannot be hidden while undocked."] = "Le journal de combat ne peut pas être masqué lorsqu'il n'est pas ancré."
L["Combat plates"] = "Plaques de combat"
L["Completed."] = "Terminé."
L["Concerted Efforts"] = "Des efforts concertés"
L["Configuration Panel"] = "Panneau de configuration"
L["Connections for"] = "Connexions pour"
L["Conquering Arathi Basin"] = "La conquête du bassin d'Arathi"
L["Credits"] = "Crédits"
L["Crossroads"] = "La Croisée"
L["Cursor"] = "Curseur"
L["Cursor Left"] = "Curseur gauche"
L["Cursor Right"] = "Curseur droit"
L["D"] = "D"
L["Darkmoon Faire"] = "Foire de Sombrelune"
L["Darkshire"] = "Sombre-Comté"
L["Darkshore"] = "Sombrivage"
L["Deadmines"] = "Les Mortemines"
L["Deadwind Pass"] = "Défilé de Deuillevent"
L["Desolace"] = "Désolace"
L["Dire Maul"] = "Hache-tripes"
L["Disable bag automation"] = "Sac"
L["Disable chat fade"] = "Fondu de discussion"
L["Disable loot warnings"] = "Avertissements de butin"
L["Disable screen effects"] = "Effets d'écran"
L["Disable screen glow"] = "L'éclat de l'écran"
L["Disable sticky chat"] = "Discussion collante"
L["Drag the frame overlay to position the frame."] = "Faites glisser la superposition de cadre pour positionner le cadre."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Faites glisser les superpositions de cadres pour positionner les cadres.|n|nPour modifier l'échelle d'un cadre, cliquez dessus pour le sélectionner, puis ajustez le curseur d'échelle.|n|nCe panneau se fermera automatiquement si vous entrez en combat."
L["Drag to set the buffs frame scale."] = "Faites glisser pour définir l'échelle du cadre des buffs."
L["Drag to set the cursor X offset."] = "Faites glisser pour définir le décalage X du curseur."
L["Drag to set the cursor Y offset."] = "Faites glisser pour définir le décalage Y du curseur."
L["Drag to set the density of weather effects."] = "Faites glisser pour définir la densité des effets météorologiques."
L["Drag to set the font size of book text."] = "Faites glisser pour définir la taille de police du texte du livre."
L["Drag to set the font size of mail text."] = "Faites glisser pour définir la taille de la police du texte du courrier."
L["Drag to set the font size of quest text."] = "Faites glisser pour définir la taille de la police du texte de la quête."
L["Drag to set the scale of the Leatrix Plus panel."] = "Faites glisser pour définir l'échelle du panneau Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Faites glisser pour définir l'échelle du cadre sélectionné."
L["Drag to set the size of the bottom border."] = "Faites glisser pour définir la taille de la bordure inférieure."
L["Drag to set the size of the left border."] = "Faites glisser pour définir la taille de la bordure gauche."
L["Drag to set the size of the right border."] = "Faites glisser pour définir la taille de la bordure droite."
L["Drag to set the size of the top border."] = "Faites glisser pour définir la taille de la bordure supérieure."
L["Drag to set the tooltip scale."] = "Faites glisser pour définir l'échelle de l'infobulle."
L["Drag to set the transparency of the borders."] = "Faites glisser pour définir la transparence des bordures."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Faites glisser pour définir la transparence du panneau Leatrix Plus."
L["Dun Morogh"] = "Dun Morogh"
L["Dungeons"] = "Donjons"
L["Dup ID"] = "Dup ID"
L["durability"] = "durabilité"
L["Durability"] = "Durabilité"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bois de la Pénombre"
L["Dustwallow Marsh"] = "Marécage d'Âprefange"
L["Eastern Kingdoms"] = "Royaumes de l'Est"
L["Eastern Plaguelands"] = "Maleterres de l'est"
L["Easy item destroy"] = "Élimination facile des objets"
L["ELITE"] = "ÉLITE"
L["Elwynn Forest"] = "Forêt d'Elwynn"
L["Enable viewport"] = "Activer la fenêtre"
L["Enhance dressup"] = "Cabine d'essayage"
L["Enhance minimap"] = "Minicarte"
L["Enhance professions"] = "Professions"
L["Enhance quest log"] = "Journal des quêtes"
L["Enhance tooltip"] = "Infobulle"
L["Enhance trainers"] = "Maîtres"
L["Enhancements"] = "Améliorations"
L["Enter"] = "Entrer"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Entrez les ID des sorts pour les icônes de temps de recharge que vous souhaitez voir.|n|nSi une icône de temps de recharge apparaît normalement sous le cadre de le familier, cochez la case de le familier.|n|nLes icônes de temps de recharge sont enregistrées dans votre classe."
L["enter zone or track name"] = "entrer dans la zone ou suivre le nom"
L["Error messages will be hidden"] = "Les messages d'erreur seront masqués"
L["Error messages will be shown"] = "Des messages d'erreur seront affichés"
L["Events"] = "Événements"
L["Everlook"] = "Long-Guet"
L["Eversong Woods"] = "Bois des Chants éternels"
L["Extras"] = "Suppléments"
L["False"] = "Faux"
L["Faster auto loot"] = "La fouille plus rapide"
L["Faster movie skip"] = "Saut de film plus rapide"
L["Feathermoon"] = "Pennelune"
L["Features"] = "Traits"
L["Felwood"] = "Gangrebois"
L["Feralas"] = "Féralas"
L["Fight for Warsong Gulch"] = "La lutte pour le goulet des Warsong"
L["Find Item"] = "Rechercher un objet"
L["Firewing Signets"] = "Les chevalières Aile-de-feu"
L["Flame Crest"] = "Corniche des Flammes"
L["For Great Honor"] = "Pour un grand honneur"
L["Frames"] = "Cadres"
L["Freewind Post"] = "Poste de Librevent"
L["Frostmaul E'ko"] = "L'E'ko de Cognegivre"
L["Frostsaber E'ko"] = "L'E'ko des sabres-de-givre"
L["Game Options"] = "Options de jeu"
L["Ghost"] = "Fantôme"
L["Ghostlands"] = "Les terres Fantômes"
L["Gloomy"] = "Cafardeux"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Or seulement"
L["Graphics and Sound"] = "Graphisme et son"
L["Groups"] = "Groupes"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "Pièces Gurubashi, Vilebranch et Witherbark"
L["H"] = "H"
L["Hammerfall"] = "Trépas-d'Orgrim"
L["Haunted"] = "Hanté"
L["Hellfire Peninsula"] = "Péninsule des Flammes infernales"
L["Hellfire Ramparts"] = "Remparts des Flammes infernales"
L["Helm"] = "Heaume"
L["Help"] = "Aide"
L["Hide chat buttons"] = "Boutons de discussion"
L["Hide cooldown duration numbers (if enabled)"] = "Masquer les numéros de durée de recharge (si activé)"
L["Hide error messages"] = "Messages d'erreur"
L["Hide gryphons"] = "Griffons"
L["Hide portrait numbers"] = "Numéros de portrait"
L["Hide stance bar"] = "Barre de posture"
L["Hide the combat log"] = "Journal de combat"
L["Hide the zone text bar"] = "Masquer la barre de texte de la zone"
L["Hide the zoom buttons"] = "Masquer les boutons de zoom"
L["Hide tooltips for world units during combat"] = "Masquer les infobulles des unités mondiales pendant le combat"
L["Hide zone text"] = "Texte de la zone"
L["High"] = "Haut"
L["Hillsbrad Foothills"] = "Contreforts d'Hillsbrad"
L["Hinterlands"] = "Les Hinterlands"
L["Home"] = "Principal"
L["Hyjal Summit"] = "Sommet d’Hyjal"
L["Ice Thistle E'ko"] = "L'E'ko des Chardon de Glace"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Si cette option est cochée, une boîte de recherche de sac sera affichée dans le cadre du sac à dos et le cadre de la banque."
L["If checked, a button will be added to the character frame which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Si cette option est cochée, un bouton sera ajouté à la feuille de personnage qui montrera la durabilité de votre objet équipé lorsque vous passez le pointeur dessus.|n|nDe plus, un pourcentage global sera affiché dans le cadre de discussion lorsque vous mourrez."
L["If checked, a master volume slider will be shown in the character frame."] = "Si cette option est cochée, un curseur de volume principal sera affiché dans la feuille de personnage."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "Si cette option est cochée, des fonctionnalités supplémentaires seront ajoutées à l'hôtel des ventes|n|nAcheter seulement - créer des enchères de rachat sans renseigner le prix de départ.|n|nOr uniquement - fixez les prix du cuivre et de l'argent à 99 pour accélérer les nouvelles enchères.|n|nRechercher un objet - recherchez dans l'hôtel des ventes l'objet que vous vendez.|n|nEn outre, le paramètre de durée de l'enchère sera enregistré dans l'ensemble du compte."
L["If checked, alert frames will not be shown."] = "Si cette option est cochée, les cadres d'alerte ne seront pas affichés."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si cette option est cochée, tous les objets de qualité médiocre dans vos sacs seront vendus automatiquement lors de votre visite chez un marchand.|n|nVous pouvez maintenir la touche Maj enfoncée lorsque vous parlez à un marchand pour remplacer ce paramètre."
L["If checked, available quests will be accepted automatically."] = "Si cette option est cochée, les quêtes disponibles seront acceptées automatiquement."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Si cette option est cochée, les fonds seront teintés en bleu (amical) ou en rouge (hostile)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Si cette option est cochée, les demandes de contact BattleTag et Nom réel seront automatiquement refusées.|n|nL'activation de cette option refusera automatiquement toutes les demandes en attente."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Si cette option est cochée, les boutons du cadre de discussion seront masqués.|n|nCliquer sur les onglets de discussion affichera automatiquement les derniers messages.|n|nUtilisez la molette de la souris pour faire défiler l'historique du discussion. Maintenez Maj pour le saut de page ou Ctrl pour sauter vers le haut ou le bas de l'historique de discussion."
L["If checked, chat text will not fade out after a time period."] = "Si cette option est cochée, le texte de discussion ne disparaîtra pas après un certain temps."
L["If checked, class colors will be used in the chat frame."] = "Si cette option est cochée, les couleurs de classe seront utilisées dans le cadre de discussion."
L["If checked, completed quests will be turned-in automatically."] = "Si cette option est cochée, les quêtes terminées seront retournées automatiquement."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Si cette option est cochée, les confirmations n'apparaîtront plus lorsque vous choisissez une option de rouleau de butin ou tentez de vendre ou d'envoyer un objet échangeable."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Si cette option est cochée, les numéros de durée de temps de recharge ne seront pas affichés au cours des temps de recharge.|n|nSi il n'est pas coché, les numéros de durée des temps de recharge seront affichés au-dessus des temps de recharge s'ils sont activés dans le panneau d'options de jeu (menu 'Barres d'action')."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Si cette option est cochée, les nombres de dégâts et de soins dans les cadres de portrait de joueur et du familier seront cachés."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Si cette option est cochée, le fait de faire glisser l'onglet Général de discussion alors que le cadre de discussion est verrouillé étendra le cadre de discussion vers le haut.|n|nSi le cadre de discussion est déverrouillé, le fait de faire glisser l'onglet Général de discussion déplace le cadre de discussion."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Si cette option est cochée, les sons d'émote seront réduits au silence pendant que votre personnage se repose ou dans Le Sinistre écluseur.|n|nLes sons d'émote seront activés à tout autre moment."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Si cette option est cochée, les barres d'info des ennemis seront affichées pendant le combat et cachées à la fin du combat."
L["If checked, helm and cloak toggle checkboxes will be shown in the character frame.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Si cette option est cochée, les cases à cocher de l'heaume et de la cape seront affichées dans la feuille de personnage.|n|nVous pouvez maintenir la touche Maj enfoncée et cliquer avec le bouton droit sur les cases à cocher pour changer de disposition."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Si cette option est cochée, la discussion de raid et la discussion d'instance seront tous les deux colorés en bleu (pour correspondre à la couleur de chat du groupe par défaut)."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Si cette option est cochée, les ID des sorts seront affichés dans les infobulles des icônes de buff situées dans le cadre du buff et sous le cadre cible."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Si cette option est cochée, le chat collant sera désactivé.|n|nNotez que cela ne s'applique pas aux fenêtres de discussion temporaires."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Si cette option est cochée, les demandes d'invocation seront acceptées automatiquement, sauf si vous êtes en combat."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Si cette option est cochée, la liste des add-ons (accessible depuis le menu du jeu) affichera les add-ons basés sur les personnages par défaut."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Si cette option est cochée, le temps qu'il faut pour fouiller automatiquement les créatures sera considérablement réduit."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Si cette option est cochée, le bouton de nettoyage du sac à dos et le bouton de nettoyage du cadre de la banque ne seront pas affichés."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Si cette option est cochée, le bouton permettant de basculer le cadre du conteneur de raid sera affiché juste au-dessus du cadre de gestion du raid (côté gauche de l'écran) plutôt que dans le cadre de gestion du raid lui-même.|n|nCela vous permet de basculer le cadre du conteneur de raid sans avoir à ouvrir le cadre de gestion du raid."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Si cette option est cochée, le journal de combat sera caché.|n|nLe journal de combat doit être ancré pour que cette option fonctionne.|n|nSi le journal de combat n'est pas ancré, vous pouvez l'ancrer en faisant glisser l'onglet (et en rechargeant votre interface utilisateur) ou en réinitialisant les fenêtres de discussion (à partir du menu de discussion)."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Si cette option est cochée, la boîte d'édition sera déplacée en haut du cadre de discussion."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Si cette option est cochée, l'écran gris de la mort et l'effet du monde inférieur seront désactivés."
L["If checked, the main bar gryphons will not be shown."] = "Si cette option est cochée, les griffons de la barre principale ne seront pas affichés."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Si cette option est cochée, le nombre d'emplacements de sac vides sera affiché dans l'icône du bouton du sac à dos et dans l'infobulle."
L["If checked, the player frame background will be shown in class color."] = "Si cette option est cochée, l'arrière-plan du cadre du joueur sera affiché en couleur de la classe."
L["If checked, the professions frame will be larger."] = "Si cette option est cochée, le cadre des professions sera plus grand."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Si cette option est cochée, la lueur de l'écran sera désactivée.|n|nL'activation de cette option désactivera également l'effet de trouble ivre."
L["If checked, the stance bar will not be shown."] = "Si cette option est cochée, la barre de posture ne sera pas affichée."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Si cette option est cochée, le cadre parlant ne sera pas affiché.|n|nLe cadre parlant apparaît normalement dans la partie inférieure de l'écran lorsque certains PNJ communiquent avec vous."
L["If checked, the target frame background will be shown in class color."] = "Si cette option est cochée, l'arrière-plan du cadre cible sera affiché dans la couleur de la classe."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Si cette option est cochée, l'infobulle sera codée par couleur et vous pourrez modifier la disposition et l'échelle de l'infobulle."
L["If checked, the vendor price will be shown in item tooltips."] = "Si cette option est cochée, le prix marchand sera affiché dans les infobulles des objets."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Si cette option est cochée, les boutons de zoom seront masqués. Vous pouvez utiliser la molette pour zoomer quel que soit ce paramètre."
L["If checked, unit targets will be shown."] = "Si cette option est cochée, les cibles des unités seront affichées."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Si cette option est cochée, vous pouvez maintenir la touche de contrôle enfoncée et cliquer sur un onglet de discussion pour afficher la discussion récente dans une fenêtre de copie."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Si cette option est cochée, vous pouvez appuyer sur les touches fléchées pour déplacer le point d'insertion vers la gauche et la droite dans le cadre de discussion.|n|nSi elle n'est pas cochée, les touches fléchées utiliseront le paramètre de liaison de touches par défaut."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Si cette option est cochée, vous pourrez annuler les cinématiques sans être invité à confirmer."
L["If checked, you will be able to change the font size of book text."] = "Si cette option est cochée, vous pourrez modifier la taille de la police du texte du livre."
L["If checked, you will be able to change the font size of quest text."] = "Si cette option est cochée, vous pourrez modifier la taille de la police du texte de la quête."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Si cette option est cochée, vous pourrez modifier la taille de police du texte de courrier standard.|n|nCela n'affecte pas le courrier créé à l'aide de modèles (tels que les factures de l'hôtel des ventes)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Si cette option est cochée, vous pourrez modifier la position et l'échelle du cadre des buffs."
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "Si cette option est cochée, vous pourrez changer la position et l'échelle du cadre du widget.|n|nLe cadre du widget est couramment utilisé pour afficher les scores JcJ et suivre les objectifs."
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Si cette option est cochée, vous pourrez créer une fenêtre. Une fenêtre ajoute des bordures noires réglables dans le monde du jeu.|n|nLes bordures sont placées au-dessus du monde du jeu mais sous l'interface utilisateur afin que vous puissiez placer des éléments d'interface sur eux."
L["If checked, you will be able to customise the minimap."] = "Si cette option est cochée, vous pourrez personnaliser la minicarte."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Si cette option est cochée, vous pourrez faire glisser le cadre de discussion vers le bord de l'écran."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Si cette option est cochée, vous pourrez placer jusqu'à cinq icônes de recharge bénéfiques au-dessus du cadre cible."
L["If checked, you will be able to reposition the tooltip."] = "Si cette option est cochée, vous pourrez repositionner l'infobulle."
L["If checked, you will be able to set the density of weather effects."] = "Si cette option est cochée, vous pourrez définir la densité des effets météorologiques."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Si cette option est cochée, vous pourrez montrer une chaîne rare, d'élite ou d'élite rare autour du cadre du joueur."
L["If checked, you will be able to zoom out to a greater distance."] = "Si cette option est cochée, vous pourrez effectuer un zoom arrière sur une plus grande distance."
L["If checked, you will no longer need to type delete when destroying a superior quality item.|n|nIn addition, item links will be shown in all item destroy confirmation windows."] = "Si est cochée, vous n'aurez plus besoin de taper supprimer lors de l'élimination d'un objet de qualité supérieure.|n|nDe plus, les liens d'objets seront affichés dans toutes les fenêtres de confirmation de élimination d'objets."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Si cette option est cochée, vous serez automatiquement libéré après votre mort sur un champ de bataille.|n|nVous ne vous libérerez pas automatiquement si vous avez la capacité de ressusciter automatiquement."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Si cette option est cochée, votre historique de discussion passera à 4096 lignes. Si elle n'est pas cochée, la valeur par défaut sera utilisée (128 lignes).|n|nL'activation de cette option peut empêcher certains textes de discussion de s'afficher pendant la connexion."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si cette option est cochée, votre équipement sera réparé automatiquement lorsque vous rendrez visite à un marchand approprié.|n|nVous pouvez maintenir la touche Maj enfoncée lorsque vous parlez à un marchand pour remplacer ce paramètre."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Si cette option est cochée, le texte de la zone ne sera pas affiché (par exemple, «Ironforge»)."
L["Increase chat history"] = "Augmenter l'historique"
L["Interface"] = "Interface"
L["Invaders of Alterac Valley"] = "Les envahisseurs de la vallée d'Alterac"
L["Invalid console variable."] = "Variable de console non valide."
L["Invalid parameter."] = "Paramètre invalide."
L["Invalid quest ID."] = "ID de quête non valide."
L["Invalid sound ID"] = "ID de son invalide"
L["Invalid taint level."] = "Niveau de souillure non valide."
L["Invalid target."] = "Cible invalide."
L["Invite from whispers"] = "Inviter des chuchotements"
L["Ironforge"] = "Forgefer"
L["Kalimdor"] = "Kalimdor"
L["Karazhan"] = "Échecs de Karazhan"
L["Keyword"] = "Mot-clé"
L["Lakeshire"] = "Comté-du-Lac"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus n'écrasera pas LeaPlusDB à la prochaine déconnexion."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: UNE VERSION INCORRECTE EST INSTALLÉE!"
L["Left"] = "Gauche"
L["Lifetime honorable kills"] = "Victoires honorables à vie"
L["Light's Hope Chapel"] = "Chapelle de l'Espoir de Lumière"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Partage de verrouillage"
L["Low"] = "Faible"
L["Magic"] = "Magie"
L["Magisters' Terrace"] = "Terrasse des Magistères"
L["Main Titles"] = "Titres principaux"
L["Manage buffs"] = "Gérer les buffs"
L["Manage frames"] = "Gérer les cadres"
L["Manage widget"] = "Gérer le widget"
L["Managed by Leatrix Plus"] = "Géré par Leatrix Plus"
L["Map"] = "Carte"
L["Maraudon"] = "Maraudon"
L["Marks of Kil'jaeden"] = "Les marques de Kil'jaeden"
L["Marks of Sargeras"] = "Les marques de Sargeras"
L["Marshal's Refuge"] = "Refuge des Marshal"
L["Max camera zoom"] = "Zoom max de la caméra"
L["Mechanics"] = "Mécanique"
L["Media"] = "Médias"
L["Medium"] = "Moyen"
L["Memory Usage"] = "Utilisation de la mémoire"
L["Menethil Harbor"] = "Port de Menethil"
L["message shown."] = "message affiché."
L["messages shown."] = "messages affichés."
L["Missing console variable."] = "Variable de console manquante."
L["Missing mount name."] = "Nom de monture manquant."
L["Missing movie ID."] = "ID de film manquant."
L["Missing quest ID."] = "ID de quête manquant."
L["Missing sound file parameter."] = "Paramètre de fichier son manquant."
L["Missing sound ID."] = "ID de son manquant."
L["Molten Core"] = "Cœur du Magma"
L["Moonglade"] = "Reflet-de-Lune"
L["More Firewing Signets"] = "De nouvelles chevalières Aile-de-feu"
L["More Marks of Kil'jaeden"] = "De nouvelles marques de Kil'jaeden"
L["More Marks of Sargeras"] = "De nouvelles marques de Sargeras"
L["More Sunfury Signets"] = "De nouvelles chevalières Solfurie"
L["Morgan's Vigil"] = "Veille de Morgan"
L["Mount not found."] = "Monture introuvable."
L["Move editbox to top"] = "Boîte d'édition"
L["Movie not playable."] = "Film non jouable."
L["Movie number"] = "Numéro de film"
L["Movies"] = "Films"
L["Mulgore"] = "Mulgore"
L["Music"] = "Musique"
L["Musical Moments"] = "Moments musicaux"
L["Mystery"] = "Mystère"
L["Nagrand"] = "Nagrand"
L["Narration"] = "Narration"
L["Naxxramas"] = "Naxxramas"
L["Nethergarde Keep"] = "Rempart-du-Néant"
L["Netherstorm"] = "Raz-de-Neant"
L["Nijel's Point"] = "Combe de Nijel"
L["No bad sound IDs found."] = "Aucun mauvais ID sonore trouvé."
L["No help is available for this page."] = "Aucune aide n'est disponible pour cette page."
L["No items with durability equipped."] = "Aucun objet avec durabilité équipé."
L["No media duplicates found."] = "Aucun doublon de média trouvé."
L["No tooltip showing."] = "Aucune infobulle ne s'affiche."
L["None"] = "Aucun"
L["Not completed."] = "Pas terminé."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "AVIS!|nVous devez redémarrer complètement votre client de jeu avant de pouvoir utiliser cette version de Leatrix Plus."
L["Nude"] = "Nu"
L["Old Hillsbrad Foothills"] = "Contreforts de Hautebrande d’antan"
L["Onyxia's Lair"] = "Repaire d'Onyxia"
L["or click the minimap button to open Leatrix Plus."] = "ou cliquez sur le bouton de la mini-carte pour ouvrir Leatrix Maps."
L["Orgrimmar"] = "Orgrimmar"
L["Outland"] = "Outreterre"
L["Overall"] = "Total"
L["Overlay"] = "Superposition"
L["Particle density"] = "Densité de particules"
L["Party from friends"] = "Groupe d'amis"
L["Pet"] = "Familier"
L["Player"] = "Joueur"
L["Power"] = "Puissance"
L["Press CTRL/C to copy."] = "Appuyez sur Ctrl+C pour copier."
L["Queue from friends"] = "File d'attente d'amis"
L["R"] = "R"
L["Ragefire Chasm"] = "Gouffre de Ragefeu"
L["Raid"] = "Raid"
L["Raid frame toggle"] = "Cadre de raid"
L["Random"] = "Aléatoire"
L["RARE"] = "RARE"
L["RARE ELITE"] = "RARE ÉLITE"
L["Ratchet"] = "Cabestan"
L["Razorfen Downs"] = "Souilles de Tranchebauge"
L["Razorfen Kraul"] = "Kraal de Tranchebauge"
L["Recent chat window"] = "Discussion récente"
L["Redridge Mountains"] = "Les Carmines"
L["Refuge Pointe"] = "Refuge de l'Ornière"
L["Release in PvP"] = "Libérer en JcJ"
L["Reload"] = "Recharger"
L["Remember Alterac Valley!"] = "Souvenez-vous de la vallée d'Alterac !"
L["Repair automatically"] = "Réparer"
L["Repaired for"] = "Réparé pour"
L["Reposition the tooltip"] = "Repositionner l'infobulle"
L["Requires UI reload."] = "Nécessite le rechargement de l'interface utilisateur."
L["Reset"] = "Réinitialiser"
L["Resize book text"] = "Texte du livre"
L["Resize mail text"] = "Texte du courrier"
L["Resize quest text"] = "Texte de la quête"
L["Resize Screen"] = "Redimensionner l'écran"
L["Rested bubbles"] = "Bulles reposées"
L["result"] = "résultat"
L["results"] = "résultats"
L["Revantusk Village"] = "Village des Vengebroches"
L["Right"] = "Droit"
L["Right-click to close"] = "Clic droit pour fermer"
L["Right-click to close."] = "Clic droit pour fermer."
L["right-click to go back"] = "clic droit pour revenir"
L["Ruins of Ahn'Qiraj"] = "Ruines d'Ahn'Qiraj"
L["Rut'theran Village"] = "Rut'theran"
L["Sacred"] = "Sacré"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "Pièces Sandfury, Skullsplitter et Bloodscalp"
L["Scale"] = "Échelle"
L["Scarlet Monastery"] = "Monastère écarlate"
L["Scholomance"] = "Scholomance"
L["Search"] = "Chercher"
L["Searing Gorge"] = "Gorge des Vents brûlants"
L["Select the settings that you want to use."] = "Sélectionnez les paramètres que vous souhaitez utiliser."
L["Selection of music tracks"] = "Sélection de morceaux de musique"
L["Self Markers Allowed"] = "Marqueurs auto autorisés"
L["Self Markers Blocked"] = "Auto marqueurs bloqués"
L["Sell junk automatically"] = "Vendre objets médiocre"
L["SELLING JUNK"] = "Vendre des objets de qualité médiocre"
L["Sentinel Hill"] = "Colline des sentinelles"
L["Set weather density"] = "Densité météorologique"
L["Settings"] = "Paramètres"
L["Shaders"] = "Shaders"
L["Shadowfang Keep"] = "Donjon d'Ombrecroc"
L["Shadowmoon Valley"] = "Vallée d’Ombrelune"
L["Shadowprey Village"] = "Proie-de-l'Ombre"
L["Shardtooth E'ko"] = "L'E'ko des Crocs acérés"
L["Show auction controls"] = "Hôtel des ventes"
L["Show bag search box"] = "Recherche de sacs"
L["Show character addons"] = "Add-ons de personnage"
L["Show cooldowns"] = "Temps de recharge"
L["Show cooldowns above the player frame"] = "Afficher les temps de recharge au-dessus du cadre du joueur"
L["Show durability status"] = "Durabilité"
L["Show free bag slots"] = "Emplacements de sac vides"
L["Show guild names"] = "Afficher les noms de guilde"
L["Show minimap button"] = "Bouton de la mini-carte"
L["Show player chain"] = "Chaîne du joueur"
L["Show player frame in class color"] = "Afficher le cadre du joueur dans la couleur de la classe"
L["Show raid button"] = "Afficher le bouton de raid"
L["Show the spell ID in buff icon tooltips"] = "Afficher l'ID du sort dans les infobulles des icônes de buff"
L["Show unit targets"] = "Afficher les cibles des unités"
L["Show vanity controls"] = "Afficher les commandes de vanité"
L["Show vendor price"] = "Prix marchand"
L["Show volume slider"] = "Volume"
L["Show Wowhead links"] = "Liens Wowhead"
L["Silence rested emotes"] = "Emotes reposés"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Forêt des Pins argentés"
L["Single Mark of Sargeras"] = "Une marque de Sargeras"
L["Single Sunfury Signet"] = "Une chevalière Solfurie"
L["Social"] = "Social"
L["Sold junk for"] = "Vendu des objets de qualité médiocre pour"
L["Sound system restarted."] = "Le système audio a redémarré."
L["Spell ID"] = "ID de sort"
L["Splintertree Post"] = "Poste de Bois-Brisé"
L["Spooky"] = "Effrayant"
L["Stockade"] = "La Prison"
L["Stonard"] = "Pierrêche"
L["Stonetalon Mountains"] = "Les Serres-Rocheuses"
L["Stonetalon Peak"] = "Pic des Serres-Rocheuses"
L["Stop"] = "Arrêt"
L["Stormwind"] = "Hurlevent"
L["Stranglethorn Vale"] = "Vallée de Strangleronce"
L["Stratholme"] = "Stratholme"
L["Sun Rock Retreat"] = "Retraite de Roche-Soleil"
L["Sunfury Signets"] = "Les chevalières Solfurie"
L["Sunken Temple"] = "Temple englouti"
L["Sunwell Plateau"] = "Plateau du Puits de soleil"
L["Support"] = "Soutien"
L["Swamp"] = "Marais"
L["Swamp of Sorrows"] = "Marais des Chagrins"
L["System"] = "Système"
L["Tabard"] = "Tabard"
L["Taint level: Basic (1)."] = "Niveau de souillure: basique (1)."
L["Taint level: Disabled (0)."] = "Niveau de souillure: désactivé (0)."
L["Taint level: Full (2)."] = "Niveau de souillure: Complet (2)."
L["Talonbranch Glade"] = "Clairière de Griffebranche"
L["Talrendis Point"] = "Halte de Talrendis"
L["Tanaris"] = "Tanaris"
L["Target"] = "Cible"
L["Target Tracking Disabled"] = "Pistage de cible désactivé"
L["Target Tracking Enabled"] = "Pistage de cible activé"
L["Tarren Mill"] = "Moulin-de-Tarren"
L["Teldrassil"] = "Teldrassil"
L["Tempest Keep"] = "Donjon de la Tempête"
L["Temple of Ahn'Qiraj"] = "Temple d'Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Le temple d'Atal'Hakkar"
L["Ten Years of Warcraft"] = "Dix ans de Warcraft"
L["Terokkar Forest"] = "Forêt de Terokkar"
L["Text"] = "Texte"
L["Text size"] = "Taille du texte"
L["Text Size"] = "Taille du texte"
L["The Sepulcher"] = "Le Sépulcre"
L["The summon from"] = "L'invocation de"
L["Themes"] = "Thèmes"
L["This panel will close automatically if you enter combat."] = "Ce panneau se fermera automatiquement si vous entrez en combat."
L["Thorium Point"] = "Halte du Thorium"
L["Thousand Needles"] = "Mille pointes"
L["Timer"] = "Chronomètre"
L["Tirisfal Glades"] = "Clairières de Tirisfal"
L["To begin, choose an options page."] = "Pour commencer, choisissez une page d'options."
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "Pour masquer le journal de combat, vous devez désactiver le module de discussion dans ElvUI."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Pour utiliser le bouton Rechercher un objet, vous devez désélectionner la catégorie Token WoW."
L["Tooltip"] = "Infobulle"
L["Tooltip title color"] = "Couleur du titre de l'infobulle"
L["Top"] = "Haut"
L["Top Center"] = "Haut Centre"
L["Tracing started."] = "Le traçage a commencé."
L["Tracing stopped."] = "Le traçage s'est arrêté."
L["Transparency"] = "Transparence"
L["True"] = "Vrai"
L["Turn-in completed quests automatically"] = "Retourner automatiquement les quêtes terminées"
L["Uldaman"] = "Uldaman"
L["Unclamp chat frame"] = "Déverrouiller le cadre"
L["Undercity"] = "Fossoyeuse"
L["Un'Goro Crater"] = "Cratère d'Un'Goro"
L["Universal group color"] = "Couleur de groupe universelle"
L["Use arrow keys in chat"] = "Touches fléchées"
L["Use class colors in chat"] = "Couleurs de classe"
L["Use easy resizing"] = "Redimensionnement"
L["Value must be a number."] = "La valeur doit être un nombre."
L["Various"] = "Divers"
L["Vendors"] = "Marchands"
L["Version"] = "Version"
L["Very Low"] = "Très faible"
L["Video"] = "Vidéo"
L["Visibility"] = "Visibilité"
L["Wailing Caverns"] = "Cavernes des lamentations"
L["was automatically declined."] = "a été automatiquement refusé."
L["Weather density"] = "Densité météorologique"
L["Welcome to Leatrix Plus."] = "Bienvenue dans Leatrix Plus."
L["Western Plaguelands"] = "Maleterres de l'ouest"
L["Westfall"] = "Marche de l'Ouest"
L["Wetlands"] = "Les Paluns"
L["Widget"] = "Widget"
L["Wildkin E'ko"] = "L'E'ko des Indomptables"
L["will be automatically accepted in 10 seconds unless cancelled."] = "sera automatiquement accepté dans 10 secondes sauf annulation."
L["Winter"] = "Hiver"
L["Winterfall E'ko"] = "L'E'ko des Tombe-hiver"
L["Winterspring"] = "Berceau-de-l'Hiver"
L["World of Warcraft"] = "World of Warcraft"
L["X Offset"] = "Décalage X"
L["Y Offset"] = "Décalage Y"
L["YOU"] = "VOUS"
L["You cannot do that in combat."] = "Vous ne pouvez pas faire cela au combat."
L["You have"] = "Vous avez"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Votre interface utilisateur doit être rechargée pour que certaines des modifications prennent effet.|n|nVous n'avez pas besoin de cliquer immédiatement sur le bouton de rechargement, mais vous devez le cliquer lorsque vous avez terminé d'apporter des modifications et que vous souhaitez que les modifications prennent effet."
L["Your UI needs to be reloaded."] = "Votre interface utilisateur doit être rechargée."
L["Zangarmarsh"] = "Marécage de Zangar"
L["Zones"] = "Zones"
L["Zoram'gar Outpost"] = "Avant-poste de Zoram'gar"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zulian, Razzashi, and Hakkari Coins"] = "Pièces zuliennes, razzashi et hakkari"
L["Zygor addon not found."] = "Add-on Zygor introuvable."

end

-- itIT: Italian
if GameLocale == "itIT" then

end

-- ptBR: Brazilian Portuguese
if GameLocale == "ptBR" then
L["+"] = "+"
L["A Donation of Mageweave"] = "Uma doação de magitrama"
L["A Donation of Runecloth"] = "Uma doação de runatrama"
L["A Donation of Silk"] = "Uma doação de seda"
L["A Donation of Wool"] = "Uma doação de lã"
L["A friend request from"] = "Uma solicitação de confirmação de amigo de"
L["Accept available quests automatically"] = "Aceitar missões disponíveis automaticamente"
L["Accept resurrection"] = "Aceitar ressuscitação"
L["Accept summon"] = "Aceitar evocação"
L["Additional Runecloth"] = "Runatrama extra"
L["Addon"] = "Addon"
L["Aerie Peak"] = "Ninho da Águia"
L["Ahn'Qiraj"] = "Ahn'Qiraj"
L["Alterac Mountains"] = "Montanhas de Alterac"
L["Anchor"] = "Âncora"
L["Angelic"] = "Angélico"
L["Arathi Highlands"] = "Planalto Arathi"
L["Ashenvale"] = "Vale Gris"
L["Auto loot is now enabled."] = "Saque automático agora está ativado."
L["AutoFollow"] = "Seguir automático"
L["AutoFollow disabled."] = "Seguir automático desativado."
L["Automate gossip"] = "Automatizar diálogo"
L["Automate quests"] = "Automatizar missões"
L["Automation"] = "Automação"
L["Azshara"] = "Azshara"
L["Azuremyst Isle"] = "Ilha Névoa Lazúli"
L["Back to Main Menu"] = "Voltar ao menu principal"
L["Bad ID"] = "ID inválido"
L["Badlands"] = "Ermos"
L["Barrens"] = "Sertões"
L["Battle"] = "Batalha"
L["Battle of Warsong Gulch"] = "Batalha da Ravina Brado Guerreiro"
L["Battlegrounds"] = "Campo de Batalha"
L["Black Morass"] = "Lamaçal Negro"
L["Black Temple"] = "Templo Negro"
L["Blackfathom Deeps"] = "Profundezas Negras"
L["Blackrock Depths"] = "Abismo Rocha Negra"
L["Blackwing Lair"] = "Covil Asa Negra"
L["Blade's Edge Mountains"] = "Montanhas da Lâmina Afiada"
L["Blasted Lands"] = "Barreira do Inferno"
L["Block duels"] = "Duelos"
L["Block friend requests"] = "Solicitações de confirmação de amigo"
L["Block party invites"] = "Convites de grupo"
L["Blocks"] = "Bloquear"
L["Bloodmyst Isle"] = "Ilha Névoa Rubra"
L["Booty Bay"] = "Angra do Butim"
L["Bottom"] = "Inferior"
L["Brackenwall Village"] = "Aldeia Muralha Verde"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "Estepes Ardentes"
L["Buyout Only"] = "Somente Compra"
L["by Leatrix Plus"] = "por Leatrix Plus"
L["C"] = "C"
L["Camera distance"] = "Distância da câmera"
L["Camp Mojache"] = "Aldeia Mojache"
L["Camp Taurajo"] = "Aldeia Taurajo"
L["Cannot announce in this zone."] = "Não é possível anunciar nesta zona."
L["Cannot find General chat channel."] = "Não é possível encontrar o canal de chat geral."
L["Cenarion Hold"] = "Forte Cenariano"
L["Chain style"] = "Estilo cadeia"
L["Character"] = "Personagem"
L["Chat"] = "Bate-papo"
L["Chat Frame"] = "Quadro de bate-papo"
L["Checkbox labels are Ok."] = "Os rótulos das caixas de seleção estão OK."
L["Chillwind Camp"] = "Acampamento Ventogelante"
L["Chillwind E'ko"] = "E'ko de ventogelante"
L["Cinematics"] = "Cinemático"
L["Claiming Arathi Basin"] = "Reivindicando a Bacia Arathi"
L["Class colored frames"] = "Quadros coloridos"
L["Class icon portraits"] = "Retratos de classe"
L["Classic"] = "Clássico"
L["click here for new selection"] = "clique aqui para nova seleção"
L["Click to configure the settings for this option."] = "Clique para definir as configurações para esta opção."
L["Click to reset the settings on this page."] = "Clique para redefinir as configurações nesta página."
L["Click to resize the screen to fit between the top and bottom borders."] = "Clique para redimensionar a tela para caber entre as bordas superior e inferior."
L["Click to return to the main menu."] = "Clique para retornar ao menu principal."
L["Cloak"] = "Capa"
L["Coilfang Reservoir"] = "Reservatório Presacurva"
L["Combat log cannot be hidden while undocked."] = "O registro de combate não pode ser oculto enquanto desencaixado."
L["Combat plates"] = "Placas de combate"
L["Completed."] = "Completo."
L["Concerted Efforts"] = "Esforços combinados"
L["Configuration Panel"] = "Painel de Configuração"
L["Connections for"] = "Conexões para"
L["Conquering Arathi Basin"] = "Conquistando a Bacia Arathi"
L["Credits"] = "Créditos"
L["Crossroads"] = "Encruzilhada"
L["Cursor"] = "Cursor"
L["Cursor Left"] = "Cursor esquerdo"
L["Cursor Right"] = "Cursor direito"
L["D"] = "M"
L["Darkmoon Faire"] = "Feira de Negraluna"
L["Darkshire"] = "Vila Sombria"
L["Darkshore"] = "Costa Negra"
L["Deadmines"] = "Minas Mortas"
L["Deadwind Pass"] = "Trilha do Vento Morto"
L["Desolace"] = "Desolação"
L["Dire Maul"] = "Gládio Cruel"
L["Disable bag automation"] = "Automação de bolsa"
L["Disable chat fade"] = "Esmaecimento"
L["Disable loot warnings"] = "Avisos de butim"
L["Disable screen effects"] = "Efeitos de tela"
L["Disable screen glow"] = "Brilho da tela"
L["Disable sticky chat"] = "Bate-papo pegajoso"
L["Drag the frame overlay to position the frame."] = "Arraste a sobreposição do quadro para posicionar o quadro."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Arraste as sobreposições de quadros para posicionar os quadros.|n|nPara alterar a escala de um quadro, clique nele para selecioná-lo e ajuste o controle deslizante da escala.|n|nThis panel will close automatically if you enter combat."
L["Drag to set the buffs frame scale."] = "Arrasta para definir a escala do quadro de buffs."
L["Drag to set the cursor X offset."] = "Arraste para definir o deslocamento X do cursor."
L["Drag to set the cursor Y offset."] = "Arraste para definir o deslocamento Y do cursor."
L["Drag to set the density of weather effects."] = "Arraste para definir a densidade dos efeitos climáticos."
L["Drag to set the font size of book text."] = "Arraste para definir o tamanho da fonte do texto do livro."
L["Drag to set the font size of mail text."] = "Arraste para definir o tamanho da fonte do texto do correio."
L["Drag to set the font size of quest text."] = "Arraste para definir o tamanho da fonte do texto da missão."
L["Drag to set the scale of the Leatrix Plus panel."] = "Arraste para definir a escala do painel Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Arraste para definir a escala do quadro selecionado."
L["Drag to set the size of the bottom border."] = "Arraste para definir o tamanho da borda inferior."
L["Drag to set the size of the left border."] = "Arraste para definir o tamanho da borda esquerda."
L["Drag to set the size of the right border."] = "Arraste para definir o tamanho da borda direita."
L["Drag to set the size of the top border."] = "Arraste para definir o tamanho da borda superior."
L["Drag to set the tooltip scale."] = "Arraste para definir a escala da dica de ferramenta."
L["Drag to set the transparency of the borders."] = "Arraste para definir a transparência das bordas."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Arraste para definir a transparência do painel Leatrix Plus."
L["Dun Morogh"] = "Dun Morogh"
L["Dungeons"] = "Masmorras"
L["Dup ID"] = "ID Dup"
L["durability"] = "durabilidade"
L["Durability"] = "Durabilidade"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Floresta do Crepúsculo"
L["Dustwallow Marsh"] = "Pântano Vadeoso"
L["Eastern Kingdoms"] = "Reinos do Leste"
L["Eastern Plaguelands"] = "Terras Pestilentas Orientais"
L["Easy item destroy"] = "Fácil remoção de itens"
L["ELITE"] = "ELITE"
L["Elwynn Forest"] = "Floresta de Elwynn"
L["Enable viewport"] = "Porta de visualização"
L["Enhance dressup"] = "Provador"
L["Enhance minimap"] = "Minimapa"
L["Enhance professions"] = "Profissões"
L["Enhance quest log"] = "Registro de missões"
L["Enhance tooltip"] = "Dica de ferramenta"
L["Enhance trainers"] = "Instrutores"
L["Enhancements"] = "Melhorias"
L["Enter"] = "Entrar"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class."] = "Entra os IDs do feitiço dos ícones de recarga que você deseja ver.|n|nSe um ícone de recarga normalmente aparecer embaixo do quadro do ajudante, marque a caixa de seleção ajudante.|n|nOs ícones de recarga são salvos na sua classe."
L["enter zone or track name"] = "entrar o nome da zona ou faixa"
L["Error messages will be hidden"] = "Mensagens de erro serão ocultadas"
L["Error messages will be shown"] = "Mensagens de erro serão mostradas"
L["Events"] = "Eventos"
L["Everlook"] = "Visteterna"
L["Eversong Woods"] = "Floresta do Canto Eterno"
L["Extras"] = "Extras"
L["False"] = "Falso"
L["Faster auto loot"] = "Saque rápido"
L["Faster movie skip"] = "Pular filme mais rápido"
L["Feathermoon"] = "Plumaluna"
L["Features"] = "Características"
L["Felwood"] = "Selva Maleva"
L["Feralas"] = "Feralas"
L["Fight for Warsong Gulch"] = "Luta pela Ravina Brado Guerreiro"
L["Find Item"] = "Encontrar objeto"
L["Firewing Signets"] = "Sinetes dos Asardente"
L["Flame Crest"] = "Monte Candente"
L["For Great Honor"] = "Por grande honra"
L["Frames"] = "Quadros"
L["Freewind Post"] = "Aldeia Vento Livre"
L["Frostmaul E'ko"] = "E'ko de Friomalho"
L["Frostsaber E'ko"] = "E'ko de sabre-de-gelo"
L["Gadgetzan"] = "Geringontzan"
L["Game Options"] = "Opções de jogo"
L["Ghost"] = "Fantasma"
L["Ghostlands"] = "Terra Fantasma"
L["Gloomy"] = "Sombrio"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Apenas ouro"
L["Graphics and Sound"] = "Gráficos e som"
L["Groups"] = "Grupos"
L["Gurubashi, Vilebranch, and Witherbark Coins"] = "As moedas Cascasseca, Ramatorpe e Gurubashi"
L["H"] = "H"
L["Hammerfall"] = "Ruína do Martelo"
L["Haunted"] = "Assombrado"
L["Hellfire Peninsula"] = "Península Fogo do Inferno"
L["Hellfire Ramparts"] = "Muralha Fogo do Inferno"
L["Helm"] = "Elmo"
L["Help"] = "Ajuda"
L["Hide chat buttons"] = "Botões de bate-papo"
L["Hide cooldown duration numbers (if enabled)"] = "Ocultar números de duração da recarga (se ativado)"
L["Hide error messages"] = "Mensagens de erro"
L["Hide gryphons"] = "Grifos"
L["Hide portrait numbers"] = "Números de retrato"
L["Hide stance bar"] = "Barra de postura"
L["Hide the combat log"] = "Registro de combate"
L["Hide the zone text bar"] = "Ocultar a barra de texto da zona"
L["Hide the zoom buttons"] = "Ocultar os botões de zoom"
L["Hide tooltips for world units during combat"] = "Ocultar dicas de ferramentas para unidades mundiais durante o combate"
L["Hide zone text"] = "Texto da zona"
L["High"] = "Alto"
L["Hillsbrad Foothills"] = "Contraforte de Eira dos Montes"
L["Hinterlands"] = "Terras Agrestes"
L["Home"] = "Principal"
L["Hyjal Summit"] = "Pico Hyjal"
L["Ice Thistle E'ko"] = "E'ko de cardo de gelo"
L["If checked, a bag search box will be shown in the backpack frame and the bank frame."] = "Se marcado, uma caixa de pesquisa de bolsas será mostrada no quadro da mochila e no quadro do banco."
L["If checked, a button will be added to the character frame which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Se marcado, um botão será adicionado à ficha de personagem que mostrará a durabilidade do objeto equipado quando você passar o cursor sobre ele.|n|nAlém disso, uma porcentagem geral será mostrada no quadro de bate-papo quando você morrer."
L["If checked, a master volume slider will be shown in the character frame."] = "Se marcado, um controle deslizante de volume principal será mostrado na folha do personagem."
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction duration setting will be saved account-wide."] = "Se marcado, funcionalidades adicionais serão adicionadas à casa de leilões.|n|nSomente compra - crie leilões de compra sem preencher o preço inicial.|n|nSomente ouro - defina os preços do cobre e da prata em 99 para acelerar novos leilões.|n|nLocalizar objeto - pesquise na casa de leilões o objeto que você está vendendo.|n|nAlém disso, a configuração de duração do leilão será salva em toda a conta."
L["If checked, alert frames will not be shown."] = "Se marcado, os quadros de alerta não serão mostrados."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Se marcado, todos os objetos de pobre qualidade em suas bolsas serão vendidos automaticamente quando você visitar um comerciante.|n|nVocê pode manter pressionada a tecla Shift ao conversar com um comerciante para substituir essa configuração."
L["If checked, available quests will be accepted automatically."] = "Se marcada, as missões disponíveis serão aceitas automaticamente."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Se marcado, o fundo será colorido em azul (amigável) ou vermelho (hostil)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Se marcado, as solicitações de confirmação de amigo do BattleTag e do Real ID serão automaticamente recusadas.|n|nA ativação desta opção recusará automaticamente quaisquer solicitações pendentes."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Se marcado, os botões do quadro de bate-papo serão ocultados.|n|nClicar nas guias de bate-papo mostrará automaticamente as mensagens mais recentes.|n|nUse a roda do mouse para rolar pelo histórico de bate-papo. Mantenha pressionada a tecla Shift para pular a página ou Ctrl para pular para a parte superior ou inferior do histórico de bate-papo."
L["If checked, chat text will not fade out after a time period."] = "Se marcado, o texto do bate-papo não desaparecerá após um período de tempo."
L["If checked, class colors will be used in the chat frame."] = "Se marcado, as cores da classe serão usadas no quadro de bate-papo."
L["If checked, completed quests will be turned-in automatically."] = "Se marcada, as missões concluídas serão entregues automaticamente."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Se marcado, as confirmações não aparecerão mais quando você escolher uma opção de saque ou tentar vender ou enviar um objeto comercializável."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Se marcado, os números de duração da recarga não serão mostrados sobre as recargas.|n|nSe desmarcada, os números de duração da recarga serão exibidos sobre as recargas, se estiverem ativados no painel de opções do jogo (menu 'Barras de ação')."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Se marcado, os números de dano e cura nos quadros de retrato do jogador e do ajudante serão ocultados."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Se marcado, arrastar a guia Geral enquanto o quadro estiver bloqueado expandirá o quadro para cima.|n|nSe o quadro de bate-papo estiver desbloqueado, arrastar a guia Geral do bate-papo moverá o quadro de bate-papo."
L["If checked, emote sounds will be silenced while your character is resting or at the Grim Guzzler.|n|nEmote sounds will be enabled at all other times."] = "Se marcado, os sons de emote serão silenciados enquanto seu personagem estiver descansando ou no Glutão Implacável.|n|nOs sons de emoção serão ativados em todos os outros momentos."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Se marcado, as placas de nomes do inimigo serão mostradas durante o combate e ocultas quando o combate terminar."
L["If checked, helm and cloak toggle checkboxes will be shown in the character frame.|n|nYou can hold shift and right-click the checkboxes to switch layouts."] = "Se marcado, as caixas de seleção de elmo e capa serão mostradas na folha do personagem.|n|nVocê pode pressionar Shift e clicar com o botão direito do mouse nas caixas de seleção para mudar a disposição."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Se marcado, o bate-papo raide e o bate-papo da instância terão a cor azul (para corresponder à cor padrão do bate-papo de grupo)."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Se marcado, os IDs de feitiço serão mostrados nas dicas de ferramentas dos ícones de buffs localizados no quadro de buff e abaixo do quadro de alvo."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Se marcado, o bate-papo pegajoso será desativado.|n|nObserve que isso não se aplica a janelas de bate-papo temporárias."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Se marcado, os solicitações de evocação serão aceitos automaticamente, a menos que você esteja em combate."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Se marcada, a lista de addons (acessível no menu do jogo) mostrará addons baseados em personagens por padrão."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Se marcado, a quantidade de tempo que leva para saquear criaturas automaticamente será significativamente reduzida."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Se marcado, o botão de limpeza da mochila e o botão de limpeza do banco não serão mostrados."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Se marcado, o botão para alternar o quadro de contêiner de raide será mostrado logo acima do quadro de gerenciamento de raide (lado esquerdo da tela) em vez de no próprio quadro de gerenciamento de raide.|n|nIsso permite que você alterne o quadro de contêiner de raide, sem precisar abrir o quadro de gerenciamento de raide."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Se marcado, o registro de combate será oculto.|n|nO registro de combate deve estar ancorado para que esta opção funcione.|n|nSe o registro de combate estiver desencaixado, você poderá encaixá-lo arrastando a guia (e recarregando a interface do usuário) ou redefinindo as janelas de bate-papo (no menu de bate-papo)."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Se marcada, a caixa de edição será movida para a parte superior do quadro de bate-papo."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Se marcado, a tela cinza da morte e o efeito submundo serão desativados."
L["If checked, the main bar gryphons will not be shown."] = "Se marcado, os grifos da barra principal não serão mostrados."
L["If checked, the number of free bag slots will be shown in the backpack button icon and tooltip."] = "Se marcado, o número de compartimentos de bolsa vazios será mostrado no ícone do botão da mochila e na dica de ferramenta."
L["If checked, the player frame background will be shown in class color."] = "Se marcado, o fundo do quadro do jogador será mostrado na cor da classe."
L["If checked, the professions frame will be larger."] = "Se marcado, o quadro de profissões será maior."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Se marcado, o brilho da tela será desativado.|n|nA ativação dessa opção também desativará o efeito de neblina bêbado."
L["If checked, the stance bar will not be shown."] = "Se marcada, a barra de postura não será mostrada."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Se marcado, o quadro de diálogo não será mostrado.|n|nO quadro de diálogo normalmente aparece na parte inferior da tela quando certos PNJs se comunicam com você."
L["If checked, the target frame background will be shown in class color."] = "Se marcado, o fundo do quadro de alvo será mostrado na cor da classe."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Se marcado, a dica de ferramenta será codificada por cores e você poderá modificar a disposição e a escala da dica de ferramenta."
L["If checked, the vendor price will be shown in item tooltips."] = "Se marcado, o preço do comerciante será mostrado nas dicas de ferramentas do objeto."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Se marcado, os botões de zoom serão ocultados. Você pode usar o botão do mouse para aplicar zoom, independentemente desta configuração."
L["If checked, unit targets will be shown."] = "Se marcado, os alvos da unidade serão mostrados."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Se marcado, você pode manter pressionada a tecla Control e clicar em uma guia de bate-papo para exibir o bate-papo recente em uma janela de cópia amigável."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Se marcado, você pode pressionar as teclas de flecha para mover o ponto de inserção para a esquerda e para a direita no quadro de bate-papo.|n|nSe desmarcado, as teclas de flecha usarão a configuração padrão de ligação de teclas."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Se marcado, você poderá cancelar o cinema sem ser solicitado a confirmar."
L["If checked, you will be able to change the font size of book text."] = "Se marcado, você poderá alterar o tamanho da fonte do texto do livro."
L["If checked, you will be able to change the font size of quest text."] = "Se marcado, você poderá alterar o tamanho da fonte do texto da missão."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Se marcado, você poderá alterar o tamanho da fonte do texto de correio padrão.|n|nIsso não afeta as mensagens criadas usando modelos (como faturas da casa de leilões)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Se marcado, você poderá alterar a posição e a escala do quadro de buffs."
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "Se marcado, você poderá alterar a posição e a escala do quadro do widget.|n|nO quadro do widget é comumente usado para mostrar pontuações JxJ e objetivos de rastreamento."
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Se marcado, você poderá criar uma porta de visualização. Uma porta de visualização adiciona bordas pretas ajustáveis ​​ao redor do mundo do jogo.|n|nAs bordas são colocadas no topo do mundo do jogo, mas sob a interface do usuário, para que você possa colocar elementos da interface do usuário sobre elas."
L["If checked, you will be able to customise the minimap."] = "Se marcado, você poderá personalizar o minimapa."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Se marcado, você poderá arrastar o quadro de bate-papo para a borda da tela."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Se marcado, você poderá colocar até cinco ícones de recarga benéficos acima do quadro de alvo."
L["If checked, you will be able to reposition the tooltip."] = "Se marcado, você poderá reposicionar a dica de ferramenta."
L["If checked, you will be able to set the density of weather effects."] = "Se marcado, você poderá definir a densidade dos efeitos climáticos."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Se marcado, você poderá mostrar uma cadeia rara, elite ou elite rara em torno do quadro do jogador."
L["If checked, you will be able to zoom out to a greater distance."] = "Se marcado, você poderá diminuir o zoom para uma distância maior."
L["If checked, you will no longer need to type delete when destroying a superior quality item.|n|nIn addition, item links will be shown in all item destroy confirmation windows."] = "Se marcado, você não precisará mais digitar delete ao destruir um item de qualidade superior.|n|nAlém disso, os links de itens serão mostrados em todas as janelas de confirmação de destruição de itens."
L["If checked, you will release automatically after you die in a battleground.|n|nYou will not release automatically if you have the ability to self-resurrect."] = "Se marcado, você será liberado automaticamente após a morte em um campo de batalha.|n|nVocê não será liberado automaticamente se tiver a capacidade de ressuscitar automaticamente."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Se marcado, seu histórico de bate-papo aumentará para 4096 linhas. Se desmarcado, o padrão será usado (128 linhas).|n|nA ativação dessa opção pode impedir a exibição de algum texto de bate-papo durante a conexão."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Se marcado, seu equipamento será reparado automaticamente quando você visitar um comerciante adequado.|n|nVocê pode manter pressionada a tecla Shift ao conversar com um comerciante para substituir essa configuração."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Se marcado, o texto da zona não será exibido (por exemplo, 'Altaforja')."
L["Increase chat history"] = "Aumentar histórico"
L["Interface"] = "Interface"
L["Invaders of Alterac Valley"] = "Invasores do Vale Alterac"
L["Invalid console variable."] = "Variável de console inválida."
L["Invalid parameter."] = "Parâmetro inválido."
L["Invalid quest ID."] = "ID de missão inválido."
L["Invalid sound ID"] = "ID de som inválido"
L["Invalid taint level."] = "Nível de mancha inválido."
L["Invalid target."] = "Alvo inválido."
L["Invite from whispers"] = "Convidar de sussurros"
L["Ironforge"] = "Altaforja"
L["Kalimdor"] = "Kalimdor"
L["Karazhan"] = "Karazhan"
L["Kargath"] = "Karrath"
L["Keyword"] = "Palavra-chave"
L["Lakeshire"] = "Vila Plácida"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "O Leatrix Plus não substituirá o LeaPlusDB na próxima desconexão."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: VERSÃO ERRADA INSTALADA!"
L["Left"] = "Esquerdo"
L["Lifetime honorable kills"] = "Jogadores abatidos honrosamente da vida inteira"
L["Light's Hope Chapel"] = "Capela Esperança da Luz"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Bloquear compartilhamento"
L["Low"] = "Baixo"
L["Magic"] = "Magia"
L["Magisters' Terrace"] = "Terraço dos Magísteres"
L["Main Titles"] = "Principais Títulos"
L["Manage buffs"] = "Gerenciar buffs"
L["Manage frames"] = "Gerenciar quadros"
L["Manage widget"] = "Gerenciar widget"
L["Managed by Leatrix Plus"] = "Gerenciado por Leatrix Plus"
L["Map"] = "Mapa"
L["Maraudon"] = "Maraudon"
L["Marks of Kil'jaeden"] = "Marca de Kil'Jaeden"
L["Marks of Sargeras"] = "Marcas de Sargeras"
L["Marshal's Refuge"] = "Refúgio do Marshal"
L["Max camera zoom"] = "Zoom máximo da câmera"
L["Mechanics"] = "Mecânico"
L["Media"] = "Mídia"
L["Medium"] = "Médio"
L["Memory Usage"] = "Uso de memória"
L["Menethil Harbor"] = "Porto de Menethil"
L["message shown."] = "mensagem mostrada."
L["messages shown."] = "mensagens mostradas."
L["Missing console variable."] = "Variável de console ausente."
L["Missing mount name."] = "Nome de montaria ausente."
L["Missing movie ID."] = "ID do filme ausente."
L["Missing quest ID."] = "ID da missão ausente."
L["Missing sound file parameter."] = "Parâmetro de arquivo de som ausente."
L["Missing sound ID."] = "ID de som ausente."
L["Molten Core"] = "Núcleo Derretido"
L["Moonglade"] = "Clareira da Lua"
L["More Firewing Signets"] = "Mais sinetes dos Asardente"
L["More Marks of Kil'jaeden"] = "Mais marcas de Kil'jaeden"
L["More Marks of Sargeras"] = "Mais marcas de Sargeras"
L["More Sunfury Signets"] = "Mais sinetes dos Solfúria"
L["Morgan's Vigil"] = "Vigia de Morgan"
L["Mount not found."] = "Montaria não encontrada."
L["Move editbox to top"] = "Caixa de edição"
L["Movie not playable."] = "Filme não reproduzível."
L["Movie number"] = "Número do filme"
L["Movies"] = "Filmes"
L["Mulgore"] = "Mulgore"
L["Music"] = "Música"
L["Musical Moments"] = "Momentos musicais"
L["Mystery"] = "Mistério"
L["Nagrand"] = "Nagrand"
L["Narration"] = "Narração"
L["Naxxramas"] = "Naxxramas"
L["Nethergarde Keep"] = "Bastilha de Etergarde"
L["Netherstorm"] = "Eternévoa"
L["Nijel's Point"] = "Posto do Nijel"
L["No bad sound IDs found."] = "Nenhum ID de som ruim encontrado."
L["No help is available for this page."] = "Nenhuma ajuda está disponível para esta página."
L["No items with durability equipped."] = "Nenhum objeto com durabilidade equipada."
L["No media duplicates found."] = "Nenhuma duplicata de mídia encontrada."
L["No tooltip showing."] = "Nenhuma dica de ferramenta sendo exibida."
L["None"] = "Nenhum"
L["Not completed."] = "Não completo."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "AVISO!|nVocê deve reiniciar completamente o cliente do jogo antes de poder usar esta versão do Leatrix Plus."
L["Nude"] = "Nu"
L["Old Hillsbrad Foothills"] = "Antigo Contraforte de Eira dos Montes"
L["Onyxia's Lair"] = "Covil da Onyxia"
L["or click the minimap button to open Leatrix Plus."] = "ou clique no botão minimapa para abrir o Leatrix Maps."
L["Orgrimmar"] = "Orgrimmar"
L["Outland"] = "Terralém"
L["Overall"] = "Total"
L["Overlay"] = "Sobreposição"
L["Particle density"] = "Densidade de partículas"
L["Party from friends"] = "Grupo de amigos"
L["Pet"] = "Ajudante"
L["Player"] = "Jogador"
L["Power"] = "Poder"
L["Press CTRL/C to copy."] = "Pressione Ctrl+C para copiar."
L["Queue from friends"] = "Fila de amigos"
L["R"] = "R"
L["Ragefire Chasm"] = "Cavernas Ígneas"
L["Raid"] = "Raide"
L["Raid frame toggle"] = "Quadro de raide"
L["Random"] = "Aleatório"
L["RARE"] = "RARO"
L["RARE ELITE"] = "ELITE RARO"
L["Ratchet"] = "Vila Catraca"
L["Razorfen Downs"] = "Urzal dos Mortos"
L["Razorfen Kraul"] = "Urzal dos Tuscos"
L["Recent chat window"] = "Bate-papo recente"
L["Redridge Mountains"] = "Montanhas Cristarrubra"
L["Refuge Pointe"] = "Ponta do Refúgio"
L["Release in PvP"] = "Libertar em JxJ"
L["Reload"] = "Recarregar"
L["Remember Alterac Valley!"] = "Lembrem-se do Vale Alterac!"
L["Repair automatically"] = "Reparar"
L["Repaired for"] = "Reparado para"
L["Reposition the tooltip"] = "Reposicionar a dica de ferramenta"
L["Requires UI reload."] = "Requer atualização da interface do usuário."
L["Reset"] = "Redefinir"
L["Resize book text"] = "Texto do livro"
L["Resize mail text"] = "Texto do correio"
L["Resize quest text"] = "Texto da missão"
L["Resize Screen"] = "Redimensionar tela"
L["Rested bubbles"] = "Bolhas descansadas"
L["result"] = "resultado"
L["results"] = "resultados"
L["Revantusk Village"] = "Aldeia Revatusco"
L["Right"] = "Direito"
L["Right-click to close"] = "Clique com o botão direito para fechar"
L["Right-click to close."] = "Clique com o botão direito para fechar"
L["right-click to go back"] = "clique com o botão direito para voltar"
L["Ruins of Ahn'Qiraj"] = "Ruínas de Ahn'Qiraj"
L["Rut'theran Village"] = "Vila de Rut'theran"
L["Sacred"] = "Sagrado"
L["Sandfury, Skullsplitter, and Bloodscalp Coins"] = "As moedas Sanguescalpo, Rachacrânio e Zangareia"
L["Scale"] = "Escala"
L["Scarlet Monastery"] = "Monastério Escarlate"
L["Scholomance"] = "Scolomântia"
L["Search"] = "Procurar"
L["Searing Gorge"] = "Garganta Abrasadora"
L["Select the settings that you want to use."] = "Selecione as configurações que você deseja usar."
L["Selection of music tracks"] = "Seleção de faixas de música"
L["Self Markers Allowed"] = "Marcadores auto permitidos"
L["Self Markers Blocked"] = "Marcadores auto bloqueados"
L["Sell junk automatically"] = "Vender objetos pobres"
L["SELLING JUNK"] = "Vendendo objetos de pobre qualidade"
L["Sentinel Hill"] = "Morro da Sentinela"
L["Set weather density"] = "Densidade do tempo"
L["Settings"] = "Configurações"
L["Shaders"] = "Shaders"
L["Shadowfang Keep"] = "Bastilha da Presa Negra"
L["Shadowmoon Valley"] = "Vale da Lua Negra"
L["Shadowprey Village"] = "Aldeia Pescassombra"
L["Shardtooth E'ko"] = "E'ko de Dentilhaço"
L["Show auction controls"] = "Casa de leilões"
L["Show bag search box"] = "Pesquisa de bolsas"
L["Show character addons"] = "Addons do personagem"
L["Show cooldowns"] = "Recargas"
L["Show cooldowns above the player frame"] = "Mostrar recarga acima do quadro do jogador"
L["Show durability status"] = "Durabilidade"
L["Show free bag slots"] = "Compartimentos de bolsa vazios"
L["Show guild names"] = "Mostrar nomes de guilda"
L["Show minimap button"] = "Botão minimapa"
L["Show player chain"] = "Cadeia de jogador"
L["Show player frame in class color"] = "Mostrar quadro do jogador na cor da classe"
L["Show raid button"] = "Mostrar botão da raide"
L["Show the spell ID in buff icon tooltips"] = "Mostrar o ID do feitiço nas dicas de ferramentas do ícone de buff"
L["Show unit targets"] = "Mostrar alvos de unidade"
L["Show vanity controls"] = "Personalizados"
L["Show vendor price"] = "Preço do comerciante"
L["Show volume slider"] = "Volume"
L["Show Wowhead links"] = "Links do Wowhead"
L["Silence rested emotes"] = "Silenciar emotes descansados"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Floresta de Pinhaprata"
L["Single Mark of Sargeras"] = "Marca única de Sargeras"
L["Single Sunfury Signet"] = "Sinete único dos Solfúria"
L["Social"] = "Social"
L["Sold junk for"] = "Vendeu objetos de pobre qualidade por"
L["Sound system restarted."] = "Sistema de som reiniciado."
L["Southshore"] = "Costa Sul"
L["Spell ID"] = "ID do feitiço"
L["Splintertree Post"] = "Posto Machadada"
L["Spooky"] = "Assustador"
L["Stockade"] = "O Cárcere"
L["Stonard"] = "Pedregal"
L["Stonetalon Mountains"] = "Cordilheira das Torres de Pedra"
L["Stonetalon Peak"] = "Morro das Torres de Pedra"
L["Stop"] = "Pare"
L["Stormwind"] = "Ventobravo"
L["Stranglethorn Vale"] = "Selva do Espinhaço"
L["Stratholme"] = "Stratholme"
L["Sun Rock Retreat"] = "Retiro Rocha do Sol"
L["Sunfury Signets"] = "Sinetes dos Solfúria"
L["Sunken Temple"] = "Templo Submerso"
L["Sunwell Plateau"] = "Platô da Nascente do Sol"
L["Support"] = "Suporte"
L["Swamp"] = "Pântano"
L["Swamp of Sorrows"] = "Pântano das Mágoas"
L["System"] = "Sistema"
L["Tabard"] = "Tabardo"
L["Taint level: Basic (1)."] = "Nível de mancha: Básico (1)."
L["Taint level: Disabled (0)."] = "Nível de mancha: desativado (0)."
L["Taint level: Full (2)."] = "Nível de mancha: Completo (2)."
L["Talonbranch Glade"] = "Clareira da Galhaça"
L["Talrendis Point"] = "Campo Talrendis"
L["Tanaris"] = "Tanaris"
L["Target"] = "Alvo"
L["Target Tracking Disabled"] = "Rastreamento de alvo desativado"
L["Target Tracking Enabled"] = "Rastreamento de alvo ativado"
L["Tarren Mill"] = "Serraria Tarren"
L["Teldrassil"] = "Teldrassil"
L["Tempest Keep"] = "Bastilha da Tormenta"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Ten Years of Warcraft"] = "Dez anos de Warcraft"
L["Terokkar Forest"] = "Mata Terokkar"
L["Text"] = "Texto"
L["Text size"] = "Tamanho do texto"
L["Text Size"] = "Tamanho do texto"
L["The Sepulcher"] = "O Sepulcro"
L["The summon from"] = "A evocação de"
L["Themes"] = "Temas"
L["This panel will close automatically if you enter combat."] = "Este painel será fechado automaticamente se você entrar em combate."
L["Thorium Point"] = "Posto de Tório"
L["Thousand Needles"] = "Mil Agulhas"
L["Thunder Bluff"] = "Penhasco do Trovão"
L["Timer"] = "Cronômetro"
L["Tirisfal Glades"] = "Clareiras de Tirisfal"
L["To begin, choose an options page."] = "Para começar, escolha uma página de opções."
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "Para ocultar o registro de combate, você precisa desativar o módulo de bate-papo no ElvUI."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Para usar o botão Encontrar objeto, você precisa desmarcar a categoria WoW Token."
L["Tooltip"] = "Dica de ferramenta"
L["Tooltip title color"] = "Cor do título da dica de ferramenta"
L["Top"] = "Topo"
L["Top Center"] = "Topo central"
L["Tracing started."] = "Rastreamento iniciado."
L["Tracing stopped."] = "Rastreamento parou."
L["Transparency"] = "Transparência"
L["True"] = "Verdade"
L["Turn-in completed quests automatically"] = "Entregar missões concluídas automaticamente"
L["Uldaman"] = "Uldaman"
L["Unclamp chat frame"] = "Desatar quadro"
L["Undercity"] = "Cidade Baixa"
L["Un'Goro Crater"] = "Cratera Un'Goro"
L["Universal group color"] = "Cor do grupo universal"
L["Use arrow keys in chat"] = "Teclas de flecha"
L["Use class colors in chat"] = "Cores da classe"
L["Use easy resizing"] = "Redimensionamento"
L["Value must be a number."] = "O valor deve ser um número."
L["Various"] = "Vários"
L["Vendors"] = "Comerciantes"
L["Version"] = "Versão"
L["Very Low"] = "Muito baixo"
L["Video"] = "Vídeo"
L["Visibility"] = "Visibilidade"
L["Wailing Caverns"] = "Caverna Ululante"
L["was automatically declined."] = "foi recusado automaticamente."
L["Weather density"] = "Densidade do tempo"
L["Welcome to Leatrix Plus."] = "Bem-vindo ao Leatrix Plus."
L["Western Plaguelands"] = "Terras Pestilentas Ocidentais"
L["Westfall"] = "Cerro Oeste"
L["Wetlands"] = "Pantanal"
L["Widget"] = "Ferramenta"
L["Wildkin E'ko"] = "E'ko de coruscante"
L["will be automatically accepted in 10 seconds unless cancelled."] = "será aceito automaticamente em 10 segundos, a menos que seja cancelado."
L["Winter"] = "Inverno"
L["Winterfall E'ko"] = "E'ko de invernoso"
L["Winterspring"] = "Hibérnia"
L["World of Warcraft"] = "World of Warcraft"
L["X Offset"] = "Deslocamento X"
L["Y Offset"] = "Deslocamento Y"
L["YOU"] = "VOCÊ"
L["You cannot do that in combat."] = "Você não pode fazer isso em combate."
L["You have"] = "Você tem"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Sua interface do usuário precisa ser recarregada para que algumas alterações entrem em vigor.|n|nVocê não precisa clicar no botão recarregar imediatamente, mas precisa clicar nele quando concluir as alterações e desejar que as alterações entrem em vigor."
L["Your UI needs to be reloaded."] = "Sua interface do usuário precisa ser recarregada."
L["Zangarmarsh"] = "Pântano Zíngaro"
L["Zones"] = "Zonas"
L["Zoram'gar Outpost"] = "Assentamento Zoram'gar"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zulian, Razzashi, and Hakkari Coins"] = "As moedas Hakkari, Zulian e Razzashi"
L["Zygor addon not found."] = "Addon Zygor não encontrado."

end
