﻿
	----------------------------------------------------------------------
	-- Leatrix Maps Reveal Data
	----------------------------------------------------------------------

	local void, Leatrix_Maps = ...
	local L = Leatrix_Maps.L

	Leatrix_Maps["Reveal"] = {

		----------------------------------------------------------------------
		-- World of Warcraft
		----------------------------------------------------------------------

		--[[1411: Durotar]]
		[1194] = {
			["162:157:399:440"] = "440583", 
			["192:184:457:406"] = "271426", 
			["208:157:438:0"] = "271427", 
			["210:200:462:298"] = "271440", 
			["220:218:295:48"] = "271439", 
			["224:227:431:157"] = "271421", 
			["236:196:415:60"] = "271428", 
			["244:222:282:174"] = "440584", 
			["248:158:302:264"] = "271422", 
			["254:258:304:312"] = "271443, 440585", 
			["259:165:309:0"] = "271435, 271442, 271435, 271442", 
			["330:255:429:413"] = "271437, 440582",
		},

		--[[1412: Mulgore]]					
		[1200] = {
			["172:205:248:321"] = "272176", 
			["174:185:449:340"] = "272180", 
			["186:185:514:43"] = "272169", 
			["186:216:448:101"] = "272177", 
			["187:165:435:224"] = "272185", 
			["190:172:331:0"] = "272172", 
			["201:167:333:202"] = "272178", 
			["208:300:530:138"] = "272186, 457475", 
			["218:192:226:220"] = "272181", 
			["222:202:400:0"] = "272179", 
			["237:184:201:0"] = "457473", 
			["260:243:527:291"] = "272170, 457474", 
			["302:223:319:273"] = "272173, 457470", 
			["373:259:208:62"] = "272187, 272171, 457476, 457477", 
			["446:264:286:401"] = "272168, 272165, 457471, 457472",
		},

		--[[1413: The Barrens]]				
		[1202] = {
			["207:332:555:129"] = "270569, 438215", 
			["219:175:547:379"] = "270585", 
			["233:193:362:275"] = "270559", 
			["239:231:481:254"] = "270574", 
			["241:195:290:104"] = "270554", 
			["243:217:448:127"] = "270584", 
			["257:249:403:6"] = "270564, 438223", 
			["261:216:258:6"] = "438216, 438217", 
			["278:209:511:7"] = "270553, 438214", 
			["283:270:116:57"] = "270572, 438218, 438219, 438220", 
			["315:212:556:456"] = "270573, 438222", 
			["336:289:344:379"] = "270565, 438224, 438225, 438226", 
			["377:325:152:318"] = "438227, 438228, 438229, 438230", 
			["446:256:100:208"] = "270560, 438221",
		},

		--[[1417: Arathi Highlands]]		
		[1206] = {
			["183:238:506:126"] = "270360", 
			["196:270:293:145"] = "270352, 438180", 
			["210:227:404:144"] = "270350", 
			["212:305:0:144"] = "438173, 438174", 
			["215:188:332:273"] = "438169", 
			["220:287:85:24"] = "270347, 438168", 
			["227:268:132:105"] = "270351, 438179", 
			["228:227:201:312"] = "270346", 
			["237:252:261:416"] = "270348", 
			["249:278:171:123"] = "270349, 438167", 
			["252:258:327:367"] = "270342, 438166", 
			["260:220:476:359"] = "270353, 438184", 
			["270:271:581:118"] = "270336, 438176, 438177, 438178", 
			["273:268:77:400"] = "270361, 438170, 438171, 438172", 
			["284:306:21:269"] = "270358, 438181, 438182, 438183", 
			["306:248:430:249"] = "270343, 438175",
		},

		--[[1418: Badlands]]				
		[1207] = {
			["209:196:411:116"] = "270532", 
			["214:285:144:99"] = "270525, 270521", 
			["236:260:504:19"] = "270530, 442231", 
			["252:353:0:66"] = "270529, 442225, 270529, 442225", 
			["266:210:336:0"] = "442238, 442239", 
			["274:448:407:220"] = "270540, 270527, 442226, 442227", 
			["285:223:230:68"] = "270543, 442224", 
			["328:313:175:178"] = "442232, 442233, 442234, 442235", 
			["339:347:0:281"] = "270520, 442228, 442229, 442230", 
			["342:353:230:315"] = "270522, 270550, 270528, 270536", 
			["469:613:533:55"] = "270534, 270551, 270546, 270535, 442236, 442237",
		},

		--[[C1419: Blasted Lands]] 			
		[1209] = {
			["168:170:375:102"] = "391431", 
			["195:199:436:0"] = "438233", 
			["199:191:333:474"] = "438238", 
			["218:183:459:97"] = "391430", 
			["233:266:386:374"] = "438236, 438237", 
			["235:188:327:182"] = "391434", 
			["238:195:225:110"] = "391425", 
			["240:270:578:91"] = "438234, 438235", 
			["268:354:533:268"] = "438243, 438244, 438245, 438246", 
			["272:206:258:0"] = "391435, 438231", 
			["295:205:530:6"] = "391432, 438232", 
			["308:226:144:175"] = "391429, 391428", 
			["348:357:132:311"] = "438247, 438248, 438249, 438250", 
			["370:298:368:179"] = "438239, 438240, 438241, 438242",
		},

		--[[1420: Tirisfal Glades]]			
		[1210] = {
			["161:234:692:99"] = "272996", 
			["175:210:686:232"] = "273000", 
			["179:169:389:255"] = "440917", 
			["190:214:477:129"] = "273020", 
			["199:182:480:252"] = "273015", 
			["210:292:573:122"] = "273009, 273002", 
			["212:177:418:317"] = "273016", 
			["225:281:347:325"] = "273003, 440921", 
			["242:179:594:324"] = "273006", 
			["250:279:752:150"] = "272999, 440935", 
			["262:262:740:47"] = "440926, 440927, 440928, 440929", 
			["285:260:324:90"] = "273019, 440914, 440915, 440916", 
			["286:225:201:192"] = "273017, 440930", 
			["293:338:709:330"] = "440931, 440932, 440933, 440934", 
			["390:267:423:359"] = "440922, 440923, 440924, 440925", 
			["431:407:9:207"] = "273001, 440918, 440919, 440920",
		},

		--[[1421: Silverpine Forest]]		
		[1211] = {
			["152:189:433:327"] = "440742", 
			["162:172:461:77"] = "440744", 
			["174:199:323:68"] = "440735", 
			["176:152:471:156"] = "440741", 
			["179:165:337:337"] = "272613", 
			["186:238:369:0"] = "440734", 
			["217:198:483:212"] = "272598", 
			["218:200:341:157"] = "272620", 
			["227:172:236:0"] = "272610", 
			["251:167:312:249"] = "272616", 
			["255:180:349:429"] = "440740", 
			["281:345:147:0"] = "440736, 440737, 440738, 440739", 
			["283:243:509:250"] = "272614, 440725", 
			["318:263:505:405"] = "272599, 440726, 440727, 440728", 
			["352:302:581:15"] = "272600, 440729, 440730, 440731", 
			["361:175:445:0"] = "440732, 440733", 
			["409:162:318:506"] = "272609, 440743",
		},

		--[[1422: Western Plaguelands]]		
		[1212] = {
			["169:195:472:332"] = "273102", 
			["185:230:551:151"] = "273121", 
			["194:208:601:390"] = "273107", 
			["241:212:229:228"] = "273113", 
			["241:252:495:213"] = "273094", 
			["290:133:286:211"] = "441018, 441019", 
			["311:436:533:0"] = "273122, 273103, 441023, 441024", 
			["316:316:48:235"] = "273120, 441020, 441021, 441022", 
			["325:192:300:232"] = "441015, 441016", 
			["359:182:231:123"] = "273114, 441017", 
			["368:220:261:448"] = "273108, 273101", 
			["432:271:235:0"] = "273095, 273111, 273100, 273090", 
			["464:325:96:343"] = "441011, 441012, 441013, 441014", 
			["492:314:510:354"] = "273119, 273092, 273112, 273093",
		},

		--[[1423: Eastern Plaguelands]]		
		[1213] = {
			["177:266:595:263"] = "271543, 271530", 
			["181:176:541:184"] = "271542", 
			["182:320:383:348"] = "442692, 442693", 
			["186:213:493:289"] = "271544", 
			["196:220:687:271"] = "271533", 
			["202:191:258:351"] = "271548", 
			["202:202:133:335"] = "271551", 
			["214:254:651:414"] = "271553", 
			["228:273:774:102"] = "442674, 442675", 
			["238:231:382:151"] = "271523", 
			["243:162:391:271"] = "442677", 
			["248:206:211:462"] = "271514", 
			["250:192:401:69"] = "271521", 
			["258:320:0:10"] = "271522, 442685, 442686, 442687", 
			["262:526:0:100"] = "271538, 271513, 442695, 442696, 442697, 442698", 
			["264:373:738:295"] = "442680, 442681, 442682, 442683", 
			["265:232:570:61"] = "271520, 442678", 
			["266:241:462:427"] = "271532, 442676", 
			["274:216:183:211"] = "271536, 442688", 
			["277:175:351:0"] = "271535, 442679", 
			["280:211:56:457"] = "271512, 442694", 
			["286:176:528:0"] = "271554, 442699", 
			["297:299:650:55"] = "271537, 442689, 442690, 442691", 
			["310:178:118:0"] = "271529, 442684", 
			["328:253:144:40"] = "271518, 271527",
		},

		--[[1424: Hillsbrad Foothills]]		
		[1214] = {
			["105:148:390:255"] = "450678", 
			["116:129:344:254"] = "450649", 
			["134:124:463:101"] = "450634", 
			["135:160:426:224"] = "450633", 
			["144:139:200:505"] = "450668", 
			["147:160:425:279"] = "450639", 
			["148:120:413:55"] = "450670", 
			["148:146:484:166"] = "450671", 
			["155:147:451:140"] = "450648", 
			["158:169:321:42"] = "450666", 
			["165:203:494:226"] = "450677", 
			["171:136:359:191"] = "450650", 
			["180:182:287:399"] = "450628", 
			["189:181:347:85"] = "450669", 
			["204:244:502:373"] = "450667", 
			["212:160:441:0"] = "450679", 
			["229:219:383:352"] = "450674", 
			["250:167:194:216"] = "450665", 
			["258:113:341:0"] = "450637, 450638", 
			["269:258:542:410"] = "450640, 450641, 450642, 450643", 
			["275:193:505:44"] = "450675, 450676", 
			["302:175:191:302"] = "450651, 450652, 450651, 450652", -- Double
			["312:254:59:310"] = "450672, 450673", 
			["316:238:102:137"] = "450635, 450636", 
			["437:451:565:217"] = "450644, 450645, 450646, 450647", 
			["447:263:555:68"] = "450629, 450630, 450631, 450632",
		},

		--[[1425: The Hinterlands]]			
		[1215] = {
			["176:235:490:195"] = "271933", 
			["191:278:133:105"] = "271927, 440600", 
			["199:199:390:252"] = "271929", 
			["199:212:286:269"] = "271934", 
			["208:204:367:159"] = "271910", 
			["225:196:357:343"] = "271922", 
			["226:225:152:284"] = "440603", 
			["238:267:0:236"] = "271917, 440597", 
			["240:196:220:379"] = "271937", 
			["241:211:220:181"] = "271928", 
			["244:401:677:267"] = "271938, 271916", 
			["281:261:565:208"] = "271915, 271921, 440601, 440602", 
			["287:289:487:334"] = "271912, 271920, 440598, 440599", 
			["303:311:475:5"] = "271908, 271935, 271936, 271909",
		},

		--[[1426: Dun Morogh]]				
		[1216] = {
			["171:234:397:132"] = "445524, 445524", -- Double
			["174:249:579:306"] = "271401", 
			["184:188:449:220"] = "271417", 
			["198:251:663:288"] = "271408", 
			["211:160:374:287"] = "271400", 
			["218:234:760:268"] = "271409", 
			["225:276:360:340"] = "271406, 438340", 
			["226:335:469:256"] = "438345, 438346", 
			["236:358:263:0"] = "271392, 442671", 
			["237:366:765:43"] = "442672, 442673", 
			["249:183:595:225"] = "271389", 
			["308:335:630:0"] = "438354, 438355, 438356, 438357", 
			["376:347:398:0"] = "271410, 271396, 438352, 438353", 
			["398:302:100:366"] = "438341, 438342, 438343, 438344", 
			["409:318:0:27"] = "438348, 438349, 438350, 438351", 
			["437:249:50:227"] = "271398, 438347",
		},

		--[[1427: Searing Gorge]]			
		[1220] = {
			["304:244:243:424"] = "450682, 450683", 
			["365:393:0:75"] = "254509, 254510, 254511, 254512", 
			["375:307:0:361"] = "254503, 254504, 450680, 450681", 
			["392:355:588:0"] = "254505, 254506, 254507, 254508", 
			["429:301:255:38"] = "450692, 450693, 450694, 450695", 
			["441:266:531:241"] = "450684, 450685, 450686, 450687", 
			["481:360:232:171"] = "254529, 254530, 254531, 254532", 
			["571:308:413:360"] = "254527, 254528, 450688, 450689, 450690, 450691",
		},

		--[[1428: Burning Steppes]]			
		[1224] = {
			["182:360:0:0"] = "270938, 455906", 
			["274:263:568:151"] = "270927, 455911, 455912, 455913", 
			["274:413:253:255"] = "270933, 270943, 270921, 270928, 270933, 270943, 270921, 270928", -- Double
			["281:388:79:0"] = "270919, 270911, 455907, 455908", 
			["298:410:419:258"] = "270920, 270914, 270908, 270929", 
			["320:385:235:0"] = "270912, 270909, 455909, 455910", 
			["324:354:421:0"] = "270922, 270934, 270923, 270937", 
			["350:341:646:7"] = "270944, 270910, 270935, 270945", 
			["362:431:0:237"] = "270941, 270925, 270926, 270917", 
			["383:413:615:255"] = "270906, 270918, 270936, 270942",
		},

		--[[C1429: Elwynn Forest]] 			
		[1228] = {
			["220:207:417:327"] = "271560", 
			["230:206:396:430"] = "271582", 
			["269:248:240:420"] = "271576, 438414", 
			["269:313:116:355"] = "438426, 438427, 438428, 438429", 
			["270:241:529:287"] = "271573, 438425", 
			["276:231:247:294"] = "271567, 438415", 
			["285:194:708:442"] = "271557, 271583", 
			["287:216:532:424"] = "271559, 438412", 
			["294:243:703:292"] = "271578, 438413", 
			["295:296:355:138"] = "271572, 438416, 438418, 438417", 
			["340:272:552:186"] = "271584, 271565, 438419, 438420", 
			["512:422:0:0"] = "438421, 438422, 438423, 438424",
		},

		--[[1430: Deadwind Pass]]			
		[1233] = {
			["350:449:433:208"] = "271092, 271085, 271086, 271089", 
			["513:358:92:310"] = "271095, 271079, 440578, 440579, 440580, 440581", 
			["617:522:83:0"] = "271075, 271076, 271080, 271081, 440573, 440574, 440575, 440576, 440577",
		},

		--[[1431: Duskwood]]				
		[1235] = {
			["189:307:0:152"] = "271453, 271454", 
			["205:157:96:292"] = "438381", 
			["219:182:661:122"] = "271466", 
			["233:248:401:396"] = "271449", 
			["268:282:228:355"] = "271448, 271456, 438391, 438392", 
			["279:399:497:112"] = "271470, 271477, 438379, 438380", 
			["291:244:627:344"] = "438385, 438386", 
			["291:263:539:368"] = "271455, 438382, 438383, 438384", 
			["299:296:32:348"] = "271444, 271483, 438377, 438378", 
			["320:388:314:101"] = "438387, 438388, 438389, 438390", 
			["323:309:91:132"] = "271473, 271463, 271467, 271464", 
			["329:314:640:128"] = "271471, 271461, 271450, 271451", 
			["931:235:71:26"] = "271481, 271460, 271474, 271468",
		},

		--[[1432: Loch Modan]]				
		[1236] = {
			["225:252:221:0"] = "252884", 
			["273:230:245:324"] = "252862, 252863", 
			["273:294:177:345"] = "252886, 252887, 440640, 440641", 
			["294:249:549:52"] = "252880, 252881", 
			["310:345:0:311"] = "252899, 440647, 440648, 440649", 
			["319:289:16:0"] = "252882, 252883, 440638, 440639", 
			["330:474:340:81"] = "252894, 252895, 252896, 252897", 
			["333:200:339:0"] = "440642, 440643", 
			["349:292:570:209"] = "252890, 252891, 252892, 252893", 
			["397:291:481:296"] = "252866, 252867, 440636, 440637", 
			["455:295:0:146"] = "252898, 440644, 440645, 440646",
		},

		--[[1433: Redridge Mountains]]		
		[1237] = {
			["189:193:445:286"] = "440660", 
			["228:247:350:139"] = "272334", 
			["228:420:480:0"] = "440672, 440673", 
			["306:324:688:283"] = "440668, 440669, 440670, 440671", 
			["316:182:525:302"] = "272347, 272371", 
			["323:406:0:256"] = "272364, 272348, 272358, 272359", 
			["357:246:214:0"] = "272357, 272342", 
			["392:352:148:316"] = "272344, 272354, 272350, 272339", 
			["410:256:0:110"] = "272351, 272340", 
			["413:292:37:0"] = "272362, 272356, 440664, 440665", 
			["427:291:451:377"] = "272369, 272363, 440666, 440667", 
			["428:463:574:0"] = "272372, 440661, 440662, 440663", 
			["464:250:81:214"] = "272335, 272343",
		},

		--[[1434: Stranglethorn Vale]]		
		[1238] = {
			["139:150:354:184"] = "440798", 
			["157:173:387:246"] = "440805", 
			["159:137:267:168"] = "440793", 
			["167:179:298:228"] = "440797", 
			["190:176:566:164"] = "440795", 
			["227:190:306:63"] = "440807", 
			["228:265:158:0"] = "440810, 440811", 
			["230:170:398:375"] = "440796", 
			["234:206:543:253"] = "440806", 
			["236:224:140:208"] = "440812", 
			["239:205:397:243"] = "440794", 
			["240:228:413:95"] = "440800", 
			["244:238:499:0"] = "440799", 
			["302:166:306:0"] = "440808, 440809", 
			["324:263:9:22"] = "440819, 440820, 440821, 440822", 
			["350:259:488:364"] = "440801, 440802, 440803, 440804", 
			["376:560:626:0"] = "440813, 440814, 440815, 440816, 440817, 440818",
		},

		--[[1435: Swamp of Sorrows]]		
		[1239] = {
			["229:418:703:80"] = "272739, 272746", 
			["238:343:194:236"] = "272747, 272763", 
			["257:229:575:238"] = "272772, 272760", 
			["262:193:600:0"] = "442700, 442701", 
			["266:284:161:79"] = "272736, 442717, 442718, 442719", 
			["268:285:0:80"] = "272759, 272750, 442713, 442714", 
			["268:316:7:242"] = "442702, 442703, 442704, 442705", 
			["292:360:331:24"] = "272768, 272770, 442720, 442721", 
			["330:342:478:0"] = "442706, 442707, 442708, 442709", 
			["347:303:540:360"] = "272740, 272773, 442715, 442716", 
			["357:308:297:258"] = "272742, 272751, 272752, 272764", 
			["402:668:600:0"] = "272756, 272737, 272769, 442710, 442711, 442712",
		},

		--[[1436: Westfall]]				
		[1240] = {
			["184:217:294:168"] = "441034", 
			["193:273:531:200"] = "273125, 441031", 
			["196:229:311:0"] = "441026", 
			["197:213:394:0"] = "273145", 
			["201:195:203:376"] = "273142", 
			["202:179:474:0"] = "273143", 
			["202:224:348:118"] = "273126", 
			["211:167:221:477"] = "273141", 
			["229:265:404:226"] = "273137, 441027", 
			["232:213:308:325"] = "273130", 
			["235:306:199:79"] = "273149, 441025", 
			["244:237:451:81"] = "273146", 
			["292:273:303:395"] = "273124, 441028, 441029, 441030", 
			["317:261:480:378"] = "273131, 273134, 441032, 441033", 
			["346:222:167:263"] = "273129, 273133",
		},

		--[[1437: Wetlands]]				
		[1243] = {
			["185:224:372:76"] = "273173", 
			["236:256:359:201"] = "273159", 
			["250:269:460:102"] = "441042, 441043", 
			["250:282:218:0"] = "441048, 441049", 
			["256:245:599:123"] = "273181", 
			["257:185:356:7"] = "273164, 441041", 
			["258:207:371:335"] = "273174, 441054", 
			["276:243:121:63"] = "273178, 273167", 
			["298:215:346:419"] = "441039, 441040", 
			["298:447:185:195"] = "273155, 441055, 441056, 441057", 
			["300:316:532:352"] = "441050, 441051, 441052, 441053", 
			["301:232:37:240"] = "273163, 441035", 
			["321:248:31:102"] = "273171, 441036", 
			["325:363:0:297"] = "273156, 441044, 441045, 441046", 
			["329:228:506:34"] = "441037, 441038", 
			["369:235:506:232"] = "273177, 441047",
		},

		--[[1438: Teldrassil]]				
		[1244] = {
			["140:210:345:243"] = "272807", 
			["144:226:432:109"] = "440837", 
			["165:249:382:83"] = "272822", 
			["175:235:374:221"] = "272826", 
			["178:186:466:237"] = "440833", 
			["187:196:544:217"] = "272815", 
			["194:244:276:90"] = "272830", 
			["198:181:347:355"] = "272814", 
			["241:217:481:104"] = "272811", 
			["289:202:422:310"] = "272810, 440834", 
			["298:337:149:181"] = "272806, 272812, 440831, 440832", 
			["317:220:329:448"] = "440835, 440836",
		},

		--[[1439: Darkshore]]				
		[1247] = {
			["200:263:517:28"] = "271043, 438260", 
			["203:194:280:182"] = "438259", 
			["244:201:207:467"] = "438258", 
			["245:147:565:0"] = "438262", 
			["250:241:596:16"] = "438261", 
			["277:281:391:54"] = "438254, 438255, 438256, 438257", 
			["303:185:277:483"] = "271044, 438263", 
			["314:193:280:378"] = "438264, 438265", 
			["326:145:294:330"] = "271045, 438251", 
			["328:250:305:118"] = "438266, 438267", 
			["330:192:300:239"] = "438252, 438253",
		},

		--[[1440: Ashenvale]]				
		[1248] = {
			["166:211:836:148"] = "270387", 
			["184:232:112:148"] = "270380", 
			["203:310:377:121"] = "437337, 437338", 
			["221:257:595:253"] = "270401, 437321", 
			["231:223:771:265"] = "270390", 
			["231:256:481:221"] = "270402", 
			["235:236:696:154"] = "270388", 
			["236:271:210:331"] = "270398, 437328", 
			["244:251:143:0"] = "437322", 
			["246:361:188:0"] = "437319, 437320", 
			["251:271:255:164"] = "270386, 437312", 
			["262:390:0:0"] = "270376, 437333, 437334, 437335", 
			["277:333:714:317"] = "270405, 437316, 437317, 437318", 
			["287:276:529:385"] = "270375, 437313, 437314, 437315", 
			["306:283:40:275"] = "437329, 437330, 437331, 437332", 
			["314:241:255:78"] = "270389, 437336", 
			["325:239:473:97"] = "270400, 437327", 
			["347:308:338:335"] = "437323, 437324, 437325, 437326",
		},

		--[[1441: Thousand Needles]]		
		[1249] = {
			["234:203:527:465"] = "442249", 
			["246:256:756:412"] = "442250", 
			["246:380:0:134"] = "272968, 442244", 
			["272:232:136:0"] = "272963, 442255", 
			["280:325:0:0"] = "442268, 442269, 442270, 442271", 
			["317:252:169:116"] = "272962, 442240", 
			["358:418:125:241"] = "442264, 442265, 442266, 442267", 
			["361:314:298:0"] = "442245, 442246, 442247, 442248", 
			["374:339:347:329"] = "442260, 442261, 442262, 442263", 
			["411:411:591:257"] = "442256, 442257, 442258, 442259", 
			["431:410:571:49"] = "442251, 442252, 442253, 442254", 
			["436:271:276:186"] = "272954, 442241, 442242, 442243",
		},

		--[[1442: Stonetalon Mountains]]	
		[1250] = {
			["164:258:479:401"] = "440778, 440779", 
			["176:189:516:289"] = "440780", 
			["183:196:588:341"] = "440771", 
			["194:156:532:512"] = "272628", 
			["210:189:252:121"] = "440773", 
			["211:131:618:537"] = "272650", 
			["221:235:367:411"] = "440772", 
			["222:222:353:285"] = "272646", 
			["241:192:366:95"] = "440768", 
			["244:247:417:143"] = "272624", 
			["265:206:654:369"] = "440776, 440777", 
			["267:352:468:263"] = "272648, 272634, 272635, 272623", 
			["277:274:199:368"] = "272633, 272647, 440774, 440775", 
			["290:297:220:189"] = "440764, 440765, 440766, 440767", 
			["305:244:265:0"] = "272632, 272641", 
			["322:220:602:448"] = "440769, 440770", 
			["374:287:533:179"] = "272630, 272649, 272642, 272636",
		},

		--[[1443: Desolace]]				
		[1251] = {
			["161:141:210:0"] = "438321", 
			["212:186:275:376"] = "438337", 
			["220:205:440:49"] = "271111", 
			["222:299:142:369"] = "271125, 438327", 
			["231:257:573:0"] = "271114, 438320", 
			["250:215:360:273"] = "271127", 
			["274:145:399:0"] = "271126, 438336", 
			["274:196:207:472"] = "271122, 438317", 
			["289:244:613:170"] = "438318, 438319", 
			["292:266:637:402"] = "271105, 438324, 438325, 438326", 
			["309:349:589:319"] = "438328, 438329, 438330, 438331", 
			["312:285:415:156"] = "438313, 438314, 438315, 438316", 
			["317:293:655:0"] = "271104, 271124, 438322, 438323", 
			["321:275:170:196"] = "271106, 271129, 438338, 438339", 
			["326:311:381:357"] = "271108, 271112, 271113, 271109", 
			["338:342:208:24"] = "438332, 438333, 438334, 438335",
		},

		--[[1444: Feralas]]					
		[1252] = {
			["159:218:607:170"] = "440592", 
			["172:198:568:287"] = "440586", 
			["174:220:671:181"] = "271675", 
			["191:179:457:281"] = "440591", 
			["192:157:663:116"] = "271696", 
			["194:304:375:343"] = "271700, 271682", 
			["206:237:467:354"] = "271699", 
			["207:209:756:191"] = "271680", 
			["208:204:186:229"] = "440593", 
			["217:192:362:237"] = "440590", 
			["232:206:652:298"] = "440596", 
			["265:284:485:101"] = "271687, 440587, 440588, 440589", 
			["350:334:271:0"] = "271705, 271686, 440594, 440595",
		},

		--[[1445: Dustwallow Marsh]]		
		[1253] = {
			["206:200:656:21"] = "271494", 
			["270:353:428:0"] = "271507, 271504, 438410, 438411", 
			["279:301:358:169"] = "438397, 438398, 438399, 438400", 
			["305:247:542:223"] = "271500, 438407", 
			["317:230:137:188"] = "438405, 438406", 
			["344:183:199:0"] = "438393, 438394", 
			["384:249:133:59"] = "438395, 438396", 
			["433:351:109:313"] = "438401, 438402, 438403, 438404", 
			["436:299:359:369"] = "271503, 271509, 438408, 438409",
		},

		--[[1446: Tanaris]]					
		[1254] = {
			["173:163:380:341"] = "272798", 
			["178:243:615:201"] = "440825", 
			["179:190:258:211"] = "272792", 
			["189:180:412:92"] = "272774", 
			["195:163:413:211"] = "272800", 
			["213:173:507:238"] = "272789", 
			["214:149:293:99"] = "272776", 
			["221:293:185:280"] = "272781, 440827", 
			["224:216:431:452"] = "272801", 
			["225:187:448:364"] = "272805", 
			["231:177:305:257"] = "272782", 
			["232:211:301:349"] = "272784", 
			["254:341:479:9"] = "440823, 440824", 
			["255:194:297:148"] = "272799", 
			["269:190:255:431"] = "440828, 440829", 
			["274:186:437:289"] = "272795, 440826", 
			["315:190:184:0"] = "272788, 440830",
		},

		--[[1447: Azshara]]					
		[1259] = {
			["184:213:353:396"] = "438209", 
			["206:329:316:168"] = "270412, 438210", 
			["207:232:407:403"] = "438208", 
			["210:232:245:377"] = "270409", 
			["218:237:228:229"] = "270414", 
			["219:193:575:121"] = "438207", 
			["243:262:343:3"] = "438197, 438198", 
			["250:230:70:222"] = "438199", 
			["256:224:113:141"] = "438185", 
			["260:267:204:53"] = "438193, 438194, 438195, 438196", 
			["295:267:476:401"] = "270410, 438204, 438205, 438206", 
			["306:337:684:22"] = "270434, 438211, 438212, 438213", 
			["321:247:477:0"] = "270432, 438192", 
			["352:274:22:344"] = "438200, 438201, 438202, 438203", 
			["587:381:395:127"] = "438186, 438187, 438188, 438189, 438190, 438191",
		},

		--[[1448: Felwood]]					
		[1260] = {
			["173:163:410:505"] = "271658", 
			["187:176:476:484"] = "271657", 
			["209:226:531:57"] = "271653", 
			["229:210:288:458"] = "271663", 
			["261:273:406:55"] = "271673, 438433, 438434, 438435", 
			["263:199:303:9"] = "271652, 438436", 
			["268:214:278:359"] = "271664, 438438", 
			["274:212:394:382"] = "271659, 438431", 
			["307:161:471:0"] = "271660, 438432", 
			["319:176:234:317"] = "271669, 438437", 
			["343:250:243:107"] = "271665, 438439", 
			["345:192:220:231"] = "271666, 438430",
		},

		--[[1449: Un'Goro Crater]]			
		[1261] = {
			["186:185:328:179"] = "440938", 
			["197:222:706:201"] = "273051", 
			["204:170:462:330"] = "440937", 
			["224:191:557:0"] = "440936", 
			["263:412:573:256"] = "273072, 273039, 273037, 273063", 
			["309:277:145:226"] = "273043, 273075, 273069, 273061", 
			["316:293:162:357"] = "273046, 273053, 273071, 273047", 
			["321:288:356:192"] = "273042, 273065, 273050, 273036", 
			["332:332:157:0"] = "440943, 440944, 440945, 440946", 
			["337:321:565:39"] = "440939, 440940, 440941, 440942", 
			["381:274:335:384"] = "273059, 273066, 273073, 273054", 
			["432:294:305:0"] = "273052, 273062, 273057, 273058",
		},

		--[[1450: Moonglade]]				
		[1263] = {
			["271:296:209:91"] = "440652, 440653, 440654, 440655", 
			["275:346:542:210"] = "440656, 440657, 440658, 440659", 
			["346:244:370:135"] = "440650, 440651", 
			["431:319:219:273"] = "252844, 252845, 252846, 252847",
		},

		--[[1451: Silithus]]				
		[1264] = {
			["292:260:427:143"] = "440714, 440715, 440716, 440717", 
			["309:243:550:181"] = "272580, 272544", 
			["315:285:614:0"] = "440721, 440722, 440723, 440724", 
			["329:246:126:0"] = "272581, 272562", 
			["405:267:345:4"] = "272565, 272566, 272577, 272546", 
			["434:231:100:151"] = "272573, 272545", 
			["489:358:380:310"] = "272567, 272547, 272555, 272548", 
			["542:367:0:206"] = "272559, 272543, 272574, 272575, 440718, 440719", 
			["580:213:0:455"] = "272564, 272553, 440720",
		},

		--[[1452: Wintergrasp]]				
		[1266] = {
			["194:229:482:195"] = "273191", 
			["221:209:588:181"] = "273200", 
			["249:217:581:314"] = "273206", 
			["254:150:556:439"] = "273199", 
			["257:238:399:340"] = "273185, 445588", 
			["271:258:372:268"] = "273192, 445585, 445586, 445587", 
			["317:183:424:474"] = "273198, 445584", 
			["332:268:304:0"] = "273184, 445581, 445582, 445583", 
			["333:255:500:17"] = "273203, 445592", 
			["362:252:92:302"] = "273187, 445593", 
			["367:340:229:33"] = "273207, 445589, 445590, 445591", 
			["376:289:93:118"] = "273202, 445578, 445579, 445580",
		},

		--[[1941: Eversong Woods]]			
		[1628] = {
			["128:193:554:475"] = "271603", 
			["128:197:584:471"] = "271598", 
			["128:248:511:420"] = "271592", 
			["128:253:183:415"] = "271625", 
			["128:256:292:319"] = "271633", 
			["128:256:580:399"] = "271630", 
			["256:128:231:404"] = "271627", 
			["256:128:243:469"] = "271635", 
			["256:128:255:507"] = "271596", 
			["256:128:524:359"] = "271591", 
			["256:128:539:305"] = "271628", 
			["256:172:378:496"] = "271614", 
			["256:174:464:494"] = "271615", 
			["256:256:215:298"] = "271601", 
			["256:256:307:136"] = "271608", 
			["256:256:324:384"] = "271599", 
			["256:256:361:298"] = "271637", 
			["256:256:386:386"] = "271612", 
			["256:256:460:373"] = "271588", 
			["256:256:474:314"] = "271610", 
			["256:256:605:253"] = "271604", 
			["256:256:669:228"] = "271586", 
			["256:353:648:315"] = "271587, 271590", 
			["512:512:195:5"] = "271619, 271602, 271589, 271638", 
			["512:512:440:87"] = "271632, 271600, 271617, 271618",
		},

		--[[1942: Ghostlands]]				
		[1629] = {
			["256:256:184:238"] = "271744", 
			["256:256:210:126"] = "271716", 
			["256:256:40:287"] = "271752", 
			["256:256:585:0"] = "271761", 
			["256:262:364:406"] = "271711, 271717", 
			["256:449:340:219"] = "271740, 271730", 
			["256:512:365:2"] = "271762, 271751", 
			["256:512:448:150"] = "271741, 271723", 
			["256:512:60:117"] = "271754, 271733", 
			["404:436:598:232"] = "271742, 271728, 271758, 271706", 
			["427:256:575:0"] = "271735, 271736", 
			["429:256:573:136"] = "271715, 271745", 
			["512:256:326:0"] = "271729, 271707", 
			["512:256:460:0"] = "271731, 271719", 
			["512:293:95:375"] = "271721, 271725, 271714, 271737", 
			["512:431:466:237"] = "271712, 271757, 271713, 271734", 
			["512:512:44:0"] = "271726, 271756, 271727, 271710",
		},

		--[[1943: Azuremyst Isle]]			
		[1631] = {
			["128:256:462:349"] = "270497", 
			["256:128:356:0"] = "270493", 
			["256:222:23:446"] = "270498", 
			["256:247:220:421"] = "270482", 
			["256:256:174:363"] = "270492", 
			["256:256:176:303"] = "270463", 
			["256:256:281:305"] = "270509", 
			["256:256:291:3"] = "270510", 
			["256:256:352:378"] = "270481", 
			["256:256:365:49"] = "270488", 
			["256:256:383:249"] = "270513", 
			["256:256:449:183"] = "270508", 
			["256:256:488:24"] = "270474", 
			["256:256:507:350"] = "270512", 
			["256:256:515:279"] = "270476", 
			["475:512:527:104"] = "270511, 270483, 270489, 270484", 
			["512:512:74:85"] = "270475, 270515, 270495, 270505",
		},

		-- Unknown (old)
		--[[1459: Alterac Valley			[1273] = {["235:290:399:375"] = "270314, 270315", ["270:240:348:13"] = "270331, 270325", ["300:300:335:172"] = "270320, 270321, 270322, 270323",},]]

		----------------------------------------------------------------------
		-- Outland
		----------------------------------------------------------------------

		--[[1944: Hellfire Peninsula]]		[1633] = {["256:256:182:412"] = "271830", ["256:256:206:110"] = "271835", ["256:256:34:142"] = "271836", ["256:256:467:154"] = "271852", ["256:256:469:298"] = "271848", ["256:256:705:368"] = "271843", ["256:260:308:408"] = "271838, 271861", ["256:378:25:290"] = "271850, 271864", ["256:458:338:210"] = "271855, 271833", ["256:512:326:45"] = "271840, 271849", ["256:512:579:128"] = "271866, 271821", ["256:512:737:156"] = "271854, 271825", ["422:238:580:430"] = "271826, 271822", ["512:255:261:413"] = "271856, 271820", ["512:256:477:6"] = "271867, 271842", ["512:342:183:326"] = "271862, 271844, 271823, 271831", ["512:512:38:152"] = "271851, 271841, 271865, 271853", ["512:512:478:25"] = "271863, 271857, 271845, 271839",},
		--[[1946: Zangarmarsh]]				[1635] = {["256:128:124:0"] = "273241", ["256:207:720:461"] = "273266", ["256:256:175:232"] = "273267", ["256:256:31:339"] = "273262", ["256:256:342:249"] = "273233", ["256:256:512:303"] = "273271", ["256:256:596:412"] = "273280", ["256:256:81:152"] = "273222", ["256:256:88:50"] = "273235", ["256:343:141:325"] = "273224, 273225", ["256:512:219:51"] = "273268, 273226", ["256:512:329:25"] = "273223, 273272", ["256:512:462:90"] = "273253, 273242", ["256:512:569:112"] = "273249, 273238", ["286:512:716:128"] = "273243, 273273, 273250, 273251", ["308:256:694:321"] = "273276, 273246", ["512:256:20:202"] = "273248, 273279", ["512:336:314:332"] = "273221, 273269, 273236, 273277",},
		--[[1948: Shadowmoon Valley]]		[1637] = {["256:256:143:256"] = "272431", ["256:256:520:93"] = "272421", ["256:256:554:308"] = "272461", ["256:512:290:129"] = "272451, 272471", ["396:512:606:126"] = "272429, 272470, 272446, 272450", ["492:223:510:445"] = "272442, 272443", ["512:358:343:310"] = "272454, 272426, 272439, 272455", ["512:410:469:258"] = "272448, 272449, 272469, 272452", ["512:439:168:229"] = "272430, 272460, 272434, 272435", ["512:512:104:155"] = "272436, 272440, 272441, 272427", ["512:512:116:35"] = "272428, 272424, 272433, 272445", ["512:512:348:8"] = "272467, 272465, 272422, 272453", ["512:512:394:90"] = "272459, 272438, 272463, 272447",},
		--[[1949: Blade's Edge Mountains]]	[1638] = {["256:128:563:151"] = "270643", ["256:240:271:428"] = "270622", ["256:254:446:414"] = "270642", ["256:256:254:176"] = "270663", ["256:256:286:28"] = "270625", ["256:256:412:95"] = "270631", ["256:256:422:0"] = "270665", ["256:256:439:210"] = "270649", ["256:256:527:81"] = "270611", ["256:256:585:0"] = "270651", ["256:256:623:147"] = "270666", ["256:256:629:406"] = "270667", ["256:256:658:297"] = "270655", ["256:256:673:71"] = "270626", ["256:256:733:109"] = "270609", ["256:297:342:371"] = "270669, 270657", ["256:318:289:350"] = "270638, 270630", ["256:336:533:332"] = "270612, 270658", ["256:396:405:272"] = "270664, 270659", ["256:410:554:258"] = "270629, 270606", ["256:419:512:249"] = "270644, 270610", ["256:462:166:206"] = "270652, 270653", ["256:507:314:161"] = "270619, 270620", ["256:512:479:98"] = "270616, 270617", ["416:256:586:147"] = "270628, 270605", ["512:252:144:416"] = "270662, 270632", ["512:256:214:55"] = "270621, 270633",},
		--[[1950: Bloodmyst Isle]]			[1639] = {["128:128:180:216"] = "270671", ["239:256:763:256"] = "270710", ["256:185:309:483"] = "270718", ["256:198:503:470"] = "270687", ["256:256:205:39"] = "270701", ["256:256:221:136"] = "270676", ["256:256:232:242"] = "270703", ["256:256:250:404"] = "270739", ["256:256:293:285"] = "270728", ["256:256:297:136"] = "270733", ["256:256:302:27"] = "270727", ["256:256:367:209"] = "270679", ["256:256:414:406"] = "270700", ["256:256:437:258"] = "270698", ["256:256:451:29"] = "270734", ["256:256:481:117"] = "270720", ["256:256:546:410"] = "270699", ["256:256:555:87"] = "270741", ["256:256:556:216"] = "270740", ["256:256:598:338"] = "270677", ["256:256:613:82"] = "270709", ["256:256:637:0"] = "270714", ["256:256:657:78"] = "270712", ["256:256:729:54"] = "270682", ["256:512:44:62"] = "270690, 270729", ["485:141:517:527"] = "270711, 270723", ["512:242:177:426"] = "270674, 270731", ["512:430:43:238"] = "270692, 270673, 270702, 270672",},

		--[[1951: Nagrand]]					[1640] = {["256:241:558:427"] = "272204", ["256:256:157:32"] = "272235", ["256:256:162:154"] = "272198", ["256:256:219:199"] = "272231", ["256:256:277:54"] = "272242", ["256:256:335:193"] = "272213", ["256:256:351:52"] = "272237", ["256:256:387:390"] = "272220", ["256:256:391:258"] = "272230", ["256:256:431:143"] = "272188", ["256:256:504:53"] = "272208", ["256:256:532:363"] = "272236", ["256:256:533:267"] = "272206", ["256:256:598:79"] = "272232", ["256:256:666:233"] = "272244", ["256:334:660:334"] = "272196, 272197", ["256:512:10:107"] = "272199, 272200", ["512:334:168:334"] = "272205, 272229, 272190, 272238", ["512:420:36:248"] = "272224, 272233, 272191, 272212",},
		--[[1952: Terokkar Forest]]			[1641] = {["128:256:316:268"] = "272840", ["256:208:321:460"] = "272889", ["256:234:247:434"] = "272843", ["256:256:116:4"] = "272878", ["256:256:222:362"] = "272846", ["256:256:245:289"] = "272881", ["256:256:310:345"] = "272887", ["256:256:314:0"] = "272837", ["256:256:377:272"] = "272836", ["256:256:397:165"] = "272839", ["256:256:417:327"] = "272873", ["256:256:478:19"] = "272880", ["256:256:480:277"] = "272866", ["256:256:505:154"] = "272886", ["256:256:521:275"] = "272835", ["256:367:103:301"] = "272844, 272847", ["256:512:455:34"] = "272879, 272834", ["385:512:617:149"] = "272860, 272855, 272850, 272856", ["512:256:143:171"] = "272851, 272867", ["512:320:449:348"] = "272876, 272888, 272857, 272877", ["512:512:104:4"] = "272861, 272831, 272883, 272838",},
		--[[1953: Netherstorm]]				[1642] = {["256:128:241:388"] = "272255", ["256:145:490:523"] = "272274", ["256:179:357:489"] = "272288", ["256:213:239:455"] = "272292", ["256:217:454:451"] = "272253", ["256:256:132:294"] = "272262", ["256:256:171:155"] = "272247", ["256:256:229:38"] = "272263", ["256:256:237:22"] = "272273", ["256:256:253:301"] = "272283", ["256:256:298:134"] = "272285", ["256:256:328:397"] = "272280", ["256:256:356:261"] = "272249", ["256:256:396:10"] = "272269", ["256:256:411:20"] = "272248", ["256:256:465:336"] = "272260", ["256:256:481:208"] = "272264", ["256:256:513:138"] = "272282", ["256:256:644:173"] = "272287", ["256:387:147:281"] = "272279, 272265", ["409:384:593:284"] = "272267, 272254, 272268, 272284", ["512:256:354:49"] = "272296, 272294",},

		--[[1957: Isle of Quel'Danas]]		[1646] = {["512:416:252:252"] = "272721, 272732, 272715, 272722", ["512:512:251:4"] = "272716, 272728, 272723, 272733",},

		----------------------------------------------------------------------
		-- Northrend
		----------------------------------------------------------------------

		--[[114: Borean Tundra]]			[119] = {["186:276:272:237"] = "270870, 270743", ["203:209:662:11"] = "270848", ["244:214:325:140"] = "270785", ["244:319:397:66"] = "270900, 270819", ["259:302:457:264"] = "270903, 270781, 270794, 270855", ["260:278:329:237"] = "270851, 270871, 270795, 270769", ["267:378:153:238"] = "270822, 270894, 270835, 270784", ["289:279:707:181"] = "270765, 270824, 270887, 270801", ["290:292:712:15"] = "270826, 270865, 270759, 270763", ["375:342:480:0"] = "270869, 270890, 270764, 270762", ["382:258:293:383"] = "270761, 270879, 270880, 270787", ["385:316:509:214"] = "270898, 270840, 270899, 270812", ["396:203:314:0"] = "270806, 270810", ["460:381:50:0"] = "270821, 270758, 270797, 270775",},
		--[[115: Dragonblight]]				[120] = {["188:211:374:208"] = "271192", ["196:218:543:362"] = "271358", ["213:219:403:0"] = "271232", ["214:261:614:358"] = "271313, 271133", ["226:212:661:264"] = "271378", ["229:259:487:0"] = "271146, 271257", ["229:299:42:187"] = "271267, 271201", ["235:337:134:165"] = "271254, 271233", ["235:354:569:7"] = "271149, 271222", ["236:218:258:203"] = "271170", ["258:225:433:118"] = "271239, 271157", ["299:278:703:7"] = "271351, 271270, 271175, 271330", ["301:286:698:332"] = "271280, 271346, 271164, 271387", ["304:203:256:104"] = "271352, 271244", ["306:242:210:0"] = "271187, 271231", ["311:272:691:160"] = "271333, 271199, 271364, 271162", ["317:353:453:219"] = "271205, 271248, 271252, 271236", ["356:300:217:313"] = "271322, 271298, 271290, 271337",},
		--[[116: Grizzly Hills]]			[121] = {["249:235:232:129"] = "271764", ["274:207:18:461"] = "271794, 271778", ["278:290:217:244"] = "271801, 271773, 271779, 271806", ["283:247:176:421"] = "271789, 271812", ["294:227:358:187"] = "271785, 271817", ["324:265:548:137"] = "271790, 271765, 271766, 271767", ["328:260:331:32"] = "271809, 271771, 271772, 271776", ["329:246:509:0"] = "271769, 271770", ["332:294:17:307"] = "271768, 271783, 271795, 271810", ["351:284:607:41"] = "271791, 271807, 271774, 271796", ["356:224:7:207"] = "271781, 271784", ["382:285:0:46"] = "271792, 271775, 271813, 271797", ["455:400:547:257"] = "271798, 271780, 271814, 271799", ["475:362:312:294"] = "271803, 271788, 271816, 271805",},
		--[[117: Howling Fjord]]			[122] = {["174:173:576:170"] = "271946", ["177:191:342:351"] = "271992", ["178:208:595:240"] = "271945", ["181:178:490:161"] = "271993", ["187:263:397:208"] = "271980, 271994", ["193:201:668:223"] = "271950", ["213:256:283:203"] = "271976", ["222:168:222:100"] = "271959", ["223:209:354:0"] = "271957", ["223:338:664:25"] = "271956, 271974", ["232:216:585:336"] = "271941", ["238:232:343:108"] = "271984", ["242:189:225:0"] = "271954", ["244:305:621:327"] = "271969, 271989", ["248:382:477:216"] = "271985, 271968", ["251:192:490:0"] = "271970", ["263:265:99:37"] = "271940, 271975, 271953, 271991", ["266:210:420:57"] = "271952, 271967", ["284:308:415:360"] = "271997, 271998, 271963, 271964", ["298:306:572:0"] = "271977, 271978, 271979, 271958", ["333:265:99:278"] = "271962, 271987, 271983, 271988", ["347:220:90:180"] = "271986, 271960", ["350:258:168:410"] = "271965, 271966, 271972, 271973",},
		--[[118: Icecrown]]					[123] = {["204:268:0:167"] = "254677, 254678", ["219:283:218:291"] = "254688, 254689", ["223:207:444:276"] = "254695", ["223:399:321:15"] = "254690, 254691", ["227:210:327:305"] = "254687", ["238:240:217:50"] = "254692", ["245:239:690:267"] = "254679", ["248:243:538:181"] = "254684", ["269:217:715:390"] = "254693, 254694", ["283:231:558:329"] = "254685, 254686", ["300:343:626:31"] = "254680, 254681, 254682, 254683", ["308:202:392:466"] = "254659, 254660", ["308:212:342:392"] = "254657, 254658", ["314:224:616:30"] = "294026, 294027", ["373:375:355:37"] = "254653, 254654, 254655, 254656", ["393:474:22:122"] = "254673, 254674, 254675, 254676",},
		--[[119: Sholazar Basin]]			[124] = {["207:235:427:244"] = "272524", ["233:286:705:236"] = "272529, 272506", ["239:313:265:355"] = "272530, 272516", ["249:248:172:135"] = "272507", ["268:288:138:58"] = "272517, 272534, 272496, 272502", ["293:229:396:51"] = "272500, 272501", ["294:327:308:34"] = "272523, 272487, 272539, 272532", ["312:369:501:134"] = "272494, 272495, 272504, 272533", ["322:265:596:92"] = "272521, 272515, 272522, 272499", ["329:293:76:375"] = "272509, 272491, 272520, 272484", ["455:316:82:186"] = "272535, 272518, 272490, 272519", ["468:329:359:339"] = "272498, 272531, 272510, 272541",},
		--[[120: The Storm Peaks]]			[125] = {["169:164:239:301"] = "272922", ["180:239:214:144"] = "272933", ["182:270:570:113"] = "272927, 272910", ["184:191:395:470"] = "272909", ["205:232:162:143"] = "272920", ["210:179:316:296"] = "272945", ["221:200:108:206"] = "272906", ["228:158:98:318"] = "272924", ["244:220:134:429"] = "272919", ["251:200:242:468"] = "272921", ["305:298:339:370"] = "272904, 272925, 272926, 272952", ["306:484:627:179"] = "272934, 272923, 272908, 272930", ["309:383:481:285"] = "272939, 272953, 272905, 272935", ["322:195:109:375"] = "272948, 272950", ["363:341:292:122"] = "272912, 272913, 272914, 272946", ["369:265:218:0"] = "272943, 272944, 272931, 272917",},
		--[[121: Zul'Drak]]					[126] = {["218:291:174:191"] = "273324, 273292", ["237:248:288:168"] = "273329", ["247:304:431:127"] = "273322, 273320", ["249:258:479:241"] = "273304, 273305", ["261:288:607:251"] = "273309, 273286, 273310, 273328", ["265:257:533:345"] = "273296, 273300, 273285, 273287", ["266:254:289:287"] = "273330, 273291", ["272:268:0:247"] = "273318, 273298, 273336, 273303", ["286:265:326:358"] = "273311, 273297, 273331, 273317", ["302:231:380:437"] = "273323, 273289", ["307:256:7:412"] = "273326, 273333", ["311:317:575:88"] = "273325, 273307, 273308, 273319", ["321:305:181:363"] = "273312, 273332, 273282, 273302", ["336:297:629:0"] = "273295, 273301, 273321, 273288",},
		--[[127: Crystalsong Forest]]		[132] = {["252:260:0:91"] = "270966, 271005", ["264:303:0:176"] = "270987, 270962, 270973, 270997", ["288:222:0:0"] = "253268, 271000", ["416:424:0:244"] = "270970, 270961, 270971, 270996", ["446:369:536:40"] = "253267, 270960, 270995, 270989", ["502:477:500:105"] = "253269, 270985, 253270, 270986", ["544:668:129:0"] = "253264, 271003, 270968, 270965, 253265, 253266, 271002, 271004, 270984", ["558:285:444:383"] = "253271, 253272, 270974, 270975, 271001, 270980",},

		----------------------------------------------------------------------
		-- Cataclysm
		----------------------------------------------------------------------

		--[[174: The Lost Isles]]
		[179] = {["142:133:377:359"] = "440843", ["156:142:433:11"] = "440842", ["159:230:264:144"] = "440863", ["168:205:416:368"] = "440853", ["172:175:189:408"] = "440859", ["173:180:351:21"] = "440840", ["177:172:129:348"] = "440838", ["190:186:416:131"] = "440860", ["210:258:492:161"] = "440852, 440851", ["212:193:279:68"] = "440862", ["212:216:440:452"] = "440854", ["221:211:508:345"] = "440850", ["222:190:244:458"] = "440841", ["231:216:213:325"] = "440861", ["248:209:462:43"] = "440839", ["305:288:323:185"] = "440855, 440856, 440857, 440858", ["350:517:581:21"] = "440844, 440845, 440846, 440847, 440848, 440849",},

		--[[179: Gilneas]]
		[184] = {["177:219:293:449"] = "438477", ["194:236:167:352"] = "438476", ["210:166:261:427"] = "438440", ["222:268:393:386"] = "438482, 438483", ["244:241:141:202"] = "438475", ["267:314:387:0"] = "438484, 438485, 438486, 438487", ["280:224:504:394"] = "438498, 438499", ["280:342:298:95"] = "438478, 438479, 438480, 438481", ["281:351:639:43"] = "438443, 438444, 438445, 438446", ["282:263:483:210"] = "438447, 438448, 438449, 438450", ["282:298:482:14"] = "438488, 438489, 438490, 438491", ["286:178:272:333"] = "438441, 438442", ["321:203:516:465"] = "438492, 438493", ["328:336:160:0"] = "438500, 438501, 438502, 438503", ["350:345:652:290"] = "438494, 438495, 438496, 438497",},

		--[[194: Kezan]]
		[199] = {
			["1002:664:0:4"] = "466830, 466834, 466835, 466836, 466837, 466838, 466839, 466840, 466841, 466831, 466832, 466833", 
			["168:213:317:232"] = "440632", 
			["250:307:383:260"] = "440626, 440627", 
			["303:452:0:41"] = "440618, 440619, 440620, 440621", 
			["351:301:180:367"] = "440610, 440611, 440612, 440613", 
			["354:360:586:308"] = "440622, 440623, 440624, 440625", 
			["376:343:98:325"] = "440614, 440615, 440616, 440617", 
			["592:202:219:108"] = "440633, 440634, 440635", 
			["694:290:163:148"] = "440604, 440605, 440606, 440607, 440608, 440609",
		},

		--[[198: Mount Hyjal]]
		[227] = {
			["270:173:303:197"] = "438698, 438699", 
			["270:300:320:5"] = "438686, 438687, 438688, 438689, 438686, 438687, 438688, 438689, 438686, 438687, 438688, 438689", -- Triple
			["272:334:622:320"] = "438700, 438701, 438702, 438703", 
			["277:232:139:436"] = "438722, 438723", 
			["282:418:6:78"] = "438690, 438691, 438692, 438693", 
			["291:321:116:17"] = "438724, 438725, 438726, 438727", 
			["320:471:682:128"] = "438694, 438695, 438696, 438697", 
			["365:264:411:216"] = "438732, 438733, 438734, 438735", 
			["419:290:318:378"] = "438736, 438737, 438738, 438739", 
			["441:319:52:253"] = "438728, 438729, 438730, 438731, 438728, 438729, 438730, 438731", -- Double
			["537:323:392:0"] = "438716, 438717, 438718, 438719, 438720, 438721",
		},

		--[[199: Southern Barrens]]
		[204] = {["214:140:273:528"] = "440758", ["216:172:423:251"] = "440749", ["218:178:300:64"] = "440753", ["242:195:269:436"] = "440750", ["254:214:267:196"] = "440763", ["269:211:398:457"] = "440745, 440746", ["280:279:548:147"] = "440754, 440755, 440757, 440756", ["285:171:244:286"] = "440759, 440760", ["315:170:201:0"] = "440751, 440752", ["355:226:289:117"] = "440761, 440762", ["384:248:274:307"] = "440747, 440748",},

		--[[201: Vashj'ir Kelp'thar]]	[206] = {["220:189:528:228"] = "440974", ["227:207:399:280"] = "440977", ["278:315:210:35"] = "440984, 440985, 440986, 440987", ["291:206:380:43"] = "440982, 440983", ["311:217:451:325"] = "440975, 440976", ["316:267:456:401"] = "440978, 440979, 440980, 440981", ["340:225:365:162"] = "440988, 440989",},
		--[[204: Vashj'ir Abyssal]]		[209] = {["225:250:415:183"] = "440973", ["267:374:266:280"] = "440955, 440956, 440957, 440958", ["298:251:315:110"] = "440963, 440964", ["306:293:162:210"] = "440969, 440970, 440971, 440972", ["363:262:275:32"] = "440959, 440960, 440961, 440962", ["370:385:412:283"] = "440965, 440966, 440967, 440968", ["371:394:50:263"] = "440947, 440948, 440949, 440950", ["491:470:497:0"] = "440951, 440952, 440953, 440954",},
		--[[205: Vashj'ir Shimmering]]	[210] = {["197:223:554:175"] = "440998", ["272:180:270:222"] = "440992, 440993", ["286:269:460:261"] = "440994, 440995, 440996, 440997", ["335:223:407:445"] = "440990, 440991", ["339:278:400:0"] = "441003, 441004, 441005, 441006", ["349:361:217:268"] = "440999, 441000, 441001, 441002", ["480:319:150:32"] = "441007, 441008, 441009, 441010",},

		--[[207: Deepholm]]
		[212] = {
			["237:198:297:384"] = "438312", 
			["274:156:434:0"] = "438306, 438307", 
			["292:285:458:383"] = "438294, 438295, 438296, 438297", 
			["355:345:287:177"] = "438298, 438299, 438300, 438301", 
			["370:285:0:146"] = "438280, 438281, 438282, 438283", 
			["371:354:0:314"] = "438290, 438291, 438292, 438293", 
			["378:359:20:0"] = "438276, 438277, 438278, 438279", 
			["411:248:570:420"] = "438310, 438311", 
			["430:230:141:438"] = "438308, 438309", 
			["454:343:549:297"] = "438272, 438273, 438274, 438275", 
			["462:400:540:12"] = "438268, 438269, 438270, 438271", 
			["467:273:85:0"] = "438302, 438303, 438304, 438305", 
			["516:287:448:0"] = "438284, 438285, 438286, 438287, 438288, 438289",
		},

		--[[210: The Cape of Stranglethorn]]
		[215] = {["155:221:468:119"] = "438752", ["184:176:533:181"] = "438751", ["225:255:289:341"] = "438740", ["236:276:340:392"] = "438754, 438755", ["238:260:345:0"] = "438743, 438744", ["240:264:471:404"] = "438748, 438747", ["244:209:452:0"] = "438753", ["246:221:292:213"] = "438750", ["253:242:408:248"] = "438749", ["271:204:528:73"] = "438741, 438742", ["356:221:208:116"] = "438745, 438746",},

		--[[Gilneas*]]
		[216] = {["177:219:293:449"] = "438541", ["194:236:167:352"] = "438540", ["210:166:261:427"] = "438504", ["222:268:393:386"] = "438546, 438547", ["244:241:141:202"] = "438539", ["250:298:482:14"] = "438552, 438553", ["267:314:387:0"] = "438548, 438549, 438550, 438551", ["280:224:504:394"] = "438562, 438563", ["280:342:298:95"] = "438542, 438543, 438544, 438545", ["281:351:639:43"] = "438507, 438508, 438509, 438510", ["282:263:483:210"] = "438523, 438524, 438525, 438526", ["286:178:272:333"] = "438505, 438506", ["321:203:516:465"] = "438556, 438557", ["328:336:160:0"] = "438564, 438565, 438566, 438567", ["350:345:652:290"] = "438558, 438559, 438560, 438561",},

		--[[217: Ruins of Gilneas]]
		[228] = {["1002:668:0:0"] = "464052, 464056, 464057, 464058, 464059, 464060, 464061, 464062, 464063, 464053, 464054, 464055, 464052, 464056, 464057, 464058, 464059, 464060, 464061, 464062, 464063, 464053, 464054, 464055, 464052, 464056, 464057, 464058, 464059, 464060, 464061, 464062, 464063, 464053, 464054, 464055, 464052, 464056, 464057, 464058, 464059, 464060, 464061, 464062, 464063, 464053, 464054, 464055, 464052, 464056, 464057, 464058, 464059, 464060, 464061, 464062, 464063, 464053, 464054, 464055",},

		--[[Gilneas*]]
		[220] = {["177:219:293:449"] = "438605", ["194:236:167:352"] = "438604", ["210:166:261:427"] = "438568", ["222:268:393:386"] = "438610, 438611", ["244:241:141:202"] = "438603", ["267:314:387:0"] = "438612, 438613, 438614, 438615", ["280:224:504:394"] = "438626, 438627", ["280:342:298:95"] = "438606, 438607, 438608, 438609", ["281:351:639:43"] = "438571, 438572, 438573, 438574", ["282:263:483:210"] = "438587, 438588, 438589, 438590", ["282:298:482:14"] = "438616, 438617, 438618, 438619", ["286:178:272:333"] = "438569, 438570", ["321:203:516:465"] = "438620, 438621", ["328:336:160:0"] = "438628, 438629, 438630, 438631", ["350:345:652:290"] = "438622, 438623, 438624, 438625",},

		--[[241: Twilight Highlands]]
		[252] = {["143:141:344:89"] = "458560", ["165:199:327:356"] = "458579", ["174:190:291:89"] = "458554", ["175:180:269:179"] = "458572", ["177:159:302:306"] = "458587", ["182:195:370:447"] = "458548", ["191:198:205:232"] = "458589", ["194:170:543:220"] = "458555", ["197:218:395:367"] = "458552", ["198:201:622:169"] = "458570", ["199:212:312:192"] = "458574", ["203:208:387:268"] = "458547", ["206:182:296:0"] = "458569", ["211:210:498:121"] = "458571", ["214:190:358:0"] = "458588", ["215:157:416:205"] = "458546", ["215:181:499:265"] = "458553", ["220:227:697:403"] = "458558", ["226:232:654:0"] = "458573", ["230:276:83:223"] = "458556, 458557", ["238:229:374:93"] = "458580", ["239:232:482:330"] = "458559", ["251:207:631:245"] = "458551", ["260:202:610:345"] = "458581, 458582", ["283:206:76:120"] = "458549, 458550", ["308:267:482:0"] = "458561, 458562, 458563, 458564", ["324:264:71:16"] = "458583, 458584, 458585, 458586", ["342:288:436:380"] = "458565, 458566, 458567, 458568", ["361:354:151:314"] = "458575, 458576, 458577, 458578",},

		--[[249: Uldum]]
		[260] = {
			["150:159:545:193"] = "458658", 
			["151:144:479:215"] = "458668", 
			["160:193:406:174"] = "458641", 
			["161:236:647:15"] = "458663", 
			["164:185:471:277"] = "458634", 
			["196:170:551:121"] = "458646", 
			["202:169:341:402"] = "458635", 
			["203:215:542:0"] = "458638", 
			["203:249:217:289"] = "458653", 
			["206:204:657:349"] = "458664", 
			["209:254:407:384"] = "458643", 
			["213:195:656:473"] = "458665", 
			["228:227:411:67"] = "458650", 
			["233:321:527:291"] = "458639, 458640", 
			["237:194:583:162"] = "458642", 
			["237:316:752:170"] = "458661, 458662", 
			["249:243:264:136"] = "458649", 
			["269:203:340:282"] = "458647, 458648", 
			["269:242:599:184"] = "458636, 458637", 
			["270:229:229:433"] = "458666, 458667", 
			["278:173:365:0"] = "458651, 458652", 
			["296:209:132:127"] = "458659, 458660", 
			["312:289:28:221"] = "458654, 458655, 458656, 458657", 
			["400:224:110:0"] = "458644, 458645",
		},

		--[[Twilight Highland*]]	[338] = {["143:141:344:89"] = "458604", ["165:199:327:356"] = "458623, 458623", ["174:190:291:89"] = "458598", ["175:180:269:179"] = "458616", ["177:159:302:306"] = "458631", ["182:195:370:447"] = "458592", ["191:198:205:232"] = "458633", ["194:170:543:220"] = "458599", ["197:218:395:367"] = "458596", ["198:201:622:169"] = "458614", ["199:212:312:192"] = "458618", ["203:208:387:268"] = "458591", ["206:182:296:0"] = "458613", ["211:210:498:121"] = "458615", ["214:190:358:0"] = "458632", ["215:157:416:205"] = "458590", ["215:181:499:265"] = "458597", ["220:227:697:403"] = "458602", ["226:232:654:0"] = "458617", ["230:276:83:223"] = "458600, 458601", ["238:229:374:93"] = "458624", ["239:232:482:330"] = "458603", ["251:207:631:245"] = "458595", ["260:202:610:345"] = "458625, 458626", ["283:206:76:120"] = "458593, 458594", ["308:267:482:0"] = "458605, 458606, 458607, 458608", ["324:264:71:16"] = "458627, 458628, 458629, 458630", ["342:288:436:380"] = "458609, 458610, 458611, 458612", ["361:354:151:314"] = "458619, 458620, 458621, 458622",},
		--[[Ahn'Qiraj Fallen Kndm]]	[339] = {["887:668:115:0"] = "462974, 462978, 462979, 462980, 462981, 462982, 462983, 462984, 462985, 462975, 462976, 462977",},
		--[[Dustwallow Marsh*]]		[498] = {["206:200:656:21"] = "656197", ["270:353:428:0"] = "656230, 656231, 656232, 656233", ["279:301:358:169"] = "656202, 656203, 656204, 656205", ["305:247:542:223"] = "656224, 656225", ["317:230:137:188"] = "656222, 656223", ["344:183:199:0"] = "656198, 656199", ["384:249:133:59"] = "656200, 656201", ["433:351:109:313"] = "656218, 656219, 656220, 656221", ["436:299:359:369"] = "656226, 656227, 656228, 656229",},

	}
