local addonName, ns = ...
AuctionBar = CreateFrame("Frame", "AuctionBarFrame", UIParent)
local selectedDuration = 1
local GOLD_AMOUNT_TEXTURE = "|TInterface\\MoneyFrame\\UI-GoldIcon:0:0:2:0|t"
local SILVER_AMOUNT_TEXTURE = "|TInterface\\MoneyFrame\\UI-SilverIcon:0:0:2:0|t"
local GOLD_AMOUNT_TEXTURE_STRING   = "%s"..GOLD_AMOUNT_TEXTURE
local SILVER_AMOUNT_TEXTURE_STRING = "%s"..SILVER_AMOUNT_TEXTURE
local version = GetAddOnMetadata(addonName, "Version") or "?"
local GetContainerNumSlots = GetContainerNumSlots or (C_Container and C_Container.GetContainerNumSlots)
local GetContainerItemLink = GetContainerItemLink or (C_Container and C_Container.GetContainerItemLink)
local GetContainerItemInfo = GetContainerItemInfo or (C_Container and C_Container.GetContainerItemInfo)


function AuctionBar.CreateBorder(frame, r, g, b, a, drawLayer, size)
    drawLayer = drawLayer or "BACKGROUND"
    size = size or 1
    frame.BorderTop = frame.BorderTop or frame:CreateTexture(nil,drawLayer)
    frame.BorderTop:SetColorTexture(r,g,b,a)
    frame.BorderTop:SetPoint("TOPLEFT",frame,"TOPLEFT",0,0)
    frame.BorderTop:SetPoint("BOTTOMRIGHT",frame,"TOPRIGHT",0,-size)
    frame.BorderLeft = frame.BorderLeft or frame:CreateTexture(nil,drawLayer)
    frame.BorderLeft:SetColorTexture(r,g,b,a)
    frame.BorderLeft:SetPoint("TOPLEFT",frame,"TOPLEFT",0,0)
    frame.BorderLeft:SetPoint("BOTTOMRIGHT",frame,"BOTTOMLEFT",size,0)
    frame.BorderBottom = frame.BorderBottom or frame:CreateTexture(nil,drawLayer)
    frame.BorderBottom:SetColorTexture(r,g,b,a)
    frame.BorderBottom:SetPoint("BOTTOMLEFT",frame,"BOTTOMLEFT",0,0)
    frame.BorderBottom:SetPoint("TOPRIGHT",frame,"BOTTOMRIGHT",0,size)
    frame.BorderRight = frame.BorderRight or frame:CreateTexture(nil,drawLayer)
    frame.BorderRight:SetColorTexture(r,g,b,a)
    frame.BorderRight:SetPoint("TOPLEFT",frame,"TOPRIGHT",0,0)
    frame.BorderRight:SetPoint("BOTTOMRIGHT",frame,"BOTTOMRIGHT",-1,0)
end

function AuctionBar.AuctionBarCreateFrame(FrameName, parent, Width, Height, FrameStrata, ClampedToScreen, Movable, TitleText)
    FrameName = FrameName or ""
    local f = CreateFrame("Frame", FrameName, parent or UIParent, BackdropTemplateMixin and "BackdropTemplate")
    f:SetSize(Width or 305, Height or 350)
    f:SetFrameStrata(FrameStrata or "DIALOG")
    f:SetClampedToScreen(ClampedToScreen and true or false)
    f:SetMovable(Movable and true or false)
    f:SetResizable(true)
    f:SetToplevel(true)
    f:SetResizeBounds(305, 219, GetScreenWidth()-30, GetScreenHeight()-50)
    if f.SetBackdrop then
        f:SetBackdrop({
            bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
            tile = true, tileSize = 32, edgeSize = 32,
            insets = { left = 12, right = 12, top = 12, bottom = 12 }
        })
        f:SetBackdropColor(0, 0, 0, 0.92)
    end

    f.content = CreateFrame("Frame", nil, f)
    f.content:SetPoint("TOPLEFT", 12, -12)
    f.content:SetPoint("BOTTOMRIGHT", -12, 12)

    local title = f.content:CreateFontString(nil, "OVERLAY", "GameFontHighlightLarge")
    title:SetPoint("TOPRIGHT", -20, -4)
    title:SetText(TitleText or "EasyAuction")
    f.titleText = title

    local closeBtn = CreateFrame("Button", nil, f, "UIPanelCloseButton")
    closeBtn:SetPoint("TOPRIGHT", f, "TOPRIGHT", -4, -4)
    closeBtn:SetScript("OnClick", function() f:Hide() end)
    f.closeBtn = closeBtn

    if Movable then
        f:EnableMouse(true)
        f:RegisterForDrag("LeftButton")
        f:SetScript("OnDragStart", function(self) self:StartMoving() end)
        f:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
        title:EnableMouse(true)
        title:RegisterForDrag("LeftButton")
        title:SetScript("OnDragStart", function() f:StartMoving() end)
        title:SetScript("OnDragStop", function() f:StopMovingOrSizing() end)
    end

    return f
end

function AuctionBar.CreateEditBox(parent, width, heigth, fontSize, justifyH, numeric, multiLine, r, g, b, a, name)
    r = r or 0.24
    g = g or 0.25
    b = b or 0.3
    a = a or 1
    local editBox = CreateFrame("EditBox", name, parent, BackdropTemplateMixin and "BackdropTemplate")
    editBox:EnableMouse(true)
    AuctionBar.CreateBorder(editBox, r, g, b, a, "OVERLAY", 1)

    editBox.Background = editBox:CreateTexture(nil,"BACKGROUND")
    editBox.Background:SetColorTexture(0,0,0,1)
    editBox.Background:SetPoint("TOPLEFT")
    editBox.Background:SetPoint("BOTTOMRIGHT")

    editBox:SetFontObject("ChatFontNormal")

    editBox:SetTextInsets(4, 4, 0, 0)
    editBox:SetSize(width or 60, heigth or 20)
    editBox:SetFont(GameFontNormal:GetFont(), fontSize or 14, "")
    editBox:SetMultiLine(multiLine)
    editBox:SetTextColor(0.95, 0.95, 0.95)
    editBox:SetAutoFocus(false)
    editBox:SetNumeric(numeric)
    editBox:SetJustifyH(justifyH or "CENTER")

    editBox:SetScript("OnEscapePressed",function (self)
        self:ClearFocus()
    end)
    editBox:SetScript("OnEnterPressed", function (self)
        self:ClearFocus()
    end)
    editBox:SetScript("OnEditFocusLost",function (self)
        self:HighlightText(0, 0)
    end)
    editBox:SetScript("OnEditFocusGained",function (self)
        self:HighlightText()
    end)

    return editBox
end
function AuctionBar.GameTooltipShow(self, point, relativePoint, offsetX, offsetY)
    offsetX = offsetX or 0
    offsetY = offsetY or 0
    GameTooltip:ClearAllPoints()
    GameTooltip:ClearLines()
    GameTooltip:SetOwner(self, "ANCHOR_NONE")
    GameTooltip:SetPoint(point, self, relativePoint, offsetX, offsetY)
end

local function GetShortMoneyString(money, maxWidth)
    local s = GetMoneyString(money, true)
    local temp = UIParent:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
    temp:SetText(s)
    if temp:GetStringWidth() <= maxWidth then
        temp:Hide()
        return s
    end

    local gold = floor(money / (COPPER_PER_GOLD))
    local silver = floor((money - gold*COPPER_PER_GOLD) / COPPER_PER_SILVER)
    local s2 = ""
    if gold > 0 then
        s2 = s2 .. GOLD_AMOUNT_TEXTURE_STRING:format(gold, 0, 0)
    end
    if silver > 0 or gold > 0 then
        s2 = s2 .. SILVER_AMOUNT_TEXTURE_STRING:format(silver, 0, 0)
    end
    temp:SetText(s2)
    if temp:GetStringWidth() <= maxWidth then
        temp:Hide()
        return s2
    end

    s2 = GOLD_AMOUNT_TEXTURE_STRING:format(gold, 0, 0)
    temp:SetText(s2)
    temp:Hide()
    return s2
end

local function utf8sub(str, startChar, numChars)
    local startIndex = 1
    while startChar > 1 do
        local char = string.byte(str, startIndex)
        if char >= 240 then
            startIndex = startIndex + 4
        elseif char >= 224 then
            startIndex = startIndex + 3
        elseif char >= 192 then
            startIndex = startIndex + 2
        else
            startIndex = startIndex + 1
        end
        startChar = startChar - 1
    end
    local currentIndex = startIndex
    while numChars > 0 and currentIndex <= #str do
        local char = string.byte(str, currentIndex)
        if char >= 240 then
            currentIndex = currentIndex + 4
        elseif char >= 224 then
            currentIndex = currentIndex + 3
        elseif char >= 192 then
            currentIndex = currentIndex + 2
        else
            currentIndex = currentIndex + 1
        end
        numChars = numChars - 1
    end
    return str:sub(1, currentIndex - 1)
end

local function TruncateNameAndKeepCount(fs, name, count, maxWidth)
    local qtyStr = " x"..count
    fs:SetText(name..qtyStr)
    if fs:GetStringWidth() <= maxWidth then
        return name..qtyStr
    end
    local len = strlenutf8(name)
    for i = len, 1, -1 do
        local truncName = utf8sub(name, 1, i)
        local newText = truncName .. "…" .. qtyStr
        fs:SetText(newText)
        if fs:GetStringWidth() <= maxWidth then
            return newText
        end
    end
    return "…" .. qtyStr
end

local function SetCopper(money, frameType)
    if not money or type(money) ~= "number" then return end
    frameType = frameType or "UnitPrice"
    local gold = floor(money / (COPPER_PER_GOLD))
	local silver = floor((money - (gold * COPPER_PER_GOLD)) / COPPER_PER_SILVER)
	local copper = mod(money, COPPER_PER_SILVER)
    HookAuctionFrame = AuctionBar.HookAuctionFrame
    if frameType == "UnitPrice" then
        HookAuctionFrame.UnitGoldPrice:SetNumber(gold)
        HookAuctionFrame.UnitSilverPrice:SetNumber(silver)
        HookAuctionFrame.UnitCopperPrice:SetNumber(copper)
    elseif frameType == "StackPrice" then
        HookAuctionFrame.StackGoldPrice:SetNumber(gold)
        HookAuctionFrame.StackSilverPrice:SetNumber(silver)
        HookAuctionFrame.StackCopperPrice:SetNumber(copper)
    else
        return
    end
end
local function GetAuctionSortColumn(sortTable)
	local existingSortColumn, existingSortReverse = GetAuctionSort(sortTable, 1);
    if (existingSortColumn == "totalbuyout" or existingSortColumn == "unitbid" or existingSortColumn == "unitprice") then
		existingSortColumn = "bid";
	end
	return existingSortColumn, existingSortReverse
end

local function Set_AuctionSort_Column(sortTable)
    SetCVar("auctionSortByBuyoutPrice", 1)
    SetCVar("auctionSortByUnitPrice", 1)
    AuctionFrame_SetSort(sortTable or "list", "bid", false)
end

local function IsCanDo()
    local existingSortColumn, existingSortReverse = GetAuctionSortColumn("list")
    if existingSortColumn ~= "bid" or existingSortReverse ~= false or
    GetCVar("auctionSortByBuyoutPrice") ~= "1" or GetCVar("auctionSortByUnitPrice") ~= "1" then
        return
    else
        return true
    end
end
local function MoneyInputEidtBox(parent, maxLetters, width, atlasName)
    local editBox = AuctionBar.CreateEditBox(parent or AuctionBar.HookAuctionFrame, width or 40, 20, 14, "RIGHT", true, nil, nil, nil, nil, nil)
    if maxLetters then
        editBox:SetMaxLetters(maxLetters)
    end
    if atlasName then
        editBox.Icon = editBox:CreateTexture(nil, "ARTWORK")
        editBox.Icon:SetSize(12, 14)
        editBox.Icon:SetPoint("RIGHT", 13, -2)
        editBox.Icon:SetAtlas(atlasName)
    end
    return editBox
end

local function UpdateSortAnim(isPlay)
    local sortBtn  = AuctionBar.HookAuctionFrame.sortBtn
    if isPlay then
        sortBtn.SpellHighlightAnim:Play()
        sortBtn.SpellHighlightTexture:Show()
    else
        sortBtn.SpellHighlightAnim:Stop()
        sortBtn.SpellHighlightTexture:Hide()
    end
end

local function UpdateUnitPrice()
    local HookAuctionFrame = AuctionBar.HookAuctionFrame
    local gold = HookAuctionFrame.StackGoldPrice:GetNumber()
    local silver = HookAuctionFrame.StackSilverPrice:GetNumber()
    local copper = HookAuctionFrame.StackCopperPrice:GetNumber()
    local count = HookAuctionFrame.StackCount:GetNumber()
    local stackMoney = gold*10000 + silver*100 + copper
    local unitMoney = floor(stackMoney/count)
    SetCopper(unitMoney)
end

local function UpdateStackPrice()
    local HookAuctionFrame = AuctionBar.HookAuctionFrame
    local gold = HookAuctionFrame.UnitGoldPrice:GetNumber()
    local silver = HookAuctionFrame.UnitSilverPrice:GetNumber()
    local copper = HookAuctionFrame.UnitCopperPrice:GetNumber()
    local count = HookAuctionFrame.StackCount:GetNumber()
    local unitMoney = gold*10000 + silver*100 + copper
    local stackMoney = unitMoney*count
    SetCopper(stackMoney, "StackPrice")
end

local function UpdateDepositMoney()
    local HookAuctionFrame = AuctionBar.HookAuctionFrame
    local StackSize = HookAuctionFrame.StackCount:GetNumber()
    local NumStacks = HookAuctionFrame.NumStacks:GetNumber()
    local perDepositMoney = GetAuctionDeposit(1, 1, 1, StackSize, 1)
    local duration = selectedDuration or 1
    if duration == 3 then
        TolDepositMoney = perDepositMoney * 4 * NumStacks
    else
        TolDepositMoney = perDepositMoney * duration * NumStacks
    end
    HookAuctionFrame.totalDepositMoneyLabel:SetText(format("总保管费：|cffffffff%s|r", GetMoneyString(TolDepositMoney)))
end

local f = CreateFrame("Frame")
f:RegisterEvent("AUCTION_HOUSE_SHOW")
f:SetScript("OnEvent", function (slef, event, ...)
    if event == "AUCTION_HOUSE_SHOW" then
        if not AuctionBar.HookAuctionFrame then
            if AuctionFrame and _G["BrowseButton1"] then
                AuctionBar:CreateHookAuctionFrame()
                local id = 1
                local btn = _G["BrowseButton" .. id]
                local ownerTextur
                while btn do
                    ownerTextur = btn:CreateTexture(nil, "BACKGROUND")
                    ownerTextur:SetAllPoints()
                    ownerTextur:SetTexture([[Interface\QuestFrame\UI-QuestLogTitleHighlight]])
                    ownerTextur:Hide()
                    btn.ownerTextur = ownerTextur
                    btn:RegisterForClicks("LeftButtonUp", "RightButtonUp")
                    btn:HookScript("OnClick", function (self, button)
                        local index = mod(self.itemIndex,50) == 0 and 50 or mod(self.itemIndex,50)
                        if button == "LeftButton" then
                            local itemID = select(10, GetAuctionSellItemInfo())
                            local _itemID = select(17, GetAuctionItemInfo("list", index))
                            if itemID and itemID == _itemID and self.buyoutPrice > 0 then
                                local UnitPrice = floor(self.buyoutPrice/self.itemCount) - 1
                                SetCopper(UnitPrice)
                                SetCopper(UnitPrice*HookAuctionFrame.StackCount:GetNumber(), "StackPrice")
                            end
                        end
                    end)
                    id = id + 1
                    btn = _G["BrowseButton" .. id]
                end
                id = 1
                btn = _G["AuctionsButton" .. id]
                while btn do
                    btn:RegisterForClicks("LeftButtonUp", "RightButtonUp")
                    btn:HookScript("OnClick", function (self, button)
                        if button == "RightButton" then
                            local index = GetSelectedAuctionItem("owner")
                            local saleStatus = select(16, GetAuctionItemInfo("owner", index))
                            if saleStatus ~= 1 then
                                CancelAuction(index)
                            end
                        end
                    end)
                    id = id + 1
                    btn = _G["AuctionsButton" .. id]
                end
                hooksecurefunc("FauxScrollFrame_Update", function (frame)
                    if frame == _G["BrowseScrollFrame"] then
                        for i = 1, NUM_BROWSE_TO_DISPLAY do
                            btn = _G["BrowseButton" .. i]
                            if btn.itemIndex then
                                local index = mod(btn.itemIndex,50) == 0 and 50 or mod(btn.itemIndex,50)
                                local owner = select(14, GetAuctionItemInfo("list", index))
                                if owner == UnitName("player") then
                                    btn.ownerTextur:Show()
                                else
                                    btn.ownerTextur:Hide()
                                end
                            end
                        end
                    end
                end)
                hooksecurefunc("AuctionFrameBrowse_Search", function ()
                    local txt = _G["BrowseName"]:GetText() or ""
                    txt = txt:gsub('"', "")
                    if #txt > 0 then
                        EasyAuctionDB.AuctionSortKeyList = EasyAuctionDB.AuctionSortKeyList or {}
                        local index = tIndexOf(EasyAuctionDB.AuctionSortKeyList, txt)
                        if index then
                            tremove(EasyAuctionDB.AuctionSortKeyList, index)
                        end
                        tinsert(EasyAuctionDB.AuctionSortKeyList, 1, txt)
                        if #EasyAuctionDB.AuctionSortKeyList > 20 then
                            for i = #EasyAuctionDB.AuctionSortKeyList, 21, -1 do
                                tremove(EasyAuctionDB.AuctionSortKeyList, i)
                            end
                        end
                    end
                end)
                btn = nil
                ownerTextur = nil
                if IsCanDo() then
                    UpdateSortAnim()
                else
                    UpdateSortAnim(true)
                    return
                end
            end
        end
    end
end)

function AuctionBar:CreateHookAuctionFrame()
    AuctionBar.HookAuctionFrame = AuctionBar.AuctionBarCreateFrame(nil, AuctionFrame, 300, AuctionFrame:GetHeight()-27, nil, nil, nil, "|cffffd700EasyAuction|r拍卖助手")
    local HookAuctionFrame = AuctionBar.HookAuctionFrame
    HookAuctionFrame:SetPoint("TOPLEFT", AuctionFrame, "TOPRIGHT", 0, -15)
    HookAuctionFrame:SetScript("OnShow", function ()
        HookAuctionFrame.New_Auction_Update()
        UpdateDepositMoney()
    end)
    HookAuctionFrame:SetScript("OnMouseUp", function (self, button)
        if button == "LeftButton" then
            local edit = GetCurrentKeyBoardFocus()
            if edit then
                edit:ClearFocus()
            end
        end
    end)

    local showBtn = CreateFrame("Button", nil, AuctionFrame)
    showBtn:SetSize(42, BrowseSearchButton:GetHeight())
    showBtn:SetPoint("LEFT", BrowseSearchButton, "RIGHT", 5, -2)
    HookAuctionFrame.showBtn = showBtn
    showBtn:SetNormalTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Up")
    showBtn:SetHighlightTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Down")
    showBtn:SetPushedTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Down")
    showBtn:SetScript("OnEnter", function(self)
        GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
        GameTooltip:ClearLines()
        GameTooltip:AddLine("显示/隐藏侧边栏")
        GameTooltip:Show()
    end)
    showBtn:SetScript("OnLeave", function(self)
        GameTooltip:Hide()
    end)

    showBtn:SetScript("OnClick", function ()
        if HookAuctionFrame:IsShown() then
            HookAuctionFrame:Hide()
            showBtn:SetNormalTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Up")
        else
            HookAuctionFrame:Show()
            showBtn:SetNormalTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Up")
        end
    end)

    local quicklyCancelAuctionLabel = _G["AuctionFrameAuctions"]:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
    quicklyCancelAuctionLabel:SetJustifyH("LEFT")
    quicklyCancelAuctionLabel:SetPoint("RIGHT", _G["AuctionsCancelAuctionButton"], "LEFT", -5, 0)
    quicklyCancelAuctionLabel:SetText("右键可快速取消拍卖")

    local ItemName = HookAuctionFrame.content:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
    ItemName:SetSize(HookAuctionFrame:GetWidth() - 114, 20)
    ItemName:SetJustifyH("LEFT")
    ItemName:SetPoint("TOPLEFT", 5, -30)
    HookAuctionFrame.ItemName = ItemName

    local infoBtn = CreateFrame("Button", nil, HookAuctionFrame)
    HookAuctionFrame.infoBtn = infoBtn
    infoBtn:SetSize(30, 30)
    infoBtn:SetPoint("TOPLEFT", HookAuctionFrame, "TOPLEFT", 12, -12)
    infoBtn:SetNormalTexture(616343)
    infoBtn:SetHighlightTexture(616343)
    infoBtn:SetScript("OnEnter", function (self)
        AuctionBar.GameTooltipShow(HookAuctionFrame, "TOPLEFT", "TOPRIGHT")
        GameTooltip:AddLine("|TInterface/Icons/INV_Misc_Coin_01:12:12:0:0|t EasyAuction V" .. version .. "               |cffff8800By：|r 晓输童" )
        GameTooltip:AddLine(" ")
        GameTooltip:AddLine("|cffff8800使用方法|r")
        GameTooltip:AddLine("|cff00bfff1、|r禁用其他带有|cffff8800拍卖功能|r的插件，避免卡顿。", 1, 1, 1)
        GameTooltip:AddLine("|cff00bfff2、|r在拍卖行切换到|cffffff00搜索界面|r。", 1, 1, 1)
        GameTooltip:AddLine("|cff00bfff3、|r点击|cffffde00“排序”|r按钮，确保按钮不再闪烁。", 1, 1, 1)
        GameTooltip:AddLine("|cff00bfff4、|r背包中|cffffde00Shift+左键|r选择需要拍卖的物品。", 1, 1, 1)
        GameTooltip:AddLine("|cff00bfff5、|r点击|cffffde00搜索|r。", 1, 1, 1)
        GameTooltip:AddLine("|cff00bfff6、|r在列表选中物品获取价格，自动设置为|cffff4040低一铜|r起拍。", 1, 1, 1)
        GameTooltip:AddLine("     |cffffde00注意：列表价格仅供参考|r，|cffff4040警惕恶意低价！|r", 1, 1, 1)
        GameTooltip:AddLine("     |cffffde00如不合适请翻页查看其他价格。|r", 1, 1, 1)
        GameTooltip:AddLine("|cff00bfff7、|r确认|cffffde00单价|r、|cffffde00堆叠数|r、|cffffde00组数|r无误。", 1, 1, 1)
        GameTooltip:AddLine("|cff00bfff8、|r点击|cffffde00开始拍卖|r。", 1, 1, 1)
        GameTooltip:AddLine(" ")
        GameTooltip:AddLine("|cffff8800注意事项|r")
        GameTooltip:AddLine("|cff00bfff1、|r搜索文本只支持|cffffde00原生方法|r：", 1, 1, 1)
        GameTooltip:AddLine("     如：手动输入、复制粘贴、|cffffde00Shift+左键|r点击物品或链接。", 1, 1, 1)
        GameTooltip:AddLine("|cff00bfff2、|r部分插件可能会影响|cffffde00Shift+左键点击|r功能，导致搜索卡顿。", 1, 1, 1)
        GameTooltip:AddLine("|cff00bfff3、|r必须手动点击|cffffde00搜索按钮|r，其他自动方法可能造成卡顿。", 1, 1, 1)
        GameTooltip:AddLine("|cff00bfff4、|r|cffffde00全局扫描|r后，请不要关闭拍卖行，等|cffffe400“搜索”按钮变亮|r，", 1, 1, 1)
        GameTooltip:AddLine("     再进行搜索或拍卖，否则将导致|cffff4040搜索卡顿|r。", 1, 1, 1)
        GameTooltip:AddLine(" ")
        GameTooltip:AddLine("|cffff8800插件命令|r")
        GameTooltip:AddLine("|cffffde00/epah|r 打开拍卖价格库界面。", 1, 1, 1)
        GameTooltip:AddLine("|cffffde00/epsp|r 开启/关闭 鼠标提示中的价格信息", 1, 1, 1)
        GameTooltip:Show()
    end)
    infoBtn:SetScript("OnLeave", function ()
        GameTooltip:Hide()
    end)
    local sortBtn = CreateFrame("Button", nil, HookAuctionFrame, "UIPanelButtonTemplate")
    sortBtn:SetText("排序")
    sortBtn:SetSize(45, 20)
    sortBtn:SetPoint("LEFT", infoBtn, "RIGHT", 2, 0)
    sortBtn:SetScript("OnClick", function ()
        Set_AuctionSort_Column()
        UpdateSortAnim()
    end)
    sortBtn:SetScript("OnEnter", function (self)
        AuctionBar.GameTooltipShow(self, "TOPLEFT", "BOTTOMRIGHT")
        GameTooltip:AddLine("|cffff8800排序相关提示|r")
        GameTooltip:AddLine("当前排序不符合要求时，本按钮会闪烁提醒。", 1, 1, 1)
        GameTooltip:AddLine("点击按钮切换为|cff40ff40一口价（每单位）升序|r。", 1, 1, 1)
        GameTooltip:Show()
    end)
    sortBtn:SetScript("OnLeave", function(self)
        GameTooltip:Hide()
    end)
    sortBtn.SpellHighlightTexture = sortBtn:CreateTexture("SpellHighlightTexture1", "OVERLAY", nil, 1)
    local SpellHighlightTexture = sortBtn.SpellHighlightTexture
    SpellHighlightTexture:SetAtlas("bags-newitem")
    SpellHighlightTexture:SetSize(60, 26)
    SpellHighlightTexture:SetPoint("CENTER")
    SpellHighlightTexture:SetBlendMode("ADD")
    SpellHighlightTexture:Hide()
    sortBtn.SpellHighlightAnim = SpellHighlightTexture:CreateAnimationGroup() 
    local SpellHighlightAnim = sortBtn.SpellHighlightAnim
    SpellHighlightAnim:SetLooping("REPEAT")
    local alpha1 = SpellHighlightAnim:CreateAnimation("Alpha")
    alpha1:SetChildKey("SpellHighlightTexture")
    alpha1:SetSmoothing("OUT")
    alpha1:SetDuration(0.75)
    alpha1:SetOrder(1)
    alpha1:SetFromAlpha(0)
    alpha1:SetToAlpha(1)
    local alpha2 = SpellHighlightAnim:CreateAnimation("Alpha")
    alpha2:SetChildKey("SpellHighlightTexture")
    alpha2:SetSmoothing("IN")
    alpha2:SetDuration(0.75)
    alpha2:SetOrder(2)
    alpha2:SetFromAlpha(1)
    alpha2:SetToAlpha(0)
    HookAuctionFrame.sortBtn = sortBtn
    local ItemButton = CreateFrame("Button", nil, HookAuctionFrame)
    ItemButton:SetSize(40, 40)
    ItemButton:SetPoint("TOPLEFT", ItemName, "BOTTOMLEFT", 0, -5)
    ItemButton:SetHighlightTexture([[Interface\Buttons\ButtonHilight-Square]])
    ItemButton:SetPushedTexture([[Interface\Buttons\UI-Quickslot-Depress]])
    ItemButton:SetScript("OnEnter", function (self)
        if self.itemID then
            AuctionBar.GameTooltipShow(self, "TOPLEFT", "BOTTOMRIGHT")
            GameTooltip:SetItemByID(self.itemID)
            GameTooltip:Show()
        end
    end)
    ItemButton:SetScript("OnLeave", function ()
        GameTooltip:Hide()
    end)
    ItemButton.EmptySlot = ItemButton:CreateTexture(nil, "BACKGROUND")
    ItemButton.EmptySlot:SetTexture("Interface\\BUTTONS\\UI-Slot-Background")
    ItemButton.EmptySlot:SetDrawLayer("BACKGROUND", 1) 
    ItemButton.EmptySlot:SetAllPoints()
    ItemButton.EmptySlot:SetTexCoord(0, 0.640625, 0, 0.640625)
    ItemButton.icon = ItemButton:CreateTexture(nil, "BACKGROUND")
    ItemButton.icon:SetDrawLayer("BACKGROUND", 2)
    ItemButton.icon:SetAllPoints()
    ItemButton.IconBorder = ItemButton:CreateTexture(nil, "BACKGROUND")
    ItemButton.IconBorder:SetTexture("Interface\\Common\\WhiteIconFrame")
    ItemButton.IconBorder:SetDrawLayer("BACKGROUND", 3)
    ItemButton.IconBorder:SetAllPoints()
    HookAuctionFrame.ItemButton = ItemButton

    ItemButton:SetScript("OnReceiveDrag", function(self)
        if CursorHasItem() then
            ClickAuctionSellItemButton()
            ClearCursor()
        end
    end)

    ItemButton:SetScript("OnMouseUp", function(self, button)
        if button == "LeftButton" and CursorHasItem() then
            ClickAuctionSellItemButton()
            ClearCursor()
        elseif button == "RightButton" then
            ClickAuctionSellItemButton()
        end
    end)
    local UnitPriceLabel = HookAuctionFrame.content:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
    UnitPriceLabel:SetText("单价")
    UnitPriceLabel:SetHeight(20)
    UnitPriceLabel:SetPoint("TOPLEFT", ItemButton, "TOPRIGHT", 5, 0)
    local UnitGoldPrice = MoneyInputEidtBox(HookAuctionFrame, 8, 60, "auctionhouse-icon-coin-gold")
    UnitGoldPrice:SetPoint("LEFT", UnitPriceLabel, "RIGHT", 8, 0)
    UnitGoldPrice:SetScript("OnTextChanged", function ()
        UpdateStackPrice()
    end)
    HookAuctionFrame.UnitGoldPrice = UnitGoldPrice
    local UnitSilverPrice = MoneyInputEidtBox(HookAuctionFrame, 2, 30, "auctionhouse-icon-coin-silver")
    UnitSilverPrice:SetPoint("LEFT", UnitGoldPrice, "RIGHT", 20, 0)
    UnitSilverPrice:SetScript("OnTextChanged", function ()
        UpdateStackPrice()
    end)
    HookAuctionFrame.UnitSilverPrice = UnitSilverPrice
    local UnitCopperPrice = MoneyInputEidtBox(HookAuctionFrame, 2, 30, "auctionhouse-icon-coin-copper")
    UnitCopperPrice:SetPoint("LEFT", UnitSilverPrice, "RIGHT", 20, 0)
    UnitCopperPrice:SetScript("OnTextChanged", function ()
        UpdateStackPrice()
    end)
    HookAuctionFrame.UnitCopperPrice = UnitCopperPrice

    local StackPriceLabel = HookAuctionFrame.content:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
    StackPriceLabel:SetText("总价")
    StackPriceLabel:SetHeight(20)
    StackPriceLabel:SetPoint("TOPLEFT", UnitPriceLabel, "BOTTOMLEFT", 0, -3)
    local StackGoldPrice = MoneyInputEidtBox(HookAuctionFrame, 8, 60, "auctionhouse-icon-coin-gold")
    StackGoldPrice:SetPoint("LEFT", StackPriceLabel, "RIGHT", 8, 0)
    StackGoldPrice:SetScript("OnTextChanged", function ()
        UpdateUnitPrice()
    end)
    HookAuctionFrame.StackGoldPrice = StackGoldPrice
    local StackSilverPrice = MoneyInputEidtBox(HookAuctionFrame, 2, 30, "auctionhouse-icon-coin-silver")
    StackSilverPrice:SetPoint("LEFT", StackGoldPrice, "RIGHT", 20, 0)
    StackSilverPrice:SetScript("OnTextChanged", function ()
        UpdateUnitPrice()
    end)
    HookAuctionFrame.StackSilverPrice = StackSilverPrice
    local StackCopperPrice = MoneyInputEidtBox(HookAuctionFrame, 2, 30, "auctionhouse-icon-coin-copper")
    StackCopperPrice:SetPoint("LEFT", StackSilverPrice, "RIGHT", 20, 0)
    StackCopperPrice:SetScript("OnTextChanged", function ()
        UpdateUnitPrice()
    end)
    HookAuctionFrame.StackCopperPrice = StackCopperPrice

    local StackCountLabel = HookAuctionFrame.content:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
    StackCountLabel:SetText("堆叠数")
    StackCountLabel:SetHeight(20)
    StackCountLabel:SetPoint("TOPLEFT", ItemButton, "BOTTOMLEFT", 0, -10)
    local StackCount = MoneyInputEidtBox(nil, nil, 30)
    StackCount:SetPoint("LEFT", StackCountLabel, "RIGHT", 8, 0)
    StackCount:SetNumber(1)
    StackCount:SetScript("OnTextChanged", function (self)
        local number = self:GetNumber()
        local name, _, _, _, _, _, _, stackCount, totalCount = GetAuctionSellItemInfo()
        if name then
            local maxStackCount = min(stackCount, totalCount)
            if number > maxStackCount then
                self:SetNumber(maxStackCount)
            elseif self:GetNumber() == 0 then
                self:SetNumber(1)
            end
            local oldNumStacks = HookAuctionFrame.NumStacks:GetNumber()
            local maxNumStacks = floor(totalCount/self:GetNumber())
            if oldNumStacks > maxNumStacks then
                HookAuctionFrame.NumStacks:SetNumber(maxNumStacks)
            end
            HookAuctionFrame.MaxNumStacksBtn:SetText("当前")
        elseif self:GetNumber() == 0 then
            self:SetNumber(1)
        end
        UpdateStackPrice()
        UpdateDepositMoney()
    end)
    HookAuctionFrame.StackCount = StackCount

    local MaxStackCountBtn = CreateFrame("Button", nil, HookAuctionFrame, "UIPanelButtonTemplate")
    MaxStackCountBtn:SetSize(40, 22)
    MaxStackCountBtn:SetText("最大")
    MaxStackCountBtn:SetPoint("TOPLEFT", StackCountLabel, "BOTTOMLEFT", 0, -3)
    MaxStackCountBtn:SetScript("OnClick", function ()
        local name, _, _, _, _, _, _, stackCount, totalCount = GetAuctionSellItemInfo()
        if name then
            StackCount:SetNumber(min(stackCount, totalCount))
        end
        HookAuctionFrame.BagItemCountLabel:SetText(("总数：|cff00ff00%d|r"):format(totalCount or 0))
    end)
    MaxStackCountBtn:SetScript("OnEnter", function(self)
        GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
        GameTooltip:ClearLines()
        GameTooltip:AddLine("|cffffd700最大|r")
        GameTooltip:AddLine("按物品最大堆叠自动填写堆叠数和组数", 1, 1, 1)
        GameTooltip:AddLine("例如：最大堆叠20，背包有50个物品，则堆叠数为20，组数为2", 0.8, 0.8, 0.8)
        GameTooltip:Show()
    end)
    MaxStackCountBtn:SetScript("OnLeave", function(self)
        GameTooltip:Hide()
    end)
    HookAuctionFrame.MaxStackCountBtn = MaxStackCountBtn

    local NumStacksLabel = HookAuctionFrame.content:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
    NumStacksLabel:SetText("组数")
    NumStacksLabel:SetHeight(20)
    NumStacksLabel:SetPoint("LEFT", StackCount, "RIGHT", 10, 0)
    local NumStacks = MoneyInputEidtBox(nil, 3, 30)
    NumStacks:SetPoint("LEFT", NumStacksLabel, "RIGHT", 8, 0)
    NumStacks:SetNumber(1)
    NumStacks:SetScript("OnTextChanged", function (self)
        local number = self:GetNumber()
        local _stackCount = StackCount:GetNumber()
        local name, _, _, _, _, _, _, stackCount, totalCount = GetAuctionSellItemInfo()
        if name then
            if number > totalCount then
                self:SetNumber(totalCount)
            elseif number == 0 then
                self:SetNumber(1)
            end
            local maxStackCount = min(stackCount, totalCount, floor(totalCount/self:GetNumber()))
            if _stackCount > maxStackCount then
                StackCount:SetNumber(maxStackCount)
            end
            MaxStackCountBtn:SetText("最大")
        elseif self:GetNumber() == 0 then
            self:SetNumber(1)
        end
        UpdateDepositMoney()
    end)
    HookAuctionFrame.NumStacks = NumStacks

    local MaxNumStacksBtn = CreateFrame("Button", nil, HookAuctionFrame, "UIPanelButtonTemplate")
    MaxNumStacksBtn:SetSize(40, 22)
    MaxNumStacksBtn:SetText("当前")
    MaxNumStacksBtn:SetPoint("LEFT", MaxStackCountBtn, "RIGHT", 12, 0)
    MaxNumStacksBtn:SetScript("OnClick", function ()
        local name, _, _, _, _, _, _, stackCount, totalCount = GetAuctionSellItemInfo()
        if name then
            local stackNum = StackCount:GetNumber()
            if stackNum < 1 then stackNum = 1 end
            local maxGroups = math.floor(totalCount / stackNum)
            if maxGroups < 1 then maxGroups = 1 end
            NumStacks:SetNumber(maxGroups)
        end
        HookAuctionFrame.BagItemCountLabel:SetText(("总数：|cff00ff00%d|r"):format(totalCount or 0))
    end)
    MaxNumStacksBtn:SetScript("OnEnter", function(self)
        GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
        GameTooltip:ClearLines()
        GameTooltip:AddLine("|cffffd700当前|r")
        GameTooltip:AddLine("根据当前堆叠数自动计算组数", 1, 1, 1)
        GameTooltip:AddLine("例如：堆叠数为2，背包有18个，组数为9", 0.8, 0.8, 0.8)
        GameTooltip:Show()
    end)
    MaxNumStacksBtn:SetScript("OnLeave", function(self)
        GameTooltip:Hide()
    end)
    HookAuctionFrame.MaxNumStacksBtn = MaxNumStacksBtn

    local MaxGroupsBtn = CreateFrame("Button", nil, HookAuctionFrame, "UIPanelButtonTemplate")
    MaxGroupsBtn:SetSize(40, 22)
    MaxGroupsBtn:SetText("最多")
    MaxGroupsBtn:SetPoint("LEFT", HookAuctionFrame.MaxNumStacksBtn, "RIGHT", 12, 0)

    MaxGroupsBtn:SetScript("OnClick", function()
        local name, _, _, _, _, _, _, stackCount, totalCount = GetAuctionSellItemInfo()
        if name then
            HookAuctionFrame.StackCount:SetNumber(1)
            HookAuctionFrame.NumStacks:SetNumber(totalCount)
            HookAuctionFrame.BagItemCountLabel:SetText(("总数：|cff00ff00%d|r"):format(totalCount or 0))
        end
        HookAuctionFrame.BagItemCountLabel:SetText(("总数：|cff00ff00%d|r"):format(totalCount or 0))
    end)
    MaxGroupsBtn:SetScript("OnEnter", function(self)
        GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
        GameTooltip:ClearLines()
        GameTooltip:AddLine("|cffffd700最多|r")
        GameTooltip:AddLine("将堆叠数设为1，组数填入背包该物品总数（每组1个）", 1, 1, 1)
        GameTooltip:Show()
    end)
    MaxGroupsBtn:SetScript("OnLeave", function(self)
        GameTooltip:Hide()
    end)


    local AuctionDurations = {
        { text = "12小时", value = 1 },
        { text = "24小时", value = 2 },
        { text = "48小时", value = 3 },
    }
    local DurationDropdown = CreateFrame("Frame", nil, HookAuctionFrame.content, "UIDropDownMenuTemplate")
    DurationDropdown:SetPoint("LEFT", NumStacks, "RIGHT", 0, -2)
    UIDropDownMenu_SetWidth(DurationDropdown, 70)
    UIDropDownMenu_SetText(DurationDropdown, "12小时")
    UIDropDownMenu_Initialize(DurationDropdown, function(self, level, menuList)
        local info = UIDropDownMenu_CreateInfo()
        for i, v in ipairs(AuctionDurations) do
            info.text = v.text
            info.checked = (selectedDuration == v.value)
            info.func = function()
                selectedDuration = v.value
                print("下拉选择时限:", selectedDuration)
                UIDropDownMenu_SetText(DurationDropdown, v.text)
                UpdateDepositMoney()
            end
            UIDropDownMenu_AddButton(info)
        end
    end)

    local StartAuctionBtn = CreateFrame("Button", nil, HookAuctionFrame, "UIPanelButtonTemplate")
    StartAuctionBtn:SetText("开始拍卖")
    StartAuctionBtn:SetSize(88, 35)
    StartAuctionBtn:SetPoint("TOP", DurationDropdown, "BOTTOM", 0, 0)
    HookAuctionFrame.StartAuctionBtn = StartAuctionBtn

    StartAuctionBtn:SetScript("OnClick", function (self)
        local name, texture, _, quality, _, _, _, _, _, itemID = GetAuctionSellItemInfo()
        if texture then
            local stackSize = StackCount:GetNumber()
            local numStacks = NumStacks:GetNumber()
            local buyoutPrice = (UnitGoldPrice:GetNumber()*10000 + UnitSilverPrice:GetNumber()*100 + UnitCopperPrice:GetNumber()) * stackSize
            local minBid = buyoutPrice * 0.99
            local runTime = selectedDuration or 1

            local vendorPrice = select(11, GetItemInfo(itemID)) or 0
            local baseDeposit = GetAuctionDeposit(minBid, buyoutPrice, 1, stackSize, 1)
            local multiplier = (runTime == 1 and 1) or (runTime == 2 and 2) or 4
            local perDepositMoney = baseDeposit * multiplier
            local unitPrice = UnitGoldPrice:GetNumber()*10000 + UnitSilverPrice:GetNumber()*100 + UnitCopperPrice:GetNumber()
            local minBidSingle = unitPrice * 0.99
            local buyoutSingle = unitPrice
            local singleDeposit = GetAuctionDeposit(minBidSingle, buyoutSingle, 1, 1, 1) * multiplier

            if vendorPrice > 0 then
                if (unitPrice - singleDeposit) < vendorPrice then
                    StaticPopupDialogs["EASYAUCTION_LOW_PRICE"] = {
                        text = 
                            "喂，伙计！你的|cffffde00一口价|r太低了！\n\n" ..
                            "拍卖扣完保管费，连卖店都不如，" ..
                            "这买卖我喜欢！\n\n" ..
                            "|cffff4040你亏我赚，大家都开心！|r",
                        button1 = "|cff00ff00生意嘛，总得有人亏本！|r",
                        button2 = "|cffff4040等等，我再改改价钱……|r",
                        OnAccept = function()
                            PostAuction(minBid, buyoutPrice, runTime, stackSize, numStacks, false)
                        end,
                        timeout = 0,
                        whileDead = true,
                        hideOnEscape = true,
                        preferredIndex = 3,
                    }
                    StaticPopup_Show("EASYAUCTION_LOW_PRICE")
                    return
                end
            end

            if stackSize > 0 and numStacks > 0 and buyoutPrice > 0 then
                if PostAuction(minBid, buyoutPrice, runTime, stackSize, numStacks, false) then
                    AuctionsCreateAuctionButton:ClearPost();
                else
                    AuctionsCreateAuctionButton:CachePendingPost(minBid, buyoutPrice, runTime, stackSize, numStacks, false);
                end
            end
        end
    end)

    local depositMoneyLabel = HookAuctionFrame.content:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
    depositMoneyLabel:SetSize(HookAuctionFrame:GetWidth() - 10, 18)
    depositMoneyLabel:SetFont(GameFontNormal:GetFont(), 13)
    depositMoneyLabel:SetJustifyH("LEFT")
    depositMoneyLabel:SetTextColor(1, 0.82, 0)
    depositMoneyLabel:SetPoint("TOPLEFT", MaxStackCountBtn, "BOTTOMLEFT", 0, -5)
    HookAuctionFrame.depositMoneyLabel = depositMoneyLabel

    local BagItemCountLabel = HookAuctionFrame.content:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
    BagItemCountLabel:SetSize(120, 18)
    BagItemCountLabel:SetFont(GameFontNormal:GetFont(), 13)
    BagItemCountLabel:SetJustifyH("LEFT")
    BagItemCountLabel:SetTextColor(0.7, 1, 0.7)
    BagItemCountLabel:SetPoint("TOPLEFT", MaxStackCountBtn, "BOTTOMLEFT", 2, 0)
    HookAuctionFrame.BagItemCountLabel = BagItemCountLabel
    
    local totalDepositMoneyLabel = HookAuctionFrame.content:CreateFontString(nil, "ARTWORK")
    totalDepositMoneyLabel:SetSize(HookAuctionFrame:GetWidth() - 10, 18)
    totalDepositMoneyLabel:SetFont(GameFontNormal:GetFont(), 13)
    totalDepositMoneyLabel:SetJustifyH("LEFT")
    totalDepositMoneyLabel:SetTextColor(1, 0.82, 0)
    totalDepositMoneyLabel:SetPoint("TOPLEFT", BagItemCountLabel, "BOTTOMLEFT", 2, -2)
    HookAuctionFrame.totalDepositMoneyLabel = totalDepositMoneyLabel

    if not HookAuctionFrame.MyAuctionListFrame then
        local f = CreateFrame("Frame", nil, HookAuctionFrame, BackdropTemplateMixin and "BackdropTemplate")
        f:SetSize(HookAuctionFrame:GetWidth() - 20, 210)
        f:SetPoint("TOPLEFT", totalDepositMoneyLabel, "BOTTOMLEFT", -10, -2)
        if f.SetBackdrop then
            f:SetBackdrop({bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", edgeFile=nil, tile=true, tileSize=16, edgeSize=16})
        end
        f:EnableMouse(true)
        f:Show()
        HookAuctionFrame.MyAuctionListFrame = f

        local title = f:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
        title:SetPoint("TOPLEFT", 5, -4)
        title:SetText("拍卖列表（右键取消）")

        local scroll = CreateFrame("ScrollFrame", "EasyAuctionScrollFrame", f, "FauxScrollFrameTemplate")
        scroll:SetPoint("TOPLEFT", f, "TOPLEFT", 0, -20)
        scroll:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", -18, 6)
        f.scroll = scroll
        f.scroll:SetScript("OnVerticalScroll", function(self, offset)
            FauxScrollFrame_OnVerticalScroll(self, offset, 18, function() HookAuctionFrame:RefreshMyAuctionList() end)
        end)
        local maxRows = 10
        f.rows = {}
        for i = 1, maxRows do
            local row = CreateFrame("Button", nil, f)
            row:SetSize(f:GetWidth() - 20, 18)
            row:SetPoint("TOPLEFT", 5, -20 - (i-1)*19)
            row.nameText = row:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
            row.nameText:SetPoint("LEFT", 4, 0)
            row.nameText:SetWidth(90)
            row.nameText:SetJustifyH("LEFT")
            row.nameText:SetWordWrap(false)
            row.priceText = row:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
            row.priceText:SetPoint("LEFT", row.nameText, "RIGHT", 8, 0)
            row.priceText:SetWidth(105) 
            row.priceText:SetJustifyH("RIGHT")
            row.durationText = row:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
            row.durationText:SetPoint("LEFT", row.priceText, "RIGHT", 8, 0)
            row.durationText:SetWidth(60)
            row.durationText:SetJustifyH("LEFT")
            row.bg = row:CreateTexture(nil, "BACKGROUND")
            row.bg:SetAllPoints()
            row.bg:SetColorTexture(1,1,1, (i%2==0) and 0.05 or 0.10)
            row:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
            row:SetScript("OnMouseUp", function(self, btn)
                if btn == "RightButton" and self.auctionIndex then
                    CancelAuction(self.auctionIndex)
                end
            end)
            row:SetScript("OnEnter", function(self)
                self.bg:SetColorTexture(0.3,0.6,1,0.18)
                if self.link then
                    GameTooltip:SetOwner(self, "ANCHOR_RIGHT")
                    GameTooltip:SetHyperlink(self.link)
                    GameTooltip:AddLine("右键取消该拍卖", 1,0.6,0.2)
                    GameTooltip:Show()
                end
            end)
            row:SetScript("OnLeave", function(self)
                row.bg:SetColorTexture(1,1,1, (i%2==0) and 0.05 or 0.10)
                GameTooltip:Hide()
            end)
            f.rows[i] = row
        end
    end

    function HookAuctionFrame:RefreshMyAuctionList()
        local f = self.MyAuctionListFrame
        if not f then return end
        local num = GetNumAuctionItems("owner")
        local maxRows = #f.rows
        local scroll = f.scroll
        local offset = FauxScrollFrame_GetOffset(scroll)
        FauxScrollFrame_Update(scroll, num, maxRows, 18)

        for i = 1, maxRows do
            local idx = offset + i
            local row = f.rows[i]
            if idx <= num then
                local res = {GetAuctionItemInfo("owner", idx)}
                local name = res[1]
                local count = tonumber(res[3]) or 0
                local buyout = tonumber(res[10]) or 0
                local buyer = res[12] or ""
                if count == 0 and buyer ~= "" then
                    local displayCount = tonumber(res[4]) or 1
                    local nameCountStr = TruncateNameAndKeepCount(row.nameText, name or "?", displayCount, 200)
                    local grayColor  = "|cffbbbbbb"
                    local qtyColor   = "|cffffff00"
                    local soldIcon   = "|TInterface\\Icons\\classic_temp:16:16:0:-2|t"
                    local itemName, itemQty = string.match(nameCountStr, "^(.-)( x%d+)$")
                    if not itemName then itemName = nameCountStr; itemQty = "" end
                    local nameShow = string.format("%s%s|r%s%s|r %s|cffff8800已售出|r", grayColor, itemName, qtyColor, itemQty, soldIcon)
                    row.nameText:SetWidth(200)
                    row.nameText:SetText(nameShow)
                    row.priceText:SetText("")
                    row.durationText:SetText("")
                    row.link = GetAuctionItemLink("owner", idx)
                    row.auctionIndex = nil
                    row:Show()
                elseif count > 0 and buyout > 0 then
                    row.nameText:SetWidth(90)
                    local nameColor  = "|cffffffff"
                    local qtyColor   = "|cffffff00"
                    local nameCountStr = TruncateNameAndKeepCount(row.nameText, name or "?", count, 90)
                    local itemName, itemQty = string.match(nameCountStr, "^(.-)( x%d+)$")
                    if not itemName then itemName = nameCountStr; itemQty = "" end
                    local nameShow = string.format("%s%s|r%s%s|r", nameColor, itemName, qtyColor, itemQty)
                    row.nameText:SetText(nameShow)
                    local price = buyout / count
                    local priceStr = GetShortMoneyString(price, 110)
                    local timeLeft = GetAuctionItemTimeLeft("owner", idx)
                    local durationStr = ""
                    if timeLeft == 1 then
                        durationStr = "|cffff8800<30分钟|r"
                    elseif timeLeft == 2 then
                        durationStr = "|cff00ff002小时|r"
                    elseif timeLeft == 3 then
                        durationStr = "|cff00bfff12小时|r"
                    elseif timeLeft == 4 then
                        durationStr = "|cffffff0048小时|r"
                    end
                    row.priceText:SetText(priceStr)
                    row.durationText:SetText(durationStr)
                    row.link = GetAuctionItemLink("owner", idx)
                    row.auctionIndex = idx
                    row:Show()
                else
                    row:Hide()
                end
            else
                row:Hide()
                row.link = nil
                row.auctionIndex = nil
            end
        end
    end
    local lastAuctionItemID
    function HookAuctionFrame.New_Auction_Update()
        local name, texture, _, quality, _, _, _, stackCount, totalCount, itemID = GetAuctionSellItemInfo()
        if name then
            ItemButton:Enable()
            ItemButton.icon:SetTexture(texture)
            ItemButton.itemID = itemID
            ItemName:SetText(name)
            local color = ITEM_QUALITY_COLORS[quality]
            ItemName:SetVertexColor(color.r, color.g, color.b)
            local maxStackCount = min(stackCount, totalCount)
            if itemID ~= lastAuctionItemID then
                StackCount:SetNumber(maxStackCount)
                NumStacks:SetNumber(1)
                lastAuctionItemID = itemID
            end
            if StackCount:GetNumber() > maxStackCount then
                StackCount:SetNumber(maxStackCount)
            end
            if NumStacks:GetNumber() > totalCount then
                NumStacks:SetNumber(totalCount)
            end
            MaxStackCountBtn:SetText("最大")
            MaxNumStacksBtn:SetText("当前")
            HookAuctionFrame.BagItemCountLabel:SetText(("总数：|cff00ff00%d|r"):format(totalCount or 0))
        else
            ItemButton:Disable()
            ItemButton.icon:SetTexture()
            ItemButton.itemID = nil
            ItemName:SetText("")
            UnitGoldPrice:SetNumber(0)
            UnitSilverPrice:SetNumber(0)
            UnitCopperPrice:SetNumber(0)
            StackGoldPrice:SetNumber(0)
            StackSilverPrice:SetNumber(0)
            StackCopperPrice:SetNumber(0)
            StackCount:SetNumber(1)
            NumStacks:SetNumber(1)
            lastAuctionItemID = nil
            MaxStackCountBtn:SetText("最大")
            MaxNumStacksBtn:SetText("当前")
            HookAuctionFrame.BagItemCountLabel:SetText("总数")
        end
    end

    local New_Auction_Update = HookAuctionFrame.New_Auction_Update
    HookAuctionFrame:RegisterEvent("NEW_AUCTION_UPDATE")
    HookAuctionFrame:RegisterEvent("AUCTION_ITEM_LIST_UPDATE")
    HookAuctionFrame:RegisterEvent("AUCTION_OWNED_LIST_UPDATE")
    HookAuctionFrame:RegisterEvent("AUCTION_HOUSE_SHOW")
    HookAuctionFrame:RegisterEvent("CHAT_MSG_SYSTEM")
    HookAuctionFrame:RegisterEvent("UI_ERROR_MESSAGE")
    HookAuctionFrame:SetScript("OnEvent", function (self, event, ...)
        if event == "NEW_AUCTION_UPDATE" then
            New_Auction_Update()
            UpdateDepositMoney()
        elseif event == "AUCTION_OWNED_LIST_UPDATE" or event == "AUCTION_HOUSE_SHOW" then
            if IsCanDo() then
                UpdateSortAnim()
            else
                UpdateSortAnim(true)
                return
            end
            self:RefreshMyAuctionList()
        elseif event == "AUCTION_ITEM_LIST_UPDATE" then
            if IsCanDo() then
                UpdateSortAnim()
            else
                UpdateSortAnim(true)
                return
            end    
        elseif event == "AUCTION_OWNED_LIST_UPDATE" then
            if not IsCanDo() then return end
            local isExist
            local _, _, count, _, _, _, _, _, _, buyoutPrice, _, _, _, owner, _, _, itemId = GetAuctionItemInfo("list", 1)
            if itemId and buyoutPrice > 0 then
                local itemLink = GetAuctionItemLink("list", 1)
                UnitPrice = floor(buyoutPrice/count)
                local ownerItemLink, ownercount, ownerbuyoutPrice, ownersaleStatus, _
                for index = 1, GetNumAuctionItems("owner") do
                    ownerItemLink = GetAuctionItemLink("owner", index)
                    if ownerItemLink == itemLink then
                        _, _, ownercount, _, _, _, _, _, _, ownerbuyoutPrice, _, _, _, _, _, ownersaleStatus = GetAuctionItemInfo("owner", index)
                        if ownersaleStatus ~= 1 and ownerbuyoutPrice > 0 and ownerbuyoutPrice/ownercount > buyoutPrice/count then
                            isExist = true
                            break
                        end
                    end
                end
            end
        end
    end)
    hooksecurefunc("AuctionFrameTab_OnClick", function(self, button, down)
        local HookAuctionFrame = AuctionBar and AuctionBar.HookAuctionFrame
        if not HookAuctionFrame then return end
        local tab = self:GetID()
        if tab == 1 then
            if not HookAuctionFrame:IsShown() then
                HookAuctionFrame:Show()
            end
        else
            if HookAuctionFrame:IsShown() then
                HookAuctionFrame:Hide()
            end
        end
    end)
end

local function BagItemClickHook(self, button)
    local containerInfo = C_Container.GetContainerItemInfo(self:GetParent():GetID(), self:GetID())
    if not containerInfo then return end
    if button == "LeftButton" and IsShiftKeyDown() and AuctionFrameBrowse and AuctionFrameBrowse:IsShown() then
        ClearCursor()
        ClickAuctionSellItemButton()
        ClearCursor()
        C_Container.PickupContainerItem(self:GetParent():GetID(), self:GetID())
        ClickAuctionSellItemButton()
        ClearCursor()
        return
    end
end

hooksecurefunc("ContainerFrameItemButton_OnModifiedClick", BagItemClickHook)
