local mod	= DBM:NewMod(584, "DBM-Party-WotLK", 1, 271)
local L		= mod:GetLocalizedStrings()

mod:SetRevision("20231117105343")
mod:SetCreatureID(29311)
mod:SetEncounterID(1968)

mod:RegisterCombat("combat")

mod:RegisterEvents(
	"SPELL_CAST_START 60848"
)

if mod:IsClassic() then
	mod:RegisterEventsInCombat(
		"UNIT_SPELLCAST_START"
	)
else
	mod.statTypes = "normal,heroic,timewalker"
	mod:RegisterEventsInCombat(
		"UNIT_SPELLCAST_START boss1"
	)
end

local warnShadowCrash			= mod:NewTargetAnnounce(62660, 4)
local warningInsanity			= mod:NewCastAnnounce(57496, 3)--Not currently working, no CLEU for it

local specWarnShadowCrash		= mod:NewSpecialWarningDodge(62660, nil, nil, nil, 1, 2)
local yellShadowCrash			= mod:NewYell(62660)

local timerInsanity				= mod:NewCastTimer(5, 57496, nil, nil, nil, 6)
local timerAchieve				= mod:NewAchievementTimer(120, 1862)

function mod:OnCombatStart(delay)
	if not self:IsDifficulty("normal5") then
		timerAchieve:Start(-delay)
	end
end

function mod:ShadowCrashTarget(targetname, uId)
	if not targetname then
		if DBM.Options.DebugMode then
			warnShadowCrash:Show(DBM_COMMON_L.UNKNOWN)
		end
		return
	end
	if self:AntiSpam(2, targetname) then--In case more than 1 pulled and target same person, avoid double/tripple warn
		if targetname == UnitName("player") then
			specWarnShadowCrash:Show()
			specWarnShadowCrash:Play("watchstep")
			yellShadowCrash:Yell()
		else
			warnShadowCrash:Show(targetname)
		end
	end
end

function mod:SPELL_CAST_START(args)
	if args.spellId == 60848 then
		self:BossTargetScanner(args.sourceGUID, "ShadowCrashTarget", 0.1, 12, nil, nil, nil, nil, true)
	end
end

function mod:UNIT_SPELLCAST_START(uId, _, spellId)
   if spellId == 57496 then -- Insanity
		if self:IsClassic() then
			self:SendSync("Insanity")
		else
			warningInsanity:Show()
			timerInsanity:Start()
		end
   end
end

function mod:OnSync(event)
	if not self:IsInCombat() then return end
	if event == "Insanity" then
		warningInsanity:Show()
		timerInsanity:Start()
	end
end
