local ALName, ALPrivate = ...

local AtlasLoot = _G.AtlasLoot
local ItemSet = {}
AtlasLoot.Data.ItemSet = ItemSet
local Requirements = AtlasLoot.Data.Requirements
local AL = AtlasLoot.Locales
local ALIL = AtlasLoot.IngameLocales
local IMAGE_PATH = ALPrivate.ICONS_PATH

local GetItemSetInfo = GetItemSetInfo

-- lua
local assert, type = _G.assert, _G.type
local format = _G.string.format

-- WoW
local GetItemQualityColor, GetItemIcon, GetSpellDescription = _G.GetItemQualityColor, _G.GetItemIcon, _G.GetSpellDescription

local NO_ICON = "Interface\\Icons\\inv_helmet_08"
local ICON_PATH_CLASS = ALPrivate.CLASS_ICON_PATH
local CLASS_BIT_TO_CLASS = ALPrivate.CLASS_BIT_TO_CLASS

local SPECIAL_ICONS = {
	[466] = GetItemIcon(19898), -- Major Mojo Infusion
	[462] = GetItemIcon(19905), -- Zanzil's Concentration
	[465] = GetItemIcon(19863), -- Prayer of the Primal
	[464] = GetItemIcon(19873), -- Overlord's Resolution
	[461] = GetItemIcon(19865), -- The Twin Blades of Hakkari
	[41]  = GetItemIcon(12940), -- Dal'Rend's Arms
	[463] = GetItemIcon(19896), -- Primal Blessing
	[261] = GetItemIcon(18203), -- Spirit of Eskhandar
	[65]  = GetItemIcon(13183), -- Spider's Kiss
}
local COLOR_STRINGS = {}
local ContentPhaseCache = {}
local CLASS_NAMES_WITH_COLORS = {}
local ContentPhase

local function OnInit()
    for i=0,7 do
		local _, _, _, itemQuality = GetItemQualityColor(i)
		COLOR_STRINGS[i] = "|c"..itemQuality
	end

    CLASS_NAMES_WITH_COLORS = AtlasLoot:GetColoredClassNames()
    ContentPhase = AtlasLoot.Data.ContentPhase
end
AtlasLoot:AddInitFunc(OnInit)


-- Formatting from special sets as some sets use the same base set
-- [addon][raidSize][diff][setID]
-- addon: 1=classic, 2=bc, 3=wrath
-- raidSize: normal=00,10man=10,25man=25
-- diff: 0=normal, 1=heroic
-- example: 3100801 = Wotlk Set with the ID 801, 10man normal version
local ITEM_SET_DATA, ITEM_SET_DATA_RAW = AtlasLoot:GetGameVersionDataTable()
ITEM_SET_DATA_RAW.CLASSIC = {
	-- [setID] { {itemID's}, armorTypeID, qualityID, itemLevelAvg, allowableClasses, {{setNum, setSpellID}} }
	[1] = {{11729,11726,11730,11728,11731},3,3,57,0,{{2,9761},{3,7514},{4,9140},{5,7597}}}, -- The Gladiator
	[41] = {{12940,12939},0,3,63,0,{{2,14056}}}, -- Dal'Rend's Arms
	[65] = {{13183,13218},0,3,61,0,{{2,17332}}}, -- Spider's Kiss
	[81] = {{13390,13388,13389,13391,13392},1,3,61,0,{{2,9764},{3,14590},{3,14712},{4,9417},{5,9106},{5,17498}}}, -- The Postmaster
	[121] = {{14637,14640,14636,14638,14641},2,3,61,0,{{2,7516},{3,9140},{4,18686},{5,15465}}}, -- Cadaverous Garb
	[122] = {{14633,14626,14629,14632,14631},1,3,61,0,{{2,7516},{3,7495},{4,18686},{5,14047}}}, -- Necropile Raiment
	[123] = {{14611,14615,14614,14612,14616},3,3,61,0,{{2,7516},{3,9140},{4,18686},{5,13665}}}, -- Bloodmail Regalia
	[124] = {{14624,14622,14620,14623,14621},4,3,61,0,{{2,7516},{3,9764},{4,18686},{5,13665}}}, -- Deathbone Guardian
	[141] = {{15055,15053,15054},2,2,57,0,{{3,9233}}}, -- Volcanic Armor
	[142] = {{15058,15056,21278,15057},2,3,58,32767,{{2,18979},{3,23863},{4,9142}}}, -- Stormshroud Armor
	[143] = {{15063,15062},2,3,59,0,{{2,15465}}}, -- Devilsaur Armor
	[144] = {{15067,15066},2,3,56,0,{{2,14799}}}, -- Ironfeather Armor
	[161] = {{10399,10401,10403,10400,10402},2,2,20,0,{{2,9760},{3,14707},{4,7534},{5,9140}}}, -- Defias Leather
	[162] = {{6473,10413,10412,10410,10411},2,2,22,0,{{2,7694},{3,20607},{4,7679},{5,9106}}}, -- Embrace of the Viper
	[163] = {{10328,10333,10331,10329,10330,10332},3,2,38,0,{{2,9760},{3,7513},{4,14668},{5,20606},{6,15464}}}, -- Chain of the Scarlet Crusade
	[181] = {{16686,16689,16688,16683,16684,16685,16687,16682},1,3,60,0,{{2,29091},{4,30777},{6,27867},{8,18679}}}, -- Magister's Regalia
	[182] = {{16693,16695,16690,16697,16692,16696,16694,16691},1,3,60,0,{{2,14803},{4,30779},{6,27778},{8,18679}}}, -- Vestments of the Devout
	[183] = {{16698,16701,16700,16703,16705,16702,16699,16704},1,3,60,0,{{2,29090},{4,30778},{6,27780},{8,18679}}}, -- Dreadmist Raiment
	[184] = {{16707,16708,16721,16710,16712,16713,16709,16711},2,3,60,0,{{2,29096},{4,30771},{6,27787},{8,18679}}}, -- Shadowcraft Armor
	[185] = {{16720,16718,16706,16714,16717,16716,16719,16715},2,3,60,0,{{2,29097},{4,9344},{4,9334},{6,27781},{8,18679}}}, -- Wildheart Raiment
	[186] = {{16677,16679,16674,16681,16676,16680,16678,16675},3,3,60,0,{{2,29094},{4,30772},{6,27785},{8,18679}}}, -- Beaststalker Armor
	[187] = {{16667,16669,16666,16671,16672,16673,16668,16670},3,3,60,0,{{2,29095},{4,30780},{6,27774},{8,18679}}}, -- The Elements
	[188] = {{16727,16729,16726,16722,16724,16723,16728,16725},4,3,60,0,{{2,29093},{4,30775},{6,27498},{8,18679}}}, -- Lightforge Armor
	[189] = {{16731,16733,16730,16735,16737,16736,16732,16734},4,3,60,0,{{2,29092},{4,30770},{6,27419},{8,18679}}}, -- Battlegear of Valor
	[201] = {{16795,16797,16798,16799,16801,16802,16796,16800},1,4,66,128,{{3,9346},{5,26175},{8,23545}}}, -- Arcanist Regalia
	[202] = {{16813,16816,16815,16819,16812,16817,16814,16811},1,4,66,16,{{3,21973},{5,21092},{8,23550}}}, -- Vestments of Prophecy
	[203] = {{16808,16807,16809,16804,16805,16806,16810,16803},1,4,66,256,{{3,23554},{5,21741},{8,23553}}}, -- Felheart Raiment
	[204] = {{16821,16823,16820,16825,16826,16827,16822,16824},2,4,66,8,{{3,21874},{5,21975},{8,23582}}}, -- Nightslayer Armor
	[205] = {{16834,16836,16833,16830,16831,16828,16835,16829},2,4,66,1024,{{3,23557},{5,18382},{8,23556}}}, -- Cenarion Raiment
	[206] = {{16846,16848,16845,16850,16852,16851,16847,16849},3,4,66,4,{{3,23560},{5,21926},{8,23566}}}, -- Giantstalker Armor
	[207] = {{16842,16844,16841,16840,16839,16838,16843,16837},3,4,66,64,{{3,21895},{5,23572},{8,23573}}}, -- The Earthfury
	[208] = {{16854,16856,16853,16857,16860,16858,16855,16859},4,4,66,2,{{3,23564},{5,7597},{5,18384},{8,21747}}}, -- Lawbringer Armor
	[209] = {{16866,16868,16865,16861,16863,16864,16867,16862},4,4,66,1,{{3,23562},{5,21838},{8,23561}}}, -- Battlegear of Might
	[210] = {{16914,16917,16916,16918,16913,16818,16915,16912},1,4,76,128,{{3,21879},{5,23549},{8,22007}}}, -- Netherwind Regalia
	[211] = {{16921,16924,16923,16926,16920,16925,16922,16919},1,4,76,16,{{3,21894},{5,21853},{8,22010}}}, -- Vestments of Transcendence
	[212] = {{16929,16932,16931,16934,16928,16933,16930,16927},1,4,76,256,{{3,14047},{5,21922},{8,23555}}}, -- Nemesis Raiment
	[213] = {{16908,16832,16905,16911,16907,16910,16909,16906},2,4,76,8,{{3,21881},{5,23558},{8,23581}}}, -- Bloodfang Armor
	[214] = {{16900,16902,16897,16904,16899,16903,16901,16898},2,4,76,1024,{{3,21894},{5,21872},{8,21871}}}, -- Stormrage Raiment
	[215] = {{16939,16937,16942,16935,16940,16936,16938,16941},3,4,76,4,{{3,23559},{5,21928},{8,23578}}}, -- Dragonstalker Armor
	[216] = {{16947,16945,16950,16943,16948,16944,16946,16949},3,4,76,64,{{3,21899},{5,23570},{8,23551}}}, -- The Ten Storms
	[217] = {{16955,16953,16958,16951,16956,16952,16954,16957},4,4,76,2,{{3,23565},{5,24196},{8,23591}}}, -- Judgement Armor
	[218] = {{16963,16961,16966,16959,16964,16960,16962,16965},4,4,76,1,{{3,23563},{5,21890},{8,23548}}}, -- Battlegear of Wrath
	[221] = {{7953,7950,7951,7948,7949,7952},2,2,37,8,{{6,7597}}}, -- Garb of Thero-shan
	[241] = {{17064,17082},0,4,73,0,{{2,18681}}}, -- Shard of the Gods
	[261] = {{18205,18204,18203,18202},0,4,67,0,{{4,22648}}}, -- Spirit of Eskhandar
	[281] = {{16514,16516,16513,16510,16515,16509},4,3,63,1,{{2,13665},{4,22738},{6,14462}}}, -- Champion's Battlegear
	[282] = {{16429,16432,16430,16406,16431,16405},4,3,63,1,{{2,13665},{4,22738},{6,14462}}}, -- Lieutenant Commander's Battlegear
	[301] = {{16521,16524,16522,16519,16523,16518},3,3,63,64,{{2,14049},{4,22804},{6,14462}}}, -- Champion's Earthshaker
	[321] = {{12427,12428,12422,12425,12424,12429,12426},4,2,57,0,{{2,15666},{4,9335},{6,14465}}}, -- Imperial Plate
	[341] = {{16489,16492,16491,16487,16490,16485},1,3,63,128,{{2,14047},{4,23025},{6,14462}}}, -- Champion's Regalia
	[342] = {{17610,17613,17612,17617,17611,17616},1,3,63,16,{{2,14047},{4,23044},{6,14462}}}, -- Champion's Raiment
	[343] = {{16416,16415,16413,16391,16414,16369},1,3,63,128,{{2,14047},{4,23025},{6,14462}}}, -- Lieutenant Commander's Regalia
	[344] = {{17598,17601,17600,17596,17599,17594},1,3,63,16,{{2,14047},{4,23044},{6,14462}}}, -- Lieutenant Commander's Raiment
	[345] = {{17570,17573,17572,17577,17571,17576},1,3,63,256,{{2,14047},{4,23047},{6,14462}}}, -- Champion's Threads
	[346] = {{17566,17569,17568,17564,17567,17562},1,3,63,256,{{2,14047},{4,23047},{6,14462}}}, -- Lieutenant Commander's Threads
	[347] = {{16506,16507,16505,16499,16508,16498},2,3,63,8,{{2,13665},{4,23048},{6,14462}}}, -- Champion's Vestments
	[348] = {{16418,16420,16417,16396,16419,16392},2,3,63,8,{{2,13665},{4,23048},{6,14462}}}, -- Lieutenant Commander's Vestments
	[361] = {{16526,16528,16525,16530,16527,16531},3,3,63,4,{{2,13665},{4,23158},{6,14462}}}, -- Champion's Pursuit
	[362] = {{16428,16427,16425,16403,16426,16401},3,3,63,4,{{2,13665},{4,23158},{6,14462}}}, -- Lieutenant Commander's Pursuit
	[381] = {{16424,16423,16421,16397,16422,16393},2,3,63,1024,{{2,14049},{4,23218},{6,14462}}}, -- Lieutenant Commander's Sanctuary
	[382] = {{16503,16501,16504,16496,16502,16494},2,3,63,1024,{{2,14049},{4,23218},{6,14462}}}, -- Champion's Sanctuary
	[383] = {{16542,16544,16541,16548,16543,16545},4,4,73,1,{{2,14467},{3,22738},{6,14049}}}, -- Warlord's Battlegear
	[384] = {{16478,16480,16477,16484,16479,16483},4,4,73,1,{{2,14467},{3,22738},{6,14049}}}, -- Field Marshal's Battlegear
	[386] = {{16578,16580,16577,16574,16579,16573},3,4,73,64,{{2,14467},{3,22804},{6,14049}}}, -- Warlord's Earthshaker
	[387] = {{16533,16536,16535,16540,16534,16539},1,4,73,128,{{2,14467},{3,23025},{6,14047}}}, -- Warlord's Regalia
	[388] = {{16441,16444,16443,16440,16442,16437},1,4,73,128,{{2,14467},{3,23025},{6,14047}}}, -- Field Marshal's Regalia
	[389] = {{17602,17604,17605,17608,17603,17607},1,4,73,16,{{2,14467},{3,23044},{6,14047}}}, -- Field Marshal's Raiment
	[390] = {{17623,17622,17624,17620,17625,17618},1,4,73,16,{{2,14467},{3,23044},{6,14047}}}, -- Warlord's Raiment
	[391] = {{17591,17590,17592,17588,17593,17586},1,4,73,256,{{2,14467},{3,23047},{6,14047}}}, -- Warlord's Threads
	[392] = {{17578,17580,17581,17584,17579,17583},1,4,73,256,{{2,14467},{3,23047},{6,14047}}}, -- Field Marshal's Threads
	[393] = {{16561,16562,16563,16560,16564,16558},2,4,73,8,{{2,14467},{3,23048},{6,14049}}}, -- Warlord's Vestments
	[394] = {{16455,16457,16453,16454,16456,16446},2,4,73,8,{{2,14467},{3,23048},{6,14049}}}, -- Field Marshal's Vestments
	[395] = {{16465,16468,16466,16463,16467,16462},3,4,73,4,{{2,14467},{3,23158},{6,14384}}}, -- Field Marshal's Pursuit
	[396] = {{16566,16568,16565,16571,16567,16569},3,4,73,4,{{2,14467},{3,23158},{6,14384}}}, -- Warlord's Pursuit
	[397] = {{16451,16449,16452,16448,16450,16459},2,4,73,1024,{{2,14467},{3,23218},{6,14049}}}, -- Field Marshal's Sanctuary
	[398] = {{16550,16551,16549,16555,16552,16554},2,4,73,1024,{{2,14467},{3,23218},{6,14049}}}, -- Warlord's Sanctuary
	[401] = {{16434,16436,16433,16410,16435,16409},4,3,63,2,{{2,7496},{2,28118},{4,23302},{6,14462}}}, -- Lieutenant Commander's Aegis
	[402] = {{16474,16476,16473,16471,16475,16472},4,4,73,2,{{2,14467},{3,23302},{6,14047}}}, -- Field Marshal's Aegis
	[421] = {{19682,19683,19684},1,3,65,0,{{3,18382}}}, -- Bloodvine Garb
	[441] = {{19685,19687,19686},2,3,65,0,{{3,24090}}}, -- Primal Batskin
	[442] = {{19689,19688},2,3,65,0,{{2,18384},{2,7597}}}, -- Blood Tiger Harness
	[443] = {{19691,19690,19692},3,3,65,0,{{3,21636}}}, -- Bloodsoul Embrace
	[444] = {{19695,19693,19694},4,3,65,0,{{3,21416}}}, -- The Darksoul
	[461] = {{19865,19866},0,4,67,0,{{2,15763}}}, -- The Twin Blades of Hakkari
	[462] = {{19893,19905},0,3,70,0,{{2,9396},{2,23727}}}, -- Zanzil's Concentration
	[463] = {{19896,19910},0,4,65,0,{{2,24256}}}, -- Primal Blessing
	[464] = {{19912,19873},0,3,70,0,{{2,13669}}}, -- Overlord's Resolution
	[465] = {{19920,19863},0,3,70,0,{{2,9318}}}, -- Prayer of the Primal
	[466] = {{19925,19898},0,3,68,0,{{2,9336}}}, -- Major Mojo Infusion
	[467] = {{20057,20041,20048},4,3,64,3,{{2,7503},{3,7597}}}, -- The Highlander's Resolution
	[468] = {{20058,20042,20049},4,3,64,2,{{2,7503},{3,7597}}}, -- The Highlander's Resolve
	[469] = {{20055,20043,20050},3,3,64,4,{{2,7503},{3,7597}}}, -- The Highlander's Determination
	[470] = {{20056,20044,20051},3,3,64,4,{{2,7503},{3,18384}}}, -- The Highlander's Fortitude
	[471] = {{20059,20045,20052},2,3,64,1032,{{2,7503},{3,7597}}}, -- The Highlander's Purpose
	[472] = {{20060,20046,20053},2,3,64,1032,{{2,7503},{3,18384}}}, -- The Highlander's Will
	[473] = {{20061,20047,20054},1,3,64,400,{{2,7503},{3,18384}}}, -- The Highlander's Intent
	[474] = {{19577,19822,19824,19823,19951},4,4,63,1,{{2,13675},{3,24456},{5,24431}}}, -- Vindicator's Battlegear
	[475] = {{19588,19825,19827,19826,19952},4,4,63,2,{{2,21618},{3,24457},{5,24460}}}, -- Freethinker's Armor
	[476] = {{19609,19828,19830,19829,19956},3,4,63,64,{{2,21618},{3,24461},{5,24462}}}, -- Augur's Regalia
	[477] = {{19621,19831,19833,19832,19953},3,4,64,4,{{2,9331},{3,24465},{5,24467}}}, -- Predator's Armor
	[478] = {{19617,19835,19834,19836,19954},2,4,63,8,{{2,9331},{3,24469},{5,24471}}}, -- Madcap's Outfit
	[479] = {{19613,19838,19840,19839,19955},2,4,63,1024,{{2,21618},{3,24479},{5,24480}}}, -- Haruspex's Garb
	[480] = {{19594,19841,19843,19842,19958},1,4,64,16,{{2,9408},{3,24482},{5,24483}}}, -- Confessor's Raiment
	[481] = {{19605,19849,20033,19848,19957},1,4,63,256,{{2,9417},{3,24486},{5,24487}}}, -- Demoniac's Threads
	[482] = {{19601,19845,20034,19846,19959},1,4,63,128,{{2,9417},{3,24489},{5,24491}}}, -- Illusionist's Attire
	[483] = {{20158,20150,20154},3,3,64,68,{{2,7503},{3,7597}}}, -- The Defiler's Determination
	[484] = {{20203,20195,20199},3,3,64,68,{{2,7503},{3,7597}}}, -- The Defiler's Fortitude
	[485] = {{20176,20163,20159},1,3,64,400,{{2,7503},{3,18384}}}, -- The Defiler's Intent
	[486] = {{20194,20190,20186},2,3,64,1032,{{2,7503},{3,7597}}}, -- The Defiler's Purpose
	[487] = {{20212,20204,20208},4,3,64,1,{{2,7503},{3,7597}}}, -- The Defiler's Resolution
	[488] = {{20175,20171,20167},2,3,64,1032,{{2,7503},{3,18384}}}, -- The Defiler's Will
	[489] = {{15051,15050,15052,16984},3,3,60,0,{{2,15464},{3,7598},{4,14590}}}, -- Black Dragon Mail
	[490] = {{15045,20296,15046},3,3,54,0,{{2,21625},{3,21894}}}, -- Green Dragon Mail
	[491] = {{15049,15048,20295},3,3,59,0,{{2,18675},{3,14127}}}, -- Blue Dragon Mail
	[492] = {{20408,20406,20407},1,2,60,32767,{{3,24746}}}, -- Twilight Trappings
	[493] = {{21353,21354,21357,21356,21355},2,4,81,1024,{{3,15693},{3,18196},{5,26106}}}, -- Genesis Raiment
	[494] = {{21409,21408,21407},0,4,67,1024,{{3,26107}}}, -- Symbols of Unending Life
	[495] = {{21394,21393,21392},0,4,67,1,{{3,26111}}}, -- Battlegear of Unyielding Strength
	[496] = {{21329,21330,21331,21332,21333},4,4,81,1,{{3,26109},{5,26110}}}, -- Conqueror's Battlegear
	[497] = {{21360,21361,21364,21362,21359},2,4,81,8,{{3,26112},{5,26113}}}, -- Deathdealer's Embrace
	[498] = {{21406,21405,21404},0,4,67,8,{{3,26114}}}, -- Emblems of Veiled Shadows
	[499] = {{21337,21335,21334,21336,21338},1,4,81,256,{{3,26116},{5,26117}}}, -- Doomcaller's Attire
	[500] = {{21418,21417,21416},0,4,67,256,{{3,26118}}}, -- Implements of Unspoken Names
	[501] = {{21372,21376,21374,21375,21373},3,4,81,64,{{3,26119},{5,26122}}}, -- Stormcaller's Garb
	[502] = {{21400,21399,21398},0,4,67,64,{{3,26123}}}, -- Gift of the Gathering Storm
	[503] = {{21347,21345,21343,21346,21344},1,4,81,128,{{3,26127},{5,26128}}}, -- Enigma Vestments
	[504] = {{21415,21414,21413},0,4,67,128,{{3,26131}}}, -- Trappings of Vaulted Secrets
	[505] = {{21387,21391,21389,21390,21388},4,4,81,2,{{3,26130},{5,23929}}}, -- Avenger's Battlegear
	[506] = {{21397,21396,21395},0,4,67,2,{{3,26135}}}, -- Battlegear of Eternal Justice
	[507] = {{21348,21350,21351,21352,21349},1,4,81,16,{{3,26169},{5,26171}}}, -- Garments of the Oracle
	[508] = {{21412,21411,21410},0,4,67,16,{{3,26172}}}, -- Finery of Infinite Wisdom
	[509] = {{21366,21367,21370,21368,21365},3,4,82,4,{{3,26173},{5,26174}}}, -- Striker's Garb
	[510] = {{21403,21402,21401},0,4,67,4,{{3,26176}}}, -- Trappings of the Unseen Path
	[511] = {{21999,22001,21997,21996,21998,21994,22000,21995},4,3,62,0,{{2,18679},{4,27419},{6,14049},{8,14803}}}, -- Battlegear of Heroism
	[512] = {{22005,22008,22009,22004,22006,22002,22007,22003},2,3,62,0,{{2,18679},{4,27787},{6,14049},{8,14803}}}, -- Darkmantle Armor
	[513] = {{22109,22112,22113,22108,22110,22106,22111,22107},2,3,62,0,{{2,18679},{4,27781},{6,9344},{6,9334},{8,14803}}}, -- Feralheart Raiment
	[514] = {{22080,22082,22083,22079,22081,22078,22085,22084},1,3,62,0,{{2,18679},{4,27778},{6,14047},{8,14803}}}, -- Vestments of the Virtuous
	[515] = {{22013,22016,22060,22011,22015,22010,22017,22061},3,3,62,0,{{2,18679},{4,27785},{6,14049},{8,14803}}}, -- Beastmaster Armor
	[516] = {{22091,22093,22089,22088,22090,22086,22092,22087},4,3,62,0,{{2,18679},{4,27498},{6,14049},{8,14803}}}, -- Soulforge Armor
	[517] = {{22065,22068,22069,22063,22066,22062,22067,22064},1,3,62,0,{{2,18679},{4,27867},{6,14047},{8,14803}}}, -- Sorcerer's Regalia
	[518] = {{22074,22073,22075,22071,22077,22070,22072,22076},1,3,62,0,{{2,18679},{4,27780},{6,14047},{8,14803}}}, -- Deathmist Raiment
	[519] = {{22097,22101,22102,22095,22099,22098,22100,22096},3,3,62,0,{{2,18679},{4,27774},{6,14047},{8,14803}}}, -- The Five Thunders
	[520] = {{22302,22305,22301,22313,22304,22306,22303,22311},1,3,62,400,{{4,27733},{8,14803}}}, -- Ironweave Battlesuit
	[521] = {{22490,22491,22488,22495,22493,22494,22489,22492,23064},2,4,88,1024,{{2,28716},{4,28743},{6,28744},{8,28719}}}, -- Dreamwalker Raiment
	[522] = {{23257,23258,22879,22864,22880,22856},2,3,68,8,{{2,14049},{4,23048},{6,14467}}}, -- Champion's Guard
	[523] = {{22418,22419,22416,22423,22421,22422,22417,22420,23059},4,4,88,1,{{2,28844},{4,28843},{6,28842},{8,28845}}}, -- Dreadnaught's Battlegear
	[524] = {{22478,22479,22476,22483,22481,22482,22477,22480,23060},2,4,88,8,{{2,28816},{4,28812},{6,28811},{8,28814}}}, -- Bonescythe Armor
	[525] = {{22514,22515,22512,22519,22517,22518,22513,22516,23061},1,4,88,16,{{2,28807},{4,28809},{6,28808},{8,28802}}}, -- Vestments of Faith
	[526] = {{22498,22499,22496,22503,22501,22502,22497,22500,23062},1,4,88,128,{{2,28763},{4,28764},{6,28771},{8,28761}}}, -- Frostfire Regalia
	[527] = {{22466,22467,22464,22471,22469,22470,22465,22468,23065},3,4,88,64,{{2,28818},{4,29171},{6,28823},{8,28821}}}, -- The Earthshatterer
	[528] = {{22428,22429,22425,22424,22426,22431,22427,22430,23066},4,4,88,2,{{2,28775},{4,28774},{6,28789},{8,28787}}}, -- Redemption Armor
	[529] = {{22506,22507,22504,22511,22509,22510,22505,22508,23063},1,4,88,256,{{2,28831},{4,28829},{6,28746},{8,28830}}}, -- Plagueheart Raiment
	[530] = {{22438,22439,22436,22443,22441,22442,22437,22440,23067},3,4,88,4,{{2,28755},{4,28756},{6,28752},{8,28751}}}, -- Cryptstalker Armor
	[533] = {{23087,23090,23078},4,3,63,1535,{{3,29068}}}, -- Battlegear of Undead Slaying
	[534] = {{23089,23093,23081},2,3,63,1535,{{3,29068}}}, -- Undead Slayer's Armor
	[535] = {{23088,23092,23082},3,3,63,32767,{{3,29068}}}, -- Garb of the Undead Slayer
	[536] = {{23085,23091,23084},1,3,63,32767,{{3,29068}}}, -- Regalia of Undead Cleansing
	[537] = {{23244,23243,22872,22868,22873,22858},4,3,68,1,{{2,14049},{4,22738},{6,14467}}}, -- Champion's Battlearmor
	[538] = {{23259,23260,22876,22867,22887,22857},3,3,68,64,{{2,14049},{4,22804},{6,14467}}}, -- Champion's Stormcaller
	[539] = {{23253,23254,22877,22863,22878,22852},2,3,68,1024,{{2,14049},{4,23218},{6,14467}}}, -- Champion's Refuge
	[540] = {{23261,23262,22885,22869,22882,22859},1,3,68,16,{{2,14047},{4,23044},{6,14467}}}, -- Champion's Investiture
	[541] = {{23255,23256,22884,22865,22881,22855},1,3,68,256,{{2,14047},{4,23047},{6,14467}}}, -- Champion's Dreadgear
	[542] = {{23263,23264,22886,22870,22883,22860},1,3,68,128,{{2,14047},{4,23025},{6,14467}}}, -- Champion's Arcanum
	[543] = {{23251,23252,22874,22862,22875,22843},3,3,68,4,{{2,14384},{4,23158},{6,14467}}}, -- Champion's Pursuance
	[544] = {{23276,23277,23272,23274,23273,23275},4,3,68,2,{{2,14047},{4,23302},{6,14467}}}, -- Lieutenant Commander's Redoubt
	[545] = {{23314,23315,23300,23286,23301,23287},4,3,68,1,{{2,14049},{4,22738},{6,14467}}}, -- Lieutenant Commander's Battlearmor
	[546] = {{23318,23319,23305,23290,23304,23291},1,3,68,128,{{2,14047},{4,23025},{6,14467}}}, -- Lieutenant Commander's Arcanum
	[547] = {{23310,23311,23297,23282,23296,23283},1,3,68,256,{{2,14047},{4,23047},{6,14467}}}, -- Lieutenant Commander's Dreadgear
	[548] = {{23312,23313,23298,23284,23299,23285},2,3,68,8,{{2,14049},{4,23048},{6,14467}}}, -- Lieutenant Commander's Guard
	[549] = {{23316,23317,23303,23288,23302,23289},1,3,68,16,{{2,14047},{4,23044},{6,14467}}}, -- Lieutenant Commander's Investiture
	[550] = {{23306,23307,23292,23279,23293,23278},3,3,68,4,{{2,14384},{4,23158},{6,14467}}}, -- Lieutenant Commander's Pursuance
	[551] = {{23308,23309,23294,23280,23295,23281},2,3,68,1024,{{2,14049},{4,23218},{6,14467}}}, -- Lieutenant Commander's Refuge
}

if AtlasLoot:GameVersion_GE(AtlasLoot.BC_VERSION_NUM) then
    ITEM_SET_DATA_RAW.BCC = {
		[142] = {{15058,15056,21278,15057},2,3,57,32767,{{2,18979},{3,23863},{4,41845}}}, -- Stormshroud Armor
		[162] = {{6473,10413,10412,10410,10411},2,3,22,0,{{2,41740},{3,41739},{4,41644},{5,41741}}}, -- Embrace of the Viper
		[469] = {{20055,20043,20050},3,3,64,68,{{2,41865},{3,39418}}}, -- The Highlander's Determination
		[470] = {{20056,20044,20051},3,3,64,68,{{2,41638},{3,39447}}}, -- The Highlander's Fortitude
		[487] = {{20212,20204,20208},4,3,64,3,{{2,41853},{3,39486}}}, -- The Defiler's Resolution
		[552] = {{21848,21847,21846},1,4,105,32767,{{3,32196}}}, -- Wrath of Spellfire
		[553] = {{21869,21871,21870},1,4,105,32767,{{3,39372}}}, -- Shadow's Embrace
		[554] = {{21874,21875,21873},1,4,113,32767,{{3,32102}}}, -- Primal Mooncloth
		[555] = {{21854,21855,21849,21851,21850,21852,21853},1,2,103,0,{{2,39543},{4,41829}}}, -- Netherweave Vestments
		[556] = {{21861,21862,21859,21860},1,3,111,32767,{{3,39881}}}, -- Imbued Netherweave
		[557] = {{21864,21865,21863},1,4,100,32767,{{3,41841}}}, -- Soulcloth Embrace
		[558] = {{21868,21866,21867},1,3,114,32767,{{3,41658}}}, -- Arcanoweave Vestments
		[559] = {{24266,24262},1,4,105,0,{{2,32106}}}, -- Spellstrike Infusion
		[560] = {{23489,23482,23484,23488,23487},4,2,95,32767,{{2,42155},{4,41744}}}, -- Fel Iron Plate
		[561] = {{23493,23490,23494,23491},3,2,95,32767,{{2,41561},{4,41562}}}, -- Fel Iron Chain
		[562] = {{23507,23506,23508},4,3,104,32767,{{3,41655}}}, -- Adamantite Battlegear
		[563] = {{23509,23510,23512,23511},4,3,114,0,{{3,41742}}}, -- Enchanted Adamantite Armor
		[564] = {{23516,23513,23515,23514},4,3,114,0,{{3,41769}}}, -- Flame Guard
		[565] = {{23524,23523,23525},4,3,114,32767,{{3,41783}}}, -- Khorium Ward
		[566] = {{23521,33173,23522,23520},4,3,115,0,{{2,41678}}}, -- Burning Rage
		[567] = {{24545,24546,24544,24549,24547},4,4,123,1,{{2,32145},{4,22738}}}, -- Gladiator's Battlegear
		[568] = {{24553,24554,24552,24556,24555},1,4,123,256,{{2,40042},{4,23047}}}, -- Gladiator's Dreadgear
		[569] = {{23519,23517,23518},4,3,114,0,{{3,41743}}}, -- Faith in Felsteel
		[570] = {{24249,24255},1,3,109,32767,{{2,41876}}}, -- The Unyielding
		[571] = {{24264,24261},1,4,105,0,{{2,32200}}}, -- Whitemend Wisdom
		[572] = {{24267,24263},1,4,105,0,{{2,41660}}}, -- Battlecast Garb
		[573] = {{25685,25687,25686},2,3,110,0,{{3,41746}}}, -- Fel Skin
		[574] = {{25689,25690,25691},2,3,113,0,{{3,41846}}}, -- Strength of the Clefthoof
		[575] = {{25696,25697,25695},3,3,113,0,{{3,41749}}}, -- Felstalker Armor
		[576] = {{25694,25692,25693},3,3,104,0,{{3,41771}}}, -- Fury of the Nether
		[577] = {{25830,25832,25831,25834,25833},2,4,123,8,{{2,32145},{4,21975}}}, -- Gladiator's Vestments
		[578] = {{25998,25999,25997,26000,26001},3,4,123,64,{{2,32145},{4,33018}}}, -- Gladiator's Earthshaker
		[579] = {{25855,25854,25856,25857,25858},1,4,123,128,{{2,40042},{4,44302}}}, -- Gladiator's Regalia
		[580] = {{27471,27473,27469,27470,27472},3,4,123,64,{{2,40042},{4,44296}}}, -- Gladiator's Thunderfist
		[581] = {{27708,27710,27711,27707,27709},1,4,123,16,{{2,40042},{4,33333}}}, -- Gladiator's Raiment
		[582] = {{27704,27706,27702,27703,27705},4,4,123,2,{{2,40044},{4,23302}}}, -- Gladiator's Aegis
		[583] = {{27881,27883,27879,27880,27882},4,4,123,2,{{2,32145},{4,23302}}}, -- Gladiator's Vindication
		[584] = {{28127,28129,28130,28126,28128},2,4,123,1024,{{2,32145},{4,23218}}}, -- Gladiator's Sanctuary
		[585] = {{28137,28139,28140,28136,28138},2,4,123,1024,{{2,40042},{4,46832}}}, -- Gladiator's Wildhide
		[586] = {{28331,28333,28334,28335,28332},3,4,123,4,{{2,32145},{4,44292}}}, -- Gladiator's Pursuit
		[587] = {{28833,28835,28831,28832,28834},4,3,115,2,{{2,40052},{4,23302}}}, -- High Warlord's Aegis
		[588] = {{28853,28855,28851,28852,28854},4,3,115,1,{{2,40050},{4,22738}}}, -- High Warlord's Battlegear
		[589] = {{28681,28683,28679,28680,28724},4,3,115,2,{{2,40048},{4,23302}}}, -- Grand Marshal's Aegis
		[590] = {{28701,28703,28699,28700,28702},4,3,115,1,{{2,40046},{4,22738}}}, -- Grand Marshal's Battlegear
		[591] = {{28625,28627,28628,28624,28626},1,3,115,256,{{2,40047},{4,23047}}}, -- Grand Marshal's Dreadgear
		[592] = {{28818,28820,28821,28817,28819},1,3,115,256,{{2,40051},{4,23047}}}, -- High Warlord's Dreadgear
		[593] = {{28691,28693,28689,28690,28692},3,3,115,64,{{2,40046},{4,33018}}}, -- Grand Marshal's Earthshaker
		[594] = {{28843,28845,28841,28842,28844},3,3,115,64,{{2,40050},{4,33018}}}, -- High Warlord's Earthshaker
		[595] = {{28615,28617,28613,28614,28616},3,3,115,4,{{2,40046},{4,23158}}}, -- Grand Marshal's Pursuit
		[596] = {{28807,28809,28805,28806,28808},3,3,115,4,{{2,40050},{4,23158}}}, -- High Warlord's Pursuit
		[597] = {{28705,28707,28708,28704,28706},1,3,115,16,{{2,40047},{4,33333}}}, -- Grand Marshal's Raiment
		[598] = {{28857,28859,28860,28856,28858},1,3,115,16,{{2,40051},{4,33333}}}, -- High Warlord's Raiment
		[599] = {{28715,28714,28717,28716,28718},1,3,115,128,{{2,40047},{4,23025}}}, -- Grand Marshal's Regalia
		[600] = {{28867,28866,28869,28868,28870},1,3,115,128,{{2,40051},{4,23025}}}, -- High Warlord's Regalia
		[601] = {{28619,28622,28623,28618,28620},2,3,115,1024,{{2,40046},{4,23218}}}, -- Grand Marshal's Sanctuary
		[602] = {{28812,28814,28815,28811,28813},2,3,115,1024,{{2,40050},{4,23218}}}, -- High Warlord's Sanctuary
		[603] = {{28696,28698,28694,28695,28697},3,3,115,64,{{2,40047},{4,22804}}}, -- Grand Marshal's Thunderfist
		[604] = {{28848,28850,28846,28847,28849},3,3,115,64,{{2,40051},{4,22804}}}, -- High Warlord's Thunderfist
		[605] = {{28685,28687,28688,28684,28686},2,3,115,8,{{2,40046},{4,23048}}}, -- Grand Marshal's Vestments
		[606] = {{28837,28839,28840,28836,28838},2,3,115,8,{{2,40050},{4,23048}}}, -- High Warlord's Vestments
		[607] = {{28711,28713,28709,28710,28712},4,3,115,2,{{2,40046},{4,23302}}}, -- Grand Marshal's Vindication
		[608] = {{28863,28865,28861,28862,28864},4,3,115,2,{{2,40050},{4,23302}}}, -- High Warlord's Vindication
		[609] = {{28720,28722,28723,28719,28721},2,3,115,1024,{{2,40047},{4,33877}}}, -- Grand Marshal's Wildhide
		[610] = {{28872,28874,28875,28871,28873},2,3,115,1024,{{2,40051},{4,33877}}}, -- High Warlord's Wildhide
		[611] = {{25657,25654,25656,25655},3,2,96,0,{{2,41748},{4,41747}}}, -- Felscale Armor
		[612] = {{25660,25661,25662,25659},3,2,97,0,{{2,41833},{4,41834}}}, -- Scaled Draenic Armor
		[613] = {{25671,25669,25670,25668},2,2,96,0,{{2,41878},{4,41877}}}, -- Thick Draenic Armor
		[614] = {{25676,25674,25675,25673},2,2,95,0,{{2,41890},{4,41889}}}, -- Wild Draenish Armor
		[615] = {{30187,30186,30200,30188,30201},1,4,123,256,{{2,40053},{4,23047}}}, -- Gladiator's Felshroud
		[616] = {{29515,29517,29516},3,4,113,0,{{3,39982}}}, -- Netherscale Armor
		[617] = {{29519,29521,29520},3,4,117,0,{{3,41828}}}, -- Netherstrike Armor
		[618] = {{29522,29523,29524},2,4,117,0,{{3,41591}}}, -- Windhawk Armor
		[619] = {{29525,29527,29526},2,4,117,0,{{3,41832}}}, -- Primal Intent
		[620] = {{28414,27776,28204,27509,27908},2,3,115,32767,{{2,37165},{4,37166}}}, -- Assassination Armor
		[621] = {{29044,29047,29045,29048,29046},2,4,120,8,{{2,37167},{4,37168}}}, -- Netherblade
		[622] = {{30146,30149,30144,30145,30148},2,4,133,8,{{2,37169},{4,37170}}}, -- Deathmantle
		[623] = {{28285,27739,28203,27535,27839},4,3,115,0,{{2,37180},{4,37181}}}, -- Righteous Armor
		[624] = {{29061,29064,29062,29065,29063},4,4,120,2,{{2,37182},{4,37183}}}, -- Justicar Raiment
		[625] = {{29068,29070,29066,29067,29069},4,4,120,2,{{2,37184},{4,37185}}}, -- Justicar Armor
		[626] = {{29073,29075,29071,29072,29074},4,4,120,2,{{2,37186},{4,37187}}}, -- Justicar Battlegear
		[627] = {{30136,30138,30134,30135,30137},4,4,133,2,{{2,37188},{4,37189}}}, -- Crystalforge Raiment
		[628] = {{30125,30127,30123,30124,30126},4,4,133,2,{{2,37190},{4,37191}}}, -- Crystalforge Armor
		[629] = {{30131,30133,30129,30130,30132},4,4,133,2,{{2,37194},{4,37195}}}, -- Crystalforge Battlegear
		[630] = {{28349,27802,28231,27510,27909},3,3,115,0,{{2,37207},{4,37209}}}, -- Tidefury Raiment
		[631] = {{29028,29031,29029,29032,29030},3,4,120,64,{{2,37210},{4,37211}}}, -- Cyclone Raiment
		[632] = {{29035,29037,29033,29034,29036},3,4,120,64,{{2,37212},{4,37213}}}, -- Cyclone Regalia
		[633] = {{29040,29043,29038,29039,29042},3,4,120,64,{{2,37223},{4,37224}}}, -- Cyclone Harness
		[634] = {{30166,30168,30164,30165,30167},3,4,133,64,{{2,37225},{4,37227}}}, -- Cataclysm Raiment
		[635] = {{30171,30173,30169,30170,30172},3,4,133,64,{{2,37228},{4,37237}}}, -- Cataclysm Regalia
		[636] = {{30190,30194,30185,30189,30192},3,4,133,64,{{2,37239},{4,37241}}}, -- Cataclysm Harness
		[637] = {{28348,27737,28202,27468,27873},2,3,115,0,{{2,37286},{4,37287}}}, -- Moonglade Raiment
		[638] = {{29086,29089,29087,29090,29088},2,4,120,1024,{{2,37288},{4,37292}}}, -- Malorne Raiment
		[639] = {{29093,29095,29091,29092,29094},2,4,120,1024,{{2,37295},{4,37297}}}, -- Malorne Regalia
		[640] = {{29098,29100,29096,29097,29099},2,4,120,1024,{{2,37311},{2,37306},{4,37299},{4,37298}}}, -- Malorne Harness
		[641] = {{30228,30230,30222,30223,30229},2,4,133,1024,{{2,37315},{4,37333}}}, -- Nordrassil Harness
		[642] = {{30219,30221,30216,30217,30220},2,4,133,1024,{{2,37313},{4,37314}}}, -- Nordrassil Raiment
		[643] = {{30233,30235,30231,30232,30234},2,4,133,1024,{{2,37324},{4,37327}}}, -- Nordrassil Regalia
		[644] = {{28415,27778,28232,27537,27948},1,3,115,32767,{{2,37375},{4,37376}}}, -- Oblivion Raiment
		[645] = {{28963,28967,28964,28968,28966},1,4,120,256,{{2,39437},{2,37377},{4,37380}}}, -- Voidheart Raiment
		[646] = {{30212,30215,30214,30211,30213},1,4,133,256,{{2,37381},{4,37384}}}, -- Corruptor Raiment
		[647] = {{28278,27738,28229,27508,27838},1,3,115,32767,{{2,37423},{4,37424}}}, -- Incanter's Regalia
		[648] = {{29076,29079,29077,29080,29078},1,4,120,128,{{2,37438},{4,37439}}}, -- Aldor Regalia
		[649] = {{30206,30210,30196,30205,30207},1,4,133,128,{{2,37441},{4,37443}}}, -- Tirisfal Regalia
		[650] = {{28275,27801,28228,27474,27874},3,3,115,0,{{2,37481},{4,37483}}}, -- Beast Lord Armor
		[651] = {{29081,29084,29082,29085,29083},3,4,120,4,{{2,37484},{4,37485}}}, -- Demon Stalker Armor
		[652] = {{30141,30143,30139,30140,30142},3,4,133,4,{{2,37381},{4,37505}}}, -- Rift Stalker Armor
		[653] = {{28350,27803,28205,27475,27977},4,3,115,32767,{{2,37512},{4,37513}}}, -- Bold Armor
		[654] = {{29011,29016,29012,29017,29015},4,4,120,1,{{2,37514},{4,37516}}}, -- Warbringer Armor
		[655] = {{29021,29023,29019,29020,29022},4,4,120,1,{{2,37518},{4,37519}}}, -- Warbringer Battlegear
		[656] = {{30115,30117,30113,30114,30116},4,4,133,1,{{2,37522},{4,37525}}}, -- Destroyer Armor
		[657] = {{30120,30122,30118,30119,30121},4,4,133,1,{{2,37528},{4,37535}}}, -- Destroyer Battlegear
		[658] = {{28193,27796,28191,27465,27907},1,3,115,32767,{{2,37607},{4,37619}}}, -- Mana-Etched Regalia
		[659] = {{28224,27797,28264,27531,27837},2,3,115,32767,{{2,37608},{4,37618}}}, -- Wastewalker Armor
		[660] = {{28192,27713,28401,27528,27936},3,3,115,0,{{2,37609},{4,37617}}}, -- Desolation Battlegear
		[661] = {{28225,27771,28403,27497,27870},4,3,115,32767,{{2,37610},{4,37611}}}, -- Doomplate Battlegear
		[662] = {{28413,27775,28230,27536,27875},1,3,115,32767,{{2,37556},{4,37558}}}, -- Hallowed Raiment
		[663] = {{29049,29054,29050,29055,29053},1,4,120,16,{{2,37564},{4,37568}}}, -- Incarnate Raiment
		[664] = {{29058,29060,29056,29057,29059},1,4,120,16,{{2,37570},{4,37571}}}, -- Incarnate Regalia
		[665] = {{30152,30154,30150,30151,30153},1,4,133,16,{{2,37594},{4,26171}}}, -- Avatar Raiment
		[666] = {{30161,30163,30159,30160,30162},1,4,133,16,{{2,37600},{4,37603}}}, -- Avatar Regalia
		[667] = {{31338,31339},0,4,100,0,{{2,41875}}}, -- The Twin Stars
		[668] = {{31027,31030,31028,34448,31026,34558,31029,34575},2,4,149,8,{{2,38388},{4,38389}}}, -- Slayer's Armor
		[669] = {{31003,31006,31004,34443,31001,34549,31005,34570},3,4,149,4,{{2,38390},{4,38392}}}, -- Gronnstalker's Armor
		[670] = {{31051,31054,31052,34436,31050,34541,31053,34564},1,4,149,256,{{2,38394},{4,38393}}}, -- Malefic Raiment
		[671] = {{31056,31059,31057,34447,31055,34557,31058,34574},1,4,149,128,{{2,38396},{4,38397}}}, -- Tempest Regalia
		[672] = {{30972,30979,30975,34441,30969,34546,30977,34569},4,4,149,1,{{2,38398},{4,38399}}}, -- Onslaught Battlegear
		[673] = {{30974,30980,30976,34442,30970,34547,30978,34568},4,4,149,1,{{2,38408},{4,38407}}}, -- Onslaught Armor
		[674] = {{31064,31070,31065,34434,31061,34528,31067,34563},1,4,149,16,{{2,38413},{4,38412}}}, -- Absolution Regalia
		[675] = {{31063,31069,31066,34435,31060,34527,31068,34562},1,4,149,16,{{2,38410},{4,38411}}}, -- Vestments of Absolution
		[676] = {{31039,31048,31042,34444,31034,34556,31044,34573},2,4,149,1024,{{2,38447},{4,38416}}}, -- Thunderheart Harness
		[677] = {{31040,31049,31043,34446,31035,34555,31046,34572},2,4,149,1024,{{2,38414},{4,38415}}}, -- Thunderheart Regalia
		[678] = {{31037,31047,31041,34445,31032,34554,31045,34571},2,4,149,1024,{{2,38417},{4,38420}}}, -- Thunderheart Raiment
		[679] = {{30987,30998,30991,34433,30985,34488,30995,34560},4,4,149,2,{{2,38421},{4,38422}}}, -- Lightbringer Armor
		[680] = {{30989,30997,30990,34431,30982,34485,30993,34561},4,4,149,2,{{2,38427},{4,38424}}}, -- Lightbringer Battlegear
		[681] = {{30988,30996,30992,34432,30983,34487,30994,34559},4,4,149,2,{{2,38426},{4,38425}}}, -- Lightbringer Raiment
		[682] = {{31015,31024,31018,34439,31011,34545,31021,34567},3,4,149,64,{{2,38429},{4,38432}}}, -- Skyshatter Harness
		[683] = {{31012,31022,31016,34438,31007,34543,31019,34565},3,4,149,64,{{2,38434},{4,38435}}}, -- Skyshatter Raiment
		[684] = {{31014,31023,31017,34437,31008,34542,31020,34566},3,4,149,64,{{2,38443},{4,38436}}}, -- Skyshatter Regalia
		[685] = {{31376,31378,31379,31375,31377},2,4,123,1024,{{2,40043},{4,46834}}}, -- Gladiator's Refuge
		[686] = {{31400,31407,31396,31397,31406},3,4,123,64,{{2,40043},{4,44299}}}, -- Gladiator's Wartide
		[687] = {{31410,31412,31413,31409,31411},1,4,123,16,{{2,40043},{4,33333}}}, -- Gladiator's Investiture
		[688] = {{31590,31592,31593,31589,31591},2,3,115,1024,{{2,40045},{4,46834}}}, -- Grand Marshal's Refuge
		[689] = {{31585,31587,31588,31584,31586},2,3,115,1024,{{2,40049},{4,46834}}}, -- High Warlord's Refuge
		[690] = {{31616,31619,31613,31614,31618},4,4,123,2,{{2,40043},{4,46851}}}, -- Gladiator's Redemption
		[691] = {{31622,31624,31625,31620,31623},1,3,115,16,{{2,40045},{4,33333}}}, -- Grand Marshal's Investiture
		[692] = {{31626,31628,31629,31621,31627},1,3,115,16,{{2,40049},{4,33333}}}, -- High Warlord's Investiture
		[693] = {{31632,31634,31630,31631,31633},4,3,115,2,{{2,40045},{4,46851}}}, -- Grand Marshal's Redemption
		[694] = {{31637,31639,31635,31636,31638},4,3,115,2,{{2,40049},{4,46851}}}, -- High Warlord's Redemption
		[695] = {{31642,31644,31640,31641,31643},3,3,115,64,{{2,40045},{4,38499}}}, -- Grand Marshal's Wartide
		[696] = {{31648,31650,31646,31647,31649},3,3,115,64,{{2,40049},{4,38499}}}, -- High Warlord's Wartide
		[697] = {{29604,29605,29602,29600,29603,29601},4,3,68,2,{{2,41705},{3,23302},{6,41704}}}, -- Champion's Redoubt
		[698] = {{29616,29617,29615,29613,29614,29612},4,4,73,2,{{2,41886},{3,23302},{6,30778}}}, -- Warlord's Aegis
		[699] = {{32837,32838},0,5,156,9,{{2,41433},{2,41434}}}, -- The Twin Blades of Azzinoth
		[700] = {{31997,31996,31992,31993,31995},4,4,136,2,{{2,41462},{4,23302}}}, -- Merciless Gladiator's Aegis
		[701] = {{30488,30490,30486,30487,30489},4,4,136,1,{{2,41464},{4,22738}}}, -- Merciless Gladiator's Battlegear
		[702] = {{31974,31976,31977,31973,31975},1,4,136,256,{{2,41474},{4,23047}}}, -- Merciless Gladiator's Dreadgear
		[703] = {{32006,32008,32004,32005,32007},3,4,136,64,{{2,41464},{4,33018}}}, -- Merciless Gladiator's Earthshaker
		[704] = {{31980,31979,31982,31981,31983},1,4,136,256,{{2,41462},{4,23047}}}, -- Merciless Gladiator's Felshroud
		[705] = {{32016,32018,32019,32015,32017},1,4,136,16,{{2,41463},{4,33333}}}, -- Merciless Gladiator's Investiture
		[706] = {{31962,31964,31960,31961,31963},3,4,136,4,{{2,41464},{4,44292}}}, -- Merciless Gladiator's Pursuit
		[707] = {{32035,32037,32038,32034,32036},1,4,136,16,{{2,41462},{4,33333}}}, -- Merciless Gladiator's Raiment
		[708] = {{32022,32024,32020,32021,32023},4,4,136,2,{{2,41463},{4,46851}}}, -- Merciless Gladiator's Redemption
		[709] = {{31988,31990,31991,31987,31989},2,4,136,1024,{{2,41463},{4,23218}}}, -- Merciless Gladiator's Refuge
		[710] = {{32048,32047,32050,32049,32051},1,4,136,128,{{2,41462},{4,44302}}}, -- Merciless Gladiator's Regalia
		[711] = {{31968,31971,31972,31967,31969},2,4,136,1024,{{2,41464},{4,23218}}}, -- Merciless Gladiator's Sanctuary
		[712] = {{32011,32013,32009,32010,32012},3,4,136,64,{{2,41462},{4,44296}}}, -- Merciless Gladiator's Thunderfist
		[713] = {{31999,32001,32002,31998,32000},2,4,136,8,{{2,41464},{4,21975}}}, -- Merciless Gladiator's Vestments
		[714] = {{32041,32043,32039,32040,32042},4,4,136,2,{{2,41464},{4,23302}}}, -- Merciless Gladiator's Vindication
		[715] = {{32031,32033,32029,32030,32032},3,4,136,64,{{2,41463},{4,44299}}}, -- Merciless Gladiator's Wartide
		[716] = {{32057,32059,32060,32056,32058},2,4,136,1024,{{2,41462},{4,44293}}}, -- Merciless Gladiator's Wildhide
		[717] = {{29610,29611,29609,29607,29608,29606},3,4,73,64,{{2,41896},{3,22804},{6,41895}}}, -- Field Marshal's Earthshaker
		[718] = {{29598,29599,29596,29595,29597,29594},3,3,68,64,{{2,41713},{4,22804},{6,41712}}}, -- Lieutenant Commander's Earthshaker
		[719] = {{32946,32945},0,4,141,0,{{2,41989}}}, -- The Fists of Fury
		[720] = {{33691,33693,33694,33690,33692},2,4,146,1024,{{2,43478},{4,23218}}}, -- Vengeful Gladiator's Refuge
		[721] = {{33672,33674,33675,33671,33673},2,4,146,1024,{{2,43479},{4,23218}}}, -- Vengeful Gladiator's Sanctuary
		[722] = {{33768,33770,33771,33767,33769},2,4,146,1024,{{2,43480},{4,44293}}}, -- Vengeful Gladiator's Wildhide
		[723] = {{33666,33668,33664,33665,33667},3,4,146,4,{{2,43479},{4,44292}}}, -- Vengeful Gladiator's Pursuit
		[724] = {{33758,33757,33760,33759,33761},1,4,146,128,{{2,43480},{4,44302}}}, -- Vengeful Gladiator's Regalia
		[725] = {{33724,33726,33722,33723,33725},4,4,146,2,{{2,43478},{4,23302}}}, -- Vengeful Gladiator's Redemption
		[726] = {{33751,33753,33749,33750,33752},4,4,146,2,{{2,43479},{4,23302}}}, -- Vengeful Gladiator's Vindication
		[727] = {{33697,33699,33695,33696,33698},4,4,146,2,{{2,43480},{4,23302}}}, -- Vengeful Gladiator's Aegis
		[728] = {{33718,33720,33721,33717,33719},1,4,146,16,{{2,43478},{4,33333}}}, -- Vengeful Gladiator's Investiture
		[729] = {{33745,33747,33748,33744,33746},1,4,146,16,{{2,43480},{4,33333}}}, -- Vengeful Gladiator's Raiment
		[730] = {{33701,33703,33704,33700,33702},2,4,146,8,{{2,43479},{4,21975}}}, -- Vengeful Gladiator's Vestments
		[731] = {{33740,33742,33738,33739,33741},3,4,146,64,{{2,43478},{4,44299}}}, -- Vengeful Gladiator's Wartide
		[732] = {{33708,33710,33706,33707,33709},3,4,146,64,{{2,43479},{4,33018}}}, -- Vengeful Gladiator's Earthshaker
		[733] = {{33713,33715,33711,33712,33714},3,4,146,64,{{2,43480},{4,44296}}}, -- Vengeful Gladiator's Thunderfist
		[734] = {{33677,33679,33680,33676,33678},1,4,146,256,{{2,43481},{4,23047}}}, -- Vengeful Gladiator's Dreadgear
		[735] = {{33683,33682,33685,33684,33686},1,4,146,256,{{2,43480},{4,23047}}}, -- Vengeful Gladiator's Felshroud
		[736] = {{33730,33732,33728,33729,33731},4,4,146,1,{{2,43479},{4,22738}}}, -- Vengeful Gladiator's Battlegear
		[737] = {{28189,34703},0,3,115,0,{{2,9336}}}, -- Latro's Flurry
		[738] = {{35329,35331,35332,35328,35330},1,3,115,256,{{2,46412},{4,23047}}}, -- Dreadweave Battlegear
		[739] = {{35333,35336,35337,35335,35334},1,3,115,16,{{2,46413},{4,33333}}}, -- Mooncloth Battlegear
		[740] = {{35339,35341,35342,35338,35340},1,3,115,16,{{2,46414},{4,33333}}}, -- Satin Battlegear
		[741] = {{35344,35343,35346,35345,35347},1,3,115,128,{{2,46415},{4,23025}}}, -- Evoker's Silk Battlegear
		[742] = {{35357,35359,35360,35356,35358},2,3,115,1024,{{2,46435},{4,23218}}}, -- Dragonhide Battlegear
		[743] = {{35372,35374,35375,35371,35373},2,3,115,1024,{{2,46436},{4,46832}}}, -- Wyrmhide Battlegear
		[744] = {{35362,35364,35365,35361,35363},2,3,115,1024,{{2,46437},{4,46834}}}, -- Kodohide Battlegear
		[745] = {{35367,35369,35370,35366,35368},2,3,115,8,{{2,46438},{4,23048}}}, -- Opportunist's Battlegear
		[746] = {{35388,35390,35386,35387,35389},3,3,115,64,{{2,46454},{4,22804}}}, -- Seer's Mail Battlegear
		[747] = {{35393,35395,35391,35392,35394},3,3,115,64,{{2,46455},{4,38466}}}, -- Seer's Ringmail Battlegear
		[748] = {{35383,35385,35381,35382,35384},3,3,115,64,{{2,46456},{4,33018}}}, -- Seer's Linked Battlegear
		[749] = {{35378,35380,35376,35377,35379},3,3,115,4,{{2,46456},{4,23158}}}, -- Stalker's Chain Battlegear
		[750] = {{35409,35411,35407,35408,35410},4,3,115,1,{{2,46528},{4,22738}}}, -- Savage Plate Battlegear
		[751] = {{35404,35406,35402,35403,35405},4,3,115,2,{{2,46530},{4,23302}}}, -- Crusader's Ornamented Battlegear
		[752] = {{35414,35416,35412,35413,35415},4,3,115,2,{{2,46534},{4,23302}}}, -- Crusader's Scaled Battlegear
		[2000567] = {{35068,35070,35066,35067,35069},4,4,159,1,{{2,32145},{4,22738}},AL["Brutal %s"],567}, -- Brutal Gladiator's Battlegear
		[2000568] = {{35004,35006,35007,35003,35005},1,4,159,256,{{2,40042},{4,23047}},AL["Brutal %s"],568}, -- Brutal Gladiator's Dreadgear
		[2000577] = {{35033,35035,35036,35032,35034},2,4,159,8,{{2,32145},{4,21975}},AL["Brutal %s"],577}, -- Brutal Gladiator's Vestments
		[2000578] = {{35044,35046,35042,35043,35045},3,4,159,64,{{2,32145},{4,33018}},AL["Brutal %s"],578}, -- Brutal Gladiator's Earthshaker
		[2000579] = {{35097,35096,35099,35098,35100},1,4,159,128,{{2,40042},{4,44302}},AL["Brutal %s"],579}, -- Brutal Gladiator's Regalia
		[2000580] = {{35050,35052,35048,35049,35051},3,4,159,64,{{2,40042},{4,44296}},AL["Brutal %s"],580}, -- Brutal Gladiator's Thunderfist
		[2000581] = {{35084,35086,35087,35083,35085},1,4,159,16,{{2,40042},{4,33333}},AL["Brutal %s"],581}, -- Brutal Gladiator's Raiment
		[2000582] = {{35029,35031,35027,35028,35030},4,4,159,2,{{2,40044},{4,23302}},AL["Brutal %s"],582}, -- Brutal Gladiator's Aegis
		[2000583] = {{35090,35092,35088,35089,35091},4,4,159,2,{{2,32145},{4,23302}},AL["Brutal %s"],583}, -- Brutal Gladiator's Vindication
		[2000584] = {{34999,35001,35002,34998,35000},2,4,159,1024,{{2,32145},{4,23218}},AL["Brutal %s"],584}, -- Brutal Gladiator's Sanctuary
		[2000585] = {{35112,35114,35115,35111,35113},2,4,159,1024,{{2,40042},{4,46832}},AL["Brutal %s"],585}, -- Brutal Gladiator's Wildhide
		[2000586] = {{34992,34994,34990,34991,34993},3,4,159,4,{{2,32145},{4,44292}},AL["Brutal %s"],586}, -- Brutal Gladiator's Pursuit
		[2000615] = {{35010,35009,35012,35011,35013},1,4,159,256,{{2,40053},{4,23047}},AL["Brutal %s"],615}, -- Brutal Gladiator's Felshroud
		[2000685] = {{35023,35025,35026,35022,35024},2,4,159,1024,{{2,40043},{4,46834}},AL["Brutal %s"],685}, -- Brutal Gladiator's Refuge
		[2000686] = {{35079,35081,35077,35078,35080},3,4,159,64,{{2,40043},{4,44299}},AL["Brutal %s"],686}, -- Brutal Gladiator's Wartide
		[2000687] = {{35054,35056,35057,35053,35055},1,4,159,16,{{2,40043},{4,33333}},AL["Brutal %s"],687}, -- Brutal Gladiator's Investiture
		[2000690] = {{35061,35063,35059,35060,35062},4,4,159,2,{{2,40043},{4,46851}},AL["Brutal %s"],690}, -- Brutal Gladiator's Redemption
    }
end

if AtlasLoot:GameVersion_GE(AtlasLoot.WRATH_VERSION_NUM) then
    ITEM_SET_DATA_RAW.WRATH = {
		[261] = {{18203,18202},0,4,66,0,{{2,22648}}}, -- Spirit of Eskhandar
		[462] = {{19905,19893},0,3,70,0,{{2,41894},{2,39702}}}, -- Zanzil's Concentration
		[490] = {{15045,20296,15046},3,3,53,0,{{2,41775},{3,21894}}}, -- Green Dragon Mail
		[511] = {{21999,22001,21997,21996,21998,21994,22000,21995},4,3,63,0,{{2,41662},{4,27419},{6,41649},{8,41661}}}, -- Battlegear of Heroism
		[512] = {{22005,22008,22009,22004,22006,22002,22007,22003},2,3,63,0,{{2,41721},{4,27787},{6,41722},{8,41720}}}, -- Darkmantle Armor
		[513] = {{22109,22112,22113,22108,22110,22106,22111,22107},2,3,63,0,{{2,41751},{4,27781},{6,41752},{6,41646},{8,41750}}}, -- Feralheart Raiment
		[514] = {{22080,22082,22083,22079,22081,22078,22085,22084},1,3,63,0,{{2,41883},{4,27778},{6,41884},{8,41882}}}, -- Vestments of the Virtuous
		[515] = {{22013,22016,22060,22011,22015,22010,22017,22061},3,3,63,0,{{2,41666},{4,27785},{6,41667},{8,41665}}}, -- Beastmaster Armor
		[516] = {{22091,22093,22089,22088,22090,22086,22092,22087},4,3,63,0,{{2,41843},{4,27498},{6,41844},{8,41842}}}, -- Soulforge Armor
		[517] = {{22065,22068,22069,22063,22066,22062,22067,22064},1,3,63,0,{{2,41839},{4,27867},{6,32451},{8,41840}}}, -- Sorcerer's Regalia
		[518] = {{22074,22073,22075,22071,22077,22070,22072,22076},1,3,63,0,{{2,41728},{4,27780},{6,41729},{8,41727}}}, -- Deathmist Raiment
		[519] = {{22097,22101,22102,22095,22099,22098,22100,22096},3,3,63,0,{{2,41859},{4,27774},{6,41860},{8,41858}}}, -- The Five Thunders
		[754] = {{38437,38402,38400,38433,38403,38405,38401,38404},2,2,146,32767,{{2,51273},{4,51274}}}, -- Borean Embrace
		[755] = {{38439,38417,38420,38435,38421,38418,38422,38419},3,2,142,32767,{{2,51262},{4,51263}}}, -- Nerubian Hive
		[756] = {{38440,38424,38414,38436,38415,38412,38416,38413},3,2,144,32767,{{2,51223},{4,51225}}}, -- Frostscale Binding
		[757] = {{38438,38411,38408,38434,38409,38406,38410,38407},2,2,144,32767,{{3,61633}}}, -- Iceborne Embrace
		[759] = {{37758,37821},0,3,154,0,{{2,9417}}}, -- Raine's Revenge
		[760] = {{40442,40444,40440,40441,40443},4,4,159,32,{{2,40044},{4,14507}}}, -- Gladiator's Dreadplate
		[761] = {{21524,21525,34085,34087,34086},1,1,1,32767,{{3,55000}}}, -- Winter Garb
		[762] = {{33968,33864,33967,33969,33863,33862,33966,33868},0,1,1,32767,{{3,55005}}}, -- Brewfest Garb
		[763] = {{41521,41513,41515,41512,44211,41522,41519,41520},1,2,138,0,{{2,55565},{4,55564}}}, -- Frostwoven Power
		[764] = {{41546,41550,41549,41551,41545,41543,41548,41544},1,2,158,0,{{2,55595},{4,55596}}}, -- Duskweaver
		[765] = {{42627,42629,42625,42626,42628},4,4,123,1,{{2,56449},{2,71850},{4,71858},{4,22738}}}, -- Gladiator's Battlegear
		[766] = {{42632,42634,42630,42631,42633},4,4,123,2,{{2,56449},{2,71850},{4,71858},{4,61776}}}, -- Gladiator's Vindication
		[767] = {{42637,42639,42635,42636,42638},4,4,123,2,{{2,56450},{2,71851},{4,71853},{4,58000}}}, -- Gladiator's Redemption
		[768] = {{42656,42658,42654,42655,42657},4,4,123,1,{{2,56449},{2,71850},{4,71858},{4,61257}}}, -- Gladiator's Desecration
		[769] = {{42661,42663,42659,42660,42662},3,4,123,64,{{2,56509},{2,71852},{4,71860},{4,44299}}}, -- Gladiator's Thunderfist
		[770] = {{42671,42673,42669,42670,42672},3,4,123,64,{{2,56449},{2,71850},{4,71858},{4,33018}}}, -- Gladiator's Earthshaker
		[771] = {{42666,42668,42664,42665,42667},3,4,123,64,{{2,71851},{2,56450},{4,44299},{4,71853}}}, -- Gladiator's Wartide
		[772] = {{42676,42678,42674,42675,42677},3,4,123,4,{{2,56449},{2,71850},{4,71858},{4,61256}}}, -- Gladiator's Pursuit
		[773] = {{42681,42683,42684,42680,42682},2,4,123,1024,{{2,56450},{2,71851},{4,71853},{4,38417}}}, -- Gladiator's Refuge
		[774] = {{42686,42688,42689,42685,42687},2,4,123,1024,{{2,56509},{2,71852},{4,71860},{4,46832}}}, -- Gladiator's Wildhide
		[775] = {{42691,42693,42694,42690,42692},2,4,123,1024,{{2,56449},{2,71850},{4,71858},{4,23218}}}, -- Gladiator's Sanctuary
		[776] = {{42696,42698,42699,42695,42697},2,4,123,8,{{2,56449},{2,71850},{4,71858},{4,21975}}}, -- Gladiator's Vestments
		[777] = {{42704,42706,42707,42703,42705},1,4,123,16,{{2,56450},{2,71851},{4,71853},{4,33333}}}, -- Gladiator's Investiture
		[778] = {{42709,42711,42712,42708,42710},1,4,123,16,{{2,56509},{2,71852},{4,71860},{4,33333}}}, -- Gladiator's Raiment
		[779] = {{42714,42713,42716,42715,42717},1,4,123,128,{{2,56509},{2,71852},{4,71860},{4,44302}}}, -- Gladiator's Regalia
		[780] = {{42719,42718,42721,42720,42722},1,4,123,256,{{2,56509},{2,71852},{4,71860},{4,23047}}}, -- Gladiator's Felshroud
		[781] = {{43074,43072,43073,43075},1,4,115,0,{{2,57943},{3,29068},{4,57944}}}, -- Blessed Regalia of Undead Cleansing
		[782] = {{43077,43076,43078,43079},2,4,115,0,{{2,57943},{3,29068},{4,57944}}}, -- Undead Slayer's Blessed Armor
		[783] = {{43081,43080,43082,43083},3,4,115,0,{{2,57943},{3,29068},{4,57944}}}, -- Blessed Garb of the Undead Slayer
		[784] = {{43068,43069,43070,43071},4,4,115,0,{{2,57943},{3,29068},{4,57944}}}, -- Blessed Battlegear of Undead Slaying
		[785] = {{23324,34685,34683},0,1,1,32767,{{3,58933}}}, -- Midsummer Reveler
		[787] = {{43742,43747,43740,43743,43745},4,4,200,1,{{2,60173},{4,60175}}}, -- Dreadnaught Plate
		[788] = {{43744,43748,43739,43741,43746},4,4,200,1,{{2,60174},{4,60176}}}, -- Dreadnaught Battlegear
		[789] = {{43801,43805,43794,43796,43803},4,4,200,2,{{2,60152},{4,60153}}}, -- Redemption Battlegear
		[790] = {{43800,43806,43807,43797,43798},4,4,200,2,{{2,60147},{4,60148}}}, -- Redemption Regalia
		[791] = {{43795,43804,43793,43799,43802},4,4,200,2,{{2,60149},{4,60150}}}, -- Redemption Plate
		[792] = {{43815,43819,43809,43813,43817},4,4,200,32,{{2,60134},{4,60132}}}, -- Scourgeborne Battlegear
		[793] = {{43812,43818,43811,43814,43816},4,4,200,32,{{2,60130},{4,60133}}}, -- Scourgeborne Plate
		[794] = {{43735,43737,43738,43734,43736},3,4,200,4,{{2,60143},{4,60144}}}, -- Cryptstalker Battlegear
		[795] = {{43763,43772,43762,43765,43776},3,4,200,64,{{2,60168},{4,60169}}}, -- Earthshatter Battlegear
		[796] = {{43769,43773,43767,43764,43770},3,4,200,64,{{2,60164},{4,60165}}}, -- Earthshatter Garb
		[797] = {{43768,43774,43775,43766,43771},3,4,200,64,{{2,60166},{4,60167}}}, -- Earthshatter Regalia
		[798] = {{43753,43758,43822,43751,43756},2,4,200,1024,{{2,60141},{4,60142}}}, -- Dreamwalker Battlegear
		[799] = {{43754,43759,43820,43752,43755},2,4,200,1024,{{2,60135},{4,60137}}}, -- Dreamwalker Regalia
		[800] = {{43749,43757,43761,43750,43760},2,4,200,1024,{{2,60138},{4,60139}}}, -- Dreamwalker Garb
		[801] = {{43729,43731,43727,43728,43730},2,4,200,8,{{2,60162},{4,60163}}}, -- Bonescythe Battlegear
		[802] = {{43787,43791,43790,43788,43789},1,4,200,256,{{2,60170},{4,60172}}}, -- Plagueheart Garb
		[803] = {{43777,43781,43780,43778,43779},1,4,200,128,{{2,61062},{4,60146}}}, -- Frostfire Garb
		[804] = {{43733,43810,43808,43782,43784},1,4,200,16,{{2,60154},{4,60155}}}, -- Regalia of Faith
		[805] = {{43732,43785,43792,43783,43786},1,4,200,16,{{2,60156},{4,60157}}}, -- Garb of Faith
		[812] = {{6835,6833},0,1,24,0,{{2,62181}}}, -- Spring Tuxedo
		[813] = {{43260,43433,43434,43435,43436,43437,43438,43439},2,3,187,32767,{{4,63973},{6,63972}}}, -- Eviscerator's Battlegear
		[814] = {{42728,42727,42725,42723,42724,42729,42726,42730},4,3,187,32767,{{4,63973},{6,63972}}}, -- Ornate Saronite Battlegear
		[815] = {{43261,43262,43263,43264,43265,43266,43271,43273},2,3,187,32767,{{4,63973},{6,63972}}}, -- Overcaster Battlegear
		[816] = {{41350,41351,41353,41354,41349,41352,41347,41348},4,3,187,32767,{{4,63973},{6,63972}}}, -- Savage Saronite Battlegear
		[817] = {{43455,43457,43453,43452,43454,43450,43456,43451},3,3,187,32767,{{4,63973},{6,63972}}}, -- Stormhide Battlegear
		[818] = {{43447,43449,43445,43444,43446,43442,43448,43443},3,3,187,32767,{{4,63973},{6,63972}}}, -- Swiftarrow Battlegear
		[819] = {{43971,43973,43972,43974,41516,43969,43975,43970},1,3,187,0,{{4,63973},{6,63972}}}, -- Frostsavage Battlegear
		[820] = {{46221,46226,46213,46216,46224},4,4,225,2,{{2,64878},{4,64879}}}, -- Aegis Battlegear
		[821] = {{46215,46225,46214,46219,46222},4,4,225,2,{{2,64881},{4,64882}}}, -- Aegis Plate
		[822] = {{46220,46227,46228,46217,46218},4,4,225,2,{{2,64890},{4,64895}}}, -- Aegis Regalia
		[823] = {{46294,46303,46293,46296,46307},3,4,225,64,{{2,64916},{4,64917}}}, -- Worldbreaker Battlegear
		[824] = {{46300,46304,46298,46295,46301},3,4,225,64,{{2,64925},{4,64928}}}, -- Worldbreaker Garb
		[825] = {{46299,46305,46306,46297,46302},3,4,225,64,{{2,64921},{4,64922}}}, -- Worldbreaker Regalia
		[826] = {{46290,46292,46288,46289,46291},2,4,225,8,{{2,64914},{4,64915}}}, -- Terrorblade Battlegear
		[827] = {{46262,46269,46267,46260,46265},2,4,225,1024,{{2,64752},{4,64754}}}, -- Nightsong Battlegear
		[828] = {{45350,46266,46272,46309,46271},2,4,225,1024,{{2,64818},{4,64824}}}, -- Nightsong Garb
		[829] = {{46263,46270,46268,46261,46264},2,4,225,1024,{{2,64756},{4,64760}}}, -- Nightsong Regalia
		[830] = {{46282,46287,46278,46280,46285},4,4,225,1,{{2,64938},{4,64939}}}, -- Siegebreaker Battlegear
		[831] = {{46281,46286,46279,46283,46284},4,4,225,1,{{2,64933},{4,64936}}}, -- Siegebreaker Plate
		[832] = {{46230,46255,46257,46248,46256},1,4,225,16,{{2,64906},{4,64908}}}, -- Sanctification Garb
		[833] = {{46231,46259,46258,46247,46254},1,4,225,16,{{2,64910},{4,64912}}}, -- Sanctification Regalia
		[834] = {{46237,46241,46232,46235,46239},4,4,225,32,{{2,64735},{4,64736}}}, -- Darkruned Battlegear
		[835] = {{46234,46240,46233,46236,46238},4,4,225,32,{{2,64744},{4,64745}}}, -- Darkruned Plate
		[836] = {{46250,46252,46253,46249,46251},1,4,225,128,{{2,64867},{4,64869}}}, -- Kirin Tor Garb
		[837] = {{46243,46246,46245,46242,46244},1,4,225,256,{{2,64931},{4,64932}}}, -- Deathbringer Garb
		[838] = {{46274,46276,46277,46273,46275},3,4,225,4,{{2,64854},{4,64860}}}, -- Scourgestalker Battlegear
		[843] = {{48726,48729,48728,48725,48727},1,4,232,128,{{2,67164},{4,67185}}}, -- Khadgar's Regalia
		[844] = {{48731,48734,48733,48730,48732},1,4,232,128,{{2,67164},{4,67185}}}, -- Sunstrider's Regalia
		[845] = {{48736,48739,48738,48735,48737},1,4,232,256,{{2,67230},{4,67231}}}, -- Gul'dan's Regalia
		[846] = {{48741,48744,48743,48740,48742},1,4,232,256,{{2,67230},{4,67231}}}, -- Kel'Thuzad's Regalia
		[847] = {{48745,48749,48748,48746,48747},1,4,232,16,{{2,67201},{4,67202}}}, -- Velen's Raiment
		[848] = {{48750,48754,48753,48751,48752},1,4,232,16,{{2,67201},{4,67202}}}, -- Zabra's Raiment
		[849] = {{48755,48757,48759,48756,48758},1,4,232,16,{{2,67193},{4,67198}}}, -- Velen's Regalia
		[850] = {{48760,48762,48764,48761,48763},1,4,232,16,{{2,67193},{4,67198}}}, -- Zabra's Regalia
		[851] = {{48775,48778,48777,48774,48776},2,4,232,1024,{{2,67127},{4,67128}}}, -- Malfurion's Garb
		[852] = {{48770,48773,48772,48769,48771},2,4,232,1024,{{2,67127},{4,67128}}}, -- Runetotem's Garb
		[853] = {{48786,48788,48790,48787,48789},2,4,232,1024,{{2,67125},{4,67126}}}, -- Malfurion's Regalia
		[854] = {{48781,48783,48785,48782,48784},2,4,232,1024,{{2,67125},{4,67126}}}, -- Runetotem's Regalia
		[855] = {{48800,48803,48802,48799,48801},2,4,232,1024,{{2,67121},{4,67123}}}, -- Malfurion's Battlegear
		[856] = {{48795,48798,48797,48794,48796},2,4,232,1024,{{2,67121},{4,67123}}}, -- Runetotem's Battlegear
		[857] = {{48811,48813,48809,48810,48812},2,4,232,8,{{2,67209},{4,67211}}}, -- VanCleef's Battlegear
		[858] = {{48806,48808,48804,48805,48807},2,4,232,8,{{2,67209},{4,67211}}}, -- Garona's Battlegear
		[859] = {{48820,48822,48823,48819,48821},3,4,232,4,{{2,67150},{4,67151}}}, -- Windrunner's Battlegear
		[860] = {{48815,48817,48818,48814,48816},3,4,232,4,{{2,67150},{4,67151}}}, -- Windrunner's Pursuit
		[861] = {{48825,48827,48828,48824,48826},3,4,232,64,{{2,67225},{4,67226}}}, -- Nobundo's Garb
		[862] = {{48830,48832,48833,48829,48831},3,4,232,64,{{2,67225},{4,67226}}}, -- Thrall's Garb
		[863] = {{48843,48845,48842,48841,48844},3,4,232,64,{{2,67227},{4,67228}}}, -- Thrall's Regalia
		[864] = {{48838,48840,48837,48836,48839},3,4,232,64,{{2,67227},{4,67228}}}, -- Nobundo's Regalia
		[865] = {{48847,48849,48846,48848,48850},3,4,232,64,{{2,67220},{4,67221}}}, -- Nobundo's Battlegear
		[866] = {{48852,48854,48851,48853,48855},3,4,232,64,{{2,67220},{4,67221}}}, -- Thrall's Battlegear
		[867] = {{48867,48869,48865,48866,48868},4,4,232,1,{{2,67234},{4,67268}}}, -- Wrynn's Battlegear
		[868] = {{48862,48864,48860,48861,48863},4,4,232,1,{{2,67234},{4,67268}}}, -- Hellscream's Battlegear
		[869] = {{48876,48879,48875,48877,48878},4,4,232,1,{{2,67269},{4,67273}}}, -- Wrynn's Plate
		[870] = {{48871,48874,48870,48872,48873},4,4,232,1,{{2,67269},{4,67273}}}, -- Hellscream's Plate
		[871] = {{48887,48889,48885,48886,48888},4,4,232,32,{{2,67115},{4,67118}}}, -- Thassarian's Battlegear
		[872] = {{48882,48884,48880,48881,48883},4,4,232,32,{{2,67115},{4,67118}}}, -- Koltira's Battlegear
		[873] = {{48896,48899,48895,48897,48898},4,4,232,32,{{2,67119},{4,67120}}}, -- Thassarian's Plate
		[874] = {{48891,48894,48890,48892,48893},4,4,232,32,{{2,67119},{4,67120}}}, -- Koltira's Plate
		[875] = {{48902,48901,48900,48904,48903},4,4,232,2,{{2,67190},{4,67191}}}, -- Turalyon's Garb
		[876] = {{48907,48906,48905,48909,48908},4,4,232,2,{{2,67190},{4,67191}}}, -- Liadrin's Garb
		[877] = {{48917,48919,48915,48916,48918},4,4,232,2,{{2,67188},{4,67189}}}, -- Turalyon's Battlegear
		[878] = {{48912,48914,48910,48911,48913},4,4,232,2,{{2,67188},{4,67189}}}, -- Liadrin's Battlegear
		[879] = {{48928,48931,48927,48929,48930},4,4,232,2,{{2,67186},{4,67187}}}, -- Turalyon's Plate
		[880] = {{48923,48926,48922,48924,48925},4,4,232,2,{{2,67186},{4,67187}}}, -- Liadrin's Plate
		[881] = {{49463,49310},0,4,232,0,{{2,69755},{2,69599}}}, -- Purified Shard of the Gods
		[882] = {{49464,49488},0,4,245,0,{{2,69739},{2,69709}}}, -- Shiny Shard of the Gods
		[883] = {{51715,51712,51713,51716,51714},1,4,251,128,{{2,70752},{4,70748}}}, -- Bloodmage's Regalia
		[884] = {{51765,51762,51763,51766,51764},1,4,251,256,{{2,70839},{4,70841}}}, -- Dark Coven's Regalia
		[885] = {{51736,51734,51733,51735,51732},1,4,251,16,{{2,70770},{4,70798}}}, -- Crimson Acolyte's Raiment
		[886] = {{51737,51739,51740,51738,51741},1,4,251,16,{{2,70800},{4,70801}}}, -- Crimson Acolyte's Regalia
		[887] = {{51694,51692,51696,51695,51693},2,4,251,1024,{{2,70658},{4,70664}}}, -- Lasherweave Garb
		[888] = {{51704,51706,51702,51703,51705},2,4,251,1024,{{2,70718},{4,70723}}}, -- Lasherweave Regalia
		[889] = {{51699,51701,51697,51698,51700},2,4,251,1024,{{2,70724},{4,70726}}}, -- Lasherweave Battlegear
		[890] = {{51745,51746,51743,51742,51744},2,4,251,8,{{2,70805},{4,70803}}}, -- Shadowblade's Battlegear
		[891] = {{51710,51708,51707,51711,51709},3,4,251,4,{{2,70727},{4,70730}}}, -- Ahn'Kahar Blood Hunter's Battlegear
		[892] = {{51749,51751,51747,51748,51750},3,4,251,64,{{2,70807},{4,70808}}}, -- Frost Witch's Garb
		[893] = {{51759,51761,51757,51758,51760},3,4,251,64,{{2,70811},{4,70817}}}, -- Frost Witch's Regalia
		[894] = {{51754,51756,51752,51753,51755},3,4,251,64,{{2,70830},{4,70832}}}, -- Frost Witch's Battlegear
		[895] = {{51769,51767,51771,51770,51768},4,4,251,1,{{2,70854},{4,70847}}}, -- Ymirjar Lord's Battlegear
		[896] = {{51774,51776,51772,51773,51775},4,4,251,1,{{2,70843},{4,70844}}}, -- Ymirjar Lord's Plate
		[897] = {{51684,51682,51686,51685,51683},4,4,251,32,{{2,70655},{4,70656}}}, -- Scourgelord's Battlegear
		[898] = {{51689,51691,51687,51688,51690},4,4,251,32,{{2,70650},{4,70652}}}, -- Scourgelord's Plate
		[899] = {{51724,51726,51722,51723,51725},4,4,251,2,{{2,70755},{4,70756}}}, -- Lightsworn Garb
		[900] = {{51719,51721,51717,51718,51720},4,4,251,2,{{2,70765},{4,70762}}}, -- Lightsworn Battlegear
		[901] = {{51729,51731,51727,51728,51730},4,4,251,2,{{2,70758},{4,70761}}}, -- Lightsworn Plate
		[3000765] = {{40816,40856,40778,40797,40836},4,3,200,1,{{2,56449},{2,71850},{4,71858},{4,22738}},AL["Savage %s"],765}, -- Savage Gladiator's Battlegear
		[3000766] = {{40818,40858,40780,40798,40838},4,3,200,2,{{2,56449},{2,71850},{4,71858},{4,61776}},AL["Savage %s"],766}, -- Savage Gladiator's Vindication
		[3000767] = {{40930,40960,40898,40918,40936},4,3,200,2,{{2,56450},{2,71851},{4,71853},{4,58000}},AL["Savage %s"],767}, -- Savage Gladiator's Redemption
		[3000768] = {{40817,40857,40779,40799,40837},4,3,200,32,{{2,56449},{2,71850},{4,71858},{4,61257}},AL["Savage %s"],768}, -- Savage Gladiator's Desecration
		[3000769] = {{41016,41041,40987,41004,41030},3,3,200,64,{{2,56509},{2,71852},{4,71860},{4,44299}},AL["Savage %s"],769}, -- Savage Gladiator's Thunderfist
		[3000770] = {{41148,41208,41078,41134,41160},3,3,200,64,{{2,56449},{2,71850},{4,71858},{4,33018}},AL["Savage %s"],770}, -- Savage Gladiator's Earthshaker
		[3000771] = {{41010,41024,40986,40998,41023},3,3,200,64,{{2,71851},{2,56450},{4,44299},{4,71853}},AL["Savage %s"],771}, -- Savage Gladiator's Wartide
		[3000772] = {{41154,41214,41084,41140,41202},3,3,200,4,{{2,56449},{2,71850},{4,71858},{4,61256}},AL["Savage %s"],772}, -- Savage Gladiator's Pursuit
		[3000773] = {{41269,41271,41272,41268,41270},2,3,200,1024,{{2,56450},{2,71851},{4,71853},{4,38417}},AL["Savage %s"],773}, -- Savage Gladiator's Refuge
		[3000774] = {{41324,41278,41313,41290,41301},2,3,200,1024,{{2,56509},{2,71852},{4,71860},{4,46832}},AL["Savage %s"],774}, -- Savage Gladiator's Wildhide
		[3000775] = {{41675,41712,41658,41770,41664},2,3,200,1024,{{2,56449},{2,71850},{4,71858},{4,23218}},AL["Savage %s"],775}, -- Savage Gladiator's Sanctuary
		[3000776] = {{41644,41646,41647,41643,41645},2,3,200,8,{{2,56449},{2,71850},{4,71858},{4,21975}},AL["Savage %s"],776}, -- Savage Gladiator's Vestments
		[3000777] = {{41848,41850,41851,41847,41849},1,3,200,16,{{2,56450},{2,71851},{4,71853},{4,33333}},AL["Savage %s"],777}, -- Savage Gladiator's Investiture
		[3000778] = {{41912,41930,41918,41937,41924},1,3,200,16,{{2,56509},{2,71852},{4,71860},{4,33333}},AL["Savage %s"],778}, -- Savage Gladiator's Raiment
		[3000779] = {{41943,41962,41949,41968,41956},1,3,200,128,{{2,56509},{2,71852},{4,71860},{4,44302}},AL["Savage %s"],779}, -- Savage Gladiator's Regalia
		[3000780] = {{41990,42008,41996,42014,42002},1,3,200,256,{{2,56509},{2,71852},{4,71860},{4,23047}},AL["Savage %s"],780}, -- Savage Gladiator's Felshroud
		[3000843] = {{47748,47751,47749,47752,47750},1,4,232,128,{{2,67164},{4,67185}},AL["Conqueror's %s"],843}, -- Conqueror's Khadgar's Regalia
		[3000844] = {{47774,47777,47776,47773,47775},1,4,232,128,{{2,67164},{4,67185}},AL["Conqueror's %s"],844}, -- Conqueror's Sunstrider's Regalia
		[3000845] = {{47801,47798,47799,47802,47800},1,4,232,256,{{2,67230},{4,67231}},AL["Conqueror's %s"],845}, -- Conqueror's Gul'dan's Regalia
		[3000846] = {{47784,47787,47786,47783,47785},1,4,232,256,{{2,67230},{4,67231}},AL["Conqueror's %s"],846}, -- Conqueror's Kel'Thuzad's Regalia
		[3000847] = {{47914,47981,47936,47982,47980},1,4,232,16,{{2,67201},{4,67202}},AL["Conqueror's %s"],847}, -- Conqueror's Velen's Raiment
		[3000848] = {{48068,48071,48070,48067,48069},1,4,232,16,{{2,67201},{4,67202}},AL["Conqueror's %s"],848}, -- Conqueror's Zabra's Raiment
		[3000849] = {{48073,48076,48075,48072,48074},1,4,232,16,{{2,67193},{4,67198}},AL["Conqueror's %s"],849}, -- Conqueror's Velen's Regalia
		[3000850] = {{48098,48101,48100,48097,48099},1,4,232,16,{{2,67193},{4,67198}},AL["Conqueror's %s"],850}, -- Conqueror's Zabra's Regalia
		[3000851] = {{48102,48131,48129,48132,48130},2,4,232,1024,{{2,67127},{4,67128}},AL["Conqueror's %s"],851}, -- Conqueror's Malfurion's Garb
		[3000852] = {{48154,48157,48156,48153,48155},2,4,232,1024,{{2,67127},{4,67128}},AL["Conqueror's %s"],852}, -- Conqueror's Runetotem's Garb
		[3000853] = {{48158,48161,48159,48162,48160},2,4,232,1024,{{2,67125},{4,67126}},AL["Conqueror's %s"],853}, -- Conqueror's Malfurion's Regalia
		[3000854] = {{48184,48187,48186,48183,48185},2,4,232,1024,{{2,67125},{4,67126}},AL["Conqueror's %s"],854}, -- Conqueror's Runetotem's Regalia
		[3000855] = {{48214,48217,48216,48213,48215},2,4,232,1024,{{2,67121},{4,67123}},AL["Conqueror's %s"],855}, -- Conqueror's Malfurion's Battlegear
		[3000856] = {{48188,48191,48189,48192,48190},2,4,232,1024,{{2,67121},{4,67123}},AL["Conqueror's %s"],856}, -- Conqueror's Runetotem's Battlegear
		[3000857] = {{48218,48221,48219,48222,48220},2,4,232,8,{{2,67209},{4,67211}},AL["Conqueror's %s"],857}, -- Conqueror's VanCleef's Battlegear
		[3000858] = {{48245,48247,48243,48244,48246},2,4,232,8,{{2,67209},{4,67211}},AL["Conqueror's %s"],858}, -- Conqueror's Garona's Battlegear
		[3000859] = {{48250,48253,48251,48254,48252},3,4,232,4,{{2,67150},{4,67151}},AL["Conqueror's %s"],859}, -- Conqueror's Windrunner's Battlegear
		[3000860] = {{48277,48279,48275,48276,48278},3,4,232,4,{{2,67150},{4,67151}},AL["Conqueror's %s"],860}, -- Conqueror's Windrunner's Pursuit
		[3000861] = {{48280,48283,48281,48284,48282},3,4,232,64,{{2,67225},{4,67226}},AL["Conqueror's %s"],861}, -- Conqueror's Nobundo's Garb
		[3000862] = {{48297,48299,48295,48296,48298},3,4,232,64,{{2,67225},{4,67226}},AL["Conqueror's %s"],862}, -- Conqueror's Thrall's Garb
		[3000863] = {{48338,48340,48336,48337,48339},3,4,232,64,{{2,67227},{4,67228}},AL["Conqueror's %s"],863}, -- Conqueror's Thrall's Regalia
		[3000864] = {{48313,48315,48310,48312,48314},3,4,232,64,{{2,67227},{4,67228}},AL["Conqueror's %s"],864}, -- Conqueror's Nobundo's Regalia
		[3000865] = {{48343,48345,48341,48342,48344},3,4,232,64,{{2,67220},{4,67221}},AL["Conqueror's %s"],865}, -- Conqueror's Nobundo's Battlegear
		[3000866] = {{48368,48370,48366,48367,48369},3,4,232,64,{{2,67220},{4,67221}},AL["Conqueror's %s"],866}, -- Conqueror's Thrall's Battlegear
		[3000867] = {{48371,48374,48372,48375,48373},4,4,232,1,{{2,67234},{4,67268}},AL["Conqueror's %s"],867}, -- Conqueror's Wrynn's Battlegear
		[3000868] = {{48388,48390,48386,48387,48389},4,4,232,1,{{2,67234},{4,67268}},AL["Conqueror's %s"],868}, -- Conqueror's Hellscream's Battlegear
		[3000869] = {{48429,48448,48436,48449,48445},4,4,232,1,{{2,67269},{4,67273}},AL["Conqueror's %s"],869}, -- Conqueror's Wrynn's Plate
		[3000870] = {{48458,48460,48456,48457,48459},4,4,232,1,{{2,67269},{4,67273}},AL["Conqueror's %s"],870}, -- Conqueror's Hellscream's Plate
		[3000871] = {{48472,48478,48474,48480,48476},4,4,232,32,{{2,67115},{4,67118}},AL["Conqueror's %s"],871}, -- Conqueror's Thassarian's Battlegear
		[3000872] = {{48503,48505,48501,48502,48504},4,4,232,32,{{2,67115},{4,67118}},AL["Conqueror's %s"],872}, -- Conqueror's Koltira's Battlegear
		[3000873] = {{48529,48535,48531,48537,48533},4,4,232,32,{{2,67119},{4,67120}},AL["Conqueror's %s"],873}, -- Conqueror's Thassarian's Plate
		[3000874] = {{48560,48562,48558,48559,48561},4,4,232,32,{{2,67119},{4,67120}},AL["Conqueror's %s"],874}, -- Conqueror's Koltira's Plate
		[3000875] = {{48564,48572,48566,48574,48568},4,4,232,2,{{2,67190},{4,67191}},AL["Conqueror's %s"],875}, -- Conqueror's Turalyon's Garb
		[3000876] = {{48597,48595,48599,48598,48596},4,4,232,2,{{2,67190},{4,67191}},AL["Conqueror's %s"],876}, -- Conqueror's Liadrin's Garb
		[3000877] = {{48604,48606,48602,48603,48605},4,4,232,2,{{2,67188},{4,67189}},AL["Conqueror's %s"],877}, -- Conqueror's Turalyon's Battlegear
		[3000878] = {{48629,48627,48631,48630,48628},4,4,232,2,{{2,67188},{4,67189}},AL["Conqueror's %s"],878}, -- Conqueror's Liadrin's Battlegear
		[3000879] = {{48634,48636,48632,48633,48635},4,4,232,2,{{2,67186},{4,67187}},AL["Conqueror's %s"],879}, -- Conqueror's Turalyon's Plate
		[3000880] = {{48654,48656,48652,48653,48655},4,4,232,2,{{2,67186},{4,67187}},AL["Conqueror's %s"],880}, -- Conqueror's Liadrin's Plate
		[3000883] = {{50276,50279,50278,50275,50277},1,4,251,128,{{2,70752},{4,70748}},nil,883}, -- Bloodmage's Regalia
		[3000884] = {{50241,50244,50243,50240,50242},1,4,251,256,{{2,70839},{4,70841}},nil,884}, -- Dark Coven's Regalia
		[3000885] = {{50765,50767,50768,50766,50769},1,4,251,16,{{2,70770},{4,70798}},nil,885}, -- Crimson Acolyte's Raiment
		[3000886] = {{50392,50396,50394,50391,50393},1,4,251,16,{{2,70800},{4,70801}},nil,886}, -- Crimson Acolyte's Regalia
		[3000887] = {{50108,50113,50106,50107,50109},2,4,251,1024,{{2,70658},{4,70664}},nil,887}, -- Lasherweave Garb
		[3000888] = {{50821,50819,50823,50822,50820},2,4,251,1024,{{2,70718},{4,70723}},nil,888}, -- Lasherweave Regalia
		[3000889] = {{50826,50824,50828,50827,50825},2,4,251,1024,{{2,70724},{4,70726}},nil,889}, -- Lasherweave Battlegear
		[3000890] = {{50089,50105,50087,50088,50090},2,4,251,8,{{2,70805},{4,70803}},nil,890}, -- Shadowblade's Battlegear
		[3000891] = {{50115,50117,50118,50114,50116},3,4,251,4,{{2,70727},{4,70730}},nil,891}, -- Ahn'Kahar Blood Hunter's Battlegear
		[3000892] = {{50837,50839,50835,50836,50838},3,4,251,64,{{2,70807},{4,70808}},nil,892}, -- Frost Witch's Garb
		[3000893] = {{50843,50845,50841,50842,50844},3,4,251,64,{{2,70811},{4,70817}},nil,893}, -- Frost Witch's Regalia
		[3000894] = {{50832,50834,50830,50831,50833},3,4,251,64,{{2,70830},{4,70832}},nil,894}, -- Frost Witch's Battlegear
		[3000895] = {{50080,50082,50078,50079,50081},4,4,251,1,{{2,70854},{4,70847}},nil,895}, -- Ymirjar Lord's Battlegear
		[3000896] = {{50848,50846,50850,50849,50847},4,4,251,1,{{2,70843},{4,70844}},nil,896}, -- Ymirjar Lord's Plate
		[3000897] = {{50096,50098,50094,50095,50097},4,4,251,32,{{2,70655},{4,70656}},nil,897}, -- Scourgelord's Battlegear
		[3000898] = {{50855,50853,50857,50856,50854},4,4,251,32,{{2,70650},{4,70652}},nil,898}, -- Scourgelord's Plate
		[3000899] = {{50867,50865,50869,50868,50866},4,4,251,2,{{2,70755},{4,70756}},nil,899}, -- Lightsworn Garb
		[3000900] = {{50326,50324,50328,50327,50325},4,4,251,2,{{2,70765},{4,70762}},nil,900}, -- Lightsworn Battlegear
		[3000901] = {{50862,50860,50864,50863,50861},4,4,251,2,{{2,70758},{4,70761}},nil,901}, -- Lightsworn Plate
		[3001765] = {{40819,40859,40783,40801,40840},4,4,200,1,{{2,56449},{2,71850},{4,71858},{4,22738}},AL["Hateful %s"],765}, -- Hateful Gladiator's Battlegear
		[3001766] = {{40821,40861,40782,40802,40842},4,4,200,2,{{2,56449},{2,71850},{4,71858},{4,61776}},AL["Hateful %s"],766}, -- Hateful Gladiator's Vindication
		[3001767] = {{40931,40961,40904,40925,40937},4,4,200,2,{{2,56450},{2,71851},{4,71853},{4,58000}},AL["Hateful %s"],767}, -- Hateful Gladiator's Redemption
		[3001768] = {{40820,40860,40781,40803,40841},4,4,200,32,{{2,56449},{2,71850},{4,71858},{4,61257}},AL["Hateful %s"],768}, -- Hateful Gladiator's Desecration
		[3001769] = {{41017,41042,40989,41005,41031},3,4,200,64,{{2,56509},{2,71852},{4,71860},{4,44299}},AL["Hateful %s"],769}, -- Hateful Gladiator's Thunderfist
		[3001770] = {{41149,41209,41079,41135,41162},3,4,200,64,{{2,56449},{2,71850},{4,71858},{4,33018}},AL["Hateful %s"],770}, -- Hateful Gladiator's Earthshaker
		[3001771] = {{41011,41036,40988,40999,41025},3,4,200,64,{{2,71851},{2,56450},{4,44299},{4,71853}},AL["Hateful %s"],771}, -- Hateful Gladiator's Wartide
		[3001772] = {{41155,41215,41085,41141,41203},3,4,200,4,{{2,56449},{2,71850},{4,71858},{4,61256}},AL["Hateful %s"],772}, -- Hateful Gladiator's Pursuit
		[3001773] = {{41319,41273,41308,41284,41296},2,4,200,1024,{{2,56450},{2,71851},{4,71853},{4,38417}},AL["Hateful %s"],773}, -- Hateful Gladiator's Refuge
		[3001774] = {{41325,41279,41314,41291,41302},2,4,200,1024,{{2,56509},{2,71852},{4,71860},{4,46832}},AL["Hateful %s"],774}, -- Hateful Gladiator's Wildhide
		[3001775] = {{41676,41713,41659,41771,41665},2,4,200,1024,{{2,56449},{2,71850},{4,71858},{4,23218}},AL["Hateful %s"],775}, -- Hateful Gladiator's Sanctuary
		[3001776] = {{41670,41681,41648,41765,41653},2,4,200,8,{{2,56449},{2,71850},{4,71858},{4,21975}},AL["Hateful %s"],776}, -- Hateful Gladiator's Vestments
		[3001777] = {{41852,41867,41857,41872,41862},1,4,200,16,{{2,56450},{2,71851},{4,71853},{4,33333}},AL["Hateful %s"],777}, -- Hateful Gladiator's Investiture
		[3001778] = {{41913,41931,41919,41938,41925},1,4,200,16,{{2,56509},{2,71852},{4,71860},{4,33333}},AL["Hateful %s"],778}, -- Hateful Gladiator's Raiment
		[3001779] = {{41944,41963,41950,41969,41957},1,4,200,128,{{2,56509},{2,71852},{4,71860},{4,44302}},AL["Hateful %s"],779}, -- Hateful Gladiator's Regalia
		[3001780] = {{41991,42009,42001,42015,42003},1,4,200,256,{{2,56509},{2,71852},{4,71860},{4,23047}},AL["Hateful %s"],780}, -- Hateful Gladiator's Felshroud
		[3002765] = {{40823,40862,40786,40804,40844},4,4,213,1,{{2,56449},{2,71850},{4,71858},{4,22738}},AL["Deadly %s"],765}, -- Deadly Gladiator's Battlegear
		[3002766] = {{40825,40864,40785,40805,40846},4,4,213,2,{{2,56449},{2,71850},{4,71858},{4,61776}},AL["Deadly %s"],766}, -- Deadly Gladiator's Vindication
		[3002767] = {{40932,40962,40905,40926,40938},4,4,213,2,{{2,56450},{2,71851},{4,71853},{4,58000}},AL["Deadly %s"],767}, -- Deadly Gladiator's Redemption
		[3002768] = {{40824,40863,40784,40806,40845},4,4,213,32,{{2,56449},{2,71850},{4,71858},{4,61257}},AL["Deadly %s"],768}, -- Deadly Gladiator's Desecration
		[3002769] = {{41018,41043,40991,41006,41032},3,4,213,64,{{2,56509},{2,71852},{4,71860},{4,44299}},AL["Deadly %s"],769}, -- Deadly Gladiator's Thunderfist
		[3002770] = {{41150,41210,41080,41136,41198},3,4,213,64,{{2,56449},{2,71850},{4,71858},{4,33018}},AL["Deadly %s"],770}, -- Deadly Gladiator's Earthshaker
		[3002771] = {{41012,41037,40990,41000,41026},3,4,213,64,{{2,71851},{2,56450},{4,44299},{4,71853}},AL["Deadly %s"],771}, -- Deadly Gladiator's Wartide
		[3002772] = {{41156,41216,41086,41142,41204},3,4,213,4,{{2,56449},{2,71850},{4,71858},{4,61256}},AL["Deadly %s"],772}, -- Deadly Gladiator's Pursuit
		[3002773] = {{41320,41274,41309,41286,41297},2,4,213,1024,{{2,56450},{2,71851},{4,71853},{4,38417}},AL["Deadly %s"],773}, -- Deadly Gladiator's Refuge
		[3002774] = {{41326,41280,41315,41292,41303},2,4,213,1024,{{2,56509},{2,71852},{4,71860},{4,46832}},AL["Deadly %s"],774}, -- Deadly Gladiator's Wildhide
		[3002775] = {{41677,41714,41660,41772,41666},2,4,213,1024,{{2,56449},{2,71850},{4,71858},{4,23218}},AL["Deadly %s"],775}, -- Deadly Gladiator's Sanctuary
		[3002776] = {{41671,41682,41649,41766,41654},2,4,213,8,{{2,56449},{2,71850},{4,71858},{4,21975}},AL["Deadly %s"],776}, -- Deadly Gladiator's Vestments
		[3002777] = {{41853,41868,41858,41873,41863},1,4,213,16,{{2,56450},{2,71851},{4,71853},{4,33333}},AL["Deadly %s"],777}, -- Deadly Gladiator's Investiture
		[3002778] = {{41914,41933,41920,41939,41926},1,4,213,16,{{2,56509},{2,71852},{4,71860},{4,33333}},AL["Deadly %s"],778}, -- Deadly Gladiator's Raiment
		[3002779] = {{41945,41964,41951,41970,41958},1,4,213,128,{{2,56509},{2,71852},{4,71860},{4,44302}},AL["Deadly %s"],779}, -- Deadly Gladiator's Regalia
		[3002780] = {{41992,42010,41997,42016,42004},1,4,213,256,{{2,56509},{2,71852},{4,71860},{4,23047}},AL["Deadly %s"],780}, -- Deadly Gladiator's Felshroud
		[3003765] = {{40826,40866,40789,40807,40847},4,4,238,1,{{2,56449},{2,71850},{4,71858},{4,22738}},AL["Furious %s"],765}, -- Furious Gladiator's Battlegear
		[3003766] = {{40828,40869,40788,40808,40849},4,4,238,2,{{2,56449},{2,71850},{4,71858},{4,61776}},AL["Furious %s"],766}, -- Furious Gladiator's Vindication
		[3003767] = {{40933,40963,40907,40927,40939},4,4,238,2,{{2,56450},{2,71851},{4,71853},{4,58000}},AL["Furious %s"],767}, -- Furious Gladiator's Redemption
		[3003768] = {{40827,40868,40787,40809,40848},4,4,238,32,{{2,56449},{2,71850},{4,71858},{4,61257}},AL["Furious %s"],768}, -- Furious Gladiator's Desecration
		[3003769] = {{41019,41044,40993,41007,41033},3,4,238,64,{{2,56509},{2,71852},{4,71860},{4,44299}},AL["Furious %s"],769}, -- Furious Gladiator's Thunderfist
		[3003770] = {{41151,41211,41081,41137,41199},3,4,238,64,{{2,56449},{2,71850},{4,71858},{4,33018}},AL["Furious %s"],770}, -- Furious Gladiator's Earthshaker
		[3003771] = {{41013,41038,40992,41001,41027},3,4,238,64,{{2,71851},{2,56450},{4,44299},{4,71853}},AL["Furious %s"],771}, -- Furious Gladiator's Wartide
		[3003772] = {{41157,41217,41087,41143,41205},3,4,238,4,{{2,56449},{2,71850},{4,71858},{4,61256}},AL["Furious %s"],772}, -- Furious Gladiator's Pursuit
		[3003773] = {{41321,41275,41310,41287,41298},2,4,238,1024,{{2,56450},{2,71851},{4,71853},{4,38417}},AL["Furious %s"],773}, -- Furious Gladiator's Refuge
		[3003774] = {{41327,41281,41316,41293,41304},2,4,238,1024,{{2,56509},{2,71852},{4,71860},{4,46832}},AL["Furious %s"],774}, -- Furious Gladiator's Wildhide
		[3003775] = {{41678,41715,41661,41773,41667},2,4,238,1024,{{2,56449},{2,71850},{4,71858},{4,23218}},AL["Furious %s"],775}, -- Furious Gladiator's Sanctuary
		[3003776] = {{41672,41683,41650,41767,41655},2,4,238,8,{{2,56449},{2,71850},{4,71858},{4,21975}},AL["Furious %s"],776}, -- Furious Gladiator's Vestments
		[3003777] = {{41854,41869,41859,41874,41864},1,4,238,16,{{2,56450},{2,71851},{4,71853},{4,33333}},AL["Furious %s"],777}, -- Furious Gladiator's Investiture
		[3003778] = {{41915,41934,41921,41940,41927},1,4,238,16,{{2,56509},{2,71852},{4,71860},{4,33333}},AL["Furious %s"],778}, -- Furious Gladiator's Raiment
		[3003779] = {{41946,41965,41953,41971,41959},1,4,238,128,{{2,56509},{2,71852},{4,71860},{4,44302}},AL["Furious %s"],779}, -- Furious Gladiator's Regalia
		[3003780] = {{41993,42011,41998,42017,42005},1,4,256,{{2,56509},{2,71852},{4,71860},{4,23047}},AL["Furious %s"],780}, -- Furious Gladiator's Felshroud
		[3004765] = {{40829,40870,40790,40810,40850},4,4,213,1,{{2,56449},{2,71850},{4,71858},{4,22738}},AL["Relentless %s"],765}, -- Relentless Gladiator's Battlegear
		[3004766] = {{40831,40872,40772,40812,40852},4,4,213,2,{{2,56449},{2,71850},{4,71858},{4,61776}},AL["Relentless %s"],766}, -- Relentless Gladiator's Vindication
		[3004767] = {{40934,40964,40910,40928,40940},4,4,213,2,{{2,56450},{2,71851},{4,71853},{4,58000}},AL["Relentless %s"],767}, -- Relentless Gladiator's Redemption
		[3004768] = {{40830,40871,40791,40811,40851},4,4,213,32,{{2,56449},{2,71850},{4,71858},{4,61257}},AL["Relentless %s"],768}, -- Relentless Gladiator's Desecration
		[3004769] = {{41020,41045,40995,41008,41034},3,4,213,64,{{2,56509},{2,71852},{4,71860},{4,44299}},AL["Relentless %s"],769}, -- Relentless Gladiator's Thunderfist
		[3004770] = {{41152,41212,41082,41138,41200},3,4,213,64,{{2,56449},{2,71850},{4,71858},{4,33018}},AL["Relentless %s"],770}, -- Relentless Gladiator's Earthshaker
		[3004771] = {{41014,41039,40994,41002,41028},3,4,213,64,{{2,71851},{2,56450},{4,44299},{4,71853}},AL["Relentless %s"],771}, -- Relentless Gladiator's Wartide
		[3004772] = {{41158,41218,41088,41144,41206},3,4,213,4,{{2,56449},{2,71850},{4,71858},{4,61256}},AL["Relentless %s"],772}, -- Relentless Gladiator's Pursuit
		[3004773] = {{41322,41276,41311,41288,41299},2,4,213,1024,{{2,56450},{2,71851},{4,71853},{4,38417}},AL["Relentless %s"],773}, -- Relentless Gladiator's Refuge
		[3004774] = {{41328,41282,41317,41294,41305},2,4,213,1024,{{2,56509},{2,71852},{4,71860},{4,46832}},AL["Relentless %s"],774}, -- Relentless Gladiator's Wildhide
		[3004775] = {{41679,41716,41662,41774,41668},2,4,213,1024,{{2,56449},{2,71850},{4,71858},{4,23218}},AL["Relentless %s"],775}, -- Relentless Gladiator's Sanctuary
		[3004776] = {{41673,41684,41651,41768,41656},2,4,213,8,{{2,56449},{2,71850},{4,71858},{4,21975}},AL["Relentless %s"],776}, -- Relentless Gladiator's Vestments
		[3004777] = {{41855,41870,41860,41875,41865},1,4,213,16,{{2,56450},{2,71851},{4,71853},{4,33333}},AL["Relentless %s"],777}, -- Relentless Gladiator's Investiture
		[3004778] = {{41916,41935,41922,41941,41928},1,4,213,16,{{2,56509},{2,71852},{4,71860},{4,33333}},AL["Relentless %s"],778}, -- Relentless Gladiator's Raiment
		[3004779] = {{41947,41966,41954,41972,41960},1,4,213,128,{{2,56509},{2,71852},{4,71860},{4,44302}},AL["Relentless %s"],779}, -- Relentless Gladiator's Regalia
		[3004780] = {{41994,42012,41999,42018,42006},1,4,213,256,{{2,56509},{2,71852},{4,71860},{4,23047}},AL["Relentless %s"],780}, -- Relentless Gladiator's Felshroud
		[3005765] = {{51543,51545,51541,51542,51544},4,4,213,1,{{2,56449},{2,71850},{4,71858},{4,22738}},AL["Wrathful %s"],765}, -- Wrathful Gladiator's Battlegear
		[3005766] = {{51476,51479,51474,51475,51477},4,4,213,2,{{2,56449},{2,71850},{4,71858},{4,61776}},AL["Wrathful %s"],766}, -- Wrathful Gladiator's Vindication
		[3005767] = {{51470,51473,51468,51469,51471},4,4,213,2,{{2,56450},{2,71851},{4,71853},{4,58000}},AL["Wrathful %s"],767}, -- Wrathful Gladiator's Redemption
		[3005768] = {{51415,51418,51413,51414,51416},4,4,213,32,{{2,56449},{2,71850},{4,71858},{4,61257}},AL["Wrathful %s"],768}, -- Wrathful Gladiator's Desecration
		[3005769] = {{51511,51514,51509,51510,51512},3,4,213,64,{{2,56509},{2,71852},{4,71860},{4,44299}},AL["Wrathful %s"],769}, -- Wrathful Gladiator's Thunderfist
		[3005770] = {{51505,51508,51503,51504,51506},3,4,213,64,{{2,56449},{2,71850},{4,71858},{4,33018}},AL["Wrathful %s"],770}, -- Wrathful Gladiator's Earthshaker
		[3005771] = {{51499,51402,51497,51498,51500},3,4,213,64,{{2,71851},{2,56450},{4,44299},{4,71853}},AL["Wrathful %s"],771}, -- Wrathful Gladiator's Wartide
		[3005772] = {{51460,51463,51458,51459,51461},3,4,213,4,{{2,56449},{2,71850},{4,71858},{4,61256}},AL["Wrathful %s"],772}, -- Wrathful Gladiator's Pursuit
		[3005773] = {{51421,51424,51419,51420,51422},2,4,213,1024,{{2,56450},{2,71851},{4,71853},{4,38417}},AL["Wrathful %s"],773}, -- Wrathful Gladiator's Refuge
		[3005774] = {{51435,51438,51433,51434,51436},2,4,213,1024,{{2,56509},{2,71852},{4,71860},{4,46832}},AL["Wrathful %s"],774}, -- Wrathful Gladiator's Wildhide
		[3005775] = {{51427,51430,51425,51426,51428},2,4,213,1024,{{2,56449},{2,71850},{4,71858},{4,23218}},AL["Wrathful %s"],775}, -- Wrathful Gladiator's Sanctuary
		[3005776] = {{51494,51491,51492,51493,51496},2,4,213,8,{{2,56449},{2,71850},{4,71858},{4,21975}},AL["Wrathful %s"],776}, -- Wrathful Gladiator's Vestments
		[3005777] = {{51484,51481,51482,51483,51485},1,4,213,16,{{2,56450},{2,71851},{4,71853},{4,33333}},AL["Wrathful %s"],777}, -- Wrathful Gladiator's Investiture
		[3005778] = {{51489,51486,51487,51488,51490},1,4,213,16,{{2,56509},{2,71852},{4,71860},{4,33333}},AL["Wrathful %s"],778}, -- Wrathful Gladiator's Raiment
		[3005779] = {{51465,51462,51463,51465,51466},1,4,213,128,{{2,56509},{2,71852},{4,71860},{4,44302}},AL["Wrathful %s"],779}, -- Wrathful Gladiator's Regalia
		[3005780] = {{51538,51540,51536,51537,51539},1,4,213,256,{{2,56509},{2,71852},{4,71860},{4,23047}},AL["Wrathful %s"],780}, -- Wrathful Gladiator's Felshroud
		[3100787] = {{39610,39613,39611,39622,39612},4,4,200,1,{{2,60173},{4,60175}},AL["Heroes' %s"],787}, -- Heroes' Dreadnaught Plate
		[3100788] = {{39605,39608,39606,39609,39607},4,4,200,1,{{2,60174},{4,60176}},AL["Heroes' %s"],788}, -- Heroes' Dreadnaught Battlegear
		[3100789] = {{39635,39637,39633,39634,39636},4,4,200,2,{{2,60152},{4,60153}},AL["Heroes' %s"],789}, -- Heroes' Redemption Battlegear
		[3100790] = {{39628,39631,39629,39632,39630},4,4,200,2,{{2,60147},{4,60148}},AL["Heroes' %s"],790}, -- Heroes' Redemption Regalia
		[3100791] = {{39640,39642,39638,39639,39641},4,4,200,2,{{2,60149},{4,60150}},AL["Heroes' %s"],791}, -- Heroes' Redemption Plate
		[3100792] = {{39619,39621,39617,39618,39620},4,4,200,32,{{2,60134},{4,60132}},AL["Heroes' %s"],792}, -- Heroes' Scourgeborne Battlegear
		[3100793] = {{39625,39627,39623,39624,39626},4,4,200,32,{{2,60130},{4,60133}},AL["Heroes' %s"],793}, -- Heroes' Scourgeborne Plate
		[3100794] = {{39578,39581,39579,39582,39580},3,4,200,4,{{2,60143},{4,60144}},AL["Heroes' %s"],794}, -- Heroes' Cryptstalker Battlegear
		[3100795] = {{39602,39604,39597,39601,39603},3,4,200,64,{{2,60168},{4,60169}},AL["Heroes' %s"],795}, -- Heroes' Earthshatter Battlegear
		[3100796] = {{39594,39596,39592,39593,39595},3,4,200,64,{{2,60164},{4,60165}},AL["Heroes' %s"],796}, -- Heroes' Earthshatter Garb
		[3100797] = {{39583,39590,39588,39591,39589},3,4,200,64,{{2,60166},{4,60167}},AL["Heroes' %s"],797}, -- Heroes' Earthshatter Regalia
		[3100798] = {{39553,39556,39554,39557,39555},2,4,200,1024,{{2,60141},{4,60142}},AL["Heroes' %s"],798}, -- Heroes' Dreamwalker Battlegear
		[3100799] = {{39531,39542,39538,39543,39539},2,4,200,1024,{{2,60135},{4,60137}},AL["Heroes' %s"],799}, -- Heroes' Dreamwalker Regalia
		[3100800] = {{39545,39548,39547,39544,39546},2,4,200,1024,{{2,60138},{4,60139}},AL["Heroes' %s"],800}, -- Heroes' Dreamwalker Garb
		[3100801] = {{39561,39565,39558,39560,39564},2,4,200,8,{{2,60162},{4,60163}},AL["Heroes' %s"],801}, -- Heroes' Bonescythe Battlegear
		[3100802] = {{39496,39499,39497,39500,39498},1,4,200,256,{{2,60170},{4,60172}},AL["Heroes' %s"],802}, -- Heroes' Plagueheart Garb
		[3100803] = {{39491,39494,39492,39495,39493},1,4,200,128,{{2,61062},{4,60146}},AL["Heroes' %s"],803}, -- Heroes' Frostfire Garb
		[3100804] = {{39514,39518,39515,39519,39517},1,4,200,16,{{2,60154},{4,60155}},AL["Heroes' %s"],804}, -- Heroes' Regalia of Faith
		[3100805] = {{39521,39529,39523,39530,39528},1,4,200,16,{{2,60156},{4,60157}},AL["Heroes' %s"],805}, -- Heroes' Garb of Faith
		[3100820] = {{45377,45380,45375,45376,45379},4,4,225,2,{{2,64878},{4,64879}},AL["Valorous %s"],820}, -- Valorous Aegis Battlegear
		[3100821] = {{45382,45385,45381,45383,45384},4,4,225,2,{{2,64881},{4,64882}},AL["Valorous %s"],821}, -- Valorous Aegis Plate
		[3100822] = {{45372,45373,45374,45370,45371},4,4,225,2,{{2,64890},{4,64895}},AL["Valorous %s"],822}, -- Valorous Aegis Regalia
		[3100823] = {{45412,45415,45413,45414,45416},3,4,225,64,{{2,64916},{4,64917}},AL["Valorous %s"],823}, -- Valorous Worldbreaker Battlegear
		[3100824] = {{45408,45410,45411,45406,45409},3,4,225,64,{{2,64925},{4,64928}},AL["Valorous %s"],824}, -- Valorous Worldbreaker Garb
		[3100825] = {{45402,45404,45405,45401,45403},3,4,225,64,{{2,64921},{4,64922}},AL["Valorous %s"],825}, -- Valorous Worldbreaker Regalia
		[3100826] = {{45398,45400,45396,45397,45399},2,4,225,8,{{2,64914},{4,64915}},AL["Valorous %s"],826}, -- Valorous Terrorblade Battlegear
		[3100827] = {{45356,45359,45358,45355,45357},2,4,225,1024,{{2,64752},{4,64754}},AL["Valorous %s"],827}, -- Valorous Nightsong Battlegear
		[3100828] = {{46313,45352,45354,45351,45353},2,4,225,1024,{{2,64818},{4,64824}},AL["Valorous %s"],828}, -- Valorous Nightsong Garb
		[3100829] = {{45346,45349,45348,45345,45347},2,4,225,1024,{{2,64756},{4,64760}},AL["Valorous %s"],829}, -- Valorous Nightsong Regalia
		[3100830] = {{45431,45433,45429,45430,45432},4,4,225,1,{{2,64938},{4,64939}},AL["Valorous %s"],830}, -- Valorous Siegebreaker Battlegear
		[3100831] = {{45425,45428,45424,45426,45427},4,4,225,1,{{2,64933},{4,64936}},AL["Valorous %s"],831}, -- Valorous Siegebreaker Plate
		[3100832] = {{45391,45393,45395,45392,45394},1,4,225,16,{{2,64906},{4,64908}},AL["Valorous %s"],832}, -- Valorous Sanctification Garb
		[3100833] = {{45386,45390,45389,45387,45388},1,4,225,16,{{2,64910},{4,64912}},AL["Valorous %s"],833}, -- Valorous Sanctification Regalia
		[3100834] = {{45342,45344,45340,45341,45343},4,4,225,32,{{2,64735},{4,64736}},AL["Valorous %s"],834}, -- Valorous Darkruned Battlegear
		[3100835] = {{45336,45339,45335,45337,45338},4,4,225,32,{{2,64744},{4,64745}},AL["Valorous %s"],835}, -- Valorous Darkruned Plate
		[3100836] = {{45365,45369,45368,46131,45367},1,4,225,128,{{2,64867},{4,64869}},AL["Valorous %s"],836}, -- Valorous Kirin Tor Garb
		[3100837] = {{45417,45422,45421,45419,45420},1,4,225,256,{{2,64931},{4,64932}},AL["Valorous %s"],837}, -- Valorous Deathbringer Garb
		[3100838] = {{45361,45363,45364,45360,45362},3,4,225,4,{{2,64854},{4,64860}},AL["Valorous %s"],838}, -- Valorous Scourgestalker Battlegear
		[3250787] = {{40546,40548,40544,40545,40547},4,4,213,1,{{2,60173},{4,60175}},AL["Valorous %s"],787}, -- Valorous Dreadnaught Plate
		[3250788] = {{40528,40530,40525,40527,40529},4,4,213,1,{{2,60174},{4,60176}},AL["Valorous %s"],788}, -- Valorous Dreadnaught Battlegear
		[3250789] = {{40576,40578,40574,40575,40577},4,4,213,2,{{2,60152},{4,60153}},AL["Valorous %s"],789}, -- Valorous Redemption Battlegear
		[3250790] = {{40571,40573,40569,40570,40572},4,4,213,2,{{2,60147},{4,60148}},AL["Valorous %s"],790}, -- Valorous Redemption Regalia
		[3250791] = {{40581,40584,40579,40580,40583},4,4,213,2,{{2,60149},{4,60150}},AL["Valorous %s"],791}, -- Valorous Redemption Plate
		[3250792] = {{40554,40557,40550,40552,40556},4,4,213,32,{{2,60134},{4,60132}},AL["Valorous %s"],792}, -- Valorous Scourgeborne Battlegear
		[3250793] = {{40565,40568,40559,40563,40567},4,4,213,32,{{2,60130},{4,60133}},AL["Valorous %s"],793}, -- Valorous Scourgeborne Plate
		[3250794] = {{40505,40507,40503,40504,40506},3,4,213,4,{{2,60143},{4,60144}},AL["Valorous %s"],794}, -- Valorous Cryptstalker Battlegear
		[3250795] = {{40521,40524,40523,40520,40522},3,4,213,64,{{2,60168},{4,60169}},AL["Valorous %s"],795}, -- Valorous Earthshatter Battlegear
		[3250796] = {{40516,40518,40514,40515,40517},3,4,213,64,{{2,60164},{4,60165}},AL["Valorous %s"],796}, -- Valorous Earthshatter Garb
		[3250797] = {{40510,40513,40508,40509,40512},3,4,213,64,{{2,60166},{4,60167}},AL["Valorous %s"],797}, -- Valorous Earthshatter Regalia
		[3250798] = {{40473,40494,40471,40472,40493},2,4,213,1024,{{2,60141},{4,60142}},AL["Valorous %s"],798}, -- Valorous Dreamwalker Battlegear
		[3250799] = {{40461,40465,40463,40460,40462},2,4,213,1024,{{2,60135},{4,60137}},AL["Valorous %s"],799}, -- Valorous Dreamwalker Regalia
		[3250800] = {{40467,40470,40469,40466,40468},2,4,213,1024,{{2,60138},{4,60139}},AL["Valorous %s"],800}, -- Valorous Dreamwalker Garb
		[3250801] = {{40499,40502,40495,40496,40500},2,4,213,8,{{2,60162},{4,60163}},AL["Valorous %s"],801}, -- Valorous Bonescythe Battlegear
		[3250802] = {{40421,40424,40423,40420,40422},1,4,213,256,{{2,60170},{4,60172}},AL["Valorous %s"],802}, -- Valorous Plagueheart Garb
		[3250803] = {{40416,40419,40418,40415,40417},1,4,213,128,{{2,61062},{4,60146}},AL["Valorous %s"],803}, -- Valorous Frostfire Garb
		[3250804] = {{40447,40450,40449,40445,40448},1,4,213,16,{{2,60154},{4,60155}},AL["Valorous %s"],804}, -- Valorous Regalia of Faith
		[3250805] = {{40456,40459,40458,40454,40457},1,4,213,16,{{2,60156},{4,60157}},AL["Valorous %s"],805}, -- Valorous Garb of Faith
		[3250820] = {{46156,46152,46154,46155,46153},4,4,232,2,{{2,64878},{4,64879}},AL["Conqueror's %s"],820}, -- Conqueror's Aegis Battlegear
		[3250821] = {{46175,46177,46173,46174,46176},4,4,232,2,{{2,64881},{4,64882}},AL["Conqueror's %s"],821}, -- Conqueror's Aegis Plate
		[3250822] = {{46180,46182,46178,46179,46181},4,4,232,2,{{2,64890},{4,64895}},AL["Conqueror's %s"],822}, -- Conqueror's Aegis Regalia
		[3250823] = {{46212,46203,46205,46200,46208},3,4,232,64,{{2,64916},{4,64917}},AL["Conqueror's %s"],823}, -- Conqueror's Worldbreaker Battlegear
		[3250824] = {{46209,46211,46206,46207,46210},3,4,232,64,{{2,64925},{4,64928}},AL["Conqueror's %s"],824}, -- Conqueror's Worldbreaker Garb
		[3250825] = {{46201,46204,46198,46199,46202},3,4,232,64,{{2,64921},{4,64922}},AL["Conqueror's %s"],825}, -- Conqueror's Worldbreaker Regalia
		[3250826] = {{46125,46127,46123,46124,46126},2,4,232,8,{{2,64914},{4,64915}},AL["Conqueror's %s"],826}, -- Conqueror's Terrorblade Battlegear
		[3250827] = {{46161,46157,46159,46158,46160},2,4,232,1024,{{2,64752},{4,64754}},AL["Conqueror's %s"],827}, -- Conqueror's Nightsong Battlegear
		[3250828] = {{46191,46196,46194,46189,46192},2,4,232,1024,{{2,64818},{4,64824}},AL["Conqueror's %s"],828}, -- Conqueror's Nightsong Garb
		[3250829] = {{46184,46187,46186,46183,46185},2,4,232,1024,{{2,64756},{4,64760}},AL["Conqueror's %s"],829}, -- Conqueror's Nightsong Regalia
		[3250830] = {{46151,46149,46146,46148,46150},4,4,232,1,{{2,64938},{4,64939}},AL["Conqueror's %s"],830}, -- Conqueror's Siegebreaker Battlegear
		[3250831] = {{46166,46167,46162,46164,46169},4,4,232,1,{{2,64933},{4,64936}},AL["Conqueror's %s"],831}, -- Conqueror's Siegebreaker Plate
		[3250832] = {{46172,46165,46168,46163,46170},1,4,232,16,{{2,64906},{4,64908}},AL["Conqueror's %s"],832}, -- Conqueror's Sanctification Garb
		[3250833] = {{46197,46190,46193,46188,46195},1,4,232,16,{{2,64910},{4,64912}},AL["Conqueror's %s"],833}, -- Conqueror's Sanctification Regalia
		[3250834] = {{46115,46117,46111,46113,46116},4,4,232,32,{{2,64735},{4,64736}},AL["Conqueror's %s"],834}, -- Conqueror's Darkruned Battlegear
		[3250835] = {{46120,46122,46118,46119,46121},4,4,232,32,{{2,64744},{4,64745}},AL["Conqueror's %s"],835}, -- Conqueror's Darkruned Plate
		[3250836] = {{46129,46134,46130,46132,46133},1,4,232,128,{{2,64867},{4,64869}},AL["Conqueror's %s"],836}, -- Conqueror's Kirin Tor Garb
		[3250837] = {{46140,46136,46137,46135,46139},1,4,232,256,{{2,64931},{4,64932}},AL["Conqueror's %s"],837}, -- Conqueror's Deathbringer Garb
		[3250838] = {{46143,46145,46141,46142,46144},3,4,232,4,{{2,64854},{4,64860}},AL["Conqueror's %s"],838}, -- Conqueror's Scourgestalker Battlegear
		[3250843] = {{47754,47757,47756,47753,47755},1,4,245,128,{{2,67164},{4,67185}},AL["Triumphant %s"],843}, -- Triumphant Khadgar's Regalia
		[3250844] = {{47771,47768,47769,47772,47770},1,4,245,128,{{2,67164},{4,67185}},AL["Triumphant %s"],844}, -- Triumphant Sunstrider's Regalia
		[3250845] = {{47804,47807,47806,47803,47805},1,4,245,256,{{2,67230},{4,67231}},AL["Triumphant %s"],845}, -- Triumphant Gul'dan's Regalia
		[3250846] = {{47778,47781,47779,47782,47780},1,4,245,256,{{2,67230},{4,67231}},AL["Triumphant %s"],846}, -- Triumphant Kel'Thuzad's Regalia
		[3250847] = {{47984,47987,47986,47983,47985},1,4,245,16,{{2,67201},{4,67202}},AL["Triumphant %s"],847}, -- Triumphant Velen's Raiment
		[3250848] = {{48065,48062,48063,48066,48064},1,4,245,16,{{2,67201},{4,67202}},AL["Triumphant %s"],848}, -- Triumphant Zabra's Raiment
		[3250849] = {{48078,48081,48080,48077,48079},1,4,245,16,{{2,67193},{4,67198}},AL["Triumphant %s"],849}, -- Triumphant Velen's Regalia
		[3250850] = {{48095,48092,48093,48096,48094},1,4,245,16,{{2,67193},{4,67198}},AL["Triumphant %s"],850}, -- Triumphant Zabra's Regalia
		[3250851] = {{48134,48137,48136,48133,48135},2,4,245,1024,{{2,67127},{4,67128}},AL["Triumphant %s"],851}, -- Triumphant Malfurion's Garb
		[3250852] = {{48151,48148,48149,48152,48150},2,4,245,1024,{{2,67127},{4,67128}},AL["Triumphant %s"],852}, -- Triumphant Runetotem's Garb
		[3250853] = {{48164,48167,48166,48163,48165},2,4,245,1024,{{2,67125},{4,67126}},AL["Triumphant %s"],853}, -- Triumphant Malfurion's Regalia
		[3250854] = {{48181,48178,48179,48182,48180},2,4,245,1024,{{2,67125},{4,67126}},AL["Triumphant %s"],854}, -- Triumphant Runetotem's Regalia
		[3250855] = {{48211,48208,48209,48212,48210},2,4,245,1024,{{2,67121},{4,67123}},AL["Triumphant %s"],855}, -- Triumphant Malfurion's Battlegear
		[3250856] = {{48194,48197,48196,48193,48195},2,4,245,1024,{{2,67121},{4,67123}},AL["Triumphant %s"],856}, -- Triumphant Runetotem's Battlegear
		[3250857] = {{48225,48227,48223,48224,48226},2,4,245,8,{{2,67209},{4,67211}},AL["Triumphant %s"],857}, -- Triumphant VanCleef's Battlegear
		[3250858] = {{48240,48238,48242,48241,48239},2,4,245,8,{{2,67209},{4,67211}},AL["Triumphant %s"],858}, -- Triumphant Garona's Battlegear
		[3250859] = {{48257,48259,48255,48256,48258},3,4,245,4,{{2,67150},{4,67151}},AL["Triumphant %s"],859}, -- Triumphant Windrunner's Battlegear
		[3250860] = {{48272,48270,48274,48273,48271},3,4,245,4,{{2,67150},{4,67151}},AL["Triumphant %s"],860}, -- Triumphant Windrunner's Pursuit
		[3250861] = {{48287,48289,48285,48286,48288},3,4,245,64,{{2,67225},{4,67226}},AL["Triumphant %s"],861}, -- Triumphant Nobundo's Garb
		[3250862] = {{48302,48304,48300,48301,48303},3,4,245,64,{{2,67225},{4,67226}},AL["Triumphant %s"],862}, -- Triumphant Thrall's Garb
		[3250863] = {{48333,48331,48335,48334,48332},3,4,245,64,{{2,67227},{4,67228}},AL["Triumphant %s"],863}, -- Triumphant Thrall's Regalia
		[3250864] = {{48318,48320,48316,48317,48319},3,4,245,64,{{2,67227},{4,67228}},AL["Triumphant %s"],864}, -- Triumphant Nobundo's Regalia
		[3250865] = {{48348,48350,48346,48347,48349},3,4,245,64,{{2,67220},{4,67221}},AL["Triumphant %s"],865}, -- Triumphant Nobundo's Battlegear
		[3250866] = {{48363,48361,48365,48364,48362},3,4,245,64,{{2,67220},{4,67221}},AL["Triumphant %s"],866}, -- Triumphant Thrall's Battlegear
		[3250867] = {{48378,48380,48376,48377,48379},4,4,245,1,{{2,67234},{4,67268}},AL["Triumphant %s"],867}, -- Triumphant Wrynn's Battlegear
		[3250868] = {{48393,48395,48391,48392,48394},4,4,245,1,{{2,67234},{4,67268}},AL["Triumphant %s"],868}, -- Triumphant Hellscream's Battlegear
		[3250869] = {{48430,48454,48450,48452,48446},4,4,245,1,{{2,67269},{4,67273}},AL["Triumphant %s"],869}, -- Triumphant Wrynn's Plate
		[3250870] = {{48463,48465,48461,48462,48464},4,4,245,1,{{2,67269},{4,67273}},AL["Triumphant %s"],870}, -- Triumphant Hellscream's Plate
		[3250871] = {{48483,48485,48481,48482,48484},4,4,245,32,{{2,67115},{4,67118}},AL["Triumphant %s"],871}, -- Triumphant Thassarian's Battlegear
		[3250872] = {{48498,48496,48500,48499,48497},4,4,245,32,{{2,67115},{4,67118}},AL["Triumphant %s"],872}, -- Triumphant Koltira's Battlegear
		[3250873] = {{48540,48542,48538,48539,48541},4,4,245,32,{{2,67119},{4,67120}},AL["Triumphant %s"],873}, -- Triumphant Thassarian's Plate
		[3250874] = {{48555,48553,48557,48556,48554},4,4,245,32,{{2,67119},{4,67120}},AL["Triumphant %s"],874}, -- Triumphant Koltira's Plate
		[3250875] = {{48577,48579,48575,48576,48578},4,4,245,2,{{2,67190},{4,67191}},AL["Triumphant %s"],875}, -- Triumphant Turalyon's Garb
		[3250876] = {{48592,48590,48594,48593,48591},4,4,245,2,{{2,67190},{4,67191}},AL["Triumphant %s"],876}, -- Triumphant Liadrin's Garb
		[3250877] = {{48609,48611,48607,48608,48610},4,4,245,2,{{2,67188},{4,67189}},AL["Triumphant %s"],877}, -- Triumphant Turalyon's Battlegear
		[3250878] = {{48624,48622,48626,48625,48623},4,4,245,2,{{2,67188},{4,67189}},AL["Triumphant %s"],878}, -- Triumphant Liadrin's Battlegear
		[3250879] = {{48639,48637,48641,48640,48638},4,4,245,2,{{2,67186},{4,67187}},AL["Triumphant %s"],879}, -- Triumphant Turalyon's Plate
		[3250880] = {{48659,48661,48657,48658,48660},4,4,245,2,{{2,67186},{4,67187}},AL["Triumphant %s"],880}, -- Triumphant Liadrin's Plate
		[3250883] = {{51158,51155,51156,51159,51157},1,4,264,128,{{2,70752},{4,70748}},AL["Sanctified %s"],883}, -- Sanctified Bloodmage's Regalia
		[3250884] = {{51208,51205,51206,51209,51207},1,4,264,256,{{2,70839},{4,70841}},AL["Sanctified %s"],884}, -- Sanctified Dark Coven's Regalia
		[3250885] = {{51178,51175,51176,51179,51177},1,4,264,16,{{2,70770},{4,70798}},AL["Sanctified %s"],885}, -- Sanctified Crimson Acolyte's Raiment
		[3250886] = {{51184,51182,51180,51183,51181},1,4,264,16,{{2,70800},{4,70801}},AL["Sanctified %s"],886}, -- Sanctified Crimson Acolyte's Regalia
		[3250887] = {{51137,51135,51139,51138,51136},2,4,264,1024,{{2,70658},{4,70664}},AL["Sanctified %s"],887}, -- Sanctified Lasherweave Garb
		[3250888] = {{51149,51147,51145,51148,51146},2,4,264,1024,{{2,70718},{4,70723}},AL["Sanctified %s"],888}, -- Sanctified Lasherweave Regalia
		[3250889] = {{51143,51140,51141,51144,51142},2,4,264,1024,{{2,70724},{4,70726}},AL["Sanctified %s"],889}, -- Sanctified Lasherweave Battlegear
		[3250890] = {{51187,51185,51189,51188,51186},2,4,264,8,{{2,70805},{4,70803}},AL["Sanctified %s"],890}, -- Sanctified Shadowblade's Battlegear
		[3250891] = {{51153,51151,51150,51154,51152},3,4,264,4,{{2,70727},{4,70730}},AL["Sanctified %s"],891}, -- Sanctified Ahn'Kahar Blood Hunter's Battlegear
		[3250892] = {{51192,51194,51190,51191,51193},3,4,264,64,{{2,70807},{4,70808}},AL["Sanctified %s"],892}, -- Sanctified Frost Witch's Garb
		[3250893] = {{51202,51204,51200,51201,51203},3,4,264,64,{{2,70811},{4,70817}},AL["Sanctified %s"],893}, -- Sanctified Frost Witch's Regalia
		[3250894] = {{51197,51199,51195,51196,51198},3,4,264,64,{{2,70830},{4,70832}},AL["Sanctified %s"],894}, -- Sanctified Frost Witch's Battlegear
		[3250895] = {{51212,51210,51214,51213,51211},4,4,264,1,{{2,70854},{4,70847}},AL["Sanctified %s"],895}, -- Sanctified Ymirjar Lord's Battlegear
		[3250896] = {{51218,51215,51219,51217,51216},4,4,264,1,{{2,70843},{4,70844}},AL["Sanctified %s"],896}, -- Sanctified Ymirjar Lord's Plate
		[3250897] = {{51127,51125,51129,51128,51126},4,4,264,32,{{2,70655},{4,70656}},AL["Sanctified %s"],897}, -- Sanctified Scourgelord's Battlegear
		[3250898] = {{51133,51130,51134,51132,51131},4,4,264,32,{{2,70650},{4,70652}},AL["Sanctified %s"],898}, -- Sanctified Scourgelord's Plate
		[3250899] = {{51167,51166,51165,51169,51168},4,4,264,2,{{2,70755},{4,70756}},AL["Sanctified %s"],899}, -- Sanctified Lightsworn Garb
		[3250900] = {{51162,51160,51164,51163,51161},4,4,264,2,{{2,70765},{4,70762}},AL["Sanctified %s"],900}, -- Sanctified Lightsworn Battlegear
		[3250901] = {{51173,51170,51174,51172,51171},4,4,264,2,{{2,70758},{4,70761}},AL["Sanctified %s"],901}, -- Sanctified Lightsworn Plate
		[3251843] = {{47761,47758,47759,47762,47760},1,4,258,128,{{2,67164},{4,67185}},AL["Triumphant %s"],843}, -- Triumphant Khadgar's Regalia
		[3251844] = {{47764,47767,47766,47763,47765},1,4,258,128,{{2,67164},{4,67185}},AL["Triumphant %s"],844}, -- Triumphant Sunstrider's Regalia
		[3251845] = {{47796,47793,47794,47797,47795},1,4,258,256,{{2,67230},{4,67231}},AL["Triumphant %s"],845}, -- Triumphant Gul'dan's Regalia
		[3251846] = {{47789,47792,47791,47788,47790},1,4,258,256,{{2,67230},{4,67231}},AL["Triumphant %s"],846}, -- Triumphant Kel'Thuzad's Regalia
		[3251847] = {{48035,48029,48031,48037,48033},1,4,258,16,{{2,67201},{4,67202}},AL["Triumphant %s"],847}, -- Triumphant Velen's Raiment
		[3251848] = {{48058,48061,48060,48057,48059},1,4,258,16,{{2,67201},{4,67202}},AL["Triumphant %s"],848}, -- Triumphant Zabra's Raiment
		[3251849] = {{48085,48082,48083,48086,48084},1,4,258,16,{{2,67193},{4,67198}},AL["Triumphant %s"],849}, -- Triumphant Velen's Regalia
		[3251850] = {{48088,48091,48090,48087,48089},1,4,258,16,{{2,67193},{4,67198}},AL["Triumphant %s"],850}, -- Triumphant Zabra's Regalia
		[3251851] = {{48141,48138,48139,48142,48140},2,4,258,1024,{{2,67127},{4,67128}},AL["Triumphant %s"],851}, -- Triumphant Malfurion's Garb
		[3251852] = {{48144,48147,48146,48143,48145},2,4,258,1024,{{2,67127},{4,67128}},AL["Triumphant %s"],852}, -- Triumphant Runetotem's Garb
		[3251853] = {{48171,48168,48169,48172,48170},2,4,258,1024,{{2,67125},{4,67126}},AL["Triumphant %s"],853}, -- Triumphant Malfurion's Regalia
		[3251854] = {{48174,48177,48176,48173,48175},2,4,258,1024,{{2,67125},{4,67126}},AL["Triumphant %s"],854}, -- Triumphant Runetotem's Regalia
		[3251855] = {{48204,48207,48206,48203,48205},2,4,258,1024,{{2,67121},{4,67123}},AL["Triumphant %s"],855}, -- Triumphant Malfurion's Battlegear
		[3251856] = {{48201,48198,48199,48202,48200},2,4,258,1024,{{2,67121},{4,67123}},AL["Triumphant %s"],856}, -- Triumphant Runetotem's Battlegear
		[3251857] = {{48230,48228,48232,48231,48229},2,4,258,8,{{2,67209},{4,67211}},AL["Triumphant %s"],857}, -- Triumphant VanCleef's Battlegear
		[3251858] = {{48235,48237,48233,48234,48236},2,4,258,8,{{2,67209},{4,67211}},AL["Triumphant %s"],858}, -- Triumphant Garona's Battlegear
		[3251859] = {{48262,48260,48264,48263,48261},3,4,258,4,{{2,67150},{4,67151}},AL["Triumphant %s"],859}, -- Triumphant Windrunner's Battlegear
		[3251860] = {{48267,48269,48265,48266,48268},3,4,258,4,{{2,67150},{4,67151}},AL["Triumphant %s"],860}, -- Triumphant Windrunner's Pursuit
		[3251861] = {{48292,48290,48294,48293,48291},3,4,258,64,{{2,67225},{4,67226}},AL["Triumphant %s"],861}, -- Triumphant Nobundo's Garb
		[3251862] = {{48307,48309,48305,48306,48308},3,4,258,64,{{2,67225},{4,67226}},AL["Triumphant %s"],862}, -- Triumphant Thrall's Garb
		[3251863] = {{48328,48330,48326,48327,48329},3,4,258,64,{{2,67227},{4,67228}},AL["Triumphant %s"],863}, -- Triumphant Thrall's Regalia
		[3251864] = {{48323,48321,48325,48324,48322},3,4,258,64,{{2,67227},{4,67228}},AL["Triumphant %s"],864}, -- Triumphant Nobundo's Regalia
		[3251865] = {{48353,48351,48355,48354,48352},3,4,258,64,{{2,67220},{4,67221}},AL["Triumphant %s"],865}, -- Triumphant Nobundo's Battlegear
		[3251866] = {{48358,48360,48356,48357,48359},3,4,258,64,{{2,67220},{4,67221}},AL["Triumphant %s"],866}, -- Triumphant Thrall's Battlegear
		[3251867] = {{48383,48381,48385,48384,48382},4,4,258,1,{{2,67234},{4,67268}},AL["Triumphant %s"],867}, -- Triumphant Wrynn's Battlegear
		[3251868] = {{48398,48400,48396,48397,48399},4,4,258,1,{{2,67234},{4,67268}},AL["Triumphant %s"],868}, -- Triumphant Hellscream's Battlegear
		[3251869] = {{48433,48455,48451,48453,48447},4,4,258,1,{{2,67269},{4,67273}},AL["Triumphant %s"],869}, -- Triumphant Wrynn's Plate
		[3251870] = {{48468,48470,48466,48467,48469},4,4,258,1,{{2,67269},{4,67273}},AL["Triumphant %s"],870}, -- Triumphant Hellscream's Plate
		[3251871] = {{48488,48486,48490,48489,48487},4,4,258,32,{{2,67115},{4,67118}},AL["Triumphant %s"],871}, -- Triumphant Thassarian's Battlegear
		[3251872] = {{48493,48495,48491,48492,48494},4,4,258,32,{{2,67115},{4,67118}},AL["Triumphant %s"],872}, -- Triumphant Koltira's Battlegear
		[3251873] = {{48545,48543,48547,48546,48544},4,4,258,32,{{2,67119},{4,67120}},AL["Triumphant %s"],873}, -- Triumphant Thassarian's Plate
		[3251874] = {{48550,48552,48548,48549,48551},4,4,258,32,{{2,67119},{4,67120}},AL["Triumphant %s"],874}, -- Triumphant Koltira's Plate
		[3251875] = {{48582,48580,48584,48583,48581},4,4,258,2,{{2,67190},{4,67191}},AL["Triumphant %s"],875}, -- Triumphant Turalyon's Garb
		[3251876] = {{48587,48585,48589,48588,48586},4,4,258,2,{{2,67190},{4,67191}},AL["Triumphant %s"],876}, -- Triumphant Liadrin's Garb
		[3251877] = {{48614,48612,48616,48615,48613},4,4,258,2,{{2,67188},{4,67189}},AL["Triumphant %s"],877}, -- Triumphant Turalyon's Battlegear
		[3251878] = {{48619,48621,48617,48618,48620},4,4,258,2,{{2,67188},{4,67189}},AL["Triumphant %s"],878}, -- Triumphant Liadrin's Battlegear
		[3251879] = {{48644,48646,48642,48643,48645},4,4,258,2,{{2,67186},{4,67187}},AL["Triumphant %s"],879}, -- Triumphant Turalyon's Plate
		[3251880] = {{48649,48647,48651,48650,48648},4,4,258,2,{{2,67186},{4,67187}},AL["Triumphant %s"],880}, -- Triumphant Liadrin's Plate
		[3251883] = {{51281,51284,51283,51280,51282},1,4,277,128,{{2,70752},{4,70748}},AL["Heroic Sanctified %s"],883}, -- Heroic Sanctified Bloodmage's Regalia
		[3251884] = {{51231,51234,51233,51230,51232},1,4,277,256,{{2,70839},{4,70841}},AL["Heroic Sanctified %s"],884}, -- Heroic Sanctified Dark Coven's Regalia
		[3251885] = {{51261,51264,51263,51260,51262},1,4,277,16,{{2,70770},{4,70798}},AL["Heroic Sanctified %s"],885}, -- Heroic Sanctified Crimson Acolyte's Raiment
		[3251886] = {{51255,51257,51259,51256,51258},1,4,277,16,{{2,70800},{4,70801}},AL["Heroic Sanctified %s"],886}, -- Heroic Sanctified Crimson Acolyte's Regalia
		[3251887] = {{51302,51304,51300,51301,51303},2,4,277,1024,{{2,70658},{4,70664}},AL["Heroic Sanctified %s"],887}, -- Heroic Sanctified Lasherweave Garb
		[3251888] = {{51290,51292,51294,51291,51293},2,4,277,1024,{{2,70718},{4,70723}},AL["Heroic Sanctified %s"],888}, -- Heroic Sanctified Lasherweave Regalia
		[3251889] = {{51296,51299,51298,51295,51297},2,4,277,1024,{{2,70724},{4,70726}},AL["Heroic Sanctified %s"],889}, -- Heroic Sanctified Lasherweave Battlegear
		[3251890] = {{51252,51254,51250,51251,51253},2,4,277,8,{{2,70805},{4,70803}},AL["Heroic Sanctified %s"],890}, -- Heroic Sanctified Shadowblade's Battlegear
		[3251891] = {{51286,51288,51289,51285,51287},3,4,277,4,{{2,70727},{4,70730}},AL["Heroic Sanctified %s"],891}, -- Heroic Sanctified Ahn'Kahar Blood Hunter's Battlegear
		[3251892] = {{51247,51245,51249,51248,51246},3,4,277,64,{{2,70807},{4,70808}},AL["Heroic Sanctified %s"],892}, -- Heroic Sanctified Frost Witch's Garb
		[3251893] = {{51237,51235,51239,51238,51236},3,4,277,64,{{2,70811},{4,70817}},AL["Heroic Sanctified %s"],893}, -- Heroic Sanctified Frost Witch's Regalia
		[3251894] = {{51242,51240,51244,51243,51241},3,4,277,64,{{2,70830},{4,70832}},AL["Heroic Sanctified %s"],894}, -- Heroic Sanctified Frost Witch's Battlegear
		[3251895] = {{51227,51229,51225,51226,51228},4,4,277,1,{{2,70854},{4,70847}},AL["Heroic Sanctified %s"],895}, -- Heroic Sanctified Ymirjar Lord's Battlegear
		[3251896] = {{51221,51224,51220,51222,51223},4,4,277,1,{{2,70843},{4,70844}},AL["Heroic Sanctified %s"],896}, -- Heroic Sanctified Ymirjar Lord's Plate
		[3251897] = {{51312,51314,51310,51311,51313},4,4,277,32,{{2,70655},{4,70656}},AL["Heroic Sanctified %s"],897}, -- Heroic Sanctified Scourgelord's Battlegear
		[3251898] = {{51306,51309,51305,51307,51308},4,4,277,32,{{2,70650},{4,70652}},AL["Heroic Sanctified %s"],898}, -- Heroic Sanctified Scourgelord's Plate
		[3251899] = {{51272,51273,51274,51270,51271},4,4,277,2,{{2,70755},{4,70756}},AL["Heroic Sanctified %s"],899}, -- Heroic Sanctified Lightsworn Garb
		[3251900] = {{51277,51279,51275,51276,51278},4,4,277,2,{{2,70765},{4,70762}},AL["Heroic Sanctified %s"],900}, -- Heroic Sanctified Lightsworn Battlegear
		[3251901] = {{51266,51269,51265,51267,51268},4,4,277,2,{{2,70758},{4,70761}},AL["Heroic Sanctified %s"],901}, -- Heroic Sanctified Lightsworn Plate
	}
end

local ITEM_TO_SET, ITEM_TO_SET_DATA = AtlasLoot:GetGameVersionDataTable()
ITEM_TO_SET_DATA.CLASSIC = {
	-- [itemID] = setID
	[6473]=162,[7948]=221,[7949]=221,[7950]=221,[7951]=221,[7952]=221,[7953]=221,[10328]=163,[10329]=163,
	[10330]=163,[10331]=163,[10332]=163,[10333]=163,[10399]=161,[10400]=161,[10401]=161,[10402]=161,[10403]=161,
	[10410]=162,[10411]=162,[10412]=162,[10413]=162,[11726]=1,[11728]=1,[11729]=1,[11730]=1,[11731]=1,
	[12422]=321,[12424]=321,[12425]=321,[12426]=321,[12427]=321,[12428]=321,[12429]=321,[12939]=41,[12940]=41,
	[13183]=65,[13218]=65,[13388]=81,[13389]=81,[13390]=81,[13391]=81,[13392]=81,[14611]=123,[14612]=123,
	[14614]=123,[14615]=123,[14616]=123,[14620]=124,[14621]=124,[14622]=124,[14623]=124,[14624]=124,[14626]=122,
	[14629]=122,[14631]=122,[14632]=122,[14633]=122,[14636]=121,[14637]=121,[14638]=121,[14640]=121,[14641]=121,
	[15045]=490,[15046]=490,[15048]=491,[15049]=491,[15050]=489,[15051]=489,[15052]=489,[15053]=141,[15054]=141,
	[15055]=141,[15056]=142,[15057]=142,[15058]=142,[15062]=143,[15063]=143,[15066]=144,[15067]=144,[16369]=343,
	[16391]=343,[16392]=348,[16393]=381,[16396]=348,[16397]=381,[16401]=362,[16403]=362,[16405]=282,[16406]=282,
	[16409]=401,[16410]=401,[16413]=343,[16414]=343,[16415]=343,[16416]=343,[16417]=348,[16418]=348,[16419]=348,
	[16420]=348,[16421]=381,[16422]=381,[16423]=381,[16424]=381,[16425]=362,[16426]=362,[16427]=362,[16428]=362,
	[16429]=282,[16430]=282,[16431]=282,[16432]=282,[16433]=401,[16434]=401,[16435]=401,[16436]=401,[16437]=388,
	[16440]=388,[16441]=388,[16442]=388,[16443]=388,[16444]=388,[16446]=394,[16448]=397,[16449]=397,[16450]=397,
	[16451]=397,[16452]=397,[16453]=394,[16454]=394,[16455]=394,[16456]=394,[16457]=394,[16459]=397,[16462]=395,
	[16463]=395,[16465]=395,[16466]=395,[16467]=395,[16468]=395,[16471]=402,[16472]=402,[16473]=402,[16474]=402,
	[16475]=402,[16476]=402,[16477]=384,[16478]=384,[16479]=384,[16480]=384,[16483]=384,[16484]=384,[16485]=341,
	[16487]=341,[16489]=341,[16490]=341,[16491]=341,[16492]=341,[16494]=382,[16496]=382,[16498]=347,[16499]=347,
	[16501]=382,[16502]=382,[16503]=382,[16504]=382,[16505]=347,[16506]=347,[16507]=347,[16508]=347,[16509]=281,
	[16510]=281,[16513]=281,[16514]=281,[16515]=281,[16516]=281,[16518]=301,[16519]=301,[16521]=301,[16522]=301,
	[16523]=301,[16524]=301,[16525]=361,[16526]=361,[16527]=361,[16528]=361,[16530]=361,[16531]=361,[16533]=387,
	[16534]=387,[16535]=387,[16536]=387,[16539]=387,[16540]=387,[16541]=383,[16542]=383,[16543]=383,[16544]=383,
	[16545]=383,[16548]=383,[16549]=398,[16550]=398,[16551]=398,[16552]=398,[16554]=398,[16555]=398,[16558]=393,
	[16560]=393,[16561]=393,[16562]=393,[16563]=393,[16564]=393,[16565]=396,[16566]=396,[16567]=396,[16568]=396,
	[16569]=396,[16571]=396,[16573]=386,[16574]=386,[16577]=386,[16578]=386,[16579]=386,[16580]=386,[16666]=187,
	[16667]=187,[16668]=187,[16669]=187,[16670]=187,[16671]=187,[16672]=187,[16673]=187,[16674]=186,[16675]=186,
	[16676]=186,[16677]=186,[16678]=186,[16679]=186,[16680]=186,[16681]=186,[16682]=181,[16683]=181,[16684]=181,
	[16685]=181,[16686]=181,[16687]=181,[16688]=181,[16689]=181,[16690]=182,[16691]=182,[16692]=182,[16693]=182,
	[16694]=182,[16695]=182,[16696]=182,[16697]=182,[16698]=183,[16699]=183,[16700]=183,[16701]=183,[16702]=183,
	[16703]=183,[16704]=183,[16705]=183,[16706]=185,[16707]=184,[16708]=184,[16709]=184,[16710]=184,[16711]=184,
	[16712]=184,[16713]=184,[16714]=185,[16715]=185,[16716]=185,[16717]=185,[16718]=185,[16719]=185,[16720]=185,
	[16721]=184,[16722]=188,[16723]=188,[16724]=188,[16725]=188,[16726]=188,[16727]=188,[16728]=188,[16729]=188,
	[16730]=189,[16731]=189,[16732]=189,[16733]=189,[16734]=189,[16735]=189,[16736]=189,[16737]=189,[16795]=201,
	[16796]=201,[16797]=201,[16798]=201,[16799]=201,[16800]=201,[16801]=201,[16802]=201,[16803]=203,[16804]=203,
	[16805]=203,[16806]=203,[16807]=203,[16808]=203,[16809]=203,[16810]=203,[16811]=202,[16812]=202,[16813]=202,
	[16814]=202,[16815]=202,[16816]=202,[16817]=202,[16818]=210,[16819]=202,[16820]=204,[16821]=204,[16822]=204,
	[16823]=204,[16824]=204,[16825]=204,[16826]=204,[16827]=204,[16828]=205,[16829]=205,[16830]=205,[16831]=205,
	[16832]=213,[16833]=205,[16834]=205,[16835]=205,[16836]=205,[16837]=207,[16838]=207,[16839]=207,[16840]=207,
	[16841]=207,[16842]=207,[16843]=207,[16844]=207,[16845]=206,[16846]=206,[16847]=206,[16848]=206,[16849]=206,
	[16850]=206,[16851]=206,[16852]=206,[16853]=208,[16854]=208,[16855]=208,[16856]=208,[16857]=208,[16858]=208,
	[16859]=208,[16860]=208,[16861]=209,[16862]=209,[16863]=209,[16864]=209,[16865]=209,[16866]=209,[16867]=209,
	[16868]=209,[16897]=214,[16898]=214,[16899]=214,[16900]=214,[16901]=214,[16902]=214,[16903]=214,[16904]=214,
	[16905]=213,[16906]=213,[16907]=213,[16908]=213,[16909]=213,[16910]=213,[16911]=213,[16912]=210,[16913]=210,
	[16914]=210,[16915]=210,[16916]=210,[16917]=210,[16918]=210,[16919]=211,[16920]=211,[16921]=211,[16922]=211,
	[16923]=211,[16924]=211,[16925]=211,[16926]=211,[16927]=212,[16928]=212,[16929]=212,[16930]=212,[16931]=212,
	[16932]=212,[16933]=212,[16934]=212,[16935]=215,[16936]=215,[16937]=215,[16938]=215,[16939]=215,[16940]=215,
	[16941]=215,[16942]=215,[16943]=216,[16944]=216,[16945]=216,[16946]=216,[16947]=216,[16948]=216,[16949]=216,
	[16950]=216,[16951]=217,[16952]=217,[16953]=217,[16954]=217,[16955]=217,[16956]=217,[16957]=217,[16958]=217,
	[16959]=218,[16960]=218,[16961]=218,[16962]=218,[16963]=218,[16964]=218,[16965]=218,[16966]=218,[16984]=489,
	[17064]=241,[17082]=241,[17562]=346,[17564]=346,[17566]=346,[17567]=346,[17568]=346,[17569]=346,[17570]=345,
	[17571]=345,[17572]=345,[17573]=345,[17576]=345,[17577]=345,[17578]=392,[17579]=392,[17580]=392,[17581]=392,
	[17583]=392,[17584]=392,[17586]=391,[17588]=391,[17590]=391,[17591]=391,[17592]=391,[17593]=391,[17594]=344,
	[17596]=344,[17598]=344,[17599]=344,[17600]=344,[17601]=344,[17602]=389,[17603]=389,[17604]=389,[17605]=389,
	[17607]=389,[17608]=389,[17610]=342,[17611]=342,[17612]=342,[17613]=342,[17616]=342,[17617]=342,[17618]=390,
	[17620]=390,[17622]=390,[17623]=390,[17624]=390,[17625]=390,[18202]=261,[18203]=261,[18204]=261,[18205]=261,
	[19577]=474,[19588]=475,[19594]=480,[19601]=482,[19605]=481,[19609]=476,[19613]=479,[19617]=478,[19621]=477,
	[19682]=421,[19683]=421,[19684]=421,[19685]=441,[19686]=441,[19687]=441,[19688]=442,[19689]=442,[19690]=443,
	[19691]=443,[19692]=443,[19693]=444,[19694]=444,[19695]=444,[19822]=474,[19823]=474,[19824]=474,[19825]=475,
	[19826]=475,[19827]=475,[19828]=476,[19829]=476,[19830]=476,[19831]=477,[19832]=477,[19833]=477,[19834]=478,
	[19835]=478,[19836]=478,[19838]=479,[19839]=479,[19840]=479,[19841]=480,[19842]=480,[19843]=480,[19845]=482,
	[19846]=482,[19848]=481,[19849]=481,[19863]=465,[19865]=461,[19866]=461,[19873]=464,[19893]=462,[19896]=463,
	[19898]=466,[19905]=462,[19910]=463,[19912]=464,[19920]=465,[19925]=466,[19951]=474,[19952]=475,[19953]=477,
	[19954]=478,[19955]=479,[19956]=476,[19957]=481,[19958]=480,[19959]=482,[20033]=481,[20034]=482,[20041]=467,
	[20042]=468,[20043]=469,[20044]=470,[20045]=471,[20046]=472,[20047]=473,[20048]=467,[20049]=468,[20050]=469,
	[20051]=470,[20052]=471,[20053]=472,[20054]=473,[20055]=469,[20056]=470,[20057]=467,[20058]=468,[20059]=471,
	[20060]=472,[20061]=473,[20150]=483,[20154]=483,[20158]=483,[20159]=485,[20163]=485,[20167]=488,[20171]=488,
	[20175]=488,[20176]=485,[20186]=486,[20190]=486,[20194]=486,[20195]=484,[20199]=484,[20203]=484,[20204]=487,
	[20208]=487,[20212]=487,[20295]=491,[20296]=490,[20406]=492,[20407]=492,[20408]=492,[21278]=142,[21329]=496,
	[21330]=496,[21331]=496,[21332]=496,[21333]=496,[21334]=499,[21335]=499,[21336]=499,[21337]=499,[21338]=499,
	[21343]=503,[21344]=503,[21345]=503,[21346]=503,[21347]=503,[21348]=507,[21349]=507,[21350]=507,[21351]=507,
	[21352]=507,[21353]=493,[21354]=493,[21355]=493,[21356]=493,[21357]=493,[21359]=497,[21360]=497,[21361]=497,
	[21362]=497,[21364]=497,[21365]=509,[21366]=509,[21367]=509,[21368]=509,[21370]=509,[21372]=501,[21373]=501,
	[21374]=501,[21375]=501,[21376]=501,[21387]=505,[21388]=505,[21389]=505,[21390]=505,[21391]=505,[21392]=495,
	[21393]=495,[21394]=495,[21395]=506,[21396]=506,[21397]=506,[21398]=502,[21399]=502,[21400]=502,[21401]=510,
	[21402]=510,[21403]=510,[21404]=498,[21405]=498,[21406]=498,[21407]=494,[21408]=494,[21409]=494,[21410]=508,
	[21411]=508,[21412]=508,[21413]=504,[21414]=504,[21415]=504,[21416]=500,[21417]=500,[21418]=500,[21994]=511,
	[21995]=511,[21996]=511,[21997]=511,[21998]=511,[21999]=511,[22000]=511,[22001]=511,[22002]=512,[22003]=512,
	[22004]=512,[22005]=512,[22006]=512,[22007]=512,[22008]=512,[22009]=512,[22010]=515,[22011]=515,[22013]=515,
	[22015]=515,[22016]=515,[22017]=515,[22060]=515,[22061]=515,[22062]=517,[22063]=517,[22064]=517,[22065]=517,
	[22066]=517,[22067]=517,[22068]=517,[22069]=517,[22070]=518,[22071]=518,[22072]=518,[22073]=518,[22074]=518,
	[22075]=518,[22076]=518,[22077]=518,[22078]=514,[22079]=514,[22080]=514,[22081]=514,[22082]=514,[22083]=514,
	[22084]=514,[22085]=514,[22086]=516,[22087]=516,[22088]=516,[22089]=516,[22090]=516,[22091]=516,[22092]=516,
	[22093]=516,[22095]=519,[22096]=519,[22097]=519,[22098]=519,[22099]=519,[22100]=519,[22101]=519,[22102]=519,
	[22106]=513,[22107]=513,[22108]=513,[22109]=513,[22110]=513,[22111]=513,[22112]=513,[22113]=513,[22301]=520,
	[22302]=520,[22303]=520,[22304]=520,[22305]=520,[22306]=520,[22311]=520,[22313]=520,[22416]=523,[22417]=523,
	[22418]=523,[22419]=523,[22420]=523,[22421]=523,[22422]=523,[22423]=523,[22424]=528,[22425]=528,[22426]=528,
	[22427]=528,[22428]=528,[22429]=528,[22430]=528,[22431]=528,[22436]=530,[22437]=530,[22438]=530,[22439]=530,
	[22440]=530,[22441]=530,[22442]=530,[22443]=530,[22464]=527,[22465]=527,[22466]=527,[22467]=527,[22468]=527,
	[22469]=527,[22470]=527,[22471]=527,[22476]=524,[22477]=524,[22478]=524,[22479]=524,[22480]=524,[22481]=524,
	[22482]=524,[22483]=524,[22488]=521,[22489]=521,[22490]=521,[22491]=521,[22492]=521,[22493]=521,[22494]=521,
	[22495]=521,[22496]=526,[22497]=526,[22498]=526,[22499]=526,[22500]=526,[22501]=526,[22502]=526,[22503]=526,
	[22504]=529,[22505]=529,[22506]=529,[22507]=529,[22508]=529,[22509]=529,[22510]=529,[22511]=529,[22512]=525,
	[22513]=525,[22514]=525,[22515]=525,[22516]=525,[22517]=525,[22518]=525,[22519]=525,[22843]=543,[22852]=539,
	[22855]=541,[22856]=522,[22857]=538,[22858]=537,[22859]=540,[22860]=542,[22862]=543,[22863]=539,[22864]=522,
	[22865]=541,[22867]=538,[22868]=537,[22869]=540,[22870]=542,[22872]=537,[22873]=537,[22874]=543,[22875]=543,
	[22876]=538,[22877]=539,[22878]=539,[22879]=522,[22880]=522,[22881]=541,[22882]=540,[22883]=542,[22884]=541,
	[22885]=540,[22886]=542,[22887]=538,[23059]=523,[23060]=524,[23061]=525,[23062]=526,[23063]=529,[23064]=521,
	[23065]=527,[23066]=528,[23067]=530,[23078]=533,[23081]=534,[23082]=535,[23084]=536,[23085]=536,[23087]=533,
	[23088]=535,[23089]=534,[23090]=533,[23091]=536,[23092]=535,[23093]=534,[23243]=537,[23244]=537,[23251]=543,
	[23252]=543,[23253]=539,[23254]=539,[23255]=541,[23256]=541,[23257]=522,[23258]=522,[23259]=538,[23260]=538,
	[23261]=540,[23262]=540,[23263]=542,[23264]=542,[23272]=544,[23273]=544,[23274]=544,[23275]=544,[23276]=544,
	[23277]=544,[23278]=550,[23279]=550,[23280]=551,[23281]=551,[23282]=547,[23283]=547,[23284]=548,[23285]=548,
	[23286]=545,[23287]=545,[23288]=549,[23289]=549,[23290]=546,[23291]=546,[23292]=550,[23293]=550,[23294]=551,
	[23295]=551,[23296]=547,[23297]=547,[23298]=548,[23299]=548,[23300]=545,[23301]=545,[23302]=549,[23303]=549,
	[23304]=546,[23305]=546,[23306]=550,[23307]=550,[23308]=551,[23309]=551,[23310]=547,[23311]=547,[23312]=548,
	[23313]=548,[23314]=545,[23315]=545,[23316]=549,[23317]=549,[23318]=546,[23319]=546,
	[40826]=3003765,[40866]=3003765,[40789]=3003765,[40807]=3003765,[40847]=3003765,
	[40828]=3003766,[40869]=3003766,[40788]=3003766,[40808]=3003766,[40849]=3003766,
	[40933]=3003767,[40963]=3003767,[40907]=3003767,[40927]=3003767,[40939]=3003767,
	[40827]=3003768,[40868]=3003768,[40787]=3003768,[40809]=3003768,[40848]=3003768,
	[41019]=3003769,[41044]=3003769,[40993]=3003769,[41007]=3003769,[41033]=3003769,
	[41151]=3003770,[41211]=3003770,[41081]=3003770,[41137]=3003770,[41199]=3003770,
	[41013]=3003771,[41038]=3003771,[40992]=3003771,[41001]=3003771,[41027]=3003771,
	[41157]=3003772,[41217]=3003772,[41087]=3003772,[41143]=3003772,[41205]=3003772,
	[41321]=3003773,[41275]=3003773,[41310]=3003773,[41287]=3003773,[41298]=3003773,
	[41327]=3003774,[41281]=3003774,[41316]=3003774,[41293]=3003774,[41304]=3003774,
	[41678]=3003775,[41715]=3003775,[41661]=3003775,[41773]=3003775,[41667]=3003775,
	[41672]=3003776,[41683]=3003776,[41650]=3003776,[41767]=3003776,[41655]=3003776,
	[41854]=3003777,[41869]=3003777,[41859]=3003777,[41874]=3003777,[41864]=3003777,
	[41915]=3003778,[41934]=3003778,[41921]=3003778,[41940]=3003778,[41927]=3003778,
	[41946]=3003779,[41965]=3003779,[41953]=3003779,[41971]=3003779,[41959]=3003779,
	[41993]=3003780,[42011]=3003780,[41998]=3003780,[42017]=3003780,[42005]=3003780,
	[40829]=3004765,[40870]=3004765,[40790]=3004765,[40810]=3004765,[40850]=3004765,
	[40831]=3004766,[40872]=3004766,[40772]=3004766,[40812]=3004766,[40852]=3004766,
	[40934]=3004767,[40964]=3004767,[40910]=3004767,[40928]=3004767,[40940]=3004767,
	[40830]=3004768,[40863]=3004768,[40784]=3004768,[40806]=3004768,[40845]=3004768,
	[41020]=3004769,[41045]=3004769,[40995]=3004769,[41008]=3004769,[41034]=3004769,
	[41152]=3004770,[41212]=3004770,[41082]=3004770,[41138]=3004770,[41200]=3004770,
	[41014]=3004771,[41039]=3004771,[40994]=3004771,[41002]=3004771,[41028]=3004771,
	[41158]=3004772,[41218]=3004772,[41088]=3004772,[41144]=3004772,[41206]=3004772,
	[41322]=3004773,[41276]=3004773,[41311]=3004773,[41288]=3004773,[41299]=3004773,
	[41328]=3004774,[41282]=3004774,[41317]=3004774,[41294]=3004774,[41305]=3004774,
	[41679]=3004775,[41716]=3004775,[41662]=3004775,[41774]=3004775,[41668]=3004775,
	[41673]=3004776,[41684]=3004776,[41651]=3004776,[41768]=3004776,[41656]=3004776,
	[41855]=3004777,[41870]=3004777,[41860]=3004777,[41875]=3004777,[41865]=3004777,
	[41916]=3004778,[41935]=3004778,[41922]=3004778,[41941]=3004778,[41928]=3004778,
	[41947]=3004779,[41966]=3004779,[41954]=3004779,[41972]=3004779,[41960]=3004779,
	[41994]=3004780,[42012]=3004780,[41999]=3004780,[42018]=3004780,[42006]=3004780,
	[51543]=3005765,[51545]=3005765,[51541]=3005765,[51542]=3005765,[51544]=3005765,
	[51476]=3005766,[51479]=3005766,[51474]=3005766,[51475]=3005766,[51477]=3005766,
	[51470]=3005767,[51473]=3005767,[51468]=3005767,[51469]=3005767,[51471]=3005767,
	[51415]=3005768,[51418]=3005768,[51413]=3005768,[51414]=3005768,[51416]=3005768,
	[51511]=3005769,[51514]=3005769,[51509]=3005769,[51510]=3005769,[51512]=3005769,
	[51505]=3005770,[51508]=3005770,[51503]=3005770,[51504]=3005770,[51506]=3005770,
	[51499]=3005771,[51402]=3005771,[51497]=3005771,[51498]=3005771,[51500]=3005771,
	[51460]=3005772,[51463]=3005772,[51458]=3005772,[51459]=3005772,[51461]=3005772,
	[51421]=3005773,[51424]=3005773,[51419]=3005773,[51420]=3005773,[51422]=3005773,
	[51435]=3005774,[51438]=3005774,[51433]=3005774,[51434]=3005774,[51436]=3005774,
	[51427]=3005775,[51430]=3005775,[51425]=3005775,[51426]=3005775,[51428]=3005775,
	[51494]=3005776,[51491]=3005776,[51492]=3005776,[51493]=3005776,[51496]=3005776,
	[51484]=3005777,[51481]=3005777,[51482]=3005777,[51483]=3005777,[51485]=3005777,
	[51489]=3005778,[51486]=3005778,[51487]=3005778,[51488]=3005778,[51490]=3005778,
	[51465]=3005779,[51462]=3005779,[51463]=3005779,[51465]=3005779,[51466]=3005779,
	[51538]=3005780,[51540]=3005780,[51536]=3005780,[51537]=3005780,[51539]=3005780
}

if AtlasLoot:GameVersion_GE(AtlasLoot.BC_VERSION_NUM) then
    ITEM_TO_SET_DATA.BCC = {
		[21846]=552,[21847]=552,[21848]=552,[21849]=555,[21850]=555,[21851]=555,[21852]=555,[21853]=555,[21854]=555,
		[21855]=555,[21859]=556,[21860]=556,[21861]=556,[21862]=556,[21863]=557,[21864]=557,[21865]=557,[21866]=558,
		[21867]=558,[21868]=558,[21869]=553,[21870]=553,[21871]=553,[21873]=554,[21874]=554,[21875]=554,[23482]=560,
		[23484]=560,[23487]=560,[23488]=560,[23489]=560,[23490]=561,[23491]=561,[23493]=561,[23494]=561,[23506]=562,
		[23507]=562,[23508]=562,[23509]=563,[23510]=563,[23511]=563,[23512]=563,[23513]=564,[23514]=564,[23515]=564,
		[23516]=564,[23517]=569,[23518]=569,[23519]=569,[23520]=566,[23521]=566,[23522]=566,[23523]=565,[23524]=565,
		[23525]=565,[24249]=570,[24255]=570,[24261]=571,[24262]=559,[24263]=572,[24264]=571,[24266]=559,[24267]=572,
		[24544]=567,[24545]=567,[24546]=567,[24547]=567,[24549]=567,[24552]=568,[24553]=568,[24554]=568,[24555]=568,
		[24556]=568,[25654]=611,[25655]=611,[25656]=611,[25657]=611,[25659]=612,[25660]=612,[25661]=612,[25662]=612,
		[25668]=613,[25669]=613,[25670]=613,[25671]=613,[25673]=614,[25674]=614,[25675]=614,[25676]=614,[25685]=573,
		[25686]=573,[25687]=573,[25689]=574,[25690]=574,[25691]=574,[25692]=576,[25693]=576,[25694]=576,[25695]=575,
		[25696]=575,[25697]=575,[25830]=577,[25831]=577,[25832]=577,[25833]=577,[25834]=577,[25854]=579,[25855]=579,
		[25856]=579,[25857]=579,[25858]=579,[25997]=578,[25998]=578,[25999]=578,[26000]=578,[26001]=578,[27465]=658,
		[27468]=637,[27469]=580,[27470]=580,[27471]=580,[27472]=580,[27473]=580,[27474]=650,[27475]=653,[27497]=661,
		[27508]=647,[27509]=620,[27510]=630,[27528]=660,[27531]=659,[27535]=623,[27536]=662,[27537]=644,[27702]=582,
		[27703]=582,[27704]=582,[27705]=582,[27706]=582,[27707]=581,[27708]=581,[27709]=581,[27710]=581,[27711]=581,
		[27713]=660,[27737]=637,[27738]=647,[27739]=623,[27771]=661,[27775]=662,[27776]=620,[27778]=644,[27796]=658,
		[27797]=659,[27801]=650,[27802]=630,[27803]=653,[27837]=659,[27838]=647,[27839]=623,[27870]=661,[27873]=637,
		[27874]=650,[27875]=662,[27879]=583,[27880]=583,[27881]=583,[27882]=583,[27883]=583,[27907]=658,[27908]=620,
		[27909]=630,[27936]=660,[27948]=644,[27977]=653,[28126]=584,[28127]=584,[28128]=584,[28129]=584,[28130]=584,
		[28136]=585,[28137]=585,[28138]=585,[28139]=585,[28140]=585,[28189]=737,[28191]=658,[28192]=660,[28193]=658,
		[28202]=637,[28203]=623,[28204]=620,[28205]=653,[28224]=659,[28225]=661,[28228]=650,[28229]=647,[28230]=662,
		[28231]=630,[28232]=644,[28264]=659,[28275]=650,[28278]=647,[28285]=623,[28331]=586,[28332]=586,[28333]=586,
		[28334]=586,[28335]=586,[28348]=637,[28349]=630,[28350]=653,[28401]=660,[28403]=661,[28413]=662,[28414]=620,
		[28415]=644,[28613]=595,[28614]=595,[28615]=595,[28616]=595,[28617]=595,[28618]=601,[28619]=601,[28620]=601,
		[28622]=601,[28623]=601,[28624]=591,[28625]=591,[28626]=591,[28627]=591,[28628]=591,[28679]=589,[28680]=589,
		[28681]=589,[28683]=589,[28684]=605,[28685]=605,[28686]=605,[28687]=605,[28688]=605,[28689]=593,[28690]=593,
		[28691]=593,[28692]=593,[28693]=593,[28694]=603,[28695]=603,[28696]=603,[28697]=603,[28698]=603,[28699]=590,
		[28700]=590,[28701]=590,[28702]=590,[28703]=590,[28704]=597,[28705]=597,[28706]=597,[28707]=597,[28708]=597,
		[28709]=607,[28710]=607,[28711]=607,[28712]=607,[28713]=607,[28714]=599,[28715]=599,[28716]=599,[28717]=599,
		[28718]=599,[28719]=609,[28720]=609,[28721]=609,[28722]=609,[28723]=609,[28724]=589,[28805]=596,[28806]=596,
		[28807]=596,[28808]=596,[28809]=596,[28811]=602,[28812]=602,[28813]=602,[28814]=602,[28815]=602,[28817]=592,
		[28818]=592,[28819]=592,[28820]=592,[28821]=592,[28831]=587,[28832]=587,[28833]=587,[28834]=587,[28835]=587,
		[28836]=606,[28837]=606,[28838]=606,[28839]=606,[28840]=606,[28841]=594,[28842]=594,[28843]=594,[28844]=594,
		[28845]=594,[28846]=604,[28847]=604,[28848]=604,[28849]=604,[28850]=604,[28851]=588,[28852]=588,[28853]=588,
		[28854]=588,[28855]=588,[28856]=598,[28857]=598,[28858]=598,[28859]=598,[28860]=598,[28861]=608,[28862]=608,
		[28863]=608,[28864]=608,[28865]=608,[28866]=600,[28867]=600,[28868]=600,[28869]=600,[28870]=600,[28871]=610,
		[28872]=610,[28873]=610,[28874]=610,[28875]=610,[28963]=645,[28964]=645,[28966]=645,[28967]=645,[28968]=645,
		[29011]=654,[29012]=654,[29015]=654,[29016]=654,[29017]=654,[29019]=655,[29020]=655,[29021]=655,[29022]=655,
		[29023]=655,[29028]=631,[29029]=631,[29030]=631,[29031]=631,[29032]=631,[29033]=632,[29034]=632,[29035]=632,
		[29036]=632,[29037]=632,[29038]=633,[29039]=633,[29040]=633,[29042]=633,[29043]=633,[29044]=621,[29045]=621,
		[29046]=621,[29047]=621,[29048]=621,[29049]=663,[29050]=663,[29053]=663,[29054]=663,[29055]=663,[29056]=664,
		[29057]=664,[29058]=664,[29059]=664,[29060]=664,[29061]=624,[29062]=624,[29063]=624,[29064]=624,[29065]=624,
		[29066]=625,[29067]=625,[29068]=625,[29069]=625,[29070]=625,[29071]=626,[29072]=626,[29073]=626,[29074]=626,
		[29075]=626,[29076]=648,[29077]=648,[29078]=648,[29079]=648,[29080]=648,[29081]=651,[29082]=651,[29083]=651,
		[29084]=651,[29085]=651,[29086]=638,[29087]=638,[29088]=638,[29089]=638,[29090]=638,[29091]=639,[29092]=639,
		[29093]=639,[29094]=639,[29095]=639,[29096]=640,[29097]=640,[29098]=640,[29099]=640,[29100]=640,[29515]=616,
		[29516]=616,[29517]=616,[29519]=617,[29520]=617,[29521]=617,[29522]=618,[29523]=618,[29524]=618,[29525]=619,
		[29526]=619,[29527]=619,[29594]=718,[29595]=718,[29596]=718,[29597]=718,[29598]=718,[29599]=718,[29600]=697,
		[29601]=697,[29602]=697,[29603]=697,[29604]=697,[29605]=697,[29606]=717,[29607]=717,[29608]=717,[29609]=717,
		[29610]=717,[29611]=717,[29612]=698,[29613]=698,[29614]=698,[29615]=698,[29616]=698,[29617]=698,[30113]=656,
		[30114]=656,[30115]=656,[30116]=656,[30117]=656,[30118]=657,[30119]=657,[30120]=657,[30121]=657,[30122]=657,
		[30123]=628,[30124]=628,[30125]=628,[30126]=628,[30127]=628,[30129]=629,[30130]=629,[30131]=629,[30132]=629,
		[30133]=629,[30134]=627,[30135]=627,[30136]=627,[30137]=627,[30138]=627,[30139]=652,[30140]=652,[30141]=652,
		[30142]=652,[30143]=652,[30144]=622,[30145]=622,[30146]=622,[30148]=622,[30149]=622,[30150]=665,[30151]=665,
		[30152]=665,[30153]=665,[30154]=665,[30159]=666,[30160]=666,[30161]=666,[30162]=666,[30163]=666,[30164]=634,
		[30165]=634,[30166]=634,[30167]=634,[30168]=634,[30169]=635,[30170]=635,[30171]=635,[30172]=635,[30173]=635,
		[30185]=636,[30186]=615,[30187]=615,[30188]=615,[30189]=636,[30190]=636,[30192]=636,[30194]=636,[30196]=649,
		[30200]=615,[30201]=615,[30205]=649,[30206]=649,[30207]=649,[30210]=649,[30211]=646,[30212]=646,[30213]=646,
		[30214]=646,[30215]=646,[30216]=642,[30217]=642,[30219]=642,[30220]=642,[30221]=642,[30222]=641,[30223]=641,
		[30228]=641,[30229]=641,[30230]=641,[30231]=643,[30232]=643,[30233]=643,[30234]=643,[30235]=643,[30486]=701,
		[30487]=701,[30488]=701,[30489]=701,[30490]=701,[30969]=672,[30970]=673,[30972]=672,[30974]=673,[30975]=672,
		[30976]=673,[30977]=672,[30978]=673,[30979]=672,[30980]=673,[30982]=680,[30983]=681,[30985]=679,[30987]=679,
		[30988]=681,[30989]=680,[30990]=680,[30991]=679,[30992]=681,[30993]=680,[30994]=681,[30995]=679,[30996]=681,
		[30997]=680,[30998]=679,[31001]=669,[31003]=669,[31004]=669,[31005]=669,[31006]=669,[31007]=683,[31008]=684,
		[31011]=682,[31012]=683,[31014]=684,[31015]=682,[31016]=683,[31017]=684,[31018]=682,[31019]=683,[31020]=684,
		[31021]=682,[31022]=683,[31023]=684,[31024]=682,[31026]=668,[31027]=668,[31028]=668,[31029]=668,[31030]=668,
		[31032]=678,[31034]=676,[31035]=677,[31037]=678,[31039]=676,[31040]=677,[31041]=678,[31042]=676,[31043]=677,
		[31044]=676,[31045]=678,[31046]=677,[31047]=678,[31048]=676,[31049]=677,[31050]=670,[31051]=670,[31052]=670,
		[31053]=670,[31054]=670,[31055]=671,[31056]=671,[31057]=671,[31058]=671,[31059]=671,[31060]=675,[31061]=674,
		[31063]=675,[31064]=674,[31065]=674,[31066]=675,[31067]=674,[31068]=675,[31069]=675,[31070]=674,[31338]=667,
		[31339]=667,[31375]=685,[31376]=685,[31377]=685,[31378]=685,[31379]=685,[31396]=686,[31397]=686,[31400]=686,
		[31406]=686,[31407]=686,[31409]=687,[31410]=687,[31411]=687,[31412]=687,[31413]=687,[31584]=689,[31585]=689,
		[31586]=689,[31587]=689,[31588]=689,[31589]=688,[31590]=688,[31591]=688,[31592]=688,[31593]=688,[31613]=690,
		[31614]=690,[31616]=690,[31618]=690,[31619]=690,[31620]=691,[31621]=692,[31622]=691,[31623]=691,[31624]=691,
		[31625]=691,[31626]=692,[31627]=692,[31628]=692,[31629]=692,[31630]=693,[31631]=693,[31632]=693,[31633]=693,
		[31634]=693,[31635]=694,[31636]=694,[31637]=694,[31638]=694,[31639]=694,[31640]=695,[31641]=695,[31642]=695,
		[31643]=695,[31644]=695,[31646]=696,[31647]=696,[31648]=696,[31649]=696,[31650]=696,[31960]=706,[31961]=706,
		[31962]=706,[31963]=706,[31964]=706,[31967]=711,[31968]=711,[31969]=711,[31971]=711,[31972]=711,[31973]=702,
		[31974]=702,[31975]=702,[31976]=702,[31977]=702,[31979]=704,[31980]=704,[31981]=704,[31982]=704,[31983]=704,
		[31987]=709,[31988]=709,[31989]=709,[31990]=709,[31991]=709,[31992]=700,[31993]=700,[31995]=700,[31996]=700,
		[31997]=700,[31998]=713,[31999]=713,[32000]=713,[32001]=713,[32002]=713,[32004]=703,[32005]=703,[32006]=703,
		[32007]=703,[32008]=703,[32009]=712,[32010]=712,[32011]=712,[32012]=712,[32013]=712,[32015]=705,[32016]=705,
		[32017]=705,[32018]=705,[32019]=705,[32020]=708,[32021]=708,[32022]=708,[32023]=708,[32024]=708,[32029]=715,
		[32030]=715,[32031]=715,[32032]=715,[32033]=715,[32034]=707,[32035]=707,[32036]=707,[32037]=707,[32038]=707,
		[32039]=714,[32040]=714,[32041]=714,[32042]=714,[32043]=714,[32047]=710,[32048]=710,[32049]=710,[32050]=710,
		[32051]=710,[32056]=716,[32057]=716,[32058]=716,[32059]=716,[32060]=716,[32837]=699,[32838]=699,[32945]=719,
		[32946]=719,[33173]=566,[33664]=723,[33665]=723,[33666]=723,[33667]=723,[33668]=723,[33671]=721,[33672]=721,
		[33673]=721,[33674]=721,[33675]=721,[33676]=734,[33677]=734,[33678]=734,[33679]=734,[33680]=734,[33682]=735,
		[33683]=735,[33684]=735,[33685]=735,[33686]=735,[33690]=720,[33691]=720,[33692]=720,[33693]=720,[33694]=720,
		[33695]=727,[33696]=727,[33697]=727,[33698]=727,[33699]=727,[33700]=730,[33701]=730,[33702]=730,[33703]=730,
		[33704]=730,[33706]=732,[33707]=732,[33708]=732,[33709]=732,[33710]=732,[33711]=733,[33712]=733,[33713]=733,
		[33714]=733,[33715]=733,[33717]=728,[33718]=728,[33719]=728,[33720]=728,[33721]=728,[33722]=725,[33723]=725,
		[33724]=725,[33725]=725,[33726]=725,[33728]=736,[33729]=736,[33730]=736,[33731]=736,[33732]=736,[33738]=731,
		[33739]=731,[33740]=731,[33741]=731,[33742]=731,[33744]=729,[33745]=729,[33746]=729,[33747]=729,[33748]=729,
		[33749]=726,[33750]=726,[33751]=726,[33752]=726,[33753]=726,[33757]=724,[33758]=724,[33759]=724,[33760]=724,
		[33761]=724,[33767]=722,[33768]=722,[33769]=722,[33770]=722,[33771]=722,[34431]=680,[34432]=681,[34433]=679,
		[34434]=674,[34435]=675,[34436]=670,[34437]=684,[34438]=683,[34439]=682,[34441]=672,[34442]=673,[34443]=669,
		[34444]=676,[34445]=678,[34446]=677,[34447]=671,[34448]=668,[34485]=680,[34487]=681,[34488]=679,[34527]=675,
		[34528]=674,[34541]=670,[34542]=684,[34543]=683,[34545]=682,[34546]=672,[34547]=673,[34549]=669,[34554]=678,
		[34555]=677,[34556]=676,[34557]=671,[34558]=668,[34559]=681,[34560]=679,[34561]=680,[34562]=675,[34563]=674,
		[34564]=670,[34565]=683,[34566]=684,[34567]=682,[34568]=673,[34569]=672,[34570]=669,[34571]=678,[34572]=677,
		[34573]=676,[34574]=671,[34575]=668,[34703]=737,[34990]=2000586,[34991]=2000586,[34992]=2000586,[34993]=2000586,[34994]=2000586,
		[34998]=2000584,[34999]=2000584,[35000]=2000584,[35001]=2000584,[35002]=2000584,[35003]=2000568,[35004]=2000568,[35005]=2000568,[35006]=2000568,
		[35007]=2000568,[35009]=2000615,[35010]=2000615,[35011]=2000615,[35012]=2000615,[35013]=2000615,[35022]=2000685,[35023]=2000685,[35024]=2000685,
		[35025]=2000685,[35026]=2000685,[35027]=2000582,[35028]=2000582,[35029]=2000582,[35030]=2000582,[35031]=2000582,[35032]=2000577,[35033]=2000577,
		[35034]=2000577,[35035]=2000577,[35036]=2000577,[35042]=2000578,[35043]=2000578,[35044]=2000578,[35045]=2000578,[35046]=2000578,[35048]=2000580,
		[35049]=2000580,[35050]=2000580,[35051]=2000580,[35052]=2000580,[35053]=2000687,[35054]=2000687,[35055]=2000687,[35056]=2000687,[35057]=2000687,
		[35059]=2000690,[35060]=2000690,[35061]=2000690,[35062]=2000690,[35063]=2000690,[35066]=2000567,[35067]=2000567,[35068]=2000567,[35069]=2000567,
		[35070]=2000567,[35077]=2000686,[35078]=2000686,[35079]=2000686,[35080]=2000686,[35081]=2000686,[35083]=2000581,[35084]=2000581,[35085]=2000581,
		[35086]=2000581,[35087]=2000581,[35088]=2000583,[35089]=2000583,[35090]=2000583,[35091]=2000583,[35092]=2000583,[35096]=2000579,[35097]=2000579,
		[35098]=2000579,[35099]=2000579,[35100]=2000579,[35111]=2000585,[35112]=2000585,[35113]=2000585,[35114]=2000585,[35115]=2000585,[35328]=738,
		[35329]=738,[35330]=738,[35331]=738,[35332]=738,[35333]=739,[35334]=739,[35335]=739,[35336]=739,[35337]=739,
		[35338]=740,[35339]=740,[35340]=740,[35341]=740,[35342]=740,[35343]=741,[35344]=741,[35345]=741,[35346]=741,
		[35347]=741,[35356]=742,[35357]=742,[35358]=742,[35359]=742,[35360]=742,[35361]=744,[35362]=744,[35363]=744,
		[35364]=744,[35365]=744,[35366]=745,[35367]=745,[35368]=745,[35369]=745,[35370]=745,[35371]=743,[35372]=743,
		[35373]=743,[35374]=743,[35375]=743,[35376]=749,[35377]=749,[35378]=749,[35379]=749,[35380]=749,[35381]=748,
		[35382]=748,[35383]=748,[35384]=748,[35385]=748,[35386]=746,[35387]=746,[35388]=746,[35389]=746,[35390]=746,
		[35391]=747,[35392]=747,[35393]=747,[35394]=747,[35395]=747,[35402]=751,[35403]=751,[35404]=751,[35405]=751,
		[35406]=751,[35407]=750,[35408]=750,[35409]=750,[35410]=750,[35411]=750,[35412]=752,[35413]=752,[35414]=752,
		[35415]=752,[35416]=752,
    }
end

if AtlasLoot:GameVersion_GE(AtlasLoot.WRATH_VERSION_NUM) then
    ITEM_TO_SET_DATA.WRATH = {
		[6833]=812,[6835]=812,[21524]=761,[21525]=761,[23324]=785,[33862]=762,[33863]=762,[33864]=762,[33868]=762,
		[33966]=762,[33967]=762,[33968]=762,[33969]=762,[34085]=761,[34086]=761,[34087]=761,[34683]=785,[34685]=785,
		[37758]=759,[37821]=759,[38400]=754,[38401]=754,[38402]=754,[38403]=754,[38404]=754,[38405]=754,[38406]=757,
		[38407]=757,[38408]=757,[38409]=757,[38410]=757,[38411]=757,[38412]=756,[38413]=756,[38414]=756,[38415]=756,
		[38416]=756,[38417]=755,[38418]=755,[38419]=755,[38420]=755,[38421]=755,[38422]=755,[38424]=756,[38433]=754,
		[38434]=757,[38435]=755,[38436]=756,[38437]=754,[38438]=757,[38439]=755,[38440]=756,[39491]=3100803,[39492]=3100803,
		[39493]=3100803,[39494]=3100803,[39495]=3100803,[39496]=3100802,[39497]=3100802,[39498]=3100802,[39499]=3100802,[39500]=3100802,[39514]=3100804,
		[39515]=3100804,[39517]=3100804,[39518]=3100804,[39519]=3100804,[39521]=3100805,[39523]=3100805,[39528]=3100805,[39529]=3100805,[39530]=3100805,
		[39531]=3100799,[39538]=3100799,[39539]=3100799,[39542]=3100799,[39543]=3100799,[39544]=3100800,[39545]=3100800,[39546]=3100800,[39547]=3100800,
		[39548]=3100800,[39553]=3100798,[39554]=3100798,[39555]=3100798,[39556]=3100798,[39557]=3100798,[39558]=3100801,[39560]=3100801,[39561]=3100801,
		[39564]=3100801,[39565]=3100801,[39578]=3100794,[39579]=3100794,[39580]=3100794,[39581]=3100794,[39582]=3100794,[39583]=3100797,[39588]=3100797,
		[39589]=3100797,[39590]=3100797,[39591]=3100797,[39592]=3100796,[39593]=3100796,[39594]=3100796,[39595]=3100796,[39596]=3100796,[39597]=3100795,
		[39601]=3100795,[39602]=3100795,[39603]=3100795,[39604]=3100795,[39605]=3100788,[39606]=3100788,[39607]=3100788,[39608]=3100788,[39609]=3100788,
		[39610]=3100787,[39611]=3100787,[39612]=3100787,[39613]=3100787,[39617]=3100792,[39618]=3100792,[39619]=3100792,[39620]=3100792,[39621]=3100792,
		[39622]=3100787,[39623]=3100793,[39624]=3100793,[39625]=3100793,[39626]=3100793,[39627]=3100793,[39628]=3100790,[39629]=3100790,[39630]=3100790,
		[39631]=3100790,[39632]=3100790,[39633]=3100789,[39634]=3100789,[39635]=3100789,[39636]=3100789,[39637]=3100789,[39638]=3100791,[39639]=3100791,
		[39640]=3100791,[39641]=3100791,[39642]=3100791,[40415]=3250803,[40416]=3250803,[40417]=3250803,[40418]=3250803,[40419]=3250803,[40420]=3250802,
		[40421]=3250802,[40422]=3250802,[40423]=3250802,[40424]=3250802,[40440]=760,[40441]=760,[40442]=760,[40443]=760,[40444]=760,
		[40445]=3250804,[40447]=3250804,[40448]=3250804,[40449]=3250804,[40450]=3250804,[40454]=3250805,[40456]=3250805,[40457]=3250805,[40458]=3250805,
		[40459]=3250805,[40460]=3250799,[40461]=3250799,[40462]=3250799,[40463]=3250799,[40465]=3250799,[40466]=3250800,[40467]=3250800,[40468]=3250800,
		[40469]=3250800,[40470]=3250800,[40471]=3250798,[40472]=3250798,[40473]=3250798,[40493]=3250798,[40494]=3250798,[40495]=3250801,[40496]=3250801,
		[40499]=3250801,[40500]=3250801,[40502]=3250801,[40503]=3250794,[40504]=3250794,[40505]=3250794,[40506]=3250794,[40507]=3250794,[40508]=3250797,
		[40509]=3250797,[40510]=3250797,[40512]=3250797,[40513]=3250797,[40514]=3250796,[40515]=3250796,[40516]=3250796,[40517]=3250796,[40518]=3250796,
		[40520]=3250795,[40521]=3250795,[40522]=3250795,[40523]=3250795,[40524]=3250795,[40525]=3250788,[40527]=3250788,[40528]=3250788,[40529]=3250788,
		[40530]=3250788,[40544]=3250787,[40545]=3250787,[40546]=3250787,[40547]=3250787,[40548]=3250787,[40550]=3250792,[40552]=3250792,[40554]=3250792,
		[40556]=3250792,[40557]=3250792,[40559]=3250793,[40563]=3250793,[40565]=3250793,[40567]=3250793,[40568]=3250793,[40569]=3250790,[40570]=3250790,
		[40571]=3250790,[40572]=3250790,[40573]=3250790,[40574]=3250789,[40575]=3250789,[40576]=3250789,[40577]=3250789,[40578]=3250789,[40579]=3250791,
		[40580]=3250791,[40581]=3250791,[40583]=3250791,[40584]=3250791,[40778]=3000765,[40779]=3000768,[40780]=3000766,[40781]=3001768,[40782]=3001766,
		[40783]=3001765,[40784]=3002768,[40785]=3002766,[40786]=3002765,[40797]=3000765,[40798]=3000766,[40799]=3000768,[40801]=3001765,[40802]=3001766,
		[40803]=3001768,[40804]=3002765,[40805]=3002766,[40806]=3002768,[40816]=3000765,[40817]=3000768,[40818]=3000766,[40819]=3001765,[40820]=3001768,
		[40821]=3001766,[40823]=3002765,[40824]=3002768,[40825]=3002766,[40836]=3000765,[40837]=3000768,[40838]=3000766,[40840]=3001765,[40841]=3001768,
		[40842]=3001766,[40844]=3002765,[40845]=3002768,[40846]=3002766,[40856]=3000765,[40857]=3000768,[40858]=3000766,[40859]=3001765,[40860]=3001768,
		[40861]=3001766,[40862]=3002765,[40863]=3002768,[40864]=3002766,[40898]=3000767,[40904]=3001767,[40905]=3002767,[40918]=3000767,[40925]=3001767,
		[40926]=3002767,[40930]=3000767,[40931]=3001767,[40932]=3002767,[40936]=3000767,[40937]=3001767,[40938]=3002767,[40960]=3000767,[40961]=3001767,
		[40962]=3002767,[40986]=3000771,[40987]=3000769,[40988]=3001771,[40989]=3001769,[40990]=3002771,[40991]=3002769,[40998]=3000771,[40999]=3001771,
		[41000]=3002771,[41004]=3000769,[41005]=3001769,[41006]=3002769,[41010]=3000771,[41011]=3001771,[41012]=3002771,[41016]=3000769,[41017]=3001769,
		[41018]=3002769,[41023]=3000771,[41024]=3000771,[41025]=3001771,[41026]=3002771,[41030]=3000769,[41031]=3001769,[41032]=3002769,[41036]=3001771,
		[41037]=3002771,[41041]=3000769,[41042]=3001769,[41043]=3002769,[41078]=3000770,[41079]=3001770,[41080]=3002770,[41084]=3000772,[41085]=3001772,
		[41086]=3002772,[41134]=3000770,[41135]=3001770,[41136]=3002770,[41140]=3000772,[41141]=3001772,[41142]=3002772,[41148]=3000770,[41149]=3001770,
		[41150]=3002770,[41154]=3000772,[41155]=3001772,[41156]=3002772,[41160]=3000770,[41162]=3001770,[41198]=3002770,[41202]=3000772,[41203]=3001772,
		[41204]=3002772,[41208]=3000770,[41209]=3001770,[41210]=3002770,[41214]=3000772,[41215]=3001772,[41216]=3002772,[41268]=3000773,[41269]=3000773,
		[41270]=3000773,[41271]=3000773,[41272]=3000773,[41273]=3001773,[41274]=3002773,[41278]=3000774,[41279]=3001774,[41280]=3002774,[41284]=3001773,
		[41286]=3002773,[41290]=3000774,[41291]=3001774,[41292]=3002774,[41296]=3001773,[41297]=3002773,[41301]=3000774,[41302]=3001774,[41303]=3002774,
		[41308]=3001773,[41309]=3002773,[41313]=3000774,[41314]=3001774,[41315]=3002774,[41319]=3001773,[41320]=3002773,[41324]=3000774,[41325]=3001774,
		[41326]=3002774,[41347]=816,[41348]=816,[41349]=816,[41350]=816,[41351]=816,[41352]=816,[41353]=816,[41354]=816,
		[41512]=763,[41513]=763,[41515]=763,[41516]=819,[41519]=763,[41520]=763,[41521]=763,[41522]=763,[41543]=764,
		[41544]=764,[41545]=764,[41546]=764,[41548]=764,[41549]=764,[41550]=764,[41551]=764,[41643]=3000776,[41644]=3000776,
		[41645]=3000776,[41646]=3000776,[41647]=3000776,[41648]=3001776,[41649]=3002776,[41653]=3001776,[41654]=3002776,[41658]=3000775,[41659]=3001775,
		[41660]=3002775,[41664]=3000775,[41665]=3001775,[41666]=3002775,[41670]=3001776,[41671]=3002776,[41675]=3000775,[41676]=3001775,[41677]=3002775,
		[41681]=3001776,[41682]=3002776,[41712]=3000775,[41713]=3001775,[41714]=3002775,[41765]=3001776,[41766]=3002776,[41770]=3000775,[41771]=3001775,
		[41772]=3002775,[41847]=3000777,[41848]=3000777,[41849]=3000777,[41850]=3000777,[41851]=3000777,[41852]=3001777,[41853]=3002777,[41857]=3001777,
		[41858]=3002777,[41862]=3001777,[41863]=3002777,[41867]=3001777,[41868]=3002777,[41872]=3001777,[41873]=3002777,[41912]=3000778,[41913]=3001778,
		[41914]=3002778,[41918]=3000778,[41919]=3001778,[41920]=3002778,[41924]=3000778,[41925]=3001778,[41926]=3002778,[41930]=3000778,[41931]=3001778,
		[41933]=3002778,[41937]=3000778,[41938]=3001778,[41939]=3002778,[41943]=3000779,[41944]=3001779,[41945]=3002779,[41949]=3000779,[41950]=3001779,
		[41951]=3002779,[41956]=3000779,[41957]=3001779,[41958]=3002779,[41962]=3000779,[41963]=3001779,[41964]=3002779,[41968]=3000779,[41969]=3001779,
		[41970]=3002779,[41990]=3000780,[41991]=3001780,[41992]=3002780,[41996]=3000780,[41997]=3002780,[42001]=3001780,[42002]=3000780,[42003]=3001780,
		[42004]=3002780,[42008]=3000780,[42009]=3001780,[42010]=3002780,[42014]=3000780,[42015]=3001780,[42016]=3002780,[42625]=765,[42626]=765,
		[42627]=765,[42628]=765,[42629]=765,[42630]=766,[42631]=766,[42632]=766,[42633]=766,[42634]=766,[42635]=767,
		[42636]=767,[42637]=767,[42638]=767,[42639]=767,[42654]=768,[42655]=768,[42656]=768,[42657]=768,[42658]=768,
		[42659]=769,[42660]=769,[42661]=769,[42662]=769,[42663]=769,[42664]=771,[42665]=771,[42666]=771,[42667]=771,
		[42668]=771,[42669]=770,[42670]=770,[42671]=770,[42672]=770,[42673]=770,[42674]=772,[42675]=772,[42676]=772,
		[42677]=772,[42678]=772,[42680]=773,[42681]=773,[42682]=773,[42683]=773,[42684]=773,[42685]=774,[42686]=774,
		[42687]=774,[42688]=774,[42689]=774,[42690]=775,[42691]=775,[42692]=775,[42693]=775,[42694]=775,[42695]=776,
		[42696]=776,[42697]=776,[42698]=776,[42699]=776,[42703]=777,[42704]=777,[42705]=777,[42706]=777,[42707]=777,
		[42708]=778,[42709]=778,[42710]=778,[42711]=778,[42712]=778,[42713]=779,[42714]=779,[42715]=779,[42716]=779,
		[42717]=779,[42718]=780,[42719]=780,[42720]=780,[42721]=780,[42722]=780,[42723]=814,[42724]=814,[42725]=814,
		[42726]=814,[42727]=814,[42728]=814,[42729]=814,[42730]=814,[43068]=784,[43069]=784,[43070]=784,[43071]=784,
		[43072]=781,[43073]=781,[43074]=781,[43075]=781,[43076]=782,[43077]=782,[43078]=782,[43079]=782,[43080]=783,
		[43081]=783,[43082]=783,[43083]=783,[43260]=813,[43261]=815,[43262]=815,[43263]=815,[43264]=815,[43265]=815,
		[43266]=815,[43271]=815,[43273]=815,[43433]=813,[43434]=813,[43435]=813,[43436]=813,[43437]=813,[43438]=813,
		[43439]=813,[43442]=818,[43443]=818,[43444]=818,[43445]=818,[43446]=818,[43447]=818,[43448]=818,[43449]=818,
		[43450]=817,[43451]=817,[43452]=817,[43453]=817,[43454]=817,[43455]=817,[43456]=817,[43457]=817,[43727]=801,
		[43728]=801,[43729]=801,[43730]=801,[43731]=801,[43732]=805,[43733]=804,[43734]=794,[43735]=794,[43736]=794,
		[43737]=794,[43738]=794,[43739]=788,[43740]=787,[43741]=788,[43742]=787,[43743]=787,[43744]=788,[43745]=787,
		[43746]=788,[43747]=787,[43748]=788,[43749]=800,[43750]=800,[43751]=798,[43752]=799,[43753]=798,[43754]=799,
		[43755]=799,[43756]=798,[43757]=800,[43758]=798,[43759]=799,[43760]=800,[43761]=800,[43762]=795,[43763]=795,
		[43764]=796,[43765]=795,[43766]=797,[43767]=796,[43768]=797,[43769]=796,[43770]=796,[43771]=797,[43772]=795,
		[43773]=796,[43774]=797,[43775]=797,[43776]=795,[43777]=803,[43778]=803,[43779]=803,[43780]=803,[43781]=803,
		[43782]=804,[43783]=805,[43784]=804,[43785]=805,[43786]=805,[43787]=802,[43788]=802,[43789]=802,[43790]=802,
		[43791]=802,[43792]=805,[43793]=791,[43794]=789,[43795]=791,[43796]=789,[43797]=790,[43798]=790,[43799]=791,
		[43800]=790,[43801]=789,[43802]=791,[43803]=789,[43804]=791,[43805]=789,[43806]=790,[43807]=790,[43808]=804,
		[43809]=792,[43810]=804,[43811]=793,[43812]=793,[43813]=792,[43814]=793,[43815]=792,[43816]=793,[43817]=792,
		[43818]=793,[43819]=792,[43820]=799,[43822]=798,[43969]=819,[43970]=819,[43971]=819,[43972]=819,[43973]=819,
		[43974]=819,[43975]=819,[44211]=763,[45335]=3100835,[45336]=3100835,[45337]=3100835,[45338]=3100835,[45339]=3100835,[45340]=3100834,
		[45341]=3100834,[45342]=3100834,[45343]=3100834,[45344]=3100834,[45345]=3100829,[45346]=3100829,[45347]=3100829,[45348]=3100829,[45349]=3100829,
		[45350]=828,[45351]=3100828,[45352]=3100828,[45353]=3100828,[45354]=3100828,[45355]=3100827,[45356]=3100827,[45357]=3100827,[45358]=3100827,
		[45359]=3100827,[45360]=3100838,[45361]=3100838,[45362]=3100838,[45363]=3100838,[45364]=3100838,[45365]=3100836,[45367]=3100836,[45368]=3100836,
		[45369]=3100836,[45370]=3100822,[45371]=3100822,[45372]=3100822,[45373]=3100822,[45374]=3100822,[45375]=3100820,[45376]=3100820,[45377]=3100820,
		[45379]=3100820,[45380]=3100820,[45381]=3100821,[45382]=3100821,[45383]=3100821,[45384]=3100821,[45385]=3100821,[45386]=3100833,[45387]=3100833,
		[45388]=3100833,[45389]=3100833,[45390]=3100833,[45391]=3100832,[45392]=3100832,[45393]=3100832,[45394]=3100832,[45395]=3100832,[45396]=3100826,
		[45397]=3100826,[45398]=3100826,[45399]=3100826,[45400]=3100826,[45401]=3100825,[45402]=3100825,[45403]=3100825,[45404]=3100825,[45405]=3100825,
		[45406]=3100824,[45408]=3100824,[45409]=3100824,[45410]=3100824,[45411]=3100824,[45412]=3100823,[45413]=3100823,[45414]=3100823,[45415]=3100823,
		[45416]=3100823,[45417]=3100837,[45419]=3100837,[45420]=3100837,[45421]=3100837,[45422]=3100837,[45424]=3100831,[45425]=3100831,[45426]=3100831,
		[45427]=3100831,[45428]=3100831,[45429]=3100830,[45430]=3100830,[45431]=3100830,[45432]=3100830,[45433]=3100830,[46111]=3250834,[46113]=3250834,
		[46115]=3250834,[46116]=3250834,[46117]=3250834,[46118]=3250835,[46119]=3250835,[46120]=3250835,[46121]=3250835,[46122]=3250835,[46123]=3250826,
		[46124]=3250826,[46125]=3250826,[46126]=3250826,[46127]=3250826,[46129]=3250836,[46130]=3250836,[46131]=3100836,[46132]=3250836,[46133]=3250836,
		[46134]=3250836,[46135]=3250837,[46136]=3250837,[46137]=3250837,[46139]=3250837,[46140]=3250837,[46141]=3250838,[46142]=3250838,[46143]=3250838,
		[46144]=3250838,[46145]=3250838,[46146]=3250830,[46148]=3250830,[46149]=3250830,[46150]=3250830,[46151]=3250830,[46152]=3250820,[46153]=3250820,
		[46154]=3250820,[46155]=3250820,[46156]=3250820,[46157]=3250827,[46158]=3250827,[46159]=3250827,[46160]=3250827,[46161]=3250827,[46162]=3250831,
		[46163]=3250832,[46164]=3250831,[46165]=3250832,[46166]=3250831,[46167]=3250831,[46168]=3250832,[46169]=3250831,[46170]=3250832,[46172]=3250832,
		[46173]=3250821,[46174]=3250821,[46175]=3250821,[46176]=3250821,[46177]=3250821,[46178]=3250822,[46179]=3250822,[46180]=3250822,[46181]=3250822,
		[46182]=3250822,[46183]=3250829,[46184]=3250829,[46185]=3250829,[46186]=3250829,[46187]=3250829,[46188]=3250833,[46189]=3250828,[46190]=3250833,
		[46191]=3250828,[46192]=3250828,[46193]=3250833,[46194]=3250828,[46195]=3250833,[46196]=3250828,[46197]=3250833,[46198]=3250825,[46199]=3250825,
		[46200]=3250823,[46201]=3250825,[46202]=3250825,[46203]=3250823,[46204]=3250825,[46205]=3250823,[46206]=3250824,[46207]=3250824,[46208]=3250823,
		[46209]=3250824,[46210]=3250824,[46211]=3250824,[46212]=3250823,[46213]=820,[46214]=821,[46215]=821,[46216]=820,[46217]=822,
		[46218]=822,[46219]=821,[46220]=822,[46221]=820,[46222]=821,[46224]=820,[46225]=821,[46226]=820,[46227]=822,
		[46228]=822,[46230]=832,[46231]=833,[46232]=834,[46233]=835,[46234]=835,[46235]=834,[46236]=835,[46237]=834,
		[46238]=835,[46239]=834,[46240]=835,[46241]=834,[46242]=837,[46243]=837,[46244]=837,[46245]=837,[46246]=837,
		[46247]=833,[46248]=832,[46249]=836,[46250]=836,[46251]=836,[46252]=836,[46253]=836,[46254]=833,[46255]=832,
		[46256]=832,[46257]=832,[46258]=833,[46259]=833,[46260]=827,[46261]=829,[46262]=827,[46263]=829,[46264]=829,
		[46265]=827,[46266]=828,[46267]=827,[46268]=829,[46269]=827,[46270]=829,[46271]=828,[46272]=828,[46273]=838,
		[46274]=838,[46275]=838,[46276]=838,[46277]=838,[46278]=830,[46279]=831,[46280]=830,[46281]=831,[46282]=830,
		[46283]=831,[46284]=831,[46285]=830,[46286]=831,[46287]=830,[46288]=826,[46289]=826,[46290]=826,[46291]=826,
		[46292]=826,[46293]=823,[46294]=823,[46295]=824,[46296]=823,[46297]=825,[46298]=824,[46299]=825,[46300]=824,
		[46301]=824,[46302]=825,[46303]=823,[46304]=824,[46305]=825,[46306]=825,[46307]=823,[46309]=828,[46313]=3100828,
		[47748]=3000843,[47749]=3000843,[47750]=3000843,[47751]=3000843,[47752]=3000843,[47753]=3250843,[47754]=3250843,[47755]=3250843,[47756]=3250843,
		[47757]=3250843,[47758]=3251843,[47759]=3251843,[47760]=3251843,[47761]=3251843,[47762]=3251843,[47763]=3251844,[47764]=3251844,[47765]=3251844,
		[47766]=3251844,[47767]=3251844,[47768]=3250844,[47769]=3250844,[47770]=3250844,[47771]=3250844,[47772]=3250844,[47773]=3000844,[47774]=3000844,
		[47775]=3000844,[47776]=3000844,[47777]=3000844,[47778]=3250846,[47779]=3250846,[47780]=3250846,[47781]=3250846,[47782]=3250846,[47783]=3000846,
		[47784]=3000846,[47785]=3000846,[47786]=3000846,[47787]=3000846,[47788]=3251846,[47789]=3251846,[47790]=3251846,[47791]=3251846,[47792]=3251846,
		[47793]=3251845,[47794]=3251845,[47795]=3251845,[47796]=3251845,[47797]=3251845,[47798]=3000845,[47799]=3000845,[47800]=3000845,[47801]=3000845,
		[47802]=3000845,[47803]=3250845,[47804]=3250845,[47805]=3250845,[47806]=3250845,[47807]=3250845,[47914]=3000847,[47936]=3000847,[47980]=3000847,
		[47981]=3000847,[47982]=3000847,[47983]=3250847,[47984]=3250847,[47985]=3250847,[47986]=3250847,[47987]=3250847,[48029]=3251847,[48031]=3251847,
		[48033]=3251847,[48035]=3251847,[48037]=3251847,[48057]=3251848,[48058]=3251848,[48059]=3251848,[48060]=3251848,[48061]=3251848,[48062]=3250848,
		[48063]=3250848,[48064]=3250848,[48065]=3250848,[48066]=3250848,[48067]=3000848,[48068]=3000848,[48069]=3000848,[48070]=3000848,[48071]=3000848,
		[48072]=3000849,[48073]=3000849,[48074]=3000849,[48075]=3000849,[48076]=3000849,[48077]=3250849,[48078]=3250849,[48079]=3250849,[48080]=3250849,
		[48081]=3250849,[48082]=3251849,[48083]=3251849,[48084]=3251849,[48085]=3251849,[48086]=3251849,[48087]=3251850,[48088]=3251850,[48089]=3251850,
		[48090]=3251850,[48091]=3251850,[48092]=3250850,[48093]=3250850,[48094]=3250850,[48095]=3250850,[48096]=3250850,[48097]=3000850,[48098]=3000850,
		[48099]=3000850,[48100]=3000850,[48101]=3000850,[48102]=3000851,[48129]=3000851,[48130]=3000851,[48131]=3000851,[48132]=3000851,[48133]=3250851,
		[48134]=3250851,[48135]=3250851,[48136]=3250851,[48137]=3250851,[48138]=3251851,[48139]=3251851,[48140]=3251851,[48141]=3251851,[48142]=3251851,
		[48143]=3251852,[48144]=3251852,[48145]=3251852,[48146]=3251852,[48147]=3251852,[48148]=3250852,[48149]=3250852,[48150]=3250852,[48151]=3250852,
		[48152]=3250852,[48153]=3000852,[48154]=3000852,[48155]=3000852,[48156]=3000852,[48157]=3000852,[48158]=3000853,[48159]=3000853,[48160]=3000853,
		[48161]=3000853,[48162]=3000853,[48163]=3250853,[48164]=3250853,[48165]=3250853,[48166]=3250853,[48167]=3250853,[48168]=3251853,[48169]=3251853,
		[48170]=3251853,[48171]=3251853,[48172]=3251853,[48173]=3251854,[48174]=3251854,[48175]=3251854,[48176]=3251854,[48177]=3251854,[48178]=3250854,
		[48179]=3250854,[48180]=3250854,[48181]=3250854,[48182]=3250854,[48183]=3000854,[48184]=3000854,[48185]=3000854,[48186]=3000854,[48187]=3000854,
		[48188]=3000856,[48189]=3000856,[48190]=3000856,[48191]=3000856,[48192]=3000856,[48193]=3250856,[48194]=3250856,[48195]=3250856,[48196]=3250856,
		[48197]=3250856,[48198]=3251856,[48199]=3251856,[48200]=3251856,[48201]=3251856,[48202]=3251856,[48203]=3251855,[48204]=3251855,[48205]=3251855,
		[48206]=3251855,[48207]=3251855,[48208]=3250855,[48209]=3250855,[48210]=3250855,[48211]=3250855,[48212]=3250855,[48213]=3000855,[48214]=3000855,
		[48215]=3000855,[48216]=3000855,[48217]=3000855,[48218]=3000857,[48219]=3000857,[48220]=3000857,[48221]=3000857,[48222]=3000857,[48223]=3250857,
		[48224]=3250857,[48225]=3250857,[48226]=3250857,[48227]=3250857,[48228]=3251857,[48229]=3251857,[48230]=3251857,[48231]=3251857,[48232]=3251857,
		[48233]=3251858,[48234]=3251858,[48235]=3251858,[48236]=3251858,[48237]=3251858,[48238]=3250858,[48239]=3250858,[48240]=3250858,[48241]=3250858,
		[48242]=3250858,[48243]=3000858,[48244]=3000858,[48245]=3000858,[48246]=3000858,[48247]=3000858,[48250]=3000859,[48251]=3000859,[48252]=3000859,
		[48253]=3000859,[48254]=3000859,[48255]=3250859,[48256]=3250859,[48257]=3250859,[48258]=3250859,[48259]=3250859,[48260]=3251859,[48261]=3251859,
		[48262]=3251859,[48263]=3251859,[48264]=3251859,[48265]=3251860,[48266]=3251860,[48267]=3251860,[48268]=3251860,[48269]=3251860,[48270]=3250860,
		[48271]=3250860,[48272]=3250860,[48273]=3250860,[48274]=3250860,[48275]=3000860,[48276]=3000860,[48277]=3000860,[48278]=3000860,[48279]=3000860,
		[48280]=3000861,[48281]=3000861,[48282]=3000861,[48283]=3000861,[48284]=3000861,[48285]=3250861,[48286]=3250861,[48287]=3250861,[48288]=3250861,
		[48289]=3250861,[48290]=3251861,[48291]=3251861,[48292]=3251861,[48293]=3251861,[48294]=3251861,[48295]=3000862,[48296]=3000862,[48297]=3000862,
		[48298]=3000862,[48299]=3000862,[48300]=3250862,[48301]=3250862,[48302]=3250862,[48303]=3250862,[48304]=3250862,[48305]=3251862,[48306]=3251862,
		[48307]=3251862,[48308]=3251862,[48309]=3251862,[48310]=3000864,[48312]=3000864,[48313]=3000864,[48314]=3000864,[48315]=3000864,[48316]=3250864,
		[48317]=3250864,[48318]=3250864,[48319]=3250864,[48320]=3250864,[48321]=3251864,[48322]=3251864,[48323]=3251864,[48324]=3251864,[48325]=3251864,
		[48326]=3251863,[48327]=3251863,[48328]=3251863,[48329]=3251863,[48330]=3251863,[48331]=3250863,[48332]=3250863,[48333]=3250863,[48334]=3250863,
		[48335]=3250863,[48336]=3000863,[48337]=3000863,[48338]=3000863,[48339]=3000863,[48340]=3000863,[48341]=3000865,[48342]=3000865,[48343]=3000865,
		[48344]=3000865,[48345]=3000865,[48346]=3250865,[48347]=3250865,[48348]=3250865,[48349]=3250865,[48350]=3250865,[48351]=3251865,[48352]=3251865,
		[48353]=3251865,[48354]=3251865,[48355]=3251865,[48356]=3251866,[48357]=3251866,[48358]=3251866,[48359]=3251866,[48360]=3251866,[48361]=3250866,
		[48362]=3250866,[48363]=3250866,[48364]=3250866,[48365]=3250866,[48366]=3000866,[48367]=3000866,[48368]=3000866,[48369]=3000866,[48370]=3000866,
		[48371]=3000867,[48372]=3000867,[48373]=3000867,[48374]=3000867,[48375]=3000867,[48376]=3250867,[48377]=3250867,[48378]=3250867,[48379]=3250867,
		[48380]=3250867,[48381]=3251867,[48382]=3251867,[48383]=3251867,[48384]=3251867,[48385]=3251867,[48386]=3000868,[48387]=3000868,[48388]=3000868,
		[48389]=3000868,[48390]=3000868,[48391]=3250868,[48392]=3250868,[48393]=3250868,[48394]=3250868,[48395]=3250868,[48396]=3251868,[48397]=3251868,
		[48398]=3251868,[48399]=3251868,[48400]=3251868,[48429]=3000869,[48430]=3250869,[48433]=3251869,[48436]=3000869,[48445]=3000869,[48446]=3250869,
		[48447]=3251869,[48448]=3000869,[48449]=3000869,[48450]=3250869,[48451]=3251869,[48452]=3250869,[48453]=3251869,[48454]=3250869,[48455]=3251869,
		[48456]=3000870,[48457]=3000870,[48458]=3000870,[48459]=3000870,[48460]=3000870,[48461]=3250870,[48462]=3250870,[48463]=3250870,[48464]=3250870,
		[48465]=3250870,[48466]=3251870,[48467]=3251870,[48468]=3251870,[48469]=3251870,[48470]=3251870,[48472]=3000871,[48474]=3000871,[48476]=3000871,
		[48478]=3000871,[48480]=3000871,[48481]=3250871,[48482]=3250871,[48483]=3250871,[48484]=3250871,[48485]=3250871,[48486]=3251871,[48487]=3251871,
		[48488]=3251871,[48489]=3251871,[48490]=3251871,[48491]=3251872,[48492]=3251872,[48493]=3251872,[48494]=3251872,[48495]=3251872,[48496]=3250872,
		[48497]=3250872,[48498]=3250872,[48499]=3250872,[48500]=3250872,[48501]=3000872,[48502]=3000872,[48503]=3000872,[48504]=3000872,[48505]=3000872,
		[48529]=3000873,[48531]=3000873,[48533]=3000873,[48535]=3000873,[48537]=3000873,[48538]=3250873,[48539]=3250873,[48540]=3250873,[48541]=3250873,
		[48542]=3250873,[48543]=3251873,[48544]=3251873,[48545]=3251873,[48546]=3251873,[48547]=3251873,[48548]=3251874,[48549]=3251874,[48550]=3251874,
		[48551]=3251874,[48552]=3251874,[48553]=3250874,[48554]=3250874,[48555]=3250874,[48556]=3250874,[48557]=3250874,[48558]=3000874,[48559]=3000874,
		[48560]=3000874,[48561]=3000874,[48562]=3000874,[48564]=3000875,[48566]=3000875,[48568]=3000875,[48572]=3000875,[48574]=3000875,[48575]=3250875,
		[48576]=3250875,[48577]=3250875,[48578]=3250875,[48579]=3250875,[48580]=3251875,[48581]=3251875,[48582]=3251875,[48583]=3251875,[48584]=3251875,
		[48585]=3251876,[48586]=3251876,[48587]=3251876,[48588]=3251876,[48589]=3251876,[48590]=3250876,[48591]=3250876,[48592]=3250876,[48593]=3250876,
		[48594]=3250876,[48595]=3000876,[48596]=3000876,[48597]=3000876,[48598]=3000876,[48599]=3000876,[48602]=3000877,[48603]=3000877,[48604]=3000877,
		[48605]=3000877,[48606]=3000877,[48607]=3250877,[48608]=3250877,[48609]=3250877,[48610]=3250877,[48611]=3250877,[48612]=3251877,[48613]=3251877,
		[48614]=3251877,[48615]=3251877,[48616]=3251877,[48617]=3251878,[48618]=3251878,[48619]=3251878,[48620]=3251878,[48621]=3251878,[48622]=3250878,
		[48623]=3250878,[48624]=3250878,[48625]=3250878,[48626]=3250878,[48627]=3000878,[48628]=3000878,[48629]=3000878,[48630]=3000878,[48631]=3000878,
		[48632]=3000879,[48633]=3000879,[48634]=3000879,[48635]=3000879,[48636]=3000879,[48637]=3250879,[48638]=3250879,[48639]=3250879,[48640]=3250879,
		[48641]=3250879,[48642]=3251879,[48643]=3251879,[48644]=3251879,[48645]=3251879,[48646]=3251879,[48647]=3251880,[48648]=3251880,[48649]=3251880,
		[48650]=3251880,[48651]=3251880,[48652]=3000880,[48653]=3000880,[48654]=3000880,[48655]=3000880,[48656]=3000880,[48657]=3250880,[48658]=3250880,
		[48659]=3250880,[48660]=3250880,[48661]=3250880,[48725]=843,[48726]=843,[48727]=843,[48728]=843,[48729]=843,[48730]=844,
		[48731]=844,[48732]=844,[48733]=844,[48734]=844,[48735]=845,[48736]=845,[48737]=845,[48738]=845,[48739]=845,
		[48740]=846,[48741]=846,[48742]=846,[48743]=846,[48744]=846,[48745]=847,[48746]=847,[48747]=847,[48748]=847,
		[48749]=847,[48750]=848,[48751]=848,[48752]=848,[48753]=848,[48754]=848,[48755]=849,[48756]=849,[48757]=849,
		[48758]=849,[48759]=849,[48760]=850,[48761]=850,[48762]=850,[48763]=850,[48764]=850,[48769]=852,[48770]=852,
		[48771]=852,[48772]=852,[48773]=852,[48774]=851,[48775]=851,[48776]=851,[48777]=851,[48778]=851,[48781]=854,
		[48782]=854,[48783]=854,[48784]=854,[48785]=854,[48786]=853,[48787]=853,[48788]=853,[48789]=853,[48790]=853,
		[48794]=856,[48795]=856,[48796]=856,[48797]=856,[48798]=856,[48799]=855,[48800]=855,[48801]=855,[48802]=855,
		[48803]=855,[48804]=858,[48805]=858,[48806]=858,[48807]=858,[48808]=858,[48809]=857,[48810]=857,[48811]=857,
		[48812]=857,[48813]=857,[48814]=860,[48815]=860,[48816]=860,[48817]=860,[48818]=860,[48819]=859,[48820]=859,
		[48821]=859,[48822]=859,[48823]=859,[48824]=861,[48825]=861,[48826]=861,[48827]=861,[48828]=861,[48829]=862,
		[48830]=862,[48831]=862,[48832]=862,[48833]=862,[48836]=864,[48837]=864,[48838]=864,[48839]=864,[48840]=864,
		[48841]=863,[48842]=863,[48843]=863,[48844]=863,[48845]=863,[48846]=865,[48847]=865,[48848]=865,[48849]=865,
		[48850]=865,[48851]=866,[48852]=866,[48853]=866,[48854]=866,[48855]=866,[48860]=868,[48861]=868,[48862]=868,
		[48863]=868,[48864]=868,[48865]=867,[48866]=867,[48867]=867,[48868]=867,[48869]=867,[48870]=870,[48871]=870,
		[48872]=870,[48873]=870,[48874]=870,[48875]=869,[48876]=869,[48877]=869,[48878]=869,[48879]=869,[48880]=872,
		[48881]=872,[48882]=872,[48883]=872,[48884]=872,[48885]=871,[48886]=871,[48887]=871,[48888]=871,[48889]=871,
		[48890]=874,[48891]=874,[48892]=874,[48893]=874,[48894]=874,[48895]=873,[48896]=873,[48897]=873,[48898]=873,
		[48899]=873,[48900]=875,[48901]=875,[48902]=875,[48903]=875,[48904]=875,[48905]=876,[48906]=876,[48907]=876,
		[48908]=876,[48909]=876,[48910]=878,[48911]=878,[48912]=878,[48913]=878,[48914]=878,[48915]=877,[48916]=877,
		[48917]=877,[48918]=877,[48919]=877,[48922]=880,[48923]=880,[48924]=880,[48925]=880,[48926]=880,[48927]=879,
		[48928]=879,[48929]=879,[48930]=879,[48931]=879,[49310]=881,[49463]=881,[49464]=882,[49488]=882,[50078]=3000895,
		[50079]=3000895,[50080]=3000895,[50081]=3000895,[50082]=3000895,[50087]=3000890,[50088]=3000890,[50089]=3000890,[50090]=3000890,[50094]=3000897,
		[50095]=3000897,[50096]=3000897,[50097]=3000897,[50098]=3000897,[50105]=3000890,[50106]=3000887,[50107]=3000887,[50108]=3000887,[50109]=3000887,
		[50113]=3000887,[50114]=3000891,[50115]=3000891,[50116]=3000891,[50117]=3000891,[50118]=3000891,[50240]=3000884,[50241]=3000884,[50242]=3000884,
		[50243]=3000884,[50244]=3000884,[50275]=3000883,[50276]=3000883,[50277]=3000883,[50278]=3000883,[50279]=3000883,[50324]=3000900,[50325]=3000900,
		[50326]=3000900,[50327]=3000900,[50328]=3000900,[50391]=3000886,[50392]=3000886,[50393]=3000886,[50394]=3000886,[50396]=3000886,[50765]=3000885,
		[50766]=3000885,[50767]=3000885,[50768]=3000885,[50769]=3000885,[50819]=3000888,[50820]=3000888,[50821]=3000888,[50822]=3000888,[50823]=3000888,
		[50824]=3000889,[50825]=3000889,[50826]=3000889,[50827]=3000889,[50828]=3000889,[50830]=3000894,[50831]=3000894,[50832]=3000894,[50833]=3000894,
		[50834]=3000894,[50835]=3000892,[50836]=3000892,[50837]=3000892,[50838]=3000892,[50839]=3000892,[50841]=3000893,[50842]=3000893,[50843]=3000893,
		[50844]=3000893,[50845]=3000893,[50846]=3000896,[50847]=3000896,[50848]=3000896,[50849]=3000896,[50850]=3000896,[50853]=3000898,[50854]=3000898,
		[50855]=3000898,[50856]=3000898,[50857]=3000898,[50860]=3000901,[50861]=3000901,[50862]=3000901,[50863]=3000901,[50864]=3000901,[50865]=3000899,
		[50866]=3000899,[50867]=3000899,[50868]=3000899,[50869]=3000899,[51125]=3250897,[51126]=3250897,[51127]=3250897,[51128]=3250897,[51129]=3250897,
		[51130]=3250898,[51131]=3250898,[51132]=3250898,[51133]=3250898,[51134]=3250898,[51135]=3250887,[51136]=3250887,[51137]=3250887,[51138]=3250887,
		[51139]=3250887,[51140]=3250889,[51141]=3250889,[51142]=3250889,[51143]=3250889,[51144]=3250889,[51145]=3250888,[51146]=3250888,[51147]=3250888,
		[51148]=3250888,[51149]=3250888,[51150]=3250891,[51151]=3250891,[51152]=3250891,[51153]=3250891,[51154]=3250891,[51155]=3250883,[51156]=3250883,
		[51157]=3250883,[51158]=3250883,[51159]=3250883,[51160]=3250900,[51161]=3250900,[51162]=3250900,[51163]=3250900,[51164]=3250900,[51165]=3250899,
		[51166]=3250899,[51167]=3250899,[51168]=3250899,[51169]=3250899,[51170]=3250901,[51171]=3250901,[51172]=3250901,[51173]=3250901,[51174]=3250901,
		[51175]=3250885,[51176]=3250885,[51177]=3250885,[51178]=3250885,[51179]=3250885,[51180]=3250886,[51181]=3250886,[51182]=3250886,[51183]=3250886,
		[51184]=3250886,[51185]=3250890,[51186]=3250890,[51187]=3250890,[51188]=3250890,[51189]=3250890,[51190]=3250892,[51191]=3250892,[51192]=3250892,
		[51193]=3250892,[51194]=3250892,[51195]=3250894,[51196]=3250894,[51197]=3250894,[51198]=3250894,[51199]=3250894,[51200]=3250893,[51201]=3250893,
		[51202]=3250893,[51203]=3250893,[51204]=3250893,[51205]=3250884,[51206]=3250884,[51207]=3250884,[51208]=3250884,[51209]=3250884,[51210]=3250895,
		[51211]=3250895,[51212]=3250895,[51213]=3250895,[51214]=3250895,[51215]=3250896,[51216]=3250896,[51217]=3250896,[51218]=3250896,[51219]=3250896,
		[51220]=3251896,[51221]=3251896,[51222]=3251896,[51223]=3251896,[51224]=3251896,[51225]=3251895,[51226]=3251895,[51227]=3251895,[51228]=3251895,
		[51229]=3251895,[51230]=3251884,[51231]=3251884,[51232]=3251884,[51233]=3251884,[51234]=3251884,[51235]=3251893,[51236]=3251893,[51237]=3251893,
		[51238]=3251893,[51239]=3251893,[51240]=3251894,[51241]=3251894,[51242]=3251894,[51243]=3251894,[51244]=3251894,[51245]=3251892,[51246]=3251892,
		[51247]=3251892,[51248]=3251892,[51249]=3251892,[51250]=3251890,[51251]=3251890,[51252]=3251890,[51253]=3251890,[51254]=3251890,[51255]=3251886,
		[51256]=3251886,[51257]=3251886,[51258]=3251886,[51259]=3251886,[51260]=3251885,[51261]=3251885,[51262]=3251885,[51263]=3251885,[51264]=3251885,
		[51265]=3251901,[51266]=3251901,[51267]=3251901,[51268]=3251901,[51269]=3251901,[51270]=3251899,[51271]=3251899,[51272]=3251899,[51273]=3251899,
		[51274]=3251899,[51275]=3251900,[51276]=3251900,[51277]=3251900,[51278]=3251900,[51279]=3251900,[51280]=3251883,[51281]=3251883,[51282]=3251883,
		[51283]=3251883,[51284]=3251883,[51285]=3251891,[51286]=3251891,[51287]=3251891,[51288]=3251891,[51289]=3251891,[51290]=3251888,[51291]=3251888,
		[51292]=3251888,[51293]=3251888,[51294]=3251888,[51295]=3251889,[51296]=3251889,[51297]=3251889,[51298]=3251889,[51299]=3251889,[51300]=3251887,
		[51301]=3251887,[51302]=3251887,[51303]=3251887,[51304]=3251887,[51305]=3251898,[51306]=3251898,[51307]=3251898,[51308]=3251898,[51309]=3251898,
		[51310]=3251897,[51311]=3251897,[51312]=3251897,[51313]=3251897,[51314]=3251897,[51682]=3000897,[51683]=3000897,[51684]=3000897,[51685]=3000897,
		[51686]=3000897,[51687]=3000898,[51688]=3000898,[51689]=3000898,[51690]=3000898,[51691]=3000898,[51692]=3000887,[51693]=3000887,[51694]=3000887,
		[51695]=3000887,[51696]=3000887,[51697]=3000889,[51698]=3000889,[51699]=3000889,[51700]=3000889,[51701]=3000889,[51702]=3000888,[51703]=3000888,
		[51704]=3000888,[51705]=3000888,[51706]=3000888,[51707]=3000891,[51708]=3000891,[51709]=3000891,[51710]=3000891,[51711]=3000891,[51712]=3000883,
		[51713]=3000883,[51714]=3000883,[51715]=3000883,[51716]=3000883,[51717]=3000900,[51718]=3000900,[51719]=3000900,[51720]=3000900,[51721]=3000900,
		[51722]=3000899,[51723]=3000899,[51724]=3000899,[51725]=3000899,[51726]=3000899,[51727]=3000901,[51728]=3000901,[51729]=3000901,[51730]=3000901,
		[51731]=3000901,[51732]=3000885,[51733]=3000885,[51734]=3000885,[51735]=3000885,[51736]=3000885,[51737]=3000886,[51738]=3000886,[51739]=3000886,
		[51740]=3000886,[51741]=3000886,[51742]=3000890,[51743]=3000890,[51744]=3000890,[51745]=3000890,[51746]=3000890,[51747]=3000892,[51748]=3000892,
		[51749]=3000892,[51750]=3000892,[51751]=3000892,[51752]=3000894,[51753]=3000894,[51754]=3000894,[51755]=3000894,[51756]=3000894,[51757]=3000893,
		[51758]=3000893,[51759]=3000893,[51760]=3000893,[51761]=3000893,[51762]=3000884,[51763]=3000884,[51764]=3000884,[51765]=3000884,[51766]=3000884,
		[51767]=3000895,[51768]=3000895,[51769]=3000895,[51770]=3000895,[51771]=3000895,[51772]=3000896,[51773]=3000896,[51774]=3000896,[51775]=3000896,
		[51776]=3000896,
    }
end

function ItemSet.GetSetName(setID, addQualityColor)
    if not ITEM_SET_DATA[setID] then return end
	local setName = GetItemSetInfo(ITEM_SET_DATA[setID][8] or setID)
	if ITEM_SET_DATA[setID][8] then
		setName = format(ITEM_SET_DATA[setID][7] or "%s", setName)
	end
    if addQualityColor then
        return format("%s%s|r", COLOR_STRINGS[ITEM_SET_DATA[setID][3]], setName or UNKNOWN)
    else
        return setName
    end
end

function ItemSet.GetSetIDforItemID(itemID)
	return ITEM_TO_SET[itemID]
end

function ItemSet.GetSetItems(setID)
    return ITEM_SET_DATA[setID] and ITEM_SET_DATA[setID][1] or nil
end

function ItemSet.GetSetIcon(setID, useClassIcon)
    if not ITEM_SET_DATA[setID] then return end
	if SPECIAL_ICONS[setID] then
		return SPECIAL_ICONS[setID]
    else
        if useClassIcon and ITEM_SET_DATA[setID][5] and CLASS_BIT_TO_CLASS[ITEM_SET_DATA[setID][5]] then
            return ICON_PATH_CLASS[CLASS_BIT_TO_CLASS[ITEM_SET_DATA[setID][5]]]
        else
            return GetItemIcon(ITEM_SET_DATA[setID][1][1]) or NO_ICON
        end
	end
end

function ItemSet.GetPhaseTextureForSetID(setID)
    if not ITEM_SET_DATA[setID] then return end
    if not ContentPhaseCache[setID] then
        local content = ITEM_SET_DATA[setID][1]
        local phase = 0
        for i = 1, #content do
            local c = ContentPhase:GetForItemID(content[i])
            phase = ( c and c > phase ) and c or phase
        end

        ContentPhaseCache[setID] = phase
    end
    return ContentPhaseCache[setID]
end

function ItemSet.GetSetDescriptionString(setID)
    if not ITEM_SET_DATA[setID] then return end
    local itemType
    if ITEM_SET_DATA[setID][5] and CLASS_BIT_TO_CLASS[ITEM_SET_DATA[setID][5]] then
        itemType = CLASS_NAMES_WITH_COLORS[CLASS_BIT_TO_CLASS[ITEM_SET_DATA[setID][5]]]
    else
        itemType = ITEM_SET_DATA[setID][2] > 0 and GetItemSubClassInfo(4, ITEM_SET_DATA[setID][2]) or ""
    end

    if itemType and itemType ~= "" then
        return format("%s%s | |cff00ccffiLvlAvg:|r %d", Requirements.BuildClassString(ITEM_SET_DATA[setID][5]), itemType, ITEM_SET_DATA[setID][4])
    elseif ITEM_SET_DATA[setID][5] > 0 then
        return format("%s |cff00ccffiLvlAvg:|r %d", Requirements.BuildClassString(ITEM_SET_DATA[setID][5]), ITEM_SET_DATA[setID][4])
    else
        return format("|cff00ccffiLvlAvg:|r %d", ITEM_SET_DATA[setID][4])
    end
end

function ItemSet.GetSetDataForExtraFrame(setID)
    if not ITEM_SET_DATA[setID] then return end
    local data = {"set"..setID, 0}
    for i = 1, #ITEM_SET_DATA[setID][1] do
        data[#data+1] = ITEM_SET_DATA[setID][1][i]
    end
    return data
end

local BONUS_FORMAT_STRING = AL["(%d) Set:"].." |cffffffff%s|r\n"
function ItemSet.GetSetBonusString(setID)
	if not ITEM_SET_DATA[setID] or not ITEM_SET_DATA[setID][6] then return end
	local ret = ""
	for i,spellEntry in ipairs(ITEM_SET_DATA[setID][6]) do
		local spellText = GetSpellDescription(spellEntry[2])
		if not spellText or spellText == "" then
			ret = false
		end
		if ret then
			ret = ret..format(BONUS_FORMAT_STRING, spellEntry[1], spellText)
		end
	end
	return ret
end