-- $Id: AreaIDs.lua 431 2023-03-20 14:46:49Z arithmandar $
--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 ~ 2010 - Dan Gilbert <dan.b.gilbert at gmail dot com>
	Copyright 2010 - Lothaer <lothayer at gmail dot com>, Atlas Team
	Copyright 2011 ~ 2023 - Arith Hsu, Atlas Team <atlas.addon at gmail dot com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]
-- ----------------------------------------------------------------------------
-- Localized Lua globals.
-- ----------------------------------------------------------------------------
-- Functions
local _G = getfenv(0)

-- Libraries

-- ----------------------------------------------------------------------------
-- AddOn namespace.
-- ----------------------------------------------------------------------------
local FOLDER_NAME, private = ...

local MapData = {}

MapData.AreaToID = {
	["Dun Morogh"] = 1,
	["Longshore"] = 2,
	["Badlands"] = 3,
	["Blasted Lands"] = 4,
	["- QA and DVD GLOBAL -"] = 5,
	["Blackwater Cove"] = 7,
	["Swamp of Sorrows"] = 8,
	["Northshire Valley"] = 9,
	["Duskwood"] = 10,
	["Wetlands"] = 11,
	["Elwynn Forest"] = 12,
	["The World Tree"] = 13,
	["Durotar"] = 14,
	["Dustwallow Marsh"] = 15,
	["Azshara"] = 16,
	["Northern Barrens"] = 17,
	["Crystal Lake"] = 18,
	["Zul'Gurub"] = 19,
	["Moonbrook"] = 20,
	["Kul Tiras"] = 21,
	["Programmer Isle"] = 22,
	["Northshire River"] = 23,
	["Northshire Abbey"] = 24,
	["Blackrock Mountain"] = 25,
	["Lighthouse"] = 26,
	["Western Plaguelands"] = 28,
	["Nine"] = 30,
	["The Cemetary"] = 32,
	["Northern Stranglethorn"] = 33,
	["Echo Ridge Mine"] = 34,
	["Booty Bay"] = 35,
	["Alterac Mountains"] = 36,
	["Lake Nazferiti"] = 37,
	["Loch Modan"] = 38,
	["Westfall"] = 40,
	["Deadwind Pass"] = 41,
	["Darkshire"] = 42,
	["Wild Shore"] = 43,
	["Redridge Mountains"] = 44,
	["Arathi Highlands"] = 45,
	["Burning Steppes"] = 46,
	["The Hinterlands"] = 47,
	["Dead Man's Hole"] = 49,
	["Searing Gorge"] = 51,
	["Thieves Camp"] = 53,
	["Jasperlode Mine"] = 54,
	["Valley of Heroes UNUSED"] = 55,
	["Heroes' Vigil"] = 56,
	["Fargodeep Mine"] = 57,
	["Northshire Vineyards"] = 59,
	["Forest's Edge"] = 60,
	["Thunder Falls"] = 61,
	["Brackwell Pumpkin Patch"] = 62,
	["The Stonefield Farm"] = 63,
	["The Maclure Vineyards"] = 64,
	["Dragonblight"] = 65,
	["Zul'Drak"] = 66,
	["The Storm Peaks"] = 67,
	["Lake Everstill"] = 68,
	["Lakeshire"] = 69,
	["Stonewatch"] = 70,
	["Stonewatch Falls"] = 71,
	["The Dark Portal"] = 72,
	["The Tainted Scar"] = 73,
	["Pool of Tears"] = 74,
	["Stonard"] = 75,
	["Fallow Sanctuary"] = 76,
	["Anvilmar"] = 77,
	["Stormwind Mountains"] = 80,
	["Jeff NE Quadrant Changed"] = 81,
	["Jeff NW Quadrant"] = 82,
	["Jeff SE Quadrant"] = 83,
	["Jeff SW Quadrant"] = 84,
	["Tirisfal Glades"] = 85,
	["Stone Cairn Lake"] = 86,
	["Goldshire"] = 87,
	["Eastvale Logging Camp"] = 88,
	["Mirror Lake Orchard"] = 89,
	["Tower of Azora"] = 91,
	["Mirror Lake"] = 92,
	["Vul'Gol Ogre Mound"] = 93,
	["Raven Hill"] = 94,
	["Redridge Canyons"] = 95,
	["Tower of Ilgalar"] = 96,
	["Alther's Mill"] = 97,
	["Rethban Caverns"] = 98,
	["Rebel Camp"] = 99,
	["Nesingwary's Expedition"] = 100,
	["Kurzen's Compound"] = 101,
	["Ruins of Zul'Kunda"] = 102,
	["Ruins of Zul'Mamwe"] = 103,
	["The Vile Reef"] = 104,
	["Mosh'Ogg Ogre Mound"] = 105,
	["The Stockpile"] = 106,
	["Saldean's Farm"] = 107,
	["Sentinel Hill"] = 108,
	["Furlbrow's Pumpkin Farm"] = 109,
	["Jangolode Mine"] = 111,
	["Gold Coast Quarry"] = 113,
	["Westfall Lighthouse"] = 115,
	["Misty Valley"] = 116,
	["Grom'gol Base Camp"] = 117,
	["Whelgar's Excavation Site"] = 118,
	["Westbrook Garrison"] = 120,
	["Tranquil Gardens Cemetery"] = 121,
	["Zuuldaia Ruins"] = 122,
	["Bal'lal Ruins"] = 123,
	["Kal'ai Ruins"] = 125,
	["Tkashi Ruins"] = 126,
	["Balia'mah Ruins"] = 127,
	["Ziata'jai Ruins"] = 128,
	["Mizjah Ruins"] = 129,
	["Silverpine Forest"] = 130,
	["Kharanos"] = 131,
	["Coldridge Valley"] = 132,
	["New Tinkertown"] = 133,
	["Gol'Bolar Quarry"] = 134,
	["Frostmane Hold"] = 135,
	["The Grizzled Den"] = 136,
	["Brewnall Village"] = 137,
	["Misty Pine Refuge"] = 138,
	["Eastern Plaguelands"] = 139,
	["Teldrassil"] = 141,
	["Ironband's Excavation Site"] = 142,
	["Mo'grosh Stronghold"] = 143,
	["Thelsamar"] = 144,
	["Algaz Gate"] = 145,
	["Stonewrought Dam"] = 146,
	["The Farstrider Lodge"] = 147,
	["Darkshore"] = 148,
	["Silver Stream Mine"] = 149,
	["Menethil Harbor"] = 150,
	["Designer Island"] = 151,
	["The Bulwark"] = 152,
	["Ruins of Lordaeron"] = 153,
	["Deathknell"] = 154,
	["Night Web's Hollow"] = 155,
	["Solliden Farmstead"] = 156,
	["Agamand Mills"] = 157,
	["Agamand Family Crypt"] = 158,
	["Brill"] = 159,
	["Whispering Gardens"] = 160,
	["Terrace of Repose"] = 161,
	["Brightwater Lake"] = 162,
	["Gunther's Retreat"] = 163,
	["Garren's Haunt"] = 164,
	["Balnir Farmstead"] = 165,
	["Cold Hearth Manor"] = 166,
	["Crusader Outpost"] = 167,
	["The North Coast"] = 168,
	["Whispering Shore"] = 169,
	["Lordamere Lake"] = 170,
	["Fenris Isle"] = 172,
	["Faol's Rest"] = 173,
	["Dolanaar"] = 186,
	["Darnassus UNUSED"] = 187,
	["Shadowglen"] = 188,
	["Steelgrill's Depot"] = 189,
	["Hearthglen"] = 190,
	["Northridge Lumber Camp"] = 192,
	["Andorhal"] = 193,
	["School of Necromancy"] = 195,
	["Uther's Tomb"] = 196,
	["Sorrow Hill"] = 197,
	["The Weeping Cave"] = 198,
	["Felstone Field"] = 199,
	["Dalson's Farm"] = 200,
	["Gahrron's Withering"] = 201,
	["The Writhing Haunt"] = 202,
	["Mardenholde Keep"] = 203,
	["Pyrewood Village"] = 204,
	["Dun Modr"] = 205,
	["Utgarde Keep"] = 206,
	["The Great Sea"] = 207,
	["Unused Ironcladcove"] = 208,
	["Shadowfang Keep"] = 209,
	["Icecrown"] = 210,
	["Iceflow Lake"] = 211,
	["Helm's Bed Lake"] = 212,
	["Deep Elem Mine"] = 213,
	["The Great Sea"] = 214,
	["Mulgore"] = 215,
	["Alexston Farmstead"] = 219,
	["Red Cloud Mesa"] = 220,
	["Camp Narache"] = 221,
	["Bloodhoof Village"] = 222,
	["Stonebull Lake"] = 223,
	["Ravaged Caravan"] = 224,
	["Red Rocks"] = 225,
	["The Skittering Dark"] = 226,
	["Valgan's Field"] = 227,
	["The Sepulcher"] = 228,
	["Olsen's Farthing"] = 229,
	["The Greymane Wall"] = 230,
	["Beren's Peril"] = 231,
	["The Dawning Isles"] = 232,
	["Ambermill"] = 233,
	["Fenris Keep"] = 235,
	["Shadowfang Keep"] = 236,
	["The Decrepit Fields"] = 237,
	["Malden's Orchard"] = 238,
	["The Ivar Patch"] = 239,
	["The Dead Field"] = 240,
	["The Rotting Orchard"] = 241,
	["Brightwood Grove"] = 242,
	["Forlorn Rowe"] = 243,
	["The Whipple Estate"] = 244,
	["The Yorgen Farmstead"] = 245,
	["The Cauldron"] = 246,
	["Grimesilt Dig Site"] = 247,
	["Dreadmaul Rock"] = 249,
	["Ruins of Thaurissan"] = 250,
	["Flame Crest"] = 251,
	["Blackrock Stronghold"] = 252,
	["The Pillar of Ash"] = 253,
	["Blackrock Mountain"] = 254,
	["Altar of Storms"] = 255,
	["Aldrassil"] = 256,
	["Shadowthread Cave"] = 257,
	["Fel Rock"] = 258,
	["Lake Al'Ameth"] = 259,
	["Starbreeze Village"] = 260,
	["Gnarlpine Hold"] = 261,
	["Ban'ethil Barrow Den"] = 262,
	["The Cleft"] = 263,
	["The Oracle Glade"] = 264,
	["Wellspring River"] = 265,
	["Wellspring Lake"] = 266,
	["Hillsbrad Foothills"] = 267,
	["Azshara Crater"] = 268,
	["Dun Algaz"] = 269,
	["Ruins of Southshore"] = 271,
	["Tarren Mill"] = 272,
	["Durnholde Keep"] = 275,
	["UNUSED Stonewrought Pass"] = 276,
	["The Foothill Caverns"] = 277,
	["Brazie Farmstead"] = 278,
	["Dalaran Crater"] = 279,
	["Strahnbrad"] = 280,
	["Ruins of Alterac"] = 281,
	["Crushridge Hold"] = 282,
	["Slaughter Hollow"] = 283,
	["The Uplands"] = 284,
	["Southpoint Gate"] = 285,
	["The Sludge Fields"] = 286,
	["Hillsbrad"] = 287,
	["Azurelode Mine"] = 288,
	["Nethander Stead"] = 289,
	["Dun Garok"] = 290,
	["Thoradin's Wall"] = 293,
	["Eastern Strand"] = 294,
	["Western Strand"] = 295,
	["South Seas UNUSED"] = 296,
	["Jaguero Isle"] = 297,
	["Baradin Bay"] = 298,
	["Menethil Bay"] = 299,
	["Misty Reed Strand"] = 300,
	["The Savage Coast"] = 301,
	["The Crystal Shore"] = 302,
	["Shell Beach"] = 303,
	["North Tide's Run"] = 305,
	["South Tide's Run"] = 306,
	["The Overlook Cliffs"] = 307,
	["The Forbidding Sea"] = 308,
	["Ironbeard's Tomb"] = 309,
	["Crystalvein Mine"] = 310,
	["Ruins of Aboraz"] = 311,
	["Janeiro's Point"] = 312,
	["Northfold Manor"] = 313,
	["Go'Shek Farm"] = 314,
	["Dabyrie's Farmstead"] = 315,
	["Boulderfist Hall"] = 316,
	["Witherbark Village"] = 317,
	["Drywhisker Gorge"] = 318,
	["Refuge Pointe"] = 320,
	["Hammerfall"] = 321,
	["Blackwater Shipwrecks"] = 322,
	["O'Breen's Camp"] = 323,
	["Stromgarde Keep"] = 324,
	["The Tower of Arathor"] = 325,
	["The Sanctum"] = 326,
	["Faldir's Cove"] = 327,
	["The Drowned Reef"] = 328,
	["Thandol Span"] = 330,
	["Ashenvale"] = 331,
	["The Great Sea"] = 332,
	["Circle of East Binding"] = 333,
	["Circle of West Binding"] = 334,
	["Circle of Inner Binding"] = 335,
	["Circle of Outer Binding"] = 336,
	["Apocryphan's Rest"] = 337,
	["Angor Fortress"] = 338,
	["Lethlor Ravine"] = 339,
	["Ruins of Kargath"] = 340,
	["Camp Kosh"] = 341,
	["Camp Boff"] = 342,
	["Camp Wurg"] = 343,
	["Camp Cagg"] = 344,
	["Agmond's End"] = 345,
	["Hammertoe's Digsite"] = 346,
	["Dustbelch Grotto"] = 347,
	["Aerie Peak"] = 348,
	["Wildhammer Keep"] = 349,
	["Quel'Danil Lodge"] = 350,
	["Skulk Rock"] = 351,
	["Zun'watha"] = 352,
	["Shadra'Alor"] = 353,
	["Jintha'Alor"] = 354,
	["The Altar of Zul"] = 355,
	["Seradane"] = 356,
	["Feralas"] = 357,
	["Brambleblade Ravine"] = 358,
	["Bael Modan [UNUSED]"] = 359,
	["The Venture Co. Mine"] = 360,
	["Felwood"] = 361,
	["Razor Hill"] = 362,
	["Valley of Trials"] = 363,
	["The Den"] = 364,
	["Burning Blade Coven"] = 365,
	["Northwatch Foothold"] = 366,
	["Sen'jin Village"] = 367,
	["Echo Isles"] = 368,
	["Thunder Ridge"] = 369,
	["Drygulch Ravine"] = 370,
	["Dustwind Cave"] = 371,
	["Tiragarde Keep"] = 372,
	["Scuttle Coast"] = 373,
	["Bladefist Bay"] = 374,
	["Deadeye Shore"] = 375,
	["Southfury River"] = 377,
	["Camp Taurajo [UNUSED]"] = 378,
	["Far Watch Post"] = 379,
	["The Crossroads"] = 380,
	["Boulder Lode Mine"] = 381,
	["The Sludge Fen"] = 382,
	["The Dry Hills"] = 383,
	["Dreadmist Peak"] = 384,
	["Northwatch Hold [UNUSED]"] = 385,
	["The Forgotten Pools"] = 386,
	["Lushwater Oasis"] = 387,
	["The Stagnant Oasis"] = 388,
	["Field of Giants [UNUSED]"] = 390,
	["The Merchant Coast"] = 391,
	["Ratchet"] = 392,
	["Darkspear Strand"] = 393,
	["Grizzly Hills"] = 394,
	["Grizzlemaw"] = 395,
	["Winterhoof Water Well"] = 396,
	["Thunderhorn Water Well"] = 397,
	["Wildmane Water Well"] = 398,
	["Skyline Ridge"] = 399,
	["Thousand Needles"] = 400,
	["The Tidus Stair"] = 401,
	["Shady Rest Inn"] = 403,
	["Bael'dun Digsite"] = 404,
	["Desolace"] = 405,
	["Stonetalon Mountains"] = 406,
	["Orgrimmar UNUSED"] = 407,
	["Gillijim's Isle"] = 408,
	["Island of Doctor Lapidis"] = 409,
	["Razorwind Canyon"] = 410,
	["Bathran's Haunt"] = 411,
	["The Ruins of Ordil'Aran"] = 412,
	["Maestra's Post"] = 413,
	["The Zoram Strand"] = 414,
	["Astranaar"] = 415,
	["The Shrine of Aessina"] = 416,
	["Fire Scar Shrine"] = 417,
	["The Ruins of Stardust"] = 418,
	["The Howling Vale"] = 419,
	["Silverwind Refuge"] = 420,
	["Mystral Lake"] = 421,
	["Fallen Sky Lake"] = 422,
	["Remains of Iris Lake"] = 424,
	["Moonwell of Purity"] = 425,
	["Raynewood Retreat"] = 426,
	["The Shady Nook"] = 427,
	["Night Run"] = 428,
	["Xavian"] = 429,
	["Satyrnaar"] = 430,
	["Splintertree Post"] = 431,
	["The Dor'Danil Barrow Den"] = 432,
	["Falfarren River"] = 433,
	["Felfire Hill"] = 434,
	["Demon Fall Canyon"] = 435,
	["Demon Fall Ridge"] = 436,
	["Warsong Lumber Camp"] = 437,
	["Bough Shadow"] = 438,
	["The Shimmering Flats"] = 439,
	["Tanaris"] = 440,
	["Lake Falathim"] = 441,
	["Ruins of Auberdine"] = 442,
	["Ruins of Mathystra"] = 443,
	["Tower of Althalaxx"] = 444,
	["Cliffspring Falls"] = 445,
	["Bashal'Aran"] = 446,
	["Ameth'Aran"] = 447,
	["Grove of the Ancients"] = 448,
	["The Master's Glaive"] = 449,
	["Remtravel's Excavation"] = 450,
	["Mist's Edge"] = 452,
	["The Long Wash"] = 453,
	["Wildbend River"] = 454,
	["Blackwood Den"] = 455,
	["Cliffspring River"] = 456,
	["The Veiled Sea"] = 457,
	["Gold Road"] = 458,
	["Scarlet Watch Post"] = 459,
	["Sun Rock Retreat"] = 460,
	["Windshear Crag"] = 461,
	["Cragpool Lake"] = 463,
	["Mirkfallon Lake"] = 464,
	["The Charred Vale"] = 465,
	["Valley of the Bloodfuries"] = 466,
	["Stonetalon Peak"] = 467,
	["The Talon Den"] = 468,
	["Greatwood Vale"] = 469,
	["Thunder Bluff UNUSED"] = 470,
	["Brave Wind Mesa"] = 471,
	["Fire Stone Mesa"] = 472,
	["Mantle Rock"] = 473,
	["Hunter Rise UNUSED"] = 474,
	["Spirit RiseUNUSED"] = 475,
	["Elder RiseUNUSED"] = 476,
	["Ruins of Jubuwal"] = 477,
	["Pools of Arlithrien"] = 478,
	["The Rustmaul Dig Site"] = 479,
	["Camp E'thok"] = 480,
	["Splithoof Crag"] = 481,
	["Highperch"] = 482,
	["The Screeching Canyon"] = 483,
	["Freewind Post"] = 484,
	["The Great Lift"] = 485,
	["Galak Hold"] = 486,
	["Roguefeather Den"] = 487,
	["The Weathered Nook"] = 488,
	["Thalanaar"] = 489,
	["Un'Goro Crater"] = 490,
	["Razorfen Kraul"] = 491,
	["Raven Hill Cemetery"] = 492,
	["Moonglade"] = 493,
	["Howling Fjord"] = 495,
	["Brackenwall Village"] = 496,
	["Swamplight Manor"] = 497,
	["Bloodfen Burrow"] = 498,
	["Darkmist Cavern"] = 499,
	["Moggle Point"] = 500,
	["Beezil's Wreck"] = 501,
	["Witch Hill"] = 502,
	["Sentry Point"] = 503,
	["North Point Tower"] = 504,
	["West Point Tower"] = 505,
	["Lost Point"] = 506,
	["Bluefen"] = 507,
	["Stonemaul Ruins"] = 508,
	["The Den of Flame"] = 509,
	["The Dragonmurk"] = 510,
	["Wyrmbog"] = 511,
	["Blackhoof Village"] = 512,
	["Theramore Isle"] = 513,
	["Foothold Citadel"] = 514,
	["Ironclad Prison"] = 515,
	["Dustwallow Bay"] = 516,
	["Tidefury Cove"] = 517,
	["Dreadmurk Shore"] = 518,
	["Addle's Stead"] = 536,
	["Fire Plume Ridge"] = 537,
	["Lakkari Tar Pits"] = 538,
	["Terror Run"] = 539,
	["The Slithering Scar"] = 540,
	["Marshal's Refuge"] = 541,
	["Fungal Rock"] = 542,
	["Golakka Hot Springs"] = 543,
	["The Loch"] = 556,
	["Beggar's Haunt"] = 576,
	["Kodo Graveyard"] = 596,
	["Ghost Walker Post"] = 597,
	["Sar'theris Strand"] = 598,
	["Thunder Axe Fortress"] = 599,
	["Bolgan's Hole"] = 600,
	["Mannoroc Coven"] = 602,
	["Sargeron"] = 603,
	["Shok'Thokar"] = 604,
	["Gelkis Village"] = 606,
	["Valley of Spears"] = 607,
	["Nijel's Point"] = 608,
	["Kolkar Village"] = 609,
	["Mount Hyjal"] = 616,
	["Winterspring"] = 618,
	["Blackwolf River"] = 636,
	["Kodo Rock"] = 637,
	["Hidden Path"] = 638,
	["Spirit Rock"] = 639,
	["Shrine of the Dormant Flame"] = 640,
	["Lake Elune'ara"] = 656,
	["The Harborage"] = 657,
	["Outland"] = 676,
	["Craftsmen's Terrace UNUSED"] = 696,
	["Tradesmen's Terrace UNUSED"] = 697,
	["The Temple Gardens UNUSED"] = 698,
	["Temple of Elune UNUSED"] = 699,
	["Cenarion Enclave UNUSED"] = 700,
	["Warrior's Terrace UNUSED"] = 701,
	["Rut'theran Village"] = 702,
	["Ironband's Compound"] = 716,
	["The Stockade"] = 717,
	["Wailing Caverns"] = 718,
	["Blackfathom Deeps"] = 719,
	["Fray Island"] = 720,
	["Gnomeregan"] = 721,
	["Razorfen Downs"] = 722,
	["Ban'ethil Hollow"] = 736,
	["Scarlet Monastery"] = 796,
	["Jerod's Landing"] = 797,
	["Ridgepoint Tower"] = 798,
	["The Darkened Bank"] = 799,
	["Coldridge Pass"] = 800,
	["Chill Breeze Valley"] = 801,
	["Shimmer Ridge"] = 802,
	["Amberstill Ranch"] = 803,
	["The Tundrid Hills"] = 804,
	["South Gate Pass"] = 805,
	["South Gate Outpost"] = 806,
	["North Gate Pass"] = 807,
	["North Gate Outpost"] = 808,
	["Gates of Ironforge"] = 809,
	["Stillwater Pond"] = 810,
	["Nightmare Vale"] = 811,
	["Venomweb Vale"] = 812,
	["The Bulwark"] = 813,
	["Southfury River"] = 814,
	["Southfury River"] = 815,
	["Razormane Grounds"] = 816,
	["Skull Rock"] = 817,
	["Palemane Rock"] = 818,
	["Windfury Ridge"] = 819,
	["The Golden Plains"] = 820,
	["The Rolling Plains"] = 821,
	["Dun Algaz"] = 836,
	["Dun Algaz"] = 837,
	["North Gate Pass"] = 838,
	["South Gate Pass"] = 839,
	["Twilight Grove"] = 856,
	["GM Island"] = 876,
	["Delete ME"] = 877,
	["Southfury River"] = 878,
	["Southfury River"] = 879,
	["Thandol Span"] = 880,
	["Thandol Span"] = 881,
	["Purgation Isle"] = 896,
	["The Jansen Stead"] = 916,
	["The Dead Acre"] = 917,
	["The Molsen Farm"] = 918,
	["Stendel's Pond"] = 919,
	["The Dagger Hills"] = 920,
	["Demont's Place"] = 921,
	["The Dust Plains"] = 922,
	["Stonesplinter Valley"] = 923,
	["Valley of Kings"] = 924,
	["Algaz Station"] = 925,
	["Bucklebree Farm"] = 926,
	["The Shining Strand"] = 927,
	["North Tide's Beachhead"] = 928,
	["Grizzlepaw Ridge"] = 936,
	["The Verdant Fields"] = 956,
	["Gadgetzan"] = 976,
	["Steamwheedle Port"] = 977,
	["Zul'Farrak"] = 978,
	["Sandsorrow Watch"] = 979,
	["Thistleshrub Valley"] = 980,
	["The Gaping Chasm"] = 981,
	["The Noxious Lair"] = 982,
	["Dunemaul Compound"] = 983,
	["Eastmoon Ruins"] = 984,
	["Waterspring Field"] = 985,
	["Zalashji's Den"] = 986,
	["Land's End Beach"] = 987,
	["Wavestrider Beach"] = 988,
	["Ruins of Uldum"] = 989,
	["Valley of the Watchers"] = 990,
	["Gunstan's Post"] = 991,
	["Southmoon Ruins"] = 992,
	["Render's Camp"] = 996,
	["Render's Valley"] = 997,
	["Render's Rock"] = 998,
	["Stonewatch Tower"] = 999,
	["Galardell Valley"] = 1000,
	["Lakeridge Highway"] = 1001,
	["Three Corners"] = 1002,
	["Direforge Hill"] = 1016,
	["Raptor Ridge"] = 1017,
	["Black Channel Marsh"] = 1018,
	["The Green Belt"] = 1019,
	["Mosshide Fen"] = 1020,
	["Thelgen Rock"] = 1021,
	["Bluegill Marsh"] = 1022,
	["Saltspray Glen"] = 1023,
	["Sundown Marsh"] = 1024,
	["The Green Belt"] = 1025,
	["Angerfang Encampment"] = 1036,
	["Grim Batol"] = 1037,
	["Dragonmaw Gates"] = 1038,
	["The Lost Fleet"] = 1039,
	["Darrow Hill"] = 1056,
	["Thoradin's Wall"] = 1057,
	["Webwinder Path"] = 1076,
	["The Hushed Bank"] = 1097,
	["Manor Mistmantle"] = 1098,
	["Camp Mojache"] = 1099,
	["Grimtotem Compound"] = 1100,
	["The Writhing Deep"] = 1101,
	["Wildwind Lake"] = 1102,
	["Gordunni Outpost"] = 1103,
	["Mok'Gordun"] = 1104,
	["Feral Scar Vale"] = 1105,
	["Frayfeather Highlands"] = 1106,
	["Idlewind Lake"] = 1107,
	["The Forgotten Coast"] = 1108,
	["East Pillar"] = 1109,
	["West Pillar"] = 1110,
	["Dream Bough"] = 1111,
	["Jademir Lake"] = 1112,
	["Oneiros"] = 1113,
	["Ruins of Ravenwind"] = 1114,
	["Rage Scar Hold"] = 1115,
	["Ruins of Feathermoon"] = 1116,
	["Ruins of Solarsal"] = 1117,
	["Lower Wilds UNUSED"] = 1118,
	["The Twin Colossals"] = 1119,
	["Sardor Isle"] = 1120,
	["Isle of Dread"] = 1121,
	["High Wilderness"] = 1136,
	["Lower Wilds"] = 1137,
	["Southern Barrens [UNUSED]"] = 1156,
	["Southern Gold Road"] = 1157,
	["Zul'Farrak"] = 1176,
	["Utgarde Pinnacle"] = 1196,
	["Blackmaw Hold"] = 1216,
	["Vanndir Encampment"] = 1217,
	["TESTAzshara"] = 1218,
	["Legash Encampment"] = 1219,
	["Darnassian Base Camp"] = 1220,
	["Ruins of Eldarath"] = 1221,
	["Hetaera's Clutch"] = 1222,
	["Temple of Zin-Malor"] = 1223,
	["Bear's Head"] = 1224,
	["Ursolan"] = 1225,
	["Ruins of Arkkoran"] = 1226,
	["Bay of Storms"] = 1227,
	["The Shattered Strand"] = 1228,
	["Tower of Eldara"] = 1229,
	["Jagged Reef"] = 1230,
	["Southridge Beach"] = 1231,
	["Ravencrest Monument"] = 1232,
	["Forlorn Ridge"] = 1233,
	["Lake Mennar"] = 1234,
	["Shadowsong Shrine"] = 1235,
	["Haldarr Encampment"] = 1236,
	["Valormok"] = 1237,
	["The Ruined Reaches"] = 1256,
	["Talondeep Vale"] = 1276,
	["The Talondeep Path"] = 1277,
	["Rocktusk Farm"] = 1296,
	["Jaggedswine Farm"] = 1297,
	["Razorfen Downs [UNUSED]"] = 1316,
	["Lost Rigger Cove"] = 1336,
	["Uldaman"] = 1337,
	["Lordamere Lake"] = 1338,
	["Lordamere Lake"] = 1339,
	["Gallows' Corner"] = 1357,
	["Silithus"] = 1377,
	["Emerald Forest"] = 1397,
	["Sunken Temple"] = 1417,
	["Dreadmaul Hold"] = 1437,
	["Nethergarde Keep"] = 1438,
	["Dreadmaul Post"] = 1439,
	["Serpent's Coil"] = 1440,
	["Altar of Storms"] = 1441,
	["Firewatch Ridge"] = 1442,
	["The Slag Pit"] = 1443,
	["The Sea of Cinders"] = 1444,
	["Blackrock Mountain"] = 1445,
	["Thorium Point"] = 1446,
	["Nethergarde Mines"] = 1457,
	["The Temple of Atal'Hakkar"] = 1477,
	["Undercity"] = 1497,
	["Uldaman"] = 1517,
	["Not Used Deadmines"] = 1518,
	["Stormwind City"] = 1519,
	["Ironforge"] = 1537,
	["Splithoof Hold"] = 1557,
	["Cape of Stranglethorn"] = 1577,
	["Southern Savage Coast"] = 1578,
	["Unused The Deadmines 002"] = 1579,
	["Unused Ironclad Cove 003"] = 1580,
	["The Deadmines"] = 1581,
	["Ironclad Cove"] = 1582,
	["Blackrock Spire"] = 1583,
	["Blackrock Depths"] = 1584,
	["Raptor Grounds UNUSED"] = 1597,
	["Grol'dom Farm UNUSED"] = 1598,
	["Mor'shan Base Camp"] = 1599,
	["Honor's Stand UNUSED"] = 1600,
	["Blackthorn Ridge UNUSED"] = 1601,
	["Bramblescar UNUSED"] = 1602,
	["Agama'gor UNUSED"] = 1603,
	["Valley of Heroes"] = 1617,
	["Orgrimmar"] = 1637,
	["Thunder Bluff"] = 1638,
	["Elder Rise"] = 1639,
	["Spirit Rise"] = 1640,
	["Hunter Rise"] = 1641,
	["Darnassus"] = 1657,
	["Cenarion Enclave"] = 1658,
	["Craftsmen's Terrace"] = 1659,
	["Warrior's Terrace"] = 1660,
	["The Temple Gardens"] = 1661,
	["Tradesmen's Terrace"] = 1662,
	["Gavin's Naze"] = 1677,
	["Sofera's Naze"] = 1678,
	["Corrahn's Dagger"] = 1679,
	["The Headland"] = 1680,
	["Misty Shore"] = 1681,
	["Dandred's Fold"] = 1682,
	["Growless Cave"] = 1683,
	["Chillwind Point"] = 1684,
	["Raptor Grounds [UNUSED]"] = 1697,
	["Bramblescar"] = 1698,
	["Thorn Hill"] = 1699,
	["Agama'gor [UNUSED]"] = 1700,
	["Blackthorn Ridge [UNUSED]"] = 1701,
	["Honor's Stand"] = 1702,
	["The Mor'shan Rampart"] = 1703,
	["Grol'dom Farm"] = 1704,
	["Razorfen Kraul"] = 1717,
	["The Great Lift [UNUSED]"] = 1718,
	["Mistvale Valley"] = 1737,
	["Nek'mani Wellspring"] = 1738,
	["Hardwrench Hideaway"] = 1739,
	["Venture Co. Base Camp"] = 1740,
	["Gurubashi Arena"] = 1741,
	["Spirit Den"] = 1742,
	["The Crimson Veil"] = 1757,
	["The Riptide"] = 1758,
	["The Damsel's Luck"] = 1759,
	["Venture Co. Operations Center"] = 1760,
	["Deadwood Village"] = 1761,
	["Felpaw Village"] = 1762,
	["Jaedenar"] = 1763,
	["Bloodvenom River"] = 1764,
	["Bloodvenom Falls"] = 1765,
	["Shatter Scar Vale"] = 1766,
	["Irontree Woods"] = 1767,
	["Irontree Cavern"] = 1768,
	["Timbermaw Hold"] = 1769,
	["Shadow Hold"] = 1770,
	["Shrine of the Deceiver"] = 1771,
	["Purespring Cavern"] = 1777,
	["Sorrowmurk"] = 1778,
	["Draenil'dur Village"] = 1779,
	["Splinterspear Junction"] = 1780,
	["Stagalbog"] = 1797,
	["The Shifting Mire"] = 1798,
	["Stagalbog Cave"] = 1817,
	["Witherbark Caverns"] = 1837,
	["Thoradin's Wall"] = 1857,
	["Boulder'gor"] = 1858,
	["Valley of Fangs"] = 1877,
	["The Dustbowl"] = 1878,
	["Mirage Flats"] = 1879,
	["Featherbeard's Hovel"] = 1880,
	["Shindigger's Camp"] = 1881,
	["Plaguemist Ravine"] = 1882,
	["Valorwind Lake"] = 1883,
	["Agol'watha"] = 1884,
	["Hiri'watha Research Station"] = 1885,
	["The Creeping Ruin"] = 1886,
	["Bogen's Ledge"] = 1887,
	["The Maker's Terrace"] = 1897,
	["Dustwind Gulch"] = 1898,
	["Shaol'watha"] = 1917,
	["Noonshade Ruins"] = 1937,
	["Broken Pillar"] = 1938,
	["Abyssal Sands"] = 1939,
	["Southbreak Shore"] = 1940,
	["Caverns of Time"] = 1941,
	["The Marshlands"] = 1942,
	["Ironstone Plateau"] = 1943,
	["Blackchar Cave"] = 1957,
	["Tanner Camp"] = 1958,
	["Dustfire Valley"] = 1959,
	["Zul'Gurub"] = 1977,
	["Misty Reed Farm"] = 1978,
	["Bloodvenom Post"] = 1997,
	["Talonbranch Glade"] = 1998,
	["Stratholme"] = 2017,
	["Quel'thalas"] = 2037,
	["ScholomanceOLD"] = 2057,
	["Twilight Vale"] = 2077,
	["Twilight Shore"] = 2078,
	["Alcaz Island"] = 2079,
	["Darkcloud Pinnacle"] = 2097,
	["Dawning Wood Catacombs"] = 2098,
	["Stonewatch Keep"] = 2099,
	["Maraudon"] = 2100,
	["Stoutlager Inn"] = 2101,
	["Thunderbrew Distillery"] = 2102,
	["Menethil Keep"] = 2103,
	["Deepwater Tavern"] = 2104,
	["Shadow Grave"] = 2117,
	["Brill Town Hall"] = 2118,
	["Gallows' End Tavern"] = 2119,
	["The Pools of VisionUNUSED"] = 2137,
	["Dreadmist Den"] = 2138,
	["Bael'dun Keep [UNUSED]"] = 2157,
	["Emberstrife's Den"] = 2158,
	["Onyxia's Lair"] = 2159,
	["Windshear Mine"] = 2160,
	["Roland's Doom"] = 2161,
	["Battle Ring"] = 2177,
	["The Pools of Vision"] = 2197,
	["Shadowbreak Ravine"] = 2198,
	["Broken Spear Village"] = 2217,
	["Whitereach Post"] = 2237,
	["Gornia"] = 2238,
	["Zane's Eye Crater"] = 2239,
	["Mirage Raceway"] = 2240,
	["Frostsaber Rock"] = 2241,
	["The Hidden Grove"] = 2242,
	["Timbermaw Post"] = 2243,
	["Winterfall Village"] = 2244,
	["Mazthoril"] = 2245,
	["Frostfire Hot Springs"] = 2246,
	["Ice Thistle Hills"] = 2247,
	["Dun Mandarr"] = 2248,
	["Frostwhisper Gorge"] = 2249,
	["Owl Wing Thicket"] = 2250,
	["Lake Kel'Theril"] = 2251,
	["The Ruins of Kel'Theril"] = 2252,
	["Starfall Village"] = 2253,
	["Ban'Thallow Barrow Den"] = 2254,
	["Everlook"] = 2255,
	["Darkwhisper Gorge"] = 2256,
	["Deeprun Tram"] = 2257,
	["The Fungal Vale"] = 2258,
	["UNUSEDThe Marris Stead"] = 2259,
	["The Marris Stead"] = 2260,
	["The Undercroft"] = 2261,
	["Darrowshire"] = 2262,
	["Crown Guard Tower"] = 2263,
	["Corin's Crossing"] = 2264,
	["Death Cultist Base Camp"] = 2265,
	["Tyr's Hand"] = 2266,
	["The Scarlet Basilica"] = 2267,
	["Light's Hope Chapel"] = 2268,
	["Browman Mill"] = 2269,
	["The Noxious Glade"] = 2270,
	["Eastwall Tower"] = 2271,
	["Northdale"] = 2272,
	["Zul'Mashar"] = 2273,
	["Mazra'Alor"] = 2274,
	["Northpass Tower"] = 2275,
	["Quel'Lithien Lodge"] = 2276,
	["Plaguewood"] = 2277,
	["Scourgehold"] = 2278,
	["Stratholme"] = 2279,
	["DO NOT USE"] = 2280,
	["Darrowmere Lake"] = 2297,
	["Caer Darrow"] = 2298,
	["Darrowmere Lake"] = 2299,
	["Caverns of Time"] = 2300,
	["Thistlefur Village"] = 2301,
	["The Quagmire"] = 2302,
	["Windbreak Canyon"] = 2303,
	["South Seas"] = 2317,
	["The Great Sea"] = 2318,
	["The Great Sea"] = 2319,
	["The Great Sea"] = 2320,
	["The Great Sea"] = 2321,
	["The Veiled Sea"] = 2322,
	["The Veiled Sea"] = 2323,
	["The Veiled Sea"] = 2324,
	["The Veiled Sea"] = 2325,
	["The Veiled Sea"] = 2326,
	["Razor Hill Barracks"] = 2337,
	["South Seas"] = 2338,
	["The Great Sea"] = 2339,
	["Bloodtooth Camp"] = 2357,
	["Forest Song"] = 2358,
	["Greenpaw Village"] = 2359,
	["Silverwing Outpost"] = 2360,
	["Nighthaven"] = 2361,
	["Shrine of Remulos"] = 2362,
	["Stormrage Barrow Dens"] = 2363,
	["The Great Sea"] = 2364,
	["The Great Sea"] = 2365,
	["The Black Morass"] = 2366,
	["Old Hillsbrad Foothills"] = 2367,
	["Tarren Mill"] = 2368,
	["Southshore"] = 2369,
	["Durnholde Keep"] = 2370,
	["Dun Garok"] = 2371,
	["Hillsbrad Fields"] = 2372,
	["Eastern Strand"] = 2373,
	["Nethander Stead"] = 2374,
	["Darrow Hill"] = 2375,
	["Southpoint Tower"] = 2376,
	["Thoradin's Wall"] = 2377,
	["Western Strand"] = 2378,
	["Azurelode Mine"] = 2379,
	["The Great Sea"] = 2397,
	["The Great Sea"] = 2398,
	["The Great Sea"] = 2399,
	["The Forbidding Sea"] = 2400,
	["The Forbidding Sea"] = 2401,
	["The Forbidding Sea"] = 2402,
	["The Forbidding Sea"] = 2403,
	["Tethris Aran"] = 2404,
	["Ethel Rethor"] = 2405,
	["Ranazjar Isle"] = 2406,
	["Kormek's Hut"] = 2407,
	["Shadowprey Village"] = 2408,
	["Blackrock Pass"] = 2417,
	["Morgan's Vigil"] = 2418,
	["Slither Rock"] = 2419,
	["Terror Wing Path"] = 2420,
	["Draco'dar"] = 2421,
	["Ragefire Chasm"] = 2437,
	["Nightsong Woods"] = 2457,
	["The Veiled Sea"] = 2477,
	["Morlos'Aran"] = 2478,
	["Emerald Sanctuary"] = 2479,
	["Jadefire Glen"] = 2480,
	["Ruins of Constellas"] = 2481,
	["Bitter Reaches"] = 2497,
	["Rise of the Defiler"] = 2517,
	["Lariss Pavilion"] = 2518,
	["Woodpaw Hills"] = 2519,
	["Woodpaw Den"] = 2520,
	["Verdantis River"] = 2521,
	["Ruins of Isildien"] = 2522,
	["Grimtotem Post"] = 2537,
	["Camp Aparaje"] = 2538,
	["Malaka'jin"] = 2539,
	["Boulderslide Ravine"] = 2540,
	["Sishir Canyon"] = 2541,
	["Dire Maul"] = 2557,
	["Deadwind Ravine"] = 2558,
	["Diamondhead River"] = 2559,
	["Ariden's Camp"] = 2560,
	["The Vice"] = 2561,
	["Karazhan"] = 2562,
	["Morgan's Plot"] = 2563,
	["Dire Maul"] = 2577,
	["Alterac Valley"] = 2597,
	["Scrabblescrew's Camp"] = 2617,
	["Jadefire Run"] = 2618,
	["Thondroril River"] = 2619,
	["Thondroril River"] = 2620,
	["Lake Mereldar"] = 2621,
	["Pestilent Scar"] = 2622,
	["The Infectis Scar"] = 2623,
	["Blackwood Lake"] = 2624,
	["Eastwall Gate"] = 2625,
	["Terrorweb Tunnel"] = 2626,
	["Terrordale"] = 2627,
	["Kargathia Keep"] = 2637,
	["Valley of Bones"] = 2657,
	["Blackwing Lair"] = 2677,
	["Deadman's Crossing"] = 2697,
	["Molten Core"] = 2717,
	["The Scarab Wall"] = 2737,
	["Southwind Village"] = 2738,
	["Twilight Base Camp"] = 2739,
	["The Crystal Vale"] = 2740,
	["The Scarab Dais"] = 2741,
	["Hive'Ashi"] = 2742,
	["Hive'Zora"] = 2743,
	["Hive'Regal"] = 2744,
	["Shrine of the Fallen Warrior"] = 2757,
	["UNUSED Alterac Valley"] = 2777,
	["Blackfathom Deeps"] = 2797,
	["Crystalsong Forest"] = 2817,
	["The Master's Cellar"] = 2837,
	["Stonewrought Pass"] = 2838,
	["Alterac Valley"] = 2839,
	["The Rumble Cage"] = 2857,
	["Chunk Test"] = 2877,
	["Zoram'gar Outpost"] = 2897,
	["Hall of Legends"] = 2917,
	["Champions' Hall"] = 2918,
	["Grosh'gok Compound"] = 2937,
	["Sleeping Gorge"] = 2938,
	["Irondeep Mine"] = 2957,
	["Stonehearth Outpost"] = 2958,
	["Dun Baldar"] = 2959,
	["Icewing Pass"] = 2960,
	["Frostwolf Village"] = 2961,
	["Tower Point"] = 2962,
	["Coldtooth Mine"] = 2963,
	["Winterax Hold"] = 2964,
	["Iceblood Garrison"] = 2977,
	["Frostwolf Keep"] = 2978,
	["Tor'kren Farm"] = 2979,
	["Frost Dagger Pass"] = 3017,
	["Ironstone Camp"] = 3037,
	["Weazel's Crater"] = 3038,
	["Tahonda Ruins"] = 3039,
	["Field of Strife"] = 3057,
	["Icewing Cavern"] = 3058,
	["Valor's Rest"] = 3077,
	["The Swarming Pillar"] = 3097,
	["Twilight Post"] = 3098,
	["Twilight Outpost"] = 3099,
	["Ravaged Twilight Camp"] = 3100,
	["Shalzaru's Lair"] = 3117,
	["Talrendis Point"] = 3137,
	["Rethress Sanctum"] = 3138,
	["Moon Horror Den"] = 3139,
	["Scalebeard's Cave"] = 3140,
	["Boulderslide Cavern"] = 3157,
	["Warsong Labor Camp"] = 3177,
	["Chillwind Camp"] = 3197,
	["The Maul"] = 3217,
	["The Maul UNUSED"] = 3237,
	["Bones of Grakkarond"] = 3257,
	["Warsong Gulch"] = 3277,
	["Frostwolf Graveyard"] = 3297,
	["Frostwolf Pass"] = 3298,
	["Dun Baldar Pass"] = 3299,
	["Iceblood Graveyard"] = 3300,
	["Snowfall Graveyard"] = 3301,
	["Stonehearth Graveyard"] = 3302,
	["Stormpike Graveyard"] = 3303,
	["Icewing Bunker"] = 3304,
	["Stonehearth Bunker"] = 3305,
	["Wildpaw Ridge"] = 3306,
	["Revantusk Village"] = 3317,
	["Rock of Durotan"] = 3318,
	["Silverwing Grove"] = 3319,
	["Warsong Lumber Mill"] = 3320,
	["Silverwing Hold"] = 3321,
	["Wildpaw Cavern"] = 3337,
	["The Veiled Cleft"] = 3338,
	["Yojamba Isle"] = 3357,
	["Arathi Basin"] = 3358,
	["The Coil"] = 3377,
	["Mandokir's Domain"] = 3378,
	["Altar of the Blood God"] = 3380,
	["Temple of Bethekk"] = 3382,
	["The Devil's Terrace"] = 3384,
	["The Cache of Madness"] = 3398,
	["Trollbane Hall"] = 3417,
	["Defiler's Den"] = 3418,
	["Farm"] = 3420,
	["Blacksmith"] = 3421,
	["Lumber Mill"] = 3422,
	["Gold Mine"] = 3423,
	["Stables"] = 3424,
	["Cenarion Hold"] = 3425,
	["Staghelm Point"] = 3426,
	["Bronzebeard Encampment"] = 3427,
	["Ahn'Qiraj"] = 3428,
	["Ruins of Ahn'Qiraj"] = 3429,
	["Eversong Woods"] = 3430,
	["Sunstrider Isle"] = 3431,
	["Shrine of Dath'Remar"] = 3432,
	["Ghostlands"] = 3433,
	["Scarab Terrace"] = 3434,
	["General's Terrace"] = 3435,
	["The Reservoir"] = 3436,
	["The Hatchery"] = 3437,
	["The Comb"] = 3438,
	["Watchers' Terrace"] = 3439,
	["Scarab Terrace"] = 3440,
	["General's Terrace"] = 3441,
	["The Reservoir"] = 3442,
	["The Hatchery"] = 3443,
	["The Comb"] = 3444,
	["Watchers' Terrace"] = 3445,
	["Twilight's Run"] = 3446,
	["Ortell's Hideout"] = 3447,
	["Scarab Terrace"] = 3448,
	["General's Terrace"] = 3449,
	["The Reservoir"] = 3450,
	["The Hatchery"] = 3451,
	["The Comb"] = 3452,
	["Watchers' Terrace"] = 3453,
	["Ruins of Ahn'Qiraj"] = 3454,
	["The North Sea"] = 3455,
	["Naxxramas"] = 3456,
	["Karazhan"] = 3457,
	["City"] = 3459,
	["Golden Strand"] = 3460,
	["Sunsail Anchorage"] = 3461,
	["Fairbreeze Village"] = 3462,
	["Magisters Gate"] = 3463,
	["Farstrider Retreat"] = 3464,
	["North Sanctum"] = 3465,
	["West Sanctum"] = 3466,
	["East Sanctum"] = 3467,
	["Saltheril's Haven"] = 3468,
	["Thuron's Livery"] = 3469,
	["Stillwhisper Pond"] = 3470,
	["The Living Wood"] = 3471,
	["Azurebreeze Coast"] = 3472,
	["Lake Elrendar"] = 3473,
	["The Scorched Grove"] = 3474,
	["Zeb'Watha"] = 3475,
	["Tor'Watha"] = 3476,
	["Azjol-Nerub"] = 3477,
	["Gates of Ahn'Qiraj"] = 3478,
	["The Veiled Sea"] = 3479,
	["Duskwither Grounds"] = 3480,
	["Duskwither Spire"] = 3481,
	["The Dead Scar"] = 3482,
	["Hellfire Peninsula"] = 3483,
	["The Sunspire"] = 3484,
	["Falthrien Academy"] = 3485,
	["Ravenholdt Manor"] = 3486,
	["Silvermoon City"] = 3487,
	["Tranquillien"] = 3488,
	["Suncrown Village"] = 3489,
	["Goldenmist Village"] = 3490,
	["Windrunner Village"] = 3491,
	["Windrunner Spire"] = 3492,
	["Sanctum of the Sun"] = 3493,
	["Sanctum of the Moon"] = 3494,
	["Dawnstar Spire"] = 3495,
	["Farstrider Enclave"] = 3496,
	["An'daroth"] = 3497,
	["An'telas"] = 3498,
	["An'owyn"] = 3499,
	["Deatholme"] = 3500,
	["Bleeding Ziggurat"] = 3501,
	["Howling Ziggurat"] = 3502,
	["Shalandis Isle"] = 3503,
	["Toryl Estate"] = 3504,
	["Underlight Mines"] = 3505,
	["Andilien Estate"] = 3506,
	["Hatchet Hills"] = 3507,
	["Amani Pass"] = 3508,
	["Sungraze Peak"] = 3509,
	["Amani Catacombs"] = 3510,
	["Tower of the Damned"] = 3511,
	["Zeb'Sora"] = 3512,
	["Lake Elrendar"] = 3513,
	["The Dead Scar"] = 3514,
	["Elrendar River"] = 3515,
	["Zeb'Tela"] = 3516,
	["Zeb'Nowa"] = 3517,
	["Nagrand"] = 3518,
	["Terokkar Forest"] = 3519,
	["Shadowmoon Valley"] = 3520,
	["Zangarmarsh"] = 3521,
	["Blade's Edge Mountains"] = 3522,
	["Netherstorm"] = 3523,
	["Azuremyst Isle"] = 3524,
	["Bloodmyst Isle"] = 3525,
	["Ammen Vale"] = 3526,
	["Crash Site"] = 3527,
	["Silverline Lake"] = 3528,
	["Nestlewood Thicket"] = 3529,
	["Shadow Ridge"] = 3530,
	["Skulking Row"] = 3531,
	["Dawning Lane"] = 3532,
	["Ruins of Silvermoon"] = 3533,
	["Feth's Way"] = 3534,
	["Thrallmar"] = 3536,
	["Borean Tundra"] = 3537,
	["Honor Hold"] = 3538,
	["The Stair of Destiny"] = 3539,
	["Twisting Nether"] = 3540,
	["Forge Camp: Mageddon"] = 3541,
	["The Path of Glory"] = 3542,
	["The Great Fissure"] = 3543,
	["Plain of Shards"] = 3544,
	["Hellfire Citadel"] = 3545,
	["Expedition Armory"] = 3546,
	["Throne of Kil'jaeden"] = 3547,
	["Forge Camp: Rage"] = 3548,
	["Invasion Point: Annihilator"] = 3549,
	["Borune Ruins"] = 3550,
	["Ruins of Sha'naar"] = 3551,
	["Temple of Telhamat"] = 3552,
	["Pools of Aggonar"] = 3553,
	["Falcon Watch"] = 3554,
	["Mag'har Post"] = 3555,
	["Den of Haal'esh"] = 3556,
	["The Exodar"] = 3557,
	["Elrendar Falls"] = 3558,
	["Nestlewood Hills"] = 3559,
	["Ammen Fields"] = 3560,
	["The Sacred Grove"] = 3561,
	["Hellfire Ramparts"] = 3562,
	["Hellfire Citadel"] = 3563,
	["Emberglade"] = 3564,
	["Cenarion Refuge"] = 3565,
	["Moonwing Den"] = 3566,
	["Pod Cluster"] = 3567,
	["Pod Wreckage"] = 3568,
	["Tides' Hollow"] = 3569,
	["Wrathscale Point"] = 3570,
	["Bristlelimb Village"] = 3571,
	["Stillpine Hold"] = 3572,
	["Odesyus' Landing"] = 3573,
	["Valaar's Berth"] = 3574,
	["Silting Shore"] = 3575,
	["Azure Watch"] = 3576,
	["Geezle's Camp"] = 3577,
	["Menagerie Wreckage"] = 3578,
	["Traitor's Cove"] = 3579,
	["Wildwind Peak"] = 3580,
	["Wildwind Path"] = 3581,
	["Zeth'Gor"] = 3582,
	["Beryl Coast"] = 3583,
	["Blood Watch"] = 3584,
	["Bladewood"] = 3585,
	["The Vector Coil"] = 3586,
	["The Warp Piston"] = 3587,
	["The Cryo-Core"] = 3588,
	["The Crimson Reach"] = 3589,
	["Wrathscale Lair"] = 3590,
	["Ruins of Loreth'Aran"] = 3591,
	["Nazzivian"] = 3592,
	["Axxarien"] = 3593,
	["Blacksilt Shore"] = 3594,
	["The Foul Pool"] = 3595,
	["The Hidden Reef"] = 3596,
	["Amberweb Pass"] = 3597,
	["Wyrmscar Island"] = 3598,
	["Talon Stand"] = 3599,
	["Bristlelimb Enclave"] = 3600,
	["Ragefeather Ridge"] = 3601,
	["Kessel's Crossing"] = 3602,
	["Tel'athion's Camp"] = 3603,
	["The Bloodcursed Reef"] = 3604,
	["Hyjal Past"] = 3605,
	["Hyjal Summit"] = 3606,
	["Serpentshrine Cavern"] = 3607,
	["Vindicator's Rest"] = 3608,
	["Unused3"] = 3609,
	["Burning Blade Ruins"] = 3610,
	["Clan Watch"] = 3611,
	["Bloodcurse Isle"] = 3612,
	["Garadar"] = 3613,
	["Skysong Lake"] = 3614,
	["Throne of the Elements"] = 3615,
	["Laughing Skull Ruins"] = 3616,
	["Warmaul Hill"] = 3617,
	["Gruul's Lair"] = 3618,
	["Auren Ridge"] = 3619,
	["Auren Falls"] = 3620,
	["Lake Sunspring"] = 3621,
	["Sunspring Post"] = 3622,
	["Aeris Landing"] = 3623,
	["Forge Camp: Fear"] = 3624,
	["Forge Camp: Hate"] = 3625,
	["Telaar"] = 3626,
	["Northwind Cleft"] = 3627,
	["Halaa"] = 3628,
	["Southwind Cleft"] = 3629,
	["Oshu'gun"] = 3630,
	["Spirit Fields"] = 3631,
	["Shamanar"] = 3632,
	["Ancestral Grounds"] = 3633,
	["Windyreed Village"] = 3634,
	["Unused2"] = 3635,
	["Elemental Plateau"] = 3636,
	["Kil'sorrow Fortress"] = 3637,
	["The Ring of Trials"] = 3638,
	["Silvermyst Isle"] = 3639,
	["Daggerfen Village"] = 3640,
	["Umbrafen Village"] = 3641,
	["Feralfen Village"] = 3642,
	["Bloodscale Enclave"] = 3643,
	["Telredor"] = 3644,
	["Zabra'jin"] = 3645,
	["Quagg Ridge"] = 3646,
	["The Spawning Glen"] = 3647,
	["The Dead Mire"] = 3648,
	["Sporeggar"] = 3649,
	["Ango'rosh Grounds"] = 3650,
	["Ango'rosh Stronghold"] = 3651,
	["Funggor Cavern"] = 3652,
	["Serpent Lake"] = 3653,
	["The Drain"] = 3654,
	["Umbrafen Lake"] = 3655,
	["Marshlight Lake"] = 3656,
	["Portal Clearing"] = 3657,
	["Sporewind Lake"] = 3658,
	["The Lagoon"] = 3659,
	["Blades' Run"] = 3660,
	["Blade Tooth Canyon"] = 3661,
	["Commons Hall"] = 3662,
	["Derelict Manor"] = 3663,
	["Huntress of the Sun"] = 3664,
	["Falconwing Square"] = 3665,
	["Halaani Basin"] = 3666,
	["Hewn Bog"] = 3667,
	["Boha'mu Ruins"] = 3668,
	["The Stadium"] = 3669,
	["The Overlook"] = 3670,
	["Broken Hill"] = 3671,
	["Mag'hari Procession"] = 3672,
	["Nesingwary Safari"] = 3673,
	["Cenarion Thicket"] = 3674,
	["Tuurem"] = 3675,
	["Veil Shienor"] = 3676,
	["Veil Skith"] = 3677,
	["Veil Shalas"] = 3678,
	["Skettis"] = 3679,
	["Blackwind Valley"] = 3680,
	["Firewing Point"] = 3681,
	["Grangol'var Village"] = 3682,
	["Stonebreaker Hold"] = 3683,
	["Allerian Stronghold"] = 3684,
	["Bonechewer Ruins"] = 3685,
	["Veil Lithic"] = 3686,
	["Olembas"] = 3687,
	["Auchindoun"] = 3688,
	["Veil Reskk"] = 3689,
	["Blackwind Lake"] = 3690,
	["Lake Ere'Noru"] = 3691,
	["Lake Jorune"] = 3692,
	["Skethyl Mountains"] = 3693,
	["Misty Ridge"] = 3694,
	["The Broken Hills"] = 3695,
	["The Barrier Hills"] = 3696,
	["The Bone Wastes"] = 3697,
	["Nagrand Arena"] = 3698,
	["Laughing Skull Courtyard"] = 3699,
	["The Ring of Blood"] = 3700,
	["Arena Floor"] = 3701,
	["Blade's Edge Arena"] = 3702,
	["Shattrath City"] = 3703,
	["The Shepherd's Gate"] = 3704,
	["Telaari Basin"] = 3705,
	["The Dark Portal"] = 3706,
	["Alliance Base"] = 3707,
	["Horde Encampment"] = 3708,
	["Night Elf Village"] = 3709,
	["Nordrassil"] = 3710,
	["Sholazar Basin"] = 3711,
	["Area 52"] = 3712,
	["The Blood Furnace"] = 3713,
	["The Shattered Halls"] = 3714,
	["The Steamvault"] = 3715,
	["The Underbog"] = 3716,
	["The Slave Pens"] = 3717,
	["Swamprat Post"] = 3718,
	["Bleeding Hollow Ruins"] = 3719,
	["Twin Spire Ruins"] = 3720,
	["The Crumbling Waste"] = 3721,
	["Manaforge Ara"] = 3722,
	["Arklon Ruins"] = 3723,
	["Cosmowrench"] = 3724,
	["Ruins of Enkaat"] = 3725,
	["Manaforge B'naar"] = 3726,
	["The Scrap Field"] = 3727,
	["The Vortex Fields"] = 3728,
	["The Heap"] = 3729,
	["Manaforge Coruu"] = 3730,
	["The Tempest Rift"] = 3731,
	["Kirin'Var Village"] = 3732,
	["The Violet Tower"] = 3733,
	["Manaforge Duro"] = 3734,
	["Voidwind Plateau"] = 3735,
	["Manaforge Ultris"] = 3736,
	["Celestial Ridge"] = 3737,
	["The Stormspire"] = 3738,
	["Forge Base: Oblivion"] = 3739,
	["Forge Base: Gehenna"] = 3740,
	["Ruins of Farahlon"] = 3741,
	["Socrethar's Seat"] = 3742,
	["Legion Hold"] = 3743,
	["Shadowmoon Village"] = 3744,
	["Wildhammer Stronghold"] = 3745,
	["The Hand of Gul'dan"] = 3746,
	["The Fel Pits"] = 3747,
	["The Deathforge"] = 3748,
	["Coilskar Cistern"] = 3749,
	["Coilskar Point"] = 3750,
	["Sunfire Point"] = 3751,
	["Illidari Point"] = 3752,
	["Ruins of Baa'ri"] = 3753,
	["Altar of Sha'tar"] = 3754,
	["The Stair of Doom"] = 3755,
	["Ruins of Karabor"] = 3756,
	["Ata'mal Terrace"] = 3757,
	["Netherwing Fields"] = 3758,
	["Netherwing Ledge"] = 3759,
	["The Barrier Hills"] = 3760,
	["The High Path"] = 3761,
	["Windyreed Pass"] = 3762,
	["Zangar Ridge"] = 3763,
	["The Twilight Ridge"] = 3764,
	["Razorthorn Trail"] = 3765,
	["Orebor Harborage"] = 3766,
	["Blades' Run"] = 3767,
	["Jagged Ridge"] = 3768,
	["Thunderlord Stronghold"] = 3769,
	["Blade Tooth Canyon"] = 3770,
	["The Living Grove"] = 3771,
	["Sylvanaar"] = 3772,
	["Bladespire Hold"] = 3773,
	["Gruul's Lair"] = 3774,
	["Circle of Blood"] = 3775,
	["Bloodmaul Outpost"] = 3776,
	["Bloodmaul Camp"] = 3777,
	["Draenethyst Mine"] = 3778,
	["Trogma's Claim"] = 3779,
	["Blackwing Coven"] = 3780,
	["Grishnath"] = 3781,
	["Veil Lashh"] = 3782,
	["Veil Vekh"] = 3783,
	["Forge Camp: Terror"] = 3784,
	["Forge Camp: Wrath"] = 3785,
	["Ogri'la"] = 3786,
	["Forge Camp: Anger"] = 3787,
	["The Low Path"] = 3788,
	["Shadow Labyrinth"] = 3789,
	["Auchenai Crypts"] = 3790,
	["Sethekk Halls"] = 3791,
	["Mana-Tombs"] = 3792,
	["Felspark Ravine"] = 3793,
	["Valley of Bones"] = 3794,
	["Sha'naari Wastes"] = 3795,
	["The Warp Fields"] = 3796,
	["Fallen Sky Ridge"] = 3797,
	["Haal'eshi Gorge"] = 3798,
	["Stonewall Canyon"] = 3799,
	["Thornfang Hill"] = 3800,
	["Mag'har Grounds"] = 3801,
	["Void Ridge"] = 3802,
	["The Abyssal Shelf"] = 3803,
	["The Legion Front"] = 3804,
	["Zul'Aman"] = 3805,
	["Supply Caravan"] = 3806,
	["Reaver's Fall"] = 3807,
	["Cenarion Post"] = 3808,
	["Southern Rampart"] = 3809,
	["Northern Rampart"] = 3810,
	["Gor'gaz Outpost"] = 3811,
	["Spinebreaker Post"] = 3812,
	["The Path of Anguish"] = 3813,
	["East Supply Caravan"] = 3814,
	["Expedition Point"] = 3815,
	["Zeppelin Crash"] = 3816,
	["Testing"] = 3817,
	["Bloodscale Grounds"] = 3818,
	["Darkcrest Enclave"] = 3819,
	["Eye of the Storm"] = 3820,
	["Warden's Cage"] = 3821,
	["Eclipse Point"] = 3822,
	["Isle of Tribulations"] = 3823,
	["Bloodmaul Ravine"] = 3824,
	["Dragons' End"] = 3825,
	["Daggermaw Canyon"] = 3826,
	["Vekhaar Stand"] = 3827,
	["Ruuan Weald"] = 3828,
	["Veil Ruuan"] = 3829,
	["Raven's Wood"] = 3830,
	["Death's Door"] = 3831,
	["Vortex Summit"] = 3832,
	["Razor Ridge"] = 3833,
	["Ridge of Madness"] = 3834,
	["Dustquill Ravine"] = 3835,
	["Magtheridon's Lair"] = 3836,
	["Sunfury Hold"] = 3837,
	["Spinebreaker Mountains"] = 3838,
	["Abandoned Armory"] = 3839,
	["The Black Temple"] = 3840,
	["Darkcrest Shore"] = 3841,
	["Tempest Keep"] = 3842,
	["Mok'Nathal Village"] = 3844,
	["Tempest Keep"] = 3845,
	["The Arcatraz"] = 3846,
	["The Botanica"] = 3847,
	["The Arcatraz"] = 3848,
	["The Mechanar"] = 3849,
	["Netherstone"] = 3850,
	["Midrealm Post"] = 3851,
	["Tuluman's Landing"] = 3852,
	["Protectorate Watch Post"] = 3854,
	["Circle of Blood Arena"] = 3855,
	["Elrendar Crossing"] = 3856,
	["Ammen Ford"] = 3857,
	["Razorthorn Shelf"] = 3858,
	["Silmyr Lake"] = 3859,
	["Raastok Glade"] = 3860,
	["Thalassian Pass"] = 3861,
	["Churning Gulch"] = 3862,
	["Broken Wilds"] = 3863,
	["Bash'ir Landing"] = 3864,
	["Crystal Spine"] = 3865,
	["Skald"] = 3866,
	["Bladed Gulch"] = 3867,
	["Gyro-Plank Bridge"] = 3868,
	["Mage Tower"] = 3869,
	["Blood Elf Tower"] = 3870,
	["Draenei Ruins"] = 3871,
	["Fel Reaver Ruins"] = 3872,
	["The Proving Grounds"] = 3873,
	["Eco-Dome Farfield"] = 3874,
	["Eco-Dome Skyperch"] = 3875,
	["Eco-Dome Sutheron"] = 3876,
	["Eco-Dome Midrealm"] = 3877,
	["Ethereum Staging Grounds"] = 3878,
	["Chapel Yard"] = 3879,
	["Access Shaft Zeon"] = 3880,
	["Trelleum Mine"] = 3881,
	["Invasion Point: Destroyer"] = 3882,
	["Camp of Boom"] = 3883,
	["Spinebreaker Pass"] = 3884,
	["Netherweb Ridge"] = 3885,
	["Derelict Caravan"] = 3886,
	["Refugee Caravan"] = 3887,
	["Shadow Tomb"] = 3888,
	["Veil Rhaze"] = 3889,
	["Tomb of Lights"] = 3890,
	["Carrion Hill"] = 3891,
	["Writhing Mound"] = 3892,
	["Ring of Observance"] = 3893,
	["Auchenai Grounds"] = 3894,
	["Cenarion Watchpost"] = 3895,
	["Aldor Rise"] = 3896,
	["Terrace of Light"] = 3897,
	["Scryer's Tier"] = 3898,
	["Lower City"] = 3899,
	["Invasion Point: Overlord"] = 3900,
	["Allerian Post"] = 3901,
	["Stonebreaker Camp"] = 3902,
	["Boulder'mok"] = 3903,
	["Cursed Hollow"] = 3904,
	["Coilfang Reservoir"] = 3905,
	["The Bloodwash"] = 3906,
	["Veridian Point"] = 3907,
	["Middenvale"] = 3908,
	["The Lost Fold"] = 3909,
	["Mystwood"] = 3910,
	["Tranquil Shore"] = 3911,
	["Goldenbough Pass"] = 3912,
	["Runestone Falithas"] = 3913,
	["Runestone Shan'dor"] = 3914,
	["Fairbridge Strand"] = 3915,
	["Moongraze Woods"] = 3916,
	["Auchindoun"] = 3917,
	["Toshley's Station"] = 3918,
	["Singing Ridge"] = 3919,
	["Shatter Point"] = 3920,
	["Arklonis Ridge"] = 3921,
	["Bladespire Outpost"] = 3922,
	["Gruul's Lair"] = 3923,
	["Northmaul Tower"] = 3924,
	["Southmaul Tower"] = 3925,
	["Shattered Plains"] = 3926,
	["Oronok's Farm"] = 3927,
	["The Altar of Damnation"] = 3928,
	["The Path of Conquest"] = 3929,
	["Eclipsion Fields"] = 3930,
	["Bladespire Grounds"] = 3931,
	["Sketh'lon Base Camp"] = 3932,
	["Sketh'lon Wreckage"] = 3933,
	["Town Square"] = 3934,
	["Wizard Row"] = 3935,
	["Deathforge Tower"] = 3936,
	["Slag Watch"] = 3937,
	["Sanctum of the Stars"] = 3938,
	["Dragonmaw Fortress"] = 3939,
	["The Fetid Pool"] = 3940,
	["Test"] = 3941,
	["Razaan's Landing"] = 3942,
	["Invasion Point: Cataclysm"] = 3943,
	["The Altar of Shadows"] = 3944,
	["Netherwing Pass"] = 3945,
	["Wayne's Refuge"] = 3946,
	["The Scalding Pools"] = 3947,
	["Brian and Pat Test"] = 3948,
	["Magma Fields"] = 3949,
	["Crimson Watch"] = 3950,
	["Evergrove"] = 3951,
	["Wyrmskull Bridge"] = 3952,
	["Scalewing Shelf"] = 3953,
	["Wyrmskull Tunnel"] = 3954,
	["Hellfire Basin"] = 3955,
	["The Shadow Stair"] = 3956,
	["Sha'tari Outpost"] = 3957,
	["Sha'tari Base Camp"] = 3958,
	["Black Temple"] = 3959,
	["Soulgrinder's Barrow"] = 3960,
	["Sorrow Wing Point"] = 3961,
	["Vim'gol's Circle"] = 3962,
	["Dragonspine Ridge"] = 3963,
	["Skyguard Outpost"] = 3964,
	["Netherwing Mines"] = 3965,
	["Dragonmaw Base Camp"] = 3966,
	["Dragonmaw Skyway"] = 3967,
	["Ruins of Lordaeron"] = 3968,
	["Rivendark's Perch"] = 3969,
	["Obsidia's Perch"] = 3970,
	["Insidion's Perch"] = 3971,
	["Furywing's Perch"] = 3972,
	["Blackwind Landing"] = 3973,
	["Veil Harr'ik"] = 3974,
	["Terokk's Rest"] = 3975,
	["Veil Ala'rak"] = 3976,
	["Upper Veil Shil'ak"] = 3977,
	["Lower Veil Shil'ak"] = 3978,
	["The Frozen Sea"] = 3979,
	["Daggercap Bay"] = 3980,
	["Valgarde"] = 3981,
	["Wyrmskull Village"] = 3982,
	["Utgarde Keep"] = 3983,
	["Nifflevar"] = 3984,
	["Falls of Ymiron"] = 3985,
	["Echo Reach"] = 3986,
	["The Isle of Spears"] = 3987,
	["Kamagua"] = 3988,
	["Garvan's Reef"] = 3989,
	["Scalawag Point"] = 3990,
	["New Agamand"] = 3991,
	["The Ancient Lift"] = 3992,
	["Westguard Turret"] = 3993,
	["Halgrind"] = 3994,
	["The Laughing Stand"] = 3995,
	["Baelgun's Excavation Site"] = 3996,
	["Explorers' League Outpost"] = 3997,
	["Westguard Keep"] = 3998,
	["Steel Gate"] = 3999,
	["Vengeance Landing"] = 4000,
	["Baleheim"] = 4001,
	["Skorn"] = 4002,
	["Fort Wildervar"] = 4003,
	["Vileprey Village"] = 4004,
	["Ivald's Ruin"] = 4005,
	["Gjalerbron"] = 4006,
	["Tomb of the Lost Kings"] = 4007,
	["Shartuul's Transporter"] = 4008,
	["Illidari Training Grounds"] = 4009,
	["Mudsprocket"] = 4010,
	["Camp Winterhoof"] = 4018,
	["Development Land"] = 4019,
	["Mightstone Quarry"] = 4020,
	["Bloodspore Plains"] = 4021,
	["Gammoth"] = 4022,
	["Amber Ledge"] = 4023,
	["Coldarra"] = 4024,
	["The Westrift"] = 4025,
	["The Transitus Stair"] = 4026,
	["Coast of Echoes"] = 4027,
	["Riplash Strand"] = 4028,
	["Riplash Ruins"] = 4029,
	["Coast of Idols"] = 4030,
	["Pal'ea"] = 4031,
	["Valiance Keep"] = 4032,
	["Winterfin Village"] = 4033,
	["The Borean Wall"] = 4034,
	["The Geyser Fields"] = 4035,
	["Fizzcrank Pumping Station"] = 4036,
	["Taunka'le Village"] = 4037,
	["Magnamoth Caverns"] = 4038,
	["Coldrock Quarry"] = 4039,
	["Njord's Breath Bay"] = 4040,
	["Kaskala"] = 4041,
	["Transborea"] = 4042,
	["The Flood Plains"] = 4043,
	["Direhorn Post"] = 4046,
	["Nat's Landing"] = 4047,
	["Ember Clutch"] = 4048,
	["Tabetha's Farm"] = 4049,
	["Derelict Strand"] = 4050,
	["The Frozen Glade"] = 4051,
	["The Vibrant Glade"] = 4052,
	["The Twisted Glade"] = 4053,
	["Rivenwood"] = 4054,
	["Caldemere Lake"] = 4055,
	["Utgarde Catacombs"] = 4056,
	["Shield Hill"] = 4057,
	["Lake Cauldros"] = 4058,
	["Cauldros Isle"] = 4059,
	["Bleeding Vale"] = 4060,
	["Giants' Run"] = 4061,
	["Apothecary Camp"] = 4062,
	["Ember Spear Tower"] = 4063,
	["Shattered Straits"] = 4064,
	["Gjalerhorn"] = 4065,
	["Frostblade Peak"] = 4066,
	["Plaguewood Tower"] = 4067,
	["West Spear Tower"] = 4068,
	["North Spear Tower"] = 4069,
	["Chillmere Coast"] = 4070,
	["Whisper Gulch"] = 4071,
	["Sub zone"] = 4072,
	["Winter's Terrace"] = 4073,
	["The Waking Halls"] = 4074,
	["Sunwell Plateau"] = 4075,
	["Reuse Me 7"] = 4076,
	["Sorlof's Strand"] = 4077,
	["Razorthorn Rise"] = 4078,
	["Frostblade Pass"] = 4079,
	["Isle of Quel'Danas"] = 4080,
	["The Dawnchaser"] = 4081,
	["The Sin'loren"] = 4082,
	["Silvermoon's Pride"] = 4083,
	["The Bloodoath"] = 4084,
	["Shattered Sun Staging Area"] = 4085,
	["Sun's Reach Sanctum"] = 4086,
	["Sun's Reach Harbor"] = 4087,
	["Sun's Reach Armory"] = 4088,
	["Dawnstar Village"] = 4089,
	["The Dawning Square"] = 4090,
	["Greengill Coast"] = 4091,
	["The Dead Scar"] = 4092,
	["The Sun Forge"] = 4093,
	["Sunwell Plateau"] = 4094,
	["Magisters' Terrace"] = 4095,
	["Claytön's WoWEdit Land"] = 4096,
	["Winterfin Caverns"] = 4097,
	["Glimmer Bay"] = 4098,
	["Winterfin Retreat"] = 4099,
	["The Culling of Stratholme"] = 4100,
	["Sands of Nasam"] = 4101,
	["Krom's Landing"] = 4102,
	["Nasam's Talon"] = 4103,
	["Echo Cove"] = 4104,
	["Beryl Point"] = 4105,
	["Garrosh's Landing"] = 4106,
	["Warsong Jetty"] = 4107,
	["Fizzcrank Airstrip"] = 4108,
	["Lake Kum'uya"] = 4109,
	["Farshire Fields"] = 4110,
	["Farshire"] = 4111,
	["Farshire Lighthouse"] = 4112,
	["Unu'pe"] = 4113,
	["Death's Stand"] = 4114,
	["The Abandoned Reach"] = 4115,
	["Scalding Pools"] = 4116,
	["Steam Springs"] = 4117,
	["Talramas"] = 4118,
	["Festering Pools"] = 4119,
	["The Nexus"] = 4120,
	["Transitus Shield"] = 4121,
	["Bor'gorok Outpost"] = 4122,
	["Magmoth"] = 4123,
	["The Dens of Dying"] = 4124,
	["Temple City of En'kilah"] = 4125,
	["The Wailing Ziggurat"] = 4126,
	["Steeljaw's Caravan"] = 4127,
	["Naxxanar"] = 4128,
	["Warsong Hold"] = 4129,
	["Plains of Nasam"] = 4130,
	["Magisters' Terrace"] = 4131,
	["Ruins of Eldra'nath"] = 4132,
	["Charred Rise"] = 4133,
	["Blistering Pool"] = 4134,
	["Spire of Blood"] = 4135,
	["Spire of Decay"] = 4136,
	["Spire of Pain"] = 4137,
	["Frozen Reach"] = 4138,
	["Parhelion Plaza"] = 4139,
	["The Dead Scar"] = 4140,
	["Torp's Farm"] = 4141,
	["Warsong Granary"] = 4142,
	["Warsong Slaughterhouse"] = 4143,
	["Warsong Farms Outpost"] = 4144,
	["West Point Station"] = 4145,
	["North Point Station"] = 4146,
	["Mid Point Station"] = 4147,
	["South Point Station"] = 4148,
	["D.E.H.T.A. Encampment"] = 4149,
	["Kaw's Roost"] = 4150,
	["Westwind Refugee Camp"] = 4151,
	["Moa'ki Harbor"] = 4152,
	["Indu'le Village"] = 4153,
	["Snowfall Glade"] = 4154,
	["The Half Shell"] = 4155,
	["Surge Needle"] = 4156,
	["Moonrest Gardens"] = 4157,
	["Stars' Rest"] = 4158,
	["Westfall Brigade Encampment"] = 4159,
	["Lothalor Woodlands"] = 4160,
	["Wyrmrest Temple"] = 4161,
	["Icemist Falls"] = 4162,
	["Icemist Village"] = 4163,
	["The Pit of Narjun"] = 4164,
	["Agmar's Hammer"] = 4165,
	["Lake Indu'le"] = 4166,
	["Obsidian Dragonshrine"] = 4167,
	["Ruby Dragonshrine"] = 4168,
	["Fordragon Hold"] = 4169,
	["Kor'kron Vanguard"] = 4170,
	["The Court of Skulls"] = 4171,
	["Angrathar the Wrathgate"] = 4172,
	["Galakrond's Rest"] = 4173,
	["The Wicked Coil"] = 4174,
	["Bronze Dragonshrine"] = 4175,
	["The Mirror of Dawn"] = 4176,
	["Wintergarde Keep"] = 4177,
	["Wintergarde Mine"] = 4178,
	["Emerald Dragonshrine"] = 4179,
	["New Hearthglen"] = 4180,
	["Crusader's Landing"] = 4181,
	["Sinner's Folly"] = 4182,
	["Azure Dragonshrine"] = 4183,
	["Path of the Titans"] = 4184,
	["The Forgotten Shore"] = 4185,
	["Venomspite"] = 4186,
	["The Crystal Vice"] = 4187,
	["The Carrion Fields"] = 4188,
	["Onslaught Base Camp"] = 4189,
	["Thorson's Post"] = 4190,
	["Light's Trust"] = 4191,
	["Frostmourne Cavern"] = 4192,
	["Scarlet Point"] = 4193,
	["Jintha'kalar"] = 4194,
	["Ice Heart Cavern"] = 4195,
	["Drak'Tharon Keep"] = 4196,
	["Wintergrasp"] = 4197,
	["Kili'ua's Atoll"] = 4198,
	["Silverbrook"] = 4199,
	["Vordrassil's Heart"] = 4200,
	["Vordrassil's Tears"] = 4201,
	["Vordrassil's Tears"] = 4202,
	["Vordrassil's Limb"] = 4203,
	["Amberpine Lodge"] = 4204,
	["Solstice Village"] = 4205,
	["Conquest Hold"] = 4206,
	["Voldrune"] = 4207,
	["Granite Springs"] = 4208,
	["Zeb'Halak"] = 4209,
	["Drak'Tharon Keep"] = 4210,
	["Camp Oneqwah"] = 4211,
	["Eastwind Shore"] = 4212,
	["The Broken Bluffs"] = 4213,
	["Boulder Hills"] = 4214,
	["Rage Fang Shrine"] = 4215,
	["Drakil'jin Ruins"] = 4216,
	["Blackriver Logging Camp"] = 4217,
	["Heart's Blood Shrine"] = 4218,
	["Hollowstone Mine"] = 4219,
	["Dun Argol"] = 4220,
	["Thor Modan"] = 4221,
	["Blue Sky Logging Grounds"] = 4222,
	["Maw of Neltharion"] = 4223,
	["The Briny Pinnacle"] = 4224,
	["Glittering Strand"] = 4225,
	["Iskaal"] = 4226,
	["Dragon's Fall"] = 4227,
	["The Oculus"] = 4228,
	["Prospector's Point"] = 4229,
	["Coldwind Heights"] = 4230,
	["Redwood Trading Post"] = 4231,
	["Vengeance Pass"] = 4232,
	["Dawn's Reach"] = 4233,
	["Naxxramas"] = 4234,
	["Heartwood Trading Post"] = 4235,
	["Evergreen Trading Post"] = 4236,
	["Spruce Point Post"] = 4237,
	["White Pine Trading Post"] = 4238,
	["Aspen Grove Post"] = 4239,
	["Forest's Edge Post"] = 4240,
	["Eldritch Heights"] = 4241,
	["Venture Bay"] = 4242,
	["Wintergarde Crypt"] = 4243,
	["Bloodmoon Isle"] = 4244,
	["Shadowfang Tower"] = 4245,
	["Wintergarde Mausoleum"] = 4246,
	["Duskhowl Den"] = 4247,
	["The Conquest Pit"] = 4248,
	["The Path of Iron"] = 4249,
	["Ruins of Tethys"] = 4250,
	["Silverbrook Hills"] = 4251,
	["The Broken Bluffs"] = 4252,
	["7th Legion Front"] = 4253,
	["The Dragon Wastes"] = 4254,
	["Ruins of Drak'Zin"] = 4255,
	["Drak'Mar Lake"] = 4256,
	["Dragonspine Tributary"] = 4257,
	["The North Sea"] = 4258,
	["Drak'ural"] = 4259,
	["Thorvald's Camp"] = 4260,
	["Ghostblade Post"] = 4261,
	["Ashwood Post"] = 4262,
	["Lydell's Ambush"] = 4263,
	["Halls of Stone"] = 4264,
	["The Nexus"] = 4265,
	["Harkor's Camp"] = 4266,
	["Vordrassil Pass"] = 4267,
	["Ruuna's Camp"] = 4268,
	["Shrine of Scales"] = 4269,
	["Drak'atal Passage"] = 4270,
	["Utgarde Pinnacle"] = 4271,
	["Halls of Lightning"] = 4272,
	["Ulduar"] = 4273,
	["The Argent Stand"] = 4275,
	["Altar of Sseratus"] = 4276,
	["Azjol-Nerub"] = 4277,
	["Drak'Sotra Fields"] = 4278,
	["Drak'Sotra"] = 4279,
	["Drak'Agal"] = 4280,
	["Acherus: The Ebon Hold"] = 4281,
	["The Avalanche"] = 4282,
	["The Lost Lands"] = 4283,
	["Nesingwary Base Camp"] = 4284,
	["The Seabreach Flow"] = 4285,
	["The Bones of Nozronn"] = 4286,
	["Kartak's Hold"] = 4287,
	["Sparktouched Haven"] = 4288,
	["The Path of the Lifewarden"] = 4289,
	["River's Heart"] = 4290,
	["Rainspeaker Canopy"] = 4291,
	["Frenzyheart Hill"] = 4292,
	["Wildgrowth Mangal"] = 4293,
	["Heb'Valok"] = 4294,
	["The Sundered Shard"] = 4295,
	["The Lifeblood Pillar"] = 4296,
	["Mosswalker Village"] = 4297,
	["Plaguelands: The Scarlet Enclave"] = 4298,
	["Kolramas"] = 4299,
	["Waygate"] = 4300,
	["The Skyreach Pillar"] = 4302,
	["Hardknuckle Clearing"] = 4303,
	["Sapphire Hive"] = 4304,
	["Mistwhisper Refuge"] = 4306,
	["The Glimmering Pillar"] = 4307,
	["Spearborn Encampment"] = 4308,
	["Drak'Tharon Keep"] = 4309,
	["Zeramas"] = 4310,
	["Reliquary of Agony"] = 4311,
	["Ebon Watch"] = 4312,
	["Thrym's End"] = 4313,
	["Voltarus"] = 4314,
	["Reliquary of Pain"] = 4315,
	["Rageclaw Den"] = 4316,
	["Light's Breach"] = 4317,
	["Pools of Zha'Jin"] = 4318,
	["Zim'Abwa"] = 4319,
	["Amphitheater of Anguish"] = 4320,
	["Altar of Rhunok"] = 4321,
	["Altar of Har'koa"] = 4322,
	["Zim'Torga"] = 4323,
	["Pools of Jin'Alai"] = 4324,
	["Altar of Quetz'lun"] = 4325,
	["Heb'Drakkar"] = 4326,
	["Drak'Mabwa"] = 4327,
	["Zim'Rhuk"] = 4328,
	["Altar of Mam'toth"] = 4329,
	["Acherus: The Ebon Hold"] = 4342,
	["New Avalon"] = 4343,
	["New Avalon Fields"] = 4344,
	["New Avalon Orchard"] = 4345,
	["New Avalon Town Hall"] = 4346,
	["Havenshire"] = 4347,
	["Havenshire Farms"] = 4348,
	["Havenshire Lumber Mill"] = 4349,
	["Havenshire Stables"] = 4350,
	["Scarlet Hold"] = 4351,
	["Chapel of the Crimson Flame"] = 4352,
	["Light's Point Tower"] = 4353,
	["Light's Point"] = 4354,
	["Crypt of Remembrance"] = 4355,
	["Death's Breach"] = 4356,
	["The Noxious Glade"] = 4357,
	["Tyr's Hand"] = 4358,
	["King's Harbor"] = 4359,
	["Scarlet Overlook"] = 4360,
	["Light's Hope Chapel"] = 4361,
	["Sinner's Folly"] = 4362,
	["Pestilent Scar"] = 4363,
	["Browman Mill"] = 4364,
	["Havenshire Mine"] = 4365,
	["Ursoc's Den"] = 4366,
	["The Blight Line"] = 4367,
	["The Bonefields"] = 4368,
	["Dorian's Outpost"] = 4369,
	["Mam'toth Crater"] = 4371,
	["Zol'Maz Stronghold"] = 4372,
	["Zol'Heb"] = 4373,
	["Rageclaw Lake"] = 4374,
	["Gundrak"] = 4375,
	["The Savage Thicket"] = 4376,
	["New Avalon Forge"] = 4377,
	["Dalaran Arena"] = 4378,
	["Valgarde"] = 4379,
	["Westguard Inn"] = 4380,
	["Waygate"] = 4381,
	["The Shaper's Terrace"] = 4382,
	["Lakeside Landing"] = 4383,
	["Strand of the Ancients"] = 4384,
	["Bittertide Lake"] = 4385,
	["Rainspeaker Rapids"] = 4386,
	["Frenzyheart River"] = 4387,
	["Wintergrasp River"] = 4388,
	["The Suntouched Pillar"] = 4389,
	["Frigid Breach"] = 4390,
	["Swindlegrin's Dig"] = 4391,
	["The Stormwright's Shelf"] = 4392,
	["Death's Hand Encampment"] = 4393,
	["Scarlet Tavern"] = 4394,
	["Dalaran"] = 4395,
	["Nozzlerust Post"] = 4396,
	["Farshire Mine"] = 4399,
	["The Mosslight Pillar"] = 4400,
	["Saragosa's Landing"] = 4401,
	["Vengeance Lift"] = 4402,
	["Balejar Watch"] = 4403,
	["New Agamand Inn"] = 4404,
	["Passage of Lost Fiends"] = 4405,
	["The Ring of Valor"] = 4406,
	["Hall of the Frostwolf"] = 4407,
	["Hall of the Stormpike"] = 4408,
	["Stormwind Harbor"] = 4411,
	["The Makers' Overlook"] = 4412,
	["The Makers' Perch"] = 4413,
	["Scarlet Tower"] = 4414,
	["The Violet Hold"] = 4415,
	["Gundrak"] = 4416,
	["Onslaught Harbor"] = 4417,
	["K3"] = 4418,
	["Snowblind Hills"] = 4419,
	["Snowblind Terrace"] = 4420,
	["Garm"] = 4421,
	["Brunnhildar Village"] = 4422,
	["Sifreldar Village"] = 4423,
	["Valkyrion"] = 4424,
	["The Forlorn Mine"] = 4425,
	["Bor's Breath River"] = 4426,
	["Argent Vanguard"] = 4427,
	["Frosthold"] = 4428,
	["Grom'arsh Crash-Site"] = 4429,
	["Temple of Storms"] = 4430,
	["Engine of the Makers"] = 4431,
	["The Foot Steppes"] = 4432,
	["Dragonspine Peaks"] = 4433,
	["Nidavelir"] = 4434,
	["Narvir's Cradle"] = 4435,
	["Snowdrift Plains"] = 4436,
	["Valley of Ancient Winters"] = 4437,
	["Dun Niffelem"] = 4438,
	["Frostfield Lake"] = 4439,
	["Thunderfall"] = 4440,
	["Camp Tunka'lo"] = 4441,
	["Brann's Base-Camp"] = 4442,
	["Gate of Echoes"] = 4443,
	["Plain of Echoes"] = 4444,
	["Ulduar"] = 4445,
	["Terrace of the Makers"] = 4446,
	["Gate of Lightning"] = 4447,
	["Path of the Titans"] = 4448,
	["Uldis"] = 4449,
	["Loken's Bargain"] = 4450,
	["Bor's Fall"] = 4451,
	["Bor's Breath"] = 4452,
	["Rohemdal Pass"] = 4453,
	["The Storm Foundry"] = 4454,
	["Hibernal Cavern"] = 4455,
	["Voldrune Dwelling"] = 4456,
	["Torseg's Rest"] = 4457,
	["Sparksocket Minefield"] = 4458,
	["Ricket's Folly"] = 4459,
	["Garm's Bane"] = 4460,
	["Garm's Rise"] = 4461,
	["Crystalweb Cavern"] = 4462,
	["Temple of Life"] = 4463,
	["Temple of Order"] = 4464,
	["Temple of Winter"] = 4465,
	["Temple of Invention"] = 4466,
	["Death's Rise"] = 4467,
	["The Dead Fields"] = 4468,
	["Dargath's Demise"] = 4469,
	["The Hidden Hollow"] = 4470,
	["Bernau's Happy Fun Land"] = 4471,
	["Frostgrip's Hollow"] = 4472,
	["The Frigid Tomb"] = 4473,
	["Twin Shores"] = 4474,
	["Zim'bo's Hideout"] = 4475,
	["Abandoned Camp"] = 4476,
	["The Shadow Vault"] = 4477,
	["Coldwind Pass"] = 4478,
	["Winter's Breath Lake"] = 4479,
	["The Forgotten Overlook"] = 4480,
	["Jintha'kalar Passage"] = 4481,
	["Arriga Footbridge"] = 4482,
	["The Lost Passage"] = 4483,
	["Bouldercrag's Refuge"] = 4484,
	["The Inventor's Library"] = 4485,
	["The Frozen Mine"] = 4486,
	["Frostfloe Deep"] = 4487,
	["The Howling Hollow"] = 4488,
	["Crusader Forward Camp"] = 4489,
	["Stormcrest"] = 4490,
	["Bonesnap's Camp"] = 4491,
	["Ufrang's Hall"] = 4492,
	["The Obsidian Sanctum"] = 4493,
	["Ahn'kahet: The Old Kingdom"] = 4494,
	["Fjorn's Anvil"] = 4495,
	["Jotunheim"] = 4496,
	["Savage Ledge"] = 4497,
	["Halls of the Ancestors"] = 4498,
	["The Blighted Pool"] = 4499,
	["The Eye of Eternity"] = 4500,
	["The Argent Vanguard"] = 4501,
	["Mimir's Workshop"] = 4502,
	["Ironwall Dam"] = 4503,
	["Valley of Echoes"] = 4504,
	["The Breach"] = 4505,
	["Scourgeholme"] = 4506,
	["The Broken Front"] = 4507,
	["Mord'rethar: The Death Gate"] = 4508,
	["The Bombardment"] = 4509,
	["Aldur'thar: The Desolation Gate"] = 4510,
	["The Skybreaker"] = 4511,
	["Orgrim's Hammer"] = 4512,
	["Ymirheim"] = 4513,
	["Saronite Mines"] = 4514,
	["The Conflagration"] = 4515,
	["Ironwall Rampart"] = 4516,
	["Weeping Quarry"] = 4517,
	["Corp'rethar: The Horror Gate"] = 4518,
	["The Court of Bones"] = 4519,
	["Malykriss: The Vile Hold"] = 4520,
	["Cathedral of Darkness"] = 4521,
	["Icecrown Citadel"] = 4522,
	["Icecrown Glacier"] = 4523,
	["Valhalas"] = 4524,
	["The Underhalls"] = 4525,
	["Njorndar Village"] = 4526,
	["Balargarde Fortress"] = 4527,
	["Kul'galar Keep"] = 4528,
	["The Crimson Cathedral"] = 4529,
	["Sanctum of Reanimation"] = 4530,
	["The Fleshwerks"] = 4531,
	["Vengeance Landing Inn"] = 4532,
	["Sindragosa's Fall"] = 4533,
	["Wildervar Mine"] = 4534,
	["The Pit of the Fang"] = 4535,
	["Frosthowl Cavern"] = 4536,
	["The Valley of Lost Hope"] = 4537,
	["The Sunken Ring"] = 4538,
	["The Broken Temple"] = 4539,
	["The Valley of Fallen Heroes"] = 4540,
	["Vanguard Infirmary"] = 4541,
	["Hall of the Shaper"] = 4542,
	["Temple of Wisdom"] = 4543,
	["Death's Breach"] = 4544,
	["Abandoned Mine"] = 4545,
	["Ruins of the Scarlet Enclave"] = 4546,
	["Halls of Stone"] = 4547,
	["Halls of Lightning"] = 4548,
	["The Great Tree"] = 4549,
	["The Mirror of Twilight"] = 4550,
	["The Twilight Rivulet"] = 4551,
	["The Decrepit Flow"] = 4552,
	["Forlorn Woods"] = 4553,
	["Ruins of Shandaral"] = 4554,
	["The Azure Front"] = 4555,
	["Violet Stand"] = 4556,
	["The Unbound Thicket"] = 4557,
	["Sunreaver's Command"] = 4558,
	["Windrunner's Overlook"] = 4559,
	["The Underbelly"] = 4560,
	["Krasus' Landing"] = 4564,
	["The Violet Hold"] = 4567,
	["The Eventide"] = 4568,
	["Sewer Exit Pipe"] = 4569,
	["Circle of Wills"] = 4570,
	["Silverwing Flag Room"] = 4571,
	["Warsong Flag Room"] = 4572,
	["Wintergrasp Fortress"] = 4575,
	["Central Bridge"] = 4576,
	["Eastern Bridge"] = 4577,
	["Western Bridge"] = 4578,
	["Dubra'Jin"] = 4579,
	["Crusaders' Pinnacle"] = 4580,
	["Flamewatch Tower"] = 4581,
	["Winter's Edge Tower"] = 4582,
	["Shadowsight Tower"] = 4583,
	["The Cauldron of Flames"] = 4584,
	["Glacial Falls"] = 4585,
	["Windy Bluffs"] = 4586,
	["The Forest of Shadows"] = 4587,
	["Blackwatch"] = 4588,
	["The Chilled Quagmire"] = 4589,
	["The Steppe of Life"] = 4590,
	["Silent Vigil"] = 4591,
	["Gimorak's Den"] = 4592,
	["The Pit of Fiends"] = 4593,
	["Battlescar Spire"] = 4594,
	["Hall of Horrors"] = 4595,
	["The Circle of Suffering"] = 4596,
	["Rise of Suffering"] = 4597,
	["Krasus' Landing"] = 4598,
	["Sewer Exit Pipe"] = 4599,
	["Dalaran Island"] = 4601,
	["Force Interior"] = 4602,
	["Vault of Archavon"] = 4603,
	["Gate of the Red Sun"] = 4604,
	["Gate of the Blue Sapphire"] = 4605,
	["Gate of the Green Emerald"] = 4606,
	["Gate of the Purple Amethyst"] = 4607,
	["Gate of the Yellow Moon"] = 4608,
	["Courtyard of the Ancients"] = 4609,
	["Landing Beach"] = 4610,
	["Westspark Workshop"] = 4611,
	["Eastspark Workshop"] = 4612,
	["Dalaran City"] = 4613,
	["The Violet Citadel Spire"] = 4614,
	["Naz'anak: The Forgotten Depths"] = 4615,
	["Sunreaver's Sanctuary"] = 4616,
	["Elevator"] = 4617,
	["Antonidas Memorial"] = 4618,
	["The Violet Citadel"] = 4619,
	["Magus Commerce Exchange"] = 4620,
	["UNUSED"] = 4621,
	["First Legion Forward Camp"] = 4622,
	["Hall of the Conquered Kings"] = 4623,
	["Befouled Terrace"] = 4624,
	["The Desecrated Altar"] = 4625,
	["Shimmering Bog"] = 4626,
	["Fallen Temple of Ahn'kahet"] = 4627,
	["Halls of Binding"] = 4628,
	["Winter's Heart"] = 4629,
	["The North Sea"] = 4630,
	["The Broodmother's Nest"] = 4631,
	["Dalaran Floating Rocks"] = 4632,
	["Raptor Pens"] = 4633,
	["Drak'Tharon Keep"] = 4635,
	["The Noxious Pass"] = 4636,
	["Vargoth's Retreat"] = 4637,
	["Violet Citadel Balcony"] = 4638,
	["Band of Variance"] = 4639,
	["Band of Acceleration"] = 4640,
	["Band of Transmutation"] = 4641,
	["Band of Alignment"] = 4642,
	["Orendil's Retreat"] = 4644,
	["Blackfathom Camp"] = 4645,
	["Ashwood Lake"] = 4646,
	["Ruuzel's Isle"] = 4647,
	["Auberdine Refugee Camp"] = 4648,
	["Iron Concourse"] = 4650,
	["Formation Grounds"] = 4652,
	["Razorscale's Aerie"] = 4653,
	["The Colossal Forge"] = 4654,
	["The Scrapyard"] = 4655,
	["The Conservatory of Life"] = 4656,
	["The Archivum"] = 4657,
	["Argent Tournament Grounds"] = 4658,
	["Lor'danel"] = 4659,
	["Ruins of Lornesta"] = 4660,
	["Cliffspring Hollow"] = 4661,
	["Shatterspear War Camp"] = 4662,
	["Maw of the Void"] = 4663,
	["Shatterspear Vale"] = 4664,
	["Expedition Base Camp"] = 4665,
	["Sunreaver Pavilion"] = 4666,
	["Silver Covenant Pavilion"] = 4667,
	["The Cooper Residence"] = 4668,
	["The Ring of Champions"] = 4669,
	["The Aspirants' Ring"] = 4670,
	["The Argent Valiants' Ring"] = 4671,
	["The Alliance Valiants' Ring"] = 4672,
	["The Horde Valiants' Ring"] = 4673,
	["Argent Pavilion"] = 4674,
	["Withering Thicket"] = 4675,
	["Sunreaver Pavilion"] = 4676,
	["Silver Covenant Pavilion"] = 4677,
	["The Forlorn Cavern"] = 4679,
	["claytonio test area"] = 4688,
	["Thunder Peak"] = 4690,
	["Hellscream's Watch"] = 4691,
	["Quel'Delar's Rest"] = 4692,
	["Splintertree Mine"] = 4693,
	["Thistlefur Hold"] = 4694,
	["The Eye of the Vortex"] = 4695,
	["Blackwood Camp"] = 4696,
	["The Blazing Strand"] = 4697,
	["Moontouched Den"] = 4698,
	["Shatterspear Pass"] = 4702,
	["Raynewood Tower"] = 4705,
	["Ruins of Gilneas"] = 4706,
	["The Lost Isles"] = 4707,
	["Earthshatter Cavern"] = 4708,
	["Southern Barrens"] = 4709,
	["Isle of Conquest"] = 4710,
	["Stardust Spire"] = 4711,
	["Moonwell of Cleansing"] = 4712,
	["Krolg's Hut"] = 4713,
	["Gilneas"] = 4714,
	["The Skunkworks"] = 4715,
	["Bolyun's Camp"] = 4716,
	["House of Edune"] = 4717,
	["Wellspring Hovel"] = 4718,
	["Familiars"] = 4719,
	["The Lost Isles"] = 4720,
	["Shipwreck Shore"] = 4721,
	["Trial of the Crusader"] = 4722,
	["Trial of the Champion"] = 4723,
	["Ban'ethil Barrow Descent"] = 4724,
	["The Headlands"] = 4725,
	["Keel Harbor"] = 4726,
	["Aderic's Repose"] = 4727,
	["Northern Headlands"] = 4728,
	["Northgate Woods"] = 4729,
	["The Blackwald"] = 4730,
	["Stormglen Village"] = 4731,
	["Emberstone Mine"] = 4732,
	["Galewatch Lighthouse"] = 4733,
	["Emberstone Village"] = 4734,
	["Northgate Breach"] = 4735,
	["The Bite"] = 4736,
	["Kezan"] = 4737,
	["Abyssal Maw"] = 4738,
	["Runeweaver Square"] = 4739,
	["The Silver Enclave"] = 4740,
	["Isle of Conquest No Man's Land"] = 4741,
	["Hrothgar's Landing"] = 4742,
	["Deathspeaker's Watch"] = 4743,
	["Mountainfoot Strip Mine"] = 4744,
	["Orgrimmar Rear Gate"] = 4745,
	["Workshop"] = 4747,
	["Quarry"] = 4748,
	["Docks"] = 4749,
	["Hangar"] = 4750,
	["Refinery"] = 4751,
	["Horde Keep"] = 4752,
	["Alliance Keep"] = 4753,
	["Gilneas City"] = 4755,
	["Merchant Square"] = 4756,
	["Military District"] = 4757,
	["Greymane Court"] = 4758,
	["Cathedral Quarter"] = 4759,
	["The Sea Reaver's Run"] = 4760,
	["Light's Dawn Cathedral"] = 4761,
	["Stoneward Prison"] = 4762,
	["Transport: Alliance Gunship"] = 4763,
	["Transport: Horde Gunship"] = 4764,
	["KTC Headquarters"] = 4765,
	["Kaja'mine"] = 4766,
	["Bilgewater Port"] = 4767,
	["Gallywix's Villa"] = 4768,
	["Hrothgar's Landing"] = 4769,
	["First Bank of Kezan"] = 4770,
	["Drudgetown"] = 4771,
	["The Slick"] = 4772,
	["Swindle Street"] = 4773,
	["Gilneas (Do Not Reuse)"] = 4774,
	["Kaja'mite Cavern"] = 4778,
	["Horde Base Camp"] = 4779,
	["The Vicious Vale"] = 4780,
	["Wild Overlook"] = 4781,
	["The Savage Glen"] = 4782,
	["Alliance Beachhead"] = 4783,
	["Vengeance Wake"] = 4784,
	["The Great Sea"] = 4785,
	["Duskhaven"] = 4786,
	["Stagecoach Crash Site"] = 4787,
	["Tempest's Reach"] = 4788,
	["The Greymane Wall"] = 4789,
	["Northgate River"] = 4790,
	["Hailwood Marsh"] = 4791,
	["Allen Farmstead"] = 4792,
	["Hammond Farmstead"] = 4793,
	["Koroth's Den"] = 4794,
	["Slitherblade Shore"] = 4795,
	["Slitherblade Shore"] = 4796,
	["Magram Territory"] = 4797,
	["Thargad's Camp"] = 4798,
	["Trial of Fire"] = 4799,
	["Trial of Shadow"] = 4800,
	["Arcane Pinnacle"] = 4801,
	["Draka's Fury"] = 4802,
	["Furien's Post"] = 4803,
	["Cenarion Wildlands"] = 4804,
	["Karnum's Glade"] = 4805,
	["Wahl Cottage"] = 4806,
	["Crowley Orchard"] = 4807,
	["Hayward Fishery"] = 4808,
	["The Forge of Souls"] = 4809,
	["Queen's Gate"] = 4810,
	["King's Gate"] = 4811,
	["Icecrown Citadel"] = 4812,
	["Pit of Saron"] = 4813,
	["Sable Ridge"] = 4814,
	["Kelp'thar Forest"] = 4815,
	["Dire Strait"] = 4816,
	["Greymane Manor"] = 4817,
	["Crowley Stable Grounds"] = 4818,
	["The Ancient Grove"] = 4819,
	["Halls of Reflection"] = 4820,
	["Bilgewater Harbor"] = 4821,
	["Kajaro Field"] = 4822,
	["South Seas"] = 4823,
	["Gallywix Pleasure Palace"] = 4824,
	["Northern Rocketway Exchange"] = 4825,
	["Storm Cliffs"] = 4826,
	["Storm Cliffs"] = 4827,
	["Southern Rocketway Terminus"] = 4828,
	["The Secret Lab"] = 4829,
	["Orgrimmar Rocketway Exchange"] = 4830,
	["Transport: Alliance Gunship (IGB)"] = 4832,
	["Transport: Horde Gunship (IGB)"] = 4833,
	["Ruins of Nordressa"] = 4834,
	["Camp Sungraze"] = 4835,
	["Stonetalon Pass"] = 4836,
	["Whitebeard's Encampment"] = 4837,
	["Gallywix's Yacht"] = 4838,
	["Fargaze Mesa"] = 4839,
	["The Pipe"] = 4840,
	["Tal'doren"] = 4841,
	["Livery Outpost"] = 4842,
	["Honor's Stand"] = 4843,
	["Hunter's Hill"] = 4844,
	["The Overgrowth"] = 4845,
	["Camp Una'fe"] = 4846,
	["Northwatch Hold"] = 4847,
	["Teegan's Expedition"] = 4848,
	["Forward Command"] = 4849,
	["Fields of Blood"] = 4850,
	["Ruins of Taurajo"] = 4851,
	["The Great Gate"] = 4852,
	["Desolation Hold"] = 4853,
	["Fort Triumph"] = 4854,
	["Battlescar"] = 4855,
	["Bael Modan"] = 4856,
	["Firestone Point"] = 4857,
	["Rygna's Lair"] = 4858,
	["The Frozen Throne"] = 4859,
	["Overgrown Camp"] = 4860,
	["The Regrowth"] = 4861,
	["The Frozen Halls"] = 4862,
	["Bloodtalon Shore"] = 4863,
	["Zalazane's Fall"] = 4864,
	["Darkspear Training Grounds"] = 4865,
	["Darkspear Hold"] = 4866,
	["Spitescale Cove"] = 4867,
	["The Bradshaw Mill"] = 4868,
	["Wood's End Cabin"] = 4869,
	["Landing Site"] = 4870,
	["Town-In-A-Box"] = 4871,
	["Bael'dun Keep"] = 4872,
	["Raptor Rise"] = 4873,
	["Scorched Gully"] = 4874,
	["Darkspear Isle"] = 4875,
	["Ruins of Vashj'elan"] = 4876,
	["Vashj'elan Spawning Pool"] = 4877,
	["The Thornsnarl"] = 4878,
	["The Battleboar Pen"] = 4879,
	["Thornmantle's Hideout"] = 4880,
	["Stonetalon Pass"] = 4881,
	["Marshal's Stand"] = 4882,
	["Mossy Pile"] = 4883,
	["The Screaming Reaches"] = 4884,
	["The Roiling Gardens"] = 4885,
	["Oomlot Village"] = 4886,
	["Nightmare Scar"] = 4887,
	["The Nightmare Scar"] = 4888,
	["The Frost Queen's Lair"] = 4889,
	["Putricide's Laboratory of Alchemical Horrors and Fun"] = 4890,
	["The Sanctum of Blood"] = 4891,
	["The Crimson Hall"] = 4892,
	["The Frost Queen's Lair"] = 4893,
	["Putricide's Laboratory of Alchemical Horrors and Fun"] = 4894,
	["The Crimson Hall"] = 4895,
	["The Frozen Throne"] = 4896,
	["The Sanctum of Blood"] = 4897,
	["Frostmourne"] = 4898,
	["Lost Peak"] = 4899,
	["Oostan Nord"] = 4900,
	["Oostan Sor"] = 4901,
	["Oostan Ost"] = 4902,
	["Oostan"] = 4903,
	["The Dark Approach"] = 4904,
	["Scourgelord's Command"] = 4905,
	["The Shadow Throne"] = 4906,
	["The Hidden Passage"] = 4908,
	["Lost Caldera"] = 4909,
	["Frostmourne"] = 4910,
	["Volcanoth's Lair"] = 4911,
	["Warchief's Lookout"] = 4912,
	["Spitescale Cavern"] = 4913,
	["Tranquil Coast"] = 4914,
	["Rotbrain Encampment"] = 4915,
	["Calston Estate"] = 4916,
	["Scarlet Palisade"] = 4917,
	["Scarlet Encampment"] = 4918,
	["Death's Watch Waystation"] = 4919,
	["Crusader's Run"] = 4920,
	["Scarlet Watchtower"] = 4921,
	["Twilight Highlands"] = 4922,
	["Sky Falls"] = 4923,
	["Gallywix Labor Mine"] = 4924,
	["Thunk's Abode"] = 4925,
	["Blackrock Caverns"] = 4926,
	["The Fold"] = 4927,
	["Talondeep Pass"] = 4928,
	["Windshear Hold"] = 4929,
	["Webwinder Hollow"] = 4930,
	["Ruins of Eldre'thar"] = 4931,
	["The Deep Reaches"] = 4932,
	["Krom'gar Fortress"] = 4933,
	["The Sludgewerks"] = 4934,
	["Mirkfallon Post"] = 4935,
	["Cliffwalker Post"] = 4936,
	["Thal'darah Overlook"] = 4937,
	["Battlescar Valley"] = 4938,
	["Farwatcher's Glen"] = 4939,
	["Northwatch Expedition Base Camp"] = 4940,
	["Unearthed Grounds"] = 4941,
	["Windshear Heights"] = 4942,
	["Dagger Pass"] = 4943,
	["Thal'darah Grove"] = 4944,
	["Halls of Origination"] = 4945,
	["Bael Modan Excavation"] = 4946,
	["Twinbraid's Patrol"] = 4947,
	["Frazzlecraz Motherlode"] = 4948,
	["Spearhead"] = 4949,
	["Grim Batol"] = 4950,
	["Bilgewater Lumber Yard"] = 4951,
	["KTC Oil Platform"] = 4952,
	["Kelp'thar Forest"] = 4953,
	["Gallywix Docks"] = 4954,
	["The Lightless Reaches"] = 4955,
	["The Slave Pits"] = 4956,
	["Verdant Highlands"] = 4958,
	["Silver Tide Trench"] = 4961,
	["Nespirah"] = 4962,
	["Glimmerdeep Gorge"] = 4963,
	["Biel'aran Ridge"] = 4966,
	["Ruins of Vashj'ir"] = 4967,
	["Quel'Dormir Terrace"] = 4968,
	["Tranquil Wash"] = 4969,
	["Legion's Rest"] = 4970,
	["L'ghorek"] = 4971,
	["Thermal Vents"] = 4972,
	["The Overlook"] = 4973,
	["Underlight Canyon"] = 4974,
	["Tenebrous Cavern"] = 4975,
	["Darkbreak Cove"] = 4976,
	["Korthun's End"] = 4977,
	["Wolf's Run"] = 4978,
	["Shrine of Goldrinn"] = 4979,
	["Maw of Lycanthoth"] = 4980,
	["Southfury Watershed"] = 4981,
	["The Dranosh'ar Blockade"] = 4982,
	["Twilight Crossing"] = 4983,
	["The Twilight Gauntlet"] = 4984,
	["The High Road"] = 4985,
	["Vendetta Point"] = 4986,
	["The Ruby Sanctum"] = 4987,
	["Gar'gol's Hovel"] = 4988,
	["Grove of Aessina"] = 4989,
	["Shrine of Aviana"] = 4990,
	["Darkwhisper Gorge"] = 4991,
	["Broken Commons"] = 4992,
	["Darkwhisper Pass"] = 4993,
	["The Forge of Supplication"] = 4994,
	["Seat of the Chosen"] = 4995,
	["Doom's Vigil"] = 4996,
	["Gates of Sothann"] = 4998,
	["Lightning Ledge"] = 4999,
	["Verrall River"] = 5000,
	["Camp Ataya"] = 5002,
	["Stonemaul Hold"] = 5003,
	["Throne of the Tides"] = 5004,
	["Silver Tide Hollow"] = 5005,
	["Damplight Cavern"] = 5006,
	["Ruins of Thelserai Temple"] = 5007,
	["Shimmering Grotto"] = 5008,
	["Shadebough"] = 5009,
	["New Thalanaar"] = 5010,
	["Westreach Summit"] = 5011,
	["The Briny Cutter"] = 5012,
	["Blackhorn's Penance"] = 5013,
	["The Inferno"] = 5014,
	["Leyara's Sorrow"] = 5015,
	["Whistling Grove"] = 5016,
	["The Scorched Plain"] = 5017,
	["Ashen Lake"] = 5018,
	["Sanctuary of Malorne"] = 5019,
	["The Flamewake"] = 5020,
	["The Searing Gateway"] = 5021,
	["Rim of the World"] = 5022,
	["The Emerald Summit"] = 5023,
	["Dreamer's Rest"] = 5024,
	["The Shimmering Deep"] = 5025,
	["Rustmaul Dive Site"] = 5026,
	["Splithoof Heights"] = 5027,
	["Southsea Holdfast"] = 5028,
	["The Admiral's Den"] = 5029,
	["Shallow's End"] = 5030,
	["Twin Peaks"] = 5031,
	["Hyjal Barrow Dens"] = 5032,
	["Twilight Command Post"] = 5033,
	["Uldum"] = 5034,
	["The Vortex Pinnacle"] = 5035,
	["Darkmist Ruins"] = 5036,
	["Lake Edunel"] = 5037,
	["Nordrassil"] = 5038,
	["Sulfuron Spire"] = 5039,
	["The Throne of Flame"] = 5040,
	["Fizzle & Pozzik's Speedbarge"] = 5041,
	["Deepholm"] = 5042,
	["The Tainted Forest"] = 5044,
	["Ascendant's Rise"] = 5045,
	["Mirage Abyss"] = 5046,
	["Abyssal Breach"] = 5047,
	["Raceway Ruins"] = 5048,
	["Speedbarge Bar"] = 5049,
	["The Hatchery"] = 5050,
	["Seafarer's Tomb"] = 5051,
	["Legion's Fate"] = 5052,
	["Gurboggle's Ledge"] = 5053,
	["The Skeletal Reef"] = 5054,
	["Gnaws' Boneyard"] = 5055,
	["The Immortal Coil"] = 5056,
	["Smuggler's Scar"] = 5057,
	["Deepmist Grotto"] = 5058,
	["The Clutch"] = 5059,
	["Steelspark Station"] = 5060,
	["Steelspark Station"] = 5061,
	["Bootlegger Outpost"] = 5062,
	["Dunemaul Recruitment Camp"] = 5063,
	["The Anvil of Flame"] = 5064,
	["Tower of Estulan"] = 5065,
	["Trueshot Point"] = 5066,
	["The Inner Spire"] = 5067,
	["Pattymack Land"] = 5068,
	["Budd's Dig"] = 5070,
	["Gorrok's Lament"] = 5071,
	["Feathermoon Stronghold"] = 5072,
	["Fallowmere Inn"] = 5073,
	["Slabchisel's Survey"] = 5074,
	["Tirth's Haunt"] = 5075,
	["Nethergarde Supply Camps"] = 5076,
	["Shattershore"] = 5077,
	["The Red Reaches"] = 5078,
	["Rockpool Village"] = 5079,
	["Bloodwash Fighting Pits"] = 5080,
	["Bloodwash Shrine"] = 5081,
	["Bloodwash Cavern"] = 5082,
	["Sunveil Excursion"] = 5083,
	["Surwich"] = 5084,
	["Maldraz"] = 5085,
	["Dreadmaul Furnace"] = 5086,
	["Sethria's Roost"] = 5087,
	["The Stonecore"] = 5088,
	["Quel'Dormir Gardens"] = 5089,
	["Nar'shola Terrace"] = 5090,
	["Razorfen Downs"] = 5092,
	["Northwatch Expedition Base Camp Inn"] = 5093,
	["Blackwing Descent"] = 5094,
	["Tol Barad"] = 5095,
	["The Forbidding Sea"] = 5096,
	["Frostmane Front"] = 5097,
	["Frostmane Retreat"] = 5098,
	["The Crucible"] = 5099,
	["Promontory Point"] = 5100,
	["Deepfin Ridge"] = 5101,
	["Nightmare Depths"] = 5102,
	["The Scalding Chasm"] = 5103,
	["The Undershell"] = 5104,
	["Pincer X2"] = 5105,
	["The Verne"] = 5106,
	["Sira'kess Front"] = 5107,
	["The Battle for Gilneas (Old City Map)"] = 5108,
	["Cathedral Quarter"] = 5109,
	["Greymane Court"] = 5110,
	["Light's Dawn Cathedral"] = 5111,
	["Stoneward Prison"] = 5112,
	["Merchant Square"] = 5113,
	["Bahrum's Post"] = 5114,
	["Ironforge Airfield"] = 5115,
	["Nozzlepot's Outpost"] = 5117,
	["Windshear Valley"] = 5118,
	["Galen's Fall"] = 5121,
	["Quel'Dormir Temple"] = 5124,
	["Seat of Life"] = 5130,
	["Seabrush"] = 5134,
	["Abandoned Reef"] = 5135,
	["Dragonmaw Port"] = 5136,
	["The Krazzworks"] = 5137,
	["Bloodgulch"] = 5138,
	["The Gullet"] = 5139,
	["Highbank"] = 5140,
	["Firebeard's Patrol"] = 5141,
	["Thundermar"] = 5142,
	["Kirthaven"] = 5143,
	["Shimmering Expanse"] = 5144,
	["Abyssal Depths"] = 5145,
	["Vashj'ir"] = 5146,
	["Trade District"] = 5148,
	["Old Town"] = 5149,
	["Dwarven District"] = 5150,
	["Cathedral Square"] = 5151,
	["The Park"] = 5152,
	["Mage Quarter"] = 5154,
	["Vermillion Redoubt"] = 5155,
	["The Park"] = 5157,
	["Cleft of Shadow"] = 5166,
	["The Drag"] = 5167,
	["Valley of Honor"] = 5168,
	["Valley of Spirits"] = 5169,
	["Valley of Strength"] = 5170,
	["Valley of Wisdom"] = 5171,
	["The Severed Span"] = 5173,
	["Hogger Hill"] = 5174,
	["Goldtooth's Den"] = 5176,
	["Crushcog's Arsenal"] = 5177,
	["The Toxic Airfield"] = 5178,
	["The Tidebreaker"] = 5247,
	["Voldrin's Hold"] = 5248,
	["Stygian Bounty"] = 5249,
	["Galerek's Remorse"] = 5250,
	["The Iron Reaper"] = 5251,
	["The Intrepid"] = 5252,
	["The Cape of Stranglethorn"] = 5287,
	["Ahn'Qiraj Terrace"] = 5288,
	["Mortwake's Tower"] = 5289,
	["The Raging Chasm"] = 5290,
	["Jagged Wastes"] = 5291,
	["Scoured Reach"] = 5292,
	["Crumbling Depths"] = 5293,
	["Shuddering Spires"] = 5294,
	["The Pale Roost"] = 5295,
	["Therazane's Throne"] = 5296,
	["Halcyon Egress"] = 5297,
	["Twilight Precipice"] = 5298,
	["Lorthuna's Gate"] = 5299,
	["Verlok Stand"] = 5300,
	["Grolluk's Grave"] = 5301,
	["Crimson Expanse"] = 5302,
	["Temple of Earth"] = 5303,
	["Swiftgear Station"] = 5304,
	["Greenwarden's Grove"] = 5305,
	["Hull of the Foebreaker"] = 5306,
	["Transport: Onyxia/Nefarian Elevator"] = 5311,
	["Nazj'vel"] = 5312,
	["Storm's Fury Wreckage"] = 5313,
	["Stormwind Lake"] = 5314,
	["Llane's Oath"] = 5315,
	["Olivia's Pond"] = 5316,
	["Bambala"] = 5317,
	["The Sundering"] = 5318,
	["Fort Livingston"] = 5320,
	["Yowler's Den"] = 5321,
	["Scar of the Worldbreaker"] = 5322,
	["Stormfeather Outpost"] = 5323,
	["Shalewind Canyon"] = 5324,
	["Keeshan's Post"] = 5325,
	["Camp Everstill"] = 5326,
	["Tower Watch"] = 5327,
	["Upper Silvermarsh"] = 5328,
	["Lower Silvermarsh"] = 5329,
	["Stonehearth"] = 5330,
	["Fractured Front"] = 5331,
	["Orgrimmar Embassy"] = 5332,
	["Trial of Frost"] = 5333,
	["The Bastion of Twilight"] = 5334,
	["Quartzite Basin"] = 5335,
	["Remains of the Fleet"] = 5336,
	["Sanctum of the Prophets"] = 5337,
	["Fungal Deep"] = 5338,
	["Stranglethorn Vale"] = 5339,
	["Hall of Arms"] = 5340,
	["Hall of Explorers"] = 5341,
	["The Great Forge"] = 5342,
	["The Military Ward"] = 5343,
	["The Mystic Ward"] = 5344,
	["Thunder Bluff"] = 5345,
	["Stormwind City Cemetery"] = 5346,
	["Render's Crater"] = 5347,
	["Alliance Mercenary Ship to Vashj'ir"] = 5348,
	["Needlerock Slag"] = 5349,
	["Needlerock Chasm"] = 5350,
	["Ruins of Gilneas City"] = 5351,
	["Alabaster Shelf"] = 5352,
	["Verrall Delta"] = 5353,
	["Twilight Overlook"] = 5354,
	["Abyssion's Lair"] = 5355,
	["Grommash Hold"] = 5356,
	["The Quaking Fields"] = 5357,
	["Deathwing's Fall"] = 5358,
	["The Menders' Stead"] = 5367,
	["Avalanchion's Vault"] = 5368,
	["Forsaken High Command"] = 5369,
	["Blackrock Caverns Entrance"] = 5374,
	["Wreckage of the Silver Dawning"] = 5375,
	["The Abyssal Maw"] = 5382,
	["Den of the Devourer"] = 5383,
	["The Great Divide"] = 5385,
	["Forsaken Rear Guard"] = 5386,
	["The Forsaken Front"] = 5387,
	["Dawnrise Expedition"] = 5388,
	["Tol Barad Peninsula"] = 5389,
	["The Canals"] = 5390,
	["Ironwing Cavern"] = 5391,
	["Charred Outpost"] = 5392,
	["Masters' Gate"] = 5394,
	["Chamber of Respite"] = 5395,
	["Lost City of the Tol'vir"] = 5396,
	["The Wollerton Stead"] = 5397,
	["Stormwind City Outskirts"] = 5398,
	["Baradin Hold"] = 5399,
	["Slagworks"] = 5400,
	["Ironclad Garrison"] = 5401,
	["Warden's Vigil"] = 5402,
	["East Spire"] = 5403,
	["South Spire"] = 5404,
	["West Spire"] = 5405,
	["Blackstone Span"] = 5406,
	["Explorers' League Digsite"] = 5408,
	["The Old Barracks"] = 5409,
	["Silverlight Cavern"] = 5410,
	["Malicia's Outpost"] = 5411,
	["The Maelstrom"] = 5416,
	["The Blood Trail"] = 5418,
	["The Gate of Unending Cycles"] = 5420,
	["Redpine Dell"] = 5421,
	["Taelan's Tower"] = 5422,
	["Obelisk of the Stars"] = 5423,
	["Obsidian Breakers"] = 5424,
	["Twilight Shore"] = 5425,
	["Path of Uther"] = 5426,
	["Sorrow Hill Crypt"] = 5427,
	["The Eastern Earthshrine"] = 5428,
	["The Western Earthshrine"] = 5429,
	["Chamber of the Stars"] = 5431,
	["Forsaken Forward Command"] = 5432,
	["The Greymane Wall"] = 5433,
	["Forsaken Forward Command"] = 5434,
	["Gilneas City"] = 5435,
	["Tempest's Reach"] = 5436,
	["Ring of the Elements"] = 5437,
	["The Maw of Madness"] = 5438,
	["Ruins of Drakgor"] = 5439,
	["Northern Headlands"] = 5440,
	["Emberstone Village"] = 5441,
	["Emberstone Mine"] = 5442,
	["Dreadwatch Outpost"] = 5443,
	["Rutsak's Guard"] = 5444,
	["Glory"] = 5445,
	["Death's Step"] = 5446,
	["Scarred Terrace"] = 5447,
	["Light's Shield Tower"] = 5448,
	["The Battle for Gilneas"] = 5449,
	["Lighthouse"] = 5450,
	["Waterworks"] = 5451,
	["Mines"] = 5452,
	["Horde Landing"] = 5453,
	["Gilnean Stronghold"] = 5454,
	["Khartut's Tomb"] = 5455,
	["The Battlefront"] = 5456,
	["The Overlook"] = 5457,
	["Bogpaddle"] = 5458,
	["Marshtide Watch"] = 5459,
	["The Bloodmire"] = 5460,
	["Dragonmaw Pass"] = 5461,
	["Wyrms' Bend"] = 5462,
	["Ix'lar's Domain"] = 5463,
	["Darrowshire Hunting Grounds"] = 5464,
	["Orsis"] = 5465,
	["Ramkahen"] = 5466,
	["Nahom"] = 5467,
	["Gilnean Coast"] = 5468,
	["Siege Vise"] = 5469,
	["Victor's Point"] = 5470,
	["Crushblow"] = 5471,
	["The Twilight Gate"] = 5472,
	["The Twilight Citadel"] = 5473,
	["Elementium Depths"] = 5474,
	["Den of the Disciples"] = 5475,
	["Pyrewood Chapel"] = 5476,
	["Pyrewood Inn"] = 5477,
	["Pyrewood Town Hall"] = 5478,
	["Slithering Cove"] = 5479,
	["Gilneas Liberation Front Base Camp"] = 5480,
	["7th Legion Base Camp"] = 5481,
	["Dunwald Ruins"] = 5483,
	["Dunwald Holdout"] = 5484,
	["Dunwald Hovel"] = 5485,
	["Dunwald Town Square"] = 5486,
	["Dunwald Market Row"] = 5487,
	["Gorshak War Camp"] = 5488,
	["The Boneyard"] = 5489,
	["The Devouring Breach"] = 5493,
	["Gnomeregan"] = 5495,
	["Fuselight"] = 5496,
	["Fuselight-by-the-Sea"] = 5497,
	["Mar'at"] = 5498,
	["Akhenet Fields"] = 5499,
	["Ramkahen Legion Outpost"] = 5500,
	["Shrine of the Elements"] = 5501,
	["Thundermar Ruins"] = 5502,
	["Altar of Ascension"] = 5503,
	["Lake Dumont"] = 5504,
	["The Pit of Scales"] = 5505,
	["The Defiled Chapel"] = 5506,
	["The Cerebrillum"] = 5507,
	["Sunstone Terrace"] = 5508,
	["Shadowfang Keep Entrance"] = 5510,
	["Scarlet Monastery Entrance"] = 5511,
	["Scholomance Entrance"] = 5512,
	["Stratholme Entrance"] = 5513,
	["Stratholme Service Entrance"] = 5514,
	["Blackrock Depths Entrance"] = 5515,
	["Blackrock Spire Entrance"] = 5516,
	["Blackfathom Deeps Entrance"] = 5517,
	["Razorfen Kraul Entrance"] = 5518,
	["Rhea's Camp"] = 5519,
	["Maraudon - The Wicked Grotto Entrance"] = 5520,
	["Maraudon - Foulspore Cavern Entrance"] = 5521,
	["Maraudon - Earth Song Falls Entrance"] = 5522,
	["Uldaman Entrance"] = 5523,
	["Bloodwatcher Point"] = 5524,
	["Dustwind Dig"] = 5525,
	["Tomb of the Watchers"] = 5526,
	["Crucible of Carnage"] = 5527,
	["Dire Maul - Warpwood Quarter Entrance"] = 5529,
	["Dire Maul - Gordok Commons Entrance"] = 5530,
	["Dire Maul - Capital Gardens Entrance"] = 5531,
	["Razorfen Downs Entrance"] = 5532,
	["Zul'Farrak Entrance"] = 5533,
	["Cape of Lost Hope"] = 5534,
	["Wellson Shipyard"] = 5535,
	["Forgotten Hill"] = 5536,
	["The Darkwood"] = 5537,
	["Rustberg Village"] = 5538,
	["Farson Hold"] = 5539,
	["Largo's Overlook"] = 5540,
	["Hellfire Citadel - Ramparts Entrance"] = 5541,
	["The Restless Front"] = 5542,
	["Hellfire Citadel - The Shattered Halls Entrance"] = 5543,
	["Hellfire Citadel - The Blood Furnace Entrance"] = 5544,
	["Baradin Base Camp"] = 5545,
	["Hellscream's Grasp"] = 5546,
	["Auchindoun - Auchenai Crypts Entrance"] = 5547,
	["Auchindoun - Mana-Tombs Entrance"] = 5548,
	["Auchindoun - Sethekk Halls Entrance"] = 5549,
	["Auchindoun - Shadow Labyrinth Entrance"] = 5550,
	["Coilfang - The Steamvault Entrance"] = 5551,
	["Coilfang - The Underbog Entrance"] = 5552,
	["Coilfang - The Slave Pens Entrance"] = 5553,
	["Tempest Keep - The Mechanar Entrance"] = 5554,
	["Tempest Keep - The Botanica Entrance"] = 5555,
	["Tempest Keep - The Arcatraz Entrance"] = 5556,
	["Magisters' Terrace Entrance"] = 5557,
	["The Escape from Durnholde Entrance"] = 5558,
	["Opening of the Dark Portal Entrance"] = 5559,
	["The Culling of Stratholme Entrance"] = 5560,
	["The Nexus Entrance"] = 5561,
	["The Oculus Entrance"] = 5562,
	["Loch Verrall"] = 5563,
	["Dragon's Mouth"] = 5564,
	["New Kargath"] = 5565,
	["Utgarde Keep Entrance"] = 5566,
	["Utgarde Pinnacle Entrance"] = 5567,
	["Azjol-Nerub Entrance"] = 5568,
	["Ahn'kahet: The Old Kingdom Entrance"] = 5569,
	["Drak'Tharon Keep Entrance"] = 5570,
	["Violet Hold Entrance"] = 5571,
	["Gundrak Entrance"] = 5572,
	["Halls of Stone Entrance"] = 5573,
	["Halls of Lightning Entrance"] = 5574,
	["Trial of the Champion Entrance"] = 5575,
	["The Forge of Souls Entrance"] = 5576,
	["Pit of Saron Entrance"] = 5577,
	["Halls of Reflection Entrance"] = 5578,
	["Throne of the Tides Entrance"] = 5579,
	["Grim Batol Entrance"] = 5580,
	["The Stonecore Entrance"] = 5581,
	["The Threshold"] = 5582,
	["The Vortex Pinnacle"] = 5583,
	["Altar of Twilight"] = 5584,
	["Gate of Hamatep"] = 5585,
	["Vir'naal River"] = 5586,
	["Twilight Aerie"] = 5588,
	["The Twilight Withering"] = 5589,
	["Twilight Bulwark"] = 5590,
	["Sunken Dig Site"] = 5591,
	["The Hidden Clutch"] = 5592,
	["The Nosebleeds"] = 5593,
	["Highland Forest"] = 5594,
	["Obsidian Forest"] = 5595,
	["Cradle of the Ancients"] = 5596,
	["Obelisk of the Sun"] = 5597,
	["Sunken Temple Entrance"] = 5598,
	["Lost City of the Tol'vir"] = 5599,
	["Baradin Hold"] = 5600,
	["Chamber of the Sun"] = 5601,
	["Schnottz's Landing"] = 5602,
	["Eastpoint Tower"] = 5603,
	["Sludgeguard Tower"] = 5604,
	["Shriveled Oasis"] = 5605,
	["Ruins of Ammon"] = 5606,
	["The Black Breach"] = 5609,
	["Tomb of the Earthrager"] = 5610,
	["Firebeard Cemetery"] = 5611,
	["The Cursed Landing"] = 5612,
	["The Steps of Fate"] = 5613,
	["The Trail of Devastation"] = 5614,
	["Pyrox Flats"] = 5615,
	["The Verdant Thicket"] = 5622,
	["The Circle of Cinders"] = 5623,
	["The Tranquil Grove"] = 5624,
	["Ruins of Lar'donir"] = 5625,
	["Shadowlurk Ridge"] = 5626,
	["Black Drake Roost"] = 5627,
	["Iron Summit"] = 5628,
	["Thorium Advance"] = 5629,
	["The Maelstrom"] = 5630,
	["Oasis of the Fallen Prophet"] = 5631,
	["The Trapper's Enclave"] = 5632,
	["Terrace of the Augurs"] = 5633,
	["Sanctum of the South Wind"] = 5634,
	["The Warlord's Garrison"] = 5635,
	["Lion's Pride Inn"] = 5637,
	["Throne of the Four Winds"] = 5638,
	["Glopgut's Hollow"] = 5639,
	["Humboldt Conflagration"] = 5640,
	["The Twilight Breach"] = 5641,
	["Tahret Grounds"] = 5642,
	["Seal of the Sun King"] = 5644,
	["Whisperwind Grove"] = 5645,
	["Sahket Wastes"] = 5646,
	["Ruins of Ahmtul"] = 5647,
	["Wildheart Point"] = 5649,
	["The Whelping Downs"] = 5650,
	["Flamestar Post"] = 5651,
	["Black Tooth Hovel"] = 5652,
	["Fields of Honor"] = 5653,
	["Chiselgrip"] = 5654,
	["Firegut Furnace"] = 5655,
	["The Skull Warren"] = 5656,
	["D-Block"] = 5657,
	["Cursed Depths"] = 5658,
	["The Hole"] = 5659,
	["Obsidian Lair"] = 5660,
	["Neferset City"] = 5663,
	["Iso'rath"] = 5664,
	["Sunwatcher's Ridge"] = 5665,
	["Vir'naal Dam"] = 5666,
	["Cannon's Inferno"] = 5667,
	["Obelisk of the Moon"] = 5668,
	["Temple of Uldum"] = 5669,
	["Oasis of Vir'sar"] = 5670,
	["Ruins of Khintaset"] = 5671,
	["Chamber of the Moon"] = 5672,
	["Sullah's Sideshow"] = 5673,
	["Maker's Ascent"] = 5674,
	["Arikara's Needle"] = 5675,
	["Irontree Clearing"] = 5676,
	["Valley of Ashes"] = 5677,
	["Sindweller's Rise"] = 5678,
	["Neferset City Outskirts"] = 5679,
	["Wildhammer Flag Room"] = 5680,
	["Dragonmaw Flag Room"] = 5681,
	["Thunderstrike Mountain"] = 5682,
	["Beneath The Double Rainbow"] = 5683,
	["Throne of the Four Winds"] = 5684,
	["Pilgrim's Precipice"] = 5685,
	["Bashal'Aran Collapse"] = 5686,
	["The Howling Oak"] = 5687,
	["Mount Akher"] = 5688,
	["Tombs of the Precursors"] = 5689,
	["Arsad Trade Post"] = 5690,
	["Darkspear Shore"] = 5691,
	["The Deathknell Graves"] = 5692,
	["Murkdeep Cavern"] = 5693,
	["Keset Pass"] = 5694,
	["Ahn'Qiraj: The Fallen Kingdom"] = 5695,
	["Surveyors' Outpost"] = 5696,
	["M.A.C. Diver"] = 5697,
	["Tomb of the Sun King"] = 5698,
	["The Circle of Life"] = 5699,
	["Schnottz's Hostel"] = 5700,
	["Halls of Origination Entrance"] = 5701,
	["The Vortex Pinnacle Entrance"] = 5702,
	["Goodgrub Smoking Pit"] = 5703,
	["The Catacombs"] = 5704,
	["Snowden Chalet"] = 5705,
	["The Steam Pools"] = 5706,
	["Beryl Egress"] = 5707,
	["Lost City of the Tol'vir Entrance"] = 5708,
	["Atulhet's Tomb"] = 5709,
	["The Lightless Reaches"] = 5710,
	["The Lightless Reaches"] = 5711,
	["The Blackwald"] = 5712,
	["Hayward Fishery"] = 5713,
	["Stormglen Village"] = 5714,
	["Vir'naal Oasis"] = 5715,
	["Vir'naal Lake"] = 5716,
	["Vir'naal River Delta"] = 5717,
	["Fortune's Fist"] = 5718,
	["The Commons"] = 5719,
	["Duskmist Shore"] = 5720,
	["Brashtide Attack Fleet"] = 5721,
	["Firelands"] = 5723,
	["Twilight Camp"] = 5724,
	["Camp Mojache Longhouse"] = 5726,
	["Scott's Spooky Area"] = 5727,
	["Falconwing Inn"] = 5728,
	["Blackwing Descent"] = 5729,
	["Nordrassil Inn"] = 5730,
	["Whelgar's Retreat"] = 5731,
	["Halls of Origination"] = 5732,
	["Molten Front"] = 5733,
	["Sarahland"] = 5734,
	["The Wandering Isle"] = 5736,
	["Pei-Wu Forest"] = 5737,
	["Malfurion's Breach"] = 5738,
	["Ashen Fields"] = 5739,
	["Magma Springs"] = 5740,
	["Igneous Depths"] = 5741,
	["Forlorn Spire"] = 5742,
	["The Widow's Clutch"] = 5743,
	["Wildflame Point"] = 5744,
	["The Furnace"] = 5745,
	["The Molten Flow"] = 5746,
	["Crumbling Stones"] = 5747,
	["Fireplume Peak"] = 5748,
	["Ragnaros' Reach"] = 5749,
	["Dreadmist Camp"] = 5758,
	["Rhyolith Plateau"] = 5763,
	["Beth'tilac's Lair"] = 5764,
	["Flamebreach"] = 5765,
	["Shatterstone"] = 5766,
	["Mortal's Demise"] = 5767,
	["Sulfuron Span"] = 5768,
	["Sulfuron Keep Courtyard"] = 5769,
	["Sulfuron Keep"] = 5770,
	["The Molten Fields"] = 5771,
	["Dragonmaw Stronghold"] = 5775,
	["Wildhammer Stronghold"] = 5776,
	["Thalassian Range"] = 5779,
	["Amani Mountains"] = 5780,
	["Nordune Ridge"] = 5781,
	["Darsok's Outpost"] = 5782,
	["A Dark Place"] = 5783,
	["Cloudtop Terrace"] = 5784,
	["The Jade Forest"] = 5785,
	["The Nexus"] = 5786,
	["Schnottz's Frigate"] = 5787,
	["Well of Eternity"] = 5788,
	["End Time"] = 5789,
	["Ruby Dragonshrine"] = 5790,
	["The Ridge of Ancient Flame"] = 5791,
	["Obsidian Dragonshrine"] = 5792,
	["Azure Dragonshrine"] = 5793,
	["Emerald Dragonshrine"] = 5794,
	["Bronze Dragonshrine"] = 5795,
	["Entryway of Time"] = 5796,
	["The Staidridge"] = 5797,
	["The Anvil of Conflagration"] = 5798,
	["Eye of the Storm"] = 5799,
	["Blood Elf Tower"] = 5800,
	["Draenei Ruins"] = 5802,
	["Fel Reaver Ruins"] = 5803,
	["Mage Tower"] = 5804,
	["Valley of the Four Winds"] = 5805,
	["Spine of the Destroyer UNUSED"] = 5806,
	["Beth'tilac's Lair"] = 5807,
	["Sulfuron Keep Courtyard"] = 5808,
	["Sulfuron Keep"] = 5809,
	["Anvil of Conflagration"] = 5810,
	["The Molten Fields"] = 5811,
	["Mortal's Demise"] = 5812,
	["Sulfuron Span"] = 5813,
	["Shatterstone"] = 5814,
	["Flamebreach"] = 5815,
	["The Ridge of Ancient Flame"] = 5816,
	["Rhyolith Plateau"] = 5817,
	["Firelands"] = 5818,
	["Temple of Five Dawns"] = 5820,
	["The Path of Corruption"] = 5821,
	["Circle of Thorns"] = 5823,
	["Bluff of the South Wind"] = 5824,
	["The Dawning Valley"] = 5825,
	["The Singing Pools"] = 5826,
	["The Rows"] = 5827,
	["Mandori Village"] = 5828,
	["Ridge of Laughing Winds"] = 5829,
	["Morning Breeze Village"] = 5830,
	["Fe-Feng Village"] = 5831,
	["The Wood of Staves"] = 5832,
	["Wreck of the Skyseeker"] = 5833,
	["Shang Xi Training Grounds"] = 5834,
	["Wu-Song Village"] = 5835,
	["Forest Heart"] = 5836,
	["The Dawning Span"] = 5837,
	["Whispering Forest"] = 5838,
	["The Great Divide"] = 5839,
	["Vale of Eternal Blossoms"] = 5840,
	["Kun-Lai Summit"] = 5841,
	["Townlong Steppes"] = 5842,
	["Tranquil Grotto"] = 5843,
	["Hour of Twilight"] = 5844,
	["Wyrmrest Temple"] = 5845,
	["Fu's Pond"] = 5846,
	["The Dawning Stair"] = 5847,
	["Cave of Meditation"] = 5848,
	["Shrine of Inner-Light"] = 5849,
	["Silken Shore"] = 5850,
	["Paw'don Glade"] = 5851,
	["Wreck of the Vanguard"] = 5852,
	["Garrosh'ar Point"] = 5853,
	["Nectarbreeze Orchard"] = 5854,
	["Tian Monastery"] = 5855,
	["Shrine of Remembrance"] = 5856,
	["Camp Gormal"] = 5857,
	["The Elders' Path"] = 5859,
	["Liang's Retreat"] = 5860,
	["Darkmoon Island"] = 5861,
	["Pool of Reflection"] = 5862,
	["Banquet Grounds"] = 5863,
	["Wreck of Hellscream's Fist"] = 5865,
	["Ascent of Swirling Winds"] = 5866,
	["Strongarm Airstrip"] = 5867,
	["The Ring of Inner Focus"] = 5868,
	["The Great Sea"] = 5869,
	["The Darkmoon Faire"] = 5870,
	["The Ring of Balance"] = 5871,
	["Slingtail Pits"] = 5872,
	["Sea Mist Ridge"] = 5873,
	["Waxwood"] = 5874,
	["Lair of the Jade Witch"] = 5875,
	["Serpent's Heart"] = 5876,
	["Darkmoon Deathmatch"] = 5877,
	["Orchid Hollow"] = 5878,
	["Terrace of Ten Thunders"] = 5879,
	["Maelstrom Deathwing Fight"] = 5880,
	["The Dai-Lo Farmstead"] = 5881,
	["Virmen Grotto"] = 5882,
	["Teeming Burrow"] = 5883,
	["Ki-Han Brewery"] = 5884,
	["Shrine of Dreaming Stones"] = 5885,
	["Chamber of Whispers"] = 5886,
	["Shadybranch Pocket"] = 5887,
	["Fox Grove"] = 5890,
	["Shang's Valley"] = 5891,
	["Dragon Soul"] = 5892,
	["The Maelstrom"] = 5893,
	["Testing02"] = 5894,
	["Testing SubZone A"] = 5895,
	["The Orchid Pond - NOT USED"] = 5896,
	["The Fertile Copse"] = 5897,
	["Serenity Falls"] = 5898,
	["Path of Enlightenment"] = 5899,
	["Exclamation Point"] = 5900,
	["Cave of Words"] = 5901,
	["Darkmoon Path"] = 5902,
	["Darkmoon Boardwalk"] = 5904,
	["Camp Nooka Nooka"] = 5905,
	["Spire of Solitude"] = 5906,
	["Lake Kittitata"] = 5907,
	["Circle of Scale"] = 5908,
	["Circle of Blood"] = 5909,
	["Circle of Bone"] = 5910,
	["Circle of Stone"] = 5911,
	["Tideview Thicket"] = 5912,
	["Dire Maul - North"] = 5913,
	["Dire Maul - East"] = 5914,
	["Dire Maul - West"] = 5915,
	["Stratholme - Main Gate"] = 5916,
	["Stratholme - Service Entrance"] = 5917,
	["Shado-Pan Monastery"] = 5918,
	["Uncharted Sea"] = 5919,
	["Eye of Eternity"] = 5920,
	["Tasters' Arena"] = 5921,
	["Above the Frozen Sea"] = 5922,
	["The Dragon Wastes"] = 5923,
	["Azure Dragonshrine"] = 5924,
	["Emerald Dragonshrine"] = 5925,
	["Path of the Titans"] = 5926,
	["Wyrmrest Summit"] = 5928,
	["The Silkwood"] = 5929,
	["Dawn's Blossom"] = 5930,
	["The Arboretum"] = 5931,
	["Shrine of the Dawn"] = 5932,
	["The Gong of Hope"] = 5933,
	["Pearl Lake"] = 5934,
	["Pearlfin Village"] = 5935,
	["Pang's Stead"] = 5936,
	["Thunderfoot Fields"] = 5937,
	["Thunderfoot Ranch"] = 5938,
	["Thunderfoot Farm"] = 5939,
	["Dreamer's Pavilion"] = 5940,
	["The Great Sea"] = 5941,
	["Tigers' Wood"] = 5942,
	["Amberfly Bog"] = 5943,
	["Forlorn Hut"] = 5944,
	["Pool of the Paw"] = 5945,
	["Morning Breeze Lake"] = 5946,
	["Shrine of Five Dawns"] = 5947,
	["Grassy Cline"] = 5948,
	["Shang's Stead"] = 5949,
	["Grookin Hill"] = 5950,
	["Dookin' Grounds"] = 5951,
	["Scenic Overlook"] = 5952,
	["Murky Bank"] = 5953,
	["Den of Sorrow"] = 5954,
	["Greenstone Quarry"] = 5955,
	["Temple of the Jade Serpent"] = 5956,
	["Mudmug's Place"] = 5957,
	["Sunsoaked Meadow"] = 5958,
	["The Twisted Warren"] = 5959,
	["Deathwing"] = 5960,
	["Slicky Stream"] = 5961,
	["Emperor's Omen"] = 5962,
	["Stormstout Brewery"] = 5963,
	["The Bamboo Wilds"] = 5964,
	["Woods of the Lost"] = 5966,
	["Paoquan Hollow"] = 5967,
	["Stoneplow"] = 5968,
	["Stoneplow Fields"] = 5969,
	["Singing Marshes"] = 5970,
	["Pools of Purity"] = 5972,
	["New Cifera"] = 5973,
	["Jade Temple Grounds"] = 5974,
	["Temple of the Jade Serpent"] = 5975,
	["Gate of the Setting Sun"] = 5976,
	["Ancient Courtyard"] = 5978,
	["The Great Sea"] = 5979,
	["Halfhill"] = 5980,
	["The Halfhill Market"] = 5981,
	["The Imperial Granary"] = 5982,
	["Plain of Thieves"] = 5983,
	["Gilded Fan"] = 5984,
	["Winds' Edge"] = 5985,
	["Silken Fields"] = 5986,
	["The Gilding Stream"] = 5987,
	["The Crystal Vice"] = 5988,
	["The Dragon Wastes"] = 5989,
	["Galakrond's Rest"] = 5990,
	["Path of the Titans"] = 5991,
	["The Heartland"] = 5992,
	["Courtyard of Lights"] = 5993,
	["Shores of the Well"] = 5994,
	["Azshara's Palace"] = 5995,
	["Springtail Warren"] = 5996,
	["Zhu's Watch"] = 6000,
	["Stormstout Brewery"] = 6001,
	["Thirsty Alley"] = 6002,
	["The Deepwild"] = 6004,
	["Zhu Province"] = 6005,
	["The Veiled Stair"] = 6006,
	["Thunder Cleft"] = 6007,
	["Ruins of Dojan"] = 6008,
	["The Incursion"] = 6009,
	["Dojani River"] = 6010,
	["Pools of Youth"] = 6011,
	["Windward Isle"] = 6012,
	["Dawnchaser Retreat"] = 6013,
	["Krasarang River"] = 6014,
	["Ruins of Korja"] = 6015,
	["Sentinel Basecamp"] = 6016,
	["Fallsong Village"] = 6017,
	["Krasari Falls"] = 6018,
	["The Forbidden Jungle"] = 6019,
	["The Southern Wall"] = 6020,
	["Huangtze Falls"] = 6021,
	["Mistveil Sea"] = 6022,
	["Windspire Bridge"] = 6023,
	["The Windspire"] = 6024,
	["Nesingwary's Safari"] = 6025,
	["The Krasari Ruins"] = 6026,
	["Virmen Nest"] = 6027,
	["Dustback Gorge"] = 6028,
	["The Torjari Pit"] = 6029,
	["The Wild Plains"] = 6030,
	["Mistfall Village"] = 6031,
	["Ruins of Guo-Lai"] = 6032,
	["The Golden Stair"] = 6033,
	["Whitepetal Lake"] = 6034,
	["Setting Sun Garrison"] = 6035,
	["The Golden Pagoda"] = 6036,
	["Tu Shen Burial Ground"] = 6037,
	["Lair of the Beast"] = 6038,
	["Sunsong Ranch"] = 6039,
	["Dustwallow Marsh"] = 6040,
	["The Great Sea"] = 6041,
	["Theramore Isle"] = 6042,
	["Dustwallow Marsh"] = 6043,
	["Dustwallow Bay"] = 6044,
	["Alcaz Island"] = 6045,
	["Foothold Citadel"] = 6046,
	["The Sea Wolf"] = 6047,
	["Temple of the Red Crane"] = 6048,
	["Crane Wing Refuge"] = 6049,
	["Spiritsong River"] = 6050,
	["Temple of Kotmogu"] = 6051,
	["Scarlet Halls"] = 6052,
	["Ruins Rise"] = 6053,
	["Winterbough Glade"] = 6054,
	["The Five Sisters"] = 6055,
	["Shattered Convoy"] = 6058,
	["Binan Village"] = 6059,
	["Temple of Kotmogu"] = 6060,
	["Temple of Kotmogu"] = 6061,
	["Kun-Lai Pass"] = 6062,
	["Moonwater Retreat"] = 6063,
	["Skyrange"] = 6064,
	["Kunzen Village"] = 6065,
	["Scholomance"] = 6066,
	["Terrace of Endless Spring"] = 6067,
	["Inkgill Mere"] = 6069,
	["The Drunken Hozen"] = 6071,
	["Lao & Son's Yakwash"] = 6072,
	["The Autumn Plains"] = 6073,
	["Guo-Lai Halls"] = 6074,
	["The Golden Gateway"] = 6075,
	["Auburn Bluffs"] = 6076,
	["Sri-La Village"] = 6077,
	["Seat of the Spirit Waker"] = 6078,
	["The Grummle Bazaar"] = 6079,
	["Serpent's Overlook"] = 6080,
	["Peak of Serenity"] = 6081,
	["The Splintered Path"] = 6082,
	["Camp Broketooth"] = 6083,
	["The Deeper"] = 6084,
	["One Keg"] = 6085,
	["Broketooth Outpost"] = 6086,
	["The Dooker Dome"] = 6087,
	["Knucklethump Hole"] = 6088,
	["Yeti Mountain Basecamp"] = 6089,
	["The Burlap Trail"] = 6090,
	["The Burlap Valley"] = 6091,
	["Greenstone Masons' Quarter"] = 6092,
	["Fire Camp Bataar"] = 6093,
	["Eastwind Rest"] = 6094,
	["Westwind Rest"] = 6095,
	["Cattail Lake"] = 6096,
	["Kunzen Cave"] = 6097,
	["Chow Farmstead"] = 6098,
	["Pranksters' Hollow"] = 6099,
	["Muskpaw Ranch"] = 6100,
	["A Brewing Storm"] = 6101,
	["Thunderpaw Refuge"] = 6102,
	["Thunderpaw Overlook"] = 6103,
	["Thunderpaw Refuge"] = 6104,
	["Thunderpaw Overlook"] = 6105,
	["Anglers Wharf"] = 6106,
	["Verdant Belt"] = 6107,
	["Narsong Trench"] = 6108,
	["Scarlet Monastery"] = 6109,
	["The Thunderwood"] = 6110,
	["The Burlap Waystation"] = 6111,
	["CTF3"] = 6112,
	["Narsong Spires"] = 6113,
	["Mogujia"] = 6114,
	["Fountain of the Everseeing"] = 6117,
	["The Scrollkeeper's Sanctum"] = 6118,
	["Terrace of the Twin Dragons"] = 6119,
	["The Heart of Jade"] = 6120,
	["Fire Camp Ruqin"] = 6121,
	["Grove of Falling Blossoms"] = 6122,
	["SM Cathedral/GY (TEMP)"] = 6123,
	["Fire Camp Ordo"] = 6124,
	["Mogu'shan Vaults"] = 6125,
	["Silvershard Mines"] = 6126,
	["The Silent Sanctuary"] = 6127,
	["Shado-Pan Fallback"] = 6128,
	["Firebough Nook"] = 6129,
	["Krasarang Wilds"] = 6134,
	["Nayeli Lagoon"] = 6135,
	["Temple of Kotmogu"] = 6136,
	["Frostmane Hovel"] = 6137,
	["Dread Wastes"] = 6138,
	["Mogu Ruins Bural Pit (TEMP)"] = 6140,
	["Shrine of Two Moons"] = 6141,
	["Shrine of Seven Stars"] = 6142,
	["Mogu'shan Palace"] = 6143,
	["Jin Yang Road"] = 6144,
	["The Summer Fields"] = 6145,
	["Marista"] = 6146,
	["Kea Krak"] = 6147,
	["Unga Ingoo"] = 6148,
	["Ancestral Rise"] = 6149,
	["The Ox Gate"] = 6150,
	["Mortbreath Grotto"] = 6151,
	["Fire Camp Yongqi"] = 6152,
	["Peak of Serenity"] = 6153,
	["Yinying Village"] = 6154,
	["Cradle of Chi-Ji"] = 6155,
	["Kota Peak"] = 6156,
	["Kota Basecamp"] = 6157,
	["Sandy Shallows"] = 6158,
	["Sarjun Depths"] = 6159,
	["Angkhal Pavilion"] = 6160,
	["Pedestal of Hope"] = 6161,
	["Dome Balrissa"] = 6162,
	["Fire Camp Osul"] = 6163,
	["Lower Sumprushes"] = 6164,
	["Upper Sumprushes"] = 6165,
	["Longying Outpost"] = 6166,
	["Zouchin Strand"] = 6168,
	["Zouchin Village"] = 6169,
	["Northshire"] = 6170,
	["Hatred's Vice"] = 6171,
	["Tallmug's Camp"] = 6172,
	["Shado-Pan Monastery"] = 6173,
	["Temple of the White Tiger"] = 6174,
	["Seeker's Folly"] = 6175,
	["Coldridge Valley"] = 6176,
	["Owen's Wishing Well"] = 6179,
	["Neverest Pinnacle"] = 6180,
	["Waterspeaker's Sanctuary"] = 6181,
	["Mogu'shan Palace"] = 6182,
	["Seeker's Point"] = 6184,
	["Mount Neverest"] = 6185,
	["Neverest Basecamp"] = 6186,
	["Gao-Ran Battlefront"] = 6187,
	["Shallowstep Pass"] = 6188,
	["The Widening Deep"] = 6189,
	["Dampsoil Burrow"] = 6190,
	["Dusklight Hollow"] = 6191,
	["Dusklight Bridge"] = 6192,
	["Rensai's Watchpost"] = 6193,
	["Farwatch Overlook"] = 6194,
	["Sik'vess"] = 6195,
	["Sik'vess Lair"] = 6196,
	["Shado-Pan Garrison"] = 6197,
	["Valley of Emperors"] = 6198,
	["Tomb of Shadows"] = 6199,
	["Tomb of Secrets"] = 6200,
	["Tomb of Conquerors"] = 6201,
	["Shrine of the Merciless One"] = 6202,
	["Emperor Rikktik's Rest"] = 6203,
	["Greenstone Village"] = 6204,
	["Kri'vess"] = 6205,
	["Whispercloud Rise"] = 6206,
	["The Zandalari Vanguard"] = 6207,
	["Crypt of Forgotten Kings"] = 6208,
	["The Jade Forest"] = 6209,
	["Greenstone Village"] = 6210,
	["Greenstone Masons' Quarter"] = 6211,
	["Sra'thik Incursion"] = 6212,
	["Niuzao Temple"] = 6213,
	["Siege of Niuzao Temple"] = 6214,
	["Valley Of Power - Scenario"] = 6215,
	["Valley of Power"] = 6216,
	["The Dark Hollow"] = 6218,
	["Arena of Annihilation"] = 6219,
	["Fields of Niuzao"] = 6220,
	["Dread Expanse"] = 6234,
	["Stormwind Keep"] = 6292,
	["Lake of Stars"] = 6293,
	["Shado-Li Basin"] = 6294,
	["Seat of Knowledge"] = 6295,
	["Tol'viron Arena"] = 6296,
	["Heart of Fear"] = 6297,
	["Brawl'gar Arena"] = 6298,
	["The Amber Womb"] = 6299,
	["Kypari Zar"] = 6300,
	["Training Grounds"] = 6301,
	["Huntsman's Cloister"] = 6302,
	["The Kennel"] = 6303,
	["Black Ox Temple"] = 6304,
	["Terrace of Gurthan"] = 6306,
	["Shan'ze Dao"] = 6307,
	["Sri-La Inn"] = 6308,
	["Unga Ingoo"] = 6309,
	["Unga Ingoo"] = 6310,
	["Niuzao Catacombs"] = 6311,
	["Fire Camp Gai-Cho"] = 6312,
	["Scenario - Black Ox Temple"] = 6313,
	["Sra'vess"] = 6314,
	["Klaxxi'vess"] = 6315,
	["Ik'vess"] = 6316,
	["Klik'vess"] = 6317,
	["Set'vess"] = 6318,
	["Scenario - Mogu Ruins"] = 6319,
	["Assault on Zan'vess"] = 6328,
	["Kor'vess"] = 6329,
	["Westersea"] = 6331,
	["The Overlook Inn"] = 6332,
	["Paur's Pub"] = 6333,
	["The Sunset Brewgarden"] = 6334,
	["The Horrid March"] = 6335,
	["Rikkitun Village"] = 6336,
	["Gokk'lok Shallows"] = 6337,
	["The Amber Hibernal"] = 6338,
	["Rikkilea"] = 6339,
	["Kun-Lai Pass"] = 6340,
	["Binan Village"] = 6341,
	["Ambermarsh"] = 6342,
	["Kypari Vor"] = 6343,
	["Nook of Konk"] = 6345,
	["Morrowchamber"] = 6346,
	["The Amber Vault"] = 6347,
	["Deadtalker's Plateau"] = 6348,
	["The Dancing Serpent"] = 6349,
	["The Lazy Turnip"] = 6354,
	["Thunderfoot Inn"] = 6355,
	["Stone Mug Tavern"] = 6356,
	["Wilds' Edge Inn"] = 6358,
	["Binan Brew & Stew"] = 6359,
	["The Lucky Traveller"] = 6360,
	["The Two Fisted Brew"] = 6361,
	["North Wind Tavern"] = 6362,
	["The Golden Rose"] = 6363,
	["Tavern in the Mists"] = 6364,
	["The Chum Bucket"] = 6365,
	["Marista's Bait & Brew"] = 6366,
	["Greenstone Inn"] = 6367,
	["Soggy's Gamble"] = 6368,
	["Krasarang Cove"] = 6369,
	["Turtle Beach"] = 6370,
	["The Southern Isles"] = 6371,
	["Gate of Endless Spring"] = 6372,
	["The Secret Aerie"] = 6373,
	["Tavern in the Mists"] = 6375,
	["The Ancient Passage"] = 6376,
	["Hatescale Burrow"] = 6377,
	["Field of Korja"] = 6378,
	["Greenstone Dojo"] = 6379,
	["Path of a Hundred Steps"] = 6380,
	["The Spring Road"] = 6381,
	["Mason's Folly"] = 6382,
	["Winter's Blossom"] = 6383,
	["Forlorn Cloister"] = 6384,
	["Crusader's Chapel"] = 6385,
	["Chapel Gardens"] = 6386,
	["Rumbling Terrace"] = 6387,
	["Zhu's Descent"] = 6388,
	["Howlingwind Cavern"] = 6389,
	["Gai-Cho Battlefield"] = 6390,
	["The Briny Muck"] = 6391,
	["The Underbough"] = 6392,
	["Serpent's Spine"] = 6393,
	["Serpent's Spine"] = 6394,
	["Serpent's Spine"] = 6395,
	["Gate of the Setting Sun"] = 6396,
	["The Clarion Bell"] = 6397,
	["Shrine of Twin Serpents"] = 6398,
	["Shelf of Mazu"] = 6401,
	["Wreck of the Mist-Hopper"] = 6402,
	["Muckscale Grotto"] = 6403,
	["Muckscale Shallows"] = 6404,
	["Zouchin Province"] = 6405,
	["Isle of Reckoning"] = 6406,
	["Thunder's Call"] = 6407,
	["Forward Assault Camp"] = 6408,
	["Rear Staging Area"] = 6409,
	["Hollowed Out Tree"] = 6410,
	["Forward Assault Camp"] = 6411,
	["Rear Staging Area"] = 6412,
	["Hollowed Out Tree"] = 6413,
	["Grove of Falling Blossoms"] = 6414,
	["The Yaungol Advance"] = 6415,
	["Yan-Zhe River"] = 6417,
	["Venomous Ledge"] = 6418,
	["Kun-Lai Summit"] = 6419,
	["The Feeding Pits"] = 6420,
	["Kzzok Warcamp"] = 6421,
	["Sra'thik Swarmdock"] = 6422,
	["Ikz'ka Ridge"] = 6423,
	["Sra'vess Rootchamber"] = 6424,
	["Forgotten Mire"] = 6425,
	["Brewmoon Festival"] = 6426,
	["Inkgill Mere"] = 6427,
	["The Ancient Passage"] = 6428,
	["Chittering Coast"] = 6429,
	["Anglers Expedition"] = 6430,
	["Seaspittle Cove"] = 6431,
	["Amberglow Hollow"] = 6432,
	["Lonesome Cove"] = 6433,
	["The Thundering Run"] = 6434,
	["Heart of Fear"] = 6435,
	["Dread Clutch"] = 6436,
	["Fear Clutch"] = 6437,
	["Horror Clutch"] = 6438,
	["Panic Clutch"] = 6439,
	["Kypari Ik"] = 6440,
	["Duskroot Fen"] = 6441,
	["The Clutches of Shek'zeer"] = 6442,
	["Writhingwood"] = 6443,
	["Zan'vess"] = 6444,
	["Whispering Stones"] = 6445,
	["Amber Quarry"] = 6446,
	["The Stinging Trail"] = 6447,
	["Mazu's Overlook"] = 6448,
	["Temple of Kotmogu"] = 6449,
	["Shadowglen"] = 6450,
	["Valley of Trials"] = 6451,
	["Camp Narache"] = 6452,
	["Echo Isles"] = 6453,
	["Deathknell"] = 6454,
	["Sunstrider Isle"] = 6455,
	["Ammen Vale"] = 6456,
	["New Tinkertown"] = 6457,
	["Kyparite Quarry"] = 6458,
	["Venomsting Pits"] = 6459,
	["The Briny Muck"] = 6460,
	["Whispering Stones"] = 6461,
	["Path of Conquerors"] = 6462,
	["Dustwallow Marsh"] = 6463,
	["Cavern of Endless Echoes"] = 6466,
	["Mogu'shan Terrace"] = 6467,
	["The Emperor's Reach"] = 6468,
	["Howlingwind Trail"] = 6469,
	["The Gilded Foyer"] = 6470,
	["The Crimson Assembly Hall"] = 6471,
	["Forgotten Passageway"] = 6472,
	["Vault of Kings Past"] = 6473,
	["Throne of Ancient Conquerors"] = 6474,
	["Bladelord's Retreat"] = 6475,
	["Shrine of Nala'shi"] = 6476,
	["South Seas"] = 6477,
	["South Seas"] = 6478,
	["South Seas"] = 6479,
	["South Seas"] = 6480,
	["South Seas"] = 6481,
	["The Summer Terrace"] = 6482,
	["The Emperor's Step"] = 6483,
	["The Golden Lantern"] = 6484,
	["Chamber of Enlightenment"] = 6485,
	["The Celestial Vault"] = 6486,
	["Ethereal Corridor"] = 6487,
	["The Star's Bazaar"] = 6488,
	["The Imperial Exchange"] = 6489,
	["Nightingale Lounge"] = 6490,
	["Chamber of Reflection"] = 6492,
	["Shrine of Fellowship"] = 6494,
	["The Hall of Tiles"] = 6495,
	["Guo-Lai Ritual Chamber"] = 6496,
	["The Hall of Statues"] = 6497,
	["Gate of the August Celestials"] = 6498,
	["The Hall of the Serpent"] = 6499,
	["Dustwallow Marsh"] = 6500,
	["The Lady Mehley"] = 6501,
	["Theramore Isle"] = 6502,
	["Guo-Lai Vault"] = 6503,
	["The Emperor's Approach"] = 6504,
	["The Riverblade Den"] = 6505,
	["Motherseed Pit"] = 6506,
	["Isle of Thunder"] = 6507,
	["Springtail Crag"] = 6508,
	["Stormstout Brewery Interior"] = 6509,
	["The Deadmines"] = 6510,
	["Wailing Caverns"] = 6511,
	["The Widow's Wail"] = 6512,
	["Oona Kagu"] = 6513,
	["Maraudon"] = 6514,
	["Terrace of Endless Spring"] = 6515,
	["Paw'don Village"] = 6516,
	["Twinspire Keep"] = 6517,
	["Path of Serenity"] = 6518,
	["Summer's Rest"] = 6519,
	["Gokk'lok's Grotto"] = 6520,
	["Honeydew Village"] = 6521,
	["Honeydew Glade"] = 6522,
	["Honeydew Farm"] = 6523,
	["Thunder Hold"] = 6524,
	["Hellscream's Fist"] = 6525,
	["Training Grounds"] = 6526,
	["Terrace of the Tiger"] = 6527,
	["Serpent's Spine"] = 6528,
	["Hellscream's Fist"] = 6529,
	["Serpent's Spine"] = 6530,
	["The Skyfire"] = 6533,
	["Twinspire Keep Interior"] = 6534,
	["Den of Defiance"] = 6535,
	["Autumnshade Ridge"] = 6538,
	["Sunblossom Hill"] = 6539,
	["Spiritsong's Rest"] = 6540,
	["Applebloom Tavern"] = 6541,
	["Terrace of Gurthan"] = 6542,
	["Mistblade Den"] = 6543,
	["Coldbite Burrow"] = 6544,
	["Greymane Manor"] = 6545,
	["Emberstone Mine"] = 6546,
	["The Deepwild"] = 6547,
	["Venomous Ledge"] = 6548,
	["Sra'vess"] = 6549,
	["Fields of Niuzao"] = 6550,
	["Townlong Steppes"] = 6551,
	["Kun-Lai Summit"] = 6552,
	["Shrine of Seven Stars"] = 6553,
	["Shrine of Two Moons"] = 6554,
	["Northern Elwynn Mountains"] = 6555,
	["Valiant Rest"] = 6556,
	["Zouchin Province"] = 6557,
	["The Zandalari Vanguard"] = 6558,
	["The Golden Terrace"] = 6560,
	["Kril'Mandar Point"] = 6561,
	["The Southern Isles"] = 6562,
	["Krasarang Cove"] = 6563,
	["Dagger in the Dark"] = 6565,
	["Domination Point"] = 6566,
	["Battle on the High Seas"] = 6567,
	["Snicklefritz Mine"] = 6572,
	["Defense of the Alehouse"] = 6573,
	["Krasarang Wilds"] = 6574,
	["Krasarang Wilds"] = 6575,
	["Diremoor"] = 6576,
	["The Thunderspire"] = 6577,
	["Court of Bones"] = 6578,
	["Za'Tual"] = 6579,
	["Ihgaluk Crag"] = 6580,
	["Zeb'tula"] = 6581,
	["Shaol'mara"] = 6582,
	["Violet Rise"] = 6583,
	["Dawnseeker Promontory"] = 6584,
	["The Emperor's Gate"] = 6585,
	["The Beast Pens"] = 6586,
	["Conqueror's Terrace"] = 6587,
	["Bloodied Crossing"] = 6588,
	["Lightning Vein Mine"] = 6589,
	["The Thunder Forges"] = 6590,
	["Stormsea Landing"] = 6591,
	["The Swollen Vault"] = 6592,
	["The Foot of Lei Shen"] = 6593,
	["Hall of the Defamed"] = 6594,
	["The Skyfire"] = 6595,
	["Lion's Landing"] = 6596,
	["Sparkrocket Outpost"] = 6597,
	["Blacksand Spillway"] = 6600,
	["Bilgewater Beach"] = 6601,
	["The Boiling Crustacean"] = 6602,
	["Oregrind's Dig"] = 6603,
	["Quickchop's Lumber Farm"] = 6604,
	["Heart of Zan'vess"] = 6605,
	["Class Quest"] = 6606,
	["Heyman's Hubris"] = 6608,
	["Ruins of Ogudei"] = 6609,
	["The Ancient Passage"] = 6610,
	["Dalaran"] = 6611,
	["Horde Landing Site"] = 6612,
	["Black Temple"] = 6613,
	["Illidari Training Grounds"] = 6614,
	["Krasarang Wilds"] = 6615,
	["A Little Patience"] = 6616,
	["Garrosh'ar Advance"] = 6617,
	["Bizmo's Brawlpub"] = 6618,
	["Ruins of Korune"] = 6619,
	["Lair of Skiggit"] = 6620,
	["Temple of the Red Crane"] = 6621,
	["Throne of Thunder"] = 6622,
	["Antonidas Memorial"] = 6623,
	["Circle of Wills"] = 6624,
	["Krasus' Landing"] = 6625,
	["Krasus' Landing"] = 6626,
	["The Silver Enclave"] = 6627,
	["Dalaran City"] = 6628,
	["The Violet Citadel"] = 6629,
	["The Violet Citadel Spire"] = 6630,
	["Sewer Exit Pipe"] = 6631,
	["Sewer Exit Pipe"] = 6632,
	["Dalaran Floating Rocks"] = 6633,
	["Sunreaver's Sanctuary"] = 6634,
	["Dalaran Island"] = 6635,
	["The Violet Hold"] = 6636,
	["The Underbelly"] = 6637,
	["The Eventide"] = 6638,
	["Magus Commerce Exchange"] = 6639,
	["Vargoth's Retreat"] = 6640,
	["Violet Citadel Balcony"] = 6641,
	["Runeweaver Square"] = 6642,
	["Lion's Landing"] = 6643,
	["Domination Point"] = 6644,
	["Crane Wing Refuge"] = 6645,
	["Fallsong Village"] = 6646,
	["The Jade Forest"] = 6647,
	["The Spring Road"] = 6648,
	["Valley of the Four Winds"] = 6649,
	["Kun-Lai Summit"] = 6650,
	["Vale of Eternal Blossoms"] = 6651,
	["The Veiled Stair"] = 6652,
	["The Skyfire"] = 6653,
	["Predator's Perch"] = 6654,
	["Isle of Giants"] = 6661,
	["Talador"] = 6662,
	["Deepwind Gorge"] = 6665,
	["Infiltrating the Shipyard"] = 6666,
	["Troll War Camp Outskirts"] = 6667,
	["Shipyard"] = 6668,
	["Warship"] = 6669,
	["Sea"] = 6670,
	["Hall of the Exalted"] = 6671,
	["Bleak Hollow"] = 6672,
	["To The Skies!"] = 6673,
	["Dawnseeker Promontory"] = 6674,
	["Isle of Thunder"] = 6675,
	["Bay of Echoes"] = 6676,
	["Isle of Thunder"] = 6677,
	["Dun Morogh"] = 6678,
	["Shimmer Ridge"] = 6679,
	["Battlefront Provisions"] = 6680,
	["Lightning Vein Mine"] = 6681,
	["Tanaan Jungle"] = 6682,
	["Misty Shores"] = 6683,
	["Diremoor"] = 6686,
	["Court of Bones"] = 6687,
	["Za'Tual"] = 6688,
	["Ihgaluk Crag"] = 6689,
	["Violet Rise"] = 6690,
	["Dawnseeker Promontory"] = 6691,
	["The Emperor's Gate"] = 6692,
	["The Beast Pens"] = 6693,
	["Conqueror's Terrace"] = 6694,
	["Bloodied Crossing"] = 6695,
	["The Thunder Forges"] = 6696,
	["Stormsea Landing"] = 6697,
	["The Foot of Lei Shen"] = 6698,
	["Heyman's Hubris"] = 6699,
	["Bay of Echoes"] = 6700,
	["Beeble's Wreck"] = 6701,
	["Bozzle's Wreck"] = 6702,
	["Whispering Inlet"] = 6703,
	["Whispering Inlet"] = 6704,
	["Outdoor Ruins"] = 6705,
	["Forgotten Depths"] = 6706,
	["Thunder King's Citadel"] = 6707,
	["The Crimson Treader"] = 6708,
	["Salabria"] = 6709,
	["The Starchaser"] = 6710,
	["Spellsails"] = 6711,
	["The Seabolt"] = 6712,
	["Rhonin's Beard"] = 6713,
	["Hall of the Grand Imperion"] = 6714,
	["Thunder King's Citadel"] = 6716,
	["Zeb'tula"] = 6717,
	["Shaol'mara"] = 6718,
	["Shadowmoon Valley"] = 6719,
	["Frostfire Ridge"] = 6720,
	["Gorgrond"] = 6721,
	["Spires of Arak"] = 6722,
	["Tanaan Jungle"] = 6723,
	["Backbreaker Bay"] = 6724,
	["Greymist Firth"] = 6725,
	["Wildvine Marsh"] = 6726,
	["Shadewood Thicket"] = 6727,
	["Isle of Giants"] = 6728,
	["Isle of Thunder"] = 6729,
	["Hidden Cell"] = 6730,
	["The Secrets of Ragefire"] = 6731,
	["The Tiger's Peak"] = 6732,
	["Vale of Eternal Blossoms"] = 6733,
	["Big Blossom Excavation"] = 6734,
	["Big Blossom Mine"] = 6735,
	["Deepwind Gorge"] = 6736,
	["Deepwind Gorge"] = 6737,
	["Siege of Orgrimmar"] = 6738,
	["The Swollen Vault"] = 6739,
	["Frostwind Crag"] = 6742,
	["Throm'var"] = 6743,
	["Daggermaw Ravine"] = 6744,
	["Grulloc's Grotto"] = 6745,
	["Siege of Orgrimmar (OLD DO NOT USE)"] = 6746,
	["Razor Hill Outskirts"] = 6747,
	["Sen'jin Village Outskirts"] = 6748,
	["Vault of Y'Shaarj"] = 6749,
	["Razor Hill Watchtower"] = 6750,
	["Big Blossom Excavation"] = 6751,
	["Big Blossom Mine"] = 6752,
	["Deepwind Gorge"] = 6753,
	["Deepwind Gorge"] = 6754,
	["Nagrand"] = 6755,
	["Faralohn"] = 6756,
	["Timeless Isle"] = 6757,
	["Icescar Boneyard"] = 6758,
	["Lashwind Cleft"] = 6759,
	["Stromgarde Keep"] = 6760,
	["Gul'rok"] = 6761,
	["Shattrath City Center"] = 6762,
	["Theramore's Fall"] = 6763,
	["Brawnbelly Barracks"] = 6764,
	["Digger Flats"] = 6765,
	["The Pits"] = 6766,
	["Blightstone Quarry"] = 6767,
	["The Iron Tower"] = 6768,
	["Blackguard's Forgotten Cove"] = 6770,
	["Celestial Tournament"] = 6771,
	["The Cursed Woods"] = 6772,
	["Old Pi'jiu"] = 6773,
	["The Cracking Plains"] = 6774,
	["Colossal's Fall"] = 6775,
	["The Boneslag"] = 6776,
	["Stonefang Outpost"] = 6777,
	["Icewind Drifts"] = 6778,
	["Grom'gar"] = 6779,
	["Cavern of Lost Spirits"] = 6780,
	["Altar of Kron"] = 6781,
	["Ascent of Frostfire"] = 6782,
	["Refuse Pit"] = 6783,
	["Magnarok"] = 6784,
	["K'arani Terrace"] = 6785,
	["Grommar"] = 6787,
	["Lunarfall"] = 6790,
	["The Burial Fields"] = 6791,
	["Shaz'gul"] = 6792,
	["Light's Fall"] = 6793,
	["Teluuna Observatory"] = 6794,
	["Starfall Outpost"] = 6796,
	["Gul'var"] = 6797,
	["Scarred Vale"] = 6798,
	["Bladefist Bay"] = 6799,
	["Dranosh'ar Landing"] = 6800,
	["The Darkspear Offensive"] = 6801,
	["Before the Gates"] = 6802,
	["Valley of Strength"] = 6803,
	["The Drag"] = 6804,
	["Gate of the Breakers"] = 6805,
	["Dark Heart of Pandaria"] = 6807,
	["Watcher's Den"] = 6809,
	["Giant's Fall"] = 6810,
	["Secluded Glade"] = 6811,
	["Greenstone Village"] = 6812,
	["Lion's Landing"] = 6813,
	["Blood in the Snow"] = 6814,
	["Domination Point"] = 6815,
	["Stormwind"] = 6816,
	["Grimfrost Hill"] = 6817,
	["[PH] - SMV - Alliance Garrison"] = 6820,
	["South Seas"] = 6821,
	["Ruby Lake"] = 6822,
	["Ordon Sanctuary"] = 6823,
	["Croaking Hollow"] = 6824,
	["Firewalker Ruins"] = 6825,
	["The Celestial Court"] = 6830,
	["Mossgreen Lake"] = 6831,
	["The Timeless Shore"] = 6832,
	["Tushui Landing"] = 6833,
	["Huojin Landing"] = 6834,
	["The Misty Strand"] = 6835,
	["Three-Breeze Terrace"] = 6836,
	["Kukuru's Grotto"] = 6837,
	["Tsavo'ka's Den"] = 6838,
	["Mysterious Den"] = 6839,
	["Whispershade Hollow"] = 6840,
	["Red Stone Run"] = 6841,
	["Firewalkers' Path"] = 6842,
	["Shrine of the Black Flame"] = 6843,
	["The Blazing Way"] = 6844,
	["Time-Lost Waters"] = 6846,
	["Turgall's Den"] = 6848,
	["Sootstained Mines"] = 6849,
	["Sootstained Mining Camp"] = 6850,
	["Grommar"] = 6851,
	["Proving Grounds"] = 6852,
	["[UNUSED]Hidey-Hole"] = 6854,
	["Gloomshade Grove"] = 6855,
	["The Shadow Rise"] = 6857,
	["Grulloc's Lair"] = 6861,
	["The Halfhill Market"] = 6862,
	["The Secret Ingredient"] = 6863,
	["Bladespire Citadel"] = 6864,
	["zzOld - Explosion Town [NOT TEMP NAME]"] = 6865,
	["Twilight Glade"] = 6866,
	["Circle of Blood"] = 6867,
	["Hall of the Great Hunt"] = 6868,
	["Wor'gol"] = 6869,
	["Gloomshade Grotto"] = 6870,
	["Farseer's Rock"] = 6871,
	["Terrace of the Stars"] = 6872,
	["Anguish Fortress"] = 6873,
	["Bloodmaul Slag Mines"] = 6874,
	["Bladespire Throne"] = 6875,
	["Bastion Rise"] = 6876,
	["Deadgrin"] = 6877,
	["Tailthrasher Basin"] = 6878,
	["The Broken Spine"] = 6879,
	["Evermorn Springs"] = 6880,
	["Beastwatch"] = 6881,
	["The Forgotten Caves"] = 6882,
	["Blackrock Pipeworks"] = 6883,
	["Mistcreep Mire"] = 6884,
	["Cragplume Cauldron"] = 6885,
	["Draenataur Cavern"] = 6886,
	["Stonemaul Arena"] = 6887,
	["Kor'gall's Hovel"] = 6888,
	["Brimstone Springs"] = 6889,
	["zzOld - Gorgrond Garrison Area"] = 6890,
	["Gronn Canyon"] = 6891,
	["The Pit"] = 6892,
	["Iyun Weald"] = 6893,
	["Gronn Cave"] = 6894,
	["Windward Ascent"] = 6895,
	["Elemental Hollow"] = 6896,
	["Blackrock Shipyard"] = 6897,
	["zzOld - Tankworks"] = 6898,
	["Affliction Ridge"] = 6899,
	["Sulfur Basin"] = 6900,
	["Grimrail Depot"] = 6901,
	["Reeg'ak's Nest"] = 6902,
	["Melted Burrow"] = 6903,
	["Gormaul Tower"] = 6905,
	["Frostwall Approach"] = 6906,
	["Mor'dul Tower"] = 6907,
	["[PH] Heroes Through Time"] = 6908,
	["Socrethar's Rise"] = 6909,
	["Darktide Roost"] = 6910,
	["Pit of the Devourer"] = 6911,
	["Auchindoun"] = 6912,
	["Gorgrond Pass"] = 6913,
	["Deeproot"] = 6914,
	["The Fertile Ground"] = 6915,
	["Court of Souls"] = 6916,
	["Liadrin's Watch"] = 6917,
	["Deathweb Hollow"] = 6918,
	["Telmor"] = 6920,
	["Plains of Serenity"] = 6921,
	["Moonflower Valley"] = 6922,
	["Embaari Village"] = 6923,
	["Aruuna"] = 6924,
	["Anchorite's Sojourn"] = 6925,
	["Veil Shadar"] = 6926,
	["Duskfall Island"] = 6927,
	["The Pilgrim's Road"] = 6928,
	["Frostboar Drifts"] = 6929,
	["Karabor"] = 6930,
	["Path of the Light"] = 6931,
	["Shadowmoon Burial Grounds"] = 6932,
	["Terokkar Refuge"] = 6933,
	["Rooter's Pass"] = 6934,
	["Razorbloom"] = 6935,
	["Blasted Lands (DO NOT USE)"] = 6936,
	["Sharptusk Lake"] = 6937,
	["Kuuro's Claim"] = 6938,
	["Butcher's Rise"] = 6939,
	["The Binding Trench"] = 6940,
	["Ashran"] = 6941,
	["Spineling Crevice"] = 6942,
	["Gardens of Eternity"] = 6943,
	["Tranquil Court"] = 6944,
	["The Coliseum of Light"] = 6945,
	["Karabor Harbor"] = 6946,
	["Orunai Coast"] = 6947,
	["Archenon Siegeyard"] = 6948,
	["Tuurem"] = 6949,
	["Mor'gran Logworks"] = 6950,
	["Iron Docks"] = 6951,
	["The Sulfic Refuge"] = 6952,
	["Shattered Beachhead"] = 6953,
	["Shattered Landing"] = 6954,
	["Bonetown Scenario"] = 6955,
	["Gronnstalkers' Cache"] = 6956,
	["Exile's Rise"] = 6957,
	["Pool of Visions"] = 6958,
	["Aruuna Crystal Mine"] = 6959,
	["Frostfire Ridge"] = 6960,
	["Canyon Pass"] = 6961,
	["Bladespire Ravine"] = 6962,
	["The Shattered Front"] = 6963,
	["Stonefang Ridge"] = 6964,
	["Thunder Pass"] = 6965,
	["Shivering Trench"] = 6966,
	["Blackrock Foundry"] = 6967,
	["Stonefury Cliffs"] = 6968,
	["Bloodmaul Slag Mines"] = 6969,
	["The Shadow Tower"] = 6970,
	["Shadowmoon Grotto"] = 6971,
	["Grommar Hold"] = 6972,
	["Grommar Docks"] = 6973,
	["[PH] Ashran [TRANSITION ZONE]"] = 6975,
	["Bloodthorn Cave"] = 6976,
	["The Verdant Mire"] = 6977,
	["Light's Rest"] = 6978,
	["Tomb of Souls"] = 6979,
	["Shattrath City"] = 6980,
	["Throne of Stonemaul"] = 6982,
	["Iron Siegeworks"] = 6983,
	["Grimrail Depot"] = 6984,
	["Chillwater Grotto"] = 6985,
	["Jorune Mine"] = 6986,
	["Waning Crescent"] = 6987,
	["Skyreach"] = 6988,
	["Lower Quarter"] = 6989,
	["Grand Spire"] = 6990,
	["The Overlook"] = 6991,
	["Moonwillow Peak"] = 6993,
	["Bones of Agurak"] = 6994,
	["Agurak's Fall"] = 6995,
	["Highmaul"] = 6996,
	["Ango'rosh Ruins"] = 6997,
	["Spires of Arak"] = 6998,
	["Admiral Taylor's Garrison"] = 6999,
	["Seat of Depravity"] = 7000,
	["Sunsworn Camp"] = 7001,
	["The Broken Crater"] = 7003,
	["Frostwall"] = 7004,
	["Snowfall Alcove"] = 7005,
	["Coldsnap Bluffs"] = 7006,
	["Frost Den"] = 7009,
	["Rangari Hollow"] = 7010,
	["Frostbite Hollow"] = 7011,
	["Sleeper's Lair"] = 7012,
	["Bloodmaul Stronghold"] = 7013,
	["Thunder Pass"] = 7014,
	["Spires of Arak"] = 7015,
	["Spires of Arak"] = 7016,
	["Blook's Overlook"] = 7017,
	["Ruins of Ata'gar"] = 7018,
	["The Gloomspire"] = 7019,
	["Retribution Point"] = 7020,
	["The Burning Front"] = 7021,
	["[PH] Test Zone"] = 7022,
	["[PH] Test Zone 2"] = 7023,
	["Iceblister Den"] = 7024,
	["Tanaan Jungle"] = 7025,
	["Okril'lon Hold"] = 7026,
	["The Forge Grounds"] = 7028,
	["Exarch's Refuge"] = 7029,
	["Dreadmaul Rise"] = 7030,
	["Skettis"] = 7031,
	["Garden of K'ure"] = 7032,
	["Darkspear's Edge"] = 7033,
	["Dreadtalon Peak"] = 7034,
	["Ravenskar"] = 7035,
	["Veil Terokk"] = 7036,
	["The Dark Portal"] = 7037,
	["Heartblood Tangle"] = 7038,
	["The Bleeding Altar"] = 7039,
	["Kargathar Proving Grounds"] = 7040,
	["Heartblood"] = 7041,
	["Umbral Halls"] = 7042,
	["Blackrock Quarry"] = 7043,
	["The Path of Glory"] = 7044,
	["Iron Bastion"] = 7045,
	["Lost Veil Anzu"] = 7046,
	["Forbidden Glacier"] = 7047,
	["Bloodthorn Hill"] = 7048,
	["The Nightmarsh"] = 7049,
	["Dyvari Overgrowth"] = 7051,
	["Sabermaw"] = 7052,
	["Remains of Xandros"] = 7053,
	["Blade's Edge Mountain"] = 7054,
	["Southwind Cliffs"] = 7055,
	["Warsong Lookout"] = 7056,
	["Gol'gor"] = 7057,
	["The Bleeding Mountain"] = 7058,
	["Wor'var"] = 7059,
	["Hemet's Happy Hunting Grounds"] = 7060,
	["Yrel's Watch"] = 7061,
	["The Burning Glacier"] = 7062,
	["Riverside Post"] = 7063,
	["The Stones of Prophecy"] = 7064,
	["Lok-rath"] = 7065,
	["Nagrand Corral"] = 7066,
	["Mar'gok's Overwatch"] = 7067,
	["Grommashar"] = 7068,
	["Gates of Grommashar"] = 7069,
	["Ironfist Harbor"] = 7070,
	["Snarlpaw Ledge"] = 7071,
	["Ancestral Grounds"] = 7072,
	["The Ring of Trials"] = 7073,
	["Telaar"] = 7074,
	["Wolf's Stand"] = 7075,
	["Iron Waystation"] = 7076,
	["Lunarfall"] = 7078,
	["Frostcave"] = 7079,
	["Emberfall Tower"] = 7080,
	["Telaari Station"] = 7081,
	["Shadowmoon Mine"] = 7082,
	["Defense of Karabor"] = 7083,
	["Aruuna's Desolation"] = 7084,
	["$n's Outpost"] = 7085,
	["$n's Garrison"] = 7086,
	["$n's Level 4 Alliance Garrison"] = 7087,
	["Ring of Conquest"] = 7088,
	["Tomb of Lights"] = 7089,
	["Zorkra's Fall"] = 7090,
	["The Shimmer Moor"] = 7091,
	["Arena Floor"] = 7092,
	["Terokkar Pass"] = 7093,
	["Stonecrag Gorge"] = 7094,
	["Wrecked Caravan"] = 7095,
	["$n's Outpost"] = 7096,
	["Fort Wrynn"] = 7097,
	["Vol'jin's Pride"] = 7098,
	["Warspear Outpost"] = 7099,
	["Stormshield Stronghold"] = 7100,
	["$n's Garrison"] = 7103,
	["$n's Level 4 Horde Garrison"] = 7104,
	["Rangari Overlook"] = 7105,
	["Hillsbrad Foothills (Southshore vs. Tarren Mill)"] = 7107,
	["The Everbloom"] = 7109,
	["The Undergrowth"] = 7110,
	["Crow's Crook"] = 7111,
	["Frostwolf Overlook"] = 7112,
	["Wolf's Stand"] = 7113,
	["Auchenai Precipice"] = 7114,
	["Zangarra"] = 7115,
	["Elodor"] = 7116,
	["Elodor Fields"] = 7117,
	["Fey Landing"] = 7118,
	["Rangari Enclave"] = 7119,
	["Altar of Sha'tar"] = 7120,
	["Exarch's Rise"] = 7121,
	["Arbor Glen"] = 7122,
	["Hallvalor"] = 7123,
	["The Masters' Cavern"] = 7124,
	["Shadowglade"] = 7125,
	["Camp Thornscar"] = 7126,
	["Veil Akraz"] = 7127,
	["Raider's Hideout"] = 7128,
	["Tar'thog Bridge"] = 7129,
	["Bladefist Rise"] = 7130,
	["Gordal Fortress"] = 7131,
	["Redemption Rise"] = 7132,
	["Durotan's Grasp"] = 7133,
	["Draka's Den"] = 7134,
	["Mount Volwrath"] = 7135,
	["Draxen's Workshop"] = 7136,
	["Trak's Rise"] = 7138,
	["Elemental Plateau"] = 7139,
	["Bloodmane Valley"] = 7140,
	["Arch of Sha'tar"] = 7141,
	["Nest of the Ravenspeakers"] = 7142,
	["Gnarlwood Pass"] = 7143,
	["Blademoon Bloom"] = 7144,
	["Sethekk Hollow"] = 7145,
	["Bones of Sethe"] = 7146,
	["The Broken Spire"] = 7147,
	["Daggerjaw Intrusion"] = 7148,
	["Crimson Fen"] = 7149,
	["Oshu'gun"] = 7150,
	["Spirit Woods"] = 7151,
	["Naielle's Watch"] = 7152,
	["Wildwood Wash"] = 7153,
	["Drywind Gorge"] = 7154,
	["Valley of Destruction"] = 7155,
	["Anguish Point"] = 7156,
	["Khadgar's Tower"] = 7157,
	["Highpass"] = 7158,
	["Frondfall"] = 7159,
	["Fissure of Fury"] = 7160,
	["The Draakorium"] = 7161,
	["Pinchwhistle Gearworks"] = 7162,
	["Pinchwhistle Point"] = 7163,
	["Wreck of the Mother Lode"] = 7164,
	["Fiona's Caravan"] = 7165,
	["Highpass Logging Camp"] = 7166,
	["Elodor Dig"] = 7167,
	["Terror's Cave"] = 7168,
	["The Soul Engine"] = 7169,
	["zzOld - Sundered Pass"] = 7170,
	["Heart of the Fen"] = 7171,
	["Shadowfall Canyon"] = 7172,
	["Eventide Landing"] = 7173,
	["Ketya's Hideaway"] = 7175,
	["Gordal Foothills"] = 7176,
	["Glut's Burrow"] = 7177,
	["Rexxar's Refuge"] = 7178,
	["Throne of the Witch Lord"] = 7179,
	["Talon Watch"] = 7180,
	["Lithic's Rest"] = 7181,
	["Talon Altar"] = 7182,
	["Breaker's Crown"] = 7183,
	["zzOld - Imperial Road"] = 7184,
	["Moira's Reach"] = 7185,
	["Mok'gor"] = 7186,
	["Kag'ah"] = 7187,
	["Gra'ah"] = 7188,
	["Shrine of Othaar"] = 7189,
	["Dionor's Demise"] = 7190,
	["Talador"] = 7191,
	["The Underbelly"] = 7192,
	["Market District"] = 7193,
	["The Imperator's Favor"] = 7194,
	["Gorian Strand"] = 7195,
	["Path of Victors"] = 7196,
	["Axefall"] = 7197,
	["Southport"] = 7198,
	["Apexis Excavation"] = 7199,
	["Auchindoun"] = 7200,
	["Brute's Rise"] = 7201,
	["The Writhing Mire"] = 7202,
	["The Underpale"] = 7203,
	["Sanctum of the Naaru"] = 7204,
	["Grom'kar Gulch"] = 7205,
	["Lonely Falls"] = 7206,
	["Apexis Chamber"] = 7207,
	["The Briny Barnacle"] = 7208,
	["Bladespire Span"] = 7209,
	["$n's Fort"] = 7210,
	["$n's Fort"] = 7211,
	["PattyMack Test Area"] = 7212,
	["Garden Plaza"] = 7213,
	["Fountain Plaza"] = 7214,
	["Moonlit Shore"] = 7215,
	["Great Tree Valuundira"] = 7216,
	["Gates of Grommashar"] = 7217,
	["Grommashar"] = 7218,
	["Sporemist Shallows"] = 7219,
	["Forgotten Shore"] = 7220,
	["Isle of Shadows"] = 7221,
	["Admiral Taylor's Farm"] = 7222,
	["Black Altar of Xan'tish"] = 7223,
	["Tangleheart"] = 7224,
	["Umbrafen"] = 7225,
	["Eastwind Gulch"] = 7226,
	["Skysong Lake"] = 7227,
	["Vile Cavern"] = 7228,
	["Town Hall"] = 7229,
	["Great Hall"] = 7230,
	["Swamplight Trail"] = 7231,
	["Drybone Hollow"] = 7232,
	["Frostangler Bay"] = 7233,
	["Coldsnap Coast"] = 7234,
	["Colossal Depths"] = 7235,
	["Tor'goroth's Tooth"] = 7236,
	["Bloodmaul Landing"] = 7237,
	["Iron Sea"] = 7238,
	["Zangar Sea"] = 7239,
	["Southwind Inlet"] = 7241,
	["The Pale Cove"] = 7242,
	["Frostboar Point"] = 7243,
	["Frostbite Deep"] = 7244,
	["Ata'gar Promontory"] = 7245,
	["Gloomshade Cove"] = 7246,
	["Ozgor's Launch"] = 7247,
	["Throm'var Landing"] = 7248,
	["ShadowmoonCape"] = 7249,
	["Umbrafen Point"] = 7250,
	["Orunai Bay"] = 7251,
	["Orunai Delta"] = 7252,
	["Shadowmoon Rise"] = 7253,
	["Zangar Sea"] = 7255,
	["Darktide Strait"] = 7256,
	["Glacier Bay"] = 7257,
	["The Evanescent Sea"] = 7258,
	["Iron Sea"] = 7259,
	["Frostchill Lagoon"] = 7260,
	["Frostbite Wall"] = 7261,
	["Tanaan Channel"] = 7262,
	["Bloodmaul Scar"] = 7263,
	["Shadowmoon Coast"] = 7264,
	["Tanaan Channel"] = 7265,
	["The Rusty Cylinder"] = 7266,
	["Vault of the Titan"] = 7267,
	["Terokkar Wayshrine"] = 7268,
	["Spire of Light"] = 7269,
	["The Howling Crag"] = 7270,
	["Worgskin's Camp"] = 7271,
	["Murkbog"] = 7272,
	["Silence Pond"] = 7273,
	["Veil Zekk"] = 7274,
	["Molten Quarry"] = 7275,
	["Forlorn Delta"] = 7276,
	["Bloodmane Pridelands"] = 7277,
	["Leorajh's Den"] = 7278,
	["Amphitheater of Annihilation"] = 7279,
	["Throne of the Elements"] = 7280,
	["Savage Fight Club"] = 7281,
	["Lowlands Lumber Yard"] = 7282,
	["Highpass Sparring Ring"] = 7283,
	["Arcane Sanctum"] = 7284,
	["Arcane Sanctum"] = 7285,
	["Vol'jin's Arsenal"] = 7286,
	["Wrynn Artillery Tower"] = 7287,
	["Smuggler's Den"] = 7288,
	["Smuggler's Den"] = 7289,
	["Hearthfire Tavern"] = 7290,
	["Stoktron Brewery"] = 7291,
	["Wor'var Corral"] = 7292,
	["Rangari Corral"] = 7293,
	["Wor'var Tankworks"] = 7294,
	["Telaari Tankworks"] = 7295,
	["Mok'gol Watchpost"] = 7296,
	["Ruins of Na'gwa"] = 7297,
	["Overlook Ruins"] = 7298,
	["Ruins of the First Bastion"] = 7299,
	["Barrier Sea"] = 7300,
	["Mok'gol Hold"] = 7301,
	["Shadow's Vigil"] = 7302,
	["Broken Precipice"] = 7303,
	["Steamscar Rise"] = 7304,
	["Terrace of Dawn"] = 7305,
	["Windswept Terrace"] = 7306,
	["Upper Blackrock Spire"] = 7307,
	["Harvesting Pits"] = 7308,
	["The Iron Wharf"] = 7309,
	["Blackhand's Might"] = 7310,
	["Ashmaul Burial Grounds"] = 7311,
	["Castaway Cave"] = 7312,
	["The Destroyed Expedition"] = 7313,
	["[Test] Sound Design"] = 7314,
	["Shattered Rise"] = 7315,
	["Skettis"] = 7316,
	["Bladefist Hold"] = 7317,
	["The Sheltered Den"] = 7318,
	["Gorgorek's Fall"] = 7319,
	["Everbloom Wilds"] = 7320,
	["Abandoned Highmaul Mine"] = 7321,
	["Crushfang's End"] = 7322,
	["Ashen Crater"] = 7323,
	["Lunarfall Excavation"] = 7324,
	["Lunarfall Excavation"] = 7325,
	["Lunarfall Excavation"] = 7326,
	["Frostwall Mine"] = 7327,
	["Frostwall Mine"] = 7328,
	["Frostwall Mine"] = 7329,
	["Stormwind"] = 7330,
	["Cerulean Lagoon"] = 7331,
	["Stormshield"] = 7332,
	["Warspear"] = 7333,
	["Azsuna"] = 7334,
	["Hatecoil Slave Pen"] = 7335,
	["Smuggler's Bay"] = 7336,
	["The Burning Gate"] = 7337,
	["Runas's Hovel"] = 7338,
	["Zarkhenar Temple"] = 7339,
	["Azurewing Repose"] = 7340,
	["Nor'Danil Wellspring"] = 7341,
	["Queen's Reprisal"] = 7342,
	["[UNUSED]"] = 7343,
	["Shipwreck Arena"] = 7344,
	["Mak'rana"] = 7345,
	["Rhut'van Passage"] = 7346,
	["Oceanus Cove"] = 7348,
	["Faronaar"] = 7349,
	["Legion Camp: Ruin"] = 7351,
	["El'dranil Shallows"] = 7352,
	["Kraklaa's Hatchery"] = 7353,
	["Legion Camp: Chaos"] = 7354,
	["Crumbled Palace"] = 7355,
	["Vanquish Point"] = 7356,
	["Drowned Gardens"] = 7357,
	["Nar'thalas Academy"] = 7358,
	["Azurewing Whelplands"] = 7359,
	["Llothien Highlands"] = 7360,
	["Ley-Ruins of Zarkhenar"] = 7361,
	["Faronaar Front"] = 7362,
	["The Royal Pond"] = 7363,
	["Illidari Stand"] = 7364,
	["Hatecoil Warcamp"] = 7365,
	["Ruins of Nar'thalas"] = 7366,
	["Highmaul"] = 7367,
	["Gurgthock's Stash"] = 7368,
	["The Shattered Tower"] = 7369,
	["Azulae Outpost"] = 7370,
	["Gorian Proving Grounds"] = 7375,
	["The Ring of Blood"] = 7376,
	["Time-Lost Glade"] = 7377,
	["The Dark Woods"] = 7378,
	["Gorian Falls"] = 7379,
	["The Trial of Faith"] = 7381,
	["Pools of Life"] = 7382,
	["Verdant Grove"] = 7383,
	["The Violet Bluff"] = 7384,
	["Zangar Shore"] = 7385,
	["Spiteleaf Thicket"] = 7386,
	["Brak's Excavation"] = 7387,
	["Bladefury's Command"] = 7389,
	["The Gates of Tanaan"] = 7390,
	["The Path of Glory"] = 7391,
	["Pillars of Fate"] = 7392,
	["Verdantis Pass"] = 7393,
	["Steamburst Cauldron"] = 7394,
	["The Coliseum"] = 7395,
	["Darksting Cave"] = 7396,
	["Moonlit Shore"] = 7397,
	["Ishaal's Hut"] = 7399,
	["Zellek's Hut"] = 7400,
	["Cavern of Lament"] = 7401,
	["Evermorn Rise"] = 7402,
	["The Compost Heap"] = 7403,
	["Lernaean Shore"] = 7404,
	["Highmaul Harbor"] = 7405,
	["The Cliffs of Highmaul"] = 7406,
	["The South Sea"] = 7407,
	["Windroc Bay"] = 7408,
	["The Sunset Shore"] = 7409,
	["The South Sea"] = 7410,
	["The Iron Approach"] = 7411,
	["Assassin's Cove"] = 7412,
	["Spirit Whisper Hollow"] = 7413,
	["Skysea Ridge"] = 7414,
	["The Iron Approach"] = 7415,
	["Sulfurscale Cave"] = 7416,
	["Sha'tari Anchorage"] = 7417,
	["Shattrath Port Authority"] = 7418,
	["Beacon of Sha'tar"] = 7419,
	["Shattrath City"] = 7420,
	["Shattrath Commons"] = 7421,
	["Sha'tari Market District"] = 7422,
	["Grimrail Crash Site"] = 7423,
	["Riverbeast Den"] = 7424,
	["Lamplighter Inn"] = 7425,
	["The Crescent Hearth"] = 7426,
	["The Silken Pillow"] = 7427,
	["Barrier Sea"] = 7428,
	["Iron Pass"] = 7429,
	["The Colossal's Fist"] = 7431,
	["Elemental Plateau"] = 7432,
	["Telaari Worksite"] = 7433,
	["Wor'var Worksite"] = 7434,
	["Aarko's Estate"] = 7435,
	["The South Sea"] = 7436,
	["Witherwind Pass"] = 7437,
	["Seat of Kor'lok"] = 7438,
	["Kings' Rest"] = 7439,
	["Echidnean Shelf"] = 7440,
	["Warspear Base"] = 7441,
	["Stormshield Base"] = 7442,
	["Ashran"] = 7444,
	["The Evanescent Sea"] = 7445,
	["Barrier Sea"] = 7446,
	["Colossal Depths"] = 7447,
	["Barrier Sea"] = 7448,
	["The Thorn Pits"] = 7449,
	["The Savage Crag"] = 7450,
	["Broken Horn Village"] = 7451,
	["Doomtide Cove"] = 7452,
	["Sha'tar Way Station"] = 7453,
	["Sha'tari Skymesa"] = 7454,
	["Shattrath Residential District"] = 7455,
	["Overgrown Den"] = 7456,
	["Sher'khaan's Den"] = 7457,
	["Deadmeat's House of Meat"] = 7459,
	["Den of Secrets"] = 7460,
	["Earthshaker Gorge"] = 7461,
	["The Coliseum"] = 7462,
	["The Coliseum"] = 7463,
	["The Path of Victors"] = 7464,
	["Gorian Strand"] = 7465,
	["The Imperator's Favor"] = 7466,
	["Market District"] = 7467,
	["The Underbelly"] = 7468,
	["Hidden Camp"] = 7469,
	["Mount Kra'gor"] = 7470,
	["Dol'mak's Hideout"] = 7471,
	["Deadwalker Pass"] = 7472,
	["Hills of Valuun"] = 7473,
	["Thaelin's Workshop"] = 7474,
	["Garrison - Alliance - Inn"] = 7475,
	["Volrath's Advance"] = 7476,
	["The Crossroads"] = 7477,
	["Tremblade's Vanguard"] = 7478,
	["Archmage Overwatch"] = 7479,
	["Shattrath Overlook"] = 7480,
	["Akeeta's Hovel"] = 7481,
	["Fort Wrynn Worksite"] = 7482,
	["Vol'jin's Pride Worksite"] = 7483,
	["Southport Worksite"] = 7484,
	["Axefall Worksite"] = 7485,
	["Stormwind Gate"] = 7486,
	["Fiendish Vault"] = 7488,
	["Cragplume Cauldron"] = 7489,
	["Garrison"] = 7490,
	["Saraah's Vale"] = 7492,
	["Iron Siegeworks"] = 7493,
	["Bones of Agurak"] = 7494,
	["Tanaan Coast"] = 7495,
	["Tanaan Valley"] = 7496,
	["Traitor's Overlook"] = 7497,
	["Shadowmoon Valley (Outland)"] = 7498,
	["Nagrand (Outland)"] = 7499,
	["Orunai Delta"] = 7500,
	["Orunai Coast"] = 7501,
	["Dalaran"] = 7502,
	["Highmountain"] = 7503,
	["The Violet Citadel"] = 7504,
	["Krasus' Landing"] = 7505,
	["Krasus' Landing"] = 7506,
	["Greyfang Enclave"] = 7508,
	["The Burning Nether"] = 7510,
	["Ravager Den"] = 7513,
	["Zeth'Kur"] = 7514,
	["Ironhold Harbor"] = 7515,
	["The Lost Orchard"] = 7517,
	["Edge of Reality"] = 7519,
	["Iron Docks"] = 7520,
	["Old Coast Path"] = 7521,
	["Lion's Watch"] = 7522,
	["Vol'mar"] = 7523,
	["Ruins of Kra'nak"] = 7524,
	["Farlight Terrace"] = 7525,
	["Temple of Sha'naar"] = 7526,
	["The Iron Front"] = 7527,
	["Broken Shore"] = 7534,
	["Challiane's Terrace"] = 7535,
	["Aktar's Post"] = 7536,
	["Vault of the Earth"] = 7537,
	["Throne of Kil'jaeden"] = 7538,
	["Zeth'Gol"] = 7539,
	["Lair of the Deposed"] = 7540,
	["Stormheim"] = 7541,
	["Weeping Bluffs"] = 7542,
	["Broken Shore"] = 7543,
	["Aggramar's Vault"] = 7544,
	["Hellfire Citadel"] = 7545,
	["Neltharion's Lair"] = 7546,
	["The Black City"] = 7547,
	["Ashran Mine"] = 7548,
	["[TEMP] Stormshield Excavation"] = 7549,
	["[TEMP] Warspear Excavation"] = 7550,
	["[TEMP] The Hollow"] = 7551,
	["[TEMP] The Ancient Vault"] = 7552,
	["[TEMP] The Dark Below"] = 7553,
	["Garden of Elune"] = 7554,
	["Skyfire Triage Camp"] = 7555,
	["Farondale"] = 7556,
	["Stormscale Cavern"] = 7557,
	["Val'sharah"] = 7558,
	["Steelclaw Vale"] = 7559,
	["The Lost Temple"] = 7562,
	["Cove of Nashal"] = 7563,
	["Forsaken Foothold"] = 7564,
	["Nor'Danil Wellspring"] = 7567,
	["Llothien Highlands"] = 7568,
	["Faronaar"] = 7569,
	["The Royal Pond"] = 7570,
	["Olivian Veil"] = 7571,
	["Thas'talah"] = 7572,
	["Hope's End"] = 7574,
	["Light's Landing"] = 7575,
	["Twisting Nether"] = 7576,
	["The Master's Promontory"] = 7577,
	["Eye of Azshara"] = 7578,
	["Rainfern Basin"] = 7579,
	["Antonidas Memorial"] = 7580,
	["Dalaran City"] = 7581,
	["Circle of Wills"] = 7582,
	["The Violet Citadel Spire"] = 7583,
	["Sewer Exit Pipe"] = 7584,
	["Sewer Exit Pipe"] = 7585,
	["The Bleeding Hollow"] = 7586,
	["Dalaran Floating Rocks"] = 7587,
	["Helheim"] = 7588,
	["Windrunner's Sanctuary"] = 7589,
	["Dalaran Island"] = 7590,
	["Vault of Eyes"] = 7591,
	["The Violet Hold"] = 7592,
	["Runeweaver Square"] = 7593,
	["The Underbelly"] = 7594,
	["The Eventide"] = 7595,
	["Magus Commerce Exchange"] = 7596,
	["Vargoth's Retreat"] = 7597,
	["Violet Citadel Balcony"] = 7598,
	["Shackle's Den"] = 7599,
	["Lorlathil"] = 7600,
	["Grove of Cenarius"] = 7601,
	["The Empyrean Society Enclave"] = 7602,
	["Blackbeak Overlook"] = 7603,
	["Zorammarsh"] = 7604,
	["Wretched Hollow"] = 7605,
	["Skulltaker's Crater"] = 7606,
	["Forever Rise"] = 7607,
	["Hrydshal"] = 7608,
	["[TEMP] JT (copy)"] = 7609,
	["Stormwing Rookery"] = 7610,
	["Galebroken Path"] = 7611,
	["Thorim's Peak"] = 7612,
	["The Fel Forge"] = 7615,
	["The Forgotten Roost"] = 7616,
	["Moonclaw Vale"] = 7617,
	["Timeworn Strand"] = 7618,
	["The Greenway"] = 7620,
	["Llothien"] = 7621,
	["The Breached Ossuary"] = 7622,
	["Tomb of Sargeras"] = 7624,
	["The Black Rose"] = 7625,
	["The Blightcaller"] = 7626,
	["The Windrunner"] = 7627,
	["The Desolation of Gorefiend"] = 7628,
	["Helya's Throne"] = 7629,
	["The Eternal Battlefield"] = 7630,
	["Honeyglow Glade"] = 7631,
	["Ironmonger's Hold"] = 7632,
	["The Ruined Sanctum"] = 7633,
	["Feralas (copy)"] = 7634,
	["[TEMP] Placeholder Area - Level Design Dev Land Only"] = 7635,
	["The Corrupted Refuge"] = 7636,
	["Suramar"] = 7637,
	["Sanctum of Light"] = 7638,
	["Thornmire"] = 7639,
	["Fang'rila"] = 7641,
	["Bradensbrook"] = 7642,
	["Gates of Valor"] = 7643,
	["Felblaze Ingress"] = 7646,
	["Moonrest"] = 7647,
	["Sleeping Hollow"] = 7649,
	["Marl's Stead"] = 7650,
	["Field of Fallen Kings"] = 7651,
	["The Runewood"] = 7652,
	["Haustvald"] = 7653,
	["Stygana Cavern"] = 7654,
	["Rangari Refuge"] = 7655,
	["The Great Sea"] = 7656,
	["Glittering Falls"] = 7657,
	["The Cove of Nashal"] = 7658,
	["Heroes' Rest"] = 7659,
	["Ravencourt"] = 7661,
	["Ironhorn Enclave"] = 7662,
	["Tanaan Jungle"] = 7663,
	["Oakheart"] = 7664,
	["Shala'nir"] = 7665,
	["Shadowfen"] = 7666,
	["Garden of the Moon"] = 7667,
	["Thas'talah Basin"] = 7668,
	["Darkgrove Cavern"] = 7669,
	["Cave of the Betrayed"] = 7670,
	["Magula's Den"] = 7671,
	["Halls of Valor"] = 7672,
	["Darkheart Thicket"] = 7673,
	["Legion Dungeon"] = 7674,
	["Darkpens"] = 7675,
	["The Bore"] = 7676,
	["Temple of Elune"] = 7677,
	["Lok'goron Foundry"] = 7678,
	["Acherus: The Ebon Hold"] = 7679,
	["Lunarwing Shallows"] = 7680,
	["Tyr's Fall"] = 7681,
	["Saberfang Cavern"] = 7682,
	["The Windrunner"] = 7683,
	["The Banshee's Wail"] = 7684,
	["The Black Rose"] = 7685,
	["The Eternity"] = 7686,
	["The Creeping Death"] = 7687,
	["The Blightcaller"] = 7688,
	["Smolderhide Thicket"] = 7689,
	["The Skyfire"] = 7690,
	["Small Battleground D"] = 7691,
	["Whispering Bluffs"] = 7692,
	["Temple of a Thousand Lights"] = 7693,
	["Skold-Ashil"] = 7694,
	["Icecrown Citadel"] = 7695,
	["The Frozen Throne"] = 7696,
	["Blades of the Fallen Prince"] = 7697,
	["Dreadwake's Landing"] = 7698,
	["Greywatch"] = 7699,
	["Ranger's Foothold"] = 7700,
	["Crowley's Overlook"] = 7701,
	["Dreadroot"] = 7702,
	["Frostwall Shipyard"] = 7703,
	["Malorne's Refuge"] = 7704,
	["Mardum, the Shattered Abyss"] = 7705,
	["Lunarfall Shipyard"] = 7706,
	["The Iron Bulwark"] = 7707,
	["Temple of Elune"] = 7708,
	["Riverbend"] = 7709,
	["Mistvale"] = 7710,
	["Huln's Rise"] = 7711,
	["Illidari Foothold"] = 7712,
	["Inferno Peak"] = 7713,
	["Bitestone Enclave"] = 7714,
	["Hellfire Citadel"] = 7716,
	["Bleeding Hollow Hunting Grounds"] = 7717,
	["Scuttler's Coast"] = 7718,
	["The Felblight"] = 7719,
	["Warcamp Gromdar"] = 7720,
	["Thundertail Wallow"] = 7721,
	["The Broken Rampart"] = 7722,
	["Ironhold Approach"] = 7723,
	["Whitewater Wash"] = 7724,
	["Bloodhunt Highland"] = 7725,
	["Skyhorn"] = 7726,
	["Pits of Mannoroth"] = 7727,
	["The Haglands"] = 7728,
	["Fields of An'she"] = 7729,
	["The Black Gate"] = 7730,
	["Thunder Totem"] = 7731,
	["Pinerock Basin"] = 7732,
	["Nesingwary's Retreat"] = 7733,
	["Icecrown Citadel"] = 7734,
	["Tanaan Jungle"] = 7735,
	["Vault of Eyir"] = 7736,
	["Niskara"] = 7737,
	["Blackfang Challenge Arena"] = 7739,
	["Molten Shore"] = 7740,
	["Despair Ridge"] = 7741,
	["Seat of Command"] = 7742,
	["Acherus: The Ebon Hold"] = 7743,
	["Shield's Rest"] = 7744,
	["The Maelstrom"] = 7745,
	["Ash'theran"] = 7746,
	["Soul Engine"] = 7747,
	["Fel Expanse"] = 7748,
	["The Fel Hammer"] = 7749,
	["Sha'naari Refuge"] = 7750,
	["Malo's Lookout"] = 7751,
	["Storm's Eye Overlook"] = 7752,
	["The Heart of Azeroth"] = 7753,
	["Cryptic Hollow"] = 7754,
	["Darkfeather Valley"] = 7755,
	["Windripper Peak"] = 7757,
	["Eventide Bay"] = 7760,
	["Ravencrest Mausoleum"] = 7761,
	["Southwind Shore"] = 7765,
	["Tanaan Jungle"] = 7766,
	["Suramar"] = 7767,
	["Felsoul Hold"] = 7768,
	["The Witchwood"] = 7769,
	["Tanaan Invasion"] = 7771,
	["Julie's Test Area"] = 7772,
	["Greymane's Offensive"] = 7773,
	["The Violet Hold"] = 7777,
	["Heathrow Manor"] = 7778,
	["Radcliffe Landing"] = 7779,
	["Black Rook Hold"] = 7780,
	["Cliff's Edge"] = 7782,
	["Stonedark Grotto"] = 7783,
	["Lifespring Cavern"] = 7786,
	["Vault of the Wardens"] = 7787,
	["Bronzeleaf Thicket"] = 7789,
	["Path of Huln"] = 7790,
	["Earthmother's Bounty"] = 7791,
	["Vol'mar Hold"] = 7794,
	["The Lion's Den"] = 7795,
	["Broken Shore"] = 7796,
	["The Shattered Edge"] = 7797,
	["Hope's End"] = 7798,
	["The Lost Temple"] = 7799,
	["Snowblind Mesa"] = 7800,
	["Greystone"] = 7801,
	["Valdisdall"] = 7803,
	["Andu'talah"] = 7804,
	["Black Rook Hold"] = 7805,
	["Neltharion's Vault"] = 7806,
	["Cave of the Blood Trial"] = 7807,
	["Valley of the Sword"] = 7808,
	["Gloombound Barrow"] = 7809,
	["Torok's Bluff"] = 7810,
	["The Naglfar"] = 7811,
	["Helmouth Cliffs"] = 7812,
	["Skyhold"] = 7813,
	["Vault of the Wardens"] = 7814,
	["Obsidian Overlook"] = 7815,
	["Black Rook Hold Arena"] = 7816,
	["Sepulcher of the Sky"] = 7817,
	["Candle Rock"] = 7818,
	["Vault of the Betrayer"] = 7819,
	["Forge of Corruption"] = 7820,
	["The Doom Fortress"] = 7821,
	["Nagrand Arena"] = 7822,
	["The Underbelly Descent"] = 7825,
	["Twisting Nether"] = 7826,
	["Southshore vs. Tarren Mill"] = 7827,
	["Understone Breach"] = 7828,
	["Navarrogg's Refuge"] = 7829,
	["Helmouth Shallows"] = 7830,
	["Rockaway Coast"] = 7833,
	["Netherlight Temple"] = 7834,
	["Twisting Nether"] = 7835,
	["Mucksnout Den"] = 7836,
	["Blind Marshlands"] = 7837,
	["Azshara"] = 7838,
	["PH Ocean"] = 7839,
	["Meredil"] = 7840,
	["Tel'anor"] = 7841,
	["Moon Guard Stronghold"] = 7842,
	["Falanaar"] = 7843,
	["Felsoul Hold"] = 7844,
	["Crystal Fissure"] = 7845,
	["The Dreamgrove"] = 7846,
	["Helmouth Shallows"] = 7847,
	["Tideskorn Harbor"] = 7848,
	["Cullen's Post"] = 7849,
	["Lorna's Watch"] = 7850,
	["Talonrest"] = 7851,
	["Felskorn Warcamp"] = 7852,
	["Rockcrawler Chasm"] = 7853,
	["The Arcway"] = 7855,
	["Tanaan Jungle Flight Bounds"] = 7856,
	["Shield's Rest"] = 7857,
	["Cave of the Undying"] = 7859,
	["Inkbinders Rise"] = 7860,
	["Prepfoot Compound"] = 7861,
	["Morheim"] = 7862,
	["Bilgefin Shore"] = 7863,
	["Chamber of Night"] = 7864,
	["The Warden's Court"] = 7865,
	["The Demon Ward"] = 7866,
	["Vault of Ice"] = 7867,
	["Vault of Mirrors"] = 7868,
	["Vault of Law"] = 7869,
	["Fallen Passage"] = 7870,
	["Tomb of the Penitent"] = 7871,
	["Illidari Ward"] = 7872,
	["Vault of Silence"] = 7873,
	["Tideskorn Harbor"] = 7874,
	["Dreadscar Rift"] = 7875,
	["Cavern of the Keeper"] = 7876,
	["Trueshot Lodge"] = 7877,
	["Murloc Shoals"] = 7878,
	["Hall of the Guardian"] = 7879,
	["Dalaran"] = 7881,
	["Krasus' Landing"] = 7882,
	["Shipwreck Cove"] = 7883,
	["The Silver Enclave"] = 7884,
	["Antonidas Memorial"] = 7885,
	["Dalaran City"] = 7886,
	["Circle of Wills"] = 7887,
	["The Violet Citadel"] = 7888,
	["The Violet Citadel Spire"] = 7889,
	["Sewer Exit Pipe"] = 7890,
	["Sewer Exit Pipe"] = 7891,
	["Dalaran Floating Rocks"] = 7892,
	["Sunreaver's Sanctuary"] = 7893,
	["Dalaran Island"] = 7894,
	["The Violet Hold"] = 7895,
	["Runeweaver Square"] = 7896,
	["The Underbelly"] = 7897,
	["The Eventide"] = 7898,
	["Magus Commerce Exchange"] = 7899,
	["Vargoth's Retreat"] = 7900,
	["Violet Citadel Balcony"] = 7901,
	["The Wandering Isle"] = 7902,
	["Temple of Five Dawns"] = 7903,
	["Shrine of Five Dawns"] = 7904,
	["Mandori Village"] = 7905,
	["Pei-Wu Forest"] = 7906,
	["Ridge of Laughing Winds"] = 7907,
	["The Dawning Valley"] = 7908,
	["The Singing Pools"] = 7909,
	["Sleeper's Barrow"] = 7910,
	["The Laughing Crane"] = 7911,
	["Foul Creche"] = 7912,
	["The Crescent Vale"] = 7913,
	["Sashj'tar Ruins"] = 7916,
	["Azuregale Bay"] = 7917,
	["Dreadscar Rift"] = 7918,
	["Jagganoth's Lair"] = 7919,
	["Warden Tower"] = 7920,
	["Stormheim"] = 7921,
	["Sunfrost Glade"] = 7922,
	["Icepine Point"] = 7923,
	["Howling Hills"] = 7924,
	["Murkloc Cave"] = 7925,
	["Bluffpoint"] = 7926,
	["Helmouth Cliffs"] = 7927,
	["Shal'Aran"] = 7928,
	["The Burning Sanctum"] = 7929,
	["The Crimson Hall"] = 7930,
	["The Spire"] = 7931,
	["The Frostwing Halls"] = 7932,
	["Screeching Crag"] = 7933,
	["Rampart of Skulls"] = 7934,
	["Deathbringer's Rise"] = 7935,
	["Frosthoof Watch"] = 7936,
	["Lonehoof Watch"] = 7937,
	["Gurun's Banquet"] = 7938,
	["Azuregale Cove"] = 7939,
	["Jandvik"] = 7940,
	["Ashran"] = 7941,
	["Leyhollow"] = 7943,
	["Straits of Hydrannon"] = 7944,
	["Mardum, the Shattered Abyss"] = 7945,
	["[Unused]Felsoul Hold"] = 7946,
	["Axetail Grotto"] = 7947,
	["Oro's Overlook"] = 7948,
	["Stonehoof Watch"] = 7949,
	["Mysthoof Watch"] = 7950,
	["Temple of the White Tiger"] = 7951,
	["Kun-Lai Summit"] = 7952,
	["Grizzly Hills"] = 7953,
	["The Emerald Nightmare"] = 7954,
	["Deepholm"] = 7955,
	["Crumbling Depths"] = 7956,
	["Skywall"] = 7960,
	["Snowmane Village"] = 7961,
	["Felsoul Command"] = 7962,
	["The Grand Promenade"] = 7963,
	["The Drift"] = 7964,
	["Warpwind Cliffs"] = 7965,
	["Oculeth's Workshop"] = 7966,
	["Boost Experience [TEMP NAME]"] = 7967,
	["Kal'delar"] = 7968,
	["Karazhan"] = 7969,
	["Evermoon Commons"] = 7970,
	["Karazhan Catacombs"] = 7971,
	["Marrowden"] = 7972,
	["The Veiled Isles"] = 7973,
	["Ursoc's Lair"] = 7974,
	["Tirisfal Glades"] = 7975,
	["Tirisfal Glades"] = 7976,
	["Whispering Forest"] = 7977,
	["Keeper's Rest"] = 7978,
	["Emerald Dreamway"] = 7979,
	["The Deep Roads"] = 7980,
	["Greystone Enclave"] = 7981,
	["Echoing Halls"] = 7982,
	["Fields of the Eternal Hunt"] = 7983,
	["Ambervale"] = 7984,
	["Highmountain Burial Ground"] = 7987,
	["Oculeth's Test Chamber"] = 7988,
	["Arcano Caverns"] = 7990,
	["Koralune Manor"] = 7991,
	["Ancient Well"] = 7992,
	["Forgotten Passage"] = 7993,
	["Crystal Hollow"] = 7994,
	["Moonshade Sanctum"] = 7995,
	["Violet Hold"] = 7996,
	["Suramar Underground"] = 7997,
	["Crumbling Coast"] = 7998,
	["Thunder Totem"] = 7999,
	["Azsuna"] = 8000,
	["Dead Man's Bay"] = 8001,
	["The Horizon's Edge"] = 8002,
	["Temple of A Thousand Lights"] = 8003,
	["Terrace of Endless Spring"] = 8005,
	["[TEMP] Tech Test - Seamless World Transition A (JT)"] = 8006,
	["[TEMP] Tech Test - Seamless World Transition B (JT)"] = 8007,
	["Ashamane's Fall"] = 8008,
	["Sashj'tar Grotto"] = 8009,
	["Jandvik Caverns"] = 8010,
	["The Hall of Shadows"] = 8011,
	["Chamber of Shadows"] = 8012,
	["[PH]Mardum Treasures"] = 8013,
	["Spiritwind Summit"] = 8014,
	["Forgalash's Den"] = 8015,
	["Gloaming Reef"] = 8017,
	["Ley Station Anora"] = 8018,
	["Stonecrown Cavern"] = 8019,
	["Sashj'tar Pit"] = 8020,
	["Lunastre Estate"] = 8021,
	["Mardum, the Shattered Abyss"] = 8022,
	["The Fel Hammer"] = 8023,
	["Azuregale Hollow"] = 8024,
	["The Nighthold"] = 8025,
	["The Emerald Nightmare"] = 8026,
	["Dalaran Arena"] = 8027,
	["Aegira's Meadery"] = 8028,
	["Starsong Refuge"] = 8029,
	["Emerald Ascent"] = 8031,
	["Sylvan Vale"] = 8032,
	["Azuregale Cove"] = 8033,
	["Un'Goro Crater"] = 8034,
	["Thorim's Rise"] = 8035,
	["Muddledeep Cavern"] = 8039,
	["Eye of Azshara"] = 8040,
	["The Emerald Dream"] = 8041,
	["Rockaway Shallows"] = 8042,
	["Rift of Aln"] = 8043,
	["Tirisfal Glades"] = 8044,
	["Aegwynn's Gallery"] = 8045,
	["The Maelstrom"] = 8046,
	["Storm's Eye Overlook"] = 8047,
	["Darkbrul Arena"] = 8049,
	["Sylvan Falls"] = 8050,
	["Cordana's Apex"] = 8051,
	["One More Glass"] = 8052,
	["The Greater Sea (Don't Use)"] = 8053,
	["Thal'dranath"] = 8054,
	["Felmaw Cavern"] = 8055,
	["Reflection Peak"] = 8056,
	["[TEMP] Dummy Area - Dev Test (JT)"] = 8057,
	["Dev Area - A"] = 8058,
	["Dev Area - B"] = 8059,
	["Dev Area - C"] = 8060,
	["Dev Area - D"] = 8061,
	["Dev Area - E"] = 8062,
	["Dev Area - F"] = 8063,
	["The MOTHERLODE!!"] = 8064,
	["The Retreat"] = 8065,
	["The High Road"] = 8066,
	["Sundersong Glade"] = 8067,
	["Tel'Andu Barrow Den"] = 8074,
	["The Postmaster's Office"] = 8075,
	["The Circle of Spirits"] = 8076,
	["Warden Tower (PH)"] = 8077,
	["Nightwatcher's Perch"] = 8078,
	["Court of Stars"] = 8079,
	["Hatecoil Encampment"] = 8081,
	["Shipwreck Shoals"] = 8082,
	["Deepbeard's Cove"] = 8083,
	["Whispering Willows"] = 8084,
	["Grizzlemaw Cavern"] = 8085,
	["Ala'washte's Nest"] = 8086,
	["Crimson Thicket"] = 8087,
	["Clackbrine Coast"] = 8088,
	["Snowblind Cliffs"] = 8089,
	["Sylvan Precipice"] = 8090,
	["Nordrassil"] = 8091,
	["Moonglade"] = 8092,
	["The Vortex Pinnacle"] = 8093,
	["The Beyond"] = 8094,
	["Nastrondir"] = 8095,
	["The Slave Enclave"] = 8096,
	["Tainted Burrow"] = 8097,
	["Test Dungeon"] = 8098,
	["Sanctum of G'Hanir"] = 8099,
	["The Rotting Grotto"] = 8100,
	["Miasmic Gorge"] = 8101,
	["Heart of Dread"] = 8102,
	["Nashal's Watch"] = 8103,
	["Throne of the Tides"] = 8104,
	["Niskara"] = 8105,
	["Abyssal Maw"] = 8106,
	["Highmountain Summit"] = 8107,
	["Vault of the Betrayer"] = 8108,
	["Vault of Silence"] = 8109,
	["Vault of Mirrors"] = 8110,
	["Vault of Law"] = 8111,
	["Vault of Ice"] = 8112,
	["Tomb of the Penitent"] = 8113,
	["The Warden's Court"] = 8114,
	["The Demon Ward"] = 8115,
	["Illidari Ward"] = 8116,
	["Fallen Passage"] = 8117,
	["Chamber of Night"] = 8118,
	["The Nexus Vault"] = 8119,
	["Tomb Approach"] = 8120,
	["Sanderhorn's Span"] = 8121,
	["Highmountain Peak"] = 8122,
	["NightmareDragonNexus [PH]"] = 8123,
	["Sword of Dawn"] = 8124,
	["Firelands"] = 8125,
	["The Violet Gate"] = 8126,
	["Mortal's Demise"] = 8127,
	["Beth'tilac's Lair"] = 8128,
	["Shatterstone"] = 8129,
	["The Ridge of Ancient Flame"] = 8130,
	["Rhyolith Plateau"] = 8131,
	["The Anvil of Conflagration"] = 8132,
	["Sulfuron Span"] = 8133,
	["Sulfuron Keep Courtyard"] = 8134,
	["Flamebreach"] = 8135,
	["The Path of Corruption"] = 8136,
	["Circle of Thorns"] = 8137,
	["Sulfuron Keep"] = 8138,
	["The Molten Fields"] = 8139,
	["The Legerdemain Lounge"] = 8140,
	["The Nexus"] = 8141,
	["Shadowgore Citadel"] = 8142,
	["Darkstone Isle"] = 8143,
	["Katterin's Hideaway"] = 8144,
	["The Twilight Throne"] = 8145,
	["Twilight Depths"] = 8146,
	["Isle of the Watchers"] = 8147,
	["Suramar City"] = 8148,
	["Twilight Vineyards"] = 8149,
	["Court of Stars"] = 8150,
	["Raven's Glory"] = 8151,
	["Hunter Order Hall"] = 8152,
	["Bough Shadow"] = 8153,
	["Seradane"] = 8154,
	["Twilight Grove"] = 8155,
	["Dream Bough"] = 8156,
	["Rhut'van Divide"] = 8157,
	["Shattered Locus"] = 8158,
	["Feltotem"] = 8159,
	["Falanaar Arcway"] = 8160,
	["Ulduar"] = 8161,
	["The Archivum"] = 8162,
	["Temple of Fal'adora"] = 8163,
	["Ashamane's Fall"] = 8164,
	["The Tidal Marsh"] = 8165,
	["Dead Man's Bay"] = 8166,
	["Stormtorn Foothills"] = 8167,
	["Storm's Reach"] = 8168,
	["Kingsfall Pass"] = 8169,
	["The Spark of Imagination"] = 8170,
	["The Corridors of Ingenuity"] = 8171,
	["Amberfall Mesa"] = 8172,
	["Ruins of Elune'eth"] = 8173,
	["Citrine Bay"] = 8174,
	["The Storm Peaks"] = 8175,
	["Temple of Storms"] = 8176,
	["Summoning Platform"] = 8178,
	["Shaladrassil"] = 8179,
	["Malorne's Nightmare"] = 8180,
	["Moonlit Landing"] = 8181,
	["The Gilded Market"] = 8182,
	["Midnight Court"] = 8183,
	["The Jeweled Estate"] = 8184,
	["Eksis' Lair"] = 8185,
	["Path of the Titans"] = 8186,
	["Sotnar's Rest"] = 8187,
	["Falanaar"] = 8188,
	["Falanaar Arcway"] = 8189,
	["The Emerald Dreamway"] = 8190,
	["Felsurge Nest"] = 8191,
	["Pits of Despair"] = 8192,
	["Altar of End Times"] = 8193,
	["Felbeast Dens"] = 8194,
	["Soul Engine: Apocalypse"] = 8195,
	["Trickster's Cut"] = 8196,
	["Felwatch Point"] = 8197,
	["Upper Faronaar"] = 8198,
	["Tidal Marsh"] = 8201,
	["Felscale Cavern"] = 8202,
	["Blackfeather Altar"] = 8203,
	["Thunder Totem"] = 8204,
	["Realm of the Mage Hunter"] = 8205,
	["Faronaar"] = 8206,
	["Altar of End Times"] = 8207,
	["Trickster's Cut"] = 8208,
	["Felsurge Nest"] = 8209,
	["Soul Engine: Apocalypse"] = 8210,
	["Pits of Despair"] = 8211,
	["Faronaar"] = 8212,
	["Felwatch Point"] = 8213,
	["Felbeast Dens"] = 8214,
	["The Arcway Vaults"] = 8215,
	["Jotunnwood"] = 8217,
	["Starweaver's Sanctum"] = 8218,
	["Moonfall Roost"] = 8219,
	["Moonfall Approach"] = 8220,
	["Lower Gardens"] = 8221,
	["The Athenaeum"] = 8222,
	["Highmist Terrace"] = 8223,
	["The Lunar Crucible"] = 8224,
	["Stormwind Gate"] = 8225,
	["Valley of Heroes"] = 8226,
	["Elwynn Forest"] = 8227,
	["Trade District"] = 8228,
	["The Canals"] = 8229,
	["Irongrove Retreat"] = 8230,
	["Feathermane Hunting Grounds"] = 8231,
	["Dappled Hollow"] = 8232,
	["Moonwhisper Gulch"] = 8233,
	["Stormwind City"] = 8234,
	["Old Town"] = 8235,
	["Stormwind Keep"] = 8236,
	["Alluvanon's Delta"] = 8237,
	["Dreyrgrot"] = 8238,
	["Black Temple"] = 8239,
	["Mage Quarter"] = 8242,
	["The Old Barracks"] = 8243,
	["Cathedral Square"] = 8244,
	["Dwarven District"] = 8245,
	["Absolon's Vigil"] = 8246,
	["Heymanhoof Slope"] = 8247,
	["Terrace of the Watchers"] = 8249,
	["Rescue Koltira"] = 8250,
	["Reliquary Base Camp"] = 8251,
	["The Oculus"] = 8252,
	["Cliffhorn Watch"] = 8253,
	["Pass of An'she"] = 8254,
	["The Ettinwalk"] = 8255,
	["Felbane Camp"] = 8256,
	["Temple Summit"] = 8257,
	["Moonshade Sanctum"] = 8258,
	["Falanaar"] = 8259,
	["Alodi's Bank Vault"] = 8260,
	["Abandoned Kirin Tor Camp"] = 8261,
	["Temple of the Jade Serpent"] = 8262,
	["Windspire Bridge"] = 8263,
	["Jade Temple Grounds"] = 8264,
	["Karazhan"] = 8265,
	["Ashamane's Gate"] = 8266,
	["Thorignir Refuge"] = 8267,
	["Lostlight Grotto"] = 8268,
	["The Undergorge"] = 8269,
	["Margoss's Retreat"] = 8270,
	["The Traveler's Den"] = 8271,
	["Lightsong"] = 8272,
	["Thornton's Cottage"] = 8273,
	["Lithduin Reef"] = 8274,
	["Azuremyst Isle"] = 8275,
	["The Veiled Sea"] = 8276,
	["The Exodar"] = 8277,
	["Grizzleweald"] = 8278,
	["Akstad"] = 8279,
	["Runeaxe Training Grounds"] = 8280,
	["Stonewarden Quarry"] = 8281,
	["The Fel Hammer"] = 8282,
	["Circle of Glory"] = 8283,
	["Illidari Redoubt"] = 8284,
	["Scarlet Monastery"] = 8285,
	["Forlorn Cloister"] = 8286,
	["Chapel Gardens"] = 8287,
	["The Great Sea"] = 8288,
	["Paledoom's Overlook"] = 8289,
	["The Broken Shore"] = 8290,
	["Terrace of the Twin Dragons"] = 8291,
	["Temple of the Jade Serpent"] = 8292,
	["The Scrollkeeper's Sanctum"] = 8293,
	["Terrace of the Twin Dragons"] = 8294,
	["The Heart of Jade"] = 8295,
	["Pit of Malinoth"] = 8296,
	["Grey Shoals"] = 8297,
	["Mulgore"] = 8298,
	["Royal Quarter"] = 8299,
	["Theodric's Lodge"] = 8300,
	["Greywatch Barracks"] = 8301,
	["The Oblivion"] = 8302,
	["Howling Dale"] = 8303,
	["Starstalker's Point"] = 8304,
	["Morning Breeze Village"] = 8306,
	["Chamber of Whispers"] = 8307,
	["Valley of Sighs"] = 8308,
	["Tol Barad"] = 8309,
	["Baradin Hold"] = 8310,
	["West Spire"] = 8311,
	["Ironclad Garrison"] = 8312,
	["East Spire"] = 8313,
	["South Spire"] = 8314,
	["Slagworks"] = 8315,
	["Warden's Vigil"] = 8316,
	["Tirisfal Glades"] = 8317,
	["Tirisfal Glades"] = 8318,
	["Baradin Hold"] = 8319,
	["Darkfollow's Spire"] = 8320,
	["Out of Bounds"] = 8321,
	["Sabermaw Bluff"] = 8322,
	["Field of Dreamers"] = 8323,
	["Whisperwind's Citadel"] = 8324,
	["Wildwood Road"] = 8325,
	["Sundered Shoals"] = 8326,
	["Watchman's Rock"] = 8327,
	["Blackhawk's Bulwark"] = 8328,
	["Anora Hollow"] = 8329,
	["[TEMP] Placeholder Area - Level Design Land - Wind Test"] = 8330,
	["Heyman's End"] = 8331,
	["Emerald Bay"] = 8332,
	["Tangled Cleft"] = 8333,
	["Moonfall Overlook"] = 8334,
	["Spiritwatch Point"] = 8335,
	["The Tomb of Sargeras"] = 8336,
	["Stonescar Gorge"] = 8337,
	["The Lost Road"] = 8338,
	["Broken Teeth"] = 8339,
	["The Stone Market"] = 8340,
	["Scaleback Run"] = 8341,
	["Path of the Worm"] = 8342,
	["The Dragon's Spine"] = 8343,
	["The Crystal Hall"] = 8344,
	["Estate of the First Arcanist"] = 8345,
	["Eastern Plaguelands"] = 8346,
	["Sanctum of Light"] = 8347,
	["Shal'dorei Terrace"] = 8348,
	["Cliffclutch Roost"] = 8349,
	["Illidari Perch"] = 8350,
	["The Menagerie"] = 8351,
	["Su'esh's Lair"] = 8352,
	["Concourse of Destiny"] = 8353,
	["Eastern Plaguelands"] = 8354,
	["The Aetherium"] = 8355,
	["Sanctuary of the Light"] = 8356,
	["Light's Hope Chapel"] = 8357,
	["Browman Mill"] = 8358,
	["Eastwall Tower"] = 8359,
	["Pestilent Scar"] = 8360,
	["SI:7"] = 8361,
	["Vrekt"] = 8362,
	["The Wildwood"] = 8363,
	["Bladesong's Retreat"] = 8364,
	["Gloomscale Coast"] = 8365,
	["The Deathbringer"] = 8366,
	["The King's Fang"] = 8367,
	["Gloaming Reef"] = 8368,
	["The Lightbreaker"] = 8369,
	["Watchers' Aerie"] = 8370,
	["Wardens' Redoubt"] = 8371,
	["Rockaway Shelf"] = 8372,
	["Eye of Azshara"] = 8373,
	["The High Gate"] = 8374,
	["Stony Highlands"] = 8375,
	["Ashil's Bay"] = 8376,
	["Moonlit Landing"] = 8378,
	["The Gilded Market"] = 8379,
	["Midnight Court"] = 8380,
	["The Jeweled Estate"] = 8381,
	["The Waning Crescent"] = 8382,
	["Artisan's Gallery"] = 8383,
	["Siren's Vigil"] = 8384,
	["Evermoon Bazaar"] = 8385,
	["Shimmershade Garden"] = 8386,
	["The Hidden Pools"] = 8387,
	["The Shattered Walkway"] = 8388,
	["Astromancer's Rise"] = 8389,
	["Suramar"] = 8390,
	["Summitcrest Basecamp"] = 8391,
	["Dalaran Sewers"] = 8392,
	["Hafr Fjall"] = 8393,
	["Carlisle Cottage"] = 8394,
	["Astravar Harbor"] = 8395,
	["World Boss Cave"] = 8396,
	["Terrace of Enlightenment"] = 8397,
	["Terrace of Order"] = 8398,
	["Elor'shan"] = 8399,
	["Kel'balor"] = 8400,
	["Ley Station Moonfall"] = 8401,
	["Ley Station Aethenar"] = 8402,
	["Halls of the Eclipse"] = 8403,
	["Falanaar Depths"] = 8404,
	["Teloth'aran"] = 8405,
	["Black Rook Hold"] = 8406,
	["Ravencourt"] = 8407,
	["Raven's Glory"] = 8408,
	["Heroes' Rest"] = 8409,
	["Lion's Rest"] = 8411,
	["Sanderhoof's Ledge"] = 8412,
	["Tanks for Everything"] = 8413,
	["Legendary Leathers"] = 8414,
	["Talismanic Textiles"] = 8415,
	["Wileywisp Den"] = 8416,
	["Nal'ryssa's Encampment"] = 8417,
	["Lyndras' Exile"] = 8418,
	["Den of the Demented"] = 8419,
	["Forgotten Crypt"] = 8420,
	["Tempest's Roar"] = 8422,
	["The Arcway"] = 8423,
	["Emerald Bay"] = 8425,
	["Ruins of Nar'thalas"] = 8426,
	["Rockaway Shallows"] = 8427,
	["Helmouth Shallows"] = 8428,
	["Tel'anor"] = 8429,
	["Tradewind Roost"] = 8430,
	["Sanctum of Order"] = 8431,
	["The Dawning Span"] = 8432,
	["Ashran"] = 8433,
	["Starcaller Retreat"] = 8434,
	["Darkheart Thicket"] = 8435,
	["Sunset Park"] = 8436,
	["The Broken Shore"] = 8437,
	["Great Dark Beyond"] = 8439,
	["Trial of Valor"] = 8440,
	["Moonbeam Causeway"] = 8441,
	["Nashal the Watcher"] = 8442,
	["Karazhan"] = 8443,
	["Seabreak Isle"] = 8444,
	["The Great Sea"] = 8445,
	["[TEMP] JT Zandalar Swamp"] = 8448,
	["xxOLD - Zuldazar City"] = 8449,
	["Temple of the White Tiger Flight Bounds"] = 8451,
	["Tomb of Sargeras"] = 8452,
	["Tomb Approach"] = 8453,
	["The Black City"] = 8454,
	["The Broken Shore"] = 8455,
	["Stormwind City"] = 8456,
	["Escape from the Vault"] = 8457,
	["El'dranil Peak"] = 8458,
	["Death Knight Campaign Flight Bounds"] = 8460,
	["Sanctum of Enlightenment"] = 8461,
	["Altar of End Times"] = 8463,
	["Loch Varmad"] = 8464,
	["Stormstout Inn"] = 8468,
	["The Maelstrom"] = 8469,
	["VictorCortisLand"] = 8470,
	["Sanctum of Order"] = 8471,
	["Terrace of Order"] = 8472,
	["Dungeon Blockout"] = 8473,
	["Dalaran (Northrend)"] = 8474,
	["Viperville"] = 8476,
	["Elwynn Forest"] = 8477,
	["Karazhan"] = 8478,
	["Broken Shore DO NOT USE"] = 8479,
	["8DesertCanyonTest"] = 8480,
	["Felsoul Advance"] = 8481,
	["Blade's Edge Arena"] = 8482,
	["The Eye of Eternity"] = 8483,
	["Ashran"] = 8485,
	["Nyell's Workshop"] = 8486,
	["Evermoon Terrace"] = 8487,
	["Underrot"] = 8488,
	["Islands"] = 8489,
	["Winter AB"] = 8490,
	["[TEMP] CV Kul Tiras Island"] = 8491,
	["Misty Coast"] = 8492,
	["Gull Rock"] = 8493,
	["Verdant Cliffs"] = 8494,
	["Xylem's Tower"] = 8495,
	["Suramar Bay"] = 8496,
	["Onyxia's Lair"] = 8497,
	["Helya's Throne"] = 8498,
	["Zuldazar"] = 8499,
	["Nazmir"] = 8500,
	["Vol'dun"] = 8501,
	["South Seas"] = 8502,
	["Felborne Outpost"] = 8503,
	["The Cliffroost"] = 8504,
	["Seaspray Cliffs"] = 8505,
	["Felfire Pass"] = 8506,
	["Felfire Cavern"] = 8507,
	["Arathi Basin"] = 8508,
	["The Ephemeral Way"] = 8509,
	["Ravenperch Cove"] = 8510,
	["The Deserted Workshop"] = 8511,
	["The Eternal Battlefield"] = 8512,
	["Damp Cave"] = 8513,
	["Gnomeregan"] = 8514,
	["The Twisted Grounds"] = 8515,
	["Felbreach Hollow"] = 8516,
	["Deliverance Point"] = 8517,
	["The Eye of Eternity"] = 8518,
	["Crescent Ruins"] = 8519,
	["The Heartland"] = 8520,
	["Field of Fallen Kings"] = 8521,
	["Haustvald"] = 8522,
	["The Temple of Atal'Hakkar"] = 8523,
	["Tomb of Sargeras"] = 8524,
	["Underrot"] = 8525,
	["Arathi Basin"] = 8526,
	["Cathedral of Eternal Night"] = 8527,
	["Wailing Caverns"] = 8528,
	["Pit of Saron"] = 8529,
	["Impsorrow Approach"] = 8530,
	["Stormstout Brewery"] = 8531,
	["The Bank of Dalaran"] = 8532,
	["Bybeen Lair"] = 8534,
	["Dalaran (Deadwind Pass)"] = 8535,
	["Deadwood Islet"] = 8536,
	["The Dreadsoul"] = 8537,
	["Twisting Nether"] = 8538,
	["Legion Command Ship"] = 8540,
	["The Twisting Nether"] = 8541,
	["Moonlight Ascent"] = 8542,
	["The Weeping Terrace"] = 8543,
	["Outcast's Hovel"] = 8544,
	["The Creeping Grotto"] = 8545,
	["Cave of the Bloodtotem"] = 8546,
	["Coast of Anguish"] = 8547,
	["Felrage Strand"] = 8548,
	["The Maelstrom"] = 8549,
	["The Hijacked Portal"] = 8550,
	["Garrison of the Fel"] = 8551,
	["Broken Valley"] = 8552,
	["Wrynnfall"] = 8553,
	["Deliverance Point"] = 8554,
	["Screaming Cliffs"] = 8555,
	["Stratholme"] = 8556,
	["Foulshore Strip"] = 8557,
	["Feldust Cavern"] = 8558,
	["Feltotem Caverns"] = 8559,
	["Vengeance Point"] = 8560,
	["The Twisting Nether"] = 8561,
	["Broken Valley - Area 2 [PH]"] = 8562,
	["Broken Valley - Area 3 [PH]"] = 8563,
	["Broken Valley - Area 4 [PH]"] = 8564,
	["Broken Valley - Area 5 [PH]"] = 8565,
	["The Great Sea"] = 8566,
	["Tiragarde Sound"] = 8567,
	["Boralus"] = 8568,
	["Coal Ridge"] = 8569,
	["Val'sharah"] = 8570,
	["Forlorn Depths"] = 8571,
	["Maw of Corruption"] = 8572,
	["MSandersTest2016"] = 8573,
	["Krokuun"] = 8574,
	["Jagged Cove"] = 8576,
	["Cinder Run"] = 8577,
	["Isle of Blizzcon"] = 8579,
	["Scavenger's Edge"] = 8580,
	["Assault on Broken Shore"] = 8581,
	["AI Test Map 8 - Arathi Basin"] = 8582,
	["Black Rook Hold"] = 8583,
	["Soul Ruin"] = 8584,
	["Den of Fiends"] = 8585,
	["Gloomshore"] = 8586,
	["Deadwood Landing"] = 8587,
	["The Pit of Agony"] = 8588,
	["Dalaran"] = 8589,
	["Soldier's Torment"] = 8590,
	["Shwayder's Tavern"] = 8591,
	["Felsworn Vault"] = 8592,
	["Shadow Fracture"] = 8593,
	["Halls of Valor"] = 8594,
	["Forge of Corruption"] = 8595,
	["Stormheim"] = 8596,
	["Battle for Blackrock Mountain"] = 8597,
	["Warden Tower TEMP"] = 8598,
	["The Great Sea"] = 8600,
	["Animation Playground"] = 8601,
	["Dark Stockades"] = 8602,
	["Stonefin Shoals"] = 8603,
	["Black Rook Hold"] = 8604,
	["Infernal Causeway"] = 8605,
	["World's End Tavern"] = 8606,
	["The Laughing Yeti"] = 8607,
	["The Exobar"] = 8608,
	["Nighthaven Inn"] = 8609,
	["The Road Warrior"] = 8610,
	["The Oasis Inn"] = 8611,
	["Firefly Tavern"] = 8612,
	["Rusty Rocket Tavern"] = 8613,
	["The Cat and the Shaman"] = 8614,
	["The Salty Sailor Tavern"] = 8615,
	["Broken Keel Tavern"] = 8616,
	["Pig and Whistle Tavern"] = 8617,
	["The Broken Tusk"] = 8618,
	["Silvermoon City Inn"] = 8619,
	["The Keggary"] = 8620,
	["The Wyvern's Tail"] = 8621,
	["The Stonefire Tavern"] = 8622,
	["Scarlet Raven Tavern"] = 8623,
	["Shado-Pan Showdown"] = 8624,
	["Azsuna"] = 8625,
	["The Deadmines"] = 8630,
	["[TEMP] Hackaton CV"] = 8634,
	["The Frozen Throne"] = 8635,
	["[TEMP] Hackaton Race"] = 8636,
	["[TEMP] Hackaton Race"] = 8637,
	["Antorus, the Burning Throne"] = 8638,
	["Test Dungeon"] = 8639,
	["Coldridge Valley"] = 8640,
	["Fields of the Eternal Hunt"] = 8641,
	["Felwing Ledge"] = 8642,
	["Path of Suffering"] = 8643,
	["Summoning Platform"] = 8644,
	["Halls of Valor"] = 8645,
	["Highmountain"] = 8646,
	["Gnomeregan"] = 8647,
	["Aalgen Point"] = 8648,
	["Netherhollow"] = 8650,
	["Mardum, the Shattered Abyss"] = 8651,
	["Empty Never Nowhere"] = 8652,
	["Shrine of Aviana"] = 8653,
	["Rim of the World"] = 8654,
	["CharacterTestSpaceArea_ECannon"] = 8656,
	["Hall of Communion"] = 8657,
	["Trollbane Hall"] = 8658,
	["Defiler's Den"] = 8659,
	["Throne of the Four Winds"] = 8660,
	["[PH] JT Test World"] = 8661,
	["Rhut'van Peak"] = 8662,
	["Rhut'van Peak"] = 8663,
	["Barterdocks"] = 8664,
	["Port of Zandalar"] = 8665,
	["Grand Bazaar"] = 8666,
	["Tal'farrak"] = 8667,
	["Tal'aman"] = 8668,
	["Gurubashi Embassy"] = 8669,
	["Dazar'alor"] = 8670,
	["Altar of Sanbwoni"] = 8671,
	["The Ruby Sanctum"] = 8672,
	["Krokul Hovel"] = 8673,
	["Darkfall Ridge"] = 8674,
	["Umbral Halls"] = 8675,
	["The Lost Glacier"] = 8676,
	["Frozen Span"] = 8677,
	["Kyranastrasz' Rest"] = 8678,
	["Slaughter Square"] = 8679,
	["Elunaria"] = 8681,
	["Triumvirate's End"] = 8682,
	["The Frogmarsh"] = 8683,
	["AI Test Map - Arathi Basin (Debug Version)"] = 8684,
	["Warsong Gulch"] = 8685,
	["Silverwing Hold"] = 8686,
	["Warsong Lumber Mill"] = 8687,
	["The Rivermarsh"] = 8688,
	["Zul'jan Ruins"] = 8689,
	["Zul'Nazman"] = 8690,
	["The Fallen Outpost"] = 8691,
	["Bloodwash"] = 8692,
	["The Shattered River"] = 8693,
	["Seat of Annihilation"] = 8694,
	["Annihilan Pits"] = 8695,
	["Petrified Forest"] = 8696,
	["Cask 'n' Anvil"] = 8698,
	["Nazmir [DEVLAND COPY]"] = 8699,
	["The Exodar"] = 8700,
	["Eredath"] = 8701,
	["Ruins of Oronaar"] = 8702,
	["The Seat of the Triumvirate"] = 8703,
	["Exodus Point"] = 8704,
	["Oronaar Collapse"] = 8705,
	["Isolon"] = 8706,
	["Strand's End"] = 8707,
	["Trollbane Hall"] = 8708,
	["Akazamzarak's Hat"] = 8709,
	["Alturus' Sanctum"] = 8710,
	["Gloom Hollow"] = 8711,
	["The Trial of Style"] = 8712,
	["Animation Playground"] = 8713,
	["The Vindicaar"] = 8714,
	["Blood Nest"] = 8715,
	["Proudmoore Keep"] = 8716,
	["Boralus Harbor"] = 8717,
	["Tradewinds Market"] = 8718,
	["Warbeast Kraal"] = 8719,
	["Tomb of Sargeras"] = 8720,
	["Drustvar"] = 8721,
	["Blood Gate"] = 8722,
	["The Savage Front"] = 8723,
	["Raz'lotec"] = 8724,
	["Terrace of War"] = 8725,
	["Zanchul"] = 8726,
	["Garden of the Loa"] = 8727,
	["Shrine of Pa'ku"] = 8728,
	["The Sliver"] = 8729,
	["Plateau of Naz"] = 8730,
	["Mount Mugamba"] = 8731,
	["Temple of the Prophet"] = 8732,
	["Zeb'ahari"] = 8733,
	["Temple of Rezan"] = 8734,
	["Northern Barrens"] = 8735,
	["Durotar"] = 8736,
	["Darkspear Strand"] = 8737,
	["Sen'jin Village"] = 8738,
	["Sen'jin Village Outskirts"] = 8739,
	["Umbra Hollows"] = 8740,
	["Shadowguard Incursion"] = 8741,
	["Northwatch Foothold"] = 8742,
	["The Merchant Coast"] = 8743,
	["Echo Isles"] = 8744,
	["Zalazane's Fall"] = 8746,
	["The Great Sea"] = 8747,
	["Darkspear Shore"] = 8748,
	["Darkspear Isle"] = 8749,
	["Bloodtalon Shore"] = 8750,
	["Valley of Trials"] = 8751,
	["Valley of Trials"] = 8752,
	["Spirit Rock"] = 8753,
	["Hidden Path"] = 8754,
	["Fray Island"] = 8755,
	["Ratchet"] = 8756,
	["The Tidus Stair"] = 8757,
	["Southfury River"] = 8758,
	["Southfury River"] = 8759,
	["Southern Barrens"] = 8760,
	["The Stagnant Oasis"] = 8761,
	["The Crossroads"] = 8762,
	["Lushwater Oasis"] = 8763,
	["Gold Road"] = 8764,
	["The Overgrowth"] = 8765,
	["The Great Divide"] = 8766,
	["Mulgore"] = 8767,
	["Red Rocks"] = 8768,
	["Hunter's Hill"] = 8769,
	["The High Road"] = 8770,
	["Honor's Stand"] = 8771,
	["The Golden Plains"] = 8772,
	["Windfury Ridge"] = 8773,
	["Camp Una'fe"] = 8774,
	["Ruins of Taurajo"] = 8775,
	["The Great Gate"] = 8776,
	["Fields of Blood"] = 8777,
	["Vendetta Point"] = 8778,
	["The Rolling Plains"] = 8779,
	["Winterhoof Water Well"] = 8780,
	["Bloodhoof Village"] = 8781,
	["Stonebull Lake"] = 8782,
	["Ravaged Caravan"] = 8783,
	["The Venture Co. Mine"] = 8784,
	["Camp Narache"] = 8785,
	["Brambleblade Ravine"] = 8786,
	["Red Cloud Mesa"] = 8787,
	["The Thornsnarl"] = 8788,
	["Feralas"] = 8789,
	["Frazzlecraz Motherlode"] = 8790,
	["Twinbraid's Patrol"] = 8791,
	["Battlescar"] = 8792,
	["Desolation Hold"] = 8793,
	["Lower Wilds"] = 8794,
	["New Thalanaar"] = 8795,
	["Thousand Needles"] = 8796,
	["Westreach Summit"] = 8797,
	["The Great Lift"] = 8798,
	["Darkcloud Pinnacle"] = 8799,
	["Razorfen Downs"] = 8800,
	["Dustwallow Marsh UNUSED"] = 8801,
	["The Dragonmurk"] = 8802,
	["Bael Modan Excavation"] = 8803,
	["Bael Modan"] = 8804,
	["Dustwallow Marsh"] = 8805,
	["Shady Rest Inn"] = 8806,
	["Spearhead"] = 8807,
	["Firestone Point"] = 8808,
	["Bloodfen Burrow"] = 8809,
	["Fort Triumph"] = 8810,
	["Lost Point"] = 8811,
	["North Point Tower"] = 8812,
	["Bluefen"] = 8813,
	["Darkmist Cavern"] = 8814,
	["Brackenwall Village"] = 8815,
	["The Den of Flame"] = 8816,
	["Stonemaul Ruins"] = 8817,
	["Mudsprocket"] = 8818,
	["Wyrmbog"] = 8819,
	["Beezil's Wreck"] = 8820,
	["Tabetha's Farm"] = 8821,
	["Direhorn Post"] = 8822,
	["The Quagmire"] = 8823,
	["Witch Hill"] = 8824,
	["Dustwallow Bay"] = 8825,
	["Tidefury Cove"] = 8826,
	["The Nightmare Scar"] = 8827,
	["Overgrown Camp"] = 8828,
	["Forward Command"] = 8829,
	["Blackhoof Village"] = 8830,
	["Northwatch Hold"] = 8831,
	["Teegan's Expedition"] = 8832,
	["The Great Sea"] = 8833,
	["Alcaz Island"] = 8834,
	["Dreadmurk Shore"] = 8835,
	["Swamplight Manor"] = 8836,
	["Sentry Point"] = 8837,
	["Nat's Landing"] = 8838,
	["Theramore Isle"] = 8839,
	["Azuremyst Isle"] = 8840,
	["Triad's Conservatory"] = 8841,
	["The Exodar"] = 8842,
	["The Umbral Locus"] = 8843,
	["Crescent Isle"] = 8844,
	["Secret Treasure Lair"] = 8845,
	["Tiragarde Redoubt"] = 8846,
	["The Gravewood"] = 8847,
	["Gol Inath"] = 8848,
	["Fate's End"] = 8849,
	["Savagelands"] = 8850,
	["Kazai"] = 8851,
	["Glenbrook Homestead"] = 8852,
	["Prisoners' Pass"] = 8853,
	["Vulpera Hideaway"] = 8854,
	["Abandoned Burrows"] = 8855,
	["The Prickly Grove"] = 8856,
	["The Brine Basin"] = 8857,
	["Slithering Plains"] = 8858,
	["Court of Zak'rajan"] = 8859,
	["Ruins of Atul'Aman"] = 8860,
	["Temple of Akunda"] = 8861,
	["The Blistering Wastes"] = 8862,
	["Valley of Sorrows"] = 8863,
	["Randall's Refuge"] = 8865,
	["Deadwood Cove"] = 8866,
	["Ashvane Encampment"] = 8867,
	["Thundering Terrace"] = 8868,
	["Sanctuary of the Devoted"] = 8869,
	["The Forgotten Marsh"] = 8870,
	["Bouldered Bluffs"] = 8871,
	["Vorrik's Sanctum"] = 8872,
	["Exiles' Enclave"] = 8873,
	["Slithering Gulch"] = 8874,
	["Skycallers' Spire"] = 8875,
	["Rocky Cleft"] = 8876,
	["Dead Man's Pass"] = 8877,
	["Thundering Gorge"] = 8878,
	["The Eternal Spring"] = 8879,
	["Sunken Shallows"] = 8880,
	["Azurelight Bazaar"] = 8881,
	["Conservatory of the Arcane"] = 8882,
	["The Praetorium"] = 8883,
	["Arinor Gardens"] = 8884,
	["Kil'jaeden's Terrace"] = 8885,
	["Prophet's Reflection"] = 8886,
	["Dragonblight"] = 8889,
	["Western Plaguelands"] = 8890,
	["Mount Hyjal"] = 8891,
	["The Culling of Stratholme"] = 8892,
	["Well of Eternity"] = 8893,
	["Beastwatcher Glade"] = 8896,
	["The Necropolis"] = 8897,
	["Antoran Wastes"] = 8899,
	["The Zocalo"] = 8900,
	["Cauldron of Rock"] = 8901,
	["Ashvane Foundry"] = 8902,
	["Eastpoint Station"] = 8903,
	["Glenbrook Hunting Grounds"] = 8904,
	["Shadowguard Incursion"] = 8905,
	["Umbra Hollows"] = 8906,
	["Triad's Conservatory"] = 8907,
	["The Umbral Locus"] = 8908,
	["The Seat of the Triumvirate"] = 8909,
	["The Seat of the Triumvirate"] = 8910,
	["Arcatraz"] = 8911,
	["Zo'bal Ruins"] = 8913,
	["Azurelight Square"] = 8914,
	["The Vindicaar"] = 8915,
	["The Vindicaar"] = 8916,
	["Wellington"] = 8917,
	["Port of Zem'lan"] = 8918,
	["Whistlebloom Oasis"] = 8919,
	["The Cracked Coast"] = 8920,
	["Tal'gurub"] = 8921,
	["Koramar"] = 8922,
	["The Slough"] = 8923,
	["Razorjaw River"] = 8924,
	["Nesingwary's Trek"] = 8925,
	["Festerroot Bog"] = 8926,
	["The Preserve"] = 8927,
	["The Exhaust"] = 8928,
	["Temple of Kimbul - DO NOT USE"] = 8929,
	["Terrace of the Fang"] = 8930,
	["Darkwood Shoal"] = 8931,
	["Upper Frogmarsh"] = 8932,
	["Shattered Fields"] = 8933,
	["Rootway"] = 8934,
	["Headhunter Lodge"] = 8935,
	["Crown of Destruction"] = 8936,
	["Obsidian Dragonshrine"] = 8937,
	["Ruby Dragonshrine"] = 8938,
	["Emerald Dragonshrine"] = 8939,
	["Azure Dragonshrine"] = 8940,
	["Zal'amak"] = 8942,
	["Fangcaller Cavern"] = 8944,
	["Naz'agal"] = 8945,
	["Wakener's Enclave"] = 8946,
	["The Sundered Span"] = 8947,
	["Forlorn Ruins"] = 8948,
	["Deceiver's Scar"] = 8949,
	["Ruins of Lordaeron"] = 8950,
	["High Inquisitor's Lair"] = 8951,
	["Bridgeport"] = 8953,
	["Scaletrader Post"] = 8954,
	["Dev Area - H (copy)"] = 8955,
	["Gol Thovas"] = 8956,
	["Dev Area - I"] = 8957,
	["Goldtusk Inn"] = 8958,
	["Crackling Ridge"] = 8959,
	["Atul'Aman"] = 8960,
	["Shatterstone Harbor"] = 8961,
	["Terrace of the Devoted"] = 8962,
	["Redrock Mesa"] = 8963,
	["Redrock Harbor"] = 8964,
	["Xibala"] = 8965,
	["Zalamar"] = 8966,
	["Terrace of Sorrows"] = 8967,
	["Primal Wetlands"] = 8968,
	["Urok's Lair"] = 8969,
	["Nazwatha"] = 8970,
	["Torga's Rest"] = 8971,
	["Atul'Nazman"] = 8972,
	["The Heart of Darkness"] = 8973,
	["The Seat of the Triumvirate (cin)"] = 8974,
	["The Xenedar"] = 8975,
	["Krag'wa's Burrow"] = 8976,
	["Wayward Shoals"] = 8977,
	["Tol Dagor"] = 8978,
	["Warfronts Prototype Main"] = 8979,
	["Endless Halls"] = 8980,
	["Escape from Argus"] = 8994,
	["Deep Cavern"] = 9004,
	["Reliquary Camp"] = 9006,
	["Explorer's League Campsite"] = 9007,
	["The Dreadmire"] = 9008,
	["Sanctum of the Claw"] = 9009,
	["Shadow of Azeroth"] = 9010,
	["Norwington Estate"] = 9011,
	["Forge of Aeons"] = 9012,
	["Maw of N'Zoth"] = 9021,
	["Orgrimmar Embassy"] = 9022,
	["[Test] Environment Art - Tina 01"] = 9023,
	["Invasion Point"] = 9024,
	["Invasion Point"] = 9025,
	["Carver's Harbor"] = 9026,
	["Atal'Dazar"] = 9028,
	["Hozen Island"] = 9029,
	["Fallhaven"] = 9032,
	["Shrouded Foothills"] = 9033,
	["Fallhaven Ranch"] = 9034,
	["Shrine of Shadra"] = 9035,
	["Throne of Rezan"] = 9036,
	["Caverns of Consumption"] = 9037,
	["Nath'raxas Hold"] = 9038,
	["Blood Bog"] = 9039,
	["Destiny Point"] = 9040,
	["Natha'vor"] = 9041,
	["Stormsong Valley"] = 9042,
	["Silithus Brawl"] = 9043,
	["Court of the Avenger"] = 9044,
	["Atal'Gral"] = 9045,
	["Scavenger's Strand"] = 9046,
	["Shoaljai Tar Pits"] = 9047,
	["Krag'wa's Shore"] = 9048,
	["Antul'Mita Plateau"] = 9049,
	["Nath'raxas Spire"] = 9050,
	["The Deaths of Chromie"] = 9051,
	["Foxhollow Woods"] = 9052,
	["Mistfall Cleft"] = 9059,
	["Freehold"] = 9078,
	["[TEMP] CV JulienTest"] = 9099,
	["Invasion Point: Aurinor"] = 9100,
	["Tropical Isle 8.0"] = 9101,
	["Invasion Point: Naigtal"] = 9102,
	["Vale of Eternal Blossoms"] = 9105,
	["Invasion Point"] = 9106,
	["Anglepoint Wharf"] = 9124,
	["Krakenbane Cove"] = 9125,
	["Invasion Point: Cen'gar"] = 9126,
	["Invasion Point: Val"] = 9127,
	["Invasion Point: Sangua"] = 9128,
	["Invasion Point"] = 9129,
	["Hangman's Point"] = 9130,
	["Watcher's Wood"] = 9131,
	["Hawthorne's Plot"] = 9132,
	["Zul'Ahjin"] = 9133,
	["Gol Koval"] = 9134,
	["The Wailing Tideway"] = 9135,
	["Seething Shore"] = 9136,
	["Black Gorge"] = 9137,
	["The Veiled Den"] = 9138,
	["Light's Purchase"] = 9139,
	["Hope's Landing"] = 9140,
	["Shattered Chasm"] = 9141,
	["Pits of Punishment"] = 9143,
	["Defiler's Overlook"] = 9144,
	["Burning Breach"] = 9145,
	["The Vindicaar"] = 9146,
	["The Old Seawall"] = 9147,
	["Fletcher's Hollow"] = 9148,
	["Felsiege Rise"] = 9149,
	["Circle of Aspirants"] = 9150,
	["Stasis Core"] = 9151,
	["Felfire Armory"] = 9152,
	["Terminus"] = 9153,
	["Ven'orn's Lair"] = 9154,
	["Fiend's Run"] = 9155,
	["Scavenger's Boneyard"] = 9156,
	["The Spirit Crucible"] = 9157,
	["Altar of Darkest Rites"] = 9158,
	["Shaper's Rise"] = 9159,
	["Putrid Laboratory"] = 9160,
	["Defiled Path"] = 9161,
	["Collector's Hovel"] = 9162,
	["Julien Test Land"] = 9163,
	["Freehold"] = 9164,
	["Elderstone Mine"] = 9165,
	["Shrine of Xibala"] = 9166,
	["Barrowknoll Cemetery"] = 9167,
	["Arathi Highlands"] = 9168,
	["Kel'vax's Shrine"] = 9169,
	["Timbered Strand"] = 9170,
	["Stormwind Embassy"] = 9171,
	["Terrace of the Chosen"] = 9172,
	["The Zocalo"] = 9173,
	["Argus Wastes"] = 9174,
	["Wayward Thicket"] = 9176,
	["Rimestone's Lair"] = 9177,
	["The Far Reach"] = 9178,
	["Sethrak Front"] = 9179,
	["Invasion Point: Bonich"] = 9180,
	["Grove of Naroua"] = 9181,
	["RiverZone_Art"] = 9183,
	["The Twisting Nether"] = 9186,
	["Fel Core"] = 9187,
	["Telogrus Rift"] = 9188,
	["Zeb'Saur [UNUSED]"] = 9191,
	["Pterror Rise"] = 9192,
	["Court of Spirits"] = 9194,
	["Shadow's Concourse"] = 9195,
	["Isolon Basin"] = 9198,
	["Hir'eek's Lair"] = 9201,
	["Withering Gulch"] = 9202,
	["Suramar City"] = 9207,
	["Autumnvale"] = 9222,
	["Trader's Camp"] = 9223,
	["North Pass Caverns"] = 9224,
	["Arid Basin"] = 9225,
	["Scorched Sands Outpost"] = 9226,
	["Carrion Grounds"] = 9227,
	["Scorched Sands Arena"] = 9228,
	["Burial Mound"] = 9229,
	["Crumbling OverlookDELETE JDA"] = 9230,
	["Barbthorn Ridge"] = 9231,
	["Barbthorn Cave"] = 9232,
	["Den of Despair"] = 9233,
	["The Wicker Altar"] = 9234,
	["Warport Rastari"] = 9235,
	["Kennings Lodge"] = 9236,
	["Rockskip Falls"] = 9263,
	["Mudfish Lodge"] = 9264,
	["Snapclaw Shore"] = 9265,
	["Verdant Plateau"] = 9266,
	["Alpine Rise"] = 9268,
	["Highroad Pass"] = 9269,
	["Torga's Innards"] = 9270,
	["Hunter's Run"] = 9271,
	["Clearspring Pass"] = 9272,
	["Stagheart Wash"] = 9273,
	["Forgotten Lodge"] = 9274,
	["Gol Var"] = 9275,
	["Kul Tiras Arena"] = 9278,
	["Hook Point"] = 9279,
	["Edge of Discord"] = 9280,
	["Den of the Devourers"] = 9281,
	["Greater Invasion Point: Matron Folnuna"] = 9295,
	["Greater Invasion Point: Pit Lord Vilemus"] = 9296,
	["Greater Invasion Point: Inquisitor Meto"] = 9297,
	["Greater Invasion Point: Occularus"] = 9298,
	["Greater Invasion Point: Sotanathor"] = 9299,
	["Greater Invasion Point: Mistress Alluradel"] = 9300,
	["Throne of Ascension"] = 9302,
	["The Alchemist's Lair"] = 9303,
	["Tempest Cliffs"] = 9304,
	["Castaway Point"] = 9305,
	["Elunaria (cin)"] = 9306,
	["Broken Cliffs"] = 9307,
	["Observer's Locus"] = 9308,
	["Redrock Mines"] = 9309,
	["Silithus: The Wound"] = 9310,
	["Sethrak War Camp"] = 9311,
	["Temple Incursion"] = 9312,
	["Silvermoon City"] = 9313,
	["Thovas Base-Camp"] = 9314,
	["Dead Man's Tale"] = 9317,
	["The Sunwell"] = 9318,
	["Camp Lastwind"] = 9319,
	["Necropolis Catacombs"] = 9321,
	["Sails' Rest"] = 9322,
	["Covescale Rise"] = 9323,
	["Dreadpearl Shallows"] = 9324,
	["Xumanu's Hideout"] = 9325,
	["Tol Dagor"] = 9327,
	["Forgotten Hollow"] = 9328,
	["Seekers' Outpost"] = 9329,
	["Gilded Docks of Zak'rajan DELETE JDA"] = 9330,
	["Gilneas Island"] = 9331,
	["Zak'rajan's Throne Room DELETE JDA"] = 9332,
	["Elarian Sanctuary"] = 9333,
	["Algerson Lumber Yard"] = 9334,
	["Hatherford"] = 9335,
	["The Serpent's Maw"] = 9336,
	["Westwind Weald"] = 9337,
	["Waning Glacier"] = 9338,
	["Arom's Stand"] = 9339,
	["The Golden Road"] = 9345,
	["The Sacred Sands"] = 9346,
	["The Bone Pit"] = 9347,
	["Slaver's Rise"] = 9348,
	["Rak'jan's Perch DELETE JDA"] = 9352,
	["Rakjan's Peak"] = 9353,
	["Siege of Boralus"] = 9354,
	["Little Tortolla"] = 9355,
	["The Steamway"] = 9356,
	["Arathor's Embrace"] = 9357,
	["Evergreen Grove"] = 9358,
	["The Vindicaar"] = 9359,
	["Fizzsprings Resort"] = 9360,
	["Terrace of the Speakers"] = 9361,
	["Ring of Booty"] = 9362,
	["Briarback Kraul"] = 9363,
	["Conqueror's Path"] = 9364,
	["Fernwood Ridge"] = 9365,
	["Brennadam"] = 9366,
	["Brennadam Square"] = 9367,
	["Mariner's Strand"] = 9368,
	["Sagehold"] = 9369,
	["Fort Daelin"] = 9370,
	["Sethrak Assault Spire"] = 9371,
	["Fogcliff Strand"] = 9372,
	["Sandscar Breach"] = 9373,
	["Drowned Lands"] = 9374,
	["Longdrop Hot Springs"] = 9375,
	["Dead Man's Tale"] = 9377,
	["Daelin's Gate"] = 9378,
	["Vigil Hill"] = 9379,
	["Old Drust Road"] = 9380,
	["Southwind Station"] = 9381,
	["Sacrificial Pits"] = 9382,
	["BlizzCon 2017"] = 9383,
	["Roughneck Camp"] = 9384,
	["Gol Osigr"] = 9385,
	["Allied - Highmountain Tauren Unlock"] = 9386,
	["Allied - Lightforged Draenei Unlock"] = 9387,
	["Hero Stage LD Demo Area"] = 9388,
	["Uldir"] = 9389,
	["The Underrot"] = 9391,
	["Creepy Isle of Blizzcon"] = 9392,
	["Greystone Keep"] = 9393,
	["Allied - Orgrimmar"] = 9394,
	["Allied - Stormwind"] = 9395,
	["Allied - Void Elf Unlock"] = 9396,
	["Allied - Nightborne Unlock"] = 9397,
	["Jewelhammer's Vault"] = 9398,
	["Addington Shipyards"] = 9400,
	["The Jeweled Coast"] = 9401,
	["Millstone Hamlet"] = 9402,
	["Eventide Delta"] = 9403,
	["Atal'Dazar"] = 9404,
	["Anglepoint Packing District"] = 9405,
	["Speakers' Step"] = 9406,
	["Ashvane Company Yards"] = 9407,
	["Sodden Depths"] = 9408,
	["Waterlogged Sewers"] = 9409,
	["Cell Block: Scillus"] = 9410,
	["Cell Block: Karybis"] = 9411,
	["Overseer's Redoubt"] = 9412,
	["Officer Quarters"] = 9413,
	["Ashvane Armory"] = 9414,
	["Telogrus Rift"] = 9415,
	["Falconhurst"] = 9416,
	["Wanderer's Cove"] = 9417,
	["BoralusDev"] = 9418,
	["Village in the Vines"] = 9419,
	["Gorilla Gorge"] = 9420,
	["Kingsmouth River"] = 9421,
	["Goldfield Farmstead"] = 9422,
	["The Amber Waves"] = 9423,
	["Waycrest Manor"] = 9424,
	["Huntmaster's Lounge"] = 9425,
	["Overgrown Atrium"] = 9426,
	["The Larder"] = 9427,
	["Grand Parlor"] = 9428,
	["Forgotten Attic"] = 9429,
	["Nazwatha Sanctum"] = 9430,
	["Watchman's Rise"] = 9432,
	["Greystone Relief"] = 9433,
	["Bloodfire Ravine"] = 9434,
	["Blood Coast"] = 9435,
	["Sundered Temple"] = 9436,
	["Gral's Grotto"] = 9437,
	["Arathi Highlands"] = 9439,
	["Verdant Wilds"] = 9440,
	["The Brineworks"] = 9441,
	["Layson & Sons Rigging"] = 9442,
	["Titan Island"] = 9443,
	["Burton Farmstead"] = 9444,
	["High Perch"] = 9455,
	["Circle of Elements"] = 9456,
	["Hatchet Ridge"] = 9457,
	["Drywhisker Mine"] = 9458,
	["Galen's Fall"] = 9459,
	["Galson's Lode"] = 9460,
	["Highlands Mill"] = 9461,
	["IsleCVTest"] = 9462,
	["A Dark Place"] = 9463,
	["Windswept Cove"] = 9464,
	["Crimson Coast"] = 9465,
	["The Rotting Mire"] = 9466,
	["White Mesa Isles"] = 9467,
	["IsleCVTest2"] = 9468,
	["Un'gol Ruins"] = 9469,
	["Mildenhall Meadery"] = 9470,
	["Highland Flats"] = 9471,
	["The Crystal Vale"] = 9472,
	["Staghelm Point"] = 9473,
	["Southwind Village"] = 9474,
	["Twilight Outpost"] = 9475,
	["Hive'Ashi"] = 9476,
	["Hive'Regal"] = 9477,
	["Hive'Zora"] = 9478,
	["Drustvar"] = 9479,
	["CursedPrototype"] = 9481,
	["Brackish Coast"] = 9482,
	["Katalina Island"] = 9483,
	["Wonderland"] = 9485,
	["lost world [ph]"] = 9486,
	["Wonderland"] = 9487,
	["Swamp Island"] = 9488,
	["Rock Spire"] = 9489,
	["The Salty Spitoon"] = 9491,
	["Valorcall Pass"] = 9492,
	["Northfold Crossing"] = 9493,
	["Ar'gorok"] = 9494,
	["Stromgarde Keep"] = 9495,
	["Molten Cay"] = 9496,
	["Skittering Hollow"] = 9497,
	["Newstead"] = 9499,
	["Bleak Hills Mine"] = 9500,
	["The Nighthold"] = 9502,
	["Corlain"] = 9509,
	["Corlain Armory"] = 9510,
	["Shipwreck"] = 9511,
	["Waterfall"] = 9512,
	["Crash Site"] = 9513,
	["Overlook"] = 9514,
	["Tar Pits"] = 9515,
	["Ruins"] = 9516,
	["Tower"] = 9517,
	["Plunge"] = 9518,
	["Tide Pools"] = 9519,
	["Bonfire"] = 9520,
	["Ridge"] = 9521,
	["Temple"] = 9522,
	["Crimson Forest"] = 9523,
	["Tul'vor"] = 9524,
	["Shrine of the Storm"] = 9525,
	["Kings' Rest"] = 9526,
	["Temple of Sethraliss"] = 9527,
	["Uncharted Territory"] = 9528,
	["Alliance Airship"] = 9529,
	["Scripps Lumber Co."] = 9530,
	["Fathom's Edge"] = 9531,
	["Thresher's Wharf"] = 9532,
	["Rootway Collapse"] = 9533,
	["Francesco test - internal only"] = 9535,
	["Winterdeep Mine"] = 9536,
	["The Four Stingers"] = 9537,
	["Sunken Path"] = 9539,
	["Snowblossom Village"] = 9540,
	["Pandaren Farm Dev"] = 9541,
	["Scalefang Outpost"] = 9542,
	["The Mugambala"] = 9543,
	["Hocking's Plot"] = 9545,
	["Pikeman's Ridge"] = 9546,
	["Corlain Aviary"] = 9547,
	["Havenswood"] = 9548,
	["Quest Training"] = 9552,
	["Stormwind City"] = 9553,
	["Stormsong Monastery"] = 9554,
	["Redrock Lowlands"] = 9555,
	["Tortaka Refuge"] = 9556,
	["Torka's Camp"] = 9557,
	["Feeding Pits"] = 9558,
	["Temple of Kimbul"] = 9559,
	["Upper Corlain"] = 9560,
	["Waycrest Manor"] = 9561,
	["Thornheart"] = 9562,
	["Sandfury Hideout"] = 9563,
	["The Maiden's Virtue"] = 9564,
	["Crater of Conquerors"] = 9565,
	["Seafarer's Rest"] = 9566,
	["Bwoljin's Fall"] = 9567,
	["Deathmist Hills"] = 9568,
	["Wayshrine of the Fallen"] = 9569,
	["Zuldazar"] = 9570,
	["Dazar'alor"] = 9571,
	["The Sliver"] = 9572,
	["Terrace of the Chosen"] = 9573,
	["Zanchul"] = 9574,
	["Rosaline's Apiary"] = 9575,
	["The Dread Chain"] = 9576,
	["Gloomwater Span"] = 9577,
	["Port Fogtide"] = 9578,
	["Tidecross"] = 9579,
	["Winterdeep Mining Camp"] = 9580,
	["Deadwash"] = 9581,
	["Outrigger Post"] = 9582,
	["Deal Farmstead"] = 9583,
	["Abandoned Passage"] = 9584,
	["Fetid Crypt"] = 9585,
	["The Blood Font"] = 9586,
	["Whitegrove Chapel"] = 9587,
	["Hook Point"] = 9588,
	["Xal'vor"] = 9589,
	["Whispering Reef"] = 9591,
	["Fort Victory"] = 9592,
	["Unity Square"] = 9593,
	["The Abyssal Melody"] = 9594,
	["Eventide Trench"] = 9595,
	["Tongo's Hideout"] = 9597,
	["The Great Seal"] = 9598,
	["Spirits Be With You"] = 9599,
	["Blushwater Brook"] = 9601,
	["Mariner's Row"] = 9602,
	["Isle of Fangs"] = 9603,
	["Tusk Isle"] = 9604,
	["Eckhart Lodge"] = 9606,
	["Briny Flats"] = 9607,
	["Arom's Crossing"] = 9608,
	["Magni's Encampment"] = 9609,
	["Hook Point Market"] = 9611,
	["Crackling RidgeDELETE JDA"] = 9612,
	["Shrouded Shore"] = 9613,
	["Chandlery Wharf"] = 9614,
	["Ashenwood Grove"] = 9615,
	["Jorundall"] = 9616,
	["Anyport"] = 9617,
	["Tempest's Roar"] = 9618,
	["Talanji's Rebuke"] = 9619,
	["Wavespeaker's Sanctum"] = 9620,
	["Tempest's Edge"] = 9621,
	["Kraken's Reach"] = 9622,
	["Tidebreak Summit"] = 9623,
	["Verdant Hollow"] = 9624,
	["Thaelin's Hideout"] = 9625,
	["Tidebreak Foothills"] = 9626,
	["Crosswind Commons"] = 9627,
	["Windshorn Hills"] = 9628,
	["Teller Farm"] = 9629,
	["The Golden Isle"] = 9630,
	["Boulderfist Hall"] = 9631,
	["Bonetrail Gulch"] = 9632,
	["Splinterbark Roost"] = 9633,
	["Rockskip Woodlands"] = 9635,
	["Northwood Home"] = 9636,
	["The Placid Spring"] = 9637,
	["Abandoned Junkheap"] = 9638,
	["Ring of Booty"] = 9639,
	["Smuggler's Run"] = 9640,
	["Umber Shore"] = 9642,
	["Winterdeep Basin"] = 9643,
	["Timberfell Outpost"] = 9644,
	["Southern Drift"] = 9645,
	["Eastern Dunes"] = 9646,
	["Falcon's Roost"] = 9647,
	["Seabreeze Village"] = 9648,
	["Shimmering Shallows"] = 9649,
	["Model Test World"] = 9651,
	["Altar of Drowned Whispers"] = 9652,
	["Hall of Communion"] = 9653,
	["Redsilt Wash"] = 9654,
	["Krazzlefrazz Outpost"] = 9655,
	["Bonepicker Summit"] = 9656,
	["Shatterstone Harbor"] = 9657,
	["Vol'dun"] = 9658,
	["The Drust Bar"] = 9659,
	["The Drunken Drummer"] = 9660,
	["Lost Spirit Lounge"] = 9661,
	["Hot House"] = 9662,
	["War Campaign - Alliance"] = 9663,
	["War Campaign - Horde"] = 9664,
	["Atal'Jani"] = 9665,
	["Blackrock Depths"] = 9666,
	["Chamber of Heart"] = 9667,
	["Shrine of the Storm"] = 9668,
	["South Seas"] = 9669,
	["Windswept Pass"] = 9670,
	["Shrouded Hollow"] = 9671,
	["Stormwind City"] = 9672,
	["Northern Elwynn Mountains"] = 9673,
	["Stormwind Harbor"] = 9674,
	["Lion's Rest"] = 9675,
	["Watchman's Tower"] = 9677,
	["Verdant Slope"] = 9678,
	["Arathi Highlands"] = 9679,
	["Ar'gorok"] = 9680,
	["Drywhisker Mine"] = 9681,
	["Circle of Elements"] = 9682,
	["Northfold Crossing"] = 9683,
	["High Perch"] = 9684,
	["Valorcall Pass"] = 9685,
	["Hatchet Ridge"] = 9686,
	["Newstead"] = 9687,
	["Highlands Mill"] = 9688,
	["Stromgarde Keep"] = 9689,
	["Galson's Lode"] = 9690,
	["Scavenging Site"] = 9691,
	["Damarcus_World"] = 9692,
	["Seekers' Vista"] = 9693,
	["Plunder Harbor"] = 9694,
	["Old Merchant Road"] = 9695,
	["Warfang Hold"] = 9696,
	["The Clearcut"] = 9697,
	["Saltstone Mine"] = 9698,
	["Seawatch Point"] = 9699,
	["Iceveil Glacier"] = 9700,
	["Vadekius's Rest"] = 9701,
	["Circle of Inner Binding"] = 9702,
	["Allied - Dark Iron Dwarf Unlock"] = 9703,
	["Allied - Mag'har Orc Unlock"] = 9704,
	["Snarlfang Den"] = 9713,
	["Seekers' Expedition"] = 9714,
	["Castaway Encampment"] = 9715,
	["The Forward Guard"] = 9716,
	["Bay of Kings"] = 9717,
	["Highland Pass"] = 9718,
	["Plume Lake"] = 9719,
	["Circle of Inner Binding"] = 9720,
	["The V.M.Z."] = 9721,
	["Lucky Strike Mines"] = 9722,
	["Rocketzan"] = 9723,
	["Downrange: Bar, Grill, and Minefield"] = 9724,
	["R&D"] = 9725,
	["Crapopolis"] = 9726,
	["The High Road"] = 9727,
	["White Frag Lane"] = 9728,
	["Platinum Sands"] = 9729,
	["Snowmelt Foothills"] = 9730,
	["The Swine's Larder"] = 9731,
	["Arathi Highlands"] = 9734,
	["Ar'gorok"] = 9735,
	["Hatchet Ridge"] = 9736,
	["Newstead"] = 9737,
	["High Perch"] = 9738,
	["Northfold Crossing"] = 9739,
	["Drywhisker Mine"] = 9740,
	["Circle of Elements"] = 9741,
	["Highlands Mill"] = 9742,
	["Stromgarde Keep"] = 9743,
	["Valorcall Pass"] = 9744,
	["Galson's Lode"] = 9745,
	["Circle of Inner Binding"] = 9746,
	["Refuge Pointe"] = 9747,
	["Circle of Outer Binding"] = 9748,
	["Dabyrie's Farmstead"] = 9749,
	["Hammerfall"] = 9750,
	["Drywhisker Gorge"] = 9751,
	["Go'Shek Farm"] = 9752,
	["Witherbark Village"] = 9753,
	["Boulderfist Hall"] = 9754,
	["Thandol Span"] = 9755,
	["Thoradin's Wall"] = 9756,
	["The Back Door"] = 9757,
	["Thoradin's Wall"] = 9758,
	["Thoradin's Wall"] = 9759,
	["Faldir's Cove"] = 9760,
	["The Drowned Reef"] = 9761,
	["Circle of East Binding"] = 9762,
	["The Rusty Blade"] = 9763,
	["Thros, the Blighted Lands"] = 9764,
	["Proudmoore Academy"] = 9765,
	["The Golden Flagon"] = 9766,
	["Shrine of the Storm"] = 9767,
	["Vulture's Nest"] = 9768,
	["Monastery Archives"] = 9769,
	["Ai'twen's Cave"] = 9770,
	["Proudmoore Barracks"] = 9771,
	["Rastakhan's Might"] = 9772,
	["Lair of Rezan"] = 9773,
	["Western Watch"] = 9774,
	["Redrock Cavern"] = 9775,
	["Forward Camp"] = 9776,
	["The Tusk Pools"] = 9777,
	["Uncharted Island"] = 9778,
	["Swiftwind Post"] = 9779,
	["The Siren's Call"] = 9780,
	["Kunza-Kunza"] = 9781,
	["Abandoned Ruin"] = 9782,
	["Shrine of Bones"] = 9783,
	["Backwater Beach"] = 9784,
	["Scavenger's Shore"] = 9785,
	["Gorgrond"] = 9786,
	["Skyrender Eyrie"] = 9788,
	["The Feeding Grounds"] = 9789,
	["Carapace Ridge"] = 9793,
	["Shepherd's Bluff"] = 9794,
	["Mangrove Shore"] = 9795,
	["Wolf's Den"] = 9796,
	["Bilgewater Bonanza"] = 9797,
	["Beacon Hill"] = 9798,
	["Roaring Highland"] = 9799,
	["The Great Sea"] = 9800,
	["Snug Harbor Inn"] = 9801,
	["Harbormaster's Office"] = 9802,
	["Howling Isles"] = 9803,
	["Stormwatch Peak"] = 9804,
	["Takulu Bridge"] = 9805,
	["Redfield's Watch"] = 9806,
	["Altar of Rot"] = 9807,
	["Eastern Kingdoms"] = 9808,
	["Vol'dun"] = 9809,
	["The Whispering Crag"] = 9810,
	["Sandy Refuge"] = 9811,
	["Plains of Tojek"] = 9812,
	["Stonefist Watch"] = 9813,
	["Vestibule of the Faithless"] = 9814,
	["Echoing Warrens"] = 9815,
	["Clutch of the Great Mother"] = 9816,
	["The Galvanized Grotto"] = 9817,
	["The Bazaar of Watchful Eyes"] = 9818,
	["Atrium of Sethraliss"] = 9819,
	["Collapsed Tunnel"] = 9820,
	["Mudfisher Cove"] = 9824,
	["Murkfathom Reach"] = 9825,
	["Sword of Dawn"] = 9826,
	["Driftwood Shore"] = 9827,
	["Troll Forest Cafe"] = 9828,
	["Windfall Cavern"] = 9829,
	["Tempest's Roar"] = 9830,
	["The Siren's Daughter"] = 9831,
	["The Valorous Rose"] = 9832,
	["Diretusk Hollow"] = 9833,
	["Hillcrest Pasture"] = 9836,
	["Boulderfist Hall"] = 9838,
	["Terrace of Crafters"] = 9935,
	["The Lion's Wake"] = 9936,
	["The Great Sea"] = 9937,
	["Stonemaul"] = 9938,
	["Hellsreach Citadel"] = 9939,
	["The Broken Spine"] = 9940,
	["Sulfur Basin"] = 9941,
	["Affliction Ridge"] = 9942,
	["Beastwatch"] = 9943,
	["Razorbloom Fallow"] = 9944,
	["Evermorn Hold"] = 9945,
	["Brimstone Springs"] = 9946,
	["Stonetusk Watch"] = 9947,
	["Xibala Shallows"] = 9948,
	["Tirisfal Glades: The Blight"] = 9949,
	["Boulder'gor"] = 9950,
	["South Seas"] = 9951,
	["Scalespine Hill"] = 9952,
	["Forgotten Cove"] = 9955,
	["Ironmaul Overlook"] = 9956,
	["Gral's Call - Crew's Quarters"] = 9957,
	["Gral's Call - Rest of Ship"] = 9958,
	["Undercity"] = 9959,
	["8.0 Islands - Ship - Player Alliance - Kul'Tiras Medium 01 With Gangplank"] = 9960,
	["Veiled Grotto"] = 9961,
	["Watertusk Inn"] = 9962,
	["Fonts of Cleansing"] = 9963,
	["Tidewater Sanctum"] = 9964,
	["Ulfar's Den"] = 9965,
	["Mugamba Overlook"] = 9966,
	["Sprucewood"] = 9967,
	["Muckwallow"] = 9968,
	["Widow's Peak"] = 9969,
	["Hall of Strength"] = 9970,
	["Crescent Cove"] = 9971,
	["Beryl Meadow"] = 9972,
	["Twin Rivers"] = 9973,
	["Mistvine Ledge"] = 9974,
	["Briarback Warrens"] = 9975,
	["Lifestone Cavern"] = 9976,
	["Gnarlroot Cleft"] = 9977,
	["Grimwatt's Crash"] = 9978,
	["Dampwick Ward"] = 9979,
	["Ashvane Docks"] = 9980,
	["Darkshore"] = 9981,
	["Tradewinds Market"] = 9982,
	["Dampwick Ward"] = 9983,
	["Ashvane Company Yards"] = 9984,
	["Unity Square"] = 9985,
	["Kraken's Breach"] = 9986,
	["The Lost Estate"] = 9988,
	["Mugambala"] = 9992,
	["The Sand Bar"] = 9993,
	["Chamber of Rezan"] = 9994,
	["Anchors Down"] = 9995,
	["The Drunk Tank"] = 9996,
	["The Lost Scroll"] = 9997,
	["The Sunken Keg"] = 9998,
	["Sink n' Swim"] = 9999,
	["The Dive Bar"] = 10000,
	["Heyman's Hideaway"] = 10001,
	["Mount Cortis"] = 10002,
	["Shrine of Shadows"] = 10003,
	["The Precipice of Oblivion"] = 10004,
	["Raimond's Laboratory"] = 10005,
	["House of Jol"] = 10006,
	["The Shrunken Head"] = 10007,
	["Watertusk Inn"] = 10008,
	["Beastcaller Inn"] = 10009,
	["Dark Iron Forward Camp"] = 10010,
	["Nightborne Forward Camp"] = 10011,
	["The Hozen Throne"] = 10012,
	["The Screaming Pit"] = 10013,
	["Torga's Tavern"] = 10014,
	["Tol Dagor"] = 10015,
	["Davenport Residence"] = 10016,
	["Sanctum of the Sages"] = 10017,
	["Tradewinds Counting House"] = 10018,
	["Sanctuary of Blood"] = 10020,
	["Ruins of Xal'vor"] = 10021,
	["Firelands"] = 10022,
	["Quilltop"] = 10024,
	["Lord Admiral's Rest"] = 10025,
	["Tiragarde Sound"] = 10026,
	["The Wayward Cask"] = 10027,
	["Blackrock Depths"] = 10028,
	["The Scarab Dais"] = 10029,
	["The Scarab Wall"] = 10030,
	["Valor's Rest"] = 10031,
	["Path of Storms"] = 10033,
	["Upton Borough"] = 10034,
	["Lair of Xak'lar"] = 10035,
	["Operation: Mechagon"] = 10036,
	["Upton Borough"] = 10037,
	["The Rum Quarter"] = 10038,
	["The Court of Crossbones"] = 10039,
	["Sweete's Landing"] = 10040,
	["The Battle for Stromgarde"] = 10041,
	["Braxton Lodge"] = 10042,
	["Tol Dagor"] = 10043,
	["The Forbidding Sea"] = 10046,
	["Siege of Orgrimmar"] = 10047,
	["Gale's Rest"] = 10048,
	["Nazjatar"] = 10052,
	["Arathi Basin"] = 10053,
	["Crucible of Storms"] = 10057,
	["Darkshore"] = 10058,
	["Darkshore"] = 10059,
	["[TEMP] Underwater Ideation"] = 10061,
	["Test Dungeon - White Area"] = 10062,
	["Test Dungeon - Gray Area"] = 10063,
	["Withering Thicket"] = 10064,
	["Ruins of Auberdine"] = 10065,
	["Cliffspring River"] = 10066,
	["Lor'danel"] = 10067,
	["Bashal'Aran"] = 10068,
	["Ruins of Lornesta"] = 10069,
	["Moontouched Den"] = 10070,
	["Mist's Edge"] = 10071,
	["The Veiled Sea"] = 10072,
	["Twilight Shore"] = 10073,
	["Twilight Vale"] = 10074,
	["Auberdine Refugee Camp"] = 10075,
	["Battle of Dazar'alor"] = 10076,
	["Horde Airship"] = 10077,
	["Horde Airship"] = 10078,
	["Horde Airship"] = 10079,
	["Bitterstone Quarry"] = 10080,
	["Cinderfall Grove"] = 10081,
	["Ashwood Depot"] = 10082,
	["Darkshore"] = 10084,
	["The Battle for Darkshore"] = 10085,
	["Greystone Ruins"] = 10086,
	["Forlorn Crossing"] = 10087,
	["Allied - Zandalari Unlock"] = 10088,
	["Lor'danel Landing"] = 10089,
	["The Dredge"] = 10090,
	["Alliance Airship"] = 10091,
	["Alliance Airship"] = 10092,
	["Alliance Airship"] = 10093,
	["Lornesta Mine"] = 10094,
	["Gloomtide Strand"] = 10095,
	["Dragonblight"] = 10154,
	["Icecrown"] = 10155,
	["Borean Tundra"] = 10156,
	["Sholazar Basin"] = 10157,
	["The Borean Wall"] = 10158,
	["The Geyser Fields"] = 10159,
	["Fizzcrank Pumping Station"] = 10160,
	["The Flood Plains"] = 10161,
	["Steam Springs"] = 10162,
	["Talramas"] = 10163,
	["Festering Pools"] = 10164,
	["The Dens of Dying"] = 10165,
	["Temple City of En'kilah"] = 10166,
	["Spire of Blood"] = 10167,
	["Spire of Decay"] = 10168,
	["Spire of Pain"] = 10169,
	["North Point Station"] = 10170,
	["Westwind Refugee Camp"] = 10171,
	["Icemist Village"] = 10172,
	["Agmar's Hammer"] = 10173,
	["Obsidian Dragonshrine"] = 10174,
	["Angrathar the Wrathgate"] = 10175,
	["Wintergrasp"] = 10176,
	["The Lost Lands"] = 10177,
	["River's Heart"] = 10178,
	["Rainspeaker Canopy"] = 10179,
	["Frenzyheart Hill"] = 10180,
	["Wildgrowth Mangal"] = 10181,
	["The Sundered Shard"] = 10182,
	["The Lifeblood Pillar"] = 10183,
	["Mosswalker Village"] = 10184,
	["The Skyreach Pillar"] = 10185,
	["Hardknuckle Clearing"] = 10186,
	["Sapphire Hive"] = 10187,
	["The Blight Line"] = 10188,
	["Lakeside Landing"] = 10189,
	["Rainspeaker Rapids"] = 10190,
	["Frenzyheart River"] = 10191,
	["Wintergrasp River"] = 10192,
	["Coldwind Pass"] = 10193,
	["The Court of Bones"] = 10194,
	["Icecrown Citadel"] = 10195,
	["Central Bridge"] = 10196,
	["The Sunken Ring"] = 10197,
	["The Broken Temple"] = 10198,
	["Wintergrasp Fortress"] = 10199,
	["Eastern Bridge"] = 10200,
	["Western Bridge"] = 10201,
	["Flamewatch Tower"] = 10202,
	["Winter's Edge Tower"] = 10203,
	["Shadowsight Tower"] = 10204,
	["The Cauldron of Flames"] = 10205,
	["Glacial Falls"] = 10206,
	["The Forest of Shadows"] = 10207,
	["The Chilled Quagmire"] = 10208,
	["The Steppe of Life"] = 10209,
	["Westspark Workshop"] = 10210,
	["Eastspark Workshop"] = 10211,
	["Falcon's Rest"] = 10212,
	["Nzoth"] = 10213,
	["The Skybag"] = 10217,
	["Warsong Gulch"] = 10218,
	["Warsong Lumber Mill"] = 10219,
	["Silverwing Hold"] = 10220,
	["The Moonspray"] = 10221,
	["Crestfall"] = 10222,
	["Aegrim's Study"] = 10223,
	["Zul'Toa"] = 10224,
	["Operation: Mechagon"] = 10225,
	["Darkshore"] = 10226,
	["Darkshore"] = 10227,
	["Lor'danel Landing"] = 10228,
	["Withering Thicket"] = 10229,
	["Lor'danel"] = 10230,
	["The Dredge"] = 10231,
	["Ruins of Auberdine"] = 10232,
	["Ashwood Depot"] = 10233,
	["Cliffspring River"] = 10234,
	["Cliffspring River"] = 10235,
	["Cinderfall Grove"] = 10236,
	["Lor'danel"] = 10237,
	["Forlorn Crossing"] = 10238,
	["Bashal'Aran"] = 10239,
	["Gloomtide Strand"] = 10240,
	["Bashal'Aran"] = 10241,
	["Ruins of Lornesta"] = 10242,
	["Lornesta Mine"] = 10243,
	["Moontouched Den"] = 10244,
	["Ruins of Lornesta"] = 10245,
	["Mist's Edge"] = 10246,
	["Mist's Edge"] = 10247,
	["The Veiled Sea"] = 10248,
	["Twilight Shore"] = 10249,
	["Twilight Vale"] = 10250,
	["Auberdine Refugee Camp"] = 10251,
	["Bitterstone Quarry"] = 10252,
	["Cinderfall Grove"] = 10253,
	["Ashwood Depot"] = 10254,
	["Forlorn Crossing"] = 10255,
	["Lor'danel Landing"] = 10256,
	["The Dredge"] = 10257,
	["Lornesta Mine"] = 10258,
	["Gloomtide Strand"] = 10259,
	["Tenebrous Vault"] = 10260,
	["Uncharted Territory"] = 10261,
	["The Strider"] = 10262,
	["Gnomeregan"] = 10263,
	["Shrine of the Storm (copy)"] = 10265,
	["Crucible of Storms"] = 10266,
	["Questfall"] = 10267,
	["Delaryn's Demise"] = 10268,
	["Zandalari Treasury"] = 10270,
	["Dev Smoketest Area"] = 10271,
	["Tol Dagor"] = 10272,
	["Shadow Core"] = 10273,
	["Court of the Sun"] = 10275,
	["Withering Thicket"] = 10277,
	["Ruins of Auberdine"] = 10278,
	["Twilight Shore"] = 10279,
	["Bashal'Aran"] = 10280,
	["Forlorn Crossing"] = 10281,
	["Ashwood Depot"] = 10282,
	["Mist's Edge"] = 10283,
	["Delaryn's Demise"] = 10284,
	["Shrine of Shadows"] = 10285,
	["Tendril of Corruption"] = 10286,
	["Redridge Pass"] = 10287,
	["Darkshore"] = 10288,
	["Mechagon"] = 10290,
	["Sunken Coast"] = 10291,
	["zzOLDBastion"] = 10292,
	["Ruins of Mathystra"] = 10293,
	["Ruins of Auberdine"] = 10294,
	["Tower of Althalaxx"] = 10295,
	["Cliffspring Falls"] = 10296,
	["Bashal'Aran"] = 10297,
	["Ameth'Aran"] = 10298,
	["Grove of the Ancients"] = 10299,
	["The Master's Glaive"] = 10300,
	["Remtravel's Excavation"] = 10301,
	["Mists's Edge"] = 10302,
	["The Long Wash"] = 10303,
	["Wildbend River"] = 10304,
	["Kor'gar"] = 10305,
	["Cliffspring River"] = 10306,
	["Twilight Vale"] = 10307,
	["The Veiled Sea"] = 10308,
	["Auberdine Refugee Camp"] = 10309,
	["Lor'danel"] = 10310,
	["Ruins of Lornesta"] = 10311,
	["Cliffspring Hollow"] = 10312,
	["Shatterspear War Camp"] = 10313,
	["Withering Thicket"] = 10314,
	["The Eye of the Vortex"] = 10315,
	["Blackwood Camp"] = 10316,
	["Maw of the Void"] = 10317,
	["Shatterspear Vale"] = 10318,
	["The Blazing Strand"] = 10319,
	["Moontouched Den"] = 10320,
	["Shatterspear Pass"] = 10321,
	["Earthshatter Cavern"] = 10322,
	["Wreckage of the Silver Dawning"] = 10323,
	["Gloomtide Strand"] = 10324,
	["Twilight Shore"] = 10325,
	["Nazj'vel"] = 10326,
	["Tide's Fall"] = 10327,
	["Tide's Fall"] = 10328,
	["Spears of Azshara"] = 10330,
	["Lower Cataracts"] = 10331,
	["The Hanging Reef"] = 10332,
	["Newhome"] = 10333,
	["Mezzamere"] = 10334,
	["Ashen Strand"] = 10335,
	["Alathir Spire"] = 10337,
	["Deepsea Slave Pen"] = 10338,
	["Predator Pass"] = 10339,
	["Coral Forest"] = 10340,
	["Kal'methir"] = 10341,
	["Kal'methir Citadel"] = 10342,
	["Iwen's Sanctum"] = 10343,
	["Nar'anan"] = 10344,
	["The Drowned Market"] = 10345,
	["Zin-Azshari"] = 10346,
	["Prototype"] = 10348,
	["Imperial Gardens"] = 10353,
	["Zanj'ir Terrace"] = 10354,
	["Icecrown Citadel"] = 10355,
	["Azsh'ari Terrace"] = 10356,
	["The Ashenvale Front"] = 10357,
	["Gnomeregan"] = 10358,
	["The Frozen Throne"] = 10359,
	["Deepcoil Tunnels"] = 10361,
	["Boralus Harbor"] = 10364,
	["Halls of Stone"] = 10366,
	["Shadow Core"] = 10367,
	["The Great Sea"] = 10368,
	["Atwater Stead"] = 10369,
	["The Zocalo"] = 10370,
	["Dazar'alor"] = 10371,
	["Bitterstone Quarry"] = 10372,
	["Terrace of the Speakers"] = 10373,
	["Grand Bazaar"] = 10374,
	["Port of Zandalar"] = 10375,
	["Bay of Kings"] = 10376,
	["Cursed Grove"] = 10377,
	["Shadow Core"] = 10378,
	["Fangtooth Bog"] = 10379,
	["Allied - Kul Tiran Unlock"] = 10380,
	["Hall of Ritual"] = 10381,
	["Auberdine Coast"] = 10382,
	["Halls of Opulence"] = 10383,
	["Path of the Ancestors"] = 10384,
	["Loa's Sanctum"] = 10385,
	["Walk of Kings"] = 10386,
	["The Heart of the Empire"] = 10387,
	["Shatterfall Pass"] = 10388,
	["Thoras'tal Spire"] = 10389,
	["Cinderfall Grove"] = 10390,
	["Ashwood Depot"] = 10391,
	["Lor'danel Landing"] = 10392,
	["Forlorn Crossing"] = 10393,
	["The Dredge"] = 10394,
	["Lemor'athra Spire"] = 10396,
	["Mulgore"] = 10397,
	["Red Cloud Mesa"] = 10398,
	["Camp Narache"] = 10399,
	["Feralas"] = 10400,
	["Brambleblade Ravine"] = 10401,
	["The Rolling Plains"] = 10402,
	["Gordunni Outpost"] = 10403,
	["Southern Barrens"] = 10404,
	["Thornmantle's Hideout"] = 10405,
	["Fargaze Mesa"] = 10406,
	["The Thornsnarl"] = 10407,
	["The Battleboar Pen"] = 10408,
	["Lake Dumont"] = 10409,
	["Highborne Estates"] = 10410,
	["Elun'alor Temple"] = 10411,
	["Dragon's Teeth Basin"] = 10412,
	["Revendreth"] = 10413,
	["Abandoned Mines"] = 10416,
	["Mulgore"] = 10417,
	["Rustbolt"] = 10418,
	["Overspark Expedition Camp"] = 10419,
	["Prospectus Bay"] = 10420,
	["Uldir"] = 10421,
	["Safe House"] = 10422,
	["Forgotten Vault"] = 10423,
	["Exile's Reach"] = 10424,
	["The Eternal Palace"] = 10425,
	["The Swift Vengeance"] = 10426,
	["The Swift Vengeance"] = 10427,
	["The Outflow"] = 10428,
	["The Prison of Ink"] = 10429,
	["Val'sharah"] = 10430,
	["The Dreamgrove"] = 10431,
	["Emerald Bay"] = 10432,
	["Darkheart Thicket"] = 10433,
	["The Heaps"] = 10435,
	["Scrapbone Den"] = 10436,
	["Bondo's Yard"] = 10437,
	["The Fleeting Forest"] = 10438,
	["Junkwatt Depot"] = 10439,
	["Arathi Basin"] = 10440,
	["Trollbane Hall"] = 10441,
	["Defiler's Den"] = 10442,
	["Farm"] = 10443,
	["Blacksmith"] = 10444,
	["Lumber Mill"] = 10445,
	["Gold Mine"] = 10446,
	["Stables"] = 10447,
	["Darkest Depths"] = 10448,
	["Mardivas' Laboratory"] = 10450,
	["Stratholme"] = 10451,
	["Abandoned Camp"] = 10452,
	["Murloc Hideaway"] = 10453,
	["Tiffin's Melody"] = 10454,
	["Tiffin's Melody"] = 10455,
	["The Obsidian Sanctum"] = 10456,
	["Alterac Valley"] = 10458,
	["Grunters Hideout"] = 10465,
	["Western Spray"] = 10467,
	["Toothy Shallows"] = 10468,
	["The Retreating Forest Top"] = 10469,
	["Broken Point"] = 10470,
	["Torghast, Tower of the Damned"] = 10472,
	["Hearthstone Tavern"] = 10473,
	["Emerald Dreamway"] = 10474,
	["The Emerald Dream"] = 10475,
	["Stormwind"] = 10476,
	["The Dragon's Spine"] = 10477,
	["Twilight Highlands"] = 10478,
	["Vermillion Redoubt"] = 10479,
	["Dragonmaw Pass"] = 10480,
	["Wyrms' Bend"] = 10481,
	["Grim Batol"] = 10482,
	["Uncharted Territory"] = 10483,
	["Vision of Stormwind"] = 10488,
	["Gilneas City"] = 10489,
	["Vision of Orgrimmar"] = 10492,
	["Old Merchant Road"] = 10495,
	["Crumbling Cavern"] = 10496,
	["The Robodrome"] = 10497,
	["Brinestone Cove"] = 10500,
	["Scarlet Halls"] = 10501,
	["Training Grounds"] = 10502,
	["Quilboar Briarpatch"] = 10503,
	["Chamber of Heart"] = 10504,
	["Bloodfin Village"] = 10505,
	["Chitterspine Grotto"] = 10506,
	["Miju's Retreat"] = 10507,
	["Baine Rescue"] = 10508,
	["Moch'k's Hole"] = 10510,
	["Tinted Cave"] = 10511,
	["Zanj'ir Wash"] = 10512,
	["Maedin's Challenge"] = 10513,
	["Blacksmith"] = 10514,
	["Blacksmith"] = 10515,
	["Lumber Mill"] = 10516,
	["Farm"] = 10517,
	["Stables"] = 10518,
	["Gold Mine"] = 10519,
	["Trollbane Hall"] = 10520,
	["Defiler's Den"] = 10521,
	["Ny'alotha, the Waking City"] = 10522,
	["Wizard's Sanctum"] = 10523,
	["The Maelstrom"] = 10524,
	["Shirakess Repository"] = 10525,
	["The Eye of Eternity"] = 10526,
	["Hrun's Barrow"] = 10527,
	["Harpy Roost"] = 10528,
	["Ogre Ruins"] = 10529,
	["Darkmaul Citadel"] = 10530,
	["Sourback Hideout"] = 10531,
	["Hungry Rest"] = 10533,
	["Bastion"] = 10534,
	["Gorgonian Overlook"] = 10535,
	["Rustrock Cavern"] = 10536,
	["Crystalized Cavern"] = 10538,
	["The Burned Cave"] = 10539,
	["Engineer's Respite"] = 10543,
	["Deepsea Refuge"] = 10544,
	["Chitterspine Caverns"] = 10545,
	["Gate of the Queen"] = 10546,
	["The Tidal Conflux"] = 10547,
	["Basin Hideout"] = 10548,
	["Kelfin Pocket"] = 10549,
	["Utama's Stand"] = 10550,
	["Abyssal Pool"] = 10562,
	["Chamber of Harvesters"] = 10563,
	["The Greasy Eel"] = 10564,
	["Oribos"] = 10565,
	["Scrapbone's Hollow"] = 10566,
	["Crashcog Circuit"] = 10567,
	["Darkmaul Bridge"] = 10568,
	["Sparkweaver Point"] = 10574,
	["Echo's Hovel"] = 10580,
	["Darkmaul Citadel"] = 10581,
	["Caverns of Time"] = 10582,
	["Halls of Origination"] = 10584,
	["Darkmaul Plains"] = 10588,
	["Scavenger's Alcove"] = 10589,
	["Murloco's Hideaway"] = 10603,
	["Honeyback Hatchery"] = 10619,
	["Durotar"] = 10625,
	["Southfury River"] = 10626,
	["Southfury River"] = 10627,
	["Razormane Grounds"] = 10628,
	["Southfury Watershed"] = 10629,
	["Karazhan Catacombs"] = 10638,
	["The North Sea"] = 10639,
	["The Endmire"] = 10640,
	["Void Chamber"] = 10641,
	["Darkwater Cavern"] = 10642,
	["Highmountain"] = 10713,
	["Stormheim"] = 10714,
	["Weeping Bluffs"] = 10715,
	["Aggramar's Vault"] = 10716,
	["Crowley's Overlook"] = 10717,
	["Skyfire Triage Camp"] = 10718,
	["Cove of Nashal"] = 10719,
	["Forsaken Foothold"] = 10720,
	["Blackbeak Overlook"] = 10721,
	["Hrydshal"] = 10722,
	["Stormwing Rookery"] = 10723,
	["Galebroken Path"] = 10724,
	["Thorim's Peak"] = 10725,
	["Gates of Valor"] = 10726,
	["Suramar"] = 10727,
	["Field of Fallen Kings"] = 10728,
	["The Runewood"] = 10729,
	["Haustvald"] = 10730,
	["The Great Sea"] = 10731,
	["Ironhorn Enclave"] = 10732,
	["Skold-Ashil"] = 10733,
	["Dreadwake's Landing"] = 10734,
	["Greywatch"] = 10735,
	["Ranger's Foothold"] = 10736,
	["Cullen's Post"] = 10737,
	["Lorna's Watch"] = 10738,
	["Talonrest"] = 10739,
	["Felskorn Warcamp"] = 10740,
	["Bluffpoint"] = 10741,
	["Helmouth Cliffs"] = 10742,
	["Skyhorn"] = 10743,
	["Greymane's Offensive"] = 10744,
	["Bronzeleaf Thicket"] = 10745,
	["Valdisdall"] = 10746,
	["Snowblind Mesa"] = 10747,
	["Valley of the Sword"] = 10748,
	["Sepulcher of the Sky"] = 10749,
	["Tel'anor"] = 10750,
	["Helmouth Shallows"] = 10751,
	["Tideskorn Harbor"] = 10752,
	["Shield's Rest"] = 10753,
	["Inkbinders Rise"] = 10754,
	["Morheim"] = 10755,
	["Bilgefin Shore"] = 10756,
	["Sashj'tar Ruins"] = 10757,
	["Azuregale Bay"] = 10758,
	["Sunfrost Glade"] = 10759,
	["Icepine Point"] = 10760,
	["Howling Hills"] = 10761,
	["Jandvik"] = 10762,
	["Straits of Hydrannon"] = 10763,
	["Stonehoof Watch"] = 10764,
	["The Grand Promenade"] = 10765,
	["Warpwind Cliffs"] = 10766,
	["Aegira's Meadery"] = 10767,
	["Azuregale Cove"] = 10768,
	["Highmountain Summit"] = 10769,
	["Cordana's Apex"] = 10770,
	["Crimson Thicket"] = 10771,
	["Suramar City"] = 10772,
	["Twilight Vineyards"] = 10773,
	["Snowblind Cliffs"] = 10774,
	["Stormtorn Foothills"] = 10775,
	["Storm's Reach"] = 10776,
	["Kingsfall Pass"] = 10777,
	["Amberfall Mesa"] = 10778,
	["Citrine Bay"] = 10779,
	["Nastrondir"] = 10780,
	["Nashal's Watch"] = 10781,
	["Highmountain Peak"] = 10782,
	["Blackfeather Altar"] = 10783,
	["Jotunnwood"] = 10784,
	["Whisperwind's Citadel"] = 10785,
	["Watchman's Rock"] = 10786,
	["Stonescar Gorge"] = 10787,
	["Dreyrgrot"] = 10788,
	["Terrace of the Watchers"] = 10789,
	["Akstad"] = 10790,
	["Runeaxe Training Grounds"] = 10791,
	["Stonewarden Quarry"] = 10792,
	["Blackhawk's Bulwark"] = 10793,
	["Spiritwatch Point"] = 10794,
	["Estate of the First Arcanist"] = 10795,
	["The Menagerie"] = 10796,
	["Vrekt"] = 10797,
	["Rockaway Shelf"] = 10798,
	["Stony Highlands"] = 10799,
	["Ashil's Bay"] = 10800,
	["Sunset Park"] = 10801,
	["Moonlit Landing"] = 10802,
	["The Gilded Market"] = 10803,
	["Midnight Court"] = 10804,
	["The Jeweled Estate"] = 10805,
	["Hafr Fjall"] = 10806,
	["Moonbeam Causeway"] = 10807,
	["Ravenperch Cove"] = 10808,
	["Gloomshore"] = 10809,
	["Loch Varmad"] = 10810,
	["Gull Rock"] = 10811,
	["Felborne Outpost"] = 10812,
	["Uldum"] = 10833,
	["The Gate of Unending Cycles"] = 10835,
	["Obelisk of the Stars"] = 10836,
	["Khartut's Tomb"] = 10837,
	["Orsis"] = 10838,
	["Ramkahen"] = 10839,
	["Nahom"] = 10840,
	["Mar'at"] = 10841,
	["Akhenet Fields"] = 10842,
	["Ramkahen Legion Outpost"] = 10843,
	["The Pit of Scales"] = 10844,
	["Sunstone Terrace"] = 10845,
	["Gate of Hamatep"] = 10846,
	["Vir'naal River"] = 10847,
	["Cradle of the Ancients"] = 10848,
	["Obelisk of the Sun"] = 10849,
	["Lost City of the Tol'vir"] = 10850,
	["Ankhaten Harbor"] = 10851,
	["Ruins of Ammon"] = 10852,
	["The Cursed Landing"] = 10853,
	["The Steps of Fate"] = 10854,
	["The Trail of Devastation"] = 10855,
	["Tahret Grounds"] = 10856,
	["Seal of the Sun King"] = 10857,
	["Sahket Wastes"] = 10858,
	["Ruins of Ahmtul"] = 10859,
	["Neferset City"] = 10860,
	["Sunwatcher's Ridge"] = 10861,
	["Vir'naal Dam"] = 10862,
	["Obelisk of the Moon"] = 10863,
	["Temple of Uldum"] = 10864,
	["Oasis of Vir'sar"] = 10865,
	["Ruins of Khintaset"] = 10866,
	["Sullah's Sideshow"] = 10867,
	["Maker's Ascent"] = 10868,
	["Neferset City Outskirts"] = 10869,
	["Pilgrim's Precipice"] = 10870,
	["Mount Akher"] = 10871,
	["Tombs of the Precursors"] = 10872,
	["Arsad Trade Post"] = 10873,
	["Keset Pass"] = 10874,
	["Surveyors' Outpost"] = 10876,
	["Tomb of the Sun King"] = 10877,
	["Vir'naal Oasis"] = 10878,
	["Vir'naal Lake"] = 10879,
	["Vir'naal River Delta"] = 10880,
	["Bluff of the South Wind"] = 10881,
	["Halls of Origination"] = 10882,
	["Chamber of the Sun"] = 10883,
	["Chamber of the Moon"] = 10884,
	["Chamber of the Stars"] = 10885,
	["Deepwind Gorge"] = 10886,
	["Solesa naksu [DNT]"] = 10887,
	["The Veiled Stair"] = 10920,
	["Terrace of Gurthan"] = 10957,
	["The Horrid March"] = 10958,
	["Gate of Endless Spring"] = 10959,
	["The Secret Aerie"] = 10960,
	["Tavern in the Mists"] = 10961,
	["Path of a Hundred Steps"] = 10962,
	["The Spring Road"] = 10963,
	["Mason's Folly"] = 10964,
	["Forgotten Mire"] = 10968,
	["The Thundering Run"] = 10969,
	["The Banewood"] = 10978,
	["Darkhaven"] = 10979,
	["Castle Nathria"] = 10980,
	["Catacombs of Regret"] = 10981,
	["Pridefall Hamlet"] = 10982,
	["Wanecrypt Hill"] = 10983,
	["Court of the Harvesters"] = 10984,
	["Ember Ward"] = 10985,
	["Sinfall"] = 10986,
	["The Shrouded Asylum"] = 10987,
	["Sanctuary of the Mad"] = 10988,
	["Dominance Keep"] = 10989,
	["Menagerie of the Master"] = 10990,
	["Bloody Grotto"] = 10991,
	["Scorpidsting's Schooner"] = 10992,
	["Sand Dweller's Refuge"] = 10993,
	["Charred Ramparts"] = 10994,
	["Halls of Atonement"] = 10995,
	["Edge of Sin"] = 10996,
	["Archivam"] = 10997,
	["Crypt of the Forgotten"] = 10998,
	["Grand Palisade"] = 10999,
	["Redelav District"] = 11000,
	["Chalice District"] = 11001,
	["Old Gate"] = 11002,
	["Darkwall Tower"] = 11003,
	["Dominance Gate"] = 11004,
	["Shassera's Lair"] = 11005,
	["Dredhollow"] = 11006,
	["Stalker's Lodge"] = 11007,
	["Wreck of the Hungry Riverbeast"] = 11008,
	["Wreck of the Old Blanchy"] = 11009,
	["Killclaw's Lair"] = 11011,
	["Elysian Hold"] = 11012,
	["Vestibule of Eternity"] = 11013,
	["The Temple of Purity"] = 11014,
	["Feeders' Thicket"] = 11015,
	["Decimated Crossroad"] = 11016,
	["Witherfall Ruin"] = 11017,
	["Wildwall"] = 11018,
	["Dredgewood"] = 11019,
	["Caretaker's Manor"] = 11020,
	["Stonevigil Overlook"] = 11021,
	["Mrgl's Bar and Gill"] = 11023,
	["The Jade Forest"] = 11024,
	["Valley of the Four Winds"] = 11025,
	["Kun-Lai Summit"] = 11026,
	["Townlong Steppes"] = 11027,
	["Serenity Falls"] = 11028,
	["Path of Enlightenment"] = 11029,
	["Exclamation Point"] = 11030,
	["Camp Nooka Nooka"] = 11031,
	["Spire of Solitude"] = 11032,
	["Lake Kittitata"] = 11033,
	["Circle of Scale"] = 11034,
	["Thunderfoot Fields"] = 11035,
	["Thunderfoot Ranch"] = 11036,
	["Thunderfoot Farm"] = 11037,
	["Tigers' Wood"] = 11038,
	["Grassy Cline"] = 11039,
	["Shang's Stead"] = 11040,
	["Grookin Hill"] = 11041,
	["Dookin' Grounds"] = 11042,
	["Scenic Overlook"] = 11043,
	["Murky Bank"] = 11044,
	["Mudmug's Place"] = 11045,
	["Sunsoaked Meadow"] = 11046,
	["Slicky Stream"] = 11047,
	["Paoquan Hollow"] = 11048,
	["Singing Marshes"] = 11049,
	["Pools of Purity"] = 11050,
	["New Cifera"] = 11051,
	["Gilded Fan"] = 11052,
	["The Heartland"] = 11053,
	["The Veiled Stair"] = 11054,
	["Huangtze Falls"] = 11055,
	["Mistfall Village"] = 11056,
	["Ruins of Guo-Lai"] = 11057,
	["The Golden Stair"] = 11058,
	["Whitepetal Lake"] = 11059,
	["Setting Sun Garrison"] = 11060,
	["The Golden Pagoda"] = 11061,
	["Tu Shen Burial Ground"] = 11062,
	["Ruins Rise"] = 11063,
	["Winterbough Glade"] = 11064,
	["The Five Sisters"] = 11065,
	["Shrine of Seven Stars"] = 11079,
	["Mogu'shan Palace"] = 11080,
	["Jin Yang Road"] = 11081,
	["The Summer Fields"] = 11082,
	["Ancestral Rise"] = 11083,
	["Gate of the Setting Sun"] = 11099,
	["The Emperor's Approach"] = 11106,
	["Autumnshade Ridge"] = 11108,
	["Sunblossom Hill"] = 11109,
	["Shrine of Two Moons"] = 11110,
	["Big Blossom Excavation"] = 11111,
	["Continent"] = 11356,
	["The Eternal Palace"] = 11375,
	["Aspirant's Crucible"] = 11377,
	["The Eonian Archives"] = 11378,
	["Citadel of Loyalty"] = 11379,
	["Temple of Courage"] = 11380,
	["Hero's Rest"] = 11381,
	["8.2.5 War Campaign"] = 11382,
	["The Royal Approach"] = 11383,
	["Mogu'shan Palace"] = 11384,
	["Gorm's Den"] = 11385,
	["Pathfinder's Den"] = 11386,
	["Bondo's Yard"] = 11387,
	["Scrapbone Den"] = 11388,
	["The Outflow"] = 11389,
	["Junkwatt Depot"] = 11390,
	["Rustbolt"] = 11391,
	["Crashcog Circuit"] = 11392,
	["Crumbling Cavern"] = 11393,
	["Ekka's Hideaway"] = 11394,
	["Mogu'shan Vaults"] = 11395,
	["Coral Grove"] = 11396,
	["Temple of the Jade Serpent"] = 11397,
	["TravisTestTerrain"] = 11398,
	["Maedin's Challenge"] = 11399,
	["The Maw"] = 11400,
	["The Dranosh'ar Blockade"] = 11401,
	["Orgrimmar"] = 11402,
	["Durotar"] = 11403,
	["The Golden Rose"] = 11404,
	["Guo-Lai Halls"] = 11405,
	["The Hall of the Serpent"] = 11406,
	["The Hall of Statues"] = 11407,
	["The Hall of Tiles"] = 11408,
	["Guo-Lai Ritual Chamber"] = 11409,
	["Guo-Lai Vault"] = 11410,
	["Temple of Humility"] = 11411,
	["The Eternal Forge"] = 11412,
	["Seat of Eternal Hymns"] = 11413,
	["Exile Overlook"] = 11414,
	["Guardian Spring"] = 11415,
	["Roiling Vortex"] = 11416,
	["MattTestTerrain"] = 11417,
	["Broken Fin Hollow"] = 11418,
	["Cinematic Test Map"] = 11419,
	["Stables"] = 11424,
	["Farm"] = 11425,
	["Lumber Mill"] = 11426,
	["Gold Mine"] = 11427,
	["The Silent Sanctuary"] = 11431,
	["The Desiccation"] = 11433,
	["Ashen Traverse"] = 11434,
	["Cinderwall"] = 11435,
	["[Vignette Space 1]"] = 11436,
	["[Vignette Space 2]"] = 11437,
	["The Scorched Crypt"] = 11438,
	["Repentance Bridge"] = 11439,
	["Grommash Hold"] = 11440,
	["Grommash Hold"] = 11441,
	["The Keggary"] = 11442,
	["The Golden Terrace"] = 11443,
	["Summer's Rest"] = 11444,
	["Path of Serenity"] = 11445,
	["Chamber of Reflection"] = 11446,
	["The Imperial Exchange"] = 11447,
	["The Star's Bazaar"] = 11448,
	["Ethereal Corridor"] = 11449,
	["The Celestial Vault"] = 11450,
	["Chamber of Enlightenment"] = 11451,
	["The Golden Lantern"] = 11452,
	["The Emperor's Step"] = 11453,
	["The Summer Terrace"] = 11454,
	["Crapopolis"] = 11455,
	["Dread Point"] = 11456,
	["Penance Bridge"] = 11457,
	["Decrepit Depository"] = 11458,
	["MattTestTerrain2"] = 11459,
	["Maldraxxus"] = 11462,
	["MalDoodadtest"] = 11463,
	["MalPestDoodadTest"] = 11464,
	["Theater of Pain"] = 11465,
	["Bleak Redoubt"] = 11466,
	["The Spearhead"] = 11467,
	["Bony Spindles"] = 11468,
	["Unfallen's Sanctum"] = 11469,
	["Ashen Gate"] = 11471,
	["Aspirant's Rest"] = 11473,
	["Chamber of First Reflection"] = 11474,
	["Blackwing Descent"] = 11475,
	["EnvArtDevMaldraxxus- Pestilence"] = 11476,
	["EnvArtMaldraxxus- Battlefield"] = 11477,
	["The Prime Reliquary"] = 11478,
	["Crapopolis"] = 11479,
	["The Mnemonic Locus"] = 11486,
	["Garden of Respite"] = 11487,
	["Firstborne's Bounty"] = 11488,
	["Agthia's Repose"] = 11489,
	["Forge of the Zephyr"] = 11490,
	["Transfer Station Ta"] = 11491,
	["Court of Elation"] = 11492,
	["Sophia's Aria"] = 11493,
	["Sophia's Overture"] = 11494,
	["Everdawn Commons"] = 11495,
	["Grace of the Remembered"] = 11498,
	["Ithys' Basin"] = 11499,
	["Sophia's Sonata"] = 11500,
	["Garden of Edenia"] = 11501,
	["Kalliope's Rest"] = 11503,
	["Sagehaven"] = 11505,
	["Steward's Rest"] = 11507,
	["SinewTestArea"] = 11508,
	["Purity's Reflection"] = 11509,
	["Ardenweald"] = 11510,
	["Heartwood Grove"] = 11511,
	["Shrouded Mire"] = 11512,
	["Spirit Glen"] = 11513,
	["Crumbled Ridge"] = 11514,
	["Tirna Vaal"] = 11515,
	["Dusty Burrows"] = 11516,
	["Tranquil Pools"] = 11517,
	["Muck Pool: Banewood"] = 11518,
	["Dreamsong Fenn"] = 11519,
	["The Stalks"] = 11520,
	["Purity's Pinnacle"] = 11521,
	["Dreadpearl Cavern"] = 11523,
	["Planes of Torment"] = 11524,
	["The Beastwarrens"] = 11525,
	["Zovaal's Cauldron"] = 11526,
	["Desmotaeron"] = 11527,
	["Gorgoa: River of Souls"] = 11528,
	["Perdition Hold"] = 11529,
	["Crucible of the Damned"] = 11530,
	["Hibernal Hollow"] = 11531,
	["Creeping Hive"] = 11532,
	["Tirna Noch"] = 11533,
	["Emerald Glade"] = 11534,
	["Path of Rebirth"] = 11535,
	["Winterax Cave"] = 11536,
	["Forgotten Wounds"] = 11537,
	["House of Rituals"] = 11538,
	["Allied - Mechagnome Unlock"] = 11539,
	["Alllied - Vulpera Unlock"] = 11540,
	["Tirna Rowen"] = 12071,
	["Dun Baldar"] = 12073,
	["Azshara"] = 12212,
	["Irondeep Mine"] = 12213,
	["Rock of Durotan"] = 12214,
	["Dun Baldar"] = 12215,
	["Icewing Pass"] = 12216,
	["Frostwolf Village"] = 12217,
	["Tower Point"] = 12218,
	["Winterax Hold"] = 12219,
	["Iceblood Garrison"] = 12220,
	["Frostwolf Keep"] = 12221,
	["Frost Dagger Pass"] = 12222,
	["Field of Strife"] = 12223,
	["Frostwolf Graveyard"] = 12224,
	["Iceblood Graveyard"] = 12225,
	["Snowfall Graveyard"] = 12226,
	["Stonehearth Graveyard"] = 12227,
	["Stormpike Graveyard"] = 12228,
	["Icewing Bunker"] = 12229,
	["Wildpaw Ridge"] = 12230,
	["Wildpaw Cavern"] = 12231,
	["Coldtooth Mine"] = 12232,
	["Dun Baldar Pass"] = 12233,
	["Stonehearth Bunker"] = 12234,
	["Stonehearth Outpost"] = 12235,
	["Nordrassil"] = 12236,
	["Icewing Cavern"] = 12239,
	["The Veiled Cleft"] = 12240,
	["Iron Trench"] = 12241,
	["Banks of Life"] = 12242,
	["The Growthworks"] = 12243,
	["Glitterfall Heights"] = 12244,
	["Glitterfall Basin"] = 12245,
	["Grove of Memory"] = 12246,
	["Gossamer Cliffs"] = 12247,
	["Keres' Rest"] = 12248,
	["Mistfall Village"] = 12462,
	["Ruins of Guo-Lai"] = 12463,
	["The Golden Stair"] = 12464,
	["Whitepetal Lake"] = 12465,
	["Sunblossom Hill"] = 12466,
	["Setting Sun Garrison"] = 12467,
	["Tu Shen Burial Ground"] = 12468,
	["Ruins Rise"] = 12469,
	["Winterbough Glade"] = 12470,
	["The Five Sisters"] = 12471,
	["Shrine of Seven Stars"] = 12472,
	["Mogu'shan Palace"] = 12473,
	["Jin Yang Road"] = 12474,
	["The Summer Fields"] = 12475,
	["Ancestral Rise"] = 12476,
	["Gate of the Setting Sun"] = 12477,
	["The Emperor's Approach"] = 12478,
	["Autumnshade Ridge"] = 12479,
	["The Golden Pagoda"] = 12480,
	["Shrine of Two Moons"] = 12481,
	["Vale of Eternal Twilight"] = 12622,
	["Vale of Eternal Twilight"] = 12623,
	["Vaal Grotto"] = 12624,
	["Vision of the Twisting Sands"] = 12765,
	["Vision of the Twisting Sands"] = 12766,
	["Obelisk of the Moon"] = 12767,
	["Maker's Ascent"] = 12768,
	["Ruins of Khintaset"] = 12769,
	["Vir'naal Oasis"] = 12770,
	["Sahket Wastes"] = 12771,
	["Temple of Uldum"] = 12772,
	["Ramkahen"] = 12773,
	["Vir'naal Lake"] = 12774,
	["House of Plagues"] = 12775,
	["Akarek's Tears"] = 12776,
	["Ossein Foundry"] = 12777,
	["The Golden Lantern"] = 12778,
	["Absolution Crypt"] = 12782,
	["House of the Chosen"] = 12783,
	["Forgefire Outpost"] = 12793,
	["Nemea's Retreat"] = 12794,
	["House of Constructs"] = 12795,
	["The Stitchyard"] = 12796,
	["Darkvein Villa"] = 12797,
	["Sourwine Estate"] = 12798,
	["Duskmire Domain"] = 12799,
	["Primrose Residence"] = 12800,
	["Redelav Hall"] = 12801,
	["Briarbane Stables"] = 12802,
	["The Golden Pasture"] = 12803,
	["Iremoore Estate"] = 12804,
	["Glutharn's Decay"] = 12805,
	["Sinfang Parlor"] = 12806,
	["Thornhill Manor"] = 12807,
	["Redelav Tower"] = 12808,
	["The Eternal Terrace"] = 12809,
	["Challenger's Promenade"] = 12810,
	["The Silent Sanctuary"] = 12811,
	["High Stand"] = 12812,
	["Separation Chamber"] = 12813,
	["Blackthorn Grove"] = 12814,
	["First Chamber of Kalliope"] = 12815,
	["Second Chamber of Kalliope"] = 12816,
	["Third Chamber of Kalliope"] = 12817,
	["Autumnal Rise"] = 12818,
	["Zerekriss"] = 12819,
	["Vortrexxis"] = 12820,
	["Exoramas"] = 12821,
	["Necropolis - Unused"] = 12822,
	["Renounced Bastille"] = 12823,
	["Mechagon City"] = 12825,
	["The Night Market"] = 12826,
	["Court of the Harvesters"] = 12827,
	["Dominance Gate"] = 12828,
	["Menagerie of the Master"] = 12829,
	["Castle Nathria"] = 12830,
	["Halls of Atonement"] = 12831,
	["Shimmerleaf Forest"] = 12832,
	["Hall of Beasts"] = 12833,
	["Silverwing Flag Room"] = 12834,
	["Warsong Flag Room"] = 12835,
	["Greatwing Roost"] = 12836,
	["Spires of Ascension"] = 12837,
	["Hall of the Stormpike"] = 12838,
	["Hall of the Frostwolf"] = 12839,
	["Star Lake Amphitheater"] = 12840,
	["Theater of Pain"] = 12841,
	["Sanguine Depths"] = 12842,
	["House of Eyes"] = 12843,
	["Shimmerbough"] = 12844,
	["Forbidden Library"] = 12845,
	["Briar Gate"] = 12846,
	["Bastion - Vignettes"] = 12847,
	["Bastion - Treasures"] = 12848,
	["Catacombs of Regret"] = 12849,
	["Jrokgar's Coast"] = 12851,
	["Shrine"] = 12852,
	["Market"] = 12853,
	["Ruins"] = 12854,
	["Farm"] = 12855,
	["Quarry"] = 12856,
	["Blackrock Depths"] = 12857,
	["Heart of the Forest"] = 12858,
	["Death's End"] = 12859,
	["Forest's Edge"] = 12860,
	["Sepulcher of Knowledge"] = 12861,
	["Digestion Chamber"] = 12871,
	["Digestion Chamber"] = 12872,
	["Seat of Ramkahen"] = 12873,
	["Elder Stand"] = 12874,
	["Dreamshrine Basin"] = 12875,
	["Seat of the Primus"] = 12876,
	["Ny'alotha"] = 12877,
	["Vision of Destiny"] = 12878,
	["Obsidian Overlook"] = 12879,
	["Annex of Prophecy"] = 12880,
	["Val'sharah"] = 12882,
	["Temple of Elune"] = 12883,
	["Garden of Night"] = 12884,
	["The Ritual Chamber"] = 12885,
	["The Hive"] = 12886,
	["Maw of Gor'ma"] = 12888,
	["Spawning Pit"] = 12889,
	["Chamber of Rebirth"] = 12890,
	["Warren of Decay"] = 12891,
	["Twilight Landing"] = 12892,
	["Terrace of Desolation"] = 12893,
	["Den of Transfusion"] = 12894,
	["N'Zoth"] = 12895,
	["Locus of Infinite Truths"] = 12896,
	["Den of the Devourer"] = 12897,
	["Butchers Block"] = 12898,
	["Blighted Scar"] = 12899,
	["Gormhive"] = 12900,
	["Etheric Vault"] = 12901,
	["Grove of Awakening"] = 12902,
	["Blackhound Outpost"] = 12903,
	["Chamber of Heart"] = 12905,
	["Wrangler Pit"] = 12906,
	["Cliffs of Respite"] = 12909,
	["Eventide Grove"] = 12910,
	["The Stabbing Wastes"] = 12911,
	["The Necrotic Wake"] = 12916,
	["Sinfall"] = 12917,
	["Tirna Glayn"] = 12918,
	["Dreamshrine Basin"] = 12919,
	["Emerald Glade"] = 12920,
	["Path of Rebirth"] = 12921,
	["Shimmerbough"] = 12922,
	["Heart of the Forest"] = 12923,
	["Ardenweald"] = 12924,
	["The Frozen Throne"] = 12951,
	["Icecrown Citadel"] = 12952,
	["Lakeshire"] = 12953,
	["Grove of Terror"] = 12954,
	["The Gilded Foyer"] = 12955,
	["The Crimson Assembly Hall"] = 12956,
	["Forgotten Passageway"] = 12957,
	["Vault of Kings Past"] = 12958,
	["Throne of Ancient Conquerors"] = 12959,
	["Bladelord's Retreat"] = 12960,
	["Shrine of Nala'shi"] = 12961,
	["The Walk of Recollection"] = 12975,
	["Tirnenn's Rest"] = 12989,
	["Gormhive Defense Wall"] = 13160,
	["Claw's Edge"] = 13161,
	["The Vortex Pinnacle"] = 13176,
	["Throne of the Four Winds"] = 13177,
	["Maldraxxus"] = 13178,
	["Bleak Redoubt"] = 13179,
	["The Spearhead"] = 13180,
	["Unfallen's Sanctum"] = 13181,
	["Iron Trench"] = 13182,
	["The Stabbing Wastes"] = 13183,
	["Ossein Foundry"] = 13184,
	["House of the Chosen"] = 13185,
	["Challenger's Promenade"] = 13186,
	["Seat of the Primus"] = 13187,
	["Butchers Block"] = 13188,
	["House of Plagues"] = 13189,
	["Theater of Pain"] = 13190,
	["Blighted Scar"] = 13191,
	["Rotting Mound"] = 13192,
	["Windshorn Expanse"] = 13193,
	["The Umbral Forests"] = 13195,
	["Calcis"] = 13196,
	["Kaithe Overlook"] = 13197,
	["Seat of Knowledge"] = 13198,
	["Netherhollow"] = 13209,
	["Hive Mother's Grotto"] = 13211,
	["Big Blossom Mine"] = 13212,
	["Ruined Passage"] = 13213,
	["Maw Entrance Area"] = 13214,
	["Cocyrus"] = 13215,
	["The Tremaculum"] = 13216,
	["Ruin's Cradle"] = 13217,
	["Marrow's Coppice"] = 13218,
	["Prodigum"] = 13219,
	["Penderghast"] = 13220,
	["Ravener's Lament"] = 13221,
	["Face of Oblivion"] = 13222,
	["Altar of Domination"] = 13223,
	["Castle Nathria"] = 13224,
	["The Fearstalker's Lodge"] = 13226,
	["Serpent's Spine"] = 13227,
	["Plaguefall"] = 13228,
	["Bastion"] = 13229,
	["Felscar Breach"] = 13230,
	["Root-Home"] = 13231,
	["Pit of Anguish"] = 13233,
	["The Blade Crypt"] = 13235,
	["Scaplian Ridge"] = 13236,
	["Starlit Overlook"] = 13237,
	["Prime Siegeworks"] = 13238,
	["Ragebringer Terrace"] = 13239,
	["Unyielding Assembly"] = 13240,
	["Plague Watch"] = 13305,
	["Burning Thicket"] = 13306,
	["Chamber of Inner Calm"] = 13307,
	["Castle Nathria (Scenario)"] = 13308,
	["De Other Side"] = 13309,
	["Court of Elation"] = 13310,
	["Citadel of Loyalty"] = 13311,
	["Maldrxxus Covenant Finale Scenario"] = 13312,
	["Maldraxxus"] = 13313,
	["Bony Spindles"] = 13314,
	["Forgotten Wounds"] = 13315,
	["House of Rituals"] = 13316,
	["Keres' Rest"] = 13317,
	["Scaplian Ridge"] = 13318,
	["Glutharn's Decay"] = 13319,
	["Challenger's Promenade"] = 13320,
	["High Stand"] = 13321,
	["Renounced Bastille"] = 13322,
	["House of Eyes"] = 13323,
	["Rotting Mound"] = 13324,
	["Theater of Pain"] = 13325,
	["Akarek's Tears"] = 13326,
	["Darkreach"] = 13328,
	["The Ember Court"] = 13329,
	["Hall of Chains"] = 13330,
	["Shimmering Pools"] = 13331,
	["The Maw"] = 13332,
	["Spider's Watch"] = 13333,
	["Mists of Tirna Scithe"] = 13334,
	["Zolramus"] = 13337,
	["Hole in the Wall"] = 13338,
	["Renard's Den"] = 13339,
	["Nurakkir"] = 13340,
	["Toxxulanar"] = 13342,
	["Not Doug Land"] = 13343,
	["Forlorn Respite"] = 13344,
	["Body Banks"] = 13346,
	["Thread House"] = 13347,
	["Amputory"] = 13348,
	["Crucible of the Damned"] = 13350,
	["Gorgoa: River of Souls"] = 13351,
	["Calcis"] = 13352,
	["Maw Entrance Area"] = 13353,
	["Cocyrus"] = 13354,
	["The Tremaculum"] = 13355,
	["Ruin's Cradle"] = 13356,
	["Planes of Torment"] = 13357,
	["Zovaal's Cauldron"] = 13358,
	["Blistering Bog"] = 13363,
	["Hidden Glade"] = 13364,
	["Furrowed Glen"] = 13365,
	["Shattered Grove"] = 13366,
	["Queen's Conservatory"] = 13367,
	["Mad Duke's Parlor"] = 13368,
	["Elysian Hold"] = 13369,
	["Exaltation Rise"] = 13370,
	["Desolate Hollow"] = 13373,
	["Theater of Pain"] = 13374,
	["Fungal Terminus"] = 13375,
	["Gleaming Overlook"] = 13376,
	["The North Sea"] = 13377,
	["The Ring"] = 13385,
	["Ardenweald"] = 13387,
	["Heart of the Forest"] = 13388,
	["Stillglade"] = 13389,
	["Vault of Memory"] = 13390,
	["Vault of the Archon"] = 13391,
	["Shattered Span"] = 13392,
	["The Necrotic Wake"] = 13393,
	["Tirna Scithe"] = 13395,
	["Mistveil Tangle"] = 13396,
	["Oaken Assembly"] = 13397,
	["Forgotten Chamber"] = 13398,
	["Xandria's Vigil"] = 13399,
	["Skoldus Hall"] = 13400,
	["The Spike"] = 13402,
	["The Fracture Chambers"] = 13403,
	["The Soulforges"] = 13404,
	["Detrithos"] = 13405,
	["Valley of a Thousand Legs"] = 13406,
	["Dusky Grotto"] = 13407,
	["The Resting Hole"] = 13408,
	["Progenitor Zone Area 1"] = 13409,
	["Underweald"] = 13410,
	["Coldheart Interstitia"] = 13411,
	["Mort'regar"] = 13412,
	["The Upper Reaches"] = 13413,
	["The Sinposium"] = 13414,
	["Aspirant's Awakening"] = 13415,
	["DEV Lowlands (DO NOT USE)"] = 13416,
	["Sightless Hold"] = 13417,
	["The Master's Keep"] = 13418,
	["Forge of Pestilence"] = 13421,
	["The Broken Tower"] = 13422,
	["Bubbling Wastes"] = 13423,
	["Virulent Mire"] = 13424,
	["Oozing Fields"] = 13425,
	["The Festering Sanctum"] = 13426,
	["Putrefied Forest"] = 13427,
	["Empyrean Domain"] = 13428,
	["Oaken Assembly"] = 13429,
	["Mistveil Tangle"] = 13430,
	["Tirna Scithe"] = 13431,
	["Forlorn Respite"] = 13432,
	["The In-Between"] = 13433,
	["The Observatorium"] = 13434,
	["Nightcloak Sanctum"] = 13435,
	["Ve'nari's Refuge"] = 13437,
	["Chambers of Misery"] = 13438,
	["Coldheart Halls"] = 13439,
	["Pit of Anguish"] = 13440,
	["Stygian Abyss"] = 13441,
	["Cinderwall Spire"] = 13442,
	["Flesh Stitchery"] = 13443,
	["Soryn's Meadow"] = 13455,
	["Haetio's Solace"] = 13456,
	["The Jagged Coast"] = 13457,
	["Alluvium Hollow"] = 13459,
	["The Forgotten Forge"] = 13460,
	["Fate's Precipice"] = 13461,
	["Ascension Coliseum"] = 13462,
	["Molten Forge"] = 13463,
	["The Abandoned Purlieu"] = 13468,
	["Map 2437 [DEV AREA]"] = 13469,
	["Terrace of Inner Grace"] = 13470,
	["The Grim Harvest"] = 13471,
	["The Final Toll"] = 13472,
	["Fall of Courage"] = 13473,
	["Trench of the Enders"] = 13474,
	["Bridge of Contrition"] = 13475,
	["The Maw"] = 13476,
	["The Defiled Altar"] = 13477,
	["Death's Roar"] = 13478,
	["Desolate Hollow"] = 13479,
	["The Forgotten Retreat"] = 13480,
	["The Distant Grotto"] = 13481,
	["The Faraway Pools"] = 13482,
	["Arkelios' Solace"] = 13483,
	["Kala's Den"] = 13485,
	["The Reagentry"] = 13486,
	["The Grimoirium"] = 13487,
	["Hall of Tomes"] = 13488,
	["Hall of Elixirs"] = 13489,
	["Hall of Sorcery"] = 13490,
	["Hungering Wastes"] = 13491,
	["Soulstained Fields"] = 13492,
	["Prime Arcanum"] = 13493,
	["Level Design [DEV MAP]"] = 13494,
	["MattTestTerrain3"] = 13495,
	["Chill's Reach"] = 13496,
	["The Fracture Chambers"] = 13497,
	["Ring of Transference"] = 13498,
	["Ring of Fates"] = 13499,
	["Vigil of the Endless"] = 13500,
	["Shrine of the Silver Wind"] = 13501,
	["Zolramus"] = 13503,
	["Exoramas"] = 13505,
	["awood_dev1"] = 13506,
	["sbenyona_dev1"] = 13507,
	["Miri's Chapel"] = 13508,
	["Honor's Ascent"] = 13510,
	["Gardens of Repose"] = 13511,
	["The Resplendent Gardens"] = 13512,
	["Atrium of Piety"] = 13513,
	["Secluded Auritory"] = 13514,
	["Font of Fealty"] = 13515,
	["Seat of the Archon"] = 13516,
	["Wanecrypt Hill"] = 13517,
	["The Sorcerous Steps"] = 13518,
	["Interactive World - Sparkles"] = 13519,
	["Interactive World - Containers"] = 13520,
	["Path of Wisdom"] = 13521,
	["The Runecarver's Oubliette"] = 13522,
	["Sinfall"] = 13523,
	["Hall of Blades"] = 13524,
	["Hall of Cantrips"] = 13525,
	["Hall of Ichor"] = 13526,
	["Vault of Souls"] = 13527,
	["Mother's Den"] = 13528,
	["Echoing Caverns"] = 13529,
	["Death's Howl"] = 13530,
	["Torturer's Hovel"] = 13531,
	["Zone2lDoodadtest"] = 13532,
	["Spire of War"] = 13533,
	["Zereth Mortis"] = 13536,
	["Dawnkeep"] = 13537,
	["Extractor's Sanatorium"] = 13538,
	["Acherus: The Ebon Hold"] = 13539,
	["Stanikos's Hollow"] = 13540,
	["Veiled Enclave"] = 13541,
	["Woeful Cavern"] = 13542,
	["Highland Path"] = 13543,
	["Exoramas"] = 13545,
	["Torghast, Tower of the Damned"] = 13546,
	["The Runecarver's Oubliette"] = 13547,
	["Boralus Harbor"] = 13548,
	["Stormheim"] = 13549,
	["Redridge Mountains"] = 13550,
	["Extractor's Sanatorium"] = 13552,
	["Escape from the Maw"] = 13553,
	["10 Canyon"] = 13554,
	["Sixfold Recluse"] = 13555,
	["Revendreth"] = 13556,
	["Detrithos"] = 13560,
	["Sanctum of Domination"] = 13561,
	["Terrace of the Collectors"] = 13567,
	["Wrath of the Jailer"] = 13569,
	["Korthia"] = 13570,
	["The Sepulcher of the First Ones"] = 13573,
	["PTH Test Area"] = 13574,
	["The Adamant Vaults"] = 13575,
	["Zone2lDoodadtest2"] = 13576,
	["Tazavesh, the Veiled Market"] = 13577,
	["Volo's Homestead"] = 13578,
	["Interactive World - Rain Test"] = 13579,
	["Fungal Wasteland"] = 13580,
	["Overgrown Canopy"] = 13581,
	["Edge of Darkness"] = 13582,
	["Lug'thun's Crater"] = 13583,
	["Interactive World - Night Test"] = 13585,
	["The Maw"] = 13587,
	["Planes of Torment"] = 13588,
	["The Beastwarrens"] = 13589,
	["Zovaal's Cauldron"] = 13595,
	["Desmotaeron"] = 13596,
	["Gorgoa: River of Souls"] = 13597,
	["Perdition Hold"] = 13598,
	["Crucible of the Damned"] = 13599,
	["Calcis"] = 13600,
	["Cocyrus"] = 13601,
	["Ruin's Cradle"] = 13602,
	["Marrow's Coppice"] = 13603,
	["Prodigum"] = 13604,
	["Ravener's Lament"] = 13605,
	["Face of Oblivion"] = 13606,
	["Altar of Domination"] = 13607,
	["Ve'nari's Refuge"] = 13608,
	["Hungering Wastes"] = 13609,
	["Soulstained Fields"] = 13610,
	["Detrithos"] = 13611,
	["Felspinner Nest"] = 13612,
	["10.0 Hackathon: Living World"] = 13613,
	["Ardenweald"] = 13619,
	["Sanctuary of Guidance"] = 13624,
	["Keeper's Respite"] = 13625,
	["Mauler's Outlook"] = 13626,
	["Scholar's Den"] = 13627,
	["Seeker's Quorum"] = 13628,
	["Windswept Aerie"] = 13629,
	["Hope's Ascent"] = 13630,
	["Vault of Secrets"] = 13631,
	["Haven"] = 13632,
	["9.1 Campaign"] = 13633,
	["The Tremaculum"] = 13634,
	["Zone4TyrholdTest"] = 13635,
	["10 Highlands"] = 13636,
	["Skyhold"] = 13637,
	["Stormheim"] = 13641,
	["Dragon Isles"] = 13642,
	["The Great Sea"] = 13643,
	["The Waking Shores"] = 13644,
	["Ohn'ahran Plains"] = 13645,
	["The Azure Span"] = 13646,
	["Thaldraszus"] = 13647,
	["Tormentors of Torghast"] = 13648,
	["Andorhal"] = 13650,
	["Reliquary of Remembrance"] = 13652,
	["Pinnacle of Domination"] = 13653,
	["Edge of the Abyss"] = 13654,
	["The Crucible"] = 13655,
	["Cave of Secrets"] = 13656,
	["Circle of Glory"] = 13657,
	["Pilgrim's Grace"] = 13658,
	["Resonant Peaks"] = 13659,
	["Cavern of Contemplation"] = 13660,
	["The Runecarver's Oubliette"] = 13664,
	["Helgarde Keep"] = 13666,
	["Crest of Clarity"] = 13667,
	["Emerald Gardens"] = 13669,
	["Chamber of the Sigil"] = 13671,
	["Tazavesh, the Veiled Market"] = 13672,
	["Estuary of Awakening"] = 13673,
	["Zerekriss"] = 13674,
	["The Path of Understanding"] = 13677,
	["Ta Repository"] = 13680,
	["Extractor's Sanatorium"] = 13681,
	["Desolate Hollow"] = 13682,
	["Cradle of Nascence"] = 13683,
	["Forlorn Respite"] = 13684,
	["Woeful Cavern"] = 13685,
	["Death's Roar"] = 13686,
	["Death's Howl"] = 13687,
	["Mother's Den"] = 13688,
	["Torturer's Hovel"] = 13689,
	["Faith's Repose"] = 13690,
	["Chamber of Knowledge"] = 13691,
	["Chamber of Wisdom"] = 13692,
	["Exile's Hollow"] = 13694,
	["The Rift"] = 13695,
	["The Chained Precipice"] = 13697,
	["Seat of the Archon"] = 13699,
	["Gromit Hollow"] = 13700,
	["Font of Fealty"] = 13701,
	["Untamed Verdure"] = 13702,
	["Restless Wetlands"] = 13703,
	["Scalecracker Keep"] = 13704,
	["Provis Esper"] = 13705,
	["Provis Fauna"] = 13706,
	["Site Ka'a"] = 13707,
	["Plain of Actualization"] = 13708,
	["Life-Binder Conservatory"] = 13709,
	["Uktulut Backwater"] = 13710,
	["Concord Observatory"] = 13711,
	["The Lost Path"] = 13713,
	["Flayscale Camp"] = 13714,
	["Overflowing Rapids"] = 13715,
	["The Overflowing Spring"] = 13716,
	["Obsidian Citadel"] = 13717,
	["Hudson's Rock"] = 13718,
	["Burning Ascent"] = 13719,
	["Dragonbane Keep"] = 13720,
	["Scalecracker Peaks"] = 13721,
	["Wild Coast"] = 13722,
	["Dragonheart Outpost"] = 13723,
	["Skytop Observatory"] = 13724,
	["Life Vault Ruins"] = 13725,
	["Hornswog Hollow"] = 13726,
	["Ruby Lifeshrine"] = 13727,
	["Ruby Life Pools"] = 13728,
	["Crumbling Life Archway"] = 13729,
	["Flashfrost Enclave"] = 13730,
	["Hatchery Observatory"] = 13731,
	["Dragonscale Basecamp"] = 13732,
	["Wild Preserve"] = 13733,
	["Apex Canopy"] = 13734,
	["Lev'al Rock Isle"] = 13735,
	["Apex Observatory"] = 13736,
	["Obsidian Observatory"] = 13738,
	["Obsidian Bulwark"] = 13739,
	["Rockfang Ravine"] = 13741,
	["Sepulcher of the First Ones"] = 13742,
	["Timberstep Outpost"] = 13743,
	["Choral Residium"] = 13744,
	["Mirewood Fen"] = 13745,
	["Horn of Drusahl"] = 13746,
	["Aylaag Outpost"] = 13747,
	["Reedwhistle Bay"] = 13748,
	["Mudfin Village"] = 13749,
	["Rusza'thar Reach"] = 13750,
	["Shikaar Highlands"] = 13751,
	["Storm Drake Roost"] = 13752,
	["Crypts of the Eternal"] = 13753,
	["The Carving Winds"] = 13754,
	["Forkriver Crossing"] = 13755,
	["The Dread Portal"] = 13756,
	["Endless Sands"] = 13757,
	["Arrangement Index"] = 13758,
	["Deserted Overlook"] = 13759,
	["Windsong Rise"] = 13761,
	["Sylvan Glade"] = 13762,
	["Cloverwood Hollow"] = 13763,
	["Maruukai"] = 13764,
	["Ohn'ahra's Roost"] = 13765,
	["Nelthazan Ruins"] = 13766,
	["Emberwatch"] = 13767,
	["The Slumbering Vault"] = 13768,
	["The Forbidden Reach"] = 13769,
	["Field of Ferocity"] = 13770,
	["Daruukhan"] = 13771,
	["Broadhoof Outpost"] = 13772,
	["Kaighan Camp"] = 13774,
	["Ohn'iri Springs"] = 13775,
	["Ohn'ir Geysers"] = 13776,
	["Ridgewater Retreat"] = 13777,
	["Mirror of the Sky"] = 13778,
	["Szar Skeleth"] = 13779,
	["Teerakai"] = 13780,
	["The Eternal Kurgans"] = 13781,
	["Nokhudon Hold"] = 13782,
	["Zovaal's Grasp"] = 13787,
	["Terrace of Formation"] = 13788,
	["zsewell"] = 13790,
	["Catalyst Gardens"] = 13791,
	["Geometric Cavern"] = 13793,
	["Veiled Ossuary"] = 13794,
	["Algeth'ar Academy"] = 13795,
	["Algeth'era Court"] = 13796,
	["Eclipse Lake"] = 13797,
	["Drake Grotto"] = 13798,
	["Chittering Caverns"] = 13799,
	["Fetid Encampment"] = 13800,
	["Tyrhold"] = 13801,
	["Tyrhold Reservoir"] = 13802,
	["Gelikyr Overlook"] = 13803,
	["Thunderspine Thicket"] = 13804,
	["Lexical Glade"] = 13805,
	["The War Creche"] = 13806,
	["The Old Weyrn Grounds"] = 13807,
	["Stormsunder Crater"] = 13808,
	["Caldera of the Menders"] = 13809,
	["Froststone Vault"] = 13810,
	["Aerie Chasm"] = 13811,
	["Gardens of Unity"] = 13812,
	["South Hold Gate"] = 13813,
	["Garden Shrine"] = 13814,
	["Misty Vale"] = 13815,
	["Stormshroud Peak"] = 13816,
	["Shifting Sands"] = 13817,
	["Temporal Conflux"] = 13818,
	["DefunctThaldraszusarea"] = 13819,
	["Eon's Fringe"] = 13820,
	["Sand-Lost Sanctum"] = 13821,
	["The Flowing Forest"] = 13822,
	["Passage of Time"] = 13823,
	["Azure Archives"] = 13825,
	["Kauriq Gleamlet"] = 13826,
	["Pleasant Hill"] = 13827,
	["Imbu"] = 13828,
	["Timbertooth Trail"] = 13829,
	["Rockhide Village"] = 13830,
	["Rustpine Den"] = 13831,
	["Shiverweb Vale"] = 13833,
	["Camp Antonidas"] = 13834,
	["Cobalt Assembly"] = 13835,
	["Slyvern Plunge"] = 13836,
	["Iskaara"] = 13837,
	["Gorloc Shore"] = 13838,
	["Chamber of Shaping"] = 13839,
	["Protoform Repository"] = 13840,
	["Path of Inception"] = 13841,
	["Genesis Vestibule"] = 13842,
	["Big Tree Hills"] = 13843,
	["Traitor's Rest"] = 13844,
	["Djardin Cliff Camp"] = 13845,
	["Drake Hatchery"] = 13846,
	["Brackenhide Hollow"] = 13847,
	["Brackenhide Waterhole"] = 13848,
	["Kalthraz Fortress"] = 13849,
	["Darktooth Pond"] = 13850,
	["Cobalt Library"] = 13851,
	["Creektooth Den"] = 13852,
	["Vakthros Range"] = 13853,
	["Primalist POI"] = 13854,
	["Primalist POI 2"] = 13855,
	["Frost Giant Cliffs"] = 13856,
	["Winterpelt Hollow"] = 13857,
	["Misty Canyon"] = 13858,
	["Camp Nowhere"] = 13859,
	["Upper Frostlands"] = 13860,
	["Bluefeather Cliffs"] = 13861,
	["Valdrakken"] = 13862,
	["Oribos"] = 13863,
	["Gelikyr Post"] = 13864,
	["East Shrine"] = 13865,
	["Shadow Pass"] = 13866,
	["Rebellious Cliffs"] = 13867,
	["Serene Dreams Spa"] = 13868,
	["The Great Veldt"] = 13869,
	["mesten_dev1"] = 13870,
	["Provis Strata"] = 13871,
	["Talonlords' Perch"] = 13872,
	["Steelcliff Passage"] = 13873,
	["Scaleborn Pass"] = 13874,
	["Shadow Ledge"] = 13875,
	["The Cascades"] = 13876,
	["Steelcliff Rampart"] = 13877,
	["Aqueduct Basin"] = 13878,
	["The Petitioner's Concourse"] = 13879,
	["Wild Cliffs"] = 13881,
	["Provis Flora"] = 13882,
	["Provis Terra"] = 13883,
	["Temporal Overlook"] = 13884,
	["Tuskarr Ice Elemental Cave"] = 13885,
	["Whaler's Nook"] = 13886,
	["Tower of Iskhdormi"] = 13887,
	["Three-Falls Lookout"] = 13888,
	["Ruins of Karnthar"] = 13889,
	["Terrestial Cache"] = 13890,
	["Gravid Repose"] = 13891,
	["Grimtusk's Hideaway"] = 13892,
	["Drake Eye's Pond"] = 13893,
	["Scalewatch Caverns"] = 13894,
	["Theron's Watch"] = 13895,
	["Antecedent Isle"] = 13896,
	["Dimensional Falls"] = 13897,
	["Catalyst Wards"] = 13898,
	["Primordial Vale"] = 13918,
	["Ancient Bough"] = 13921,
	["Roaring Dragonsprings"] = 13922,
	["Brackenhide Brambles"] = 13923,
	["Forge of Afterlives"] = 13924,
	["Ageless Shards"] = 13925,
	["Droning Precipice"] = 13927,
	["Blooming Foundry"] = 13928,
	["Zelthrak Outpost"] = 13931,
	["Snowhide Camp"] = 13932,
	["Kargpaw's Den"] = 13933,
	["Rhonin's Shield"] = 13934,
	["Circle of Thought"] = 13935,
	["Marie Lazar Land"] = 13936,
	["Fissured Breach"] = 13938,
	["Wingrest Embassy"] = 13939,
	["Wild Hatchery"] = 13940,
	["Obsidian Throne"] = 13941,
	["Rubyscale Outpost"] = 13942,
	["Crumbling Cliffs"] = 13943,
	["Flashfrost Assault"] = 13944,
	["Marie Lazar Land Panda Farm"] = 13946,
	["Genesis Fields"] = 13948,
	["Garudeon's Nest"] = 13949,
	["Felicitous Glade"] = 13950,
	["Locrian Esper"] = 13952,
	["The Azure Vault"] = 13954,
	["LDNewHire"] = 13955,
	["Eternal Watch"] = 13956,
	["Immortal Hearth"] = 13957,
	["Genesis Cradle"] = 13958,
	["The Endless Foundry"] = 13959,
	["Keeper's Bastion"] = 13960,
	["Ephemeral Plains"] = 13961,
	["Devouring Pit"] = 13962,
	["Broker's Sting"] = 13963,
	["Shimmering Cliffs"] = 13964,
	["Domination's Grasp"] = 13965,
	["Genesis Repository"] = 13966,
	["Genesis Alcove"] = 13967,
	["Uldaman"] = 13968,
	["The Grand Design"] = 13969,
	["Enigma Arena"] = 13970,
	["Maldraxxus Coliseum"] = 13971,
	["Maldraxxus Coliseum"] = 13972,
	["Tirisfal Glades"] = 13975,
	["Smoldering Perch"] = 13976,
	["Lost Grotto"] = 13977,
	["Lair of the Scythid"] = 13978,
	["Ruins of Lordaeron"] = 13979,
	["Brill"] = 13980,
	["Brightwater Lake"] = 13981,
	["Ohn'ahran Plains"] = 13982,
	["Tirisfal Glades"] = 13983,
	["Garren's Haunt"] = 13984,
	["The North Coast"] = 13985,
	["Cold Hearth Manor"] = 13986,
	["Stillwater Pond"] = 13987,
	["Calston Estate"] = 13988,
	["Death's Watch Waystation"] = 13989,
	["Brill Inn"] = 13990,
	["Brackenhide Hollow"] = 13991,
	["The Primalist Future"] = 13992,
	["The Gnoll War"] = 13993,
	["War of the Shifting Sands"] = 13994,
	["Pandaren Revolution"] = 13995,
	["The Black Empire"] = 13996,
	["Creektooth Den - Decayve"] = 13997,
	["Brackenhide Outskirts"] = 13998,
	["The Siege Creche"] = 13999,
	["The Support Creche"] = 14000,
	["Burrow of the Faithful"] = 14001,
	["Stormsunder Overlook"] = 14002,
	["Darksand Hollow"] = 14003,
	["Hoard of Shimmermaw"] = 14004,
	["Burning Ascent [DNT]"] = 14006,
	["Obsidian Citadel"] = 14007,
	["The Waking Shores [DNT]"] = 14009,
	["Shady Sanctuary"] = 14010,
	["Neltharus"] = 14011,
	["The Slagmire"] = 14012,
	["Emberflow"] = 14013,
	["Content Playground"] = 14014,
	["Vakthros Summit"] = 14017,
	["Leafy Repose"] = 14018,
	["Merithra's Watch"] = 14019,
	["Lunedane"] = 14020,
	["JoshTest"] = 14023,
	["Vault of the Incarnates"] = 14030,
	["Emberslate Cavern"] = 14031,
	["Algeth'ar Academy"] = 14032,
	["The Quad"] = 14033,
	["Terrace of Lectures"] = 14034,
	["The Pitch"] = 14035,
	["The Headteacher's Enclave"] = 14036,
	["The Botanica"] = 14037,
	["Khuri's Fishing Spot"] = 14039,
	["Cindershard Seam"] = 14040,
	["Hornspike Nest"] = 14042,
	["Tirisfal Glades"] = 14045,
	["Tirisfal Glades"] = 14046,
	["Shattered Vaults"] = 14047,
	["Stonefray Falls"] = 14050,
	["The Nokhud Approach"] = 14054,
	["Tempest Coast"] = 14056,
	["Ruby Life Pools"] = 14063,
	["Gelikyr Gardens"] = 14064,
	["Melting Knoll"] = 14065,
	["The Lost Atheneum"] = 14071,
	["Hopper Hills"] = 14075,
	["Lilac Ramble"] = 14079,
	["House of Plagues"] = 14081,
	["Halls of Infusion"] = 14082,
	["Enigma Crucible"] = 14083,
	["Genesis Falls"] = 14085,
	["Ashscale Halls"] = 14086,
	["Ashscale HallsS"] = 14087,
	["Cliffdrip Camp"] = 14088,
	["Vakthros"] = 14089,
	["Vakthros Cavern"] = 14091,
	["Azmerloth"] = 14092,
	["[PH] Epoch's Rest"] = 14093,
	["Wanderer's Steppe"] = 14094,
	["Vault of the Incarnates"] = 14095,
	["Little Scales Daycare"] = 14096,
	["Sundapple Copse"] = 14097,
	["Azmerloth - Timeless Area"] = 14098,
	["Quaking Cavern"] = 14099,
	["Clearwater Basin"] = 14100,
	["Sagecrest Pines"] = 14101,
	["Lost Ruins"] = 14103,
	["Toghusuq Village"] = 14104,
	["The Storm Scar"] = 14105,
	["Erupting Cavern"] = 14106,
	["Conservatory Outpost"] = 14107,
	["Wild Feeding Pits"] = 14142,
	["The Dig"] = 14143,
	["Hall of the Keepers"] = 14144,
	["The Earthworks"] = 14145,
	["The Vault of Tyr"] = 14146,
	["Pinewood Post"] = 14147,
	["Out of Temporal Bounds"] = 14148,
	["Pandaren Revolution - No Man's Land"] = 14149,
	["Dragonskull Island"] = 14150,
	["The Gnoll War- No Man's Land"] = 14151,
	["War of the Shifting Sands - No Man's Land"] = 14152,
	["Stormsunder Mountain"] = 14153,
	["Sharpscale Coast"] = 14154,
	["Morqut Islet"] = 14155,
	["Hornswog Grounds"] = 14156,
	["[PH] Chamber of Flames"] = 14157,
	["Hissing Grotto"] = 14158,
	["Creektooth Den"] = 14159,
	["Flayscale Cavern"] = 14160,
	["Uktulut Pier"] = 14346,
	["Mountainview Post"] = 14347,
	["Fluttering Cavern"] = 14348,
	["Dragonsprings Summit"] = 14349,
	["Life-Binder Observatory"] = 14350,
	["The Watering Hole"] = 14355,
	["The Mallakh"] = 14356,
	["The Filled Bowl"] = 14429,
	["Mage's Rest"] = 14430,
	["Mulsted's Marquee"] = 14431,
	["The Missing Hinge Inn"] = 14432,
	["The Forbidden Reach"] = 14433,
	["The Conjured Biscuit Inn"] = 14434,
	["Nokhudon Proving Grounds"] = 14436,
	["Training Grounds"] = 14437,
	["Khadin's Cave"] = 14438,
	["The Dragon's Hoard"] = 14440,
	["The Burning Cauldron"] = 14441,
	["Lost Kanniak"] = 14442,
	["Gutshot's Overlook"] = 14443,
	["The Rotwood"] = 14444,
	["Den of Decay"] = 14445,
	["Deadsnare Caverns"] = 14447,
	["Ruby Lifeshrine"] = 14448,
	["Flashfrost Incursion"] = 14449,
	["Infusion Chambers"] = 14450,
	["Ruby Overlook"] = 14451,
	["Greenscale Inn"] = 14452,
	["Temporal Conflux"] = 14454,
	["Forge of Arcanum"] = 14455,
	["Kilpi Isle"] = 14456,
	["Sully Test Start"] = 14457,
	["Longclaw Island"] = 14458,
	["Sully Test Plains"] = 14459,
	["Sully Test Desert"] = 14460,
	["Sully Test Forest"] = 14461,
	["Thunderspine Ridge"] = 14462,
	["Eaglewatch Outpost"] = 14463,
	["Lonely Falls"] = 14464,
	["Slyvern Ice Cave"] = 14465,
	["Outcast's Alcove"] = 14466,
	["Lair of Stoneheart"] = 14467,
	["The Mane Squeeze"] = 14468,
	["Rhuzast's Roost"] = 14475,
	["Maruukai"] = 14476,
	["The Eternal Kurgans"] = 14477,
	["Nokhudon Hold"] = 14478,
	["The Nokhud Approach"] = 14479,
	["The Nokhud Offensive"] = 14480,
	["Battle of Spears"] = 14481,
	["Ohn'iri Springs"] = 14482,
	["Ohn'ahran Plains"] = 14485,
	["Forgotten Cavern"] = 14486,
	["Ancient Outlook"] = 14487,
	["Algeth'ar Tower"] = 14488,
	["The Seat of the Aspects"] = 14489,
	["The Victorious Visage"] = 14490,
	["The Late Night Lab"] = 14491,
	["The Black Market"] = 14492,
	["Azure Archives Annex"] = 14493,
	["Fallingwater Overlook"] = 14494,
	["The High Creche"] = 14495,
	["Cascade's Edge"] = 14497,
	["The Ruby Feast"] = 14498,
	["Gladiator's Refuge"] = 14499,
	["Misty Canyon Overlook"] = 14500,
	["The Bubble Bath"] = 14501,
	["The Parting Glass"] = 14502,
	["The Sapphire Enclave"] = 14504,
	["The Ruby Enclave"] = 14505,
	["The Obsidian Enclave"] = 14506,
	["The Bronze Enclave"] = 14507,
	["The Emerald Enclave"] = 14508,
	["The Artisan's Market"] = 14509,
	["The Great Sea"] = 14510,
	["Wingrest Bay"] = 14511,
	["The Rugged Dragonscale"] = 14513,
	["Ley Pools"] = 14515,
	["Lost Canal"] = 14516,
	["Uktulut Outpost"] = 14524,
	["Valdrakken Treasury Hoard"] = 14530,
	["The Seat of the Aspects"] = 14617,
	["Azure Vault (delete me)"] = 14618,
}
private.MapData = MapData
