if not WeakAuras.IsLibsOK() then return end
---@type string
local AddonName = ...
---@class Private
local Private = select(2, ...)

---@class WeakAuras
local WeakAuras = WeakAuras;
local L = WeakAuras.L;

local encounter_list = ""
function Private.InitializeEncounterAndZoneLists()
  if encounter_list ~= "" then
    return
  end
  local raids = {
    {
      L["Vault of Archavon"],
      {
        { L["Archavon the Stone Watcher"], 772 },
        { L["Emalon the Storm Watcher"], 774 },
        { L["Koralon the Flame Watcher"], 776 },
        { L["Toravon the Ice Watcher"], 885 },
      }
    },
    {
      L["Naxxramas"],
      {
        -- The Arachnid Quarter
        { L["Anub'Rekhan"], 1107 },
        { L["Grand Widow Faerlina"], 1110 },
        { L["Maexxna"], 1116 },
        -- The Plague Quarter
        { L["Noth the Plaguebringer"], 1117 },
        { L["Heigan the Unclean"], 1112 },
        { L["Loatheb"], 1115 },
        -- The Military Quarter
        { L["Instructor Razuvious"], 1113 },
        { L["Gothik the Harvester"], 1109 },
        { L["The Four Horsemen"], 1121 },
        -- The Construct Quarter
        { L["Patchwerk"], 1118 },
        { L["Grobbulus"], 1111 },
        { L["Gluth"], 1108 },
        { L["Thaddius"], 1120 },
        -- Frostwyrm Lair
        { L["Sapphiron"], 1119 },
        { L["Kel'Thuzad"], 1114 }
      }
    },
    {
      L["The Obsidian Sanctum"],
      {
        { L["Tenebron"], 736 },
        { L["Shadron"], 738 },
        { L["Vesperon"], 740 },
        { L["Sartharion"], 742 },
      }
    },
    {
      L["The Eye of Eternity"],
      {
        { L["Malygos"], 734 },
      }
    },
    {
      L["Ulduar"],
      {
        -- The Siege of Ulduar
        { L["Flame Leviathan"], 744 },
        { L["Ignis the Furnace Master"], 745 },
        { L["Razorscale"], 746 },
        { L["XT-002 Deconstructor"], 747 },
        -- The Antechamber of Ulduar
        { L["Assembly of Iron"], 748 },
        { L["Kologarn"], 749 },
        { L["Auriaya"], 750 },
        -- The Keepers of Ulduar
        { L["Freya"], 753 },
        { L["Hodir"], 751 },
        { L["Mimiron"], 754 },
        { L["Thorim"], 752 },
        -- The Descent into Madness
        { L["General Vezax"], 755 },
        { L["Yogg-Saron"], 756 },
        -- Celestial Planetarium
        { L["Algalon the Observer"], 757 },
      }
    },
    {
      L["Trial of the Crusader"],
      {
        { L["Northrend Beasts"], 629 },
        { L["Lord Jaraxxus"], 633 },
        { L["Faction Champions"], 637 },
        { L["Val'kyr Twins"], 641 },
        { L["Anub'arak"], 645 },
      }
    },
    {
      L["Onyxia's Lair"],
      {
        { L["Onyxia"], 1084 },
      }
    },
    {
      L["Icecrown Citadel"],
      {
        -- The Lower Spire
        { L["Lord Marrowgar"], 845 },
        { L["Lady Deathwhisper"], 846 },
        { L["Gunship Battle"], 847 },
        { L["Deathbringer Saurfang"], 848 },
        -- The Plagueworks
        { L["Festergut"], 849 },
        { L["Rotface"], 850 },
        { L["Professor Putricide"], 851 },
        -- The Crimson Hall
        { L["Blood Prince Council"], 852 },
        { L["Blood-Queen Lana'thel"], 853 },
        -- The Frostwing Halls
        { L["Valithria Dreamwalker"], 854 },
        { L["Sindragosa"], 855 },
        -- The Frozen Throne
        { L["The Lich King"], 856 },
      }
    },
    {
      L["The Ruby Sanctum"],
      {
        { L["Baltharus the Warborn"], 890 },
        { L["General Zarithrian"], 893 },
        { L["Saviana Ragefire"], 891 },
        { L["Halion"], 887 },
      }
    },
  }
  for _, raid in ipairs(raids) do
    encounter_list = ("%s|cffffd200%s|r\n"):format(encounter_list, raid[1])
    for _, boss in ipairs(raid[2]) do
        encounter_list = ("%s%s: %d\n"):format(encounter_list, boss[1], boss[2])
    end
    encounter_list = encounter_list .. "\n"
  end

  encounter_list = encounter_list:sub(1, -3) .. "\n\n" .. L["Supports multiple entries, separated by commas\n"]
end

function Private.get_encounters_list()
  return encounter_list
end

function Private.get_zoneId_list()
  return ""
end

Private.talentInfo = {
  ["DEATHKNIGHT"] = {
    {
      135770, -- [1]
      7, -- [2]
      3, -- [3]
      50371, -- [4]
    }, -- [1]
    {
      135067, -- [1]
      2, -- [2]
      1, -- [3]
      49393, -- [4]
    }, -- [2]
    {
      132455, -- [1]
      1, -- [2]
      1, -- [3]
      49483, -- [4]
    }, -- [3]
    {
      237529, -- [1]
      3, -- [2]
      1, -- [3]
      48982, -- [4]
    }, -- [4]
    {
      237529, -- [1]
      4, -- [2]
      1, -- [3]
      49489, -- [4]
    }, -- [5]
    {
      237518, -- [1]
      3, -- [2]
      2, -- [3]
      49480, -- [4]
    }, -- [6]
    {
      132090, -- [1]
      6, -- [2]
      2, -- [3]
      49504, -- [4]
    }, -- [7]
    {
      237533, -- [1]
      1, -- [2]
      2, -- [3]
      49491, -- [4]
    }, -- [8]
    {
      132284, -- [1]
      2, -- [2]
      2, -- [3]
      49509, -- [4]
    }, -- [9]
    {
      132205, -- [1]
      5, -- [2]
      4, -- [3]
      49005, -- [4]
    }, -- [10]
    {
      136005, -- [1]
      5, -- [2]
      3, -- [3]
      50029, -- [4]
    }, -- [11]
    {
      237536, -- [1]
      4, -- [2]
      4, -- [3]
      55136, -- [4]
    }, -- [12]
    {
      237512, -- [1]
      7, -- [2]
      2, -- [3]
      49016, -- [4]
    }, -- [13]
    {
      136181, -- [1]
      8, -- [2]
      2, -- [3]
      49530, -- [4]
    }, -- [14]
    {
      135675, -- [1]
      9, -- [2]
      2, -- [3]
      55050, -- [4]
    }, -- [15]
    {
      135771, -- [1]
      9, -- [2]
      3, -- [3]
      49534, -- [4]
    }, -- [16]
    {
      132094, -- [1]
      9, -- [2]
      1, -- [3]
      50150, -- [4]
    }, -- [17]
    {
      136211, -- [1]
      7, -- [2]
      1, -- [3]
      49543, -- [4]
    }, -- [18]
    {
      135277, -- [1]
      11, -- [2]
      2, -- [3]
      49028, -- [4]
    }, -- [19]
    {
      135772, -- [1]
      5, -- [2]
      1, -- [3]
      49395, -- [4]
    }, -- [20]
    {
      132330, -- [1]
      1, -- [2]
      3, -- [3]
      55226, -- [4]
    }, -- [21]
    {
      237531, -- [1]
      4, -- [2]
      3, -- [3]
      49497, -- [4]
    }, -- [22]
    {
      136168, -- [1]
      8, -- [2]
      3, -- [3]
      55233, -- [4]
    }, -- [23]
    {
      136080, -- [1]
      10, -- [2]
      2, -- [3]
      61158, -- [4]
    }, -- [24]
    {
      135372, -- [1]
      3, -- [2]
      3, -- [3]
      50034, -- [4]
    }, -- [25]
    {
      236310, -- [1]
      6, -- [2]
      3, -- [3]
      53138, -- [4]
    }, -- [26]
    {
      135378, -- [1]
      2, -- [2]
      3, -- [3]
      55108, -- [4]
    }, -- [27]
    {
      237517, -- [1]
      8, -- [2]
      1, -- [3]
      62908, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      135892, -- [1]
      1, -- [2]
      3, -- [3]
      49789, -- [4]
    }, -- [41]
    {
      136223, -- [1]
      4, -- [2]
      4, -- [3]
      49657, -- [4]
    }, -- [42]
    {
      136141, -- [1]
      2, -- [2]
      3, -- [3]
      49664, -- [4]
    }, -- [43]
    {
      237520, -- [1]
      9, -- [2]
      2, -- [3]
      49143, -- [4]
    }, -- [44]
    {
      132388, -- [1]
      8, -- [2]
      3, -- [3]
      51271, -- [4]
    }, -- [45]
    {
      136213, -- [1]
      5, -- [2]
      4, -- [3]
      49796, -- [4]
    }, -- [46]
    {
      135849, -- [1]
      4, -- [2]
      3, -- [3]
      50115, -- [4]
    }, -- [47]
    {
      135833, -- [1]
      11, -- [2]
      2, -- [3]
      49184, -- [4]
    }, -- [48]
    {
      132734, -- [1]
      5, -- [2]
      2, -- [3]
      51109, -- [4]
    }, -- [49]
    {
      135840, -- [1]
      6, -- [2]
      3, -- [3]
      59057, -- [4]
    }, -- [50]
    {
      135294, -- [1]
      6, -- [2]
      2, -- [3]
      49538, -- [4]
    }, -- [51]
    {
      135791, -- [1]
      9, -- [2]
      1, -- [3]
      50152, -- [4]
    }, -- [52]
    {
      136107, -- [1]
      10, -- [2]
      2, -- [3]
      50130, -- [4]
    }, -- [53]
    {
      135152, -- [1]
      7, -- [2]
      2, -- [3]
      49203, -- [4]
    }, -- [54]
    {
      135728, -- [1]
      1, -- [2]
      2, -- [3]
      50147, -- [4]
    }, -- [55]
    {
      132147, -- [1]
      2, -- [2]
      4, -- [3]
      50138, -- [4]
    }, -- [56]
    {
      135773, -- [1]
      7, -- [2]
      3, -- [3]
      50385, -- [4]
    }, -- [57]
    {
      136083, -- [1]
      5, -- [2]
      3, -- [3]
      49791, -- [4]
    }, -- [58]
    {
      237526, -- [1]
      1, -- [2]
      1, -- [3]
      51456, -- [4]
    }, -- [59]
    {
      135859, -- [1]
      2, -- [2]
      2, -- [3]
      55062, -- [4]
    }, -- [60]
    {
      132373, -- [1]
      9, -- [2]
      3, -- [3]
      50191, -- [4]
    }, -- [61]
    {
      252994, -- [1]
      3, -- [2]
      1, -- [3]
      50887, -- [4]
    }, -- [62]
    {
      135305, -- [1]
      4, -- [2]
      2, -- [3]
      51130, -- [4]
    }, -- [63]
    {
      135609, -- [1]
      3, -- [2]
      3, -- [3]
      51473, -- [4]
    }, -- [64]
    {
      135714, -- [1]
      8, -- [2]
      2, -- [3]
      54637, -- [4]
    }, -- [65]
    {
      136187, -- [1]
      3, -- [2]
      2, -- [3]
      49039, -- [4]
    }, -- [66]
    {
      252994, -- [1]
      6, -- [2]
      1, -- [3]
      55610, -- [4]
    }, -- [67]
    {
      135864, -- [1]
      7, -- [2]
      1, -- [3]
      50043, -- [4]
    }, -- [68]
    {
      132148, -- [1]
      8, -- [2]
      1, -- [3]
      66192, -- [4]
    }, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136126, -- [1]
      1, -- [2]
      2, -- [3]
      49568, -- [4]
    }, -- [81]
    {
      136144, -- [1]
      2, -- [2]
      2, -- [3]
      49565, -- [4]
    }, -- [82]
    {
      237524, -- [1]
      2, -- [2]
      4, -- [3]
      49572, -- [4]
    }, -- [83]
    {
      136066, -- [1]
      8, -- [2]
      2, -- [3]
      49632, -- [4]
    }, -- [84]
    {
      136207, -- [1]
      2, -- [2]
      1, -- [3]
      49562, -- [4]
    }, -- [85]
    {
      136119, -- [1]
      6, -- [2]
      4, -- [3]
      52143, -- [4]
    }, -- [86]
    {
      132099, -- [1]
      3, -- [2]
      3, -- [3]
      49158, -- [4]
    }, -- [87]
    {
      136132, -- [1]
      5, -- [2]
      1, -- [3]
      49194, -- [4]
    }, -- [88]
    {
      132182, -- [1]
      11, -- [2]
      2, -- [3]
      49206, -- [4]
    }, -- [89]
    {
      136195, -- [1]
      6, -- [2]
      3, -- [3]
      56835, -- [4]
    }, -- [90]
    {
      136127, -- [1]
      9, -- [2]
      1, -- [3]
      49655, -- [4]
    }, -- [91]
    {
      132109, -- [1]
      4, -- [2]
      3, -- [3]
      49628, -- [4]
    }, -- [92]
    {
      136196, -- [1]
      5, -- [2]
      2, -- [3]
      49638, -- [4]
    }, -- [93]
    {
      132728, -- [1]
      8, -- [2]
      3, -- [3]
      49222, -- [4]
    }, -- [94]
    {
      136182, -- [1]
      3, -- [2]
      1, -- [3]
      55237, -- [4]
    }, -- [95]
    {
      136120, -- [1]
      6, -- [2]
      2, -- [3]
      49611, -- [4]
    }, -- [96]
    {
      136194, -- [1]
      5, -- [2]
      3, -- [3]
      49599, -- [4]
    }, -- [97]
    {
      135775, -- [1]
      7, -- [2]
      3, -- [3]
      50392, -- [4]
    }, -- [98]
    {
      237532, -- [1]
      2, -- [2]
      3, -- [3]
      49589, -- [4]
    }, -- [99]
    {
      135564, -- [1]
      10, -- [2]
      2, -- [3]
      50121, -- [4]
    }, -- [100]
    {
      237534, -- [1]
      4, -- [2]
      2, -- [3]
      51267, -- [4]
    }, -- [101]
    {
      132095, -- [1]
      9, -- [2]
      2, -- [3]
      51161, -- [4]
    }, -- [102]
    {
      135695, -- [1]
      3, -- [2]
      2, -- [3]
      51465, -- [4]
    }, -- [103]
    {
      135774, -- [1]
      1, -- [2]
      1, -- [3]
      51746, -- [4]
    }, -- [104]
    {
      132152, -- [1]
      7, -- [2]
      4, -- [3]
      63560, -- [4]
    }, -- [105]
    {
      237530, -- [1]
      9, -- [2]
      3, -- [3]
      55090, -- [4]
    }, -- [106]
    {
      136056, -- [1]
      1, -- [2]
      3, -- [3]
      55133, -- [4]
    }, -- [107]
    {
      237510, -- [1]
      7, -- [2]
      2, -- [3]
      51052, -- [4]
    }, -- [108]
    {
      237511, -- [1]
      4, -- [2]
      4, -- [3]
      55623, -- [4]
    }, -- [109]
    {
      136199, -- [1]
      6, -- [2]
      1, -- [3]
      55667, -- [4]
    }, -- [110]
    {
      136224, -- [1]
      7, -- [2]
      1, -- [3]
      66817, -- [4]
    }, -- [111]
    [121] = {
      "DeathKnightBlood", -- [1]
      "DeathKnightFrost", -- [2]
      "DeathKnightUnholy", -- [3]
    },
  },
  ["WARRIOR"] = {
    {
      132090, -- [1]
      3, -- [2]
      4, -- [3]
      12867, -- [4]
    }, -- [1]
    {
      135328, -- [1]
      5, -- [2]
      4, -- [3]
      12815, -- [4]
    }, -- [2]
    {
      132282, -- [1]
      1, -- [2]
      1, -- [3]
      12664, -- [4]
    }, -- [3]
    {
      133476, -- [1]
      5, -- [2]
      3, -- [3]
      12704, -- [4]
    }, -- [4]
    {
      132337, -- [1]
      2, -- [2]
      1, -- [3]
      12697, -- [4]
    }, -- [5]
    {
      132155, -- [1]
      1, -- [2]
      3, -- [3]
      12658, -- [4]
    }, -- [6]
    {
      136031, -- [1]
      2, -- [2]
      3, -- [3]
      12677, -- [4]
    }, -- [7]
    {
      132316, -- [1]
      6, -- [2]
      3, -- [3]
      23695, -- [4]
    }, -- [8]
    {
      132269, -- [1]
      1, -- [2]
      2, -- [3]
      16466, -- [4]
    }, -- [9]
    {
      135275, -- [1]
      3, -- [2]
      1, -- [3]
      12963, -- [4]
    }, -- [10]
    {
      132397, -- [1]
      5, -- [2]
      1, -- [3]
      12785, -- [4]
    }, -- [11]
    {
      132306, -- [1]
      5, -- [2]
      2, -- [3]
      12328, -- [4]
    }, -- [12]
    {
      132367, -- [1]
      6, -- [2]
      1, -- [3]
      20505, -- [4]
    }, -- [13]
    {
      132355, -- [1]
      7, -- [2]
      2, -- [3]
      12294, -- [4]
    }, -- [14]
    {
      132400, -- [1]
      4, -- [2]
      2, -- [3]
      12712, -- [4]
    }, -- [15]
    {
      135881, -- [1]
      3, -- [2]
      2, -- [3]
      12296, -- [4]
    }, -- [16]
    {
      135995, -- [1]
      2, -- [2]
      2, -- [3]
      12960, -- [4]
    }, -- [17]
    {
      132312, -- [1]
      3, -- [2]
      3, -- [3]
      16494, -- [4]
    }, -- [18]
    {
      132344, -- [1]
      9, -- [2]
      2, -- [3]
      29623, -- [4]
    }, -- [19]
    {
      132346, -- [1]
      9, -- [2]
      1, -- [3]
      29724, -- [4]
    }, -- [20]
    {
      132175, -- [1]
      7, -- [2]
      1, -- [3]
      29838, -- [4]
    }, -- [21]
    {
      132334, -- [1]
      9, -- [2]
      3, -- [3]
      29859, -- [4]
    }, -- [22]
    {
      132355, -- [1]
      8, -- [2]
      2, -- [3]
      35449, -- [4]
    }, -- [23]
    {
      236305, -- [1]
      6, -- [2]
      4, -- [3]
      46855, -- [4]
    }, -- [24]
    {
      236317, -- [1]
      8, -- [2]
      3, -- [3]
      46860, -- [4]
    }, -- [25]
    {
      132349, -- [1]
      7, -- [2]
      3, -- [3]
      46866, -- [4]
    }, -- [26]
    {
      236303, -- [1]
      11, -- [2]
      2, -- [3]
      46924, -- [4]
    }, -- [27]
    {
      132364, -- [1]
      10, -- [2]
      2, -- [3]
      56614, -- [4]
    }, -- [28]
    {
      236276, -- [1]
      4, -- [2]
      3, -- [3]
      56638, -- [4]
    }, -- [29]
    {
      132340, -- [1]
      7, -- [2]
      4, -- [3]
      12330, -- [4]
    }, -- [30]
    {
      132335, -- [1]
      8, -- [2]
      1, -- [3]
      64976, -- [4]
    }, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      136035, -- [1]
      3, -- [2]
      4, -- [3]
      12861, -- [4]
    }, -- [41]
    {
      136224, -- [1]
      4, -- [2]
      3, -- [3]
      13048, -- [4]
    }, -- [42]
    {
      132152, -- [1]
      6, -- [2]
      3, -- [3]
      12974, -- [4]
    }, -- [43]
    {
      132292, -- [1]
      1, -- [2]
      3, -- [3]
      12856, -- [4]
    }, -- [44]
    {
      136075, -- [1]
      1, -- [2]
      2, -- [3]
      12835, -- [4]
    }, -- [45]
    {
      136097, -- [1]
      2, -- [2]
      3, -- [3]
      13002, -- [4]
    }, -- [46]
    {
      136147, -- [1]
      3, -- [2]
      2, -- [3]
      12323, -- [4]
    }, -- [47]
    {
      132366, -- [1]
      2, -- [2]
      2, -- [3]
      12879, -- [4]
    }, -- [48]
    {
      136146, -- [1]
      5, -- [2]
      2, -- [3]
      12292, -- [4]
    }, -- [49]
    {
      132338, -- [1]
      3, -- [2]
      1, -- [3]
      20496, -- [4]
    }, -- [50]
    {
      136012, -- [1]
      7, -- [2]
      2, -- [3]
      23881, -- [4]
    }, -- [51]
    {
      136218, -- [1]
      3, -- [2]
      3, -- [3]
      16492, -- [4]
    }, -- [52]
    {
      136009, -- [1]
      6, -- [2]
      1, -- [3]
      20501, -- [4]
    }, -- [53]
    {
      135358, -- [1]
      4, -- [2]
      2, -- [3]
      20503, -- [4]
    }, -- [54]
    {
      132307, -- [1]
      5, -- [2]
      3, -- [3]
      29889, -- [4]
    }, -- [55]
    {
      132147, -- [1]
      4, -- [2]
      1, -- [3]
      23588, -- [4]
    }, -- [56]
    {
      132369, -- [1]
      7, -- [2]
      4, -- [3]
      29776, -- [4]
    }, -- [57]
    {
      132222, -- [1]
      5, -- [2]
      1, -- [3]
      29592, -- [4]
    }, -- [58]
    {
      132275, -- [1]
      8, -- [2]
      4, -- [3]
      29763, -- [4]
    }, -- [59]
    {
      132352, -- [1]
      9, -- [2]
      2, -- [3]
      29801, -- [4]
    }, -- [60]
    {
      132344, -- [1]
      7, -- [2]
      1, -- [3]
      56924, -- [4]
    }, -- [61]
    {
      236308, -- [1]
      8, -- [2]
      1, -- [3]
      46911, -- [4]
    }, -- [62]
    {
      236306, -- [1]
      9, -- [2]
      3, -- [3]
      46915, -- [4]
    }, -- [63]
    {
      236316, -- [1]
      11, -- [2]
      2, -- [3]
      46917, -- [4]
    }, -- [64]
    {
      236171, -- [1]
      9, -- [2]
      1, -- [3]
      60970, -- [4]
    }, -- [65]
    {
      236310, -- [1]
      10, -- [2]
      2, -- [3]
      56932, -- [4]
    }, -- [66]
    {
      135053, -- [1]
      1, -- [2]
      1, -- [3]
      61222, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136056, -- [1]
      2, -- [2]
      3, -- [3]
      12753, -- [4]
    }, -- [81]
    {
      135892, -- [1]
      3, -- [2]
      4, -- [3]
      12764, -- [4]
    }, -- [82]
    {
      132326, -- [1]
      1, -- [2]
      3, -- [3]
      12666, -- [4]
    }, -- [83]
    {
      132277, -- [1]
      1, -- [2]
      1, -- [3]
      12818, -- [4]
    }, -- [84]
    {
      236309, -- [1]
      2, -- [2]
      2, -- [3]
      50687, -- [4]
    }, -- [85]
    {
      132363, -- [1]
      4, -- [2]
      3, -- [3]
      12811, -- [4]
    }, -- [86]
    {
      132353, -- [1]
      3, -- [2]
      2, -- [3]
      12799, -- [4]
    }, -- [87]
    {
      236318, -- [1]
      7, -- [2]
      2, -- [3]
      50720, -- [4]
    }, -- [88]
    {
      132357, -- [1]
      5, -- [2]
      3, -- [3]
      12958, -- [4]
    }, -- [89]
    {
      132362, -- [1]
      5, -- [2]
      1, -- [3]
      12803, -- [4]
    }, -- [90]
    {
      132343, -- [1]
      4, -- [2]
      2, -- [3]
      12804, -- [4]
    }, -- [91]
    {
      132325, -- [1]
      5, -- [2]
      2, -- [3]
      12809, -- [4]
    }, -- [92]
    {
      135871, -- [1]
      3, -- [2]
      1, -- [3]
      12975, -- [4]
    }, -- [93]
    {
      135321, -- [1]
      6, -- [2]
      3, -- [3]
      16542, -- [4]
    }, -- [94]
    {
      134952, -- [1]
      1, -- [2]
      2, -- [3]
      12727, -- [4]
    }, -- [95]
    {
      132341, -- [1]
      7, -- [2]
      1, -- [3]
      29594, -- [4]
    }, -- [96]
    {
      133123, -- [1]
      8, -- [2]
      2, -- [3]
      29144, -- [4]
    }, -- [97]
    {
      132360, -- [1]
      3, -- [2]
      3, -- [3]
      29599, -- [4]
    }, -- [98]
    {
      132345, -- [1]
      7, -- [2]
      3, -- [3]
      29792, -- [4]
    }, -- [99]
    {
      135291, -- [1]
      9, -- [2]
      2, -- [3]
      20243, -- [4]
    }, -- [100]
    {
      236311, -- [1]
      8, -- [2]
      3, -- [3]
      46949, -- [4]
    }, -- [101]
    {
      236315, -- [1]
      10, -- [2]
      2, -- [3]
      46953, -- [4]
    }, -- [102]
    {
      236312, -- [1]
      11, -- [2]
      2, -- [3]
      46968, -- [4]
    }, -- [103]
    {
      236307, -- [1]
      9, -- [2]
      3, -- [3]
      47296, -- [4]
    }, -- [104]
    {
      236319, -- [1]
      9, -- [2]
      1, -- [3]
      57499, -- [4]
    }, -- [105]
    {
      134976, -- [1]
      10, -- [2]
      3, -- [3]
      58874, -- [4]
    }, -- [106]
    {
      132361, -- [1]
      4, -- [2]
      1, -- [3]
      59089, -- [4]
    }, -- [107]
    [121] = {
      "WarriorArms", -- [1]
      "WarriorFury", -- [2]
      "WarriorProtection", -- [3]
    },
  },
  ["SHAMAN"] = {
    {
      135817, -- [1]
      2, -- [2]
      1, -- [3]
      16161, -- [4]
    }, -- [1]
    {
      136014, -- [1]
      5, -- [2]
      2, -- [3]
      16041, -- [4]
    }, -- [2]
    {
      135807, -- [1]
      1, -- [2]
      3, -- [3]
      16108, -- [4]
    }, -- [3]
    {
      136116, -- [1]
      1, -- [2]
      2, -- [3]
      16112, -- [4]
    }, -- [4]
    {
      135830, -- [1]
      3, -- [2]
      3, -- [3]
      60188, -- [4]
    }, -- [5]
    {
      135824, -- [1]
      4, -- [2]
      1, -- [3]
      16544, -- [4]
    }, -- [6]
    {
      136115, -- [1]
      7, -- [2]
      2, -- [3]
      16166, -- [4]
    }, -- [7]
    {
      136170, -- [1]
      3, -- [2]
      2, -- [3]
      16164, -- [4]
    }, -- [8]
    {
      135850, -- [1]
      3, -- [2]
      1, -- [3]
      16116, -- [4]
    }, -- [9]
    {
      135990, -- [1]
      6, -- [2]
      3, -- [3]
      16582, -- [4]
    }, -- [10]
    {
      136094, -- [1]
      2, -- [2]
      2, -- [3]
      28998, -- [4]
    }, -- [11]
    {
      136099, -- [1]
      5, -- [2]
      1, -- [3]
      29000, -- [4]
    }, -- [12]
    {
      136213, -- [1]
      4, -- [2]
      4, -- [3]
      29065, -- [4]
    }, -- [13]
    {
      135791, -- [1]
      2, -- [2]
      3, -- [3]
      29180, -- [4]
    }, -- [14]
    {
      136111, -- [1]
      5, -- [2]
      4, -- [3]
      30666, -- [4]
    }, -- [15]
    {
      136028, -- [1]
      6, -- [2]
      1, -- [3]
      30674, -- [4]
    }, -- [16]
    {
      136050, -- [1]
      8, -- [2]
      3, -- [3]
      30679, -- [4]
    }, -- [17]
    {
      135829, -- [1]
      9, -- [2]
      2, -- [3]
      30706, -- [4]
    }, -- [18]
    {
      237576, -- [1]
      8, -- [2]
      2, -- [3]
      51470, -- [4]
    }, -- [19]
    {
      237572, -- [1]
      9, -- [2]
      1, -- [3]
      51479, -- [4]
    }, -- [20]
    {
      237583, -- [1]
      9, -- [2]
      3, -- [3]
      51482, -- [4]
    }, -- [21]
    {
      237588, -- [1]
      7, -- [2]
      3, -- [3]
      51486, -- [4]
    }, -- [22]
    {
      237589, -- [1]
      11, -- [2]
      2, -- [3]
      51490, -- [4]
    }, -- [23]
    {
      136234, -- [1]
      10, -- [2]
      2, -- [3]
      62101, -- [4]
    }, -- [24]
    {
      135782, -- [1]
      8, -- [2]
      1, -- [3]
      63372, -- [4]
    }, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      136056, -- [1]
      3, -- [2]
      4, -- [3]
      16272, -- [4]
    }, -- [41]
    {
      132152, -- [1]
      4, -- [2]
      2, -- [3]
      16284, -- [4]
    }, -- [42]
    {
      136095, -- [1]
      2, -- [2]
      3, -- [3]
      16287, -- [4]
    }, -- [43]
    {
      136051, -- [1]
      2, -- [2]
      4, -- [3]
      51881, -- [4]
    }, -- [44]
    {
      136098, -- [1]
      2, -- [2]
      1, -- [3]
      16293, -- [4]
    }, -- [45]
    {
      136023, -- [1]
      1, -- [2]
      1, -- [3]
      52456, -- [4]
    }, -- [46]
    {
      135814, -- [1]
      3, -- [2]
      1, -- [3]
      29080, -- [4]
    }, -- [47]
    {
      132325, -- [1]
      2, -- [2]
      2, -- [3]
      16305, -- [4]
    }, -- [48]
    {
      136162, -- [1]
      1, -- [2]
      3, -- [3]
      17489, -- [4]
    }, -- [49]
    {
      135892, -- [1]
      4, -- [2]
      3, -- [3]
      16309, -- [4]
    }, -- [50]
    {
      132269, -- [1]
      5, -- [2]
      2, -- [3]
      16268, -- [4]
    }, -- [51]
    {
      136027, -- [1]
      3, -- [2]
      3, -- [3]
      43338, -- [4]
    }, -- [52]
    {
      132314, -- [1]
      7, -- [2]
      3, -- [3]
      17364, -- [4]
    }, -- [53]
    {
      132215, -- [1]
      6, -- [2]
      3, -- [3]
      29086, -- [4]
    }, -- [54]
    {
      136114, -- [1]
      5, -- [2]
      1, -- [3]
      29193, -- [4]
    }, -- [55]
    {
      136110, -- [1]
      6, -- [2]
      1, -- [3]
      30809, -- [4]
    }, -- [56]
    {
      132147, -- [1]
      7, -- [2]
      2, -- [3]
      30798, -- [4]
    }, -- [57]
    {
      136055, -- [1]
      9, -- [2]
      1, -- [3]
      30814, -- [4]
    }, -- [58]
    {
      132148, -- [1]
      7, -- [2]
      1, -- [3]
      30819, -- [4]
    }, -- [59]
    {
      136088, -- [1]
      9, -- [2]
      2, -- [3]
      30823, -- [4]
    }, -- [60]
    {
      237581, -- [1]
      8, -- [2]
      3, -- [3]
      51522, -- [4]
    }, -- [61]
    {
      237587, -- [1]
      8, -- [2]
      1, -- [3]
      51527, -- [4]
    }, -- [62]
    {
      136024, -- [1]
      9, -- [2]
      3, -- [3]
      51524, -- [4]
    }, -- [63]
    {
      237584, -- [1]
      10, -- [2]
      2, -- [3]
      51532, -- [4]
    }, -- [64]
    {
      237577, -- [1]
      11, -- [2]
      2, -- [3]
      51533, -- [4]
    }, -- [65]
    {
      136012, -- [1]
      5, -- [2]
      3, -- [3]
      51885, -- [4]
    }, -- [66]
    {
      136097, -- [1]
      1, -- [2]
      2, -- [3]
      16130, -- [4]
    }, -- [67]
    {
      236289, -- [1]
      8, -- [2]
      2, -- [3]
      60103, -- [4]
    }, -- [68]
    {
      135776, -- [1]
      6, -- [2]
      4, -- [3]
      63374, -- [4]
    }, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136109, -- [1]
      3, -- [2]
      4, -- [3]
      16240, -- [4]
    }, -- [81]
    {
      135845, -- [1]
      3, -- [2]
      3, -- [3]
      55198, -- [4]
    }, -- [82]
    {
      132315, -- [1]
      3, -- [2]
      1, -- [3]
      16198, -- [4]
    }, -- [83]
    {
      136052, -- [1]
      1, -- [2]
      2, -- [3]
      16229, -- [4]
    }, -- [84]
    {
      136043, -- [1]
      3, -- [2]
      2, -- [3]
      16232, -- [4]
    }, -- [85]
    {
      136053, -- [1]
      4, -- [2]
      2, -- [3]
      16206, -- [4]
    }, -- [86]
    {
      136080, -- [1]
      2, -- [2]
      1, -- [3]
      16209, -- [4]
    }, -- [87]
    {
      135861, -- [1]
      7, -- [2]
      2, -- [3]
      16190, -- [4]
    }, -- [88]
    {
      136076, -- [1]
      5, -- [2]
      3, -- [3]
      16188, -- [4]
    }, -- [89]
    {
      135865, -- [1]
      6, -- [2]
      3, -- [3]
      16213, -- [4]
    }, -- [90]
    {
      135859, -- [1]
      2, -- [2]
      3, -- [3]
      16217, -- [4]
    }, -- [91]
    {
      136107, -- [1]
      4, -- [2]
      3, -- [3]
      16221, -- [4]
    }, -- [92]
    {
      136057, -- [1]
      1, -- [2]
      3, -- [3]
      16225, -- [4]
    }, -- [93]
    {
      136041, -- [1]
      2, -- [2]
      2, -- [3]
      29191, -- [4]
    }, -- [94]
    {
      136044, -- [1]
      5, -- [2]
      1, -- [3]
      29202, -- [4]
    }, -- [95]
    {
      136035, -- [1]
      5, -- [2]
      4, -- [3]
      30866, -- [4]
    }, -- [96]
    {
      136059, -- [1]
      8, -- [2]
      3, -- [3]
      30869, -- [4]
    }, -- [97]
    {
      136042, -- [1]
      8, -- [2]
      2, -- [3]
      30873, -- [4]
    }, -- [98]
    {
      136089, -- [1]
      9, -- [2]
      2, -- [3]
      974, -- [4]
    }, -- [99]
    {
      136060, -- [1]
      7, -- [2]
      1, -- [3]
      30886, -- [4]
    }, -- [100]
    {
      136089, -- [1]
      9, -- [2]
      3, -- [3]
      51561, -- [4]
    }, -- [101]
    {
      237573, -- [1]
      8, -- [2]
      1, -- [3]
      51555, -- [4]
    }, -- [102]
    {
      237571, -- [1]
      9, -- [2]
      1, -- [3]
      51558, -- [4]
    }, -- [103]
    {
      237590, -- [1]
      10, -- [2]
      2, -- [3]
      51566, -- [4]
    }, -- [104]
    {
      252995, -- [1]
      11, -- [2]
      2, -- [3]
      61295, -- [4]
    }, -- [105]
    {
      236288, -- [1]
      7, -- [2]
      3, -- [3]
      51886, -- [4]
    }, -- [106]
    [121] = {
      "ShamanElementalCombat", -- [1]
      "ShamanEnhancement", -- [2]
      "ShamanRestoration", -- [3]
    },
  },
  ["MAGE"] = {
    {
      135894, -- [1]
      1, -- [2]
      1, -- [3]
      12592, -- [4]
    }, -- [1]
    {
      136170, -- [1]
      2, -- [2]
      3, -- [3]
      12577, -- [4]
    }, -- [2]
    {
      135892, -- [1]
      1, -- [2]
      2, -- [3]
      12840, -- [4]
    }, -- [3]
    {
      136129, -- [1]
      5, -- [2]
      4, -- [3]
      12503, -- [4]
    }, -- [4]
    {
      136096, -- [1]
      1, -- [2]
      3, -- [3]
      16770, -- [4]
    }, -- [5]
    {
      136116, -- [1]
      3, -- [2]
      2, -- [3]
      12469, -- [4]
    }, -- [6]
    {
      136006, -- [1]
      3, -- [2]
      1, -- [3]
      12606, -- [4]
    }, -- [7]
    {
      136153, -- [1]
      4, -- [2]
      1, -- [3]
      12605, -- [4]
    }, -- [8]
    {
      135733, -- [1]
      2, -- [2]
      1, -- [3]
      54659, -- [4]
    }, -- [9]
    {
      136031, -- [1]
      5, -- [2]
      2, -- [3]
      12043, -- [4]
    }, -- [10]
    {
      136048, -- [1]
      7, -- [2]
      2, -- [3]
      12042, -- [4]
    }, -- [11]
    {
      135856, -- [1]
      4, -- [2]
      2, -- [3]
      12598, -- [4]
    }, -- [12]
    {
      136222, -- [1]
      6, -- [2]
      2, -- [3]
      15060, -- [4]
    }, -- [13]
    {
      136208, -- [1]
      4, -- [2]
      3, -- [3]
      18464, -- [4]
    }, -- [14]
    {
      136011, -- [1]
      2, -- [2]
      2, -- [3]
      29444, -- [4]
    }, -- [15]
    {
      135736, -- [1]
      5, -- [2]
      1, -- [3]
      31570, -- [4]
    }, -- [16]
    {
      135732, -- [1]
      6, -- [2]
      3, -- [3]
      31572, -- [4]
    }, -- [17]
    {
      135752, -- [1]
      6, -- [2]
      1, -- [3]
      54354, -- [4]
    }, -- [18]
    {
      136096, -- [1]
      7, -- [2]
      1, -- [3]
      31583, -- [4]
    }, -- [19]
    {
      135740, -- [1]
      8, -- [2]
      3, -- [3]
      31588, -- [4]
    }, -- [20]
    {
      136091, -- [1]
      9, -- [2]
      2, -- [3]
      31589, -- [4]
    }, -- [21]
    {
      135734, -- [1]
      10, -- [2]
      3, -- [3]
      35581, -- [4]
    }, -- [22]
    {
      236223, -- [1]
      8, -- [2]
      2, -- [3]
      44379, -- [4]
    }, -- [23]
    {
      236219, -- [1]
      7, -- [2]
      3, -- [3]
      44396, -- [4]
    }, -- [24]
    {
      236225, -- [1]
      3, -- [2]
      3, -- [3]
      44399, -- [4]
    }, -- [25]
    {
      236222, -- [1]
      10, -- [2]
      2, -- [3]
      44403, -- [4]
    }, -- [26]
    {
      236205, -- [1]
      11, -- [2]
      2, -- [3]
      44425, -- [4]
    }, -- [27]
    {
      236221, -- [1]
      9, -- [2]
      3, -- [3]
      54490, -- [4]
    }, -- [28]
    {
      135754, -- [1]
      3, -- [2]
      4, -- [3]
      54646, -- [4]
    }, -- [29]
    {
      236226, -- [1]
      4, -- [2]
      4, -- [3]
      55340, -- [4]
    }, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      135805, -- [1]
      3, -- [2]
      4, -- [3]
      12351, -- [4]
    }, -- [41]
    {
      135806, -- [1]
      4, -- [2]
      2, -- [3]
      13043, -- [4]
    }, -- [42]
    {
      135827, -- [1]
      4, -- [2]
      1, -- [3]
      12873, -- [4]
    }, -- [43]
    {
      135812, -- [1]
      1, -- [2]
      3, -- [3]
      12341, -- [4]
    }, -- [44]
    {
      135807, -- [1]
      1, -- [2]
      1, -- [3]
      11080, -- [4]
    }, -- [45]
    {
      135815, -- [1]
      3, -- [2]
      1, -- [3]
      12353, -- [4]
    }, -- [46]
    {
      135808, -- [1]
      3, -- [2]
      3, -- [3]
      11366, -- [4]
    }, -- [47]
    {
      135821, -- [1]
      3, -- [2]
      2, -- [3]
      12358, -- [4]
    }, -- [48]
    {
      236228, -- [1]
      2, -- [2]
      3, -- [3]
      12350, -- [4]
    }, -- [49]
    {
      135903, -- [1]
      5, -- [2]
      3, -- [3]
      11113, -- [4]
    }, -- [50]
    {
      136115, -- [1]
      5, -- [2]
      2, -- [3]
      11368, -- [4]
    }, -- [51]
    {
      135818, -- [1]
      2, -- [2]
      1, -- [3]
      12848, -- [4]
    }, -- [52]
    {
      135817, -- [1]
      6, -- [2]
      3, -- [3]
      12400, -- [4]
    }, -- [53]
    {
      135824, -- [1]
      7, -- [2]
      2, -- [3]
      11129, -- [4]
    }, -- [54]
    {
      135813, -- [1]
      1, -- [2]
      2, -- [3]
      54734, -- [4]
    }, -- [55]
    {
      135820, -- [1]
      4, -- [2]
      4, -- [3]
      29076, -- [4]
    }, -- [56]
    {
      135823, -- [1]
      5, -- [2]
      1, -- [3]
      31640, -- [4]
    }, -- [57]
    {
      135788, -- [1]
      6, -- [2]
      1, -- [3]
      31642, -- [4]
    }, -- [58]
    {
      135822, -- [1]
      7, -- [2]
      3, -- [3]
      31680, -- [4]
    }, -- [59]
    {
      135789, -- [1]
      7, -- [2]
      1, -- [3]
      34296, -- [4]
    }, -- [60]
    {
      135812, -- [1]
      8, -- [2]
      3, -- [3]
      31658, -- [4]
    }, -- [61]
    {
      134153, -- [1]
      9, -- [2]
      2, -- [3]
      31661, -- [4]
    }, -- [62]
    {
      236215, -- [1]
      8, -- [2]
      1, -- [3]
      64357, -- [4]
    }, -- [63]
    {
      236216, -- [1]
      9, -- [2]
      1, -- [3]
      44443, -- [4]
    }, -- [64]
    {
      236218, -- [1]
      9, -- [2]
      3, -- [3]
      44448, -- [4]
    }, -- [65]
    {
      236207, -- [1]
      10, -- [2]
      2, -- [3]
      44472, -- [4]
    }, -- [66]
    {
      236220, -- [1]
      11, -- [2]
      2, -- [3]
      44457, -- [4]
    }, -- [67]
    {
      135829, -- [1]
      2, -- [2]
      2, -- [3]
      54749, -- [4]
    }, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      135846, -- [1]
      1, -- [2]
      2, -- [3]
      16766, -- [4]
    }, -- [81]
    {
      135842, -- [1]
      1, -- [2]
      1, -- [3]
      12497, -- [4]
    }, -- [82]
    {
      135845, -- [1]
      3, -- [2]
      1, -- [3]
      12953, -- [4]
    }, -- [83]
    {
      135854, -- [1]
      1, -- [2]
      3, -- [3]
      55094, -- [4]
    }, -- [84]
    {
      135857, -- [1]
      3, -- [2]
      3, -- [3]
      12488, -- [4]
    }, -- [85]
    {
      135852, -- [1]
      5, -- [2]
      3, -- [3]
      12490, -- [4]
    }, -- [86]
    {
      135864, -- [1]
      2, -- [2]
      4, -- [3]
      12571, -- [4]
    }, -- [87]
    {
      135860, -- [1]
      4, -- [2]
      2, -- [3]
      12519, -- [4]
    }, -- [88]
    {
      135849, -- [1]
      4, -- [2]
      3, -- [3]
      12983, -- [4]
    }, -- [89]
    {
      135836, -- [1]
      6, -- [2]
      3, -- [3]
      28593, -- [4]
    }, -- [90]
    {
      135838, -- [1]
      3, -- [2]
      2, -- [3]
      12472, -- [4]
    }, -- [91]
    {
      135850, -- [1]
      2, -- [2]
      2, -- [3]
      28332, -- [4]
    }, -- [92]
    {
      135988, -- [1]
      7, -- [2]
      2, -- [3]
      11426, -- [4]
    }, -- [93]
    {
      135865, -- [1]
      5, -- [2]
      2, -- [3]
      11958, -- [4]
    }, -- [94]
    {
      135855, -- [1]
      2, -- [2]
      1, -- [3]
      15047, -- [4]
    }, -- [95]
    {
      136141, -- [1]
      4, -- [2]
      1, -- [3]
      16758, -- [4]
    }, -- [96]
    {
      135989, -- [1]
      2, -- [2]
      3, -- [3]
      29440, -- [4]
    }, -- [97]
    {
      135851, -- [1]
      5, -- [2]
      4, -- [3]
      31669, -- [4]
    }, -- [98]
    {
      236209, -- [1]
      6, -- [2]
      1, -- [3]
      55092, -- [4]
    }, -- [99]
    {
      135833, -- [1]
      7, -- [2]
      3, -- [3]
      31678, -- [4]
    }, -- [100]
    {
      135846, -- [1]
      8, -- [2]
      2, -- [3]
      31683, -- [4]
    }, -- [101]
    {
      135862, -- [1]
      9, -- [2]
      2, -- [3]
      31687, -- [4]
    }, -- [102]
    {
      236227, -- [1]
      8, -- [2]
      3, -- [3]
      44545, -- [4]
    }, -- [103]
    {
      236206, -- [1]
      9, -- [2]
      1, -- [3]
      44549, -- [4]
    }, -- [104]
    {
      135862, -- [1]
      9, -- [2]
      3, -- [3]
      44561, -- [4]
    }, -- [105]
    {
      236208, -- [1]
      10, -- [2]
      2, -- [3]
      44571, -- [4]
    }, -- [106]
    {
      236214, -- [1]
      11, -- [2]
      2, -- [3]
      44572, -- [4]
    }, -- [107]
    {
      236224, -- [1]
      7, -- [2]
      1, -- [3]
      54787, -- [4]
    }, -- [108]
    [121] = {
      "MageArcane", -- [1]
      "MageFire", -- [2]
      "MageFrost", -- [3]
    },
  },
  ["PRIEST"] = {
    {
      136107, -- [1]
      2, -- [2]
      4, -- [3]
      14774, -- [4]
    }, -- [1]
    {
      135939, -- [1]
      7, -- [2]
      2, -- [3]
      10060, -- [4]
    }, -- [2]
    {
      132156, -- [1]
      4, -- [2]
      2, -- [3]
      14781, -- [4]
    }, -- [3]
    {
      135995, -- [1]
      1, -- [2]
      2, -- [3]
      14791, -- [4]
    }, -- [4]
    {
      135940, -- [1]
      3, -- [2]
      3, -- [3]
      14769, -- [4]
    }, -- [5]
    {
      135987, -- [1]
      2, -- [2]
      3, -- [3]
      14767, -- [4]
    }, -- [6]
    {
      135926, -- [1]
      2, -- [2]
      2, -- [3]
      14771, -- [4]
    }, -- [7]
    {
      136090, -- [1]
      3, -- [2]
      1, -- [3]
      14777, -- [4]
    }, -- [8]
    {
      135863, -- [1]
      3, -- [2]
      2, -- [3]
      14751, -- [4]
    }, -- [9]
    {
      136170, -- [1]
      4, -- [2]
      4, -- [3]
      14772, -- [4]
    }, -- [10]
    {
      135948, -- [1]
      5, -- [2]
      3, -- [3]
      63574, -- [4]
    }, -- [11]
    {
      136053, -- [1]
      2, -- [2]
      1, -- [3]
      14785, -- [4]
    }, -- [12]
    {
      136031, -- [1]
      5, -- [2]
      2, -- [3]
      18555, -- [4]
    }, -- [13]
    {
      237538, -- [1]
      10, -- [2]
      2, -- [3]
      52800, -- [4]
    }, -- [14]
    {
      135868, -- [1]
      4, -- [2]
      1, -- [3]
      33172, -- [4]
    }, -- [15]
    {
      136158, -- [1]
      6, -- [2]
      1, -- [3]
      33190, -- [4]
    }, -- [16]
    {
      135740, -- [1]
      6, -- [2]
      3, -- [3]
      34910, -- [4]
    }, -- [17]
    {
      135886, -- [1]
      7, -- [2]
      3, -- [3]
      63506, -- [4]
    }, -- [18]
    {
      135936, -- [1]
      9, -- [2]
      2, -- [3]
      33206, -- [4]
    }, -- [19]
    {
      135737, -- [1]
      7, -- [2]
      1, -- [3]
      45244, -- [4]
    }, -- [20]
    {
      237537, -- [1]
      8, -- [2]
      3, -- [3]
      47508, -- [4]
    }, -- [21]
    {
      237539, -- [1]
      9, -- [2]
      1, -- [3]
      47515, -- [4]
    }, -- [22]
    {
      237548, -- [1]
      8, -- [2]
      2, -- [3]
      47537, -- [4]
    }, -- [23]
    {
      237545, -- [1]
      11, -- [2]
      2, -- [3]
      47540, -- [4]
    }, -- [24]
    {
      135969, -- [1]
      1, -- [2]
      3, -- [3]
      52803, -- [4]
    }, -- [25]
    {
      237543, -- [1]
      9, -- [2]
      3, -- [3]
      47517, -- [4]
    }, -- [26]
    {
      135923, -- [1]
      8, -- [2]
      1, -- [3]
      57472, -- [4]
    }, -- [27]
    {
      135940, -- [1]
      5, -- [2]
      1, -- [3]
      33202, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      135928, -- [1]
      3, -- [2]
      4, -- [3]
      15363, -- [4]
    }, -- [41]
    {
      135967, -- [1]
      1, -- [2]
      3, -- [3]
      15011, -- [4]
    }, -- [42]
    {
      135977, -- [1]
      5, -- [2]
      3, -- [3]
      15031, -- [4]
    }, -- [43]
    {
      135973, -- [1]
      4, -- [2]
      3, -- [3]
      15017, -- [4]
    }, -- [44]
    {
      136057, -- [1]
      6, -- [2]
      3, -- [3]
      15356, -- [4]
    }, -- [45]
    {
      135953, -- [1]
      1, -- [2]
      2, -- [3]
      17191, -- [4]
    }, -- [46]
    {
      135916, -- [1]
      4, -- [2]
      2, -- [3]
      15014, -- [4]
    }, -- [47]
    {
      135918, -- [1]
      1, -- [2]
      1, -- [3]
      15012, -- [4]
    }, -- [48]
    {
      135976, -- [1]
      2, -- [2]
      2, -- [3]
      27904, -- [4]
    }, -- [49]
    {
      135943, -- [1]
      5, -- [2]
      1, -- [3]
      15018, -- [4]
    }, -- [50]
    {
      135954, -- [1]
      3, -- [2]
      1, -- [3]
      19236, -- [4]
    }, -- [51]
    {
      135971, -- [1]
      2, -- [2]
      3, -- [3]
      18535, -- [4]
    }, -- [52]
    {
      132864, -- [1]
      5, -- [2]
      2, -- [3]
      20711, -- [4]
    }, -- [53]
    {
      135949, -- [1]
      4, -- [2]
      1, -- [3]
      27790, -- [4]
    }, -- [54]
    {
      135877, -- [1]
      3, -- [2]
      2, -- [3]
      27816, -- [4]
    }, -- [55]
    {
      135980, -- [1]
      7, -- [2]
      2, -- [3]
      724, -- [4]
    }, -- [56]
    {
      135878, -- [1]
      7, -- [2]
      3, -- [3]
      33146, -- [4]
    }, -- [57]
    {
      135981, -- [1]
      6, -- [2]
      1, -- [3]
      33154, -- [4]
    }, -- [58]
    {
      135913, -- [1]
      8, -- [2]
      2, -- [3]
      33162, -- [4]
    }, -- [59]
    {
      135905, -- [1]
      7, -- [2]
      1, -- [3]
      34860, -- [4]
    }, -- [60]
    {
      135887, -- [1]
      9, -- [2]
      2, -- [3]
      34861, -- [4]
    }, -- [61]
    {
      236254, -- [1]
      9, -- [2]
      1, -- [3]
      63543, -- [4]
    }, -- [62]
    {
      237550, -- [1]
      9, -- [2]
      3, -- [3]
      47560, -- [4]
    }, -- [63]
    {
      237549, -- [1]
      8, -- [2]
      3, -- [3]
      63737, -- [4]
    }, -- [64]
    {
      237541, -- [1]
      10, -- [2]
      2, -- [3]
      47567, -- [4]
    }, -- [65]
    {
      237542, -- [1]
      11, -- [2]
      2, -- [3]
      47788, -- [4]
    }, -- [66]
    {
      135982, -- [1]
      8, -- [2]
      1, -- [3]
      64129, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136123, -- [1]
      4, -- [2]
      4, -- [3]
      15332, -- [4]
    }, -- [81]
    {
      136223, -- [1]
      1, -- [2]
      3, -- [3]
      15310, -- [4]
    }, -- [82]
    {
      136126, -- [1]
      2, -- [2]
      3, -- [3]
      15328, -- [4]
    }, -- [83]
    {
      136188, -- [1]
      1, -- [2]
      1, -- [3]
      15336, -- [4]
    }, -- [84]
    {
      136205, -- [1]
      2, -- [2]
      1, -- [3]
      15320, -- [4]
    }, -- [85]
    {
      136224, -- [1]
      3, -- [2]
      2, -- [3]
      15316, -- [4]
    }, -- [86]
    {
      136207, -- [1]
      2, -- [2]
      2, -- [3]
      15317, -- [4]
    }, -- [87]
    {
      135994, -- [1]
      4, -- [2]
      2, -- [3]
      15311, -- [4]
    }, -- [88]
    {
      136230, -- [1]
      5, -- [2]
      2, -- [3]
      15286, -- [4]
    }, -- [89]
    {
      136208, -- [1]
      3, -- [2]
      3, -- [3]
      15407, -- [4]
    }, -- [90]
    {
      136200, -- [1]
      7, -- [2]
      2, -- [3]
      15473, -- [4]
    }, -- [91]
    {
      136164, -- [1]
      5, -- [2]
      1, -- [3]
      15487, -- [4]
    }, -- [92]
    {
      136184, -- [1]
      3, -- [2]
      1, -- [3]
      15448, -- [4]
    }, -- [93]
    {
      136130, -- [1]
      4, -- [2]
      3, -- [3]
      17323, -- [4]
    }, -- [94]
    {
      136165, -- [1]
      5, -- [2]
      3, -- [3]
      27840, -- [4]
    }, -- [95]
    {
      136035, -- [1]
      5, -- [2]
      4, -- [3]
      33215, -- [4]
    }, -- [96]
    {
      136204, -- [1]
      7, -- [2]
      3, -- [3]
      33225, -- [4]
    }, -- [97]
    {
      135978, -- [1]
      9, -- [2]
      2, -- [3]
      34914, -- [4]
    }, -- [98]
    {
      237569, -- [1]
      6, -- [2]
      1, -- [3]
      33371, -- [4]
    }, -- [99]
    {
      136176, -- [1]
      8, -- [2]
      3, -- [3]
      33193, -- [4]
    }, -- [100]
    {
      136221, -- [1]
      8, -- [2]
      1, -- [3]
      47570, -- [4]
    }, -- [101]
    {
      237566, -- [1]
      10, -- [2]
      3, -- [3]
      51167, -- [4]
    }, -- [102]
    {
      237568, -- [1]
      9, -- [2]
      1, -- [3]
      64044, -- [4]
    }, -- [103]
    {
      237567, -- [1]
      9, -- [2]
      3, -- [3]
      47582, -- [4]
    }, -- [104]
    {
      237563, -- [1]
      11, -- [2]
      2, -- [3]
      47585, -- [4]
    }, -- [105]
    {
      136188, -- [1]
      1, -- [2]
      2, -- [3]
      15338, -- [4]
    }, -- [106]
    {
      252996, -- [1]
      6, -- [2]
      3, -- [3]
      63627, -- [4]
    }, -- [107]
    [121] = {
      "PriestDiscipline", -- [1]
      "PriestHoly", -- [2]
      "PriestShadow", -- [3]
    },
  },
  ["WARLOCK"] = {
    {
      136157, -- [1]
      3, -- [2]
      2, -- [3]
      17785, -- [4]
    }, -- [1]
    {
      136223, -- [1]
      4, -- [2]
      2, -- [3]
      18095, -- [4]
    }, -- [2]
    {
      136118, -- [1]
      1, -- [2]
      3, -- [3]
      17814, -- [4]
    }, -- [3]
    {
      136169, -- [1]
      2, -- [2]
      4, -- [3]
      17805, -- [4]
    }, -- [4]
    {
      136230, -- [1]
      1, -- [2]
      2, -- [3]
      18176, -- [4]
    }, -- [5]
    {
      136138, -- [1]
      2, -- [2]
      1, -- [3]
      18180, -- [4]
    }, -- [6]
    {
      136126, -- [1]
      2, -- [2]
      3, -- [3]
      18183, -- [4]
    }, -- [7]
    {
      136127, -- [1]
      4, -- [2]
      1, -- [3]
      18219, -- [4]
    }, -- [8]
    {
      136141, -- [1]
      7, -- [2]
      3, -- [3]
      18220, -- [4]
    }, -- [9]
    {
      136188, -- [1]
      5, -- [2]
      2, -- [3]
      63108, -- [4]
    }, -- [10]
    {
      136195, -- [1]
      6, -- [2]
      2, -- [3]
      18275, -- [4]
    }, -- [11]
    {
      136132, -- [1]
      3, -- [2]
      3, -- [3]
      18288, -- [4]
    }, -- [12]
    {
      136162, -- [1]
      5, -- [2]
      3, -- [3]
      18223, -- [4]
    }, -- [13]
    {
      136163, -- [1]
      2, -- [2]
      2, -- [3]
      18372, -- [4]
    }, -- [14]
    {
      136139, -- [1]
      1, -- [2]
      1, -- [3]
      18829, -- [4]
    }, -- [15]
    {
      136137, -- [1]
      8, -- [2]
      3, -- [3]
      32484, -- [4]
    }, -- [16]
    {
      136147, -- [1]
      8, -- [2]
      1, -- [3]
      30057, -- [4]
    }, -- [17]
    {
      136180, -- [1]
      7, -- [2]
      2, -- [3]
      30064, -- [4]
    }, -- [18]
    {
      136228, -- [1]
      9, -- [2]
      2, -- [3]
      30108, -- [4]
    }, -- [19]
    {
      136198, -- [1]
      5, -- [2]
      1, -- [3]
      32394, -- [4]
    }, -- [20]
    {
      136118, -- [1]
      4, -- [2]
      4, -- [3]
      32383, -- [4]
    }, -- [21]
    {
      136217, -- [1]
      6, -- [2]
      1, -- [3]
      54038, -- [4]
    }, -- [22]
    {
      237557, -- [1]
      9, -- [2]
      1, -- [3]
      47200, -- [4]
    }, -- [23]
    {
      236296, -- [1]
      10, -- [2]
      2, -- [3]
      47205, -- [4]
    }, -- [24]
    {
      236295, -- [1]
      7, -- [2]
      1, -- [3]
      47197, -- [4]
    }, -- [25]
    {
      236298, -- [1]
      11, -- [2]
      2, -- [3]
      48181, -- [4]
    }, -- [26]
    {
      136183, -- [1]
      3, -- [2]
      1, -- [3]
      53759, -- [4]
    }, -- [27]
    {
      136227, -- [1]
      9, -- [2]
      3, -- [3]
      58435, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      135230, -- [1]
      1, -- [2]
      1, -- [3]
      18693, -- [4]
    }, -- [41]
    {
      136218, -- [1]
      1, -- [2]
      2, -- [3]
      18696, -- [4]
    }, -- [42]
    {
      136172, -- [1]
      1, -- [2]
      3, -- [3]
      18699, -- [4]
    }, -- [43]
    {
      136168, -- [1]
      2, -- [2]
      1, -- [3]
      18704, -- [4]
    }, -- [44]
    {
      136221, -- [1]
      2, -- [2]
      2, -- [3]
      18707, -- [4]
    }, -- [45]
    {
      136082, -- [1]
      3, -- [2]
      3, -- [3]
      18708, -- [4]
    }, -- [46]
    {
      136164, -- [1]
      4, -- [2]
      3, -- [3]
      18710, -- [4]
    }, -- [47]
    {
      135932, -- [1]
      2, -- [2]
      3, -- [3]
      18744, -- [4]
    }, -- [48]
    {
      136220, -- [1]
      3, -- [2]
      1, -- [3]
      18756, -- [4]
    }, -- [49]
    {
      136203, -- [1]
      6, -- [2]
      2, -- [3]
      23825, -- [4]
    }, -- [50]
    {
      132386, -- [1]
      5, -- [2]
      3, -- [3]
      18768, -- [4]
    }, -- [51]
    {
      136206, -- [1]
      4, -- [2]
      2, -- [3]
      18773, -- [4]
    }, -- [52]
    {
      136165, -- [1]
      7, -- [2]
      3, -- [3]
      35693, -- [4]
    }, -- [53]
    {
      136171, -- [1]
      5, -- [2]
      1, -- [3]
      30326, -- [4]
    }, -- [54]
    {
      136160, -- [1]
      3, -- [2]
      2, -- [3]
      19028, -- [4]
    }, -- [55]
    {
      236301, -- [1]
      6, -- [2]
      3, -- [3]
      47247, -- [4]
    }, -- [56]
    {
      136185, -- [1]
      3, -- [2]
      4, -- [3]
      30145, -- [4]
    }, -- [57]
    {
      136216, -- [1]
      9, -- [2]
      2, -- [3]
      30146, -- [4]
    }, -- [58]
    {
      136150, -- [1]
      8, -- [2]
      2, -- [3]
      30248, -- [4]
    }, -- [59]
    {
      136149, -- [1]
      7, -- [2]
      1, -- [3]
      30321, -- [4]
    }, -- [60]
    {
      236292, -- [1]
      7, -- [2]
      2, -- [3]
      47193, -- [4]
    }, -- [61]
    {
      236299, -- [1]
      9, -- [2]
      1, -- [3]
      54349, -- [4]
    }, -- [62]
    {
      237564, -- [1]
      1, -- [2]
      4, -- [3]
      47231, -- [4]
    }, -- [63]
    {
      237561, -- [1]
      9, -- [2]
      3, -- [3]
      63123, -- [4]
    }, -- [64]
    {
      237562, -- [1]
      10, -- [2]
      2, -- [3]
      47240, -- [4]
    }, -- [65]
    {
      237558, -- [1]
      11, -- [2]
      2, -- [3]
      59672, -- [4]
    }, -- [66]
    {
      135808, -- [1]
      8, -- [2]
      3, -- [3]
      63158, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      135831, -- [1]
      2, -- [2]
      3, -- [3]
      17780, -- [4]
    }, -- [81]
    {
      136146, -- [1]
      1, -- [2]
      3, -- [3]
      17792, -- [4]
    }, -- [82]
    {
      136197, -- [1]
      1, -- [2]
      2, -- [3]
      17803, -- [4]
    }, -- [83]
    {
      135817, -- [1]
      5, -- [2]
      2, -- [3]
      17834, -- [4]
    }, -- [84]
    {
      136191, -- [1]
      3, -- [2]
      2, -- [3]
      17877, -- [4]
    }, -- [85]
    {
      136133, -- [1]
      4, -- [2]
      2, -- [3]
      17918, -- [4]
    }, -- [86]
    {
      135827, -- [1]
      4, -- [2]
      4, -- [3]
      17930, -- [4]
    }, -- [87]
    {
      135826, -- [1]
      6, -- [2]
      3, -- [3]
      17958, -- [4]
    }, -- [88]
    {
      136207, -- [1]
      3, -- [2]
      3, -- [3]
      59741, -- [4]
    }, -- [89]
    {
      135807, -- [1]
      7, -- [2]
      2, -- [3]
      17962, -- [4]
    }, -- [90]
    {
      135813, -- [1]
      5, -- [2]
      3, -- [3]
      18130, -- [4]
    }, -- [91]
    {
      135805, -- [1]
      2, -- [2]
      1, -- [3]
      18120, -- [4]
    }, -- [92]
    {
      135809, -- [1]
      3, -- [2]
      1, -- [3]
      18127, -- [4]
    }, -- [93]
    {
      135819, -- [1]
      4, -- [2]
      1, -- [3]
      18136, -- [4]
    }, -- [94]
    {
      135830, -- [1]
      7, -- [2]
      4, -- [3]
      63245, -- [4]
    }, -- [95]
    {
      136201, -- [1]
      9, -- [2]
      2, -- [3]
      30283, -- [4]
    }, -- [96]
    {
      136196, -- [1]
      8, -- [2]
      2, -- [3]
      30292, -- [4]
    }, -- [97]
    {
      136214, -- [1]
      7, -- [2]
      3, -- [3]
      30296, -- [4]
    }, -- [98]
    {
      136178, -- [1]
      6, -- [2]
      1, -- [3]
      30302, -- [4]
    }, -- [99]
    {
      135823, -- [1]
      5, -- [2]
      1, -- [3]
      34939, -- [4]
    }, -- [100]
    {
      132221, -- [1]
      2, -- [2]
      2, -- [3]
      63351, -- [4]
    }, -- [101]
    {
      236290, -- [1]
      9, -- [2]
      1, -- [3]
      47260, -- [4]
    }, -- [102]
    {
      236300, -- [1]
      8, -- [2]
      3, -- [3]
      54118, -- [4]
    }, -- [103]
    {
      236297, -- [1]
      10, -- [2]
      2, -- [3]
      47270, -- [4]
    }, -- [104]
    {
      236291, -- [1]
      11, -- [2]
      2, -- [3]
      50796, -- [4]
    }, -- [105]
    {
      236294, -- [1]
      9, -- [2]
      3, -- [3]
      47223, -- [4]
    }, -- [106]
    [121] = {
      "WarlockCurses", -- [1]
      "WarlockSummoning", -- [2]
      "WarlockDestruction", -- [3]
    },
  },
  ["HUNTER"] = {
    {
      132159, -- [1]
      2, -- [2]
      2, -- [3]
      19551, -- [4]
    }, -- [1]
    {
      136076, -- [1]
      1, -- [2]
      2, -- [3]
      19556, -- [4]
    }, -- [2]
    {
      132242, -- [1]
      3, -- [2]
      1, -- [3]
      19560, -- [4]
    }, -- [3]
    {
      132179, -- [1]
      4, -- [2]
      2, -- [3]
      19573, -- [4]
    }, -- [4]
    {
      132127, -- [1]
      7, -- [2]
      2, -- [3]
      19574, -- [4]
    }, -- [5]
    {
      132111, -- [1]
      5, -- [2]
      2, -- [3]
      19577, -- [4]
    }, -- [6]
    {
      132121, -- [1]
      5, -- [2]
      1, -- [3]
      20895, -- [4]
    }, -- [7]
    {
      136080, -- [1]
      1, -- [2]
      3, -- [3]
      19587, -- [4]
    }, -- [8]
    {
      136006, -- [1]
      5, -- [2]
      4, -- [3]
      19592, -- [4]
    }, -- [9]
    {
      134297, -- [1]
      4, -- [2]
      3, -- [3]
      19602, -- [4]
    }, -- [10]
    {
      134355, -- [1]
      2, -- [2]
      3, -- [3]
      19612, -- [4]
    }, -- [11]
    {
      132091, -- [1]
      3, -- [2]
      3, -- [3]
      19620, -- [4]
    }, -- [12]
    {
      134296, -- [1]
      6, -- [2]
      3, -- [3]
      19625, -- [4]
    }, -- [13]
    {
      132210, -- [1]
      2, -- [2]
      1, -- [3]
      35030, -- [4]
    }, -- [14]
    {
      132163, -- [1]
      2, -- [2]
      4, -- [3]
      19575, -- [4]
    }, -- [15]
    {
      132158, -- [1]
      6, -- [2]
      1, -- [3]
      34454, -- [4]
    }, -- [16]
    {
      132173, -- [1]
      7, -- [2]
      1, -- [3]
      34460, -- [4]
    }, -- [17]
    {
      132167, -- [1]
      7, -- [2]
      3, -- [3]
      34465, -- [4]
    }, -- [18]
    {
      132209, -- [1]
      8, -- [2]
      3, -- [3]
      34470, -- [4]
    }, -- [19]
    {
      132166, -- [1]
      9, -- [2]
      2, -- [3]
      34692, -- [4]
    }, -- [20]
    {
      236184, -- [1]
      8, -- [2]
      1, -- [3]
      53253, -- [4]
    }, -- [21]
    {
      236177, -- [1]
      9, -- [2]
      3, -- [3]
      53260, -- [4]
    }, -- [22]
    {
      236172, -- [1]
      3, -- [2]
      2, -- [3]
      53265, -- [4]
    }, -- [23]
    {
      236175, -- [1]
      11, -- [2]
      2, -- [3]
      53270, -- [4]
    }, -- [24]
    {
      236186, -- [1]
      9, -- [2]
      1, -- [3]
      53264, -- [4]
    }, -- [25]
    {
      236202, -- [1]
      10, -- [2]
      2, -- [3]
      56318, -- [4]
    }, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      135860, -- [1]
      1, -- [2]
      1, -- [3]
      19412, -- [4]
    }, -- [41]
    {
      135865, -- [1]
      4, -- [2]
      3, -- [3]
      19420, -- [4]
    }, -- [42]
    {
      132212, -- [1]
      2, -- [2]
      2, -- [3]
      19423, -- [4]
    }, -- [43]
    {
      132312, -- [1]
      1, -- [2]
      3, -- [3]
      19431, -- [4]
    }, -- [44]
    {
      135130, -- [1]
      3, -- [2]
      3, -- [3]
      19434, -- [4]
    }, -- [45]
    {
      132218, -- [1]
      3, -- [2]
      2, -- [3]
      19456, -- [4]
    }, -- [46]
    {
      132330, -- [1]
      5, -- [2]
      3, -- [3]
      24691, -- [4]
    }, -- [47]
    {
      132204, -- [1]
      4, -- [2]
      2, -- [3]
      19466, -- [4]
    }, -- [48]
    {
      132271, -- [1]
      2, -- [2]
      3, -- [3]
      19490, -- [4]
    }, -- [49]
    {
      135753, -- [1]
      5, -- [2]
      1, -- [3]
      35102, -- [4]
    }, -- [50]
    {
      132206, -- [1]
      5, -- [2]
      2, -- [3]
      23989, -- [4]
    }, -- [51]
    {
      132329, -- [1]
      7, -- [2]
      2, -- [3]
      19506, -- [4]
    }, -- [52]
    {
      135615, -- [1]
      6, -- [2]
      4, -- [3]
      19509, -- [4]
    }, -- [53]
    {
      132168, -- [1]
      6, -- [2]
      1, -- [3]
      34476, -- [4]
    }, -- [54]
    {
      132217, -- [1]
      2, -- [2]
      1, -- [3]
      34484, -- [4]
    }, -- [55]
    {
      132177, -- [1]
      8, -- [2]
      2, -- [3]
      34489, -- [4]
    }, -- [56]
    {
      132323, -- [1]
      9, -- [2]
      2, -- [3]
      34490, -- [4]
    }, -- [57]
    {
      132174, -- [1]
      3, -- [2]
      1, -- [3]
      34954, -- [4]
    }, -- [58]
    {
      132205, -- [1]
      3, -- [2]
      4, -- [3]
      34949, -- [4]
    }, -- [59]
    {
      132330, -- [1]
      7, -- [2]
      3, -- [3]
      35111, -- [4]
    }, -- [60]
    {
      236198, -- [1]
      7, -- [2]
      1, -- [3]
      53238, -- [4]
    }, -- [61]
    {
      236201, -- [1]
      8, -- [2]
      3, -- [3]
      53232, -- [4]
    }, -- [62]
    {
      236204, -- [1]
      9, -- [2]
      1, -- [3]
      53217, -- [4]
    }, -- [63]
    {
      236182, -- [1]
      9, -- [2]
      3, -- [3]
      53224, -- [4]
    }, -- [64]
    {
      236173, -- [1]
      10, -- [2]
      2, -- [3]
      53246, -- [4]
    }, -- [65]
    {
      236176, -- [1]
      11, -- [2]
      2, -- [3]
      53209, -- [4]
    }, -- [66]
    {
      236179, -- [1]
      1, -- [2]
      2, -- [3]
      53622, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136047, -- [1]
      6, -- [2]
      1, -- [3]
      24297, -- [4]
    }, -- [81]
    {
      136100, -- [1]
      2, -- [2]
      2, -- [3]
      19388, -- [4]
    }, -- [82]
    {
      132149, -- [1]
      2, -- [2]
      3, -- [3]
      63458, -- [4]
    }, -- [83]
    {
      236185, -- [1]
      4, -- [2]
      4, -- [3]
      56344, -- [4]
    }, -- [84]
    {
      132293, -- [1]
      3, -- [2]
      4, -- [3]
      19287, -- [4]
    }, -- [85]
    {
      132219, -- [1]
      2, -- [2]
      1, -- [3]
      24283, -- [4]
    }, -- [86]
    {
      132269, -- [1]
      3, -- [2]
      3, -- [3]
      19298, -- [4]
    }, -- [87]
    {
      132336, -- [1]
      5, -- [2]
      3, -- [3]
      19306, -- [4]
    }, -- [88]
    {
      135881, -- [1]
      5, -- [2]
      2, -- [3]
      19373, -- [4]
    }, -- [89]
    {
      136181, -- [1]
      9, -- [2]
      2, -- [3]
      3674, -- [4]
    }, -- [90]
    {
      135125, -- [1]
      7, -- [2]
      2, -- [3]
      19386, -- [4]
    }, -- [91]
    {
      132277, -- [1]
      1, -- [2]
      3, -- [3]
      19160, -- [4]
    }, -- [92]
    {
      136223, -- [1]
      3, -- [2]
      1, -- [3]
      19259, -- [4]
    }, -- [93]
    {
      236183, -- [1]
      1, -- [2]
      1, -- [3]
      52788, -- [4]
    }, -- [94]
    {
      132207, -- [1]
      6, -- [2]
      3, -- [3]
      34493, -- [4]
    }, -- [95]
    {
      132214, -- [1]
      2, -- [2]
      4, -- [3]
      34496, -- [4]
    }, -- [96]
    {
      132216, -- [1]
      7, -- [2]
      3, -- [3]
      34499, -- [4]
    }, -- [97]
    {
      132295, -- [1]
      7, -- [2]
      1, -- [3]
      34503, -- [4]
    }, -- [98]
    {
      132178, -- [1]
      8, -- [2]
      1, -- [3]
      34839, -- [4]
    }, -- [99]
    {
      132153, -- [1]
      3, -- [2]
      2, -- [3]
      19503, -- [4]
    }, -- [100]
    {
      132327, -- [1]
      1, -- [2]
      2, -- [3]
      19500, -- [4]
    }, -- [101]
    {
      236200, -- [1]
      8, -- [2]
      2, -- [3]
      53297, -- [4]
    }, -- [102]
    {
      236199, -- [1]
      9, -- [2]
      1, -- [3]
      53299, -- [4]
    }, -- [103]
    {
      236187, -- [1]
      9, -- [2]
      4, -- [3]
      53304, -- [4]
    }, -- [104]
    {
      236181, -- [1]
      10, -- [2]
      3, -- [3]
      53292, -- [4]
    }, -- [105]
    {
      236178, -- [1]
      11, -- [2]
      2, -- [3]
      53301, -- [4]
    }, -- [106]
    {
      236180, -- [1]
      5, -- [2]
      1, -- [3]
      56341, -- [4]
    }, -- [107]
    {
      133713, -- [1]
      4, -- [2]
      2, -- [3]
      56337, -- [4]
    }, -- [108]
    [121] = {
      "HunterBeastMastery", -- [1]
      "HunterMarksmanship", -- [2]
      "HunterSurvival", -- [3]
    },
  },
  ["DRUID"] = {
    {
      136006, -- [1]
      1, -- [2]
      2, -- [3]
      16818, -- [4]
    }, -- [1]
    {
      136096, -- [1]
      2, -- [2]
      4, -- [3]
      16822, -- [4]
    }, -- [2]
    {
      136065, -- [1]
      3, -- [2]
      4, -- [3]
      16820, -- [4]
    }, -- [3]
    {
      136104, -- [1]
      3, -- [2]
      1, -- [3]
      16840, -- [4]
    }, -- [4]
    {
      136087, -- [1]
      2, -- [2]
      1, -- [3]
      16847, -- [4]
    }, -- [5]
    {
      135753, -- [1]
      4, -- [2]
      3, -- [3]
      16924, -- [4]
    }, -- [6]
    {
      136045, -- [1]
      5, -- [2]
      2, -- [3]
      5570, -- [4]
    }, -- [7]
    {
      136062, -- [1]
      3, -- [2]
      2, -- [3]
      61346, -- [4]
    }, -- [8]
    {
      136057, -- [1]
      6, -- [2]
      2, -- [3]
      16899, -- [4]
    }, -- [9]
    {
      136075, -- [1]
      4, -- [2]
      2, -- [3]
      16913, -- [4]
    }, -- [10]
    {
      136036, -- [1]
      7, -- [2]
      2, -- [3]
      24858, -- [4]
    }, -- [11]
    {
      132132, -- [1]
      5, -- [2]
      1, -- [3]
      33591, -- [4]
    }, -- [12]
    {
      132113, -- [1]
      6, -- [2]
      3, -- [3]
      33596, -- [4]
    }, -- [13]
    {
      132123, -- [1]
      6, -- [2]
      1, -- [3]
      33956, -- [4]
    }, -- [14]
    {
      136033, -- [1]
      7, -- [2]
      4, -- [3]
      33602, -- [4]
    }, -- [15]
    {
      132146, -- [1]
      8, -- [2]
      3, -- [3]
      33607, -- [4]
    }, -- [16]
    {
      132129, -- [1]
      9, -- [2]
      3, -- [3]
      33831, -- [4]
    }, -- [17]
    {
      135138, -- [1]
      2, -- [2]
      2, -- [3]
      35364, -- [4]
    }, -- [18]
    {
      236156, -- [1]
      7, -- [2]
      3, -- [3]
      48396, -- [4]
    }, -- [19]
    {
      236163, -- [1]
      8, -- [2]
      1, -- [3]
      48393, -- [4]
    }, -- [20]
    {
      236170, -- [1]
      9, -- [2]
      2, -- [3]
      50516, -- [4]
    }, -- [21]
    {
      236151, -- [1]
      9, -- [2]
      1, -- [3]
      48525, -- [4]
    }, -- [22]
    {
      236154, -- [1]
      9, -- [2]
      4, -- [3]
      48514, -- [4]
    }, -- [23]
    {
      236168, -- [1]
      11, -- [2]
      2, -- [3]
      48505, -- [4]
    }, -- [24]
    {
      236150, -- [1]
      10, -- [2]
      2, -- [3]
      48511, -- [4]
    }, -- [25]
    {
      135730, -- [1]
      1, -- [2]
      3, -- [3]
      57814, -- [4]
    }, -- [26]
    {
      136045, -- [1]
      5, -- [2]
      3, -- [3]
      57851, -- [4]
    }, -- [27]
    {
      136060, -- [1]
      3, -- [2]
      3, -- [3]
      57865, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      134355, -- [1]
      2, -- [2]
      3, -- [3]
      16931, -- [4]
    }, -- [41]
    {
      132121, -- [1]
      1, -- [2]
      3, -- [3]
      16862, -- [4]
    }, -- [42]
    {
      132190, -- [1]
      1, -- [2]
      2, -- [3]
      16938, -- [4]
    }, -- [43]
    {
      132114, -- [1]
      5, -- [2]
      1, -- [3]
      16941, -- [4]
    }, -- [44]
    {
      134297, -- [1]
      3, -- [2]
      3, -- [3]
      16944, -- [4]
    }, -- [45]
    {
      132089, -- [1]
      2, -- [2]
      1, -- [3]
      16949, -- [4]
    }, -- [46]
    {
      132278, -- [1]
      4, -- [2]
      3, -- [3]
      37117, -- [4]
    }, -- [47]
    {
      136231, -- [1]
      4, -- [2]
      1, -- [3]
      16968, -- [4]
    }, -- [48]
    {
      132185, -- [1]
      4, -- [2]
      2, -- [3]
      16975, -- [4]
    }, -- [49]
    {
      132183, -- [1]
      5, -- [2]
      3, -- [3]
      49377, -- [4]
    }, -- [50]
    {
      132141, -- [1]
      2, -- [2]
      2, -- [3]
      16999, -- [4]
    }, -- [51]
    {
      136095, -- [1]
      3, -- [2]
      1, -- [3]
      24866, -- [4]
    }, -- [52]
    {
      135879, -- [1]
      6, -- [2]
      2, -- [3]
      24894, -- [4]
    }, -- [53]
    {
      136112, -- [1]
      7, -- [2]
      2, -- [3]
      17007, -- [4]
    }, -- [54]
    {
      236169, -- [1]
      3, -- [2]
      2, -- [3]
      61336, -- [4]
    }, -- [55]
    {
      132130, -- [1]
      5, -- [2]
      4, -- [3]
      33873, -- [4]
    }, -- [56]
    {
      132139, -- [1]
      7, -- [2]
      4, -- [3]
      33957, -- [4]
    }, -- [57]
    {
      132126, -- [1]
      6, -- [2]
      3, -- [3]
      33856, -- [4]
    }, -- [58]
    {
      132138, -- [1]
      8, -- [2]
      3, -- [3]
      33867, -- [4]
    }, -- [59]
    {
      132135, -- [1]
      9, -- [2]
      2, -- [3]
      33917, -- [4]
    }, -- [60]
    {
      136112, -- [1]
      7, -- [2]
      3, -- [3]
      34300, -- [4]
    }, -- [61]
    {
      236165, -- [1]
      4, -- [2]
      4, -- [3]
      48410, -- [4]
    }, -- [62]
    {
      236164, -- [1]
      10, -- [2]
      2, -- [3]
      51269, -- [4]
    }, -- [63]
    {
      236158, -- [1]
      8, -- [2]
      4, -- [3]
      48485, -- [4]
    }, -- [64]
    {
      132135, -- [1]
      9, -- [2]
      3, -- [3]
      48491, -- [4]
    }, -- [65]
    {
      236159, -- [1]
      9, -- [2]
      1, -- [3]
      48495, -- [4]
    }, -- [66]
    {
      236149, -- [1]
      11, -- [2]
      2, -- [3]
      50334, -- [4]
    }, -- [67]
    {
      132117, -- [1]
      8, -- [2]
      1, -- [3]
      57877, -- [4]
    }, -- [68]
    {
      132091, -- [1]
      6, -- [2]
      1, -- [3]
      57881, -- [4]
    }, -- [69]
    {
      132140, -- [1]
      10, -- [2]
      3, -- [3]
      63503, -- [4]
    }, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136078, -- [1]
      1, -- [2]
      1, -- [3]
      17051, -- [4]
    }, -- [81]
    {
      135881, -- [1]
      1, -- [2]
      3, -- [3]
      17061, -- [4]
    }, -- [82]
    {
      136042, -- [1]
      1, -- [2]
      2, -- [3]
      17066, -- [4]
    }, -- [83]
    {
      136041, -- [1]
      2, -- [2]
      1, -- [3]
      17073, -- [4]
    }, -- [84]
    {
      136085, -- [1]
      6, -- [2]
      3, -- [3]
      17078, -- [4]
    }, -- [85]
    {
      136116, -- [1]
      2, -- [2]
      3, -- [3]
      16835, -- [4]
    }, -- [86]
    {
      136017, -- [1]
      3, -- [2]
      2, -- [3]
      16864, -- [4]
    }, -- [87]
    {
      136074, -- [1]
      5, -- [2]
      2, -- [3]
      24946, -- [4]
    }, -- [88]
    {
      135863, -- [1]
      3, -- [2]
      1, -- [3]
      17108, -- [4]
    }, -- [89]
    {
      136081, -- [1]
      4, -- [2]
      3, -- [3]
      17113, -- [4]
    }, -- [90]
    {
      136076, -- [1]
      5, -- [2]
      1, -- [3]
      17116, -- [4]
    }, -- [91]
    {
      132150, -- [1]
      2, -- [2]
      2, -- [3]
      17120, -- [4]
    }, -- [92]
    {
      136107, -- [1]
      5, -- [2]
      4, -- [3]
      17124, -- [4]
    }, -- [93]
    {
      135900, -- [1]
      4, -- [2]
      2, -- [3]
      24972, -- [4]
    }, -- [94]
    {
      134914, -- [1]
      7, -- [2]
      2, -- [3]
      18562, -- [4]
    }, -- [95]
    {
      132125, -- [1]
      6, -- [2]
      1, -- [3]
      33880, -- [4]
    }, -- [96]
    {
      132124, -- [1]
      8, -- [2]
      2, -- [3]
      33890, -- [4]
    }, -- [97]
    {
      132137, -- [1]
      7, -- [2]
      3, -- [3]
      33883, -- [4]
    }, -- [98]
    {
      132145, -- [1]
      9, -- [2]
      2, -- [3]
      65139, -- [4]
    }, -- [99]
    {
      136037, -- [1]
      7, -- [2]
      1, -- [3]
      34153, -- [4]
    }, -- [100]
    {
      236161, -- [1]
      3, -- [2]
      3, -- [3]
      48412, -- [4]
    }, -- [101]
    {
      236160, -- [1]
      10, -- [2]
      3, -- [3]
      51183, -- [4]
    }, -- [102]
    {
      236153, -- [1]
      11, -- [2]
      2, -- [3]
      48438, -- [4]
    }, -- [103]
    {
      236155, -- [1]
      8, -- [2]
      3, -- [3]
      48500, -- [4]
    }, -- [104]
    {
      236166, -- [1]
      9, -- [2]
      1, -- [3]
      48545, -- [4]
    }, -- [105]
    {
      236157, -- [1]
      9, -- [2]
      3, -- [3]
      48537, -- [4]
    }, -- [106]
    {
      136097, -- [1]
      10, -- [2]
      1, -- [3]
      63411, -- [4]
    }, -- [107]
    [121] = {
      "DruidBalance", -- [1]
      "DruidFeralCombat", -- [2]
      "DruidRestoration", -- [3]
    },
  },
  ["PALADIN"] = {
    {
      135736, -- [1]
      1, -- [2]
      2, -- [3]
      20208, -- [4]
    }, -- [1]
    {
      135915, -- [1]
      5, -- [2]
      2, -- [3]
      20216, -- [4]
    }, -- [2]
    {
      135872, -- [1]
      3, -- [2]
      1, -- [3]
      31821, -- [4]
    }, -- [3]
    {
      135928, -- [1]
      3, -- [2]
      3, -- [3]
      20235, -- [4]
    }, -- [4]
    {
      135920, -- [1]
      2, -- [2]
      1, -- [3]
      20239, -- [4]
    }, -- [5]
    {
      135970, -- [1]
      4, -- [2]
      3, -- [3]
      20245, -- [4]
    }, -- [6]
    {
      136090, -- [1]
      2, -- [2]
      2, -- [3]
      20261, -- [4]
    }, -- [7]
    {
      135933, -- [1]
      4, -- [2]
      1, -- [3]
      20256, -- [4]
    }, -- [8]
    {
      135913, -- [1]
      3, -- [2]
      2, -- [3]
      20215, -- [4]
    }, -- [9]
    {
      132325, -- [1]
      1, -- [2]
      3, -- [3]
      20332, -- [4]
    }, -- [10]
    {
      135917, -- [1]
      5, -- [2]
      3, -- [3]
      20361, -- [4]
    }, -- [11]
    {
      135972, -- [1]
      7, -- [2]
      2, -- [3]
      20473, -- [4]
    }, -- [12]
    {
      135938, -- [1]
      6, -- [2]
      3, -- [3]
      25829, -- [4]
    }, -- [13]
    {
      135984, -- [1]
      2, -- [2]
      3, -- [3]
      25836, -- [4]
    }, -- [14]
    {
      135948, -- [1]
      5, -- [2]
      1, -- [3]
      31823, -- [4]
    }, -- [15]
    {
      135950, -- [1]
      6, -- [2]
      1, -- [3]
      31826, -- [4]
    }, -- [16]
    {
      135876, -- [1]
      7, -- [2]
      3, -- [3]
      31830, -- [4]
    }, -- [17]
    {
      135931, -- [1]
      7, -- [2]
      1, -- [3]
      31836, -- [4]
    }, -- [18]
    {
      135921, -- [1]
      8, -- [2]
      3, -- [3]
      31841, -- [4]
    }, -- [19]
    {
      135895, -- [1]
      9, -- [2]
      1, -- [3]
      31842, -- [4]
    }, -- [20]
    {
      236261, -- [1]
      8, -- [2]
      1, -- [3]
      53553, -- [4]
    }, -- [21]
    {
      236251, -- [1]
      10, -- [2]
      3, -- [3]
      53557, -- [4]
    }, -- [22]
    {
      236247, -- [1]
      11, -- [2]
      2, -- [3]
      53563, -- [4]
    }, -- [23]
    {
      236254, -- [1]
      10, -- [2]
      2, -- [3]
      53576, -- [4]
    }, -- [24]
    {
      236248, -- [1]
      4, -- [2]
      4, -- [3]
      53661, -- [4]
    }, -- [25]
    {
      236256, -- [1]
      9, -- [2]
      3, -- [3]
      54155, -- [4]
    }, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      132110, -- [1]
      8, -- [2]
      1, -- [3]
      20135, -- [4]
    }, -- [41]
    {
      135893, -- [1]
      4, -- [2]
      3, -- [3]
      20140, -- [4]
    }, -- [42]
    {
      135892, -- [1]
      3, -- [2]
      3, -- [3]
      20147, -- [4]
    }, -- [43]
    {
      135964, -- [1]
      2, -- [2]
      2, -- [3]
      20175, -- [4]
    }, -- [44]
    {
      135882, -- [1]
      5, -- [2]
      3, -- [3]
      20182, -- [4]
    }, -- [45]
    {
      135321, -- [1]
      6, -- [2]
      3, -- [3]
      20198, -- [4]
    }, -- [46]
    {
      135880, -- [1]
      7, -- [2]
      2, -- [3]
      20925, -- [4]
    }, -- [47]
    {
      136051, -- [1]
      5, -- [2]
      2, -- [3]
      20911, -- [4]
    }, -- [48]
    {
      135883, -- [1]
      1, -- [2]
      2, -- [3]
      63650, -- [4]
    }, -- [49]
    {
      135962, -- [1]
      3, -- [2]
      2, -- [3]
      20470, -- [4]
    }, -- [50]
    {
      135963, -- [1]
      4, -- [2]
      2, -- [3]
      20488, -- [4]
    }, -- [51]
    {
      135994, -- [1]
      2, -- [2]
      3, -- [3]
      20100, -- [4]
    }, -- [52]
    {
      135978, -- [1]
      2, -- [2]
      1, -- [3]
      53519, -- [4]
    }, -- [53]
    {
      135896, -- [1]
      6, -- [2]
      1, -- [3]
      31849, -- [4]
    }, -- [54]
    {
      135870, -- [1]
      7, -- [2]
      3, -- [3]
      31852, -- [4]
    }, -- [55]
    {
      135986, -- [1]
      8, -- [2]
      3, -- [3]
      31860, -- [4]
    }, -- [56]
    {
      135874, -- [1]
      9, -- [2]
      2, -- [3]
      31935, -- [4]
    }, -- [57]
    {
      132154, -- [1]
      1, -- [2]
      3, -- [3]
      20266, -- [4]
    }, -- [58]
    {
      236252, -- [1]
      9, -- [2]
      3, -- [3]
      53585, -- [4]
    }, -- [59]
    {
      236267, -- [1]
      9, -- [2]
      1, -- [3]
      53592, -- [4]
    }, -- [60]
    {
      236253, -- [1]
      11, -- [2]
      2, -- [3]
      53595, -- [4]
    }, -- [61]
    {
      236259, -- [1]
      10, -- [2]
      3, -- [3]
      53696, -- [4]
    }, -- [62]
    {
      236264, -- [1]
      10, -- [2]
      2, -- [3]
      53711, -- [4]
    }, -- [63]
    {
      253400, -- [1]
      3, -- [2]
      1, -- [3]
      64205, -- [4]
    }, -- [64]
    {
      253400, -- [1]
      4, -- [2]
      1, -- [3]
      53530, -- [4]
    }, -- [65]
    {
      135958, -- [1]
      7, -- [2]
      1, -- [3]
      33776, -- [4]
    }, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      135906, -- [1]
      2, -- [2]
      3, -- [3]
      20045, -- [4]
    }, -- [81]
    {
      132275, -- [1]
      6, -- [2]
      2, -- [3]
      20057, -- [4]
    }, -- [82]
    {
      132269, -- [1]
      1, -- [2]
      2, -- [3]
      20064, -- [4]
    }, -- [83]
    {
      135863, -- [1]
      1, -- [2]
      3, -- [3]
      20105, -- [4]
    }, -- [84]
    {
      133041, -- [1]
      5, -- [2]
      1, -- [3]
      20113, -- [4]
    }, -- [85]
    {
      135957, -- [1]
      3, -- [2]
      2, -- [3]
      20121, -- [4]
    }, -- [86]
    {
      135942, -- [1]
      7, -- [2]
      2, -- [3]
      20066, -- [4]
    }, -- [87]
    {
      135924, -- [1]
      2, -- [2]
      2, -- [3]
      20337, -- [4]
    }, -- [88]
    {
      132347, -- [1]
      3, -- [2]
      3, -- [3]
      20375, -- [4]
    }, -- [89]
    {
      135959, -- [1]
      2, -- [2]
      1, -- [3]
      25957, -- [4]
    }, -- [90]
    {
      135904, -- [1]
      4, -- [2]
      1, -- [3]
      25988, -- [4]
    }, -- [91]
    {
      135985, -- [1]
      3, -- [2]
      1, -- [3]
      26016, -- [4]
    }, -- [92]
    {
      135937, -- [1]
      3, -- [2]
      4, -- [3]
      26023, -- [4]
    }, -- [93]
    {
      135889, -- [1]
      4, -- [2]
      4, -- [3]
      31868, -- [4]
    }, -- [94]
    {
      135934, -- [1]
      5, -- [2]
      3, -- [3]
      31869, -- [4]
    }, -- [95]
    {
      135897, -- [1]
      6, -- [2]
      3, -- [3]
      31872, -- [4]
    }, -- [96]
    {
      236257, -- [1]
      7, -- [2]
      3, -- [3]
      31878, -- [4]
    }, -- [97]
    {
      135905, -- [1]
      8, -- [2]
      2, -- [3]
      31881, -- [4]
    }, -- [98]
    {
      135924, -- [1]
      4, -- [2]
      3, -- [3]
      35397, -- [4]
    }, -- [99]
    {
      135891, -- [1]
      9, -- [2]
      2, -- [3]
      35395, -- [4]
    }, -- [100]
    {
      236262, -- [1]
      8, -- [2]
      3, -- [3]
      53376, -- [4]
    }, -- [101]
    {
      236266, -- [1]
      9, -- [2]
      1, -- [3]
      53648, -- [4]
    }, -- [102]
    {
      236260, -- [1]
      10, -- [2]
      2, -- [3]
      53382, -- [4]
    }, -- [103]
    {
      236250, -- [1]
      11, -- [2]
      2, -- [3]
      53385, -- [4]
    }, -- [104]
    {
      236246, -- [1]
      7, -- [2]
      1, -- [3]
      53488, -- [4]
    }, -- [105]
    {
      236263, -- [1]
      9, -- [2]
      3, -- [3]
      53503, -- [4]
    }, -- [106]
    [121] = {
      "PaladinHoly", -- [1]
      "PaladinProtection", -- [2]
      "PaladinCombat", -- [3]
    },
  },
  ["ROGUE"] = {
    {
      132273, -- [1]
      4, -- [2]
      3, -- [3]
      14117, -- [4]
    }, -- [1]
    {
      132109, -- [1]
      3, -- [2]
      3, -- [3]
      14137, -- [4]
    }, -- [2]
    {
      132277, -- [1]
      1, -- [2]
      3, -- [3]
      14142, -- [4]
    }, -- [3]
    {
      132151, -- [1]
      1, -- [2]
      2, -- [3]
      14148, -- [4]
    }, -- [4]
    {
      132122, -- [1]
      2, -- [2]
      1, -- [3]
      14161, -- [4]
    }, -- [5]
    {
      136147, -- [1]
      6, -- [2]
      3, -- [3]
      14159, -- [4]
    }, -- [6]
    {
      132292, -- [1]
      1, -- [2]
      1, -- [3]
      14164, -- [4]
    }, -- [7]
    {
      132090, -- [1]
      2, -- [2]
      4, -- [3]
      13866, -- [4]
    }, -- [8]
    {
      132354, -- [1]
      3, -- [2]
      2, -- [3]
      14169, -- [4]
    }, -- [9]
    {
      132298, -- [1]
      5, -- [2]
      3, -- [3]
      14176, -- [4]
    }, -- [10]
    {
      135988, -- [1]
      5, -- [2]
      2, -- [3]
      14177, -- [4]
    }, -- [11]
    {
      132205, -- [1]
      7, -- [2]
      2, -- [3]
      58426, -- [4]
    }, -- [12]
    {
      136130, -- [1]
      6, -- [2]
      2, -- [3]
      14195, -- [4]
    }, -- [13]
    {
      136023, -- [1]
      3, -- [2]
      1, -- [3]
      14983, -- [4]
    }, -- [14]
    {
      132293, -- [1]
      4, -- [2]
      2, -- [3]
      16515, -- [4]
    }, -- [15]
    {
      132108, -- [1]
      9, -- [2]
      1, -- [3]
      58410, -- [4]
    }, -- [16]
    {
      132295, -- [1]
      8, -- [2]
      3, -- [3]
      31236, -- [4]
    }, -- [17]
    {
      132304, -- [1]
      9, -- [2]
      2, -- [3]
      1329, -- [4]
    }, -- [18]
    {
      132296, -- [1]
      5, -- [2]
      1, -- [3]
      31209, -- [4]
    }, -- [19]
    {
      132286, -- [1]
      7, -- [2]
      3, -- [3]
      31383, -- [4]
    }, -- [20]
    {
      132301, -- [1]
      5, -- [2]
      4, -- [3]
      31245, -- [4]
    }, -- [21]
    {
      236270, -- [1]
      7, -- [2]
      1, -- [3]
      51626, -- [4]
    }, -- [22]
    {
      236284, -- [1]
      9, -- [2]
      3, -- [3]
      51629, -- [4]
    }, -- [23]
    {
      236268, -- [1]
      2, -- [2]
      2, -- [3]
      51633, -- [4]
    }, -- [24]
    {
      236274, -- [1]
      8, -- [2]
      1, -- [3]
      51636, -- [4]
    }, -- [25]
    {
      236269, -- [1]
      10, -- [2]
      2, -- [3]
      51669, -- [4]
    }, -- [26]
    {
      236276, -- [1]
      11, -- [2]
      2, -- [3]
      51662, -- [4]
    }, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      132222, -- [1]
      2, -- [2]
      4, -- [3]
      13845, -- [4]
    }, -- [41]
    {
      135641, -- [1]
      3, -- [2]
      3, -- [3]
      13807, -- [4]
    }, -- [42]
    {
      133476, -- [1]
      5, -- [2]
      1, -- [3]
      13803, -- [4]
    }, -- [43]
    {
      136047, -- [1]
      4, -- [2]
      3, -- [3]
      13789, -- [4]
    }, -- [44]
    {
      132269, -- [1]
      2, -- [2]
      2, -- [3]
      13854, -- [4]
    }, -- [45]
    {
      136189, -- [1]
      1, -- [2]
      2, -- [3]
      13863, -- [4]
    }, -- [46]
    {
      132155, -- [1]
      1, -- [2]
      1, -- [3]
      13792, -- [4]
    }, -- [47]
    {
      136205, -- [1]
      3, -- [2]
      1, -- [3]
      13872, -- [4]
    }, -- [48]
    {
      136206, -- [1]
      7, -- [2]
      2, -- [3]
      13750, -- [4]
    }, -- [49]
    {
      132219, -- [1]
      4, -- [2]
      1, -- [3]
      13867, -- [4]
    }, -- [50]
    {
      132147, -- [1]
      1, -- [2]
      3, -- [3]
      13852, -- [4]
    }, -- [51]
    {
      132307, -- [1]
      4, -- [2]
      2, -- [3]
      13875, -- [4]
    }, -- [52]
    {
      132350, -- [1]
      5, -- [2]
      2, -- [3]
      13877, -- [4]
    }, -- [53]
    {
      135328, -- [1]
      5, -- [2]
      3, -- [3]
      13964, -- [4]
    }, -- [54]
    {
      132336, -- [1]
      3, -- [2]
      2, -- [3]
      14251, -- [4]
    }, -- [55]
    {
      132275, -- [1]
      4, -- [2]
      4, -- [3]
      61331, -- [4]
    }, -- [56]
    {
      135882, -- [1]
      6, -- [2]
      2, -- [3]
      30920, -- [4]
    }, -- [57]
    {
      132353, -- [1]
      7, -- [2]
      1, -- [3]
      61329, -- [4]
    }, -- [58]
    {
      132283, -- [1]
      6, -- [2]
      3, -- [3]
      31126, -- [4]
    }, -- [59]
    {
      132300, -- [1]
      7, -- [2]
      3, -- [3]
      31131, -- [4]
    }, -- [60]
    {
      132308, -- [1]
      9, -- [2]
      2, -- [3]
      32601, -- [4]
    }, -- [61]
    {
      135673, -- [1]
      8, -- [2]
      3, -- [3]
      35553, -- [4]
    }, -- [62]
    {
      132306, -- [1]
      2, -- [2]
      1, -- [3]
      14166, -- [4]
    }, -- [63]
    {
      236282, -- [1]
      8, -- [2]
      1, -- [3]
      51679, -- [4]
    }, -- [64]
    {
      236285, -- [1]
      9, -- [2]
      1, -- [3]
      51674, -- [4]
    }, -- [65]
    {
      132100, -- [1]
      9, -- [2]
      3, -- [3]
      58413, -- [4]
    }, -- [66]
    {
      236278, -- [1]
      10, -- [2]
      2, -- [3]
      51689, -- [4]
    }, -- [67]
    {
      236277, -- [1]
      11, -- [2]
      2, -- [3]
      51690, -- [4]
    }, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136129, -- [1]
      1, -- [2]
      2, -- [3]
      13971, -- [4]
    }, -- [81]
    {
      132320, -- [1]
      2, -- [2]
      3, -- [3]
      14063, -- [4]
    }, -- [82]
    {
      136159, -- [1]
      4, -- [2]
      2, -- [3]
      13980, -- [4]
    }, -- [83]
    {
      136056, -- [1]
      4, -- [2]
      1, -- [3]
      14071, -- [4]
    }, -- [84]
    {
      135994, -- [1]
      3, -- [2]
      1, -- [3]
      14066, -- [4]
    }, -- [85]
    {
      132366, -- [1]
      1, -- [2]
      3, -- [3]
      14072, -- [4]
    }, -- [86]
    {
      132310, -- [1]
      2, -- [2]
      2, -- [3]
      14094, -- [4]
    }, -- [87]
    {
      132282, -- [1]
      4, -- [2]
      3, -- [3]
      14080, -- [4]
    }, -- [88]
    {
      136220, -- [1]
      5, -- [2]
      3, -- [3]
      14083, -- [4]
    }, -- [89]
    {
      136121, -- [1]
      5, -- [2]
      2, -- [3]
      14185, -- [4]
    }, -- [90]
    {
      136136, -- [1]
      3, -- [2]
      2, -- [3]
      14278, -- [4]
    }, -- [91]
    {
      136183, -- [1]
      7, -- [2]
      2, -- [3]
      14183, -- [4]
    }, -- [92]
    {
      136168, -- [1]
      5, -- [2]
      4, -- [3]
      16511, -- [4]
    }, -- [93]
    {
      135315, -- [1]
      3, -- [2]
      3, -- [3]
      14173, -- [4]
    }, -- [94]
    {
      132294, -- [1]
      2, -- [2]
      1, -- [3]
      30893, -- [4]
    }, -- [95]
    {
      132089, -- [1]
      5, -- [2]
      1, -- [3]
      30895, -- [4]
    }, -- [96]
    {
      135540, -- [1]
      6, -- [2]
      3, -- [3]
      30906, -- [4]
    }, -- [97]
    {
      132291, -- [1]
      7, -- [2]
      1, -- [3]
      31213, -- [4]
    }, -- [98]
    {
      132305, -- [1]
      8, -- [2]
      2, -- [3]
      31220, -- [4]
    }, -- [99]
    {
      132299, -- [1]
      6, -- [2]
      1, -- [3]
      31223, -- [4]
    }, -- [100]
    {
      132303, -- [1]
      9, -- [2]
      2, -- [3]
      36554, -- [4]
    }, -- [101]
    {
      132285, -- [1]
      7, -- [2]
      3, -- [3]
      31230, -- [4]
    }, -- [102]
    {
      236286, -- [1]
      8, -- [2]
      3, -- [3]
      51696, -- [4]
    }, -- [103]
    {
      236275, -- [1]
      9, -- [2]
      1, -- [3]
      51701, -- [4]
    }, -- [104]
    {
      236287, -- [1]
      9, -- [2]
      3, -- [3]
      58415, -- [4]
    }, -- [105]
    {
      236280, -- [1]
      10, -- [2]
      2, -- [3]
      51712, -- [4]
    }, -- [106]
    {
      236279, -- [1]
      11, -- [2]
      2, -- [3]
      51713, -- [4]
    }, -- [107]
    {
      132340, -- [1]
      1, -- [2]
      1, -- [3]
      58425, -- [4]
    }, -- [108]
    [121] = {
      "RogueAssassination", -- [1]
      "RogueCombat", -- [2]
      "RogueSubtlety", -- [3]
    },
  },
}
