--[[--
	by ALA
--]]--
----------------------------------------------------------------------------------------------------
local __addon, __private = ...;
local MT = __private.MT;
local CT = __private.CT;
local VT = __private.VT;
local DT = __private.DT;

if CT.TOCVERSION >= 50000 or CT.TOCVERSION < 40400 then
	return;
end
-- if WOW_PROJECT_ID ~= WOW_PROJECT_CATACLYSM_CLASSIC then
-- 	return;
-- end

----------------------------------------------------------------------------------------------------

DT.MAX_LEVEL = 85;
DT.MAX_NUM_TIER = 7;
DT.MAX_NUM_COL = 4;
DT.MAX_NUM_TALENTS = 28;
DT.CUR_PHASE = 1;
--
DT.ClassSpec = {
	DEATHKNIGHT = {
		398,	--Blood,鲜血
		399,	--Frost,冰霜
		400,	--Unholy,邪恶
	},
	DRUID = {
		752,	--Balance,平衡
		750,	--Feral,野性战斗
		748,	--Restoration,恢复
	},
	HUNTER = {
		811,	--BeastMastery,野兽控制
		807,	--Marksmanship,射击
		809,	--Survival,生存
	},
	MAGE = {
		799,	--Arcane,奥术
		851,	--Fire,火焰
		823,	--Frost,冰霜
	},
	PALADIN = {
		831,	--Holy,神圣
		839,	--Protection,防护
		855,	--Discipline,惩戒
	},
	PRIEST = {
		760,	--Discipline,戒律
		813,	--Holy,神圣
		795,	--Shadow,暗影
	},
	ROGUE = {
		182,	--Assassination,刺杀
		181,	--Combat,战斗
		183,	--Subtlety,敏锐
	},
	SHAMAN = {
		261,	--Elemental,元素
		263,	--Enhancement,增强
		262,	--Restoration,恢复
	},
	WARLOCK = {
		871,	--Affliction,痛苦
		867,	--Demonology,恶魔学识
		865,	--Destruction,毁灭
	},
	WARRIOR = {
		746,	--Arms,武器
		815,	--Fury,狂怒
		845,	--Protection,防护
	},
};
--
	--	DT.TalentDB
	--1-----2----3---4---------5--------6-------7------8---------9--------10-----------11--------------------12
	--tier, col, id, maxPoint, reqTier, reqCol, reqId, Spell[5], texture, [icon index, req index in TreeTDB, req by index in TreeTDB](calculated after addon loaded)
--
DT.TalentDB = {
	DEATHKNIGHT = {
		[398] = {
			{  0,  0,  1939, 2, nil, nil,   nil, { 48979, 49483,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  2017, 3, nil, nil,   nil, { 49182, 49500, 49501,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  1938, 3, nil, nil,   nil, { 48978, 49390, 49391,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, FALSE, 2, nil, nil,   nil, { 94553, 94555,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  1948, 3, nil, nil,   nil, { 49004, 49508, 49509,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  7462, 2, nil, nil,   nil, { 81131, 81132,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3, FALSE, 2, nil, nil,   nil, { 85793, 85794,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  7460, 3, nil, nil,   nil, { 49219, 49627, 49628,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  7459, 1, nil, nil,   nil, { 49222,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  7458, 3, nil, nil,   nil, { 49042, 49786, 49787,   nil,  nil, }, 'TEXTURE', },
			{  2,  3,  2105, 2, nil, nil,   nil, { 53137, 53138,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0,  7461, 2, nil, nil,   nil, { 81125, 81127,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  1960, 2, nil, nil,   nil, { 49027, 49542,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  1936, 2, nil, nil,   nil, { 50365, 50371,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  1959, 3,   4,   1,  1941, { 52284, 81163, 81164,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  1941, 1, nil, nil,   nil, { 48982,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  2019, 1, nil, nil,   nil, { 55233,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  2259, 3, nil, nil,   nil, { 62905, 62908, 81138,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  7463, 2, nil, nil,   nil, { 81135, 81136,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  1961, 1, nil, nil,   nil, { 49028,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[399] = {
			{  0,  0,  2031, 3, nil, nil,   nil, { 49455, 50147, 91145,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  2035, 2, nil, nil,   nil, { 55061, 55062,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  2022, 3, nil, nil,   nil, { 49226, 50137, 50138,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  2048, 3, nil, nil,   nil, { 51468, 51472, 51473,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  2215, 1, nil, nil,   nil, { 49039,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 11275, 2, nil, nil,   nil, { 51983, 51986,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  1971, 2, nil, nil,   nil, { 49137, 49657,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  1993, 2, nil, nil,   nil, { 49024, 49538,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  1981, 2, nil, nil,   nil, { 49149, 50115,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  2044, 3, nil, nil,   nil, { 51123, 51127, 51128,   nil,  nil, }, 'TEXTURE', },
			{  3,  0,  1992, 3, nil, nil,   nil, { 49188, 56822, 59057,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  1979, 1, nil, nil,   nil, { 51271,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  2223, 1, nil, nil,   nil, { 55610,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  1980, 2, nil, nil,   nil, { 81327, 81328,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  2260, 2, nil, nil,   nil, { 50040, 50041,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  1999, 1, nil, nil,   nil, { 49203,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  2029, 2, nil, nil,   nil, { 50384, 50385,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  2284, 3, nil, nil,   nil, { 65661, 66191, 66192,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  7571, 3, nil, nil,   nil, { 81330, 81332, 81333,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  1989, 1,   4,   1,  1999, { 49184,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[400] = {
			{  0,  0,  2025, 2, nil, nil,   nil, { 49588, 49589,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  1932, 3, nil, nil,   nil, { 48962, 49567, 49568,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  1963, 3, nil, nil,   nil, { 49036, 49562, 81334,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  2226, 2, nil, nil,   nil, { 55666, 55667,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  7572, 2, nil, nil,   nil, { 81338, 81339,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3, 11178, 3, nil, nil,   nil, { 48963, 49564, 49565,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  2047, 2, nil, nil,   nil, { 51459, 51462,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  7574, 1, nil, nil,   nil, { 49016,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 12119, 2,   0,   2,  1963, { 91316, 91319,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 11179, 3, nil, nil,   nil, { 48965, 49571, 49572,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 15322, 2, nil, nil,   nil, { 96269, 96270,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  2009, 3, nil, nil,   nil, { 49224, 49610, 49611,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  2082, 3, nil, nil,   nil, { 51745, 51746, 91323,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  1996, 1, nil, nil,   nil, { 49194,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  2221, 1,   3,   1,  2009, { 51052,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  2013, 2, nil, nil,   nil, { 50391, 50392,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,  2085, 1,   2,   3, 11179, { 63560,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  2043, 2, nil, nil,   nil, { 51099, 51160,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  7575, 3, nil, nil,   nil, { 49018, 49529, 49530,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  2000, 1, nil, nil,   nil, { 49206,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	DRUID = {
		[752] = {
			{  0,  0,  8359, 3, nil, nil,   nil, { 16880, 61345, 61346,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  8349, 3, nil, nil,   nil, { 16814, 16815, 16816,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 11281, 2, nil, nil,   nil, { 35363, 35364,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 11284, 3, nil, nil,   nil, { 57810, 57811, 57812,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  8353, 3, nil, nil,   nil, { 16845, 16846, 16847,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  8383, 2, nil, nil,   nil, { 33592, 33596,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  8389, 2, nil, nil,   nil, { 81061, 81062,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1, 11278, 1, nil, nil,   nil, { 24858,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 11282, 1, nil, nil,   nil, { 50516,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3,  8381, 2, nil, nil,   nil, { 93398, 93399,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  8391, 3,   2,   1, 11278, { 48389, 48392, 48393,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  8379, 2,   2,   2, 11282, { 48488, 48514,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  8361, 1, nil, nil,   nil, { 78675,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 12149, 2,   2,   0,  8389, { 33597, 33599,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  8399, 1, nil, nil,   nil, { 33831,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 12150, 1, nil, nil,   nil, { 93401,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3, 11277, 1, nil, nil,   nil, { 48506,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  8403, 2,   4,   1,  8399, { 78788, 78789,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  8393, 3,   4,   2, 12150, { 33603, 33604, 33605,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  8405, 1, nil, nil,   nil, { 48505,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[750] = {
			{  0,  0,  8295, 2, nil, nil,   nil, { 17002, 24866,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 11716, 3, nil, nil,   nil, { 17056, 17058, 17059,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  9026, 2, nil, nil,   nil, { 16972, 16974,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  8760, 2, nil, nil,   nil, { 48483, 48484,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  8305, 3, nil, nil,   nil, { 48532, 80552, 80553,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  8761, 2, nil, nil,   nil, { 37116, 37117,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3, 11285, 2, nil, nil,   nil, { 16858, 16859,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  8323, 3, nil, nil,   nil, { 48492, 48494, 48495,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  8299, 1, nil, nil,   nil, { 49377,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  8301, 2,   2,   1,  8299, { 78892, 78893,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3,  8293, 3, nil, nil,   nil, { 16929, 16930, 16931,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  8325, 1, nil, nil,   nil, { 17007,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  8307, 2, nil, nil,   nil, { 16940, 16941,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  8303, 2, nil, nil,   nil, { 33872, 33873,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  8335, 2,   2,   0,  8323, { 80316, 80317,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  8313, 1, nil, nil,   nil, { 61336,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  8759, 2, nil, nil,   nil, { 80314, 80315,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,  8758, 2, nil, nil,   nil, { 57878, 57880,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  8341, 2, nil, nil,   nil, { 80318, 80319,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  8343, 3, nil, nil,   nil, { 48432, 48433, 48434,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  8319, 1,   5,   1,  8343, { 80313,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  8347, 1, nil, nil,   nil, { 50334,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[748] = {
			{  0,  0,  8227, 2, nil, nil,   nil, { 78784, 78785,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  8237, 2, nil, nil,   nil, { 16833, 16834,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 11699, 2, nil, nil,   nil, { 17069, 17070,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  3, 11715, 3, nil, nil,   nil, { 17003, 17004, 17005,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 11279, 3, nil, nil,   nil, { 78734, 78735, 78736,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  8277, 1,   0,   1,  8237, { 48411,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  8245, 3, nil, nil,   nil, { 17111, 17112, 17113,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  8253, 3, nil, nil,   nil, { 48496, 48499, 48500,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  8269, 2, nil, nil,   nil, { 48539, 48544,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  8249, 1, nil, nil,   nil, { 17116,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 11712, 2, nil, nil,   nil, { 17104, 24943,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  8255, 3, nil, nil,   nil, { 17074, 17075, 17076,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  8762, 2, nil, nil,   nil, { 33879, 33880,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3, 12146, 2, nil, nil,   nil, { 92363, 92364,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  8263, 3, nil, nil,   nil, { 34151, 81274, 81275,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  8279, 1, nil, nil,   nil, { 48438,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  8763, 1, nil, nil,   nil, { 88423,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,  8267, 2, nil, nil,   nil, { 33881, 33882,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0, 11280, 3, nil, nil,   nil, { 51179, 51180, 51181,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  8265, 1, nil, nil,   nil, { 33886,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  8271, 1,   4,   1,  8279, { 33891,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	HUNTER = {
		[811] = {
			{  0,  0,  9494, 2, nil, nil,   nil, { 35029, 35030,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  9490, 3, nil, nil,   nil, { 82682, 82683, 82684,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  9492, 3, nil, nil,   nil, { 19590, 19592, 82687,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  9502, 2, nil, nil,   nil, { 19559, 19560,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  9514, 2, nil, nil,   nil, { 19578, 20895,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  9512, 3, nil, nil,   nil, { 19621, 19622, 19623,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  9510, 2, nil, nil,   nil, { 19572, 19573,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  9530, 3, nil, nil,   nil, { 53256, 53259, 53260,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  9504, 1, nil, nil,   nil, { 82726,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  9520, 1,   1,   2,  9512, { 82692,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0,  9534, 3, nil, nil,   nil, { 53262, 53263, 53264,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  9528, 2, nil, nil,   nil, { 82748, 82749,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 11714, 2, nil, nil,   nil, { 82898, 82899,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  9524, 1,   2,   1,  9504, { 19574,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  9518, 1, nil, nil,   nil, { 34460,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  9538, 2, nil, nil,   nil, { 56314, 56315,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  9536, 1,   4,   1,  9524, { 34692,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  9522, 2,   4,   2,  9518, { 53252, 53253,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  9542, 1, nil, nil,   nil, { 53270,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[809] = {
			{  0,  0,  9442, 3, nil, nil,   nil, { 56339, 56340, 56341,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  9432, 3, nil, nil,   nil, { 52783, 52785, 52786,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  9450, 2, nil, nil,   nil, { 19464, 82834,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  9444, 2, nil, nil,   nil, { 19286, 19287,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 10753, 3, nil, nil,   nil, { 19376, 63457, 63458,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  9440, 2, nil, nil,   nil, { 19184, 19387,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  9472, 2, nil, nil,   nil, { 53298, 53299,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  9484, 3, nil, nil,   nil, { 34497, 34498, 34499,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  9448, 1, nil, nil,   nil, { 19306,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  9452, 2, nil, nil,   nil, { 56342, 56343,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0,  9460, 3, nil, nil,   nil, { 34491, 34492, 34493,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  9482, 2, nil, nil,   nil, { 83494, 83495,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  9462, 2,   2,   2,  9452, { 56333, 56336,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  9464, 2, nil, nil,   nil, { 82832, 82833,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  9468, 1, nil, nil,   nil, { 19386,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  9474, 2,   4,   1,  9468, { 53295, 53296,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,  9476, 1, nil, nil,   nil, { 53290,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  9478, 3, nil, nil,   nil, { 53302, 53303, 53304,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 11698, 2, nil, nil,   nil, { 87934, 87935,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  9480, 1,   4,   1,  9468, { 3674,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[807] = {
			{  0,  0,  9390, 2, nil, nil,   nil, { 34950, 34954,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  9380, 3, nil, nil,   nil, { 19416, 19417, 19418,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  9378, 2, nil, nil,   nil, { 34948, 34949,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  9396, 2,   0,   0,  9390, { 83340, 83356,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  9402, 3, nil, nil,   nil, { 53221, 53222, 53224,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  9398, 2, nil, nil,   nil, { 34482, 34483,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  9424, 1, nil, nil,   nil, { 34490,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  9406, 2, nil, nil,   nil, { 35100, 35102,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 11225, 3, nil, nil,   nil, { 53234, 53237, 53238,   nil,  nil, }, 'TEXTURE', },
			{  3,  0,  9408, 2, nil, nil,   nil, { 35104, 35110,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  9412, 1, nil, nil,   nil, { 19506,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  9416, 2, nil, nil,   nil, { 83489, 83490,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  9420, 2, nil, nil,   nil, { 82893, 82894,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  9422, 2, nil, nil,   nil, { 53228, 53232,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  9418, 3, nil, nil,   nil, { 34485, 34486, 34487,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,  9404, 1, nil, nil,   nil, { 23989,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  9426, 2, nil, nil,   nil, { 83558, 83560,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  9428, 2,   4,   1,  9418, { 53241, 53243,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  9430, 1,   4,   1,  9418, { 53209,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	MAGE = {
		[799] = {	--	数据库多了一行3-3
			{  0,  0,  9154, 3, nil, nil,   nil, { 11213, 12574, 12575,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  9166, 2, nil, nil,   nil, { 11255, 12598,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  9200, 3, nil, nil,   nil, { 44400, 44402, 44403,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  9170, 3, nil, nil,   nil, { 29447, 55339, 55340,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 10864, 2, nil, nil,   nil, { 84722, 84723,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 10737, 2, nil, nil,   nil, { 83513, 83515,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  9172, 2, nil, nil,   nil, { 31569, 31570,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  9192, 2,   2,   1,  9174, { 44378, 44379,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  9174, 1, nil, nil,   nil, { 12043,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  9198, 2,   1,   2, 10737, { 44404, 54486,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3,  9178, 3, nil, nil,   nil, { 31574, 31575, 54354,   nil,  nil, }, 'TEXTURE', },
			{  3,  0,  9142, 2, nil, nil,   nil, { 11210, 12592,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 10733, 1,   2,   1,  9174, { 82930,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  9188, 2, nil, nil,   nil, { 44394, 44395,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3, 11825, 2, nil, nil,   nil, { 90787, 90788,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  9180, 2, nil, nil,   nil, { 31571, 31572,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  9196, 1, nil, nil,   nil, { 31589,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 11367, 2,   4,   1,  9196, { 86181, 86209,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0, 10578, 1, nil, nil,   nil, { 54646,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  9194, 2, nil, nil,   nil, { 31584, 31585,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  9186, 1,   4,   1,  9196, { 12042,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{nil,  0,     0, 0, nil, nil,   nil, {   nil,   nil,   nil,   nil,  nil, }, 'TEXTURE', }, -- {  3,  3, 11824, 2, nil, nil,   nil, { 90724, 90731,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[851] = {
			{  0,  0, 10545, 2, nil, nil,   nil, { 29074, 29075,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 10531, 3, nil, nil,   nil, { 11083, 84253, 84254,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 10523, 2, nil, nil,   nil, { 11078, 11080,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 10529, 3, nil, nil,   nil, { 11119, 11120, 12846,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 11434, 3, nil, nil,   nil, { 18459, 18460, 54734,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 10555, 2, nil, nil,   nil, { 31641, 31642,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3, 10537, 2, nil, nil,   nil, { 11103, 12357,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 11433, 2, nil, nil,   nil, { 86948, 86949,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1, 10551, 1, nil, nil,   nil, { 11113,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 10573, 1, nil, nil,   nil, { 44445,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 10547, 2, nil, nil,   nil, { 11115, 11367,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 10543, 1, nil, nil,   nil, { 11094,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 10561, 1, nil, nil,   nil, { 11129,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 12121, 2,   2,   2, 10573, { 44446, 44448,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3, 11431, 1, nil, nil,   nil, { 86914,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 10734, 2, nil, nil,   nil, { 84673, 84674,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1, 10571, 1, nil, nil,   nil, { 31661,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 10563, 3, nil, nil,   nil, { 31679, 31680, 86880,   nil,  nil, }, 'TEXTURE', },
			{  5,  0, 10559, 2, nil, nil,   nil, { 34293, 34295,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 10541, 3, nil, nil,   nil, { 11095, 12872, 12873,   nil,  nil, }, 'TEXTURE', },
			{  6,  1, 10577, 1,   4,   1, 10571, { 44457,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[823] = {
			{  0,  0,  9862, 2, nil, nil,   nil, { 83049, 83050,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 11157, 3, nil, nil,   nil, { 11151, 12952, 12953,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 11158, 2, nil, nil,   nil, { 11170, 12982,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  9846, 3, nil, nil,   nil, { 31670, 31672, 55094,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 11325, 2, nil, nil,   nil, { 11190, 12489,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 11156, 2, nil, nil,   nil, { 83156, 83157,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  9854, 3, nil, nil,   nil, { 11175, 12569, 12571,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  9860, 2, nil, nil,   nil, { 11185, 12487,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  9858, 1, nil, nil,   nil, { 12472,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  9876, 3, nil, nil,   nil, { 44543, 44545, 83074,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 11371, 3,   2,   2,  9876, { 86259, 86260, 86314,   nil,  nil, }, 'TEXTURE', },
			{  3,  0,  9894, 3, nil, nil,   nil, { 44561, 86500, 86508,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  9870, 1, nil, nil,   nil, { 11958,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  9890, 3, nil, nil,   nil, { 44546, 44548, 44549,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  9880, 2,   4,   1,  9882, { 44745, 54787,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  9882, 1, nil, nil,   nil, { 11426,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 11373, 2,   4,   1,  9882, { 86303, 86304,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 11169, 2, nil, nil,   nil, { 84726, 84727,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  9898, 1,   4,   1,  9882, { 44572,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	PALADIN = {
		[831] = {
			{  0,  0, 10099, 2, nil, nil,   nil, { 20359, 20360,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 12189, 3, nil, nil,   nil, { 20138, 20139, 20140,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 10127, 3, nil, nil,   nil, { 53671, 53673, 54151,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 11213, 3, nil, nil,   nil, { 85462, 85463, 85464,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 10097, 2, nil, nil,   nil, { 20234, 20235,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 11780, 2, nil, nil,   nil, { 20237, 20238,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 10109, 2, nil, nil,   nil, { 31825, 85510,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1, 11202, 1, nil, nil,   nil, { 31842,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 10129, 2, nil, nil,   nil, { 53569, 53576,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 11771, 2, nil, nil,   nil, { 88820, 88821,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 10113, 2, nil, nil,   nil, { 53556, 53557,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 10133, 1, nil, nil,   nil, { 53563,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 11215, 3,   2,   2, 10129, { 85495, 85498, 85499,   nil,  nil, }, 'TEXTURE', },
			{  3,  3, 10121, 1, nil, nil,   nil, { 53551,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 11779, 3, nil, nil,   nil, { 20049, 20056, 20057,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 10115, 1, nil, nil,   nil, { 31821,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3, 12151, 2, nil, nil,   nil, { 93418, 93417,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1, 11168, 3,   3,   1, 10133, { 84800, 85511, 85512,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 10117, 2, nil, nil,   nil, { 31828, 31829,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1, 11203, 1, nil, nil,   nil, { 85222,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[839] = {
			{  0,  0, 12198, 3, nil, nil,   nil, { 63646, 63647, 63648,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 10324, 2, nil, nil,   nil, { 20224, 20225,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 12152, 2, nil, nil,   nil, { 87163, 87164,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 10372, 2, nil, nil,   nil, { 53695, 53696,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 10332, 3, nil, nil,   nil, { 20143, 20144, 20145,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 10336, 2, nil, nil,   nil, { 20487, 20488,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 10344, 2, nil, nil,   nil, { 84631, 84633,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1, 10346, 3, nil, nil,   nil, { 20911, 84628, 84629,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 10374, 1, nil, nil,   nil, { 53595,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 11159, 2, nil, nil,   nil, { 84635, 84636,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 11161, 2, nil, nil,   nil, { 20177, 20179,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 11607, 1,   2,   1, 10346, { 53600,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 11193, 2,   2,   2, 10374, { 75806, 85043,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 10680, 1, nil, nil,   nil, { 26016,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1, 10356, 1,   3,   1, 11607, { 20925,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 11221, 2, nil, nil,   nil, { 85639, 85646,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3, 10334, 1, nil, nil,   nil, { 70940,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1, 10370, 2,   4,   1, 10356, { 53709, 53710,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 10340, 3, nil, nil,   nil, { 31848, 31849, 84854,   nil,  nil, }, 'TEXTURE', },
			{  6,  1, 10350, 1, nil, nil,   nil, { 31850,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[855] = {
			{  0,  0, 10647, 2, nil, nil,   nil, { 9799, 25988,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 10651, 3, nil, nil,   nil, { 31866, 31867, 31868,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 11612, 2, nil, nil,   nil, { 87174, 87175,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 12153, 2, nil, nil,   nil, { 20174, 20175,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 11269, 3, nil, nil,   nil, { 85457, 85458, 87461,   nil,  nil, }, 'TEXTURE', },
			{  1,  3, 11611, 2, nil, nil,   nil, { 26022, 26023,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 10665, 1, nil, nil,   nil, { 31876,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1, 10661, 3, nil, nil,   nil, { 53486, 53488, 87138,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 11610, 2,   0,   2, 11612, { 87168, 87172,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 11204, 1, nil, nil,   nil, { 53385,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 11207, 1, nil, nil,   nil, { 85285,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 11372, 1, nil, nil,   nil, { 25956,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 10643, 1, nil, nil,   nil, { 85126,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3, 10669, 3, nil, nil,   nil, { 53375, 90286, 53376,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 11271, 2, nil, nil,   nil, { 85803, 85804,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1, 10663, 1, nil, nil,   nil, { 20066,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 10633, 2, nil, nil,   nil, { 85117, 86172,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1, 10677, 3, nil, nil,   nil, { 53380, 53381, 53382,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 11211, 2, nil, nil,   nil, { 85446, 85795,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1, 11222, 1, nil, nil,   nil, { 85696,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	PRIEST = {
		[795] = {
			{  0,  0,  9032, 3, nil, nil,   nil, { 15259, 15307, 15308,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  9036, 2, nil, nil,   nil, { 15275, 15317,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  9046, 2, nil, nil,   nil, { 15274, 15311,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  9040, 2, nil, nil,   nil, { 15392, 15448,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  9042, 3, nil, nil,   nil, { 15273, 15312, 15313,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  9062, 2, nil, nil,   nil, { 63625, 63626,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3, 11673, 2, nil, nil,   nil, { 47573, 47577,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  9064, 1, nil, nil,   nil, { 15473,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  9068, 2, nil, nil,   nil, { 47569, 47570,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 11606, 2, nil, nil,   nil, { 33191, 78228,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0,  9052, 1,   1,   0,  9040, { 15487,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  9054, 1, nil, nil,   nil, { 15286,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 11778, 2,   3,   1,  9054, { 88994, 88995,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  9060, 2, nil, nil,   nil, { 14910, 33371,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  9076, 2, nil, nil,   nil, { 47580, 47581,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  9074, 1,   3,   1,  9054, { 34914,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 11663, 2, nil, nil,   nil, { 87192, 87195,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  9072, 1, nil, nil,   nil, { 64044,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1, 11605, 2,   4,   1,  9074, { 87099, 87100,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  9070, 3, nil, nil,   nil, { 78202, 78203, 78204,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  9080, 1, nil, nil,   nil, { 47585,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[813] = {
			{  0,  0, 10746, 2, nil, nil,   nil, { 14908, 15020,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  9553, 3, nil, nil,   nil, { 33158, 33159, 33160,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  9549, 3, nil, nil,   nil, { 18530, 18531, 18533,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 11669, 1, nil, nil,   nil, { 19236,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 11765, 2, nil, nil,   nil, { 88687, 88690,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  9561, 2, nil, nil,   nil, { 14892, 15362,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  9593, 2,   0,   0, 10746, { 63534, 63542,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  9577, 2, nil, nil,   nil, { 34753, 34859,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 11666, 1, nil, nil,   nil, { 724,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 12184, 2, nil, nil,   nil, { 14898, 81625,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 14738, 1,   2,   0,  9593, { 95649,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 11670, 1, nil, nil,   nil, { 20711,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  9573, 2, nil, nil,   nil, { 63730, 63733,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  9587, 2, nil, nil,   nil, { 64127, 64129,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1, 11667, 1,   2,   1,  9577, { 14751,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 11755, 1,   4,   1, 11667, { 88627,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3, 11672, 2, nil, nil,   nil, { 33142, 33145,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  9597, 3, nil, nil,   nil, { 47558, 47559, 47560,   nil,  nil, }, 'TEXTURE', },
			{  5,  1, 11668, 2,   4,   1, 11667, { 87430, 87431,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  9595, 1, nil, nil,   nil, { 34861,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  9601, 1, nil, nil,   nil, { 47788,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[760] = {
			{  0,  0, 10736, 2, nil, nil,   nil, { 14748, 14768,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  8577, 3, nil, nil,   nil, { 47586, 47587, 47588,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  8595, 3, nil, nil,   nil, { 14520, 14780, 14781,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  8593, 2, nil, nil,   nil, { 81659, 81662,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 11608, 1,   1,   0,  8593, { 87151,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  8581, 3, nil, nil,   nil, { 14747, 14770, 14771,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  8607, 2, nil, nil,   nil, { 63574, 78500,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 11224, 2, nil, nil,   nil, { 57470, 57472,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  8611, 1, nil, nil,   nil, { 10060,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 11812, 2, nil, nil,   nil, { 14523, 81749,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3,  8591, 1, nil, nil,   nil, { 89485,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  8617, 3, nil, nil,   nil, { 47535, 47536, 47537,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 11523, 2, nil, nil,   nil, { 52795, 52797,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  8605, 2, nil, nil,   nil, { 33201, 33202,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 11813, 2,   2,   0, 11224, { 89488, 89489,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  8609, 3, nil, nil,   nil, { 47509, 47511, 47515,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  8623, 1, nil, nil,   nil, { 33206,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3, 12183, 2, nil, nil,   nil, { 92295, 92297,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  8621, 2, nil, nil,   nil, { 45234, 45243,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  8625, 2, nil, nil,   nil, { 47516, 47517,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  8603, 1,   4,   1,  8609, { 62618,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	ROGUE = {
		[182] = {
			{  0,  0,  6514, 2, nil, nil,   nil, { 79121, 79122,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,   276, 3, nil, nil,   nil, { 14162, 14163, 14164,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,   269, 3, nil, nil,   nil, { 14128, 14132, 14135,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,   273, 3, nil, nil,   nil, { 14156, 14160, 14161,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  1721, 2, nil, nil,   nil, { 31208, 31209,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,   277, 3, nil, nil,   nil, { 13733, 13865, 13866,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  6515, 2, nil, nil,   nil, { 79123, 79125,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  2065, 2, nil, nil,   nil, { 51625, 51626,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,   280, 1, nil, nil,   nil, { 14177,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,   682, 3, nil, nil,   nil, { 16513, 16514, 16515,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 11209, 3, nil, nil,   nil, { 31380, 31382, 31383,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,   283, 2,   2,   1,   280, { 14186, 14190,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  6516, 2, nil, nil,   nil, { 14158, 14159,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,   281, 1, nil, nil,   nil, { 58426,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  1715, 1,   2,   2,   682, { 58410,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,   278, 2, nil, nil,   nil, { 14168, 14169,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  2070, 3, nil, nil,   nil, { 51664, 51665, 51667,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  6517, 2, nil, nil,   nil, { 79133, 79134,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  2071, 1, nil, nil,   nil, { 79140,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[181] = {
			{  0,  0,  6395, 2, nil, nil,   nil, { 79007, 79008,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,   201, 3, nil, nil,   nil, { 13732, 13863, 79004,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,   181, 3, nil, nil,   nil, { 13705, 13832, 13843,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  1827, 2, nil, nil,   nil, { 14165, 14166,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,   222, 2, nil, nil,   nil, { 13743, 13875,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  1122, 3, nil, nil,   nil, { 18427, 18428, 18429,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,   206, 2, nil, nil,   nil, { 13754, 13867,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,   186, 3, nil, nil,   nil, { 13712, 13788, 13789,   nil,  nil, }, 'TEXTURE', },
			{  2,  1, 11171, 1, nil, nil,   nil, { 84617,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  6511, 2, nil, nil,   nil, { 79077, 79079,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3,   203, 2, nil, nil,   nil, { 13741, 13793,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  1825, 3, nil, nil,   nil, { 35541, 35550, 35551,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  1706, 2, nil, nil,   nil, { 31124, 31126,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  2072, 2, nil, nil,   nil, { 5952, 51679,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,   205, 1, nil, nil,   nil, { 13750,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  2074, 2, nil, nil,   nil, { 51682, 58413,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0, 11174, 3, nil, nil,   nil, { 84652, 84653, 84654,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  6513, 2, nil, nil,   nil, { 79095, 79096,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  2076, 1,   4,   1,   205, { 51690,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[183] = {
			{  0,  0,   244, 2, nil, nil,   nil, { 13975, 14062,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,   263, 3, nil, nil,   nil, { 14079, 14080, 84661,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  2244, 3, nil, nil,   nil, { 14179, 58422, 58423,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,   247, 2, nil, nil,   nil, { 13981, 14066,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  2077, 2,   0,   1,   263, { 51692, 51696,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,   261, 3, nil, nil,   nil, { 14057, 14072, 79141,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,   245, 2, nil, nil,   nil, { 13976, 13979,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 11665, 3, nil, nil,   nil, { 79150, 79151, 79152,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  6519, 2, nil, nil,   nil, { 51632, 91023,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,   681, 1, nil, nil,   nil, { 16511,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0,  2078, 3, nil, nil,   nil, { 51698, 51700, 51701,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,   381, 1, nil, nil,   nil, { 14183,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3, 11664, 3, nil, nil,   nil, { 31211, 31212, 31213,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  1722, 3, nil, nil,   nil, { 31228, 31229, 31230,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,   284, 1, nil, nil,   nil, { 14185,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  6520, 2,   2,   2,   681, { 79146, 79147,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  2080, 3, nil, nil,   nil, { 51708, 51709, 51710,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  1123, 2, nil, nil,   nil, { 14171, 14172,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  2081, 1, nil, nil,   nil, { 51713,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	SHAMAN = {
		[262] = {
			{  0,  0,  5568, 2, nil, nil,   nil, { 77829, 77830,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,   593, 3, nil, nil,   nil, { 16179, 16214, 16215,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 11177, 3, nil, nil,   nil, { 84846, 84847, 84848,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,   583, 2, nil, nil,   nil, { 16180, 16196,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,   595, 2, nil, nil,   nil, { 16173, 16222,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  5567, 3, nil, nil,   nil, { 77794, 77795, 77796,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  1699, 3, nil, nil,   nil, { 30881, 30883, 30884,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,   581, 2, nil, nil,   nil, { 16176, 16235,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,   591, 1, nil, nil,   nil, { 16188,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  1696, 3, nil, nil,   nil, { 30867, 30868, 30869,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,   588, 2, nil, nil,   nil, { 16187, 16205,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  2084, 1, nil, nil,   nil, { 77130,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3, 11435, 2,   3,   2,  2084, { 86959, 86962,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  2061, 3,   2,   0,   581, { 51556, 51557, 51558,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,   590, 1, nil, nil,   nil, { 16190,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  7705, 2, nil, nil,   nil, { 82984, 82988,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3, 15487, 1, nil, nil,   nil, { 98008,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  2063, 3, nil, nil,   nil, { 51562, 51563, 51564,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  2060, 2, nil, nil,   nil, { 51554, 51555,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  2064, 1, nil, nil,   nil, { 61295,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[263] = {
			{  0,  0,   611, 2, nil, nil,   nil, { 16266, 29079,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  5560, 3, nil, nil,   nil, { 77536, 77537, 77538,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,   607, 3, nil, nil,   nil, { 16261, 16290, 51881,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 11216, 3, nil, nil,   nil, { 30160, 29179, 29180,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,   602, 3, nil, nil,   nil, { 16256, 16281, 16282,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,   605, 2, nil, nil,   nil, { 16262, 16287,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3, 11432, 2, nil, nil,   nil, { 86935, 86936,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,   615, 3, nil, nil,   nil, { 16252, 16306, 16307,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,   901, 1, nil, nil,   nil, { 17364,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  2055, 3, nil, nil,   nil, { 51525, 51526, 51527,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 11220, 2, nil, nil,   nil, { 63373, 63374,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 11770, 2, nil, nil,   nil, { 16086, 16544,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  2083, 3, nil, nil,   nil, { 77655, 77656, 77657,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  2056, 2, nil, nil,   nil, { 51523, 51524,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  1693, 1, nil, nil,   nil, { 30823,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,  1689, 2, nil, nil,   nil, { 30802, 30808,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  2057, 3, nil, nil,   nil, { 51528, 51529, 51530,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  5563, 2,   3,   2,  2083, { 77700, 77701,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  2058, 1, nil, nil,   nil, { 51533,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[261] = {
			{  0,  0, 11218, 3, nil, nil,   nil, { 17485, 17486, 17487,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,   564, 2, nil, nil,   nil, { 16039, 16109,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,   563, 3, nil, nil,   nil, { 16035, 16105, 16106,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,   561, 2, nil, nil,   nil, { 16038, 16160,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  1640, 3, nil, nil,   nil, { 28996, 28997, 28998,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,   575, 2, nil, nil,   nil, { 16040, 16113,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  1685, 3, nil, nil,   nil, { 30672, 30673, 30674,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 11767, 2, nil, nil,   nil, { 88756, 88764,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,   574, 1, nil, nil,   nil, { 16164,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  1641, 2, nil, nil,   nil, { 28999, 29000,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  2049, 2,   2,   1,   574, { 51466, 51470,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  2051, 3, nil, nil,   nil, { 51480, 51481, 51482,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 11769, 1,   2,   0, 11767, { 88766,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,   573, 1, nil, nil,   nil, { 16166,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 11768, 2, nil, nil,   nil, { 51483, 51485,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,  5565, 1, nil, nil,   nil, { 77746,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1, 11368, 3,   4,   1,   573, { 86183, 86184, 86185,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  5566, 2, nil, nil,   nil, { 77755, 77756,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  1687, 1, nil, nil,   nil, { 61882,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	WARLOCK = {
		[865] = {
			{  0,  0, 10938, 3, nil, nil,   nil, { 17788, 17789, 17790,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 10936, 3, nil, nil,   nil, { 17793, 17796, 17801,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 10960, 2, nil, nil,   nil, { 17815, 17833,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 11197, 2, nil, nil,   nil, { 85113, 85114,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 11181, 2, nil, nil,   nil, { 17954, 17955,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 11196, 2, nil, nil,   nil, { 17927, 17929,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 10940, 2, nil, nil,   nil, { 18119, 18120,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1, 10978, 3, nil, nil,   nil, { 47258, 47259, 47260,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 10948, 1, nil, nil,   nil, { 17877,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 11182, 2, nil, nil,   nil, { 91986, 85112,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 10970, 2, nil, nil,   nil, { 30293, 30295,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 10958, 3, nil, nil,   nil, { 34935, 34938, 34939,   nil,  nil, }, 'TEXTURE', },
			{  3,  3, 12120, 1, nil, nil,   nil, { 91713,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1, 10984, 3, nil, nil,   nil, { 47266, 47267, 47268,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 10980, 1, nil, nil,   nil, { 30283,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3, 10964, 2,   3,   3, 12120, { 30299, 30301,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0, 10982, 2,   3,   0, 11182, { 47220, 47221,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 10962, 1, nil, nil,   nil, { 80240,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1, 10986, 1,   4,   1, 10984, { 50796,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[871] = {
			{  0,  0, 11100, 2, nil, nil,   nil, { 18827, 18829,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 11110, 2, nil, nil,   nil, { 18182, 18183,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 11104, 3, nil, nil,   nil, { 17810, 17811, 17812,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 11214, 2, nil, nil,   nil, { 18179, 85479,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 11112, 2, nil, nil,   nil, { 17804, 17805,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 11420, 2,   1,   1, 11112, { 63108, 86667,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 11128, 1, nil, nil,   nil, { 18223,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 11114, 2, nil, nil,   nil, { 53754, 53759,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 11134, 3, nil, nil,   nil, { 47195, 47196, 47197,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 11140, 2, nil, nil,   nil, { 30054, 30057,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 11366, 1,   1,   1, 11112, { 86121,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 11124, 3, nil, nil,   nil, { 32385, 32387, 32392,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 11142, 3, nil, nil,   nil, { 47198, 47199, 47200,   nil,  nil, }, 'TEXTURE', },
			{  4,  1, 11122, 2, nil, nil,   nil, { 18094, 18095,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 11419, 1, nil, nil,   nil, { 86664,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1, 11150, 3, nil, nil,   nil, { 47201, 47202, 47203,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 11200, 2, nil, nil,   nil, { 85099, 85100,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1, 11152, 1, nil, nil,   nil, { 48181,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[867] = {
			{  0,  0, 10994, 3, nil, nil,   nil, { 18697, 18698, 18699,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 10992, 3, nil, nil,   nil, { 18694, 85283, 85284,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 11206, 2, nil, nil,   nil, { 47230, 47231,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 11713, 2, nil, nil,   nil, { 88446, 88447,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 11020, 2, nil, nil,   nil, { 30326, 85175,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 11190, 2, nil, nil,   nil, { 30143, 30144,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3, 11014, 2, nil, nil,   nil, { 18709, 18710,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 11198, 3, nil, nil,   nil, { 85106, 85107, 85108,   nil,  nil, }, 'TEXTURE', },
			{  2,  1, 11160, 1, nil, nil,   nil, { 47193,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 10998, 2, nil, nil,   nil, { 18703, 18704,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 11024, 3, nil, nil,   nil, { 47245, 47246, 47247,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 11201, 1, nil, nil,   nil, { 71521,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 11814, 2,   3,   1, 11201, { 89604, 89605,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 11188, 2, nil, nil,   nil, { 85109, 85110,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1, 11189, 1,   3,   1, 11201, { 85105,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2, 11034, 2, nil, nil,   nil, { 63156, 63158,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1, 11199, 2,   4,   1, 11189, { 85103, 85104,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 11042, 1, nil, nil,   nil, { 47236,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1, 11044, 1, nil, nil,   nil, { 59672,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	WARRIOR = {
		[746] = {
			{  0,  0, 10134, 3, nil, nil,   nil, { 84570, 84571, 84572,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 11163, 2, nil, nil,   nil, { 84579, 84580,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  9664, 2, nil, nil,   nil, { 80976, 80977,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 11416, 2, nil, nil,   nil, { 12295, 12676,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  8190, 2, nil, nil,   nil, { 29834, 29838,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  8176, 3, nil, nil,   nil, { 12834, 12849, 12867,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  8184, 2, nil, nil,   nil, { 12290, 12963,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 10138, 3, nil, nil,   nil, { 56636, 56637, 56638,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  8192, 1, nil, nil,   nil, { 12328,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 10741, 2,   1,   2,  8176, { 16493, 16494,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 11417, 2, nil, nil,   nil, { 12289, 12668,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 11418, 2, nil, nil,   nil, { 86655, 12330,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 11223, 1, nil, nil,   nil, { 85730,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  9662, 2, nil, nil,   nil, { 29836, 29859,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 10520, 3, nil, nil,   nil, { 84583, 84587, 84588,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  8208, 1, nil, nil,   nil, { 64976,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,  8214, 2, nil, nil,   nil, { 29723, 29725,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  8194, 2, nil, nil,   nil, { 46867, 56611,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 11167, 1,   4,   1,  8208, { 85388,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  8222, 1,   4,   1,  8208, { 46924,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[845] = {
			{  0,  0, 10464, 3, nil, nil,   nil, { 50685, 50686, 50687,   nil,  nil, }, 'TEXTURE', },
			{  0,  1, 10474, 3, nil, nil,   nil, { 12299, 12761, 12762,   nil,  nil, }, 'TEXTURE', },
			{  0,  2, 10480, 2, nil, nil,   nil, { 84614, 84615,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0, 10466, 3, nil, nil,   nil, { 12298, 12724, 12725,   nil,  nil, }, 'TEXTURE', },
			{  1,  1, 10472, 3, nil, nil,   nil, { 29598, 84607, 84608,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 11170, 2, nil, nil,   nil, { 84604, 84621,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3, 10468, 2, nil, nil,   nil, { 12311, 12958,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0, 10482, 1, nil, nil,   nil, { 12975,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  1, 10478, 1, nil, nil,   nil, { 12809,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2, 10934, 2, nil, nil,   nil, { 29593, 29594,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3, 10494, 1, nil, nil,   nil, { 57499,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 10470, 2, nil, nil,   nil, { 12797, 12799,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2, 10486, 1, nil, nil,   nil, { 20243,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3, 11217, 2,   3,   2, 10486, { 80128, 80129,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0, 10488, 2, nil, nil,   nil, { 80979, 80980,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1, 10492, 1,   2,   1, 10478, { 50720,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3, 10484, 2, nil, nil,   nil, { 86894, 86896,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1, 10490, 2, nil, nil,   nil, { 46945, 46949,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 10496, 3,   3,   2, 10486, { 46951, 46952, 46953,   nil,  nil, }, 'TEXTURE', },
			{  6,  1, 10498, 1, nil, nil,   nil, { 46968,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[815] = {
			{  0,  0,  9610, 3, nil, nil,   nil, { 16487, 16489, 16492,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  9606, 3, nil, nil,   nil, { 12322, 85741, 85742,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  9608, 2, nil, nil,   nil, { 12320, 12852,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  9644, 2, nil, nil,   nil, { 20502, 20503,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  9624, 2, nil, nil,   nil, { 12321, 12835,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2, 11415, 2, nil, nil,   nil, { 61216, 61221,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  9618, 1, nil, nil,   nil, { 12323,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  9636, 3, nil, nil,   nil, { 12319, 12971, 12972,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  9630, 1, nil, nil,   nil, { 12292,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  9612, 3, nil, nil,   nil, { 12317, 13045, 13046,   nil,  nil, }, 'TEXTURE', },
			{  3,  0, 11414, 2, nil, nil,   nil, { 81913, 81914,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1, 11208, 1,   2,   1,  9630, { 85288,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  9650, 1,   3,   1, 11208, { 29801,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  9648, 1, nil, nil,   nil, { 60970,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  9634, 1, nil, nil,   nil, { 46910,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  9642, 2, nil, nil,   nil, { 12329, 12950,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3, 10743, 2, nil, nil,   nil, { 46908, 46909,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  9654, 3,   3,   1, 11208, { 46913, 46914, 46915,   nil,  nil, }, 'TEXTURE', },
			{  5,  2, 10744, 2, nil, nil,   nil, { 29888, 29889,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  1,  9658, 1, nil, nil,   nil, { 46917,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  6,  2,  9660, 1, nil, nil,   nil, { 81099,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	--[[
	PET = {
		[409] = {
			{  0,  0,  2114, 2, nil, nil,   nil, { 61682, 61683,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  2237, 1, nil, nil,   nil, { 61685,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  2116, 3, nil, nil,   nil, { 61686, 61687, 61688,   nil,  nil, }, 'TEXTURE', },
			{  0,  3,  2117, 2, nil, nil,   nil, { 61689, 61690,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  2126, 3, nil, nil,   nil, { 53182, 53183, 53184,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  2160, 1, nil, nil,   nil, { 19596,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  2173, 2,   0,   2,  2116, { 53481, 53482,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  2122, 2,   0,   3,  2117, { 53175, 53176,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  2110, 3, nil, nil,   nil, { 61680, 61681, 52858,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  2123, 2, nil, nil,   nil, { 53178, 53179,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  2162, 2, nil, nil,   nil, { 53409, 53411,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3,  2277, 1, nil, nil,   nil, { 63900,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  2163, 2, nil, nil,   nil, { 53450, 53451,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  2161, 3, nil, nil,   nil, { 53427, 53429, 53430,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  2171, 1, nil, nil,   nil, { 53478,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  2170, 1,   2,   1,  2123, { 53477,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  2172, 1,   3,   2,  2163, { 53480,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,  2169, 1, nil, nil,   nil, { 53476,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  1,  2258, 2, nil, nil,   nil, { 62764, 62765,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  2255, 2,   4,   2,  2172, { 62758, 62762,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[410] = {
			{  0,  0,  2107, 2, nil, nil,   nil, { 61682, 61683,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  2109, 1, nil, nil,   nil, { 61684,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  2203, 1, nil, nil,   nil, { 23145,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  2112, 3, nil, nil,   nil, { 61686, 61687, 61688,   nil,  nil, }, 'TEXTURE', },
			{  0,  3,  2113, 2, nil, nil,   nil, { 61689, 61690,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  2124, 2, nil, nil,   nil, { 53180, 53181,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  2128, 2, nil, nil,   nil, { 53186, 53187,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  2125, 3, nil, nil,   nil, { 53182, 53183, 53184,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  2151, 1, nil, nil,   nil, { 19596,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  2106, 3, nil, nil,   nil, { 61680, 61681, 52858,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  2152, 2, nil, nil,   nil, { 53409, 53411,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3,  2111, 1, nil, nil,   nil, { 61685,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  3,  2219, 1, nil, nil,   nil, { 52825,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  2156, 1,   1,   1,  2128, { 55709,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  2129, 3, nil, nil,   nil, { 53203, 53204, 53205,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  2154, 3, nil, nil,   nil, { 53427, 53429, 53430,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  2155, 1, nil, nil,   nil, { 53401,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  2153, 1,   3,   1,  2156, { 53426,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  2157, 1,   3,   2,  2129, { 53434,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  2254, 2, nil, nil,   nil, { 62759, 62760,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  2,  2253, 2,   4,   2,  2157, { 62758, 62762,   nil,   nil,  nil, }, 'TEXTURE', },
		},
		[411] = {
			{  0,  0,  2118, 2, nil, nil,   nil, { 61682, 61683,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  2119, 1, nil, nil,   nil, { 61684,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  1,  2201, 1, nil, nil,   nil, { 23145,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  0,  2,  2120, 3, nil, nil,   nil, { 61686, 61687, 61688,   nil,  nil, }, 'TEXTURE', },
			{  0,  3,  2121, 2, nil, nil,   nil, { 61689, 61690,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  0,  2165, 1, nil, nil,   nil, { 19596,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  2207, 2,   0,   1,  2119, { 53483, 53485,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  1,  2208, 2,   0,   1,  2201, { 53554, 53555,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  2,  2182, 2, nil, nil,   nil, { 53514, 53516,   nil,   nil,  nil, }, 'TEXTURE', },
			{  1,  3,  2127, 3, nil, nil,   nil, { 53182, 53183, 53184,   nil,  nil, }, 'TEXTURE', },
			{  2,  0,  2166, 3, nil, nil,   nil, { 61680, 61681, 52858,   nil,  nil, }, 'TEXTURE', },
			{  2,  1,  2167, 2, nil, nil,   nil, { 53409, 53411,   nil,   nil,  nil, }, 'TEXTURE', },
			{  2,  2,  2206, 1, nil, nil,   nil, { 54044,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  1,  2168, 3, nil, nil,   nil, { 53427, 53429, 53430,   nil,  nil, }, 'TEXTURE', },
			{  3,  2,  2177, 2, nil, nil,   nil, { 52234, 53497,   nil,   nil,  nil, }, 'TEXTURE', },
			{  3,  3,  2183, 2,   1,   3,  2127, { 53511, 53512,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  0,  2181, 1, nil, nil,   nil, { 53508,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  1,  2184, 1, nil, nil,   nil, { 53517,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  2,  2175, 1,   3,   2,  2177, { 53490,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
			{  4,  3,  2257, 2, nil, nil,   nil, { 53450, 53451,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  0,  2256, 2,   4,   0,  2181, { 62758, 62762,   nil,   nil,  nil, }, 'TEXTURE', },
			{  5,  3,  2278, 1,   4,   3,  2257, { 53480,   nil,   nil,   nil,  nil, }, 'TEXTURE', },
		},
	},
	--]]
};
--
	--	DT.SpellDB_P
	--1------2---3-----4------5-----6--------7-------8
	--level, id, cost, phase, name, passive, talent, class
	--	passive = true, talent = true, race = "", require = SpellID,
--
DT.SpellDB = {
};

DT.TalentSpecIcon = {
	[41] = "Interface\\Icons\\spell_fire_firebolt02",
	[61] = "Interface\\Icons\\spell_frost_frostbolt02",
	[81] = "Interface\\Icons\\inv_misc_rune_03",
	[161] = "Interface\\Icons\\ability_rogue_eviscerate",--
	[163] = "Interface\\Icons\\ability_warrior_defensivestance",
	[164] = "Interface\\Icons\\ability_warrior_innerrage",
	-- [181] = "Interface\\Icons\\ability_backstab",
	-- [182] = "Interface\\Icons\\ability_rogue_eviscerate",--
	-- [183] = "Interface\\Icons\\Ability_Ambush",
	[201] = "Interface\\Icons\\spell_holy_wordfortitude",
	[202] = "Interface\\Icons\\spell_holy_holybolt",
	[203] = "Interface\\Icons\\spell_shadow_shadowwordpain",
	-- [261] = "Interface\\Icons\\spell_nature_lightning",
	-- [262] = "Interface\\Icons\\Spell_Nature_HealingWaveGreater",
	-- [263] = "Interface\\Icons\\spell_nature_lightningshield",
	[281] = "Interface\\Icons\\ability_racial_bearform",
	[282] = "Interface\\Icons\\Spell_Nature_HealingTouch",
	[283] = "Interface\\Icons\\spell_nature_starfall",
	[301] = "Interface\\Icons\\spell_shadow_rainoffire",
	[302] = "Interface\\Icons\\spell_shadow_deathcoil",
	[303] = "Interface\\Icons\\spell_shadow_metamorphosis",
	[361] = "Interface\\Icons\\Ability_Hunter_BeastTaming",
	[362] = "Interface\\Icons\\Ability_Hunter_SwiftStrike",
	[363] = "Interface\\Icons\\Ability_Marksmanship",
	[381] = "Interface\\Icons\\Spell_Holy_AuraOfLight",
	[382] = "Interface\\Icons\\Spell_Holy_HolyBolt",
	[383] = "Interface\\Icons\\Spell_Holy_DevotionAura",

	[398] = "Interface\\Icons\\Spell_Deathknight_BloodPresence",
	[399] = "Interface\\Icons\\Spell_Deathknight_FrostPresence",
	[400] = "Interface\\Icons\\Spell_Deathknight_UnholyPresence",
	[409] = "Interface\\Icons\\Ability_Hunter_Pet_Bear",
	[410] = "Interface\\Icons\\Ability_Druid_Swipe",
	[411] = "Interface\\Icons\\Ability_Hunter_CombatExperience",

	[851] = "Interface\\Icons\\spell_fire_firebolt02",
	[823] = "Interface\\Icons\\spell_frost_frostbolt02",
	[799] = "Interface\\Icons\\inv_misc_rune_03",
	[746] = "Interface\\Icons\\ability_rogue_eviscerate",--
	[845] = "Interface\\Icons\\ability_warrior_defensivestance",
	[815] = "Interface\\Icons\\ability_warrior_innerrage",
	[181] = "Interface\\Icons\\ability_backstab",
	[182] = "Interface\\Icons\\ability_rogue_eviscerate",--
	[183] = "Interface\\Icons\\Ability_Ambush",
	[760] = "Interface\\Icons\\spell_holy_wordfortitude",
	[813] = "Interface\\Icons\\spell_holy_holybolt",
	[795] = "Interface\\Icons\\spell_shadow_shadowwordpain",
	[261] = "Interface\\Icons\\spell_nature_lightning",
	[262] = "Interface\\Icons\\Spell_Nature_HealingWaveGreater",
	[263] = "Interface\\Icons\\spell_nature_lightningshield",
	[750] = "Interface\\Icons\\ability_racial_bearform",
	[748] = "Interface\\Icons\\Spell_Nature_HealingTouch",
	[752] = "Interface\\Icons\\spell_nature_starfall",
	[865] = "Interface\\Icons\\spell_shadow_rainoffire",
	[871] = "Interface\\Icons\\spell_shadow_deathcoil",
	[867] = "Interface\\Icons\\spell_shadow_metamorphosis",
	[811] = "Interface\\Icons\\Ability_Hunter_BeastTaming",
	[809] = "Interface\\Icons\\Ability_Hunter_SwiftStrike",
	[807] = "Interface\\Icons\\Ability_Marksmanship",
	[855] = "Interface\\Icons\\Spell_Holy_AuraOfLight",
	[831] = "Interface\\Icons\\Spell_Holy_HolyBolt",
	[839] = "Interface\\Icons\\Spell_Holy_DevotionAura",

	[398] = "Interface\\Icons\\Spell_Deathknight_BloodPresence",
	[399] = "Interface\\Icons\\Spell_Deathknight_FrostPresence",
	[400] = "Interface\\Icons\\Spell_Deathknight_UnholyPresence",
	[409] = "Interface\\Icons\\Ability_Hunter_Pet_Bear",
	[410] = "Interface\\Icons\\Ability_Druid_Swipe",
	[411] = "Interface\\Icons\\Ability_Hunter_CombatExperience",
};

DT.ClassBackground = {
	DEATHKNIGHT = {
		"Interface\\TalentFrame\\bg-deathknight-blood",
		"Interface\\TalentFrame\\bg-deathknight-frost",
		"Interface\\TalentFrame\\bg-deathknight-unholy",
	},
	DRUID = {
		"Interface\\TalentFrame\\bg-druid-balance",
		"Interface\\TalentFrame\\bg-druid-bear",
		"Interface\\TalentFrame\\bg-druid-cat",
		"Interface\\TalentFrame\\bg-druid-restoration",
	},
	HUNTER = {
		"Interface\\TalentFrame\\bg-hunter-beastmaster",
		"Interface\\TalentFrame\\bg-hunter-marksman",
		"Interface\\TalentFrame\\bg-hunter-survival",
	},
	MAGE = {
		"Interface\\TalentFrame\\bg-mage-arcane",
		"Interface\\TalentFrame\\bg-mage-fire",
		"Interface\\TalentFrame\\bg-mage-frost",
	},
	MONK = {
		"Interface\\TalentFrame\\bg-monk-battledancer",
		"Interface\\TalentFrame\\bg-monk-brewmaster",
		"Interface\\TalentFrame\\bg-monk-mistweaver",
	},
	PALADIN = {
		"Interface\\TalentFrame\\bg-paladin-holy",
		"Interface\\TalentFrame\\bg-paladin-protection",
		"Interface\\TalentFrame\\bg-paladin-retribution",
	},
	PRIEST = {
		"Interface\\TalentFrame\\bg-priest-discipline",
		"Interface\\TalentFrame\\bg-priest-holy",
		"Interface\\TalentFrame\\bg-priest-shadow",
	},
	ROGUE = {
		"Interface\\TalentFrame\\bg-rogue-assassination",
		"Interface\\TalentFrame\\bg-rogue-combat",
		"Interface\\TalentFrame\\bg-rogue-subtlety",
	},
	SHAMAN = {
		"Interface\\TalentFrame\\bg-shaman-elemental",
		"Interface\\TalentFrame\\bg-shaman-enhancement",
		"Interface\\TalentFrame\\bg-shaman-restoration",
	},
	WARLOCK = {
		"Interface\\TalentFrame\\bg-warlock-affliction",
		"Interface\\TalentFrame\\bg-warlock-demonology",
		"Interface\\TalentFrame\\bg-warlock-destruction",
	},
	WARRIOR = {
		"Interface\\TalentFrame\\bg-warrior-arms",
		"Interface\\TalentFrame\\bg-warrior-fury",
		"Interface\\TalentFrame\\bg-warrior-protection",
	},
};

DT.SpecBackground = {
		[283] = "Interface\\TalentFrame\\DruidBalance-TopLeft",
		[281] = "Interface\\TalentFrame\\DruidFeralCombat-TopLeft",
		[282] = "Interface\\TalentFrame\\DruidRestoration-TopLeft",
		[361] = "Interface\\TalentFrame\\HunterBeastMastery-TopLeft",
		[363] = "Interface\\TalentFrame\\HunterMarksmanship-TopLeft",
		[362] = "Interface\\TalentFrame\\HunterSurvival-TopLeft",
		[81] = "Interface\\TalentFrame\\MageArcane-TopLeft",
		[41] = "Interface\\TalentFrame\\MageFire-TopLeft",
		[61] = "Interface\\TalentFrame\\MageFrost-TopLeft",
		[382] = "Interface\\TalentFrame\\PaladinHoly-TopLeft",
		[383] = "Interface\\TalentFrame\\PaladinProtection-TopLeft",
		[381] = "Interface\\TalentFrame\\PaladinCombat-TopLeft",
		[201] = "Interface\\TalentFrame\\PriestDiscipline-TopLeft",
		[202] = "Interface\\TalentFrame\\PriestHoly-TopLeft",
		[203] = "Interface\\TalentFrame\\PriestShadow-TopLeft",
		-- [182] = "Interface\\TalentFrame\\RogueAssassination-TopLeft",
		-- [181] = "Interface\\TalentFrame\\RogueCombat-TopLeft",
		-- [183] = "Interface\\TalentFrame\\RogueSubtlety-TopLeft",
		-- [261] = "Interface\\TalentFrame\\ShamanElementalCombat-TopLeft",
		-- [263] = "Interface\\TalentFrame\\ShamanEnhancement-TopLeft",
		-- [262] = "Interface\\TalentFrame\\ShamanRestoration-TopLeft",
		[302] = "Interface\\TalentFrame\\WarlockCurses-TopLeft",
		[303] = "Interface\\TalentFrame\\WarlockSummoning-TopLeft",
		[301] = "Interface\\TalentFrame\\WarlockDestruction-TopLeft",
		[161] = "Interface\\TalentFrame\\WarriorArms-TopLeft",
		[164] = "Interface\\TalentFrame\\WarriorFury-TopLeft",
		[163] = "Interface\\TalentFrame\\WarriorProtection-TopLeft",

		[752] = "Interface\\TalentFrame\\DruidBalance-TopLeft",
		[750] = "Interface\\TalentFrame\\DruidFeralCombat-TopLeft",
		[748] = "Interface\\TalentFrame\\DruidRestoration-TopLeft",
		[811] = "Interface\\TalentFrame\\HunterBeastMastery-TopLeft",
		[807] = "Interface\\TalentFrame\\HunterMarksmanship-TopLeft",
		[809] = "Interface\\TalentFrame\\HunterSurvival-TopLeft",
		[799] = "Interface\\TalentFrame\\MageArcane-TopLeft",
		[851] = "Interface\\TalentFrame\\MageFire-TopLeft",
		[823] = "Interface\\TalentFrame\\MageFrost-TopLeft",
		[831] = "Interface\\TalentFrame\\PaladinHoly-TopLeft",
		[839] = "Interface\\TalentFrame\\PaladinProtection-TopLeft",
		[855] = "Interface\\TalentFrame\\PaladinCombat-TopLeft",
		[760] = "Interface\\TalentFrame\\PriestDiscipline-TopLeft",
		[813] = "Interface\\TalentFrame\\PriestHoly-TopLeft",
		[795] = "Interface\\TalentFrame\\PriestShadow-TopLeft",
		[182] = "Interface\\TalentFrame\\RogueAssassination-TopLeft",
		[181] = "Interface\\TalentFrame\\RogueCombat-TopLeft",
		[183] = "Interface\\TalentFrame\\RogueSubtlety-TopLeft",
		[261] = "Interface\\TalentFrame\\ShamanElementalCombat-TopLeft",
		[263] = "Interface\\TalentFrame\\ShamanEnhancement-TopLeft",
		[262] = "Interface\\TalentFrame\\ShamanRestoration-TopLeft",
		[871] = "Interface\\TalentFrame\\WarlockCurses-TopLeft",
		[867] = "Interface\\TalentFrame\\WarlockSummoning-TopLeft",
		[865] = "Interface\\TalentFrame\\WarlockDestruction-TopLeft",
		[746] = "Interface\\TalentFrame\\WarriorArms-TopLeft",
		[815] = "Interface\\TalentFrame\\WarriorFury-TopLeft",
		[845] = "Interface\\TalentFrame\\WarriorProtection-TopLeft",
};

DT.PresetTalents = {
};

DT.TalentMap = {
	DEATHKNIGHT = {
		VMap = {
			{
				[1] = 3,
				[2] = 9,
				[3] = 2,
				[4] = 20,
				[5] = 5,
				[6] = 17,
				[7] = 19,
				[8] = 15,
				[9] = 14,
				[10] = 13,
				[11] = 11,
				[12] = 16,
				[13] = 7,
				[14] = 1,
				[15] = 6,
				[16] = 4,
				[17] = 10,
				[18] = 12,
				[19] = 18,
				[20] = 8,
			},
			{
				[1] = 11,
				[2] = 12,
				[3] = 9,
				[4] = 14,
				[5] = 15,
				[6] = 20,
				[7] = 1,
				[8] = 7,
				[9] = 4,
				[10] = 13,
				[11] = 6,
				[12] = 2,
				[13] = 16,
				[14] = 3,
				[15] = 17,
				[16] = 8,
				[17] = 10,
				[18] = 18,
				[19] = 19,
				[20] = 5,
			},
			{
				[1] = 7,
				[2] = 1,
				[3] = 2,
				[4] = 13,
				[5] = 14,
				[6] = 17,
				[7] = 9,
				[8] = 15,
				[9] = 19,
				[10] = 18,
				[11] = 20,
				[12] = 5,
				[13] = 10,
				[14] = 3,
				[15] = 12,
				[16] = 6,
				[17] = 11,
				[18] = 8,
				[19] = 16,
				[20] = 4,
			},
		},
		RMap = {
			{
				[1] = 14,
				[2] = 3,
				[3] = 1,
				[4] = 16,
				[5] = 5,
				[6] = 15,
				[7] = 13,
				[8] = 20,
				[9] = 2,
				[10] = 17,
				[11] = 11,
				[12] = 18,
				[13] = 10,
				[14] = 9,
				[15] = 8,
				[16] = 12,
				[17] = 6,
				[18] = 19,
				[19] = 7,
				[20] = 4,
			},
			{
				[1] = 7,
				[2] = 12,
				[3] = 14,
				[4] = 9,
				[5] = 20,
				[6] = 11,
				[7] = 8,
				[8] = 16,
				[9] = 3,
				[10] = 17,
				[11] = 1,
				[12] = 2,
				[13] = 10,
				[14] = 4,
				[15] = 5,
				[16] = 13,
				[17] = 15,
				[18] = 18,
				[19] = 19,
				[20] = 6,
			},
			{
				[1] = 2,
				[2] = 3,
				[3] = 14,
				[4] = 20,
				[5] = 12,
				[6] = 16,
				[7] = 1,
				[8] = 18,
				[9] = 7,
				[10] = 13,
				[11] = 17,
				[12] = 15,
				[13] = 4,
				[14] = 5,
				[15] = 8,
				[16] = 19,
				[17] = 6,
				[18] = 10,
				[19] = 9,
				[20] = 11,
			},
		},
	},
	DRUID = {
		RMap = {
			{
				[1] = 2,
				[2] = 5,
				[3] = 1,
				[4] = 13,
				[5] = 12,
				[6] = 10,
				[7] = 6,
				[8] = 7,
				[9] = 11,
				[10] = 19,
				[11] = 15,
				[12] = 18,
				[13] = 20,
				[14] = 17,
				[15] = 8,
				[16] = 3,
				[17] = 9,
				[18] = 4,
				[19] = 14,
				[20] = 16,
			},
			{
				[1] = 11,
				[2] = 1,
				[3] = 9,
				[4] = 10,
				[5] = 14,
				[6] = 5,
				[7] = 13,
				[8] = 16,
				[9] = 21,
				[10] = 8,
				[11] = 12,
				[12] = 15,
				[13] = 19,
				[14] = 20,
				[15] = 22,
				[16] = 18,
				[17] = 17,
				[18] = 4,
				[19] = 6,
				[20] = 3,
				[21] = 7,
				[22] = 2,
			},
			{
				[1] = 1,
				[2] = 2,
				[3] = 7,
				[4] = 10,
				[5] = 8,
				[6] = 12,
				[7] = 15,
				[8] = 20,
				[9] = 18,
				[10] = 9,
				[11] = 21,
				[12] = 6,
				[13] = 16,
				[14] = 13,
				[15] = 17,
				[16] = 5,
				[17] = 19,
				[18] = 3,
				[19] = 11,
				[20] = 4,
				[21] = 14,
			},
		},
		VMap = {
			{
				[1] = 3,
				[2] = 1,
				[3] = 16,
				[4] = 18,
				[5] = 2,
				[6] = 7,
				[7] = 8,
				[8] = 15,
				[9] = 17,
				[10] = 6,
				[11] = 9,
				[12] = 5,
				[13] = 4,
				[14] = 19,
				[15] = 11,
				[16] = 20,
				[17] = 14,
				[18] = 12,
				[19] = 10,
				[20] = 13,
			},
			{
				[1] = 2,
				[2] = 22,
				[3] = 20,
				[4] = 18,
				[5] = 6,
				[6] = 19,
				[7] = 21,
				[8] = 10,
				[9] = 3,
				[10] = 4,
				[11] = 1,
				[12] = 11,
				[13] = 7,
				[14] = 5,
				[15] = 12,
				[16] = 8,
				[17] = 17,
				[18] = 16,
				[19] = 13,
				[20] = 14,
				[21] = 9,
				[22] = 15,
			},
			{
				[1] = 1,
				[2] = 2,
				[3] = 18,
				[4] = 20,
				[5] = 16,
				[6] = 12,
				[7] = 3,
				[8] = 5,
				[9] = 10,
				[10] = 4,
				[11] = 19,
				[12] = 6,
				[13] = 14,
				[14] = 21,
				[15] = 7,
				[16] = 13,
				[17] = 15,
				[18] = 9,
				[19] = 17,
				[20] = 8,
				[21] = 11,
			},
		},
	},
	WARRIOR = {
		VMap = {
			{
				[1] = 11,
				[2] = 15,
				[3] = 10,
				[4] = 18,
				[5] = 3,
				[6] = 1,
				[7] = 2,
				[8] = 12,
				[9] = 4,
				[10] = 14,
				[11] = 19,
				[12] = 20,
				[13] = 17,
				[14] = 9,
				[15] = 13,
				[16] = 6,
				[17] = 7,
				[18] = 5,
				[19] = 16,
				[20] = 8,
			},
			{
				[1] = 3,
				[2] = 1,
				[3] = 2,
				[4] = 11,
				[5] = 6,
				[6] = 21,
				[7] = 5,
				[8] = 9,
				[9] = 7,
				[10] = 4,
				[11] = 20,
				[12] = 19,
				[13] = 13,
				[14] = 12,
				[15] = 8,
				[16] = 10,
				[17] = 17,
				[18] = 14,
				[19] = 18,
				[20] = 15,
				[21] = 16,
			},
			{
				[1] = 1,
				[2] = 6,
				[3] = 8,
				[4] = 2,
				[5] = 5,
				[6] = 19,
				[7] = 3,
				[8] = 9,
				[9] = 7,
				[10] = 18,
				[11] = 15,
				[12] = 4,
				[13] = 11,
				[14] = 20,
				[15] = 12,
				[16] = 14,
				[17] = 10,
				[18] = 13,
				[19] = 16,
				[20] = 17,
			},
		},
		RMap = {
			{
				[1] = 6,
				[2] = 7,
				[3] = 5,
				[4] = 9,
				[5] = 18,
				[6] = 16,
				[7] = 17,
				[8] = 20,
				[9] = 14,
				[10] = 3,
				[11] = 1,
				[12] = 8,
				[13] = 15,
				[14] = 10,
				[15] = 2,
				[16] = 19,
				[17] = 13,
				[18] = 4,
				[19] = 11,
				[20] = 12,
			},
			{
				[1] = 2,
				[2] = 3,
				[3] = 1,
				[4] = 10,
				[5] = 7,
				[6] = 5,
				[7] = 9,
				[8] = 15,
				[9] = 8,
				[10] = 16,
				[11] = 4,
				[12] = 14,
				[13] = 13,
				[14] = 18,
				[15] = 20,
				[16] = 21,
				[17] = 17,
				[18] = 19,
				[19] = 12,
				[20] = 11,
				[21] = 6,
			},
			{
				[1] = 1,
				[2] = 4,
				[3] = 7,
				[4] = 12,
				[5] = 5,
				[6] = 2,
				[7] = 9,
				[8] = 3,
				[9] = 8,
				[10] = 17,
				[11] = 13,
				[12] = 15,
				[13] = 18,
				[14] = 16,
				[15] = 11,
				[16] = 19,
				[17] = 20,
				[18] = 10,
				[19] = 6,
				[20] = 14,
			},
		},
	},
	SHAMAN = {
		RMap = {
			{
				[1] = 4,
				[2] = 3,
				[3] = 2,
				[4] = 14,
				[5] = 9,
				[6] = 6,
				[7] = 5,
				[8] = 10,
				[9] = 7,
				[10] = 19,
				[11] = 11,
				[12] = 12,
				[13] = 16,
				[14] = 18,
				[15] = 1,
				[16] = 17,
				[17] = 8,
				[18] = 15,
				[19] = 13,
			},
			{
				[1] = 5,
				[2] = 6,
				[3] = 3,
				[4] = 1,
				[5] = 8,
				[6] = 9,
				[7] = 16,
				[8] = 15,
				[9] = 10,
				[10] = 14,
				[11] = 17,
				[12] = 19,
				[13] = 13,
				[14] = 2,
				[15] = 18,
				[16] = 4,
				[17] = 11,
				[18] = 7,
				[19] = 12,
			},
			{
				[1] = 8,
				[2] = 4,
				[3] = 11,
				[4] = 15,
				[5] = 9,
				[6] = 2,
				[7] = 5,
				[8] = 10,
				[9] = 7,
				[10] = 19,
				[11] = 14,
				[12] = 18,
				[13] = 20,
				[14] = 12,
				[15] = 6,
				[16] = 1,
				[17] = 16,
				[18] = 3,
				[19] = 13,
				[20] = 17,
			},
		},
		VMap = {
			{
				[1] = 15,
				[2] = 3,
				[3] = 2,
				[4] = 1,
				[5] = 7,
				[6] = 6,
				[7] = 9,
				[8] = 17,
				[9] = 5,
				[10] = 8,
				[11] = 11,
				[12] = 12,
				[13] = 19,
				[14] = 4,
				[15] = 18,
				[16] = 13,
				[17] = 16,
				[18] = 14,
				[19] = 10,
			},
			{
				[1] = 4,
				[2] = 14,
				[3] = 3,
				[4] = 16,
				[5] = 1,
				[6] = 2,
				[7] = 18,
				[8] = 5,
				[9] = 6,
				[10] = 9,
				[11] = 17,
				[12] = 19,
				[13] = 13,
				[14] = 10,
				[15] = 8,
				[16] = 7,
				[17] = 11,
				[18] = 15,
				[19] = 12,
			},
			{
				[1] = 16,
				[2] = 6,
				[3] = 18,
				[4] = 2,
				[5] = 7,
				[6] = 15,
				[7] = 9,
				[8] = 1,
				[9] = 5,
				[10] = 8,
				[11] = 3,
				[12] = 14,
				[13] = 19,
				[14] = 11,
				[15] = 4,
				[16] = 17,
				[17] = 20,
				[18] = 12,
				[19] = 10,
				[20] = 13,
			},
		},
	},
	MAGE = {
		RMap = {
			{
				[1] = 12,
				[2] = 1,
				[3] = 2,
				[4] = 4,
				[5] = 7,
				[6] = 9,
				[7] = 11,
				[8] = 16,
				[9] = 21,
				[10] = 14,
				[11] = 8,
				[12] = 20,
				[13] = 17,
				[14] = 10,
				[15] = 3,
				[16] = 19,
				[17] = 13,
				[18] = 6,
				[19] = 5,
				[20] = 18,
				[21] = 22,
				[22] = 15,
			},
			{
				[1] = 3,
				[2] = 4,
				[3] = 2,
				[4] = 7,
				[5] = 20,
				[6] = 12,
				[7] = 1,
				[8] = 11,
				[9] = 9,
				[10] = 6,
				[11] = 19,
				[12] = 13,
				[13] = 18,
				[14] = 17,
				[15] = 10,
				[16] = 21,
				[17] = 16,
				[18] = 15,
				[19] = 8,
				[20] = 5,
				[21] = 14,
			},
			{
				[1] = 4,
				[2] = 7,
				[3] = 9,
				[4] = 8,
				[5] = 1,
				[6] = 13,
				[7] = 10,
				[8] = 15,
				[9] = 16,
				[10] = 14,
				[11] = 12,
				[12] = 19,
				[13] = 6,
				[14] = 2,
				[15] = 3,
				[16] = 18,
				[17] = 5,
				[18] = 11,
				[19] = 17,
			},
		},
		VMap = {
			{
				[1] = 2,
				[2] = 3,
				[3] = 15,
				[4] = 4,
				[5] = 19,
				[6] = 18,
				[7] = 5,
				[8] = 11,
				[9] = 6,
				[10] = 14,
				[11] = 7,
				[12] = 1,
				[13] = 17,
				[14] = 10,
				[15] = 22,
				[16] = 8,
				[17] = 13,
				[18] = 20,
				[19] = 16,
				[20] = 12,
				[21] = 9,
				[22] = 21,
			},
			{
				[1] = 7,
				[2] = 3,
				[3] = 1,
				[4] = 2,
				[5] = 20,
				[6] = 10,
				[7] = 4,
				[8] = 19,
				[9] = 9,
				[10] = 15,
				[11] = 8,
				[12] = 6,
				[13] = 12,
				[14] = 21,
				[15] = 18,
				[16] = 17,
				[17] = 14,
				[18] = 13,
				[19] = 11,
				[20] = 5,
				[21] = 16,
			},
			{
				[1] = 5,
				[2] = 14,
				[3] = 15,
				[4] = 1,
				[5] = 17,
				[6] = 13,
				[7] = 2,
				[8] = 4,
				[9] = 3,
				[10] = 7,
				[11] = 18,
				[12] = 11,
				[13] = 6,
				[14] = 10,
				[15] = 8,
				[16] = 9,
				[17] = 19,
				[18] = 16,
				[19] = 12,
			},
		},
	},
	PRIEST = {
		VMap = {
			{
				[1] = 15,
				[2] = 1,
				[3] = 5,
				[4] = 4,
				[5] = 18,
				[6] = 2,
				[7] = 8,
				[8] = 16,
				[9] = 10,
				[10] = 19,
				[11] = 3,
				[12] = 11,
				[13] = 17,
				[14] = 7,
				[15] = 20,
				[16] = 9,
				[17] = 13,
				[18] = 21,
				[19] = 12,
				[20] = 14,
				[21] = 6,
			},
			{
				[1] = 11,
				[2] = 2,
				[3] = 1,
				[4] = 15,
				[5] = 19,
				[6] = 3,
				[7] = 7,
				[8] = 5,
				[9] = 12,
				[10] = 20,
				[11] = 21,
				[12] = 16,
				[13] = 4,
				[14] = 6,
				[15] = 13,
				[16] = 18,
				[17] = 17,
				[18] = 9,
				[19] = 14,
				[20] = 8,
				[21] = 10,
			},
			{
				[1] = 1,
				[2] = 2,
				[3] = 5,
				[4] = 3,
				[5] = 4,
				[6] = 9,
				[7] = 20,
				[8] = 10,
				[9] = 11,
				[10] = 18,
				[11] = 6,
				[12] = 7,
				[13] = 21,
				[14] = 8,
				[15] = 15,
				[16] = 14,
				[17] = 19,
				[18] = 13,
				[19] = 17,
				[20] = 12,
				[21] = 16,
			},
		},
		RMap = {
			{
				[1] = 2,
				[2] = 6,
				[3] = 11,
				[4] = 4,
				[5] = 3,
				[6] = 21,
				[7] = 14,
				[8] = 7,
				[9] = 16,
				[10] = 9,
				[11] = 12,
				[12] = 19,
				[13] = 17,
				[14] = 20,
				[15] = 1,
				[16] = 8,
				[17] = 13,
				[18] = 5,
				[19] = 10,
				[20] = 15,
				[21] = 18,
			},
			{
				[1] = 3,
				[2] = 2,
				[3] = 6,
				[4] = 13,
				[5] = 8,
				[6] = 14,
				[7] = 7,
				[8] = 20,
				[9] = 18,
				[10] = 21,
				[11] = 1,
				[12] = 9,
				[13] = 15,
				[14] = 19,
				[15] = 4,
				[16] = 12,
				[17] = 17,
				[18] = 16,
				[19] = 5,
				[20] = 10,
				[21] = 11,
			},
			{
				[1] = 1,
				[2] = 2,
				[3] = 4,
				[4] = 5,
				[5] = 3,
				[6] = 11,
				[7] = 12,
				[8] = 14,
				[9] = 6,
				[10] = 8,
				[11] = 9,
				[12] = 20,
				[13] = 18,
				[14] = 16,
				[15] = 15,
				[16] = 21,
				[17] = 19,
				[18] = 10,
				[19] = 17,
				[20] = 7,
				[21] = 13,
			},
		},
	},
	WARLOCK = {
		RMap = {
			{
				[1] = 1,
				[2] = 3,
				[3] = 2,
				[4] = 5,
				[5] = 8,
				[6] = 14,
				[7] = 12,
				[8] = 7,
				[9] = 9,
				[10] = 10,
				[11] = 13,
				[12] = 16,
				[13] = 18,
				[14] = 17,
				[15] = 4,
				[16] = 11,
				[17] = 15,
				[18] = 6,
			},
			{
				[1] = 2,
				[2] = 1,
				[3] = 10,
				[4] = 7,
				[5] = 5,
				[6] = 11,
				[7] = 16,
				[8] = 18,
				[9] = 19,
				[10] = 9,
				[11] = 14,
				[12] = 15,
				[13] = 6,
				[14] = 8,
				[15] = 17,
				[16] = 12,
				[17] = 3,
				[18] = 4,
				[19] = 13,
			},
			{
				[1] = 2,
				[2] = 1,
				[3] = 7,
				[4] = 9,
				[5] = 12,
				[6] = 3,
				[7] = 18,
				[8] = 16,
				[9] = 11,
				[10] = 8,
				[11] = 15,
				[12] = 17,
				[13] = 14,
				[14] = 19,
				[15] = 5,
				[16] = 10,
				[17] = 6,
				[18] = 4,
				[19] = 13,
			},
		},
		VMap = {
			{
				[1] = 1,
				[2] = 3,
				[3] = 2,
				[4] = 15,
				[5] = 4,
				[6] = 18,
				[7] = 8,
				[8] = 5,
				[9] = 9,
				[10] = 10,
				[11] = 16,
				[12] = 7,
				[13] = 11,
				[14] = 6,
				[15] = 17,
				[16] = 12,
				[17] = 14,
				[18] = 13,
			},
			{
				[1] = 2,
				[2] = 1,
				[3] = 17,
				[4] = 18,
				[5] = 5,
				[6] = 13,
				[7] = 4,
				[8] = 14,
				[9] = 10,
				[10] = 3,
				[11] = 6,
				[12] = 16,
				[13] = 19,
				[14] = 11,
				[15] = 12,
				[16] = 7,
				[17] = 15,
				[18] = 8,
				[19] = 9,
			},
			{
				[1] = 2,
				[2] = 1,
				[3] = 6,
				[4] = 18,
				[5] = 15,
				[6] = 17,
				[7] = 3,
				[8] = 10,
				[9] = 4,
				[10] = 16,
				[11] = 9,
				[12] = 5,
				[13] = 19,
				[14] = 13,
				[15] = 11,
				[16] = 8,
				[17] = 12,
				[18] = 7,
				[19] = 14,
			},
		},
	},
	HUNTER = {
		VMap = {
			{
				[1] = 3,
				[2] = 1,
				[3] = 2,
				[4] = 4,
				[5] = 8,
				[6] = 7,
				[7] = 6,
				[8] = 14,
				[9] = 5,
				[10] = 10,
				[11] = 15,
				[12] = 13,
				[13] = 19,
				[14] = 12,
				[15] = 9,
				[16] = 17,
				[17] = 16,
				[18] = 11,
				[19] = 18,
			},
			{
				[1] = 3,
				[2] = 2,
				[3] = 1,
				[4] = 4,
				[5] = 6,
				[6] = 5,
				[7] = 15,
				[8] = 8,
				[9] = 19,
				[10] = 9,
				[11] = 10,
				[12] = 11,
				[13] = 13,
				[14] = 14,
				[15] = 12,
				[16] = 7,
				[17] = 16,
				[18] = 17,
				[19] = 18,
			},
			{
				[1] = 3,
				[2] = 1,
				[3] = 6,
				[4] = 4,
				[5] = 19,
				[6] = 2,
				[7] = 12,
				[8] = 18,
				[9] = 5,
				[10] = 7,
				[11] = 8,
				[12] = 17,
				[13] = 9,
				[14] = 10,
				[15] = 11,
				[16] = 13,
				[17] = 14,
				[18] = 15,
				[19] = 20,
				[20] = 16,
			},
		},
		RMap = {
			{
				[1] = 2,
				[2] = 3,
				[3] = 1,
				[4] = 4,
				[5] = 9,
				[6] = 7,
				[7] = 6,
				[8] = 5,
				[9] = 15,
				[10] = 10,
				[11] = 18,
				[12] = 14,
				[13] = 12,
				[14] = 8,
				[15] = 11,
				[16] = 17,
				[17] = 16,
				[18] = 19,
				[19] = 13,
			},
			{
				[1] = 3,
				[2] = 2,
				[3] = 1,
				[4] = 4,
				[5] = 6,
				[6] = 5,
				[7] = 16,
				[8] = 8,
				[9] = 10,
				[10] = 11,
				[11] = 12,
				[12] = 15,
				[13] = 13,
				[14] = 14,
				[15] = 7,
				[16] = 17,
				[17] = 18,
				[18] = 19,
				[19] = 9,
			},
			{
				[1] = 2,
				[2] = 6,
				[3] = 1,
				[4] = 4,
				[5] = 9,
				[6] = 3,
				[7] = 10,
				[8] = 11,
				[9] = 13,
				[10] = 14,
				[11] = 15,
				[12] = 7,
				[13] = 16,
				[14] = 17,
				[15] = 18,
				[16] = 20,
				[17] = 12,
				[18] = 8,
				[19] = 5,
				[20] = 19,
			},
		},
	},
	PALADIN = {
		RMap = {
			{
				[1] = 5,
				[2] = 1,
				[3] = 7,
				[4] = 11,
				[5] = 16,
				[6] = 19,
				[7] = 14,
				[8] = 3,
				[9] = 9,
				[10] = 12,
				[11] = 18,
				[12] = 8,
				[13] = 20,
				[14] = 4,
				[15] = 13,
				[16] = 10,
				[17] = 15,
				[18] = 6,
				[19] = 17,
				[20] = 2,
			},
			{
				[1] = 2,
				[2] = 5,
				[3] = 17,
				[4] = 6,
				[5] = 19,
				[6] = 7,
				[7] = 8,
				[8] = 20,
				[9] = 15,
				[10] = 18,
				[11] = 4,
				[12] = 9,
				[13] = 14,
				[14] = 10,
				[15] = 11,
				[16] = 13,
				[17] = 16,
				[18] = 12,
				[19] = 3,
				[20] = 1,
			},
			{
				[1] = 17,
				[2] = 13,
				[3] = 1,
				[4] = 2,
				[5] = 8,
				[6] = 16,
				[7] = 7,
				[8] = 14,
				[9] = 18,
				[10] = 10,
				[11] = 11,
				[12] = 19,
				[13] = 20,
				[14] = 5,
				[15] = 15,
				[16] = 12,
				[17] = 9,
				[18] = 6,
				[19] = 3,
				[20] = 4,
			},
		},
		VMap = {
			{
				[1] = 2,
				[2] = 20,
				[3] = 8,
				[4] = 14,
				[5] = 1,
				[6] = 18,
				[7] = 3,
				[8] = 12,
				[9] = 9,
				[10] = 16,
				[11] = 4,
				[12] = 10,
				[13] = 15,
				[14] = 7,
				[15] = 17,
				[16] = 5,
				[17] = 19,
				[18] = 11,
				[19] = 6,
				[20] = 13,
			},
			{
				[1] = 20,
				[2] = 1,
				[3] = 19,
				[4] = 11,
				[5] = 2,
				[6] = 4,
				[7] = 6,
				[8] = 7,
				[9] = 12,
				[10] = 14,
				[11] = 15,
				[12] = 18,
				[13] = 16,
				[14] = 13,
				[15] = 9,
				[16] = 17,
				[17] = 3,
				[18] = 10,
				[19] = 5,
				[20] = 8,
			},
			{
				[1] = 3,
				[2] = 4,
				[3] = 19,
				[4] = 20,
				[5] = 14,
				[6] = 18,
				[7] = 7,
				[8] = 5,
				[9] = 17,
				[10] = 10,
				[11] = 11,
				[12] = 16,
				[13] = 2,
				[14] = 8,
				[15] = 15,
				[16] = 6,
				[17] = 1,
				[18] = 9,
				[19] = 12,
				[20] = 13,
			},
		},
	},
	ROGUE = {
		VMap = {
			{
				[1] = 15,
				[2] = 3,
				[3] = 1,
				[4] = 2,
				[5] = 11,
				[6] = 4,
				[7] = 16,
				[8] = 12,
				[9] = 6,
				[10] = 9,
				[11] = 19,
				[12] = 8,
				[13] = 17,
				[14] = 7,
				[15] = 10,
				[16] = 5,
				[17] = 13,
				[18] = 18,
				[19] = 14,
			},
			{
				[1] = 15,
				[2] = 3,
				[3] = 1,
				[4] = 11,
				[5] = 7,
				[6] = 8,
				[7] = 6,
				[8] = 2,
				[9] = 18,
				[10] = 16,
				[11] = 4,
				[12] = 10,
				[13] = 9,
				[14] = 12,
				[15] = 5,
				[16] = 13,
				[17] = 19,
				[18] = 17,
				[19] = 14,
			},
			{
				[1] = 1,
				[2] = 5,
				[3] = 15,
				[4] = 3,
				[5] = 11,
				[6] = 4,
				[7] = 2,
				[8] = 19,
				[9] = 16,
				[10] = 8,
				[11] = 12,
				[12] = 7,
				[13] = 18,
				[14] = 10,
				[15] = 6,
				[16] = 17,
				[17] = 13,
				[18] = 9,
				[19] = 14,
			},
		},
		RMap = {
			{
				[1] = 3,
				[2] = 4,
				[3] = 2,
				[4] = 6,
				[5] = 16,
				[6] = 9,
				[7] = 14,
				[8] = 12,
				[9] = 10,
				[10] = 15,
				[11] = 5,
				[12] = 8,
				[13] = 17,
				[14] = 19,
				[15] = 1,
				[16] = 7,
				[17] = 13,
				[18] = 18,
				[19] = 11,
			},
			{
				[1] = 3,
				[2] = 8,
				[3] = 2,
				[4] = 11,
				[5] = 15,
				[6] = 7,
				[7] = 5,
				[8] = 6,
				[9] = 13,
				[10] = 12,
				[11] = 4,
				[12] = 14,
				[13] = 16,
				[14] = 19,
				[15] = 1,
				[16] = 10,
				[17] = 18,
				[18] = 9,
				[19] = 17,
			},
			{
				[1] = 1,
				[2] = 7,
				[3] = 4,
				[4] = 6,
				[5] = 2,
				[6] = 15,
				[7] = 12,
				[8] = 10,
				[9] = 18,
				[10] = 14,
				[11] = 5,
				[12] = 11,
				[13] = 17,
				[14] = 19,
				[15] = 3,
				[16] = 9,
				[17] = 16,
				[18] = 13,
				[19] = 8,
			},
		},
	},
};

DT.PointsNeeded4SecondaryTree = 31
DT.LevelAvailablePointsTable = {  };
for i = 1, 9 do DT.LevelAvailablePointsTable[i] = 0; end
for i = 10, 80 do DT.LevelAvailablePointsTable[i] = math.floor((i - 7) / 2); end
for i = 81, 85 do DT.LevelAvailablePointsTable[i] = i - 44; end

DT.LevelAvailablePointsTableClass = {  };
local DK = {  };
for i = 1, 54 do DK[i] = 0; end
for i = 55, 80 do DK[i] = math.floor((i - 7) / 2); end
for i = 81, 85 do DK[i] = i - 44; end
DT.LevelAvailablePointsTableClass.DEATHKNIGHT = DK;

DT.ItemLevelColor = {
	--	BWD/TOF/BOT	359, 372
	--	FL			378/384, 391/397
	--	DS			397/403, 410/416
	step = {
		277,	--	灰色
		300,	--	白色
		346,	--	绿色
		359,	--	蓝色
		372,	--	紫色
		391,	--	橙色
	},
	list = {
		{ 0.5, 0.5, 0.5, },	--	灰色
		{ 1.0, 1.0, 1.0, },	--	白色
		{ 0.0, 1.0, 0.0, },	--	绿色
		{ 0.0, 0.5, 1.0, },	--	蓝色
		{ 0.6, 0.2, 1.0, },	--	紫色
		{ 1.0, 0.5, 0.0, },	--	橙色
	},
};

--	enchantID, spellID, itemID, classID, subClassMask, invTypeMask
local RawEnchantDB = {
	{ 1, 2605, nil, 2, 33155, },
	{ 15, 2831, 2304, 4, 30, },
	{ 16, 2832, 2313, 4, 30, },
	{ 17, 2833, 4265, 4, 30, },
	{ 18, 10344, 8173, 4, 30, },
	{ 24, 7443, 6342, 4, 31, },
	{ 30, 3974, 4405, 2, 262156, },
	{ 32, 3975, 4406, 2, 262156, },
	{ 33, 3976, 4407, 2, 262156, },
	{ 34, 7218, 6043, 2, 354, },
	{ 36, 6296, 5421, 2, 189939, },
	{ 37, 7220, 6041, 2, 173555, },
	{ 41, 7418, 38679, 4, 31, },
	{ 41, 7420, 38766, 4, 31, },
	{ 43, 7216, 6042, 4, 96, },
	{ 44, 7426, 38767, 4, 31, },
	{ 63, 13538, 38798, 4, 31, },
	{ 65, 7454, 38770, 4, 31, },
	{ 66, 7457, 38771, 4, 31, },
	{ 66, 7863, 6376, 4, 31, },
	{ 66, 13378, 38787, 4, 64, },
	{ 76, 3231, 22584, 4, 31, },
	{ 241, 7745, 38772, 2, 1378, },
	{ 241, 13503, 38794, 2, 189939, },
	{ 242, 7748, 38773, 4, 31, },
	{ 243, 7766, 6344, 4, 31, },
	{ 246, 7776, 6346, 4, 31, },
	{ 247, 7779, 38777, 4, 31, },
	{ 247, 7867, 6377, 4, 31, },
	{ 247, 13419, 11039, 4, 30, },
	{ 248, 7782, 6347, 4, 31, },
	{ 249, 7786, 6348, 2, 189939, },
	{ 250, 7788, 38780, 2, 189939, },
	{ 254, 7857, 38782, 4, 31, },
	{ 255, 7859, 6375, 4, 31, },
	{ 255, 13380, 11038, 2, 1378, },
	{ 255, 13485, 38792, 4, 64, },
	{ 255, 13687, 11167, 4, 30, },
	{ 256, 7861, 38784, 4, 31, },
	{ 368, 34004, 35432, 4, 30, },
	{ 368, 35813, 29860, 4, 31, },
	{ 369, 34001, 35423, 4, 30, },
	{ 369, 39403, 31842, 4, 30, },
	{ 463, 9781, 7967, 4, 96, },
	{ 464, 9783, 7969, 4, nil, },
	{ 663, 12459, 10546, 2, 262156, },
	{ 664, 12460, 10548, 2, 262156, },
	{ 684, 33995, 35442, 4, 31, },
	{ 684, 35819, 29867, 4, 31, },
	{ 723, 7793, 6349, 2, 1378, },
	{ 723, 13622, 38803, 4, 31, },
	{ 724, 13501, 38793, 4, 31, },
	{ 724, 13631, 38805, 4, 64, },
	{ 724, 13644, 38810, 4, 30, },
	{ 744, 13421, 38790, 4, nil, },
	{ 783, 7771, 6345, 4, 31, },
	{ 803, 13898, 11207, 2, 189939, },
	{ 803, 19927, nil, 2, 173555, },
	{ 803, 30183, 23725, 2, 189939, },
	{ 804, 13522, 11098, 4, 31, },
	{ 805, 13943, 38848, 2, 189939, },
	{ 823, 13536, 11101, 4, 31, },
	{ 843, 13607, 38799, 4, 31, },
	{ 844, 13612, 11150, 4, 31, },
	{ 845, 13617, 11151, 4, 31, },
	{ 846, 24302, 19971, 2, 1048576, },
	{ 846, 30187, 23727, 4, 31, },
	{ 846, 71692, 50406, 4, 31, },
	{ 847, 13626, 38804, 4, 31, },
	{ 848, 13464, 11081, 4, 64, },
	{ 848, 13635, 38806, 4, 30, },
	{ 849, 13637, 38807, 4, 31, },
	{ 849, 13882, 11206, 4, 30, },
	{ 850, 13640, 38808, 4, 30, },
	{ 851, 13642, 38809, 4, 30, },
	{ 851, 13659, 38816, 4, 64, },
	{ 851, 20024, 16220, 4, 30, },
	{ 851, 22102, 17895, 4, 30, },
	{ 852, 13648, 38812, 4, 30, },
	{ 852, 13817, 11202, 4, 64, },
	{ 852, 13836, 38830, 4, 30, },
	{ 853, 13653, 11164, 2, 189939, },
	{ 854, 13655, 11165, 2, 189939, },
	{ 856, 13661, 38817, 4, 30, },
	{ 856, 13887, 38836, 4, 31, },
	{ 857, 13663, 38818, 4, 30, },
	{ 863, 13689, 11168, 4, 64, },
	{ 863, 27117, 22038, 4, 64, },
	{ 865, 13698, 11166, 4, 31, },
	{ 865, 27114, 22035, 4, 31, },
	{ 866, 13700, 38824, 4, 31, },
	{ 884, 13746, 38825, 4, 30, },
	{ 903, 13794, 38826, 4, 30, },
	{ 904, 13815, 38827, 4, 31, },
	{ 904, 13935, 38844, 4, 30, },
	{ 905, 13822, 38829, 4, 30, },
	{ 906, 8375, 22585, 4, 30, },
	{ 906, 13841, 11203, 4, 31, },
	{ 907, 13846, 11204, 4, 30, },
	{ 907, 13905, 38839, 4, 64, },
	{ 908, 13858, 38833, 4, 31, },
	{ 909, 13868, 11205, 4, 31, },
	{ 909, 26020, 22586, 4, 30, },
	{ 910, 25083, 33149, 4, 31, },
	{ 910, 27120, 22041, 4, 31, },
	{ 910, 359640, 187738, 4, 30, },
	{ 911, 13890, 38837, 4, 30, },
	{ 911, 26019, 22587, 4, 30, },
	{ 912, 13915, 11208, 2, 189939, },
	{ 913, 13917, 38841, 4, 31, },
	{ 923, 13931, 11223, 4, 30, },
	{ 924, 7428, 38768, 4, 31, },
	{ 925, 13646, 11163, 4, 30, },
	{ 926, 13933, 11224, 4, 64, },
	{ 926, 22099, 17892, 4, 64, },
	{ 926, 359895, 187814, 4, 64, },
	{ 927, 13939, 38846, 4, 30, },
	{ 927, 20013, 16244, 4, 31, },
	{ 927, 22104, 17897, 4, 31, },
	{ 928, 13941, 38847, 4, 31, },
	{ 929, 13945, 11225, 4, 30, },
	{ 929, 20017, 16217, 4, 64, },
	{ 929, 20020, 16215, 4, 30, },
	{ 929, 22098, 17891, 4, 64, },
	{ 929, 22103, 17896, 4, 30, },
	{ 930, 13947, 11226, 4, 31, },
	{ 930, 30190, 23728, 4, 31, },
	{ 931, 13948, 38851, 4, 31, },
	{ 931, 22106, 17899, 4, 31, },
	{ 943, 13529, 38796, 2, 1378, },
	{ 943, 13693, 38821, 2, 189939, },
	{ 963, 13937, 38845, 2, 1378, },
	{ 963, 27967, 22552, 2, 189939, },
	{ 963, 35798, 29844, 2, 42483, },
	{ 983, 44500, 38959, 4, 30, },
	{ 983, 44589, 38976, 4, 30, },
	{ 1023, 14847, nil, 2, 173555, },
	{ 1071, 34009, 28282, 4, 64, },
	{ 1071, 35803, 29849, 4, 64, },
	{ 1075, 44528, 38966, 4, 30, },
	{ 1099, 60663, 44457, 4, 30, },
	{ 1103, 44633, 38995, 2, 177651, },
	{ 1119, 44555, 38968, 4, 30, },
	{ 1119, 47715, nil, 4, 30, },
	{ 1128, 60653, 44455, 4, 64, },
	{ 1144, 33990, 35431, 4, 31, },
	{ 1144, 35823, 29871, 4, 31, },
	{ 1147, 44508, 38961, 4, 30, },
	{ 1147, 44593, 38980, 4, 30, },
	{ 1257, 34005, 28276, 4, 30, },
	{ 1257, 35812, 29859, 4, 31, },
	{ 1262, 44596, 38982, 4, 30, },
	{ 1341, 19932, 16104, 4, 30, },
	{ 1354, 44556, 38969, 4, 30, },
	{ 1400, 44494, 38956, 4, 30, },
	{ 1436, 6476, 22588, 4, 31, },
	{ 1441, 34006, 28277, 4, 30, },
	{ 1441, 35811, 29858, 4, 31, },
	{ 1446, 44590, 38977, 4, 30, },
	{ 1483, 15340, 11622, 4, 31, },
	{ 1503, 15389, 11642, 4, 31, },
	{ 1504, 15391, 11643, 4, 31, },
	{ 1505, 15394, 11644, 4, 31, },
	{ 1506, 15397, 11645, 4, 31, },
	{ 1507, 15400, 11646, 4, 31, },
	{ 1508, 15402, 11647, 4, 31, },
	{ 1509, 15404, 11648, 4, 31, },
	{ 1510, 15406, 11649, 4, 31, },
	{ 1523, 15427, 11663, 4, 30, },
	{ 1524, 15429, 11664, 4, 30, },
	{ 1525, 15439, 11666, 4, 30, },
	{ 1526, 15441, 11667, 4, 30, },
	{ 1527, 15444, 11670, 4, 30, },
	{ 1528, 15446, 11671, 4, 30, },
	{ 1529, 15449, 11673, 4, 30, },
	{ 1530, 15458, 11672, 4, 30, },
	{ 1532, 15463, 11676, 4, 30, },
	{ 1543, 15490, 11683, 4, 30, },
	{ 1593, 34002, 38938, 4, 30, },
	{ 1593, 39404, 31843, 4, 30, },
	{ 1593, 359639, 187737, 4, 30, },
	{ 1594, 33996, 35438, 4, 31, },
	{ 1594, 35820, 29868, 4, 31, },
	{ 1597, 60763, 44469, 4, 30, },
	{ 1600, 60616, 38971, 4, 30, },
	{ 1603, 60668, 44458, 4, 30, },
	{ 1606, 60621, 44453, 2, 189939, },
	{ 1704, 16623, 12645, 4, 96, },
	{ 1843, 19057, 15564, 4, 30, },
	{ 1883, 20008, 16214, 4, 30, },
	{ 1883, 22054, 17830, 4, 30, },
	{ 1884, 20009, 16218, 4, 30, },
	{ 1884, 22053, 17829, 4, 30, },
	{ 1885, 20010, 16246, 4, 30, },
	{ 1885, 22051, 17827, 4, 30, },
	{ 1886, 20011, 16251, 4, 30, },
	{ 1886, 22052, 17828, 4, 30, },
	{ 1887, 20012, 16219, 4, 31, },
	{ 1887, 20023, 16245, 4, 30, },
	{ 1887, 22101, 17894, 4, 30, },
	{ 1887, 22105, 17898, 4, 31, },
	{ 1888, 20014, 16216, 4, 30, },
	{ 1888, 22091, 17884, 4, 30, },
	{ 1888, 27947, 22541, 4, 64, },
	{ 1888, 35802, 29848, 4, 64, },
	{ 1889, 20015, 16224, 4, 30, },
	{ 1889, 22092, 17885, 4, 30, },
	{ 1890, 20016, 16222, 4, 64, },
	{ 1890, 22100, 17893, 4, 64, },
	{ 1891, 20025, 16253, 4, 31, },
	{ 1891, 27107, 22028, 4, 31, },
	{ 1891, 27905, 35426, 4, 30, },
	{ 1891, 39410, 31848, 4, 30, },
	{ 1892, 20026, 16221, 4, 31, },
	{ 1892, 22089, 17882, 4, 31, },
	{ 1893, 20028, 16242, 4, 31, },
	{ 1893, 22090, 17883, 4, 31, },
	{ 1894, 20029, 16223, 2, 189939, },
	{ 1894, 23142, 18667, 2, 173555, },
	{ 1896, 20030, 16247, 2, 1378, },
	{ 1896, 22094, 17887, 2, 136546, },
	{ 1897, 13695, 38822, 2, 1378, },
	{ 1897, 20031, 16250, 2, 189939, },
	{ 1897, 22095, 17888, 2, 173555, },
	{ 1898, 20032, 16254, 2, 189939, },
	{ 1898, 27104, 22025, 2, 189939, },
	{ 1899, 20033, 16248, 2, 189939, },
	{ 1899, 27102, 22024, 2, 189939, },
	{ 1900, 20034, 16252, 2, 189939, },
	{ 1900, 23141, 18666, 2, 173555, },
	{ 1903, 20035, 16255, 2, 1378, },
	{ 1904, 20036, 16249, 2, 1378, },
	{ 1951, 44591, 38978, 4, 30, },
	{ 1951, 46594, 35500, 4, 31, },
	{ 1952, 44489, 38954, 4, 64, },
	{ 1953, 47766, 39002, 4, 31, },
	{ 2322, 33999, 28273, 4, 31, },
	{ 2322, 35815, 29862, 4, 31, },
	{ 2326, 44635, 38997, 4, 30, },
	{ 2332, 60767, 44470, 4, 30, },
	{ 2343, 35791, 29837, 2, 42483, },
	{ 2376, 35822, 29870, 4, 31, },
	{ 2381, 44509, 38962, 4, 30, },
	{ 2443, 21931, 17725, 2, 196083, },
	{ 2463, 13657, 38815, 4, 30, },
	{ 2483, 22593, 18169, 4, 30, },
	{ 2484, 22594, 18170, 4, 30, },
	{ 2485, 22598, 18171, 4, 30, },
	{ 2486, 22597, 18172, 4, 30, },
	{ 2487, 22596, 18173, 4, 30, },
	{ 2488, 22599, 18182, 4, 30, },
	{ 2503, 22725, 18251, 4, 30, },
	{ 2504, 22749, 18259, 2, 58867, },
	{ 2504, 23143, 18668, 2, 42483, },
	{ 2505, 22750, 18260, 2, 58867, },
	{ 2505, 23144, 18669, 2, 42483, },
	{ 2523, 22779, 18283, 2, 262156, },
	{ 2523, 30255, nil, 2, 262156, },
	{ 2543, 22840, 18329, 4, 31, },
	{ 2544, 22844, 18330, 4, 31, },
	{ 2545, 22846, 18331, 4, 31, },
	{ 2563, 23799, 19444, 2, 58867, },
	{ 2563, 27093, 22022, 2, 175603, },
	{ 2564, 23800, 19445, 2, 58867, },
	{ 2564, 25080, 33152, 4, 31, },
	{ 2564, 26792, 22020, 2, 175603, },
	{ 2564, 27112, 22033, 4, 31, },
	{ 2564, 359641, 187739, 4, 30, },
	{ 2565, 23801, 19446, 4, 30, },
	{ 2565, 27115, 22036, 4, 30, },
	{ 2566, 27116, 22037, 4, 30, },
	{ 2567, 23803, 19448, 2, 58867, },
	{ 2567, 26743, 22023, 2, 175603, },
	{ 2567, 359642, 187740, 2, 58867, },
	{ 2568, 23804, 19449, 2, 58867, },
	{ 2568, 26793, 22021, 2, 175603, },
	{ 2583, 24149, 19782, 4, 31, },
	{ 2584, 24160, 19783, 4, 31, },
	{ 2587, 24163, 19786, 4, 31, },
	{ 2588, 24164, 19787, 4, 31, },
	{ 2589, 24165, 19788, 4, 31, },
	{ 2590, 24167, 19789, 4, 31, },
	{ 2591, 24168, 19790, 4, 31, },
	{ 2603, 13620, 11152, 4, 31, },
	{ 2604, 24420, 20078, 4, 30, },
	{ 2605, 24421, 20076, 4, 30, },
	{ 2606, 24422, 20077, 4, 30, },
	{ 2613, 25072, 33153, 4, 31, },
	{ 2613, 27113, 22034, 4, 31, },
	{ 2613, 359858, 187801, 4, 31, },
	{ 2614, 25073, 20727, 4, 31, },
	{ 2614, 27110, 22031, 4, 31, },
	{ 2615, 25074, 20728, 4, 31, },
	{ 2615, 27108, 22029, 4, 31, },
	{ 2616, 25078, 20729, 4, 31, },
	{ 2616, 27109, 22030, 4, 31, },
	{ 2617, 25079, 20730, 4, 31, },
	{ 2617, 27111, 22032, 4, 31, },
	{ 2617, 39405, 31844, 4, 30, },
	{ 2619, 25081, 20732, 4, 31, },
	{ 2619, 27118, 22039, 4, 31, },
	{ 2619, 359950, 187815, 4, 30, },
	{ 2620, 25082, 20733, 4, 31, },
	{ 2620, 27119, 22040, 4, 31, },
	{ 2620, 359949, 187807, 4, 30, },
	{ 2621, 25084, 33150, 4, 31, },
	{ 2621, 27121, 22042, 4, 31, },
	{ 2621, 359847, 187800, 4, 30, },
	{ 2622, 25086, 33148, 4, 31, },
	{ 2622, 27122, 22043, 4, 31, },
	{ 2646, 27837, 22392, 2, 1378, },
	{ 2646, 30229, 18599, 2, 136546, },
	{ 2647, 27899, 35420, 4, 30, },
	{ 2647, 39411, 31849, 4, 30, },
	{ 2648, 27906, 22530, 4, 30, },
	{ 2648, 39407, 31846, 4, 30, },
	{ 2648, 47051, 35756, 4, 31, },
	{ 2649, 27914, 22533, 4, 30, },
	{ 2649, 27950, 22543, 4, 30, },
	{ 2649, 35810, 29857, 4, 30, },
	{ 2649, 39408, 31847, 4, 30, },
	{ 2650, 23802, 19447, 4, 30, },
	{ 2650, 27911, 22531, 4, 30, },
	{ 2650, 27917, 22534, 4, 30, },
	{ 2650, 39406, 31845, 4, 30, },
	{ 2653, 27944, 38904, 4, 64, },
	{ 2654, 27945, 22539, 4, 64, },
	{ 2654, 35804, 29850, 4, 64, },
	{ 2655, 27946, 22540, 4, 64, },
	{ 2655, 35805, 29851, 4, 64, },
	{ 2656, 27948, 22542, 4, 30, },
	{ 2656, 36286, 30199, 4, 30, },
	{ 2657, 27951, 22544, 4, 30, },
	{ 2657, 35809, 29856, 4, 30, },
	{ 2658, 27954, 22545, 4, 30, },
	{ 2658, 35808, 29854, 4, 30, },
	{ 2659, 27957, 35428, 4, 31, },
	{ 2659, 35826, 29874, 4, 31, },
	{ 2660, 35825, 29873, 4, 31, },
	{ 2661, 27960, 24003, 4, 31, },
	{ 2661, 35824, 29872, 4, 31, },
	{ 2661, 44616, 38987, 4, 30, },
	{ 2662, 27961, 35437, 4, 30, },
	{ 2662, 45028, nil, 4, 30, },
	{ 2664, 27962, 22548, 4, 30, },
	{ 2664, 36285, 30198, 4, 30, },
	{ 2666, 27968, 22551, 2, 58867, },
	{ 2666, 35797, 29843, 2, 42483, },
	{ 2667, 27971, 22554, 2, 132450, },
	{ 2667, 35801, 29847, 2, 136546, },
	{ 2668, 27972, 22553, 2, 189939, },
	{ 2668, 35799, 29845, 2, 42483, },
	{ 2669, 27975, 22555, 2, 173555, },
	{ 2669, 35796, 29842, 2, 42483, },
	{ 2670, 27977, 22556, 2, 132450, },
	{ 2670, 35800, 29846, 2, 136546, },
	{ 2671, 27981, 22560, 2, 189939, },
	{ 2671, 35795, 29841, 2, 42483, },
	{ 2672, 27982, 22561, 2, 189939, },
	{ 2672, 35794, 29840, 2, 42483, },
	{ 2673, 27984, 22559, 2, 189939, },
	{ 2673, 35793, 29839, 2, 42483, },
	{ 2674, 28003, 22558, 2, 189939, },
	{ 2674, 42012, 32952, 2, 42483, },
	{ 2675, 28004, 22557, 2, 189939, },
	{ 2675, 35792, 29838, 2, 42483, },
	{ 2679, 27913, 22532, 4, 30, },
	{ 2679, 39409, 30877, 4, 30, },
	{ 2681, 28161, 22635, 4, 31, },
	{ 2682, 28163, 22636, 4, 31, },
	{ 2683, 28165, 22638, 4, 31, },
	{ 2714, 29454, 23530, 4, 96, },
	{ 2715, 29475, 23547, 4, 30, },
	{ 2716, 29480, 23549, 4, 30, },
	{ 2717, 29483, 23548, 4, 30, },
	{ 2721, 29467, 23545, 4, 30, },
	{ 2722, 30250, 23764, 2, 262156, },
	{ 2723, 30252, 23765, 2, 262156, },
	{ 2724, 30258, nil, 2, 262156, },
	{ 2724, 30260, 23766, 2, 262156, },
	{ 2745, 31369, 24275, 4, 31, },
	{ 2746, 31370, 24276, 4, 31, },
	{ 2747, 31371, 24273, 4, 31, },
	{ 2748, 31372, 24274, 4, 31, },
	{ 2792, 32397, 25650, 4, 30, },
	{ 2793, 32398, 25651, 4, 30, },
	{ 2794, 32399, 25652, 4, 30, },
	{ 2841, 44968, 34330, 4, 30, },
	{ 2928, 27924, 22536, 4, nil, },
	{ 2928, 36282, 30193, 4, nil, },
	{ 2929, 27920, 22535, 4, nil, },
	{ 2929, 36281, 30191, 4, nil, },
	{ 2930, 27926, 22537, 4, nil, },
	{ 2930, 36283, 30195, 4, nil, },
	{ 2931, 27927, 22538, 4, nil, },
	{ 2931, 36284, 30197, 4, nil, },
	{ 2933, 33992, 28270, 4, 31, },
	{ 2933, 35821, 29869, 4, 31, },
	{ 2934, 33993, 35439, 4, 31, },
	{ 2934, 35818, 29866, 4, 31, },
	{ 2935, 33994, 28271, 4, 31, },
	{ 2935, 35817, 29864, 4, 31, },
	{ 2937, 33997, 28272, 4, 31, },
	{ 2937, 35816, 29863, 4, 31, },
	{ 2938, 34003, 28274, 4, 30, },
	{ 2938, 35814, 29861, 4, 31, },
	{ 2939, 34007, 28279, 4, 30, },
	{ 2939, 35807, 29853, 4, 30, },
	{ 2940, 34008, 28280, 4, 30, },
	{ 2940, 35806, 29852, 4, 30, },
	{ 2977, 35355, 28882, 4, 31, },
	{ 2978, 35402, 28889, 4, 31, },
	{ 2979, 35403, 28878, 4, 31, },
	{ 2980, 35404, 28887, 4, 31, },
	{ 2981, 35405, 28881, 4, 31, },
	{ 2982, 35406, 28886, 4, 31, },
	{ 2983, 35407, 28885, 4, 31, },
	{ 2984, 35415, 29483, 4, 30, },
	{ 2985, 35416, 29485, 4, 30, },
	{ 2986, 35417, 28888, 4, 31, },
	{ 2987, 35418, 29486, 4, 30, },
	{ 2988, 35419, 29487, 4, 30, },
	{ 2989, 35420, 29488, 4, 30, },
	{ 2990, 35432, 28908, 4, 31, },
	{ 2991, 35433, 28911, 4, 31, },
	{ 2992, 35434, 28904, 4, 31, },
	{ 2993, 35435, 28912, 4, 31, },
	{ 2994, 35436, 28903, 4, 31, },
	{ 2995, 35437, 28909, 4, 31, },
	{ 2996, 35438, 28907, 4, 31, },
	{ 2997, 35439, 28910, 4, 31, },
	{ 2998, 35441, 29187, 4, 30, },
	{ 2999, 35443, 29186, 4, 31, },
	{ 3001, 35445, 29189, 4, 31, },
	{ 3002, 35447, 29191, 4, 31, },
	{ 3003, 35452, 29192, 4, 31, },
	{ 3004, 35453, 29193, 4, 31, },
	{ 3005, 35454, 29194, 4, 31, },
	{ 3006, 35455, 29195, 4, 31, },
	{ 3007, 35456, 29196, 4, 31, },
	{ 3008, 35457, 29198, 4, 31, },
	{ 3009, 35458, 29199, 4, 31, },
	{ 3010, 35488, 29533, 4, 31, },
	{ 3011, 35489, 29534, 4, 31, },
	{ 3012, 35490, 29535, 4, 31, },
	{ 3013, 35495, 29536, 4, 31, },
	{ 3095, 37889, 30845, 4, 31, },
	{ 3096, 37891, 30846, 4, 31, },
	{ 3150, 33991, 38929, 4, 31, },
	{ 3222, 42620, 33165, 2, 189939, },
	{ 3222, 44529, 38967, 4, 30, },
	{ 3223, 42687, 33185, 2, 173555, },
	{ 3225, 42974, 33307, 2, 189939, },
	{ 3225, 43005, 33315, 2, 42483, },
	{ 3228, 44119, nil, 4, 30, },
	{ 3229, 44383, 38949, 4, 64, },
	{ 3229, 359685, 187783, 4, 64, },
	{ 3230, 44483, 38950, 4, 30, },
	{ 3231, 44484, 38951, 4, 30, },
	{ 3231, 44598, 38984, 4, 30, },
	{ 3232, 47901, 39006, 4, 30, },
	{ 3233, 27958, 22546, 4, 31, },
	{ 3234, 44488, 38953, 4, 31, },
	{ 3236, 44492, 38955, 4, 30, },
	{ 3238, 44506, 38960, 4, 30, },
	{ 3239, 44524, 38965, 2, 177651, },
	{ 3241, 44576, 38972, 2, 173555, },
	{ 3243, 44582, 38973, 4, 30, },
	{ 3244, 44584, 38974, 4, 30, },
	{ 3245, 44588, 38975, 4, 30, },
	{ 3246, 44592, 38979, 4, 30, },
	{ 3247, 44595, 38981, 2, 132450, },
	{ 3249, 44612, 38985, 4, 30, },
	{ 3251, 44621, 38988, 2, 173555, },
	{ 3252, 44623, 38989, 4, 30, },
	{ 3253, 44625, 38990, 4, 31, },
	{ 3256, 44631, 38993, 4, 30, },
	{ 3260, 44769, 34207, 4, 30, },
	{ 3269, 45697, 34836, 2, 1048576, },
	{ 3273, 46578, 35498, 2, 189939, },
	{ 3288, 47101, nil, nil, nil, },
	{ 3289, 47103, 37311, 15, 32, },
	{ 3289, 48555, nil, 15, 32, },
	{ 3289, 48557, nil, 15, 32, },
	{ 3290, 47147, nil, nil, nil, },
	{ 3290, 52639, 39300, 4, nil, },
	{ 3291, 47242, nil, nil, nil, },
	{ 3294, 47672, 39001, 4, 30, },
	{ 3296, 47899, 39004, 4, 30, },
	{ 3297, 47900, 39005, 4, 30, },
	{ 3297, 48036, nil, 4, 30, },
	{ 3315, 48401, 37312, 15, 32, },
	{ 3315, 48556, nil, 15, 32, },
	{ 3319, 50465, nil, 2, 41105, },
	{ 3320, 50358, nil, nil, nil, },
	{ 3325, 50901, 38371, 4, 31, },
	{ 3326, 50902, 38372, 4, 31, },
	{ 3327, 50903, nil, 4, 31, },
	{ 3327, 60583, nil, 4, 30, },
	{ 3328, 50904, nil, 4, 31, },
	{ 3328, 60584, nil, 4, 30, },
	{ 3329, 50906, 38375, 4, 30, },
	{ 3330, 50909, 38376, 4, 30, },
	{ 3332, 50913, 38378, 4, 31, },
	{ 3365, 53323, nil, 2, 1378, },
	{ 3366, 53331, nil, 2, 189939, },
	{ 3367, 53342, nil, 2, 1378, },
	{ 3368, 53344, nil, 2, 189939, },
	{ 3369, 53341, nil, 2, 189939, },
	{ 3370, 53343, nil, 2, 189939, },
	{ 3594, 54446, nil, 2, 32913, },
	{ 3595, 54447, nil, 2, 32913, },
	{ 3599, 54736, 40776, 4, 30, },
	{ 3601, 54793, 40800, 4, 30, },
	{ 3603, 54998, 41091, 4, 30, },
	{ 3604, 54999, nil, 4, 30, },
	{ 3605, 55002, 41111, 4, 30, },
	{ 3607, 55076, 41146, 2, 262156, },
	{ 3608, 55135, 41167, 2, 262156, },
	{ 3718, 55630, 41601, 4, 31, },
	{ 3719, 55631, 41602, 4, 31, },
	{ 3720, 55632, 41603, 4, 31, },
	{ 3721, 55634, 41604, 4, 31, },
	{ 3722, 55642, nil, 4, 30, },
	{ 3728, 55769, nil, 4, 30, },
	{ 3730, 55777, nil, 4, 30, },
	{ 3731, 55836, 41976, 2, 173555, },
	{ 3748, 56353, 42500, 4, 96, },
	{ 3754, 24162, 19785, 4, 31, },
	{ 3755, 24161, 19784, 4, 31, },
	{ 3756, 57683, 43097, 4, 30, },
	{ 3757, 57690, nil, 4, 30, },
	{ 3758, 57691, nil, 4, 30, },
	{ 3759, 57692, 44559, 4, 30, },
	{ 3760, 57694, 44560, 4, 30, },
	{ 3761, 57696, 44561, 4, 30, },
	{ 3762, 57699, 44562, 4, 30, },
	{ 3763, 57701, 44563, 4, 30, },
	{ 3775, 58126, 43302, 4, 31, },
	{ 3776, 58128, 43303, 4, 31, },
	{ 3777, 58129, 43304, 4, 31, },
	{ 3788, 59619, 44497, 2, 177651, },
	{ 3789, 59621, 44493, 2, 173555, },
	{ 3790, 59625, 43987, 2, 173555, },
	{ 3791, 59636, nil, 4, nil, },
	{ 3793, 59771, 44125, 4, 31, },
	{ 3794, 59773, 44068, 4, 31, },
	{ 3795, 59777, 44124, 4, 31, },
	{ 3796, 59778, nil, 4, 31, },
	{ 3797, 59784, 44075, 4, 31, },
	{ 3806, 59927, 44129, 4, 31, },
	{ 3807, 59928, 44130, 4, 31, },
	{ 3808, 59934, 44133, 4, 31, },
	{ 3809, 59936, 44134, 4, 31, },
	{ 3810, 59937, 44135, 4, 31, },
	{ 3811, 59941, 44136, 4, 31, },
	{ 3812, 59944, 44137, 4, 31, },
	{ 3813, 59945, 44138, 4, 31, },
	{ 3814, 59946, 44139, 4, 31, },
	{ 3815, 59947, 44140, 4, 31, },
	{ 3816, 59948, 44141, 4, 31, },
	{ 3817, 59954, 44149, 4, 31, },
	{ 3818, 59955, 44150, 4, 31, },
	{ 3819, 59960, 44152, 4, 31, },
	{ 3820, 59970, 44159, 4, 31, },
	{ 3822, 60581, 38373, 4, 31, },
	{ 3823, 60582, 38374, 4, 31, },
	{ 3824, 60606, 44449, 4, 30, },
	{ 3825, 60609, 44456, 4, 30, },
	{ 3826, 60623, 38986, 4, 30, },
	{ 3827, 60691, 44463, 2, 136546, },
	{ 3828, 44630, 38992, 2, 132450, },
	{ 3829, 44513, 38964, 4, 30, },
	{ 3830, 44629, 38991, 2, 177651, },
	{ 3831, 47898, 39003, 4, 30, },
	{ 3832, 60692, 44465, 4, 30, },
	{ 3832, 68274, 49130, 4, 30, },
	{ 3833, 60707, 44466, 2, 189939, },
	{ 3834, 60714, 44467, 2, 177651, },
	{ 3835, 61117, nil, 4, 31, },
	{ 3836, 61118, nil, 4, 31, },
	{ 3837, 61119, nil, 4, 31, },
	{ 3838, 61120, nil, 4, 31, },
	{ 3839, 44645, nil, 4, nil, },
	{ 3840, 44636, nil, 4, nil, },
	{ 3842, 61271, 44701, 4, 31, },
	{ 3843, 61468, 44739, 2, 262156, },
	{ 3844, 44510, 38963, 2, 177651, },
	{ 3845, 44575, 44815, 4, 30, },
	{ 3846, 34010, 28281, 2, 189939, },
	{ 3847, 62158, nil, 2, 1378, },
	{ 3849, 62201, 44936, 4, 64, },
	{ 3850, 62256, 44947, 4, 30, },
	{ 3851, 62257, 44945, 2, 189939, },
	{ 3852, 62384, 44957, 4, 31, },
	{ 3853, 62447, 44963, 4, 31, },
	{ 3854, 62948, 45056, 2, 1024, },
	{ 3855, 62959, 45060, 2, 1024, },
	{ 3858, 63746, 45628, 4, 30, },
	{ 3859, 63765, nil, 4, 30, },
	{ 3860, 63770, nil, 4, 30, },
	{ 3869, 64441, 46026, 2, 189939, },
	{ 3870, 64579, 46098, 2, 189939, },
	{ 3872, 56039, nil, 4, 31, },
	{ 3873, 56034, nil, 4, 31, },
	{ 3875, 59929, 44131, 4, 31, },
	{ 3876, 59932, 44132, 4, 31, },
	{ 3883, 70164, nil, 2, 32913, },
	{ 4061, 74132, 52687, 4, 30, },
	{ 4062, 74189, 52743, 4, 30, },
	{ 4063, 74191, 52744, 4, 30, },
	{ 4064, 74192, 52745, 4, 30, },
	{ 4065, 74193, 52746, 4, 30, },
	{ 4066, 74195, 52747, 2, 189939, },
	{ 4067, 74197, 52748, 2, 189939, },
	{ 4068, 74198, 52749, 4, 30, },
	{ 4069, 74199, 52750, 4, 30, },
	{ 4070, 74200, 52751, 4, 30, },
	{ 4071, 74201, 52752, 4, 30, },
	{ 4072, 74202, 52753, 4, 30, },
	{ 4073, 74207, 52754, 4, 64, },
	{ 4074, 74211, 52755, 2, 189939, },
	{ 4075, 74212, 52756, 4, 30, },
	{ 4076, 74213, 52757, 4, 30, },
	{ 4077, 74214, 52758, 4, 30, },
	{ 4078, 74215, nil, 4, nil, },
	{ 4079, 74216, nil, 4, nil, },
	{ 4080, 74217, nil, 4, nil, },
	{ 4081, 74218, nil, 4, nil, },
	{ 4082, 74220, 52759, 4, 30, },
	{ 4083, 74223, 52760, 2, 189939, },
	{ 4084, 74225, 52761, 2, 189939, },
	{ 4085, 74226, 52762, 4, 64, },
	{ 4086, 74229, 52763, 4, 30, },
	{ 4087, 74230, 52764, 4, 30, },
	{ 4088, 74231, 52765, 4, 30, },
	{ 4089, 74232, 52766, 4, 30, },
	{ 4090, 74234, 52767, 4, 30, },
	{ 4091, 74235, 52768, 4, 65, },
	{ 4092, 74236, 52769, 4, 30, },
	{ 4093, 74237, 52770, 4, 30, },
	{ 4094, 74238, 52771, 4, 30, },
	{ 4095, 74239, 52772, 4, 30, },
	{ 4096, 74240, 52773, 4, 30, },
	{ 4097, 74242, 52733, 2, 189939, },
	{ 4098, 74244, 52735, 2, 189939, },
	{ 4099, 74246, 52736, 2, 189939, },
	{ 4100, 74247, 52737, 4, 30, },
	{ 4101, 74248, 52738, 4, 30, },
	{ 4102, 74250, 52739, 4, 30, },
	{ 4103, 74251, 52740, 4, 30, },
	{ 4104, 74253, 52782, 4, 30, },
	{ 4105, 74252, 52781, 4, 30, },
	{ 4106, 74254, 52783, 4, 30, },
	{ 4107, 74255, 52784, 4, 30, },
	{ 4108, 74256, 52785, 4, 30, },
	{ 4109, 75149, 54449, 4, 31, },
	{ 4110, 75150, 54450, 4, 31, },
	{ 4111, 75151, 54447, 4, 31, },
	{ 4112, 75152, 54448, 4, 31, },
	{ 4113, 75154, nil, 4, 31, },
	{ 4114, 75155, nil, 4, 31, },
	{ 4115, 75172, nil, 4, 30, },
	{ 4116, 75175, nil, 4, 30, },
	{ 4118, 75178, nil, 4, 30, },
	{ 4120, 78165, 56477, 4, 30, },
	{ 4121, 78166, 56517, 4, 30, },
	{ 4122, 78169, 56502, 4, 31, },
	{ 4124, 78170, 56503, 4, 31, },
	{ 4126, 78171, 56550, 4, 31, },
	{ 4127, 78172, 56551, 4, 31, },
	{ 4175, 81932, 59594, 2, 262156, },
	{ 4176, 81933, 59595, 2, 262156, },
	{ 4177, 81934, 59596, 2, 262156, },
	{ 4179, 82175, nil, 4, 30, },
	{ 4180, 82177, nil, 4, 30, },
	{ 4181, 82180, nil, 4, 30, },
	{ 4182, 82200, nil, 4, 30, },
	{ 4183, 82201, nil, 4, 30, },
	{ 4187, 84424, nil, 4, 30, },
	{ 4188, 84427, nil, 4, 30, },
	{ 4189, 85007, nil, 4, 30, },
	{ 4190, 85008, nil, 4, 30, },
	{ 4191, 85009, nil, 4, 30, },
	{ 4192, 85010, nil, 4, 30, },
	{ 4193, 86375, nil, 4, 31, },
	{ 4194, 86401, nil, 4, 31, },
	{ 4195, 86402, nil, 4, 31, },
	{ 4196, 86403, nil, 4, 31, },
	{ 4197, 86847, 62321, 4, 31, },
	{ 4198, 86854, 62333, 4, 31, },
	{ 4199, 86898, 62342, 4, 31, },
	{ 4200, 86899, 62343, 4, 31, },
	{ 4201, 86900, 62344, 4, 31, },
	{ 4202, 86901, 62345, 4, 31, },
	{ 4203, 86906, nil, 4, 31, },
	{ 4204, 86907, 62346, 4, 31, },
	{ 4205, 86909, 62347, 4, 31, },
	{ 4206, 86931, 62366, 4, 31, },
	{ 4207, 86932, 62367, 4, 31, },
	{ 4208, 86933, 62368, 4, 31, },
	{ 4209, 86934, 62369, 4, 31, },
	{ 4214, 84425, nil, 4, 30, },
	{ 4215, 92433, 55055, 4, 96, },
	{ 4216, 92437, 55056, 4, 96, },
	{ 4217, 93448, 55057, 2, 173555, },
	{ 4221, 94953, 68009, 4, 30, },
	{ 4222, 67839, nil, 4, 30, },
	{ 4223, 55016, 41118, 4, 30, },
	{ 4227, 95471, 68134, 2, 1378, },
	{ 4245, 96245, 68770, 4, 31, },
	{ 4246, 96246, 68769, 4, 31, },
	{ 4247, 96247, 68768, 4, 31, },
	{ 4248, 96249, 68772, 4, 31, },
	{ 4249, 96250, 68773, 4, 31, },
	{ 4250, 96251, 68774, 4, 31, },
	{ 4256, 96261, 68785, 4, 30, },
	{ 4257, 96262, 68786, 4, 30, },
	{ 4258, 96264, 68784, 4, 30, },
	{ 4259, 96286, 68796, 2, 1048576, },
	{ 4267, 99623, 70139, 2, 262156, },
	{ 4270, 101598, 71720, 4, 31, },
	{ 4438, 101600, nil, 4, 30, },
	{ 4439, 85068, nil, 4, 30, },
	{ 4440, 85067, nil, 4, 30, },
};
--	[classID][enchantID] = { subClassMask, invTypeMask, spellID, itemID, }
local EnchantDB = {  };
for _, info in next, RawEnchantDB do
	local classID = info[4];
	if classID then
		local TO = EnchantDB[classID];
		if TO == nil then
			TO = {  };
			EnchantDB[classID] = TO;
		end
		local enchantID = info[1];
		local to = TO[enchantID];
		if to == nil then
			to = {  };
			TO[enchantID] = to;
		end
		to[#to + 1] = { info[5], info[6], info[2], info[3], };
	end
end
DT.EnchantDB = EnchantDB;
DT.EnchantableByLoc = {
	INVTYPE_HEAD = 1,
	INVTYPE_SHOULDER = 1,
	INVTYPE_CHEST = 1,
	INVTYPE_LEGS = 1,
	INVTYPE_FEET = 1,
	INVTYPE_WRIST = 1,
	INVTYPE_HAND = 1,
	INVTYPE_CLOAK = 1,
	INVTYPE_WEAPON = 1,
	INVTYPE_2HWEAPON = 1,
	INVTYPE_SHIELD = 1,
	INVTYPE_RANGED = 1,
	INVTYPE_ROBE = 1,
	INVTYPE_WEAPONMAINHAND = 1,
	INVTYPE_WEAPONOFFHAND = 1,
	INVTYPE_RANGEDRIGHT = 1,
};
local EnumItemClass = Enum and Enum.ItemClass or {
	Weapon = 2,
};
local EnumWSubClass = Enum and Enum.ItemWeaponSubclass or {
	Axe1H = 0,
	Axe2H = 1,
	Bows = 2,
	Guns = 3,
	Mace1H = 4,
	Mace2H = 5,
	Polearm = 6,
	Sword1H = 7,
	Sword2H = 8,
	Warglaive = 9,
	Staff = 10,
	Bearclaw = 11,
	Catclaw = 12,
	Unarmed = 13,
	Generic = 14,
	Dagger = 15,
	Thrown = 16,
	Obsolete3 = 17,
	Crossbow = 18,
	Wand = 19,
	Fishingpole = 20,
};
DT.UnenchantableByType = {
	[EnumItemClass.Weapon] = {
		[EnumWSubClass.Generic] = 1,
		[EnumWSubClass.Thrown] = 1,
		[EnumWSubClass.Wand] = 1,
		[EnumWSubClass.Fishingpole] = 1,
		[EnumWSubClass.Bows] = 'HUNTER',
		[EnumWSubClass.Guns] = 'HUNTER',
		[EnumWSubClass.Crossbow] = 'HUNTER',
	},
};

DT.ItemSet = {
	[1] = { 11729, 11726, 11728, 11731, 11730, },
	[41] = { 12940, 12939, },
	[65] = { 13218, 13183, },
	[81] = { 13390, 13388, 13391, 13392, 13389, },
	[121] = { 14637, 14636, 14640, 14638, 14641, },
	[122] = { 14631, 14629, 14632, 14633, 14626, },
	[123] = { 14614, 14616, 14615, 14611, 14612, },
	[124] = { 14624, 14622, 14620, 14623, 14621, },
	[141] = { 15053, 15054, 15055, },
	[142] = { 15056, 15057, 15058, 21278, },
	[143] = { 15062, 15063, },
	[144] = { 15066, 15067, },
	[161] = { 10399, 10403, 10402, 10401, 10400, },
	[162] = { 10412, 10411, 10413, 10410, 6473, },
	[163] = { 10329, 10332, 10328, 10331, 10330, 10333, },
	[181] = { 16685, 16683, 16686, 16684, 16687, 16689, 16688, 16682, },
	[182] = { 16696, 16691, 16697, 16693, 16692, 16695, 16694, 16690, },
	[183] = { 16702, 16703, 16699, 16701, 16700, 16704, 16698, 16705, },
	[184] = { 16713, 16711, 16710, 16721, 16708, 16709, 16712, 16707, },
	[185] = { 16716, 16715, 16714, 16720, 16706, 16718, 16719, 16717, },
	[186] = { 16680, 16675, 16681, 16677, 16674, 16678, 16679, 16676, },
	[187] = { 16673, 16670, 16671, 16667, 16672, 16668, 16669, 16666, },
	[188] = { 16723, 16725, 16722, 16726, 16724, 16728, 16729, 16727, },
	[189] = { 16736, 16734, 16735, 16730, 16737, 16731, 16732, 16733, },
	[201] = { 16802, 16799, 16795, 16800, 16801, 16796, 16797, 16798, },
	[202] = { 16811, 16813, 16817, 16812, 16814, 16816, 16815, 16819, },
	[203] = { 16806, 16804, 16805, 16810, 16809, 16807, 16808, 16803, },
	[204] = { 16827, 16824, 16825, 16820, 16821, 16826, 16822, 16823, },
	[205] = { 16828, 16829, 16830, 16833, 16831, 16834, 16835, 16836, },
	[206] = { 16851, 16849, 16850, 16845, 16848, 16852, 16846, 16847, },
	[207] = { 16838, 16837, 16840, 16841, 16844, 16839, 16842, 16843, },
	[208] = { 16858, 16859, 16857, 16853, 16860, 16854, 16855, 16856, },
	[209] = { 16864, 16861, 16865, 16863, 16866, 16867, 16868, 16862, },
	[210] = { 16818, 16918, 16912, 16914, 16917, 16913, 16915, 16916, },
	[211] = { 16925, 16926, 16919, 16921, 16920, 16922, 16924, 16923, },
	[212] = { 16933, 16927, 16934, 16928, 16930, 16931, 16929, 16932, },
	[213] = { 16910, 16906, 16911, 16905, 16907, 16908, 16909, 16832, },
	[214] = { 16903, 16898, 16904, 16897, 16900, 16899, 16901, 16902, },
	[215] = { 16936, 16935, 16942, 16940, 16941, 16939, 16938, 16937, },
	[216] = { 16944, 16943, 16950, 16945, 16948, 16949, 16947, 16946, },
	[217] = { 16952, 16951, 16958, 16955, 16956, 16954, 16957, 16953, },
	[218] = { 16959, 16966, 16964, 16963, 16962, 16961, 16965, 16960, },
	[221] = { 7950, 7948, 7952, 7951, 7953, 7949, },
	[241] = { 17082, 17064, },
	[261] = { 18203, 18202, },
	[281] = { 16509, 16510, 16513, 16515, 16514, 16516, },
	[282] = { 16405, 16406, 16430, 16431, 16429, 16432, },
	[301] = { 16519, 16518, 16522, 16523, 16521, 16524, },
	[321] = { 12424, 12426, 12425, 12422, 12427, 12429, 12428, },
	[341] = { 16485, 16487, 16491, 16490, 16489, 16492, },
	[342] = { 17616, 17617, 17612, 17611, 17613, 17610, },
	[343] = { 16369, 16391, 16413, 16414, 16416, 16415, },
	[344] = { 17594, 17596, 17600, 17599, 17598, 17601, },
	[345] = { 17576, 17577, 17572, 17571, 17570, 17573, },
	[346] = { 17562, 17564, 17568, 17567, 17569, 17566, },
	[347] = { 16498, 16499, 16505, 16508, 16506, 16507, },
	[348] = { 16392, 16396, 16417, 16419, 16420, 16418, },
	[361] = { 16531, 16530, 16525, 16527, 16526, 16528, },
	[362] = { 16425, 16426, 16401, 16403, 16428, 16427, },
	[381] = { 16423, 16424, 16422, 16421, 16393, 16397, },
	[382] = { 16494, 16496, 16504, 16502, 16503, 16501, },
	[383] = { 16541, 16542, 16544, 16545, 16548, 16543, },
	[384] = { 16477, 16478, 16480, 16483, 16484, 16479, },
	[386] = { 16577, 16578, 16580, 16573, 16574, 16579, },
	[387] = { 16536, 16533, 16535, 16539, 16540, 16534, },
	[388] = { 16441, 16444, 16443, 16437, 16440, 16442, },
	[389] = { 17604, 17603, 17605, 17608, 17607, 17602, },
	[390] = { 17623, 17625, 17622, 17624, 17618, 17620, },
	[391] = { 17586, 17588, 17593, 17591, 17590, 17592, },
	[392] = { 17581, 17580, 17583, 17584, 17579, 17578, },
	[393] = { 16563, 16561, 16562, 16564, 16560, 16558, },
	[394] = { 16453, 16457, 16455, 16446, 16454, 16456, },
	[395] = { 16466, 16465, 16468, 16462, 16463, 16467, },
	[396] = { 16569, 16571, 16567, 16565, 16566, 16568, },
	[397] = { 16452, 16451, 16449, 16459, 16448, 16450, },
	[398] = { 16554, 16555, 16552, 16551, 16549, 16550, },
	[401] = { 16410, 16409, 16433, 16435, 16434, 16436, },
	[402] = { 16473, 16474, 16476, 16472, 16471, 16475, },
	[421] = { 19682, 19683, 19684, },
	[441] = { 19685, 19687, 19686, },
	[442] = { 19688, 19689, },
	[443] = { 19690, 19691, 19692, },
	[444] = { 19693, 19694, 19695, },
	[461] = { 19865, 19866, },
	[462] = { 19893, 19905, },
	[463] = { 19896, 19910, },
	[464] = { 19873, 19912, },
	[465] = { 19863, 19920, },
	[466] = { 19898, 19925, },
	[467] = { 20041, 20048, 20057, },
	[468] = { 20042, 20049, 20058, },
	[469] = { 20043, 20050, 20055, },
	[470] = { 20044, 20051, 20056, },
	[471] = { 20052, 20045, 20059, },
	[472] = { 20053, 20046, 20060, },
	[473] = { 20054, 20047, 20061, },
	[474] = { 19951, 19577, 19824, 19823, 19822, },
	[475] = { 19952, 19588, 19827, 19826, 19825, },
	[476] = { 19609, 19956, 19830, 19829, 19828, },
	[477] = { 19621, 19953, 19833, 19832, 19831, },
	[478] = { 19617, 19954, 19836, 19835, 19834, },
	[479] = { 19613, 19955, 19840, 19839, 19838, },
	[480] = { 19594, 19958, 19843, 19842, 19841, },
	[481] = { 19605, 19957, 19848, 19849, 20033, },
	[482] = { 19601, 19959, 19846, 19845, 20034, },
	[483] = { 20158, 20154, 20150, },
	[484] = { 20195, 20199, 20203, },
	[485] = { 20176, 20159, 20163, },
	[486] = { 20186, 20190, 20194, },
	[487] = { 20204, 20208, 20212, },
	[488] = { 20167, 20171, 20175, },
	[489] = { 16984, 15050, 15052, 15051, },
	[490] = { 15045, 15046, 20296, },
	[491] = { 15048, 20295, 15049, },
	[492] = { 20406, 20408, 20407, },
	[493] = { 21355, 21353, 21354, 21356, 21357, },
	[494] = { 21408, 21409, 21407, },
	[495] = { 21394, 21392, 21393, },
	[496] = { 21331, 21329, 21333, 21332, 21330, },
	[497] = { 21359, 21360, 21361, 21362, 21364, },
	[498] = { 21405, 21406, 21404, },
	[499] = { 21337, 21338, 21335, 21334, 21336, },
	[500] = { 21416, 21417, 21418, },
	[501] = { 21372, 21373, 21374, 21375, 21376, },
	[502] = { 21400, 21398, 21399, },
	[503] = { 21344, 21347, 21346, 21343, 21345, },
	[504] = { 21414, 21413, 21415, },
	[505] = { 21389, 21387, 21388, 21390, 21391, },
	[506] = { 21397, 21395, 21396, },
	[507] = { 21349, 21350, 21348, 21352, 21351, },
	[508] = { 21410, 21411, 21412, },
	[509] = { 21366, 21365, 21370, 21368, 21367, },
	[510] = { 21403, 21401, 21402, },
	[511] = { 21994, 21995, 21996, 21997, 21998, 21999, 22000, 22001, },
	[512] = { 22002, 22003, 22004, 22005, 22006, 22007, 22008, 22009, },
	[513] = { 22106, 22107, 22108, 22109, 22110, 22111, 22112, 22113, },
	[514] = { 22078, 22079, 22080, 22081, 22082, 22083, 22084, 22085, },
	[515] = { 22010, 22011, 22061, 22013, 22015, 22016, 22017, 22060, },
	[516] = { 22086, 22087, 22088, 22089, 22090, 22091, 22092, 22093, },
	[517] = { 22062, 22063, 22064, 22065, 22066, 22067, 22068, 22069, },
	[518] = { 22070, 22071, 22072, 22073, 22074, 22075, 22076, 22077, },
	[519] = { 22095, 22096, 22097, 22098, 22099, 22100, 22101, 22102, },
	[520] = { 22306, 22311, 22313, 22302, 22304, 22305, 22303, 22301, },
	[521] = { 22492, 22494, 22493, 22490, 22489, 22491, 22488, 22495, 23064, },
	[522] = { 22864, 22856, 22879, 22880, 23257, 23258, },
	[523] = { 22423, 22416, 22421, 22422, 22418, 22417, 22419, 22420, 23059, },
	[524] = { 22483, 22476, 22481, 22478, 22477, 22479, 22480, 22482, 23060, },
	[525] = { 22518, 22519, 22514, 22517, 22513, 22512, 22516, 22515, 23061, },
	[526] = { 22502, 22503, 22498, 22501, 22497, 22496, 22500, 22499, 23062, },
	[527] = { 22468, 22470, 22469, 22466, 22465, 22467, 22464, 22471, 23065, },
	[528] = { 22430, 22431, 22426, 22428, 22427, 22429, 22425, 22424, 23066, },
	[529] = { 22510, 22511, 22506, 22509, 22505, 22504, 22508, 22507, 23063, },
	[530] = { 22440, 22442, 22441, 22438, 22437, 22439, 22436, 22443, 23067, },
	[533] = { 23090, 23087, 23078, },
	[534] = { 23081, 23089, 23093, },
	[535] = { 23088, 23082, 23092, },
	[536] = { 23091, 23084, 23085, },
	[537] = { 22868, 22858, 22872, 22873, 23244, 23243, },
	[538] = { 22857, 22867, 22876, 22887, 23259, 23260, },
	[539] = { 22863, 22852, 22877, 22878, 23253, 23254, },
	[540] = { 22869, 22859, 22882, 22885, 23261, 23262, },
	[541] = { 22865, 22855, 23255, 23256, 22881, 22884, },
	[542] = { 22870, 22860, 23263, 23264, 22883, 22886, },
	[543] = { 22843, 22862, 23251, 23252, 22874, 22875, },
	[544] = { 23272, 23273, 23274, 23275, 23276, 23277, },
	[545] = { 23300, 23301, 23286, 23287, 23314, 23315, },
	[546] = { 23304, 23305, 23290, 23291, 23318, 23319, },
	[547] = { 23296, 23297, 23282, 23283, 23310, 23311, },
	[548] = { 23298, 23299, 23284, 23285, 23312, 23313, },
	[549] = { 23302, 23303, 23288, 23289, 23316, 23317, },
	[550] = { 23292, 23293, 23278, 23279, 23306, 23307, },
	[551] = { 23294, 23295, 23280, 23281, 23308, 23309, },
	[552] = { 21848, 21847, 21846, },
	[553] = { 21871, 21869, 21870, },
	[554] = { 21875, 21874, 21873, },
	[555] = { 21855, 21854, 21852, 21851, 21849, 21853, 21850, },
	[556] = { 21862, 21861, 21859, 21860, },
	[557] = { 21865, 21864, 21863, },
	[558] = { 21868, 21866, 21867, },
	[559] = { 24266, 24262, },
	[560] = { 23489, 23488, 23487, 23482, 23484, },
	[561] = { 23490, 23491, 23493, 23494, },
	[562] = { 23507, 23508, 23506, },
	[563] = { 23509, 23512, 23511, 23510, },
	[564] = { 23513, 23516, 23514, 23515, },
	[565] = { 23523, 23525, 23524, },
	[566] = { 23522, 23521, 23520, 33173, },
	[567] = { 24544, 24549, 24545, 24547, 24546, },
	[568] = { 24556, 24553, 24555, 24554, 24552, },
	[569] = { 23519, 23518, 23517, },
	[570] = { 24255, 24249, },
	[571] = { 24264, 24261, },
	[572] = { 24267, 24263, },
	[573] = { 25685, 25686, 25687, },
	[574] = { 25691, 25690, 25689, },
	[575] = { 25695, 25697, 25696, },
	[576] = { 25694, 25693, 25692, },
	[577] = { 25834, 25833, 25830, 25832, 25831, },
	[578] = { 25997, 26000, 25998, 26001, 25999, },
	[579] = { 25854, 25855, 25857, 25856, 25858, },
	[580] = { 27469, 27470, 27471, 27472, 27473, },
	[581] = { 27707, 27708, 27709, 27710, 27711, },
	[582] = { 27702, 27703, 27704, 27705, 27706, },
	[583] = { 27879, 27880, 27881, 27882, 27883, },
	[584] = { 28126, 28127, 28128, 28129, 28130, },
	[585] = { 28136, 28137, 28138, 28139, 28140, },
	[586] = { 28334, 28335, 28331, 28332, 28333, },
	[587] = { 28831, 28832, 28833, 28834, 28835, },
	[588] = { 28851, 28852, 28853, 28854, 28855, },
	[589] = { 28679, 28680, 28681, 28724, 28683, },
	[590] = { 28699, 28700, 28701, 28702, 28703, },
	[591] = { 28624, 28625, 28626, 28627, 28628, },
	[592] = { 28817, 28818, 28819, 28820, 28821, },
	[593] = { 28689, 28690, 28691, 28692, 28693, },
	[594] = { 28841, 28842, 28843, 28844, 28845, },
	[595] = { 28613, 28614, 28615, 28616, 28617, },
	[596] = { 28805, 28806, 28807, 28808, 28809, },
	[597] = { 28704, 28705, 28706, 28707, 28708, },
	[598] = { 28856, 28857, 28858, 28859, 28860, },
	[599] = { 28714, 28715, 28716, 28717, 28718, },
	[600] = { 28866, 28867, 28868, 28869, 28870, },
	[601] = { 28618, 28619, 28620, 28622, 28623, },
	[602] = { 28811, 28812, 28813, 28814, 28815, },
	[603] = { 28694, 28695, 28696, 28697, 28698, },
	[604] = { 28846, 28847, 28848, 28849, 28850, },
	[605] = { 28684, 28685, 28686, 28687, 28688, },
	[606] = { 28836, 28837, 28838, 28839, 28840, },
	[607] = { 28709, 28710, 28711, 28712, 28713, },
	[608] = { 28861, 28862, 28863, 28864, 28865, },
	[609] = { 28719, 28720, 28721, 28722, 28723, },
	[610] = { 28871, 28872, 28873, 28874, 28875, },
	[611] = { 25657, 25656, 25655, 25654, },
	[612] = { 25661, 25659, 25662, 25660, },
	[613] = { 25668, 25669, 25670, 25671, },
	[614] = { 25673, 25674, 25675, 25676, },
	[615] = { 30186, 30187, 30188, 30200, 30201, },
	[616] = { 29516, 29517, 29515, },
	[617] = { 29521, 29520, 29519, },
	[618] = { 29523, 29524, 29522, },
	[619] = { 29527, 29526, 29525, },
	[620] = { 27509, 28414, 27908, 27776, 28204, },
	[621] = { 29046, 29045, 29044, 29048, 29047, },
	[622] = { 30144, 30145, 30146, 30148, 30149, },
	[623] = { 28203, 27535, 28285, 27839, 27739, },
	[624] = { 29062, 29061, 29065, 29063, 29064, },
	[625] = { 29066, 29068, 29067, 29069, 29070, },
	[626] = { 29071, 29073, 29072, 29074, 29075, },
	[627] = { 30134, 30135, 30136, 30137, 30138, },
	[628] = { 30123, 30125, 30124, 30126, 30127, },
	[629] = { 30129, 30130, 30132, 30133, 30131, },
	[630] = { 28231, 27510, 28349, 27909, 27802, },
	[631] = { 29032, 29029, 29028, 29030, 29031, },
	[632] = { 29033, 29035, 29034, 29036, 29037, },
	[633] = { 29038, 29039, 29040, 29043, 29042, },
	[634] = { 30164, 30165, 30166, 30167, 30168, },
	[635] = { 30169, 30170, 30171, 30172, 30173, },
	[636] = { 30185, 30189, 30190, 30192, 30194, },
	[637] = { 28348, 27468, 27873, 28202, 27737, },
	[638] = { 29087, 29086, 29090, 29088, 29089, },
	[639] = { 29093, 29094, 29091, 29092, 29095, },
	[640] = { 29096, 29097, 29099, 29100, 29098, },
	[641] = { 30222, 30223, 30228, 30229, 30230, },
	[642] = { 30216, 30217, 30219, 30220, 30221, },
	[643] = { 30231, 30232, 30233, 30234, 30235, },
	[644] = { 27537, 28415, 28232, 27778, 27948, },
	[645] = { 28963, 28968, 28966, 28967, 28964, },
	[646] = { 30211, 30212, 30213, 30215, 30214, },
	[647] = { 28278, 27508, 27738, 28229, 27838, },
	[648] = { 29076, 29080, 29078, 29079, 29077, },
	[649] = { 30206, 30205, 30207, 30210, 30196, },
	[650] = { 28228, 27474, 28275, 27874, 27801, },
	[651] = { 29085, 29081, 29083, 29082, 29084, },
	[652] = { 30139, 30140, 30141, 30142, 30143, },
	[653] = { 28205, 27475, 27977, 27803, 28350, },
	[654] = { 29012, 29011, 29017, 29015, 29016, },
	[655] = { 29021, 29019, 29020, 29022, 29023, },
	[656] = { 30113, 30115, 30114, 30116, 30117, },
	[657] = { 30120, 30118, 30119, 30121, 30122, },
	[658] = { 28193, 27465, 27907, 28191, 27796, },
	[659] = { 28264, 27531, 28224, 27837, 27797, },
	[660] = { 27936, 28401, 27528, 28192, 27713, },
	[661] = { 28403, 27497, 28225, 27870, 27771, },
	[662] = { 28413, 28230, 27536, 27775, 27875, },
	[663] = { 29055, 29049, 29054, 29050, 29053, },
	[664] = { 29057, 29059, 29056, 29058, 29060, },
	[665] = { 30153, 30152, 30151, 30154, 30150, },
	[666] = { 30160, 30161, 30162, 30159, 30163, },
	[667] = { 31339, 31338, },
	[668] = { 31028, 31026, 31027, 31029, 31030, 34575, 34448, 34558, },
	[669] = { 31004, 31001, 31003, 31005, 31006, 34549, 34443, 34570, },
	[670] = { 31050, 31051, 31053, 31054, 31052, 34564, 34436, 34541, },
	[671] = { 31056, 31055, 31058, 31059, 31057, 34574, 34447, 34557, },
	[672] = { 30972, 30975, 30969, 30977, 30979, 34546, 34441, 34569, },
	[673] = { 30976, 30974, 30970, 30978, 30980, 34568, 34442, 34547, },
	[674] = { 31061, 31064, 31067, 31070, 31065, 34434, 34528, 34563, },
	[675] = { 31068, 31063, 31060, 31069, 31066, 34562, 34527, 34435, },
	[676] = { 31042, 31034, 31039, 31044, 31048, 34556, 34444, 34573, },
	[677] = { 31043, 31035, 31040, 31046, 31049, 34572, 34446, 34555, },
	[678] = { 31041, 31032, 31037, 31045, 31047, 34571, 34445, 34554, },
	[679] = { 30991, 30987, 30985, 30995, 30998, 34488, 34433, 34560, },
	[680] = { 30990, 30982, 30993, 30997, 30989, 34561, 34431, 34485, },
	[681] = { 30992, 30983, 30988, 30994, 30996, 34432, 34487, 34559, },
	[682] = { 31018, 31011, 31015, 31021, 31024, 34567, 34439, 34545, },
	[683] = { 31016, 31007, 31012, 31019, 31022, 34543, 34438, 34565, },
	[684] = { 31017, 31008, 31014, 31020, 31023, 34542, 34437, 34566, },
	[685] = { 31375, 31376, 31377, 31378, 31379, },
	[686] = { 31396, 31397, 31400, 31406, 31407, },
	[687] = { 31409, 31410, 31411, 31412, 31413, },
	[688] = { 31589, 31590, 31591, 31592, 31593, },
	[689] = { 31584, 31585, 31586, 31587, 31588, },
	[690] = { 31613, 31614, 31616, 31618, 31619, },
	[691] = { 31622, 31623, 31620, 31624, 31625, },
	[692] = { 31626, 31627, 31621, 31628, 31629, },
	[693] = { 31630, 31631, 31632, 31633, 31634, },
	[694] = { 31635, 31636, 31637, 31638, 31639, },
	[695] = { 31640, 31641, 31642, 31643, 31644, },
	[696] = { 31646, 31647, 31648, 31649, 31650, },
	[697] = { 29600, 29601, 29602, 29603, 29604, 29605, },
	[698] = { 29612, 29613, 29614, 29615, 29616, 29617, },
	[699] = { 32838, 32837, },
	[717] = { 29608, 29606, 29611, 29609, 29607, 29610, },
	[718] = { 29599, 29595, 29597, 29596, 29598, 29594, },
	[719] = { 32946, 32945, },
	[737] = { 34703, 28189, },
	[738] = { 35328, 35329, 35330, 35331, 35332, },
	[739] = { 35333, 35334, 35335, 35336, 35337, },
	[740] = { 35338, 35339, 35340, 35341, 35342, },
	[741] = { 35343, 35344, 35345, 35346, 35347, },
	[742] = { 35356, 35357, 35358, 35360, 35359, },
	[743] = { 35371, 35372, 35373, 35375, 35374, },
	[744] = { 35361, 35362, 35363, 35365, 35364, },
	[745] = { 35366, 35367, 35368, 35369, 35370, },
	[746] = { 35386, 35387, 35388, 35389, 35390, },
	[747] = { 35391, 35392, 35393, 35394, 35395, },
	[748] = { 35381, 35382, 35383, 35384, 35385, },
	[749] = { 35376, 35377, 35378, 35379, 35380, },
	[750] = { 35407, 35408, 35409, 35410, 35411, },
	[751] = { 35402, 35403, 35404, 35405, 35406, },
	[752] = { 35412, 35413, 35414, 35415, 35416, },
	[754] = { 38405, 38404, 38400, 38403, 38401, 38402, 38437, 38433, },
	[755] = { 38418, 38419, 38420, 38421, 38422, 38417, 38439, 38435, },
	[756] = { 38412, 38413, 38414, 38415, 38416, 38424, 38436, 38440, },
	[757] = { 38406, 38407, 38408, 38409, 38410, 38411, 38434, 38438, },
	[759] = { 37758, 37821, },
	[760] = { 40440, 40441, 40442, 40443, 40444, },
	[761] = { 34087, 21525, 34085, 21524, 34086, },
	[762] = { 33862, 33863, 33868, 33966, 33969, 33967, 33864, 33968, },
	[763] = { 41522, 41520, 44211, 41521, 41519, 41515, 41513, 41512, },
	[764] = { 41543, 41544, 41545, 41546, 41548, 41549, 41550, 41551, },
	[765] = { 42625, 42626, 42627, 42628, 42629, },
	[766] = { 42630, 42631, 42632, 42633, 42634, },
	[767] = { 42635, 42636, 42637, 42638, 42639, },
	[768] = { 42654, 42655, 42656, 42657, 42658, },
	[769] = { 42659, 42660, 42661, 42662, 42663, },
	[770] = { 42669, 42670, 42671, 42672, 42673, },
	[771] = { 42664, 42665, 42666, 42667, 42668, },
	[772] = { 42674, 42675, 42676, 42677, 42678, },
	[773] = { 42680, 42681, 42682, 42683, 42684, },
	[774] = { 42685, 42686, 42687, 42688, 42689, },
	[775] = { 42690, 42691, 42692, 42693, 42694, },
	[776] = { 42695, 42696, 42697, 42698, 42699, },
	[777] = { 42703, 42704, 42705, 42706, 42707, },
	[778] = { 42708, 42709, 42710, 42711, 42712, },
	[779] = { 42713, 42714, 42715, 42716, 42717, },
	[780] = { 42718, 42719, 42720, 42721, 42722, },
	[781] = { 43073, 43074, 43075, 43072, },
	[782] = { 43078, 43077, 43079, 43076, },
	[783] = { 43082, 43081, 43083, 43080, },
	[784] = { 43070, 43068, 43071, 43069, },
	[785] = { 23324, 34685, 34683, },
	[787] = { 43740, 43742, 43743, 43745, 43747, },
	[788] = { 43739, 43744, 43746, 43741, 43748, },
	[789] = { 43794, 43796, 43801, 43803, 43805, },
	[790] = { 43797, 43798, 43800, 43806, 43807, },
	[791] = { 43793, 43795, 43799, 43802, 43804, },
	[792] = { 43809, 43813, 43815, 43817, 43819, },
	[793] = { 43811, 43812, 43814, 43816, 43818, },
	[794] = { 43734, 43735, 43736, 43737, 43738, },
	[795] = { 43762, 43763, 43765, 43772, 43776, },
	[796] = { 43764, 43767, 43769, 43770, 43773, },
	[797] = { 43766, 43768, 43771, 43774, 43775, },
	[798] = { 43751, 43753, 43756, 43822, 43758, },
	[799] = { 43752, 43754, 43755, 43759, 43820, },
	[800] = { 43749, 43750, 43757, 43760, 43761, },
	[801] = { 43727, 43728, 43729, 43730, 43731, },
	[802] = { 43787, 43788, 43789, 43790, 43791, },
	[803] = { 43777, 43778, 43779, 43780, 43781, },
	[804] = { 43733, 43782, 43784, 43808, 43810, },
	[805] = { 43732, 43783, 43785, 43786, 43792, },
	[812] = { 6835, 6833, },
	[813] = { 43435, 43434, 43260, 43436, 43438, 43433, 43439, 43437, },
	[814] = { 42723, 42724, 42725, 42726, 42727, 42728, 42730, 42729, },
	[815] = { 43266, 43273, 43264, 43263, 43265, 43261, 43271, 43262, },
	[816] = { 41354, 41349, 41353, 41347, 41351, 41350, 41352, 41348, },
	[817] = { 43450, 43455, 43454, 43453, 43456, 43457, 43451, 43452, },
	[818] = { 43442, 43443, 43444, 43446, 43445, 43447, 43448, 43449, },
	[819] = { 43969, 43970, 43974, 43971, 41516, 43975, 43972, 43973, },
	[820] = { 46213, 46216, 46221, 46224, 46226, },
	[821] = { 46214, 46215, 46219, 46222, 46225, },
	[822] = { 46217, 46218, 46220, 46227, 46228, },
	[823] = { 46293, 46294, 46296, 46303, 46307, },
	[824] = { 46295, 46298, 46300, 46301, 46304, },
	[825] = { 46297, 46299, 46302, 46305, 46306, },
	[826] = { 46288, 46289, 46290, 46291, 46292, },
	[827] = { 46260, 46262, 46265, 46267, 46269, },
	[828] = { 45350, 46309, 46266, 46271, 46272, },
	[829] = { 46261, 46263, 46264, 46268, 46270, },
	[830] = { 46278, 46280, 46282, 46285, 46287, },
	[831] = { 46279, 46281, 46283, 46284, 46286, },
	[832] = { 46230, 46248, 46255, 46256, 46257, },
	[833] = { 46231, 46247, 46254, 46258, 46259, },
	[834] = { 46232, 46235, 46237, 46239, 46241, },
	[835] = { 46233, 46234, 46236, 46238, 46240, },
	[836] = { 46249, 46250, 46251, 46252, 46253, },
	[837] = { 46242, 46243, 46244, 46245, 46246, },
	[838] = { 46273, 46274, 46275, 46276, 46277, },
	[842] = { 47164, 47166, 47163, },
	[843] = { 48725, 48726, 48727, 48728, 48729, },
	[844] = { 48730, 48731, 48732, 48733, 48734, },
	[845] = { 48735, 48736, 48737, 48738, 48739, },
	[846] = { 48740, 48741, 48742, 48743, 48744, },
	[847] = { 48745, 48746, 48747, 48748, 48749, },
	[848] = { 48750, 48751, 48752, 48753, 48754, },
	[849] = { 48755, 48756, 48757, 48758, 48759, },
	[850] = { 48760, 48761, 48762, 48763, 48764, },
	[851] = { 48774, 48775, 48776, 48777, 48778, },
	[852] = { 48769, 48770, 48771, 48772, 48773, },
	[853] = { 48786, 48787, 48788, 48789, 48790, },
	[854] = { 48781, 48782, 48783, 48784, 48785, },
	[855] = { 48799, 48800, 48801, 48802, 48803, },
	[856] = { 48794, 48795, 48796, 48797, 48798, },
	[857] = { 48809, 48810, 48811, 48812, 48813, },
	[858] = { 48804, 48805, 48806, 48807, 48808, },
	[859] = { 48819, 48820, 48821, 48822, 48823, },
	[860] = { 48814, 48815, 48816, 48817, 48818, },
	[861] = { 48824, 48825, 48826, 48827, 48828, },
	[862] = { 48829, 48830, 48831, 48832, 48833, },
	[863] = { 48841, 48842, 48843, 48844, 48845, },
	[864] = { 48836, 48837, 48838, 48839, 48840, },
	[865] = { 48846, 48847, 48848, 48849, 48850, },
	[866] = { 48854, 48855, 48852, 48853, 48851, },
	[867] = { 48865, 48866, 48867, 48868, 48869, },
	[868] = { 48860, 48861, 48862, 48863, 48864, },
	[869] = { 48875, 48876, 48877, 48878, 48879, },
	[870] = { 48870, 48871, 48872, 48873, 48874, },
	[871] = { 48885, 48886, 48887, 48888, 48889, },
	[872] = { 48880, 48881, 48882, 48883, 48884, },
	[873] = { 48895, 48896, 48897, 48898, 48899, },
	[874] = { 48890, 48891, 48892, 48893, 48894, },
	[875] = { 48904, 48903, 48902, 48901, 48900, },
	[876] = { 48909, 48908, 48907, 48906, 48905, },
	[877] = { 48915, 48916, 48917, 48918, 48919, },
	[878] = { 48910, 48911, 48912, 48913, 48914, },
	[879] = { 48927, 48928, 48929, 48930, 48931, },
	[880] = { 48922, 48923, 48924, 48925, 48926, },
	[881] = { 49310, 49463, },
	[882] = { 49488, 49464, },
	[883] = { 51716, 51715, 51714, 51713, 51712, },
	[884] = { 51766, 51765, 51764, 51763, 51762, },
	[885] = { 51732, 51733, 51734, 51735, 51736, },
	[886] = { 51741, 51740, 51739, 51738, 51737, },
	[887] = { 51696, 51695, 51694, 51693, 51692, },
	[888] = { 51706, 51705, 51704, 51703, 51702, },
	[889] = { 51701, 51700, 51699, 51698, 51697, },
	[890] = { 51746, 51745, 51744, 51743, 51742, },
	[891] = { 51711, 51710, 51709, 51708, 51707, },
	[892] = { 51747, 51748, 51749, 51750, 51751, },
	[893] = { 51757, 51758, 51759, 51760, 51761, },
	[894] = { 51752, 51753, 51754, 51755, 51756, },
	[895] = { 51771, 51770, 51769, 51768, 51767, },
	[896] = { 51776, 51775, 51774, 51773, 51772, },
	[897] = { 51686, 51685, 51684, 51683, 51682, },
	[898] = { 51691, 51690, 51689, 51688, 51687, },
	[899] = { 51726, 51725, 51724, 51723, 51722, },
	[900] = { 51721, 51720, 51719, 51718, 51717, },
	[901] = { 51731, 51730, 51729, 51728, 51727, },
	[908] = { 20184, 20177, 20181, },
	[909] = { 64947, 64946, 64945, 64944, 64943, },
	[910] = { 64977, 64976, 64975, 64974, 64973, },
	[911] = { 65156, 65155, 65154, 65153, 65152, },
	[912] = { 64962, 64961, 64960, 64959, 64958, },
	[913] = { 65151, 65150, 65149, 65148, 65147, },
	[914] = { 64967, 64966, 64965, 64964, 64963, },
	[915] = { 64942, 64941, 64940, 64939, 64938, },
	[916] = { 64957, 64956, 64955, 64954, 64953, },
	[917] = { 64937, 64936, 64935, 64934, 64933, },
	[918] = { 64952, 64951, 64950, 64949, 64948, },
	[919] = { 64932, 64931, 64930, 64929, 64928, },
	[920] = { 64992, 64991, 64990, 64989, 64988, },
	[921] = { 64927, 64926, 64925, 64924, 64923, },
	[922] = { 64987, 64986, 64985, 64984, 64983, },
	[923] = { 64972, 64971, 64970, 64969, 64968, },
	[924] = { 64982, 64981, 64980, 64979, 64978, },
	[925] = { 60339, 60340, 60341, 60342, 60343, },
	[926] = { 60349, 60350, 60351, 60352, 60353, },
	[927] = { 60290, 60286, 60288, 60287, 60289, },
	[928] = { 60280, 60277, 60278, 60276, 60279, },
	[929] = { 60284, 60281, 60283, 60282, 60285, },
	[930] = { 60306, 60305, 60303, 60307, 60304, },
	[931] = { 60246, 60244, 60245, 60243, 60247, },
	[932] = { 60348, 60347, 60346, 60345, 60344, },
	[933] = { 60362, 60361, 60359, 60363, 60360, },
	[934] = { 60358, 60357, 60356, 60355, 60354, },
	[935] = { 60262, 60259, 60261, 60258, 60275, },
	[936] = { 60253, 60254, 60255, 60256, 60257, },
	[937] = { 60302, 60300, 60299, 60298, 60301, },
	[938] = { 60311, 60310, 60308, 60312, 60309, },
	[939] = { 60322, 60321, 60320, 60319, 60318, },
	[940] = { 60317, 60316, 60315, 60314, 60313, },
	[941] = { 60252, 60251, 60250, 60249, 60248, },
	[942] = { 60327, 60324, 60325, 60326, 60323, },
	[943] = { 60331, 60330, 60328, 60332, 60329, },
	[944] = { 54486, 54485, 54484, 54483, 54482, 54481, 54480, 54479, },
	[945] = { 54478, 54477, 54476, 54475, 54474, 54473, 54472, 54471, },
	[949] = { 56513, 56509, 56505, 56499, 56495, 56491, 56484, 56483, },
	[950] = { 56512, 56508, 56504, 56498, 56494, 56490, 56482, 56481, },
	[951] = { 63538, 63537, },
	[963] = { 70010, 70005, 70011, 70004, 70006, 70007, 70008, 70009, },
	[964] = { 70018, 70013, 70019, 70012, 70014, 70015, 70016, 70017, },
	[965] = { 70020, 70021, 70022, 70023, 70024, 70025, 70026, 70027, },
	[966] = { 70028, 70029, 70030, 70031, 70032, 70033, 70034, 70035, },
	[967] = { 70036, 70037, 70038, 70039, 70040, 70041, 70042, 70043, },
	[968] = { 70044, 70045, 70046, 70047, 70048, 70049, 70050, 70051, },
	[969] = { 70062, 70061, 70063, 70070, 70067, 70065, 70066, 70060, 70064, },
	[970] = { 70052, 70053, 70054, 70055, 70056, 70057, 70058, 70059, },
	[1000] = { 71058, 71059, 71060, 71061, 71062, },
	[1001] = { 70951, 70952, 70953, 70954, 70955, },
	[1002] = { 71097, 71098, 71099, 71100, 71101, },
	[1003] = { 71107, 71108, 71109, 71110, 71111, },
	[1004] = { 71102, 71103, 71104, 71105, 71106, },
	[1005] = { 71050, 71051, 71052, 71053, 71054, },
	[1006] = { 71045, 71046, 71047, 71048, 71049, },
	[1007] = { 71290, 71286, 71287, 71288, 71289, },
	[1008] = { 71281, 71283, 71282, 71284, 71285, },
	[1009] = { 71271, 71272, 71273, 71274, 71275, },
	[1010] = { 71280, 71279, 71278, 71277, 71276, },
	[1011] = { 71095, 71094, 71093, 71092, 71091, },
	[1012] = { 71067, 71066, 71065, 71064, 71063, },
	[1013] = { 70946, 70947, 70948, 70949, 70950, },
	[1014] = { 71300, 71299, 71298, 71297, 71296, },
	[1015] = { 71305, 71304, 71303, 71302, 71301, },
	[1016] = { 71295, 71294, 71293, 71292, 71291, },
	[1017] = { 71072, 71071, 71069, 71068, 71070, },
	[1018] = { 70941, 70942, 70944, 70943, 70945, },
	[1056] = { 77008, 77009, 77010, 77011, 77012, },
	[1057] = { 76974, 76975, 76976, 76977, 76978, },
	[1058] = { 77013, 77014, 77015, 77016, 77017, },
	[1059] = { 77018, 77019, 77020, 77021, 77022, },
	[1060] = { 76749, 76750, 76751, 76752, 76753, },
	[1061] = { 77028, 77029, 77030, 77031, 77032, },
	[1062] = { 76212, 76213, 76214, 76215, 76216, },
	[1063] = { 76765, 76766, 76767, 76768, 76769, },
	[1064] = { 76874, 76875, 76876, 76877, 76878, },
	[1065] = { 77003, 77004, 77005, 77006, 77007, },
	[1066] = { 76357, 76358, 76359, 76360, 76361, },
	[1067] = { 76348, 76347, 76346, 76345, 76344, },
	[1068] = { 77023, 77024, 77025, 77026, 77027, },
	[1069] = { 76756, 76757, 76758, 76759, 76760, },
	[1070] = { 77039, 77038, 77037, 77036, 77035, },
	[1071] = { 77040, 77041, 77042, 77043, 77044, },
	[1072] = { 76343, 76342, 76341, 76340, 76339, },
	[1073] = { 76983, 76984, 76985, 76986, 76987, },
	[1074] = { 76988, 76989, 76990, 76991, 76992, },
	[1087] = { 77949, 77950, },
	[1088] = { 77947, 77948, },
	[1089] = { 77945, 77946, },
};
DT.ItemSetThreshold = {
	[1]={ 2, 3, 4, 5, },
	[41]={ 2, },
	[65]={ 2, },
	[81]={ 2, 3, 3, 4, 5, 5, },
	[121]={ 2, 3, 4, 5, },
	[122]={ 2, 3, 4, 5, },
	[123]={ 2, 3, 4, 5, },
	[124]={ 2, 3, 4, 5, },
	[141]={ 3, },
	[142]={ 2, 3, 4, },
	[143]={ 2, },
	[144]={ 2, },
	[161]={ 2, 3, 4, 5, },
	[162]={ 2, 3, 4, 5, },
	[163]={ 2, 3, 4, 5, 6, },
	[181]={ 2, 4, 6, 8, },
	[182]={ 2, 4, 6, 8, },
	[183]={ 2, 4, 6, 8, },
	[184]={ 2, 4, 6, 8, },
	[185]={ 2, 4, 4, 6, 8, },
	[186]={ 2, 4, 6, 8, },
	[187]={ 2, 4, 6, 8, },
	[188]={ 2, 4, 6, 8, },
	[189]={ 2, 4, 6, 8, },
	[201]={ 3, 5, 8, },
	[202]={ 3, 5, 8, },
	[203]={ 3, 5, 8, },
	[204]={ 3, 5, 8, },
	[205]={ 3, 5, 8, },
	[206]={ 3, 5, 8, },
	[207]={ 3, 5, 8, },
	[208]={ 3, 5, 8, },
	[209]={ 3, 5, 8, },
	[210]={ 3, 5, 8, },
	[211]={ 3, 5, 8, },
	[212]={ 3, 5, 8, },
	[213]={ 3, 5, 8, },
	[214]={ 3, 5, 8, },
	[215]={ 3, 5, 8, },
	[216]={ 3, 5, 8, },
	[217]={ 3, 5, 8, },
	[218]={ 3, 5, 8, },
	[221]={ 6, },
	[241]={ 2, },
	[261]={ 2, },
	[281]={ 2, 4, 6, },
	[282]={ 2, 4, 6, },
	[301]={ 2, 4, 6, },
	[321]={ 2, 4, 6, },
	[341]={ 2, 4, 6, },
	[342]={ 2, 4, 6, },
	[343]={ 2, 4, 6, },
	[344]={ 2, 4, 6, },
	[345]={ 2, 4, 6, },
	[346]={ 2, 4, 6, },
	[347]={ 2, 4, 6, },
	[348]={ 2, 4, 6, },
	[361]={ 2, 4, 6, },
	[362]={ 2, 4, 6, },
	[381]={ 2, 4, 6, },
	[382]={ 2, 4, 6, },
	[383]={ 2, 3, 6, },
	[384]={ 2, 3, 6, },
	[386]={ 2, 3, 6, },
	[387]={ 2, 3, 6, },
	[388]={ 2, 3, 6, },
	[389]={ 2, 3, 6, },
	[390]={ 2, 3, 6, },
	[391]={ 2, 3, 6, },
	[392]={ 2, 3, 6, },
	[393]={ 2, 3, 6, },
	[394]={ 2, 3, 6, },
	[395]={ 2, 3, 6, },
	[396]={ 2, 3, 6, },
	[397]={ 2, 3, 6, },
	[398]={ 2, 3, 6, },
	[401]={ 2, 2, 4, 6, },
	[402]={ 2, 3, 6, },
	[421]={ 3, },
	[441]={ 3, },
	[442]={ 2, 2, },
	[443]={ 3, },
	[444]={ 3, },
	[461]={ 2, },
	[462]={ 2, 2, },
	[463]={ 2, },
	[464]={ 2, },
	[465]={ 2, },
	[466]={ 2, },
	[467]={ 2, 3, },
	[468]={ 2, 3, },
	[469]={ 2, 3, },
	[470]={ 2, 3, },
	[471]={ 2, 3, },
	[472]={ 2, 3, },
	[473]={ 2, 3, },
	[474]={ 2, 3, 5, },
	[475]={ 2, 3, 5, },
	[476]={ 2, 3, 5, },
	[477]={ 2, 3, 5, },
	[478]={ 2, 3, 5, },
	[479]={ 2, 3, 5, },
	[480]={ 2, 3, 5, },
	[481]={ 2, 3, 5, },
	[482]={ 2, 3, 5, },
	[483]={ 2, 3, },
	[484]={ 2, 3, },
	[485]={ 2, 3, },
	[486]={ 2, 3, },
	[487]={ 2, 3, },
	[488]={ 2, 3, },
	[489]={ 2, 3, 4, },
	[490]={ 2, 3, },
	[491]={ 2, 3, },
	[492]={ 3, },
	[493]={ 3, 3, 5, },
	[494]={ 3, },
	[495]={ 3, },
	[496]={ 3, 5, },
	[497]={ 3, 5, },
	[498]={ 3, },
	[499]={ 3, 5, },
	[500]={ 3, },
	[501]={ 3, 5, },
	[502]={ 3, },
	[503]={ 3, 5, },
	[504]={ 3, },
	[505]={ 3, 5, },
	[506]={ 3, },
	[507]={ 3, 5, },
	[508]={ 3, },
	[509]={ 3, 5, },
	[510]={ 3, },
	[511]={ 2, 4, 6, 8, },
	[512]={ 2, 4, 6, 8, },
	[513]={ 2, 4, 6, 6, 8, },
	[514]={ 2, 4, 6, 8, },
	[515]={ 2, 4, 6, 8, },
	[516]={ 2, 4, 6, 8, },
	[517]={ 2, 4, 6, 8, },
	[518]={ 2, 4, 6, 8, },
	[519]={ 2, 4, 6, 8, },
	[520]={ 4, 8, },
	[521]={ 2, 4, 6, 8, },
	[522]={ 2, 4, 6, },
	[523]={ 2, 4, 6, 8, },
	[524]={ 2, 4, 6, 8, },
	[525]={ 2, 4, 6, 8, },
	[526]={ 2, 4, 6, 8, },
	[527]={ 2, 4, 6, 8, },
	[528]={ 2, 4, 6, 8, },
	[529]={ 2, 4, 6, 8, },
	[530]={ 2, 4, 6, 8, },
	[533]={ 3, },
	[534]={ 3, },
	[535]={ 3, },
	[536]={ 3, },
	[537]={ 2, 4, 6, },
	[538]={ 2, 4, 6, },
	[539]={ 2, 4, 6, },
	[540]={ 2, 4, 6, },
	[541]={ 2, 4, 6, },
	[542]={ 2, 4, 6, },
	[543]={ 2, 4, 6, },
	[544]={ 2, 4, 6, },
	[545]={ 2, 4, 6, },
	[546]={ 2, 4, 6, },
	[547]={ 2, 4, 6, },
	[548]={ 2, 4, 6, },
	[549]={ 2, 4, 6, },
	[550]={ 2, 4, 6, },
	[551]={ 2, 4, 6, },
	[552]={ 3, },
	[553]={ 3, },
	[554]={ 3, },
	[555]={ 2, 4, },
	[556]={ 3, },
	[557]={ 3, },
	[558]={ 3, },
	[559]={ 2, },
	[560]={ 2, 4, },
	[561]={ 2, 4, },
	[562]={ 3, },
	[563]={ 3, },
	[564]={ 3, },
	[565]={ 3, },
	[566]={ 2, },
	[567]={ 2, 4, },
	[568]={ 2, 4, },
	[569]={ 3, },
	[570]={ 2, },
	[571]={ 2, },
	[572]={ 2, },
	[573]={ 3, },
	[574]={ 3, },
	[575]={ 3, },
	[576]={ 3, },
	[577]={ 2, 4, },
	[578]={ 2, 4, },
	[579]={ 2, 4, },
	[580]={ 2, 4, },
	[581]={ 2, 4, },
	[582]={ 2, 4, },
	[583]={ 2, 4, },
	[584]={ 2, 4, },
	[585]={ 2, 4, },
	[586]={ 2, 4, },
	[587]={ 2, 4, },
	[588]={ 2, 4, },
	[589]={ 2, 4, },
	[590]={ 2, 4, },
	[591]={ 2, 4, },
	[592]={ 2, 4, },
	[593]={ 2, 4, },
	[594]={ 2, 4, },
	[595]={ 2, 4, },
	[596]={ 2, 4, },
	[597]={ 2, 4, },
	[598]={ 2, 4, },
	[599]={ 2, 4, },
	[600]={ 2, 4, },
	[601]={ 2, 4, },
	[602]={ 2, 4, },
	[603]={ 2, 4, },
	[604]={ 2, 4, },
	[605]={ 2, 4, },
	[606]={ 2, 4, },
	[607]={ 2, 4, },
	[608]={ 2, 4, },
	[609]={ 2, 4, },
	[610]={ 2, 4, },
	[611]={ 2, 4, },
	[612]={ 2, 4, },
	[613]={ 2, 4, },
	[614]={ 2, 4, },
	[615]={ 2, 4, },
	[616]={ 3, },
	[617]={ 3, },
	[618]={ 3, },
	[619]={ 3, },
	[620]={ 2, 4, },
	[621]={ 2, 4, },
	[622]={ 2, 4, },
	[623]={ 2, 4, },
	[624]={ 2, 4, },
	[625]={ 2, 4, },
	[626]={ 2, 4, },
	[627]={ 2, 4, },
	[628]={ 2, 4, },
	[629]={ 2, 4, },
	[630]={ 2, 4, },
	[631]={ 2, 4, },
	[632]={ 2, 4, },
	[633]={ 2, 4, },
	[634]={ 2, 4, },
	[635]={ 2, 4, },
	[636]={ 2, 4, },
	[637]={ 2, 4, },
	[638]={ 2, 4, },
	[639]={ 2, 4, },
	[640]={ 2, 2, 4, 4, },
	[641]={ 2, 4, },
	[642]={ 2, 4, },
	[643]={ 2, 4, },
	[644]={ 2, 4, },
	[645]={ 2, 2, 4, },
	[646]={ 2, 4, },
	[647]={ 2, 4, },
	[648]={ 2, 4, },
	[649]={ 2, 4, },
	[650]={ 2, 4, },
	[651]={ 2, 4, },
	[652]={ 2, 4, },
	[653]={ 2, 4, },
	[654]={ 2, 4, },
	[655]={ 2, 4, },
	[656]={ 2, 4, },
	[657]={ 2, 4, },
	[658]={ 2, 4, },
	[659]={ 2, 4, },
	[660]={ 2, 4, },
	[661]={ 2, 4, },
	[662]={ 2, 4, },
	[663]={ 2, 4, },
	[664]={ 2, 4, },
	[665]={ 2, 4, },
	[666]={ 2, 4, },
	[667]={ 2, },
	[668]={ 2, 4, },
	[669]={ 2, 4, },
	[670]={ 2, 4, },
	[671]={ 2, 4, },
	[672]={ 2, 4, },
	[673]={ 2, 4, },
	[674]={ 2, 4, },
	[675]={ 2, 4, },
	[676]={ 2, 4, },
	[677]={ 2, 4, },
	[678]={ 2, 4, },
	[679]={ 2, 4, },
	[680]={ 2, 4, },
	[681]={ 2, 4, },
	[682]={ 2, 4, },
	[683]={ 2, 4, },
	[684]={ 2, 4, },
	[685]={ 2, 4, },
	[686]={ 2, 4, },
	[687]={ 2, 4, },
	[688]={ 2, 4, },
	[689]={ 2, 4, },
	[690]={ 2, 4, },
	[691]={ 2, 4, },
	[692]={ 2, 4, },
	[693]={ 2, 4, },
	[694]={ 2, 4, },
	[695]={ 2, 4, },
	[696]={ 2, 4, },
	[697]={ 2, 4, 6, },
	[698]={ 2, 3, 6, },
	[699]={ 2, 2, },
	[700]={ 2, 4, },
	[701]={ 2, 4, },
	[702]={ 2, 4, },
	[703]={ 2, 4, },
	[704]={ 2, 4, },
	[705]={ 2, 4, },
	[706]={ 2, 4, },
	[707]={ 2, 4, },
	[708]={ 2, 4, },
	[709]={ 2, 4, },
	[710]={ 2, 4, },
	[711]={ 2, 4, },
	[712]={ 2, 4, },
	[713]={ 2, 4, },
	[714]={ 2, 4, },
	[715]={ 2, 4, },
	[716]={ 2, 4, },
	[717]={ 2, 3, 6, },
	[718]={ 2, 4, 6, },
	[719]={ 2, },
	[720]={ 2, 4, },
	[721]={ 2, 4, },
	[722]={ 2, 4, },
	[723]={ 2, 4, },
	[724]={ 2, 4, },
	[725]={ 2, 4, },
	[726]={ 2, 4, },
	[727]={ 2, 4, },
	[728]={ 2, 4, },
	[729]={ 2, 4, },
	[730]={ 2, 4, },
	[731]={ 2, 4, },
	[732]={ 2, 4, },
	[733]={ 2, 4, },
	[734]={ 2, 4, },
	[735]={ 2, 4, },
	[736]={ 2, 4, },
	[737]={ 2, },
	[738]={ 2, 4, },
	[739]={ 2, 4, },
	[740]={ 2, 4, },
	[741]={ 2, 4, },
	[742]={ 2, 4, },
	[743]={ 2, 4, },
	[744]={ 2, 4, },
	[745]={ 2, 4, },
	[746]={ 2, 4, },
	[747]={ 2, 4, },
	[748]={ 2, 4, },
	[749]={ 2, 4, },
	[750]={ 2, 4, },
	[751]={ 2, 4, },
	[752]={ 2, 4, },
	[754]={ 2, 4, },
	[755]={ 2, 4, },
	[756]={ 2, 4, },
	[757]={ 3, },
	[759]={ 2, },
	[760]={ 2, 4, },
	[761]={ 3, },
	[762]={ 3, },
	[763]={ 2, 4, },
	[764]={ 2, 4, },
	[765]={ 2, 2, 4, 4, },
	[766]={ 2, 2, 4, 4, },
	[767]={ 2, 2, 4, 4, },
	[768]={ 2, 2, 4, 4, },
	[769]={ 2, 2, 4, 4, },
	[770]={ 2, 2, 4, 4, },
	[771]={ 2, 2, 4, 4, },
	[772]={ 2, 2, 4, 4, },
	[773]={ 2, 2, 4, 4, },
	[774]={ 2, 2, 4, 4, },
	[775]={ 2, 2, 4, 4, },
	[776]={ 2, 2, 4, 4, },
	[777]={ 2, 2, 4, 4, },
	[778]={ 2, 2, 4, 4, },
	[779]={ 2, 2, 4, 4, },
	[780]={ 2, 2, 4, 4, },
	[781]={ 2, 3, 4, },
	[782]={ 2, 3, 4, },
	[783]={ 2, 3, 4, },
	[784]={ 2, 3, 4, },
	[785]={ 3, },
	[787]={ 2, 4, },
	[788]={ 2, 4, },
	[789]={ 2, 4, },
	[790]={ 2, 4, },
	[791]={ 2, 4, },
	[792]={ 2, 4, },
	[793]={ 2, 4, },
	[794]={ 2, 4, },
	[795]={ 2, 4, },
	[796]={ 2, 4, },
	[797]={ 2, 4, },
	[798]={ 2, 4, },
	[799]={ 2, 4, },
	[800]={ 2, 4, },
	[801]={ 2, 4, },
	[802]={ 2, 4, },
	[803]={ 2, 4, },
	[804]={ 2, 4, },
	[805]={ 2, 4, },
	[812]={ 2, },
	[813]={ 4, 6, },
	[814]={ 4, 6, },
	[815]={ 4, 6, },
	[816]={ 4, 6, },
	[817]={ 4, 6, },
	[818]={ 4, 6, },
	[819]={ 4, 6, },
	[820]={ 2, 4, },
	[821]={ 2, 4, },
	[822]={ 2, 4, },
	[823]={ 2, 4, },
	[824]={ 2, 4, },
	[825]={ 2, 4, },
	[826]={ 2, 4, },
	[827]={ 2, 4, },
	[828]={ 2, 4, },
	[829]={ 2, 4, },
	[830]={ 2, 4, },
	[831]={ 2, 4, },
	[832]={ 2, 4, },
	[833]={ 2, 4, },
	[834]={ 2, 4, },
	[835]={ 2, 4, },
	[836]={ 2, 4, },
	[837]={ 2, 4, },
	[838]={ 2, 4, },
	[842]={ 3, },
	[843]={ 2, 4, },
	[844]={ 2, 4, },
	[845]={ 2, 4, },
	[846]={ 2, 4, },
	[847]={ 2, 4, },
	[848]={ 2, 4, },
	[849]={ 2, 4, },
	[850]={ 2, 4, },
	[851]={ 2, 4, },
	[852]={ 2, 4, },
	[853]={ 2, 4, },
	[854]={ 2, 4, },
	[855]={ 2, 4, },
	[856]={ 2, 4, },
	[857]={ 2, 4, },
	[858]={ 2, 4, },
	[859]={ 2, 4, },
	[860]={ 2, 4, },
	[861]={ 2, 4, },
	[862]={ 2, 4, },
	[863]={ 2, 4, },
	[864]={ 2, 4, },
	[865]={ 2, 4, },
	[866]={ 2, 4, },
	[867]={ 2, 4, },
	[868]={ 2, 4, },
	[869]={ 2, 4, },
	[870]={ 2, 4, },
	[871]={ 2, 4, },
	[872]={ 2, 4, },
	[873]={ 2, 4, },
	[874]={ 2, 4, },
	[875]={ 2, 4, },
	[876]={ 2, 4, },
	[877]={ 2, 4, },
	[878]={ 2, 4, },
	[879]={ 2, 4, },
	[880]={ 2, 4, },
	[881]={ 2, 2, },
	[882]={ 2, 2, },
	[883]={ 2, 4, },
	[884]={ 2, 4, },
	[885]={ 2, 4, },
	[886]={ 2, 4, },
	[887]={ 2, 4, },
	[888]={ 2, 4, },
	[889]={ 2, 4, },
	[890]={ 2, 4, },
	[891]={ 2, 4, },
	[892]={ 2, 4, },
	[893]={ 2, 4, },
	[894]={ 2, 4, },
	[895]={ 2, 4, },
	[896]={ 2, 4, },
	[897]={ 2, 4, },
	[898]={ 2, 4, },
	[899]={ 2, 4, },
	[900]={ 2, 4, },
	[901]={ 2, 4, },
	[908]={ 2, 3, },
	[909]={ 2, 2, 4, 4, },
	[910]={ 2, 2, 4, 4, },
	[911]={ 2, 2, 4, 4, },
	[912]={ 2, 2, 4, 4, },
	[913]={ 2, 2, 4, 4, },
	[914]={ 2, 2, 4, 4, },
	[915]={ 2, 2, 4, 4, },
	[916]={ 2, 2, 4, 4, },
	[917]={ 2, 2, 4, 4, },
	[918]={ 2, 2, 4, 4, },
	[919]={ 2, 2, 4, 4, },
	[920]={ 2, 2, 4, 4, },
	[921]={ 2, 2, 4, 4, },
	[922]={ 2, 2, 4, 4, },
	[923]={ 2, 2, 4, 4, },
	[924]={ 2, 2, 4, 4, },
	[925]={ 2, 4, },
	[926]={ 2, 4, },
	[927]={ 2, 4, },
	[928]={ 2, 4, },
	[929]={ 2, 4, },
	[930]={ 2, 4, },
	[931]={ 2, 4, },
	[932]={ 2, 4, },
	[933]={ 2, 4, },
	[934]={ 2, 4, },
	[935]={ 2, 4, },
	[936]={ 2, 4, },
	[937]={ 2, 4, },
	[938]={ 2, 4, },
	[939]={ 2, 4, },
	[940]={ 2, 4, },
	[941]={ 2, 4, },
	[942]={ 2, 4, },
	[943]={ 2, 4, },
	[944]={ 2, },
	[945]={ 2, },
	[949]={ 2, },
	[950]={ 2, },
	[951]={ 2, },
	[963]={ 2, },
	[964]={ 2, },
	[965]={ 2, },
	[966]={ 2, },
	[967]={ 2, },
	[968]={ 2, },
	[969]={ 2, },
	[970]={ 2, },
	[1000]={ 2, 4, },
	[1001]={ 2, 4, },
	[1002]={ 2, 4, },
	[1003]={ 2, 4, },
	[1004]={ 2, 4, },
	[1005]={ 2, 4, },
	[1006]={ 2, 4, },
	[1007]={ 2, 4, },
	[1008]={ 2, 4, },
	[1009]={ 2, 4, },
	[1010]={ 2, 4, },
	[1011]={ 2, 4, },
	[1012]={ 2, 4, },
	[1013]={ 2, 4, },
	[1014]={ 2, 4, },
	[1015]={ 2, 4, },
	[1016]={ 2, 4, },
	[1017]={ 2, 4, },
	[1018]={ 2, 4, },
	[1056]={ 2, 4, },
	[1057]={ 2, 4, },
	[1058]={ 2, 4, },
	[1059]={ 2, 4, },
	[1060]={ 2, 4, },
	[1061]={ 2, 4, },
	[1062]={ 2, 4, },
	[1063]={ 2, 4, },
	[1064]={ 2, 4, },
	[1065]={ 2, 4, },
	[1066]={ 2, 4, },
	[1067]={ 2, 4, },
	[1068]={ 2, 4, },
	[1069]={ 2, 4, },
	[1070]={ 2, 4, },
	[1071]={ 2, 4, },
	[1072]={ 2, 4, },
	[1073]={ 2, 4, },
	[1074]={ 2, 4, },
	[1087]={ 2, },
	[1088]={ 2, },
	[1089]={ 2, },
};
local GetItemInfoInstant = GetItemInfoInstant;
for setID, set in next, DT.ItemSet do
	local h = {  };
	for i, id in next, set do
		local _, _, _, loc, icon = GetItemInfoInstant(id);
		if h[loc] then
			h = false;
			break;
		end
		h[loc] = i;
	end
	if h then
		for loc, i in next, h do
			set[loc] = i;
		end
	end
end
