---@type Expansions
local Expansions = QuestieLoader:ImportModule("Expansions")
---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local questStateLocales = {
    ["Complete"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossen",
        ["esES"] = "Completo",
        ["esMX"] = "Completo",
        ["frFR"] = "Terminée",
        ["koKR"] = "성공",
        ["ptBR"] = "Sucesso",
        ["ruRU"] = "Выполнено",
        ["zhCN"] = "完成",
        ["zhTW"] = "完成",
    },
    ["Failed"] = {
        ["enUS"] = true,
        ["deDE"] = "Fehlgeschlagen",
        ["esES"] = "Fracasado",
        ["esMX"] = "Fracasado",
        ["frFR"] = "Échouée",
        ["koKR"] = "실패",
        ["ptBR"] = "Fracassada",
        ["ruRU"] = "Провалено",
        ["zhCN"] = "失败",
        ["zhTW"] = "失敗",
    },
    ["Available"] = {
        ["enUS"] = true,
        ["deDE"] = "Verfügbar",
        ["esES"] = "Disponible",
        ["esMX"] = "Disponible",
        ["frFR"] = "Disponible",
        ["koKR"] = "수행가능",
        ["ptBR"] = "Disponível",
        ["ruRU"] = "Доступно",
        ["zhCN"] = "可接",
        ["zhTW"] = "可接",
    },
    ["Active"] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiv",
        ["esES"] = "Activo",
        ["esMX"] = "Activo",
        ["frFR"] = "Actif",
        ["koKR"] = "활성화",
        ["ptBR"] = "Ativo",
        ["ruRU"] = "Активно",
        ["zhCN"] = "已有",
        ["zhTW"] = "已有",
    },
    ["Event"] = {
        ["enUS"] = true,
        ["deDE"] = "Event",
        ["esES"] = "Evento",
        ["esMX"] = "Evento",
        ["frFR"] = "Évènement",
        ["koKR"] = "이벤트",
        ["ptBR"] = "Evento",
        ["ruRU"] = "Игровое событие",
        ["zhCN"] = "事件",
        ["zhTW"] = "節慶",
    },
    ["Repeatable"] = {
        ["enUS"] = true,
        ["deDE"] = "Wiederholbar",
        ["esES"] = "Repetible",
        ["esMX"] = "Repetible",
        ["frFR"] = "Répétable",
        ["koKR"] = "반복가능",
        ["ptBR"] = "Repetível",
        ["ruRU"] = "Повторяемое",
        ["zhCN"] = "可重复",
        ["zhTW"] = "可重複",
    },
    ["PvP"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "JcJ",
        ["esMX"] = "JcJ",
        ["frFR"] = "JcJ",
        ["koKR"] = "전쟁",
        ["ptBR"] = "JxJ",
        ["ruRU"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
    },
    ["Rune"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Runa",
        ["esMX"] = "Runa",
        ["frFR"] = true,
        ["koKR"] = "룬",
        ["ptBR"] = "Runa",
        ["ruRU"] = "Руна",
        ["zhCN"] = "符文",
        ["zhTW"] = "符文",
    },
    ["Daily"] = {
        ["enUS"] = true,
        ["deDE"] = "Täglich",
        ["esES"] = "Diario",
        ["esMX"] = "Diario",
        ["frFR"] = "Journalier",
        ["koKR"] = "일일",
        ["ptBR"] = "Diário",
        ["ruRU"] = "Ежедневное",
        ["zhCN"] = "日常",
        ["zhTW"] = "日常",
    },
    ["Weekly"] = {
        ["enUS"] = true,
        ["deDE"] = "Wöchentlich",
        ["esES"] = "Semanal",
        ["esMX"] = "Semanal",
        ["frFR"] = "Hebdomadaire",
        ["koKR"] = "주간",
        ["ptBR"] = "Semanal",
        ["ruRU"] = "Еженедельное",
        ["zhCN"] = "每周",
        ["zhTW"] = "每周",
    },
    ["Daily Celestial"] = {
        ["enUS"] = true,
        ["deDE"] = "Täglich Himmlisch",
        ["esES"] = "Diaria Celestial",
        ["esMX"] = "Diaria Celestial",
        ["frFR"] = "Journalière Astral",
        ["koKR"] = "일일 천신",
        ["ptBR"] = "Diário Celestial",
        ["ruRU"] = "Ежедневно Небожители",
        ["zhCN"] = "日常 天神",
        ["zhTW"] = "日常 天尊",
    },
    ["Daily Account"] = {
        ["enUS"] = true,
        ["deDE"] = "Täglich Account",
        ["esES"] = "Diaria Cuenta",
        ["esMX"] = "Diaria Cuenta",
        ["frFR"] = "Journalière Compte",
        ["koKR"] = "일일 계정",
        ["ptBR"] = "Diário Conta",
        ["ruRU"] = "Ежедневно Учетная запись",
        ["zhCN"] = "日常 账号",
        ["zhTW"] = "日常 帳號",
    },
    ["Weekly Account"] = {
        ["enUS"] = true,
        ["deDE"] = "Wöchentlich Account",
        ["esES"] = "Semanal Cuenta",
        ["esMX"] = "Semanal Cuenta",
        ["frFR"] = "Chaque semaine Compte",
        ["koKR"] = "매주 계정",
        ["ptBR"] = "Semanal Conta",
        ["ruRU"] = "Раз в неделю Учетная запись",
        ["zhCN"] = "每周 账号",
        ["zhTW"] = "每周 帳號",
    },
    ["Daily Heroic"] = {
        ["enUS"] = true,
        ["deDE"] = "Täglich Heroisch",
        ["esES"] = "Diaria Heroica",
        ["esMX"] = "Diaria Heroica",
        ["frFR"] = "Journalière Héroïque",
        ["koKR"] = "일일 영웅",
        ["ptBR"] = "Diário Heroico",
        ["ruRU"] = "Ежедневно Героический",
        ["zhCN"] = "日常 英雄",
        ["zhTW"] = "日常 英雄",
    },
    ["Daily Dungeon"] = {
        ["enUS"] = true,
        ["deDE"] = "Täglich Dungeon",
        ["esES"] = "Diaria Mazmorra",
        ["esMX"] = "Diaria Calabozo",
        ["frFR"] = "Journalière Donjon",
        ["koKR"] = "일일 던전",
        ["ptBR"] = "Diário Masmorra",
        ["ruRU"] = "Ежедневно Подземелье",
        ["zhCN"] = "日常 地下城",
        ["zhTW"] = "日常 地城",
    },
    ["Heroic"] = {
        ["enUS"] = true,
        ["deDE"] = "Heroisch",
        ["esES"] = "Heroica",
        ["esMX"] = "Heroica",
        ["frFR"] = "Héroïque",
        ["koKR"] = "영웅",
        ["ptBR"] = "Heroico",
        ["ruRU"] = "Героический",
        ["zhCN"] = "英雄",
        ["zhTW"] = "英雄",
    },
    ["Celestial"] = {
        ["enUS"] = true,
        ["deDE"] = "Himmlisch",
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = "Astral",
        ["koKR"] = "천신",
        ["ptBR"] = true,
        ["ruRU"] = "Небожители",
        ["zhCN"] = "天神",
        ["zhTW"] = "天尊",
    },
    ["Scenario"] = {
        ["enUS"] = true,
        ["deDE"] = "Szenario",
        ["esES"] = "Gesta",
        ["esMX"] = "Gesta",
        ["frFR"] = "Scénario",
        ["koKR"] = "시나리오",
        ["ptBR"] = "Cenário",
        ["ruRU"] = "Сценарий",
        ["zhCN"] = "场景战役",
        ["zhTW"] = "事件",
    },
    ["Dungeon"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Mazmorra",
        ["esMX"] = "Calabozo",
        ["frFR"] = "Donjon",
        ["koKR"] = "던전",
        ["ptBR"] = "Masmorra",
        ["ruRU"] = "Подземелье",
        ["zhCN"] = "地下城",
        ["zhTW"] = "地城",
    },
    ["Elite"] = {
        ["enUS"] = (Expansions.Current == Expansions.Era and true) or "Group",
        ["deDE"] = (Expansions.Current == Expansions.Era and true) or "Gruppe",
        ["esES"] = "Élite",
        ["esMX"] = "Élite",
        ["frFR"] = (Expansions.Current == Expansions.Era and "Élite") or "Groupe",
        ["koKR"] = (Expansions.Current == Expansions.Era and "정예") or "파티",
        ["ptBR"] = (Expansions.Current == Expansions.Era and true) or "Grupo",
        ["ruRU"] = (Expansions.Current == Expansions.Era and "Элитный") or "Группа",
        ["zhCN"] = "精英",
        ["zhTW"] = (Expansions.Current == Expansions.Era and "精英") or "團體",
    },
}

for k, v in pairs(questStateLocales) do
    l10n.translations[k] = v
end
