---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

--- If you want to add something to areaIdToUiMapId overwrite the data in this table.
---@type table<AreaId, UiMapId>
ZoneDB.private.areaIdToUiMapIdOverride = [[return {
    [1583] = 253, -- Blackrock Spire - Dungeon (override wrong ID)
    [1977] = 337, -- Zul'Gurub - Dungeon (override wrong ID)
    [3428] = 320, -- Ahn'Qiraj - Raid (override wrong ID)
    [3456] = 166, -- Naxxramas - Raid (override wrong ID)
    [3979] = 113, -- The Frozen Sea/Northrend (was missing)
    [4131] = 349, -- Magisters' Terrace - Dungeon (override wrong ID)
    [4277] = 159, -- Azjol-Nerub (override wrong ID)
    [4416] = 154, -- Gundrak (override wrong ID)
    [4560] = 126, -- The Underbelly - Sub zone of Dalaran (override wrong ID)
    [6182] = 453, -- Mogu'shan Palace - (Dungeon/Raid) - base ID to -1,-1 spawns
    [6219] = 480, -- Proving Grounds - (Dungeon/Raid)
    [6471] = 453, -- Mogu'shan Palace - The Crimson Assembly Hall
    [6473] = 454, -- Mogu'shan Palace - Vaults of Kings Past
    [6474] = 455, -- Mogu'shan Palace - Throne of Ancient Conquerors

    [10000] = 281, -- Maraudon - Zaetar's Grave (fake ID for Maraudon)
    [10001] = 318, -- Stratholme - The Gauntlet (fake ID for Stratholme)
    [10002] = 243, -- Blackrock Depths - Shadowforge City (fake ID for Blackrock Depths)
    [10003] = 250, -- Blackrock Spire - Tazz'Alor (fake ID for Blackrock Spire)
    [10004] = 251, -- Blackrock Spire - Skitterweb Tunnels (fake ID for Blackrock Spire)
    [10005] = 252, -- Blackrock Spire - Hordemar City (fake ID for Blackrock Spire)
    [10006] = 254, -- Blackrock Spire - Halycon's Lair (fake ID for Blackrock Spire)
    [10007] = 255, -- Blackrock Spire - Chamber of Battle (fake ID for Blackrock Spire)
    [10008] = 303, -- Scarlet Monastery - Library (fake ID for Scarlet Monastery)
    [10009] = 304, -- Scarlet Monastery - Armory (fake ID for Scarlet Monastery)
    [10010] = 305, -- Scarlet Monastery - Cathedral (fake ID for Scarlet Monastery)
    [10011] = 307, -- Scholomance - Chamber of Summoning (fake ID for Scholomance)
    [10012] = 308, -- Scholomance - The Upper Study (fake ID for Scholomance)
    [10013] = 309, -- Scholomance - Headmaster's Study (fake ID for Scholomance)
    [10014] = 311, -- Shadowfang Keep - Dining Hall (fake ID for Shadowfang Keep)
    [10015] = 312, -- Shadowfang Keep - The Vacant Den (fake ID for Shadowfang Keep)
    [10016] = 313, -- Shadowfang Keep - Lower Observatory (fake ID for Shadowfang Keep)
    [10017] = 314, -- Shadowfang Keep - Upper Observatory (fake ID for Shadowfang Keep)
    [10018] = 315, -- Shadowfang Keep - Lord Godfrey's Chamber (fake ID for Shadowfang Keep)
    [10019] = 316, -- Shadowfang Keep - The Wall Walk (fake ID for Shadowfang Keep)
    [10020] = 222, -- Blackfathom Deeps - Dungeon - Moonshrine Sanctum
    [10021] = 223, -- Blackfathom Deeps - Dungeon - The Forgotten Pool
    [10022] = 235, -- Dire Maul - Gordok Commons (fake ID for Dire Maul North)
    [10023] = 236, -- Dire Maul - Capital Gardens (fake ID for Dire Maul West)
    [10024] = 237, -- Dire Maul - Court of the Highborne (fake ID for Dire Maul West)
    [10025] = 238, -- Dire Maul - Prison of Immol'Thar (fake ID for Dire Maul West)
    [10026] = 239, -- Dire Maul - Warpwood Quarter (fake ID for Dire Maul East)
    [10027] = 240, -- Dire Maul - The Shrine of Eldretharr (fake ID for Dire Maul East)
    [10028] = 348, -- Magisters' Terrace - Grand Magister's Asylum (fake ID for Magisters' Terrace)
    [10029] = 292, -- The Deadmines - Dungeon - Ironclad Cove (fake ID for The Deadmines)
    [10030] = 227, -- Gnomeregan - Dungeon - The Dormitory
    [10031] = 228, -- Gnomeregan - Dungeon - Launch Bay
    [10032] = 229, -- Gnomeregan - Dungeon - Tinkers' Court
    [10033] = 231, -- Uldaman - Dungeon - Khaz'Goroth's Seat
    [10039] = 400, -- Hour of Twilight - Wyrmrest Temple
    [10040] = 319, -- Ahn'Qiraj - Raid - The Hive Undergrounds
    [10041] = 321, -- Ahn'Qiraj - Raid - Vault of C'thun
    [10042] = 259, -- Sethekk Halls - Dungeon - Halls of Mourning
    [10043] = 257, -- Auchenai Crypts - Dungeon - Bridge of Souls
    [10044] = 268, -- The Mechanar - Dungeon - Calculation Chamber
    [10045] = 270, -- The Arcatraz - Dungeon - Stasis Block: Maximus
    [10046] = 271, -- The Arcatraz - Dungeon - Containment Core
    [10047] = 144, -- The Oculus - Band of Acceleration (fake ID for The Oculus)
    [10048] = 145, -- The Oculus - Band of Transmutation (fake ID for The Oculus)
    [10049] = 146, -- The Oculus - Band of Alignment (fake ID for The Oculus)
    [10050] = 150, -- Ulduar - The Descent of Madness (fake ID for Ulduar)
    [10051] = 151, -- Ulduar - The Spark of Imagination (fake ID for Ulduar)
    [10052] = 149, -- Ulduar - The Inner Sanctum of Ulduar (fake ID for Ulduar)
    [10053] = 136, -- Utgarde Pinnacle - Lower Level (fake ID for Utgarde Pinnacle)
    [10054] = 139, -- Halls of Lightning - The Terrestrial Watchtower (fake ID for Halls of Lightning)
    [10055] = 157, -- Azjol-Nerub - The Brood Pit (fake ID for Azjol-Nerub)
    [10056] = 158, -- Azjol-Nerub - Hadronox's Lair (fake ID for Azjol-Nerub)
    [10057] = 134, -- Utgarde Keep - Middle Level (fake ID for Utgarde Keep)
    [10058] = 135, -- Utgarde Keep - Upper Level (fake ID for Utgarde Keep)
    [10059] = 131, -- The Culling of Stratholme - City (fake ID for The Culling of Stratholme)
    [10060] = 161, -- Drak'Tharon Keep - Upper Level (fake ID for Drak'Tharon Keep)
    [10061] = 153, -- Gundrak - Lower Level (fake ID for Gundrak) -- does not exist in Cata+
    [10062] = 162, -- Naxxramas - Construct Quarter (fake ID for Naxxramas)
    [10063] = 163, -- Naxxramas - Arachnid Quarter (fake ID for Naxxramas)
    [10064] = 164, -- Naxxramas - Military Quarter (fake ID for Naxxramas)
    [10065] = 165, -- Naxxramas - Plague Quarter (fake ID for Naxxramas)
    [10066] = 167, -- Naxxramas - Frostwyrm Lair (fake ID for Naxxramas)
    [10067] = 190, -- Icecrown Citadel - Upper Spire (fake ID for ICC)
    [10068] = 191, -- Icecrown Citadel - Queen Lana'thel (fake ID for ICC)
    [10069] = 189, -- Icecrown Citadel - Sindragosa (fake ID for ICC)
    [10070] = 187, -- Icecrown Citadel - Rampart of Skulls (fake ID for ICC)
    [10071] = 188, -- Icecrown Citadel - Deathbringer's Rise (fake ID for ICC)
    [10072] = 192, -- Icecrown Citadel - The Frozen Throne (fake ID for ICC)
    [10073] = 12, -- Kalimdor - the continent map
    [10074] = 13, -- Eastern Kingdoms - the continent map
    [10075] = 424, -- Pandaria - the continent map
    [10076] = 432, -- Scarlet Halls - Athenaeum
    [10077] = 477, -- Scholomance - Chamber of Summoning (fake ID for Scholomance MoP)
    [10078] = 478, -- Scholomance - The Upper Study (fake ID for Scholomance MoP)
    [10079] = 479, -- Scholomance - Headmaster's Study (fake ID for Scholomance MoP)
    [10080] = 396, -- Guo-Lai Halls - The Hall of the Serpent (fake ID cave in Vale of Eternal Blossoms)
    [10081] = 373, -- Greenstone Quarry Lower Quarry(fake ID cave in The Jade Forest)
    [10082] = 392, -- Shrine of Two Moons - The Imperial Mercantile - Top Floor
    [10083] = 394, -- Shrine of Seven Stars - The Imperial Exchange - Top Floor
    [10084] = 384, -- The Deeper - Lower Deep (fake ID cave in Kun-Lai Summit)
    [10085] = 420, -- Ruins of Ogudei (fake ID cave in Krasarang Wilds)
    [10086] = 421, -- Ruins of Ogudei - Reliquary Incursion (fake ID cave in Krasarang Wilds)
    [10087] = 387, -- Crypt of Korune - Ruins of Korune (fake ID cave in Kun-Lai Summit)
    [10088] = 502, -- Dalaran - Underbelly (Landfall version)
    [10089] = 947, -- Azeroth - the world map
}]]

--- This table is generated by the generate_zone_tables.py script - use the table above to add new entries.
--- This table maps the areaId (used in the DB for example) to the UiMapId of each zone.
--- The UiMapId identifies a map which can be displayed ingame on the worldmap.
--- https://wow.gamepedia.com/UiMapID/Classic
---@type table<AreaId, UiMapId>
ZoneDB.private.areaIdToUiMapId = [[return {
    [1] = 27, -- Dun Morogh
    [3] = 15, -- Badlands
    [4] = 17, -- Blasted Lands
    [8] = 51, -- Swamp of Sorrows
    [10] = 47, -- Duskwood
    [11] = 56, -- Wetlands
    [12] = 37, -- Elwynn Forest
    [14] = 1, -- Durotar
    [15] = 70, -- Dustwallow Marsh
    [16] = 76, -- Azshara
    [17] = 10, -- The Barrens
    [25] = 33, -- Blackrock Mountain
    [28] = 22, -- Western Plaguelands
    [33] = 50, -- Northern Stranglethorn
    [34] = 426, -- Echo Ridge Mine
    [38] = 48, -- Loch Modan
    [40] = 52, -- Westfall
    [41] = 42, -- Deadwind Pass
    [44] = 49, -- Redridge Mountains
    [45] = 14, -- Arathi Highlands
    [46] = 36, -- Burning Steppes
    [47] = 26, -- The Hinterlands
    [51] = 32, -- Searing Gorge
    [54] = 40, -- Jasperlode Mine
    [57] = 38, -- Fargodeep Mine
    [65] = 115, -- Dragonblight
    [66] = 121, -- Zul'Drak
    [67] = 120, -- The Storm Peaks
    [85] = 18, -- Tirisfal Glades
    [111] = 54, -- Jangolode Mine
    [113] = 53, -- Gold Coast Quarry
    [130] = 21, -- Silverpine Forest
    [133] = 30, -- New Tinkertown
    [134] = 31, -- Gol'Bolar Quarry
    [135] = 470, -- Frostmane Hold
    [136] = 29, -- The Grizzled Den
    [139] = 23, -- Eastern Plaguelands
    [141] = 57, -- Teldrassil
    [148] = 62, -- Darkshore
    [155] = 466, -- Night Web's Hollow
    [206] = 133, -- Utgarde Keep - (Dungeon/Raid)
    [209] = 310, -- Shadowfang Keep - (Dungeon/Raid)
    [210] = 118, -- Icecrown
    [215] = 7, -- Mulgore
    [236] = 310, -- Shadowfang Keep - (Dungeon/Raid)
    [254] = 33, -- Blackrock Mountain
    [257] = 58, -- Shadowthread Cave
    [258] = 59, -- Fel Rock
    [262] = 60, -- Ban'ethil Barrow Den
    [267] = 25, -- Hillsbrad Foothills
    [331] = 63, -- Ashenvale
    [357] = 69, -- Feralas
    [360] = 9, -- The Venture Co. Mine
    [361] = 77, -- Felwood
    [365] = 2, -- Burning Blade Coven
    [371] = 6, -- Dustwind Cave
    [372] = 3, -- Tiragarde Keep
    [394] = 116, -- Grizzly Hills
    [400] = 64, -- Thousand Needles
    [405] = 66, -- Desolace
    [406] = 65, -- Stonetalon Mountains
    [440] = 71, -- Tanaris
    [490] = 78, -- Un'Goro Crater
    [491] = 301, -- Razorfen Kraul - (Dungeon/Raid)
    [493] = 80, -- Moonglade
    [495] = 117, -- Howling Fjord
    [540] = 79, -- The Slithering Scar
    [616] = 198, -- Mount Hyjal
    [618] = 83, -- Winterspring
    [676] = 1467, -- Outland
    [717] = 225, -- The Stockade - (Dungeon/Raid)
    [718] = 11, -- Wailing Caverns
    [719] = 221, -- Blackfathom Deeps - (Dungeon/Raid)
    [721] = 226, -- Gnomeregan - (Dungeon/Raid)
    [722] = 300, -- Razorfen Downs - (Dungeon/Raid)
    [796] = 302, -- Scarlet Monastery - (Dungeon/Raid)
    [800] = 28, -- Coldridge Pass
    [817] = 5, -- Skull Rock
    [818] = 8, -- Palemane Rock
    [981] = 73, -- The Gaping Chasm
    [982] = 72, -- The Noxious Lair
    [1037] = 293, -- Grim Batol - (Dungeon/Raid)
    [1176] = 219, -- Zul'Farrak
    [1196] = 136, -- Utgarde Pinnacle - (Dungeon/Raid)
    [1337] = 16, -- Uldaman
    [1377] = 81, -- Silithus
    [1445] = 33, -- Blackrock Mountain
    [1477] = 220, -- The Temple of Atal'Hakkar - (Dungeon/Raid)
    [1497] = 998, -- Undercity
    [1517] = 16, -- Uldaman
    [1519] = 84, -- Stormwind City
    [1537] = 87, -- Ironforge
    [1581] = 55, -- The Deadmines
    [1583] = 250, -- Blackrock Spire - (Dungeon/Raid)
    [1584] = 242, -- Blackrock Depths - (Dungeon/Raid)
    [1637] = 85, -- Orgrimmar
    [1638] = 88, -- Thunder Bluff
    [1657] = 89, -- Darnassus
    [1717] = 301, -- Razorfen Kraul - (Dungeon/Raid)
    [1941] = 74, -- Caverns of Time
    [2017] = 317, -- Stratholme - (Dungeon/Raid)
    [2057] = 306, -- ScholomanceOLD - (Dungeon/Raid)
    [2100] = 67, -- Maraudon
    [2159] = 248, -- Onyxia's Lair - (Dungeon/Raid)
    [2257] = 499, -- Deeprun Tram - (Dungeon/Raid)
    [2279] = 317, -- Stratholme - (Dungeon/Raid)
    [2300] = 74, -- Caverns of Time
    [2366] = 273, -- The Black Morass
    [2367] = 274, -- Old Hillsbrad Foothills
    [2437] = 213, -- Ragefire Chasm - (Dungeon/Raid)
    [2557] = 234, -- Dire Maul
    [2562] = 350, -- Karazhan - (Dungeon/Raid)
    [2577] = 235, -- Dire Maul - (Dungeon/Raid)
    [2597] = 91, -- Alterac Valley
    [2677] = 287, -- Blackwing Lair - (Dungeon/Raid)
    [2717] = 232, -- Molten Core - (Dungeon/Raid)
    [2797] = 221, -- Blackfathom Deeps - (Dungeon/Raid)
    [2817] = 127, -- Crystalsong Forest
    [3277] = 92, -- Warsong Gulch
    [3358] = 93, -- Arathi Basin
    [3428] = 319, -- Ahn'Qiraj - (Dungeon/Raid)
    [3429] = 247, -- Ruins of Ahn'Qiraj
    [3430] = 94, -- Eversong Woods
    [3433] = 95, -- Ghostlands
    [3446] = 82, -- Twilight's Run
    [3456] = 162, -- Naxxramas - (Dungeon/Raid)
    [3457] = 350, -- Karazhan - (Dungeon/Raid)
    [3477] = 157, -- Azjol-Nerub - (Dungeon/Raid)
    [3483] = 100, -- Hellfire Peninsula
    [3487] = 110, -- Silvermoon City
    [3510] = 96, -- Amani Catacombs
    [3518] = 107, -- Nagrand
    [3519] = 108, -- Terokkar Forest
    [3520] = 104, -- Shadowmoon Valley
    [3521] = 102, -- Zangarmarsh
    [3522] = 105, -- Blade's Edge Mountains
    [3523] = 109, -- Netherstorm
    [3524] = 97, -- Azuremyst Isle
    [3525] = 106, -- Bloodmyst Isle
    [3537] = 114, -- Borean Tundra
    [3557] = 103, -- The Exodar
    [3562] = 347, -- Hellfire Ramparts - (Dungeon/Raid)
    [3569] = 98, -- Tides' Hollow
    [3572] = 99, -- Stillpine Hold
    [3606] = 329, -- Hyjal Summit
    [3607] = 332, -- Serpentshrine Cavern - (Dungeon/Raid)
    [3618] = 330, -- Gruul's Lair - (Dungeon/Raid)
    [3703] = 111, -- Shattrath City
    [3711] = 119, -- Sholazar Basin
    [3713] = 261, -- The Blood Furnace - (Dungeon/Raid)
    [3714] = 246, -- The Shattered Halls - (Dungeon/Raid)
    [3715] = 263, -- The Steamvault - (Dungeon/Raid)
    [3716] = 262, -- The Underbog - (Dungeon/Raid)
    [3717] = 265, -- The Slave Pens - (Dungeon/Raid)
    [3774] = 330, -- Gruul's Lair - (Dungeon/Raid)
    [3789] = 260, -- Shadow Labyrinth - (Dungeon/Raid)
    [3790] = 256, -- Auchenai Crypts - (Dungeon/Raid)
    [3791] = 258, -- Sethekk Halls - (Dungeon/Raid)
    [3792] = 272, -- Mana-Tombs - (Dungeon/Raid)
    [3805] = 333, -- Zul'Aman
    [3820] = 112, -- Eye of the Storm
    [3836] = 331, -- Magtheridon's Lair - (Dungeon/Raid)
    [3842] = 334, -- Tempest Keep - (Dungeon/Raid)
    [3845] = 334, -- Tempest Keep - (Dungeon/Raid)
    [3846] = 269, -- The Arcatraz - (Dungeon/Raid)
    [3847] = 266, -- The Botanica - (Dungeon/Raid)
    [3848] = 269, -- The Arcatraz - (Dungeon/Raid)
    [3849] = 267, -- The Mechanar - (Dungeon/Raid)
    [3923] = 330, -- Gruul's Lair - (Dungeon/Raid)
    [3959] = 339, -- Black Temple - (Dungeon/Raid)
    [3983] = 133, -- Utgarde Keep - (Dungeon/Raid)
    [4075] = 335, -- Sunwell Plateau - (Dungeon/Raid)
    [4080] = 122, -- Isle of Quel'Danas
    [4094] = 336, -- Sunwell Plateau - (Dungeon/Raid)
    [4095] = 348, -- Magisters' Terrace - (Dungeon/Raid)
    [4100] = 130, -- The Culling of Stratholme - (Dungeon/Raid)
    [4120] = 129, -- The Nexus - (Dungeon/Raid)
    [4131] = 348, -- Magisters' Terrace - (Dungeon/Raid)
    [4196] = 160, -- Drak'Tharon Keep - (Dungeon/Raid)
    [4197] = 123, -- Wintergrasp
    [4210] = 160, -- Drak'Tharon Keep - (Dungeon/Raid)
    [4228] = 143, -- The Oculus
    [4234] = 162, -- Naxxramas - (Dungeon/Raid)
    [4264] = 140, -- Halls of Stone - (Dungeon/Raid)
    [4265] = 129, -- The Nexus - (Dungeon/Raid)
    [4271] = 136, -- Utgarde Pinnacle - (Dungeon/Raid)
    [4272] = 138, -- Halls of Lightning - (Dungeon/Raid)
    [4273] = 147, -- Ulduar - (Dungeon/Raid)
    [4277] = 157, -- Azjol-Nerub - (Dungeon/Raid)
    [4298] = 124, -- Plaguelands: The Scarlet Enclave
    [4309] = 160, -- Drak'Tharon Keep - (Dungeon/Raid)
    [4375] = 154, -- Gundrak - (Dungeon/Raid)
    [4384] = 128, -- Strand of the Ancients
    [4395] = 125, -- Dalaran - (Dungeon/Raid)
    [4415] = 168, -- The Violet Hold - (Dungeon/Raid)
    [4416] = 153, -- Gundrak
    [4445] = 148, -- Ulduar - (Dungeon/Raid)
    [4493] = 155, -- The Obsidian Sanctum
    [4494] = 132, -- Ahn'kahet: The Old Kingdom - (Dungeon/Raid)
    [4500] = 141, -- The Eye of Eternity - (Dungeon/Raid)
    [4522] = 186, -- Icecrown Citadel - (Dungeon/Raid)
    [4547] = 140, -- Halls of Stone - (Dungeon/Raid)
    [4548] = 138, -- Halls of Lightning - (Dungeon/Raid)
    [4567] = 168, -- The Violet Hold - (Dungeon/Raid)
    [4603] = 156, -- Vault of Archavon - (Dungeon/Raid)
    [4635] = 160, -- Drak'Tharon Keep - (Dungeon/Raid)
    [4706] = 217, -- Ruins of Gilneas
    [4709] = 199, -- Southern Barrens
    [4710] = 169, -- Isle of Conquest
    [4714] = 179, -- Gilneas
    [4720] = 174, -- The Lost Isles
    [4722] = 172, -- Trial of the Crusader - (Dungeon/Raid)
    [4723] = 171, -- Trial of the Champion - (Dungeon/Raid)
    [4732] = 180, -- Emberstone Mine
    [4737] = 194, -- Kezan
    [4742] = 170, -- Hrothgar's Landing
    [4755] = 202, -- Gilneas City
    [4766] = 195, -- Kaja'mine
    [4778] = 175, -- Kaja'mite Cavern
    [4809] = 183, -- The Forge of Souls - (Dungeon/Raid)
    [4812] = 186, -- Icecrown Citadel - (Dungeon/Raid)
    [4813] = 184, -- Pit of Saron
    [4815] = 201, -- Kelp'thar Forest
    [4817] = 181, -- Greymane Manor
    [4820] = 185, -- Halls of Reflection - (Dungeon/Raid)
    [4911] = 176, -- Volcanoth's Lair
    [4913] = 464, -- Spitescale Cavern
    [4922] = 241, -- Twilight Highlands
    [4924] = 177, -- Gallywix Labor Mine
    [4926] = 283, -- Blackrock Caverns - (Dungeon/Raid)
    [4945] = 297, -- Halls of Origination - (Dungeon/Raid)
    [4950] = 293, -- Grim Batol - (Dungeon/Raid)
    [4987] = 200, -- The Ruby Sanctum
    [5004] = 322, -- Throne of the Tides - (Dungeon/Raid)
    [5031] = 206, -- Twin Peaks
    [5034] = 249, -- Uldum
    [5035] = 325, -- The Vortex Pinnacle - (Dungeon/Raid)
    [5042] = 207, -- Deepholm
    [5088] = 324, -- The Stonecore - (Dungeon/Raid)
    [5092] = 300, -- Razorfen Downs - (Dungeon/Raid)
    [5094] = 285, -- Blackwing Descent - (Dungeon/Raid)
    [5095] = 244, -- Tol Barad
    [5144] = 205, -- Shimmering Expanse
    [5145] = 204, -- Abyssal Depths
    [5146] = 203, -- Vashj'ir
    [5166] = 86, -- Orgrimmar
    [5287] = 210, -- The Cape of Stranglethorn
    [5334] = 294, -- The Bastion of Twilight - (Dungeon/Raid)
    [5339] = 224, -- Stranglethorn Vale
    [5351] = 218, -- Ruins of Gilneas City
    [5389] = 245, -- Tol Barad Peninsula
    [5396] = 277, -- Lost City of the Tol'vir
    [5399] = 282, -- Baradin Hold - (Dungeon/Raid)
    [5416] = 276, -- The Maelstrom
    [5449] = 275, -- The Battle for Gilneas
    [5495] = 226, -- Gnomeregan - (Dungeon/Raid)
    [5511] = 19, -- Scarlet Monastery Entrance
    [5600] = 282, -- Baradin Hold - (Dungeon/Raid)
    [5638] = 328, -- Throne of the Four Winds - (Dungeon/Raid)
    [5684] = 328, -- Throne of the Four Winds - (Dungeon/Raid)
    [5695] = 327, -- Ahn'Qiraj: The Fallen Kingdom
    [5723] = 367, -- Firelands - (Dungeon/Raid)
    [5729] = 285, -- Blackwing Descent - (Dungeon/Raid)
    [5732] = 297, -- Halls of Origination - (Dungeon/Raid)
    [5733] = 338, -- Molten Front
    [5736] = 378, -- The Wandering Isle
    [5785] = 371, -- The Jade Forest
    [5786] = 129, -- The Nexus - (Dungeon/Raid)
    [5788] = 398, -- Well of Eternity
    [5789] = 401, -- End Time - (Dungeon/Raid)
    [5790] = 403, -- End Time - (Dungeon/Raid)
    [5792] = 404, -- End Time - (Dungeon/Raid)
    [5793] = 402, -- End Time - (Dungeon/Raid)
    [5794] = 405, -- End Time - (Dungeon/Raid)
    [5795] = 406, -- End Time - (Dungeon/Raid)
    [5799] = 397, -- Eye of the Storm
    [5805] = 376, -- Valley of the Four Winds
    [5818] = 369, -- Firelands - (Dungeon/Raid)
    [5840] = 390, -- Vale of Eternal Blossoms
    [5841] = 379, -- Kun-Lai Summit
    [5842] = 388, -- Townlong Steppes
    [5844] = 399, -- Hour of Twilight - (Dungeon/Raid)
    [5861] = 407, -- Darkmoon Island
    [5892] = 409, -- Dragon Soul - (Dungeon/Raid)
    [5918] = 443, -- Shado-Pan Monastery - (Dungeon/Raid)
    [5955] = 372, -- Greenstone Quarry
    [5956] = 429, -- Temple of the Jade Serpent - (Dungeon/Raid)
    [5963] = 439, -- Stormstout Brewery - (Dungeon/Raid)
    [5975] = 429, -- Temple of the Jade Serpent - (Dungeon/Raid)
    [5976] = 437, -- Gate of the Setting Sun - (Dungeon/Raid)
    [6001] = 439, -- Stormstout Brewery - (Dungeon/Raid)
    [6006] = 433, -- The Veiled Stair
    [6040] = 416, -- Dustwallow Marsh
    [6051] = 417, -- Temple of Kotmogu
    [6052] = 431, -- Scarlet Halls - (Dungeon/Raid)
    [6066] = 476, -- Scholomance - (Dungeon/Raid)
    [6067] = 456, -- Terrace of Endless Spring
    [6074] = 395, -- Guo-Lai Halls
    [6084] = 383, -- The Deeper
    [6088] = 382, -- Knucklethump Hole
    [6099] = 381, -- Pranksters' Hollow
    [6101] = 447, -- A Brewing Storm
    [6125] = 471, -- Mogu'shan Vaults - (Dungeon/Raid)
    [6126] = 423, -- Silvershard Mines - (Dungeon/Raid)
    [6134] = 418, -- Krasarang Wilds
    [6137] = 428, -- Frostmane Hovel
    [6138] = 422, -- Dread Wastes
    [6141] = 391, -- Shrine of Two Moons
    [6142] = 393, -- Shrine of Seven Stars
    [6170] = 425, -- Northshire
    [6173] = 444, -- Shado-Pan Monastery - (Dungeon/Raid)
    [6176] = 427, -- Coldridge Valley
    [6201] = 385, -- Tomb of Conquerors
    [6208] = 481, -- Crypt of Forgotten Kings - (Dungeon/Raid)
    [6209] = 448, -- The Jade Forest
    [6213] = 389, -- Niuzao Catacombs
    [6214] = 457, -- Siege of Niuzao Temple - (Dungeon/Raid)
    [6297] = 474, -- Heart of Fear - (Dungeon/Raid)
    [6298] = 503, -- Brawl'gar Arena - (Dungeon/Raid)
    [6309] = 450, -- Unga Ingoo
    [6328] = 451, -- Assault on Zan'vess
    [6376] = 434, -- The Ancient Passage
    [6384] = 435, -- Scarlet Monastery - (Dungeon/Raid)
    [6386] = 436, -- Scarlet Monastery - (Dungeon/Raid)
    [6389] = 380, -- Howlingwind Cavern
    [6396] = 437, -- Gate of the Setting Sun - (Dungeon/Raid)
    [6426] = 452, -- Brewmoon Festival
    [6428] = 434, -- The Ancient Passage
    [6435] = 474, -- Heart of Fear - (Dungeon/Raid)
    [6449] = 449, -- Temple of Kotmogu
    [6450] = 460, -- Shadowglen
    [6451] = 461, -- Valley of Trials
    [6452] = 462, -- Camp Narache
    [6453] = 463, -- Echo Isles
    [6454] = 465, -- Deathknell
    [6455] = 467, -- Sunstrider Isle
    [6456] = 468, -- Ammen Vale
    [6457] = 469, -- New Tinkertown
    [6466] = 377, -- Cavern of Endless Echoes
    [6500] = 483, -- Dustwallow Marsh
    [6507] = 504, -- Isle of Thunder
    [6510] = 55, -- The Deadmines
    [6511] = 11, -- Wailing Caverns
    [6512] = 374, -- The Widow's Wail
    [6513] = 375, -- Oona Kagu
    [6514] = 67, -- Maraudon
    [6553] = 393, -- Shrine of Seven Stars
    [6565] = 488, -- Dagger in the Dark
    [6567] = 524, -- Battle on the High Seas
    [6575] = 486, -- Krasarang Wilds
    [6589] = 505, -- Lightning Vein Mine
    [6592] = 506, -- The Swollen Vault
    [6609] = 419, -- Ruins of Ogudei
    [6610] = 434, -- The Ancient Passage
    [6611] = 501, -- Dalaran - Landfall version
    [6613] = 340, -- Black Temple - (Dungeon/Raid)
    [6615] = 498, -- Krasarang Wilds
    [6616] = 487, -- A Little Patience
    [6618] = 500, -- Bizmo's Brawlpub
    [6619] = 386, -- Ruins of Korune
    [6622] = 508, -- Throne of Thunder - (Dungeon/Raid)
    [6636] = 168, -- The Violet Hold - (Dungeon/Raid)
    [6651] = 521, -- Vale of Eternal Blossoms - (Dungeon/Raid)
    [6661] = 507, -- Isle of Giants
    [6665] = 519, -- Deepwind Gorge
    [6677] = 516, -- Isle of Thunder
    [6678] = 523, -- Dun Morogh
    [6707] = 518, -- Thunder King's Citadel - (Dungeon/Raid)
    [6716] = 518, -- Thunder King's Citadel - (Dungeon/Raid)
    [6731] = 522, -- The Secrets of Ragefire - (Dungeon/Raid)
    [6733] = 520, -- Vale of Eternal Blossoms
    [6738] = 556, -- Siege of Orgrimmar - (Dungeon/Raid)
    [6757] = 554, -- Timeless Isle
    [6771] = 571, -- Celestial Tournament
    [6780] = 555, -- Cavern of Lost Spirits
    [6852] = 480, -- Proving Grounds - (Dungeon/Raid)
    [14288] = 2104, -- Wintergrasp
    [14334] = 186, -- Icecrown Citadel - (Dungeon/Raid)
    [15306] = 244, -- Tol Barad
    [15318] = 282, -- Baradin Hold - (Dungeon/Raid)
}]]
