﻿
	----------------------------------------------------------------------
	-- Leatrix Maps Reveal Data
	----------------------------------------------------------------------

	local void, Leatrix_Maps = ...
	local L = Leatrix_Maps.L

	Leatrix_Maps["Reveal"] = {

		----------------------------------------------------------------------
		-- World of Warcraft
		----------------------------------------------------------------------

		--[[1411: Durotar]]					[1194] = {["128:110:464:33"] = "271427", ["160:120:413:476"] = "2212659", ["160:190:474:384"] = "271426", ["190:180:462:286"] = "271440", ["190:200:327:60"] = "271439", ["200:240:549:427"] = "271437", ["210:160:427:78"] = "271428", ["215:215:355:320"] = "271443", ["220:230:432:170"] = "271421", ["230:230:301:189"] = "271422", ["445:160:244:0"] = "271435, 271442",},
		--[[1412: Mulgore]]					[1200] = {["128:120:473:260"] = "272185", ["128:155:379:242"] = "272178", ["128:205:303:307"] = "272176", ["170:128:458:369"] = "272180", ["185:128:291:0"] = "272172", ["205:128:395:0"] = "272179", ["205:230:502:16"] = "272169", ["210:180:255:214"] = "272181", ["215:240:428:80"] = "272177", ["225:235:532:238"] = "272186", ["256:190:523:356"] = "272170", ["256:200:367:303"] = "272173", ["280:240:249:59"] = "272187, 272171", ["470:243:270:425"] = "272168, 272165",},
		--[[1413: The Barrens]]				[1202] = {["100:165:564:52"] = "270569", ["115:110:507:294"] = "852702", ["120:110:555:0"] = "270553", ["120:125:384:115"] = "270560", ["125:115:492:63"] = "270584", ["125:125:556:189"] = "270585", ["125:165:442:298"] = "852696", ["128:100:412:0"] = "852705", ["128:105:419:63"] = "270554", ["128:128:306:130"] = "852699", ["128:128:341:537"] = "852704", ["128:128:431:479"] = "852694", ["140:128:498:119"] = "270574", ["145:125:365:350"] = "852697", ["150:120:527:307"] = "852701", ["155:115:407:553"] = "852703", ["155:128:335:462"] = "852695", ["155:128:481:211"] = "270565", ["155:155:431:118"] = "270559", ["170:120:456:0"] = "270564", ["175:185:365:177"] = "852700", ["200:145:317:29"] = "270572", ["200:185:340:234"] = "852693", ["210:150:355:402"] = "852698", ["95:100:581:247"] = "270573",},

		--[[1416: Alterac Mountains]]		[1205] = {["160:175:225:478"] = "768731", ["165:197:314:471"] = "768752", ["190:170:317:372"] = "768732", ["195:288:399:380"] = "768721, 768722", ["200:200:406:279"] = "768730", ["220:280:196:131"] = "768738, 769205", ["235:200:462:77"] = "768753", ["255:255:270:197"] = "768739", ["255:320:462:307"] = "768744, 768745", ["280:240:334:162"] = "768723, 769200", ["285:230:276:0"] = "768728, 768729", ["300:300:26:262"] = "769201, 769202, 769203, 769204", ["330:265:44:403"] = "768734, 768735, 768736, 768737", ["350:370:626:253"] = "768717, 768718, 768719, 768720", ["370:300:549:105"] = "768748, 768749, 768750, 768751",},
		--[[1417: Arathi Highlands]]		[1206] = {["160:230:558:112"] = "270360", ["170:155:419:293"] = "2212546", ["175:225:370:186"] = "270352", ["180:210:472:165"] = "270350", ["190:210:138:54"] = "270347", ["190:240:87:138"] = "2212539", ["200:220:355:412"] = "270348", ["205:250:655:120"] = "270336", ["210:185:286:310"] = "270346", ["215:210:559:333"] = "270353", ["215:235:432:362"] = "270342", ["230:195:531:276"] = "270343", ["230:240:192:90"] = "270351", ["240:230:108:287"] = "270358", ["245:245:232:145"] = "270349", ["256:215:171:424"] = "270361",},
		--[[1418: Badlands]]				[1207] = {["195:200:325:148"] = "270543", ["200:195:445:120"] = "270532", ["220:220:551:48"] = "270530", ["230:230:349:256"] = "2212608", ["245:205:389:7"] = "2212606", ["245:205:498:209"] = "2212592", ["255:280:501:341"] = "270540, 270527", ["256:256:0:148"] = "2212593", ["256:256:12:428"] = "270520", ["256:256:148:384"] = "2212599", ["256:256:17:310"] = "270529", ["265:270:345:389"] = "270522, 270550, 270528, 270536", ["270:275:159:199"] = "270525, 270521, 2212603, 2212605", ["370:455:611:110"] = "270534, 270551, 270546, 270535",},
		--[[1419: Blasted Lands]]			[1209] = {["170:145:405:123"] = "391431", ["170:200:472:9"] = "391433", ["185:155:310:133"] = "391425", ["185:190:559:30"] = "391432", ["195:180:361:15"] = "391435", ["225:170:501:140"] = "391430", ["245:195:361:195"] = "391434", ["265:220:453:259"] = "391437, 391436", ["384:450:212:178"] = "391429, 391428, 391427, 391426",},
		--[[1420: Tirisfal Glades]]			[1210] = {["128:256:537:299"] = "273015", ["150:128:474:327"] = "273016", ["173:128:694:289"] = "273000", ["174:220:497:145"] = "273020", ["175:247:689:104"] = "272996", ["186:128:395:277"] = "2213434", ["201:288:587:139"] = "273009, 273002", ["211:189:746:125"] = "2213425", ["216:179:630:326"] = "273006", ["230:205:698:362"] = "2213418", ["237:214:757:205"] = "272999", ["243:199:363:349"] = "273003", ["245:205:227:328"] = "273001", ["256:156:239:250"] = "273017", ["256:210:335:139"] = "273019", ["315:235:463:361"] = "2213428, 2213430",},
		--[[1421: Silverpine Forest]]		[1211] = {["140:125:391:446"] = "2213067", ["160:170:470:261"] = "272598", ["165:185:382:252"] = "272616", ["175:165:402:65"] = "2213080", ["180:128:323:128"] = "2213065", ["180:185:457:144"] = "2213082", ["185:165:286:37"] = "272610", ["210:160:352:168"] = "272620", ["210:215:379:447"] = "272609", ["220:160:364:359"] = "272613", ["240:180:491:417"] = "272599", ["240:240:494:262"] = "272614", ["250:215:593:74"] = "272600", ["256:160:465:0"] = "2213063", ["256:220:459:13"] = "2213084",},
		--[[1422: Western Plaguelands]]		[1212] = {["160:125:300:311"] = "273113", ["160:200:566:198"] = "273121", ["170:165:600:412"] = "273107", ["170:190:451:323"] = "273102", ["180:205:520:250"] = "273094", ["205:340:590:86"] = "273122, 273103", ["220:150:381:265"] = "2212523", ["220:180:382:164"] = "273114", ["225:185:137:293"] = "273120", ["285:230:260:355"] = "2212522, 2212521", ["300:206:355:462"] = "273108, 273101", ["340:288:307:16"] = "273095, 273111, 273100, 273090", ["370:270:504:343"] = "273119, 273092, 273112, 273093",},
		--[[1423: Eastern Plaguelands]]		[1213] = {["256:179:279:467"] = "271514", ["256:191:142:455"] = "271512", ["256:197:687:449"] = "271553", ["256:205:474:412"] = "271532", ["256:243:164:0"] = "271529", ["256:256:126:338"] = "271551", ["256:256:241:239"] = "271536", ["256:256:261:379"] = "271548", ["256:256:379:323"] = "271543", ["256:256:392:14"] = "271535", ["256:256:412:177"] = "271523", ["256:256:427:87"] = "271521", ["256:256:471:345"] = "271544", ["256:256:49:76"] = "271522", ["256:256:562:219"] = "271542", ["256:256:584:8"] = "271554", ["256:256:590:106"] = "271520", ["256:256:656:277"] = "271533", ["256:256:692:144"] = "271537", ["256:288:590:269"] = "2212700, 4357862", ["256:384:0:209"] = "2212705, 2212706", ["284:450:718:218"] = "4357864, 4357866, 4357868, 4357870", ["384:288:139:61"] = "271518, 271527, 2212703, 2212704",},
		--[[1424: Hillsbrad Foothills]]		[1214] = {["125:100:109:482"] = "271904", ["165:200:175:275"] = "2212736", ["205:155:414:154"] = "271897", ["215:240:541:236"] = "2212742", ["220:310:509:0"] = "271894, 2212744", ["230:320:524:339"] = "2212737, 2212738", ["235:270:418:201"] = "271905, 2212743", ["240:275:637:294"] = "271885, 271877", ["285:155:208:368"] = "2212746, 2212747", ["288:225:2:192"] = "271876, 271881", ["305:275:198:155"] = "271883, 271892, 2212739, 2212740", ["384:365:605:75"] = "271872, 271898, 271882, 271891",},
		--[[1425: The Hinterlands]]			[1215] = {["145:220:158:149"] = "271927", ["160:145:512:232"] = "271933", ["170:170:319:302"] = "271934", ["170:310:693:303"] = "271938, 271916", ["180:170:408:260"] = "271929", ["185:195:237:185"] = "271928", ["195:185:240:387"] = "271937", ["200:165:373:365"] = "271922", ["205:195:374:164"] = "271910", ["225:200:171:306"] = "770218", ["235:285:505:333"] = "271912, 271920", ["255:205:13:245"] = "271917", ["275:275:509:19"] = "271908, 271935, 271936, 271909", ["280:205:571:239"] = "271915, 271921",},
		--[[1426: Dun Morogh]]				[1216] = {["115:115:252:249"] = "2212640", ["125:125:217:287"] = "271398", ["128:120:792:279"] = "2212654", ["128:128:573:280"] = "271389", ["128:165:502:221"] = "2212651", ["128:165:759:173"] = "2212653", ["128:180:281:167"] = "271392", ["128:190:347:163"] = "271418", ["150:128:295:385"] = "271406", ["155:128:522:322"] = "271401", ["155:170:694:273"] = "271409", ["165:165:608:291"] = "271408", ["180:128:274:296"] = "2212641", ["180:165:166:184"] = "2212644", ["200:185:314:311"] = "271400", ["200:200:386:294"] = "271417", ["240:185:155:403"] = "2212639", ["315:200:397:163"] = "271410, 271396",},
		--[[1427: Searing Gorge]]			[1220] = {["275:235:77:366"] = "254503, 254504", ["305:220:494:300"] = "2201968, 2201949", ["305:230:545:407"] = "254527, 254528", ["360:280:247:388"] = "2201972, 2201970, 2201969, 2201971", ["405:430:85:30"] = "254509, 254510, 254511, 254512", ["425:325:250:170"] = "254529, 254530, 254531, 254532", ["460:365:422:8"] = "254505, 254506, 254507, 254508",},
		--[[1428: Burning Steppes]]			[1224] = {["220:225:707:168"] = "270927", ["225:220:36:109"] = "270938", ["245:265:334:114"] = "270912, 270909", ["256:280:173:101"] = "270919, 270911", ["270:285:513:99"] = "270922, 270934, 270923, 270937", ["270:310:589:279"] = "270920, 270914, 270908, 270929", ["280:355:722:46"] = "270944, 270910, 270935, 270945", ["294:270:708:311"] = "270906, 270918, 270936, 270942", ["320:270:377:285"] = "270933, 270943, 270921, 270928", ["415:315:56:258"] = "270941, 270925, 270926, 270917",},
		--[[1429: Elwynn Forest]]			[1228] = {["225:220:422:332"] = "271560", ["240:220:250:270"] = "271567", ["255:250:551:292"] = "271573", ["256:210:704:330"] = "271578", ["256:237:425:431"] = "271582", ["256:240:238:428"] = "271576", ["256:249:577:419"] = "271559", ["256:256:381:147"] = "271572", ["256:341:124:327"] = "2212708, 2212709", ["306:233:696:435"] = "271557, 271583", ["310:256:587:190"] = "271584, 271565", ["485:405:0:0"] = "2212713, 2212714, 2212715, 2212716",},
		--[[1430: Deadwind Pass]]			[1233] = {["270:270:426:299"] = "271092, 271085, 271086, 271089", ["300:245:269:337"] = "271095, 271079", ["380:365:249:76"] = "271075, 271076, 271080, 271081",},
		--[[1431: Duskwood]]				[1235] = {["160:330:19:132"] = "271453, 271454", ["195:145:102:302"] = "2212669", ["200:175:653:120"] = "271466", ["220:220:690:353"] = "2212676", ["220:340:504:117"] = "271470, 271477", ["235:250:390:382"] = "271449", ["250:230:539:369"] = "271455", ["255:285:243:348"] = "271448, 271456", ["275:250:55:342"] = "271444, 271483", ["315:280:631:162"] = "271471, 271461, 271450, 271451", ["350:300:85:149"] = "271473, 271463, 271467, 271464", ["360:420:298:79"] = "2212678, 2212679, 2212680, 2212681", ["910:210:89:31"] = "271481, 271460, 271474, 271468",},
		--[[1432: Loch Modan]]				[1236] = {["195:250:109:370"] = "252899", ["230:300:125:12"] = "252882, 252883", ["235:270:229:11"] = "252884, 2212852", ["255:285:215:348"] = "252886, 252887", ["256:230:217:203"] = "252898", ["290:175:339:11"] = "2212855, 2212856", ["295:358:309:310"] = "252862, 252863, 2212828, 2212829", ["315:235:542:48"] = "252880, 252881", ["320:410:352:87"] = "252894, 252895, 252896, 252897", ["345:256:482:321"] = "252866, 252867", ["370:295:546:199"] = "252890, 252891, 252892, 252893",},
		--[[1433: Redridge Mountains]]		[1237] = {["235:270:399:129"] = "272334, 2212936", ["250:250:654:161"] = "272372", ["255:300:500:215"] = "2212977, 2212978", ["275:256:277:0"] = "272357, 272342", ["320:210:595:320"] = "272347, 272371", ["340:195:83:197"] = "272351, 272340", ["365:245:121:72"] = "272362, 272356", ["365:350:0:284"] = "272364, 272348, 272358, 272359", ["430:290:187:333"] = "272344, 272354, 272350, 272339", ["465:255:484:361"] = "272369, 272363", ["535:275:133:240"] = "272335, 272343, 2212940, 2212942, 2212943, 2212945",},
		--[[1434: Stranglethorn Vale]]		[1238] = {["105:110:311:131"] = "2213161", ["105:125:387:64"] = "2213191", ["110:105:260:132"] = "2213150", ["110:110:306:301"] = "2213171", ["110:140:371:129"] = "2213145", ["115:115:156:42"] = "2213197", ["120:120:345:276"] = "2213148", ["125:120:314:493"] = "2213152", ["125:125:280:368"] = "2213159", ["125:140:196:3"] = "2213173", ["128:125:331:59"] = "2213158", ["128:125:364:231"] = "2213194", ["128:175:432:94"] = "2213162", ["140:110:269:26"] = "2213165", ["145:128:203:433"] = "2213147", ["155:150:388:0"] = "2213156", ["165:175:194:284"] = "2213146", ["165:190:229:422"] = "2213192", ["170:125:394:212"] = "2213174", ["170:90:284:0"] = "2213168", ["190:175:152:90"] = "2213188", ["200:185:235:189"] = "2213187", ["245:220:483:8"] = "2213196", ["90:115:211:359"] = "2213164", ["90:80:241:92"] = "2213143", ["95:95:299:88"] = "2213154", ["95:95:350:335"] = "2213170",},
		--[[1435: Swamp of Sorrows]]		[1239] = {["215:365:724:120"] = "272739, 272746", ["235:205:171:145"] = "272736", ["240:245:0:262"] = "2213206", ["245:305:0:140"] = "272759, 272750", ["256:668:746:0"] = "272756, 272737, 272769", ["275:240:129:236"] = "272747, 272763", ["300:275:565:218"] = "272772, 272760, 2213215, 2213216", ["315:235:286:110"] = "272768, 272770", ["345:250:552:378"] = "272740, 272773", ["360:315:279:237"] = "272742, 272751, 272752, 272764", ["365:305:492:0"] = "2213200, 2213202, 2213203, 2213204",},
		--[[1436: Westfall]]				[1240] = {["165:200:488:0"] = "273143", ["195:240:442:241"] = "273137", ["200:185:208:375"] = "273142", ["200:240:524:252"] = "273125", ["210:215:387:11"] = "273145", ["215:215:307:29"] = "2212528", ["220:200:317:331"] = "273130", ["225:205:328:148"] = "273126", ["225:210:459:105"] = "273146", ["225:256:220:102"] = "273149", ["256:175:339:418"] = "273124", ["280:190:205:467"] = "273141, 2212527", ["288:235:523:377"] = "273131, 273134", ["305:210:204:260"] = "273129, 273133",},
		--[[1437: Wetlands]]				[1243] = {["175:128:13:314"] = "273156", ["185:240:456:125"] = "2212531", ["190:160:628:176"] = "273181", ["195:185:247:205"] = "273155", ["200:185:349:115"] = "273173", ["200:240:237:41"] = "2212533", ["205:180:401:21"] = "273164", ["205:245:527:264"] = "273177", ["225:185:347:218"] = "273159", ["225:190:89:142"] = "273171", ["230:190:470:371"] = "273174", ["240:175:77:245"] = "273163", ["256:250:507:115"] = "2212535", ["300:240:92:82"] = "273178, 273167", ["350:360:611:230"] = "2213613, 2213614, 2212532, 2212534",},

		--[[1438: Teldrassil]]				[1244] = {["128:100:494:548"] = "2213328", ["128:190:335:313"] = "272807", ["160:210:382:281"] = "272826", ["170:240:272:127"] = "272830", ["180:256:377:93"] = "272822", ["185:128:368:443"] = "272814", ["190:128:462:323"] = "2213323", ["200:200:561:292"] = "272815", ["225:225:491:153"] = "272811", ["256:185:436:380"] = "272810", ["315:256:101:247"] = "272806, 272812",},
		--[[1439: Darkshore]]				[1247] = {["150:215:318:162"] = "769206", ["170:195:468:85"] = "769211", ["175:158:329:510"] = "271044", ["175:183:229:485"] = "769210", ["180:195:365:181"] = "769207", ["190:205:324:306"] = "271045", ["195:215:510:0"] = "271043", ["200:170:305:412"] = "769209", ["230:190:375:94"] = "769208",},
		--[[1440: Ashenvale]]				[1248] = {["128:195:131:137"] = "270380", ["146:200:856:151"] = "270387", ["155:150:260:373"] = "270398", ["165:175:189:324"] = "2212540", ["180:245:520:238"] = "270402", ["200:160:796:311"] = "270390", ["200:205:392:218"] = "2212541", ["205:185:272:251"] = "270386", ["210:185:463:141"] = "270400", ["215:305:205:38"] = "2212542, 2212543", ["220:195:104:259"] = "2212548", ["225:255:597:258"] = "270401", ["235:205:547:426"] = "270375", ["245:245:19:28"] = "270376", ["245:255:713:344"] = "270405", ["255:195:203:158"] = "270389", ["275:240:356:347"] = "2212544, 2212545", ["285:185:694:225"] = "270388, 2212547",},
		--[[1441: Thousand Needles]]		[1249] = {["190:190:31:155"] = "272968", ["205:195:259:131"] = "272962", ["210:180:205:70"] = "272963", ["210:190:357:264"] = "272954", ["210:195:391:192"] = "2213363", ["240:220:492:250"] = "2213395", ["250:240:179:200"] = "2213369", ["305:310:0:0"] = "2213348, 2213349, 2213351, 2213352", ["320:365:610:300"] = "2213371, 2213372, 2213374, 2213375",},
		--[[1442: Stonetalon Mountains]]	[1250] = {["125:125:475:433"] = "2213093", ["125:86:663:582"] = "272650", ["145:107:572:561"] = "272628", ["150:150:389:320"] = "272646", ["190:97:718:571"] = "2213087", ["200:215:390:145"] = "272624", ["225:120:668:515"] = "2213088", ["230:355:210:234"] = "272633, 272647", ["270:205:247:0"] = "272632, 272641", ["288:355:457:282"] = "272648, 272634, 272635, 272623", ["320:275:553:197"] = "272630, 272649, 272642, 272636",},
		--[[1443: Desolace]]				[1251] = {["100:100:241:6"] = "2212638", ["170:160:555:181"] = "2212635", ["190:220:447:102"] = "271111", ["195:242:293:426"] = "271122", ["200:250:554:0"] = "271114", ["205:145:431:0"] = "271126", ["205:195:690:444"] = "271105", ["205:250:311:61"] = "2212632", ["205:285:590:365"] = "2212636, 2212637", ["220:220:607:215"] = "2212634", ["230:230:167:389"] = "271125", ["245:285:212:215"] = "271106, 271129", ["275:250:387:244"] = "271127, 2212633", ["285:245:625:33"] = "271104, 271124", ["285:280:399:380"] = "271108, 271112, 271113, 271109",},
		--[[1444: Feralas]]					[1252] = {["110:110:493:70"] = "2212732", ["110:170:478:386"] = "2212728", ["115:115:486:329"] = "2212726", ["120:195:623:167"] = "2212729", ["140:165:690:141"] = "271696", ["145:320:404:256"] = "271700, 271682", ["150:125:454:0"] = "2212721", ["155:160:689:233"] = "271675", ["180:180:208:234"] = "2212734", ["190:155:305:0"] = "2212733", ["190:250:540:320"] = "271699", ["215:293:192:375"] = "2212730, 2212731", ["225:180:751:198"] = "271680", ["230:195:454:201"] = "271687", ["240:220:618:298"] = "2212735", ["285:245:319:75"] = "271705, 271686",},
		--[[1445: Dustwallow Marsh]]		[1253] = {["200:195:660:21"] = "271494", ["230:205:534:224"] = "271500", ["250:315:422:0"] = "271507, 271504", ["255:250:257:313"] = "2212689", ["280:270:230:0"] = "2212685, 2212686, 2212687, 2212688", ["285:240:367:381"] = "271503, 271509", ["400:255:239:189"] = "2212683, 2212684",},
		--[[1446: Tanaris]]					[1254] = {["110:140:611:147"] = "2213315", ["110:180:473:234"] = "272800", ["120:135:533:104"] = "2213275", ["150:160:291:434"] = "2213311", ["155:150:561:256"] = "272789", ["155:150:592:75"] = "2213281", ["160:150:395:346"] = "272798", ["160:190:629:220"] = "2213273", ["165:180:509:168"] = "2213313", ["175:165:421:91"] = "272774", ["180:200:252:199"] = "272792", ["185:250:203:286"] = "272781", ["195:175:299:100"] = "272776", ["195:210:323:359"] = "272784", ["205:145:325:289"] = "272782", ["205:157:445:511"] = "272801", ["210:175:254:0"] = "272788", ["215:175:499:293"] = "272795", ["215:180:363:194"] = "272799", ["220:210:449:372"] = "272805",},
		--[[1447: Azshara]]					[1259] = {["120:155:818:107"] = "270434", ["145:215:422:95"] = "2212573", ["160:210:404:194"] = "270412", ["190:200:681:153"] = "2212567", ["200:150:77:331"] = "2212555", ["215:175:84:229"] = "2212574", ["220:255:191:369"] = "2212554", ["225:180:35:422"] = "2212564", ["235:140:478:44"] = "2212560", ["235:270:250:106"] = "2212571, 2212572", ["240:125:552:499"] = "270410", ["240:155:499:119"] = "2212568", ["245:185:644:40"] = "270432", ["265:280:238:221"] = "270414, 2212561, 2212562, 2212563", ["270:300:479:201"] = "2212550, 2212551, 2212552, 2212553", ["315:200:296:429"] = "270409, 2212559", ["370:220:389:353"] = "2212565, 2212566", ["395:128:396:540"] = "2212569, 2212570", ["570:170:366:0"] = "2212556, 2212557, 2212558",},
		--[[1448: Felwood]]					[1260] = {["145:159:496:509"] = "271657", ["160:145:548:90"] = "271653", ["165:155:332:465"] = "271663", ["175:135:408:533"] = "271658", ["185:160:405:429"] = "271659", ["195:170:330:29"] = "271652", ["215:215:420:54"] = "271673", ["235:145:292:263"] = "271666", ["235:155:297:381"] = "271664", ["235:200:307:123"] = "271665", ["240:145:483:0"] = "271660", ["245:128:271:331"] = "271669",},
		--[[1449: Un'Goro Crater]]			[1261] = {["285:285:582:67"] = "273051, 2213483, 2213484, 2213486", ["295:270:367:178"] = "273042, 273065, 273050, 273036", ["310:355:560:240"] = "273072, 273039, 273037, 273063", ["315:345:121:151"] = "273043, 273075, 273069, 273061", ["345:285:158:368"] = "273046, 273053, 273071, 273047", ["345:285:367:380"] = "273059, 273066, 273073, 273054", ["570:265:160:6"] = "273052, 273062, 273057, 273058, 2213490, 2213491",},
		--[[1450: Moonglade]]				[1263] = {["555:510:244:89"] = "252844, 252845, 252846, 252847, 2212870, 2212872",},
		--[[1451: Silithus]]				[1264] = {["288:256:116:413"] = "272564, 272553", ["320:256:344:197"] = "272573, 272545", ["320:289:104:24"] = "272581, 272562, 2213052, 2213053", ["384:384:500:65"] = "272580, 272544, 2213048, 2213049", ["384:512:97:144"] = "272559, 272543, 272574, 272575", ["512:320:265:12"] = "272565, 272566, 272577, 272546", ["512:384:245:285"] = "272567, 272547, 272555, 272548",},
		--[[1452: Wintergrasp]]				[1266] = {["125:165:611:242"] = "273206", ["145:125:617:158"] = "273200", ["165:140:593:340"] = "273199", ["165:200:509:107"] = "273191", ["175:185:555:27"] = "273203", ["185:160:392:137"] = "273207", ["185:180:493:258"] = "273185", ["200:160:523:376"] = "273198", ["215:185:401:198"] = "273192", ["230:120:229:243"] = "273187", ["240:140:222:172"] = "273202", ["250:180:368:7"] = "273184", ["255:205:447:441"] = "2213650",},
		--[[1459: Alterac Valley]]			[1273] = {["235:290:399:375"] = "270314, 270315", ["270:240:348:13"] = "270331, 270325", ["300:300:335:172"] = "270320, 270321, 270322, 270323",},

		--[[1941: Eversong Woods]]			[1628] = {["128:193:554:475"] = "271603", ["128:197:584:471"] = "271598", ["128:248:511:420"] = "271592", ["128:253:183:415"] = "271625", ["128:256:292:319"] = "271633", ["128:256:580:399"] = "271630", ["256:128:231:404"] = "271627", ["256:128:243:469"] = "271635", ["256:128:255:507"] = "271596", ["256:128:524:359"] = "271591", ["256:128:539:305"] = "271628", ["256:172:378:496"] = "271614", ["256:174:464:494"] = "271615", ["256:256:215:298"] = "271601", ["256:256:307:136"] = "271608", ["256:256:324:384"] = "271599", ["256:256:361:298"] = "271637", ["256:256:386:386"] = "271612", ["256:256:460:373"] = "271588", ["256:256:474:314"] = "271610", ["256:256:605:253"] = "271604", ["256:256:669:228"] = "271586", ["256:353:648:315"] = "271587, 271590", ["512:512:195:5"] = "271619, 271602, 271589, 271638", ["512:512:440:87"] = "271632, 271600, 271617, 271618",},
		--[[1942: Ghostlands]]				[1629] = {["256:256:184:238"] = "271744", ["256:256:210:126"] = "271716", ["256:256:40:287"] = "271752", ["256:256:585:0"] = "271761", ["256:262:364:406"] = "271711, 271717", ["256:449:340:219"] = "271740, 271730", ["256:512:365:2"] = "271762, 271751", ["256:512:448:150"] = "271741, 271723", ["256:512:60:117"] = "271754, 271733", ["404:436:598:232"] = "271742, 271728, 271758, 271706", ["427:256:575:0"] = "271735, 271736", ["429:256:573:136"] = "271715, 271745", ["512:256:326:0"] = "271729, 271707", ["512:256:460:0"] = "271731, 271719", ["512:293:95:375"] = "271721, 271725, 271714, 271737", ["512:431:466:237"] = "271712, 271757, 271713, 271734", ["512:512:44:0"] = "271726, 271756, 271727, 271710",},
		--[[1943: Azuremyst Isle]]			[1631] = {["128:256:462:349"] = "270497", ["256:128:356:0"] = "270493", ["256:222:23:446"] = "270498", ["256:247:220:421"] = "270482", ["256:256:174:363"] = "270492", ["256:256:176:303"] = "270463", ["256:256:281:305"] = "270509", ["256:256:291:3"] = "270510", ["256:256:352:378"] = "270481", ["256:256:365:49"] = "270488", ["256:256:383:249"] = "270513", ["256:256:449:183"] = "270508", ["256:256:488:24"] = "270474", ["256:256:507:350"] = "270512", ["256:256:515:279"] = "270476", ["475:512:527:104"] = "270511, 270483, 270489, 270484", ["512:512:74:85"] = "270475, 270515, 270495, 270505",},

		----------------------------------------------------------------------
		-- Outland
		----------------------------------------------------------------------

		--[[1944: Hellfire Peninsula]]		[1633] = {["256:256:182:412"] = "271830", ["256:256:206:110"] = "271835", ["256:256:34:142"] = "271836", ["256:256:467:154"] = "271852", ["256:256:469:298"] = "271848", ["256:256:705:368"] = "271843", ["256:260:308:408"] = "271838, 271861", ["256:378:25:290"] = "271850, 271864", ["256:458:338:210"] = "271855, 271833", ["256:512:326:45"] = "271840, 271849", ["256:512:579:128"] = "271866, 271821", ["256:512:737:156"] = "271854, 271825", ["422:238:580:430"] = "271826, 271822", ["512:255:261:413"] = "271856, 271820", ["512:256:477:6"] = "271867, 271842", ["512:342:183:326"] = "271862, 271844, 271823, 271831", ["512:512:38:152"] = "271851, 271841, 271865, 271853", ["512:512:478:25"] = "271863, 271857, 271845, 271839",},
		--[[1946: Zangarmarsh]]				[1635] = {["256:128:124:0"] = "273241", ["256:207:720:461"] = "273266", ["256:256:175:232"] = "273267", ["256:256:31:339"] = "273262", ["256:256:342:249"] = "273233", ["256:256:512:303"] = "273271", ["256:256:596:412"] = "273280", ["256:256:81:152"] = "273222", ["256:256:88:50"] = "273235", ["256:343:141:325"] = "273224, 273225", ["256:512:219:51"] = "273268, 273226", ["256:512:329:25"] = "273223, 273272", ["256:512:462:90"] = "273253, 273242", ["256:512:569:112"] = "273249, 273238", ["286:512:716:128"] = "273243, 273273, 273250, 273251", ["308:256:694:321"] = "273276, 273246", ["512:256:20:202"] = "273248, 273279", ["512:336:314:332"] = "273221, 273269, 273236, 273277",},
		--[[1948: Shadowmoon Valley]]		[1637] = {["256:256:143:256"] = "272431", ["256:256:520:93"] = "272421", ["256:256:554:308"] = "272461", ["256:512:290:129"] = "272451, 272471", ["396:512:606:126"] = "272429, 272470, 272446, 272450", ["492:223:510:445"] = "272442, 272443", ["512:358:343:310"] = "272454, 272426, 272439, 272455", ["512:410:469:258"] = "272448, 272449, 272469, 272452", ["512:439:168:229"] = "272430, 272460, 272434, 272435", ["512:512:104:155"] = "272436, 272440, 272441, 272427", ["512:512:116:35"] = "272428, 272424, 272433, 272445", ["512:512:348:8"] = "272467, 272465, 272422, 272453", ["512:512:394:90"] = "272459, 272438, 272463, 272447",},
		--[[1949: Blade's Edge Mountains]]	[1638] = {["256:128:563:151"] = "270643", ["256:240:271:428"] = "270622", ["256:254:446:414"] = "270642", ["256:256:254:176"] = "270663", ["256:256:286:28"] = "270625", ["256:256:412:95"] = "270631", ["256:256:422:0"] = "270665", ["256:256:439:210"] = "270649", ["256:256:527:81"] = "270611", ["256:256:585:0"] = "270651", ["256:256:623:147"] = "270666", ["256:256:629:406"] = "270667", ["256:256:658:297"] = "270655", ["256:256:673:71"] = "270626", ["256:256:733:109"] = "270609", ["256:297:342:371"] = "270669, 270657", ["256:318:289:350"] = "270638, 270630", ["256:336:533:332"] = "270612, 270658", ["256:396:405:272"] = "270664, 270659", ["256:410:554:258"] = "270629, 270606", ["256:419:512:249"] = "270644, 270610", ["256:462:166:206"] = "270652, 270653", ["256:507:314:161"] = "270619, 270620", ["256:512:479:98"] = "270616, 270617", ["416:256:586:147"] = "270628, 270605", ["512:252:144:416"] = "270662, 270632", ["512:256:214:55"] = "270621, 270633",},

		--[[1950: Bloodmyst Isle]]			[1639] = {["128:128:180:216"] = "270671", ["239:256:763:256"] = "270710", ["256:185:309:483"] = "270718", ["256:198:503:470"] = "270687", ["256:256:205:39"] = "270701", ["256:256:221:136"] = "270676", ["256:256:232:242"] = "270703", ["256:256:250:404"] = "270739", ["256:256:293:285"] = "270728", ["256:256:297:136"] = "270733", ["256:256:302:27"] = "270727", ["256:256:367:209"] = "270679", ["256:256:414:406"] = "270700", ["256:256:437:258"] = "270698", ["256:256:451:29"] = "270734", ["256:256:481:117"] = "270720", ["256:256:546:410"] = "270699", ["256:256:555:87"] = "270741", ["256:256:556:216"] = "270740", ["256:256:598:338"] = "270677", ["256:256:613:82"] = "270709", ["256:256:637:0"] = "270714", ["256:256:657:78"] = "270712", ["256:256:729:54"] = "270682", ["256:512:44:62"] = "270690, 270729", ["485:141:517:527"] = "270711, 270723", ["512:242:177:426"] = "270674, 270731", ["512:430:43:238"] = "270692, 270673, 270702, 270672",},

		--[[1951: Nagrand]]					[1640] = {["256:241:558:427"] = "272204", ["256:256:157:32"] = "272235", ["256:256:162:154"] = "272198", ["256:256:219:199"] = "272231", ["256:256:277:54"] = "272242", ["256:256:335:193"] = "272213", ["256:256:351:52"] = "272237", ["256:256:387:390"] = "272220", ["256:256:391:258"] = "272230", ["256:256:431:143"] = "272188", ["256:256:504:53"] = "272208", ["256:256:532:363"] = "272236", ["256:256:533:267"] = "272206", ["256:256:598:79"] = "272232", ["256:256:666:233"] = "272244", ["256:334:660:334"] = "272196, 272197", ["256:512:10:107"] = "272199, 272200", ["512:334:168:334"] = "272205, 272229, 272190, 272238", ["512:420:36:248"] = "272224, 272233, 272191, 272212",},
		--[[1952: Terokkar Forest]]			[1641] = {["128:256:316:268"] = "272840", ["256:208:321:460"] = "272889", ["256:234:247:434"] = "272843", ["256:256:116:4"] = "272878", ["256:256:222:362"] = "272846", ["256:256:245:289"] = "272881", ["256:256:310:345"] = "272887", ["256:256:314:0"] = "272837", ["256:256:377:272"] = "272836", ["256:256:397:165"] = "272839", ["256:256:417:327"] = "272873", ["256:256:478:19"] = "272880", ["256:256:480:277"] = "272866", ["256:256:505:154"] = "272886", ["256:256:521:275"] = "272835", ["256:367:103:301"] = "272844, 272847", ["256:512:455:34"] = "272879, 272834", ["385:512:617:149"] = "272860, 272855, 272850, 272856", ["512:256:143:171"] = "272851, 272867", ["512:320:449:348"] = "272876, 272888, 272857, 272877", ["512:512:104:4"] = "272861, 272831, 272883, 272838",},
		--[[1953: Netherstorm]]				[1642] = {["256:128:241:388"] = "272255", ["256:145:490:523"] = "272274", ["256:179:357:489"] = "272288", ["256:213:239:455"] = "272292", ["256:217:454:451"] = "272253", ["256:256:132:294"] = "272262", ["256:256:171:155"] = "272247", ["256:256:229:38"] = "272263", ["256:256:237:22"] = "272273", ["256:256:253:301"] = "272283", ["256:256:298:134"] = "272285", ["256:256:328:397"] = "272280", ["256:256:356:261"] = "272249", ["256:256:396:10"] = "272269", ["256:256:411:20"] = "272248", ["256:256:465:336"] = "272260", ["256:256:481:208"] = "272264", ["256:256:513:138"] = "272282", ["256:256:644:173"] = "272287", ["256:387:147:281"] = "272279, 272265", ["409:384:593:284"] = "272267, 272254, 272268, 272284", ["512:256:354:49"] = "272296, 272294",},

		--[[1957: Isle of Quel'Danas]]		[1646] = {["512:416:252:252"] = "272721, 272732, 272715, 272722", ["512:512:251:4"] = "272716, 272728, 272723, 272733",},

		----------------------------------------------------------------------
		-- Northrend
		----------------------------------------------------------------------

		--[[114: Borean Tundra]]			[119] = {["186:276:272:237"] = "270870, 270743", ["203:209:662:11"] = "270848", ["244:214:325:140"] = "270785", ["244:319:397:66"] = "270900, 270819", ["259:302:457:264"] = "270903, 270781, 270794, 270855", ["260:278:329:237"] = "270851, 270871, 270795, 270769", ["267:378:153:238"] = "270822, 270894, 270835, 270784", ["289:279:707:181"] = "270765, 270824, 270887, 270801", ["290:292:712:15"] = "270826, 270865, 270759, 270763", ["375:342:480:0"] = "270869, 270890, 270764, 270762", ["382:258:293:383"] = "270761, 270879, 270880, 270787", ["385:316:509:214"] = "270898, 270840, 270899, 270812", ["396:203:314:0"] = "270806, 270810", ["460:381:50:0"] = "270821, 270758, 270797, 270775",},
		--[[115: Dragonblight]]				[120] = {["188:211:374:208"] = "271192", ["196:218:543:362"] = "271358", ["213:219:403:0"] = "271232", ["214:261:614:358"] = "271313, 271133", ["226:212:661:264"] = "271378", ["229:259:487:0"] = "271146, 271257", ["229:299:42:187"] = "271267, 271201", ["235:337:134:165"] = "271254, 271233", ["235:354:569:7"] = "271149, 271222", ["236:218:258:203"] = "271170", ["258:225:433:118"] = "271239, 271157", ["299:278:703:7"] = "271351, 271270, 271175, 271330", ["301:286:698:332"] = "271280, 271346, 271164, 271387", ["304:203:256:104"] = "271352, 271244", ["306:242:210:0"] = "271187, 271231", ["311:272:691:160"] = "271333, 271199, 271364, 271162", ["317:353:453:219"] = "271205, 271248, 271252, 271236", ["356:300:217:313"] = "271322, 271298, 271290, 271337",},
		--[[116: Grizzly Hills]]			[121] = {["249:235:232:129"] = "271764", ["274:207:18:461"] = "271794, 271778", ["278:290:217:244"] = "271801, 271773, 271779, 271806", ["283:247:176:421"] = "271789, 271812", ["294:227:358:187"] = "271785, 271817", ["324:265:548:137"] = "271790, 271765, 271766, 271767", ["328:260:331:32"] = "271809, 271771, 271772, 271776", ["329:246:509:0"] = "271769, 271770", ["332:294:17:307"] = "271768, 271783, 271795, 271810", ["351:284:607:41"] = "271791, 271807, 271774, 271796", ["356:224:7:207"] = "271781, 271784", ["382:285:0:46"] = "271792, 271775, 271813, 271797", ["455:400:547:257"] = "271798, 271780, 271814, 271799", ["475:362:312:294"] = "271803, 271788, 271816, 271805",},
		--[[117: Howling Fjord]]			[122] = {["174:173:576:170"] = "271946", ["177:191:342:351"] = "271992", ["178:208:595:240"] = "271945", ["181:178:490:161"] = "271993", ["187:263:397:208"] = "271980, 271994", ["193:201:668:223"] = "271950", ["213:256:283:203"] = "271976", ["222:168:222:100"] = "271959", ["223:209:354:0"] = "271957", ["223:338:664:25"] = "271956, 271974", ["232:216:585:336"] = "271941", ["238:232:343:108"] = "271984", ["242:189:225:0"] = "271954", ["244:305:621:327"] = "271969, 271989", ["248:382:477:216"] = "271985, 271968", ["251:192:490:0"] = "271970", ["263:265:99:37"] = "271940, 271975, 271953, 271991", ["266:210:420:57"] = "271952, 271967", ["284:308:415:360"] = "271997, 271998, 271963, 271964", ["298:306:572:0"] = "271977, 271978, 271979, 271958", ["333:265:99:278"] = "271962, 271987, 271983, 271988", ["347:220:90:180"] = "271986, 271960", ["350:258:168:410"] = "271965, 271966, 271972, 271973",},
		--[[118: Icecrown]]					[123] = {["204:268:0:167"] = "254677, 254678", ["219:283:218:291"] = "254688, 254689", ["223:207:444:276"] = "254695", ["223:399:321:15"] = "254690, 254691", ["227:210:327:305"] = "254687", ["238:240:217:50"] = "254692", ["245:239:690:267"] = "254679", ["248:243:538:181"] = "254684", ["269:217:715:390"] = "254693, 254694", ["283:231:558:329"] = "254685, 254686", ["300:343:626:31"] = "254680, 254681, 254682, 254683", ["308:202:392:466"] = "254659, 254660", ["308:212:342:392"] = "254657, 254658", ["314:224:616:30"] = "294026, 294027", ["373:375:355:37"] = "254653, 254654, 254655, 254656", ["393:474:22:122"] = "254673, 254674, 254675, 254676",},
		--[[119: Sholazar Basin]]			[124] = {["207:235:427:244"] = "272524", ["233:286:705:236"] = "272529, 272506", ["239:313:265:355"] = "272530, 272516", ["249:248:172:135"] = "272507", ["268:288:138:58"] = "272517, 272534, 272496, 272502", ["293:229:396:51"] = "272500, 272501", ["294:327:308:34"] = "272523, 272487, 272539, 272532", ["312:369:501:134"] = "272494, 272495, 272504, 272533", ["322:265:596:92"] = "272521, 272515, 272522, 272499", ["329:293:76:375"] = "272509, 272491, 272520, 272484", ["455:316:82:186"] = "272535, 272518, 272490, 272519", ["468:329:359:339"] = "272498, 272531, 272510, 272541",},
		--[[120: The Storm Peaks]]			[125] = {["169:164:239:301"] = "272922", ["180:239:214:144"] = "272933", ["182:270:570:113"] = "272927, 272910", ["184:191:395:470"] = "272909", ["205:232:162:143"] = "272920", ["210:179:316:296"] = "272945", ["221:200:108:206"] = "272906", ["228:158:98:318"] = "272924", ["244:220:134:429"] = "272919", ["251:200:242:468"] = "272921", ["305:298:339:370"] = "272904, 272925, 272926, 272952", ["306:484:627:179"] = "272934, 272923, 272908, 272930", ["309:383:481:285"] = "272939, 272953, 272905, 272935", ["322:195:109:375"] = "272948, 272950", ["363:341:292:122"] = "272912, 272913, 272914, 272946", ["369:265:218:0"] = "272943, 272944, 272931, 272917",},
		--[[121: Zul'Drak]]					[126] = {["218:291:174:191"] = "273324, 273292", ["237:248:288:168"] = "273329", ["247:304:431:127"] = "273322, 273320", ["249:258:479:241"] = "273304, 273305", ["261:288:607:251"] = "273309, 273286, 273310, 273328", ["265:257:533:345"] = "273296, 273300, 273285, 273287", ["266:254:289:287"] = "273330, 273291", ["272:268:0:247"] = "273318, 273298, 273336, 273303", ["286:265:326:358"] = "273311, 273297, 273331, 273317", ["302:231:380:437"] = "273323, 273289", ["307:256:7:412"] = "273326, 273333", ["311:317:575:88"] = "273325, 273307, 273308, 273319", ["321:305:181:363"] = "273312, 273332, 273282, 273302", ["336:297:629:0"] = "273295, 273301, 273321, 273288",},
		--[[127: Crystalsong Forest]]		[132] = {["252:260:0:91"] = "270966, 271005", ["264:303:0:176"] = "270987, 270962, 270973, 270997", ["288:222:0:0"] = "253268, 271000", ["416:424:0:244"] = "270970, 270961, 270971, 270996", ["446:369:536:40"] = "253267, 270960, 270995, 270989", ["502:477:500:105"] = "253269, 270985, 253270, 270986", ["544:668:129:0"] = "253264, 271003, 270968, 270965, 253265, 253266, 271002, 271004, 270984", ["558:285:444:383"] = "253271, 253272, 270974, 270975, 271001, 270980",},

	}
