
local addonId, wqtInternal = ...
local detailsFramework = DetailsFramework
local L = detailsFramework.Language.GetLanguageTable(addonId)
local WorldQuestTracker = WorldQuestTrackerAddon

local C_Map = C_Map
local UIParent = UIParent
local UnitPosition = UnitPosition
local currentRaceId = 0

local playerPathTextures = {}
local ringIndicators = {}
local bShowRingIndicators = false

local trackDebug = false

--all minimaps has a size of 256x256
local translateWorldCoordinateToMinimapCoords = function(posX, posY)
    local WQT_raceData = WQT_RaceData[currentRaceId]

	local x, y
    if (posX and posY) then
        x = posX
        y = posY
    else
        x, y = C_Map.GetPlayerMapPosition(C_Map.GetBestMapForUnit("player"), "player"):GetXY()
    end

    local minX, maxX = WQT_raceData.minX, WQT_raceData.maxX
    local minY, maxY = WQT_raceData.minY, WQT_raceData.maxY

    --normalize player position
    x = (x - minX) / (maxX - minX)
    y = (y - minY) / (maxY - minY)

    local normalizedMinX = WQT_raceData.minXNormalized
    local normalizedMaxX = WQT_raceData.maxXNormalized
    local normalizedMinY = WQT_raceData.minYNormalized
    local normalizedMaxY = WQT_raceData.maxYNormalized

    local miniMapWidth = 256
    local miniMapHeight = 256

    local minimapStartX = 0
    local minimapStartY = 0

	--the minimap has 256x256 pixels and the initial anchor is at the top left corner.
    --this projects the player position in the world to the position in the minimap
    local resultX = detailsFramework.Math.MapRangeClamped(normalizedMinX, normalizedMaxX, minimapStartX, miniMapWidth, x)
    local resultY = detailsFramework.Math.MapRangeClamped(normalizedMinY, normalizedMaxY, minimapStartY, miniMapHeight, y)

    return resultX, -resultY
end

local dragonRidingRaceFrame = CreateFrame("frame", "WorldQuestTrackerDragonRacingFrame", UIParent)
dragonRidingRaceFrame:SetSize(256, 256)
dragonRidingRaceFrame:SetPoint("center", UIParent, "center", -400, 125)
dragonRidingRaceFrame:RegisterEvent("QUEST_WATCH_LIST_CHANGED")
detailsFramework:AddRoundedCornersToFrame(dragonRidingRaceFrame, detailsFramework.DefaultRoundedCornerPreset)
dragonRidingRaceFrame:Hide()
dragonRidingRaceFrame:SetAlpha(0.1)

local title = dragonRidingRaceFrame:CreateFontString("$parentTitle", "overlay", "GameFontNormal")
title:SetPoint("bottomleft", dragonRidingRaceFrame, "topleft", 6, 2)
title:SetText("World Quest Tracker - Race Track")
title:SetIgnoreParentAlpha(true)

local minimapTexture = dragonRidingRaceFrame:CreateTexture("$parentMinimapTexture", "artwork")
minimapTexture:SetSize(256, 256)
minimapTexture:SetAllPoints(dragonRidingRaceFrame)
minimapTexture:SetIgnoreParentAlpha(true)
minimapTexture:SetAlpha(0.7)
dragonRidingRaceFrame.MinimapTexture = minimapTexture

local positionBlip = dragonRidingRaceFrame:CreateTexture("$parentPositionBlip", "overlay", nil, 0)
positionBlip:SetTexture([[Interface\COMMON\Indicator-Yellow]])
positionBlip:SetSize(24, 24)
positionBlip:SetIgnoreParentAlpha(true)
dragonRidingRaceFrame.PositionBlip = positionBlip

--make a ring around the position blip
local ringTexture = dragonRidingRaceFrame:CreateTexture("$parentRingTexture", "overlay", nil, 2)
ringTexture:SetTexture([[Interface\AddOns\WorldQuestTracker\media\border_zone_whiteT]])
ringTexture:SetPoint("center", positionBlip, "center", 0, 0)
ringTexture:SetSize(36, 36)
ringTexture:SetIgnoreParentAlpha(true)

--make a glow above the positionBlip
local glowTexture = dragonRidingRaceFrame:CreateTexture("$parentGlowTexture", "overlay", nil, 1)
glowTexture:SetTexture([[Interface\AddOns\WorldQuestTracker\media\highlight_circleT]])
glowTexture:SetPoint("center", positionBlip, "center", 0, 0)
glowTexture:SetSize(24, 24)
glowTexture:SetAlpha(0.2)
glowTexture:SetIgnoreParentAlpha(true)

dragonRidingRaceFrame:SetScript("OnEvent", function(self, event, questId, bIsStartingRace)
	if (bIsStartingRace) then
        currentRaceId = questId

        local WQT_raceData = WQT_RaceData[currentRaceId]
        if (not WQT_raceData) then
            WQT_raceData = WQT_UseSameTrack[currentRaceId] and WQT_RaceData[WQT_UseSameTrack[currentRaceId]]
            if (WQT_raceData) then
                currentRaceId = WQT_UseSameTrack[currentRaceId]
            end
        end

        if (not WQT_raceData) then
         	return
        end

		if (WorldQuestTracker.db.profile.dragon_racing.minimap_enabled) then
			dragonRidingRaceFrame:Show()
			minimapTexture:Show()
			positionBlip:Show()
		end

		dragonRidingRaceFrame:SetScale(WorldQuestTracker.db.profile.dragon_racing.minimap_scale)
		minimapTexture:SetVertexColor(unpack(WorldQuestTracker.db.profile.dragon_racing.minimap_track_color))

		SetPortraitTexture(positionBlip, "player")

        for i = 1, #playerPathTextures do
            playerPathTextures[i]:Hide()
        end

        local nextPathTexture = 1

        local raceMap = "Interface\\AddOns\\WorldQuestTracker\\media\\track_minimaps\\" .. currentRaceId
        minimapTexture:SetTexture(raceMap)
		local r, g, b = detailsFramework:ParseColors(WorldQuestTracker.db.profile.dragon_racing.minimap_color)
		minimapTexture:SetVertexColor(r, g, b)

        --ringIndicators
        ---@type table<number, number>[]
        local ringPositions = WQT_raceData.worldPositions
        for i = 1, #ringPositions do
            local thisRingPosition = ringPositions[i]
            local x = thisRingPosition[1]
            local y = thisRingPosition[2]

            if (bShowRingIndicators) then
				local ringIndicator = ringIndicators[i]

				if (not ringIndicator) then
					ringIndicator = dragonRidingRaceFrame:CreateTexture("$parentRingIndicator" .. i, "overlay")
					--ringIndicator:SetRotation(math.pi*2 / 8)
					ringIndicator:SetColorTexture(.5, .5, .5, 0.7)
					ringIndicator:SetSize(2, 10)
					ringIndicators[i] = ringIndicator
				end

				local posX, posY = translateWorldCoordinateToMinimapCoords(x, y)
				if (ringPositions[i+1]) then
					local nextX, nextY = translateWorldCoordinateToMinimapCoords(ringPositions[i+1][1], ringPositions[i+1][2])
					local angle = detailsFramework.Math.FindLookAtRotation(posX, posY, nextX, nextY)
					--print(angle)
					ringIndicator:SetRotation(angle)
				end

				ringIndicator:ClearAllPoints()
				ringIndicator:SetPoint("center", minimapTexture, "topleft", posX, posY)
				ringIndicator:Show()
			end
        end


		dragonRidingRaceFrame:SetScript("OnUpdate", function()
			--get the player current position
			local x, y = translateWorldCoordinateToMinimapCoords()
			positionBlip:SetPoint("center", minimapTexture, "topleft", x, y)

            if (trackDebug) then
				local pathTexture = playerPathTextures[nextPathTexture]

				if (not pathTexture) then
					pathTexture = dragonRidingRaceFrame:CreateTexture("$parentPathTexture" .. nextPathTexture, "overlay")
					pathTexture:SetColorTexture(.2, .7, .7)
					pathTexture:SetSize(3, 3)
					playerPathTextures[nextPathTexture] = pathTexture
				end

				pathTexture:ClearAllPoints()
				pathTexture:SetPoint("topleft", minimapTexture, "topleft", x, y)
				pathTexture:Show()

				nextPathTexture = nextPathTexture + 1
			end
		end)
	else
		if (currentRaceId == questId) then
			dragonRidingRaceFrame:SetScript("OnUpdate", nil)
			if (trackDebug) then
				print("Race Finished!")
			else
				dragonRidingRaceFrame:Hide()
			end
		end
	end
end)

WQT_RaceData = {
	--thaldrazus
    [70051] =  {
        ["buffId"] = 415668,
        ["mapId"] = 2025,
        ["maxXNormalized"] = 1,
        ["startX"] = 0.37554800510406,
        ["minYNormalized"] = 0,
        ["minX"] = 0.37554800510406,
        ["worldPositionsNormalized"] =  {
           [1] =  {
              [1] = 0.0095504195812335,
              [2] = 0.40063747495045,
           },
           [2] =  {
              [1] = 0.017234255519734,
              [2] = 0.36389355441995,
           },
           [3] =  {
              [1] = 0.084834989932378,
              [2] = 0.17334196494758,
           },
           [4] =  {
              [1] = 0.14518579999767,
              [2] = 0.1596614977775,
           },
           [5] =  {
              [1] = 0.21763921542383,
              [2] = 0.19722551329241,
           },
           [6] =  {
              [1] = 0.28688684982367,
              [2] = 0.28173240712997,
           },
           [7] =  {
              [1] = 0.46672811019681,
              [2] = 0.41147693150695,
           },
           [8] =  {
              [1] = 0.54946228424446,
              [2] = 0.54542730613917,
           },
           [9] =  {
              [1] = 0.59959271232207,
              [2] = 0.67567121796475,
           },
           [10] =  {
              [1] = 0.72371179541196,
              [2] = 0.82903172897098,
           },
           [11] =  {
              [1] = 0.81127137187351,
              [2] = 0.73375822500291,
           },
           [12] =  {
              [1] = 0.85018556722029,
              [2] = 0.66347975006804,
           },
           [13] =  {
              [1] = 0.88386663601764,
              [2] = 0.58465121222867,
           },
           [14] =  {
              [1] = 0.92137070962185,
              [2] = 0.55648072043741,
           },
           [15] =  {
              [1] = 0.9066428118344,
              [2] = 0.3533028752805,
           },
           [16] =  {
              [1] = 1,
              [2] = 0.17984179039105,
           },
           [17] =  {
              [1] = 0.93581709226132,
              [2] = 0,
           },
           [18] =  {
              [1] = 0.8324966683737,
              [2] = 0.078122981260601,
           },
           [19] =  {
              [1] = 0.7882085889035,
              [2] = 0.21974971983906,
           },
           [20] =  {
              [1] = 0.76863819411306,
              [2] = 0.32466002710437,
           },
           [21] =  {
              [1] = 0.76371277016725,
              [2] = 0.4433328110382,
           },
           [22] =  {
              [1] = 0.72959560749078,
              [2] = 0.6042789715734,
           },
           [23] =  {
              [1] = 0.70015290564369,
              [2] = 0.72877488805016,
           },
           [24] =  {
              [1] = 0.68556976629151,
              [2] = 0.92765204515196,
           },
           [25] =  {
              [1] = 0.60794432837905,
              [2] = 1,
           },
           [26] =  {
              [1] = 0.56358386969122,
              [2] = 0.89774744189925,
           },
           [27] =  {
              [1] = 0.55004350027351,
              [2] = 0.77308933904009,
           },
           [28] =  {
              [1] = 0.58214532001071,
              [2] = 0.64184436154918,
           },
           [29] =  {
              [1] = 0.58514742082659,
              [2] = 0.51715647870456,
           },
           [30] =  {
              [1] = 0.53543890175631,
              [2] = 0.37005892771894,
           },
           [31] =  {
              [1] = 0.39414703092448,
              [2] = 0.25395455299326,
           },
           [32] =  {
              [1] = 0.30311434316042,
              [2] = 0.26344383082403,
           },
           [33] =  {
              [1] = 0.18086184371326,
              [2] = 0.31937339245348,
           },
           [34] =  {
              [1] = 0.096520778291181,
              [2] = 0.39519369360702,
           },
           [35] =  {
              [1] = 0.048008880457175,
              [2] = 0.42681133325453,
           },
           [36] =  {
              [1] = 0,
              [2] = 0.40586913116663,
           },
        },
        ["maxY"] = 0.56668221950531,
        ["startY"] = 0.48938727378845,
        ["startYNormalized"] = 0.40586913116663,
        ["maxX"] = 0.53942549228668,
        ["minXNormalized"] = 0,
        ["minY"] = 0.43658471107483,
        ["maxYNormalized"] = 1,
        ["startXNormalized"] = 0,
        ["worldPositions"] =  {
           [1] =  {
              [1] = 0.37711310386658,
              [2] = 0.48870664834976,
           },
           [2] =  {
              [1] = 0.3783723115921,
              [2] = 0.48392635583878,
           },
           [3] =  {
              [1] = 0.38945055007935,
              [2] = 0.45913606882095,
           },
           [4] =  {
              [1] = 0.39934068918228,
              [2] = 0.45735627412796,
           },
           [5] =  {
              [1] = 0.41121417284012,
              [2] = 0.46224325895309,
           },
           [6] =  {
              [1] = 0.42256230115891,
              [2] = 0.47323739528656,
           },
           [7] =  {
              [1] = 0.45203423500061,
              [2] = 0.4901168346405,
           },
           [8] =  {
              [1] = 0.46559250354767,
              [2] = 0.50754344463348,
           },
           [9] =  {
              [1] = 0.47380775213242,
              [2] = 0.52448785305023,
           },
           [10] =  {
              [1] = 0.4941480755806,
              [2] = 0.54443967342377,
           },
           [11] =  {
              [1] = 0.50849711894989,
              [2] = 0.53204482793808,
           },
           [12] =  {
              [1] = 0.51487427949905,
              [2] = 0.52290177345276,
           },
           [13] =  {
              [1] = 0.52039384841919,
              [2] = 0.51264637708664,
           },
           [14] =  {
              [1] = 0.52653992176056,
              [2] = 0.50898146629333,
           },
           [15] =  {
              [1] = 0.52412635087967,
              [2] = 0.48254853487015,
           },
           [16] =  {
              [1] = 0.53942549228668,
              [2] = 0.45998167991638,
           },
           [17] =  {
              [1] = 0.52890735864639,
              [2] = 0.43658471107483,
           },
           [18] =  {
              [1] = 0.51197546720505,
              [2] = 0.44674831628799,
           },
           [19] =  {
              [1] = 0.50471764802933,
              [2] = 0.46517360210419,
           },
           [20] =  {
              [1] = 0.5015105009079,
              [2] = 0.47882217168808,
           },
           [21] =  {
              [1] = 0.50070333480835,
              [2] = 0.49426120519638,
           },
           [22] =  {
              [1] = 0.49511229991913,
              [2] = 0.51519989967346,
           },
           [23] =  {
              [1] = 0.49028730392456,
              [2] = 0.53139650821686,
           },
           [24] =  {
              [1] = 0.48789745569229,
              [2] = 0.55726993083954,
           },
           [25] =  {
              [1] = 0.47517639398575,
              [2] = 0.56668221950531,
           },
           [26] =  {
              [1] = 0.46790671348572,
              [2] = 0.55337941646576,
           },
           [27] =  {
              [1] = 0.46568775177002,
              [2] = 0.53716170787811,
           },
           [28] =  {
              [1] = 0.47094851732254,
              [2] = 0.52008706331253,
           },
           [29] =  {
              [1] = 0.47144049406052,
              [2] = 0.50386548042297,
           },
           [30] =  {
              [1] = 0.46329438686371,
              [2] = 0.48472845554352,
           },
           [31] =  {
              [1] = 0.44013983011246,
              [2] = 0.46962356567383,
           },
           [32] =  {
              [1] = 0.4252216219902,
              [2] = 0.47085809707642,
           },
           [33] =  {
              [1] = 0.40518718957901,
              [2] = 0.47813439369202,
           },
           [34] =  {
              [1] = 0.39136558771133,
              [2] = 0.48799842596054,
           },
           [35] =  {
              [1] = 0.38341557979584,
              [2] = 0.49211180210114,
           },
           [36] =  {
              [1] = 0.37554800510406,
              [2] = 0.48938727378845,
           },
        },
    },
    [70161] =  {
        ["buffId"] = 415671,
        ["mapId"] = 2025,
        ["maxXNormalized"] = 1,
        ["startX"] = 0.57813239097595,
        ["minYNormalized"] = 0,
        ["minX"] = 0.55293297767639,
        ["worldPositionsNormalized"] =  {
           [1] =  {
              [1] = 0.33601414478796,
              [2] = 0.60354822221721,
           },
           [2] =  {
              [1] = 0.31809781567422,
              [2] = 0.54680662181646,
           },
           [3] =  {
              [1] = 0.39358596624622,
              [2] = 0.36063147042336,
           },
           [4] =  {
              [1] = 0.59971577665838,
              [2] = 0.24617545676036,
           },
           [5] =  {
              [1] = 0.77570644737418,
              [2] = 0.097010090934009,
           },
           [6] =  {
              [1] = 0.93750405440674,
              [2] = 0.019109447263437,
           },
           [7] =  {
              [1] = 1,
              [2] = 0.22203181199846,
           },
           [8] =  {
              [1] = 0.89434857186823,
              [2] = 0.2481930619103,
           },
           [9] =  {
              [1] = 0.79530940969346,
              [2] = 0.14596337192352,
           },
           [10] =  {
              [1] = 0.70100881182876,
              [2] = 0.03791716258553,
           },
           [11] =  {
              [1] = 0.52879647104437,
              [2] = 0,
           },
           [12] =  {
              [1] = 0.3956233527794,
              [2] = 0.065452565194094,
           },
           [13] =  {
              [1] = 0.3233523268146,
              [2] = 0.19356794748846,
           },
           [14] =  {
              [1] = 0.27080796971905,
              [2] = 0.38894265130039,
           },
           [15] =  {
              [1] = 0.17737331770407,
              [2] = 0.39902122520618,
           },
           [16] =  {
              [1] = 0.061768792458125,
              [2] = 0.2538903426148,
           },
           [17] =  {
              [1] = 0.018902964280488,
              [2] = 0.17239727117995,
           },
           [18] =  {
              [1] = 0.022101231181895,
              [2] = 0.045632048439973,
           },
           [19] =  {
              [1] = 0.10820551580351,
              [2] = 0.042912825643289,
           },
           [20] =  {
              [1] = 0.2214090779487,
              [2] = 0.069965457145703,
           },
           [21] =  {
              [1] = 0.31288403717834,
              [2] = 0.13009590713345,
           },
           [22] =  {
              [1] = 0.23500774674554,
              [2] = 0.25476136638764,
           },
           [23] =  {
              [1] = 0.10789549512038,
              [2] = 0.25872677845532,
           },
           [24] =  {
              [1] = 0.086006978859757,
              [2] = 0.42760941781731,
           },
           [25] =  {
              [1] = 0.064336457678028,
              [2] = 0.63973351616592,
           },
           [26] =  {
              [1] = 0.041907856723677,
              [2] = 0.78049691978947,
           },
           [27] =  {
              [1] = 0,
              [2] = 1,
           },
           [28] =  {
              [1] = 0.10626996088158,
              [2] = 0.98407218882167,
           },
           [29] =  {
              [1] = 0.20543886407215,
              [2] = 0.88516663964409,
           },
           [30] =  {
              [1] = 0.24977634760937,
              [2] = 0.74964028463137,
           },
           [31] =  {
              [1] = 0.27913628690264,
              [2] = 0.64315871899886,
           },
           [32] =  {
              [1] = 0.24535987291415,
              [2] = 0.50105242647011,
           },
           [33] =  {
              [1] = 0.16953907241208,
              [2] = 0.34206368652451,
           },
           [34] =  {
              [1] = 0.25586663227021,
              [2] = 0.31936181149679,
           },
           [35] =  {
              [1] = 0.31890341686543,
              [2] = 0.64664063289547,
           },
        },
        ["maxY"] = 0.36832773685455,
        ["startY"] = 0.33935940265656,
        ["startYNormalized"] = 0.64664063289547,
        ["maxX"] = 0.63195192813873,
        ["minXNormalized"] = 0,
        ["minY"] = 0.28634792566299,
        ["maxYNormalized"] = 1,
        ["startXNormalized"] = 0.31890341686543,
        ["worldPositions"] =  {
           [1] =  {
              [1] = 0.57948446273804,
              [2] = 0.33582669496536,
           },
           [2] =  {
              [1] = 0.57806873321533,
              [2] = 0.3311750292778,
           },
           [3] =  {
              [1] = 0.58403372764587,
              [2] = 0.31591242551804,
           },
           [4] =  {
              [1] = 0.60032188892365,
              [2] = 0.3065293431282,
           },
           [5] =  {
              [1] = 0.61422848701477,
              [2] = 0.29430079460144,
           },
           [6] =  {
              [1] = 0.6270135641098,
              [2] = 0.28791451454163,
           },
           [7] =  {
              [1] = 0.63195192813873,
              [2] = 0.30455005168915,
           },
           [8] =  {
              [1] = 0.62360346317291,
              [2] = 0.30669474601746,
           },
           [9] =  {
              [1] = 0.61577749252319,
              [2] = 0.29831397533417,
           },
           [10] =  {
              [1] = 0.60832595825195,
              [2] = 0.28945636749268,
           },
           [11] =  {
              [1] = 0.59471791982651,
              [2] = 0.28634792566299,
           },
           [12] =  {
              [1] = 0.58419471979141,
              [2] = 0.29171371459961,
           },
           [13] =  {
              [1] = 0.57848393917084,
              [2] = 0.30221658945084,
           },
           [14] =  {
              [1] = 0.57433193922043,
              [2] = 0.31823337078094,
           },
           [15] =  {
              [1] = 0.56694883108139,
              [2] = 0.31905961036682,
           },
           [16] =  {
              [1] = 0.55781388282776,
              [2] = 0.30716180801392,
           },
           [17] =  {
              [1] = 0.55442667007446,
              [2] = 0.30048102140427,
           },
           [18] =  {
              [1] = 0.55467939376831,
              [2] = 0.29008883237839,
           },
           [19] =  {
              [1] = 0.56148326396942,
              [2] = 0.28986591100693,
           },
           [20] =  {
              [1] = 0.57042849063873,
              [2] = 0.29208368062973,
           },
           [21] =  {
              [1] = 0.57765674591064,
              [2] = 0.29701316356659,
           },
           [22] =  {
              [1] = 0.57150304317474,
              [2] = 0.30723321437836,
           },
           [23] =  {
              [1] = 0.56145876646042,
              [2] = 0.30755829811096,
           },
           [24] =  {
              [1] = 0.55972915887833,
              [2] = 0.32140326499939,
           },
           [25] =  {
              [1] = 0.55801677703857,
              [2] = 0.33879315853119,
           },
           [26] =  {
              [1] = 0.55624449253082,
              [2] = 0.35033291578293,
           },
           [27] =  {
              [1] = 0.55293297767639,
              [2] = 0.36832773685455,
           },
           [28] =  {
              [1] = 0.56133031845093,
              [2] = 0.36702197790146,
           },
           [29] =  {
              [1] = 0.56916654109955,
              [2] = 0.35891371965408,
           },
           [30] =  {
              [1] = 0.5726700425148,
              [2] = 0.34780329465866,
           },
           [31] =  {
              [1] = 0.57499003410339,
              [2] = 0.33907395601273,
           },
           [32] =  {
              [1] = 0.57232105731964,
              [2] = 0.32742410898209,
           },
           [33] =  {
              [1] = 0.56632977724075,
              [2] = 0.31439024209976,
           },
           [34] =  {
              [1] = 0.57315129041672,
              [2] = 0.3125291466713,
           },
           [35] =  {
              [1] = 0.57813239097595,
              [2] = 0.33935940265656,
           },
        },
    },
	[70157] =  {
		["mapId"] = 2025,
		["maxXNormalized"] = 1,
		["startX"] = 0.39402163028717,
		["minYNormalized"] = 0,
		["minX"] = 0.33034628629684,
		["worldPositionsNormalized"] =  {
		   [1] =  {
			  [1] = 0.966265419826,
			  [2] = 0.80418604626532,
		   },
		   [2] =  {
			  [1] = 0.86855943315277,
			  [2] = 0.76323959988752,
		   },
		   [3] =  {
			  [1] = 0.68120485063117,
			  [2] = 0.66046837244204,
		   },
		   [4] =  {
			  [1] = 0.51365206812431,
			  [2] = 0.44345146525917,
		   },
		   [5] =  {
			  [1] = 0.39227982758731,
			  [2] = 0.29929425869626,
		   },
		   [6] =  {
			  [1] = 0.2146769172814,
			  [2] = 0.27909693497404,
		   },
		   [7] =  {
			  [1] = 0.082903317679581,
			  [2] = 0.35189202957685,
		   },
		   [8] =  {
			  [1] = 0,
			  [2] = 0.48011537999194,
		   },
		   [9] =  {
			  [1] = 0.16598407084316,
			  [2] = 0.56839420685258,
		   },
		   [10] =  {
			  [1] = 0.27733530119901,
			  [2] = 0.50663085445694,
		   },
		   [11] =  {
			  [1] = 0.36497569133869,
			  [2] = 0.41001838094144,
		   },
		   [12] =  {
			  [1] = 0.52438918972039,
			  [2] = 0.33882096136931,
		   },
		   [13] =  {
			  [1] = 0.67820937569097,
			  [2] = 0.31989616436194,
		   },
		   [14] =  {
			  [1] = 0.80060528248184,
			  [2] = 0.31273654672365,
		   },
		   [15] =  {
			  [1] = 0.95844460964648,
			  [2] = 0.3901059591637,
		   },
		   [16] =  {
			  [1] = 0.97268039501688,
			  [2] = 0.5675326167714,
		   },
		   [17] =  {
			  [1] = 0.90464890067344,
			  [2] = 0.6574716064498,
		   },
		   [18] =  {
			  [1] = 0.74916264100434,
			  [2] = 0.77950919550151,
		   },
		   [19] =  {
			  [1] = 0.62095139996597,
			  [2] = 0.78114393955842,
		   },
		   [20] =  {
			  [1] = 0.50584490682817,
			  [2] = 0.72989336300268,
		   },
		   [21] =  {
			  [1] = 0.33643769603209,
			  [2] = 0.64955419200379,
		   },
		   [22] =  {
			  [1] = 0.26894487761956,
			  [2] = 0.52439539094319,
		   },
		   [23] =  {
			  [1] = 0.26239341359483,
			  [2] = 0.39533004407507,
		   },
		   [24] =  {
			  [1] = 0.36208121813554,
			  [2] = 0.24888514903602,
		   },
		   [25] =  {
			  [1] = 0.47150340630633,
			  [2] = 0.15887837599537,
		   },
		   [26] =  {
			  [1] = 0.5790666165601,
			  [2] = 0.080294688167408,
		   },
		   [27] =  {
			  [1] = 0.68049874839739,
			  [2] = 0,
		   },
		   [28] =  {
			  [1] = 0.81488019465128,
			  [2] = 0.00014668743238212,
		   },
		   [29] =  {
			  [1] = 0.95797781783472,
			  [2] = 0.15686340964081,
		   },
		   [30] =  {
			  [1] = 1,
			  [2] = 0.21743949408193,
		   },
		   [31] =  {
			  [1] = 0.95081306398324,
			  [2] = 0.43570668656391,
		   },
		   [32] =  {
			  [1] = 0.85246739964204,
			  [2] = 0.5943695326496,
		   },
		   [33] =  {
			  [1] = 0.76771238344991,
			  [2] = 0.73864800788405,
		   },
		   [34] =  {
			  [1] = 0.68093824244239,
			  [2] = 0.87922116916768,
		   },
		   [35] =  {
			  [1] = 0.75301162611887,
			  [2] = 0.99999205663724,
		   },
		   [36] =  {
			  [1] = 0.88258502571905,
			  [2] = 1,
		   },
		   [37] =  {
			  [1] = 0.97206892504124,
			  [2] = 0.82618757245009,
		   },
		},
		["maxY"] = 0.78422206640244,
		["startY"] = 0.76465851068497,
		["startYNormalized"] = 0.82618757245009,
		["maxX"] = 0.3958512544632,
		["minXNormalized"] = 0,
		["minY"] = 0.67166650295258,
		["maxYNormalized"] = 1,
		["startXNormalized"] = 0.97206892504124,
		["worldPositions"] =  {
		   [1] =  {
			  [1] = 0.39364147186279,
			  [2] = 0.76218211650848,
		   },
		   [2] =  {
			  [1] = 0.3872412443161,
			  [2] = 0.75757336616516,
		   },
		   [3] =  {
			  [1] = 0.3749685883522,
			  [2] = 0.7460058927536,
		   },
		   [4] =  {
			  [1] = 0.36399304866791,
			  [2] = 0.72157943248749,
		   },
		   [5] =  {
			  [1] = 0.35604256391525,
			  [2] = 0.70535373687744,
		   },
		   [6] =  {
			  [1] = 0.34440869092941,
			  [2] = 0.70308041572571,
		   },
		   [7] =  {
			  [1] = 0.33577686548233,
			  [2] = 0.71127390861511,
		   },
		   [8] =  {
			  [1] = 0.33034628629684,
			  [2] = 0.72570616006851,
		   },
		   [9] =  {
			  [1] = 0.34121906757355,
			  [2] = 0.7356424331665,
		   },
		   [10] =  {
			  [1] = 0.34851312637329,
			  [2] = 0.72869062423706,
		   },
		   [11] =  {
			  [1] = 0.35425400733948,
			  [2] = 0.71781635284424,
		   },
		   [12] =  {
			  [1] = 0.36469638347626,
			  [2] = 0.70980268716812,
		   },
		   [13] =  {
			  [1] = 0.3747723698616,
			  [2] = 0.70767259597778,
		   },
		   [14] =  {
			  [1] = 0.38278990983963,
			  [2] = 0.70686674118042,
		   },
		   [15] =  {
			  [1] = 0.39312916994095,
			  [2] = 0.71557509899139,
		   },
		   [16] =  {
			  [1] = 0.39406168460846,
			  [2] = 0.73554545640945,
		   },
		   [17] =  {
			  [1] = 0.38960528373718,
			  [2] = 0.74566859006882,
		   },
		   [18] =  {
			  [1] = 0.37942016124725,
			  [2] = 0.7594045996666,
		   },
		   [19] =  {
			  [1] = 0.37102168798447,
			  [2] = 0.75958859920502,
		   },
		   [20] =  {
			  [1] = 0.36348164081573,
			  [2] = 0.75382006168365,
		   },
		   [21] =  {
			  [1] = 0.35238462686539,
			  [2] = 0.74477744102478,
		   },
		   [22] =  {
			  [1] = 0.34796351194382,
			  [2] = 0.7306901216507,
		   },
		   [23] =  {
			  [1] = 0.34753435850143,
			  [2] = 0.7161630988121,
		   },
		   [24] =  {
			  [1] = 0.35406440496445,
			  [2] = 0.69967991113663,
		   },
		   [25] =  {
			  [1] = 0.36123210191727,
			  [2] = 0.68954914808273,
		   },
		   [26] =  {
			  [1] = 0.36827802658081,
			  [2] = 0.68070411682129,
		   },
		   [27] =  {
			  [1] = 0.37492233514786,
			  [2] = 0.67166650295258,
		   },
		   [28] =  {
			  [1] = 0.38372498750687,
			  [2] = 0.67168301343918,
		   },
		   [29] =  {
			  [1] = 0.39309859275818,
			  [2] = 0.68932235240936,
		   },
		   [30] =  {
			  [1] = 0.3958512544632,
			  [2] = 0.69614052772522,
		   },
		   [31] =  {
			  [1] = 0.39262926578522,
			  [2] = 0.72070771455765,
		   },
		   [32] =  {
			  [1] = 0.38618713617325,
			  [2] = 0.73856610059738,
		   },
		   [33] =  {
			  [1] = 0.38063526153564,
			  [2] = 0.75480544567108,
		   },
		   [34] =  {
			  [1] = 0.37495112419128,
			  [2] = 0.77062773704529,
		   },
		   [35] =  {
			  [1] = 0.37967228889465,
			  [2] = 0.78422117233276,
		   },
		   [36] =  {
			  [1] = 0.38815999031067,
			  [2] = 0.78422206640244,
		   },
		   [37] =  {
			  [1] = 0.39402163028717,
			  [2] = 0.76465851068497,
		   },
		},
	},
	[67095] =  {
		["mapId"] = 2025,
		["maxXNormalized"] = 1,
		["startX"] = 0.57651561498642,
		["minYNormalized"] = 0,
		["minX"] = 0.54108726978302,
		["worldPositionsNormalized"] =  {
		   [1] =  {
			  [1] = 0.47959091739016,
			  [2] = 0.011337693856038,
		   },
		   [2] =  {
			  [1] = 0.46468525084495,
			  [2] = 0.079713747923395,
		   },
		   [3] =  {
			  [1] = 0.38645182946227,
			  [2] = 0.15652401496216,
		   },
		   [4] =  {
			  [1] = 0.1897480587552,
			  [2] = 0.16155251126264,
		   },
		   [5] =  {
			  [1] = 0.14641279327965,
			  [2] = 0.26405939328801,
		   },
		   [6] =  {
			  [1] = 0.32523375067074,
			  [2] = 0.33665590207965,
		   },
		   [7] =  {
			  [1] = 0.35218434390749,
			  [2] = 0.14919081444229,
		   },
		   [8] =  {
			  [1] = 0.21643872969756,
			  [2] = 0.023703296954721,
		   },
		   [9] =  {
			  [1] = 0.074246883125063,
			  [2] = 0.049216316859442,
		   },
		   [10] =  {
			  [1] = 0.011442959414649,
			  [2] = 0.15237108304915,
		   },
		   [11] =  {
			  [1] = 0,
			  [2] = 0.31845822542239,
		   },
		   [12] =  {
			  [1] = 0.16892557212804,
			  [2] = 0.47325064300132,
		   },
		   [13] =  {
			  [1] = 0.22060306756146,
			  [2] = 0.66735026537581,
		   },
		   [14] =  {
			  [1] = 0.25879968522294,
			  [2] = 0.8011988926259,
		   },
		   [15] =  {
			  [1] = 0.37642488843673,
			  [2] = 0.90350878661508,
		   },
		   [16] =  {
			  [1] = 0.4357509561712,
			  [2] = 1,
		   },
		   [17] =  {
			  [1] = 0.61501920315479,
			  [2] = 0.94057881000253,
		   },
		   [18] =  {
			  [1] = 0.80060850519964,
			  [2] = 0.79276077337615,
		   },
		   [19] =  {
			  [1] = 0.92007389447314,
			  [2] = 0.68099098933195,
		   },
		   [20] =  {
			  [1] = 1,
			  [2] = 0.57410795948855,
		   },
		   [21] =  {
			  [1] = 0.91160648721398,
			  [2] = 0.46808207872044,
		   },
		   [22] =  {
			  [1] = 0.85021060881615,
			  [2] = 0.37299210317932,
		   },
		   [23] =  {
			  [1] = 0.8177139435554,
			  [2] = 0.24353748101967,
		   },
		   [24] =  {
			  [1] = 0.7238054537438,
			  [2] = 0.19200418306606,
		   },
		   [25] =  {
			  [1] = 0.61076158029566,
			  [2] = 0.18280378150065,
		   },
		   [26] =  {
			  [1] = 0.48400401524133,
			  [2] = 0.16081589877605,
		   },
		   [27] =  {
			  [1] = 0.39044155695049,
			  [2] = 0.03771902363131,
		   },
		   [28] =  {
			  [1] = 0.47391089768071,
			  [2] = 0,
		   },
		},
		["maxY"] = 0.85593163967133,
		["startY"] = 0.74912089109421,
		["startYNormalized"] = 0,
		["maxX"] = 0.61584466695786,
		["minXNormalized"] = 0,
		["minY"] = 0.74912089109421,
		["maxYNormalized"] = 1,
		["startXNormalized"] = 0.47391089768071,
		["worldPositions"] =  {
		   [1] =  {
			  [1] = 0.5769402384758,
			  [2] = 0.75033187866211,
		   },
		   [2] =  {
			  [1] = 0.57582592964172,
			  [2] = 0.75763517618179,
		   },
		   [3] =  {
			  [1] = 0.56997740268707,
			  [2] = 0.76583933830261,
		   },
		   [4] =  {
			  [1] = 0.55527234077454,
			  [2] = 0.76637643575668,
		   },
		   [5] =  {
			  [1] = 0.5520327091217,
			  [2] = 0.77732527256012,
		   },
		   [6] =  {
			  [1] = 0.56540089845657,
			  [2] = 0.78507936000824,
		   },
		   [7] =  {
			  [1] = 0.56741565465927,
			  [2] = 0.76505607366562,
		   },
		   [8] =  {
			  [1] = 0.55726766586304,
			  [2] = 0.75165265798569,
		   },
		   [9] =  {
			  [1] = 0.54663777351379,
			  [2] = 0.75437772274017,
		   },
		   [10] =  {
			  [1] = 0.54194271564484,
			  [2] = 0.76539576053619,
		   },
		   [11] =  {
			  [1] = 0.54108726978302,
			  [2] = 0.78313565254211,
		   },
		   [12] =  {
			  [1] = 0.55371570587158,
			  [2] = 0.79966914653778,
		   },
		   [13] =  {
			  [1] = 0.5575789809227,
			  [2] = 0.82040107250214,
		   },
		   [14] =  {
			  [1] = 0.56043446063995,
			  [2] = 0.83469754457474,
		   },
		   [15] =  {
			  [1] = 0.56922781467438,
			  [2] = 0.84562534093857,
		   },
		   [16] =  {
			  [1] = 0.57366287708282,
			  [2] = 0.85593163967133,
		   },
		   [17] =  {
			  [1] = 0.58706450462341,
			  [2] = 0.84958481788635,
		   },
		   [18] =  {
			  [1] = 0.60093867778778,
			  [2] = 0.83379626274109,
		   },
		   [19] =  {
			  [1] = 0.60986959934235,
			  [2] = 0.82185804843903,
		   },
		   [20] =  {
			  [1] = 0.61584466695786,
			  [2] = 0.81044179201126,
		   },
		   [21] =  {
			  [1] = 0.60923659801483,
			  [2] = 0.79911708831787,
		   },
		   [22] =  {
			  [1] = 0.60464680194855,
			  [2] = 0.78896045684814,
		   },
		   [23] =  {
			  [1] = 0.60221743583679,
			  [2] = 0.7751333117485,
		   },
		   [24] =  {
			  [1] = 0.59519708156586,
			  [2] = 0.76962900161743,
		   },
		   [25] =  {
			  [1] = 0.58674621582031,
			  [2] = 0.76864629983902,
		   },
		   [26] =  {
			  [1] = 0.57727015018463,
			  [2] = 0.76629775762558,
		   },
		   [27] =  {
			  [1] = 0.57027566432953,
			  [2] = 0.75314968824387,
		   },
		   [28] =  {
			  [1] = 0.57651561498642,
			  [2] = 0.74912089109421,
		   },
		},
	},
	[70059] =  {
		["mapId"] = 2025,
		["maxXNormalized"] = 1,
		["startX"] = 0.60338342189789,
		["minYNormalized"] = 0,
		["minX"] = 0.57034707069397,
		["worldPositionsNormalized"] =  {
		   [1] =  {
			  [1] = 0.56210121225353,
			  [2] = 0.86969117273419,
		   },
		   [2] =  {
			  [1] = 0.54832384166634,
			  [2] = 0.88677626589828,
		   },
		   [3] =  {
			  [1] = 0.43233029776832,
			  [2] = 0.96532101705018,
		   },
		   [4] =  {
			  [1] = 0.26076714162411,
			  [2] = 0.99157447017592,
		   },
		   [5] =  {
			  [1] = 0.071941462498903,
			  [2] = 0.95097902943327,
		   },
		   [6] =  {
			  [1] = 0,
			  [2] = 0.85874137809537,
		   },
		   [7] =  {
			  [1] = 0.036655314755376,
			  [2] = 0.77122835917292,
		   },
		   [8] =  {
			  [1] = 0.18927356609853,
			  [2] = 0.70705630445562,
		   },
		   [9] =  {
			  [1] = 0.32791856006889,
			  [2] = 0.659884327965,
		   },
		   [10] =  {
			  [1] = 0.47974510232024,
			  [2] = 0.55785573579297,
		   },
		   [11] =  {
			  [1] = 0.35922167650522,
			  [2] = 0.47660893193439,
		   },
		   [12] =  {
			  [1] = 0.1893602868109,
			  [2] = 0.46670226734515,
		   },
		   [13] =  {
			  [1] = 0.074991991087151,
			  [2] = 0.54133374537024,
		   },
		   [14] =  {
			  [1] = 0.21344007802824,
			  [2] = 0.61538886737476,
		   },
		   [15] =  {
			  [1] = 0.37208184802858,
			  [2] = 0.59286281821608,
		   },
		   [16] =  {
			  [1] = 0.39687274908739,
			  [2] = 0.53128323421389,
		   },
		   [17] =  {
			  [1] = 0.33987581593988,
			  [2] = 0.42055499561349,
		   },
		   [18] =  {
			  [1] = 0.4595299941438,
			  [2] = 0.355567702599,
		   },
		   [19] =  {
			  [1] = 0.6910947010584,
			  [2] = 0.31631957082649,
		   },
		   [20] =  {
			  [1] = 0.83367375463956,
			  [2] = 0.29700954300754,
		   },
		   [21] =  {
			  [1] = 1,
			  [2] = 0.18880265996546,
		   },
		   [22] =  {
			  [1] = 0.91260388631221,
			  [2] = 0.1127437067935,
		   },
		   [23] =  {
			  [1] = 0.79992001289588,
			  [2] = 0.062523799333716,
		   },
		   [24] =  {
			  [1] = 0.65962018368467,
			  [2] = 0,
		   },
		   [25] =  {
			  [1] = 0.52765982627291,
			  [2] = 0.068196202838529,
		   },
		   [26] =  {
			  [1] = 0.62138451147672,
			  [2] = 0.16836642666379,
		   },
		   [27] =  {
			  [1] = 0.74350665913047,
			  [2] = 0.26208618251899,
		   },
		   [28] =  {
			  [1] = 0.78159235551819,
			  [2] = 0.32668104916837,
		   },
		   [29] =  {
			  [1] = 0.80399282564648,
			  [2] = 0.47872848685695,
		   },
		   [30] =  {
			  [1] = 0.75828692925018,
			  [2] = 0.56475002699143,
		   },
		   [31] =  {
			  [1] = 0.76993913226235,
			  [2] = 0.63396220681968,
		   },
		   [32] =  {
			  [1] = 0.77439963760945,
			  [2] = 0.68332840914748,
		   },
		   [33] =  {
			  [1] = 0.66742504779842,
			  [2] = 0.73717357334914,
		   },
		   [34] =  {
			  [1] = 0.67994037695963,
			  [2] = 0.79286288286623,
		   },
		   [35] =  {
			  [1] = 0.67722142756576,
			  [2] = 0.90016563366514,
		   },
		   [36] =  {
			  [1] = 0.66531722436587,
			  [2] = 0.98132515983131,
		   },
		   [37] =  {
			  [1] = 0.55365869584292,
			  [2] = 1,
		   },
		   [38] =  {
			  [1] = 0.47414702527552,
			  [2] = 0.94243228059196,
		   },
		   [39] =  {
			  [1] = 0.56547821881778,
			  [2] = 0.86587099581261,
		   },
		},
		["maxY"] = 0.44116562604904,
		["startY"] = 0.41643339395523,
		["startYNormalized"] = 0.86587099581261,
		["maxX"] = 0.62876904010773,
		["minXNormalized"] = 0,
		["minY"] = 0.25677424669266,
		["maxYNormalized"] = 1,
		["startXNormalized"] = 0.56547821881778,
		["worldPositions"] =  {
		   [1] =  {
			  [1] = 0.60318613052368,
			  [2] = 0.41713780164719,
		   },
		   [2] =  {
			  [1] = 0.60238122940063,
			  [2] = 0.42028814554214,
		   },
		   [3] =  {
			  [1] = 0.59560465812683,
			  [2] = 0.43477112054825,
		   },
		   [4] =  {
			  [1] = 0.58558160066605,
			  [2] = 0.43961203098297,
		   },
		   [5] =  {
			  [1] = 0.57455003261566,
			  [2] = 0.43212658166885,
		   },
		   [6] =  {
			  [1] = 0.57034707069397,
			  [2] = 0.41511875391006,
		   },
		   [7] =  {
			  [1] = 0.57248854637146,
			  [2] = 0.39898210763931,
		   },
		   [8] =  {
			  [1] = 0.58140480518341,
			  [2] = 0.38714933395386,
		   },
		   [9] =  {
			  [1] = 0.58950471878052,
			  [2] = 0.37845122814178,
		   },
		   [10] =  {
			  [1] = 0.59837472438812,
			  [2] = 0.35963803529739,
		   },
		   [11] =  {
			  [1] = 0.59133350849152,
			  [2] = 0.34465682506561,
		   },
		   [12] =  {
			  [1] = 0.58140987157822,
			  [2] = 0.34283012151718,
		   },
		   [13] =  {
			  [1] = 0.57472825050354,
			  [2] = 0.35659152269363,
		   },
		   [14] =  {
			  [1] = 0.58281666040421,
			  [2] = 0.37024664878845,
		   },
		   [15] =  {
			  [1] = 0.59208482503891,
			  [2] = 0.36609303951263,
		   },
		   [16] =  {
			  [1] = 0.59353315830231,
			  [2] = 0.35473829507828,
		   },
		   [17] =  {
			  [1] = 0.59020328521729,
			  [2] = 0.33432096242905,
		   },
		   [18] =  {
			  [1] = 0.59719371795654,
			  [2] = 0.32233786582947,
		   },
		   [19] =  {
			  [1] = 0.61072218418121,
			  [2] = 0.31510084867477,
		   },
		   [20] =  {
			  [1] = 0.61905193328857,
			  [2] = 0.31154024600983,
		   },
		   [21] =  {
			  [1] = 0.62876904010773,
			  [2] = 0.29158782958984,
		   },
		   [22] =  {
			  [1] = 0.62366318702698,
			  [2] = 0.27756321430206,
		   },
		   [23] =  {
			  [1] = 0.61707997322083,
			  [2] = 0.2683030962944,
		   },
		   [24] =  {
			  [1] = 0.60888338088989,
			  [2] = 0.25677424669266,
		   },
		   [25] =  {
			  [1] = 0.60117399692535,
			  [2] = 0.26934903860092,
		   },
		   [26] =  {
			  [1] = 0.60664957761765,
			  [2] = 0.2878195643425,
		   },
		   [27] =  {
			  [1] = 0.61378419399261,
			  [2] = 0.30510067939758,
		   },
		   [28] =  {
			  [1] = 0.61600923538208,
			  [2] = 0.3170114159584,
		   },
		   [29] =  {
			  [1] = 0.61731791496277,
			  [2] = 0.34504765272141,
		   },
		   [30] =  {
			  [1] = 0.61464768648148,
			  [2] = 0.36090928316116,
		   },
		   [31] =  {
			  [1] = 0.61532843112946,
			  [2] = 0.37367141246796,
		   },
		   [32] =  {
			  [1] = 0.61558902263641,
			  [2] = 0.38277411460876,
		   },
		   [33] =  {
			  [1] = 0.60933935642242,
			  [2] = 0.39270269870758,
		   },
		   [34] =  {
			  [1] = 0.61007052659988,
			  [2] = 0.40297132730484,
		   },
		   [35] =  {
			  [1] = 0.60991168022156,
			  [2] = 0.42275702953339,
		   },
		   [36] =  {
			  [1] = 0.60921621322632,
			  [2] = 0.43772214651108,
		   },
		   [37] =  {
			  [1] = 0.60269290208817,
			  [2] = 0.44116562604904,
		   },
		   [38] =  {
			  [1] = 0.59804767370224,
			  [2] = 0.43055063486099,
		   },
		   [39] =  {
			  [1] = 0.60338342189789,
			  [2] = 0.41643339395523,
		   },
		},
	},
	--the waking shores
	[66710] =  {
		["toUnrealEngine"] = [[---,x,y
		 1,"(0.91158306788837)","(0.64878031328809)"
		 2,"(0.9145865285042)","(0.65976534621105)"
		 3,"(0.96862260280257)","(0.63194864272751)"
		 4,"(1)","(0.52073761500601)"
		 5,"(0.95694712074141)","(0.40523104890814)"
		 6,"(0.87124362604376)","(0.31544586827299)"
		 7,"(0.70550929385085)","(0.23868373643925)"
		 8,"(0.55159791314379)","(0.19893242167343)"
		 9,"(0.47401711628456)","(0.26839080424921)"
		 10,"(0.50112527363771)","(0.48691661719683)"
		 11,"(0.48989998295909)","(0.60427443663505)"
		 12,"(0.56938518358305)","(0.72315061125317)"
		 13,"(0.60199722757482)","(0.86326677997736)"
		 14,"(0.53598090107096)","(0.96657920762961)"
		 15,"(0.39966344200191)","(1)"
		 16,"(0.27783239608321)","(0.93320874412501)"
		 17,"(0.1256824557264)","(0.83004063297947)"
		 18,"(0.004055409178497)","(0.70664880699365)"
		 19,"(0)","(0.55968124243172)"
		 20,"(0.019973504660034)","(0.43768285901914)"
		 21,"(0.058243868549032)","(0.30926602928897)"
		 22,"(0.11745325219238)","(0.15013767673466)"
		 23,"(0.18331719362408)","(0.028880886127606)"
		 24,"(0.27998544968343)","(0)"
		 25,"(0.35605263675331)","(0.072300750749021)"
		 26,"(0.46687427084562)","(0.18447166515175)"
		 27,"(0.54488518686015)","(0.27263813606136)"
		 28,"(0.68591060731186)","(0.41382242884681)"
		 29,"(0.78490765136917)","(0.50270017396809)"
		 30,"(0.89733383472938)","(0.60782989813559)"
		 31,"(0.91161583887163)","(0.64732198892401)"
		 ]],
			["mapId"] = 2022,
			["maxXNormalized"] = 1,
			["startX"] = 0.62841761112213,
			["minYNormalized"] = 0,
			["minX"] = 0.49577212333679,
			["worldPositionsNormalized"] =  {
			   [1] =  {
				  [1] = 0.91158306788837,
				  [2] = 0.64878031328809,
			   },
			   [2] =  {
				  [1] = 0.9145865285042,
				  [2] = 0.65976534621105,
			   },
			   [3] =  {
				  [1] = 0.96862260280257,
				  [2] = 0.63194864272751,
			   },
			   [4] =  {
				  [1] = 1,
				  [2] = 0.52073761500601,
			   },
			   [5] =  {
				  [1] = 0.95694712074141,
				  [2] = 0.40523104890814,
			   },
			   [6] =  {
				  [1] = 0.87124362604376,
				  [2] = 0.31544586827299,
			   },
			   [7] =  {
				  [1] = 0.70550929385085,
				  [2] = 0.23868373643925,
			   },
			   [8] =  {
				  [1] = 0.55159791314379,
				  [2] = 0.19893242167343,
			   },
			   [9] =  {
				  [1] = 0.47401711628456,
				  [2] = 0.26839080424921,
			   },
			   [10] =  {
				  [1] = 0.50112527363771,
				  [2] = 0.48691661719683,
			   },
			   [11] =  {
				  [1] = 0.48989998295909,
				  [2] = 0.60427443663505,
			   },
			   [12] =  {
				  [1] = 0.56938518358305,
				  [2] = 0.72315061125317,
			   },
			   [13] =  {
				  [1] = 0.60199722757482,
				  [2] = 0.86326677997736,
			   },
			   [14] =  {
				  [1] = 0.53598090107096,
				  [2] = 0.96657920762961,
			   },
			   [15] =  {
				  [1] = 0.39966344200191,
				  [2] = 1,
			   },
			   [16] =  {
				  [1] = 0.27783239608321,
				  [2] = 0.93320874412501,
			   },
			   [17] =  {
				  [1] = 0.1256824557264,
				  [2] = 0.83004063297947,
			   },
			   [18] =  {
				  [1] = 0.004055409178497,
				  [2] = 0.70664880699365,
			   },
			   [19] =  {
				  [1] = 0,
				  [2] = 0.55968124243172,
			   },
			   [20] =  {
				  [1] = 0.019973504660034,
				  [2] = 0.43768285901914,
			   },
			   [21] =  {
				  [1] = 0.058243868549032,
				  [2] = 0.30926602928897,
			   },
			   [22] =  {
				  [1] = 0.11745325219238,
				  [2] = 0.15013767673466,
			   },
			   [23] =  {
				  [1] = 0.18331719362408,
				  [2] = 0.028880886127606,
			   },
			   [24] =  {
				  [1] = 0.27998544968343,
				  [2] = 0,
			   },
			   [25] =  {
				  [1] = 0.35605263675331,
				  [2] = 0.072300750749021,
			   },
			   [26] =  {
				  [1] = 0.46687427084562,
				  [2] = 0.18447166515175,
			   },
			   [27] =  {
				  [1] = 0.54488518686015,
				  [2] = 0.27263813606136,
			   },
			   [28] =  {
				  [1] = 0.68591060731186,
				  [2] = 0.41382242884681,
			   },
			   [29] =  {
				  [1] = 0.78490765136917,
				  [2] = 0.50270017396809,
			   },
			   [30] =  {
				  [1] = 0.89733383472938,
				  [2] = 0.60782989813559,
			   },
			   [31] =  {
				  [1] = 0.91161583887163,
				  [2] = 0.64732198892401,
			   },
			},
			["maxY"] = 0.81091785430908,
			["startY"] = 0.74158334732056,
			["startYNormalized"] = 0.64732198892401,
			["maxX"] = 0.64127802848816,
			["minXNormalized"] = 0,
			["minY"] = 0.61432349681854,
			["maxYNormalized"] = 1,
			["startXNormalized"] = 0.91161583887163,
			["worldPositions"] =  {
			   [1] =  {
				  [1] = 0.62841284275055,
				  [2] = 0.74187004566193,
			   },
			   [2] =  {
				  [1] = 0.62884986400604,
				  [2] = 0.74402964115143,
			   },
			   [3] =  {
				  [1] = 0.63671243190765,
				  [2] = 0.73856103420258,
			   },
			   [4] =  {
				  [1] = 0.64127802848816,
				  [2] = 0.7166975736618,
			   },
			   [5] =  {
				  [1] = 0.63501358032227,
				  [2] = 0.69398963451385,
			   },
			   [6] =  {
				  [1] = 0.62254321575165,
				  [2] = 0.67633837461472,
			   },
			   [7] =  {
				  [1] = 0.59842789173126,
				  [2] = 0.66124737262726,
			   },
			   [8] =  {
				  [1] = 0.57603287696838,
				  [2] = 0.65343248844147,
			   },
			   [9] =  {
				  [1] = 0.56474441289902,
				  [2] = 0.66708761453629,
			   },
			   [10] =  {
				  [1] = 0.56868880987167,
				  [2] = 0.71004855632782,
			   },
			   [11] =  {
				  [1] = 0.56705546379089,
				  [2] = 0.73312044143677,
			   },
			   [12] =  {
				  [1] = 0.57862102985382,
				  [2] = 0.75649082660675,
			   },
			   [13] =  {
				  [1] = 0.58336627483368,
				  [2] = 0.78403687477112,
			   },
			   [14] =  {
				  [1] = 0.57376050949097,
				  [2] = 0.8043475151062,
			   },
			   [15] =  {
				  [1] = 0.55392551422119,
				  [2] = 0.81091785430908,
			   },
			   [16] =  {
				  [1] = 0.53619837760925,
				  [2] = 0.79778707027435,
			   },
			   [17] =  {
				  [1] = 0.51405966281891,
				  [2] = 0.77750480175018,
			   },
			   [18] =  {
				  [1] = 0.49636220932007,
				  [2] = 0.75324666500092,
			   },
			   [19] =  {
				  [1] = 0.49577212333679,
				  [2] = 0.72435367107391,
			   },
			   [20] =  {
				  [1] = 0.4986783862114,
				  [2] = 0.70036947727203,
			   },
			   [21] =  {
				  [1] = 0.50424695014954,
				  [2] = 0.67512345314026,
			   },
			   [22] =  {
				  [1] = 0.51286226511002,
				  [2] = 0.64383971691132,
			   },
			   [23] =  {
				  [1] = 0.52244585752487,
				  [2] = 0.62000131607056,
			   },
			   [24] =  {
				  [1] = 0.53651165962219,
				  [2] = 0.61432349681854,
			   },
			   [25] =  {
				  [1] = 0.54757988452911,
				  [2] = 0.62853741645813,
			   },
			   [26] =  {
				  [1] = 0.56370508670807,
				  [2] = 0.65058958530426,
			   },
			   [27] =  {
				  [1] = 0.57505613565445,
				  [2] = 0.66792261600494,
			   },
			   [28] =  {
				  [1] = 0.59557616710663,
				  [2] = 0.69567865133286,
			   },
			   [29] =  {
				  [1] = 0.6099808216095,
				  [2] = 0.71315151453018,
			   },
			   [30] =  {
				  [1] = 0.62633949518204,
				  [2] = 0.73381942510605,
			   },
			   [31] =  {
				  [1] = 0.62841761112213,
				  [2] = 0.74158334732056,
			   },
			},
		},

}

WQT_UseSameTrack = {
    [70052] = 70051,
    [72760] = 70051,
    [75824] = 70051,
    [75825] = 70051,
	[70163] = 70161,
	[72750] = 70161,
	[75829] = 70161,
	[75830] = 70161,
	[70158] = 70157,
	[72769] = 70157,
	[75784] = 70157,
	[75828] = 70157,
	[67096] = 67095,
	[72793] = 67095,
	[75820] = 67095,
	[75821] = 67095,
	[70060] = 70059,
	[72754] = 70059,
	[75826] = 70059,
	[75827] = 70059,
}

trackDebug = false

--[=[]]
local spline = CreateCatmullRomSpline(2);
for i = 1, #WQT_RaceData[70051].worldPositionsNormalized do
    local thisPoint = WQT_RaceData[70051].worldPositionsNormalized[i]
    spline:AddPoint(thisPoint.x, thisPoint.y);
end
--]=]


