--[[ BEGIN STANDARD HEADER ]] --

-- Imports
local _G = _G
local setmetatable = setmetatable
local tostring = tostring
local type = type
local pairs = pairs
local GetLocale = GetLocale
local SVC_NAMESPACE = select(2, ...)
local Prat = select(2, ...)

--[[ END STANDARD HEADER ]] --

--==============
-- Locale
--==============

Prat.MULTIBYTE_FIRST_CHAR = "^([%a\192-\255]?[\128-\191]*)"

function Prat.GetNamePattern(name)
  local u = name:match(Prat.MULTIBYTE_FIRST_CHAR):upper()

  if not u or u:len() == 0 then _G.Prat:Print("GetNamePattern: name error ", name) return end

  local l = u:lower()
  local namepat
  if u == l then
    namepat = name:lower()
  elseif u:len() == 1 then
    namepat = "[" .. u .. l .. "]" .. name:sub(2):lower()
  elseif u:len() > 1 then
    namepat = ""
    for i = 1, u:len() do
      namepat = namepat .. "[" .. u:sub(i, i) .. l:sub(i, i) .. "]"
    end
    namepat = namepat .. name:sub(u:len() + 1)
  end

  return "%f[%a\128-\255]" .. namepat .. "%f[^%a\128-\255]"
end

Prat.AnyNamePattern = "%f[%a\128-\255]([%a\128-\255]+)%f[^%a\128-\255]"

function Prat.AddLocale(L, module, name, loc)
  if GetLocale() == name or name == "enUS" then
    --[==[@debug@
    for k, v in pairs(loc) do
      --@end-debug@]==]
      --@non-debug@
            for k,v in pairs(loc[module] or loc) do
      --@end-non-debug@
      if type(v) == "table" then
        ---
      elseif v == true then
        L[k] = k
      else
        L[k] = v
      end
    end
  end
end

local loc_mt = {
  __index = function(t, k)
    if k == "GetDebugName" then return end
    _G.error("Locale key " .. tostring(k) .. " is not provided.")
  end
}

function Prat.GetLocalizer(self, locs)
  if self ~= SVC_NAMESPACE then
    locs = self
  end

  locs.AddLocale = Prat.AddLocale
  return setmetatable(locs, loc_mt)
end

