local addonName = ...
local MDT = MDT
local L = MDT.L
local dungeonIndex = 38
MDT.dungeonList[dungeonIndex] = L["TazaveshUpper"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 367416,
  shortName = L["tazaveshUpperShortName"],
  englishName = "Tazavesh: So'leah's Gambit",
  mapID = 392
};

local zones = { 1993, 1995, 1996 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Interface\\AddOns\\'..addonName..'\\TheWarWithin\\Textures\\TazaveshUpper' }
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["TazaveshUpper"]
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 346 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 191.11163560234,
      ["y"] = -106.33895309988,
      ["graveyardDescription"] = "",
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Murkbrine Shorerunner",
    ["id"] = 178163,
    ["count"] = 1,
    ["health"] = 14868916,
    ["scale"] = 0.8,
    ["displayId"] = 101786,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [355147] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 251.88116957393,
        ["y"] = -150.98904129678,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 244.63679586049,
        ["y"] = -149.11642565934,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 235.8545617561,
        ["y"] = -163.4688910491,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 241.09096209053,
        ["y"] = -170.14180328708,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 294.81874088859,
        ["y"] = -190.43345916771,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 301.37264905619,
        ["y"] = -192.37530276439,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 289.07943665581,
        ["y"] = -195.02807660612,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 299.82142201013,
        ["y"] = -207.02246139968,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 295.9619406661,
        ["y"] = -197.49140525933,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 300.96130636867,
            ["y"] = -197.49140525933,
          },
          [2] = {
            ["x"] = 271.98829807798,
            ["y"] = -158.08435956686,
          },
          [3] = {
            ["x"] = 250.35762569518,
            ["y"] = -144.88963530338,
          },
          [4] = {
            ["x"] = 220.45396829854,
            ["y"] = -157.30440787103,
          },
          [5] = {
            ["x"] = 206.74706022995,
            ["y"] = -177.86493804289,
          },
          [6] = {
            ["x"] = 162.68874227424,
            ["y"] = -209.68480866703,
          },
          [7] = {
            ["x"] = 156.84568227875,
            ["y"] = -250.80587951506,
          },
          [8] = {
            ["x"] = 199.40400023446,
            ["y"] = -293.39554240399,
          },
          [9] = {
            ["x"] = 238.56675676502,
            ["y"] = -302.69676724207,
          },
          [10] = {
            ["x"] = 272.83434206583,
            ["y"] = -276.75132255527,
          },
          [11] = {
            ["x"] = 265.00178115225,
            ["y"] = -229.26630384319,
          },
        },
      },
      [10] = {
        ["x"] = 302.92295989742,
        ["y"] = -199.91323427731,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 292.92055676659,
        ["y"] = -204.72049626337,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 286.5062909609,
        ["y"] = -202.47342909556,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 289.35543353539,
        ["y"] = -144.76826476125,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 292.99503386124,
        ["y"] = -150.42474045698,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 297.11397588843,
        ["y"] = -156.4223809191,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 285.74275681616,
        ["y"] = -138.56992447173,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 303.7183380697,
        ["y"] = -83.203046442177,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 288.03431650905,
        ["y"] = -75.500395914777,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 285.54682174674,
        ["y"] = -82.800576552729,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 301.09189946179,
        ["y"] = -75.479594696759,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 239.94479824827,
        ["y"] = -74.074997745947,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 247.4765146056,
        ["y"] = -62.734253061724,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 246.51828547556,
        ["y"] = -70.641186134302,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 243.59472072631,
        ["y"] = -56.71225442361,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 361.38267767442,
        ["y"] = -87.759082689326,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 364.77994168477,
        ["y"] = -82.094727683365,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 371.24260762565,
        ["y"] = -78.334453978172,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 378.28187813257,
        ["y"] = -81.274650081772,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 368.01895791194,
        ["y"] = -91.885350478494,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 374.80822719575,
        ["y"] = -95.030772269009,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 371.5081404223,
        ["y"] = -85.408882215632,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 339.07975570113,
            ["y"] = -84.327966343286,
          },
          [2] = {
            ["x"] = 305.36560304198,
            ["y"] = -78.104339018435,
          },
          [3] = {
            ["x"] = 260.39066286878,
            ["y"] = -52.257220670826,
          },
          [4] = {
            ["x"] = 255.37166394407,
            ["y"] = -80.197105359474,
          },
          [5] = {
            ["x"] = 287.92585359602,
            ["y"] = -116.23924390271,
          },
          [6] = {
            ["x"] = 312.34149084544,
            ["y"] = -107.40309773028,
          },
          [7] = {
            ["x"] = 351.17394958323,
            ["y"] = -113.91393965231,
          },
          [8] = {
            ["x"] = 374.26237566515,
            ["y"] = -128.31029689456,
          },
          [9] = {
            ["x"] = 381.40286991162,
            ["y"] = -156.6994330792,
          },
          [10] = {
            ["x"] = 415.42014364289,
            ["y"] = -117.14886642992,
          },
          [11] = {
            ["x"] = 385.99304242848,
            ["y"] = -96.898292966201,
          },
          [12] = {
            ["x"] = 358.55453709606,
            ["y"] = -87.8296288426,
          },
        },
      },
      [32] = {
        ["x"] = 378.20830223097,
        ["y"] = -88.252639772359,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 232.05518945315,
        ["y"] = -240.03181201141,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 240.15299456727,
        ["y"] = -223.94023009289,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 239.89632786165,
        ["y"] = -238.07589869093,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 242.43007954944,
        ["y"] = -231.16181042229,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 246.47818315298,
        ["y"] = -267.39180690923,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 228.89660095698,
        ["y"] = -274.1088126768,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 231.7842729597,
        ["y"] = -281.51236424368,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 240.4470404852,
        ["y"] = -262.9584281888,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 192.89071452788,
        ["y"] = -315.91125596574,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 183.91920162496,
        ["y"] = -299.43247550342,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 190.84537606245,
        ["y"] = -301.16458279822,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 194.66896906893,
        ["y"] = -308.24725670888,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 137.04701552863,
        ["y"] = -264.06638189261,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 142.31850509361,
        ["y"] = -243.19711250538,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [47] = {
        ["x"] = 131.85105804403,
        ["y"] = -245.18803510578,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 129.4864989536,
        ["y"] = -258.69477084574,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [49] = {
        ["x"] = 303.24734383096,
        ["y"] = -251.74407621813,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [50] = {
        ["x"] = 303.73805839575,
        ["y"] = -229.7495342434,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [51] = {
        ["x"] = 296.5364590308,
        ["y"] = -231.76328055602,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [52] = {
        ["x"] = 296.00649240919,
        ["y"] = -249.86544882364,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [53] = {
        ["x"] = 292.5474535403,
        ["y"] = -308.83370406368,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [54] = {
        ["x"] = 273.004235067,
        ["y"] = -309.69403685749,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [55] = {
        ["x"] = 288.85309822973,
        ["y"] = -302.32076412034,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [56] = {
        ["x"] = 277.38482639767,
        ["y"] = -302.10404824844,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [57] = {
        ["x"] = 373.24117219697,
        ["y"] = -251.61785948327,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [58] = {
        ["x"] = 357.78588451688,
        ["y"] = -264.31219265583,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [59] = {
        ["x"] = 355.82630100672,
        ["y"] = -256.46151204303,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [60] = {
        ["x"] = 366.96809881087,
        ["y"] = -248.05056223344,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [61] = {
        ["x"] = 361.5557053037,
        ["y"] = -134.5353248787,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [62] = {
        ["x"] = 351.12672661777,
        ["y"] = -123.0865716645,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [63] = {
        ["x"] = 366.70082093127,
        ["y"] = -130.06339851629,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [64] = {
        ["x"] = 355.65735266761,
        ["y"] = -116.66944917389,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [65] = {
        ["x"] = 436.70027779749,
        ["y"] = -122.52758008998,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [66] = {
        ["x"] = 438.86071052235,
        ["y"] = -141.52240450252,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [67] = {
        ["x"] = 444.20803291689,
        ["y"] = -131.2022125769,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [68] = {
        ["x"] = 427.10354789626,
        ["y"] = -124.48663654692,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [69] = {
        ["x"] = 506.51231938769,
        ["y"] = -173.91538730291,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [70] = {
        ["x"] = 515.04364711627,
        ["y"] = -190.99525247569,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [71] = {
        ["x"] = 508.05491232655,
        ["y"] = -194.73580611775,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [72] = {
        ["x"] = 498.25067570771,
        ["y"] = -177.91565295588,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [73] = {
        ["x"] = 463.97655231926,
        ["y"] = -249.04287320377,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [74] = {
        ["x"] = 466.4910504555,
        ["y"] = -255.89232539381,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [75] = {
        ["x"] = 471.05856,
        ["y"] = -247.36533845415,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [76] = {
        ["x"] = 480.42447869408,
        ["y"] = -252.58062931917,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [77] = {
        ["x"] = 473.35519884614,
        ["y"] = -253.38466215945,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 470.83823928685,
            ["y"] = -252.37786417918,
          },
          [2] = {
            ["x"] = 502.36976458035,
            ["y"] = -285.28241139768,
          },
          [3] = {
            ["x"] = 515.07593023429,
            ["y"] = -285.20350178479,
          },
          [4] = {
            ["x"] = 523.72820661372,
            ["y"] = -273.73924579322,
          },
          [5] = {
            ["x"] = 505.12583282029,
            ["y"] = -225.07020508328,
          },
          [6] = {
            ["x"] = 467.70475697333,
            ["y"] = -231.34311195638,
          },
          [7] = {
            ["x"] = 471.38198464576,
            ["y"] = -197.38294480462,
          },
          [8] = {
            ["x"] = 437.85439046829,
            ["y"] = -197.59924521608,
          },
          [9] = {
            ["x"] = 417.30526655724,
            ["y"] = -232.64094227384,
          },
          [10] = {
            ["x"] = 427.90429305429,
            ["y"] = -257.29992717033,
          },
          [11] = {
            ["x"] = 448.66974522545,
            ["y"] = -243.88889785394,
          },
        },
      },
      [78] = {
        ["x"] = 477.9170829362,
        ["y"] = -245.66020473918,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [79] = {
        ["x"] = 478.30557283553,
        ["y"] = -259.16226720456,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [80] = {
        ["x"] = 471.51565237703,
        ["y"] = -260.95636582384,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [81] = {
        ["x"] = 431.08198111897,
        ["y"] = -186.95915704279,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [82] = {
        ["x"] = 423.6739360472,
        ["y"] = -182.36479605526,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [83] = {
        ["x"] = 414.4559611807,
        ["y"] = -200.49103310024,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [84] = {
        ["x"] = 421.90211257487,
        ["y"] = -203.28818846277,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [85] = {
        ["x"] = 424.11875675856,
        ["y"] = -287.31286565913,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [86] = {
        ["x"] = 411.38177913631,
        ["y"] = -278.07590053444,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [87] = {
        ["x"] = 430.19408364023,
        ["y"] = -281.68878142047,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [88] = {
        ["x"] = 413.32720997314,
        ["y"] = -271.60573846711,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [89] = {
        ["x"] = 503.22403894781,
        ["y"] = -289.82191515266,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [90] = {
        ["x"] = 510.58543856334,
        ["y"] = -287.9632270348,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [91] = {
        ["x"] = 516.07862230922,
        ["y"] = -305.89511354893,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [92] = {
        ["x"] = 520.01217998097,
        ["y"] = -299.45741548295,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [93] = {
        ["x"] = 557.93978465367,
        ["y"] = -276.27322318015,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [94] = {
        ["x"] = 550.08219403521,
        ["y"] = -255.96855653395,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [95] = {
        ["x"] = 544.61149818008,
        ["y"] = -261.50320689248,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [96] = {
        ["x"] = 549.38854801928,
        ["y"] = -275.09235827123,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Murkbrine Shellcrusher",
    ["id"] = 178139,
    ["count"] = 3,
    ["health"] = 83637651,
    ["scale"] = 1.5,
    ["displayId"] = 101785,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [355048] = {
      },
      [355057] = {
        ["interruptible"] = true,
        ["enrage"] = true,
      },
      [355147] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 245.2150399669,
        ["y"] = -160.02440474401,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 238.11930608288,
        ["y"] = -64.253701234152,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 238.68271712578,
        ["y"] = -273.55495458736,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 184.62512176349,
        ["y"] = -309.97884925551,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 138.060581002,
        ["y"] = -253.73929780132,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 302.90365692145,
        ["y"] = -240.96016731611,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 282.43665254509,
        ["y"] = -310.50478994007,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 366.92989622172,
        ["y"] = -270.75568127982,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 377.38289459841,
        ["y"] = -262.12233206647,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 351.83911019115,
        ["y"] = -133.8890105443,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 433.90809068974,
        ["y"] = -132.27968397323,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 504.74113303309,
        ["y"] = -185.36502613206,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 420.93801656576,
        ["y"] = -192.51030426552,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 421.56481393641,
        ["y"] = -276.47722235137,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 509.66853011026,
        ["y"] = -296.81216168009,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 553.05146302483,
        ["y"] = -266.67667102258,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Murkbrine Fishmancer",
    ["id"] = 178142,
    ["count"] = 2,
    ["health"] = 65051506,
    ["scale"] = 1.4,
    ["displayId"] = 101789,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [355147] = {
      },
      [355225] = {
        ["interruptible"] = true,
      },
      [355234] = {
      },
      [355423] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 251.75690380958,
        ["y"] = -172.22249442803,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 257.92504038615,
        ["y"] = -159.72696370411,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 304.15413654111,
        ["y"] = -147.58295806892,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 296.79726461675,
        ["y"] = -137.02412331147,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 287.15039662361,
        ["y"] = -92.360155367233,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 300.71842759702,
        ["y"] = -93.076775617993,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 250.89415476477,
        ["y"] = -277.06559974494,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 240.69709669971,
        ["y"] = -286.10231588808,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 150.55187549287,
        ["y"] = -249.46661367339,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 147.87336723911,
        ["y"] = -263.93585614286,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 313.01260285581,
        ["y"] = -247.28522323095,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 312.9920210753,
        ["y"] = -232.85175289715,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 358.58843450437,
        ["y"] = -248.06140112755,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 428.45678558124,
        ["y"] = -143.99332779779,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 515.53499396289,
        ["y"] = -179.72976981977,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 407.74773225883,
        ["y"] = -192.83121137296,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 414.11286391986,
        ["y"] = -182.10438126557,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 421.00134554038,
        ["y"] = -264.68034127427,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 433.29035228687,
        ["y"] = -271.14018656442,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 507.21004311858,
        ["y"] = -309.88564732613,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 497.25359585333,
        ["y"] = -298.748483715,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 565.85395432617,
        ["y"] = -269.73386953408,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Coastwalker Goliath",
    ["id"] = 178165,
    ["count"] = 18,
    ["health"] = 185861446,
    ["scale"] = 3,
    ["displayId"] = 101790,
    ["creatureType"] = "Giant",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [355429] = {
      },
      [355464] = {
      },
      [355465] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 325.55309268982,
        ["y"] = -99.582978605104,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 263.1284704889,
            ["y"] = -130.93042582177,
          },
          [2] = {
            ["x"] = 312.16042736923,
            ["y"] = -102.66682392472,
          },
          [3] = {
            ["x"] = 263.1284704889,
            ["y"] = -130.93042582177,
          },
          [4] = {
            ["x"] = 289.18103265478,
            ["y"] = -169.41655689968,
          },
          [5] = {
            ["x"] = 295.74655052154,
            ["y"] = -208.26270979967,
          },
          [6] = {
            ["x"] = 289.18103265478,
            ["y"] = -169.41655689968,
          },
        },
      },
      [2] = {
        ["x"] = 194.11392,
        ["y"] = -206.53300528084,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 194.11392,
            ["y"] = -206.53300528084,
          },
          [2] = {
            ["x"] = 160.26729596452,
            ["y"] = -182.29786432085,
          },
          [3] = {
            ["x"] = 194.11392,
            ["y"] = -206.53300528084,
          },
          [4] = {
            ["x"] = 197.98118275107,
            ["y"] = -261.80955174617,
          },
          [5] = {
            ["x"] = 215.31523582078,
            ["y"] = -312.12054444119,
          },
          [6] = {
            ["x"] = 197.98118275107,
            ["y"] = -261.80955174617,
          },
        },
      },
      [3] = {
        ["x"] = 323.01696,
        ["y"] = -274.86221795487,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 323.01696,
            ["y"] = -274.86221795487,
          },
          [2] = {
            ["x"] = 310.22476796274,
            ["y"] = -218.60160247727,
          },
          [3] = {
            ["x"] = 323.01696,
            ["y"] = -274.86221795487,
          },
          [4] = {
            ["x"] = 423.10743388687,
            ["y"] = -304.84899908608,
          },
          [5] = {
            ["x"] = 457.35275293371,
            ["y"] = -329.37033293854,
          },
          [6] = {
            ["x"] = 423.10743388687,
            ["y"] = -304.84899908608,
          },
        },
      },
      [4] = {
        ["x"] = 464.07759649887,
        ["y"] = -222.41197903666,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 464.07759649887,
            ["y"] = -222.41197903666,
          },
          [2] = {
            ["x"] = 514.22371250835,
            ["y"] = -221.79788653731,
          },
          [3] = {
            ["x"] = 464.07759649887,
            ["y"] = -222.41197903666,
          },
          [4] = {
            ["x"] = 423.32572138459,
            ["y"] = -224.33459094893,
          },
          [5] = {
            ["x"] = 400.91829577927,
            ["y"] = -262.38490310986,
          },
          [6] = {
            ["x"] = 423.32572138459,
            ["y"] = -224.33459094893,
          },
        },
      },
    },
  },
  [5] = {
    ["name"] = "Murkbrine Scalebinder",
    ["id"] = 178141,
    ["count"] = 2,
    ["health"] = 65051506,
    ["iconTexture"] = 136043,
    ["scale"] = 1.4,
    ["displayId"] = 101788,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [355132] = {
      },
      [355147] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 294.03138282378,
        ["y"] = -81.968137077741,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 232.98191724473,
        ["y"] = -230.81090907873,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 290.31270086285,
        ["y"] = -240.62261458709,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 290.27245211307,
        ["y"] = -319.09561317909,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 275.54022902703,
        ["y"] = -320.31401406461,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 366.16241811517,
        ["y"] = -258.84306210282,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 359.21700578191,
        ["y"] = -124.64910062896,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 421.10694297101,
        ["y"] = -132.7180085005,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 497.75079070716,
        ["y"] = -196.81869140533,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 492.09383417923,
        ["y"] = -186.41668653198,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 431.17234083079,
        ["y"] = -198.89095382949,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 414.29757174951,
        ["y"] = -286.86956535548,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 520.603901074,
        ["y"] = -289.68517726454,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 561.0120805799,
        ["y"] = -255.8595622416,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Stormforged Guardian",
    ["id"] = 178171,
    ["count"] = 10,
    ["health"] = 133820238,
    ["scale"] = 2,
    ["displayId"] = 67358,
    ["creatureType"] = "Elemental",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [355577] = {
      },
      [355584] = {
      },
      [1235052] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 638.7128524184,
        ["y"] = -108.91774276647,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [2] = {
        ["x"] = 613.69184473046,
        ["y"] = -127.99033832105,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [3] = {
        ["x"] = 662.72543886792,
        ["y"] = -192.2186704288,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [4] = {
        ["x"] = 682.28003346251,
        ["y"] = -180.2486704288,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Hylbrande",
    ["id"] = 175663,
    ["count"] = 0,
    ["health"] = 558344979,
    ["scale"] = 1.8,
    ["displayId"] = 100546,
    ["creatureType"] = "Mechanical",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2448,
    ["instanceID"] = 1194,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [346116] = {
      },
      [346766] = {
      },
      [346828] = {
      },
      [346876] = {
      },
      [346877] = {
      },
      [346960] = {
      },
      [346961] = {
      },
      [347094] = {
      },
      [347097] = {
      },
      [353312] = {
      },
      [356796] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 729.23218711794,
        ["y"] = -152.05229125186,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Burly Deckhand",
    ["id"] = 180015,
    ["count"] = 5,
    ["health"] = 111516868,
    ["scale"] = 1.5,
    ["displayId"] = 101457,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [356133] = {
        ["enrage"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 696.84238701819,
        ["y"] = -386.45798625784,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [2] = {
        ["x"] = 660.01258812686,
        ["y"] = -414.51144229901,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [3] = {
        ["x"] = 673.90507964433,
        ["y"] = -407.11093910738,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [4] = {
        ["x"] = 646.2087994485,
        ["y"] = -421.9606686357,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [5] = {
        ["x"] = 534.22191466771,
        ["y"] = -532.50371965738,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [6] = {
        ["x"] = 545.15888031079,
        ["y"] = -480.33877863744,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [7] = {
        ["x"] = 558.36255480176,
        ["y"] = -474.78359848229,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
    },
  },
  [9] = {
    ["name"] = "Hourglass Tidesage",
    ["id"] = 179388,
    ["count"] = 4,
    ["health"] = 83637651,
    ["scale"] = 1.5,
    ["displayId"] = 101468,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [356260] = {
      },
      [356843] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 660.62125695068,
        ["y"] = -397.85302628611,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [2] = {
        ["x"] = 646.64442029125,
        ["y"] = -406.72110687893,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [3] = {
        ["x"] = 550.09300750255,
        ["y"] = -535.08330877013,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [4] = {
        ["x"] = 553.91513864913,
        ["y"] = -521.88822444118,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [5] = {
        ["x"] = 550.85571083763,
        ["y"] = -494.68526618515,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [6] = {
        ["x"] = 508.17192145751,
        ["y"] = -484.16030224827,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [7] = {
        ["x"] = 502.74629067904,
        ["y"] = -467.29449854475,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
    },
  },
  [10] = {
    ["name"] = "Drunk Pirate",
    ["id"] = 179399,
    ["count"] = 0,
    ["health"] = 18586145,
    ["scale"] = 1,
    ["displayId"] = 101469,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 652.546938468,
        ["y"] = -369.25752573977,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [2] = {
        ["x"] = 665.35978339305,
        ["y"] = -363.50916695807,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
    },
  },
  [11] = {
    ["name"] = "Corsair Officer",
    ["id"] = 179386,
    ["count"] = 5,
    ["health"] = 92930723,
    ["scale"] = 1.5,
    ["displayId"] = 101464,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [368661] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 540.39766447408,
        ["y"] = -518.74952500411,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [2] = {
        ["x"] = 564.32260767602,
        ["y"] = -488.78113090474,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [3] = {
        ["x"] = 523.90941063778,
        ["y"] = -477.91823319291,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
      [4] = {
        ["x"] = 519.0170225792,
        ["y"] = -462.26462734604,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
    },
  },
  [12] = {
    ["name"] = "Timecap'n Hooktail",
    ["id"] = 175546,
    ["count"] = 0,
    ["health"] = 651402475,
    ["scale"] = 1.5,
    ["displayId"] = 100063,
    ["creatureType"] = "Dragonkin",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2449,
    ["instanceID"] = 1194,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [347149] = {
        ["magic"] = true,
      },
      [350134] = {
      },
      [1240097] = {
        ["magic"] = true,
      },
      [1240099] = {
      },
      [1240102] = {
      },
      [1240105] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 484.69514824343,
        ["y"] = -517.18699664377,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 1.2,
      },
    },
  },
  [13] = {
    ["name"] = "Adorned Starseer",
    ["id"] = 180429,
    ["count"] = 12,
    ["health"] = 139396085,
    ["scale"] = 2.5,
    ["displayId"] = 101668,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [357226] = {
      },
      [357228] = {
      },
      [357238] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 316.78886694753,
        ["y"] = -472.9744068143,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 164.5902063826,
        ["y"] = -427.2680964176,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 163.69283767488,
        ["y"] = -479.7963365543,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 318.94151846001,
        ["y"] = -433.53052115786,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Devoted Accomplice",
    ["id"] = 180432,
    ["count"] = 5,
    ["health"] = 102223795,
    ["scale"] = 2,
    ["displayId"] = 101670,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [355891] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 237.24392275358,
        ["y"] = -383.24946944016,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 235.95875742294,
        ["y"] = -401.91653844128,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 230.24450844846,
        ["y"] = -511.64650596582,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 231.49662670942,
        ["y"] = -493.29020670858,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 222.95803511337,
        ["y"] = -440.1230146916,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 240.67698076352,
        ["y"] = -441.17551338618,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 206.07439897387,
        ["y"] = -439.85989703892,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Focused Ritualist",
    ["id"] = 180431,
    ["count"] = 4,
    ["health"] = 92930723,
    ["scale"] = 2,
    ["displayId"] = 101669,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [354297] = {
        ["interruptible"] = true,
      },
      [357260] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 220.33705359766,
        ["y"] = -391.29814651178,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 214.90323402748,
        ["y"] = -501.53721843212,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 230.23877393892,
        ["y"] = -456.23117745663,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 212.27963274463,
        ["y"] = -455.44181045665,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "So'leah",
    ["id"] = 177269,
    ["count"] = 0,
    ["health"] = 553692104,
    ["scale"] = 2,
    ["displayId"] = 100737,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2455,
    ["instanceID"] = 1194,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [181089] = {
      },
      [350796] = {
      },
      [350804] = {
      },
      [350875] = {
      },
      [350885] = {
      },
      [351057] = {
      },
      [351080] = {
      },
      [351086] = {
      },
      [351096] = {
      },
      [351101] = {
      },
      [351124] = {
      },
      [351646] = {
      },
      [353635] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 94.894091512072,
        ["y"] = -453.97971012835,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Titanic Defense Turret",
    ["id"] = 175667,
    ["count"] = 0,
    ["health"] = 10000,
    ["scale"] = 1,
    ["displayId"] = 20324,
    ["creatureType"] = "Not specified",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [346957] = {
      },
      [346959] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 755.05673097554,
        ["y"] = -131.42808611353,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Hourglass Cannon",
    ["id"] = 176178,
    ["count"] = 0,
    ["health"] = 10000,
    ["scale"] = 2,
    ["displayId"] = 84891,
    ["creatureType"] = "Mechanical",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [347370] = {
      },
      [352345] = {
      },
      [358947] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 451.91805143342,
        ["y"] = -483.66537258867,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Vault Purifier",
    ["id"] = 176551,
    ["count"] = 0,
    ["health"] = 18586147,
    ["scale"] = 2,
    ["displayId"] = 100495,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [181113] = {
      },
      [346980] = {
      },
      [347015] = {
      },
      [347958] = {
      },
      [352347] = {
        ["interruptible"] = true,
      },
      [355071] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 743.55339776684,
        ["y"] = -172.37469749899,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 710.6991232619,
        ["y"] = -127.24820127823,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Corsair Brute",
    ["id"] = 177500,
    ["count"] = 0,
    ["health"] = 17424513,
    ["scale"] = 2,
    ["displayId"] = 81324,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [1240214] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 468.65026193866,
        ["y"] = -538.15135307363,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 499.29230366197,
        ["y"] = -538.60022394802,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "So' Cartel Assassin",
    ["id"] = 177716,
    ["count"] = 0,
    ["health"] = 27104798,
    ["scale"] = 2,
    ["displayId"] = 101153,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [351119] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 84.39618392498,
        ["y"] = -478.3541185126,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 106.47575700406,
        ["y"] = -477.88352329817,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Progenitor Relic",
    ["id"] = 177821,
    ["count"] = 0,
    ["health"] = 10000,
    ["scale"] = 1.3,
    ["displayId"] = 4449,
    ["creatureType"] = "Not specified",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [351088] = {
      },
      [351098] = {
      },
      [351646] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 94.4983014448,
        ["y"] = -428.55190906266,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Wandering Pulsar",
    ["id"] = 180433,
    ["count"] = 0,
    ["health"] = 13382024,
    ["scale"] = 1.3,
    ["displayId"] = 101671,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [357243] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 163.93960804867,
        ["y"] = -408.46655066205,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 163.25497314891,
        ["y"] = -498.56255941858,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 316.02250491676,
        ["y"] = -491.43735460907,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 318.4563541472,
        ["y"] = -415.15258769002,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Invigorating Fish Stick",
    ["id"] = 179733,
    ["count"] = 0,
    ["health"] = 9293072,
    ["scale"] = 1,
    ["displayId"] = 102085,
    ["creatureType"] = "Totem",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [355139] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 294.63854931826,
        ["y"] = -72.882067773397,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 364.50171115747,
        ["y"] = -120.03677442637,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 419.86093255261,
        ["y"] = -141.88978940282,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 437.32734700215,
        ["y"] = -192.28897339626,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 376.69523500611,
        ["y"] = -272.80773353322,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 420.02786180583,
        ["y"] = -292.54074082887,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 283.3170250009,
        ["y"] = -324.45372760096,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 488.95357767702,
        ["y"] = -194.72489169195,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 569.39163618548,
        ["y"] = -260.71364278652,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 526.80982024687,
        ["y"] = -296.02537580746,
        ["sublevel"] = 1,
      },
    },
  },
};
