local addonName = ...
local MDT = MDT
local L = MDT.L

local dungeonIndex = 115
MDT.dungeonList[dungeonIndex] = L["Priory of the Sacred Flame"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 445444,
  shortName = L["prioryShortName"],
  englishName = "Priory of the Sacred Flame",
  mapID = 499
}

local zones = { 2215, 2308, 2309 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Interface\\AddOns\\'..addonName..'\\TheWarWithin\\Textures\\PrioryOfTheSacredFlame' }
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Priory of the Sacred Flame"]
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 960 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dungeonEntrance",
      ["x"] = 821.00625906156,
      ["y"] = -274.69458389737,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "prioryItem",
      ["x"] = 185.99748033925,
      ["y"] = -250.31749541189,
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "prioryItem",
      ["x"] = 649.92761799678,
      ["y"] = -279.62096884776,
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "prioryItem",
      ["x"] = 185.99748033925,
      ["y"] = -325.43414998044,
    },
    [5] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "generalNote",
      ["x"] = 518.45294071181,
      ["y"] = -311.27045421487,
      ["text"] = "priory1BossNote",
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Arathi Footman",
    ["id"] = 206705,
    ["count"] = 3,
    ["health"] = 102034571,
    ["scale"] = 1,
    ["displayId"] = 120023,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427342] = {
      },
      [427360] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 574.36988719935,
        ["y"] = -226.06979090617,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 739.32626379526,
        ["y"] = -262.81838300497,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 738.98456984402,
        ["y"] = -271.62847927246,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 739.30890435761,
        ["y"] = -280.83132250189,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 739.97485525875,
        ["y"] = -290.46101787616,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 681.02394768626,
        ["y"] = -288.26631386835,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 662.34562765805,
        ["y"] = -275.52641644967,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 661.83339329244,
        ["y"] = -283.17918042337,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 681.40200811425,
        ["y"] = -264.98103219948,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 645.74412651324,
        ["y"] = -291.97918287064,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 654.281060752,
        ["y"] = -292.35349019359,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 645.67344785799,
        ["y"] = -266.64208108113,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 654.39499513631,
        ["y"] = -267.28230597777,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 626.80419046904,
        ["y"] = -318.92720357182,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 630.59488725599,
        ["y"] = -327.10299320349,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 622.2234659402,
        ["y"] = -325.96589111361,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 604.75895890376,
        ["y"] = -270.74371439892,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 608.97645115263,
        ["y"] = -303.09220582395,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 602.90388818168,
        ["y"] = -226.92055209951,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 616.26230185232,
        ["y"] = -226.85134718494,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 609.55663524136,
        ["y"] = -219.49827238123,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 610.02077871216,
        ["y"] = -233.34940328642,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 550.70168636195,
        ["y"] = -157.3675989934,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 550.8344060341,
        ["y"] = -167.12377121213,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 550.56651310017,
        ["y"] = -177.22010652454,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 598.19130303364,
        ["y"] = -211.79651137684,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 607.08179193573,
        ["y"] = -192.96614890771,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 607.04866487454,
        ["y"] = -183.20995694782,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 588.10356277987,
        ["y"] = -178.4844896372,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 605.90472789549,
        ["y"] = -155.44073153704,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 606.29588178969,
        ["y"] = -164.05796657133,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 534.95730835282,
        ["y"] = -209.06584829252,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 537.55145671164,
        ["y"] = -230.75281274202,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 529.52004451881,
        ["y"] = -235.28138440154,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 650.38504959744,
        ["y"] = -222.45978988894,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 659.76547123247,
        ["y"] = -223.22589990976,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 530.47834889487,
        ["y"] = -346.91752980371,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 568.16255919618,
        ["y"] = -354.42340022238,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 606.18802092925,
        ["y"] = -375.55253492178,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 614.43352719619,
        ["y"] = -375.64493440583,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 608.09397405217,
        ["y"] = -408.0753523297,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 615.93774388994,
        ["y"] = -408.01232919504,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 564.94329081992,
        ["y"] = -226.78464037447,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 568.28802065277,
        ["y"] = -332.42598007237,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 555.18239397421,
        ["y"] = -342.53582587325,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Arathi Knight",
    ["id"] = 206696,
    ["count"] = 25,
    ["health"] = 148413922,
    ["scale"] = 1.1,
    ["stealthDetect"] = true,
    ["displayId"] = 120988,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427609] = {
      },
      [427621] = {
        ["bleed"] = true,
      },
      [444296] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 568.20250200584,
        ["y"] = -219.79604672094,
        ["g"] = 63,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 568.20250200584,
            ["y"] = -219.79604672094,
          },
          [2] = {
            ["x"] = 580.46518645616,
            ["y"] = -223.62580217024,
          },
          [3] = {
            ["x"] = 586.63639399699,
            ["y"] = -230.62463199513,
          },
          [4] = {
            ["x"] = 580.46518645616,
            ["y"] = -223.62580217024,
          },
          [5] = {
            ["x"] = 568.20250200584,
            ["y"] = -219.79604672094,
          },
          [6] = {
            ["x"] = 556.27901444619,
            ["y"] = -231.32755900005,
          },
          [7] = {
            ["x"] = 549.92846022965,
            ["y"] = -239.97511006838,
          },
          [8] = {
            ["x"] = 531.82262787216,
            ["y"] = -257.54047724415,
          },
          [9] = {
            ["x"] = 549.92846022965,
            ["y"] = -239.97511006838,
          },
          [10] = {
            ["x"] = 556.27901444619,
            ["y"] = -231.32755900005,
          },
        },
      },
      [2] = {
        ["x"] = 688.02273345775,
        ["y"] = -292.20024246709,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 688.02273345775,
            ["y"] = -292.20024246709,
          },
          [2] = {
            ["x"] = 672.80647332649,
            ["y"] = -293.48042885568,
          },
          [3] = {
            ["x"] = 666.80390085657,
            ["y"] = -302.11825627295,
          },
          [4] = {
            ["x"] = 657.72686558358,
            ["y"] = -308.70644442583,
          },
          [5] = {
            ["x"] = 649.52824602204,
            ["y"] = -311.0488993447,
          },
          [6] = {
            ["x"] = 657.72686558358,
            ["y"] = -308.70644442583,
          },
          [7] = {
            ["x"] = 666.80390085657,
            ["y"] = -302.11825627295,
          },
          [8] = {
            ["x"] = 672.80647332649,
            ["y"] = -293.48042885568,
          },
        },
      },
      [3] = {
        ["x"] = 688.21470676555,
        ["y"] = -269.74126190164,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 688.21470676555,
            ["y"] = -269.74126190164,
          },
          [2] = {
            ["x"] = 672.513673298,
            ["y"] = -266.10286051846,
          },
          [3] = {
            ["x"] = 667.2431165253,
            ["y"] = -259.66110363183,
          },
          [4] = {
            ["x"] = 658.75168130927,
            ["y"] = -254.97616254209,
          },
          [5] = {
            ["x"] = 652.8955244796,
            ["y"] = -252.9265154647,
          },
          [6] = {
            ["x"] = 658.75168130927,
            ["y"] = -254.97616254209,
          },
          [7] = {
            ["x"] = 667.2431165253,
            ["y"] = -259.66110363183,
          },
          [8] = {
            ["x"] = 672.513673298,
            ["y"] = -266.10286051846,
          },
        },
      },
      [4] = {
        ["x"] = 649.99469083285,
        ["y"] = -334.47280164792,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 649.99469083285,
            ["y"] = -334.47280164792,
          },
          [2] = {
            ["x"] = 638.25643533217,
            ["y"] = -330.14401760019,
          },
          [3] = {
            ["x"] = 649.99469083285,
            ["y"] = -334.47280164792,
          },
          [4] = {
            ["x"] = 666.4346754403,
            ["y"] = -331.05303025131,
          },
          [5] = {
            ["x"] = 671.20684330144,
            ["y"] = -321.73598104141,
          },
          [6] = {
            ["x"] = 684.61420083538,
            ["y"] = -309.46482565397,
          },
          [7] = {
            ["x"] = 671.20684330144,
            ["y"] = -321.73598104141,
          },
          [8] = {
            ["x"] = 666.4346754403,
            ["y"] = -331.05303025131,
          },
        },
      },
      [5] = {
        ["x"] = 529.32071626912,
        ["y"] = -226.2261801003,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 529.05047286218,
            ["y"] = -228.52319858426,
          },
          [2] = {
            ["x"] = 540.34849310932,
            ["y"] = -219.98441107726,
          },
          [3] = {
            ["x"] = 552.64422922127,
            ["y"] = -230.25340095507,
          },
          [4] = {
            ["x"] = 540.34849310932,
            ["y"] = -219.98441107726,
          },
          [5] = {
            ["x"] = 529.05047286218,
            ["y"] = -228.52319858426,
          },
          [6] = {
            ["x"] = 515.48671979271,
            ["y"] = -239.44144604801,
          },
          [7] = {
            ["x"] = 528.72830061823,
            ["y"] = -250.92648799274,
          },
          [8] = {
            ["x"] = 515.48671979271,
            ["y"] = -239.44144604801,
          },
        },
      },
      [6] = {
        ["x"] = 681.62815982117,
        ["y"] = -242.16888979478,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 561.61853675763,
        ["y"] = -337.87102711327,
        ["g"] = 64,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 561.61853675763,
            ["y"] = -337.87102711327,
          },
          [2] = {
            ["x"] = 575.76426221453,
            ["y"] = -345.82388857125,
          },
          [3] = {
            ["x"] = 561.61853675763,
            ["y"] = -337.87102711327,
          },
          [4] = {
            ["x"] = 544.40454452665,
            ["y"] = -323.09945757316,
          },
          [5] = {
            ["x"] = 533.4968292896,
            ["y"] = -313.32796873686,
          },
          [6] = {
            ["x"] = 544.40454452665,
            ["y"] = -323.09945757316,
          },
          [7] = {
            ["x"] = 561.61853675763,
            ["y"] = -337.87102711327,
          },
        },
      },
    },
  },
  [3] = {
    ["name"] = "Arathi Neophyte",
    ["id"] = 207943,
    ["count"] = 1,
    ["health"] = 24345039,
    ["scale"] = 0.8,
    ["displayId"] = 121006,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 570.33667052521,
        ["y"] = -398.72264363533,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 577.59340253634,
        ["y"] = -398.67474733194,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 585.12570778638,
        ["y"] = -398.41727304049,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 592.40043350711,
        ["y"] = -398.36937398015,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 592.18484282868,
        ["y"] = -406.16503641243,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 584.95798119696,
        ["y"] = -406.11114003806,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 577.61740624513,
        ["y"] = -405.94948880057,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 570.14508016902,
        ["y"] = -406.35065606353,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 570.19295008658,
        ["y"] = -413.69724116301,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 577.37191395319,
        ["y"] = -413.79304754082,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 584.83826376285,
        ["y"] = -413.7451457281,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 592.46028724831,
        ["y"] = -413.79903222631,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Arathi Neophyte",
    ["id"] = 212838,
    ["count"] = 1,
    ["health"] = 46379351,
    ["scale"] = 0.8,
    ["displayId"] = 121017,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 426.72401600461,
        ["y"] = -274.79930285085,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 433.80624372579,
        ["y"] = -274.89033927738,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 426.59544062821,
        ["y"] = -282.07436567458,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 433.91877133306,
        ["y"] = -282.34221899378,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 426.31156590471,
        ["y"] = -289.66547581911,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 433.69914881035,
        ["y"] = -290.34050979821,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 426.61692108917,
        ["y"] = -297.21379293658,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 433.72593304355,
        ["y"] = -298.39773077859,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Ardent Paladin",
    ["id"] = 206704,
    ["count"] = 14,
    ["health"] = 148413922,
    ["scale"] = 1,
    ["displayId"] = 121023,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [424429] = {
      },
      [424430] = {
      },
      [448791] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 464.33160994156,
        ["y"] = -291.14401445398,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 464.44941872264,
        ["y"] = -300.80837686159,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 428.14906508742,
        ["y"] = -259.61167274322,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 437.52952387161,
        ["y"] = -258.98485985487,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 397.64136644251,
        ["y"] = -245.79330190409,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 427.61092395054,
        ["y"] = -319.17702791264,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 410.58152557339,
        ["y"] = -323.42532694739,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 404.74869034933,
        ["y"] = -331.15224367571,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 352.43785335196,
        ["y"] = -277.93034753001,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 362.0620899369,
        ["y"] = -277.52764776114,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 232.52641967761,
        ["y"] = -277.5900562822,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 231.99716476165,
        ["y"] = -296.40390805831,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 208.53578186603,
        ["y"] = -320.84650483525,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Devout Priest",
    ["id"] = 206697,
    ["count"] = 6,
    ["health"] = 78844896,
    ["scale"] = 1,
    ["displayId"] = 120847,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427356] = {
        ["interruptible"] = true,
      },
      [427357] = {
        ["interruptible"] = true,
      },
      [428916] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [2] = {
        ["x"] = 677.94398686914,
        ["y"] = -317.73555581813,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 654.15050060844,
        ["y"] = -229.67080309145,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 613.04966585953,
        ["y"] = -269.13154259912,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 596.31070136953,
        ["y"] = -277.59954933703,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 614.64685465734,
        ["y"] = -296.4852669458,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 577.49128145999,
        ["y"] = -188.418263949,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 575.93058928822,
            ["y"] = -190.21067112266,
          },
          [2] = {
            ["x"] = 594.18331715362,
            ["y"] = -190.02848979076,
          },
          [3] = {
            ["x"] = 585.58464454082,
            ["y"] = -189.84937580564,
          },
          [4] = {
            ["x"] = 585.58464454082,
            ["y"] = -189.84937580564,
          },
          [5] = {
            ["x"] = 557.28050775219,
            ["y"] = -190.02848979076,
          },
          [6] = {
            ["x"] = 552.9811326933,
            ["y"] = -190.20764252837,
          },
          [7] = {
            ["x"] = 557.28050775219,
            ["y"] = -190.02848979076,
          },
          [8] = {
            ["x"] = 594.18331715362,
            ["y"] = -190.02848979076,
          },
        },
      },
      [8] = {
        ["x"] = 590.17139416542,
        ["y"] = -217.71851229924,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 540.70586360349,
        ["y"] = -214.76482271726,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 508.29111567652,
        ["y"] = -255.46161664619,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 507.49798950989,
        ["y"] = -332.90663061383,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 521.86122067259,
        ["y"] = -348.19231758269,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 541.20300346896,
        ["y"] = -354.77194548416,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 502.09168435644,
        ["y"] = -365.5273218388,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 574.01692245606,
        ["y"] = -359.8308709791,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 591.19183584475,
        ["y"] = -380.56503409785,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 437.10086282516,
        ["y"] = -248.95090608352,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 410.66121874217,
        ["y"] = -246.95278552846,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 436.14333041461,
        ["y"] = -318.98232633475,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 397.57053641171,
        ["y"] = -325.1246847351,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 361.38299972465,
        ["y"] = -286.97650351708,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 352.22140485247,
        ["y"] = -286.9980517052,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 211.75476737955,
        ["y"] = -300.40934922269,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 169.7834748492,
        ["y"] = -297.69453838238,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 169.92100631864,
        ["y"] = -276.97606814305,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 199.10852747772,
        ["y"] = -320.77028508732,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 140.81850689166,
        ["y"] = -269.63577389384,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 141.46993658089,
        ["y"] = -316.55935266475,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Elaena Emberlanz",
    ["id"] = 239833,
    ["count"] = 50,
    ["health"] = 250448493,
    ["scale"] = 1.7,
    ["stealthDetect"] = true,
    ["displayId"] = 118872,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [424431] = {
      },
      [424432] = {
      },
      [448385] = {
      },
      [448515] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 529.72836202331,
        ["y"] = -272.4218561968,
        ["sublevel"] = 1,
        ["constrained"] = {
          ["index"] = 1,
          ["amount"] = 2,
        },
      },
    },
  },
  [8] = {
    ["name"] = "Fanatical Conjuror",
    ["id"] = 206698,
    ["count"] = 6,
    ["health"] = 83482831,
    ["scale"] = 1,
    ["displayId"] = 121005,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427469] = {
        ["interruptible"] = true,
      },
      [427472] = {
      },
      [427473] = {
      },
      [427484] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 596.21644873441,
        ["y"] = -286.16850518949,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 606.09051569955,
        ["y"] = -294.39842615834,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 572.73555713758,
        ["y"] = -260.47507210373,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 581.79864114375,
        ["y"] = -260.83746395056,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 568.75842660056,
        ["y"] = -188.37189913792,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 596.63427360332,
        ["y"] = -178.9846570016,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 516.94022567008,
        ["y"] = -253.38055824277,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 585.19292104871,
        ["y"] = -303.28897986104,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 578.01763300374,
        ["y"] = -303.27310860041,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 512.16640839252,
        ["y"] = -323.5260739783,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 542.6765576889,
        ["y"] = -364.54423107268,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 549.33808263403,
        ["y"] = -358.44637353182,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 507.71925633578,
        ["y"] = -372.45706936167,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 574.6313911868,
        ["y"] = -351.36162170009,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 590.98777747186,
        ["y"] = -389.61899779997,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 570.17749180006,
        ["y"] = -373.77701328911,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 570.28499949103,
        ["y"] = -381.24072153371,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 404.94348638919,
        ["y"] = -239.34094163443,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 403.02273692495,
        ["y"] = -317.67215113732,
        ["g"] = 52,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Fervent Sharpshooter",
    ["id"] = 206694,
    ["count"] = 6,
    ["health"] = 92758701,
    ["scale"] = 1,
    ["displayId"] = 120987,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427629] = {
      },
      [453458] = {
      },
      [453461] = {
        ["bleed"] = true,
      },
      [462859] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 576.29010939946,
        ["y"] = -218.21128388051,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 669.71814433501,
        ["y"] = -279.44251664449,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 650.22501898283,
        ["y"] = -298.54764033086,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 650.19856580994,
        ["y"] = -259.25004066147,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 677.78123915054,
        ["y"] = -327.16099845302,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 685.45601895691,
        ["y"] = -321.22485079752,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 650.24467814667,
        ["y"] = -343.13895913005,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 649.92349172264,
        ["y"] = -326.06278780709,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 606.568151358,
        ["y"] = -261.77666298023,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 588.55180492376,
        ["y"] = -281.50826450694,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 591.67504444712,
        ["y"] = -242.20907494757,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 591.67504444712,
            ["y"] = -242.20907494757,
          },
          [2] = {
            ["x"] = 595.8999058387,
            ["y"] = -237.39538003013,
          },
          [3] = {
            ["x"] = 602.80712793406,
            ["y"] = -232.17975940269,
          },
          [4] = {
            ["x"] = 595.8999058387,
            ["y"] = -237.39538003013,
          },
          [5] = {
            ["x"] = 591.67504444712,
            ["y"] = -242.20907494757,
          },
          [6] = {
            ["x"] = 583.49512416057,
            ["y"] = -248.67247848096,
          },
          [7] = {
            ["x"] = 576.58790206521,
            ["y"] = -252.05560882282,
          },
          [8] = {
            ["x"] = 583.49512416057,
            ["y"] = -248.67247848096,
          },
        },
      },
      [12] = {
        ["x"] = 577.36517128642,
        ["y"] = -196.31360162015,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 590.48651299939,
        ["y"] = -208.63157095462,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 615.07097532296,
        ["y"] = -188.02996597998,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 614.78889276608,
        ["y"] = -175.09636704086,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 588.0259209825,
        ["y"] = -170.35077779846,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 614.12735384266,
        ["y"] = -159.75546831456,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 558.60470714381,
        ["y"] = -245.82865749585,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 551.07246813043,
        ["y"] = -251.42692715793,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 687.6389664578,
        ["y"] = -248.2225150138,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 675.87466419479,
        ["y"] = -235.76167159658,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 553.27556810604,
        ["y"] = -310.97579532183,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 559.67260077345,
        ["y"] = -316.63671347739,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 502.78742792987,
        ["y"] = -323.99122408571,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 523.71223595404,
        ["y"] = -340.01403612802,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 593.63609832591,
        ["y"] = -320.83701031534,
        ["g"] = 44,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 593.63609832591,
            ["y"] = -320.83701031534,
          },
          [2] = {
            ["x"] = 598.22832990149,
            ["y"] = -326.36680259026,
          },
          [3] = {
            ["x"] = 601.0476065307,
            ["y"] = -328.90415639615,
          },
          [4] = {
            ["x"] = 598.22832990149,
            ["y"] = -326.36680259026,
          },
          [5] = {
            ["x"] = 593.63609832591,
            ["y"] = -320.83701031534,
          },
          [6] = {
            ["x"] = 587.65606270696,
            ["y"] = -315.23068168309,
          },
          [7] = {
            ["x"] = 582.58138735918,
            ["y"] = -309.87406737999,
          },
          [8] = {
            ["x"] = 587.65606270696,
            ["y"] = -315.23068168309,
          },
        },
      },
      [27] = {
        ["x"] = 598.84514520451,
        ["y"] = -342.40525641708,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 604.33241662076,
        ["y"] = -336.31657540321,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 609.45873941475,
        ["y"] = -330.85710340088,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 624.96434515788,
        ["y"] = -376.2760907919,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 625.75831570733,
        ["y"] = -391.31619505935,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 626.2966361478,
        ["y"] = -408.28290696314,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 560.19838782948,
        ["y"] = -220.67842632204,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 680.21857207873,
        ["y"] = -272.98873714123,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 552.68434872637,
        ["y"] = -334.41442199559,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 559.74752389235,
        ["y"] = -329.60414937334,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 680.17000552234,
        ["y"] = -296.16462125201,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Forge Master Damian",
    ["id"] = 212831,
    ["count"] = 50,
    ["health"] = 222620883,
    ["scale"] = 1.7,
    ["stealthDetect"] = true,
    ["displayId"] = 118874,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427894] = {
      },
      [427897] = {
        ["magic"] = true,
      },
      [427898] = {
      },
      [427900] = {
      },
      [427950] = {
      },
      [427951] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 574.26857233146,
        ["y"] = -157.01898030824,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Guard Captain Suleyman",
    ["id"] = 212826,
    ["count"] = 50,
    ["health"] = 259724363,
    ["scale"] = 1.7,
    ["stealthDetect"] = true,
    ["displayId"] = 118876,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [448485] = {
      },
      [448492] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 627.66164429613,
        ["y"] = -281.59341300518,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 627.66164429613,
            ["y"] = -281.59341300518,
          },
          [2] = {
            ["x"] = 627.85744670293,
            ["y"] = -271.27293125011,
          },
          [3] = {
            ["x"] = 632.08636971275,
            ["y"] = -265.91631694701,
          },
          [4] = {
            ["x"] = 636.73817695754,
            ["y"] = -260.98258687889,
          },
          [5] = {
            ["x"] = 639.55743745475,
            ["y"] = -258.02236497002,
          },
          [6] = {
            ["x"] = 640.26226064505,
            ["y"] = -251.81995799896,
          },
          [7] = {
            ["x"] = 637.86590051482,
            ["y"] = -247.59105112115,
          },
          [8] = {
            ["x"] = 633.35502241769,
            ["y"] = -243.78502847831,
          },
          [9] = {
            ["x"] = 628.13936952625,
            ["y"] = -238.8513064762,
          },
          [10] = {
            ["x"] = 633.35502241769,
            ["y"] = -243.78502847831,
          },
          [11] = {
            ["x"] = 637.86590051482,
            ["y"] = -247.59105112115,
          },
          [12] = {
            ["x"] = 640.26226064505,
            ["y"] = -251.81995799896,
          },
          [13] = {
            ["x"] = 639.55743745475,
            ["y"] = -258.02236497002,
          },
          [14] = {
            ["x"] = 636.73817695754,
            ["y"] = -260.98258687889,
          },
          [15] = {
            ["x"] = 632.08636971275,
            ["y"] = -265.91631694701,
          },
          [16] = {
            ["x"] = 627.85744670293,
            ["y"] = -271.27293125011,
          },
          [17] = {
            ["x"] = 627.66164429613,
            ["y"] = -281.59341300518,
          },
          [18] = {
            ["x"] = 636.73817695754,
            ["y"] = -281.14037525434,
          },
          [19] = {
            ["x"] = 641.38995193834,
            ["y"] = -280.85844436502,
          },
          [20] = {
            ["x"] = 636.73817695754,
            ["y"] = -281.14037525434,
          },
          [21] = {
            ["x"] = 627.66164429613,
            ["y"] = -281.59341300518,
          },
          [22] = {
            ["x"] = 627.99844037859,
            ["y"] = -290.44398167793,
          },
          [23] = {
            ["x"] = 630.1128776855,
            ["y"] = -294.8138499674,
          },
          [24] = {
            ["x"] = 633.77792278467,
            ["y"] = -298.05599469959,
          },
          [25] = {
            ["x"] = 639.13453708777,
            ["y"] = -302.14394823175,
          },
          [26] = {
            ["x"] = 641.38995193834,
            ["y"] = -304.96322486096,
          },
          [27] = {
            ["x"] = 641.24899052668,
            ["y"] = -309.33308911743,
          },
          [28] = {
            ["x"] = 639.13453708777,
            ["y"] = -313.28007317192,
          },
          [29] = {
            ["x"] = 633.91890032833,
            ["y"] = -321.45596007123,
          },
          [30] = {
            ["x"] = 639.13453708777,
            ["y"] = -313.28007317192,
          },
          [31] = {
            ["x"] = 641.24899052668,
            ["y"] = -309.33308911743,
          },
          [32] = {
            ["x"] = 641.38995193834,
            ["y"] = -304.96322486096,
          },
          [33] = {
            ["x"] = 639.13453708777,
            ["y"] = -302.14394823175,
          },
          [34] = {
            ["x"] = 633.77792278467,
            ["y"] = -298.05599469959,
          },
          [35] = {
            ["x"] = 630.1128776855,
            ["y"] = -294.8138499674,
          },
          [36] = {
            ["x"] = 627.99844037859,
            ["y"] = -290.44398167793,
          },
        },
      },
    },
  },
  [12] = {
    ["name"] = "High Priest Aemya",
    ["id"] = 212827,
    ["count"] = 50,
    ["health"] = 121725195,
    ["scale"] = 1.7,
    ["stealthDetect"] = true,
    ["displayId"] = 118867,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427357] = {
        ["interruptible"] = true,
      },
      [428150] = {
      },
      [428151] = {
      },
      [429091] = {
        ["magic"] = true,
      },
      [464240] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 583.04606991351,
        ["y"] = -431.01008705134,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Lightspawn",
    ["id"] = 206710,
    ["count"] = 18,
    ["health"] = 148413922,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 120878,
    ["creatureType"] = "Elemental",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [427601] = {
      },
      [448787] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 194.00517163162,
        ["y"] = -286.25090519029,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 596.03300873017,
        ["y"] = -170.70980926624,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 510.81728181915,
        ["y"] = -246.63209372769,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 510.12861636095,
        ["y"] = -364.90230723764,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 591.45982814823,
        ["y"] = -373.18298565196,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 570.29734059436,
        ["y"] = -389.7286379344,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 218.9591625051,
        ["y"] = -277.87734740739,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 219.24720542897,
        ["y"] = -296.4732433075,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 206.99033242895,
        ["y"] = -254.13001472975,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Risen Footman",
    ["id"] = 212835,
    ["count"] = 4,
    ["health"] = 111310441,
    ["scale"] = 1,
    ["displayId"] = 116189,
    ["creatureType"] = "Undead",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Shackle Undead"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["spells"] = {
      [435156] = {
      },
      [1217938] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 202.02571869903,
        ["y"] = -291.99178491343,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 198.67887663163,
        ["y"] = -254.00336006087,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 203.64481528705,
        ["y"] = -328.98891552831,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 132.00372356055,
        ["y"] = -260.43423464455,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 131.65770930217,
        ["y"] = -269.55431259324,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 140.98134611189,
        ["y"] = -260.45457472066,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 131.84088845291,
        ["y"] = -306.84889593616,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 132.04449810324,
        ["y"] = -316.35576848187,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 141.18491818433,
        ["y"] = -306.56391401655,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 201.62325794814,
        ["y"] = -283.42462201464,
        ["g"] = 65,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 201.62325794814,
            ["y"] = -283.42462201464,
          },
          [2] = {
            ["x"] = 192.28158293783,
            ["y"] = -269.18217792438,
          },
          [3] = {
            ["x"] = 179.10521444507,
            ["y"] = -263.32601328171,
          },
          [4] = {
            ["x"] = 192.28158293783,
            ["y"] = -269.18217792438,
          },
          [5] = {
            ["x"] = 201.62325794814,
            ["y"] = -283.42462201464,
          },
          [6] = {
            ["x"] = 198.72334763747,
            ["y"] = -302.12307962378,
          },
          [7] = {
            ["x"] = 178.37319093486,
            ["y"] = -311.78575401874,
          },
          [8] = {
            ["x"] = 198.72334763747,
            ["y"] = -302.12307962378,
          },
        },
      },
      [11] = {
        ["x"] = 185.8995645522,
        ["y"] = -265.55779971782,
        ["g"] = 62,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 184.71884514892,
            ["y"] = -262.95210703262,
          },
          [2] = {
            ["x"] = 191.73499957627,
            ["y"] = -263.14897074439,
          },
          [3] = {
            ["x"] = 198.00489973887,
            ["y"] = -263.328123482,
          },
          [4] = {
            ["x"] = 201.05029282761,
            ["y"] = -259.20790116072,
          },
          [5] = {
            ["x"] = 198.00489973887,
            ["y"] = -263.328123482,
          },
          [6] = {
            ["x"] = 191.73499957627,
            ["y"] = -263.14897074439,
          },
          [7] = {
            ["x"] = 184.71884514892,
            ["y"] = -262.95210703262,
          },
          [8] = {
            ["x"] = 174.89583872436,
            ["y"] = -262.61156097218,
          },
          [9] = {
            ["x"] = 170.77562124714,
            ["y"] = -259.20790116072,
          },
          [10] = {
            ["x"] = 172.20873657865,
            ["y"] = -254.90854547808,
          },
          [11] = {
            ["x"] = 170.77562124714,
            ["y"] = -259.20790116072,
          },
          [12] = {
            ["x"] = 174.89583872436,
            ["y"] = -262.61156097218,
          },
        },
      },
      [12] = {
        ["x"] = 232.09184924302,
        ["y"] = -287.15665250112,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Risen Mage",
    ["id"] = 221760,
    ["count"] = 6,
    ["health"] = 83482831,
    ["scale"] = 1,
    ["displayId"] = 116171,
    ["creatureType"] = "Undead",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Shackle Undead"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["spells"] = {
      [427469] = {
        ["interruptible"] = true,
      },
      [435156] = {
      },
      [444743] = {
        ["interruptible"] = true,
      },
      [1217938] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 194.72494957546,
        ["y"] = -277.8015461893,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 219.15137717732,
        ["y"] = -269.02350265352,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 203.23455798066,
        ["y"] = -246.40602121378,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 194.39338754993,
        ["y"] = -295.1021380182,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Sergeant Shaynemail",
    ["id"] = 239836,
    ["count"] = 50,
    ["health"] = 250448493,
    ["scale"] = 1.7,
    ["stealthDetect"] = true,
    ["displayId"] = 118870,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [424423] = {
      },
      [424426] = {
        ["bleed"] = true,
      },
      [424621] = {
      },
      [448385] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 540.3596657693,
        ["y"] = -286.69619870486,
        ["sublevel"] = 1,
        ["constrained"] = {
          ["index"] = 1,
          ["amount"] = 2,
        },
      },
    },
  },
  [17] = {
    ["name"] = "Sir Braunpyke",
    ["id"] = 217658,
    ["count"] = 50,
    ["health"] = 250448493,
    ["scale"] = 1.4,
    ["displayId"] = 116186,
    ["creatureType"] = "Undead",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [435156] = {
      },
      [435165] = {
      },
      [451763] = {
      },
      [451764] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 173.88520043006,
        ["y"] = -287.75499169252,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Taener Duelmal",
    ["id"] = 239834,
    ["count"] = 50,
    ["health"] = 146070234,
    ["scale"] = 1.7,
    ["stealthDetect"] = true,
    ["displayId"] = 118873,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [424421] = {
        ["interruptible"] = true,
      },
      [424460] = {
      },
      [424462] = {
      },
      [448385] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 530.53433620569,
        ["y"] = -299.57159119063,
        ["sublevel"] = 1,
        ["constrained"] = {
          ["index"] = 1,
          ["amount"] = 2,
        },
      },
    },
  },
  [19] = {
    ["name"] = "War Lynx",
    ["id"] = 206699,
    ["count"] = 6,
    ["health"] = 74206961,
    ["scale"] = 1,
    ["displayId"] = 121012,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [427635] = {
        ["bleed"] = true,
      },
      [446776] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 656.70609873362,
        ["y"] = -339.47330898222,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 657.16333408229,
        ["y"] = -331.26299126068,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 582.90939781644,
        ["y"] = -242.3884106871,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 590.62776738652,
        ["y"] = -250.61014905403,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 568.67848950716,
        ["y"] = -196.72821061472,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 560.31895169186,
        ["y"] = -254.63658392021,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 566.60284122165,
        ["y"] = -247.70828293143,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 553.10696413803,
        ["y"] = -259.34027852116,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 679.76919063721,
        ["y"] = -249.66359107948,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 673.22818444566,
        ["y"] = -244.23138019418,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 560.91337146873,
        ["y"] = -308.78660290287,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 566.75978127389,
        ["y"] = -314.56004026311,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 555.31081826775,
        ["y"] = -303.24710115849,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 591.96575586249,
        ["y"] = -312.41040282138,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 584.3346484773,
        ["y"] = -320.69710089915,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Zealous Templar",
    ["id"] = 207949,
    ["count"] = 10,
    ["health"] = 120586312,
    ["scale"] = 1,
    ["displayId"] = 121024,
    ["creatureType"] = "Humanoid",
    ["level"] = 81,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [427596] = {
      },
      [427597] = {
      },
      [444728] = {
        ["magic"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 464.32086103141,
        ["y"] = -272.55450472739,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 464.39050941883,
        ["y"] = -281.89208487118,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 428.03116823035,
        ["y"] = -249.55621778886,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 403.76634302454,
        ["y"] = -253.15734493666,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 427.77914908154,
        ["y"] = -328.4086447691,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 436.27611648099,
        ["y"] = -328.58566470738,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 352.28535782476,
        ["y"] = -296.9711603394,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 361.87120246507,
        ["y"] = -296.72519093153,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 211.10496021299,
        ["y"] = -273.29205825652,
        ["g"] = 56,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 218.96113143725,
        ["y"] = -305.43089116289,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Captain Dailcry",
    ["id"] = 207946,
    ["count"] = 0,
    ["health"] = 835240800,
    ["scale"] = 1.5,
    ["displayId"] = 118879,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2570,
    ["instanceID"] = 1267,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [424414] = {
        ["bleed"] = true,
      },
      [424419] = {
        ["enrage"] = true,
      },
      [447439] = {
      },
      [447443] = {
      },
      [448385] = {
      },
      [462855] = {
      },
      [1238780] = {
      },
      [1238781] = {
      },
      [1238782] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 511.51965469826,
        ["y"] = -287.92409023365,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Baron Braunpyke",
    ["id"] = 207939,
    ["count"] = 0,
    ["health"] = 649631734,
    ["scale"] = 2,
    ["displayId"] = 118878,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2570,
    ["instanceID"] = 1267,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [422969] = {
      },
      [423015] = {
      },
      [423019] = {
      },
      [423051] = {
        ["interruptible"] = true,
      },
      [423062] = {
      },
      [423076] = {
      },
      [423121] = {
      },
      [446368] = {
      },
      [446525] = {
      },
      [446649] = {
      },
      [446657] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 399.27414096233,
        ["y"] = -287.50012575351,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Prioress Murrpray",
    ["id"] = 207940,
    ["count"] = 0,
    ["health"] = 649631734,
    ["scale"] = 2,
    ["displayId"] = 118877,
    ["creatureType"] = "Humanoid",
    ["level"] = 82,
    ["isBoss"] = true,
    ["encounterID"] = 2570,
    ["instanceID"] = 1267,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [423536] = {
        ["interruptible"] = true,
      },
      [423547] = {
      },
      [423588] = {
      },
      [423664] = {
      },
      [423665] = {
      },
      [423682] = {
      },
      [425554] = {
      },
      [425556] = {
      },
      [428169] = {
      },
      [428170] = {
        ["magic"] = true,
      },
      [429091] = {
        ["magic"] = true,
      },
      [444546] = {
      },
      [444608] = {
      },
      [444609] = {
      },
      [451605] = {
      },
      [451606] = {
        ["magic"] = true,
      },
      [1242783] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 87.763033206228,
        ["y"] = -288.46139923906,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Arathi Neophyte",
    ["id"] = 211140,
    ["count"] = 0,
    ["health"] = 123678278,
    ["scale"] = 1.5,
    ["displayId"] = 115544,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [425018] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 98.06356380679,
        ["y"] = -323.39363660883,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 78.493212110286,
        ["y"] = -323.12123459102,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 59.235675211556,
        ["y"] = -323.56901951111,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 39.530208070926,
        ["y"] = -323.12118615042,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 100.4378218341,
        ["y"] = -254.60013883207,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 80.732378913775,
        ["y"] = -254.60013883207,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 60.57917529365,
        ["y"] = -253.70442367007,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 41.32161417462,
        ["y"] = -253.25656608907,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
    },
  },
};
