local addonName = ...
local MDT = MDT
local L = MDT.L

local dungeonIndex = 114
MDT.dungeonList[dungeonIndex] = L["CityOfThreads"]
MDT.mapInfo[dungeonIndex] = {
  teleportId = 445416,
  shortName = L["cityOfThreadsShortName"],
  englishName = "City of Threads",
  mapID = 502
}

local zones = { 2343 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'Interface\\AddOns\\'..addonName..'\\TheWarWithin\\Textures\\CityOfThreads' }
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["CityOfThreads"]
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 742 }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "dungeonEntrance",
      ["x"] = 320.77680262201,
      ["y"] = -83.954249381602,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "cityOfThreadsItem",
      ["x"] = 502.76705118943,
      ["y"] = -118.51498924243,
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "cityOfThreadsItem",
      ["x"] = 435.54496374703,
      ["y"] = -259.54267223567,
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "cityOfThreadsItem",
      ["x"] = 326.12725031554,
      ["y"] = -143.49639416954,
    },
    [5] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "cityOfThreadsItem",
      ["x"] = 430.16808643823,
      ["y"] = -167.16077396436,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Sureki Silkbinder",
    ["id"] = 220195,
    ["count"] = 10,
    ["health"] = 17106549,
    ["scale"] = 1.2,
    ["displayId"] = 120872,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [443427] = {
        ["interruptible"] = true,
      },
      [443430] = {
        ["interruptible"] = true,
      },
      [443432] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 451.4765460876,
        ["y"] = -133.526044858,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 318.10631385106,
        ["y"] = -114.23451225126,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 360.54261546401,
        ["y"] = -136.42504871122,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 348.67341323059,
        ["y"] = -123.09533234122,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 410.9083838323,
        ["y"] = -116.67193357225,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 431.33785684581,
        ["y"] = -95.578803866687,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 452.09240422817,
        ["y"] = -110.64910014347,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 408.39202097437,
        ["y"] = -146.09569888148,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 421.58248178641,
        ["y"] = -193.42135957558,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 437.42488726213,
        ["y"] = -193.82039621576,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 445.66882753185,
        ["y"] = -174.78218933701,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 444.98803191928,
        ["y"] = -157.7595791287,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 403.90096960131,
        ["y"] = -222.02225807081,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 409.36282304983,
        ["y"] = -252.76713104965,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 437.08782393997,
        ["y"] = -223.14927463878,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 450.56798019181,
        ["y"] = -241.34172850943,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 469.89340161809,
        ["y"] = -96.362643548083,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 469.2992840934,
        ["y"] = -144.45181347796,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 476.499931396,
        ["y"] = -165.47495609525,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 521.71921082979,
        ["y"] = -127.53086546089,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 522.12082625122,
        ["y"] = -163.95097240788,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 504.53248594099,
        ["y"] = -186.50183038287,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Sureki Venomblade",
    ["id"] = 220193,
    ["count"] = 10,
    ["health"] = 18300028,
    ["scale"] = 1.2,
    ["displayId"] = 120868,
    ["creatureType"] = "Uncategorized",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [443397] = {
      },
      [443401] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 437.53023314252,
        ["y"] = -84.817812200389,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 330.54568084632,
        ["y"] = -114.00523582679,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 348.19787677626,
        ["y"] = -136.14413980952,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 360.60310167356,
        ["y"] = -123.50466302097,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 402.69279543263,
        ["y"] = -108.66769580492,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 424.88549722468,
        ["y"] = -84.973501232144,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 452.39695827938,
        ["y"] = -121.58725234085,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 376.92540816773,
        ["y"] = -173.11274485754,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 376.23108964195,
        ["y"] = -184.43705451556,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 398.56890619532,
        ["y"] = -252.57136416349,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 443.50283414443,
        ["y"] = -232.38792041713,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 469.63386688568,
        ["y"] = -114.51342312988,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 473.10092677221,
        ["y"] = -155.19457893364,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 534.34246224768,
        ["y"] = -141.52519908564,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 534.63339009179,
        ["y"] = -152.85776579459,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 493.19753247535,
        ["y"] = -186.9369583349,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 515.60572562131,
        ["y"] = -185.83163292645,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Royal Swarmguard",
    ["id"] = 220197,
    ["count"] = 20,
    ["health"] = 35804403,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 120882,
    ["creatureType"] = "Demon",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [443500] = {
      },
      [443507] = {
      },
      [443509] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 381.57331823335,
        ["y"] = -140.6587871295,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 409.09244897585,
        ["y"] = -176.24164097428,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 412.45071573533,
            ["y"] = -172.60348929333,
          },
          [2] = {
            ["x"] = 397.21685044009,
            ["y"] = -192.03888688542,
          },
          [3] = {
            ["x"] = 412.45071573533,
            ["y"] = -172.60348929333,
          },
          [4] = {
            ["x"] = 424.57807442444,
            ["y"] = -150.34556869342,
          },
          [5] = {
            ["x"] = 429.26855725028,
            ["y"] = -138.35872980499,
          },
          [6] = {
            ["x"] = 424.57807442444,
            ["y"] = -150.34556869342,
          },
        },
      },
      [3] = {
        ["x"] = 429.20949667903,
        ["y"] = -184.92615175494,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 432.20151846411,
        ["y"] = -243.6519432105,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 428.54414992713,
            ["y"] = -253.95884068713,
          },
          [2] = {
            ["x"] = 436.30430930164,
            ["y"] = -245.19790547487,
          },
          [3] = {
            ["x"] = 432.65615908294,
            ["y"] = -235.03515560209,
          },
          [4] = {
            ["x"] = 423.79629020334,
            ["y"] = -230.08405485871,
          },
          [5] = {
            ["x"] = 415.97880955607,
            ["y"] = -236.33805050157,
          },
          [6] = {
            ["x"] = 415.4576293462,
            ["y"] = -241.81031754851,
          },
          [7] = {
            ["x"] = 418.32405096899,
            ["y"] = -248.06429928507,
          },
        },
      },
      [5] = {
        ["x"] = 475.85495883165,
        ["y"] = -199.74887698242,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 480.01073339538,
        ["y"] = -105.77882400181,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 484.82649211766,
        ["y"] = -150.97552843675,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Herald Of Ansurek",
    ["id"] = 220196,
    ["count"] = 20,
    ["health"] = 31826136,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 120905,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [443433] = {
        ["interruptible"] = true,
      },
      [443434] = {
      },
      [443435] = {
      },
      [443436] = {
      },
      [443437] = {
      },
      [443438] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 381.55830603601,
        ["y"] = -105.06011625593,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 386.57477906911,
        ["y"] = -179.09215290538,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 454.51646105312,
        ["y"] = -164.47675160777,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 452.34612617429,
        ["y"] = -224.70774219114,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 464.83870641429,
        ["y"] = -209.66324493708,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 514.4502536282,
        ["y"] = -143.90209444741,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 505.01042294315,
        ["y"] = -174.07240140385,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 465.52851755631,
        ["y"] = -508.24931053054,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Xephitik",
    ["id"] = 219984,
    ["count"] = 8,
    ["health"] = 29837003,
    ["scale"] = 1.8,
    ["displayId"] = 119732,
    ["creatureType"] = "Uncategorized",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [443427] = {
        ["interruptible"] = true,
      },
      [450783] = {
      },
      [450784] = {
      },
      [451423] = {
      },
      [451426] = {
      },
      [451428] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 546.21057551008,
        ["y"] = -279.41542988887,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Eye Of The Queen",
    ["id"] = 219983,
    ["count"] = 20,
    ["health"] = 35804403,
    ["scale"] = 2,
    ["displayId"] = 119371,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [451218] = {
      },
      [451222] = {
      },
      [451295] = {
      },
      [451309] = {
      },
      [451543] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 577.97067515285,
        ["y"] = -308.04840487015,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 619.64438725022,
        ["y"] = -269.42662070969,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 694.22218830512,
        ["y"] = -334.09191696474,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 538.41799585652,
        ["y"] = -333.83687028083,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Web Marauder",
    ["id"] = 223182,
    ["count"] = 14,
    ["health"] = 25858736,
    ["scale"] = 1.2,
    ["displayId"] = 119369,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [452151] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 626.85500816484,
        ["y"] = -285.39579299489,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 702.17769395911,
        ["y"] = -349.0203064651,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 549.44135384003,
        ["y"] = -346.10740952458,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Agile Pursuer",
    ["id"] = 223181,
    ["count"] = 14,
    ["health"] = 19891335,
    ["scale"] = 1.2,
    ["displayId"] = 119370,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [448030] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 608.91565492159,
        ["y"] = -283.30158599053,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 538.65131955419,
        ["y"] = -357.65498470642,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 564.74986548261,
        ["y"] = -488.41081015408,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 546.07080917696,
        ["y"] = -498.98813531447,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Congealed Droplet",
    ["id"] = 216329,
    ["count"] = 1,
    ["health"] = 3978267,
    ["scale"] = 1,
    ["displayId"] = 114555,
    ["creatureType"] = "Aberration",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 128.58211954926,
        ["y"] = -398.93294183623,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 137.32658960901,
        ["y"] = -399.27270578124,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 146.57597672434,
        ["y"] = -399.53654549824,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 155.82056677392,
        ["y"] = -399.4419173516,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 164.94550124257,
        ["y"] = -399.50515040183,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 128.55253929784,
        ["y"] = -408.83293596219,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 137.19513790361,
        ["y"] = -409.09776565608,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 146.3732628173,
        ["y"] = -409.2526117933,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 155.14659194462,
        ["y"] = -408.87207204603,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 164.60435894059,
        ["y"] = -408.88386150768,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Battle Scarab",
    ["id"] = 220199,
    ["count"] = 1,
    ["health"] = 3978267,
    ["scale"] = 0.6,
    ["displayId"] = 120589,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 347.79495817058,
        ["y"] = -82.126346667752,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 347.65521188299,
        ["y"] = -87.851934441246,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 353.01956290316,
        ["y"] = -85.354968756505,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 377.23633622684,
        ["y"] = -150.73285476639,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 384.99156740614,
        ["y"] = -151.1992685466,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 392.59198797327,
        ["y"] = -137.74585587744,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 391.25638785119,
        ["y"] = -146.82504566656,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 411.20061314681,
        ["y"] = -130.14795566727,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 415.77381399913,
        ["y"] = -133.42230384756,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 415.84456890249,
        ["y"] = -127.33448677927,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 456.00006162779,
        ["y"] = -84.226079615091,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 456.00711936614,
        ["y"] = -91.961341056629,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 450.48407258717,
        ["y"] = -87.883966382081,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 403.98519797922,
        ["y"] = -166.51372597322,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 409.92445497977,
        ["y"] = -164.75880679634,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 416.31807173687,
        ["y"] = -166.77046740674,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 418.73836718432,
        ["y"] = -172.82608346945,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 419.7214499069,
        ["y"] = -203.19490878998,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 425.52347366513,
        ["y"] = -202.86251322878,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 431.05658039519,
        ["y"] = -202.97530520173,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 429.59213523318,
        ["y"] = -195.67314101311,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 437.46375883968,
        ["y"] = -202.9673240577,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 406.64143686958,
        ["y"] = -232.29044895126,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 400.47419260974,
        ["y"] = -232.58600366786,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 406.34602914826,
        ["y"] = -238.5220448374,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 400.68841874335,
        ["y"] = -238.61954955364,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 406.61824233198,
        ["y"] = -245.07219813785,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 400.35553694371,
        ["y"] = -244.83905384089,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 452.60314188073,
        ["y"] = -204.70544283759,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 457.14335474568,
        ["y"] = -201.28578149795,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 461.33476869424,
        ["y"] = -197.76750210841,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 466.1527141876,
        ["y"] = -194.15721911826,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 470.53942436951,
        ["y"] = -190.48227215312,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 474.67209776057,
        ["y"] = -187.04444484564,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 466.62370689051,
        ["y"] = -200.11724095475,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 483.69473235429,
        ["y"] = -213.29190558166,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 479.23759421511,
        ["y"] = -217.28676395191,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 474.74079638802,
        ["y"] = -221.66023743213,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 488.36446924778,
        ["y"] = -209.44033511914,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 487.41268653411,
        ["y"] = -217.527617885,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 479.0239581541,
        ["y"] = -226.08145921246,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 483.00717100731,
        ["y"] = -221.76406297873,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [43] = {
        ["x"] = 496.10055230877,
        ["y"] = -209.25960384541,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [44] = {
        ["x"] = 492.02874975215,
        ["y"] = -213.71072597995,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [45] = {
        ["x"] = 469.74860772799,
        ["y"] = -104.94679772597,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [46] = {
        ["x"] = 478.69607540674,
        ["y"] = -95.712152382808,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [47] = {
        ["x"] = 478.24265078363,
        ["y"] = -116.13985736637,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [48] = {
        ["x"] = 478.48161889113,
        ["y"] = -141.90190934282,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [49] = {
        ["x"] = 484.37819403223,
        ["y"] = -139.8261328566,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [50] = {
        ["x"] = 485.32537018547,
        ["y"] = -162.09067834432,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Covert Webmancer",
    ["id"] = 223844,
    ["count"] = 14,
    ["health"] = 19891335,
    ["scale"] = 1.2,
    ["displayId"] = 118106,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [442536] = {
        ["interruptible"] = true,
      },
      [452162] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 684.85391683828,
        ["y"] = -347.81318905529,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 526.91661612815,
        ["y"] = -347.77539816356,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Sureki Conscript",
    ["id"] = 223357,
    ["count"] = 3,
    ["health"] = 11934801,
    ["scale"] = 0.7,
    ["displayId"] = 120886,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [451238] = {
      },
      [451239] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 553.52691109297,
        ["y"] = -445.50490329211,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 556.93950669139,
        ["y"] = -450.99105569787,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 559.90255287283,
        ["y"] = -456.90746893266,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 563.30603384299,
        ["y"] = -463.03772994667,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 529.19528090149,
        ["y"] = -459.15638996604,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 534.98162572206,
        ["y"] = -456.32434810408,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 535.92047102739,
        ["y"] = -449.44766569583,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 535.25710750509,
        ["y"] = -471.994173015,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 535.80970373567,
        ["y"] = -479.03222555027,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 528.95627520244,
        ["y"] = -469.65637199499,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 507.95723481219,
        ["y"] = -489.77079273442,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 514.3717173929,
        ["y"] = -489.36549220875,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 520.83470083087,
        ["y"] = -489.34514524,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 527.36122431225,
        ["y"] = -489.26239834662,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 542.74371831276,
        ["y"] = -490.56666814083,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 548.50467968349,
        ["y"] = -487.46466467564,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 553.85608494259,
        ["y"] = -484.0719331035,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 559.33364909595,
        ["y"] = -480.91263613307,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 532.61733806682,
        ["y"] = -520.08158894647,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 528.07340027917,
        ["y"] = -514.12018425042,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 521.7154464477,
        ["y"] = -514.1609844526,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 516.85540878098,
        ["y"] = -519.29315304315,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 501.41414017904,
        ["y"] = -508.32895995488,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 501.75836908907,
        ["y"] = -515.16456333291,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 507.95883779492,
        ["y"] = -508.49443490273,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 508.0675169793,
        ["y"] = -515.13959965298,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 464.74946941793,
        ["y"] = -497.43252538396,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 472.505420767,
        ["y"] = -500.37828247803,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 475.56920750379,
        ["y"] = -508.11194112218,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Royal Venomshell",
    ["id"] = 220730,
    ["count"] = 20,
    ["health"] = 39782670,
    ["scale"] = 1.4,
    ["displayId"] = 120890,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434133] = {
      },
      [434137] = {
      },
      [443500] = {
      },
      [461630] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 515.85483162086,
        ["y"] = -546.31938738382,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Skittering Assistant",
    ["id"] = 216342,
    ["count"] = 3,
    ["health"] = 7956534,
    ["scale"] = 1,
    ["displayId"] = 120891,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [453583] = {
      },
      [453584] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 212.54929377167,
        ["y"] = -381.40892272904,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 220.1471613378,
        ["y"] = -376.05079363549,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 227.13693492523,
        ["y"] = -370.27329098172,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 191.5726761829,
        ["y"] = -450.00678285187,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 193.67439807832,
        ["y"] = -440.65116222987,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 201.32058109821,
        ["y"] = -446.61593075314,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 208.74554100343,
        ["y"] = -453.87709917286,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 199.47261031165,
        ["y"] = -456.15619646262,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 107.32377126597,
        ["y"] = -333.41346696677,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 114.39978257602,
        ["y"] = -339.06020406817,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 120.71062623811,
        ["y"] = -346.2245347332,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Unstable Test Subject",
    ["id"] = 216328,
    ["count"] = 20,
    ["health"] = 31826136,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 116499,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [436205] = {
      },
      [436246] = {
      },
      [445812] = {
      },
      [445813] = {
      },
      [445838] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 106.75596359699,
        ["y"] = -349.07785365944,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 226.78347094964,
        ["y"] = -386.68846769038,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 186.40033255352,
        ["y"] = -462.27043666058,
        ["g"] = 47,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Sureki Unnaturaler",
    ["id"] = 216339,
    ["count"] = 6,
    ["health"] = 15913068,
    ["scale"] = 1.2,
    ["displayId"] = 120894,
    ["creatureType"] = "Uncategorized",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [446086] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 179.39272431496,
        ["y"] = -349.61445492025,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 206.79002789214,
        ["y"] = -349.32813319517,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 85.96320732132,
        ["y"] = -455.37268259935,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 100.24378952071,
        ["y"] = -465.66086144043,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 64.218576881834,
        ["y"] = -391.52880633598,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 64.433098732165,
        ["y"] = -403.53242026847,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 64.848325608255,
        ["y"] = -415.05955270121,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 80.21843364451,
        ["y"] = -355.55818913474,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 79.948979087556,
        ["y"] = -378.19623560459,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Elder Shadeweaver",
    ["id"] = 221102,
    ["count"] = 40,
    ["health"] = 39782670,
    ["scale"] = 2,
    ["displayId"] = 118827,
    ["creatureType"] = "Demon",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [443427] = {
        ["interruptible"] = true,
      },
      [444428] = {
      },
      [446717] = {
      },
      [446718] = {
      },
      [446726] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 167.7927778296,
        ["y"] = -498.85046592382,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Hulking Warshell",
    ["id"] = 221103,
    ["count"] = 40,
    ["health"] = 55695738,
    ["scale"] = 2,
    ["displayId"] = 118826,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [443507] = {
      },
      [443509] = {
      },
      [444428] = {
      },
      [447271] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 133.45929048378,
        ["y"] = -499.15195499653,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Orator Krixvizk",
    ["id"] = 216619,
    ["count"] = 0,
    ["health"] = 139239345,
    ["scale"] = 1.2,
    ["displayId"] = 116692,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2594,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [434691] = {
      },
      [434710] = {
      },
      [434722] = {
      },
      [434723] = {
      },
      [434779] = {
      },
      [434829] = {
      },
      [434832] = {
      },
      [434926] = {
      },
      [440310] = {
      },
      [448560] = {
      },
      [448561] = {
      },
      [448562] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 504.97935481258,
        ["y"] = -235.04948518216,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Nx",
    ["id"] = 216648,
    ["count"] = 0,
    ["health"] = 218804685,
    ["scale"] = 1.5,
    ["displayId"] = 116699,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2595,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [439518] = {
      },
      [439522] = {
      },
      [439621] = {
      },
      [439686] = {
      },
      [439687] = {
      },
      [439692] = {
      },
      [439696] = {
      },
      [439697] = {
      },
      [440049] = {
      },
      [440107] = {
      },
      [441381] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 629.54955808077,
        ["y"] = -427.61602925928,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Vx",
    ["id"] = 216649,
    ["count"] = 0,
    ["health"] = 218804685,
    ["scale"] = 1.5,
    ["displayId"] = 116700,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2595,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [439518] = {
      },
      [440049] = {
      },
      [440107] = {
      },
      [440218] = {
      },
      [440238] = {
      },
      [440468] = {
      },
      [441295] = {
      },
      [441298] = {
      },
      [441305] = {
      },
      [441384] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 659.46898694165,
        ["y"] = -425.94445203024,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Izo The Grand Splicer",
    ["id"] = 216658,
    ["count"] = 0,
    ["health"] = 159130680,
    ["scale"] = 1.5,
    ["displayId"] = 116701,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2596,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [437700] = {
      },
      [438860] = {
      },
      [439324] = {
      },
      [439341] = {
      },
      [439401] = {
      },
      [439481] = {
      },
      [439646] = {
      },
      [439763] = {
      },
      [439764] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 149.96892185382,
        ["y"] = -537.40814474773,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "The Coaglamation",
    ["id"] = 216320,
    ["count"] = 0,
    ["health"] = 159130680,
    ["scale"] = 1.5,
    ["displayId"] = 117254,
    ["creatureType"] = "Elemental",
    ["level"] = 80,
    ["isBoss"] = true,
    ["encounterID"] = 2600,
    ["instanceID"] = 0,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [437533] = {
      },
      [441289] = {
      },
      [441395] = {
      },
      [442285] = {
      },
      [443150] = {
      },
      [447146] = {
      },
      [461825] = {
      },
      [461842] = {
      },
      [461880] = {
      },
      [461989] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 150.18795209979,
        ["y"] = -440.71186273661,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Ravenous Scarab",
    ["id"] = 219198,
    ["count"] = 0,
    ["health"] = 3978267,
    ["scale"] = 1.5,
    ["displayId"] = 116480,
    ["creatureType"] = "Beast",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [450042] = {
      },
      [450047] = {
      },
      [450055] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 170.30552861225,
        ["y"] = -541.67363091606,
        ["sublevel"] = 1,
      },
    },
  },
  [25] = {
    ["name"] = "Web Marauder",
    ["id"] = 224731,
    ["count"] = 14,
    ["health"] = 25858736,
    ["scale"] = 1,
    ["displayId"] = 119369,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [452151] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 565.40725305934,
        ["y"] = -449.95596499799,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 554.66387570133,
        ["y"] = -492.73059839868,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 510.70442620969,
        ["y"] = -461.49442462239,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 524.656667113,
        ["y"] = -521.78670150065,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
    },
  },
  [26] = {
    ["name"] = "Covert Webmancer",
    ["id"] = 224732,
    ["count"] = 14,
    ["health"] = 19891335,
    ["scale"] = 1,
    ["displayId"] = 118106,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [442536] = {
        ["interruptible"] = true,
      },
      [452162] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 528.48933629987,
        ["y"] = -477.59846922745,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 522.47974909764,
        ["y"] = -497.25564192064,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 508.59383909787,
        ["y"] = -452.2753855534,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 491.7403766692,
        ["y"] = -468.97614303541,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 528.87159786888,
        ["y"] = -529.86934759458,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 519.20533908694,
        ["y"] = -529.63515808426,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
    },
  },
  [27] = {
    ["name"] = "Agile Pursuer",
    ["id"] = 228361,
    ["count"] = 14,
    ["health"] = 19891335,
    ["scale"] = 1,
    ["displayId"] = 119370,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [448030] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 527.90184509018,
        ["y"] = -450.7840969097,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 513.53483180673,
        ["y"] = -497.62491579883,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 497.35844149877,
        ["y"] = -476.82722104408,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
    },
  },
  [28] = {
    ["name"] = "Retired Lord Vul'azak",
    ["id"] = 220423,
    ["count"] = 20,
    ["health"] = 32727423,
    ["scale"] = 2.1,
    ["stealthDetect"] = true,
    ["displayId"] = 120885,
    ["creatureType"] = "Humanoid",
    ["level"] = 80,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [443500] = {
      },
      [443507] = {
      },
      [443509] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 606.11356453925,
        ["y"] = -333.21987216065,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 606.11356453925,
            ["y"] = -333.21987216065,
          },
          [2] = {
            ["x"] = 583.3776216858,
            ["y"] = -343.2553960812,
          },
          [3] = {
            ["x"] = 606.11356453925,
            ["y"] = -333.21987216065,
          },
          [4] = {
            ["x"] = 619.02534132222,
            ["y"] = -318.4999985254,
          },
          [5] = {
            ["x"] = 639.32491263877,
            ["y"] = -306.61740769862,
          },
          [6] = {
            ["x"] = 667.05085221341,
            ["y"] = -311.07341889161,
          },
          [7] = {
            ["x"] = 639.32491263877,
            ["y"] = -306.61740769862,
          },
          [8] = {
            ["x"] = 619.02534132222,
            ["y"] = -318.4999985254,
          },
        },
      },
    },
  },
};
