local MDT = MDT
local L = MDT.L
local dungeonIndex = 32
MDT.dungeonList[dungeonIndex] = L["Plaguefall"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides =
  {
    [1] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 115.34848613406,
      verticalPan = 37.921958997821,
    },
  }
};

local zones = { 1674, 1697 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.scaleMultiplier[dungeonIndex] = 0.6

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "Plaguefall",
  [1] = "Plaguefall",
  [2] = "Plaguefall_B",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Plaguefall"],
  [2] = L["The Festering Sanctum"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 600, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 465.69301622737,
      ["y"] = -454.01866110977,
      ["target"] = 2,
      ["direction"] = -1,
      ["connectionIndex"] = 1,
    },
  },
  [2] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 465.53583053408,
      ["y"] = -243.85217912137,
      ["target"] = 1,
      ["direction"] = 1,
      ["connectionIndex"] = 1,
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Plaguebound Fallen",
    ["id"] = 168968,
    ["count"] = 0,
    ["health"] = 33039,
    ["scale"] = 0.6,
    ["displayId"] = 96986,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [331871] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 265.31859240626,
        ["y"] = -114.12496935191,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 270.74374058787,
        ["y"] = -120.36665070046,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 265.30068292683,
        ["y"] = -117.12380185849,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 267.78044147134,
        ["y"] = -119.41855037842,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 271.50359664821,
        ["y"] = -123.1338069989,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 302.07189947352,
        ["y"] = -134.37272613933,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Fungret Shroomtender",
    ["id"] = 168365,
    ["count"] = 0,
    ["health"] = 24779,
    ["scale"] = 0.6,
    ["displayId"] = 83592,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 283.98841819292,
        ["y"] = -108.39013250299,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 296.46263414634,
        ["y"] = -111.47918343455,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 303.45040732959,
        ["y"] = -119.87008651214,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Mire Soldier",
    ["id"] = 169696,
    ["count"] = 8,
    ["health"] = 132156,
    ["scale"] = 1,
    ["displayId"] = 83596,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [330417] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 299.07157181537,
        ["y"] = -116.59372091646,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 301.20417004098,
        ["y"] = -113.64620802918,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 351.34414485775,
        ["y"] = -132.87993338916,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 351.14458536585,
        ["y"] = -116.45375722543,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 343.54124065103,
        ["y"] = -127.14833985717,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 370.78638626053,
        ["y"] = -109.99871310716,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Gushing Slime",
    ["id"] = 168969,
    ["count"] = 1,
    ["health"] = 49559,
    ["scale"] = 0.7,
    ["displayId"] = 95785,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [328660] = {
      },
      [328662] = {
      },
      [346989] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 284.00915170758,
        ["y"] = -140.48346121326,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 397.70157843902,
        ["y"] = -96.283303297631,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 399.64997594475,
        ["y"] = -93.469133042359,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 398.40335792029,
        ["y"] = -89.432127229936,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 400.71332876502,
        ["y"] = -98.093309368353,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 410.14012336947,
        ["y"] = -96.074308541217,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 407.36312195122,
        ["y"] = -90.581912636277,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [8] = {
        ["x"] = 405.65154730876,
        ["y"] = -86.487909817884,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 413.7695943042,
        ["y"] = -93.552355160014,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 404.40742502255,
        ["y"] = -95.866609847032,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 405.99951550852,
        ["y"] = -99.09299352724,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 402.38342788929,
        ["y"] = -88.03499355493,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 412.19461184276,
        ["y"] = -90.164348723887,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 409.42063723641,
        ["y"] = -87.980601576096,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 412.34109037587,
        ["y"] = -87.177548159169,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 402.42153758877,
        ["y"] = -91.7530499711,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 414.01560886436,
        ["y"] = -97.812538925794,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 409.34102945531,
        ["y"] = -99.313616006827,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [19] = {
        ["x"] = 411.54581284801,
        ["y"] = -100.88022632029,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 403.44061582457,
        ["y"] = -101.64395843203,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 407.4662244656,
        ["y"] = -94.489182264532,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 472.32585365854,
        ["y"] = -297.46733006512,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [23] = {
        ["x"] = 458.62708591444,
        ["y"] = -299.16331467926,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 440.45912195122,
        ["y"] = -347.75316455696,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 469.8515866241,
        ["y"] = -355.44372988434,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 470.9850569402,
        ["y"] = -319.66016786968,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 423.79024390244,
        ["y"] = -363.41190458769,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 427.69513929465,
        ["y"] = -374.85030572235,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Plaguebound",
    ["id"] = 168155,
    ["count"] = 0,
    ["health"] = 165414,
    ["scale"] = 0.5,
    ["displayId"] = 96251,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 306.04273170732,
        ["y"] = -138.47589083193,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 305.0191382609,
        ["y"] = -136.13648438603,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Plagueroc",
    ["id"] = 168153,
    ["count"] = 12,
    ["health"] = 231273,
    ["scale"] = 1,
    ["displayId"] = 96752,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [327882] = {
      },
      [330403] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 284.86707168175,
        ["y"] = -132.40463635649,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 315.55726829268,
        ["y"] = -144.76212775298,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 376.76590508401,
        ["y"] = -126.55289367038,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 459.67258536585,
        ["y"] = -133.02619448306,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 424.43765853659,
        ["y"] = -385.51119484891,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 430.57580487805,
        ["y"] = -419.28956610814,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 412.14497560976,
        ["y"] = -401.54759640009,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 334.59892925403,
        ["y"] = -116.78178947386,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 359.49279124282,
        ["y"] = -101.9640223537,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Decaying Flesh Giant",
    ["id"] = 163882,
    ["count"] = 14,
    ["health"] = 297351,
    ["scale"] = 1.5,
    ["stealthDetect"] = true,
    ["displayId"] = 99191,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [320040] = {
      },
      [320072] = {
      },
      [329239] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 327.3150089591,
        ["y"] = -124.83981603523,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 327.3150089591,
            ["y"] = -124.83981603523,
          },
          [2] = {
            ["x"] = 334.16647126079,
            ["y"] = -128.55458277376,
          },
          [3] = {
            ["x"] = 344.31041672892,
            ["y"] = -130.41018391412,
          },
          [4] = {
            ["x"] = 351.85652962571,
            ["y"] = -127.93604906031,
          },
          [5] = {
            ["x"] = 356.8047887155,
            ["y"] = -123.11148768806,
          },
          [6] = {
            ["x"] = 351.85652962571,
            ["y"] = -127.93604906031,
          },
          [7] = {
            ["x"] = 344.31041672892,
            ["y"] = -130.41018391412,
          },
          [8] = {
            ["x"] = 334.16647126079,
            ["y"] = -128.55458277376,
          },
          [9] = {
            ["x"] = 327.3150089591,
            ["y"] = -124.83981603523,
          },
          [10] = {
            ["x"] = 328.97078488244,
            ["y"] = -116.30762480346,
          },
          [11] = {
            ["x"] = 333.54794020179,
            ["y"] = -106.78221039432,
          },
          [12] = {
            ["x"] = 342.45482355194,
            ["y"] = -99.854639174356,
          },
          [13] = {
            ["x"] = 333.54794020179,
            ["y"] = -106.78221039432,
          },
          [14] = {
            ["x"] = 328.97078488244,
            ["y"] = -116.30762480346,
          },
        },
      },
      [2] = {
        ["x"] = 469.72972821944,
        ["y"] = -326.05698781209,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Fungi Stormer",
    ["id"] = 168572,
    ["count"] = 8,
    ["health"] = 132156,
    ["scale"] = 1,
    ["displayId"] = 83621,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [330423] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 356.48244864547,
        ["y"] = -118.76847819519,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 355.46342292123,
        ["y"] = -133.69968672466,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 340.81026818516,
        ["y"] = -122.71715211227,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 375.56571013002,
        ["y"] = -109.50989709013,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Fungalmancer",
    ["id"] = 168578,
    ["count"] = 8,
    ["health"] = 198234,
    ["scale"] = 1.3,
    ["displayId"] = 83616,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [328015] = {
      },
      [328016] = {
        ["interruptible"] = true,
      },
      [329917] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 340.42912697063,
        ["y"] = -129.55981684044,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 352.62300855403,
        ["y"] = -120.62051565761,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 366.37096965138,
        ["y"] = -113.51747989998,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
    },
  },
  [10] = {
    ["name"] = "Plagueborer",
    ["id"] = 168580,
    ["count"] = 8,
    ["health"] = 132156,
    ["scale"] = 1,
    ["displayId"] = 97079,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [344003] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 329.30375973909,
        ["y"] = -111.00579022831,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [2] = {
        ["x"] = 336.37214447216,
        ["y"] = -100.89984733656,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 351.28491667896,
        ["y"] = -94.838229880129,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 365.54419614024,
        ["y"] = -88.997148896034,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 371.27237541493,
        ["y"] = -91.274314317921,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 361.20169411449,
        ["y"] = -68.317835217614,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Fen Hornet",
    ["id"] = 168361,
    ["count"] = 8,
    ["health"] = 132156,
    ["scale"] = 1,
    ["displayId"] = 63503,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [327515] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 323.89612499331,
        ["y"] = -109.82680025626,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 336.95500688554,
        ["y"] = -95.480456897986,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 314.86162806413,
        ["y"] = -96.269863076711,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 318.81361428924,
        ["y"] = -93.124300147373,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 354.81452112075,
        ["y"] = -91.928793816899,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 368.24600796308,
        ["y"] = -84.222575793532,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 359.68506415457,
        ["y"] = -74.415883054029,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 364.74496679867,
        ["y"] = -61.189114227181,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 329.62928156653,
        ["y"] = -89.989034183382,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 377.16733585627,
        ["y"] = -72.15580184481,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Hatchling Nest",
    ["id"] = 163915,
    ["count"] = 10,
    ["health"] = 165195,
    ["scale"] = 1,
    ["displayId"] = 99163,
    ["creatureType"] = "Not specified",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 326.71727497543,
        ["y"] = -106.0306813965,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 328.92728011043,
        ["y"] = -85.424995643525,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 317.88933089392,
        ["y"] = -100.07018928969,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 349.59284634637,
        ["y"] = -89.683353083541,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 372.93124897047,
        ["y"] = -87.030099596775,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 322.36276884019,
        ["y"] = -96.612310880845,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 363.59057263665,
        ["y"] = -75.128715327837,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 340.70630249237,
        ["y"] = -98.534422590617,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 365.19684544817,
        ["y"] = -64.952582753709,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 335.13951219512,
        ["y"] = -79.999268310529,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 373.30675110641,
        ["y"] = -75.136440463469,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Pestilent Harvester",
    ["id"] = 168574,
    ["count"] = 8,
    ["health"] = 198234,
    ["scale"] = 1.3,
    ["displayId"] = 96887,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [327995] = {
      },
      [328002] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 359.32558786729,
        ["y"] = -129.98937146502,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 369.00482859831,
        ["y"] = -117.50977726906,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Finger Food",
    ["id"] = 171474,
    ["count"] = 0,
    ["health"] = 512105,
    ["scale"] = 1,
    ["displayId"] = 95789,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [334640] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 389.3912195122,
        ["y"] = -73.542474573791,
        ["sublevel"] = 1,
      },
    },
  },
  [15] = {
    ["name"] = "Plaguebelcher",
    ["id"] = 168396,
    ["count"] = 12,
    ["health"] = 264312,
    ["scale"] = 1.5,
    ["displayId"] = 96244,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [327233] = {
      },
      [327581] = {
      },
      [327594] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 417.35440465416,
        ["y"] = -81.35147114482,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 417.35440465416,
            ["y"] = -81.35147114482,
          },
          [2] = {
            ["x"] = 421.19143870491,
            ["y"] = -84.979988504945,
          },
          [3] = {
            ["x"] = 422.87870590435,
            ["y"] = -89.52265967195,
          },
          [4] = {
            ["x"] = 421.19143870491,
            ["y"] = -84.979988504945,
          },
          [5] = {
            ["x"] = 417.35440465416,
            ["y"] = -81.35147114482,
          },
          [6] = {
            ["x"] = 411.19754988348,
            ["y"] = -79.009634849192,
          },
          [7] = {
            ["x"] = 404.57822888099,
            ["y"] = -79.269197279847,
          },
          [8] = {
            ["x"] = 401.46324577274,
            ["y"] = -81.086267974652,
          },
          [9] = {
            ["x"] = 397.82911552315,
            ["y"] = -84.071458727552,
          },
          [10] = {
            ["x"] = 394.06519291821,
            ["y"] = -88.743922249902,
          },
          [11] = {
            ["x"] = 397.82911552315,
            ["y"] = -84.071458727552,
          },
          [12] = {
            ["x"] = 401.46324577274,
            ["y"] = -81.086267974652,
          },
          [13] = {
            ["x"] = 404.57822888099,
            ["y"] = -79.269197279847,
          },
          [14] = {
            ["x"] = 411.19754988348,
            ["y"] = -79.009634849192,
          },
        },
      },
      [2] = {
        ["x"] = 420.28921499286,
        ["y"] = -105.41056520271,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 420.28921499286,
            ["y"] = -105.41056520271,
          },
          [2] = {
            ["x"] = 422.74892468902,
            ["y"] = -100.94424769216,
          },
          [3] = {
            ["x"] = 423.39787532574,
            ["y"] = -96.271773029788,
          },
          [4] = {
            ["x"] = 422.74892468902,
            ["y"] = -100.94424769216,
          },
          [5] = {
            ["x"] = 420.28921499286,
            ["y"] = -105.41056520271,
          },
          [6] = {
            ["x"] = 415.22106833913,
            ["y"] = -108.21250819134,
          },
          [7] = {
            ["x"] = 411.06775752813,
            ["y"] = -108.73167761272,
          },
          [8] = {
            ["x"] = 404.57822888099,
            ["y"] = -108.99125675341,
          },
          [9] = {
            ["x"] = 398.8674432259,
            ["y"] = -107.43376519928,
          },
          [10] = {
            ["x"] = 393.54602349683,
            ["y"] = -101.98256425489,
          },
          [11] = {
            ["x"] = 398.8674432259,
            ["y"] = -107.43376519928,
          },
          [12] = {
            ["x"] = 404.57822888099,
            ["y"] = -108.99125675341,
          },
          [13] = {
            ["x"] = 411.06775752813,
            ["y"] = -108.73167761272,
          },
          [14] = {
            ["x"] = 415.22106833913,
            ["y"] = -108.21250819134,
          },
        },
      },
      [3] = {
        ["x"] = 414.47648780488,
        ["y"] = -358.94494036731,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Globgrog",
    ["id"] = 164255,
    ["count"] = 0,
    ["health"] = 935598,
    ["scale"] = 1,
    ["displayId"] = 95844,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2419,
    ["instanceID"] = 1183,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [319780] = {
      },
      [324459] = {
      },
      [324490] = {
      },
      [324527] = {
      },
      [324652] = {
      },
      [324667] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 432.00995121951,
        ["y"] = -93.603204799883,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Unstable Canister",
    ["id"] = 169159,
    ["count"] = 0,
    ["health"] = 8260,
    ["scale"] = 0.6,
    ["displayId"] = 99464,
    ["creatureType"] = "Not specified",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [328986] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 449.85336750056,
        ["y"] = -138.10832570569,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 493.13326829268,
        ["y"] = -131.47900051218,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 489.49928166962,
        ["y"] = -141.48252685905,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 483.85229268293,
        ["y"] = -153.72854320626,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 538.50556097561,
        ["y"] = -148.91234360138,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 546.99980487805,
        ["y"] = -147.13774054291,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Rotting Slimeclaw",
    ["id"] = 163892,
    ["count"] = 6,
    ["health"] = 132156,
    ["scale"] = 1,
    ["displayId"] = 97796,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [320512] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 453.5396161177,
        ["y"] = -141.23508597401,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 449.33214162567,
        ["y"] = -142.88976992423,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 452.9316322593,
        ["y"] = -136.08525549095,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 477.01501804585,
        ["y"] = -131.07794100618,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 480.0372957718,
        ["y"] = -138.11573458027,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 509.84879703416,
        ["y"] = -120.97884265861,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 504.68644112299,
        ["y"] = -121.09084601677,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 511.94350905522,
        ["y"] = -128.09166433331,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 515.14489613431,
        ["y"] = -134.07664409016,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 527.24399989887,
        ["y"] = -114.03714208776,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 522.56604878049,
        ["y"] = -114.52077998098,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 530.80764468933,
        ["y"] = -229.29595086022,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Rigged Plagueborer",
    ["id"] = 168878,
    ["count"] = 8,
    ["health"] = 132156,
    ["scale"] = 1,
    ["displayId"] = 97079,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [328501] = {
      },
      [334926] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 468.70475012539,
        ["y"] = -153.0986560598,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 465.74891935058,
        ["y"] = -157.17977139386,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 480.83426042598,
        ["y"] = -155.58040170299,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 479.18213000245,
        ["y"] = -162.0430864911,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Blighted Spinebreaker",
    ["id"] = 163894,
    ["count"] = 12,
    ["health"] = 264312,
    ["scale"] = 1.5,
    ["displayId"] = 95475,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [318949] = {
      },
      [320517] = {
      },
      [332581] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 461.36546951417,
        ["y"] = -147.69639652777,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 461.36546951417,
            ["y"] = -147.69639652777,
          },
          [2] = {
            ["x"] = 464.10234772756,
            ["y"] = -153.21120719754,
          },
          [3] = {
            ["x"] = 461.36546951417,
            ["y"] = -147.69639652777,
          },
          [4] = {
            ["x"] = 465.4021778939,
            ["y"] = -142.6942952979,
          },
          [5] = {
            ["x"] = 471.07423599316,
            ["y"] = -137.73124699665,
          },
          [6] = {
            ["x"] = 465.4021778939,
            ["y"] = -142.6942952979,
          },
        },
      },
      [2] = {
        ["x"] = 509.69399123069,
        ["y"] = -109.50238223463,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 509.69399123069,
            ["y"] = -109.50238223463,
          },
          [2] = {
            ["x"] = 516.95380977464,
            ["y"] = -107.85414078796,
          },
          [3] = {
            ["x"] = 522.44738690393,
            ["y"] = -108.82359639126,
          },
          [4] = {
            ["x"] = 516.95380977464,
            ["y"] = -107.85414078796,
          },
          [5] = {
            ["x"] = 509.69399123069,
            ["y"] = -109.50238223463,
          },
          [6] = {
            ["x"] = 502.08880536649,
            ["y"] = -113.83245265299,
          },
          [7] = {
            ["x"] = 496.11049350146,
            ["y"] = -120.45707749902,
          },
          [8] = {
            ["x"] = 494.81788140767,
            ["y"] = -125.78909025125,
          },
          [9] = {
            ["x"] = 496.11049350146,
            ["y"] = -120.45707749902,
          },
          [10] = {
            ["x"] = 502.08880536649,
            ["y"] = -113.83245265299,
          },
        },
      },
      [3] = {
        ["x"] = 517.22264750072,
        ["y"] = -129.59456897833,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 489.3925592072,
        ["y"] = -240.07154676417,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Plaguebinder",
    ["id"] = 168627,
    ["count"] = 8,
    ["health"] = 132155,
    ["scale"] = 1,
    ["displayId"] = 96459,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [328094] = {
        ["interruptible"] = true,
      },
      [328180] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 475.92322857336,
        ["y"] = -135.7955205792,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [2] = {
        ["x"] = 482.93750112458,
        ["y"] = -159.39610144832,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [3] = {
        ["x"] = 501.43419879591,
        ["y"] = -134.5623545947,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["inspiring"] = true,
        ["patrol"] = {
          [1] = {
            ["x"] = 501.43419879591,
            ["y"] = -134.5623545947,
          },
          [2] = {
            ["x"] = 495.36196015164,
            ["y"] = -133.18586449495,
          },
          [3] = {
            ["x"] = 501.43419879591,
            ["y"] = -134.5623545947,
          },
          [4] = {
            ["x"] = 505.99704119615,
            ["y"] = -133.30402856862,
          },
          [5] = {
            ["x"] = 509.77840311992,
            ["y"] = -132.24051640721,
          },
          [6] = {
            ["x"] = 510.36923870186,
            ["y"] = -136.49455491045,
          },
          [7] = {
            ["x"] = 509.06938825071,
            ["y"] = -139.09423552794,
          },
          [8] = {
            ["x"] = 504.34268331039,
            ["y"] = -142.63926423318,
          },
          [9] = {
            ["x"] = 504.34268331039,
            ["y"] = -142.63926423318,
          },
          [10] = {
            ["x"] = 509.06938825071,
            ["y"] = -139.09423552794,
          },
          [11] = {
            ["x"] = 510.36923870186,
            ["y"] = -136.49455491045,
          },
          [12] = {
            ["x"] = 509.77840311992,
            ["y"] = -132.24051640721,
          },
          [13] = {
            ["x"] = 505.99704119615,
            ["y"] = -133.30402856862,
          },
        },
      },
      [4] = {
        ["x"] = 515.93116764425,
        ["y"] = -123.81726968817,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 489.96160863438,
        ["y"] = -154.20633134398,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 489.96160863438,
            ["y"] = -154.20633134398,
          },
          [2] = {
            ["x"] = 491.28088592077,
            ["y"] = -149.3116710577,
          },
          [3] = {
            ["x"] = 489.96160863438,
            ["y"] = -154.20633134398,
          },
          [4] = {
            ["x"] = 485.13618166924,
            ["y"] = -156.2835542521,
          },
          [5] = {
            ["x"] = 478.16428326123,
            ["y"] = -158.52873757739,
          },
          [6] = {
            ["x"] = 472.13774815458,
            ["y"] = -157.70156877692,
          },
          [7] = {
            ["x"] = 468.59271437814,
            ["y"] = -156.2835542521,
          },
          [8] = {
            ["x"] = 472.13774815458,
            ["y"] = -157.70156877692,
          },
          [9] = {
            ["x"] = 478.16428326123,
            ["y"] = -158.52873757739,
          },
          [10] = {
            ["x"] = 485.13618166924,
            ["y"] = -156.2835542521,
          },
        },
      },
      [6] = {
        ["x"] = 500.417472786,
        ["y"] = -212.52949114825,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [7] = {
        ["x"] = 534.35545374488,
        ["y"] = -232.44102184085,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 529.62187598197,
        ["y"] = -234.44624410771,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 485.16563493014,
        ["y"] = -233.51144678486,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Pestilence Slime",
    ["id"] = 164705,
    ["count"] = 6,
    ["health"] = 132156,
    ["scale"] = 1,
    ["displayId"] = 33010,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [321999] = {
        ["interruptible"] = true,
      },
      [331967] = {
      },
      [340356] = {
      },
      [346989] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 493.62292532272,
        ["y"] = -157.26780900968,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 502.64031943836,
        ["y"] = -216.25398516626,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 380.77647918188,
        ["y"] = -82.276849315068,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
    },
  },
  [23] = {
    ["name"] = "Rotmarrow Slime",
    ["id"] = 163891,
    ["count"] = 6,
    ["health"] = 132156,
    ["scale"] = 1,
    ["displayId"] = 97477,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [319070] = {
        ["interruptible"] = true,
      },
      [328662] = {
      },
      [346989] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 489.24496005355,
        ["y"] = -132.99437470818,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 487.84108485143,
        ["y"] = -128.68910095143,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 491.77653514526,
        ["y"] = -126.7039816666,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 495.13205111024,
        ["y"] = -146.3725480582,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 489.70482180229,
        ["y"] = -145.74502110254,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 492.99755417186,
        ["y"] = -142.44056610791,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 380.39298758218,
        ["y"] = -148.7704109589,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
    },
  },
  [24] = {
    ["name"] = "Congealed Slime",
    ["id"] = 164707,
    ["count"] = 6,
    ["health"] = 132156,
    ["scale"] = 1,
    ["displayId"] = 95787,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [321935] = {
      },
      [328175] = {
      },
      [346989] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 499.96089576842,
        ["y"] = -138.40374755191,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 504.69641878971,
        ["y"] = -210.81620808319,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 380.02483564646,
        ["y"] = -114.05630136986,
        ["g"] = 46,
        ["sublevel"] = 2,
      },
    },
  },
  [25] = {
    ["name"] = "Slime Tentacle",
    ["id"] = 168022,
    ["count"] = 10,
    ["health"] = 181715,
    ["scale"] = 1.5,
    ["displayId"] = 95688,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [319898] = {
        ["interruptible"] = true,
      },
      [329224] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 535.30946341463,
        ["y"] = -143.85249140265,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 545.47141463415,
        ["y"] = -154.45950098778,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 468.70494066189,
        ["y"] = -302.96453456152,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 452.96487804878,
        ["y"] = -310.41746542767,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 431.78048780488,
        ["y"] = -338.33599180508,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 483.79902439024,
        ["y"] = -313.02454818175,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 490.77948611095,
        ["y"] = -302.13674577973,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 495.51804878049,
        ["y"] = -289.06131557767,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 457.51317073171,
        ["y"] = -336.41925806688,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 524.29847405256,
        ["y"] = -152.87597632885,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 529.15854710293,
        ["y"] = -165.24711273585,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 546.28603163461,
        ["y"] = -136.89367950848,
        ["sublevel"] = 1,
      },
    },
  },
  [26] = {
    ["name"] = "Virulax Blightweaver",
    ["id"] = 168886,
    ["count"] = 25,
    ["health"] = 317172,
    ["scale"] = 1,
    ["displayId"] = 96985,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [320529] = {
      },
      [320576] = {
      },
      [328094] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 537.58770731707,
        ["y"] = -179.77500548767,
        ["sublevel"] = 1,
      },
    },
  },
  [27] = {
    ["name"] = "Doctor Ickus",
    ["id"] = 164967,
    ["count"] = 0,
    ["health"] = 924047,
    ["scale"] = 1,
    ["displayId"] = 96919,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2403,
    ["instanceID"] = 1183,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [322358] = {
        ["interruptible"] = true,
      },
      [329110] = {
      },
      [330026] = {
      },
      [332617] = {
      },
      [333808] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 520.12998557667,
        ["y"] = -252.48784980471,
        ["sublevel"] = 1,
      },
    },
  },
  [28] = {
    ["name"] = "Defender of Many Eyes",
    ["id"] = 163862,
    ["count"] = 8,
    ["health"] = 181715,
    ["scale"] = 1,
    ["displayId"] = 96445,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [328533] = {
      },
      [336451] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 426.95211609951,
        ["y"] = -365.18211108266,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 455.06745919158,
        ["y"] = -300.98265665052,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 441.47226688588,
        ["y"] = -352.38715828053,
        ["g"] = 37,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [4] = {
        ["x"] = 474.28625175849,
        ["y"] = -353.92617284545,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 463.59116711873,
        ["y"] = -325.36991311068,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 475.50429814686,
        ["y"] = -328.50297872974,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 431.02405605182,
        ["y"] = -378.12503402157,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 473.86816353298,
        ["y"] = -401.43858988635,
        ["g"] = 45,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
      [9] = {
        ["x"] = 455.94611505295,
        ["y"] = -406.22566854897,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 478.37028809897,
        ["y"] = -382.29376642372,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 439.50215141636,
        ["y"] = -386.68210313448,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
    },
  },
  [29] = {
    ["name"] = "Venomous Sniper",
    ["id"] = 167493,
    ["count"] = 8,
    ["health"] = 148676,
    ["scale"] = 1,
    ["displayId"] = 96116,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [328338] = {
      },
      [328365] = {
      },
      [328395] = {
        ["interruptible"] = true,
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 492.91626791628,
        ["y"] = -342.49740572651,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 448.1390577323,
        ["y"] = -322.48457122551,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 471.29662346868,
        ["y"] = -333.06559919892,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 419.20904544528,
        ["y"] = -373.340147268,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 439.23291556205,
        ["y"] = -375.09685433332,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 478.23030201839,
        ["y"] = -409.65613054699,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 450.67024390244,
        ["y"] = -401.97804931587,
        ["g"] = 44,
        ["sublevel"] = 1,
        ["inspiring"] = true,
      },
    },
  },
  [30] = {
    ["name"] = "Venomfang",
    ["id"] = 168747,
    ["count"] = 0,
    ["health"] = 283079,
    ["scale"] = 0.6,
    ["displayId"] = 94406,
    ["creatureType"] = "Beast",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [328342] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 448.75545086974,
        ["y"] = -327.57855446406,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 492.15664897327,
        ["y"] = -337.77805343811,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 465.97185975329,
        ["y"] = -331.85003259355,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 443.71417895747,
        ["y"] = -375.74477155265,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 474.10731381056,
        ["y"] = -410.89283823325,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 449.5315546023,
        ["y"] = -398.30995299765,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 416.25773970986,
        ["y"] = -370.07098384654,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
    },
  },
  [31] = {
    ["name"] = "Brood Ambusher",
    ["id"] = 164737,
    ["count"] = 12,
    ["health"] = 165195,
    ["scale"] = 1,
    ["displayId"] = 96434,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [328400] = {
      },
      [328475] = {
        ["interruptible"] = true,
      },
      [328539] = {
      },
      [338079] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 442.34967943972,
        ["y"] = -364.3473725234,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 462.11805590326,
        ["y"] = -388.47226867038,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 478.09691496114,
        ["y"] = -404.19777302284,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 449.47565705719,
        ["y"] = -407.70250151655,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
    },
  },
  [32] = {
    ["name"] = "Domina Venomblade",
    ["id"] = 164266,
    ["count"] = 0,
    ["health"] = 1155058,
    ["scale"] = 1,
    ["displayId"] = 96475,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2423,
    ["instanceID"] = 1183,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [325245] = {
      },
      [325550] = {
      },
      [325552] = {
      },
      [328539] = {
      },
      [332313] = {
      },
      [336258] = {
      },
      [336306] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 466.07707317073,
        ["y"] = -433.6488256384,
        ["sublevel"] = 1,
      },
    },
  },
  [33] = {
    ["name"] = "Plaguebound Devoted",
    ["id"] = 163857,
    ["count"] = 4,
    ["health"] = 39647,
    ["scale"] = 1,
    ["displayId"] = 96988,
    ["creatureType"] = "Undead",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Control Undead"] = true,
      ["Silence"] = true,
      ["Shackle Undead"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [340702] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 444.20598977356,
        ["y"] = -259.32945205479,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 443.60771058641,
        ["y"] = -397.9138421885,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 437.59459459459,
        ["y"] = -401.45506849315,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [4] = {
        ["x"] = 446.14003858811,
        ["y"] = -404.42539260983,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [5] = {
        ["x"] = 435.67777831787,
        ["y"] = -395.45582594408,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
      [6] = {
        ["x"] = 461.70854638422,
        ["y"] = -432.73440593699,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [7] = {
        ["x"] = 421.01280326734,
        ["y"] = -448.71897005696,
        ["g"] = 50,
        ["sublevel"] = 2,
      },
      [8] = {
        ["x"] = 460.41987032455,
        ["y"] = -441.51260650171,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [9] = {
        ["x"] = 417.65264665072,
        ["y"] = -443.13193376241,
        ["g"] = 50,
        ["sublevel"] = 2,
      },
      [10] = {
        ["x"] = 424.17445549472,
        ["y"] = -453.48438828408,
        ["g"] = 50,
        ["sublevel"] = 2,
      },
      [11] = {
        ["x"] = 414.14029645134,
        ["y"] = -449.11400022057,
        ["g"] = 50,
        ["sublevel"] = 2,
      },
      [12] = {
        ["x"] = 466.77063550036,
        ["y"] = -443.04009998634,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [13] = {
        ["x"] = 467.36865772477,
        ["y"] = -432.04156341455,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [14] = {
        ["x"] = 465.60528618282,
        ["y"] = -437.96944119217,
        ["g"] = 49,
        ["sublevel"] = 2,
      },
      [15] = {
        ["x"] = 417.91295579296,
        ["y"] = -453.73513181928,
        ["g"] = 50,
        ["sublevel"] = 2,
      },
      [16] = {
        ["x"] = 437.57823954977,
        ["y"] = -259.52005204769,
        ["g"] = 47,
        ["sublevel"] = 2,
      },
      [17] = {
        ["x"] = 431.65634435712,
        ["y"] = -402.60356194726,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
    },
  },
  [34] = {
    ["name"] = "Ickor Bileflesh",
    ["id"] = 169861,
    ["count"] = 25,
    ["health"] = 317172,
    ["scale"] = 1.5,
    ["displayId"] = 94145,
    ["creatureType"] = "Humanoid",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [328094] = {
        ["interruptible"] = true,
      },
      [330786] = {
      },
      [330816] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 437.94740686633,
        ["y"] = -410.21342465753,
        ["g"] = 48,
        ["sublevel"] = 2,
      },
    },
  },
  [35] = {
    ["name"] = "Margrave Stradama",
    ["id"] = 164267,
    ["count"] = 0,
    ["health"] = 1056053,
    ["scale"] = 1,
    ["displayId"] = 95794,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["isBoss"] = true,
    ["encounterID"] = 2404,
    ["instanceID"] = 1183,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [322232] = {
      },
      [322304] = {
      },
      [322491] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 441.37763071444,
        ["y"] = -439.44631642946,
        ["sublevel"] = 2,
      },
    },
  },
  [36] = {
    ["name"] = "Slime Tentacle",
    ["id"] = 168907,
    ["count"] = 10,
    ["health"] = 181715,
    ["scale"] = 1.5,
    ["displayId"] = 95688,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [319898] = {
        ["interruptible"] = true,
      },
      [329224] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 478.08531722173,
        ["y"] = -389.41260322269,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
    },
  },
  [37] = {
    ["name"] = "Plaguebelcher",
    ["id"] = 173360,
    ["count"] = 0,
    ["health"] = 128160,
    ["scale"] = 1.5,
    ["displayId"] = 96244,
    ["creatureType"] = "Aberration",
    ["level"] = 60,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [327233] = {
      },
      [327581] = {
      },
      [327594] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 440.5917807123,
        ["y"] = -392.81631844775,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
    },
  },
  [38] = {
    ["name"] = "Executioner Varruth",
    ["id"] = 179890,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 92418,
    ["iconTexture"] = 237552,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [357575] = {
        ["dps"] = true,
        ["healer"] = true,
        ["tank"] = true,
      },
      [357604] = {
        ["tank"] = true,
      },
      [357609] = {
        ["dps"] = true,
      },
      [357706] = {
        ["dps"] = true,
      },
      [357747] = {
        ["healer"] = true,
      },
      [357847] = {
        ["healer"] = true,
      },
      [357863] = {
        ["tank"] = true,
      },
    },
    ["spells"] = {
      [355714] = {
      },
      [356923] = {
      },
      [356925] = {
      },
      [358971] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 493.33518549204,
        ["y"] = -263.39073876864,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 365.62249442263,
        ["y"] = -96.330604482266,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [39] = {
    ["name"] = "Oros Coldheart",
    ["id"] = 179892,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 97237,
    ["iconTexture"] = 136213,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [357815] = {
        ["dps"] = true,
        ["healer"] = true,
      },
      [357817] = {
        ["tank"] = true,
      },
      [357820] = {
        ["tank"] = true,
      },
      [357825] = {
        ["dps"] = true,
      },
      [357829] = {
        ["healer"] = true,
      },
      [357834] = {
        ["dps"] = true,
        ["tank"] = true,
      },
      [357842] = {
        ["healer"] = true,
      },
    },
    ["spells"] = {
      [355710] = {
      },
      [356414] = {
      },
      [356666] = {
      },
      [358894] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 526.87699972842,
        ["y"] = -120.4487443875,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 474.45940882119,
        ["y"] = -365.64881855542,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [40] = {
    ["name"] = "Soggodon the Breaker",
    ["id"] = 179891,
    ["count"] = 0,
    ["health"] = 358540,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 98535,
    ["iconTexture"] = 2103898,
    ["creatureType"] = "Humanoid",
    ["level"] = 62,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [356827] = {
        ["dps"] = true,
        ["healer"] = true,
      },
      [356828] = {
        ["dps"] = true,
        ["tank"] = true,
      },
      [357524] = {
        ["dps"] = true,
        ["healer"] = true,
        ["tank"] = true,
      },
      [357556] = {
        ["healer"] = true,
      },
      [357778] = {
        ["tank"] = true,
      },
    },
    ["spells"] = {
      [355719] = {
      },
      [355806] = {
      },
      [358784] = {
      },
      [358968] = {
      },
      [358970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 474.45940882119,
        ["y"] = -365.64881855542,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 526.87699972842,
        ["y"] = -120.4487443875,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [41] = {
    ["name"] = "Incinerator Arkolath",
    ["id"] = 179446,
    ["count"] = 0,
    ["health"] = 336131,
    ["ignoreFortified"] = true,
    ["scale"] = 1.5,
    ["displayId"] = 100718,
    ["iconTexture"] = 236297,
    ["creatureType"] = "Humanoid",
    ["level"] = 61,
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 128,
    },
    ["powers"] = {
      [357575] = {
        ["dps"] = true,
        ["healer"] = true,
        ["tank"] = true,
      },
      [357839] = {
        ["tank"] = true,
      },
      [357848] = {
        ["dps"] = true,
      },
      [357864] = {
        ["dps"] = true,
      },
      [357889] = {
        ["healer"] = true,
      },
      [357897] = {
        ["tank"] = true,
      },
      [357900] = {
        ["healer"] = true,
      },
    },
    ["spells"] = {
      [355707] = {
      },
      [355732] = {
      },
      [355737] = {
      },
      [358967] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 365.62249442263,
        ["y"] = -96.330604482266,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 493.33518549204,
        ["y"] = -263.39073876864,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [42] = {
    ["name"] = "Wo Relic",
    ["id"] = 185683,
    ["count"] = 0,
    ["health"] = 33039,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 101046,
    ["iconTexture"] = 4335644,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368241,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.6,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366566] = {
      },
      [368078] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 360.28762380823,
        ["y"] = -84.414989676334,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 352.54127186189,
        ["y"] = -109.54118665478,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 392.86207807011,
        ["y"] = -85.728535969622,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 441.5254353656,
        ["y"] = -93.271526396325,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 469.6009339622,
        ["y"] = -136.08863651783,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 478.01513174158,
        ["y"] = -168.88613260332,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 534.43209696708,
        ["y"] = -186.79703136425,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 516.65892268043,
        ["y"] = -263.62675963261,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 449.93218004061,
        ["y"] = -294.92667185546,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 449.57671828645,
        ["y"] = -374.84150457996,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 462.43887557508,
        ["y"] = -395.202593872,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 443.59399193176,
        ["y"] = -412.79981029751,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 478.01256864138,
        ["y"] = -416.86963487758,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 464.77354042616,
        ["y"] = -422.3475206823,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 440.44481960756,
        ["y"] = -427.72799167457,
        ["sublevel"] = 2,
      },
      [16] = {
        ["x"] = 435.16446313092,
        ["y"] = -388.1834539436,
        ["sublevel"] = 2,
      },
    },
  },
  [43] = {
    ["name"] = "Urh Relic",
    ["id"] = 185685,
    ["count"] = 0,
    ["health"] = 33039,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 105134,
    ["iconTexture"] = 4335642,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368239,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.75,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366288] = {
      },
      [366297] = {
      },
      [368243] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 366.40527024374,
        ["y"] = -95.650284591096,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 358.39493391598,
        ["y"] = -112.65093120997,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 399.02713611902,
        ["y"] = -82.961530454575,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 432.86470808384,
        ["y"] = -104.43223637479,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 470.6665288192,
        ["y"] = -128.62961322485,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 472.69868259204,
        ["y"] = -163.82283230742,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 544.35014093816,
        ["y"] = -183.35440522903,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 525.79355201318,
        ["y"] = -261.99214731189,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 448.29423476478,
        ["y"] = -302.34046672132,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 451.32089775323,
        ["y"] = -368.09732800655,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 469.2992828741,
        ["y"] = -389.62119362947,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 442.89628820804,
        ["y"] = -404.6602811684,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 484.64047456791,
        ["y"] = -412.10216908439,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 453.49442937298,
        ["y"] = -433.16147429565,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 429.31146914398,
        ["y"] = -439.05305252714,
        ["sublevel"] = 2,
      },
      [16] = {
        ["x"] = 428.75664472993,
        ["y"] = -392.950238483,
        ["sublevel"] = 2,
      },
    },
  },
  [44] = {
    ["name"] = "Vy Relic",
    ["id"] = 185680,
    ["count"] = 0,
    ["health"] = 33039,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 103111,
    ["iconTexture"] = 4335643,
    ["creatureType"] = "Mechanical",
    ["level"] = 62,
    ["bonusSpell"] = 368240,
    ["badCreatureModel"] = true,
    ["modelPosition"] = {
      [1] = 0,
      [2] = 0,
      [3] = 0.75,
    },
    ["include"] = {
      ["level"] = 10,
      ["affix"] = 130,
    },
    ["spells"] = {
      [366406] = {
      },
      [366409] = {
      },
      [368103] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 379.1699868651,
        ["y"] = -90.650289761031,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 345.65104747919,
        ["y"] = -112.22410680974,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 392.95918338004,
        ["y"] = -92.621729681121,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 431.79328857028,
        ["y"] = -82.735816881689,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 474.76485909443,
        ["y"] = -142.07224458983,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 485.54676169905,
        ["y"] = -166.41776763166,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 530.41568573872,
        ["y"] = -176.79702965214,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 508.77431819088,
        ["y"] = -258.33828980173,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 457.17355143622,
        ["y"] = -292.42666842193,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 447.71620829092,
        ["y"] = -381.35313985962,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 455.22953657169,
        ["y"] = -389.6212135901,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 451.96607732508,
        ["y"] = -415.24167352739,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 485.22186772351,
        ["y"] = -403.96261999465,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 476.1688422837,
        ["y"] = -433.85915306859,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 450.81145783493,
        ["y"] = -438.92805084634,
        ["sublevel"] = 2,
      },
      [16] = {
        ["x"] = 442.50998258948,
        ["y"] = -390.84035409262,
        ["sublevel"] = 2,
      },
    },
  },
};
