local addonName = ...
local MDT = MDT
local L = MDT.L
local dungeonIndex = 4
MDT.dungeonList[dungeonIndex] = L["Darkheart Thicket"]

MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides = {
    [1] = {
      zoomScale = 1.2999999523163,
      horizontalPan = 67.260832446435,
      verticalPan = 69.727395812053,
    },
  }
};

local zones = { 733 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'DarkheartThicket' },
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Darkheart Thicket Sublevel"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 273, teeming = 336, teemingEnabled = true }

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Frenzied Nightclaw",
    ["id"] = 95772,
    ["count"] = 4,
    ["health"] = 1184900,
    ["scale"] = 1,
    ["displayId"] = 64385,
    ["creatureType"] = "Beast",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [225484] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 310.00335933817,
        ["y"] = -135.45334847906,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 306.84546745164,
        ["y"] = -139.13756320902,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 279.83037028607,
        ["y"] = -135.45334847906,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 171.81223444619,
        ["y"] = -155.77518349162,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 164.0749599263,
        ["y"] = -163.35880204115,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 207.72806966183,
        ["y"] = -167.04508008321,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 205.23484335237,
        ["y"] = -174.53830981001,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 227.1051156225,
        ["y"] = -170.94161456242,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 227.47726087093,
        ["y"] = -177.04512106563,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 223.56538650062,
        ["y"] = -219.56532917582,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 233.40363955368,
        ["y"] = -218.67936674893,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 185.10096591678,
        ["y"] = -183.09355228671,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 301.06930664595,
        ["y"] = -140.03257873621,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [14] = {
        ["x"] = 212.33564276823,
        ["y"] = -168.75303116808,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [2] = {
    ["name"] = "Dreadsoul Poisoner",
    ["id"] = 101679,
    ["count"] = 4,
    ["health"] = 1184900,
    ["scale"] = 1,
    ["displayId"] = 67296,
    ["creatureType"] = "Humanoid",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [200684] = {
      },
      [200686] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 303.68757556511,
        ["y"] = -131.2428334927,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 223.70948678147,
        ["y"] = -208.42865112161,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 232.34863948555,
        ["y"] = -109.21333168519,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 145.63439363378,
        ["y"] = -145.85341594566,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 176.49635530989,
        ["y"] = -187.01317900517,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 234.81841750299,
        ["y"] = -172.92083923381,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 238.19790567609,
            ["y"] = -180.68870777374,
          },
          [2] = {
            ["x"] = 223.74775380237,
            ["y"] = -192.32783014783,
          },
          [3] = {
            ["x"] = 219.77419677526,
            ["y"] = -199.43580795636,
          },
          [4] = {
            ["x"] = 207.10739672029,
            ["y"] = -197.95181811762,
          },
          [5] = {
            ["x"] = 208.67521670917,
            ["y"] = -185.05460071172,
          },
          [6] = {
            ["x"] = 215.43479338555,
            ["y"] = -178.7000131341,
          },
          [7] = {
            ["x"] = 231.87060067706,
            ["y"] = -172.49971738086,
          },
        },
      },
      [8] = {
        ["x"] = 232.98213989355,
        ["y"] = -207.51971372447,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 208.30597764346,
        ["y"] = -245.83526888118,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 216.67918834006,
            ["y"] = -251.32750870967,
          },
          [2] = {
            ["x"] = 212.29368634028,
            ["y"] = -228.13025637098,
          },
          [3] = {
            ["x"] = 211.73588302154,
            ["y"] = -214.89864537853,
          },
          [4] = {
            ["x"] = 215.38103617532,
            ["y"] = -209.52575065084,
          },
          [5] = {
            ["x"] = 211.73588302154,
            ["y"] = -214.89864537853,
          },
          [6] = {
            ["x"] = 212.29368634028,
            ["y"] = -228.13025637098,
          },
          [7] = {
            ["x"] = 216.67918834006,
            ["y"] = -251.32750870967,
          },
          [8] = {
            ["x"] = 218.0611012743,
            ["y"] = -267.14810745017,
          },
          [9] = {
            ["x"] = 214.08945573558,
            ["y"] = -282.10113184884,
          },
          [10] = {
            ["x"] = 218.0611012743,
            ["y"] = -267.14810745017,
          },
        },
      },
      [10] = {
        ["x"] = 229.69819973632,
        ["y"] = -252.1187309397,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Mindshattered Screecher",
    ["id"] = 95769,
    ["count"] = 4,
    ["health"] = 888675,
    ["scale"] = 1,
    ["displayId"] = 64536,
    ["creatureType"] = "Beast",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [200630] = {
      },
      [200631] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 276.67242504308,
        ["y"] = -149.31784002173,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 271.52944854591,
        ["y"] = -134.04023242974,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 277.37179478601,
        ["y"] = -128.08494160617,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 181.81919803964,
        ["y"] = -194.83436176509,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 226.81917256627,
        ["y"] = -262.85498757978,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Festerhide Grizzly",
    ["id"] = 95779,
    ["count"] = 10,
    ["health"] = 2962250,
    ["scale"] = 1.4,
    ["displayId"] = 66633,
    ["creatureType"] = "Beast",
    ["level"] = 111,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [200580] = {
      },
      [218755] = {
      },
      [218759] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 242.33743406113,
        ["y"] = -144.28618408769,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 272.70394884234,
        ["y"] = -104.32669784512,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 225.61563103723,
        ["y"] = -101.13600099148,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 157.64351045581,
        ["y"] = -107.10325745224,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 146.10478130163,
        ["y"] = -109.77235153726,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 247.99213068602,
        ["y"] = -176.59056956311,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 255.26483768455,
        ["y"] = -204.77239208705,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 254.35577369345,
        ["y"] = -216.13602359434,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 202.29157598098,
        ["y"] = -296.88691113233,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 213.90215284615,
        ["y"] = -299.87813002325,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 237.28316194242,
        ["y"] = -147.95429989909,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [5] = {
    ["name"] = "Dreadsoul Ruiner",
    ["id"] = 95771,
    ["count"] = 4,
    ["health"] = 1066410,
    ["scale"] = 1,
    ["displayId"] = 64539,
    ["creatureType"] = "Humanoid",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [200642] = {
      },
      [200658] = {
      },
      [204402] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 217.8882546569,
        ["y"] = -129.31782656954,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 217.8882546569,
            ["y"] = -129.31782656954,
          },
          [2] = {
            ["x"] = 189.08386791577,
            ["y"] = -124.64718122079,
          },
          [3] = {
            ["x"] = 217.8882546569,
            ["y"] = -129.31782656954,
          },
          [4] = {
            ["x"] = 225.19277325947,
            ["y"] = -130.63459875729,
          },
          [5] = {
            ["x"] = 240.64736828947,
            ["y"] = -144.2709877772,
          },
          [6] = {
            ["x"] = 262.92007980153,
            ["y"] = -139.72555077986,
          },
          [7] = {
            ["x"] = 240.64736828947,
            ["y"] = -144.2709877772,
          },
          [8] = {
            ["x"] = 225.19277325947,
            ["y"] = -130.63459875729,
          },
        },
      },
      [2] = {
        ["x"] = 216.05169493286,
        ["y"] = -102.15213382032,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 197.51525138487,
        ["y"] = -132.21973184351,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 146.03699680199,
        ["y"] = -156.14553178363,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 164.26909814081,
        ["y"] = -156.18535519318,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 164.26909814081,
            ["y"] = -159.97540367677,
          },
          [2] = {
            ["x"] = 153.5164253695,
            ["y"] = -148.74213276827,
          },
          [3] = {
            ["x"] = 151.31418146772,
            ["y"] = -143.49295412365,
          },
          [4] = {
            ["x"] = 153.5164253695,
            ["y"] = -148.74213276827,
          },
          [5] = {
            ["x"] = 164.26909814081,
            ["y"] = -159.97540367677,
          },
          [6] = {
            ["x"] = 169.54375263666,
            ["y"] = -176.87712655062,
          },
        },
      },
      [6] = {
        ["x"] = 190.07702205872,
        ["y"] = -190.7411615845,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 198.05242160445,
        ["y"] = -163.3407663079,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 216.49207005813,
        ["y"] = -244.19034522582,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 219.8158252158,
        ["y"] = -122.06051412379,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 196.05044957098,
        ["y"] = -172.1730953085,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
    },
  },
  [6] = {
    ["name"] = "Crazed Razorbeak",
    ["id"] = 95766,
    ["count"] = 4,
    ["health"] = 1925463,
    ["scale"] = 1,
    ["displayId"] = 64535,
    ["creatureType"] = "Beast",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [200768] = {
      },
      [200771] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 206.64160274227,
        ["y"] = -135.68093484766,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 197.05973248942,
        ["y"] = -141.46281786127,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 136.3423148528,
        ["y"] = -145.743097457,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 135.92275200138,
        ["y"] = -154.58946723319,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Rotheart Dryad",
    ["id"] = 99358,
    ["count"] = 4,
    ["health"] = 1184900,
    ["scale"] = 1,
    ["displayId"] = 69689,
    ["creatureType"] = "Humanoid",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [198723] = {
      },
      [198904] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 222.53641448834,
        ["y"] = -416.72321648419,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 252.2588105734,
        ["y"] = -445.22699184888,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 272.83376270715,
        ["y"] = -449.12559924866,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["patrolFacing"] = 4.2215151282613,
        ["patrolFacing2"] = 4.9087385212341,
        ["patrol"] = {
          [1] = {
            ["x"] = 273.88653721894,
            ["y"] = -451.86286117223,
          },
          [2] = {
            ["x"] = 289.41353145065,
            ["y"] = -449.77247809621,
          },
          [3] = {
            ["x"] = 298.8447319233,
            ["y"] = -441.22771315903,
          },
          [4] = {
            ["x"] = 311.65753951435,
            ["y"] = -443.32451928762,
          },
          [5] = {
            ["x"] = 313.62040975433,
            ["y"] = -455.24692518042,
          },
          [6] = {
            ["x"] = 306.67837957585,
            ["y"] = -459.30171050277,
          },
          [7] = {
            ["x"] = 293.72563943785,
            ["y"] = -456.59067260616,
          },
          [8] = {
            ["x"] = 289.555732201,
            ["y"] = -459.27907115651,
          },
          [9] = {
            ["x"] = 273.88653721894,
            ["y"] = -451.86286117223,
          },
          [10] = {
            ["x"] = 289.555732201,
            ["y"] = -459.27907115651,
          },
          [11] = {
            ["x"] = 293.72563943785,
            ["y"] = -456.59067260616,
          },
          [12] = {
            ["x"] = 306.67837957585,
            ["y"] = -459.30171050277,
          },
          [13] = {
            ["x"] = 313.62040975433,
            ["y"] = -455.24692518042,
          },
          [14] = {
            ["x"] = 311.65753951435,
            ["y"] = -443.32451928762,
          },
          [15] = {
            ["x"] = 298.8447319233,
            ["y"] = -441.22771315903,
          },
          [16] = {
            ["x"] = 289.41353145065,
            ["y"] = -449.77247809621,
          },
        },
      },
      [4] = {
        ["x"] = 344.75698856791,
        ["y"] = -395.56186160247,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["patrolFacing"] = 2.3561944901923,
        ["patrolFacing2"] = 5.7923114550562,
        ["patrol"] = {
          [1] = {
            ["x"] = 344.75698856791,
            ["y"] = -395.56186160247,
          },
          [2] = {
            ["x"] = 325.64520372574,
            ["y"] = -415.00884277176,
          },
          [3] = {
            ["x"] = 344.75698856791,
            ["y"] = -395.56186160247,
          },
          [4] = {
            ["x"] = 351.54877804974,
            ["y"] = -384.07039475886,
          },
          [5] = {
            ["x"] = 355.9374361899,
            ["y"] = -344.61142627437,
          },
          [6] = {
            ["x"] = 353.92198784673,
            ["y"] = -329.61447461795,
          },
          [7] = {
            ["x"] = 358.30930828032,
            ["y"] = -316.02454030049,
          },
          [8] = {
            ["x"] = 353.92198784673,
            ["y"] = -329.61447461795,
          },
          [9] = {
            ["x"] = 355.9374361899,
            ["y"] = -344.61142627437,
          },
          [10] = {
            ["x"] = 351.54877804974,
            ["y"] = -384.07039475886,
          },
        },
      },
    },
  },
  [8] = {
    ["name"] = "Vilethorn Blossom",
    ["id"] = 99360,
    ["count"] = 4,
    ["health"] = 1333013,
    ["scale"] = 1,
    ["displayId"] = 69687,
    ["creatureType"] = "Elemental",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [201123] = {
      },
      [201129] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 209.29741683468,
        ["y"] = -423.55827152654,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 218.53051266084,
        ["y"] = -429.77244456595,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 262.25878865684,
        ["y"] = -439.77241224143,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 257.25883862907,
        ["y"] = -432.49968494777,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 281.38094803189,
        ["y"] = -447.32779150298,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 278.75678352491,
        ["y"] = -454.45619136676,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 302.55313494458,
        ["y"] = -435.22697977128,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 313.4621759354,
        ["y"] = -431.59064577899,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 324.35508312557,
        ["y"] = -474.31786279301,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 318.90054312319,
        ["y"] = -480.68150580044,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 316.20671481981,
        ["y"] = -488.38536558824,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 324.77619293028,
        ["y"] = -486.25977706824,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 344.7963090408,
        ["y"] = -402.1600217726,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 338.43274406126,
        ["y"] = -396.70548177021,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 225.98036130262,
        ["y"] = -427.09824332037,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [16] = {
        ["x"] = 217.79855129905,
        ["y"] = -422.09823531353,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [9] = {
    ["name"] = "Rotheart Keeper",
    ["id"] = 99359,
    ["count"] = 3,
    ["health"] = 1629238,
    ["scale"] = 1,
    ["displayId"] = 69688,
    ["creatureType"] = "Humanoid",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [225497] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 248.33110579345,
        ["y"] = -435.68155684538,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 314.56740910116,
        ["y"] = -439.09810428073,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 306.40897084512,
        ["y"] = -442.93157433628,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 260.41812922054,
        ["y"] = -445.73757820576,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [5] = {
        ["x"] = 311.35854737553,
        ["y"] = -443.86336708433,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [10] = {
    ["name"] = "Nightmare Dweller",
    ["id"] = 101991,
    ["count"] = 4,
    ["health"] = 1481125,
    ["scale"] = 1,
    ["displayId"] = 71636,
    ["creatureType"] = "Elemental",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [204243] = {
      },
      [204246] = {
      },
      [204852] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 379.17747443888,
        ["y"] = -323.24744912373,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 382.04213554552,
        ["y"] = -301.70781576134,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 378.40572352534,
        ["y"] = -288.52597824395,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 357.4967055348,
        ["y"] = -296.70776874056,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 336.58760951636,
        ["y"] = -287.61691425286,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Hatespawn Slime",
    ["id"] = 100529,
    ["count"] = 1,
    ["health"] = 222169,
    ["scale"] = 0.6,
    ["displayId"] = 47926,
    ["creatureType"] = "Elemental",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [201191] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 423.48297168345,
        ["y"] = -206.75129995109,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 432.68660694789,
        ["y"] = -200.47295013329,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 433.14119746436,
        ["y"] = -205.01838713063,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 431.32295244032,
        ["y"] = -210.47292713301,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 420.86842393807,
        ["y"] = -200.0183791238,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 425.41382192146,
        ["y"] = -212.29115265008,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 417.23205093184,
        ["y"] = -210.47292713301,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 413.59571693955,
        ["y"] = -207.2911056293,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 415.41388393569,
        ["y"] = -202.74566863196,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 482.4087219671,
        ["y"] = -181.62793467476,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 480.59047674601,
        ["y"] = -187.08247526827,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 483.31778605672,
        ["y"] = -192.53701586177,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 490.53973134317,
        ["y"] = -195.0214751594,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 490.10491578576,
        ["y"] = -188.92042239643,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 495.59056091303,
        ["y"] = -184.8097565233,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 499.22693431335,
        ["y"] = -186.62792371648,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 488.36579117006,
        ["y"] = -184.05503759857,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 496.72883546825,
        ["y"] = -191.01230420535,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 511.87124801644,
        ["y"] = -203.05326167093,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 507.32581052651,
        ["y"] = -206.68965457822,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 502.78037303657,
        ["y"] = -208.96237332319,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 506.3868112593,
        ["y"] = -212.66751144441,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 509.59852927147,
        ["y"] = -209.41688586102,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 513.23486365784,
        ["y"] = -207.14418662303,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 517.78037917568,
        ["y"] = -212.59874672351,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 513.68945422358,
        ["y"] = -215.78054906507,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 508.68946518186,
        ["y"] = -216.68963266166,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Bloodtainted Fury",
    ["id"] = 100531,
    ["count"] = 8,
    ["health"] = 1925463,
    ["scale"] = 1,
    ["displayId"] = 29278,
    ["creatureType"] = "Elemental",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [201226] = {
      },
      [201227] = {
      },
      [201250] = {
      },
      [201272] = {
      },
      [201273] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 460.0701258476,
        ["y"] = -194.26827922932,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["patrolFacing"] = 2.0616701789183,
        ["patrolFacing2"] = 5.7923114550562,
        ["patrol"] = {
          [1] = {
            ["x"] = 460.0701258476,
            ["y"] = -194.26827922932,
          },
          [2] = {
            ["x"] = 438.55421881428,
            ["y"] = -199.96604551375,
          },
          [3] = {
            ["x"] = 460.0701258476,
            ["y"] = -194.26827922932,
          },
          [4] = {
            ["x"] = 471.09963647194,
            ["y"] = -184.25099508944,
          },
          [5] = {
            ["x"] = 474.28142310101,
            ["y"] = -181.06918010075,
          },
          [6] = {
            ["x"] = 469.73598610368,
            ["y"] = -176.06923061483,
          },
          [7] = {
            ["x"] = 474.28142310101,
            ["y"] = -181.06918010075,
          },
          [8] = {
            ["x"] = 471.09963647194,
            ["y"] = -184.25099508944,
          },
        },
      },
      [2] = {
        ["x"] = 520.47283889433,
        ["y"] = -194.04340059876,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["patrolFacing"] = 6.1850105367549,
        ["patrolFacing2"] = 3.4361169648638,
        ["patrol"] = {
          [1] = {
            ["x"] = 520.47283889433,
            ["y"] = -194.04340059876,
          },
          [2] = {
            ["x"] = 521.99343644345,
            ["y"] = -178.61992394155,
          },
          [3] = {
            ["x"] = 527.90252794836,
            ["y"] = -177.7108209365,
          },
          [4] = {
            ["x"] = 521.99343644345,
            ["y"] = -178.61992394155,
          },
          [5] = {
            ["x"] = 520.47283889433,
            ["y"] = -194.04340059876,
          },
          [6] = {
            ["x"] = 525.9864842126,
            ["y"] = -224.73685216927,
          },
        },
      },
      [3] = {
        ["x"] = 477.43098536334,
        ["y"] = -187.41863154537,
        ["sublevel"] = 1,
        ["teeming"] = true,
        ["patrolFacing"] = 1.3744467859455,
        ["patrolFacing2"] = 4.7123889803847,
        ["patrol"] = {
          [1] = {
            ["x"] = 477.43098536334,
            ["y"] = -187.41863154537,
          },
          [2] = {
            ["x"] = 463.48755112442,
            ["y"] = -185.45097742167,
          },
          [3] = {
            ["x"] = 477.43098536334,
            ["y"] = -187.41863154537,
          },
          [4] = {
            ["x"] = 507.05157050938,
            ["y"] = -191.51836625746,
          },
          [5] = {
            ["x"] = 520.4227819362,
            ["y"] = -206.86307324189,
          },
          [6] = {
            ["x"] = 507.05157050938,
            ["y"] = -191.51836625746,
          },
          [7] = {
            ["x"] = 477.43098536334,
            ["y"] = -187.41863154537,
          },
        },
      },
    },
  },
  [13] = {
    ["name"] = "Taintheart Summoner",
    ["id"] = 99366,
    ["count"] = 4,
    ["health"] = 1303390,
    ["scale"] = 1,
    ["displayId"] = 66131,
    ["creatureType"] = "Demon",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Subjugate Demon"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["spells"] = {
      [201837] = {
      },
      [201839] = {
      },
      [201842] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 441.53853612648,
        ["y"] = -293.22524091842,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 495.8095536507,
        ["y"] = -360.86406312631,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["patrolFacing"] = 0.58904862254809,
        ["patrolFacing2"] = 4.0251655874119,
        ["patrol"] = {
          [1] = {
            ["x"] = 486.48969150137,
            ["y"] = -346.07013268721,
          },
          [2] = {
            ["x"] = 484.02042404813,
            ["y"] = -336.27745264767,
          },
          [3] = {
            ["x"] = 486.48969150137,
            ["y"] = -346.07013268721,
          },
          [4] = {
            ["x"] = 495.8095536507,
            ["y"] = -360.86406312631,
          },
          [5] = {
            ["x"] = 502.48137519286,
            ["y"] = -366.61470183184,
          },
          [6] = {
            ["x"] = 495.8095536507,
            ["y"] = -360.86406312631,
          },
          [7] = {
            ["x"] = 495.8095536507,
            ["y"] = -360.86406312631,
          },
        },
      },
      [3] = {
        ["x"] = 515.60170855114,
        ["y"] = -370.90454319207,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 630.50829758703,
        ["y"] = -452.04459323975,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 492.21017635229,
        ["y"] = -356.230171503,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [14] = {
    ["name"] = "Taintheart Stalker",
    ["id"] = 99365,
    ["count"] = 4,
    ["health"] = 1184900,
    ["scale"] = 1,
    ["displayId"] = 66740,
    ["creatureType"] = "Demon",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Subjugate Demon"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["spells"] = {
      [201517] = {
      },
      [201564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 431.01221478003,
        ["y"] = -299.54106986553,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 442.89706886572,
        ["y"] = -303.05804694903,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 443.35164048481,
        ["y"] = -255.78534725631,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 516.07605708156,
        ["y"] = -362.95422476065,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 619.14462706579,
        ["y"] = -442.95371924508,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 618.94189184173,
        ["y"] = -448.40892730608,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [15] = {
    ["name"] = "Dreadfire Imp",
    ["id"] = 100527,
    ["count"] = 3,
    ["health"] = 888675,
    ["scale"] = 1,
    ["displayId"] = 12190,
    ["creatureType"] = "Demon",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Subjugate Demon"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["spells"] = {
      [201399] = {
      },
      [201400] = {
      },
      [201411] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 434.26066834568,
        ["y"] = -292.60349893982,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 498.06229211175,
        ["y"] = -354.18686651433,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 491.24409760179,
        ["y"] = -364.64143403052,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 507.15312709247,
        ["y"] = -371.91414102905,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 507.607678595,
        ["y"] = -363.27776001598,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 618.16692434791,
        ["y"] = -454.30522497712,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Taintheart Deadeye",
    ["id"] = 100539,
    ["count"] = 4,
    ["health"] = 1066410,
    ["scale"] = 1,
    ["displayId"] = 64486,
    ["creatureType"] = "Demon",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Subjugate Demon"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Turn Evil"] = true,
    },
    ["spells"] = {
      [201858] = {
      },
      [201885] = {
      },
      [201902] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 441.53339546077,
        ["y"] = -263.96715725988,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 437.89702245453,
        ["y"] = -260.78531624919,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 626.41737307827,
        ["y"] = -460.2264227503,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 519.91830040217,
        ["y"] = -367.6025125639,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [17] = {
    ["name"] = "Tormented Bloodseeker",
    ["id"] = 100526,
    ["count"] = 4,
    ["health"] = 1110844,
    ["scale"] = 1,
    ["displayId"] = 61828,
    ["creatureType"] = "Beast",
    ["level"] = 110,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [201361] = {
      },
      [201365] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 465.65797076734,
        ["y"] = -280.39627110298,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 477.92034192708,
        ["y"] = -270.3429713843,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 463.8294404186,
        ["y"] = -266.70663739201,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 472.92035342722,
        ["y"] = -258.07027588591,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 542.894142341,
        ["y"] = -397.49972302535,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 551.53050384709,
        ["y"] = -400.68152502209,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 545.01460208218,
        ["y"] = -389.68690356999,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 555.92368208694,
        ["y"] = -394.2323600743,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 631.80335238176,
        ["y"] = -444.759740959,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
    },
  },
  [18] = {
    ["name"] = "Archdruid Glaidalis",
    ["id"] = 96512,
    ["count"] = 0,
    ["health"] = 10375700,
    ["scale"] = 1,
    ["displayId"] = 69815,
    ["creatureType"] = "Humanoid",
    ["level"] = 112,
    ["isBoss"] = true,
    ["encounterID"] = 1654,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [196354] = {
      },
      [196376] = {
      },
      [198269] = {
      },
      [198376] = {
      },
      [198379] = {
      },
      [198386] = {
      },
      [198408] = {
      },
      [212464] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 204.55247082157,
        ["y"] = -341.5737020441,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Oakheart",
    ["id"] = 103344,
    ["count"] = 0,
    ["health"] = 10375700,
    ["scale"] = 1,
    ["displayId"] = 68127,
    ["creatureType"] = "Elemental",
    ["level"] = 112,
    ["isBoss"] = true,
    ["encounterID"] = 1655,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [199051] = {
      },
      [204574] = {
      },
      [204611] = {
      },
      [204646] = {
      },
      [204666] = {
      },
      [204667] = {
      },
      [212786] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 364.54813116981,
        ["y"] = -259.56120430561,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Shade of Xavius",
    ["id"] = 99192,
    ["count"] = 0,
    ["health"] = 11857942,
    ["scale"] = 1,
    ["displayId"] = 71688,
    ["creatureType"] = "Demon",
    ["level"] = 112,
    ["isBoss"] = true,
    ["encounterID"] = 1657,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [200050] = {
      },
      [200111] = {
      },
      [200182] = {
      },
      [200185] = {
      },
      [200238] = {
      },
      [200289] = {
      },
      [200329] = {
      },
      [200359] = {
      },
      [204502] = {
      },
      [221315] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 681.70414915098,
        ["y"] = -479.31788158202,
        ["g"] = 42,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Dresaron",
    ["id"] = 99200,
    ["count"] = 0,
    ["health"] = 10375700,
    ["scale"] = 1,
    ["displayId"] = 71675,
    ["creatureType"] = "Dragonkin",
    ["level"] = 112,
    ["isBoss"] = true,
    ["encounterID"] = 1656,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [191326] = {
      },
      [199345] = {
      },
      [199389] = {
      },
      [199460] = {
      },
      [218587] = {
      },
      [220855] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 554.56865152516,
        ["y"] = -254.48568850622,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
    },
  },
};
