local MDT = MDT
local L = MDT.L
local dungeonIndex = 3
MDT.dungeonList[dungeonIndex] = L["Court of Stars"]
MDT.mapInfo[dungeonIndex] = {
  viewportPositionOverrides = {
    [1] = {
      zoomScale = 1.2999999523163;
      horizontalPan = 89.754838662491;
      verticalPan = 36.757613963117;
    };
  }
};
local zones = { 761, 762, 763 }
-- add zones to MDT.zoneIdToDungeonIdx
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "SuramarNoblesDistrict",
  [1] = "SuramarNoblesDistrict",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Court of Stars"],
}
MDT.dungeonTotalCount[dungeonIndex] = { normal = 190, teeming = 1000, teemingEnabled = true }

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Duskwatch Guard";
    ["id"] = 111563;
    ["count"] = 4;
    ["health"] = 717294;
    ["scale"] = 1;
    ["displayId"] = 70561;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Polymorph"] = true;
      ["Imprison"] = true;
      ["Sap"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [209027] = {
      };
      [209033] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 359.14546565175;
        ["y"] = -362.44518000595;
        ["g"] = 1;
        ["sublevel"] = 1;
      };
    };
  };
  [2] = {
    ["name"] = "Duskwatch Sentry";
    ["id"] = 104251;
    ["count"] = 1;
    ["health"] = 179323;
    ["scale"] = 1;
    ["displayId"] = 70566;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Polymorph"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Imprison"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [209036] = {
      };
      [210261] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 347.96976623397;
        ["y"] = -313.98405455526;
        ["g"] = 2;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 340.30847925576;
            ["y"] = -319.22227943218;
          };
          [2] = {
            ["x"] = 356.67209926291;
            ["y"] = -311.4950404381;
          };
        };
      };
      [2] = {
        ["x"] = 294.01010092315;
        ["y"] = -329.49518668812;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 321.15618603682;
            ["y"] = -323.09551862453;
          };
          [2] = {
            ["x"] = 317.51981303058;
            ["y"] = -331.27730912114;
          };
          [3] = {
            ["x"] = 312.97441504719;
            ["y"] = -334.45911111788;
          };
          [4] = {
            ["x"] = 299.33802602728;
            ["y"] = -337.64093262159;
          };
          [5] = {
            ["x"] = 290.70166452119;
            ["y"] = -324.45913411816;
          };
          [6] = {
            ["x"] = 297.97444954761;
            ["y"] = -316.27732411458;
          };
          [7] = {
            ["x"] = 290.70166452119;
            ["y"] = -324.45913411816;
          };
          [8] = {
            ["x"] = 299.33802602728;
            ["y"] = -337.64093262159;
          };
          [9] = {
            ["x"] = 312.97441504719;
            ["y"] = -334.45911111788;
          };
          [10] = {
            ["x"] = 317.51981303058;
            ["y"] = -331.27730912114;
          };
        };
      };
      [3] = {
        ["x"] = 293.63317256761;
        ["y"] = -267.29389707235;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 270.74753587518;
            ["y"] = -244.38947809711;
          };
          [2] = {
            ["x"] = 268.02022686004;
            ["y"] = -254.8440456133;
          };
          [3] = {
            ["x"] = 278.02028188765;
            ["y"] = -270.7531336249;
          };
          [4] = {
            ["x"] = 284.38392489508;
            ["y"] = -272.57132012802;
          };
          [5] = {
            ["x"] = 293.47479888976;
            ["y"] = -267.11678012564;
          };
          [6] = {
            ["x"] = 303.92928837805;
            ["y"] = -272.11674911852;
          };
          [7] = {
            ["x"] = 293.47479888976;
            ["y"] = -267.11678012564;
          };
          [8] = {
            ["x"] = 284.38392489508;
            ["y"] = -272.57132012802;
          };
          [9] = {
            ["x"] = 278.02028188765;
            ["y"] = -270.7531336249;
          };
          [10] = {
            ["x"] = 268.02022686004;
            ["y"] = -254.8440456133;
          };
        };
      };
      [4] = {
        ["x"] = 259.34922767637;
        ["y"] = -230.82722626379;
        ["sublevel"] = 1;
      };
      [5] = {
        ["x"] = 278.11474246507;
        ["y"] = -215.20644325353;
        ["g"] = 14;
        ["sublevel"] = 1;
      };
    };
  };
  [3] = {
    ["name"] = "Mana Wyrm";
    ["id"] = 105703;
    ["count"] = 1;
    ["health"] = 143459;
    ["scale"] = 1;
    ["displayId"] = 70565;
    ["creatureType"] = "Beast";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [209477] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 344.80901792002;
        ["y"] = -321.03961392967;
        ["g"] = 2;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [2] = {
        ["x"] = 341.86885289082;
        ["y"] = -312.91766007501;
        ["g"] = 2;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [3] = {
        ["x"] = 290.8461598757;
        ["y"] = -281.36533326415;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [4] = {
        ["x"] = 300.67478419677;
        ["y"] = -292.95393088152;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [5] = {
        ["x"] = 289.68033461899;
        ["y"] = -287.19646570461;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [6] = {
        ["x"] = 296.16194689219;
        ["y"] = -295.2122683145;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [7] = {
        ["x"] = 295.77264573356;
        ["y"] = -284.38553641109;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [8] = {
        ["x"] = 300.37929881917;
        ["y"] = -287.94080108072;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [9] = {
        ["x"] = 290.28087659414;
        ["y"] = -292.66139714987;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [10] = {
        ["x"] = 294.712249558;
        ["y"] = -290.05082961254;
        ["g"] = 9;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [11] = {
        ["x"] = 285.47737952018;
        ["y"] = -245.81918847296;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [12] = {
        ["x"] = 288.55993544785;
        ["y"] = -251.80118619574;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [13] = {
        ["x"] = 283.6351090522;
        ["y"] = -258.71992997116;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [14] = {
        ["x"] = 277.97230284819;
        ["y"] = -259.65480038962;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [15] = {
        ["x"] = 272.14373793765;
        ["y"] = -245.76302315653;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [16] = {
        ["x"] = 278.41070794423;
        ["y"] = -245.30913505939;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [17] = {
        ["x"] = 271.76697861258;
        ["y"] = -250.86780623831;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [18] = {
        ["x"] = 273.73620723401;
        ["y"] = -256.06972764643;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [19] = {
        ["x"] = 219.95836504219;
        ["y"] = -335.28360947092;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [20] = {
        ["x"] = 226.20734663186;
        ["y"] = -324.52223450826;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [21] = {
        ["x"] = 223.58129938792;
        ["y"] = -329.1811381725;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [22] = {
        ["x"] = 220.47298202265;
        ["y"] = -324.00713131483;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [23] = {
        ["x"] = 231.90638370155;
        ["y"] = -339.65472305912;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [24] = {
        ["x"] = 228.55508481103;
        ["y"] = -331.29931737274;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [25] = {
        ["x"] = 226.05618542584;
        ["y"] = -338.11742873449;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [26] = {
        ["x"] = 234.85261314735;
        ["y"] = -334.13081349236;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [27] = {
        ["x"] = 214.74939047488;
        ["y"] = -94.017226174875;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [28] = {
        ["x"] = 207.06721130139;
        ["y"] = -87.023541537573;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [29] = {
        ["x"] = 208.13886266394;
        ["y"] = -91.917660304442;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [30] = {
        ["x"] = 210.38482597927;
        ["y"] = -78.977540365535;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [31] = {
        ["x"] = 223.2667888787;
        ["y"] = -86.931409969607;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [32] = {
        ["x"] = 216.24369169599;
        ["y"] = -77.981153316532;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [33] = {
        ["x"] = 207.31330529627;
        ["y"] = -82.31084441231;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [34] = {
        ["x"] = 220.57032122234;
        ["y"] = -81.336517852456;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [35] = {
        ["x"] = 326.26808654078;
        ["y"] = -117.55332852547;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [36] = {
        ["x"] = 326.9900555401;
        ["y"] = -122.60302044748;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [37] = {
        ["x"] = 318.70520252953;
        ["y"] = -111.79203251113;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [38] = {
        ["x"] = 321.36452720651;
        ["y"] = -107.9288668254;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [39] = {
        ["x"] = 328.54297477496;
        ["y"] = -113.11916582596;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [40] = {
        ["x"] = 325.97818754694;
        ["y"] = -110.09733910394;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [41] = {
        ["x"] = 323.07295881169;
        ["y"] = -114.51466756209;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
    };
  };
  [4] = {
    ["name"] = "Guardian Construct";
    ["id"] = 104270;
    ["count"] = 8;
    ["health"] = 1147671;
    ["scale"] = 1;
    ["displayId"] = 68553;
    ["creatureType"] = "Mechanical";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [209413] = {
      };
      [209495] = {
      };
      [209512] = {
      };
      [225100] = {
      };
      [225101] = {
      };
      [397918] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 374.8547080505;
        ["y"] = -316.11730893129;
        ["g"] = 3;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
      };
      [2] = {
        ["x"] = 376.93872364332;
        ["y"] = -303.35963563138;
        ["g"] = 3;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
      };
      [3] = {
        ["x"] = 319.03652799155;
        ["y"] = -297.32920754717;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
      };
      [4] = {
        ["x"] = 313.05606576497;
        ["y"] = -264.96092650549;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
      };
      [5] = {
        ["x"] = 258.44939209631;
        ["y"] = -269.08639393603;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
        ["patrol"] = {
          [1] = {
            ["x"] = 260.0336389706;
            ["y"] = -252.0218982617;
          };
          [2] = {
            ["x"] = 260.48811244523;
            ["y"] = -270.20376329289;
          };
          [3] = {
            ["x"] = 286.85178747999;
            ["y"] = -287.93101830063;
          };
          [4] = {
            ["x"] = 260.48811244523;
            ["y"] = -270.20376329289;
          };
        };
      };
      [6] = {
        ["x"] = 243.0445824298;
        ["y"] = -231.19399499496;
        ["g"] = 15;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
      };
      [7] = {
        ["x"] = 281.45959545134;
        ["y"] = -168.02467924528;
        ["g"] = 16;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
      };
      [8] = {
        ["x"] = 344.03904598974;
        ["y"] = -144.38377358491;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
      };
      [9] = {
        ["x"] = 419.34007249798;
        ["y"] = -258.7279966277;
        ["g"] = 29;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
        ["patrol"] = {
          [1] = {
            ["x"] = 397.9164767445;
            ["y"] = -289.24959508772;
          };
          [2] = {
            ["x"] = 434.73468427158;
            ["y"] = -239.24962664262;
          };
        };
      };
      [10] = {
        ["x"] = 472.59524618202;
        ["y"] = -351.49719733861;
        ["g"] = 34;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
      };
    };
  };
  [5] = {
    ["name"] = "Duskwatch Guard";
    ["id"] = 104246;
    ["count"] = 4;
    ["health"] = 717294;
    ["scale"] = 1;
    ["displayId"] = 70561;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Imprison"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [209027] = {
      };
      [209033] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 352.80901047139;
        ["y"] = -292.75608673617;
        ["g"] = 4;
        ["sublevel"] = 1;
      };
      [2] = {
        ["x"] = 370.66785185722;
        ["y"] = -276.06261147142;
        ["g"] = 5;
        ["sublevel"] = 1;
      };
      [3] = {
        ["x"] = 304.75765135132;
        ["y"] = -309.76929652588;
        ["g"] = 6;
        ["sublevel"] = 1;
      };
      [4] = {
        ["x"] = 319.40891825313;
        ["y"] = -364.30216008615;
        ["g"] = 7;
        ["sublevel"] = 1;
      };
      [5] = {
        ["x"] = 309.64583968049;
        ["y"] = -361.76380039648;
        ["g"] = 7;
        ["sublevel"] = 1;
      };
      [6] = {
        ["x"] = 283.30797090179;
        ["y"] = -343.20272509209;
        ["g"] = 8;
        ["sublevel"] = 1;
      };
      [7] = {
        ["x"] = 287.95572271072;
        ["y"] = -354.5158359265;
        ["g"] = 8;
        ["sublevel"] = 1;
      };
      [8] = {
        ["x"] = 296.39208123499;
        ["y"] = -237.05676819489;
        ["g"] = 36;
        ["sublevel"] = 1;
        ["scale"] = 1;
      };
      [9] = {
        ["x"] = 280.76253156237;
        ["y"] = -251.66328123835;
        ["g"] = 10;
        ["sublevel"] = 1;
        ["scale"] = 1;
      };
      [10] = {
        ["x"] = 256.52648984162;
        ["y"] = -297.9666320215;
        ["g"] = 12;
        ["sublevel"] = 1;
      };
      [11] = {
        ["x"] = 234.99101830883;
        ["y"] = -323.55693040875;
        ["g"] = 13;
        ["sublevel"] = 1;
        ["scale"] = 1;
      };
      [12] = {
        ["x"] = 271.78157169123;
        ["y"] = -219.02077847602;
        ["g"] = 14;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 268.81475145364;
            ["y"] = -231.29870862857;
          };
          [2] = {
            ["x"] = 272.90569130975;
            ["y"] = -206.29872711532;
          };
        };
      };
      [13] = {
        ["x"] = 246.21354015016;
        ["y"] = -243.46055706126;
        ["g"] = 15;
        ["sublevel"] = 1;
      };
      [14] = {
        ["x"] = 272.47456391745;
        ["y"] = -174.92169935817;
        ["g"] = 16;
        ["sublevel"] = 1;
      };
      [15] = {
        ["x"] = 301.4099561004;
        ["y"] = -178.07609973164;
        ["g"] = 17;
        ["sublevel"] = 1;
      };
      [16] = {
        ["x"] = 322.7616385694;
        ["y"] = -174.50142103971;
        ["g"] = 18;
        ["sublevel"] = 1;
      };
      [17] = {
        ["x"] = 250.7435994921;
        ["y"] = -114.72669964847;
        ["g"] = 21;
        ["sublevel"] = 1;
      };
      [18] = {
        ["x"] = 214.5464994257;
        ["y"] = -85.858729144764;
        ["g"] = 22;
        ["sublevel"] = 1;
        ["scale"] = 1;
      };
      [19] = {
        ["x"] = 295.46225662207;
        ["y"] = -106.75392454224;
        ["g"] = 23;
        ["sublevel"] = 1;
      };
      [20] = {
        ["x"] = 319.53998571814;
        ["y"] = -120.94474255335;
        ["g"] = 24;
        ["sublevel"] = 1;
        ["scale"] = 1;
      };
    };
  };
  [6] = {
    ["name"] = "Mana Saber";
    ["id"] = 105699;
    ["count"] = 2;
    ["health"] = 215189;
    ["scale"] = 1;
    ["displayId"] = 64620;
    ["creatureType"] = "Beast";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [209516] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 349.25027841164;
        ["y"] = -285.48511832669;
        ["g"] = 4;
        ["sublevel"] = 1;
      };
      [2] = {
        ["x"] = 359.70309896141;
        ["y"] = -288.42279898423;
        ["g"] = 4;
        ["sublevel"] = 1;
      };
      [3] = {
        ["x"] = 368.51863585091;
        ["y"] = -265.93146606027;
        ["g"] = 5;
        ["sublevel"] = 1;
      };
      [4] = {
        ["x"] = 377.57775536724;
        ["y"] = -267.93880237352;
        ["g"] = 5;
        ["sublevel"] = 1;
      };
      [5] = {
        ["x"] = 297.52078091979;
        ["y"] = -307.39041509434;
        ["g"] = 6;
        ["sublevel"] = 1;
      };
      [6] = {
        ["x"] = 291.29672660156;
        ["y"] = -230.47171301122;
        ["g"] = 36;
        ["sublevel"] = 1;
        ["scale"] = 1;
      };
      [7] = {
        ["x"] = 301.99566075832;
        ["y"] = -231.93131345833;
        ["g"] = 36;
        ["sublevel"] = 1;
        ["scale"] = 1;
      };
      [8] = {
        ["x"] = 263.56858724233;
        ["y"] = -303.15759375052;
        ["g"] = 12;
        ["sublevel"] = 1;
      };
      [9] = {
        ["x"] = 267.43951888267;
        ["y"] = -212.89760125057;
        ["g"] = 14;
        ["sublevel"] = 1;
      };
      [10] = {
        ["x"] = 305.87164777829;
        ["y"] = -185.57277898252;
        ["g"] = 17;
        ["sublevel"] = 1;
      };
      [11] = {
        ["x"] = 238.360446202;
        ["y"] = -128.1930981792;
        ["g"] = 20;
        ["sublevel"] = 1;
      };
      [12] = {
        ["x"] = 294.34993458905;
        ["y"] = -114.35372217151;
        ["g"] = 23;
        ["sublevel"] = 1;
      };
    };
  };
  [7] = {
    ["name"] = "Duskwatch Arcanist";
    ["id"] = 104247;
    ["count"] = 4;
    ["health"] = 573835;
    ["scale"] = 1;
    ["displayId"] = 70563;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Incapacitate"] = true;
      ["Silence"] = true;
      ["Root"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Imprison"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [209404] = {
      };
      [209410] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 316.19411726004;
        ["y"] = -354.56558146607;
        ["g"] = 7;
        ["sublevel"] = 1;
      };
      [2] = {
        ["x"] = 272.08648672943;
        ["y"] = -280.33940591693;
        ["g"] = 11;
        ["sublevel"] = 1;
      };
      [3] = {
        ["x"] = 264.05824480107;
        ["y"] = -294.61589733277;
        ["g"] = 12;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 271.05490573177;
            ["y"] = -286.85477831064;
          };
          [2] = {
            ["x"] = 253.78226074747;
            ["y"] = -306.85477132403;
          };
        };
      };
      [4] = {
        ["x"] = 323.7258729999;
        ["y"] = -167.12386713855;
        ["g"] = 18;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 323.73797439679;
            ["y"] = -182.18125984065;
          };
          [2] = {
            ["x"] = 322.82887129322;
            ["y"] = -155.36310842492;
          };
        };
      };
      [5] = {
        ["x"] = 243.28956493727;
        ["y"] = -151.50203780718;
        ["g"] = 19;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 263.51600659853;
            ["y"] = -148.13724287072;
          };
          [2] = {
            ["x"] = 223.5160595857;
            ["y"] = -152.22816737948;
          };
          [3] = {
            ["x"] = 224.65942634785;
            ["y"] = -133.07266581502;
          };
          [4] = {
            ["x"] = 223.5160595857;
            ["y"] = -152.22816737948;
          };
        };
      };
      [6] = {
        ["x"] = 242.20844762287;
        ["y"] = -134.35484048251;
        ["g"] = 20;
        ["sublevel"] = 1;
      };
      [7] = {
        ["x"] = 255.16374252428;
        ["y"] = -108.18397255798;
        ["g"] = 21;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 262.9822703498;
            ["y"] = -117.79772384291;
          };
          [2] = {
            ["x"] = 237.07318583151;
            ["y"] = -100.52496181677;
          };
        };
      };
      [8] = {
        ["x"] = 300.31040153931;
        ["y"] = -113.55108037675;
        ["g"] = 23;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 286.1984579639;
            ["y"] = -112.83323300108;
          };
          [2] = {
            ["x"] = 301.6530529939;
            ["y"] = -112.83323300108;
          };
          [3] = {
            ["x"] = 305.74396017414;
            ["y"] = -106.46963517973;
          };
          [4] = {
            ["x"] = 316.65307919285;
            ["y"] = -108.74233417142;
          };
          [5] = {
            ["x"] = 305.74396017414;
            ["y"] = -106.46963517973;
          };
          [6] = {
            ["x"] = 301.6530529939;
            ["y"] = -112.83323300108;
          };
        };
      };
    };
  };
  [8] = {
    ["name"] = "Bound Energy";
    ["id"] = 105705;
    ["count"] = 3;
    ["health"] = 430377;
    ["scale"] = 1;
    ["displayId"] = 55561;
    ["creatureType"] = "Elemental";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Fear"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [212031] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 291.45428072899;
        ["y"] = -347.12191270487;
        ["g"] = 8;
        ["sublevel"] = 1;
      };
      [2] = {
        ["x"] = 279.36599358877;
        ["y"] = -350.89074049335;
        ["g"] = 8;
        ["sublevel"] = 1;
      };
      [3] = {
        ["x"] = 287.75161654691;
        ["y"] = -177.38254880982;
        ["g"] = 16;
        ["sublevel"] = 1;
      };
      [4] = {
        ["x"] = 309.94398907626;
        ["y"] = -178.4177763309;
        ["g"] = 17;
        ["sublevel"] = 1;
      };
      [5] = {
        ["x"] = 243.25575191523;
        ["y"] = -158.89928608939;
        ["g"] = 19;
        ["sublevel"] = 1;
      };
    };
  };
  [9] = {
    ["name"] = "Arcane Manifestation";
    ["id"] = 105704;
    ["count"] = 8;
    ["health"] = 1147671;
    ["scale"] = 1;
    ["displayId"] = 54282;
    ["creatureType"] = "Elemental";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [209485] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 278.95185315419;
        ["y"] = -285.65364972037;
        ["g"] = 11;
        ["sublevel"] = 1;
      };
      [2] = {
        ["x"] = 329.8725227697;
        ["y"] = -172.79555872595;
        ["g"] = 18;
        ["sublevel"] = 1;
      };
      [3] = {
        ["x"] = 235.71055348213;
        ["y"] = -136.82024374776;
        ["g"] = 20;
        ["sublevel"] = 1;
      };
    };
  };
  [10] = {
    ["name"] = "Patrol Captain Gerdo";
    ["id"] = 104215;
    ["count"] = 0;
    ["health"] = 5019049;
    ["scale"] = 1;
    ["displayId"] = 68521;
    ["creatureType"] = "Humanoid";
    ["level"] = 72;
    ["isBoss"] = true;
    ["encounterID"] = 1718;
    ["instanceID"] = 800;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [207261] = {
      };
      [207278] = {
      };
      [207806] = {
      };
      [207815] = {
      };
      [219488] = {
      };
      [219498] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 293.4089870319;
        ["y"] = -139.24605381573;
        ["sublevel"] = 1;
      };
    };
  };
  [11] = {
    ["name"] = "Watchful Inquisitor";
    ["id"] = 105715;
    ["count"] = 4;
    ["health"] = 717294;
    ["scale"] = 1;
    ["displayId"] = 68418;
    ["creatureType"] = "Demon";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [211299] = {
      };
      [212784] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 416.21835877917;
        ["y"] = -208.53313088897;
        ["g"] = 26;
        ["sublevel"] = 1;
        ["scale"] = 1;
      };
      [2] = {
        ["x"] = 409.52977391941;
        ["y"] = -265.35263705919;
        ["g"] = 29;
        ["sublevel"] = 1;
      };
      [3] = {
        ["x"] = 413.20762042007;
        ["y"] = -343.77052209532;
        ["g"] = 32;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 438.70238455327;
            ["y"] = -318.86329872115;
          };
          [2] = {
            ["x"] = 423.24782686238;
            ["y"] = -305.22692773042;
          };
          [3] = {
            ["x"] = 408.24778170932;
            ["y"] = -315.22694482781;
          };
          [4] = {
            ["x"] = 401.8841770262;
            ["y"] = -322.49963310752;
          };
          [5] = {
            ["x"] = 403.24783168155;
            ["y"] = -331.59060562227;
          };
          [6] = {
            ["x"] = 411.88419412359;
            ["y"] = -349.77239459596;
          };
          [7] = {
            ["x"] = 417.338812745;
            ["y"] = -355.68148674125;
          };
          [8] = {
            ["x"] = 411.88419412359;
            ["y"] = -349.77239459596;
          };
          [9] = {
            ["x"] = 403.24783168155;
            ["y"] = -331.59060562227;
          };
          [10] = {
            ["x"] = 401.8841770262;
            ["y"] = -322.49963310752;
          };
          [11] = {
            ["x"] = 408.24778170932;
            ["y"] = -315.22694482781;
          };
          [12] = {
            ["x"] = 423.24782686238;
            ["y"] = -305.22692773042;
          };
        };
      };
      [4] = {
        ["x"] = 448.4039428435;
        ["y"] = -367.42269589156;
        ["g"] = 33;
        ["sublevel"] = 1;
      };
      [5] = {
        ["x"] = 468.10166277936;
        ["y"] = -342.61313263053;
        ["g"] = 34;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 466.07603627811;
            ["y"] = -358.07411151872;
          };
          [2] = {
            ["x"] = 469.25777975393;
            ["y"] = -326.7104479841;
          };
          [3] = {
            ["x"] = 473.80321675127;
            ["y"] = -312.61954647562;
          };
          [4] = {
            ["x"] = 485.16692628645;
            ["y"] = -304.43773647204;
          };
          [5] = {
            ["x"] = 510.62142028828;
            ["y"] = -303.528633467;
          };
          [6] = {
            ["x"] = 485.16692628645;
            ["y"] = -304.43773647204;
          };
          [7] = {
            ["x"] = 473.80321675127;
            ["y"] = -312.61954647562;
          };
          [8] = {
            ["x"] = 469.25777975393;
            ["y"] = -326.7104479841;
          };
        };
      };
      [6] = {
        ["x"] = 530.2054778293;
        ["y"] = -257.47841334587;
        ["g"] = 35;
        ["sublevel"] = 1;
        ["patrol"] = {
          [1] = {
            ["x"] = 548.34420159267;
            ["y"] = -246.56187108275;
          };
          [2] = {
            ["x"] = 549.70785610024;
            ["y"] = -250.65275657756;
          };
          [3] = {
            ["x"] = 531.526030083;
            ["y"] = -257.01641909197;
          };
          [4] = {
            ["x"] = 526.52604158314;
            ["y"] = -266.56186409614;
          };
          [5] = {
            ["x"] = 515.16233204795;
            ["y"] = -274.28916161114;
          };
          [6] = {
            ["x"] = 526.52604158314;
            ["y"] = -266.56186409614;
          };
          [7] = {
            ["x"] = 531.526030083;
            ["y"] = -257.01641909197;
          };
          [8] = {
            ["x"] = 549.70785610024;
            ["y"] = -250.65275657756;
          };
        };
      };
    };
  };
  [12] = {
    ["name"] = "Blazing Imp";
    ["id"] = 104295;
    ["count"] = 1;
    ["health"] = 143459;
    ["scale"] = 1;
    ["displayId"] = 17035;
    ["creatureType"] = "Demon";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [211401] = {
      };
      [211406] = {
      };
      [211412] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 421.15618249929;
        ["y"] = -201.83837899005;
        ["g"] = 26;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [2] = {
        ["x"] = 424.7050580209;
        ["y"] = -206.20113526629;
        ["g"] = 26;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [3] = {
        ["x"] = 415.17838352634;
        ["y"] = -199.96613300835;
        ["g"] = 26;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [4] = {
        ["x"] = 423.77697799735;
        ["y"] = -211.63768646921;
        ["g"] = 26;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [5] = {
        ["x"] = 475.48898474555;
        ["y"] = -274.95614111672;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [6] = {
        ["x"] = 483.92617291644;
        ["y"] = -272.26032520056;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [7] = {
        ["x"] = 471.70987728905;
        ["y"] = -265.51821940397;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
        ["patrol"] = {
          [1] = {
            ["x"] = 479.84525212951;
            ["y"] = -193.04653235656;
          };
          [2] = {
            ["x"] = 511.66346716666;
            ["y"] = -218.95567539578;
          };
          [3] = {
            ["x"] = 514.84528867037;
            ["y"] = -225.77385039876;
          };
          [4] = {
            ["x"] = 503.93620866561;
            ["y"] = -238.95568791614;
          };
          [5] = {
            ["x"] = 517.11804618299;
            ["y"] = -270.31927342287;
          };
          [6] = {
            ["x"] = 508.481606649;
            ["y"] = -285.31929744337;
          };
          [7] = {
            ["x"] = 498.48166866322;
            ["y"] = -291.22838894828;
          };
          [8] = {
            ["x"] = 458.48168263645;
            ["y"] = -257.59202642196;
          };
          [9] = {
            ["x"] = 457.5725796314;
            ["y"] = -228.50112039995;
          };
        };
      };
      [8] = {
        ["x"] = 478.33110018987;
        ["y"] = -269.33853303805;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [9] = {
        ["x"] = 477.8038709699;
        ["y"] = -265.47007056695;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [10] = {
        ["x"] = 482.38514082451;
        ["y"] = -266.37095098674;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [11] = {
        ["x"] = 481.35767097612;
        ["y"] = -277.40950044368;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [12] = {
        ["x"] = 471.22127241525;
        ["y"] = -271.35378458563;
        ["g"] = 28;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [13] = {
        ["x"] = 416.0591321201;
        ["y"] = -304.38598692608;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [14] = {
        ["x"] = 416.81212959286;
        ["y"] = -299.6986872647;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [15] = {
        ["x"] = 421.78323384008;
        ["y"] = -299.51918930481;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [16] = {
        ["x"] = 417.49210819523;
        ["y"] = -309.92825136421;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [17] = {
        ["x"] = 426.39921631957;
        ["y"] = -309.02114636783;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
        ["patrol"] = {
          [1] = {
            ["x"] = 423.25491342541;
            ["y"] = -306.66661761093;
          };
          [2] = {
            ["x"] = 456.22878907083;
            ["y"] = -326.49085302845;
          };
          [3] = {
            ["x"] = 455.31972507974;
            ["y"] = -338.30901653129;
          };
          [4] = {
            ["x"] = 445.77426056859;
            ["y"] = -350.58175104362;
          };
          [5] = {
            ["x"] = 415.6307522703;
            ["y"] = -349.8989326334;
          };
          [6] = {
            ["x"] = 392.90352826967;
            ["y"] = -313.53530010589;
          };
          [7] = {
            ["x"] = 395.17624676834;
            ["y"] = -300.80805310498;
          };
          [8] = {
            ["x"] = 405.63073625663;
            ["y"] = -298.53533460631;
          };
        };
      };
      [18] = {
        ["x"] = 421.79963689818;
        ["y"] = -306.10500749501;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [19] = {
        ["x"] = 422.14576838626;
        ["y"] = -310.68798405809;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
      [20] = {
        ["x"] = 425.46550495385;
        ["y"] = -302.19878589319;
        ["g"] = 31;
        ["sublevel"] = 1;
        ["scale"] = 0.7;
      };
    };
  };
  [13] = {
    ["name"] = "Shadow Mistress";
    ["id"] = 104300;
    ["count"] = 4;
    ["health"] = 645566;
    ["scale"] = 1;
    ["displayId"] = 10923;
    ["creatureType"] = "Demon";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Imprison"] = true;
      ["Stun"] = true;
      ["Slow"] = true;
    };
    ["spells"] = {
      [211470] = {
      };
      [211473] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 447.70786733357;
        ["y"] = -230.04164346474;
        ["g"] = 27;
        ["sublevel"] = 1;
      };
      [2] = {
        ["x"] = 393.90757340396;
        ["y"] = -276.5908306018;
        ["g"] = 30;
        ["sublevel"] = 1;
      };
      [3] = {
        ["x"] = 407.62261334573;
        ["y"] = -349.58700535737;
        ["g"] = 32;
        ["sublevel"] = 1;
      };
      [4] = {
        ["x"] = 447.58350828932;
        ["y"] = -377.02471803351;
        ["g"] = 33;
        ["sublevel"] = 1;
      };
      [5] = {
        ["x"] = 534.97744303366;
        ["y"] = -251.26957984805;
        ["g"] = 35;
        ["sublevel"] = 1;
      };
    };
  };
  [14] = {
    ["name"] = "Legion Hound";
    ["id"] = 104277;
    ["count"] = 2;
    ["health"] = 286918;
    ["scale"] = 1;
    ["displayId"] = 62513;
    ["creatureType"] = "Demon";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
      ["Silence"] = true;
      ["Fear"] = true;
      ["Disorient"] = true;
      ["Stun"] = true;
    };
    ["spells"] = {
      [211384] = {
      };
      [211391] = {
      };
      [211477] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 442.13360291428;
        ["y"] = -237.28047925856;
        ["g"] = 27;
        ["sublevel"] = 1;
      };
      [2] = {
        ["x"] = 417.2637105983;
        ["y"] = -270.2861073956;
        ["g"] = 29;
        ["sublevel"] = 1;
      };
      [3] = {
        ["x"] = 390.60857129136;
        ["y"] = -286.74285469172;
        ["g"] = 30;
        ["sublevel"] = 1;
      };
      [4] = {
        ["x"] = 463.78561815953;
        ["y"] = -349.29518714398;
        ["g"] = 34;
        ["sublevel"] = 1;
      };
      [5] = {
        ["x"] = 539.08913814193;
        ["y"] = -260.41085679807;
        ["g"] = 35;
        ["sublevel"] = 1;
      };
    };
  };
  [15] = {
    ["name"] = "Felbound Enforcer";
    ["id"] = 104278;
    ["count"] = 10;
    ["health"] = 1291130;
    ["scale"] = 1;
    ["displayId"] = 68765;
    ["creatureType"] = "Demon";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [211464] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 396.13204921856;
        ["y"] = -328.72945571547;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
        ["patrol"] = {
          [1] = {
            ["x"] = 395.31038736291;
            ["y"] = -340.75671109095;
          };
          [2] = {
            ["x"] = 397.01942651325;
            ["y"] = -326.12620352057;
          };
          [3] = {
            ["x"] = 414.29214952545;
            ["y"] = -310.21713501594;
          };
          [4] = {
            ["x"] = 422.9285500455;
            ["y"] = -311.12623802099;
          };
          [5] = {
            ["x"] = 414.29214952545;
            ["y"] = -310.21713501594;
          };
          [6] = {
            ["x"] = 397.01942651325;
            ["y"] = -326.12620352057;
          };
        };
      };
      [2] = {
        ["x"] = 557.3228417771;
        ["y"] = -262.57735274652;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
        ["patrol"] = {
          [1] = {
            ["x"] = 566.87135013531;
            ["y"] = -275.63954734324;
          };
          [2] = {
            ["x"] = 559.70856648389;
            ["y"] = -269.32510465575;
          };
          [3] = {
            ["x"] = 552.89048901578;
            ["y"] = -251.14327863851;
          };
          [4] = {
            ["x"] = 536.52679098073;
            ["y"] = -251.59783014103;
          };
          [5] = {
            ["x"] = 525.61774998991;
            ["y"] = -261.5978461547;
          };
          [6] = {
            ["x"] = 511.52680946748;
            ["y"] = -259.32508864208;
          };
          [7] = {
            ["x"] = 525.61774998991;
            ["y"] = -261.5978461547;
          };
          [8] = {
            ["x"] = 536.52679098073;
            ["y"] = -251.59783014103;
          };
          [9] = {
            ["x"] = 552.89048901578;
            ["y"] = -251.14327863851;
          };
          [10] = {
            ["x"] = 559.70856648389;
            ["y"] = -269.32510465575;
          };
        };
      };
      [3] = {
        ["x"] = 480.03979847751;
        ["y"] = -199.82439611446;
        ["sublevel"] = 1;
        ["scale"] = 1.4;
        ["patrol"] = {
          [1] = {
            ["x"] = 463.43570075413;
            ["y"] = -177.73673747779;
          };
          [2] = {
            ["x"] = 473.67594747759;
            ["y"] = -184.90218738127;
          };
          [3] = {
            ["x"] = 471.6175887856;
            ["y"] = -196.37311499756;
          };
          [4] = {
            ["x"] = 488.43576029527;
            ["y"] = -203.19130950751;
          };
          [5] = {
            ["x"] = 471.6175887856;
            ["y"] = -196.37311499756;
          };
          [6] = {
            ["x"] = 473.67594747759;
            ["y"] = -184.90218738127;
          };
        };
      };
      [4] = {
        ["x"] = 428.90924542172;
        ["y"] = -373.438152777;
        ["sublevel"] = 1;
        ["scale"] = 1.5;
        ["patrol"] = {
          [1] = {
            ["x"] = 413.44390501709;
            ["y"] = -345.84589630387;
          };
          [2] = {
            ["x"] = 415.31882254965;
            ["y"] = -355.22096676424;
          };
          [3] = {
            ["x"] = 418.03836876707;
            ["y"] = -363.6273504712;
          };
          [4] = {
            ["x"] = 435.94821244373;
            ["y"] = -380.47711979901;
          };
          [5] = {
            ["x"] = 437.45865765591;
            ["y"] = -388.93437566169;
          };
          [6] = {
            ["x"] = 435.94821244373;
            ["y"] = -380.47711979901;
          };
          [7] = {
            ["x"] = 418.03836876707;
            ["y"] = -363.6273504712;
          };
          [8] = {
            ["x"] = 415.31882254965;
            ["y"] = -355.22096676424;
          };
        };
      };
    };
  };
  [16] = {
    ["name"] = "Imacu'tya";
    ["id"] = 104275;
    ["count"] = 0;
    ["health"] = 2008424;
    ["scale"] = 1;
    ["displayId"] = 17543;
    ["creatureType"] = "Demon";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [209378] = {
      };
      [209713] = {
      };
      [397892] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 489.34217702513;
        ["y"] = -344.13073553844;
        ["sublevel"] = 1;
        ["scale"] = 1.6;
      };
    };
  };
  [17] = {
    ["name"] = "Baalgar the Watchful";
    ["id"] = 104274;
    ["count"] = 0;
    ["health"] = 1864966;
    ["scale"] = 1;
    ["displayId"] = 63588;
    ["creatureType"] = "Demon";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [207980] = {
      };
      [207981] = {
      };
      [209719] = {
      };
      [397907] = {
      };
      [397908] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 490.52788551926;
        ["y"] = -328.81619622564;
        ["sublevel"] = 1;
        ["scale"] = 1.6;
      };
    };
  };
  [18] = {
    ["name"] = "Jazshariu";
    ["id"] = 104273;
    ["count"] = 0;
    ["health"] = 4303767;
    ["scale"] = 1;
    ["displayId"] = 9018;
    ["creatureType"] = "Demon";
    ["level"] = 71;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [207850] = {
      };
      [207979] = {
      };
      [397897] = {
      };
      [397903] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 505.43826677384;
        ["y"] = -324.02934239492;
        ["sublevel"] = 1;
        ["scale"] = 1.6;
      };
    };
  };
  [19] = {
    ["name"] = "Talixae Flamewreath";
    ["id"] = 104217;
    ["count"] = 0;
    ["health"] = 3585035;
    ["scale"] = 1;
    ["displayId"] = 69267;
    ["creatureType"] = "Demon";
    ["level"] = 72;
    ["isBoss"] = true;
    ["encounterID"] = 1719;
    ["instanceID"] = 800;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [207881] = {
      };
      [207887] = {
      };
      [207906] = {
      };
      [207907] = {
      };
      [208165] = {
      };
      [209722] = {
      };
      [211457] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 521.37597819604;
        ["y"] = -353.38661176367;
        ["sublevel"] = 1;
        ["scale"] = 1.4;
      };
    };
  };
  [20] = {
    ["name"] = "Gerenth the Vile";
    ["id"] = 108151;
    ["count"] = 12;
    ["health"] = 946828;
    ["scale"] = 1;
    ["displayId"] = 69968;
    ["creatureType"] = "Humanoid";
    ["level"] = 70;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [214692] = {
      };
      [373364] = {
      };
      [373552] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 557.25604495891;
        ["y"] = -392.7159213229;
        ["sublevel"] = 1;
        ["scale"] = 1.8;
      };
    };
  };
  [21] = {
    ["name"] = "Advisor Melandrus";
    ["id"] = 104218;
    ["count"] = 0;
    ["health"] = 5019049;
    ["scale"] = 1;
    ["displayId"] = 70592;
    ["creatureType"] = "Humanoid";
    ["level"] = 72;
    ["isBoss"] = true;
    ["encounterID"] = 1720;
    ["instanceID"] = 800;
    ["characteristics"] = {
      ["Taunt"] = true;
    };
    ["spells"] = {
      [209602] = {
      };
      [209628] = {
      };
      [209667] = {
      };
      [209676] = {
      };
      [209678] = {
      };
    };
    ["clones"] = {
      [1] = {
        ["x"] = 590.33767941904;
        ["y"] = -426.69459254991;
        ["sublevel"] = 1;
        ["scale"] = 1.4;
      };
    };
  };
};
