local MDT = MDT
local L = MDT.L

local dungeonIndex = 44
MDT.dungeonList[dungeonIndex] = L["TheAzureVault"]
MDT.mapInfo[dungeonIndex] = {};

local zones = { 2073, 2074, 2075, 2076, 2077 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'AzureVault' },
}

MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["TheAzureVault"],
}

MDT.mapPOIs[dungeonIndex] = {};

MDT.dungeonTotalCount[dungeonIndex] = { normal = 410, teeming = 1000, teemingEnabled = true }

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Conjured Lasher",
    ["id"] = 196102,
    ["count"] = 5,
    ["health"] = 4833367,
    ["scale"] = 1,
    ["displayId"] = 76261,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [387564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 320.73947780124,
        ["y"] = -72.678637958431,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [2] = {
        ["x"] = 311.90847374884,
        ["y"] = -83.200831031417,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [3] = {
        ["x"] = 307.51158483339,
        ["y"] = -69.876220268192,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [4] = {
        ["x"] = 325.2194791556,
        ["y"] = -136.77823005047,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [5] = {
        ["x"] = 317.11041829434,
        ["y"] = -144.56679392356,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [6] = {
        ["x"] = 312.51513317504,
        ["y"] = -133.16581021035,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [7] = {
        ["x"] = 274.488120592,
        ["y"] = -120.79629844554,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [8] = {
        ["x"] = 272.64137451833,
        ["y"] = -103.29192291265,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [9] = {
        ["x"] = 284.20404541004,
        ["y"] = -112.1258463848,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [10] = {
        ["x"] = 159.66677281527,
        ["y"] = -50.83111131076,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [11] = {
        ["x"] = 222.24122450624,
        ["y"] = -107.74730397429,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [12] = {
        ["x"] = 178.08887933042,
        ["y"] = -39.97058233872,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [13] = {
        ["x"] = 172.59582473647,
        ["y"] = -51.3337273625,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [14] = {
        ["x"] = 233.8820917096,
        ["y"] = -100.77637482438,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [15] = {
        ["x"] = 194.40764687954,
        ["y"] = -90.452607704743,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [16] = {
        ["x"] = 184.51760027866,
        ["y"] = -80.038034968819,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
    },
  },
  [2] = {
    ["name"] = "Shrieking Whelp",
    ["id"] = 187159,
    ["count"] = 1,
    ["health"] = 2685204,
    ["scale"] = 1,
    ["displayId"] = 102138,
    ["creatureType"] = "Dragonkin",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Hibernate"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [370223] = {
      },
      [370225] = {
      },
      [397726] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 355.3595035106,
        ["y"] = -90.705346773942,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [2] = {
        ["x"] = 224.21757194696,
        ["y"] = -84.274603585053,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [3] = {
        ["x"] = 165.91176332779,
        ["y"] = -40.78608995926,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Arcane Tender",
    ["id"] = 196115,
    ["count"] = 8,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 107894,
    ["creatureType"] = "Elemental",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [375596] = {
      },
      [375602] = {
      },
      [375649] = {
      },
      [375652] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 261.34712281449,
        ["y"] = -113.47629327999,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
      [2] = {
        ["x"] = 147.64387886421,
        ["y"] = -36.615996176298,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
    },
  },
  [4] = {
    ["name"] = "Crystal Fury",
    ["id"] = 187160,
    ["count"] = 5,
    ["health"] = 7527186,
    ["scale"] = 1,
    ["displayId"] = 64607,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [370764] = {
      },
      [389686] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 223.77085639918,
        ["y"] = -59.206659724754,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 212.51163278099,
        ["y"] = -48.681625408767,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 520.81589218929,
        ["y"] = -161.07957057179,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 547.0695348703,
        ["y"] = -161.44642898675,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 549.43450399097,
        ["y"] = -182.62290227713,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 521.7528948155,
        ["y"] = -183.41541374013,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 329.72477275689,
        ["y"] = -112.31608519647,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [8] = {
        ["x"] = 335.94541659116,
        ["y"] = -95.837876109203,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [9] = {
        ["x"] = 345.43941609782,
        ["y"] = -109.3431995556,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [5] = {
    ["name"] = "Crystal Thrasher",
    ["id"] = 187139,
    ["count"] = 8,
    ["health"] = 10948634,
    ["scale"] = 1,
    ["displayId"] = 106012,
    ["creatureType"] = "Elemental",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [370766] = {
      },
      [371005] = {
      },
      [371007] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 207.17917799908,
        ["y"] = -65.640094198323,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
      [2] = {
        ["x"] = 534.0036874922,
        ["y"] = -172.58749077489,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
    },
  },
  [6] = {
    ["name"] = "Volatile Sapling",
    ["id"] = 191313,
    ["count"] = 1,
    ["health"] = 671302,
    ["scale"] = 1,
    ["displayId"] = 107890,
    ["creatureType"] = "Aberration",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [375591] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 75.413619610255,
        ["y"] = -119.56034808169,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [2] = {
        ["x"] = 84.219735554093,
        ["y"] = -111.67523443752,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [3] = {
        ["x"] = 83.597490629293,
        ["y"] = -120.57794487537,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [4] = {
        ["x"] = 75.235500957215,
        ["y"] = -110.61961969587,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [5] = {
        ["x"] = 165.59643003128,
        ["y"] = -125.85900829908,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [6] = {
        ["x"] = 174.23805717122,
        ["y"] = -130.95946446541,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [7] = {
        ["x"] = 167.79133772132,
        ["y"] = -117.60417944464,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [8] = {
        ["x"] = 174.6499793657,
        ["y"] = -121.12245340072,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [9] = {
        ["x"] = 141.72218484069,
        ["y"] = -196.50506063978,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [10] = {
        ["x"] = 131.74705878317,
        ["y"] = -194.51219181252,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [11] = {
        ["x"] = 123.1852958865,
        ["y"] = -198.93241670586,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [12] = {
        ["x"] = 133.71486244971,
        ["y"] = -203.52440867924,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
    },
  },
  [7] = {
    ["name"] = "Arcane Tender",
    ["id"] = 191164,
    ["count"] = 8,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 107894,
    ["creatureType"] = "Elemental",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [375596] = {
      },
      [375602] = {
      },
      [375649] = {
      },
      [375652] = {
      },
      [375732] = {
      },
    },
    ["clones"] = {
      [3] = {
        ["x"] = 130.19956223838,
        ["y"] = -104.19414330054,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
      [4] = {
        ["x"] = 167.9651217156,
        ["y"] = -169.61206670244,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
      [5] = {
        ["x"] = 94.838146197764,
        ["y"] = -169.68820392698,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [8] = {
    ["name"] = "Leymor",
    ["id"] = 186644,
    ["count"] = 0,
    ["health"] = 46843573,
    ["scale"] = 1,
    ["displayId"] = 107127,
    ["creatureType"] = "Elemental",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2492,
    ["instanceID"] = 1203,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [374364] = {
      },
      [374567] = {
      },
      [374570] = {
      },
      [374582] = {
      },
      [374720] = {
      },
      [374729] = {
      },
      [374731] = {
      },
      [374789] = {
      },
      [375729] = {
      },
      [386660] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 130.26885895658,
        ["y"] = -149.96350623666,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [9] = {
    ["name"] = "Shrieking Whelp",
    ["id"] = 188100,
    ["count"] = 1,
    ["health"] = 2685204,
    ["scale"] = 1,
    ["displayId"] = 102138,
    ["creatureType"] = "Dragonkin",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Hibernate"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [370225] = {
      },
      [371042] = {
      },
      [397726] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 546.6545943875,
        ["y"] = -133.84318153119,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [2] = {
        ["x"] = 531.49400847757,
        ["y"] = -127.89511629251,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
      [3] = {
        ["x"] = 535.24416790439,
        ["y"] = -144.59900636513,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Arcane Elemental",
    ["id"] = 186741,
    ["count"] = 5,
    ["health"] = 6713011,
    ["scale"] = 1,
    ["displayId"] = 107911,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [371306] = {
      },
      [386546] = {
      },
      [386549] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 565.72295271518,
        ["y"] = -194.04114608197,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [2] = {
        ["x"] = 569.53211405265,
        ["y"] = -205.64241077433,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [3] = {
        ["x"] = 633.65079694812,
        ["y"] = -137.39770401949,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [4] = {
        ["x"] = 641.94295837513,
        ["y"] = -124.0010658008,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [5] = {
        ["x"] = 686.03601510333,
        ["y"] = -109.96957951144,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [6] = {
        ["x"] = 684.56414510577,
        ["y"] = -123.73045978255,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [7] = {
        ["x"] = 706.69390460527,
        ["y"] = -132.37519189155,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [8] = {
        ["x"] = 160.50267428136,
        ["y"] = -334.65553065846,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [9] = {
        ["x"] = 180.18911491195,
        ["y"] = -346.63098702123,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [10] = {
        ["x"] = 187.78256175423,
        ["y"] = -392.79837064204,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
    },
  },
  [11] = {
    ["name"] = "Unstable Curator",
    ["id"] = 187154,
    ["count"] = 8,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 68973,
    ["creatureType"] = "Elemental",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [371352] = {
      },
      [371358] = {
      },
      [389804] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 627.87347845098,
        ["y"] = -123.94890271236,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
      [2] = {
        ["x"] = 666.64727491328,
        ["y"] = -209.76365649447,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
      [3] = {
        ["x"] = 721.36070925941,
        ["y"] = -135.19935029339,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
    },
  },
  [12] = {
    ["name"] = "Rune Seal Keeper",
    ["id"] = 187155,
    ["count"] = 5,
    ["health"] = 6713011,
    ["scale"] = 1,
    ["displayId"] = 105096,
    ["creatureType"] = "Dragonkin",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Hibernate"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [377488] = {
      },
      [377503] = {
      },
      [378065] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 671.81028563479,
        ["y"] = -115.62006442005,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 179.53274142766,
        ["y"] = -383.35707672704,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
        ["patrol"] = {
          [1] = {
            ["x"] = 179.53274142766,
            ["y"] = -383.35707672704,
          },
          [2] = {
            ["x"] = 176.319686222,
            ["y"] = -367.32167728687,
          },
          [3] = {
            ["x"] = 169.80620275526,
            ["y"] = -357.74300062679,
          },
          [4] = {
            ["x"] = 147.58372201327,
            ["y"] = -347.78118303898,
          },
          [5] = {
            ["x"] = 130.72521425949,
            ["y"] = -346.63176025579,
          },
          [6] = {
            ["x"] = 147.58372201327,
            ["y"] = -347.78118303898,
          },
          [7] = {
            ["x"] = 169.80620275526,
            ["y"] = -357.74300062679,
          },
          [8] = {
            ["x"] = 176.319686222,
            ["y"] = -367.32167728687,
          },
          [9] = {
            ["x"] = 179.53274142766,
            ["y"] = -383.35707672704,
          },
          [10] = {
            ["x"] = 177.09348698462,
            ["y"] = -405.87879566572,
          },
          [11] = {
            ["x"] = 170.18446169611,
            ["y"] = -415.67992638854,
          },
          [12] = {
            ["x"] = 153.21745478901,
            ["y"] = -428.2767922182,
          },
          [13] = {
            ["x"] = 141.16685152212,
            ["y"] = -428.11612939871,
          },
          [14] = {
            ["x"] = 126.38482402814,
            ["y"] = -425.06331057865,
          },
          [15] = {
            ["x"] = 119.47581712736,
            ["y"] = -422.17115917501,
          },
          [16] = {
            ["x"] = 126.38482402814,
            ["y"] = -425.06331057865,
          },
          [17] = {
            ["x"] = 141.16685152212,
            ["y"] = -428.11612939871,
          },
          [18] = {
            ["x"] = 153.21745478901,
            ["y"] = -428.2767922182,
          },
          [19] = {
            ["x"] = 170.18446169611,
            ["y"] = -415.67992638854,
          },
          [20] = {
            ["x"] = 177.09348698462,
            ["y"] = -405.87879566572,
          },
        },
      },
      [3] = {
        ["x"] = 313.54283809744,
        ["y"] = -381.04815172542,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 326.27805768378,
        ["y"] = -340.69102863887,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 345.27304331832,
        ["y"] = -431.84889320172,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [13] = {
    ["name"] = "Crystal Fury",
    ["id"] = 196116,
    ["count"] = 5,
    ["health"] = 7384312,
    ["scale"] = 1,
    ["displayId"] = 64607,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [370764] = {
      },
      [389686] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 656.26226161117,
        ["y"] = -196.23290003208,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 674.27711066587,
        ["y"] = -196.76114303777,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 693.51110475667,
        ["y"] = -172.80692302363,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 713.62515932678,
        ["y"] = -146.65582003049,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 165.03600633069,
        ["y"] = -447.48903601896,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 179.78539948998,
        ["y"] = -437.68367901844,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [14] = {
    ["name"] = "Crystal Thrasher",
    ["id"] = 196117,
    ["count"] = 8,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 106012,
    ["creatureType"] = "Elemental",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [370766] = {
      },
      [371005] = {
      },
      [371007] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 706.35206172597,
        ["y"] = -182.37622928933,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
      [2] = {
        ["x"] = 164.85607247588,
        ["y"] = -428.86476712679,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
      },
    },
  },
  [15] = {
    ["name"] = "Arcane Construct",
    ["id"] = 186740,
    ["count"] = 5,
    ["health"] = 8055613,
    ["scale"] = 1,
    ["displayId"] = 104019,
    ["creatureType"] = "Elemental",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [387067] = {
      },
      [387122] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 114.17009732345,
        ["y"] = -363.49501421774,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 104.95055229039,
        ["y"] = -351.97001169623,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 163.81653654332,
        ["y"] = -348.80957621371,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 111.00936696188,
        ["y"] = -424.76829065297,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 119.57063024708,
        ["y"] = -411.92722858766,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [16] = {
    ["name"] = "Astral Attendant",
    ["id"] = 189555,
    ["count"] = 3,
    ["health"] = 4027806,
    ["scale"] = 1,
    ["displayId"] = 107525,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [374868] = {
      },
      [374885] = {
      },
      [378065] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 174.73652555648,
        ["y"] = -396.4942354476,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [2] = {
        ["x"] = 297.99357801229,
        ["y"] = -378.49291373412,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [3] = {
        ["x"] = 325.29785656463,
        ["y"] = -353.61879042241,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [4] = {
        ["x"] = 338.65515671844,
        ["y"] = -345.91826525454,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [5] = {
        ["x"] = 354.11126921635,
        ["y"] = -442.83071375036,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [6] = {
        ["x"] = 358.9206507604,
        ["y"] = -428.8743983894,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
    },
  },
  [17] = {
    ["name"] = "Vault Guard",
    ["id"] = 190510,
    ["count"] = 5,
    ["health"] = 7384312,
    ["scale"] = 1,
    ["displayId"] = 104202,
    ["creatureType"] = "Dragonkin",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Hibernate"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [374778] = {
      },
      [377105] = {
      },
      [378065] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 267.46783211794,
        ["y"] = -396.0985886223,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 267.32174516142,
        ["y"] = -380.17022284874,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 304.40733832744,
        ["y"] = -390.8808049366,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
        ["patrol"] = {
          [1] = {
            ["x"] = 305.3496733264,
            ["y"] = -389.534614832,
          },
          [2] = {
            ["x"] = 304.65701785315,
            ["y"] = -400.52215413334,
          },
          [3] = {
            ["x"] = 307.01641944865,
            ["y"] = -407.33814235159,
          },
          [4] = {
            ["x"] = 310.42438730686,
            ["y"] = -418.34855312611,
          },
          [5] = {
            ["x"] = 307.01641944865,
            ["y"] = -407.33814235159,
          },
          [6] = {
            ["x"] = 304.65701785315,
            ["y"] = -400.52215413334,
          },
          [7] = {
            ["x"] = 305.3496733264,
            ["y"] = -389.534614832,
          },
          [8] = {
            ["x"] = 306.30961767607,
            ["y"] = -374.58309620355,
          },
          [9] = {
            ["x"] = 310.98555873765,
            ["y"] = -366.24770454568,
          },
          [10] = {
            ["x"] = 315.76317269351,
            ["y"] = -363.80806693712,
          },
          [11] = {
            ["x"] = 310.98555873765,
            ["y"] = -366.24770454568,
          },
          [12] = {
            ["x"] = 306.30961767607,
            ["y"] = -374.58309620355,
          },
        },
      },
      [4] = {
        ["x"] = 377.30879486925,
        ["y"] = -366.24819724572,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 398.46460866453,
        ["y"] = -407.28515747639,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 383.96363768516,
        ["y"] = -434.53221548562,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [18] = {
    ["name"] = "Scalebane Lieutenant",
    ["id"] = 191739,
    ["count"] = 8,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["displayId"] = 104234,
    ["creatureType"] = "Dragonkin",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [374778] = {
      },
      [377105] = {
      },
      [378065] = {
      },
      [391118] = {
      },
      [391120] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 318.57731458403,
        ["y"] = -417.63046103274,
        ["sublevel"] = 1,
        ["scale"] = 2.2,
        ["patrol"] = {
          [1] = {
            ["x"] = 316.01407627843,
            ["y"] = -417.18814580057,
          },
          [2] = {
            ["x"] = 307.54071758052,
            ["y"] = -402.09507853,
          },
          [3] = {
            ["x"] = 305.18131598502,
            ["y"] = -382.17144200819,
          },
          [4] = {
            ["x"] = 311.73516263759,
            ["y"] = -367.49086930795,
          },
          [5] = {
            ["x"] = 326.41575033833,
            ["y"] = -360.41274702429,
          },
          [6] = {
            ["x"] = 343.71782869845,
            ["y"] = -356.48045103317,
          },
          [7] = {
            ["x"] = 355.7768957388,
            ["y"] = -359.8884338919,
          },
          [8] = {
            ["x"] = 362.59283145522,
            ["y"] = -366.70440710963,
          },
          [9] = {
            ["x"] = 368.88449904081,
            ["y"] = -375.35546879046,
          },
          [10] = {
            ["x"] = 373.34115316589,
            ["y"] = -379.549898847,
          },
          [11] = {
            ["x"] = 383.04078860969,
            ["y"] = -377.71484788519,
          },
          [12] = {
            ["x"] = 386.97305459978,
            ["y"] = -379.8120554132,
          },
          [13] = {
            ["x"] = 389.85678432819,
            ["y"] = -385.05511923478,
          },
          [14] = {
            ["x"] = 389.33245619528,
            ["y"] = -390.56033962257,
          },
          [15] = {
            ["x"] = 388.80812806237,
            ["y"] = -401.30863133219,
          },
          [16] = {
            ["x"] = 386.18660740197,
            ["y"] = -410.48396864412,
          },
          [17] = {
            ["x"] = 381.2057151471,
            ["y"] = -411.79472147406,
          },
          [18] = {
            ["x"] = 375.70046475828,
            ["y"] = -411.27043834271,
          },
          [19] = {
            ["x"] = 368.62234997488,
            ["y"] = -410.22181207793,
          },
          [20] = {
            ["x"] = 362.8550105222,
            ["y"] = -413.89196650337,
          },
          [21] = {
            ["x"] = 359.18486359701,
            ["y"] = -420.70794722136,
          },
          [22] = {
            ["x"] = 351.5824206807,
            ["y"] = -425.42669041029,
          },
          [23] = {
            ["x"] = 335.59108765027,
            ["y"] = -425.95101104294,
          },
          [24] = {
            ["x"] = 324.5806468747,
            ["y"] = -424.90239977868,
          },
        },
      },
    },
  },
  [19] = {
    ["name"] = "Azureblade",
    ["id"] = 186739,
    ["count"] = 0,
    ["health"] = 33459695,
    ["scale"] = 1,
    ["displayId"] = 106829,
    ["creatureType"] = "Dragonkin",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2505,
    ["instanceID"] = 1203,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [372222] = {
      },
      [378734] = {
      },
      [384132] = {
      },
      [384223] = {
      },
      [384625] = {
      },
      [385578] = {
      },
      [385579] = {
      },
      [390462] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 345.18021201236,
        ["y"] = -389.6942983341,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [20] = {
    ["name"] = "Drakonid Breaker",
    ["id"] = 187240,
    ["count"] = 8,
    ["health"] = 10740817,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 109739,
    ["creatureType"] = "Dragonkin",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [391136] = {
      },
      [391143] = {
      },
      [396991] = {
      },
      [436652] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 417.05498156632,
        ["y"] = -490.02207407987,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [2] = {
        ["x"] = 514.41498513538,
        ["y"] = -425.74985906174,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 2,
        ["patrol"] = {
          [1] = {
            ["x"] = 514.41498513538,
            ["y"] = -425.74985906174,
          },
          [2] = {
            ["x"] = 511.99436523676,
            ["y"] = -439.40452167263,
          },
          [3] = {
            ["x"] = 511.67305801023,
            ["y"] = -448.56296363765,
          },
          [4] = {
            ["x"] = 511.83373001123,
            ["y"] = -457.0787084048,
          },
          [5] = {
            ["x"] = 513.60112202223,
            ["y"] = -468.96862955003,
          },
          [6] = {
            ["x"] = 511.83373001123,
            ["y"] = -457.0787084048,
          },
          [7] = {
            ["x"] = 511.67305801023,
            ["y"] = -448.56296363765,
          },
          [8] = {
            ["x"] = 511.99436523676,
            ["y"] = -439.40452167263,
          },
          [9] = {
            ["x"] = 514.41498513538,
            ["y"] = -425.74985906174,
          },
          [10] = {
            ["x"] = 514.08313802524,
            ["y"] = -409.03704459637,
          },
          [11] = {
            ["x"] = 516.01123881271,
            ["y"] = -396.98646983787,
          },
          [12] = {
            ["x"] = 518.42137399091,
            ["y"] = -387.66735587185,
          },
          [13] = {
            ["x"] = 521.31350678438,
            ["y"] = -379.3122831057,
          },
          [14] = {
            ["x"] = 524.68769235632,
            ["y"] = -368.70776555008,
          },
          [15] = {
            ["x"] = 521.31350678438,
            ["y"] = -379.3122831057,
          },
          [16] = {
            ["x"] = 518.42137399091,
            ["y"] = -387.66735587185,
          },
          [17] = {
            ["x"] = 516.01123881271,
            ["y"] = -396.98646983787,
          },
          [18] = {
            ["x"] = 514.08313802524,
            ["y"] = -409.03704459637,
          },
        },
      },
      [3] = {
        ["x"] = 497.57467295536,
        ["y"] = -320.20133295635,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [4] = {
        ["x"] = 586.41003683028,
        ["y"] = -379.94558091207,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
      [5] = {
        ["x"] = 598.51686792406,
        ["y"] = -368.1688908069,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [21] = {
    ["name"] = "Tarasek Delver",
    ["id"] = 187242,
    ["count"] = 3,
    ["health"] = 4027806,
    ["scale"] = 1,
    ["displayId"] = 106882,
    ["creatureType"] = "Dragonkin",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Hibernate"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [386640] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 452.30914490816,
        ["y"] = -485.04385589836,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
        ["patrol"] = {
          [1] = {
            ["x"] = 457.58303417944,
            ["y"] = -486.50882327757,
          },
          [2] = {
            ["x"] = 455.05002609168,
            ["y"] = -477.24860829543,
          },
          [3] = {
            ["x"] = 451.00306492657,
            ["y"] = -470.71118688131,
          },
          [4] = {
            ["x"] = 444.15431482825,
            ["y"] = -461.99458936959,
          },
          [5] = {
            ["x"] = 451.00306492657,
            ["y"] = -470.71118688131,
          },
          [6] = {
            ["x"] = 455.05002609168,
            ["y"] = -477.24860829543,
          },
          [7] = {
            ["x"] = 457.58303417944,
            ["y"] = -486.50882327757,
          },
          [8] = {
            ["x"] = 455.68941938681,
            ["y"] = -494.94395328081,
          },
          [9] = {
            ["x"] = 451.44102907585,
            ["y"] = -499.92485662062,
          },
          [10] = {
            ["x"] = 444.84863395618,
            ["y"] = -504.31977971487,
          },
          [11] = {
            ["x"] = 451.44102907585,
            ["y"] = -499.92485662062,
          },
          [12] = {
            ["x"] = 455.68941938681,
            ["y"] = -494.94395328081,
          },
        },
      },
      [2] = {
        ["x"] = 495.20962477309,
        ["y"] = -482.27568032411,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
        ["patrol"] = {
          [1] = {
            ["x"] = 495.20962477309,
            ["y"] = -482.27568032411,
          },
          [2] = {
            ["x"] = 491.58126268242,
            ["y"] = -475.31331747038,
          },
          [3] = {
            ["x"] = 487.03984871811,
            ["y"] = -468.86742998607,
          },
          [4] = {
            ["x"] = 479.12901481119,
            ["y"] = -463.30053382673,
          },
          [5] = {
            ["x"] = 471.3646424351,
            ["y"] = -460.95657931387,
          },
          [6] = {
            ["x"] = 467.26271365497,
            ["y"] = -458.31963467823,
          },
          [7] = {
            ["x"] = 467.26271365497,
            ["y"] = -451.28775437439,
          },
          [8] = {
            ["x"] = 467.26271365497,
            ["y"] = -458.31963467823,
          },
          [9] = {
            ["x"] = 471.3646424351,
            ["y"] = -460.95657931387,
          },
          [10] = {
            ["x"] = 479.12901481119,
            ["y"] = -463.30053382673,
          },
          [11] = {
            ["x"] = 487.03984871811,
            ["y"] = -468.86742998607,
          },
          [12] = {
            ["x"] = 491.58126268242,
            ["y"] = -475.31331747038,
          },
          [13] = {
            ["x"] = 495.20962477309,
            ["y"] = -482.27568032411,
          },
          [14] = {
            ["x"] = 494.36470237945,
            ["y"] = -489.67004724425,
          },
          [15] = {
            ["x"] = 491.87425280521,
            ["y"] = -494.50445552267,
          },
          [16] = {
            ["x"] = 487.47935066757,
            ["y"] = -497.43440285506,
          },
          [17] = {
            ["x"] = 477.81054249337,
            ["y"] = -501.24333312977,
          },
          [18] = {
            ["x"] = 474.73407914299,
            ["y"] = -505.05226340447,
          },
          [19] = {
            ["x"] = 472.8296265796,
            ["y"] = -510.32616315405,
          },
          [20] = {
            ["x"] = 474.73407914299,
            ["y"] = -505.05226340447,
          },
          [21] = {
            ["x"] = 477.81054249337,
            ["y"] = -501.24333312977,
          },
          [22] = {
            ["x"] = 487.47935066757,
            ["y"] = -497.43440285506,
          },
          [23] = {
            ["x"] = 491.87425280521,
            ["y"] = -494.50445552267,
          },
          [24] = {
            ["x"] = 494.36470237945,
            ["y"] = -489.67004724425,
          },
        },
      },
      [3] = {
        ["x"] = 466.6380362232,
        ["y"] = -483.84520475754,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [4] = {
        ["x"] = 472.82441993051,
        ["y"] = -472.37328688182,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [5] = {
        ["x"] = 523.53313772265,
        ["y"] = -413.11877160768,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [6] = {
        ["x"] = 506.91242063792,
        ["y"] = -412.49818898833,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [7] = {
        ["x"] = 521.74543168588,
        ["y"] = -357.49832125928,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [8] = {
        ["x"] = 505.68384541873,
        ["y"] = -341.18676453025,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [9] = {
        ["x"] = 466.62831467288,
        ["y"] = -335.32373525817,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [10] = {
        ["x"] = 478.8555021161,
        ["y"] = -332.71218291222,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [11] = {
        ["x"] = 511.28934094958,
        ["y"] = -320.46563790745,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [12] = {
        ["x"] = 503.56634307918,
        ["y"] = -306.58952892638,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [13] = {
        ["x"] = 496.3925255864,
        ["y"] = -284.68405412644,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
      },
      [14] = {
        ["x"] = 527.97131133857,
        ["y"] = -291.74332388893,
        ["sublevel"] = 1,
        ["scale"] = 1.5,
        ["patrol"] = {
          [1] = {
            ["x"] = 527.64996733657,
            ["y"] = -291.26130788593,
          },
          [2] = {
            ["x"] = 535.13228049577,
            ["y"] = -294.31714152836,
          },
          [3] = {
            ["x"] = 542.04130525292,
            ["y"] = -297.6913271003,
          },
          [4] = {
            ["x"] = 547.18288283587,
            ["y"] = -298.33403349203,
          },
          [5] = {
            ["x"] = 552.64582280854,
            ["y"] = -299.29806549804,
          },
          [6] = {
            ["x"] = 547.18288283587,
            ["y"] = -298.33403349203,
          },
          [7] = {
            ["x"] = 542.04130525292,
            ["y"] = -297.6913271003,
          },
          [8] = {
            ["x"] = 535.13228049577,
            ["y"] = -294.31714152836,
          },
          [9] = {
            ["x"] = 527.64996733657,
            ["y"] = -291.26130788593,
          },
          [10] = {
            ["x"] = 519.54687574594,
            ["y"] = -285.48007114694,
          },
          [11] = {
            ["x"] = 511.99516298479,
            ["y"] = -283.8733327492,
          },
          [12] = {
            ["x"] = 506.21089739784,
            ["y"] = -285.96208714994,
          },
          [13] = {
            ["x"] = 502.83673021364,
            ["y"] = -281.46321595873,
          },
          [14] = {
            ["x"] = 506.21089739784,
            ["y"] = -285.96208714994,
          },
          [15] = {
            ["x"] = 511.99516298479,
            ["y"] = -283.8733327492,
          },
          [16] = {
            ["x"] = 519.54687574594,
            ["y"] = -285.48007114694,
          },
        },
      },
    },
  },
  [22] = {
    ["name"] = "Nullmagic Hornswog",
    ["id"] = 187246,
    ["count"] = 5,
    ["health"] = 5706059,
    ["scale"] = 1,
    ["displayId"] = 102558,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [386526] = {
      },
      [386536] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 455.53488756453,
        ["y"] = -511.57033173294,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 485.66288539981,
        ["y"] = -510.80952968173,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 458.92877903723,
        ["y"] = -455.58917647646,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 478.4879075605,
        ["y"] = -484.34940136941,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 502.50674528195,
        ["y"] = -448.0002231896,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 526.51356003779,
        ["y"] = -389.30927572866,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 509.98640809503,
        ["y"] = -354.11332641141,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [8] = {
        ["x"] = 522.30060147523,
        ["y"] = -269.61405883675,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [9] = {
        ["x"] = 548.59887257455,
        ["y"] = -284.52669298927,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [10] = {
        ["x"] = 535.48148994762,
        ["y"] = -333.70986913667,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [23] = {
    ["name"] = "Telash Greywing",
    ["id"] = 186737,
    ["count"] = 0,
    ["health"] = 42159216,
    ["scale"] = 1,
    ["displayId"] = 109087,
    ["creatureType"] = "Dragonkin",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2483,
    ["instanceID"] = 1203,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [386781] = {
      },
      [386881] = {
      },
      [386910] = {
      },
      [387150] = {
      },
      [387151] = {
      },
      [387152] = {
      },
      [387928] = {
      },
      [388008] = {
      },
      [388084] = {
      },
      [396722] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 650.43942644534,
        ["y"] = -398.94743728087,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [24] = {
    ["name"] = "Umbrelskul",
    ["id"] = 186738,
    ["count"] = 0,
    ["health"] = 47780446,
    ["scale"] = 1,
    ["displayId"] = 108968,
    ["creatureType"] = "Elemental",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2508,
    ["instanceID"] = 1203,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [181089] = {
      },
      [374881] = {
      },
      [374916] = {
      },
      [374917] = {
      },
      [374918] = {
      },
      [384696] = {
      },
      [384699] = {
      },
      [384978] = {
      },
      [385075] = {
      },
      [388773] = {
      },
      [388777] = {
      },
      [388804] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 648.69560362351,
        ["y"] = -482.61819460885,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
};
