local MDT = MDT
local L = MDT.L
local dungeonIndex = 45
MDT.dungeonList[dungeonIndex] = L["AlgetharAcademy"]
MDT.mapInfo[dungeonIndex] = {};

local zones = { 2097, 2098, 2099 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "",
  [1] = { customTextures = 'AlgetharAcademy' },
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["AlgetharAcademy"],
}

MDT.dungeonTotalCount[dungeonIndex] = { normal = 450, teeming = 1000, teemingEnabled = true }

MDT.mapPOIs[dungeonIndex] = {};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Corrupted Manafiend",
    ["id"] = 196045,
    ["count"] = 5,
    ["health"] = 6578656,
    ["scale"] = 1,
    ["displayId"] = 107525,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [387523] = {
      },
      [388862] = {
      },
      [388863] = {
      },
      [388866] = {
      },
      [388868] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 194.89855157761,
        ["y"] = -342.96609758159,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 207.03353671286,
        ["y"] = -332.90245787882,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 179.74981260726,
        ["y"] = -293.34911130947,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 167.12371455473,
        ["y"] = -300.09956614044,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 136.10363637264,
        ["y"] = -149.55276862046,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 151.8919282734,
        ["y"] = -149.82583391974,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 176.93703091491,
        ["y"] = -17.003610186356,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [8] = {
        ["x"] = 188.05563655599,
        ["y"] = -28.50934486202,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [9] = {
        ["x"] = 67.803021697428,
        ["y"] = -249.67002370655,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [10] = {
        ["x"] = 67.82145977072,
        ["y"] = -232.54984960665,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [11] = {
        ["x"] = 68.358323167089,
        ["y"] = -209.93010704136,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [12] = {
        ["x"] = 75.549700012888,
        ["y"] = -199.2579323093,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [13] = {
        ["x"] = 93.886060034298,
        ["y"] = -187.52194137414,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [14] = {
        ["x"] = 107.9960702745,
        ["y"] = -184.83570974512,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [2] = {
    ["name"] = "Spellbound Battleaxe",
    ["id"] = 196577,
    ["count"] = 5,
    ["health"] = 7236522,
    ["scale"] = 1,
    ["displayId"] = 109246,
    ["creatureType"] = "Not specified",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [387523] = {
      },
      [388911] = {
      },
      [388912] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 208.12732407607,
        ["y"] = -348.73126184344,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 175.66094458724,
        ["y"] = -311.51493216303,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 152.11665117152,
        ["y"] = -133.85531937938,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 131.84247158173,
        ["y"] = -51.641528219394,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 173.77358181987,
        ["y"] = -29.27394601494,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 104.01664632803,
        ["y"] = -172.30914578023,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [7] = {
        ["x"] = 49.932489253343,
        ["y"] = -249.09148371815,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [3] = {
    ["name"] = "Spellbound Scepter",
    ["id"] = 196576,
    ["count"] = 5,
    ["health"] = 5920791,
    ["scale"] = 1,
    ["displayId"] = 109246,
    ["creatureType"] = "Not specified",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [387523] = {
      },
      [388884] = {
      },
      [388886] = {
      },
      [388899] = {
      },
      [396812] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 189.16213383059,
        ["y"] = -307.10019594744,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 137.26951989449,
        ["y"] = -133.84388541779,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 124.46922561771,
        ["y"] = -66.092485549138,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 55.668371719976,
        ["y"] = -193.4510037728,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [4] = {
    ["name"] = "Arcane Ravager",
    ["id"] = 196671,
    ["count"] = 15,
    ["health"] = 15788774,
    ["scale"] = 1,
    ["displayId"] = 108194,
    ["creatureType"] = "Beast",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [388940] = {
      },
      [388942] = {
      },
      [388957] = {
      },
      [388958] = {
      },
      [388976] = {
      },
      [388982] = {
      },
      [388984] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 143.10492012138,
        ["y"] = -237.54955824779,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
        ["patrol"] = {
          [1] = {
            ["x"] = 143.10492012138,
            ["y"] = -237.54955824779,
          },
          [2] = {
            ["x"] = 145.22104727864,
            ["y"] = -225.57120353582,
          },
          [3] = {
            ["x"] = 142.41927574104,
            ["y"] = -217.47722656017,
          },
          [4] = {
            ["x"] = 130.27835481036,
            ["y"] = -212.49632313304,
          },
          [5] = {
            ["x"] = 116.26955056171,
            ["y"] = -218.72247023007,
          },
          [6] = {
            ["x"] = 113.1564770132,
            ["y"] = -230.8634446001,
          },
          [7] = {
            ["x"] = 116.26955056171,
            ["y"] = -240.82525145436,
          },
          [8] = {
            ["x"] = 125.92003759194,
            ["y"] = -246.42874109021,
          },
        },
      },
      [2] = {
        ["x"] = 141.80342218758,
        ["y"] = -65.696628584958,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
        ["patrol"] = {
          [1] = {
            ["x"] = 143.35996786839,
            ["y"] = -66.630534617708,
          },
          [2] = {
            ["x"] = 158.60725558722,
            ["y"] = -66.151682066452,
          },
          [3] = {
            ["x"] = 167.32381877158,
            ["y"] = -54.633365157605,
          },
          [4] = {
            ["x"] = 166.38994836507,
            ["y"] = -43.426314633442,
          },
          [5] = {
            ["x"] = 162.03164895977,
            ["y"] = -36.577545701463,
          },
          [6] = {
            ["x"] = 150.51326079846,
            ["y"] = -28.483586538931,
          },
          [7] = {
            ["x"] = 131.52358874891,
            ["y"] = -26.927058671232,
          },
          [8] = {
            ["x"] = 120.31653822475,
            ["y"] = -35.021000020647,
          },
          [9] = {
            ["x"] = 117.82605088495,
            ["y"] = -49.96376374139,
          },
          [10] = {
            ["x"] = 120.62784023567,
            ["y"] = -57.746420893004,
          },
          [11] = {
            ["x"] = 129.65570543095,
            ["y"] = -64.595172011868,
          },
        },
      },
    },
  },
  [5] = {
    ["name"] = "Arcane Forager",
    ["id"] = 196694,
    ["count"] = 4,
    ["health"] = 5262925,
    ["scale"] = 1,
    ["displayId"] = 62384,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [389054] = {
      },
      [389055] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 133.29623705326,
        ["y"] = -249.34390539772,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [2] = {
        ["x"] = 128.29441384477,
        ["y"] = -233.61949948076,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [3] = {
        ["x"] = 104.23539318582,
        ["y"] = -251.15245820389,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [4] = {
        ["x"] = 115.09661860228,
        ["y"] = -258.52804690109,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [5] = {
        ["x"] = 163.97850024821,
        ["y"] = -214.17980075324,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [6] = {
        ["x"] = 165.7046898697,
        ["y"] = -227.42383924145,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [7] = {
        ["x"] = 129.99650561123,
        ["y"] = -196.95886390629,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [8] = {
        ["x"] = 121.50292650604,
        ["y"] = -205.61152213976,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [9] = {
        ["x"] = 99.454784309139,
        ["y"] = -46.595053842098,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [10] = {
        ["x"] = 98.223964820969,
        ["y"] = -61.752056771797,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [11] = {
        ["x"] = 83.273332793324,
        ["y"] = -57.705873677334,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [12] = {
        ["x"] = 85.640226348654,
        ["y"] = -43.653755393882,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [13] = {
        ["x"] = 180.41641158631,
        ["y"] = -68.79382483625,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [14] = {
        ["x"] = 185.65238252834,
        ["y"] = -56.874173444542,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [15] = {
        ["x"] = 150.29673116075,
        ["y"] = -10.414312743717,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [16] = {
        ["x"] = 135.36211817939,
        ["y"] = -16.649214571237,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
    },
  },
  [6] = {
    ["name"] = "Unruly Textbook",
    ["id"] = 196044,
    ["count"] = 4,
    ["health"] = 5262925,
    ["scale"] = 1,
    ["displayId"] = 109308,
    ["creatureType"] = "Not specified",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [387523] = {
      },
      [388392] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 50.844785123141,
        ["y"] = -231.81969592605,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [2] = {
        ["x"] = 90.693081709746,
        ["y"] = -173.90220020307,
        ["g"] = 8,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 51.243980132084,
        ["y"] = -207.74133437417,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 68.468528799821,
        ["y"] = -184.32583397828,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
    },
  },
  [7] = {
    ["name"] = "Vexamus",
    ["id"] = 194181,
    ["count"] = 0,
    ["health"] = 46207073,
    ["scale"] = 1,
    ["displayId"] = 109099,
    ["creatureType"] = "Elemental",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2509,
    ["instanceID"] = 1201,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [385958] = {
      },
      [386173] = {
      },
      [386181] = {
      },
      [386202] = {
      },
      [387691] = {
      },
      [388537] = {
      },
      [388546] = {
      },
      [388651] = {
      },
      [392557] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 34.0814753229,
        ["y"] = -172.25800558101,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [8] = {
    ["name"] = "Guardian Sentry",
    ["id"] = 192680,
    ["count"] = 18,
    ["health"] = 19735968,
    ["scale"] = 1,
    ["displayId"] = 26385,
    ["creatureType"] = "Elemental",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [377912] = {
      },
      [377991] = {
      },
      [378003] = {
      },
      [378011] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 697.95953352601,
        ["y"] = -455.18691610399,
        ["sublevel"] = 1,
        ["scale"] = 3,
      },
    },
  },
  [9] = {
    ["name"] = "Territorial Eagle",
    ["id"] = 192329,
    ["count"] = 2,
    ["health"] = 3289328,
    ["scale"] = 1,
    ["displayId"] = 34918,
    ["creatureType"] = "Beast",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Scare Beast"] = true,
      ["Hibernate"] = true,
    },
    ["spells"] = {
      [377344] = {
      },
      [377516] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 691.69990656677,
        ["y"] = -196.20831690923,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [2] = {
        ["x"] = 696.05514164241,
        ["y"] = -218.71254527142,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [3] = {
        ["x"] = 672.23141895016,
        ["y"] = -209.22726431588,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [4] = {
        ["x"] = 680.01218698218,
        ["y"] = -219.33850015834,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [5] = {
        ["x"] = 702.89138476737,
        ["y"] = -203.7193876195,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [6] = {
        ["x"] = 688.05786012712,
        ["y"] = -208.49074069717,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [7] = {
        ["x"] = 663.39684596842,
        ["y"] = -168.66576249887,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [8] = {
        ["x"] = 650.78122866692,
        ["y"] = -157.65068733862,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [9] = {
        ["x"] = 640.27048302354,
        ["y"] = -166.62751420993,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [10] = {
        ["x"] = 740.42837784868,
        ["y"] = -162.8915522619,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [11] = {
        ["x"] = 727.53667600147,
        ["y"] = -155.83403075503,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [12] = {
        ["x"] = 714.90800760805,
        ["y"] = -160.39603496562,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [13] = {
        ["x"] = 677.17446347139,
        ["y"] = -197.81108003142,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [14] = {
        ["x"] = 637.62710713492,
        ["y"] = -153.39061788698,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [15] = {
        ["x"] = 665.99909495311,
        ["y"] = -154.8676303365,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
      [16] = {
        ["x"] = 727.06518617111,
        ["y"] = -169.35570509968,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 1.6,
      },
    },
  },
  [10] = {
    ["name"] = "Alpha Eagle",
    ["id"] = 192333,
    ["count"] = 8,
    ["health"] = 9867984,
    ["scale"] = 1,
    ["displayId"] = 101438,
    ["creatureType"] = "Beast",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [377383] = {
      },
      [377389] = {
      },
      [377524] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 650.12614659089,
        ["y"] = -179.02549976816,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [2] = {
        ["x"] = 735.17277451151,
        ["y"] = -182.10652845137,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [3] = {
        ["x"] = 712.09472973216,
        ["y"] = -176.91692838486,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
    },
  },
  [11] = {
    ["name"] = "Crawth",
    ["id"] = 191736,
    ["count"] = 0,
    ["health"] = 66010104,
    ["scale"] = 1,
    ["displayId"] = 64923,
    ["creatureType"] = "Beast",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2495,
    ["instanceID"] = 1201,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [181089] = {
      },
      [376997] = {
      },
      [377004] = {
      },
      [377008] = {
      },
      [377009] = {
      },
      [377034] = {
      },
      [397210] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 684.32659069286,
        ["y"] = -117.03170378065,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [12] = {
    ["name"] = "Aggravated Skitterfly",
    ["id"] = 197406,
    ["count"] = 4,
    ["health"] = 5262925,
    ["scale"] = 1,
    ["displayId"] = 103762,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
      [390938] = {
      },
      [390942] = {
      },
      [390944] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 373.67756650156,
        ["y"] = -197.84159538266,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
        ["patrol"] = {
          [1] = {
            ["x"] = 373.67756650156,
            ["y"] = -197.84159538266,
          },
          [2] = {
            ["x"] = 350.70008675789,
            ["y"] = -198.98518229782,
          },
          [3] = {
            ["x"] = 338.74586224333,
            ["y"] = -204.96223755313,
          },
          [4] = {
            ["x"] = 337.25166968196,
            ["y"] = -221.89736519794,
          },
          [5] = {
            ["x"] = 350.70008675789,
            ["y"] = -234.84771333658,
          },
          [6] = {
            ["x"] = 364.14850383382,
            ["y"] = -254.27325692028,
          },
          [7] = {
            ["x"] = 367.6352001522,
            ["y"] = -271.7064107509,
          },
          [8] = {
            ["x"] = 379.5893676648,
            ["y"] = -278.18159194547,
          },
          [9] = {
            ["x"] = 403.99584287973,
            ["y"] = -280.67203638534,
          },
          [10] = {
            ["x"] = 412.96139726171,
            ["y"] = -250.28852016559,
          },
          [11] = {
            ["x"] = 422.92328902516,
            ["y"] = -236.34196289992,
          },
          [12] = {
            ["x"] = 435.87356591134,
            ["y"] = -223.88969794905,
          },
          [13] = {
            ["x"] = 423.42131521097,
            ["y"] = -212.43362787473,
          },
          [14] = {
            ["x"] = 401.50536993887,
            ["y"] = -200.47943186116,
          },
        },
      },
      [2] = {
        ["x"] = 386.95330731721,
        ["y"] = -203.8179360113,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [3] = {
        ["x"] = 385.17606612285,
        ["y"] = -188.91209956221,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [4] = {
        ["x"] = 330.62039086056,
        ["y"] = -318.46006031499,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [5] = {
        ["x"] = 332.97599941107,
        ["y"] = -298.20306913456,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
      },
      [6] = {
        ["x"] = 343.43279802336,
        ["y"] = -310.80424077559,
        ["g"] = 22,
        ["sublevel"] = 1,
        ["scale"] = 1.8,
        ["patrol"] = {
          [1] = {
            ["x"] = 343.43279802336,
            ["y"] = -310.80424077559,
          },
          [2] = {
            ["x"] = 359.66575514381,
            ["y"] = -308.56515091669,
          },
          [3] = {
            ["x"] = 383.07600698122,
            ["y"] = -307.5689631654,
          },
          [4] = {
            ["x"] = 396.52442405714,
            ["y"] = -301.59187228386,
          },
          [5] = {
            ["x"] = 392.53964455098,
            ["y"] = -290.13575945806,
          },
          [6] = {
            ["x"] = 380.08739385061,
            ["y"] = -278.67968938374,
          },
          [7] = {
            ["x"] = 355.68097563765,
            ["y"] = -274.19685519078,
          },
          [8] = {
            ["x"] = 331.77264061246,
            ["y"] = -272.20450818917,
          },
          [9] = {
            ["x"] = 310.35472152617,
            ["y"] = -270.71023012485,
          },
          [10] = {
            ["x"] = 292.4234417563,
            ["y"] = -265.23122955633,
          },
          [11] = {
            ["x"] = 277.97885830481,
            ["y"] = -272.70260562744,
          },
          [12] = {
            ["x"] = 281.96358080901,
            ["y"] = -293.62241302497,
          },
          [13] = {
            ["x"] = 293.9177483216,
            ["y"] = -308.06706060367,
          },
          [14] = {
            ["x"] = 315.83375059567,
            ["y"] = -310.5574979183,
          },
        },
      },
    },
  },
  [13] = {
    ["name"] = "Vile Lasher",
    ["id"] = 197219,
    ["count"] = 9,
    ["health"] = 11841581,
    ["scale"] = 1,
    ["displayId"] = 104635,
    ["creatureType"] = "Elemental",
    ["level"] = 71,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [390912] = {
      },
      [390915] = {
      },
      [390918] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 359.26591043657,
        ["y"] = -222.6478643899,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [2] = {
        ["x"] = 393.04915735986,
        ["y"] = -281.61845712637,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [3] = {
        ["x"] = 298.59000888491,
        ["y"] = -246.0541860745,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
    },
  },
  [14] = {
    ["name"] = "Hungry Lasher",
    ["id"] = 197398,
    ["count"] = 2,
    ["health"] = 3289328,
    ["scale"] = 1,
    ["displayId"] = 104474,
    ["creatureType"] = "Elemental",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
    },
    ["spells"] = {
    },
    ["clones"] = {
      [1] = {
        ["x"] = 411.98193093823,
        ["y"] = -236.59817419562,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [2] = {
        ["x"] = 307.62468150236,
        ["y"] = -203.87872377278,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [3] = {
        ["x"] = 401.04670650521,
        ["y"] = -219.15479553545,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [4] = {
        ["x"] = 395.15275969944,
        ["y"] = -233.0982135269,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [5] = {
        ["x"] = 316.9566776384,
        ["y"] = -211.4392288515,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [6] = {
        ["x"] = 330.02221265661,
        ["y"] = -208.80406999885,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [7] = {
        ["x"] = 320.58352563755,
        ["y"] = -195.57944198372,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [8] = {
        ["x"] = 337.49913587399,
        ["y"] = -194.8422251583,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [9] = {
        ["x"] = 400.47192183244,
        ["y"] = -301.03780616455,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [10] = {
        ["x"] = 407.91291602936,
        ["y"] = -273.52670489211,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [11] = {
        ["x"] = 377.96724942238,
        ["y"] = -269.80261116156,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [12] = {
        ["x"] = 405.56020026171,
        ["y"] = -259.50592185149,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [13] = {
        ["x"] = 390.39735195489,
        ["y"] = -260.08351041737,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [14] = {
        ["x"] = 384.5810947649,
        ["y"] = -295.30871203353,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [15] = {
        ["x"] = 409.46467624428,
        ["y"] = -290.2439130584,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [16] = {
        ["x"] = 375.07247673549,
        ["y"] = -285.84287495496,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [17] = {
        ["x"] = 314.5174961897,
        ["y"] = -254.74712299544,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [18] = {
        ["x"] = 313.28131354916,
        ["y"] = -235.01073216386,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [19] = {
        ["x"] = 304.75420675782,
        ["y"] = -265.0102030128,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [20] = {
        ["x"] = 288.64370232194,
        ["y"] = -267.06320285553,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [21] = {
        ["x"] = 283.68712982626,
        ["y"] = -244.73519448313,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [22] = {
        ["x"] = 285.82744965858,
        ["y"] = -230.59971038784,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [23] = {
        ["x"] = 300.14211543425,
        ["y"] = -226.26772972499,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
      [24] = {
        ["x"] = 284.96371879974,
        ["y"] = -256.36417070281,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["scale"] = 1.4,
      },
    },
  },
  [15] = {
    ["name"] = "Overgrown Ancient",
    ["id"] = 196482,
    ["count"] = 0,
    ["health"] = 39606062,
    ["scale"] = 1,
    ["displayId"] = 109194,
    ["creatureType"] = "Elemental",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2512,
    ["instanceID"] = 1201,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [388544] = {
      },
      [388623] = {
      },
      [388625] = {
      },
      [388796] = {
      },
      [388799] = {
      },
      [388923] = {
      },
      [390297] = {
      },
      [396716] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 350.31256910172,
        ["y"] = -260.80939298541,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
  [16] = {
    ["name"] = "Algeth'ar Echoknight",
    ["id"] = 196200,
    ["count"] = 8,
    ["health"] = 8223320,
    ["scale"] = 1,
    ["displayId"] = 109104,
    ["creatureType"] = "Dragonkin",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Hibernate"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [181089] = {
      },
      [387910] = {
      },
      [387932] = {
      },
      [387970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 428.44450326461,
        ["y"] = -366.27600338196,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [2] = {
        ["x"] = 415.42429953793,
        ["y"] = -354.52573734103,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [3] = {
        ["x"] = 386.16241104438,
        ["y"] = -427.63679778498,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [4] = {
        ["x"] = 358.48153116961,
        ["y"] = -462.55776573571,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [5] = {
        ["x"] = 349.2218511707,
        ["y"] = -479.83124108073,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [6] = {
        ["x"] = 316.86760663993,
        ["y"] = -409.49424303719,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [7] = {
        ["x"] = 351.0560949822,
        ["y"] = -385.87267573758,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [8] = {
        ["x"] = 369.0357837083,
        ["y"] = -388.55346489783,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [9] = {
        ["x"] = 359.13692487077,
        ["y"] = -357.35431230712,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [10] = {
        ["x"] = 375.68732112542,
        ["y"] = -361.88450143409,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [11] = {
        ["x"] = 340.75016203281,
        ["y"] = -503.45813332745,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
    },
  },
  [17] = {
    ["name"] = "Spectral Invoker",
    ["id"] = 196202,
    ["count"] = 5,
    ["health"] = 7236522,
    ["scale"] = 1,
    ["displayId"] = 109105,
    ["creatureType"] = "Dragonkin",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Hibernate"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [387843] = {
      },
      [387848] = {
      },
      [387970] = {
      },
      [387975] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 357.3187748484,
        ["y"] = -400.20300945302,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [2] = {
        ["x"] = 377.09605072767,
        ["y"] = -443.33126906346,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [3] = {
        ["x"] = 367.94207296888,
        ["y"] = -428.23772957173,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [4] = {
        ["x"] = 312.9485063364,
        ["y"] = -435.20041478409,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [5] = {
        ["x"] = 298.1753575297,
        ["y"] = -444.920634924,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
        ["patrol"] = {
          [1] = {
            ["x"] = 297.40907567424,
            ["y"] = -444.53749399627,
          },
          [2] = {
            ["x"] = 298.76500235356,
            ["y"] = -460.82979849974,
          },
          [3] = {
            ["x"] = 307.57737523434,
            ["y"] = -473.85676543321,
          },
          [4] = {
            ["x"] = 326.35163147444,
            ["y"] = -475.38938395372,
          },
          [5] = {
            ["x"] = 344.35947431607,
            ["y"] = -459.6803428308,
          },
          [6] = {
            ["x"] = 346.65831988245,
            ["y"] = -444.73761644908,
          },
          [7] = {
            ["x"] = 339.37859840792,
            ["y"] = -430.56120480858,
          },
          [8] = {
            ["x"] = 324.81902391585,
            ["y"] = -422.89825471099,
          },
          [9] = {
            ["x"] = 308.34370093747,
            ["y"] = -422.13195093169,
          },
        },
      },
      [6] = {
        ["x"] = 305.56225242653,
        ["y"] = -396.21898070029,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [7] = {
        ["x"] = 283.2994684444,
        ["y"] = -490.0370095837,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [8] = {
        ["x"] = 292.71475393093,
        ["y"] = -476.59817608564,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [9] = {
        ["x"] = 320.28318726858,
        ["y"] = -504.00777865257,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [10] = {
        ["x"] = 372.08626989099,
        ["y"] = -472.72730261386,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
    },
  },
  [18] = {
    ["name"] = "Ethereal Restorer",
    ["id"] = 196203,
    ["count"] = 6,
    ["health"] = 6578656,
    ["scale"] = 1,
    ["displayId"] = 109106,
    ["creatureType"] = "Dragonkin",
    ["level"] = 70,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Knock"] = true,
      ["Grip"] = true,
      ["Mind Control"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Repentance"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
      ["Sleep Walk"] = true,
      ["Hibernate"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [387955] = {
      },
      [387970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 295.96109441185,
        ["y"] = -426.5501251125,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [2] = {
        ["x"] = 322.17496589243,
        ["y"] = -393.81111531999,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [3] = {
        ["x"] = 278.86838436577,
        ["y"] = -469.51494212167,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [4] = {
        ["x"] = 364.98950623728,
        ["y"] = -488.21204081566,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
      [5] = {
        ["x"] = 333.11855043474,
        ["y"] = -518.7059030983,
        ["g"] = 33,
        ["sublevel"] = 1,
        ["scale"] = 2.1,
      },
    },
  },
  [19] = {
    ["name"] = "Echo of Doragosa",
    ["id"] = 190609,
    ["count"] = 0,
    ["health"] = 59409094,
    ["scale"] = 1,
    ["displayId"] = 108925,
    ["creatureType"] = "Dragonkin",
    ["level"] = 72,
    ["isBoss"] = true,
    ["encounterID"] = 2514,
    ["instanceID"] = 1201,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Mind Soothe"] = true,
    },
    ["spells"] = {
      [373326] = {
      },
      [374343] = {
      },
      [374350] = {
      },
      [374352] = {
      },
      [374361] = {
      },
      [388822] = {
      },
      [389011] = {
      },
      [439488] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 452.71368376103,
        ["y"] = -521.27375202316,
        ["sublevel"] = 1,
        ["scale"] = 2,
      },
    },
  },
};
