local MDT = MDT
local L = MDT.L
local dungeonIndex = 21
MDT.dungeonList[dungeonIndex] = L["The MOTHERLODE!!"]

local zones = { 1010 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonTotalCount[dungeonIndex] = { normal = 384, teeming = 460, teemingEnabled = true }
MDT.scaleMultiplier[dungeonIndex] = 0.7

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "KezanDungeon",
  [1] = "KezanDungeon",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["The MOTHERLODE!! Sublevel"],
}

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 434.8042835021,
      ["y"] = -480.35147832794,
      ["graveyardDescription"] = "",
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mlFrackingTotem",
      ["x"] = 230.88050878771,
      ["y"] = -165.41051814016,
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mlFrackingTotem",
      ["x"] = 229.53433707512,
      ["y"] = -159.0643543431,
    },
    [4] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mlMineCart",
      ["x"] = 286.53431587181,
      ["y"] = -116.94137664378,
    },
    [5] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 367.76549732401,
      ["y"] = -262.08125072401,
      ["graveyardDescription"] = "mlGraveyardNote1",
    },
    [6] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 275.70035521298,
      ["y"] = -121.09600689235,
      ["graveyardDescription"] = "mlGraveyardNote2",
    },
    [7] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 479.54906443908,
      ["y"] = -112.60568055995,
      ["graveyardDescription"] = "mlGraveyardNote3",
    },
    [8] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "generalNote",
      ["x"] = 409.95526615971,
      ["y"] = -273.73565889455,
      ["text"] = "mlJockeyNote",
    },
    [9] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "generalNote",
      ["x"] = 415.73284153458,
      ["y"] = -348.49370305917,
      ["text"] = "mlJockeyNote",
    },
    [10] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 451.71529736273,
      ["y"] = -405.33085878462,
      ["index"] = 1,
      ["npcId"] = 161124,
      ["tooltipText"] = "Brutal Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [3] = true,
        [4] = true,
        [5] = true,
        [6] = true,
        [7] = true,
        [8] = true,
        [9] = true,
        [10] = true,
        [11] = true,
        [12] = true,
      },
    },
    [11] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 296.59599494222,
      ["y"] = -275.22932156066,
      ["index"] = 2,
      ["npcId"] = 161241,
      ["tooltipText"] = "Cursed Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [5] = true,
        [6] = true,
        [9] = true,
        [10] = true,
      },
    },
    [12] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 341.12996466647,
      ["y"] = -106.30385916865,
      ["index"] = 3,
      ["npcId"] = 161244,
      ["tooltipText"] = "Defiled Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [5] = true,
        [6] = true,
        [9] = true,
        [10] = true,
      },
    },
    [13] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 531.00495086141,
      ["y"] = -118.90339334755,
      ["index"] = 4,
      ["npcId"] = 161243,
      ["tooltipText"] = "Entropic Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [3] = true,
        [4] = true,
        [5] = true,
        [6] = true,
        [7] = true,
        [8] = true,
        [9] = true,
        [10] = true,
        [11] = true,
        [12] = true,
      },
    },
    [14] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 295.26874509012,
      ["y"] = -275.62658557555,
      ["index"] = 5,
      ["npcId"] = 161244,
      ["tooltipText"] = "Defiled Spire of Ny'alotha",
      ["weeks"] = {
        [3] = true,
        [4] = true,
        [7] = true,
        [8] = true,
        [11] = true,
        [12] = true,
      },
    },
    [15] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 339.76874564595,
      ["y"] = -108.08239691446,
      ["index"] = 6,
      ["npcId"] = 161241,
      ["tooltipText"] = "Cursed Spire of Ny'alotha",
      ["weeks"] = {
        [3] = true,
        [4] = true,
        [7] = true,
        [8] = true,
        [11] = true,
        [12] = true,
      },
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Big Money Crab",
    ["id"] = 137713,
    ["count"] = 1,
    ["health"] = 153699,
    ["scale"] = 0.7,
    ["displayId"] = 32024,
    ["creatureType"] = "Beast",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Root"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [270866] = {
      },
      [277242] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 425.40178176878,
        ["y"] = -478.2259243172,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
          [3] = true,
        },
      },
      [2] = {
        ["x"] = 447.58139077397,
        ["y"] = -478.87108043154,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 453.97559275342,
        ["y"] = -466.85963499295,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [4] = {
        ["x"] = 473.37653395575,
        ["y"] = -483.07467635869,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 487.57010690783,
        ["y"] = -488.23596680439,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 497.82152711282,
        ["y"] = -485.00011197057,
        ["sublevel"] = 1,
      },
    },
  },
  [2] = {
    ["name"] = "Bottom Feeder",
    ["id"] = 137716,
    ["count"] = 0,
    ["health"] = 153699,
    ["scale"] = 0.7,
    ["displayId"] = 32023,
    ["creatureType"] = "Beast",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["clones"] = {
      [1] = {
        ["x"] = 425.07649815113,
        ["y"] = -508.91315031584,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 450.94195363675,
        ["y"] = -496.78592021978,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 412.39914455893,
        ["y"] = -486.60016709926,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 400.36439703866,
        ["y"] = -495.96787666363,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 387.11641745026,
        ["y"] = -508.92875746902,
        ["sublevel"] = 1,
      },
    },
  },
  [3] = {
    ["name"] = "Venture Co. Longshoreman",
    ["id"] = 138061,
    ["count"] = 0,
    ["health"] = 307398,
    ["scale"] = 0.7,
    ["neutral"] = true,
    ["displayId"] = 81226,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 413.56816392568,
        ["y"] = -548.02341232211,
        ["sublevel"] = 1,
        ["upstairs"] = true,
      },
      [2] = {
        ["x"] = 424.265841902,
        ["y"] = -550.58154619885,
        ["sublevel"] = 1,
        ["upstairs"] = true,
      },
      [3] = {
        ["x"] = 418.27288128767,
        ["y"] = -523.21446339563,
        ["sublevel"] = 1,
        ["upstairs"] = true,
      },
      [4] = {
        ["x"] = 430.77283457852,
        ["y"] = -526.42877694896,
        ["sublevel"] = 1,
        ["upstairs"] = true,
      },
      [5] = {
        ["x"] = 434.71401869778,
        ["y"] = -507.87807746141,
        ["sublevel"] = 1,
        ["upstairs"] = true,
      },
      [6] = {
        ["x"] = 395.76294614373,
        ["y"] = -459.78643311087,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 405.01147033623,
        ["y"] = -449.17486333683,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 425.01146303998,
        ["y"] = -447.74631870413,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 485.6324518163,
        ["y"] = -464.26906410961,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 473.55560139048,
        ["y"] = -456.37415670018,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 465.73199190146,
        ["y"] = -456.47780215629,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 456.19712019695,
        ["y"] = -455.31502582542,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 460.2539811199,
        ["y"] = -473.78387314372,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 460.2539811199,
        ["y"] = -481.28385124899,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Posh Vacationer",
    ["id"] = 138064,
    ["count"] = 0,
    ["health"] = 153699,
    ["scale"] = 0.7,
    ["neutral"] = true,
    ["displayId"] = 85704,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["clones"] = {
      [1] = {
        ["x"] = 381.53036956989,
        ["y"] = -502.8636334281,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 385.35392512337,
        ["y"] = -497.86360409746,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 502.83538303213,
        ["y"] = -484.36417596637,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 507.21111723987,
        ["y"] = -485.16753800061,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 505.65938739876,
        ["y"] = -487.75373467127,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 501.86629302909,
        ["y"] = -489.99512139741,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 498.07319865943,
        ["y"] = -490.68478568164,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 506.69713557341,
        ["y"] = -498.29889889274,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 511.9145218839,
        ["y"] = -497.86412913943,
        ["sublevel"] = 1,
      },
    },
  },
  [5] = {
    ["name"] = "Off-Duty Laborer",
    ["id"] = 130436,
    ["count"] = 1,
    ["health"] = 307398,
    ["scale"] = 0.8,
    ["displayId"] = 81226,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [258674] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 449.02471238213,
        ["y"] = -434.14300926226,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [2] = {
        ["x"] = 451.50833604267,
        ["y"] = -439.36455230936,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 452.54468439098,
        ["y"] = -435.46782418764,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 481.62542419251,
        ["y"] = -430.11586660419,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 461.59482753369,
        ["y"] = -420.1786603195,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 466.99321155107,
        ["y"] = -422.99777931989,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 435.35094745914,
        ["y"] = -416.59957778435,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 468.06397992127,
        ["y"] = -400.24809876436,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 471.1189878183,
        ["y"] = -403.18472073708,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 458.17260833013,
        ["y"] = -358.71874866673,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 450.59536600093,
        ["y"] = -359.43396729303,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 448.42147991669,
        ["y"] = -354.86875427136,
        ["g"] = 19,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 461.23382100857,
        ["y"] = -338.92283836523,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 457.56035528456,
        ["y"] = -342.39221974072,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 458.7848088263,
        ["y"] = -346.88202285883,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 463.84961221425,
        ["y"] = -292.30480466739,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 455.26139566038,
        ["y"] = -289.48127360145,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 408.06805201094,
        ["y"] = -308.86456151826,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 407.21969976684,
        ["y"] = -313.75102527871,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 432.56067973406,
        ["y"] = -326.75066665947,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 430.02902279571,
        ["y"] = -330.92788757017,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 430.84077766723,
        ["y"] = -361.44398874944,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 435.93651948351,
        ["y"] = -364.59780324269,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 434.66379096478,
        ["y"] = -369.50690453121,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 436.1251307314,
        ["y"] = -342.89427712404,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["infested"] = {
        },
      },
      [26] = {
        ["x"] = 442.83941872568,
        ["y"] = -347.6085695264,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 440.41085221187,
        ["y"] = -351.60856071024,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 435.98228397537,
        ["y"] = -351.46571395421,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 440.58932329189,
        ["y"] = -344.79427963513,
        ["g"] = 39,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 438.77025155148,
        ["y"] = -416.02358442115,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [6] = {
    ["name"] = "Refreshment Vendor",
    ["id"] = 136470,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 84784,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [224729] = {
      },
      [268129] = {
      },
      [268130] = {
      },
      [277242] = {
      },
      [277564] = {
      },
      [280604] = {
      },
      [280605] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 481.67609043668,
        ["y"] = -435.00018284157,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 477.61856226763,
        ["y"] = -427.55080630878,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 439.3794102781,
        ["y"] = -414.53336685115,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["negativeTeeming"] = true,
      },
      [4] = {
        ["x"] = 431.61958075867,
        ["y"] = -419.88315178515,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 466.61615006596,
        ["y"] = -404.83779067648,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [6] = {
        ["x"] = 461.22700421103,
        ["y"] = -395.21057359874,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 467.27869006316,
        ["y"] = -373.06237900427,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 504.04957323132,
        ["y"] = -333.53532477086,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 459.14372878729,
        ["y"] = -292.65774037067,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 451.09070467911,
        ["y"] = -298.63355783428,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [11] = {
        ["x"] = 429.97962561865,
        ["y"] = -311.75848298904,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [12] = {
        ["x"] = 416.12633606115,
        ["y"] = -286.01466856316,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 413.38056968444,
        ["y"] = -310.94431763882,
        ["g"] = 31,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 428.38346425568,
        ["y"] = -324.34560451914,
        ["g"] = 32,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 393.86934268811,
        ["y"] = -330.92605057055,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 410.62456974962,
        ["y"] = -360.00323316245,
        ["g"] = 35,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [17] = {
        ["x"] = 468.60506319127,
        ["y"] = -427.13404980502,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [7] = {
    ["name"] = "Mech Jockey",
    ["id"] = 130488,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 81265,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [224729] = {
      },
      [262019] = {
      },
      [262287] = {
      },
      [267433] = {
      },
      [277242] = {
      },
      [277564] = {
      },
      [280602] = {
      },
      [281621] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 465.36079572815,
        ["y"] = -419.54535271079,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [2] = {
        ["x"] = 454.04528093853,
        ["y"] = -355.10936763606,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [3] = {
        ["x"] = 476.16988417219,
        ["y"] = -355.71156236957,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 509.76385820838,
        ["y"] = -332.54631028177,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 505.47815390753,
        ["y"] = -327.71114824701,
        ["g"] = 22,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 499.65076427533,
        ["y"] = -323.82978481744,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 468.9249933922,
        ["y"] = -311.91353221683,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 464.72918257925,
        ["y"] = -307.48171092243,
        ["g"] = 26,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 478.21192841174,
        ["y"] = -332.25374457137,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 470.96799696168,
        ["y"] = -332.32743212129,
        ["g"] = 25,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 450.00392816461,
        ["y"] = -304.58596373195,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 449.6760549887,
        ["y"] = -310.32368802792,
        ["g"] = 28,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 440.54154084352,
        ["y"] = -309.69230383048,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 411.73992804077,
        ["y"] = -315.90996457181,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [15] = {
        ["x"] = 425.97839125071,
        ["y"] = -328.26965213076,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [16] = {
        ["x"] = 397.55354496879,
        ["y"] = -335.13658682306,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 413.27536358374,
        ["y"] = -334.97673527945,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [18] = {
        ["x"] = 410.27970801072,
        ["y"] = -352.41702962473,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 434.22763792554,
        ["y"] = -346.93038103221,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [20] = {
        ["x"] = 431.13207048378,
        ["y"] = -424.95815162701,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [21] = {
        ["x"] = 403.98926354167,
        ["y"] = -282.55838428264,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 420.83320320086,
        ["y"] = -356.17397051988,
        ["g"] = 89,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Addled Thug",
    ["id"] = 130435,
    ["count"] = 5,
    ["health"] = 999044,
    ["scale"] = 1.2,
    ["displayId"] = 30262,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [224729] = {
      },
      [262092] = {
      },
      [263636] = {
      },
      [263637] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 454.94319863389,
        ["y"] = -394.4723222671,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 445.54271378336,
        ["y"] = -380.53516379952,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 441.82179359542,
        ["y"] = -385.65146149395,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [4] = {
        ["x"] = 431.34753769379,
        ["y"] = -404.1715499278,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 482.67372893737,
        ["y"] = -352.74503361071,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 501.98621577546,
        ["y"] = -319.44911838114,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 484.59901468162,
        ["y"] = -317.27159278197,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [8] = {
        ["x"] = 481.27610806539,
        ["y"] = -312.21697049844,
        ["g"] = 24,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 454.43938551122,
        ["y"] = -328.52072837613,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 471.28511852648,
        ["y"] = -305.73344743986,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [11] = {
        ["x"] = 460.55550189356,
        ["y"] = -286.42245038369,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 435.52555761529,
        ["y"] = -304.57441402861,
        ["g"] = 29,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 406.66929011603,
        ["y"] = -336.04502320821,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [14] = {
        ["x"] = 405.65446988511,
        ["y"] = -355.71634412717,
        ["g"] = 35,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 429.97118218407,
        ["y"] = -367.53093322539,
        ["g"] = 38,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Hired Assassin",
    ["id"] = 134232,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 83395,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [267354] = {
      },
      [267357] = {
      },
      [269298] = {
      },
      [269302] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 461.11431977744,
        ["y"] = -373.33634931865,
        ["g"] = 40,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 433.73865216591,
        ["y"] = -409.36564645266,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 463.90011099051,
        ["y"] = -347.33663173639,
        ["g"] = 20,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 460.40217993942,
        ["y"] = -326.76391932942,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 454.00873743284,
        ["y"] = -322.50162432503,
        ["g"] = 41,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 474.62271822124,
        ["y"] = -336.78665619602,
        ["g"] = 25,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 474.62271822124,
            ["y"] = -336.78665619602,
          },
          [2] = {
            ["x"] = 468.90094316129,
            ["y"] = -348.65758098167,
          },
          [3] = {
            ["x"] = 474.62271822124,
            ["y"] = -336.78665619602,
          },
          [4] = {
            ["x"] = 471.72703052261,
            ["y"] = -324.30975643075,
          },
        },
      },
      [7] = {
        ["x"] = 406.74577908281,
        ["y"] = -294.49634326392,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 398.72250499114,
        ["y"] = -327.57033724503,
        ["g"] = 33,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 408.30809514058,
        ["y"] = -330.00580243568,
        ["g"] = 34,
        ["sublevel"] = 1,
      },
    },
  },
  [10] = {
    ["name"] = "Rowdy Reveler",
    ["id"] = 136006,
    ["count"] = 0,
    ["health"] = 153699,
    ["scale"] = 0.7,
    ["neutral"] = true,
    ["displayId"] = 85710,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["clones"] = {
      [1] = {
        ["x"] = 445.81886970914,
        ["y"] = -403.33506578442,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 443.60120081537,
        ["y"] = -406.28607697551,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 444.07643355816,
        ["y"] = -409.63843308163,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 446.30373750595,
        ["y"] = -394.79444469829,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 443.44659393948,
        ["y"] = -394.93729145432,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 452.2980765933,
        ["y"] = -383.14512786918,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 449.38897837747,
        ["y"] = -386.05422608501,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 446.47989576722,
        ["y"] = -389.14512928445,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 434.19345472932,
        ["y"] = -390.8238566991,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 434.16502939967,
        ["y"] = -394.39300324678,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 437.0597815434,
        ["y"] = -392.94562152816,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 467.77829615664,
        ["y"] = -392.18745932876,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 469.90595613289,
        ["y"] = -391.23001827454,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 472.1400004776,
        ["y"] = -391.54916681443,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 464.40197530756,
        ["y"] = -380.45963040171,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 467.44899964032,
        ["y"] = -380.49718389826,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 466.92269954902,
        ["y"] = -383.65508608764,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 466.59374958019,
        ["y"] = -385.66510752651,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 469.33349975444,
        ["y"] = -384.43223817242,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 475.29797373954,
        ["y"] = -384.29121070518,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [21] = {
        ["x"] = 477.15514096771,
        ["y"] = -385.29121156652,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 475.29797373954,
        ["y"] = -381.57692615626,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 477.27170614703,
        ["y"] = -382.57525345282,
        ["g"] = 15,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 485.84235116617,
        ["y"] = -376.66260870592,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 488.60096390789,
        ["y"] = -377.00744084803,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 474.34737378737,
        ["y"] = -370.73491124572,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [27] = {
        ["x"] = 477.06163381324,
        ["y"] = -370.30634645459,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 473.20452617001,
        ["y"] = -363.7349113471,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 476.06165747495,
        ["y"] = -362.30634569463,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [30] = {
        ["x"] = 400.17209537491,
        ["y"] = -361.06456389368,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [31] = {
        ["x"] = 398.58672965892,
        ["y"] = -363.01578806743,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [32] = {
        ["x"] = 402.12331954866,
        ["y"] = -363.01578806743,
        ["g"] = 36,
        ["sublevel"] = 1,
      },
      [33] = {
        ["x"] = 393.43874065695,
        ["y"] = -360.16054336484,
        ["sublevel"] = 1,
      },
      [34] = {
        ["x"] = 396.1159134637,
        ["y"] = -353.49853093076,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [35] = {
        ["x"] = 395.62408962924,
        ["y"] = -349.72805976084,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [36] = {
        ["x"] = 392.34541415258,
        ["y"] = -351.53133408713,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [37] = {
        ["x"] = 392.18149163522,
        ["y"] = -354.97396022235,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [38] = {
        ["x"] = 398.73887072976,
        ["y"] = -354.48216452909,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [39] = {
        ["x"] = 398.73887072976,
        ["y"] = -351.20346091122,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [40] = {
        ["x"] = 390.21425257978,
        ["y"] = -348.41656705721,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [41] = {
        ["x"] = 388.7388655,
        ["y"] = -352.02312978038,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
      [42] = {
        ["x"] = 389.55850622796,
        ["y"] = -355.79362909151,
        ["g"] = 37,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Mechanized Peacekeeper",
    ["id"] = 136139,
    ["count"] = 12,
    ["health"] = 1229592,
    ["scale"] = 1.6,
    ["displayId"] = 82943,
    ["creatureType"] = "Mechanical",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [262066] = {
      },
      [262412] = {
      },
      [263628] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 409.75023371705,
        ["y"] = -287.96403229057,
        ["g"] = 30,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 421.7520034151,
        ["y"] = -348.12147816083,
        ["g"] = 89,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 425.25199455151,
            ["y"] = -351.32147778175,
          },
          [2] = {
            ["x"] = 417.4969119229,
            ["y"] = -342.13778719702,
          },
          [3] = {
            ["x"] = 425.25199455151,
            ["y"] = -351.32147778175,
          },
          [4] = {
            ["x"] = 437.08876415058,
            ["y"] = -355.40308592811,
          },
        },
        ["infested"] = {
          [3] = true,
        },
      },
    },
  },
  [12] = {
    ["name"] = "Coin-Operated Crowd Pummeler",
    ["id"] = 129214,
    ["count"] = 0,
    ["health"] = 8914542,
    ["scale"] = 1,
    ["displayId"] = 80443,
    ["creatureType"] = "Mechanical",
    ["level"] = 122,
    ["isBoss"] = true,
    ["encounterID"] = 2109,
    ["instanceID"] = 1012,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [257337] = {
      },
      [262347] = {
      },
      [267547] = {
      },
      [267551] = {
      },
      [269493] = {
      },
      [271867] = {
      },
      [271903] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 383.52127517017,
        ["y"] = -269.35004719114,
        ["sublevel"] = 1,
      },
    },
  },
  [13] = {
    ["name"] = "Venture Co. Earthshaper",
    ["id"] = 130661,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 81333,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [263202] = {
      },
      [268709] = {
      },
      [268722] = {
      },
      [271579] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 341.37885347748,
        ["y"] = -248.79042145848,
        ["g"] = 42,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [2] = {
        ["x"] = 322.18181830407,
        ["y"] = -248.6592433697,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 322.41759577357,
        ["y"] = -269.28650512174,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 317.72880363856,
        ["y"] = -264.95955281291,
        ["g"] = 45,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 309.44674265138,
        ["y"] = -257.93801060505,
        ["g"] = 46,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 309.44674265138,
            ["y"] = -257.93801060505,
          },
          [2] = {
            ["x"] = 298.15392425402,
            ["y"] = -257.91990659878,
          },
          [3] = {
            ["x"] = 309.44674265138,
            ["y"] = -257.93801060505,
          },
          [4] = {
            ["x"] = 326.46704569555,
            ["y"] = -257.49952956103,
          },
        },
        ["infested"] = {
          [3] = true,
        },
      },
      [6] = {
        ["x"] = 291.36338999324,
        ["y"] = -263.24188694247,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 270.56060205143,
        ["y"] = -256.21370937208,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 258.25237870002,
        ["y"] = -266.97301602119,
        ["g"] = 51,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 297.41823237674,
        ["y"] = -240.242091997,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 303.19694717965,
        ["y"] = -246.10812635318,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 281.29724354476,
        ["y"] = -236.12596711913,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 244.43731355328,
        ["y"] = -183.26444850217,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 252.0322517744,
        ["y"] = -181.49230059643,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 254.87533569424,
        ["y"] = -177.10228965329,
        ["g"] = 78,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [14] = {
    ["name"] = "Mine Rat",
    ["id"] = 130437,
    ["count"] = 2,
    ["health"] = 461097,
    ["scale"] = 0.8,
    ["displayId"] = 65436,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [263209] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 336.64831715532,
        ["y"] = -248.51747410029,
        ["g"] = 42,
        ["sublevel"] = 1,
        ["infested"] = {
        },
      },
      [2] = {
        ["x"] = 340.54952988674,
        ["y"] = -243.87644139072,
        ["g"] = 42,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [3] = {
        ["x"] = 333.12163283447,
        ["y"] = -269.6340825539,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 338.24100852005,
        ["y"] = -270.78155789664,
        ["g"] = 43,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 321.36786067196,
        ["y"] = -243.99712109165,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 314.70046805279,
        ["y"] = -252.02475529748,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 285.73839641588,
        ["y"] = -263.39813899924,
        ["g"] = 48,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [8] = {
        ["x"] = 270.99530544114,
        ["y"] = -250.34413776449,
        ["g"] = 50,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [9] = {
        ["x"] = 266.86495652465,
        ["y"] = -252.95285225745,
        ["g"] = 50,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 244.5232831631,
        ["y"] = -257.29908278369,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 246.44636910375,
        ["y"] = -268.64522215933,
        ["g"] = 51,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
    },
  },
  [15] = {
    ["name"] = "Wanton Sapper",
    ["id"] = 130653,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 81316,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268362] = {
      },
      [268712] = {
      },
      [269313] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 336.60257197849,
        ["y"] = -265.59673655247,
        ["g"] = 43,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [2] = {
        ["x"] = 318.92820628973,
        ["y"] = -252.00063473159,
        ["g"] = 44,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 321.91482562423,
        ["y"] = -264.63248688424,
        ["g"] = 45,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [4] = {
        ["x"] = 305.38422940856,
        ["y"] = -255.28176587313,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 305.38422940856,
        ["y"] = -261.21926356403,
        ["g"] = 46,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 275.2823863862,
        ["y"] = -273.33538547124,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 269.70900859751,
        ["y"] = -271.08418338594,
        ["g"] = 49,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 302.93195254732,
        ["y"] = -237.55447821519,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 307.99481933585,
        ["y"] = -240.77558834183,
        ["g"] = 53,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 275.38344175447,
        ["y"] = -245.00103764999,
        ["g"] = 54,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 256.71579212167,
        ["y"] = -172.75811240719,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 235.82972559439,
        ["y"] = -176.93532788558,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 239.30571288417,
        ["y"] = -180.2668553939,
        ["g"] = 78,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [16] = {
    ["name"] = "Azerite Extractor",
    ["id"] = 136643,
    ["count"] = 12,
    ["health"] = 1229592,
    ["scale"] = 1.2,
    ["displayId"] = 84881,
    ["creatureType"] = "Mechanical",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268415] = {
      },
      [268417] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 290.29653993565,
        ["y"] = -268.45436094448,
        ["g"] = 48,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 250.33429794346,
        ["y"] = -255.35927933195,
        ["g"] = 88,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 253.56174912058,
        ["y"] = -271.5298510703,
        ["g"] = 51,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [4] = {
        ["x"] = 279.24259872388,
        ["y"] = -241.57420081507,
        ["g"] = 54,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
    },
  },
  [17] = {
    ["name"] = "Safety Shark",
    ["id"] = 137940,
    ["count"] = 4,
    ["health"] = 3073980,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 12207,
    ["creatureType"] = "Beast",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["spells"] = {
      [257478] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 297.3989234896,
        ["y"] = -187.06471973415,
        ["sublevel"] = 1,
        ["patrol"] = {
        },
      },
      [2] = {
        ["x"] = 311.91508142068,
        ["y"] = -198.35504171889,
        ["sublevel"] = 1,
        ["patrol"] = {
        },
      },
      [3] = {
        ["x"] = 332.56021551615,
        ["y"] = -192.54859515885,
        ["sublevel"] = 1,
        ["patrol"] = {
        },
      },
      [4] = {
        ["x"] = 305.78424056015,
        ["y"] = -169.57684578475,
        ["sublevel"] = 1,
        ["patrol"] = {
        },
      },
      [5] = {
        ["x"] = 322.8676100705,
        ["y"] = -171.24349221168,
        ["sublevel"] = 1,
        ["patrol"] = {
        },
      },
      [6] = {
        ["x"] = 315.99259856438,
        ["y"] = -183.53519624758,
        ["sublevel"] = 1,
        ["patrol"] = {
        },
      },
    },
  },
  [18] = {
    ["name"] = "Shalebiter",
    ["id"] = 134005,
    ["count"] = 1,
    ["health"] = 153699,
    ["scale"] = 0.7,
    ["displayId"] = 88196,
    ["creatureType"] = "Elemental",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [263262] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 282.48000067196,
        ["y"] = -221.74336883029,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 278.26948700647,
        ["y"] = -224.90126537291,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 281.55896986543,
        ["y"] = -224.63811532726,
        ["g"] = 55,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 257.86476856303,
        ["y"] = -194.44559164829,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 252.63086370807,
        ["y"] = -198.73055061898,
        ["g"] = 57,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [6] = {
        ["x"] = 257.04143871153,
        ["y"] = -198.63700036022,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
    },
  },
  [19] = {
    ["name"] = "Stonefury",
    ["id"] = 130635,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 83052,
    ["creatureType"] = "Elemental",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [263215] = {
      },
      [268702] = {
      },
      [268704] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 273.66423133224,
        ["y"] = -216.8749518169,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 273.66423133224,
            ["y"] = -216.8749518169,
          },
          [2] = {
            ["x"] = 268.00634159488,
            ["y"] = -210.95390638714,
          },
          [3] = {
            ["x"] = 273.66423133224,
            ["y"] = -216.8749518169,
          },
          [4] = {
            ["x"] = 279.71686307833,
            ["y"] = -222.53284720101,
          },
        },
        ["infested"] = {
          [2] = true,
        },
      },
      [2] = {
        ["x"] = 260.29190043111,
        ["y"] = -203.14913954218,
        ["g"] = 57,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [3] = {
        ["x"] = 252.68472623618,
        ["y"] = -192.84441003172,
        ["g"] = 57,
        ["sublevel"] = 1,
      },
    },
  },
  [20] = {
    ["name"] = "Taskmaster Askari",
    ["id"] = 134012,
    ["count"] = 6,
    ["health"] = 1229592,
    ["scale"] = 1.4,
    ["displayId"] = 83286,
    ["creatureType"] = "Humanoid",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [263275] = {
      },
      [263276] = {
      },
      [263583] = {
      },
      [263586] = {
      },
      [263601] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 247.29418483409,
        ["y"] = -176.25325035966,
        ["g"] = 78,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Azerokk",
    ["id"] = 129227,
    ["count"] = 0,
    ["health"] = 4733929,
    ["scale"] = 1,
    ["displayId"] = 83891,
    ["creatureType"] = "Elemental",
    ["level"] = 122,
    ["isBoss"] = true,
    ["encounterID"] = 2114,
    ["instanceID"] = 1012,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [257593] = {
      },
      [257597] = {
      },
      [258622] = {
      },
      [271698] = {
      },
      [275907] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 252.15696974033,
        ["y"] = -149.53323722569,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
    },
  },
  [22] = {
    ["name"] = "Earthrager",
    ["id"] = 129802,
    ["count"] = 0,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 83052,
    ["creatureType"] = "Elemental",
    ["level"] = 120,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Banish"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [257544] = {
      },
      [257582] = {
      },
      [258627] = {
      },
      [271526] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 261.20676759075,
        ["y"] = -145.56099820803,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 257.62465658313,
        ["y"] = -158.24756556426,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 241.80375810842,
        ["y"] = -153.02369317734,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 246.57988903784,
        ["y"] = -140.03861443538,
        ["g"] = 58,
        ["sublevel"] = 1,
      },
    },
  },
  [23] = {
    ["name"] = "Footbomb Hooligan",
    ["id"] = 138369,
    ["count"] = 0,
    ["health"] = 153699,
    ["scale"] = 0.6,
    ["displayId"] = 85829,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["spells"] = {
      [271784] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 308.8830745492,
        ["y"] = -104.75213306346,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 324.06870177232,
        ["y"] = -112.39530952304,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 326.92585234537,
        ["y"] = -105.25247907113,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 327.64014765209,
        ["y"] = -101.32388553799,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 328.35441230499,
        ["y"] = -98.823882618294,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 314.83818044678,
        ["y"] = -96.767636866554,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 317.73291000349,
        ["y"] = -94.267649318578,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 321.68027362333,
        ["y"] = -95.320277734951,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 317.60132933391,
        ["y"] = -97.557109590522,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 314.57501910762,
        ["y"] = -99.793958386356,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 320.89080089936,
        ["y"] = -99.004480015633,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 309.70660209423,
        ["y"] = -101.89922086586,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 310.36449414862,
        ["y"] = -107.42552993363,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 312.73292361403,
        ["y"] = -108.87289471199,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 317.46974866433,
        ["y"] = -100.05711972551,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 322.60133831039,
        ["y"] = -101.76763454952,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 321.94343496249,
        ["y"] = -105.32026745413,
        ["g"] = 59,
        ["sublevel"] = 1,
      },
    },
  },
  [24] = {
    ["name"] = "Venture Co. Mastermind",
    ["id"] = 133430,
    ["count"] = 8,
    ["health"] = 1229592,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 83136,
    ["creatureType"] = "Humanoid",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [262794] = {
      },
      [262804] = {
      },
      [262947] = {
      },
      [271428] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 426.4223142796,
        ["y"] = -114.87366004873,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 425.7326203986,
        ["y"] = -120.73573247268,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 361.86321322224,
        ["y"] = -148.69317920568,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 361.86321322224,
            ["y"] = -148.69317920568,
          },
          [2] = {
            ["x"] = 354.03715241535,
            ["y"] = -143.91056264851,
          },
          [3] = {
            ["x"] = 361.86321322224,
            ["y"] = -148.69317920568,
          },
          [4] = {
            ["x"] = 373.13469152513,
            ["y"] = -149.87321883214,
          },
        },
      },
      [4] = {
        ["x"] = 364.22819552767,
        ["y"] = -111.94521274864,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 364.22819552767,
            ["y"] = -111.94521274864,
          },
          [2] = {
            ["x"] = 357.50405754684,
            ["y"] = -116.9452196157,
          },
          [3] = {
            ["x"] = 364.22819552767,
            ["y"] = -111.94521274864,
          },
          [4] = {
            ["x"] = 372.50404855123,
            ["y"] = -108.32451965164,
          },
        },
        ["infested"] = {
          [3] = true,
        },
      },
      [5] = {
        ["x"] = 387.11718681777,
        ["y"] = -106.89309868833,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 387.11718681777,
            ["y"] = -106.89309868833,
          },
          [2] = {
            ["x"] = 376.75353807875,
            ["y"] = -102.34763077539,
          },
          [3] = {
            ["x"] = 387.11718681777,
            ["y"] = -106.89309868833,
          },
          [4] = {
            ["x"] = 395.6626452705,
            ["y"] = -116.34764448141,
          },
        },
      },
      [6] = {
        ["x"] = 391.28214632718,
        ["y"] = -127.95643401756,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 391.28214632718,
            ["y"] = -127.95643401756,
          },
          [2] = {
            ["x"] = 384.90282569007,
            ["y"] = -134.6805572,
          },
          [3] = {
            ["x"] = 391.28214632718,
            ["y"] = -127.95643401756,
          },
          [4] = {
            ["x"] = 396.28215319424,
            ["y"] = -121.23230343592,
          },
        },
        ["infested"] = {
          [3] = true,
        },
      },
      [7] = {
        ["x"] = 371.83635399335,
        ["y"] = -135.82534968228,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 367.57290486676,
            ["y"] = -134.454518109,
          },
          [2] = {
            ["x"] = 377.57289908,
            ["y"] = -140.73360211461,
          },
          [3] = {
            ["x"] = 367.57290486676,
            ["y"] = -134.454518109,
          },
          [4] = {
            ["x"] = 358.03803316225,
            ["y"] = -128.64055661211,
          },
        },
        ["infested"] = {
        },
      },
      [8] = {
        ["x"] = 409.74688664058,
        ["y"] = -109.67485765522,
        ["g"] = 65,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [9] = {
        ["x"] = 370.46648478504,
        ["y"] = -126.78425288335,
        ["g"] = 75,
        ["sublevel"] = 1,
        ["teeming"] = true,
        ["infested"] = {
        },
      },
    },
  },
  [25] = {
    ["name"] = "Feckless Assistant",
    ["id"] = 133345,
    ["count"] = 5,
    ["health"] = 768495,
    ["scale"] = 0.8,
    ["displayId"] = 82866,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [262263] = {
      },
      [263066] = {
      },
      [263074] = {
      },
      [263103] = {
      },
      [263105] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 342.49887736161,
        ["y"] = -96.118657816419,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 339.05061513406,
        ["y"] = -97.670387657532,
        ["g"] = 60,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 352.86760421168,
        ["y"] = -110.67757559578,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 371.70169599061,
        ["y"] = -88.467782982899,
        ["g"] = 63,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [5] = {
        ["x"] = 382.49051316428,
        ["y"] = -91.814075922799,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 423.83608801216,
        ["y"] = -109.01160242318,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 408.80034973201,
        ["y"] = -126.9038768246,
        ["g"] = 67,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [8] = {
        ["x"] = 376.06223543989,
        ["y"] = -156.20269452448,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 354.36371909447,
        ["y"] = -157.08512826728,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 364.57607893489,
        ["y"] = -119.66097180029,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 369.7815560597,
        ["y"] = -118.56508466398,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
    },
  },
  [26] = {
    ["name"] = "Weapons Tester",
    ["id"] = 136934,
    ["count"] = 4,
    ["teemingCount"] = 5,
    ["health"] = 768495,
    ["scale"] = 0.8,
    ["displayId"] = 84962,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268846] = {
      },
      [268865] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 338.6933916311,
        ["y"] = -92.98872066061,
        ["g"] = 60,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [2] = {
        ["x"] = 386.05215664521,
        ["y"] = -94.416826242829,
        ["g"] = 64,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 400.78138413119,
        ["y"] = -106.22658062928,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 403.53999687291,
        ["y"] = -111.22658749633,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 397.47278205007,
        ["y"] = -154.86916077277,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 375.50234780232,
        ["y"] = -168.07602044777,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 349.01942633565,
        ["y"] = -157.60974069404,
        ["g"] = 74,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 366.63087686854,
        ["y"] = -123.08563894226,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
    },
  },
  [27] = {
    ["name"] = "Venture Co. Alchemist",
    ["id"] = 133432,
    ["count"] = 5,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 82915,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [262268] = {
      },
      [262270] = {
      },
      [268797] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 356.65256956271,
        ["y"] = -108.03046315425,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 365.67812842666,
        ["y"] = -92.698542186826,
        ["g"] = 63,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 382.62750126087,
        ["y"] = -95.78667193589,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 382.62750126087,
            ["y"] = -95.78667193589,
          },
          [2] = {
            ["x"] = 369.47680859463,
            ["y"] = -94.416826242829,
          },
          [3] = {
            ["x"] = 382.62750126087,
            ["y"] = -95.78667193589,
          },
        },
        ["infested"] = {
          [2] = true,
        },
      },
      [4] = {
        ["x"] = 405.95380706931,
        ["y"] = -105.19209900133,
        ["g"] = 65,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 425.7219165469,
        ["y"] = -127.90752708398,
        ["g"] = 66,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 407.86632302462,
        ["y"] = -130.66933052743,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 405.67241033308,
        ["y"] = -132.6143762488,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 402.42238808984,
        ["y"] = -135.36437031115,
        ["g"] = 67,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 400.09572524552,
        ["y"] = -143.8855500859,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 390.98602676877,
        ["y"] = -171.12315932201,
        ["g"] = 71,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [11] = {
        ["x"] = 385.1164764989,
        ["y"] = -159.81880987673,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 371.59605979418,
        ["y"] = -164.63852884306,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 371.59605979418,
        ["y"] = -170.26352242043,
        ["g"] = 72,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 372.07401292909,
        ["y"] = -155.20682004787,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 374.92301263338,
        ["y"] = -151.01280214673,
        ["g"] = 73,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 350.33091903928,
        ["y"] = -152.36386133844,
        ["g"] = 74,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [17] = {
        ["x"] = 373.34321129826,
        ["y"] = -123.22261528122,
        ["g"] = 75,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 365.27023237456,
        ["y"] = -141.97633420248,
        ["g"] = 77,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 398.54000480425,
        ["y"] = -110.88177015262,
        ["g"] = 65,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [20] = {
        ["x"] = 362.11289539306,
        ["y"] = -122.80716290171,
        ["g"] = 75,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [28] = {
    ["name"] = "Test Subject",
    ["id"] = 133963,
    ["count"] = 1,
    ["health"] = 153699,
    ["scale"] = 0.5,
    ["displayId"] = 1141,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268810] = {
      },
      [268815] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 349.88940408128,
        ["y"] = -107.42976385598,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 354.42467417492,
        ["y"] = -114.07371491933,
        ["g"] = 61,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 351.94330961943,
        ["y"] = -114.7335668989,
        ["g"] = 61,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [4] = {
        ["x"] = 354.30545462517,
        ["y"] = -91.845982810497,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 356.3571527917,
        ["y"] = -90.085019455527,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 358.95990311173,
        ["y"] = -89.948031358933,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 357.86398658135,
        ["y"] = -92.002829292588,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 356.3571527917,
        ["y"] = -93.3726985009,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 354.02837866486,
        ["y"] = -93.3726985009,
        ["g"] = 62,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 403.21050634604,
        ["y"] = -147.32816918582,
        ["g"] = 68,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [11] = {
        ["x"] = 395.66950772378,
        ["y"] = -146.83636645726,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 396.81706383946,
        ["y"] = -149.78718986392,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 400.09572524552,
        ["y"] = -151.09866146165,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 400.42361249203,
        ["y"] = -147.98392257293,
        ["g"] = 68,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 386.12787103318,
        ["y"] = -119.36467831552,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 388.49345438637,
        ["y"] = -117.29667688676,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 384.20244905826,
        ["y"] = -117.28400446284,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 389.47518372237,
        ["y"] = -119.46581251914,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 385.8618748753,
        ["y"] = -115.45457574642,
        ["g"] = 69,
        ["sublevel"] = 1,
      },
      [20] = {
        ["x"] = 387.92423900664,
        ["y"] = -162.87146377604,
        ["g"] = 71,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [21] = {
        ["x"] = 384.17424328839,
        ["y"] = -164.12146011361,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [22] = {
        ["x"] = 384.48674740193,
        ["y"] = -166.465200732,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [23] = {
        ["x"] = 387.76800036091,
        ["y"] = -168.18395994539,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [24] = {
        ["x"] = 389.64299822004,
        ["y"] = -165.37145645119,
        ["g"] = 71,
        ["sublevel"] = 1,
      },
      [25] = {
        ["x"] = 368.90539961288,
        ["y"] = -140.30334173465,
        ["g"] = 77,
        ["sublevel"] = 1,
      },
      [26] = {
        ["x"] = 368.78344679363,
        ["y"] = -143.83992115723,
        ["g"] = 77,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [27] = {
        ["x"] = 366.83223308703,
        ["y"] = -145.4252921068,
        ["g"] = 77,
        ["sublevel"] = 1,
      },
      [28] = {
        ["x"] = 361.3444294907,
        ["y"] = -141.76675463138,
        ["g"] = 77,
        ["sublevel"] = 1,
      },
      [29] = {
        ["x"] = 362.68590003534,
        ["y"] = -138.47407038016,
        ["g"] = 77,
        ["sublevel"] = 1,
      },
    },
  },
  [29] = {
    ["name"] = "Rixxa Fluxflame",
    ["id"] = 129231,
    ["count"] = 0,
    ["health"] = 5379465,
    ["scale"] = 1,
    ["displayId"] = 81489,
    ["creatureType"] = "Humanoid",
    ["level"] = 122,
    ["isBoss"] = true,
    ["encounterID"] = 2115,
    ["instanceID"] = 1012,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [259474] = {
      },
      [259853] = {
      },
      [259856] = {
      },
      [260669] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 466.80802997306,
        ["y"] = -112.22534117666,
        ["sublevel"] = 1,
      },
    },
  },
  [30] = {
    ["name"] = "Expert Technician",
    ["id"] = 133593,
    ["count"] = 5,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 83034,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [262540] = {
      },
      [262554] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 502.68530584216,
        ["y"] = -107.66784182933,
        ["g"] = 79,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [2] = {
        ["x"] = 495.31446879142,
        ["y"] = -125.80409887054,
        ["g"] = 80,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 558.3736973268,
        ["y"] = -113.58970168772,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 602.49991019652,
        ["y"] = -138.97133650933,
        ["g"] = 86,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [5] = {
        ["x"] = 606.66641360611,
        ["y"] = -160.00768784213,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 550.29518805671,
        ["y"] = -121.57230531622,
        ["g"] = 90,
        ["sublevel"] = 1,
      },
    },
  },
  [31] = {
    ["name"] = "Venture Co. War Machine",
    ["id"] = 133463,
    ["count"] = 12,
    ["health"] = 1229592,
    ["scale"] = 1.3,
    ["stealthDetect"] = true,
    ["displayId"] = 83391,
    ["creatureType"] = "Mechanical",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [262383] = {
      },
      [269099] = {
      },
      [269100] = {
      },
      [269429] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 507.03313398718,
        ["y"] = -104.40698471469,
        ["g"] = 79,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [2] = {
        ["x"] = 501.79495014634,
        ["y"] = -128.99618133409,
        ["g"] = 80,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 591.63697586743,
        ["y"] = -116.09386714438,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 591.63697586743,
            ["y"] = -116.09386714438,
          },
          [2] = {
            ["x"] = 586.26383497711,
            ["y"] = -108.63118498562,
          },
          [3] = {
            ["x"] = 591.63697586743,
            ["y"] = -116.09386714438,
          },
          [4] = {
            ["x"] = 598.20413667957,
            ["y"] = -125.49684768927,
          },
        },
      },
      [4] = {
        ["x"] = 574.2169183565,
        ["y"] = -119.0625439491,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 576.08848904957,
            ["y"] = -126.52056756911,
          },
          [2] = {
            ["x"] = 570.14284059589,
            ["y"] = -113.72897735969,
          },
          [3] = {
            ["x"] = 576.08848904957,
            ["y"] = -126.52056756911,
          },
          [4] = {
            ["x"] = 584.15297508797,
            ["y"] = -145.2302194779,
          },
        },
        ["infested"] = {
          [3] = true,
        },
      },
      [5] = {
        ["x"] = 564.63620385762,
        ["y"] = -149.69133509057,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 564.63620385762,
            ["y"] = -149.69133509057,
          },
          [2] = {
            ["x"] = 557.72836194741,
            ["y"] = -140.28280291519,
          },
          [3] = {
            ["x"] = 564.63620385762,
            ["y"] = -149.69133509057,
          },
          [4] = {
            ["x"] = 570.6594044943,
            ["y"] = -157.17932630602,
          },
        },
      },
      [6] = {
        ["x"] = 610.70629446065,
        ["y"] = -165.32110385425,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
    },
  },
  [32] = {
    ["name"] = "Ordnance Specialist",
    ["id"] = 137029,
    ["count"] = 5,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 85024,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [269090] = {
      },
      [269092] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 505.66596989434,
        ["y"] = -122.86716363872,
        ["g"] = 80,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
          [2] = true,
        },
      },
      [2] = {
        ["x"] = 519.75965424701,
        ["y"] = -105.79333791783,
        ["g"] = 81,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [3] = {
        ["x"] = 519.68925146648,
        ["y"] = -112.34037467397,
        ["g"] = 81,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 547.55938846329,
        ["y"] = -108.8101506555,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 560.76499627596,
        ["y"] = -118.15494269766,
        ["g"] = 82,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 586.47345853923,
        ["y"] = -147.43362106064,
        ["g"] = 84,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
    },
  },
  [33] = {
    ["name"] = "Venture Co. Skyscorcher",
    ["id"] = 133436,
    ["count"] = 5,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 82922,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [260372] = {
      },
      [262287] = {
      },
      [262513] = {
      },
      [262515] = {
      },
      [277242] = {
      },
      [277564] = {
      },
      [281621] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 538.77523388938,
        ["y"] = -114.90501753788,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 538.46753015731,
        ["y"] = -99.129630339316,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [3] = {
        ["x"] = 554.9281381064,
        ["y"] = -127.01005945566,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 568.88324042251,
        ["y"] = -107.02042727081,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 566.85199050662,
        ["y"] = -111.70792191861,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 579.89810044849,
        ["y"] = -153.32402103198,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 602.10878780705,
        ["y"] = -130.64835797805,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [8] = {
        ["x"] = 612.93507584307,
        ["y"] = -158.96290439736,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 603.68135099104,
        ["y"] = -166.42558655613,
        ["g"] = 85,
        ["sublevel"] = 1,
      },
    },
  },
  [34] = {
    ["name"] = "Mogul Razdunk",
    ["id"] = 129232,
    ["count"] = 0,
    ["health"] = 5994261,
    ["scale"] = 1,
    ["displayId"] = 81816,
    ["creatureType"] = "Mechanical",
    ["level"] = 122,
    ["isBoss"] = true,
    ["encounterID"] = 2116,
    ["instanceID"] = 1012,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [260189] = {
      },
      [260190] = {
      },
      [260202] = {
      },
      [260280] = {
      },
      [260318] = {
      },
      [260323] = {
      },
      [260811] = {
      },
      [260813] = {
      },
      [270277] = {
      },
      [270926] = {
      },
      [271456] = {
      },
      [276212] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 578.23777434257,
        ["y"] = -210.91697510937,
        ["sublevel"] = 1,
      },
    },
  },
  [35] = {
    ["name"] = "Crawler Mine",
    ["id"] = 133482,
    ["count"] = 1,
    ["health"] = 19707,
    ["scale"] = 0.7,
    ["displayId"] = 49134,
    ["creatureType"] = "Mechanical",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Root"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [262348] = {
      },
      [262377] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 523.10031706718,
        ["y"] = -109.86235489806,
        ["g"] = 81,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 525.2051065873,
        ["y"] = -118.95296105033,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 518.01036176257,
        ["y"] = -96.483800295248,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 528.91721638771,
        ["y"] = -106.84243946323,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 529.03708273502,
        ["y"] = -91.606328234521,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 549.24948717915,
        ["y"] = -100.5006560559,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 549.62471512875,
        ["y"] = -127.04978404908,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 556.63460193472,
        ["y"] = -140.92006428613,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 570.05231417427,
        ["y"] = -157.62893163199,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 563.56908813178,
        ["y"] = -106.05627477129,
        ["g"] = 83,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 594.5664396924,
        ["y"] = -125.16008960038,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 604.86618540451,
        ["y"] = -135.01951743756,
        ["g"] = 86,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 608.83169584523,
        ["y"] = -126.05401492818,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 584.22776588243,
        ["y"] = -151.90464432582,
        ["g"] = 84,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 581.15178658182,
        ["y"] = -137.84301532828,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 606.88765938666,
        ["y"] = -146.71115472387,
        ["sublevel"] = 1,
      },
      [17] = {
        ["x"] = 591.40619005933,
        ["y"] = -157.38732508187,
        ["sublevel"] = 1,
      },
      [18] = {
        ["x"] = 582.18172379917,
        ["y"] = -106.29985863928,
        ["sublevel"] = 1,
      },
      [19] = {
        ["x"] = 596.53743518509,
        ["y"] = -109.51050590374,
        ["sublevel"] = 1,
      },
    },
  },
  [36] = {
    ["name"] = "Mechanized Peacekeeper",
    ["id"] = 130485,
    ["count"] = 12,
    ["health"] = 1229592,
    ["scale"] = 1.2,
    ["displayId"] = 82943,
    ["creatureType"] = "Mechanical",
    ["level"] = 121,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [262066] = {
      },
      [262412] = {
      },
      [263628] = {
      },
      [267367] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 452.76276992635,
        ["y"] = -349.0153562019,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 463.47855634964,
        ["y"] = -332.18362000556,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 484.79616675868,
        ["y"] = -342.42002021961,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 489.9598137371,
        ["y"] = -317.60601667629,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 480.33373232292,
        ["y"] = -306.7816622197,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 464.44097692694,
        ["y"] = -300.0470909243,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 456.33809052917,
        ["y"] = -303.97643978494,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 415.68526370019,
        ["y"] = -325.33374698576,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 424.26441507197,
        ["y"] = -338.91935176132,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 440.31990437513,
        ["y"] = -337.70941677999,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 475.46170266607,
        ["y"] = -414.06142606187,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 451.21285447553,
        ["y"] = -337.97276073111,
        ["sublevel"] = 1,
      },
    },
  },
  [37] = {
    ["name"] = "Asset Manager",
    ["id"] = 144286,
    ["count"] = 0,
    ["health"] = 153699,
    ["scale"] = 1,
    ["displayId"] = 85704,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["clones"] = {
      [1] = {
        ["x"] = 592.36265829,
        ["y"] = -260.93717892805,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 597.13880202998,
        ["y"] = -257.0565821558,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 602.06415022062,
        ["y"] = -253.62374605687,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 597.73577355924,
        ["y"] = -261.68344458181,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 602.21341872403,
        ["y"] = -258.39986417575,
        ["g"] = 87,
        ["sublevel"] = 1,
      },
    },
  },
  [38] = {
    ["name"] = "Off-Duty Laborer",
    ["id"] = 135975,
    ["count"] = 0,
    ["health"] = 307398,
    ["scale"] = 1,
    ["displayId"] = 81229,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["clones"] = {
      [1] = {
        ["x"] = 495.93072211015,
        ["y"] = -319.75791518289,
        ["g"] = 23,
        ["sublevel"] = 1,
      },
    },
  },
  [39] = {
    ["name"] = "Void-Touched Emissary",
    ["id"] = 155433,
    ["count"] = 4,
    ["health"] = 999042,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["stealthDetect"] = true,
    ["displayId"] = 39391,
    ["iconTexture"] = 132886,
    ["creatureType"] = "Humanoid",
    ["level"] = 122,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [302415] = {
      },
      [302419] = {
      },
      [302420] = {
      },
      [302421] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 456.21730727281,
        ["y"] = -440.46506334809,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 457.93196886807,
        ["y"] = -399.05851592266,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [3] = {
        ["x"] = 426.15899812353,
        ["y"] = -363.87891908174,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [4] = {
        ["x"] = 340.37292437476,
        ["y"] = -266.95943836528,
        ["g"] = 43,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [5] = {
        ["x"] = 285.3946546269,
        ["y"] = -268.78338423016,
        ["g"] = 48,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [6] = {
        ["x"] = 342.87463696164,
        ["y"] = -114.47948170265,
        ["g"] = 92,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [7] = {
        ["x"] = 409.46219370416,
        ["y"] = -135.16608768845,
        ["g"] = 67,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [8] = {
        ["x"] = 544.62713215961,
        ["y"] = -125.83276061525,
        ["g"] = 90,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [9] = {
        ["x"] = 588.89663352901,
        ["y"] = -162.81799280706,
        ["g"] = 93,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [10] = {
        ["x"] = 585.78837576708,
        ["y"] = -103.0860152079,
        ["g"] = 94,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [11] = {
        ["x"] = 359.03215169639,
        ["y"] = -100.26557329067,
        ["g"] = 95,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [12] = {
        ["x"] = 477.31823708605,
        ["y"] = -349.57359956652,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [13] = {
        ["x"] = 464.95951532226,
        ["y"] = -341.91596055426,
        ["g"] = 20,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [14] = {
        ["x"] = 378.8967094098,
        ["y"] = -153.39285998377,
        ["g"] = 73,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [15] = {
        ["x"] = 274.49933422896,
        ["y"] = -254.28940042562,
        ["g"] = 50,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [16] = {
        ["x"] = 431.73341636712,
        ["y"] = -352.43446184518,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [17] = {
        ["x"] = 337.40221851439,
        ["y"] = -260.3324319918,
        ["g"] = 43,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [18] = {
        ["x"] = 376.37514870388,
        ["y"] = -162.57133418459,
        ["g"] = 72,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [19] = {
        ["x"] = 541.97137453729,
        ["y"] = -96.844939882672,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
    },
  },
  [40] = {
    ["name"] = "Emissary of the Tides",
    ["id"] = 155434,
    ["count"] = 4,
    ["health"] = 614795,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 39391,
    ["iconTexture"] = 132315,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [302415] = {
      },
      [302417] = {
      },
      [302418] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 469.14798360903,
        ["y"] = -419.30592443047,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 431.5590084809,
        ["y"] = -351.07890343192,
        ["g"] = 39,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [3] = {
        ["x"] = 298.05149006111,
        ["y"] = -245.89392958249,
        ["g"] = 53,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [4] = {
        ["x"] = 499.69142826978,
        ["y"] = -121.55414072741,
        ["g"] = 80,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [5] = {
        ["x"] = 447.83297820449,
        ["y"] = -437.56568167695,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [6] = {
        ["x"] = 469.62866891268,
        ["y"] = -407.62643133508,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [7] = {
        ["x"] = 453.9016579131,
        ["y"] = -359.82352427916,
        ["g"] = 19,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [8] = {
        ["x"] = 506.47985181098,
        ["y"] = -110.81662886629,
        ["g"] = 79,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [9] = {
        ["x"] = 607.94207884334,
        ["y"] = -153.52189320554,
        ["g"] = 85,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [10] = {
        ["x"] = 364.42964460697,
        ["y"] = -127.79127934087,
        ["g"] = 75,
        ["sublevel"] = 1,
        ["teeming"] = true,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [11] = {
        ["x"] = 385.14777414932,
        ["y"] = -170.95800220248,
        ["g"] = 71,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [12] = {
        ["x"] = 597.98123807581,
        ["y"] = -114.59273809432,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [13] = {
        ["x"] = 433.96087064676,
        ["y"] = -330.82405856665,
        ["g"] = 32,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [14] = {
        ["x"] = 332.44024483023,
        ["y"] = -249.18742899505,
        ["g"] = 42,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [15] = {
        ["x"] = 320.10730662658,
        ["y"] = -273.55010288998,
        ["g"] = 45,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [16] = {
        ["x"] = 249.48524098056,
        ["y"] = -186.24588916952,
        ["g"] = 78,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [17] = {
        ["x"] = 463.26480745136,
        ["y"] = -369.02799891071,
        ["g"] = 40,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [18] = {
        ["x"] = 431.91078906381,
        ["y"] = -308.06065992015,
        ["g"] = 29,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [19] = {
        ["x"] = 274.72576208774,
        ["y"] = -253.30203325208,
        ["g"] = 50,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [20] = {
        ["x"] = 354.47799476409,
        ["y"] = -152.77823995884,
        ["g"] = 74,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [21] = {
        ["x"] = 407.97341110856,
        ["y"] = -138.62871651868,
        ["g"] = 67,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
    },
  },
  [41] = {
    ["name"] = "Enchanted Emissary",
    ["id"] = 155432,
    ["count"] = 4,
    ["health"] = 15369884,
    ["ignoreFortified"] = true,
    ["scale"] = 1,
    ["displayId"] = 39391,
    ["iconTexture"] = 135735,
    ["creatureType"] = "Humanoid",
    ["level"] = 121,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [290027] = {
      },
      [302415] = {
      },
      [303632] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 435.73194131414,
        ["y"] = -404.34503491716,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 403.85253384018,
        ["y"] = -310.7057581121,
        ["g"] = 31,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [3] = {
        ["x"] = 264.93665383449,
        ["y"] = -210.19103640257,
        ["g"] = 91,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [4] = {
        ["x"] = 378.27765216552,
        ["y"] = -93.444632456317,
        ["g"] = 64,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [5] = {
        ["x"] = 439.48496071633,
        ["y"] = -379.80077330232,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [6] = {
        ["x"] = 434.12891344728,
        ["y"] = -360.73261878147,
        ["g"] = 38,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [7] = {
        ["x"] = 397.02356652965,
        ["y"] = -106.17705559142,
        ["g"] = 65,
        ["sublevel"] = 1,
        ["teeming"] = true,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [8] = {
        ["x"] = 463.52692933041,
        ["y"] = -312.68355585776,
        ["g"] = 26,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [9] = {
        ["x"] = 478.52602749201,
        ["y"] = -318.43235726429,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [10] = {
        ["x"] = 276.06405373428,
        ["y"] = -279.50658618918,
        ["g"] = 49,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [11] = {
        ["x"] = 445.09921578365,
        ["y"] = -438.0482033974,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [12] = {
        ["x"] = 471.56644600259,
        ["y"] = -406.78164734194,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [13] = {
        ["x"] = 477.47363930839,
        ["y"] = -349.6539686079,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [14] = {
        ["x"] = 411.42107596531,
        ["y"] = -339.69608421782,
        ["g"] = 34,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [15] = {
        ["x"] = 410.69221255131,
        ["y"] = -299.48768494855,
        ["g"] = 30,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [16] = {
        ["x"] = 308.84023601405,
        ["y"] = -246.33302758865,
        ["g"] = 53,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [17] = {
        ["x"] = 348.41874873088,
        ["y"] = -112.10252312857,
        ["g"] = 61,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [18] = {
        ["x"] = 392.30650249191,
        ["y"] = -162.23822292246,
        ["g"] = 71,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [19] = {
        ["x"] = 499.7902426258,
        ["y"] = -121.36477656806,
        ["g"] = 80,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [20] = {
        ["x"] = 562.65964352978,
        ["y"] = -157.63992794576,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
    },
  },
  [42] = {
    ["name"] = "Samh'rek, Beckoner of Chaos",
    ["id"] = 161243,
    ["count"] = 4,
    ["teemingCount"] = 6,
    ["health"] = 2151786,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 90742,
    ["creatureType"] = "Aberration",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314397] = {
      },
      [314477] = {
      },
      [314483] = {
      },
      [314531] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 535.23214910256,
        ["y"] = -107.06310141478,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [3] = true,
          [4] = true,
          [5] = true,
          [6] = true,
          [7] = true,
          [8] = true,
          [9] = true,
          [10] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [43] = {
    ["name"] = "Urg'roth, Breaker of Heroes",
    ["id"] = 161124,
    ["count"] = 4,
    ["teemingCount"] = 6,
    ["health"] = 2151786,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 89415,
    ["creatureType"] = "Aberration",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314308] = {
      },
      [314309] = {
      },
      [314387] = {
      },
      [314397] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 449.93614630826,
        ["y"] = -415.51082329646,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [3] = true,
          [4] = true,
          [5] = true,
          [6] = true,
          [7] = true,
          [8] = true,
          [9] = true,
          [10] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [44] = {
    ["name"] = "Voidweaver Mal'thir",
    ["id"] = 161241,
    ["count"] = 4,
    ["teemingCount"] = 6,
    ["health"] = 2151786,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 91910,
    ["creatureType"] = "Beast",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314397] = {
      },
      [314406] = {
      },
      [314411] = {
      },
      [314463] = {
      },
      [314467] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 304.66635013543,
        ["y"] = -272.74135778189,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 332.56610354198,
        ["y"] = -116.82429592987,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [45] = {
    ["name"] = "Blood of the Corruptor",
    ["id"] = 161244,
    ["count"] = 4,
    ["teemingCount"] = 6,
    ["health"] = 2151786,
    ["scale"] = 1.4,
    ["stealthDetect"] = true,
    ["displayId"] = 92229,
    ["creatureType"] = "Aberration",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314397] = {
      },
      [314565] = {
      },
      [314566] = {
      },
      [314592] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 333.4636831689,
        ["y"] = -117.72186664014,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 302.64676659448,
        ["y"] = -274.79831668879,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
};
