local MDT = MDT
local L = MDT.L
local dungeonIndex = 20
MDT.dungeonList[dungeonIndex] = L["Temple of Sethraliss"]

local zones = { 1038, 1043 }
for _, zone in ipairs(zones) do
  MDT.zoneIdToDungeonIdx[zone] = dungeonIndex
end

MDT.dungeonTotalCount[dungeonIndex] = { normal = 220, teeming = 264, teemingEnabled = true }

MDT.dungeonMaps[dungeonIndex] = {
  [0] = "TempleOfSethralissA",
  [1] = "TempleOfSethralissA",
  [2] = "TempleOfSethralissB",
}
MDT.dungeonSubLevels[dungeonIndex] = {
  [1] = L["Temple of Sethraliss Sublevel"],
  [2] = L["Atrium of Sethraliss"],
}

MDT.mapPOIs[dungeonIndex] = {
  [1] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 335.00001778454,
      ["y"] = -73.998246995732,
      ["target"] = 2,
      ["direction"] = -2,
      ["connectionIndex"] = 1,
    },
    [2] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 571.10587581764,
      ["y"] = -541.41229396957,
      ["graveyardDescription"] = "",
    },
    [3] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 370.20027720976,
      ["y"] = -267.29618127731,
      ["graveyardDescription"] = "templeGraveyardNote1",
    },
    [4] = {
      ["template"] = "DeathReleasePinTemplate",
      ["type"] = "graveyard",
      ["x"] = 382.02713945136,
      ["y"] = -165.06919033154,
      ["graveyardDescription"] = "templeGraveyardNote2",
    },
    [5] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 300,
      ["y"] = -200,
      ["index"] = 1,
      ["npcId"] = 161244,
      ["tooltipText"] = "Defiled Spire of Ny'alotha",
      ["weeks"] = {
      },
    },
    [6] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 439.11747637335,
      ["y"] = -403.01166505144,
      ["scale"] = 0.7,
      ["index"] = 1,
      ["npcId"] = 161124,
      ["tooltipText"] = "Brutal Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [5] = true,
        [6] = true,
        [9] = true,
        [10] = true,
      },
    },
    [7] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 428.50334041028,
      ["y"] = -176.57890633549,
      ["scale"] = 0.7,
      ["index"] = 3,
      ["npcId"] = 161243,
      ["tooltipText"] = "Entropic Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [5] = true,
        [6] = true,
        [9] = true,
        [10] = true,
      },
    },
    [8] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 437.55768863205,
      ["y"] = -405.98277277096,
      ["scale"] = 0.7,
      ["index"] = 5,
      ["npcId"] = 161243,
      ["tooltipText"] = "Entropic Spire of Ny'alotha",
      ["weeks"] = {
        [3] = true,
        [4] = true,
        [7] = true,
        [8] = true,
        [11] = true,
        [12] = true,
      },
    },
    [9] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 569.75769252457,
      ["y"] = -517.94951775516,
      ["scale"] = 0.7,
      ["index"] = 1,
      ["npcId"] = 161244,
      ["tooltipText"] = "Defiled Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [3] = true,
        [4] = true,
        [5] = true,
        [6] = true,
        [7] = true,
        [8] = true,
        [9] = true,
        [10] = true,
        [11] = true,
        [12] = true,
      },
    },
    [10] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 428.45847734519,
      ["y"] = -177.95106677132,
      ["scale"] = 0.7,
      ["index"] = 6,
      ["npcId"] = 161124,
      ["tooltipText"] = "Brutal Spire of Ny'alotha",
      ["weeks"] = {
        [3] = true,
        [4] = true,
        [7] = true,
        [8] = true,
        [11] = true,
        [12] = true,
      },
    },
  },
  [2] = {
    [1] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "mapLink",
      ["x"] = 559.00008483976,
      ["y"] = -493.99826543592,
      ["target"] = 1,
      ["direction"] = 2,
      ["connectionIndex"] = 1,
    },
    [2] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "templeEye",
      ["x"] = 534.63990976737,
      ["y"] = -360.12915173214,
    },
    [3] = {
      ["template"] = "MapLinkPinTemplate",
      ["type"] = "templeEye",
      ["x"] = 429.98898521393,
      ["y"] = -420.50072225326,
    },
    [4] = {
      ["template"] = "VignettePinTemplate",
      ["type"] = "nyalothaSpire",
      ["x"] = 496.16008727721,
      ["y"] = -404.37457372909,
      ["scale"] = 1.2,
      ["index"] = 4,
      ["npcId"] = 161241,
      ["tooltipText"] = "Cursed Spire of Ny'alotha",
      ["weeks"] = {
        [1] = true,
        [2] = true,
        [3] = true,
        [4] = true,
        [5] = true,
        [6] = true,
        [7] = true,
        [8] = true,
        [9] = true,
        [10] = true,
        [11] = true,
        [12] = true,
      },
    },
  },
};

MDT.dungeonEnemies[dungeonIndex] = {
  [1] = {
    ["name"] = "Sandswept Marksman",
    ["id"] = 134600,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 0.7,
    ["displayId"] = 83780,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [205276] = {
      },
      [209859] = {
      },
      [264574] = {
      },
      [272670] = {
      },
      [273563] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 572.53017282563,
        ["y"] = -528.18912776395,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [2] = {
        ["x"] = 549.26448522628,
        ["y"] = -490.03659780617,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
          [2] = true,
        },
      },
      [3] = {
        ["x"] = 542.12497358588,
        ["y"] = -466.65685014658,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 550.54600091687,
        ["y"] = -466.9200171325,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [5] = {
        ["x"] = 591.12941455194,
        ["y"] = -470.84706986978,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 598.29856403428,
        ["y"] = -470.67461408373,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [7] = {
        ["x"] = 561.68892716214,
        ["y"] = -405.11391008142,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [8] = {
        ["x"] = 536.80665580666,
        ["y"] = -421.55430209589,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 523.08648568368,
        ["y"] = -445.92777365027,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 507.6319540809,
        ["y"] = -445.01867850712,
        ["sublevel"] = 1,
      },
      [11] = {
        ["x"] = 499.26831621736,
        ["y"] = -433.38232465774,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 516.17742813921,
        ["y"] = -437.56414358951,
        ["sublevel"] = 1,
      },
      [13] = {
        ["x"] = 423.08850337895,
        ["y"] = -427.85757801962,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [14] = {
        ["x"] = 368.63710846851,
        ["y"] = -429.05391701604,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [15] = {
        ["x"] = 373.85449477899,
        ["y"] = -431.44522529463,
        ["g"] = 11,
        ["sublevel"] = 1,
      },
      [16] = {
        ["x"] = 376.47994985287,
        ["y"] = -415.2710833918,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [17] = {
        ["x"] = 416.65617357243,
        ["y"] = -429.0142699785,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [2] = {
    ["name"] = "Krolusk Pup",
    ["id"] = 134616,
    ["count"] = 2,
    ["health"] = 461097,
    ["scale"] = 0.5,
    ["displayId"] = 83787,
    ["creatureType"] = "Beast",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [264587] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 574.77155215258,
        ["y"] = -524.05118645378,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [2] = {
        ["x"] = 547.20969905025,
        ["y"] = -495.79001555973,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 543.51295069242,
        ["y"] = -470.71063713044,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 548.08741461936,
        ["y"] = -471.13617003878,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [5] = {
        ["x"] = 590.64413741324,
        ["y"] = -475.4775923815,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 599.21415485134,
        ["y"] = -475.64723066815,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 557.2873973416,
        ["y"] = -406.90890727231,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [8] = {
        ["x"] = 540.78794758416,
        ["y"] = -426.74962707104,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
      [9] = {
        ["x"] = 410.45431669333,
        ["y"] = -444.48367665192,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [10] = {
        ["x"] = 407.1850590401,
        ["y"] = -447.56060755459,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [11] = {
        ["x"] = 395.45429917515,
        ["y"] = -451.98367715805,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [12] = {
        ["x"] = 383.7235290585,
        ["y"] = -445.06057980333,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
    },
  },
  [3] = {
    ["name"] = "Charged Dust Devil",
    ["id"] = 134990,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 0.7,
    ["displayId"] = 84024,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [265968] = {
      },
      [268703] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 567.18536341325,
        ["y"] = -524.22360252483,
        ["g"] = 1,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 594.374160519,
        ["y"] = -467.16832210443,
        ["g"] = 4,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 608.87190032375,
        ["y"] = -426.69542437043,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [4] = {
        ["x"] = 579.14517143018,
        ["y"] = -405.14748959407,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 547.36988195338,
        ["y"] = -425.19000026833,
        ["g"] = 7,
        ["sublevel"] = 1,
      },
    },
  },
  [4] = {
    ["name"] = "Sandfury Stonefist",
    ["id"] = 134991,
    ["count"] = 6,
    ["health"] = 1229592,
    ["scale"] = 1,
    ["displayId"] = 84207,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [265966] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 542.278186361,
        ["y"] = -490.58453843492,
        ["g"] = 2,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 595.05879037697,
        ["y"] = -493.14818953885,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [3] = {
        ["x"] = 604.9349739225,
        ["y"] = -429.92526402194,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 573.67755072539,
        ["y"] = -410.01221158938,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [5] = {
        ["x"] = 565.61441693134,
        ["y"] = -410.43851292774,
        ["g"] = 6,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 571.22805903506,
        ["y"] = -475.87107363345,
        ["sublevel"] = 1,
        ["teeming"] = true,
        ["patrol"] = {
          [1] = {
            ["x"] = 571.22805903506,
            ["y"] = -475.87107363345,
          },
          [2] = {
            ["x"] = 587.35856364467,
            ["y"] = -473.04456022786,
          },
          [3] = {
            ["x"] = 571.02945353128,
            ["y"] = -475.57620630156,
          },
          [4] = {
            ["x"] = 554.06743461562,
            ["y"] = -472.53823535897,
          },
        },
      },
      [7] = {
        ["x"] = 544.32854905754,
        ["y"] = -416.09513335334,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [5] = {
    ["name"] = "Shrouded Fang",
    ["id"] = 134602,
    ["count"] = 4,
    ["health"] = 614796,
    ["scale"] = 0.7,
    ["stealth"] = true,
    ["displayId"] = 83782,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [258908] = {
      },
      [268993] = {
      },
      [271055] = {
      },
      [271057] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 540.20844337258,
        ["y"] = -476.46241875656,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 551.49414635937,
        ["y"] = -477.17669545204,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 598.48937847837,
        ["y"] = -429.6700728219,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 582.05872191217,
        ["y"] = -423.47230997361,
        ["g"] = 21,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 573.25871329869,
            ["y"] = -421.87230801738,
          },
          [2] = {
            ["x"] = 556.89509435556,
            ["y"] = -422.05411300099,
          },
          [3] = {
            ["x"] = 541.80417272,
            ["y"] = -423.3268571253,
          },
          [4] = {
            ["x"] = 534.71327898076,
            ["y"] = -437.50865240656,
          },
          [5] = {
            ["x"] = 538.53146453695,
            ["y"] = -455.50865665238,
          },
          [6] = {
            ["x"] = 545.98599945456,
            ["y"] = -467.32684669652,
          },
          [7] = {
            ["x"] = 538.53146453695,
            ["y"] = -455.50865665238,
          },
          [8] = {
            ["x"] = 534.71327898076,
            ["y"] = -437.50865240656,
          },
          [9] = {
            ["x"] = 541.80417272,
            ["y"] = -423.3268571253,
          },
          [10] = {
            ["x"] = 556.89509435556,
            ["y"] = -422.05411300099,
          },
          [11] = {
            ["x"] = 573.25871329869,
            ["y"] = -421.87230801738,
          },
          [12] = {
            ["x"] = 585.98596727482,
            ["y"] = -424.96321121682,
          },
          [13] = {
            ["x"] = 601.25874071073,
            ["y"] = -429.32682732942,
          },
          [14] = {
            ["x"] = 605.98598239611,
            ["y"] = -442.59956648148,
          },
          [15] = {
            ["x"] = 603.98597152064,
            ["y"] = -455.69046943877,
          },
          [16] = {
            ["x"] = 597.98600131652,
            ["y"] = -467.69046446653,
          },
          [17] = {
            ["x"] = 603.98597152064,
            ["y"] = -455.69046943877,
          },
          [18] = {
            ["x"] = 605.98598239611,
            ["y"] = -442.59956648148,
          },
          [19] = {
            ["x"] = 601.25874071073,
            ["y"] = -429.32682732942,
          },
          [20] = {
            ["x"] = 585.98596727482,
            ["y"] = -424.96321121682,
          },
        },
      },
      [5] = {
        ["x"] = 600.29356528515,
        ["y"] = -424.41222001536,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [6] = {
        ["x"] = 555.85038074849,
        ["y"] = -420.82479254533,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [7] = {
        ["x"] = 560.45564771623,
        ["y"] = -417.66689035594,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["teeming"] = true,
        ["patrol"] = {
          [1] = {
            ["x"] = 560.45564771623,
            ["y"] = -417.66689035594,
          },
          [2] = {
            ["x"] = 571.23306320364,
            ["y"] = -416.16118126167,
          },
          [3] = {
            ["x"] = 584.52073220884,
            ["y"] = -418.3529555343,
          },
          [4] = {
            ["x"] = 591.78100726731,
            ["y"] = -425.75021868935,
          },
          [5] = {
            ["x"] = 595.34265074824,
            ["y"] = -439.72279878346,
          },
          [6] = {
            ["x"] = 593.69880534674,
            ["y"] = -455.06527160114,
          },
          [7] = {
            ["x"] = 583.82694807423,
            ["y"] = -465.1933458048,
          },
          [8] = {
            ["x"] = 561.63517036669,
            ["y"] = -464.23444088627,
          },
          [9] = {
            ["x"] = 546.97763215317,
            ["y"] = -449.028962044,
          },
          [10] = {
            ["x"] = 550.81325182729,
            ["y"] = -430.80979210717,
          },
        },
      },
      [8] = {
        ["x"] = 396.13866323521,
        ["y"] = -428.06669752945,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["teeming"] = true,
        ["patrol"] = {
        },
      },
      [9] = {
        ["x"] = 396.13866323521,
        ["y"] = -432.14832319228,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["teeming"] = true,
        ["patrol"] = {
          [1] = {
            ["x"] = 396.13866323521,
            ["y"] = -432.14832319228,
          },
          [2] = {
            ["x"] = 382.05135903833,
            ["y"] = -423.32461138601,
          },
          [3] = {
            ["x"] = 372.5164673732,
            ["y"] = -405.41762434723,
          },
          [4] = {
            ["x"] = 367.40019961971,
            ["y"] = -382.39437953529,
          },
          [5] = {
            ["x"] = 365.53972954543,
            ["y"] = -355.41763332042,
          },
          [6] = {
            ["x"] = 365.53972954543,
            ["y"] = -330.3013372192,
          },
          [7] = {
            ["x"] = 365.53972954543,
            ["y"] = -355.18509202668,
          },
          [8] = {
            ["x"] = 367.40019961971,
            ["y"] = -382.16181828093,
          },
          [9] = {
            ["x"] = 372.28392607946,
            ["y"] = -404.25484801636,
          },
          [10] = {
            ["x"] = 382.05135903833,
            ["y"] = -423.32461138601,
          },
        },
      },
    },
  },
  [6] = {
    ["name"] = "Krolusk Hatchling",
    ["id"] = 134617,
    ["count"] = 1,
    ["health"] = 5631,
    ["scale"] = 0.3,
    ["neutral"] = true,
    ["displayId"] = 83790,
    ["creatureType"] = "Beast",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 543.39359585109,
        ["y"] = -475.35143025521,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 547.60113497119,
        ["y"] = -475.247861995,
        ["g"] = 3,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 600.18337372702,
        ["y"] = -432.92493028906,
        ["g"] = 5,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 577.66602057478,
        ["y"] = -424.25911598505,
        ["g"] = 21,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 602.1228471068,
        ["y"] = -420.75368253995,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [6] = {
        ["x"] = 553.08722056785,
        ["y"] = -416.87741763198,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [7] = {
        ["x"] = 557.82406820516,
        ["y"] = -413.85111869919,
        ["g"] = 23,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [8] = {
        ["x"] = 399.68676338161,
        ["y"] = -428.25024637399,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [9] = {
        ["x"] = 399.9253489813,
        ["y"] = -432.40939774585,
        ["g"] = 24,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [7] = {
    ["name"] = "Aspix",
    ["id"] = 133944,
    ["count"] = 0,
    ["health"] = 3073980,
    ["scale"] = 1,
    ["displayId"] = 83552,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["isBoss"] = true,
    ["encounterID"] = 2142,
    ["instanceID"] = 1030,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [263246] = {
      },
      [263257] = {
      },
      [263318] = {
      },
      [263371] = {
      },
      [263775] = {
      },
      [263778] = {
      },
      [268851] = {
      },
      [273411] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 581.57444094023,
        ["y"] = -450.45248833995,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
    },
  },
  [8] = {
    ["name"] = "Adderis",
    ["id"] = 133379,
    ["count"] = 0,
    ["health"] = 3073980,
    ["scale"] = 1,
    ["displayId"] = 83550,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["isBoss"] = true,
    ["encounterID"] = 2142,
    ["instanceID"] = 1030,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [263234] = {
      },
      [263246] = {
      },
      [263365] = {
      },
      [263424] = {
      },
      [263425] = {
      },
      [263573] = {
      },
      [268851] = {
      },
      [274342] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 562.73723882495,
        ["y"] = -450.21992708558,
        ["g"] = 8,
        ["sublevel"] = 1,
      },
    },
  },
  [9] = {
    ["name"] = "Scaled Krolusk Rider",
    ["id"] = 134629,
    ["count"] = 6,
    ["health"] = 1229592,
    ["scale"] = 1.2,
    ["displayId"] = 84761,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [255741] = {
      },
      [262046] = {
      },
      [272657] = {
      },
      [272658] = {
      },
      [272659] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 509.48937685565,
        ["y"] = -404.72262455503,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 509.48937685565,
            ["y"] = -404.72262455503,
          },
          [2] = {
            ["x"] = 521.41244696525,
            ["y"] = -406.26109000637,
          },
          [3] = {
            ["x"] = 534.29708480403,
            ["y"] = -409.7226331454,
          },
          [4] = {
            ["x"] = 537.95092993477,
            ["y"] = -412.99186603979,
          },
          [5] = {
            ["x"] = 534.29708480403,
            ["y"] = -409.7226331454,
          },
          [6] = {
            ["x"] = 521.41244696525,
            ["y"] = -406.26109000637,
          },
          [7] = {
            ["x"] = 509.48937685565,
            ["y"] = -404.72262455503,
          },
          [8] = {
            ["x"] = 497.89989056639,
            ["y"] = -405.74839149087,
          },
          [9] = {
            ["x"] = 475.97680327604,
            ["y"] = -407.86377942322,
          },
          [10] = {
            ["x"] = 443.09221360527,
            ["y"] = -407.28686519516,
          },
          [11] = {
            ["x"] = 475.97680327604,
            ["y"] = -407.86377942322,
          },
          [12] = {
            ["x"] = 497.89989056639,
            ["y"] = -405.74839149087,
          },
        },
        ["infested"] = {
          [3] = true,
        },
      },
      [2] = {
        ["x"] = 414.00541612366,
        ["y"] = -422.58718596389,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 366.69145708182,
        ["y"] = -367.33889685737,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 366.69145708182,
            ["y"] = -367.33889685737,
          },
          [2] = {
            ["x"] = 368.38193761327,
            ["y"] = -386.14863103116,
          },
          [3] = {
            ["x"] = 370.52479287961,
            ["y"] = -400.79151622289,
          },
          [4] = {
            ["x"] = 373.73909110602,
            ["y"] = -410.4343495945,
          },
          [5] = {
            ["x"] = 370.52479287961,
            ["y"] = -400.79151622289,
          },
          [6] = {
            ["x"] = 368.38193761327,
            ["y"] = -386.14863103116,
          },
          [7] = {
            ["x"] = 366.69145708182,
            ["y"] = -367.33889685737,
          },
          [8] = {
            ["x"] = 365.88542324685,
            ["y"] = -349.25099603533,
          },
          [9] = {
            ["x"] = 365.4772545498,
            ["y"] = -337.82243016624,
          },
          [10] = {
            ["x"] = 365.88542324685,
            ["y"] = -349.25099603533,
          },
        },
        ["infested"] = {
          [3] = true,
        },
      },
      [4] = {
        ["x"] = 353.4909412989,
        ["y"] = -279.49008302814,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 353.4909412989,
            ["y"] = -279.49008302814,
          },
          [2] = {
            ["x"] = 348.8034466511,
            ["y"] = -285.8963234783,
          },
          [3] = {
            ["x"] = 348.33467706975,
            ["y"] = -293.70882573385,
          },
          [4] = {
            ["x"] = 350.52217904241,
            ["y"] = -303.55257119976,
          },
          [5] = {
            ["x"] = 355.05343504449,
            ["y"] = -311.36507345531,
          },
          [6] = {
            ["x"] = 363.95968158084,
            ["y"] = -312.61506979289,
          },
          [7] = {
            ["x"] = 370.99094366912,
            ["y"] = -310.58382658252,
          },
          [8] = {
            ["x"] = 376.77218930325,
            ["y"] = -304.80257424286,
          },
          [9] = {
            ["x"] = 380.5221850215,
            ["y"] = -295.89632770651,
          },
          [10] = {
            ["x"] = 381.14716642648,
            ["y"] = -289.64632590207,
          },
          [11] = {
            ["x"] = 379.11594333268,
            ["y"] = -281.52133294403,
          },
          [12] = {
            ["x"] = 370.67842614454,
            ["y"] = -274.95882032054,
          },
          [13] = {
            ["x"] = 362.08468372172,
            ["y"] = -274.33382550451,
          },
        },
        ["infested"] = {
          [3] = true,
        },
      },
      [5] = {
        ["x"] = 379.58468609194,
        ["y"] = -279.33383097137,
        ["sublevel"] = 1,
        ["patrol"] = {
          [1] = {
            ["x"] = 379.58468609194,
            ["y"] = -279.33383097137,
          },
          [2] = {
            ["x"] = 381.14716642648,
            ["y"] = -289.64632590207,
          },
          [3] = {
            ["x"] = 376.77218930325,
            ["y"] = -304.80257424286,
          },
          [4] = {
            ["x"] = 370.99094366912,
            ["y"] = -310.58382658252,
          },
          [5] = {
            ["x"] = 352.86593307183,
            ["y"] = -309.17757818817,
          },
          [6] = {
            ["x"] = 344.42844270578,
            ["y"] = -293.70882573385,
          },
          [7] = {
            ["x"] = 346.6159312674,
            ["y"] = -278.86508150659,
          },
          [8] = {
            ["x"] = 352.24095166685,
            ["y"] = -271.83381941832,
          },
          [9] = {
            ["x"] = 364.74091504259,
            ["y"] = -270.74008184303,
          },
          [10] = {
            ["x"] = 372.08469465545,
            ["y"] = -272.92757040465,
          },
        },
      },
      [6] = {
        ["x"] = 365.27366340338,
        ["y"] = -316.31154919386,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [10] = {
    ["name"] = "Venomous Ophidian",
    ["id"] = 135562,
    ["count"] = 2,
    ["health"] = 307398,
    ["scale"] = 0.7,
    ["displayId"] = 78250,
    ["creatureType"] = "Beast",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [267027] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 419.78027987518,
        ["y"] = -415.37622978742,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 378.89425721837,
        ["y"] = -410.1206870107,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
    },
  },
  [11] = {
    ["name"] = "Sand-Crusted Striker",
    ["id"] = 135846,
    ["count"] = 2,
    ["health"] = 307398,
    ["scale"] = 0.7,
    ["displayId"] = 78247,
    ["creatureType"] = "Beast",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [260792] = {
      },
      [268705] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 427.03588958581,
        ["y"] = -423.64704741387,
        ["g"] = 9,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 370.40908753551,
        ["y"] = -413.48850804385,
        ["g"] = 12,
        ["sublevel"] = 1,
      },
    },
  },
  [12] = {
    ["name"] = "Scaled Krolusk Tamer",
    ["id"] = 139422,
    ["count"] = 6,
    ["health"] = 1229592,
    ["scale"] = 1,
    ["displayId"] = 84761,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [255741] = {
      },
      [272658] = {
      },
      [272659] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 397.07469027474,
        ["y"] = -439.18482875882,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
    },
  },
  [13] = {
    ["name"] = "Mature Krolusk",
    ["id"] = 134686,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 75595,
    ["creatureType"] = "Beast",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Fear"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [272654] = {
      },
      [272655] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 401.63107652534,
        ["y"] = -450.15678263626,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 389.91679648589,
        ["y"] = -448.72821698379,
        ["g"] = 10,
        ["sublevel"] = 1,
      },
    },
  },
  [14] = {
    ["name"] = "Faithless Tender",
    ["id"] = 134364,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 86510,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Polymorph"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [267237] = {
      },
      [269896] = {
      },
      [272699] = {
      },
      [272700] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 362.21458175219,
        ["y"] = -322.64392902958,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [2] = {
        ["x"] = 341.27909250506,
        ["y"] = -301.14035103586,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["infested"] = {
        },
      },
      [3] = {
        ["x"] = 362.98782142309,
        ["y"] = -297.21088602385,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 370.12270403287,
        ["y"] = -303.02695365915,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 356.17491916742,
        ["y"] = -302.66263894818,
        ["g"] = 14,
        ["sublevel"] = 1,
      },
      [6] = {
        ["x"] = 390.24491717596,
        ["y"] = -289.8818996277,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
    },
  },
  [15] = {
    ["name"] = "Crazed Incubator",
    ["id"] = 139425,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 83444,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [272696] = {
      },
      [272698] = {
      },
      [272699] = {
      },
      [273995] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 369.12367050782,
        ["y"] = -322.46211624318,
        ["g"] = 13,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 383.10208672405,
        ["y"] = -303.81045885889,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [3] = {
        ["x"] = 342.03062770264,
        ["y"] = -278.45331266238,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [4] = {
        ["x"] = 357.74494052754,
        ["y"] = -263.81047345138,
        ["g"] = 27,
        ["sublevel"] = 1,
      },
    },
  },
  [16] = {
    ["name"] = "Merektha",
    ["id"] = 133384,
    ["count"] = 0,
    ["health"] = 3535073,
    ["scale"] = 1,
    ["displayId"] = 88585,
    ["creatureType"] = "Beast",
    ["level"] = 120,
    ["isBoss"] = true,
    ["encounterID"] = 2143,
    ["instanceID"] = 1030,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [263912] = {
      },
      [263914] = {
      },
      [263927] = {
      },
      [269970] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 362.43056997391,
        ["y"] = -286.33875865449,
        ["sublevel"] = 1,
      },
    },
  },
  [17] = {
    ["name"] = "Agitated Nimbus",
    ["id"] = 136076,
    ["count"] = 6,
    ["health"] = 1229592,
    ["scale"] = 1,
    ["displayId"] = 65631,
    ["creatureType"] = "Elemental",
    ["level"] = 120,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [265911] = {
      },
      [265912] = {
      },
      [269129] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 411.8116666932,
        ["y"] = -272.70194050979,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 432.6358610699,
        ["y"] = -262.11403453012,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
      [3] = {
        ["x"] = 435.45630502128,
        ["y"] = -184.42012195145,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [4] = {
        ["x"] = 414.36406426897,
        ["y"] = -194.48929252445,
        ["sublevel"] = 1,
        ["infested"] = {
          [3] = true,
        },
      },
    },
  },
  [18] = {
    ["name"] = "Imbued Stormcaller",
    ["id"] = 134599,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 83779,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Imprison"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [269116] = {
      },
      [269129] = {
      },
      [272820] = {
      },
      [272821] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 420.52824551779,
        ["y"] = -259.87371151842,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [2] = {
        ["x"] = 427.26153508477,
        ["y"] = -189.63205811251,
        ["g"] = 16,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 421.17459060882,
        ["y"] = -201.37119596995,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
    },
  },
  [19] = {
    ["name"] = "Static-charged Dervish",
    ["id"] = 134691,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 81655,
    ["creatureType"] = "Elemental",
    ["level"] = 120,
    ["reaping"] = 148716,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [264763] = {
      },
      [264765] = {
      },
      [267278] = {
      },
      [277242] = {
      },
      [277564] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 396.48372747004,
        ["y"] = -186.70425843201,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [2] = {
        ["x"] = 402.65522106129,
        ["y"] = -180.70287498077,
        ["g"] = 17,
        ["sublevel"] = 1,
      },
      [3] = {
        ["x"] = 369.83144489125,
        ["y"] = -164.62836565566,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["infested"] = {
          [1] = true,
        },
      },
      [4] = {
        ["x"] = 354.47427971971,
        ["y"] = -183.91407837961,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [5] = {
        ["x"] = 351.26001214712,
        ["y"] = -188.91409954591,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["infested"] = {
          [2] = true,
        },
      },
      [6] = {
        ["x"] = 347.68853561352,
        ["y"] = -195.69978234446,
        ["g"] = 18,
        ["sublevel"] = 1,
      },
      [7] = {
        ["x"] = 395.19109927504,
        ["y"] = -175.94416730275,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [8] = {
        ["x"] = 392.51068731342,
        ["y"] = -184.91322822788,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
      [9] = {
        ["x"] = 391.78905495553,
        ["y"] = -193.98539213059,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["teeming"] = true,
      },
    },
  },
  [20] = {
    ["name"] = "Galvazzt",
    ["id"] = 133389,
    ["count"] = 0,
    ["health"] = 5379459,
    ["scale"] = 1,
    ["displayId"] = 81654,
    ["creatureType"] = "Elemental",
    ["level"] = 120,
    ["isBoss"] = true,
    ["encounterID"] = 2144,
    ["instanceID"] = 1030,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [205276] = {
      },
      [265974] = {
      },
      [266511] = {
      },
      [266512] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 375.06072496568,
        ["y"] = -184.73395484974,
        ["sublevel"] = 1,
      },
    },
  },
  [21] = {
    ["name"] = "Eye of Sethraliss",
    ["id"] = 68819,
    ["count"] = 12,
    ["health"] = 0,
    ["scale"] = 2,
    ["displayId"] = 46941,
    ["creatureType"] = "Unknown",
    ["level"] = 0,
    ["clones"] = {
      [1] = {
        ["x"] = 452.57081749994,
        ["y"] = -322.82680203571,
        ["g"] = 22,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 430.51201461351,
        ["y"] = -336.65032692598,
        ["g"] = 22,
        ["sublevel"] = 2,
      },
    },
  },
  [22] = {
    ["name"] = "Hoodoo Hexer",
    ["id"] = 136250,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 84676,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268013] = {
      },
      [274642] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 387.36842937633,
        ["y"] = -240.91180707509,
        ["g"] = 19,
        ["sublevel"] = 2,
        ["infested"] = {
          [3] = true,
        },
      },
      [2] = {
        ["x"] = 355.83310826627,
        ["y"] = -190.31216825437,
        ["g"] = 20,
        ["sublevel"] = 2,
      },
      [3] = {
        ["x"] = 309.19331769174,
        ["y"] = -153.24194376156,
        ["sublevel"] = 2,
      },
      [4] = {
        ["x"] = 340.4976542135,
        ["y"] = -135.41584276932,
        ["sublevel"] = 2,
      },
      [5] = {
        ["x"] = 323.10636029226,
        ["y"] = -105.85060391964,
        ["sublevel"] = 2,
      },
      [6] = {
        ["x"] = 291.80200511165,
        ["y"] = -123.67670491188,
        ["sublevel"] = 2,
      },
    },
  },
  [23] = {
    ["name"] = "Plague Doctor",
    ["id"] = 139949,
    ["count"] = 4,
    ["health"] = 768495,
    ["scale"] = 1,
    ["displayId"] = 86210,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148893,
    ["characteristics"] = {
      ["Taunt"] = true,
      ["Incapacitate"] = true,
      ["Silence"] = true,
      ["Root"] = true,
      ["Fear"] = true,
      ["Disorient"] = true,
      ["Sap"] = true,
      ["Stun"] = true,
      ["Slow"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268008] = {
      },
      [268061] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 345.51052737487,
        ["y"] = -187.73148842237,
        ["g"] = 20,
        ["sublevel"] = 2,
        ["infested"] = {
          [2] = true,
        },
      },
    },
  },
  [24] = {
    ["name"] = "Avatar of Sethraliss",
    ["id"] = 133392,
    ["count"] = 0,
    ["health"] = 1536990,
    ["scale"] = 1,
    ["displayId"] = 83203,
    ["creatureType"] = "Undead",
    ["level"] = 120,
    ["isBoss"] = true,
    ["encounterID"] = 2145,
    ["instanceID"] = 1030,
    ["spells"] = {
      [186439] = {
      },
      [267944] = {
      },
      [269670] = {
      },
      [279000] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 316.9357950046,
        ["y"] = -129.96434741109,
        ["sublevel"] = 2,
      },
    },
  },
  [25] = {
    ["name"] = "Spark Channeler",
    ["id"] = 139110,
    ["count"] = 11,
    ["health"] = 1229590,
    ["scale"] = 1.4,
    ["displayId"] = 83553,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [224729] = {
      },
      [267483] = {
      },
      [272820] = {
      },
      [272821] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 525.27885800853,
        ["y"] = -450.23463841861,
        ["sublevel"] = 2,
      },
    },
  },
  [26] = {
    ["name"] = "Emissary of the Tides",
    ["id"] = 155434,
    ["count"] = 4,
    ["health"] = 614795,
    ["ignoreFortified"] = true,
    ["scale"] = 0.8,
    ["displayId"] = 39391,
    ["iconTexture"] = 132315,
    ["creatureType"] = "Humanoid",
    ["level"] = 120,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [302415] = {
      },
      [302417] = {
      },
      [302418] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 569.93610040954,
        ["y"] = -415.33082503765,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 362.37497111024,
        ["y"] = -305.14742213294,
        ["g"] = 14,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [3] = {
        ["x"] = 403.02881176632,
        ["y"] = -187.23729928348,
        ["g"] = 17,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [4] = {
        ["x"] = 380.09059932894,
        ["y"] = -235.31930445103,
        ["g"] = 19,
        ["sublevel"] = 2,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [5] = {
        ["x"] = 568.98468753282,
        ["y"] = -531.56843781868,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [6] = {
        ["x"] = 542.42825578647,
        ["y"] = -421.55981714633,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [3] = true,
          [5] = true,
          [6] = true,
          [8] = true,
          [9] = true,
          [11] = true,
          [12] = true,
        },
      },
      [7] = {
        ["x"] = 589.23608510326,
        ["y"] = -465.86111791115,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [8] = {
        ["x"] = 417.52673699517,
        ["y"] = -429.05687721686,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [9] = {
        ["x"] = 364.52438861745,
        ["y"] = -315.73342681987,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [3] = true,
          [5] = true,
          [6] = true,
          [8] = true,
          [9] = true,
          [11] = true,
          [12] = true,
        },
      },
      [10] = {
        ["x"] = 333.54062155291,
        ["y"] = -288.20379057289,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [11] = {
        ["x"] = 428.03286390727,
        ["y"] = -254.10869260373,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [12] = {
        ["x"] = 538.12646594995,
        ["y"] = -400.33555844582,
        ["sublevel"] = 2,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [13] = {
        ["x"] = 415.78110073179,
        ["y"] = -421.02451781926,
        ["sublevel"] = 2,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [14] = {
        ["x"] = 347.88990305137,
        ["y"] = -180.22938580085,
        ["g"] = 20,
        ["sublevel"] = 2,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [15] = {
        ["x"] = 396.06812655272,
        ["y"] = -445.57753904133,
        ["g"] = 10,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [16] = {
        ["x"] = 423.04657241381,
        ["y"] = -178.87601330634,
        ["g"] = 16,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
    },
  },
  [27] = {
    ["name"] = "Void-Touched Emissary",
    ["id"] = 155433,
    ["count"] = 4,
    ["health"] = 999042,
    ["ignoreFortified"] = true,
    ["scale"] = 0.8,
    ["stealthDetect"] = true,
    ["displayId"] = 39391,
    ["iconTexture"] = 132886,
    ["creatureType"] = "Humanoid",
    ["level"] = 122,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [302415] = {
      },
      [302419] = {
      },
      [302420] = {
      },
      [302421] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 586.39805557405,
        ["y"] = -472.42530812721,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 555.24890938087,
        ["y"] = -470.95924411443,
        ["g"] = 3,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [3] = {
        ["x"] = 420.89923059913,
        ["y"] = -421.01342738537,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [4] = {
        ["x"] = 366.06323769891,
        ["y"] = -330.02138115252,
        ["g"] = 13,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [5] = {
        ["x"] = 424.51081726786,
        ["y"] = -256.77047519582,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [6] = {
        ["x"] = 439.05695301902,
        ["y"] = -409.45240966935,
        ["g"] = 25,
        ["sublevel"] = 2,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [7] = {
        ["x"] = 464.82386072411,
        ["y"] = -322.435885646,
        ["g"] = 26,
        ["sublevel"] = 2,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [8] = {
        ["x"] = 569.41414720351,
        ["y"] = -403.43220495855,
        ["g"] = 6,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [10] = {
        ["x"] = 593.83284169516,
        ["y"] = -432.80546335449,
        ["g"] = 5,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [11] = {
        ["x"] = 515.30947389357,
        ["y"] = -370.62743644022,
        ["sublevel"] = 2,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
    },
  },
  [28] = {
    ["name"] = "Enchanted Emissary",
    ["id"] = 155432,
    ["count"] = 4,
    ["health"] = 15369884,
    ["ignoreFortified"] = true,
    ["scale"] = 0.8,
    ["displayId"] = 39391,
    ["iconTexture"] = 135735,
    ["creatureType"] = "Humanoid",
    ["level"] = 121,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [290027] = {
      },
      [302415] = {
      },
      [303632] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 542.43608422125,
        ["y"] = -422.03083296113,
        ["g"] = 7,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 368.69570389102,
        ["y"] = -433.97829101832,
        ["g"] = 11,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [4] = true,
          [7] = true,
          [10] = true,
        },
      },
      [3] = {
        ["x"] = 546.05933930309,
        ["y"] = -484.67290969617,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [4] = {
        ["x"] = 380.02055527924,
        ["y"] = -404.47531792081,
        ["g"] = 12,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [5] = {
        ["x"] = 366.59074807643,
        ["y"] = -173.11407744938,
        ["g"] = 28,
        ["sublevel"] = 1,
        ["week"] = {
          [2] = true,
          [5] = true,
          [8] = true,
          [11] = true,
        },
      },
      [6] = {
        ["x"] = 571.4257379041,
        ["y"] = -520.83117016535,
        ["g"] = 1,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [7] = {
        ["x"] = 546.15052691778,
        ["y"] = -484.90723021744,
        ["g"] = 2,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [8] = {
        ["x"] = 595.08444139468,
        ["y"] = -474.92289513429,
        ["g"] = 4,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [9] = {
        ["x"] = 416.9538120906,
        ["y"] = -429.7961195783,
        ["g"] = 9,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [10] = {
        ["x"] = 333.53939058319,
        ["y"] = -287.8650903163,
        ["g"] = 27,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [11] = {
        ["x"] = 430.32472928839,
        ["y"] = -253.66139575811,
        ["g"] = 15,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [12] = {
        ["x"] = 358.88203226665,
        ["y"] = -194.77589861861,
        ["g"] = 18,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [13] = {
        ["x"] = 440.52071324487,
        ["y"] = -417.01358392311,
        ["sublevel"] = 2,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
      [14] = {
        ["x"] = 346.59114224414,
        ["y"] = -179.76895124132,
        ["g"] = 20,
        ["sublevel"] = 2,
        ["week"] = {
          [3] = true,
          [6] = true,
          [9] = true,
          [12] = true,
        },
      },
    },
  },
  [29] = {
    ["name"] = "Heart Guardian",
    ["id"] = 139946,
    ["count"] = 6,
    ["teemingCount"] = 4,
    ["health"] = 1229592,
    ["scale"] = 1,
    ["neutral"] = true,
    ["displayId"] = 84761,
    ["creatureType"] = "Elemental",
    ["level"] = 120,
    ["reaping"] = 148894,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [209859] = {
      },
      [268007] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 386.87010905427,
        ["y"] = -231.26897299107,
        ["g"] = 19,
        ["sublevel"] = 2,
      },
      [2] = {
        ["x"] = 355.33043548026,
        ["y"] = -180.3496261495,
        ["g"] = 20,
        ["sublevel"] = 2,
      },
    },
  },
  [30] = {
    ["name"] = "Samh'rek, Beckoner of Chaos",
    ["id"] = 161243,
    ["count"] = 4,
    ["teemingCount"] = 6,
    ["health"] = 2151786,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 90742,
    ["creatureType"] = "Aberration",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314397] = {
      },
      [314477] = {
      },
      [314483] = {
      },
      [314531] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 418.6264141093,
        ["y"] = -175.29540486083,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 440.64987570173,
        ["y"] = -415.6530125943,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [31] = {
    ["name"] = "Urg'roth, Breaker of Heroes",
    ["id"] = 161124,
    ["count"] = 4,
    ["teemingCount"] = 6,
    ["health"] = 2151786,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 89415,
    ["creatureType"] = "Aberration",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314308] = {
      },
      [314309] = {
      },
      [314387] = {
      },
      [314397] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 440.65291175934,
        ["y"] = -415.09391872482,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [5] = true,
          [6] = true,
          [9] = true,
          [10] = true,
        },
      },
      [2] = {
        ["x"] = 418.8406538725,
        ["y"] = -176.22479068563,
        ["sublevel"] = 1,
        ["week"] = {
          [3] = true,
          [4] = true,
          [7] = true,
          [8] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [32] = {
    ["name"] = "Voidweaver Mal'thir",
    ["id"] = 161241,
    ["count"] = 4,
    ["teemingCount"] = 6,
    ["health"] = 2151786,
    ["scale"] = 2,
    ["stealthDetect"] = true,
    ["displayId"] = 91910,
    ["creatureType"] = "Beast",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314397] = {
      },
      [314406] = {
      },
      [314411] = {
      },
      [314463] = {
      },
      [314467] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 505.0724361502,
        ["y"] = -417.44934107322,
        ["sublevel"] = 2,
        ["week"] = {
          [1] = true,
          [2] = true,
          [3] = true,
          [4] = true,
          [5] = true,
          [6] = true,
          [7] = true,
          [8] = true,
          [9] = true,
          [10] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
  [33] = {
    ["name"] = "Blood of the Corruptor",
    ["id"] = 161244,
    ["count"] = 4,
    ["teemingCount"] = 6,
    ["health"] = 2151786,
    ["scale"] = 1.2,
    ["stealthDetect"] = true,
    ["displayId"] = 92229,
    ["creatureType"] = "Aberration",
    ["level"] = 122,
    ["corrupted"] = true,
    ["characteristics"] = {
      ["Taunt"] = true,
    },
    ["spells"] = {
      [314397] = {
      },
      [314565] = {
      },
      [314566] = {
      },
      [314592] = {
      },
    },
    ["clones"] = {
      [1] = {
        ["x"] = 320,
        ["y"] = -200,
        ["sublevel"] = 1,
        ["week"] = {
        },
      },
      [2] = {
        ["x"] = 563.79034048432,
        ["y"] = -532.85249514114,
        ["sublevel"] = 1,
        ["week"] = {
          [1] = true,
          [2] = true,
          [3] = true,
          [4] = true,
          [5] = true,
          [6] = true,
          [7] = true,
          [8] = true,
          [9] = true,
          [10] = true,
          [11] = true,
          [12] = true,
        },
      },
    },
  },
};
