if not WeakAuras.IsLibsOK() then return end
---@type string
local AddonName = ...
---@class Private
local Private = select(2, ...)

---@class WeakAuras
local WeakAuras = WeakAuras;
local L = WeakAuras.L;

local encounter_list = ""
local zoneId_list = ""
function Private.InitializeEncounterAndZoneLists()
	local currTier = EJ_GetCurrentTier()
  if encounter_list ~= "" then
    return
  end
	for tier = EJ_GetNumTiers(), EJ_GetNumTiers() do
		EJ_SelectTier(tier)
		local tierName = EJ_GetTierInfo(tier)
		for _, inRaid in ipairs({false, true}) do
			local instance_index = 1
			local instance_id = EJ_GetInstanceByIndex(instance_index, inRaid)
			local title = ("%s %s"):format(tierName , inRaid and L["Raids"] or L["Dungeons"])
			local zones = ""
			while instance_id do
				EJ_SelectInstance(instance_id)
				local instance_name, _, _, _, _, _, dungeonAreaMapID = EJ_GetInstanceInfo(instance_id)
				local ej_index = 1
				local boss, _, _, _, _, _, encounter_id = EJ_GetEncounterInfoByIndex(ej_index, instance_id)

				-- zone ids
				if dungeonAreaMapID and dungeonAreaMapID ~= 0 then
					local mapGroupId = C_Map.GetMapGroupID(dungeonAreaMapID)
					if mapGroupId then -- If there's a group id, only list that one
						zones = ("%s%s: g%d\n"):format(zones, instance_name, mapGroupId)
					else
						zones = ("%s%s: %d\n"):format(zones, instance_name, dungeonAreaMapID)
					end
				end

				-- Encounter ids
				if inRaid then
					while boss do
						if encounter_id then
							if instance_name then
								encounter_list = ("%s|cffffd200%s|r\n"):format(encounter_list, instance_name)
								instance_name = nil -- Only add it once per section
							end
							encounter_list = ("%s%s: %d\n"):format(encounter_list, boss, encounter_id)
						end
						ej_index = ej_index + 1
						boss, _, _, _, _, _, encounter_id = EJ_GetEncounterInfoByIndex(ej_index, instance_id)
					end
					encounter_list = encounter_list .. "\n"
				end
				instance_index = instance_index + 1
				instance_id = EJ_GetInstanceByIndex(instance_index, inRaid)
			end
			if zones ~= "" then
				zoneId_list = ("%s|cffffd200%s|r\n"):format(zoneId_list, title)
				zoneId_list = zoneId_list .. zones.. "\n"
			end
		end
	end
	EJ_SelectTier(currTier) -- restore previously selected tier

  encounter_list = encounter_list:sub(1, -3) .. "\n\n" .. L["Supports multiple entries, separated by commas\n"]
end

function Private.get_encounters_list()
  return encounter_list
end

function Private.get_zoneId_list()
  return zoneId_list
end

Private.talentInfo = {
  ["DEATHKNIGHT"] = {
    {
      135770, -- [1]
      4, -- [2]
      3, -- [3]
      50371, -- [4]
    }, -- [1]
    {
      135067, -- [1]
      1, -- [2]
      3, -- [3]
      49391, -- [4]
    }, -- [2]
    {
      132455, -- [1]
      1, -- [2]
      1, -- [3]
      49483, -- [4]
    }, -- [3]
    {
      237529, -- [1]
      5, -- [2]
      2, -- [3]
      48982, -- [4]
    }, -- [4]
    {
      132284, -- [1]
      2, -- [2]
      2, -- [3]
      49509, -- [4]
    }, -- [5]
    {
      132094, -- [1]
      5, -- [2]
      1, -- [3]
      81164, -- [4]
    }, -- [6]
    {
      136211, -- [1]
      4, -- [2]
      2, -- [3]
      49542, -- [4]
    }, -- [7]
    {
      135277, -- [1]
      7, -- [2]
      2, -- [3]
      49028, -- [4]
    }, -- [8]
    {
      132330, -- [1]
      1, -- [2]
      2, -- [3]
      49501, -- [4]
    }, -- [9]
    {
      136168, -- [1]
      5, -- [2]
      3, -- [3]
      55233, -- [4]
    }, -- [10]
    {
      236310, -- [1]
      3, -- [2]
      4, -- [3]
      53138, -- [4]
    }, -- [11]
    {
      237517, -- [1]
      6, -- [2]
      2, -- [3]
      81138, -- [4]
    }, -- [12]
    {
      135892, -- [1]
      3, -- [2]
      3, -- [3]
      49787, -- [4]
    }, -- [13]
    {
      458717, -- [1]
      3, -- [2]
      2, -- [3]
      49222, -- [4]
    }, -- [14]
    {
      132109, -- [1]
      3, -- [2]
      1, -- [3]
      49628, -- [4]
    }, -- [15]
    {
      458719, -- [1]
      4, -- [2]
      1, -- [3]
      81127, -- [4]
    }, -- [16]
    {
      458735, -- [1]
      2, -- [2]
      3, -- [3]
      81132, -- [4]
    }, -- [17]
    {
      237513, -- [1]
      6, -- [2]
      3, -- [3]
      81136, -- [4]
    }, -- [18]
    {
      458966, -- [1]
      2, -- [2]
      4, -- [3]
      85794, -- [4]
    }, -- [19]
    {
      237515, -- [1]
      2, -- [2]
      1, -- [3]
      94555, -- [4]
    }, -- [20]
    nil, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    {
      136223, -- [1]
      2, -- [2]
      4, -- [3]
      49657, -- [4]
    }, -- [29]
    {
      458718, -- [1]
      4, -- [2]
      2, -- [3]
      51271, -- [4]
    }, -- [30]
    {
      460686, -- [1]
      4, -- [2]
      4, -- [3]
      81328, -- [4]
    }, -- [31]
    {
      135849, -- [1]
      3, -- [2]
      2, -- [3]
      50115, -- [4]
    }, -- [32]
    {
      135833, -- [1]
      7, -- [2]
      2, -- [3]
      49184, -- [4]
    }, -- [33]
    {
      135840, -- [1]
      4, -- [2]
      1, -- [3]
      59057, -- [4]
    }, -- [34]
    {
      135294, -- [1]
      3, -- [2]
      1, -- [3]
      49538, -- [4]
    }, -- [35]
    {
      135152, -- [1]
      5, -- [2]
      2, -- [3]
      49203, -- [4]
    }, -- [36]
    {
      132147, -- [1]
      1, -- [2]
      3, -- [3]
      50138, -- [4]
    }, -- [37]
    {
      135773, -- [1]
      5, -- [2]
      3, -- [3]
      50385, -- [4]
    }, -- [38]
    {
      135728, -- [1]
      1, -- [2]
      1, -- [3]
      91145, -- [4]
    }, -- [39]
    {
      135859, -- [1]
      1, -- [2]
      2, -- [3]
      55062, -- [4]
    }, -- [40]
    {
      135305, -- [1]
      3, -- [2]
      3, -- [3]
      51128, -- [4]
    }, -- [41]
    {
      135609, -- [1]
      2, -- [2]
      1, -- [3]
      51473, -- [4]
    }, -- [42]
    {
      136187, -- [1]
      2, -- [2]
      2, -- [3]
      49039, -- [4]
    }, -- [43]
    {
      252994, -- [1]
      4, -- [2]
      3, -- [3]
      55610, -- [4]
    }, -- [44]
    {
      135864, -- [1]
      5, -- [2]
      1, -- [3]
      50041, -- [4]
    }, -- [45]
    {
      132148, -- [1]
      6, -- [2]
      1, -- [3]
      66192, -- [4]
    }, -- [46]
    {
      135303, -- [1]
      6, -- [2]
      3, -- [3]
      81333, -- [4]
    }, -- [47]
    {
      132264, -- [1]
      2, -- [2]
      3, -- [3]
      51986, -- [4]
    }, -- [48]
    nil, -- [49]
    nil, -- [50]
    nil, -- [51]
    nil, -- [52]
    nil, -- [53]
    nil, -- [54]
    nil, -- [55]
    nil, -- [56]
    {
      136126, -- [1]
      1, -- [2]
      2, -- [3]
      49568, -- [4]
    }, -- [57]
    {
      136207, -- [1]
      1, -- [2]
      3, -- [3]
      81334, -- [4]
    }, -- [58]
    {
      136132, -- [1]
      5, -- [2]
      1, -- [3]
      49194, -- [4]
    }, -- [59]
    {
      458967, -- [1]
      7, -- [2]
      2, -- [3]
      49206, -- [4]
    }, -- [60]
    {
      136120, -- [1]
      4, -- [2]
      2, -- [3]
      49611, -- [4]
    }, -- [61]
    {
      135775, -- [1]
      5, -- [2]
      3, -- [3]
      50392, -- [4]
    }, -- [62]
    {
      237532, -- [1]
      1, -- [2]
      1, -- [3]
      49589, -- [4]
    }, -- [63]
    {
      132095, -- [1]
      6, -- [2]
      2, -- [3]
      51160, -- [4]
    }, -- [64]
    {
      252272, -- [1]
      3, -- [2]
      1, -- [3]
      51462, -- [4]
    }, -- [65]
    {
      135564, -- [1]
      4, -- [2]
      3, -- [3]
      91323, -- [4]
    }, -- [66]
    {
      342913, -- [1]
      5, -- [2]
      4, -- [3]
      63560, -- [4]
    }, -- [67]
    {
      237510, -- [1]
      5, -- [2]
      2, -- [3]
      51052, -- [4]
    }, -- [68]
    {
      136199, -- [1]
      2, -- [2]
      1, -- [3]
      55667, -- [4]
    }, -- [69]
    {
      132102, -- [1]
      2, -- [2]
      2, -- [3]
      81339, -- [4]
    }, -- [70]
    {
      136224, -- [1]
      3, -- [2]
      2, -- [3]
      49016, -- [4]
    }, -- [71]
    {
      136181, -- [1]
      6, -- [2]
      3, -- [3]
      49530, -- [4]
    }, -- [72]
    {
      136144, -- [1]
      2, -- [2]
      4, -- [3]
      49565, -- [4]
    }, -- [73]
    {
      136188, -- [1]
      3, -- [2]
      4, -- [3]
      49572, -- [4]
    }, -- [74]
    {
      136182, -- [1]
      3, -- [2]
      3, -- [3]
      91319, -- [4]
    }, -- [75]
    {
      237561, -- [1]
      4, -- [2]
      1, -- [3]
      96270, -- [4]
    }, -- [76]
    [85] = {
      "DeathKnightBlood", -- [1]
      "DeathKnightFrost", -- [2]
      "DeathKnightUnholy", -- [3]
    },
  },
  ["WARRIOR"] = {
    {
      132090, -- [1]
      2, -- [2]
      3, -- [3]
      12867, -- [4]
    }, -- [1]
    {
      236397, -- [1]
      2, -- [2]
      4, -- [3]
      12963, -- [4]
    }, -- [2]
    {
      132175, -- [1]
      2, -- [2]
      2, -- [3]
      29838, -- [4]
    }, -- [3]
    {
      132306, -- [1]
      3, -- [2]
      2, -- [3]
      12328, -- [4]
    }, -- [4]
    {
      132364, -- [1]
      6, -- [2]
      1, -- [3]
      56611, -- [4]
    }, -- [5]
    {
      132335, -- [1]
      5, -- [2]
      2, -- [3]
      64976, -- [4]
    }, -- [6]
    {
      132346, -- [1]
      5, -- [2]
      4, -- [3]
      29725, -- [4]
    }, -- [7]
    {
      236303, -- [1]
      7, -- [2]
      2, -- [3]
      46924, -- [4]
    }, -- [8]
    {
      132334, -- [1]
      4, -- [2]
      3, -- [3]
      29859, -- [4]
    }, -- [9]
    {
      458970, -- [1]
      1, -- [2]
      3, -- [3]
      80977, -- [4]
    }, -- [10]
    {
      236317, -- [1]
      1, -- [2]
      1, -- [3]
      84572, -- [4]
    }, -- [11]
    {
      236276, -- [1]
      3, -- [2]
      1, -- [3]
      56638, -- [4]
    }, -- [12]
    {
      458973, -- [1]
      5, -- [2]
      1, -- [3]
      84588, -- [4]
    }, -- [13]
    {
      132312, -- [1]
      3, -- [2]
      3, -- [3]
      16494, -- [4]
    }, -- [14]
    {
      133675, -- [1]
      1, -- [2]
      2, -- [3]
      84580, -- [4]
    }, -- [15]
    {
      133542, -- [1]
      6, -- [2]
      3, -- [3]
      85388, -- [4]
    }, -- [16]
    {
      298660, -- [1]
      4, -- [2]
      2, -- [3]
      85730, -- [4]
    }, -- [17]
    {
      136031, -- [1]
      2, -- [2]
      1, -- [3]
      12676, -- [4]
    }, -- [18]
    {
      132316, -- [1]
      3, -- [2]
      4, -- [3]
      12668, -- [4]
    }, -- [19]
    {
      132340, -- [1]
      4, -- [2]
      1, -- [3]
      12330, -- [4]
    }, -- [20]
    nil, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    {
      133074, -- [1]
      1, -- [2]
      2, -- [3]
      85742, -- [4]
    }, -- [29]
    {
      132292, -- [1]
      1, -- [2]
      3, -- [3]
      12852, -- [4]
    }, -- [30]
    {
      136218, -- [1]
      1, -- [2]
      1, -- [3]
      16492, -- [4]
    }, -- [31]
    {
      136224, -- [1]
      3, -- [2]
      3, -- [3]
      13046, -- [4]
    }, -- [32]
    {
      136147, -- [1]
      2, -- [2]
      4, -- [3]
      12323, -- [4]
    }, -- [33]
    {
      136075, -- [1]
      2, -- [2]
      2, -- [3]
      12835, -- [4]
    }, -- [34]
    {
      136146, -- [1]
      3, -- [2]
      2, -- [3]
      12292, -- [4]
    }, -- [35]
    {
      236308, -- [1]
      5, -- [2]
      1, -- [3]
      46910, -- [4]
    }, -- [36]
    {
      132152, -- [1]
      3, -- [2]
      1, -- [3]
      12972, -- [4]
    }, -- [37]
    {
      460959, -- [1]
      5, -- [2]
      3, -- [3]
      12950, -- [4]
    }, -- [38]
    {
      135358, -- [1]
      2, -- [2]
      1, -- [3]
      20503, -- [4]
    }, -- [39]
    {
      460958, -- [1]
      4, -- [2]
      4, -- [3]
      60970, -- [4]
    }, -- [40]
    {
      132352, -- [1]
      4, -- [2]
      3, -- [3]
      29801, -- [4]
    }, -- [41]
    {
      236306, -- [1]
      6, -- [2]
      2, -- [3]
      46915, -- [4]
    }, -- [42]
    {
      236316, -- [1]
      7, -- [2]
      2, -- [3]
      46917, -- [4]
    }, -- [43]
    {
      458974, -- [1]
      7, -- [2]
      3, -- [3]
      81099, -- [4]
    }, -- [44]
    {
      458971, -- [1]
      5, -- [2]
      4, -- [3]
      46909, -- [4]
    }, -- [45]
    {
      458975, -- [1]
      6, -- [2]
      3, -- [3]
      29889, -- [4]
    }, -- [46]
    {
      132215, -- [1]
      4, -- [2]
      2, -- [3]
      85288, -- [4]
    }, -- [47]
    {
      135396, -- [1]
      4, -- [2]
      1, -- [3]
      81914, -- [4]
    }, -- [48]
    {
      132339, -- [1]
      2, -- [2]
      3, -- [3]
      61221, -- [4]
    }, -- [49]
    nil, -- [50]
    nil, -- [51]
    nil, -- [52]
    nil, -- [53]
    nil, -- [54]
    nil, -- [55]
    nil, -- [56]
    {
      236309, -- [1]
      1, -- [2]
      1, -- [3]
      50687, -- [4]
    }, -- [57]
    {
      134952, -- [1]
      2, -- [2]
      1, -- [3]
      12725, -- [4]
    }, -- [58]
    {
      132453, -- [1]
      2, -- [2]
      4, -- [3]
      12958, -- [4]
    }, -- [59]
    {
      132353, -- [1]
      4, -- [2]
      1, -- [3]
      12799, -- [4]
    }, -- [60]
    {
      132359, -- [1]
      2, -- [2]
      2, -- [3]
      84608, -- [4]
    }, -- [61]
    {
      135892, -- [1]
      1, -- [2]
      2, -- [3]
      12762, -- [4]
    }, -- [62]
    {
      132325, -- [1]
      3, -- [2]
      2, -- [3]
      12809, -- [4]
    }, -- [63]
    {
      460957, -- [1]
      1, -- [2]
      3, -- [3]
      84615, -- [4]
    }, -- [64]
    {
      135871, -- [1]
      3, -- [2]
      1, -- [3]
      12975, -- [4]
    }, -- [65]
    {
      134947, -- [1]
      5, -- [2]
      4, -- [3]
      86896, -- [4]
    }, -- [66]
    {
      135291, -- [1]
      4, -- [2]
      3, -- [3]
      20243, -- [4]
    }, -- [67]
    {
      458976, -- [1]
      5, -- [2]
      1, -- [3]
      80980, -- [4]
    }, -- [68]
    {
      236311, -- [1]
      6, -- [2]
      2, -- [3]
      46949, -- [4]
    }, -- [69]
    {
      236318, -- [1]
      5, -- [2]
      2, -- [3]
      50720, -- [4]
    }, -- [70]
    {
      236319, -- [1]
      3, -- [2]
      4, -- [3]
      57499, -- [4]
    }, -- [71]
    {
      236315, -- [1]
      6, -- [2]
      3, -- [3]
      46953, -- [4]
    }, -- [72]
    {
      236312, -- [1]
      7, -- [2]
      2, -- [3]
      46968, -- [4]
    }, -- [73]
    {
      132110, -- [1]
      3, -- [2]
      3, -- [3]
      29594, -- [4]
    }, -- [74]
    {
      236351, -- [1]
      2, -- [2]
      3, -- [3]
      84621, -- [4]
    }, -- [75]
    {
      132342, -- [1]
      4, -- [2]
      4, -- [3]
      80129, -- [4]
    }, -- [76]
    [85] = {
      "WarriorArms", -- [1]
      "WarriorFury", -- [2]
      "WarriorProtection", -- [3]
    },
  },
  ["PALADIN"] = {
    {
      135921, -- [1]
      2, -- [2]
      2, -- [3]
      20235, -- [4]
    }, -- [1]
    {
      135917, -- [1]
      1, -- [2]
      1, -- [3]
      20360, -- [4]
    }, -- [2]
    {
      135903, -- [1]
      3, -- [2]
      1, -- [3]
      85510, -- [4]
    }, -- [3]
    {
      236251, -- [1]
      4, -- [2]
      1, -- [3]
      53557, -- [4]
    }, -- [4]
    {
      135872, -- [1]
      5, -- [2]
      3, -- [3]
      31821, -- [4]
    }, -- [5]
    {
      135876, -- [1]
      6, -- [2]
      3, -- [3]
      31829, -- [4]
    }, -- [6]
    {
      236261, -- [1]
      4, -- [2]
      4, -- [3]
      53551, -- [4]
    }, -- [7]
    {
      236256, -- [1]
      1, -- [2]
      3, -- [3]
      54151, -- [4]
    }, -- [8]
    {
      236254, -- [1]
      3, -- [2]
      3, -- [3]
      53576, -- [4]
    }, -- [9]
    {
      236247, -- [1]
      4, -- [2]
      2, -- [3]
      53563, -- [4]
    }, -- [10]
    {
      236394, -- [1]
      6, -- [2]
      2, -- [3]
      85512, -- [4]
    }, -- [11]
    {
      135895, -- [1]
      3, -- [2]
      2, -- [3]
      31842, -- [4]
    }, -- [12]
    {
      461859, -- [1]
      7, -- [2]
      2, -- [3]
      85222, -- [4]
    }, -- [13]
    {
      461857, -- [1]
      2, -- [2]
      1, -- [3]
      85464, -- [4]
    }, -- [14]
    {
      460953, -- [1]
      4, -- [2]
      3, -- [3]
      85499, -- [4]
    }, -- [15]
    {
      134909, -- [1]
      3, -- [2]
      4, -- [3]
      88821, -- [4]
    }, -- [16]
    {
      460689, -- [1]
      5, -- [2]
      1, -- [3]
      20057, -- [4]
    }, -- [17]
    {
      135920, -- [1]
      2, -- [2]
      3, -- [3]
      20238, -- [4]
    }, -- [18]
    {
      135875, -- [1]
      5, -- [2]
      4, -- [3]
      93417, -- [4]
    }, -- [19]
    {
      460690, -- [1]
      1, -- [2]
      2, -- [3]
      20140, -- [4]
    }, -- [20]
    nil, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    {
      133526, -- [1]
      1, -- [2]
      2, -- [3]
      20225, -- [4]
    }, -- [29]
    {
      135892, -- [1]
      2, -- [2]
      2, -- [3]
      20145, -- [4]
    }, -- [30]
    {
      253400, -- [1]
      5, -- [2]
      4, -- [3]
      70940, -- [4]
    }, -- [31]
    {
      135963, -- [1]
      2, -- [2]
      3, -- [3]
      20488, -- [4]
    }, -- [32]
    {
      236264, -- [1]
      6, -- [2]
      3, -- [3]
      84854, -- [4]
    }, -- [33]
    {
      135926, -- [1]
      3, -- [2]
      1, -- [3]
      84633, -- [4]
    }, -- [34]
    {
      136051, -- [1]
      3, -- [2]
      2, -- [3]
      84629, -- [4]
    }, -- [35]
    {
      135870, -- [1]
      7, -- [2]
      2, -- [3]
      31850, -- [4]
    }, -- [36]
    {
      135880, -- [1]
      5, -- [2]
      2, -- [3]
      20925, -- [4]
    }, -- [37]
    {
      135896, -- [1]
      6, -- [2]
      2, -- [3]
      53710, -- [4]
    }, -- [38]
    {
      236259, -- [1]
      2, -- [2]
      1, -- [3]
      53696, -- [4]
    }, -- [39]
    {
      236253, -- [1]
      3, -- [2]
      3, -- [3]
      53595, -- [4]
    }, -- [40]
    {
      135985, -- [1]
      5, -- [2]
      1, -- [3]
      26016, -- [4]
    }, -- [41]
    {
      133562, -- [1]
      3, -- [2]
      4, -- [3]
      84636, -- [4]
    }, -- [42]
    {
      135882, -- [1]
      4, -- [2]
      1, -- [3]
      20179, -- [4]
    }, -- [43]
    {
      133176, -- [1]
      4, -- [2]
      3, -- [3]
      85043, -- [4]
    }, -- [44]
    {
      236252, -- [1]
      5, -- [2]
      3, -- [3]
      85646, -- [4]
    }, -- [45]
    {
      236265, -- [1]
      4, -- [2]
      2, -- [3]
      53600, -- [4]
    }, -- [46]
    {
      135433, -- [1]
      1, -- [2]
      3, -- [3]
      87164, -- [4]
    }, -- [47]
    {
      135883, -- [1]
      1, -- [2]
      1, -- [3]
      63648, -- [4]
    }, -- [48]
    nil, -- [49]
    nil, -- [50]
    nil, -- [51]
    nil, -- [52]
    nil, -- [53]
    nil, -- [54]
    nil, -- [55]
    nil, -- [56]
    {
      135897, -- [1]
      5, -- [2]
      3, -- [3]
      86172, -- [4]
    }, -- [57]
    {
      132347, -- [1]
      4, -- [2]
      3, -- [3]
      85126, -- [4]
    }, -- [58]
    {
      135904, -- [1]
      1, -- [2]
      1, -- [3]
      25988, -- [4]
    }, -- [59]
    {
      135889, -- [1]
      1, -- [2]
      2, -- [3]
      31868, -- [4]
    }, -- [60]
    {
      236246, -- [1]
      3, -- [2]
      2, -- [3]
      87138, -- [4]
    }, -- [61]
    {
      135942, -- [1]
      5, -- [2]
      2, -- [3]
      20066, -- [4]
    }, -- [62]
    {
      236257, -- [1]
      3, -- [2]
      1, -- [3]
      31876, -- [4]
    }, -- [63]
    {
      236262, -- [1]
      4, -- [2]
      4, -- [3]
      53376, -- [4]
    }, -- [64]
    {
      236260, -- [1]
      6, -- [2]
      2, -- [3]
      53382, -- [4]
    }, -- [65]
    {
      236250, -- [1]
      3, -- [2]
      4, -- [3]
      53385, -- [4]
    }, -- [66]
    {
      236249, -- [1]
      4, -- [2]
      1, -- [3]
      85285, -- [4]
    }, -- [67]
    {
      236248, -- [1]
      6, -- [2]
      3, -- [3]
      85795, -- [4]
    }, -- [68]
    {
      237547, -- [1]
      7, -- [2]
      2, -- [3]
      85696, -- [4]
    }, -- [69]
    {
      134916, -- [1]
      2, -- [2]
      2, -- [3]
      87461, -- [4]
    }, -- [70]
    {
      252269, -- [1]
      5, -- [2]
      1, -- [3]
      85804, -- [4]
    }, -- [71]
    {
      237486, -- [1]
      4, -- [2]
      2, -- [3]
      25956, -- [4]
    }, -- [72]
    {
      236258, -- [1]
      3, -- [2]
      3, -- [3]
      87172, -- [4]
    }, -- [73]
    {
      135937, -- [1]
      2, -- [2]
      4, -- [3]
      26023, -- [4]
    }, -- [74]
    {
      236255, -- [1]
      1, -- [2]
      3, -- [3]
      87175, -- [4]
    }, -- [75]
    {
      135964, -- [1]
      2, -- [2]
      1, -- [3]
      20175, -- [4]
    }, -- [76]
    [85] = {
      "PALADINHOLY", -- [1]
      "PALADINPROTECTION", -- [2]
      "PALADINCOMBAT", -- [3]
    },
  },
  ["MAGE"] = {
    {
      136071, -- [1]
      4, -- [2]
      1, -- [3]
      12592, -- [4]
    }, -- [1]
    {
      136170, -- [1]
      1, -- [2]
      1, -- [3]
      12575, -- [4]
    }, -- [2]
    {
      135856, -- [1]
      1, -- [2]
      2, -- [3]
      12598, -- [4]
    }, -- [3]
    {
      135737, -- [1]
      2, -- [2]
      1, -- [3]
      55340, -- [4]
    }, -- [4]
    {
      135736, -- [1]
      2, -- [2]
      4, -- [3]
      31570, -- [4]
    }, -- [5]
    {
      136031, -- [1]
      3, -- [2]
      2, -- [3]
      12043, -- [4]
    }, -- [6]
    {
      135752, -- [1]
      3, -- [2]
      4, -- [3]
      54354, -- [4]
    }, -- [7]
    {
      135732, -- [1]
      5, -- [2]
      1, -- [3]
      31572, -- [4]
    }, -- [8]
    {
      136048, -- [1]
      7, -- [2]
      2, -- [3]
      12042, -- [4]
    }, -- [9]
    {
      236219, -- [1]
      4, -- [2]
      3, -- [3]
      44395, -- [4]
    }, -- [10]
    {
      236223, -- [1]
      3, -- [2]
      1, -- [3]
      44379, -- [4]
    }, -- [11]
    {
      134104, -- [1]
      6, -- [2]
      3, -- [3]
      31585, -- [4]
    }, -- [12]
    {
      136091, -- [1]
      5, -- [2]
      2, -- [3]
      31589, -- [4]
    }, -- [13]
    {
      236221, -- [1]
      3, -- [2]
      3, -- [3]
      54486, -- [4]
    }, -- [14]
    {
      236222, -- [1]
      1, -- [2]
      3, -- [3]
      44403, -- [4]
    }, -- [15]
    {
      135754, -- [1]
      6, -- [2]
      1, -- [3]
      54646, -- [4]
    }, -- [16]
    {
      429382, -- [1]
      4, -- [2]
      2, -- [3]
      82930, -- [4]
    }, -- [17]
    {
      136096, -- [1]
      2, -- [2]
      3, -- [3]
      83515, -- [4]
    }, -- [18]
    {
      429383, -- [1]
      2, -- [2]
      2, -- [3]
      84723, -- [4]
    }, -- [19]
    {
      135735, -- [1]
      5, -- [2]
      3, -- [3]
      86209, -- [4]
    }, -- [20]
    nil, -- [21]
    {
      136116, -- [1]
      4, -- [2]
      4, -- [3]
      90788, -- [4]
    }, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    {
      135807, -- [1]
      1, -- [2]
      3, -- [3]
      11080, -- [4]
    }, -- [29]
    {
      135818, -- [1]
      2, -- [2]
      1, -- [3]
      12846, -- [4]
    }, -- [30]
    {
      429590, -- [1]
      1, -- [2]
      2, -- [3]
      84254, -- [4]
    }, -- [31]
    {
      135821, -- [1]
      2, -- [2]
      4, -- [3]
      12357, -- [4]
    }, -- [32]
    {
      136115, -- [1]
      6, -- [2]
      3, -- [3]
      12873, -- [4]
    }, -- [33]
    {
      135806, -- [1]
      4, -- [2]
      1, -- [3]
      11094, -- [4]
    }, -- [34]
    {
      135820, -- [1]
      1, -- [2]
      1, -- [3]
      29075, -- [4]
    }, -- [35]
    {
      135827, -- [1]
      3, -- [2]
      4, -- [3]
      11367, -- [4]
    }, -- [36]
    {
      135903, -- [1]
      3, -- [2]
      2, -- [3]
      11113, -- [4]
    }, -- [37]
    {
      135788, -- [1]
      2, -- [2]
      3, -- [3]
      31642, -- [4]
    }, -- [38]
    {
      135789, -- [1]
      6, -- [2]
      1, -- [3]
      34295, -- [4]
    }, -- [39]
    {
      135824, -- [1]
      4, -- [2]
      2, -- [3]
      11129, -- [4]
    }, -- [40]
    {
      135822, -- [1]
      5, -- [2]
      3, -- [3]
      86880, -- [4]
    }, -- [41]
    {
      134153, -- [1]
      5, -- [2]
      2, -- [3]
      31661, -- [4]
    }, -- [42]
    {
      236218, -- [1]
      3, -- [2]
      3, -- [3]
      44445, -- [4]
    }, -- [43]
    {
      236220, -- [1]
      7, -- [2]
      2, -- [3]
      44457, -- [4]
    }, -- [44]
    {
      135826, -- [1]
      5, -- [2]
      1, -- [3]
      84674, -- [4]
    }, -- [45]
    {
      236216, -- [1]
      4, -- [2]
      4, -- [3]
      86914, -- [4]
    }, -- [46]
    {
      252268, -- [1]
      3, -- [2]
      1, -- [3]
      86949, -- [4]
    }, -- [47]
    {
      135817, -- [1]
      2, -- [2]
      2, -- [3]
      54734, -- [4]
    }, -- [48]
    {
      236218, -- [1]
      4, -- [2]
      3, -- [3]
      44448, -- [4]
    }, -- [49]
    nil, -- [50]
    nil, -- [51]
    nil, -- [52]
    nil, -- [53]
    nil, -- [54]
    nil, -- [55]
    nil, -- [56]
    {
      135854, -- [1]
      2, -- [2]
      1, -- [3]
      55094, -- [4]
    }, -- [57]
    {
      135864, -- [1]
      2, -- [2]
      4, -- [3]
      12571, -- [4]
    }, -- [58]
    {
      135838, -- [1]
      3, -- [2]
      2, -- [3]
      12472, -- [4]
    }, -- [59]
    {
      429385, -- [1]
      3, -- [2]
      1, -- [3]
      12487, -- [4]
    }, -- [60]
    {
      135837, -- [1]
      1, -- [2]
      1, -- [3]
      83050, -- [4]
    }, -- [61]
    {
      135865, -- [1]
      4, -- [2]
      2, -- [3]
      11958, -- [4]
    }, -- [62]
    {
      236227, -- [1]
      3, -- [2]
      3, -- [3]
      83074, -- [4]
    }, -- [63]
    {
      236209, -- [1]
      5, -- [2]
      1, -- [3]
      54787, -- [4]
    }, -- [64]
    {
      135988, -- [1]
      5, -- [2]
      2, -- [3]
      11426, -- [4]
    }, -- [65]
    {
      236206, -- [1]
      4, -- [2]
      3, -- [3]
      44549, -- [4]
    }, -- [66]
    {
      135833, -- [1]
      4, -- [2]
      1, -- [3]
      86508, -- [4]
    }, -- [67]
    {
      236214, -- [1]
      7, -- [2]
      2, -- [3]
      44572, -- [4]
    }, -- [68]
    {
      429386, -- [1]
      2, -- [2]
      3, -- [3]
      83157, -- [4]
    }, -- [69]
    {
      135845, -- [1]
      1, -- [2]
      2, -- [3]
      12953, -- [4]
    }, -- [70]
    {
      135849, -- [1]
      1, -- [2]
      3, -- [3]
      12982, -- [4]
    }, -- [71]
    {
      430840, -- [1]
      6, -- [2]
      3, -- [3]
      84727, -- [4]
    }, -- [72]
    {
      135852, -- [1]
      2, -- [2]
      2, -- [3]
      12489, -- [4]
    }, -- [73]
    {
      135861, -- [1]
      3, -- [2]
      4, -- [3]
      86314, -- [4]
    }, -- [74]
    {
      135859, -- [1]
      5, -- [2]
      3, -- [3]
      86304, -- [4]
    }, -- [75]
    [85] = {
      "MageArcane", -- [1]
      "MageFire", -- [2]
      "MageFrost", -- [3]
    },
  },
  ["PRIEST"] = {
    {
      135969, -- [1]
      1, -- [2]
      2, -- [3]
      47588, -- [4]
    }, -- [1]
    {
      135926, -- [1]
      2, -- [2]
      3, -- [3]
      14771, -- [4]
    }, -- [2]
    {
      135863, -- [1]
      3, -- [2]
      4, -- [3]
      89485, -- [4]
    }, -- [3]
    {
      135895, -- [1]
      2, -- [2]
      1, -- [3]
      81662, -- [4]
    }, -- [4]
    {
      132156, -- [1]
      1, -- [2]
      3, -- [3]
      14781, -- [4]
    }, -- [5]
    {
      253400, -- [1]
      7, -- [2]
      2, -- [3]
      62618, -- [4]
    }, -- [6]
    {
      458412, -- [1]
      4, -- [2]
      4, -- [3]
      33202, -- [4]
    }, -- [7]
    {
      458722, -- [1]
      2, -- [2]
      4, -- [3]
      78500, -- [4]
    }, -- [8]
    {
      237539, -- [1]
      5, -- [2]
      2, -- [3]
      47515, -- [4]
    }, -- [9]
    {
      135939, -- [1]
      3, -- [2]
      2, -- [3]
      10060, -- [4]
    }, -- [10]
    {
      237548, -- [1]
      4, -- [2]
      2, -- [3]
      47537, -- [4]
    }, -- [11]
    {
      458227, -- [1]
      6, -- [2]
      1, -- [3]
      45243, -- [4]
    }, -- [12]
    {
      135936, -- [1]
      5, -- [2]
      3, -- [3]
      33206, -- [4]
    }, -- [13]
    {
      237543, -- [1]
      6, -- [2]
      3, -- [3]
      47517, -- [4]
    }, -- [14]
    {
      135940, -- [1]
      1, -- [2]
      1, -- [3]
      14768, -- [4]
    }, -- [15]
    {
      135923, -- [1]
      3, -- [2]
      1, -- [3]
      57472, -- [4]
    }, -- [16]
    {
      237538, -- [1]
      4, -- [2]
      3, -- [3]
      52797, -- [4]
    }, -- [17]
    {
      458225, -- [1]
      2, -- [2]
      2, -- [3]
      87151, -- [4]
    }, -- [18]
    {
      458720, -- [1]
      3, -- [2]
      3, -- [3]
      81749, -- [4]
    }, -- [19]
    {
      135871, -- [1]
      5, -- [2]
      1, -- [3]
      89489, -- [4]
    }, -- [20]
    {
      236225, -- [1]
      5, -- [2]
      4, -- [3]
      92297, -- [4]
    }, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    {
      135971, -- [1]
      1, -- [2]
      3, -- [3]
      18533, -- [4]
    }, -- [29]
    {
      135913, -- [1]
      1, -- [2]
      2, -- [3]
      33160, -- [4]
    }, -- [30]
    {
      135928, -- [1]
      2, -- [2]
      4, -- [3]
      15362, -- [4]
    }, -- [31]
    {
      237549, -- [1]
      4, -- [2]
      4, -- [3]
      63733, -- [4]
    }, -- [32]
    {
      135905, -- [1]
      3, -- [2]
      2, -- [3]
      34859, -- [4]
    }, -- [33]
    {
      135982, -- [1]
      5, -- [2]
      1, -- [3]
      64129, -- [4]
    }, -- [34]
    {
      236254, -- [1]
      3, -- [2]
      1, -- [3]
      63542, -- [4]
    }, -- [35]
    {
      135887, -- [1]
      6, -- [2]
      3, -- [3]
      34861, -- [4]
    }, -- [36]
    {
      237550, -- [1]
      6, -- [2]
      1, -- [3]
      47560, -- [4]
    }, -- [37]
    {
      237542, -- [1]
      7, -- [2]
      2, -- [3]
      47788, -- [4]
    }, -- [38]
    {
      135953, -- [1]
      1, -- [2]
      1, -- [3]
      15020, -- [4]
    }, -- [39]
    {
      135980, -- [1]
      3, -- [2]
      3, -- [3]
      724, -- [4]
    }, -- [40]
    {
      521584, -- [1]
      5, -- [2]
      2, -- [3]
      14751, -- [4]
    }, -- [41]
    {
      458228, -- [1]
      6, -- [2]
      2, -- [3]
      87431, -- [4]
    }, -- [42]
    {
      135954, -- [1]
      2, -- [2]
      2, -- [3]
      19236, -- [4]
    }, -- [43]
    {
      132864, -- [1]
      4, -- [2]
      3, -- [3]
      20711, -- [4]
    }, -- [44]
    {
      135878, -- [1]
      5, -- [2]
      4, -- [3]
      33145, -- [4]
    }, -- [45]
    {
      458721, -- [1]
      5, -- [2]
      3, -- [3]
      88627, -- [4]
    }, -- [46]
    {
      135981, -- [1]
      2, -- [2]
      3, -- [3]
      88690, -- [4]
    }, -- [47]
    {
      133739, -- [1]
      3, -- [2]
      4, -- [3]
      81625, -- [4]
    }, -- [48]
    {
      236249, -- [1]
      4, -- [2]
      1, -- [3]
      95649, -- [4]
    }, -- [49]
    nil, -- [50]
    nil, -- [51]
    nil, -- [52]
    nil, -- [53]
    nil, -- [54]
    nil, -- [55]
    nil, -- [56]
    {
      458226, -- [1]
      1, -- [2]
      1, -- [3]
      15308, -- [4]
    }, -- [57]
    {
      136207, -- [1]
      1, -- [2]
      2, -- [3]
      15317, -- [4]
    }, -- [58]
    {
      136184, -- [1]
      2, -- [2]
      1, -- [3]
      15448, -- [4]
    }, -- [59]
    {
      136224, -- [1]
      2, -- [2]
      2, -- [3]
      15313, -- [4]
    }, -- [60]
    {
      135994, -- [1]
      1, -- [2]
      3, -- [3]
      15311, -- [4]
    }, -- [61]
    {
      458230, -- [1]
      4, -- [2]
      1, -- [3]
      15487, -- [4]
    }, -- [62]
    {
      136230, -- [1]
      4, -- [2]
      2, -- [3]
      15286, -- [4]
    }, -- [63]
    {
      237569, -- [1]
      4, -- [2]
      4, -- [3]
      33371, -- [4]
    }, -- [64]
    {
      252996, -- [1]
      2, -- [2]
      3, -- [3]
      63626, -- [4]
    }, -- [65]
    {
      136200, -- [1]
      3, -- [2]
      2, -- [3]
      15473, -- [4]
    }, -- [66]
    {
      237570, -- [1]
      3, -- [2]
      3, -- [3]
      47570, -- [4]
    }, -- [67]
    {
      458229, -- [1]
      6, -- [2]
      3, -- [3]
      78204, -- [4]
    }, -- [68]
    {
      237568, -- [1]
      6, -- [2]
      1, -- [3]
      64044, -- [4]
    }, -- [69]
    {
      135978, -- [1]
      5, -- [2]
      2, -- [3]
      34914, -- [4]
    }, -- [70]
    {
      237567, -- [1]
      5, -- [2]
      1, -- [3]
      47581, -- [4]
    }, -- [71]
    {
      237563, -- [1]
      7, -- [2]
      2, -- [3]
      47585, -- [4]
    }, -- [72]
    {
      135945, -- [1]
      6, -- [2]
      2, -- [3]
      87100, -- [4]
    }, -- [73]
    {
      134336, -- [1]
      3, -- [2]
      4, -- [3]
      78228, -- [4]
    }, -- [74]
    {
      132299, -- [1]
      5, -- [2]
      3, -- [3]
      87195, -- [4]
    }, -- [75]
    {
      237566, -- [1]
      2, -- [2]
      4, -- [3]
      47577, -- [4]
    }, -- [76]
    {
      136176, -- [1]
      4, -- [2]
      3, -- [3]
      88995, -- [4]
    }, -- [77]
    [85] = {
      "PriestDiscipline", -- [1]
      "PriestHoly", -- [2]
      "PriestShadow", -- [3]
    },
  },
  ["WARLOCK"] = {
    {
      136139, -- [1]
      1, -- [2]
      1, -- [3]
      18829, -- [4]
    }, -- [1]
    {
      136118, -- [1]
      1, -- [2]
      3, -- [3]
      17812, -- [4]
    }, -- [2]
    {
      136126, -- [1]
      1, -- [2]
      2, -- [3]
      18183, -- [4]
    }, -- [3]
    {
      460700, -- [1]
      2, -- [2]
      2, -- [3]
      17805, -- [4]
    }, -- [4]
    {
      136183, -- [1]
      3, -- [2]
      3, -- [3]
      53759, -- [4]
    }, -- [5]
    {
      136223, -- [1]
      5, -- [2]
      2, -- [3]
      18095, -- [4]
    }, -- [6]
    {
      136198, -- [1]
      4, -- [2]
      3, -- [3]
      32392, -- [4]
    }, -- [7]
    {
      136162, -- [1]
      3, -- [2]
      1, -- [3]
      18223, -- [4]
    }, -- [8]
    {
      236295, -- [1]
      3, -- [2]
      4, -- [3]
      47197, -- [4]
    }, -- [9]
    {
      136147, -- [1]
      4, -- [2]
      1, -- [3]
      30057, -- [4]
    }, -- [10]
    {
      237557, -- [1]
      5, -- [2]
      1, -- [3]
      47200, -- [4]
    }, -- [11]
    {
      236296, -- [1]
      6, -- [2]
      2, -- [3]
      47203, -- [4]
    }, -- [12]
    {
      236298, -- [1]
      7, -- [2]
      2, -- [3]
      48181, -- [4]
    }, -- [13]
    {
      136166, -- [1]
      6, -- [2]
      3, -- [3]
      85100, -- [4]
    }, -- [14]
    {
      460699, -- [1]
      2, -- [2]
      1, -- [3]
      85479, -- [4]
    }, -- [15]
    {
      460857, -- [1]
      4, -- [2]
      2, -- [3]
      86121, -- [4]
    }, -- [16]
    {
      136193, -- [1]
      5, -- [2]
      3, -- [3]
      86664, -- [4]
    }, -- [17]
    {
      136188, -- [1]
      2, -- [2]
      3, -- [3]
      86667, -- [4]
    }, -- [18]
    nil, -- [19]
    nil, -- [20]
    nil, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    {
      460697, -- [1]
      1, -- [2]
      2, -- [3]
      85284, -- [4]
    }, -- [29]
    {
      136172, -- [1]
      1, -- [2]
      1, -- [3]
      18699, -- [4]
    }, -- [30]
    {
      136168, -- [1]
      3, -- [2]
      3, -- [3]
      18704, -- [4]
    }, -- [31]
    {
      136164, -- [1]
      2, -- [2]
      4, -- [3]
      18710, -- [4]
    }, -- [32]
    {
      136171, -- [1]
      2, -- [2]
      2, -- [3]
      85175, -- [4]
    }, -- [33]
    {
      236301, -- [1]
      4, -- [2]
      1, -- [3]
      47247, -- [4]
    }, -- [34]
    {
      135808, -- [1]
      5, -- [2]
      3, -- [3]
      63158, -- [4]
    }, -- [35]
    {
      237562, -- [1]
      6, -- [2]
      3, -- [3]
      47236, -- [4]
    }, -- [36]
    {
      237558, -- [1]
      7, -- [2]
      2, -- [3]
      59672, -- [4]
    }, -- [37]
    {
      236292, -- [1]
      3, -- [2]
      2, -- [3]
      47193, -- [4]
    }, -- [38]
    {
      460694, -- [1]
      5, -- [2]
      1, -- [3]
      85110, -- [4]
    }, -- [39]
    {
      460698, -- [1]
      5, -- [2]
      2, -- [3]
      85105, -- [4]
    }, -- [40]
    {
      136185, -- [1]
      2, -- [2]
      3, -- [3]
      30144, -- [4]
    }, -- [41]
    {
      136082, -- [1]
      3, -- [2]
      1, -- [3]
      85108, -- [4]
    }, -- [42]
    {
      460696, -- [1]
      6, -- [2]
      2, -- [3]
      85104, -- [4]
    }, -- [43]
    {
      135265, -- [1]
      4, -- [2]
      2, -- [3]
      71521, -- [4]
    }, -- [44]
    {
      237564, -- [1]
      1, -- [2]
      3, -- [3]
      47231, -- [4]
    }, -- [45]
    {
      136150, -- [1]
      2, -- [2]
      1, -- [3]
      88447, -- [4]
    }, -- [46]
    {
      136192, -- [1]
      4, -- [2]
      3, -- [3]
      89605, -- [4]
    }, -- [47]
    nil, -- [48]
    nil, -- [49]
    nil, -- [50]
    nil, -- [51]
    nil, -- [52]
    nil, -- [53]
    nil, -- [54]
    nil, -- [55]
    nil, -- [56]
    {
      136196, -- [1]
      1, -- [2]
      2, -- [3]
      17801, -- [4]
    }, -- [57]
    {
      136146, -- [1]
      1, -- [2]
      1, -- [3]
      17790, -- [4]
    }, -- [58]
    {
      135808, -- [1]
      3, -- [2]
      1, -- [3]
      18120, -- [4]
    }, -- [59]
    {
      136191, -- [1]
      3, -- [2]
      3, -- [3]
      17877, -- [4]
    }, -- [60]
    {
      135823, -- [1]
      4, -- [2]
      3, -- [3]
      34939, -- [4]
    }, -- [61]
    {
      135817, -- [1]
      1, -- [2]
      3, -- [3]
      17833, -- [4]
    }, -- [62]
    {
      460695, -- [1]
      6, -- [2]
      3, -- [3]
      80240, -- [4]
    }, -- [63]
    {
      136178, -- [1]
      5, -- [2]
      4, -- [3]
      30301, -- [4]
    }, -- [64]
    {
      136214, -- [1]
      4, -- [2]
      2, -- [3]
      30295, -- [4]
    }, -- [65]
    {
      236290, -- [1]
      3, -- [2]
      2, -- [3]
      47260, -- [4]
    }, -- [66]
    {
      136201, -- [1]
      5, -- [2]
      3, -- [3]
      30283, -- [4]
    }, -- [67]
    {
      236294, -- [1]
      6, -- [2]
      1, -- [3]
      47221, -- [4]
    }, -- [68]
    {
      236297, -- [1]
      5, -- [2]
      2, -- [3]
      47268, -- [4]
    }, -- [69]
    {
      236291, -- [1]
      7, -- [2]
      2, -- [3]
      50796, -- [4]
    }, -- [70]
    {
      135826, -- [1]
      2, -- [2]
      2, -- [3]
      17955, -- [4]
    }, -- [71]
    {
      460952, -- [1]
      4, -- [2]
      1, -- [3]
      85112, -- [4]
    }, -- [72]
    {
      135827, -- [1]
      2, -- [2]
      3, -- [3]
      17929, -- [4]
    }, -- [73]
    {
      135805, -- [1]
      2, -- [2]
      1, -- [3]
      85114, -- [4]
    }, -- [74]
    {
      135796, -- [1]
      4, -- [2]
      4, -- [3]
      91713, -- [4]
    }, -- [75]
    [85] = {
      "WarlockCurses", -- [1]
      "WarlockSummoning", -- [2]
      "WarlockDestruction", -- [3]
    },
  },
  ["ROGUE"] = {
    {
      132109, -- [1]
      1, -- [2]
      3, -- [3]
      14135, -- [4]
    }, -- [1]
    {
      132122, -- [1]
      2, -- [2]
      1, -- [3]
      14161, -- [4]
    }, -- [2]
    {
      132292, -- [1]
      1, -- [2]
      2, -- [3]
      14164, -- [4]
    }, -- [3]
    {
      132090, -- [1]
      2, -- [2]
      3, -- [3]
      13866, -- [4]
    }, -- [4]
    {
      132354, -- [1]
      5, -- [2]
      4, -- [3]
      14169, -- [4]
    }, -- [5]
    {
      135988, -- [1]
      3, -- [2]
      2, -- [3]
      14177, -- [4]
    }, -- [6]
    {
      132205, -- [1]
      5, -- [2]
      2, -- [3]
      58426, -- [4]
    }, -- [7]
    {
      236281, -- [1]
      4, -- [2]
      2, -- [3]
      14190, -- [4]
    }, -- [8]
    {
      132293, -- [1]
      3, -- [2]
      3, -- [3]
      16515, -- [4]
    }, -- [9]
    {
      132108, -- [1]
      5, -- [2]
      3, -- [3]
      58410, -- [4]
    }, -- [10]
    {
      132301, -- [1]
      2, -- [2]
      2, -- [3]
      31209, -- [4]
    }, -- [11]
    {
      236270, -- [1]
      3, -- [2]
      1, -- [3]
      51626, -- [4]
    }, -- [12]
    {
      236269, -- [1]
      6, -- [2]
      2, -- [3]
      51667, -- [4]
    }, -- [13]
    {
      458726, -- [1]
      7, -- [2]
      2, -- [3]
      79140, -- [4]
    }, -- [14]
    {
      458727, -- [1]
      1, -- [2]
      1, -- [3]
      79122, -- [4]
    }, -- [15]
    {
      458797, -- [1]
      2, -- [2]
      4, -- [3]
      79125, -- [4]
    }, -- [16]
    {
      136147, -- [1]
      5, -- [2]
      1, -- [3]
      14159, -- [4]
    }, -- [17]
    {
      458736, -- [1]
      6, -- [2]
      3, -- [3]
      79134, -- [4]
    }, -- [18]
    {
      132286, -- [1]
      4, -- [2]
      1, -- [3]
      31383, -- [4]
    }, -- [19]
    nil, -- [20]
    nil, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    {
      132222, -- [1]
      1, -- [2]
      3, -- [3]
      13843, -- [4]
    }, -- [29]
    {
      136047, -- [1]
      3, -- [2]
      1, -- [3]
      13789, -- [4]
    }, -- [30]
    {
      136189, -- [1]
      1, -- [2]
      2, -- [3]
      79004, -- [4]
    }, -- [31]
    {
      132155, -- [1]
      3, -- [2]
      4, -- [3]
      13793, -- [4]
    }, -- [32]
    {
      136206, -- [1]
      5, -- [2]
      2, -- [3]
      13750, -- [4]
    }, -- [33]
    {
      132219, -- [1]
      2, -- [2]
      4, -- [3]
      13867, -- [4]
    }, -- [34]
    {
      132307, -- [1]
      2, -- [2]
      2, -- [3]
      13875, -- [4]
    }, -- [35]
    {
      132275, -- [1]
      2, -- [2]
      3, -- [3]
      18429, -- [4]
    }, -- [36]
    {
      132283, -- [1]
      4, -- [2]
      3, -- [3]
      31126, -- [4]
    }, -- [37]
    {
      135673, -- [1]
      4, -- [2]
      2, -- [3]
      35551, -- [4]
    }, -- [38]
    {
      132306, -- [1]
      2, -- [2]
      1, -- [3]
      14166, -- [4]
    }, -- [39]
    {
      236282, -- [1]
      5, -- [2]
      1, -- [3]
      51679, -- [4]
    }, -- [40]
    {
      132100, -- [1]
      5, -- [2]
      3, -- [3]
      58413, -- [4]
    }, -- [41]
    {
      236277, -- [1]
      7, -- [2]
      2, -- [3]
      51690, -- [4]
    }, -- [42]
    {
      457635, -- [1]
      1, -- [2]
      1, -- [3]
      79008, -- [4]
    }, -- [43]
    {
      458730, -- [1]
      3, -- [2]
      3, -- [3]
      79079, -- [4]
    }, -- [44]
    {
      458731, -- [1]
      6, -- [2]
      3, -- [3]
      79096, -- [4]
    }, -- [45]
    {
      135407, -- [1]
      3, -- [2]
      2, -- [3]
      84617, -- [4]
    }, -- [46]
    {
      236278, -- [1]
      6, -- [2]
      1, -- [3]
      84654, -- [4]
    }, -- [47]
    nil, -- [48]
    nil, -- [49]
    nil, -- [50]
    nil, -- [51]
    nil, -- [52]
    nil, -- [53]
    nil, -- [54]
    nil, -- [55]
    nil, -- [56]
    {
      132320, -- [1]
      1, -- [2]
      1, -- [3]
      14062, -- [4]
    }, -- [57]
    {
      136159, -- [1]
      2, -- [2]
      4, -- [3]
      13979, -- [4]
    }, -- [58]
    {
      135994, -- [1]
      2, -- [2]
      1, -- [3]
      14066, -- [4]
    }, -- [59]
    {
      236268, -- [1]
      2, -- [2]
      3, -- [3]
      79141, -- [4]
    }, -- [60]
    {
      132282, -- [1]
      1, -- [2]
      2, -- [3]
      84661, -- [4]
    }, -- [61]
    {
      460693, -- [1]
      5, -- [2]
      2, -- [3]
      14185, -- [4]
    }, -- [62]
    {
      136183, -- [1]
      4, -- [2]
      2, -- [3]
      14183, -- [4]
    }, -- [63]
    {
      136168, -- [1]
      3, -- [2]
      3, -- [3]
      16511, -- [4]
    }, -- [64]
    {
      135315, -- [1]
      6, -- [2]
      3, -- [3]
      14172, -- [4]
    }, -- [65]
    {
      132285, -- [1]
      5, -- [2]
      1, -- [3]
      31230, -- [4]
    }, -- [66]
    {
      236286, -- [1]
      2, -- [2]
      2, -- [3]
      51696, -- [4]
    }, -- [67]
    {
      236275, -- [1]
      4, -- [2]
      1, -- [3]
      51701, -- [4]
    }, -- [68]
    {
      236280, -- [1]
      6, -- [2]
      2, -- [3]
      51710, -- [4]
    }, -- [69]
    {
      236279, -- [1]
      7, -- [2]
      2, -- [3]
      51713, -- [4]
    }, -- [70]
    {
      132340, -- [1]
      1, -- [2]
      3, -- [3]
      58423, -- [4]
    }, -- [71]
    {
      132295, -- [1]
      3, -- [2]
      2, -- [3]
      91023, -- [4]
    }, -- [72]
    {
      457636, -- [1]
      5, -- [2]
      3, -- [3]
      79147, -- [4]
    }, -- [73]
    {
      132291, -- [1]
      4, -- [2]
      4, -- [3]
      31213, -- [4]
    }, -- [74]
    {
      458734, -- [1]
      3, -- [2]
      1, -- [3]
      79152, -- [4]
    }, -- [75]
    [85] = {
      "RogueAssassination", -- [1]
      "RogueCombat", -- [2]
      "RogueSubtlety", -- [3]
    },
  },
  ["DRUID"] = {
    {
      136006, -- [1]
      1, -- [2]
      2, -- [3]
      16816, -- [4]
    }, -- [1]
    {
      136087, -- [1]
      2, -- [2]
      2, -- [3]
      16847, -- [4]
    }, -- [2]
    {
      136062, -- [1]
      1, -- [2]
      1, -- [3]
      61346, -- [4]
    }, -- [3]
    {
      252188, -- [1]
      4, -- [2]
      4, -- [3]
      78675, -- [4]
    }, -- [4]
    {
      236154, -- [1]
      4, -- [2]
      3, -- [3]
      48514, -- [4]
    }, -- [5]
    {
      236205, -- [1]
      3, -- [2]
      4, -- [3]
      93399, -- [4]
    }, -- [6]
    {
      132113, -- [1]
      2, -- [2]
      3, -- [3]
      33596, -- [4]
    }, -- [7]
    {
      341763, -- [1]
      3, -- [2]
      1, -- [3]
      81062, -- [4]
    }, -- [8]
    {
      236163, -- [1]
      4, -- [2]
      2, -- [3]
      48393, -- [4]
    }, -- [9]
    {
      236704, -- [1]
      6, -- [2]
      3, -- [3]
      33605, -- [4]
    }, -- [10]
    {
      132129, -- [1]
      5, -- [2]
      2, -- [3]
      33831, -- [4]
    }, -- [11]
    {
      132371, -- [1]
      6, -- [2]
      2, -- [3]
      78789, -- [4]
    }, -- [12]
    {
      236168, -- [1]
      7, -- [2]
      2, -- [3]
      48505, -- [4]
    }, -- [13]
    {
      236150, -- [1]
      5, -- [2]
      4, -- [3]
      48506, -- [4]
    }, -- [14]
    {
      136036, -- [1]
      3, -- [2]
      2, -- [3]
      24858, -- [4]
    }, -- [15]
    {
      135138, -- [1]
      1, -- [2]
      3, -- [3]
      35364, -- [4]
    }, -- [16]
    {
      236170, -- [1]
      3, -- [2]
      3, -- [3]
      50516, -- [4]
    }, -- [17]
    {
      135730, -- [1]
      2, -- [2]
      1, -- [3]
      57812, -- [4]
    }, -- [18]
    {
      132123, -- [1]
      5, -- [2]
      1, -- [3]
      33599, -- [4]
    }, -- [19]
    {
      236216, -- [1]
      5, -- [2]
      3, -- [3]
      93401, -- [4]
    }, -- [20]
    nil, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    {
      134355, -- [1]
      3, -- [2]
      4, -- [3]
      16931, -- [4]
    }, -- [29]
    {
      136095, -- [1]
      1, -- [2]
      1, -- [3]
      24866, -- [4]
    }, -- [30]
    {
      132183, -- [1]
      3, -- [2]
      2, -- [3]
      49377, -- [4]
    }, -- [31]
    {
      304501, -- [1]
      3, -- [2]
      3, -- [3]
      78893, -- [4]
    }, -- [32]
    {
      132130, -- [1]
      4, -- [2]
      4, -- [3]
      33873, -- [4]
    }, -- [33]
    {
      132134, -- [1]
      2, -- [2]
      2, -- [3]
      80553, -- [4]
    }, -- [34]
    {
      132114, -- [1]
      4, -- [2]
      3, -- [3]
      16941, -- [4]
    }, -- [35]
    {
      236169, -- [1]
      5, -- [2]
      2, -- [3]
      61336, -- [4]
    }, -- [36]
    {
      132318, -- [1]
      6, -- [2]
      3, -- [3]
      80313, -- [4]
    }, -- [37]
    {
      236159, -- [1]
      3, -- [2]
      1, -- [3]
      48495, -- [4]
    }, -- [38]
    {
      136112, -- [1]
      4, -- [2]
      2, -- [3]
      17007, -- [4]
    }, -- [39]
    {
      132242, -- [1]
      5, -- [2]
      1, -- [3]
      80317, -- [4]
    }, -- [40]
    {
      237347, -- [1]
      6, -- [2]
      1, -- [3]
      80319, -- [4]
    }, -- [41]
    {
      236164, -- [1]
      6, -- [2]
      2, -- [3]
      48434, -- [4]
    }, -- [42]
    {
      236149, -- [1]
      7, -- [2]
      2, -- [3]
      50334, -- [4]
    }, -- [43]
    {
      132091, -- [1]
      5, -- [2]
      4, -- [3]
      57880, -- [4]
    }, -- [44]
    {
      237513, -- [1]
      5, -- [2]
      3, -- [3]
      80315, -- [4]
    }, -- [45]
    {
      236158, -- [1]
      2, -- [2]
      1, -- [3]
      48484, -- [4]
    }, -- [46]
    {
      132278, -- [1]
      2, -- [2]
      3, -- [3]
      37117, -- [4]
    }, -- [47]
    {
      132185, -- [1]
      1, -- [2]
      3, -- [3]
      16974, -- [4]
    }, -- [48]
    {
      132121, -- [1]
      2, -- [2]
      4, -- [3]
      16859, -- [4]
    }, -- [49]
    {
      135881, -- [1]
      1, -- [2]
      2, -- [3]
      17059, -- [4]
    }, -- [50]
    nil, -- [51]
    nil, -- [52]
    nil, -- [53]
    nil, -- [54]
    nil, -- [55]
    nil, -- [56]
    {
      237586, -- [1]
      1, -- [2]
      1, -- [3]
      78785, -- [4]
    }, -- [57]
    {
      136116, -- [1]
      1, -- [2]
      2, -- [3]
      16834, -- [4]
    }, -- [58]
    {
      136081, -- [1]
      2, -- [2]
      3, -- [3]
      17113, -- [4]
    }, -- [59]
    {
      136076, -- [1]
      3, -- [2]
      3, -- [3]
      17116, -- [4]
    }, -- [60]
    {
      236155, -- [1]
      3, -- [2]
      1, -- [3]
      48500, -- [4]
    }, -- [61]
    {
      136085, -- [1]
      4, -- [2]
      2, -- [3]
      17076, -- [4]
    }, -- [62]
    {
      134222, -- [1]
      5, -- [2]
      1, -- [3]
      81275, -- [4]
    }, -- [63]
    {
      132124, -- [1]
      6, -- [2]
      3, -- [3]
      33886, -- [4]
    }, -- [64]
    {
      132137, -- [1]
      5, -- [2]
      4, -- [3]
      33882, -- [4]
    }, -- [65]
    {
      236166, -- [1]
      3, -- [2]
      2, -- [3]
      48544, -- [4]
    }, -- [66]
    {
      132145, -- [1]
      7, -- [2]
      2, -- [3]
      33891, -- [4]
    }, -- [67]
    {
      236161, -- [1]
      2, -- [2]
      2, -- [3]
      48411, -- [4]
    }, -- [68]
    {
      236153, -- [1]
      5, -- [2]
      2, -- [3]
      48438, -- [4]
    }, -- [69]
    {
      132125, -- [1]
      4, -- [2]
      3, -- [3]
      33880, -- [4]
    }, -- [70]
    {
      236288, -- [1]
      5, -- [2]
      3, -- [3]
      88423, -- [4]
    }, -- [71]
    {
      236740, -- [1]
      2, -- [2]
      1, -- [3]
      78736, -- [4]
    }, -- [72]
    {
      236160, -- [1]
      6, -- [2]
      1, -- [3]
      51181, -- [4]
    }, -- [73]
    {
      136041, -- [1]
      1, -- [2]
      3, -- [3]
      17070, -- [4]
    }, -- [74]
    {
      237472, -- [1]
      3, -- [2]
      4, -- [3]
      24943, -- [4]
    }, -- [75]
    {
      135879, -- [1]
      1, -- [2]
      4, -- [3]
      17005, -- [4]
    }, -- [76]
    {
      237578, -- [1]
      4, -- [2]
      4, -- [3]
      92364, -- [4]
    }, -- [77]
    [85] = {
      "DruidBalance", -- [1]
      "DruidFeralCombat", -- [2]
      "DruidRestoration", -- [3]
    },
  },
  ["SHAMAN"] = {
    {
      135817, -- [1]
      2, -- [2]
      1, -- [3]
      16160, -- [4]
    }, -- [1]
    {
      135807, -- [1]
      1, -- [2]
      3, -- [3]
      16106, -- [4]
    }, -- [2]
    {
      459025, -- [1]
      1, -- [2]
      2, -- [3]
      16109, -- [4]
    }, -- [3]
    {
      136115, -- [1]
      5, -- [2]
      2, -- [3]
      16166, -- [4]
    }, -- [4]
    {
      136170, -- [1]
      3, -- [2]
      2, -- [3]
      16164, -- [4]
    }, -- [5]
    {
      135850, -- [1]
      2, -- [2]
      3, -- [3]
      16113, -- [4]
    }, -- [6]
    {
      136094, -- [1]
      2, -- [2]
      2, -- [3]
      28998, -- [4]
    }, -- [7]
    {
      136099, -- [1]
      3, -- [2]
      3, -- [3]
      29000, -- [4]
    }, -- [8]
    {
      136028, -- [1]
      2, -- [2]
      4, -- [3]
      30674, -- [4]
    }, -- [9]
    {
      451165, -- [1]
      7, -- [2]
      2, -- [3]
      61882, -- [4]
    }, -- [10]
    {
      237576, -- [1]
      4, -- [2]
      2, -- [3]
      51470, -- [4]
    }, -- [11]
    {
      237583, -- [1]
      4, -- [2]
      3, -- [3]
      51482, -- [4]
    }, -- [12]
    {
      135829, -- [1]
      5, -- [2]
      4, -- [3]
      77746, -- [4]
    }, -- [13]
    {
      451169, -- [1]
      6, -- [2]
      3, -- [3]
      77756, -- [4]
    }, -- [14]
    {
      136011, -- [1]
      1, -- [2]
      1, -- [3]
      17487, -- [4]
    }, -- [15]
    {
      252174, -- [1]
      6, -- [2]
      2, -- [3]
      86185, -- [4]
    }, -- [16]
    {
      136014, -- [1]
      3, -- [2]
      1, -- [3]
      88764, -- [4]
    }, -- [17]
    {
      136100, -- [1]
      5, -- [2]
      3, -- [3]
      51485, -- [4]
    }, -- [18]
    {
      136111, -- [1]
      5, -- [2]
      1, -- [3]
      88766, -- [4]
    }, -- [19]
    nil, -- [20]
    nil, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    {
      132152, -- [1]
      2, -- [2]
      2, -- [3]
      16282, -- [4]
    }, -- [29]
    {
      348567, -- [1]
      2, -- [2]
      3, -- [3]
      16287, -- [4]
    }, -- [30]
    {
      136051, -- [1]
      1, -- [2]
      3, -- [3]
      51881, -- [4]
    }, -- [31]
    {
      135814, -- [1]
      1, -- [2]
      1, -- [3]
      29079, -- [4]
    }, -- [32]
    {
      135892, -- [1]
      3, -- [2]
      1, -- [3]
      16307, -- [4]
    }, -- [33]
    {
      132314, -- [1]
      3, -- [2]
      2, -- [3]
      17364, -- [4]
    }, -- [34]
    {
      136110, -- [1]
      5, -- [2]
      4, -- [3]
      30808, -- [4]
    }, -- [35]
    {
      136088, -- [1]
      5, -- [2]
      2, -- [3]
      30823, -- [4]
    }, -- [36]
    {
      237587, -- [1]
      3, -- [2]
      3, -- [3]
      51527, -- [4]
    }, -- [37]
    {
      136024, -- [1]
      5, -- [2]
      1, -- [3]
      51524, -- [4]
    }, -- [38]
    {
      237584, -- [1]
      6, -- [2]
      2, -- [3]
      51530, -- [4]
    }, -- [39]
    {
      237577, -- [1]
      7, -- [2]
      2, -- [3]
      51533, -- [4]
    }, -- [40]
    {
      135825, -- [1]
      4, -- [2]
      3, -- [3]
      77657, -- [4]
    }, -- [41]
    {
      451166, -- [1]
      1, -- [2]
      2, -- [3]
      77538, -- [4]
    }, -- [42]
    {
      451168, -- [1]
      6, -- [2]
      3, -- [3]
      77701, -- [4]
    }, -- [43]
    {
      135791, -- [1]
      2, -- [2]
      1, -- [3]
      29180, -- [4]
    }, -- [44]
    {
      135776, -- [1]
      4, -- [2]
      1, -- [3]
      63374, -- [4]
    }, -- [45]
    {
      136008, -- [1]
      2, -- [2]
      4, -- [3]
      86936, -- [4]
    }, -- [46]
    {
      136027, -- [1]
      4, -- [2]
      2, -- [3]
      16544, -- [4]
    }, -- [47]
    nil, -- [48]
    nil, -- [49]
    nil, -- [50]
    nil, -- [51]
    nil, -- [52]
    nil, -- [53]
    nil, -- [54]
    nil, -- [55]
    nil, -- [56]
    {
      136109, -- [1]
      3, -- [2]
      1, -- [3]
      16235, -- [4]
    }, -- [57]
    {
      132315, -- [1]
      2, -- [2]
      1, -- [3]
      16196, -- [4]
    }, -- [58]
    {
      136037, -- [1]
      4, -- [2]
      2, -- [3]
      16205, -- [4]
    }, -- [59]
    {
      135861, -- [1]
      5, -- [2]
      2, -- [3]
      16190, -- [4]
    }, -- [60]
    {
      136076, -- [1]
      3, -- [2]
      2, -- [3]
      16188, -- [4]
    }, -- [61]
    {
      135859, -- [1]
      1, -- [2]
      2, -- [3]
      16215, -- [4]
    }, -- [62]
    {
      136057, -- [1]
      2, -- [2]
      2, -- [3]
      16222, -- [4]
    }, -- [63]
    {
      136059, -- [1]
      3, -- [2]
      3, -- [3]
      30869, -- [4]
    }, -- [64]
    {
      136060, -- [1]
      2, -- [2]
      4, -- [3]
      30884, -- [4]
    }, -- [65]
    {
      237573, -- [1]
      6, -- [2]
      3, -- [3]
      51555, -- [4]
    }, -- [66]
    {
      237571, -- [1]
      5, -- [2]
      1, -- [3]
      51558, -- [4]
    }, -- [67]
    {
      237590, -- [1]
      6, -- [2]
      2, -- [3]
      51564, -- [4]
    }, -- [68]
    {
      252995, -- [1]
      7, -- [2]
      2, -- [3]
      61295, -- [4]
    }, -- [69]
    {
      236288, -- [1]
      4, -- [2]
      3, -- [3]
      77130, -- [4]
    }, -- [70]
    {
      462651, -- [1]
      2, -- [2]
      3, -- [3]
      77796, -- [4]
    }, -- [71]
    {
      252271, -- [1]
      1, -- [2]
      1, -- [3]
      77830, -- [4]
    }, -- [72]
    {
      135990, -- [1]
      5, -- [2]
      3, -- [3]
      82988, -- [4]
    }, -- [73]
    {
      237556, -- [1]
      1, -- [2]
      3, -- [3]
      84848, -- [4]
    }, -- [74]
    {
      136079, -- [1]
      4, -- [2]
      4, -- [3]
      86962, -- [4]
    }, -- [75]
    {
      237586, -- [1]
      5, -- [2]
      4, -- [3]
      98008, -- [4]
    }, -- [76]
    [85] = {
      "ShamanElementalCombat", -- [1]
      "ShamanEnhancement", -- [2]
      "ShamanRestoration", -- [3]
    },
  },
  ["HUNTER"] = {
    {
      461117, -- [1]
      1, -- [2]
      2, -- [3]
      82684, -- [4]
    }, -- [1]
    {
      461112, -- [1]
      1, -- [2]
      3, -- [3]
      82687, -- [4]
    }, -- [2]
    {
      132210, -- [1]
      1, -- [2]
      1, -- [3]
      35030, -- [4]
    }, -- [3]
    {
      461118, -- [1]
      2, -- [2]
      1, -- [3]
      19560, -- [4]
    }, -- [4]
    {
      132160, -- [1]
      3, -- [2]
      2, -- [3]
      82726, -- [4]
    }, -- [5]
    {
      132179, -- [1]
      2, -- [2]
      4, -- [3]
      19573, -- [4]
    }, -- [6]
    {
      134296, -- [1]
      2, -- [2]
      3, -- [3]
      19623, -- [4]
    }, -- [7]
    {
      132121, -- [1]
      2, -- [2]
      2, -- [3]
      20895, -- [4]
    }, -- [8]
    {
      132173, -- [1]
      5, -- [2]
      3, -- [3]
      34460, -- [4]
    }, -- [9]
    {
      461846, -- [1]
      3, -- [2]
      3, -- [3]
      82692, -- [4]
    }, -- [10]
    {
      236184, -- [1]
      6, -- [2]
      3, -- [3]
      53253, -- [4]
    }, -- [11]
    {
      132127, -- [1]
      5, -- [2]
      2, -- [3]
      19574, -- [4]
    }, -- [12]
    {
      236357, -- [1]
      4, -- [2]
      3, -- [3]
      82749, -- [4]
    }, -- [13]
    {
      236177, -- [1]
      3, -- [2]
      1, -- [3]
      53260, -- [4]
    }, -- [14]
    {
      236186, -- [1]
      4, -- [2]
      1, -- [3]
      53264, -- [4]
    }, -- [15]
    {
      132166, -- [1]
      6, -- [2]
      2, -- [3]
      34692, -- [4]
    }, -- [16]
    {
      236202, -- [1]
      6, -- [2]
      1, -- [3]
      56315, -- [4]
    }, -- [17]
    {
      236175, -- [1]
      7, -- [2]
      2, -- [3]
      53270, -- [4]
    }, -- [18]
    {
      236190, -- [1]
      5, -- [2]
      1, -- [3]
      82899, -- [4]
    }, -- [19]
    nil, -- [20]
    nil, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    {
      132205, -- [1]
      1, -- [2]
      3, -- [3]
      34949, -- [4]
    }, -- [29]
    {
      236179, -- [1]
      1, -- [2]
      2, -- [3]
      19418, -- [4]
    }, -- [30]
    {
      132174, -- [1]
      1, -- [2]
      1, -- [3]
      34954, -- [4]
    }, -- [31]
    {
      461121, -- [1]
      2, -- [2]
      1, -- [3]
      83356, -- [4]
    }, -- [32]
    {
      132217, -- [1]
      2, -- [2]
      3, -- [3]
      34483, -- [4]
    }, -- [33]
    {
      236182, -- [1]
      2, -- [2]
      2, -- [3]
      53224, -- [4]
    }, -- [34]
    {
      132206, -- [1]
      5, -- [2]
      4, -- [3]
      23989, -- [4]
    }, -- [35]
    {
      461115, -- [1]
      3, -- [2]
      2, -- [3]
      35102, -- [4]
    }, -- [36]
    {
      132222, -- [1]
      4, -- [2]
      1, -- [3]
      35110, -- [4]
    }, -- [37]
    {
      132329, -- [1]
      4, -- [2]
      2, -- [3]
      19506, -- [4]
    }, -- [38]
    {
      132345, -- [1]
      4, -- [2]
      3, -- [3]
      83490, -- [4]
    }, -- [39]
    {
      132177, -- [1]
      5, -- [2]
      2, -- [3]
      34487, -- [4]
    }, -- [40]
    {
      461120, -- [1]
      4, -- [2]
      4, -- [3]
      82894, -- [4]
    }, -- [41]
    {
      236201, -- [1]
      5, -- [2]
      1, -- [3]
      53232, -- [4]
    }, -- [42]
    {
      132323, -- [1]
      3, -- [2]
      1, -- [3]
      34490, -- [4]
    }, -- [43]
    {
      461119, -- [1]
      6, -- [2]
      1, -- [3]
      83560, -- [4]
    }, -- [44]
    {
      236173, -- [1]
      6, -- [2]
      3, -- [3]
      53243, -- [4]
    }, -- [45]
    {
      236176, -- [1]
      7, -- [2]
      2, -- [3]
      53209, -- [4]
    }, -- [46]
    {
      236198, -- [1]
      3, -- [2]
      3, -- [3]
      53238, -- [4]
    }, -- [47]
    nil, -- [48]
    nil, -- [49]
    nil, -- [50]
    nil, -- [51]
    nil, -- [52]
    nil, -- [53]
    nil, -- [54]
    nil, -- [55]
    nil, -- [56]
    {
      236183, -- [1]
      1, -- [2]
      2, -- [3]
      52786, -- [4]
    }, -- [57]
    {
      136100, -- [1]
      2, -- [2]
      3, -- [3]
      19387, -- [4]
    }, -- [58]
    {
      236180, -- [1]
      1, -- [2]
      1, -- [3]
      56341, -- [4]
    }, -- [59]
    {
      132293, -- [1]
      2, -- [2]
      1, -- [3]
      19287, -- [4]
    }, -- [60]
    {
      132336, -- [1]
      3, -- [2]
      2, -- [3]
      19306, -- [4]
    }, -- [61]
    {
      132204, -- [1]
      1, -- [2]
      3, -- [3]
      82834, -- [4]
    }, -- [62]
    {
      236185, -- [1]
      3, -- [2]
      3, -- [3]
      56343, -- [4]
    }, -- [63]
    {
      132207, -- [1]
      4, -- [2]
      1, -- [3]
      34493, -- [4]
    }, -- [64]
    {
      133713, -- [1]
      4, -- [2]
      3, -- [3]
      56336, -- [4]
    }, -- [65]
    {
      132378, -- [1]
      5, -- [2]
      1, -- [3]
      82833, -- [4]
    }, -- [66]
    {
      135125, -- [1]
      5, -- [2]
      2, -- [3]
      19386, -- [4]
    }, -- [67]
    {
      236199, -- [1]
      2, -- [2]
      4, -- [3]
      53299, -- [4]
    }, -- [68]
    {
      236200, -- [1]
      5, -- [2]
      3, -- [3]
      53296, -- [4]
    }, -- [69]
    {
      236181, -- [1]
      5, -- [2]
      4, -- [3]
      53290, -- [4]
    }, -- [70]
    {
      236187, -- [1]
      6, -- [2]
      1, -- [3]
      53304, -- [4]
    }, -- [71]
    {
      136181, -- [1]
      7, -- [2]
      2, -- [3]
      3674, -- [4]
    }, -- [72]
    {
      304583, -- [1]
      4, -- [2]
      2, -- [3]
      83495, -- [4]
    }, -- [73]
    {
      132216, -- [1]
      3, -- [2]
      1, -- [3]
      34499, -- [4]
    }, -- [74]
    {
      132149, -- [1]
      2, -- [2]
      2, -- [3]
      63458, -- [4]
    }, -- [75]
    {
      132209, -- [1]
      6, -- [2]
      3, -- [3]
      87935, -- [4]
    }, -- [76]
    [85] = {
      "HunterBeastMastery", -- [1]
      "HunterMarksmanship", -- [2]
      "HunterSurvival", -- [3]
    },
  },
}
