--[[
	Player.lua
	实例化 模板并装载到TargetFrame上
	为其他子模块提供母模块
	Terry@bf
	2010 - 9 -30
]]

local T = LibStub("AceAddon-3.0"):GetAddon("TUnitFrame")
if not T then return end

local M = T:GetModule("Target",true) or T:NewModule("Target","AceHook-3.0")
if not M then return end

M.config = {
	self = 23,
	other = 17,
}

local __3DPor = T.Templates and T.Templates.ThreeDportrait and T.Templates.ThreeDportrait:new()
local __ClassIcon = T.Templates and T.Templates.ClassIcon and T.Templates.ClassIcon:new()
local config = M.config

function M:Toggle3DPor(flag)
	if flag then
		__3DPor:SetPoint("TOPLEFT", "TargetFrame", "TOPLEFT", 127, -17)
		__3DPor:Enable()
	else
		__3DPor:Disable()
	end
end

function M:ToggleClass(flag)
	if flag then
		__ClassIcon:Enable()
	else
		__ClassIcon:Disable()
	end
end

-- Blizzard_UnitFrame\Vanilla\TargetFrame.lua
local AURA_OFFSET_Y = 1;
local AURA_ROW_WIDTH = 122;
local NUM_TOT_AURA_ROWS = 2;
function M:TargetFrame_UpdateAuraPositions(...)
	local frame,auraName, numAuras, numOppositeAuras, largeAuraList, updateFunc, maxRowWidth, offsetX,mirrorAurasVertically = ...
	local size;
	local offsetY = AURA_OFFSET_Y;
	local rowWidth = 0;
	local firstBuffOnRow = 1;

	for i=1, numAuras do
		if ( largeAuraList[i] ) then
			size = config.self
			offsetY = AURA_OFFSET_Y + AURA_OFFSET_Y;
		else
			size = config.other
		end
		if ( i == 1 ) then
			rowWidth = size;
			frame.auraRows = frame.auraRows + 1;
		else
			rowWidth = rowWidth + size + offsetX;
		end
		if ( rowWidth > maxRowWidth ) then
			updateFunc(frame, auraName, i, numOppositeAuras, firstBuffOnRow, size, offsetX, offsetY, mirrorAurasVertically);
			rowWidth = size;
			frame.auraRows = frame.auraRows + 1;
			firstBuffOnRow = i;
			offsetY = AURA_OFFSET_Y;

			if ( frame.auraRows > NUM_TOT_AURA_ROWS ) then
				maxRowWidth = AURA_ROW_WIDTH;
			end
		else
			updateFunc(frame, auraName, i, numOppositeAuras, i - 1, size, offsetX, offsetY, mirrorAurasVertically);
		end
	end
end

function M:TargetFrame_UpdateAuras(frame, forceHide)
    local buffFrame, frameStealable, icon, debuffType, caster, isStealable, _
    local selfName = frame:GetName()
    local isEnemy = UnitIsEnemy(PlayerFrame.unit, frame.unit)

    local LARGE_AURA_SIZE = config.self
    local SMALL_AURA_SIZE = config.other
    local buffSize = 17

    -- Debuffs on top
    if (frame.maxDebuffs and frame.maxDebuffs > 0 and frame.buffsOnTop) then
        local _, fisrtDebuffIcon = UnitDebuff(frame.unit, 1)
        local _, fisrtBuffIcon = UnitBuff(frame.unit, 1)

        if (fisrtDebuffIcon and not fisrtBuffIcon) then
            local firstDebuffFrame = _G[selfName .. 'Debuff1']
            local point, relativeTo, relativePoint, xOffset, yOffset = firstDebuffFrame:GetPoint()

            firstDebuffFrame:ClearAllPoints()
            firstDebuffFrame:SetPoint(point, relativeTo, relativePoint, xOffset, yOffset + 8)
        end
    end

    for i = 1, MAX_TARGET_BUFFS do
        _, icon, _, debuffType, _, _, caster, isStealable = UnitBuff(frame.unit, i)

        if (icon and (not frame.maxBuffs or i <= frame.maxBuffs)) then
            local frameName = selfName .. 'Buff' .. i

            buffFrame = _G[frameName]

            -- Custom buff size
            if (icon and (not frame.maxBuffs or i <= frame.maxBuffs)) then
                if (caster == 'player') then
					buffSize = LARGE_AURA_SIZE
				else
					buffSize = SMALL_AURA_SIZE
				end

                buffFrame:SetHeight(buffSize)
                buffFrame:SetWidth(buffSize)
            end

            -- Buffs on top
            if (i == 1 and frame.buffsOnTop) then
                local point, relativeTo, relativePoint, xOffset, yOffset = buffFrame:GetPoint()

                buffFrame:ClearAllPoints()
                buffFrame:SetPoint(point, relativeTo, relativePoint, xOffset, yOffset + 8)
            end

            -- Stealable buffs
            if (forceHide) then
                frameStealable = _G[frameName .. 'Stealable']

                if (isEnemy and debuffType == 'Magic' and isStealable and not forceHide) then
                    local buffSize

                    if (db.general.customBuffSize) then
                        buffSize = db.general.buffSize * db.general.dispelledBuffScale
                    else
                        buffSize = DEFAULT_BUFF_SIZE * db.general.dispelledBuffScale
                    end

                    buffFrame:SetHeight(buffSize)
                    buffFrame:SetWidth(buffSize)

                    frameStealable:Show()
                    frameStealable:SetHeight(buffSize * 1.4)
                    frameStealable:SetWidth(buffSize * 1.4)
                elseif (forceHide) then
                    frameStealable:Hide()
                end
            end
        end
    end
end

function M:OnInitialize()
	assert(__3DPor,"Target 3D template does not exist.")
	__3DPor:Create("Target",TargetFrame,TargetFramePortrait or TargetPortrait)

	assert(__ClassIcon,"Target class icon template does not exist.")
	__ClassIcon:Create(TargetFrame,"target")
	__ClassIcon:SetPoint("TOPLEFT",TargetFrame,"TOPLEFT",107,2)

	T:Debug("Target Module Initialized")
end

function M:OnEnable()
	self:SecureHook("TargetFrame_UpdateAuraPositions")
	self:SecureHook("TargetFrame_UpdateAuras")
	T:Debug("Target Module Enabled")
end

function M:OnDisable()
	self:UnhookAll()
	T:Debug("Target Module Disabled")
end
