-------------------------------------------------------------------------------
-- AddOn namespace.
-------------------------------------------------------------------------------
local FOLDER_NAME, private = ...

local activeSeason = C_Seasons.GetActiveSeason()

-- CLASSIC
if (not activeSeason or activeSeason ~= Enum.SeasonID.SeasonOfDiscovery) then
	private.NPC_LOOT = {
		[10203] = {}; --Berylgos
		[10236] = {}; --Wep
		[10237] = {}; --Yor
		[10238] = {}; --Staggon
		[10239] = {}; --Tepolar
		[10818] = {}; --Death Knight Soulbearer
		[10819] = {}; --Baron Bloodbane
		[11580] = {}; --Kelemis the Lifeless
		[13977] = {20400}; --Gash'nak the Cannibal
		[14016] = {18335}; --Ushalac the Gloomdweller
		[14018] = {18335}; --Rezrelek <Winterax Hero>
		[14019] = {}; --Tatterhide
		[14341] = {}; --Felendor the Accuser
		[17075] = {18512}; --Sandworm
		[208842] = {}; --The Gardener <Gardener>
		[208843] = {}; --Abominable Snowman
		[208844] = {}; --Crimson Emissary
		[208845] = {}; --Par'kourc <Blackrock Clan Outrunner>
		[208846] = {}; --Sun Admirer
		[208847] = {}; --The Snatcher <Rascal>
		[228673] = {}; --Wandering Swordsman
		[5348] = {}; --Dreamwatcher Forktongue
		[5367] = {8705}; --Scillia Daggerquil
		[5789] = {}; --Serra Mountainhome <Ironforge Surveyor>
		[5790] = {}; --Lizzle Sprysprocket <Ironforge Surveyor>
		[5793] = {}; --Captain Armistice <Alliance Peacekeeper>
		[5794] = {}; --Thurmonde the Devout <Alliance Peacekeeper>
		[5795] = {}; --Grash Thunderbrew <Alliance Peacekeeper>
		[5796] = {}; --Ben <Grash Thunderbrew's Pet>
		[601] = {}; --Capo the Mean
		[8206] = {}; --Soul of Tanaris
		[9417] = {}; --Sleeping Dragon
		[203079] = {}; --Wandering Swordsman
		[204070] = {}; --Soboz
		[208124] = {}; --Raluk
		[5808] = {117,118,159,774,2589,3013,3609,3642,3650,4671,4870,6267,6269,6337,6506,6507,6508,6509,6510,6513,6514,6515,6517,6518,6519,6520,6521,7350,7351,8181,9742,9743,9744,9745,9750,9751,9752,9754,9758,9760,9761,14086,14087,14088,14089,14090,15003,15005,15007,15474}; --Warlord Kolkanis
		[5809] = {118,159,2070,2091,2589,4870,6506,6507,6508,6509,6510,6513,6514,6515,6517,6519,6520,6521,7350,7351,9745,15003,15007}; --Watch Commander Zalaphil
		[5822] = {117,118,159,818,1210,2589,3289,6266,6267,6268,6269,6336,6337,6506,6507,6509,6510,6512,6513,6514,6515,6517,6518,6519,6521,6549,6555,7350,7351,9742,9743,9744,9745,9746,9747,9750,9751,9752,9754,9755,9756,9758,9759,9760,9761,9762,9763,14110,15297,15302}; --Felweaver Scornn
		[5823] = {1475,2447,4867,4872,5466,6336,6506,6507,6509,6510,6513,6514,6515,6517,6518,6519,6521,6549,6555,7350,7351,9742,9744,9745,9746,9747,9750,9751,9754,9756,9761,9762,15302}; --Death Flayer
		[5824] = {1181,1495,1504,1511,1513,1515,1516,2214,2589,2777,3289,3375,4536,6266,6268,6336,6337,6506,6507,6509,6510,6513,6514,6515,6518,6519,6521,6549,6555,7350,9742,9745,9746,9747,9750,9752,9754,9761,9763,15479}; --Captain Flat Tusk <Captain of the Battleguard>
		[5826] = {118,159,774,818,1181,2589,3013,3190,3642,3649,4536,4671,4674,6267,6269,6337,6506,6507,6508,6509,6510,6513,6514,6515,6517,6518,6519,6520,6521,7350,7351,8180,8181,9742,9743,9744,9745,9750,9751,9752,9754,9758,9760,9761,14087,14088,15003,15005,15007,15477}; --Geolord Mottle
		[205382] = {}; --Mokwa
		[3056] = {1210,2075,2318,2672,2934,3192,3282,3286,3289,3290,3299,3300,3314,3609,3644,4561,4686,4854,5069,14099,14102,14110,15479,15480,15944,15969}; --Ghost Howl
		[3068] = {774,818,2318,2589,2672,2934,3189,3642,4563,4668,4671,4674,4675,4759,4806,4861,6267,6269,6337,6506,6507,6508,6509,6510,6513,6514,6515,6517,6518,6519,6520,6521,7097,7350,7351,9742,9743,9744,9745,9750,9751,9752,9754,9758,9760,9761,15003,15007,15475,15482}; --Mazzranache
		[5785] = {117,159,2589,2778,4772,4775,4776,6506,6507,6514,6517,6518,6519,6521,7351,9745,9754,9761,15483,17056}; --Sister Hatelash
		[5786] = {117,118,159,774,1181,2589,3013,3189,3286,3642,4563,4668,4671,4675,6267,6269,6337,6506,6507,6508,6509,6510,6513,6514,6515,6517,6518,6519,6520,6521,7350,7351,8180,8181,9743,9745,9750,9751,9752,9754,9758,9760,9761,14093,15003,15005,15007,15472,15475,15486}; --Snagglespear
		[5787] = {117,118,159,1181,1509,1515,2589,6266,6267,6268,6269,6336,6506,6507,6509,6510,6512,6513,6514,6515,6517,6518,6519,6521,6549,6555,7350,7351,9743,9744,9745,9746,9747,9751,9754,9755,9756,9760,9761,9762,9763,14097}; --Enforcer Emilgund
		[5807] = {774,2318,2406,2598,2934,3284,3312,3642,3644,4496,4669,4674,4813,4814,5571,8178,14086,14093,14094,14098,14099,15299,15479,15483,15484,17922}; --The Rake
		[3253] = {5058,5138,5268,5269}; --Silithid Harvester
		[3270] = {774,818,856,858,1179,1210,2073,2406,2455,2589,2632,3013,3036,3302,3306,3307,3308,3311,3314,4537,4567,4569,4570,4681,4687,4768,4771,5071,14097,14113,14114,14115,14116,14117,14119,14365,14561,14724,15011,15012,15013,15014,15268,15300,15303,15309,15491,15493,15495,15945}; --Elder Mystic Razorsnout
		[3295] = {3040,3195,3196,3670,4568,4575,6536,6538,6540,6545,6552,6553,6562,6563,6564,6575,6581,6583,6585,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9783,9784,9787,9788,9789,10407,14122,14131,14367,14370,14564,14727,15017,15114,15222,15310,15312,15497,15499,15502,15507}; --Sludge Beast
		[3398] = {2318,3010,4874,5182,5183,5523,17057}; --Gesharahan
		[3470] = {858,955,1179,1180,1495,1499,1501,1506,1507,1509,1511,1512,1513,1515,1516,1732,1734,2214,2455,2589,2763,2778,3375,4567,4569,4605,5071,5111,5112,14113,14116,15298,15485}; --Rathorian
		[5797] = {2589,2592,4538,10621}; --Aean Swiftriver <Alliance Outrunner>
		[5798] = {2589,2592,4538,9811}; --Thora Feathermoon <Alliance Outrunner>
		[5799] = {1205,1824,2589,2592,4306,4538}; --Hannah Bladeleaf <Alliance Outrunner>
		[5800] = {2589,2592,4542}; --Marcus Bel <Alliance Outrunner>
		[5827] = {2319,4715,5082,5121,5122,5467,6591,6593,6600,6602,6604,9796,9798,9803,9806,9807,9817}; --Brontus
		[5828] = {2319,2589,2592,3731,4306,5135,5136,6565,6566,6569,6573,6577,6580,6586,6588,9773,9774,9781,9782,9803,9811,9812,9817,10287,10405}; --Humar the Pridelord
		[5829] = {2318,2319,3299,3301,5635,6539,6540,6541,6545,6546,6547,6548,6551,6553,6554,6557,9770,9779,9780,9785,9786,9788,9789}; --Snort the Heckler
		[5830] = {858,1179,1180,2287,2455,2589,2592,4576,5635,6536,6538,6540,6545,6552,6553,6562,6563,6564,6565,6570,6574,6575,6576,6581,6582,6583,6585,9766,9767,9768,9770,9771,9772,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,9812,10287,10405,10407,14161,17056}; --Sister Rathtalon
		[5831] = {1206,5086,5119,5120,6562,6563,6564,6565,6581,6583,9776,9780,9783,9814,10407}; --Swiftmane
		[5832] = {2318,2319,4895,5128,5133,5470,6566,6568,6569,6577,6578,6579,6580,6586,6587,6593,9773,9774,9802,9803,9805,9810,9811,9814,9815}; --Thunderstomp
		[5834] = {2318,2319,6444,6566,6567,6568,6569,6579,6584,6587,6591,6593,6600,6604,6826,9792,9793,9794,9795,9796,9799,9801,9802,9805,9806,9810,9811,9813,9814,9815,9817,9818,17056}; --Azzere the Skyblade
		[5835] = {414,858,955,1179,1180,1816,2455,2589,2592,2781,3377,6536,6538,6540,6545,6552,6553,6562,6563,6564,6565,6570,6574,6575,6576,6581,6582,6583,6585,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,9812,10287,10405,10407,14367}; --Foreman Grills
		[5836] = {814,858,1179,1816,2287,2455,2589,2592,2764,4359,4364,6536,6538,6540,6545,6552,6553,6563,6564,6575,6583,9767,9768,9770,9771,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,10407,15497}; --Engineer Whirleygig
		[5837] = {818,858,955,1179,1180,1355,2287,2455,2589,2632,3307,3311,4570,5030,5071,5573,6537,6539,6540,6541,6542,6543,6545,6546,6547,6548,6549,6550,6551,6553,6554,6555,6556,6557,6558,9747,9748,9749,9756,9757,9763,9765,9779,9785,9786,9788,14115,14365,15011,15492}; --Stonearm
		[5838] = {1812,2287,2589,2592,5030,6539,6541,6545,6546,6547,6548,6551,6553,6554,7559,9779,9783,9785,9786,9788}; --Brokespear
		[5841] = {1812,2287,5030,6536,6539,6540,6541,6545,6546,6547,6548,6551,6553,6554,6557,9779,9785,9786,9788}; --Rocklance
		[5842] = {2318,2319,3180,5055,5062,5124,5635,6536,6538,6540,6545,6552,6553,6562,6564,6575,6582,6583,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9783,9784,9787,9788,9789,10407}; --Takk the Leaper
		[5847] = {1205,2035,2589,2592,4306,4542,4715,6566,6568,6573,6577,6579,6580,6584,6587,6602,9773,9793,9794,9802,9805,9810,9811,9814,9818}; --Heggin Stonewhisker <Bael'dun Chief Engineer>
		[5848] = {929,1205,1776,1778,1797,1818,1821,2589,2592,3012,4306,4542,4715,6566,6567,6568,6569,6579,6584,6587,6591,6593,6594,6595,6596,6597,6600,6601,6602,6604,6612,6613,9792,9793,9794,9795,9799,9801,9802,9803,9805,9806,9807,9810,9811,9813,9814,9815,9817,9818}; --Malgin Barleybrew <Bael'dun Morale Officer>
		[5849] = {1205,2589,2592,2771,2772,2836,2838,4306,4542,4785,6566,6568,6573,6578,6579,6580,6586,6587,6591,6604,9773,9782,9796,9799,9805,9810,9811,9814,9817}; --Digger Flameforge <Excavation Specialist>
		[5851] = {1478,1755,1827,2589,2592,3012,3210,4715,6594,6597,6600,6601,6603,6604,6605,6611,6614,9791,9795,9797,9799,9803,9806,9807,9809,9817,9831,9838,10404}; --Captain Gerogg Hammertoe <Bael'dun Captain of the Guard>
		[5859] = {2589,2592,4538,4715,6591,6593,6595,6601,6604,9795,9799,9801,9802,9803,9806,9807,9815,9817,9818}; --Hagg Taurenbane <Razormane Champion>
		[5863] = {858,1179,1210,1539,2078,2455,2589,2592,3610,4537,6342,6536,6538,6540,6545,6552,6553,6562,6563,6564,6570,6574,6575,6576,6581,6582,6583,6585,6661,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,10287,10405,10407,14160,14164}; --Geopriest Gukk'rok
		[5864] = {929,2589,2592,4306,4538,6562,6564,6565,6566,6573,6574,6578,6580,6582,6583,6587,6591,9772,9773,9774,9781,9812,10287,10405,10407}; --Swinegart Spearhide
		[5865] = {2934,3284,3644,3654,4569,4813,4893,5134,6266,6267,6268,6269,6336,6337,6512,6537,6539,6541,6542,6543,6548,6549,6555,6556,6557,6558,9742,9743,9744,9746,9747,9748,9750,9751,9752,9755,9756,9757,9758,9759,9760,9762,9763,9765,9786,15490}; --Dishu
		[7895] = {4306,4338,7353,7436,7444,7448,7456,9844,9856,9863,9864,9869,9870,9871,15550}; --Ambassador Bloodrage
		[14221] = {1707,1708,3505,4306,5113,6986,7369,7418,7434,7437,7438,7440,7446,7447,7448,7458,9844,9848,9849,9850,9854,9855,9856,9859,9861,9864,9870,9871,9877,9886,11985}; --Gravis Slipknot
		[14222] = {1686,1687,2319,5637,7353,7357,7369,7417,7418,7423,7434,7436,7437,7446,7447,7448,7461,8146,9819,9826,9844,9845,9846,9852,9853,9855,9861,9865,9868,9869,9871}; --Araga
		[14223] = {3712,4555,4556,5524,6308,6610,7353,7355,7357,7366,7370,7406,7407,7409,7410,7416,7421,7422,7423,7424,9825,9826,9828,9832,9833,9834,9836,9839,9842,9853,9869,10289,10406,10408,10409}; --Cranky Benj
		[14281] = {422,1205,1775,1777,2589,2592,4306,6565,6568,6573,6574,6576,6577,6578,6579,6580,6582,6584,6586,6587,6588,6591,9772,9774,9781,9782,9793,9801,9802,9803,9810,9814,10287,10405}; --Jimmy the Bleeder
		[2258] = {4553,7067,7431,7433,7434,7437,7438,7439,7440,7441,7443,7444,7445,7446,7447,7448,7454,7455,7457,7458,7459,7461,7462,7483,7492,7912,8150,9844,9848,9849,9850,9851,9852,9856,9859,9862,9863,9864,9866,9870,9871,9872,9875,9877,9879,9886,9889,9890,9896,9898}; --Stone Fury
		[2447] = {4304,4402,4460,6444,7487,7524,7532,7533,7544,8146,9907,9908,9910,9926,9931,9932,9934,9967}; --Narillasanz
		[2452] = {1708,1710,3011,3385,3771,4304,5637,6331,8146}; --Skhowl
		[2453] = {1678,3771,4306,4810,6327}; --Lo'Grosh
		[2598] = {1707,1708,1710,3778,3787,3797,3802,4306,4338,7455}; --Darbel Montrose <Shadow Council Warlock>
		[2600] = {1707,1708,1710,2592,3781,3794,3804,3827,4038,4306,4338,5180,5181}; --Singer
		[2601] = {3771,4306,4338}; --Foulbelly
		[2602] = {3385,3771,4306,4338}; --Ruul Onestone
		[2603] = {1708,1710,3771,4306,4338,4614,5256,7353,7369,7438,7446,7448,7454,7459,7461,7462,9845,9846,9848,9849,9856,9859,9864}; --Kovork
		[2604] = {4306,4338,7431,7440,7445,7454,7489,7492,9287,9288,9875,9876,9879,9886,9891,9896,9898}; --Molok the Crusher
		[2605] = {4306,4503,7273,7483}; --Zalas Witherbark <Warband Leader>
		[2606] = {1708,1710,2622,3385,3771,3781,3816,4306,4338,5257,8151,9848,11166}; --Nimar the Slayer <Warband Leader>
		[2609] = {1708,1710,4306,4338}; --Geomancer Flintdagger
		[2779] = {1404,7072,7472,7478,7973,9285,17058}; --Prince Nazjak
		[14224] = {1645,3928,4005,4306,4338,4601,7191,7429,7469,7472,7473,7475,7476,7479,7484,7485,7487,7490,7493,7494,9061,9285,9287,9288,9289,9290,9291,9292,9876,9878,9881,9883,9885,9893,9894,9900,9902,9903,9904,9906,9925,9926,9929,9934,9968,9972,9973,10505,10561}; --7:XT <Long Distance Recovery Unit>
		[218273] = {}; --Wandering Swordsman
		[2744] = {1708,4306,4338,4616,7430,7454,7474,7475,7490,7492,7494,9889,9900}; --Shadowforge Commander
		[2749] = {3804,4552,4554,7429,7455,7470,7471,7474,7476,7479,7483,7490,7912,8163,9287,9875,9876,9879,9880,9885,9892,9895,9896,9901,9904,9909,9929}; --Siege Golem
		[2751] = {4552,4553,7353,7369,7407,7418,7434,7436,7437,7438,7443,7446,7447,7448,7457,7461,7912,8150,9845,9846,9848,9850,9852,9855,9856,9859,9863,9864,9868,9869,9870,9871,9872}; --War Golem
		[2752] = {4552,4554,4784,7067,7075,7468,7477,7525,7534,7535,7545,7848,7912,8120,8150,9921,9923,9925,9928,9933,9951,9970,10088}; --Rumbler
		[2754] = {4552,4554,7332,7468,7486,7525,7529,7534,7543,7544,7912,8120,8150,9912,9916,9921,9923,9928,9933,9959,9966,9970,10088,10089}; --Anathemus
		[2850] = {1688,4304,4580,7434,7438,7443,7444,7447,7454,7455,7457,7458,7459,7462,8146,9848,9849,9850,9851,9852,9856,9862,9863,9864,9870,9871,9872,9875,9877,9890}; --Broken Tooth
		[2931] = {2772,3404,3818,5117,10057,10091,10099,10100,10103,10106,10107,10109,10110,10113,10122,10123,10126,10167,10170,10171,10172,10175,10179,10183,10187,10189,10193,10199,10229,10231,10276,10278,11417,11419,11420,12037,12207,15420}; --Zaricotl
		[7057] = {1708,1710,2289,3771,3779,3783,3785,3797,3799,3805,3810,3813,3817,4306,4338,6412,6416,7458,7462,7909,9375,9378,9382,9881,12040}; --Digmaster Shovelphlange
		[14697] = {12841,22484,23090,23091,23092,23093}; --Lumbering Horror
		[16379] = {12841,22484,23090,23091,23092,23093}; --Spirit of the Damned
		[16380] = {12841,22484,23090,23091,23092}; --Bone Witch
		[8296] = {3961,4338,4422,4599,7519,7520,7528,7529,7539,7543,9938,9941,9945,9947,9948,9949,9962,10061,10067,10071,10075,10086,10092,10131,10201,10202,10206,10207,10209,10243}; --Mojo the Twisted
		[8297] = {10095,10106,10110,10119,10121,10124,10125,10168,10170,10175,10177,10229,14047}; --Magronos the Unyielding
		[8298] = {8952,9943,10064,10095,10096,10103,10107,10108,10109,10110,10120,10128,10166,10168,10173,10175,10176,10179,10183,10186,10199,10200,10229,10231,10241,10244,10276,10277,13443,14047,19260}; --Akubar the Seer
		[8299] = {1464,3404,5117,8146,8168,8396,10063,10073,10075,10084,10085,10133,10134,10173,10174,10176,10180,10190,10197,10203,10239,10240,10242,11417,11419,11420,12037,12207,15420}; --Spiteflayer
		[8300] = {4583,4584,8146,8391,10061,10073,10075,10083,10132,10134,10173,10185,10191,10239,12037,12203,12208,15294}; --Ravage
		[8301] = {8154,8170,8393,9943,9950,10064,10073,10077,10082,10085,10098,10108,10120,10166,10167,10174,10179,10186,10189,10190,10197,10198,10199,10200,10238,10241,12037,15408,19933,19934}; --Clack the Reaver
		[8302] = {4092,4093,4304,7528,8146,8394,9945,9947,9948,9952,9957,9964,9965,10060,10076,10080,10133,10174,10207,10593,11386,11387}; --Deatheye
		[8303] = {2295,3403,4304,7517,7527,8170,8392,9940,9952,9953,9954,9964,9965,10059,10060,10066,10076,10080,10081,10127,10133,10196,10203,10208,10209,10243}; --Grunter
		[8304] = {8766,8952,10095,10097,10100,10106,10111,10113,10119,10121,10123,10124,10169,10170,10177,10188,10212,10225,10233,10277,14047}; --Dreadscorn
		[10356] = {2672,2962,3299,3300,6266,6336,6507,6508,6509,6513,6514,6515,6517,6518,6519,6520,6521,7350,9744,9750,9758,9759,9761}; --Bayne
		[10357] = {2318,4865,6267,6269,6293,6296,6336,6506,6507,6509,6510,6512,6513,6514,6515,6517,6518,6519,6521,7073,7074,7350,7351,9742,9743,9745,9751,9752,9754,9755,9756,9758,9760,9761,9762,12223}; --Ressan the Needler
		[10358] = {118,159,1181,2589,3013,4561,4604,6266,6267,6268,6269,6336,6337,6506,6510,6512,6515,6518,6521,6537,6542,6543,6549,6550,6555,6556,6558,7351,9742,9743,9744,9745,9746,9747,9748,9749,9750,9751,9752,9754,9755,9756,9757,9758,9759,9760,9761,9762,9763,9765}; --Fellicent's Shade
		[10359] = {1475,1476,3192,4684,4690,5465,6266,6267,6268,6269,6336,6337,6512,6537,6549,6550,6555,6557,9743,9744,9746,9747,9750,9751,9752,9755,9756,9757,9758,9759,9760,9762,9763,9765,9786}; --Sri'skulk
		[1531] = {118,159,766,774,805,818,1181,1411,1412,1413,1414,1415,1416,1417,1418,1421,1422,1425,1427,1429,1430,1431,2138,2212,2213,2589,2598,2635,2642,2643,2644,2645,2773,2774,3013,3189,3322,3373,3609,4496,4560,4563,4565,4604,5571,8177,8178,8179,8181,8182}; --Lost Soul
		[1533] = {118,159,1181,1411,1412,1413,1414,1415,1416,1417,1418,1421,1422,1423,1425,1427,1430,1433,2138,2212,2589,2598,2635,2642,2773,2960,2962,2964,2968,3013,3190,3323,3370,3373,4496,4562,4563,4604,4659,4662,4663,4666,5571,6269,6513,6520,6521,7109,8178,8181}; --Tormented Spirit
		[1910] = {118,159,727,779,1414,1431,2958,2960,2962,3013,3214,4302,4562,5069,5523,6266,6267,6268,6269,6303,6337,6506,6507,6508,6509,6510,6512,6513,6514,6515,6517,6518,6519,6520,6521,7350,7351,8178,9742,9743,9744,9745,9750,9751,9752,9754,9755,9758,9760,9761}; --Muad
		[1911] = {118,159,779,1181,1497,1498,1509,1510,1513,1514,1732,2763,2778,3013,4303,5523,6266,6267,6269,6303,6337,6506,6510,6512,6515,6518,6521,6542,6543,6549,6555,6556,7351,9742,9743,9744,9745,9746,9747,9749,9750,9751,9752,9756,9757,9758,9759,9760,9761,9763}; --Deeb
		[1936] = {118,159,727,767,774,818,1411,1412,1413,1414,1415,1416,1417,1418,1420,1421,1423,1425,1427,1429,1430,1431,1433,2070,2091,2138,2212,2213,2589,2643,2644,2645,2646,2648,2773,2774,3013,3190,3334,3370,3373,3610,4261,4536}; --Farmer Solliden
		[12431] = {1210,2318,2672,3164,3299,3300,4684,4701,6266,6267,6268,6269,6336,6337,6512,6537,6539,6541,6542,6543,6548,6549,6550,6555,6556,6557,6558,9742,9743,9744,9746,9747,9748,9749,9750,9751,9752,9755,9756,9757,9758,9759,9760,9762,9763,9765,9786}; --Gorefang
		[12432] = {1210,2318,2934,2940,3169,3170,3173,3253,4569,5635,6266,6268,6336,6512,6537,6539,6541,6542,6543,6546,6547,6548,6549,6550,6551,6554,6555,6556,6557,6558,9746,9747,9748,9749,9755,9756,9757,9759,9762,9763,9765,9785,9786,11406}; --Old Vicejaw
		[12433] = {1475,2972,3167,3174,3254,3651,5465,6537,6539,6540,6541,6542,6543,6545,6546,6547,6548,6549,6550,6551,6553,6554,6555,6556,6557,6558,6560,9747,9748,9749,9756,9757,9763,9765,9779,9785,9786,9788,15268}; --Krethis Shadowspinner
		[1920] = {414,1179,2589,2592,4436,4437,5110,8491}; --Dalaran Spellscribe
		[1944] = {858,1179,1752,2589,2592,3236,4439,4605,4710,5376,5975,6584,16882}; --Rot Hide Bruiser
		[1948] = {858,1179,2455,2589,2592,4445,4605,6565,6566,6573,6574,6582,6586,6588,9772,9773,9774,9795,9810,9813,9815}; --Snarlmane
		[2283] = {1179,2589,2592,4605,5969,6628}; --Ravenclaw Regent
		[1837] = {8932,10144,10145,10147,10156,10219,10225,10258,10376,10380,10391,14047}; --Scarlet Judge
		[1838] = {8932,10149,10154,10161,10247,10273,10373,10378,10380,10383,14047}; --Scarlet Interrogator
		[1839] = {8932,10135,10142,10150,10151,10152,10162,10163,10220,10247,10250,10252,10253,10260,10261,10262,10263,10264,10265,10266,10269,10270,10272,10273,10274,10378,10382,10384,10388,10389,10390,14047,14555}; --Scarlet High Clerist
		[1841] = {8932,10105,10144,10210,10228,10230,10258,10275,14047}; --Scarlet Executioner
		[1843] = {8932,10137,10151,10378,10386,14047}; --Foreman Jerris
		[1844] = {10101,10181,10210,10216,10221,12836,14047}; --Foreman Marcrid
		[1847] = {6530,7972,8948,9954,10064,10073,10075,10082,10085,10122,10133,10174,10175,10190,10191,10196,10197,10198,10242,10243,12840,13356,14047}; --Foulmane
		[1848] = {8766,8932,10091,10095,10106,10121,10124,10125,10168,10170,10177,10188,10189,10229,10231,10276,10278,10282,12841,14047}; --Lord Maldazzar
		[1849] = {12841,13354,20400}; --Dreadwhisper
		[1850] = {12843,13356,14047}; --Putridius
		[1851] = {2450,4625,8836,10139,10146,10149,10153,10215,10220,10227,10248,10255,10268,10286,10378,10382,10386,12803}; --The Husk
		[1885] = {10118,10155,12719,14047}; --Scarlet Smith
		[10817] = {10122,10167,10240,14047}; --Duggan Wildhammer
		[10820] = {}; --Duke Ragereaver
		[10821] = {8766,8952,10100,10111,10113,10119,10123,10136,10138,10168,10169,10177,10219,10221,10223,10234,10277,10280,10381,12843,14047}; --Hed'mush the Rotting
		[10822] = {10100,10105,10113,10119,10123,10148,10159,10164,10181,10212,10219,10221,10222,10224,10232,10235,10237,10277,10279,10308,10377,10387,12804,14047}; --Warlord Thresh'jin
		[10823] = {3950,10145,10159,10214,10222,10269,12804,14047}; --Zul'Brin Warpbranch
		[10824] = {8766,8953,10105,10136,10144,10147,10222,10225,10228,10235,10249,10380,14047}; --Ranger Lord Hawkspear
		[10825] = {4552,4554,8146,10106,10193,10229,10276,12843}; --Gish the Unmoving
		[10826] = {7972,8766,8948,10111,10112,10119,10169,10223,12808,12843,14047,15043,16039,22526}; --Lord Darkscythe
		[10827] = {8766,8932,10057,10095,10106,10111,10113,10119,10125,10165,10168,10170,10177,10188,10193,10233,10240,10276,10282,14047}; --Deathspeaker Selendre <Cult of the Damned>
		[10828] = {8766,8932,10104,10138,10145,10154,10214,10222,10223,10235,10256,10281,10377,10381,14047,16885}; --High General Abbendis
		[14275] = {929,1205,1206,2592,3053,3693,4306,4542,4715,6590,6591,6592,6594,6595,6596,6597,6600,6601,6602,6603,6605,6607,6611,6612,6613,6614,6615,6617,7356,7415,7416,7419,9791,9796,9797,9806,9807,9808,9809,9821,9822,9823,9827,9829,9831,9837,9838,9839,9840,10404}; --Tamra Stormpike
		[14276] = {929,1205,3510,3716,5524,5785,6308,6590,6592,6603,6607,6611,6615,6616,6617,7355,7356,7366,7370,7411,7412,7413,7415,7416,7419,7421,7422,7424,9791,9798,9820,9821,9823,9825,9827,9829,9831,9832,9837,9838,9839,9841,9842,9847,9867,10404,10408,11152,17057,17058}; --Scargil
		[14277] = {1205,3509,5504,6308,6609,6616,7072,7354,7357,7366,7367,7406,7407,7408,7409,7412,7413,7414,7418,7420,7421,7422,7423,7424,7437,7448,7460,9819,9824,9825,9826,9833,9834,9835,9836,9841,9842,9845,9849,9857,9860,9861,9865,9867,9868,10406,10408,10409,17057,17058}; --Lady Zephris
		[14278] = {1205,2592,3385,3770,4306,4715,6211,6590,6591,6594,6595,6596,6597,6600,6601,6602,6605,6611,6612,6613,6614,7411,9796,9797,9798,9806,9807,9808,9809,9821,9822,9831,9837,9838,9839}; --Ro'Bark
		[14279] = {878,1081,1288,2251,3182,3477,4428,4715,6566,6567,6568,6578,6579,6580,6586,6587,6588,9773,9774,9782,9792,9796,9799,9802,9803,9805,9807,9810,9811,9814,9817,9818}; --Creepthess
		[14280] = {2319,2940,3476,3702,3730,4715,5635,6591,6593,6600,6602,6604,6605,9795,9796,9799,9802,9803,9806,9807,11406,11407}; --Big Samras
		[221333] = {}; --Doomkin
		[8210] = {5636,7491,7524,9959,9967,11417,12207}; --Razortalon
		[8211] = {4304,4583,4584,7470,7471,7479,7482,7488,8146,9285,9289,9874,9897,9903,9968,9973,12203,12208}; --Old Cliff Jumper
		[8212] = {3669,3670,3671,3673,3674,3676,3818,3928,4608,7296,7528,9941,9948,9953,9964,9965,10060,10066,10069,10076,10080,10085,10086,10127,10130,10131,10134,10201,10205,20763,20767}; --The Reak
		[8213] = {3712,4304,4555,4556,4603,7973,8167,8170,10061,10062,10063,10075,10129,10131,10132,10185,10191,10196,10243}; --Ironback
		[8214] = {1645,3928,4338,4602,7528,9913,9924,9936,9939,9941,9948,9949,9962,9963,9964,9965,10059,10060,10066,10067,10071,10076,10079,10086,10091,10127,10205,10207,10208}; --Jalinde Summerdrake
		[8215] = {4552,4554,7517,7527,7910,7912,8150,8924,9940,9953,9955,9965,10059,10062,10067,10071,10080,10086,10127,10129,10131,10134,10194,10196,13464}; --Grimungous
		[8216] = {1520,1645,4338,4599,7519,7528,7529,7532,7538,8151,8153,9259,9905,9913,9924,9937,9938,9945,9948,9949,9951,9963,10066,10079,10201,10202}; --Retherokk the Berserker
		[8217] = {1520,4338,4599,8152,8153,9259,10063,10083,10085,10174,10180,10185,10190,10196,10203,10238,10242,17050}; --Mith'rethis the Enchanter
		[8218] = {1520,3928,4306,4338,4599,7332,7486,7522,7525,7526,7533,7534,7535,7542,7543,7545,8120,8151,8153,9286,9906,9907,9913,9915,9921,9922,9923,9928,9959,9970,10087,10094,10201}; --Witherheart the Stalker
		[8219] = {1520,1645,3928,4306,4338,4599,7490,7491,8151,8153,9259,9286,9291,9874,9884,9887,9908,9909,9919,9926,9930,9931,9967,9969,9971}; --Zul'arek Hatefowler
		[1119] = {117,118,159,763,1181,1499,1501,1502,1509,1510,1511,1512,1513,1514,1516,1737,2214,2254,2406,2589,2763,2777,2778,3013,3375,4684,5069,9755,9757}; --Hammerspine
		[1130] = {2069,2318,2940,3169,3170,3173,3192,5069,5635,6266,6267,6268,6269,6336,6337,6506,6510,6512,6515,6518,6521,6537,6549,6550,6555,7351,9742,9743,9744,9745,9746,9747,9749,9750,9751,9752,9754,9755,9756,9757,9758,9759,9760,9761,9762,9763,9765,11406}; --Bjarn
		[1132] = {1965,2318,2672,2934,3224,3299,3300}; --Timber
		[1137] = {117,118,159,767,768,774,818,1181,1411,1413,1414,1417,1418,1419,1427,1431,1433,1438,2212,2318,2642,2645,2671,2773,2774,2934,2967,2968,3008,3214,3225,3370,4562,6520,7109,9750}; --Edan the Howler
		[1260] = {117,118,159,1181,1497,1499,1502,1506,1510,1511,1513,1516,1730,2075,2140,2214,2546,2589,2763,2777,2958,2965,2972,3013,3223,4561,6510,6513,7108,9745,9750}; --Great Father Arctikus
		[208812] = {}; --Jorul
		[8503] = {118,159,1495,1497,1501,1503,1504,1506,1510,1511,1512,1513,1514,1515,1516,1732,1733,1734,2408,2589,2598,2763,2777,2964,3013,3083,3084,3375,4540,4561,4562,6510,7351,9747,9754,9763,10553,10554}; --Gibblewilt
		[228721] = {}; --Lieutenant Skarresh
		[228728] = {}; --Flamebringer Kelris <Twilight Lord>
		[228969] = {}; --Lord Gazzran
		[228970] = {}; --Galenges
		[8277] = {1074,4337,4585,7517,7519,7527,7528,7529,7539,8122,9913,9924,9936,9937,9938,9941,9947,9949,9951,9961,9964,10060,10067,10076,10079,10091,10201,10202,10209,10285,12205,14227}; --Rekk'tilac
		[8278] = {4552,4554,4784,7067,7075,7527,7848,7912,8150,9940,9955,9964,10059,10061,10066,10068,10081,10085,10129,10194,10205,10208,10242,22527}; --Smoldar
		[8279] = {4552,4554,7332,7477,7519,7520,7521,7522,7523,7526,7529,7530,7531,7535,7540,7541,7542,7543,7545,7546,7912,8120,8150,9912,9913,9915,9921,9922,9923,9933,9936,9938,9941,9947,9948,9951,9952,9956,9962,9966,10060,10067,10086,10087,10089,10090,10127,10201}; --Faulty War Golem
		[8280] = {5120,7519,7526,7529,7531,7535,7538,7539,7541,7543,9922,9948,9951,9960,9961,9962,10090,10091,10092,10127,10130,10201,10205,10206,10208,12683}; --Shleipnarr
		[8281] = {3857,4787,7068,7517,9924,9948,9955,10127,10129,10130,10185,10207,10509,11129}; --Scald
		[8282] = {3928,3970,3997,4338,4602,6149,8316,8754,9943,9953,9955,10062,10068,10074,10174,10186,10194,10196,10243,13824,13825}; --Highlord Mastrogonde
		[8283] = {1645,3928,4338,4601,7527,9940,9957,10058,10080,10081,10130,10131,10208,10209}; --Slave Master Blackheart
		[10077] = {4304,4583,4584,8146,9950,10073,10174,10184,10241,11467,12203,12208}; --Deathmaw
		[10078] = {8146,8766,8952,10091,10096,10099,10103,10106,10107,10110,10122,10125,10126,10128,10165,10167,10169,10170,10172,10175,10177,10179,10187,10189,10199,10223,10231,10240,10244,10276,12662,14047,14256,22338}; --Terrorspark
		[10119] = {3857,4787,7067,7068,7075,7076,7077,7078,10105,10136,10144,10147,10156,10159,10210,10211,10219,10222,10228,10230,10258,10267,10275,10280,10376,10379,10380,10381,10391,12828}; --Volchan
		[208841] = {}; --Revered Champion
		[8976] = {4304,4460,4557,8146,8170,10104,10136,10138,10146,10147,10156,10211,10225,10228,10230,10236,10263}; --Hematos
		[8978] = {8950,10106,10111,10113,10121,10123,10124,10159,10168,10169,10212,10229,10233,10276,10277,10282,14047}; --Thauris Balgarr
		[8979] = {8766,8952,10101,10104,10105,10112,10138,10145,10159,10211,10214,10216,10222,10226,10228,10234,10235,10236,10280,10380,10381,14047}; --Gruklash
		[8981] = {4552,4554,7912,8150,8838,10095,10101,10106,10110,10113,10119,10121,10122,10123,10125,10145,10164,10168,10170,10175,10177,10188,10223,10229,10231,10233,10276,10278,10282,11266}; --Malfunctioning Reaver
		[9602] = {8766,8952,10064,10077,10096,10098,10103,10107,10109,10122,10126,10128,10176,10179,10183,10199,10231,10244,14047}; --Hahk'Zor
		[9604] = {8766,8952,10096,10107,10109,10126,10183,10199,10200,14047}; --Gorgon'och
		[100] = {117,118,159,818,1181,1210,1307,1495,1498,1499,1501,1503,1504,1510,1511,1512,1513,1514,1515,1516,1730,1733,1735,2075,2214,2215,2589,2763,2777,3013,3374,4677,4689,4690,5069,5071,6269,6506,6550,9742,9746,9747,9756,9760}; --Gruff Swiftbite
		[471] = {727,768,774,1476,2598,2961,2963,2966,2967,2968,3000,3174,3214,4536,4562,4663,4666,5465,5572,6148,6269,6336,6506,6509,6510,6514,6517,6519,6520,8178,8180,8181,9744,9753,9759,9762,15925}; --Mother Fang
		[472] = {117,159,2589,3233,5744}; --Fedfennel
		[61] = {118,159,727,1181,1495,1497,1498,1501,1502,1505,1506,1509,1510,1511,1512,1513,1514,1515,1516,1731,1732,1734,1737,2070,2215,2589,2763,2777,2778,2958,2961,2964,3013,3374,3375,4561,4569,6202,6203,6267,6507,6509,6514,6515,6519,6716,9745,9753,9755}; --Thuros Lightfingers
		[79] = {118,159,727,774,1414,1416,1418,1420,1421,1422,1425,1431,1913,2075,2138,2212,2589,2645,2646,2648,2774,2960,2962,2963,2964,2967,3013,3192,3373,4536,4561,4577,4663,4666,5572,6147,6269,6336,6507,6509,6514,6515,6517,7108,8178,8181,9745,9746,9750,15925}; --Narg the Taskmaster
		[99] = {118,159,727,768,774,818,1411,1413,1415,1419,1420,1431,1917,2070,2075,2091,2138,2140,2589,2598,2646,2648,2958,2959,2963,2964,2968,3013,3192,3370,4562,4563,4663,4666,5069,6201,6266,6267,6268,6269,6509,6514,6519,6520,7350,8178,8181,9743,9744,15895}; --Morgaine the Sly
		[503] = {929,1187,1205,2592,3783,3786,4306,4462,4606,6530,8746,15231}; --Lord Malathrom
		[507] = {929,1205,2319,2794,3385,3793,4474,4606,5637,6204}; --Fenros
		[521] = {1015,2318,2319,3018,3227,3301,3402,5635,11982,14175}; --Lupos
		[534] = {929,1205,1478,1712,2319,3770,3780,3785,3806,3816,4476,4477,5637,9850}; --Nefaru
		[574] = {878,1074,1081,1130,1288,2251,3174,3182,4448,4449}; --Naraxis
		[771] = {1205,2592,2794,4306,4464,4465,4606}; --Commander Felstrom
		[1398] = {1179,1215,1938,2287,2589,2592}; --Boss Galgosh <Stonesplinter Chieftain>
		[1399] = {1179,2241,2287,2589,2592,3571}; --Magosh <Stonesplinter Tribal Shaman>
		[1425] = {858,1179,1180,1495,1499,1501,1502,1511,1513,1516,1731,1734,2214,2284,2408,2455,2589,2700,2763,3013,3036,3374,3375,4537,4570,6195,6342,6543}; --Grizlak
		[14266] = {1081,1475,2606,2988,3174,3931,4575,5465,6536,6538,6540,6545,6552,6553,6562,6563,6564,6570,6574,6575,6576,6581,6582,6583,6585,9766,9767,9768,9770,9771,9772,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,10287,10405,10407}; --Shanda the Spinner
		[14267] = {929,1205,1206,1210,2589,2592,2607,2821,3196,3211,3385,3770,4306,6536,6538,6540,6545,6552,6553,6562,6563,6564,6565,6574,6575,6576,6581,6582,6583,6585,6591,9766,9767,9768,9770,9771,9772,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,9812,10407}; --Emogg the Crusher
		[14268] = {556,2700,2970,2977,3645,3882,4775,4776,5114,5115,5573,6537,6538,6539,6540,6541,6542,6543,6545,6546,6547,6548,6549,6550,6551,6553,6554,6555,6556,6557,6558,6889,9747,9748,9749,9756,9757,9763,9765,9768,9770,9779,9784,9785,9786,9788,15926,17056}; --Lord Condar
		[2476] = {2318,2319,2924,2925,2939,3181,3401,3563,6197,14170}; --Large Loch Crocolisk
		[14269] = {6562,6563,6564,6565,6568,6573,6574,6575,6576,6577,6578,6581,6582,6583,6585,7091,9451,9766,9772,9774,9782,10405,10407}; --Seeker Aqualon
		[14270] = {730,858,1179,1210,1467,1468,1469,2455,4575,5523,5784,6289,6536,6538,6540,6545,6552,6553,6562,6563,6564,6565,6570,6574,6575,6576,6581,6582,6583,6585,9766,9767,9768,9770,9771,9772,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,10287,10405,10407}; --Squiddic
		[14271] = {858,955,1013,1179,1212,1214,2287,2455,2589,2592,2856,2987,4695,4697,6378,6536,6538,6539,6540,6541,6545,6546,6547,6548,6551,6552,6553,6554,6557,6575,6585,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9783,9784,9785,9786,9787,9788,9789,14167,14173}; --Ribchaser
		[14272] = {1206,1210,1221,3176,3177,5635,6536,6538,6540,6545,6546,6547,6551,6552,6553,6554,6562,6563,6564,6575,6581,6583,6585,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9783,9784,9785,9787,9788,9789,10407}; --Snarlflare
		[14273] = {4715,5741,6566,6567,6568,6569,6579,6584,6587,6591,6593,6604,9792,9793,9794,9795,9799,9801,9802,9803,9806,9807,9810,9811,9813,9814,9815,9817,9818}; --Boulderheart
		[214456] = {}; --Dro'zem the Blasphemous
		[584] = {929,1205,1805,1828,2058,2589,2592,3231,3385,3770,4306}; --Kazon
		[616] = {878,1081,1288,2251,3174,3182,3229,4428,6565,6566,6568,6569,6573,6577,6578,6580,6582,6586,6587,6588,9772,9773,9774,9782,9805,9811,9812,10287}; --Chatter
		[947] = {929,1075,1782,2589,2592,3012,3385,3770,4306,4446,4447,9792}; --Rohh the Silent
		[14487] = {5785,6362,7433,7434,7457,7462,9864,9872,9889,9890,17057,17058}; --Gluggle
		[14488] = {1708,2734,2738,3771,4306,4338,7433,7434,7435,7440,7441,7443,7445,7456,7459,7493,9289,9862,9866,9871,9877,9879,9886,9890,9895,9898,9901,9904}; --Roloch
		[14490] = {4860,6308,7541,9919,17057}; --Rippa
		[14491] = {2799,4096,4099,4304,5637,7470,7471,7472,7473,7486,7487,7488,7490,7491,7494,7524,9285,9288,9289,9290,9292,9874,9878,9884,9887,9893,9903,9909,9926,9927,9928,9931,9972,9973}; --Kurmokk
		[14492] = {1630,2749,3917,4306,4338,4599,7479,7481,7482,7485,9290,9292,9883,9893,9897,9903,9908,9927,9968,9972}; --Verifonix <The Surveyor>
		[1552] = {1604,4092,4093,4304,4478,8146,11386,11387}; --Scale Belly
		[2541] = {1645,2728,3928,4603,5028,5029,7973}; --Lord Sakrasis
		[723] = {1680,3930,4306,4338,7486,7524,9906,9908}; --Mosh'Ogg Butcher
		[9046] = {8766,8952,14047,18987}; --Scarshield Quartermaster <Scarshield Legion>
		[1063] = {4304,4402,4460,4557,7517,7519,7521,7528,7529,7530,7532,7535,7540,7541,7543,7546,8146,8170,9922,9951,9956,9960,9961,9963,10086,10087}; --Jade
		[1106] = {1708,1710,3771,4306,4338,7444,7458,7462,9863,9871,9872}; --Lost One Cook
		[14445] = {3358,4021,4304,4599,5803,7332,7468,7477,7524,7525,7534,7535,7540,7541,7545,8120,9915,9916,9917,9921,9923,9959,9966,10088,10089,10090,10094}; --Lord Captain Wyrmak
		[14446] = {1645,4603,7470,7478,7479,7482,7487,7488,7491,7533,7973,8120,9290,9291,9292,9874,9884,9887,9907,9908,9909,9917,9920,9926,9930,9931,9934,9959,9967,9968,9969,9971,17058}; --Fingat
		[14447] = {1645,3928,4603,7469,7478,7481,7487,7973,9290,9874,9887,9893,9908,9909,9919,9922,9926,9927,9930,9931,9932,9933,9967,9969,9972,10090,10094,17058}; --Gilmorian
		[14448] = {2453,3357,3818,4608,5608,6065,7470,7471,7472,7479,7481,7482,7490,8831,9285,9290,9893,9904,9926,9927,9929,9968,9973,10286}; --Molt Thorn
		[763] = {1708,1710,3771,4306,4338,7454,7455,7459,9879,9886,9891}; --Lost One Chieftain
		[1424] = {818,858,1179,1180,1210,1497,1498,1499,1506,1509,1510,1511,1515,1516,1731,1732,1735,2455,2589,2657,2770,2771,2836,2980,3036,3375,4537,4570,4571,5071,6205,6206,6555,6556,9763}; --Master Digger
		[462] = {555,729,2447,4454,5114,5115,5116,5636,5971,8183,11416,17056}; --Vultros
		[506] = {725,1179,2203,2204,2287,2589,2592,2770}; --Sergeant Brashclaw
		[519] = {730,774,858,1179,1210,1357,1497,1498,1501,1506,1509,1510,1511,1512,1513,1514,1515,1516,1730,1731,1732,1733,2073,2215,2763,2777,2778,2984,3013,3188,3374,3645,4570,5503,5523,5573,6180,6289,6378,6537,6556,9765,9786,15268,15926}; --Slark
		[520] = {730,858,1179,1180,1357,1742,1743,1745,1764,1766,1767,1768,1769,1770,1787,1789,1811,1814,1815,1816,1817,2217,2235,2455,2764,2780,2781,2987,3376,4345,4699,5503,5523,5784,6179,6289,9787,14166}; --Brack
		[572] = {1179,1314,1387,2085,2589,2592,4605,6530}; --Leprithus
		[573] = {732,814,933,1274,4359,4361,4363,4434}; --Foe Reaper 4000
		[1037] = {929,1205,2592,3337,3770,4306,4715,6587,6590,6592,6603,6607,6611,6617,7131,7355,7356,7366,7370,7408,7409,7411,7412,7415,7416,7419,9791,9795,9798,9805,9817,9821,9822,9823,9824,9825,9827,9829,9832,9837,9838,9840,9841,9842,9847,10289,10404,10406,10408,10409}; --Dragonmaw Battlemaster
		[1112] = {878,1081,1288,2251,3174,3182,4428,4444,6199}; --Leech Widow
		[1140] = {1696,1697,3685,4461,4463,5635,6198,12184}; --Razormaw Matriarch
		[14424] = {765,785,929,954,1205,1801,2447,2449,2450,2452,2453,4606,4709,4715,6566,6567,6568,6569,6579,6584,6587,6591,6593,6595,6596,6600,6602,6604,6614,9792,9793,9794,9795,9796,9799,9801,9802,9803,9805,9806,9807,9810,9811,9813,9814,9815,9817,9818}; --Mirelow
		[14425] = {2589,2592,2611,4715,6566,9774,9782,9805,9814,11968}; --Gnawbone
		[14433] = {814,858,1825,2452,2455,2785,3380,3385,3669,3671,3674,3676,5504,6590,7296,7356,7370,7415,7416,7419,9821,9827,9832,9837,9838,9847,9867,10288,10404}; --Sludginn
		[2090] = {790,929,1205,1712,1796,1819,1822,2589,2592,3385,3770,4306,5749,5750}; --Ma'ruk Wyrmscale <Dragonmaw Warlord>
		[2108] = {929,1205,1478,1785,1808,1831,2592,3385,3392,3770,4306,6200,7131}; --Garneg Charskull
		[14428] = {118,159,766,774,818,828,1181,1411,1412,1413,1414,1415,1416,1417,1419,1420,1421,1422,1425,1427,1429,1430,1431,1433,2138,2212,2213,2589,2598,2635,2642,2643,2644,2645,2646,2648,2773,2774,3013,3190,3370,3373,4536,4560,4563,5571,8177,8178,8182,18611}; --Uruson
		[14429] = {818,858,1179,1181,2075,2455,2589,3013,4537,6266,6267,6268,6269,6336,6337,6506,6507,6509,6510,6512,6513,6514,6515,6517,6518,6519,6521,6549,6555,7350,7351,9742,9743,9744,9745,9746,9747,9750,9751,9752,9754,9755,9756,9758,9759,9760,9761,9762,9763,15297}; --Grimmaw
		[14430] = {767,828,2318,2447,2934,3189,3409,3644,4813,4814,5571,6267,6506,6507,6508,6509,6510,6513,6514,6517,6518,6519,6520,6521,7350,7351,8178,9742,9743,9744,9745,9750,9752,9754,9758,9760,9761,14093,15003,15004,15005,15007,15008,15297}; --Duskstalker
		[14431] = {117,118,159,766,767,1181,1411,1412,1413,1414,1415,1416,1417,1418,1419,1421,1422,1425,1427,1429,1430,1431,1433,2138,2212,2213,2589,2635,2642,2643,2644,2646,2648,2773,2774,3013,3189,3190,3370,3373,4562,4563,4775,4776,5204,18612}; --Fury Shelda
		[14432] = {117,118,159,774,818,1181,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1422,1423,1427,1429,1430,1431,1433,2138,2212,2213,2589,2635,2642,2643,2644,2645,2646,2648,2773,2774,3013,3370,3373,18610}; --Threggil
		[209928] = {}; --Mowgh
		[3535] = {118,159,765,785,818,856,1495,1497,1498,1499,1501,1503,1505,1509,1510,1511,1512,1513,1514,1515,1516,1730,1732,1733,1737,2215,2447,2449,2763,2777,2778,3013,3192,3283,3288,3305,3374,3375,3654,4577,4604,5069,5179,14110,15298,15306,15970}; --Blackmoss the Fetid
		[2172] = {2318,2319,4775,4776,5114,5115,5469,6536,6552,6562,6563,6564,6573,6575,6581,6585,6588,9766,9768,9771,9775,9776,9780,9783,9784,10407,17056}; --Strider Clutchmother
		[2175] = {2318,2934,3290,4569,4813,5134,5413,6266,6267,6268,6269,6336,6337,6512,6537,6539,6541,6542,6543,6548,6549,6550,6555,6556,6557,6558,9742,9743,9744,9746,9747,9748,9749,9750,9751,9752,9755,9756,9757,9758,9759,9760,9762,9763,9765,9786,14113,15268,15304,15480}; --Shadowclaw
		[2184] = {858,1179,1764,1766,1814,2079,2455,2589,2592,2764,3306,4345,4537,4567,6536,6538,6539,6540,6541,6545,6546,6547,6548,6551,6552,6553,6554,6557,6575,6585,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9783,9784,9785,9786,9787,9788,9789,14123,14160,15308}; --Lady Moongazer
		[2186] = {858,1179,1742,1743,1787,1794,1816,2589,2592,3311,4537,6537,6538,6539,6540,6541,6542,6543,6545,6546,6547,6548,6550,6551,6553,6554,6556,6557,6558,9748,9749,9757,9770,9785,9786,9787,9788}; --Carnivous the Breaker
		[2191] = {858,1179,2287,2455,2589,3288,3304,3308,3312,4564,6266,6268,6336,6512,6537,6539,6541,6542,6543,6546,6547,6548,6549,6550,6551,6554,6555,6556,6557,6558,9746,9747,9748,9749,9755,9756,9757,9759,9762,9763,9765,9785,9786,14110,14115,14116,15013,15268,15481,15490}; --Licillin
		[2192] = {858,1179,1813,1815,2287,2455,2589,2592,2764,2780,3040,6536,6538,6540,6545,6552,6553,6562,6563,6564,6565,6570,6574,6575,6581,6582,6583,6585,9766,9767,9768,9770,9771,9772,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,9812,10405,10407,14131,14367}; --Firecaller Radison
		[7015] = {730,858,1179,1210,1812,2455,3302,3376,4570,5523,5784,6289,6536,6537,6538,6539,6540,6541,6542,6543,6545,6546,6547,6548,6550,6551,6552,6553,6554,6556,6557,6558,9748,9749,9757,9765,9767,9768,9770,9775,9777,9779,9784,9785,9786,9787,9788,9789,14724,15487}; --Flagglemurk the Cruel
		[7016] = {858,1179,1749,2455,2765,5503,5523,6289,6332,6333,17057}; --Lady Vespira
		[7017] = {858,1179,1180,1501,1814,2073,2632,2698,3013,3305,3374,4569,5523,6289,6537,6539,6540,6541,6542,6543,6545,6546,6547,6548,6549,6550,6551,6552,6553,6554,6555,6556,6557,6558,9747,9748,9749,9756,9757,9763,9765,9768,9770,9779,9785,9786,9788,9789,14722,15485}; --Lord Sinslayer
		[10559] = {1205,5445,5503,5523,6308,6562,6563,6564,6565,6566,6573,6574,6576,6577,6578,6579,6580,6581,6582,6583,6588,6591,9772,9774,9781,9812,10287,10405,10407,16654,17057}; --Lady Vespia
		[10639] = {929,954,1205,2589,2592,4306,4538,4715,6566,6567,6568,6569,6579,6584,6587,6591,6593,6595,6596,6602,6604,6605,6612,6614,9792,9793,9794,9795,9796,9799,9801,9802,9803,9805,9806,9807,9809,9810,9811,9813,9814,9815,9817,9818,16645,16647,16648,16649,16653,16654}; --Rorgish Jowl
		[10640] = {929,2592,4306,4538,4715,6591,6593,6594,6596,6600,6602,6604,6615,9795,9796,9799,9802,9803,9806,9807,9817}; --Oakpaw
		[10641] = {1205,2450,4606,6566,6567,6568,6569,6579,6584,6587,6600,9792,9793,9801,9802,9803,9805,9806,9807,9810,9811,9813,9814,9817,9818}; --Branch Snapper
		[10642] = {4715,5446,5447,5448,5451,6591,6600,6602,6604,6605,6612,6613,6614,7070,7091,9451,9795,9796,9803,9806,9807}; --Eck'alom
		[10643] = {730,1205,1468,5524,5784,6308,6565,6567,6568,6573,6577,6578,6579,6580,6582,6586,6588,6591,9772,9773,9774,9781,9782,9802,9812,9814,10405,17057}; --Mugglefin
		[10644] = {1015,2318,2319,3301,3402,5635,6562,6563,6564,6565,6566,6569,6576,6578,6579,6580,6582,6583,6587,6591,9772,9773,9781,9812,10405,10407}; --Mist Howler
		[10647] = {1205,2592,3770,4306,5481,6609,6610,7366,7406,7412,7422,9834,9841,9842,9853,10408,10409}; --Prince Raze
		[12037] = {2940,3702,3730,5635,6617,7355,7366,7409,7410,7411,7412,7416,7419,9821,9823,9827,9828,9833,9839,9840,10288,10289,10404,10406,11406,11407,16648}; --Ursol'lok
		[3735] = {929,1205,1747,1797,1818,2589,2592,3199,3385,4306,4606,6562,6563,6564,6565,6566,6568,6569,6570,6573,6574,6576,6577,6578,6579,6580,6581,6582,6583,6584,6586,6587,6588,6591,9772,9773,9774,9781,9782,9792,9805,9810,9811,9812,9813,9814,9818,10287,10405,10407}; --Apothecary Falthis
		[3773] = {929,1205,2592,2785,4306,4606,4715,6569,6584,6590,6593,6594,6596,6597,6600,6601,6602,6604,9792,9793,9794,9795,9799,9802,9803,9806,9807,9810,9815,9817}; --Akkrilus
		[3792] = {1205,3770,5635,5637,5753,5754}; --Terrowulf Packlord
		[14426] = {929,1205,1478,2592,2819,3770,4306,4715,6590,6591,6592,6593,6594,6595,6596,6597,6600,6601,6602,6604,6605,6607,6611,6612,6613,6614,6615,7356,7415,7419,9791,9795,9796,9797,9798,9799,9802,9803,9806,9807,9808,9809,9817,9821,9827,9829,9831,9838,10404,14197}; --Harb Foulmountain
		[14427] = {929,1205,2592,2771,4306,4538,4715,5842,6590,6591,6597,6600,9796,9806,9807,9809,9829}; --Gibblesnik
		[4132] = {5853,5854,5877,6300,6302,7438,7444,7446,7448,7461,7462,8224,9848,9849,9850,9859,9868,9870}; --Silithid Ravager
		[5933] = {1708,2592,3771,4306,6603,6607,6617,7355,7356,7370,7410,7411,7416,9821,9823,9828,9832,9837,9839,9840,9841,10404}; --Achellios the Banished
		[5934] = {1686,1687,5637,5809,6609,6610,6616,7354,7355,7357,7366,7367,7369,7370,7406,7407,7410,7411,7412,7414,7416,7417,7421,7422,7423,7424,7460,9820,9823,9824,9825,9826,9828,9832,9833,9834,9839,9840,9841,9842,9857,9861,9865,9868,10288,10289,10406,10408,10409,15142}; --Heartrazor
		[5935] = {1701,1702,4093,4235,5637,5798,7446,7462,8223,9863,9871,11386}; --Ironeye the Invincible
		[5937] = {1288,2319,5794,5798,7353,7368,7369,7418,7436,7443,7444,7446,7460,7461,9819,9850,9857,9860,9861,9864,9868,9869,12037,19937,19938}; --Vile Sting
		[4015] = {1206,1210,2319,5135,5136,5635,5637,5751,5752,5808,9773,12007,14158,14748,15117,15224,15259,15330,15520,15527}; --Pridewing Patriarch
		[4030] = {3857,4606,5664,6590,6603,6607,6615,6617,7356,7416,7422,9798,9821,9822,9827,9829,9831,9837,9838,9841,10404,10406,11151}; --Vengeful Ancient
		[4066] = {2319,3175,3179,4402,5583,5635,5637,6590,6607,6611,6617,7356,7419,9821,9824,9827,9838,9841,10404}; --Nal'taszar
		[5915] = {1755,1757,1783,1784,1785,1808,1827,1830,2592,2819,3385,4306,4538,6592,6594,6595,6596,6603,6611,6613,6614,6615,7366,7410,7411,7415,7416,9791,9797,9808,9821,9822,9829,9831,9832,9838,9839,10288,10406,15973}; --Brother Ravenoak
		[5916] = {929,1205,1759,1760,1784,1827,1828,1831,2592,2786,3385,4306,4538,4715,6591,6592,6593,6594,6595,6596,6597,6600,6601,6602,6604,6605,6611,6614,6617,7356,7415,7419,9795,9796,9798,9799,9802,9803,9806,9807,9808,9809,9817,9821,9827,9829,9831,9838,10404,14195}; --Sentinel Amarassan
		[5928] = {4633,4715,5136,5137,5637,5808,6590,6591,6592,6593,6594,6595,6596,6597,6600,6601,6602,6603,6604,6605,6607,6611,6613,6615,7356,7419,9791,9795,9796,9797,9798,9799,9802,9803,9806,9807,9809,9817,9821,9827,9831,9837,9838,14372,14400,15132}; --Sorrow Wing
		[5930] = {929,1205,2592,3201,3770,4306,4715,5116,5117,5635,6590,6591,6592,6594,6595,6596,6597,6600,6601,6602,6603,6605,6607,6611,6612,6613,6614,6615,7356,7410,7415,7419,9791,9796,9797,9798,9806,9807,9808,9809,9821,9822,9827,9829,9831,9837,9838,10288,10404,17056}; --Sister Riven
		[5931] = {422,929,1205,2589,2592,4306,6566,6568,6573,6577,6578,6579,6580,6587,6588,6604,9782,9794,9799,9801,9802,9805,9811,9813,9814,9817,16882}; --Foreman Rigger
		[5932] = {929,1205,1210,2589,2592,3012,3199,3385,3770,4306,6562,6563,6564,6565,6566,6567,6568,6570,6573,6574,6576,6577,6578,6579,6580,6581,6582,6583,6586,6587,6588,6591,9772,9773,9774,9781,9782,9793,9805,9810,9811,9812,9813,9814,9818,10287,10405,10407,14368,15333}; --Taskmaster Whipfang
		[11688] = {1645,4306,4338,4599,7478,7487,7491,9290,9291,9874,9884,9887,9909,9919,9930,9931,9967,9969,9971,17684}; --Cursed Centaur
		[14225] = {2592,3771,4306,6246,6247,6989,7354,7367,7368,7369,7409,7420,7424,9825,9833,9836,9867,9869}; --Prince Kellen
		[14226] = {1708,4306,6252,7429,7474,7492,9878,9885,9892,9900}; --Kaskk
		[14227] = {1701,1702,4093,5637,7432,7433,7434,7438,7443,7444,7445,7446,7448,7454,7455,7457,7458,7461,7462,7493,9844,9851,9859,9862,9863,9864,9866,9870,9871,9872,9875,9876,9877,9886,9891,9901,11386}; --Hissperak
		[14228] = {2319,3402,4582,5637,7354,7357,7368,7408,7413,7414,7417,7421,7423,7436,7438,7446,7448,7460,9819,9826,9833,9845,9847,9853,9857,9860,9863,9865,9867,9868,9869,12037,12203}; --Giggler
		[14229] = {6362,7072,7368,7369,7417,7418,7436,7461,9826,9845,9853,9855,9861,9868,15881,17057,17058}; --Accursed Slitherblade
		[5343] = {1645,3928,4424,4603,6149,7468,7477,7519,7521,7522,7523,7525,7526,7530,7531,7534,7535,7539,7540,7541,7542,7543,7545,7546,7973,9247,9911,9912,9913,9922,9923,9924,9933,9948,9951,9956,9959,9960,9961,9962,9964,10087,10088,10090,10091,10092,10202,10205,10206,14955}; --Lady Szallah
		[5345] = {7534,8705}; --Diamond Head
		[5346] = {3928,7527,8973,9924,9937,9951,10076,10201,10206}; --Bloodroar the Stalker
		[5347] = {4590,5117,5829,7520,7528,7529,7538,7543,9591,9592,9913,9924,9937,9938,9939,9945,9947,9951,9954,9955,9961,9962,10060,10066,10072,10079,10091,10092,10201,10202,10206,11417,11418,14835}; --Antilus the Soarer
		[5349] = {4304,6444,6826,8170,9939,9941,9947,9948,9949,9952,9964,9965,10060,10066,10071,10076,10079,10086,10127,10201,10205,10207}; --Arash-ethis
		[5350] = {6300,6302,7519,7520,7526,7529,7532,7535,7540,7541,7543,8705,9939,9940,9951,9952,9960,9962,10091,10092}; --Qirot
		[5352] = {6258,8146,9874,9910,9930,9970,11408,11409,11410,11411}; --Old Grizzlegut
		[5354] = {9919,9931,9932}; --Gnarl Leafbrother
		[5356] = {4304,4583,4584,7470,7471,7472,7479,7482,8146,9287,9883,9893,9897,9903,9909,9968,9972,12203,12208}; --Snarler
		[14230] = {1708,1710,2289,3827,4639,5785,5847,6362,7429,7430,7431,7432,7433,7434,7435,7440,7441,7444,7445,7454,7455,7456,7457,7458,7459,7462,7472,7476,7492,7493,7494,9844,9851,9852,9854,9862,9863,9866,9871,9872,9875,9877,9879,9890,9891,9894,9896,9898,17057,17058}; --Burgle Eye
		[14231] = {1708,4607,7433,7434,7437,7443,7444,7446,7448,7457,7458,7461,7462,9856,9871,9872,9875}; --Drogoth the Roamer
		[14232] = {4461,4586,4587,5637,7429,7432,7441,7443,7444,7445,7457,7458,7459,7462,7493,8146,9844,9851,9852,9854,9862,9866,9872,9875,9877,9886,9890,9896,9898,12184}; --Dart
		[14233] = {770,3357,3667,4304,7429,7431,7432,7435,7440,7445,7454,7455,7456,7459,7493,9852,9854,9866,9875,9876,9877,9879,9886,9890,9891,9892,9894,9895,9896,9902}; --Ripscale
		[14234] = {4304,5636,6444,6826,7430,7439,7472,7474,7475,7479,7481,7483,7484,7489,7490,7493,7533,9287,9289,9291,9876,9881,9889,9894,9902,9904,9906,9909,9916,9929,9967,9970}; --Hayoc
		[14235] = {3669,3670,3671,3673,3674,3676,3938,3989,7296,7478,7479,7481,7482,7487,7488,7490,7491,7524,7533,9290,9291,9874,9883,9884,9887,9906,9908,9909,9916,9917,9919,9920,9925,9930,9931,9956,9972,10089,20763,20767}; --The Rot
		[14236] = {4603,6149,7469,7486,7522,7524,7533,7544,7973,9286,9291,9874,9884,9906,9907,9908,9909,9910,9915,9916,9917,9919,9920,9925,9926,9930,9931,9932,9934,9959,9971,10087,10092}; --Lord Angler
		[14237] = {3669,3676,7332,7470,7471,7472,7473,7478,7479,7481,7484,7485,7486,7488,7522,7524,9285,9287,9289,9292,9878,9881,9883,9884,9893,9894,9897,9903,9904,9932,9934,9967,9970,9972,9973}; --Oozeworm
		[4339] = {4304,4402,4460,6444,7332,7477,7525,7529,7530,7534,7540,7545,8146,9910,9912,9915,9920,9925,9928,9934,9945,9947,9959,9961,9966,9970,10094}; --Brimgore
		[4380] = {1074,4337,4585,5637,5884,7439,7483,9889,9891,9892,10285,12205}; --Darkmist Widow
		[8199] = {1520,3928,4306,4338,4599,7523,7524,7525,7533,7534,7544,8151,9906,9921,9925,9928,9951,9959,9962,9966,10088}; --Warleader Krazzilak
		[8200] = {1520,4306,4338,4599,7521,7530,7540,8120,8151,9922,9964}; --Jin'Zallah the Sandbringer
		[8201] = {1645,4338,4599,17055}; --Omgorn the Lost
		[8202] = {4338,9913}; --Cyclok the Mad
		[8203] = {4338,4599,7519,7520,7526,7528,7529,7530,7531,7532,7535,7540,7543,9911,9951,9960,9961,10087,10090,10091,10092,20519}; --Kregg Keelhaul
		[8204] = {6300,6302,9939,10066,10083,10130}; --Soriid the Devourer
		[8205] = {6300,6302,9936,9957,10067,10083,10208}; --Haarka the Ravenous
		[8207] = {1464,3404,5117,5829,7526,7531,7543,8146,9911,9956,10088,11417,11418,12207}; --Greater Firebird
		[8208] = {4583,9439,12037,12203,12208}; --Murderous Blisterpaw
		[13896] = {3712,4304,4555,4556,7973,8167,8170,8959,9954,10063,10064,10068,10073,10083,10084,10085,10103,10108,10132,10133,10134,10174,10179,10180,10184,10190,10191,10196,10197,10203,10238,10239,10242}; --Scalebeard
		[6118] = {1645,3928,4338,4608,7519,7520,7528,7529,7532,7538,7539,7540,7543,7972,9905,9913,9924,9937,9938,9941,9945,9947,9948,9949,9951,9960,9961,9962,9963,9964,10079,10091,10092,10201,10202,10206}; --Varo'then's Ghost
		[6646] = {3948,3970,3971,3973,3997,4552,4554,7912,8150,8754,10082,10085,10095,10097,10098,10099,10103,10119,10122,10126,10166,10167,10169,10173,10174,10175,10179,10184,10188,10190,10197,10198,10199,10200,10203,10238,10240,10244,10245}; --Monnos the Elder
		[6647] = {10068,10083,10084,10134,10176,10203,10239,10242,14047}; --Magister Hawkhelm
		[6648] = {4590,5117,5829,7517,8146,8170,9940,9941,9942,9948,9954,9955,9957,10073,10081,10194,10239,10450,11417,11418,15420}; --Antilos
		[6649] = {7973,8766,8959,9954,10061,10062,10063,10075,10084,10132,10134,10185,10191,10239,10243}; --Lady Sesspira
		[6650] = {1645,4603,7973,9955,10058,10068,10081,10131,10132,10191,17054}; --General Fangferror
		[6651] = {3928,4338,4599,4602,5430,9941,9952,9953,9965,10058,10060,10066,10069,10071,10108,10133,10205,10242}; --Gatekeeper Rageroar
		[6652] = {10134,10191,12662,14047}; --Master Feardred
		[8660] = {6444,6826,7519,7520,7528,7529,9905,9924,9937,9945,9951,9963,10067,10091,10092,10129,10202,10206,10208,20023}; --The Evalcharr
		[14339] = {4583,4584,7527,7528,8146,8169,8170,9913,9936,9945,9948,9952,9954,9962,9964,9965,10062,10071,10076,10079,10083,10134,10174,10185,10197,10202,10207,10208,11515,12203,12208,14427}; --Death Howl
		[14340] = {8766,8952,10057,10077,10096,10098,10103,10107,10109,10122,10123,10126,10128,10166,10171,10173,10176,10179,10183,10186,10193,10199,10200,10244,10278,11515,11674,12662,14047,14256}; --Alshirr Banebreath
		[14342] = {8766,8953,9940,9942,9954,9955,9957,10058,10059,10061,10062,10063,10068,10072,10073,10075,10081,10083,10091,10130,10131,10132,10134,10184,10185,10191,10194,10196,10208,10239,10243,11515,13443,14047,21377}; --Ragepaw
		[14343] = {5117,10062,10196,10197,10238,10242,11417,11420,11515,12207,15420}; --Olm the Wise
		[14344] = {4304,10058,10067,10080,10081,10084,10086,10132,11172,11408,11409,11410,11411,11515}; --Mongress
		[14345] = {3669,3671,3673,3674,7296,9954,9955,10061,10063,10068,10073,10075,10109,11515,12230,20763,20768,20770}; --The Ongar
		[7104] = {1645,3818,3927,8766,8948,10057,10095,10101,10106,10111,10121,10125,10168,10169,10177,10188,10214,10221,10229,10276,10282,10286,10305,11503,11515,12803}; --Dessecus
		[7137] = {4784,7067,7075,7076,7912,8150,10057,10095,10106,10112,10113,10121,10122,10124,10125,10168,10170,10177,10188,10224,10229,11515,12662}; --Immolatus
		[6581] = {3108,4304,4587,4588,7527,8146,9952,9953,9955,10058,10059,10060,10081,10129,10130,10239,11018,11116,11477,12184,20015}; --Ravasaur Matriarch
		[6582] = {6300,6302,10096,10099,10103,10107,10108,10109,10126,10128,10166,10171,10176,10179,10183,10186,10193,10199,10241,10244,11018}; --Clutchmother Zavas
		[6583] = {4304,5128,5133,8170,10100,10106,10111,10113,10119,10124,10138,10168,10170,10212,10216,10221,10224,10225,10229,10230,10235,10277,10282,11018,11188}; --Gruff
		[6584] = {4587,4588,10136,10144,10147,10154,10162,10211,10219,10255,10379,10380,10382,11018,11185,11186,11188,11315,13463,14330,15417,20015}; --King Mosh
		[6585] = {2799,4099,4304,4558,8170,10084,10174,10242,11018,11116}; --Uhk'loc
		[14471] = {4552,4554,7912,8150,10137,10140,10142,10146,10147,10149,10155,10249,10252,10383,10385,10387}; --Setis
		[14472] = {1074,4337,4585,10125,10214,10285,12205,14227}; --Gretheer
		[14473] = {6300,6302,10137,10138,10144,10145,10210,10226,10230,10258,10263,10269,10376,10377,10383}; --Lapress
		[14474] = {6300,6302,10104,10105,10138,10148,10159,10181,10182,10210,10211,10213,10216,10230,10235,10236,10249,10275,10279,10376,10381,15431}; --Zora
		[14475] = {6300,6302,10097,10106,10119,10125,10147,10177,10212,10213,10229,10233,10277,10281,20498}; --Rex Ashil
		[14476] = {10057,10091,10095,10099,10106,10113,10121,10124,10125,10148,10164,10167,10168,10170,10172,10175,10177,10187,10188,10189,10212,10229,10231,10276,10278,10282,12037,19441,19933,19934}; --Krellack
		[14477] = {3669,3676,10111,10118,10123,10164,10224}; --Grubthor
		[14478] = {7069,7081,7082,10097,10101,10104,10111,10112,10113,10118,10124,10145,10156,10164,10169,10181,10210,10213,10214,10216,10221,10223,10228,10232,10233,10234,10235,10237,10277,10281,10377,10381,22527}; --Huricanian
		[14479] = {8766,8952,10104,10105,10136,10138,10140,10144,10145,10146,10147,10150,10153,10154,10155,10156,10159,10161,10163,10210,10211,10214,10219,10222,10225,10226,10227,10228,10230,10235,10236,10258,10259,10274,10275,10280,10373,10376,10377,10380,10381,10386,10387,10391,14047,20404,20406,20407,20408,20451}; --Twilight Lord Everun <Twilight's Hammer>
		[224965] = {}; --Khonsu <Night Traveler>
		[228611] = {}; --Wandering Swordsman
		[10196] = {8170,8766,8952,10095,10100,10106,10119,10121,10123,10124,10125,10168,10177,10188,10216,10224,10233,10276,10282}; --General Colbatann
		[10197] = {4304,8146,8170,8766,8952,10057,10091,10096,10099,10100,10107,10110,10122,10125,10126,10165,10166,10167,10172,10175,10176,10183,10187,10189,10193,10199,10224,10231,10240,10278,10282}; --Mezzir the Howler
		[10198] = {8952,10105,10136,10142,10144,10147,10150,10155,10226,10253,10307,10383,12334}; --Kashoch the Reaver
		[10199] = {8766,8953,10101,10104,10118,10138,10145,10147,10148,10156,10159,10210,10211,10214,10221,10222,10225,10232,10234,10235,10236,10279,10280,10377,10380,10381,12820,12841,14047}; --Grizzle Snowpaw
		[10200] = {1688,4580,4581,8146,8170,10095,10100,10111,10113,10119,10123,10124,10169,10212,10233,10277,12202}; --Rak'shiri
		[10201] = {12662,14047,21105}; --Lady Hederine
		[10202] = {4460,10138,10222,10223,10267}; --Azurous
		[12116] = {}; --Priestess of Elune
		[3581] = {770,4304,15279}; --Sewer Beast
		[3586] = {414,789,858,955,1179,1180,1206,1210,2078,2455,2589,2592,2770,2771,2836,2838,2984,2987,2988,2989,3012,3040,3195,3199,3211,4575,4576,4697,4699,5207,5443,5444,6344,6538,6540,6552,6560,6563,6583,9775,9777,9779,9784,9787,9789,14166,14167,14174,15222,15926}; --Miner Johnson
		[596] = {414,818,858,1179,1180,1206,1210,1738,1740,1741,1744,1764,1766,1767,1769,1770,1787,1788,1789,1790,1791,1793,1794,1811,1812,1813,1814,1815,1816,2217,2455,2589,2592,2780,2781,2984,2992,3377,3645,3902,4695,4699,5967,6528,9784,14166}; --Brainwashed Noble
		[599] = {414,858,1179,1180,1206,1210,1792,1812,1813,1814,1815,2078,2079,2455,2589,2592,2764,2781,2969,2984,2987,3012,3019,3040,3195,3196,3205,3645,4346,4576,4660,4695,4699,6379,6540,6546,6551,6552,6553,6559,6563,6564,6581,9776,9777,9779,9785,9788,14174,15222}; --Marisa du'Paige
		[3652] = {2318,2319,3010,4874,5425,5426,5523}; --Trigore the Lasher
		[3672] = {858,1179,1210,1738,1741,1745,1766,1767,1768,1770,1790,1812,1813,1814,1817,2589,2592,2764,2781,3184,3393,4537,4575,4576,5422,5423,7288,14129,14367,15114,15498}; --Boahn <Druid of the Fang>
		[5912] = {789,790,818,1206,1210,3176,3177,3184,4576,5207,5243,6443,6470,6471,6632,14369,14371,14727,15222,15248,15307,15488,15498,15502,15971}; --Deviate Faerie Dragon
		[211764] = {}; --Gefell
		[211765] = {}; --Gemela
		[3872] = {929,1205,1206,1210,1705,1712,1822,1823,2589,2592,2782,2819,2882,3012,3057,3058,3201,3385,3656,3740,4306,4606,4632,4706,4709,4714,6383,6394,6584,6587,6600,6641,6642,7558,9792,9793,9794,9799,9801,9811,9813,9814,9818,11994,12007,15223,15224,15230,15259,15269}; --Deathsworn Captain
		[4425] = {1529,2319,3831,5635,5637,6695,6696,6697,11391,11392,11393,11394,14210,15133,15285,15346,15542}; --Blind Hunter
		[4438] = {929,1205,1206,1478,1488,1529,1705,1712,1978,2077,2290,2592,3041,3186,3201,3210,3385,4306,4538,4633,5825,6679,8184,11969,14178,14180,14183,14186,14187,14191,14379,14400,14402,14406,14570,14750,14751,14754,14756,15127,15242,15284,15337,15351,15518,15529,15535,15539,15545,15559}; --Razorfen Spearhide
		[4842] = {929,1478,2592,3041,3779,3781,3782,3783,3799,3802,3804,3813,3815,3864,4306,4538,4634,5214,5825,6688,6689,14189,14192,14196,14205,14209,15129,15225,15285,15579}; --Earthcaller Halmgar
		[5399] = {1520,1645,4338,6181,7532,7539,8152,9924,9942,9945,9947,9952,9962,9963,10062,10092,10202}; --Veyzhak the Cannibal
		[5400] = {1520,4338,6181,7529,7532,7538,7539,7543,8152,9913,9945,9949,9954,9960,9962,9963,9964,9965,10079,10081,10086,10092,10129,10201,10206}; --Zekkis
		[6228] = {2592,4306,5108,9308}; --Dark Iron Ambassador
		[6488] = {1477,1529,1705,1708,1710,2592,3037,3042,3185,3197,3778,3779,3780,3782,3783,3784,3785,3786,3787,3794,3805,3807,3811,3813,3815,3827,3864,4075,4306,4338,4607,4634,4716,6403,6410,6610,7367,7417,7689,7690,7691,8748,9836,9847,9860,11985,12009,12019,12029,15225}; --Fallen Champion
		[6489] = {1477,1529,1705,1708,1710,2289,2592,3042,3780,3782,3785,3794,3799,3800,3801,3805,3827,3864,4306,4338,4352,4607,4634,4716,6403,6406,6407,6410,6609,7354,7367,7408,7412,7424,7436,7686,7687,7688,7728,9819,9825,9834,9835,9836,9847,12019,12028,12039,15285,15934}; --Ironspine
		[6490] = {1477,1529,1708,1710,2080,2289,2592,3042,3779,3780,3781,3782,3785,3786,3792,3803,3808,3816,3827,3864,4306,4338,4607,4634,4720,5214,5433,6045,6406,7354,7408,7414,7421,7436,7460,7708,7709,7730,7731,8746,8747,9847,9867,9868,12039,15225,15232,15250,15286,15935}; --Azshir the Sleepless
		[8923] = {3994,4552,4554,5759,7910,7912,8150,10106,10212,11129,11370,11754,11785,11786,11787,18945,22245,22528}; --Panzor the Invincible
		[8924] = {10069,10080,10127,10200,11446,11603,14047,18945,19259,22528}; --The Behemoth
		[9024] = {3948,3949,3951,3969,3976,3987,3990,3992,3997,4425,5758,7909,7910,8084,8260,8264,8314,8753,8766,8950,10063,10073,10085,10175,10184,10196,10245,11207,11747,11748,11749,11750,11754,13443,13817,13819,13820,13821,13822,13824,13825,14047,15236,17413,18945,22528}; --Pyromancer Loregrain
		[9041] = {3944,3945,3947,3949,3972,3990,3996,3997,3998,4425,4426,5759,7910,8085,8752,8753,8766,8950,10095,11078,11446,11754,11782,11783,11784,11939,11940,11966,13443,13446,13816,13817,13818,13819,13820,13822,13823,13824,13825,14047,15229,15264,15271,15324,18600,18945,19275,22241,22528}; --Warder Stilgiss
		[9042] = {3075,4304,4583,4584,5758,7909,7910,8146,8169,8170,8272,10110,10166,10187,10371,11754,11755,11939,11940,11966,12203,12208,18945,22242,22528}; --Verek
		[10263] = {8948,10057,10070,10095,10097,10100,10101,10106,10111,10112,10113,10118,10119,10121,10122,10123,10124,10125,10165,10167,10168,10170,10177,10187,10188,10193,10212,10213,10214,10219,10222,10223,10224,10225,10229,10233,10236,10237,10276,10277,10278,10280,10282,10376,12662,13181,13182,14047,14256,15428}; --Burning Felguard
		[10376] = {1074,4337,4585,7909,7910,10144,10210,10236,10263,10285,12205,13184,13185,13218,14227,15282,15325}; --Crystal Fang
		[9217] = {3992,3994,3999,4500,7909,7910,8305,8766,8952,10124,10228,10381,12219,12694,13261,13282,13283,13819,13820,13821,13824,14047,17414,21982,22528}; --Spirestone Lord Magus
		[9218] = {3945,3946,3993,3996,3998,3999,5759,7910,8086,8310,8754,8766,8952,10112,10118,10230,12015,12219,13284,13285,13818,13821,13824,13825,14047,15219,15256,15276,15281,18600,21982,22528}; --Spirestone Battle Lord
		[9219] = {3944,3945,3948,3970,3976,3999,5759,7909,7910,8752,8766,8952,10168,10223,10309,12026,12219,12608,13286,13817,13819,13824,13825,14047,15218,15255,18335,21982,22528}; --Spirestone Butcher
		[9596] = {3947,3948,3949,3951,3976,5759,7910,8081,8307,8766,8952,10145,10213,10216,12219,12621,12634,12637,12838,13444,13818,13823,13824,14047}; --Bannok Grimaxe <Firebrand Legion Champion>
		[9718] = {3948,3973,5759,7910,8086,8755,8766,8952,10223,10232,10377,12219,13198,13203,13204,13446,13816,13817,13818,13822,13823,14047,15238,16215,22528}; --Ghok Bashguud <Bloodaxe Champion>
		[10080] = {1645,3928,4306,4338,4599,7332,7468,7477,7486,7519,7521,7522,7524,7525,7529,7530,7531,7532,7534,7539,7541,7543,7544,7545,8120,8151,8623,9242,9243,9286,9523,9906,9910,9911,9912,9915,9921,9923,9925,9933,9934,9937,9951,9956,9959,9966,10088,10089,10092,10094}; --Sandarr Dunereaver
		[10081] = {4306,4338,4599,7332,7468,7469,7477,7522,7524,7525,7530,7531,7532,7533,7534,7535,7541,7543,7544,7545,8120,8151,8623,9242,9243,9286,9523,9907,9910,9911,9912,9915,9916,9921,9922,9923,9925,9928,9932,9933,9934,9956,9959,9960,9966,9970,10088,10089,10094,12471}; --Dustwraith
		[10082] = {1645,4306,4338,4599,7332,7468,7469,7477,7520,7522,7523,7525,7526,7531,7533,7534,7535,7543,7544,7545,8120,8151,8623,9242,9243,9286,9523,9906,9907,9910,9912,9915,9920,9921,9922,9923,9925,9928,9932,9933,9934,9945,9951,9959,9966,9970,10088,10090,10094,12470}; --Zerillis
		[10393] = {3945,3950,3990,3997,7972,8289,8292,8752,8753,8754,8755,8766,8948,10138,10145,10169,10279,10371,12057,12808,12843,13394,13395,13396,13817,13820,13821,13824,14047,16251,18335,22526}; --Skul
		[10558] = {3969,3987,3998,5759,7909,7972,8298,8299,8312,8318,8753,8754,8766,8948,10212,10306,12808,12843,13174,13378,13379,13383,13384,13444,13818,13819,13821,13823,13824,14047,15255,15282,16682,18600}; --Hearthsinger Forresten
		[10809] = {4552,4554,5759,7909,7910,8146,10136,10145,10219,10230,12843,13397,13399,13954,15239,15256,15282,18600}; --Stonespine
		[10509] = {4500,5759,7909,7910,8292,8306,8766,8952,10102,10104,10138,10145,10182,10211,10213,10214,10216,10222,10223,10228,10235,10236,10237,10280,10307,10308,10369,10374,10377,10381,12004,12604,12605,12930,13101,13446,14047,15219,15238,15256,15257,15265,15272,15276,15278,17414,17683,18335,18600,22138}; --Jed Runewatcher <Blackhand Legion>
		[11447] = {1973,4696,5267,9402,10286,13004,13006,13015,13023,13028,13047,13053,13060,13072,13091,13107,13116,13146,13463,13464,13465,13468,14862,23197,23199}; --Mushgog
		[11497] = {1973,4696,6622,8170,9402,13000,13001,13002,13004,13006,13015,13023,13028,13053,13060,13072,13083,13096,13101,13107,13113,13116,13123,13133,13135,13463,15435,23197,23199,23203}; --The Razza
		[11498] = {1973,4696,8766,9402,13000,13001,13002,13004,13006,13007,13015,13028,13047,13053,13060,13070,13072,13075,13083,13091,13096,13101,13107,13116,13123,13133,13135,13146,14047,23199,23203}; --Skarr the Unbreakable
		[12237] = {765,785,1645,2452,3820,3938,3943,3962,3963,3986,4005,4020,4021,4022,4026,4608,4638,7909,7910,8749,8751,8838,8839,8846,10286,15235,17684,17741,17742,17767}; --Meshlok the Harvester
		[232556] = {}; --Drake
		[232557] = {}; --Drake
		[231661] = {}; --Rahuz <The Scorned Student>
		[232215] = {}; --Rahuz
		[232216] = {}; --Rahuz
		[240797] = {}; --Scarlet Executioner
		[242577] = {}; --Devouring Hunger
		[242827] = {}; --Captain Bloodcoin <Seafaring Auctioneer>
		[243046] = {}; --Scarlet Captain
		[243893] = {}; --High General Abbendis
	}
-- SOD
else 
	private.NPC_LOOT = {
		[10203] = {}; --Berylgos
		[10236] = {}; --Wep
		[10237] = {}; --Yor
		[10238] = {}; --Staggon
		[10239] = {}; --Tepolar
		[10818] = {}; --Death Knight Soulbearer
		[10819] = {}; --Baron Bloodbane
		[11580] = {}; --Kelemis the Lifeless
		[13977] = {20400}; --Gash'nak the Cannibal
		[14016] = {18335}; --Ushalac the Gloomdweller
		[14018] = {18335}; --Rezrelek <Winterax Hero>
		[14019] = {}; --Tatterhide
		[14341] = {}; --Felendor the Accuser
		[17075] = {18512}; --Sandworm
		[208842] = {}; --The Gardener <Gardener>
		[208843] = {}; --Abominable Snowman
		[208844] = {}; --Crimson Emissary
		[208845] = {}; --Par'kourc <Blackrock Clan Outrunner>
		[208846] = {}; --Sun Admirer
		[208847] = {}; --The Snatcher <Rascal>
		[228673] = {}; --Wandering Swordsman
		[232556] = {}; --Drake
		[232557] = {}; --Drake
		[5348] = {}; --Dreamwatcher Forktongue
		[5367] = {8705}; --Scillia Daggerquil
		[5789] = {}; --Serra Mountainhome <Ironforge Surveyor>
		[5790] = {}; --Lizzle Sprysprocket <Ironforge Surveyor>
		[5793] = {}; --Captain Armistice <Alliance Peacekeeper>
		[5794] = {}; --Thurmonde the Devout <Alliance Peacekeeper>
		[5795] = {}; --Grash Thunderbrew <Alliance Peacekeeper>
		[5796] = {}; --Ben <Grash Thunderbrew's Pet>
		[601] = {}; --Capo the Mean
		[8206] = {}; --Soul of Tanaris
		[9417] = {}; --Sleeping Dragon
		[203079] = {}; --Wandering Swordsman
		[204070] = {204912}; --Soboz
		[208124] = {4814,205979,211323}; --Raluk
		[5808] = {117,118,159,727,774,2589,3013,3609,3642,3650,4671,4870,6267,6269,6337,6506,6507,6508,6509,6510,6513,6514,6515,6517,6518,6519,6520,6521,7350,7351,9742,9743,9744,9745,9750,9751,9752,9754,9758,9760,9761,14088,14089,14093,15003,15005,15007,203753,205945,211933}; --Warlord Kolkanis
		[5809] = {118,159,2070,2091,2589,4870,6506,6507,6508,6509,6510,6513,6514,6515,6517,6519,6520,6521,7350,7351,9745,15003,15007}; --Watch Commander Zalaphil
		[5822] = {117,118,159,818,1181,2589,3653,4672,6266,6267,6336,6347,6506,6507,6509,6510,6512,6513,6514,6515,6517,6518,6519,6521,6555,7350,7351,8180,9743,9745,9746,9747,9750,9751,9752,9754,9755,9756,9758,9759,9760,9761,9762,9763,15009,15481,15485,203753,204809,205945}; --Felweaver Scornn
		[5823] = {1475,2447,4867,4872,5466,6336,6506,6507,6509,6510,6513,6514,6515,6517,6518,6519,6521,6549,6555,7350,7351,9742,9744,9745,9746,9747,9750,9751,9754,9756,9761,9762,15302}; --Death Flayer
		[5824] = {1181,1495,1504,1511,1513,1515,1516,2214,2589,2777,3289,3375,4536,6266,6268,6336,6337,6506,6507,6509,6510,6513,6514,6515,6518,6519,6521,6549,6555,7350,9742,9745,9746,9747,9750,9752,9754,9761,9763,15479}; --Captain Flat Tusk <Captain of the Battleguard>
		[5826] = {118,159,767,768,774,818,1181,2075,2589,3642,3650,4536,4668,4675,6267,6269,6337,6506,6507,6508,6509,6510,6513,6514,6515,6517,6518,6520,6521,7350,7351,9743,9744,9745,9750,9752,9754,9760,9761,14099,15003,15007,15475,15482,204809,205945,206994,207631,211325,211330}; --Geolord Mottle
		[205382] = {4814,205979}; --Mokwa
		[3056] = {1210,2075,2140,2318,2657,2672,2934,3192,3279,3282,3286,3289,3290,3299,3300,3314,3609,3644,4561,4569,4686,4854,5069,14097,14099,14102,14110,15015,15479,15480,15944,15969,204809,206169,210771,211315,211316,211317,211318,211320,211324,211326,211328,211331,211780,211785,211933}; --Ghost Howl
		[3068] = {727,767,774,818,2318,2672,2934,3289,3642,4672,4759,4806,4861,6337,6506,6507,6508,6509,6510,6514,6515,6517,6519,6520,6521,7097,7350,7351,8181,9743,9751,9752,9754,9761,14090,15003,15004,15007,15472,15969,204809,206169,211315,211316,211319,211325,211326,211327,211328,211329}; --Mazzranache
		[5785] = {117,159,2589,2778,4772,4775,4776,6506,6507,6514,6517,6518,6519,6521,7351,9745,9754,9761,15483,17056}; --Sister Hatelash
		[5786] = {117,118,159,768,774,1181,2589,3013,3280,3286,3290,3642,4671,4674,6269,6337,6506,6507,6508,6509,6510,6513,6514,6515,6517,6518,6519,6520,6521,7350,7351,9744,9745,9750,9751,9752,9754,9758,9760,9761,14088,15003,15007,15302,15483,204809,211318,211327,211330,211332}; --Snagglespear
		[5787] = {117,118,159,1181,1509,1515,2589,6266,6267,6268,6269,6336,6506,6507,6509,6510,6512,6513,6514,6515,6517,6518,6519,6521,6549,6555,7350,7351,9743,9744,9745,9746,9747,9751,9754,9755,9756,9760,9761,9762,9763,14097}; --Enforcer Emilgund
		[5807] = {727,774,2318,2406,2598,2934,3284,3286,3312,3642,3644,4496,4562,4563,4669,4674,4692,4813,4814,5571,8178,8181,14086,14093,14094,14098,14099,15005,15299,15476,15479,15483,15484,15486,15969,17922,204809,206169,210771,211328,211331,211787}; --The Rake
		[3253] = {5058,5138,5268,5269}; --Silithid Harvester
		[3270] = {774,818,858,1179,1210,2073,2079,2455,2589,3013,3036,3196,3306,3307,3308,3311,3314,3654,4537,4569,4570,4571,4681,4693,4768,4771,5212,14096,14097,14113,14115,14117,14365,14559,14561,14722,14723,14724,15011,15012,15013,15014,15016,15268,15303,15485,15489,15491,15494,15495}; --Elder Mystic Razorsnout
		[3295] = {3184,3193,3195,3196,3306,3670,4575,4576,5207,6540,6545,6564,6575,6583,9766,9768,9770,9771,9775,9776,9779,9780,9783,9787,9788,9789,10407,14121,14124,14159,14160,14161,14367,14560,14564,14565,14745,15017,15018,15110,15112,15114,15222,15305,15498,15502,15508,15510,15971,211833}; --Sludge Beast
		[3398] = {2318,3010,4874,5182,5183,5523,17057}; --Gesharahan
		[3470] = {858,955,1179,1180,1495,1497,1499,1501,1505,1506,1507,1509,1511,1512,1513,1515,1516,1731,1732,1734,1735,2214,2408,2455,2589,2763,2777,2778,3307,3375,4567,4569,4605,5071,5111,5112,14109,14113,14116,14161,15298,15485,211327,211934}; --Rathorian
		[5797] = {2589,2592,4538,10621}; --Aean Swiftriver <Alliance Outrunner>
		[5798] = {2589,2592,4538,9811}; --Thora Feathermoon <Alliance Outrunner>
		[5799] = {1205,1824,2589,2592,4306,4538}; --Hannah Bladeleaf <Alliance Outrunner>
		[5800] = {2589,2592,4542}; --Marcus Bel <Alliance Outrunner>
		[5827] = {2319,4715,5082,5121,5122,5467,6591,6593,6600,6602,6604,9796,9798,9803,9806,9807,9817}; --Brontus
		[5828] = {2319,2589,2592,3731,4306,5135,5136,6565,6566,6569,6573,6577,6580,6586,6588,9773,9774,9781,9782,9803,9811,9812,9817,10287,10405}; --Humar the Pridelord
		[5829] = {2318,2319,3299,3301,5635,6539,6540,6541,6545,6546,6547,6548,6551,6553,6554,6557,9770,9779,9780,9785,9786,9788,9789}; --Snort the Heckler
		[5830] = {858,1179,1180,1210,2287,2455,2589,2592,5635,6536,6538,6540,6545,6552,6553,6562,6563,6564,6565,6570,6574,6575,6576,6581,6582,6583,6585,9766,9767,9768,9770,9771,9772,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,9812,10287,10407,17056,211822,211826}; --Sister Rathtalon
		[5831] = {1206,5086,5119,5120,6562,6563,6564,6565,6581,6583,9776,9780,9783,9814,10407}; --Swiftmane
		[5832] = {2318,2319,4895,5128,5133,5470,6566,6568,6569,6577,6578,6579,6580,6586,6587,6593,9773,9774,9802,9803,9805,9810,9811,9814,9815}; --Thunderstomp
		[5834] = {2318,2319,6444,6566,6567,6568,6569,6579,6584,6587,6591,6593,6600,6604,6826,9792,9793,9794,9795,9796,9799,9801,9802,9805,9806,9810,9811,9813,9814,9815,9817,9818,17056}; --Azzere the Skyblade
		[5835] = {414,858,955,1179,1180,2455,2589,2592,4575,6536,6538,6540,6545,6552,6553,6562,6563,6564,6565,6570,6574,6575,6576,6581,6583,6585,6663,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,9812,10405,10407,14367,15493,15497,211831}; --Foreman Grills
		[5836] = {814,858,1179,1816,2287,2455,2589,2592,2764,4359,4364,6536,6538,6540,6545,6552,6553,6563,6564,6575,6583,9767,9768,9770,9771,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,10407,15497}; --Engineer Whirleygig
		[5837] = {818,858,1179,1180,1210,1355,2287,2455,2589,2632,3013,3195,3311,4570,5030,5573,6344,6537,6539,6540,6541,6542,6543,6545,6546,6547,6548,6549,6550,6551,6553,6554,6555,6556,6557,6558,9747,9748,9749,9756,9757,9763,9765,9779,9785,9786,9788,14115,14365,15495}; --Stonearm
		[5838] = {1812,2287,2589,2592,5030,6539,6541,6545,6546,6547,6548,6551,6553,6554,7559,9779,9783,9785,9786,9788}; --Brokespear
		[5841] = {1812,2287,5030,6536,6539,6540,6541,6545,6546,6547,6548,6551,6553,6554,6557,9779,9785,9786,9788}; --Rocklance
		[5842] = {2318,2319,3180,5055,5062,5124,5635,6536,6538,6540,6545,6552,6553,6562,6564,6575,6582,6583,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9783,9784,9787,9788,9789,10407}; --Takk the Leaper
		[5847] = {1205,2035,2589,2592,4306,4542,4715,6566,6568,6573,6577,6579,6580,6584,6587,6602,9773,9793,9794,9802,9805,9810,9811,9814,9818}; --Heggin Stonewhisker <Bael'dun Chief Engineer>
		[5848] = {929,954,1205,1753,1797,2589,2592,3012,4306,4542,4715,6566,6567,6568,6569,6579,6584,6587,6591,6593,6594,6595,6596,6597,6600,6601,6602,6604,6612,6613,6614,9792,9793,9794,9795,9799,9801,9802,9803,9805,9806,9807,9810,9811,9813,9814,9815,9817,9818,211855}; --Malgin Barleybrew <Bael'dun Morale Officer>
		[5849] = {1205,2589,2592,2771,2772,2836,2838,4306,4542,4785,6566,6568,6573,6578,6579,6580,6586,6587,6591,6604,9773,9782,9796,9799,9805,9810,9811,9814,9817}; --Digger Flameforge <Excavation Specialist>
		[5851] = {1478,1755,1827,2589,2592,3012,3210,4715,6594,6597,6600,6601,6603,6604,6605,6611,6614,9791,9795,9797,9799,9803,9806,9807,9809,9817,9831,9838,10404}; --Captain Gerogg Hammertoe <Bael'dun Captain of the Guard>
		[5859] = {2589,2592,4538,4715,6591,6593,6595,6601,6604,9795,9799,9801,9802,9803,9806,9807,9815,9817,9818}; --Hagg Taurenbane <Razormane Champion>
		[5863] = {789,858,1179,1210,1539,2589,2592,2881,4537,6342,6536,6538,6540,6545,6552,6553,6562,6563,6564,6570,6574,6575,6581,6582,6583,6585,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9781,9784,9787,9788,9789,10287,10405,10407,14122,15493,15893,211823,211826,211834}; --Geopriest Gukk'rok
		[5864] = {929,2589,2592,4306,4538,6562,6564,6565,6566,6573,6574,6578,6580,6582,6583,6587,6591,9772,9773,9774,9781,9812,10287,10405,10407}; --Swinegart Spearhide
		[5865] = {1210,2318,2555,2934,3288,3291,4686,4893,5134,6266,6267,6268,6269,6336,6337,6512,6537,6539,6541,6542,6543,6548,6549,6555,6557,6558,9742,9743,9744,9746,9747,9748,9749,9750,9751,9752,9755,9756,9757,9758,9759,9760,9762,9763,9786,14110,211315,211319,211327,211331}; --Dishu
		[7895] = {4306,4338,7353,7436,7444,7448,7456,9844,9856,9863,9864,9869,9870,9871,15550}; --Ambassador Bloodrage
		[14221] = {1707,1708,3505,4306,5113,6986,7369,7418,7434,7437,7438,7440,7446,7447,7448,7458,9844,9848,9849,9850,9854,9855,9856,9859,9861,9864,9870,9871,9877,9886,11985}; --Gravis Slipknot
		[14222] = {1686,1687,2319,5637,7353,7357,7369,7417,7418,7423,7434,7436,7437,7446,7447,7448,7461,8146,9819,9826,9844,9845,9846,9852,9853,9855,9861,9865,9868,9869,9871}; --Araga
		[14223] = {3712,4555,4556,5524,6308,6610,7353,7355,7357,7366,7370,7406,7407,7409,7410,7416,7421,7422,7423,7424,9825,9826,9828,9832,9833,9834,9836,9839,9842,9853,9869,10289,10406,10408,10409}; --Cranky Benj
		[14281] = {422,1205,1775,1777,2589,2592,4306,6565,6568,6573,6574,6576,6577,6578,6579,6580,6582,6584,6586,6587,6588,6591,9772,9774,9781,9782,9793,9801,9802,9803,9810,9814,10287,10405}; --Jimmy the Bleeder
		[2258] = {4553,7067,7431,7433,7434,7437,7438,7440,7441,7443,7444,7445,7446,7447,7448,7454,7455,7456,7457,7458,7459,7461,7462,7483,7492,7912,8150,9844,9848,9849,9850,9851,9852,9856,9859,9862,9863,9864,9870,9871,9872,9877,9879,9885,9886,9889,9890,9896,9898,9900}; --Stone Fury
		[2447] = {4304,4402,4460,6444,7487,7524,7532,7533,7544,8146,9907,9908,9910,9926,9931,9932,9934,9967}; --Narillasanz
		[2452] = {1708,1710,3011,3385,3771,4304,5637,6331,8146}; --Skhowl
		[2453] = {1678,3771,4306,4810,6327}; --Lo'Grosh
		[2598] = {1625,1707,1708,1710,3778,3787,3797,3802,4306,4338,7440,7455,8748}; --Darbel Montrose <Shadow Council Warlock>
		[2600] = {1707,1708,1710,2592,3781,3793,3794,3800,3804,3827,4038,4306,4338,5180,5181}; --Singer
		[2601] = {3771,4306,4338}; --Foulbelly
		[2602] = {3385,3771,4306,4338}; --Ruul Onestone
		[2603] = {1708,1710,3771,4306,4338,4614,5256,7353,7369,7438,7446,7448,7454,7459,7461,7462,9845,9846,9848,9849,9856,9859,9864}; --Kovork
		[2604] = {4306,4338,7431,7440,7445,7454,7489,7492,9287,9288,9875,9876,9879,9886,9891,9896,9898}; --Molok the Crusher
		[2605] = {4306,4503,7273,7483}; --Zalas Witherbark <Warband Leader>
		[2606] = {1708,1710,2622,3385,3771,3781,3785,3816,4306,4338,5257,8151,9848,11166}; --Nimar the Slayer <Warband Leader>
		[2609] = {1708,1710,4306,4338}; --Geomancer Flintdagger
		[2779] = {1404,7072,7472,7478,7973,9285,17058}; --Prince Nazjak
		[14224] = {1645,3928,4005,4306,4338,4601,7191,7429,7469,7472,7473,7475,7476,7479,7484,7485,7487,7490,7493,7494,9061,9285,9287,9288,9289,9290,9291,9292,9876,9878,9881,9883,9885,9893,9894,9900,9902,9903,9904,9906,9925,9926,9929,9934,9968,9972,9973,10505,10561}; --7:XT <Long Distance Recovery Unit>
		[218273] = {}; --Wandering Swordsman
		[2744] = {1708,4306,4338,4616,7430,7454,7474,7475,7490,7492,7494,9889,9900}; --Shadowforge Commander
		[2749] = {3804,4552,4554,7429,7455,7470,7471,7474,7476,7479,7483,7490,7912,8163,9287,9875,9876,9879,9880,9885,9892,9895,9896,9901,9904,9909,9929}; --Siege Golem
		[2751] = {4552,4553,7353,7369,7407,7418,7434,7436,7437,7438,7443,7446,7447,7448,7457,7461,7912,8150,9845,9846,9848,9850,9852,9855,9856,9859,9863,9864,9868,9869,9870,9871,9872}; --War Golem
		[2752] = {4552,4554,4784,7067,7075,7468,7477,7525,7534,7535,7545,7848,7912,8120,8150,9921,9923,9925,9928,9933,9951,9970,10088}; --Rumbler
		[2754] = {4552,4554,7332,7468,7486,7525,7529,7534,7543,7544,7912,8120,8150,9912,9916,9921,9923,9928,9933,9959,9966,9970,10088,10089}; --Anathemus
		[2850] = {1688,4304,4580,7434,7438,7443,7444,7447,7454,7455,7457,7458,7459,7462,8146,9848,9849,9850,9851,9852,9856,9862,9863,9864,9870,9871,9872,9875,9877,9890}; --Broken Tooth
		[2931] = {2772,3404,3818,5117,10057,10091,10099,10100,10103,10106,10107,10109,10110,10113,10122,10123,10126,10167,10170,10171,10172,10175,10179,10183,10187,10189,10193,10199,10229,10231,10276,10278,11417,11419,11420,12037,12207,15420}; --Zaricotl
		[7057] = {1207,1708,1710,2289,3771,3779,3783,3785,3786,3797,3799,3805,3810,3813,3817,4306,4338,6412,6416,7458,7462,7909,9375,9378,9382,9881,12040}; --Digmaster Shovelphlange
		[14697] = {12841,22484,23090,23091,23092,23093}; --Lumbering Horror
		[16379] = {12841,22484,23090,23091,23092,23093}; --Spirit of the Damned
		[16380] = {12841,22484,23090,23091,23092}; --Bone Witch
		[8296] = {3961,4338,4422,4599,7519,7520,7528,7529,7539,7543,9938,9941,9945,9947,9948,9949,9962,10061,10067,10071,10075,10086,10092,10131,10201,10202,10206,10207,10209,10243}; --Mojo the Twisted
		[8297] = {10095,10106,10110,10119,10121,10124,10125,10168,10170,10175,10177,10229,14047}; --Magronos the Unyielding
		[8298] = {8952,9943,10064,10095,10096,10103,10107,10108,10109,10110,10120,10128,10166,10168,10173,10175,10176,10179,10183,10186,10199,10200,10229,10231,10241,10244,10276,10277,13443,14047,19260}; --Akubar the Seer
		[8299] = {1464,3404,5117,8146,8168,8396,10063,10073,10075,10084,10085,10133,10134,10173,10174,10176,10180,10190,10197,10203,10239,10240,10242,11417,11419,11420,12037,12207,15420}; --Spiteflayer
		[8300] = {4583,4584,8146,8391,10061,10073,10075,10083,10132,10134,10173,10185,10191,10239,12037,12203,12208,15294}; --Ravage
		[8301] = {8154,8170,8393,9943,9950,10064,10073,10077,10082,10085,10098,10108,10120,10166,10167,10174,10179,10186,10189,10190,10197,10198,10199,10200,10238,10241,12037,15408,19933,19934}; --Clack the Reaver
		[8302] = {4092,4093,4304,7528,8146,8394,9945,9947,9948,9952,9957,9964,9965,10060,10076,10080,10133,10174,10207,10593,11386,11387}; --Deatheye
		[8303] = {2295,3403,4304,7517,7527,8170,8392,9940,9952,9953,9954,9964,9965,10059,10060,10066,10076,10080,10081,10127,10133,10196,10203,10208,10209,10243}; --Grunter
		[8304] = {8766,8952,10095,10097,10100,10106,10111,10113,10119,10121,10123,10124,10169,10170,10177,10188,10212,10225,10233,10277,14047}; --Dreadscorn
		[10356] = {2672,2962,3299,3300,6266,6336,6507,6508,6509,6513,6514,6515,6517,6518,6519,6520,6521,7350,9744,9750,9758,9759,9761}; --Bayne
		[10357] = {2318,4865,6267,6269,6293,6296,6336,6506,6507,6509,6510,6512,6513,6514,6515,6517,6518,6519,6521,7073,7074,7350,7351,9742,9743,9745,9751,9752,9754,9755,9756,9758,9760,9761,9762,12223}; --Ressan the Needler
		[10358] = {118,159,774,1181,2589,2965,3013,4604,6266,6267,6268,6269,6336,6337,6506,6510,6512,6515,6518,6521,6549,6550,6555,6556,7351,8180,9742,9743,9744,9745,9746,9747,9748,9750,9751,9752,9754,9755,9756,9757,9758,9759,9760,9761,9762,9763,210771,211323,211324,211785}; --Fellicent's Shade
		[10359] = {1475,1476,3192,4684,4690,5465,6266,6267,6268,6269,6336,6337,6512,6537,6549,6550,6555,6557,9743,9744,9746,9747,9750,9751,9752,9755,9756,9757,9758,9759,9760,9762,9763,9765,9786}; --Sri'skulk
		[1531] = {118,159,766,774,805,818,828,1181,1414,1415,1417,2589,2598,2644,2645,2646,2774,3013,3189,3322,3609,3610,4496,4560,4563,4565,4604,5571,8177,8178,8179,8181,8182,210771,211315,211316,211318,211319,211320,211321,211322,211323,211325,211326,211328,211329,211330,211331,211785,211933}; --Lost Soul
		[1533] = {118,159,767,768,805,1181,1414,1417,1421,2140,2213,2589,2598,2642,2645,2959,2960,2961,2962,2964,2968,3013,3190,3323,4496,4562,4563,4604,4659,4662,4663,4666,5571,6269,6513,6520,6521,7109,8178,8181,9751,211315,211319,211321,211322,211323,211327,211780,211785,211933}; --Tormented Spirit
		[1910] = {118,159,805,2958,2962,3013,3214,4302,4561,4562,5069,5523,6266,6267,6268,6269,6303,6336,6337,6506,6507,6508,6509,6510,6512,6513,6514,6515,6517,6518,6519,6520,6521,7350,7351,8181,9742,9743,9744,9745,9750,9751,9752,9754,9755,9758,9759,9760,9761,211317}; --Muad
		[1911] = {118,159,779,1181,1497,1504,1737,3013,4303,5523,6266,6267,6268,6269,6303,6337,6506,6510,6512,6515,6518,6521,6542,6543,6549,6555,6556,7351,8180,9742,9743,9744,9745,9746,9747,9749,9750,9751,9752,9754,9755,9756,9757,9758,9759,9760,9761,9762,9763,211786}; --Deeb
		[1936] = {118,159,727,766,767,774,818,1411,1412,1413,1414,1415,1416,1417,1418,1425,1430,1431,1433,2070,2091,2138,2212,2589,2598,2642,2643,2644,2645,2646,2648,2773,2774,3013,3190,3334,3370,3373,3610,4261,4536,8177,8178,8182,211317,211325,211326,211331,211786,211933}; --Farmer Solliden
		[12431] = {2075,2318,2672,2974,3164,4566,4701,5069,6266,6267,6268,6269,6336,6337,6512,6537,6539,6541,6542,6543,6548,6549,6550,6555,6556,6557,6558,9742,9743,9744,9746,9747,9748,9749,9750,9751,9752,9755,9756,9757,9758,9759,9760,9762,9763,9764,9765,9786,211318,211786}; --Gorefang
		[12432] = {2318,2408,2934,2974,3173,3253,3609,4689,4690,5071,5635,6266,6268,6336,6512,6537,6539,6541,6542,6543,6546,6547,6548,6549,6550,6551,6554,6555,6556,6557,6558,9746,9747,9748,9749,9755,9756,9757,9759,9762,9763,9765,9785,9786,211316,211317,211318,211319,211326,211327}; --Old Vicejaw
		[12433] = {818,1475,2972,2987,3167,3174,3254,3651,4701,5465,6537,6539,6540,6541,6542,6543,6545,6546,6547,6548,6549,6550,6551,6553,6554,6555,6556,6557,6558,6560,9747,9748,9749,9756,9757,9763,9765,9779,9785,9786,9788,15268,211318,211327,211785}; --Krethis Shadowspinner
		[1920] = {414,1179,2589,2592,4436,4437,5110,8491}; --Dalaran Spellscribe
		[1944] = {858,1179,1752,2589,2592,3236,4439,4605,4710,5376,5975,6582,6584,16882}; --Rot Hide Bruiser
		[1948] = {858,1179,2455,2589,2592,4445,4605,6565,6566,6573,6574,6582,6586,6588,9772,9773,9774,9795,9810,9813,9815}; --Snarlmane
		[2283] = {1179,2589,2592,4605,5969,6628}; --Ravenclaw Regent
		[1837] = {8932,10144,10145,10147,10156,10219,10225,10258,10376,10380,10391,14047}; --Scarlet Judge
		[1838] = {8932,10149,10154,10161,10247,10273,10373,10378,10380,10383,14047}; --Scarlet Interrogator
		[1839] = {8932,10135,10142,10150,10151,10152,10162,10163,10220,10247,10250,10252,10253,10260,10261,10262,10263,10264,10265,10266,10269,10270,10272,10273,10274,10378,10382,10384,10388,10389,10390,14047,14555}; --Scarlet High Clerist
		[1841] = {8932,10105,10144,10210,10228,10230,10258,10275,14047}; --Scarlet Executioner
		[1843] = {8932,10137,10151,10378,10386,14047}; --Foreman Jerris
		[1844] = {10101,10181,10210,10216,10221,12836,14047}; --Foreman Marcrid
		[1847] = {6530,7972,8948,9954,10064,10073,10075,10082,10085,10122,10133,10174,10175,10190,10191,10196,10197,10198,10242,10243,12840,13356,14047}; --Foulmane
		[1848] = {8766,8932,10091,10095,10106,10121,10124,10125,10168,10170,10177,10188,10189,10229,10231,10276,10278,10282,12841,14047}; --Lord Maldazzar
		[1849] = {12841,13354,20400}; --Dreadwhisper
		[1850] = {12843,13356,14047}; --Putridius
		[1851] = {2450,4625,8836,10139,10146,10149,10153,10215,10220,10227,10248,10255,10268,10286,10378,10382,10386,12803}; --The Husk
		[1885] = {10118,10155,12719,14047}; --Scarlet Smith
		[10817] = {10122,10167,10240,14047}; --Duggan Wildhammer
		[10820] = {}; --Duke Ragereaver
		[10821] = {8766,8952,10100,10111,10113,10119,10123,10136,10138,10168,10169,10177,10219,10221,10223,10234,10277,10280,10381,12843,14047}; --Hed'mush the Rotting
		[10822] = {10100,10105,10113,10119,10123,10148,10159,10164,10181,10212,10219,10221,10222,10224,10232,10235,10237,10277,10279,10308,10377,10387,12804,14047}; --Warlord Thresh'jin
		[10823] = {3950,10145,10159,10214,10222,10269,12804,14047}; --Zul'Brin Warpbranch
		[10824] = {8766,8953,10105,10136,10144,10147,10222,10225,10228,10235,10249,10380,14047}; --Ranger Lord Hawkspear
		[10825] = {4552,4554,8146,10106,10193,10229,10276,12843}; --Gish the Unmoving
		[10826] = {7972,8766,8948,10111,10112,10119,10169,10223,12808,12843,14047,15043,16039,22526}; --Lord Darkscythe
		[10827] = {8766,8932,10057,10095,10106,10111,10113,10119,10125,10165,10168,10170,10177,10188,10193,10233,10240,10276,10282,14047}; --Deathspeaker Selendre <Cult of the Damned>
		[10828] = {8766,8932,10104,10138,10145,10154,10214,10222,10223,10235,10256,10281,10377,10381,14047,16885}; --High General Abbendis
		[14275] = {929,1205,1206,2592,3053,3693,4306,4542,4715,4999,6388,6590,6591,6592,6594,6595,6596,6597,6600,6601,6602,6603,6605,6607,6611,6612,6613,6614,6615,6617,7370,7415,9791,9796,9797,9798,9806,9807,9808,9809,9820,9821,9822,9823,9827,9829,9831,9837,9840,10404}; --Tamra Stormpike
		[14276] = {929,1205,3510,3716,5524,5785,6308,6395,6590,6592,6603,6607,6611,6615,6617,7355,7356,7370,7411,7413,7415,7416,7419,7421,7422,9791,9798,9820,9821,9823,9824,9825,9827,9829,9831,9832,9835,9837,9838,9839,9840,9841,9867,10288,10404,10409,11152,17057,17058,215398}; --Scargil
		[14277] = {1205,3509,6308,6609,6610,6616,7072,7354,7357,7366,7367,7406,7408,7409,7412,7413,7417,7418,7420,7421,7424,7446,7447,7448,7460,9819,9824,9825,9835,9836,9841,9842,9845,9847,9853,9855,9856,9860,9861,9865,9867,9868,9870,10289,10406,10408,10409,13048,17057,17058}; --Lady Zephris
		[14278] = {1205,2592,3385,3770,4306,4715,6211,6590,6591,6594,6595,6596,6597,6600,6601,6602,6605,6611,6612,6613,6614,7411,9796,9797,9798,9806,9807,9808,9809,9821,9822,9831,9837,9838,9839}; --Ro'Bark
		[14279] = {878,1081,1288,2251,3182,3477,4428,4715,6566,6567,6568,6578,6579,6580,6586,6587,6588,9773,9774,9782,9792,9796,9799,9802,9803,9805,9807,9810,9811,9814,9817,9818}; --Creepthess
		[14280] = {2319,2940,3476,3702,3730,4715,5635,6591,6593,6600,6602,6604,6605,9795,9796,9799,9802,9803,9806,9807,11406,11407}; --Big Samras
		[221333] = {3946,3975,3976,3997,4425,5636,7734,8766,8952,10305,11419,11420,12691,13443,13446,13816,13820,13821,13825,14293,15394,15420,15654,213547,220929}; --Doomkin
		[8210] = {5636,7491,7524,9959,9967,11417,12207}; --Razortalon
		[8211] = {4304,4583,4584,7470,7471,7479,7482,7488,8146,9285,9289,9874,9897,9903,9968,9973,12203,12208}; --Old Cliff Jumper
		[8212] = {3669,3670,3671,3673,3674,3676,3818,3928,4608,7296,7528,9941,9948,9953,9964,9965,10060,10066,10069,10076,10080,10085,10086,10127,10130,10131,10134,10201,10205,20763,20767}; --The Reak
		[8213] = {3712,4304,4555,4556,4603,7973,8167,8170,10061,10062,10063,10075,10129,10131,10132,10185,10191,10196,10243}; --Ironback
		[8214] = {1645,3928,4338,4602,7528,9913,9924,9936,9939,9941,9948,9949,9962,9963,9964,9965,10059,10060,10066,10067,10071,10076,10079,10086,10091,10127,10205,10207,10208}; --Jalinde Summerdrake
		[8215] = {4552,4554,7517,7527,7910,7912,8150,8924,9940,9953,9955,9965,10059,10062,10067,10071,10080,10086,10127,10129,10131,10134,10194,10196,13464}; --Grimungous
		[8216] = {1520,1645,4338,4599,7519,7528,7529,7532,7538,8151,8153,9259,9905,9913,9924,9937,9938,9945,9948,9949,9951,9963,10066,10079,10201,10202}; --Retherokk the Berserker
		[8217] = {1520,4338,4599,8152,8153,9259,10063,10083,10085,10174,10180,10185,10190,10196,10203,10238,10242,17050}; --Mith'rethis the Enchanter
		[8218] = {1520,3928,4306,4338,4599,7332,7486,7522,7525,7526,7533,7534,7535,7542,7543,7545,8120,8151,8153,9286,9906,9907,9913,9915,9921,9922,9923,9928,9959,9970,10087,10094,10201}; --Witherheart the Stalker
		[8219] = {1520,1645,3928,4306,4338,4599,7490,7491,8151,8153,9259,9286,9291,9874,9884,9887,9908,9909,9919,9926,9930,9931,9967,9969,9971}; --Zul'arek Hatefowler
		[1119] = {117,118,159,763,1181,1499,1501,1502,1505,1506,1509,1510,1511,1512,1513,1514,1515,1516,1731,1737,2140,2214,2254,2406,2589,2763,2777,2778,2881,3013,3192,3375,4684,5069,6267,6337,6518,6549,9755,9757,203753,205945,211329}; --Hammerspine
		[1130] = {2069,2965,3036,3173,3643,4561,4689,5069,5071,5635,6266,6267,6268,6269,6336,6337,6506,6510,6512,6515,6518,6521,6542,6549,6550,6555,6558,7351,9742,9743,9744,9745,9746,9748,9749,9750,9751,9752,9754,9758,9759,9760,9761,9762,9763,9765,203753,204809,206169,211332}; --Bjarn
		[1132] = {1965,2318,2672,2934,3224,3299,3300}; --Timber
		[1137] = {117,118,159,767,768,774,818,1181,1412,1413,1415,1417,1422,1430,1433,1438,2318,2642,2643,2644,2645,2648,2671,2773,2934,2964,2967,2968,3008,3013,3214,3225,3370,3373,4561,4562,4563,4666,5572,6508,6520,7109,8178,9750,9761,203753,204809,206169,211318,211329}; --Edan the Howler
		[1260] = {117,118,159,1181,1495,1497,1499,1502,1506,1510,1511,1513,1516,1730,1735,1737,2075,2140,2214,2546,2589,2763,2777,2958,2965,2972,3013,3223,4561,6337,6510,6513,6519,7108,8178,9745,9750,203753,204809,205945,211317,211933}; --Great Father Arctikus
		[208812] = {828,3169,3170,205979}; --Jorul
		[8503] = {118,159,1495,1497,1499,1501,1502,1503,1504,1506,1510,1511,1512,1513,1514,1515,1516,1732,1733,1734,2075,2140,2408,2589,2598,2763,2777,2778,2964,3013,3083,3084,3375,4540,4561,4562,6267,6510,6519,6549,6555,7351,9747,9754,9763,10553,10554,203753,205945,211317}; --Gibblewilt
		[228721] = {1728,2801,3475,12711,12717,12728,13000,13001,13006,13015,13028,13083,13107,13116,13123,13133,13493,13518,14510,14511,14553,14554,16055,16253,17010,17011,17012,22388,22390,227801,228250,228313,228314,228315,228317,228993}; --Lieutenant Skarresh
		[228728] = {13000,13001,13006,13015,13028,13083,13107,13116,13123,13133,228315}; --Flamebringer Kelris <Twilight Lord>
		[228969] = {1728,2801,3475,12702,12711,12717,12728,13000,13001,13006,13015,13028,13083,13107,13116,13123,13133,13493,13518,14507,14511,14553,14554,16055,16253,17010,17011,17012,22390,227801,228314,228315,228316,228317,228318,228993}; --Lord Gazzran
		[228970] = {1728,2801,3475,12702,12711,12717,12728,13000,13001,13006,13015,13028,13083,13107,13116,13123,13133,13518,14511,14553,14554,16253,17010,17011,17012,22390,227801,228250,228314,228315,228316,228317,228993}; --Galenges
		[8277] = {1074,4337,4585,7517,7519,7527,7528,7529,7539,8122,9913,9924,9936,9937,9938,9941,9947,9949,9951,9961,9964,10060,10067,10076,10079,10091,10201,10202,10209,10285,12205,14227}; --Rekk'tilac
		[8278] = {4552,4554,4784,7067,7075,7527,7848,7912,8150,9940,9955,9964,10059,10061,10066,10068,10081,10085,10129,10194,10205,10208,10242,22527}; --Smoldar
		[8279] = {4552,4554,7332,7477,7519,7520,7521,7522,7523,7526,7529,7530,7531,7535,7540,7541,7542,7543,7545,7546,7912,8120,8150,9912,9913,9915,9921,9922,9923,9933,9936,9938,9941,9947,9948,9951,9952,9956,9962,9966,10060,10067,10086,10087,10089,10090,10127,10201}; --Faulty War Golem
		[8280] = {5120,7519,7526,7529,7531,7535,7538,7539,7541,7543,9922,9948,9951,9960,9961,9962,10090,10091,10092,10127,10130,10201,10205,10206,10208,12683}; --Shleipnarr
		[8281] = {3857,4787,7068,7517,9924,9948,9955,10127,10129,10130,10185,10207,10509,11129}; --Scald
		[8282] = {3928,3970,3997,4338,4602,6149,8316,8754,9943,9953,9955,10062,10068,10074,10174,10186,10194,10196,10243,13824,13825}; --Highlord Mastrogonde
		[8283] = {1645,3928,4338,4601,7527,9940,9957,10058,10080,10081,10130,10131,10208,10209}; --Slave Master Blackheart
		[10077] = {4304,4583,4584,8146,9950,10073,10174,10184,10241,11467,12203,12208}; --Deathmaw
		[10078] = {8146,8766,8952,10091,10096,10099,10103,10106,10107,10110,10122,10125,10126,10128,10165,10167,10169,10170,10172,10175,10177,10179,10187,10189,10199,10223,10231,10240,10244,10276,12662,14047,14256,22338}; --Terrorspark
		[10119] = {3857,4787,7067,7068,7075,7076,7077,7078,10105,10136,10144,10147,10156,10159,10210,10211,10219,10222,10228,10230,10258,10267,10275,10280,10376,10379,10380,10381,10391,12828}; --Volchan
		[208841] = {}; --Revered Champion
		[8976] = {4304,4460,4557,8146,8170,10104,10136,10138,10146,10147,10156,10211,10225,10228,10230,10236,10263}; --Hematos
		[8978] = {8950,10106,10111,10113,10121,10123,10124,10159,10168,10169,10212,10229,10233,10276,10277,10282,14047}; --Thauris Balgarr
		[8979] = {8766,8952,10101,10104,10105,10112,10138,10145,10159,10211,10214,10216,10222,10226,10228,10234,10235,10236,10280,10380,10381,14047}; --Gruklash
		[8981] = {4552,4554,7912,8150,8838,10095,10101,10106,10110,10113,10119,10121,10122,10123,10125,10145,10164,10168,10170,10175,10177,10188,10223,10229,10231,10233,10276,10278,10282,11266}; --Malfunctioning Reaver
		[9602] = {8766,8952,10064,10077,10096,10098,10103,10107,10109,10122,10126,10128,10176,10179,10183,10199,10231,10244,14047}; --Hahk'Zor
		[9604] = {8766,8952,10096,10107,10109,10126,10183,10199,10200,14047}; --Gorgon'och
		[100] = {117,118,159,818,1181,1210,1307,1498,1499,1501,1502,1503,1504,1505,1506,1510,1511,1512,1513,1514,1515,1516,1730,1733,1734,1735,2075,2214,2215,2589,2777,3013,3374,4677,4689,4690,5069,5071,6269,6506,6550,6556,9742,9743,9746,9747,9756,9760,204809,211316}; --Gruff Swiftbite
		[471] = {727,768,774,2598,2958,2961,2963,2967,2968,3000,3174,3214,4496,4536,4563,4564,4663,4666,4689,5465,5572,6148,6337,6506,6507,6509,6510,6513,6514,6517,6519,6520,7350,8180,8181,9744,9745,9754,15895,204809,205945,210771,211315,211316,211318,211321,211323,211325,211330,211933}; --Mother Fang
		[472] = {117,159,2589,3233,5744}; --Fedfennel
		[61] = {118,159,727,774,1181,1495,1497,1506,1507,1509,1512,1514,1731,1737,2070,2214,2589,2778,2958,2961,2964,2965,2979,3013,3374,4561,4569,4684,6202,6203,6267,6337,6507,6509,6513,6514,6515,6519,6521,6716,7108,8180,9745,9753,9755,211315,211318,211320,211325,211780}; --Thuros Lightfingers
		[79] = {118,159,727,768,774,818,1913,2075,2589,2645,2959,2960,2961,2962,2963,2964,2967,3013,3192,3214,4536,4561,4566,4577,4663,4666,5572,6147,6269,6336,6507,6509,6514,6515,6517,6519,7108,8178,8181,9745,9746,9750,9751,9760,15925,204809,211316,211321,211328,211933}; --Narg the Taskmaster
		[99] = {118,159,768,774,818,828,1917,2070,2075,2091,2589,2957,2958,2959,2962,2963,2964,2967,2968,3013,4496,4562,4563,4663,4666,4689,5069,6201,6266,6336,6506,6509,6514,6519,6520,7350,8178,8181,9743,9750,9762,15895,15925,211316,211318,211319,211327,211329,211332,211785}; --Morgaine the Sly
		[503] = {929,1187,1205,2592,3782,3783,3786,3816,4306,4462,4606,6530,8746,15231,213544}; --Lord Malathrom
		[507] = {929,1205,2319,2794,3385,3612,3793,3807,4474,4606,5637,6204}; --Fenros
		[521] = {1015,1206,2318,2319,3018,3227,3301,3402,5635,6382,11982,14175,211935}; --Lupos
		[534] = {929,1205,1478,1712,2319,3770,3780,3785,3806,3811,3816,4476,4477,5637,7357,9850}; --Nefaru
		[574] = {878,1074,1081,1130,1288,2251,3174,3182,4448,4449}; --Naraxis
		[771] = {1205,2592,2794,4306,4464,4465,4606}; --Commander Felstrom
		[1398] = {1179,1215,1938,2287,2589,2592}; --Boss Galgosh <Stonesplinter Chieftain>
		[1399] = {1179,2241,2287,2589,2592,3571}; --Magosh <Stonesplinter Tribal Shaman>
		[1425] = {858,1179,1180,1495,1498,1499,1501,1502,1505,1510,1511,1513,1515,1516,1731,1732,1733,1734,2079,2214,2284,2408,2455,2589,2700,2763,2971,2976,3013,3036,3374,3375,4537,4570,4571,4699,6195,6342,6543,6547,6556,211320,211331,211785}; --Grizlak
		[14266] = {1081,1475,2078,2606,2988,2989,3174,3931,4575,5465,6536,6538,6540,6545,6552,6553,6560,6562,6563,6564,6565,6570,6574,6575,6576,6581,6582,6583,6585,9766,9767,9768,9770,9771,9772,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,10287,10405,10407}; --Shanda the Spinner
		[14267] = {929,1205,1206,1210,1478,2589,2592,2607,2821,3199,3385,3770,4306,4700,6536,6538,6540,6545,6552,6553,6562,6563,6564,6565,6570,6574,6575,6576,6581,6582,6583,6585,9766,9767,9768,9770,9771,9772,9775,9776,9777,9779,9780,9783,9784,9787,9788,9789,10287,10407}; --Emogg the Crusher
		[14268] = {556,2700,2970,2972,2977,3645,3882,4775,4776,5573,6537,6538,6539,6540,6541,6542,6543,6545,6546,6547,6548,6549,6550,6551,6553,6554,6555,6556,6557,6558,6889,9747,9748,9749,9756,9757,9763,9765,9768,9770,9779,9784,9785,9786,9787,9788,9789,15926,17056,211321}; --Lord Condar
		[2476] = {2318,2319,2924,2925,2939,2985,3181,3401,3563,4568,6197,14170,211836}; --Large Loch Crocolisk
		[14269] = {6562,6563,6564,6565,6568,6573,6574,6575,6576,6577,6578,6581,6582,6583,6585,7091,9451,9766,9772,9774,9782,10405,10407}; --Seeker Aqualon
		[14270] = {730,858,1179,1180,1467,1468,1469,3040,5523,5784,6289,6536,6538,6540,6545,6552,6553,6562,6564,6565,6570,6575,6581,6582,6583,6585,9766,9767,9768,9770,9771,9772,9775,9776,9777,9779,9780,9784,9787,9788,9789,9790,9812,10287,10407,14174,211820,211825,211830,211854}; --Squiddic
		[14271] = {858,955,1013,1179,1212,1214,2287,2455,2589,2592,2856,2986,6536,6538,6539,6540,6541,6545,6546,6547,6548,6551,6552,6553,6554,6557,6560,6575,6585,9766,9767,9768,9770,9775,9776,9777,9779,9780,9783,9784,9785,9786,9787,9788,9789,14167,211820,211831,211855,211935}; --Ribchaser
		[14272] = {1206,1210,1221,3176,3177,5635,6536,6538,6540,6545,6546,6547,6551,6552,6553,6554,6562,6563,6564,6575,6581,6583,6585,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9783,9784,9785,9787,9788,9789,10407,211822}; --Snarlflare
		[14273] = {4715,5741,6566,6567,6568,6569,6579,6584,6587,6591,6593,6604,9792,9793,9794,9795,9799,9801,9802,9803,9806,9807,9810,9811,9813,9814,9815,9817,9818}; --Boulderheart
		[214456] = {790,929,954,1205,1206,1299,1300,1478,1705,1747,1750,1774,1795,1820,1821,1823,2409,2589,2592,3039,3065,3198,3385,3770,4306,4709,4998,6381,6382,6383,6566,6570,6576,6577,6578,6580,6586,9781,9782,9793,9805,9815,10424,12006,12979,12984,14171,15211,15223,211488}; --Dro'zem the Blasphemous
		[584] = {929,1205,1805,1828,2058,2589,2592,3231,3385,3770,4306,15212}; --Kazon
		[616] = {878,1081,1288,2251,3174,3182,3229,4428,6565,6566,6568,6569,6573,6577,6578,6580,6582,6586,6587,6588,9772,9773,9774,9782,9805,9811,9812,10287}; --Chatter
		[947] = {929,1075,1759,1782,1831,2589,2592,2766,3012,3385,3770,4306,4446,4447,9792,215398}; --Rohh the Silent
		[14487] = {5785,6362,7433,7434,7457,7462,9864,9872,9889,9890,17057,17058}; --Gluggle
		[14488] = {1708,2734,2738,3771,4306,4338,7433,7434,7435,7440,7441,7443,7445,7456,7459,7493,9289,9862,9866,9871,9877,9879,9886,9890,9895,9898,9901,9904}; --Roloch
		[14490] = {4860,6308,7541,9919,17057}; --Rippa
		[14491] = {2799,4096,4099,4304,5637,7470,7471,7472,7473,7486,7487,7488,7490,7491,7494,7524,9285,9288,9289,9290,9292,9874,9878,9884,9887,9893,9903,9909,9926,9927,9928,9931,9972,9973}; --Kurmokk
		[14492] = {1630,2749,3917,4306,4338,4599,7479,7481,7482,7485,9290,9292,9883,9893,9897,9903,9908,9927,9968,9972}; --Verifonix <The Surveyor>
		[1552] = {1604,4092,4093,4304,4478,8146,11386,11387}; --Scale Belly
		[2541] = {1645,2728,3928,4603,5028,5029,7973}; --Lord Sakrasis
		[723] = {1680,3930,4306,4338,7486,7524,9906,9908}; --Mosh'Ogg Butcher
		[9046] = {8766,8952,14047,18987}; --Scarshield Quartermaster <Scarshield Legion>
		[1063] = {4304,4402,4460,4557,7517,7519,7521,7528,7529,7530,7532,7535,7540,7541,7543,7546,8146,8170,9922,9951,9956,9960,9961,9963,10086,10087}; --Jade
		[1106] = {1708,1710,3771,4306,4338,7444,7458,7462,9863,9871,9872}; --Lost One Cook
		[14445] = {3358,4021,4304,4599,5803,7332,7468,7477,7524,7525,7534,7535,7540,7541,7545,8120,9915,9916,9917,9921,9923,9959,9966,10088,10089,10090,10094}; --Lord Captain Wyrmak
		[14446] = {1645,4603,7470,7478,7479,7482,7487,7488,7491,7533,7973,8120,9290,9291,9292,9874,9884,9887,9907,9908,9909,9917,9920,9926,9930,9931,9934,9959,9967,9968,9969,9971,17058}; --Fingat
		[14447] = {1645,3928,4603,7469,7478,7481,7487,7973,9290,9874,9887,9893,9908,9909,9919,9922,9926,9927,9930,9931,9932,9933,9967,9969,9972,10090,10094,17058}; --Gilmorian
		[14448] = {2453,3357,3818,4608,5608,6065,7470,7471,7472,7479,7481,7482,7490,8831,9285,9290,9893,9904,9926,9927,9929,9968,9973,10286}; --Molt Thorn
		[763] = {1708,1710,3771,4306,4338,7454,7455,7459,9879,9886,9891}; --Lost One Chieftain
		[1424] = {818,858,1179,1180,1181,1210,1497,1498,1499,1506,1509,1510,1511,1515,1516,1731,1732,1735,2215,2455,2589,2657,2770,2771,2777,2836,2980,3036,3375,4537,4570,4571,5071,6205,6206,6555,6556,9763,9785,15210,208741,211326,211785,211933}; --Master Digger
		[462] = {555,729,2447,4454,5114,5115,5116,5636,5971,8183,9803,11416,17056}; --Vultros
		[506] = {725,1179,2203,2204,2287,2589,2592,2770}; --Sergeant Brashclaw
		[519] = {730,774,858,1179,1210,1357,1497,1498,1501,1502,1506,1509,1510,1511,1512,1513,1514,1515,1516,1732,1733,2073,2214,2763,2777,2778,2973,2977,2984,3013,3188,3374,3645,4570,5503,5523,5573,6180,6289,6378,6537,6556,9757,9765,9786,15268,15926,208741,211325,211330}; --Slark
		[520] = {730,858,955,1179,1180,1357,1738,1742,1743,1745,1764,1766,1767,1768,1769,1770,1787,1789,1811,1812,1814,1815,1816,1817,2217,2235,2455,2764,2780,2781,2987,3040,3376,4293,4345,4699,5503,5523,5784,6179,6289,9787,14166,208741,211821}; --Brack
		[572] = {1179,1314,1387,2085,2589,2592,4605,6530}; --Leprithus
		[573] = {732,814,933,1274,4359,4361,4363,4434}; --Foe Reaper 4000
		[1037] = {929,1205,2592,3337,3770,4306,4715,6587,6590,6592,6603,6607,6611,6617,7131,7355,7356,7366,7370,7409,7411,7415,7416,7419,9791,9798,9805,9817,9821,9822,9823,9824,9825,9827,9828,9829,9831,9832,9837,9838,9840,9841,9842,9847,10288,10289,10404,10406,10408,10409}; --Dragonmaw Battlemaster
		[1112] = {878,1081,1288,2251,3174,3182,4428,4444,6199}; --Leech Widow
		[1140] = {1696,1697,3685,4461,4463,5635,6198,12184}; --Razormaw Matriarch
		[14424] = {765,785,929,954,1205,1478,2447,2449,2450,2452,2453,3385,4606,4709,4715,6566,6567,6568,6569,6579,6584,6591,6593,6595,6596,6600,6602,6604,6613,6614,9792,9793,9794,9795,9796,9799,9801,9802,9803,9805,9806,9807,9810,9811,9813,9814,9815,9817,9818,211823}; --Mirelow
		[14425] = {2589,2592,2611,4715,6566,9774,9782,9805,9814,11968}; --Gnawbone
		[14433] = {814,858,1825,2452,2455,2785,3380,3385,3669,3671,3674,3676,5504,6590,7296,7356,7370,7415,7416,7419,9821,9827,9832,9837,9838,9847,9867,10288,10404}; --Sludginn
		[2090] = {790,929,1205,1712,1747,1796,1819,1822,2589,2592,3385,3770,4306,5749,5750}; --Ma'ruk Wyrmscale <Dragonmaw Warlord>
		[2108] = {929,1205,1478,1785,1808,1810,1831,2221,2592,3385,3392,3770,4306,6200,6596,7131,215411}; --Garneg Charskull
		[14428] = {118,159,766,774,818,828,1181,1412,1414,1415,1416,1417,1421,1422,1423,1427,1430,1433,2138,2212,2589,2598,2642,2643,2648,2773,2774,3013,3189,3190,3370,4536,4560,4563,4565,5571,8177,8178,8179,8182,18611,210771,211319,211323,211325,211326,211327,211787,211933,211934}; --Uruson
		[14429] = {818,858,1179,1181,2140,2455,2589,3013,4537,4562,4675,4681,6266,6267,6268,6269,6336,6337,6506,6507,6509,6510,6513,6514,6515,6517,6518,6521,6555,7350,7351,9743,9744,9745,9746,9747,9750,9751,9754,9756,9758,9760,9761,9762,9763,14086,14094,14098,15008,15297}; --Grimmaw
		[14430] = {767,818,2318,2447,2598,2934,3282,3409,3644,5571,6267,6337,6506,6507,6508,6509,6510,6513,6514,6515,6517,6518,6519,6520,6521,7350,7351,9742,9743,9744,9745,9750,9752,9754,9758,9760,9761,14087,14093,14095,15003,15004,15005,15007,15008,15010,15297,15483,211317,211331}; --Duskstalker
		[14431] = {117,118,159,766,767,1181,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1425,1427,1429,1430,1433,2138,2212,2213,2589,2635,2642,2643,2644,2646,2648,2773,2774,3013,3189,3190,3370,3373,4562,4563,4775,4776,5204,8182,18612,210771,211315,211318,211327,211332}; --Fury Shelda
		[14432] = {117,118,159,774,818,1181,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1422,1423,1425,1427,1429,1430,1431,1433,2138,2212,2213,2589,2635,2642,2643,2644,2645,2646,2648,2773,2774,3013,3370,3373,4496,18610,211316,211325,211329,211787}; --Threggil
		[209928] = {3169,3170,205979,211330}; --Mowgh
		[3535] = {118,159,765,785,818,856,1497,1499,1502,1503,1504,1505,1506,1510,1511,1512,1513,1514,1730,1732,1737,2215,2447,2449,2632,2763,2777,2778,3013,3192,3283,3287,3288,3305,3375,3654,4577,4604,5069,5179,14102,14110,14114,15298,15306,15970,210771,211321,211332,211780}; --Blackmoss the Fetid
		[2172] = {2318,2319,4775,4776,5114,5115,5469,6536,6552,6562,6563,6564,6573,6575,6581,6585,6588,9766,9768,9771,9775,9776,9780,9783,9784,10407,17056}; --Strider Clutchmother
		[2175] = {2318,2934,3292,3303,4567,5134,5413,5573,6266,6267,6268,6269,6336,6337,6512,6527,6537,6539,6541,6542,6543,6548,6549,6550,6555,6556,6557,9742,9743,9744,9746,9747,9748,9749,9750,9751,9752,9755,9756,9757,9758,9759,9760,9762,9763,9765,9786,14099,15015,211326}; --Shadowclaw
		[2184] = {858,1179,1210,1789,2079,2455,2589,2592,3306,4345,4537,4567,6536,6538,6539,6540,6541,6545,6546,6547,6548,6551,6552,6553,6554,6557,6575,6585,9766,9767,9768,9770,9771,9775,9776,9777,9779,9780,9783,9784,9785,9786,9787,9788,9789,14123,14160,15308,15497,211831}; --Lady Moongazer
		[2186] = {858,1179,1742,1743,1787,1794,1816,2589,2592,3311,4537,6537,6538,6539,6540,6541,6542,6543,6545,6546,6547,6548,6550,6551,6553,6554,6556,6557,6558,9748,9749,9757,9770,9785,9786,9787,9788}; --Carnivous the Breaker
		[2191] = {858,1179,2287,2589,3312,4564,6266,6268,6336,6512,6537,6539,6541,6543,6546,6547,6548,6549,6550,6551,6554,6555,6556,6557,6558,9746,9747,9748,9755,9756,9757,9759,9762,9763,9765,9785,9786,14115,14561,14723,15013,15298,15485,15490,208744,210771,211317,211319,211330,211785}; --Licillin
		[2192] = {858,1179,1739,1764,1812,2287,2455,2589,2592,3040,6536,6538,6540,6545,6552,6553,6562,6563,6564,6565,6570,6574,6575,6581,6582,6583,6585,9766,9767,9768,9770,9771,9772,9775,9776,9777,9779,9780,9781,9783,9784,9787,9788,9789,9812,10287,10405,10407,14131,14367}; --Firecaller Radison
		[7015] = {730,858,955,1179,2455,5523,5784,6289,6536,6537,6538,6539,6540,6541,6542,6543,6545,6546,6547,6548,6550,6551,6552,6553,6554,6556,6557,6558,9748,9749,9757,9765,9767,9768,9770,9775,9777,9779,9784,9785,9786,9787,9788,9789,14096,14131,14364,14724,14727,211837}; --Flagglemurk the Cruel
		[7016] = {858,1179,1749,1799,1821,2455,2765,5503,5523,6289,6332,6333,17057,211819}; --Lady Vespira
		[7017] = {818,858,955,1179,1180,3013,3036,3196,3305,4569,5523,6289,6536,6537,6538,6539,6540,6541,6542,6543,6545,6546,6547,6548,6549,6550,6551,6552,6553,6554,6555,6556,6557,6558,9747,9748,9749,9756,9757,9763,9765,9768,9770,9779,9785,9786,9788,9789,15012,211830}; --Lord Sinslayer
		[10559] = {1205,5445,5503,5523,6308,6562,6563,6564,6565,6566,6573,6574,6576,6577,6578,6579,6580,6581,6582,6583,6588,6591,9772,9774,9781,9812,10287,10405,10407,16654,17057}; --Lady Vespia
		[10639] = {929,954,1205,2589,2592,3385,4306,4538,4715,6566,6567,6568,6569,6579,6584,6587,6591,6593,6594,6595,6596,6602,6604,6612,6613,9792,9793,9794,9795,9796,9799,9801,9802,9803,9805,9806,9807,9810,9811,9813,9814,9815,9817,9818,14182,16645,16647,16651,16654,211829}; --Rorgish Jowl
		[10640] = {929,2592,4306,4538,4715,6591,6593,6594,6596,6600,6602,6604,6615,9795,9796,9799,9802,9803,9806,9807,9817}; --Oakpaw
		[10641] = {1205,2450,4606,6566,6567,6568,6569,6579,6584,6587,6600,9792,9793,9801,9802,9803,9805,9806,9807,9810,9811,9813,9814,9817,9818}; --Branch Snapper
		[10642] = {4715,5446,5447,5448,5451,6591,6600,6602,6604,6605,6612,6613,6614,7070,7091,9451,9795,9796,9803,9806,9807}; --Eck'alom
		[10643] = {730,1205,1468,5524,5784,6308,6565,6567,6568,6573,6577,6578,6579,6580,6582,6586,6588,6591,9772,9773,9774,9781,9782,9802,9812,9814,10405,17057}; --Mugglefin
		[10644] = {1015,2318,2319,3301,3402,5635,6562,6563,6564,6565,6566,6569,6576,6578,6579,6580,6582,6583,6587,6591,9772,9773,9781,9812,10405,10407}; --Mist Howler
		[10647] = {1205,2592,3770,4306,5481,6609,6610,7366,7406,7412,7422,9834,9841,9842,9853,10408,10409}; --Prince Raze
		[12037] = {2940,3702,3730,5635,6617,7355,7366,7409,7410,7411,7412,7416,7419,9821,9823,9827,9828,9833,9839,9840,10288,10289,10404,10406,11406,11407,16648}; --Ursol'lok
		[3735] = {929,954,1205,2589,2592,3385,4306,4606,6562,6563,6564,6565,6566,6568,6569,6570,6573,6574,6576,6577,6578,6579,6580,6581,6582,6583,6584,6586,6587,6588,6591,9772,9773,9774,9781,9782,9792,9801,9805,9810,9811,9812,9813,9814,9818,10287,10405,10407,211820,211853}; --Apothecary Falthis
		[3773] = {929,1205,2592,2785,4306,4606,4715,6569,6584,6590,6593,6594,6596,6597,6600,6601,6602,6604,9792,9793,9794,9795,9799,9802,9803,9806,9807,9810,9815,9817}; --Akkrilus
		[3792] = {1205,3770,5635,5637,5753,5754}; --Terrowulf Packlord
		[14426] = {929,1205,1705,2592,2819,3770,4306,4715,6590,6591,6592,6593,6594,6595,6596,6597,6600,6601,6602,6604,6605,6607,6611,6612,6613,6614,7415,7419,9791,9795,9796,9797,9798,9799,9802,9803,9806,9807,9808,9809,9817,9821,9827,9829,9831,9837,9838,10404,14197,215413}; --Harb Foulmountain
		[14427] = {929,1205,2592,2771,4306,4538,4715,5842,6590,6591,6597,6600,9796,9806,9807,9809,9829}; --Gibblesnik
		[4132] = {5853,5854,5877,6300,6302,7438,7444,7446,7448,7461,7462,8224,9848,9849,9850,9859,9868,9870}; --Silithid Ravager
		[5933] = {1708,2592,3771,4306,6603,6607,6617,7355,7356,7370,7410,7411,7416,9821,9823,9828,9832,9837,9839,9840,9841,10404}; --Achellios the Banished
		[5934] = {1686,1687,5637,5809,6609,6616,7354,7355,7357,7366,7367,7369,7370,7406,7407,7409,7410,7411,7412,7414,7416,7417,7421,7422,7423,7424,7460,9820,9823,9824,9826,9828,9833,9834,9839,9840,9841,9842,9857,9861,9865,9868,9869,10288,10289,10406,10408,10409,15142,15892}; --Heartrazor
		[5935] = {1701,1702,4093,4235,5637,5798,7446,7462,8223,9863,9871,11386}; --Ironeye the Invincible
		[5937] = {1288,2319,5794,5798,7353,7368,7369,7418,7436,7443,7444,7446,7460,7461,9819,9850,9857,9860,9861,9864,9868,9869,12037,19937,19938}; --Vile Sting
		[4015] = {1206,1210,2319,5135,5136,5635,5637,5751,5752,5808,9773,12007,14158,14375,14742,14748,15117,15224,15259,15330,15336,15504,15520,15527,211784,211819,211820,211826,211835,211836,211837}; --Pridewing Patriarch
		[4030] = {3857,4606,5664,6590,6603,6607,6615,6617,7356,7416,7422,9798,9821,9822,9827,9829,9831,9837,9838,9841,10404,10406,11151}; --Vengeful Ancient
		[4066] = {2319,3175,3179,4402,5583,5635,5637,6590,6607,6611,6617,7356,7419,9821,9824,9827,9838,9841,10404}; --Nal'taszar
		[5915] = {1755,1757,1783,1784,1785,1808,1827,1830,2592,2819,3385,4306,4538,6592,6594,6595,6596,6603,6611,6613,6614,6615,7366,7410,7411,7415,7416,9791,9797,9808,9821,9822,9829,9831,9832,9838,9839,10288,10406,15973}; --Brother Ravenoak
		[5916] = {929,1205,1760,1780,1828,1831,2592,2786,3385,4306,4538,4715,6591,6592,6593,6594,6595,6596,6597,6600,6601,6602,6604,6605,6611,6614,6617,7356,7415,7419,9795,9796,9798,9799,9802,9803,9806,9807,9808,9809,9817,9821,9827,9829,9831,9838,10404,14195,15537,15974}; --Sentinel Amarassan
		[5928] = {4633,4715,5136,5137,5637,5808,6590,6591,6592,6593,6594,6595,6596,6597,6600,6601,6602,6603,6604,6605,6607,6611,6613,6615,7356,7419,8183,9791,9795,9796,9797,9798,9799,9802,9803,9806,9807,9809,9817,9821,9827,9829,9831,9837,9838,14177,14372,14400,15132}; --Sorrow Wing
		[5930] = {929,1205,2592,3770,4306,4715,5116,5117,5635,6590,6591,6594,6595,6596,6597,6600,6601,6602,6603,6605,6607,6611,6612,6613,6614,6615,7356,7410,7419,9769,9796,9797,9806,9807,9808,9809,9821,9822,9827,9828,9829,9831,9832,9840,10288,10404,14182,14573,15347,17056}; --Sister Riven
		[5931] = {422,929,1205,2589,2592,4306,6566,6568,6573,6577,6578,6579,6580,6587,6588,6604,9782,9794,9799,9801,9802,9805,9811,9813,9814,9817,16882}; --Foreman Rigger
		[5932] = {929,1205,1210,2589,2592,3012,3193,3385,3770,4306,6562,6563,6564,6565,6566,6567,6568,6570,6574,6576,6577,6578,6579,6580,6581,6582,6583,6586,6587,6588,6591,9766,9772,9773,9774,9781,9782,9793,9805,9811,9812,9813,9814,9818,10287,10405,10407,12054,14164,15230}; --Taskmaster Whipfang
		[11688] = {1645,4306,4338,4599,7478,7487,7491,9290,9291,9874,9884,9887,9909,9919,9930,9931,9967,9969,9971,17684}; --Cursed Centaur
		[14225] = {2592,3771,4306,6246,6247,6989,7354,7367,7368,7369,7409,7420,7424,9825,9833,9836,9867,9869}; --Prince Kellen
		[14226] = {1708,4306,6252,7429,7474,7492,9878,9885,9892,9900}; --Kaskk
		[14227] = {1701,1702,4093,5637,7432,7433,7434,7438,7443,7444,7445,7446,7448,7454,7455,7457,7458,7461,7462,7493,9844,9851,9859,9862,9863,9864,9866,9870,9871,9872,9875,9876,9877,9886,9891,9901,11386}; --Hissperak
		[14228] = {2319,3402,4582,5637,7354,7357,7368,7408,7413,7414,7417,7421,7423,7436,7438,7446,7448,7460,9819,9826,9833,9845,9847,9853,9857,9860,9863,9865,9867,9868,9869,12037,12203}; --Giggler
		[14229] = {6362,7072,7368,7369,7417,7418,7436,7461,9826,9845,9853,9855,9861,9868,15881,17057,17058}; --Accursed Slitherblade
		[5343] = {1645,3928,4424,4603,6149,7332,7468,7477,7519,7521,7522,7523,7525,7526,7530,7531,7534,7535,7539,7540,7541,7542,7543,7545,7546,7973,8120,9247,9911,9912,9913,9915,9922,9923,9924,9933,9948,9951,9956,9959,9960,9961,10087,10088,10090,10091,10092,10202,10205,10206}; --Lady Szallah
		[5345] = {7534,8705}; --Diamond Head
		[5346] = {3928,7527,8973,9924,9937,9951,10076,10201,10206}; --Bloodroar the Stalker
		[5347] = {4590,5117,5829,7520,7528,7529,7538,7543,9591,9592,9913,9924,9936,9937,9938,9939,9945,9947,9951,9954,9955,9957,9961,9962,9963,10060,10063,10066,10072,10079,10091,10092,10185,10194,10201,10202,10206,11417,11418,14835}; --Antilus the Soarer
		[5349] = {4304,6444,6826,8170,9939,9941,9947,9948,9949,9952,9964,9965,10060,10066,10071,10076,10079,10086,10127,10201,10205,10207}; --Arash-ethis
		[5350] = {6300,6302,7519,7520,7526,7529,7532,7535,7540,7541,7543,8705,9939,9940,9951,9952,9960,9962,10091,10092}; --Qirot
		[5352] = {6258,8146,9874,9910,9930,9970,11408,11409,11410,11411}; --Old Grizzlegut
		[5354] = {9919,9931,9932}; --Gnarl Leafbrother
		[5356] = {4304,4583,4584,7470,7471,7472,7479,7482,8146,9287,9883,9893,9897,9903,9909,9968,9972,12203,12208}; --Snarler
		[14230] = {1708,1710,4639,5785,5847,6362,7429,7430,7431,7432,7433,7434,7435,7441,7444,7445,7454,7455,7456,7457,7459,7462,7476,7480,7483,7492,9287,9289,9844,9851,9852,9854,9862,9863,9866,9871,9872,9875,9876,9877,9878,9879,9890,9891,9894,9896,9898,17057,17058,215396}; --Burgle Eye
		[14231] = {1708,4607,7433,7434,7437,7443,7444,7446,7448,7457,7458,7461,7462,9856,9871,9872,9875}; --Drogoth the Roamer
		[14232] = {4461,4586,4587,5637,7429,7432,7441,7443,7444,7445,7457,7458,7459,7462,7493,8146,9844,9851,9852,9854,9862,9866,9872,9875,9877,9886,9890,9896,9898,12184}; --Dart
		[14233] = {770,3357,3667,4304,7429,7431,7432,7435,7440,7445,7454,7455,7456,7459,7493,9852,9854,9866,9875,9876,9877,9879,9886,9890,9891,9892,9894,9895,9896,9902}; --Ripscale
		[14234] = {4304,5636,6444,6826,7430,7439,7472,7474,7475,7479,7481,7483,7484,7489,7490,7493,7533,9287,9289,9291,9876,9881,9889,9894,9902,9904,9906,9909,9916,9929,9967,9970}; --Hayoc
		[14235] = {3669,3670,3671,3673,3674,3676,3938,3989,7296,7478,7479,7481,7482,7487,7488,7490,7491,7524,7533,9290,9291,9874,9883,9884,9887,9906,9908,9909,9916,9917,9919,9920,9925,9930,9931,9956,9972,10089,20763,20767}; --The Rot
		[14236] = {4603,6149,7469,7486,7522,7524,7533,7544,7973,9286,9291,9874,9884,9906,9907,9908,9909,9910,9915,9916,9917,9919,9920,9925,9926,9930,9931,9932,9934,9959,9971,10087,10092}; --Lord Angler
		[14237] = {3669,3676,7332,7470,7471,7472,7473,7478,7479,7481,7484,7485,7486,7488,7522,7524,9285,9287,9289,9292,9878,9881,9883,9884,9893,9894,9897,9903,9904,9932,9934,9967,9970,9972,9973}; --Oozeworm
		[4339] = {4304,4402,4460,6444,7332,7477,7525,7529,7530,7534,7540,7545,8146,9910,9912,9915,9920,9925,9928,9934,9945,9947,9959,9961,9966,9970,10094}; --Brimgore
		[4380] = {1074,4337,4585,5637,5884,7439,7483,9889,9891,9892,10285,12205}; --Darkmist Widow
		[8199] = {1520,3928,4306,4338,4599,7523,7524,7525,7533,7534,7544,8151,9906,9921,9925,9928,9951,9959,9962,9966,10088}; --Warleader Krazzilak
		[8200] = {1520,4306,4338,4599,7521,7530,7540,8120,8151,9922,9964}; --Jin'Zallah the Sandbringer
		[8201] = {1645,4338,4599,17055}; --Omgorn the Lost
		[8202] = {4338,9913}; --Cyclok the Mad
		[8203] = {4338,4599,7519,7520,7526,7528,7529,7530,7531,7532,7535,7540,7543,9911,9951,9960,9961,10087,10090,10091,10092,20519}; --Kregg Keelhaul
		[8204] = {6300,6302,9939,10066,10083,10130}; --Soriid the Devourer
		[8205] = {6300,6302,9936,9957,10067,10083,10208}; --Haarka the Ravenous
		[8207] = {1464,3404,5117,5829,7526,7531,7543,8146,9911,9956,10088,11417,11418,12207}; --Greater Firebird
		[8208] = {4583,9439,12037,12203,12208}; --Murderous Blisterpaw
		[13896] = {3712,4304,4555,4556,7973,8167,8170,8959,9954,10063,10064,10068,10073,10083,10084,10085,10103,10108,10132,10133,10134,10174,10179,10180,10184,10190,10191,10196,10197,10203,10238,10239,10242}; --Scalebeard
		[6118] = {1645,3928,4338,4608,7519,7520,7528,7529,7532,7538,7539,7540,7543,7972,9905,9913,9924,9937,9938,9941,9945,9947,9948,9949,9951,9960,9961,9962,9963,9964,10079,10091,10092,10201,10202,10206}; --Varo'then's Ghost
		[6646] = {3948,3970,3971,3973,3997,4552,4554,7912,8150,8754,10082,10085,10095,10097,10098,10099,10103,10119,10122,10126,10166,10167,10169,10173,10174,10175,10179,10184,10188,10190,10197,10198,10199,10200,10203,10238,10240,10244,10245}; --Monnos the Elder
		[6647] = {10068,10083,10084,10134,10176,10203,10239,10242,14047}; --Magister Hawkhelm
		[6648] = {4590,5117,5829,7517,8146,8170,9940,9941,9942,9948,9954,9955,9957,10073,10081,10194,10239,10450,11417,11418,15420}; --Antilos
		[6649] = {7973,8766,8959,9954,10061,10062,10063,10075,10084,10132,10134,10185,10191,10239,10243}; --Lady Sesspira
		[6650] = {1645,4603,7973,9955,10058,10068,10081,10131,10132,10191,17054}; --General Fangferror
		[6651] = {3928,4338,4599,4602,5430,9941,9952,9953,9965,10058,10060,10066,10069,10071,10108,10133,10205,10242}; --Gatekeeper Rageroar
		[6652] = {10134,10191,12662,14047}; --Master Feardred
		[8660] = {6444,6826,7519,7520,7528,7529,9905,9924,9937,9945,9951,9963,10067,10091,10092,10129,10202,10206,10208,20023}; --The Evalcharr
		[14339] = {4583,4584,7527,7528,8146,8169,8170,9913,9936,9945,9948,9952,9954,9962,9964,9965,10062,10071,10076,10079,10083,10134,10174,10185,10197,10202,10207,10208,11515,12203,12208,14427}; --Death Howl
		[14340] = {8766,8952,10057,10077,10096,10098,10103,10107,10109,10122,10123,10126,10128,10166,10171,10173,10176,10179,10183,10186,10193,10199,10200,10244,10278,11515,11674,12662,14047,14256}; --Alshirr Banebreath
		[14342] = {8766,8953,9940,9942,9954,9955,9957,10058,10059,10061,10062,10063,10068,10072,10073,10075,10081,10083,10091,10130,10131,10132,10134,10184,10185,10191,10194,10196,10208,10239,10243,11515,13443,14047,21377}; --Ragepaw
		[14343] = {5117,10062,10196,10197,10238,10242,11417,11420,11515,12207,15420}; --Olm the Wise
		[14344] = {4304,10058,10067,10080,10081,10084,10086,10132,11172,11408,11409,11410,11411,11515}; --Mongress
		[14345] = {3669,3671,3673,3674,7296,9954,9955,10061,10063,10068,10073,10075,10109,11515,12230,20763,20768,20770}; --The Ongar
		[7104] = {1645,3818,3927,8766,8948,10057,10095,10101,10106,10111,10121,10125,10168,10169,10177,10188,10214,10221,10229,10276,10282,10286,10305,11503,11515,12803}; --Dessecus
		[7137] = {4784,7067,7075,7076,7912,8150,10057,10095,10106,10112,10113,10121,10122,10124,10125,10168,10170,10177,10188,10224,10229,11515,12662}; --Immolatus
		[6581] = {3108,4304,4587,4588,7527,8146,9952,9953,9955,10058,10059,10060,10081,10129,10130,10239,11018,11116,11477,12184,20015}; --Ravasaur Matriarch
		[6582] = {6300,6302,10096,10099,10103,10107,10108,10109,10126,10128,10166,10171,10176,10179,10183,10186,10193,10199,10241,10244,11018}; --Clutchmother Zavas
		[6583] = {4304,5128,5133,8170,10100,10106,10111,10113,10119,10124,10138,10168,10170,10212,10216,10221,10224,10225,10229,10230,10235,10277,10282,11018,11188}; --Gruff
		[6584] = {4587,4588,10136,10144,10147,10149,10154,10155,10162,10211,10219,10226,10230,10248,10255,10258,10379,10380,10382,10387,11018,11116,11185,11186,11188,11315,13463,14330,15417,20015,228119,228120}; --King Mosh
		[6585] = {2799,4099,4304,4558,8170,10084,10174,10242,11018,11116}; --Uhk'loc
		[14471] = {4552,4554,7912,8150,10137,10140,10142,10146,10147,10149,10155,10249,10252,10383,10385,10387}; --Setis
		[14472] = {1074,4337,4585,10125,10214,10285,12205,14227}; --Gretheer
		[14473] = {6300,6302,10137,10138,10144,10145,10210,10226,10230,10258,10263,10269,10376,10377,10383}; --Lapress
		[14474] = {6300,6302,10104,10105,10138,10148,10159,10181,10182,10210,10211,10213,10216,10230,10235,10236,10249,10275,10279,10376,10381,15431}; --Zora
		[14475] = {6300,6302,10097,10106,10119,10125,10147,10177,10212,10213,10229,10233,10277,10281,20498}; --Rex Ashil
		[14476] = {10057,10091,10095,10099,10106,10113,10121,10124,10125,10148,10164,10167,10168,10170,10172,10175,10177,10187,10188,10189,10212,10229,10231,10276,10278,10282,12037,19441,19933,19934}; --Krellack
		[14477] = {3669,3676,10111,10118,10123,10164,10224}; --Grubthor
		[14478] = {7069,7081,7082,10097,10101,10104,10111,10112,10113,10118,10124,10145,10156,10164,10169,10181,10210,10213,10214,10216,10221,10223,10228,10232,10233,10234,10235,10237,10277,10281,10377,10381,22527}; --Huricanian
		[14479] = {8766,8952,10104,10105,10136,10138,10139,10140,10142,10144,10145,10146,10147,10154,10155,10156,10159,10210,10211,10214,10219,10222,10225,10226,10228,10230,10235,10236,10258,10275,10280,10309,10373,10376,10380,10381,10383,10387,10391,13446,14047,14815,14865,20404,20406,20407,20408,20451,220934,234008}; --Twilight Lord Everun <Twilight's Hammer>
		[224965] = {}; --Khonsu <Night Traveler>
		[228611] = {}; --Wandering Swordsman
		[10196] = {8170,8766,8952,10095,10100,10106,10119,10121,10123,10124,10125,10168,10177,10188,10216,10224,10233,10276,10282}; --General Colbatann
		[10197] = {4304,8146,8170,8766,8952,10057,10091,10096,10099,10100,10107,10110,10122,10125,10126,10165,10166,10167,10172,10175,10176,10183,10187,10189,10193,10199,10224,10231,10240,10278,10282}; --Mezzir the Howler
		[10198] = {8952,10105,10136,10142,10144,10147,10150,10155,10226,10253,10307,10383,12334}; --Kashoch the Reaver
		[10199] = {8766,8953,10101,10104,10118,10138,10145,10147,10148,10156,10159,10210,10211,10214,10221,10222,10225,10232,10234,10235,10236,10279,10280,10377,10380,10381,12820,12841,14047}; --Grizzle Snowpaw
		[10200] = {1688,4580,4581,8146,8170,10095,10100,10111,10113,10119,10123,10124,10169,10212,10233,10277,12202}; --Rak'shiri
		[10201] = {12662,14047,21105}; --Lady Hederine
		[10202] = {4460,10138,10222,10223,10267}; --Azurous
		[12116] = {}; --Priestess of Elune
		[3581] = {770,4304,15279}; --Sewer Beast
		[3586] = {414,789,858,955,1179,1206,1210,2078,2455,2555,2589,2592,2770,2771,2772,2836,2838,2984,2987,2992,3040,3193,3195,3199,3655,4345,4408,4575,4576,4697,5207,5443,5444,6344,6536,6552,6559,9775,9776,9777,9779,9789,10316,14167,14168,14174,15211,15222,15248,15926}; --Miner Johnson
		[596] = {414,818,858,1179,1180,1206,1210,1738,1740,1741,1744,1764,1766,1767,1769,1770,1787,1788,1789,1790,1791,1794,1811,1812,1813,1814,1815,1816,1817,2455,2589,2592,2764,2780,2781,2973,2984,2992,3377,3645,3902,4695,4699,5967,6528,6585,7608,9779,9784,14166}; --Brainwashed Noble
		[599] = {414,856,858,1179,1180,1206,1210,2078,2079,2455,2589,2592,2601,2983,2984,2987,3012,3019,3040,3195,3196,3205,3211,3645,4346,4571,4576,4660,4695,4699,6379,6528,6540,6545,6546,6552,6553,6554,6559,6563,6564,6581,9776,9777,9779,9785,9788,14174,15222,15926}; --Marisa du'Paige
		[3652] = {2318,2319,3010,4874,5425,5426,5523}; --Trigore the Lasher
		[3672] = {858,1179,1206,1210,1738,1741,1745,1766,1767,1768,1770,1790,1812,1813,1814,1817,2455,2589,2592,2764,2781,3184,3376,3393,4537,4575,4576,5422,5423,7288,14129,14367,14564,14727,15114,15498}; --Boahn <Druid of the Fang>
		[5912] = {789,790,818,1206,1210,2601,3040,3176,3177,3184,4576,5207,5243,6443,6470,6471,6632,9770,12053,14124,14131,14160,14369,14370,14371,14560,14727,15114,15211,15222,15248,15307,15488,15498,15502,15503,15510,15971}; --Deviate Faerie Dragon
		[211764] = {954,2592,210212}; --Gefell
		[211765] = {210213}; --Gemela
		[3872] = {929,1205,1318,1482,1712,1935,2589,2592,3012,3058,3194,3201,3202,3206,3385,3740,4293,4294,4306,4606,4632,4706,4708,4709,4715,4998,6566,6584,6600,6604,6641,6642,7558,8183,9792,9793,9794,9797,9801,9811,9813,9814,11081,11968,11994,15223,15224,15230,15241,15269}; --Deathsworn Captain
		[4425] = {1529,2319,3831,3864,4634,5214,5635,5637,6695,6696,6697,7360,11391,11392,11393,11394,12028,14206,14210,14585,14608,14751,14763,15133,15250,15285,15346,15352,15357,15542,15554,15962}; --Blind Hunter
		[4438] = {929,1205,1206,1488,1705,1978,2077,2592,2882,3186,3210,3385,4306,4538,4633,5002,5825,6454,6679,7090,7091,8184,11969,14181,14183,14191,14195,14197,14205,14209,14379,14400,14402,14406,14578,14579,14585,14744,14756,15121,15284,15285,15337,15341,15351,15518,15531,15547,15559,15962}; --Razorfen Spearhide
		[4842] = {865,929,1478,1529,1712,2264,2592,3037,3041,3780,3781,3783,3785,3786,3787,3792,3797,3803,3804,3806,3811,3813,3815,3864,4299,4306,4538,4634,5214,5825,6688,6689,8746,14189,14192,14196,14205,14209,14404,14579,14751,14757,15129,15139,15225,15285,15542,15556,15559,15579}; --Earthcaller Halmgar
		[5399] = {1520,1645,4338,6181,7532,7539,8152,9924,9942,9945,9947,9952,9962,9963,10062,10092,10202}; --Veyzhak the Cannibal
		[5400] = {1520,4338,6181,7529,7532,7538,7539,7543,8152,9913,9945,9949,9954,9960,9962,9963,9964,9965,10079,10081,10086,10092,10129,10201,10206}; --Zekkis
		[6228] = {867,868,869,929,1980,1982,2592,2825,3937,3938,3989,4003,4017,4019,4026,4070,4079,4306,4637,5108,6426,6429,6432,7112,7475,7484,7495,7909,9308,9904,14549,15234,15251,15261,213427,216661}; --Dark Iron Ambassador
		[6488] = {1477,1529,1705,1708,1710,2289,2592,3037,3042,3185,3827,4297,4306,4338,4607,4634,4716,4722,6403,6610,7367,7409,7689,7690,7691,9833,9835,9836,9841,9846,9847,9860,9861,10289,12028,15232,216738,216740,216744,216745,216746,216747,216748,216764,216767,216768,216769,216770,216771,217294}; --Fallen Champion
		[6489] = {1529,1708,1710,1725,2080,2592,3042,4055,4306,4338,4352,4607,4634,4716,6400,6407,6410,6609,7367,7368,7409,7414,7420,7686,7687,7688,7754,9833,9834,9835,9836,9841,9853,15225,15250,15285,15928,216738,216740,216744,216745,216746,216747,216748,216764,216767,216768,216769,216770,216771}; --Ironspine
		[6490] = {1477,1529,1708,1710,2592,3037,3197,3827,3864,4306,4338,4607,4634,5433,5819,6045,6396,6406,7409,7417,7708,7709,7731,7787,9825,9826,9834,9847,9858,10409,12039,15232,15250,15285,15934,216738,216740,216744,216745,216746,216747,216748,216764,216767,216768,216769,216770,216771,217295,217296}; --Azshir the Sleepless
		[8923] = {3946,3951,3971,3994,4552,4554,5759,7910,7912,8150,8258,8284,8753,10097,10100,10106,10118,10121,10125,10159,10212,10223,10232,10237,10279,10363,11129,11370,11754,11785,11786,11787,12695,13816,15255,15265,15281,18600,18945,22245,22528}; --Panzor the Invincible
		[8924] = {10069,10080,10127,10200,11446,11603,14047,18945,19259,22528}; --The Behemoth
		[9024] = {3948,3949,3987,3997,4425,5758,7909,7910,8084,8260,8264,8314,8319,8753,8766,8950,10063,10070,10073,10085,10175,10184,10196,10245,11207,11446,11732,11747,11748,11749,11750,11754,12044,13443,13819,13820,13821,13822,13825,14047,15236,15294,16043,17413,18945,22528,221294,223538,223980,223981}; --Pyromancer Loregrain
		[9041] = {4425,4426,5759,7909,7910,8258,8271,8287,8295,8298,8305,8306,8766,8950,10070,10095,10170,10175,10188,10193,11078,11446,11737,11754,11782,11783,11784,11939,11940,11966,11977,11978,12528,13443,13446,14047,14504,15229,15255,15264,15276,15324,15731,18945,19275,22241,22393,22528,221294,223983}; --Warder Stilgiss
		[9042] = {3075,4304,4500,5758,7909,7910,8146,8169,8170,8269,8270,8271,8272,8286,8295,8318,10057,10078,10097,10110,10122,10166,10170,10171,10172,10175,10187,10193,10229,10231,10278,10282,10371,11446,11754,11755,11939,11940,11966,12203,12208,15218,15229,15276,15281,15295,17682,18945,22242,22528}; --Verek
		[10263] = {4500,5759,8948,10095,10097,10100,10106,10110,10111,10112,10113,10119,10121,10124,10125,10138,10144,10148,10159,10168,10170,10177,10187,10188,10211,10212,10214,10223,10229,10230,10231,10233,10234,10236,10276,10277,10279,10281,10282,10381,12662,13181,13182,14047,14256,14311,14977,15218,228554,228555}; --Burning Felguard
		[10376] = {1074,4337,4585,7909,7910,8299,10144,10159,10210,10211,10228,10236,10263,10267,10285,10379,10387,11991,12205,13007,13184,13185,13218,14227,15220,15282,15325,22890,22891,23203,228590,228592}; --Crystal Fang
		[9217] = {3992,3994,3997,3999,4500,7909,7910,8084,8305,8766,8952,10105,10123,10124,10224,10228,10364,10369,10375,10381,12219,12684,12694,13261,13282,13283,13818,13819,13820,13821,13824,14047,15238,15265,15281,16218,17414,18335,21982,22528,228563,228564,228565}; --Spirestone Lord Magus
		[9218] = {3945,3946,3951,3974,3993,3996,3998,3999,5759,7910,8085,8086,8310,8766,8952,10104,10112,10118,10221,10230,10281,10307,10370,12015,12219,13146,13284,13285,13816,13818,13820,13821,13823,13824,13825,14047,15219,15255,15256,15265,15276,15281,15282,15939,17414,18600,21982,22528,24222,228557}; --Spirestone Battle Lord
		[9219] = {1443,3944,3945,3948,3949,3970,3999,5759,7909,7910,8258,8752,8755,8766,8952,10100,10113,10168,10223,10230,10234,10305,10309,11978,12026,12056,12219,12608,13286,13817,13818,13819,13824,13825,14047,15218,15238,15255,15256,15276,15281,15731,15745,15938,16051,18335,21982,22528,22891,228556}; --Spirestone Butcher
		[9596] = {3947,3948,3949,3950,3951,3970,3976,5759,7910,8081,8301,8305,8307,8766,8952,10144,10145,10213,10216,10235,12219,12621,12634,12637,12838,13444,13818,13823,13824,14047,15282,17414,22138,228567,228568}; --Bannok Grimaxe <Firebrand Legion Champion>
		[9718] = {3948,3973,3994,3995,3997,5759,7910,8086,8754,8755,8766,8952,10163,10223,10232,10236,10281,10377,10386,12057,12219,13198,13203,13204,13446,13816,13817,13818,13821,13822,13823,14047,15238,15282,15939,16215,22138,22528}; --Ghok Bashguud <Bloodaxe Champion>
		[10080] = {1645,3187,4306,4338,5616,7332,7468,7469,7477,7486,7519,7522,7523,7525,7526,7530,7531,7533,7534,7540,7541,7542,8120,8151,8623,9242,9243,9286,9523,9907,9910,9911,9912,9915,9928,9932,9933,9934,9937,9956,9959,9966,9970,10079,10087,10088,10089,10091,10092,10201}; --Sandarr Dunereaver
		[10081] = {3874,4306,4338,4599,4637,7332,7468,7486,7519,7520,7522,7525,7529,7531,7533,7534,7539,7541,7544,7545,7546,8151,8623,9242,9243,9523,9907,9910,9911,9912,9913,9915,9917,9920,9922,9923,9924,9928,9933,9934,9947,9956,9966,10089,10090,10094,12043,12471,14252,223533}; --Dustwraith
		[10082] = {1645,1994,2040,3928,4306,4338,4599,7468,7469,7524,7525,7530,7532,7545,7546,8120,8151,8623,9242,9243,9286,9523,9906,9910,9912,9915,9916,9917,9922,9925,9928,9933,9938,9945,9956,9959,9960,9961,9963,9966,10087,10088,10089,10090,10094,12470,14833,14843,14950,223962}; --Zerillis
		[10393] = {3944,3945,3950,3969,3973,3975,3990,3997,5759,7910,7972,8288,8289,8292,8752,8753,8754,8755,8766,8948,10123,10138,10145,10164,10169,10210,10275,10279,10371,10377,12057,12808,12843,13394,13395,13396,13817,13820,13821,13823,13824,14047,15218,16251,18335,22526}; --Skul
		[10558] = {4500,5759,7909,7910,7972,8289,8295,8298,8299,8307,8312,8318,8766,8948,10124,10125,10170,10177,10224,10236,10281,10306,10307,10363,10377,12035,12056,12808,12843,13174,13378,13379,13383,13384,13444,14047,15255,15264,15276,15281,15324,16682,18335,18600,19233,226730,228501,228502,228503,228504}; --Hearthsinger Forresten
		[10809] = {4552,4554,5759,7909,7910,8146,8307,10136,10138,10144,10145,10156,10163,10219,10220,10225,10230,10255,10257,10259,10260,10372,10381,10382,10387,10390,12057,12843,13397,13399,13954,14496,15239,15256,15282,15296,15743,15931,18600}; --Stonespine
		[10509] = {1443,4500,5759,7909,7910,8283,8288,8299,8302,8310,8313,8766,8952,10136,10144,10213,10221,10222,10228,10232,10234,10235,10236,10259,10365,10374,12604,12605,12930,13446,13492,14047,15219,15220,15239,15265,15272,15276,15325,15743,15939,16043,16245,17414,18335,19264,22138,22890,22891,228566}; --Jed Runewatcher <Blackhand Legion>
		[11447] = {1973,4696,5267,9402,10286,13004,13006,13015,13023,13028,13047,13053,13060,13072,13091,13107,13116,13146,13463,13464,13465,13468,14862,23197,23199}; --Mushgog
		[11497] = {1973,4696,6622,8170,9402,13000,13001,13002,13004,13006,13015,13023,13028,13053,13060,13072,13083,13096,13101,13107,13113,13116,13123,13133,13135,13463,15435,23197,23199,23203}; --The Razza
		[11498] = {1973,4696,8766,9402,13000,13001,13002,13004,13006,13007,13015,13028,13047,13053,13060,13070,13072,13075,13083,13091,13096,13101,13107,13116,13123,13133,13135,13146,14047,23199,23203}; --Skarr the Unbreakable
		[12237] = {765,785,1645,2452,3395,3820,3938,3943,3962,3963,3986,4005,4020,4021,4022,4026,4608,4638,7909,7910,7989,7990,8749,8751,8838,8839,8846,10286,13134,14249,14669,15235,15387,17684,17741,17742,17767}; --Meshlok the Harvester
		[231661] = {}; --Rahuz <The Scorned Student>
		[232215] = {}; --Rahuz
		[232216] = {}; --Rahuz
		[240797] = {}; --Scarlet Executioner
		[242577] = {}; --Devouring Hunger
		[242827] = {}; --Captain Bloodcoin <Seafaring Auctioneer>
		[243046] = {}; --Scarlet Captain
		[243893] = {}; --High General Abbendis
	}
end