---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")
---@type Expansions
local Expansions = QuestieLoader:ImportModule("Expansions")

-- This file is used to add corrections/changes to the lookupZones.lua which contains data for Era up to WotLK.
-- For example, it applies all the changes that were made to the zones in Cataclysm and also add all zones that were added in Mists of Pandaria.

local easternKingdom = l10n.zoneLookup[0]
easternKingdom[33]="Northern Stranglethorn"
easternKingdom[133]="New Tinkertown"
easternKingdom[193]="Andorhal"
easternKingdom[200]="Dalson's Farm"
easternKingdom[237]="The Decrepit Fields"
easternKingdom[271]="Ruins of Southshore"
easternKingdom[278]="Brazie Farmstead"
easternKingdom[285]="Southpoint Gate"
easternKingdom[286]="The Sludge Fields"
easternKingdom[340]="Ruins of Kargath"
easternKingdom[928]="North Tide's Beachhead"
easternKingdom[1457]="Nethergarde Mines"
easternKingdom[1577]="Cape of Stranglethorn"
easternKingdom[1739]="Hardwrench Hideaway"
easternKingdom[1777]="Purespring Cavern"
easternKingdom[1885]="Hiri'watha Research Station"
--easternKingdom[1977]="Zul'Gurub"
easternKingdom[2265]="Death Cultist Base Camp"
easternKingdom[3378]="Mandokir's Domain"
easternKingdom[3380]="Altar of the Blood God"
easternKingdom[3384]="The Devil's Terrace"
easternKingdom[3398]="The Cache of Madness"
easternKingdom[4706]="Ruins of Gilneas"
easternKingdom[4714]="Gilneas"
easternKingdom[4725]="The Headlands"
easternKingdom[4726]="Keel Harbor"
easternKingdom[4727]="Aderic's Repose"
easternKingdom[4728]="Northern Headlands"
easternKingdom[4729]="Northgate Woods"
easternKingdom[4730]="The Blackwald"
easternKingdom[4731]="Stormglen Village"
easternKingdom[4732]="Emberstone Mine"
easternKingdom[4733]="Galewatch Lighthouse"
easternKingdom[4734]="Emberstone Village"
easternKingdom[4735]="Northgate Breach"
easternKingdom[4736]="The Bite"
easternKingdom[4755]="Gilneas City"
easternKingdom[4756]="Merchant Square"
easternKingdom[4757]="Military District"
easternKingdom[4758]="Greymane Court"
easternKingdom[4759]="Cathedral Quarter"
easternKingdom[4761]="Light's Dawn Cathedral"
easternKingdom[4762]="Stoneward Prison"
easternKingdom[4786]="Duskhaven"
easternKingdom[4787]="Stagecoach Crash Site"
easternKingdom[4788]="Tempest's Reach"
easternKingdom[4789]="The Greymane Wall"
easternKingdom[4790]="Northgate River"
easternKingdom[4791]="Hailwood Marsh"
easternKingdom[4792]="Allen Farmstead"
easternKingdom[4793]="Hammond Farmstead"
easternKingdom[4794]="Koroth's Den"
easternKingdom[4806]="Wahl Cottage"
easternKingdom[4807]="Crowley Orchard"
easternKingdom[4808]="Hayward Fishery"
easternKingdom[4810]="Queen's Gate"
easternKingdom[4811]="King's Gate"
easternKingdom[4815]="Kelp'thar Forest"
easternKingdom[4817]="Greymane Manor"
easternKingdom[4818]="Crowley Stable Grounds"
easternKingdom[4837]="Whitebeard's Encampment"
easternKingdom[4841]="Tal'doren"
easternKingdom[4842]="Livery Outpost"
easternKingdom[4858]="Rygna's Lair"
easternKingdom[4868]="The Bradshaw Mill"
easternKingdom[4869]="Wood's End Cabin"
easternKingdom[4915]="Rotbrain Encampment"
easternKingdom[4916]="Calston Estate"
easternKingdom[4917]="Scarlet Palisade"
easternKingdom[4918]="Scarlet Encampment"
easternKingdom[4919]="Death's Watch Waystation"
easternKingdom[4920]="Crusader's Run"
easternKingdom[4921]="Scarlet Watchtower"
easternKingdom[4922]="Twilight Highlands"
easternKingdom[4953]="Kelp'thar Forest"
easternKingdom[4955]="The Lightless Reaches"
easternKingdom[4961]="Silver Tide Trench"
easternKingdom[4962]="Nespirah"
easternKingdom[4963]="Glimmerdeep Gorge"
easternKingdom[4966]="Biel'aran Ridge"
easternKingdom[4967]="Ruins of Vashj'ir"
easternKingdom[4968]="Quel'Dormir Terrace"
easternKingdom[4969]="Tranquil Wash"
easternKingdom[4970]="Legion's Rest"
easternKingdom[4971]="L'ghorek"
easternKingdom[4972]="Thermal Vents"
easternKingdom[4973]="The Overlook"
easternKingdom[4974]="Underlight Canyon"
easternKingdom[4975]="Tenebrous Cavern"
easternKingdom[4976]="Darkbreak Cove"
easternKingdom[4977]="Korthun's End"
easternKingdom[5000]="Verrall River"
easternKingdom[5005]="Silver Tide Hollow"
easternKingdom[5006]="Damplight Cavern"
easternKingdom[5007]="Ruins of Thelserai Temple"
easternKingdom[5008]="Shimmering Grotto"
easternKingdom[5012]="The Briny Cutter"
easternKingdom[5030]="Shallow's End"
easternKingdom[5031]="Twin Peaks"
easternKingdom[5044]="The Tainted Forest"
easternKingdom[5047]="Abyssal Breach"
easternKingdom[5051]="Seafarer's Tomb"
easternKingdom[5052]="Legion's Fate"
easternKingdom[5053]="Gurboggle's Ledge"
easternKingdom[5054]="The Skeletal Reef"
easternKingdom[5055]="Gnaws' Boneyard"
easternKingdom[5056]="The Immortal Coil"
easternKingdom[5057]="Smuggler's Scar"
easternKingdom[5058]="Deepmist Grotto"
easternKingdom[5059]="The Clutch"
easternKingdom[5070]="Budd's Dig"
easternKingdom[5071]="Gorrok's Lament"
easternKingdom[5074]="Slabchisel's Survey"
easternKingdom[5076]="Nethergarde Supply Camps"
easternKingdom[5077]="Shattershore"
easternKingdom[5078]="The Red Reaches"
easternKingdom[5079]="Rockpool Village"
easternKingdom[5080]="Bloodwash Fighting Pits"
easternKingdom[5081]="Bloodwash Shrine"
easternKingdom[5082]="Bloodwash Cavern"
easternKingdom[5083]="Sunveil Excursion"
easternKingdom[5084]="Surwich"
easternKingdom[5085]="Maldraz"
easternKingdom[5086]="Dreadmaul Furnace"
easternKingdom[5089]="Quel'Dormir Gardens"
easternKingdom[5090]="Nar'shola Terrace"
easternKingdom[5095]="Tol Barad"
easternKingdom[5096]="The Forbidding Sea"
easternKingdom[5097]="Frostmane Front"
easternKingdom[5098]="Frostmane Retreat"
easternKingdom[5100]="Promontory Point"
easternKingdom[5101]="Deepfin Ridge"
easternKingdom[5102]="Nightmare Depths"
easternKingdom[5103]="The Scalding Chasm"
easternKingdom[5104]="The Undershell"
easternKingdom[5105]="Pincer X2"
easternKingdom[5106]="The Verne"
easternKingdom[5107]="Sira'kess Front"
easternKingdom[5114]="Bahrum's Post"
easternKingdom[5115]="Ironforge Airfield"
easternKingdom[5121]="Galen's Fall"
easternKingdom[5124]="Quel'Dormir Temple"
easternKingdom[5134]="Seabrush"
easternKingdom[5135]="Abandoned Reef"
easternKingdom[5136]="Dragonmaw Port"
easternKingdom[5137]="The Krazzworks"
easternKingdom[5138]="Bloodgulch"
easternKingdom[5139]="The Gullet"
easternKingdom[5140]="Highbank"
easternKingdom[5141]="Firebeard's Patrol"
easternKingdom[5142]="Thundermar"
easternKingdom[5143]="Kirthaven"
easternKingdom[5144]="Shimmering Expanse"
easternKingdom[5145]="Abyssal Depths"
easternKingdom[5146]="Vashj'ir"
easternKingdom[5148]="Trade District"
easternKingdom[5149]="Old Town"
easternKingdom[5150]="Dwarven District"
easternKingdom[5151]="Cathedral Square"
easternKingdom[5152]="The Park"
easternKingdom[5154]="Mage Quarter"
easternKingdom[5155]="Vermillion Redoubt"
easternKingdom[5157]="The Park"
easternKingdom[5173]="The Severed Span"
easternKingdom[5174]="Hogger Hill"
easternKingdom[5176]="Goldtooth's Den"
easternKingdom[5177]="Crushcog's Arsenal"
easternKingdom[5178]="The Toxic Airfield"
easternKingdom[5247]="The Tidebreaker"
easternKingdom[5248]="Voldrin's Hold"
easternKingdom[5249]="Stygian Bounty"
easternKingdom[5250]="Galerek's Remorse"
easternKingdom[5251]="The Iron Reaper"
easternKingdom[5252]="The Intrepid"
easternKingdom[5287]="The Cape of Stranglethorn"
easternKingdom[5289]="Mortwake's Tower"
easternKingdom[5290]="The Raging Chasm"
easternKingdom[5304]="Swiftgear Station"
easternKingdom[5305]="Greenwarden's Grove"
easternKingdom[5314]="Stormwind Lake"
easternKingdom[5316]="Olivia's Pond"
easternKingdom[5317]="Bambala"
easternKingdom[5318]="The Sundering"
easternKingdom[5320]="Fort Livingston"
easternKingdom[5321]="Yowler's Den"
easternKingdom[5322]="Scar of the Worldbreaker"
easternKingdom[5323]="Stormfeather Outpost"
easternKingdom[5324]="Shalewind Canyon"
easternKingdom[5325]="Keeshan's Post"
easternKingdom[5326]="Camp Everstill"
easternKingdom[5327]="Tower Watch"
easternKingdom[5336]="Remains of the Fleet"
easternKingdom[5339]="Stranglethorn Vale"
easternKingdom[5340]="Hall of Arms"
easternKingdom[5341]="Hall of Explorers"
easternKingdom[5342]="The Great Forge"
easternKingdom[5343]="The Military Ward"
easternKingdom[5344]="The Mystic Ward"
easternKingdom[5346]="Stormwind City Cemetery"
easternKingdom[5347]="Render's Crater"
easternKingdom[5351]="Ruins of Gilneas City"
easternKingdom[5353]="Verrall Delta"
easternKingdom[5367]="The Menders' Stead"
easternKingdom[5369]="Forsaken High Command"
easternKingdom[5374]="Blackrock Caverns Entrance"
easternKingdom[5382]="The Abyssal Maw"
easternKingdom[5386]="Forsaken Rear Guard"
easternKingdom[5387]="The Forsaken Front"
easternKingdom[5389]="Tol Barad Peninsula"
easternKingdom[5390]="The Canals"
easternKingdom[5391]="Ironwing Cavern"
easternKingdom[5392]="Charred Outpost"
easternKingdom[5397]="The Wollerton Stead"
easternKingdom[5398]="Stormwind City Outskirts"
easternKingdom[5399]="Baradin Hold"
easternKingdom[5400]="Slagworks"
easternKingdom[5401]="Ironclad Garrison"
easternKingdom[5402]="Warden's Vigil"
easternKingdom[5403]="East Spire"
easternKingdom[5404]="South Spire"
easternKingdom[5405]="West Spire"
easternKingdom[5406]="Blackstone Span"
easternKingdom[5408]="Explorers' League Digsite"
easternKingdom[5409]="The Old Barracks"
easternKingdom[5411]="Malicia's Outpost"
easternKingdom[5421]="Redpine Dell"
easternKingdom[5422]="Taelan's Tower"
easternKingdom[5424]="Obsidian Breakers"
easternKingdom[5425]="Twilight Shore"
easternKingdom[5426]="Path of Uther"
easternKingdom[5427]="Sorrow Hill Crypt"
easternKingdom[5428]="The Eastern Earthshrine"
easternKingdom[5432]="Forsaken Forward Command"
easternKingdom[5433]="The Greymane Wall"
easternKingdom[5434]="Forsaken Forward Command"
easternKingdom[5435]="Gilneas City"
easternKingdom[5436]="Tempest's Reach"
easternKingdom[5437]="Ring of the Elements"
easternKingdom[5438]="The Maw of Madness"
easternKingdom[5439]="Ruins of Drakgor"
easternKingdom[5440]="Northern Headlands"
easternKingdom[5441]="Emberstone Village"
easternKingdom[5442]="Emberstone Mine"
easternKingdom[5443]="Dreadwatch Outpost"
easternKingdom[5444]="Rutsak's Guard"
easternKingdom[5445]="Glory"
easternKingdom[5446]="Death's Step"
easternKingdom[5448]="Light's Shield Tower"
easternKingdom[5449]="The Battle for Gilneas"
easternKingdom[5450]="Lighthouse"
easternKingdom[5451]="Waterworks"
easternKingdom[5452]="Mines"
easternKingdom[5453]="Horde Landing"
easternKingdom[5454]="Gilnean Stronghold"
easternKingdom[5456]="The Battlefront"
easternKingdom[5457]="The Overlook"
easternKingdom[5458]="Bogpaddle"
easternKingdom[5459]="Marshtide Watch"
easternKingdom[5460]="The Bloodmire"
easternKingdom[5461]="Dragonmaw Pass"
easternKingdom[5462]="Wyrms' Bend"
easternKingdom[5463]="Ix'lar's Domain"
easternKingdom[5464]="Darrowshire Hunting Grounds"
easternKingdom[5468]="Gilnean Coast"
easternKingdom[5469]="Siege Vise"
easternKingdom[5470]="Victor's Point"
easternKingdom[5471]="Crushblow"
easternKingdom[5472]="The Twilight Gate"
easternKingdom[5473]="The Twilight Citadel"
easternKingdom[5474]="Elementium Depths"
easternKingdom[5475]="Den of the Disciples"
easternKingdom[5476]="Pyrewood Chapel"
easternKingdom[5477]="Pyrewood Inn"
easternKingdom[5478]="Pyrewood Town Hall"
easternKingdom[5479]="Slithering Cove"
easternKingdom[5480]="Gilneas Liberation Front Base Camp"
easternKingdom[5481]="7th Legion Base Camp"
easternKingdom[5483]="Dunwald Ruins"
easternKingdom[5484]="Dunwald Holdout"
easternKingdom[5485]="Dunwald Hovel"
easternKingdom[5486]="Dunwald Town Square"
easternKingdom[5487]="Dunwald Market Row"
easternKingdom[5488]="Gorshak War Camp"
easternKingdom[5489]="The Boneyard"
easternKingdom[5493]="The Devouring Breach"
easternKingdom[5495]="Gnomeregan"
easternKingdom[5496]="Fuselight"
easternKingdom[5497]="Fuselight-by-the-Sea"
easternKingdom[5502]="Thundermar Ruins"
easternKingdom[5503]="Altar of Ascension"
easternKingdom[5506]="The Defiled Chapel"
easternKingdom[5507]="The Cerebrillum"
easternKingdom[5510]="Shadowfang Keep Entrance"
easternKingdom[5511]="Scarlet Monastery Entrance"
easternKingdom[5512]="Scholomance Entrance"
easternKingdom[5513]="Stratholme Entrance"
easternKingdom[5514]="Stratholme Service Entrance"
easternKingdom[5515]="Blackrock Depths Entrance"
easternKingdom[5516]="Blackrock Spire Entrance"
easternKingdom[5519]="Rhea's Camp"
easternKingdom[5523]="Uldaman Entrance"
easternKingdom[5524]="Bloodwatcher Point"
easternKingdom[5525]="Dustwind Dig"
easternKingdom[5526]="Tomb of the Watchers"
easternKingdom[5527]="Crucible of Carnage"
easternKingdom[5534]="Cape of Lost Hope"
easternKingdom[5535]="Wellson Shipyard"
easternKingdom[5536]="Forgotten Hill"
easternKingdom[5537]="The Darkwood"
easternKingdom[5538]="Rustberg Village"
easternKingdom[5539]="Farson Hold"
easternKingdom[5540]="Largo's Overlook"
easternKingdom[5542]="The Restless Front"
easternKingdom[5545]="Baradin Base Camp"
easternKingdom[5546]="Hellscream's Grasp"
easternKingdom[5557]="Magisters' Terrace Entrance"
easternKingdom[5563]="Loch Verrall"
easternKingdom[5564]="Dragon's Mouth"
easternKingdom[5565]="New Kargath"
easternKingdom[5579]="Throne of the Tides Entrance"
easternKingdom[5580]="Grim Batol Entrance"
easternKingdom[5584]="Altar of Twilight"
easternKingdom[5592]="The Hidden Clutch"
easternKingdom[5593]="The Nosebleeds"
easternKingdom[5594]="Highland Forest"
easternKingdom[5595]="Obsidian Forest"
easternKingdom[5598]="Sunken Temple Entrance"
easternKingdom[5603]="Eastpoint Tower"
easternKingdom[5604]="Sludgeguard Tower"
easternKingdom[5609]="The Black Breach"
easternKingdom[5611]="Firebeard Cemetery"
easternKingdom[5615]="Pyrox Flats"
easternKingdom[5627]="Black Drake Roost"
easternKingdom[5628]="Iron Summit"
easternKingdom[5629]="Thorium Advance"
easternKingdom[5637]="Lion's Pride Inn"
easternKingdom[5639]="Glopgut's Hollow"
easternKingdom[5640]="Humboldt Conflagration"
easternKingdom[5641]="The Twilight Breach"
easternKingdom[5650]="The Whelping Downs"
easternKingdom[5651]="Flamestar Post"
easternKingdom[5652]="Black Tooth Hovel"
easternKingdom[5653]="Fields of Honor"
easternKingdom[5654]="Chiselgrip"
easternKingdom[5655]="Firegut Furnace"
easternKingdom[5656]="The Skull Warren"
easternKingdom[5657]="D-Block"
easternKingdom[5658]="Cursed Depths"
easternKingdom[5659]="The Hole"
easternKingdom[5660]="Obsidian Lair"
easternKingdom[5664]="Iso'rath"
easternKingdom[5667]="Cannon's Inferno"
easternKingdom[5677]="Valley of Ashes"
easternKingdom[5680]="Wildhammer Flag Room"
easternKingdom[5681]="Dragonmaw Flag Room"
easternKingdom[5682]="Thunderstrike Mountain"
easternKingdom[5683]="Beneath The Double Rainbow"
easternKingdom[5692]="The Deathknell Graves"
easternKingdom[5699]="The Circle of Life"
easternKingdom[5704]="The Catacombs"
easternKingdom[5710]="The Lightless Reaches"
easternKingdom[5711]="The Lightless Reaches"
easternKingdom[5712]="The Blackwald"
easternKingdom[5713]="Hayward Fishery"
easternKingdom[5714]="Stormglen Village"
easternKingdom[5718]="Fortune's Fist"
easternKingdom[5719]="The Commons"
easternKingdom[5720]="Duskmist Shore"
easternKingdom[5721]="Brashtide Attack Fleet"
easternKingdom[5724]="Twilight Camp"
easternKingdom[5728]="Falconwing Inn"
easternKingdom[5729]="Blackwing Descent"
easternKingdom[5731]="Whelgar's Retreat"
easternKingdom[5775]="Dragonmaw Stronghold"
easternKingdom[5776]="Wildhammer Stronghold"
easternKingdom[5779]="Thalassian Range"
easternKingdom[5780]="Amani Mountains"
easternKingdom[5838]="Whispering Forest"
easternKingdom[6510]="The Deadmines"
easternKingdom[15306]="Battle for Tol Barad"
easternKingdom[15318]="Baradin Hold"
easternKingdom[15319]="Blackstone Span"
easternKingdom[15320]="West Spire"
easternKingdom[15321]="South Spire"
easternKingdom[15322]="East Spire"
easternKingdom[15323]="Warden's Vigil"
easternKingdom[15324]="Ironclad Garrison"
easternKingdom[15325]="Slagworks"

local kalimdor = l10n.zoneLookup[1]
kalimdor[17]="Northern Barrens"
kalimdor[366]="Northwatch Foothold"
kalimdor[506]="Lost Point"
kalimdor[424]="Remains of Iris Lake"
kalimdor[425]="Moonwell of Purity"
kalimdor[442]="Ruins of Auberdine"
kalimdor[604]="Shok'Thokar"
kalimdor[616]="Mount Hyjal"
kalimdor[989]="Ruins of Uldum"
kalimdor[1116]="Ruins of Feathermoon"
kalimdor[1216]="Blackmaw Hold"
kalimdor[1220]="Darnassian Base Camp"
kalimdor[1221]="Ruins of Eldarath "
kalimdor[1226]="Ruins of Arkkoran"
kalimdor[1276]="Talondeep Vale"
--kalimdor[1941]="Caverns of Time"
--kalimdor[2557]="Dire Maul"
--kalimdor[2577]="Dire Maul"
--kalimdor[3606]="Hyjal Summit"
kalimdor[4644]="Orendil's Retreat"
kalimdor[4645]="Blackfathom Camp"
kalimdor[4647]="Ruuzel's Isle"
kalimdor[4648]="Auberdine Refugee Camp"
kalimdor[4659]="Lor'danel"
kalimdor[4660]="Ruins of Lornesta"
kalimdor[4661]="Cliffspring Hollow"
kalimdor[4662]="Shatterspear War Camp"
kalimdor[4663]="Maw of the Void"
kalimdor[4664]="Shatterspear Vale"
kalimdor[4675]="Withering Thicket"
kalimdor[4690]="Thunder Peak"
kalimdor[4691]="Hellscream's Watch"
kalimdor[4693]="Splintertree Mine"
kalimdor[4694]="Thistlefur Hold"
kalimdor[4695]="The Eye of the Vortex"
kalimdor[4696]="Blackwood Camp"
kalimdor[4697]="The Blazing Strand"
kalimdor[4698]="Moontouched Den"
kalimdor[4702]="Shatterspear Pass"
kalimdor[4705]="Raynewood Tower"
kalimdor[4707]="The Lost Isles"
kalimdor[4708]="Earthshatter Cavern"
kalimdor[4709]="Southern Barrens"
kalimdor[4711]="Stardust Spire"
kalimdor[4712]="Moonwell of Cleansing"
kalimdor[4713]="Krolg's Hut"
kalimdor[4715]="The Skunkworks"
kalimdor[4716]="Bolyun's Camp"
kalimdor[4717]="House of Edune"
kalimdor[4718]="Wellspring Hovel"
kalimdor[4724]="Ban'ethil Barrow Descent"
kalimdor[4744]="Mountainfoot Strip Mine"
kalimdor[4745]="Orgrimmar Rear Gate"
kalimdor[4795]="Slitherblade Shore"
kalimdor[4796]="Slitherblade Shore"
kalimdor[4797]="Magram Territory"
kalimdor[4798]="Thargad's Camp"
kalimdor[4799]="Trial of Fire"
kalimdor[4800]="Trial of Shadow"
kalimdor[4801]="Arcane Pinnacle"
kalimdor[4803]="Furien's Post"
kalimdor[4804]="Cenarion Wildlands"
kalimdor[4805]="Karnum's Glade"
kalimdor[4814]="Sable Ridge"
kalimdor[4819]="The Ancient Grove"
kalimdor[4821]="Bilgewater Harbor"
kalimdor[4824]="Gallywix Pleasure Palace"
kalimdor[4825]="Northern Rocketway Exchange"
kalimdor[4826]="Storm Cliffs"
kalimdor[4827]="Storm Cliffs"
kalimdor[4828]="Southern Rocketway Terminus"
kalimdor[4829]="The Secret Lab"
kalimdor[4830]="Orgrimmar Rocketway Exchange"
kalimdor[4834]="Ruins of Nordressa"
kalimdor[4835]="Camp Sungraze"
kalimdor[4836]="Stonetalon Pass"
kalimdor[4839]="Fargaze Mesa"
kalimdor[4843]="Honor's Stand"
kalimdor[4844]="Hunter's Hill"
kalimdor[4845]="The Overgrowth"
kalimdor[4846]="Camp Una'fe"
kalimdor[4847]="Northwatch Hold"
kalimdor[4848]="Teegan's Expedition"
kalimdor[4849]="Forward Command"
kalimdor[4850]="Fields of Blood"
kalimdor[4851]="Ruins of Taurajo"
kalimdor[4852]="The Great Gate"
kalimdor[4853]="Desolation Hold"
kalimdor[4854]="Fort Triumph"
kalimdor[4855]="Battlescar"
kalimdor[4856]="Bael Modan"
kalimdor[4857]="Firestone Point"
kalimdor[4860]="Overgrown Camp"
kalimdor[4861]="The Regrowth"
kalimdor[4863]="Bloodtalon Shore"
kalimdor[4864]="Zalazane's Fall"
kalimdor[4865]="Darkspear Training Grounds"
kalimdor[4866]="Darkspear Hold"
kalimdor[4867]="Spitescale Cove"
kalimdor[4872]="Bael'dun Keep"
kalimdor[4875]="Darkspear Isle"
kalimdor[4878]="The Thornsnarl"
kalimdor[4879]="The Battleboar Pen"
kalimdor[4880]="Thornmantle's Hideout"
kalimdor[4881]="Stonetalon Pass"
kalimdor[4882]="Marshal's Stand"
kalimdor[4883]="Mossy Pile"
kalimdor[4884]="The Screaming Reaches"
kalimdor[4885]="The Roiling Gardens"
kalimdor[4887]="Nightmare Scar"
kalimdor[4888]="The Nightmare Scar"
kalimdor[4913]="Spitescale Cavern"
kalimdor[4925]="Thunk's Abode"
kalimdor[4927]="The Fold"
kalimdor[4928]="Talondeep Pass"
kalimdor[4929]="Windshear Hold"
kalimdor[4930]="Webwinder Hollow"
kalimdor[4931]="Ruins of Eldre'thar"
kalimdor[4932]="The Deep Reaches"
kalimdor[4933]="Krom'gar Fortress"
kalimdor[4934]="The Sludgewerks"
kalimdor[4935]="Mirkfallon Post"
kalimdor[4936]="Cliffwalker Post"
kalimdor[4937]="Thal'darah Overlook"
kalimdor[4938]="Battlescar Valley"
kalimdor[4939]="Farwatcher's Glen"
kalimdor[4940]="Northwatch Expedition Base Camp"
kalimdor[4941]="Unearthed Grounds"
kalimdor[4942]="Windshear Heights"
kalimdor[4943]="Dagger Pass"
kalimdor[4944]="Thal'darah Grove"
kalimdor[4946]="Bael Modan Excavation"
kalimdor[4947]="Twinbraid's Patrol"
kalimdor[4948]="Frazzlecraz Motherlode"
kalimdor[4949]="Spearhead"
kalimdor[4978]="Wolf's Run"
kalimdor[4979]="Shrine of Goldrinn"
kalimdor[4980]="Maw of Lycanthoth"
kalimdor[4981]="Southfury Watershed"
kalimdor[4982]="The Dranosh'ar Blockade"
kalimdor[4983]="Twilight Crossing"
kalimdor[4984]="The Twilight Gauntlet"
kalimdor[4985]="The High Road"
kalimdor[4986]="Vendetta Point"
kalimdor[4988]="Gar'gol's Hovel"
kalimdor[4989]="Grove of Aessina"
kalimdor[4990]="Shrine of Aviana"
kalimdor[4991]="Darkwhisper Gorge"
kalimdor[4992]="Broken Commons"
kalimdor[4993]="Darkwhisper Pass"
kalimdor[4994]="The Forge of Supplication"
kalimdor[4995]="Seat of the Chosen"
kalimdor[4996]="Doom's Vigil"
kalimdor[4998]="Gates of Sothann"
kalimdor[4999]="Lightning Ledge"
kalimdor[5002]="Camp Ataya"
kalimdor[5003]="Stonemaul Hold"
kalimdor[5009]="Shadebough"
kalimdor[5010]="New Thalanaar"
kalimdor[5011]="Westreach Summit"
kalimdor[5013]="Blackhorn's Penance"
kalimdor[5014]="The Inferno"
kalimdor[5015]="Leyara's Sorrow"
kalimdor[5016]="Whistling Grove"
kalimdor[5017]="The Scorched Plain"
kalimdor[5018]="Ashen Lake"
kalimdor[5019]="Sanctuary of Malorne"
kalimdor[5020]="The Flamewake"
kalimdor[5021]="The Searing Gateway"
kalimdor[5022]="Rim of the World"
kalimdor[5023]="The Emerald Summit"
kalimdor[5024]="Dreamer's Rest"
kalimdor[5025]="The Shimmering Deep"
kalimdor[5026]="Rustmaul Dive Site"
kalimdor[5027]="Splithoof Heights"
kalimdor[5028]="Southsea Holdfast"
kalimdor[5029]="The Admiral's Den"
kalimdor[5032]="Hyjal Barrow Dens"
kalimdor[5033]="Twilight Command Post"
kalimdor[5034]="Uldum"
kalimdor[5036]="Darkmist Ruins"
kalimdor[5037]="Lake Edunel"
kalimdor[5038]="Nordrassil"
kalimdor[5039]="Sulfuron Spire"
kalimdor[5040]="The Throne of Flame"
kalimdor[5041]="Fizzle & Pozzik's Speedbarge"
kalimdor[5045]="Ascendant's Rise"
kalimdor[5046]="Mirage Abyss"
kalimdor[5048]="Raceway Ruins"
kalimdor[5049]="Speedbarge Bar"
kalimdor[5050]="The Hatchery"
kalimdor[5060]="Steelspark Station"
kalimdor[5061]="Steelspark Station"
kalimdor[5062]="Bootlegger Outpost"
kalimdor[5063]="Dunemaul Recruitment Camp"
kalimdor[5064]="The Anvil of Flame"
kalimdor[5065]="Tower of Estulan"
kalimdor[5066]="Trueshot Point"
kalimdor[5067]="The Inner Spire"
kalimdor[5072]="Feathermoon Stronghold"
kalimdor[5073]="Fallowmere Inn"
kalimdor[5075]="Tirth's Haunt"
kalimdor[5087]="Sethria's Roost"
kalimdor[5092]="Razorfen Downs"
kalimdor[5093]="Northwatch Expedition Base Camp Inn"
kalimdor[5099]="The Crucible"
kalimdor[5117]="Nozzlepot's Outpost"
kalimdor[5118]="Windshear Valley"
kalimdor[5166]="Cleft of Shadow"
kalimdor[5167]="The Drag"
kalimdor[5168]="Valley of Honor"
kalimdor[5169]="Valley of Spirits"
kalimdor[5170]="Valley of Strength"
kalimdor[5171]="Valley of Wisdom"
kalimdor[5306]="Hull of the Foebreaker"
kalimdor[5312]="Nazj'vel"
kalimdor[5332]="Goblin Slums"
kalimdor[5333]="Trial of Frost"
kalimdor[5337]="Sanctum of the Prophets"
kalimdor[5345]="Thunder Bluff"
kalimdor[5356]="Grommash Hold"
kalimdor[5375]="Wreckage of the Silver Dawning"
kalimdor[5385]="The Great Divide"
kalimdor[5388]="Dawnrise Expedition"
--kalimdor[5396]="Lost City of the Tol'vir"
kalimdor[5420]="The Gate of Unending Cycles"
kalimdor[5423]="Obelisk of the Stars"
kalimdor[5429]="The Western Earthshrine"
kalimdor[5431]="Chamber of the Stars"
kalimdor[5455]="Khartut's Tomb"
kalimdor[5465]="Orsis"
kalimdor[5466]="Ramkahen"
kalimdor[5467]="Nahom"
kalimdor[5498]="Mar'at"
kalimdor[5499]="Akhenet Fields"
kalimdor[5500]="Ramkahen Legion Outpost"
kalimdor[5501]="Shrine of the Elements"
kalimdor[5504]="Lake Dumont"
kalimdor[5505]="The Pit of Scales"
kalimdor[5508]="Sunstone Terrace"
kalimdor[5517]="Blackfathom Deeps Entrance"
kalimdor[5518]="Razorfen Kraul Entrance"
kalimdor[5520]="Maruadon - The Wicked Grotto Entrance"
kalimdor[5521]="Maraudon - Foulspore Cavern Entrance"
kalimdor[5522]="Maraudon - Earth Song Falls Entrance"
kalimdor[5529]="Dire Maul - Warpwood Quarter Entrance"
kalimdor[5530]="Dire Maul - Gordok Commons Entrance"
kalimdor[5531]="Dire Maul - Capital Gardens Entrance"
kalimdor[5532]="Razorfen Downs Entrance"
kalimdor[5533]="Zul'Farrak Entrance"
kalimdor[5558]="The Escape from Durnholde Entrance"
kalimdor[5559]="Opening of the Dark Portal Entrance"
kalimdor[5560]="The Culling of Stratholme Entrance"
kalimdor[5582]="The Threshold"
kalimdor[5585]="Gate of Hamatep"
kalimdor[5586]="Vir'naal River"
kalimdor[5588]="Twilight Aerie"
kalimdor[5589]="The Twilight Withering"
kalimdor[5590]="Twilight Bulwark"
kalimdor[5591]="Sunken Dig Site"
kalimdor[5596]="Cradle of the Ancients"
kalimdor[5597]="Obelisk of the Sun"
kalimdor[5599]="Lost City of the Tol'vir"
kalimdor[5601]="Chamber of the Sun"
kalimdor[5602]="Schnottz's Landing"
kalimdor[5605]="Shriveled Oasis"
kalimdor[5606]="Ruins of Ammon"
kalimdor[5612]="The Cursed Landing"
kalimdor[5613]="The Steps of Fate"
kalimdor[5614]="The Trail of Devastation"
kalimdor[5622]="The Verdant Thicket"
kalimdor[5623]="The Circle of Cinders"
kalimdor[5624]="The Tranquil Grove"
kalimdor[5625]="Ruins of Lar'donir"
kalimdor[5626]="Shadowlurk Ridge"
kalimdor[5631]="Oasis of the Fallen Prophet"
kalimdor[5632]="The Trapper's Enclave"
kalimdor[5633]="Terrace of the Augurs"
kalimdor[5634]="Sanctum of the South Wind"
kalimdor[5635]="The Warlord's Garrison"
kalimdor[5642]="Tahret Grounds"
kalimdor[5644]="Seal of the Sun King"
kalimdor[5645]="Whisperwind Grove"
kalimdor[5646]="Sahket Wastes"
kalimdor[5647]="Ruins of Ahmtul"
kalimdor[5649]="Wildheart Point"
kalimdor[5663]="Neferset City"
kalimdor[5665]="Sunwatcher's Ridge"
kalimdor[5666]="Vir'naal Dam"
kalimdor[5668]="Obelisk of the Moon"
kalimdor[5669]="Temple of Uldum"
kalimdor[5670]="Oasis of Vir'sar"
kalimdor[5671]="Ruins of Khintaset"
kalimdor[5672]="Chamber of the Moon"
kalimdor[5673]="Sullah's Sideshow"
kalimdor[5674]="Maker's Ascent"
kalimdor[5675]="Arikara's Needle"
kalimdor[5676]="Irontree Clearing"
kalimdor[5678]="Sindweller's Rise"
kalimdor[5679]="Neferset City Outskirts"
kalimdor[5684]="Throne of the Four Winds"
kalimdor[5685]="Pilgrim's Precipice"
kalimdor[5686]="Bashal'Aran Collapse"
kalimdor[5687]="The Howling Oak"
kalimdor[5688]="Mount Akher"
kalimdor[5689]="Tombs of the Precursors"
kalimdor[5690]="Arsad Trade Post"
kalimdor[5691]="Darkspear Shore"
kalimdor[5693]="Murkdeep Cavern"
kalimdor[5694]="Keset Pass"
kalimdor[5695]="Ahn'Qiraj: The Fallen Kingdom"
kalimdor[5696]="Surveyors' Outpost"
kalimdor[5697]="M.A.C. Diver"
kalimdor[5698]="Tomb of the Sun King"
kalimdor[5700]="Schnottz's Hostel"
kalimdor[5701]="Halls of Origination Entrance"
kalimdor[5702]="The Vortex Pinnacle Entrance"
kalimdor[5703]="Goodgrub Smoking Pit"
kalimdor[5705]="Snowden Chalet"
--kalimdor[5706]="The Steam Pools"
kalimdor[5707]="Beryl Egress"
kalimdor[5708]="Lost City of the Tol'vir Entrance"
kalimdor[5709]="Atulhet's Tomb"
kalimdor[5715]="Vir'naal Oasis"
kalimdor[5716]="Vir'naal Lake"
kalimdor[5717]="Vir'naal River Delta"
kalimdor[5726]="Camp Mojache Longhouse"
kalimdor[5730]="Nordrassil Inn"
kalimdor[5732]="Halls of Origination"
--kalimdor[5733]="Molten Front"
kalimdor[5738]="Malfurion's Breach"
kalimdor[5739]="Ashen Fields"
kalimdor[5740]="Magma Springs"
kalimdor[5741]="Igneous Depths"
kalimdor[5742]="Forlorn Spire"
kalimdor[5743]="The Widow's Clutch"
kalimdor[5744]="Wildflame Point"
kalimdor[5745]="The Furnace"
kalimdor[5746]="The Molten Flow"
kalimdor[5747]="Crumbling Stones"
kalimdor[5748]="Fireplume Peak"
kalimdor[5749]="Ragnaros' Reach"
kalimdor[5758]="Dreadmist Camp"
kalimdor[5763]="Rhyolith Plateau"
kalimdor[5764]="Beth'tilac's Lair"
kalimdor[5765]="Flamebreach"
kalimdor[5766]="Shatterstone"
kalimdor[5767]="Mortal's Demise"
kalimdor[5768]="Sulfuron Span"
kalimdor[5769]="Sulfuron Keep Courtyard"
kalimdor[5770]="Sulfuron Keep"
kalimdor[5771]="The Molten Fields"
kalimdor[5781]="Nordune Ridge"
kalimdor[5782]="Darsok's Outpost"
kalimdor[5784]="Cloudtop Terrace"
kalimdor[5787]="Schnottz's Frigate"
kalimdor[5790]="Ruby Dragonshrine"
kalimdor[5791]="The Ridge of Ancient Flame"
kalimdor[5792]="Obsidian Dragonshrine"
kalimdor[5793]="Azure Dragonshrine"
kalimdor[5794]="Emerald Dragonshrine"
kalimdor[5795]="Bronze Dragonshrine"
kalimdor[5796]="Entryway of Time"
kalimdor[5798]="The Anvil of Conflagration"
kalimdor[5807]="Beth'tilac's Lair"
kalimdor[5808]="Sulfuron Keep Courtyard"
kalimdor[5809]="Sulfuron Keep"
kalimdor[5810]="Anvil of Conflagration"
kalimdor[5811]="The Molten Fields"
kalimdor[5812]="Mortal's Demise"
kalimdor[5813]="Sulfuron Span"
kalimdor[5814]="Shatterstone"
kalimdor[5815]="Flamebreach"
kalimdor[5816]="The Ridge of Ancient Flame"
kalimdor[5817]="Rhyolith Plateau"
kalimdor[5821]="The Path of Corruption"
kalimdor[5823]="Circle of Thorns"
kalimdor[5824]="Bluff of the South Wind"
kalimdor[5839]="The Great Divide"
kalimdor[5845]="Wyrmrest Temple"
kalimdor[5893]="The Maelstrom"
kalimdor[5913]="Dire Maul - North"
kalimdor[5914]="Dire Maul - East"
kalimdor[5915]="Dire Maul - West"
kalimdor[5920]="Eye of Eternity"
kalimdor[5922]="Above the Frozen Sea"
kalimdor[5923]="The Dragon Wastes"
kalimdor[5924]="Azure Dragonshrine"
kalimdor[5925]="Emerald Dragonshrine"
kalimdor[5926]="Path of the Titans"
kalimdor[5928]="Wyrmrest Summit"
kalimdor[5960]="Deathwing"
kalimdor[5979]="The Great Sea"
kalimdor[5988]="The Crystal Vice"
kalimdor[5989]="The Dragon Wastes"
kalimdor[5990]="Galakrond's Rest"
kalimdor[5991]="Path of the Titans"
kalimdor[5993]="Courtyard of Lights"
kalimdor[5994]="Shores of the Well"
kalimdor[5995]="Azshara's Palace"

l10n.zoneLookup[530][3832]="Vortex Summit"
l10n.zoneCategoryLookup[8][1477]="Sunken Temple"

if Expansions.Current >= Expansions.MoP then
    local pandaria = l10n.zoneLookup[870]
    -- Pandaren starting zone
    pandaria[5736]="The Wandering Isle"
    pandaria[5737]="Pei-Wu Forest"
    pandaria[5820]="Temple of Five Dawns"
    pandaria[5825]="The Dawning Valley"
    pandaria[5826]="The Singing Pools"
    pandaria[5827]="The Rows"
    pandaria[5828]="Mandori Village"
    pandaria[5829]="Ridge of Laughing Winds"
    pandaria[5830]="Morning Breeze Village"
    pandaria[5831]="Fe-Feng Village"
    pandaria[5832]="The Wood of Staves"
    pandaria[5833]="Wreck of the Skyseeker"
    pandaria[5834]="Shang Xi Training Grounds"
    pandaria[5835]="Wu-Song Village"
    pandaria[5837]="The Dawning Span"
    pandaria[5843]="Tranquil Grotto"
    pandaria[5846]="Fu's Pond"
    pandaria[5847]="The Dawning Stair"
    pandaria[5848]="Cave of Meditation"
    pandaria[5849]="Shrine of Inner-Light"
    pandaria[5859]="The Elders' Path"
    pandaria[5860]="Liang's Retreat"
    pandaria[5862]="Pool of Reflection"
    pandaria[5881]="The Dai-Lo Farmstead"
    pandaria[5882]="Virmen Grotto"
    pandaria[5883]="Teeming Burrow"
    pandaria[5884]="Ki-Han Brewery"
    pandaria[5885]="Shrine of Dreaming Stones"
    pandaria[5886]="Chamber of Whispers"
    pandaria[5941]="The Great Sea"
    pandaria[5944]="Forlorn Hut"
    pandaria[5945]="Pool of the Paw"
    pandaria[5946]="Morning Breeze Lake"
    pandaria[5947]="Shrine of Five Dawns"
    -- Pandaria continent
    pandaria[5785]="The Jade Forest"
    pandaria[5805]="Valley of the Four Winds"
    pandaria[5836]="Forest Heart"
    pandaria[5840]="Vale of Eternal Blossoms"
    pandaria[5841]="Kun-Lai Summit"
    pandaria[5842]="Townlong Steppes"
    pandaria[5850]="Silken Shore"
    pandaria[5851]="Paw'don Glade"
    pandaria[5852]="Wreck of the Vanguard"
    pandaria[5853]="Garrosh'ar Point"
    pandaria[5854]="Nectarbreeze Orchard"
    pandaria[5855]="Tian Monastery"
    pandaria[5856]="Shrine of Remembrance"
    pandaria[5857]="Camp Gormal"
    pandaria[5863]="Banquet Grounds"
    pandaria[5865]="Wreck of Hellscream's Fist"
    pandaria[5866]="Ascent of Swirling Winds"
    pandaria[5867]="Strongarm Airstrip"
    pandaria[5868]="The Ring of Inner Focus"
    pandaria[5871]="The Ring of Balance"
    pandaria[5872]="Slingtail Pits"
    pandaria[5873]="Sea Mist Ridge"
    pandaria[5874]="Waxwood"
    pandaria[5875]="Lair of the Jade Witch"
    pandaria[5876]="Serpent's Heart"
    pandaria[5878]="Orchid Hollow"
    pandaria[5879]="Terrace of Ten Thunders"
    pandaria[5887]="Shadybranch Pocket"
    pandaria[5890]="Fox Grove"
    pandaria[5891]="Shang's Valley"
    pandaria[5896]="The Orchid Pond - NOT USED"
    pandaria[5897]="The Fertile Copse"
    pandaria[5898]="Serenity Falls"
    pandaria[5899]="Path of Enlightenment"
    pandaria[5900]="Exclamation Point"
    pandaria[5901]="Cave of Words"
    pandaria[5905]="Camp Nooka Nooka"
    pandaria[5906]="Spire of Solitude"
    pandaria[5907]="Lake Kittitata"
    pandaria[5908]="Circle of Scale"
    pandaria[5909]="Circle of Blood"
    pandaria[5910]="Circle of Bone"
    pandaria[5911]="Circle of Stone"
    pandaria[5912]="Tideview Thicket"
    pandaria[5919]="Uncharted Sea"
    pandaria[5921]="Tasters' Arena"
    pandaria[5929]="The Silkwood"
    pandaria[5930]="Dawn's Blossom"
    pandaria[5931]="The Arboretum"
    pandaria[5932]="Shrine of the Dawn"
    pandaria[5933]="The Gong of Hope"
    pandaria[5934]="Pearl Lake"
    pandaria[5935]="Pearlfin Village"
    pandaria[5936]="Pang's Stead"
    pandaria[5937]="Thunderfoot Fields"
    pandaria[5938]="Thunderfoot Ranch"
    pandaria[5939]="Thunderfoot Farm"
    pandaria[5940]="Dreamer's Pavilion"
    pandaria[5942]="Tigers' Wood"
    pandaria[5943]="Amberfly Bog"
    pandaria[5948]="Grassy Cline"
    pandaria[5949]="Shang's Stead"
    pandaria[5950]="Grookin Hill"
    pandaria[5951]="Dookin' Grounds"
    pandaria[5952]="Scenic Overlook"
    pandaria[5953]="Murky Bank"
    pandaria[5954]="Den of Sorrow"
    pandaria[5955]="Greenstone Quarry"
    pandaria[5957]="Mudmug's Place"
    pandaria[5958]="Sunsoaked Meadow"
    pandaria[5959]="The Twisted Warren"
    pandaria[5961]="Slicky Stream"
    pandaria[5962]="Emperor's Omen"
    pandaria[5964]="The Bamboo Wilds"
    pandaria[5966]="Woods of the Lost"
    pandaria[5967]="Paoquan Hollow"
    pandaria[5968]="Stoneplow"
    pandaria[5969]="Stoneplow Fields"
    pandaria[5970]="Singing Marshes"
    pandaria[5972]="Pools of Purity"
    pandaria[5973]="New Cifera"
    pandaria[5974]="Jade Temple Grounds"
    pandaria[5975]="Temple of the Jade Serpent"
    pandaria[5980]="Halfhill"
    pandaria[5981]="The Halfhill Market"
    pandaria[5982]="The Imperial Granary"
    pandaria[5983]="Plain of Thieves"
    pandaria[5984]="Gilded Fan"
    pandaria[5985]="Winds' Edge"
    pandaria[5986]="Silken Fields"
    pandaria[5987]="The Gilding Stream"
    pandaria[5992]="The Heartland"
    pandaria[5996]="Springtail Warren"
    pandaria[6000]="Zhu's Watch"
    pandaria[6001]="Stormstout Brewery"
    pandaria[6002]="Thirsty Alley"
    pandaria[6004]="The Deepwild"
    pandaria[6005]="Zhu Province"
    pandaria[6006]="The Veiled Stair"
    pandaria[6007]="Thunder Cleft"
    pandaria[6008]="Ruins of Dojan"
    pandaria[6009]="The Incursion"
    pandaria[6010]="Dojani River"
    pandaria[6011]="Pools of Youth"
    pandaria[6012]="Windward Isle"
    pandaria[6013]="Dawnchaser Retreat"
    pandaria[6014]="Krasarang River"
    pandaria[6015]="Ruins of Korja"
    pandaria[6016]="Sentinel Basecamp"
    pandaria[6017]="Fallsong Village"
    pandaria[6018]="Krasari Falls"
    pandaria[6019]="The Forbidden Jungle"
    pandaria[6020]="The Southern Wall"
    pandaria[6021]="Huangtze Falls"
    pandaria[6022]="Mistveil Sea"
    pandaria[6023]="Windspire Bridge"
    pandaria[6024]="The Windspire"
    pandaria[6025]="Nesingwary's Safari"
    pandaria[6026]="The Krasari Ruins"
    pandaria[6027]="Virmen Nest"
    pandaria[6028]="Dustback Gorge"
    pandaria[6029]="The Torjari Pit"
    pandaria[6030]="The Wild Plains"
    pandaria[6031]="Mistfall Village"
    pandaria[6032]="Ruins of Guo-Lai"
    pandaria[6033]="The Golden Stair"
    pandaria[6034]="Whitepetal Lake"
    pandaria[6035]="Setting Sun Garrison"
    pandaria[6036]="The Golden Pagoda"
    pandaria[6037]="Tu Shen Burial Ground"
    pandaria[6038]="Lair of the Beast"
    pandaria[6039]="Sunsong Ranch"
    pandaria[6048]="Temple of the Red Crane"
    pandaria[6049]="Crane Wing Refuge"
    pandaria[6050]="Spiritsong River"
    pandaria[6053]="Ruins Rise"
    pandaria[6054]="Winterbough Glade"
    pandaria[6055]="The Five Sisters"
    pandaria[6058]="Shattered Convoy"
    pandaria[6059]="Binan Village"
    pandaria[6062]="Kun-Lai Pass"
    pandaria[6063]="Moonwater Retreat"
    pandaria[6064]="Skyrange"
    pandaria[6065]="Kunzen Village"
    pandaria[6069]="Inkgill Mere"
    pandaria[6071]="The Drunken Hozen"
    pandaria[6072]="Lao & Son's Yakwash"
    pandaria[6073]="The Autumn Plains"
    pandaria[6074]="Guo-Lai Halls"
    pandaria[6075]="The Golden Gateway"
    pandaria[6076]="Auburn Bluffs"
    pandaria[6077]="Sri-La Village"
    pandaria[6078]="Seat of the Spirit Waker"
    pandaria[6079]="The Grummle Bazaar"
    pandaria[6080]="Serpent's Overlook"
    pandaria[6081]="Peak of Serenity"
    pandaria[6082]="The Splintered Path"
    pandaria[6083]="Camp Broketooth"
    pandaria[6084]="The Deeper"
    pandaria[6085]="One Keg"
    pandaria[6086]="Broketooth Outpost"
    pandaria[6087]="The Dooker Dome"
    pandaria[6088]="Knucklethump Hole"
    pandaria[6089]="Yeti Mountain Basecamp"
    pandaria[6090]="The Burlap Trail"
    pandaria[6091]="The Burlap Valley"
    pandaria[6092]="Greenstone Masons' Quarter"
    pandaria[6093]="Fire Camp Bataar"
    pandaria[6094]="Eastwind Rest"
    pandaria[6095]="Westwind Rest"
    pandaria[6096]="Cattail Lake"
    pandaria[6097]="Kunzen Cave"
    pandaria[6098]="Chow Farmstead"
    pandaria[6099]="Pranksters' Hollow"
    pandaria[6100]="Muskpaw Ranch"
    pandaria[6104]="Thunderpaw Refuge"
    pandaria[6105]="Thunderpaw Overlook"
    pandaria[6106]="Anglers Wharf"
    pandaria[6107]="Verdant Belt"
    pandaria[6108]="Narsong Trench"
    pandaria[6110]="The Thunderwood"
    pandaria[6111]="The Burlap Waystation"
    pandaria[6113]="Narsong Spires"
    pandaria[6114]="Mogujia"
    pandaria[6121]="Fire Camp Ruqin"
    pandaria[6124]="Fire Camp Ordo"
    pandaria[6127]="The Silent Sanctuary"
    pandaria[6128]="Shado-Pan Fallback"
    pandaria[6129]="Firebough Nook"
    pandaria[6134]="Krasarang Wilds"
    pandaria[6135]="Nayeli Lagoon"
    pandaria[6138]="Dread Wastes"
    pandaria[6140]="Mogu Ruins Bural Pit (TEMP)"
    pandaria[6141]="Shrine of Two Moons"
    pandaria[6142]="Shrine of Seven Stars"
    --pandaria[6143]="Mogu'shan Palace"
    pandaria[6144]="Jin Yang Road"
    pandaria[6145]="The Summer Fields"
    pandaria[6146]="Marista"
    pandaria[6147]="Kea Krak"
    pandaria[6148]="Unga Ingoo"
    pandaria[6149]="Ancestral Rise"
    pandaria[6150]="The Ox Gate"
    pandaria[6151]="Mortbreath Grotto"
    pandaria[6152]="Fire Camp Yongqi"
    pandaria[6154]="Yinying Village"
    pandaria[6155]="Cradle of Chi-Ji"
    pandaria[6156]="Kota Peak"
    pandaria[6157]="Kota Basecamp"
    pandaria[6158]="Sandy Shallows"
    pandaria[6159]="Sarjun Depths"
    pandaria[6160]="Angkhal Pavilion"
    pandaria[6161]="Pedestal of Hope"
    pandaria[6162]="Dome Balrissa"
    pandaria[6163]="Fire Camp Osul"
    pandaria[6164]="Lower Sumprushes"
    pandaria[6165]="Upper Sumprushes"
    pandaria[6166]="Longying Outpost"
    pandaria[6168]="Zouchin Strand"
    pandaria[6169]="Zouchin Village"
    pandaria[6171]="Hatred's Vice"
    pandaria[6172]="Tallmug's Camp"
    pandaria[6173]="Shado-Pan Monastery"
    pandaria[6174]="Temple of the White Tiger"
    pandaria[6175]="Seeker's Folly"
    pandaria[6179]="Owen's Wishing Well"
    pandaria[6180]="Neverest Pinnacle"
    pandaria[6181]="Waterspeaker's Sanctuary"
    pandaria[6184]="Seeker's Point"
    pandaria[6185]="Mount Neverest"
    pandaria[6186]="Neverest Basecamp"
    pandaria[6187]="Gao-Ran Battlefront"
    pandaria[6188]="Shallowstep Pass"
    pandaria[6189]="The Widening Deep"
    pandaria[6190]="Dampsoil Burrow"
    pandaria[6191]="Dusklight Hollow"
    pandaria[6192]="Dusklight Bridge"
    pandaria[6193]="Rensai's Watchpost"
    pandaria[6194]="Farwatch Overlook"
    pandaria[6195]="Sik'vess"
    pandaria[6196]="Sik'vess Lair"
    pandaria[6197]="Shado-Pan Garrison"
    pandaria[6198]="Valley of Emperors"
    pandaria[6199]="Tomb of Shadows"
    pandaria[6200]="Tomb of Secrets"
    pandaria[6201]="Tomb of Conquerors"
    pandaria[6202]="Shrine of the Merciless One"
    pandaria[6203]="Emperor Rikktik's Rest"
    pandaria[6204]="Greenstone Village"
    pandaria[6205]="Kri'vess"
    pandaria[6206]="Whispercloud Rise"
    pandaria[6207]="The Zandalari Vanguard"
    pandaria[6212]="Sra'thik Incursion"
    pandaria[6213]="Niuzao Catacombs"
    pandaria[6218]="The Dark Hollow"
    pandaria[6220]="Fields of Niuzao"
    pandaria[6293]="Lake of Stars"
    pandaria[6294]="Shado-Li Basin"
    pandaria[6295]="Seat of Knowledge"
    pandaria[6299]="The Amber Womb"
    pandaria[6300]="Kypari Zar"
    pandaria[6306]="Terrace of Gurthan"
    pandaria[6307]="Shan'ze Dao"
    pandaria[6308]="Sri-La Inn"
    pandaria[6311]="Niuzao Catacombs"
    pandaria[6312]="Fire Camp Gai-Cho"
    pandaria[6314]="Sra'vess"
    pandaria[6315]="Klaxxi'vess"
    pandaria[6316]="Ik'vess"
    pandaria[6317]="Klik'vess"
    pandaria[6318]="Set'vess"
    pandaria[6329]="Kor'vess"
    pandaria[6331]="Westersea"
    pandaria[6332]="The Overlook Inn"
    pandaria[6333]="Paur's Pub"
    pandaria[6334]="The Sunset Brewgarden"
    pandaria[6335]="The Horrid March"
    pandaria[6336]="Rikkitun Village"
    pandaria[6337]="Gokk'lok Shallows"
    pandaria[6338]="The Amber Hibernal"
    pandaria[6339]="Rikkilea"
    pandaria[6342]="Ambermarsh"
    pandaria[6343]="Kypari Vor"
    pandaria[6345]="Nook of Konk"
    pandaria[6346]="Morrowchamber"
    pandaria[6347]="The Amber Vault"
    pandaria[6348]="Deadtalker's Plateau"
    pandaria[6349]="The Dancing Serpent"
    pandaria[6354]="The Lazy Turnip"
    pandaria[6355]="Thunderfoot Inn"
    pandaria[6356]="Stone Mug Tavern"
    pandaria[6358]="Wilds' Edge Inn"
    pandaria[6359]="Binan Brew & Stew"
    pandaria[6360]="The Lucky Traveller"
    pandaria[6361]="The Two Fisted Brew"
    pandaria[6362]="North Wind Tavern"
    pandaria[6363]="The Golden Rose"
    pandaria[6364]="Tavern in the Mists"
    pandaria[6365]="The Chum Bucket"
    pandaria[6366]="Marista's Bait & Brew"
    pandaria[6367]="Greenstone Inn"
    pandaria[6368]="Soggy's Gamble"
    pandaria[6369]="Krasarang Cove"
    pandaria[6370]="Turtle Beach"
    pandaria[6371]="The Southern Isles"
    pandaria[6372]="Gate of Endless Spring"
    pandaria[6373]="The Secret Aerie"
    pandaria[6375]="Tavern in the Mists"
    pandaria[6376]="The Ancient Passage"
    pandaria[6377]="Hatescale Burrow"
    pandaria[6378]="Field of Korja"
    pandaria[6380]="Path of a Hundred Steps"
    pandaria[6381]="The Spring Road"
    pandaria[6382]="Mason's Folly"
    pandaria[6383]="Winter's Blossom"
    pandaria[6387]="Rumbling Terrace"
    pandaria[6388]="Zhu's Descent"
    pandaria[6389]="Howlingwind Cavern"
    pandaria[6390]="Gai-Cho Battlefield"
    pandaria[6391]="The Briny Muck"
    pandaria[6392]="The Underbough"
    pandaria[6393]="Serpent's Spine"
    pandaria[6394]="Serpent's Spine"
    pandaria[6395]="Serpent's Spine"
    pandaria[6396]="Gate of the Setting Sun"
    pandaria[6397]="The Clarion Bell"
    pandaria[6398]="Shrine of Twin Serpents"
    pandaria[6401]="Shelf of Mazu"
    pandaria[6402]="Wreck of the Mist-Hopper"
    pandaria[6403]="Muckscale Grotto"
    pandaria[6404]="Muckscale Shallows"
    pandaria[6405]="Zouchin Province"
    pandaria[6406]="Isle of Reckoning"
    pandaria[6407]="Thunder's Call"
    pandaria[6408]="Forward Assault Camp"
    pandaria[6409]="Rear Staging Area"
    pandaria[6410]="Hollowed Out Tree"
    pandaria[6414]="Grove of Falling Blossoms"
    pandaria[6415]="The Yaungol Advance"
    pandaria[6417]="Yan-Zhe River"
    pandaria[6418]="Venomous Ledge"
    pandaria[6420]="The Feeding Pits"
    pandaria[6421]="Kzzok Warcamp"
    pandaria[6422]="Sra'thik Swarmdock"
    pandaria[6423]="Ikz'ka Ridge"
    pandaria[6424]="Sra'vess Rootchamber"
    pandaria[6425]="Forgotten Mire"
    pandaria[6429]="Chittering Coast"
    pandaria[6430]="Anglers Expedition"
    pandaria[6431]="Seaspittle Cove"
    pandaria[6432]="Amberglow Hollow"
    pandaria[6433]="Lonesome Cove"
    pandaria[6434]="The Thundering Run"
    pandaria[6435]="Heart of Fear"
    pandaria[6436]="Dread Clutch"
    pandaria[6437]="Fear Clutch"
    pandaria[6438]="Horror Clutch"
    pandaria[6439]="Panic Clutch"
    pandaria[6440]="Kypari Ik"
    pandaria[6441]="Duskroot Fen"
    pandaria[6442]="The Clutches of Shek'zeer"
    pandaria[6443]="Writhingwood"
    pandaria[6444]="Zan'vess"
    pandaria[6445]="Whispering Stones"
    pandaria[6446]="Amber Quarry"
    pandaria[6447]="The Stinging Trail"
    pandaria[6448]="Mazu's Overlook"
    pandaria[6462]="Path of Conquerors"
    pandaria[6466]="Cavern of Endless Echoes"
    pandaria[6467]="Mogu'shan Terrace"
    pandaria[6468]="The Emperor's Reach"
    pandaria[6469]="Howlingwind Trail"
    pandaria[6477]="South Seas"
    pandaria[6478]="South Seas"
    pandaria[6479]="South Seas"
    pandaria[6480]="South Seas"
    pandaria[6481]="South Seas"
    pandaria[6482]="The Summer Terrace"
    pandaria[6483]="The Emperor's Step"
    pandaria[6484]="The Golden Lantern"
    pandaria[6485]="Chamber of Enlightenment"
    pandaria[6486]="The Celestial Vault"
    pandaria[6487]="Ethereal Corridor"
    pandaria[6488]="The Star's Bazaar"
    pandaria[6489]="The Imperial Exchange"
    pandaria[6490]="Nightingale Lounge"
    pandaria[6492]="Chamber of Reflection"
    pandaria[6494]="Shrine of Fellowship"
    pandaria[6495]="The Hall of Tiles"
    pandaria[6496]="Guo-Lai Ritual Chamber"
    pandaria[6497]="The Hall of Statues"
    pandaria[6498]="Gate of the August Celestials"
    pandaria[6499]="The Hall of the Serpent"
    pandaria[6503]="Guo-Lai Vault"
    pandaria[6504]="The Emperor's Approach"
    pandaria[6505]="The Riverblade Den"
    pandaria[6506]="Motherseed Pit"
    pandaria[6508]="Springtail Crag"
    pandaria[6509]="Stormstout Brewery Interior"
    pandaria[6512]="The Widow's Wail"
    pandaria[6513]="Oona Kagu"
    pandaria[6516]="Paw'don Village"
    pandaria[6517]="Twinspire Keep"
    pandaria[6518]="Path of Serenity"
    pandaria[6519]="Summer's Rest"
    pandaria[6520]="Gokk'lok's Grotto"
    pandaria[6521]="Honeydew Village"
    pandaria[6522]="Honeydew Glade"
    pandaria[6523]="Honeydew Farm"
    pandaria[6524]="Thunder Hold"
    pandaria[6525]="Hellscream's Fist"
    pandaria[6526]="Training Grounds"
    pandaria[6527]="Terrace of the Tiger"
    pandaria[6528]="Serpent's Spine"
    pandaria[6530]="Serpent's Spine"
    pandaria[6533]="The Skyfire"
    pandaria[6534]="Twinspire Keep Interior"
    pandaria[6535]="Den of Defiance"
    pandaria[6538]="Autumnshade Ridge"
    pandaria[6539]="Sunblossom Hill"
    pandaria[6540]="Spiritsong's Rest"
    pandaria[6541]="Applebloom Tavern"
    pandaria[6542]="Terrace of Gurthan"
    pandaria[6543]="Mistblade Den"
    pandaria[6544]="Coldbite Burrow"
    pandaria[6547]="The Deepwild"
    pandaria[6548]="Venomous Ledge"
    pandaria[6549]="Sra'vess"
    pandaria[6550]="Fields of Niuzao"
    pandaria[6551]="Townlong Steppes"
    pandaria[6552]="Kun-Lai Summit"
    pandaria[6553]="Shrine of Seven Stars"
    pandaria[6554]="Shrine of Two Moons"
    pandaria[6557]="Zouchin Province"
    pandaria[6558]="The Zandalari Vanguard"
    pandaria[6560]="The Golden Terrace"
    pandaria[6561]="Kril'Mandar Point"
    pandaria[6562]="The Southern Isles"
    pandaria[6563]="Krasarang Cove"
    pandaria[6566]="Domination Point"
    pandaria[6572]="Snicklefritz Mine"
    pandaria[6595]="The Skyfire"
    pandaria[6596]="Lion's Landing"
    pandaria[6597]="Sparkrocket Outpost"
    pandaria[6600]="Blacksand Spillway"
    pandaria[6601]="Bilgewater Beach"
    pandaria[6602]="The Boiling Crustacean"
    pandaria[6603]="Oregrind's Dig"
    pandaria[6604]="Quickchop's Lumber Farm"
    pandaria[6609]="Ruins of Ogudei"
    pandaria[6612]="Horde Landing Site"
    pandaria[6617]="Garrosh'ar Advance"
    pandaria[6619]="Ruins of Korune"
    pandaria[6620]="Lair of Skiggit"
    pandaria[6661]="Isle of Giants"
    pandaria[6683]="Misty Shores"
    pandaria[6701]="Beeble's Wreck"
    pandaria[6702]="Bozzle's Wreck"
    pandaria[6728]="Isle of Giants"
    pandaria[6751]="Big Blossom Excavation"
    pandaria[6752]="Big Blossom Mine"
    pandaria[6757]="Timeless Isle"
    pandaria[6770]="Blackguard's Forgotten Cove"
    pandaria[6773]="Old Pi'jiu"
    pandaria[6780]="Cavern of Lost Spirits"
    pandaria[6821]="South Seas"
    pandaria[6822]="Ruby Lake"
    pandaria[6823]="Ordon Sanctuary"
    pandaria[6824]="Croaking Hollow"
    pandaria[6825]="Firewalker Ruins"
    pandaria[6830]="The Celestial Court"
    pandaria[6831]="Mossgreen Lake"
    pandaria[6832]="The Timeless Shore"
    pandaria[6833]="Tushui Landing"
    pandaria[6834]="Huojin Landing"
    pandaria[6835]="The Misty Strand"
    pandaria[6836]="Three-Breeze Terrace"
    pandaria[6837]="Kukuru's Grotto"
    pandaria[6838]="Tsavo'ka's Den"
    pandaria[6839]="Mysterious Den"
    pandaria[6840]="Whispershade Hollow"
    pandaria[6841]="Red Stone Run"
    pandaria[6842]="Firewalkers' Path"
    pandaria[6843]="Shrine of the Black Flame"
    pandaria[6844]="The Blazing Way"
    pandaria[6846]="Time-Lost Waters"
    -- Isle of Thunder
    pandaria[6507]="Isle of Thunder"
    pandaria[6576]="Diremoor"
    pandaria[6577]="The Thunderspire"
    pandaria[6578]="Court of Bones"
    pandaria[6579]="Za'Tual"
    pandaria[6580]="Ihgaluk Crag"
    pandaria[6581]="Zeb'tula"
    pandaria[6582]="Shaol'mara"
    pandaria[6583]="Violet Rise"
    pandaria[6584]="Dawnseeker Promontory"
    pandaria[6585]="The Emperor's Gate"
    pandaria[6586]="The Beast Pens"
    pandaria[6587]="Conqueror's Terrace"
    pandaria[6588]="Bloodied Crossing"
    pandaria[6589]="Lightning Vein Mine"
    pandaria[6590]="The Thunder Forges"
    pandaria[6591]="Stormsea Landing"
    pandaria[6592]="The Swollen Vault"
    pandaria[6593]="The Foot of Lei Shen"
    pandaria[6594]="Hall of the Defamed"
    pandaria[6608]="Heyman's Hubris"
    pandaria[6671]="Hall of the Exalted"
    pandaria[6672]="Bleak Hollow"
    pandaria[6676]="Bay of Echoes"
    pandaria[6680]="Battlefront Provisions"
    pandaria[6703]="Whispering Inlet"
    pandaria[6708]="The Crimson Treader"
    pandaria[6709]="Salabria"
    pandaria[6710]="The Starchaser"
    pandaria[6711]="Spellsails"
    pandaria[6712]="The Seabolt"
    pandaria[6713]="Rhonin's Beard"
    pandaria[6714]="Hall of the Grand Imperion"
    pandaria[6724]="Backbreaker Bay"
    pandaria[6725]="Greymist Firth"
    pandaria[6726]="Wildvine Marsh"
    pandaria[6727]="Shadewood Thicket"
    pandaria[6729]="Isle of Thunder"
    pandaria[6731]="The Secrets of Ragefire"
    pandaria[6732]="The Tiger's Peak"
    pandaria[6733]="Dark Heart of Pandaria"
    pandaria[6738]="Siege of Orgrimmar"

    l10n.zoneLookup[369][6618]="Bizmo's Brawlpub"
end
