---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")


local raidLocales = {
    ["Molten Core"] = {
        ["enUS"] = true,
        ["deDE"] = "Geschmolzener Kern",
        ["esES"] = "Núcleo de Magma",
        ["esMX"] = "Núcleo de Magma",
        ["frFR"] = "Cœur du Magma",
        ["koKR"] = "화산 심장부",
        ["ptBR"] = "Núcleo Derretido",
        ["ruRU"] = "Огненные Недра",
        ["zhCN"] = "熔火之心",
        ["zhTW"] = "熔火之心",
    },
    ["Blackwing Lair"] = {
        ["enUS"] = true,
        ["deDE"] = "Pechschwingenhort",
        ["esES"] = "Guarida Alanegra",
        ["esMX"] = "Guarida de Alanegra",
        ["frFR"] = "Repaire de l'Aile noire",
        ["koKR"] = "검은날개 둥지",
        ["ptBR"] = "Covil Asa Negra",
        ["ruRU"] = "Логово Крыла Тьмы",
        ["zhCN"] = "黑翼之巢",
        ["zhTW"] = "黑翼之巢",
    },
    ["Onyxia's Lair"] = {
        ["enUS"] = true,
        ["deDE"] = "Onyxias Hort",
        ["esES"] = "Guarida de Onyxia",
        ["esMX"] = "Guarida de Onyxia",
        ["frFR"] = "Repaire d'Onyxia",
        ["koKR"] = "오닉시아의 둥지",
        ["ptBR"] = "Covil da Onyxia",
        ["ruRU"] = "Логово Ониксии",
        ["zhCN"] = "奥妮克希亚的巢穴",
        ["zhTW"] = "奧妮克希亞的巢穴",
    },
    ["Zul'Gurub"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "줄구룹",
        ["ptBR"] = true,
        ["ruRU"] = "Зул'Гуруб",
        ["zhCN"] = "祖尔格拉布",
        ["zhTW"] = "祖爾格拉布",
    },
    ["Ruins of Ahn'Qiraj"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Ahn'Qiraj",
        ["esES"] = "Ruinas de Ahn'Qiraj",
        ["esMX"] = "Ruinas de Ahn'Qiraj",
        ["frFR"] = "Ruines d'Ahn'Qiraj",
        ["koKR"] = "안퀴라즈 폐허",
        ["ptBR"] = "Ruínas de Ahn'Qiraj",
        ["ruRU"] = "Руины Ан'Киража",
        ["zhCN"] = "安其拉废墟",
        ["zhTW"] = "安其拉廢墟",
    },
    ["Ahn'Qiraj"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "안퀴라즈",
        ["ptBR"] = true,
        ["ruRU"] = "Ан'Кираж",
        ["zhCN"] = "安其拉",
        ["zhTW"] = "安其拉",
    },
    ["Naxxramas"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "낙스라마스",
        ["ptBR"] = true,
        ["ruRU"] = "Наксрамас",
        ["zhCN"] = "纳克萨玛斯",
        ["zhTW"] = "納克薩瑪斯",
    },
    ["Karazhan"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "카라잔",
        ["ptBR"] = true,
        ["ruRU"] = "Каражан",
        ["zhCN"] = "卡拉赞",
        ["zhTW"] = "卡拉贊",
    },
    ["Gruul's Lair"] = {
        ["enUS"] = true,
        ["deDE"] = "Gruuls Unterschlupf",
        ["esES"] = "Guarida de Gruul",
        ["esMX"] = "Guarida de Gruul",
        ["frFR"] = "Repaire de Gruul",
        ["koKR"] = "그룰의 둥지",
        ["ptBR"] = "Covil de Gruul",
        ["ruRU"] = "Логово Груула",
        ["zhCN"] = "格鲁尔的巢穴",
        ["zhTW"] = "戈魯爾之巢",
    },
    ["Magtheridon's Lair"] = {
        ["enUS"] = true,
        ["deDE"] = "Magtheridons Kammer",
        ["esES"] = "Guarida de Magtheridon",
        ["esMX"] = "Guarida de Magtheridon",
        ["frFR"] = "Le repaire de Magtheridon",
        ["koKR"] = "마그테리돈의 둥지",
        ["ptBR"] = "Covil de Magtheridon",
        ["ruRU"] = "Логово Магтеридона",
        ["zhCN"] = "玛瑟里顿的巢穴",
        ["zhTW"] = "瑪瑟里頓的巢穴",
    },
    ["Serpentshrine Cavern"] = {
        ["enUS"] = true,
        ["deDE"] = "Höhle des Schlangenschreins",
        ["esES"] = "Caverna Santuario Serpiente",
        ["esMX"] = "Caverna Santuario Serpiente",
        ["frFR"] = "Caverne du sanctuaire du Serpent",
        ["koKR"] = "불뱀 제단",
        ["ptBR"] = "Caverna do Serpentário",
        ["ruRU"] = "Змеиное святилище",
        ["zhCN"] = "毒蛇神殿",
        ["zhTW"] = "毒蛇神殿洞穴",
    },
    ["Tempest Keep"] = {
        ["enUS"] = true,
        ["deDE"] = "Festung der Stürme",
        ["esES"] = "El Castillo de la Tempestad",
        ["esMX"] = "El Castillo de la Tempestad",
        ["frFR"] = "Donjon de la Tempête",
        ["koKR"] = "폭풍우 요새",
        ["ptBR"] = "Bastilha da Tormenta",
        ["ruRU"] = "Крепость Бурь",
        ["zhCN"] = "风暴要塞",
        ["zhTW"] = "風暴要塞",
    },
    ["Hyjal Summit"] = {
        ["enUS"] = true,
        ["deDE"] = "Hyjalgipfel",
        ["esES"] = "La Cima Hyjal",
        ["esMX"] = "La Cima Hyjal",
        ["frFR"] = "Sommet d'Hyjal",
        ["koKR"] = "하이잘 정상",
        ["ptBR"] = "Pico Hyjal",
        ["ruRU"] = "Вершина Хиджала",
        ["zhCN"] = "海加尔峰",
        ["zhTW"] = "海加爾山",
    },
    ["Black Temple"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Schwarze Tempel",
        ["esES"] = "El Templo Oscuro",
        ["esMX"] = "El Templo Oscuro",
        ["frFR"] = "Le Temple noir",
        ["koKR"] = "검은 사원",
        ["ptBR"] = "Templo Negro",
        ["ruRU"] = "Черный храм",
        ["zhCN"] = "黑暗神殿",
        ["zhTW"] = "黑暗神廟",
    },
    ["Zul'Aman"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "줄아만",
        ["ptBR"] = true,
        ["ruRU"] = "Зул'Аман",
        ["zhCN"] = "祖阿曼",
        ["zhTW"] = "祖阿曼",
    },
    ["Sunwell Plateau"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenbrunnenplateau",
        ["esES"] = "Meseta de La Fuente del Sol",
        ["esMX"] = "Meseta de La Fuente del Sol",
        ["frFR"] = "Plateau du Puits de soleil",
        ["koKR"] = "태양샘 고원",
        ["ptBR"] = "Platô da Nascente do Sol",
        ["ruRU"] = "Плато Солнечного Колодца",
        ["zhCN"] = "太阳之井高地",
        ["zhTW"] = "太陽之井高地",
    },
    ["Ulduar"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "울두아르",
        ["ptBR"] = true,
        ["ruRU"] = "Ульдуар",
        ["zhCN"] = "奥杜尔",
        ["zhTW"] = "奧杜亞",
    },
    ["Wyrmrest Temple"] = { -- Not really a dungeon but used for the Meeting Stone
        ["enUS"] = true,
        ["deDE"] = "Wyrmruhtempel",
        ["esES"] = "Templo del Reposo del Dragón",
        ["esMX"] = "Templo del Reposo del Dragón",
        ["frFR"] = "Temple du Repos du ver",
        ["koKR"] = "고룡쉼터 사원",
        ["ptBR"] = "Templo do Repouso das Serpes",
        ["ruRU"] = "Храм Драконьего Покоя",
        ["zhCN"] = "龙眠神殿",
        ["zhTW"] = "龍眠神殿",
    },
    ["Vault of Archavon"] = {
        ["enUS"] = true,
        ["deDE"] = "Archavons Kammer",
        ["esES"] = "La Cámara de Archavon",
        ["esMX"] = "La Cámara de Archavon",
        ["frFR"] = "Caveau d'Archavon",
        ["koKR"] = "아카본 석실",
        ["ptBR"] = "Abóbada de Arcavon",
        ["ruRU"] = "Склеп Аркавона",
        ["zhCN"] = "阿尔卡冯的宝库",
        ["zhTW"] = "亞夏梵穹殿",
    },
    ["Argent Tournament"] = { -- Not really a dungeon but used for the Meeting Stone
        ["enUS"] = true,
        ["deDE"] = "Argentumturnierplatz",
        ["esES"] = "Campos del Torneo Argenta",
        ["esMX"] = "Campos del Torneo Argenta",
        ["frFR"] = "Enceinte du tournoi d'Argent",
        ["koKR"] = "은빛십자군 마상시합 광장",
        ["ptBR"] = "Campos do Torneio Argênteo",
        ["ruRU"] = "Ристалище Серебряного турнира",
        ["zhCN"] = "银色比武场",
        ["zhTW"] = "銀白聯賽場地",
    },
    ["Icecrown Citadel"] = {
        ["enUS"] = true,
        ["deDE"] = "Eiskronenzitadelle",
        ["esES"] = "Ciudadela de la Corona de Hielo",
        ["esMX"] = "Ciudadela de la Corona de Hielo",
        ["frFR"] = "Citadelle de la Couronne de glace",
        ["koKR"] = "얼음왕관 성채",
        ["ptBR"] = "Cidadela da Coroa de Gelo",
        ["ruRU"] = "Цитадель Ледяной Короны",
        ["zhCN"] = "冰冠堡垒",
        ["zhTW"] = "冰冠城塞",
    },
    ["The Ruby Sanctum"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Rubinsanktum",
        ["esES"] = "El Sagrario Rubí",
        ["esMX"] = "El Sagrario Rubí",
        ["frFR"] = "Le sanctum Rubis",
        ["koKR"] = "루비 성소",
        ["ptBR"] = "Santuário Rubi",
        ["ruRU"] = "Рубиновое святилище",
        ["zhCN"] = "红玉圣殿",
        ["zhTW"] = "晶紅聖所",
    },
    ["Baradin Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Baradinfestung",
        ["esES"] = "Bastión de Baradin",
        ["esMX"] = "Bastión de Baradin",
        ["frFR"] = "Bastion de Baradin",
        ["koKR"] = "바라딘 요새",
        ["ptBR"] = "Guarnição Baradin",
        ["ruRU"] = "Крепость Барадин",
        ["zhCN"] = "巴拉丁监狱",
        ["zhTW"] = "巴拉丁堡",
    },
    ["The Bastion of Twilight"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Bastion des Zwielichts",
        ["esES"] = "El Bastión del Crepúsculo",
        ["esMX"] = "El Bastión del Crepúsculo",
        ["frFR"] = "Le bastion du Crépuscule",
        ["koKR"] = "황혼의 요새",
        ["ptBR"] = "Bastião do Crepúsculo",
        ["ruRU"] = "Сумеречный бастион",
        ["zhCN"] = "暮光堡垒",
        ["zhTW"] = "暮光堡壘",
    },
    ["Throne of the Four Winds"] = {
        ["enUS"] = true,
        ["deDE"] = "Thron der Vier Winde",
        ["esES"] = "Trono de los Cuatro Vientos",
        ["esMX"] = "Trono de los Cuatro Vientos",
        ["frFR"] = "Trône des quatre vents",
        ["koKR"] = "네 바람의 왕좌",
        ["ptBR"] = "Trono dos Quatro Ventos",
        ["ruRU"] = "Трон Четырех Ветров",
        ["zhCN"] = "风神王座",
        ["zhTW"] = "四風王座",
    },
    ["Firelands"] = {
        ["enUS"] = true,
        ["deDE"] = "Feuerlande",
        ["esES"] = "Tierras de Fuego",
        ["esMX"] = "Tierras de Fuego",
        ["frFR"] = "Terres de Feu",
        ["koKR"] = "불의 땅",
        ["ptBR"] = "Terras do Fogo",
        ["ruRU"] = "Огненные Просторы",
        ["zhCN"] = "火焰之地",
        ["zhTW"] = "火源之界",
    },
    ["Blackwing Descent"] = {
        ["enUS"] = true,
        ["deDE"] = "Pechschwingenabstieg",
        ["esES"] = "Descenso de Alanegra",
        ["esMX"] = "Descenso de Alanegra",
        ["frFR"] = "Descente de l'Aile noire",
        ["koKR"] = "검은날개 강림지",
        ["ptBR"] = "Descenso do Asa Negra",
        ["ruRU"] = "Гнездовье Крыла Тьмы",
        ["zhCN"] = "黑翼血环",
        ["zhTW"] = "黑翼陷窟",
    },
    ["Dragon Soul"] = {
        ["enUS"] = true,
        ["deDE"] = "Drachenseele",
        ["esES"] = "Alma de Dragón",
        ["esMX"] = "Alma de Dragón",
        ["frFR"] = "L'Âme des dragons",
        ["koKR"] = "용의 영혼",
        ["ptBR"] = "Alma Dragônica",
        ["ruRU"] = "Душа Дракона",
        ["zhCN"] = "巨龙之魂",
        ["zhTW"] = "巨龍之魂",
    },
    ["Scarlet Enclave"] = {
        ["enUS"] = true,
        ["deDE"] = "Scharlachrote Enklave",
        ["esES"] = "Enclave Escarlata",
        ["esMX"] = "Enclave Escarlata",
        ["frFR"] = "Enclave Écarlate",
        ["koKR"] = "붉은십자군 초소",
        ["ptBR"] = "Enclave Escarlate",
        ["ruRU"] = "Анклав Алого ордена",
        ["zhCN"] = "血色领地",
        ["zhTW"] = "血色領區",
    },
}

for k, v in pairs(raidLocales) do
    l10n.translations[k] = v
end
