---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local northrendLocales = {
    ["Zul'Drak"] = {
        ["enUS"] = true,
        ["deDE"] = "Zul'Drak",
        ["esES"] = "Zul'Drak",
        ["esMX"] = "Zul'Drak",
        ["frFR"] = "Zul'Drak",
        ["koKR"] = "줄드락",
        ["ptBR"] = "Zul'Drak",
        ["ruRU"] = "Зул'Драк",
        ["zhCN"] = "祖达克",
        ["zhTW"] = "祖爾德拉克",
    },
    ["Grizzly Hills"] = {
        ["enUS"] = true,
        ["deDE"] = "Grizzlyhügel",
        ["esES"] = "Colinas Pardas",
        ["esMX"] = "Colinas Pardas",
        ["frFR"] = "Les Grisonnes",
        ["koKR"] = "회색 구릉지",
        ["ptBR"] = "Serra Gris",
        ["ruRU"] = "Седые холмы",
        ["zhCN"] = "灰熊丘陵",
        ["zhTW"] = "灰白之丘",
    },
    ["Grizzlemaw"] = {
        ["enUS"] = true,
        ["deDE"] = "Grauschlund",
        ["esES"] = "Fauceparda",
        ["esMX"] = "Fauceparda",
        ["frFR"] = "Grisegueule",
        ["koKR"] = "회색구렁 요새",
        ["ptBR"] = "Bocaina Velha",
        ["ruRU"] = "Седая Пасть",
        ["zhCN"] = "灰喉堡",
        ["zhTW"] = "灰喉鎮",
    },
    ["Howling Fjord"] = {
        ["enUS"] = true,
        ["deDE"] = "Der heulende Fjord",
        ["esES"] = "Fiordo Aquilonal",
        ["esMX"] = "Fiordo Aquilonal",
        ["frFR"] = "Fjord Hurlant",
        ["koKR"] = "울부짖는 협만",
        ["ptBR"] = "Fiorde Uivante",
        ["ruRU"] = "Ревущий фьорд",
        ["zhCN"] = "嚎风峡湾",
        ["zhTW"] = "凜風峽灣",
    },
    ["Crystalsong Forest"] = {
        ["enUS"] = true,
        ["deDE"] = "Kristallsangwald",
        ["esES"] = "Bosque Canto de Cristal",
        ["esMX"] = "Bosque Canto de Cristal",
        ["frFR"] = "Forêt du Chant de cristal",
        ["koKR"] = "수정노래 숲",
        ["ptBR"] = "Floresta do Canto Cristalino",
        ["ruRU"] = "Лес Хрустальной Песни",
        ["zhCN"] = "晶歌森林",
        ["zhTW"] = "水晶之歌森林",
    },
    ["The Frozen Sea"] = {
        ["enUS"] = true,
        ["deDE"] = "Die gefrorene See",
        ["esES"] = "El Mar Gélido",
        ["esMX"] = "El Mar Gélido",
        ["frFR"] = "La mer Gelée",
        ["koKR"] = "얼어붙은 바다",
        ["ptBR"] = "Mar Congelado",
        ["ruRU"] = "Ледяное море",
        ["zhCN"] = "冰冻之海",
        ["zhTW"] = "冰凍之海",
    },
    ["Daggercap Bay"] = {
        ["enUS"] = true,
        ["deDE"] = "Dolchbucht",
        ["esES"] = "Bahía Cubredaga",
        ["esMX"] = "Bahía Cubredaga",
        ["frFR"] = "Baie de Coiffedague",
        ["koKR"] = "비수집 만",
        ["ptBR"] = "Baía das Adagas",
        ["ruRU"] = "Бухта Кинжалов",
        ["zhCN"] = "匕鞘湾",
        ["zhTW"] = "匕鞘海灣",
    },
    ["Valgarde"] = {
        ["enUS"] = true,
        ["deDE"] = "Valgarde",
        ["esES"] = "Valgarde",
        ["esMX"] = "Valgarde",
        ["frFR"] = "Valgarde",
        ["koKR"] = "발가드",
        ["ptBR"] = "Valgarde",
        ["ruRU"] = "Валгард",
        ["zhCN"] = "瓦加德",
        ["zhTW"] = "瓦爾加德",
    },
    ["Wyrmskull Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Wyrmskol",
        ["esES"] = "Poblado Calavermis",
        ["esMX"] = "Poblado Calavermis",
        ["frFR"] = "Crâne-du-ver",
        ["koKR"] = "고룡해골 마을",
        ["ptBR"] = "Aldeia Caveira de Dragão",
        ["ruRU"] = "Деревня Драконьего Черепа",
        ["zhCN"] = "龙颅村",
        ["zhTW"] = "龍顱村",
    },
    ["Nifflevar"] = {
        ["enUS"] = true,
        ["deDE"] = "Niffelvar",
        ["esES"] = "Nafsavar",
        ["esMX"] = "Nafsavar",
        ["frFR"] = "Nifflevar",
        ["koKR"] = "니플바르",
        ["ptBR"] = "Niffelvar",
        ["ruRU"] = "Ниффлвар",
        ["zhCN"] = "尼弗莱瓦",
        ["zhTW"] = "尼弗瓦",
    },
    ["Falls of Ymiron"] = {
        ["enUS"] = true,
        ["deDE"] = "Ymironfälle",
        ["esES"] = "Cataratas de Ymiron",
        ["esMX"] = "Cataratas de Ymiron",
        ["frFR"] = "Chutes d'Ymiron",
        ["koKR"] = "이미론의 폭포",
        ["ptBR"] = "Salto de Ymiron",
        ["ruRU"] = "Водопады Имирона",
        ["zhCN"] = "伊米隆瀑布",
        ["zhTW"] = "依米倫瀑布",
    },
    ["Echo Reach"] = {
        ["enUS"] = true,
        ["deDE"] = "Echoweiten",
        ["esES"] = "Risco del Eco",
        ["esMX"] = "Risco del Eco",
        ["frFR"] = "Les confins de l'écho",
        ["koKR"] = "메아리치는 바다",
        ["ptBR"] = "Rincão do Eco",
        ["ruRU"] = "Край Эха",
        ["zhCN"] = "回音海滩",
        ["zhTW"] = "回音之境",
    },
    ["The Isle of Spears"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Insel der Speere",
        ["esES"] = "La Isla de las Lanzas",
        ["esMX"] = "La Isla de las Lanzas",
        ["frFR"] = "L'île des Lances",
        ["koKR"] = "작살잡이 섬",
        ["ptBR"] = "Ilha das Lanças",
        ["ruRU"] = "Остров Копий",
        ["zhCN"] = "长矛岛",
        ["zhTW"] = "群矛之島",
    },
    ["Kamagua"] = {
        ["enUS"] = true,
        ["deDE"] = "Kamagua",
        ["esES"] = "Komawa",
        ["esMX"] = "Komawa",
        ["frFR"] = "Kamagua",
        ["koKR"] = "카마구아",
        ["ptBR"] = "Kamagua",
        ["ruRU"] = "Камагуа",
        ["zhCN"] = "卡玛古",
        ["zhTW"] = "卡瑪廓",
    },
    ["Garvan's Reef"] = {
        ["enUS"] = true,
        ["deDE"] = "Garvans Riff",
        ["esES"] = "Arrecife de Garvan",
        ["esMX"] = "Arrecife de Garvan",
        ["frFR"] = "Récif de Garvan",
        ["koKR"] = "가반의 산호초",
        ["ptBR"] = "Recife Garvan",
        ["ruRU"] = "Риф Гарвана",
        ["zhCN"] = "加维暗礁",
        ["zhTW"] = "加爾文暗礁",
    },
    ["Scalawag Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Halunkeneck",
        ["esES"] = "Cabo Pillastre",
        ["esMX"] = "Cabo Pillastre",
        ["frFR"] = "Cap du Forban",
        ["koKR"] = "해적 야영지",
        ["ptBR"] = "Angra dos Malandros",
        ["ruRU"] = "Лагерь Скалаваг",
        ["zhCN"] = "无赖港",
        ["zhTW"] = "無賴角",
    },
    ["New Agamand"] = {
        ["enUS"] = true,
        ["deDE"] = "Neu-Agamand",
        ["esES"] = "Nuevo Agamand",
        ["esMX"] = "Nuevo Agamand",
        ["frFR"] = "Nouvelle-Agamand",
        ["koKR"] = "신 아가만드",
        ["ptBR"] = "Nova Agamand",
        ["ruRU"] = "Новый Агамонд",
        ["zhCN"] = "新阿加曼德",
        ["zhTW"] = "新阿加曼德",
    },
    ["The Ancient Lift"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Uralte Aufzug",
        ["esES"] = "El Antiguo Elevador",
        ["esMX"] = "El Antiguo Elevador",
        ["frFR"] = "L'antique élévateur",
        ["koKR"] = "고대 승강장",
        ["ptBR"] = "Elevador Ancestral",
        ["ruRU"] = "Древний подъемник",
        ["zhCN"] = "上古升降梯",
        ["zhTW"] = "遠古升降梯",
    },
    ["Westguard Turret"] = {
        ["enUS"] = true,
        ["deDE"] = "Turm der Westwacht",
        ["esES"] = "Torreta de la Guardia Oeste",
        ["esMX"] = "Torreta de la Guardia Oeste",
        ["frFR"] = "Tourelle de la Garde de l'ouest",
        ["koKR"] = "서부경비대 포탑",
        ["ptBR"] = "Torreta da Guarda Oeste",
        ["ruRU"] = "Башня Западной Стражи",
        ["zhCN"] = "西部卫戍要塞塔楼",
        ["zhTW"] = "鎮西砲塔",
    },
    ["Halgrind"] = {
        ["enUS"] = true,
        ["deDE"] = "Halgrind",
        ["esES"] = "Haltorboll",
        ["esMX"] = "Haltorboll",
        ["frFR"] = "Halegrince",
        ["koKR"] = "할그린드",
        ["ptBR"] = "Halgrind",
        ["ruRU"] = "Халгринд",
        ["zhCN"] = "哈尔格林德",
        ["zhTW"] = "霍葛萊",
    },
    ["The Laughing Stand"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Lachende Stützpunkt",
        ["esES"] = "La Playa Rompeolas",
        ["esMX"] = "La Playa Rompeolas",
        ["frFR"] = "La grève Rieuse",
        ["koKR"] = "웃음소리 해안",
        ["ptBR"] = "Ponta Gargalhante",
        ["ruRU"] = "Веселая стоянка",
        ["zhCN"] = "欢笑之台",
        ["zhTW"] = "可笑的看臺",
    },
    ["Baelgun's Excavation Site"] = {
        ["enUS"] = true,
        ["deDE"] = "Baelguns Ausgrabungsstätte",
        ["esES"] = "Excavación de Baelgun",
        ["esMX"] = "Excavación de Baelgun",
        ["frFR"] = "Excavations de Baelgun",
        ["koKR"] = "바엘군의 발굴현장",
        ["ptBR"] = "Sítio de Escavação de Baelgun",
        ["ruRU"] = "Раскопки Бейлгуна",
        ["zhCN"] = "巴尔古挖掘场",
        ["zhTW"] = "巴爾古恩挖掘場",
    },
    ["Explorers' League Outpost"] = {
        ["enUS"] = true,
        ["deDE"] = "Außenposten der Forscherliga",
        ["esES"] = "Avanzada de la Liga de Expedicionarios",
        ["esMX"] = "Avanzada de la Liga de Expedicionarios",
        ["frFR"] = "Avant-poste de la Ligue des explorateurs",
        ["koKR"] = "탐험가 연맹 전초기지",
        ["ptBR"] = "Posto Avançado da Liga dos Exploradores",
        ["ruRU"] = "Лагерь Лиги Исследователей",
        ["zhCN"] = "探险者协会哨站",
        ["zhTW"] = "探險者協會前哨",
    },
    ["Westguard Keep"] = {
        ["enUS"] = true,
        ["deDE"] = "Westwacht",
        ["esES"] = "Fortaleza de la Guardia Oeste",
        ["esMX"] = "Fortaleza de la Guardia Oeste",
        ["frFR"] = "Donjon de la Garde de l'ouest",
        ["koKR"] = "서부경비대 성채",
        ["ptBR"] = "Bastilha da Guarda Oeste",
        ["ruRU"] = "Крепость Западной Стражи",
        ["zhCN"] = "西部卫戍要塞",
        ["zhTW"] = "鎮西要塞",
    },
    ["Steel Gate"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Stählerne Tor",
        ["esES"] = "Las Puertas de Acero",
        ["esMX"] = "Las Puertas de Acero",
        ["frFR"] = "Porte d'acier",
        ["koKR"] = "강철 관문",
        ["ptBR"] = "Portão de Aço",
        ["ruRU"] = "Стальные ворота",
        ["zhCN"] = "钢铁之门",
        ["zhTW"] = "鋼鐵之門",
    },
    ["Vengeance Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Hafen der Vergeltung",
        ["esES"] = "Campo Venganza",
        ["esMX"] = "Campo Venganza",
        ["frFR"] = "Accostage de la Vengeance",
        ["koKR"] = "복수의 상륙지",
        ["ptBR"] = "Porto Vendeta",
        ["ruRU"] = "Лагерь Возмездия",
        ["zhCN"] = "复仇港",
        ["zhTW"] = "復仇臺地",
    },
    ["Baleheim"] = {
        ["enUS"] = true,
        ["deDE"] = "Quälheim",
        ["esES"] = "Baleheim",
        ["esMX"] = "Baleheim",
        ["frFR"] = "Torvheim",
        ["koKR"] = "베일하임",
        ["ptBR"] = "Baleheim",
        ["ruRU"] = "Гибльхейм",
        ["zhCN"] = "拜尔海姆",
        ["zhTW"] = "貝爾海姆",
    },
    ["Skorn"] = {
        ["enUS"] = true,
        ["deDE"] = "Skorn",
        ["esES"] = "Skorn",
        ["esMX"] = "Skorn",
        ["frFR"] = "Mörg",
        ["koKR"] = "스코른",
        ["ptBR"] = "Skorn",
        ["ruRU"] = "Скорн",
        ["zhCN"] = "斯克恩",
        ["zhTW"] = "斯考恩",
    },
    ["Fort Wildervar"] = {
        ["enUS"] = true,
        ["deDE"] = "Fort Wildervar",
        ["esES"] = "Fuerte Vildervar",
        ["esMX"] = "Fuerte Vildervar",
        ["frFR"] = "Fort Hardivar",
        ["koKR"] = "빌더바르 요새",
        ["ptBR"] = "Forte Vildervar",
        ["ruRU"] = "Крепость Вилдервар",
        ["zhCN"] = "维德瓦堡垒",
        ["zhTW"] = "威德瓦堡壘",
    },
    ["Vileprey Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Vil'prajidorf",
        ["esES"] = "Poblado Presavil",
        ["esMX"] = "Poblado Presavil",
        ["frFR"] = "Vileproie",
        ["koKR"] = "썩은수렵 마을",
        ["ptBR"] = "Aldeia Presabjeta",
        ["ruRU"] = "Деревня Жестокой Травли",
        ["zhCN"] = "邪猎村",
        ["zhTW"] = "鄙掠村",
    },
    ["Ivald's Ruin"] = {
        ["enUS"] = true,
        ["deDE"] = "Ivalds Ruine",
        ["esES"] = "Ruinas de Ivald",
        ["esMX"] = "Ruinas de Ivald",
        ["frFR"] = "Ruines d'Ivald",
        ["koKR"] = "이발드의 폐허",
        ["ptBR"] = "Ruína de Ivald",
        ["ruRU"] = "Руины Ивальда",
        ["zhCN"] = "伊瓦尔德废墟",
        ["zhTW"] = "伊瓦德遺跡",
    },
    ["Gjalerbron"] = {
        ["enUS"] = true,
        ["deDE"] = "Gjalerbron",
        ["esES"] = "Gjalerbron",
        ["esMX"] = "Gjalerbron",
        ["frFR"] = "Gjalerbron",
        ["koKR"] = "샬레르브론",
        ["ptBR"] = "Gjalerbron",
        ["ruRU"] = "Гьялерброн",
        ["zhCN"] = "亚勒伯龙",
        ["zhTW"] = "夏勒布隆",
    },
    ["Tomb of the Lost Kings"] = {
        ["enUS"] = true,
        ["deDE"] = "Gruft der verlorenen Könige",
        ["esES"] = "Tumba de los Reyes Perdidos",
        ["esMX"] = "Tumba de los Reyes Perdidos",
        ["frFR"] = "Tombeau des Rois perdus",
        ["koKR"] = "왕의 무덤",
        ["ptBR"] = "Tumba dos Reis Perdidos",
        ["ruRU"] = "Могила Побежденных Королей",
        ["zhCN"] = "失落王者之墓",
        ["zhTW"] = "逝王陵墓",
    },
    ["Camp Winterhoof"] = {
        ["enUS"] = true,
        ["deDE"] = "Lager der Winterhufe",
        ["esES"] = "Campamento Pezuña Invernal",
        ["esMX"] = "Campamento Pezuña Invernal",
        ["frFR"] = "Camp Sabot-d'hiver",
        ["koKR"] = "겨울발굽 야영지",
        ["ptBR"] = "Aldeia Casco Invernal",
        ["ruRU"] = "Лагерь Заиндевевшего Копыта",
        ["zhCN"] = "冬蹄营地",
        ["zhTW"] = "冬蹄營地",
    },
    ["Development Land"] = {
        ["enUS"] = true,
        ["deDE"] = "Entwicklungsland",
        ["esES"] = "Tierra de Desarrollo",
        ["esMX"] = "Tierra de Desarrollo",
        ["frFR"] = "Terrain en développement",
        ["koKR"] = "진화의 대지",
        ["ptBR"] = "Área em Desenvolvimento",
        ["ruRU"] = "Зона разработчика",
        ["zhCN"] = "Development Land",
        ["zhTW"] = "開發之地",
    },
    ["Mightstone Quarry"] = {
        ["enUS"] = true,
        ["deDE"] = "Großfelsbruch",
        ["esES"] = "Cantera de Piedra de Poderío",
        ["esMX"] = "Cantera de Piedra de Poderío",
        ["frFR"] = "Carrière de pierres de pouvoir",
        ["koKR"] = "퇴마석 채석장",
        ["ptBR"] = "Pedreira do Megalito",
        ["ruRU"] = "Карьер Камня Силы",
        ["zhCN"] = "巨石采掘场",
        ["zhTW"] = "力石礦場",
    },
    ["Bloodspore Plains"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutsporenprärie",
        ["esES"] = "Llanuras Sanguiespora",
        ["esMX"] = "Llanuras Sanguiespora",
        ["frFR"] = "Plaines de Spore-sang",
        ["koKR"] = "핏빛포자 평원",
        ["ptBR"] = "Planícies Sanguesporo",
        ["ruRU"] = "Равнины Кровавых Спор",
        ["zhCN"] = "血孢平原",
        ["zhTW"] = "血孢平原",
    },
    ["Gammoth"] = {
        ["enUS"] = true,
        ["deDE"] = "Gammut",
        ["esES"] = "Gammoth",
        ["esMX"] = "Gammoth",
        ["frFR"] = "Gammoth",
        ["koKR"] = "감모스",
        ["ptBR"] = "Gamute",
        ["ruRU"] = "Гаммот",
        ["zhCN"] = "迦莫斯",
        ["zhTW"] = "甘默斯",
    },
    ["Amber Ledge"] = {
        ["enUS"] = true,
        ["deDE"] = "Bernsteinflöz",
        ["esES"] = "El Saliente Ámbar",
        ["esMX"] = "El Saliente Ámbar",
        ["frFR"] = "Escarpement d'Ambre",
        ["koKR"] = "호박석 절벽",
        ["ptBR"] = "Promontório Âmbar",
        ["ruRU"] = "Янтарная гряда",
        ["zhCN"] = "琥珀崖",
        ["zhTW"] = "琥珀岩臺",
    },
    ["Coldarra"] = {
        ["enUS"] = true,
        ["deDE"] = "Kaltarra",
        ["esES"] = "Gelidar",
        ["esMX"] = "Gelidar",
        ["frFR"] = "Frimarra",
        ["koKR"] = "콜다라",
        ["ptBR"] = "Gelarra",
        ["ruRU"] = "Хладарра",
        ["zhCN"] = "考达拉",
        ["zhTW"] = "凜懼島",
    },
    ["The Westrift"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Westklamm",
        ["esES"] = "La Falla Oeste",
        ["esMX"] = "La Falla Oeste",
        ["frFR"] = "La Faille-Ouest",
        ["koKR"] = "서부 균열",
        ["ptBR"] = "Fenda Ocidental",
        ["ruRU"] = "Западная расселина",
        ["zhCN"] = "西部裂谷",
        ["zhTW"] = "西裂峽",
    },
    ["The Transitus Stair"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Transitustreppe",
        ["esES"] = "La Escalera de Tránsito",
        ["esMX"] = "La Escalera de Tránsito",
        ["frFR"] = "L'escalier Transitus",
        ["koKR"] = "변위의 계단",
        ["ptBR"] = "Escada Transitus",
        ["ruRU"] = "Промежуточная лестница",
        ["zhCN"] = "永生之阶",
        ["zhTW"] = "隘境梯臺",
    },
    ["Coast of Echoes"] = {
        ["enUS"] = true,
        ["deDE"] = "Echoküste",
        ["esES"] = "Costa de los Ecos",
        ["esMX"] = "Costa de los Ecos",
        ["frFR"] = "Côte des Échos",
        ["koKR"] = "메아리 해안",
        ["ptBR"] = "Costa do Eco",
        ["ruRU"] = "Берег Эха",
        ["zhCN"] = "回音海岸",
        ["zhTW"] = "回聲海岸",
    },
    ["Riplash Strand"] = {
        ["enUS"] = true,
        ["deDE"] = "Strand der Peitschennarbe",
        ["esES"] = "Litoral Tralladón",
        ["esMX"] = "Litoral Tralladón",
        ["frFR"] = "Grève des Courcinglants",
        ["koKR"] = "채찍파도 해안",
        ["ptBR"] = "Areal Quebramar",
        ["ruRU"] = "Берег Терзающего Бича",
        ["zhCN"] = "裂鞭海岸",
        ["zhTW"] = "裂鞭水岸",
    },
    ["Riplash Ruins"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen der Peitschennarbe",
        ["esES"] = "Ruinas Tralladón",
        ["esMX"] = "Ruinas Tralladón",
        ["frFR"] = "Ruines des Courcinglants",
        ["koKR"] = "채찍파도 폐허",
        ["ptBR"] = "Ruínas Quebramar",
        ["ruRU"] = "Руины Терзающего Бича",
        ["zhCN"] = "裂鞭废墟",
        ["zhTW"] = "裂鞭遺跡",
    },
    ["Coast of Idols"] = {
        ["enUS"] = true,
        ["deDE"] = "Küste der Götzen",
        ["esES"] = "Costa de los Ídolos",
        ["esMX"] = "Costa de los Ídolos",
        ["frFR"] = "Côte des Idoles",
        ["koKR"] = "우상 해안",
        ["ptBR"] = "Costa dos Ídolos",
        ["ruRU"] = "Берег истуканов",
        ["zhCN"] = "巨像海岸",
        ["zhTW"] = "巨像海岸",
    },
    ["Pal'ea"] = {
        ["enUS"] = true,
        ["deDE"] = "Pal'ea",
        ["esES"] = "Pal'ea",
        ["esMX"] = "Pal'ea",
        ["frFR"] = "Pal'ea",
        ["koKR"] = "팔에아",
        ["ptBR"] = "Pal'ea",
        ["ruRU"] = "Пал'иа",
        ["zhCN"] = "帕尔依",
        ["zhTW"] = "帕雷亞",
    },
    ["Valiance Keep"] = {
        ["enUS"] = true,
        ["deDE"] = "Valianzfeste",
        ["esES"] = "Fortaleza Denuedo",
        ["esMX"] = "Fortaleza Denuedo",
        ["frFR"] = "Donjon de la Bravoure",
        ["koKR"] = "용맹의 성채",
        ["ptBR"] = "Bastilha Valentia",
        ["ruRU"] = "Крепость Отваги",
        ["zhCN"] = "无畏要塞",
        ["zhTW"] = "驍勇要塞",
    },
    ["Winterfin Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Dorf der Winterflossen",
        ["esES"] = "Poblado Aleta Invernal",
        ["esMX"] = "Poblado Aleta Invernal",
        ["frFR"] = "Aileron-d'hiver",
        ["koKR"] = "겨울지느러미 마을",
        ["ptBR"] = "Aldeia Falésia Invernal",
        ["ruRU"] = "Деревня Зимних Плавников",
        ["zhCN"] = "冬鳞村",
        ["zhTW"] = "冬鰭村",
    },
    ["Taunka'le Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Taunka'le",
        ["esES"] = "Poblado Taunka'le",
        ["esMX"] = "Poblado Taunka'le",
        ["frFR"] = "Taunka'le",
        ["koKR"] = "타운카르 마을",
        ["ptBR"] = "Aldeia Taunka'le",
        ["ruRU"] = "Деревня Таунка'ле",
        ["zhCN"] = "牦牛村",
        ["zhTW"] = "坦卡雷村",
    },
    ["Magnamoth Caverns"] = {
        ["enUS"] = true,
        ["deDE"] = "Magnamuthöhlen",
        ["esES"] = "Cavernas Magnamoth",
        ["esMX"] = "Cavernas Magnamoth",
        ["frFR"] = "Cavernes de Magnamoth",
        ["koKR"] = "마그나모스 동글",
        ["ptBR"] = "Caverna Magnatraça",
        ["ruRU"] = "Пещеры Магнамух",
        ["zhCN"] = "猛犸人洞穴",
        ["zhTW"] = "瑪格納默斯洞窟",
    },
    ["Coldrock Quarry"] = {
        ["enUS"] = true,
        ["deDE"] = "Froststeinbruch",
        ["esES"] = "Cantera Frioescollo",
        ["esMX"] = "Cantera Frioescollo",
        ["frFR"] = "Carrière de Rochefroide",
        ["koKR"] = "얼음바위 채석장",
        ["ptBR"] = "Pedreira da Rocha Fria",
        ["ruRU"] = "Карьер Ледяного Булыжника",
        ["zhCN"] = "冷石采掘场",
        ["zhTW"] = "冷岩礦場",
    },
    ["Njord's Breath Bay"] = {
        ["enUS"] = true,
        ["deDE"] = "Bucht des Njordatems",
        ["esES"] = "Bahía Aliento de Njord",
        ["esMX"] = "Bahía Aliento de Njord",
        ["frFR"] = "Baie du Souffle de Njord",
        ["koKR"] = "요르드의 숨결 만",
        ["ptBR"] = "Baía do Bafo de Njord",
        ["ruRU"] = "Бухта Дыхания Ньорда",
        ["zhCN"] = "尼约德海湾",
        ["zhTW"] = "尼約德之息海灣",
    },
    ["Kaskala"] = {
        ["enUS"] = true,
        ["deDE"] = "Kaskala",
        ["esES"] = "Kashala",
        ["esMX"] = "Kashala",
        ["frFR"] = "Kaskala",
        ["koKR"] = "카스칼라",
        ["ptBR"] = "Kaskala",
        ["ruRU"] = "Каскала",
        ["zhCN"] = "卡斯卡拉",
        ["zhTW"] = "卡斯卡拉",
    },
    ["Transborea"] = {
        ["enUS"] = true,
        ["deDE"] = "Transborea",
        ["esES"] = "Transborea",
        ["esMX"] = "Transborea",
        ["frFR"] = "Transborée",
        ["koKR"] = "북풍길",
        ["ptBR"] = "Transbórea",
        ["ruRU"] = "Трансборея",
        ["zhCN"] = "横贯冰原",
        ["zhTW"] = "越風之地",
    },
    ["Ember Clutch"] = {
        ["enUS"] = true,
        ["deDE"] = "Glutstätte",
        ["esES"] = "Encierro Ámbar",
        ["esMX"] = "Encierro Ámbar",
        ["frFR"] = "Étreinte de braise",
        ["koKR"] = "잿불의 손아귀",
        ["ptBR"] = "Ninho Incandescente",
        ["ruRU"] = "Пылающее Гнездовье",
        ["zhCN"] = "灰烬龙巢",
        ["zhTW"] = "餘燼窩巢",
    },
    ["Derelict Strand"] = {
        ["enUS"] = true,
        ["deDE"] = "Verlassener Strand",
        ["esES"] = "Playa Derelicta",
        ["esMX"] = "Playa Derelicta",
        ["frFR"] = "Grève des Épaves",
        ["koKR"] = "적막한 해안",
        ["ptBR"] = "Praia do Naufrágio",
        ["ruRU"] = "Обнажившееся дно",
        ["zhCN"] = "荒弃海岸",
        ["zhTW"] = "遺棄水岸",
    },
    ["The Frozen Glade"] = {
        ["enUS"] = true,
        ["deDE"] = "Gefrorene Lichtung",
        ["esES"] = "El Claro Helado",
        ["esMX"] = "El Claro Helado",
        ["frFR"] = "La clairière Gelée",
        ["koKR"] = "얼어붙은 숲",
        ["ptBR"] = "A Clareira Congelada",
        ["ruRU"] = "Заиндевевшая поляна",
        ["zhCN"] = "冰雪林地",
        ["zhTW"] = "冰凍林地",
    },
    ["The Vibrant Glade"] = {
        ["enUS"] = true,
        ["deDE"] = "Lebendige Lichtung",
        ["esES"] = "El Claro Vibrante",
        ["esMX"] = "El Claro Vibrante",
        ["frFR"] = "La clairière Vibrante",
        ["koKR"] = "활력의 숲",
        ["ptBR"] = "Clareira Vibrante",
        ["ruRU"] = "Светлая поляна",
        ["zhCN"] = "活力之林",
        ["zhTW"] = "鮮亮林地",
    },
    ["The Twisted Glade"] = {
        ["enUS"] = true,
        ["deDE"] = "Siechende Lichtung",
        ["esES"] = "El Claro Retorcido",
        ["esMX"] = "El Claro Retorcido",
        ["frFR"] = "La clairière Tordue",
        ["koKR"] = "뒤틀린 숲",
        ["ptBR"] = "Clareira Deformada",
        ["ruRU"] = "Холмистая поляна",
        ["zhCN"] = "扭曲之林",
        ["zhTW"] = "扭曲林地",
    },
    ["Rivenwood"] = {
        ["enUS"] = true,
        ["deDE"] = "Bruchwald",
        ["esES"] = "El Bosque Hendido",
        ["esMX"] = "El Bosque Hendido",
        ["frFR"] = "Clivebois",
        ["koKR"] = "비틀린 숲",
        ["ptBR"] = "Bosque Fendido",
        ["ruRU"] = "Вырубки",
        ["zhCN"] = "裂木森林",
        ["zhTW"] = "裂木森林",
    },
    ["Caldemere Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Kaldemaarsee",
        ["esES"] = "Lago Caldemere",
        ["esMX"] = "Lago Caldemere",
        ["frFR"] = "Lac Caldemere",
        ["koKR"] = "칼더미어 호수",
        ["ptBR"] = "Lago Caldemere",
        ["ruRU"] = "Озеро Холдомир",
        ["zhCN"] = "凯德米尔湖",
        ["zhTW"] = "凱德米爾湖",
    },
    ["Utgarde Catacombs"] = {
        ["enUS"] = true,
        ["deDE"] = "Katakomben von Utgarde",
        ["esES"] = "Catacumbas de Utgarde",
        ["esMX"] = "Catacumbas de Utgarde",
        ["frFR"] = "Catacombes d'Utgarde",
        ["koKR"] = "우트가드 지하묘지",
        ["ptBR"] = "Catacumbas de Utgarde",
        ["ruRU"] = "Катакомбы Утгард",
        ["zhCN"] = "乌特加德墓穴",
        ["zhTW"] = "俄特加德墓窖",
    },
    ["Shield Hill"] = {
        ["enUS"] = true,
        ["deDE"] = "Schildhügel",
        ["esES"] = "Colina Escudo",
        ["esMX"] = "Colina Escudo",
        ["frFR"] = "Colline du Bouclier",
        ["koKR"] = "방패 언덕",
        ["ptBR"] = "Monte Égide",
        ["ruRU"] = "Заградительный холм",
        ["zhCN"] = "盾牌岭",
        ["zhTW"] = "盾丘",
    },
    ["Lake Cauldros"] = {
        ["enUS"] = true,
        ["deDE"] = "Kaldrossee",
        ["esES"] = "Lago Caldros",
        ["esMX"] = "Lago Caldros",
        ["frFR"] = "Lac Calderos",
        ["koKR"] = "카울드로스 호수",
        ["ptBR"] = "Lago Cauldros",
        ["ruRU"] = "Озеро Колдрос",
        ["zhCN"] = "考杜斯湖",
        ["zhTW"] = "科德洛斯湖",
    },
    ["Cauldros Isle"] = {
        ["enUS"] = true,
        ["deDE"] = "Kaldrosinsel",
        ["esES"] = "Isla Caldros",
        ["esMX"] = "Isla Caldros",
        ["frFR"] = "Île Calderos",
        ["koKR"] = "카울드로스 섬",
        ["ptBR"] = "Ilha Cauldros",
        ["ruRU"] = "Остров Колдрос",
        ["zhCN"] = "考杜斯岛",
        ["zhTW"] = "科德洛斯島",
    },
    ["Bleeding Vale"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutklamm",
        ["esES"] = "Vega Sangrante",
        ["esMX"] = "Vega Sangrante",
        ["frFR"] = "Val Sanglant",
        ["koKR"] = "피투성이 계곡",
        ["ptBR"] = "Vale Sangrento",
        ["ruRU"] = "Кровоточащая долина",
        ["zhCN"] = "鲜血谷",
        ["zhTW"] = "浴血谷",
    },
    ["Giants' Run"] = {
        ["enUS"] = true,
        ["deDE"] = "Plateau der Riesen",
        ["esES"] = "El Paso del Gigante",
        ["esMX"] = "El Paso del Gigante",
        ["frFR"] = "La piste des Géants",
        ["koKR"] = "거인의 터",
        ["ptBR"] = "Passo do Gigante",
        ["ruRU"] = "Тропа Великанов",
        ["zhCN"] = "巨人平原",
        ["zhTW"] = "巨人小徑",
    },
    ["Apothecary Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Apothekerlager",
        ["esES"] = "Campamento de los Boticarios",
        ["esMX"] = "Campamento de los Boticarios",
        ["frFR"] = "Camp des Apothicaires",
        ["koKR"] = "연금술사 야영지",
        ["ptBR"] = "Acampamento da Sociedade dos Boticários",
        ["ruRU"] = "Аптекарский поселок",
        ["zhCN"] = "药剂师营地",
        ["zhTW"] = "藥劑師營地",
    },
    ["Ember Spear Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Glutspeerturm",
        ["esES"] = "Torre Lanza Ámbar",
        ["esMX"] = "Torre Lanza Ámbar",
        ["frFR"] = "Tour de la Lance de braise",
        ["koKR"] = "잿불창 경비탑",
        ["ptBR"] = "Torre da Lança Incandescente",
        ["ruRU"] = "Тлеющая башня",
        ["zhCN"] = "灰烬长矛塔楼",
        ["zhTW"] = "餘燼矛塔",
    },
    ["Shattered Straits"] = {
        ["enUS"] = true,
        ["deDE"] = "Straße der Trümmer",
        ["esES"] = "Estrecho Devastado",
        ["esMX"] = "Estrecho Devastado",
        ["frFR"] = "Les détroits Fracassés",
        ["koKR"] = "부서진 해협",
        ["ptBR"] = "Estreito dos Estilhaços",
        ["ruRU"] = "Пролив Кораблекрушений",
        ["zhCN"] = "碎裂海峡",
        ["zhTW"] = "破碎海峽",
    },
    ["Gjalerhorn"] = {
        ["enUS"] = true,
        ["deDE"] = "Gjalerhorn",
        ["esES"] = "Gjalercorn",
        ["esMX"] = "Gjalercorn",
        ["frFR"] = "Gjalercorne",
        ["koKR"] = "샬레르호른",
        ["ptBR"] = "Gjalehorn",
        ["ruRU"] = "Гьялерхорн",
        ["zhCN"] = "亚勒霍恩",
        ["zhTW"] = "夏勒宏恩",
    },
    ["Frostblade Peak"] = {
        ["enUS"] = true,
        ["deDE"] = "Frostklingengipfel",
        ["esES"] = "Pico Filoescarcha",
        ["esMX"] = "Pico Filoescarcha",
        ["frFR"] = "Pic de Givrelame",
        ["koKR"] = "서릿날 봉우리",
        ["ptBR"] = "Pico de Cunhalva",
        ["ruRU"] = "Вершина Ледяного Клинка",
        ["zhCN"] = "霜刃峰",
        ["zhTW"] = "霜刃峰",
    },
    ["West Spear Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Westspeerturm",
        ["esES"] = "Torre Lanza del Oeste",
        ["esMX"] = "Torre Lanza del Oeste",
        ["frFR"] = "Tour de la Lance de l'ouest",
        ["koKR"] = "서부창 경비탑",
        ["ptBR"] = "Torre da Lança Oeste",
        ["ruRU"] = "Западная башня",
        ["zhCN"] = "西部长矛塔楼",
        ["zhTW"] = "西矛哨塔",
    },
    ["North Spear Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Nordspeerturm",
        ["esES"] = "Torre Lanza del Norte",
        ["esMX"] = "Torre Lanza del Norte",
        ["frFR"] = "Tour de la Lance du nord",
        ["koKR"] = "북부창 경비탑",
        ["ptBR"] = "Torre da Lança Norte",
        ["ruRU"] = "Северная башня",
        ["zhCN"] = "北部长矛塔楼",
        ["zhTW"] = "北矛哨塔",
    },
    ["Chillmere Coast"] = {
        ["enUS"] = true,
        ["deDE"] = "Küste des Frostmaares",
        ["esES"] = "Costafría",
        ["esMX"] = "Costafría",
        ["frFR"] = "Côte de Frissonde",
        ["koKR"] = "서릿발 해안",
        ["ptBR"] = "Costa da Água Fria",
        ["ruRU"] = "Берег Стылой Межи",
        ["zhCN"] = "切米尔海岸",
        ["zhTW"] = "寒凜海岸",
    },
    ["Whisper Gulch"] = {
        ["enUS"] = true,
        ["deDE"] = "Flüsterschlucht",
        ["esES"] = "Garganta Susurro",
        ["esMX"] = "Garganta Susurro",
        ["frFR"] = "Goulet des Murmures",
        ["koKR"] = "속삭임 협곡",
        ["ptBR"] = "Desfiladeiro dos Sussurros",
        ["ruRU"] = "Шепчущая теснина",
        ["zhCN"] = "低语峡谷",
        ["zhTW"] = "低語峽谷",
    },
    ["Sub zone"] = {
        ["enUS"] = true,
        ["deDE"] = "Subzone",
        ["esES"] = "Subzona",
        ["esMX"] = "Subzona",
        ["frFR"] = "Sous-zone",
        ["koKR"] = "세부 지역",
        ["ptBR"] = "Subárea",
        ["ruRU"] = "Sub zone",
        ["zhCN"] = "Sub zone",
        ["zhTW"] = "子區域",
    },
    ["Winter's Terrace"] = {
        ["enUS"] = true,
        ["deDE"] = "Terrasse des Winters",
        ["esES"] = "Bancal del Invierno",
        ["esMX"] = "Bancal del Invierno",
        ["frFR"] = "Terrasse de l'Hiver",
        ["koKR"] = "겨울 단상",
        ["ptBR"] = "Terraço do Inverno",
        ["ruRU"] = "Зимняя терраса",
        ["zhCN"] = "寒冬大厅",
        ["zhTW"] = "冬之殿堂",
    },
    ["The Waking Halls"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Hallen des Erwachens",
        ["esES"] = "Las Salas del Despertar",
        ["esMX"] = "Las Salas del Despertar",
        ["frFR"] = "Les salles de l'Éveil",
        ["koKR"] = "각성의 전당",
        ["ptBR"] = "Salões do Despertar",
        ["ruRU"] = "Чертоги Пробуждения",
        ["zhCN"] = "苏醒之厅",
        ["zhTW"] = "喚醒之廳",
    },
    ["Sorlof's Strand"] = {
        ["enUS"] = true,
        ["deDE"] = "Sorlofs Strand",
        ["esES"] = "Playa de Sorlof",
        ["esMX"] = "Playa de Sorlof",
        ["frFR"] = "La grève de Sorlof",
        ["koKR"] = "소를로프의 해안",
        ["ptBR"] = "Praia de Sorlof",
        ["ruRU"] = "Берег Сорлофа",
        ["zhCN"] = "索罗夫海岸",
        ["zhTW"] = "索洛夫水岸",
    },
    ["Frostblade Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Frostklingenpass",
        ["esES"] = "Paso Filoescarcha",
        ["esMX"] = "Paso Filoescarcha",
        ["frFR"] = "Passe de Givrelame",
        ["koKR"] = "서릿날 고개",
        ["ptBR"] = "Desfiladeiro de Cunhalva",
        ["ruRU"] = "Перевал Ледяного Клинка",
        ["zhCN"] = "霜刃小径",
        ["zhTW"] = "霜刃隘口",
    },
    ["Claytön's WoWEdit Land"] = {
        ["enUS"] = true,
        ["deDE"] = "Claytön's WoWEdit Land",
        ["esES"] = "Claytön's WoWEdit Land",
        ["esMX"] = "Claytön's WoWEdit Land",
        ["frFR"] = "Claytön's WoWEdit Land",
        ["koKR"] = "클레이튼의 섬",
        ["ptBR"] = "Terra do WoWEdit do Claytön",
        ["ruRU"] = "Clayton's WoWEdit Land",
        ["zhCN"] = "Clayton's WoWEdit Land",
        ["zhTW"] = "克雷頓的WoW編輯地",
    },
    ["Winterfin Caverns"] = {
        ["enUS"] = true,
        ["deDE"] = "Höhlen der Winterflossen",
        ["esES"] = "Cavernas Aleta Invernal",
        ["esMX"] = "Cavernas Aleta Invernal",
        ["frFR"] = "Cavernes des Ailerons-d'hiver",
        ["koKR"] = "겨울지느러미 동굴",
        ["ptBR"] = "Caverna Falésia Invernal",
        ["ruRU"] = "Пещеры Зимних Плавников",
        ["zhCN"] = "冬鳞洞穴",
        ["zhTW"] = "冬鰭洞窟",
    },
    ["Glimmer Bay"] = {
        ["enUS"] = true,
        ["deDE"] = "Glimmerbucht",
        ["esES"] = "Bahía Titileo",
        ["esMX"] = "Bahía Titileo",
        ["frFR"] = "Baie Scintillante",
        ["koKR"] = "깜박임 만",
        ["ptBR"] = "Baía Tremeluzente",
        ["ruRU"] = "Мерцающая бухта",
        ["zhCN"] = "幽光海湾",
        ["zhTW"] = "微光海灣",
    },
    ["Winterfin Retreat"] = {
        ["enUS"] = true,
        ["deDE"] = "Zuflucht der Winterflossen",
        ["esES"] = "Refugio Aleta Invernal",
        ["esMX"] = "Refugio Aleta Invernal",
        ["frFR"] = "Retraite des Ailerons-d'hiver",
        ["koKR"] = "겨울지느러미 은신처",
        ["ptBR"] = "Retiro da Falésia Invernal",
        ["ruRU"] = "Приют Зимних Плавников",
        ["zhCN"] = "冬鳞避难所",
        ["zhTW"] = "冬鰭避居地",
    },
    ["The Culling of Stratholme"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Ausmerzen von Stratholme",
        ["esES"] = "La Matanza de Stratholme",
        ["esMX"] = "La Matanza de Stratholme",
        ["frFR"] = "L'Épuration de Stratholme",
        ["koKR"] = "옛 스트라솔름",
        ["ptBR"] = "Expurgo de Stratholme",
        ["ruRU"] = "Очищение Стратхольма",
        ["zhCN"] = "净化斯坦索姆",
        ["zhTW"] = "斯坦索姆的抉擇",
    },
    ["Sands of Nasam"] = {
        ["enUS"] = true,
        ["deDE"] = "Sande von Nasam",
        ["esES"] = "Arenas de Nasam",
        ["esMX"] = "Arenas de Nasam",
        ["frFR"] = "Sables de Nasam",
        ["koKR"] = "나삼의 갯벌",
        ["ptBR"] = "Areias de Nasam",
        ["ruRU"] = "Пески Назама",
        ["zhCN"] = "纳萨姆沙地",
        ["zhTW"] = "納森沙地",
    },
    ["Krom's Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Kroms Landeplatz",
        ["esES"] = "Puerto de Krom",
        ["esMX"] = "Puerto de Krom",
        ["frFR"] = "Point d'ancrage de Krom",
        ["koKR"] = "크롬의 정박지",
        ["ptBR"] = "Porto de Krom",
        ["ruRU"] = "Лагерь Крома",
        ["zhCN"] = "克罗姆的码头",
        ["zhTW"] = "克羅姆臺地",
    },
    ["Nasam's Talon"] = {
        ["enUS"] = true,
        ["deDE"] = "Nasams Klaue",
        ["esES"] = "Garfa de Nasam",
        ["esMX"] = "Garfa de Nasam",
        ["frFR"] = "La serre de Nasam",
        ["koKR"] = "나삼의 발톱",
        ["ptBR"] = "Garra de Nasam",
        ["ruRU"] = "Коготь Назама",
        ["zhCN"] = "纳萨姆之爪",
        ["zhTW"] = "納森之爪",
    },
    ["Echo Cove"] = {
        ["enUS"] = true,
        ["deDE"] = "Echobucht",
        ["esES"] = "Cala del Eco",
        ["esMX"] = "Cala del Eco",
        ["frFR"] = "Crique de l'Écho",
        ["koKR"] = "메아리 동굴",
        ["ptBR"] = "Angra do Eco",
        ["ruRU"] = "Бухта Эха",
        ["zhCN"] = "回音湾",
        ["zhTW"] = "回音灣",
    },
    ["Beryl Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Beryllspitze",
        ["esES"] = "Alto de Berilo",
        ["esMX"] = "Alto de Berilo",
        ["frFR"] = "Halte de Béryl",
        ["koKR"] = "녹주석 거점",
        ["ptBR"] = "Penhasco de Berília",
        ["ruRU"] = "Берилловый лагерь",
        ["zhCN"] = "蓝玉营地",
        ["zhTW"] = "碧晶哨點",
    },
    ["Garrosh's Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Garroshs Landeplatz",
        ["esES"] = "Desembarco de Garrosh",
        ["esMX"] = "Desembarco de Garrosh",
        ["frFR"] = "Point d'accostage de Garrosh",
        ["koKR"] = "가로쉬의 상륙지",
        ["ptBR"] = "Ancoradouro de Garrosh",
        ["ruRU"] = "Лагерь Гарроша",
        ["zhCN"] = "加尔鲁什码头",
        ["zhTW"] = "卡爾洛斯臺地",
    },
    ["Warsong Jetty"] = {
        ["enUS"] = true,
        ["deDE"] = "Landebrücke des Kriegshymnenklans",
        ["esES"] = "Malecón Grito de Guerra",
        ["esMX"] = "Malecón Grito de Guerra",
        ["frFR"] = "Jetée chanteguerre",
        ["koKR"] = "전쟁노래부족 부두",
        ["ptBR"] = "Quebra-mar Brado Guerreiro",
        ["ruRU"] = "Пристань Песни Войны",
        ["zhCN"] = "战歌防波堤",
        ["zhTW"] = "戰歌碼頭",
    },
    ["Fizzcrank Airstrip"] = {
        ["enUS"] = true,
        ["deDE"] = "Landebahn Kurbelzisch",
        ["esES"] = "Pista de Aterrizaje de Palanqueta",
        ["esMX"] = "Pista de Aterrizaje de Palanqueta",
        ["frFR"] = "Piste d'atterrissage de Spumelevier",
        ["koKR"] = "피즈크랭크 비행장",
        ["ptBR"] = "Pista de Pouso do Biela",
        ["ruRU"] = "Взлетная полоса Выкрутеня",
        ["zhCN"] = "菲兹兰克机场",
        ["zhTW"] = "嘶軸簡易機場",
    },
    ["Lake Kum'uya"] = {
        ["enUS"] = true,
        ["deDE"] = "Kum'uyasee",
        ["esES"] = "Lago Kum'uya",
        ["esMX"] = "Lago Kum'uya",
        ["frFR"] = "Lac Kum'uya",
        ["koKR"] = "쿰우야 호수",
        ["ptBR"] = "Lago Kum'uya",
        ["ruRU"] = "Озеро Кум'уа",
        ["zhCN"] = "库姆亚湖",
        ["zhTW"] = "庫姆亞湖",
    },
    ["Farshire Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Weiden von Fernhain",
        ["esES"] = "Campos de Lindeallá",
        ["esMX"] = "Campos de Lindeallá",
        ["frFR"] = "Champs de Comté-lointaine",
        ["koKR"] = "파샤이어 농장",
        ["ptBR"] = "Campos de Algures",
        ["ruRU"] = "Поля Далечья",
        ["zhCN"] = "致远郡农场",
        ["zhTW"] = "遠郡原野",
    },
    ["Farshire"] = {
        ["enUS"] = true,
        ["deDE"] = "Fernhain",
        ["esES"] = "Lindeallá",
        ["esMX"] = "Lindeallá",
        ["frFR"] = "Comté-lointaine",
        ["koKR"] = "파샤이어",
        ["ptBR"] = "Algures",
        ["ruRU"] = "Далечье",
        ["zhCN"] = "致远郡",
        ["zhTW"] = "遠郡",
    },
    ["Farshire Lighthouse"] = {
        ["enUS"] = true,
        ["deDE"] = "Leuchtturm von Fernhain",
        ["esES"] = "Faro de Lindeallá",
        ["esMX"] = "Faro de Lindeallá",
        ["frFR"] = "Phare de Comté-lointaine",
        ["koKR"] = "파샤이어 등대",
        ["ptBR"] = "Farol de Algures",
        ["ruRU"] = "Маяк Далечья",
        ["zhCN"] = "致远郡灯塔",
        ["zhTW"] = "遠郡燈塔",
    },
    ["Unu'pe"] = {
        ["enUS"] = true,
        ["deDE"] = "Unu'pe",
        ["esES"] = "Unu'pe",
        ["esMX"] = "Unu'pe",
        ["frFR"] = "Unu'pe",
        ["koKR"] = "우누페",
        ["ptBR"] = "Unu'pe",
        ["ruRU"] = "Уну'пе",
        ["zhCN"] = "乌努比",
        ["zhTW"] = "昂紐沛",
    },
    ["Death's Stand"] = {
        ["enUS"] = true,
        ["deDE"] = "Todeswehr",
        ["esES"] = "Confín de la Muerte",
        ["esMX"] = "Confín de la Muerte",
        ["frFR"] = "Le séjour de la Mort",
        ["koKR"] = "죽음의 언덕",
        ["ptBR"] = "Campo da Morte",
        ["ruRU"] = "Стоянка Смерти",
        ["zhCN"] = "死亡营地",
        ["zhTW"] = "死亡看臺",
    },
    ["The Abandoned Reach"] = {
        ["enUS"] = true,
        ["deDE"] = "Die verlassenen Weiten",
        ["esES"] = "El Tramo Abandonado",
        ["esMX"] = "El Tramo Abandonado",
        ["frFR"] = "Les confins Abandonnés",
        ["koKR"] = "버려진 해안",
        ["ptBR"] = "Os Confins Abandonados",
        ["ruRU"] = "Покинутый предел",
        ["zhCN"] = "遗弃海岸",
        ["zhTW"] = "被遺棄之境",
    },
    ["Scalding Pools"] = {
        ["enUS"] = true,
        ["deDE"] = "Siedende Teiche",
        ["esES"] = "Pozas Escaldantes",
        ["esMX"] = "Pozas Escaldantes",
        ["frFR"] = "Bassins Brûlants",
        ["koKR"] = "끓어오르는 웅덩이",
        ["ptBR"] = "Lagos Escaldantes",
        ["ruRU"] = "Жгучие пруды",
        ["zhCN"] = "滚烫熔池",
        ["zhTW"] = "沸水之池",
    },
    ["Transitus Shield"] = {
        ["enUS"] = true,
        ["deDE"] = "Transitusschild",
        ["esES"] = "Escudo de Tránsito",
        ["esMX"] = "Escudo de Tránsito",
        ["frFR"] = "Bouclier Transitus",
        ["koKR"] = "변위의 보호막",
        ["ptBR"] = "Escudo de Transitus",
        ["ruRU"] = "Маскировочный щит",
        ["zhCN"] = "永生之盾",
        ["zhTW"] = "隘境之盾",
    },
    ["Bor'gorok Outpost"] = {
        ["enUS"] = true,
        ["deDE"] = "Außenposten Bor'gorok",
        ["esES"] = "Avanzada Bor'gorok",
        ["esMX"] = "Avanzada Bor'gorok",
        ["frFR"] = "Avant-poste de Bor'gorok",
        ["koKR"] = "보르고로크 전초기지",
        ["ptBR"] = "Posto Avançado Bor'gorok",
        ["ruRU"] = "Застава Бор'горока",
        ["zhCN"] = "博古洛克前哨站",
        ["zhTW"] = "博格洛克前哨",
    },
    ["Magmoth"] = {
        ["enUS"] = true,
        ["deDE"] = "Magmut",
        ["esES"] = "Magmoth",
        ["esMX"] = "Magmoth",
        ["frFR"] = "Magmoth",
        ["koKR"] = "마그모스",
        ["ptBR"] = "Magmute",
        ["ruRU"] = "Магмот",
        ["zhCN"] = "犸格莫斯",
        ["zhTW"] = "瑪格默斯",
    },
    ["The Dens of Dying"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Höhlen des Todes",
        ["esES"] = "Los Cubiles de los Moribundos",
        ["esMX"] = "Los Cubiles de los Moribundos",
        ["frFR"] = "Les tanières du Trépas",
        ["koKR"] = "사자의 동굴",
        ["ptBR"] = "Tocas da Morte",
        ["ruRU"] = "Кельи Смерти",
        ["zhCN"] = "亡者之穴",
        ["zhTW"] = "垂死獸穴",
    },
    ["Temple City of En'kilah"] = {
        ["enUS"] = true,
        ["deDE"] = "Tempelstadt En'kilah",
        ["esES"] = "Ciudad Templo de En'kilah",
        ["esMX"] = "Ciudad Templo de En'kilah",
        ["frFR"] = "Ville-temple d'En'kilah",
        ["koKR"] = "엔킬라 사원",
        ["ptBR"] = "Cidade-templo de En'kilah",
        ["ruRU"] = "Храмовый город Эн'кила",
        ["zhCN"] = "圣城恩其拉",
        ["zhTW"] = "恩吉拉聖城",
    },
    ["The Wailing Ziggurat"] = {
        ["enUS"] = true,
        ["deDE"] = "Die klagende Ziggurat",
        ["esES"] = "El Zigurat de los Lamentos",
        ["esMX"] = "El Zigurat de los Lamentos",
        ["frFR"] = "La ziggourat Gémissante",
        ["koKR"] = "통곡의 지구라트",
        ["ptBR"] = "Zigurate dos Lamentos",
        ["ruRU"] = "Стонущий зиккурат",
        ["zhCN"] = "悲叹通灵塔",
        ["zhTW"] = "悲嘯通靈塔",
    },
    ["Steeljaw's Caravan"] = {
        ["enUS"] = true,
        ["deDE"] = "Stahlkiefers Karawane",
        ["esES"] = "Caravana de Quijacero",
        ["esMX"] = "Caravana de Quijacero",
        ["frFR"] = "Caravane de Mâchoire-d'acier",
        ["koKR"] = "스틸조의 짐마차",
        ["ptBR"] = "Caravana do Queixoduro",
        ["ruRU"] = "Караван Стальной Челюсти",
        ["zhCN"] = "钢腭的车队",
        ["zhTW"] = "鋼顎商隊",
    },
    ["Naxxanar"] = {
        ["enUS"] = true,
        ["deDE"] = "Naxxanar",
        ["esES"] = "Naxxanar",
        ["esMX"] = "Naxxanar",
        ["frFR"] = "Naxxanar",
        ["koKR"] = "낙사나르",
        ["ptBR"] = "Naxxanar",
        ["ruRU"] = "Наксанар",
        ["zhCN"] = "纳克萨纳尔",
        ["zhTW"] = "納克薩爾",
    },
    ["Warsong Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Kriegshymnenfeste",
        ["esES"] = "Bastión Grito de Guerra",
        ["esMX"] = "Bastión Grito de Guerra",
        ["frFR"] = "Bastion Chanteguerre",
        ["koKR"] = "전쟁노래부족 요새",
        ["ptBR"] = "Fortaleza Brado Guerreiro",
        ["ruRU"] = "Крепость Песни Войны",
        ["zhCN"] = "战歌要塞",
        ["zhTW"] = "戰歌堡",
    },
    ["Plains of Nasam"] = {
        ["enUS"] = true,
        ["deDE"] = "Ebene von Nasam",
        ["esES"] = "Llanuras de Nasam",
        ["esMX"] = "Llanuras de Nasam",
        ["frFR"] = "Les plaines de Nasam",
        ["koKR"] = "나삼의 평원",
        ["ptBR"] = "Planícies de Nasam",
        ["ruRU"] = "Равнины Назама",
        ["zhCN"] = "纳萨姆平原",
        ["zhTW"] = "納森平原",
    },
    ["Ruins of Eldra'nath"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Eldra'nath",
        ["esES"] = "Ruinas de Eldra'nath",
        ["esMX"] = "Ruinas de Eldra'nath",
        ["frFR"] = "Ruines d'Eldra'nath",
        ["koKR"] = "엘드라나스 폐허",
        ["ptBR"] = "Ruínas de Eldra'nath",
        ["ruRU"] = "Руины Элдра'ната",
        ["zhCN"] = "埃德拉纳斯废墟",
        ["zhTW"] = "艾卓納斯遺跡",
    },
    ["Charred Rise"] = {
        ["enUS"] = true,
        ["deDE"] = "Kohlschwarze Anhöhe",
        ["esES"] = "Alto Carbonizado",
        ["esMX"] = "Alto Carbonizado",
        ["frFR"] = "Cime Calcinée",
        ["koKR"] = "잿더미 마루",
        ["ptBR"] = "Alto Calcinado",
        ["ruRU"] = "Обугленная вершина",
        ["zhCN"] = "焦土高地",
        ["zhTW"] = "焦炭高崗",
    },
    ["Blistering Pool"] = {
        ["enUS"] = true,
        ["deDE"] = "Kochender Teich",
        ["esES"] = "Poza Virulenta",
        ["esMX"] = "Poza Virulenta",
        ["frFR"] = "Bassin Caustique",
        ["koKR"] = "부글거리는 웅덩이",
        ["ptBR"] = "Poço Virulento",
        ["ruRU"] = "Кипящий пруд",
        ["zhCN"] = "毒泡水池",
        ["zhTW"] = "極熱之池",
    },
    ["Frozen Reach"] = {
        ["enUS"] = true,
        ["deDE"] = "Die gefrorenen Weiten",
        ["esES"] = "Tramo Helado",
        ["esMX"] = "Tramo Helado",
        ["frFR"] = "Les confins Gelés",
        ["koKR"] = "얼어붙은 해안",
        ["ptBR"] = "Confins Glaciais",
        ["ruRU"] = "Студеный предел",
        ["zhCN"] = "冰冻平原",
        ["zhTW"] = "冰凍之境",
    },
    ["Torp's Farm"] = {
        ["enUS"] = true,
        ["deDE"] = "Torps Bauernhof",
        ["esES"] = "Granja de Torp",
        ["esMX"] = "Granja de Torp",
        ["frFR"] = "Ferme de Torp",
        ["koKR"] = "토르프의 농장",
        ["ptBR"] = "Fazenda dos Torp",
        ["ruRU"] = "Ферма Торпа",
        ["zhCN"] = "托普的农场",
        ["zhTW"] = "托普的農場",
    },
    ["Warsong Granary"] = {
        ["enUS"] = true,
        ["deDE"] = "Kornkammer des Kriegshymnenklans",
        ["esES"] = "Granero Grito de Guerra",
        ["esMX"] = "Granero Grito de Guerra",
        ["frFR"] = "Grenier chanteguerre",
        ["koKR"] = "전쟁노래부족 곡물창고",
        ["ptBR"] = "Celeiro Brado Guerreiro",
        ["ruRU"] = "Амбар Песни Войны",
        ["zhCN"] = "战歌粮仓",
        ["zhTW"] = "戰歌穀倉",
    },
    ["Warsong Slaughterhouse"] = {
        ["enUS"] = true,
        ["deDE"] = "Schlachthof des Kriegshymnenklans",
        ["esES"] = "Matadero Grito de Guerra",
        ["esMX"] = "Matadero Grito de Guerra",
        ["frFR"] = "Abattoir chanteguerre",
        ["koKR"] = "전쟁노래부족 도살장",
        ["ptBR"] = "Matadouro Brado Guerreiro",
        ["ruRU"] = "Скотобойня Песни Войны",
        ["zhCN"] = "战歌屠宰场",
        ["zhTW"] = "戰歌屠宰場",
    },
    ["Warsong Farms Outpost"] = {
        ["enUS"] = true,
        ["deDE"] = "Höfe des Kriegshymnenklans",
        ["esES"] = "Avanzada de las Granjas Grito de Guerra",
        ["esMX"] = "Avanzada de las Granjas Grito de Guerra",
        ["frFR"] = "Avant-poste des fermes chanteguerres",
        ["koKR"] = "전쟁노래부족 농장 전진기지",
        ["ptBR"] = "Acampamento das Fazendas Brado Guerreiro",
        ["ruRU"] = "Застава у ферм Песни войны",
        ["zhCN"] = "战歌农场哨站",
        ["zhTW"] = "戰歌農場前哨",
    },
    ["West Point Station"] = {
        ["enUS"] = true,
        ["deDE"] = "Weststation",
        ["esES"] = "Estación de la Punta Oeste",
        ["esMX"] = "Estación de la Punta Oeste",
        ["frFR"] = "Poste de la Halte de l'ouest",
        ["koKR"] = "서부 거점",
        ["ptBR"] = "Estação Oeste",
        ["ruRU"] = "Западная станция",
        ["zhCN"] = "西部哨站",
        ["zhTW"] = "西點抽水站",
    },
    ["Mid Point Station"] = {
        ["enUS"] = true,
        ["deDE"] = "Zentralstation",
        ["esES"] = "Estación de la Punta Central",
        ["esMX"] = "Estación de la Punta Central",
        ["frFR"] = "Poste de la Halte du centre",
        ["koKR"] = "중부 거점",
        ["ptBR"] = "Estação Central",
        ["ruRU"] = "Центральная станция",
        ["zhCN"] = "中部哨站",
        ["zhTW"] = "中點抽水站",
    },
    ["South Point Station"] = {
        ["enUS"] = true,
        ["deDE"] = "Südstation",
        ["esES"] = "Estación de la Punta Sur",
        ["esMX"] = "Estación de la Punta Sur",
        ["frFR"] = "Poste de la Halte du sud",
        ["koKR"] = "남부 거점",
        ["ptBR"] = "Estação Sul",
        ["ruRU"] = "Южная станция",
        ["zhCN"] = "南部哨站",
        ["zhTW"] = "南點抽水站",
    },
    ["D.E.H.T.A. Encampment"] = {
        ["enUS"] = true,
        ["deDE"] = "Lager der D.E.H.T.A.",
        ["esES"] = "Campamento D.E.H.T.A.",
        ["esMX"] = "Campamento D.E.H.T.A.",
        ["frFR"] = "Campement de la SdPA",
        ["koKR"] = "동물보호협회 야영지",
        ["ptBR"] = "Acampamento da DruiPA",
        ["ruRU"] = "Лагерь Д.Э.Г.О.Ж.",
        ["zhCN"] = "仁德会营地",
        ["zhTW"] = "D.E.H.T.A.駐營",
    },
    ["Kaw's Roost"] = {
        ["enUS"] = true,
        ["deDE"] = "Kraas Ruhestätte",
        ["esES"] = "Percha de Kaw",
        ["esMX"] = "Percha de Kaw",
        ["frFR"] = "Perchoir de Kaw",
        ["koKR"] = "카우의 보금자리",
        ["ptBR"] = "Mirante de Kaw",
        ["ruRU"] = "Гнездо Кау",
        ["zhCN"] = "卡奥的营地",
        ["zhTW"] = "卡烏的棲息地",
    },
    ["Moa'ki Harbor"] = {
        ["enUS"] = true,
        ["deDE"] = "Hafen Moa'ki",
        ["esES"] = "Puerto Moa'ki",
        ["esMX"] = "Puerto Moa'ki",
        ["frFR"] = "Port-Moa'ki",
        ["koKR"] = "모아키 항구",
        ["ptBR"] = "Porto Moa'ki",
        ["ruRU"] = "Гавань Моа'ки",
        ["zhCN"] = "莫亚基港口",
        ["zhTW"] = "默亞基港",
    },
    ["Indu'le Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Indu'le",
        ["esES"] = "Poblado Indu'le",
        ["esMX"] = "Poblado Indu'le",
        ["frFR"] = "Indu'le",
        ["koKR"] = "인두르 마을",
        ["ptBR"] = "Aldeia Indu'le",
        ["ruRU"] = "Деревня Инду'ле",
        ["zhCN"] = "因度雷村",
        ["zhTW"] = "因度雷村",
    },
    ["Snowfall Glade"] = {
        ["enUS"] = true,
        ["deDE"] = "Schneewehenlichtung",
        ["esES"] = "Claro Avalancha",
        ["esMX"] = "Claro Avalancha",
        ["frFR"] = "Clairière de Tombeneige",
        ["koKR"] = "눈사태 숲",
        ["ptBR"] = "Clareira Nevada",
        ["ruRU"] = "Поляна Снегопада",
        ["zhCN"] = "飘雪林地",
        ["zhTW"] = "落雪林地",
    },
    ["The Half Shell"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Halbmuschel",
        ["esES"] = "La Media Concha",
        ["esMX"] = "La Media Concha",
        ["frFR"] = "La demi-coquille",
        ["koKR"] = "반쪽 껍질",
        ["ptBR"] = "A Carapaça",
        ["ruRU"] = "Половина Оболочки",
        ["zhCN"] = "半壳龟",
        ["zhTW"] = "半殼號",
    },
    ["Surge Needle"] = {
        ["enUS"] = true,
        ["deDE"] = "Sognadel",
        ["esES"] = "Aguja de Flujo",
        ["esMX"] = "Aguja de Flujo",
        ["frFR"] = "Capteur tellurique",
        ["koKR"] = "폭풍 바늘",
        ["ptBR"] = "Agulha de Mana",
        ["ruRU"] = "Волноловы",
        ["zhCN"] = "湍流之针",
        ["zhTW"] = "極濤磁針",
    },
    ["Moonrest Gardens"] = {
        ["enUS"] = true,
        ["deDE"] = "Mondruhgärten",
        ["esES"] = "Jardines Reposo Lunar",
        ["esMX"] = "Jardines Reposo Lunar",
        ["frFR"] = "Jardins de Repos-de-Lune",
        ["koKR"] = "달쉼터 정원",
        ["ptBR"] = "Jardins Lua Serena",
        ["ruRU"] = "Сады Лунного Покоя",
        ["zhCN"] = "眠月花园",
        ["zhTW"] = "月眠花園",
    },
    ["Stars' Rest"] = {
        ["enUS"] = true,
        ["deDE"] = "Sternenruh",
        ["esES"] = "Reposo Estelar",
        ["esMX"] = "Reposo Estelar",
        ["frFR"] = "Repos des étoiles",
        ["koKR"] = "별의 쉼터",
        ["ptBR"] = "Recanto das Estrelas",
        ["ruRU"] = "Покой Звезд",
        ["zhCN"] = "群星之墓",
        ["zhTW"] = "繁星之眠",
    },
    ["Westfall Brigade Encampment"] = {
        ["enUS"] = true,
        ["deDE"] = "Lager der Westfallbrigade",
        ["esES"] = "Campamento de la Brigada de los Páramos de Poniente",
        ["esMX"] = "Campamento de la Brigada de los Páramos de Poniente",
        ["frFR"] = "Campement de la brigade de la marche de l'Ouest",
        ["koKR"] = "서부 몰락지대 여단 야영지",
        ["ptBR"] = "Acampamento da Brigada de Cerro Oeste",
        ["ruRU"] = "Лагерь дружины Западного Края",
        ["zhCN"] = "月溪旅营地",
        ["zhTW"] = "西荒兵團駐營",
    },
    ["Lothalor Woodlands"] = {
        ["enUS"] = true,
        ["deDE"] = "Waldländer von Lothalor",
        ["esES"] = "Bosque Lothalor",
        ["esMX"] = "Bosque Lothalor",
        ["frFR"] = "Forêt de Lothalor",
        ["koKR"] = "로탈로르 숲",
        ["ptBR"] = "Bosques de Lothalor",
        ["ruRU"] = "Лоталорское редколесье",
        ["zhCN"] = "罗萨洛尔森林",
        ["zhTW"] = "洛薩羅林地",
    },
    ["Icemist Falls"] = {
        ["enUS"] = true,
        ["deDE"] = "Eisnebelfälle",
        ["esES"] = "Cataratas Bruma de Hielo",
        ["esMX"] = "Cataratas Bruma de Hielo",
        ["frFR"] = "Chutes de Brume-glace",
        ["koKR"] = "얼음안개 폭포",
        ["ptBR"] = "Cachoeira Bruma Boreal",
        ["ruRU"] = "Водопады Ледяной Пыли",
        ["zhCN"] = "冰雾瀑布",
        ["zhTW"] = "冰霧瀑布",
    },
    ["The Pit of Narjun"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Grube von Narjun",
        ["esES"] = "El Foso de Narjun",
        ["esMX"] = "El Foso de Narjun",
        ["frFR"] = "La fosse de Narjun",
        ["koKR"] = "나르준의 구덩이",
        ["ptBR"] = "Fosso de Narjun",
        ["ruRU"] = "Провал Наржуна",
        ["zhCN"] = "纳尔苏深渊",
        ["zhTW"] = "那金之淵",
    },
    ["Lake Indu'le"] = {
        ["enUS"] = true,
        ["deDE"] = "Wasser von Indu'le",
        ["esES"] = "Lago Indu'le",
        ["esMX"] = "Lago Indu'le",
        ["frFR"] = "Lac Indu'le",
        ["koKR"] = "인두르 호수",
        ["ptBR"] = "Lago Indu'le",
        ["ruRU"] = "Озеро Инду'ле",
        ["zhCN"] = "因度雷湖",
        ["zhTW"] = "因度雷湖",
    },
    ["Ruby Dragonshrine"] = {
        ["enUS"] = true,
        ["deDE"] = "Rubindrachenschrein",
        ["esES"] = "Santuario de Dragones Rubí",
        ["esMX"] = "Santuario de Dragones Rubí",
        ["frFR"] = "Sanctuaire draconique rubis",
        ["koKR"] = "루비 용제단",
        ["ptBR"] = "Santuário Dragônico Rubi",
        ["ruRU"] = "Рубиновое святилище драконов",
        ["zhCN"] = "红玉巨龙圣地",
        ["zhTW"] = "晶紅龍殿",
    },
    ["Fordragon Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Feste Fordragon",
        ["esES"] = "Bastión de Fordragón",
        ["esMX"] = "Bastión de Fordragón",
        ["frFR"] = "Bastion Fordragon",
        ["koKR"] = "폴드라곤 요새",
        ["ptBR"] = "Forte Fordragon",
        ["ruRU"] = "Крепость Фордрагона",
        ["zhCN"] = "弗塔根要塞",
        ["zhTW"] = "弗塔根堡",
    },
    ["Kor'kron Vanguard"] = {
        ["enUS"] = true,
        ["deDE"] = "Vorposten der Kor'kron",
        ["esES"] = "Vanguardia Kor'kron",
        ["esMX"] = "Vanguardia Kor'kron",
        ["frFR"] = "Avant-garde kor'kronne",
        ["koKR"] = "코르크론 선봉기지",
        ["ptBR"] = "Vanguarda Kor'kron",
        ["ruRU"] = "Отряд кор'крона",
        ["zhCN"] = "库卡隆先锋营地",
        ["zhTW"] = "柯爾克隆先鋒駐地",
    },
    ["The Court of Skulls"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Hof der Schädel",
        ["esES"] = "La Corte de las Calaveras",
        ["esMX"] = "La Corte de las Calaveras",
        ["frFR"] = "La cour des Crânes",
        ["koKR"] = "해골 왕궁",
        ["ptBR"] = "Castelo das Caveiras",
        ["ruRU"] = "Двор Черепов",
        ["zhCN"] = "颅骨之庭",
        ["zhTW"] = "骸骨之廷",
    },
    ["Galakrond's Rest"] = {
        ["enUS"] = true,
        ["deDE"] = "Galakronds Ruhestätte",
        ["esES"] = "Reposo de Galakrond",
        ["esMX"] = "Reposo de Galakrond",
        ["frFR"] = "Le Repos de Galakrond",
        ["koKR"] = "갈라크론드의 안식처",
        ["ptBR"] = "Repouso de Galakrond",
        ["ruRU"] = "Покой Галакронда",
        ["zhCN"] = "迦拉克隆之墓",
        ["zhTW"] = "葛拉克朗安息地",
    },
    ["The Wicked Coil"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Serpentine",
        ["esES"] = "La Espiral Maldita",
        ["esMX"] = "La Espiral Maldita",
        ["frFR"] = "La Spirale pernicieuse",
        ["koKR"] = "악의 똬리",
        ["ptBR"] = "Espiral Perversa",
        ["ruRU"] = "Пагубный Серпантин",
        ["zhCN"] = "邪恶之旋",
        ["zhTW"] = "敗德螺旋",
    },
    ["Bronze Dragonshrine"] = {
        ["enUS"] = true,
        ["deDE"] = "Bronzedrachenschrein",
        ["esES"] = "Santuario de Dragones Bronce",
        ["esMX"] = "Santuario de Dragones Bronce",
        ["frFR"] = "Sanctuaire draconique bronze",
        ["koKR"] = "청동 용제단",
        ["ptBR"] = "Santuário Dragônico Bronze",
        ["ruRU"] = "Бронзовое святилище драконов",
        ["zhCN"] = "青铜巨龙圣地",
        ["zhTW"] = "青銅龍殿",
    },
    ["The Mirror of Dawn"] = {
        ["enUS"] = true,
        ["deDE"] = "Spiegel der Morgenröte",
        ["esES"] = "El Espejo del Alba",
        ["esMX"] = "El Espejo del Alba",
        ["frFR"] = "Le Miroir de l'aube",
        ["koKR"] = "새벽의 거울",
        ["ptBR"] = "Espelho da Aurora",
        ["ruRU"] = "Зеркало Рассвета",
        ["zhCN"] = "黎明之镜",
        ["zhTW"] = "黎明之鏡",
    },
    ["Wintergarde Keep"] = {
        ["enUS"] = true,
        ["deDE"] = "Feste Wintergarde",
        ["esES"] = "Fortaleza de Hibergarde",
        ["esMX"] = "Fortaleza de Hibergarde",
        ["frFR"] = "Donjon de Garde-hiver",
        ["koKR"] = "윈터가드 성채",
        ["ptBR"] = "Bastilha Invergarde",
        ["ruRU"] = "Крепость Стражей Зимы",
        ["zhCN"] = "暮冬要塞",
        ["zhTW"] = "溫特加德要塞",
    },
    ["Wintergarde Mine"] = {
        ["enUS"] = true,
        ["deDE"] = "Minen von Wintergarde",
        ["esES"] = "Mina de Hibergarde",
        ["esMX"] = "Mina de Hibergarde",
        ["frFR"] = "Mine de Garde-hiver",
        ["koKR"] = "윈터가드 광산",
        ["ptBR"] = "Mina Invergarde",
        ["ruRU"] = "Рудник Стражей Зимы",
        ["zhCN"] = "暮冬矿洞",
        ["zhTW"] = "溫特加德礦坑",
    },
    ["Emerald Dragonshrine"] = {
        ["enUS"] = true,
        ["deDE"] = "Smaragddrachenschrein",
        ["esES"] = "Santuario de Dragones Esmeralda",
        ["esMX"] = "Santuario de Dragones Esmeralda",
        ["frFR"] = "Sanctuaire draconique émeraude",
        ["koKR"] = "에메랄드 용제단",
        ["ptBR"] = "Santuário Dragônico Esmeralda",
        ["ruRU"] = "Изумрудное святилище драконов",
        ["zhCN"] = "翡翠巨龙圣地",
        ["zhTW"] = "翡翠龍殿",
    },
    ["New Hearthglen"] = {
        ["enUS"] = true,
        ["deDE"] = "Neuherdweiler",
        ["esES"] = "Nueva Vega del Amparo",
        ["esMX"] = "Nueva Vega del Amparo",
        ["frFR"] = "Nouvelle-Âtreval",
        ["koKR"] = "신 하스글렌",
        ["ptBR"] = "Nova Amparo",
        ["ruRU"] = "Новый Дольный Очаг",
        ["zhCN"] = "新壁炉谷",
        ["zhTW"] = "新壁爐谷",
    },
    ["Crusader's Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Hafen des Kreuzzüglers",
        ["esES"] = "El Tramo del Cruzado",
        ["esMX"] = "El Tramo del Cruzado",
        ["frFR"] = "L'accostage du Croisé",
        ["koKR"] = "십자군 정박지",
        ["ptBR"] = "Ancoradouro dos Cruzados",
        ["ruRU"] = "Стоянка рыцарей",
        ["zhCN"] = "十字军码头",
        ["zhTW"] = "十字軍臺地",
    },
    ["Azure Dragonshrine"] = {
        ["enUS"] = true,
        ["deDE"] = "Azurdrachenschrein",
        ["esES"] = "Santuario de Dragones Azur",
        ["esMX"] = "Santuario de Dragones Azur",
        ["frFR"] = "Sanctuaire draconique azur",
        ["koKR"] = "청금석 용제단",
        ["ptBR"] = "Santuário Dragônico Lazúli",
        ["ruRU"] = "Лазуритовое святилище драконов",
        ["zhCN"] = "碧蓝巨龙圣地",
        ["zhTW"] = "蒼藍龍殿",
    },
    ["The Forgotten Shore"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Vergessene Strand",
        ["esES"] = "La Orilla Olvidada",
        ["esMX"] = "La Orilla Olvidada",
        ["frFR"] = "La côte Oubliée",
        ["koKR"] = "망각의 해변",
        ["ptBR"] = "Costa Abandonada",
        ["ruRU"] = "Забытое взморье",
        ["zhCN"] = "遗忘海岸",
        ["zhTW"] = "遺民之濱",
    },
    ["Venomspite"] = {
        ["enUS"] = true,
        ["deDE"] = "Gallgrimm",
        ["esES"] = "Rencor Venenoso",
        ["esMX"] = "Rencor Venenoso",
        ["frFR"] = "Vexevenin",
        ["koKR"] = "원한의 초소",
        ["ptBR"] = "Perfídia",
        ["ruRU"] = "Ядозлобь",
        ["zhCN"] = "怨毒镇",
        ["zhTW"] = "毒怨之地",
    },
    ["The Crystal Vice"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Kristallschlucht",
        ["esES"] = "Vicio de Cristal",
        ["esMX"] = "Vicio de Cristal",
        ["frFR"] = "L'Étau de cristal",
        ["koKR"] = "수정 계곡",
        ["ptBR"] = "Fenda Cristalina",
        ["ruRU"] = "Ущелье порочных кристаллов",
        ["zhCN"] = "水晶裂痕",
        ["zhTW"] = "水晶之鉗",
    },
    ["The Carrion Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Aasfelder",
        ["esES"] = "Los Campos de Carroña",
        ["esMX"] = "Los Campos de Carroña",
        ["frFR"] = "Les champs de la Charogne",
        ["koKR"] = "부패의 벌판",
        ["ptBR"] = "Campos de Carniça",
        ["ruRU"] = "Поля Падальщиков",
        ["zhCN"] = "腐臭平原",
        ["zhTW"] = "腐屍農地",
    },
    ["Onslaught Base Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Basislager des Ansturms",
        ["esES"] = "Campamento del Embate",
        ["esMX"] = "Campamento del Embate",
        ["frFR"] = "Camp de base de l'Assaut",
        ["koKR"] = "붉은돌격대 주둔지",
        ["ptBR"] = "Base da Ofensiva",
        ["ruRU"] = "Лагерь Алого Натиска",
        ["zhCN"] = "先锋军营地",
        ["zhTW"] = "突襲營地",
    },
    ["Thorson's Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Thorsons Posten",
        ["esES"] = "Puesto de Thorson",
        ["esMX"] = "Puesto de Thorson",
        ["frFR"] = "Poste de Thorson",
        ["koKR"] = "토르손의 전초기지",
        ["ptBR"] = "Posto de Thorson",
        ["ruRU"] = "Застава Торсона",
        ["zhCN"] = "索尔森的岗哨",
        ["zhTW"] = "托爾森崗哨",
    },
    ["Light's Trust"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Lichtwarte",
        ["esES"] = "Confianza de la Luz",
        ["esMX"] = "Confianza de la Luz",
        ["frFR"] = "La Confiance de Lumière",
        ["koKR"] = "믿음의 빛 거점",
        ["ptBR"] = "Guarda da Luz",
        ["ruRU"] = "Опора Света",
        ["zhCN"] = "圣光之望礼拜堂",
        ["zhTW"] = "聖光之託",
    },
    ["Frostmourne Cavern"] = {
        ["enUS"] = true,
        ["deDE"] = "Frostgramhöhlen",
        ["esES"] = "Caverna Agonía de Escarcha",
        ["esMX"] = "Caverna Agonía de Escarcha",
        ["frFR"] = "Caverne de Deuillegivre",
        ["koKR"] = "서리한 동굴",
        ["ptBR"] = "Caverna Gélido Lamento",
        ["ruRU"] = "Пещера Ледяной Скорби",
        ["zhCN"] = "霜之哀伤洞穴",
        ["zhTW"] = "霜之哀傷洞窟",
    },
    ["Scarlet Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Scharlachrote Wacht",
        ["esES"] = "Punta Escarlata",
        ["esMX"] = "Punta Escarlata",
        ["frFR"] = "Halte Ecarlate",
        ["koKR"] = "붉은돌격대 초소",
        ["ptBR"] = "Vista Escarlate",
        ["ruRU"] = "Застава Алого ордена",
        ["zhCN"] = "血色哨站",
        ["zhTW"] = "血色哨點",
    },
    ["Jintha'kalar"] = {
        ["enUS"] = true,
        ["deDE"] = "Jintha'kalar",
        ["esES"] = "Jintha'kalar",
        ["esMX"] = "Jintha'kalar",
        ["frFR"] = "Jintha'kalar",
        ["koKR"] = "진타칼라르",
        ["ptBR"] = "Jintha'kalar",
        ["ruRU"] = "Джинта'калар",
        ["zhCN"] = "金萨卡拉",
        ["zhTW"] = "辛薩卡拉",
    },
    ["Ice Heart Cavern"] = {
        ["enUS"] = true,
        ["deDE"] = "Eiskernhöhlen",
        ["esES"] = "Caverna Corazón de Hielo",
        ["esMX"] = "Caverna Corazón de Hielo",
        ["frFR"] = "Caverne du Cœur de glace",
        ["koKR"] = "얼음 심장 동굴",
        ["ptBR"] = "Caverna Gelocórdia",
        ["ruRU"] = "Пещера Ледяного Сердца",
        ["zhCN"] = "冰心洞穴",
        ["zhTW"] = "冰心洞窟",
    },
    ["Wintergrasp"] = {
        ["enUS"] = true,
        ["deDE"] = "Tausendwintersee",
        ["esES"] = "Conquista del Invierno",
        ["esMX"] = "Conquista del Invierno",
        ["frFR"] = "Joug-d'hiver",
        ["koKR"] = "겨울손아귀 호수",
        ["ptBR"] = "Invérnia",
        ["ruRU"] = "Озеро Ледяных Оков",
        ["zhCN"] = "冬拥湖",
        ["zhTW"] = "冬握湖",
    },
    ["Kili'ua's Atoll"] = {
        ["enUS"] = true,
        ["deDE"] = "Kili'uas Atoll",
        ["esES"] = "Atolón de Kili'ua",
        ["esMX"] = "Atolón de Kili'ua",
        ["frFR"] = "Atoll de Kili'ua",
        ["koKR"] = "킬리우아의 산호섬",
        ["ptBR"] = "Atol de Kili'ua",
        ["ruRU"] = "Атолл Кили'уа",
        ["zhCN"] = "基利瓦的礁石",
        ["zhTW"] = "齊里厄雅環礁",
    },
    ["Silverbrook"] = {
        ["enUS"] = true,
        ["deDE"] = "Silberwasser",
        ["esES"] = "Arroyoplata",
        ["esMX"] = "Arroyoplata",
        ["frFR"] = "Ruissargent",
        ["koKR"] = "은빛시내 마을",
        ["ptBR"] = "Arroio Prateado",
        ["ruRU"] = "Среброречье",
        ["zhCN"] = "银溪镇",
        ["zhTW"] = "銀溪鎮",
    },
    ["Vordrassil's Heart"] = {
        ["enUS"] = true,
        ["deDE"] = "Vordrassils Herz",
        ["esES"] = "Corazón de Vordrassil",
        ["esMX"] = "Corazón de Vordrassil",
        ["frFR"] = "Cœur de Vordrassil",
        ["koKR"] = "볼드랏실의 심장",
        ["ptBR"] = "Coração de Vordrassil",
        ["ruRU"] = "Сердце Фордрассила",
        ["zhCN"] = "沃达希尔之心",
        ["zhTW"] = "沃達希爾之心",
    },
    ["Vordrassil's Limb"] = {
        ["enUS"] = true,
        ["deDE"] = "Vordrassils Ast",
        ["esES"] = "Extremidad de Vordrassil",
        ["esMX"] = "Extremidad de Vordrassil",
        ["frFR"] = "Branche de Vordrassil",
        ["koKR"] = "볼드랏실의 가지",
        ["ptBR"] = "Rama de Vordrassil",
        ["ruRU"] = "Ветви Фордрассила",
        ["zhCN"] = "沃达希尔之臂",
        ["zhTW"] = "沃達希爾之枝",
    },
    ["Amberpine Lodge"] = {
        ["enUS"] = true,
        ["deDE"] = "Ammertannhütte",
        ["esES"] = "Refugio Pino Ámbar",
        ["esMX"] = "Refugio Pino Ámbar",
        ["frFR"] = "Gîte Ambrepin",
        ["koKR"] = "호박빛소나무 오두막",
        ["ptBR"] = "Chalé do Pinho Âmbar",
        ["ruRU"] = "Приют Янтарной Сосны",
        ["zhCN"] = "琥珀松木营地",
        ["zhTW"] = "琥珀松小屋",
    },
    ["Solstice Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Julheim",
        ["esES"] = "Poblado Solsticio",
        ["esMX"] = "Poblado Solsticio",
        ["frFR"] = "Solstice",
        ["koKR"] = "극지 마을",
        ["ptBR"] = "Aldeia Solstício",
        ["ruRU"] = "Деревня Солнцестояния",
        ["zhCN"] = "冬至村",
        ["zhTW"] = "季至村",
    },
    ["Conquest Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Burg Siegeswall",
        ["esES"] = "Bastión de la Conquista",
        ["esMX"] = "Bastión de la Conquista",
        ["frFR"] = "Bastion de la Conquête",
        ["koKR"] = "정복의 요새",
        ["ptBR"] = "Forte da Conquista",
        ["ruRU"] = "Крепость Завоевателей",
        ["zhCN"] = "征服堡",
        ["zhTW"] = "征服堡",
    },
    ["Voldrune"] = {
        ["enUS"] = true,
        ["deDE"] = "Voldrune",
        ["esES"] = "Runavold",
        ["esMX"] = "Runavold",
        ["frFR"] = "Voldrune",
        ["koKR"] = "볼드룬",
        ["ptBR"] = "Runavold",
        ["ruRU"] = "Волдрун",
        ["zhCN"] = "沃德伦",
        ["zhTW"] = "沃德盧恩",
    },
    ["Granite Springs"] = {
        ["enUS"] = true,
        ["deDE"] = "Granitquell",
        ["esES"] = "Manantial de Granito",
        ["esMX"] = "Manantial de Granito",
        ["frFR"] = "Sources de granit",
        ["koKR"] = "화강암 웅덩이",
        ["ptBR"] = "Fontes Graníticas",
        ["ruRU"] = "Гранитные ключи",
        ["zhCN"] = "岩石之泉",
        ["zhTW"] = "花崗岩之泉",
    },
    ["Zeb'Halak"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeb'Halak",
        ["esES"] = "Zeb'Halak",
        ["esMX"] = "Zeb'Halak",
        ["frFR"] = "Zeb'Halak",
        ["koKR"] = "제브할락",
        ["ptBR"] = "Zeb'Halak",
        ["ruRU"] = "Зеб'Халак",
        ["zhCN"] = "塞布哈拉克",
        ["zhTW"] = "札布哈拉克",
    },
    ["Camp Oneqwah"] = {
        ["enUS"] = true,
        ["deDE"] = "Camp Oneqwah",
        ["esES"] = "Campamento Oneqwah",
        ["esMX"] = "Campamento Oneqwah",
        ["frFR"] = "Camp Oneqwah",
        ["koKR"] = "원크와 야영지",
        ["ptBR"] = "Aldeia Oneqwah",
        ["ruRU"] = "Лагерь Уанква",
        ["zhCN"] = "欧尼瓦营地",
        ["zhTW"] = "歐尼克瓦營地",
    },
    ["Eastwind Shore"] = {
        ["enUS"] = true,
        ["deDE"] = "Ostwindküste",
        ["esES"] = "Playa Viento Este",
        ["esMX"] = "Playa Viento Este",
        ["frFR"] = "Rivage d'Estevent",
        ["koKR"] = "샛바람 해안",
        ["ptBR"] = "Costa da Lestada",
        ["ruRU"] = "Побережье Восточного Ветра",
        ["zhCN"] = "东风海岸",
        ["zhTW"] = "東風水濱",
    },
    ["Boulder Hills"] = {
        ["enUS"] = true,
        ["deDE"] = "Felshügel",
        ["esES"] = "Colinas Pedrusco",
        ["esMX"] = "Colinas Pedrusco",
        ["frFR"] = "Collines du Rocher",
        ["koKR"] = "바위 언덕",
        ["ptBR"] = "Montes dos Penedos",
        ["ruRU"] = "Каменистые холмы",
        ["zhCN"] = "巨石丘陵",
        ["zhTW"] = "巨礫之丘",
    },
    ["Rage Fang Shrine"] = {
        ["enUS"] = true,
        ["deDE"] = "Schrein des Grollfangs",
        ["esES"] = "Santuario Colmillo Iracundo",
        ["esMX"] = "Santuario Colmillo Iracundo",
        ["frFR"] = "Sanctuaire du Croc rageur",
        ["koKR"] = "분노의 송곳니 제단",
        ["ptBR"] = "Ermida Presa Raivosa",
        ["ruRU"] = "Святилище Красного Клыка",
        ["zhCN"] = "怒牙神殿",
        ["zhTW"] = "怒牙聖壇",
    },
    ["Drakil'jin Ruins"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Drakil'jin",
        ["esES"] = "Ruinas de Drakil'jin",
        ["esMX"] = "Ruinas de Drakil'jin",
        ["frFR"] = "Ruines de Drakil'jin",
        ["koKR"] = "드라킬진 폐허",
        ["ptBR"] = "Ruínas de Drakil'jin",
        ["ruRU"] = "Руины Дракил'джин",
        ["zhCN"] = "达基尔金废墟",
        ["zhTW"] = "德拉齊金遺跡",
    },
    ["Blackriver Logging Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Holzfällerlager Schwarzwasser",
        ["esES"] = "Aserradero Río Negro",
        ["esMX"] = "Aserradero Río Negro",
        ["frFR"] = "Camp de bûcherons de la rivière Noire",
        ["koKR"] = "검은강 벌목지",
        ["ptBR"] = "Madeireira Rio Negro",
        ["ruRU"] = "Лесопилка Черноречья",
        ["zhCN"] = "黑水伐木场",
        ["zhTW"] = "黑河伐木營地",
    },
    ["Heart's Blood Shrine"] = {
        ["enUS"] = true,
        ["deDE"] = "Schrein des Herzensblutes",
        ["esES"] = "Santuario Sangre de Corazón",
        ["esMX"] = "Santuario Sangre de Corazón",
        ["frFR"] = "Sanctuaire du Sang du cœur",
        ["koKR"] = "혈심장 제단",
        ["ptBR"] = "Ermida Verossangue",
        ["ruRU"] = "Святилище Кровавого Сердца",
        ["zhCN"] = "心血神殿",
        ["zhTW"] = "心之血聖壇",
    },
    ["Hollowstone Mine"] = {
        ["enUS"] = true,
        ["deDE"] = "Hohlsteinmine",
        ["esES"] = "Mina Piedrahueca",
        ["esMX"] = "Mina Piedrahueca",
        ["frFR"] = "Mine de la Pierre creuse",
        ["koKR"] = "빈돌 광산",
        ["ptBR"] = "Mina da Pedra Oca",
        ["ruRU"] = "Рудник Полого Камня",
        ["zhCN"] = "空石矿洞",
        ["zhTW"] = "穴石礦坑",
    },
    ["Dun Argol"] = {
        ["enUS"] = true,
        ["deDE"] = "Dun Argol",
        ["esES"] = "Dun Argol",
        ["esMX"] = "Dun Argol",
        ["frFR"] = "Dun Argol",
        ["koKR"] = "던 아르골",
        ["ptBR"] = "Dun Argol",
        ["ruRU"] = "Дун Аргол",
        ["zhCN"] = "丹厄古尔",
        ["zhTW"] = "丹亞戈",
    },
    ["Thor Modan"] = {
        ["enUS"] = true,
        ["deDE"] = "Thor Modan",
        ["esES"] = "Thor Modan",
        ["esMX"] = "Thor Modan",
        ["frFR"] = "Thor Modan",
        ["koKR"] = "토르 모단",
        ["ptBR"] = "Thor Modan",
        ["ruRU"] = "Тор Модан",
        ["zhCN"] = "索尔莫丹",
        ["zhTW"] = "鐸爾莫丹",
    },
    ["Blue Sky Logging Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Holzfällerposten Blauhimmel",
        ["esES"] = "Aserradero Cielo Azul",
        ["esMX"] = "Aserradero Cielo Azul",
        ["frFR"] = "Chantier d'abattage du Ciel bleu",
        ["koKR"] = "푸른 하늘 벌목장",
        ["ptBR"] = "Madeireira Céu Azul",
        ["ruRU"] = "Лесозаготовки Синего Неба",
        ["zhCN"] = "蓝天伐木场",
        ["zhTW"] = "藍天伐木地",
    },
    ["Maw of Neltharion"] = {
        ["enUS"] = true,
        ["deDE"] = "Neltharions Schlund",
        ["esES"] = "Fauces de Neltharion",
        ["esMX"] = "Fauces de Neltharion",
        ["frFR"] = "Gueule de Neltharion",
        ["koKR"] = "넬타리온의 턱",
        ["ptBR"] = "Bocarra de Neltharion",
        ["ruRU"] = "Пасть Нелтариона",
        ["zhCN"] = "奈萨里奥之喉",
        ["zhTW"] = "奈薩里奧之喉",
    },
    ["The Briny Pinnacle"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Salzzinne",
        ["esES"] = "El Pináculo Salobre",
        ["esMX"] = "El Pináculo Salobre",
        ["frFR"] = "Cime Saumâtre",
        ["koKR"] = "소금바위 봉우리",
        ["ptBR"] = "Morro Salgado",
        ["ruRU"] = "Соленая вершина",
        ["zhCN"] = "海洋之巅",
        ["zhTW"] = "海水之巔",
    },
    ["Glittering Strand"] = {
        ["enUS"] = true,
        ["deDE"] = "Glimmerstrand",
        ["esES"] = "Orilla Resplandeciente",
        ["esMX"] = "Orilla Resplandeciente",
        ["frFR"] = "Grève Lumineuse",
        ["koKR"] = "반짝이는 해안",
        ["ptBR"] = "Praia Reluzente",
        ["ruRU"] = "Сверкающее взморье",
        ["zhCN"] = "灿烂海岸",
        ["zhTW"] = "閃耀水岸",
    },
    ["Iskaal"] = {
        ["enUS"] = true,
        ["deDE"] = "Iskaal",
        ["esES"] = "Iskaal",
        ["esMX"] = "Iskaal",
        ["frFR"] = "Iskaal",
        ["koKR"] = "이스카알",
        ["ptBR"] = "Iskaal",
        ["ruRU"] = "Искаал",
        ["zhCN"] = "伊斯卡尔",
        ["zhTW"] = "伊斯考",
    },
    ["Dragon's Fall"] = {
        ["enUS"] = true,
        ["deDE"] = "Drachensturz",
        ["esES"] = "Caída del Dragón",
        ["esMX"] = "Caída del Dragón",
        ["frFR"] = "Chute du dragon",
        ["koKR"] = "용사냥 마루",
        ["ptBR"] = "Aldeia do Dragão Arruinado",
        ["ruRU"] = "Драконья погибель",
        ["zhCN"] = "猎龙营地",
        ["zhTW"] = "龍殞營地",
    },
    ["The Oculus"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Oculus",
        ["esES"] = "El Oculus",
        ["esMX"] = "El Oculus",
        ["frFR"] = "L'Oculus",
        ["koKR"] = "마력의 눈",
        ["ptBR"] = "Óculus",
        ["ruRU"] = "Окулус",
        ["zhCN"] = "魔环",
        ["zhTW"] = "奧核之眼",
    },
    ["Prospector's Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Prospektorat",
        ["esES"] = "Altozano del Prospector",
        ["esMX"] = "Altozano del Prospector",
        ["frFR"] = "Pointe du Prospecteur",
        ["koKR"] = "발굴단 거점",
        ["ptBR"] = "Mirante do Minerador",
        ["ruRU"] = "Лагерь горняков",
        ["zhCN"] = "勘探员哨站",
        ["zhTW"] = "勘察員崗哨",
    },
    ["Coldwind Heights"] = {
        ["enUS"] = true,
        ["deDE"] = "Kaltwindanhöhen",
        ["esES"] = "Altos Viento Helado",
        ["esMX"] = "Altos Viento Helado",
        ["frFR"] = "Hauts de Vent-froid",
        ["koKR"] = "눈바람 언덕",
        ["ptBR"] = "Planalto Vento Frio",
        ["ruRU"] = "Морозные выси",
        ["zhCN"] = "冷风高地",
        ["zhTW"] = "冷風陵地",
    },
    ["Redwood Trading Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Handelsposten von Rotholz",
        ["esES"] = "Puesto de Venta de Madera Roja",
        ["esMX"] = "Puesto de Venta de Madera Roja",
        ["frFR"] = "Comptoir du Cèdre",
        ["koKR"] = "붉은나무 교역소",
        ["ptBR"] = "Entreposto Sequoia",
        ["ruRU"] = "Торговая лавка Красного леса",
        ["zhCN"] = "红木商栈",
        ["zhTW"] = "紅木貿易站",
    },
    ["Vengeance Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Pass der Vergeltung",
        ["esES"] = "Paso Venganza",
        ["esMX"] = "Paso Venganza",
        ["frFR"] = "Défilé de la Vengeance",
        ["koKR"] = "복수의 고개",
        ["ptBR"] = "Desfiladeiro da Vingança",
        ["ruRU"] = "Перевал Возмездия",
        ["zhCN"] = "复仇小径",
        ["zhTW"] = "復仇隘口",
    },
    ["Dawn's Reach"] = {
        ["enUS"] = true,
        ["deDE"] = "Dämmerkuppe",
        ["esES"] = "Tramo del Alba",
        ["esMX"] = "Tramo del Alba",
        ["frFR"] = "Confins de l'Aube",
        ["koKR"] = "십자군 주둔지",
        ["ptBR"] = "Confins da Aurora",
        ["ruRU"] = "Рассветный край",
        ["zhCN"] = "黎明河滩",
        ["zhTW"] = "黎明之境",
    },
    ["Heartwood Trading Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Handelsposten Kernholz",
        ["esES"] = "Puesto de Venta de Duramen",
        ["esMX"] = "Puesto de Venta de Duramen",
        ["frFR"] = "Comptoir de Cœur-du-bois",
        ["koKR"] = "심재 교역소",
        ["ptBR"] = "Entreposto Alburno",
        ["ruRU"] = "Торговая лавка Чащи Леса",
        ["zhCN"] = "心木商栈",
        ["zhTW"] = "心材貿易站",
    },
    ["Evergreen Trading Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Handelsposten Immergrün",
        ["esES"] = "Puesto de Venta de Siempreverde",
        ["esMX"] = "Puesto de Venta de Siempreverde",
        ["frFR"] = "Comptoir des Conifères",
        ["koKR"] = "사철나무 교역소",
        ["ptBR"] = "Entreposto Perene",
        ["ruRU"] = "Торговая лавка Вечнозеленого леса",
        ["zhCN"] = "常青商栈",
        ["zhTW"] = "常青貿易站",
    },
    ["Spruce Point Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Posten des Fichtenpunkts",
        ["esES"] = "Puesto del Altozano de Píceas",
        ["esMX"] = "Puesto del Altozano de Píceas",
        ["frFR"] = "Poste du cap de l'Epicéa",
        ["koKR"] = "전나무 거점 주둔지",
        ["ptBR"] = "Posto Ponta do Pinheiro",
        ["ruRU"] = "Застава еловой макушки",
        ["zhCN"] = "云杉哨站",
        ["zhTW"] = "雲杉峰崗哨",
    },
    ["White Pine Trading Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Handelsposten Weißkiefer",
        ["esES"] = "Puesto de Venta de Pino Blanco",
        ["esMX"] = "Puesto de Venta de Pino Blanco",
        ["frFR"] = "Comptoir du Pin blanc",
        ["koKR"] = "흰 소나무 교역소",
        ["ptBR"] = "Entreposto Pinheiro Branco",
        ["ruRU"] = "Торговая лавка Белой Сосны",
        ["zhCN"] = "白松商栈",
        ["zhTW"] = "白松貿易站",
    },
    ["Aspen Grove Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Posten des Espenhains",
        ["esES"] = "Puesto de la Alameda",
        ["esMX"] = "Puesto de la Alameda",
        ["frFR"] = "Poste de la Tremblaie",
        ["koKR"] = "미루나무 숲 초소",
        ["ptBR"] = "Posto Álamo",
        ["ruRU"] = "Застава Тополиной рощи",
        ["zhCN"] = "白杨商栈",
        ["zhTW"] = "白楊崗哨",
    },
    ["Forest's Edge Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Posten des Waldrands",
        ["esES"] = "Puesto Fronterizo del Bosque",
        ["esMX"] = "Puesto Fronterizo del Bosque",
        ["frFR"] = "Poste de la Lisière",
        ["koKR"] = "숲 가장자리 초소",
        ["ptBR"] = "Posto Boca da Mata",
        ["ruRU"] = "Застава на опушке",
        ["zhCN"] = "林边哨站",
        ["zhTW"] = "林邊崗哨",
    },
    ["Eldritch Heights"] = {
        ["enUS"] = true,
        ["deDE"] = "Düsterhöhen",
        ["esES"] = "Cumbres de Eldritch",
        ["esMX"] = "Cumbres Fantasmales",
        ["frFR"] = "Les hauts Surréels",
        ["koKR"] = "으스스한 언덕",
        ["ptBR"] = "Cerro Lúgubre",
        ["ruRU"] = "Зловещая возвышенность",
        ["zhCN"] = "埃尔德齐断崖",
        ["zhTW"] = "異法陵地",
    },
    ["Venture Bay"] = {
        ["enUS"] = true,
        ["deDE"] = "Venturebucht",
        ["esES"] = "Bahía Ventura",
        ["esMX"] = "Bahía Ventura",
        ["frFR"] = "Baie de la KapitalRisk",
        ["koKR"] = "투자개발 만",
        ["ptBR"] = "Baía dos Empreendimentos",
        ["ruRU"] = "Бухта торговцев",
        ["zhCN"] = "风险湾",
        ["zhTW"] = "風險海灣",
    },
    ["Wintergarde Crypt"] = {
        ["enUS"] = true,
        ["deDE"] = "Gruft von Wintergarde",
        ["esES"] = "Cripta de Hibergarde",
        ["esMX"] = "Cripta de Hibergarde",
        ["frFR"] = "Crypte de Garde-hiver",
        ["koKR"] = "윈터가드 납골당",
        ["ptBR"] = "Cripta de Invergarde",
        ["ruRU"] = "Склеп Стражей Зимы",
        ["zhCN"] = "暮冬地穴",
        ["zhTW"] = "溫特加德墓穴",
    },
    ["Bloodmoon Isle"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutmondinsel",
        ["esES"] = "Isla Luna de Sangre",
        ["esMX"] = "Isla Luna de Sangre",
        ["frFR"] = "Île de la Lune sanguine",
        ["koKR"] = "핏빛달 섬",
        ["ptBR"] = "Ilha Sangreluna",
        ["ruRU"] = "Остров Кровавой Луны",
        ["zhCN"] = "血月岛",
        ["zhTW"] = "血月島",
    },
    ["Shadowfang Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Schattenfangturm",
        ["esES"] = "Torre de Colmillo Oscuro",
        ["esMX"] = "Torre de Colmillo Oscuro",
        ["frFR"] = "Tour d'Ombrecroc",
        ["koKR"] = "그림자송곳니 탑",
        ["ptBR"] = "Torre da Presa Negra",
        ["ruRU"] = "Башня Темного Клыка",
        ["zhCN"] = "影牙之塔",
        ["zhTW"] = "影牙塔",
    },
    ["Wintergarde Mausoleum"] = {
        ["enUS"] = true,
        ["deDE"] = "Mausoleum von Wintergarde",
        ["esES"] = "Mausoleo de Hibergarde",
        ["esMX"] = "Mausoleo de Hibergarde",
        ["frFR"] = "Mausolée de Garde-hiver",
        ["koKR"] = "윈터가드 묘지",
        ["ptBR"] = "Mausoléu de Invergarde",
        ["ruRU"] = "Усыпальница Стражей Зимы",
        ["zhCN"] = "暮冬陵园",
        ["zhTW"] = "溫特加德墓塚",
    },
    ["Duskhowl Den"] = {
        ["enUS"] = true,
        ["deDE"] = "Grauheulerbau",
        ["esES"] = "Cubil Aúllaocaso",
        ["esMX"] = "Cubil Aúllaocaso",
        ["frFR"] = "Tanière des Hurlesoir",
        ["koKR"] = "그늘울음 동굴",
        ["ptBR"] = "Gruta do Uivo da Noite",
        ["ruRU"] = "Логово Ночного Воя",
        ["zhCN"] = "暗嚎兽穴",
        ["zhTW"] = "暮嚎之穴",
    },
    ["The Conquest Pit"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Siegeswallgrube",
        ["esES"] = "El Foso de la Conquista",
        ["esMX"] = "El Foso de la Conquista",
        ["frFR"] = "La fosse des Conquérants",
        ["koKR"] = "정복의 요새 투기장",
        ["ptBR"] = "Fosso da Conquista",
        ["ruRU"] = "Бойцовская яма",
        ["zhCN"] = "征服斗兽场",
        ["zhTW"] = "征服之淵",
    },
    ["The Path of Iron"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Eisenpfad",
        ["esES"] = "La Senda de Hierro",
        ["esMX"] = "La Senda de Hierro",
        ["frFR"] = "Le sentier du Fer",
        ["koKR"] = "무쇠단의 길",
        ["ptBR"] = "Caminho de Ferro",
        ["ruRU"] = "Путь Железа",
        ["zhCN"] = "铁铸之路",
        ["zhTW"] = "鐵之途",
    },
    ["Ruins of Tethys"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Tethys",
        ["esES"] = "Ruinas de Tethys",
        ["esMX"] = "Ruinas de Tethys",
        ["frFR"] = "Ruines de Téthys",
        ["koKR"] = "테시스의 폐허",
        ["ptBR"] = "Ruínas de Tethys",
        ["ruRU"] = "Руины Тетиса",
        ["zhCN"] = "泰塞斯废墟",
        ["zhTW"] = "瑟希斯遺跡",
    },
    ["Silverbrook Hills"] = {
        ["enUS"] = true,
        ["deDE"] = "Silberwasserhügel",
        ["esES"] = "Colinas de Arroyoplata",
        ["esMX"] = "Colinas de Arroyoplata",
        ["frFR"] = "Collines de Ruissargent",
        ["koKR"] = "은빛시내 언덕",
        ["ptBR"] = "Serra do Arroio Prateado",
        ["ruRU"] = "Холмы Среброречья",
        ["zhCN"] = "银溪丘陵",
        ["zhTW"] = "銀溪丘",
    },
    ["The Broken Bluffs"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Felssturz",
        ["esES"] = "Riscos Quebrados",
        ["esMX"] = "Riscos Quebrados",
        ["frFR"] = "Les pitons Brisés",
        ["koKR"] = "부서진 절벽",
        ["ptBR"] = "Penhascos Inóspitos",
        ["ruRU"] = "Изрезанные утесы",
        ["zhCN"] = "裂崖",
        ["zhTW"] = "破碎崖",
    },
    ["7th Legion Front"] = {
        ["enUS"] = true,
        ["deDE"] = "Front der 7. Legion",
        ["esES"] = "Frente de la Séptima Legión",
        ["esMX"] = "Frente de la Séptima Legión",
        ["frFR"] = "Front de la 7e Légion",
        ["koKR"] = "7군단 전초지",
        ["ptBR"] = "Front da 7ª Legião",
        ["ruRU"] = "Передовая 7-го легиона",
        ["zhCN"] = "第七军团前线",
        ["zhTW"] = "第七軍團前線",
    },
    ["The Dragon Wastes"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Dracheneiswüste",
        ["esES"] = "Baldío del Dragón",
        ["esMX"] = "Baldío del Dragón",
        ["frFR"] = "Le désert des Dragons",
        ["koKR"] = "용의 황무지",
        ["ptBR"] = "Ermos Dragônicos",
        ["ruRU"] = "Драконьи пустоши",
        ["zhCN"] = "巨龙废土",
        ["zhTW"] = "龍墳荒原",
    },
    ["Ruins of Drak'Zin"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Drak'Zin",
        ["esES"] = "Ruinas de Drak'Zin",
        ["esMX"] = "Ruinas de Drak'Zin",
        ["frFR"] = "Ruines de Drak'Zin",
        ["koKR"] = "드락진 폐허",
        ["ptBR"] = "Ruínas de Drak'Zin",
        ["ruRU"] = "Руины Драк'Зина",
        ["zhCN"] = "达克辛废墟",
        ["zhTW"] = "德拉克辛遺跡",
    },
    ["Drak'Mar Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Drak'Marsee",
        ["esES"] = "Lago Drak'Mar",
        ["esMX"] = "Lago Drak'Mar",
        ["frFR"] = "Lac Drak'Mar",
        ["koKR"] = "드락마 호수",
        ["ptBR"] = "Lago Drak'Mar",
        ["ruRU"] = "Озеро Драк'Мар",
        ["zhCN"] = "达克玛尔湖",
        ["zhTW"] = "德拉克瑪湖",
    },
    ["Dragonspine Tributary"] = {
        ["enUS"] = true,
        ["deDE"] = "Drachenwirbelzufluss",
        ["esES"] = "Afluente del Espinazo del Dragón",
        ["esMX"] = "Afluente del Espinazo del Dragón",
        ["frFR"] = "Affluent de l'Epine-de-dragon",
        ["koKR"] = "용돌기 강",
        ["ptBR"] = "Afluente Espinodraco",
        ["ruRU"] = "Кладовая Драконьего Хребта",
        ["zhCN"] = "龙脊河",
        ["zhTW"] = "龍脊支流",
    },
    ["Drak'ural"] = {
        ["enUS"] = true,
        ["deDE"] = "Drak'ural",
        ["esES"] = "Drak'ural",
        ["esMX"] = "Drak'ural",
        ["frFR"] = "Drak'ural",
        ["koKR"] = "드락우랄",
        ["ptBR"] = "Drak'ural",
        ["ruRU"] = "Драк'урал",
        ["zhCN"] = "达克乌拉",
        ["zhTW"] = "德拉克烏洛",
    },
    ["Thorvald's Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Thorvalds Lager",
        ["esES"] = "Campamento de Thorvald",
        ["esMX"] = "Campamento de Thorvald",
        ["frFR"] = "Camp de Thorvald",
        ["koKR"] = "토르발트의 야영지",
        ["ptBR"] = "Acampamento do Thorvald",
        ["ruRU"] = "Лагерь Торвальда",
        ["zhCN"] = "托尔瓦德的营地",
        ["zhTW"] = "索瓦爾德營地",
    },
    ["Ghostblade Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Geisterklingenposten",
        ["esES"] = "Puesto del Filo Fantasmal",
        ["esMX"] = "Puesto del Filo Fantasmal",
        ["frFR"] = "Poste de la Lame-fantôme",
        ["koKR"] = "유령칼날 초소",
        ["ptBR"] = "Posto Lâmina Espectral",
        ["ruRU"] = "Застава Призрачного Клинка",
        ["zhCN"] = "幽刃岗哨",
        ["zhTW"] = "鬼刃崗哨",
    },
    ["Ashwood Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Eschenholzposten",
        ["esES"] = "Puesto Fresno",
        ["esMX"] = "Puesto Fresno",
        ["frFR"] = "Poste du Frêne",
        ["koKR"] = "잿빛나무 초소",
        ["ptBR"] = "Posto Freixo",
        ["ruRU"] = "Ясеневая застава",
        ["zhCN"] = "灰木哨站",
        ["zhTW"] = "灰木崗哨",
    },
    ["Lydell's Ambush"] = {
        ["enUS"] = true,
        ["deDE"] = "Lydells Hinterhalt",
        ["esES"] = "Emboscada de Lydell",
        ["esMX"] = "Emboscada de Lydell",
        ["frFR"] = "Embuscade de Lydell",
        ["koKR"] = "리델의 매복지",
        ["ptBR"] = "Cilada de Lídio",
        ["ruRU"] = "Засада Лиделла",
        ["zhCN"] = "林德尔的伏击点",
        ["zhTW"] = "黎戴爾的埋伏處",
    },
    ["Harkor's Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Harkors Lager",
        ["esES"] = "Campamento de Harkor",
        ["esMX"] = "Campamento de Harkor",
        ["frFR"] = "Camp de Harkor",
        ["koKR"] = "하코르의 야영지",
        ["ptBR"] = "Acampamento do Harkor",
        ["ruRU"] = "Лагерь Харкора",
        ["zhCN"] = "哈考尔营地",
        ["zhTW"] = "哈克爾營地",
    },
    ["Vordrassil Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Pass von Vordrassil",
        ["esES"] = "Paso de Vordrassil",
        ["esMX"] = "Paso de Vordrassil",
        ["frFR"] = "Passe de Vordrassil",
        ["koKR"] = "볼드랏실 고개",
        ["ptBR"] = "Desfiladeiro de Vordrassil",
        ["ruRU"] = "Перевал Фордрассил",
        ["zhCN"] = "沃达希尔小径",
        ["zhTW"] = "沃達希爾小徑",
    },
    ["Ruuna's Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruunas Lager",
        ["esES"] = "Campamento de Ruuna",
        ["esMX"] = "Campamento de Ruuna",
        ["frFR"] = "Camp de Ruuna",
        ["koKR"] = "루나의 야영지",
        ["ptBR"] = "Acampamento da Ruuna",
        ["ruRU"] = "Лагерь Рууны",
        ["zhCN"] = "卢娜的营地",
        ["zhTW"] = "魯巫娜的營地",
    },
    ["Shrine of Scales"] = {
        ["enUS"] = true,
        ["deDE"] = "Schrein der Schuppen",
        ["esES"] = "Santuario de Escamas",
        ["esMX"] = "Santuario de Escamas",
        ["frFR"] = "Sanctuaire des Écailles",
        ["koKR"] = "비늘 제단",
        ["ptBR"] = "Altar das Escamas",
        ["ruRU"] = "Святилище Чешуи",
        ["zhCN"] = "蛇鳞神殿",
        ["zhTW"] = "群鱗聖壇",
    },
    ["Drak'atal Passage"] = {
        ["enUS"] = true,
        ["deDE"] = "Passage von Drak'atal",
        ["esES"] = "Pasaje de Drak'atal",
        ["esMX"] = "Pasaje de Drak'atal",
        ["frFR"] = "Passage de Drak'atal",
        ["koKR"] = "드라카탈 통로",
        ["ptBR"] = "Passagem de Drak'atal",
        ["ruRU"] = "Перевал Драк'атала",
        ["zhCN"] = "达克阿塔小径",
        ["zhTW"] = "德拉克托通道",
    },
    ["The Argent Stand"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Argentumwache",
        ["esES"] = "El Confín Argenta",
        ["esMX"] = "El Confín Argenta",
        ["frFR"] = "Le séjour d'Argent",
        ["koKR"] = "은빛십자군 격전지",
        ["ptBR"] = "Fortaleza Argêntea",
        ["ruRU"] = "Серебряная застава",
        ["zhCN"] = "银色前沿",
        ["zhTW"] = "銀白看臺",
    },
    ["Altar of Sseratus"] = {
        ["enUS"] = true,
        ["deDE"] = "Altar von Sseratus",
        ["esES"] = "Altar de Sseratus",
        ["esMX"] = "Altar de Sseratus",
        ["frFR"] = "Autel de Sseratus",
        ["koKR"] = "세라투스의 제단",
        ["ptBR"] = "Altar de Sseratus",
        ["ruRU"] = "Алтарь Шшератуса",
        ["zhCN"] = "西莱图斯祭坛",
        ["zhTW"] = "司瑟拉圖斯祭壇",
    },
    ["Drak'Sotra Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Felder von Drak'Sotra",
        ["esES"] = "Campos Drak'Sotra",
        ["esMX"] = "Campos Drak'Sotra",
        ["frFR"] = "Champs de Drak'Sotra",
        ["koKR"] = "드락소트라 농장",
        ["ptBR"] = "Campos de Drak'Sotra",
        ["ruRU"] = "Поля Драк'Сотры",
        ["zhCN"] = "达克索塔农田",
        ["zhTW"] = "德拉克索璀原野",
    },
    ["Drak'Sotra"] = {
        ["enUS"] = true,
        ["deDE"] = "Drak'Sotra",
        ["esES"] = "Drak'Sotra",
        ["esMX"] = "Drak'Sotra",
        ["frFR"] = "Drak'Sotra",
        ["koKR"] = "드락소트라",
        ["ptBR"] = "Drak'Sotra",
        ["ruRU"] = "Драк'Сотра",
        ["zhCN"] = "达克索塔",
        ["zhTW"] = "德拉克索璀",
    },
    ["Drak'Agal"] = {
        ["enUS"] = true,
        ["deDE"] = "Drak'Agal",
        ["esES"] = "Drak'Agal",
        ["esMX"] = "Drak'Agal",
        ["frFR"] = "Drak'Agal",
        ["koKR"] = "드락아갈",
        ["ptBR"] = "Draz'Agal",
        ["ruRU"] = "Драк'Агал",
        ["zhCN"] = "达克迦尔",
        ["zhTW"] = "德拉克亞苟",
    },
    ["The Avalanche"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Lawine",
        ["esES"] = "La Avalancha",
        ["esMX"] = "La Avalancha",
        ["frFR"] = "L'Avalanche",
        ["koKR"] = "눈사태 언덕",
        ["ptBR"] = "A Avalanche",
        ["ruRU"] = "Застывшая лавина",
        ["zhCN"] = "雪崩山麓",
        ["zhTW"] = "雪崩地",
    },
    ["Nesingwary Base Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Nesingwarys Basislager",
        ["esES"] = "Campamento Base de Nesingwary",
        ["esMX"] = "Campamento Base de Nesingwary",
        ["frFR"] = "Camp de base de Nesingwary",
        ["koKR"] = "네싱워리 주둔지",
        ["ptBR"] = "Acampamento do Rosarães",
        ["ruRU"] = "Лагерь Эрнестуэя",
        ["zhCN"] = "奈辛瓦里营地",
        ["zhTW"] = "奈辛瓦里營地",
    },
    ["The Seabreach Flow"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Meeresklammstrom",
        ["esES"] = "El Flujo de la Brecha del Mar",
        ["esMX"] = "El Flujo de la Brecha del Mar",
        ["frFR"] = "Le courant de la Brèche",
        ["koKR"] = "바닷길 여울",
        ["ptBR"] = "Arroio Quebra-mar",
        ["ruRU"] = "Разлом Морского Потока",
        ["zhCN"] = "碎浪河",
        ["zhTW"] = "海裂之湧",
    },
    ["The Bones of Nozronn"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Knochen von Nozronn",
        ["esES"] = "Los Huesos de Nozronn",
        ["esMX"] = "Los Huesos de Nozronn",
        ["frFR"] = "Les os de Nozronn",
        ["koKR"] = "노즈론의 무덤",
        ["ptBR"] = "Ossos de Nozronn",
        ["ruRU"] = "Скелет Нозронна",
        ["zhCN"] = "诺兹隆之骨",
        ["zhTW"] = "諾茲朗之骨",
    },
    ["Kartak's Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Kartaks Stellung",
        ["esES"] = "Bastión de Kartak",
        ["esMX"] = "Bastión de Kartak",
        ["frFR"] = "Bastion de Kartak",
        ["koKR"] = "카르탁의 요새",
        ["ptBR"] = "Aldeia de Kartak",
        ["ruRU"] = "Форт Картака",
        ["zhCN"] = "卡塔克要塞",
        ["zhTW"] = "卡爾塔克堡",
    },
    ["Sparktouched Haven"] = {
        ["enUS"] = true,
        ["deDE"] = "Zuflucht der Funkenbesprühten",
        ["esES"] = "Retiro Pavesa",
        ["esMX"] = "Retiro Pavesa",
        ["frFR"] = "Le havre Touchétincelle",
        ["koKR"] = "번개불꽃 안식처",
        ["ptBR"] = "Refúgio Piscabrilha",
        ["ruRU"] = "Заиндевелая гавань",
        ["zhCN"] = "灵鳍湾",
        ["zhTW"] = "炫觸避風港",
    },
    ["The Path of the Lifewarden"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Pfad der Lebenswächterin",
        ["esES"] = "La Senda del Guardián de Vida",
        ["esMX"] = "La Senda del Guardián de Vida",
        ["frFR"] = "Le chemin de la Gardienne de la vie",
        ["koKR"] = "생명 감시자의 길",
        ["ptBR"] = "Caminho da Guardiã da Vida",
        ["ruRU"] = "Путь Хранителя Жизни",
        ["zhCN"] = "生命守卫者之路",
        ["zhTW"] = "生命守護者之路",
    },
    ["Heb'Valok"] = {
        ["enUS"] = true,
        ["deDE"] = "Heb'Valok",
        ["esES"] = "Heb'Valok",
        ["esMX"] = "Heb'Valok",
        ["frFR"] = "Heb'Valok",
        ["koKR"] = "헤브발로크",
        ["ptBR"] = "Heb'Valok",
        ["ruRU"] = "Хеб'Валок",
        ["zhCN"] = "赫布瓦罗",
        ["zhTW"] = "希伯伐洛克",
    },
    ["Plaguelands: The Scarlet Enclave"] = {
        ["enUS"] = true,
        ["deDE"] = "Pestländer: Die Scharlachrote Enklave",
        ["esES"] = "Tierras de la Peste: El Enclave Escarlata",
        ["esMX"] = "Tierras de la Peste: El Enclave Escarlata",
        ["frFR"] = "Maleterres : l'enclave Écarlate",
        ["koKR"] = "동부 역병지대: 붉은십자군 초소",
        ["ptBR"] = "Terras Pestilentas: Enclave Escarlate",
        ["ruRU"] = "Чумные земли: Анклав Алого ордена",
        ["zhCN"] = "东瘟疫之地：血色领地",
        ["zhTW"] = "東瘟疫之地: 血色領區",
    },
    ["Kolramas"] = {
        ["enUS"] = true,
        ["deDE"] = "Kolramas",
        ["esES"] = "Kolramas",
        ["esMX"] = "Kolramas",
        ["frFR"] = "Kolramas",
        ["koKR"] = "콜라마스",
        ["ptBR"] = "Kolramas",
        ["ruRU"] = "Колрамас",
        ["zhCN"] = "科尔拉玛斯",
        ["zhTW"] = "科爾拉瑪斯",
    },
    ["Mistwhisper Refuge"] = {
        ["enUS"] = true,
        ["deDE"] = "Zuflucht der Nebelflüsterer",
        ["esES"] = "Refugio Susurraneblina",
        ["esMX"] = "Refugio Susurraneblina",
        ["frFR"] = "Le refuge de Murmebrume",
        ["koKR"] = "안개속삭임 야영지",
        ["ptBR"] = "Refúgio Brumurmúria",
        ["ruRU"] = "Убежище Шепота Тумана",
        ["zhCN"] = "雾语村",
        ["zhTW"] = "霧語避難所",
    },
    ["The Glimmering Pillar"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schimmersäule",
        ["esES"] = "El Pilar Iluminado",
        ["esMX"] = "El Pilar Iluminado",
        ["frFR"] = "Le pilier Scintillant",
        ["koKR"] = "미명의 봉우리",
        ["ptBR"] = "Pilar Rutilante",
        ["ruRU"] = "Мерцающая колонна",
        ["zhCN"] = "光芒之柱",
        ["zhTW"] = "微光之柱",
    },
    ["Spearborn Encampment"] = {
        ["enUS"] = true,
        ["deDE"] = "Lager der Speerträger",
        ["esES"] = "Campamento Lanzonato",
        ["esMX"] = "Campamento Lanzonato",
        ["frFR"] = "Campement Né-des-lances",
        ["koKR"] = "작살사냥꾼 야영지",
        ["ptBR"] = "Assentamento do Povo da Lança",
        ["ruRU"] = "Лагерь Копьеносца",
        ["zhCN"] = "锐矛营地",
        ["zhTW"] = "矛生駐營",
    },
    ["Zeramas"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeramas",
        ["esES"] = "Zeramas",
        ["esMX"] = "Zeramas",
        ["frFR"] = "Zeramas",
        ["koKR"] = "제라마스",
        ["ptBR"] = "Zeramas",
        ["ruRU"] = "Зерамас",
        ["zhCN"] = "泽尔拉玛斯",
        ["zhTW"] = "賽拉瑪斯",
    },
    ["Reliquary of Agony"] = {
        ["enUS"] = true,
        ["deDE"] = "Reliquie der Pein",
        ["esES"] = "Relicario de Agonía",
        ["esMX"] = "Relicario de Agonía",
        ["frFR"] = "Reliquaire d'agonie",
        ["koKR"] = "고뇌의 성물함",
        ["ptBR"] = "Relicário da Agonia",
        ["ruRU"] = "Реликварий Агонии",
        ["zhCN"] = "折磨之匣",
        ["zhTW"] = "苦楚聖匣",
    },
    ["Ebon Watch"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schwarze Wacht",
        ["esES"] = "Puesto de Vigilancia de Ébano",
        ["esMX"] = "Puesto de Vigilancia de Ébano",
        ["frFR"] = "Guet d'Ébène",
        ["koKR"] = "칠흑의 감시초소",
        ["ptBR"] = "Posto Ébano",
        ["ruRU"] = "Черная застава",
        ["zhCN"] = "黑锋哨站",
        ["zhTW"] = "黯黑守望",
    },
    ["Thrym's End"] = {
        ["enUS"] = true,
        ["deDE"] = "Thryms Ende",
        ["esES"] = "Fin de Thrym",
        ["esMX"] = "Fin de Thrym",
        ["frFR"] = "Fin de Thrym",
        ["koKR"] = "스림의 최후",
        ["ptBR"] = "Ruína de Thrym",
        ["ruRU"] = "Тупик Трыма",
        ["zhCN"] = "塞穆之末",
        ["zhTW"] = "瑟瑞姆之歿",
    },
    ["Voltarus"] = {
        ["enUS"] = true,
        ["deDE"] = "Voltarus",
        ["esES"] = "Voltarus",
        ["esMX"] = "Voltarus",
        ["frFR"] = "Voltarus",
        ["koKR"] = "볼타루스",
        ["ptBR"] = "Voltarus",
        ["ruRU"] = "Волтар",
        ["zhCN"] = "沃尔塔鲁斯",
        ["zhTW"] = "沃塔魯斯",
    },
    ["Reliquary of Pain"] = {
        ["enUS"] = true,
        ["deDE"] = "Reliquiar des Schmerzes",
        ["esES"] = "Relicario de Dolor",
        ["esMX"] = "Relicario de Dolor",
        ["frFR"] = "Reliquaire de souffrance",
        ["koKR"] = "고통의 성물함",
        ["ptBR"] = "Relicário da Dor",
        ["ruRU"] = "Реликварий Боли",
        ["zhCN"] = "痛苦之匣",
        ["zhTW"] = "痛苦聖匣",
    },
    ["Rageclaw Den"] = {
        ["enUS"] = true,
        ["deDE"] = "Zornklauenbau",
        ["esES"] = "Guarida de Garrafuria",
        ["esMX"] = "Guarida de Garrafuria",
        ["frFR"] = "Tanière Grifferage",
        ["koKR"] = "성난발톱 소굴",
        ["ptBR"] = "Covil Patafúria",
        ["ruRU"] = "Логово Яростного Когтя",
        ["zhCN"] = "怒爪巢穴",
        ["zhTW"] = "怒爪巢穴",
    },
    ["Light's Breach"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Lichtbresche",
        ["esES"] = "Brecha de la Luz",
        ["esMX"] = "Brecha de la Luz",
        ["frFR"] = "La Brèche de Lumière",
        ["koKR"] = "빛의 틈",
        ["ptBR"] = "Campo da Luz",
        ["ruRU"] = "Разлом Света",
        ["zhCN"] = "圣光据点",
        ["zhTW"] = "聖光止境",
    },
    ["Pools of Zha'Jin"] = {
        ["enUS"] = true,
        ["deDE"] = "Teiche von Zha'Jin",
        ["esES"] = "Pozas de Zha'Jin",
        ["esMX"] = "Pozas de Zha'Jin",
        ["frFR"] = "Bassins de Zha'Jin",
        ["koKR"] = "자진의 웅덩이",
        ["ptBR"] = "Poços de Zha'Jin",
        ["ruRU"] = "Озера Жа'Джина",
        ["zhCN"] = "扎尔金之池",
        ["zhTW"] = "薩金之池",
    },
    ["Zim'Abwa"] = {
        ["enUS"] = true,
        ["deDE"] = "Zim'Abwa",
        ["esES"] = "Zim'Abwa",
        ["esMX"] = "Zim'Abwa",
        ["frFR"] = "Zim'Abwa",
        ["koKR"] = "짐아브와",
        ["ptBR"] = "Zim'Abwa",
        ["ruRU"] = "Зим'Абва",
        ["zhCN"] = "希姆埃巴",
        ["zhTW"] = "辛阿布瓦",
    },
    ["Amphitheater of Anguish"] = {
        ["enUS"] = true,
        ["deDE"] = "Amphitheater der Agonie",
        ["esES"] = "Anfiteatro de la Angustia",
        ["esMX"] = "Anfiteatro de la Angustia",
        ["frFR"] = "Amphithéâtre de l'Angoisse",
        ["koKR"] = "고뇌의 투기장",
        ["ptBR"] = "Anfiteatro da Angústia",
        ["ruRU"] = "Амфитеатр Страданий",
        ["zhCN"] = "痛苦斗兽场",
        ["zhTW"] = "苦痛露天競技場",
    },
    ["Altar of Rhunok"] = {
        ["enUS"] = true,
        ["deDE"] = "Altar von Rhunok",
        ["esES"] = "Altar de Rhunok",
        ["esMX"] = "Altar de Rhunok",
        ["frFR"] = "Autel de Rhunok",
        ["koKR"] = "루노크의 제단",
        ["ptBR"] = "Altar de Rhunok",
        ["ruRU"] = "Алтарь Рунока",
        ["zhCN"] = "伦诺克祭坛",
        ["zhTW"] = "魯諾克祭壇",
    },
    ["Altar of Har'koa"] = {
        ["enUS"] = true,
        ["deDE"] = "Altar von Har'koa",
        ["esES"] = "Altar de Har'koa",
        ["esMX"] = "Altar de Har'koa",
        ["frFR"] = "Autel de Har'koa",
        ["koKR"] = "하르코아의 제단",
        ["ptBR"] = "Altar de Har'koa",
        ["ruRU"] = "Алтарь Хар'коа",
        ["zhCN"] = "哈克娅祭坛",
        ["zhTW"] = "哈寇亞祭壇",
    },
    ["Zim'Torga"] = {
        ["enUS"] = true,
        ["deDE"] = "Zim'Torga",
        ["esES"] = "Zim'Torga",
        ["esMX"] = "Zim'Torga",
        ["frFR"] = "Zim'Torga",
        ["koKR"] = "짐토르가",
        ["ptBR"] = "Zim'Torga",
        ["ruRU"] = "Зим'Торга",
        ["zhCN"] = "希姆托加",
        ["zhTW"] = "辛托加",
    },
    ["Pools of Jin'Alai"] = {
        ["enUS"] = true,
        ["deDE"] = "Teiche von Jin'Alai",
        ["esES"] = "Pozas de Jin'Alai",
        ["esMX"] = "Pozas de Jin'Alai",
        ["frFR"] = "Bassins de Jin'Alai",
        ["koKR"] = "진알라이의 웅덩이",
        ["ptBR"] = "Poços de Jin'Alai",
        ["ruRU"] = "Бассейн Джин'Алаи",
        ["zhCN"] = "金亚莱之池",
        ["zhTW"] = "金阿萊之池",
    },
    ["Altar of Quetz'lun"] = {
        ["enUS"] = true,
        ["deDE"] = "Altar von Quetz'lun",
        ["esES"] = "Altar de Quetz'lun",
        ["esMX"] = "Altar de Quetz'lun",
        ["frFR"] = "Autel de Quetz'lun",
        ["koKR"] = "쿠에츠룬의 제단",
        ["ptBR"] = "Altar de Quetz'lun",
        ["ruRU"] = "Алтарь Кетц'лун",
        ["zhCN"] = "奎丝鲁恩祭坛",
        ["zhTW"] = "奎茲倫祭壇",
    },
    ["Heb'Drakkar"] = {
        ["enUS"] = true,
        ["deDE"] = "Heb'Drakkar",
        ["esES"] = "Heb'Drakkar",
        ["esMX"] = "Heb'Drakkar",
        ["frFR"] = "Heb'Drakkar",
        ["koKR"] = "헤브드라카",
        ["ptBR"] = "Heb'Drakkar",
        ["ruRU"] = "Хеб'Драккар",
        ["zhCN"] = "赫布达卡",
        ["zhTW"] = "希伯德拉卡",
    },
    ["Drak'Mabwa"] = {
        ["enUS"] = true,
        ["deDE"] = "Drak'Mabwa",
        ["esES"] = "Drak'Mabwa",
        ["esMX"] = "Drak'Mabwa",
        ["frFR"] = "Drak'Mabwa",
        ["koKR"] = "드락마브와",
        ["ptBR"] = "Drak'Mabwa",
        ["ruRU"] = "Драк'Мабва",
        ["zhCN"] = "达克玛瓦",
        ["zhTW"] = "德拉克瑪布瓦",
    },
    ["Zim'Rhuk"] = {
        ["enUS"] = true,
        ["deDE"] = "Zim'Rhuk",
        ["esES"] = "Zim'Rhuk",
        ["esMX"] = "Zim'Rhuk",
        ["frFR"] = "Zim'Rhuk",
        ["koKR"] = "짐루크",
        ["ptBR"] = "Zim'Rhuk",
        ["ruRU"] = "Зим'Рук",
        ["zhCN"] = "希姆鲁克",
        ["zhTW"] = "辛茹克",
    },
    ["Altar of Mam'toth"] = {
        ["enUS"] = true,
        ["deDE"] = "Altar von Mam'toth",
        ["esES"] = "Altar de Mam'toth",
        ["esMX"] = "Altar de Mam'toth",
        ["frFR"] = "Autel de Mam'toth",
        ["koKR"] = "맘토스의 제단",
        ["ptBR"] = "Altar de Mam'toth",
        ["ruRU"] = "Алтарь Мам'Тота",
        ["zhCN"] = "犸托斯祭坛",
        ["zhTW"] = "瑪姆托司祭壇",
    },
    ["Acherus: The Ebon Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Acherus: Die Schwarze Festung",
        ["esES"] = "Acherus: El Bastión de Ébano",
        ["esMX"] = "Acherus: El Bastión de Ébano",
        ["frFR"] = "Achérus : le fort d'Ébène",
        ["koKR"] = "아케루스: 칠흑의 요새",
        ["ptBR"] = "Áquerus: A Fortaleza de Ébano",
        ["ruRU"] = "Акерус: Черный оплот",
        ["zhCN"] = "阿彻鲁斯：黑锋要塞",
        ["zhTW"] = "亞榭洛:黯黑堡",
    },
    ["New Avalon"] = {
        ["enUS"] = true,
        ["deDE"] = "Neu-Avalon",
        ["esES"] = "Nuevo Avalon",
        ["esMX"] = "Nuevo Avalon",
        ["frFR"] = "Nouvelle-Avalon",
        ["koKR"] = "신 아발론",
        ["ptBR"] = "Nova Avalon",
        ["ruRU"] = "Новый Авалон",
        ["zhCN"] = "新阿瓦隆",
        ["zhTW"] = "新亞法隆",
    },
    ["New Avalon Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Felder von Neu-Avalon",
        ["esES"] = "Campos de Nuevo Avalon",
        ["esMX"] = "Campos de Nuevo Avalon",
        ["frFR"] = "Champs de la Nouvelle-Avalon",
        ["koKR"] = "신 아발론 농장",
        ["ptBR"] = "Campos de Nova Avalon",
        ["ruRU"] = "Поля Нового Авалона",
        ["zhCN"] = "新阿瓦隆农田",
        ["zhTW"] = "新亞法隆農地",
    },
    ["New Avalon Orchard"] = {
        ["enUS"] = true,
        ["deDE"] = "Obsthain von Neu-Avalon",
        ["esES"] = "Huerto de Nuevo Avalon",
        ["esMX"] = "Huerto de Nuevo Avalon",
        ["frFR"] = "Vergers de la Nouvelle-Avalon",
        ["koKR"] = "신 아발론 과수원",
        ["ptBR"] = "Pomar de Nova Avalon",
        ["ruRU"] = "Сад Нового Авалона",
        ["zhCN"] = "新阿瓦隆果园",
        ["zhTW"] = "新亞法隆果林",
    },
    ["New Avalon Town Hall"] = {
        ["enUS"] = true,
        ["deDE"] = "Rathaus von Neu-Avalon",
        ["esES"] = "Concejo de Nuevo Avalon",
        ["esMX"] = "Concejo de Nuevo Avalon",
        ["frFR"] = "Hôtel de ville de la Nouvelle-Avalon",
        ["koKR"] = "신 아발론 마을회관",
        ["ptBR"] = "Prefeitura de Nova Avalon",
        ["ruRU"] = "Ратуша Нового Авалона",
        ["zhCN"] = "新阿瓦隆市政厅",
        ["zhTW"] = "新亞法隆市政廳",
    },
    ["Havenshire"] = {
        ["enUS"] = true,
        ["deDE"] = "Havenau",
        ["esES"] = "Villa Refugio",
        ["esMX"] = "Villa Refugio",
        ["frFR"] = "Havre-comté",
        ["koKR"] = "헤이븐샤이어",
        ["ptBR"] = "Vila do Amparo",
        ["ruRU"] = "Тихоземье",
        ["zhCN"] = "海文郡",
        ["zhTW"] = "避風郡",
    },
    ["Havenshire Farms"] = {
        ["enUS"] = true,
        ["deDE"] = "Höfe von Havenau",
        ["esES"] = "Granjas de Villa Refugio",
        ["esMX"] = "Granjas de Villa Refugio",
        ["frFR"] = "Fermes de Havre-comté",
        ["koKR"] = "헤이븐샤이어 농장",
        ["ptBR"] = "Fazendas da Vila do Amparo",
        ["ruRU"] = "Тихоземские фермы",
        ["zhCN"] = "海文郡农场",
        ["zhTW"] = "避風郡農場",
    },
    ["Havenshire Lumber Mill"] = {
        ["enUS"] = true,
        ["deDE"] = "Sägewerk von Havenau",
        ["esES"] = "Serrería de Villa Refugio",
        ["esMX"] = "Serrería de Villa Refugio",
        ["frFR"] = "Scierie de Havre-comté",
        ["koKR"] = "헤이븐샤이어 제재소",
        ["ptBR"] = "Serraria Vila do Amparo",
        ["ruRU"] = "Тихоземская лесопилка",
        ["zhCN"] = "海文郡伐木场",
        ["zhTW"] = "避風郡伐木場",
    },
    ["Havenshire Stables"] = {
        ["enUS"] = true,
        ["deDE"] = "Ställe von Havenau",
        ["esES"] = "Establos de Villa Refugio",
        ["esMX"] = "Establos de Villa Refugio",
        ["frFR"] = "Écurie de Havre-comté",
        ["koKR"] = "헤이븐샤이어 마구간",
        ["ptBR"] = "Estábulos da Vila do Amparo",
        ["ruRU"] = "Тихоземские стойла",
        ["zhCN"] = "海文郡马厩",
        ["zhTW"] = "避風郡獸欄",
    },
    ["Scarlet Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Scharlachrote Festung",
        ["esES"] = "El Bastión Escarlata",
        ["esMX"] = "El Bastión Escarlata",
        ["frFR"] = "Fort écarlate",
        ["koKR"] = "붉은십자군 요새",
        ["ptBR"] = "Castelo Escarlate",
        ["ruRU"] = "Крепость Алого ордена",
        ["zhCN"] = "血色城堡",
        ["zhTW"] = "血色堡",
    },
    ["Chapel of the Crimson Flame"] = {
        ["enUS"] = true,
        ["deDE"] = "Kapelle der Scharlachroten Flamme",
        ["esES"] = "Capilla de la Llama Carmesí",
        ["esMX"] = "Capilla de la Llama Carmesí",
        ["frFR"] = "Chapelle de la Flamme cramoisie",
        ["koKR"] = "진홍불꽃의 예배당",
        ["ptBR"] = "Capela da Chama Carmesim",
        ["ruRU"] = "Часовня Багрового Пламени",
        ["zhCN"] = "赤色烈焰礼拜堂",
        ["zhTW"] = "赤紅之焰禮拜堂",
    },
    ["Light's Point Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Lichtgipfelturm",
        ["esES"] = "Torre de la Punta de la Luz",
        ["esMX"] = "Torre de la Punta de la Luz",
        ["frFR"] = "Tour de la halte de la Lumière",
        ["koKR"] = "빛의 거점탑",
        ["ptBR"] = "Torre Ponto de Luz",
        ["ruRU"] = "Башня Заставы Света",
        ["zhCN"] = "圣光哨塔",
        ["zhTW"] = "聖光之尖哨塔",
    },
    ["Light's Point"] = {
        ["enUS"] = true,
        ["deDE"] = "Lichtgipfel",
        ["esES"] = "Punta de la Luz",
        ["esMX"] = "Punta de la Luz",
        ["frFR"] = "Halte de la Lumière",
        ["koKR"] = "빛의 거점",
        ["ptBR"] = "Pontal da Luz",
        ["ruRU"] = "Застава Света",
        ["zhCN"] = "圣光哨站",
        ["zhTW"] = "聖光之尖",
    },
    ["Crypt of Remembrance"] = {
        ["enUS"] = true,
        ["deDE"] = "Krypta der Erinnerung",
        ["esES"] = "Cripta de los Recuerdos",
        ["esMX"] = "Cripta de los Recuerdos",
        ["frFR"] = "La crypte du Souvenir",
        ["koKR"] = "기념 납골당",
        ["ptBR"] = "Cripta da Memória",
        ["ruRU"] = "Склеп Воспоминаний",
        ["zhCN"] = "追忆墓穴",
        ["zhTW"] = "緬懷墓穴",
    },
    ["The Noxious Glade"] = {
        ["enUS"] = true,
        ["deDE"] = "Das giftige Tal",
        ["esES"] = "El Claro Ponzoñoso",
        ["esMX"] = "El Claro Ponzoñoso",
        ["frFR"] = "La Clairière nocive",
        ["koKR"] = "맹독의 숲",
        ["ptBR"] = "Clareira Nociva",
        ["ruRU"] = "Ядовитая поляна",
        ["zhCN"] = "剧毒林地",
        ["zhTW"] = "劇毒林地",
    },
    ["Tyr's Hand"] = {
        ["enUS"] = true,
        ["deDE"] = "Tyrs Hand",
        ["esES"] = "Mano de Tyr",
        ["esMX"] = "Mano de Tyr",
        ["frFR"] = "Main de Tyr",
        ["koKR"] = "티르의 손 수도원",
        ["ptBR"] = "Manopla de Tyr",
        ["ruRU"] = "Длань Тира",
        ["zhCN"] = "提尔之手",
        ["zhTW"] = "提爾之手",
    },
    ["King's Harbor"] = {
        ["enUS"] = true,
        ["deDE"] = "Hafen des Königs",
        ["esES"] = "Puerto del Rey",
        ["esMX"] = "Puerto del Rey",
        ["frFR"] = "Port-royal",
        ["koKR"] = "왕의 항구",
        ["ptBR"] = "Porto Real",
        ["ruRU"] = "Королевская гавань",
        ["zhCN"] = "国王港",
        ["zhTW"] = "國王港",
    },
    ["Scarlet Overlook"] = {
        ["enUS"] = true,
        ["deDE"] = "Scharlachroter Rundblick",
        ["esES"] = "Mirador Escarlata",
        ["esMX"] = "Mirador Escarlata",
        ["frFR"] = "Le surplomb Écarlate",
        ["koKR"] = "붉은십자군 전망대",
        ["ptBR"] = "Penhasco Escarlate",
        ["ruRU"] = "Дозорное укрепление Алого ордена",
        ["zhCN"] = "血色悬崖",
        ["zhTW"] = "血色瞰臺",
    },
    ["Light's Hope Chapel"] = {
        ["enUS"] = true,
        ["deDE"] = "Kapelle des hoffnungsvollen Lichts",
        ["esES"] = "Capilla de la Esperanza de la Luz",
        ["esMX"] = "Capilla de la Esperanza de la Luz",
        ["frFR"] = "Chapelle de l'Espoir de Lumière",
        ["koKR"] = "희망의 빛 예배당",
        ["ptBR"] = "Capela Esperança da Luz",
        ["ruRU"] = "Часовня Последней Надежды",
        ["zhCN"] = "圣光之愿礼拜堂",
        ["zhTW"] = "聖光之願禮拜堂",
    },
    ["Sinner's Folly"] = {
        ["enUS"] = true,
        ["deDE"] = "Sündenbabel",
        ["esES"] = "Locura del Pecador",
        ["esMX"] = "Locura del Pecador",
        ["frFR"] = "Folie du pécheur",
        ["koKR"] = "불신자의 만용호",
        ["ptBR"] = "Extravagância do Pecador",
        ["ruRU"] = "Глупость Грешника",
        ["zhCN"] = "罪人的愚行",
        ["zhTW"] = "罪人愚行號",
    },
    ["Pestilent Scar"] = {
        ["enUS"] = true,
        ["deDE"] = "Pestilenznarbe",
        ["esES"] = "Cicatriz Pestilente",
        ["esMX"] = "Cicatriz Pestilente",
        ["frFR"] = "Balafre pestilentielle",
        ["koKR"] = "전염의 흉터",
        ["ptBR"] = "Cicatriz Pestilenta",
        ["ruRU"] = "Моровой овраг",
        ["zhCN"] = "瘟疫之痕",
        ["zhTW"] = "瘟疫之痕",
    },
    ["Browman Mill"] = {
        ["enUS"] = true,
        ["deDE"] = "Braumanns Mühle",
        ["esES"] = "Molino Cejifrente",
        ["esMX"] = "Molino Cejifrente",
        ["frFR"] = "Scierie de Browman",
        ["koKR"] = "브라우만 밀농장",
        ["ptBR"] = "Engenho Assombrado",
        ["ruRU"] = "Лесопилка Бровача",
        ["zhCN"] = "布洛米尔",
        ["zhTW"] = "布洛米爾",
    },
    ["Havenshire Mine"] = {
        ["enUS"] = true,
        ["deDE"] = "Mine von Havenau",
        ["esES"] = "Mina de Villa Refugio",
        ["esMX"] = "Mina de Villa Refugio",
        ["frFR"] = "Mine de Havre-comté",
        ["koKR"] = "헤이븐샤이어 광산",
        ["ptBR"] = "Mina da Vila do Amparo",
        ["ruRU"] = "Тихоземская шахта",
        ["zhCN"] = "海文郡矿洞",
        ["zhTW"] = "避風郡礦坑",
    },
    ["Ursoc's Den"] = {
        ["enUS"] = true,
        ["deDE"] = "Ursocs Höhle",
        ["esES"] = "El Cubil de Ursoc",
        ["esMX"] = "El Cubil de Ursoc",
        ["frFR"] = "Tanière d'Ursoc",
        ["koKR"] = "우르속의 동굴",
        ["ptBR"] = "Covil de Ursoc",
        ["ruRU"] = "Логово Урсока",
        ["zhCN"] = "乌索克之巢",
        ["zhTW"] = "厄索克之穴",
    },
    ["The Bonefields"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Knochenfelder",
        ["esES"] = "Los Campos de Huesos",
        ["esMX"] = "Los Campos de Huesos",
        ["frFR"] = "Les champs d'Ossements",
        ["koKR"] = "뼈의 언덕",
        ["ptBR"] = "Os Campos de Ossos",
        ["ruRU"] = "Поля Костей",
        ["zhCN"] = "埋骨地",
        ["zhTW"] = "白骨原野",
    },
    ["Dorian's Outpost"] = {
        ["enUS"] = true,
        ["deDE"] = "Dorians Außenposten",
        ["esES"] = "Avanzada de Dorian",
        ["esMX"] = "Avanzada de Dorian",
        ["frFR"] = "Avant-poste de Dorian",
        ["koKR"] = "도리안의 전초기지",
        ["ptBR"] = "Posto Avançado de Dorian",
        ["ruRU"] = "Форпост Дориана",
        ["zhCN"] = "多里安哨站",
        ["zhTW"] = "多里安前哨",
    },
    ["Mam'toth Crater"] = {
        ["enUS"] = true,
        ["deDE"] = "Krater Mam'toth",
        ["esES"] = "Cráter de Mam'toth",
        ["esMX"] = "Cráter de Mam'toth",
        ["frFR"] = "Cratère de Mam'toth",
        ["koKR"] = "맘토스 분화구",
        ["ptBR"] = "Cratera de Mam'toth",
        ["ruRU"] = "Кратер Мам'Тота",
        ["zhCN"] = "犸托斯巨坑",
        ["zhTW"] = "瑪姆托司爆坑",
    },
    ["Zol'Maz Stronghold"] = {
        ["enUS"] = true,
        ["deDE"] = "Festung Zol'Maz",
        ["esES"] = "Bastión de Zol'Maz",
        ["esMX"] = "Bastión de Zol'Maz",
        ["frFR"] = "Bastion de Zol'Maz",
        ["koKR"] = "졸마즈 요새",
        ["ptBR"] = "Fortaleza de Zol'Maz",
        ["ruRU"] = "Крепость Зол'Маз",
        ["zhCN"] = "佐尔玛兹要塞",
        ["zhTW"] = "佐爾馬茲堡砦",
    },
    ["Zol'Heb"] = {
        ["enUS"] = true,
        ["deDE"] = "Zol'Heb",
        ["esES"] = "Zol'Heb",
        ["esMX"] = "Zol'Heb",
        ["frFR"] = "Zol'Heb",
        ["koKR"] = "졸헤브",
        ["ptBR"] = "Zol'Heb",
        ["ruRU"] = "Зол'Хеб",
        ["zhCN"] = "佐尔赫布",
        ["zhTW"] = "佐爾希伯",
    },
    ["Rageclaw Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Zornklauensee",
        ["esES"] = "Lago de Garrafuria",
        ["esMX"] = "Lago de Garrafuria",
        ["frFR"] = "Lac Grifferage",
        ["koKR"] = "성난발톱 호수",
        ["ptBR"] = "Lago Patafúria",
        ["ruRU"] = "Озеро Яростного Когтя",
        ["zhCN"] = "怒爪湖",
        ["zhTW"] = "怒爪湖",
    },
    ["The Savage Thicket"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Wilde Dickicht",
        ["esES"] = "El Matorral Silvestre",
        ["esMX"] = "El Matorral Silvestre",
        ["frFR"] = "Le fourré Sauvage",
        ["koKR"] = "야만의 숲",
        ["ptBR"] = "Floresta Selvagem",
        ["ruRU"] = "Дикая чаща",
        ["zhCN"] = "蛮荒树林",
        ["zhTW"] = "蠻荒灌木林",
    },
    ["New Avalon Forge"] = {
        ["enUS"] = true,
        ["deDE"] = "Schmiede von Neu-Avalon",
        ["esES"] = "Forja de Nuevo Avalon",
        ["esMX"] = "Forja de Nuevo Avalon",
        ["frFR"] = "Forge de la Nouvelle-Avalon",
        ["koKR"] = "신 아발론 대장간",
        ["ptBR"] = "Forja de Nova Avalon",
        ["ruRU"] = "Кузня Нового Авалона",
        ["zhCN"] = "新阿瓦隆熔炉",
        ["zhTW"] = "新亞法隆熔爐",
    },
    ["Dalaran Arena"] = {
        ["enUS"] = true,
        ["deDE"] = "Arena von Dalaran",
        ["esES"] = "Arena de Dalaran",
        ["esMX"] = "Arena de Dalaran",
        ["frFR"] = "Arène de Dalaran",
        ["koKR"] = "달라란 투기장",
        ["ptBR"] = "Arena de Dalaran",
        ["ruRU"] = "Арена Даларана",
        ["zhCN"] = "达拉然竞技场",
        ["zhTW"] = "達拉然競技場",
    },
    ["Westguard Inn"] = {
        ["enUS"] = true,
        ["deDE"] = "Gasthaus der Westwacht",
        ["esES"] = "Taberna de Guardia Oeste",
        ["esMX"] = "Taberna de Guardia Oeste",
        ["frFR"] = "Auberge de la Garde de l'ouest",
        ["koKR"] = "서부경비대 여관",
        ["ptBR"] = "Estalagem da Guarda Oeste",
        ["ruRU"] = "Таверна Западной Стражи",
        ["zhCN"] = "西部卫戍要塞旅店",
        ["zhTW"] = "鎮西旅店",
    },
    ["Waygate"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Tor",
        ["esES"] = "Puerta",
        ["esMX"] = "Puerta",
        ["frFR"] = "Portail d'accès",
        ["koKR"] = "차원문",
        ["ptBR"] = "Pórtico",
        ["ruRU"] = "Связующая спираль",
        ["zhCN"] = "界门",
        ["zhTW"] = "甬道之門",
    },
    ["The Shaper's Terrace"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Terrasse des Formers",
        ["esES"] = "El Bancal del Creador",
        ["esMX"] = "El Bancal del Creador",
        ["frFR"] = "La terrasse du Façonneur",
        ["koKR"] = "구체자의 정원",
        ["ptBR"] = "O Terraço do Moldador",
        ["ruRU"] = "Терраса Создателя",
        ["zhCN"] = "塑造者之台",
        ["zhTW"] = "塑造者殿堂",
    },
    ["Strand of the Ancients"] = {
        ["enUS"] = true,
        ["deDE"] = "Strand der Uralten",
        ["esES"] = "Playa de los Ancestros",
        ["esMX"] = "Playa de los Ancestros",
        ["frFR"] = "Rivage des Anciens",
        ["koKR"] = "고대의 해안",
        ["ptBR"] = "Baía dos Ancestrais",
        ["ruRU"] = "Берег Древних",
        ["zhCN"] = "远古海滩",
        ["zhTW"] = "遠祖灘頭",
    },
    ["Bittertide Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Bittertidensee",
        ["esES"] = "Lago Olamarga",
        ["esMX"] = "Lago Olamarga",
        ["frFR"] = "Lac de Flot-amer",
        ["koKR"] = "거센물결 호수",
        ["ptBR"] = "Lago Maremarga",
        ["ruRU"] = "Озеро Горьких Волн",
        ["zhCN"] = "苦潮湖",
        ["zhTW"] = "惡潮湖",
    },
    ["The Suntouched Pillar"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Sonnenstrahlsäule",
        ["esES"] = "El Pilar Toquesol",
        ["esMX"] = "El Pilar Toquesol",
        ["frFR"] = "Le pilier Solegrâce",
        ["koKR"] = "해마루 봉우리",
        ["ptBR"] = "Pilar Tocado pelo Sol",
        ["ruRU"] = "Колонна Солнечного Благословения",
        ["zhCN"] = "日灼之柱",
        ["zhTW"] = "日觸之柱",
    },
    ["Frigid Breach"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Eisbresche",
        ["esES"] = "Brecha Gélida",
        ["esMX"] = "Brecha Gélida",
        ["frFR"] = "Brèche algide",
        ["koKR"] = "얼어붙은 틈",
        ["ptBR"] = "Pontal Frio",
        ["ruRU"] = "Хладный разлом",
        ["zhCN"] = "冰冷裂口",
        ["zhTW"] = "嚴寒止境",
    },
    ["Swindlegrin's Dig"] = {
        ["enUS"] = true,
        ["deDE"] = "Schwindelgrins' Grabungsstätte",
        ["esES"] = "Excavación de Timomueca",
        ["esMX"] = "Excavación de Timomueca",
        ["frFR"] = "Site de fouilles de Ricarnaque",
        ["koKR"] = "스윈들그린의 채굴현장",
        ["ptBR"] = "Escavação do Caloteiro",
        ["ruRU"] = "Раскоп Хитрохмыла",
        ["zhCN"] = "斯温迪格林挖掘场",
        ["zhTW"] = "詐咧挖掘場",
    },
    ["The Stormwright's Shelf"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Sturmherrenschelf",
        ["esES"] = "La Plataforma del Tormentoso",
        ["esMX"] = "La Plataforma del Tormentoso",
        ["frFR"] = "La saillie de Forgetempête",
        ["koKR"] = "폭풍전령 바위",
        ["ptBR"] = "Prateleira do Criador da Tempestade",
        ["ruRU"] = "Уступ Ваятеля Бурь",
        ["zhCN"] = "雷暴台地",
        ["zhTW"] = "風暴工匠沙洲",
    },
    ["Death's Hand Encampment"] = {
        ["enUS"] = true,
        ["deDE"] = "Lager der Todeshand",
        ["esES"] = "Campamento Mano de la Muerte",
        ["esMX"] = "Campamento Mano de la Muerte",
        ["frFR"] = "Campement de la Main de Mort",
        ["koKR"] = "죽음의 손 야영지",
        ["ptBR"] = "Posto Avançado Mão da Morte",
        ["ruRU"] = "Лагерь Руки Смерти",
        ["zhCN"] = "死亡之手营地",
        ["zhTW"] = "死亡之手駐營",
    },
    ["Scarlet Tavern"] = {
        ["enUS"] = true,
        ["deDE"] = "Scharlachrote Taverne",
        ["esES"] = "Taberna Escarlata",
        ["esMX"] = "Taberna Escarlata",
        ["frFR"] = "Taverne écarlate",
        ["koKR"] = "붉은십자군 선술집",
        ["ptBR"] = "Taberna Escarlate",
        ["ruRU"] = "Таверна Алого ордена",
        ["zhCN"] = "血色旅店",
        ["zhTW"] = "血色旅店",
    },
    ["Dalaran"] = {
        ["enUS"] = true,
        ["deDE"] = "Dalaran",
        ["esES"] = "Dalaran",
        ["esMX"] = "Dalaran",
        ["frFR"] = "Dalaran",
        ["koKR"] = "달라란",
        ["ptBR"] = "Dalaran",
        ["ruRU"] = "Даларан",
        ["zhCN"] = "达拉然",
        ["zhTW"] = "達拉然",
    },
    ["Nozzlerust Post"] = {
        ["enUS"] = true,
        ["deDE"] = "Düsenrostposten",
        ["esES"] = "Puesto Boquilla Oxidada",
        ["esMX"] = "Puesto Boquilla Oxidada",
        ["frFR"] = "Poste de Rouilletuyère",
        ["koKR"] = "녹주둥이 전초기지",
        ["ptBR"] = "Posto Ferrugem",
        ["ruRU"] = "Лагерь Соплозабилось",
        ["zhCN"] = "诺兹拉斯哨站",
        ["zhTW"] = "鏽鼻崗哨",
    },
    ["Farshire Mine"] = {
        ["enUS"] = true,
        ["deDE"] = "Mine von Fernhain",
        ["esES"] = "Mina de Lindeallá",
        ["esMX"] = "Mina de Lindeallá",
        ["frFR"] = "Mine de Comté-lointaine",
        ["koKR"] = "파샤이어 광산",
        ["ptBR"] = "Mina de Algures",
        ["ruRU"] = "Шахта Далечья",
        ["zhCN"] = "致远郡矿洞",
        ["zhTW"] = "遠郡礦坑",
    },
    ["The Mosslight Pillar"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Mooslichtsäule",
        ["esES"] = "El Pilar Musgoluz",
        ["esMX"] = "El Pilar Musgoluz",
        ["frFR"] = "Le pilier Mousselume",
        ["koKR"] = "이끼빛 봉우리",
        ["ptBR"] = "Pilar Verdeluz",
        ["ruRU"] = "Колонна Мохосвета",
        ["zhCN"] = "苔光之柱",
        ["zhTW"] = "苔光之柱",
    },
    ["Saragosa's Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Saragosas Landeplatz",
        ["esES"] = "Alto de Saragosa",
        ["esMX"] = "Alto de Saragosa",
        ["frFR"] = "Aire de Saragosa",
        ["koKR"] = "사라고사의 영지",
        ["ptBR"] = "Patamar de Saragosa",
        ["ruRU"] = "Лагерь Сарагосы",
        ["zhCN"] = "莎拉苟萨平台",
        ["zhTW"] = "薩拉苟莎臺地",
    },
    ["Vengeance Lift"] = {
        ["enUS"] = true,
        ["deDE"] = "Blutklammlift",
        ["esES"] = "Elevador de Venganza",
        ["esMX"] = "Elevador de Venganza",
        ["frFR"] = "Ascenseur de la vengeance",
        ["koKR"] = "복수의 승강장",
        ["ptBR"] = "Elevador da Vingança",
        ["ruRU"] = "Подъемник лагеря Возмездия",
        ["zhCN"] = "复仇升降梯",
        ["zhTW"] = "復仇升降梯",
    },
    ["Balejar Watch"] = {
        ["enUS"] = true,
        ["deDE"] = "Balejarwacht",
        ["esES"] = "Avanzada Balejar",
        ["esMX"] = "Avanzada Balejar",
        ["frFR"] = "Guet de Balejar",
        ["koKR"] = "베일야르 감시초소",
        ["ptBR"] = "Posto Balejar",
        ["ruRU"] = "Застава Баледжара",
        ["zhCN"] = "拜尔亚岗哨",
        ["zhTW"] = "貝爾亞守望",
    },
    ["New Agamand Inn"] = {
        ["enUS"] = true,
        ["deDE"] = "Gasthaus von Neu-Agamand",
        ["esES"] = "Posada de Nuevo Agamand",
        ["esMX"] = "Posada de Nuevo Agamand",
        ["frFR"] = "Auberge de la Nouvelle-Agamand",
        ["koKR"] = "신 아가만드 여관",
        ["ptBR"] = "Estalagem de Nova Agamand",
        ["ruRU"] = "Таверна Нового Агамонда",
        ["zhCN"] = "新阿加曼德旅店",
        ["zhTW"] = "新阿加曼德旅店",
    },
    ["Passage of Lost Fiends"] = {
        ["enUS"] = true,
        ["deDE"] = "Pass der verlorenen Geister",
        ["esES"] = "Pasaje de los Malignos Perdidos",
        ["esMX"] = "Pasaje de los Malignos Perdidos",
        ["frFR"] = "Passage des démons perdus",
        ["koKR"] = "잃어버린 악마의 통로",
        ["ptBR"] = "Passagem dos Demônios Perdidos",
        ["ruRU"] = "Перевал Заблудившихся Злодеев",
        ["zhCN"] = "迷失恶魔之路",
        ["zhTW"] = "失落惡魔通道",
    },
    ["The Ring of Valor"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ring der Ehre",
        ["esES"] = "El Círculo del Valor",
        ["esMX"] = "El Círculo del Valor",
        ["frFR"] = "L'Arène des valeureux",
        ["koKR"] = "용맹의 투기장",
        ["ptBR"] = "Ringue dos Valorosos",
        ["ruRU"] = "Арена Доблести",
        ["zhCN"] = "勇气竞技场",
        ["zhTW"] = "勇武之環",
    },
    ["Hall of the Frostwolf"] = {
        ["enUS"] = true,
        ["deDE"] = "Halle der Frostwölfe",
        ["esES"] = "Cámara de los Lobo Gélido",
        ["esMX"] = "Cámara de los Lobo Gélido",
        ["frFR"] = "Hall des Loups-de-givre",
        ["koKR"] = "서리늑대 전당",
        ["ptBR"] = "Salão do Lobo do Gelo",
        ["ruRU"] = "Зал Северного Волка",
        ["zhCN"] = "霜狼大厅",
        ["zhTW"] = "霜狼大廳",
    },
    ["Hall of the Stormpike"] = {
        ["enUS"] = true,
        ["deDE"] = "Halle der Sturmlanzen",
        ["esES"] = "Cámara de los Pico Tormenta",
        ["esMX"] = "Cámara de los Pico Tormenta",
        ["frFR"] = "Hall des Foudrepiques",
        ["koKR"] = "스톰파이크 전당",
        ["ptBR"] = "Salão de Lançatroz",
        ["ruRU"] = "Зал Грозовой Вершины",
        ["zhCN"] = "雷矛大厅",
        ["zhTW"] = "雷矛大廳",
    },
    ["Stormwind Harbor"] = {
        ["enUS"] = true,
        ["deDE"] = "Hafen von Sturmwind",
        ["esES"] = "Puerto de Ventormenta",
        ["esMX"] = "Puerto de Ventormenta",
        ["frFR"] = "Port de Hurlevent",
        ["koKR"] = "스톰윈드 항구",
        ["ptBR"] = "Porto de Ventobravo",
        ["ruRU"] = "Порт Штормграда",
        ["zhCN"] = "暴风城港口",
        ["zhTW"] = "暴風港",
    },
    ["The Makers' Overlook"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Warte der Schöpfer",
        ["esES"] = "El Mirador de los Creadores",
        ["esMX"] = "El Mirador de los Creadores",
        ["frFR"] = "Le surplomb du Faiseur",
        ["koKR"] = "창조주의 전망대",
        ["ptBR"] = "Mirante dos Criadores",
        ["ruRU"] = "Дозор Творцов",
        ["zhCN"] = "造物者悬台",
        ["zhTW"] = "造物者瞰臺",
    },
    ["The Makers' Perch"] = {
        ["enUS"] = true,
        ["deDE"] = "Hort der Schöpfer",
        ["esES"] = "El Pedestal de los Creadores",
        ["esMX"] = "El Pedestal de los Creadores",
        ["frFR"] = "Perchoir du Faiseur",
        ["koKR"] = "창조주의 감시대",
        ["ptBR"] = "Alcândora dos Criadores",
        ["ruRU"] = "Обитель Творцов",
        ["zhCN"] = "造物者之座",
        ["zhTW"] = "造物者棲所",
    },
    ["Scarlet Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Scharlachroter Turm",
        ["esES"] = "Torre Escarlata",
        ["esMX"] = "Torre Escarlata",
        ["frFR"] = "Tour écarlate",
        ["koKR"] = "붉은십자군 경비탑",
        ["ptBR"] = "Torre Escarlate",
        ["ruRU"] = "Алая башня",
        ["zhCN"] = "血色哨塔",
        ["zhTW"] = "血色哨塔",
    },
    ["Onslaught Harbor"] = {
        ["enUS"] = true,
        ["deDE"] = "Hafen des Ansturms",
        ["esES"] = "Puerto del Embate",
        ["esMX"] = "Puerto del Embate",
        ["frFR"] = "Port de l'Assaut",
        ["koKR"] = "붉은돌격대 항구",
        ["ptBR"] = "Porto da Ofensiva",
        ["ruRU"] = "Гавань Натиска",
        ["zhCN"] = "先锋军港口",
        ["zhTW"] = "突襲軍港口",
    },
    ["K3"] = {
        ["enUS"] = true,
        ["deDE"] = "K3",
        ["esES"] = "K3",
        ["esMX"] = "K3",
        ["frFR"] = "K3",
        ["koKR"] = "K3",
        ["ptBR"] = "K3",
        ["ruRU"] = "К-3",
        ["zhCN"] = "K3",
        ["zhTW"] = "K3",
    },
    ["Snowblind Hills"] = {
        ["enUS"] = true,
        ["deDE"] = "Blendschneehügel",
        ["esES"] = "Colinas Veloneve",
        ["esMX"] = "Colinas Veloneve",
        ["frFR"] = "Collines du Voile blanc",
        ["koKR"] = "설맹의 언덕",
        ["ptBR"] = "Serra Ceganeve",
        ["ruRU"] = "Холмы Снежной Слепоты",
        ["zhCN"] = "雪盲岭",
        ["zhTW"] = "雪盲丘",
    },
    ["Snowblind Terrace"] = {
        ["enUS"] = true,
        ["deDE"] = "Blendschneeterrasse",
        ["esES"] = "Bancal Veloneve",
        ["esMX"] = "Bancal Veloneve",
        ["frFR"] = "Terrasse du Voile blanc",
        ["koKR"] = "설맹의 언덕 길목",
        ["ptBR"] = "Terraço Ceganeve",
        ["ruRU"] = "Терраса Снежной Слепоты",
        ["zhCN"] = "雪盲台地",
        ["zhTW"] = "雪盲殿堂",
    },
    ["Garm"] = {
        ["enUS"] = true,
        ["deDE"] = "Garm",
        ["esES"] = "Garm",
        ["esMX"] = "Garm",
        ["frFR"] = "Garm",
        ["koKR"] = "가름",
        ["ptBR"] = "Garm",
        ["ruRU"] = "Гарм",
        ["zhCN"] = "加姆",
        ["zhTW"] = "迦姆",
    },
    ["Brunnhildar Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Brunnhildar",
        ["esES"] = "Poblado Brunnhildar",
        ["esMX"] = "Poblado Brunnhildar",
        ["frFR"] = "Brunnhildar",
        ["koKR"] = "브룬힐다르 마을",
        ["ptBR"] = "Aldeia Brunnhildar",
        ["ruRU"] = "Деревня Бруннхильдар",
        ["zhCN"] = "布伦希尔达村",
        ["zhTW"] = "布倫希爾達村",
    },
    ["Sifreldar Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Sifreldar",
        ["esES"] = "Poblado Sifreldar",
        ["esMX"] = "Poblado Sifreldar",
        ["frFR"] = "Sifreldar",
        ["koKR"] = "시프렐다르 마을",
        ["ptBR"] = "Aldeia Sifreldar",
        ["ruRU"] = "Деревня Сифрельдар",
        ["zhCN"] = "希弗列尔达村",
        ["zhTW"] = "希弗爾達村",
    },
    ["Valkyrion"] = {
        ["enUS"] = true,
        ["deDE"] = "Valkyrion",
        ["esES"] = "Valkyrion",
        ["esMX"] = "Valkyrion",
        ["frFR"] = "Valkyrion",
        ["koKR"] = "발키리온",
        ["ptBR"] = "Valkyrion",
        ["ruRU"] = "Валькирион",
        ["zhCN"] = "瓦基里安",
        ["zhTW"] = "華爾基倫",
    },
    ["The Forlorn Mine"] = {
        ["enUS"] = true,
        ["deDE"] = "Die verlassene Mine",
        ["esES"] = "La Mina Desolada",
        ["esMX"] = "La Mina Desolada",
        ["frFR"] = "La mine Lugubre",
        ["koKR"] = "쓸쓸한 광산",
        ["ptBR"] = "Mina Esquecida",
        ["ruRU"] = "Заброшенный рудник",
        ["zhCN"] = "荒弃矿洞",
        ["zhTW"] = "凋落礦坑",
    },
    ["Bor's Breath River"] = {
        ["enUS"] = true,
        ["deDE"] = "Bors Atemstrom",
        ["esES"] = "Río del Aliento de Bor",
        ["esMX"] = "Río del Aliento de Bor",
        ["frFR"] = "Le Souffle de Bor",
        ["koKR"] = "보르의 숨결 강",
        ["ptBR"] = "Rio Vale de Bor",
        ["ruRU"] = "Река Дыхания Бора",
        ["zhCN"] = "伯尔之息河",
        ["zhTW"] = "伯爾之息河谷",
    },
    ["Argent Vanguard"] = {
        ["enUS"] = true,
        ["deDE"] = "Argentumvorhut",
        ["esES"] = "Vanguardia Argenta",
        ["esMX"] = "Vanguardia Argenta",
        ["frFR"] = "L'avant-garde d'Argent",
        ["koKR"] = "은빛십자군 선봉기지",
        ["ptBR"] = "Vanguarda Argêntea",
        ["ruRU"] = "Оплот Серебряного Авангарда",
        ["zhCN"] = "银色前线基地",
        ["zhTW"] = "銀白先鋒駐地",
    },
    ["Frosthold"] = {
        ["enUS"] = true,
        ["deDE"] = "Eisfestung",
        ["esES"] = "Fuerte Escarcha",
        ["esMX"] = "Fuerte Escarcha",
        ["frFR"] = "Fort du Givre",
        ["koKR"] = "서리요새",
        ["ptBR"] = "Fortaleza Gelada",
        ["ruRU"] = "Ледяная крепость",
        ["zhCN"] = "冰霜堡",
        ["zhTW"] = "霜堡",
    },
    ["Grom'arsh Crash-Site"] = {
        ["enUS"] = true,
        ["deDE"] = "Absturzstelle Grom'ash",
        ["esES"] = "Lugar del accidente de Grom'arsh",
        ["esMX"] = "Lugar del accidente de Grom'arsh",
        ["frFR"] = "Point d'impact de Grom'arsh",
        ["koKR"] = "그롬아쉬 추락 지점",
        ["ptBR"] = "Local da Queda de Grom'arsh",
        ["ruRU"] = "Место крушения Гром'арша",
        ["zhCN"] = "格罗玛什坠毁点",
        ["zhTW"] = "葛羅姆亞什失事地",
    },
    ["Temple of Storms"] = {
        ["enUS"] = true,
        ["deDE"] = "Tempel der Stürme",
        ["esES"] = "Templo de las Tormentas",
        ["esMX"] = "Templo de las Tormentas",
        ["frFR"] = "Temple des Tempêtes",
        ["koKR"] = "폭풍의 신전",
        ["ptBR"] = "Templo das Tempestades",
        ["ruRU"] = "Храм Штормов",
        ["zhCN"] = "风暴神殿",
        ["zhTW"] = "風暴神殿",
    },
    ["Engine of the Makers"] = {
        ["enUS"] = true,
        ["deDE"] = "Maschine der Schöpfer",
        ["esES"] = "Motor de los Creadores",
        ["esMX"] = "Motor de los Creadores",
        ["frFR"] = "Moteur des Faiseurs",
        ["koKR"] = "창조주의 기계",
        ["ptBR"] = "Maquinário dos Criadores",
        ["ruRU"] = "Машина Творцов",
        ["zhCN"] = "造物者引擎",
        ["zhTW"] = "造物者動力核心",
    },
    ["The Foot Steppes"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Fußmarschen",
        ["esES"] = "Las Estepas Inferiores",
        ["esMX"] = "Las Estepas Inferiores",
        ["frFR"] = "Le Pied-mont",
        ["koKR"] = "눈봉우리 분지",
        ["ptBR"] = "Estepes do Sopé",
        ["ruRU"] = "Подножие",
        ["zhCN"] = "山底平原",
        ["zhTW"] = "足跡冷原",
    },
    ["Dragonspine Peaks"] = {
        ["enUS"] = true,
        ["deDE"] = "Drachenwirbelgipfel",
        ["esES"] = "Cumbres Espinazo de Dragón",
        ["esMX"] = "Cumbres Espinazo de Dragón",
        ["frFR"] = "Pics de l'Epine-de-dragon",
        ["koKR"] = "용돌기 봉우리",
        ["ptBR"] = "Pico Espinodraco",
        ["ruRU"] = "Драконьи пики",
        ["zhCN"] = "龙脊之巅",
        ["zhTW"] = "龍脊群山",
    },
    ["Narvir's Cradle"] = {
        ["enUS"] = true,
        ["deDE"] = "Narvirs Wiege",
        ["esES"] = "Cuna de Narvir",
        ["esMX"] = "Cuna de Narvir",
        ["frFR"] = "Le berceau de Narvir",
        ["koKR"] = "나르비르의 요람",
        ["ptBR"] = "Berço de Narvir",
        ["ruRU"] = "Колыбель Нарвира",
        ["zhCN"] = "纳维尔支架",
        ["zhTW"] = "那維爾搖籃",
    },
    ["Valley of Ancient Winters"] = {
        ["enUS"] = true,
        ["deDE"] = "Das uralte Wintertal",
        ["esES"] = "Valle de los Viejos Inviernos",
        ["esMX"] = "Valle de los Viejos Inviernos",
        ["frFR"] = "La vallée des Anciens hivers",
        ["koKR"] = "고대의 겨울 계곡",
        ["ptBR"] = "Vale dos Antigos Invernos",
        ["ruRU"] = "Долина Древних Зим",
        ["zhCN"] = "上古寒冬山谷",
        ["zhTW"] = "遠古寒冬山谷",
    },
    ["Dun Niffelem"] = {
        ["enUS"] = true,
        ["deDE"] = "Dun Niffelem",
        ["esES"] = "Dun Niffelem",
        ["esMX"] = "Dun Niffelem",
        ["frFR"] = "Dun Niffelem",
        ["koKR"] = "던 니펠렘",
        ["ptBR"] = "Dun Niffelem",
        ["ruRU"] = "Дун Ниффелем",
        ["zhCN"] = "丹尼芬雷",
        ["zhTW"] = "丹尼弗蘭",
    },
    ["Frostfield Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Frostfeldsee",
        ["esES"] = "Lago Campo de Escarcha",
        ["esMX"] = "Lago Campo de Escarcha",
        ["frFR"] = "Lac du Champ-gelé",
        ["koKR"] = "서리평원 호수",
        ["ptBR"] = "Lago Congelado",
        ["ruRU"] = "Промерзшее озеро",
        ["zhCN"] = "霜原湖",
        ["zhTW"] = "霜域湖",
    },
    ["Thunderfall"] = {
        ["enUS"] = true,
        ["deDE"] = "Donnerfall",
        ["esES"] = "Truenotoño",
        ["esMX"] = "Truenotoño",
        ["frFR"] = "Chute-tonnerre",
        ["koKR"] = "천둥 골짜기",
        ["ptBR"] = "Tormentério",
        ["ruRU"] = "Громовержье",
        ["zhCN"] = "落雷谷",
        ["zhTW"] = "雷殞之地",
    },
    ["Camp Tunka'lo"] = {
        ["enUS"] = true,
        ["deDE"] = "Camp Tunka'lo",
        ["esES"] = "Campamento Tunka'lo",
        ["esMX"] = "Campamento Tunka'lo",
        ["frFR"] = "Camp Tunka'lo",
        ["koKR"] = "툰카로 야영지",
        ["ptBR"] = "Aldeia Tunka'lo",
        ["ruRU"] = "Лагерь Тунка’ло",
        ["zhCN"] = "唐卡洛营地",
        ["zhTW"] = "坦卡羅營地",
    },
    ["Brann's Base-Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Branns Basislager",
        ["esES"] = "Campamento base de Brann",
        ["esMX"] = "Campamento base de Brann",
        ["frFR"] = "Campement de Brann",
        ["koKR"] = "브란의 기지",
        ["ptBR"] = "Acampamento do Brann",
        ["ruRU"] = "Базовый лагерь Бранна",
        ["zhCN"] = "布莱恩的营地",
        ["zhTW"] = "布萊恩營地",
    },
    ["Gate of Echoes"] = {
        ["enUS"] = true,
        ["deDE"] = "Tor der Echos",
        ["esES"] = "Puerta de los Ecos",
        ["esMX"] = "Puerta de los Ecos",
        ["frFR"] = "Porte des Échos",
        ["koKR"] = "메아리 관문",
        ["ptBR"] = "Portão dos Ecos",
        ["ruRU"] = "Врата эха",
        ["zhCN"] = "回音之门",
        ["zhTW"] = "回聲之門",
    },
    ["Plain of Echoes"] = {
        ["enUS"] = true,
        ["deDE"] = "Ebene der Echos",
        ["esES"] = "Llanura de los Ecos",
        ["esMX"] = "Llanura de los Ecos",
        ["frFR"] = "Plaine des Échos",
        ["koKR"] = "메아리 평원",
        ["ptBR"] = "Planície dos Ecos",
        ["ruRU"] = "Равнина эха",
        ["zhCN"] = "回音平原",
        ["zhTW"] = "回聲平原",
    },
    ["Terrace of the Makers"] = {
        ["enUS"] = true,
        ["deDE"] = "Terrasse der Schöpfer",
        ["esES"] = "Bancal de los Creadores",
        ["esMX"] = "Bancal de los Creadores",
        ["frFR"] = "Terrasse des Faiseurs",
        ["koKR"] = "창조주의 거처",
        ["ptBR"] = "Terraço dos Criadores",
        ["ruRU"] = "Терраса Творцов",
        ["zhCN"] = "造物者圣台",
        ["zhTW"] = "造物者殿堂",
    },
    ["Gate of Lightning"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Blitztor",
        ["esES"] = "Puerta de los Rayos",
        ["esMX"] = "Puerta de los Rayos",
        ["frFR"] = "Porte de la Foudre",
        ["koKR"] = "번개의 관문",
        ["ptBR"] = "Pórtico dos Relâmpagos",
        ["ruRU"] = "Врата молнии",
        ["zhCN"] = "闪电之门",
        ["zhTW"] = "雷光之門",
    },
    ["Path of the Titans"] = {
        ["enUS"] = true,
        ["deDE"] = "Pfad der Titanen",
        ["esES"] = "Senda de los Titanes",
        ["esMX"] = "Senda de los Titanes",
        ["frFR"] = "Voie des Titans",
        ["koKR"] = "티탄의 길",
        ["ptBR"] = "Caminho dos Titãs",
        ["ruRU"] = "Путь Титанов",
        ["zhCN"] = "泰坦之路",
        ["zhTW"] = "泰坦之途",
    },
    ["Uldis"] = {
        ["enUS"] = true,
        ["deDE"] = "Uldis",
        ["esES"] = "Uldis",
        ["esMX"] = "Uldis",
        ["frFR"] = "Uldis",
        ["koKR"] = "울디스",
        ["ptBR"] = "Uldis",
        ["ruRU"] = "Ульдис",
        ["zhCN"] = "奥迪斯",
        ["zhTW"] = "奧迪斯",
    },
    ["Loken's Bargain"] = {
        ["enUS"] = true,
        ["deDE"] = "Lokens Handel",
        ["esES"] = "Acuerdo de Loken",
        ["esMX"] = "Acuerdo de Loken",
        ["frFR"] = "Marché de Loken",
        ["koKR"] = "로켄의 거래물",
        ["ptBR"] = "Barganha de Loken",
        ["ruRU"] = "Сделка Локена",
        ["zhCN"] = "洛肯的宝库",
        ["zhTW"] = "洛肯的交易地",
    },
    ["Bor's Fall"] = {
        ["enUS"] = true,
        ["deDE"] = "Bors Sturz",
        ["esES"] = "Caída de Bor",
        ["esMX"] = "Caída de Bor",
        ["frFR"] = "Chute de Bor",
        ["koKR"] = "보르의 폭포",
        ["ptBR"] = "Cascata de Bor",
        ["ruRU"] = "Водопад Бора",
        ["zhCN"] = "伯尔瀑布",
        ["zhTW"] = "伯爾瀑布",
    },
    ["Bor's Breath"] = {
        ["enUS"] = true,
        ["deDE"] = "Bors Atem",
        ["esES"] = "Aliento de Bor",
        ["esMX"] = "Aliento de Bor",
        ["frFR"] = "Souffle de Bor",
        ["koKR"] = "보르의 숨결",
        ["ptBR"] = "Vale de Bor",
        ["ruRU"] = "Дыхание Бора",
        ["zhCN"] = "伯尔之息",
        ["zhTW"] = "伯爾之息",
    },
    ["Rohemdal Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Rohemdalpass",
        ["esES"] = "Paso de Rohemdal",
        ["esMX"] = "Paso de Rohemdal",
        ["frFR"] = "Passe de Rohemdal",
        ["koKR"] = "로헴달 고개",
        ["ptBR"] = "Desfiladeiro de Rohemdal",
        ["ruRU"] = "Рохемдальский проход",
        ["zhCN"] = "洛希达尔小径",
        ["zhTW"] = "洛罕達之徑",
    },
    ["The Storm Foundry"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Wiege des Sturms",
        ["esES"] = "La Fundición de la Tormenta",
        ["esMX"] = "La Fundición de la Tormenta",
        ["frFR"] = "La Fonderie des tempêtes",
        ["koKR"] = "폭풍 주조소",
        ["ptBR"] = "Fundição da Tempestade",
        ["ruRU"] = "Плавильня штормов",
        ["zhCN"] = "风暴铸造场",
        ["zhTW"] = "風暴鑄造場",
    },
    ["Hibernal Cavern"] = {
        ["enUS"] = true,
        ["deDE"] = "Überwinterungshöhle",
        ["esES"] = "Caverna Hibernal",
        ["esMX"] = "Caverna Hibernal",
        ["frFR"] = "Caverne de l'hibernation",
        ["koKR"] = "겨울 동굴",
        ["ptBR"] = "Caverna Hibérnia",
        ["ruRU"] = "Пещера зимней спячки",
        ["zhCN"] = "冬眠洞穴",
        ["zhTW"] = "凜冬洞窟",
    },
    ["Voldrune Dwelling"] = {
        ["enUS"] = true,
        ["deDE"] = "Voldrunenbehausung",
        ["esES"] = "Morada Runavold",
        ["esMX"] = "Morada Runavold",
        ["frFR"] = "Logis de Voldrune",
        ["koKR"] = "볼드룬 주거지",
        ["ptBR"] = "Residência de Runavold",
        ["ruRU"] = "Поселение Волдрун",
        ["zhCN"] = "沃德伦民居",
        ["zhTW"] = "沃德盧恩居所",
    },
    ["Torseg's Rest"] = {
        ["enUS"] = true,
        ["deDE"] = "Torsegs Ruheplatz",
        ["esES"] = "Reposo de Torseg",
        ["esMX"] = "Reposo de Torseg",
        ["frFR"] = "Le Repos de Torseg",
        ["koKR"] = "토르섹의 쉼터",
        ["ptBR"] = "Repouso de Torseg",
        ["ruRU"] = "Покой Торсега",
        ["zhCN"] = "托塞格的营地",
        ["zhTW"] = "托賽格安息地",
    },
    ["Sparksocket Minefield"] = {
        ["enUS"] = true,
        ["deDE"] = "Funksockels Minenfeld",
        ["esES"] = "Campo de Minas Encajebujía",
        ["esMX"] = "Campo de Minas Encajebujía",
        ["frFR"] = "Champ de mines de Grilledouille",
        ["koKR"] = "스파크소켓의 지뢰밭",
        ["ptBR"] = "Campo Minado do Curtomada",
        ["ruRU"] = "Минное поле Свечекрута",
        ["zhCN"] = "斯巴索克雷区",
        ["zhTW"] = "炫臼礦區",
    },
    ["Ricket's Folly"] = {
        ["enUS"] = true,
        ["deDE"] = "Rickets Torheit",
        ["esES"] = "Locura de Ricket",
        ["esMX"] = "Locura de Ricket",
        ["frFR"] = "La Folie de Ricket",
        ["koKR"] = "리켓의 로켓 썰매",
        ["ptBR"] = "O Erro da Ricket",
        ["ruRU"] = "Просторы Рикет",
        ["zhCN"] = "莉吉特爆炸坑",
        ["zhTW"] = "芮凱特異所",
    },
    ["Garm's Bane"] = {
        ["enUS"] = true,
        ["deDE"] = "Garms Bann",
        ["esES"] = "Pesadilla de Garm",
        ["esMX"] = "Pesadilla de Garm",
        ["frFR"] = "Plaie-de-Garm",
        ["koKR"] = "가름의 파멸",
        ["ptBR"] = "Perdição de Garm",
        ["ruRU"] = "Побоище Гарма",
        ["zhCN"] = "加姆雷区",
        ["zhTW"] = "迦姆之禍",
    },
    ["Garm's Rise"] = {
        ["enUS"] = true,
        ["deDE"] = "Garms Erhebung",
        ["esES"] = "Alto de Garm",
        ["esMX"] = "Alto de Garm",
        ["frFR"] = "Cime de Garm",
        ["koKR"] = "가름의 마루",
        ["ptBR"] = "Ladeira de Garm",
        ["ruRU"] = "Подъем Гарма",
        ["zhCN"] = "加姆高地",
        ["zhTW"] = "迦姆高崗",
    },
    ["Crystalweb Cavern"] = {
        ["enUS"] = true,
        ["deDE"] = "Kristallnetzhöhle",
        ["esES"] = "Caverna Red de Cristal",
        ["esMX"] = "Caverna Red de Cristal",
        ["frFR"] = "Caverne de la Toile cristalline",
        ["koKR"] = "수정그물 동굴",
        ["ptBR"] = "Caverna da Teia de Cristal",
        ["ruRU"] = "Пещера Хрустальной Паутины",
        ["zhCN"] = "水晶蛛网洞穴",
        ["zhTW"] = "晶網洞窟",
    },
    ["Temple of Life"] = {
        ["enUS"] = true,
        ["deDE"] = "Tempel des Lebens",
        ["esES"] = "Templo de la Vida",
        ["esMX"] = "Templo de la Vida",
        ["frFR"] = "Temple de la Vie",
        ["koKR"] = "생명의 신전",
        ["ptBR"] = "Templo da Vida",
        ["ruRU"] = "Храм жизни",
        ["zhCN"] = "生命神殿",
        ["zhTW"] = "生命神殿",
    },
    ["Temple of Order"] = {
        ["enUS"] = true,
        ["deDE"] = "Tempel der Ordnung",
        ["esES"] = "Templo del Orden",
        ["esMX"] = "Templo del Orden",
        ["frFR"] = "Temple de l'Ordre",
        ["koKR"] = "질서의 신전",
        ["ptBR"] = "Templo da Ordem",
        ["ruRU"] = "Храм Порядка",
        ["zhCN"] = "秩序神殿",
        ["zhTW"] = "秩序神殿",
    },
    ["Temple of Winter"] = {
        ["enUS"] = true,
        ["deDE"] = "Tempel des Winters",
        ["esES"] = "Templo del Invierno",
        ["esMX"] = "Templo del Invierno",
        ["frFR"] = "Temple de l'Hiver",
        ["koKR"] = "겨울의 신전",
        ["ptBR"] = "Templo do Inverno",
        ["ruRU"] = "Храм Зимы",
        ["zhCN"] = "寒冬神殿",
        ["zhTW"] = "凜冬神殿",
    },
    ["Temple of Invention"] = {
        ["enUS"] = true,
        ["deDE"] = "Tempel des Erfindungsreichtums",
        ["esES"] = "Templo de la Invención",
        ["esMX"] = "Templo de la Invención",
        ["frFR"] = "Temple de l'Innovation",
        ["koKR"] = "발명의 신전",
        ["ptBR"] = "Templo da Invenção",
        ["ruRU"] = "Храм Изобретений",
        ["zhCN"] = "创世神殿",
        ["zhTW"] = "發明神殿",
    },
    ["Death's Rise"] = {
        ["enUS"] = true,
        ["deDE"] = "Todesanhöhe",
        ["esES"] = "Ascenso de la Muerte",
        ["esMX"] = "Ascenso de la Muerte",
        ["frFR"] = "Cime de la Mort",
        ["koKR"] = "죽음의 마루",
        ["ptBR"] = "Beiral da Morte",
        ["ruRU"] = "Уступ Смерти",
        ["zhCN"] = "死亡高地",
        ["zhTW"] = "死亡高崗",
    },
    ["The Dead Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Die toten Felder",
        ["esES"] = "Los Campos Muertos",
        ["esMX"] = "Los Campos Muertos",
        ["frFR"] = "Les champs des Morts",
        ["koKR"] = "죽음의 들판",
        ["ptBR"] = "Campos Estéreis",
        ["ruRU"] = "Мертвые поля",
        ["zhCN"] = "死亡旷野",
        ["zhTW"] = "亡者原野",
    },
    ["Dargath's Demise"] = {
        ["enUS"] = true,
        ["deDE"] = "Dargaths Niedergang",
        ["esES"] = "Óbito de Dargath",
        ["esMX"] = "Óbito de Dargath",
        ["frFR"] = "La Fin de Dargath",
        ["koKR"] = "다르가스의 최후",
        ["ptBR"] = "Destino de Dargath",
        ["ruRU"] = "Погибель Даргата",
        ["zhCN"] = "达加斯的行刑场",
        ["zhTW"] = "達加希的終點",
    },
    ["The Hidden Hollow"] = {
        ["enUS"] = true,
        ["deDE"] = "Die versteckte Senke",
        ["esES"] = "La Hondonada Oculta",
        ["esMX"] = "La Hondonada Oculta",
        ["frFR"] = "Le creux Caché",
        ["koKR"] = "숨겨진 동굴",
        ["ptBR"] = "Vazio Oculto",
        ["ruRU"] = "Скрытая низина",
        ["zhCN"] = "隐蔽山洞",
        ["zhTW"] = "隱匿谷",
    },
    ["Bernau's Happy Fun Land"] = {
        ["enUS"] = true,
        ["deDE"] = "Bernaus lustiges Paradies",
        ["esES"] = "El Maravilloso Mundo de Bernau",
        ["esMX"] = "El Maravilloso Mundo de Bernau",
        ["frFR"] = "Pays du bonheur de Bernau",
        ["koKR"] = "버나우의 놀이동산",
        ["ptBR"] = "Divertilândia de Bernau",
        ["ruRU"] = "Страна веселья Берно",
        ["zhCN"] = "Bernau's Happy Fun Land",
        ["zhTW"] = "博諾的快樂之地",
    },
    ["Frostgrip's Hollow"] = {
        ["enUS"] = true,
        ["deDE"] = "Frostgriffs Höhle",
        ["esES"] = "Hondonada Puño Helado",
        ["esMX"] = "Hondonada Puño Helado",
        ["frFR"] = "Creux de Poignegivre",
        ["koKR"] = "서리손아귀 동굴",
        ["ptBR"] = "Ravina Gélida",
        ["ruRU"] = "Лощина Ледохвата",
        ["zhCN"] = "霜握的洞穴",
        ["zhTW"] = "霜握谷",
    },
    ["The Frigid Tomb"] = {
        ["enUS"] = true,
        ["deDE"] = "Das eisige Grab",
        ["esES"] = "La Tumba Gélida",
        ["esMX"] = "La Tumba Gélida",
        ["frFR"] = "La tombe Algide",
        ["koKR"] = "얼어붙은 무덤",
        ["ptBR"] = "Tumba Frígida",
        ["ruRU"] = "Стылый склеп",
        ["zhCN"] = "严寒墓穴",
        ["zhTW"] = "嚴寒陵寢",
    },
    ["Twin Shores"] = {
        ["enUS"] = true,
        ["deDE"] = "Zwillingsküste",
        ["esES"] = "Las Playas Gemelas",
        ["esMX"] = "Las Playas Gemelas",
        ["frFR"] = "Rivages jumeaux",
        ["koKR"] = "쌍둥이 해안",
        ["ptBR"] = "Praias Gêmeas",
        ["ruRU"] = "Два берега",
        ["zhCN"] = "双子海岸",
        ["zhTW"] = "雙水之濱",
    },
    ["Zim'bo's Hideout"] = {
        ["enUS"] = true,
        ["deDE"] = "Zim'bos Versteck",
        ["esES"] = "Guarida de Zim'bo",
        ["esMX"] = "Guarida de Zim'bo",
        ["frFR"] = "Planque de Zim'bo",
        ["koKR"] = "짐보의 은신처",
        ["ptBR"] = "Esconderijo de Zim'bo",
        ["ruRU"] = "Убежище Зим'бо",
        ["zhCN"] = "希姆波的藏身处",
        ["zhTW"] = "辛波的藏身所",
    },
    ["Abandoned Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Verlassenes Lager",
        ["esES"] = "Campamento Abandonado",
        ["esMX"] = "Campamento Abandonado",
        ["frFR"] = "Camp abandonné",
        ["koKR"] = "버려진 야영지",
        ["ptBR"] = "Acampamento Abandonado",
        ["ruRU"] = "Заброшенный лагерь",
        ["zhCN"] = "被遗弃的营地",
        ["zhTW"] = "廢棄營地",
    },
    ["The Shadow Vault"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Schattengewölbe",
        ["esES"] = "La Cámara de las Sombras",
        ["esMX"] = "La Cámara de las Sombras",
        ["frFR"] = "Le caveau des Ombres",
        ["koKR"] = "어둠의 무기고",
        ["ptBR"] = "Abóbada das Sombras",
        ["ruRU"] = "Мрачный Свод",
        ["zhCN"] = "暗影拱顶",
        ["zhTW"] = "暗影穹殿",
    },
    ["Winter's Breath Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Winterhauchsee",
        ["esES"] = "Lago Aliento Invernal",
        ["esMX"] = "Lago Aliento Invernal",
        ["frFR"] = "Lac du Souffle de l'hiver",
        ["koKR"] = "겨울의 숨결 호수",
        ["ptBR"] = "Lago Sopro Invernal",
        ["ruRU"] = "Озеро Дыхания Зимы",
        ["zhCN"] = "冬息湖",
        ["zhTW"] = "冬息湖",
    },
    ["The Forgotten Overlook"] = {
        ["enUS"] = true,
        ["deDE"] = "Die vergessene Warte",
        ["esES"] = "El Mirador Olvidado",
        ["esMX"] = "El Mirador Olvidado",
        ["frFR"] = "Le surplomb Oublié",
        ["koKR"] = "잊혀진 전망대",
        ["ptBR"] = "Mirante Esquecido",
        ["ruRU"] = "Забытая высота",
        ["zhCN"] = "遗忘峭壁",
        ["zhTW"] = "遺忘瞰臺",
    },
    ["Jintha'kalar Passage"] = {
        ["enUS"] = true,
        ["deDE"] = "Jintha'kalarpassage",
        ["esES"] = "Pasaje de Jintha'kalar",
        ["esMX"] = "Pasaje de Jintha'kalar",
        ["frFR"] = "Passage de Jintha'kalar",
        ["koKR"] = "진타칼라르 통로",
        ["ptBR"] = "Passagem de Jintha'kalar",
        ["ruRU"] = "Джинта'каларский проход",
        ["zhCN"] = "金萨卡拉小径",
        ["zhTW"] = "辛薩卡拉通道",
    },
    ["Arriga Footbridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Arrigabrücke",
        ["esES"] = "Pasarela de Arriga",
        ["esMX"] = "Pasarela de Arriga",
        ["frFR"] = "Passerelle Arriga",
        ["koKR"] = "아리가 교각",
        ["ptBR"] = "Pinguela do Arriga",
        ["ruRU"] = "Мост Аррига",
        ["zhCN"] = "埃雷加之桥",
        ["zhTW"] = "艾瑞加之橋",
    },
    ["The Lost Passage"] = {
        ["enUS"] = true,
        ["deDE"] = "Die verlorene Passage",
        ["esES"] = "El Pasaje Perdido",
        ["esMX"] = "El Pasaje Perdido",
        ["frFR"] = "Le passage perdu",
        ["koKR"] = "잃어버린 통로",
        ["ptBR"] = "Passagem Perdida",
        ["ruRU"] = "Забытый проход",
        ["zhCN"] = "失落小径",
        ["zhTW"] = "失落通道",
    },
    ["Bouldercrag's Refuge"] = {
        ["enUS"] = true,
        ["deDE"] = "Bergfels' Zuflucht",
        ["esES"] = "Refugio de Pedruscón",
        ["esMX"] = "Refugio de Pedruscón",
        ["frFR"] = "Refuge de Rochecombe",
        ["koKR"] = "바울더크랙의 은거처",
        ["ptBR"] = "Refúgio do Petrenedo",
        ["ruRU"] = "Приют Глыбоскала",
        ["zhCN"] = "布德克拉格庇护所",
        ["zhTW"] = "石崖避難所",
    },
    ["The Inventor's Library"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Bibliothek des Erfinders",
        ["esES"] = "La Biblioteca del Inventor",
        ["esMX"] = "La Biblioteca del Inventor",
        ["frFR"] = "Bibliothèque de l'inventeur",
        ["koKR"] = "발명가의 도서관",
        ["ptBR"] = "Biblioteca do Inventor",
        ["ruRU"] = "Библиотека Изобретателя",
        ["zhCN"] = "创世者的图书馆",
        ["zhTW"] = "發明者圖書館",
    },
    ["The Frozen Mine"] = {
        ["enUS"] = true,
        ["deDE"] = "Die gefrorene Mine",
        ["esES"] = "La Mina Gélida",
        ["esMX"] = "La Mina Gélida",
        ["frFR"] = "La mine Gelée",
        ["koKR"] = "얼어붙은 광산",
        ["ptBR"] = "Mina Congelada",
        ["ruRU"] = "Застывшая шахта",
        ["zhCN"] = "冰霜矿洞",
        ["zhTW"] = "冰凍礦坑",
    },
    ["Frostfloe Deep"] = {
        ["enUS"] = true,
        ["deDE"] = "Frostschollentiefe",
        ["esES"] = "Hondonada Témpano Gélido",
        ["esMX"] = "Hondonada Témpano Gélido",
        ["frFR"] = "Gouffre du Sérac",
        ["koKR"] = "거대한 유빙",
        ["ptBR"] = "Caverna Flotagelo",
        ["ruRU"] = "Ледяные глубины",
        ["zhCN"] = "浮冰深渊",
        ["zhTW"] = "浮冰霜淵",
    },
    ["The Howling Hollow"] = {
        ["enUS"] = true,
        ["deDE"] = "Die heulende Senke",
        ["esES"] = "La Hondonada Aullante",
        ["esMX"] = "La Hondonada Aullante",
        ["frFR"] = "Le creux Hurlant",
        ["koKR"] = "울부짖는 동굴",
        ["ptBR"] = "Vazio Uivante",
        ["ruRU"] = "Стенающая ложбина",
        ["zhCN"] = "凛风洞窟",
        ["zhTW"] = "嚎風谷",
    },
    ["Crusader Forward Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Lager der Kreuzfahrer",
        ["esES"] = "Puesto de Avanzada de los Cruzados",
        ["esMX"] = "Puesto de Avanzada de los Cruzados",
        ["frFR"] = "Camp avancé des croisés",
        ["koKR"] = "십자군 전진기지",
        ["ptBR"] = "Campo Avançado dos Cruzados",
        ["ruRU"] = "Передовой лагерь рыцарей",
        ["zhCN"] = "北伐军前线营地",
        ["zhTW"] = "十字軍前進營地",
    },
    ["Stormcrest"] = {
        ["enUS"] = true,
        ["deDE"] = "Sturmspitze",
        ["esES"] = "Crestormenta",
        ["esMX"] = "Crestormenta",
        ["frFR"] = "Foudrecrête",
        ["koKR"] = "폭풍마루",
        ["ptBR"] = "Pico Crista de Gelo",
        ["ruRU"] = "Грозовесье",
        ["zhCN"] = "雷羽峰",
        ["zhTW"] = "風暴頂",
    },
    ["Bonesnap's Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Knochenknackers Lager",
        ["esES"] = "Campamento Cascahueso",
        ["esMX"] = "Campamento Cascahueso",
        ["frFR"] = "Camp de Bris'os",
        ["koKR"] = "본스냅 야영지",
        ["ptBR"] = "Acampamento do Quebraossos",
        ["ruRU"] = "Лагерь Костехвата",
        ["zhCN"] = "博斯纳普的营地",
        ["zhTW"] = "斷骨營地",
    },
    ["Ufrang's Hall"] = {
        ["enUS"] = true,
        ["deDE"] = "Ufrangs Halle",
        ["esES"] = "Sala de Ufrang",
        ["esMX"] = "Sala de Ufrang",
        ["frFR"] = "Salle d'Ufrang",
        ["koKR"] = "우프랑의 전당",
        ["ptBR"] = "Salão de Ufrang",
        ["ruRU"] = "Зал Уфранга",
        ["zhCN"] = "乌弗朗之厅",
        ["zhTW"] = "烏弗蘭大廳",
    },
    ["The Obsidian Sanctum"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Obsidiansanktum",
        ["esES"] = "El Sagrario Obsidiana",
        ["esMX"] = "El Sagrario Obsidiana",
        ["frFR"] = "Le sanctum Obsidien",
        ["koKR"] = "흑요석 성소",
        ["ptBR"] = "Santuário Obsidiano",
        ["ruRU"] = "Обсидиановое святилище",
        ["zhCN"] = "黑曜石圣殿",
        ["zhTW"] = "黑曜聖所",
    },
    ["Ahn'kahet: The Old Kingdom"] = {
        ["enUS"] = true,
        ["deDE"] = "Ahn'kahet: Das Alte Königreich",
        ["esES"] = "Ahn'kahet: El Antiguo Reino",
        ["esMX"] = "Ahn'kahet: El Antiguo Reino",
        ["frFR"] = "Ahn'kahet : l'Ancien royaume",
        ["koKR"] = "안카헤트: 고대 왕국",
        ["ptBR"] = "Ahn'kahet: O Velho Reino",
        ["ruRU"] = "Ан'кахет: Старое Королевство",
        ["zhCN"] = "安卡赫特：古代王国",
        ["zhTW"] = "安卡罕特:古王國",
    },
    ["Ahn'kahet"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = "안카헤트",
        ["ptBR"] = true,
        ["ruRU"] = "Ан'кахет",
        ["zhCN"] = "安卡赫特",
        ["zhTW"] = "安卡罕特",
    },
    ["Fjorn's Anvil"] = {
        ["enUS"] = true,
        ["deDE"] = "Fjorns Amboss",
        ["esES"] = "Yunque de Fjorn",
        ["esMX"] = "Yunque de Fjorn",
        ["frFR"] = "L'enclume de Fjorn",
        ["koKR"] = "피요른의 모루",
        ["ptBR"] = "Bigorna de Fjorn",
        ["ruRU"] = "Наковальня Фьорна",
        ["zhCN"] = "弗约恩之砧",
        ["zhTW"] = "斐雍之砧",
    },
    ["Jotunheim"] = {
        ["enUS"] = true,
        ["deDE"] = "Jotunheim",
        ["esES"] = "Jotunheim",
        ["esMX"] = "Jotunheim",
        ["frFR"] = "Jotunheim",
        ["koKR"] = "요툰하임",
        ["ptBR"] = "Jotunheim",
        ["ruRU"] = "Йотунхейм",
        ["zhCN"] = "尤顿海姆",
        ["zhTW"] = "卓頓海姆",
    },
    ["Savage Ledge"] = {
        ["enUS"] = true,
        ["deDE"] = "Wilde Klippe",
        ["esES"] = "Cornisa Salvaje",
        ["esMX"] = "Cornisa Salvaje",
        ["frFR"] = "L'escarpement Sauvage",
        ["koKR"] = "야만전사의 절벽",
        ["ptBR"] = "Plataforma Selvagem",
        ["ruRU"] = "Дикий уступ",
        ["zhCN"] = "野蛮之台",
        ["zhTW"] = "蠻荒岩臺",
    },
    ["Halls of the Ancestors"] = {
        ["enUS"] = true,
        ["deDE"] = "Hallen der Vorfahren",
        ["esES"] = "Salas de los Ancestros",
        ["esMX"] = "Salas de los Ancestros",
        ["frFR"] = "Salles des Ancêtres",
        ["koKR"] = "선조의 전당",
        ["ptBR"] = "Salões dos Antepassados",
        ["ruRU"] = "Залы Предков",
        ["zhCN"] = "先祖大厅",
        ["zhTW"] = "先祖大廳",
    },
    ["The Blighted Pool"] = {
        ["enUS"] = true,
        ["deDE"] = "Der verseuchte Teich",
        ["esES"] = "La Poza Contagiada",
        ["esMX"] = "La Poza Contagiada",
        ["frFR"] = "L'étang Chancreux",
        ["koKR"] = "파멸의 웅덩이",
        ["ptBR"] = "Tanque Empesteado",
        ["ruRU"] = "Гнилостный пруд",
        ["zhCN"] = "枯萎之池",
        ["zhTW"] = "荒疫之池",
    },
    ["The Eye of Eternity"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Auge der Ewigkeit",
        ["esES"] = "El Ojo de la Eternidad",
        ["esMX"] = "El Ojo de la Eternidad",
        ["frFR"] = "L'Œil de l'éternité",
        ["koKR"] = "영원의 눈",
        ["ptBR"] = "Olho da Eternidade",
        ["ruRU"] = "Око Вечности",
        ["zhCN"] = "永恒之眼",
        ["zhTW"] = "永恆之眼",
    },
    ["The Argent Vanguard"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Argentumvorhut",
        ["esES"] = "La Vanguardia Argenta",
        ["esMX"] = "La Vanguardia Argenta",
        ["frFR"] = "L'avant-garde d'Argent",
        ["koKR"] = "은빛십자군 선봉기지",
        ["ptBR"] = "Vanguarda Argêntea",
        ["ruRU"] = "Оплот Серебряного Авангарда",
        ["zhCN"] = "银色前线基地",
        ["zhTW"] = "銀白先鋒駐地",
    },
    ["Mimir's Workshop"] = {
        ["enUS"] = true,
        ["deDE"] = "Mimirs Werkstatt",
        ["esES"] = "Taller de Mimir",
        ["esMX"] = "Taller de Mimir",
        ["frFR"] = "Atelier de Mimir",
        ["koKR"] = "미미르의 작업장",
        ["ptBR"] = "Oficina do Mimir",
        ["ruRU"] = "Мастерская Мимира",
        ["zhCN"] = "米米尔的车间",
        ["zhTW"] = "彌米爾工坊",
    },
    ["Ironwall Dam"] = {
        ["enUS"] = true,
        ["deDE"] = "Eisenwalldamm",
        ["esES"] = "Presa del Muro de Hierro",
        ["esMX"] = "Presa del Muro de Hierro",
        ["frFR"] = "Barrage Mur-de-fer",
        ["koKR"] = "무쇠벽 둑",
        ["ptBR"] = "Dique da Muralha de Ferro",
        ["ruRU"] = "Железная плотина",
        ["zhCN"] = "铁墙大坝",
        ["zhTW"] = "鐵牆水壩",
    },
    ["Valley of Echoes"] = {
        ["enUS"] = true,
        ["deDE"] = "Tal der Echos",
        ["esES"] = "Valle de los Ecos",
        ["esMX"] = "Valle de los Ecos",
        ["frFR"] = "Vallée des Échos",
        ["koKR"] = "메아리 골짜기",
        ["ptBR"] = "Vale dos Ecos",
        ["ruRU"] = "Долина Эха",
        ["zhCN"] = "回音谷",
        ["zhTW"] = "回聲山谷",
    },
    ["The Breach"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Bresche",
        ["esES"] = "La Brecha",
        ["esMX"] = "La Brecha",
        ["frFR"] = "La Brèche",
        ["koKR"] = "거대한 틈",
        ["ptBR"] = "A Brecha",
        ["ruRU"] = "Пролом",
        ["zhCN"] = "突破口",
        ["zhTW"] = "止境",
    },
    ["Scourgeholme"] = {
        ["enUS"] = true,
        ["deDE"] = "Geißelholme",
        ["esES"] = "Ciudad de la Plaga",
        ["esMX"] = "Ciudad de la Plaga",
        ["frFR"] = "Fléaulme",
        ["koKR"] = "스컬지홀름",
        ["ptBR"] = "Forte do Flagelo",
        ["ruRU"] = "Плетхольм",
        ["zhCN"] = "天灾城",
        ["zhTW"] = "天譴岸地",
    },
    ["The Broken Front"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Zerbrochene Front",
        ["esES"] = "El Frente Roto",
        ["esMX"] = "El Frente Roto",
        ["frFR"] = "Le Front brisé",
        ["koKR"] = "파괴된 싸움터",
        ["ptBR"] = "O Front Partido",
        ["ruRU"] = "Прорванный фронт",
        ["zhCN"] = "破碎前线",
        ["zhTW"] = "破碎前線",
    },
    ["Mord'rethar: The Death Gate"] = {
        ["enUS"] = true,
        ["deDE"] = "Mord'rethar: Das Tor des Todes",
        ["esES"] = "Mord'rethar: La Puerta de la Muerte",
        ["esMX"] = "Mord'rethar: La Puerta de la Muerte",
        ["frFR"] = "Mord'rethar : la Porte de la Mort",
        ["koKR"] = "모드레타르: 죽음의 관문",
        ["ptBR"] = "Mord'rethar: O Portão da Morte",
        ["ruRU"] = "Морд'ретар: Врата Смерти",
        ["zhCN"] = "死亡之门莫德雷萨",
        ["zhTW"] = "默德雷薩:死亡之門",
    },
    ["The Bombardment"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Bombardement",
        ["esES"] = "El Bombardeo",
        ["esMX"] = "El Bombardeo",
        ["frFR"] = "Le Bombardement",
        ["koKR"] = "폭격지",
        ["ptBR"] = "O Bombardeio",
        ["ruRU"] = "Зона бомбардировки",
        ["zhCN"] = "轰炸场",
        ["zhTW"] = "轟炸地",
    },
    ["The Skybreaker"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Himmelsbrecher",
        ["esES"] = "El Rompecielos",
        ["esMX"] = "El Rompecielos",
        ["frFR"] = "Le Brise-ciel",
        ["koKR"] = "하늘파괴자호",
        ["ptBR"] = "O Rompe-céus",
        ["ruRU"] = "Усмиритель небес",
        ["zhCN"] = "破天号",
        ["zhTW"] = "破天者號",
    },
    ["Orgrim's Hammer"] = {
        ["enUS"] = true,
        ["deDE"] = "Orgrims Hammer",
        ["esES"] = "Martillo de Orgrim",
        ["esMX"] = "Martillo de Orgrim",
        ["frFR"] = "Le Marteau d'Orgrim",
        ["koKR"] = "오그림의 망치호",
        ["ptBR"] = "Martelo de Orgrim",
        ["ruRU"] = "Молот Оргрима",
        ["zhCN"] = "奥格瑞姆之锤",
        ["zhTW"] = "奧格林之錘",
    },
    ["Ymirheim"] = {
        ["enUS"] = true,
        ["deDE"] = "Ymirheim",
        ["esES"] = "Ymirheim",
        ["esMX"] = "Ymirheim",
        ["frFR"] = "Ymirheim",
        ["koKR"] = "이미르하임",
        ["ptBR"] = "Ymarheim",
        ["ruRU"] = "Имирхейм",
        ["zhCN"] = "伊米海姆",
        ["zhTW"] = "依米海姆",
    },
    ["Saronite Mines"] = {
        ["enUS"] = true,
        ["deDE"] = "Saronitminen",
        ["esES"] = "Minas de Saronita",
        ["esMX"] = "Minas de Saronita",
        ["frFR"] = "Mines de saronite",
        ["koKR"] = "사로나이트 광산",
        ["ptBR"] = "Minas de Saronita",
        ["ruRU"] = "Саронитовые шахты",
        ["zhCN"] = "萨隆邪铁矿洞",
        ["zhTW"] = "薩鋼礦坑",
    },
    ["The Conflagration"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Großbrand",
        ["esES"] = "La Conflagración",
        ["esMX"] = "La Conflagración",
        ["frFR"] = "La Déflagration",
        ["koKR"] = "끝없는 불길",
        ["ptBR"] = "A Conflagração",
        ["ruRU"] = "Пожарище",
        ["zhCN"] = "战火平原",
        ["zhTW"] = "焚焰地",
    },
    ["Ironwall Rampart"] = {
        ["enUS"] = true,
        ["deDE"] = "Eisenwallbollwerk",
        ["esES"] = "Fortificación del Muro de Hierro",
        ["esMX"] = "Fortificación del Muro de Hierro",
        ["frFR"] = "Rempart Mur-de-fer",
        ["koKR"] = "무쇠벽 성채",
        ["ptBR"] = "Muralha de Ferro",
        ["ruRU"] = "Железный вал",
        ["zhCN"] = "铁墙壁垒",
        ["zhTW"] = "鐵牆壁壘",
    },
    ["Weeping Quarry"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Tränenbruch",
        ["esES"] = "Cantera Llorosa",
        ["esMX"] = "Cantera Llorosa",
        ["frFR"] = "Carrière des Larmes",
        ["koKR"] = "진흙탕 채석장",
        ["ptBR"] = "Pedreira dos Lamentos",
        ["ruRU"] = "Саронитовый карьер",
        ["zhCN"] = "哭泣采掘场",
        ["zhTW"] = "哀泣礦場",
    },
    ["Corp'rethar: The Horror Gate"] = {
        ["enUS"] = true,
        ["deDE"] = "Corp'rethar: Das Tor des Schreckens",
        ["esES"] = "Corp'rethar: La Puerta del Horror",
        ["esMX"] = "Corp'rethar: La Puerta del Horror",
        ["frFR"] = "Corp'rethar : la Porte de l'Horreur",
        ["koKR"] = "코프레타르: 공포의 관문",
        ["ptBR"] = "Corp'rethar: O Portão do Horror",
        ["ruRU"] = "Корп'ретар: Врата Ужаса",
        ["zhCN"] = "恐惧之门科雷萨",
        ["zhTW"] = "寇普雷薩:驚怖之門",
    },
    ["Malykriss: The Vile Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Malykriss: Die unheilvolle Festung",
        ["esES"] = "Malykriss: El Bastión Inmundo",
        ["esMX"] = "Malykriss: El Bastión Inmundo",
        ["frFR"] = "Malykriss : le Fort infâme",
        ["koKR"] = "말리크리스: 타락의 요새",
        ["ptBR"] = "Malykriss: O Forte Torpe",
        ["ruRU"] = "Маликрисс: Зловещая Крепость",
        ["zhCN"] = "玛雷卡里斯：邪恶城堡",
        ["zhTW"] = "瑪里庫立斯:邪鄙堡",
    },
    ["Cathedral of Darkness"] = {
        ["enUS"] = true,
        ["deDE"] = "Kathedrale der Dunkelheit",
        ["esES"] = "Catedral de la Oscuridad",
        ["esMX"] = "Catedral de la Oscuridad",
        ["frFR"] = "Cathédrale des ténèbres",
        ["koKR"] = "어둠의 대성당",
        ["ptBR"] = "Catedral das Trevas",
        ["ruRU"] = "Собор Тьмы",
        ["zhCN"] = "黑暗大教堂",
        ["zhTW"] = "黑暗大教堂",
    },
    ["Icecrown Glacier"] = {
        ["enUS"] = true,
        ["deDE"] = "Eiskronengletscher",
        ["esES"] = "Glaciar Corona de Hielo",
        ["esMX"] = "Glaciar Corona de Hielo",
        ["frFR"] = "Glacier de la Couronne de glace",
        ["koKR"] = "얼음왕관 빙하",
        ["ptBR"] = "Glaciar Coroa de Gelo",
        ["ruRU"] = "Ледник Ледяная Корона",
        ["zhCN"] = "冰冠冰川",
        ["zhTW"] = "寒冰皇冠",
    },
    ["Valhalas"] = {
        ["enUS"] = true,
        ["deDE"] = "Valhalas",
        ["esES"] = "Valhalas",
        ["esMX"] = "Valhalas",
        ["frFR"] = "Valhalas",
        ["koKR"] = "발할라스",
        ["ptBR"] = "Valhalas",
        ["ruRU"] = "Валхалас",
        ["zhCN"] = "瓦哈拉斯",
        ["zhTW"] = "英靈殿",
    },
    ["The Underhalls"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Kellergewölbe",
        ["esES"] = "Las Cámaras Subterráneas",
        ["esMX"] = "Las Cámaras Subterráneas",
        ["frFR"] = "Les Basses-salles",
        ["koKR"] = "지하 전당",
        ["ptBR"] = "Salões Subterrâneos",
        ["ruRU"] = "Глубинные чертоги",
        ["zhCN"] = "地下大厅",
        ["zhTW"] = "地下大廳",
    },
    ["Njorndar Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Njorndar",
        ["esES"] = "Poblado Njorndar",
        ["esMX"] = "Poblado Njorndar",
        ["frFR"] = "Njorndar",
        ["koKR"] = "요른다르 마을",
        ["ptBR"] = "Vila Njorndar",
        ["ruRU"] = "Деревня Ньорндар",
        ["zhCN"] = "约尔达村",
        ["zhTW"] = "尼約達村",
    },
    ["Balargarde Fortress"] = {
        ["enUS"] = true,
        ["deDE"] = "Festung Balargarde",
        ["esES"] = "Fortaleza de Balargarde",
        ["esMX"] = "Fortaleza de Balargarde",
        ["frFR"] = "Forteresse de Balargarde",
        ["koKR"] = "발라르가드 요새",
        ["ptBR"] = "Fortaleza Balargarde",
        ["ruRU"] = "Цитадель Балагарда",
        ["zhCN"] = "巴拉加德堡垒",
        ["zhTW"] = "巴拉加德堡壘",
    },
    ["Kul'galar Keep"] = {
        ["enUS"] = true,
        ["deDE"] = "Feste Kul'galar",
        ["esES"] = "Fortaleza de Kul'galar",
        ["esMX"] = "Fortaleza de Kul'galar",
        ["frFR"] = "Donjon de Kul'galar",
        ["koKR"] = "쿨갈라르 성채",
        ["ptBR"] = "Forte Kul'galar",
        ["ruRU"] = "Крепость Кул'галар",
        ["zhCN"] = "库尔加拉要塞",
        ["zhTW"] = "庫爾加拉要塞",
    },
    ["The Crimson Cathedral"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Scharlachrote Kathedrale",
        ["esES"] = "La Catedral Carmesí",
        ["esMX"] = "La Catedral Carmesí",
        ["frFR"] = "La Cathédrale cramoisie",
        ["koKR"] = "진홍빛 성당",
        ["ptBR"] = "Catedral Carmesim",
        ["ruRU"] = "Багровый собор",
        ["zhCN"] = "赤色大教堂",
        ["zhTW"] = "赤紅大教堂",
    },
    ["Sanctum of Reanimation"] = {
        ["enUS"] = true,
        ["deDE"] = "Sanktum der Reanimation",
        ["esES"] = "Sagrario de Reanimación",
        ["esMX"] = "Sagrario de Reanimación",
        ["frFR"] = "Sanctum de réanimation",
        ["koKR"] = "부활의 성소",
        ["ptBR"] = "Sacrário da Reanimação",
        ["ruRU"] = "Святилище воскрешения",
        ["zhCN"] = "复生密室",
        ["zhTW"] = "再活化聖所",
    },
    ["The Fleshwerks"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Fleischwerke",
        ["esES"] = "La Factoría de Carne",
        ["esMX"] = "La Factoría de Carne",
        ["frFR"] = "La Charognerie",
        ["koKR"] = "살덩이작업장",
        ["ptBR"] = "Usina de Carne",
        ["ruRU"] = "Мясопилка",
        ["zhCN"] = "缝合场",
        ["zhTW"] = "血肉作坊",
    },
    ["Vengeance Landing Inn"] = {
        ["enUS"] = true,
        ["deDE"] = "Gasthaus des Hafens der Vergeltung",
        ["esES"] = "Taberna de Campo Venganza",
        ["esMX"] = "Taberna de Campo Venganza",
        ["frFR"] = "Auberge de l'accostage de la Vengeance",
        ["koKR"] = "복수의 상륙지 여관",
        ["ptBR"] = "Estalagem de Porto Vendeta",
        ["ruRU"] = "Таверна Лагеря возмездия",
        ["zhCN"] = "复仇港旅店",
        ["zhTW"] = "復仇臺地旅店",
    },
    ["Wildervar Mine"] = {
        ["enUS"] = true,
        ["deDE"] = "Mine von Wildervar",
        ["esES"] = "Mina de Vildervar",
        ["esMX"] = "Mina de Vildervar",
        ["frFR"] = "Mine Hardivar",
        ["koKR"] = "빌더바르 광산",
        ["ptBR"] = "Mina Vildervar",
        ["ruRU"] = "Вилдерварская шахта",
        ["zhCN"] = "维德瓦矿洞",
        ["zhTW"] = "威德瓦礦坑",
    },
    ["The Pit of the Fang"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Reißzahngrube",
        ["esES"] = "El Foso del Colmillo",
        ["esMX"] = "El Foso del Colmillo",
        ["frFR"] = "La Fosse du croc",
        ["koKR"] = "송곳니 구덩이",
        ["ptBR"] = "Fosso da Presa",
        ["ruRU"] = "Яма Клыка",
        ["zhCN"] = "利齿之坑",
        ["zhTW"] = "尖牙之淵",
    },
    ["Frosthowl Cavern"] = {
        ["enUS"] = true,
        ["deDE"] = "Heulende Frosthöhle",
        ["esES"] = "Caverna Aúllaescarcha",
        ["esMX"] = "Caverna Aúllaescarcha",
        ["frFR"] = "Caverne des Hurlegivres",
        ["koKR"] = "서리울음 동굴",
        ["ptBR"] = "Caverna Uivo de Gelo",
        ["ruRU"] = "Пещера Ледяного Воя",
        ["zhCN"] = "霜嚎洞穴",
        ["zhTW"] = "霜嚎洞窟",
    },
    ["The Valley of Lost Hope"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Tal der Verlorenen Hoffnung",
        ["esES"] = "El Valle de la Esperanza Perdida",
        ["esMX"] = "El Valle de la Esperanza Perdida",
        ["frFR"] = "La vallée de l'Espoir perdu",
        ["koKR"] = "잃어버린 희망의 계곡",
        ["ptBR"] = "Vale das Esperanças Perdidas",
        ["ruRU"] = "Долина Потерянной Надежды",
        ["zhCN"] = "失落希望之谷",
        ["zhTW"] = "逝望山谷",
    },
    ["The Valley of Fallen Heroes"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Tal der Gefallenen Helden",
        ["esES"] = "El Valle de los Héroes Caídos",
        ["esMX"] = "El Valle de los Héroes Caídos",
        ["frFR"] = "La vallée des Héros défunts",
        ["koKR"] = "전사한 영웅의 계곡",
        ["ptBR"] = "Vale dos Heróis Caídos",
        ["ruRU"] = "Долина Павших Героев",
        ["zhCN"] = "陨落英雄之谷",
        ["zhTW"] = "逝往英雄山谷",
    },
    ["Vanguard Infirmary"] = {
        ["enUS"] = true,
        ["deDE"] = "Feldlazarett der Vorhut",
        ["esES"] = "Enfermería de la Vanguardia",
        ["esMX"] = "Enfermería de la Vanguardia",
        ["frFR"] = "Infirmerie de l'avant-garde",
        ["koKR"] = "선봉기지 치료소",
        ["ptBR"] = "Enfermaria da Vanguarda",
        ["ruRU"] = "Лазарет Оплота",
        ["zhCN"] = "前线基地医护所",
        ["zhTW"] = "先鋒醫護站",
    },
    ["Hall of the Shaper"] = {
        ["enUS"] = true,
        ["deDE"] = "Halle des Formers",
        ["esES"] = "Sala del Creador",
        ["esMX"] = "Sala del Creador",
        ["frFR"] = "Hall du Façonneur",
        ["koKR"] = "구체자의 전당",
        ["ptBR"] = "Salão do Formador",
        ["ruRU"] = "Зал Творца",
        ["zhCN"] = "塑造者之厅",
        ["zhTW"] = "塑造者大廳",
    },
    ["Temple of Wisdom"] = {
        ["enUS"] = true,
        ["deDE"] = "Tempel der Weisheit",
        ["esES"] = "Templo de Sabiduría",
        ["esMX"] = "Templo de Sabiduría",
        ["frFR"] = "Temple de la Sagesse",
        ["koKR"] = "지혜의 신전",
        ["ptBR"] = "Templo da Sabedoria",
        ["ruRU"] = "Храм Мудрости",
        ["zhCN"] = "智慧神殿",
        ["zhTW"] = "智慧神殿",
    },
    ["Death's Breach"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Todesbresche",
        ["esES"] = "Brecha de la Muerte",
        ["esMX"] = "Brecha de la Muerte",
        ["frFR"] = "Brèche-de-Mort",
        ["koKR"] = "죽음의 틈",
        ["ptBR"] = "Vanguarda da Morte",
        ["ruRU"] = "Разлом Смерти",
        ["zhCN"] = "死亡裂口",
        ["zhTW"] = "死亡止境",
    },
    ["Abandoned Mine"] = {
        ["enUS"] = true,
        ["deDE"] = "Verlassene Mine",
        ["esES"] = "Mina Abandonada",
        ["esMX"] = "Mina Abandonada",
        ["frFR"] = "Mine abandonnée",
        ["koKR"] = "버려진 광산",
        ["ptBR"] = "Mina Abandonada",
        ["ruRU"] = "Заброшенная шахта",
        ["zhCN"] = "被遗弃的矿洞",
        ["zhTW"] = "棄置礦坑",
    },
    ["Ruins of the Scarlet Enclave"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen der Scharlachroten Enklave",
        ["esES"] = "Ruinas de El Enclave Escarlata",
        ["esMX"] = "Ruinas de El Enclave Escarlata",
        ["frFR"] = "Ruines de l'enclave Écarlate",
        ["koKR"] = "붉은십자군 폐허",
        ["ptBR"] = "Ruínas do Enclave Escarlate",
        ["ruRU"] = "Руины Анклава Алого ордена",
        ["zhCN"] = "血色领地废墟",
        ["zhTW"] = "血色領區廢墟",
    },
    ["Halls of Stone"] = {
        ["enUS"] = true,
        ["deDE"] = "Hallen des Steins",
        ["esES"] = "Cámaras de Piedra",
        ["esMX"] = "Cámaras de Piedra",
        ["frFR"] = "Les salles de Pierre",
        ["koKR"] = "돌의 전당",
        ["ptBR"] = "Salões Rochosos",
        ["ruRU"] = "Чертоги Камня",
        ["zhCN"] = "岩石大厅",
        ["zhTW"] = "石之大廳",
    },
    ["Halls of Lightning"] = {
        ["enUS"] = true,
        ["deDE"] = "Hallen der Blitze",
        ["esES"] = "Cámaras de Relámpagos",
        ["esMX"] = "Cámaras de Relámpagos",
        ["frFR"] = "Les salles de Foudre",
        ["koKR"] = "번개의 전당",
        ["ptBR"] = "Salões Relampejantes",
        ["ruRU"] = "Чертоги Молний",
        ["zhCN"] = "闪电大厅",
        ["zhTW"] = "雷光大廳",
    },
    ["The Great Tree"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Große Baum",
        ["esES"] = "El Gran Árbol",
        ["esMX"] = "El Gran Árbol",
        ["frFR"] = "Le grand Arbre",
        ["koKR"] = "거대 고목",
        ["ptBR"] = "A Grande Árvore",
        ["ruRU"] = "Великое Древо",
        ["zhCN"] = "符印巨树",
        ["zhTW"] = "巨偉之樹",
    },
    ["The Mirror of Twilight"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Zwielichtspiegel",
        ["esES"] = "El Espejo del Crepúsculo",
        ["esMX"] = "El Espejo del Crepúsculo",
        ["frFR"] = "Le Miroir du crépuscule",
        ["koKR"] = "황혼의 거울",
        ["ptBR"] = "Espelho do Crepúsculo",
        ["ruRU"] = "Зеркало Сумерек",
        ["zhCN"] = "暮色之镜",
        ["zhTW"] = "曦光之鏡",
    },
    ["The Twilight Rivulet"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Zwielichtbach",
        ["esES"] = "El Riachuelo Crepuscular",
        ["esMX"] = "El Riachuelo Crepuscular",
        ["frFR"] = "Le ruisselet du Crépuscule",
        ["koKR"] = "황혼의 개울",
        ["ptBR"] = "Regato do Crepúsculo",
        ["ruRU"] = "Сумеречный ручей",
        ["zhCN"] = "暮色小溪",
        ["zhTW"] = "曦光之溪",
    },
    ["The Decrepit Flow"] = {
        ["enUS"] = true,
        ["deDE"] = "Der versiegende Strom",
        ["esES"] = "La Corriente Decrépita",
        ["esMX"] = "La Corriente Decrépita",
        ["frFR"] = "Le courant Stagnant",
        ["koKR"] = "이울어진 물줄기",
        ["ptBR"] = "Córrego Decrépito",
        ["ruRU"] = "Замерший поток",
        ["zhCN"] = "衰弱之河",
        ["zhTW"] = "衰舊之流",
    },
    ["Forlorn Woods"] = {
        ["enUS"] = true,
        ["deDE"] = "Die trostlosen Wälder",
        ["esES"] = "El Bosque Desolado",
        ["esMX"] = "El Bosque Desolado",
        ["frFR"] = "Bois Lugubre",
        ["koKR"] = "쓸쓸한 숲",
        ["ptBR"] = "Bosque Esquecido",
        ["ruRU"] = "Опустевшие леса",
        ["zhCN"] = "绝望之林",
        ["zhTW"] = "凋落樹林",
    },
    ["Ruins of Shandaral"] = {
        ["enUS"] = true,
        ["deDE"] = "Ruinen von Shandaral",
        ["esES"] = "Ruinas de Shandaral",
        ["esMX"] = "Ruinas de Shandaral",
        ["frFR"] = "Ruines de Shandaral",
        ["koKR"] = "샨다랄 폐허",
        ["ptBR"] = "Ruínas de Shandaral",
        ["ruRU"] = "Руины Шандарала",
        ["zhCN"] = "杉达拉废墟",
        ["zhTW"] = "珊達拉遺跡",
    },
    ["The Azure Front"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Azurfront",
        ["esES"] = "El Frente Azur",
        ["esMX"] = "El Frente Azur",
        ["frFR"] = "Le front Azur",
        ["koKR"] = "하늘빛 전초지",
        ["ptBR"] = "Front Lazúli",
        ["ruRU"] = "Лазурный берег",
        ["zhCN"] = "碧蓝前线",
        ["zhTW"] = "蒼藍前線",
    },
    ["Violet Stand"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Violette Wacht",
        ["esES"] = "El Confín Violeta",
        ["esMX"] = "El Confín Violeta",
        ["frFR"] = "Le Séjour pourpre",
        ["koKR"] = "보랏빛 단",
        ["ptBR"] = "Fortaleza Violácea",
        ["ruRU"] = "Аметистовая застава",
        ["zhCN"] = "紫罗兰哨站",
        ["zhTW"] = "紫羅蘭看臺",
    },
    ["The Unbound Thicket"] = {
        ["enUS"] = true,
        ["deDE"] = "Unbändiges Dickicht",
        ["esES"] = "El Matorral Desatado",
        ["esMX"] = "El Matorral Desatado",
        ["frFR"] = "Le fourré Délié",
        ["koKR"] = "해방의 숲",
        ["ptBR"] = "Selva Franca",
        ["ruRU"] = "Дикая чаща",
        ["zhCN"] = "自由之林",
        ["zhTW"] = "無縛灌木林",
    },
    ["Sunreaver's Command"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenhäschers Schar",
        ["esES"] = "Dominio de los Atracasol",
        ["esMX"] = "Dominio de los Atracasol",
        ["frFR"] = "Quartier général de Saccage-soleil",
        ["koKR"] = "선리버 지휘초소",
        ["ptBR"] = "Comando Fendessol",
        ["ruRU"] = "Лагерь Похитителя Солнца",
        ["zhCN"] = "夺日者指挥站",
        ["zhTW"] = "奪日者指揮所",
    },
    ["Windrunner's Overlook"] = {
        ["enUS"] = true,
        ["deDE"] = "Windläufers Warte",
        ["esES"] = "Mirador Brisaveloz",
        ["esMX"] = "Mirador Brisaveloz",
        ["frFR"] = "Surplomb de Coursevent",
        ["koKR"] = "윈드러너 전망대",
        ["ptBR"] = "Penhasco Correventos",
        ["ruRU"] = "Дозор Ветрокрылой",
        ["zhCN"] = "风行者观察站",
        ["zhTW"] = "風行者瞰臺",
    },
    ["The Underbelly"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schattenseite",
        ["esES"] = "Los Bajos Fondos",
        ["esMX"] = "Los Bajos Fondos",
        ["frFR"] = "Les Entrailles",
        ["koKR"] = "마법의 뒤안길",
        ["ptBR"] = "Os Esgotos",
        ["ruRU"] = "Клоака",
        ["zhCN"] = "达拉然下水道",
        ["zhTW"] = "城底區",
    },
    ["The Violet Hold"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Violette Festung",
        ["esES"] = "El Bastión Violeta",
        ["esMX"] = "El Bastión Violeta",
        ["frFR"] = "Le fort Pourpre",
        ["koKR"] = "보랏빛 요새",
        ["ptBR"] = "Castelo Violeta",
        ["ruRU"] = "Аметистовая крепость",
        ["zhCN"] = "紫罗兰监狱",
        ["zhTW"] = "紫羅蘭堡",
    },
    ["The Eventide"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Abendruh",
        ["esES"] = "El Manto de la Noche",
        ["esMX"] = "El Manto de la Noche",
        ["frFR"] = "Le Brunant",
        ["koKR"] = "어스름 거리",
        ["ptBR"] = "Anoitecer",
        ["ruRU"] = "Вечерняя Заря",
        ["zhCN"] = "日暮广场",
        ["zhTW"] = "日暮區",
    },
    ["Circle of Wills"] = {
        ["enUS"] = true,
        ["deDE"] = "Kreis der Mächte",
        ["esES"] = "Círculo de Voluntades",
        ["esMX"] = "Círculo de Voluntades",
        ["frFR"] = "Le cercle des Volontés",
        ["koKR"] = "의지의 투기장",
        ["ptBR"] = "Círculo dos Desejos",
        ["ruRU"] = "Круг Воли",
        ["zhCN"] = "意志竞技场",
        ["zhTW"] = "意志之環",
    },
    ["Silverwing Flag Room"] = {
        ["enUS"] = true,
        ["deDE"] = "Flaggenraum der Silberschwingen",
        ["esES"] = "Sala de la Bandera de Brisa de Plata",
        ["esMX"] = "Sala de la Bandera de Brisa de Plata",
        ["frFR"] = "Salle du drapeau des Ailes-d'argent",
        ["koKR"] = "은빛날개 깃발 보관실",
        ["ptBR"] = "Sala da Bandeira Asa de Prata",
        ["ruRU"] = "Флаговая комната Среброкрылых",
        ["zhCN"] = "银翼军旗室",
        ["zhTW"] = "銀翼旗幟房間",
    },
    ["Warsong Flag Room"] = {
        ["enUS"] = true,
        ["deDE"] = "Flaggenraum des Kriegshymnenklans",
        ["esES"] = "Sala de la Bandera Grito de Guerra",
        ["esMX"] = "Sala de la Bandera Grito de Guerra",
        ["frFR"] = "Salle du drapeau des Chanteguerres",
        ["koKR"] = "전쟁노래 깃발 보관실",
        ["ptBR"] = "Sala da Bandeira Brado Guerreiro",
        ["ruRU"] = "Флаговая комната Песни Войны",
        ["zhCN"] = "战歌军旗室",
        ["zhTW"] = "戰歌旗幟房間",
    },
    ["Dubra'Jin"] = {
        ["enUS"] = true,
        ["deDE"] = "Dubra'Jin",
        ["esES"] = "Dubra'Jin",
        ["esMX"] = "Dubra'Jin",
        ["frFR"] = "Dubra'Jin",
        ["koKR"] = "두브라진",
        ["ptBR"] = "Dubra'Jin",
        ["ruRU"] = "Дубра'джин",
        ["zhCN"] = "杜布拉金",
        ["zhTW"] = "杜布拉金",
    },
    ["Crusaders' Pinnacle"] = {
        ["enUS"] = true,
        ["deDE"] = "Kreuzfahrerturm",
        ["esES"] = "Pináculo de los Cruzados",
        ["esMX"] = "Pináculo de los Cruzados",
        ["frFR"] = "Cime des Croisés",
        ["koKR"] = "십자군 봉우리",
        ["ptBR"] = "Pináculo dos Cruzados",
        ["ruRU"] = "Вершина Рыцарей",
        ["zhCN"] = "北伐军之峰",
        ["zhTW"] = "十字軍之巔",
    },
    ["Windy Bluffs"] = {
        ["enUS"] = true,
        ["deDE"] = "Die windigen Klippen",
        ["esES"] = "Riscos Ventosos",
        ["esMX"] = "Riscos Ventosos",
        ["frFR"] = "Les pitons Venteux",
        ["koKR"] = "바람 절벽",
        ["ptBR"] = "Penhasco dos Ventos",
        ["ruRU"] = "Ветряные утесы",
        ["zhCN"] = "狂风崖",
        ["zhTW"] = "群風崖",
    },
    ["Blackwatch"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schwarzwacht",
        ["esES"] = "La Guardia Negra",
        ["esMX"] = "La Guardia Negra",
        ["frFR"] = "Guet Noir",
        ["koKR"] = "어둠의 감시초소",
        ["ptBR"] = "Guarda Negra",
        ["ruRU"] = "Черный дозор",
        ["zhCN"] = "黑色观察站",
        ["zhTW"] = "黑色守望",
    },
    ["Gimorak's Den"] = {
        ["enUS"] = true,
        ["deDE"] = "Gimoraks Bau",
        ["esES"] = "Guarida de Gimorak",
        ["esMX"] = "Guarida de Gimorak",
        ["frFR"] = "Tanière de Gimorak",
        ["koKR"] = "기모라크의 동굴",
        ["ptBR"] = "Covil de Gimorak",
        ["ruRU"] = "Логово Гиморака",
        ["zhCN"] = "基莫拉克之巢",
        ["zhTW"] = "吉摩拉克獸穴",
    },
    ["The Pit of Fiends"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schreckensgrube",
        ["esES"] = "El Foso de los Mefistos",
        ["esMX"] = "El Foso de los Mefistos",
        ["frFR"] = "La fosse aux Démons",
        ["koKR"] = "악마의 구덩이",
        ["ptBR"] = "Fosso dos Demônios",
        ["ruRU"] = "Яма чудовищ",
        ["zhCN"] = "邪魔之坑",
        ["zhTW"] = "魔鬼之淵",
    },
    ["Battlescar Spire"] = {
        ["enUS"] = true,
        ["deDE"] = "Kriegsnarbenwarte",
        ["esES"] = "Cumbre Marca de Guerra",
        ["esMX"] = "Cumbre Marca de Guerra",
        ["frFR"] = "Flèche de la Balafre",
        ["koKR"] = "전투의 흉터 첨탑",
        ["ptBR"] = "Pináculo Chaga de Guerra",
        ["ruRU"] = "Вершина Боевого Шрама",
        ["zhCN"] = "战痕尖塔",
        ["zhTW"] = "戰傷尖塔",
    },
    ["Hall of Horrors"] = {
        ["enUS"] = true,
        ["deDE"] = "Halle des Grauens",
        ["esES"] = "Cámara de los Horrores",
        ["esMX"] = "Cámara de los Horrores",
        ["frFR"] = "Salle des Horreurs",
        ["koKR"] = "공포의 전당",
        ["ptBR"] = "Salão dos Horrores",
        ["ruRU"] = "Зал Ужасов",
        ["zhCN"] = "恐惧大厅",
        ["zhTW"] = "驚怖大廳",
    },
    ["The Circle of Suffering"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Kreis des Leidens",
        ["esES"] = "El Círculo de Sufrimiento",
        ["esMX"] = "El Círculo de Sufrimiento",
        ["frFR"] = "Cercle de Souffrance",
        ["koKR"] = "고통의 투기장",
        ["ptBR"] = "Círculo dos Sofrimentos",
        ["ruRU"] = "Круг Страдания",
        ["zhCN"] = "受难之环",
        ["zhTW"] = "苦難之環",
    },
    ["Rise of Suffering"] = {
        ["enUS"] = true,
        ["deDE"] = "Anhöhe des Leidens",
        ["esES"] = "Alto del Sufrimiento",
        ["esMX"] = "Alto del Sufrimiento",
        ["frFR"] = "Cime de Souffrance",
        ["koKR"] = "고통의 언덕",
        ["ptBR"] = "Beira do Sofrimento",
        ["ruRU"] = "Высота Страдания",
        ["zhCN"] = "苦难高地",
        ["zhTW"] = "苦難高崗",
    },
    ["Krasus' Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Krasus' Landeplatz",
        ["esES"] = "Alto de Krasus",
        ["esMX"] = "Alto de Krasus",
        ["frFR"] = "Aire de Krasus",
        ["koKR"] = "크라서스 착륙장",
        ["ptBR"] = "Plataforma de Krasus",
        ["ruRU"] = "Площадка Краса",
        ["zhCN"] = "克拉苏斯平台",
        ["zhTW"] = "卡薩斯平臺",
    },
    ["Sewer Exit Pipe"] = {
        ["enUS"] = true,
        ["deDE"] = "Ausgangsrohr der Kanalisation",
        ["esES"] = "Tubería de salida de las cloacas",
        ["esMX"] = "Tubería de salida de las cloacas",
        ["frFR"] = "Tunnel de sortie des égouts",
        ["koKR"] = "하수도 배출관",
        ["ptBR"] = "Cano de Saída dos Esgotos",
        ["ruRU"] = "Выход из сточной трубы",
        ["zhCN"] = "下水道排水管",
        ["zhTW"] = "下水道出口管道",
    },
    ["Dalaran Island"] = {
        ["enUS"] = true,
        ["deDE"] = "Insel Dalaran",
        ["esES"] = "Isla de Dalaran",
        ["esMX"] = "Isla de Dalaran",
        ["frFR"] = "Île de Dalaran",
        ["koKR"] = "달라란 섬",
        ["ptBR"] = "Ilha de Dalaran",
        ["ruRU"] = "Остров Даларан",
        ["zhCN"] = "达拉然岛",
        ["zhTW"] = "達拉然島",
    },
    ["Force Interior"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Innere der Macht",
        ["esES"] = "Fuerza Interior",
        ["esMX"] = "Fuerza Interior",
        ["frFR"] = "Force intérieure",
        ["koKR"] = "내부 강제",
        ["ptBR"] = "Força Interior",
        ["ruRU"] = "Интерьер силы",
        ["zhCN"] = "内室",
        ["zhTW"] = "力場內部",
    },
    ["Gate of the Red Sun"] = {
        ["enUS"] = true,
        ["deDE"] = "Tor der Rubinsonne",
        ["esES"] = "Puerta del Sol Rojo",
        ["esMX"] = "Puerta del Sol Rojo",
        ["frFR"] = "Porte du Soleil rouge",
        ["koKR"] = "붉은 태양 관문",
        ["ptBR"] = "Pórtico do Sol Escarlate",
        ["ruRU"] = "Врата Красного Солнца",
        ["zhCN"] = "红日之门",
        ["zhTW"] = "紅日之門",
    },
    ["Gate of the Blue Sapphire"] = {
        ["enUS"] = true,
        ["deDE"] = "Tor des Saphirhimmels",
        ["esES"] = "Puerta del Zafiro Azul",
        ["esMX"] = "Puerta del Zafiro Azul",
        ["frFR"] = "Porte du Saphir bleu",
        ["koKR"] = "푸른 사파이어 관문",
        ["ptBR"] = "Pórtico da Safira Azul",
        ["ruRU"] = "Врата Синего Сапфира",
        ["zhCN"] = "蓝玉之门",
        ["zhTW"] = "藍晶之門",
    },
    ["Gate of the Green Emerald"] = {
        ["enUS"] = true,
        ["deDE"] = "Tor des Smaragdhorizonts",
        ["esES"] = "Puerta de la Esmeralda Verde",
        ["esMX"] = "Puerta de la Esmeralda Verde",
        ["frFR"] = "Porte de l'Émeraude verte",
        ["koKR"] = "초록 에메랄드 관문",
        ["ptBR"] = "Pórtico da Esmeralda Verde",
        ["ruRU"] = "Врата Зеленого Изумруда",
        ["zhCN"] = "翡翠之门",
        ["zhTW"] = "碧翠之門",
    },
    ["Gate of the Purple Amethyst"] = {
        ["enUS"] = true,
        ["deDE"] = "Tor des Amethyststerns",
        ["esES"] = "Puerta de la Amatista Púrpura",
        ["esMX"] = "Puerta de la Amatista Púrpura",
        ["frFR"] = "Porte de l'Améthyste violette",
        ["koKR"] = "보라 자수정 관문",
        ["ptBR"] = "Pórtico da Ametista Roxa",
        ["ruRU"] = "Врата Лилового Аметиста",
        ["zhCN"] = "紫晶之门",
        ["zhTW"] = "紫晶之門",
    },
    ["Gate of the Yellow Moon"] = {
        ["enUS"] = true,
        ["deDE"] = "Tor des Goldmondes",
        ["esES"] = "Puerta de la Luna Amarilla",
        ["esMX"] = "Puerta de la Luna Amarilla",
        ["frFR"] = "Porte de la Lune jaune",
        ["koKR"] = "노란 달 관문",
        ["ptBR"] = "Pórtico da Lua Amarela",
        ["ruRU"] = "Врата Желтой Луны",
        ["zhCN"] = "金月之门",
        ["zhTW"] = "黃月之門",
    },
    ["Courtyard of the Ancients"] = {
        ["enUS"] = true,
        ["deDE"] = "Hof der Uralten",
        ["esES"] = "Patio de los Ancestros",
        ["esMX"] = "Patio de los Ancestros",
        ["frFR"] = "Cour des Anciens",
        ["koKR"] = "고대의 안마당",
        ["ptBR"] = "Pátio dos Anciãos",
        ["ruRU"] = "Двор Древних",
        ["zhCN"] = "远古庭院",
        ["zhTW"] = "遠祖庭院",
    },
    ["Landing Beach"] = {
        ["enUS"] = true,
        ["deDE"] = "Anlandestrand",
        ["esES"] = "Playa de Desembarco",
        ["esMX"] = "Playa de Desembarco",
        ["frFR"] = "Plage de débarquement",
        ["koKR"] = "해안 선착장",
        ["ptBR"] = "Praia do Desembarque",
        ["ruRU"] = "Береговая станция",
        ["zhCN"] = "登陆海滩",
        ["zhTW"] = "起降海灘",
    },
    ["Dalaran City"] = {
        ["enUS"] = true,
        ["deDE"] = "Dalaran",
        ["esES"] = "Ciudad de Dalaran",
        ["esMX"] = "Ciudad de Dalaran",
        ["frFR"] = "Dalaran",
        ["koKR"] = "달라란",
        ["ptBR"] = "Dalaran",
        ["ruRU"] = "Даларан",
        ["zhCN"] = "达拉然城",
        ["zhTW"] = "達拉然城",
    },
    ["The Violet Citadel Spire"] = {
        ["enUS"] = true,
        ["deDE"] = "Turm der Violetten Zitadelle",
        ["esES"] = "Aguja de La Ciudadela Violeta",
        ["esMX"] = "Aguja de La Ciudadela Violeta",
        ["frFR"] = "Fléche de la citadelle Pourpre",
        ["koKR"] = "보랏빛 성채 첨탑",
        ["ptBR"] = "Torre da Cidadela Violeta",
        ["ruRU"] = "Шпиль Аметистовой цитадели",
        ["zhCN"] = "紫罗兰塔",
        ["zhTW"] = "紫羅蘭城塞尖塔",
    },
    ["Naz'anak: The Forgotten Depths"] = {
        ["enUS"] = true,
        ["deDE"] = "Naz'anak: Die Vergessenen Tiefen",
        ["esES"] = "Naz'anak: Las Profundidades Olvidadas",
        ["esMX"] = "Naz'anak: Las Profundidades Olvidadas",
        ["frFR"] = "Naz'anak : les profondeurs oubliées",
        ["koKR"] = "나즈아낙: 망각의 심연",
        ["ptBR"] = "Naz'anak: As Profundezas Abandonadas",
        ["ruRU"] = "Наз'анак: Забытые глубины",
        ["zhCN"] = "纳扎纳克：遗忘深渊",
        ["zhTW"] = "納茲安那克:遺忘深淵",
    },
    ["Sunreaver's Sanctuary"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenhäschers Zuflucht",
        ["esES"] = "Santuario Atracasol",
        ["esMX"] = "Santuario Atracasol",
        ["frFR"] = "Sanctuaire de Saccage-soleil",
        ["koKR"] = "선리버 성소",
        ["ptBR"] = "Santuário Fendessol",
        ["ruRU"] = "Прибежище Похитителя Солнца",
        ["zhCN"] = "夺日者圣殿",
        ["zhTW"] = "奪日者聖堂",
    },
    ["Elevator"] = {
        ["enUS"] = true,
        ["deDE"] = "Aufzug",
        ["esES"] = "Elevador",
        ["esMX"] = "Elevador",
        ["frFR"] = "Ascenseur",
        ["koKR"] = "승강기",
        ["ptBR"] = "Elevador",
        ["ruRU"] = "Подъемник",
        ["zhCN"] = "升降梯",
        ["zhTW"] = "升降梯",
    },
    ["Antonidas Memorial"] = {
        ["enUS"] = true,
        ["deDE"] = "Antonidas' Denkmal",
        ["esES"] = "Monumento de Antonidas",
        ["esMX"] = "Monumento de Antonidas",
        ["frFR"] = "Monument à Antonidas",
        ["koKR"] = "안토니다스 기념지",
        ["ptBR"] = "Memorial a Antônidas",
        ["ruRU"] = "Памятник Антонидасу",
        ["zhCN"] = "安东尼达斯纪念碑",
        ["zhTW"] = "安東尼達斯紀念碑",
    },
    ["The Violet Citadel"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Violette Zitadelle",
        ["esES"] = "La Ciudadela Violeta",
        ["esMX"] = "La Ciudadela Violeta",
        ["frFR"] = "Citadelle Pourpre",
        ["koKR"] = "보랏빛 성채",
        ["ptBR"] = "A Cidadela Violeta",
        ["ruRU"] = "Аметистовая цитадель",
        ["zhCN"] = "紫罗兰城堡",
        ["zhTW"] = "紫羅蘭城塞",
    },
    ["Magus Commerce Exchange"] = {
        ["enUS"] = true,
        ["deDE"] = "Handelsmarkt der Magier",
        ["esES"] = "Mercado de Magos",
        ["esMX"] = "Mercado de Magos",
        ["frFR"] = "La halle des mages",
        ["koKR"] = "마법사 교역소",
        ["ptBR"] = "Área Comercial Magus",
        ["ruRU"] = "Торговая палата волшебников",
        ["zhCN"] = "魔法商业区",
        ["zhTW"] = "魔導師貿易區",
    },
    ["UNUSED"] = {
        ["enUS"] = true,
        ["deDE"] = "Unbenutzt",
        ["esES"] = "UNUSED",
        ["esMX"] = "UNUSED",
        ["frFR"] = "INUTILISÉ",
        ["koKR"] = "미사용",
        ["ptBR"] = "UNUSED",
        ["ruRU"] = "UNUSED",
        ["zhCN"] = "UNUSED",
        ["zhTW"] = "UNUSED",
    },
    ["First Legion Forward Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Vorhutslager der Ersten Legion",
        ["esES"] = "Puesto de Avanzada de la Primera Legión",
        ["esMX"] = "Puesto de Avanzada de la Primera Legión",
        ["frFR"] = "Camp avancé de la Première légion",
        ["koKR"] = "1군단 전진기지",
        ["ptBR"] = "Acampamento Avançado da Primeira Legião",
        ["ruRU"] = "Лагерь сопротивления первого легиона",
        ["zhCN"] = "第一军团前线营地",
        ["zhTW"] = "第一軍團前進營地",
    },
    ["Hall of the Conquered Kings"] = {
        ["enUS"] = true,
        ["deDE"] = "Halle der bezwungenen Könige",
        ["esES"] = "Cámara de los Reyes Conquistados",
        ["esMX"] = "Cámara de los Reyes Conquistados",
        ["frFR"] = "Salle des Rois conquis",
        ["koKR"] = "정복당한 왕들의 전당",
        ["ptBR"] = "Salão dos Reis Derrotados",
        ["ruRU"] = "Зал побежденных королей",
        ["zhCN"] = "败降王者之厅",
        ["zhTW"] = "征服諸王大廳",
    },
    ["Befouled Terrace"] = {
        ["enUS"] = true,
        ["deDE"] = "Besudelte Terrasse",
        ["esES"] = "Bancal Infecto",
        ["esMX"] = "Bancal Infecto",
        ["frFR"] = "Terrasse Souillée",
        ["koKR"] = "더럽혀진 단상",
        ["ptBR"] = "Terraço Conspurcado",
        ["ruRU"] = "Опоганенная терраса",
        ["zhCN"] = "被玷污的平台",
        ["zhTW"] = "玷污殿堂",
    },
    ["The Desecrated Altar"] = {
        ["enUS"] = true,
        ["deDE"] = "Der entweihte Altar",
        ["esES"] = "El Altar Profanado",
        ["esMX"] = "El Altar Profanado",
        ["frFR"] = "L'autel désacralisé",
        ["koKR"] = "모독의 제단",
        ["ptBR"] = "Altar Profanado",
        ["ruRU"] = "Оскверненный алтарь",
        ["zhCN"] = "被亵渎的祭坛",
        ["zhTW"] = "褻瀆祭壇",
    },
    ["Shimmering Bog"] = {
        ["enUS"] = true,
        ["deDE"] = "Schimmersumpf",
        ["esES"] = "Ciénaga Bruñida",
        ["esMX"] = "Ciénaga Bruñida",
        ["frFR"] = "La tourbière Chatoyante",
        ["koKR"] = "미명의 수렁",
        ["ptBR"] = "Brejo Cintilante",
        ["ruRU"] = "Мерцающая топь",
        ["zhCN"] = "闪光泥沼",
        ["zhTW"] = "幻光泥沼",
    },
    ["Fallen Temple of Ahn'kahet"] = {
        ["enUS"] = true,
        ["deDE"] = "Der gefallene Tempel Ahn'kahet",
        ["esES"] = "Templo Caído de Ahn'kahet",
        ["esMX"] = "Templo Caído de Ahn'kahet",
        ["frFR"] = "Temple déchu d'Ahn'kahet",
        ["koKR"] = "무너진 안카헤트 신전",
        ["ptBR"] = "Templo de Ahn'kahet",
        ["ruRU"] = "Павший храм Ан'кахета",
        ["zhCN"] = "坍塌的安卡赫特神殿",
        ["zhTW"] = "安卡罕特墮落神殿",
    },
    ["Halls of Binding"] = {
        ["enUS"] = true,
        ["deDE"] = "Hallen der Bindung",
        ["esES"] = "Sala de Vínculos",
        ["esMX"] = "Sala de Vínculos",
        ["frFR"] = "Salles de lien",
        ["koKR"] = "구속의 전당",
        ["ptBR"] = "Salões do Confinamento",
        ["ruRU"] = "Залы Оков",
        ["zhCN"] = "束缚大厅",
        ["zhTW"] = "束縛大廳",
    },
    ["Winter's Heart"] = {
        ["enUS"] = true,
        ["deDE"] = "Winterherz",
        ["esES"] = "Corazón del Invierno",
        ["esMX"] = "Corazón del Invierno",
        ["frFR"] = "Cœur de l'hiver",
        ["koKR"] = "겨울의 심장",
        ["ptBR"] = "Coração do Inverno",
        ["ruRU"] = "Сердце зимы",
        ["zhCN"] = "寒冬之心",
        ["zhTW"] = "寒冬之心",
    },
    ["The North Sea"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Nordmeer",
        ["esES"] = "El Mar del Norte",
        ["esMX"] = "El Mar del Norte",
        ["frFR"] = "La mer Boréale",
        ["koKR"] = "북해",
        ["ptBR"] = "Mar do Norte",
        ["ruRU"] = "Северное море",
        ["zhCN"] = "北海",
        ["zhTW"] = "北海",
    },
    ["The Broodmother's Nest"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Nest der Brutmutter",
        ["esES"] = "El Nido de la Madre de Linaje",
        ["esMX"] = "El Nido de la Madre de Linaje",
        ["frFR"] = "Le nid de la mère des couvées",
        ["koKR"] = "여왕 둥지",
        ["ptBR"] = "Ninho da Prolemadre",
        ["ruRU"] = "Гнездо праматери",
        ["zhCN"] = "母龙之巢",
        ["zhTW"] = "育母之巢",
    },
    ["Dalaran Floating Rocks"] = {
        ["enUS"] = true,
        ["deDE"] = "Fliegende Felsen von Dalaran",
        ["esES"] = "Rocas Flotantes de Dalaran",
        ["esMX"] = "Rocas Flotantes de Dalaran",
        ["frFR"] = "Rochers flottants de Dalaran",
        ["koKR"] = "떠다니는 바위",
        ["ptBR"] = "Pedras Flutuantes de Dalaran",
        ["ruRU"] = "Даларанские парящие камни",
        ["zhCN"] = "达拉然浮石",
        ["zhTW"] = "達拉然漂浮岩",
    },
    ["Raptor Pens"] = {
        ["enUS"] = true,
        ["deDE"] = "Raptorenställe",
        ["esES"] = "Cercado de Raptores",
        ["esMX"] = "Cercado de Raptores",
        ["frFR"] = "Enclos à raptors",
        ["koKR"] = "랩터 우리",
        ["ptBR"] = "Redil dos Raptores",
        ["ruRU"] = "Ямы ящеров",
        ["zhCN"] = "迅猛龙围栏",
        ["zhTW"] = "迅猛龍圍欄",
    },
    ["The Noxious Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Giftpass",
        ["esES"] = "El Paso Ponzoñoso",
        ["esMX"] = "El Paso Ponzoñoso",
        ["frFR"] = "La passe Nocive",
        ["koKR"] = "맹독의 길",
        ["ptBR"] = "Estrada Nociva",
        ["ruRU"] = "Гибельный путь",
        ["zhCN"] = "剧毒小径",
        ["zhTW"] = "腐毒小徑",
    },
    ["Vargoth's Retreat"] = {
        ["enUS"] = true,
        ["deDE"] = "Erzmagier Vargoths Rückzugsort",
        ["esES"] = "Reposo de Vargoth",
        ["esMX"] = "Reposo de Vargoth",
        ["frFR"] = "Retraite de Vargoth",
        ["koKR"] = "바르고스의 은거지",
        ["ptBR"] = "Retiro de Vargoth",
        ["ruRU"] = "Укрытие Варгота",
        ["zhCN"] = "瓦格斯的居所",
        ["zhTW"] = "瓦戈斯居所",
    },
    ["Violet Citadel Balcony"] = {
        ["enUS"] = true,
        ["deDE"] = "Balkon der Violetten Zitadelle",
        ["esES"] = "Balcón de la Ciudadela Violeta",
        ["esMX"] = "Balcón de la Ciudadela Violeta",
        ["frFR"] = "Balcon de la citadelle Pourpre",
        ["koKR"] = "보랏빛 성채 발코니",
        ["ptBR"] = "Varanda da Cidadela Violeta",
        ["ruRU"] = "Балкон Аметистовой цитадели",
        ["zhCN"] = "紫罗兰城堡阳台",
        ["zhTW"] = "紫羅蘭城塞露台",
    },
    ["Band of Variance"] = {
        ["enUS"] = true,
        ["deDE"] = "Ring der Varianz",
        ["esES"] = "Anillo de Discrepancia",
        ["esMX"] = "Anillo de Discrepancia",
        ["frFR"] = "Bague de variance",
        ["koKR"] = "변화의 고리",
        ["ptBR"] = "Faixa de Alternância",
        ["ruRU"] = "Кольцо отклонения",
        ["zhCN"] = "突变之环",
        ["zhTW"] = "變化之環",
    },
    ["Band of Acceleration"] = {
        ["enUS"] = true,
        ["deDE"] = "Ring der Akzeleration",
        ["esES"] = "Anillo de Aceleración",
        ["esMX"] = "Anillo de Aceleración",
        ["frFR"] = "Bague d'accélération",
        ["koKR"] = "가속의 고리",
        ["ptBR"] = "Faixa de Aceleração",
        ["ruRU"] = "Кольцо ускорения",
        ["zhCN"] = "加速之环",
        ["zhTW"] = "加速之環",
    },
    ["Band of Transmutation"] = {
        ["enUS"] = true,
        ["deDE"] = "Ring der Transmutation",
        ["esES"] = "Anillo de Transmutación",
        ["esMX"] = "Anillo de Transmutación",
        ["frFR"] = "Bague de transmutation",
        ["koKR"] = "변환의 고리",
        ["ptBR"] = "Faixa de Transmutação",
        ["ruRU"] = "Кольцо трансмутации",
        ["zhCN"] = "转化之环",
        ["zhTW"] = "轉化之環",
    },
    ["Band of Alignment"] = {
        ["enUS"] = true,
        ["deDE"] = "Ring der Abgleichung",
        ["esES"] = "Anillo de Alineación",
        ["esMX"] = "Anillo de Alineación",
        ["frFR"] = "Bague d'alignement",
        ["koKR"] = "정렬의 고리",
        ["ptBR"] = "Faixa de Alinhamento",
        ["ruRU"] = "Кольцо управления",
        ["zhCN"] = "校准之环",
        ["zhTW"] = "化合之環",
    },
    ["Ashwood Lake"] = {
        ["enUS"] = true,
        ["deDE"] = "Eschenholzsee",
        ["esES"] = "Lago Fresno",
        ["esMX"] = "Lago Fresno",
        ["frFR"] = "Lac du Frêne",
        ["koKR"] = "잿빛나무 호수",
        ["ptBR"] = "Lago Freixo",
        ["ruRU"] = "Ясеневое озеро",
        ["zhCN"] = "灰木湖",
        ["zhTW"] = "灰木湖",
    },
    ["Iron Concourse"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Eisenstau",
        ["esES"] = "Explanada de Hierro",
        ["esMX"] = "Explanada de Hierro",
        ["frFR"] = "Corridor de Fer",
        ["koKR"] = "무쇠 대열 광장",
        ["ptBR"] = "Junção de Ferro",
        ["ruRU"] = "Железный двор",
        ["zhCN"] = "钢铁广场",
        ["zhTW"] = "鐵之集合場",
    },
    ["Formation Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Gestaltungsgelände",
        ["esES"] = "Campo de Formación",
        ["esMX"] = "Campo de Formación",
        ["frFR"] = "Champ d'entraînement",
        ["koKR"] = "전투대형 훈련장",
        ["ptBR"] = "Campos de Formação",
        ["ruRU"] = "Плац",
        ["zhCN"] = "练兵场",
        ["zhTW"] = "構築之地",
    },
    ["Razorscale's Aerie"] = {
        ["enUS"] = true,
        ["deDE"] = "Klingenschuppes Kanzel",
        ["esES"] = "Nidal de Tajoescama",
        ["esMX"] = "Nidal de Tajoescama",
        ["frFR"] = "Nichoir de Tranchécaille",
        ["koKR"] = "칼날비늘의 둥지",
        ["ptBR"] = "Refúgio da Navalhada",
        ["ruRU"] = "Гнездо Острокрылой",
        ["zhCN"] = "锋鳞之巢",
        ["zhTW"] = "銳鱗之巢",
    },
    ["The Colossal Forge"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Kolossale Schmiede",
        ["esES"] = "La Forja Colosal",
        ["esMX"] = "La Forja Colosal",
        ["frFR"] = "La Forge colossale",
        ["koKR"] = "거대 제련실",
        ["ptBR"] = "Forja Colossal",
        ["ruRU"] = "Гигантская кузня",
        ["zhCN"] = "巨人熔炉",
        ["zhTW"] = "巨熔爐",
    },
    ["The Scrapyard"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Schrottplatz",
        ["esES"] = "La Chatarrería",
        ["esMX"] = "La Chatarrería",
        ["frFR"] = "La Ferraillerie",
        ["koKR"] = "고철 야적장",
        ["ptBR"] = "O Ferro Velho",
        ["ruRU"] = "Мусорная свалка",
        ["zhCN"] = "废料场",
        ["zhTW"] = "廢料場",
    },
    ["The Conservatory of Life"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Konservatorium des Lebens",
        ["esES"] = "El Invernadero de Vida",
        ["esMX"] = "El Invernadero de Vida",
        ["frFR"] = "Le jardin de la Vie",
        ["koKR"] = "생명의 정원",
        ["ptBR"] = "Reserva Biológica",
        ["ruRU"] = "Оранжерея Жизни",
        ["zhCN"] = "生命温室",
        ["zhTW"] = "生命溫室",
    },
    ["The Archivum"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Archivum",
        ["esES"] = "El Archivum",
        ["esMX"] = "El Archivum",
        ["frFR"] = "L'Archivum",
        ["koKR"] = "고대 기록관",
        ["ptBR"] = "Archivum",
        ["ruRU"] = "Архив",
        ["zhCN"] = "档案馆",
        ["zhTW"] = "大資料庫",
    },
    ["Argent Tournament Grounds"] = {
        ["enUS"] = true,
        ["deDE"] = "Argentumturnierplatz",
        ["esES"] = "Campos del Torneo Argenta",
        ["esMX"] = "Campos del Torneo Argenta",
        ["frFR"] = "Enceinte du tournoi d'Argent",
        ["koKR"] = "은빛십자군 마상시합 광장",
        ["ptBR"] = "Campos do Torneio Argênteo",
        ["ruRU"] = "Ристалище Серебряного турнира",
        ["zhCN"] = "银色比武场",
        ["zhTW"] = "銀白聯賽場地",
    },
    ["Tournament"] = {
        ["enUS"] = true,
        ["deDE"] = "Turnier",
        ["esES"] = "Torneo",
        ["esMX"] = "Torneo",
        ["frFR"] = "Tournoi",
        ["koKR"] = "토너먼트",
        ["ptBR"] = "Torneio",
        ["ruRU"] = "Турнир",
        ["zhCN"] = "锦标赛",
        ["zhTW"] = "聯賽",
    },
    ["Expedition Base Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Basislager der Expedition",
        ["esES"] = "Campamento Base de la Expedición",
        ["esMX"] = "Campamento Base de la Expedición",
        ["frFR"] = "Camp de base de l'expédition",
        ["koKR"] = "원정대 기지",
        ["ptBR"] = "Acampamento da Expedição",
        ["ruRU"] = "Главный лагерь экспедиции",
        ["zhCN"] = "远征军营地",
        ["zhTW"] = "遠征隊營地",
    },
    ["The Cooper Residence"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Cooper-Residenz",
        ["esES"] = "La Residencia Cooper",
        ["esMX"] = "La Residencia Cooper",
        ["frFR"] = "La résidence des Tonnelier",
        ["koKR"] = "쿠퍼 저택",
        ["ptBR"] = "Residência dos Curvelo",
        ["ruRU"] = "Имение Купера",
        ["zhCN"] = "桶屋",
        ["zhTW"] = "庫珀的住所",
    },
    ["The Ring of Champions"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ring der Champions",
        ["esES"] = "La Liza de los Campeones",
        ["esMX"] = "La Liza de los Campeones",
        ["frFR"] = "La lice des champions",
        ["koKR"] = "용사의 투기장",
        ["ptBR"] = "Arena dos Campeões",
        ["ruRU"] = "Арена чемпионов",
        ["zhCN"] = "冠军赛场",
        ["zhTW"] = "勇士競技場",
    },
    ["The Aspirants' Ring"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ring der Streiter",
        ["esES"] = "La Liza de los Aspirantes",
        ["esMX"] = "La Liza de los Aspirantes",
        ["frFR"] = "La lice des aspirants",
        ["koKR"] = "지원자의 투기장",
        ["ptBR"] = "Arena dos Aspirantes",
        ["ruRU"] = "Арена претендентов",
        ["zhCN"] = "候选者赛场",
        ["zhTW"] = "志士競技場",
    },
    ["The Argent Valiants' Ring"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ring der Recken des Argentumkreuzzugs",
        ["esES"] = "La Liza de los Valerosos Argenta",
        ["esMX"] = "La Liza de los Valerosos Argenta",
        ["frFR"] = "La lice des vaillants d'Argent",
        ["koKR"] = "은빛십자군 용맹전사의 투기장",
        ["ptBR"] = "Arena dos Valentes Argênteos",
        ["ruRU"] = "Арена искателей славы Серебряного Авангарда",
        ["zhCN"] = "银色勇士赛场",
        ["zhTW"] = "銀白驍士競技場",
    },
    ["The Alliance Valiants' Ring"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ring der Recken der Allianz",
        ["esES"] = "La Liza de los Valerosos de la Alianza",
        ["esMX"] = "La Liza de los Valerosos de la Alianza",
        ["frFR"] = "La lice des vaillants de l'Alliance",
        ["koKR"] = "얼라이언스 용맹전사의 투기장",
        ["ptBR"] = "Arena dos Valentes da Aliança",
        ["ruRU"] = "Арена искателей славы из Альянса",
        ["zhCN"] = "联盟勇士赛场",
        ["zhTW"] = "聯盟驍士競技場",
    },
    ["The Horde Valiants' Ring"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Ring der Recken der Horde",
        ["esES"] = "La Liza de los Valerosos de la Horda",
        ["esMX"] = "La Liza de los Valerosos de la Horda",
        ["frFR"] = "La lice des vaillants de la Horde",
        ["koKR"] = "호드 용맹전사의 투기장",
        ["ptBR"] = "Arena dos Valentes da Horda",
        ["ruRU"] = "Арена искателей славы из Орды",
        ["zhCN"] = "部落勇士赛场",
        ["zhTW"] = "部落驍士競技場",
    },
    ["Argent Pavilion"] = {
        ["enUS"] = true,
        ["deDE"] = "Argentumpavillon",
        ["esES"] = "Pabellón Argenta",
        ["esMX"] = "Pabellón Argenta",
        ["frFR"] = "Pavillon d'Argent",
        ["koKR"] = "은빛십자군 막사",
        ["ptBR"] = "Pavilhão Argênteo",
        ["ruRU"] = "Серебряный павильон",
        ["zhCN"] = "银色大帐",
        ["zhTW"] = "銀白亭閣",
    },
    ["Sunreaver Pavilion"] = {
        ["enUS"] = true,
        ["deDE"] = "Sonnenhäscherpavillon",
        ["esES"] = "Pabellón Atracasol",
        ["esMX"] = "Pabellón Atracasol",
        ["frFR"] = "Pavillon de Saccage-soleil",
        ["koKR"] = "선리버 막사",
        ["ptBR"] = "Pavilhão Fendessol",
        ["ruRU"] = "Павильон Похитителей Солнца",
        ["zhCN"] = "夺日者大帐",
        ["zhTW"] = "奪日者亭閣",
    },
    ["Silver Covenant Pavilion"] = {
        ["enUS"] = true,
        ["deDE"] = "Silberbundpavillon",
        ["esES"] = "Pabellón de El Pacto de Plata",
        ["esMX"] = "Pabellón de El Pacto de Plata",
        ["frFR"] = "Pavillon du Concordat argenté",
        ["koKR"] = "은빛 서약단 막사",
        ["ptBR"] = "Pavilhão do Pacto de Prata",
        ["ruRU"] = "Павильон Серебряного союза",
        ["zhCN"] = "银色盟约大帐",
        ["zhTW"] = "白銀誓盟亭閣",
    },
    ["The Forlorn Cavern"] = {
        ["enUS"] = true,
        ["deDE"] = "Das düstere Viertel",
        ["esES"] = "La Caverna Abandonada",
        ["esMX"] = "La Caverna Abandonada",
        ["frFR"] = "La Caverne lugubre",
        ["koKR"] = "쓸쓸한 뒷골목",
        ["ptBR"] = "Caverna Esquecida",
        ["ruRU"] = "Заброшенный грот",
        ["zhCN"] = "荒弃的洞穴",
        ["zhTW"] = "荒棄的洞穴",
    },
    ["claytonio test area"] = {
        ["enUS"] = true,
        ["deDE"] = "Testgebiet Claytonio",
        ["esES"] = "claytonio test area",
        ["esMX"] = "claytonio test area",
        ["frFR"] = "claytonio test area",
        ["koKR"] = "클레이토니오 시험 지역",
        ["ptBR"] = "área de teste do clayton",
        ["ruRU"] = "claytonio test area",
        ["zhCN"] = "claytonio test area",
        ["zhTW"] = "claytonio test area",
    },
    ["Quel'Delar's Rest"] = {
        ["enUS"] = true,
        ["deDE"] = "Quel'Delars Ruh",
        ["esES"] = "Reposo de Quel'Delar",
        ["esMX"] = "Reposo de Quel'Delar",
        ["frFR"] = "Repos de Quel'Delar",
        ["koKR"] = "쿠엘델라의 쉼터",
        ["ptBR"] = "Repouso de Quel'Delar",
        ["ruRU"] = "Покой Кель'Делара",
        ["zhCN"] = "奎尔德拉之冢",
        ["zhTW"] = "奎爾德拉之眠",
    },
    ["Isle of Conquest"] = {
        ["enUS"] = true,
        ["deDE"] = "Insel der Eroberung",
        ["esES"] = "Isla de la Conquista",
        ["esMX"] = "Isla de la Conquista",
        ["frFR"] = "Île des Conquérants",
        ["koKR"] = "정복의 섬",
        ["ptBR"] = "Ilha da Conquista",
        ["ruRU"] = "Остров Завоеваний",
        ["zhCN"] = "征服之岛",
        ["zhTW"] = "征服之島",
    },
    ["Trial of the Crusader"] = {
        ["enUS"] = true,
        ["deDE"] = "Prüfung des Kreuzfahrers",
        ["esES"] = "Prueba del Cruzado",
        ["esMX"] = "Prueba del Cruzado",
        ["frFR"] = "L'épreuve du croisé",
        ["koKR"] = "십자군의 시험장",
        ["ptBR"] = "Prova do Cruzado",
        ["ruRU"] = "Испытание крестоносца",
        ["zhCN"] = "十字军的试炼",
        ["zhTW"] = "十字軍試煉",
    },
    ["Trial of the Champion"] = {
        ["enUS"] = true,
        ["deDE"] = "Prüfung des Champions",
        ["esES"] = "Prueba del Campeón",
        ["esMX"] = "Prueba del Campeón",
        ["frFR"] = "L'épreuve du champion",
        ["koKR"] = "용사의 시험장",
        ["ptBR"] = "Prova do Campeão",
        ["ruRU"] = "Испытание чемпиона",
        ["zhCN"] = "冠军的试炼",
        ["zhTW"] = "勇士試煉",
    },
    ["Runeweaver Square"] = {
        ["enUS"] = true,
        ["deDE"] = "Runenweberplatz",
        ["esES"] = "Plaza Tejerruna",
        ["esMX"] = "Plaza Tejerruna",
        ["frFR"] = "Place Tisserune",
        ["koKR"] = "룬위버 광장",
        ["ptBR"] = "Praça Fiarruna",
        ["ruRU"] = "Площадь Руноплета",
        ["zhCN"] = "鲁因广场",
        ["zhTW"] = "織符者廣場",
    },
    ["The Silver Enclave"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Silberne Enklave",
        ["esES"] = "El Enclave de Plata",
        ["esMX"] = "El Enclave de Plata",
        ["frFR"] = "L'enclave Argentée",
        ["koKR"] = "은빛 자치구",
        ["ptBR"] = "Enclave Prateado",
        ["ruRU"] = "Серебряный Союз",
        ["zhCN"] = "银色领地",
        ["zhTW"] = "白銀領區",
    },
    ["Isle of Conquest No Man's Land"] = {
        ["enUS"] = true,
        ["deDE"] = "Niemandsland auf der Insel der Eroberung",
        ["esES"] = "Tierra de Nadie de Isla de la Conquista",
        ["esMX"] = "Tierra de Nadie de Isla de la Conquista",
        ["frFR"] = "No man's land de l'île des Conquérants",
        ["koKR"] = "정복의 섬 접근 금지",
        ["ptBR"] = "Terra de Ninguém da Ilha da Conquista",
        ["ruRU"] = "Остров Завоеваний нейтральная территория",
        ["zhCN"] = "征服之岛（禁区）",
        ["zhTW"] = "無人登陸的征服之島",
    },
    ["Deathspeaker's Watch"] = {
        ["enUS"] = true,
        ["deDE"] = "Todessprechers Wacht",
        ["esES"] = "Avanzada del Portavoz de la Muerte",
        ["esMX"] = "Avanzada del Portavoz de la Muerte",
        ["frFR"] = "Le Guet du nécrorateur",
        ["koKR"] = "죽음예언자 감시초소",
        ["ptBR"] = "Vigília do Morta-voz",
        ["ruRU"] = "Застава Вестника Смерти",
        ["zhCN"] = "亡语者岗哨",
        ["zhTW"] = "亡頌者之望",
    },
    ["Workshop"] = {
        ["enUS"] = true,
        ["deDE"] = "Werkstatt",
        ["esES"] = "Taller",
        ["esMX"] = "Taller",
        ["frFR"] = "Atelier",
        ["koKR"] = "작업장",
        ["ptBR"] = "Oficina",
        ["ruRU"] = "Мастерская",
        ["zhCN"] = "车间",
        ["zhTW"] = "工坊",
    },
    ["Quarry"] = {
        ["enUS"] = true,
        ["deDE"] = "Steinbruch",
        ["esES"] = "Cantera",
        ["esMX"] = "Cantera",
        ["frFR"] = "Carrière",
        ["koKR"] = "채석장",
        ["ptBR"] = "Pedreira",
        ["ruRU"] = "Каменоломня",
        ["zhCN"] = "采石场",
        ["zhTW"] = "礦場",
    },
    ["Docks"] = {
        ["enUS"] = true,
        ["deDE"] = "Docks",
        ["esES"] = "Muelles",
        ["esMX"] = "Muelles",
        ["frFR"] = "Docks",
        ["koKR"] = "부두",
        ["ptBR"] = "Docas",
        ["ruRU"] = "Причал",
        ["zhCN"] = "码头",
        ["zhTW"] = "碼頭",
    },
    ["Hangar"] = {
        ["enUS"] = true,
        ["deDE"] = "Hangar",
        ["esES"] = "Hangar",
        ["esMX"] = "Hangar",
        ["frFR"] = "Hangar",
        ["koKR"] = "격납고",
        ["ptBR"] = "Hangar",
        ["ruRU"] = "Ангар",
        ["zhCN"] = "飞艇基地",
        ["zhTW"] = "機棚",
    },
    ["Refinery"] = {
        ["enUS"] = true,
        ["deDE"] = "Raffinerie",
        ["esES"] = "Refinería",
        ["esMX"] = "Refinería",
        ["frFR"] = "Raffinerie",
        ["koKR"] = "정제소",
        ["ptBR"] = "Refinaria",
        ["ruRU"] = "Нефтезавод",
        ["zhCN"] = "油料精炼厂",
        ["zhTW"] = "精煉廠",
    },
    ["Horde Keep"] = {
        ["enUS"] = true,
        ["deDE"] = "Hordenfestung",
        ["esES"] = "Fortaleza de la Horda",
        ["esMX"] = "Fortaleza de la Horda",
        ["frFR"] = "Donjon de la Horde",
        ["koKR"] = "호드 요새",
        ["ptBR"] = "Bastilha da Horda",
        ["ruRU"] = "Крепость Орды",
        ["zhCN"] = "部落要塞",
        ["zhTW"] = "部落要塞",
    },
    ["Alliance Keep"] = {
        ["enUS"] = true,
        ["deDE"] = "Allianzfestung",
        ["esES"] = "Fortaleza de la Alianza",
        ["esMX"] = "Fortaleza de la Alianza",
        ["frFR"] = "Donjon de l'Alliance",
        ["koKR"] = "얼라이언스 요새",
        ["ptBR"] = "Bastilha da Aliança",
        ["ruRU"] = "Крепость Альянса",
        ["zhCN"] = "联盟要塞",
        ["zhTW"] = "聯盟要塞",
    },
    ["The Sea Reaver's Run"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Straße der Meerhäscher",
        ["esES"] = "La Travesía del Atracamar",
        ["esMX"] = "La Travesía del Atracamar",
        ["frFR"] = "Le trajet du Saccageur des mers",
        ["koKR"] = "바다 학살자의 터",
        ["ptBR"] = "Estreito do Aniquilador Marítimo",
        ["ruRU"] = "Пролив Грозы Морей",
        ["zhCN"] = "破海者航道",
        ["zhTW"] = "海劫者航道",
    },
    ["Transport: Alliance Gunship"] = {
        ["enUS"] = true,
        ["deDE"] = "Transport: Kanonenboot der Allianz",
        ["esES"] = "Transporte: Nave de Guerra de la Alianza",
        ["esMX"] = "Transporte: Nave de Guerra de la Alianza",
        ["frFR"] = "Transport : canonnière de l'Alliance",
        ["koKR"] = "수송: 얼라이언스 비행포격선",
        ["ptBR"] = "Transporte: Belonave da Aliança",
        ["ruRU"] = "Транспорт: Боевой корабль Альянса",
        ["zhCN"] = "交通工具：联盟炮艇",
        ["zhTW"] = "傳送:聯盟砲艇",
    },
    ["Transport: Horde Gunship"] = {
        ["enUS"] = true,
        ["deDE"] = "Transport: Kanonenboot der Horde",
        ["esES"] = "Transporte: Nave de Guerra de la Horda",
        ["esMX"] = "Transporte: Nave de Guerra de la Horda",
        ["frFR"] = "Transport : canonnière de la Horde",
        ["koKR"] = "수송: 호드 비행포격선",
        ["ptBR"] = "Transporte: Belonave da Horda",
        ["ruRU"] = "Транспорт: Боевой корабль Орды",
        ["zhCN"] = "交通工具：部落炮艇",
        ["zhTW"] = "傳送:部落砲艇",
    },
    ["Hrothgar's Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Hrothgars Landestelle",
        ["esES"] = "Desembarco de Hrothgar",
        ["esMX"] = "Desembarco de Hrothgar",
        ["frFR"] = "Accostage de Hrothgar",
        ["koKR"] = "흐로스가르 상륙지",
        ["ptBR"] = "Porto de Hrothgar",
        ["ruRU"] = "Лагерь Хротгара",
        ["zhCN"] = "洛斯加尔登陆点",
        ["zhTW"] = "赫魯斯加臺地",
    },
    ["The Forge of Souls"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Seelenschmiede",
        ["esES"] = "La Forja de Almas",
        ["esMX"] = "La Forja de Almas",
        ["frFR"] = "La Forge des âmes",
        ["koKR"] = "영혼의 제련소",
        ["ptBR"] = "Forja das Almas",
        ["ruRU"] = "Кузня Душ",
        ["zhCN"] = "灵魂洪炉",
        ["zhTW"] = "眾魂熔爐",
    },
    ["Pit of Saron"] = {
        ["enUS"] = true,
        ["deDE"] = "Grube von Saron",
        ["esES"] = "Foso de Saron",
        ["esMX"] = "Foso de Saron",
        ["frFR"] = "Fosse de Saron",
        ["koKR"] = "사론의 구덩이",
        ["ptBR"] = "Fosso de Saron",
        ["ruRU"] = "Яма Сарона",
        ["zhCN"] = "萨隆矿坑",
        ["zhTW"] = "薩倫之淵",
    },
    ["Halls of Reflection"] = {
        ["enUS"] = true,
        ["deDE"] = "Hallen der Reflexion",
        ["esES"] = "Cámaras de Reflexión",
        ["esMX"] = "Cámaras de Reflexión",
        ["frFR"] = "Salles des Reflets",
        ["koKR"] = "투영의 전당",
        ["ptBR"] = "Salões da Reflexão",
        ["ruRU"] = "Залы Отражений",
        ["zhCN"] = "映像大厅",
        ["zhTW"] = "倒影大廳",
    },
    ["Transport: Alliance Gunship (IGB)"] = {
        ["enUS"] = true,
        ["deDE"] = "Transport: Kanonenschiff der Allianz (IGB)",
        ["esES"] = "Transporte: Nave de Guerra de la Alianza",
        ["esMX"] = "Transporte: Nave de Guerra de la Alianza",
        ["frFR"] = "Transport: canonnière de l'Alliance (IGB)",
        ["koKR"] = "수송: 얼라이언스 비행포격선",
        ["ptBR"] = "Transporte: Belonave da Aliança (IGB)",
        ["ruRU"] = "Транспорт: боевой корабль Альянса (IGB)",
        ["zhCN"] = "Transport: Alliance Gunship (IGB)",
        ["zhTW"] = "傳送:聯盟砲艇(IGB)",
    },
    ["Transport: Horde Gunship (IGB)"] = {
        ["enUS"] = true,
        ["deDE"] = "Transport: Kanonenschiff der Horde (IGB)",
        ["esES"] = "Transporte: Nave de Guerra de la Horda",
        ["esMX"] = "Transporte: Nave de Guerra de la Horda",
        ["frFR"] = "Transport : canonnière de la Horde(IGB)",
        ["koKR"] = "수송: 호드 비행포격선",
        ["ptBR"] = "Transporte: Belonave da Horda (IGB)",
        ["ruRU"] = "Транспорт: боевой корабль Орды (IGB)",
        ["zhCN"] = "Transport: Horde Gunship (IGB)",
        ["zhTW"] = "傳送:部落砲艇(IGB)",
    },
    ["The Frost Queen's Lair"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Hort der Frostkönigin",
        ["esES"] = "La Guarida de la Reina de Escarcha",
        ["esMX"] = "La Guarida de la Reina de Escarcha",
        ["frFR"] = "Le repaire de la reine du Givre",
        ["koKR"] = "서리 여왕의 둥지",
        ["ptBR"] = "Covil da Rainha Gélida",
        ["ruRU"] = "Логово Королевы Льда",
        ["zhCN"] = "冰霜女王的巢穴",
        ["zhTW"] = "冰霜之后的巢穴",
    },
    ["Putricide's Laboratory of Alchemical Horrors and Fun"] = {
        ["enUS"] = true,
        ["deDE"] = "Seuchenmords Laboratorium der alchemistischen Schrecken und Späße",
        ["esES"] = "Laboratorio Horrores y Risas Alquímicas de Putricidio",
        ["esMX"] = "Laboratorio Horrores y Risas Alquímicas de Putricidio",
        ["frFR"] = "Laboratoire des désopilantes atrocités alchimiques de Putricide",
        ["koKR"] = "공포와 재미가 넘치는 퓨트리사이드의 연금술 실험실",
        ["ptBR"] = "Laboratório de Horrores e Diversões Alquímicas do Putricídio",
        ["ruRU"] = "Лаборатория алхимических ужасов и забав",
        ["zhCN"] = "普崔赛德的恐怖和娱乐化学实验室",
        ["zhTW"] = "普崔希德的恐懼與歡樂鍊金實驗室",
    },
    ["The Crimson Hall"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Blutrote Halle",
        ["esES"] = "La Sala Carmesí",
        ["esMX"] = "La Sala Carmesí",
        ["frFR"] = "La salle Cramoisie",
        ["koKR"] = "진홍빛 전당",
        ["ptBR"] = "Salão Carmesim",
        ["ruRU"] = "Багровый зал",
        ["zhCN"] = "血色厅堂",
        ["zhTW"] = "赤紅大廳",
    },
    ["The Frozen Throne"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Frostthron",
        ["esES"] = "El Trono Helado",
        ["esMX"] = "El Trono Helado",
        ["frFR"] = "Le Trône de glace",
        ["koKR"] = "얼어붙은 왕좌",
        ["ptBR"] = "O Trono de Gelo",
        ["ruRU"] = "Ледяной Трон",
        ["zhCN"] = "冰封王座",
        ["zhTW"] = "冰封王座",
    },
    ["The Sanctum of Blood"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Sanktum des Blutes",
        ["esES"] = "El Sagrario de Sangre",
        ["esMX"] = "El Sagrario de Sangre",
        ["frFR"] = "Le sanctum de Sang",
        ["koKR"] = "피의 성소",
        ["ptBR"] = "Sacrário de Sangue",
        ["ruRU"] = "Святилище Крови",
        ["zhCN"] = "鲜血秘室",
        ["zhTW"] = "血之聖所",
    },
    ["The Dark Approach"] = {
        ["enUS"] = true,
        ["deDE"] = "Der dunkle Zugang",
        ["esES"] = "El Trayecto Oscuro",
        ["esMX"] = "El Trayecto Oscuro",
        ["frFR"] = "La Sombre marche",
        ["koKR"] = "어둠의 진입로",
        ["ptBR"] = "Entrada Negra",
        ["ruRU"] = "Темный Подступ",
        ["zhCN"] = "黑暗小径",
        ["zhTW"] = "黑暗路徑",
    },
    ["Scourgelord's Command"] = {
        ["enUS"] = true,
        ["deDE"] = "Order des Geißelfürsten",
        ["esES"] = "Dominio del Señor de la Plaga",
        ["esMX"] = "Dominio del Señor de la Plaga",
        ["frFR"] = "Quartier général du seigneur du Fléau",
        ["koKR"] = "스컬지군주의 지휘소",
        ["ptBR"] = "Comando do Senhor do Flagelo",
        ["ruRU"] = "Смотровая площадка",
        ["zhCN"] = "天灾领主的指挥站",
        ["zhTW"] = "天譴領主指揮所",
    },
    ["The Shadow Throne"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Schattenthron",
        ["esES"] = "El Trono de las Sombras",
        ["esMX"] = "El Trono de las Sombras",
        ["frFR"] = "Le trône des Ombres",
        ["koKR"] = "어둠의 왕좌",
        ["ptBR"] = "O Trono das Sombras",
        ["ruRU"] = "Темный трон",
        ["zhCN"] = "暗影王座",
        ["zhTW"] = "暗影王座",
    },
    ["The Hidden Passage"] = {
        ["enUS"] = true,
        ["deDE"] = "Die versteckte Passage",
        ["esES"] = "El Pasaje Oculto",
        ["esMX"] = "El Pasaje Oculto",
        ["frFR"] = "Le passage secret",
        ["koKR"] = "숨겨진 통로",
        ["ptBR"] = "Passagem Secreta",
        ["ruRU"] = "Потайной ход",
        ["zhCN"] = "隐秘小径",
        ["zhTW"] = "隱藏通道",
    },
    ["Frostmourne"] = {
        ["enUS"] = true,
        ["deDE"] = "Frostgram",
        ["esES"] = "Agonía de Escarcha",
        ["esMX"] = "Agonía de Escarcha",
        ["frFR"] = "Deuillegivre",
        ["koKR"] = "서리한",
        ["ptBR"] = "Gélido Lamento",
        ["ruRU"] = "Ледяная Скорбь",
        ["zhCN"] = "霜之哀伤",
        ["zhTW"] = "霜之哀傷",
    },
    ["The Ruby Sanctum"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Rubinsanktum",
        ["esES"] = "El Sagrario Rubí",
        ["esMX"] = "El Sagrario Rubí",
        ["frFR"] = "Le sanctum Rubis",
        ["koKR"] = "루비 성소",
        ["ptBR"] = "Santuário Rubi",
        ["ruRU"] = "Рубиновое святилище",
        ["zhCN"] = "红玉圣殿",
        ["zhTW"] = "晶紅聖所",
    },
    ["Borean Tundra"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Boreanische Tundra",
        ["esES"] = "Tundra Boreal",
        ["esMX"] = "Tundra Boreal",
        ["frFR"] = "Toundra Boréenne",
        ["koKR"] = "북풍의 땅",
        ["ptBR"] = "Tundra Boreana",
        ["ruRU"] = "Борейская тундра",
        ["zhCN"] = "北风苔原",
        ["zhTW"] = "北風凍原",
    },
    ["Icecrown"] = {
        ["enUS"] = true,
        ["deDE"] = "Eiskrone",
        ["esES"] = "Corona de Hielo",
        ["esMX"] = "Corona de Hielo",
        ["frFR"] = "Couronne de glace",
        ["koKR"] = "얼음왕관",
        ["ptBR"] = "Coroa de Gelo",
        ["ruRU"] = "Ледяная Корона",
        ["zhCN"] = "冰冠冰川",
        ["zhTW"] = "寒冰皇冠",
    },
    ["Sholazar Basin"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Sholazarbecken",
        ["esES"] = "Cuenca de Sholazar",
        ["esMX"] = "Cuenca de Sholazar",
        ["frFR"] = "Bassin de Sholazar",
        ["koKR"] = "숄라자르 분지",
        ["ptBR"] = "Bacia Sholazar",
        ["ruRU"] = "Низина Шолазар",
        ["zhCN"] = "索拉查盆地",
        ["zhTW"] = "休拉薩盆地",
    },
    ["Dragonblight"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Drachenöde",
        ["esES"] = "Cementerio de Dragones",
        ["esMX"] = "Cementerio de Dragones",
        ["frFR"] = "Désolation des dragons",
        ["koKR"] = "용의 안식처",
        ["ptBR"] = "Praga Dragônica",
        ["ruRU"] = "Драконий Погост",
        ["zhCN"] = "龙骨荒野",
        ["zhTW"] = "龍骨荒野",
    },
    ["Battle for Wintergrasp"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schlacht um Tausendwinter",
        ["esES"] = "Batalla por Conquista del Invierno",
        ["esMX"] = "Batalla por Conquista del Invierno",
        ["frFR"] = "Bataille de Joug-d’hiver",
        ["koKR"] = "격전의 겨울손아귀",
        ["ptBR"] = "Batalha por Invérnia",
        ["ruRU"] = "Битва за озеро Ледяных Оков",
        ["zhCN"] = "冬拥湖之战",
        ["zhTW"] = "冬握湖戰鬥",
    },
    ["Westspark Workshop"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Werkstatt Westfunk",
        ["esES"] = "Taller Chispa Occidental",
        ["esMX"] = "Taller Chispa Occidental",
        ["frFR"] = "Atelier de l’Ouestincelle",
        ["koKR"] = "서부불꽃 작업장",
        ["ptBR"] = "Oficina do Parque Oeste",
        ["ruRU"] = "Мастерская Западной Искры",
        ["zhCN"] = "西部火花车间",
        ["zhTW"] = "西炫工坊",
    },
    ["The Steppe of Life"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Lebendige Steppe",
        ["esES"] = "Las Estepas de la Vida",
        ["esMX"] = "Las Estepas de la Vida",
        ["frFR"] = "Steppes de la Vie",
        ["koKR"] = "생명의 평원",
        ["ptBR"] = "Estepe da Vida",
        ["ruRU"] = "Степь Жизни",
        ["zhCN"] = "生命草原",
        ["zhTW"] = "生命冷原",
    },
    ["Eastspark Workshop"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Werkstatt Ostfunk",
        ["esES"] = "Taller Chispa Oriental",
        ["esMX"] = "Taller Chispa Oriental",
        ["frFR"] = "Atelier de l’Estincelle",
        ["koKR"] = "동부불꽃 작업장",
        ["ptBR"] = "Oficina do Parque Leste",
        ["ruRU"] = "Мастерская Восточной Искры",
        ["zhCN"] = "东部火花车间",
        ["zhTW"] = "東炫工坊",
    },
    ["The Chilled Quagmire"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Kühle Sumpf",
        ["esES"] = "El Cenagal Escalofrío",
        ["esMX"] = "El Cenagal Escalofrío",
        ["frFR"] = "Bourbier Glacial",
        ["koKR"] = "얼어붙은 수렁",
        ["ptBR"] = "Atoleiro Gelado",
        ["ruRU"] = "Холодная трясина",
        ["zhCN"] = "冰冷湿地",
        ["zhTW"] = "寒冽泥淖",
    },
    ["The Forest of Shadows"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Schattenwald",
        ["esES"] = "El Bosque de las Sombras",
        ["esMX"] = "El Bosque de las Sombras",
        ["frFR"] = "Forêt des Ombres",
        ["koKR"] = "그늘진 수풀",
        ["ptBR"] = "Floresta das Sombras",
        ["ruRU"] = "Лес Теней",
        ["zhCN"] = "阴影森林",
        ["zhTW"] = "暗影森林",
    },
    ["Glacial Falls"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Eiswasserfälle",
        ["esES"] = "Cascadas Glaciales",
        ["esMX"] = "Cascadas Glaciales",
        ["frFR"] = "Chutes Glaciales",
        ["koKR"] = "빙하 폭포",
        ["ptBR"] = "Cachoeira Glacial",
        ["ruRU"] = "Ледопады",
        ["zhCN"] = "冰川瀑布",
        ["zhTW"] = "冰川瀑布",
    },
    ["The Cauldron of Flames"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Flammenkessel",
        ["esES"] = "El Caldero de Llamas",
        ["esMX"] = "El Caldero de Llamas",
        ["frFR"] = "Chaudron des flammes",
        ["koKR"] = "불길의 가마솥",
        ["ptBR"] = "Caldeirão das Chamas",
        ["ruRU"] = "Огненная котловина",
        ["zhCN"] = "烈焰之坑",
        ["zhTW"] = "火焰熔爐",
    },
    ["Winter's Edge Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Wintersturzturm",
        ["esES"] = "Torre Filoinvierno",
        ["esMX"] = "Torre Filoinvierno",
        ["frFR"] = "Tour Bornehiver",
        ["koKR"] = "겨울 칼날 경비탑",
        ["ptBR"] = "Torre da Borda Invernal",
        ["ruRU"] = "Башня Клинка Зимы",
        ["zhCN"] = "冬缘塔楼",
        ["zhTW"] = "冬際哨塔",
    },
    ["Flamewatch Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Flammenaugenturm",
        ["esES"] = "Torre de la Guardia en Llamas",
        ["esMX"] = "Torre de la Guardia en Llamas",
        ["frFR"] = "Tour Guetteflamme",
        ["koKR"] = "불꽃감시 경비탑",
        ["ptBR"] = "Torre da Guarda Ígnea",
        ["ruRU"] = "Башня Огненного Дозора",
        ["zhCN"] = "火光塔楼",
        ["zhTW"] = "焰望哨塔",
    },
    ["Western Bridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Westliche Brücke",
        ["esES"] = "Puente Occidental",
        ["esMX"] = "Puente Occidental",
        ["frFR"] = "Pont de l’ouest",
        ["koKR"] = "서부 교각",
        ["ptBR"] = "Ponte Ocidental",
        ["ruRU"] = "Западный мост",
        ["zhCN"] = "西部桥梁",
        ["zhTW"] = "西部橋樑",
    },
    ["Central Bridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Zentrale Brücke",
        ["esES"] = "Puente Central",
        ["esMX"] = "Puente Central",
        ["frFR"] = "Pont central",
        ["koKR"] = "중앙 교각",
        ["ptBR"] = "Ponte Central",
        ["ruRU"] = "Центральный мост",
        ["zhCN"] = "中部桥梁",
        ["zhTW"] = "中央橋樑",
    },
    ["Wintergrasp Fortress"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Tausendwinterfestung",
        ["esES"] = "Fortaleza de Conquista del Invierno",
        ["esMX"] = "Fortaleza de Conquista del Invierno",
        ["frFR"] = "Forteresse de Joug-d’hiver",
        ["koKR"] = "겨울손아귀 요새",
        ["ptBR"] = "Fortaleza Invérnia",
        ["ruRU"] = "Крепость Ледяных Оков",
        ["zhCN"] = "冬拥堡垒",
        ["zhTW"] = "冬握堡壘",
    },
    ["The Sunken Ring"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Versunkene Ring",
        ["esES"] = "El Anillo Sumergido",
        ["esMX"] = "El Anillo Sumergido",
        ["frFR"] = "Arène Engloutie",
        ["koKR"] = "가라앉은 경기장",
        ["ptBR"] = "Ringue Enterrado",
        ["ruRU"] = "Затопленный Круг",
        ["zhCN"] = "沉降之环",
        ["zhTW"] = "沉沒之環",
    },
    ["Eastern Bridge"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Östliche Brücke",
        ["esES"] = "Puente Oriental",
        ["esMX"] = "Puente Oriental",
        ["frFR"] = "Pont de l’est",
        ["koKR"] = "동부 교각",
        ["ptBR"] = "Ponte Oriental",
        ["ruRU"] = "Восточный мост",
        ["zhCN"] = "东部桥梁",
        ["zhTW"] = "東部橋樑",
    },
    ["The Broken Temple"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Zerbrochene Tempel",
        ["esES"] = "El Templo Quebrado",
        ["esMX"] = "El Templo Quebrado",
        ["frFR"] = "Temple Brisé",
        ["koKR"] = "파괴된 신전",
        ["ptBR"] = "Templo Partido",
        ["ruRU"] = "Павший храм",
        ["zhCN"] = "破碎神殿",
        ["zhTW"] = "破碎神殿",
    },
    ["Shadowsight Tower"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Schattenblickturm",
        ["esES"] = "Torre de la Vista de las Sombras",
        ["esMX"] = "Torre de la Vista de las Sombras",
        ["frFR"] = "Tour d’Ombrevue",
        ["koKR"] = "그늘눈 경비탑",
        ["ptBR"] = "Mirante Negro",
        ["ruRU"] = "Башня Темного Взора",
        ["zhCN"] = "影目塔楼",
        ["zhTW"] = "影景哨塔",
    },
    ["The Lifeblood Pillar"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Lebensblutsäule",
        ["esES"] = "El Pilar Sangrevida",
        ["esMX"] = "El Pilar Sangrevida",
        ["frFR"] = "Pilier Sang-de-vie",
        ["koKR"] = "생명의 피 봉우리",
        ["ptBR"] = "Pilar Sangue Vital",
        ["ruRU"] = "Колонна Жизненной Силы",
        ["zhCN"] = "源血之柱",
        ["zhTW"] = "活血之柱",
    },
    ["The Lost Lands"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Verlorenen Lande",
        ["esES"] = "Las Tierras Perdidas",
        ["esMX"] = "Las Tierras Perdidas",
        ["frFR"] = "Terres Perdues",
        ["koKR"] = "잃어버린 땅",
        ["ptBR"] = "Terras Perdidas",
        ["ruRU"] = "Затерянные земли",
        ["zhCN"] = "迷失之地",
        ["zhTW"] = "失落之地",
    },
    ["The Skyreach Pillar"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Himmelszeltsäule",
        ["esES"] = "El Pilar del Trecho Celestial",
        ["esMX"] = "El Pilar del Trecho Celestial",
        ["frFR"] = "Pilier Confins-du-ciel",
        ["koKR"] = "하늘길 봉우리",
        ["ptBR"] = "Pilar Beira-céu",
        ["ruRU"] = "Колонна Небесного Пути",
        ["zhCN"] = "通天之柱",
        ["zhTW"] = "擎天之柱",
    },
    ["Hardknuckle Clearing"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Lichtung der Hartknöchel",
        ["esES"] = "Claro Callonudillo",
        ["esMX"] = "Claro Callonudillo",
        ["frFR"] = "Clairière des Poings-durs",
        ["koKR"] = "바위돌기고릴라 폐허",
        ["ptBR"] = "Clareira do Nodo",
        ["ruRU"] = "Зачистка барабанчей",
        ["zhCN"] = "硬皮旷野",
        ["zhTW"] = "硬拳空地",
    },
    ["Sapphire Hive"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Saphirschwarm",
        ["esES"] = "Enjambre Zafiro",
        ["esMX"] = "Enjambre Zafiro",
        ["frFR"] = "Ruche de Saphir",
        ["koKR"] = "사파이어 부화장",
        ["ptBR"] = "Colmeia Safira",
        ["ruRU"] = "Сапфирный улей",
        ["zhCN"] = "蓝玉虫巢",
        ["zhTW"] = "天藍蜂巢",
    },
    ["Wintergrasp River"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Tausendwinterfluss",
        ["esES"] = "Río Conquista del Invierno",
        ["esMX"] = "Río Conquista del Invierno",
        ["frFR"] = "Joug-d’hiver",
        ["koKR"] = "겨울손아귀 강",
        ["ptBR"] = "Rio Invérnia",
        ["ruRU"] = "Река Ледяных Оков",
        ["zhCN"] = "冬拥河",
        ["zhTW"] = "冬握河",
    },
    ["Frenzyheart River"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Strom der Wildherzen",
        ["esES"] = "Río Corazón Frenético",
        ["esMX"] = "Río Corazón Frenético",
        ["frFR"] = "Rivière de Frénécœur",
        ["koKR"] = "광란의심장 강",
        ["ptBR"] = "Rio dos Feralma",
        ["ruRU"] = "Река Бешеного Сердца",
        ["zhCN"] = "狂心河",
        ["zhTW"] = "狂心之河",
    },
    ["The Sundered Shard"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Versprengte Scherbe",
        ["esES"] = "El Fragmento Hendido",
        ["esMX"] = "El Fragmento Hendido",
        ["frFR"] = "Éclat scindé",
        ["koKR"] = "조각난 파편",
        ["ptBR"] = "Estilhaço Partido",
        ["ruRU"] = "Одинокий осколок",
        ["zhCN"] = "崩裂碎片",
        ["zhTW"] = "破碎裂片",
    },
    ["Frenzyheart Hill"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Hügel der Wildherzen",
        ["esES"] = "Colina Corazón Frenético",
        ["esMX"] = "Colina Corazón Frenético",
        ["frFR"] = "Colline de Frénécœur",
        ["koKR"] = "광란의심장 언덕",
        ["ptBR"] = "Morro dos Feralma",
        ["ruRU"] = "Холм Бешеного Сердца",
        ["zhCN"] = "狂心岭",
        ["zhTW"] = "狂心之丘",
    },
    ["Rainspeaker Rapids"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Katarakt der Regenrufer",
        ["esES"] = "Rápidos de Hablalluvia",
        ["esMX"] = "Rápidos de Hablalluvia",
        ["frFR"] = "Rapides parlepluie",
        ["koKR"] = "구름몰이 여울목",
        ["ptBR"] = "Corredeiras Pluvozes",
        ["ruRU"] = "Водопады Гласа Дождя",
        ["zhCN"] = "雨声河",
        ["zhTW"] = "雨頌者急湍",
    },
    ["Lakeside Landing"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Landeplatz am See",
        ["esES"] = "Pista del Lago",
        ["esMX"] = "Pista del Lago",
        ["frFR"] = "Terrain d’atterrissage de Rive-du-lac",
        ["koKR"] = "호반의 착륙장",
        ["ptBR"] = "Pouso Beiralago",
        ["ruRU"] = "Лагерь у озера",
        ["zhCN"] = "湖边着陆场",
        ["zhTW"] = "湖畔起降場",
    },
    ["River's Heart"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Flussnabel",
        ["esES"] = "Corazón del Río",
        ["esMX"] = "Corazón del Río",
        ["frFR"] = "Cœur du fleuve",
        ["koKR"] = "강의 심장부",
        ["ptBR"] = "Coração do Rio",
        ["ruRU"] = "Слияние рек",
        ["zhCN"] = "河流之心",
        ["zhTW"] = "大河之心",
    },
    ["Rainspeaker Canopy"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Baldachin der Regenrufer",
        ["esES"] = "Canope de Hablalluvia",
        ["esMX"] = "Canope de Hablalluvia",
        ["frFR"] = "Canopée Parlepluie",
        ["koKR"] = "구름몰이 거처",
        ["ptBR"] = "Dossel Pluvozes",
        ["ruRU"] = "Прибежище Гласа Дождя",
        ["zhCN"] = "雨声树屋",
        ["zhTW"] = "雨頌者之篷",
    },
    ["The Blight Line"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Seuchenfront",
        ["esES"] = "La Línea de Añublo",
        ["esMX"] = "La Línea de Añublo",
        ["frFR"] = "Ligne de la désolation",
        ["koKR"] = "파멸의 역병지",
        ["ptBR"] = "Confim da Praga",
        ["ruRU"] = "Увядшая поляна",
        ["zhCN"] = "荒芜边界",
        ["zhTW"] = "荒萎線",
    },
    ["Wildgrowth Mangal"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Wildwuchsmangal",
        ["esES"] = "Manglar Silvestre",
        ["esMX"] = "Manglar Silvestre",
        ["frFR"] = "Mangrove de la Croissance sauvage",
        ["koKR"] = "야생수풀 늪지대",
        ["ptBR"] = "Mangue Silvestre",
        ["ruRU"] = "Дикие мангровые заросли",
        ["zhCN"] = "蛮藤谷",
        ["zhTW"] = "叢生沼林",
    },
    ["Mosswalker Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Mooswandlerdorf",
        ["esES"] = "Poblado Caminamoho",
        ["esMX"] = "Poblado Caminamoho",
        ["frFR"] = "Marchemousse",
        ["koKR"] = "이끼걸음 마을",
        ["ptBR"] = "Aldeia Limâmbulo",
        ["ruRU"] = "Деревня Мохобродов",
        ["zhCN"] = "苔行村",
        ["zhTW"] = "苔行者村",
    },
    ["The Borean Wall"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Boreanische Wall",
        ["esES"] = "La Muralla Boreal",
        ["esMX"] = "La Muralla Boreal",
        ["frFR"] = "Mur Boréen",
        ["koKR"] = "북풍의 벽",
        ["ptBR"] = "Muralha Boreana",
        ["ruRU"] = "Борейская стена",
        ["zhCN"] = "北风之墙",
        ["zhTW"] = "北風之牆",
    },
    ["North Point Station"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Nordstation",
        ["esES"] = "Estación de la Punta Norte",
        ["esMX"] = "Estación de la Punta Norte",
        ["frFR"] = "Poste de la Halte du nord",
        ["koKR"] = "북부 거점",
        ["ptBR"] = "Estação Norte",
        ["ruRU"] = "Северная станция",
        ["zhCN"] = "北部哨站",
        ["zhTW"] = "北點抽水站",
    },
    ["Spire of Pain"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Säule der Pein",
        ["esES"] = "Aguja de Dolor",
        ["esMX"] = "Aguja de Dolor",
        ["frFR"] = "Flèche de la Douleur",
        ["koKR"] = "고통의 첨탑",
        ["ptBR"] = "Pináculo da Dor",
        ["ruRU"] = "Шпиль Боли",
        ["zhCN"] = "苦痛尖塔",
        ["zhTW"] = "苦痛尖塔",
    },
    ["Spire of Decay"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Säule der Fäulnis",
        ["esES"] = "Aguja de Putrefacción",
        ["esMX"] = "Aguja de Putrefacción",
        ["frFR"] = "Flèche de la Décomposition",
        ["koKR"] = "부패의 첨탑",
        ["ptBR"] = "Pináculo da Decomposição",
        ["ruRU"] = "Шпиль Порчи",
        ["zhCN"] = "凋零尖塔",
        ["zhTW"] = "凋零尖塔",
    },
    ["Spire of Blood"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Säule des Blutes",
        ["esES"] = "Aguja de Sangre",
        ["esMX"] = "Aguja de Sangre",
        ["frFR"] = "Flèche du Sang",
        ["koKR"] = "피의 첨탑",
        ["ptBR"] = "Torre Sangrenta",
        ["ruRU"] = "Шпиль Крови",
        ["zhCN"] = "鲜血尖塔",
        ["zhTW"] = "鮮血尖塔",
    },
    ["Festering Pools"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Eiterteiche",
        ["esES"] = "Pozas Purulentas",
        ["esMX"] = "Pozas Purulentas",
        ["frFR"] = "Bassins Purulents",
        ["koKR"] = "썩은 웅덩이",
        ["ptBR"] = "Poços Purulentos",
        ["ruRU"] = "Гнойные пруды",
        ["zhCN"] = "溃烂之池",
        ["zhTW"] = "膿瘡之池",
    },
    ["Talramas"] = {
        ["enUS"] = true,
        ["deDE"] = "Talramas",
        ["esES"] = "Talramas",
        ["esMX"] = "Talramas",
        ["frFR"] = "Talramas",
        ["koKR"] = "탈라마스",
        ["ptBR"] = "Talramas",
        ["ruRU"] = "Талрамас",
        ["zhCN"] = "塔尔拉玛斯",
        ["zhTW"] = "塔爾拉瑪斯",
    },
    ["Steam Springs"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Dampfquellen",
        ["esES"] = "Manantiales de Vapor",
        ["esMX"] = "Manantiales de Vapor",
        ["frFR"] = "Sources de vapeur",
        ["koKR"] = "증기 온천",
        ["ptBR"] = "Fontes de Vapor",
        ["ruRU"] = "Кипящие Источники",
        ["zhCN"] = "蒸汽之泉",
        ["zhTW"] = "蒸汽之泉",
    },
    ["The Flood Plains"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Flutebenen",
        ["esES"] = "Llanuras Anegadas",
        ["esMX"] = "Llanuras Anegadas",
        ["frFR"] = "Plaines Inondées",
        ["koKR"] = "범람 평야",
        ["ptBR"] = "Planícies Inundadas",
        ["ruRU"] = "Затопленные равнины",
        ["zhCN"] = "洪荒平原",
        ["zhTW"] = "氾濫平原",
    },
    ["The Geyser Fields"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Geysirfelder",
        ["esES"] = "Los Campos de Géiseres",
        ["esMX"] = "Los Campos de Géiseres",
        ["frFR"] = "Champs de Geysers",
        ["koKR"] = "간헐천 지대",
        ["ptBR"] = "Campos de Gêiser",
        ["ruRU"] = "Поле Гейзеров",
        ["zhCN"] = "喷泉平原",
        ["zhTW"] = "水泉原野",
    },
    ["Fizzcrank Pumping Station"] = {
        ["enUS"] = true,
        ["deDE"] = "Kurbelzischs Pumpstation",
        ["esES"] = "Estación de Bombeo de Palanqueta",
        ["esMX"] = "Estación de Bombeo de Palanqueta",
        ["frFR"] = "Station de pompage de Spumelevier",
        ["koKR"] = "피즈크랭크 채굴 현장",
        ["ptBR"] = "Estação Bombeadora do Biela",
        ["ruRU"] = "Насосная станция Выкрутеня",
        ["zhCN"] = "菲兹兰克泵站",
        ["zhTW"] = "嘶軸幫浦站",
    },
    ["The Court of Bones"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Hof der Knochen",
        ["esES"] = "El Patio de los Huesos",
        ["esMX"] = "El Patio de los Huesos",
        ["frFR"] = "Cour des Ossements",
        ["koKR"] = "해골 광장",
        ["ptBR"] = "Corte de Ossos",
        ["ruRU"] = "Двор Костей",
        ["zhCN"] = "白骨之庭",
        ["zhTW"] = "白骨之廷",
    },
    ["Icemist Village"] = {
        ["enUS"] = true,
        ["deDE"] = "Eisnebel",
        ["esES"] = "Poblado Bruma de Hielo",
        ["esMX"] = "Poblado Bruma de Hielo",
        ["frFR"] = "Brume-glace",
        ["koKR"] = "얼음안개 마을",
        ["ptBR"] = "Aldeia Bruma Boreal",
        ["ruRU"] = "Деревня Ледяной Пыли",
        ["zhCN"] = "冰雾村",
        ["zhTW"] = "冰霧村",
    },
    ["Westwind Refugee Camp"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Flüchtlingslager von Westwind",
        ["esES"] = "Campo de Refugiados de Viento Oeste",
        ["esMX"] = "Campo de Refugiados de Viento Oeste",
        ["frFR"] = "Camp de réfugiés de Ponevent",
        ["koKR"] = "서풍의 피난민 행렬",
        ["ptBR"] = "Campo de Refugiados de Zefirália",
        ["ruRU"] = "Лагерь беженцев Западного Ветра",
        ["zhCN"] = "西风避难营",
        ["zhTW"] = "西風難民營",
    },
    ["Obsidian Dragonshrine"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Obsidiandrachenschrein",
        ["esES"] = "Santuario de Dragones Obsidiana",
        ["esMX"] = "Santuario de Dragones Obsidiana",
        ["frFR"] = "Sanctuaire draconique obsidien",
        ["koKR"] = "흑요석 용제단",
        ["ptBR"] = "Santuário Dragônico Obsidiano",
        ["ruRU"] = "Обсидиановое святилище драконов",
        ["zhCN"] = "黑曜石巨龙圣地",
        ["zhTW"] = "黑曜龍殿",
    },
    ["Agmar's Hammer"] = {
        ["enUS"] = true,
        ["deDE"] = "Agmars Hammer",
        ["esES"] = "Martillo de Agmar",
        ["esMX"] = "El Martillo de Agmar",
        ["frFR"] = "Marteau d’Agmar",
        ["koKR"] = "아그마르의 망치",
        ["ptBR"] = "Martelo de Agmar",
        ["ruRU"] = "Молот Агмара",
        ["zhCN"] = "阿格玛之锤",
        ["zhTW"] = "阿格瑪之錘",
    },
    ["Coldwind Pass"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Kaltwindpass",
        ["esES"] = "Pasaje Viento Helado",
        ["esMX"] = "Pasaje Viento Helado",
        ["frFR"] = "Passe de Vent-froid",
        ["koKR"] = "눈바람 고개",
        ["ptBR"] = "Desfiladeiro Ventálgido",
        ["ruRU"] = "Перевал Холодного Ветра",
        ["zhCN"] = "冷风小径",
        ["zhTW"] = "冷風小徑",
    },
    ["Angrathar the Wrathgate"] = {
        ["enUS"] = true,
        ["deDE"] = "Angrathar",
        ["esES"] = "Angrathar la Puerta de Cólera",
        ["esMX"] = "Angrathar la Puerta de Cólera",
        ["frFR"] = "Angrathar",
        ["koKR"] = "분노의 관문 앙그라타르",
        ["ptBR"] = "Angrathar",
        ["ruRU"] = "Ангратар",
        ["zhCN"] = "天谴之门安加萨",
        ["zhTW"] = "『憤怒之門』安格拉薩",
    },
    ["Aldur'thar: The Desolation Gate"] = {
        ["enUS"] = true,
        ["deDE"] = "Aldur'thar: Das Tor der Verwüstung",
        ["esES"] = "Aldur'thar: La Puerta de la Desolación",
        ["esMX"] = "Aldur'thar: La Puerta de la Desolación",
        ["frFR"] = "Aldur’thar : la Porte de la Désolation",
        ["koKR"] = "알두르타르: 황폐의 관문",
        ["ptBR"] = "Aldur'thar: o Portão da Desolação",
        ["ruRU"] = "Алдур'тар: Врата Горя",
        ["zhCN"] = "荒凉之门奥尔杜萨",
        ["zhTW"] = "奧多薩：荒寂之門",
    },
    ["Silent Vigil"] = {
        ["enUS"] = true,
        ["deDE"] = "Die stille Nachtwache",
        ["esES"] = "Vigía Silencioso",
        ["esMX"] = "Vigía Silencioso",
        ["frFR"] = "Veille Silencieuse",
        ["koKR"] = "침묵의 망루",
        ["ptBR"] = "Vigia Silente",
        ["ruRU"] = "Молчаливое Бдение",
        ["zhCN"] = "沉默墓地",
        ["zhTW"] = "靜默警戒",
    },
    ["The Storm Peaks"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Sturmgipfel",
        ["esES"] = "Cumbres Tormentosas",
        ["esMX"] = "Las Cumbres Tormentosas",
        ["frFR"] = "Pics Foudroyés",
        ["koKR"] = "폭풍우 봉우리",
        ["ptBR"] = "Picos Tempestuosos",
        ["ruRU"] = "Грозовая Гряда",
        ["zhCN"] = "风暴峭壁",
        ["zhTW"] = "風暴群山",
    },
    ["Nidavelir"] = {
        ["enUS"] = true,
        ["deDE"] = "Nidavelir",
        ["esES"] = "Nidavelir",
        ["esMX"] = "Nidavelir",
        ["frFR"] = "Nidavelir",
        ["koKR"] = "니다벨리르",
        ["ptBR"] = "Nidavelir",
        ["ruRU"] = "Нидавелир",
        ["zhCN"] = "尼达维里尔",
        ["zhTW"] = "尼達維里爾",
    },
    ["Snowdrift Plains"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Verschneiten Ebenen",
        ["esES"] = "Llanuras Ventisquero",
        ["esMX"] = "Llanuras Ventisquero",
        ["frFR"] = "Plaines des Congères",
        ["koKR"] = "눈더미 평원",
        ["ptBR"] = "Planícies Nevadas",
        ["ruRU"] = "Снежные равнины",
        ["zhCN"] = "雪流平原",
        ["zhTW"] = "雪迅平原",
    },
    ["Sindragosa's Fall"] = {
        ["enUS"] = true,
        ["deDE"] = "Sindragosas Sturz",
        ["esES"] = "Caída de Sindragosa",
        ["esMX"] = "La Caída de Sindragosa",
        ["frFR"] = "Chute de Sindragosa",
        ["koKR"] = "신드라고사의 추락지",
        ["ptBR"] = "Queda de Sindragosa",
        ["ruRU"] = "Каньон Гибели Синдрагосы",
        ["zhCN"] = "辛达苟萨之墓",
        ["zhTW"] = "辛德拉苟莎之殞",
    },
    ["Uncharted Territory"] = {
        ["enUS"] = true,
        ["deDE"] = "Unerforschtes Gebiet",
        ["esES"] = "Territorio inexplorado",
        ["esMX"] = "Territorio no explorado",
        ["frFR"] = "Territoire inconnu",
        ["koKR"] = "미지의 땅",
        ["ptBR"] = "Território Desconhecido",
        ["ruRU"] = "Неизведанная территория",
        ["zhCN"] = "未知领域",
        ["zhTW"] = "未知領土",
    },
}

for k, v in pairs(northrendLocales) do
    l10n.translations[k] = v
end
