---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local weaponSkillLocales = {
    ["One-Handed Swords"] = {
        ["enUS"] = true,
        ["deDE"] = "Einhandschwerter",
        ["esES"] = "Espadas de una mano",
        ["esMX"] = "Espadas de una mano",
        ["frFR"] = "Épées à une main",
        ["koKR"] = "한손검류",
        ["ptBR"] = "Espadas de Uma Mão",
        ["ruRU"] = "Одноручные мечи",
        ["zhCN"] = "单手剑",
        ["zhTW"] = "單手劍",
    },
    ["One-Handed Maces"] = {
        ["enUS"] = true,
        ["deDE"] = "Einhandstreitkolben",
        ["esES"] = "Mazas de una mano",
        ["esMX"] = "Mazas de una mano",
        ["frFR"] = "Masse à une main",
        ["koKR"] = "한손둔기류",
        ["ptBR"] = "Maças de Uma Mão",
        ["ruRU"] = "Одноручные дробящие",
        ["zhCN"] = "单手锤",
        ["zhTW"] = "單手錘",
    },
    ["One-Handed Axes"] = {
        ["enUS"] = true,
        ["deDE"] = "Einhandäxte",
        ["esES"] = "Hachas de una mano",
        ["esMX"] = "Hachas de una mano",
        ["frFR"] = "Haches à une main",
        ["koKR"] = "한손도끼류",
        ["ptBR"] = "Machados de Uma Mão",
        ["ruRU"] = "Одноручные топоры",
        ["zhCN"] = "单手斧",
        ["zhTW"] = "單手斧",
    },
    ["Two-Handed Swords"] = {
        ["enUS"] = true,
        ["deDE"] = "Zweihandschwerter",
        ["esES"] = "Espadas de dos manos",
        ["esMX"] = "Espadas de dos manos",
        ["frFR"] = "Épées à deux mains",
        ["koKR"] = "양손검류",
        ["ptBR"] = "Espadas de Duas Mãos",
        ["ruRU"] = "Двуручные мечи",
        ["zhCN"] = "双手剑",
        ["zhTW"] = "雙手劍",
    },
    ["Two-Handed Maces"] = {
        ["enUS"] = true,
        ["deDE"] = "Zweihandstreitkolben",
        ["esES"] = "Mazas de dos manos",
        ["esMX"] = "Mazas de dos manos",
        ["frFR"] = "Masses à deux mains",
        ["koKR"] = "양손둔기류",
        ["ptBR"] = "Maças de Duas Mãos",
        ["ruRU"] = "Двуручные дробящие",
        ["zhCN"] = "双手锤",
        ["zhTW"] = "雙手錘",
    },
    ["Two-Handed Axes"] = {
        ["enUS"] = true,
        ["deDE"] = "Zweihandäxte",
        ["esES"] = "Hachas de dos manos",
        ["esMX"] = "Hachas de dos manos",
        ["frFR"] = "Haches à deux mains",
        ["koKR"] = "양손도끼류",
        ["ptBR"] = "Machados de Duas Mãos",
        ["ruRU"] = "Двуручные топоры",
        ["zhCN"] = "双手斧",
        ["zhTW"] = "雙手斧",
    },
    ["Fist Weapons"] = {
        ["enUS"] = true,
        ["deDE"] = "Faustwaffen",
        ["esES"] = "Armas de puño",
        ["esMX"] = "Armas de puño",
        ["frFR"] = "Armes de pugilat",
        ["koKR"] = "장착 무기류",
        ["ptBR"] = "Armas de Punho",
        ["ruRU"] = "Кистевое оружие",
        ["zhCN"] = "拳套",
        ["zhTW"] = "拳套",
    },
    ["Daggers"] = {
        ["enUS"] = true,
        ["deDE"] = "Dolche",
        ["esES"] = "Dagas",
        ["esMX"] = "Dagas",
        ["frFR"] = "Dagues",
        ["koKR"] = "단검류",
        ["ptBR"] = "Adagas",
        ["ruRU"] = "Кинжалы",
        ["zhCN"] = "匕首",
        ["zhTW"] = "匕首",
    },
    ["Thrown"] = {
        ["enUS"] = true,
        ["deDE"] = "Wurfwaffen",
        ["esES"] = "Arrojadizas",
        ["esMX"] = "Arrojadizas",
        ["frFR"] = "Armes de jet",
        ["koKR"] = "투척 무기류",
        ["ptBR"] = "Arremesso",
        ["ruRU"] = "Метательное оружие",
        ["zhCN"] = "投掷",
        ["zhTW"] = "投擲武器",
    },
    ["Bows"] = {
        ["enUS"] = true,
        ["deDE"] = "Bögen",
        ["esES"] = "Arcos",
        ["esMX"] = "Arcos",
        ["frFR"] = "Arcs",
        ["koKR"] = "활류",
        ["ptBR"] = "Arcos",
        ["ruRU"] = "Луки",
        ["zhCN"] = "弓",
        ["zhTW"] = "弓",
    },
    ["Crossbows"] = {
        ["enUS"] = true,
        ["deDE"] = "Armbrüste",
        ["esES"] = "Ballestas",
        ["esMX"] = "Ballestas",
        ["frFR"] = "Arbalètes",
        ["koKR"] = "석궁류",
        ["ptBR"] = "Bestas",
        ["ruRU"] = "Арбалеты",
        ["zhCN"] = "弩",
        ["zhTW"] = "弩",
    },
    ["Guns"] = {
        ["enUS"] = true,
        ["deDE"] = "Schusswaffen",
        ["esES"] = "Armas de fuego",
        ["esMX"] = "Armas de fuego",
        ["frFR"] = "Armes à feu",
        ["koKR"] = "총기류",
        ["ptBR"] = "Armas de Fogo",
        ["ruRU"] = "Огнестрельное оружие",
        ["zhCN"] = "枪械",
        ["zhTW"] = "槍械",
    },
    ["Staves"] = {
        ["enUS"] = true,
        ["deDE"] = "Stäbe",
        ["esES"] = "Bastones",
        ["esMX"] = "Bastones",
        ["frFR"] = "Bâtons",
        ["koKR"] = "지팡이류",
        ["ptBR"] = "Cajados",
        ["ruRU"] = "Посохи",
        ["zhCN"] = "法杖",
        ["zhTW"] = "法杖",
    },
    ["Polearms"] = {
        ["enUS"] = true,
        ["deDE"] = "Stangenwaffen",
        ["esES"] = "Armas de asta",
        ["esMX"] = "Armas de asta",
        ["frFR"] = "Armes d'hast",
        ["koKR"] = "장창류",
        ["ptBR"] = "Armas de Haste",
        ["ruRU"] = "Древковое оружие",
        ["zhCN"] = "长柄武器",
        ["zhTW"] = "長柄武器",
    },
}

for k, v in pairs(weaponSkillLocales) do
    l10n.translations[k] = v
end