---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local tutorialLocals = {
    ["Welcome to Questie"] = {
        ["enUS"] = true,
        ["deDE"] = "Willkommen bei Questie",
        ["esES"] = "Bienvenido a Questie",
        ["esMX"] = "Bienvenido a Questie",
        ["frFR"] = "Bienvenue sur Questie",
        ["koKR"] = "퀘스티에 오신 것을 환영합니다",
        ["ptBR"] = "Bem-vindo ao Questie",
        ["ruRU"] = "Добро пожаловать в Questie",
        ["zhCN"] = "欢迎来到 Questie",
        ["zhTW"] = "歡迎使用任務位置提示插件 Questie",
    },
    ["With WotLK Phase 4 Blizzard introduced their own quest objective system.\n\nPlease choose the objective style you want to use:"] = {
        ["enUS"] = true,
        ["deDE"] = "Mit der Phase 4 von WotLK hat Blizzard sein eigenes Questziel-System eingeführt.\n\nBitte wähle den Stil den du nutzen möchtest:",
        ["esES"] = "Con la Fase 4 de WoTLK, Blizzard introdujo su propio sistema de objetivos de misiones.\n\nElija el estilo objetivo que deseas utilizar:",
        ["esMX"] = "Con la Fase 4 de WoTLK, Blizzard introdujo su propio sistema de objetivos de misiones.\n\nElija el estilo objetivo que deseas utilizar:",
        ["frFR"] = "Avec WotLK Phase 4, Blizzard a introduit son propre système d'objectifs de quête.\n\nVeuillez choisir le style d'objectif que vous souhaitez utiliser :",
        ["koKR"] = "리치왕의 분노 페이즈4 에서는 블리자드 순정 퀘스트 추적기가 제공됩니다. \n\n사용하고 싶은 퀘스트 추적기 종류를 선택하여 주십시오",
        ["ptBR"] = "Com a Fase 4 de WotLK, a Blizzard introduziu seu próprio sistema de objetivos de missão.\n\nPor favor, escolha o estilo de objetivo que deseja usar:",
        ["ruRU"] = "В 4-й фазе Гнева Короля Лича разработчики Blizzard представили их собственную систему целей заданий.\n\nПожалуйста, выберите стиль целей, который вы будете использовать:",
        ["zhCN"] = "在巫妖王之怒第四阶段中，暴雪引入了他们自己的任务目标系统。\n\n请选择您想要使用的目标样式：",
        ["zhTW"] = "在巫妖王之怒第四階段中，暴雪引入了他們自己的任務目標系統。\n\n請選擇您想要使用的目標風格：",
    },
    ["Questie Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie Questziele",
        ["esES"] = "Objetivos de Questie",
        ["esMX"] = "Objetivos de Questie",
        ["frFR"] = "Objectifs de Questie",
        ["koKR"] = "퀘스트 목표",
        ["ptBR"] = "Objetivos de Questie",
        ["ruRU"] = "Цели Questie",
        ["zhCN"] = "Questie 目标",
        ["zhTW"] = "Questie 目標",
    },
    ["pfQuest Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "pfQuest Questziele",
        ["esES"] = "Objetivos de pfQuest",
        ["esMX"] = "Objetivos de pfQuest",
        ["frFR"] = "Objectifs de pfQuest",
        ["koKR"] = "pfQuest 목표",
        ["ptBR"] = "Objetivos de pfQuest",
        ["ruRU"] = "Цели pfQuest",
        ["zhCN"] = "pfQuest 目标",
        ["zhTW"] = "pfQuest 目標",
    },
    ["Blizzard Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Blizzard Questziele",
        ["esES"] = "Objetivos de Blizzard",
        ["esMX"] = "Objetivos de Blizzard",
        ["frFR"] = "Objectifs de Blizzard",
        ["koKR"] = "블리자드 목표",
        ["ptBR"] = "Objetivos de Blizzard",
        ["ruRU"] = "Цели Blizzard",
        ["zhCN"] = "暴雪原始目标",
        ["zhTW"] = "暴雪原始目標",
    },
    ["Questie can show you the locations of runes for your class from previous SoD Phases.\n\n"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie kann die Orte der Runen aus vorherigen SoD Phasen für deine Klasse anzeigen.\n\n",
        ["esES"] = "Questie puede mostrarte las ubicaciones de las runas para tu clase de fases anteriores de SoD.\n\n",
        ["esMX"] = "Questie puede mostrarte las ubicaciones de las runas para tu clase de fases anteriores de SoD.\n\n",
        ["frFR"] = "Questie peut afficher les emplacements des runes des phases précédentes de SoD pour votre classe.\n\n",
        ["koKR"] = "Questie는 이전 SoD 단계에서 귀하의 직업에 대한 룬 위치를 표시할 수 있습니다.\n\n",
        ["ptBR"] = "Questie pode mostrar a você as localizações das runas para a sua classe das fases anteriores de SoD.\n\n",
        ["ruRU"] = "Questie может показать вам местоположения рун для вашего класса из предыдущих фаз SoD.\n\n",
        ["zhCN"] = "Questie 可以显示你的职业在以往 SoD 阶段的符文位置。\n\n",
        ["zhTW"] = "Questie 可以顯示你的職業在之前的探索賽季階段的符文位置。\n\n",
    },
    ["Rune locations are marked with the following symbol:"] = {
        ["enUS"] = true,
        ["deDE"] = "Runenstandorte sind mit dem folgenden Symbol markiert:",
        ["esES"] = "Las ubicaciones de las runas están marcadas con el siguiente símbolo:",
        ["esMX"] = "Las ubicaciones de las runas están marcadas con el siguiente símbolo:",
        ["frFR"] = "La position des runes est indiquée par le symbole suivant:",
        ["koKR"] = "룬 위치는 다음 기호로 표시됩니다:",
        ["ptBR"] = "As localizações das runas são marcadas com o seguinte símbolo:",
        ["ruRU"] = "Местоположения рун отмечены следующим символом:",
        ["zhCN"] = "符文位置以以下符号标记：",
        ["zhTW"] = "符文位置使用以下符號標記:",
    },
    ["Please choose if you want to see them or not\n"] = {
        ["enUS"] = true,
        ["deDE"] = "Bitte wähle, ob sie angezeigt werden sollen oder nicht\n",
        ["esES"] = "Por favor, elige si deseas verlas o no\n",
        ["esMX"] = "Por favor, elige si deseas verlas o no\n",
        ["frFR"] = "Choisissez si vous voulez les voir ou non\n",
        ["koKR"] = "룬 위치들을 보고 싶은지 여부를 선택해주세요\n",
        ["ptBR"] = "Por favor, escolha se deseja vê-las ou não\n",
        ["ruRU"] = "Пожалуйста, выберите, хотите вы их видеть или нет\n",
        ["zhCN"] = "请选择是否显示它们\n",
        ["zhTW"] = "請選擇是否想要看到\n",
    },
    ["(This can always be changed in the Icons tab of the settings)"] = {
        ["enUS"] = true,
        ["deDE"] = "(Dies kann immer im Reiter Icons der Einstellungen geändert werden)",
        ["esES"] = "(Esto siempre se puede cambiar en la pestaña de Iconos de las opciones)",
        ["esMX"] = "(Esto siempre se puede cambiar en la pestaña de Iconos de las opciones)",
        ["frFR"] = "(Ce choix peut être changé à nouveau dans l'onglet Icones des options)",
        ["koKR"] = "(이 설정은 항상 아이콘 탭에서 변경할 수 있습니다)",
        ["ptBR"] = "(Isso sempre pode ser alterado na guia de Ícones nas opções)",
        ["ruRU"] = "(это всегда может быть изменено в настройках на вкладке Значки)",
        ["zhCN"] = "（此设置可随时在设置中的图标标签页中更改）",
        ["zhTW"] = "(隨時都可以在設定選項的圖示標籤頁面中更改)",
    },
    ["Questie can automatically reject quests shared to you\nwhile you are in a battleground.\n\n\nDo you want to activate this?"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie kann automatisch Quests ablehnen, die in dir\nauf einem Schlachtfeld geteilt werden.\n\n\nMöchtest du das aktivieren?",
        ["esES"] = "Questie puede rechazar automáticamente las misiones que te compartan\nmientras estás en un campo de batalla.\n\n\n¿Quieres activar esto?",
        ["esMX"] = "Questie puede rechazar automáticamente las misiones que te compartan\nmientras estás en un campo de batalla.\n\n\n¿Quieres activar esto?",
        ["frFR"] = "Questie peut rejeter automatiquement les quêtes partagées avec vous\npendant que vous êtes sur un champ de bataille.\n\n\nSouhaitez-vous activer cela ?",
        ["koKR"] = false,
        ["ptBR"] = "Questie pode rejeitar automaticamente as missões compartilhadas com você\nenquanto estiver em um campo de batalha.\n\n\nDeseja ativar isso?",
        ["ruRU"] = "На поле боя Questie может автоматически отменять задания,\nкоторыми поделились с вами.\n\n\nХотите ли вы включить это?",
        ["zhCN"] = "当你在战场中，Questie 可以\n自动拒绝分享给你的任务。\n\n\n是否要启用此功能？",
        ["zhTW"] = "當你在戰場中，Questie 可以\n自動拒絕分享給你的任務。\n\n\n是否要啟用這個功能?",
    }
}

for k, v in pairs(tutorialLocals) do
    l10n.translations[k] = v
end
