---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local trackerUILocales = {
    ["Questie Tracker"] = {
        ["enUS"] = true,
        ["deDE"] = "Aktive Quests",
        ["esES"] = "Rastreador de Questie",
        ["esMX"] = "Rastreador de Questie",
        ["frFR"] = "Suivi de Questie",
        ["koKR"] = "활성 퀘스트",
        ["ptBR"] = "Rastreador de Questie",
        ["ruRU"] = "Активные задания",
        ["zhCN"] = "当前任务",
        ["zhTW"] = "任務",
    },
    ---------------------------------------------------------
    -- Sizer
    ["Sizer Mode"] = {
        ["enUS"] = true,
        ["deDE"] = "Sizer-Modus",
        ["esES"] = "Modo de medición",
        ["esMX"] = "Modo de medición",
        ["frFR"] = "Mode de calibrage",
        ["koKR"] = "사이저 모드",
        ["ptBR"] = "Modo de medição",
        ["ruRU"] = "Режим сайзера",
        ["zhCN"] = "分级器模式",
        ["zhTW"] = "調整模式",
    },
    ["Resize Tracker"] = {
        ["enUS"] = true,
        ["deDE"] = "Größe des Trackers ändern",
        ["esES"] = "Redimensionar rastreador",
        ["esMX"] = "Redimensionar rastreador",
        ["frFR"] = "Redimensionner le suivi",
        ["koKR"] = "트래커 크기 조정",
        ["ptBR"] = "Redimensionar rastreador",
        ["ruRU"] = "Изменить размера трекера",
        ["zhCN"] = "调整跟踪器",
        ["zhTW"] = "調整任務清單大小",
    },
    ["Reset Sizer"] = {
        ["enUS"] = true,
        ["deDE"] = "Sizer zurücksetzen",
        ["esES"] = "Restablecer medidor",
        ["esMX"] = "Restablecer medidor",
        ["frFR"] = "Réinitialiser le calibreur",
        ["koKR"] = "Sizer 재설정",
        ["ptBR"] = "Redefinir medidor",
        ["ruRU"] = "Сбросить сайзер",
        ["zhCN"] = "重置 Sizer",
        ["zhTW"] = "重置大小",
    },
    ["NOTE"] = {
        ["enUS"] = true,
        ["deDE"] = "NOTIZ",
        ["esES"] = "NOTA",
        ["esMX"] = "NOTA",
        ["frFR"] = "REMARQUE",
        ["koKR"] = "메모",
        ["ptBR"] = "NOTA",
        ["ruRU"] = "ПРИМЕЧАНИЕ",
        ["zhCN"] = "笔记",
        ["zhTW"] = "筆記",
    },
    ["The Tracker Height Ratio\nis ignored while in Manual mode"] = {
        ["enUS"] = true,
        ["deDE"] = "Das Tracker-Höhenverhältnis\nwird im manuellen Modus ignoriert",
        ["esES"] = "La relación de altura del rastreador\nse ignora mientras está en modo manual",
        ["esMX"] = "La relación de altura del rastreador\nse ignora mientras está en modo manual",
        ["frFR"] = "Le rapport de hauteur du suivi\nest ignoré en mode manuel",
        ["koKR"] = "수동 모드에서는 추적기 높이 비율이 무시됩니다.",
        ["ptBR"] = "A relação de altura do\nrastreador é ignorada no modo manual",
        ["ruRU"] = "Соотношение высоты трекера игнорируется в ручном режиме",
        ["zhCN"] = "在手動模式下忽略跟踪器高度比",
        ["zhTW"] = "手動模式下忽略任務清單的高度比例",
    },
    ---------------------------------------------------------
    -- Questie Icon (Active Quest Header)
    ["Toggle Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Einstellungen anzeigen/verstecken",
        ["esES"] = "Mostrar opciones",
        ["esMX"] = "Mostrar opciones",
        ["frFR"] = "Afficher options",
        ["koKR"] = "설정 열기",
        ["ptBR"] = "Mostrar / Ocultar opções",
        ["ruRU"] = "Открыть/закрыть настройки",
        ["zhCN"] = "打开设置",
        ["zhTW"] = "設定選項",
    },
    -- "Toggle My Journey" is in MinimapIcon.lua
    ["Drag while Unlocked"] = {
        ["enUS"] = true,
        ["deDE"] = "Ziehen, während entsperrt",
        ["esES"] = "Arrastra mientras está desbloqueado",
        ["esMX"] = "Arrastra mientras está desbloqueado",
        ["frFR"] = "Glisser pendant le déverrouillage",
        ["koKR"] = "잠금 해제 상태에서 드래그",
        ["ptBR"] = "Arraste enquanto desbloqueado",
        ["ruRU"] = "Перетаскивать, если разблокирован",
        ["zhCN"] = "解锁时拖动",
        ["zhTW"] = "解鎖時拖曳移動",
    },
    ["Drag while Locked"] = {
        ["enUS"] = true,
        ["deDE"] = "Ziehen, während gesperrt",
        ["esES"] = "Arrastra mientras está bloqueado",
        ["esMX"] = "Arrastra mientras está bloqueado",
        ["frFR"] = "Glisser pendant le verrouillage",
        ["koKR"] = "잠금 상태에서 드래그",
        ["ptBR"] = "Arraste enquanto estiver bloqueado",
        ["ruRU"] = "Перетаскивать, если заблокирован",
        ["zhCN"] = "锁定时拖动",
        ["zhTW"] = "鎖定時拖曳移動",
    },
    ["Questie Tracker Integrations"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker-Integrationen",
        ["esES"] = "Integraciones del rastreador",
        ["esMX"] = "Integraciones del rastreador",
        ["frFR"] = "Intégrations de suivi",
        ["koKR"] = "통합 퀘스티 추적기",
        ["ptBR"] = "Integrações do rastreador",
        ["ruRU"] = "Интеграции трекера",
        ["zhCN"] = "Questie 追踪器集成",
        ["zhTW"] = "整合插件",
    },
    -- VoiceOver Integration
    ["VoiceOver"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = true,
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
    },
    ["Hold shift to see PlayButtons"] = {
        ["enUS"] = true,
        ["deDE"] = "Halte Shift gedrückt, um Play-Buttons zu sehen",
        ["esES"] = "Manten presionada la tecla mayús para ver los PlayButtons",
        ["esMX"] = "Manten presionada la tecla mayús para ver los PlayButtons",
        ["frFR"] = "Maintenez la touche Maj enfoncée pour voir les PlayButtons",
        ["koKR"] = "플레이 버튼을 보기 위해서는 쉬프트 키를 누르고 계세요",
        ["ptBR"] = "Pressione Shift para ver os PlayButtons",
        ["ruRU"] = "Зажмите Shift, чтобы увидеть PlayButtons",
        ["zhCN"] = "按住 Shift 键查看播放按钮",
        ["zhTW"] = "按住 Shift 顯示播放按鈕",
    },
    -- TomTom Integration
    ["TomTom"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = true,
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
    },
    ["Ctrl + Left Click or Right Click a Quest Title"] = {
        ["enUS"] = true,
        ["deDE"] = "Strg + Links- oder Rechtsklick auf einen Quest-Titel",
        ["esES"] = "Ctrl + clic izquierdo o clic derecho en el título de una misión",
        ["esMX"] = "Ctrl + clic izquierdo o clic derecho en el título de una misión",
        ["frFR"] = "Ctrl + Clic gauche ou clic droit sur un titre de quête",
        ["koKR"] = "퀘스트 제목 컨트롤 + 좌클릭 혹은 우클릭",
        ["ptBR"] = "Ctrl + Clique esquerdo ou direito em um título de missão",
        ["ruRU"] = "Ctrl + ЛКМ или ПКМ на названии задания",
        ["zhCN"] = "Ctrl + 左键单击或右键单击任务标题",
        ["zhTW"] = "Ctrl+左鍵或右鍵點擊任務標題",
    },
    ---------------------------------------------------------
    -- Quest/Achievement Right Click Menu
    ["Focus Quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest fokussieren",
        ["esES"] = "Enfocar misión",
        ["esMX"] = "Enfocar misión",
        ["frFR"] = "Prioriser cette quête",
        ["koKR"] = "관심 퀘스트",
        ["ptBR"] = "Focar missão",
        ["ruRU"] = "Фокусировка на задании",
        ["zhCN"] = "关注任务",
        ["zhTW"] = "關注任務",
    },
    ["Focus Objective"] = {
        ["enUS"] = true,
        ["deDE"] = "Questziel fokussieren",
        ["esES"] = "Enfocar objetivo",
        ["esMX"] = "Enfocar objetivo",
        ["frFR"] = "Objectif prioritaire",
        ["koKR"] = "관심 목표",
        ["ptBR"] = "Focar objetivo",
        ["ruRU"] = "Фокусировка на цели",
        ["zhCN"] = "关注目标",
        ["zhTW"] = "關注目標",
    },
    ["Unfocus"] = {
        ["enUS"] = true,
        ["deDE"] = "Fokus entfernen",
        ["esES"] = "Desenfocar",
        ["esMX"] = "Desenfocar",
        ["frFR"] = "Ne plus prioriser",
        ["koKR"] = "관심 퀘스트 해제",
        ["ptBR"] = "Desfocar",
        ["ruRU"] = "Сбросить фокусировку",
        ["zhCN"] = "停止关注",
        ["zhTW"] = "停止關注",
    },
    -- "Set TomTom Target" is in the Tracker.lua inside the Translations/Options directory
    ["Minimize Quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Suche minimieren",
        ["esES"] = "Minimizar misión",
        ["esMX"] = "Minimizar misión",
        ["frFR"] = "Minimiser la quête",
        ["koKR"] = "퀘스트 최소화",
        ["ptBR"] = "Minimizar missão",
        ["ruRU"] = "Свернуть задание",
        ["zhCN"] = "最小化任务",
        ["zhTW"] = "最小化任務",
    },
    ["Hide Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons verstecken",
        ["esES"] = "Ocultar iconos",
        ["esMX"] = "Ocultar iconos",
        ["frFR"] = "Cacher les icônes",
        ["koKR"] = "아이콘 가리기",
        ["ptBR"] = "Ocultar ícones",
        ["ruRU"] = "Скрыть значки",
        ["zhCN"] = "隐藏标记",
        ["zhTW"] = "隱藏圖示",
    },
    ["Show Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Icons anzeigen",
        ["esES"] = "Mostrar iconos",
        ["esMX"] = "Mostrar iconos",
        ["frFR"] = "Afficher les icônes",
        ["koKR"] = "아이콘 표시",
        ["ptBR"] = "Mostrar ícones",
        ["ruRU"] = "Показать значки",
        ["zhCN"] = "显示标记",
        ["zhTW"] = "顯示圖示",
    },
    ["Show on Map"] = {
        ["enUS"] = true,
        ["deDE"] = "Auf der Karte zeigen",
        ["esES"] = "Mostrar en mapa",
        ["esMX"] = "Mostrar en mapa",
        ["frFR"] = "Afficher sur la carte",
        ["koKR"] = "지도에 표시",
        ["ptBR"] = "Mostrar no mapa",
        ["ruRU"] = "Показать на карте",
        ["zhCN"] = "地图上显示",
        ["zhTW"] = "在地圖上顯示",
    },
    ["Show in Quest Log"] = {
        ["enUS"] = true,
        ["deDE"] = "In Questlog anzeigen",
        ["esES"] = "Mostrar en registro de misiones",
        ["esMX"] = "Mostrar en registro de misiones",
        ["frFR"] = "Afficher dans le journal de quête",
        ["koKR"] = "퀘스트 목록에서 열기",
        ["ptBR"] = "Mostrar no registro de missões",
        ["ruRU"] = "Показать в журнале заданий",
        ["zhCN"] = "开启任务日志",
        ["zhTW"] = "顯示任務內容",
    },
    ["Show in Achievements Log"] = {
        ["enUS"] = true,
        ["deDE"] = "Im Erfolgsprotokoll anzeigen",
        ["esES"] = "Mostrar en registro de logros",
        ["esMX"] = "Mostrar en registro de logros",
        ["frFR"] = "Afficher dans le journal des réalisations",
        ["koKR"] = "업적 로그에 표시",
        ["ptBR"] = "Mostrar no Registro de Conquistas",
        ["ruRU"] = "Показать в журнале достижений",
        ["zhCN"] = "在成就日志中显示",
        ["zhTW"] = "顯示成就內容",
    },
    ["Link Quest to chat"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest in Chat verlinken",
        ["esES"] = "Vincular misión al chat",
        ["esMX"] = "Vincular misión al chat",
        ["frFR"] = "Linker la quêter dans la discussion",
        ["koKR"] = "채팅창에 퀘스트 링크",
        ["ptBR"] = "Enviar missão para o chat",
        ["ruRU"] = "Ссылка на задание в чат",
        ["zhCN"] = "将任务连接到聊天框",
        ["zhTW"] = "將任務貼到對話視窗",
    },
    ["Link Achievement to chat"] = {
        ["enUS"] = true,
        ["deDE"] = "Verknüpfen Sie den Erfolg mit dem Chat",
        ["esES"] = "Vincular logro al chat",
        ["esMX"] = "Vincular logro al chat",
        ["frFR"] = "Lier la réussite au chat",
        ["koKR"] = "업적을 채팅에 연결",
        ["ptBR"] = "Conquista de link para bate-papo",
        ["ruRU"] = "Ссылка на достижение в чат",
        ["zhCN"] = "将成就链接到聊天",
        ["zhTW"] = "將成就貼到對話視窗",
    },
    ["Untrack Quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Questfokussieren entfernen",
        ["esES"] = "No rastrear misión",
        ["esMX"] = "No rastrear misión",
        ["frFR"] = "Annuler le suivi",
        ["koKR"] = "퀘스트 추적해제",
        ["ptBR"] = "Não rastrear a missão",
        ["ruRU"] = "Не отслеживать задание",
        ["zhCN"] = "停止追踪",
        ["zhTW"] = "取消追蹤任務",
    },
    ["Untrack Achievement"] = {
        ["enUS"] = true,
        ["deDE"] = "Erfolg aufheben",
        ["esES"] = "No rastrear logro",
        ["esMX"] = "No rastrear logro",
        ["frFR"] = "Annuler le suivi des réalisations",
        ["koKR"] = "업적 추적 해제",
        ["ptBR"] = "Descompactar conquista",
        ["ruRU"] = "Не отслеживать достижение",
        ["zhCN"] = "取消跟踪成就",
        ["zhTW"] = "取消追蹤成就",
    },
    ["Abandon Quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Suche aufgeben",
        ["esES"] = "Abandonar misión",
        ["esMX"] = "Abandonar misión",
        ["frFR"] = "Abandonner la quête",
        ["koKR"] = "퀘스트 포기",
        ["ptBR"] = "Abandonar Missão",
        ["ruRU"] = "Отменить задание",
        ["zhCN"] = "放弃任务",
        ["zhTW"] = "放棄任務",
    },
    -- This message appears on screen after the player holds CTRL + C
    -- (Keyboard shortcut for Copy) - WoWHead URL StaticPopUp.
    ["Copied URL to clipboard"] = {
        ["enUS"] = true,
        ["deDE"] = "URL in die Zwischenablage kopiert",
        ["esES"] = "URL copiada al portapapeles",
        ["esMX"] = "URL copiada al portapapeles",
        ["frFR"] = "URL copiée dans le presse-papiers",
        ["koKR"] = "클립보드에 URL을 복사하였습니다",
        ["ptBR"] = "URL copiada para a área de transferência",
        ["ruRU"] = "URL скопирован в буфер обмена",
        ["zhCN"] = "已将 URL 复制到剪贴板",
        ["zhTW"] = "複製 URL",
    },
    -- "Lock Tracker" is in the Tracker.lua inside the Translations/Options directory
    ["Unlock Tracker"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker entsperren",
        ["esES"] = "Desbloquear rastreador",
        ["esMX"] = "Desbloquear rastreador",
        ["frFR"] = "Déverrouiller la fenêtre du suivi",
        ["koKR"] = "추적기 잠금해제",
        ["ptBR"] = "Desbloquear rastreador",
        ["ruRU"] = "Разблокировать трекер",
        ["zhCN"] = "解锁框体",
        ["zhTW"] = "解鎖任務清單",
    },
    ---------------------------------------------------------
    -- Misc Translations
    ["Quest Complete!"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest abgeschlossen!",
        ["esES"] = "¡Misión completada!",
        ["esMX"] = "¡Misión completada!",
        ["frFR"] = "Quête terminée !",
        ["koKR"] = "퀘스트 완료!",
        ["ptBR"] = "Missão concluída!",
        ["ruRU"] = "Задание выполнено!",
        ["zhCN"] = "任务完成！",
        ["zhTW"] = "任務完成！",
    },
    ["Quest Failed!"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest fehlgeschlagen!",
        ["esES"] = "¡Misión fracasada!",
        ["esMX"] = "¡Misión fracasada!",
        ["frFR"] = "Quête échouée !",
        ["koKR"] = "퀘스트 실패",
        ["ptBR"] = "Missão falhou!",
        ["ruRU"] = "Задание провалено!",
        ["zhCN"] = "任务失败！",
        ["zhTW"] = "任務失敗！",
    },
    ["Can't open Quest Log while in combat. Open it manually."] = {
        ["enUS"] = true,
        ["deDE"] = "Das Quest Log kann nicht im Kampf geöffnet werden. Bitte öffne es manuell.",
        ["esES"] = "No se puede abrir el registro de misiones durante el combate. Ábrelo manualmente.",
        ["esMX"] = "No se puede abrir el registro de misiones durante el combate. Ábrelo manualmente.",
        ["frFR"] = "Impossible d'ouvrir le journal des quêtes en combat. Ouvrez-le manuellement.",
        ["koKR"] = "전투 중에는 퀘스트 목록을 열 수 없습니다. 수동으로 열어주세요.",
        ["ptBR"] = "Não é possível abrir o registro de missões durante o combate. Abra-o manualmente.",
        ["ruRU"] = "Невозможно автоматически открыть журнал заданий, находясь в бою. Откройте его вручную.",
        ["zhCN"] = "战斗中无法打开任务日志，需要手动打开.",
        ["zhTW"] = "戰鬥中無法打開任務日誌。",
    },
    ["Maximize Quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest maximieren",
        ["esES"] = "Maximizar misión",
        ["esMX"] = "Maximizar misión",
        ["frFR"] = "Maximiser la quête",
        ["koKR"] = "퀘스트 크기 최대화",
        ["ptBR"] = "Maximizar missão",
        ["ruRU"] = "Развернуть задание",
        ["zhCN"] = "最大化任务",
        ["zhTW"] = "最大化任務",
    },
    ["Quests (By %% Complete)"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests (Nach %% Fertigstellung)",
        ["esES"] = "Misiones (Por %% completada)",
        ["esMX"] = "Misiones (Por %% completada)",
        ["frFR"] = "Quêtes (Par %% complet)",
        ["koKR"] = "퀘스트 (%% 완료 기준)",
        ["ptBR"] = "Missões (Por %% completo)",
        ["ruRU"] = "Задания (По %% выполнения)",
        ["zhCN"] = "任务（按完成度 %%）",
        ["zhTW"] = "任務 (依完成度 %%)",
    },
    ["Quests (By %% Complete Reversed)"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests (Nach %% Fertigstellung Absteigend)",
        ["esES"] = "Misiones (Por %% completada invertida)",
        ["esMX"] = "Misiones (Por %% completada invertida)",
        ["frFR"] = "Quêtes (Par %% complet inversé)",
        ["koKR"] = "퀘스트 (%% 완료 기준 역순)",
        ["ptBR"] = "Missões (Por %% completo invertido)",
        ["ruRU"] = "Задания (По %% выполнения убыв.)",
        ["zhCN"] = "任务 (按完成度 %%反向）",
        ["zhTW"] = "任務 (依完成度 %% 反向)",
    },
    ["Quests (By Level)"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests (Nach Level)",
        ["esES"] = "Misiones (Por nivel)",
        ["esMX"] = "Misiones (Por nivel)",
        ["frFR"] = "Quêtes (Par niveau)",
        ["koKR"] = "퀘스트 (레벨 순서)",
        ["ptBR"] = "Missões (Por nivel)",
        ["ruRU"] = "Задания (По уровню)",
        ["zhCN"] = "任务（按等级）",
        ["zhTW"] = "任務 (依等級)",
    },
    ["Quests (By Level Reversed)"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests (Nach Level Absteigend)",
        ["esES"] = "Misiones (Por nivel inverso)",
        ["esMX"] = "Misiones (Por nivel inverso)",
        ["frFR"] = "Quêtes (Par niveau inversé)",
        ["koKR"] = "퀘스트 (레벨 순서 역순)",
        ["ptBR"] = "Missões (Por nível invertido)",
        ["ruRU"] = "Задания (По уровню убыв.)",
        ["zhCN"] = "任务（按等级 反向）",
        ["zhTW"] = "任務 (依等級 反向)",
    },
    ["Quests (By Proximity)"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests (Nach Nähe)",
        ["esES"] = "Misiones (Por proximidad)",
        ["esMX"] = "Misiones (Por proximidad)",
        ["frFR"] = "Quêtes (Par proximité)",
        ["koKR"] = "퀘스트 (가까운)",
        ["ptBR"] = "Missões (Por proximidade)",
        ["ruRU"] = "Задания (По близости)",
        ["zhCN"] = "任务（按远近）",
        ["zhTW"] = "任務 (依遠近)",
    },
    ["Quests (By Proximity Reversed)"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests (Nach Nähe Absteigend)",
        ["esES"] = "Misiones (Por proximidad invertida)",
        ["esMX"] = "Misiones (Por proximidad invertida)",
        ["frFR"] = "Quêtes (Par proximité inversée)",
        ["koKR"] = "퀘스트 (가까운 역순)",
        ["ptBR"] = "Missões (Por proximidade invertida)",
        ["ruRU"] = "Задания (По близости убыв.)",
        ["zhCN"] = "任务（按远近反向）",
        ["zhTW"] = "任務 (依遠近 (反向)",
    },
    ["Blizzard Timer Active!"] = {
        ["enUS"] = true,
        ["deDE"] = "Blizzard Timer aktiv!",
        ["esES"] = "¡Temporizador de Blizzard activo!",
        ["esMX"] = "¡Temporizador de Blizzard activo!",
        ["frFR"] = "Chronomètre de Blizzard actif !",
        ["koKR"] = false,
        ["ptBR"] = "Temporizador de Blizzard ativo!",
        ["ruRU"] = "Таймер Blizzard активен!",
        ["zhCN"] = "暴雪计时器启动！",
        ["zhTW"] = "暴雪計時器啟動！",
    },
}

for k, v in pairs(trackerUILocales) do
    l10n.translations[k] = v
end
