---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local trackerOptionsLocales = {
    ["Tracker"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker",
        ["esES"] = "Rastreador",
        ["esMX"] = "Rastreador",
        ["frFR"] = "Suivi",
        ["koKR"] = "추적기",
        ["ptBR"] = "Rastreador",
        ["ruRU"] = "Трекер",
        ["zhCN"] = "追踪",
        ["zhTW"] = "任務清單",
    },
    ["Tracker Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie-Tracker Einstellungen",
        ["esES"] = "Opciones del rastreador",
        ["esMX"] = "Opciones del rastreador",
        ["frFR"] = "Options du suivi des quêtes",
        ["koKR"] = "퀘스트 추적기 설정",
        ["ptBR"] = "Opções do rastreador para missões",
        ["ruRU"] = "Настройки трекера (окна отслеживания) заданий",
        ["zhCN"] = "任务追踪选项",
        ["zhTW"] = "任務清單選項",
    },
    ---------------------------------------------------------
    ["Auto Track Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Quests automatisch verfolgen",
        ["esES"] = "Rastrear misiones automáticamente",
        ["esMX"] = "Rastrear misiones automáticamente",
        ["frFR"] = "Suivi auto des quêtes",
        ["koKR"] = "자동 추적 퀘스트",
        ["ptBR"] = "Missões de rastreamento automático",
        ["ruRU"] = "Автоотслеживание",
        ["zhCN"] = "自动追踪任务",
        ["zhTW"] = "自動追蹤所有任務",
    },
    ["This is the same as \"Enable Automatic Quest Tracking\" in the Blizzard Interface Options. When enabled, the Questie Tracker will automatically track all Quests in your Quest Log. Disabling this option will untrack all Quests. You will have to manually select which Quests to track.\n\nNOTE: \"Show Complete Quests\" is disabled while this option is not being used."] = {
        ["enUS"] = true,
        ["deDE"] = "Dies ist dasselbe wie \"Automatische Questverfolgung aktivieren\" in den Schnittstellenoptionen. Wenn aktiviert, verfolgt der Questie-Tracker automatisch alle Quests im Questlog. Dies verhindert die manuelle Verfolgung durch \"Umschalten + Linksklick\".",
        ["esES"] = "Esto es lo mismo que \"Activar el seguimiento automático de misiones\" en las opciones de la interfaz. Si está activado, el rastreador rastreará automáticamente todas las misiones en tu registro. Esto evita el seguimiento manual de clic de cambio.",
        ["esMX"] = "Esto es lo mismo que \"Activar el seguimiento automático de misiones\" en las opciones de la interfaz. Si está activado, el rastreador rastreará automáticamente todas las misiones en tu registro. Esto evita el seguimiento manual de clic de cambio.",
        ["frFR"] = "Cela revient à utiliser \"Activer le suivi automatique des quêtes\" dans les options d'interface. Le suivi des quêtes suivra alors automatiquement toutes les quêtes de votre journal et cela empêchera le suivi manuel Maj-clic.",
        ["koKR"] = "인터페이스 옵션의 \"자동 퀘스트 추적 사용 \"과 동일합니다. 활성화하면 Questie Tracker가 로그의 모든 퀘스트를 자동으로 추적합니다. 이렇게하면 Shift- 클릭 수동 추적이 방지됩니다.",
        ["ptBR"] = "É o mesmo que \"Ativar rastreamento automático de missões\" nas opções da interface. Se ativado, o Questie Rastreador rastreia automaticamente todas as missões em seu registro. Isso evita o rastreamento manual com a tecla Shift pressionada.",
        ["ruRU"] = "Когда включено, трекер будет автоматически отслеживать все задания в вашем журнале (это то же самое, что и \"Отслеживание заданий\" в настройках интерфейса игры). Отключение данной настройки приведет к отмене отслеживания всех заданий в вашем журнале, вам придется вручную выбрать задания для отслеживания.\n\nПРИМЕЧАНИЕ: Настройка \"Выполненные задания\" будет отключена при отключении данной настройки",
        ["zhCN"] = "这与界面选项中的“启用自动任务跟踪”相同。 启用后，Questie 追踪将自动追踪日志中的所有任务。 关闭此选项可以取消所有追踪的任务，需要手动选择。\n\n注意：停用本选项也会停用“显示已完成的任务”",
        ["zhTW"] = "和遊戲內建的選項 \"啟用自動追蹤任務\" 相同。啟用時，Questie 任務清單將會自動追蹤任務日誌中的所有任務。停用此選項將會取消追蹤所有任務，必須手動選擇要追蹤的任務。\n\n注意: 停用此選項時也會停用 \"顯示已完成的任務\"。",
    },
    ---------------------------------------------------------
    ["Show Completed Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossene Quests anzeigen",
        ["esES"] = "Mostrar misiones completadas",
        ["esMX"] = "Mostrar misiones completadas",
        ["frFR"] = "Afficher les quêtes terminées",
        ["koKR"] = "완료된 퀘스트 표시",
        ["ptBR"] = "Mostrar missões concluídas",
        ["ruRU"] = "Выполненные задания",
        ["zhCN"] = "显示已完成的任务",
        ["zhTW"] = "顯示已完成的任務",
    },
    ["When this is checked, completed Quests will show in the Questie Tracker.\n\nNOTE: This setting only works when \"Auto Track Quests\" is enabled."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden abgeschlossene Quests im Questie-Tracker angezeigt.\n\nHINWEIS: Diese Einstellung funktioniert nur, wenn \"Quests automatisch verfolgen\" aktiviert ist.",
        ["esES"] = "Si está activado, las misiones completadas se mostrarán en el rastreador.\n\nNOTA: Esta configuración solo funciona cuando el \"Rastrear misiones automáticamente\" está activado.",
        ["esMX"] = "Si está activado, las misiones completadas se mostrarán en el rastreador.\n\nNOTA: Esta configuración solo funciona cuando el \"Rastrear misiones automáticamente\" está activado.",
        ["frFR"] = "Si cette option est activée, les quêtes terminées s'afficheront dans le suivi de quêtes de Questie.\n\nREMARQUE : Ce paramètre ne fonctionne que lorsque l'option \"Suivi automatique des quêtes\" est activée.",
        ["koKR"] = "이 옵션을 선택하면 완료된 퀘스트가 Questie 추적기에 표시됩니다.\n\n참고: 이 설정은 \"자동 퀘스트 추적\"이 활성화된 경우에만 작동합니다.",
        ["ptBR"] = "Se ativado, as missões concluída serão exibidas no rastreador de missões de Questie.\n\nNOTA: Esta configuração só funciona quando \"Rastrear missões automaticamente\" está ativado.",
        ["ruRU"] = "Показать/скрыть выполненные задания в трекере.\n\nПРИМЕЧАНИЕ: Эта настройка работает только при включенной настройке \"Автоотслеживание\"",
        ["zhCN"] = "启用时，任务列表中会显示已完成的任务\n\n注意: 必须先启用 \"自动追踪所有任务\"，此设置才有用。",
        ["zhTW"] = "啟用時，任務清單中會顯示已完成的任務。\n\n注意: 必須先啟用 \"自動追蹤所有任務\"，此設定才有效果。",
    },
    ---------------------------------------------------------
    ["Show Quest Level"] = {
        ["enUS"] = true,
        ["deDE"] = "Questlevel anzeigen",
        ["esES"] = "Mostrar nivel de misión",
        ["esMX"] = "Mostrar nivel de misión",
        ["frFR"] = "Afficher le niveau des quêtes",
        ["koKR"] = "퀘스트 레벨 표시",
        ["ptBR"] = "Mostrar nível da missão",
        ["ruRU"] = "Уровень заданий",
        ["zhCN"] = "显示任务等级",
        ["zhTW"] = "顯示任務等級",
    },
    ["When this is checked, the Quest Level Tags for Quest Titles will show in the Questie Tracker."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Quest-Level-Tags für Quest-Titel im Questie-Tracker angezeigt.",
        ["esES"] = "Si está activado, el nivel de la misión se mostrará en el rastreador.",
        ["esMX"] = "Si está activado, el nivel de la misión se mostrará en el rastreador.",
        ["frFR"] = "Si cette option est activée, le niveau de la quête sera affiché dans le suivi.",
        ["koKR"] = "이 옵션을 선택하면 퀘스트 제목에 대한 퀘스트 레벨 태그가 Questie 트래커에 표시됩니다.",
        ["ptBR"] = "Se ativado, o nível da missão será mostrado no rastreador.",
        ["ruRU"] = "Показать/скрыть уровень заданий слева от их названий",
        ["zhCN"] = "选中后，任务标题的任务等级将显示在Questie追踪窗口",
        ["zhTW"] = "啟用時，任務清單中的任務標題將會顯示任務等級。",
    },
    ---------------------------------------------------------
    ["Auto Minimize Completed Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossene Quests automatisch minimieren",
        ["esES"] = "Minimizar misiones completadas",
        ["esMX"] = "Minimizar misiones completadas",
        ["frFR"] = "Réduire les quêtes terminées",
        ["koKR"] = "완료된 퀘스트 자동 최소화",
        ["ptBR"] = "Minimizar missões concluídas",
        ["ruRU"] = "Свернуть выполненные",
        ["zhCN"] = "自动收起已完成的任务",
        ["zhTW"] = "自動最小化已完成的任務",
    },
    ["When this is checked, completed Quests will automatically minimize."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn dies aktiviert ist, werden abgeschlossene Quests automatisch minimiert.",
        ["esES"] = "Si está activado, las misiones completadas se minimizarán automáticamente.",
        ["esMX"] = "Si está activado, las misiones completadas se minimizarán automáticamente.",
        ["frFR"] = "Si cette option est activée, les quêtes terminées seront automatiquement réduites.",
        ["koKR"] = "이 옵션을 선택하면 완료된 퀘스트가 자동으로 최소화됩니다.",
        ["ptBR"] = "Se ativado, as missões concluídas serão automaticamente minimizadas.",
        ["ruRU"] = "Когда включено, задания будут автоматически сворачиваться после их выполнения",
        ["zhCN"] = "选中后，已完成的任务将自动收起",
        ["zhTW"] = "啟用時，已完成的任務會自動收合起來。",
    },
    ---------------------------------------------------------
    ["Hide Completed Quest Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossene Quest-Ziele ausblenden",
        ["esES"] = "Ocultar objetivos completados",
        ["esMX"] = "Ocultar objetivos completados",
        ["frFR"] = "Cacher les objectifs terminés",
        ["koKR"] = "완료된 퀘스트 목표 숨기기",
        ["ptBR"] = "Ocultar objetivos concluídos",
        ["ruRU"] = "Скрыть выполн. цели заданий",
        ["zhCN"] = "隐藏已完成的任务目标",
        ["zhTW"] = "隱藏已完成的任務目標",
    },
    ["When this is checked, completed Quest Objectives will automatically be removed from the Questie Tracker."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden abgeschlossene Quest-Ziele automatisch aus dem Questie-Tracker entfernt.",
        ["esES"] = "Si está activado, los objetivos de misiones completados se eliminarán automáticamente del rastreador.",
        ["esMX"] = "Si está activado, los objetivos de misiones completados se eliminarán automáticamente del rastreador.",
        ["frFR"] = "Si cette option est activée, les objectifs des quêtes terminées seront automatiquement supprimés du suivi.",
        ["koKR"] = "이 옵션을 선택하면 완료된 퀘스트 목표가 자동으로 Questie 추적기에서 제거됩니다.",
        ["ptBR"] = "Se ativado, os objetivos de missões concluídos serão automaticamente removidos do rastreador.",
        ["ruRU"] = "Когда включено, выполненные цели заданий будут автоматически изъяты из трекера",
        ["zhCN"] = "当勾选此项时，已完成的任务目标将自动从 Questie 追踪器中移除。",
        ["zhTW"] = "當勾選此項時，已完成的任務目標將自動從 Questie 追蹤器中移除。",
    },
    ---------------------------------------------------------
    ["Hide Blizzard Completion Text"] = {
        ["enUS"] = true,
        ["deDE"] = "Blizzards Quest-Abgeschlossen-Text ausblenden",
        ["esES"] = "Ocultar texto de completación",
        ["esMX"] = "Ocultar texto de completación",
        ["frFR"] = "Cacher le texte de terminaison",
        ["koKR"] = "블리자드 완료 텍스트 숨기기",
        ["ptBR"] = "Ocultar texto de conclusão",
        ["ruRU"] = "Скрыть текст Blizzard",
        ["zhCN"] = "隐藏内建的完成信息",
        ["zhTW"] = "隱藏內建的完成訊息",
    },
    ["When this is checked, Blizzard Completion Text will be hidden for completed Quests and instead show the old Questie tags: \"Quest Complete!\" or \"Quest Failed!\""] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Blizzard Quest-Abgeschlossen-Text für abgeschlossene Quests ausgeblendet und stattdessen die alten Questie-Tags angezeigt: 'Quest abgeschlossen!' oder 'Quest fehlgeschlagen!'",
        ["esES"] = "Si está activado, el texto de completación de Blizzard se ocultará para las misiones completadas y en su lugar mostrará las etiquetas de Questie antiguas: \"¡Misión completada!\" o \"¡Misión fracasada!\"",
        ["esMX"] = "Si está activado, el texto de completación de Blizzard se ocultará para las misiones completadas y en su lugar mostrará las etiquetas de Questie antiguas: \"¡Misión completada!\" o \"¡Misión fracasada!\"",
        ["frFR"] = "Si cette option est activée, le texte de terminaison de Blizzard sera caché pour les quêtes terminées et à la place, les anciennes balises Questie seront affichées : \"Quête terminée !\" ou \"Quête échouée !'\"",
        ["koKR"] = "이 옵션을 선택하면 완료된 퀘스트에 대한 블리자드 완료 텍스트가 숨겨지고 이전 Questie 태그인 \"퀘스트 완료!\" 또는 \"퀘스트 실패!\"가 표시됩니다.",
        ["ptBR"] = "Se ativado, o texto de conclusão de Blizzard será ocultado para as missões concluídas e, em vez disso, mostrará as antigas etiquetas de Questie: \"Missão concluída!\" ou \"Missão falhou!\"",
        ["ruRU"] = "Когда включено, Blizzard-ский текст об окончании задания будет скрыт, а вместо него будет отображен текст Questie: 'Задание выполнено!' или 'Задание провалено!'",
        ["zhCN"] = "启用时，完成任务时不会显示游戏内建的完成信息，而会显示传统的信息：\"任务完成！\" 和 \"任务失败！\"",
        ["zhTW"] = "啟用時，完成任務時不會顯示遊戲內建的完成訊息，而會顯示傳統的訊息: \"任務完成！\" or \"任務失敗！\"",
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only
    ["Hide Completed Achieve Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Abgeschlossene Erfolgsziele ausblenden",
        ["esES"] = "Ocultar objetivos de logros completados",
        ["esMX"] = "Ocultar objetivos de logros completados",
        ["frFR"] = "Cacher les objectifs des hauts faits terminées",
        ["koKR"] = "완료된 업적 목표 숨기기",
        ["ptBR"] = "Ocultar objetivos de conquistas concluídos",
        ["ruRU"] = "Скрыть выполн. цели достижений",
        ["zhCN"] = "隐藏已完成的成就目标",
        ["zhTW"] = "隱藏已完成的成就目標",
    },
    ["When this is checked, completed Achievement Objectives will automatically be removed from the Questie Tracker."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden abgeschlossene Erfolgsziele automatisch aus dem Questie-Tracker entfernt.",
        ["esES"] = "Si está activado, los objetivos de logro completados serán eliminados automáticamente del rastreador de Questie.",
        ["esMX"] = "Si está activado, los objetivos de logro completados serán eliminados automáticamente del rastreador de Questie.",
        ["frFR"] = "Si cette option est activée, les objectifs des hauts faits terminées seront automatiquement supprimés du suivi de quêtes de Questie.",
        ["koKR"] = "이 옵션을 선택하면 완료된 업적 목표가 자동으로 Questie 추적기에서 제거됩니다.",
        ["ptBR"] = "Se ativado, os objetivos de conquistas concluídos serão automaticamente removidos do rastreador de missões de Questie.",
        ["ruRU"] = "Когда включено, выполненные цели достижений будут автоматически изъяты из трекера",
        ["zhCN"] = "当勾选此项时，已完成的成就目标将自动从 Questie 追踪器中移除。",
        ["zhTW"] = "當勾選此項時，已完成的成就目標將自動從 Questie 追蹤器中移除。",
    },
    ---------------------------------------------------------
    ["Show Blizzard Timer"] = {
        ["enUS"] = true,
        ["deDE"] = "Blizzard Timer anzeigen",
        ["esES"] = "Mostrar temporizador de Blizzard",
        ["esMX"] = "Mostrar temporizador de Blizzard",
        ["frFR"] = "Chronomètre par défaut",
        ["koKR"] = "블리자드 타이머 표시",
        ["ptBR"] = "Mostrar temporizador de Blizzard",
        ["ruRU"] = "Таймер Blizzard",
        ["zhCN"] = "显示暴雪计时器",
        ["zhTW"] = "顯示內建任務計時器",
    },
    ["When this is checked, the default Blizzard Timer Frame for Quests will be shown instead of being embedded inside the Questie Tracker."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Standard-Blizzard-Timer-Frame für Quests angezeigt, anstatt in den Tracker eingebettet zu sein.",
        ["esES"] = "Si está activado, se mostrará el marco del temporizador de Blizzard para las misiones en lugar de estar incorporado dentro del rastreador.",
        ["esMX"] = "Si está activado, se mostrará el marco del temporizador de Blizzard para las misiones en lugar de estar incorporado dentro del rastreador.",
        ["frFR"] = "Active l'affichage du chronomètre de l'interface de base pour les quêtes au lieu d'indiquer le temps restant directement dans le suivi des quêtes.",
        ["koKR"] = "이 옵션을 선택하면 추적기에 내장 된 대신 퀘스트에 대한 기본 블리자드 타이머 프레임이 표시됩니다.",
        ["ptBR"] = "Se ativado, o quadro do temporizador de Blizzard para missões será mostrado em vez de incorporado no rastreador.",
        ["ruRU"] = "Когда включено, будет отображаться стандартный таймер Blizzard вместо встраивания его в трекер",
        ["zhCN"] = "启用后，任务计时器将会显示",
        ["zhTW"] = "啟用時，會顯示遊戲內建的任務計時器框架，而不會內嵌在任務清單裡面。",
    },
    ---------------------------------------------------------
    ["Enable Tracker Header"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker-Kopfzeile aktivieren",
        ["esES"] = "Activar encabezado del rastreador",
        ["esMX"] = "Activar encabezado del rastreador",
        ["frFR"] = "Activer l'en-tête du suivi",
        ["koKR"] = "추적기 헤더 활성화",
        ["ptBR"] = "Ativar cabeçalho do rastreador",
        ["ruRU"] = "Вкл/выкл",
        ["zhCN"] = "开启任务清单标题",
        ["zhTW"] = "啟用任務清單標題列",
    },
    ["When this is enabled the Tracker Header with the number of active quests and the Questie Icon will be permanently visible.\n\nWhen this is disabled the Questie Icon will fade in while your mouse is over the Tracker."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn dies aktiviert ist sind die Tracker-Kopfzeile und das Questie Icon permanent sichtbar.\n\nWenn dies deaktiviert ist blendet sich das Questie Icon ein sobald die Maus über dem Tracker ist.",
        ["esES"] = "Si está activado, el encabezado del rastreador con el número de misiones activas y el icono de Questie estarán permanentemente visibles.\n\nSi está desactivado, el icono de Questie desaparecerá mientras el ratón esté sobre el rastreador.",
        ["esMX"] = "Si está activado, el encabezado del rastreador con el número de misiones activas y el icono de Questie estarán permanentemente visibles.\n\nSi está desactivado, el icono de Questie desaparecerá mientras el ratón esté sobre el rastreador.",
        ["frFR"] = "Si cette option est activée, l'en-tête du suivi avec le nombre de quêtes actives et l'icône de Questie restera visible en permanence.\n\nSi cette option est désactivée, l'icône de Questie s'estompera lorsque votre souris survolera le suivi.",
        ["koKR"] = "이 옵션을 활성화하면 활성화된 퀘스트 수와 Questie 아이콘이 추적기 헤더에 지속적으로 표시됩니다.\n\n이 옵션을 비활성화하면 마우스가 추적기 위에 있을 때만 Questie 아이콘이 나타납니다.",
        ["ptBR"] = "Se ativado, o cabeçalho do rastreador com o número de missões ativas e o ícone de Questie ficará permanentemente visível.\n\nSe desativado, o ícone de Questie desaparecerá enquanto o cursor do mouse estiver sobre o rastreador.",
        ["ruRU"] = "Когда включено, заголовок трекера с числом активных заданий и значком Questie будет всегда виден.\n\nКогда выключено, значок Questie будет появляться при наведении мышью на трекер",
        ["zhCN"] = "开启后，会一直显示任务数量和 Questie 图标。 \n\n停用时，指标指向清单时才会显示 Questie 图标。",
        ["zhTW"] = "啟用時，會一直顯示任務數量和 Questie 圖示。\n\n停用時，滑鼠指向清單時才會顯示 Questie 圖示。",
    },
    ---------------------------------------------------------
    ["Show Tracker Header At The Bottom"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker-Kopfzeile unten anzeigen",
        ["esES"] = "Mostrar encabezado del rastreador en la parte inferior",
        ["esMX"] = "Mostrar en la parte inferior",
        ["frFR"] = "Afficher l'en-tête du suivi en bas",
        ["koKR"] = "추적기 헤더 하단 표시",
        ["ptBR"] = "Mostrar na parte inferior",
        ["ruRU"] = "Заголовок трекера внизу",
        ["zhCN"] = "标题在下方",
        ["zhTW"] = "標題列在下方",
    },
    ["When this is enabled the Tracker Header and/or the Questie Icon will be moved to the bottom of the Questie Tracker and the sizer to the top."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn dies aktiviert ist wird die Tracker-Kopfzeile und/oder das Questie-Icon an den unteren und der Sizer an den oberen Rand des Questie-Tracker verschoben",
        ["esES"] = "Si está activado, el encabezado del rastreador y/o el icono de Questie se moverán a la parte inferior del rastreador y el medidor a la parte superior.",
        ["esMX"] = "Si está activado, el encabezado del rastreador y/o el icono de Questie se moverán a la parte inferior del rastreador y el medidor a la parte superior.",
        ["frFR"] = "Si cette option est activée, l'en-tête du suivi et/ou l'icône de Questie seront déplacés en bas du suivi de quêtes et le calibreur en haut.",
        ["koKR"] = "이 옵션을 활성화하면 추적기 헤더와 Questie 아이콘이 Questie 추적기 하단으로 이동하고 크기 조정기가 상단으로 이동합니다.",
        ["ptBR"] = "Se ativado, o cabeçalho do rastreador e/ou o ícone de Questie serão movidos para a parte inferior do rastreador de Questie e o medidor para o topo.",
        ["ruRU"] = "Когда включено, заголовок трекера и/или значок Questie будут перемещены в низ трекера, а сайзер будет перемещен наверх",
        ["zhCN"] = "启用后，任务清单标题列和/或 Questie 图标会移动到清单的最下方，缩放大小的拖曳点会在最上方。",
        ["zhTW"] = "啟用時，任務清單標題列和 Questie 圖示會移動到清單的最下方，縮放大小的拖曳點會在最上方。",
    },
    ---------------------------------------------------------
    ["Sticky Durability Frame"] = {
        ["enUS"] = true,
        ["deDE"] = "Starre Haltbarkeitsanzeige",
        ["esES"] = "Marco de durabilidad fijo",
        ["esMX"] = "Marco de durabilidad fijo",
        ["frFR"] = "Ajust auto durabilité",
        ["koKR"] = "달라붙는 프레임",
        ["ptBR"] = "Quadro de durabilidade aderente",
        ["ruRU"] = "Индикатор прочности",
        ["zhCN"] = "锁定任务道具",
        ["zhTW"] = "耐久度貼齊清單",
    },
    ["When this is checked, the durability frame will be placed on the left or right side of the Questie Tracker depending on where the Tracker is placed on your screen."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, wird die Haltbarkeitsanzeige auf der linken oder rechten Seite des Trackers platziert, je nachdem, wo sich der Tracker auf dem Bildschirm befindet.",
        ["esES"] = "Si está activado, el marco de durabilidad se colocará en el lado izquierdo o derecho del rastreador, dependiendo de dónde esté ubicado el rastreador en su pantalla.",
        ["esMX"] = "Si está activado, el marco de durabilidad se colocará en el lado izquierdo o derecho del rastreador, dependiendo de dónde esté ubicado el rastreador en su pantalla.",
        ["frFR"] = "Active le placement automatique du cadre de durabilité sur le côté gauche ou droit de la fenêtre de suivi selon l'endroit où celle-ci se trouve sur l'écran.",
        ["koKR"] = "이 옵션을 선택하면 화면에서 트래커의 위치에 따라 내구성 프레임이 트래커의 왼쪽 또는 오른쪽에 배치됩니다.",
        ["ptBR"] = "Se ativado, o quadro de durabilidade será colocado no lado esquerdo ou direito do Rastreador, dependendo de onde o Rastreador estiver colocado na tela.",
        ["ruRU"] = "Когда включено, индикатор прочности снаряжения будет расположен с левой или правой стороны трекера (в зависимости от положения трекера на экране)",
        ["zhCN"] = "选中此选项时，道具框架将根据追踪器在屏幕上的放置位置放置在追踪器的左侧或右侧。",
        ["zhTW"] = "啟用時，裝備耐久度框架會放在任務清單的左側或右側，依據任務清單在畫面上的位置而定。",
    },
    ---------------------------------------------------------
    ["Minimize In Combat"] = {
        ["enUS"] = true,
        ["deDE"] = "Im Kampf minimieren",
        ["esES"] = "Minimizar en combate",
        ["esMX"] = "Minimizar en combate",
        ["frFR"] = "Réduire en combat",
        ["koKR"] = "전투 최소화",
        ["ptBR"] = "Minimizar em combate",
        ["ruRU"] = "Свернуть в бою",
        ["zhCN"] = "在战斗中最小化",
        ["zhTW"] = "戰鬥中最小化",
    },
    ["When this is checked, the Questie Tracker will automatically be minimized while entering combat."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn dies aktiviert ist, wird der Tracker beim Eintritt in den Kampf automatisch minimiert.",
        ["esES"] = "Si está activado, el rastreador se minimizará automáticamente al entrar en combate.",
        ["esMX"] = "Si está activado, el rastreador se minimizará automáticamente al entrar en combate.",
        ["frFR"] = "Active la réduction automatique du suivi de quête lors des combats.",
        ["koKR"] = "이 옵션을 선택하면 전투에 들어가는 동안 트래커가 자동으로 최소화됩니다.",
        ["ptBR"] = "Se ativado, o Rastreador será automaticamente minimizado ao entrar em combate.",
        ["ruRU"] = "Когда включено, при входе в бой трекер будет автоматически свернут",
        ["zhCN"] = "选中后，在进入战斗状态时，追踪器将自动最小化。",
        ["zhTW"] = "啟用時，進入戰鬥後會自動將任務清單最小化。",
    },
    ---------------------------------------------------------
    ["Minimize In Dungeons"] = {
        ["enUS"] = true,
        ["deDE"] = "In Instanzen minimieren",
        ["esES"] = "Minimizar en mazmorras",
        ["esMX"] = "Minimizar en calabozos",
        ["frFR"] = "Réduire dans les donjons",
        ["koKR"] = "던전 내 최소화",
        ["ptBR"] = "Minimizar em masmorras",
        ["ruRU"] = "Свернуть в подземельях",
        ["zhCN"] = "地下城时最小化",
        ["zhTW"] = "地城中最小化",
    },
    ["When this is checked, the Questie Tracker will automatically be minimized when entering a dungeon."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn dies aktiviert ist, wird der Tracker beim Betreten eines Dungeons automatisch minimiert.",
        ["esES"] = "Si está activado, el rastreador se minimizará automáticamente al entrar a una mazmorra.",
        ["esMX"] = "Si está activado, el rastreador se minimizará automáticamente al entrar a un calabozo.",
        ["frFR"] = "La fenêtre du suivi sera automatiquement réduite lors de l'entrée dans un donjon.",
        ["koKR"] = "이 옵션을 선택하면 던전으로 들어갈 때 Questie 추적기가 자동으로 최소화됩니다.",
        ["ptBR"] = "Se ativado, o rastreador será minimizado automaticamente ao entrar em uma masmorra.",
        ["ruRU"] = "Когда включено, при входе в подземелье трекер будет автоматически свернут",
        ["zhCN"] = "选中此项后，进入地下城时跟踪器将自动最小化。",
        ["zhTW"] = "啟用時，進入地城後會自動將任務清單最小化。",
    },
    ---------------------------------------------------------
    ["Fade Min/Max Buttons"] = {
        ["enUS"] = true,
        ["deDE"] = "Min/Max ausblenden",
        ["esES"] = "Desvanecer botones min/máx",
        ["esMX"] = "Desvanecer botones min/máx",
        ["frFR"] = "Fondu des boutons min/max",
        ["koKR"] = "페이드 최소 / 최대 BTN",
        ["ptBR"] = "Desvanecer botões min/max",
        ["ruRU"] = "Скрыть '+' и '–'",
        ["zhCN"] = "淡化按钮",
        ["zhTW"] = "淡出最大化/最小化按鈕",
    },
    ["When this is checked, the Minimize and Maximize Buttons will fade and become transparent when not in use."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Schaltflächen zum Minimieren und Maximieren von Quests ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["esES"] = "Si está activado, los botones minimizar y maximizar se desvanecerán y se volverán transparentes cuando no estén en uso.",
        ["esMX"] = "Si está activado, los botones minimizar y maximizar se desvanecerán y se volverán transparentes cuando no estén en uso.",
        ["frFR"] = "Active le fondu des boutons min. et max. ce qui les rend transparents en dehors du survol de la souris.",
        ["koKR"] = "이 옵션을 선택하면 사용하지 않을 때 최소화 및 최대화 버튼이 사라지고 투명 해집니다.",
        ["ptBR"] = "Se ativado, os botões minimizar e maximizar desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, кнопки сворачивания и разворачивания заданий исчезают и становятся прозрачными при неиспользовании",
        ["zhCN"] = "选中时，自动淡化按钮",
        ["zhTW"] = "啟用時，滑鼠沒有指向最大化和最小化按鈕時會變成透明。",
    },
    ---------------------------------------------------------
    ["Fade Quest Item Buttons"] = {
        ["enUS"] = true,
        ["deDE"] = "Questgegenstände ausblenden",
        ["esES"] = "Desvanecer botones de objetos de misiones",
        ["esMX"] = "Desvanecer botones de objetos de misiones",
        ["frFR"] = "Fondu des objets de quête",
        ["koKR"] = "페이드 퀘스트 아이템 BTN",
        ["ptBR"] = "Desvanecer botões do item de missão",
        ["ruRU"] = "Скрыть предметы заданий",
        ["zhCN"] = "淡化任务物品按钮",
        ["zhTW"] = "淡出任務物品按鈕",
    },
    ["When this is checked, the Quest Item Buttons will fade and become transparent when not in use."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Schaltflächen für die Questgegenstände ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["esES"] = "Si está activado, los botones de objetos de misión se desvanecerán y se volverán transparentes cuando no estén en uso.",
        ["esMX"] = "Si está activado, los botones de objetos de misión se desvanecerán y se volverán transparentes cuando no estén en uso.",
        ["frFR"] = "Active le fondu des boutons d'objet de quête ce qui les rend transparents en dehors du survol de la souris.",
        ["koKR"] = "이 항목을 체크하면 퀘스트 아이템 버튼이 사라지고 사용하지 않을 때 투명 해집니다.",
        ["ptBR"] = "Se ativado, os botões de itens de missão desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, кнопки предметов заданий исчезают и становятся прозрачными при неиспользовании",
        ["zhCN"] = "当勾选此选项时，任务物品按钮在未使用时会淡化并变得透明。",
        ["zhTW"] = "當勾選此選項時，任務物品按鈕在未使用時會淡化並變得透明。",
    },
    ---------------------------------------------------------
    ["Enable Background"] = {
        ["enUS"] = true,
        ["deDE"] = "Hintergrund anzeigen",
        ["esES"] = "Activar fondo",
        ["esMX"] = "Activar fondo",
        ["frFR"] = "Activer l'arrière-plan",
        ["koKR"] = "배경 사용",
        ["ptBR"] = "Ativar plano de fundo",
        ["ruRU"] = "Фон трекера",
        ["zhCN"] = "启用背景",
        ["zhTW"] = "顯示背景",
    },
    ["When this is checked, the Questie Tracker Background becomes visible."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Questie-Tracker-Hintergrund angezeigt.",
        ["esES"] = "Si está activado, el fondo del rastreador se vuelve visible.",
        ["esMX"] = "Si está activado, el fondo del rastreador se vuelve visible.",
        ["frFR"] = "Active l'arrière-plan du suivi des quêtes Questie.",
        ["koKR"] = "이 옵션을 선택하면 Questie 추적기 배경이 나타납니다.",
        ["ptBR"] = "Se ativado, o fundo do rastreador de missões fica visível.",
        ["ruRU"] = "Показать/скрыть фон трекера",
        ["zhCN"] = "选中后，将显示追踪器背景。",
        ["zhTW"] = "啟用時，任務清單會顯示背景顏色。",
    },
    ---------------------------------------------------------
    ["Enable Border"] = {
        ["enUS"] = true,
        ["deDE"] = "Rahmen anzeigen",
        ["esES"] = "Activar borde",
        ["esMX"] = "Activar borde",
        ["frFR"] = "Activer la bordure",
        ["koKR"] = "테두리 활성화",
        ["ptBR"] = "Ativar borda",
        ["ruRU"] = "Граница фона",
        ["zhCN"] = "启用边框",
        ["zhTW"] = "顯示邊框",
    },
    ["When this is checked, the Questie Tracker Border becomes visible."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn dies aktiviert ist, wird der Rand des Questie-Trackers sichtbar.",
        ["esES"] = "Si está activado, el borde del rastreador se vuelve visible.",
        ["esMX"] = "Si está activado, el borde del rastreador se vuelve visible.",
        ["frFR"] = "Active la bordure du suivi des quêtes Questie.",
        ["koKR"] = "이 옵션을 선택하면 Questie 트래커 테두리가 나타납니다.",
        ["ptBR"] = "Se ativado, a borda do rastreador de missões fica visível.",
        ["ruRU"] = "Показать/скрыть границу фона трекера",
        ["zhCN"] = "选中后，将显示边框。",
        ["zhTW"] = "啟用時，任務清單會顯示邊框。",
    },
    ---------------------------------------------------------
    ["Fade Background"] = {
        ["enUS"] = true,
        ["deDE"] = "Hintergrund verblassen",
        ["esES"] = "Desvanecer fondo",
        ["esMX"] = "Desvanecer fondo",
        ["frFR"] = "Fondu de l'arrière-plan",
        ["koKR"] = "페이드 배경",
        ["ptBR"] = "Desvanecer fundo",
        ["ruRU"] = "Скрыть фон и границу",
        ["zhCN"] = "淡化背景",
        ["zhTW"] = "淡出背景",
    },
    ["When this is checked, the Questie Tracker Backdrop and Border (if enabled) will fade and become transparent when not in use."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden der Hintergrund des Questie-Trackers und der Rahmen (falls aktiviert) ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["esES"] = "Si está activado, el fondo y el borde del rastreador (si está activado) se desvanecerán y se volverán transparentes cuando no estén en uso.",
        ["esMX"] = "Si está activado, el fondo y el borde del rastreador (si está activado) se desvanecerán y se volverán transparentes cuando no estén en uso.",
        ["frFR"] = "Active le fondu de l'arrière-plan du suivi des quêtes Questie lorsque celui-ci est activé.",
        ["koKR"] = "이 옵션을 선택하면 Questie 트래커 배경 및 테두리 (사용 가능한 경우)가 사라지고 사용하지 않을 때 투명 해집니다.",
        ["ptBR"] = "Se ativado, o Pano de fundo e a borda de Questie Rastreador (se ativado) desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, фон и граница трекера исчезают и становятся прозрачными при неиспользовании",
        ["zhCN"] = "选中后，自动淡化背景及边框",
        ["zhTW"] = "啟用時，滑鼠沒有指向任務清單時，背景和 (如果有啟用) 邊框會變成透明。",
    },
    ---------------------------------------------------------
    ["Hide Tracker Sizer"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker-Sizer ausblenden",
        ["esES"] = "Ocultar medidor del rastreador",
        ["esMX"] = "Ocultar medidor del rastreador",
        ["frFR"] = "Cacher le calibreur du suivi",
        ["koKR"] = "추적기 크기 조정기 숨기기",
        ["ptBR"] = "Ocultar medidor do rastreador",
        ["ruRU"] = "Скрыть сайзер трекера",
        ["zhCN"] = "隐藏列表大小调整点",
        ["zhTW"] = "隱藏清單大小調整點",
    },
    ["When this is checked, the Questie Tracker Sizer that appears in the bottom or top right hand corner will be hidden."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Tracker-Sizer, der in der unteren oder oberen rechten Ecke angezeigt wird, ausgeblendet.",
        ["esES"] = "Si está activado, el medidor del rastreador que aparece en la esquina inferior o superior derecha estará oculto.",
        ["esMX"] = "Si está activado, el medidor del rastreador que aparece en la esquina inferior o superior derecha estará oculto.",
        ["frFR"] = "Si cette option est activée, le calibreur du suivi de quêtes qui apparaît dans le coin inférieur ou supérieur droit sera caché.",
        ["koKR"] = "이 옵션을 선택하면 오른쪽 하단 또는 상단에 나타나는 Questie 추적기 크기 조정기가 숨겨집니다.",
        ["ptBR"] = "Se ativado, o redimensionador do rastreador que aparece no canto inferior ou superior direito será ocultado.",
        ["ruRU"] = "Когда включено, скрывается сайзер (изменитель размера трекера), который отображается в правом нижнем или в правом верхнем углу",
        ["zhCN"] = "启用时，任务列表下方或右上角调整点不会显示。",
        ["zhTW"] = "啟用時，任務清單下方或右上角調整點不會顯示出來。",
    },
    ---------------------------------------------------------
    ["Show Header For Empty Tracker"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker-Kopfzeile für leeren Tracker anzeigen",
        ["esES"] = "Mostrar encabezado para el rastreador vacío",
        ["esMX"] = "Mostrar encabezado para el rastreador vacío",
        ["frFR"] = "Afficher l'en-tête pour le suivi vide",
        ["koKR"] = "빈 추적기 헤더 표시",
        ["ptBR"] = "Mostrar cabeçalho para o rastreador vazio",
        ["ruRU"] = "Отображать при пустом трекере",
        ["zhCN"] = "为空清单显示标题",
        ["zhTW"] = "空的清單也要顯示標題列",
    },
    ["When this is enabled the Tracker Header will be visible even when no quests are being tracked versus the Tracker being hidden completely."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn dies aktiviert ist wird die Tracker-Kopfzeile angezeigt, selbst wenn keine Quests verfolgt werden anstatt, dass der Tracker komplett ausgeblendet wird.",
        ["esES"] = "Si está activado, el encabezado del rastreador será visible incluso cuando no se estén rastreando misiones, en lugar de que el rastreador esté completamente oculto.",
        ["esMX"] = "Si está activado, el encabezado del rastreador será visible incluso cuando no se estén rastreando misiones, en lugar de que el rastreador esté completamente oculto.",
        ["frFR"] = "Si cette option est activée, l'en-tête du suivi sera visible même lorsque aucune quête n'est suivie, contrairement à la dissimulation complète du suivi.",
        ["koKR"] = "이 옵션을 활성화하면 퀘스트가 추적되지 않을 때와 추적기가 완전히 숨겨져 있을 때에도 추적기 헤더가 표시됩니다.",
        ["ptBR"] = "Se ativado, o cabeçalho do rastreador será visível mesmo quando nenhuma missão estiver sendo rastreada, ao contrário do rastreador sendo completamente oculto.",
        ["ruRU"] = "Когда включено, заголовок трекера будет виден, даже если в трекере нет отслеживаемых заданий",
        ["zhCN"] = "启用后，就算没有追踪任何任务，也会显示任务清单的标题列，而不是完全隐藏清单。",
        ["zhTW"] = "啟用時，就算沒有追蹤任何任務，也會顯示任務清單的標題列，而不是完全隱藏清單。",
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only
    ["List Achievements First"] = {
        ["enUS"] = true,
        ["deDE"] = "Erfolge zuerst anzeigen",
        ["esES"] = "Listar logros primero",
        ["esMX"] = "Listar logros primero",
        ["frFR"] = "Afficher d'abord les hauts faits",
        ["koKR"] = "업적 목록 먼저 표시",
        ["ptBR"] = "Listar conquistas primeiro",
        ["ruRU"] = "Достижения вверху",
        ["zhCN"] = "成就排前面",
        ["zhTW"] = "成就排在前面",
    },
    ["When this is checked, the Questie Tracker will list Achievements first then Quests."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, werden Erfolge im Tracker zuerst und dann Quests angezeigt.",
        ["esES"] = "Si está activado, el rastreador listará primero los logros y después las misiones.",
        ["esMX"] = "Si está activado, el rastreador listará primero los logros y después las misiones.",
        ["frFR"] = "Si cette option est activée, le suivi de Questie affichera d'abord les hauts faits, puis les quêtes.",
        ["koKR"] = "이 옵션을 선택하면 Questie 추적기가 먼저 업적을 나열한 후 퀘스트를 나열합니다.",
        ["ptBR"] = "Se ativado, o rastreador de Questie listará primeiro as conquistas e depois as missões.",
        ["ruRU"] = "Когда включено, достижения в трекере будут отображаться сверху заданий",
        ["zhCN"] = "启用时，任务追踪列表会将成就排在任务的前面",
        ["zhTW"] = "啟用時，任務追蹤清單會將成就排列在任務的前面。",
    },
    ---------------------------------------------------------
    -- VoiceOver Tracker Integration
    ["Sticky VoiceOver Frame"] = {
        ["enUS"] = true,
        ["deDE"] = "Sticky VoiceOver-Fenster",
        ["esES"] = "Marco VoiceOver pegajoso",
        ["esMX"] = "Marco VoiceOver pegajoso",
        ["frFR"] = "Cadre VoiceOver collant",
        ["koKR"] = "음성 안내 고정 프레임",
        ["ptBR"] = "Quadro VoiceOver fixo",
        ["ruRU"] = "Клейкое окно VoiceOver",
        ["zhCN"] = "语音贴齐清单",
        ["zhTW"] = "語音貼齊清單",
    },
    ["When this is checked, the VoiceOver talking head / sound queue frame will be placed on the left or right side of the Questie Tracker depending on where the Tracker is placed on your screen."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn diese Option aktiviert ist, wird das VoiceOver-Fenster auf der linken oder rechten Seite des Questie-Trackers platziert, je nachdem, wo sich der Tracker auf dem Bildschirm befindet.",
        ["esES"] = "Si está activado, el marco de la cabeza parlante de VoiceOver / cola de sonido se colocará en el lado izquierdo o derecho del rastreador de Questie dependiendo de dónde esté ubicado el rastreador en la pantalla.",
        ["esMX"] = "Si está activado, el marco de la cabeza parlante de VoiceOver / cola de sonido se colocará en el lado izquierdo o derecho del rastreador de Questie dependiendo de dónde esté ubicado el rastreador en la pantalla.",
        ["frFR"] = "Si cette option est activée, le cadre de tête parlante / file d'attente sonore de VoiceOver sera placé sur le côté gauche ou droit du suivi de Questie en fonction de l'emplacement du suivi sur l'écran.",
        ["koKR"] = "이 옵션을 선택하면 화면에서 트래커가 배치된 위치에 따라 VoiceOver 토킹 헤드 / 음향 대기열 프레임이 Questie 트래커의 왼쪽 또는 오른쪽에 배치됩니다.",
        ["ptBR"] = "Se ativado, o quadro de cabeça falante / fila de som do VoiceOver será colocado no lado esquerdo ou direito do rastreador de Questie, dependendo de onde o rastreador estiver localizado na tela.",
        ["ruRU"] = "Когда включено, говорящая голова или окно очереди звука VoiceOver будет отображено слева или справа от трекера Questie в зависимости от того, где он расположен на вашем экране",
        ["zhCN"] = "启用时，语音框会放在任务列表的左侧或右侧，根据任务列表在界面上的位置而定。",
        ["zhTW"] = "啟用時，語音框架會放在任務清單的左側或右側，依據任務清單在畫面上的位置而定。",
    },
    ---------------------------------------------------------
    ["Lock Tracker"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker sperren",
        ["esES"] = "Bloquear rastreador",
        ["esMX"] = "Bloquear rastreador",
        ["frFR"] = "Verrouiller la fenêtre du suivi",
        ["koKR"] = "추적기 잠금",
        ["ptBR"] = "Bloqueado o rastreador",
        ["ruRU"] = "Заблокировать трекер",
        ["zhCN"] = "锁定框体",
        ["zhTW"] = "鎖定任務清單",
    },
    ["When this is checked, the Questie Tracker is locked and you need to hold CTRL when you want to move it."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn dies aktiviert ist, dann muss STRG gedrückt gehalten werden, wenn der Tracker bewegt werden soll.",
        ["esES"] = "Si está activado, el rastreador estará bloqueado y debes mantener presionada la tecla CTRL cuando quieras moverlo.",
        ["esMX"] = "Si está activado, el rastreador estará bloqueado y debes mantener presionada la tecla CTRL cuando quieras moverlo.",
        ["frFR"] = "Si cette option est activée, le suivi est vérouillé, maintenez CTRL lorsque vous souhaitez le déplacer.",
        ["koKR"] = "이 옵션을 선택하면 Questie 추적기를 고정하며, 추적기의 위치를 이동하려면 CTRL 키를 눌러야 합니다.",
        ["ptBR"] = "Se ativado, o rastreador de Questie estará bloqueado e você precisará manter pressionada a tecla CTRL quando quiser movê-lo.",
        ["ruRU"] = "Когда это включено, то трекер заблокирован, и для его перемещения вам нужно зажать Ctrl",
        ["zhCN"] = "启用此选项，追踪器被锁定，您需要按住 CTRL 键才能移动它。",
        ["zhTW"] = "啟用時，會鎖定任務清單，必須按住 CTRL 鍵才能移動它。",
    },
    ---------------------------------------------------------
    ["Enable Tracker"] = {
        ["enUS"] = true,
        ["deDE"] = "Den Tracker anzeigen",
        ["esES"] = "Activar el rastreador",
        ["esMX"] = "Activar rastreador",
        ["frFR"] = "Activer le suivi",
        ["koKR"] = "트래커 활성화",
        ["ptBR"] = "Ativar rastreador",
        ["ruRU"] = "Включить трекер",
        ["zhCN"] = "启用跟踪器",
        ["zhTW"] = "啟用任務清單",
    },
    ["Enabling the Tracker will replace the default Blizzard Quest Tracker with the Questie Tracker.\n\nNOTE: Changing this setting will reload the UI."] = {
        ["enUS"] = true,
        ["deDE"] = "Durch Aktivieren des Trackers wird der Standard-Blizzard-Quest-Tracker durch den Questie-Tracker ersetzt.\n\nHINWEIS: Das Ändern dieser Einstellung wird das Benutzerinterface neu laden.",
        ["esES"] = "Al activar el rastreador se reemplazará el rastreador de Blizzard predeterminado por el rastreador de Questie.\n\nNOTA: Cambiar esta configuración se recargará la interfaz de usuario.",
        ["esMX"] = "Al activar el rastreador se reemplazará el rastreador de  Blizzard predeterminado por el rastreador de Questie.\n\nNOTA: Cambiar esta configuración se recargará la interfaz de usuario.",
        ["frFR"] = "Activer le suivi remplacera le suivi de quête par défaut de Blizzard par le suivi de Questie.\n\nREMARQUE : Modifier ce paramètre rechargera l'interface utilisateur.",
        ["koKR"] = "추적기를 활성화하면 기본 블리자드 퀘스트 추적기가 Questie 추적기로 대체됩니다.\n\n참고: 이 설정을 변경하면 UI가 다시 로드됩니다.", --Old Translation: "추적기를 활성화하면 기본 블리자드 퀘스트 추적기가 Questie 추적기로 대체됩니다.",
        ["ptBR"] = "Ativar o rastreador substituirá o rastreador de missões padrão de Blizzard pelo rastreador de Questie.\n\nNOTA: Alterar essa configuração recarregará a IU.",
        ["ruRU"] = "После нажатия данной кнопки трекер Blizzard заменится трекером Questie.\n\nПРИМЕЧАНИЕ: Эта настройка перезапускает пользовательский интерфейс",
        ["zhCN"] = "启用跟踪器会将默认的暴雪自带任务追踪器替换为Questie追踪器。 \n\n注意：更改后会重新载入介面。",
        ["zhTW"] = "啟用任務位置提示插件的任務清單來取代遊戲內建的。\n\n更改後會重新載入介面。",
    },
    ---------------------------------------------------------
    ["Reset Tracker"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker-Position zurücksetzen",
        ["esES"] = "Restablecer rastreador",
        ["esMX"] = "Restablecer rastreador",
        ["frFR"] = "Réinitialiser le suivi",
        ["koKR"] = "추적기 위치 재설정",
        ["ptBR"] = "Redefinir rastreador",
        ["ruRU"] = "Сброс позиции",
        ["zhCN"] = "重置追踪器位置",
        ["zhTW"] = "重置任務清單",
    },
    ["If the Questie Tracker is stuck offscreen or lost, you can reset it's location to the center of the screen with this button."] = {
        ["enUS"] = true,
        ["deDE"] = "Wenn der Questie-Tracker außerhalb des Bildschirms hängen bleibt oder verloren geht, kann seine Position mit dieser Schaltfläche auf die Mitte des Bildschirms zurückgesetzt werden (erfordert möglicherweise ein /reload).",
        ["esES"] = "Si el rastreador Questie está atascado o perdido, puede restablecer su ubicación en el centro de la pantalla con este botón.",
        ["esMX"] = "Si el rastreador Questie está atascado o perdido, puede restablecer su ubicación en el centro de la pantalla con este botón.",
        ["frFR"] = "Si le suivi des quêtes Questie est bloqué hors écran ou perdu, vous pouvez réinitialiser son emplacement au centre de l'écran avec ce bouton (peut nécessiter de /reload).",
        ["koKR"] = "Questie 트래커가 화면을 벗어나거나 잃어버린 경우이 버튼을 사용하여 화면 중앙으로 위치를 재설정 할 수 있습니다 (/ 재로드 필요).",
        ["ptBR"] = "Se o rastreador de Questie estiver preso fora da tela ou perdido, você poderá redefinir sua localização para o centro da tela com este botão (pode exigir / recarregar).",
        ["ruRU"] = "Если трекер исчез полностью или оказался за пределами экрана, то нажатие этой кнопки сбросит его положение в центр экрана (может потребоваться перезагрузка пользовательского интерфейса командой '/reload')",
        ["zhCN"] = "如果Questie追踪器卡在屏幕外或丢失，您可以使用此按钮将其位置重置到屏幕中央（可能需要重载界面 /reload）。",
        ["zhTW"] = "如果任務清單跑出畫面或不見了，使用這個按鈕可以將它重置到畫面的中間。",
    },
    ---------------------------------------------------------
    ["Objective Color"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Zielfarbe",
        ["esES"] = "Color del objetivo",
        ["esMX"] = "Color del objetivo",
        ["frFR"] = "Couleur du objectif",
        ["koKR"] = "퀘스트 목표 색상",
        ["ptBR"] = "Cor do objetivo",
        ["ruRU"] = "Цвет целей",
        ["zhCN"] = "目标颜色",
        ["zhTW"] = "目標顏色",
    },
    ["Change the color of Objectives in the Questie Tracker by how complete they are.\n\nNOTE: The Minimalistic option will not display the \"Blizzard Completion Text\" and just label the Quest as either \"Quest Complete!\" or \"Quest Failed!\"."] = {
        ["enUS"] = true,
        ["deDE"] = "Ändert die Farbe der Quest-Ziele im Questie-Tracker je nach Fortschritt.\n\nHINWEIS: Die minimalistische Option zeigt \"Blizzards Quest-Abgeschlossen-Text\" nicht an und kennzeichnet Quests nur mit \"Quest abgeschlossen!\" oder \"Quest fehlgeschlagen!\".",
        ["esES"] = "Cambia el color de los objetivos en el rastreador de misiones según lo completos que estén.\n\nNOTA: La opción Minimalista no mostrará el \"Texto de completación de Blizzard\" y solo mostrará la misión como \"¡Misión completada!\" o \"¡Misión fracasada!\".",
        ["esMX"] = "Cambia el color de los objetivos en el rastreador de misiones según lo completos que estén.\n\nNOTA: La opción Minimalista no mostrará el \"Texto de completación de Blizzard\" y solo mostrará la misión como \"¡Misión completada!\" o \"¡Misión fracasada!\".",
        ["frFR"] = "Modifiez la couleur des objectifs dans le suivi en fonction de leur état de terminaison.\n\nREMARQUE : L'option Minimaliste n'affichera pas le \"Texte de terminaison de Blizzard\" et se contentera d'afficher la quête comme \"Quête terminée !\" ou \"Quête échouée !\".",
        ["koKR"] = "Questie 추적기에서 목표의 색을 완료도에 따라 변경합니다.\n\n참고: Minimalistic 옵션은 \"블리자드 완료 텍스트\"를 표시하지 않고 퀘스트를 \"퀘스트 완료!\" 또는 \"퀘스트 실패!\"로 표시합니다.",
        ["ptBR"] = "Mude a cor dos objetivos no rastreador de Questie conforme estiverem completos.\n\nNOTA: A opção Minimalista não mostrará o \"Texto de conclusão de Blizzard\" e apenas mostrará a missão como \"Missão concluída!\" ou \"Missão Falhou!\".",
        ["ruRU"] = "Изменение цвета целей заданий в трекере в зависимости от прогресса выполнения.\n\nПРИМЕЧАНИЕ: Настройка 'Минимализм' не будет отображать Blizzard-ский текст об окончании задания, вместо этого будут отображаться или 'Задание выполнено!', или 'Задание провалено!'",
        ["zhCN"] = "根据目标完成度更改 Questie 追踪器中目标的颜色。\n\n注意：极简选项将不会显示“暴雪完成文字”，只会将任务标记为“任务完成！”或“任务失败！”。",
        ["zhTW"] = "依據目標完成度變更 Questie 追蹤器中目標的顏色。\n\n注意：極簡選項將不會顯示「暴雪完成文字」，僅將任務標記為「任務完成！」或「任務失敗！」。",
    },
    ---------------------------------------------------------
    ["Red to Green"] = {
        ["enUS"] = true,
        ["deDE"] = "Rot zu Grün",
        ["esES"] = "Rojo a verde",
        ["esMX"] = "Rojo a verde",
        ["frFR"] = "Rouge à vert",
        ["koKR"] = "빨간색에서 초록색",
        ["ptBR"] = "Vermelho ao verde",
        ["ruRU"] = "От красного к зеленому",
        ["zhCN"] = "由红至绿",
        ["zhTW"] = "紅變綠",
    },
    ["White"] = {
        ["enUS"] = true,
        ["deDE"] = "Weiß",
        ["esES"] = "Blanco",
        ["esMX"] = "Blanco",
        ["frFR"] = "Blanc",
        ["koKR"] = "하얀색",
        ["ptBR"] = "Branco",
        ["ruRU"] = "Белый",
        ["zhCN"] = "白色",
        ["zhTW"] = "白色",
    },
    ["White and Green"] = {
        ["enUS"] = true,
        ["deDE"] = "Weiß und Grün",
        ["esES"] = "Blanco y verde",
        ["esMX"] = "Blanco y verde",
        ["frFR"] = "Blanc et vert",
        ["koKR"] = "하얀색에서 초록색",
        ["ptBR"] = "Branco e verde",
        ["ruRU"] = "Белый и зеленый",
        ["zhCN"] = "白和绿",
        ["zhTW"] = "白和綠",
    },
    ["White to Green"] = {
        ["enUS"] = true,
        ["deDE"] = "Weiß zu Grün",
        ["esES"] = "Blanco a verde",
        ["esMX"] = "Blanco a verde",
        ["frFR"] = "Blanc à vert",
        ["koKR"] = "하얀색에서 초록색",
        ["ptBR"] = "Branco ao verde",
        ["ruRU"] = "От белого к зеленому",
        ["zhCN"] = "由白至绿",
        ["zhTW"] = "白變綠",
    },
    ["Minimalistic"] = {
        ["enUS"] = true,
        ["deDE"] = "Minimalistisch",
        ["esES"] = "Minimalista",
        ["esMX"] = "Minimalista",
        ["frFR"] = "Minimaliste",
        ["koKR"] = "미니멀리즘",
        ["ptBR"] = "Minimalista",
        ["ruRU"] = "Минимализм",
        ["zhCN"] = "极简",
        ["zhTW"] = "極簡",
    },
    ---------------------------------------------------------
    ["Objective Sorting"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Zielsortierung",
        ["esES"] = "Ordenación de los objetivos",
        ["esMX"] = "Ordenación de los objetivos",
        ["frFR"] = "Méthode de tri des objectifs",
        ["koKR"] = "퀘스트 목표 정렬",
        ["ptBR"] = "Ordenaçao dos objetivos",
        ["ruRU"] = "Сортировка целей",
        ["zhCN"] = "目标排序",
        ["zhTW"] = "目標排序",
    },
    -- Classic and TBC only --
    ["How Objectives are sorted in the Questie Tracker."] = {
        ["enUS"] = true,
        ["deDE"] = "Wie Quest-Ziele im Tracker sortiert werden.",
        ["esES"] = "La manera en que se ordenan los objetivos en el rastreador.",
        ["esMX"] = "La manera en que se ordenan los objetivos en el rastreador.",
        ["frFR"] = "Comment les objectifs sont triés dans le suivi.",
        ["koKR"] = "Questie 추적기에서 목표가 정렬되는 방식.",
        ["ptBR"] = "Como os objetivos são ordenados no rastreador.",
        ["ruRU"] = "Выбор типа сортировки целей заданий в трекере",
        ["zhCN"] = "目标在 Questie 追踪器中的排序方式。",
        ["zhTW"] = "目標在 Questie 追蹤器中的排序方式。",
    },
    -- Wrath of the Lich King only --
    ["How Objectives are sorted in the Questie Tracker.\n\nNOTE: This will not sort Achievements."] = {
        ["enUS"] = true,
        ["deDE"] = "Wie Quest-Ziele im Tracker sortiert werden.\n\nHINWEIS: Dies sortiert keine Erfolge.",
        ["esES"] = "La manera en que se ordenan los objetivos en el rastreador.\n\nNOTA: Esto no ordenará los logros.",
        ["esMX"] = "La manera en que se ordenan los objetivos en el rastreador.\n\nNOTA: Esto no ordenará los logros.",
        ["frFR"] = "Comment les objectifs sont triés dans le suivi.\n\nREMARQUE : Cela ne triera pas les hauts faits.",
        ["koKR"] = "추적기에서 퀘스트 목표를 어떻게 정렬해서 보여줄지 설정합니다.",
        ["ptBR"] = "Como os objetivos são ordenados no rastreador.\n\nNOTA: Isso não ordenará as conquistas.",
        ["ruRU"] = "Выбор типа сортировки целей заданий в трекере.\n\nПРИМЕЧАНИЕ: Это не сортирует достижения",
        ["zhCN"] = "目标在 Questie 追踪器中的排序方式。\n\n注意：此设置不会对成就进行排序。",
        ["zhTW"] = "目標在 Questie 追蹤器中的排序方式。\n\n注意：此設定不會對成就進行排序。",
    },
    ---------------------------------------------------------
    ["By %% Complete"] = {
        ["enUS"] = true,
        ["deDE"] = "Nach %% Fertigstellung",
        ["esES"] = "Por %% completada",
        ["esMX"] = "Por %% completada",
        ["frFR"] = "Par %% complet",
        ["koKR"] = "완료된 퍼센트 순",
        ["ptBR"] = "Por %% completo",
        ["ruRU"] = "По %% выполнения",
        ["zhCN"] = "按完成度 %%",
        ["zhTW"] = "依完成度 %%",
    },
    ["By %% Complete (Reversed)"] = {
        ["enUS"] = true,
        ["deDE"] = "Nach %% Fertigstellung (Absteigend)",
        ["esES"] = "Por %% completada (inverso)",
        ["esMX"] = "Por %% completada (inverso)",
        ["frFR"] = "Par %% complet (inversé)",
        ["koKR"] = "완료된 퍼센트 (역순)",
        ["ptBR"] = "Por %% completo (invertido)",
        ["ruRU"] = "По %% выполнения (убыв.)",
        ["zhCN"] = "按完成度 %%（反向）",
        ["zhTW"] = "依完成度 %% (反向)",
    },
    ["By Level"] = {
        ["enUS"] = true,
        ["deDE"] = "Nach Level",
        ["esES"] = "Por nivel",
        ["esMX"] = "Por nivel",
        ["frFR"] = "Par niveau",
        ["koKR"] = "레벨 순서",
        ["ptBR"] = "Por nivel",
        ["ruRU"] = "По уровню",
        ["zhCN"] = "按等级",
        ["zhTW"] = "依等級",
    },
    ["By Level (Reversed)"] = {
        ["enUS"] = true,
        ["deDE"] = "Nach Level (Absteigend)",
        ["esES"] = "Por nivel (inverso)",
        ["esMX"] = "Por nivel (inverso)",
        ["frFR"] = "Par niveau (inversé)",
        ["koKR"] = "레벨 순서 (역순)",
        ["ptBR"] = "Por nível (invertido)",
        ["ruRU"] = "По уровню (убыв.)",
        ["zhCN"] = "按等级（反向）",
        ["zhTW"] = "依等級 (反向)",
    },
    ["By Proximity"] = {
        ["enUS"] = true,
        ["deDE"] = "Nach Nähe",
        ["esES"] = "Por proximidad",
        ["esMX"] = "Por proximidad",
        ["frFR"] = "Par proximité",
        ["koKR"] = "근접도 순",
        ["ptBR"] = "Por proximidade",
        ["ruRU"] = "По близости",
        ["zhCN"] = "按远近",
        ["zhTW"] = "依遠近",
    },
    ["By Proximity (Reversed)"] = {
        ["enUS"] = true,
        ["deDE"] = "Nach Nähe (Absteigend)",
        ["esES"] = "Por proximidad (inverso)",
        ["esMX"] = "Por proximidad (inverso)",
        ["frFR"] = "Par proximité (inversé)",
        ["koKR"] = "근접도 순 (역순)",
        ["ptBR"] = "Por proximidade (invertido)",
        ["ruRU"] = "По близости (убыв.)",
        ["zhCN"] = "按远近（反向）",
        ["zhTW"] = "依遠近 (反向)",
    },
    ["By Zone"] = {
        ["enUS"] = true,
        ["deDE"] = "Nach Zone",
        ["esES"] = "Por zona",
        ["esMX"] = "Por zona",
        ["frFR"] = "Par zone",
        ["koKR"] = "지역별",
        ["ptBR"] = "Por zona",
        ["ruRU"] = "По игровой зоне",
        ["zhCN"] = "按区域",
        ["zhTW"] = "依區域",
    },
    ["By Zone Prox"] = {
        ["enUS"] = true,
        ["deDE"] = "Nach Zonen-Nähe",
        ["esES"] = "Por proximidad de zona",
        ["esMX"] = "Por proximidad de zona",
        ["frFR"] = "Par proximité de zone",
        ["koKR"] = "지역 근접도",
        ["ptBR"] = "Por proximidade de zona",
        ["ruRU"] = "По дальности зоны",
        ["zhCN"] = "按区域远近",
        ["zhTW"] = "依區域遠近",
    },
    ["By Zone Prox (Reversed)"] = {
        ["enUS"] = true,
        ["deDE"] = "Nach Zonen-Nähe (Absteigend)",
        ["esES"] = "Por proximidad de zona (inverso)",
        ["esMX"] = "Por proximidad de zona (inverso)",
        ["frFR"] = "Par proximité de zone (inverté)",
        ["koKR"] = "지역 근접도 (역순)",
        ["ptBR"] = "Por proximidade de zona (invertido)",
        ["ruRU"] = "По дальности зоны (убыв.)",
        ["zhCN"] = "按区域远近（反向）",
        ["zhTW"] = "依區域遠近 (反向)",
    },
    ---------------------------------------------------------
    ["Set |cFF54e33bTomTom|r Target"] = {
        ["enUS"] = true,
        ["deDE"] = "|cFF54e33bTomTom|r-Ziel setzen",
        ["esES"] = "Establecer objetivo de |cFF54e33bTomTom|r",
        ["esMX"] = "Establecer objetivo de |cFF54e33bTomTom|r",
        ["frFR"] = "Définir un point |cFF54e33bTomTom|r",
        ["koKR"] = "|cFF54e33bTomTom|r 대상 설정",
        ["ptBR"] = "Definir alvo de |cFF54e33bTomTom|r",
        ["ruRU"] = "Установить точку |cFF54e33bTomTom|r",
        ["zhCN"] = "显示|cFF54e33bTomTom|r箭头",
        ["zhTW"] = "|cFF54e33bTomTom|r 開始導航",
    },
    -- Classic and TBC only --
    ["This shortcut will set the TomTom arrow to point to either an NPC or the first incomplete Quest Objective (if location data is available)."] = {
        ["enUS"] = true,
        ["deDE"] = "Dieser Shortcut setzt den TomTom-Pfeil auf einen NPC oder das erste unvollständige Quest-Ziel (falls Positionsdaten verfügbar sind).",
        ["esES"] = "Este atajo configurará la flecha de TomTom para que apunte a un PNJ o al primer objetivo de misión incompleto (si hay datos de ubicación disponibles).",
        ["esMX"] = "Este atajo configurará la flecha de TomTom para que apunte a un PNJ o al primer objetivo de misión incompleto (si hay datos de ubicación disponibles).",
        ["frFR"] = "Ce raccourci définira la flèche TomTom pour pointer vers un PNJ ou le premier objectif de quête incomplet (si des données de localisation sont disponibles).",
        ["koKR"] = "이 단축키는 TomTom 화살표를 NPC나 첫 번째 미완성 퀘스트 목표로 설정합니다 (위치 데이터가 있는 경우).",
        ["ptBR"] = "Este atalho definirá a seta do TomTom para apontar para um NPC ou o primeiro objetivo de missão incompleto (se houver dados de localização disponíveis).",
        ["ruRU"] = "Сочетание клавиш для установки точки TomTom либо на NPC, либо на первую невыполненную цель задания (если имеются координаты)",
        ["zhCN"] = "此捷径将会设置 TomTom 箭头指向 NPC 或第一个未完成的任务目标（如果位置数据可用）。",
        ["zhTW"] = "此捷徑將會設定 TomTom 箭頭指向 NPC 或第一個未完成的任務目標（如果位置資料可用）。",
    },
    -- Wrath of the Lich King only --
    ["This shortcut will set the TomTom arrow to point to either an NPC or the first incomplete Quest Objective (if location data is available).\n\nNOTE: This will not work with Achievements."] = {
        ["enUS"] = true,
        ["deDE"] = "Der Tracker-Shortcut, um TomTom zu öffnen The tracker shortcut to open TomTom.",
        ["esES"] = "El atajo del rastreador para abrir TomTom",
        ["esMX"] = "El atajo del rastreador para abrir TomTom",
        ["frFR"] = "Définis le raccourci servant à ouvrir TomTom.",
        ["koKR"] = "추적기에서 TomTom 애드온을 여는 단축키를 설정합니다.",
        ["ptBR"] = "Atalho para abrir TomTom",
        ["ruRU"] = "Сочетание клавиш для установки точки TomTom либо на NPC, либо на первую невыполненную цель задания (если имеются координаты).\n\nПРИМЕЧАНИЕ: Это не работает с достижениями",
        ["zhCN"] = "此捷径将会设置 TomTom 箭头指向 NPC 或第一个未完成的任务目标（如果位置数据可用）。\n\n注意：此功能不适用于成就。",
        ["zhTW"] = "此捷徑將會設定 TomTom 箭頭指向 NPC 或第一個未完成的任務目標（如果位置資料可用）。\n\n注意：此功能不適用於成就。",
    },
    ---------------------------------------------------------
    -- Classic and TBC only --
    ["Show in Quest Log"] = {
        ["enUS"] = true,
        ["deDE"] = "Im Quest-Log anzeigen",
        ["esES"] = "Mostrar en el registro de misiones",
        ["esMX"] = "Mostrar en el registro de misiones",
        ["frFR"] = "Afficher dans le journal de quête",
        ["koKR"] = "퀘스트 로그에서 표시",
        ["ptBR"] = "Mostrar no registro de missões",
        ["ruRU"] = "Показать в журнале заданий",
        ["zhCN"] = "显示任务日志",
        ["zhTW"] = "顯示任務日誌",
    },
    -- Classic and TBC only --
    ["This shortcut will open the Quest Log with the clicked Quest selected."] = {
        ["enUS"] = true,
        ["deDE"] = "Dieser Shortcut öffnet das Quest-Log mit der angeklickten Quest.",
        ["esES"] = "Este atajo abrirá el registro de misiones con la misión en la que se hizo clic seleccionada.",
        ["esMX"] = "Este atajo abrirá el registro de misiones con la misión en la que se hizo clic seleccionada.",
        ["frFR"] = "Ce raccourci ouvrira le journal des quêtes avec la quête cliquée sélectionnée.",
        ["koKR"] = "이 단축키는 클릭한 퀘스트가 선택된 상태로 퀘스트 로그를 엽니다.",
        ["ptBR"] = "Este atalho abrirá o registro de missões com a missão clicada selecionada.",
        ["ruRU"] = "Сочетание клавиш для открытия задания в журнале заданий",
        ["zhCN"] = "此功能会打开任务日志并显示选点的任务。",
        ["zhTW"] = "此功能會打開任務日誌並顯示選點的任務。",
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only --
    ["Show Quest / Achievement"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest / Erfolg anzeigen",
        ["esES"] = "Mostrar misión/logro",
        ["esMX"] = "Mostrar misión/logro",
        ["frFR"] = "Afficher quête / haut fait",
        ["koKR"] = "퀘스트 / 업적 표시",
        ["ptBR"] = "Mostrar missão/conquista",
        ["ruRU"] = "Задание / Достижение",
        ["zhCN"] = "显示任务 / 成就",
        ["zhTW"] = "顯示任務 / 成就",
    },
    -- Wrath of the Lich King only --
    ["This shortcut will open the Quest Log with the clicked Quest selected or open Achievements with the clicked Achievement selected."] = {
        ["enUS"] = true,
        ["deDE"] = "Dieser Shortcut öffnet das Quest-Log mit der angeklickten Quest oder dem Erfolg.",
        ["esES"] = "Este atajo abrirá el registro de misiones con la misión cliqueada seleccionada o abrirá los logros con el logro cliqueado seleccionado.",
        ["esMX"] = "Este atajo abrirá el registro de misiones con la misión cliqueada seleccionada o abrirá los logros con el logro cliqueado seleccionado.",
        ["frFR"] = "Ce raccourci ouvrira le journal des quêtes avec la quête cliquée sélectionnée ou ouvrira les hauts faits avec le haut hait cliqué sélectionné.",
        ["koKR"] = "이 단축키는 클릭한 퀘스트나 업적을 선택하여 퀘스트 로그나 업적을 엽니다.",
        ["ptBR"] = "Este atalho abrirá o registro de missões com a missão clicada selecionada ou abrirá as conquistas com a conquista clicada selecionada.",
        ["ruRU"] = "Сочетание клавиш для открытия задания в журнале заданий или достижения в окне достижений",
        ["zhCN"] = "此功能会打开任务日志并显示选点的任务，或是打开成就窗口并显示选点的成就。",
        ["zhTW"] = "此功能會打開任務日誌並顯示選點的任務，或是打開成就視窗並顯示選點的的成就。",
    },
    ---------------------------------------------------------
    -- Classic and TBC only --
    ["Untrack / Link Quest"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest verlinken/entfernen",
        ["esES"] = "No rastrear/vincular misión",
        ["esMX"] = "No rastrear/vincular misión",
        ["frFR"] = "Désuivre / Lier la quête",
        ["koKR"] = "퀘스트 추적 취소 / 링크",
        ["ptBR"] = "Remover rastreio/vincular missão",
        ["ruRU"] = "Отмена / Ссылка",
        ["zhCN"] = "取消追踪 / 任务链接",
        ["zhTW"] = "取消追蹤 / 任務連結",
    },
    -- Classic and TBC only --
    ["This shortcut removes a Quest from the Questie Tracker when the chat input box is NOT visible, otherwise this will link a Quest to chat."] = {
        ["enUS"] = true,
        ["deDE"] = "Dieser Shortcut entfernt eine Quest aus dem Questie-Tracker, wenn das Chat-Eingabefeld nicht sichtbar ist, andernfalls wird die Quest verlinkt.",
        ["esES"] = "Este atajo elimina una misión del rastreador cuando el cuadro de entrada del chat NO está visible; de lo contrario, vinculará una misión al chat.",
        ["esMX"] = "Este atajo elimina una misión del rastreador cuando el cuadro de entrada del chat NO está visible; de lo contrario, vinculará una misión al chat.",
        ["frFR"] = "Ce raccourci retire une quête du suivi lorsque la boîte de saisie de discussion n'est PAS visible, sinon il liera une quête au discussion.",
        ["koKR"] = "이 단축키는 채팅 입력창이 보이지 않을 때 Questie 추적기에서 퀘스트를 제거하며, 그렇지 않으면 퀘스트를 채팅에 링크합니다.",
        ["ptBR"] = "Este atalho remove uma missão do rastreador quando a caixa de entrada do bate-papo NÃO está visível; caso contrário, ele vinculará uma missão ao bate-papo.",
        ["ruRU"] = "Сочетание клавиш для отмены отслеживания задания в трекере. Если активно поле ввода чата, то вместо отмены отслеживания в чат отправится ссылка на задание",
        ["zhCN"] = "当聊天输入框不可见时，此快捷键会将任务从 Questie 追踪器中移除；否则，会将任务链接到聊天中。",
        ["zhTW"] = "正在聊天視窗打字時，此功能會產生可以貼到聊天視窗的任務連結。不是正在打字時會從任務清單中移除任務。",
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only --
    ["Untrack / Link"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest verlinken/entfernen",
        ["esES"] = "No rastrear/vincular misión",
        ["esMX"] = "No rastrear/vincular misión",
        ["frFR"] = "Ne plus traquer et partager le lien de la quête",
        ["koKR"] = "추적종료 / 링크 퀘스트",
        ["ptBR"] = "Remover rastreio/vincular missão",
        ["ruRU"] = "Отмена / Ссылка",
        ["zhCN"] = "停止追踪 / 链接",
        ["zhTW"] = "取消追蹤 / 任務連結",
    },
    -- Wrath of the Lich King only --
    ["This shortcut removes a Quest or an Achievement from the Questie Tracker when the chat input box is NOT visible, otherwise this will link a Quest or an Achievement to chat."] = {
        ["enUS"] = true,
        ["deDE"] = "Dieser Shortcut entfernt eine Quest oder einen Erfolg aus dem Questie-Tracker, wenn das Chat-Eingabefeld nicht sichtbar ist, andernfalls wird die Quest oder der Erfolg verlinkt.",
        ["esES"] = "Este atajo elimina una misión o un logro del rastreador de Questie cuando la caja de entrada de chat NO está visible; de lo contrario, vinculará una misión o un logro al chat.",
        ["esMX"] = "Este atajo elimina una misión o un logro del rastreador de Questie cuando la caja de entrada de chat NO está visible; de lo contrario, vinculará una misión o un logro al chat.",
        ["frFR"] = "Ce raccourci retire une quête ou un haut fait du suivi de Questie lorsque la boîte de saisie de discussion n'est PAS visible, sinon il liera une quête ou un haut fait au discussion.",
        ["koKR"] = "이 단축키는 채팅 입력창이 보이지 않을 때 Questie 추적기에서 퀘스트나 업적을 제거하며, 그렇지 않으면 퀘스트나 업적을 채팅에 링크합니다.",
        ["ptBR"] = "Este atalho remove uma missão ou uma conquista do rastreador de Questie quando a caixa de entrada do bate-papo NÃO está visível; caso contrário, ele vinculará uma missão ou uma conquista ao bate-papo.",
        ["ruRU"] = "Сочетание клавиш для отмены отслеживания задания или достижения в трекере. Если активно поле ввода чата, то вместо отмены отслеживания в чат отправится ссылка на задание или достижение",
        ["zhCN"] = "正在聊天窗口打字时，此功能会产生可以点到聊天窗口的任务或者成就链接。不是正在打字时会从任务列表中移除任务或成就。",
        ["zhTW"] = "正在聊天視窗打字時，此功能會產生可以貼到聊天視窗的任務或成就連結。不是正在打字時會從任務清單中移除任務或成就。",
    },
    ---------------------------------------------------------
    ["Tracker Growth Direction"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker Wachstumsrichtung",
        ["esES"] = "Dirección de crecimiento",
        ["esMX"] = "Dirección de crecimiento",
        ["frFR"] = "Direction de croissance du suivi",
        ["koKR"] = "추적기 성장 방향",
        ["ptBR"] = "Direção de crescimento",
        ["ruRU"] = "Изменение размера трекера",
        ["zhCN"] = "列表增长方向",
        ["zhTW"] = "清單增長方向",
    },
    ["This determines the direction in which the Questie Tracker grows when you add or remove Quests. For example, if you use the \"Up & Right\" option then the ideal place for the Tracker should be in the lower left-hand corner of your screen. This allows the \"Sizer Mode: Auto\" to push the Tracker Height and Width \"Up & Right\" so the Tracker doesn't inadvertently cover up elements of your UI."] = {
        ["enUS"] = true,
        ["deDE"] = "Dies bestimmt die Richtung, in der der Questie Tracker wächst, wenn Quests hinzugefügt oder entfernt werden. Wenn du beispielsweise die Option \"Oben & Rechts\" verwendest, sollte sich der Tracker idealerweise in der unteren linken Ecke deines Bildschirms befinden. Dies ermöglicht es dem \"Sizer-Modus: Auto\", die Tracker-Höhe und -Breite \"Oben & Rechts\" zu verschieben, damit der Tracker nicht versehentlich Elemente deiner UI verdeckt.",
        ["esES"] = "Esto determina la dirección en la que crece el rastreador cuando agregas o eliminas misiones. Por ejemplo, si usas la opción \"Arriba y derecha\", el lugar ideal para el rastreador debe ser en la esquina inferior izquierda de la pantalla. Esto permite que el \"Modo de medición: Automático\" empuje la altura y el ancho del rastreador hacia arriba y hacia la derecha para que el rastreador no cubra inadvertidamente elementos de su interfaz de usuario.",
        ["esMX"] = "Esto determina la dirección en la que crece el rastreador cuando agregas o eliminas misiones. Por ejemplo, si usas la opción \"Arriba y derecha\", el lugar ideal para el rastreador debe ser en la esquina inferior izquierda de la pantalla. Esto permite que el \"Modo de medición: Automático\" empuje la altura y el ancho del rastreador hacia arriba y hacia la derecha para que el rastreador no cubra inadvertidamente elementos de su interfaz de usuario.",
        ["frFR"] = "Cela détermine la direction dans laquelle le suivi de Questie se développe lorsque vous ajoutez ou supprimez des quêtes. Par exemple, si vous utilisez l'option \"Haut et Droite\", alors l'endroit idéal pour le suivi devrait être dans le coin inférieur gauche de votre écran. Cela permet au \"Mode de calibrage : Automatique\" de pousser la hauteur et la largeur du suivi \"Haut et Droite\" afin que le suivi ne recouvre pas involontairement des éléments de votre interface utilisateur.",
        ["koKR"] = "이 설정은 퀘스트를 추가하거나 제거할 때 Questie 추적기가 성장하는 방향을 결정합니다. 예를 들어, \"위쪽 & 오른쪽\" 옵션을 사용하면 추적기의 이상적인 위치는 화면의 왼쪽 하단이어야 합니다. 이를 통해 \"크기 조정 모드: 자동\"이 추적기의 높이와 너비를 \"위쪽 & 오른쪽\"으로 밀어 UI 요소를 덮지 않도록 합니다.",
        ["ptBR"] = "Isso determina a direção na qual o rastreador de Questie cresce quando você adiciona ou remove missões. Por exemplo, se você usar a opção \"Para Cima e Para a Direita\", então o local ideal para o rastreador deve ser no canto inferior esquerdo da tela. Isso permite que o \"Modo de medição: Automático\" empurre a Altura e a Largura do rastreador \"Para Cima e Para a Direita\" para que o rastreador não cubra inadvertidamente elementos da sua interface de usuário.",
        ["ruRU"] = "Определяет направление, в котором изменяется размер трекера при добавлении или удалении заданий. Например, при использовании значения \"Вверх и вправо\" идеальным расположением для трекера будет нижний левый угол вашего экрана. Это позволяет сайзеру (изменитель размера трекера) в режиме \"Авто\" выставлять высоту и ширину трекера \"Вверх и вправо\" так, чтобы трекер случайно не скрыл элементы вашего интерфейса.",
        ["zhCN"] = "新增或移除任务时，任务列表的增长方向。例如：列表在界面的左下方时，可以使用 \"上 & 右\"，让 \"调整大小模式：自动 \" 往 \"上 & 右\" 调整列表的高度和宽度，列表便不会挡住其他界面清。",
        ["zhTW"] = "新增或移除任務時，任務清單的延伸方向。例如清單位置在畫面的左下方時，可以使用 \"上 & 右\"，讓 \"調整大小模式: 自動\" 往 \"上 & 右\" 調整清單的高度和寬度，清單便不會擋住其他介面。",
    },
    ---------------------------------------------------------
    ["Up & Right"] = {
        ["enUS"] = true,
        ["deDE"] = "Oben & Rechts",
        ["esES"] = "Arriba y derecho",
        ["esMX"] = "Arriba y derecho",
        ["frFR"] = "En haut et à droite",
        ["koKR"] = "위쪽 & 오른쪽",
        ["ptBR"] = "Para cima e para a direita",
        ["ruRU"] = "Вверх и вправо",
        ["zhCN"] = "上 & 右",
        ["zhTW"] = "上 & 右",
    },
    ["Up & Left"] = {
        ["enUS"] = true,
        ["deDE"] = "Oben & Links",
        ["esES"] = "Arriba y izquierdo",
        ["esMX"] = "Arriba y izquierdo",
        ["frFR"] = "En haut et à gauche",
        ["koKR"] = "위쪽 & 왼쪽",
        ["ptBR"] = "Para cima e para a esquerda",
        ["ruRU"] = "Вверх и влево",
        ["zhCN"] = "上 & 左",
        ["zhTW"] = "上 & 左",
    },
    ["Down & Right"] = {
        ["enUS"] = true,
        ["deDE"] = "Unten & Rechts",
        ["esES"] = "Abajo y derecho",
        ["esMX"] = "Abajo y derecho",
        ["frFR"] = "En bas et à droite",
        ["koKR"] = "아래쪽 & 오른쪽",
        ["ptBR"] = "Para baixo e para a direita",
        ["ruRU"] = "Вниз и вправо",
        ["zhCN"] = "下 & 右",
        ["zhTW"] = "下 & 右",
    },
    ["Down & Left"] = {
        ["enUS"] = true,
        ["deDE"] = "Unten & Links",
        ["esES"] = "Abajo y izquierdo",
        ["esMX"] = "Abajo y izquierdo",
        ["frFR"] = "En bas et à gauche",
        ["koKR"] = "아래쪽 & 왼쪽",
        ["ptBR"] = "Para baixo e para a esquerda",
        ["ruRU"] = "Вниз и влево",
        ["zhCN"] = "下 & 左",
        ["zhTW"] = "下 & 左",
    },
    ---------------------------------------------------------
    ["Font Size for Active Quests Header"] = {
        ["enUS"] = true,
        ["deDE"] = "Schriftgröße für aktive Quests",
        ["esES"] = "Tamaño de fuente para misiones activas",
        ["esMX"] = "Tamaño de fuente para misiones activas",
        ["frFR"] = "Taille de police pour les quêtes actives",
        ["koKR"] = "활성 퀘스트의 글꼴 크기",
        ["ptBR"] = "Tamanho da fonte para missões ativas",
        ["ruRU"] = "Размер шрифта заголовка",
        ["zhCN"] = "当前任务字体大小",
        ["zhTW"] = "標題列文字大小",
    },
    ["The font size used for the Active Quests Header."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schriftgröße die für aktive Quests verwendet wird.",
        ["esES"] = "El tamaño de fuente utilizado para las misiones activas.",
        ["esMX"] = "El tamaño de fuente utilizado para las misiones activas.",
        ["frFR"] = "Taille de police utilisée par quêtes actives.",
        ["koKR"] = "Active Quests에서 사용하는 글꼴 크기입니다.",
        ["ptBR"] = "O tamanho da fonte que o missões ativas usa.",
        ["ruRU"] = "Размер шрифта, используемого в заголовке 'Активные задания'",
        ["zhCN"] = "当前任务使用的字体大小。",
        ["zhTW"] = "標題列文字的字體大小。",
    },
    ---------------------------------------------------------
    ["Font for Active Quests Header"] = {
        ["enUS"] = true,
        ["deDE"] = "Schriftart für aktive Quests",
        ["esES"] = "Fuente para misiones activas",
        ["esMX"] = "Fuente para misiones activas",
        ["frFR"] = "Police pour les quêtes actives",
        ["koKR"] = "활성 퀘스트를위한 글꼴",
        ["ptBR"] = "Fonte para missões ativas",
        ["ruRU"] = "Шрифт заголовка",
        ["zhCN"] = "当前任务的字体",
        ["zhTW"] = "標題列字體",
    },
    ["The font used for the Active Quests Header."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schriftart die für aktive Quests verwendet wird.",
        ["esES"] = "La fuente utilizada para las misiones activas.",
        ["esMX"] = "La fuente utilizada para las misiones activas.",
        ["frFR"] = "La police utilisée par Active Quests.",
        ["koKR"] = "액티브 퀘스트 글꼴이 사용합니다.",
        ["ptBR"] = "A fonte usada para missões ativas.",
        ["ruRU"] = "Шрифт, используемый в заголовке 'Активные задания'",
        ["zhCN"] = "当前任务使用的字体。",
        ["zhTW"] = "標題列文字的字體。",
    },
    ---------------------------------------------------------
    ["Font Size for Zone Names"] = {
        ["enUS"] = true,
        ["deDE"] = "Schriftgröße für Zonennamen",
        ["esES"] = "Tamaño de fuente para nombres de zona",
        ["esMX"] = "Tamaño de fuente para nombres de zona",
        ["frFR"] = "Taille de police pour les noms de zone",
        ["koKR"] = "영역 이름의 글꼴 크기",
        ["ptBR"] = "Tamanho da fonte para nomes de zonas",
        ["ruRU"] = "Размер шрифта названий игровых зон",
        ["zhCN"] = "区域名称字体大小",
        ["zhTW"] = "區域名稱文字大小",
    },
    ["The font size used for zone names."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schriftgröße die für Zonennamen verwendet wird.",
        ["esES"] = "El tamaño de fuente utilizado para los nombres de zona.",
        ["esMX"] = "El tamaño de fuente utilizado para los nombres de zona.",
        ["frFR"] = "La taille de police utilisée pour les noms de zone.",
        ["koKR"] = "영역 이름에 사용되는 글꼴 크기입니다.",
        ["ptBR"] = "O tamanho da fonte usada para nomes de zonas.",
        ["ruRU"] = "Размер шрифта, используемого в названиях игровых зон",
        ["zhCN"] = "区域名称使用的字体大小。",
        ["zhTW"] = "區域名稱文字的字體大小。",
    },
    ---------------------------------------------------------
    ["Font for Zone Names"] = {
        ["enUS"] = true,
        ["deDE"] = "Schriftart für Zonennamen",
        ["esES"] = "Fuente para nombres de zona",
        ["esMX"] = "Fuente para nombres de zona",
        ["frFR"] = "Police pour les noms de zone",
        ["koKR"] = "영역 이름의 글꼴",
        ["ptBR"] = "Fonte para nomes de zonas",
        ["ruRU"] = "Шрифт названий игровых зон",
        ["zhCN"] = "区域名称字体",
        ["zhTW"] = "區域名稱字體",
    },
    ["The font used for zone names."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schriftart die für Zonennamen verwendet wird.",
        ["esES"] = "La fuente utilizada para los nombres de zona.",
        ["esMX"] = "La fuente utilizada para los nombres de zona.",
        ["frFR"] = "La police utilisée pour les noms de zone.",
        ["koKR"] = "영역 이름에 사용되는 글꼴입니다.",
        ["ptBR"] = "A fonte usada para nomes de zona.",
        ["ruRU"] = "Шрифт, используемый в названиях игровых зон",
        ["zhCN"] = "区域名称使用的字体",
        ["zhTW"] = "區域名稱文字的字體。",
    },
    ---------------------------------------------------------
    ["Font Size for Quest Titles"] = {
        ["enUS"] = true,
        ["deDE"] = "Schriftgröße für Quest-Titel",
        ["esES"] = "Tamaño de fuente para títulos de misión",
        ["esMX"] = "Tamaño de fuente para títulos de misión",
        ["frFR"] = "Taille de police pour les titres de quête",
        ["koKR"] = "퀘스트 제목의 글꼴 크기",
        ["ptBR"] = "Tamanho da fonte para títulos de missão",
        ["ruRU"] = "Размер шрифта названий заданий",
        ["zhCN"] = "任务标题字体大小",
        ["zhTW"] = "任務標題文字大小",
    },
    ["The font size used for Quest Titles.\n\nNOTE: Objective font size will auto adjust to less than or equal to Quest font size. This is necessary to avoid any text collisions and formatting abnormalities."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schriftgröße der Quest-Titel.\n\nHINWEIS: Die Schriftgröße für Quest-Ziele wird automatisch auf weniger als oder gleich der Quest-Titel Schriftgröße angepasst. Dies ist notwendig, um Textkollisionen und Formatierungsfehler zu vermeiden.",
        ["esES"] = "El tamaño de fuente utilizado para los títulos de misión.\n\nNOTA: El tamaño de fuente de los objetivos se ajustará automáticamente a un tamaño menor o igual al del título de la misión. Esto es necesario para evitar colisiones de texto y anormalidades en el formato.",
        ["esMX"] = "El tamaño de fuente utilizado para los títulos de misión.\n\nNOTA: El tamaño de fuente de los objetivos se ajustará automáticamente a un tamaño menor o igual al del título de la misión. Esto es necesario para evitar colisiones de texto y anormalidades en el formato.",
        ["frFR"] = "La taille de police utilisée pour les titres de quête.\n\nREMARQUE : La taille de police des objectifs s'ajustera automatiquement à moins ou égale à la taille de police des quêtes. Cela est nécessaire pour éviter toute collision de texte et toute anomalie de formatage.",
        ["koKR"] = "퀘스트 제목에 사용되는 글꼴 크기입니다.\n\n참고: 목표 글꼴 크기는 퀘스트 글꼴 크기보다 작거나 같게 자동 조정됩니다. 이는 텍스트 충돌 및 형식 오류를 방지하기 위해 필요합니다.",
        ["ptBR"] = "O tamanho da fonte usado para os títulos de missão.\n\nNOTA: O tamanho da fonte do objetivo será ajustado automaticamente para menos ou igual ao tamanho da fonte da missão. Isso é necessário para evitar colisões de texto e anormalidades de formatação.",
        ["ruRU"] = "Размер шрифта, используемого в названиях заданий.\n\nПРИМЕЧАНИЕ: Размер шрифта целей будет автоматически скорректирован до значения меньше или равно 'Размер шрифта названий заданий'. Это необходимо для того, чтобы избежать любых проблем с текстом и форматированием",
        ["zhCN"] = "任务标题所使用的字体大小。\n\n注意：任务目标的字体大小会自动调整为小于或等于任务标题的字体大小。这样可以避免文字重叠和格式异常。",
        ["zhTW"] = "任務標題所使用的字體大小。\n\n注意：任務目標的字體大小會自動調整為小於或等於任務標題的字體大小。這樣可以避免文字重疊和格式異常。",
    },
    ---------------------------------------------------------
    ["Font for Quest Titles"] = {
        ["enUS"] = true,
        ["deDE"] = "Schriftart für Quest-Titel",
        ["esES"] = "Fuente para títulos de misión",
        ["esMX"] = "Fuente para títulos de misión",
        ["frFR"] = "Police pour les titres de quête",
        ["koKR"] = "퀘스트 타이틀용 글꼴",
        ["ptBR"] = "Fonte para títulos de missão",
        ["ruRU"] = "Шрифт названий заданий",
        ["zhCN"] = "任务标题字体",
        ["zhTW"] = "任務標題字體",
    },
    ["The font used for Quest Titles."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schriftart die für Quest-Titel verwendet wird.",
        ["esES"] = "La fuente utilizada para los títulos de misión.",
        ["esMX"] = "La fuente utilizada para los títulos de misión.",
        ["frFR"] = "La police utilisée pour les titres de quête.",
        ["koKR"] = "퀘스트 제목에 사용되는 글꼴입니다.",
        ["ptBR"] = "A fonte usada para os títulos de missão.",
        ["ruRU"] = "Шрифт, используемый в названиях заданий",
        ["zhCN"] = "任务标题使用的字体。",
        ["zhTW"] = "任務標題文字的字體。",
    },
    ---------------------------------------------------------
    ["Font Size for Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Schriftgröße für Quest-Ziele",
        ["esES"] = "Tamaño de fuente para objetivos",
        ["esMX"] = "Tamaño de fuente para objetivos",
        ["frFR"] = "Taille de police pour les objectifs",
        ["koKR"] = "목표를위한 글꼴 크기",
        ["ptBR"] = "Tamanho da fonte para objetivos",
        ["ruRU"] = "Размер шрифта целей",
        ["zhCN"] = "目标字体大小",
        ["zhTW"] = "目標字體大小",
    },
    ["The font size used for Objectives.\n\nNOTE: Objective font size will auto adjust to less than or equal to Quest font size. This is necessary to avoid any text collisions and formatting abnormalities."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schriftgröße die für Quest-Ziele verwendet wird.",
        ["esES"] = "El tamaño de fuente utilizado para los objetivos.",
        ["esMX"] = "El tamaño de fuente utilizado para los objetivos.",
        ["frFR"] = "La taille de police utilisée pour les objectifs.",
        ["koKR"] = "목표에 사용되는 글꼴 크기입니다.",
        ["ptBR"] = "O tamanho da fonte usada para os objetivos.",
        ["ruRU"] = "Размер шрифта, используемого в наименованиях целей заданий.\n\nПРИМЕЧАНИЕ: Размер шрифта целей будет автоматически скорректирован до значения меньше или равно 'Размер шрифта названий заданий'. Это необходимо для того, чтобы избежать любых проблем с текстом и форматированием",
        ["zhCN"] = "用于任务目标的字体大小。\n\n注意：任务目标的字体大小会自动调整为小于或等于任务标题的字体大小。这样做可以避免文字重叠和格式异常。",
        ["zhTW"] = "用於任務目標的字體大小。\n\n注意：任務目標的字體大小會自動調整為小於或等於任務標題的字體大小。這樣做可以避免文字重疊和格式異常。",
    },
    ---------------------------------------------------------
    ["Font for Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Schriftart für Quest-Ziele",
        ["esES"] = "Fuente para objetivos",
        ["esMX"] = "Fuente para objetivos",
        ["frFR"] = "Police pour les objectifs",
        ["koKR"] = "목표를위한 글꼴",
        ["ptBR"] = "Fonte para objetivos",
        ["ruRU"] = "Шрифт целей",
        ["zhCN"] = "目标字体",
        ["zhTW"] = "目標字體",
    },
    ["The font used for Objectives."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Schriftart die für Quest-Ziele verwendet wird.",
        ["esES"] = "La fuente utilizada para los objetivos.",
        ["esMX"] = "La fuente utilizada para los objetivos.",
        ["frFR"] = "La police utilisée pour les objectifs.",
        ["koKR"] = "목표에 사용되는 글꼴입니다.",
        ["ptBR"] = "A fonte usada para objetivos.",
        ["ruRU"] = "Шрифт, используемый в наименовании целей",
        ["zhCN"] = "目标的字体。",
        ["zhTW"] = "目标的字体。",
    },
    ---------------------------------------------------------
    ["Padding Between Quests"] = {
        ["enUS"] = true,
        ["deDE"] = "Abstand zwischen Quests",
        ["esES"] = "Espaciado entre misiones",
        ["esMX"] = "Espaciado entre misiones",
        ["frFR"] = "Espacement entre les quêtes",
        ["koKR"] = "퀘스트간 간격 설정",
        ["ptBR"] = "Espaçamento entre missões",
        ["ruRU"] = "Отступ между заданиями",
        ["zhCN"] = "任务间距",
        ["zhTW"] = "任務間距",
    },
    ["The amount of padding between Quests in the Questie Tracker.\n\nNOTE: Changing this setting while in Sizer Manual Mode will reset the Sizer back to Auto Mode"] = {
        ["enUS"] = true,
        ["deDE"] = "Der Abstand zwischen Quests im Questie-Tracker.\n\nHINWEIS: Wenn Sie diese Einstellung im manuellen Sizer-Modus ändern, wird der Sizer wieder in den automatischen Modus zurückgesetzt",
        ["esES"] = "La cantidad de espacio entre misiones en el rastreador.\n\nNOTA: Cambiar esta configuración mientras está en el modo manual de medición restablecerá el medidor nuevamente al modo automático.",
        ["esMX"] = "La cantidad de espacio entre misiones en el rastreador.\n\nNOTA: Cambiar esta configuración mientras está en el modo manual de medición restablecerá el medidor nuevamente al modo automático.",
        ["frFR"] = "La quantité d'espace entre les quêtes dans le suivi des quêtes.\n\nREMARQUE : Modifier ce paramètre en mode manuel de calibrage réinitialisera le calibreur en mode automatique.",
        ["koKR"] = "Questie Tracker에서 퀘스트 사이의 패딩 양입니다.\n\n참고: Sizer 수동 모드에서 이 설정을 변경하면 Sizer가 다시 자동 모드로 재설정됩니다.",
        ["ptBR"] = "A quantidade de espaço entre missões no rastreador.\n\nNOTA: Alterar esta configuração no modo manual de medição irá redefinir o medidor de volta para o modo automático.",
        ["ruRU"] = "Установка отступа между заданиями в трекере.\n\nПРИМЕЧАНИЕ: Если сайзер (изменитель размера трекера) в ручном режиме, то изменение этой настройки сбросит режим сайзера на автоматический",
        ["zhCN"] = "Questie Tracker 中任务之间的填充量。\n\n注意：在 Sizer 手动模式下更改此设置会将 Sizer 重置为自动模式",
        ["zhTW"] = "清單中每個任務之間的距離。\n\n注意: 在手動調整大小的模式下更改此設定會重置為自動模式。",
    },
    ---------------------------------------------------------
    ["Outline for Zones, Titles, and Objectives"] = {
        ["enUS"] = true,
        ["deDE"] = "Konturen für Zonen, Titel und Ziele",
        ["esES"] = "Contorno para zonas, títulos y objetivos",
        ["esMX"] = "Contorno para zonas, títulos y objetivos",
        ["frFR"] = "Contours pour les zones, les titres et les objectifs",
        ["koKR"] = "지역, 제목 및 목표에 대한 외곽선",
        ["ptBR"] = "Contorno para zonas, títulos e objetivos",
        ["ruRU"] = "Обводка шрифтов",
        ["zhCN"] = "区域、标题和目标的文字外框",
        ["zhTW"] = "區域、標題和目標的文字外框",
    },
    ["The outline used for Quest Zones, Titles, and Objectives in the Questie Tracker."] = {
        ["enUS"] = true,
        ["deDE"] = "Die Konturen die für Zonen, Titel und Ziele im Questie-Tracker verwendet werden.",
        ["esES"] = "El contorno utilizado para las zonas, títulos y objetivos en el rastreador.",
        ["esMX"] = "El contorno utilizado para las zonas, títulos y objetivos en el rastreador.",
        ["frFR"] = "Le contour utilisé pour les zones, les titres et les objectifs dans le suivi.",
        ["koKR"] = "Questie 추적기에서 퀘스트 지역, 제목 및 목표에 사용되는 외곽선입니다.",
        ["ptBR"] = "O contorno usado para as zonas, títulos e objetivos no rastreador.",
        ["ruRU"] = "Обводка для шрифтов названий игровых зон, названий заданий и целей",
        ["zhCN"] = "在 Questie 追踪器中，用于任务区域、标题与目标的文字外框样式。",
        ["zhTW"] = "在 Questie 追蹤器中，用於任務區域、標題與目標的文字外框樣式。",
    },
    ---------------------------------------------------------
    ["Tracker Backdrop Alpha"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker Hintergrund Alpha",
        ["esES"] = "Transparencia del fondo del rastreador",
        ["esMX"] = "Transparencia del fondo del rastreador",
        ["frFR"] = "Opacité de l'arrière-plan du suivi",
        ["koKR"] = "트래커 배경 알파",
        ["ptBR"] = "Transparência do fundo do rastreador",
        ["ruRU"] = "Непрозрачность фона",
        ["zhCN"] = "背景透明度",
        ["zhTW"] = "背景透明度",
    },
    ["The alpha level of the Questie Trackers backdrop. A setting of 100 percent is fully visible."] = {
        ["enUS"] = true,
        ["deDE"] = "Das Alpha-Level des Tracker-Hintergrunds",
        ["esES"] = "La transparencia del fondo del rastreador.",
        ["esMX"] = "La transparencia del fondo del rastreador.",
        ["frFR"] = "Définis l'opacité de l'arrière-plan du suivi.",
        ["koKR"] = "트래커 배경의 알파 수준",
        ["ptBR"] = "A transparência do fundo do rastreador.",
        ["ruRU"] = "Уровень непрозрачности фона трекера",
        ["zhCN"] = "设置背景的透明度",
        ["zhTW"] = "任務清單背景的透明度，100% 是完全不透明。",
    },
    ---------------------------------------------------------
    ["Tracker Height Ratio"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker Höhenverhältnis",
        ["esES"] = "Relación de altura del rastreador",
        ["esMX"] = "Relación de altura del rastreador",
        ["frFR"] = "Ratio de hauteur du suivi",
        ["koKR"] = "추적기 높이 비율",
        ["ptBR"] = "Proporção de altura do rastreador",
        ["ruRU"] = "Соотношение высоты трекера",
        ["zhCN"] = "列表高度比例",
        ["zhTW"] = "清單高度比例",
    },
    ["The height of the Questie Tracker based on percentage of usable screen height. A setting of 100 percent would make the Tracker fill the players entire screen height.\n\nNOTE: This setting only applies while in Sizer Mode: Auto"] = {
        ["enUS"] = true,
        ["deDE"] = "Die Höhe des Questie-Trackers basierend auf dem Prozentsatz der nutzbaren Bildschirmhöhe. Eine Einstellung von 100 Prozent würde den Tracker die gesamte Bildschirmhöhe des Spielers ausfüllen lassen.\n\nHINWEIS: Diese Einstellung gilt nur im Sizer-Modus: Auto",
        ["esES"] = "La altura del rastreador se basa en el porcentaje de la altura utilizable de la pantalla. Una configuración de 100 por ciento haría que el rastreador llenará toda la altura de la pantalla del jugador.\n\nNOTA: Esta configuración solo se aplica en el Modo de medición: Automático.",
        ["esMX"] = "La altura del rastreador se basa en el porcentaje de la altura utilizable de la pantalla. Una configuración de 100 por ciento haría que el rastreador llenará toda la altura de la pantalla del jugador.\n\nNOTA: Esta configuración solo se aplica en el Modo de medición: Automático.",
        ["frFR"] = "La hauteur du suivi en pourcentage de la hauteur d'écran utilisable. Un réglage de 100 pour cent ferait remplir la hauteur de l'écran du joueur.\n\nREMARQUE : Ce réglage ne s'applique que lors du Mode de calibrage : Automatique.",
        ["koKR"] = "Questie 추적기의 높이는 실행 가능한 화면 높이의 백분율을 기준으로 설정됩니다. 100%%로 설정하면 추적기가 화면 전체 높이를 차지하게 됩니다.\n\n참고: 이 설정은 '크기 조정 모드: 자동'에서만 적용됩니다.",
        ["ptBR"] = "A altura do rastreador baseada em percentagem da altura de tela utilizável. Uma configuração de 100 por cento faria com que o rastreador preenchesse toda a altura da tela do jogador.\n\nNOTA: Esta configuração só se aplica enquanto estiver no Modo de mediçao: Automático.",
        ["ruRU"] = "Высота трекера, основанная на процентах от высоты экрана. Значение 100 заставит трекер заполнять всю высоту экрана.\n\nПРИМЕЧАНИЕ: Эта настройка работает только тогда, когда сайзер (изменитель размера трекера) в автоматическом режиме",
        ["zhCN"] = "列表高度依据可用的界面高度百分比，100%% 会让列表和界面一样高。\n\n注意：此设定只在调整大小模式为自动时有效。",
        ["zhTW"] = "清單高度依據可用的畫面高度百分比，100%% 會讓清單和畫面一樣高。\n\n注意: 此設定只在調整大小模式為自動時有效。",
    },
    ["Font Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Schriftarten",
        ["esES"] = "Opciones de fuente",
        ["esMX"] = "Opciones de fuente",
        ["frFR"] = "Options de police",
        ["koKR"] = "글꼴 옵션",
        ["ptBR"] = "Opções de fonte",
        ["ruRU"] = "Настройки шрифтов",
        ["zhCN"] = "字体选项",
        ["zhTW"] = "字體選項",
    },
    ["Quest Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest-Einstellungen",
        ["esES"] = "Opciones de misión",
        ["esMX"] = "Opciones de misión",
        ["frFR"] = "Options de quête",
        ["koKR"] = "퀘스트 옵션",
        ["ptBR"] = "Opções de missão",
        ["ruRU"] = "Настройки заданий",
        ["zhCN"] = "任务选项",
        ["zhTW"] = "任務選項",
    },
    ["Quest and Achievement Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Quest- und Erfolg-Einstellungen",
        ["esES"] = "Opciones de misión y logro",
        ["esMX"] = "Opciones de misión y logro",
        ["frFR"] = "Options des quêtes et des hauts faits",
        ["koKR"] = "퀘스트 및 업적 옵션",
        ["ptBR"] = "Opções de missões e conquistas",
        ["ruRU"] = "Настройки заданий и достижений",
        ["zhCN"] = "任务和成就选项",
        ["zhTW"] = "任務和成就選項",
    },
    ["Tracker Window Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker-Fenster-Einstellungen",
        ["esES"] = "Opciones de la ventana del rastreador",
        ["esMX"] = "Opciones de la ventana del rastreador",
        ["frFR"] = "Options de la fenêtre de suivi",
        ["koKR"] = "추적기 창 옵션",
        ["ptBR"] = "Opções da janela do rastreador",
        ["ruRU"] = "Настройки окна трекера",
        ["zhCN"] = "任务清单窗口选项",
        ["zhTW"] = "任務清單視窗選項",
    },
    ["Tracker Background"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker-Hintergrund",
        ["esES"] = "Fondo del rastreador",
        ["esMX"] = "Fondo del rastreador",
        ["frFR"] = "Arrière-plan du suivi",
        ["koKR"] = "추적기 배경",
        ["ptBR"] = "Fundo do rastreador",
        ["ruRU"] = "Фон трекера",
        ["zhCN"] = "任务清单背景",
        ["zhTW"] = "任務清單背景",
    },
    ["Tracker Header"] = {
        ["enUS"] = true,
        ["deDE"] = "Tracker-Kopfzeile",
        ["esES"] = "Encabezado del rastreador",
        ["esMX"] = "Encabezado del rastreador",
        ["frFR"] = "En-tête du suivi",
        ["koKR"] = "추적기 헤더",
        ["ptBR"] = "Cabeçalho do rastreador",
        ["ruRU"] = "Заголовок трекера",
        ["zhCN"] = "任务清单标题",
        ["zhTW"] = "任務清單標題列",
    },
}

for k, v in pairs(trackerOptionsLocales) do
    l10n.translations[k] = v
end
