---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local dbmHudOptionsLocales = {
    ["DBM HUD"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = true,
        ["esMX"] = true,
        ["frFR"] = true,
        ["koKR"] = true,
        ["ptBR"] = true,
        ["ruRU"] = true,
        ["zhCN"] = true,
        ["zhTW"] = true,
    },
    ["Show DBM HUD"] = {
        ["enUS"] = true,
        ["deDE"] = "Zeige DBM HUD",
        ["esES"] = "Mostrar DBM HUD",
        ["esMX"] = "Mostrar DBM HUD",
        ["frFR"] = "Afficher DBM HUD",
        ["koKR"] = "DBM HUD 표시",
        ["ptBR"] = "Mostrar DBM HUD",
        ["ruRU"] = "Включить DBM HUD",
        ["zhCN"] = "启用 DBM HUD",
        ["zhTW"] = "顯示 DBM HUD",
    },
    ["Enable or disable the DBM Heads Up Display (HUD) overlay for showing map objects."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert das DBM-HUD zur Anzeige von Kartenobjekten.",
        ["esES"] = "Activa o desactiva la superposición del DBM Heads Up Display (HUD) para mostrar objetos del mapa.",
        ["esMX"] = "Activa o desactiva la superposición del DBM Heads Up Display (HUD) para mostar objetos del mapa.",
        ["frFR"] = "Active ou désactive la superposition du DBM Heads Up Display (HUD) pour afficher les objets de la carte.",
        ["koKR"] = "DBM 애드온의 HUD 오버레이 기능을 사용해서 지도상의 오브젝트를 화면에 표시합니다.",
        ["ptBR"] = "Ativa ou desativa a sobreposição do DBM Heads Up Display (HUD) para mostrar objetos do mapa.",
        ["ruRU"] = "Включить/отключить DBM HUD - оверлей для отображения объектов карты",
        ["zhCN"] = "启用或停用 DBM HUD 覆盖层，以显示地图物体。",
        ["zhTW"] = "啟用或停用 DBM HUD 覆蓋層，以顯示地圖物體。",
    },
    ["Questie has activated DBM HUD overlay. For more options, visit DBM HUD tab in Questie options"] = {
        ["enUS"] = true,
        ["deDE"] = "Questie hat das DBM HUD aktiviert. Einstellungen dazu findest du in den Questie-Einstellungen im \"DBM HUD\"-Reiter.",
        ["esES"] = "Questie ha activado la superposición del DBM HUD. Para más opciones, visita la pestaña DBM HUD en las opciones de Questie.",
        ["esMX"] = "Questie ha activado la superposición del DBM HUD. Para más opciones, visita la pestaña DBM HUD en las opciones de Questie.",
        ["frFR"] = "Questie a activé la superposition du DBM HUD. Pour plus d'options, rendez-vous dans l'onglet DBM HUD dans les options de Questie.",
        ["koKR"] = "Questie가 DBM HUD 오버레이를 활성화했습니다. 더 많은 옵션을 보려면 Questie 설정의 DBM HUD 탭을 방문하세요.",
        ["ptBR"] = "O Questie ativou a sobreposição do DBM HUD. Para mais opções, acesse a aba DBM HUD nas opções de Questie.",
        ["ruRU"] = "В Questie активировано наложение DBM HUD. Для расширенных настроек посетите вкладку DBM HUD в параметрах Questie",
        ["zhCN"] = "Questie 已激活 DBM HUD 覆盖。更多选项，请前往 Questie 选项中的 DBM HUD 标签。",
        ["zhTW"] = "Questie 已啟用 DBM 畫面中顯示 (HUD) 圖層，更多選項在 Questie 設定選項的 DBM HUD 標籤頁面中。",
    },
    ["Filter Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Filteroptionen",
        ["esES"] = "Opciones de filtro",
        ["esMX"] = "Opciones de filtro",
        ["frFR"] = "Options de filtre",
        ["koKR"] = "필터 설정",
        ["ptBR"] = "Opções de filtro",
        ["ruRU"] = "Фильтр значков",
        ["zhCN"] = "过滤器选项",
        ["zhTW"] = "過濾選項",
    },
    ["Show quest giver icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Questgeber-Icons anzeigen",
        ["esES"] = "Mostrar iconos de asignadores de misiones",
        ["esMX"] = "Mostrar iconos de asignadores de misiones",
        ["frFR"] = "Afficher les icônes des donneurs de quêtes",
        ["koKR"] = "수행가능/완료 퀘스트 아이콘 표시",
        ["ptBR"] = "Mostrar ícones de recrutadores de missões",
        ["ruRU"] = "Значки заданий",
        ["zhCN"] = "显示起始任务图标",
        ["zhTW"] = "顯示任務 NPC 圖示",
    },
    ["Toggles whether or not available/complete quest icons appear on the HUD."] = {
        ["enUS"] = true,
        ["deDE"] = "Schaltet ein, ob Icons für verfügbare/abgeschlossene Quests im HUD angezeigt werden oder nicht.",
        ["esES"] = "Activa o desactiva si los iconos de misiones disponibles/completadas aparecen en el HUD.",
        ["esMX"] = "Activa o desactiva si los iconos de misiones disponibles/completadas aparecen en el HUD.",
        ["frFR"] = "Indique si les icônes de quêtes disponibles / terminées apparaissent sur le HUD.",
        ["koKR"] = "수행가능/완료 퀘스트 아이콘을 HUD에 표시합니다.",
        ["ptBR"] = "Ativa ou desativa se os ícones de missões disponíveis/concluídas aparecem no HUD.",
        ["ruRU"] = "Показать/скрыть значки доступных или выполненных заданий на HUD",
        ["zhCN"] = "切换是否在HUD上显示可用/完成任务图标。",
        ["zhTW"] = "切換 HUD 上是否要顯示可接/完成任務的圖示。",
    },
    ["Show object interact icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Objekt-Interaktions-Icons anzeigen",
        ["esES"] = "Mostrar iconos de interacción con objetos",
        ["esMX"] = "Mostrar iconos de interacción con objetos",
        ["frFR"] = "Afficher les icônes d'interaction avec les objets",
        ["koKR"] = "오브젝트 상호작용 아이콘 표시",
        ["ptBR"] = "Mostrar ícones de interação com objetos",
        ["ruRU"] = "Значки объектов",
        ["zhCN"] = "显示物件互动图标",
        ["zhTW"] = "顯示物件互動圖示",
    },
    ["Refresh rate for HUD (Requires turning HUD off/on)"] = {
        ["enUS"] = true,
        ["deDE"] = "Aktualisierungsrate für das HUD (erfordert das Ausschalten/Einschalten des HUD)",
        ["esES"] = "Frecuencia de actualización para el HUD",
        ["esMX"] = "Frecuencia de actualización para el HUD",
        ["frFR"] = "Taux de rafraîchissement pour le HUD",
        ["koKR"] = "HUD 새로고침 주기 (HUD 재시작 필요)",
        ["ptBR"] = "Taxa de atualização para o HUD",
        ["ruRU"] = "Частота обновления",
        ["zhCN"] = "HUD的刷新率（需要关闭再打开HUD）",
        ["zhTW"] = "HUD 重新整理頻率 (需要將 HUD 停用後再啟用)",
    },
    ["Adjusts the fresh rate for HUD Icons which affects how often UI refreshes their position. (Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Passt die Aktualisierungsrate für HUD-Icons an, die sich darauf auswirkt, wie oft die Benutzeroberfläche ihre Position aktualisiert. (Standard: %s)",
        ["esES"] = "Ajusta la frecuencia de actualización de los iconos del HUD que afecta la frecuencia con la que la interfaz de usuario actualiza su posición. (Predeterminado: %s)",
        ["esMX"] = "Ajusta la frecuencia de actualización de los iconos del HUD que afecta la frecuencia con la que la interfaz de usuario actualiza su posición. (Predeterminado: %s)",
        ["frFR"] = "Ajuste le taux de rafraîchissement des icônes du HUD qui affecte la fréquence à laquelle l'interface utilisateur actualise leur position. (Par défaut : %s)",
        ["koKR"] = "HUD 아이콘의 위치를 새로 표시하는 주기를 설정합니다. (기본값: %s)",
        ["ptBR"] = "Ajusta a taxa de atualização dos ícones do HUD, que afeta a frequência com que a interface do usuário atualiza sua posição. (Padrão: %s)",
        ["ruRU"] = "Регулирует частоту обновления значков DBM HUD, которая влияет на то, как часто пользовательский интерфейс обновляет их позиции (по умолчанию: %s)",
        ["zhCN"] = "调整HUD图标的刷新率，这会影响UI更新其位置的频率。（默认：%s）",
        ["zhTW"] = "調整 HUD 圖示的更新頻率，會影響介面有多頻繁更新位置。(預設值: %s)",
    },
    ["Enable proximity visual for HUD icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Näherungsvisualisierung für HUD-Icons einschalten",
        ["esES"] = "Activar visual de proximidad para los iconos del HUD",
        ["esMX"] = "Activar visual de proximidad para los iconos del HUD",
        ["frFR"] = "Activer le visuel de proximité pour les icônes du HUD",
        ["koKR"] = "근접한 HUD 아이콘 표시 활성화",
        ["ptBR"] = "Ativar visual de proximidade para ícones do HUD",
        ["ruRU"] = "Визуальное отображение близости",
        ["zhCN"] = "启用近距离视野的 HUD 图标",
        ["zhTW"] = "啟用 HUD 圖示的接近提示",
    },
    ["Adjusts the size of the icons that appear on the HUD. (Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Passt die Größe der Icons an, die auf dem HUD erscheinen. (Standard: %s)",
        ["esES"] = "Ajusta el tamaño de los iconos que aparecen en el HUD. (Predeterminado: %s)",
        ["esMX"] = "Ajusta el tamaño de los iconos que aparecen en el HUD. (Predeterminado: %s)",
        ["frFR"] = "Ajuste la taille des icônes qui apparaissent sur le HUD. (Par défaut : %s)",
        ["koKR"] = "HUD에 표시될 아이콘의 크기를 설정합니다. (기본값: %s)",
        ["ptBR"] = "Ajusta o tamanho dos ícones que aparecem no HUD. (Padrão: %s)",
        ["ruRU"] = "Регулирует размер значков, отображаемых на HUD (по умолчанию: %s)",
        ["zhCN"] = "调整HUD上显示的图标的大小。（默认：%s）",
        ["zhTW"] = "調整 HUD 上出現的圖示大小。(預設值: %s)",
    },
    ["Toggles whether or not object (gear) icons appear on the HUD."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert, ob Objekt-Icons (Zahnrad) im HUD angezeigt werden oder nicht.",
        ["esES"] = "Activa o desactiva si los iconos de objetos (engranaje) aparecen en el HUD.",
        ["esMX"] = "Activa o desactiva si los iconos de objetos (engranaje) aparecen en el HUD.",
        ["frFR"] = "Indique si les icônes d'objets (engrenage) apparaissent sur le HUD.",
        ["koKR"] = "HUD에 오브젝트(기어) 아이콘을 표시할지 여부를 전환합니다.",
        ["ptBR"] = "Ativa ou desativa se os ícones de objetos (engrenagem) aparecem no HUD.",
        ["ruRU"] = "Показать/скрыть значки объектов (шестерня) на HUD",
        ["zhCN"] = "切换是否在 HUD 上显示物件（齿轮）图标。",
        ["zhTW"] = "切換是否在 HUD 上顯示物件（齒輪）圖示。",
    },
    ["Size & Scale Options"] = {
        ["enUS"] = true,
        ["deDE"] = "Optionen für Größe und Skalierung",
        ["esES"] = "Opciones de tamaño y escala",
        ["esMX"] = "Opciones de tamaño y escala",
        ["frFR"] = "Options de taille et d'échelle",
        ["koKR"] = "크기 & 비율 설정",
        ["ptBR"] = "Opções de tamanho e escala",
        ["ruRU"] = "Параметры масштабирования и размера значков",
        ["zhCN"] = "打开大小 & 比例 选项",
        ["zhTW"] = "大小 & 縮放選項",
    },
    ["Show loot icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Beute-Icons für Quests anzeigen",
        ["esES"] = "Mostrar iconos de botín",
        ["esMX"] = "Mostrar iconos de botín",
        ["frFR"] = "Afficher les icônes de butin",
        ["koKR"] = "수집 아이콘 표시",
        ["ptBR"] = "Mostrar ícones de saque",
        ["ruRU"] = "Значки добычи",
        ["zhCN"] = "显示任务物品图标",
        ["zhTW"] = "顯示撿東西圖示",
    },
    ["Toggles whether or not loot icons appear on the HUD."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktivert die Anzeige von Beute-Icons im HUD.",
        ["esES"] = "Activa o desactiva si los iconos de botín aparecen en el HUD.",
        ["esMX"] = "Activa o desactiva si los iconos de botín aparecen en el HUD.",
        ["frFR"] = "Indique si les icônes de butin apparaissent sur le HUD.",
        ["koKR"] = "수집 아이콘을 HUD에 표시합니다.",
        ["ptBR"] = "Ativa ou desativa se os ícones de saque aparecem no HUD.",
        ["ruRU"] = "Показать/скрыть значки добычи на HUD",
        ["zhCN"] = "切换是否在HUD上显示物品图标。",
        ["zhTW"] = "切換 HUD 上是否要顯示撿東西的圖示。",
    },
    ["Global zoom level for HUD Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Globale Zoomstufe für HUD-Icons",
        ["esES"] = "Nivel de zoom global para iconos del HUD",
        ["esMX"] = "Nivel de zoom global para iconos del HUD",
        ["frFR"] = "Niveau de zoom global pour les icônes du HUD",
        ["koKR"] = "HUD 아이콘 확대 비율 전역 설정",
        ["ptBR"] = "Nível de zoom global para ícones do HUD",
        ["ruRU"] = "Масштабирование",
        ["zhCN"] = "HUD图标的全局缩放等级",
        ["zhTW"] = "HUD 圖示的整體檢視大小",
    },
    ["Changes the color of a HUD icon to red when you are near it."] = {
        ["enUS"] = true,
        ["deDE"] = "Ändert die Farbe eines HUD-Icons auf rot, wenn Sie sich in dessen Nähe befinden.",
        ["esES"] = "Cambia el color de un icono del HUD a rojo cuando estás cerca de él.",
        ["esMX"] = "Cambia el color de un icono del HUD a rojo cuando estás cerca de él.",
        ["frFR"] = "Change la couleur d'une icône du HUD en rouge lorsque vous vous en approchez.",
        ["koKR"] = "근처에 다가가면 HUD 아이콘을 빨간색으로 표시합니다.",
        ["ptBR"] = "Muda a cor de um ícone HUD para vermelho quando você está perto dele.",
        ["ruRU"] = "Изменяет цвет значка DBM HUD на красный, когда игрок находится рядом с ним",
        ["zhCN"] = "靠近HUD图标时，将其颜色更改为红色。",
        ["zhTW"] = "靠近時將 HUD 圖示變成紅色。",
    },
    ["Show slay icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Tötungs-Icons anzeigen",
        ["esES"] = "Mostrar iconos de matanza",
        ["esMX"] = "Mostrar iconos de matanza",
        ["frFR"] = "Afficher les icônes de tuerie",
        ["koKR"] = "처치 아이콘 표시",
        ["ptBR"] = "Mostrar ícones de matança",
        ["ruRU"] = "Значки убийств",
        ["zhCN"] = "显示任务需要击杀图标",
        ["zhTW"] = "顯示殺怪圖示",
    },
    ["Toggles whether or not slay icons appear on the HUD."] = {
        ["enUS"] = true,
        ["deDE"] = "Aktiviert/Deaktiviert die Anzeige von Tötungs-Icons im HUD.",
        ["esES"] = "Activa o desactiva si los iconos de matanza aparecen en el HUD.",
        ["esMX"] = "Activa o desactiva si los iconos de matanza aparecen en el HUD.",
        ["frFR"] = "Indique si les icônes de tuerie apparaissent sur le HUD.",
        ["koKR"] = "처치 아이콘을 HUD에 표시합니다.",
        ["ptBR"] = "Ativa ou desativa se os ícones de matança aparecem no HUD.",
        ["ruRU"] = "Показать/скрыть значки убийств на HUD",
        ["zhCN"] = "切换是否在HUD上显示击杀目标的图标。",
        ["zhTW"] = "切換 HUD 上是否要顯示殺怪的圖示。",
    },
    ["Global radius/size for HUD Icons"] = {
        ["enUS"] = true,
        ["deDE"] = "Globaler Radius/Größe für HUD-Icons",
        ["esES"] = "Radio/tamaño global para iconos del HUD",
        ["esMX"] = "Radio/tamaño global para iconos del HUD",
        ["frFR"] = "Rayon / taille global pour les icônes du HUD",
        ["koKR"] = "HUD 아이콘 크기 전역 설정",
        ["ptBR"] = "Raio/tamanho global para ícones do HUD",
        ["ruRU"] = "Размер",
        ["zhCN"] = "HUD图标的全局半径/大小",
        ["zhTW"] = "HUD 圖示的整體半徑/大小",
    },
    ["Adjusts the zoom level for HUD Icons which affects how close in or how far out you see them. (Default: %s)"] = {
        ["enUS"] = true,
        ["deDE"] = "Stellt die Zoomstufe für HUD-Icons ein, die beeinflusst, wie nah oder wie weit entfernt sie zu sehen sind. (Standard: %s)",
        ["esES"] = "Ajusta el nivel de zoom para los iconos del HUD, lo que afecta la proximidad o la distancia a la que los ves. (Predeterminado: %s)",
        ["esMX"] = "Ajusta el nivel de zoom para los iconos del HUD, lo que afecta la proximidad o la distancia a la que los ves. (Predeterminado: %s)",
        ["frFR"] = "Ajuste le niveau de zoom des icônes du HUD qui affecte la distance à laquelle vous les voyez. (Par défaut : %s)",
        ["koKR"] = "가까운 거리면 커지고 먼 거리면 작아지는 HUD 아이콘의 확대 비율을 설정합니다. (기본값: %s)",
        ["ptBR"] = "Ajusta o nível de zoom dos ícones HUD, o que afeta a proximidade ou a distância que você os vê. (Padrão: %s)",
        ["ruRU"] = "Регулирует уровень масштабирования для значков DBM HUD, который влияет на то, как близко или как далеко вы видите их (по умолчанию: %s)",
        ["zhCN"] = "调整HUD图标的缩放级别，这会影响您看到它们的接近程度或远近程度。（默认：%s）",
        ["zhTW"] = "調整 HUD 圖示的檢視大小，會影響你看到它們的遠近程度。(預設值: %s)",
    },
    ["The DBM HUD integrates with the addon DeadlyBossMods to show a radar of objective icons on your entire screen. Enabling this feature usually requires a /reload to take effect."] = {
        ["enUS"] = true,
        ["deDE"] = "Das DBM-HUD integriert sich in dem Addon DeadlyBossMods, um ein Radar mit Quest-Icons auf dem gesamten Bildschirm anzuzeigen. Die Aktivierung dieser Funktion erfordert normalerweise ein /reload",
        ["esES"] = "El DBM HUD se integra con el addon DeadlyBossMods para mostrar un radar de iconos de objetivos en toda la pantalla. Activar esta función generalmente requiere recargar la interfaz para que tenga efecto.",
        ["esMX"] = "El DBM HUD se integra con el addon DeadlyBossMods para mostrar un radar de iconos de objetivos en toda la pantalla. Activar esta función generalmente requiere recargar la interfaz para que tenga efecto.",
        ["frFR"] = "Le DBM HUD s'intègre avec l'add-on DeadlyBossMods pour afficher un radar d'icônes d'objectifs sur l'ensemble de votre écran. Activer cette fonctionnalité nécessite généralement de recharger l'interface pour prendre effet.",
        ["koKR"] = "DBM HUD는 애드온 DeadlyBossMods와 통합되어 전체 화면에 목표 아이콘의 레이더를 표시합니다. 이 기능을 활성화시키기 위해 /reload가 필요합니다.",
        ["ptBR"] = "O DBM HUD se integra ao addon DeadlyBossMods para mostrar um radar de ícones de objetivos em toda a tela. Ativar esse recurso geralmente requer recarregar a interface para ter efeito.",
        ["ruRU"] = "Оверлей DBM HUD интегрируется с аддоном DeadlyBossMods для отображения на вашем экране радара со значками целей. После включения настройки желательно перезагрузить интерфейс командой /reload",
        ["zhCN"] = "DBM HUD 与 DeadlyBossMods 插件集成，可在整个屏幕上显示目标图标雷达。启用此功能通常需要 /reload 才能生效。",
        ["zhTW"] = "DBM HUD 與 DeadlyBossMods 插件整合，可在整個螢幕上顯示目標圖示雷達。啟用此功能通常需要 /reload 才能生效。",
    },
}

for k, v in pairs(dbmHudOptionsLocales) do
    l10n.translations[k] = v
end
