---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local classicObjectiveLocales = {
    ["Summon Dagun the Ravenous using an Enchanted Sea Kelp"] = { -- 735 736
        ["enUS"] = true,
        ["deDE"] = "Verzauberten Seetang benutzen, um Dagun den Gefräßigen zu beschwören",
        ["esES"] = "Invoca a Dagun el Voraz usando un Kelp marino encantado",
        ["esMX"] = "Invoca a Dagun el Voraz usando una Alga marina encantada",
        ["frFR"] = "Invoquez Dagun le Vorace en utilisant un Varech Énchanté",
        ["koKR"] = "마법의 해조를 사용하여 포악한 다군을 소환",
        ["ptBR"] = "Evoca Dagun, o Voraz, usando uma Alga Marinha Encantada",
        ["ruRU"] = "Призовите Дагун Ненасытный используя Зачарованные морские водоросли",
        ["zhCN"] = false,
        ["zhTW"] = "使用附魔海藻召喚貪婪的達古恩",
    },
    ["Use a Fresh Carcass at the Flame of Uzel"] = { -- 1136
        ["enUS"] = true,
        ["deDE"] = "Einen frischen Kadaver an der Flamme von Uzel verbrennen",
        ["esES"] = "Deja el Cadáver fresco sobre la Llama de Uzel",
        ["esMX"] = "Deja el Cadáver reciente sobre la Llama de Uzel",
        ["frFR"] = "Placez la Carcasse fraîche sur la Flamme d'Uzel",
        ["koKR"] = "우젤의 불꽃에서 방금 죽은 사자 시체를 사용하세요",
        ["ptBR"] = "Coloque a Carcaça Fresca sobre a Chama de Uzel",
        ["ruRU"] = "Используйте Свежую Тушу в Пламени Узеля",
        ["zhCN"] = false,
        ["zhTW"] = "在尤基爾之焰使用新鮮的屍體",
    },
    ["Fish for Darkshore Groupers"] = { -- 1141
        ["enUS"] = true,
        ["deDE"] = "Dunkelküstenbarsche angeln",
        ["esES"] = "Pesca Meros de Costa Oscura",
        ["esMX"] = "Pesca Meros de Costa Oscura",
        ["frFR"] = "Pêchez des Mérous de Sombrerivage",
        ["koKR"] = "낚시를 통해 어둠의해안 농어를 획득하세요",
        ["ptBR"] = "Pesca Garoupas da Costa Negra",
        ["ruRU"] = "Выловите Окунь с Темных берегов",
        ["zhCN"] = false,
        ["zhTW"] = "釣魚取得黑海岸石斑魚",
    },
    ["Slay Gelkis centaur to increase your reputation with the Magram Clan"] = { -- 1367
        ["enUS"] = true,
        ["deDE"] = "Töte Gelkis-Zentauren, um Ansehen beim Magram-Clan zu erhöhen",
        ["esES"] = "Mata al centauro Gelkis para aumentar tu reputación con el clan Magram",
        ["esMX"] = "Mata al centauro Gelkis para aumentar tu reputación con el clan Magram",
        ["frFR"] = "Tuez des centaures Gelkis pour augmenter votre réputation auprès du Clan Magram",
        ["koKR"] = "마그람일족의 평판 획득을 위해 겔키스 켄타우로스를 사냥하세요",
        ["ptBR"] = "Mata centauros Gelkis para aumentar sua reputação com o Clã dos Centauros Magram",
        ["ruRU"] = "Убейте кентавра из племени Гелкис, чтобы поднять свою репутацию с племенем Маграм",
        ["zhCN"] = false,
        ["zhTW"] = "殺死吉爾吉斯半人馬來提高你在瑪格拉姆氏族中的聲望",
    },
    ["Slay Magram centaur to increase your reputation with the Gelkis Clan"] = { -- 1368
        ["enUS"] = true,
        ["deDE"] = "Töte Magram-Zentauren, um dein Ansehen beim Gelkis-Clan zu erhöhen",
        ["esES"] = "Mata al centauro Magram para aumentar tu reputación con el Clan Gelkis",
        ["esMX"] = "Mata al centauro Magram para aumentar tu reputación con el Clan Gelkis",
        ["frFR"] = "Tuez des centaures Magram pour augmenter votre réputation auprès du Clan Gelkis",
        ["koKR"] = "겔키스일족의 평판 획득을 위해 마그람 켄타우로스를 사냥하세요",
        ["ptBR"] = "Mata centauros Magram para aumentar sua reputação com o Clã dos Centauros Gelkis",
        ["ruRU"] = "Убейте кентавра из племени Маграм, чтобы поднять свою репутацию с племенем Гелкис",
        ["zhCN"] = false,
        ["zhTW"] = "殺死瑪格拉姆半人馬來提高你在吉爾吉斯氏族中的聲望",
    },
    ["Use the War Horn Mouthpiece to summon Khan Hratha"] = { -- 1380 1381
        ["enUS"] = true,
        ["deDE"] = "Kriegshornmundstück benutzen, um Khan Hratha zu rufen",
        ["esES"] = "Usa la Boquilla del cuerno de guerra para invocar a Khan Hratha",
        ["esMX"] = "Usa la Boquilla del cuerno de guerra para invocar a Khan Hratha",
        ["frFR"] = "Utilisez l'Embouchure de Cor de Guerre pour invoquer Khan Hratha",
        ["koKR"] = "전쟁 뿔피리 파이프를 사용하여 칸 흐라사를 소환하세요",
        ["ptBR"] = "Usa a Boquilha da Corneta de Guerra para evocar Khan Hratha",
        ["ruRU"] = "Используйте Загубник боевого горна, чтобы призвать Вождя Храта",
        ["zhCN"] = false,
        ["zhTW"] = "使用半人馬號角哨嘴召喚赫蘭薩可汗",
    },
    ["Fish for Gaffer Jacks"] = { -- 1579
        ["enUS"] = true,
        ["deDE"] = "Klemm-Muffen angeln",
        ["esES"] = "Pesca Mecanismos eléctricos",
        ["esMX"] = "Pesca Mecanismos eléctricos",
        ["frFR"] = "Pêchez des Rouages Électriques",
        ["koKR"] = "낚시로 개퍼 잭을 획득하세요",
        ["ptBR"] = "Pesca Deschanfradores",
        ["ruRU"] = "Выловите Суперразъемы",
        ["zhCN"] = false,
        ["zhTW"] = "釣魚取得小齒輪",
    },
    ["Fish for Electropellers"] = { -- 1580
        ["enUS"] = true,
        ["deDE"] = "Elektropeller angeln",
        ["esES"] = "Pesca electromuelles",
        ["esMX"] = "Pesca electromuelles",
        ["frFR"] = "Pêchez des Électropellers",
        ["koKR"] = "낚시로 전력추진기를 획득하세요",
        ["ptBR"] = "Pesca Eletromolas",
        ["ruRU"] = "Выловите Электропеллеры",
        ["zhCN"] = false,
        ["zhTW"] = "釣魚取得導電器",
    },
    ["Use Cantation of Manifestation to reveal Rift Spawn. Use Chest of Containment Coffers on stunned Rift Spawn"] = { -- 1920 & 1960
        ["enUS"] = true,
        ["deDE"] = "Benutze die Kantate der Manifestation, um den Rift-Spawn zu enthüllen. Verwende Truhe der Eindämmungskassen am betäubtem Rift-Spawn.",
        ["esES"] = "Usa el Canto de Manifestación para revelar Cría del risco. Crea un arca de contención sobre una cría del risco aturdida.",
        ["esMX"] = "Usa el Canto de Manifestación para revelar Cría del risco. Crea un arca de contención sobre una cría del risco aturdida.",
        ["frFR"] = "Utilisez un Chant de Manifestation pour révéler le Rejeton de la Faille. Utilisez une Caisse de coffres de stockage sur le Rejeton de la Faille.",
        ["koKR"] = "현신의 주문서를 사용하여 균열의 정령을 찾으세요. 스턴 상태의 균열의 정령에게 속박의 상자를 사용하세요",
        ["ptBR"] = "Usa o Cantochão da Manifestação para revelar Aparição Etérea. Crie um cofre de contenção em uma Aparição Etérea atordoada.",
        ["ruRU"] = "Используйте Свиток заклятия Проявления, чтобы увидеть Порождение Разлома. Используйте Ящик со шкатулками-духоловками на ошеломленное Порождение Разлома",
        ["zhCN"] = false,
        ["zhTW"] = "使用顯形卷軸讓裂隙怒靈顯示出來，對暈住的裂隙怒靈使用封靈箱。",
    },
    ["Step 1: obtain the Yellow Punch Card. You need the White Punch Card."] = { -- 2930
        ["enUS"] = true,
        ["deDE"] = "Schritt 1: Erhalte die gelbe Lochkarte. Weiße Lochkarte wird benötigt.",
        ["esES"] = "Paso 1: Obtén la tarjeta perforada amarilla. Necesitas la tarjeta perforada blanca.",
        ["esMX"] = "Paso 1: Obtén la tarjeta perforada amarilla. Necesitas la tarjeta perforada blanca.",
        ["frFR"] = "Étape 1 : Obtenez la Carte Perforée Jaune. Vous aurez besoin de la Carte Perforée Blanche.",
        ["koKR"] = "1 단계: 황색 천공 카드를 획득하세요. 백색 천공 카드가 필요합니다",
        ["ptBR"] = "Passo 1: Obtenha o Cartão Perfurado Amarelo. Você precisa do Cartão Perfurado Branco.",
        ["ruRU"] = "Шаг 1: получите Желтую перфокарту. Вам нужна Белая перфокарта.",
        ["zhCN"] = false,
        ["zhTW"] = "步驟 1: 取得黃色穿孔卡片，需要白色穿孔卡片。",
    },
    ["Step 2: obtain the Blue Punch Card. You need the Yellow Punch Card."] = { -- 2930
        ["enUS"] = true,
        ["deDE"] = "Schritt 2: Erhalte die blaue Lochkarte. Gelbe Lochkarte wird benötigt.",
        ["esES"] = "Paso 2: Obtén la tarjeta perforada azul. Necesitas la tarjeta perforada amarilla.",
        ["esMX"] = "Paso 2: Obtén la tarjeta perforada azul. Necesitas la tarjeta perforada amarilla.",
        ["frFR"] = "Étape 2 : Obtenez la Carte Perforée Bleue. Vous aurez besoin de la Carte Perforée Jaune.",
        ["koKR"] = "2 단계: 청색 천공 카드를 획득하세요. 황색 천공 카드가 필요합니다",
        ["ptBR"] = "Passo 2: Obtenha o Cartão Perfurado Azul. Você precisa do Cartão Perfurado Amarelo.",
        ["ruRU"] = "Шаг 2: получите Синюю перфокарту. Вам нужна Желтая перфокарта.",
        ["zhCN"] = false,
        ["zhTW"] = "步驟 2: 取得藍色穿孔卡片，需要黃色穿孔卡片。",
    },
    ["Step 3: obtain the Red Punch Card. You need the Blue Punch Card."] = { -- 2930
        ["enUS"] = true,
        ["deDE"] = "Schritt 3: Erhalte die rote Stempelkarte. Blaue Lochkarte wird benötigt.",
        ["esES"] = "Paso 3: Obtén la tarjeta perforada roja. Necesitas la tarjeta perforada azul.",
        ["esMX"] = "Paso 3: Obtén la tarjeta perforada roja. Necesitas la tarjeta perforada azul.",
        ["frFR"] = "Étape 3 : Obtenez la Carte Perforée Rouge. Vous aurez besoin de la Carte de Carte Perforée Bleue.",
        ["koKR"] = "3 단계: 적색 천공 카드를 획득하세요. 청색 천공 카드가 필요합니다",
        ["ptBR"] = "Passo 3: Obtenha o Cartão Perfurado Vermelho. Você precisa do Cartão Perfurado Azul.",
        ["ruRU"] = "Шаг 3: получите Красную перфокарту. Вам нужна Синяя перфокарта.",
        ["zhCN"] = false,
        ["zhTW"] = "步驟 3: 取得紅色穿孔卡片，需要藍色穿孔卡片。",
    },
    ["Step 4: obtain the Prismatic Punch Card. You need the Red Punch Card."] = { -- 2930
        ["enUS"] = true,
        ["deDE"] = "Schritt 4: Erhalte die prismatische Lochkarte. Rote Lochkarte wird benötigt.",
        ["esES"] = "Paso 4: Obtén la tarjeta perforada prismática. Necesitas la tarjeta perforada roja.",
        ["esMX"] = "Paso 4: Obtén la tarjeta perforada prismática. Necesitas la tarjeta perforada roja.",
        ["frFR"] = "Étape 4 : Obtenez la Carte Perforée Prismatique. Vous aurez besoin de la Carte Perforée Rouge.",
        ["koKR"] = "Step 4: 오색 천공 카드를 획득하세요. 적색 천공 카드가 필요합니다",
        ["ptBR"] = "Passo 4: Obtenha o Cartão Perfurado Prismático. Você precisa do Cartão Perfurado Vermelho.",
        ["ruRU"] = "Шаг 4: получите Призматическую перфокарту. Вам нужна Красная перфокарта.",
        ["zhCN"] = false,
        ["zhTW"] = "步驟 4: 取得稜彩穿孔卡片，需要紅色穿孔卡片。",
    },
    ["Slay Vale Screechers and use Yeh'kinya's Bramble on their corpse."] = { -- 3520
        ["enUS"] = true,
        ["deDE"] = "Erschlagt Wilde Talkreischer und benutzt dann Yeh'kinyas Dornbusch auf ihren Körpern",
        ["esES"] = "Mata a Estridadores del valle y usa la Zarza de Yeh'kinya en su cadáver",
        ["esMX"] = "Mata a Estridadores del valle y usa la Zarza de Yeh'kinya en su cadáver",
        ["frFR"] = "Tuez les Hurleurs des Vallées et utilisez la Ronce de Yeh'kinya sur leurs corps",
        ["koKR"] = "계곡 천둥매 처치 후 예킨야의 나뭇가지를 천둥매 시체에 사용하세요",
        ["ptBR"] = "Mata os Guinchadores do Vale e use a Morácea de Yeh'Kinya em seu cadáver",
        ["ruRU"] = "Убейте Норовистого дольного крикуна, а затем используйте Колючку Йе'киньи на его трупе.",
        ["zhCN"] = false,
        ["zhTW"] = "殺死山谷尖嘯者，對屍體使用葉基亞的樹枝。",
    },
    ["Use the Ward of the Defiler to summon Razelikh."] = { -- 3628
        ["enUS"] = true,
        ["deDE"] = "Zauberschutz der Entweihten benutzen, um Razelikh zu beschwören",
        ["esES"] = "Usa el Amuleto del Rapiñador para invocar a Razelikh el Rapiñador",
        ["esMX"] = "Usa el Amuleto del Rapiñador para invocar a Razelikh el Rapiñador",
        ["frFR"] = "Utilisez l'Amulette du Souilleur pour invoquer Razelikh le Souilleur",
        ["koKR"] = "파멸자의 수호물을 사용하여 파멸자 라젤리크를 소환하세요",
        ["ptBR"] = "Usa o Proteção do Profanador para evocar Razelikh, o Profanador",
        ["ruRU"] = "Используйте Оберег Осквернителя, чтобы призвать Разелиха.",
        ["zhCN"] = false,
        ["zhTW"] = "使用污染者防護結界召喚拉瑟萊克。",
    },
    ["Teleport to the top of the mountain."] = { -- 3628
        ["enUS"] = true,
        ["deDE"] = "Zur Bergspitze teleportieren",
        ["esES"] = "Teletransportarse a la cima de la montaña",
        ["esMX"] = "Teletransportarse a la cima de la montaña",
        ["frFR"] = "Téléportez-vous en haut de la montagne",
        ["koKR"] = "산 꼭대기로 텔레포트 하세요",
        ["ptBR"] = "Teleporta-se para o topo da montanha",
        ["ruRU"] = "Телепортируйтесь на вершину горы.",
        ["zhCN"] = false,
        ["zhTW"] = "傳送到山頂。",
    },
    ["Place the Bait in front of Miblon Snarltooth."] = { -- 3909
        ["enUS"] = true,
        ["deDE"] = "Den Köder vor Miblon Fletschmaul legen",
        ["esES"] = "Deja el cebo cerca de Miblon Gruñedientes",
        ["esMX"] = "Deja el cebo cerca de Miblon Gruñediente",
        ["frFR"] = "Placez l'appât devant Miblon Grondequenotte",
        ["koKR"] = "미블론 스날투스 앞에 미끼를 두세요",
        ["ptBR"] = "Coloque a isca na frente de Miblon Rosnadente",
        ["ruRU"] = "Разместите Приманку перед Миблон Рыкозубом.",
        ["zhCN"] = false,
        ["zhTW"] = "將誘餌放在米布隆·亂齒面前。",
    },
    ["Hold off Kolkar invaders until Warlord Krom'zar spawns and then loot the banner spawned on his corpse."] = { -- 4021
        ["enUS"] = true,
        ["deDE"] = false,
        ["esES"] = "Mata a los invasores Kolkar hasta que aparezca el Señor de la Guerra Krom'zar, y luego recoge el estandarte que aparece en su cadáver",
        ["esMX"] = "Mata a los invasores Kolkar hasta que aparezca el Señor de la Guerra Krom'zar, y luego recoge el estandarte que aparece en su cadáver",
        ["frFR"] = "Tuez les envahisseurs Kolkar jusqu'à ce que le Chef de guerre Krom'zar apparaisse, puis récupérez la bannière qui apparaît sur son cadavre",
        ["koKR"] = "콜카르 침입자를 무찌르고, 콜가르 일족의 워로드 크롬자드를 처치 한 뒤 그의 시체로부터 나오는 깃발을 획득하세요",
        ["ptBR"] = "Mata os invasores Kolkar até que o Senhor da Guerra Krom'zar apareça e, em seguida, saqueie o estandarte que surge em seu cadáver",
        ["ruRU"] = "Убивайте захватчиков из племени Колкар, пока не появится предводитель Кром'зар, а затем заберите знамя с его трупа.",
        ["zhCN"] = false,
        ["zhTW"] = "阻擋科卡爾入侵者直到督軍克羅姆札出現，然後拾取他屍體上生成的旗幟。",
    },
    ["Use the Altered Black Dragonflight Molt on Bael'gar's corpse."] = { -- 4024
        ["enUS"] = true,
        ["deDE"] = "Benutze die veränderte Haut des schwarzen Drachenschwarms mit Bael'Gar's Leichnam",
        ["esES"] = "Usa la Muda de piel de vuelo negro alterada en los restos de Bael'Gar",
        ["esMX"] = "Usa la Muda de piel de vuelo negro alterada en los restos de Bael'Gar",
        ["frFR"] = "Utilisez le Cuir de dragon noir altéré sur le corps de Bael'gar",
        ["koKR"] = "밸가르 시체 위에서 변형된 검은용군단 허물을 사용하세요",
        ["ptBR"] = "Usa a Muda de Pele Alterada da Revoada Negra nos restos de Bael'Gar",
        ["ruRU"] = "Используйте Измененную сброшенную шкуру черного дракона на трупе Бейл'Гора.",
        ["zhCN"] = false,
        ["zhTW"] = "對貝爾加的屍體使用變化後的黑龍軍團之皮。",
    },
    ["Use the Gorishi Queen Lure."] = { -- 4507
        ["enUS"] = true,
        ["deDE"] = "Benutze den Köder für die Gorishischwarmkönigin",
        ["esES"] = "Usa el Cebo de reina Gorishi.",
        ["esMX"] = "Usa el Cebo de la reina Gorishi",
        ["frFR"] = "Utilisez l'Appât de Reine Gorishi",
        ["koKR"] = "여왕 고리쉬 미끼를 사용하세요",
        ["ptBR"] = "Usa a Isca para a Rainha Gorishi",
        ["ruRU"] = "Используйте Приманку для королевы Гориши.",
        ["zhCN"] = false,
        ["zhTW"] = "使用格里什皇后誘引劑。",
    },
    ["Collect eggs using the Collectronic Module."] = { -- 4735
        ["enUS"] = true,
        ["deDE"] = "Sammle Eier mit dem Kollektronischen Modul",
        ["esES"] = "Recoge huevos con el Módulo colectrónico",
        ["esMX"] = "Recoge huevos con el Módulo colectrónico",
        ["frFR"] = "Collectez les œufs en utilisant le Module Collectronique",
        ["koKR"] = "수집전자 모듈을 사용하여 용의 알을 수집하세요",
        ["ptBR"] = "Coleta ovos usando o Módulo Colectrônico",
        ["ruRU"] = "Соберите яйца используя Устройство-коллекционер.",
        ["zhCN"] = false,
        ["zhTW"] = "使用電動採集模組收集蛋",
    },
    ["Summon Xabraxxis once you have the required items from the Blackwood Stores."] = { -- 4763
        ["enUS"] = true,
        ["deDE"] = "Beschwöre Xabraxxis sobald Ihr die benötigten Gegenstände von den Lager der Schwarzfelle habt",
        ["esES"] = "Invoca a Xabraxxis una vez que tengas los objetos necesarios de las Provisiones del Bosque Negro",
        ["esMX"] = "Invoca a Xabraxxis una vez que tengas los objetos necesarios de las Provisiones del Bosque Negro",
        ["frFR"] = "Invoquez Xabraxxis une fois que vous aurez les objets nécessaires des Réserves des Noirbois",
        ["koKR"] = "검은나무일족 곡식 저장고에서 사브라시스 소환에 필요한 아이템을 모두 모았다면 소환 의식을 진행하세요",
        ["ptBR"] = "Evoca Xabraxxis assim que você tiver os itens necessários das Reservas de Bosquenero",
        ["ruRU"] = "Призовите Забраксис, когда у вас будут необходимые предметы из Зернохранилищ.",
        ["zhCN"] = false,
        ["zhTW"] = "從黑木商店獲得所需物品後，即可召喚薩巴克希斯。",
    },
    ["Use the Flames of the Black Flight over it to create the Seal."] = { -- 4743
        ["enUS"] = true,
        ["deDE"] = "Flammen des schwarzen Drachenschwarms benutzen, um das Siegel zu erstellen",
        ["esES"] = "Usa las Llamas del Vuelo Negro sobre él para crear el Sello",
        ["esMX"] = "Usa las Llamas del Vuelo Negro sobre él para crear el Sello",
        ["frFR"] = "Utilisez dessus les Flammes des Dragons Noirs pour créer le Sceau",
        ["koKR"] = "인장을 만들기 위해 검은용군단의 불길을 시전하세요",
        ["ptBR"] = "Lance as Chamas da Revoada Negra sobre ele para criar o Selo",
        ["ruRU"] = "Используйте Пламя Черного дракона над ним, чтобы создать Печать.",
        ["zhCN"] = false,
        ["zhTW"] = "使用黑龍之焰來建立封印。",
    },
    ["Beat Emberstrife till his will is broken, then place the Unforged Seal of Ascension before him and use the Orb of Draconic Energy."] = { -- 4743
        ["enUS"] = true,
        ["deDE"] = "Kämpfe mit Aschenschwinge, bis sein Wille gebrochen ist, platziere dann das Ungeschmiedete Siegel des Aufstiegs vor ihm und benutze den Orb der Drakonischen Energie",
        ["esES"] = "Encuentra al anciano draco Brasaliza y derrótalo sin contemplaciones hasta doblegar su voluntad. Este es el preciso momento en el que debes colocar el Sello de ascensión sin forjar ante la colosal bestia y usa el orbe de energía dracónica",
        ["esMX"] = "Encuentra al anciano draco Brasaliza y derrótalo sin contemplaciones hasta doblegar su voluntad. Este es el preciso momento en el que debes colocar el Sello de ascensión sin forjar ante la colosal bestia y usa el orbe de energía dracónica",
        ["frFR"] = "Combattez Brandeguerre jusqu'à ce que sa volonté soit brisée, puis placez le Sceau d'Ascension Brut avant lui et utilisez l'Orbe d'Énergie Draconique",
        ["koKR"] = "엠버스트라이프를 의지가 꺾일 때 까지 때린 후, 벼려지지 않은 승천의 인장을 엠버스트라이프 앞에 놓으세요. 그 후, 용력의 보주를 사용하여 엠버스트라이프의 정신을 제압하세요",
        ["ptBR"] = "Encontre o draco ancião Ardeluta e ataque-o sem misericórdia até que sua vontade seja quebrada. É nesse momento que você deve colocar o Selo da Ascensão de Metal Bruto em frente a essa fera imponente para usar o Orbe de Energia Dracônica",
        ["ruRU"] = "Победите Огнебора, пока его воля не сломлена, затем поместите Заготовку печати Вознесения перед ним, после чего используйте Сферу энергии дракона.",
        ["zhCN"] = false,
        ["zhTW"] = "擊敗艾博斯塔夫直到他失去意志，然後將未鑄造的晉升徽印放在他面前並使用龍力寶珠。",
    },
    ["Lure the Kodos to Smeed Scrabblescrew."] = { -- 5561
        ["enUS"] = true,
        ["deDE"] = "Führe die Kodos zu Smeed Scrabblescrew",
        ["esES"] = "Atrae a los kodos hacia Smeed Mezclatornillos",
        ["esMX"] = "Atrae a los kodos hacia Smeed Mezclatornillos",
        ["frFR"] = "Attirez les kodos vers Smeed Scrabblescrew",
        ["koKR"] = "코도를 유인하여 스미드 스크래블스크류에게 데려가세요",
        ["ptBR"] = "Atrai os kodos para Smid Rabiscafuso",
        ["ruRU"] = "Приманите Кодо к Смиду Заржавень.",
        ["zhCN"] = false,
        ["zhTW"] = "將科多獸引誘至斯米德·瑟卡布斯庫。",
    },
    ["Summon Lord Kragaru"] = { -- 6027
        ["enUS"] = true,
        ["deDE"] = "Lord Kragaru beschwören",
        ["esES"] = "Invoca a Lord Kragaru",
        ["esMX"] = "Invoca a Lord Kragaru",
        ["frFR"] = "Invoquez Seigneur Kragaru",
        ["koKR"] = "군주 크라가루를 소환하세요",
        ["ptBR"] = "Evoca Lorde Kragero",
        ["ruRU"] = "Призовите Лорда Крагару",
        ["zhCN"] = false,
        ["zhTW"] = "召喚柯拉加魯領主",
    },
    ["Place the Crate of Ghost Magnets"] = { -- 6134
        ["enUS"] = true,
        ["deDE"] = "Platziere die Kiste mit Geistermagneten",
        ["esES"] = "Deja el Cajón de imanes fantasmales",
        ["esMX"] = "Deja el Cajón de imanes fantasmales",
        ["frFR"] = "Placez la Caisse d'Aimants Fantômes",
        ["koKR"] = "유령 유인기 상자를 설치하세요",
        ["ptBR"] = "Coloque o Caixote de Ímãs Fantasmais",
        ["ruRU"] = "Разместите Ящик с призрачным магнитом",
        ["zhCN"] = false,
        ["zhTW"] = "放置鬼魂磁鐵木箱",
    },
    ["Use the Lovers' Hearts to summon an Incubus and slay it."] = { -- 65597
        ["enUS"] = true,
        ["deDE"] = "Benutzt die Herzen der Liebenden um den Inkubus zu beschwören und zu erschlagen",
        ["esES"] = "Usa los Corazones de amantes a invocar un íncubo y mátalo",
        ["esMX"] = "Usa los Corazones de amantes a invocar un íncubo y mátalo",
        ["frFR"] = "Utlisez les Cœurs des Amants pour invoquer un Incubus et tuez-le",
        ["koKR"] = "연인의 심장을 사용하여 인큐버스를 소환한 후 죽이세요",
        ["ptBR"] = "Use os Corações dos Amantes para evocar um Íncubo e abatê-lo",
        ["ruRU"] = "Используйте Сердца влюбленных, чтобы призвать Суккуба и убить его.",
        ["zhCN"] = false,
        ["zhTW"] = "使用戀人的心召喚夢魔並殺死它。",
    },
    ["Light the Unlit Torch near a fire and use the Burning Torch to set the Archaeologist's Cart on fire."] = { -- 65602
        ["enUS"] = true,
        ["deDE"] = "Entzünde die Fackel an einem Feuer und nutze die brennende Fackel um die Lore des Archeologen Cart in brand zu stecken",
        ["esES"] = "Enciende la Antorcha apagada cerca del fuego y usa la Antorcha encendida para prender fuego al carretón del arqueólogo",
        ["esMX"] = "Enciende la Antorcha apagada cerca del fuego y usa la Antorcha encendida para prender fuego al carretón del arqueólogo",
        ["frFR"] = "Allumez la Torche Éteinte près d'un feu et utilisez la Torche Ardente pour mettre le feu à la Carte de l'Archéologue",
        ["koKR"] = "불가 근처에서 불을 붙이지 않은 횃불에 불을 붙인 후, 불타는 횃불을 사용하여 고고학자의 수레에 불을 붙이세요",
        ["ptBR"] = "Acenda a Tocha Apagada perto de um fogo e use a Tocha Acesa para incendiar o Carrinho do Arqueólogo",
        ["ruRU"] = "Зажгите Незажженный факел с помощью огня, затем используйте Зажженный Факел чтобы поджечь Телегу Археолога.",
        ["zhCN"] = false,
        ["zhTW"] = "靠近火點燃未點燃的火把，然後使用燃燒的火把點燃考古學家的車。",
    },
    ["Use the Withered Scarf to summon an Incubus and slay it."] = { -- 65603 & 65604
        ["enUS"] = true,
        ["deDE"] = "Benutzt den abgetragener Schal um den Inkubus zu beschwören und erschlagt ihn",
        ["esES"] = "Usa un Pañuelo deshilachado para invocar a un íncubo y mátalo",
        ["esMX"] = "Usa un Pañuelo deshilachado para invocar a un íncubo y mátalo",
        ["frFR"] = "Utilisez l'Écharpe Flétrie pour invoquer un Incubus et tuez-le",
        ["koKR"] = "너덜너덜한 목도리를 사용하여 인큐버스를 소환 후 죽이세요",
        ["ptBR"] = "Use o Lenço Fenecido para evocar um Íncubo e abatê-lo",
        ["ruRU"] = "Используйте Истлевший платок, чтобы призвать Суккуба и убить его.",
        ["zhCN"] = false,
        ["zhTW"] = "使用乾癟的圍巾召喚夢魔並殺死它。",
    },
    ["Slay ghouls to free Darrowshire spirits"] = { -- 5211
        ["enUS"] = true,
        ["deDE"] = "Erschlagt die Ghoule um die Geist von Darrowshire freizulassen",
        ["esES"] = "Mata necrófagos para liberar a los Espíritus de Villa Darrow",
        ["esMX"] = "Mata necrófagos para liberar a los Espíritus de Villa Darrow",
        ["frFR"] = "Combattez les goules pour libérer les Esprits de Darrowshire",
        ["koKR"] = "구울을 처치해 다로우샤이어 영혼에게 자유를 선사하세요",
        ["ptBR"] = "Matar carniçais para libertar os Espíritos da Vila das Flechas",
        ["ruRU"] = "Убейте Вурдалаков, чтобы освободить Духов Дарроушира",
        ["zhCN"] = false,
        ["zhTW"] = "殺死食屍鬼以釋放達隆郡居民的靈魂",
    },
    ["Exorcise the spirits"] = { -- 7640
        ["enUS"] = true,
        ["deDE"] = "Vertreibe die Geister",
        ["esES"] = "Usa el incensario de exorcismos para expulsar los espíritus",
        ["esMX"] = "Usa el incensario de exorcismos para expulsar los espíritus",
        ["frFR"] = "Servez-vous de l’Encensoir d’exorcisme pour chasser les esprits",
        ["koKR"] = "영혼을 퇴마하세요",
        ["ptBR"] = "Use o Incensório de Exorcismo para expulsar os espíritos",
        ["ruRU"] = "Изгоните духов",
        ["zhCN"] = false,
        ["zhTW"] = "驅除靈魂",
    },
    ["Plant the Demon Summoning Torch"] = { -- 8481
        ["enUS"] = true,
        ["deDE"] = "Platziere die Fackel zur Dämonenbeschwörung",
        ["esES"] = "Deja la Antorcha para invocar demonios",
        ["esMX"] = "Deja la Antorcha para invocar demonios",
        ["frFR"] = "Plantez la Torche d'Invocation de Démon",
        ["koKR"] = "악마 소환의 횃불을 설치하세요",
        ["ptBR"] = "Coloque a Tocha de Evocação Demoníaca",
        ["ruRU"] = "Поставьте Факел призыва демонов",
        ["zhCN"] = false,
        ["zhTW"] = "放置惡魔召喚火炬",
    },
    ["Use Arcanite Buoy"] = { -- 8729
        ["enUS"] = true,
        ["deDE"] = "Benutze Arkanitboje",
        ["esES"] = "Deja la Boya de arcanita",
        ["esMX"] = "Deja la Boya de arcanita",
        ["frFR"] = "Utilisez la Bouée en Arcanite",
        ["koKR"] = "아케이나이트 부표를 사용하세요",
        ["ptBR"] = "Coloca a Boia de Arcanita",
        ["ruRU"] = "Используйте Арканитовый буй",
        ["zhCN"] = false,
        ["zhTW"] = "使用奧金浮標",
    },
    ["Talk to Silva Fil'naveth to fly back to Darnassus"] = { -- 5931
        ["enUS"] = true,
        ["deDE"] = "Sprich mit Silva Fil'naveth, um zurück nach Darnassus zu fliegen",
        ["esES"] = "Habla con Silva Fil'naveth para volar de regreso a Darnassus",
        ["esMX"] = "Habla con Silva Fil'naveth para volar de regreso a Darnassus",
        ["frFR"] = "Parlez à Silva Fil'naveth pour revenir à Darnassus",
        ["koKR"] = "실비아 필나베스에게 말을 걸어 다르나서스로 이동하세요",
        ["ptBR"] = "Converse com Silva Fil'naveth para voar de volta para Darnassus",
        ["ruRU"] = "Поговорите с Сильва Фил'навет, чтобы вернуться в Дарнассус",
        ["zhCN"] = false,
        ["zhTW"] = "與希爾瓦·菲納雯斯交談，飛回達納蘇斯。",
    },
    ["Talk to Bunthen Plainswind to fly back to Thunder Bluff"] = { -- 5932
        ["enUS"] = true,
        ["deDE"] = "Sprich mit Bunthen Plainswind, um zurück nach Thunder Bluff zu fliegen",
        ["esES"] = "Habla con Bunthen Ventollano para volar de regreso a Cima del Trueno",
        ["esMX"] = "Habla con Bunthen Ventollano para volar de regreso a Cima del Trueno",
        ["frFR"] = "Parlez à Bunthen Plainswind pour revenir à Thunder Bluff",
        ["koKR"] = "분덴 플레인즈윈드에게 말을 걸어 썬더블러프로 이동하세요",
        ["ptBR"] = "Converse com Bonthen Vento do Prado para voar de volta para Penhasco do Trovão",
        ["ruRU"] = "Поговорите с Бунтен Ветер Равнин, чтобы вернуться в Громовой Утес",
        ["zhCN"] = false,
        ["zhTW"] = "與布瑟恩·草風交談，飛回雷霆崖。",
    },
    ["Release the kitten near the Jadefire Satyrs' corrupted moonwell."] = { -- quest 4506, text from item 12565
        ["enUS"] = true,
        ["deDE"] = "Das Kätzchen in der Nähe des verderbten Mondbrunnens des Jadefeuersatyrs freilassen",
        ["esES"] = "Libera al gatito cerca de la poza de la luna corrupta de los sátiros Fuego de Jade",
        ["esMX"] = "Libera al gatito cerca de la poza de la luna corrupta de los sátiros Fuego de Jade",
        ["frFR"] = "Libérez le chaton au Puits de lune corrompu des satyres Jadefeu",
        ["koKR"] = "비취불꽃 사티로스가 있는 오염된 달샘에 고양이를 풀어놓습니다.",
        ["ptBR"] = "Solta o gato perto do poço lunar corrompido dos Sátiros Flamejade",
        ["ruRU"] = "Отпустите котенка у оскверненного лунного колодца сатиров из племени Нефритового Пламени.",
        ["zhCN"] = "在碧火萨特的被腐化的月亮井旁释放普通猫。",
        ["zhTW"] = "在碧火薩特被腐化的月井旁釋放小貓。",
    },
    ["Summon a Templar using a full Twilight set."] = { -- 8332 8361
        ["enUS"] = true,
        ["deDE"] = "Beschwöre einen Templer mit einem vollen Twilight-Set",
        ["esES"] = "Invoca a un Templario usando un conjunto Crepuscular",
        ["esMX"] = "Invoca a un Templario usando un conjunto Crepuscular",
        ["frFR"] = "Invoquez un Templier en utilisant un ensemble complet de Sectateur du crépuscule",
        ["koKR"] = "황혼의 제복 세트를 모두 착용하여 기사단을 소환하세요",
        ["ptBR"] = "Evocar um Templário usando um conjunto Crepúsculo",
        ["ruRU"] = "Призовите Храмовника используя Сумеречное облачение.",
        ["zhCN"] = false,
        ["zhTW"] = "使用全套暮光套裝召喚一名聖殿騎士。",
    },
    ["Summon a Duke using a full Twilight set and neck."] = { -- 8341 8348
        ["enUS"] = true,
        ["deDE"] = "Beschwöre einen Duke mit einem vollen Twilight-Set und einer Halskette",
        ["esES"] = "Invoca a un Duque usando un conjunto Crepuscular y el Medallón",
        ["esMX"] = "Invoca a un Duque usando un conjunto Crepuscular y el Medallón",
        ["frFR"] = "Invoquez un Duc en utilisant un ensemble complet et un équipement de cou de Sectateur du crépuscule",
        ["koKR"] = "황혼의 제복 세트와 황혼의 신도 계급장을 착용하여 군주를 소환하세요",
        ["ptBR"] = "Evocar um Duque usando um conjunto Crepúsculo e o Medalhão de Posto",
        ["ruRU"] = "Призовите Герцога используя Сумеречное облачение и шею.",
        ["zhCN"] = false,
        ["zhTW"] = "使用全套暮光套裝和項鍊召喚一位公爵。",
    },
    ["Summon a Lord using a full Twilight set, neck and ring."] = { -- 8352 9248
        ["enUS"] = true,
        ["deDE"] = "Beschwöre einen Lord mit einem vollen Twilight-Set, Halskette und Ring",
        ["esES"] = "Invoca a un Señor usando un conjunto Crepuscular, Medallón y Anillo",
        ["esMX"] = "Invoca a un Señor usando un conjunto Crepuscular, Medallón y Anillo",
        ["frFR"] = "Invoquez un Seigneur en utilisant un ensemble complet, un équipement de cou et une bague de Sectateur du crépuscule",
        ["koKR"] = "황혼의 제복 세트, 황혼의 신도 계급장, 황혼의 신도 지휘관 반지를 착용하여 심연의 대의회 보스 몬스터를 소환하세요",
        ["ptBR"] = "Evocar um Lorde usando um conjunto Crepúsculo, o Medalhão de Posto e Anel",
        ["ruRU"] = "Призовите Лорда используя Сумеречное облачение, шею и кольцо.",
        ["zhCN"] = false,
        ["zhTW"] = "使用全套暮光套裝、項鍊和戒指召喚領主。",
    },
    ["Ask to see the Captain."] = { -- 8507
        ["enUS"] = true,
        ["deDE"] = "Frage nach dem Kapitän",
        ["esES"] = "Pide ver al capitán",
        ["esMX"] = "Pide ver al capitán",
        ["frFR"] = "Demandez à voir le Capitaine",
        ["koKR"] = "선장을 뵙기를 요청하세요",
        ["ptBR"] = "Peça para ver o Capitão",
        ["ruRU"] = "Попросите встретиться с капитаном.",
        ["zhCN"] = false,
        ["zhTW"] = "要求見船長。",
    },
    ["Draw the glyphs into the sand to summon the Qiraji Emissary."] = { -- 8315
        ["enUS"] = true,
        ["deDE"] = "Zeichne die Glyphen in den Sand, um den Abgesandten der Qiraji zu rufen",
        ["esES"] = "Copia los glifos en la arena para invocar al emisario Qiraji",
        ["esMX"] = "Copia los glifos en la arena para invocar al emisario Qiraji",
        ["frFR"] = "Tracez les glyphes dans le sol pour invoquer un Émissaire des Qiraji",
        ["koKR"] = "부름의 상형문자를 사막에 가지고 간 후 퀴라지 밀사를 소환하세요",
        ["ptBR"] = "Desenhe os glifos na areia para evocar o Emissário Qiraji",
        ["ruRU"] = "Нарисуйте письмена зова на песке, чтобы призвать Киражского посланника.",
        ["zhCN"] = false,
        ["zhTW"] = "將雕文放到沙中來召喚其拉蟲人使者。",
    },
    ["Place the Relic Bundle in the Town Square."] = { -- 5721
        ["enUS"] = true,
        ["deDE"] = "Lege das Reliquienbündel auf den Stadtplatz.",
        ["esES"] = "Coloca el Fardo de reliquias en la plaza de Villa Darrow",
        ["esMX"] = "Coloca el Fardo de reliquias en la plaza de Villa Darrow",
        ["frFR"] = " À mettre l'Ensemble de Reliques sur la place centrale de Darrowshire",
        ["koKR"] = "마을 광장에 유물 더미를 놓으세요",
        ["ptBR"] = "Coloque o Saco de Relíquias na Praça da Vila das Flechas",
        ["ruRU"] = "Положите сверток с реликвиями на городскую площадь.",
        ["zhCN"] = false,
        ["zhTW"] = "將聖物包裹放在城鎮廣場中。",
    },
    ["Search the false grave for the Taelan's Hammer."] = { -- 5781
        ["enUS"] = true,
        ["deDE"] = "Durchsuche das falsche Grab nach dem Hammer des Taelan",
        ["esES"] = "Busca en el Túmulo de porquería el Martillo de Taelan",
        ["esMX"] = "Busca en el Túmulo de porquería el Martillo de Taelan",
        ["frFR"] = "Cherchez le Marteau de Taelan dans la fausse tombe",
        ["koKR"] = "지하 납골당 근처에서 탤런의 망치를 찾으세요",
        ["ptBR"] = "Procure o Monturo de Terra pelo Martelo de Taelan",
        ["ruRU"] = "Ищите ложное могильное место для Молота Таэлана.",
        ["zhCN"] = false,
        ["zhTW"] = "在假墳墓中尋找泰蘭之錘。",
    },
    ["Plant the bomb!"] = { -- 6041
        ["enUS"] = true,
        ["deDE"] = "Platziere die Bombe!",
        ["esES"] = "¡Planta la bomba!",
        ["esMX"] = "¡Coloca la bomba!",
        ["frFR"] = "Placez la bombe !",
        ["koKR"] = "폭탄을 설치하세요",
        ["ptBR"] = "Planta a bomba!",
        ["ruRU"] = "Установите бомбу!",
        ["zhCN"] = false,
        ["zhTW"] = "安置炸彈!",
    },
    ["Use the Empty Worg Pup Cage to capture it."] = { -- 4729
        ["enUS"] = true,
        ["deDE"] = "Benutze den leeren Worg-Welpen-Käfig, um ihn zu fangen",
        ["esES"] = "Usa la Jaula de Mascolupo vacía para capturarlo",
        ["esMX"] = "Usa la Jaula de cachorro de huargo vacía para capturarlo",
        ["frFR"] = "Utilisez la Cage de Jeune Worg Vide pour le capturer",
        ["koKR"] = "빈 검은늑대 우리 아이템을 사용하여 사로잡으세요",
        ["ptBR"] = "Use a Jaula Vazia de Filhote de Worg para capturá-lo",
        ["ruRU"] = "Используйте Пустую клетку для щенка ворга, чтобы поймать его.",
        ["zhCN"] = false,
        ["zhTW"] = "使用空的小座狼籠來捕捉它。",
    },
    ["Combine Omokk's Head with the Roughshod Pike."] = { -- 4867
        ["enUS"] = true,
        ["deDE"] = "Kombiniere Omokks Kopf mit der beschlagenen Pike",
        ["esES"] = "Combina la Cabeza de Omokk con la Pica despiadada",
        ["esMX"] = "Combina la Cabeza de Omokk con la Pica férrea",
        ["frFR"] = "Combinez la Tête d'Omokk avec la Pique de fortune",
        ["koKR"] = "오모크의 머리 장식과 날카로운 장창을 조합하세요",
        ["ptBR"] = "Junte a Cabeça do Omokk com o Pique da Brutalidade",
        ["ruRU"] = "Соедините голову Омокка с грубым копьем.",
        ["zhCN"] = false,
        ["zhTW"] = "將歐莫克的頭顱與尖銳長矛結合。",
    },
    ["Use it to instantly kill one nearby ogre."] = { -- 4867
        ["enUS"] = true,
        ["deDE"] = "Benutze es, um einen Oger in der Nähe sofort zu töten",
        ["esES"] = "Úsalo para matar instantáneamente a un ogro cercano",
        ["esMX"] = "Úsalo para matar instantáneamente a un ogro cercano",
        ["frFR"] = "Utilisez-le pour instantanément tuer un ogre proche",
        ["koKR"] = "근처 오우거를 즉시 사살하기 위해 사용하세요",
        ["ptBR"] = "Use-a para matar instantaneamente um ogro próximo",
        ["ruRU"] = "Используйте его, чтобы мгновенно убить одного ближайшего огра.",
        ["zhCN"] = false,
        ["zhTW"] = "用它立即殺死附近的一個巨魔。",
    },
    ["Place a tribute at Uther's Tomb"] = { -- 8149
        ["enUS"] = true,
        ["deDE"] = "Bringt einen Tribut an Uthers Grabmal an",
        ["esES"] = "Ofrece un tributo en la tumba de Uther",
        ["esMX"] = "Ofrece un tributo en la tumba de Uther",
        ["frFR"] = "Fait une offrande sur la tombe d'Uther",
        ["koKR"] = "우서 경의 무덤에 공물을 두세요",
        ["ptBR"] = "Coloca uma homenagem na tumba de Uther",
        ["ruRU"] = "Положите подношения у гробницы Утера",
        ["zhCN"] = false,
        ["zhTW"] = "在烏瑟之墓前獻上一份敬意",
    },
    ["Place a tribute at Grom's Monument"] = { -- 8150
        ["enUS"] = true,
        ["deDE"] = "Platziere ein Tribut am Grom-Denkmal",
        ["esES"] = "Ofrece un tributo en el monumento de Grom",
        ["esMX"] = "Ofrece un tributo en el monumento de Grom",
        ["frFR"] = "Fait une offrande au monument de Grom",
        ["koKR"] = "그롬 헬스크림의 기념비에 공물을 두세요",
        ["ptBR"] = "Oferece um tributo no monumento de Grom",
        ["ruRU"] = "Положите подношения у памятника Грому",
        ["zhCN"] = false,
        ["zhTW"] = "在葛羅的紀念碑前致敬",
    },
    ["Combine the Pendant halves at the Shrine of Remulos."] = { -- 30 & 272
        ["enUS"] = true,
        ["deDE"] = "Kombiniere die Anhängerhälften am Schrein von Remulos",
        ["esES"] = "Combina los dos medio colgantes cuando estés cerca del Santuario de Remulos",
        ["esMX"] = "Combina los dos medio colgantes cuando estés cerca del Santuario de Remulos",
        ["frFR"] = "Combinez les Demi-pendentifs à proximité du sanctuaire de Remulos",
        ["koKR"] = "레물로스 신전에서 펜던트 반쪽을 결합하세요",
        ["ptBR"] = "Combine os Meio-pingentes perto do Santuário de Remulos",
        ["ruRU"] = "Сложите из половинок подвеску в святилище Ремулоса.",
        ["zhCN"] = false,
        ["zhTW"] = "在雷姆洛斯神殿附近將墜飾的兩部分合而為一。",
    },
    ["Use the Draco-Incarcinatrix 900 and defeat the dragonkin."] = {
        ["enUS"] = true,
        ["deDE"] = "Benutze den Draco-Incarcinatrix 900 und besiege den Drachkinbrutling",
        ["esES"] = "Usa el Draco-Incarcinatrix 900 y dispara a una cría de dragonante en Las Estepas Ardientes",
        ["esMX"] = "Usa el Draco-Incarcinatrix 900 y dispara a una cría de dragonante en Las Estepas Ardientes",
        ["frFR"] = "Utilisez le Draco-Incarcinatrix 900 et tire sur un Rejeton draconien dans les Steppes ardentes",
        ["koKR"] = "새끼용 속박장치 900을 사용하여 드래곤킨을 물리칩니다",
        ["ptBR"] = "Use o Draco-incarcinatrix 900 e dispara contra um filhote de draconiano nas Estepes Ardentes",
        ["ruRU"] = "Используйте Драко-инкарцинатор 900 и одолейте детеныша дракона.",
        ["zhCN"] = false,
        ["zhTW"] = "使用龍靈採集器900型並擊敗龍人。",
    },
    ["Silithyst"] = {
        ["enUS"] = true,
        ["deDE"] = "Silithyst",
        ["esES"] = "Silitista",
        ["esMX"] = "Silitista",
        ["frFR"] = "Silithyste",
        ["koKR"] = "실리시스트",
        ["ptBR"] = "Silitista",
        ["ruRU"] = "Силитист",
        ["zhCN"] = "水晶尘",
        ["zhTW"] = false,
    },
    ["Use the Empty Leaden Collection Phial."] = {
        ["enUS"] = true,
        ["deDE"] = "Benutze die Leere bleierne Sammelphiole",
        ["esES"] = "Usa la Ampolla de plomo vacía",
        ["esMX"] = "Usa la Ampolla de plomo vacía",
        ["frFR"] = "Utilisez le Flasque plombée vide",
        ["koKR"] = false,
        ["ptBR"] = "Use o Coletor de Chumbo Vazio",
        ["ruRU"] = false,
        ["zhCN"] = false,
        ["zhTW"] = false,
    },
    ["Use the Aspect of Neptulon."] = {
        ["enUS"] = true,
        ["deDE"] = "Benutze den Aspekt von Neptulon",
        ["esES"] = "Usa el Aspecto de Neptulon",
        ["esMX"] = "Usa el Aspecto de Neptulon",
        ["frFR"] = "Utilisez l'Aspect de Neptulon",
        ["koKR"] = false,
        ["ptBR"] = "Use o Aspecto de Neptulon",
        ["ruRU"] = false,
        ["zhCN"] = false,
        ["zhTW"] = false,
    },
}

for k, v in pairs(classicObjectiveLocales) do
    l10n.translations[k] = v
end
