---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local classLocales = {
    ["Warrior"] = {
        ["enUS"] = true,
        ["deDE"] = "Krieger",
        ["esES"] = "Guerrero",
        ["esMX"] = "Guerrero",
        ["frFR"] = "Guerrier",
        ["koKR"] = "전사",
        ["ptBR"] = "Guerreiro",
        ["ruRU"] = "Воин",
        ["zhCN"] = "战士",
        ["zhTW"] = "戰士",
    },
    ["Paladin"] = {
        ["enUS"] = true,
        ["deDE"] = true,
        ["esES"] = "Paladín",
        ["esMX"] = "Paladín",
        ["frFR"] = true,
        ["koKR"] = "성기사",
        ["ptBR"] = "Paladino",
        ["ruRU"] = "Паладин",
        ["zhCN"] = "圣骑士",
        ["zhTW"] = "聖騎士",
    },
    ["Shaman"] = {
        ["enUS"] = true,
        ["deDE"] = "Schamane",
        ["esES"] = "Chamán",
        ["esMX"] = "Chamán",
        ["frFR"] = "Chaman",
        ["koKR"] = "주술사",
        ["ptBR"] = "Xamã",
        ["ruRU"] = "Шаман",
        ["zhCN"] = "萨满祭司",
        ["zhTW"] = "薩滿",
    },
    ["Rogue"] = {
        ["enUS"] = true,
        ["deDE"] = "Schurke",
        ["esES"] = "Pícaro",
        ["esMX"] = "Pícaro",
        ["frFR"] = "Voleur",
        ["koKR"] = "도적",
        ["ptBR"] = "Ladino",
        ["ruRU"] = "Разбойник",
        ["zhCN"] = "潜行者",
        ["zhTW"] = "盜賊",
    },
    ["Mage"] = {
        ["enUS"] = true,
        ["deDE"] = "Magier",
        ["esES"] = "Mago",
        ["esMX"] = "Mago",
        ["frFR"] = true,
        ["koKR"] = "마법사",
        ["ptBR"] = "Mago",
        ["ruRU"] = "Маг",
        ["zhCN"] = "法师",
        ["zhTW"] = "法師",
    },
    ["Druid"] = {
        ["enUS"] = true,
        ["deDE"] = "Druide",
        ["esES"] = "Druida",
        ["esMX"] = "Druida",
        ["frFR"] = "Druide",
        ["koKR"] = "드루이드",
        ["ptBR"] = "Druida",
        ["ruRU"] = "Друид",
        ["zhCN"] = "德鲁伊",
        ["zhTW"] = "德魯伊",
    },
    ["Priest"] = {
        ["enUS"] = true,
        ["deDE"] = "Priester",
        ["esES"] = "Sacerdote",
        ["esMX"] = "Sacerdote",
        ["frFR"] = "Prêtre",
        ["koKR"] = "사제",
        ["ptBR"] = "Sacerdote",
        ["ruRU"] = "Жрец",
        ["zhCN"] = "牧师",
        ["zhTW"] = "牧師",
    },
    ["Hunter"] = {
        ["enUS"] = true,
        ["deDE"] = "Jäger",
        ["esES"] = "Cazador",
        ["esMX"] = "Cazador",
        ["frFR"] = "Chasseur",
        ["koKR"] = "사냥꾼",
        ["ptBR"] = "Caçador",
        ["ruRU"] = "Охотник",
        ["zhCN"] = "猎人",
        ["zhTW"] = "獵人",
    },
    ["Warlock"] = {
        ["enUS"] = true,
        ["deDE"] = "Hexenmeister",
        ["esES"] = "Brujo",
        ["esMX"] = "Brujo",
        ["frFR"] = "Démoniste",
        ["koKR"] = "흑마법사",
        ["ptBR"] = "Bruxo",
        ["ruRU"] = "Чернокнижник",
        ["zhCN"] = "术士",
        ["zhTW"] = "術士",
    },
    ["Death Knight"] = {
        ["enUS"] = true,
        ["deDE"] = "Todesritter",
        ["esES"] = "Caballero de la Muerte",
        ["esMX"] = "Caballero de la Muerte",
        ["frFR"] = "Chevalier de la mort",
        ["koKR"] = "죽음의 기사,죽음의 기사",
        ["ptBR"] = "Cavaleiro da Morte",
        ["ruRU"] = "Рыцарь смерти",
        ["zhCN"] = "死亡骑士",
        ["zhTW"] = "死亡騎士",
    },
    ["Monk"] = {
        ["enUS"] = true,
        ["deDE"] = "Mönch",
        ["esES"] = "Monje",
        ["esMX"] = "Monje",
        ["frFR"] = "Moine",
        ["koKR"] = "수도사",
        ["ptBR"] = "Monge",
        ["ruRU"] = "Монах",
        ["zhCN"] = "武僧",
        ["zhTW"] = "武僧",
    },
}

for k, v in pairs(classLocales) do
    l10n.translations[k] = v
end
