---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

--- If you want to add something to areaIdToUiMapId overwrite the data in this table.
---@type table<AreaId, UiMapId>
ZoneDB.private.areaIdToUiMapIdOverride = [[return {
    [0] = 1415, -- Eastern Kingdoms (some things are so far off the map, we need to use this map)
    [1977] = 337, -- Zul'Gurub - Dungeon (override wrong ID)
    [10073] = 1414, -- Kalimdor - the continent map
    [10074] = 1415, -- Eastern Kingdoms - the continent map
    [10000] = 281, -- Maraudon - Zaetar's Grave (fake ID for Maraudon)
    [10001] = 318, -- Stratholme - The Gauntlet (fake ID for Stratholme)
    [10002] = 243, -- Blackrock Depths - Shadowforge City (fake ID for Blackrock Depths)
    [10003] = 250, -- Blackrock Spire - Tazz'Alor (fake ID for Blackrock Spire)
    [10004] = 251, -- Blackrock Spire - Skitterweb Tunnels (fake ID for Blackrock Spire)
    [10005] = 252, -- Blackrock Spire - Hordemar City (fake ID for Blackrock Spire)
    [10006] = 254, -- Blackrock Spire - Halycon's Lair (fake ID for Blackrock Spire)
    [10007] = 255, -- Blackrock Spire - Chamber of Battle (fake ID for Blackrock Spire)
    [10008] = 303, -- Scarlet Monastery - Library (fake ID for Scarlet Monastery)
    [10009] = 304, -- Scarlet Monastery - Armory (fake ID for Scarlet Monastery)
    [10010] = 305, -- Scarlet Monastery - Cathedral (fake ID for Scarlet Monastery)
    [10011] = 307, -- Scholomance - Chamber of Summoning (fake ID for Scholomance)
    [10012] = 308, -- Scholomance - The Upper Study (fake ID for Scholomance)
    [10013] = 309, -- Scholomance - Headmaster's Study (fake ID for Scholomance)
    [10014] = 311, -- Shadowfang Keep - Dining Hall (fake ID for Shadowfang Keep)
    [10015] = 312, -- Shadowfang Keep - The Vacant Den (fake ID for Shadowfang Keep)
    [10016] = 313, -- Shadowfang Keep - Lower Observatory (fake ID for Shadowfang Keep)
    [10017] = 314, -- Shadowfang Keep - Upper Observatory (fake ID for Shadowfang Keep)
    [10018] = 315, -- Shadowfang Keep - Lord Godfrey's Chamber (fake ID for Shadowfang Keep)
    [10019] = 316, -- Shadowfang Keep - The Wall Walk (fake ID for Shadowfang Keep)
    [10020] = 222, -- Blackfathom Deeps - Dungeon - Moonshrine Sanctum
    [10021] = 223, -- Blackfathom Deeps - Dungeon - The Forgotten Pool
    [10022] = 235, -- Dire Maul - Gordok Commons (fake ID for Dire Maul North)
    [10023] = 236, -- Dire Maul - Capital Gardens (fake ID for Dire Maul West)
    [10024] = 237, -- Dire Maul - Court of the Highborne (fake ID for Dire Maul West)
    [10025] = 238, -- Dire Maul - Prison of Immol'Thar (fake ID for Dire Maul West)
    [10026] = 239, -- Dire Maul - Warpwood Quarter (fake ID for Dire Maul East)
    [10027] = 240, -- Dire Maul - The Shrine of Eldretharr (fake ID for Dire Maul East)
    [10028] = 348, -- Magisters' Terrace - Grand Magister's Asylum (fake ID for Magisters' Terrace)
    [10029] = 292, -- The Deadmines - Dungeon - Ironclad Cove (fake ID for The Deadmines)
    [10030] = 227, -- Gnomeregan - Dungeon - The Dormitory
    [10031] = 228, -- Gnomeregan - Dungeon - Launch Bay
    [10032] = 229, -- Gnomeregan - Dungeon - Tinkers' Court
    [10033] = 231, -- Uldaman - Dungeon - Khaz'Goroth's Seat
    [10039] = 400, -- Hour of Twilight - Wyrmrest Temple
    [10040] = 319, -- Ahn'Qiraj - Raid - The Hive Undergrounds
    [10041] = 321, -- Ahn'Qiraj - Raid - Vault of C'thun
    [10042] = 259, -- Sethekk Halls - Dungeon - Halls of Mourning
    [10043] = 257, -- Auchenai Crypts - Dungeon - Bridge of Souls
    [10044] = 268, -- The Mechanar - Dungeon - Calculation Chamber
    [10045] = 270, -- The Arcatraz - Dungeon - Stasis Block: Maximus
    [10046] = 271, -- The Arcatraz - Dungeon - Containment Core
    [10047] = 144, -- The Oculus - Band of Acceleration (fake ID for The Oculus)
    [10048] = 145, -- The Oculus - Band of Transmutation (fake ID for The Oculus)
    [10049] = 146, -- The Oculus - Band of Alignment (fake ID for The Oculus)
    [10050] = 150, -- Ulduar - The Descent of Madness (fake ID for Ulduar)
    [10051] = 151, -- Ulduar - The Spark of Imagination (fake ID for Ulduar)
    [10052] = 149, -- Ulduar - The Inner Sanctum of Ulduar (fake ID for Ulduar)
    [10053] = 136, -- Utgarde Pinnacle - Lower Level (fake ID for Utgarde Pinnacle)
    [10054] = 139, -- Halls of Lightning - The Terrestrial Watchtower (fake ID for Halls of Lightning)
    [10055] = 157, -- Azjol-Nerub - The Brood Pit (fake ID for Azjol-Nerub)
    [10056] = 158, -- Azjol-Nerub - Hadronox's Lair (fake ID for Azjol-Nerub)
    [10057] = 134, -- Utgarde Keep - Middle Level (fake ID for Utgarde Keep)
    [10058] = 135, -- Utgarde Keep - Upper Level (fake ID for Utgarde Keep)
    [10059] = 131, -- The Culling of Stratholme - City (fake ID for The Culling of Stratholme)
    [10060] = 161, -- Drak'Tharon Keep - Upper Level (fake ID for Drak'Tharon Keep)
    [10061] = 153, -- Gundrak - Lower Level (fake ID for Gundrak) -- does not exist in Cata+
    [10062] = 162, -- Naxxramas - Construct Quarter (fake ID for Naxxramas)
    [10063] = 163, -- Naxxramas - Arachnid Quarter (fake ID for Naxxramas)
    [10064] = 164, -- Naxxramas - Military Quarter (fake ID for Naxxramas)
    [10065] = 165, -- Naxxramas - Plague Quarter (fake ID for Naxxramas)
    [10066] = 167, -- Naxxramas - Frostwyrm Lair (fake ID for Naxxramas)
    [10067] = 190, -- Icecrown Citadel - Upper Spire (fake ID for ICC)
    [10068] = 191, -- Icecrown Citadel - Queen Lana'thel (fake ID for ICC)
    [10069] = 189, -- Icecrown Citadel - Sindragosa (fake ID for ICC)
    [10070] = 187, -- Icecrown Citadel - Rampart of Skulls (fake ID for ICC)
    [10071] = 188, -- Icecrown Citadel - Deathbringer's Rise (fake ID for ICC)
    [10072] = 192, -- Icecrown Citadel - The Frozen Throne (fake ID for ICC)
}]]

--- This table is generated by the generate_zone_tables.py script - use the table above to add new entries.
--- This table maps the areaId (used in the DB for example) to the UiMapId of each zone.
--- The UiMapId identifies a map which can be displayed ingame on the worldmap.
--- Dungeons don't have a UiMapId prior WotLK!
--- https://wow.gamepedia.com/UiMapID/Classic
---@type table<AreaId, UiMapId>
ZoneDB.private.areaIdToUiMapId = [[return {
    [1] = 1426, -- Dun Morogh
    [3] = 1418, -- Badlands
    [4] = 1419, -- Blasted Lands
    [8] = 1435, -- Swamp of Sorrows
    [10] = 1431, -- Duskwood
    [11] = 1437, -- Wetlands
    [12] = 1429, -- Elwynn Forest
    [14] = 1411, -- Durotar
    [15] = 1445, -- Dustwallow Marsh
    [16] = 1447, -- Azshara
    [17] = 1413, -- The Barrens
    [28] = 1422, -- Western Plaguelands
    [33] = 1434, -- Stranglethorn Vale
    [36] = 1416, -- Alterac Mountains
    [38] = 1432, -- Loch Modan
    [40] = 1436, -- Westfall
    [41] = 1430, -- Deadwind Pass
    [44] = 1433, -- Redridge Mountains
    [45] = 1417, -- Arathi Highlands
    [46] = 1428, -- Burning Steppes
    [47] = 1425, -- The Hinterlands
    [51] = 1427, -- Searing Gorge
    [65] = 115, -- Dragonblight
    [66] = 121, -- Zul'Drak
    [67] = 120, -- The Storm Peaks
    [85] = 1420, -- Tirisfal Glades
    [130] = 1421, -- Silverpine Forest
    [139] = 1423, -- Eastern Plaguelands
    [141] = 1438, -- Teldrassil
    [148] = 1439, -- Darkshore
    [206] = 133, -- Utgarde Keep - Dungeon
    [209] = 310, -- Shadowfang Keep - Dungeon
    [210] = 118, -- Icecrown
    [215] = 1412, -- Mulgore
    [267] = 1424, -- Hillsbrad Foothills
    [331] = 1440, -- Ashenvale
    [357] = 1444, -- Feralas
    [361] = 1448, -- Felwood
    [394] = 116, -- Grizzly Hills
    [400] = 1441, -- Thousand Needles
    [405] = 1443, -- Desolace
    [406] = 1442, -- Stonetalon Mountains
    [440] = 1446, -- Tanaris
    [490] = 1449, -- Un'Goro Crater
    [491] = 301, -- Razorfen Kraul - Dungeon
    [493] = 1450, -- Moonglade
    [495] = 117, -- Howling Fjord
    [616] = 198, -- Mount Hyjal
    [618] = 1452, -- Winterspring
    [717] = 225, -- The Stockade - Dungeon
    [718] = 279, -- Wailing Caverns - Dungeon
    [719] = 221, -- Blackfathom Deeps - Dungeon
    [721] = 226, -- Gnomeregan - Dungeon
    [722] = 300, -- Razorfen Downs - Dungeon
    [796] = 302, -- Scarlet Monastery - Dungeon
    [1037] = 293, -- Grim Batol
    [1176] = 219, -- Zul'Farrak - Dungeon
    [1196] = 137, -- Utgarde Pinnacle
    [1337] = 230, -- Uldaman - Dungeon
    [1377] = 1451, -- Silithus
    [1477] = 220, -- The Temple of Atal'Hakkar - Dungeon
    [1497] = 1458, -- Undercity
    [1519] = 1453, -- Stormwind City
    [1537] = 1455, -- Ironforge
    [1581] = 291, -- The Deadmines - Dungeon - The Deadmines
    [1583] = 253, -- Blackrock Spire - Dungeon
    [1584] = 242, -- Blackrock Depths - Dungeon
    [1637] = 1454, -- Orgrimmar
    [1638] = 1456, -- Thunder Bluff
    [1657] = 1457, -- Darnassus
    [2017] = 317, -- Stratholme - Dungeon
    [2057] = 306, -- Scholomance - Dungeon
    [2100] = 280, -- Maraudon - Dungeon
    [2159] = 248, -- Onyxia's Lair - Dungeon?
    [2366] = 273, -- The Black Morass - Dungeon
    [2367] = 274, -- Old Hillsbrad Foothills - Dungeon
    [2437] = 213, -- Ragefire Chasm - Dungeon
    [2557] = 234, -- Dire Maul - Dungeon
    [2597] = 1459, -- Alterac Valley - Battleground
    [2677] = 287, -- Blackwing Lair - Raid
    [2717] = 232, -- Molten Core - Raid
    [2817] = 127, -- Crystalsong Forest
    [3277] = 1460, -- Warsong Gulch - Battleground
    [3358] = 1461, -- Arathi Basin - Battleground
    [3428] = 320, -- Ahn'Qiraj - Raid
    [3429] = 247, -- Ruins of Ahn'Qiraj - Raid
    [3430] = 1941, -- Eversong Woods
    [3433] = 1942, -- Ghostlands
    [3456] = 166, -- Naxxramas - Raid
    [3457] = 350, -- Karazhan - Raid
    [3483] = 1944, -- Hellfire Peninsula
    [3487] = 1954, -- Silvermoon City
    [3518] = 1951, -- Nagrand
    [3519] = 1952, -- Terokkar Forest
    [3520] = 1948, -- Shadowmoon Valley
    [3521] = 1946, -- Zangarmarsh
    [3522] = 1949, -- Blade's Edge Mountains
    [3523] = 1953, -- Netherstorm
    [3524] = 1943, -- Azuremyst Isle
    [3525] = 1950, -- Bloodmyst Isle
    [3537] = 114, -- Borean Tundra
    [3557] = 1947, -- The Exodar
    [3562] = 347, -- Hellfire Ramparts - Dungeon
    [3606] = 329, -- Hyjal Summit - Raid
    [3607] = 332, -- Serpentshrine Cavern - Raid
    [3703] = 1955, -- Shattrath City
    [3711] = 119, -- Sholazar Basin
    [3713] = 261, -- The Blood Furnace - Dungeon
    [3714] = 246, -- The Shattered Halls - Dungeon
    [3715] = 263, -- The Steamvault - Dungeon
    [3716] = 262, -- The Underbog - Dungeon
    [3717] = 265, -- The Slave Pens - Dungeon
    [3789] = 260, -- Shadow Labyrinth - Dungeon
    [3790] = 256, -- Auchenai Crypts - Dungeon
    [3791] = 258, -- Sethekk Halls - Dungeon
    [3792] = 272, -- Mana-Tombs - Dungeon
    [3805] = 333, -- Zul'Aman - Raid
    [3820] = 1956, -- Eye of the Storm - Battleground
    [3836] = 331, -- Magtheridon's Lair - Raid
    [3845] = 334, -- Tempest Keep - Raid
    [3847] = 266, -- The Botanica - Dungeon
    [3848] = 269, -- The Arcatraz - Dungeon
    [3849] = 267, -- The Mechanar - Dungeon
    [3923] = 330, -- Gruul's Lair - Raid
    [3959] = 339, -- Black Temple - Raid
    [3979] = 113, -- The Frozen Sea
    [4075] = 335, -- Sunwell Plateau - Raid
    [4080] = 1957, -- Isle of Quel'Danas
    --[4095] = 349, -- Magisters' Terrace
    [4100] = 130, -- The Culling of Stratholme
    --[4120] = 370, -- The Nexus
    [4131] = 349, -- Magisters' Terrace - Dungeon
    [4196] = 160, -- Drak'Tharon Keep
    [4197] = 123, -- Wintergrasp
    [4228] = 143, -- The Oculus - Dungeon
    [4264] = 140, -- Halls of Stone
    [4265] = 129, -- The Nexus - Dungeon
    [4272] = 138, -- Halls of Lightning - Dungeon
    [4273] = 147, -- Ulduar - Raid
    [4277] = 159, -- Azjol-Nerub
    [4298] = 124, -- Plaguelands: The Scarlet Enclave
    [4384] = 128, -- Strand of the Ancients - Battleground
    [4395] = 125, -- Dalaran - Dungeon?
    [4415] = 168, -- The Violet Hold - Dungeon
    [4416] = 154, -- Gundrak
    [4493] = 155, -- The Obsidian Sanctum - Raid
    [4494] = 132, -- Ahn'kahet: The Old Kingdom
    [4500] = 141, -- The Eye of Eternity - Raid
    [4560] = 126, -- The Underbelly - Sub zone of Dalaran
    [4603] = 156, -- Vault of Archavon - Raid
    [4657] = 148, -- Ulduar - The Antechamber of Ulduar
    [4706] = 217, -- Ruins of Gilneas
    [4707] = 174, -- The Lost Isles
    [4709] = 199, -- Southern Barrens
    [4710] = 169, -- Isle of Conquest - Battleground
    [4714] = 179, -- Gilneas
    [4720] = 174, -- The Lost Isles
    [4722] = 172, -- Trial of the Crusader - Raid
    [4723] = 171, -- Trial of the Champion - Dungeon
    [4737] = 194, -- Kezan
    [4742] = 170, -- Hrothgar's Landing
    [4755] = 202, -- Gilneas City
    [4809] = 183, -- The Forge of Souls - Dungeon
    [4812] = 186, -- Icecrown Citadel - Raid
    [4813] = 184, -- Pit of Saron - Dungeon
    [4815] = 201, -- Kelp'thar Forest
    [4820] = 185, -- Halls of Reflection - Dungeon
    [4922] = 241, -- Twilight Highlands
    [4926] = 283, -- Blackrock Caverns
    --[4926] = 284, -- Blackrock Caverns
    [4945] = 297, -- Halls of Origination
    --[4945] = 298, -- Halls of Origination
    --[4945] = 299, -- Halls of Origination
    [4950] = 293, -- Grim Batol
    [4987] = 200, -- The Ruby Sanctum - Raid
    [5004] = 322, -- Throne of the Tides
    --[5004] = 323, -- Throne of the Tides
    [5031] = 206, -- Twin Peaks
    [5034] = 249, -- Uldum
    [5035] = 325, -- The Vortex Pinnacle
    [5042] = 207, -- Deepholm
    [5088] = 324, -- The Stonecore
    --[5094] = 286, -- Blackwing Descent
    [5094] = 285, -- Blackwing Descent
    [5095] = 244, -- Tol Barad
    [5144] = 205, -- Shimmering Expanse
    [5145] = 204, -- Abyssal Depths
    [5146] = 203, -- Vashj'ir
    [5287] = 210, -- The Cape of Stranglethorn
    [5334] = 294, -- The Bastion of Twilight
    --[5334] = 295, -- The Bastion of Twilight
    --[5334] = 296, -- The Bastion of Twilight
    [5339] = 224, -- Stranglethorn Vale
    [5351] = 218, -- Ruins of Gilneas City
    [5389] = 245, -- Tol Barad Peninsula
    [5396] = 277, -- Lost City of the Tol'vir
    [5399] = 282, -- Baradin Hold
    [5416] = 276, -- The Maelstrom
    [5449] = 275, -- The Battle for Gilneas
    [5638] = 328, -- Throne of the Four Winds
    [5695] = 327, -- Ahn'Qiraj: The Fallen Kingdom
    [5723] = 367, -- Firelands
    --[5723] = 368, -- Firelands
    --[5723] = 369, -- Firelands
    [5733] = 338, -- Molten Front
    [5786] = 370, -- Nexus Legendary
    [5788] = 398, -- Well of Eternity
    [5789] = 401, -- End Time
    [5790] = 403, -- End Time - Dungeon - Ruby Dragonshrine
    [5792] = 404, -- End Time - Dungeon - Obsidian Dragonshrine
    [5793] = 402, -- End Time - Dungeon - Azure Dragonshrine
    [5794] = 405, -- End Time - Dungeon - Emerald Dragonshrine
    [5795] = 406, -- End Time - Dungeon - Bronze Dragonshrine
    [5844] = 399, -- Hour of Twilight
    [5861] = 407, -- Darkmoon Island
    [5892] = 409, -- Dragon Soul
    --[5892] = 410, -- Dragon Soul
    --[5892] = 411, -- Dragon Soul
    --[5892] = 412, -- Dragon Soul
    --[5892] = 413, -- Dragon Soul
    --[5892] = 414, -- Dragon Soul
    --[5892] = 415, -- Dragon Soul
    [6170] = 425, -- Northshire
    [6176] = 427, -- Coldridge Valley
    [6450] = 460, -- Shadowglen
    [6451] = 461, -- Valley of Trials
    [6452] = 462, -- Camp Narache
    [6453] = 463, -- Echo Isles
    [6454] = 465, -- Deathknell
    [6455] = 467, -- Sunstrider Isle
    [6456] = 468, -- Ammen Vale
    [6457] = 469, -- New Tinkertown
}]]
