---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

--- If you want to add something to uiMapIdToAreaId overwrite the data in this table.
--- We map continent zone to 0, because they can be returned from C_Map.GetBestMapForUnit("player") when
--- the player is in a cave for example.
---@type table<AreaId, UiMapId>
ZoneDB.private.uiMapIdToAreaIdOverride = [[return {
    [947] = 0, -- World -- TODO: Remove this once the spawns are fixed
    [1414] = 0, -- Kalimdor
    [1415] = 0, -- Eastern Kingdoms
    [1945] = 0, -- Outland
    [246] = 3713, -- The Blood Furnace
    [113] = 3979, -- The Frozen Sea/Northrend
    [174] = 4720, -- The Lost Isles
    [349] = 4131, -- Magisters' Terrace - (Dungeon/Raid) (override wrong ID)
    [159] = 4277, -- Azjol-Nerub (override wrong ID)
    [154] = 4416, -- Gundrak (override wrong ID)
    [126] = 4560, -- The Underbelly - Sub zone of Dalaran (override wrong ID)
    [480] = 6219, -- Proving Grounds - (Dungeon/Raid)
    [453] = 6471, -- Mogu'shan Palace - The Crimson Assembly Hall
    [454] = 6473, -- Mogu'shan Palace - Vaults of Kings Past
    [455] = 6474, -- Mogu'shan Palace - Throne of Ancient Conquerors

    [281] = 10000, -- Maraudon - Zaetar's Grave (fake ID for Maraudon)
    [318] = 10001, -- Stratholme - The Gauntlet (fake ID for Stratholme)
    [243] = 10002, -- Blackrock Depths - Shadowforge City (fake ID for Blackrock Depths)
    [250] = 10003, -- Blackrock Spire - Tazz'Alor (fake ID for Blackrock Spire)
    [251] = 10004, -- Blackrock Spire - Skitterweb Tunnels (fake ID for Blackrock Spire)
    [252] = 10005, -- Blackrock Spire - Hordemar City (fake ID for Blackrock Spire)
    [254] = 10006, -- Blackrock Spire - Halycon's Lair (fake ID for Blackrock Spire)
    [255] = 10007, -- Blackrock Spire - Chamber of Battle (fake ID for Blackrock Spire)
    [303] = 10008, -- Scarlet Monastery - Library (fake ID for Scarlet Monastery)
    [304] = 10009, -- Scarlet Monastery - Armory (fake ID for Scarlet Monastery)
    [305] = 10010, -- Scarlet Monastery - Cathedral (fake ID for Scarlet Monastery)
    [307] = 10011, -- Scholomance - Chamber of Summoning (fake ID for Scholomance)
    [308] = 10012, -- Scholomance - The Upper Study (fake ID for Scholomance)
    [309] = 10013, -- Scholomance - Headmaster's Study (fake ID for Scholomance)
    [311] = 10014, -- Shadowfang Keep - Dining Hall (fake ID for Shadowfang Keep)
    [312] = 10015, -- Shadowfang Keep - The Vacant Den (fake ID for Shadowfang Keep)
    [313] = 10016, -- Shadowfang Keep - Lower Observatory (fake ID for Shadowfang Keep)
    [314] = 10017, -- Shadowfang Keep - Upper Observatory (fake ID for Shadowfang Keep)
    [315] = 10018, -- Shadowfang Keep - Lord Godfrey's Chamber (fake ID for Shadowfang Keep)
    [316] = 10019, -- Shadowfang Keep - The Wall Walk (fake ID for Shadowfang Keep)
    [235] = 10022, -- Dire Maul - Gordok Commons (fake ID for Dire Maul North)
    [236] = 10023, -- Dire Maul - Capital Gardens (fake ID for Dire Maul West)
    [237] = 10024, -- Dire Maul - Court of the Highborne (fake ID for Dire Maul West)
    [238] = 10025, -- Dire Maul - Prison of Immol'Thar (fake ID for Dire Maul West)
    [239] = 10026, -- Dire Maul - Warpwood Quarter (fake ID for Dire Maul East)
    [240] = 10027, -- Dire Maul - The Shrine of Eldretharr (fake ID for Dire Maul East)
    [348] = 10028, -- Magisters' Terrace - Grand Magister's Asylum (fake ID for Magisters' Terrace)
    [292] = 10029, -- The Deadmines - Dungeon - Ironclad Cove (fake ID for The Deadmines)
    [222] = 10020, -- Blackfathom Deeps - Moonshrine Sanctum
    [223] = 10021, -- Blackfathom Deeps - The Forgotten Pool
    [227] = 10030, -- Gnomeregan - Dungeon - The Dormitory
    [228] = 10031, -- Gnomeregan - Dungeon - Launch Bay
    [229] = 10032, -- Gnomeregan - Dungeon - Tinkers' Court
    [231] = 10033, -- Uldaman - Dungeon - Khaz'Goroth's Seat
    [400] = 10039, -- Hour of Twilight - Wyrmrest Temple
    [319] = 10040, -- Ahn'Qiraj - Raid - The Hive Undergrounds
    [321] = 10041, -- Ahn'Qiraj - Raid - Vault of C'thun
    [259] = 10042, -- Sethekk Halls - Dungeon - Halls of Mourning
    [257] = 10043, -- Auchenai Crypts - Dungeon - Bridge of Souls
    [268] = 10044, -- The Mechanar - Dungeon - Calculation Chamber
    [270] = 10045, -- The Arcatraz - Dungeon - Stasis Block: Maximus
    [271] = 10046, -- The Arcatraz - Dungeon - Containment Core
    [144] = 10047, -- The Oculus - Band of Acceleration (fake ID for The Oculus)
    [145] = 10048, -- The Oculus - Band of Transmutation (fake ID for The Oculus)
    [146] = 10049, -- The Oculus - Band of Alignment (fake ID for The Oculus)
    [149] = 10052, -- Ulduar - The Inner Sanctum of Ulduar (fake ID for Ulduar)
    [150] = 10050, -- Ulduar - The Descent of Madness (fake ID for Ulduar)
    [151] = 10051, -- Ulduar - The Spark of Imagination (fake ID for Ulduar)
    [136] = 10053, -- Utgarde Pinnacle - Lower Level (fake ID for Utgarde Pinnacle)
    [139] = 10054, -- Halls of Lightning - The Terrestrial Watchtower (fake ID for Halls of Lightning)
    [157] = 10055, -- Azjol-Nerub - The Brood Pit (fake ID for Azjol-Nerub)
    [158] = 10056, -- Azjol-Nerub - Hadronox's Lair (fake ID for Azjol-Nerub)
    [134] = 10057, -- Utgarde Keep - Middle Level (fake ID for Utgarde Keep)
    [135] = 10058, -- Utgarde Keep - Upper Level (fake ID for Utgarde Keep)
    [131] = 10059, -- The Culling of Stratholme - City (fake ID for The Culling of Stratholme)
    [161] = 10060, -- Drak'Tharon Keep - Upper Level (fake ID for Drak'Tharon Keep)
    [153] = 10061, -- Gundrak - Lower Level (fake ID for Gundrak) -- does not exist in Cata+
    [162] = 10062, -- Naxxramas - Construct Quarter (fake ID for Naxxramas)
    [163] = 10063, -- Naxxramas - Arachnid Quarter (fake ID for Naxxramas)
    [164] = 10064, -- Naxxramas - Military Quarter (fake ID for Naxxramas)
    [165] = 10065, -- Naxxramas - Plague Quarter (fake ID for Naxxramas)
    [167] = 10066, -- Naxxramas - Frostwyrm Lair (fake ID for Naxxramas)
    [187] = 10067, -- Icecrown Citadel - Rampart of Skulls (fake ID for ICC)
    [188] = 10068, -- Icecrown Citadel - Deathbringer's Rise (fake ID for ICC)
    [189] = 10069, -- Icecrown Citadel - Sindragosa (fake ID for ICC)
    [190] = 10070, -- Icecrown Citadel - Upper Spire (fake ID for ICC)
    [191] = 10071, -- Icecrown Citadel - Queen Lana'thel (fake ID for ICC)
    [192] = 10072, -- Icecrown Citadel - The Frozen Throne (fake ID for ICC)
    [12] = 10073, -- Kalimdor - the continent map
    [13] = 10074, -- Eastern Kingdoms - the continent map
    [424] = 10075, -- Pandaria - the continent map
    [432] = 10076, -- Scarlet Halls - Athenaeum
    [477] = 10077, -- Scholomance - Chamber of Summoning (fake ID for Scholomance MoP)
    [478] = 10078, -- Scholomance - The Upper Study (fake ID for Scholomance MoP)
    [479] = 10079, -- Scholomance - Headmaster's Study (fake ID for Scholomance MoP)
    [396] = 10080, -- Guo-Lai Halls - The Hall of the Serpent (fake ID cave in Vale of Eternal Blossoms)
    [373] = 10081, -- Greenstone Quarry Lower Quarry(fake ID cave in The Jade Forest)
    [392] = 10082, -- Shrine of Two Moons - The Imperial Mercantile - Top Floor
    [394] = 10083, -- Shrine of Seven Stars - The Imperial Exchange - Top Floor
    [384] = 10084, -- The Deeper - Lower Deep (fake ID cave in Kun-Lai Summit)
}]]

--- This table is generated by the generate_zone_tables.py script - use the table above to add new entries.
--- This table is the inverse of areaIdToUiMapId, without duplicated uiMapId entries.
---@type table<UiMapId, AreaId>
ZoneDB.private.uiMapIdToAreaId = [[return {
    [1] = 14, -- Durotar
    [2] = 365, -- Burning Blade Coven
    [3] = 372, -- Tiragarde Keep
    [4] = 372, -- Tiragarde Keep
    [5] = 817, -- Skull Rock
    [6] = 371, -- Dustwind Cave
    [7] = 215, -- Mulgore
    [8] = 818, -- Palemane Rock
    [9] = 360, -- The Venture Co. Mine
    [10] = 17, -- The Barrens
    [11] = 718, -- Wailing Caverns
    [14] = 45, -- Arathi Highlands
    [15] = 3, -- Badlands
    [16] = 1337, -- Uldaman
    [17] = 4, -- Blasted Lands
    [18] = 85, -- Tirisfal Glades
    [19] = 5511, -- Scarlet Monastery Entrance
    [21] = 130, -- Silverpine Forest
    [22] = 28, -- Western Plaguelands
    [23] = 139, -- Eastern Plaguelands
    [25] = 267, -- Hillsbrad Foothills
    [26] = 47, -- The Hinterlands
    [27] = 1, -- Dun Morogh
    [28] = 800, -- Coldridge Pass
    [29] = 136, -- The Grizzled Den
    [30] = 133, -- New Tinkertown
    [31] = 134, -- Gol'Bolar Quarry
    [32] = 51, -- Searing Gorge
    [33] = 25, -- Blackrock Mountain
    [34] = 25, -- Blackrock Mountain
    [35] = 25, -- Blackrock Mountain
    [36] = 46, -- Burning Steppes
    [37] = 12, -- Elwynn Forest
    [38] = 57, -- Fargodeep Mine
    [39] = 57, -- Fargodeep Mine
    [40] = 54, -- Jasperlode Mine
    [42] = 41, -- Deadwind Pass
    [47] = 10, -- Duskwood
    [48] = 38, -- Loch Modan
    [49] = 44, -- Redridge Mountains
    [50] = 33, -- Northern Stranglethorn
    [51] = 8, -- Swamp of Sorrows
    [52] = 40, -- Westfall
    [53] = 113, -- Gold Coast Quarry
    [54] = 111, -- Jangolode Mine
    [55] = 1581, -- The Deadmines
    [56] = 11, -- Wetlands
    [57] = 141, -- Teldrassil
    [58] = 257, -- Shadowthread Cave
    [59] = 258, -- Fel Rock
    [60] = 262, -- Ban'ethil Barrow Den
    [61] = 262, -- Ban'ethil Barrow Den
    [62] = 148, -- Darkshore
    [63] = 331, -- Ashenvale
    [64] = 400, -- Thousand Needles
    [65] = 406, -- Stonetalon Mountains
    [66] = 405, -- Desolace
    [67] = 2100, -- Maraudon
    [68] = 2100, -- Maraudon
    [69] = 357, -- Feralas
    [70] = 15, -- Dustwallow Marsh
    [71] = 440, -- Tanaris
    [72] = 982, -- The Noxious Lair
    [73] = 981, -- The Gaping Chasm
    [74] = 1941, -- Caverns of Time
    [75] = 1941, -- Caverns of Time
    [76] = 16, -- Azshara
    [77] = 361, -- Felwood
    [78] = 490, -- Un'Goro Crater
    [79] = 540, -- The Slithering Scar
    [80] = 493, -- Moonglade
    [81] = 1377, -- Silithus
    [82] = 3446, -- Twilight's Run
    [83] = 618, -- Winterspring
    [84] = 1519, -- Stormwind City
    [85] = 1637, -- Orgrimmar
    [86] = 5166, -- Orgrimmar
    [87] = 1537, -- Ironforge
    [88] = 1638, -- Thunder Bluff
    [89] = 1657, -- Darnassus
    [91] = 2597, -- Alterac Valley
    [92] = 3277, -- Warsong Gulch
    [93] = 3358, -- Arathi Basin
    [94] = 3430, -- Eversong Woods
    [95] = 3433, -- Ghostlands
    [96] = 3510, -- Amani Catacombs
    [97] = 3524, -- Azuremyst Isle
    [98] = 3569, -- Tides' Hollow
    [99] = 3572, -- Stillpine Hold
    [100] = 3483, -- Hellfire Peninsula
    [102] = 3521, -- Zangarmarsh
    [103] = 3557, -- The Exodar
    [104] = 3520, -- Shadowmoon Valley
    [105] = 3522, -- Blade's Edge Mountains
    [106] = 3525, -- Bloodmyst Isle
    [107] = 3518, -- Nagrand
    [108] = 3519, -- Terokkar Forest
    [109] = 3523, -- Netherstorm
    [110] = 3487, -- Silvermoon City
    [111] = 3703, -- Shattrath City
    [112] = 3820, -- Eye of the Storm
    [114] = 3537, -- Borean Tundra
    [115] = 65, -- Dragonblight
    [116] = 394, -- Grizzly Hills
    [117] = 495, -- Howling Fjord
    [118] = 210, -- Icecrown
    [119] = 3711, -- Sholazar Basin
    [120] = 67, -- The Storm Peaks
    [121] = 66, -- Zul'Drak
    [122] = 4080, -- Isle of Quel'Danas
    [123] = 4197, -- Wintergrasp
    [124] = 4298, -- Plaguelands: The Scarlet Enclave
    [125] = 4395, -- Dalaran - (Dungeon/Raid)
    [126] = 4395, -- Dalaran - (Dungeon/Raid)
    [127] = 2817, -- Crystalsong Forest
    [128] = 4384, -- Strand of the Ancients
    [129] = 4120, -- The Nexus - (Dungeon/Raid)
    [130] = 4100, -- The Culling of Stratholme - (Dungeon/Raid)
    [131] = 4100, -- The Culling of Stratholme - (Dungeon/Raid)
    [132] = 4494, -- Ahn'kahet: The Old Kingdom - (Dungeon/Raid)
    [133] = 206, -- Utgarde Keep - (Dungeon/Raid)
    [134] = 206, -- Utgarde Keep - (Dungeon/Raid)
    [135] = 206, -- Utgarde Keep - (Dungeon/Raid)
    [136] = 1196, -- Utgarde Pinnacle - (Dungeon/Raid)
    [137] = 1196, -- Utgarde Pinnacle - (Dungeon/Raid)
    [138] = 4272, -- Halls of Lightning - (Dungeon/Raid)
    [139] = 4272, -- Halls of Lightning - (Dungeon/Raid)
    [140] = 4264, -- Halls of Stone - (Dungeon/Raid)
    [141] = 4500, -- The Eye of Eternity - (Dungeon/Raid)
    [142] = 4228, -- The Oculus
    [143] = 4228, -- The Oculus - (Dungeon/Raid)
    [144] = 4228, -- The Oculus - (Dungeon/Raid)
    [145] = 4228, -- The Oculus - (Dungeon/Raid)
    [146] = 4228, -- The Oculus - (Dungeon/Raid)
    [147] = 4273, -- Ulduar - (Dungeon/Raid)
    [148] = 4273, -- Ulduar - (Dungeon/Raid)
    [149] = 4273, -- Ulduar - (Dungeon/Raid)
    [150] = 4273, -- Ulduar - (Dungeon/Raid)
    [151] = 4273, -- Ulduar - (Dungeon/Raid)
    [152] = 4273, -- Ulduar - (Dungeon/Raid)
    [153] = 4416, -- Gundrak
    [154] = 4375, -- Gundrak - (Dungeon/Raid)
    [155] = 4493, -- The Obsidian Sanctum
    [156] = 4603, -- Vault of Archavon - (Dungeon/Raid)
    [157] = 3477, -- Azjol-Nerub - (Dungeon/Raid)
    [158] = 3477, -- Azjol-Nerub - (Dungeon/Raid)
    [159] = 3477, -- Azjol-Nerub - (Dungeon/Raid)
    [160] = 4196, -- Drak'Tharon Keep - (Dungeon/Raid)
    [161] = 4196, -- Drak'Tharon Keep - (Dungeon/Raid)
    [162] = 3456, -- Naxxramas - (Dungeon/Raid)
    [163] = 3456, -- Naxxramas - (Dungeon/Raid)
    [164] = 3456, -- Naxxramas - (Dungeon/Raid)
    [165] = 3456, -- Naxxramas - (Dungeon/Raid)
    [166] = 3456, -- Naxxramas - (Dungeon/Raid)
    [167] = 3456, -- Naxxramas - (Dungeon/Raid)
    [168] = 4415, -- The Violet Hold - (Dungeon/Raid)
    [169] = 4710, -- Isle of Conquest
    [170] = 4742, -- Hrothgar's Landing
    [171] = 4723, -- Trial of the Champion - (Dungeon/Raid)
    [172] = 4722, -- Trial of the Crusader - (Dungeon/Raid)
    [173] = 4722, -- Trial of the Crusader - (Dungeon/Raid)
    [174] = 4720, -- The Lost Isles
    [175] = 4778, -- Kaja'mite Cavern
    [176] = 4911, -- Volcanoth's Lair
    [177] = 4924, -- Gallywix Labor Mine
    [178] = 4924, -- Gallywix Labor Mine
    [179] = 4714, -- Gilneas
    [180] = 4732, -- Emberstone Mine
    [181] = 4817, -- Greymane Manor
    [182] = 4817, -- Greymane Manor
    [183] = 4809, -- The Forge of Souls - (Dungeon/Raid)
    [184] = 4813, -- Pit of Saron
    [185] = 4820, -- Halls of Reflection - (Dungeon/Raid)
    [186] = 4522, -- Icecrown Citadel - (Dungeon/Raid)
    [187] = 4522, -- Icecrown Citadel - (Dungeon/Raid)
    [188] = 4522, -- Icecrown Citadel - (Dungeon/Raid)
    [189] = 4522, -- Icecrown Citadel - (Dungeon/Raid)
    [190] = 4522, -- Icecrown Citadel - (Dungeon/Raid)
    [191] = 4522, -- Icecrown Citadel - (Dungeon/Raid)
    [192] = 4522, -- Icecrown Citadel - (Dungeon/Raid)
    [193] = 4522, -- Icecrown Citadel - (Dungeon/Raid)
    [194] = 4737, -- Kezan
    [195] = 4766, -- Kaja'mine
    [196] = 4766, -- Kaja'mine
    [197] = 4766, -- Kaja'mine
    [198] = 616, -- Mount Hyjal
    [199] = 4709, -- Southern Barrens
    [200] = 4987, -- The Ruby Sanctum
    [201] = 4815, -- Kelp'thar Forest
    [202] = 4755, -- Gilneas City
    [203] = 5146, -- Vashj'ir
    [204] = 5145, -- Abyssal Depths
    [205] = 5144, -- Shimmering Expanse
    [206] = 5031, -- Twin Peaks
    [207] = 5042, -- Deepholm
    [210] = 5287, -- The Cape of Stranglethorn
    [213] = 2437, -- Ragefire Chasm - (Dungeon/Raid)
    [217] = 4706, -- Ruins of Gilneas
    [218] = 5351, -- Ruins of Gilneas City
    [219] = 1176, -- Zul'Farrak
    [220] = 1477, -- The Temple of Atal'Hakkar - (Dungeon/Raid)
    [221] = 719, -- Blackfathom Deeps - (Dungeon/Raid)
    [222] = 719, -- Blackfathom Deeps - (Dungeon/Raid)
    [223] = 719, -- Blackfathom Deeps - (Dungeon/Raid)
    [224] = 5339, -- Stranglethorn Vale
    [225] = 717, -- The Stockade - (Dungeon/Raid)
    [226] = 721, -- Gnomeregan - (Dungeon/Raid)
    [227] = 721, -- Gnomeregan - (Dungeon/Raid)
    [228] = 721, -- Gnomeregan - (Dungeon/Raid)
    [229] = 721, -- Gnomeregan - (Dungeon/Raid)
    [230] = 1337, -- Uldaman - (Dungeon/Raid)
    [231] = 1337, -- Uldaman - (Dungeon/Raid)
    [232] = 2717, -- Molten Core - (Dungeon/Raid)
    [233] = 1977, -- Zul'Gurub
    [234] = 2557, -- Dire Maul
    [235] = 2557, -- Dire Maul - (Dungeon/Raid)
    [236] = 2557, -- Dire Maul - (Dungeon/Raid)
    [237] = 2557, -- Dire Maul - (Dungeon/Raid)
    [238] = 2557, -- Dire Maul - (Dungeon/Raid)
    [239] = 2557, -- Dire Maul - (Dungeon/Raid)
    [240] = 2557, -- Dire Maul - (Dungeon/Raid)
    [241] = 4922, -- Twilight Highlands
    [242] = 1584, -- Blackrock Depths - (Dungeon/Raid)
    [243] = 1584, -- Blackrock Depths - (Dungeon/Raid)
    [244] = 5095, -- Tol Barad
    [245] = 5389, -- Tol Barad Peninsula
    [246] = 3714, -- The Shattered Halls - (Dungeon/Raid)
    [247] = 3429, -- Ruins of Ahn'Qiraj
    [248] = 2159, -- Onyxia's Lair - (Dungeon/Raid)
    [249] = 5034, -- Uldum
    [250] = 1583, -- Blackrock Spire - (Dungeon/Raid)
    [251] = 1583, -- Blackrock Spire - (Dungeon/Raid)
    [252] = 1583, -- Blackrock Spire - (Dungeon/Raid)
    [253] = 1583, -- Blackrock Spire - (Dungeon/Raid)
    [254] = 1583, -- Blackrock Spire - (Dungeon/Raid)
    [255] = 1583, -- Blackrock Spire - (Dungeon/Raid)
    [256] = 3790, -- Auchenai Crypts - (Dungeon/Raid)
    [257] = 3790, -- Auchenai Crypts - (Dungeon/Raid)
    [258] = 3791, -- Sethekk Halls - (Dungeon/Raid)
    [259] = 3791, -- Sethekk Halls - (Dungeon/Raid)
    [260] = 3789, -- Shadow Labyrinth - (Dungeon/Raid)
    [261] = 3713, -- The Blood Furnace - (Dungeon/Raid)
    [262] = 3716, -- The Underbog - (Dungeon/Raid)
    [263] = 3715, -- The Steamvault - (Dungeon/Raid)
    [264] = 3715, -- The Steamvault - (Dungeon/Raid)
    [265] = 3717, -- The Slave Pens - (Dungeon/Raid)
    [266] = 3847, -- The Botanica - (Dungeon/Raid)
    [267] = 3849, -- The Mechanar - (Dungeon/Raid)
    [268] = 3849, -- The Mechanar - (Dungeon/Raid)
    [269] = 3846, -- The Arcatraz - (Dungeon/Raid)
    [270] = 3846, -- The Arcatraz - (Dungeon/Raid)
    [271] = 3846, -- The Arcatraz - (Dungeon/Raid)
    [272] = 3792, -- Mana-Tombs - (Dungeon/Raid)
    [273] = 2366, -- The Black Morass
    [274] = 2367, -- Old Hillsbrad Foothills
    [275] = 5449, -- The Battle for Gilneas
    [276] = 5416, -- The Maelstrom
    [277] = 5396, -- Lost City of the Tol'vir
    [279] = 718, -- Wailing Caverns - (Dungeon/Raid)
    [280] = 2100, -- Maraudon - (Dungeon/Raid)
    [281] = 2100, -- Maraudon - (Dungeon/Raid)
    [282] = 5399, -- Baradin Hold - (Dungeon/Raid)
    [283] = 4926, -- Blackrock Caverns - (Dungeon/Raid)
    [284] = 4926, -- Blackrock Caverns - (Dungeon/Raid)
    [285] = 5094, -- Blackwing Descent - (Dungeon/Raid)
    [286] = 5094, -- Blackwing Descent - (Dungeon/Raid)
    [287] = 2677, -- Blackwing Lair - (Dungeon/Raid)
    [288] = 2677, -- Blackwing Lair - (Dungeon/Raid)
    [289] = 2677, -- Blackwing Lair - (Dungeon/Raid)
    [290] = 2677, -- Blackwing Lair - (Dungeon/Raid)
    [291] = 1581, -- The Deadmines - (Dungeon/Raid)
    [292] = 1581, -- The Deadmines - (Dungeon/Raid)
    [293] = 1037, -- Grim Batol - (Dungeon/Raid)
    [294] = 5334, -- The Bastion of Twilight - (Dungeon/Raid)
    [295] = 5334, -- The Bastion of Twilight - (Dungeon/Raid)
    [296] = 5334, -- The Bastion of Twilight - (Dungeon/Raid)
    [297] = 4945, -- Halls of Origination - (Dungeon/Raid)
    [298] = 4945, -- Halls of Origination - (Dungeon/Raid)
    [299] = 4945, -- Halls of Origination - (Dungeon/Raid)
    [300] = 722, -- Razorfen Downs - (Dungeon/Raid)
    [301] = 491, -- Razorfen Kraul - (Dungeon/Raid)
    [302] = 796, -- Scarlet Monastery - (Dungeon/Raid)
    [303] = 796, -- Scarlet Monastery - (Dungeon/Raid)
    [304] = 796, -- Scarlet Monastery - (Dungeon/Raid)
    [305] = 796, -- Scarlet Monastery - (Dungeon/Raid)
    [306] = 2057, -- ScholomanceOLD - (Dungeon/Raid)
    [307] = 2057, -- ScholomanceOLD - (Dungeon/Raid)
    [308] = 2057, -- ScholomanceOLD - (Dungeon/Raid)
    [309] = 2057, -- ScholomanceOLD - (Dungeon/Raid)
    [310] = 209, -- Shadowfang Keep - (Dungeon/Raid)
    [311] = 209, -- Shadowfang Keep - (Dungeon/Raid)
    [312] = 209, -- Shadowfang Keep - (Dungeon/Raid)
    [313] = 209, -- Shadowfang Keep - (Dungeon/Raid)
    [314] = 209, -- Shadowfang Keep - (Dungeon/Raid)
    [315] = 209, -- Shadowfang Keep - (Dungeon/Raid)
    [316] = 209, -- Shadowfang Keep - (Dungeon/Raid)
    [317] = 2017, -- Stratholme - (Dungeon/Raid)
    [318] = 2017, -- Stratholme - (Dungeon/Raid)
    [319] = 3428, -- Ahn'Qiraj - (Dungeon/Raid)
    [320] = 3428, -- Ahn'Qiraj - (Dungeon/Raid)
    [321] = 3428, -- Ahn'Qiraj - (Dungeon/Raid)
    [322] = 5004, -- Throne of the Tides - (Dungeon/Raid)
    [323] = 5004, -- Throne of the Tides - (Dungeon/Raid)
    [324] = 5088, -- The Stonecore - (Dungeon/Raid)
    [325] = 5035, -- The Vortex Pinnacle - (Dungeon/Raid)
    [327] = 5695, -- Ahn'Qiraj: The Fallen Kingdom
    [328] = 5638, -- Throne of the Four Winds - (Dungeon/Raid)
    [329] = 3606, -- Hyjal Summit
    [330] = 3618, -- Gruul's Lair - (Dungeon/Raid)
    [331] = 3836, -- Magtheridon's Lair - (Dungeon/Raid)
    [332] = 3607, -- Serpentshrine Cavern - (Dungeon/Raid)
    [333] = 3805, -- Zul'Aman
    [334] = 3842, -- Tempest Keep - (Dungeon/Raid)
    [335] = 4075, -- Sunwell Plateau - (Dungeon/Raid)
    [336] = 4075, -- Sunwell Plateau - (Dungeon/Raid)
    [337] = 1977, -- Zul'Gurub
    [338] = 5733, -- Molten Front
    [339] = 3959, -- Black Temple - (Dungeon/Raid)
    [340] = 3959, -- Black Temple - (Dungeon/Raid)
    [341] = 3959, -- Black Temple - (Dungeon/Raid)
    [342] = 3959, -- Black Temple - (Dungeon/Raid)
    [343] = 3959, -- Black Temple - (Dungeon/Raid)
    [344] = 3959, -- Black Temple - (Dungeon/Raid)
    [345] = 3959, -- Black Temple - (Dungeon/Raid)
    [346] = 3959, -- Black Temple - (Dungeon/Raid)
    [347] = 3562, -- Hellfire Ramparts - (Dungeon/Raid)
    [348] = 4095, -- Magisters' Terrace - (Dungeon/Raid)
    [349] = 4095, -- Magisters' Terrace - (Dungeon/Raid)
    [350] = 2562, -- Karazhan - (Dungeon/Raid)
    [351] = 2562, -- Karazhan - (Dungeon/Raid)
    [352] = 2562, -- Karazhan - (Dungeon/Raid)
    [353] = 2562, -- Karazhan - (Dungeon/Raid)
    [354] = 2562, -- Karazhan - (Dungeon/Raid)
    [355] = 2562, -- Karazhan - (Dungeon/Raid)
    [356] = 2562, -- Karazhan - (Dungeon/Raid)
    [357] = 2562, -- Karazhan - (Dungeon/Raid)
    [358] = 2562, -- Karazhan - (Dungeon/Raid)
    [359] = 2562, -- Karazhan - (Dungeon/Raid)
    [360] = 2562, -- Karazhan - (Dungeon/Raid)
    [361] = 2562, -- Karazhan - (Dungeon/Raid)
    [362] = 2562, -- Karazhan - (Dungeon/Raid)
    [363] = 2562, -- Karazhan - (Dungeon/Raid)
    [364] = 2562, -- Karazhan - (Dungeon/Raid)
    [365] = 2562, -- Karazhan - (Dungeon/Raid)
    [366] = 2562, -- Karazhan - (Dungeon/Raid)
    [367] = 5723, -- Firelands - (Dungeon/Raid)
    [368] = 5723, -- Firelands - (Dungeon/Raid)
    [369] = 5723, -- Firelands - (Dungeon/Raid)
    [370] = 4120, -- The Nexus - (Dungeon/Raid)
    [371] = 5785, -- The Jade Forest
    [372] = 5955, -- Greenstone Quarry
    [374] = 6512, -- The Widow's Wail
    [375] = 6513, -- Oona Kagu
    [376] = 5805, -- Valley of the Four Winds
    [377] = 6466, -- Cavern of Endless Echoes
    [378] = 5736, -- The Wandering Isle
    [379] = 5841, -- Kun-Lai Summit
    [380] = 6389, -- Howlingwind Cavern
    [381] = 6099, -- Pranksters' Hollow
    [382] = 6088, -- Knucklethump Hole
    [383] = 6084, -- The Deeper
    [385] = 6201, -- Tomb of Conquerors
    [386] = 6619, -- Ruins of Korune
    [387] = 6619, -- Ruins of Korune
    [388] = 5842, -- Townlong Steppes
    [389] = 6213, -- Niuzao Catacombs
    [390] = 5840, -- Vale of Eternal Blossoms
    [391] = 6141, -- Shrine of Two Moons - Hall of the Crescent Moon - Ground Floor
    [393] = 6142, -- Shrine of Seven Stars - Hall of the Crescent Moon - Ground Floor
    [395] = 6074, -- Guo-Lai Halls
    [397] = 5799, -- Eye of the Storm
    [398] = 5788, -- Well of Eternity
    [399] = 5844, -- Hour of Twilight - (Dungeon/Raid)
    [400] = 5844, -- Hour of Twilight - (Dungeon/Raid)
    [401] = 5789, -- End Time - (Dungeon/Raid)
    [402] = 5793, -- End Time - (Dungeon/Raid)
    [403] = 5790, -- End Time - (Dungeon/Raid)
    [404] = 5792, -- End Time - (Dungeon/Raid)
    [405] = 5794, -- End Time - (Dungeon/Raid)
    [406] = 5795, -- End Time - (Dungeon/Raid)
    [407] = 5861, -- Darkmoon Island
    [409] = 5892, -- Dragon Soul - (Dungeon/Raid)
    [410] = 5892, -- Dragon Soul - (Dungeon/Raid)
    [411] = 5892, -- Dragon Soul - (Dungeon/Raid)
    [412] = 5892, -- Dragon Soul - (Dungeon/Raid)
    [413] = 5892, -- Dragon Soul - (Dungeon/Raid)
    [414] = 5892, -- Dragon Soul - (Dungeon/Raid)
    [415] = 5892, -- Dragon Soul - (Dungeon/Raid)
    [416] = 6040, -- Dustwallow Marsh
    [417] = 6051, -- Temple of Kotmogu
    [418] = 6134, -- Krasarang Wilds
    [419] = 6609, -- Ruins of Ogudei
    [420] = 6609, -- Ruins of Ogudei
    [421] = 6609, -- Ruins of Ogudei
    [422] = 6138, -- Dread Wastes
    [423] = 6126, -- Silvershard Mines - (Dungeon/Raid)
    [425] = 6170, -- Northshire
    [426] = 34, -- Echo Ridge Mine
    [427] = 6176, -- Coldridge Valley
    [428] = 6137, -- Frostmane Hovel
    [429] = 5956, -- Temple of the Jade Serpent - (Dungeon/Raid)
    [430] = 5956, -- Temple of the Jade Serpent - (Dungeon/Raid)
    [431] = 6052, -- Scarlet Halls - (Dungeon/Raid)
    [433] = 6006, -- The Veiled Stair
    [434] = 6376, -- The Ancient Passage
    [435] = 6384, -- Scarlet Monastery - (Dungeon/Raid)
    [436] = 6386, -- Scarlet Monastery - (Dungeon/Raid)
    [437] = 5976, -- Gate of the Setting Sun - (Dungeon/Raid)
    [438] = 5976, -- Gate of the Setting Sun - (Dungeon/Raid)
    [439] = 5963, -- Stormstout Brewery - (Dungeon/Raid)
    [440] = 5963, -- Stormstout Brewery - (Dungeon/Raid)
    [441] = 5963, -- Stormstout Brewery - (Dungeon/Raid)
    [442] = 5963, -- Stormstout Brewery - (Dungeon/Raid)
    [443] = 5918, -- Shado-Pan Monastery - (Dungeon/Raid)
    [444] = 5918, -- Shado-Pan Monastery - (Dungeon/Raid)
    [445] = 5918, -- Shado-Pan Monastery - (Dungeon/Raid)
    [446] = 5918, -- Shado-Pan Monastery - (Dungeon/Raid)
    [447] = 6101, -- A Brewing Storm
    [448] = 6209, -- The Jade Forest
    [449] = 6449, -- Temple of Kotmogu
    [450] = 6309, -- Unga Ingoo
    [451] = 6328, -- Assault on Zan'vess
    [452] = 6426, -- Brewmoon Festival
    [456] = 6067, -- Terrace of Endless Spring
    [457] = 6214, -- Siege of Niuzao Temple - (Dungeon/Raid)
    [458] = 6214, -- Siege of Niuzao Temple - (Dungeon/Raid)
    [459] = 6214, -- Siege of Niuzao Temple - (Dungeon/Raid)
    [460] = 6450, -- Shadowglen
    [461] = 6451, -- Valley of Trials
    [462] = 6452, -- Camp Narache
    [463] = 6453, -- Echo Isles
    [464] = 4913, -- Spitescale Cavern
    [465] = 6454, -- Deathknell
    [466] = 155, -- Night Web's Hollow
    [467] = 6455, -- Sunstrider Isle
    [468] = 6456, -- Ammen Vale
    [469] = 6457, -- New Tinkertown
    [470] = 135, -- Frostmane Hold
    [471] = 6125, -- Mogu'shan Vaults - (Dungeon/Raid)
    [472] = 6125, -- Mogu'shan Vaults - (Dungeon/Raid)
    [473] = 6125, -- Mogu'shan Vaults - (Dungeon/Raid)
    [474] = 6297, -- Heart of Fear - (Dungeon/Raid)
    [475] = 6297, -- Heart of Fear - (Dungeon/Raid)
    [476] = 6066, -- Scholomance - (Dungeon/Raid)
    [480] = 6852, -- Proving Grounds - (Dungeon/Raid)
    [481] = 6208, -- Crypt of Forgotten Kings - (Dungeon/Raid)
    [482] = 6208, -- Crypt of Forgotten Kings - (Dungeon/Raid)
    [483] = 6500, -- Dustwallow Marsh
    [486] = 6575, -- Krasarang Wilds
    [487] = 6616, -- A Little Patience
    [488] = 6565, -- Dagger in the Dark
    [489] = 6565, -- Dagger in the Dark - (Dungeon/Raid)
    [490] = 6613, -- Black Temple - (Dungeon/Raid)
    [491] = 3959, -- Black Temple - (Dungeon/Raid)
    [492] = 3959, -- Black Temple - (Dungeon/Raid)
    [493] = 3959, -- Black Temple - (Dungeon/Raid)
    [494] = 3959, -- Black Temple - (Dungeon/Raid)
    [495] = 3959, -- Black Temple - (Dungeon/Raid)
    [496] = 3959, -- Black Temple - (Dungeon/Raid)
    [497] = 3959, -- Black Temple - (Dungeon/Raid)
    [498] = 6615, -- Krasarang Wilds
    [499] = 2257, -- Deeprun Tram - (Dungeon/Raid)
    [500] = 2257, -- Deeprun Tram - (Dungeon/Raid)
    [501] = 4395, -- Dalaran - (Dungeon/Raid)
    [502] = 4395, -- Dalaran - (Dungeon/Raid)
    [503] = 6298, -- Brawl'gar Arena - (Dungeon/Raid)
    [504] = 6507, -- Isle of Thunder
    [505] = 6589, -- Lightning Vein Mine
    [506] = 6592, -- The Swollen Vault
    [507] = 6661, -- Isle of Giants
    [508] = 6622, -- Throne of Thunder - (Dungeon/Raid)
    [509] = 6622, -- Throne of Thunder - (Dungeon/Raid)
    [510] = 6622, -- Throne of Thunder - (Dungeon/Raid)
    [511] = 6622, -- Throne of Thunder - (Dungeon/Raid)
    [512] = 6622, -- Throne of Thunder - (Dungeon/Raid)
    [513] = 6622, -- Throne of Thunder - (Dungeon/Raid)
    [514] = 6622, -- Throne of Thunder - (Dungeon/Raid)
    [515] = 6622, -- Throne of Thunder - (Dungeon/Raid)
    [516] = 6677, -- Isle of Thunder
    [517] = 6589, -- Lightning Vein Mine
    [518] = 6707, -- Thunder King's Citadel - (Dungeon/Raid)
    [519] = 6665, -- Deepwind Gorge
    [520] = 6733, -- Vale of Eternal Blossoms
    [521] = 5840, -- Vale of Eternal Blossoms - (Dungeon/Raid)
    [522] = 6731, -- The Secrets of Ragefire - (Dungeon/Raid)
    [523] = 6678, -- Dun Morogh
    [524] = 6567, -- Battle on the High Seas
    [554] = 6757, -- Timeless Isle
    [555] = 6780, -- Cavern of Lost Spirits
    [556] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [557] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [558] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [559] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [560] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [561] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [562] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [563] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [564] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [565] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [566] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [567] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [568] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [569] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [570] = 6738, -- Siege of Orgrimmar - (Dungeon/Raid)
    [571] = 6771, -- Celestial Tournament
    [987] = 676, -- Outland
    [998] = 1497, -- Undercity
    [1467] = 676, -- Outland
    [2104] = 14288, -- Wintergrasp
}]]
