---@class QuestieWotlkNpcFixes
local QuestieWotlkNpcFixes = QuestieLoader:CreateModule("QuestieWotlkNpcFixes")

---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")
---@type Phasing
local Phasing = QuestieLoader:ImportModule("Phasing")

function QuestieWotlkNpcFixes:Load()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs
    local waypointPresets = QuestieDB.waypointPresets
    local phases = Phasing.phases
    local npcFlags = QuestieDB.npcFlags

    return {
        [376] = { -- High Priestess Laurena
            [npcKeys.questStarts] = {5634,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166},
            [npcKeys.questEnds] = {5640,5678,64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164},
        },
        [658] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{29.87,71.87}}},
        },
        [914] = { -- Ander Germaine
            [npcKeys.questStarts] = {64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166},
            [npcKeys.questEnds] = {64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164},
        },
        [928] = { -- Lord Grayson Shadowbreaker
            [npcKeys.questStarts] = {3000,7637,7640,7641,7643,7646,7647,7666,8415,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166},
            [npcKeys.questEnds] = {7638,7639,7640,7644,7646,7648,7666,7670,64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164},
        },
        [1105] = {
            [npcKeys.spawns] = {[zoneIDs.LOCH_MODAN]={{36.99,47.02}}},
        },
        [1365] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE]={{30.26,59.38}}},
        },
        [1721] = {
            [npcKeys.waypoints] = {[zoneIDs.STORMWIND_CITY]={{{73.27,55.49},{73.73,55.09},{75.57,56.13},{75.54,57.84},{75.91,58.32},{76.11,59.22},{76.37,59.7},{76.37,60.23},{76.64,60.47},{76.03,60.65},{75.74,62.34},{75.83,62.98},{76.46,63.65},{76.3,63.4},{75.79,63.03},{75.78,62.88},{72.89,62.06},{71.71,60},{71.21,59.16},{71.13,58.79},{70.6,58.07},{70.49,57.83},{70.71,57.55},{71.19,56.65},{72.54,55.16},{72.89,54.98},{73.27,55.49}}}},
        },
        [1748] = { -- Highlord Bolvar Fordragon
            [npcKeys.questStarts] = {6182,6501,7496,7782},
        },
        [1755] = {
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{71.97,35.39}}},
        },
        [2079] = {
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL] = {{58.62,44.71}}},
        },
        [2142] = { -- Watcher Callahan
            [npcKeys.questStarts] = {},
        },
        [2425] = { -- Varimathras
            [npcKeys.questStarts] = {1048,5725,6145},
            [npcKeys.questEnds] = {550,1048,1978,5725,6144},
        },
        [3030] = { -- Siln Skychaser
            [npcKeys.questStarts] = {14100},
        },
        [3036] = { -- Kym Wildmane
            [npcKeys.questStarts] = {64049,64051,64053,64128,64217,70761,70764,70765,70865,78151,78158,78167,78168},
            [npcKeys.questEnds] = {64047,64049,64051,64053,70761,70762,70764,70765,78138,78151,78158,78167},
        },
        [3189] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{47,53.6}}},
        },
        [3190] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{42.1,15.0}}},
        },
        [3324] = { -- Grol'dar
            [npcKeys.questStarts] = {64048,64050,64052,64063,64064,70734,70735,70736,70737,70865,70869,78167,78168},
            [npcKeys.questEnds] = {64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167},
        },
        [3328] = { -- Ormok
            [npcKeys.questStarts] = {6681,8233,64048,64050,64052,64063,64064,70734,70735,70736,70737,70865,70869,78167,78168},
            [npcKeys.questEnds] = {64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167},
        },
        [3344] = { -- Kardris Dreamseeker
            [npcKeys.questStarts] = {64048,64050,64052,64063,64064,70734,70735,70736,70737,70865,70869,78167,78168},
            [npcKeys.questEnds] = {64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167},
        },
        [3353] = { -- Grezz Ragefist
            [npcKeys.questStarts] = {64048,64050,64052,64063,64064,70734,70735,70736,70737,70869,78167,78168},
            [npcKeys.questEnds] = {64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167},
        },
        [3406] = { -- Xor'juul
            [npcKeys.questStarts] = {64048,64050,64052,64063,64064,70734,70735,70736,70737,70865,70869,78167,78168},
            [npcKeys.questEnds] = {64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167},
        },
        [3996] = {
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{35.77,49.1}}},
        },
        [4076] = {
            [npcKeys.spawns] = {[406]={{34.88,59.85},{31.82,59.91},{31.28,72.32},{30.51,74.54},{34.16,71.52}},[405]={{53.97,67.86},{68.35,49.33},{53.61,9.2},{64.06,23.28},{67.08,53.35},{41.45,85.11},{49.77,47.75},{45.09,36.34},{53.33,85.01},{50.6,27.03},{43.48,73.69},{67.95,81.93},{70.57,54.45},{38.03,75.25},{61.53,73.65},{77.8,43.63},{49.56,6.81},{77.07,52.31},{56.5,84.65},{64.05,33.14},{74.01,30.74}},[4100]={{55.3,2.04},{47.73,9.76},{42.87,14.73},{55.76,1.55},{42.95,14.23},{52.98,1.42},{47.6,9.6},{54.6,2.89}},[3792]={{-1,-1}},[3791]={{-1,-1}},[28]={{49.94,57.65},{45.49,21.05},{36.45,78.43},{50.31,60.09},{43.84,11.46},{54.35,34.13},{51.83,82.05},{48.94,45.56},{54.72,26.32},{51.69,39.66},{50.77,23.47},{49.57,50.1},{53.81,25.12},{42.2,19.96},{40.4,57.36},{48.59,42.98}},[495]={{32.96,10.34},{35.88,12.33},{36.5,14.89},{33.5,10.36},{35.7,15.91},{36.93,9.4},{36.56,11.4},{36.29,15.45}},[2557]={{-1,-1}},[2100]={{-1,-1}},[1583]={{-1,-1}},[722]={{-1,-1}},[zoneIDs.AZJOL_NERUB]={{-1,-1}},[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{74.05,76.21},{55.47,54.94},{55.12,40.53},{77.15,43.11},{60.57,29.98},{69.92,43.19},{63.7,60.09},{80.08,50.93},{60.35,78.57},{59.97,65.8},{82.95,56.71},{57.75,69.05},{77.61,53.91},{53.33,59.0},{84.06,64.27}},[4812]={{34.0,73.87},{34.11,74.39},{33.91,79.81},{34.47,75.32}}},
        },
        [4455] = { -- Red Jack Flint
            [npcKeys.questStarts] = {1132},
        },
        [4456] = { -- Fiora Longears
            [npcKeys.questEnds] = {1132,1135},
        },
        [5111] = {
            [npcKeys.questStarts] = {3790,8353},
        },
        [5149] = { -- Brandur Ironhammer
            [npcKeys.questStarts] = {2999,3681,4486,7670,8415},
        },
        [5495] = { -- Ursula Deline
            [npcKeys.questStarts] = {64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166},
            [npcKeys.questEnds] = {64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164},
        },
        [5497] = { -- Jennea Cannon
            [npcKeys.questStarts] = {1861,1920,1921,1939,1947,1953,2861,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166},
            [npcKeys.questEnds] = {1860,1861,1919,1920,64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164},
        },
        [5505] = { -- Theridran
            [npcKeys.questStarts] = {5924,9063,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166},
            [npcKeys.questEnds] = {64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164},
        },
        [5515] = { -- Einris Brightspear
            [npcKeys.questStarts] = {6073,6076,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166},
            [npcKeys.questEnds] = {64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164},
        },
        [5885] = { -- Deino
            [npcKeys.questStarts] = {1944,1945,1947,2861,64048,64050,64052,64063,64064,70734,70735,70736,70737,70865,70869,78167,78168},
            [npcKeys.questEnds] = {1943,1944,64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167},
        },
        [5994] = { -- Zayus
            [npcKeys.questStarts] = {64048,64050,64052,64063,64064,70734,70735,70736,70737,70865,70869,78167,78168},
            [npcKeys.questEnds] = {64046,64048,64050,64052,70396,70734,70735,70736,70869,78137,78167},
        },
        [6179] = { -- Tiza Battleforge
            [npcKeys.questStarts] = {1645,1647,1779,1789,1794,4485},
        },
        [6467] = { -- Mennet Carkad
            [npcKeys.questStarts] = {1998,1999,2019,2378,6681,14418,14419,14420},
        },
        [6740] = {
            [npcKeys.questStarts] = {3789,8356},
        },
        [6826] = { -- Talvash del Kissel
            [npcKeys.questStarts] = {2199,2200,2361,2948,3375,8355},
        },
        [7009] = { -- Arantir
            [npcKeys.questStarts] = {2358},
        },
        [7750] = { -- Corporal Thund Splithoof
            [npcKeys.questEnds] = {2702},
        },
        [8125] = { -- Dirge Quikcleave
            [npcKeys.questStarts] = {6610,8585,8586,8587,13825},
            [npcKeys.questEnds] = {6610,6611,6612,8584,8585,8586,13825},
        },
        [8530] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS]={{11.2,27.8},{11.4,27.2},{11.6,27.8},{12.2,27.4},{13.4,26.2},{13.4,26.8},{13.8,30},{14.4,26.2},{14.4,27},{14.4,27.8},{14.6,24.4},{14.6,27.2},{14.6,27.8},{14.8,24.6},{15,29.2},{15,29.6},{16,26.6},{17,26.4},{17.2,27},{17.6,25.4},{17.6,26.4},{18.2,24.2},{18.8,19.6},{18.8,21.8},{18.8,26.6},{19.2,25.2},{19.4,24},{19.6,20.6},{19.6,23.4},{19.8,15.6},{20.4,23.8},{20.6,19.2},{20.8,23.8},{21,25.6},{21.2,16.4},{21.2,20.4},{21.4,18},{21.4,25},{21.4,27.8},{21.8,28},{22,33},{22.4,23},{22.4,24.2},{22.4,24.8},{22.6,22.8},{22.8,25.4},{22.8,33.8},{23,18.6},{23,25.8},{23,27.8},{23.6,33.8},{23.8,21.8},{24,26.6},{24,29.6},{24.4,19.8},{24.6,27.4},{25,20.6},{25,21.8},{25.8,21.2},{25.8,21.6},{26.2,25.6},{26.4,20.4},{26.4,27.6},{26.6,20.2},{26.6,28.4},{26.8,29},{27,29.8},{27.4,26.6},{28,21.2},{28,21.8},{28,28.4},{28,28.6},{28.4,18.4},{29.4,18.2},{29.4,21.6},{29.4,23},{29.4,26.2},{29.6,18.4},{29.6,21.8},{29.8,24.2},{30.4,20.6},{30.4,26.2},{30.4,29.4},{30.4,31.4},{30.4,31.6},{30.8,25.2},{30.8,30.2},{31,21.4},{31,21.8},{31,24.4},{31,28},{31.2,19.2},{31.4,20},{31.6,18.8},{31.6,28},{31.8,27.4},{31.8,28.8},{32,25.6},{32.2,16.2},{32.2,18.4},{32.2,20.8},{32.2,31.6},{32.4,24.6},{32.6,21.6},{32.6,23.2},{32.6,26.4},{32.6,32},{32.8,18.2},{33,17.2},{33,19},{33,20.6},{33,24.8},{33.4,20.4},{33.6,28.8},{33.6,29.8},{33.6,31.6},{33.8,18.2},{34,30.8},{34.6,17.2},{34.6,17.8},{34.8,22.2},{35,31.2},{35.2,31.8},{35.4,19.6},{35.6,20.6},{35.8,26.8},{36,27.6},{36.2,16.4},{36.4,16.8},{36.6,25.8},{36.6,30.8},{36.8,16.2},{36.8,19.6},{36.8,30.4},{37,19.4},{37.6,18.4},{37.6,18.6},{37.6,21},{37.6,30.4},{37.8,22},{37.8,28.2},{37.8,31.4},{37.8,32.4},{38.2,23.4},{38.2,32.8},{38.4,24},{38.6,19.2},{38.6,19.8},{38.6,23.8},{38.6,24.8},{38.6,30.4},{38.6,31.6},{38.8,25.6},{38.8,33.6},{39,18},{39,33},{39.2,30.8},{39.4,29},{39.8,27},{40,23.8},{40.2,28.2},{40.4,20.2},{40.4,28.6},{40.6,19},{40.6,22.2},{41,28},}},
        },
        [8531] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS]={{52.4,64},{52.4,64.6},{52.6,64.6},{52.6,66.6},{53,61.4},{53,66.2},{53.4,59.4},{53.4,59.6},{53.4,61.8},{53.4,63.8},{53.6,60},{53.6,64.2},{53.8,63.2},{53.8,64.6},{54.4,62.4},{54.4,66.4},{54.4,67.2},{54.6,61.4},{54.8,58.8},{54.8,62.8},{54.8,66.4},{55.2,62.4},{55.2,63.6},{55.4,58.2},{55.4,67.2},{55.8,63.2},{55.8,67.8},{56,58.8},{56,61.4},{56,66.6},{56.2,58.2},{56.2,60.2},{56.2,61.6},{56.2,65.2},{56.2,66.2},{56.4,64},{56.6,63.8},{56.8,65.2},{57,59.2},{57,62.8},{57.2,62},{57.4,58.4},{57.4,59.6},{57.4,60.6},{57.4,66},{57.6,65},{57.8,59.8},{57.8,62.4},{58,61.4},},},
        },
        [8532] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS]={{27.8,57.8},{28.8,59.8},{29.4,58.4},{29.4,59.4},{29.8,57.6},{29.8,59.8},{30.2,54.2},{30.2,56.6},{30.4,54.6},{30.4,59},{30.8,53.6},{31.4,52},{31.4,53.2},{31.6,58.6},{31.8,52},{31.8,58},{32.2,50.4},{32.2,50.8},{32.2,52.6},{32.8,45.2},{32.8,47},{33,48.6},{33,50.6},{33.2,51.6},{33.2,52.6},{33.4,49.6},{33.6,48},{33.6,49.8},{33.6,51.8},{33.8,49},{33.8,50.8},{34,46.6},{34.6,46},{35,46.8},{35.6,43.8},{36.4,43.2},{36.8,43.8},{37,46.4},{58.8,34.2},{58.8,36},{59.2,36.6},{59.4,32.4},{59.4,33},{59.4,35},{59.6,31.6},{60,33},{60,35.6},{60.2,30.4},{60.2,30.8},{60.4,34.4},{60.4,35.2},{60.6,31.2},{60.6,31.6},{60.6,33.4},{60.6,35.2},{60.8,34.2},{60.8,35.6},{61,36.6},{61.4,30.2},{61.6,29.8},{62,34.2},{62.2,29.4},{62.2,33.2},{62.4,30.6},{62.4,35.4},{62.4,35.8},{62.4,36.6},{62.6,30.6},{62.6,34.4},{62.6,35.4},{62.8,32.8},{63,35.8},{63.4,36.6},{63.6,33.6},{63.6,35.8},{63.6,36.6},{64,35},{64.6,35.4},{64.8,34.2},{68.8,45.6},{69.2,44},{69.4,45},{69.6,44.2},{69.8,47.4},{70,45.2},{70,45.6},{70.6,45.8},{70.6,46.8},{70.8,48},{71,42.8},{71.4,41.6},{71.4,44.4},{71.4,44.6},{71.4,49.2},{71.6,42.8},{71.6,43.8},{71.6,45.4},{71.6,46.6},{71.6,48.8},{71.8,46.4},{71.8,48},{72,41.8},{72.4,40.6},{72.4,50},{72.4,50.6},{72.4,51.6},{72.6,40.6},{72.6,51.6},{72.8,40.2},{72.8,49.4},{73,45.2},{73,49.6},{73.2,46.6},{73.4,39.4},{73.8,39.2},{73.8,50.2},{73.8,50.6},{74,40},{74.4,38.4},{74.8,38},{75.2,36.8},{75.4,36},{75.8,38.2},{76,35.6},{76.2,33.6},{76.2,35.4},{76.2,36.8},{76.4,39},{76.6,34.8},{76.8,33},{76.8,36},{77.4,38.2},{78,34.4},{78,39},{78.4,32.8},{78.4,38.4},{78.4,39.8},{78.6,32.6},{78.6,34.8},{78.6,38},{78.6,38.8},{78.6,40.2},{79,36.2},{79,36.6},{79.6,35.8},{79.6,37.2},{79.8,40.4},{80.4,38},{80.6,38.2},{81,37.4},{81,38.8},}},
        },
        [10181] = { -- Lady Sylvanas Windrunner
            [npcKeys.questEnds] = {9177,9180,9621,9812,10592,14349,24613},
        },
        [10540] = { -- Vol'jin
            [npcKeys.waypoints] = {},
            [npcKeys.questStarts] = {1361},
        },
        [10837] = { -- High Executor Derrington
            [npcKeys.questEnds] = {105,5093,5094,5095,5096,5098,5238,5511,10374},
        },
        [10838] = { -- Commander Ashlam Valorfist
            [npcKeys.questEnds] = {211,5066,5090,5091,5092,5097,5237,8415,8416,8418,10373},
        },
        [10936] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS]={{35.07,84.07}}},
        },
        [11056] = { -- Alchemist Arbington
            [npcKeys.questStarts] = {5505,5537,5538,5803},
            [npcKeys.questEnds] = {5505,5533,5537,5801,5803},
        },
        [11064] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS]={{11.2,27.8},{11.4,27.2},{11.6,27.8},{12.2,27.4},{13.4,26.2},{13.4,26.8},{13.8,30},{14.4,26.2},{14.4,27},{14.4,27.8},{14.6,24.4},{14.6,27.2},{14.6,27.8},{14.8,24.6},{15,29.2},{15,29.6},{16,26.6},{17,26.4},{17.2,27},{17.6,25.4},{17.6,26.4},{18.2,24.2},{18.8,19.6},{18.8,21.8},{18.8,26.6},{19.2,25.2},{19.4,24},{19.6,20.6},{19.6,23.4},{19.8,15.6},{20.4,23.8},{20.6,19.2},{20.8,23.8},{21,25.6},{21.2,16.4},{21.2,20.4},{21.4,18},{21.4,25},{21.4,27.8},{21.8,28},{22,33},{22.4,23},{22.4,24.2},{22.4,24.8},{22.6,22.8},{22.8,25.4},{22.8,33.8},{23,18.6},{23,25.8},{23,27.8},{23.6,33.8},{23.8,21.8},{24,26.6},{24,29.6},{24.4,19.8},{24.6,27.4},{25,20.6},{25,21.8},{25.8,21.2},{25.8,21.6},{26.2,25.6},{26.4,20.4},{26.4,27.6},{26.6,20.2},{26.6,28.4},{26.8,29},{27,29.8},{27.4,26.6},{28,21.2},{28,21.8},{28,28.4},{28,28.6},{28.4,18.4},{29.4,18.2},{29.4,21.6},{29.4,23},{29.4,26.2},{29.6,18.4},{29.6,21.8},{29.8,24.2},{30.4,20.6},{30.4,26.2},{30.4,29.4},{30.4,31.4},{30.4,31.6},{30.8,25.2},{30.8,30.2},{31,21.4},{31,21.8},{31,24.4},{31,28},{31.2,19.2},{31.4,20},{31.6,18.8},{31.6,28},{31.8,27.4},{31.8,28.8},{32,25.6},{32.2,16.2},{32.2,18.4},{32.2,20.8},{32.2,31.6},{32.4,24.6},{32.6,21.6},{32.6,23.2},{32.6,26.4},{32.6,32},{32.8,18.2},{33,17.2},{33,19},{33,20.6},{33,24.8},{33.4,20.4},{33.6,28.8},{33.6,29.8},{33.6,31.6},{33.8,18.2},{34,30.8},{34.6,17.2},{34.6,17.8},{34.8,22.2},{35,31.2},{35.2,31.8},{35.4,19.6},{35.6,20.6},{35.8,26.8},{36,27.6},{36.2,16.4},{36.4,16.8},{36.6,25.8},{36.6,30.8},{36.8,16.2},{36.8,19.6},{36.8,30.4},{37,19.4},{37.6,18.4},{37.6,18.6},{37.6,21},{37.6,30.4},{37.8,22},{37.8,28.2},{37.8,31.4},{37.8,32.4},{38.2,23.4},{38.2,32.8},{38.4,24},{38.6,19.2},{38.6,19.8},{38.6,23.8},{38.6,24.8},{38.6,30.4},{38.6,31.6},{38.8,25.6},{38.8,33.6},{39,18},{39,33},{39.2,30.8},{39.4,29},{39.8,27},{40,23.8},{40.2,28.2},{40.4,20.2},{40.4,28.6},{40.6,19},{40.6,22.2},{41,28},{52.4,64},{52.4,64.6},{52.6,64.6},{52.6,66.6},{53,61.4},{53,66.2},{53.4,59.4},{53.4,59.6},{53.4,61.8},{53.4,63.8},{53.6,60},{53.6,64.2},{53.8,63.2},{53.8,64.6},{54.4,62.4},{54.4,66.4},{54.4,67.2},{54.6,61.4},{54.8,58.8},{54.8,62.8},{54.8,66.4},{55.2,62.4},{55.2,63.6},{55.4,58.2},{55.4,67.2},{55.8,63.2},{55.8,67.8},{56,58.8},{56,61.4},{56,66.6},{56.2,58.2},{56.2,60.2},{56.2,61.6},{56.2,65.2},{56.2,66.2},{56.4,64},{56.6,63.8},{56.8,65.2},{57,59.2},{57,62.8},{57.2,62},{57.4,58.4},{57.4,59.6},{57.4,60.6},{57.4,66},{57.6,65},{57.8,59.8},{57.8,62.4},{58,61.4},{27.8,57.8},{28.8,59.8},{29.4,58.4},{29.4,59.4},{29.8,57.6},{29.8,59.8},{30.2,54.2},{30.2,56.6},{30.4,54.6},{30.4,59},{30.8,53.6},{31.4,52},{31.4,53.2},{31.6,58.6},{31.8,52},{31.8,58},{32.2,50.4},{32.2,50.8},{32.2,52.6},{32.8,45.2},{32.8,47},{33,48.6},{33,50.6},{33.2,51.6},{33.2,52.6},{33.4,49.6},{33.6,48},{33.6,49.8},{33.6,51.8},{33.8,49},{33.8,50.8},{34,46.6},{34.6,46},{35,46.8},{35.6,43.8},{36.4,43.2},{36.8,43.8},{37,46.4},{58.8,34.2},{58.8,36},{59.2,36.6},{59.4,32.4},{59.4,33},{59.4,35},{59.6,31.6},{60,33},{60,35.6},{60.2,30.4},{60.2,30.8},{60.4,34.4},{60.4,35.2},{60.6,31.2},{60.6,31.6},{60.6,33.4},{60.6,35.2},{60.8,34.2},{60.8,35.6},{61,36.6},{61.4,30.2},{61.6,29.8},{62,34.2},{62.2,29.4},{62.2,33.2},{62.4,30.6},{62.4,35.4},{62.4,35.8},{62.4,36.6},{62.6,30.6},{62.6,34.4},{62.6,35.4},{62.8,32.8},{63,35.8},{63.4,36.6},{63.6,33.6},{63.6,35.8},{63.6,36.6},{64,35},{64.6,35.4},{64.8,34.2},{68.8,45.6},{69.2,44},{69.4,45},{69.6,44.2},{69.8,47.4},{70,45.2},{70,45.6},{70.6,45.8},{70.6,46.8},{70.8,48},{71,42.8},{71.4,41.6},{71.4,44.4},{71.4,44.6},{71.4,49.2},{71.6,42.8},{71.6,43.8},{71.6,45.4},{71.6,46.6},{71.6,48.8},{71.8,46.4},{71.8,48},{72,41.8},{72.4,40.6},{72.4,50},{72.4,50.6},{72.4,51.6},{72.6,40.6},{72.6,51.6},{72.8,40.2},{72.8,49.4},{73,45.2},{73,49.6},{73.2,46.6},{73.4,39.4},{73.8,39.2},{73.8,50.2},{73.8,50.6},{74,40},{74.4,38.4},{74.8,38},{75.2,36.8},{75.4,36},{75.8,38.2},{76,35.6},{76.2,33.6},{76.2,35.4},{76.2,36.8},{76.4,39},{76.6,34.8},{76.8,33},{76.8,36},{77.4,38.2},{78,34.4},{78,39},{78.4,32.8},{78.4,38.4},{78.4,39.8},{78.6,32.6},{78.6,34.8},{78.6,38},{78.6,38.8},{78.6,40.2},{79,36.2},{79,36.6},{79.6,35.8},{79.6,37.2},{79.8,40.4},{80.4,38},{80.6,38.2},{81,37.4},{81,38.8}}},
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [11886] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{24.8,79.8}}},
        },
        [12339] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{79.58,77.26}}},
            [npcKeys.waypoints] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{{79.58,77.26},{79.41,77.14},{79.02,76.90},{78.63,76.68},{78.24,76.46},{77.85,76.26},{77.46,76.04},{77.07,75.83},{76.67,75.62},{76.29,75.39},{76.09,74.84},{75.72,74.66},{75.36,74.96},{74.98,75.06},{74.57,74.95},{74.15,74.87},{73.74,74.85},{73.32,74.84},{72.90,74.82},{72.49,74.80},{72.08,74.89},{71.67,75.00},{71.25,75.02},{70.84,74.93},{70.44,74.77},{70.04,74.58},{69.65,74.37},{69.25,74.17},{68.86,73.96},{68.47,73.72},{68.09,73.48},{67.73,73.17},{67.39,72.81},{67.06,72.43},{66.71,72.08},{66.33,71.85},{65.91,71.77},{65.50,71.71},{65.09,71.60},{64.69,71.45},{64.28,71.29},{63.88,71.14},{63.47,70.98},{63.08,70.76},{62.68,70.61},{62.27,70.50},{61.87,70.33},{61.48,70.12},{61.09,69.89},{60.71,69.65},{60.34,69.34},{60.04,68.91},{59.79,68.41},{59.59,67.87},{59.39,67.32},{59.18,66.78},{58.93,66.28},{58.60,65.89},{58.26,65.54},{57.91,65.19},{57.53,64.96},{57.13,64.78},{56.72,64.59},{56.35,64.32},{56.06,63.88},{55.80,63.39},{55.53,62.90},{55.28,62.41},{55.09,62.04},{55.24,61.74},{55.55,61.31},{55.87,60.91},{56.19,60.51},{56.50,60.09},{56.79,59.65},{57.09,59.21},{57.35,58.72},{57.58,58.20},{57.79,57.66},{57.97,57.10},{58.14,56.53},{58.24,55.92},{58.25,55.30},{58.18,54.69},{58.05,54.09},{57.92,53.50},{57.79,52.90},{57.67,52.30},{57.59,51.69},{57.51,51.08},{57.45,50.46},{57.41,49.84},{57.39,49.21},{57.45,48.60},{57.59,48.01},{57.78,47.45},{57.95,46.88},{58.14,46.33},{58.38,45.82},{58.64,45.32},{58.74,44.73},{58.74,44.10},{58.70,43.48},{58.61,42.87},{58.47,42.29},{58.28,41.73},{58.06,41.20},{57.84,40.67},{57.61,40.15},{57.40,39.61},{57.19,39.07},{56.98,38.53},{56.77,37.99},{56.56,37.45},{56.35,36.91},{56.14,36.37},{55.92,35.84},{55.64,35.37},{55.35,34.92},{55.06,34.48},{54.76,34.05},{54.46,33.61},{54.16,33.18},{53.83,32.80},{53.49,32.43},{53.15,32.06},{52.80,31.73},{52.43,31.44},{52.07,31.15},{51.69,30.87},{51.30,30.64},{50.91,30.46},{50.50,30.33},{50.09,30.22},{49.68,30.12},{49.27,30.03},{48.85,29.95},{48.44,29.88},{48.03,29.79},{47.61,29.71},{47.20,29.62},{46.79,29.54},{46.38,29.41},{45.97,29.27},{45.57,29.15},{45.16,29.03},{44.75,28.89},{44.36,28.69},{43.96,28.48},{43.57,28.26},{43.18,28.05},{42.79,27.82},{42.41,27.59},{42.02,27.37},{41.63,27.14},{41.24,26.91},{40.84,26.78},{40.43,26.67},{40.02,26.52},{39.63,26.33},{39.23,26.13},{38.84,25.92},{38.45,25.70},{38.06,25.49},{37.67,25.27},{37.29,25.03},{36.90,24.78},{36.51,24.55},{36.13,24.32},{35.74,24.09},{35.35,23.86},{34.94,23.82},{34.54,24.01},{34.17,24.28},{33.79,24.54},{33.38,24.66},{32.97,24.66},{32.55,24.67},{32.13,24.70},{31.72,24.73},{31.30,24.69},{30.89,24.57},{30.49,24.39},{30.10,24.19},{29.71,23.97},{29.34,23.67},{29.03,23.26},{28.73,22.82},{28.41,22.44},{28.10,22.02},{27.82,21.55},{27.67,20.98},{27.54,20.38},{27.38,19.80},{27.29,19.20},{27.22,18.58},{27.16,17.96},{27.13,17.34},{27.12,16.71},{27.10,16.09},{27.10,11.9}}}},
        },
        [12919] = { -- Nat Pagle
            [npcKeys.questStarts] = {6607,11209,11210,13826},
            [npcKeys.questEnds] = {6607,6608,6609,8227,11194,11209,13826},
        },
        [13283] = { -- Lord Tony Romano
            [npcKeys.questStarts] = {6681,64031,64034,64035,64037,64038,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166},
            [npcKeys.questEnds] = {64028,64031,64034,64035,70395,70397,70398,70401,70870,78136,78140,78157,78164},
        },
        [13434] = { -- Macey Jinglepocket
            [npcKeys.questStarts] = {},
        },
        [14305] = { -- Human Orphan
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY] = {{56.1,54.3}}},
            [npcKeys.questStarts] = {171,558,1479,1558,1687,4822},
        },
        [14374] = {
            [npcKeys.waypoints] = {[357]={{{31.65,43.45},{31.78,43.42},{31.93,44.12},{31.87,44.42},{31.73,44.68},{31.52,44.65},{31.16,44.6},{31.03,44.24},{30.72,43.85},{30.74,43.33},{31.37,43.31}}}}
        },
        [14733] = { -- Sentinel Farsong
            [npcKeys.questStarts] = {7788,7871,7872,7873,7886,7887,7888,7921,8289,8291,8292},
            [npcKeys.questEnds] = {7788,7871,7872,7873,7886,7887,7888,7921,8289,8291,8292,9521},
        },
        [14842] = {
            [npcKeys.spawns] = {[zoneIDs.IRONFORGE] = {{29.65,75.25}}},
            [npcKeys.waypoints] = {[zoneIDs.IRONFORGE] = {{{50.55,82.85},{50.53,83.71},{49.19,84.47},{46.53,84.65},{43.28,84.31},{41.55,83.87},{38.55,82.34},{36.72,81.3},{34.22,79.88},{31.64,78.36},{29.65,75.25},{27.58,71.68},{24.97,66.97},{23.38,62.81},{22.38,58.13},{21.78,54.25},{21.56,50.41},{21.48,47.63},{21.56,43.81},{21.73,40.75},{22.3,36.8},{22.9,34.03},{24.24,34.15},{24.76,35.01},{24.34,37.9},{24.49,39.16},{24.54,40.85},{24.19,44.54},{23.81,47.81},{24.47,52.25},{25.04,56.1},{25.33,58.08},{26.44,58.53},{28.97,58.59},{28.14,66.92},{29.77,69.53},{34.9,71.1},{34.75,75.56},{36.0,76.98},{37.81,78.22},{40.32,79.37},{41.78,79.98},{42.85,80.12},{44.2,80.44},{46.47,80.61},{47.45,80.77},{49.36,81.07},{50.27,81.22},{50.58,82.28}}}},
            [npcKeys.zoneID] = zoneIDs.IRONFORGE,
        },
        [14843] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR]={{52.9,66.56}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
        },
        [14881] = {
            [npcKeys.spawns] = {[4196]={{-1,-1}},[1196]={{-1,-1}},[3805]={{-1,-1}},[3433]={{45.32,31.32},{52.28,18.77},{76.66,17.02},{68.59,32.27},{77.24,33.38},{68.89,32.33},{52.37,19.12},{38.6,16.14},{30.17,25.42},{24.06,19.96},{27.3,31.04},{20.49,52.45},{42.78,53.18}},[3959]={{-1,-1}},[3790]={{-1,-1}},[3792]={{-1,-1}},[3791]={{-1,-1}},[3789]={{-1,-1}},[495]={{69.66,52.14},{70.69,54.13},{37.69,9.4},{64.6,37.88},{35.54,13.38},{35.17,11.25},{64.83,41.44},{35.83,16.85},{33.58,12.58},{34.58,14.38},{36.07,11.05},{35.64,10.82},{33.93,13.78},{38.43,9.03},{38.71,11.56}},[3456]={{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1}},[3457]={{-1,-1}},[1977]={{-1,-1}},[zoneIDs.AZJOL_NERUB]={{-1,-1}},[4415]={{51.16,66.81},{25.37,26.61},{39.21,66.89},{41.73,13.77}},[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{70.61,29.58},{56.41,64.8},{72.65,33.51},{66.31,47.35},{59.43,44.25},{72.51,37.6},{86.18,73.16},{82.7,42.93},{73.11,31.36},{66.73,46.29},{74.38,42.19},{76.94,20.42},{68.65,35.06},{46.41,65.45},{56.34,51.78},{51.26,53.5}},[4812]={{34.06,75.98},{34.04,73.36},{34.41,75.45},{28.7,19.4},{29.01,20.35},{28.85,18.59},{29.02,18.33},{33.6,75.48},{29.84,18.28},{29.5,21.16},{29.13,20.52},{30.02,20.3},{34.04,73.78},{34.48,75.29},{34.59,78.32},{32.96,78.3},{33.63,75.18},{34.06,75.98},{34.16,75.8},{33.7,78.81},{33.96,72.62},{34.06,76.77},{34.09,77.08}},[4809]={{42.13,19.94},{43.07,18.37},{40.13,12.27},{40.3,13.91},{40.12,11.08}},[4813]={{53.78,30.91},{50.18,34.18},{46.53,47.95},{57.41,60.4},{50.96,36.2},{58.65,31.85},{39.35,70.11},{55.04,17.7},{63.01,22.24},{44.1,72.79},{61.49,30.02},{49.27,45.11},{44.18,53.8},{54.95,62.3},{49.72,62.62},{60.35,30.97},{59.26,19.19},{52.33,17.61},{56.04,18.17}},[4820]={{37.19,11.29},{38.25,12.64},{38.98,13.82},{37.43,11.58},{38.99,13.81},{38.72,12.99}}},
        },
        [15278] = {
            [npcKeys.spawns] = {[zoneIDs.EVERSONG_WOODS] = {{38.02,21.01}}},
        },
        [15350] = { -- Horde Warbringer
            [npcKeys.spawns] = {
                [zoneIDs.ORGRIMMAR]={{79.6,30.21},{36.94,65.36}},
                [zoneIDs.THUNDER_BLUFF]={{57.8,76.4}},
                [zoneIDs.UNDERCITY]={{53.78,87.73}},
                [zoneIDs.SILVERMOON_CITY]={{97,38.3}},
                [zoneIDs.SHATTRATH_CITY]={{66.96,56.6}},
                [zoneIDs.DALARAN]={{58.19,20.59}},
                [zoneIDs.WINTERGRASP]={{50.02,15.16}},
            },
            [npcKeys.waypoints] = {[zoneIDs.WINTERGRASP] = {{{50.64,13.08},{50.58,13.00},{50.51,12.93},{50.44,12.86},{50.37,12.79},{50.30,12.71},{50.23,12.64},{50.16,12.60},{50.07,12.59},{50.00,12.58},{49.97,12.58},{49.88,12.57},{49.80,12.59},{49.73,12.66},{49.67,12.74},{49.60,12.83},{49.54,12.91},{49.48,13.00},{49.42,13.09},{49.36,13.18},{49.32,13.29},{49.29,13.40},{49.25,13.52},{49.22,13.63},{49.20,13.76},{49.20,13.88},{49.19,14.01},{49.19,14.13},{49.21,14.26},{49.25,14.36},{49.30,14.46},{49.35,14.56},{49.40,14.67},{49.45,14.77},{49.51,14.86},{49.57,14.94},{49.64,15.01},{49.71,15.07},{49.79,15.13},{49.87,15.16},{49.95,15.17},{50.04,15.17},{50.12,15.17},{50.21,15.17},{50.28,15.13},{50.36,15.06},{50.42,14.99},{50.49,14.92},{50.57,14.85},{50.63,14.77},{50.67,14.66},{50.71,14.55},{50.75,14.44},{50.79,14.33},{50.82,14.21},{50.84,14.09},{50.84,13.96},{50.84,13.84},{50.84,13.71},{50.82,13.59},{50.78,13.48},{50.73,13.37},{50.70,13.29},{50.66,13.19},{50.62,13.08},{50.57,12.98},{50.50,12.91},{50.42,12.85},{50.35,12.78},{50.28,12.72},{50.21,12.66},{50.13,12.60},{50.05,12.58},{50.02,12.58},}}},
            [npcKeys.questStarts] = {8367,8388,11339,11340,11341,11342,13407,13428,13476,14164,14181,14182,14183,24216,24217,24221,24225,24226,24426},
            [npcKeys.questEnds] = {8367,8388,11339,11340,11341,11342,13407,13428,13476,14164,14181,14182,14183,24216,24217,24221,24225,24226,24426},
        },
        [15351] = { -- Alliance Brigadier General
            [npcKeys.spawns] = {
                [zoneIDs.IRONFORGE]={{70.41,91.10}},
                [zoneIDs.SHATTRATH_CITY]={{67.41,33.86}},
                [zoneIDs.DARNASSUS]={{58.02,34.52}},
                [zoneIDs.THE_EXODAR]={{26.6,50.06}},
                [zoneIDs.STORMWIND_CITY]={{83.47,33.66},{75.67,66.54}},
                [zoneIDs.DALARAN]={{29.79,75.78}},
                [zoneIDs.WINTERGRASP]={{50.02,15.16}},
            },
            [npcKeys.waypoints] = {[zoneIDs.WINTERGRASP] = {{{50.64,13.08},{50.58,13.00},{50.51,12.93},{50.44,12.86},{50.37,12.79},{50.30,12.71},{50.23,12.64},{50.16,12.60},{50.07,12.59},{50.00,12.58},{49.97,12.58},{49.88,12.57},{49.80,12.59},{49.73,12.66},{49.67,12.74},{49.60,12.83},{49.54,12.91},{49.48,13.00},{49.42,13.09},{49.36,13.18},{49.32,13.29},{49.29,13.40},{49.25,13.52},{49.22,13.63},{49.20,13.76},{49.20,13.88},{49.19,14.01},{49.19,14.13},{49.21,14.26},{49.25,14.36},{49.30,14.46},{49.35,14.56},{49.40,14.67},{49.45,14.77},{49.51,14.86},{49.57,14.94},{49.64,15.01},{49.71,15.07},{49.79,15.13},{49.87,15.16},{49.95,15.17},{50.04,15.17},{50.12,15.17},{50.21,15.17},{50.28,15.13},{50.36,15.06},{50.42,14.99},{50.49,14.92},{50.57,14.85},{50.63,14.77},{50.67,14.66},{50.71,14.55},{50.75,14.44},{50.79,14.33},{50.82,14.21},{50.84,14.09},{50.84,13.96},{50.84,13.84},{50.84,13.71},{50.82,13.59},{50.78,13.48},{50.73,13.37},{50.70,13.29},{50.66,13.19},{50.62,13.08},{50.57,12.98},{50.50,12.91},{50.42,12.85},{50.35,12.78},{50.28,12.72},{50.21,12.66},{50.13,12.60},{50.05,12.58},{50.02,12.58},}}},
            [npcKeys.questStarts] = {8371,8385,11335,11336,11337,11338,13405,13427,13478,14163,14178,14179,14180,24218,24219,24220,24223,24224,24427,64845},
            [npcKeys.questEnds] = {8371,8385,11335,11336,11337,11338,13405,13427,13478,14163,14178,14179,14180,24218,24219,24220,24223,24224,24427,64845},
        },
        [15563] = {
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS] = {{57.9,54.83}}},
        },
        [15564] = {
            [npcKeys.spawns] = {[zoneIDs.UNDERCITY] = {{66.66,38.19}}},
        },
        [15732] = {
            [npcKeys.spawns] = {
                [zoneIDs.THE_EXODAR]={{79.28,55.14}},
                [zoneIDs.STORMWIND_CITY]={{67.87,71.43}},
                [zoneIDs.DALARAN]={{49.35,44.82}},
                [zoneIDs.DUN_MOROGH]={{53.16,35.62}},
                [zoneIDs.EVERSONG_WOODS]={{56.45,51.79}},
                [zoneIDs.STRANGLETHORN_VALE]={{26.66,73.51}},
                [zoneIDs.DUROTAR]={{49.99,13.59}},
                [zoneIDs.TIRISFAL_GLADES]={{61.03,59.36}},
                [zoneIDs.WETLANDS]={{9.22,58.37}},
                [zoneIDs.TANARIS]={{53.54,28.01}},
                [zoneIDs.SHATTRATH_CITY]={{79.83,58.97}},
            },
        },
        [15576] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{26.5,76.5}}},
        },
        [15891] = { -- Lunar Festival Herald
            [npcKeys.spawns] = {
                [zoneIDs.ORGRIMMAR]={{50.98,70.57}},
                [zoneIDs.UNDERCITY]={{66.74,43.39}},
                [zoneIDs.THUNDER_BLUFF]={{38.37,63.42}},
            },
            [npcKeys.questStarts] = {8873},
        },
        [15892] = { -- Lunar Festival Emissary
            [npcKeys.spawns] = {
                [zoneIDs.STORMWIND_CITY]={{61.73,75.73}},
                [zoneIDs.IRONFORGE]={{30.92,61.59}},
                [zoneIDs.DARNASSUS]={{42.15,43.99}},
            },
            [npcKeys.questStarts] = {8870},
        },
        [15895] = {
            [npcKeys.spawns] = {
                [zoneIDs.DARNASSUS]={{32.59,12}},
                [zoneIDs.UNDERCITY]={{65.62,36.0}},
                [zoneIDs.ORGRIMMAR]={{41.66,31.98}},
                [zoneIDs.THUNDER_BLUFF]={{71.12,28.2}},
                [zoneIDs.IRONFORGE]={{28.85,16.23}},
                [zoneIDs.STORMWIND_CITY]={{37.65,65.63}},
                [zoneIDs.THE_EXODAR]={{74.02,57.47}},
                [zoneIDs.SILVERMOON_CITY]={{73.1,82.6}},
                [zoneIDs.SHATTRATH_CITY]={{53.29,33.1},{48.14,36.87}},
                [zoneIDs.DALARAN]={{47.65,43.76}},
            },
        },
        [15954] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS_PLAGUE_QUARTER] = {{34.7,56.5}},[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.NAXXRAMAS,
        },
        [15956] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS_ARACHNID_QUARTER] = {{30.7,46.9}},[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.NAXXRAMAS,
        },
        [15989] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS_FROSTWYRM_LAIR] = {{56.6,67.4}},[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.NAXXRAMAS,
        },
        [16061] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS_MILITARY_QUARTER] = {{42.7,45.8}},[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.NAXXRAMAS,
        },
        [16028] = {
            [npcKeys.spawns] = {[zoneIDs.NAXXRAMAS_CONSTRUCT_QUARTER] = {{54,42}},[zoneIDs.NAXXRAMAS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.NAXXRAMAS,
        },
        [16226] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{74.46,52.15}}},
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [16241] = { -- Argent Recruiter
            [npcKeys.questStarts] = {9154},
        },
        [16254] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{42.65,37.3}}},
            [npcKeys.zoneID] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [16255] = { -- Argent Scout
            [npcKeys.questStarts] = {9154},
        },
        [16281] = { -- Keeper of the Rolls
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{75.16,54.39}}},
            [npcKeys.questEnds] = {9154,9247,9295,9299,9300,9301,9302,9304},
        },
        [16361] = {
            [npcKeys.spawns] = {[zoneIDs.EASTERN_PLAGUELANDS] = {{75.16,54.45}}},
        },
        [16075] = {
            [npcKeys.spawns] = {}, -- Replaced in WotLK
        },
        [16438] = {
            [npcKeys.spawns] = {
                [zoneIDs.DUN_MOROGH]={{47.4,40.4},{48.2,40.8},{48.4,38.4},{48.4,41.6},{48.8,40.8},{49,36.8},{49.2,38.8},{49.2,40},{49.6,36.2},{50,38.6},{50,40.2},{50,40.6},{50.4,42.8},{50.4,43.6},{50.4,44.8},{50.6,40.6},{51.2,43.6},{51.2,45},{51.4,39.6},{51.4,41.6},{51.4,45.6},{51.6,41.2},{51.6,43},{51.6,43.8},{51.6,44.8},{51.8,42},{51.8,45.8},{52.6,43.8},{52.8,44.8}},
                [zoneIDs.MULGORE]={{39.43,38.54},{38.78,38.51},{39.04,38.51},{38.71,38.04},{39.4,37.54},{38.76,37.49},{38.35,37.39},{38.99,37.18},{40.3,37.03},{38.32,37.01},{38.37,36.59},{39.37,36.49},{39.0,36.15},{38.73,36.06},{38.34,35.42}},
                [zoneIDs.DUROTAR]={{44.42,18.56},{44.71,18.02},{43.9,17.97},{45.3,17.93},{45.04,17.61},{44.36,17.53},{45.29,16.99},{44.42,16.98},{45.25,16.64},{45.03,16.57},{43.97,16.55},{45.58,16.5},{44.94,16.39},{44.67,16.13},{45.67,15.99},{45.83,15.97}},
                [zoneIDs.TELDRASSIL]={{38.17,57.75},{38.38,57.18},{38.7,57.17},{38.13,56.67},{38.36,56.66},{37.76,56.29},{36.44,56.19},{36.78,56.13},{38.78,56.12},{38.09,55.73},{38.41,55.66},{37.48,55.22},{38.12,55.16},{37.11,54.81},{36.77,54.75},{36.77,54.66},{36.76,54.66}}
            },
        },
        [16817] = {
            [npcKeys.spawns] = {
                [zoneIDs.TELDRASSIL]={{56.5,92.3}},
                [zoneIDs.STORMWIND_CITY]={{49.53,72.27}},
                [zoneIDs.IRONFORGE]={{63.81,25.31}},
                [zoneIDs.SHATTRATH_CITY]={{61.39,31.91}},
                [zoneIDs.THE_EXODAR]={{41.62,25.28}},
            },
        },
        [16475] = {
            [npcKeys.spawns] = {[zoneIDs.AZUREMYST_ISLE] = {{84.19,43.03}}},
        },
        [17076] = { -- Lady Liadrin
            [npcKeys.questEnds] = {10960,64139,64140,64141,64142,64143,64144,64145},
        },
        [17219] = { -- Sulaa
            [npcKeys.questStarts] = {9462,9500,9551,14111},
        },
        [17663] = {
            [npcKeys.name] = "Maatparm",
        },
        [17718] = {
            [npcKeys.questStarts] = {9684,9681},
        },
        [17977] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA]={{-1,-1}}},
        },
        [18024] = { -- Defender Sorli
            [npcKeys.questStarts] = {},
        },
        [18481] = { -- A'dal
            [npcKeys.questEnds] = {10102,10210,10280,10560,10704,10708,10781,10882,10883,10884,10885,10886,10948,11007,11052,13081,13430},
        },
        [18528] = { -- Xi'ri
            [npcKeys.questStarts] = {10958,10985,13429},
            [npcKeys.questEnds] = {10949,10985,13429},
        },
        [18927] = { -- Human Commoner
            [npcKeys.questStarts] = {11356,11441,11970,12753,12772,12775,12777,12808,13484,14022},
        },
        [19148] = { -- Dwarf Commoner
            [npcKeys.questStarts] = {11356,11441,11970,12753,12772,12775,12777,12808},
        },
        [19169] = { -- Blood Elf Commoner
            [npcKeys.questStarts] = {11357,11446,11971,12752,12782,12783,12784,12811,13483,14036},
        },
        [19171] = { -- Draenei Commoner
            [npcKeys.questStarts] = {11356,11441,11970,12753,12772,12775,12777,12808},
        },
        [19172] = { -- Gnome Commoner
            [npcKeys.questStarts] = {11356,11441,11970,12753,12772,12775,12777,12808},
        },
        [19173] = { -- Night Elf Commoner
            [npcKeys.questStarts] = {11356,11441,11970,12753,12772,12775,12777,12808},
        },
        [19175] = { -- Orc Commoner
            [npcKeys.questStarts] = {11357,11446,11971,12752,12782,12783,12784,12811},
        },
        [19176] = { -- Tauren Commoner
            [npcKeys.questStarts] = {11357,11446,11971,12752,12782,12783,12784,12811},
        },
        [19177] = { -- Troll Commoner
            [npcKeys.questStarts] = {11357,11446,11971,12752,12782,12783,12784,12811},
        },
        [19178] = { -- Forsaken Commoner
            [npcKeys.questStarts] = {11357,11446,11971,12752,12782,12783,12784,12811},
        },
        [19220] = {
            [npcKeys.spawns] = {[zoneIDs.THE_MECHANAR]={{-1,-1}}},
        },
        [19481] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM]={{58.34,86.4}}},
        },
        [19684] = { -- Haggard War Veteran
            [npcKeys.questEnds] = {70865},
        },
        [20102] = { -- Goblin Commoner
            [npcKeys.questStarts] = {11441,11446,11970,11971,12752,12753,12772,12775,12777,12782,12783,12784,12808,12811},
        },
        [20407] = { -- Farseer Umbrua
            [npcKeys.questStarts] = {8410,10490,10491,70397,70398,70401,70411,70865,70870,78140,78157,78164,78166},
            [npcKeys.questEnds] = {70395,70397,70398,70401,70870,78136,78140,78157,78164},
        },
        [20735] = { -- Archmage Lan'dalock
            [npcKeys.questStarts] = {13245,13246,13247,13248,13249,13250,13251,13252,13253,13254,13255,13256,14199,24579,24580,24581,24582,24583,24584,24585,24586,24587,24588,24589,24590,78752,78753,83713,83714,83717,87379},
            [npcKeys.questEnds] = {13245,13246,13247,13248,13249,13250,13251,13252,13253,13254,13255,13256,14199,24579,24580,24581,24582,24583,24584,24585,24586,24587,24588,24589,24590,78752,78753,83713,83714,83717,87379},
        },
        [22515] = {
            [npcKeys.spawns] = {[4264]={{70.68,57.53},{71.63,57.69},{59.72,39.98},{63.76,39.98}},[4131]={{-1,-1}},[4075]={{-1,-1}},[1196]={{-1,-1}},[3805]={{-1,-1}},[3959]={{-1,-1}},[3562]={{-1,-1}},[495]={{57.65,77.64},{60.53,78.47},{58.97,80.08},{58.71,78.18},{59.2,76.94},{59.78,79.37},{60.5,80.44},{57.84,75.7},{61.86,79.8}},[210]={{44.94,61.23},{45.33,60.99},{45.53,62.56},{44.84,62.0}},[4197]={{46.88,43.15}},[4384]={{50.19,45.79},{47.32,45.25},{50.08,44.72},{47.13,44.65}},[2597]={{42.36,13.25}},[4196]={{39.21,21.91},{48.25,10.59},{44.3,10.39},{46.08,10.63}},[zoneIDs.AZJOL_NERUB]={{-1,-1}},[4273]={{39.71,29.29},{39.74,26.52},{39.71,23.82}},[4710]={{53.16,78.39},{44.96,26.93},{51.45,26.9},{52.3,26.94},{48.72,23.31},{47.96,30.87},{49.23,32.2},{47.89,78.23},{49.32,78.25},{52.15,72.32},{51.24,80.86},{54.45,78.97},{52.24,74.48},{45.78,26.83}},[4812]={{32.42,20.8},{31.22,20.81}},[4723]={{56.99,83.83}},[4820]={{41.07,13.75}}},
        },
        [22817] = { -- Blood Elf Orphan
            [npcKeys.questStarts] = {10945,10951,10953,10960,10963,10967,11975},
        },
        [22818] = { -- Draenei Orphan
            [npcKeys.questEnds] = {10943,10950,10952,10962},
        },
        [23010] = { -- Wolgren Jinglepocket
            [npcKeys.spawns] = {[zoneIDs.THE_EXODAR]={{54.95,47.44}}},
            [npcKeys.zoneID] = zoneIDs.THE_EXODAR,
            [npcKeys.questStarts] = {7023},
        },
        [23128] = { -- Master Pyreanor
            [npcKeys.questStarts] = {70734,70735,70736,70737,70865,70869,78167,78168},
            [npcKeys.questEnds] = {70396,70734,70735,70736,70869,78137,78167},
        },
        [23472] = {
            [npcKeys.spawns] = {[4075]={{-1,-1}},[1196]={{-1,-1}},[3959]={{-1,-1}},[4395]={{49.8,47.27}},[4197]={{56.14,20.62},{49.58,16.33},{31.75,38.45},{32.28,38.7},{66.59,67.42},{66.62,68.38},{45.15,17.5},{45.13,16.47},{65.17,38.64},{64.47,38.47},{34.63,67.72},{34.54,68.64},{54.12,16.53},{54.13,17.45},{45.41,23.68},{43.98,20.7},{52.23,26.44},{54.66,23.53},{47.81,26.53},{50.4,15.87}},[4384]={{50.2,72.24},{41.15,59.32},{58.66,56.38},{39.26,42.52},{58.96,38.04}},[2597]={{44.11,1.48}},[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
        },
        [23486] = { -- Goldark Snipehunter
            [npcKeys.questStarts] = {11117,11118},
            [npcKeys.questEnds] = {11117,11118},
        },
        [23763] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD] = {{50.2,29.2},{50.4,26.4},{50.4,27},{50.6,26.6},{51,26.2},{51,27.6},{51.2,25.4},{51.2,28.8},{51.6,25.4},{51.8,27.6},{52,29.6},{52.2,26.4},{52.2,26.6},{52.4,28.6},{52.6,28.6},{52.8,26.4},{52.8,27},{52.8,27.8}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [23804] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD] = {{40.29,60.25}}},
        },
        [23921] = {
            [npcKeys.name] = "Northeast Plague Tank",
        },
        [23922] = {
            [npcKeys.name] = "Northwest Plague Tank",
        },
        [23923] = {
            [npcKeys.name] = "Southwest Plague Tank",
        },
        [23924] = {
            [npcKeys.name] = "Southeast Plague Tank",
        },
        [23931] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{54.93,57.47}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [23953] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_KEEP]={{29.6,65.1},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.UTGARDE_KEEP,
        },
        [23954] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_KEEP_UPPER_LEVEL]={{75.8,35.5}},[zoneIDs.UTGARDE_KEEP]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.UTGARDE_KEEP,
        },
        [24028] = { --"Talu Frosthoof", "Bowyer"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24031] = { --"Camp Winterhoof Brave"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24032] = { --"Celea Frozenmane", "Wind Rider Master"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24033] = { --"Bori Wintertotem", "Innkeeper"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24060] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{45.2,27.3}}},
        },
        [24067] = { --"Mahana Frosthoof", "Stable Master"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24083] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_KEEP_UPPER_LEVEL]={{-1,-1}},[zoneIDs.UTGARDE_KEEP]={{-1,-1}}},
        },
        [24111] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{59.56,48.85}}},
        },
        [24120] = {
            [npcKeys.spawns] = {[zoneIDs.THE_FROZEN_SEA]={{89.83,81.95},{89.78,82.02},{89.78,81.91},{89.79,81.9},{89.8,81.9},{89.88,82.05},{89.83,82.2},{89.85,82.15},{89.9,82.2},{89.89,82.28},{89.09,81.92},{89.06,81.95},{89.03,81.82},{89.06,81.84},{89.09,82.05},{89.14,82.09},{89.14,82.17},{88.73,82.62},{88.73,82.52},{88.76,82.53},{88.73,82.6},{88.77,82.64},{88.8,82.79},{88.75,82.86},{88.83,82.86},{88.83,82.9},{88.83,82.94},{89.14,83.71},{89.2,83.61},{89.24,83.95},{89.23,83.94},{89.22,83.84},{89.2,83.83},{89.16,83.76},{89.22,83.71},{89.21,83.67},{89.19,83.54},{89.17,83.53},{89.56,83.06},{89.52,82.97},{89.55,83.03},{89.6,83.14},{89.58,83.2},{89.62,83.29},{89.6,83.34},{89.63,83.39},{90.16,83.04},{90.17,83.03},{90.22,83.02},{90.21,83.14},{90.17,83.14},{90.19,83.17},{90.21,83.15},{90.26,83.17},{90.23,83.18},{90.21,83.18},{90.2,83.35},{90.29,83.26},{90.25,83.29},{90.26,83.29},{90.28,83.43},{90.28,83.42},{89.77,84.36},{89.83,84.38},{89.92,84.79},{89.93,84.75},{89.9,84.7},{89.86,84.66},{89.88,84.56},{89.83,84.56},{89.8,84.47},{89.87,84.43},{89.87,84.46},{89.84,84.44},{90.44,84.63},{90.49,84.64},{90.43,84.76},{90.51,84.74},{90.47,84.65},{90.48,84.59},{90.44,84.57},{90.5,84.86},{90.5,84.89},{90.46,84.86},{90.46,84.93},{90.52,84.83}}},
        },
        [24123] = { --"Nokoma Snowseer"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24127] = { --"Ahota Whitefrost"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24129] = { --"Chieftain Ashtotem"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24130] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{45.2,27.3}}},
        },
        [24135] = { --"Greatmother Ankha"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24137] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_KEEP]={{68,67.7},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.UTGARDE_KEEP,
        },
        [24142] = { --"Camp Winterhoof Wind Rider"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24160] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{37.62,52.64},{39.06,48.25},{38.97,49.15},{38.7,48.45},{38.96,49.35},{42.38,53.56},{37.57,48.53},{37.67,47.65},{37.87,49.4},{38.1,49.39},{38.67,50.63},{38.58,50.44},{37.93,50.25},{38.55,50.7},{37.93,50.47},{38.01,50.43},{38.12,51.81},{38.09,51.94},{42.24,52.35},{42.51,53.19},{36.9,46.89},{37.55,50.82},{37.6,51.09},{37.51,50.9},{37.18,49.86},{38.16,51.06},{40.68,52.18},{37.95,52.41},{39.29,50.82},{40.1,49.55},{40.17,49.69},{40.16,50.73},{41.98,54.41},{41.01,54.05},{40.5,54.04},{37.71,48.66},{41.56,50.34},{39.09,49.49},{40.39,52.64},{40.06,50.85},{40.09,50.67},{39.83,53.12},{39.37,50.76},{39.9,51.53},{41.09,51.14},{40.77,48.49},{40.33,48.75},{40.41,48.92},{40.89,48.96},{40.35,48.85},{39.76,51.48},{40.2,48.1},{40.19,49.53},{42.03,51.48}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24161] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{69.6,38.6}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24162] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{69.6,39.8}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24170] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{39.2,50.2}}},
        },
        [24173] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{52.4,3.9}}},
        },
        [24184] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{63.43,40.57}}},
        },
        [24186] = { --"Sage Mistwalker"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24195] = { --"Winterhoof Longrunner"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24209] = { --"Longrunner Skycloud"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24206] = {
            [npcKeys.spawns] = {[495]={{59.91,27.94},{58.23,11.71},{46.39,21.61},{47.49,19.32},{54.01,20.75},{47.21,21.60},{50.13,14.30},{63.47,22.07},{63.85,22.89},{62.72,22.70},{51.84,15.98},{50.5,27.03},{49.01,15.55},{55.9,18.08},{58.61,24.76},{48.91,20.74},{62.59,24.61},{61.12,21.65},{59.39,22.08},{55.72,22.19},{56.05,27.28},{49.57,24.93},{56.62,16.17},{46.46,23.36},{47.22,16.92},{59.94,22.60},{54.06,14.44},{60.56,25.35},{52.2,11.46},{59.05,13.96},{52.07,29.76},{51.93,29.15},{50.91,18.99},{51.34,17.85},{49.83,21.93},{54.62,28.17},{53.15,13.22},{51.24,13.23},{52.21,13.46},{52.62,25.61},{53.41,18.79},{61.91,23.23},{58.35,20.65},{50.04,17.35},{54.94,2.81},{51.47,7.41},{62.64,28.75},{44.4,16.98},{56.81,17.70},{57.27,18.52},{47.67,21.05},{52.31,21.61},{47.83,23.78},{51.76,20.31},{51.25,20.03},{53.52,22.7},{55.55,20.59},{53.55,20.02},{50.71,24.31},{56.71,19.66},{52.53,17.99},{50.86,12.69},{53.12,29.29},{50.64,16.78},{52.98,16.23},{47.05,18.26},{64.02,14.18},{55.04,18.53},{56.92,21.70},{41.95,14.91},{55.95,24.75},{45.7,22.79},{53.43,27.15},{46.58,17.54},{51.01,21.85},{54.87,13.28},{55.63,21.14},{57.99,20.81},{60.7,26.46}},[394]={{66.11,68.3},{62.82,69.55},{68.94,68.49}}},
        },
        [24211] = { --"Freed Winterhoof Longrunner"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{31.49,15.0},{30.05,18.11},{31.11,15.63},{27.29,14.23},{26.54,15.46},{28.82,15.22},{29.54,19.95},{29.71,17.89},{29.08,18.64},{28.26,16.62},{27.57,16.79},{28.33,18.02},{28.41,18.62},{27.92,15.05},{28.93,16.8},{28.91,12.68},{28.04,10.46},{28.1,10.17},{29.69,16.12},{33.25,19.35},{32.33,17.45},{31.98,19.17},{31.03,18.08},{31.3,18.96},{30.52,16.81},{30.42,20.67},{31.06,20.87},{30.42,18.88},{27.88,12.65},{27.3,11.48}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24213] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{55.08,57.53}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24214] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{55.08,57.53}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24215] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{55.08,57.53}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24234] = { --"Junat the Wanderer"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24236] = { --"Wind Tamer"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24256] = { --"Wind Tamer Kagan"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24277] = {
            [npcKeys.waypoints] = {[495]={{{28.27,9.46},{28.43,9.96},{28.49,10.28},{28.54,10.81},{28.61,11.2},{28.72,11.61},{28.84,11.83},{29.02,12.19},{29.1,12.59},{28.8,13.4},{28.7,13.9},{28.9,14.2},{29,15.3},{29.1,16.2},{29.3,17},{29.2,17.2},{28.8,17.3},{28.6,17.1},{28.2,16.8},{28.08,16.5},{28.02,16.38},{27.83,16.25},{27.56,15.95},{27.33,15.43},{27.17,15.11},{27.03,14.76},{27.03,14.2},{26.96,13.57},{26.88,12.95},{26.76,12.46},{26.65,12.06},{26.54,11.51},{26.49,11.09},{26.44,10.67},{26.45,10.27},{26.49,9.66},{26.49,9.06},{26.54,8.55},{26.81,8.09},{27.13,8.0},{27.39,8.12},{27.61,8.36},{27.98,8.95}}}},
        },
        [24285] = {
            [npcKeys.spawns] = {[495]={{65.52,21.12},{63.75,17.57},{64.41,20.35},{63.74,19.36},{65.65,20.26},{63.93,20.46},{67.65,19.24},{65.8,19.52},{65.46,21.64},{66.01,20.88},{63.5,20.38},{63.52,18.39},{63.98,19.74},{64.4,18.31},{62.08,19.11},{61.1,19.25},{60.69,19.1},{62.67,18.67},{60.33,19.23},{62.36,19.05},{66.67,20.45},{63.33,19.28},{62.72,19.43},{67.74,20.19},{67.2,19.65}}},
        },
        [24290] = {
            [npcKeys.name] = "New Agamand Plague Tank",
        },
        [24329] = {
            [npcKeys.spawns] = {
                [zoneIDs.HOWLING_FJORD] = {{72,26.4},{70.3,27.3},{68.7,28.1},{66.5,24.9},{69.7,21.5},{72.6,19.9},{73.6,23.1}},
            },
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24362] = { --"Longrunner Pembe"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24364] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{45.91,52.77}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [24390] = { --"Sage Edan"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24418] = {
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD] = {{30.89,28.42},{30.88,28.18}}},
        },
        [24440] = {
            [npcKeys.spawns] = {
                [zoneIDs.HOWLING_FJORD] = {{30.2,26.4},{30.4,27},{30.6,24},{30.8,23.4},{30.8,26.6},{30.8,28.2},{30.8,28.6},{31,24.6},{31,26.4},{31.2,31},{31.6,27.2},{31.6,27.6},{31.8,26},},
            },
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24495] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{44.07,17.98}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [24527] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{48.16,27.53}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [24640] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{65.01,39.94}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24657] = { -- Glodrak Huntsniper
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{45.01,17.41}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
            [npcKeys.questStarts] = {11120,11431},
            [npcKeys.questEnds] = {11120,11431},
        },
        [24702] = { --"Greatfather Mahan"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24703] = { --"Chieftain Wintergale"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24706] = { --"Durm Icehide"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24709] = { --"Sage Aeire"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24730] = { --"Wind Tamer Barah"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24733] = { --"Snow Tracker Junek"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [24847] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD] = {{71.54,69.51}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [24910] = {
            [npcKeys.spawns] = {
                [zoneIDs.HOWLING_FJORD] = {{37.19,74.79}},
            },
            [npcKeys.waypoints] = {[zoneIDs.HOWLING_FJORD]={{{37.19,74.79},{37.22,74.80},{37.28,74.80},{37.36,74.81},{37.46,74.83},{37.58,74.87},{37.71,74.94},{37.82,75.07},{37.90,75.24},{37.93,75.46},{37.92,75.71},{37.88,76.01},{37.82,76.37},{37.84,76.74},{37.93,77.01},{38.02,77.33},{38.11,77.69},{38.22,78.10},{38.34,78.53},{38.50,79.00},{38.69,79.48},{38.91,79.90},{39.12,80.21},{39.38,80.50},{39.67,80.78},{39.98,81.05},{40.30,81.31},{40.62,81.56},{40.94,81.78},{41.24,82.00},{41.52,82.19},{41.81,82.38},{42.17,82.62},{42.50,82.83},{42.82,83.00},{43.13,83.14},{43.42,83.24},{43.70,83.31},{44.06,83.36},{44.43,83.35},{44.79,83.27},{45.11,83.16},{45.42,83.03},{45.75,82.79},{45.95,82.35},{46.03,81.83},{46.03,81.30},{46.02,80.80},{45.92,80.33},{45.74,79.89},{45.53,79.48},{45.31,79.12},{45.06,78.73},{44.88,78.28},{44.75,77.81},{44.65,77.29},{43.16,77.68},{43.13,77.68},{43.10,77.69},{43.05,77.69},{42.98,77.68},{42.90,77.67},{42.80,77.64},{42.69,77.60},{42.56,77.54},{42.41,77.45},{42.24,77.34},{42.07,77.21},{41.89,77.06},{41.73,76.91},{41.59,76.77},{41.47,76.64},{41.37,76.53},{41.29,76.43},{41.22,76.34},{41.16,76.28},{41.12,76.23},{41.09,76.19},{41.08,76.17},{41.04,76.12},{41.01,76.08},{40.95,76.03},{40.89,75.96},{40.81,75.88},{40.71,75.78},{40.60,75.67},{40.49,75.54},{40.36,75.40},{40.24,75.25},{40.13,75.10},{40.03,74.97},{39.95,74.85},{39.88,74.74},{39.83,74.65},{39.78,74.57},{39.74,74.51},{39.72,74.47},{39.70,74.44},{39.67,74.41},{39.64,74.36},{39.60,74.29},{39.55,74.20},{39.49,74.10},{39.42,73.97},{39.35,73.81},{39.29,73.62},{39.22,73.41},{39.16,73.18},{39.11,72.97},{39.07,72.78},{39.04,72.61},{39.01,72.47},{38.98,72.35},{38.97,72.25},{38.95,72.18},{38.94,72.13},{38.93,72.11},{38.92,72.08},{38.91,72.04},{38.88,71.97},{38.85,71.87},{38.82,71.75},{38.78,71.61},{38.75,71.43},{38.71,71.22},{38.66,70.99},{38.62,70.72},{38.57,70.45},{38.53,70.21},{38.49,69.99},{38.46,69.81},{38.43,69.66},{38.41,69.53},{38.39,69.42},{38.38,69.34},{38.37,69.28},{38.37,69.25},{38.36,69.23},{38.36,69.19},{38.34,69.13},{38.31,69.05},{38.28,68.95},{38.24,68.82},{38.19,68.67},{38.13,68.50},{38.07,68.31},{37.99,68.11},{37.89,67.89},{37.78,67.66},{37.62,67.43},{37.45,67.28},{37.25,67.19},{37.01,67.13},{36.74,67.11},{36.44,67.13},{36.12,67.20},{35.77,67.35},{35.50,67.56},{35.23,67.84},{34.94,68.16},{34.65,68.51},{34.37,68.87},{34.10,69.25},{33.86,69.61},{33.64,69.96},{33.48,70.36},{33.43,70.83},{33.48,71.32},{33.60,71.82},{33.77,72.30},{33.97,72.75},{34.20,73.17},{34.42,73.53},{34.61,73.87},{34.83,74.16},{35.08,74.36},{35.34,74.50},{35.60,74.60},{35.84,74.66},{36.07,74.71},{36.27,74.75},{36.44,74.78},{36.60,74.80},{36.73,74.81},{36.83,74.82},{36.93,74.83},{37.00,74.82},{37.06,74.82},{37.11,74.81},{37.15,74.80},{37.17,74.79}}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [25026] = {
            [npcKeys.waypoints] = {[zoneIDs.HOWLING_FJORD]={{{37.19,74.79},{37.22,74.80},{37.28,74.80},{37.36,74.81},{37.46,74.83},{37.58,74.87},{37.71,74.94},{37.82,75.07},{37.90,75.24},{37.93,75.46},{37.92,75.71},{37.88,76.01},{37.82,76.37},{37.84,76.74},{37.93,77.01},{38.02,77.33},{38.11,77.69},{38.22,78.10},{38.34,78.53},{38.50,79.00},{38.69,79.48},{38.91,79.90},{39.12,80.21},{39.38,80.50},{39.67,80.78},{39.98,81.05},{40.30,81.31},{40.62,81.56},{40.94,81.78},{41.24,82.00},{41.52,82.19},{41.81,82.38},{42.17,82.62},{42.50,82.83},{42.82,83.00},{43.13,83.14},{43.42,83.24},{43.70,83.31},{44.06,83.36},{44.43,83.35},{44.79,83.27},{45.11,83.16},{45.42,83.03},{45.75,82.79},{45.95,82.35},{46.03,81.83},{46.03,81.30},{46.02,80.80},{45.92,80.33},{45.74,79.89},{45.53,79.48},{45.31,79.12},{45.06,78.73},{44.88,78.28},{44.75,77.81},{44.65,77.29},{43.16,77.68},{43.13,77.68},{43.10,77.69},{43.05,77.69},{42.98,77.68},{42.90,77.67},{42.80,77.64},{42.69,77.60},{42.56,77.54},{42.41,77.45},{42.24,77.34},{42.07,77.21},{41.89,77.06},{41.73,76.91},{41.59,76.77},{41.47,76.64},{41.37,76.53},{41.29,76.43},{41.22,76.34},{41.16,76.28},{41.12,76.23},{41.09,76.19},{41.08,76.17},{41.04,76.12},{41.01,76.08},{40.95,76.03},{40.89,75.96},{40.81,75.88},{40.71,75.78},{40.60,75.67},{40.49,75.54},{40.36,75.40},{40.24,75.25},{40.13,75.10},{40.03,74.97},{39.95,74.85},{39.88,74.74},{39.83,74.65},{39.78,74.57},{39.74,74.51},{39.72,74.47},{39.70,74.44},{39.67,74.41},{39.64,74.36},{39.60,74.29},{39.55,74.20},{39.49,74.10},{39.42,73.97},{39.35,73.81},{39.29,73.62},{39.22,73.41},{39.16,73.18},{39.11,72.97},{39.07,72.78},{39.04,72.61},{39.01,72.47},{38.98,72.35},{38.97,72.25},{38.95,72.18},{38.94,72.13},{38.93,72.11},{38.92,72.08},{38.91,72.04},{38.88,71.97},{38.85,71.87},{38.82,71.75},{38.78,71.61},{38.75,71.43},{38.71,71.22},{38.66,70.99},{38.62,70.72},{38.57,70.45},{38.53,70.21},{38.49,69.99},{38.46,69.81},{38.43,69.66},{38.41,69.53},{38.39,69.42},{38.38,69.34},{38.37,69.28},{38.37,69.25},{38.36,69.23},{38.36,69.19},{38.34,69.13},{38.31,69.05},{38.28,68.95},{38.24,68.82},{38.19,68.67},{38.13,68.50},{38.07,68.31},{37.99,68.11},{37.89,67.89},{37.78,67.66},{37.62,67.43},{37.45,67.28},{37.25,67.19},{37.01,67.13},{36.74,67.11},{36.44,67.13},{36.12,67.20},{35.77,67.35},{35.50,67.56},{35.23,67.84},{34.94,68.16},{34.65,68.51},{34.37,68.87},{34.10,69.25},{33.86,69.61},{33.64,69.96},{33.48,70.36},{33.43,70.83},{33.48,71.32},{33.60,71.82},{33.77,72.30},{33.97,72.75},{34.20,73.17},{34.42,73.53},{34.61,73.87},{34.83,74.16},{35.08,74.36},{35.34,74.50},{35.60,74.60},{35.84,74.66},{36.07,74.71},{36.27,74.75},{36.44,74.78},{36.60,74.80},{36.73,74.81},{36.83,74.82},{36.93,74.83},{37.00,74.82},{37.06,74.82},{37.11,74.81},{37.15,74.80},{37.17,74.79}}}},
        },
        [25301] = {
            [npcKeys.waypoints] = {},
        },
        [25320] = {
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{42.59,36.75},{40.44,39.15},{41.79,42.55}}},
            [npcKeys.zoneID] = zoneIDs.BOREAN_TUNDRA,
        },
        [25335] = { --"Longrunner Proudhoof"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [25455] = {
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{50.25,9.66},},},
            [npcKeys.zoneID] = zoneIDs.BOREAN_TUNDRA,
        },
        [25469] = {
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{33.2,62.2},{33.6,59.8},{34,58.4},{34,63.8},{34.4,56.8},{34.4,63},{34.8,59},{34.8,63},{34.8,65.6},{35,61.8},{35,68.4},{35,68.8},{35.2,57.2},{35.2,63.8},{35.2,64.8},{35.4,58},{35.4,67},{35.6,60.8},{35.6,64.2},{35.6,64.6},{35.6,67.8},{35.8,60.4},{35.8,62.2},{35.8,62.6},{35.8,65.6},{36,58},{36,66.6},{36,73.6},{36.2,59.2},{36.4,69.8},{36.4,70.8},{36.6,57.2},{36.6,61.2},{36.6,70.4},{36.6,70.8},{36.8,68.6},{37,62.4},{37,62.6},{37,68},{37.2,59.4},{37.2,67},{37.4,58.4},{37.4,60.2},{37.6,59.2},{37.6,60.4},{37.6,61.2},{37.6,65.8},{38,69.4},{38.2,67},{38.2,68},{38.6,67},{38.6,69.2},{39.8,71.4},},},
            [npcKeys.zoneID] = zoneIDs.BOREAN_TUNDRA,
        },
        [25516] = { --"Snow Tracker Grumm"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [25602] = { --"Greatmother Taiga"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [25604] = { --"Sage Highmesa"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [25658] = { --"Longrunner Bristlehorn"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [25790] = {
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{46.04,62.01}}},
            [npcKeys.zoneID] = zoneIDs.BOREAN_TUNDRA,
        },
        [25794] = {
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{70.3,36.7}}},
            [npcKeys.zoneID] = zoneIDs.BOREAN_TUNDRA,
        },
        [25834] = {
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{64.57,23.2}}},
            [npcKeys.zoneID] = zoneIDs.BOREAN_TUNDRA,
        },
        [25847] = {
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{63.38,37.0}}},
        },
        [25889] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{41.57,65.92}}},
        },
        [25912] = {
            [npcKeys.spawns] = {[zoneIDs.ZANGARMARSH] = {{68.79,51.95}}},
        },
        [25918] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM] = {{32.11,68.31}}},
        },
        [25926] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{49.92,58.66}}},
        },
        [25938] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY] = {{33.4,30.53},},},
        },
        [25969] = {
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{61.08,40.07},{59.59,39.21},{60.85,33.6},{61.12,30.14},{61.66,35.96},{63.38,37.0}}},
            [npcKeys.zoneID] = zoneIDs.BOREAN_TUNDRA,
        },
        [25975] = {
            [npcKeys.spawns] = {
                [zoneIDs.TELDRASSIL]={{56.56,92.09}},
                [zoneIDs.IRONFORGE]={{65.36,25.06}},
                [zoneIDs.STORMWIND_CITY]={{50.13,72.56}},
                [zoneIDs.THE_EXODAR]={{40.90,25.59}},
            },
        },
        [25978] = { --"Ambassador Talonga"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [25982] = { --"Sage Earth and Sky"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [25983] = { --"Dorain Frosthoof", "Apprentice Wind Tamer"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26104] = { --"Iron Eyes"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26105] = {
            [npcKeys.spawns] = {[zoneIDs.THE_NEXUS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_NEXUS,
        },
        [26123] = {
            [npcKeys.spawns] = {
                [zoneIDs.IRONFORGE]={{64.82,26.28}},
                [zoneIDs.TELDRASSIL]={{56.02,92.22}},
                [zoneIDs.THE_EXODAR]={{42.51,25.97}},
                [zoneIDs.STORMWIND_CITY]={{49.03,71.95}},
            },
        },
        [26156] = { --"Wartook Iceborn"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26157] = { --"Taunka'le Brave"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26158] = { --"Mother Tauranook"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26159] = { --"Taunka'le Evacuee"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26170] = {
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA] = {{84.8,41.68},},},
        },
        [26179] = { --"Taunka'le Refugee"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26184] = { --"Taunka'le Refugee"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26225] = {
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA]={{85.4,33.34}}},
        },
        [26287] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT]={{63.7,27.62}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [26401] = { -- Summer Scorchling
            [npcKeys.spawns] = {[3518]={{49.57,69.4}},[3521]={{68.73,51.95}},[3522]={{41.52,65.87}},[3519]={{54.01,55.57}},[3520]={{39.63,54.56}},[3523]={{31.16,62.65}},[141]={{55.0,60.41}},[405]={{66.19,17.1}},[15]={{61.87,40.5}},[45]={{49.94,44.79}},[33]={{33.94,73.56}},[267]={{50.45,47.45}},[11]={{13.5,46.97}},[12]={{43.48,62.5}},[44]={{26.08,59.25}},[47]={{14.41,50.01}},[40]={{55.86,53.39}},[1]={{46.69,46.85}},[38]={{32.59,41.1}},[10]={{73.77,54.5}},[4]={{59.3,16.88}},[1377]={{57.56,35.23}},[618]={{62.52,35.47}},[440]={{52.79,29.32}},[331]={{37.79,54.81}},[148]={{36.95,46.23}},[3483]={{62.2,58.25}},[67]={{41.42,86.75}},[2817]={{78.07,74.91}},[66]={{40.37,61.4}},[495]={{57.84,16.18}},[394]={{33.94,60.52}},[65]={{75.24,43.77}},[3537]={{55.15,19.92}},[3711]={{48.12,65.93}},[3524]={{44.4,52.48}},[3525]={{55.81,67.74}},[357]={{28.27,43.86}},[46]={{80.28,63.03}},[28]={{43.43,82.24}},},
        },
        [26471] = { -- Image of Archmage Aethas Sunreaver
            [npcKeys.questEnds] = {11996,11999,12005,12059,12061,12066,12084,12110,12173,78168,78225},
        },
        [26488] = { --"Taunka Pack Kodo"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26520] = { -- Festival Scorchling
            [npcKeys.spawns] = {[67]={{40.27,85.41}},[2817]={{80.08,53.21}},[66]={{43.42,71.81}},[495]={{48.64,13.09}},[394]={{19.26,61.17}},[65]={{38.31,48.45}},[3537]={{51.16,11.47}},[3711]={{46.74,61.65}},[3430]={{46.41,50.51}},[3433]={{46.89,26.48}},[85]={{57.29,51.76}},[130]={{49.65,38.4}},[267]={{58.65,25.52}},[45]={{74.27,41.38}},[47]={{76.66,75.07}},[33]={{32.89,75.18}},[8]={{46.73,47.17}},[46]={{61.86,29.12}},[3]={{4.7,48.79}},[3519]={{51.97,42.96}},[3520]={{33.62,30.64}},[3522]={{49.92,58.75}},[3523]={{32.16,68.33}},[3483]={{57.17,41.99}},[3521]={{35.47,51.69}},[3518]={{50.97,34.13}},[14]={{52.15,47.25}},[618]={{59.88,35.58}},[331]={{70.2,69.31}},[17]={{52.22,28}},[15]={{33.49,30.91}},[400]={{42.36,52.93}},[440]={{49.81,26.99}},[1377]={{46.41,44.56}},[357]={{72.41,47.76}},[405]={{26.13,77.01}},[406]={{50.54,60.41}},[215]={{51.88,59.77}},},
        },
        [26527] = {
            [npcKeys.spawns] = {[zoneIDs.THE_CULLING_OF_STRATHOLME]={{86.45,61.47},{-1,-1}}},
        },
        [26533] = {
            [npcKeys.spawns] = {[zoneIDs.THE_CULLING_OF_STRATHOLME_CITY]={{32.3,46.2}},[zoneIDs.THE_CULLING_OF_STRATHOLME]={{-1,-1}}},
        },
        [26537] = { -- Greeb Ramrocket
            [npcKeys.questEnds] = {70737},
        },
        [26539] = { -- Meefi Farthrottle
            [npcKeys.questEnds] = {70737},
        },
        [26546] = { -- Ludin Farrow
            [npcKeys.questEnds] = {70411},
        },
        [26548] = { -- Leesha Tannerby
            [npcKeys.questEnds] = {70411},
        },
        [26555] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_PINNACLE_LOWER_LEVEL] = {{-1,-1}},[zoneIDs.UTGARDE_PINNACLE] = {{-1,-1}}},
        },
        [26584] = { --"Sage Paluna"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26620] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
        },
        [26621] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
        },
        [26623] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
        },
        [26631] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{69.7,47.3},{-1,-1}}},
        },
        [26632] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{47.6,13.3}},[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}}},
        },
        [26633] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS] = {{51.8,18.2}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [26635] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
        },
        [26636] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
        },
        [26637] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [26638] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
        },
        [26639] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
        },
        [26647] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT] = {{54.50,23.62}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [26648] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT] = {{34.18,86.05}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [26664] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{69.9,22.1},{67.6,30.6},{63.7,25},{64,14.2},{69.7,15.1},{71.2,17.5},{-1,-1}}},
        },
        [26669] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_PINNACLE_LOWER_LEVEL]={{-1,-1}},[zoneIDs.UTGARDE_PINNACLE] = {{-1,-1}}},
        },
        [26670] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_PINNACLE_LOWER_LEVEL]={{-1,-1}},[zoneIDs.UTGARDE_PINNACLE] = {{-1,-1}}},
        },
        [26673] = { -- Image of Archmage Modera
            [npcKeys.questEnds] = {11995,12000,12004,12055,12060,12065,12083,12107,12172,12440,78166,78223},
        },
        [26678] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT]={{25.24,41.16}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [26691] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_PINNACLE_LOWER_LEVEL]={{-1,-1}},[zoneIDs.UTGARDE_PINNACLE] = {{-1,-1}}},
        },
        [26694] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_PINNACLE_LOWER_LEVEL]={{-1,-1}},[zoneIDs.UTGARDE_PINNACLE] = {{-1,-1}}},
        },
        [26680] = { --"Aiyan Coldwind", "Innkeeper"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26696] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_PINNACLE] = {{42.8,52.7},{42.8,54.1},{49.4,53.3},{49.4,53.9},{61.8,35.6},{-1,-1}},[zoneIDs.UTGARDE_PINNACLE_LOWER_LEVEL] = {{55.6,33.5},{57.5,18.4}}},
            [npcKeys.waypoints] = {[zoneIDs.UTGARDE_PINNACLE]={{{49.4,53.3},{55.9,53.9}}},[zoneIDs.UTGARDE_PINNACLE_LOWER_LEVEL]={{{48.4,44.5},{51.5,42.8},{54,38.9},{56,38.2},{55.9,42.9},{55,46.2},{53,47.9},{50.9,45.9},{48.4,44.5}}}},
        },
        [26697] = { --"Tewah Chillmane", "Leather Armor Merchant"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26707] = { --"Litoko Icetotem", "Armor Merchant"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26709] = { --"Pahu Frosthoof", "Innkeeper"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26718] = { --"Trader Alorn", "General Goods"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26720] = { --"Danook Stormwhisper", "Trade Goods"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26721] = { --"Halona Stormwhisper", "Stable Master"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26723] = {
            [npcKeys.spawns] = {[zoneIDs.THE_NEXUS] = {{36.1,67.4},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_NEXUS,
        },
        [26725] = { --"Wind Tamer Oril"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26766] = { --"Brave Storming Sky"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26790] = { --"Taunka'le Longrunner"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26792] = {
            [npcKeys.spawns] = {[zoneIDs.THE_NEXUS] = {{50.2,68.4},{54.7,55.9},{58.5,55.3},{59.8,48.5},{65.1,51.2},{62.6,63.9},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_NEXUS,
        },
        [26810] = { --"Roanauk Icemist", "High Chieftain of the Taunka"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26830] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
        },
        [26847] = { --"Omu Spiritbreeze", "Wind Rider Master"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26853] = { --"Makki Wintergale", "Wind Rider Master"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26860] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{20.7,64.17}}},
        },
        [26861] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_PINNACLE] = {{40.9,53.4},{-1,-1}}},
        },
        [26935] = { -- Sasha
            [npcKeys.spawns] = {
                [zoneIDs.GRIZZLY_HILLS] = {
                    {57.6,41.2}, -- She is always at this place, but sometimes also at the ones below
                    {64.8,43.4,phases.SASHA_DUSKHOWL_DEN},
                    {87,25.6,phases.SASHA_BLOODMOON_ISLE},
                },
            },
            [npcKeys.waypoints] = {},
        },
        [26936] = { --"Chaska Frosthoof", "General Goods"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26939] = { --"Koro the Wanderer", "Trade Goods"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26944] = { --"Soulok Stormfury", "Stable Master"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26950] = { --"Sanut Swiftspear", "Reagents and Poisons"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26986] = { --"Tiponi Stormwhisper", "Grand Master Skinning Trainer"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [26996] = { --"Awan Iceborn", "Grand Master Leatherworker"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [27102] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{20.91,64.02}}},
        },
        [27126] = { --"Camp Oneqwah Brave"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [27199] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{71.41,23.78}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27216] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{45.25,17.33}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [27221] = { --"Tormak the Scarred", "Camp Oneqwah Chieftain"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [27249] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT]={{64.51,78.68}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [27315] = {
            [npcKeys.spawns] = {
                [zoneIDs.DRAGONBLIGHT] = {{77.2,49.8},{78.2,50.6},{78.8,50.8},{79.8,49.6},{80,49.4},{80,51},{81.8,50.6},{82.2,50.4},{83,49.2},{83,50.2},{83.4,51},{84.2,50.4},{84.6,51.6},{84.8,50.4},}
            },
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [27328] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{52.62,24.06}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27383] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT]={{80.94,50.63}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [27409] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{26.24,31.11}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27431] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [27495] = { -- Barblefink
            [npcKeys.questStarts] = {12443,12446},
            [npcKeys.questEnds] = {12443,12446},
        },
        [27565] = { -- Gurtor
            [npcKeys.questStarts] = {12433,12434},
            [npcKeys.questEnds] = {12433,12434},
        },
        [27575] = { -- #4675
            [npcKeys.name] = "Lord Devrestrasz",
        },
        [27588] = {
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[65]={{85.61,49.82}}},
        },
        [27627] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{62.18,42.41}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27641] = {
            [npcKeys.spawns] = {[zoneIDs.BAND_OF_ACCELERATION]={{40.9,67.1},{40.1,55.2},{57.6,54.1},{57.5,66},{72.2,73.3},{72.7,77.4},{74.7,75.3},{27.4,79.8},{25.9,81.2},{25.8,78.5}},[zoneIDs.THE_OCULUS]={{-1,-1}}},
        },
        [27642] = {
            [npcKeys.spawns] = {[zoneIDs.BAND_OF_TRANSMUTATION]={{-1,-1}},[zoneIDs.THE_OCULUS]={{-1,-1}}},
        },
        [27655] = {
            [npcKeys.spawns] = {[zoneIDs.BAND_OF_ALIGNMENT]={{39.7,35.7}},[zoneIDs.THE_OCULUS]={{-1,-1}}},
        },
        [27656] = {
            [npcKeys.spawns] = {[zoneIDs.BAND_OF_ALIGNMENT]={{47.3,13.3}},[zoneIDs.THE_OCULUS]={{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.BAND_OF_ALIGNMENT]={{{47.3,13.3},{43.8,13.9},{40.5,15.5},{37.2,18.4},{34.4,22.2},{31.9,27},{30,33.7},{29.3,40.3},{29.9,48.7},{31.8,55.3},{34.2,60},{37.5,64.4},{42,68},{47.8,69.5},{53.3,68.3},{57.3,65.4},{60.7,61.9},{63.4,56.9},{65.9,48.9},{66.4,43.4},{66.3,36.6},{64.6,28.4},{62.3,23},{58.2,17.8},{54,14.8},{50.1,13.3},{47.3,13.3}}}},
        },
        [27658] = {
            [npcKeys.spawns] = {[zoneIDs.THE_OCULUS]={{50,81.2},{-1,-1}}},
        },
        [27447] = {
            [npcKeys.spawns] = {[zoneIDs.BAND_OF_ACCELERATION]={{46.1,19.1}},[zoneIDs.THE_OCULUS]={{-1,-1}}},
        },
        [27688] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{21.66,84.54}}},
        },
        [27702] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{9.45,78.42}}},
        },
        [27708] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{14.83,86.63}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27715] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{23.32,64.84}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27716] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{23.32,64.84}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27717] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{23.32,64.84}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27718] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{23.32,64.84}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27727] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{23.32,64.84}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27744] = {
            [npcKeys.spawns] = {[zoneIDs.THE_CULLING_OF_STRATHOLME_CITY]={{66.4,28},{62.1,31.1},{59.3,27.1},{57.8,32.2}},[zoneIDs.THE_CULLING_OF_STRATHOLME]={{-1,-1}}},
        },
        [27759] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{14.83,86.63}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [27788] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT]={{87.15,51.78},{84.73,50.04}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [27840] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT]={{71.71,39.21}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [27843] = {
            [npcKeys.waypoints] = {},
        },
        [27871] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}},[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{-1,-1}}},
        },
        [27909] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}}},
        },
        [27915] = {
            [npcKeys.spawns] = {[zoneIDs.THE_CULLING_OF_STRATHOLME]={{47.5,39.7},{-1,-1}}},
        },
        [27959] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD] = {{61.1,2}}},
            [npcKeys.zoneID] = zoneIDs.HOWLING_FJORD,
        },
        [27978] = {
            [npcKeys.spawns] = {[zoneIDs.HALLS_OF_STONE]={{49.9,13.3},{-1,-1}}},
        },
        [27996] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT]={{59.83,52.87}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [28012] = {
            [npcKeys.spawns] = {[zoneIDs.BAND_OF_ACCELERATION]={{46.1,19.1}},[zoneIDs.BAND_OF_ALIGNMENT]={{39.7,35.7}},[zoneIDs.THE_OCULUS]={{-1,-1}}},
        },
        [28013] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT]={{71.81,82.70}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [28016] = {
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP_UPPER_LEVEL]={{47.6,13.3}},[zoneIDs.DRAKTHARON_KEEP]={{-1,-1}}},
        },
        [28026] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{35.21,64.79},{37.15,64.77},{36.51,64.55},{37.99,65.5}}},
        },
        [28039] = { -- Commander Kunz
            [npcKeys.questEnds] = {12501,12563,12587,12596,12604},
        },
        [28070] = {
            [npcKeys.spawns] = {[zoneIDs.HALLS_OF_STONE]={{71.1,48.5},{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [28083] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{49.8,85},{51.6,86.2},{58,83.8},{58.8,85.6}}},
        },
        [28118] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{41.39,73.83},{42.94,76.3},{44.57,79},{43.01,81.33},{41.45,78.86},{39.95,76.07}}},
        },
        [28120] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{54.51,56.32}}},
            [npcKeys.zoneID] = zoneIDs.SHOLAZAR_BASIN,
        },
        [28122] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{74.74,51.04}}},
            [npcKeys.zoneID] = zoneIDs.SHOLAZAR_BASIN,
        },
        [28126] = { -- Don Carlos
            [npcKeys.questStarts] = {12513,12515},
            [npcKeys.questEnds] = {12513,12515},
        },
        [28136] = {
            [npcKeys.spawns] = {},
        },
        [28142] = {
            [npcKeys.spawns] = {},
        },
        [28148] = {
            [npcKeys.spawns] = {},
        },
        [28203] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{41.53,61.04},{47.19,51.93},{49.18,62.25},{48.47,60.92},{41.09,62.01},{41.06,61.96},{47.89,66.69},{50.28,62.95},{41.21,55.06},{41.07,58.88},{46.51,60.48},{46.33,62.68},{42.62,57.98},{46.31,64.7},{44.8,52.73},{42.59,68.34},{43.8,56.65},{41.1,56.64},{45.18,60.78},{46.06,70.15},{42.3,55.0},{45.17,71.5},{43.6,52.29},{48.91,64.85},{42.4,56.71},{45.1,62.74},{45.03,56.7},{42.34,64.04},{42.34,66.46},{43.68,58.93},{43.5,54.65},{42.58,59.31},{42.45,60.62},{41.29,60.04}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [28214] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{55.33,69.77}}},
            [npcKeys.zoneID] = zoneIDs.SHOLAZAR_BASIN,
        },
        [28216] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{46.25,39.68}}},
            [npcKeys.zoneID] = zoneIDs.SHOLAZAR_BASIN,
        },
        [28217] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{58.48,62.49},{56.64,62.44},{58.37,64.67},{55.7,64.98},{54.05,64.53},{55.4,62.94}}},
            [npcKeys.zoneID] = zoneIDs.SHOLAZAR_BASIN,
        },
        [28256] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{26.21,71.46}}},
            [npcKeys.zoneID] = zoneIDs.SHOLAZAR_BASIN,
        },
        [28277] = {
            [npcKeys.spawns] = {[zoneIDs.HOWLING_FJORD]={{80.87,75.09}}},
        },
        [28314] = { --"Longrunner Nanik"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [28318] = {
            [npcKeys.spawns] = {[zoneIDs.SHATTRATH_CITY]={{44.22,34.85}}},
        },
        [28323] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{41.8,62.4},{42,62.8},{42.4,55.6},{42.4,58.2},{42.4,60},{42.6,57.8},{42.6,58.6},{42.6,61.2},{42.6,62.6},{42.8,55.8},{42.8,61.6},{43,60.4},{43,65.2},{43.4,65.6},{43.4,70},{43.6,65.4},{43.6,65.6},{43.8,60.8},{43.8,70.6},{44,57},{44.2,57.6},{44.2,63.4},{44.2,63.6},{44.4,55.2},{44.4,55.6},{44.6,55.4},{44.6,55.6},{44.6,63.4},{44.6,68},{44.8,68.6},{45.2,61},{45.6,61.4},{45.6,68.4},{47,65.6},{47.2,65},{49.4,64.2},{49.4,64.6},{49.6,64.2}}},
        },
        [28325] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{58.48,62.49},{56.64,62.44},{58.37,64.67},{55.7,64.98},{54.05,64.53},{55.4,62.94}}},
            [npcKeys.zoneID] = zoneIDs.SHOLAZAR_BASIN,
        },
        [28341] = {
            [npcKeys.spawns] = {[zoneIDs.THE_CULLING_OF_STRATHOLME_CITY]={{-1,-1}},[zoneIDs.THE_CULLING_OF_STRATHOLME]={{-1,-1}}},
        },
        [28358] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{57.4,52.2},{58.4,53.8},},},
        },
        [28389] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{46.23,27.47},{48.85,27.4},{48.17,21.12},{47.81,22.72},{47.63,24.05},{47.67,22.57},{48.86,24.45},{49.71,28.79},{45.21,31.17},{47.62,27.79},{49.45,22.81},{44.8,28.62},{45.54,30.47}}},
        },
        [28401] = { -- Har'koa
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={
                {60.25,57.74,phases.HAR_KOA_AT_ZIM_TORGA},
                {63.72,70.42,phases.HAR_KOA_AT_ALTAR},
            }},
        },
        [28402] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{59,69.2},{59.8,68},{60.4,69.69},{60.95,66.35},{60.96,70.45},{61.96,64.81},{62.2,74},{62.4,69.4},{62.43,72.23},{62.67,69.67},{62.86,63.39},{63.39,74.79},{63.4,68.2},{63.6,76.6},{64.04,62.56},{65.04,63.98},{64.7,63.52},{65.2,69.2},{65.6,67.8},{66,74.2}}},
        },
        [28403] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{59.51,70.48},{60.48,71.83},{61.9,67.58},{62.2,68.2},{62.44,67.84},{62.6,71},{63.2,70.6},{63.4,72.2},{63.6,71.4},{63.8,69.8},{64,68.4},{64.6,67.4},{64.6,70.6},{64.8,70},{65.6,65.8},{66.4,67},{66.4,70.4}}},
        },
        [28411] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{48.8,39},{48.8,45.4},{49,42.6},{49.2,40.6},{49.2,46.6},{49.2,48.6},{49.6,41.4},{50.4,42.6},{50.4,44.8},{50.4,46.4},{50.6,47.2},{50.6,48.2},{50.6,50.6},{50.8,44.4},{56.03,49.64},{55.51,50.22},{51.6,42.6},{51.8,46.8},{51.8,48.4},{51.8,49.2},{51.8,50.8},{51.8,52.6},{51.8,54.4},{52,45.6},{52,52},{52.4,44.4},{52.4,50},{52.4,55.6},{52.6,44.8},{53,54.4},{53.2,44.2},{53.2,50.6},{53.2,52.4},{53.6,43.8},{53.8,50.4},{53.8,52.4},{54.2,54.6},{54.4,50.6},{54.8,44.8},{54.8,50.2},{54.8,54},{55,42},{55,51.6},{55.4,43.6},{55.4,52.8},{55.6,42.8},{55.6,45.2},{55.8,44.2},{55.8,52.2},{55.8,54.4},{56.2,45.8},{56.2,46.8},{56.2,48.4},{56.2,50.6},{52.74,58.28},{56.6,52.8},{56.26,47.53},{56.6,53.6},{56.8,45.6},{57,42.8},{57,44.4},{57,46.6},{57,48.4},{57,50.4},{57,52.4},{57.6,41.6},{57.8,49.4},{58,49.6},{58.4,50.6}}},
        },
        [28417] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{56.22,40.43},{56.59,40.09},{55.52,37.11},{55.57,34.93},{51.53,36.94},{52.49,37.15},{50.56,35.9},{49.63,35.9},{50.2,40.15},{50.52,40.58},{53.27,36.96},{53.36,39.91},{57.15,35.76},{56.22,35.78},{54.49,37.15},{53.66,36.98},{53.29,35.1},{53.14,45.75},{52.8,47.87},{53.8,45.62},{54.36,46.04},{55,45.98},{55.35,46.61},{55.37,47.62},{55.42,48.57},{55.04,49.41},{54.4,49.3},{53.97,48.95},{53.35,49.12},{52.97,48.63}}},
        },
        [28452] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{48.8,39.2},{48.8,45.6},{49.8,41.6},{49.8,48.6},{50.6,47.4},{51,44.8},{51.6,42.6},{52.2,52},{52.4,55.4},{53.2,44.2},{53.8,52.4},{54.8,54},{55,42.2},{55,51.8},{55.8,44.2},{56.4,50.2},{56.4,52.8},{56.8,45.6},{57.6,41.8},{57.8,49.4}}},
        },
        [28471] = { -- Lady Alistra
            [npcKeys.questStarts] = {78220,78221,78222,78223,78224,78225},
            [npcKeys.questEnds] = {78219,78220,78221,78222,78224},
        },
        [28472] = { -- Lord Thorval
            [npcKeys.questStarts] = {12849,78220,78221,78222,78223,78224,78225},
            [npcKeys.questEnds] = {12849,78219,78220,78221,78222,78224},
        },
        [28474] = { -- Amal'thazad
            [npcKeys.questStarts] = {78220,78221,78222,78223,78224,78225},
            [npcKeys.questEnds] = {78219,78220,78221,78222,78224},
        },
        [28546] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TERRESTRIAL_WATCHTOWER]={{60.9,77.2}},[zoneIDs.HALLS_OF_LIGHTNING]={{-1,-1}}},
        },
        [28584] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TERRESTRIAL_WATCHTOWER]={{-1,-1}},[zoneIDs.HALLS_OF_LIGHTNING]={{-1,-1}}},
        },
        [28587] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TERRESTRIAL_WATCHTOWER]={{37.6,20.9}},[zoneIDs.HALLS_OF_LIGHTNING]={{-1,-1}}},
        },
        [28636] = { -- Heb'Jin
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{65.64,50.46}}},
        },
        [28639] = { -- Heb'Jin's Bat
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{65.64,50.46}}},
        },
        [28684] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{50.2,44.6},{-1,-1}}},
        },
        [28701] = { -- Timothy Jones
            [npcKeys.questStarts] = {12958,12959,12960,12961,12962,12963,13041,14103},
            [npcKeys.questEnds] = {12958,12959,12960,12961,12962,12963,13041,13148,14103,14160},
        },
        [28708] = { -- Kizi Copperclip
            [npcKeys.npcFlags] = npcFlags.BARBER,
        },
        [28730] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
        },
        [28731] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
        },
        [28732] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
        },
        [28734] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
        },
        [28788] = {
            [npcKeys.spawns] = {[zoneIDs.PLAGUELANDS_THE_SCARLET_ENCLAVE]={{52.61,34.38}}},
        },
        [28826] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TERRESTRIAL_WATCHTOWER]={{-1,-1}},[zoneIDs.HALLS_OF_LIGHTNING]={{-1,-1}}},
        },
        [28838] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TERRESTRIAL_WATCHTOWER]={{40.1,66.5},{45,82.6},{40.2,84},{45.1,68.1},{32.7,75.8},{33.2,75.8},{51.2,75.8},{51.9,75.8}},[zoneIDs.HALLS_OF_LIGHTNING]={{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_TERRESTRIAL_WATCHTOWER]={{{32.7,75.8},{32.9,72.2},{34.2,70.4},{36.2,69.4},{39.1,70.4},{40.7,72.2},{41.3,74.9},{40.7,77.8},{39.1,80.3},{36.4,81.1},{34.5,80.7},{32.9,78.8},{32.7,75.8}},{{51.2,75.8},{51.1,78.8},{49.5,80.1},{47.8,80.7},{45.6,80.3},{44.3,77.6},{43.8,75.3},{44.3,72.5},{45.8,70.8},{47.8,69.8},{49.8,70.6},{50.8,72.2},{51.2,75.8}}}},
        },
        [28859] = {
            [npcKeys.spawns] = {[4500]={{45.68,61.39},{-1,-1}}},
        },
        [28860] = {
            [npcKeys.spawns] = {[4493]={{50.07,47.75},{-1,-1}}},
        },
        [28912] = {
            [npcKeys.waypoints] = {},
        },
        [28921] = {
            [npcKeys.spawns] = {[zoneIDs.HADRONOXS_LAIR]={{43.3,59}},[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [28922] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [28923] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TERRESTRIAL_WATCHTOWER]={{19.2,51.7}},[zoneIDs.HALLS_OF_LIGHTNING]={{-1,-1}}},
        },
        [28931] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{29.34,45.13},{28.21,46.28},{27.44,44.6},{28.56,43.44}}},
        },
        [28948] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{27.21,42.32}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [29018] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{49,63}}},
        },
        [29033] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{43,42}}},
        },
        [29034] = {
            [npcKeys.spawns] = {[zoneIDs.SHOLAZAR_BASIN]={{46,74}}},
        },
        [29087] = {
            [npcKeys.spawns] = {[zoneIDs.SHATTRATH_CITY]={{53.93,34.3}}},
        },
        [29117] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [29118] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [29120] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BROOD_PIT]={{63.2,48.1}},[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
        },
        [29128] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BROOD_PIT]={{63.2,48.1}},[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
        },
        [29139] = { -- Naznik Sureshave
            [npcKeys.npcFlags] = npcFlags.BARBER,
        },
        [29141] = { -- Pella Brassbrush
            [npcKeys.npcFlags] = npcFlags.BARBER,
        },
        [29142] = { -- Jelinek Sharpshear
            [npcKeys.npcFlags] = npcFlags.BARBER,
        },
        [29143] = { -- Bebri Coifcurl
            [npcKeys.npcFlags] = npcFlags.BARBER,
        },
        [29145] = { -- Pulik Swiftsnip
            [npcKeys.npcFlags] = npcFlags.BARBER,
        },
        [29173] = {
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[zoneIDs.PLAGUELANDS_THE_SCARLET_ENCLAVE]={{39.06,39.16}}},
        },
        [29194] = {
            [npcKeys.subName] = "Death Knight Trainer",
        },
        [29195] = {
            [npcKeys.subName] = "Death Knight Trainer",
        },
        [29196] = {
            [npcKeys.subName] = "Death Knight Trainer",
        },
        [29216] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BROOD_PIT]={{63.2,48.1}},[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
        },
        [29301] = { --"Camp Winterhoof Wayfarer"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [29306] = {
            [npcKeys.spawns] = {[zoneIDs.GUNDRAK]={{46.6,28},{-1,-1}}},
        },
        [29311] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{21.43,50.95},{-1,-1}}},
        },
        [29313] = {
            [npcKeys.spawns] = {[4415]={{60.99,25.06},{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [29335] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [29339] = {
            [npcKeys.spawns] = {[zoneIDs.SILVERMOON_CITY]={{52.69,19.86}}},
        },
        [29340] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
        },
        [29346] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR]={{31.64,37.38}}},
        },
        [29348] = {
            [npcKeys.spawns] = {[zoneIDs.THUNDER_BLUFF]={{69.84,31.31}}},
        },
        [29456] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{19.74,47.93},},},
            [npcKeys.waypoints] = {[zoneIDs.ICECROWN]={{{20.03,47.56},{20.26,47.70},{20.32,47.93},{20.26,48.16},{20.03,48.30},{19.80,48.16},{19.74,47.93},{19.80,47.70},{20.03,47.56}}}},
        },
        [29503] = {
            [npcKeys.waypoints] = {[zoneIDs.STORM_PEAKS] = {{{77.4,62.8},{77.2,63.8},{76.15,63.9}}}},
        },
        [29560] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN] = {{9.53,47.01}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [29563] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{54.79,60.36}}},
        },
        [29573] = {
            [npcKeys.spawns] = {[zoneIDs.GUNDRAK]={{46.5,65.3},{-1,-1}}},
        },
        [29579] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{30.1,73.9}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [29595] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{63.24,62.52},{61.48,61.4},{63.0,60.41},{63.84,58.29},{62.76,60.93},{65.35,62.54},{59.82,60.46},{61.29,59.34},{57.85,61.98},{59.23,59.01},{58.58,60.81},},},
        },
        [29597] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{60.55,60.22},{57.78,62.32},{60.8,58.67},{60.74,61.13},{59.01,61.85},{59.66,60.87},{58.57,62.99},{59.88,59.07},{58.15,63.85},{58.58,59.45},{56.69,64.95},{56.85,63.18},},},
        },
        [29611] = { -- King Varian Wrynn
            [npcKeys.questStarts] = {396,6182,6187,7496,13369,13371},
        },
        [29650] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{29.61,74.07}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [29677] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{36.4,64.2}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [29762] = { --"Hyeyoung Parka", "Wind Rider Master"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [29795] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{64.78,28.41}}},
            [npcKeys.waypoints] = waypointPresets.ORGRIMS_HAMMER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [29799] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{63.59,52.34}}},
            [npcKeys.waypoints] = waypointPresets.THE_SKYBREAKER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [29806] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS]={{37.76,46.54}}},
        },
        [29811] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS]={{37.68,66.75},{38.49,77.19},{31.65,64.53},{34.56,64.64},{36.43,77.3},{38.26,73.22}}},
        },
        [29821] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{32.50,63.37},},},
        },
        [29840] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{42.56,20.81},},},
            [npcKeys.waypoints] = {[zoneIDs.ICECROWN]={{{42.56,20.81},{42.80,20.02},{43.36,19.23},{44.32,18.80},{45.28,19.23},{45.84,20.02},{46.08,20.81},{46.15,21.54},{46.08,22.27},{45.84,23.06},{45.28,23.85},{44.32,24.28},{43.36,23.85},{42.80,23.06}}}},
        },
        [29854] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS]={{33.39,73.52},{33.21,73.63},{32.73,73.86},{32.39,73.84},{32.41,74.32},{32.63,74.87},{33.55,74.88},{33.77,74.42},{33.9,73.64},{32.66,71.97},{33.81,72.63}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [29872] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{28.38,44.85},},},
            [npcKeys.waypoints] = {[zoneIDs.ZUL_DRAK]={{{28.38,46.85},{29.79,46.26},{30.38,44.85},{29.79,43.44},{28.38,42.85},{26.97,43.44},{26.38,44.85},{26.97,46.26},{28.38,46.85}}}},
        },
        [29875] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{43.4,74.2},{44.4,73.8},{45.2,74},{45.4,74.8},{45.8,73},{45.8,75.4},{46.4,74},{46.4,76.2},{46.4,78.4},{46.4,78.8},{46.6,74},{46.6,78.8},{46.8,74.6},{46.8,77.4},{46.8,77.6},{47,72.4},{47,72.6},{47.4,76.2},{47.6,78.8},{48.2,74},{48.2,76.6},{48.4,75},{48.4,75.6},{48.6,77.2},{48.8,79.4},{48.8,79.8},{49,76.4},}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [29895] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{31.19,61.86}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [29968] = { --"Hapanu Coldwind", "Poisons & Reagents"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [29969] = { --"Ontak", "Blacksmithing Supplies"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [29970] = { --"Danho Farcloud", "General Goods"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [29971] = { --"Wabada Whiteflower", "Innkeeper"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [29973] = { --"Tunka'lo Brave"
            [npcKeys.friendlyToFaction] = "H",
            [npcKeys.factionID] = 1064,
        },
        [29999] = {
            [npcKeys.spawns] = {},
        },
        [30014] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{47.09,57.27}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [30017] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{47.72,56.13}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [30019] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{47.85,56.82}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [30020] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{47.8,56.77}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [30022] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{47.8,56.78}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [30023] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{47.96,57.2}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [30024] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{47.85,56.82}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [30025] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{47.85,56.82}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [30026] = {
            [npcKeys.spawns] = {[zoneIDs.ZUL_DRAK]={{47.85,56.82}}},
            [npcKeys.zoneID] = zoneIDs.ZUL_DRAK,
        },
        [30053] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{41.8,65.8},{42,63.4},{42,65},{42.4,63.8},{42.4,66.8},{42.6,63.8},{42.6,66.4},{42.8,65},{43,67.4},{43.2,67.6},{43.6,67.6},{43.8,67},{44,66.4}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30082] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{38.2,61.6}}},
        },
        [30120] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{76.8,63},{77,62.2},{77.6,62.6}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30134] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{39.62,56.45}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30137] = {
            [npcKeys.waypoints] = {[zoneIDs.THE_UNDERBELLY] = {{{51.64,45.28},{51.61,45.94},{51.49,46.59},{51.34,47.21},{51.19,47.85},{51.17,48.51},{51.35,49.12},{51.62,49.64},{51.91,50.15},{52.12,50.73},{52.15,51.39},{52.12,52.05},{52.10,52.72},{52.16,53.38},{52.31,54.01},{52.51,54.61},{52.77,55.15},{53.09,55.62},{53.45,56.03},{53.84,56.34},{54.27,56.48},{54.72,56.49},{55.16,56.46},{55.59,56.31},{55.99,56.01},{56.35,55.63},{56.65,55.15},{56.83,54.54},{56.98,53.91},{57.14,53.28},{57.25,52.64},{57.29,51.98},{57.24,51.32},{57.10,50.69},{56.88,50.11},{56.57,49.62},{56.18,49.29},{55.77,49.06},{55.34,48.86},{54.90,48.72},{54.45,48.72},{54.03,48.92},{53.62,49.19},{53.20,49.40},{52.76,49.41},{52.36,49.12},{51.98,48.76},{51.61,48.40},{51.21,48.16},{50.81,48.44},{50.44,48.82},{50.07,49.19},{49.66,49.46},{49.23,49.58},{48.78,49.57},{48.35,49.42},{47.94,49.19},{47.54,48.88},{47.18,48.50},{46.87,48.03},{46.61,47.49},{46.41,46.89},{46.30,46.25},{46.28,45.58},{46.32,44.92},{46.38,44.26},{46.45,43.60},{46.36,42.96},{46.04,42.48},{45.72,42.02},{45.43,41.52},{45.19,40.96},{45.28,40.32},{45.47,39.71},{45.62,39.09},{45.71,38.42},{45.69,37.76},{45.56,37.11},{45.39,36.50},{45.13,35.95},{44.84,35.46},{44.49,35.05},{44.10,34.74},{43.67,34.53},{43.24,34.39},{42.80,34.43},{42.37,34.62},{41.97,34.90},{41.59,35.23},{41.27,35.70},{41.00,36.23},{40.78,36.81},{40.59,37.41},{40.51,38.06},{40.59,38.72},{40.69,39.37},{40.87,39.97},{41.16,40.48},{41.48,40.95},{41.81,41.39},{42.17,41.77},{42.61,41.87},{43.05,41.79},{43.49,41.64},{43.92,41.50},{44.35,41.32},{44.78,41.13},{45.20,40.91},{45.63,40.75},{46.05,40.93},{46.43,41.28},{46.81,41.62},{47.21,41.93},{47.64,41.94},{48.07,41.74},{48.50,41.56},{48.94,41.47},{49.38,41.57},{49.81,41.75},{50.22,42.00},{50.59,42.38},{50.92,42.81},{51.19,43.33},{51.32,43.97},{51.46,44.60},{51.64,45.29}}}},
            [npcKeys.zoneID] = zoneIDs.THE_UNDERBELLY,
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBELLY] = {{45.4,41.1},}},
        },
        [30163] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{68.4,58},{68.6,60},{68.6,63.2},{69.2,57},{69.4,58.8},{69.6,59},{69.6,61.2},{70,60.2},{70.2,57.4},{70.2,58.4},{70.2,62.4},{70.6,59.4},{70.6,59.6},{70.8,56.8},{70.8,58.4},{70.8,61.2},{71.8,62.8},{72.4,62.2},{72.6,62.2},}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30208] = {
            [npcKeys.spawns] = {},
        },
        [30210] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{64.21,59.21},},},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30222] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{56.91,65.11},{56.72,63.79},{57.48,63.05},{57.85,65.01}}},
        },
        [30236] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{85.2,75.8},{85.8,76.6},{85.8,78},{86,74.8},},},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30276] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{-1,-1}}},
        },
        [30277] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{-1,-1}}},
        },
        [30278] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{-1,-1}}},
        },
        [30283] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{-1,-1}}},
        },
        [30284] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [30286] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{-1,-1}}},
        },
        [30287] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{-1,-1}}},
        },
        [30295] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{56.3,51.4},},},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30300] = {
            [npcKeys.minLevel] = 80,
            [npcKeys.maxLevel] = 80,
            [npcKeys.minLevelHealth] = 315000,
            [npcKeys.maxLevelHealth] = 315000,
            [npcKeys.waypoints] = {[zoneIDs.STORM_PEAKS]={{{28.84,47.95},{28.62,47.50},{28.35,46.90},{28.13,46.25},{27.91,45.61},{27.69,44.95},{27.50,44.29},{27.35,43.60},{27.20,42.90},{27.16,42.75}}}},
        },
        [30301] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{26.2,35.8},{27.2,35.8}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30302] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{63.59,52.34}}},
            [npcKeys.waypoints] = waypointPresets.THE_SKYBREAKER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30315] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{45,49}}},
        },
        [30316] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{64,47}}},
        },
        [30317] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{52,56}}},
        },
        [30318] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{53,42}}},
        },
        [30329] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{65.9,60.7},{65.9,65.7},{69,71.6},{70.9,75.3},{61.4,72.9},{59.2,80.3},{-1,-1}}},
        },
        [30340] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{54.74,60.65}}},
        },
        [30341] = {
            [npcKeys.minLevel] = 80,
            [npcKeys.maxLevel] = 80,
            [npcKeys.minLevelHealth] = 50400,
            [npcKeys.maxLevelHealth] = 50400,
        },
        [30344] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{63.59,52.34}}},
            [npcKeys.waypoints] = waypointPresets.THE_SKYBREAKER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30345] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{63.59,52.34}}},
            [npcKeys.waypoints] = waypointPresets.THE_SKYBREAKER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30348] = { -- Elder Sardis
            [npcKeys.questStarts] = {13012},
            [npcKeys.questEnds] = {13012},
        },
        [30357] = { -- Elder Beldak
            [npcKeys.questStarts] = {13013},
            [npcKeys.questEnds] = {13013},
        },
        [30358] = { -- Elder Morthie
            [npcKeys.questStarts] = {13014},
            [npcKeys.questEnds] = {13014},
        },
        [30359] = { -- Elder Fargal
            [npcKeys.questStarts] = {13015},
            [npcKeys.questEnds] = {13015},
        },
        [30360] = { -- Elder Northal
            [npcKeys.questStarts] = {13016},
            [npcKeys.questEnds] = {13016},
        },
        [30362] = { -- Elder Sandrene
            [npcKeys.questStarts] = {13018},
            [npcKeys.questEnds] = {13018},
        },
        [30363] = { -- Elder Thoim
            [npcKeys.questStarts] = {13019},
            [npcKeys.questEnds] = {13019},
        },
        [30364] = { -- Elder Arp
            [npcKeys.questStarts] = {13033},
            [npcKeys.questEnds] = {13033},
        },
        [30365] = { -- Elder Wanikaya
            [npcKeys.questStarts] = {13024},
            [npcKeys.questEnds] = {13024},
        },
        [30367] = { -- Elder Lunaro
            [npcKeys.questStarts] = {13025},
            [npcKeys.questEnds] = {13025},
        },
        [30368] = { -- Elder Bluewolf
            [npcKeys.questStarts] = {13026},
            [npcKeys.questEnds] = {13026},
        },
        [30369] = { -- Elder Tauros
            [npcKeys.questStarts] = {13027},
            [npcKeys.questEnds] = {13027},
        },
        [30370] = { -- Elder Graymane
            [npcKeys.questStarts] = {13028},
            [npcKeys.questEnds] = {13028},
        },
        [30371] = { -- Elder Pamuya
            [npcKeys.questStarts] = {13029},
            [npcKeys.questEnds] = {13029},
        },
        [30372] = { -- Elder Whurain
            [npcKeys.questStarts] = {13030},
            [npcKeys.questEnds] = {13030},
        },
        [30373] = { -- Elder Skywarden
            [npcKeys.questStarts] = {13031},
            [npcKeys.questEnds] = {13031},
        },
        [30374] = { -- Elder Muraco
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{64.59,51.34}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
            [npcKeys.questStarts] = {13032},
            [npcKeys.questEnds] = {13032},
        },
        [30375] = { -- Elder Stonebeard
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{31.26,37.61}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
            [npcKeys.questStarts] = {13020},
            [npcKeys.questEnds] = {13020},
        },
        [30382] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{39.56,56.35},},},
        },
        [30390] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{71.37,48.79}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30399] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{35.93,31.51}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30405] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{30.12,73.87}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30414] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{32.7,50},{29.2,47},{29.2,54},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{{27.3,44.2},{31.1,49.4}},{{27.7,56.6},{31.1,51.2}}}},
        },
        [30448] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{61.75,39.81},{61.96,40.01},{61.98,41.01},{62.63,40.42},{61.74,38.88},{61.08,39.37},{61.42,38.72},{61.74,38.29},{61.61,38.05},{62.24,40.37}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [30469] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{48.52,54.36}}},
        },
        [30531] = { -- Elder Jarten
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_KEEP]={{47.8,71.4},{-1,-1}}},
            [npcKeys.questStarts] = {13017},
            [npcKeys.questEnds] = {13017},
        },
        [30533] = { -- Elder Nurgen
            [npcKeys.spawns] = {[zoneIDs.THE_BROOD_PIT]={{21.1,43.4}},[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
            [npcKeys.questStarts] = {13022},
            [npcKeys.questEnds] = {13022},
        },
        [30534] = { -- Elder Kilias
            [npcKeys.spawns] = {[zoneIDs.DRAKTHARON_KEEP]={{67.5,80.6},{-1,-1}}},
            [npcKeys.questStarts] = {13023},
            [npcKeys.questEnds] = {13023},
        },
        [30535] = { -- Elder Yurauk
            [npcKeys.spawns] = {[zoneIDs.HALLS_OF_STONE]={{28.1,61.1},{-1,-1}}},
            [npcKeys.questStarts] = {13066},
            [npcKeys.questEnds] = {13066},
        },
        [30536] = { -- Elder Igasho
            [npcKeys.spawns] = {[zoneIDs.THE_NEXUS]={{54.9,65.2},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_NEXUS,
            [npcKeys.questStarts] = {13021},
            [npcKeys.questEnds] = {13021},
        },
        [30537] = { -- Elder Ohanzee
            [npcKeys.spawns] = {[zoneIDs.GUNDRAK]={{45.6,61.5},{-1,-1}}},
            [npcKeys.questStarts] = {13065},
            [npcKeys.questEnds] = {13065},
        },
        [30538] = { -- Elder Chogan'gada
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_PINNACLE_LOWER_LEVEL]={{47.4,22.9}},[zoneIDs.UTGARDE_PINNACLE]={{-1,-1}}},
            [npcKeys.questStarts] = {13067},
            [npcKeys.questEnds] = {13067},
        },
        [30575] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{84.2,75.6},{84.4,75},{84.6,76.8},{85,76.2},{85,77.6},{85.2,73.4},{85.2,74.6},{85.4,74},{85.6,73.8},{85.6,78.4},{86.4,76.6},},},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30593] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{83.4,72.8},{83.8,73.4},{84,74.4},{84.2,75.4},{84.2,75.8},{84.6,73},{84.8,78.6},{84.8,79.6},{85,74.2},{85,76.2},{85.4,74.8},{85.4,76.8},{85.4,78},{85.6,74.2},{85.6,75},{85.6,76.6},{85.8,79.8},{86,78.8},{86.2,75.6},{86.8,75},},},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30696] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{29.4,61.4},{29.6,61.6},{30.4,60.8},{30.8,61.8},{31.2,60.2},{31.2,61.2},{31.2,63.2},{31.2,65},{31.2,66.8},{31.4,58.4},{31.4,58.6},{31.4,63.6},{31.4,66.4},{31.4,67.6},{31.4,69.4},{31.4,70},{31.6,58.4},{31.6,58.8},{31.6,60.4},{31.6,60.6},{31.6,66.4},{31.6,67.2},{31.6,68},{31.8,68.8},{32,64.4},{32,64.6},{32,70},{32,70.6},{32.6,69.2},{32.8,70.2},{33.2,70.6},{33.4,65.8},{33.4,67.6},{33.8,69.6},{34,68.4},{34.2,69},{34.8,69.2},{34.8,70.4},{35,70.6},{35.2,71.8},{35.4,66.2},{35.4,66.6},{35.6,72},{35.8,70.2},{36.2,66},{36.2,67.6},{36.2,71},{36.4,65.4},{36.4,66.8},{36.6,65.4},{36.6,65.8},{36.6,67},{36.8,67.8},{37,71.2},{37.2,71.6},{37.4,70.4},{37.6,70.4},{37.6,70.8}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30698] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{29.8,61.6}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30750] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{26.16,62.28}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30824] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{64.78,28.41}}},
            [npcKeys.waypoints] = waypointPresets.ORGRIMS_HAMMER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30825] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{64.78,28.41}}},
            [npcKeys.waypoints] = waypointPresets.ORGRIMS_HAMMER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30871] = {
            [npcKeys.spawns] = {[zoneIDs.UTGARDE_PINNACLE] = {{43.9,18},{-1,-1}}},
        },
        [30944] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{54.15,71.18}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30989] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{80.38,71.06}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30992] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{35.82,67.16}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [30996] = {
            [npcKeys.spawns] = {[zoneIDs.THE_CULLING_OF_STRATHOLME]={{-1,-1}}},
        },
        [30997] = {
            [npcKeys.spawns] = {[zoneIDs.THE_CULLING_OF_STRATHOLME_CITY]={{31.9,44.6}},[zoneIDs.THE_CULLING_OF_STRATHOLME]={{-1,-1}}},
        },
        [31024] = {
            [npcKeys.spawns] = {[zoneIDs.THE_CULLING_OF_STRATHOLME]={{83.8,59.9},{-1,-1}}},
        },
        [31036] = { -- Commander Zanneth
            [npcKeys.questStarts] = {13179},
            [npcKeys.questEnds] = {13177,13179},
        },
        [31051] = { -- Sorceress Kaylana
            [npcKeys.questStarts] = {13198},
        },
        [31052] = { -- Bowyer Randolph
            [npcKeys.questStarts] = {13196},
        },
        [31053] = { -- Primalist Mulfort
            [npcKeys.questStarts] = {13201},
        },
        [31054] = { -- Anchorite Tessa
            [npcKeys.spawns] = {[zoneIDs.WINTERGRASP]={{72.66,31.67},{43.73,17.01}}},
            [npcKeys.questStarts] = {13195},
        },
        [31091] = { -- Commander Dardosh
            [npcKeys.questStarts] = {13180},
            [npcKeys.questEnds] = {13178,13180},
        },
        [31101] = {
            [npcKeys.spawns] = {[zoneIDs.WINTERGRASP]={{21.86,35.43},{51.74,21.17}}},
        },
        [31102] = { -- Vieron Blazefeather
            [npcKeys.questStarts] = {13199},
        },
        [31104] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{81.37,61.1},{82.39,60.19},{-1,-1}}},
        },
        [31105] = {
            [npcKeys.spawns] = {[zoneIDs.AHNKAHET_THE_OLD_KINGDOM]={{12.29,50.82},{-1,-1}}},
        },
        [31106] = { -- Siegesmith Stronghoof
            [npcKeys.questStarts] = {13200},
            [npcKeys.questEnds] = {13191,13200},
        },
        [31108] = { -- Siege Master Stouthandle
            [npcKeys.questEnds] = {236,13197},
        },
        [31134] = {
            [npcKeys.spawns] = {[zoneIDs.VIOLET_HOLD] = {{45.9,56.5},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.VIOLET_HOLD,
        },
        [31191] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{30.9,29.3}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31205] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN] = {{65.6,67},{66,62.6},{66,65.4},{66.4,59.6},{66.4,60.6},{66.4,62},{66.4,64},{66.4,66.2},{66.6,59.6},{66.6,65.6},{66.8,65},{67,69},{67.2,61.4},{67.2,63},{67.2,66.6},{67.4,59.4},{67.4,62.2},{67.4,64},{67.4,68.2},{67.4,70},{67.6,69.4},{67.6,70},{67.8,60.4},{67.8,63.4},{67.8,65.8},{68,62.4},{68,63.8},{68,67.4},{68.2,59.2},{68.2,61.4},{68.2,68},{68.4,65.4},{68.6,59.8},{68.8,58.4},{68.8,59.2},{68.8,62.2},{68.8,64.4},{69,65.4},{69,66},{69,66.6},{69,67.8},{69.2,63.2},{69.4,61.2},{69.6,59.8},{69.6,61.8},{69.6,66},{69.8,59.4},{69.8,61.4},{70,63},{70,64.4},{70,65},{70.4,67.4},{70.6,60.4},{70.6,60.6},{70.6,65},{70.6,68.6},{70.8,63.4},{70.8,67.2},{70.8,68.4},{71,62.2},{71.6,68},}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31222] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{30.9,29.3}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31235] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{35.6,66.73}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31237] = { -- Matthias Lehner
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{53.8,86.9}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
            [npcKeys.questStarts] = {13275,13282,13390,13391,13392},
        },
        [31242] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{30.9,29.3}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31259] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{63.59,52.34}}},
            [npcKeys.waypoints] = waypointPresets.THE_SKYBREAKER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31261] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{64.78,28.41}}},
            [npcKeys.waypoints] = waypointPresets.ORGRIMS_HAMMER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31271] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{30.9,29.3}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31277] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{30.9,29.3}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31283] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{54.44,86.13}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31306] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{29.8,61.2}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31395] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{48.2,72.97}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31413] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{54.1,85.27},{54.29,85.69},{54.69,85.26},{54.91,86.05},{55.36,86.08},{55.32,86.71},{55.87,87.14},{55.5,88.09},{55.78,88.63},{55.2,89.23},{55.34,90.01},{54.73,89.98},{54.12,90.57},{53.93,90.02},{53.35,90.52},{53.14,89.62},{52.49,89.86},{52.64,88.83},{52.25,88.25},{52.47,87.65},{52.41,86.66},{52.9,86.2},{53.07,85.11},{53.7,85.51}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31439] = { -- Archmage Timear
            [npcKeys.questStarts] = {13240,13241,13243,13244},
            [npcKeys.questEnds] = {13240,13241,13243,13244},
        },
        [31440] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{54.94,84.18}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31648] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{54,43}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31701] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{62.47,51.24},{62.46,51.19},{62.42,51.07},{62.44,51.03},{62.49,51.1},{62.83,51.51},{62.86,51.53},{62.83,51.72},{62.83,51.56},{62.82,51.03}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31721] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{65.24,48.06},{63.41,47.54},{63.83,52.82},{63.61,50.59},{66.45,50.46},{68.89,46.2},{65.28,53.84}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31773] = {
            [npcKeys.name] = "Plague Cauldron",
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{62.26,63.37},{60.84,63.39},{61.55,63.96}}},
        },
        [31839] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{54,36.6}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31882] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{52.28,55.92},{57.54,51.39},{59.53,58.15},{57.31,63.63}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [31884] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{59.61,45.83}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32154] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{65.02,53.96},{65.8,53.75},{66.59,53.87},{67.06,54.76},{67.61,55.6},{67.25,56.24},{66.39,56.37},{65.73,56.77},{65.24,56.57},{67.2,53.2},{67.4,54.2},{65.4,55.2}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32179] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{61.02,39.65},{60.96,43.39},{57.94,44.49},{56.8,42.09},{57.51,38.21},{56.73,39.28},{57.14,36.67},{57.52,41.85}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32182] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{61.04,40.03},{55.19,38.73},{55.03,38.69},{61.38,43.29},{61.02,43.03},{57.58,38.69},{56.9,44.09},{56.97,44.12},{58.1,41.36},{58.16,41.4},{59.33,39.41},{57.2,36.44},{56.0,35.54},{56.13,35.67},{55.96,40.56},{57.36,36.13},{60.45,38.9},{57.84,44.6},{57.87,44.09},{56.76,42.48},{59.48,39.48},{57.58,38.52},{56.68,38.97},{56.74,39.2},{57.87,41.66},{57.64,41.81},{57.21,42.71}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32183] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{60.81,43.45},{57.5,36.68},{56.88,42.81},{61.04,42.58},{57.22,36.38},{60.61,39.48},{60.46,38.85},{57.63,44.03},{57.91,43.94},{57.52,38.34},{57.46,38.38},{56.84,39.36},{56.76,39.11},{57.47,41.88},{57.71,41.75},{56.7,42.06}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32188] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{60.98,39.02},{61.61,42.27},{60.57,43.51},{60.06,44.64},{60.19,45.02},{61.08,38.54},{64.6,39.69}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32195] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{54,44}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32196] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{54,40}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32197] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{54,34}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32199] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{51,33}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32222] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{57.47,62.96},{52.76,57.45},{56.8,50.65},{59.21,58.41}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32227] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{62.57,50.7}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32239] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{44.4,76.2}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32297] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{52.51,29.43},{52.61,29.4},{52.55,29.28},{52.9,29.01},{53.03,29.47},{53.25,29.28},{53.31,29.53},{53.32,29.75},{53.31,30.01},{53.31,30.11},{53.28,30.34},{53.32,30.66},{53.31,30.97},{52.61,31},{52.65,30.82},{52.51,30.85},{52.87,30.49},{52.88,30.2},{52.88,29.94},{52.77,30.04},{52.76,30.42},{50.9,30.41},{50.53,30.79},{50.88,30.23},{51.01,30.28},{50.55,29.4},{50.95,28.96},{52.76,31.15}}},
        },
        [32300] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{51.93,28.89}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32301] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{64.78,28.41}}},
            [npcKeys.waypoints] = waypointPresets.ORGRIMS_HAMMER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32302] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{63.59,52.34}}},
            [npcKeys.waypoints] = waypointPresets.THE_SKYBREAKER,
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32327] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT]={{71.71,39.21}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [32370] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{68.05,51.83}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32408] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{68.02,51.59}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32423] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{71.6,37.5}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32430] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{54,36.9}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32444] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{53.95,42.93}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32497] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{49.2,73.2}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32587] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{49.82,73.53}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32588] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{49.27,74.1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32593] = {
            [npcKeys.spawns] = {[zoneIDs.AZJOL_NERUB]={{-1,-1}}},
        },
        [32648] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{42.9,78.71}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [32663] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{16.37,48.26}}},
        },
        [32801] = {
            [npcKeys.questStarts] = {13485},
            [npcKeys.questEnds] = {13485},
        },
        [32802] = {
            [npcKeys.questStarts] = {13486},
            [npcKeys.questEnds] = {13486},
        },
        [32803] = {
            [npcKeys.questStarts] = {13487},
            [npcKeys.questEnds] = {13487},
        },
        [32804] = {
            [npcKeys.questStarts] = {13488},
            [npcKeys.questEnds] = {13488},
        },
        [32805] = {
            [npcKeys.questStarts] = {13489},
            [npcKeys.questEnds] = {13489},
        },
        [32806] = {
            [npcKeys.questStarts] = {13490},
            [npcKeys.questEnds] = {13490},
        },
        [32807] = {
            [npcKeys.questStarts] = {13491},
            [npcKeys.questEnds] = {13491},
        },
        [32808] = {
            [npcKeys.questStarts] = {13492},
            [npcKeys.questEnds] = {13492},
        },
        [32809] = {
            [npcKeys.questStarts] = {13493},
            [npcKeys.questEnds] = {13493},
        },
        [32810] = { -- Sholazar Basin Flame Keeper
            [npcKeys.questStarts] = {13494},
            [npcKeys.questEnds] = {13494},
        },
        [32811] = { -- Dragonblight Flame Keeper
            [npcKeys.questStarts] = {13495},
            [npcKeys.questEnds] = {13495},
        },
        [32812] = {
            [npcKeys.questStarts] = {13496},
            [npcKeys.questEnds] = {13496},
        },
        [32813] = {
            [npcKeys.questStarts] = {13497},
            [npcKeys.questEnds] = {13497},
        },
        [32814] = {
            [npcKeys.questStarts] = {13498},
            [npcKeys.questEnds] = {13498},
        },
        [32815] = {
            [npcKeys.questStarts] = {13499},
            [npcKeys.questEnds] = {13499},
        },
        [32816] = {
            [npcKeys.questStarts] = {13500},
            [npcKeys.questEnds] = {13500},
        },
        [32867] = {
            [npcKeys.spawns] = {[zoneIDs.ULDUAR]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ULDUAR,
        },
        [32871] = {
            [npcKeys.spawns] = {[zoneIDs.ULDUAR]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ULDUAR,
        },
        [32927] = {
            [npcKeys.spawns] = {[zoneIDs.ULDUAR]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ULDUAR,
        },
        [33113] = {
            [npcKeys.spawns] = {[zoneIDs.ULDUAR]={{49.3,39},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ULDUAR,
        },
        [33118] = {
            [npcKeys.spawns] = {[zoneIDs.ULDUAR]={{36.64,26.56},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ULDUAR,
        },
        [33186] = {
            [npcKeys.spawns] = {[zoneIDs.ULDUAR]={{54.4,26.8},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ULDUAR,
        },
        [33220] = {
            [npcKeys.spawns] = {[zoneIDs.GRIZZLY_HILLS]={{61.76,48.88}}},
            [npcKeys.zoneID] = zoneIDs.GRIZZLY_HILLS,
        },
        [33273] = {
            [npcKeys.spawns] = {[zoneIDs.DRAGONBLIGHT]={{93.20,25.99}}},
            [npcKeys.zoneID] = zoneIDs.DRAGONBLIGHT,
        },
        [33288] = {
            [npcKeys.spawns] = {[zoneIDs.THE_DESCENT_OF_MADNESS]={{68,40.2}},[zoneIDs.ULDUAR]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ULDUAR,
        },
        [33293] = {
            [npcKeys.spawns] = {[zoneIDs.ULDUAR]={{48.6,14.5},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ULDUAR,
        },
        [33308] = {
            [npcKeys.spawns] = {[zoneIDs.CRYSTALSONG_FOREST]={{10.4,35},{11.6,37},{11.6,39.8},{11.8,40.6},{12.4,29.2},{12.4,39.4},{12.8,25},{12.8,39.2},{14.2,27.8},{14.4,38.4},{15,37},{15.2,31.4},{15.2,31.8},{15.4,34},{15.4,34.8},{17.6,28.4},{18.2,35.6},{19.8,30.6},{20.4,38}}},
            [npcKeys.zoneID] = zoneIDs.CRYSTALSONG_FOREST,
        },
        [33434] = { -- Bezzle Blastbolt
            [npcKeys.questEnds] = {13820},
        },
        [33448] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{71.46,19.75}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [33519] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{77.8,21.6}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [33532] = {
            [npcKeys.spawns] = {[zoneIDs.DALARAN] = {{49.5,62.6}}}, -- Wolvar Orphan
            [npcKeys.zoneID] = zoneIDs.DALARAN,
        },
        [33533] = {
            [npcKeys.spawns] = {[zoneIDs.DALARAN] = {{49.5,62.6}}}, -- Oracle Orphan
            [npcKeys.zoneID] = zoneIDs.DALARAN,
        },
        [33537] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{52.8,9},{53.6,8.6},{53.8,8.4}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [33687] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{43.98,33.48}}},
            [npcKeys.waypoints] = {[zoneIDs.ICECROWN]={{{43.98,33.48},{43.98,33.48},{43.98,33.30},{44.00,33.15},{44.11,32.77},{44.19,32.53},{44.26,32.39},{44.36,32.25},{44.37,32.24},{44.63,32.14},{44.82,32.13},{45.07,32.11},{45.24,32.10},{45.29,32.12},{45.58,32.21},{45.61,32.22},{45.97,32.32},{46.30,32.41},{46.60,32.55},{46.90,32.86},{47.12,33.32},{47.19,33.57},{47.15,33.90},{47.02,34.44},{46.54,35.06},{46.46,35.08},{46.12,35.15},{45.82,35.13},{45.44,35.09},{45.10,34.97},{44.92,34.85},{44.79,34.69},{44.64,34.58},{44.56,34.52},{44.48,34.43},{44.24,33.99},{44.14,33.73},{44.08,33.57},{43.98,33.48}}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [33695] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{43.98,33.48}}},
            [npcKeys.waypoints] = {[zoneIDs.ICECROWN]={{{43.98,33.48},{43.98,33.48},{43.98,33.30},{44.00,33.15},{44.11,32.77},{44.19,32.53},{44.26,32.39},{44.36,32.25},{44.37,32.24},{44.63,32.14},{44.82,32.13},{45.07,32.11},{45.24,32.10},{45.29,32.12},{45.58,32.21},{45.61,32.22},{45.97,32.32},{46.30,32.41},{46.60,32.55},{46.90,32.86},{47.12,33.32},{47.19,33.57},{47.15,33.90},{47.02,34.44},{46.54,35.06},{46.46,35.08},{46.12,35.15},{45.82,35.13},{45.44,35.09},{45.10,34.97},{44.92,34.85},{44.79,34.69},{44.64,34.58},{44.56,34.52},{44.48,34.43},{44.24,33.99},{44.14,33.73},{44.08,33.57},{43.98,33.48}}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [33707] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{68.79,20.87}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [33817] = { -- Justicar Mariel Trueheart
            [npcKeys.questStarts] = {13667,13668,13794,13795,13820},
        },
        [33956] = {
            [npcKeys.spawns] = {[zoneIDs.THE_ARCHIVUM]={{15.6,89.5}},[zoneIDs.ULDUAR]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_ARCHIVUM,
        },
        [33957] = {
            [npcKeys.spawns] = {[zoneIDs.THE_ARCHIVUM]={{15.6,89.5}},[zoneIDs.ULDUAR]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_ARCHIVUM,
        },
        [34644] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{52.67,36.11}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [34653] = { -- alliance
            [npcKeys.spawns] = {
                [zoneIDs.STORM_PEAKS]={{40.3,85.43}},
                [zoneIDs.ZUL_DRAK]={{41.24,68.46}},
                [zoneIDs.GRIZZLY_HILLS]={{31.29,59.37}},
                [zoneIDs.HOWLING_FJORD]={{60.56,16.74}},
                [zoneIDs.DRAGONBLIGHT]={{77.67,50.73}},
                [zoneIDs.BOREAN_TUNDRA]={{57.07,67.44}},
                [zoneIDs.SHOLAZAR_BASIN]={{47.47,60.73}},
                [zoneIDs.SHATTRATH_CITY]={{43.66,49.85}},
                [zoneIDs.SHADOWMOON_VALLEY]={{37.68,55.74}},
                [zoneIDs.NAGRAND]={{54.16,75.42}},
                [zoneIDs.ZANGARMARSH]={{67.85,51.08}},
                [zoneIDs.BLADES_EDGE_MOUNTAINS]={{37.81,61.83}},
                [zoneIDs.NETHERSTORM]={{34.01,64.32}},
                [zoneIDs.HELLFIRE_PENINSULA]={{55.12,63.39}},
                [zoneIDs.THE_EXODAR]={{76.16,53.3}},
                [zoneIDs.AZUREMYST_ISLE]={{51.53,52.05}},
                [zoneIDs.BLOODMYST_ISLE]={{55.82,58.68}},
                [zoneIDs.DARKSHORE]={{36.95,43.78}},
                [zoneIDs.WINTERSPRING]={{62.18,36.89}},
                [zoneIDs.DARNASSUS]={{68.72,37.23}},
                [zoneIDs.TELDRASSIL]={{56.31,58.36}},
                [zoneIDs.TANARIS]={{51.11,29.37}},
                [zoneIDs.SILITHUS]={{51.88,37.41}},
                [zoneIDs.FERALAS]={{30.06,43.4}},
                [zoneIDs.ELWYNN_FOREST]={{34.18,51.08},{41.99,64.81}},
                [zoneIDs.DUN_MOROGH]={{52.63,36.49},{46.3,53.08}},
                [zoneIDs.WESTFALL]={{53.36,52.79}},
                [zoneIDs.STRANGLETHORN_VALE]={{37.88,3.59}},
                [zoneIDs.DUSKWOOD]={{77.76,44.18}},
                [zoneIDs.BLASTED_LANDS]={{66.36,23.45}},
                [zoneIDs.REDRIDGE_MOUNTAINS]={{32.39,53.81}},
                [zoneIDs.BURNING_STEPPES]={{85.63,69.55}},
                [zoneIDs.LOCH_MODAN]={{32.2,48.9}},
                [zoneIDs.WETLANDS]={{9.22,60.49}},
                [zoneIDs.ARATHI_HIGHLANDS]={{46.06,46.2}},
                [zoneIDs.HILLSBRAD_FOOTHILLS]={{49.82,61.05}},
                [zoneIDs.THE_HINTERLANDS]={{14.09,46.73}},
                [zoneIDs.EASTERN_PLAGUELANDS]={{74.77,53.95}},
                [zoneIDs.WESTERN_PLAGUELANDS]={{43.77,84.47}},
                [zoneIDs.THE_BARRENS]={{62.58,38.31}},
                [zoneIDs.DUSTWALLOW_MARSH]={{67.85,50.75}},
                [zoneIDs.DESOLACE]={{65.16,9.06}},
                [zoneIDs.ASHENVALE]={{35.28,50.2}},
            },
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
        },
        [34654] = { -- horde
            [npcKeys.spawns] = {
                [zoneIDs.STORM_PEAKS]={{40.37,85.34}},
                [zoneIDs.ZUL_DRAK]={{41.32,68.37}},
                [zoneIDs.GRIZZLY_HILLS]={{22.3,65.9}},
                [zoneIDs.HOWLING_FJORD]={{49.02,12.96}},
                [zoneIDs.DRAGONBLIGHT]={{37.18,46.99}},
                [zoneIDs.BOREAN_TUNDRA]={{40.82,52.4}},
                [zoneIDs.SHOLAZAR_BASIN]={{47.58,60.66}},
                [zoneIDs.SHATTRATH_CITY]={{43.45,49.14}},
                [zoneIDs.SHADOWMOON_VALLEY]={{29.93,28.96}},
                [zoneIDs.NAGRAND]={{56.56,34.06}},
                [zoneIDs.ZANGARMARSH]={{32.64,51.06}},
                [zoneIDs.BLADES_EDGE_MOUNTAINS]={{52.33,55.12}},
                [zoneIDs.NETHERSTORM]={{33.95,64.22}},
                [zoneIDs.HELLFIRE_PENINSULA]={{56.25,38.3}},
                [zoneIDs.WINTERSPRING]={{60.32,36.52}},
                [zoneIDs.TANARIS]={{51.89,25.68}},
                [zoneIDs.SILITHUS]={{51.7,37.57}},
                [zoneIDs.FERALAS]={{74.84,43.49}},
                [zoneIDs.THOUSAND_NEEDLES]={{45.57,51.35}},
                [zoneIDs.STRANGLETHORN_VALE]={{32.25,28.18}},
                [zoneIDs.SWAMP_OF_SORROWS]={{46.25,56.23}},
                [zoneIDs.BURNING_STEPPES]={{63.93,31.3}},
                [zoneIDs.BADLANDS]={{4.77,48.75}},
                [zoneIDs.ARATHI_HIGHLANDS]={{74.68,36.89}},
                [zoneIDs.HILLSBRAD_FOOTHILLS]={{60.8,20.8}},
                [zoneIDs.THE_HINTERLANDS]={{79.02,80.49}},
                [zoneIDs.EASTERN_PLAGUELANDS]={{74.16,51.83}},
                [zoneIDs.DUROTAR]={{46.25,14.33},{52.84,44.09}},
                [zoneIDs.GHOSTLANDS]={{45.02,31.21}},
                [zoneIDs.EVERSONG_WOODS]={{55.47,53.29},{46.6,47.38}},
                [zoneIDs.UNDERCITY]={{65.56,8.14}},
                [zoneIDs.TIRISFAL_GLADES]={{58.66,51.44}},
                [zoneIDs.SILVERPINE_FOREST]={{44.35,42.07}},
                [zoneIDs.THUNDER_BLUFF]={{29.93,65.11}},
                [zoneIDs.MULGORE]={{46.57,59.68}},
                [zoneIDs.THE_BARRENS]={{51.45,29.6},{62.53,38.3}},
                [zoneIDs.STONETALON_MOUNTAINS]={{46.19,60.18}},
                [zoneIDs.ASHENVALE]={{73.84,60.63}},
                [zoneIDs.DUSTWALLOW_MARSH]={{35.56,31.44}},
                [zoneIDs.DESOLACE]={{25.22,72.05}},
            },
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [34675] = {
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{34.1,51.44}}},
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
        },
        [34676] = {
            [npcKeys.spawns] = {[zoneIDs.DARNASSUS]={{65.89,39.33}}},
            [npcKeys.zoneID] = zoneIDs.DARNASSUS,
        },
        [34677] = {
            [npcKeys.spawns] = {[zoneIDs.UNDERCITY]={{63.92,11.48}}},
            [npcKeys.zoneID] = zoneIDs.UNDERCITY,
        },
        [34678] = {
            [npcKeys.spawns] = {[zoneIDs.THUNDER_BLUFF]={{30.83,63.7}}},
            [npcKeys.zoneID] = zoneIDs.THUNDER_BLUFF,
        },
        [34679] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{46.58,13.8}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [34708] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{52.9,36.08}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [34710] = {
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{33.71,50.63}}},
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
        },
        [34711] = {
            [npcKeys.spawns] = {[zoneIDs.DARNASSUS]={{66.51,35.1}}},
            [npcKeys.zoneID] = zoneIDs.DARNASSUS,
        },
        [34712] = {
            [npcKeys.spawns] = {[zoneIDs.UNDERCITY]={{63.23,8.94}}},
            [npcKeys.zoneID] = zoneIDs.UNDERCITY,
        },
        [34713] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{46.37,13.86}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [34714] = {
            [npcKeys.spawns] = {[zoneIDs.THUNDER_BLUFF]={{30.98,69.8}}},
            [npcKeys.zoneID] = zoneIDs.THUNDER_BLUFF,
        },
        [34744] = {
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{33.89,50.81}}},
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
        },
        [34768] = {
            [npcKeys.spawns] = {[zoneIDs.UNDERCITY]={{65.24,14.23}}},
            [npcKeys.zoneID] = zoneIDs.UNDERCITY,
        },
        [34780] = {
            [npcKeys.spawns] = {[zoneIDs.TRIAL_OF_THE_CRUSADER]={{51.1,52.7},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.TRIAL_OF_THE_CRUSADER,
        },
        [34920] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS]={{42.65,58.43},{42.25,60.1},{43.36,60.69},{43.4,57.84},{42.94,56.95},{43.22,55.94},{42.52,55.01},{43.09,54.6},{41.51,53.56},{41.19,52.62},{40.67,53.31},{40.06,52.53},{39.38,53.79},{38.55,53.96},{38.46,55.05},{37.61,56.07},{38.38,58.33},{37.73,59.86},{38.57,61.28},{38.87,60.57},{39.23,61.41},{40.61,60.33},{41.53,60.01},{42.24,60.09},{43.36,60.69},{44.68,59.4},{45.55,59.06},{45.47,60.13},{45.06,60.94},{45.15,61.93},{44.54,61.9},{46,61.18},{46.5,62.41},{46.08,63.36},{46.7,64.01},{47.35,62.49},{47.72,61.55},{46.88,59.91},{46.29,58.52},{45.85,57.6},{45.92,57.02},{45.77,55.82},{42.4,53.88},{43.38,59.28},{43.82,61.93},{46.69,60.7},{45.03,56.98},{45.15,55.61},{45.03,56.96},{43.9,56.55},{43.38,59.28},{44.27,61.01},{46.82,63.05},{44.34,58.48},{46.56,62.92},{38.21,62.04},{38.03,58.85},{37.67,57.9},{38.13,57.05},{39.95,61.25},{38.84,59.57},{40.56,62.92},{39.99,61.76},{39.96,60.23}}},
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [34925] = {
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING]={{42.55,54.63},{49.61,48.11},{51.31,50.77},{44.78,53.07}}},
        },
        [34965] = {
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING]={{43.8,24.6}}},
            [npcKeys.zoneID] = zoneIDs.HROTHGARS_LANDING,
        },
        [34980] = {
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING]={{50.4,15.6}}},
            [npcKeys.zoneID] = zoneIDs.HROTHGARS_LANDING,
        },
        [35012] = {
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING]={{58.59,31.72}}},
            [npcKeys.zoneID] = zoneIDs.HROTHGARS_LANDING,
        },
        [35060] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{66.87,8.97},{66.36,8.08},{67.31,8.2},{66.92,7.55},{74.14,10.52},{74.7,9.72},{74.15,9.14},{73.76,9.69}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35061] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{66.87,8.97},{66.36,8.08},{67.31,8.2},{66.92,7.55},{74.14,10.52},{74.7,9.72},{74.15,9.14},{73.76,9.69}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35071] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{66.87,8.97},{66.36,8.08},{67.31,8.2},{66.92,7.55},{74.14,10.52},{74.7,9.72},{74.15,9.14},{73.76,9.69}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35116] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{79.48,23.30}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35127] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{79.49,23.23}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35451] = {
            [npcKeys.spawns] = {[zoneIDs.TRIAL_OF_THE_CHAMPION]={{51,52.4},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.TRIAL_OF_THE_CHAMPION,
        },
        [36273] = { -- Bragor Bloodfist
            [npcKeys.questStarts] = {6521,14353,14355,14356},
            [npcKeys.questEnds] = {550,6144,6521,6522,14351,14352,14353,14355,14356},
        },
        [36494] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{67.67,54.94},{-1,-1}}},
        },
        [36497] = {
            [npcKeys.spawns] = {[zoneIDs.FORGE_OF_SOULS]={{43.4,50},{-1,-1}}},
        },
        [36502] = {
            [npcKeys.spawns] = {[zoneIDs.FORGE_OF_SOULS]={{43.3,12.2},{-1,-1}}},
        },
        [36597] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_THE_FROZEN_THRONE]={{49.8,52.7}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
        },
        [36612] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{39,59.8},{-1,-1}}},
        },
        [36626] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_UPPER_SPIRE]={{19.8,65.4}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
        },
        [36627] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_UPPER_SPIRE]={{19.8,41.8}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
        },
        [36658] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{44.2,26},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.PIT_OF_SARON,
        },
        [36764] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{59.37,60.48},{45.33,58.72},{43.77,66.77},{55.92,65.86},{55.84,39.13},{56.22,64.93},{58.71,60.9},{55.55,43.2},{53.46,65.12},{47.55,61.06},{41.77,65.25},{52.89,64.84},{49.63,69.36},{61.14,59.63},{60.06,49.25},{55.16,65.87},{55.64,63.33},{62.08,59.4},{54.38,36.42},{60.94,49.22},{55.5,38.28},{55.82,41.31},{60.23,60.09},{54.38,65.36},{50.54,68.04},{58.8,48.69},{48.83,69.23},{61.78,49.56},{38.6,66.65},{37.5,69},{34,70.5},{33.8,68.9},{34.3,65.9},{33.5,63.7},{34.8,61.5},{36.7,61.1},{40.3,55.9},{41,58.1},{42.2,59.5},{42.8,60.5},{45.3,55.8},{43.8,56.7},{42.3,54.5},{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [36765] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{59.37,60.48},{45.33,58.72},{43.77,66.77},{55.92,65.86},{55.84,39.13},{56.22,64.93},{58.71,60.9},{55.55,43.2},{53.46,65.12},{47.55,61.06},{41.77,65.25},{52.89,64.84},{49.63,69.36},{61.14,59.63},{60.06,49.25},{55.16,65.87},{55.64,63.33},{62.08,59.4},{54.38,36.42},{60.94,49.22},{55.5,38.28},{55.82,41.31},{60.23,60.09},{54.38,65.36},{50.54,68.04},{58.8,48.69},{48.83,69.23},{61.78,49.56},{38.6,66.65},{37.5,69},{34,70.5},{33.8,68.9},{34.3,65.9},{33.5,63.7},{34.8,61.5},{36.7,61.1},{40.3,55.9},{41,58.1},{42.2,59.5},{42.8,60.5},{45.3,55.8},{43.8,56.7},{42.3,54.5},{-1,-1}}},
        },
        [36766] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{59.37,60.48},{45.33,58.72},{43.77,66.77},{55.92,65.86},{55.84,39.13},{56.22,64.93},{58.71,60.9},{55.55,43.2},{53.46,65.12},{47.55,61.06},{41.77,65.25},{52.89,64.84},{49.63,69.36},{61.14,59.63},{60.06,49.25},{55.16,65.87},{55.64,63.33},{62.08,59.4},{54.38,36.42},{60.94,49.22},{55.5,38.28},{55.82,41.31},{60.23,60.09},{54.38,65.36},{50.54,68.04},{58.8,48.69},{48.83,69.23},{61.78,49.56},{38.6,66.65},{37.5,69},{34,70.5},{33.8,68.9},{34.3,65.9},{33.5,63.7},{34.8,61.5},{36.7,61.1},{40.3,55.9},{41,58.1},{42.2,59.5},{42.8,60.5},{45.3,55.8},{43.8,56.7},{42.3,54.5},{-1,-1}}},
        },
        [36767] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{59.37,60.48},{45.33,58.72},{43.77,66.77},{55.92,65.86},{55.84,39.13},{56.22,64.93},{58.71,60.9},{55.55,43.2},{53.46,65.12},{47.55,61.06},{41.77,65.25},{52.89,64.84},{49.63,69.36},{61.14,59.63},{60.06,49.25},{55.16,65.87},{55.64,63.33},{62.08,59.4},{54.38,36.42},{60.94,49.22},{55.5,38.28},{55.82,41.31},{60.23,60.09},{54.38,65.36},{50.54,68.04},{58.8,48.69},{48.83,69.23},{61.78,49.56},{38.6,66.65},{37.5,69},{34,70.5},{33.8,68.9},{34.3,65.9},{33.5,63.7},{34.8,61.5},{36.7,61.1},{40.3,55.9},{41,58.1},{42.2,59.5},{42.8,60.5},{45.3,55.8},{43.8,56.7},{42.3,54.5},{-1,-1}}},
        },
        [36770] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{59.37,60.48},{45.33,58.72},{43.77,66.77},{55.92,65.86},{55.84,39.13},{56.22,64.93},{58.71,60.9},{55.55,43.2},{53.46,65.12},{47.55,61.06},{41.77,65.25},{52.89,64.84},{49.63,69.36},{61.14,59.63},{60.06,49.25},{55.16,65.87},{55.64,63.33},{62.08,59.4},{54.38,36.42},{60.94,49.22},{55.5,38.28},{55.82,41.31},{60.23,60.09},{54.38,65.36},{50.54,68.04},{58.8,48.69},{48.83,69.23},{61.78,49.56},{38.6,66.65},{37.5,69},{34,70.5},{33.8,68.9},{34.3,65.9},{33.5,63.7},{34.8,61.5},{36.7,61.1},{40.3,55.9},{41,58.1},{42.2,59.5},{42.8,60.5},{45.3,55.8},{43.8,56.7},{42.3,54.5},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.PIT_OF_SARON,
        },
        [36771] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{59.37,60.48},{45.33,58.72},{43.77,66.77},{55.92,65.86},{55.84,39.13},{56.22,64.93},{58.71,60.9},{55.55,43.2},{53.46,65.12},{47.55,61.06},{41.77,65.25},{52.89,64.84},{49.63,69.36},{61.14,59.63},{60.06,49.25},{55.16,65.87},{55.64,63.33},{62.08,59.4},{54.38,36.42},{60.94,49.22},{55.5,38.28},{55.82,41.31},{60.23,60.09},{54.38,65.36},{50.54,68.04},{58.8,48.69},{48.83,69.23},{61.78,49.56},{38.6,66.65},{37.5,69},{34,70.5},{33.8,68.9},{34.3,65.9},{33.5,63.7},{34.8,61.5},{36.7,61.1},{40.3,55.9},{41,58.1},{42.2,59.5},{42.8,60.5},{45.3,55.8},{43.8,56.7},{42.3,54.5},{-1,-1}}},
            [npcKeys.waypoints] = {},
        },
        [36772] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{59.37,60.48},{45.33,58.72},{43.77,66.77},{55.92,65.86},{55.84,39.13},{56.22,64.93},{58.71,60.9},{55.55,43.2},{53.46,65.12},{47.55,61.06},{41.77,65.25},{52.89,64.84},{49.63,69.36},{61.14,59.63},{60.06,49.25},{55.16,65.87},{55.64,63.33},{62.08,59.4},{54.38,36.42},{60.94,49.22},{55.5,38.28},{55.82,41.31},{60.23,60.09},{54.38,65.36},{50.54,68.04},{58.8,48.69},{48.83,69.23},{61.78,49.56},{38.6,66.65},{37.5,69},{34,70.5},{33.8,68.9},{34.3,65.9},{33.5,63.7},{34.8,61.5},{36.7,61.1},{40.3,55.9},{41,58.1},{42.2,59.5},{42.8,60.5},{45.3,55.8},{43.8,56.7},{42.3,54.5},{-1,-1}}},
        },
        [36773] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{59.37,60.48},{45.33,58.72},{43.77,66.77},{55.92,65.86},{55.84,39.13},{56.22,64.93},{58.71,60.9},{55.55,43.2},{53.46,65.12},{47.55,61.06},{41.77,65.25},{52.89,64.84},{49.63,69.36},{61.14,59.63},{60.06,49.25},{55.16,65.87},{55.64,63.33},{62.08,59.4},{54.38,36.42},{60.94,49.22},{55.5,38.28},{55.82,41.31},{60.23,60.09},{54.38,65.36},{50.54,68.04},{58.8,48.69},{48.83,69.23},{61.78,49.56},{38.6,66.65},{37.5,69},{34,70.5},{33.8,68.9},{34.3,65.9},{33.5,63.7},{34.8,61.5},{36.7,61.1},{40.3,55.9},{41,58.1},{42.2,59.5},{42.8,60.5},{45.3,55.8},{43.8,56.7},{42.3,54.5},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.PIT_OF_SARON,
        },
        [36678] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_UPPER_SPIRE]={{13.2,53.5}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
        },
        [36774] = {
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBELLY]={{35.68,57.2}}},
            [npcKeys.zoneID] = zoneIDs.THE_UNDERBELLY,
        },
        [36776] = {
            [npcKeys.spawns] = {[zoneIDs.THE_UNDERBELLY]={{64.18,15.6}}},
            [npcKeys.zoneID] = zoneIDs.THE_UNDERBELLY,
        },
        [36853] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_SINDRAGOSA]={{36.6,23.3}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
        },
        [36855] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{39,86.6},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
        },
        [36954] = {
            [npcKeys.spawns] = {[zoneIDs.HALLS_OF_REFLECTION]={{73.6,73.2},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.HALLS_OF_REFLECTION]={{{73.6,73.2},{69.2,68.3},{64.3,62.9},{60.1,57.6},{55.9,51.4},{52.2,48.3},{49.1,44.8},{46.1,42.5},{43.7,40.4},{40.7,37.6},{37.7,35.1},{35.1,33.2},{31.5,31},{29.4,29.3},{27.1,27.6},{25.3,26},{22.7,23.1},{20.2,19.4},{18,18.6},{16,19.2},{13.4,21.7},{9.7,27}}}},
            [npcKeys.zoneID] = zoneIDs.HALLS_OF_REFLECTION,
        },
        [36955] = { -- Lady Jaina Proudmoore
            [npcKeys.spawns] = {[zoneIDs.HALLS_OF_REFLECTION]={{75.8,76.6},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.HALLS_OF_REFLECTION]={{{75.8,76.6},{73.1,73.2},{69.2,68.3},{64.3,62.9},{60.1,57.6},{55.9,51.4},{49.1,44.8},{42.1,38.4},{35.1,33.2},{29.4,29.3},{25.3,26},{22.7,23.1},{20.2,19.4},{18,18.6},{16,19.2},{13.4,21.7},{10.4,28}}}},
            [npcKeys.zoneID] = zoneIDs.HALLS_OF_REFLECTION,
            [npcKeys.questEnds] = {24500},
        },
        [36990] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{40.8,79.7},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.PIT_OF_SARON,
        },
        [36993] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{40.8,79.7},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.PIT_OF_SARON,
        },
        [37094] = {
            [npcKeys.spawns] = {[zoneIDs.FORGE_OF_SOULS]={{42.5,11},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.FORGE_OF_SOULS,
        },
        [37120] = { -- Highlord Darion Mograine
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{43.1,23},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questStarts] = {24545,24547,24548,24549,24743,24748,24749,24756,24757,24912,24915},
            [npcKeys.questEnds] = {24547,24548,24549,24743,24748,24749,24756,24757,24912,24914,24915},
        },
        [37158] = {
            [npcKeys.spawns] = {[zoneIDs.HALLS_OF_REFLECTION]={{40.4,70.9},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.HALLS_OF_REFLECTION,
        },
        [37172] = { -- Detective Snap Snagglebolt
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR]={{50.7,65.8}}},
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
            [npcKeys.questStarts] = {24536,24541,24638,24645,24647,24648,24649,24650,24651,24652,24793,24850},
            [npcKeys.questEnds] = {14483,24536,24541,24576,24638,24645,24647,24648,24649,24650,24651,24652,24805},
        },
        [37205] = {
            [npcKeys.spawns] = {[zoneIDs.ISLE_OF_QUEL_DANAS]={{52.93,80.24}}},
            [npcKeys.zoneID] = zoneIDs.ISLE_OF_QUEL_DANAS,
        },
        [37221] = {
            [npcKeys.spawns] = {[zoneIDs.HALLS_OF_REFLECTION]={{45,76.2},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.HALLS_OF_REFLECTION,
        },
        [37223] = {
            [npcKeys.spawns] = {[zoneIDs.HALLS_OF_REFLECTION]={{45.3,76.7},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.HALLS_OF_REFLECTION,
        },
        [37523] = {
            [npcKeys.spawns] = {[zoneIDs.ISLE_OF_QUEL_DANAS]={{44.4,45.62},{44.11,45.6},{44.14,45.14},{44.4,45.15},{44.4,44.66},{44.15,44.64},{44.49,44.04},{44.77,44.07},{44.76,44.94},{43.78,44.9},{43.81,44.05},{44.05,44.03}}},
            [npcKeys.zoneID] = zoneIDs.ISLE_OF_QUEL_DANAS,
        },
        [37527] = {
            [npcKeys.spawns] = {[zoneIDs.ISLE_OF_QUEL_DANAS]={{44.52,45.5}}},
            [npcKeys.zoneID] = zoneIDs.ISLE_OF_QUEL_DANAS,
        },
        [37552] = {
            [npcKeys.spawns] = {[zoneIDs.ISLE_OF_QUEL_DANAS]={{53,80}}},
            [npcKeys.zoneID] = zoneIDs.ISLE_OF_QUEL_DANAS,
        },
        [37554] = { -- Lady Sylvanas Windrunner
            [npcKeys.spawns] = {[zoneIDs.HALLS_OF_REFLECTION]={{75.8,76.6},{-1,-1}}},
            [npcKeys.waypoints] = {[zoneIDs.HALLS_OF_REFLECTION]={{{75.8,76.6},{73.1,73.2},{69.2,68.3},{64.3,62.9},{60.1,57.6},{55.9,51.4},{49.1,44.8},{42.1,38.4},{35.1,33.2},{29.4,29.3},{25.3,26},{22.7,23.1},{20.2,19.4},{18,18.6},{16,19.2},{13.4,21.7},{10.4,28}}}},
            [npcKeys.zoneID] = zoneIDs.HALLS_OF_REFLECTION,
            [npcKeys.questEnds] = {24802},
        },
        [37591] = {
            [npcKeys.spawns] = {[zoneIDs.HALLS_OF_REFLECTION]={{65.7,54.8},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.HALLS_OF_REFLECTION,
        },
        [37592] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{65.7,54.8},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.PIT_OF_SARON,
        },
        [37596] = {
            [npcKeys.spawns] = {[zoneIDs.FORGE_OF_SOULS]={{64,91},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.FORGE_OF_SOULS,
        },
        [37597] = {
            [npcKeys.spawns] = {[zoneIDs.FORGE_OF_SOULS]={{64,91},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.FORGE_OF_SOULS,
        },
        [37671] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{47.73,11.83},{47.81,11.73},{47.66,11.75}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [37675] = {
            [npcKeys.spawns] = {[1657]={{41.95,51.96}},[1537]={{34.15,66.42}},[1519]={{62.41,75.38}},[3557]={{73.73,56.06}}, -- original data
                               [zoneIDs.THUNDER_BLUFF]={{43.6,52.9}},[zoneIDs.ORGRIMMAR]={{53.8,66.4}},[zoneIDs.UNDERCITY]={{65.9,38.7}},[zoneIDs.SILVERMOON_CITY]={{64.6,67.3}}}, -- corrections
        },
        [37776] = {
            [npcKeys.waypoints] = {[zoneIDs.DALARAN]={{{45.96,76.74},{45.19,76.29},{44.96,75.11},{45.14,73.88},{45.35,72.66},{45.60,71.45},{45.97,70.31},{46.35,69.18},{46.72,68.05},{47.10,66.92},{47.47,65.78},{47.67,64.55},{47.77,63.30},{47.75,62.04},{47.28,61.02},{46.49,60.94},{46.32,61.13}}}},
        },
        [37780] = {
            [npcKeys.waypoints] = {[zoneIDs.DALARAN]={{{51.35,18.63},{51.99,19.37},{52.06,20.62},{52.14,21.88},{52.24,23.13},{51.93,24.31},{51.56,25.44},{51.16,26.56},{50.77,27.68},{50.38,28.80},{49.98,29.92},{49.73,31.10},{49.96,32.32},{50.30,33.47},{50.86,34.41},{51.46,35.29},{52.07,36.18},{52.67,37.07},{53.31,37.90},{53.53,38.16}}}},
        },
        [37917] = {
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST]={{55.2,61.0},{55.3,62.0},{54.9,63.1},{54.6,62.3}},[zoneIDs.DARKSHORE]={{43.3,79.9},{43.2,79.9},{43.2,79.5},{42.7,79.5},{43.0,79.4}}}
        },
        [37955] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_QUEEN_LANA_THEL]={{51.1,43.9}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
        },
        [37970] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_UPPER_SPIRE]={{51.8,14.1}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
        },
        [37984] = {
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{28.3,38.5},{28.6,38.2},{27.9,37.8},{28.6,37.4},{28.3,36.7}}},
        },
        [38006] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{61.5,39.8},{61.9,39.7},{61.4,39.5},{61.5,39.3},{61.8,39.3}}},
        },
        [38016] = {
            [npcKeys.spawns] = {[zoneIDs.THE_HINTERLANDS] = {{21.3,52.9},{21.6,52.8},{21.0,52.8},{21.8,52.6},{20.9,52.4}}},
        },
        [38017] = { -- Kalecgos
            [npcKeys.questEnds] = {24872,24880},
        },
        [38023] = {
            [npcKeys.spawns] = {[zoneIDs.WINTERSPRING] = {{64.2,37.6},{64.4,37.6},{64.2,37.4},{64.5,37.3},{64.4,37.1}}},
        },
        [38030] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{41.2,22.5},{41.1,22.2},{41.6,22.0},{41.2,21.9},{41.4,21.8}}},
        },
        [38035] = {
            [npcKeys.spawns] = {},
        },
        [38042] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{53.7,66.9}},},
        },
        [38043] = {
            [npcKeys.spawns] = {[zoneIDs.SILVERMOON_CITY] = {{64.4,66.5}},},
        },
        [38044] = {
            [npcKeys.spawns] = {[zoneIDs.THUNDER_BLUFF] = {{44,52.8}},},
        },
        [38045] = {
            [npcKeys.spawns] = {[zoneIDs.UNDERCITY] = {{66.6,38.6}},},
        },
        [38065] = {
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{33.92,47.27},{34.07,47.27}},[zoneIDs.STORMWIND_CITY]={{78.96,89.18}}},
            [npcKeys.zoneID] = zoneIDs.ELWYNN_FOREST,
        },
        [38066] = { -- Inspector Snip Snagglebolt
            [npcKeys.questStarts] = {24655,24656,24658,24659,24660,24662,24663,24664,24665,24666,24792,24848},
            [npcKeys.questEnds] = {24655,24656,24657,24658,24659,24660,24662,24663,24664,24665,24666,24745,24804},
        },
        [38121] = {
            [npcKeys.name] = "Soul Feast",
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
        },
        [38160] = {
            [npcKeys.spawns] = {[zoneIDs.FORGE_OF_SOULS]={{44.6,13.6},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.FORGE_OF_SOULS,
        },
        [38161] = {
            [npcKeys.spawns] = {[zoneIDs.FORGE_OF_SOULS]={{44.6,13.6},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.FORGE_OF_SOULS,
        },
        [38188] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{39.6,16.1},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.PIT_OF_SARON,
        },
        [38189] = {
            [npcKeys.spawns] = {[zoneIDs.PIT_OF_SARON]={{39.6,16.1},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.PIT_OF_SARON,
        },
        [38293] = {
            [npcKeys.spawns] = {[1657]={{42.0,50.05}},[1537]={{35.37,69.01}}, -- original data
                               [zoneIDs.THE_EXODAR]={{76,57.5}}}, -- correction
        },
        [38294] = {
            [npcKeys.spawns] = {[zoneIDs.DALARAN] = {{52.5,66.5}},},
            [npcKeys.zoneID] = zoneIDs.DALARAN,
        },
        [38295] = {
            [npcKeys.spawns] = {[zoneIDs.THUNDER_BLUFF]={{44.2,55.8}},[zoneIDs.UNDERCITY]={{64.3,37.5}},[zoneIDs.SILVERMOON_CITY]={{64.4,70.3}}}
        },
        [38316] = { -- Ormus the Penitent
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{40.2,21.6},{-1,-1}}},
            [npcKeys.questStarts] = {24815,24819,24820,24821,24822,24823,24825,24826,24827,24828,24829,24830,24831,24832,24833,24834,24835,24836,24837,24838,24839,24840,24841,24842,24843,24844,24845,24846,24847,25239,25240,25242},
            [npcKeys.questEnds] = {24815,24819,24820,24821,24822,24823,24825,24826,24827,24828,24829,24830,24831,24832,24833,24834,24835,24836,24837,24838,24839,24840,24841,24842,24843,24844,24845,24846,24847,25239,25240,25242},
        },
        [38328] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR]={{58.96,53.12}}}
        },
        [38471] = {
            [npcKeys.questStarts] = {24869,24875},
            [npcKeys.questEnds] = {24869,24875},
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{40.8,71.1},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
        },
        [38472] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{39,75.8},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
        },
        [38485] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{39,75.8},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
        },
        [38490] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_RAMPART_OF_SKULLS]={{45.6,34.5}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
        },
        [38491] = { -- Kor'kron Lieutenant
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_RAMPART_OF_SKULLS]={{45.6,73.5}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questStarts] = {24870,24877},
            [npcKeys.questEnds] = {24870,24877},
        },
        [38492] = { -- Skybreaker Lieutenant
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_RAMPART_OF_SKULLS]={{45.6,73.5}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questStarts] = {24871,24876},
            [npcKeys.questEnds] = {24871,24876},
        },
        [38494] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_RAMPART_OF_SKULLS]={{45.6,34.5}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
        },
        [38501] = { -- Alchemist Adrianna
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_UPPER_SPIRE]={{53.1,67.7}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questStarts] = {24873,24878},
            [npcKeys.questEnds] = {24873,24878},
        },
        [38551] = { -- Alrin the Agile
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_UPPER_SPIRE]={{50.1,39.5}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questStarts] = {24874,24879},
        },
        [38558] = { -- Infiltrator Minchar
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_QUEEN_LANA_THEL]={{48.8,35.7}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questEnds] = {24874,24879},
        },
        [38589] = { -- Valithria Dreamwalker
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL_UPPER_SPIRE]={{76.6,72.8}},[zoneIDs.ICECROWN_CITADEL]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questStarts] = {24872,24880},
        },
        [38606] = { -- Lady Jaina Proudmoore
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{39,20.6},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questStarts] = {24916},
            [npcKeys.questEnds] = {24916},
        },
        [38607] = { -- Muradin Bronzebeard
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{39.2,20.6},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questStarts] = {24917},
            [npcKeys.questEnds] = {24917},
        },
        [38608] = { -- Uther the Lightbringer
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{39,18.2},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questStarts] = {24919},
            [npcKeys.questEnds] = {24919},
        },
        [38609] = { -- Lady Sylvanas Windrunner
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{38.1,19.9},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
            [npcKeys.questStarts] = {24918},
            [npcKeys.questEnds] = {24918},
        },
        [38858] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{36,20.7},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN_CITADEL,
        },
        [39271] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{25.87,47.15}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [39368] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{49.53,47.12}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [39386] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{50.09,47.74}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [39396] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{50.14,47.84}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [39420] = {
            [npcKeys.name] = "Gnomeregan Vent",
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{23.5,44.8},{23.2,43.4},{24.1,41.2},{23.9,38.8},{24.5,38},{25.6,34.9}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [39509] = { -- Aronen
            [npcKeys.spawns] = {[zoneIDs.ICECROWN_CITADEL]={{40.2,21.9},{-1,-1}}},
            [npcKeys.questStarts] = {25246,25247,25248,25249},
            [npcKeys.questEnds] = {25246,25247,25248,25249},
        },
        [39654] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{64.5,74.1}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [39675] = { -- Captain Tread Sparknozzle
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{50.18,48.36}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
            [npcKeys.questStarts] = {25199,25285,25287,25289,25295},
            [npcKeys.questEnds] = {25199,25229,25285,25286,25289,25295,25500},
        },
        [39678] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{49.32,48.27}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [39711] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{50.63,48.17},{50.83,48.02}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [39715] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{50.21,48.65}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [39716] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{50.12,48.2}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [39717] = {
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{50.42,47.63}}},
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
        },
        [39863] = {
            [npcKeys.spawns] = {[zoneIDs.THE_RUBY_SANCTUM]={{49.3,53.9},{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_RUBY_SANCTUM,
        },
        [40176] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{55.2,76.4},{55.3,73.6},{55.6,72.6},{55.1,71.5},{54.2,71.9},{56.4,72.8},{56.3,71.2},{58.3,71.8}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40184] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{57.5,72.5}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40187] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{57.6,72.5}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40204] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{57.1,75.1}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40253] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{57.8,73}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40256] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{52.5,43.6},{52.1,44.3},{51.7,44.1},{51.3,44.3},{50.4,43.3},{50.6,42.2},{50.1,42.7},{51.1,40.5},{51.6,40.8},{51.9,39.7},{53.2,40.6},{53.5,41.5},{54.3,41.5},{54.2,43.7},{53.6,43}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40257] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{52.5,43.6},{52.1,44.3},{51.7,44.1},{51.3,44.3},{50.4,43.3},{50.6,42.2},{50.1,42.7},{51.1,40.5},{51.6,40.8},{51.9,39.7},{53.2,40.6},{53.5,41.5},{54.3,41.5},{54.2,43.7},{53.6,43}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40260] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{57.8,73}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40264] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{57.8,73}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40301] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{64.3,74.4},{61.1,78.4},{60.4,80.1},{59.9,82.8}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40352] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{57,74.2}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40391] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{57.4,72.7}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40502] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{60.3,89.6}}},
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
        },
        [40429] = {
            [npcKeys.spawns] = {[zoneIDs.THE_RUBY_SANCTUM]={{74.42,54.5},{-1,-1}}},
        },
        [198875] = {
            [npcKeys.name] = "Thassarian",
            [npcKeys.minLevel] = 72,
            [npcKeys.maxLevel] = 72,
            [npcKeys.spawns] = {[zoneIDs.BOREAN_TUNDRA]={{86.64,31.38}}},
            [npcKeys.zoneID] = zoneIDs.BOREAN_TUNDRA,
            [npcKeys.questEnds] = {12019},
        },
        [211332] = {
            [npcKeys.name] = "Korralin Hoperender",
            [npcKeys.minLevel] = 80,
            [npcKeys.maxLevel] = 80,
            [npcKeys.spawns] = {[zoneIDs.DALARAN]={{38,55.8}}},
            [npcKeys.zoneID] = zoneIDs.DALARAN,
        },
        [211340] = {
            [npcKeys.name] = "Kolara Dreamsmasher",
            [npcKeys.minLevel] = 80,
            [npcKeys.maxLevel] = 80,
            [npcKeys.spawns] = {[zoneIDs.DALARAN]={{65.5,24.8}}},
            [npcKeys.zoneID] = zoneIDs.DALARAN,
        },

        -- Below are fake IDs to show specific quest starts/ends only at one specific location even though the
        -- corresponding real NPC has multiple spawns (e.g. "The Kessel Run" requires you to run to Azure Watch even
        -- though "Exarch Menelaous" also spawns at Bloodmyst Isle)

        [80000] = {
            [npcKeys.name] = "Lorehammer attuned",
            [npcKeys.zoneID] = zoneIDs.STORM_PEAKS,
        },
        [80001] = {
            [npcKeys.name] = "Maintain a Trot for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{47,43.9}}}
        },
        [80002] = {
            [npcKeys.name] = "Maintain a Canter for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{47,43.9}}}
        },
        [80003] = {
            [npcKeys.name] = "Maintain a Gallop for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUN_MOROGH,
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH]={{47,43.9}}}
        },
        [80004] = {
            [npcKeys.name] = "Maintain a Trot for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{46.34,17.13}}}
        },
        [80005] = {
            [npcKeys.name] = "Maintain a Canter for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{46.34,17.13}}}
        },
        [80006] = {
            [npcKeys.name] = "Maintain a Gallop for 8 seconds",
            [npcKeys.zoneID] = zoneIDs.DUROTAR,
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{46.34,17.13}}}
        },
    }
end

function QuestieWotlkNpcFixes:LoadAutomatics()
    local npcKeys = QuestieDB.npcKeys

  --! This file is automatically generated from wowhead data by looking at mobs with no spawns, but drops questiems or are objectives of quests.
  return {
    --! 3.0.1
    --* Halfdan the Ice-Hearted https://www.wowhead.com/wotlk/npc=23671
    [23671] = {
      [npcKeys.spawns] = {
        [495]={{44.9,34.9},},
      },
    },
    --* Scarlet Ivy https://www.wowhead.com/wotlk/npc=23763
    [23763] = {
      [npcKeys.spawns] = {
        [495]={{51.6,25.3},{52.5,26.4},{50.9,27.1},{52.4,27.8},{52.7,29.1},},
      },
    },
    --* Fallen Combatant https://www.wowhead.com/wotlk/npc=24008
    [24008] = {
      [npcKeys.spawns] = {
        [495]={{74.9,32.0},{75.5,34.1},},
      },
    },
    --* Plaguehound Tracker https://www.wowhead.com/wotlk/npc=24156
    [24156] = {
      [npcKeys.spawns] = {
        [495]={{77.6,22.0},{78.5,26.9},},
      },
    },
    --* Plagued Proto-Whelp https://www.wowhead.com/wotlk/npc=24160
    [24160] = {
      [npcKeys.spawns] = {
        [495]={{37.9,52.5},{40.0,50.3},{42.4,53.1},},
      },
    },
    --* Frostgore https://www.wowhead.com/wotlk/npc=24173
    [24173] = {
      [npcKeys.spawns] = {
        [495]={{52.4,3.9},{53.6,6.6},},
      },
    },
    --* Prowling Worg https://www.wowhead.com/wotlk/npc=24206
    [24206] = {
      [npcKeys.spawns] = {
        [495]={{51.4,20.2},{59.6,22.3},},
      },
    },
    --* Northern Barbfish https://www.wowhead.com/wotlk/npc=24285
    [24285] = {
      [npcKeys.spawns] = {
        [495]={{62.8,18.5},{64.6,20.2},},
      },
    },
    --* Image of Megalith https://www.wowhead.com/wotlk/npc=24381
    [24381] = {
      [npcKeys.spawns] = {
        [495]={{71.7,17.6},},
      },
    },
    --* Gjalerbron Gargoyle https://www.wowhead.com/wotlk/npc=24440
    [24440] = {
      [npcKeys.spawns] = {
        [495]={{31.4,22.8},{31.0,26.0},{31.6,26.8},{30.8,27.2},{31.4,27.8},},
      },
    },
    --* Frostfin https://www.wowhead.com/wotlk/npc=24500
    [24500] = {
      [npcKeys.spawns] = {
        [495]={{63.7,19.4},},
      },
    },
    --* Black Conrad's Ghost https://www.wowhead.com/wotlk/npc=24790
    [24790] = {
      [npcKeys.spawns] = {
        [495]={{32.5,60.1},},
      },
    },
    --* Mutinous Sea Dog https://www.wowhead.com/wotlk/npc=25026
    [25026] = {
      [npcKeys.spawns] = {
        [495]={{37.8,75.5},{39.1,73.3},{40.5,75.5},},
      },
    },
    --* Warsong Peon https://www.wowhead.com/wotlk/npc=25270
    [25270] = {
      [npcKeys.spawns] = {
        [3537]={{40.8,58.5},{44.0,58.6},},
      },
    },
    --* Arcane Prisoner https://www.wowhead.com/wotlk/npc=25318
    [25318] = {
      [npcKeys.spawns] = {
        [3537]={{42.5,36.8},},
      },
    },
    --* Alluvius https://www.wowhead.com/wotlk/npc=25742
    [25742] = {
      [npcKeys.spawns] = {
        [3537]={{70.2,36.2},{75.5,35.5},},
      },
    },
    --* Nedar, Lord of Rhinos https://www.wowhead.com/wotlk/npc=25801
    [25801] = {
      [npcKeys.spawns] = {
        [3537]={{48.5,40.1},{46.1,40.6},{47.4,41.1},{47.1,42.5},{45.6,44.9},},
      },
    },
    --* Twonky https://www.wowhead.com/wotlk/npc=25830
    [25830] = {
      [npcKeys.spawns] = {
        [3537]={{60.2,20.4},},
      },
    },
    --* ED-210 https://www.wowhead.com/wotlk/npc=25831
    [25831] = {
      [npcKeys.spawns] = {
        [3537]={{65.5,17.6},},
      },
    },
    --* Max Blasto https://www.wowhead.com/wotlk/npc=25832
    [25832] = {
      [npcKeys.spawns] = {
        [3537]={{63.6,22.4},},
      },
    },
    --* The Grinder https://www.wowhead.com/wotlk/npc=25833
    [25833] = {
      [npcKeys.spawns] = {
        [3537]={{65.0,28.8},},
      },
    },
    --* Nesingwary Trapper https://www.wowhead.com/wotlk/npc=25835
    [25835] = {
      [npcKeys.spawns] = {
        [3537]={{57.5,46.3},},
      },
    },
    --* Storm Tempest https://www.wowhead.com/wotlk/npc=26045
    [26045] = {
      [npcKeys.spawns] = {
        [3537]={{77.0,38.6},},
      },
    },
    --* Keristrasza https://www.wowhead.com/wotlk/npc=26206
    [26206] = {
      [npcKeys.spawns] = {
        [3537]={{21.6,22.5},{30.8,33.2},{33.4,34.0},},
      },
    },
    --* Saragosa https://www.wowhead.com/wotlk/npc=26232
    [26232] = {
      [npcKeys.spawns] = {
        [3537]={{21.9,22.5},},
      },
    },
    --* Keristrasza https://www.wowhead.com/wotlk/npc=26237
    [26237] = {
      [npcKeys.spawns] = {
        [3537]={{25.6,22.0},},
      },
    },
    --* Tu'u'gwar https://www.wowhead.com/wotlk/npc=26510
    [26510] = {
      [npcKeys.spawns] = {
        [65]={{46.6,78.0},},
      },
    },
    --* Iron Rune Avenger https://www.wowhead.com/wotlk/npc=26786
    [26786] = {
      [npcKeys.spawns] = {
        [394]={{69.9,5.1},{70.6,7.8},{69.3,9.5},{67.5,10.4},},
      },
    },
    --* Kor'kron War Rider https://www.wowhead.com/wotlk/npc=26813
    [26813] = {
      [npcKeys.spawns] = {
        [65]={{23.6,41.4},{25.8,42.2},{26.0,40.2},},
      },
    },
    --* Overseer Durval https://www.wowhead.com/wotlk/npc=26920
    [26920] = {
      [npcKeys.spawns] = {
        [394]={{67.6,29.3},},
      },
    },
    --* Overseer Korgan https://www.wowhead.com/wotlk/npc=26921
    [26921] = {
      [npcKeys.spawns] = {
        [394]={{72.0,34.2},},
      },
    },
    --* Overseer Lochli https://www.wowhead.com/wotlk/npc=26922
    [26922] = {
      [npcKeys.spawns] = {
        [394]={{74.9,37.5},},
      },
    },
    --* Overseer Brunon https://www.wowhead.com/wotlk/npc=26923
    [26923] = {
      [npcKeys.spawns] = {
        [394]={{78.6,43.8},},
      },
    },
    --* Grom'thar the Thunderbringer https://www.wowhead.com/wotlk/npc=27002
    [27002] = {
      [npcKeys.spawns] = {
        [65]={{57.1,75.6},},
      },
    },
    --* Xink's Shredder https://www.wowhead.com/wotlk/npc=27061
    [27061] = {
      [npcKeys.spawns] = {
        [65]={{52.6,19.3},},
      },
    },
    --* Onslaught Knight https://www.wowhead.com/wotlk/npc=27206
    [27206] = {
      [npcKeys.spawns] = {
        [65]={{74.5,65.5},{72.6,67.3},{72.5,69.7},{73.1,71.3},{71.5,71.5},{69.4,74.2},{72.6,74.4},{67.4,75.4},{72.8,76.4},{69.2,79.5},{71.3,81.5},},
      },
    },
    --* Foreman Kaleiki https://www.wowhead.com/wotlk/npc=27238
    [27238] = {
      [npcKeys.spawns] = {
        [65]={{68.4,74.1},},
      },
    },
    --* Wintergarde Gryphon https://www.wowhead.com/wotlk/npc=27258
    [27258] = {
      [npcKeys.spawns] = {
        [65]={{77.2,50.0},{78.2,48.8},{78.4,48.0},{80.8,48.8},{83.2,51.0},},
      },
    },
    --* Frigid Ghoul Attacker https://www.wowhead.com/wotlk/npc=27685
    [27685] = {
      [npcKeys.spawns] = {
        [65]={{42.8,51.4},{49.8,51.4},{52.1,49.6},},
      },
    },
    --* Frigid Geist Attacker https://www.wowhead.com/wotlk/npc=27686
    [27686] = {
      [npcKeys.spawns] = {
        [65]={{43.0,51.2},{49.5,51.2},{51.2,52.8},{52.6,46.3},},
      },
    },
    --* Injured 7th Legion Soldier https://www.wowhead.com/wotlk/npc=27788
    [27788] = {
      [npcKeys.spawns] = {
        [65]={{86.2,51.0},},
      },
    },
    --* Hourglass of Eternity https://www.wowhead.com/wotlk/npc=27840
    [27840] = {
      [npcKeys.spawns] = {
        [65]={{71.4,39.3},},
      },
    },
    --* Your Inner Turmoil https://www.wowhead.com/wotlk/npc=27959
    [27959] = {
      [npcKeys.spawns] = {
        [495]={{61.0,2.0},},
      },
    },
    --* Wyrmrest Vanquisher https://www.wowhead.com/wotlk/npc=27996
    [27996] = {
      [npcKeys.spawns] = {
        [65]={{59.6,54.5},},
      },
    },
    --* Warlord Tartek https://www.wowhead.com/wotlk/npc=28105
    [28105] = {
      [npcKeys.spawns] = {
        [3711]={{41.5,19.7},},
      },
    },
    --* Watery Lord https://www.wowhead.com/wotlk/npc=28118
    [28118] = {
      [npcKeys.spawns] = {
        [66]={{41.6,74.3},{39.5,76.2},{42.5,82.6},},
      },
    },
    --* Crusader Jonathan https://www.wowhead.com/wotlk/npc=28136
    [28136] = {
      [npcKeys.spawns] = {
        [66]={{50.6,69.8},{54.0,73.8},},
      },
    },
    --* Crusader Lamoof https://www.wowhead.com/wotlk/npc=28142
    [28142] = {
      [npcKeys.spawns] = {
        [66]={{51.4,75.0},{53.6,75.0},{58.0,72.2},},
      },
    },
    --* Crusader Josephine https://www.wowhead.com/wotlk/npc=28148
    [28148] = {
      [npcKeys.spawns] = {
        [66]={{49.4,74.8},{57.8,72.6},},
      },
    },
    --* Bushwhacker https://www.wowhead.com/wotlk/npc=28317
    [28317] = {
      [npcKeys.spawns] = {
        [3711]={{46.5,63.5},},
      },
    },
    --* Drakkari Captive https://www.wowhead.com/wotlk/npc=28414
    [28414] = {
      [npcKeys.spawns] = {
        [66]={{53.9,67.7},{55.5,70.4},},
      },
    },
    --* Captive Footman https://www.wowhead.com/wotlk/npc=28415
    [28415] = {
      [npcKeys.spawns] = {
        [66]={{55.8,71.0},},
      },
    },
    --* Scarlet Ghost https://www.wowhead.com/wotlk/npc=28846
    [28846] = {
      [npcKeys.spawns] = {
        [4298]={{60.9,26.8},{61.6,28.8},{60.0,29.7},{58.8,30.6},{60.2,31.5},{58.6,33.9},},
      },
    },
    --* Drakkari Chieftain https://www.wowhead.com/wotlk/npc=28873
    [28873] = {
      [npcKeys.spawns] = {
        [66]={{33.7,38.3},},
      },
    },
    --* High Inquisitor Valroth https://www.wowhead.com/wotlk/npc=29001
    [29001] = {
      [npcKeys.spawns] = {
        [4298]={{63.0,68.0},},
      },
    },
    --* Prophet of Akali https://www.wowhead.com/wotlk/npc=29028
    [29028] = {
      [npcKeys.spawns] = {
        [66]={{77.5,36.3},},
      },
    },
    --* Scarlet Courier https://www.wowhead.com/wotlk/npc=29076
    [29076] = {
      [npcKeys.spawns] = {
        [4298]={{63.4,72.5},{61.1,75.7},{64.3,76.7},{59.5,78.5},{62.2,79.3},},
      },
    },
    --* Drakuru Raptor Rider https://www.wowhead.com/wotlk/npc=29699
    [29699] = {
      [npcKeys.spawns] = {
        [66]={{22.9,82.7},{26.4,82.8},{29.9,82.8},},
      },
    },
    --* Prince Navarius https://www.wowhead.com/wotlk/npc=29821
    [29821] = {
      [npcKeys.spawns] = {
        [66]={{30.2,63.0},{32.6,64.0},},
      },
    },
    --* Algar the Chosen https://www.wowhead.com/wotlk/npc=29872
    [29872] = {
      [npcKeys.spawns] = {
        [66]={{27.8,47.3},{32.2,51.4},},
      },
    },
    --! 3.0.2
    --* Tormar Frostgut https://www.wowhead.com/wotlk/npc=29626
    [29626] = {
      [npcKeys.spawns] = {
        [67]={{50.4,78.4},},
      },
    },
    --* General Lightsbane https://www.wowhead.com/wotlk/npc=29851
    [29851] = {
      [npcKeys.spawns] = {
        [210]={{44.6,20.0},},
      },
    },
    --* Stormforged Eradicator https://www.wowhead.com/wotlk/npc=29861
    [29861] = {
      [npcKeys.spawns] = {
        [67]={{26.9,66.7},{24.8,69.4},},
      },
    },
    --* Stormforged Monitor https://www.wowhead.com/wotlk/npc=29862
    [29862] = {
      [npcKeys.spawns] = {
        [67]={{26.9,66.7},{24.8,69.2},},
      },
    },
    --* Reanimated Crusader https://www.wowhead.com/wotlk/npc=30202
    [30202] = {
      [npcKeys.spawns] = {
        [210]={{76.5,66.4},{76.5,68.6},{78.2,67.6},{78.5,69.5},{79.2,65.5},{82.8,71.5},},
      },
    },
    --* Stormforged Ambusher https://www.wowhead.com/wotlk/npc=30208
    [30208] = {
      [npcKeys.spawns] = {
        [67]={{70.3,59.1},},
      },
    },
    --* Freed Crusader https://www.wowhead.com/wotlk/npc=30274
    [30274] = {
      [npcKeys.spawns] = {
        [210]={{83.1,71.8},{83.6,74.0},},
      },
    },
    --* Overseer Narvir https://www.wowhead.com/wotlk/npc=30299
    [30299] = {
      [npcKeys.spawns] = {
        [67]={{36.0,60.8},},
      },
    },
    --* Dr. Terrible https://www.wowhead.com/wotlk/npc=30404
    [30404] = {
      [npcKeys.spawns] = {
        [210]={{33.4,33.2},},
      },
    },
    --* Veranus https://www.wowhead.com/wotlk/npc=30461
    [30461] = {
      [npcKeys.spawns] = {
        [67]={{38.7,65.5},},
      },
    },
    --* Forgotten Depths Underking https://www.wowhead.com/wotlk/npc=30541
    [30541] = {
      [npcKeys.spawns] = {
        [210]={{78.6,64.3},{77.5,64.7},{80.9,65.3},{79.2,67.5},{79.5,68.6},},
      },
    },
    --* Forgotten Depths High Priest https://www.wowhead.com/wotlk/npc=30543
    [30543] = {
      [npcKeys.spawns] = {
        [210]={{78.7,57.3},{79.5,60.7},{77.6,62.2},{77.6,65.4},},
      },
    },
    --* Salranax the Flesh Render https://www.wowhead.com/wotlk/npc=30829
    [30829] = {
      [npcKeys.spawns] = {
        [210]={{77.5,62.1},},
      },
    },
    --* Underking Talonox https://www.wowhead.com/wotlk/npc=30830
    [30830] = {
      [npcKeys.spawns] = {
        [210]={{76.4,53.8},},
      },
    },
    --* High Priest Yath'amon https://www.wowhead.com/wotlk/npc=30831
    [30831] = {
      [npcKeys.spawns] = {
        [210]={{79.8,61.0},},
      },
    },
    --* Possessed Iskalder https://www.wowhead.com/wotlk/npc=30924
    [30924] = {
      [npcKeys.spawns] = {
        [210]={{28.8,52.2},},
      },
    },
    --* Overthane Balargarde https://www.wowhead.com/wotlk/npc=31016
    [31016] = {
      [npcKeys.spawns] = {
        [210]={{17.2,56.0},},
      },
    },
    --* Hulking Horror https://www.wowhead.com/wotlk/npc=31413
    [31413] = {
      [npcKeys.spawns] = {
        [210]={{55.3,87.3},},
      },
    },
    --* Armored Decoy https://www.wowhead.com/wotlk/npc=31578
    [31578] = {
      [npcKeys.spawns] = {
        [210]={{70.6,63.0},{69.2,64.6},},
      },
    },
    --* Brann Bronzebeard https://www.wowhead.com/wotlk/npc=31810
    [31810] = {
      [npcKeys.spawns] = {
        [67]={{45.4,49.4},},
      },
    },
    --* Grimkor the Wicked https://www.wowhead.com/wotlk/npc=32162
    [32162] = {
      [npcKeys.spawns] = {
        [210]={{45.4,46.0},},
      },
    },
    --* Alumeth the Ascended https://www.wowhead.com/wotlk/npc=32300
    [32300] = {
      [npcKeys.spawns] = {
        [210]={{51.8,28.6},},
      },
    },
    --* Hourglass of Eternity https://www.wowhead.com/wotlk/npc=32327
    [32327] = {
      [npcKeys.spawns] = {
        [65]={{72.2,38.2},},
      },
    },
    --* Orabus the Helmsman https://www.wowhead.com/wotlk/npc=32576
    [32576] = {
      [npcKeys.spawns] = {
        [3537]={{26.3,54.5},},
      },
    },
  }
  end

-- This should allow manual fix for NPC availability
function QuestieWotlkNpcFixes:LoadFactionFixes()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs

    local npcFixesHorde = {
        [15898] = {
            [npcKeys.spawns] = {
                [zoneIDs.ORGRIMMAR]={{41.27,32.36}},
                [zoneIDs.THUNDER_BLUFF]={{70.56,27.83}},
                [zoneIDs.UNDERCITY]={{66.45,36.02}},
                [zoneIDs.MOONGLADE]={{36.58,58.1},{36.3,58.53}},
                [zoneIDs.SHATTRATH_CITY]={{52.63,33.25},{48.64,36.29}},
                [zoneIDs.SILVERMOON_CITY]={{73.41,82.17}},
                [zoneIDs.DALARAN]={{47.93,43.32}},
            },
        },
        [24108] = { -- Self-Turning and Oscillating Utility Target
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{45.26,17.79}}},
        },
        [26221] = {
            [npcKeys.spawns] = {[zoneIDs.UNDERCITY]={{66.9,13.53}},[zoneIDs.ORGRIMMAR]={{46.44,38.69}},[zoneIDs.THUNDER_BLUFF]={{22.16,23.98}},[zoneIDs.SHATTRATH_CITY]={{60.68,30.62}},[zoneIDs.SILVERMOON_CITY]={{68.67,42.94}}},
        },
        [29579] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{36.62,49.27}}},
        },
        [34806] = {
            [npcKeys.name] = "Spirit of Sharing",
            [npcKeys.spawns] = {
                [zoneIDs.STORM_PEAKS]={{40.38,85.5}},
                [zoneIDs.ZUL_DRAK]={{41.2,68.25}},
                [zoneIDs.GRIZZLY_HILLS]={{22.43,65.94}},
                [zoneIDs.HOWLING_FJORD]={{49.14,13.05}},
                [zoneIDs.DRAGONBLIGHT]={{37.25,47.11}},
                [zoneIDs.BOREAN_TUNDRA]={{40.95,52.44},{40.62,52.88}},
                [zoneIDs.SHOLAZAR_BASIN]={{47.59,60.92}},
                [zoneIDs.SHATTRATH_CITY]={{43.42,51.93},{43.17,50.29},{42.96,48.61},{42.7,46.84}},
                [zoneIDs.SHADOWMOON_VALLEY]={{29.97,28.77}},
                [zoneIDs.NAGRAND]={{56.65,33.94}},
                [zoneIDs.ZANGARMARSH]={{32.75,51.19}},
                [zoneIDs.BLADES_EDGE_MOUNTAINS]={{52.28,54.96}},
                [zoneIDs.NETHERSTORM]={{33.9,64.43}},
                [zoneIDs.HELLFIRE_PENINSULA]={{56.44,38.39},{56.02,37.74}},
                [zoneIDs.WINTERSPRING]={{60.26,36.41}},
                [zoneIDs.TANARIS]={{51.95,25.55}},
                [zoneIDs.SILITHUS]={{51.89,37.71}},
                [zoneIDs.FERALAS]={{74.88,43.33}},
                [zoneIDs.THOUSAND_NEEDLES]={{45.54,51.59}},
                [zoneIDs.STRANGLETHORN_VALE]={{32.35,28.3}},
                [zoneIDs.SWAMP_OF_SORROWS]={{46.2,56.66}},
                [zoneIDs.BURNING_STEPPES]={{63.96,31.66}},
                [zoneIDs.BADLANDS]={{5.02,48.98}},
                [zoneIDs.ARATHI_HIGHLANDS]={{74.86,36.88}},
                [zoneIDs.HILLSBRAD_FOOTHILLS]={{61.03,20.84}},
                [zoneIDs.THE_HINTERLANDS]={{79,80.76}},
                [zoneIDs.EASTERN_PLAGUELANDS]={{74.11,52.14}},
                [zoneIDs.DUROTAR]={{46.32,14.58},{46.37,15.08},{46.66,15.02},{46.64,14.58},{52.98,43.89},{52.99,43.54}},
                [zoneIDs.GHOSTLANDS]={{44.85,30.98}},
                [zoneIDs.EVERSONG_WOODS]={{55.65,53.15},{55.61,53.53},{55.3,53.18},{55.29,53.64},{46.52,46.64},{46.5,46.94},{46.46,47.27}},
                [zoneIDs.UNDERCITY]={{64.1,14.23},{67.82,14.3},{67.98,7.85},{64.37,7.86}},
                [zoneIDs.TIRISFAL_GLADES]={{58.81,51.17},{59.12,51.21},{59.38,51.26}},
                [zoneIDs.SILVERPINE_FOREST]={{44.33,42.33}},
                [zoneIDs.THUNDER_BLUFF]={{29.83,62.24},{31.24,66.99},{30.21,67.43},{28.76,62.4}},
                [zoneIDs.MULGORE]={{46.43,59.57},{46.23,59.77}},
                [zoneIDs.THE_BARRENS]={{51.52,29.52},{51.62,29.42},{62.48,38.22}},
                [zoneIDs.STONETALON_MOUNTAINS]={{46.25,59.98}},
                [zoneIDs.ASHENVALE]={{73.9,60.47}},
                [zoneIDs.DUSTWALLOW_MARSH]={{35.68,31.53}},
                [zoneIDs.DESOLACE]={{25.41,72.09}},
            },
        },
        [34907] = {
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING]={{43.43,53.57},{43.1,53.5},{42.94,53.83},{43.92,54.36},{44.07,54.44},{43.82,54.64},{42.62,53.3},{42.85,53.33},{44.23,54.41},{43.36,53.87}}},
        },
        [34947] = {
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING]={{43.43,53.57},{43.1,53.5},{42.94,53.83},{43.92,54.36},{44.07,54.44},{43.82,54.64},{42.62,53.3},{42.85,53.33},{44.23,54.41},{43.36,53.87}}},
        },
        [35060] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{74.14,10.52},{74.7,9.72},{74.15,9.14},{73.76,9.69}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35061] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{74.14,10.52},{74.7,9.72},{74.15,9.14},{73.76,9.69}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35071] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{74.14,10.52},{74.7,9.72},{74.15,9.14},{73.76,9.69}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [37214] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{40.3,15.8},{40.1,15.5},{40.5,15.5},{40.5,15.2},{40.3,15.0}}},
        },
        [37715] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR]={{50.63,13.13}}},
        },
        [37917] = {
            [npcKeys.spawns] = {[zoneIDs.SILVERPINE_FOREST]={{55.2,61.0},{55.3,62.0},{54.9,63.1},{54.6,62.3}}},
        },
        [38340] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR]={{49,68.96}}}
        },
        [38341] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR]={{54.26,63.77}}}
        },
        [38342] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR]={{47.21,54.09}}}
        },
    }

    local npcFixesAlliance = {
        [15898] = {
            [npcKeys.spawns] = {
                [zoneIDs.STORMWIND_CITY]={{37.32,64.04}},
                [zoneIDs.IRONFORGE]={{29.92,14.21}},
                [zoneIDs.DARNASSUS]={{34.57,12.8}},
                [zoneIDs.MOONGLADE]={{36.58,58.1},{36.3,58.53}},
                [zoneIDs.SHATTRATH_CITY]={{52.63,33.25},{48.64,36.29}},
                [zoneIDs.THE_EXODAR]={{74.02,58.23}},
                [zoneIDs.DALARAN]={{47.93,43.32}},
            },
        },
        [24108] = { -- Self-Turning and Oscillating Utility Target
            [npcKeys.spawns] = {[zoneIDs.DUN_MOROGH] = {{47.64,39.3}}},
        },
        [26221] = {
            [npcKeys.spawns] = {[zoneIDs.TELDRASSIL]={{56.1,92.16}},[zoneIDs.SHATTRATH_CITY]={{60.68,30.62}},[zoneIDs.IRONFORGE]={{65.14,27.71}},[zoneIDs.STORMWIND_CITY]={{49.32,72.3}},[zoneIDs.THE_EXODAR]={{43.27,26.26}}},
        },
        [29579] = {
            [npcKeys.spawns] = {[zoneIDs.STORM_PEAKS] = {{30.1,73.9}}},
        },
        [34806] = {
            [npcKeys.name] = "Spirit of Sharing",
            [npcKeys.spawns] = {
                [zoneIDs.STORM_PEAKS]={{40.38,85.5}},
                [zoneIDs.ZUL_DRAK]={{41.2,68.25}},
                [zoneIDs.GRIZZLY_HILLS]={{31.3,59.59}},
                [zoneIDs.HOWLING_FJORD]={{60.45,16.74}},
                [zoneIDs.DRAGONBLIGHT]={{77.78,50.85}},
                [zoneIDs.BOREAN_TUNDRA]={{56.93,67.48},{56.92,67.82}},
                [zoneIDs.SHOLAZAR_BASIN]={{47.59,60.92}},
                [zoneIDs.SHATTRATH_CITY]={{43.42,51.93},{43.17,50.29},{42.96,48.61},{42.7,46.84}},
                [zoneIDs.SHADOWMOON_VALLEY]={{37.78,55.62}},
                [zoneIDs.NAGRAND]={{54.03,75.49}},
                [zoneIDs.ZANGARMARSH]={{67.72,51.16}},
                [zoneIDs.BLADES_EDGE_MOUNTAINS]={{37.9,61.97}},
                [zoneIDs.NETHERSTORM]={{33.9,64.43}},
                [zoneIDs.HELLFIRE_PENINSULA]={{55.07,63.22},{56.45,63.92}},
                [zoneIDs.THE_EXODAR]={{75.74,52.29},{75.75,50.51},{76.95,51.26},{77.21,53.08}},
                [zoneIDs.AZUREMYST_ISLE]={{51.71,52.11},{51.69,51.14}},
                [zoneIDs.BLOODMYST_ISLE]={{56.03,58.75}},
                [zoneIDs.DARKSHORE]={{36.91,43.65}},
                [zoneIDs.WINTERSPRING]={{62.17,37.03}},
                [zoneIDs.DARNASSUS]={{69.56,38.23},{67.85,38.08},{67.81,36.09},{69.47,36.08}},
                [zoneIDs.TELDRASSIL]={{56.44,58.4},{56.36,56.92}},
                [zoneIDs.TANARIS]={{51.2,29.42}},
                [zoneIDs.SILITHUS]={{51.89,37.71}},
                [zoneIDs.FERALAS]={{29.96,43.41}},
                [zoneIDs.ELWYNN_FOREST]={{34.33,51.18},{34.58,50.81},{34.81,50.45},{41.52,64.04},{41.43,64.65},{41.67,64.83}},
                [zoneIDs.DUN_MOROGH]={{52.77,36.41},{52.76,36.74},{52.76,37.03},{46.69,55.41},{46.66,55.12},{46.64,54.75},{46.19,52.91}},
                [zoneIDs.WESTFALL]={{53.21,52.61}},
                [zoneIDs.STRANGLETHORN_VALE]={{37.87,3.78}},
                [zoneIDs.DUSKWOOD]={{77.64,43.85}},
                [zoneIDs.BLASTED_LANDS]={{66.54,23.66}},
                [zoneIDs.REDRIDGE_MOUNTAINS]={{32.23,53.35}},
                [zoneIDs.BURNING_STEPPES]={{85.83,69.78}},
                [zoneIDs.LOCH_MODAN]={{32.16,48.4}},
                [zoneIDs.WETLANDS]={{9.19,60.77},},
                [zoneIDs.ARATHI_HIGHLANDS]={{46,45.97}},
                [zoneIDs.HILLSBRAD_FOOTHILLS]={{49.61,61.05}},
                [zoneIDs.THE_HINTERLANDS]={{13.91,46.87}},
                [zoneIDs.EASTERN_PLAGUELANDS]={{74.81,54.22}},
                [zoneIDs.WESTERN_PLAGUELANDS]={{43.73,84.72}},
                [zoneIDs.THE_BARRENS]={{62.64,38.23}},
                [zoneIDs.DUSTWALLOW_MARSH]={{68,50.78}},
                [zoneIDs.DESOLACE]={{65.19,8.73}},
                [zoneIDs.ASHENVALE]={{35.26,50.41}},
            },
        },
        [34907] = {
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING]={{50.21,49.08},{50.14,49.47},{49.75,49.51},{50.06,49.08},{50.63,48.98},{51.18,48.81},{50.43,49.05},{49.9,49.59},{50.3,49.61},{51,48.53}}},
        },
        [34947] = {
            [npcKeys.spawns] = {[zoneIDs.HROTHGARS_LANDING]={{50.21,49.08},{50.14,49.47},{49.75,49.51},{50.06,49.08},{50.63,48.98},{51.18,48.81},{50.43,49.05},{49.9,49.59},{50.3,49.61},{51,48.53}}},
        },
        [35060] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{66.87,8.97},{66.36,8.08},{67.31,8.2},{66.92,7.55}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35061] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{66.87,8.97},{66.36,8.08},{67.31,8.2},{66.92,7.55}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [35071] = {
            [npcKeys.spawns] = {[zoneIDs.ICECROWN]={{66.87,8.97},{66.36,8.08},{67.31,8.2},{66.92,7.55}}},
            [npcKeys.zoneID] = zoneIDs.ICECROWN,
        },
        [37214] = {
            [npcKeys.spawns] = {[zoneIDs.ELWYNN_FOREST]={{29.1,66.5},{28.8,66.2},{29.5,65.7},{28.8,65.7},{29.2,65.2}}},
        },
        [37715] = {
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY]={{27.43,34.83}}},
        },
        [37917] = {
            [npcKeys.spawns] = {[zoneIDs.DARKSHORE]={{43.3,79.9},{43.2,79.9},{43.2,79.5},{42.7,79.5},{43.0,79.4}}},
        },
        [38340] = {
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY]={{63.08,78.86}}},
        },
        [38341] = {
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY]={{60.81,70.03}}},
        },
        [38342] = {
            [npcKeys.spawns] = {[zoneIDs.STORMWIND_CITY]={{61.33,65.64}}},
        },
    }

    if UnitFactionGroup("Player") == "Horde" then
        return npcFixesHorde
    else
        return npcFixesAlliance
    end
end
