---@type SeasonOfDiscovery
local SeasonOfDiscovery = QuestieLoader:ImportModule("SeasonOfDiscovery")
---@type QuestieCorrections
local QuestieCorrections = QuestieLoader:ImportModule("QuestieCorrections")
---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")
---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")
---@type QuestieProfessions
local QuestieProfessions = QuestieLoader:ImportModule("QuestieProfessions")

QuestieCorrections.eventObjectiveFirst[85304] = true
QuestieCorrections.eventObjectiveFirst[85386] = true
QuestieCorrections.eventObjectiveFirst[89567] = true

function SeasonOfDiscovery:LoadQuests()
    local questKeys = QuestieDB.questKeys
    local zoneIDs = ZoneDB.zoneIDs
    local raceIDs = QuestieDB.raceKeys
    local classIDs = QuestieDB.classKeys
    local sortKeys = QuestieDB.sortKeys
    local questFlags = QuestieDB.questFlags
    local specialFlags = QuestieDB.specialFlags
    local factionIDs = QuestieDB.factionIDs
    local profKeys = QuestieProfessions.professionKeys
    local specKeys = QuestieProfessions.specializationKeys

    -- TODO: reputation once data is more reliably confirmed
    -- TODO: ZoneIDs, sort keys

    return {
        [7636] = { -- An Introduction
            [questKeys.nextQuestInChain] = 84546,
        },
        [7493] = { -- The Journey Has Just Begun
            [questKeys.preQuestSingle] = {84561},
        },
        [7497] = { -- The Journey Has Just Begun
            [questKeys.preQuestSingle] = {84560},
        },
        [8728] = { -- The Good News and The Bad News
            [questKeys.preQuestSingle] = {86444},
        },
        [8735] = { -- The Nightmare's Corruption
            [questKeys.preQuestSingle] = {86443},
        },
        [8742] = { -- The Might of Kalimdor
            [questKeys.preQuestGroup] = {8741,86442,86445},
        },
        [8801] = { -- C'Thun's Legacy
            [questKeys.nextQuestInChain] = 86670,
        },
        [8922] = { -- A Supernatural Device
            [questKeys.preQuestSingle] = {84147,84148,84149,84150,84151,84152,84153,84154},
        },
        [8923] = { -- A Supernatural Device
            [questKeys.preQuestSingle] = {84155,84156,84157,84158,84159,84160,84161,84162},
        },
        [8929] = { -- In Search of Anthion
            [questKeys.preQuestSingle] = {84163,84164,84165,84166,84167,84168,84169,84170},
        },
        [8930] = { -- In Search of Anthion
            [questKeys.preQuestSingle] = {84171,84172,84173,84174,84175,84176,84177,84178},
        },
        [8960] = { -- Bodley's Unfortunate Fate
            [questKeys.preQuestSingle] = {84179,84180,84181,84182,84183,84184,84185,84186},
        },
        [9032] = { -- Bodley's Unfortunate Fate
            [questKeys.preQuestSingle] = {84187,84188,84189,84190,84191,84192,84193,84194},
        },
        [76156] = { -- Stalk With The Earthmother
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [76160] = { -- Stalk With The Earthmother
            [questKeys.objectives] = {nil,nil,{{206175}}},
            [questKeys.preQuestSingle] = {76156},
            [questKeys.requiredSourceItems] = {206170},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [76240] = { -- Stalk With The Earthmother
            [questKeys.objectives] = {nil,nil,{{206345}}},
            [questKeys.preQuestSingle] = {76160},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [77568] = { -- A Hunter's Strength
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [77571] = { -- Relics of the Kaldorei
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410061, nil, 208414}}},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [77573] = { -- Second-Story Work
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.NIGHT_ELF,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77574] = { -- Meditation on Elune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.exclusiveTo] = {77619,77661},
        },
        [77575] = { -- Amidst the Shadowed Webs
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.NIGHT_ELF,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77582] = { -- A Trial of Fitness
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.ORC,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77583] = { -- Atop the Cliffs
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.ORC,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77584] = { -- Hunt for the Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.requiredRaces] = raceIDs.ORC,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [77585] = { -- Icons of Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410094, nil, 206381}}},
            [questKeys.requiredRaces] = raceIDs.ORC,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [77586] = { -- Stolen Power
            [questKeys.requiredRaces] = raceIDs.ORC,
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [77587] = { -- Icons of Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410094, nil, 206381}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [77588] = { -- A Trial of Fitness
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77590] = { -- Rugged Terrain
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [77592] = { -- Atop the Cliffs
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77616] = { -- The Lost Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.HUMAN,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77617] = { -- Relics of the Light
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410002, nil, 205420}}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.exclusiveTo] = {77657},
        },
        [77618] = { -- Thrice Stolen
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.HUMAN,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77619] = { -- Meditation on the Light
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.exclusiveTo] = {77574,77661},
        },
        [77620] = { -- Spell Research (Human)
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{401760, nil, 203751}}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
            [questKeys.exclusiveTo] = {77643,77667,77671},
        },
        [77621] = { -- Stolen Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [77642] = { -- Wisdom of the Loa
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.exclusiveTo] = {77670},
        },
        [77643] = { -- Spell Research (Troll)
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{401760, nil, 203751}}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
            [questKeys.exclusiveTo] = {77620,77667,77671},
        },
        [77648] = { -- Relics of the Tauren
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410061, nil, 208414}}},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [77649] = { -- A Hunter's Strength
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [77651] = { -- Into the Brambles
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.TAUREN,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77652] = { -- Icons of Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410094, nil, 206381}}},
            [questKeys.requiredRaces] = raceIDs.TAUREN,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [77655] = { -- The Lost Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.DWARF,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77656] = { -- The Lost Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.GNOME,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77657] = { -- Relics of the Light
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410002, nil, 205420}}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.exclusiveTo] = {77617},
        },
        [77658] = { -- Thrice Stolen
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.DWARF,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77659] = { -- Thrice Stolen
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.GNOME,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77660] = { -- Trek Through the Caves
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{410121, nil, 206168}}},
            [questKeys.requiredRaces] = raceIDs.DWARF,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [77661] = { -- Meditation on the Light
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.exclusiveTo] = {77574,77619},
        },
        [77666] = { -- Stolen Power
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [77667] = { -- Spell Research (Gnome)
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{401760, nil, 203751}}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
            [questKeys.exclusiveTo] = {77620,77643,77671},
        },
        [77668] = { -- The Lost Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403470, nil, 204806}}},
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [77669] = { -- The Scarlet Rune
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{400105, nil, 204795}}},
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [77670] = { -- Meditation on Undeath
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{402862, nil, 205951}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.exclusiveTo] = {77642},
        },
        [77671] = { -- Spell Research (Undead)
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{401760, nil, 203751}}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
            [questKeys.exclusiveTo] = {77620,77643,77667},
        },
        [77672] = { -- The Lost Rune
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
            [questKeys.objectives] = {nil, nil, nil, nil, nil, {{403919, nil, 205230}}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [78088] = { -- A Strange Artifact
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78089] = { -- Advice From Stormwind
            [questKeys.preQuestSingle] = {78088},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78090] = { -- A Second Opinion
            [questKeys.preQuestSingle] = {78089},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78091] = { -- Earning Your Salt
            [questKeys.preQuestSingle] = {78090},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78092] = { -- It Must Be Destroyed
            [questKeys.preQuestSingle] = {78091},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78093] = { -- Return to Delgren
            [questKeys.preQuestSingle] = {78092},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [78114] = { -- Wild Wyvern Wrangling
            [questKeys.questLevel] = 22,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [78121] = { -- Wrangling a Wild Wyvern
            [questKeys.questLevel] = 22,
            [questKeys.preQuestSingle] = {78114},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [78124] = { -- Nar'thalas Almanac
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78127] = { -- The Dalaran Digest
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78132] = { -- Dragonslayer's Helm
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [78133] = { -- Dragonslayer's Shield
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [78134] = { -- Dragonslayer's Lance
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [78142] = { -- Bewitchments and Glamours
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78143] = { -- Secrets of the Dreamers
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78144] = { -- Alonso the Dragonslayer
            [questKeys.questLevel] = -1,
            [questKeys.requiredSpell] = -425444,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.preQuestGroup] = {78132,78133,78134},
        },
        [78145] = { -- Arcanic Systems Manual
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78146] = { -- Goaz Scrolls
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78147] = { -- Crimes Against Anatomy
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78148] = { -- Runes of the Sorceror-Kings
            [questKeys.name] = "Runes of the Sorcerer-Kings",
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78149] = { -- Fury of the Land
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78150] = { -- Friend of the Library
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78192] = { -- Secrets of the Light
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredRaces] = raceIDs.NIGHT_ELF,
        },
        [78193] = { -- Secrets of the Light
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {78192},
            [questKeys.requiredRaces] = raceIDs.NIGHT_ELF,
        },
        [78194] = { -- Secrets of Elune
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredRaces] = raceIDs.DWARF + raceIDs.HUMAN,
        },
        [78195] = { -- Secrets of Elune
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {78194},
            [questKeys.requiredRaces] = raceIDs.DWARF + raceIDs.HUMAN,
        },
        [78196] = { -- Secrets of Undeath
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredRaces] = raceIDs.TROLL,
        },
        [78197] = { -- Secrets of Undeath
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {78196},
            [questKeys.requiredRaces] = raceIDs.TROLL,
        },
        [78198] = { -- Secrets of the Loa
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
        },
        [78199] = { -- Secrets of the Loa
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {78198},
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
        },
        [78229] = { -- Trial of The Owls
            [questKeys.preQuestGroup] = {90088,90089,90090},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
            [questKeys.objectivesText] = {"Bring symbols of the three owls to Loganaar in Moonglade. NOTE: To accept this quest, you need to bring at least one symbol, but you can also bring all three at once."},
        },
        [78261] = { -- The Horn of Xelthos
            [questKeys.requiredLevel] = 20,
            [questKeys.childQuests] = {78270},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [78265] = { -- Fish Oil
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78266] = { -- Dark Iron Ordinance
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78267] = { -- Shredder Turbochargers
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78270] = { -- Goblin Lockpicks
            [questKeys.objectivesText] = {"Pickpocket the work order from Venture Co. Operators in Windshear Crag"},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.parentQuest] = 78261,
        },
        [78277] = { -- A Token of Gratitude
            [questKeys.objectivesText] = {"Complete the quest chain starting with Resting in Pieces to receive the Living Bomb rune."},
            [questKeys.requiredSpell] = -415936,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [78287] = { -- Let Me Make You An Offer
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78288] = { -- Let Me Make You An Offer
            [questKeys.preQuestGroup] = {78265,78266,78267},
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78297] = { -- You've Got Yourself A Deal
            [questKeys.preQuestSingle] = {78287},
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78304] = { -- You've Got Yourself A Deal
            [questKeys.preQuestSingle] = {78288},
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [78307] = { -- The Horn of Xelthos
            [questKeys.startedBy] = {nil,{410369}},
            [questKeys.preQuestSingle] = {78261},
            [questKeys.objectivesText] = {"Head to a major city to receive another letter. Then head back to the Dead Drop to receive the rune."},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [78506] = { -- Elemental Distress
            [questKeys.preQuestSingle] = {78920},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [78537] = { -- Elixir of Insight
            [questKeys.preQuestSingle] = {85772},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [78561] = { -- Elixir of Insight
            [questKeys.objectives] = {},
            [questKeys.preQuestSingle] = {78537},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [78575] = { -- Hirzek
            [questKeys.preQuestSingle] = {78561},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [78611] = { -- A Waylaid Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [78612] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [78676] = { -- The Eye of Bhossca
            [questKeys.preQuestSingle] = {78261},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.extraObjectives] = {
                {nil, Questie.ICON_TYPE_LOOT, l10n("Step 1: Loot the Scarlet Initiate's Uniform from the chest in the stables, outside of Scarlet Monastery. You need Lockpicking 100 to open the chest."), 0, {{"object", 412147}}},
                {{[zoneIDs.SCARLET_MONASTERY]={{-1,-1}}}, Questie.ICON_TYPE_EVENT, l10n("Step 2: put on the Scarlet Initiate's Uniform while inside the Graveyard wing of Scarlet Monastery and not in a group.")},
                {nil, Questie.ICON_TYPE_LOOT, l10n("Step 3: pick pocket Scarlet Scryer to loot Scryer's Key."), 0, {{"monster", 4293}}},
                {nil, Questie.ICON_TYPE_LOOT, l10n("Step 4: head to the Library wing and loot the Confidential Message from the Personal Letterbox."), 0, {{"object", 412759}}},
                {nil, Questie.ICON_TYPE_LOOT, l10n("Step 5: go back to the Graveyard and /sit on the two benches between the pair of statues on either side of the graveyard. Then loot the Reliquary Key from the Stone Coffer in the northern mausoleum."), 0, {{"object", 412198}}},
                {nil, Questie.ICON_TYPE_LOOT, l10n("Step 6: go back to the Library and loot the Eye of Bhossca from the Padlocked Reliquary."), 0, {{"object", 412261}}},
            },
        },
        [78680] = { -- Rumors Abound
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {1740},
        },
        [78681] = { -- The Conjuring
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {78680},
        },
        [78684] = { -- Mysterious Traveler
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {78681},
        },
        [78699] = { -- The Eye of Bhossca
            [questKeys.startedBy] = {nil,{410369}},
            [questKeys.preQuestSingle] = {78676},
            [questKeys.objectivesText] = {"Head to a major city to receive another letter. Then head back to the Dead Drop to receive the rune."},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [78702] = { -- Raszel Ander
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {78684},
        },
        [78823] = { -- Terror of the Desert Skies
            [questKeys.startedBy] = {{2701,2715,2716,2717,2718,2893,2894,2906,2907}},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [78830] = { -- Terror of the Desert Skies
            [questKeys.preQuestSingle] = {78823},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [78872] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [78909] = { -- Shifting Scale Talisman
            [questKeys.objectivesText] = {"Tip: You need to loot Handful of Shifting Scales from Old Serra'kis in Blackfathom Deeps before you can start this quest.","","Bring N'ora Anyheart the following materials alongside the Handful of Shifting Scales to complete the talisman: A satchel of Strange Dust, five Greater Magic Essence, 2 Small Glimmering Shards and five gold pieces."},
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78914] = { -- Soul Vessel
            [questKeys.preQuestSingle] = {78994},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [78916] = { -- The Heart of the Void (Alliance)
            [questKeys.startedBy] = {nil, nil, {209693}},
            [questKeys.finishedBy] = {{4783}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.sourceItemId] = 209693,
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
        },
        [78917] = { -- The Heart of the Void (Horde)
            [questKeys.startedBy] = {nil, nil, {211452}},
            [questKeys.finishedBy] = {{9087}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.sourceItemId] = 211452,
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
        },
        [78920] = { -- Baron Aquanis (Horde)
            [questKeys.startedBy] = {nil, nil, {211454}},
            [questKeys.finishedBy] = {{12736}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78921] = { -- Blackfathom Villainy (Alliance)
            [questKeys.startedBy] = {{4787}},
            [questKeys.finishedBy] = {{4783}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5881}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78922] = { -- Blackfathom Villainy (Horde)
            [questKeys.startedBy] = {{4787}},
            [questKeys.finishedBy] = {{9087}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectives] = {nil,nil,{{5881}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78923] = { -- Knowledge in the Deeps (Alliance)
            [questKeys.startedBy] = {{2786}},
            [questKeys.finishedBy] = {{2786}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5359}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78924] = { -- In Search of Thaelrid
            [questKeys.startedBy] = {{4786}},
            [questKeys.finishedBy] = {{4787}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.exclusiveTo] = {78921,78922}
        },
        [78925] = { -- Twilight Falls (Alliance)
            [questKeys.startedBy] = {{4784}},
            [questKeys.finishedBy] = {{4784}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5879}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78926] = { -- Researching the Corruption (Alliance)
            [questKeys.startedBy] = {{8997}},
            [questKeys.finishedBy] = {{8997}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{5952}}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78927] = { -- Allegiance to the Old Gods (Horde)
            [questKeys.zoneOrSort] = zoneIDs.BLACKFATHOM_DEEPS,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [78994] = { -- A Solid Foundation
            [questKeys.preQuestSingle] = {78702},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [79007] = { -- ...and that note you found
            [questKeys.zoneOrSort] = zoneIDs.THE_BARRENS,
        },
        [79008] = { -- ...and that note you found
            [questKeys.zoneOrSort] = zoneIDs.WESTFALL,
        },
        [79077] = { -- Sharing the Faith (Stormwind)
            [questKeys.objectives] = {{{215062, nil, Questie.ICON_TYPE_EVENT}}},
            [questKeys.requiredRaces] = raceIDs.DWARF + raceIDs.HUMAN,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [79078] = { -- Sharing the Faith (Darnassus)
            [questKeys.objectives] = {{{215095, nil, Questie.ICON_TYPE_EVENT}}},
            [questKeys.requiredRaces] = raceIDs.NIGHT_ELF,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [79079] = { -- Sharing the Faith (Orgrimmar)
            [questKeys.objectives] = {{{215096, nil, Questie.ICON_TYPE_EVENT}}},
            [questKeys.requiredRaces] = raceIDs.TROLL,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [79080] = { -- Sharing the Faith (Undercity)
            [questKeys.objectives] = {{{215098, nil, Questie.ICON_TYPE_EVENT}}},
            [questKeys.requiredRaces] = raceIDs.UNDEAD,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [79090] = { -- Repelling Invaders
            [questKeys.startedBy] = {{212727,212728,212729,212730,212801,212802}},
            [questKeys.finishedBy] = {{212970,217707}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
        },
        [79091] = { -- Archmage Antonidas: The Unabridged Autobiography
            [questKeys.startedBy] = {nil,{386691}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Archmage Antonidas: The Unabridged Autobiography'and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79092] = { -- Archmage Theocritus's Research Journal
            [questKeys.startedBy] = {nil,{386759}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Azora Apprentice Notes: Page 1'and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79093] = { -- Rumi of Gnomeregan: The Collected Works
            [questKeys.startedBy] = {nil,{408014}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Rumi of Gnomeregan: The Collected Works'and bring it to Garion Wendell in Stormwind. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79094] = { -- The Lessons of Ta'zo
            [questKeys.startedBy] = {nil,{450001}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Lessons of Ta'zo'and bring it to Owen Thadd in Undercity. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79095] = { -- The Apothecary's Metaphysical Primer
            [questKeys.startedBy] = {nil,{405879}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Apothecary's Metaphysical Primer'and bring it to Owen Thadd in Undercity. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79096] = { -- Ataeric: On Arcane Curiosities
            [questKeys.startedBy] = {nil,{410299}},
            [questKeys.questLevel] = -1,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Ataeric: On Arcane Curiosities'and bring it to Owen Thadd in Undercity. After ten book turnins you will receive the Icy Veins rune."},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79097] = { -- Baxtan: On Destructive Magics
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79098] = { -- Clear the Forest!
            [questKeys.startedBy] = {{212699,212703,212706,212707,212803,212804}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
        },
        [79099] = { -- Baron Aquanis (Alliance)
            [questKeys.startedBy] = {{214876}},
            [questKeys.finishedBy] = {{214876}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectives] = {nil,nil,{{211818}}},
            [questKeys.zoneOrSort] = zoneIDs.AUBERDINE,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79100] = { -- A Waylaid Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79101] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79102] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79103] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79192] = { -- Stepping Stones
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.startedBy] = {nil,{415106,415107}},
            [questKeys.preQuestSingle] = {79007,79008},
            [questKeys.zoneOrSort] = zoneIDs.THE_BARRENS,
        },
        [79229] = { -- Highway Robbery
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
        },
        [79235] = { -- On the Lam
            [questKeys.preQuestSingle] = {79229},
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
        },
        [79236] = { -- Cherry for Your Thoughts?
            [questKeys.preQuestSingle] = {79235},
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
        },
        [79242] = { -- No Honor Among Thieves
            [questKeys.preQuestSingle] = {79236},
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_OBJECT, l10n("Use the Rowboat to reach the eastern shore."), 0, {{"object", 420055}}}},
        },
        [79298] = { -- Tempting Fate
            [questKeys.preQuestSingle] = {78914},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [79348] = { -- The Lost Ancient
            [questKeys.startedBy] = {nil,nil,{212693}},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [79358] = { -- Tattered Note
            [questKeys.startedBy] = {nil,nil,{212748}},
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
        },
        [79360] = { -- Elemental Aid
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79358},
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
        },
        [79361] = { -- Power of da Wind
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79360},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79362] = { -- Power of da Earth
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79360},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79363] = { -- Power of da Water
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79360},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79364] = { -- A Simple Container
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestGroup] = {79361,79362,79363},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79365] = { -- With Wind Beneath Your Wings
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79364},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79366] = { -- Calm Before the Storm
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79365},
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_TALK, l10n("Drink the Squall-breakers Potion and talk to Nyse."), 0, {{"monster", 4317}}}},
        },
        [79377] = { -- The Lost Saplings
            [questKeys.preQuestSingle] = {79348},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
            [questKeys.objectives] = {{{216437},{216451},{216448},{216445}},nil,{{213036}}},
        },
        [79442] = { -- Catching Up
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {79366},
            [questKeys.zoneOrSort] = zoneIDs.ALTERAC_MOUNTAINS,
        },
        [79482] = { -- Stolen Winter Veil Treats (Alliance)
            [questKeys.startedBy] = {{216902}},
            [questKeys.finishedBy] = {{216915}},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79483] = { -- Stolen Winter Veil Treats (Horde)
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79484] = { -- You're a Mean One... (Alliance)
            [questKeys.preQuestSingle] = {79482},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79485] = { -- You're a Mean One... (Horde)
            [questKeys.preQuestSingle] = {79483},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79486] = { -- A Smokywood Pastures' Thank You! (Alliance)
            [questKeys.preQuestSingle] = {79484},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79487] = { -- A Smokywood Pastures' Thank You! (Horde)
            [questKeys.preQuestSingle] = {79485},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79492] = { -- Metzen the Reindeer (Alliance)
            [questKeys.objectives] = {{{15664,"Find Metzen the Reindeer and rescue him"}},nil,{{21211}}},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79495] = { -- Metzen the Reindeer (Horde)
            [questKeys.objectives] = {{{15664,"Find Metzen the Reindeer and rescue him"}},nil,{{21211}}},
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79501] = { -- The Hero of the Day
            [questKeys.preQuestSingle] = {79492},
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79502] = { -- The Hero of the Day
            [questKeys.startedBy] = {{216924}},
            [questKeys.preQuestSingle] = {79495},
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79535] = { -- Basilisks: Should Petrification be Feared?
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79536] = { -- Greater Friend of the Library
            [questKeys.zoneOrSort] = sortKeys.MAGE,
            [questKeys.preQuestSingle] = {78150},
        },
        [79588] = { -- Small Furry Paws
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 500},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79589] = { -- Torn Bear Pelts
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1100},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79590] = { -- Heavy Grinding Stone
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1100},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 250}},
        },
        [79591] = { -- Whirring Bronze Gizmo
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1100},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79592] = { -- Carnival Jerkins
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1100},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 250}},
        },
        [79593] = { -- Coarse Weightstone
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 500},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79594] = { -- Copper Modulator
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 500},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79595] = { -- Carnival Boots
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 500},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [79624] = { -- Anyone Can Cook
            [questKeys.startedBy] = {{2254,2255,2256,2287,2569,2570,2571}},
            [questKeys.zoneOrSort] = zoneIDs.WARRIOR,
        },
        [79626] = { -- The Salvagematic 9000!
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79637] = { -- A Ticking Present
            [questKeys.zoneOrSort] = sortKeys.SEASONAL,
        },
        [79677] = { -- A Quick Grocery Run
            [questKeys.preQuestSingle] = {79624},
            [questKeys.zoneOrSort] = zoneIDs.WARRIOR,
        },
        [79678] = { -- Taste Testing
            [questKeys.preQuestSingle] = {79677},
            [questKeys.zoneOrSort] = zoneIDs.WARRIOR,
        },
        [79704] = { -- The Salvagematic 9000!
            [questKeys.startedBy] = {nil,{422483}},
            [questKeys.preQuestSingle] = {79705},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79705] = { -- Salvaging the Salvagematic
            [questKeys.finishedBy] = {{217689}},
            [questKeys.objectives] = {nil,nil,{{3860},{11135},{216634},{213735}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79731] = { -- The Troll Scroll
            [questKeys.startedBy] = {{702}},
            [questKeys.objectivesText] = {
                "Solve the riddle of the scroll. Once you've done that, Hemet Nesingwary might like to hear the tale.",
                "NOTE: Have a Rogue with a Jani's Charm trinket pickpocket a Mysterious Troll Scroll from the Bloodscalp Trolls in Stranglethorn Vale.",
                "Then let that scroll be deciphered by a Mage to receive a Deciphered Troll Scroll starting this quest.",
            },
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.requiredSourceItems] = {737},
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_OBJECT, l10n("Use the Holy Spring Water next to the Holy Spring, while you have two meditation buffs active. Then loot the rune from the fountain."), 0, {{"object", 759}}}},
        },
        [79939] = { -- The Broken Hammer
            [questKeys.startedBy] = {nil,{423703}},
            [questKeys.preQuestSingle] = {78093},
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
        },
        [79940] = { -- A Lost Brother
            [questKeys.objectives] = {{{5492,"Speak with Katherine and Learn More"}}},
            [questKeys.preQuestSingle] = {79939},
            [questKeys.zoneOrSort] = zoneIDs.DESOLACE,
        },
        [79945] = { -- Orders from the Grand Crusader
            [questKeys.startedBy] = {{218908}},
            [questKeys.preQuestSingle] = {79940},
            [questKeys.zoneOrSort] = zoneIDs.STORMWIND_CITY,
        },
        [79946] = { -- A Brother In Need
            [questKeys.objectives] = {{{5492,"Learn more about Aeonas from Katherine"},{217996,"Find Aeonas in the Scarlet Monastery"}}},
            [questKeys.preQuestSingle] = {79945},
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_MONASTERY,
        },
        [79947] = { -- Geomancy: The Stone-Cold Truth
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79948] = { -- Defensive Magics 101
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79949] = { -- A Web of Lies: Debunking Myths and Legends
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79950] = { -- Demons and You
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79951] = { -- Mummies: A Guide to the Unsavory Undead
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79952] = { -- RwlRwlRwlRwl!
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79953] = { -- A Ludite's Guide to Caring for Your Demonic Pet
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [79963] = { -- By The Light's Grace
            [questKeys.objectives] = {{{217996,"Heal Aeonas"}}},
            [questKeys.preQuestSingle] = {79946},
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_MONASTERY,
        },
        [79970] = { -- Aeonas the Vindicated
            [questKeys.objectives] = {{{218160,"Meet Aeonas at the Cathedral of Light in Stormwind"}}},
            [questKeys.preQuestSingle] = {79963},
            [questKeys.zoneOrSort] = zoneIDs.PALADIN,
        },
        [79974] = { -- Wet Job
            [questKeys.preQuestSingle] = {79980},
            [questKeys.zoneOrSort] = zoneIDs.STONETALON_MOUNTAINS,
        },
        [79975] = { -- Eagle's Fist
            [questKeys.preQuestSingle] = {79974},
            [questKeys.zoneOrSort] = zoneIDs.STONEWROUGHT_DAM,
        },
        [79976] = { -- This Must Be The Place
            [questKeys.preQuestSingle] = {79975},
            [questKeys.zoneOrSort] = zoneIDs.ARATHI_HIGHLANDS,
        },
        [79980] = { -- Scramble
            [questKeys.preQuestSingle] = {79192},
            [questKeys.zoneOrSort] = zoneIDs.STONETALON_MOUNTAINS,
        },
        [79981] = { -- The Corroded Core
            [questKeys.startedBy] = {{216666}},
            [questKeys.finishedBy] = {{218237}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_TALK, l10n("Talk with Scooty in Booty Bay."), 0, {{"monster", 7853}}}},
        },
        [79982] = { -- Warrany Claim
            [questKeys.preQuestSingle] = {79981},
            [questKeys.requiredSourceItems] = {216635,216645},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.extraObjectives] = {{{[zoneIDs.FERALAS]={{84.5,44.8}}}, Questie.ICON_TYPE_SLAY, l10n("Defeat enough enemies around the world to call forth the Shadowy Figure and talk to her to receive a Mote of Darkness.")}},
        },
        [79984] = { -- Quadrangulation
            [questKeys.objectives] = {nil,{{424074},{424075},{424076},{424077}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79985] = { -- A Fine Mess
            [questKeys.triggerEnd] = {"Kernobee Rescue", {[zoneIDs.GNOMEREGAN]={{-1,-1}}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79986] = { -- Grime-Encrusted Ring
            [questKeys.startedBy] = {nil,nil,{216661}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79987] = { -- Return of the Ring Alliance
            [questKeys.preQuestSingle] = {79984},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [79990] = { -- Stranglethorn Lumber
            [questKeys.zoneOrSort] = zoneIDs.ARATHI_HIGHLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [79991] = { -- Stranglethorn Lumber
            [questKeys.zoneOrSort] = zoneIDs.ARATHI_HIGHLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80001] = { -- Rekindle
            [questKeys.preQuestSingle] = {79192},
            [questKeys.exclusiveTo] = {79974},
        },
        [80098] = { -- Curious Dalaran Relic
            [questKeys.startedBy] = {{218931}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80120] = { -- A Service to Dalaran
            [questKeys.preQuestGroup] = {80098,80147,80148,80149,80150,80151,80152},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80131] = { -- Gnome Improvement Alliance
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.preQuestSingle] = {79987},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80132] = { -- Rig Wars
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80133] = { -- Chief Engineer Scooty
            [questKeys.startedBy] = {{3413}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80134] = { -- Gnomer-gooooone!
            [questKeys.triggerEnd] = {"Goblin Transponder", {[zoneIDs.STRANGLETHORN_VALE]={{27.56,77.42}}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.preQuestSingle] = {80133},
        },
        [80135] = { -- Klockmort's Essentials
            [questKeys.exclusiveTo] = {80136},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80136] = { -- Essential Artificials
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80137] = { -- Save Techbot's Brain!
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80138] = { -- Tinkmaster Overspark
            [questKeys.exclusiveTo] = {80137},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80139] = { -- Gnogaine
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_INTERACT, l10n("Use the Empty Leaden Collection Phial."), 0, {{"monster", 216668},{"monster", 216669}}}},
        },
        [80140] = { -- Return of the Ring Horde
            [questKeys.preQuestSingle] = {79984},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80141] = { -- Nogg's Ring Redo
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.preQuestSingle] = {80140},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80142] = { -- Castpipe's Task
            [questKeys.startedBy] = {{4077}},
            [questKeys.finishedBy] = {{7950}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.nextQuestInChain] = 80143,
        },
        [80143] = { -- Data Rescue
            [questKeys.extraObjectives] = {
                {nil, Questie.ICON_TYPE_OBJECT, l10n("Step 1: obtain the Yellow Punch Card. You need the White Punch Card."), 0, {{"object", 142345}}},
                {nil, Questie.ICON_TYPE_OBJECT, l10n("Step 2: obtain the Blue Punch Card. You need the Yellow Punch Card."), 0, {{"object", 142475}}},
                {nil, Questie.ICON_TYPE_OBJECT, l10n("Step 3: obtain the Red Punch Card. You need the Blue Punch Card."), 0, {{"object", 142476}}},
                {nil, Questie.ICON_TYPE_OBJECT, l10n("Step 4: obtain the Prismatic Punch Card. You need the Red Punch Card."), 0, {{"object", 142696}}},
            },
            [questKeys.requiredSourceItems] = {9279,9280,9281,9282},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80147] = { -- Glittering Dalaran Relic
            [questKeys.startedBy] = {{900000}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80148] = { -- Whirring Dalaran Relic
            [questKeys.startedBy] = {{900001}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80149] = { -- Odd Dalaran Relic
            [questKeys.startedBy] = {{900002}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80150] = { -- Heavy Dalaran Relic
            [questKeys.startedBy] = {{900003}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80151] = { -- Creepy Dalaran Relic
            [questKeys.startedBy] = {{900004}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80152] = { -- Slippery Dalaran Relic
            [questKeys.startedBy] = {{900005}},
            [questKeys.objectivesText] = {"Defeat the Dark Rider and bring the relic to the Dalaran Agent in Deadwind Pass."},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [80153] = { -- The Sparklematic 5200!
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80155] = { -- More Sparklematic Action
            [questKeys.preQuestSingle] = {80157},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80157] = { -- The Sparklematic 5200!
            [questKeys.preQuestSingle] = {80158},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80158] = { -- The Sparklematic 5200!
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80160] = { -- More Sparklematic Action
            [questKeys.preQuestSingle] = {80161},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80161] = { -- The Sparklematic 5200!
            [questKeys.preQuestSingle] = {80153},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80164] = { -- Large Cluster Rockets
            [questKeys.zoneOrSort] = sortKeys.LUNAR_FESTIVAL,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80165] = { -- Cluster Rockets
            [questKeys.zoneOrSort] = sortKeys.LUNAR_FESTIVAL,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80166] = { -- Small Rockets
            [questKeys.zoneOrSort] = sortKeys.LUNAR_FESTIVAL,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80167] = { -- Large Rockets
            [questKeys.zoneOrSort] = sortKeys.LUNAR_FESTIVAL,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80168] = { -- Large Rockets
            [questKeys.zoneOrSort] = sortKeys.LUNAR_FESTIVAL,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80180] = { -- The Grand Betrayal
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80181] = { -- Gyrodrillmatic Excavationators
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80182] = { -- The Only Cure is More Green Glow
            [questKeys.preQuestSingle] = {80139},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80241] = {
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
            [questKeys.requiredSkill] = {specKeys.BLACKSMITHING,210},
        },
        [80307] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80308] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80309] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [80324] = { -- The Mad King
            [questKeys.startedBy] = {{218537}},
            [questKeys.objectives] = {nil,nil,{{217350}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80325] = { -- The Mad King
            [questKeys.startedBy] = {{218537}},
            [questKeys.objectives] = {nil,nil,{{217351}}},
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
            [questKeys.questFlags] = questFlags.RAID,
        },
        [80411] = { -- The Talisman of Kazdor
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestSingle] = {80526},
            [questKeys.nextQuestInChain] = 80453,
        },
        [80417] = { -- Soft Bushy Tails
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1700},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [80421] = { -- Green Iron Bracers
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1700},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [80422] = { -- Green Fireworks
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1700},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [80423] = { -- The World's Largest Gnome!
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 1700},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [80453] = { -- Best Laid Plans
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestSingle] = {80411},
            [questKeys.nextQuestInChain] = 80454,
        },
        [80454] = { -- One Last Drop
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestSingle] = {80453},
            [questKeys.nextQuestInChain] = 80455,
        },
        [80455] = { -- Biding Our Time
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestSingle] = {80454},
        },
        [80526] = { -- Fool Me Twice
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestGroup] = {6681,78261,78676},
            [questKeys.nextQuestInChain] = 80411,
        },
        [81570] = { -- Jarl Needs a Blade
            [questKeys.finishedBy] = {{4792}},
            [questKeys.preQuestSingle] = {1206},
            [questKeys.zoneOrSort] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [81682] = { -- The Old Camp
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [81697] = { -- Defanged
            [questKeys.preQuestSingle] = {81682},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [81801] = { -- Return to the Arena
            [questKeys.preQuestSingle] = {81697},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [81877] = { -- Fight Night
            [questKeys.objectives] = {{{221829}}},
            [questKeys.preQuestSingle] = {81801},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },

        -- P3 Incursion Intro Quests
        [81716] = { -- Recover Incursion Field Report: Duskwood
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219759, nil, Questie.ICON_TYPE_TALK}},nil,{{{221226},221226},{{221223},221223},{{221227},221227}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81727] = { -- Recover Incursion Field Report: Ashenvale
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219770, nil, Questie.ICON_TYPE_TALK}},nil,{{{221283},221283},{{221282},221282},{{221292},221292}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81728] = { -- Recover Incursion Field Report: Hinterlands
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219772, nil, Questie.ICON_TYPE_TALK}},nil,{{{221357},221357},{{221356},221356},{{221360},221360}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81729] = { -- Recover Incursion Field Report: Feralas
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219771, nil, Questie.ICON_TYPE_TALK}},nil,{{{221407},221407},{{221406},221406},{{221408},221408}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.requiredMaxLevel] = 53,
        },

        -- Begin Duskwood Incursion
        [81730] = { -- Duskwood Mission I: Defeat Worgen
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81731] = { -- Duskwood Mission II: Defeat Ogres
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81732] = { -- Duskwood Mission III: Defeat Dragonkin
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81733] = { -- Duskwood Mission IV: Ogre Intelligence
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219776, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81734] = { -- Duskwood Mission V: Worgen Intelligence
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219778, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81735] = { -- Duskwood Mission VI: Dragon Intelligence
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {nil,nil,{{219803, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81736] = { -- Duskwood Mission VII: Recover Shadowscythe
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81737] = { -- Duskwood Mission VIII: Recover Ogre Magi text
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81738] = { -- Duskwood Mission IX: Recover Dragon Egg
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81739] = { -- Duskwood Mission X: Nightmare Moss
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81740] = { -- Duskwood Mission XI: Cold Iron Ore
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81741] = { -- Duskwood Mission XII: Dream-Touched Dragonscale
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81742] = { -- Duskwood Mission XIII: Defeat Ylanthrius
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81743] = { -- Duskwood Mission XIV: Defeat Vvarc'zul
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81744] = { -- Duskwood Mission XV: Defeat Amokarok
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81745] = { -- Duskwood Mission XVI: Rescue Kroll Mountainshade
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221210, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.DUSKWOOD]={{46.52,38.69}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Kroll Mountainshade to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81746] = { -- Duskwood Mission XVII: Rescue Alara Grovemender
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221215, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.DUSKWOOD]={{46.52,38.69}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Alara Grovemender to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        [81747] = { -- Duskwood Mission XVIII: Rescue Elenora Marshwalker
            [questKeys.zoneOrSort] = zoneIDs.DUSKWOOD,
            [questKeys.objectives] = {{{221216, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.DUSKWOOD]={{46.52,38.69}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Elenora Marshwalker to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 39,
        },
        -- End Duskwood Incursion

        [81762] = { -- Some Good News
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [81764] = { -- The Mysterious Merchant
            [questKeys.preQuestSingle] = {79970},
            [questKeys.nextQuestInChain] = 81765,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [81765] = { -- Elrick, Paladin of the Silver Hand
            [questKeys.preQuestSingle] = {81764},
            [questKeys.nextQuestInChain] = 81766,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [81766] = { -- The Bloody Missive
            [questKeys.startedBy] = {nil,nil,{219930}},
            [questKeys.preQuestSingle] = {81765},
            [questKeys.nextQuestInChain] = 81790,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },

        -- Begin Ashenvale Incursion
        [81768] = { -- Ashenvale Mission I: Defeat Satyrs
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81769] = { -- Ashenvale Mission II: Defeat Treants
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81770] = { -- Ashenvale Mission III: Defeat Dragonkin
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81771] = { -- Ashenvale Mission IV: Dragon Intelligence
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219924, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81772] = { -- Ashenvale Mission V: Satyr Intelligence
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219925, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81773] = { -- Ashenvale Mission VI: Treant Intelligence
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {nil,nil,{{219926, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81774] = { -- Ashenvale Mission VII: Recover Dreamengine
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81775] = { -- Ashenvale Mission VIII: Recover Azsharan Prophecy
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81776] = { -- Ashenvale Mission IX: Recover Dream-Touched Dragonegg
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81777] = { -- Ashenvale Mission X: Dreamroot
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81778] = { -- Ashenvale Mission XI: Fool's Gold Dust
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81779] = { -- Ashenvale Mission XII: Dream-Infused Dragonscale
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81780] = { -- Ashenvale Mission XIII: Defeat Larsera
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81781] = { -- Ashenvale Mission XIV: Defeat Zalius
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81782] = { -- Ashenvale Mission XV: Defeat Shredder 9000
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81783] = { -- Ashenvale Mission XVI: Rescue Alyssian Windcaller
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221270, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.ASHENVALE]={{93.94,38.35}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Alyssian Windcaller to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81784] = { -- Ashenvale Mission XVII: Rescue Doran Dreambough
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221268, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.ASHENVALE]={{93.94,38.35}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Doran Dreambough to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        [81785] = { -- Ashenvale Mission XVIII: Rescue Maseara Autumnmoon
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
            [questKeys.objectives] = {{{221269, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.ASHENVALE]={{93.94,38.35}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Maseara Autumnmoon to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 49,
        },
        -- End Ashenvale Incursion

        -- Begin Hinterlands Incursion
        [81786] = { -- Hinterlands Mission I: Defeat Moonkin
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81787] = { -- Hinterlands Mission II: Defeat Giant Turtles
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81788] = { -- Hinterlands Mission III: Defeat Dragonkin
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81789] = { -- Hinterlands Mission IV: Dragon Intelligence
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219928, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81817] = { -- Hinterlands Mission V: Turtle Intelligence
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219937, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81820] = { -- Hinterlands Mission VI: Moonkin Intelligence
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {nil,nil,{{219938, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81826] = { -- Hinterlands Mission VII: Recover Star-Touched Dragonegg
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81830] = { -- Hinterlands Mission VIII: Recover Elunar Relic
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81832] = { -- Hinterlands Mission IX: Recover Dreampearl
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81833] = { -- Hinterlands Mission X: Star Lotus
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81834] = { -- Hinterlands Mission XI: Starsilver Ore
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81835] = { -- Hinterlands Mission XII: Starshells
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81837] = { -- Hinterlands Mission XIII: Defeat Florius
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81838] = { -- Hinterlands Mission XIV: Defeat Doomkin
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81839] = { -- Hinterlands Mission XV: Defeat Ghamoo-Raja
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81850] = { -- Hinterlands Mission XVI: Rescue Elianar Shadowdrinker
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221335, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.THE_HINTERLANDS]={{63.24,27.39}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Elianar Shadowdrinker to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81851] = { -- Hinterlands Mission XVII: Rescue Serlina Starbright
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221336, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.THE_HINTERLANDS]={{63.24,27.39}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Serlina Starbright to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81852] = { -- Hinterlands Mission XVIII: Rescue Veanna Cloudsleeper
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.objectives] = {{{221337, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.THE_HINTERLANDS]={{63.24,27.39}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Veanna Cloudsleeper to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        -- End Hinterlands Incursion

        -- Begin Feralas Incursion
        [81855] = { -- Feralas Mission I: Defeat Children of Cenarius
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81856] = { -- Feralas Mission II: Defeat Harpies
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81857] = { -- Feralas Mission III: Defeat Dragonkin
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81858] = { -- Feralas Mission IV: Dragon Intelligence
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219957, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81859] = { -- Feralas Mission V: Cenarion Intelligence
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219958, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81860] = { -- Feralas Mission VI: Harpy Intelligence
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {nil,nil,{{219959, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81861] = { -- Feralas Mission VII: Recover Moonglow Dragonegg
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81863] = { -- Feralas Mission VIII: Recover Keeper's Notes
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81864] = { -- Feralas Mission IX: Recover Harpy Screed
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81865] = { -- Feralas Mission X: Moonroot
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81866] = { -- Feralas Mission XI: Greater Moonstone
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81867] = { -- Feralas Mission XII: Greater Moondragon Scales
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81868] = { -- Feralas Mission XIII: Defeat Tyrannikus
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81870] = { -- Feralas Mission XIV: Defeat Alondrius
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81871] = { -- Feralas Mission XV: Defeat Slirena
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81872] = { -- Feralas Mission XVI: Rescue Mellias Earthtender
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221395, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.FERALAS]={{50.97,11.67}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Mellias Earthtender to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81873] = { -- Feralas Mission XVII: Rescue Nerene Brooksinger
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221398, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.FERALAS]={{50.97,11.67}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Nerene Brooksinger to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        [81874] = { -- Feralas Mission XVIII: Rescue Jamniss Treemender
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
            [questKeys.objectives] = {{{221399, nil, Questie.ICON_TYPE_TALK}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.FERALAS]={{50.97,11.67}}}, Questie.ICON_TYPE_EVENT, l10n("Escort Jamniss Treemender to the Dream Portal"),}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredMaxLevel] = 53,
        },
        -- End Feralas Incursion

        [81790] = { -- Materials of Significance
            [questKeys.preQuestSingle] = {81766},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [81885] = { -- The Ritual
            [questKeys.preQuestSingle] = {81790},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [81900] = { -- The Burning Beast
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [81917] = { -- Chains That Bind
            [questKeys.preQuestSingle] = {81900},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [81919] = { -- Brought to Heel
            [questKeys.preQuestSingle] = {81917},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [81924] = { -- Wisdom of the Guardians
            [questKeys.zoneOrSort] = sortKeys.DRUID,
            [questKeys.extraObjectives] = {
                {nil, Questie.ICON_TYPE_INTERACT, l10n("Part 1: Get shrunk and decurse it"), 0, {{"monster", 5240}}},
                {nil, Questie.ICON_TYPE_INTERACT, l10n("Part 2: Get poisoned and abolish it"), 0, {{"monster", 5245}}},
                {nil, Questie.ICON_TYPE_EVENT, l10n("Part 3: When buffed with the Mark of the Warden summon and defeat the Treant Avatar"), 0, {{"object", 441948}}},
                {nil, Questie.ICON_TYPE_INTERACT, l10n("Part 1: Kill the Child of Apa'ro to receive a Sacred Stag Heart"), 0, {{"monster", 222580}}},
                {nil, Questie.ICON_TYPE_EVENT, l10n("Part 2: Offer the Sacred Stag Heart and defeat the Hippogryph Avatar"), 0, {{"object", 441947}}},
                {nil, Questie.ICON_TYPE_INTERACT, l10n("Cast Tranquility followed by Hurricane to summon the Moonkin Avatar and defeat him"), 0, {{"object", 441946}}},
            },
        },
        [81944] = { -- A Newly Discovered Purpose...
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [81947] = { -- Sanguine Sorcery
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [81949] = { -- Legends of the Tidesages
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [81951] = { -- The Liminal and the Arcane
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [81952] = { -- Everyday Etiquette
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [81953] = { -- Stonewrought Design
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [81954] = { -- Venomous Journeys
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [81955] = { -- A Mind of Metal
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [81956] = { -- Conjurer's Codex
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [81960] = { -- Clarifying Air
            [questKeys.startedBy] = {{2655,2656},nil,{220379}},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [81967] = { -- Otherworldly Treasure
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [81968] = { -- Answering Air's Call
            [questKeys.preQuestSingle] = {81960},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [81974] = { -- More Junk for Ziri
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
        },
        [81975] = { -- A Troubling Exchange
            [questKeys.zoneOrSort] = zoneIDs.GNOMEREGAN,
        },
        [81986] = { -- Waking the Nightmare
            [questKeys.preQuestSingle] = {82022},
            [questKeys.objectives] = {{{222198}},nil,{{220570}}},
            [questKeys.zoneOrSort] = sortKeys.NIGHTMARE_INCURSIONS,
            [questKeys.extraObjectives] = {{{[zoneIDs.ASHENVALE]={{94.26,35.13}}}, Questie.ICON_TYPE_EVENT, l10n("Enter the Emerald Dream"),}},
        },
        [81987] = { -- Goblin Solutions (Goblin)
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,225},
            [questKeys.requiredSpecialization] = specKeys.ENGINEERING_GOBLIN,
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
        },
        [82001] = { -- Require Gnomish Problems (Goblin)
            [questKeys.preQuestSingle] = {81987},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,225},
            [questKeys.requiredSpecialization] = specKeys.ENGINEERING_GOBLIN,
            [questKeys.zoneOrSort] = zoneIDs.UN_GORO_CRATER,
        },
        [82002] = { -- Whats Red and Smells like Paint?" (Goblin)
            [questKeys.preQuestSingle] = {82001},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,225},
            [questKeys.requiredSpecialization] = specKeys.ENGINEERING_GOBLIN,
            [questKeys.zoneOrSort] = zoneIDs.WESTERN_PLAGUELANDS,
        },
        [82003] = { -- Victory Lap For the Goblins! (Goblin)
            [questKeys.preQuestSingle] = {82002},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,225},
            [questKeys.requiredSpecialization] = specKeys.ENGINEERING_GOBLIN,
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
        },
        [82004] = { -- Hush Money (Goblin)
            [questKeys.preQuestSingle] = {82003},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,225},
            [questKeys.requiredSpecialization] = specKeys.ENGINEERING_GOBLIN,
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82008] = { -- Gnomish Solutions (Gnome)
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,225},
            [questKeys.requiredSpecialization] = specKeys.ENGINEERING_GNOMISH,
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
        },
        [82009] = { -- Require Goblin Problems (Gnome)
            [questKeys.preQuestSingle] = {82008},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,225},
            [questKeys.requiredSpecialization] = specKeys.ENGINEERING_GNOMISH,
            [questKeys.zoneOrSort] = zoneIDs.UN_GORO_CRATER,
        },
        [82010] = { -- Watering Down the Competition (Gnome)
            [questKeys.preQuestSingle] = {82009},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,225},
            [questKeys.requiredSpecialization] = specKeys.ENGINEERING_GNOMISH,
            [questKeys.zoneOrSort] = zoneIDs.WESTERN_PLAGUELANDS,
        },
        [82011] = { -- Victory Lap For the Gnomes! (Gnome)
            [questKeys.preQuestSingle] = {82010},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,225},
            [questKeys.requiredSpecialization] = specKeys.ENGINEERING_GNOMISH,
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
        },
        [82013] = { -- Hush Money (Gnome)
            [questKeys.preQuestSingle] = {82011},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,225},
            [questKeys.requiredSpecialization] = specKeys.ENGINEERING_GNOMISH,
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82016] = { -- Atal'ai Potent Potables
            [questKeys.zoneOrSort] = zoneIDs.STRANGLETHORN_VALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82017] = { -- An Amalagamation of Nightmares
            [questKeys.nextQuestInChain] = 82018,
            [questKeys.objectives] = {{{12042,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.zoneOrSort] = zoneIDs.ASHENVALE,
        },
        [82018] = { -- Itharius
            [questKeys.nextQuestInChain] = 82019,
            [questKeys.preQuestSingle] = {82017},
            [questKeys.objectives] = {{{5353,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.zoneOrSort] = zoneIDs.SWAMP_OF_SORROWS,
        },
        [82019] = { -- Going Under
            [questKeys.nextQuestInChain] = 82020,
            [questKeys.preQuestSingle] = {82018},
            [questKeys.extraObjectives] = {{{[zoneIDs.SWAMP_OF_SORROWS]={{70.24,54.08}}}, Questie.ICON_TYPE_EVENT, l10n("Explore the Temple of Atal'Hakkar"),}},
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
        },
        [82020] = { -- Return to Moonglade
            [questKeys.nextQuestInChain] = 82021,
            [questKeys.preQuestSingle] = {82019},
            [questKeys.objectives] = {{{12042,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.zoneOrSort] = zoneIDs.MOONGLADE,
        },
        [82021] = { -- A Fortuitous Turn of Events
            [questKeys.nextQuestInChain] = 82022,
            [questKeys.preQuestSingle] = {82020},
            [questKeys.objectives] = {{{222188,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.zoneOrSort] = zoneIDs.MOONGLADE,
        },
        [82022] = { -- The Bad News...
            [questKeys.nextQuestInChain] = 81986,
            [questKeys.preQuestSingle] = {82021},
            [questKeys.objectives] = {nil,nil,{{220964}}},
            [questKeys.childQuests] = {82023},
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_TALK, l10n("Talk to the Injured Gnome"), 0, {{"monster", 222444}}}},
            [questKeys.zoneOrSort] = zoneIDs.MOONGLADE,
        },
        [82023] = { -- The Lost Vambraces
            [questKeys.parentQuest] = 82022,
            [questKeys.objectives] = {nil,{{441848}}},
        },
        [82043] = { -- The Wild Gods
            [questKeys.zoneOrSort] = zoneIDs.FELWOOD,
        },
        [82044] = { -- The Wild Gods
            [questKeys.zoneOrSort] = zoneIDs.FELWOOD,
        },
        [82055] = { -- Darkmoon Dunes Deck
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [82056] = { -- Darkmoon Nightmares Deck
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [82057] = { -- Darkmoon Plagues Deck
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [82058] = { -- Darkmoon Wilds Deck
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
        },
        [82062] = { -- Ever After
            [questKeys.zoneOrSort] = zoneIDs.BLACKROCK_DEPTHS,
        },
        [82068] = { -- Fight the Nightmare Incursions
            [questKeys.startedBy] = {{221479,221480}},
            [questKeys.finishedBy] = {{221479,221480}},
            [questKeys.objectives] = {nil,nil,nil,nil,{{{221479,221480},221479}}},
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.NIGHTMARE_INCURSIONS,
            [questKeys.requiredMaxLevel] = 53,
        },
        [82071] = { -- Purifying Fire
            [questKeys.startedBy] = {{5852,5855},nil,{221350}},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [82072] = { -- Purging Earth
            [questKeys.startedBy] = {{5420,5426,5465},nil,{221352}},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [82073] = { -- Cleansing Water
            [questKeys.startedBy] = {{6125,6126,6127},nil,{221351}},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [82074] = { -- Answering Fire's Call
            [questKeys.preQuestSingle] = {82071},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [82075] = { -- Answering Earth's Call
            [questKeys.preQuestSingle] = {82072},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [82076] = { -- Answering Water's Call
            [questKeys.preQuestSingle] = {82073},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [82081] = { -- A Broken Ritual
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
        },
        [82083] = { -- A Broken Ritual
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
        },
        [82084] = { -- A Lesson in Literacy
            [questKeys.startedBy] = {{211022,211033}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [82086] = { -- A Lesson in Literacy
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [82089] = { -- Master of Transmutation
            [questKeys.zoneOrSort] = sortKeys.ALCHEMY,
            [questKeys.requiredSkill] = {profKeys.ALCHEMY,275},
        },
        [82090] = { -- Mixology For Fun and Profit
            [questKeys.zoneOrSort] = sortKeys.ALCHEMY,
            [questKeys.requiredSkill] = {profKeys.ALCHEMY,275},
        },
        [82093] = { -- Jungle Durian
            [questKeys.zoneOrSort] = zoneIDs.STRANGLETHORN_VALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82094] = { -- Signets of the Lost Temple
            [questKeys.zoneOrSort] = zoneIDs.STRANGLETHORN_VALE,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82095] = { -- The God Hakkar
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [questKeys.preQuestSingle] = {4787},
        },
        [82096] = { -- Into the Depths
            [questKeys.preQuestSingle] = {3444},
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
        },
        [82097] = { -- Secret of the Circle
            [questKeys.preQuestSingle] = {3444},
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
        },
        [82098] = { -- Into The Temple of Atal'Hakkar
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [questKeys.preQuestSingle] = {1469},
        },
        [82099] = { -- Haze of Evil
            [questKeys.zoneOrSort] = zoneIDs.UN_GORO_CRATER,
            [questKeys.preQuestSingle] = {4142},
            [questKeys.nextQuestInChain] = 4144,
        },
        [82100] = { -- The Temple of Atal'Hakkar
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
            [questKeys.preQuestSingle] = {1444},
        },
        [82101] = { -- Zapper Fuel
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
        },
        [82102] = { -- The Essence of Eranikus
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
        },
        [82104] = { -- Jammal'an the Prophet
            [questKeys.zoneOrSort] = zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR,
        },
        [82106] = { -- Forging the Mightstone
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.preQuestSingle] = {8416},
        },
        [82107] = { -- Voodoo Feathers
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.preQuestSingle] = {8424},
        },
        [82108] = { -- The Green Drake
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
            [questKeys.preQuestSingle] = {8231},
        },
        [82110] = { -- The Azure Key
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
            [questKeys.preQuestSingle] = {8235},
        },
        [82111] = { -- Blood of Morphaz
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {8256},
        },
        [82112] = { -- A Better Ingredient
            [questKeys.zoneOrSort] = sortKeys.DRUID,
            [questKeys.preQuestSingle] = {9051},
        },
        [82113] = { -- Da Voodoo
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
            [questKeys.preQuestSingle] = {8412},
        },
        [82114] = { -- Destroy Morphaz
            [questKeys.zoneOrSort] = sortKeys.MAGE,
            [questKeys.preQuestSingle] = {8252},
        },
        [82115] = { -- Trolls of a Feather
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.preQuestSingle] = {8421},
        },
        [82135] = { -- The Price of Hope
            [questKeys.preQuestSingle] = {81885},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [82208] = { -- Greater Friend of the Library
            [questKeys.zoneOrSort] = sortKeys.MAGE,
            [questKeys.preQuestSingle] = {79536},
            [questKeys.objectivesText] = {"You will need to hand in 25 books to receive the rune, however you can hand 1 in at any time."},
        },
        [82209] = { -- Water Pouch Bounty  (repeatable)
            [questKeys.preQuestSingle] = {1707},
            [questKeys.zoneOrSort] = zoneIDs.TANARIS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82210] = { -- Troll Necklace Bounty
            [questKeys.preQuestSingle] = {2880},
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82271] = { -- More Glowing Scorpid Blood
            [questKeys.preQuestSingle] = {82272},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 5500},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82272] = { -- Glowing Scorpid Blood
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 5500},
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [82273] = { -- More Bat Eyes
            [questKeys.preQuestSingle] = {82274},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 5500},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82274] = { -- Evil Bat Eyes
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 5500},
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [82275] = { -- Big Black Mace
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 2500},
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82276] = { -- Rituals of Strength
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 5500},
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82277] = { -- More Dense Grinding Stones
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 5500},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82278] = { -- More Thorium Widgets
            [questKeys.preQuestSingle] = {82279},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 5500},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82279] = { -- Thorium Widget
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 5500},
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [82280] = { -- Mechanical Repair Kits
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 2500},
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82281] = { -- More Armor Kits
            [questKeys.preQuestSingle] = {82282},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 5500},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82282] = { -- Armor Kits
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 5500},
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
        },
        [82283] = { -- Crocolisk Boy and the Bearded Murloc
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.requiredMaxRep] = {factionIDs.DARKMOON_FAIRE, 2500},
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE, 100}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82301] = { -- Otherworldly Treasure
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82302] = { -- Otherworldly Treasure
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82303] = { -- Otherworldly Treasure
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82307] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82308] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82309] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [82316] = { -- Seven Eyes I Seek...
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
            [questKeys.preQuestSingle] = {90304},
        },
        [82656] = { -- Wild Leather Vest (Horde)
            [questKeys.zoneOrSort] = sortKeys.LEATHERWORKING,
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,225},
        },
        [82657] = { -- Wild Leather Vest (Alliance)
            [questKeys.zoneOrSort] = sortKeys.LEATHERWORKING,
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,225},
        },
        [82662] = { -- The Way of the Weaponsmith (Alliance)
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
            [questKeys.requiredSkill] = {profKeys.BLACKSMITHING,200},
            [questKeys.requiredSpecialization] = specKeys.BLACKSMITHING,
        },
        [82665] = { -- The Way of the Weaponsmith (Horde)
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
            [questKeys.requiredSkill] = {profKeys.BLACKSMITHING,200},
            [questKeys.requiredSpecialization] = specKeys.BLACKSMITHING,
        },
        [82850] = { -- Fish Oil
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [82851] = { -- Dark Iron Ordinance
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [82853] = { -- Shredder Turbochargers
            [questKeys.zoneOrSort] = zoneIDs.RATCHET,
        },
        [83188] = { -- Otherworldly Treasure
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [83189] = { -- Otherworldly Treasure
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [83190] = { -- Otherworldly Treasure
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [83191] = { -- Otherworldly Treasure
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [83192] = { -- Otherworldly Treasure
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [83808] = { -- In a Bind
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [83822] = { -- The Fallen Knight
            [questKeys.objectives] = {{{227519,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.preQuestSingle] = {83935},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [83823] = { -- A Lesson in Violence
            [questKeys.startedBy] = {{227673}},
            [questKeys.objectivesText] = {"To accept this quest, summon your squire with Dalton's Horn and fight enemies alongside him."},
            [questKeys.objectives] = {},
            [questKeys.preQuestSingle] = {83936},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [83934] = { -- Show Me The Money!
            [questKeys.zoneOrSort] = zoneIDs.STRANGLETHORN_VALE,
        },
        [83935] = { -- Clearing the Path
            [questKeys.preQuestSingle] = {83935},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [83936] = { -- Dalton's Quest
            [questKeys.objectives] = {{{227672,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.preQuestSingle] = {83822},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84008] = { -- A Lesson in Grace
            [questKeys.startedBy] = {{227464}},
            [questKeys.objectivesText] = {"To accept this quest, summon your squire with Dalton's Horn and fight enemies alongside him."},
            [questKeys.preQuestSingle] = {83823},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84011] = { -- More Star Lotus
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
        },
        [84012] = { -- More Starsilver Ore
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
        },
        [84013] = { -- More Starshells
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = zoneIDs.THE_HINTERLANDS,
        },
        [84014] = { -- More Moonroot
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
        },
        [84015] = { -- More Greater Moonstones
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
        },
        [84016] = { -- More Moondragon Scales
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = zoneIDs.FERALAS,
        },
        [84017] = { -- A Time to Kill
            [questKeys.triggerEnd] = {"Find Arkonos the Cursed",{[zoneIDs.EASTERN_PLAGUELANDS]={{86.8,39.4}}}},
            [questKeys.preQuestSingle] = {84008},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84124] = { -- Legacy of Valor
            [questKeys.startedBy] = {{208841}},
            [questKeys.objectivesText] = {"Achieve five killing blows in a short amount of time, while fighting enemies in the Blackrock Stronghold. Once you get the Rhythm of War buff, /salute at the altar, defeat the Revered Champion and receive the rune."},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [84125] = { -- Close Enough To Touch
            [questKeys.preQuestSingle] = {84017},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84126] = { -- Finish the Fight
            [questKeys.preQuestSingle] = {84125},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84135] = { -- Beach Bot
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [84136] = { -- The Beast Master of Moonglade
            [questKeys.preQuestSingle] = {85521},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [84137] = { -- Mechanical Romance
            [questKeys.objectives] = {},
            [questKeys.preQuestSingle] = {84135},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.extraObjectives] = {{{[zoneIDs.TANARIS]={{53.5,96.5}}}, Questie.ICON_TYPE_EVENT, l10n("Swim south till you reach a small island. You need to use your Guided Buoyancy Accelerant or any other swim speed increase.")}},
        },
        [84138] = { -- Frosty Favors
            [questKeys.preQuestSingle] = {84137},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [84146] = { -- Red Bag Blues
            [questKeys.objectives] = {{{218236}}},
            [questKeys.preQuestSingle] = {84138},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [84147] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84148] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84149] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84150] = { -- An Earnest Proposition
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84151] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84152] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84153] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84154] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84155] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84156] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84157] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84158] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84159] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84160] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84161] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84162] = { -- An Earnest Proposition
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84163] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.preQuestSingle] = {8977},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
            [questKeys.nextQuestInChain] = 8929,
        },
        [84164] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.preQuestSingle] = {8977},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
            [questKeys.nextQuestInChain] = 8929,
        },
        [84165] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.preQuestSingle] = {8977},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
            [questKeys.nextQuestInChain] = 8929,
        },
        [84166] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.preQuestSingle] = {8977},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
            [questKeys.nextQuestInChain] = 8929,
        },
        [84167] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.preQuestSingle] = {8977},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
            [questKeys.nextQuestInChain] = 8929,
        },
        [84168] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.preQuestSingle] = {8977},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
            [questKeys.nextQuestInChain] = 8929,
        },
        [84169] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.preQuestSingle] = {8977},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
            [questKeys.nextQuestInChain] = 8929,
        },
        [84170] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.preQuestSingle] = {8977},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
            [questKeys.nextQuestInChain] = 8929,
        },
        [84171] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.preQuestSingle] = {8978},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
            [questKeys.nextQuestInChain] = 8930,
        },
        [84172] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.preQuestSingle] = {8978},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
            [questKeys.nextQuestInChain] = 8930,
        },
        [84173] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.preQuestSingle] = {8978},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
            [questKeys.nextQuestInChain] = 8930,
        },
        [84174] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.preQuestSingle] = {8978},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
            [questKeys.nextQuestInChain] = 8930,
        },
        [84175] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.preQuestSingle] = {8978},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
            [questKeys.nextQuestInChain] = 8930,
        },
        [84176] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {8978},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
            [questKeys.nextQuestInChain] = 8930,
        },
        [84177] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.preQuestSingle] = {8978},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
            [questKeys.nextQuestInChain] = 8930,
        },
        [84178] = { -- Just Compensation
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.preQuestSingle] = {8978},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
            [questKeys.nextQuestInChain] = 8930,
        },
        [84179] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectives] = {nil,nil,{{226713},{226709},{226710}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84180] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectives] = {nil,nil,{{226722},{226719},{226716}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84181] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectives] = {nil,nil,{{226730},{226727},{226726}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84182] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectives] = {nil,nil,{{226738},{226736},{226735}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84183] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectives] = {nil,nil,{{226743},{226747},{226741}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84184] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectives] = {nil,nil,{{226703},{226705},{226706}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84185] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectives] = {nil,nil,{{226763},{226760},{226756}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84186] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectives] = {nil,nil,{{226764},{226767},{226768}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84187] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectives] = {nil,nil,{{226713},{226709},{226710}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84188] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectives] = {nil,nil,{{226722},{226719},{226716}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84189] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectives] = {nil,nil,{{226730},{226727},{226726}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84190] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectives] = {nil,nil,{{226743},{226747},{226741}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84191] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectives] = {nil,nil,{{226703},{226705},{226706}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84192] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectives] = {nil,nil,{{226752},{226750},{226753}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84193] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectives] = {nil,nil,{{226763},{226760},{226756}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84194] = { -- Anthion's Parting Words
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectives] = {nil,nil,{{226764},{226767},{226768}}},
            [questKeys.preQuestSingle] = {9015},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84195] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.preQuestSingle] = {8997},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84196] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.preQuestSingle] = {8997},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84197] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.preQuestSingle] = {8997},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84198] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.preQuestSingle] = {8997},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84199] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.preQuestSingle] = {8997},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84200] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.preQuestSingle] = {8997},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84201] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.preQuestSingle] = {8997},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84202] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.preQuestSingle] = {8997},
            [questKeys.zoneOrSort] = zoneIDs.IRONFORGE,
        },
        [84203] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.preQuestSingle] = {8998},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84204] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.preQuestSingle] = {8998},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84205] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.preQuestSingle] = {8998},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84206] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.preQuestSingle] = {8998},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84207] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.preQuestSingle] = {8998},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84208] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {8998},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84209] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.preQuestSingle] = {8998},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84210] = { -- Saving the Best for Last
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.preQuestSingle] = {8998},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84211] = { -- Poacher's Den
            [questKeys.preQuestSingle] = {84146},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [84212] = { -- Bookin' it Back
            [questKeys.preQuestSingle] = {84211},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.extraObjectives] = {{{[zoneIDs.TANARIS]={{53.5,96.5}}}, Questie.ICON_TYPE_EVENT, l10n("Swim south till you reach a small island. You need to use your Guided Buoyancy Accelerant or any other swim speed increase.")}},
        },
        [84213] = { -- Rift Away
            [questKeys.preQuestSingle] = {84212},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.extraObjectives] = {
                {nil, Questie.ICON_TYPE_OBJECT, l10n("Teleport to either Westfall (Alliance) or Tirisfal Glades (Horde)."),0,{{"object", 461155}}},
                {nil, Questie.ICON_TYPE_OBJECT, l10n("Form a proper group and click on the Console to summon Harvest Golem V000-A."),0,{{"object", 456918}}},
                {nil, Questie.ICON_TYPE_SLAY, l10n("Keep up Disarm and Demoralizing Shout to greatly reduce the damage of the golem."),0,{{"monster", 212252}}},
                {nil, Questie.ICON_TYPE_SLAY, l10n("Phase 1: Interrupt"),0,{{"monster", 212252}}},
                {nil, Questie.ICON_TYPE_SLAY, l10n("Phase 2: Kite"),0,{{"monster", 212252}}},
                {nil, Questie.ICON_TYPE_SLAY, l10n("Phase 3: Use Shield Wall and survive"),0,{{"monster", 212252}}},
            },
        },
        [84317] = { -- Infinite Midnight
            [questKeys.startedBy] = {{228611}},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [84318] = { -- Oi!
            [questKeys.startedBy] = {{228619,228620}},
            [questKeys.objectives] = {nil,nil,{{227686}}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84319] = { -- Oh No Ye Don't!
            [questKeys.preQuestSingle] = {84318},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84320] = { -- Lost Heirloom
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84321] = { -- Relic of Light
            [questKeys.preQuestSingle] = {84320},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84322] = { -- Scarlet Research
            [questKeys.preQuestSingle] = {84321,84406},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84323] = { -- The Prize Within
            [questKeys.preQuestSingle] = {84322},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84324] = { -- Diplomatic Overtures
            [questKeys.preQuestSingle] = {84323},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84325] = { -- Shrine of Cooperation
            [questKeys.startedBy] = {{228818}},
            [questKeys.objectivesText] = {"To accept this quest, damage a Horde member and heal it with Altruist Ward. Then deliver the crystal to High Priestess Laurena in Stormwind Cathedral."},
            [questKeys.preQuestSingle] = {84324},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84326] = { -- Diplomat Ring
            [questKeys.startedBy] = {{376}},
            [questKeys.preQuestSingle] = {84325},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84327] = { -- A Diplomatic Mission
            [questKeys.startedBy] = {{376}},
            [questKeys.preQuestSingle] = {84326},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84328] = { -- Repairing the Shard
            [questKeys.startedBy] = {{211229}},
            [questKeys.preQuestSingle] = {84327},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84329] = { -- The Convocation Assembles
            [questKeys.startedBy] = {{376,211229}},
            [questKeys.preQuestSingle] = {84328,84413},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84330] = { -- A Wee Bit O' Necromancy
            [questKeys.preQuestSingle] = {84319},
            [questKeys.objectives] = {nil,nil,{{227690}}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84331] = { -- The Miracle
            [questKeys.objectives] = {nil,{{462201}}},
            [questKeys.preQuestSingle] = {84329},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84332] = { -- A Thane's Gratitude
            [questKeys.preQuestSingle] = {84414},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84338] = { -- A Binding Contract
            [questKeys.startedBy] = {nil,nil,{227730}},
            [questKeys.zoneOrSort] = zoneIDs.BLACKROCK_DEPTHS,
            [questKeys.reputationReward] = {{factionIDs.THORIUM_BROTHERHOOD,200}},
        },
        [84235] = { -- Dive! Dive!
            [questKeys.objectives] = {{{229897,nil,Questie.ICON_TYPE_INTERACT}}},
            [questKeys.preQuestSingle] = {84136},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [84348] = { -- Priority Target: Duke Tectonis
            [questKeys.zoneOrSort] = sortKeys.BLACKROCK_ERUPTION,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [84349] = { -- Priority Target: Duke Searbrand
            [questKeys.zoneOrSort] = sortKeys.BLACKROCK_ERUPTION,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [84350] = { -- Grinding Them Down
            [questKeys.zoneOrSort] = sortKeys.BLACKROCK_ERUPTION,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [84351] = { -- Work Smarter, Not Harder
            [questKeys.zoneOrSort] = sortKeys.BLACKROCK_ERUPTION,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [84355] = { -- More Like Lame-bringers!
            [questKeys.zoneOrSort] = sortKeys.BLACKROCK_ERUPTION,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [84356] = { -- Oh, Shiny!
            [questKeys.zoneOrSort] = sortKeys.BLACKROCK_ERUPTION,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [84359] = { -- Sleepless Nights
            [questKeys.sourceItemId] = 227768,
            [questKeys.zoneOrSort] = sortKeys.BLACKROCK_ERUPTION,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [84360] = { -- Firefighting
            [questKeys.zoneOrSort] = sortKeys.BLACKROCK_ERUPTION,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [84369] = { -- Healing the Healer
            [questKeys.triggerEnd] = {"Collect Frostfire Hot Spring water",{[zoneIDs.WINTERSPRING]={{29.3,35.7}}}},
            [questKeys.objectives] = {nil,nil,{{227924}}},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [84372] = { -- Lava Diving
            [questKeys.zoneOrSort] = sortKeys.BLACKROCK_ERUPTION,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [84377] = { -- End of the Dark Horde
            [questKeys.startedBy] = {nil,nil,{227911}},
            [questKeys.finishedBy] = {{332}},
            [questKeys.zoneOrSort] = zoneIDs.STORMWIND_CITY,
        },
        [84384] = { -- Demonic Deceptions
            [questKeys.zoneOrSort] = zoneIDs.WINTERSPRING,
        },
        [84394] = { -- Greater Friend of the Library
            [questKeys.questLevel] = -1,
            [questKeys.preQuestSingle] = {82208},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
            [questKeys.objectivesText] = {"You will need to hand in 35 books to receive the rune, however you can hand 1 in at any time."},
        },
        [84395] = { -- Undead Potatoes
            [questKeys.startedBy] = {nil,{463213}},
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [84396] = { -- Magma or Lava?
            [questKeys.startedBy] = {nil,{463206}},
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [84397] = { -- Northern Kalimdor - A Comprehensive Guide
            [questKeys.startedBy] = {nil,{463209}},
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [84398] = { -- A Study of the Light
            [questKeys.startedBy] = {nil,{463207}},
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [84399] = { -- Ka-Boom!
            [questKeys.startedBy] = {nil,{463214}},
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [84400] = { -- The Knight and the Lady
            [questKeys.startedBy] = {nil,{463208}},
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [84401] = { -- Scourge: Undead Menace or Misunderstood?
            [questKeys.startedBy] = {nil,{463212}},
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [84402] = { -- Necromancy 101
            [questKeys.startedBy] = {nil,{463211}},
            [questKeys.questLevel] = -1,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [84405] = { -- Lost Heirloom
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84406] = { -- Relic of Light
            [questKeys.preQuestSingle] = {84320},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84407] = { -- The Prize Within
            [questKeys.preQuestSingle] = {84406},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84408] = { -- Diplomatic Overtures
            [questKeys.preQuestSingle] = {84407},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84410] = { -- Shrine of Cooperation
            [questKeys.objectivesText] = {"To accept this quest, damage an Alliance member and heal it with Altruist Ward. Then deliver the crystal to Dietrich Praice in Orgrimmar."},
            [questKeys.preQuestSingle] = {84324},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84411] = { -- Diplomat Ring
            [questKeys.preQuestSingle] = {84410},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84412] = { -- A Diplomatic Mission
            [questKeys.preQuestSingle] = {84411},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84413] = { -- Repairing the Shard
            [questKeys.preQuestSingle] = {84412},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84414] = { -- Send Me On Me Way!
            [questKeys.preQuestSingle] = {84330},
            [questKeys.objectives] = {{{228619,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84418] = { -- The Missing Knight
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [84495] = { -- Fiery Plate Gauntlets
            [questKeys.requiredSkill] = {profKeys.BLACKSMITHING,275},
            [questKeys.zoneOrSort] = zoneIDs.WINTERSPRING,
        },
        [84496] = { -- Sweet Serenity
            [questKeys.requiredSkill] = {profKeys.BLACKSMITHING,250},
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
            [questKeys.requiredSpecialization] = specKeys.BLACKSMITHING_WEAPON,
        },
        [84525] = { -- Otherworldly Treasure
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [84545] = { -- A Hero's Reward
            [questKeys.preQuestSingle] = {6824},
            [questKeys.zoneOrSort] = zoneIDs.AZSHARA,
        },
        [84546] = { -- Stave of the Ancients
            [questKeys.preQuestSingle] = {7633},
            [questKeys.objectives] = {nil,nil,{{18952},{18953},{18954},{18955}}},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [84548] = { -- Garona: A Study on Stealth and Treachery
            [questKeys.startedBy] = {nil,nil,{228691}},
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.zoneOrSort] = zoneIDs.DIRE_MAUL,
        },
        [84549] = { -- The Arcanist's Cookbook
            [questKeys.startedBy] = {nil,nil,{228693}},
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.zoneOrSort] = zoneIDs.DIRE_MAUL,
        },
        [84550] = { -- Codex of Defense
            [questKeys.startedBy] = {nil,nil,{228692}},
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.zoneOrSort] = zoneIDs.DIRE_MAUL,
        },
        [84551] = { -- The Light and How To Swing It
            [questKeys.startedBy] = {nil,nil,{228690}},
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.zoneOrSort] = zoneIDs.DIRE_MAUL,
        },
        [84555] = { -- Nostro's Compendium
            [questKeys.startedBy] = {nil,nil,{18401}},
            [questKeys.zoneOrSort] = zoneIDs.DIRE_MAUL,
        },
        [84556] = { -- The Forging of Quel'Serrar
            [questKeys.startedBy] = {nil,nil,{18513}},
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN,
            [questKeys.preQuestSingle] = {84555},
            [questKeys.zoneOrSort] = zoneIDs.STORMWIND_CITY,
        },
        [84557] = { -- The Forging of Quel'Serrar
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN,
            [questKeys.preQuestSingle] = {84556},
            [questKeys.zoneOrSort] = zoneIDs.STORMWIND_CITY,
            [questKeys.reputationReward] = {{factionIDs.SHEN_DRALAR,200}},
        },
        [84560] = { -- Celebrating Good Times
            [questKeys.preQuestSingle] = {7495},
            [questKeys.zoneOrSort] = zoneIDs.STORMWIND_CITY,
        },
        [84561] = { -- For All To See
            [questKeys.preQuestSingle] = {7490},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [84590] = { -- The Balance of Light and Shadow
            [questKeys.triggerEnd] = {"The Balance of Light and Shadow", {[zoneIDs.EASTERN_PLAGUELANDS]={{21.19,17.79}}}},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [84636] = { -- Prowler
            [questKeys.objectives] = {{{230481,nil,Questie.ICON_TYPE_INTERACT}}},
            [questKeys.preQuestSingle] = {84235},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [84777] = { -- Feathers for Nafien
            [questKeys.preQuestSingle] = {8461},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = zoneIDs.FELWOOD,
        },
        [84853] = { -- Tracks in the Snow
            [questKeys.finishedBy] = {nil,{467315}},
            [questKeys.preQuestSingle] = {84636},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [84870] = { -- The Dark Hoard
            [questKeys.startedBy] = {nil,nil,{229352}},
            [questKeys.objectives] = {nil,nil,{{229362}}},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [84880] = { -- The Enemy of my Enemy
            [questKeys.preQuestSingle] = {84870},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [84881] = { -- Into the Hold of Shadows
            [questKeys.startedBy] = {{6707}},
            [questKeys.finishedBy] = {{6706}},
            [questKeys.objectives] = {{{231430}},nil,{{229911}}},
            [questKeys.extraObjectives] = {{{[zoneIDs.FELWOOD]={{35.4,57.8}}}, Questie.ICON_TYPE_EVENT, l10n("Find Caius Blackwood")}},
            [questKeys.preQuestSingle] = {84880},
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [84950] = { -- Out in the Cold
            [questKeys.startedBy] = {nil,{467315}},
            [questKeys.preQuestSingle] = {84853},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
            [questKeys.extraObjectives] = {{{[zoneIDs.WINTERSPRING]={{58,21}}}, Questie.ICON_TYPE_EVENT, l10n("Use your Survival Supplies")}},
        },
        [85034] = { -- The Ruins of Andorhal
            [questKeys.preQuestSingle] = {85455},
            [questKeys.objectives] = {nil,{{478062}}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85457,
        },
        [85061] = { -- Bug Hunt
            [questKeys.preQuestSingle] = {84950},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [85063] = { -- Culmination
            [questKeys.objectives] = {{{232929,nil,Questie.ICON_TYPE_EVENT}}},
            [questKeys.preQuestSingle] = {85458},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85064,
        },
        [85064] = { -- Worst Case Scenario
            [questKeys.finishedBy] = {{231500}},
            [questKeys.preQuestSingle] = {85063},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85065,
        },
        [85065] = { -- A Most Curious Gnome
            [questKeys.preQuestSingle] = {85064},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85066,
        },
        [85066] = { -- Making Ready
            [questKeys.preQuestSingle] = {85065},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85067,
        },
        [85067] = { -- A Paladin of the Silver Hand
            [questKeys.objectives] = {{{231498,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.preQuestSingle] = {85066},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85068,
        },
        [85068] = { -- Who Says You Can Never Go Back?
            [questKeys.preQuestSingle] = {85067},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85074,
        },
        [85074] = { -- The Burning of Andorhal
            [questKeys.preQuestSingle] = {85068},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85087,
        },
        [85087] = { -- A Desperate Escape
            [questKeys.preQuestSingle] = {85074},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85090,
        },
        [85090] = { -- Back to the Future
            [questKeys.preQuestSingle] = {85087},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85091,
        },
        [85091] = { -- The Cost of Victory
            [questKeys.preQuestSingle] = {85090},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85092,
        },
        [85092] = { -- Truthbearer
            [questKeys.preQuestSingle] = {85091},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [85112] = { -- The Depleted Scythe
            [questKeys.startedBy] = {nil,nil,{231722}},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [85150] = { -- The Only Good Bug is a Dead Bug
            [questKeys.preQuestSingle] = {85061},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [85248] = { -- Everyone Knows That Bugs Can't Fly
            [questKeys.objectives] = {{{231984,nil,Questie.ICON_TYPE_INTERACT}}},
            [questKeys.preQuestSingle] = {85150},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [85250] = { -- Meeting the Menagerie
            [questKeys.preQuestSingle] = {85248},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [85251] = { -- Showdown at Un'Goro Crater
            [questKeys.preQuestSingle] = {85250},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [85304] = { -- Essence of Fire
            [questKeys.startedBy] = {nil,nil,{230904}},
            [questKeys.triggerEnd] = {"Translate the scroll", {[zoneIDs.BURNING_STEPPES]={{14.8,56.7}}}},
            [questKeys.objectives] = {{{232429},{232429},{232398}},nil,{{230908}}},
            [questKeys.nextQuestInChain] = 85385,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [85385] = { -- The Librarian's Apprentice
            [questKeys.startedBy] = {{5497,7825}},
            [questKeys.preQuestSingle] = {85304},
            [questKeys.nextQuestInChain] = 85386,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [85386] = { -- Essence of Frost
            [questKeys.triggerEnd] = {"Translate the scroll", {[zoneIDs.WINTERSPRING]={{63.3,68.4}}}},
            [questKeys.objectives] = {{{232466},{232466},{232399}},nil,{{230948}}},
            [questKeys.preQuestSingle] = {85385},
            [questKeys.nextQuestInChain] = 85388,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [85388] = { -- A Foul Interference
            [questKeys.startedBy] = {{232381}},
            [questKeys.objectives] = {{{232534},{232532},{10929}}},
            [questKeys.preQuestSingle] = {85386},
            [questKeys.requiredSourceItems] = {231304,231298},
            [questKeys.zoneOrSort] = sortKeys.MAGE,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_INTERACT, l10n("Use Scroll of Lesser Spatial Mending"), 0, {{"monster", 232538}}}},
        },
        [85401] = { -- The Frigid Barrow
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [85441] = { -- Thunderaan the Windseeker
            [questKeys.preQuestSingle] = {85442},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
        },
        [85442] = { -- Examine the Vessel
            [questKeys.startedBy] = {{14347},nil,{19016}},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
        },
        [85443] = { -- Rise, Thunderfury!
            [questKeys.startedBy] = {nil,nil,{232018}},
            [questKeys.preQuestSingle] = {85441},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
        },
        [85445] = { -- The Golden Disk
            [questKeys.startedBy] = {nil,nil,{231378}},
            [questKeys.objectives] = {{{2888,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.nextQuestInChain] = 85447,
        },
        [85446] = { -- Scale of the Dragon Lord
            [questKeys.objectives] = {{{11583}},nil,{{231386},{232414}}},
            [questKeys.preQuestSingle] = {85447},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.nextQuestInChain] = 85453,
        },
        [85447] = { -- Grim Batol
            [questKeys.preQuestSingle] = {85445},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.nextQuestInChain] = 85446,
        },
        [85453] = { -- No Good Deed Goes Unpunished
            [questKeys.startedBy] = {{232596}},
            [questKeys.preQuestSingle] = {85446},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
            [questKeys.nextQuestInChain] = 85454,
            [questKeys.extraObjectives] = {{{[zoneIDs.WETLANDS]={{74.4,70.5}}}, Questie.ICON_TYPE_EVENT, l10n("Fight Riosustrasz near the edge")}},
        },
        [85454] = { -- A Just Reward
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.objectives] = {{{232626,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.preQuestSingle] = {85453},
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [85455] = { -- The Blood of the Lightbringer
            [questKeys.startedBy] = {nil,nil,{231452}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85034,
        },
        [85457] = { -- Just What Was Needed
            [questKeys.preQuestSingle] = {85034},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85458,
        },
        [85458] = { -- Darkwhisper Gorge
            [questKeys.preQuestSingle] = {85457},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
            [questKeys.nextQuestInChain] = 85063,
        },
        [85468] = { -- Soul of Mischief
            [questKeys.objectives] = {{{232731,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.preQuestSingle] = {85112},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_INTERACT, l10n("Place Suspicious Supplies on the bone piles"), 0, {{"object", 600000}}}},
        },
        [85480] = { -- Procrastimond's Gratitude
            [questKeys.objectivesText] = {"You are a remarkable mortal, little one. The gift of foresight is not common among your kind.I must warn you, though. Such knowledge can influence events, even unintentionally. It is quite possible your future will take a different path than the one written in my library.I found this book which does not appear to belong in my collection. Please accept it, with my thanks.\n\nNOTE: You need to use \"Tarnished Bronze Scale\" in Tanaris, which is dropped by Chromaggus to get to Procrastimond."},
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [85485] = { -- Soul of the Void
            [questKeys.objectives] = {nil,nil,{{231797}}},
            [questKeys.preQuestSingle] = {85468},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [85486] = { -- Soul of Enthralling
            [questKeys.objectives] = {nil,nil,{{231798}}},
            [questKeys.requiredSourceItems] = {231836},
            [questKeys.preQuestSingle] = {85485},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [85501] = { -- The Heart of Chromaggus
            [questKeys.startedBy] = {nil,nil,{231814}},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [85505] = { -- Soul of Devouring
            [questKeys.objectives] = {nil,nil,{{231799}}},
            [questKeys.requiredSourceItems] = {231837},
            [questKeys.preQuestSingle] = {85486},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [85506] = { -- The Final Test
            [questKeys.objectives] = {{{232924,nil,Questie.ICON_TYPE_TALK}},nil,{{231800}}},
            [questKeys.preQuestSingle] = {85505},
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [85507] = { -- Our Wayward Friend
            [questKeys.objectives] = {{{231498,nil,Questie.ICON_TYPE_EVENT}}},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [85508] = { -- Our Wayward Friend
            [questKeys.objectives] = {{{231498,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.preQuestSingle] = {85507},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [85509] = { -- Grand Theft Echoing Orb
            [questKeys.objectives] = {{{217980,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.preQuestSingle] = {85508},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [85510] = { -- A Solid Lead
            [questKeys.preQuestSingle] = {85509},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [85511] = { -- Plaguelands Rendezvous
            [questKeys.objectives] = {{{232912,nil,Questie.ICON_TYPE_EVENT}}},
            [questKeys.preQuestSingle] = {85510},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [85521] = { -- Tracking the Trapper
            [questKeys.startedBy] = {{10429}},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [85525] = { -- One Night in Winterspring
            [questKeys.objectives] = {nil,{{469600}},{{12622},{229416}}},
            [questKeys.preQuestSingle] = {84950},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [85555] = { -- Heavy Metal
            [questKeys.startedBy] = {nil,nil,{231995}},
            [questKeys.nextQuestInChain] = 85556,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [85556] = { -- A Particular Set of Skills
            [questKeys.preQuestSingle] = {85555},
            [questKeys.requiredSourceItems] = {231996},
            [questKeys.nextQuestInChain] = 85557,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [85557] = { -- Efficiency Is Priority One
            [questKeys.preQuestSingle] = {85556},
            [questKeys.nextQuestInChain] = 85558,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [85558] = { -- Commit to Quality
            [questKeys.startedBy] = {{14401}},
            [questKeys.preQuestSingle] = {85557},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [85559] = { -- Night Falls
            [questKeys.preQuestSingle] = {85251},
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [85595] = { -- Presence of Might
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,3000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,250}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85596] = { -- Death's Embrace
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,3000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85597] = { -- Falcon's Call
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,3000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85598] = { -- Prophetic Aura
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,3000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85599] = { -- Hoodoo Hex
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,3000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85600] = { -- Presence of Sight
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,3000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,250}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85601] = { -- Syncretist's Sigil
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,3000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,250}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85602] = { -- Animist's Caress
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,3000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,250}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85603] = { -- Vodouisant's Vigilant Embrace
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,3000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85604] = { -- The Unmarred Vision of Voodress
            [questKeys.startedBy] = {{14904}},
            [questKeys.finishedBy] = {{14904}},
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.preQuestSingle] = {8118},
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,42000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85605] = { -- Paragons of Power: The Augur's Bracers
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85606] = { -- Paragons of Power: The Augur's Belt
            [questKeys.finishedBy] = {{14904}},
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85607] = { -- Paragons of Power: The Augur's Hauberk
            [questKeys.finishedBy] = {{14904}},
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85608] = { -- Pristine Enchanted South Seas Kelp
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.preQuestSingle] = {8112},
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,42000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85609] = { -- Paragons of Power: The Haruspex's Bracers
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85610] = { -- Paragons of Power: The Haruspex's Belt
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85611] = { -- Paragons of Power: The Haruspex's Tunic
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85612] = { -- The Rage of Mugamba
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.preQuestSingle] = {8043},
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,42000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85613] = { -- Paragons of Power: The Vindicator's Armguards
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85614] = { -- Paragons of Power: The Vindicator's Belt
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85615] = { -- Paragons of Power: The Vindicator's Breastplate
            [questKeys.finishedBy] = {{14902}},
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85616] = { -- The All-Seeing Eye of Zuldazar
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.preQuestSingle] = {8051},
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,42000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85617] = { -- The Hero's Brand
            [questKeys.startedBy] = {{14902}},
            [questKeys.finishedBy] = {{14902}},
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.preQuestSingle] = {8047},
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,42000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85618] = { -- Paragons of Power: The Freethinker's Armguards
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85619] = { -- Paragons of Power: The Freethinker's Belt
            [questKeys.finishedBy] = {{14902}},
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85620] = { -- Paragons of Power: The Freethinker's Breastplate
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85622] = { -- Paragons of Power: The Confessor's Wraps
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85623] = { -- Paragons of Power: The Confessor's Bindings
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85624] = { -- Paragons of Power: The Confessor's Mantle
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85625] = { -- Kezan's Unstoppable Taint
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.preQuestSingle] = {8108},
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,42000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85626] = { -- Paragons of Power: The Demoniac's Wraps
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85627] = { -- Paragons of Power: The Demoniac's Mantle
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85628] = { -- Paragons of Power: The Demoniac's Robes
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85629] = { -- The Jewel of Kajaro
            [questKeys.startedBy] = {{14903}},
            [questKeys.finishedBy] = {{14903}},
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.preQuestSingle] = {8103},
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,42000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85630] = { -- Paragons of Power: The Illusionist's Wraps
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85631] = { -- Paragons of Power: The Illusionist's Mantle
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85632] = { -- Paragons of Power: The Illusionist's Robes
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85633] = { -- Zandalarian Shadow Mastery Talisman
            [questKeys.startedBy] = {{14905}},
            [questKeys.finishedBy] = {{14905}},
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.preQuestSingle] = {8143},
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,42000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85634] = { -- Paragons of Power: The Madcap's Bracers
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85635] = { -- Paragons of Power: The Madcap's Mantle
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85636] = { -- Paragons of Power: The Madcap's Tunic
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85637] = { -- Maelstrom's Wrath
            [questKeys.startedBy] = {{14905}},
            [questKeys.finishedBy] = {{14905}},
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.preQuestSingle] = {8147},
            [questKeys.requiredMinRep] = {factionIDs.ZANDALAR_TRIBE,42000},
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,100}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85638] = { -- Paragons of Power: The Predator's Bracers
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85639] = { -- Paragons of Power: The Predator's Belt
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85640] = { -- Paragons of Power: The Predator's Mantle
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,150}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85643] = { -- The Lord of Blackrock
            [questKeys.preQuestSingle] = {7781},
            [questKeys.zoneOrSort] = zoneIDs.STORMWIND_CITY,
        },
        [85644] = { -- The Lord of Blackrock
            [questKeys.preQuestSingle] = {7783},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [85658] = { -- For All To See
            [questKeys.preQuestSingle] = {84561},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [85659] = { -- Celebrating Good Times
            [questKeys.preQuestSingle] = {84560},
            [questKeys.zoneOrSort] = zoneIDs.STORMWIND_CITY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [85660] = { -- The Heart of Hakkar
            [questKeys.startedBy] = {nil,nil,{19802}},
            [questKeys.zoneOrSort] = zoneIDs.ZUL_GURUB,
        },
        [85699] = { -- Snakestone of the Shadow Huntress
            [questKeys.requiredSkill] = {profKeys.BLACKSMITHING,250},
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
            [questKeys.requiredSpecialization] = specKeys.BLACKSMITHING_WEAPON,
        },
        [85700] = { -- Corruption
            [questKeys.requiredSkill] = {profKeys.BLACKSMITHING,250},
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
            [questKeys.requiredSpecialization] = specKeys.BLACKSMITHING_WEAPON,
        },
        [85701] = { -- Dragonscale Leatherworking
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,225},
            [questKeys.zoneOrSort] = sortKeys.LEATHERWORKING,
        },
        [85702] = { -- Dragonscale Leatherworking
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,225},
            [questKeys.zoneOrSort] = sortKeys.LEATHERWORKING,
        },
        [85703] = { -- Elemental Leatherworking
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,225},
            [questKeys.zoneOrSort] = sortKeys.LEATHERWORKING,
        },
        [85704] = { -- Elemental Leatherworking
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,225},
            [questKeys.zoneOrSort] = sortKeys.LEATHERWORKING,
        },
        [85705] = { -- Tribal Leatherworking
            [questKeys.exclusiveTo] = {5143},
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,225},
            [questKeys.zoneOrSort] = sortKeys.LEATHERWORKING,
        },
        [85706] = { -- Tribal Leatherworking
            [questKeys.exclusiveTo] = {5148},
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,225},
            [questKeys.zoneOrSort] = sortKeys.LEATHERWORKING,
        },
        [85712] = { -- The Art of the Armorsmith
            [questKeys.startedBy] = {{11177}},
            [questKeys.finishedBy] = {{11177}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredSkill] = {profKeys.BLACKSMITHING,200},
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
        },
        [85713] = { -- The Art of the Armorsmith
            [questKeys.finishedBy] = {{5164}},
            [questKeys.requiredSkill] = {profKeys.BLACKSMITHING,200},
            [questKeys.zoneOrSort] = sortKeys.BLACKSMITHING,
        },
        [85772] = { -- Elemental Distress
            [questKeys.startedBy] = {{12736}},
            [questKeys.objectives] = {nil,nil,{{210668},{210667},{210665}}},
            [questKeys.preQuestSingle] = {78920},
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [85798] = { -- Arms for the Field
            [questKeys.startedBy] = {nil,nil,{21260}},
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
        },
        [85882] = { -- End of the Dark Horde
            [questKeys.startedBy] = {{10429}},
            [questKeys.preQuestSingle] = {84377},
            [questKeys.zoneOrSort] = zoneIDs.STORMWIND_CITY,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [85883] = { -- For The Horde!
            [questKeys.startedBy] = {{4949}},
            [questKeys.preQuestSingle] = {4974},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [85963] = { -- One Commendation Signet
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,5}},
        },
        [85964] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,75}},
        },
        [85965] = { -- One Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,75}},
        },
        [85966] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,75}},
        },
        [85967] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,75}},
        },
        [85968] = { -- One Commendation Signet
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,5}},
        },
        [85969] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,75}},
        },
        [85970] = { -- One Commendation Signet
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,5}},
        },
        [85971] = { -- One Commendation Signet
            [questKeys.startedBy] = {{13278}},
            [questKeys.finishedBy] = {{13278}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.HYDRAXIAN_WATERLORDS,5}},
        },
        [85972] = { -- One Commendation Signet
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.HYDRAXIAN_WATERLORDS,5}},
        },
        [85973] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.HYDRAXIAN_WATERLORDS,75}},
        },
        [85974] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.HYDRAXIAN_WATERLORDS,75}},
        },
        [85975] = { -- One Commendation Signet
            [questKeys.startedBy] = {{14625}},
            [questKeys.finishedBy] = {{14625}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.THORIUM_BROTHERHOOD,5}},
        },
        [85976] = { -- Ten Commendation Signets
            [questKeys.startedBy] = {{14625}},
            [questKeys.finishedBy] = {{14625}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.THORIUM_BROTHERHOOD,75}},
        },
        [85977] = { -- One Commendation Signet
            [questKeys.startedBy] = {{14625}},
            [questKeys.finishedBy] = {{14625}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.THORIUM_BROTHERHOOD,5}},
        },
        [85978] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.THORIUM_BROTHERHOOD,75}},
        },
        [85979] = { -- One Commendation Signet
            [questKeys.startedBy] = {{2496}},
            [questKeys.finishedBy] = {{2496}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.STEAMWHEEDLE_CARTEL,5}},
        },
        [85980] = { -- One Commendation Signet
            [questKeys.startedBy] = {{2496}},
            [questKeys.finishedBy] = {{2496}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.STEAMWHEEDLE_CARTEL,5}},
        },
        [85981] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.STEAMWHEEDLE_CARTEL,75}},
        },
        [85982] = { -- Ten Commendation Signets
            [questKeys.startedBy] = {{2496}},
            [questKeys.finishedBy] = {{2496}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.STEAMWHEEDLE_CARTEL,75}},
        },
        [85983] = { -- One Commendation Signet
            [questKeys.startedBy] = {{14910}},
            [questKeys.finishedBy] = {{14910}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,5}},
        },
        [85984] = { -- One Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,5}},
        },
        [85985] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,75}},
        },
        [85986] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ZANDALAR_TRIBE,75}},
        },
        [85987] = { -- One Commendation Signet
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.TIMBERMAW_HOLD,5}},
        },
        [85988] = { -- Ten Commendation Signets
            [questKeys.startedBy] = {{15395}},
            [questKeys.finishedBy] = {{15395}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.TIMBERMAW_HOLD,5}},
        },
        [86160] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.TIMBERMAW_HOLD,75}},
        },
        [86161] = { -- Ten Commendation Signets
            [questKeys.zoneOrSort] = sortKeys.REPUTATION,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.TIMBERMAW_HOLD,75}},
        },
        [86326] = { -- Desert Power
            [questKeys.startedBy] = {{234539}},
            [questKeys.finishedBy] = {{234539}},
            [questKeys.objectives] = {{{234539,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.zoneOrSort] = zoneIDs.AHN_QIRAJ,
        },
        [86442] = { -- Nefarius's Corruption
            [questKeys.preQuestSingle] = {8555},
            [questKeys.zoneOrSort] = zoneIDs.BLACKWING_LAIR,
            [questKeys.requiredMinRep] = {factionIDs.BROOD_OF_NOZDORMU,0},
            [questKeys.reputationReward] = {{factionIDs.BROOD_OF_NOZDORMU,200}},
        },
        [86443] = { -- The Nightmare Manifests
            [questKeys.startedBy] = {{11832}},
            [questKeys.finishedBy] = {{11832}},
            [questKeys.triggerEnd] = {"The Redemption of Eranikus", {[zoneIDs.MOONGLADE]={{51.8,36.4}}}},
            [questKeys.preQuestSingle] = {8735},
            [questKeys.zoneOrSort] = zoneIDs.BLACKWING_LAIR,
            [questKeys.requiredMinRep] = {factionIDs.BROOD_OF_NOZDORMU,0},
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,100},{factionIDs.BROOD_OF_NOZDORMU,100}},
        },
        [86444] = { -- The Only Prescription
            [questKeys.preQuestSingle] = {8606},
            [questKeys.sourceItemId] = 21112,
            [questKeys.requiredSourceItems] = {21103,21104,21105,21106,21107,21108,21109,21110},
            [questKeys.zoneOrSort] = zoneIDs.TANARIS,
            [questKeys.requiredMinRep] = {factionIDs.BROOD_OF_NOZDORMU,0},
            [questKeys.reputationReward] = {{factionIDs.BROOD_OF_NOZDORMU,150}},
        },
        [86445] = { -- The Wrath of Neptulon
            [questKeys.startedBy] = {{11811}},
            [questKeys.preQuestSingle] = {8728},
            [questKeys.zoneOrSort] = zoneIDs.AZSHARA,
            [questKeys.requiredMinRep] = {factionIDs.BROOD_OF_NOZDORMU,0},
            [questKeys.reputationReward] = {{factionIDs.BROOD_OF_NOZDORMU,200}},
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_EVENT, l10n("Use Arcanite Buoy"),0,{{"object", 180669}}}},
        },
        [86449] = { -- Treasure of the Timeless One
            [questKeys.preQuestSingle] = {8742},
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
            [questKeys.requiredMinRep] = {factionIDs.BROOD_OF_NOZDORMU,0},
            [questKeys.reputationReward] = {{factionIDs.BROOD_OF_NOZDORMU,200}},
        },
        [86670] = { -- The Savior of Kalimdor
            [questKeys.startedBy] = {{15379}},
            [questKeys.finishedBy] = {{15192}},
            [questKeys.preQuestSingle] = {8801},
            [questKeys.zoneOrSort] = zoneIDs.AHN_QIRAJ,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,200},{factionIDs.BROOD_OF_NOZDORMU,1000}},
        },
        [86671] = { -- Imperial Qiraji Regalia
            [questKeys.startedBy] = {{15378}},
            [questKeys.finishedBy] = {{15378}},
            [questKeys.zoneOrSort] = zoneIDs.AHN_QIRAJ,
        },
        [86672] = { -- Imperial Qiraji Armaments
            [questKeys.startedBy] = {{15378}},
            [questKeys.finishedBy] = {{15378}},
            [questKeys.zoneOrSort] = zoneIDs.AHN_QIRAJ,
        },
        [86673] = { -- The Fall of Ossirian
            [questKeys.startedBy] = {nil,nil,{21220}},
            [questKeys.finishedBy] = {{15181}},
            [questKeys.zoneOrSort] = zoneIDs.RUINS_OF_AHN_QIRAJ,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,200},{factionIDs.BROOD_OF_NOZDORMU,200}},
        },
        [86675] = { -- Volunteer's Battlegear
            [questKeys.startedBy] = {{15176}},
            [questKeys.finishedBy] = {{15176}},
            [questKeys.preQuestSingle] = {8800},
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
            [questKeys.reputationReward] = {{factionIDs.BROOD_OF_NOZDORMU,50}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [86674] = { -- The Perfect Poison
            [questKeys.finishedBy] = {{16091}},
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,100}},
        },
        [86676] = { -- Veteran's Battlegear
            [questKeys.preQuestSingle] = {8800},
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
            [questKeys.reputationReward] = {{factionIDs.BROOD_OF_NOZDORMU,50}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [86677] = { -- Stalwart's Battlegear
            [questKeys.startedBy] = {{15176}},
            [questKeys.preQuestSingle] = {8800},
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
            [questKeys.reputationReward] = {{factionIDs.BROOD_OF_NOZDORMU,50}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [86678] = { -- Champion's Battlegear
            [questKeys.startedBy] = {{15176}},
            [questKeys.preQuestSingle] = {8800},
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
            [questKeys.reputationReward] = {{factionIDs.BROOD_OF_NOZDORMU,50}},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [86679] = { -- Shrouded in Nightmare
            [questKeys.startedBy] = {{14887,14888,14889,14890},nil,{20644}},
            [questKeys.finishedBy] = {{11832}},
            [questKeys.zoneOrSort] = sortKeys.EPIC,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,200}},
        },
        [86680] = { -- Waking Legends
            [questKeys.triggerEnd] = {"Waking Legends.",{[zoneIDs.MOONGLADE]={{40.0,48.6}}}},
            [questKeys.preQuestSingle] = {86679},
            [questKeys.zoneOrSort] = sortKeys.EPIC,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,200}},
        },
        [86724] = { -- Dust to Dust
            [questKeys.objectives] = {{{18199,nil,Questie.ICON_TYPE_EVENT}}},
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,100}},
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_OBJECT, l10n("Silithyst"),0,{{"object", 181597},{"object", 181598}}}},
        },
        [86725] = { -- Dust to Dust
            [questKeys.objectives] = {{{17090,nil,Questie.ICON_TYPE_EVENT}}},
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
            [questKeys.reputationReward] = {{factionIDs.CENARION_CIRCLE,100}},
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_OBJECT, l10n("Silithyst"),0,{{"object", 181597},{"object", 181598}}}},
        },
        [86760] = { -- Darkmoon Beast Deck
            [questKeys.startedBy] = {nil,nil,{235278}},
            [questKeys.finishedBy] = {{14847}},
            [questKeys.objectives] = {nil,nil,{{235278}}},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE,150}},
        },
        [86761] = { -- Darkmoon Warlords Deck
            [questKeys.startedBy] = {nil,nil,{235277}},
            [questKeys.finishedBy] = {{14847}},
            [questKeys.objectives] = {nil,nil,{{235277}}},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE,150}},
        },
        [86762] = { -- Darkmoon Elementals Deck
            [questKeys.startedBy] = {nil,nil,{235276}},
            [questKeys.finishedBy] = {{14847}},
            [questKeys.objectives] = {nil,nil,{{235276}}},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE,150}},
        },
        [86763] = { -- Darkmoon Portals Deck
            [questKeys.startedBy] = {nil,nil,{235275}},
            [questKeys.finishedBy] = {{14847}},
            [questKeys.objectives] = {nil,nil,{{235275}}},
            [questKeys.zoneOrSort] = sortKeys.DARKMOON_FAIRE,
            [questKeys.reputationReward] = {{factionIDs.DARKMOON_FAIRE,150}},
        },
        [86964] = { -- For Gold and Glory!
            [questKeys.startedBy] = {nil,{600001}},
            [questKeys.finishedBy] = {{237820}},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [86965] = { -- No Ordinary Shadows
            [questKeys.startedBy] = {{237820}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.preQuestSingle] = {86964},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [86966] = { -- Seeking Survivors
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{237819}},
            [questKeys.triggerEnd] = {"Search for any survivor of the unfortunate adventuring party", {[zoneIDs.DEADWIND_PASS]={{65.43,78.64}}}},
            [questKeys.preQuestSingle] = {86965},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [86967] = { -- To the Rescue
            [questKeys.startedBy] = {{237819}},
            [questKeys.finishedBy] = {{237818}},
            [questKeys.objectives] = {nil,{{424003}}},
            [questKeys.preQuestSingle] = {86966},
            [questKeys.requiredSourceItems] = {235785},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [86968] = { -- Are You Afraid of the Dark?
            [questKeys.startedBy] = {{237818}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.objectives] = {{{237818,nil,Questie.ICON_TYPE_EVENT}}},
            [questKeys.preQuestSingle] = {86967},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [86969] = { -- The Hypothesis
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.objectives] = {nil,nil,{{235789},{235787},{235788}}},
            [questKeys.sourceItemId] = 236002,
            [questKeys.preQuestSingle] = {86968},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [86970] = { -- Testing Our Hypothesis
            [questKeys.startedBy] = {{218920}},
            [questKeys.finishedBy] = {{218920}},
            [questKeys.triggerEnd] = {"Test the magical torch", {[zoneIDs.DEADWIND_PASS]={{39.99,74.16}}}},
            [questKeys.objectives] = {},
            [questKeys.sourceItemId] = 235790,
            [questKeys.preQuestSingle] = {86969},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [86971] = { -- Curious Karazhan Curios!
            [questKeys.startedBy] = {{237818}},
            [questKeys.finishedBy] = {{237818}},
            [questKeys.preQuestSingle] = {86970},
            [questKeys.zoneOrSort] = zoneIDs.KARAZHAN_CRYPTS,
        },
        [86972] = { -- Curious Karazhan Curios!
            [questKeys.startedBy] = {{237818}},
            [questKeys.preQuestSingle] = {86971},
            [questKeys.zoneOrSort] = zoneIDs.KARAZHAN_CRYPTS,
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [87283] = { -- The Violet Satchel
            [questKeys.startedBy] = {nil,nil,{235852}},
            [questKeys.finishedBy] = {{16381}},
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [87360] = { -- The Fall of Kel'Thuzad
            [questKeys.startedBy] = {nil,nil,{236350}},
            [questKeys.finishedBy] = {{16113}},
            [questKeys.zoneOrSort] = zoneIDs.NAXXRAMAS,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,200}},
        },
        [87361] = { -- Laid to Rest
            [questKeys.startedBy] = {nil,nil,{236750}},
            [questKeys.finishedBy] = {{238376}},
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,200}},
        },
        [87362] = { -- Hope Begins in the Dark
            [questKeys.startedBy] = {{238382}},
            [questKeys.finishedBy] = {{238382}},
            [questKeys.zoneOrSort] = zoneIDs.NAXXRAMAS,
        },
        [87364] = { -- Seal the Deal
            [questKeys.startedBy] = {{238382}},
            [questKeys.finishedBy] = {{238382}},
            [questKeys.preQuestSingle] = {87362},
            [questKeys.zoneOrSort] = zoneIDs.NAXXRAMAS,
        },
        [87365] = { -- Valor Grows by Daring
            [questKeys.preQuestSingle] = {87364},
            [questKeys.zoneOrSort] = zoneIDs.NAXXRAMAS,
        },
        [87366] = { -- Knight Time
            [questKeys.preQuestSingle] = {87365},
            [questKeys.zoneOrSort] = zoneIDs.NAXXRAMAS,
        },
        [87367] = { -- A New Light
            [questKeys.preQuestSingle] = {87366},
            [questKeys.zoneOrSort] = zoneIDs.NAXXRAMAS,
        },
        [87368] = { -- A Product of Faith
            [questKeys.preQuestSingle] = {87367},
            [questKeys.zoneOrSort] = zoneIDs.NAXXRAMAS,
        },
        [87369] = { -- Cultivating Faith
            [questKeys.preQuestSingle] = {87368},
            [questKeys.zoneOrSort] = zoneIDs.NAXXRAMAS,
        },
        [87377] = { -- Never at Rest
            [questKeys.startedBy] = {{238376}},
            [questKeys.finishedBy] = {{238376}},
            [questKeys.preQuestSingle] = {87361},
            [questKeys.exclusiveTo] = {88713,88714,88715,88716,88717,88718},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [87433] = { -- Argent Dawn Plate Gloves
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN,
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [87434] = { -- Argent Dawn Plate Gloves
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN,
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [87435] = { -- Argent Dawn Mail Gloves
            [questKeys.requiredClasses] = classIDs.HUNTER + classIDs.SHAMAN + classIDs.WARRIOR + classIDs.PALADIN,
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [87436] = { -- Argent Dawn Mail Gloves
            [questKeys.requiredClasses] = classIDs.HUNTER + classIDs.SHAMAN + classIDs.WARRIOR + classIDs.PALADIN,
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [87437] = { -- Argent Dawn Leather Gloves
            [questKeys.requiredClasses] = classIDs.ROGUE + classIDs.DRUID + classIDs.HUNTER + classIDs.SHAMAN + classIDs.WARRIOR + classIDs.PALADIN,
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [87438] = { -- Argent Dawn Leather Gloves
            [questKeys.requiredClasses] = classIDs.ROGUE + classIDs.DRUID + classIDs.HUNTER + classIDs.SHAMAN + classIDs.WARRIOR + classIDs.PALADIN,
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [87439] = { -- Argent Dawn Cloth Gloves
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [87440] = { -- Argent Dawn Cloth Gloves
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [87441] = { -- Atiesh, Greatstaff of the Guardian
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.preQuestSingle] = {9251},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
        },
        [87442] = { -- Atiesh, Greatstaff of the Guardian
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.preQuestSingle] = {9251},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
        },
        [87443] = { -- Atiesh, Greatstaff of the Guardian
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.preQuestSingle] = {9251},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
        },
        [87444] = { -- Atiesh, Greatstaff of the Guardian
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.preQuestSingle] = {9251},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
        },
        [87459] = { -- Scarlet Activities
            [questKeys.preQuestSingle] = {9121,9122,9123},
            [questKeys.nextQuestInChain] = 87493,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [87493] = { -- Unrest at Tyr's Hand
            [questKeys.preQuestSingle] = {87459},
            [questKeys.nextQuestInChain] = 87497,
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
        },
        [87497] = { -- The Schism
            [questKeys.objectives] = {{{239032,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.preQuestSingle] = {87493},
            [questKeys.nextQuestInChain] = 87498,
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
        },
        [87498] = { -- The Scarlet Reclamation
            [questKeys.preQuestSingle] = {87497},
            [questKeys.nextQuestInChain] = 87502,
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
        },
        [87502] = { -- Gathering Intelligence
            [questKeys.objectives] = {{{239154,nil,Questie.ICON_TYPE_EVENT},{239152,nil,Questie.ICON_TYPE_EVENT},{239153,nil,Questie.ICON_TYPE_EVENT}}},
            [questKeys.preQuestSingle] = {87498},
            [questKeys.nextQuestInChain] = 87506,
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_TALK, l10n("Talk to Inquisitor Jociphine to get a disguise"),0,{{"monster", 243023}}}},
        },
        [87506] = { -- Weakening The Defenses
            [questKeys.preQuestSingle] = {87502},
            [questKeys.nextQuestInChain] = 87508,
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
        },
        [87508] = { -- Report to Lord Tyrosus
            [questKeys.objectives] = {{{11034,nil,Questie.ICON_TYPE_EVENT}}},
            [questKeys.preQuestSingle] = {87506},
            [questKeys.nextQuestInChain] = 87509,
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
        },
        [87509] = { -- The Wrath of the Dawn
            [questKeys.objectives] = {{{239032,nil,Questie.ICON_TYPE_EVENT}}},
            [questKeys.preQuestSingle] = {87508},
            [questKeys.nextQuestInChain] = 87516,
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
        },
        [87516] = { -- Decapitation Strike
            [questKeys.objectives] = {{{240811}}},
            [questKeys.preQuestSingle] = {87509},
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
        },
        [87517] = { -- Red = Dead
            [questKeys.preQuestSingle] = {87516},
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
        },
        [87518] = { -- Fall of the Grand Crusader
            [questKeys.finishedBy] = {{239337}},
            [questKeys.preQuestSingle] = {87517},
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
        },
        [88654] = { -- A Full Shipment
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
        },
        [88713] = { -- Never at Rest
            [questKeys.preQuestSingle] = {87361},
            [questKeys.exclusiveTo] = {87377,88714,88715,88716,88717,88718},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88714] = { -- Never at Rest
            [questKeys.preQuestSingle] = {87361},
            [questKeys.exclusiveTo] = {87377,88713,88715,88716,88717,88718},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88715] = { -- Never at Rest
            [questKeys.preQuestSingle] = {87361},
            [questKeys.exclusiveTo] = {87377,88713,88714,88716,88717,88718},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88716] = { -- Never at Rest
            [questKeys.preQuestSingle] = {87361},
            [questKeys.exclusiveTo] = {87377,88713,88714,88715,88717,88718},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88717] = { -- Never at Rest
            [questKeys.preQuestSingle] = {87361},
            [questKeys.exclusiveTo] = {87377,88713,88714,88715,88716,88718},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88718] = { -- Never at Rest
            [questKeys.preQuestSingle] = {87361},
            [questKeys.exclusiveTo] = {87377,88713,88714,88715,88716,88717},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88721] = { -- Superior Armaments of Battle - Friend of the Dawn
            [questKeys.startedBy] = {{11536}},
            [questKeys.finishedBy] = {{11536}},
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
            [questKeys.requiredMinRep] = {factionIDs.ARGENT_DAWN,3000},
            [questKeys.requiredMaxRep] = {factionIDs.ARGENT_DAWN,8999},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,100}},
        },
        [88722] = { -- Superior Armaments of Battle - Honored Amongst the Dawn
            [questKeys.startedBy] = {{11536}},
            [questKeys.finishedBy] = {{11536}},
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
            [questKeys.requiredMinRep] = {factionIDs.ARGENT_DAWN,9000},
            [questKeys.requiredMaxRep] = {factionIDs.ARGENT_DAWN,20999},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,100}},
        },
        [88723] = { -- Superior Armaments of Battle - Revered Amongst the Dawn
            [questKeys.startedBy] = {{11536}},
            [questKeys.finishedBy] = {{11536}},
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
            [questKeys.requiredMinRep] = {factionIDs.ARGENT_DAWN,21000},
            [questKeys.requiredMaxRep] = {factionIDs.ARGENT_DAWN,41999},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,100}},
        },
        [88724] = { -- Superior Armaments of Battle - Exalted Amongst the Dawn
            [questKeys.startedBy] = {{11536}},
            [questKeys.finishedBy] = {{11536}},
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
            [questKeys.requiredMinRep] = {factionIDs.ARGENT_DAWN,42000},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,100}},
        },
        [88725] = { -- Epic Armaments of Battle - Friend of the Dawn
            [questKeys.startedBy] = {{11536}},
            [questKeys.finishedBy] = {{11536}},
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
            [questKeys.requiredMinRep] = {factionIDs.ARGENT_DAWN,3000},
            [questKeys.requiredMaxRep] = {factionIDs.ARGENT_DAWN,8999},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,100}},
        },
        [88726] = { -- Epic Armaments of Battle - Honored Amongst the Dawn
            [questKeys.startedBy] = {{11536}},
            [questKeys.finishedBy] = {{11536}},
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
            [questKeys.requiredMinRep] = {factionIDs.ARGENT_DAWN,9000},
            [questKeys.requiredMaxRep] = {factionIDs.ARGENT_DAWN,20999},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,100}},
        },
        [88727] = { -- Epic Armaments of Battle - Revered Amongst the Dawn
            [questKeys.startedBy] = {{11536}},
            [questKeys.finishedBy] = {{11536}},
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
            [questKeys.requiredMinRep] = {factionIDs.ARGENT_DAWN,21000},
            [questKeys.requiredMaxRep] = {factionIDs.ARGENT_DAWN,41999},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,100}},
        },
        [88728] = { -- Epic Armaments of Battle - Exalted Amongst the Dawn
            [questKeys.startedBy] = {{11536}},
            [questKeys.finishedBy] = {{11536}},
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
            [questKeys.requiredMinRep] = {factionIDs.ARGENT_DAWN,42000},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,100}},
        },
        [88729] = { -- Ramaladni's Icy Grasp
            [questKeys.objectives] = {nil,nil,{{22682},{12361},{12360}}},
            [questKeys.preQuestSingle] = {9229},
            [questKeys.zoneOrSort] = zoneIDs.NAXXRAMAS,
        },
        [88730] = { -- The Only Song I Know...
            [questKeys.startedBy] = {{16376}},
            [questKeys.finishedBy] = {{16376}},
            [questKeys.objectives] = {nil,nil,{{236656},{7080},{12361}}},
            [questKeys.preQuestSingle] = {9033},
            [questKeys.zoneOrSort] = zoneIDs.NAXXRAMAS,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,200}},
        },
        [88744] = { -- Under the Shadow
            [questKeys.startedBy] = {{16361}},
            [questKeys.finishedBy] = {{16361}},
            [questKeys.zoneOrSort] = sortKeys.INVASION,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,50}},
        },
        [88745] = { -- Shadows of Doom
            [questKeys.startedBy] = {{16361}},
            [questKeys.finishedBy] = {{16361}},
            [questKeys.zoneOrSort] = sortKeys.INVASION,
            [questKeys.reputationReward] = {{factionIDs.ARGENT_DAWN,50}},
        },
        [88746] = { -- Consecrated Sharpening Stones
            [questKeys.startedBy] = {{16786}},
            [questKeys.finishedBy] = {{16786}},
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88747] = { -- Consecrated Sharpening Stones
            [questKeys.startedBy] = {{16787}},
            [questKeys.finishedBy] = {{16787}},
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88748] = { -- Cracked Necrotic Crystal
            [questKeys.startedBy] = {{16531}},
            [questKeys.finishedBy] = {{16478}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88749] = { -- Faint Necrotic Crystal
            [questKeys.startedBy] = {{16531}},
            [questKeys.finishedBy] = {{16494}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88882] = { -- Blessed Wizard Oil
            [questKeys.startedBy] = {{16787}},
            [questKeys.finishedBy] = {{16787}},
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88883] = { -- Blessed Wizard Oil
            [questKeys.startedBy] = {{16786}},
            [questKeys.finishedBy] = {{16786}},
            [questKeys.preQuestSingle] = {88744},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = sortKeys.INVASION,
        },
        [88968] = { -- The Lord of Blackrock
            [questKeys.startedBy] = {{4949}},
            [questKeys.finishedBy] = {{14720}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.preQuestSingle] = {7783},
            [questKeys.zoneOrSort] = zoneIDs.ORGRIMMAR,
        },
        [88969] = { -- The Lord of Blackrock
            [questKeys.startedBy] = {{1748}},
            [questKeys.finishedBy] = {{14721}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.preQuestSingle] = {7781},
            [questKeys.zoneOrSort] = zoneIDs.STORMWIND_CITY,
        },
        [89224] = { -- Food Shortage
            [questKeys.preQuestSingle] = {87498},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
            [questKeys.requiredSkill] = {profKeys.COOKING,250},
        },
        [89229] = { -- The Right Path
            [questKeys.preQuestSingle] = {89328},
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [89232] = { -- The First Step
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89300},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89303,
        },
        [89234] = { -- A Personal Matter
            [questKeys.preQuestSingle] = {89574},
            [questKeys.nextQuestInChain] = 89235,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [89235] = { -- The Culling
            [questKeys.preQuestSingle] = {89234},
            [questKeys.nextQuestInChain] = 89310,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [89236] = { -- Wrangling Apples
            [questKeys.preQuestSingle] = {89224},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
            [questKeys.objectives] = {nil,nil,{{238811}}},
            [questKeys.requiredSourceItems] = {238830,238831},
            [questKeys.extraObjectives] = {{{[zoneIDs.EASTERN_PLAGUELANDS]={{95.82,90.60}}}, Questie.ICON_TYPE_EVENT, l10n("From afar, use the Apple Scope to peer into the orchard, then lasso an Apple with the Apple Rope.")}},
        },
        [89237] = { -- This Could Get Expensive...
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89449},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89304,
        },
        [89245] = { -- Fish in a Barrel
            [questKeys.preQuestSingle] = {89224},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
            [questKeys.extraObjectives] = {
                {nil, Questie.ICON_TYPE_SLAY, l10n("Free the fish from their barrels."), 0, {{"monster", 241032}}},
            },
        },
        [89253] = { -- Main Course
            [questKeys.preQuestSingle] = {89224},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89255] = { -- Prove Your Worth: Headgear
            [questKeys.startedBy] = {{240248}},
            [questKeys.finishedBy] = {{240248}},
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSourceItems] = {238960},
            [questKeys.exclusiveTo] = {89256,89257,89258,89259,89260,89261,89262,89421},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89256] = { -- Prove Your Worth: Shoulderpads
            [questKeys.startedBy] = {{240248}},
            [questKeys.finishedBy] = {{240248}},
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSourceItems] = {238960},
            [questKeys.exclusiveTo] = {89255,89257,89258,89259,89260,89261,89262,89421},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89257] = { -- Prove Your Worth: Chestpiece
            [questKeys.startedBy] = {{240248}},
            [questKeys.finishedBy] = {{240248}},
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSourceItems] = {238960},
            [questKeys.exclusiveTo] = {89255,89256,89258,89259,89260,89261,89262,89421},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89258] = { -- Prove Your Worth: Wristguards
            [questKeys.startedBy] = {{240248}},
            [questKeys.finishedBy] = {{240248}},
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSourceItems] = {238960},
            [questKeys.exclusiveTo] = {89255,89256,89257,89259,89260,89261,89262,89421},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89259] = { -- Prove Your Worth: Gloves
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSourceItems] = {238960},
            [questKeys.exclusiveTo] = {89255,89256,89257,89258,89260,89261,89262,89421},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89260] = { -- Prove Your Worth: Belt
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSourceItems] = {238960},
            [questKeys.exclusiveTo] = {89255,89256,89257,89258,89259,89261,89262,89421},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89261] = { -- Prove Your Worth: Legguards
            [questKeys.startedBy] = {{240248}},
            [questKeys.finishedBy] = {{240248}},
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSourceItems] = {238960},
            [questKeys.exclusiveTo] = {89255,89256,89257,89258,89259,89260,89262,89421},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89262] = { -- Prove Your Worth: Boots
            [questKeys.startedBy] = {{240248}},
            [questKeys.finishedBy] = {{240248}},
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSourceItems] = {238960},
            [questKeys.exclusiveTo] = {89255,89256,89257,89258,89259,89260,89261,89421},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89300] = { -- The Ashbringer
            [questKeys.startedBy] = {nil,nil,{239696}},
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89304},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89232,
        },
        [89301] = { -- A Difficult Path
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89443},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89451,
        },
        [89303] = { -- On Fate's Path
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89232},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89442,
        },
        [89304] = { -- The Perfect Metal
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89237},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89300,
        },
        [89310] = { -- Terrordale
            [questKeys.preQuestSingle] = {89235},
            [questKeys.nextQuestInChain] = 89329,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [89328] = { -- Loss
            [questKeys.preQuestSingle] = {89329},
            [questKeys.nextQuestInChain] = 89229,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [89329] = { -- Stomping Out The Infestation
            [questKeys.preQuestSingle] = {89310},
            [questKeys.nextQuestInChain] = 89328,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [89340] = { -- Preposterously Prosed Postage
            [questKeys.startedBy] = {nil,nil,{239092}},
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSkill] = {profKeys.COOKING,250},
            [questKeys.objectivesText] = {"Finish the delivery. NOTE: You need to deploy a Pop-Up Shrub to spawn the Scarlet Courier."},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89341] = { -- The Great Feast
            [questKeys.preQuestGroup] = {89236,89245,89253,89340},
            [questKeys.requiredSkill] = {profKeys.COOKING,250},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89342] = { -- VIP Haute Club Membership
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.objectives] = {{{241462},{241461}},nil,{{238639},{238637}}},
            [questKeys.preQuestSingle] = {89341},
            [questKeys.requiredSkill] = {profKeys.COOKING,250},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89381] = { -- Pin Cushion
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,250},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89421] = { -- Bullet Heaven
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSkill] = {profKeys.LEATHERWORKING,250},
            [questKeys.questFlags] = questFlags.WEEKLY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89442] = { -- Emblem of Darkness
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89303},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89443,
        },
        [89443] = { -- Falling Into Place
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89442},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89301,
        },
        [89445] = { -- Blades of Light
            [questKeys.startedBy] = {nil,nil,{239196}},
            [questKeys.finishedBy] = {{16376}},
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89446,
        },
        [89446] = { -- The Lost Craftsman
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89445},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89447,
        },
        [89447] = { -- Extravagant Tastes
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89446},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89448,
        },
        [89448] = { -- Gathering Light
            [questKeys.startedBy] = {{16365}},
            [questKeys.finishedBy] = {{16365}},
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89447},
            [questKeys.triggerEnd] = {"Explore the Scarlet Enclave Smithy",{[zoneIDs.SCARLET_ENCLAVE] = {{-1,-1}}}},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89449,
        },
        [89449] = { -- The Radiant Forge
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89448},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89237,
        },
        [89451] = { -- Journey To Moonglade
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89301},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89462,
        },
        [89462] = { -- The Druid of the Talon
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89451},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 90507,
        },
        [89463] = { -- Nondisclosure Argument
            [questKeys.name] = "Nondisclosure Argument",
            [questKeys.preQuestSingle] = {87498},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,250},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89471] = { -- Goblin Tinkering
            [questKeys.sourceItemId] = 239246,
            [questKeys.preQuestSingle] = {89463},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,250},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89473] = { -- The Well of Eternity
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {90508},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 90559,
        },
        [89474] = { -- Forgiveness
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {90559},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89475,
        },
        [89475] = { -- The Lonely Path of the Damned
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89474},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89488,
        },
        [89485] = { -- Whimsical Horrors
            [questKeys.preQuestSingle] = {89471},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,250},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89486] = { -- A Pinch of Gunpowder
            [questKeys.preQuestSingle] = {89471},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,250},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89487] = { -- Much Ado About Magnets
            [questKeys.preQuestSingle] = {89471},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,250},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89488] = { -- A Kind of Peace
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89475},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
        },
        [89489] = { -- Increased Drop Rate
            [questKeys.preQuestGroup] = {89485,89486,89487},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,250},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89491] = { -- A Complicated Escape Plan
            [questKeys.preQuestSingle] = {89489},
            [questKeys.requiredSkill] = {profKeys.ENGINEERING,250},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [89562] = { -- My Old Enemy
            [questKeys.objectives] = {{{11036,nil,Questie.ICON_TYPE_TALK}}},
            [questKeys.preQuestSingle] = {87497},
            [questKeys.nextQuestInChain] = 89563,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [89563] = { -- Leonid's Burden
            [questKeys.preQuestSingle] = {89562},
            [questKeys.nextQuestInChain] = 89567,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [89567] = { -- The Wrecked Caravan
            [questKeys.objectives] = {nil,nil,{{242257},{242258}}},
            [questKeys.triggerEnd] = {"Locate the Scarlet Caravan", {[zoneIDs.EASTERN_PLAGUELANDS]={{33.5,27.6}}}},
            [questKeys.preQuestSingle] = {89563},
            [questKeys.nextQuestInChain] = 89568,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [89568] = { -- Something New
            [questKeys.objectives] = {nil,nil,nil,nil,{{{8523,8524,8525,8530,8543},243629}}},
            [questKeys.preQuestSingle] = {89567},
            [questKeys.sourceItemId] = 242319,
            [questKeys.nextQuestInChain] = 89574,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [89574] = { -- Servants of Death
            [questKeys.objectives] = {nil,nil,nil,nil,{{{8551,8553,8555},243630}}},
            [questKeys.preQuestSingle] = {89568},
            [questKeys.sourceItemId] = 242320,
            [questKeys.nextQuestInChain] = 89234,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [90107] = { -- The Blade Reformed
            [questKeys.preQuestSingle] = {89237},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
        },
        [90116] = { -- Holy Threads
            [questKeys.preQuestSingle] = {87502},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
            [questKeys.requiredSkill] = {profKeys.TAILORING,250},
            [questKeys.nextQuestInChain] = 90120,
            [questKeys.extraObjectives] = {{nil, Questie.ICON_TYPE_EVENT, l10n("Craft cloth bolts near the Crusader's Loom"),0,{{"object", 600003}}}},
        },
        [90120] = { -- Red is Not Dead
            [questKeys.preQuestSingle] = {90116},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
            [questKeys.requiredSkill] = {profKeys.TAILORING,250},
        },
        [90506] = { -- Take Their Breath Away
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89462},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 90508,
        },
        [90507] = { -- Logistics Challenges
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89462},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 90508,
        },
        [90508] = { -- As The Crow Flies
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestGroup] = {90506,90507},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89473,
        },
        [90510] = { -- New Avalon
            [questKeys.preQuestSingle] = {87502},
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [90518] = { -- An Apple a Day Keeps the Undead at Bay
            [questKeys.objectives] = {nil,nil,{{238811}}},
            [questKeys.preQuestSingle] = {89341},
            [questKeys.exclusiveTo] = {90519,90520},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
            [questKeys.requiredSkill] = {profKeys.COOKING,250},
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.requiredSourceItems] = {238830,238831},
            [questKeys.extraObjectives] = {{{[zoneIDs.EASTERN_PLAGUELANDS]={{95.82,90.60}}}, Questie.ICON_TYPE_EVENT, l10n("From afar, use the Apple Scope to peer into the orchard, then lasso an Apple with the Apple Rope.")}},
        },
        [90519] = { -- Fish On Demand
            [questKeys.preQuestSingle] = {89341},
            [questKeys.exclusiveTo] = {90518,90520},
            [questKeys.requiredSkill] = {profKeys.COOKING,250},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
            [questKeys.extraObjectives] = {
                {nil, Questie.ICON_TYPE_SLAY, l10n("Free the fish from their barrels."), 0, {{"monster", 241032}}},
            },
        },
        [90520] = { -- Food Safety
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.preQuestSingle] = {89341},
            [questKeys.exclusiveTo] = {90518,90519},
            [questKeys.requiredSkill] = {profKeys.COOKING,250},
            [questKeys.specialFlags] = specialFlags.REPEATABLE,
            [questKeys.questFlags] = questFlags.DAILY,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
        },
        [90559] = { -- The Tempering
            [questKeys.requiredClasses] = classIDs.WARRIOR + classIDs.PALADIN + classIDs.HUNTER,
            [questKeys.preQuestSingle] = {89473},
            [questKeys.zoneOrSort] = sortKeys.LEGENDARY,
            [questKeys.nextQuestInChain] = 89474,
        },
        [90560] = { -- Familiar Foulness
            [questKeys.startedBy] = {nil,{531291},{241655}},
            [questKeys.sourceItemId] = 241655,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredSkill] = {profKeys.ALCHEMY, 250}
        },
        [90566] = { -- Oh, My Bleeding Hearts!
            [questKeys.startedBy] = {{2055}},
            [questKeys.preQuestSingle] = {90560},
            [questKeys.sourceItemId] = 242224,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
            [questKeys.requiredSkill] = {profKeys.ALCHEMY, 250}
        },
        [90567] = { -- Unfamiliar Foulness
            [questKeys.startedBy] = {nil,{531291},{241656}},
            [questKeys.sourceItemId] = 241656,
            [questKeys.zoneOrSort] = zoneIDs.NEW_AVALON,
            [questKeys.requiredSkill] = {profKeys.ALCHEMY, 250}
        },
        [90625] = { -- On Dreaded Wings
            [questKeys.startedBy] = {nil,nil,{242365}},
            [questKeys.finishedBy] = {{238415}},
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.sourceItemId] = 242365,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [90626] = { -- Sinew of Light
            [questKeys.startedBy] = {{238415}},
            [questKeys.finishedBy] = {{238415}},
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectives] = {nil,nil,{{242364}}},
            [questKeys.sourceItemId] = 242365,
            [questKeys.preQuestSingle] = {90625},
            [questKeys.zoneOrSort] = zoneIDs.SCARLET_ENCLAVE,
        },
        [90627] = { -- Crafty the Crafter
            [questKeys.startedBy] = {{238415}},
            [questKeys.finishedBy] = {{14353}},
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectives] = {},
            [questKeys.sourceItemId] = 242365,
            [questKeys.preQuestSingle] = {90626},
            [questKeys.zoneOrSort] = zoneIDs.DIRE_MAUL,
        },

        --- Fake rune quests
        [90000] = {
            [questKeys.name] = "Arcane Blast",
            [questKeys.startedBy] = {nil,{450000}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 14,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Cast Arcane Explosion in the correct order next to the Arcane Shard. South to North."},
            [questKeys.requiredSpell] = -401757,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90001] = {
            [questKeys.name] = "Burnout",
            [questKeys.startedBy] = {{208752}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Trogg with fire spells."},
            [questKeys.requiredSpell] = -401759,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90002] = {
            [questKeys.name] = "Burnout",
            [questKeys.startedBy] = {{202060}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Murloc with fire spells."},
            [questKeys.requiredSpell] = -401759,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90003] = {
            [questKeys.name] = "Burnout",
            [questKeys.startedBy] = {{208275}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Makrura with fire spells."},
            [questKeys.requiredSpell] = -401759,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90004] = {
            [questKeys.name] = "Fingers of Frost",
            [questKeys.startedBy] = {{448,1132,1388,1271}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 11,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -401765,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90005] = {
            [questKeys.name] = "Fingers of Frost",
            [questKeys.startedBy] = {{3205,208196}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 11,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -401765,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90006] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {nil,{407983}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Search the hut for a Pile of Stolen Books."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90007] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {nil,{152608,152618,3642}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Loot the Kolkar's Booty chest."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90008] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {{589}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Defias Pillager."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90009] = {
            [questKeys.name] = "Regeneration",
            [questKeys.startedBy] = {{1867}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Dalaran Apprentice."},
            [questKeys.requiredSpell] = -401767,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90010] = {
            [questKeys.name] = "Enlightenment",
            [questKeys.startedBy] = {{202093}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 8,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Polymorph 6 irregular critters like Gazelle, Maggot and Larva to loot Azora Apprentice Notes. You find them all over Elwynn Forest."},
            [questKeys.requiredSpell] = -415942,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90011] = {
            [questKeys.name] = "Enlightenment",
            [questKeys.startedBy] = {{208712}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 8,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Polymorph 6 Odd Melon to loot Apothecary Notes. You find them all over Tirisfal Glades."},
            [questKeys.requiredSpell] = -415942,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90012] = {
            [questKeys.name] = "Arcane Surge",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Arcane Surge rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425171,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90013] = {
            [questKeys.name] = "Arcane Surge",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Arcane Surge rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425171,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90014] = {
            [questKeys.name] = "Mass Regeneration",
            [questKeys.startedBy] = {{212261},{411328,411348}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Loot the Decrepit Phylactery from the Dusty Coffer in the eastern crypt. Then use it on the Slumbering Bones in the western crypt to summon the Awakened Lich and defeat it."},
            [questKeys.requiredSpell] = -415939,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90015] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{476}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Kobold Geomancer."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90016] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{1124,1397}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Frostmane Shadowcaster and Frostmane Seer."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90017] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{3197}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Burning Blade Fanatic."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90018] = {
            [questKeys.name] = "Living Flame",
            [questKeys.startedBy] = {{1535}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Scarlet Warrior."},
            [questKeys.requiredSpell] = -401768,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90019] = {
            [questKeys.name] = "Rewind Time",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Buy the Rewind Time rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -401761,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90020] = {
            [questKeys.name] = "Living Bomb",
            [questKeys.startedBy] = {{1166}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 13,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Defeat Stonesplinter Seer."},
            [questKeys.requiredSpell] = -415936,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90021] = {
            [questKeys.name] = "Living Bomb",
            [questKeys.startedBy] = {nil,{407505}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Use Blink to reach each green dot."},
            [questKeys.requiredSpell] = -415936,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90022] = {
            [questKeys.name] = "Divine Storm",
            [questKeys.startedBy] = {nil,{409289}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Loot Althalaxx Orb on top of the tower then go to Maestra’s Post in Ashenvale and speak with Delgren the Purifier."},
            [questKeys.exclusiveTo] = {78089},
            [questKeys.requiredSpell] = -410014,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90023] = {
            [questKeys.name] = "Wild Strikes",
            [questKeys.startedBy] = {{11910,11913,11912,11911}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Defeat Grimtotem Tauren to receive Idol of the Wild and follow its guidance."},
            [questKeys.requiredSpell] = -410021,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90024] = {
            [questKeys.name] = "Survival of the Fittest",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Buy the Survival of the Fittest rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -416042,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90025] = {
            [questKeys.name] = "Serendipity",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Buy the Serendipity rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -415995,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90026] = {
            [questKeys.name] = "Divine Sacrifice",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Buy the Divine Sacrifice rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -410010,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90027] = {
            [questKeys.name] = "Lone Wolf",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Buy the Lone Wolf rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -410122,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90028] = {
            [questKeys.name] = "Warbringer",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Buy the Warbringer rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -425445,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90029] = {
            [questKeys.name] = "Demonic Pact",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Buy the Demonic Pact rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -425476,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90030] = {
            [questKeys.name] = "Main Gauche",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Buy the Main Gauche rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -424990,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90031] = {
            [questKeys.name] = "Dual Wield Specialization",
            [questKeys.startedBy] = {{211653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 20,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Buy the Dual Wield Specialization rune from Grizzby."},
            [questKeys.preQuestSingle] = {78297,78304},
            [questKeys.requiredSpell] = -410096,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90032] = {
            [questKeys.name] = "Lake of Fire",
            [questKeys.startedBy] = {{3537}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Buy Demolition Explosives from Zixil for 1 gold."},
            [questKeys.requiredSpell] = -403937,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90033] = {
            [questKeys.name] = "Lake of Fire",
            [questKeys.startedBy] = {nil,{414658}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use the Demolition Explosives bought from Zixil on the rubble and loot the chest that spawns."},
            [questKeys.requiredSpell] = -403937,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90034] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{3291}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Buy Malevolent Pie from Greishan Ironstove. Eat it and he will give you the rune."},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90035] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{2336}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Dark Strand Fanatic"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90036] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{114,480,832,210501}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Harvest Watcher or Rusty Harvest Golem for Spare Reaper Parts. Kill Dust Devil for Elemental Core. Combine for Elemental Core. Use on Harvest Reaper Prototype and kill it for the rune"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90037] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {{212763}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Cast Curse of Recklessness on Sadistic Fiend and kill it"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90038] = {
            [questKeys.name] = "Master Channeler",
            [questKeys.startedBy] = {nil,{407347}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Cast Health Funnel while standing on the Altar of Thorns until you are at 0 health"},
            [questKeys.requiredSpell] = -403932,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90039] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{208752}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Trogg with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90040] = {
            [questKeys.name] = "Beacon of Light",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Beacon of Light rune from the Quartermaster."},
            [questKeys.requiredSpell] = -409999,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90041] = {
            [questKeys.name] = "Healing Rain",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Healing Rain rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416057,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90042] = {
            [questKeys.name] = "Everlasting Affliction",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Everlasting Affliction rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416008,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90043] = {
            [questKeys.name] = "Everlasting Affliction",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Everlasting Affliction rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416008,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90044] = {
            [questKeys.name] = "Serpent Spread",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Serpent Spread rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425760,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90045] = {
            [questKeys.name] = "Serpent Spread",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Serpent Spread rune from the Quartermaster."},
            [questKeys.requiredSpell] = -425760,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90046] = {
            [questKeys.name] = "Single-Minded Fury",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Single-Minded Fury rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416003,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90047] = {
            [questKeys.name] = "Single-Minded Fury",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Single-Minded Fury rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416003,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90048] = {
            [questKeys.name] = "Skull Bash",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Skull Bash rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416046,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90049] = {
            [questKeys.name] = "Skull Bash",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Skull Bash rune from the Quartermaster."},
            [questKeys.requiredSpell] = -416046,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90050] = {
            [questKeys.name] = "Just a Flesh Wound",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Just a Flesh Wound rune from the Quartermaster."},
            [questKeys.requiredSpell] = -400082,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90051] = {
            [questKeys.name] = "Just a Flesh Wound",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Just a Flesh Wound rune from the Quartermaster."},
            [questKeys.requiredSpell] = -400082,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90052] = {
            [questKeys.name] = "Mind Sear",
            [questKeys.startedBy] = {{213077,214099,214101,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Reach Friendly with the Azeroth Commerce Authority, then buy the Mind Sear rune from the Quartermaster."},
            [questKeys.requiredSpell] = -415996,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90053] = {
            [questKeys.name] = "Mind Sear",
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Reach Friendly with Durotar Supply and Logistics, then buy the Mind Sear rune from the Quartermaster."},
            [questKeys.requiredSpell] = -415996,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90054] = {
            [questKeys.name] = "Living Seed",
            [questKeys.startedBy] = {{206248}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Loot 3 Glade Flower spread across the zone. Combine them to the Glade Crown, use it on the Wooden Effigy and defeat the Unleashed Nature Spirit Elite mob."},
            [questKeys.requiredSpell] = -416050,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90055] = {
            [questKeys.name] = "Living Seed",
            [questKeys.startedBy] = {{206248}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Loot 3 Prairie Flower spread across the zone. Combine them to the Prairie Crown, use it on the Wooden Effigy and defeat the Unleashed Nature Spirit Elite mob."},
            [questKeys.requiredSpell] = -416050,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90056] = {
            [questKeys.name] = "Starsurge",
            [questKeys.startedBy] = {{212186,212209}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Accept the offer from Grugimdern to receive a Mushroom. Then eat the Mushroom at the pond and speak with Vodyanoi."},
            [questKeys.requiredSpell] = -424718,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90057] = {
            [questKeys.name] = "Sunfire",
            [questKeys.startedBy] = {{207577},{404433}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Cast Moonfire on all three Lunar Stones to spawn the Lunar Chest."},
            [questKeys.requiredSpell] = -416044,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90058] = {
            [questKeys.name] = "Lifebloom",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend."},
            [questKeys.requiredSpell] = -410033,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90059] = {
            [questKeys.name] = "Prayer of Mending",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend."},
            [questKeys.requiredSpell] = -402848,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90060] = {
            [questKeys.name] = "Ancestral Guidance",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend."},
            [questKeys.requiredSpell] = -410099,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90061] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{202060}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Murloc with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90062] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{208275}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Makrura with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90063] = {
            [questKeys.name] = "Chaos Bolt",
            [questKeys.startedBy] = {{202060}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Murloc with fire spells."},
            [questKeys.requiredSpell] = -403925,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90064] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{209954,209958}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Demonic Remains with a shadow spell. It spawns Graix, who drops the Rune."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90065] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{391}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Drain Soul on Old Murk-Eye to receive Soul of the Sea."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90066] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {nil,{450002}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Soul of the Sea on the Medusa Statue."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90067] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{3445}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Drain Soul on Supervisor Lugwizzle to receive Soul of Greed."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90068] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {nil,{407312}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use the Soul of Greed on the Hungry Idol."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90069] = {
            [questKeys.name] = "Shadow Bolt Volley",
            [questKeys.startedBy] = {{1974,1973}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Ravenclaw Drudger and Ravenclaw Guardian until they drop Tortured Soul. Once gathered, Life Tap to receive a buff, and then use the item. This will spawn a Ghost mob to kill."},
            [questKeys.requiredSpell] = -403936,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90070] = {
            [questKeys.name] = "Incinerate",
            [questKeys.startedBy] = {{214519}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Incinerator Gar'im"},
            [questKeys.requiredSpell] = -416015,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90071] = {
            [questKeys.name] = "Demonic Tactics",
            [questKeys.startedBy] = {{204503,906,6122}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Loot the Dead Acolyte near Jasperlode Mine. Take the artifact to the Warlock Trainer in Goldshire. Use the Powerless Artifact near the Dead Acolyte. Finally go to Gakin the Darkbinder in Stormwind"},
            [questKeys.requiredSpell] = -416009,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90072] = {
            [questKeys.name] = "Demonic Tactics",
            [questKeys.startedBy] = {{208927,2127,5675}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Loot the Dead Acolyte near Scarlet Monestary. Take the artifact to the Warlock Trainer in Brill. Use the Powerless Artifact near the Dead Acolyte. Finally go to Carendin Halgar in Undercity"},
            [questKeys.requiredSpell] = -416009,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90073] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{6124,209002}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Captain Beld to obtain Tainted Soul Shard. Trade both Shards to Gaklik Voidtwist in Kharanos"},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90074] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{448,204256}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Hogger to obtain Tainted Soul Shard. Trade both Shards to Damien Kane, found in the basement of the Goldshire Inn."},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90075] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{3204,208226}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Gazz'uz to obtain Tainted Soul Shard. Trade both Shards to Darmak Bloodhowl in Razor Hill."},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90076] = {
            [questKeys.name] = "Soul Siphon",
            [questKeys.startedBy] = {{1753,208682}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Drain a critter with Drain Soul to obtain Pure Soul Shard. Drain Maggot Eye to obtain Tainted Soul Shard. Trade both Shards to Denton Bleakway in Undercity."},
            [questKeys.requiredSpell] = -403920,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90077] = {
            [questKeys.name] = "Demonic Grace",
            [questKeys.startedBy] = {{204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain an Ominous Tome from Frostmane Shadowcaster in Troll cave west of Brewnall Village Loot Wendigo Blood from Wendigo mobs Loot Wolf Jawbone from Wolf mobs. Use the reagents on Shimmer Ridge and kill Soboz."},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90078] = {
            [questKeys.name] = "Demonic Grace",
            [questKeys.startedBy] = {{204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain an Ominous Tome from Kobolds in Jasperlode Mine. Loot Gnoll Blood from any Gnoll. Loot Wolf Jawbone from any Prowler or Wolf. Use the reagents on the summoning circle at The Slaughtered Lamb Inn in the Mage Quarter in Stormwind and kill Soboz."},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90079] = {
            [questKeys.name] = "Demonic Grace",
            [questKeys.startedBy] = {{204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain an Ominous Tome from Voodoo Troll in Echo Isles. Loot Makrura Leg from Makrura mobs. Loot Kul Tiran Skull from Kul Tiran mobs in Tiragarde Keep. Use the reagents on the summoning circle near Zalazane and kill Soboz."},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90080] = {
            [questKeys.name] = "Demonic Grace",
            [questKeys.startedBy] = {{204070}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Obtain an Ominous Tome from Darkeye Bonecaster. Loot Gnoll Blood from any Gnoll in Garren's Haunt. Loot Wolf Jawbone from any Darkhound in Tirisfal Glades. Use the reagents on the summoning circle in the Sewers location in Undercity - up where the flight path usually flies you over. Kill Soboz."},
            [questKeys.requiredSpell] = -425477,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90081] = {
            [questKeys.name] = "Heart of the Lion",
            [questKeys.startedBy] = {{211965}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Enter the cave to the east and defeat Carrodin."},
            [questKeys.requiredSpell] = -410115,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90082] = {
            [questKeys.name] = "Master Marksman",
            [questKeys.startedBy] = {{205692,208179,208975,209811}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 6,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Use Hunter's Mark on the Bush and defeat the Poacher."},
            [questKeys.requiredSpell] = -410113,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90083] = {
            [questKeys.name] = "Cobra Strikes",
            [questKeys.startedBy] = {{3537,211951}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Buy Freshwater Snapper Bait from Zixil and use them on the boat in the lake to spawn Koartul."},
            [questKeys.requiredSpell] = -425759,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90084] = {
            [questKeys.name] = "Blade Dance",
            [questKeys.startedBy] = {nil,{414532}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 16,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Defeat Naga in the Cliffspring River cave to receive Cliffspring Key. Use the key to open the chest."},
            [questKeys.requiredSpell] = -400099,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90085] = {
            [questKeys.name] = "Blade Dance",
            [questKeys.startedBy] = {{1169}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Dark Iron dwarfs to receive Dark Iron Lockbox and pick it."},
            [questKeys.requiredSpell] = -400099,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90086] = {
            [questKeys.name] = "Blade Dance",
            [questKeys.startedBy] = {nil,{408718}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Defias to receive a Discreet Envelope which contains the Equipment Stash Key. Use the key to open the chest."},
            [questKeys.requiredSpell] = -400099,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90087] = {
            [questKeys.name] = "Blade Dance",
            [questKeys.startedBy] = {nil,{407454}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Southsea pirates to receive Buccaneer's Matchbox. Use it to blow up some crates and loot the rune from the spawning chest."},
            [questKeys.requiredSpell] = -400099,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90088] = {
            [questKeys.name] = "First Trial of The Owls",
            [questKeys.startedBy] = {nil,{410020}},
            [questKeys.finishedBy] = {{12042}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.requiredSpell] = -410028,
            [questKeys.objectivesText] = {"Click the Owl Statue to start the the first trial. You will need to defeat 3 waves of 2 mobs each. Then you will receive the Symbol of the First Owl."},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90089] = {
            [questKeys.name] = "Second Trial of The Owls",
            [questKeys.startedBy] = {nil,{410089}},
            [questKeys.finishedBy] = {{12042}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.requiredSpell] = -410028,
            [questKeys.objectivesText] = {"Click the Owl Statue to become able to see Agon who is east of the grove, near the worgen camp. Defeat him and collect the Symbol of the Second Owl."},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90090] = {
            [questKeys.name] = "Third Trial of The Owls",
            [questKeys.startedBy] = {nil,{409942,409949}},
            [questKeys.finishedBy] = {{12042}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.requiredSpell] = -410028,
            [questKeys.objectivesText] = {"Click one of the Twin Owl Statues and reach the other in two minutes. You need to use Aquatic Form to make it in time. If you succeed you'll receive the Symbol of the Third Owl."},
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90091] = {
            [questKeys.name] = "Flagellation",
            [questKeys.startedBy] = {{212261},{411328,411348}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Loot the Decrepit Phylactery from the Dusty Coffer in the eastern crypt. Then use it on the Slumbering Bones in the western crypt to summon the Awakened Lich."},
            [questKeys.requiredSpell] = -403480,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90092] = {
            [questKeys.name] = "Blood Frenzy",
            [questKeys.startedBy] = {{203079}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -403474,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90093] = {
            [questKeys.name] = "Furious Thunder",
            [questKeys.startedBy] = {{208638,207515,327,448,1271,1388,3204,3281,3205,3058,6113,208196},{407734}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -403476,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90094] = {
            [questKeys.name] = "Consumed By Rage",
            [questKeys.startedBy] = {{211965}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Enter the cave to the east and defeat Carrodin."},
            [questKeys.requiredSpell] = -425446,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90095] = {
            [questKeys.name] = "Explosive Shot",
            [questKeys.startedBy] = {{208638,327,448,1271,1388,3204,3281,3205,3058,6113,208196},{407734}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -410123,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90100] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{208652}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Troll Head, a Severed Wendigo Paw and a Pristine Trogg Heart to Junni Steelpass."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90101] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{203226}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Kobold Head, a Severed Murloc Head and a Severed Gnoll Head to Viktoria Woods."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90102] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{209608}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Tiger Head, a Severed Owl Head and a Severed Spider Head to Delwynna."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90103] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{207957}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Centaur Head, a Severed Harpy Head and a Severed Quilboar Head to Vahi Bonesplitter."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90104] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{207637}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Gnoll Head, a Severed Harpy Head and a Severed Quilboar Head to Vateya Timberhoof."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90105] = {
            [questKeys.name] = "Devastate",
            [questKeys.startedBy] = {{208619}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Bring a Severed Bat Head, a Severed Gnoll Head and a Severed Murloc Head to Dorac Graves."},
            [questKeys.requiredSpell] = -403475,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90106] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{5570}},
            [questKeys.finishedBy] = {{5570}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Bruuk Barleybeard and then defeat Bruart outside the Inn. Return to Bruuk afterwards."},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90108] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{6736}},
            [questKeys.finishedBy] = {{6736}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Innkeeper Keldamyr and then defeat Syllart outside the Inn. Return to Keldamyr afterwards."},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90109] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{3399}},
            [questKeys.finishedBy] = {{3399}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Zamja and then defeat Gru'ark outside the hut. Return to Zamja afterwards."},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90110] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{207743}},
            [questKeys.finishedBy] = {{207743}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Netali Proudwind and then defeat Mooart outside the hut. Return to Netali afterwards."},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90111] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{208920}},
            [questKeys.finishedBy] = {{208920}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Penny Hawkins and then defeat Blueheart in the basement. Return to Penny afterwards."},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90112] = {
            [questKeys.name] = "Endless Rage",
            [questKeys.startedBy] = {{391}},
            [questKeys.finishedBy] = {{391}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -403489,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90113] = {
            [questKeys.name] = "Endless Rage",
            [questKeys.startedBy] = {{210451}},
            [questKeys.finishedBy] = {{210451}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defeat her."},
            [questKeys.requiredSpell] = -403489,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90114] = {
            [questKeys.name] = "Endless Rage",
            [questKeys.startedBy] = {{2478}},
            [questKeys.finishedBy] = {{2478}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Mo'grosh Orgre in the north-east of Loch Modan until you receive a Battle Totem. Use this totem to challenge Haren Swifthoof."},
            [questKeys.requiredSpell] = -403489,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90115] = {
            [questKeys.name] = "Endless Rage",
            [questKeys.startedBy] = {{209607},{407289,407291}},
            [questKeys.finishedBy] = {{209607}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 17,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Pickup the Horde Warbanner in the Crossroads and replace it with the Alliance Warbanner  in Northwatch Hold. Then defeat Lieutenant Stonebrew."},
            [questKeys.requiredSpell] = -403489,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90117] = {
            [questKeys.name] = "Seal of Martyrdom",
            [questKeys.startedBy] = {{205278,205153},{402215}},
            [questKeys.finishedBy] = {{205153}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"First talk to Brother Romulus in Stormwind Cathedral. Then head to the stairs right next to Brother Romulus and find the Charred Note. At last challenge Ada Gelhardt and defeat her."},
            [questKeys.requiredSpell] = -410015,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90118] = {
            [questKeys.name] = "Horn of Lordaeron",
            [questKeys.startedBy] = {nil,{407844}},
            [questKeys.finishedBy] = {nil,{407844}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Receive the Libram of Blessings in the basement of the tavern, equip it and follow its guidance."},
            [questKeys.requiredSpell] = -425618,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90119] = {
            [questKeys.name] = "Horn of Lordaeron",
            [questKeys.startedBy] = {{210537}},
            [questKeys.finishedBy] = {{210537}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Defeat the Undying Laborer in the mine and finish him with holy damage to receive the Libram of Blessings. Then equip it and follow its guidance."},
            [questKeys.requiredSpell] = -425618,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90121] = {
            [questKeys.name] = "Inspiration Exemplar",
            [questKeys.startedBy] = {{204827}},
            [questKeys.finishedBy] = {{204827}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 4,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Summon the Adventurer's Spirit with the help of a friend."},
            [questKeys.requiredSpell] = -410011,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90122] = {
            [questKeys.name] = "Avenger's Shield",
            [questKeys.startedBy] = {{214456}},
            [questKeys.finishedBy] = {{214456}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Defeat him."},
            [questKeys.requiredSpell] = -410008,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90123] = {
            [questKeys.name] = "Rebuke",
            [questKeys.startedBy] = {{5570}},
            [questKeys.finishedBy] = {{5570}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Talk to Bruuk Barleybeard and then defeat Bruart outside the Inn. Return to Bruuk afterwards."},
            [questKeys.requiredSpell] = -425621,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90124] = {
            [questKeys.name] = "Rebuke",
            [questKeys.startedBy] = {{203475}},
            [questKeys.finishedBy] = {{203475}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Talk to Liv Bradford and then defeat Stuart outside the Inn. Return to Liv afterwards"},
            [questKeys.requiredSpell] = -425621,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90125] = {
            [questKeys.name] = "Rebuke",
            [questKeys.startedBy] = {{6736}},
            [questKeys.finishedBy] = {{6736}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Talk to Innkeeper Keldamyr and then defeat Syllart outside the Inn. Return to Keldamyr afterwards."},
            [questKeys.requiredSpell] = -425621,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90126] = {
            [questKeys.name] = "Hand of Reckoning",
            [questKeys.startedBy] = {nil,{407850}},
            [questKeys.finishedBy] = {nil,{407850}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Retrieve the Libram of Justice deep inside the Stonesplitter Valley cave, equip it and follow its guidance."},
            [questKeys.requiredSpell] = -410001,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90127] = {
            [questKeys.name] = "Mangle",
            [questKeys.startedBy] = {{7318}},
            [questKeys.finishedBy] = {{7318}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Defeat him to receive the Idol of Ursine Rage drops, equip it and follow its guidance."},
            [questKeys.requiredSpell] = -410025,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90128] = {
            [questKeys.name] = "Lacerate",
            [questKeys.startedBy] = {{1684}},
            [questKeys.finishedBy] = {{1224}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Buy Rainbow Fin Albacore Chum and feed a Young Threshadon in The Loch."},
            [questKeys.requiredSpell] = -416049,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90129] = {
            [questKeys.name] = "Lacerate",
            [questKeys.startedBy] = {nil,{407117,407120}},
            [questKeys.finishedBy] = {{407120}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Pickup the Abandoned Snapjaw Egg in the Forgotten Pools and place it in the Empty Snapjaw Nest in the Lushwater Oasis."},
            [questKeys.requiredSpell] = -416049,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90130] = {
            [questKeys.name] = "Savage Roar",
            [questKeys.startedBy] = {{6788}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Defeat the Den Mother, equip the Ferocious Idol and follow its guidance."},
            [questKeys.requiredSpell] = -410023,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90131] = {
            [questKeys.name] = "Savage Roar",
            [questKeys.startedBy] = {nil,{152608,152618,3642}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Loot the Kolkar's Booty chest, equip the Ferocious Idol and follow its guidance."},
            [questKeys.requiredSpell] = -410023,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90132] = {
            [questKeys.name] = "Savage Roar",
            [questKeys.startedBy] = {nil,{408004}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Loot the Tangled Blight Pile, equip the Ferocious Idol and follow its guidance."},
            [questKeys.requiredSpell] = -410023,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90133] = {
            [questKeys.name] = "Quick Draw",
            [questKeys.startedBy] = {nil,{386675}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Frostmane Trolls, Rockjaw Troggs, Leper Gnomes and Dark Iron Dwarves for map pieces. Collect all 4, and combine them. Follow the location of the treasure map and loot the treasure chest."},
            [questKeys.requiredSpell] = -400095,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90134] = {
            [questKeys.name] = "Quick Draw",
            [questKeys.startedBy] = {nil,{450005}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Kobolds, Defias, Murlocs and Gnolls for map pieces. Collect all 4, and combine them. Follow the location of the treasure map and loot the treasure chest."},
            [questKeys.requiredSpell] = -400095,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90135] = {
            [questKeys.name] = "Quick Draw",
            [questKeys.startedBy] = {nil,{450008}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Timberlings, Gnarlpine, Harpies and Sprites for map pieces. Collect all 4, and combine them. Follow the location of the treasure map and loot the treasure chest."},
            [questKeys.requiredSpell] = -400095,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90136] = {
            [questKeys.name] = "Quick Draw",
            [questKeys.startedBy] = {nil,{450006}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Kul Tiras, Burning Blade, Quilboar and Trolls for map pieces. Collect all 4, and combine them. Follow the location of the treasure map and loot the treasure chest."},
            [questKeys.requiredSpell] = -400095,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90137] = {
            [questKeys.name] = "Quick Draw",
            [questKeys.startedBy] = {nil,{450007}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Scarlet, Tirisfal Farmers, Murlocs and Gnolls for map pieces. Collect all 4, and combine them. Follow the location of the treasure map and loot the treasure chest."},
            [questKeys.requiredSpell] = -400095,
        },
        [90138] = {
            [questKeys.name] = "Slaughter from the Shadows",
            [questKeys.startedBy] = {nil,{387466,407734,404941}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Lockbox for the rune."},
            [questKeys.requiredSpell] = -424992,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90139] = {
            [questKeys.name] = "Quick Strike",
            [questKeys.startedBy] = {{1161,1162,1163,1164}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Troggs for the Skull-Shaped Geode. Then get hit by a Skullthumper's stun and use the geode to loot the rune."},
            [questKeys.requiredSpell] = -425443,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90140] = {
            [questKeys.name] = "Quick Strike",
            [questKeys.startedBy] = {{504,95,449,590,589,121,285,46,732,735},{408799}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Defias for Gillsbane, equip it and then kill Murlocs to receive Soul of the Sea. Take it to the Idol of the Deep to summon Horror of the Deep and defeat it."},
            [questKeys.requiredSpell] = -425443,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90141] = {
            [questKeys.name] = "Quick Strike",
            [questKeys.startedBy] = {{210482},{408802}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Loot the Gnarled Harpoon, and use it on Paxnozz to weaken it, kill it and loot the rune."},
            [questKeys.requiredSpell] = -425443,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90142] = {
            [questKeys.name] = "Quick Strike",
            [questKeys.startedBy] = {{3497,209797}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Purchase a Fishing Harpoon from Kilxx, and use it on Bruuz to weaken it, kill it and loot the rune."},
            [questKeys.requiredSpell] = -425443,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90143] = {
            [questKeys.name] = "Quick Strike",
            [questKeys.startedBy] = {{212598}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Find the body of Recke Grinnes, loot him to get Rot Bane, equip it and it will give you the Rot Bane buff. Kill Rot Hide Gnolls until one drops the rune."},
            [questKeys.requiredSpell] = -425443,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90144] = {
            [questKeys.name] = "Savage Roar",
            [questKeys.startedBy] = {{452,124,117,501,1426,123,453,125,500,1065,98}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Riverpaw Gnolls until one drops the Ferocious Idol, equip the idol and follow its guidance."},
            [questKeys.requiredSpell] = -410023,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90145] = {
            [questKeys.name] = "Lacerate",
            [questKeys.startedBy] = {{2167,2324,2171,2168,2169,2170,2234}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Furlbogs until Crab Treats drop, use them to feed a Young Reef Crawler and receive the rune."},
            [questKeys.requiredSpell] = -416049,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90146] = {
            [questKeys.name] = "Mangle",
            [questKeys.startedBy] = {{3566,2960}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Flatland Prowlers or Prairie Wolf Alphas until the Idol of Ursine Rage drops. Equip it and follow its guidance."},
            [questKeys.requiredSpell] = -410025,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90147] = {
            [questKeys.name] = "Hand of Reckoning",
            [questKeys.startedBy] = {{846,572,7050}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 22,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Kill Ghouls, Defias Drones or the rare Leprithus until the Libram of Justice drops, equip it and follow its guidance."},
            [questKeys.requiredSpell] = -410001,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90148] = {
            [questKeys.name] = "Exorcist",
            [questKeys.startedBy] = {{215,909,910}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Kill Defias until one drops the Libram of Banishment, equip the libram and follow its guidance."},
            [questKeys.requiredSpell] = -416037,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90150] = {
            [questKeys.name] = "Sniper Training",
            [questKeys.startedBy] = {{210482},{408802}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Loot the Gnarled Harpoon, and use it on Paxnozz to weaken it, kill it and loot the rune."},
            [questKeys.requiredSpell] = -416091,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90151] = {
            [questKeys.name] = "Sniper Training",
            [questKeys.startedBy] = {{210549}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Mark a Defias Scout with Hunter's Mark, and kill them whilst they are marked until the rune drops."},
            [questKeys.requiredSpell] = -416091,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90152] = {
            [questKeys.name] = "Sniper Training",
            [questKeys.startedBy] = {{210107}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Kackle and loot the rune."},
            [questKeys.requiredSpell] = -416091,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90153] = {
            [questKeys.name] = "Sniper Training",
            [questKeys.startedBy] = {{3497,209797}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Purchase a Fishing Harpoon from Kilxx, and use it on Bruuz to weaken it, kill it and loot the rune."},
            [questKeys.requiredSpell] = -416091,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90154] = {
            [questKeys.name] = "Lacerate",
            [questKeys.startedBy] = {{210483}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 16,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Defias for Magic Pumpkin Seeds, Crabs for Fishy Bonemeal and Kobolds for Fertile Soil Sample. Then go to any farmland in Westfall, and use the seeds to spawn Aggressive Squashling. Kill it and loot the rune."},
            [questKeys.requiredSpell] = -416049,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90155] = {
            [questKeys.name] = "Void Plague",
            [questKeys.startedBy] = {{1211}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Leper Gnomes and loot the rune."},
            [questKeys.requiredSpell] = -425216,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90156] = {
            [questKeys.name] = "Void Plague",
            [questKeys.startedBy] = {{327}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Goldtooth and loot the rune."},
            [questKeys.requiredSpell] = -425216,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90157] = {
            [questKeys.name] = "Void Plague",
            [questKeys.startedBy] = {nil,{407734}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Find a Gnarlpine Cache at the bottom of the Ben'ethil Barrow Den and loot it for the rune."},
            [questKeys.requiredSpell] = -425216,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90158] = {
            [questKeys.name] = "Void Plague",
            [questKeys.startedBy] = {{3128,2129}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Kul Tiras and loot the rune."},
            [questKeys.requiredSpell] = -425216,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90159] = {
            [questKeys.name] = "Void Plague",
            [questKeys.startedBy] = {{208196}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Gillgar and loot the rune."},
            [questKeys.requiredSpell] = -425216,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90161] = {
            [questKeys.name] = "Strength of Soul",
            [questKeys.startedBy] = {nil,{450003}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Thislefur for Primal Insight, then go up in to the tree, and use it whilst near the Thislefur Dreamcatcher with two Meditation buffs active, and receive the rune."},
            [questKeys.requiredSpell] = -415997,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90162] = {
            [questKeys.name] = "Twisted Faith",
            [questKeys.startedBy] = {nil,{450004}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 12,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Kobolds until a Offering Coin drops, then go to the first left turn near the cave entrance and go to the well, use the coin near the well to receive the rune."},
            [questKeys.requiredSpell] = -425215,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90163] = {
            [questKeys.name] = "Twisted Faith",
            [questKeys.startedBy] = {{210537}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill the Undying Laborer with holy damage to receive the rune."},
            [questKeys.requiredSpell] = -425215,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90164] = {
            [questKeys.name] = "Twisted Faith",
            [questKeys.startedBy] = {nil,{414663}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 16,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Nagas for Shatterspear Offering, then go to the Shatterspear Idol, and use the offering to receive the rune."},
            [questKeys.requiredSpell] = -425215,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90165] = {
            [questKeys.name] = "Twisted Faith",
            [questKeys.startedBy] = {{3268,3267,3266,3265,3457}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 12,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Quillboars until Helping Hand drops. You then need to use Rank 1 Ressurection on someone for the hand to open, then click it to receive the rune."},
            [questKeys.requiredSpell] = -425215,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90166] = {
            [questKeys.name] = "Twisted Faith",
            [questKeys.startedBy] = {{212809}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Wailing Spirit, and loot the rune."},
            [questKeys.requiredSpell] = -425215,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90167] = {
            [questKeys.name] = "Flanking Strike",
            [questKeys.startedBy] = {{208812}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Boars for Dun Morogh Pig Meat, then use the meat east of the lake near Brewnall Village, to summon Jorul which you must kill and then loot the rune."},
            [questKeys.requiredSpell] = -425762,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90168] = {
            [questKeys.name] = "Flanking Strike",
            [questKeys.startedBy] = {{209928}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Strigid Birds for Teldrassil Bird Meat, then use the meat east of the river near The Oracle Glade, to summon Mowgh which you must kill and then loot the rune."},
            [questKeys.requiredSpell] = -425762,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90169] = {
            [questKeys.name] = "Power Word: Barrier",
            [questKeys.startedBy] = {{436}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 22,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Blackrock Shadowcasters and then loot the rune. You will need to have two mediation buffs to use it."},
            [questKeys.requiredSpell] = -425213,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90170] = {
            [questKeys.name] = "Flanking Strike",
            [questKeys.startedBy] = {{208124}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Mottled Boars for Durotar Pig Meat, then use the meat on the most northern island of The Echo Isles, to summon Raluk which you must kill and then loot the rune."},
            [questKeys.requiredSpell] = -425762,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90171] = {
            [questKeys.name] = "Flanking Strike",
            [questKeys.startedBy] = {{205382}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Swoops and Plainstriders for Mulgore Bird Meat, then use the meat west of Bloodhoof Village, to summon Mokwa which you must kill and then loot the rune."},
            [questKeys.requiredSpell] = -425762,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90172] = {
            [questKeys.name] = "Beast Mastery",
            [questKeys.startedBy] = {{210533}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Goretusks for Goretusk Haunch, then use the haunch north of Gold Coast Quarry, to summon Silverspur which you must kill and then loot the rune."},
            [questKeys.requiredSpell] = -410110,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90173] = {
            [questKeys.name] = "Beast Mastery",
            [questKeys.startedBy] = {{2170,2171,2169,2168,2324,2167,2234}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Furbolgs for Crab Treats, then use them on a Young Reef Crawler on the beach to receive the rune."},
            [questKeys.requiredSpell] = -410110,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90174] = {
            [questKeys.name] = "Beast Mastery",
            [questKeys.startedBy] = {nil,{407918}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Loot the Empty Trophy Display next to Daryl the Youngling to receive the rune."},
            [questKeys.requiredSpell] = -410110,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90175] = {
            [questKeys.name] = "Beast Mastery",
            [questKeys.startedBy] = {{1778,211736}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 16,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Ferocious Grizzled Bears until a Grizzled Protector spawns. Kill it to receive the rune."},
            [questKeys.requiredSpell] = -410110,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90176] = {
            [questKeys.name] = "Beast Mastery",
            [questKeys.startedBy] = {{209524}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Patrolling Cheetah. You will need to drop a trap in its path to remove the speed buff, once the buff is removed, kill it to receive the rune."},
            [questKeys.requiredSpell] = -410110,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90177] = {
            [questKeys.name] = "Shared Pain",
            [questKeys.startedBy] = {{6124}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 11,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Captain Beld to receive the rune."},
            [questKeys.requiredSpell] = -402854,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90178] = {
            [questKeys.name] = "Shared Pain",
            [questKeys.startedBy] = {{40}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Kobold Miners to receive the rune."},
            [questKeys.requiredSpell] = -402854,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90179] = {
            [questKeys.name] = "Shared Pain",
            [questKeys.startedBy] = {{2038}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Lord Melenas to receive the rune."},
            [questKeys.requiredSpell] = -402854,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90180] = {
            [questKeys.name] = "Shared Pain",
            [questKeys.startedBy] = {{13157,3204}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 13,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Makasgar or Gazzuz to receive the rune."},
            [questKeys.requiredSpell] = -402854,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90181] = {
            [questKeys.name] = "Shared Pain",
            [questKeys.startedBy] = {{1934}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Tirisfal Farmers to receive the rune."},
            [questKeys.requiredSpell] = -402854,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90182] = {
            [questKeys.name] = "Homunculi",
            [questKeys.startedBy] = {{1124,1397}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Frostmane Seers and Shadowcasters to receive the rune."},
            [questKeys.requiredSpell] = -402852,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90183] = {
            [questKeys.name] = "Homunculi",
            [questKeys.startedBy] = {{474}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Defias Rogue Wizards to receive the rune."},
            [questKeys.requiredSpell] = -402852,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90184] = {
            [questKeys.name] = "Homunculi",
            [questKeys.startedBy] = {{2002,2003,2004,2005}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Grells to receive the rune."},
            [questKeys.requiredSpell] = -402852,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90185] = {
            [questKeys.name] = "Homunculi",
            [questKeys.startedBy] = {{3206}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Voodoo Trolls to receive the rune."},
            [questKeys.requiredSpell] = -402852,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90186] = {
            [questKeys.name] = "Homunculi",
            [questKeys.startedBy] = {{1535,1536}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 6,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Scarlet Warriors and Missionaries to receive the rune."},
            [questKeys.requiredSpell] = -402852,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90187] = {
            [questKeys.name] = "Shadow Word: Death",
            [questKeys.startedBy] = {{572}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 19,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Leprithus to receive the rune."},
            [questKeys.requiredSpell] = -402849,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90188] = {
            [questKeys.name] = "Shadow Word: Death",
            [questKeys.startedBy] = {{209742}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Cast Dispel on Desert Mirage to receive the rune."},
            [questKeys.requiredSpell] = -402849,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90189] = {
            [questKeys.name] = "Shadow Word: Death",
            [questKeys.startedBy] = {{209908}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kneel at the Heretic Idol and receive the rune."},
            [questKeys.requiredSpell] = -402849,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90190] = {
            [questKeys.name] = "Shadow Word: Death",
            [questKeys.startedBy] = {nil,{411674}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Loot the Prophecy of a King's Demise on the table next to Thule Ravenclaw and receive the rune."},
            [questKeys.requiredSpell] = -402849,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90191] = {
            [questKeys.name] = "Shadow Word: Death",
            [questKeys.startedBy] = {nil,{414646}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 12,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Loot the Remnant on the island and receive the rune."},
            [questKeys.requiredSpell] = -402849,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90192] = {
            [questKeys.name] = "Circle of Healing",
            [questKeys.startedBy] = {{215,909,910},{450009}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 24,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Loot Dark Insight from Defias, then use it on the Secluded Grave north east of Darkshire and receive the rune."},
            [questKeys.requiredSpell] = -402859,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90193] = {
            [questKeys.name] = "Between the Eyes",
            [questKeys.startedBy] = {nil,{405946}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Dusty Chest, two level 10 mobs will spawn, kill them and receive the rune."},
            [questKeys.requiredSpell] = -400081,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90194] = {
            [questKeys.name] = "Between the Eyes",
            [questKeys.startedBy] = {nil,{386777}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Dusty Chest, two level 10 mobs will spawn, kill them and receive the rune."},
            [questKeys.requiredSpell] = -400081,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90195] = {
            [questKeys.name] = "Between the Eyes",
            [questKeys.startedBy] = {nil,{404830}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Dusty Chest and receive the rune."},
            [questKeys.requiredSpell] = -400081,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90196] = {
            [questKeys.name] = "Between the Eyes",
            [questKeys.startedBy] = {nil,{405201}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket the Shipwreck Cache Key from nearby Vile Fin Murlocs, and use it on the Shipwreck Cache next to the ship and receive the rune."},
            [questKeys.requiredSpell] = -400081,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90197] = {
            [questKeys.name] = "Between the Eyes",
            [questKeys.startedBy] = {nil,{407352}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket the Gnarlpine Stash Key from nearby Gnarlpine Furbolgs, and use it on the Gnarlpine stash out on the tree branch and receive the rune."},
            [questKeys.requiredSpell] = -400081,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90198] = {
            [questKeys.name] = "Envenom",
            [questKeys.startedBy] = {{3536},{410847}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Buy a Hot Tip from Kris Legace, and use it on the Rusty Safe under the waterfall in Western Plaguelands to receive the rune."},
            [questKeys.requiredSpell] = -400102,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90199] = {
            [questKeys.name] = "Mutilate",
            [questKeys.startedBy] = {{2038}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Kill Lord Melanas and loot the rune."},
            [questKeys.requiredSpell] = -400094,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90200] = {
            [questKeys.name] = "Mutilate",
            [questKeys.startedBy] = {{6123,208886}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Kill Dark Iron Spies until Blackrats Note drops, then hand it in to Blackrat at Misty Pine Refuge to receive the rune."},
            [questKeys.requiredSpell] = -400094,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90201] = {
            [questKeys.name] = "Shiv",
            [questKeys.startedBy] = {{215,909,910},{450010}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Kill Defias until Engraved Gold Ring drops, then go to the statue in the middle of Raven Hill and /kneel in front of it to receive the rune."},
            [questKeys.requiredSpell] = -424988,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90202] = {
            [questKeys.name] = "Greater Ghost Wolf",
            [questKeys.startedBy] = {{212837}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill the Primordial Anomaly which can spawn around The Charred Vale. It shifts forms so you must use different schools of magic to kill it. Loot it to receive the rune."},
            [questKeys.requiredSpell] = -425343,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90203] = {
            [questKeys.name] = "Way of Earth",
            [questKeys.startedBy] = {{209742}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 12,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Cast Purge on Desert Mirage to receive the rune."},
            [questKeys.requiredSpell] = -410107,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90204] = {
            [questKeys.name] = "Way of Earth",
            [questKeys.startedBy] = {{1773}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Rot Hide Mystics until a Rot Totem drops, use it to spawn a level 15 elite. Kill it to receive the rune."},
            [questKeys.requiredSpell] = -410107,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90205] = {
            [questKeys.name] = "Lava Burst",
            [questKeys.startedBy] = {{2373}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 25,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Mudsnout Shamans until Kajaric Icon drops, equip it and follow its instructions to receieve the rune."},
            [questKeys.requiredSpell] = -410095,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90206] = {
            [questKeys.name] = "Carve",
            [questKeys.startedBy] = {{1115,1116,1117,1118,208711}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Rockjaw Troggs until Rabbit Musk drops, consume it and use Tame Beast on a Rabbit critter, then speak to Toby at Amberstill Ranch to receive the rune."},
            [questKeys.requiredSpell] = -425758,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90207] = {
            [questKeys.name] = "Carve",
            [questKeys.startedBy] = {{2009,2010,2011,2012,2013,2014,2152,209948}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Gnarlpine Furbolgs until Deer Musk drops, consume it and use Tame Beast on a Deer critter, then speak to Raelaeron next to the hunter trainer in Darnassus to receive the rune."},
            [questKeys.requiredSpell] = -425758,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90208] = {
            [questKeys.name] = "Carve",
            [questKeys.startedBy] = {{3111,3114,3113,3112,5824,5826,208184}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Razermane Quillboars until Adder Pheromone drops, consume it and use Tame Beast on an Adder critter, then speak to Razzil in Razor Hill to receive the rune."},
            [questKeys.requiredSpell] = -425758,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90209] = {
            [questKeys.name] = "Carve",
            [questKeys.startedBy] = {{2949,2950,2951,205635}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 7,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Palemane Gnolls until Prairie Dog Musk drops, consume it and use Tame Beast on a Prairie Dog critter, then speak to Takoda Sunmane in Bloodhoof Village to receive the rune."},
            [questKeys.requiredSpell] = -425758,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90210] = {
            [questKeys.name] = "Saber Slash",
            [questKeys.startedBy] = {nil,{407731}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Stonemason's Toolbox on the platform behind the quest givers at Stonewrough Dam to receive the rune."},
            [questKeys.requiredSpell] = -424984,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90211] = {
            [questKeys.name] = "Saber Slash",
            [questKeys.startedBy] = {{210549}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 4,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Approach the Defias Scout in Stealth and Pickpocket them to receive the rune."},
            [questKeys.requiredSpell] = -424984,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90212] = {
            [questKeys.name] = "Saber Slash",
            [questKeys.startedBy] = {nil,{407457}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Take a left from the main gate, go up and around to the right and jump down onto the wall behind the stable and drop on to the roof and open the Stable Hand's Trunk to receive the rune. NOTE: You need 80 Lockpicking to open the trunk."},
            [questKeys.requiredSpell] = -424984,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90213] = {
            [questKeys.name] = "Saber Slash",
            [questKeys.startedBy] = {nil,{409131}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Use Sprint and jump to the Rusty Chest on the platform and open it to receive the rune. NOTE: You need to have learnt Sprint to make the jump, alternatively you can bring a Swiftness Potion."},
            [questKeys.requiredSpell] = -424984,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90214] = {
            [questKeys.name] = "Saber Slash",
            [questKeys.startedBy] = {nil,{414624}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Loot the Lighthouse Stash between the roots of the tree to receive the rune."},
            [questKeys.requiredSpell] = -424984,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90215] = {
            [questKeys.name] = "Water Shield",
            [questKeys.startedBy] = {{1972}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 15,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Grimson the Pale and equip the Icon, follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -410097,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90216] = {
            [questKeys.name] = "Water Shield",
            [questKeys.startedBy] = {nil,{152608,152618,3642}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 14,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Kolkar Centaurs until Kolkar Booty Key drops, then use it on Kolkars' Booty and equip the Icon, follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -410097,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90217] = {
            [questKeys.name] = "Shield Mastery",
            [questKeys.startedBy] = {nil,{450011}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.ORC + raceIDs.TROLL,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find a Galvanic Icon, loot it and equip the Icon, follow its instructions to kill 10 enemies with Lightning Bolt Rank 1 to receive the rune."},
            [questKeys.requiredSpell] = -410098,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90218] = {
            [questKeys.name] = "Shield Mastery",
            [questKeys.startedBy] = {nil,{450012}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 5,
            [questKeys.requiredRaces] = raceIDs.TAUREN,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Find a Galvanic Icon, loot it and equip the Icon, follow its instructions to kill 10 enemies with Lightning Bolt Rank 1 to receive the rune."},
            [questKeys.requiredSpell] = -410098,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90219] = {
            [questKeys.name] = "Molten Blast",
            [questKeys.startedBy] = {{208275}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Gather some Mage and Warlock friends and attack the Frozen Makrura with fire spells."},
            [questKeys.requiredSpell] = -425344,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90220] = {
            [questKeys.name] = "Molten Blast",
            [questKeys.startedBy] = {nil,{404352}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 9,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Bael'dun Dwarves until Artifact Storage Key drops, use it on the Artifact Storage. Equip the Icon and follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -425344,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90221] = {
            [questKeys.name] = "Berserk",
            [questKeys.startedBy] = {nil,{450013}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 28,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Use Challenging Roar on the Beastly Effigy, then Kill Zai'enki. Equip the Icon and follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -424760,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90222] = {
            [questKeys.name] = "Dreamstate",
            [questKeys.startedBy] = {nil,{450015}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 32,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Kol'kar Centaur until Desiccated Seed Pod drops, bring it to the lack in the south east of Desolace, and swim until it becomes a Satyrweed Bulb. Then bring it to Sargeron and plant it in Sandy Loam to receive the rune."},
            [questKeys.requiredSpell] = -410060,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90223] = {
            [questKeys.name] = "Dual Wield Specialization",
            [questKeys.startedBy] = {{217783}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 32,
            [questKeys.questLevel] = 32,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Use Flare when you have the Danger! buff, it will reveal a Bloodscalp Guerrilla which patrols so you may need to cast it a few times, kill it to receive the rune."},
            [questKeys.requiredSpell] = -410116,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90224] = {
            [questKeys.name] = "Intervene",
            [questKeys.startedBy] = {{218019,218020,218021,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 24,
            [questKeys.questLevel] = 24,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Use Execute while wielding a two-handed weapon on the left Combat Dummy, use Taunt whilst dual wielding on the center Combat Dummy, and use Shield Bash on the right Combat Dummy to receive the rune."},
            [questKeys.requiredSpell] = -403472,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90225] = {
            [questKeys.name] = "Rallying Cry",
            [questKeys.startedBy] = {{218273}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Wandering Swordsman, after his RP he will spawn Swordman's Reward, open it to receive the rune."},
            [questKeys.requiredSpell] = -426491,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90226] = {
            [questKeys.name] = "Spellfrost Bolt",
            [questKeys.startedBy] = {{780}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Kill Skullsplitter Mystics until Spell Notes: PELFRB STOLLOTS drops, decipher it to receive the rune."},
            [questKeys.requiredSpell] = -415948,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90227] = {
            [questKeys.name] = "Frostfire Bolt",
            [questKeys.startedBy] = {{780}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Kill Skullsplitter Mystics until Spell Notes: TROFF IRESTBOL drops, decipher it to receive the rune."},
            [questKeys.requiredSpell] = -401762,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90228] = {
            [questKeys.name] = "Rolling with the Punches",
            [questKeys.startedBy] = {nil,{423930}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 30,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Keep opening the chests in the Sizable Stolen Strongbox until you receive the rune."},
            [questKeys.requiredSpell] = -400093,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90229] = {
            [questKeys.name] = "Sacred Shield",
            [questKeys.startedBy] = {nil,{423695}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 18,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Loot the Libram of Deliverance from a book on the bench inside the building. Equip the Libram and follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -416028,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90230] = {
            [questKeys.name] = "Focused Rage",
            [questKeys.startedBy] = {nil,{450014}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Witherbark Trolls until Witherbark Mallet drops, use it on the gong inside of the cave to summon an Witherbark Goliath and two adds. Kill the Goliath and loot it to receive the rune."},
            [questKeys.requiredSpell] = -409163,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90231] = {
            [questKeys.name] = "Spirit of the Alpha",
            [questKeys.startedBy] = {nil,{421568}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 30,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Starting at Freewind Post, take the northern and then the lower bridge to see a chest on a pillar. Either in Ghost Wolf form or with a different speed boost, jump down and loot the chest."},
            [questKeys.requiredSpell] = -410103,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90232] = {
            [questKeys.name] = "Empowered Renew",
            [questKeys.startedBy] = {{2252,2253,10758,10759,10760,10761}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 30,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Defeat Grimtotem Tauren or Crushridge Ogres to receive the rune."},
            [questKeys.requiredSpell] = -425309,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90233] = {
            [questKeys.name] = "Steady Shot",
            [questKeys.startedBy] = {{217836}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 35,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill Needletooth, then loot him to receive the rune."},
            [questKeys.requiredSpell] = -410109,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90234] = {
            [questKeys.name] = "Hot Streak",
            [questKeys.startedBy] = {{217305},{450016}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 16,
            [questKeys.questLevel] = 30,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Cast Flamestrike on the two bellows on the outside of the blacksmith in Strahnbrad until they are glowing red, this will spawn an Ancient Fire Elemental, kill it to receive the rune."},
            [questKeys.requiredSpell] = -401749,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90235] = {
            [questKeys.name] = "Renewed Hope",
            [questKeys.startedBy] = {{4713,218249}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 30,
            [questKeys.questLevel] = 32,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Nagas until they drop Unsettling VIsion, then use Mind Control on a Slitherblade Tide Priestess to acquire her Meditation buff, then use Unsettling Vision to receive the rune."},
            [questKeys.requiredSpell] = -425310,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90236] = {
            [questKeys.name] = "Chronostatic Preservation",
            [questKeys.startedBy] = {{217703}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage friends and defeat the Singed Highperch Consort with frost spells. Combine all three Partial Spell Notes to receive the rune."},
            [questKeys.requiredSpell] = -425189,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90237] = {
            [questKeys.name] = "Chronostatic Preservation",
            [questKeys.startedBy] = {{217669}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage friends and defeat the Scorched Screeching Roguefeather with frost spells. Combine all three Partial Spell Notes to receive the rune."},
            [questKeys.requiredSpell] = -425189,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90238] = {
            [questKeys.name] = "Chronostatic Preservation",
            [questKeys.startedBy] = {{217711}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 28,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Gather some Mage friends and attack Galak Centaur to loot a Cougar Cage Key. Open the cage and defeat the Seared Needles Cougar with frost spells. Combine all three Partial Spell Notes to receive the rune."},
            [questKeys.requiredSpell] = -425189,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90239] = {
            [questKeys.name] = "Fire Nova: Step 1",
            [questKeys.startedBy] = {{217392}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Defeat Flameseer Dubelen and loot the Corrupted Fire Totem. Then head to Maraudon."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90240] = {
            [questKeys.name] = "Fire Nova: Step 2",
            [questKeys.startedBy] = {nil,{422895,422896}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Loot both Tears of Theradras. One in the purple wing and the other in the orange wing of the entrance cave, not the dungeon itself. Then head to Orgrimmar."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90241] = {
            [questKeys.name] = "Fire Nova: Step 3",
            [questKeys.startedBy] = {{4047}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Talk to Zor Lonetree, who sends you to Arch Druid Hamuul Runetotem in Thunder Bluff."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90242] = {
            [questKeys.name] = "Fire Nova: Step 4",
            [questKeys.startedBy] = {{5769}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Talk to Arch Druid Hamuul Runetotem, who sends you to Tal in Thunder Bluff."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90243] = {
            [questKeys.name] = "Fire Nova: Step 5",
            [questKeys.startedBy] = {{2995}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Talk to Tal in Thunder Bluff to travel to Moonglade."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90244] = {
            [questKeys.name] = "Fire Nova: Step 6",
            [questKeys.startedBy] = {{11832}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Talk to Keeper Remulos in Moonglade to receive Elemental Salve."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90245] = {
            [questKeys.name] = "Fire Nova: Final Step",
            [questKeys.startedBy] = {nil,{450017}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Loot the Elemental Salve and use it to receive the rune."},
            [questKeys.requiredSpell] = -410093,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90246] = {
            [questKeys.name] = "Power Surge",
            [questKeys.startedBy] = {nil,{450018}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Defeat Boulderfist Ogre to receive a Ogre Lightning Rod and place it in the Soft Soil on top of the mountain. Then hit the Lightning Rod with Lightning Bolt ten times to summon Tam'kar. Defeat him to receive the rune."},
            [questKeys.requiredSpell] = -416054,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90247] = {
            [questKeys.name] = "Decoy Totem",
            [questKeys.startedBy] = {{217683}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Collect either 3 Cloud Serpent Fangs from any Cloud Serpent or 10 Strong Harpy Feather from any Harpy. Bring these together with a Silken Thread (e.g. bought from Jandia in Freewind Post) to the altar and create the Offering to the Wind Spirit. Then jump off the cliff to receive the rune."},
            [questKeys.requiredSpell] = -425882,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90248] = {
            [questKeys.name] = "Enlightened Judgements",
            [questKeys.startedBy] = {{217387}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {
                "Kill Humanoids in Arathi Highlands and collect Tarnished Prayer Bead I, II and III. Purify all three before combining them to the Rosary of the Light, which you bring to Brother Atticus in Stromgarde Keep.",
                "Purify Bead I: Cast Blessing of Might while in combat and defeat an enemy.",
                "Purify Bead II: Cast Divine Shield with less than 10% HP.",
                "Purify Bead III: Unleash Seal of Justice on a fleeing enemy.",
            },
            [questKeys.requiredSpell] = -426175,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90249] = {
            [questKeys.name] = "Guarded by the Light",
            [questKeys.startedBy] = {nil,{423841}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Loot the Dormant Holy Rune, cast Divine Intervention (anywhere) and be resurrected by another player before releasing your spirit to receive the rune."},
            [questKeys.requiredSpell] = -416035,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90250] = {
            [questKeys.name] = "Aeonas Whereabouts",
            [questKeys.startedBy] = {{3179}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Talk to Harold Riggs to find out more about Aeonas whereabouts."},
            [questKeys.preQuestSingle] = {79940},
            [questKeys.exclusiveTo] = {79945},
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90251] = {
            [questKeys.name] = "Invigoration",
            [questKeys.startedBy] = {{217412}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Buy an Entomology Starter Kit to receive a Bug Catching Net and a Field Guide. Then catch all three bugs listed in the Field Guide and bring them to Amaryllis Webb."},
            [questKeys.requiredSpell] = -416089,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90252] = {
            [questKeys.name] = "Invigoration",
            [questKeys.startedBy] = {{217588}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Catch a Arbor Tarantula with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -416089,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90253] = {
            [questKeys.name] = "Invigoration",
            [questKeys.startedBy] = {{217589}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Catch a Hay Weevil with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -416089,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90254] = {
            [questKeys.name] = "Invigoration",
            [questKeys.startedBy] = {{217590}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Catch a Flesh Picker with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -416089,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90255] = {
            [questKeys.name] = "Invocation",
            [questKeys.startedBy] = {{2590}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Defeat Syndicate Conjuror to receive 10 Conjuror's Pendant and use Drain Soul on the Voidwalker Minions to receive a Soul of the Void. Combine both to spawn a Void Seeker and defeat it to receive the rune."},
            [questKeys.requiredSpell] = -426443,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90256] = {
            [questKeys.name] = "Shadowflame",
            [questKeys.startedBy] = {nil,{419741}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Cast Shadow Ward and start the summoning ritual. Defeat Seductress Ceeyna to receive the rune."},
            [questKeys.requiredSpell] = -426467,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90257] = {
            [questKeys.name] = "Dance of the Wicked",
            [questKeys.startedBy] = {{217620}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Talk to the Reckless Warlock to receive Brimstone Carving. Then use Hellfire to damage yourself for a chance to receive the rune."},
            [questKeys.requiredSpell] = -416017,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90258] = {
            [questKeys.name] = "Graveyard Echo",
            [questKeys.startedBy] = {nil,{424266}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect the Graveyard Echo and bring it to the Scarlet Monastery Library, together with the other three echos."},
            [questKeys.requiredSpell] = -402855,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90259] = {
            [questKeys.name] = "Arathi Echo",
            [questKeys.startedBy] = {nil,{424267}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect the Arathi Echo and bring it to the Scarlet Monastery Library, together with the other three echos."},
            [questKeys.requiredSpell] = -402855,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90260] = {
            [questKeys.name] = "Theramore Echo",
            [questKeys.startedBy] = {nil,{424264}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect the Theramore Echo and bring it to the Scarlet Monastery Library, together with the other three echos."},
            [questKeys.requiredSpell] = -402855,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90261] = {
            [questKeys.name] = "Swamp Echo",
            [questKeys.startedBy] = {nil,{424265}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect the Swamp Echo and bring it to the Scarlet Monastery Library, together with the other three echos."},
            [questKeys.requiredSpell] = -402855,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90262] = {
            [questKeys.name] = "Pain Suppression",
            [questKeys.startedBy] = {nil,{425896}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {
                "Bring all four Echoes to the Scarlet Monastery Library. In one of the first hallways you find statues. Activate them in the following order:",
                "Warrior, Mage, Paladin and Priest."
            },
            [questKeys.requiredSpell] = -402855,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90263] = {
            [questKeys.name] = "Pain Suppression",
            [questKeys.startedBy] = {nil,{428228}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Disarm the Dart Trap and loot the Conspicuous Cache to receive the rune."},
            [questKeys.requiredSpell] = -400096,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90264] = {
            [questKeys.name] = "Master of Subtlety",
            [questKeys.startedBy] = {{218230,218229}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {
                "Talk to Wendel Mathers and free him with a Compoud Cage Key you can pickpocket from the nearby Kurzen mobs.",
                "Afterwards talk to Captain Aransas in Booty Bay to receive the rune. Hold on to the Jani's Charm, you'll get as a bonus."
            },
            [questKeys.requiredSpell] = -425103,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90265] = {
            [questKeys.name] = "Survival Instincts",
            [questKeys.startedBy] = {{217412}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Buy an Entomology Starter Kit to receive a Bug Catching Net and a Field Guide. Then catch all three bugs listed in the Field Guide and bring them to Amaryllis Webb."},
            [questKeys.requiredSpell] = -410027,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90266] = {
            [questKeys.name] = "Survival Instincts",
            [questKeys.startedBy] = {{217588}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Catch a Arbor Tarantula with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -410027,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90267] = {
            [questKeys.name] = "Survival Instincts",
            [questKeys.startedBy] = {{217589}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Catch a Hay Weevil with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -410027,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90268] = {
            [questKeys.name] = "Survival Instincts",
            [questKeys.startedBy] = {{217590}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Catch a Flesh Picker with the Bug Catching Net and bring it together with the other two bugs to Amaryllis Webb in the Swamp of Sorrows."},
            [questKeys.requiredSpell] = -410027,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90269] = {
            [questKeys.name] = "Gale Winds",
            [questKeys.startedBy] = {{222286}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 43,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Defeat Namida Grimtotem to receive the rune."},
            [questKeys.requiredSpell] = -431451,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90270] = {
            [questKeys.name] = "Gore",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Buy the Gore rune from the Quartermaster (no reputation required)."},
            [questKeys.requiredSpell] = -431447,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90271] = {
            [questKeys.name] = "Raptor Fury",
            [questKeys.startedBy] = {{222243}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 43,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Defeat Zopilote to receive the rune."},
            [questKeys.requiredSpell] = -416093,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90272] = {
            [questKeys.name] = "T.N.T",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Buy the T.N.T rune from the Quartermaster (no reputation required)."},
            [questKeys.requiredSpell] = -431611,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90273] = {
            [questKeys.name] = "Molten Armor",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Buy the Molten Armor rune from the Quartermaster (no reputation required)."},
            [questKeys.requiredSpell] = -429308,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90274] = {
            [questKeys.name] = "Improved Hammer of Wrath",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Buy the Improved Hammer of Wrath rune from the Quartermaster (no reputation required)."},
            [questKeys.requiredSpell] = -429261,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90275] = {
            [questKeys.name] = "Wrath",
            [questKeys.startedBy] = {{221828,221827}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Use Sense Undead, to find a Vengeful Spirit, kill it and go to Ironforge and speak with Magister Falath to receive the rune."},
            [questKeys.requiredSpell] = -429249,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90276] = {
            [questKeys.name] = "Void Zone",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Buy the Void Zone rune from the Quartermaster (no reputation required)."},
            [questKeys.requiredSpell] = -431705,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90277] = {
            [questKeys.name] = "Cut to the Chase",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Buy the Cut to the Chase rune from the Quartermaster (no reputation required)."},
            [questKeys.requiredSpell] = -432297,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90278] = {
            [questKeys.name] = "Burn",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Buy the Burn rune from the Quartermaster (no reputation required)."},
            [questKeys.requiredSpell] = -416066,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90279] = {
            [questKeys.name] = "Unstable Affliction",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Buy the Unstable Affliction rune from the Quartermaster (no reputation required)."},
            [questKeys.requiredSpell] = -431747,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90280] = {
            [questKeys.name] = "Shield Mastery",
            [questKeys.startedBy] = {{222685,222687,222684,222686}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 23,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Buy the Shield Mastery rune from the Quartermaster (no reputation required)."},
            [questKeys.requiredSpell] = -431747,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90281] = {
            [questKeys.name] = "Rampage",
            [questKeys.startedBy] = {{222233}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 43,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defeat Ohk'zi to receive the rune."},
            [questKeys.requiredSpell] = -427081,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90282] = {
            [questKeys.name] = "Vigilance",
            [questKeys.startedBy] = {{222726}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Defeat Tyrant of the Hive to receive the rune."},
            [questKeys.requiredSpell] = -427078,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90283] = {
            [questKeys.name] = "Wrecking Crew",
            [questKeys.startedBy] = {{2649,2650,2651,2652,2653}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Kill Trolls and Spiders until they drop a Geode Hammer, equip it and continue attacking enemies until it breaks, then open it to receive the rune."},
            [questKeys.requiredSpell] = -427084,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90284] = {
            [questKeys.name] = "Immolation Aura",
            [questKeys.startedBy] = {{221282,221283,221292}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Collect Dreampyre Fire, Dreamsworn Horn and Dreamhunter Fang from imps, satyrs and hounds and combine them to receive the rune."},
            [questKeys.requiredSpell] = -431758,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90285] = {
            [questKeys.name] = "Summon Felguard",
            [questKeys.startedBy] = {{222228,222288,222696,222697,222698}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Send an Explorer Imp through a Fel Portal and open the returned Otherworldly Treasure to receive the rune."},
            [questKeys.requiredSpell] = -431756,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90286] = {
            [questKeys.name] = "Static Shock",
            [questKeys.startedBy] = {{223061}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 42,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Activate the Charged Totem, and ensure you and your partner are within range of the totem and keep Lightning Shield on yourself. Kill mobs that spawn until a Whirling Tempest appears, kill it to receive the rune. NOTE: This rune requires 2 players."},
            [questKeys.requiredSpell] = -432238,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90287] = {
            [questKeys.name] = "Mental Dexterity",
            [questKeys.startedBy] = {{5616,5617},{450019}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 43,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Wastewander mobs until they drop Coded Warlock Notes and Wastewander Cipher, combine them and go to the Cryptic Scroll of Summoning, stand on it and use the Deciphered Warlock Notes. Kill the Enraged Voidwalker to receive the rune."},
            [questKeys.requiredSpell] = -416055,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90288] = {
            [questKeys.name] = "Pain and Suffering",
            [questKeys.startedBy] = {{5616,5617},{450019}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 43,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Wastewander mobs until they drop Coded Warlock Notes and Wastewander Cipher, combine them and go to the Cryptic Scroll of Summoning, stand on it and use the Deciphered Warlock Notes. Kill the Enraged Voidwalker to receive the rune."},
            [questKeys.requiredSpell] = -415991,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90289] = {
            [questKeys.name] = "Taste for Blood",
            [questKeys.startedBy] = {{222546},{441912,441913,441914,441915,450020}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Collect Giant Golem Feet and Arms and take them to the eastern section of Searing Gorge, combine the golem parts to summon Iodax, kill him to receive the rune."},
            [questKeys.requiredSpell] = -427076,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90290] = {
            [questKeys.name] = "Improved Barkskin",
            [questKeys.startedBy] = {{5481,5485}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 44,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Thistleshrub Dew Collectors and Thistleshrub Rootshapers until they drop the Idol of the Raging Shambler, equip it and follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -431449,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90291] = {
            [questKeys.name] = "Focus Fire",
            [questKeys.startedBy] = {nil,{442404}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Walk across the long branch to a Stormcrow Nest, loot the nest and kill the Enraged Stormcrow to receive the rune."},
            [questKeys.requiredSpell] = -431601,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90292] = {
            [questKeys.name] = "Catlike Reflexes",
            [questKeys.startedBy] = {{222376,222406}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Find the Groddoc Infant in the yeti cave and feed it either Soft Banana Bread or Tel'Abim Banana and bring it to the Groddoc Matriarch in the east within 10 minutes to receive the rune."},
            [questKeys.requiredSpell] = -416083,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90293] = {
            [questKeys.name] = "Balefire Bolt",
            [questKeys.startedBy] = {{222228,222288,222696,222697,222698}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 1,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Get a Scroll of Spatial Mending from an enchanter or the auction house, then find Fel Portals throughout Azeroth and close one to receive the rune."},
            [questKeys.requiredSpell] = -429311,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90294] = {
            [questKeys.name] = "Unfair Advantage",
            [questKeys.startedBy] = {{7855,7856,8139}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 44,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket Southsea Pirates and Southsea Freebooters until you receive a Kidnapper's Coin Purse, open it to get a Precious Medallion, bring it to Jabbey in Steamwheedle Port to receive the rune."},
            [questKeys.requiredSpell] = -432301,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90295] = {
            [questKeys.name] = "Carnage",
            [questKeys.startedBy] = {nil,{442405}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Climb the tower, and open the Abandoned Cache, it will spawn a Murderous Lost One, kill it to receive the rune. NOTE: The Abandoned Cache requires 225 Lockpicking skill."},
            [questKeys.requiredSpell] = -432299,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90296] = {
            [questKeys.name] = "Focused Attacks",
            [questKeys.startedBy] = {nil,{442397}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 45,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Blind the Vilebranch Mask, and loot the Treasure of the Bat to receive the rune."},
            [questKeys.requiredSpell] = -432291,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90297] = {
            [questKeys.name] = "Tidal Waves",
            [questKeys.startedBy] = {nil,{442688,442685}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Loot the Old Crate behind the empty tent and loot the Old Key, then go to the bottom of the waterfall and open the Old Chest to receive the rune. NOTE: Opening the Old Chest will spawn 4 non-elite elementals."},
            [questKeys.requiredSpell] = -432234,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90298] = {
            [questKeys.name] = "Rolling Thunder",
            [questKeys.startedBy] = {{222856,222857}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 20,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Click the Odd Totem which will give you the Totem Challenge debuff which increases your damage taken by 50%, quickly run to the opposite Odd Totem and click it. Open the chest to receive the rune."},
            [questKeys.requiredSpell] = -432236,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90299] = {
            [questKeys.name] = "Elune's Fires",
            [questKeys.startedBy] = {{6375},{441865,441870}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 18,
            [questKeys.questLevel] = 46,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Go inside the temple and loot the Traveller's Knapsack, open it and read Keldara's Log. Then go find 3 Satyrweed Brambles and combine them with the Mortar and Pestle found in the knapsack. Then find a Thunderhead Hippogryph with the Satyr Corruption debuff, use Hibernate on them and then use the Satyrweed Tincture to dispel the debuff, you will then receive the rune."},
            [questKeys.requiredSpell] = -416051,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90300] = {
            [questKeys.name] = "Displacement",
            [questKeys.startedBy] = {{222405}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 47,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Collect Worldcore Fragments or Scroll of Geomancy to have four in total. Then visit all four Leyline Confluxes found in Feralas, Hinterlands, Azshara and Searing Gorge and attune to them with the collected items. Kill the Enraged Leywalker, and loot it to receive a Leycryst. Combine all four to receive the rune."},
            [questKeys.requiredSpell] = -429309,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90301] = {
            [questKeys.name] = "Purifying Power",
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Collect Worldcore Fragments or Scroll of Geomancy to have four in total. Then visit all four Leyline Confluxes found in Feralas, Hinterlands, Azshara and Searing Gorge and attune to them with the collected items. Kill the Enraged Leywalker, and loot it to receive a Leycryst. Combine all four to receive the rune."},
            [questKeys.requiredSpell] = -429255,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90302] = {
            [questKeys.name] = "Surge of Light",
            [questKeys.startedBy] = {{223591}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 1,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Echo of a Lost Soul to receive the rune. NOTE: This mob only spawns between 21:00 and 06:00 server time, and only takes damage from arcane spells. You might want to bring an arcane damage wand with you."},
            [questKeys.requiredSpell] = -431669,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90303] = {
            [questKeys.name] = "Despair",
            [questKeys.startedBy] = {{222405}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 47,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Collect Worldcore Fragments or Scroll of Geomancy to have four in total. Then visit all four Leyline Confluxes found in Feralas, Hinterlands, Azshara and Searing Gorge and attune to them with the collected items. Kill the Enraged Leywalker, and loot it to receive a Leycryst. Combine all four to receive the rune."},
            [questKeys.requiredSpell] = -431673,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90304] = {
            [questKeys.name] = "Eye of the Void",
            [questKeys.startedBy] = {{223590},{445039,445036,445037,445044,445041,445040,445042}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Find 7 eyes around Azeroth, and head to Azshara where you'll find the Shrine of the Watcher, target it and /kneel, hand in the quest to receive the rune."},
            [questKeys.requiredSpell] = -402864,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90305] = {
            [questKeys.name] = "Pandemic",
            [questKeys.startedBy] = {{223123},{443727,443728}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 43,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Loot the Grimtotem Chest and Woodpaw Bag and combine the Grimtotem Necklace and Broken Woodpaw Staff, then use the Diseased Nature Staff on a Diseased Forest Walker and kill it to receive the rune."},
            [questKeys.requiredSpell] = -431743,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90306] = {
            [questKeys.name] = "Backdraft",
            [questKeys.startedBy] = {{222405}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 47,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Collect Worldcore Fragments or Scroll of Geomancy to have four in total. Then visit all four Leyline Confluxes found in Feralas, Hinterlands, Azshara and Searing Gorge and attune to them with the collected items. Kill the Enraged Leywalker, and loot it to receive a Leycryst. Combine all four to receive the rune."},
            [questKeys.requiredSpell] = -431745,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90307] = {
            [questKeys.name] = "Improved Swipe",
            [questKeys.startedBy] = {{6505,6506,6507,6508,}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Venomhide Ravasaurs until Idol of the Huntress drops, equip it and follow its instructions to receive the rune."},
            [questKeys.requiredSpell] = -439765,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90308] = {
            [questKeys.name] = "Starfall",
            [questKeys.startedBy] = {{228814}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 58,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Kill Arcterris to receive the rune. NOTE: This is an elite mob, and may require a group."},
            [questKeys.requiredSpell] = -439770,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90309] = {
            [questKeys.name] = "Tree of Life",
            [questKeys.startedBy] = {{228596}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Talk to the Vengeful Wisp and kill Satyrs in Jadefire Run until you get the 'Shimmering Light' buff. Then talk to the wisp again and it will put Gift of the Wisp on the ground, loot it to receive the rune."},
            [questKeys.requiredSpell] = -439767,
            [questKeys.zoneOrSort] = sortKeys.DRUID,
        },
        [90310] = {
            [questKeys.name] = "Axe Specialization",
            [questKeys.startedBy] = {nil,{457101}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER + classIDs.PALADIN + classIDs.SHAMAN + classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Read the book 'The Rites of Mak'Gora' to receive the rune."},
            [questKeys.requiredSpell] = -453688,
            [questKeys.zoneOrSort] = zoneIDs.BURNING_STEPPES,
        },
        [90311] = {
            [questKeys.name] = "Frozen Orb",
            [questKeys.startedBy] = {{7156,7157,7158}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 52,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Kill Deadwood Furbolgs till you receive a Myserious Darnassian Scroll. Decipher and bring it to Calyx Greenglow in Felwood."},
            [questKeys.requiredSpell] = -440858,
            [questKeys.exclusiveTo] = {84369},
            [questKeys.zoneOrSort] = zoneIDs.MAGE,
        },
        [90312] = {
            [questKeys.name] = "Vampiric Touch",
            [questKeys.startedBy] = {{227028}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 55,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill Hellscream's Phantom, the final boss in the Demon Fall Canyon dungeon and loot him to receive the rune."},
            [questKeys.requiredSpell] = -402857,
            [questKeys.zoneOrSort] = classIDs.PRIEST,
        },
        [90313] = {
            [questKeys.name] = "Arcane Specialization",
            [questKeys.startedBy] = {nil,{457102}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID + classIDs.HUNTER + classIDs.MAGE,
            [questKeys.objectivesText] = {"Read the book 'Elements for Dummies Volume III: Arcane' to receive the rune. NOTE: The book is located at the top of Hearthglen tower, near a Scarlet Priest."},
            [questKeys.requiredSpell] = -453695,
            [questKeys.zoneOrSort] = zoneIDs.WESTERN_PLAGUELANDS,
        },
        [90314] = {
            [questKeys.name] = "Defense Specialization",
            [questKeys.startedBy] = {nil,{457099}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID + classIDs.PALADIN + classIDs.ROGUE + classIDs.SHAMAN + classIDs.WARLOCK + classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Read the book 'Zirene's Guide to Getting Punched' to receive the rune. NOTE: The book is located near the LBRS entrance, in the hallway behind the meeting stone."},
            [questKeys.requiredSpell] = -459313,
            [questKeys.zoneOrSort] = zoneIDs.SEARING_GORGE,
        },
        [90315] = {
            [questKeys.name] = "Feral Combat Specialization",
            [questKeys.startedBy] = {nil,{457098}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID,
            [questKeys.objectivesText] = {"Read the book 'Finding Your Inner Feline: A Guide to Modern Druidism' to receive the rune. NOTE: The book is located in the cat den guarded by two level 55 Frostsabers."},
            [questKeys.requiredSpell] = -453703,
            [questKeys.zoneOrSort] = classIDs.DRUID,
        },
        [90316] = {
            [questKeys.name] = "Frost Specialization",
            [questKeys.startedBy] = {nil,{457095}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER + classIDs.MAGE + classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Read the book 'Elements for Dummies Volume I: Frost' to receive the rune. NOTE: The book is located in the Owlbeast camp."},
            [questKeys.requiredSpell] = -453697,
            [questKeys.zoneOrSort] = zoneIDs.WINTERSPRING,
        },
        [90317] = {
            [questKeys.name] = "Holy Specialization",
            [questKeys.startedBy] = {nil,{457094}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN + classIDs.PRIEST,
            [questKeys.objectivesText] = {"Read the book 'The True Nature of the Light' to receive the rune. NOTE: The book is located on top of a bookshelf in the Library of the northern building."},
            [questKeys.requiredSpell] = -453702,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [90318] = {
            [questKeys.name] = "Nature Specialization",
            [questKeys.startedBy] = {nil,{457092}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID + classIDs.ROGUE + classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Read the book 'The Fury of Stormrage' to receive the rune. NOTE: The book is located near Chieftan Bloodmaw at Felpaw Village."},
            [questKeys.requiredSpell] = -453698,
            [questKeys.zoneOrSort] = zoneIDs.FELWOOD,
        },
        [90319] = {
            [questKeys.name] = "Ranged Weapon Specialization",
            [questKeys.startedBy] = {nil,{457090}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER + classIDs.ROGUE + classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Read the book 'Famous (and Infamous) Rangers of Azeroth' to receive the rune. NOTE: The book is located in the Marris Stead."},
            [questKeys.requiredSpell] = -453692,
            [questKeys.zoneOrSort] = zoneIDs.EASTERN_PLAGUELANDS,
        },
        [90320] = {
            [questKeys.name] = "Shadow Specialization",
            [questKeys.startedBy] = {nil,{457089}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST + classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Read the book 'The Shadow Connection' to receive the rune. NOTE: The book is located on the alter in the Tainted Scar."},
            [questKeys.requiredSpell] = -453700,
            [questKeys.zoneOrSort] = zoneIDs.BLASTED_LANDS,
        },
        [90321] = {
            [questKeys.name] = "Rune of Healing Specialization",
            [questKeys.startedBy] = {nil,{499987}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN + classIDs.PRIEST + classIDs.SHAMAN + classIDs.DRUID + classIDs.MAGE,
            [questKeys.requiredSpell] = -468761,
            [questKeys.zoneOrSort] = zoneIDs.ARATHI_HIGHLANDS,
        },
        [90322] = {
            [questKeys.name] = "Rune of Meditation Specialization",
            [questKeys.startedBy] = {nil,{499988}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 40,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN + classIDs.PRIEST + classIDs.SHAMAN + classIDs.DRUID + classIDs.MAGE,
            [questKeys.requiredSpell] = -468763,
            [questKeys.zoneOrSort] = zoneIDs.THOUSAND_NEEDLES,
        },
        [90323] = {
            [questKeys.name] = "Light's Grace",
            [questKeys.startedBy] = {{220930,218240,214954}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Position yourself on top of the pillar with your back towards Frix Xizzix. Set 'Gadgetzan' to 'at War' and attack the dragon Tower Defense Automaton. It will eventually knock you off the platform towards Frix Xizzix, which you need to heal up. Once you get the 'Feeling much better, thank you!' buff, go to Booty Bay and buy the rune from Rix Xizzix."},
            [questKeys.requiredSpell] = -429242,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90324] = {
            [questKeys.name] = "Rune of Overcharged",
            [questKeys.startedBy] = {{222044}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 45,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Position yourself on top of the pillar with your back towards Frix Xizzix. Set 'Gadgetzan' to 'at War' and attack the dragon Tower Defense Automaton. It will eventually knock you off the platform towards Frix Xizzix, which you need to heal up. Once you get the 'Feeling much better, thank you!' buff, go to Booty Bay and buy the rune from Rix Xizzix."},
            [questKeys.preQuestGroup] = {81968,82074,82075,82076},
            [questKeys.requiredSpell] = -432140,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90325] = {
            [questKeys.name] = "Rune of Dagger Specialization",
            [questKeys.startedBy] = {nil,{457100}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID + classIDs.HUNTER + classIDs.MAGE + classIDs.PRIEST + classIDs.ROGUE + classIDs.SHAMAN + classIDs.WARLOCK + classIDs.WARRIOR,
            [questKeys.requiredSpell] = -453690,
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
        },
        [90326] = {
            [questKeys.name] = "Rune of Fire Specialization",
            [questKeys.startedBy] = {nil,{457097}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE + classIDs.HUNTER + classIDs.SHAMAN + classIDs.WARLOCK,
            [questKeys.requiredSpell] = -453696,
            [questKeys.zoneOrSort] = zoneIDs.SEARING_GORGE,
        },
        [90327] = {
            [questKeys.name] = "Rune of Fist Weapon Specialization",
            [questKeys.startedBy] = {nil,{457096}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID + classIDs.HUNTER + classIDs.ROGUE + classIDs.SHAMAN + classIDs.WARRIOR,
            [questKeys.requiredSpell] = -453691,
            [questKeys.zoneOrSort] = zoneIDs.SILITHUS,
        },
        [90328] = {
            [questKeys.name] = "Rune of Mace Specialization",
            [questKeys.startedBy] = {nil,{457093}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID + classIDs.PALADIN + classIDs.PRIEST + classIDs.ROGUE + classIDs.SHAMAN + classIDs.WARRIOR,
            [questKeys.requiredSpell] = -453689,
            [questKeys.zoneOrSort] = zoneIDs.WETLANDS,
        },
        [90329] = {
            [questKeys.name] = "Rune of Pole Weapon Specialization",
            [questKeys.startedBy] = {nil,{457091}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.DRUID + classIDs.HUNTER + classIDs.MAGE + classIDs.PALADIN + classIDs.PRIEST + classIDs.SHAMAN + classIDs.WARLOCK + classIDs.WARRIOR,
            [questKeys.requiredSpell] = -453694,
            [questKeys.zoneOrSort] = zoneIDs.AZSHARA,
        },
        [90330] = {
            [questKeys.name] = "Rune of Sword Specialization",
            [questKeys.startedBy] = {nil,{457088}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER + classIDs.MAGE + classIDs.PALADIN + classIDs.ROGUE + classIDs.WARLOCK + classIDs.WARRIOR,
            [questKeys.requiredSpell] = -453635,
            [questKeys.zoneOrSort] = zoneIDs.DEADWIND_PASS,
        },
        [90331] = {
            [questKeys.name] = "Resourcefulness: Step 1",
            [questKeys.startedBy] = {{8606,8607,16117}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Defeat Plagued Swine until you loot Tainted Boar Meat, then kill Living Decay and Rotting Sludge until you loot a Bubbling Green Ichor. Combine both items to create a Rancid Hunk of Flesh."},
            [questKeys.requiredSpell] = -440557,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90332] = {
            [questKeys.name] = "Resourcefulness: Step 2",
            [questKeys.startedBy] = {{8603}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Use the Rancid Hunk of Flesh on a Carrion Grub, it will create a Regurgitated Skeleton. Loot this to receive the rune."},
            [questKeys.requiredSpell] = -440557,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90333] = {
            [questKeys.name] = "Hit and Run",
            [questKeys.startedBy] = {{227746}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill the Escaped Core Hound. Loot it to receive the rune."},
            [questKeys.requiredSpell] = -440563,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90334] = {
            [questKeys.name] = "Improved Volley: Step 1",
            [questKeys.startedBy] = {{11880,11736,12179,15213,227951}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Kill any mobs in Silithus, until you loot Busted Gizmo, bring this to Edwi Copperbolt at Bronzebeard's Encampment."},
            [questKeys.requiredSpell] = -440560,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90335] = {
            [questKeys.name] = "Improved Volley: Step 2",
            [questKeys.startedBy] = {{227493,227951}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.HUNTER,
            [questKeys.objectivesText] = {"Using the Desert Sonar obtained in the last step, find the area where the ground moves, and use it. Kill the summoned Sandworm, and loot it to receive the rune."},
            [questKeys.requiredSpell] = -440560,
            [questKeys.zoneOrSort] = sortKeys.HUNTER,
        },
        [90336] = {
            [questKeys.name] = "Overheat",
            [questKeys.startedBy] = {{227324,227385,227386,227387}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.MAGE,
            [questKeys.objectivesText] = {"Unfreeze the Novice Frost Mage at each of the farms on the map with fire spells without killing them. Then use Remove Lesser Curse and speak with them. Each will give you a page, combine all 4 to receive the rune."},
            [questKeys.requiredSpell] = -401764,
            [questKeys.zoneOrSort] = sortKeys.MAGE,
        },
        [90337] = {
            [questKeys.name] = "Fan of Knives",
            [questKeys.startedBy] = {nil,{462432}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Find the Wooden Chest, iteract with it and input the code 'Frostsaber, Owl, Bear, Owl' to unlock it and receive the rune."},
            [questKeys.requiredSpell] = -436609,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90338] = {
            [questKeys.name] = "Storm, Earth, and Fire",
            [questKeys.startedBy] = {{7158}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Deadwood Shaman until Voltaic Icon drops, equip it and bring three enemies to low health at once, then kill all three with a single cast of Chain Lightning and use the Voltaic Icon to receive the rune."},
            [questKeys.requiredSpell] = -440634,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90339] = {
            [questKeys.name] = "Feral Spirit",
            [questKeys.startedBy] = {{226982}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 60,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Speak to Frijidar, and kill it to receive the rune."},
            [questKeys.requiredSpell] = -440630,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90340] = {
            [questKeys.name] = "Coherence",
            [questKeys.startedBy] = {{7032}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.SHAMAN,
            [questKeys.objectivesText] = {"Kill Greater Obsidian Elements until Molten Obsidian Core drops, travel to a pool of standing water (Loch Modan is perfect for this) and walk into it to create a Sooty Obsidian Core, then use it to polish it and receive the rune."},
            [questKeys.requiredSpell] = -416062,
            [questKeys.zoneOrSort] = sortKeys.SHAMAN,
        },
        [90341] = {
            [questKeys.name] = "Mark of Chaos",
            [questKeys.startedBy] = {{1783,226799}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Drain Soul on Skeletal Flayer until you have 3 Plagued Soul Shards, then head to Pixi Pilfershard in Chillwind Camp, and hand them in to receive the rune."},
            [questKeys.requiredSpell] = -440924,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90342] = {
            [questKeys.name] = "Mark of Chaos",
            [questKeys.startedBy] = {{1783,226797}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use Drain Soul on Skeletal Flayer until you have 3 Plagued Soul Shards, then head to Prazik Pilfershard in The Bulwark, and hand them in to receive the rune."},
            [questKeys.requiredSpell] = -440924,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90343] = {
            [questKeys.name] = "Infernal Armor: Step 1",
            [questKeys.startedBy] = {{6004,6006}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Kill Shadowsworn Cultist and Adepts until you have a Shadowsworn Note, enter the cave and get to the altar at the end of the cave."},
            [questKeys.requiredSpell] = -440926,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90344] = {
            [questKeys.name] = "Infernal Armor: Step 2",
            [questKeys.startedBy] = {{228414}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"You will need a Greater Spellstone, Shadow Ward, and then cast Sacrifice on your Voidwalker. Once done, then click the altar to perform a Shadow Ritual of Great Sacrifice. After surviving the ritual, kill Heliath to receive the rune."},
            [questKeys.requiredSpell] = -440926,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90345] = {
            [questKeys.name] = "Blunderbuss",
            [questKeys.startedBy] = {nil,{179498,456874,456876,456877,456879,456883}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Use Pick Lock on Scarlet Footlockers until you have a Sending Sigil. Bring this to the 4 pillars located in Eastern Plaguelands, interact with all of them and you will be teleported to a house, open Adon's Trunk inside to receive the rune."},
            [questKeys.requiredSpell] = -415922,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90346] = {
            [questKeys.name] = "Crimson Tempest: Step 1",
            [questKeys.startedBy] = {{1883},{463540}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Pickpocket or kill Scarlet Workers until you have a Toolbox Key, then use it on the Scarlet Toolbox and loot the Rusty Crowbar."},
            [questKeys.requiredSpell] = -415918,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90347] = {
            [questKeys.name] = "Crimson Tempest: Step 2",
            [questKeys.startedBy] = {nil,{461632}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Use the Rusty Crowbar to open the Marked Crate on top of the middle tower, and loot the Hidden Bundle. Open it to receive a Safe Box Key."},
            [questKeys.requiredSpell] = -415918,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90348] = {
            [questKeys.name] = "Crimson Tempest: Step 3",
            [questKeys.startedBy] = {nil,{461633}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.ROGUE,
            [questKeys.objectivesText] = {"Use the Safe Box Key to open Belavus' Safe Box on the middle floor of the northern tower to receive the rune."},
            [questKeys.requiredSpell] = -415918,
            [questKeys.zoneOrSort] = sortKeys.ROGUE,
        },
        [90349] = {
            [questKeys.name] = "Soul Warding: Step 1",
            [questKeys.startedBy] = {{11082,227511},{461633}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Kill the Stratholme Couriers and get postbox keys, then use these on the mailboxes to get Stratholme Shadow Jar. You will need 3 of these for the next step."},
            [questKeys.requiredSpell] = -402850,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90350] = {
            [questKeys.name] = "Soul Warding: Step 2",
            [questKeys.startedBy] = {{11082,227511},{461633}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 55,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PRIEST,
            [questKeys.objectivesText] = {"Go to the 3 pedestals located before Cannon Master Willey, and check them to know which bosses to kill. Kill the required bosses, and use the Stratholme Shadow Jar on each of their corpses. Bring all 3 Echos back to the corresponding pedestal to receive the rune."},
            [questKeys.requiredSpell] = -402850,
            [questKeys.zoneOrSort] = sortKeys.PRIEST,
        },
        [90351] = {
            [questKeys.name] = "Decimation: Step 1",
            [questKeys.startedBy] = {{222288}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Summon your Explorer Imp and send them inside Fel Rifts until you get a Legion Portal Tuner from one of the bags returned. Then make your way to Blasted Lands, Feralas, or Azshara for the next step."},
            [questKeys.requiredSpell] = -440922,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90352] = {
            [questKeys.name] = "Decimation: Step 2",
            [questKeys.startedBy] = {{222698}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 10,
            [questKeys.questLevel] = 50,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARLOCK,
            [questKeys.objectivesText] = {"Use the Legion Portal Tuner on a fel scar, and send your Explorer Imp inside until you get a Portal Tuner Tuner. Use it on the Legion Portal Tuner to create a Overcharged Portal Tuner. Then use it on a Fel Scar and send your Explorer Imp back in, and he will return with the rune."},
            [questKeys.requiredSpell] = -440922,
            [questKeys.zoneOrSort] = sortKeys.WARLOCK,
        },
        [90353] = {
            [questKeys.name] = "Endless Rage",
            [questKeys.startedBy] = {{210802,211146}},
            [questKeys.finishedBy] = {{211146}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 16,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Attack the Webbed Victim to free the Lost Adventurer and defeat him."},
            [questKeys.requiredSpell] = -403489,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [90354] = {
            [questKeys.name] = "Aegis",
            [questKeys.startedBy] = {{204989,208802}},
            [questKeys.finishedBy] = {{204989,208802}},
            [questKeys.requiredLevel] = 8,
            [questKeys.questLevel] = 8,
            [questKeys.requiredRaces] = raceIDs.NONE,
            [questKeys.requiredClasses] = classIDs.PALADIN,
            [questKeys.objectivesText] = {"Cast Purify on the Wounded Adventurer and talk to him afterwards."},
            [questKeys.requiredSpell] = -425619,
            [questKeys.zoneOrSort] = sortKeys.PALADIN,
        },
        [90355] = {
            [questKeys.name] = "Frenzied Assault",
            [questKeys.startedBy] = {{203475}},
            [questKeys.finishedBy] = {{203475}},
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 10,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.WARRIOR,
            [questKeys.objectivesText] = {"Talk to Liv Bradford and then defeat Stuart outside the Inn. Return to Liv afterwards"},
            [questKeys.requiredSpell] = -425447,
            [questKeys.zoneOrSort] = sortKeys.WARRIOR,
        },
        [91000] = {
            [questKeys.name] = "Rune Broker",
            [questKeys.startedBy] = {{233335}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 1,
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = sortKeys.SPECIAL,
        },
        [91001] = {
            [questKeys.name] = "Rune Broker",
            [questKeys.startedBy] = {{233428}},
            [questKeys.finishedBy] = nil,
            [questKeys.requiredLevel] = 1,
            [questKeys.questLevel] = 1,
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.requiredClasses] = classIDs.NONE,
            [questKeys.zoneOrSort] = sortKeys.SPECIAL,
        },
    }
end

function SeasonOfDiscovery:LoadFactionQuestFixes()
    local questKeys = QuestieDB.questKeys
    local raceIDs = QuestieDB.raceKeys

    local questFixesHorde = {
        [78124] = { -- Nar'thalas Almanac
            [questKeys.startedBy] = {nil,{409496}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Nar'thalas Almanac, Vol. 74' and bring it to Owen Thadd in Undercity."},
        },
        [78127] = { -- The Dalaran Digest
            [questKeys.startedBy] = {nil,{409501}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Dalaran Digest, Vol. 23' and bring it to Owen Thadd in Undercity."},
        },
        [78142] = { -- Bewitchments and Glamours
            [questKeys.startedBy] = {nil,{409562}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Bewitchments and Glamours' and bring it to Owen Thadd in Undercity."},
        },
        [78143] = { -- Secrets of the Dreamers
            [questKeys.startedBy] = {nil,{409692}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Secrets of the Dreamers' located just outside the Wailing Cavern dungeon and bring it to Owen Thadd in Undercity."},
        },
        [78145] = { -- Arcanic Systems Manual
            [questKeys.startedBy] = {nil,{409700}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Arcanic Systems Manual' and bring it to Owen Thadd in Undercity."},
        },
        [78146] = { -- Goaz Scrolls
            [questKeys.startedBy] = {nil,{409717}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Goaz Scrolls' and bring it to Owen Thadd in Undercity."},
        },
        [78147] = { -- Crimes Against Anatomy
            [questKeys.startedBy] = {nil,{409735}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Crimes Against Anatomy' and bring it to Owen Thadd in Undercity."},
        },
        [78148] = { -- Runes of the Sorceror-Kings
            [questKeys.startedBy] = {nil,{409731}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Runes of the Sorcerer-Kings' and bring it to Owen Thadd in Undercity."},
        },
        [78149] = { -- Fury of the Land
            [questKeys.startedBy] = {nil,{409711}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Fury of the Land' and bring it to Owen Thadd in Undercity."},
        },
        [78150] = { -- Friend of the Library
            [questKeys.startedBy] = {{211022}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"You will need to hand in 10 books to receive the rune, however you can hand 1 in at any time."},
        },
        [78611] = { -- A Waylaid Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [78612] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [78872] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79097] = { -- Baxtan: On Destructive Magics
            [questKeys.startedBy] = {nil,{407566}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Baxtan: On Destructive Magics' and bring it to Owen Thadd in Undercity."},
        },
        [79100] = { -- A Waylaid Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79101] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79102] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79103] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [79535] = { -- Basilisks: Should Petrification be Feared?
            [questKeys.startedBy] = {nil,{421526}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Basilisks: Should Petrification be Feared?' and bring it to Owen Thadd in Undercity."},
        },
        [79536] = { -- Greater Friend of the Library
            [questKeys.startedBy] = {{211022}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"You will need to hand in 20 books to receive the rune, however you can hand 1 in at any time."},
        },
        [79947] = { -- Geomancy: The Stone-Cold Truth
            [questKeys.startedBy] = {nil,{423895}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Geomancy: The Stone-Cold Truth' and bring it to Owen Thadd in Undercity."},
        },
        [79948] = { -- Defensive Magics 101
            [questKeys.startedBy] = {nil,{423896}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Defensive Magics 101' and bring it to Owen Thadd in Undercity."},
        },
        [79949] = { -- A Web of Lies: Debunking Myths and Legends
            [questKeys.startedBy] = {nil,{423897}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'A Web of Lies: Debunking Myths and Legends' and bring it to Owen Thadd in Undercity."},
        },
        [79950] = { -- Demons and You
            [questKeys.startedBy] = {nil,{423898}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Demons and You' and bring it to Owen Thadd in Undercity."},
        },
        [79951] = { -- Mummies: A Guide to the Unsavory Undead
            [questKeys.startedBy] = {nil,{423899}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Mummies: A Guide to the Unsavory Undead' and bring it to Owen Thadd in Undercity."},
        },
        [79952] = { -- RwlRwlRwlRwl!
            [questKeys.startedBy] = {nil,{423900}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'RwlRwlRwlRwl!' and bring it to Owen Thadd in Undercity."},
        },
        [79953] = { -- A Ludite's Guide to Caring for Your Demonic Pet
            [questKeys.startedBy] = {nil,{423901}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'A Ludite's Guide to Caring for Your Demonic Pet' and bring it to Owen Thadd in Undercity."},
        },
        [80307] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [80308] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [80309] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [81947] = { -- Sanguine Sorcery
            [questKeys.startedBy] = {nil,{441247}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Sanguine Sorcery' and bring it to Owen Thadd in Undercity."},
        },
        [81949] = { -- Legends of the Tidesages
            [questKeys.startedBy] = {nil,{441248}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Legends of the Tidesages' and bring it to Owen Thadd in Undercity."},
        },
        [81951] = { -- The Liminal and the Arcane
            [questKeys.startedBy] = {nil,{441249}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Liminal and the Arcane' and bring it to Owen Thadd in Undercity. NOTE: You need to enter the Emerald Nightmare."},
        },
        [81952] = { -- Everyday Etiquette
            [questKeys.startedBy] = {nil,{441250}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Everyday Etiquette' and bring it to Owen Thadd in Undercity."},
        },
        [81953] = { -- Stonewrought Design
            [questKeys.startedBy] = {nil,{441251}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Stonewrought Design' and bring it to Owen Thadd in Undercity."},
        },
        [81954] = { -- Venomous Journeys
            [questKeys.startedBy] = {nil,{441252}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Venomous Journeys' and bring it to Owen Thadd in Undercity."},
        },
        [81955] = { -- A Mind of Metal
            [questKeys.startedBy] = {nil,{441253}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'A Mind of Metal' and bring it to Owen Thadd in Undercity."},
        },
        [81956] = { -- Conjurer's Codex
            [questKeys.startedBy] = {nil,{441254}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Conjurer's Codex' and bring it to Owen Thadd in Undercity."},
        },
        [82084] = { -- A Lesson in Literacy
            [questKeys.startedBy] = {{211022}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
        },
        [82208] = { -- Greater Friend of the Library
            [questKeys.startedBy] = {{211022}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
        },
        [82307] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [82308] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [82309] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
        [84394] = { -- Greater Friend of the Library
            [questKeys.startedBy] = {{211022}},
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
        },
        [84395] = { -- Undead Potatoes
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Undead Potatoes' and bring it to Oran Snakewrithe in Undercity."},
        },
        [84396] = { -- Magma or Lava?
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Magma or Lava?' and bring it to Oran Snakewrithe in Undercity."},
        },
        [84397] = { -- Northern Kalimdor - A Comprehensive Guide
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Northern Kalimdor - A Comprehensive Guide' and bring it to Oran Snakewrithe in Undercity."},
        },
        [84398] = { -- A Study of the Light
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'A Study of the Light' and bring it to Oran Snakewrithe in Undercity."},
        },
        [84399] = { -- Ka-Boom!
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Ka-Boom!' and bring it to Oran Snakewrithe in Undercity."},
        },
        [84400] = { -- The Knight and the Lady
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'The Knight and the Lady' and bring it to Oran Snakewrithe in Undercity."},
        },
        [84401] = { -- Scourge: Undead Menace or Misunderstood?
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Scourge: Undead Menace or Misunderstood?' and bring it to Oran Snakewrithe in Undercity."},
        },
        [84402] = { -- Necromancy 101
            [questKeys.requiredRaces] = raceIDs.ALL_HORDE,
            [questKeys.objectivesText] = {"Collect 'Necromancy 101' and bring it to Oran Snakewrithe in Undercity."},
        },
        [88654] = { -- A Full Shipment
            [questKeys.startedBy] = {{214070,214096,214098}},
            [questKeys.finishedBy] = {{214070,214096,214098}},
        },
    }

    local questFixesAlliance = {
        [78124] = { -- Nar'thalas Almanac
            [questKeys.startedBy] = {nil,{409496}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Nar'thalas Almanac, Vol. 74' and bring it to Garion Wendell in Stormwind."},
        },
        [78127] = { -- The Dalaran Digest
            [questKeys.startedBy] = {nil,{409501}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'The Dalaran Digest, Vol. 23' and bring it to Garion Wendell in Stormwind."},
        },
        [78142] = { -- Bewitchments and Glamours
            [questKeys.startedBy] = {nil,{409562}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Bewitchments and Glamours' and bring it to Garion Wendell in Stormwind."},
        },
        [78143] = { -- Secrets of the Dreamers
            [questKeys.startedBy] = {nil,{409692}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Secrets of the Dreamers' located just outside the Wailing Cavern dungeon and bring it to Garion Wendell in Stormwind."},
        },
        [78145] = { -- Arcanic Systems Manual
            [questKeys.startedBy] = {nil,{409700}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Arcanic Systems Manual' and bring it to Garion Wendell in Stormwind."},
        },
        [78146] = { -- Goaz Scrolls
            [questKeys.startedBy] = {nil,{409717}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Goaz Scrolls' and bring it to Garion Wendell in Stormwind."},
        },
        [78147] = { -- Crimes Against Anatomy
            [questKeys.startedBy] = {nil,{409735}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Crimes Against Anatomy' and bring it to Garion Wendell in Stormwind."},
        },
        [78148] = { -- Runes of the Sorceror-Kings
            [questKeys.startedBy] = {nil,{409731}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Runes of the Sorcerer-Kings' and bring it to Garion Wendell in Stormwind."},
        },
        [78149] = { -- Fury of the Land
            [questKeys.startedBy] = {nil,{409711}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Fury of the Land' and bring it to Garion Wendell in Stormwind."},
        },
        [78150] = { -- Friend of the Library
            [questKeys.startedBy] = {{211033}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"You will need to hand in 10 books to receive the rune, however you can hand 1 in at any time."},
        },
        [78611] = { -- A Waylaid Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [78612] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [78872] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79097] = { -- Baxtan: On Destructive Magics
            [questKeys.startedBy] = {nil,{407566}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Baxtan: On Destructive Magics' and bring it to Garion Wendell in Stormwind."},
        },
        [79100] = { -- A Waylaid Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79101] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79102] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79103] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [79535] = { -- Basilisks: Should Petrification be Feared?
            [questKeys.startedBy] = {nil,{421526}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Basilisks: Should Petrification be Feared?' and bring it to Garion Wendell in Stormwind."},
        },
        [79536] = { -- Greater Friend of the Library
            [questKeys.startedBy] = {{211033}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"You will need to hand in 20 books to receive the rune, however you can hand 1 in at any time."},
        },
        [79947] = { -- Geomancy: The Stone-Cold Truth
            [questKeys.startedBy] = {nil,{423895}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Geomancy: The Stone-Cold Truth' and bring it to Garion Wendell in Stormwind."},
        },
        [79948] = { -- Defensive Magics 101
            [questKeys.startedBy] = {nil,{423896}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Defensive Magics 101' and bring it to Garion Wendell in Stormwind."},
        },
        [79949] = { -- A Web of Lies: Debunking Myths and Legends
            [questKeys.startedBy] = {nil,{423897}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'A Web of Lies: Debunking Myths and Legends' and bring it to Garion Wendell in Stormwind."},
        },
        [79950] = { -- Demons and You
            [questKeys.startedBy] = {nil,{423898}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Demons and You' and bring it to Garion Wendell in Stormwind."},
        },
        [79951] = { -- Mummies: A Guide to the Unsavory Undead
            [questKeys.startedBy] = {nil,{423899}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Mummies: A Guide to the Unsavory Undead' and bring it to Garion Wendell in Stormwind."},
        },
        [79952] = { -- RwlRwlRwlRwl!
            [questKeys.startedBy] = {nil,{423900}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'RwlRwlRwlRwl!' and bring it to Garion Wendell in Stormwind."},
        },
        [79953] = { -- A Ludite's Guide to Caring for Your Demonic Pet
            [questKeys.startedBy] = {nil,{423901}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'A Ludite's Guide to Caring for Your Demonic Pet' and bring it to Garion Wendell in Stormwind."},
        },
        [80307] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [80308] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [80309] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [81947] = { -- Sanguine Sorcery
            [questKeys.startedBy] = {nil,{441247}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Sanguine Sorcery' and bring it to Garion Wendell in Stormwind."},
        },
        [81949] = { -- Legends of the Tidesages
            [questKeys.startedBy] = {nil,{441248}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Legends of the Tidesages' and bring it to Garion Wendell in Stormwind."},
        },
        [81951] = { -- The Liminal and the Arcane
            [questKeys.startedBy] = {nil,{441249}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'The Liminal and the Arcane' and bring it to Garion Wendell in Stormwind."},
        },
        [81952] = { -- Everyday Etiquette
            [questKeys.startedBy] = {nil,{441250}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Everyday Etiquette' and bring it to Garion Wendell in Stormwind."},
        },
        [81953] = { -- Stonewrought Design
            [questKeys.startedBy] = {nil,{441251}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Stonewrought Design' and bring it to Garion Wendell in Stormwind."},
        },
        [81954] = { -- Venomous Journeys
            [questKeys.startedBy] = {nil,{441252}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Venomous Journeys' and bring it to Garion Wendell in Stormwind."},
        },
        [81955] = { -- A Mind of Metal
            [questKeys.startedBy] = {nil,{441253}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'A Mind of Metal' and bring it to Garion Wendell in Stormwind."},
        },
        [81956] = { -- Conjurer's Codex
            [questKeys.startedBy] = {nil,{441254}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Conjurer's Codex' and bring it to Garion Wendell in Stormwind."},
        },
        [82084] = { -- A Lesson in Literacy
            [questKeys.startedBy] = {{211033}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
        },
        [82208] = { -- Greater Friend of the Library
            [questKeys.startedBy] = {{211033}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
        },
        [82307] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [82308] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [82309] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
        [84394] = { -- Greater Friend of the Library
            [questKeys.startedBy] = {{211033}},
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
        },
        [84395] = { -- Undead Potatoes
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Undead Potatoes' and bring it to Jennea Cannon in Stormwind."},
        },
        [84396] = { -- Magma or Lava?
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Magma or Lava?' and bring it to Jennea Cannon in Stormwind."},
        },
        [84397] = { -- Northern Kalimdor - A Comprehensive Guide
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Northern Kalimdor - A Comprehensive Guide' and bring it to Jennea Cannon in Stormwind."},
        },
        [84398] = { -- A Study of the Light
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'A Study of the Light' and bring it to Jennea Cannon in Stormwind."},
        },
        [84399] = { -- Ka-Boom!
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Ka-Boom!' and bring it to Jennea Cannon in Stormwind."},
        },
        [84400] = { -- The Knight and the Lady
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'The Knight and the Lady' and bring it to Jennea Cannon in Stormwind."},
        },
        [84401] = { -- Scourge: Undead Menace or Misunderstood?
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Scourge: Undead Menace or Misunderstood?' and bring it to Jennea Cannon in Stormwind."},
        },
        [84402] = { -- Necromancy 101
            [questKeys.requiredRaces] = raceIDs.ALL_ALLIANCE,
            [questKeys.objectivesText] = {"Collect 'Necromancy 101' and bring it to Jennea Cannon in Stormwind."},
        },
        [88654] = { -- A Full Shipment
            [questKeys.startedBy] = {{213077,214099,214101}},
            [questKeys.finishedBy] = {{213077,214099,214101}},
        },
    }

    if UnitFactionGroup("Player") == "Horde" then
        return questFixesHorde
    else
        return questFixesAlliance
    end
end
