---@type QuestieDBPrivate
local _QuestieDB = QuestieLoader:ImportModule("QuestieDB").private

---@type Expansions
local Expansions = QuestieLoader:ImportModule("Expansions")


--- Tag corrections for quests for which the GetQuestTagInfo API returns the wrong values.
function _QuestieDB.InitializeQuestTagInfoCorrections()

    ---@type table<number, {[1]: QuestTagIds, [2]: string}>
    _QuestieDB.questTagCorrections = {
        [208] = Expansions.Current < Expansions.Cata and {1, "Elite"} or nil,
        [373] = {81, "Dungeon"},
        [644] = Expansions.Current == Expansions.Era and {1, "Elite"} or nil,
        [645] = Expansions.Current == Expansions.Era and {1, "Elite"} or nil,
        [646] = Expansions.Current == Expansions.Era and {1, "Elite"} or nil,
        [4146] = {81, "Dungeon"},
        [4601] = {81, "Dungeon"},
        [4602] = {81, "Dungeon"},
        [4603] = {81, "Dungeon"},
        [4604] = {81, "Dungeon"},
        [4605] = {81, "Dungeon"},
        [4606] = {81, "Dungeon"},
        [5342] = {0, ""},
        [5344] = {0, ""},
        [6846] = {41, "PvP"},
        [6901] = {41, "PvP"},
        [7001] = {41, "PvP"},
        [7027] = {41, "PvP"},
        [7161] = {41, "PvP"},
        [7162] = {41, "PvP"},
        [7737] = {0, ""},
        [7841] = {0, ""},
        [7842] = {0, ""},
        [7843] = {0, ""},
        [8122] = {41, "PvP"},
        [8367] = {41, "PvP"},
        [8371] = {41, "PvP"},
        [8375] = {41, "PvP"},
        [8383] = {41, "PvP"},
        [8385] = {41, "PvP"},
        [8386] = {41, "PvP"},
        [8387] = {41, "PvP"},
        [8388] = {41, "PvP"},
        [8404] = {41, "PvP"},
        [8405] = {41, "PvP"},
        [8406] = {41, "PvP"},
        [8407] = {41, "PvP"},
        [8408] = {41, "PvP"},
        [12170] = {41, "PvP"},
        [12244] = {41, "PvP"},
        [12268] = {41, "PvP"},
        [12270] = {41, "PvP"},
        [12280] = {41, "PvP"},
        [12284] = {41, "PvP"},
        [12288] = {41, "PvP"},
        [12289] = {41, "PvP"},
        [12296] = {41, "PvP"},
        [12314] = {41, "PvP"},
        [12315] = {41, "PvP"},
        [12316] = {41, "PvP"},
        [12317] = {41, "PvP"},
        [12323] = {41, "PvP"},
        [12324] = {41, "PvP"},
        [12432] = {41, "PvP"},
        [12433] = {41, "PvP"},
        [12434] = {41, "PvP"},
        [12437] = {41, "PvP"},
        [12443] = {41, "PvP"},
        [12446] = {41, "PvP"},
        [13129] = {81, "Dungeon"},
        [13199] = {41, "PvP"},
        [13662] = {0, ""},
        [26452] = {41, "PvP"},
        [26856] = {81, "Dungeon"},
        [26858] = {81, "Dungeon"},
        [26862] = {81, "Dungeon"},
        [26866] = {81, "Dungeon"},
        [26962] = {81, "Dungeon"},
        [26967] = {81, "Dungeon"},
        [27848] = {81, "Dungeon"},
        [27850] = {81, "Dungeon"},
        [28735] = {81, "Dungeon"},
        [28737] = {81, "Dungeon"},
        [28738] = {81, "Dungeon"},
        [28740] = {81, "Dungeon"},
        [28760] = {81, "Dungeon"},
        [28814] = {81, "Dungeon"},
        [28845] = {81, "Dungeon"},
        [29135] = {62, "Raid"},
        [29153] = {81, "Dungeon"},
        [29154] = {81, "Dungeon"},
        [29172] = {81, "Dungeon"},
        [29173] = {81, "Dungeon"},
        [29175] = {81, "Dungeon"},
        [29208] = {81, "Dungeon"},
        [29241] = {81, "Dungeon"},
        [29242] = {81, "Dungeon"},
        [29251] = {81, "Dungeon"},
        [29252] = {81, "Dungeon"},
        [78680] = {1, "Elite"},
        [78681] = {1, "Elite"},
        [78684] = {1, "Elite"},
        [80098] = {1, "Elite"},
        [80147] = {1, "Elite"},
        [80148] = {1, "Elite"},
        [80149] = {1, "Elite"},
        [80150] = {1, "Elite"},
        [80151] = {1, "Elite"},
        [80152] = {1, "Elite"},
        [90014] = {1, "Elite"},
        [90054] = {1, "Elite"},
        [90070] = {1, "Elite"},
        [90081] = {1, "Elite"},
        [90091] = {1, "Elite"},
        [90094] = {1, "Elite"},
        [90113] = {1, "Elite"},
        [90114] = {1, "Elite"},
        [90119] = {1, "Elite"},
        [90122] = {1, "Elite"},
        [90151] = {1, "Elite"},
        [90152] = {1, "Elite"},
        [90159] = {1, "Elite"},
        [90163] = {1, "Elite"},
        [90166] = {1, "Elite"},
        [90169] = {1, "Elite"},
        [90175] = {1, "Elite"},
        [90190] = {1, "Elite"},
        [90202] = {1, "Elite"},
        [90204] = {1, "Elite"},
        [90221] = {1, "Elite"},
        [90225] = {1, "Elite"},
        [90230] = {1, "Elite"},
        [90269] = {1, "Elite"},
        [90271] = {1, "Elite"},
        [90281] = {1, "Elite"},
        [90282] = {1, "Elite"},
        [90287] = {1, "Elite"},
        [90288] = {1, "Elite"},
        [90289] = {1, "Elite"},
        [90308] = {1, "Elite"},
        [90312] = {1, "Elite"},
        [90334] = {1, "Elite"},
        [90335] = {1, "Elite"},
        [90339] = {1, "Elite"},
        [90343] = {1, "Elite"},
        [90344] = {1, "Elite"},
        [90353] = {1, "Elite"},

        -- PvP quest manual overwrite for Anniversary servers
        [236] = {41, "PvP"},
        [1657] = {41, "PvP"},
        [5892] = {41, "PvP"},
        [5893] = {41, "PvP"},
        [6741] = {41, "PvP"},
        [6781] = {41, "PvP"},
        [6801] = {41, "PvP"},
        [6825] = {41, "PvP"},
        [6826] = {41, "PvP"},
        [6827] = {41, "PvP"},
        [6847] = {41, "PvP"},
        [6848] = {41, "PvP"},
        [6861] = {41, "PvP"},
        [6862] = {41, "PvP"},
        [6881] = {41, "PvP"},
        [6941] = {41, "PvP"},
        [6942] = {41, "PvP"},
        [6943] = {41, "PvP"},
        [6982] = {41, "PvP"},
        [6985] = {41, "PvP"},
        [7002] = {41, "PvP"},
        [7026] = {41, "PvP"},
        [7081] = {41, "PvP"},
        [7082] = {41, "PvP"},
        [7101] = {41, "PvP"},
        [7102] = {41, "PvP"},
        [7121] = {41, "PvP"},
        [7122] = {41, "PvP"},
        [7123] = {41, "PvP"},
        [7124] = {41, "PvP"},
        [7141] = {41, "PvP"},
        [7142] = {41, "PvP"},
        [7163] = {41, "PvP"},
        [7164] = {41, "PvP"},
        [7165] = {41, "PvP"},
        [7166] = {41, "PvP"},
        [7167] = {41, "PvP"},
        [7168] = {41, "PvP"},
        [7169] = {41, "PvP"},
        [7170] = {41, "PvP"},
        [7171] = {41, "PvP"},
        [7172] = {41, "PvP"},
        [7181] = {41, "PvP"},
        [7202] = {41, "PvP"},
        [7221] = {41, "PvP"},
        [7222] = {41, "PvP"},
        [7223] = {41, "PvP"},
        [7224] = {41, "PvP"},
        [7241] = {41, "PvP"},
        [7261] = {41, "PvP"},
        [7281] = {41, "PvP"},
        [7282] = {41, "PvP"},
        [7301] = {41, "PvP"},
        [7302] = {41, "PvP"},
        [7361] = {41, "PvP"},
        [7362] = {41, "PvP"},
        [7363] = {41, "PvP"},
        [7364] = {41, "PvP"},
        [7365] = {41, "PvP"},
        [7366] = {41, "PvP"},
        [7367] = {41, "PvP"},
        [7368] = {41, "PvP"},
        [7381] = {41, "PvP"},
        [7382] = {41, "PvP"},
        [7385] = {41, "PvP"},
        [7386] = {41, "PvP"},
        [7401] = {41, "PvP"},
        [7402] = {41, "PvP"},
        [7421] = {41, "PvP"},
        [7422] = {41, "PvP"},
        [7423] = {41, "PvP"},
        [7424] = {41, "PvP"},
        [7425] = {41, "PvP"},
        [7426] = {41, "PvP"},
        [7427] = {41, "PvP"},
        [7428] = {41, "PvP"},
        [7788] = {41, "PvP"},
        [7789] = {41, "PvP"},
        [7810] = {41, "PvP"},
        [7871] = {41, "PvP"},
        [7872] = {41, "PvP"},
        [7873] = {41, "PvP"},
        [7874] = {41, "PvP"},
        [7875] = {41, "PvP"},
        [7876] = {41, "PvP"},
        [7886] = {41, "PvP"},
        [7887] = {41, "PvP"},
        [7888] = {41, "PvP"},
        [7908] = {41, "PvP"},
        [7921] = {41, "PvP"},
        [7922] = {41, "PvP"},
        [7923] = {41, "PvP"},
        [7924] = {41, "PvP"},
        [7925] = {41, "PvP"},
        [8001] = {41, "PvP"},
        [8002] = {41, "PvP"},
        [8080] = {41, "PvP"},
        [8081] = {41, "PvP"},
        [8105] = {41, "PvP"},
        [8114] = {41, "PvP"},
        [8115] = {41, "PvP"},
        [8120] = {41, "PvP"},
        [8121] = {41, "PvP"},
        [8123] = {41, "PvP"},
        [8124] = {41, "PvP"},
        [8154] = {41, "PvP"},
        [8155] = {41, "PvP"},
        [8156] = {41, "PvP"},
        [8157] = {41, "PvP"},
        [8158] = {41, "PvP"},
        [8159] = {41, "PvP"},
        [8160] = {41, "PvP"},
        [8161] = {41, "PvP"},
        [8162] = {41, "PvP"},
        [8163] = {41, "PvP"},
        [8164] = {41, "PvP"},
        [8165] = {41, "PvP"},
        [8166] = {41, "PvP"},
        [8167] = {41, "PvP"},
        [8168] = {41, "PvP"},
        [8169] = {41, "PvP"},
        [8170] = {41, "PvP"},
        [8171] = {41, "PvP"},
        [8260] = {41, "PvP"},
        [8261] = {41, "PvP"},
        [8262] = {41, "PvP"},
        [8263] = {41, "PvP"},
        [8264] = {41, "PvP"},
        [8265] = {41, "PvP"},
        [8266] = {41, "PvP"},
        [8267] = {41, "PvP"},
        [8268] = {41, "PvP"},
        [8269] = {41, "PvP"},
        [8271] = {41, "PvP"},
        [8272] = {41, "PvP"},
        [8289] = {41, "PvP"},
        [8290] = {41, "PvP"},
        [8291] = {41, "PvP"},
        [8292] = {41, "PvP"},
        [8293] = {41, "PvP"},
        [8294] = {41, "PvP"},
        [8295] = {41, "PvP"},
        [8296] = {41, "PvP"},
        [8297] = {41, "PvP"},
        [8298] = {41, "PvP"},
        [8299] = {41, "PvP"},
        [8300] = {41, "PvP"},
        [8322] = {41, "PvP"},
        [8368] = {41, "PvP"},
        [8369] = {41, "PvP"},
        [8370] = {41, "PvP"},
        [8372] = {41, "PvP"},
        [8373] = {41, "PvP"},
        [8374] = {41, "PvP"},
        [8384] = {41, "PvP"},
        [8389] = {41, "PvP"},
        [8390] = {41, "PvP"},
        [8391] = {41, "PvP"},
        [8392] = {41, "PvP"},
        [8393] = {41, "PvP"},
        [8394] = {41, "PvP"},
        [8395] = {41, "PvP"},
        [8396] = {41, "PvP"},
        [8397] = {41, "PvP"},
        [8398] = {41, "PvP"},
        [8399] = {41, "PvP"},
        [8400] = {41, "PvP"},
        [8401] = {41, "PvP"},
        [8402] = {41, "PvP"},
        [8403] = {41, "PvP"},
        [8409] = {41, "PvP"},
        [8426] = {41, "PvP"},
        [8427] = {41, "PvP"},
        [8428] = {41, "PvP"},
        [8429] = {41, "PvP"},
        [8430] = {41, "PvP"},
        [8431] = {41, "PvP"},
        [8432] = {41, "PvP"},
        [8433] = {41, "PvP"},
        [8434] = {41, "PvP"},
        [8435] = {41, "PvP"},
        [8436] = {41, "PvP"},
        [8437] = {41, "PvP"},
        [8438] = {41, "PvP"},
        [8439] = {41, "PvP"},
        [8440] = {41, "PvP"},
        [8441] = {41, "PvP"},
        [8442] = {41, "PvP"},
        [8443] = {41, "PvP"},
        [9419] = {41, "PvP"},
        [9422] = {41, "PvP"},
        [9664] = {41, "PvP"},
        [9665] = {41, "PvP"},

        -- MoP quests
        [31519] = {85, "Heroic"},
        [31520] = {85, "Heroic"},
        [31522] = {85, "Heroic"},
        [31523] = {85, "Heroic"},
        [31524] = {85, "Heroic"},
        [31525] = {85, "Heroic"},
        [31526] = {85, "Heroic"},
        [31527] = {85, "Heroic"},
        [31528] = {85, "Heroic"},
        [31998] = {85, "Heroic"},
        [32000] = {85, "Heroic"},
        [32001] = {85, "Heroic"},
        [32002] = {85, "Heroic"},
        [32003] = {85, "Heroic"},
        [32004] = {85, "Heroic"},
        [32005] = {85, "Heroic"},
        [32006] = {85, "Heroic"},
        [32007] = {85, "Heroic"},
        [91701] = {294, "Celestial"},
        [91702] = {294, "Celestial"},
        [91703] = {294, "Celestial"},
        [91704] = {294, "Celestial"},
        [91705] = {294, "Celestial"},
        [91706] = {294, "Celestial"},
        [91707] = {294, "Celestial"},
        [91708] = {294, "Celestial"},
        [91709] = {294, "Celestial"},
        [91710] = {294, "Celestial"},
        [91711] = {294, "Celestial"},
        [91712] = {294, "Celestial"},
        [91713] = {294, "Celestial"},
        [91714] = {294, "Celestial"},
        [91715] = {294, "Celestial"},
        [91716] = {294, "Celestial"},
        [91717] = {294, "Celestial"},
        [91718] = {294, "Celestial"},
        [91786] = {294, "Celestial"},
    }
end
