
local _
local addonName, platerInternal = ...
local tinsert = tinsert
local tremove = tremove
local Plater = Plater
local wipe = wipe

---@type detailsframework
local detailsFramework = DetailsFramework

local GetExpansionLevel = GetExpansionLevel

--this list of scripts are used at the Cast Colors and Names tab to previre which script the spell is using and also to select a script for the spell
platerInternal.Scripts.DefaultCastScripts = {
	"Cast - Small Alert [Plater]",
	"Cast - Frontal Cone [Plater]",
	"Cast - Shield Interrupt [P]",
	"Cast - Quick Flash [P]",
	"Cast - Ultra Important [P]",
	"Cast - Stop Casting [P]",
	"Cast - Glowing [P]",
	"Cast - Big Alert [Plater]",
	"Explosion Affix M+ [Plater]",
	"Cast - Circle AoE [P]",
	"Cast - Very Important [Plater]",
}

platerInternal.Scripts.CurrentCastScripts = {}

do
	PlaterScriptLibrary = {}

--[=[OverrideTriggers:
	"merge": use the old triggers an the new ones from the updated script
	false: don't override, don't merge, use the old triggers
	true or nil: use the new triggers only
--]=]

--new scripts for v11
if (GetExpansionLevel() == 10) then --World of Warcraft 11 has the expansion level 10
	detailsFramework.table.remove(platerInternal.Scripts.DefaultCastScripts, "Cast - Stop Casting [P]")
	detailsFramework.table.remove(platerInternal.Scripts.DefaultCastScripts, "Cast - Glowing [P]")
	detailsFramework.table.remove(platerInternal.Scripts.DefaultCastScripts, "Cast - Big Alert [Plater]")
	detailsFramework.table.remove(platerInternal.Scripts.DefaultCastScripts, "Explosion Affix M+ [Plater]")
	detailsFramework.table.remove(platerInternal.Scripts.DefaultCastScripts, "Cast - Circle AoE [P]")
	detailsFramework.table.remove(platerInternal.Scripts.DefaultCastScripts, "Cast - Very Important [Plater]")
	detailsFramework.table.remove(platerInternal.Scripts.DefaultCastScripts, "Cast - Ultra Important")
	detailsFramework.table.remove(platerInternal.Scripts.DefaultCastScripts, "Cast - Quick Flash [P]")

	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Heroic Leap [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - AoE Hit All [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - AoE With Range [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Debuff [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Heal Cut [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Heal Stun [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Important by Color [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Ongoing Cast [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Simple Interrupt [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Spark Color [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Special Ability [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Shining Green [P]")
	--table.insert(platerInternal.Scripts.DefaultCastScripts, "Aura - Is Cast Bar [P]")
	table.insert(platerInternal.Scripts.DefaultCastScripts, "Cast - Voidzone [P]")

	PlaterScriptLibrary["Cast - Tankbuster [P]"] = { --2025 March 03
		Revision = 1,
		ScriptType = "script",
		String = "vNvBZPTow4)l8LctduBJXaDM8bcjKW9MazQt7D2TPoiSfG3AKzLTtA2Dw(TVNJSKXa2qst7oZo02RSS051NZJoYxhDN7CSdxf7hYIGHJepF3ZROoJSCS)t6ZQ3Q7y)fsqcmVMJ9iYsQJ9zbe23xp5AFg8Wq3qg8VSykFgXLEFppVXSO7VnGaZCV)sYCA09PI6HP4gDSpNg56y7e7mYyJwBTLwnuA1(wEOxIlnA9eY6jSWyY0a66j0zZOUXRN4ZwpjEbmHljcECkHVEYtlOmXQJwrdcwpzgpCPCvV7oU)85uE07G3gt4XGyJdt3DdL7nwybRNy86CUaYuAqENRzzoxZmN7cuYsBtATmWgwpjKlNy45WdZKlXoDjzonyoRNiDjW5d)b42myQf(qSOc82k75unFJoLzz4eZsXj2RaT8gbkT2OwtPAtIO9H0gKY7hgeYvQ)mL27lqeNHicXcwp5cgcE8ELMsyywa4VeilAQyobGnliS5i0CxiOlQWtqd3AJHRlnC3cSArfi(hdNbT7QByO1wtZQPgmOJZS6TSq40Go6DnB3Pv7oDT0A3TzB5BmXDgxMF)6Cx30TK6VY4wg(lZdBGUw7YGcT)Dsz0zJwHc0Bi)qeyZNFYzQQACSEywajAX6jCYkFVGNHShX7FKGlAr4tWBfRpBD0OgRNiCcysqal9dc8JOGH7fb1u34ZaNRHMQUwSNZt4e0M349nalBaN4kM9SxNJZswoLYvXVbPgFMkGar3cceAQiXqMlNsIkcBUG6pFb(WZ47qN7XuYOuNkhifWqxjwC(8zM)m9T4p5aPxjTNBc9q3c8HxDc(eXCC67spLiAjbPjJwq(onhBjYSUcnTtuoEeno2NnpclyzX8WGijAiiKnpfnedYixgxvdlK9VZeUDQXNpHRRxugplLFfA4rGximDvIxyOk73iV13B5Qa)4epAM5BSJYZTIFghjhsbTEJ9T(oBB8P1GBmBOSl8Xnr)TI9d40)zcL5(CM1RRTJ5NBjVzZhkbIdDFe6CaNbsfAIipXZdfCQCCSf832XOpAh5Y9xbBRPKB3OJMLMjUaiuO3YeYMaLUySMvlbjEZM6n1TWd7g10qZY0ejwHz1A1XcPBHzB2sVfYbcdnHJaqwGrMnnB3UPiaaJnmm6kWkW4UAn1fr(rMTBcBfgdRZSv32DX1aY30cprbgJwGvlllqrOjyAzP3fKNoOvtZoMDG3RdRZ0W0e3NExX8O1a(OHQGUo0ocWxpf4vXos(6TFZXU1rd8yP8da30dXz7TXk2ChBSzdq8W5j3r5U(HaLdCstVP(aS0h52WDsHgEcv14Oea8cyI2ZsyUP98unIgmdk6ty(Xd9KdG07sKjGYE8o88CyyAkt8uT1)X6jYFzJQxhY2VdCt6pOUjX0u9oLehhqNZdtGZgKnGr4qtcrB2PpCcAvO511ts98gdJSbIgG7PFkp7D0O4AcFGLtZ53TCJ)9qgDidO9yUuSyA9Ktpf61tOWkP9nE4vU6XvVO1XGPRuQjP(XPXj8cEpfIc)rHpCOWPVQrdGM(zeaH0yIWwwY9GX0BfBdrGvRvQPVRjxQ1HgrwBdegawf3wk)otHongKeeajrXH0FenIQLGFY2HBchYyXQZ(onhMSH8O3pEjv((YKghanHCFKVxeF8OZijb4PI()lQk4GKG(CSijYhYWPNQrcGUd8EgFlkI8NsUW3JQkfQTt0oZ8hd35WNrcsTVsd1yD3hTPzUz5c44zdFzhn73qJWBZwzqOljytxoNkTIcdMLyoIDjfqb2YEELsxVpNe7NV)jG1RWuOe4cYsU8Zc5EuUSTBfTLo83ggQ)rRHzHYkd)iaGIrYZb3e13mBjikOHiv8TSw)tVWShH)DKfbV)dOHqwWZPyexcsjkauGRXtwb8Z1YRIuFgGGjOCKk0pktJcPRaYzxLNrFAVw(yH48iYg3dGK3iRht7CNatmMDfGOBSV3UnI(H(e2qLjFyM4Cht0a6RyM)8g7Cx0JsBQGq2XK4KOZizP80OZhVLWbjIZfL3i3sh1(5yD3dZjK2GqUTWTuGUJ7KfVi3TxHY0leVL5xNrC)E6bOhJcDpwYg2RaO4MYXQhKhDlzMgGEb)G(jATD)ef2OaYrfr5Xiug5qXBKSJ(CSX(UmGUPSXMUABQRzA0Xc6SfAm73qhlVT(o(5735)Z7CPaKQ3lcnw8HDpCEkF2Eh2Tf1BC4QmU2LuorDjOcy4H7IS6NIHV4owqXv4XI7wxU7c)FwDjuFy8RR(OEDjlv2HovtpO5ihEvipCAlghMiS4mUSZsp5v83RfM(Jhny4LpCwV()5LFA8NhD(ddUUN9vpC(N)uV7goEuzAERpgvXQMGF44ToQepcTKVuuX(F(MBoumiBDfBjytDiZcrD9Fv)2tHR(VNjDyGSWmk5n5On6luPCEfsc)yEYETQ80c)yKb5yg821PtMfY39lnvKbNRU9uLn9rPnLVMopKUGy7wFbQdSKSpIZbwt2xk5emleerZ9F1KrfzasRb(GmscvW3gc1kr5n3AhpWft)bq(krDjrQyhjl7pLUWN5vE6xwHmf4NUCd)0DkXUBCDi(Dg2KR)6xZ9bj6F1Wl(Yf3CXO7g8PE3CX9FEy9EUl8PpsxcxqREVa4e96xge(03(2jBUlXF57fVOAT3BPDY(xW49TWzRmnJ9Sc84)gNZut7dT0nuH12AFWOL1)jxaRypcPrpla4fVr0yr1k9o)CuMTFr78Co5PRXlgxTY4VCXNUU3F7LVxr6f1OlfdzvKEl6EYzoUyW(VREeqHirNDhBG6jzAk6yryGchS7nXrtraBPh)ORTPg27LByhKiMEkLCfAivl2ZojVVO(PoKQATY79OS4n0Aw1IBR)KFPkAVmsrT58sYyVLusJzepO9TdMzYwt5jO8D)SZUruAVRV9QEvKCyh7e1pOQmB0UvTxShiQXKeXvpUkEvxfsOIXjXhpkjw0Bpmz8sdtIZeQ969KFfrRCFiTsU64HwISl29K6lF0wDOc9MQ)R8UBzcheSw6)NDD(Vp",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Aura - Is Cast Bar [P]"] = { --2024 June 30
		Revision = 1,
		ScriptType = "script",
		String = "fxv3UPnmu43LEvReGAkWkDstASonPSlyvYCxPgBCCsSMXoY2PBDtZp774KaTwna7IPnSuW)8D()4pJtWlXiDLtOvwyQdJCA2JCJf2aVij5s4hgrZYGLO7Kuh3GrjWjaWNQ4yKLzevGyJbPHDxmz8Sj3mbV4k8IXJNMmjjOZRWO51gQNm0tsTEYTuRZt(a14j3F3dy0umkvbQoNY4RMNL9fLDvRXwj2sl42vuq81mqSnuZOkvbgnP1DVgJwYnmHEdg9gmcvQ)MNawQdRNKRHpUsoSBJlKbFdH7iioMGr51kwyPNCULlZh4j1kHlnRBYNm0TCyox94s6gzyABe3S6c)N9KUX(zsnJkBT2h7SLN8UNvXO173(vYiDHutAwJaj9P9Hdh(EMKAHSyvtgAniuxWY0QCrHN8wiGdwkwQCbxckwaOwY)UR2aPeRZiufhdhtRnzNsFZLvLqQvvVDd30lkhyXJAo3oxIQEQxamTmujp0Xc7TLuLIldgGSrRLCQQFfrvnnBM6k3XrwYffLUJgxHOhj(b)Kb)jbzR4s5cOBBUIvgI0S8102P9QtXwU5pdAtf6WiFvxyBButVAtF4pFb2UrutuuVD3UdETmTTarGr7I5EG3vVb8NvyOpDwpqIR5asNPUxvfvXbC5uP9qU4Uq6(7pbLeCHB9gk7RfgDTk7Hh6rFpVZV6lF3QVriUBE7fFGr889SoJAoEhb0lkkdIjxgeLrDuJBPOrK9Sjr0uCvgSega)hW76t9PVKdmMClnmgouOSCJl4ez8W1cdF3zT)3QZum6gG4hyKNbpfCDYnxpB20PWZhjJ)7XZEaNjoJElCL2CIC6fXPIR(x5IXMn5)JzVm8wTdJ)9p",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - Heroic Leap [P]"] = { --2024 Aug 19
		Revision = 3,
		ScriptType = "script",
		String = "9Q1EVTTnq8Vl9FMDHLMfLFgGcS0eKLUhobvEDdijkwwMkMOkIgs0nlBO(Z(osQh06HLTSZGrSLe5D)Uh)UJKcX2WEQTfDfJqdIGlNiUF6RRW2t6BBnX5zST1nIH3mZW26lo(RHNCRVZRBM5eW)J8SJC4xwIHVzlXBM56eX2mJebJVz214qkXDZSFd7SY26xXVMaiOVp5sdGVdy4qphx89NVyXnbr3d6hEY9GQFchDVC2p67mh7BBDjoY12YMzpbLzRdsS15(obFDZmFsaoXAN0DlurhgQcfQIQzgQ9sq9Z4a43nZSwH99tW9JXWoxoA8yhe2uAQdNaHi(kVK6fFBex16CJRxMXzMyCcG3mtEtCcSKCIqjYjDi2id)3SeBCI0cPGfTK(cqacunWeAXCNqHT2VrPV(hz6BqjPVle21hDc3m7cQpnmb65jzW)icZNdy5XJ30S4flDcEcVvvYCoSUC1kdDYHK3hH9XUm8cywyF6lIW2WmhWOohquqF1G(dgpU)quVrdrJ7oAKTNw)E8YNRgoanEaAecHgpEqVHIrgWPoqqhcpGWS4qGBJDFxPiX(FEdLXrGrD)gomcMnaPr3UDHAuNfl4yivPTLb3ETyC32kYnKSceZu6Ft61BOrpXeM0ZeCOHCDIsatB7oqBMD3TpyB1hMU5aJHqiKxZacmeIQ4qxcfY6aF83PliEVkAGPKNu6XToGWKJjBZfZXFHWwMW6fLdyppihQuT(NoHHeA4peL3WIlJTmaIP36axzB1wajWRJeVpTi(IRcbDdxJd(2uN5(8lLrfXDT38lBMf)j9kIhxxztshYHEKN0ZtUBlmZafve)rMk0TWm(0)y80bLQAqxIzoe)iXTVqd)6z36ec6NpZOYqxLx1wXUXblkZj2d3rPBBLUcpKQpf6CDg4n8FlttPneBRIBfgMMM2pXzNaIG6whIV7HSb9PUoa1WhYYtLJc5(peBgIq1na)hwtvNteopmK(s68svIhpwt6KcGS9kzLdbISQQgm3f0I(CSyjEmCzR7URQs4NXlio37WTKhdjpTK94GE6SNCE4H2vR5laRi8CF)BPKawuR270gSi)dwqTp7NXSRXCmA1(9g697iJl5F8U12NPmXUqAbBgzP(kIOSp(633vFy)25fU2mACslI5eY(lr6sZORYWkr87mEGBec)U178XES3f7fWpz3l0eCH2O2vOhKQECX8KJQMuEs96YuvxICOQQYEqPAQqyiDFE1YCppBMfuI)QLogNVTQY0SE24LlkQgrfJxPlWcDcI2b6zJxUOOAeTc0lOmElVPe(sdFiRbU(JxUouUr6s7UWxjWZzHSQpVg5d8PGufW1Bgm)4GY04fpYhlu)CpGr1ABfaKHKLFkRi(u1qAFkN1YQHr9BxVo00s1cSd0Dz98Q(QuJARHslksDDbTtM3vC(888kcaPcZD5KGFUCr7Ae7Qq6ZNZFqRU6M1n5Pu5unQFH2SKlNAxWdZxlv1AojcFyE4wIDJNxeM1AeylOUT3JfIZkvORzLwRCZA2wflPLkOMMSrhrYwXA2)STX(MR3MwCezB0rKT3Tlwv6wZyqotFhnxpzBpQI(g5xhuqCIfsp7PftkjdDg)LM06q2IRMwHDtFjE(6N(cjImN4tyV2AhRdZziaeWXj6V9Xjk9CcAAKGiCi)enuEPZsmecvSjHMgdh3YCST1i4x44KDhA2FaColdZt35vE73h9PNYCnzb(THYaNmEvR6RbKmj4dKlqNYCXU5eBDuSakBNjcJkpmwfhpRc1uEc)SlcXWbxsoytaXNVjxQCW31(GGa92dH5jcIk5C0aE3MRaIGaP9z7CAA7kSx7(P2P4OJtCZeXRDdBL3BnFSHxwDqXMDgzQQ8FFOAhJWMvkCPEFXNOP5bD6GYwX58vBuTRwzxVEUSiSWIts2B62eGjg3bQQqxhvIAh1mt7Y7kYXo(uI7Lja4NigVssij)qV87GngX)wC1ODHNCVUnbpHK(Ir2gv(UBgTx1ZB71OJYRrzETo3c6wRxJobEnkVxxRpFyliOV96RPu09Qaic7s5RPEOvaOttfaQjvaOMvbGAAfaQzvaOtBfaQzvaOMwbGAwfaAFQaoogpQCgpA)y8SLKWgq4npneEZMq4nBgH3SPeEZMr4npTeEZMr4nBkH3SzeEZ3EcVz5eEZJuTBDeY)TzB(RtZ22xZeReh(7hzmi3R0EhrbL3nVyMFVtnZfTFZv5TUVFZTg9E6Ii65D5C7aTtHvK7uOL13pkSrvHnQa2OcyJAm25tj52jCNc7mOtHwNhh2OQWgvaBubSb)(a2HzUxcx6Bsj5JTLHX)FVrf1xKtx5)(f2)3",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary ["Cast - Voidzone [P]"] = { --2024 June 30
		Revision = 2,
		ScriptType = "script",
		String = "TRvBVPnsq4)lOt6msf0U(DhP7KOjTxtBeefJA)qtDWGxal54fz7KCPNo(TFZSgmMxmSohnn50fIGL1ZZS78mZSZAw7r9675YNLfYJtHMDfFV)JZyEDn8C)e7XLxL65(z)O7yEUUSSSW4jPZhmMNmFq2u28b(XH36JInFWSi)hzbZh8Wuw8IRoYpndEpH5NXayP36hfnFW98qqSVZJX(cxk7Ke(DXbT9C76Flmy9MLRvy4pFepgEpoJLm2Fe76obb9ItV(YiqRjxdJ)ew615t2BI8hYI8CpJLoYZ1ldE5MXhDpljfUkyLucHO656heG6mxfEUuVUqNzO17MokjCgatlNv6QBqSS1rbGMuDvnVUW)66g2u8Z8MA2iT1vxZ20aAAIn1S1HUSqyMMoqx2cnO5ak1buIQUdQmkbBRrrvqHlPPtO2W1PQy)MevOpCK0ujgwyBDSn1YgWrnq5nmf6bgbnnnDleRf2wx3c6JAlWAzb6Jcxt1WY2gARc41H5abWIJHUQPgoHvrdvvvvd7p3sn0rccnvvBlH8cB1XWWbjyG6ov4OBnFWNbFl6zNp4Rx(npxJd63WqKBg6NCZ9lq2Ew8epxDG9bvBbXKSKrH8HEUMc)1Jym3AXDhmEB3rA4x8bPFieLjWhNoGqJxiKiAgIYd4S04FfK7w(9mi6eOF3X3fpkFSvszrJFZ8b3fhMDEWIgVpbIGH2S4777pmcBMhuj(wZ5FC(GfVkAvaR9Bz(j9t8N1zPbk6(ei3Zn87mfkOmAZAa80iO)orrxYdJZsvAwVXuGsPXig6eBSH9vQBnc8MPwn1U7i)iMcPTrD5KtWabL1qXap6hp0lW9brKZpF(5LDHR7BohF1QvyCklbdM4bq0WuwcB51Y)mF8o3ZftPGCjxm91sLq0OowWGaPSpVXjNal0nRcobMoQhVPtfKZwtwmxsjMNvEA3N9Nz3LW(IF2OPUzSznfPBXLGVLA2223ujZh8BGAsUJjJAI4quxPfqeQuOHtfRBi(UsJX4hyODCyuzcQPmJX290Q1Vd0ju9mA9IM4ArZQCsoCtNSyE6VrgUyAxiYFGAuPbcnRmur)n2X0F42rsSSl48zWSvPr3EDFxJMsBIpegmHLLEICaQZF1W3gXgNHwe2vv81IyiLg)Ym)eyDSLyw0p65B05Q(FP3vFAxM)sXrUAPQ(6xpqTUqyJm3S0XCJkwP7BF7ak)Se)hUalfPumDGPg5aO2AD715G1x8ULUTeQmV8dbxOhE)WuYPCEsGOEfPnHG77c)JcB4GQwvNu5d0kmOLBhTWPltCYczBNWZwLxTDIWgPwknUQx)o9pVx39fsuOubr4Na5dklVMSW6LeaECQSIF2Dj5tqsBQJHd(NUTLUSWDZGqYZyynvsBnbChltkSdxPvXzSjjmwQslhI82y4KqGthYZY43kIQpqy4lC3L5ZK7Ajx)dLQ9JMn1xwEUZfx(HonoO6QjdxGrc6Tq2Na3wG99j8B7GFz)zERSfEU0KM)ul3bo3P1UExbijl4vi)pKkERPD5l5TgSAvZJiJgpyjpzRnTYdjHkke(OUC32ATu2yXfLgy1fO2T8YNwUB81RevfZH9TUzvMPSlC(kYRz(S512)UcoEu(XPy1g6R2mTe1R2HWpfowYkw7YGEzuYAiNNLwNYvcaLlv92ExD27UAN3plkA9RsLoLZsRSavHslvCAXuOIOZce17EXSX7ftZyFkuuwYaZkm(3uuk3hibCHGhPCSs6Qu(LO3dlD1fD2qWs5uAuroLTULovvcORYOism95vN8Ll6XSyW6AuA6tUY2BlBjsu1XuCJ6Aq5wlPaVw9AAE9ABBILdro8lRCOtK0UYlAC4n4LJf2oACAuT8m9VQtx3loGZPKEL2)SbMd5I2q8sEjJ8YhgMunIJT0J34XPWC0udx9rt71lLP(eOmIU5IFdkBh99eAUBodPSxXeM2ZoH1kpi71lLP))Xy1JWmEXfJ9IzFmM1BFmlU3alBdDvT6SpgQ87J5N1DfS9XAUyV7Pch1FT8NE7nLUNM3SWk(BzuxNTpTVnoaW6OKDh980oyWDE6BUIZDvPrVy8GUXTZS8SBv2LhQQBuypo1Ddzk)bzgGvN0JKak9RQLJOkj3stS4GMhbA89HXHPtzbpnQ8dHbSAXlYcyfVufcH9FSdQWNuG)lWe1Grw1t(dfXUFUr8CP0NVNtIYpEg4dZLxMN3)8d",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - AoE Hit All [P]"] = { --2024 June 30
		Revision = 3,
		ScriptType = "script",
		String = "9I1wVTPsq4)l(jSuSf3XeP(GBYjkPNwNOIvFPPetWRJrfdwl4MMZd(3(zMD5QzXgC65eKDgVSZmFZLDMbCvCN76eVnniokbiNX(9832sCNP668fVF7otESMRZ1KeFxNBJFD)In78xVFrAWgc8T3pjj7xSkMUFrCeSaL8R4WDO4gdSheHSR46Cd1Zhx09JUoFZlChbxhuWFtEZ1HgN6H386Du2)DDUZN9DukHUYZN840LlVpk5Xhc9GvEmyJ3lKKh5O(PODBEMqDDM5TH4681mzTFrH0srtPWQmZ359B57ZOerz4HlyJ(bJNd9I(zUFc1PwtpPYyJ8DmncyNdaNupAAf8M52YX5X2zHRu2id7EWUzB795mReVatrxGPKBiZj)oDhfI8td3U2B)IxxtaKMUgwXRe5jCKVn07TGOxUa3qaK3qwTI4dRheHFsjrljlH7fVFHVxklldLdYfbsW8sHDu3fXS5uoeyMndffogLCNybkZCHzB797AmQLzvp9PmTQrg37kZYuuMLAJaIJVxiP4qOzlhcTpWjYz68paEG6b4A15SNY4QaOQuhOVJi4baLljaOtkbArIZvXHX0CmWQpEJHfCPRPQBAPAOOk7UAKHgABTDhTwVJokW06gwMg7JH5Zz5axkxqPO8tJ9)fHMGo0zkkYWFqLILlrnWfORJcl6KIwVtIpnylWMg3INPBamPIByMUQP1el0MMPRpb(Jze6A2tuuWtdaPULTjMKYj1WeaGCYelB0fJK6wWQ2SnOAacvrMrpr1gHhkzzDtyRkOc1mvHQBZu0406GGvqvQROzJRZ0PLHgCFftgwTnX1rTAyAJ4wzsgnOhfB(EqmQkZP1G1uz2PSSfWNQAgnUogav1TLrADonEFvuVMYY2inkllvle7Qi)M2QM4AOEvnSTa(qBtxvN5f0K5osly)Akzovtu2iTMgtpO9QY9AAyEcyCqibIrx5LavWgbjUX)1(f3gWkNfUFX3F4hUogNmNXhy)PN9Op5hq93fcejVgSLO(uaKXnEB0lUoy9EqxwyYe1pi(zxhtwMYBqr4A11RuTpzlbrrrj9eCJqH8mTKbxpA8UOLzSGqHqHbfGaQZQDr(CHkLqcxb9i2ffKE3YmcOIWgcqtI(1CVNdrsEAk7xd3)P9lYUkOY364ROeWd4GMz2PJPrll6RMiviFHIjmgQKbJ3WhsA)IputZJbV2QGxocJqhNxiPSYHmMZe04QvCpc75oWIZ1FOIdzmMmu1WufjPrJsZzoHKMcDGtkV5bY)shsAgP03)(zMlHPr)4hdpQsEig64lnWNGQyaeoLXphNhNG)HizQdB0uFyt7uahFmegQ4lXljsdME91doU4)gHcokwDtPRjPEbHjmV8RX0FE5dE0eEX5ePdcHSvhEcOJHzPk5chF7SMshQh2IdfhHlouM08UcsxkY(vhNpYmQ28Pgl08HZMpSRsDo1lkPVISrYpiKLXBUF1kiVLL5B0B9ZzwcwF9yU4KgvvSxuxldHF359ke6IqiBSZdHilCk0f1yk(H9xO3qJ3imlQCo5ZqQZJ7zM5jem7OWFAFqHqzeZJRES7IAfKpbK)ROLNgWWd4oSJm3mIxN5QhOR)itc6QH9JRRGQnYwikXeQfc)m7cA7AuVTRW(PJgfeLqqO4dLr3VynHsektxhCufywlhC0nlfByMx9jAGA0(Z1DVW6HzA32U1xfvWuK)hmCrwbQRVHvw6WUfI4OedDme(PkbX2Q4L32)sN1XVk1nEktiVebWX5s0bSgSX92DXIpryRDC080uRG)QNMhSbMRC6kyYc4eMQYfLyred9ZNHMWzkLIO1TbWejcKb4ipl36znHB2vWk4uXra7q206rTBWucSViHgJaMASsxMZ9sUbMpyAuqieshedpulKdmqGr9)YuTVNPB78uUNKJ2YL6v9dM7(Wqqhe5Or0I34A5Zf2VQq8kO3KfJlw)2DplDaI6D9nWB(544TqduPbuYwq(d6Rmgx(kLfctPJYnMMM7HW0aLSpAMY9giSrApBum)RtN585PZV7(zvbcEp1HDluZgjbhgPBHArTo6ESUwn7gNs4D7oOEzxY8BF82t7zfXl6A9q2ZDQq)MSJ7k9UX64Y3sWzbKeK96arzSw53CqDsVLOy)QGOGK14RNVtX(MTR7vKNxGV94FwnVZi(32u5N2P3KZwI9kTuQVNWQJ5cIHLOmH8p5zeDcITonsTNL4uxWu4k)5McVhpsc(QLXxXU7)(d",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - AoE With Range [P]"] = { --2024 June 30
		Revision = 2,
		ScriptType = "script",
		String = "1IvBVTjsq4)l5tyPZwS8EI09HCPnQ5URUrfREFOPutG1XOJSyTlUT5(a)2Vz2LxmgigsAdIKnWmZ(mpZSZm2bKGvb(z7YtYycy5s5)V6PD0GLgb(Vp8hbl1xyg4)gQikW)Jz5HOOfRFZEUCfitcdLHe4Fnpms(S)iW)tHP7PYNBh4)x0Nc85L62O5nrYFZYP8nHr07Umo(dmXD3Mgcp5UKhdFGkUtHTVY2)49uEG)YWhP9IJCeW1y3PsYpStjNDdKkXJYW2tdg3NgY(3k2a3tZU8fzHDLexYa1vaWppKN3L3QW5ZjznxAuc9qqyPuVoU8G4f4jw94jv(Xk6pY3ZPfRVmD32WI1FFlfaA(w4jHnaxOa(U0WNsyp8BOajII10nBOrWZty4DoLftJH3LvSokmpABPDqTOCWE5GeTziPpNRGG0TLO4aEXSIfRXzjhwk4RNCSBLA1o)PjVQtk3Rk1YPVulJoHe)OWuA9XqNbog6DenQu6LFc8OThGR7OZFAISJbQVIy4rqvzjaQEnqL0rQRYsZ4vWrwr8Ahhx7ZnSmGBhpxtNGnZTnr3CO3yo4BSqdM32dl3XP4HrkvoIDvgkhTFEw03OCbYTljeD4hOSrCmUdkdg4tKbQCKg8fr8KDGAMkpEPLTPbXafaws0p3d9PLwgU66ePtyz65yyGhmwAz5O75G5RWsxdxcMlac4ccJCnS8Chl4TNJc455cVLOlnSPhUguW0K4Ab7aUNMg6oM4ZrI0W1WcKLaBPHTlXfxBlxBAaMK4OEUdyBcURgM2MWwsWT1WZwhxFUATbOlEtaLaxf89RcfqrI5qMr2Blw)pj5qXOpgYEaOYpF7xc8Tpz4ikHhTpnK)vX3tqEelIc22fdk8OKS7d8DKm(tqLTwflpOeQyhnn9G6KcuqO6yPTlHxipBplUuLia5u(ciiAf4VzplszunbnDdu4Dplj)M4YfWHShPWAk7BRcVpfxQc3Y)BwXFwSU8QEvLOlUItb31hDUYSSlzX19QeA12VxZKMbfhkwxoErX6FV1oVaY33K8qhXHs3pqZL1vgqLfhwfRVnE(Cz8OynVEqH4YwLDfU2hwG5dsFT2dxunPXf(06UTA9GOJNUPx(ONDQKvrZxUu7ZFEsjDl2XE4lFz2Zsd5vvie08CO3SySy6tuoORSUIMcexCBixOkzj0go0ify2SXUpYiP2br(rRPSO(Zae57N1Mx6Z2Yjgok4l19ur(odJnBYM)AE2JNYpAg8z62Fv2izPjZqYy1RHHM8gjxGeMgzHUnuld)ZSxMzwLPrqlmRlA6ZGVLfFs3h(apZgNUDtUARBRJXTMSUN60yhM22)WsZ94DWu4W)cxqleOnxXnf3CyBK29hUbVMppHjOimIYIHsjBPCA17u)vzZBc8HgUgEWKvyZxxY5U2E6qZCF8(NvVQAphM0z3WE(ykI8UKyQ2S2uIXVIUQnwCKXTgBmIsHBZ(U24uPEVUa3(NxPEoe1rlfXng3DKbRrC8zqOF1xxL8imA0LBGMvWrkd8eEfu6tHjryOd8cnYXPBhRcWIVio9fnIw5vYgi7EySotoTjBy3LtbXy96l9OuNNuoWN4GTuoXxnIUq5CvtgXssHG5zzWNSbI(N1Jdj(vnt1a2)2SewU2zru06NbGthVhHI(j)hvZXcK2X6uIpugZuQpOMK(WhmcZnFEZ8ZnF0LjvIrUVLtoQcM1V6D7Vxt0kBBAfVaw8VZY2bne1oJt3b2(SjAIfnFpIdIsTNZay2yffHrFs5TPJ(SXrWYo7yp9XrW9uoEcmCRkHIE6ECurOjmM54yWEuhPWq0cv8huYU8CezYqP5dn(sHIaTqBOqwy2872JloyGTVq9MewIyl(DFoQqDNwEtlqRQvoq4USIYjd3dm164y4okpqOMmqjZto49Rag9fMRURc3d3nUEsXN7cMIK8ZBkYbM(U3551vFhJb))",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - Debuff [P]"] = { --2024 June 29
		Revision = 2,
		ScriptType = "script",
		String = "vRXAVjUY1)l0Vy2nq8BWrAVsSKM7MB3qq10BRusCycEaSQXdAS5MD3QYV9EoJFeBSn2SjPQviwMmZzoVMZZzwhfNzo2STrESGqy4eXFp77BPotuDSVH8n4xzh7lPHlCSNqPU7Nt2p)Co1NrCba8cCMyaRq2qDShTHTliA)C2Y9ZTPR2qdIcDS)DI)oaDdCSVItwGuY5jh7Rxa)AFDqeLVKSGE)ix3BdcVFQpbM5EVnKv0W7JzShd2T5jk3X(Vq)UJDycIJjMteYOz8SskqBj8)5yMpJNsFHSD1WbQ6MQkYYd1Knvgy6SSNHgIbyfldvtJbY6kAQMYdtwrd32eD8FJsftBe57NNG(trqweVLyTjY6ALz9v(SNRIZbo2y4qzdvzDJHQ6i)PJC(ezenxPBPBOOAPQRpqvrXqnH)lY5Z4ep)3eohqzeBXFq5H455efqLkd2jexxeNXOWXwryffHYND4cU3wyBAXc0eDnGxhkKaDnfnzlHYgecf5bc(ghQyHMxaadnvaynXHMAQQO50eDDnde2HIHWcotSqaS00b8RiJtpq1ehJ0d0q6O6qvGAvvCCmfvfWliPSSfqpfdX8MiSkMIXAI5bQbST1q4xKF0uhaudgd0v1WCakeG7YevZHQA4VOcyGXqK1qMwx1utgLznb)OiS9q6Qoq3uCobQRXKqWhQ3(5xsFA3sWv6UPp4yB04j1cyFp(eH)ORyF93gSYXwh02aAbNVzu(cpg45zcwWRzplCKD9wUKYPOtljaWdEwVF(sgF)8O109Zxi4faP9HdtDh7L7cwedJui1F5z7NVlWl6A3KbGd(gkmMg8hZip5JdJp2f)v39)2(5jFYg5Tmbx9xSMeeq99cw1vq9GCGN8HtJ2XdYVDAGBTy96WRd(RepxPUnHWMqNpBbXpwB8zcOB(uoXTF6S5qsS0NUYF3ZnATytjtCXVsJetkLtLKSwFr0LlSPr)oLhr)MWxv6sAe45gki4Zmy9PeEivSwOuovCFWLEP3Q(Ve)RBLA9sIgqjqtqTJanYI1yy(cY4sQ)Ou7J(LGndzhUYfOHwEHSmaVo5mlyzEXSxVQiZOiFsOuN)XuqjJYsVB5KGvuriXonWIZINt6U7AWhe5(h5qIjxQ7JpV2lIIUHp8qd4)luVvRJKYzEKmdy4(X9ZvBy7F2hSBVH5sL6m6YlbHz(XHFK)21ej5(gnG3l5KN)k57uUuhgeQ3N89oGh9GkTOkT)X(uqr77pL5bzRBYiqaLuhok1irk4na)DNfuuZJljJFRKhGdErcUSjebY8e2YkfJfL5OuOAcCpUSYHjk6KCmFJelLW78EOmAYmmFTM9cXSS7Dr97Heb1azFp(2G08eymyz7kfX3rRa6AvsjNCtz84efvg278MpkAbfZXX2E)GkvK0F04ScKo1LQbrVsBEZUNc)uVPFH8tOH5NAHvzTzVQG9RXpc9GYMRKduAEl)q6PqeF6YdPr6usE9u6(HINhNvmqw1PCBZzDs4RJCo(fpiw4PCK1peSDfi)wUlC2Fe)Jxa9s0dbeSdIKwl824GR4SnWgupUt4bBAgl27TD05w4K2lqQ5d8A9HDtKSzEBIJ2vkaf4p9z6p8O8yBbWu(8wyjJ8Hq0L7lRi(PkhRdycbdqEkukpx1R6TwV2HGgnT7aod0ChWYgTzd4HBJwNVa(mwAMy9txwupbHrTG0KQh7IzKa9yB2SDeHdPfGWH52El2xonsFJwTJmLs3gllpRq7X74ytmZYLFwPcWMaRpfAdIgNPhHswgh1gB3Ql4inP3UWi2grEwbERaByWqba3fXcJ4qBoszm2J2BP((xFz3hYJ74sl7d6KXXbsfB)kg3wG90oWWe0NDalGFRHhsXtU20anDSgUfFG(ank2hyLn41RNxqiu8bWxqDP7NVg6YmVgmJEo2qpZdGgWThI9xRyzAPRPb9Rc9M)E1Uz11UHTa72yHD1Mm(TQwZ34Aoli4jiRXckAD(0JLdVWKhRp9FMJJd7HOwr6nT)2QuMnZc123tDQ1YAUgDpb)f13d)Lt7MpEVAbOiEJlK)q0M1XCfsrDwyFQ(LqV5)1)UwB2aw0R32ST2F5K0(c4VnUZKlgZPqkI0BNiWZhRbpxBlXZy0TD(HhtMAm8xd7tidf0N1wLZbbsvLfXjHmkBiFdckK7ngsnxaWdfaEkbttnDANo08ir)AryzKGzeVMp)2PVsw1tar)voB328ek)SIl0nT7uHaNXNciowW9eDhPWgQHq1IKI7oUoVR8ci(Xf7fFjdNS8xgRFLX2ILw1zYTt(ZD6(kuQ1DVFJV9MBUDY9z3JyHl3744AmJXDXM)SSKJBcsw5Gb6kgwTdFLU0VxH9JO1X4(SkQrpWwrQJ94rF9O61sDJoJWxrJEP0JxJzoAR0k2C0xN(LrTHnFPxS3y2u9DGpvBfJ2M6UQSu8t5duVHY)N9CqI0Bv1l4)DFDO6E6LW2uIFTc3lTsI9kM1K7VCIsCclfKVr5F62KB6EmcVRMg4FO07g16D(sUOlMIxwrL(hvDDaFQUf(4bQJJGWkUgIAx7JfUII61vfpDlrbGe)POMQnRrj3Ay13g8Xj(V82qBlRFUyyP2Qm(gIV3pOUvEww0F48yB53Nx)mbzBXBeTv3AAjwp9UA7hF5OgT7L2A1nYNWvFOMNNU23uRu0LarPq8DBBruKNhLLXEJhEnQkcdFqtUUFOhM2OYZVpKaYwpeBDp(vLxXlBMs4899GVTrBV(7)NIXXlbP(03IuLZwZzrr(0)2wxO8cbxllYRdzPLJ)paKZ)5p",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - Heal Cut [P]"] = { --2024 August 05
		Revision = 3,
		ScriptType = "script",
		String = "vN16YPTss43f(tWvaIqCZ4QYp4IVW5yJDzrsQDJJmdsdiTwmIvAKDy36WZ(29OzKegjW32TQT4KC0LE6PV81FDpkM1nNyA4VI76ZcHlhlUFY6vuZXTnngtwsnn67rypSz6LUm4MVt8IGxQzA8N01QLw30yKLpd(BgNgmNyrVRNT91SW7UXJap5o3LKf0W7IL((zOcnngsdTmnm5MJ1t31wQD9AHSBMQR2tJBc8TJSOHBMs2mL5ZjZ8OBMsNpNAX3m1fKL7apWIec3oJeSz6touMq6WvupVntNh4Vuk1NMe4Uybni8tWB5KaoOwUF8QRTLZP)6CopYmQxwNRXECUgjo3POYL2M0AzGOBM6hiFWOHWnZLIyelsItdw0MPsxcCE)FdUndEKJlelkbVT02ovJ3Pt1SyCIXkqBfauA(obkTs32MQTDGiF3hZ3d89WW1PmeAyRSH(stikKIYcidHCVstX3pja8dbSIgVlvamJdHTaXLph)zH7tf0WBNA41lYWv2ROme)pDZZ60PJw36D00AQ1vtVDxZ5vB1eXuqGfcbGuCP3z9MDnR4Le7BYqycqlXBQHUrN3e9qN3zw)40DfkgVI8BrqmBUiJPQkMrG)CpsOZMPbKvU2ERHmfX(FeHc54)e8wH8jYrdRTzQW(HhckyPRNNBifmC7qO45kxg4x10sQHplw5dJciOzN671Ak9EHAtF)RjgWIwoJcjLZciwIv3hdeDZjqOPIeJywbusyE4qhQ7ch8M147qN7XywNyNkha5fYvCLFszeYELG0aHIf5D6wZq3c8HxDcUI4zb0pf3oiCjb5ddDipqZqlIuORqdPIYXdPCUlBriwCY4b(EHs0GNpBrmAGd6itgpPE1iw55KW1LrgX2)rMWRxpVmEsk)c0WdbVqy6QeVWku2V(wbBLjFCwdU3YvEU8iB6BZI3k4KQl061316pEBJpUgm1SHYo)htJ(1Z16BQL18plG(pJOmR1FaMFQU4iXk336ryebC3HuHMMg4feBBCtI1PPHGM2GJ(OrOvG7kyznKu4nBP1PvBua4s96T1fe3n01724yb7T4YUyLfCzZoDAJ0Q4LDR3ejBHlBR1SnMVg3OPwRMnroGXnA0QEZgI6gqIo1BOjqkJ1B1UBRoI4(y9oTowhwzDqUM6DRRbRdvAZwWLDqNtxvWxfl3jq1ZGi4UFEZVmnADWOiwlEpqUCVdSuIhnGxBfBHPboyaOCGYFcnWY1hYATLCLqnyF)iMfvoBYTu7Kw2ceWGyIfC(LaBAY8BYP4G)4UCLFaNW4kUaeZ7qwTIYGA6AYXGc37SrZDPE2a(ccggZbRjEqSYHuV5GbgXC5JSLxaqVLiZbL94eSxpCzCkwC3rB(JntL)sUQAvaD8jWYO)MAfXX53yijmN7rxeaEVDO07jbWaeHPR0f64wgMQDZ04aDTrHgaXe4xYWYeAi)iHlXYSZzxTCH)DFgDedOjHqnw8Tz6x)kmeOydlfpq5(LC1JRErYXGhxQqts9lGYJcY59uik8h5Et2WjWEVoProHbOpXzvYUY4KtTZI88GWKaQDcy4RlxqgkzfwrbqmHR6191mz9AYMCNCov((I0waKw8dCrgybAZMoNe5H9PC)xuvkfPvCdq8EOROaa7Zq8G(12RX3IQiBFlhxBQcSD0ZWijM)1aK2Lr8ITVcZdiY(edAIBwScoC2WvoJXUJyi82ej98TqcfN0iRWkYnywG5iwLub5yl74vQ96Zz04GStQa0a5McLyCqxsX7lyFKetkIH6WFQPR(lygVC1vc(raafxj7SKg1tFAbikyefv8TOHXJpRQnj4bSofp9bSd(mV1XyelKSCMaqbUwq0konRVxTASpdqWiupYn0nmzhfAxbKtofnJ(0odHX8XNJiBCnasovxpgplnbEW1SlaeDTD92Tr03pGWgPm59Z1LHiUg01FU7IAp78DhKysbHm4eEuyFsskpo6CYnKaqJ4ZcZAKBThh92412bZj02z(bgc3sb6oStMVqwBlHY0ZfVL4x9jwpe3I6quO7WswdoZFWdPLJL3lp6w6moavWpOlDRT7sNB7xKxkeMabHViVjEUGNThMg48p6WzNnGzPQ3rx)42TBO1a2Hg)3yoG3x383(ue)F(8a5GoTFriW8BWD)WyoSDAWTfDl3Fvc)6sAarDuKCy1HteS6nXQN)ukO6YTv4ZRfFUG)pRweQp0)4QpQwvYmL0OPCCZLd0WkxU34Xk2p5x(zC50K2YdQVZyldUE8zJo)((9g8NNF71FB8W7p7YEgxC)WVDBVjJUECr78wFVN83AcEwKTApITnl471KV)NDGM9fdsKlFlbhKdzwiQdHRMXEgCa8DmP9dKfMrbVjdTXaXwkFUcjHFsn58vLEYXLJmihYG3UoD68KtqM89EYZGZu3(vLnDI0MYwtNfsNtSDRpYZEej5tHShzs(EdvWSGxinZ)xtgvKbiTA4nYijubFJpuReM1Cp6Wboo93a5Re1ffQIDKKS)mQJlZU40VSczgWpDEk)0eLAFECDe(XcsZ1)8Nz(QcdUy0PF)0RoD8KZUT3vNE33gvTNLJl9r6s4qzv7HFtHQN75)0V(vL0Zp8dxBUt5J(CBTk7EOIp3cFAPzjSNLGB)34ZAQP9Lw11vH1oAFrVv7)ktalFpcPr77b8IxjgSOCPEdhI6SZlALddipDjznnOCPR)(P3EzV)2lFTI0lUJwumKvs6TO7jFYHvdoZD5dakej6KZvduprZIrho(EkCWZp9nAkcyl9WTU2MAyNxMYoirm9uBYfOHuoFpRswFr9t1KQ8rfp7rrXBy0SY5pkFLp0nANmsEJ58sYyVNusT5eBy8T9MzsKP4eu2PFE2QruAVlV5IELKCyhQJ6xuvM1606OxShiQXKeXLp8w8Qo(JylUoIF4OKqO3Fys)LgMe9eo617jFerRmF8ScoU4(erof7oA9LF1wtOcZMw)J8SBjkhuSw8)0QM)Nd",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - Heal Stun [P]"] = { --2024 June 29
		Revision = 2,
		ScriptType = "script",
		String = "nR1EVPnsq8VlC)JPjqSnyiePwjk5st7LaizUEvkjUEdEbSoJx0AtBtpD(Z(n76h4N41xsKAqjy2D251(BMDMLyOySWqNSZ3M46bpoL)5fpTdBmv1q)w0pG3Ln0Ve7T0qFkgBfyIcmpJIDiilGaBxJPAWmOTyd9XBj7D9dmjRcm1XR3ID99m0)mYzpoKnxrrlzIY4rd9pUeEx)JU(y6k0s89JTSM56D)ChemY92BrRXE3hQzF1D)2hXud9)a)KHUxeNdLMHptttuALyDrFhI(3bMtioeASoWTVRoFGY5d061xUVwVb9hEUXQoA9ymbMCApy(rYkQ9uvL7p4CnvLbrZ3NnVFSoW4EeVBIHSmCjHUtMQ3Rev)doKVxQMpCypnTr9hO1xEOYGHAjAomZq5rkdLL7lpswDWi2m9zCNztz081aZFbuCGD(KLFdt9yBNtvuKHFm0rwwmEgYcdDfokYNzE6ElP27GL1l0yM2VNQgGjy(9EQYNRQY4jq9eKhaH6eyEng5a4i)9UbM3n)bdDTQv2TylB09E(KDFDqFd9(GmaUneCTy6sBca3gyOZyOT76at8Qv4LGq83GG)Ue56sG3FehyAZ4pD)oFSvxq9bwTAVlhYgyk5HDwDAG5ExB)pAf9aGO3IHNXUFBb6rh2JHgk)tTd(uGz4lhYsM5SeSU3JObMVn167gpAc1XSlEM)Y2YFdFrrdCXhW(8bLsjJO56YX(xOJ9)mM6J)bF7w6sSpY2XJlWVtG5NJOEy(CEsP05UaQyL96UhG4TtjIcgeWF)9uSUpf7VCdl)qglBf2zSlaLyUWUfOnHz5N5c9nKVN20ksWZZ6scdAxJqg77G8KA9L5GJLzjDMrrURXlOG4ADS1oXbdRWXzobavE1zlCQKArTxVXV1P52kHp3AjMbnztjZ(Tg2DnMXiPuGLOrQZCFVd216wIfwQ14lVemqZACpo72GKK7QvdFVKI((nONWuPweiRHd6jMPmSuK1kceFyZbskzJNsWMzocGTglskovkc9yaZfHK4DN9dfztNorCipMJPCj)2U4cRyzViq1sKbKBgbpd5dTK8P7XLqDL(OiGYCcnmxxPjAoR(DcbKyknw3(NyP8I(KatTtZi(yOlFoyhBtxie0ISLVbOvNxPuG3G2nrvRouU61Ad1ajXaXVvaeCB2zry3s4BrdQImfSCejJLpfrYXkoE4Mieh8Q8YiEij7okTFt2npyy1cBsDuzdx2UeKPPHaMOSnhzh)ABi1vt2C76bbaCMpJAbOKJeiFG0lzHzGbNlXxL0RZE4kk4nK7QE8Sf5w0csyAgXKZmaby7kvpqOYebwrw2c7THzmlKTcciFp(N2yAigbG4NjacNPhCtxURSc)TYcbZPeCfa9ONuATQt5lTtNYwmqlBkl8J7x3eqbIb0eduKqAkqHSMilGbiQfrFG8fKqIvA3ylrTbMIAgB5G38eM3eSlWDY8QcWeDFefovcs5MWgHe(b)IykBSJjTxmBULKNoC(pRxbwRgqdbFPq1MLui(K9ukaNxKQycLsiBkm)CONdCyzjmQKLzpjsqszkaRPdE9j5omdCTSWX8vrXjpP()grFCQZqxxUxqZqAzBgQ0UC60X21dQ1boYaQHmWCdMM(aNd82qFKXunnON3ZHUbhQmAWWrJgcT)P07LRNRFzlPSQtRQa1(62QvKsiASsHtyRfQMQUlzrGQPOVxf0xiETaOfqsQVgiPM1h)Rv51z5BybY5zBszZhnpyAuZraubMSiO)5FlJz8sD5xHIGGXkl3vuWCAlDcfdT8efUj5A7WQsnfekCeT6JYkZmsJ8fqRttEALSlF6zHkLGA8W2IkPufSF4wckakf5QeQxoXA9D3v1vXDB6RI7HhAe35neQmGvW7aXxOGzrRfMgNYUPWZ41X3XZeIuz1z5opsvU8JBoYXond(xA)UIzvSdWycmr4v86tnFMKs5aH(bkz)U0ck9OmVvsZ4Cdorp5ui1UwFhkZcQqqvYKSRoSOZRSDroHvEgEDln2(lY1BiKDaMwQ10zt)9wTFgo1QcwNm72BNn9(K7ZS0i0Y51ecHAX6GD0i5Wo5KvY9qFfTrIXVcx04Za)W7)nSzXSE0CyfPw6tgFZr9RfAPEbIUg7lfn(Zsn5DSiKAo(M5xpwe18qZHVWQP6RGEQkKIMj7DfPYpALFI8cQou5xMQd9tF(rDNXu1bBjDG(v25IjTG(UY7nTYJ4Iuj30TXg3eBdBHTURMW7UkAU(HI13l6kpKl)I5S7DqORkP8M3FBvtCso3ZryyjxAqLZDsMluOATTtNDuwTELPCNwj)f)oRRw5bT)38RRgPADQJoV87L(4c)DVmYE0O)FjCIdli0TihOivRsHjzd9olmS51Pl(iMTJv2Vq3tBbvpU8F2H35Us6J8fuEKVrGiD5nv8TxNVvJCxBWgkX33b)N7SGJycV7wEUDitTC4))cg)3",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - Important by Color [P]"] = { --2024 June 29
		Revision = 2,
		ScriptType = "script",
		String = "DNv32PTYv43fFf0tqrsGaJxRCb2ux72tWEv5ZPTlhllH0aOgHgvnIKqUG3SU6JuFf6EpZO)Grcioxv7qS(zpZ(B))Ep4y48KJnnjlKgZGlNXV)PTjeNzdDSN5TM4y)a)17CnCS)DVOnWR0DS)lKT5leE(9(0y4)JZiPl88jFAsqWdXSp9yKh8KpfU2BjH9jb1VopYl(Zo2tjmFhBNmNzML80AFEAMZtByV2Y256TZLLq8d9IGRJHDwqN)kV4LHXl35MTIa36XY25o3lfUKgrt1QbyZZdWrEZjrvbC)AaU(glr7t0DUljzC8gfIGHUqILDUXGiYE3o3nmYv7CFFcNPY3YuObEtGDqlw0(nyr7)gTOwL8eG)h9(gN3I3FFSFkXJryst1kIxu2kPXAfjC5k0YTfFBiqZxe6ZpggZbPa)3jxZ14AUtUMpsdkeN(sXb9daIeKCEcv8M1ZjPo23M65JpWzokzdlLSb5O5g03dKe8oUTCN7nOPmhnZLGbm3fKij4S0YuAHHTrwcqCujenYHytqJhXJ)Z05wlZH917RByzoAKUP5iNf9S6JQsqVdclqvMuqeMmqV(dif(ILiedvW)Yw8xh1G)6O3O)64Aw1CJ1nGZZ8cHuW4RZH0VXqqZtZW9cFJgu7v0VIj0GpPP8lNt)cWb1SbGSHEnZCvV9MSWZ01g03O)iZ9nQs343KWuZUQeWTwAPPmrgV1urgQQUmLcWBsE1JRkYAFWZRIK3AIyJ(kcm5CS5qsRbwd1VCSL5yJlhpCqZHKb0S3QrBsW)CdA2efqfvQWIw87dqCwuVvJlpdomlp4vk3nUG9335(WIfmsMmbEp89vsOMBZZd6(wo1)ijQROql5lItRJIZ)HkCwz)Q8EjIhwxo(rWlxI3wbNvQTmQiOuyh(vEleyvr7esu09bLElzvc()bCbWMtklnZiP5EambJ25gglFcWM3Hobb19rWUzQqLaxOezNr9)cjLH6ii8xh(XX2liabNalo2C)C7muOTz(PHjWY6lJbg03C8Wr8mxdgmCKXiUN)alif2yU7pCPosGfsWL6qagyx4xAnc1HZ6BAo4YHynLz9hymsFmMQhEQHP5qUtWSbMJhyEjcwZ80w925E)6eAAMxSuNlncp)4lo2whvXIgIxH6gVgMVlVoFROl0K4Lo2degnWeFnD9CVG)7)5Ft7n57PErOIziV0cOI5D1cBfVpjpajR9(mrQJxtNVZL8TKiAabmjSnRxJKJGml1lMTGMUgmjlQ1nCIhd66c6egcCTxSj2xK6TdJeTaBgnom7(a5fGV9ACNjXF5jV5rCMWTo876U7pVZv(BXv5KQb1TsHE1Tt8s)8vyDTokPhzR21Hl50froGYdEpj7VfgKTQZLTtKOxpUuD1FQ42U7C)LkIMwrlmvPP9ngIWIiDmANOFhcGiFJ7W0X4DgGEJ)P7X0t3fgqArpDmIkVs4lQDBKhBvr7vxttdWjm6u12QRPB19exEW29w8fxi2HrwT7mWw7ffX1CLLvXj5ulg96fkNoq65gx2Gil87KskJO(4eGfVpFiGpuicbZ1ssPlcbqWPak2fViCPgjMSEBCIV0f4vGJyyiS2NnFPKbQCvk8UaLXbC(xQi1fAoBa0Im8NEmJ2QszrfxSADNGc1tkhlUuDGk9PvExhfciysnRhPRjvA5TxO(TYY2QF52tr(RIAun)inmoRZfZPzz01POOJ(BYmvh842quVZesh4I5dnfrxllb8bLCRO07ZzuwwAy8Yofs2RIc2t7(slrRGeFtLE3VLMAZ5sEUzf8CV5tE3Eaf)0asVUCj5OuPMalF0rnNRpgBxEWACL9yVG0e)7dS56fUguHsAgqY0UhUdhgrvAiK6oi)n)zxV9X0qAAy22AjQuia1hFT7(88qui50us8w(setFxJnzPBihUtkC4dQQQHBHYXw1lhRSolMzu0CMpuZhpOKuYE7eCl8RJn0HZL9HbmGMEmgzmEKb8d0Cdoj1pRQ(5UTz0KtiNIYO8ZOhI9l7TFz3MllkX5FLSiLuPEM0hQeUNFnmu0))TAyTPcBZ3FHxedvHv8brhUF(Ty2RhK1odYCWuyLuuZTT81fNkOITcBfDI4yyuVbSccoCX8NpjkzLxtR2RKcLcj69KvC(Om0lhtAcxYpKOQT0NsxcE2mC8lwyarXrQ2ESfhIn8gmery9V6goIUhNVrvm(r7UfC6UocCp(ip3vNlMmD6fhBrAFf72NdqJHNrlt9pkXEfghTXhJwOz(SnqQwK6NF(it(Xnv9F5LtyChHVX(pRbvoNoUo)bb2Aoz45b4IrvHTnleYg9kxeW5uvlfqeiMhS6x9YjLVSUFMscoq2lE3DBMxnzTs)o1RewwBmf7L0(Mj)6F8c5CA8bAYNzd)OPFP8p)u5LPcEPRn2s(NUQu8NYivhJS2QAjY6W)cR8bTCk(fTTIFKdl4NRq9szhA152gBXk(WEkPQV7yDNXz60nP5ATMizY6KOWSnbTTn3Ms(xBiX(BZRsv5V6L2CHEhVPSNs(eiSAnj0TTPf61BtsaxbkpBmefv1DSpZfFEJBUmiBEiKV6Ru8mMIj4b(ak83NsIOEbTQD1Eag8jm2lQqb0CvQQQPtBtZv8TUNfeDsBzHrO19SKQY(ik)f6OW4Nxhf7zRsiP(K4StOig3PalGfrwWh9SHdusCqvG)YFOAwHxXb2EuYm33dUF66D7ngD(oPti7MiIx6KOiHR5roRScOcH8TGwmTu7uCMYd)8th0Om92hQSCK56lOJkxaT930MMeR01aIy9lB(IJur3x5(mO)heRou)UVJTyXi7zhEAvknllI8Bs6bNE99CQb3zDX3EJZ)7p",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - Ongoing Cast [P]"] = { --2024 July 30
		Revision = 4,
		ScriptType = "script",
		String = "9EvwZnQrq4)l6juvwuIllzxvEWRD5SEt8rv4SvsfhmJGbjIrZqnm4v(f(TNEoad2iH8XM1RLhy6JVVUNP7wbwb3g4tZ5PusbS8k5Z3(uowS0)3Wpf4ht5NsZOSa)VJYkXkPe)3w(PJ8t3GZN5n1ZA(rtp0A28zh6EuqYep3aEG)vO14a)ZO8IQqTLUiIsGpjCmlbfHV7K44Rjf3DtgcEZDPRrlXf3PG19rkvodxe11kCbeAGRDG)LOnayM2v2)Sk86KKcmaKltjbxnriqBi1safbVce4Cgks49GfVnWskxVaZ0rUnA7YfrPbb6F1hqL25PxJV2eOLIVhO2IQCrISbOhw7MRLkuf62gbsKPmL7BZXlYqKhQ5UWNE9eCQ3)K4)TSGxfUI(JQWeKyjFfUkCrwk5HuYYQqAuujRqh0MAA3IrF5zaB6QHCrogh)(IuQOXxeEUk0xAhUimTD0dyQkeTMwsaCttaSZqKICedtIEQntQcJqGORqpIRzs)8qZI1PKtYYxH(eiIeJkJbSz2UydAZhGnDDQWuAg0KI86s5399U1Onn8zENcADWW2QQDU7mhhRJ8S8Mz7An37qrLmhXD4ZDp0EMT9CllhVP22tNR3XvOjx7Dze4JwNtQVoi394ohVHxYWbIYk(CA0JywHiGDLL1u4Fb(O4yHtv(iWxsjFUic4xeXsZb1C0011XY5qxzLCxBhh7zcBcsFQ8E2eOUczjv6v1B(7B(NaFVbjuei89lqS7Pk1nZjld8fvwaZpdshywukfQScvyUvYou0dlzW5Q4wuMa5QCHD1ShQ0HQczyqMiv0jLeNgH4QWIqLijktbjxGLVnhGjLTghBwf(hf4KYmqsAJMcvwHieCMuAO0qwgOCSIZXibDaebHyE6ASjemHQijLKiv9qJcCwYbvHLKu(fX6fWj41yynM84TOfzILQWU8PXvFRku)tZkHzmV(xp9E5bZBvj4JpndJyNKLDdGgEHX4HK3hZLIAmItZZWj8rhOef(t7xnv87BWAlOCoDnlD5Qow8fV(Lw95vz0iuMmXbISKHXKdez0siY(lvHQtohFdIvGLh6lmAfUmH7pjPlnF(o1(a8Vd5l8gP4gV2T7cKs)iRSlbxpir2(y4K4je4UG4uI5febKoRKjF04zpmEyDVUKpSYVIeqVbLDe1a3gpQBG8ATrB2dT1vyF7bIZz01svn6aZX7R(3s1A3gM7FOSL77AG9MgAd1GJTWIbnKWi)oLMdLAmgXW5yeF0W84y4(Ytg96N6coMWa7nYB16sMPq3ZATzD9lVd6njxp4F)7QhUT)n1tSoEi0zQ7MDbjHQUADzzgpnplfZKiFQ5r7pxfpTLYaLKCOhJXoy54EdQVjxcZO2FQzYKE12EFso2)pKC2g(gm9yT7yw13WeywBlVUDn7TD4KjPKciJj6Uhd9gwHz4xyj4r4Na)JGHx8Mh4ph(7mBhlpplxOXSLZp)MZTU(cTu7pBRtOcb6lH2)bPXFo2XECV5G6iNL9pJq0KjrmSCAkOHrsgQyvZyQvH)yvAe88dyCE7XyHxNH7o2gGi90Ma42DxEvFP(3rmzOyRJpvck97niPzIXwedZb30gTpZriVGvRVfOT839rtvVHPdeTKKhvN6etPqlHGuIGb9p1)Ghl7jW0ApHH1dCPcon791Yfg9YgGX1hyGt7BJXQkFWzM49s(VMgJ1Yp(TncXU4NC7TtrJTOM4ubsKVgPZWWxev(PZlY271Sb7eGY9)Gi0UbHkSApEWkWn3(T(8U9V7Y1tMiPIiF3KS7cLPQVYCW)9",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - Simple Interrupt [P]"] = { --2024 June 29
		Revision = 2,
		ScriptType = "script",
		String = "TNvw3PTss4)l8sGjGIwyXoNJFGf7yMRn2NiNCpZehz1i1aASqIBlj7WCpd)2NQA1s0asaEzUpnhsSL6T6RQ6RwASLM1DwMHlI9cdIGhhXF)ULlOwJABz(B0LzZQzz(DIFcmUQL5iYCQLzpFsWJRSVYlaEzOtya8ZGykBcXHEFxx3BcIU)wFcmY9EZjtPr3NEupmg3OL5aAKJLPvS1i91sT1gsvptQM3YcDtCOrRSjRSdcJjJ9PRShNeVYEcjc(jDYeQd8BVGv2XZG5C4dpMWwz)8mAaFJrlO((WoyHZfR6d3X8MoLYI(amBmHfdsiomD3kzA6nCWSYw)LPN(KXuFz90Om90ixpphpzb2eOnaWWk7qMyGHdGxMiwIz6sYvAaoRSfQeO8H)cu7ayOzEGTOcmBLDukJ3Os1SmktZsPmMlaP8g5mTwl2McXMer7dUnWL3p0pKLj(EzsVpNr0dze8fSY(8aKh5(cHsyyUb435mlA6XuhOnZibtrw62uqhuG1rG3EnW1eahxxVTqnpye)NU1fD60r9uToQQnvpvvV9PwtA0QjsNallO9WQIlthFzQMt6ws1nHnkNRLRnkOA0Pm3EN)xMP4K1sfcgVM8lUru2xib1S4zK7pXNenBLnJSWZ1Fj4PiU)ReCrZcFolfs(6OrkRS5kbmiCaZ9899IOaWDJG4NR9caLtrnlgMVNbjmcI51AVcGWlyeh(O9EzkEqY8XuwM97IuWNlcWqCAbgc1mlXWahgLevepCg1B6m8LL4COY9uAINuLAtc5L8fl7pZ1NXVf9rIKEPapxh6IQfOdVyhCD(ym6hsloenNGPeJMrEKkLzeZIUaHw9mfpIgh7fmncdodIzH(rc2GFyW0u2qmCgsE8S4v(zxGdx79YHBMcEzhUM2UwgD1Cx(LiWJaTGd9mhphOz4xtvg(DNVW3loXLMJF9wBjEPL8AufjUcIF9DX)jBc)0OW1ahc8cFAT9FdR)fm6FKqdCwMdFd1TGV0sEZWhccIdDEc6tahbCgQQOTN46IhC65yzYZwBgJ6OzKdZBbSndrM8MgAggg4cg1SPUo4mW83nBA00injo)rdSW2OMT0oPJgMyDuN2DappKTDKHrZonpbtbM(4PysGrg6N0UDhUZfg(eJwgCQcCAT0v7G4wplERbu41dCPGPHBjyjlGr)XT)0YS1bnoya3dqgKh(JepNh5z8uINsSmXY)GuGS(3rzoEHHnmx6)ejGezz2MBAwYdlbB3YmxSiz8ZfgpdUBnOI(KKaN0guQgr9NarTjbEXdDfpaEN5yOmn4P7WIVWJPwC(B1w93xzl(K)KhuiRkV5X1Bt5H(KajRrnoEcK2U4dJgNWKgNcDvvGmA0aieFafWVOojXyFBbyM34yF6uwycuar0rgHbDneTf6sT5k)ZWa6WaWAe4qXiMv2NDg0(gFlvsBfC)RCXtlQ82vLfCFNWzrcaMa)EcY7uyfViX3hsNZRt9z0LxTwXhz(oCsyG2eNL()mjVQIO6ZN)cvmFzNgJgfhY8WuECwKlDcjXhjsE)B41QCxnMfWJrDXrbRuAIDIpuG0DjolEeYfkM55sZit12Y)Kd)BGwS9ci(P4RutnYC)Sjnxnl)aoS3WtuuF3A6CTnFL(Hoe)1f6ptGIcnMLah(UehqbyzhTktwFu6e7l3cbKsPwzNKsepPuEqykjk)4RUd6T)BWnXuAHbRfCKIady)ce0lK5szIMzZYLOb)xrp7hQknl8SYPKCon)jrTL1oY1JECWHdKlczMCcwgEKYDPa1QM4nvzRBZu8IKV5Gu2WxMXUleAFzY49e4UtSPcCfo2JsEP9g9UXzMsW3Zhi)FRnZ)xyIDmIiIYIX23WiwSfWTKJLjwKS1jwMqrtToANc1s10Hx1m()fy(RTaZokYEixfNX8HbPz33jJPSXbsMVipb5CkJK1kzbX0qhDlEvX0fx2dpo5ONdgUT9g(ljCd4(6VFC)gnCstrj(coGZlTPohcYk5LvfQo1TO6oYz4sRvvCoU81uOxx0IIR46s7ulS)nJUy4xEOx3()2x(6nFB0GhU4QUMx(WGV91U3n8MrLj5nUyFXIMGFHBsxKo9BpSKBDxS(lxLCF2G81vmsWUdW8bKT6YMmgUe1oqA)KzomkzgPKd95IumEgtc)IrevyR88mVyALAheWBgRApjKT9T2lcWsXUNLHPplWKCCTmLUaB7g3MFplj)6W7zn535So6f8JOs)wvyvegivf8fHLeIEVneIvIKHBTdB4IP)cY1kyDjrz2osU3FmDMxGB5U)sZsL35yjZIIzlJ(q8QIRjc)4hs3PS)Ldp)7NF95JU7IV296ZV)BdB01zMh9j6C4Aan66dvYB8f)WN)5pRVUJ1F3ZnEw1AFSTA9DBJ9JTWrRmM48yALVkWR)jowtv1p1stpZM3r9t6TA)FE5DG2ZhYEEnV7IQv6oyqLAh5ghWipFfzjLvTYnF)8VEv3)bIToh725ubuMouCUkcLh1wXih1jDjCtMQhGdX5f53TdYuLmoLmnl0pJ2S9narzYz50JVA3(Pt5lADYfbNQBMq5txT0tO(g9wi(KvMBdJqbxrRehXSWNlANaNO(7TS2XvvuxGhJR89WxPmH4cZCuUS81wUNBFUnXPGm7UxD7LDRiYrEOk2Fkl4wPtRAVynJhIks4x9WI6vDBkUOUjj(4TI8f)(zg1pwZiVMuTxVg(EynL(MH6LNpFJVoP9TerN075ogh6P8UKH(J1EpVBO8bRM(xQZ6)c",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - Spark Color [P]"] = { --2024 June 29
		Revision = 2,
		ScriptType = "script",
		String = "fx12YTTnq0FhPorSIK6IDMPp0A3Ms3jmAgOM8qCGie5sjmgcKdbKJsFaF7DxErsmUoPkz6uZh8IDbo7zVkUpFjNvuALfAdkgxFE5NkbE8uolwSd4S3uB2L4ZzVvO2JAIWt2TGlzDXbxIW6sQKB2AFbkNL1AYuckLlrINf6oLPfQIkpo7pGp15we1O0cnbQfQYfPW9)Cw2B0M7xOeOM7L7eBaZ9n3ELsSguC2TGjLZ4wECWxGXbhz8YcxYgajQWLOKguOiVLogK27nWlDj)yzTh703JMbFN0m8enN950CAhnJh3ZNtVmFUwj0pCUpNCYNi9FT4arJw7Ssr1dUewQqHm51snv7BCUHm9oPDBRXwUHM)Tkrk5k(VCzmtVF3AOQlSBD97Kz2TDmWsvVlLTNtNtKSNt(DGAmp(YVfsFkN0a2rcp7eHN)zU9gQbQJulXlFgkT2UOUjSJ9SclkBlsFeQmuWh77pg)JZWzpcYge4m)68OL4hZKwjlXNf2mJhpzAO)KX0fqXzZ9dPCnkoE8vxr9nXHbbZ8NqffumCE4ykCJdMopCYvu4ghmpysa(C66bxpjyoXk0F3iOHRryg)SmHl59l(aNn9RgVP4RxTwuTQot5vQ3WztAsGykEjO1ITJwUfm4UKxHJ00y9VQGhbmUXXQB2k0BGJlGQjqAdbS4nZK55qfOTs0N1RcsRzBEvXoAlvb(oA7eg4S8960MPZbgqLt7i0sBuwRa26Tdqzq)4sXAfj2KJRpn0DNlP97O0Or1lGEk3oEdvb2A1ASnV9t9W1d7zYLB8oDJ3Blm2kPEZGoM4TIrBEJUD4h(NybfmE11MxYa7BHklCOgPb3cwHuzQJSpwG2xiQmqTnZGtEC4WVoS1J2d6P9vDAh6s(HNpOoU2XLm85qVzm8jW3Q(lJ)zJW98G7oa)rQ7OpS(JnQUix059a9lUr03OrsTbtGuDmdHdBEGoBn)VbZio7ACMbbfhw8N7F9CFF)qShdh7(pOp75RWeKLI0hg0m05LT2RSQixs5iAWZyf29MJJFRQBph2lpTqEau)PvQ8qSzY)c6vgq29Ve6ps9cVO5T9lEpBrj4PfLVPe2Lw789))YXJPD1wo)Vp",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - Special Ability [P]"] = { --2024 June 30
		Revision = 3,
		ScriptType = "script",
		String = "DJvwZTTnq4)l(j52kwskEi5z6dY211PTrXtPtpMytlirij2sbWssLe1h0V9UlapaLGoCS7l1ozmjXI9c73hwGqRW7dd4PfXCwo84iX73VoLgoYom4TKphoYlm4AA(0WG3WMMrj508nJlwq3mEkjVyZ4jKSnJxqJNVaFznowmiXhjjROGgIzHJmddgrwcVDLygxIZ42Yz8wEuyWVkeEuVWGFIUomavmiKueWUt5m06f0SzKP0hggf9ow(d3LqGV8q8sYCA(dYy4j2QLtOzHb3KrMIFiCsybgk1rLvBBCfpHNv5aI4h)ND4nU2E9m7zA5A77BAB7hoRRBp0fHOzKdkvHMOQuDphpEQCkYu8vliS56sWcPGpZRYVCg1adTEnHMxzOjvSFDATo9)oXaBg7)88Wjje2Fv5HOnDASPBlB6vzZGHzz8pDrLHRE75y1eYeAIQvDBSQtPvZxW)Kq3v29YklgaJSzC5ypRGLZRTQujeiJrqfb)zc)J0YfhgyNuudBgJUrmB(URAPz85z08CXkL3UqlRklnSu)jPligBJAkhCioy9IAvDSWZkh6fbuUe9rFn(O9wo5VfhvSOYjDuDdXi1Ey)wOWViNRv8l1EbQ4J7KsUdfVSLQQywA80MG41J1zW(GMw92p2eh7fboTm3h6etsLWZR5qj6qgOkCGAC6oF(fbyTS2L2nIxSFkxxhxpZ(dCThy1FGNZbOCfo6lLSDy0FUcHQsuRKGLpR89i0cKQuHaaBzRPWZSsBcx633m(DZMLtlkl86IJRIckx2RGnFUs6VC0Xw2f9ZEh1p)dD(PI(ugVzV5xkAweXRv8tNwaKTWb9vXiQvX9FPae3waePzh1WM3Q(uZaQ(I)lfI4T7MARYP1gTLVmPUHdrxcBgVRV9LUt3E1i6J(TGXhoFPIN98Cm9mTg444c)ynaXZUBJNfH8ckjPyrt7yFXq6BfkQvZyyPwqbF6hPz5yXlqlzc)aS9rrOvKknmq4ZbfyygKpnlofMwVY4XX1Y02dfaE02c6geJchhppOycdfNE9898W6j4rBliLbv0Ga9bcnCxv4rtBOYf2QbE0YU)aC7b4rFlhpb6eMx)(OWwwIj23XxW4appWRVVavdg3Z31sGCWVpO3ar58OE98G3eLtJ6zB76Akw2GNnTnbtIwgCR(dWSoiNTVNPh8nB0U2GuMysYUQv2UBghKsNgtsGDdMeNexaT1)H7EmmW9ORky3ppbn)8uUudprKkWiLnpmar8GLayZ90SPXCOKgq(3GmVRyX)9kk2JfkFSSjycscNrLnHfVmLNvqyW3sjzfkK1ZKNLGmNeZWaGa9FXZfNubv9YywC5xGocGKxWSvSPsEMo50KzFJW8fVjQ8bGPBjfEMY(49Kjj4JYscXBNV5h3mw(BLagqFHzjK1bGJ9xxG9n2rrQMNIbpUt9KcQAF9CrCWuMX26VGNkBIEBDtzr6mKCrX4Mes(IAS6L8SikKp6OgJMgMUNFItpA9wt(SZKAW3vB4w7(5ljjjWzUsOnDxa2yT(Su3UXLh1utV2X)dTrYe(uSiTE8Qtv(D1Hq0edOl8zXGtiKa4lyq5IbLrxUMLo1qY98eyr(Yjy92hSFSXa1bRrnh1fb0Ik70zhl)1krDDMlaCA5(EhonPwfzSOjw0zf3dQjO9L6mTA6at6xRmwhnbiSKA3UI3OmPv19M(rlBMr)GRpq8x6BqE9kLtLdScbc9ubrlYwr1RC1dZRaB3peuJo2zB3JdkBlVAA(hOYe1LRVllMNb8FTGnAmF7TapFxRwQ5RPS1crKBz3sTycAlQH2k5hLSfk)c0HUTPd1YZHiYCkY5oLhrX77jJQMCR1ByaS9IhEigCBhFRb(97BBcmU4NETyDRQxasXtOwwlM40XHxCBCeTJoo)Ao5TLyhp9xOZYOkmPL1lno8ZN9ed()VXEEOu4HQ7NrsYXuOsviEw3xRYn1ulqHveZMNRzvsdBVivUF(QY8WUQQUXG9PG6l(sZKhwFJq7B2n3zK(GeREkQVfYCefiV6XCXfIPClxvxWfqRYYJJQQ4wu2goEjyhgDjCX9mccrKR(xCLWJEd2IPkSPPS649KrlUmbkqERG)QZzdV(6Zo2Km(eELtcx0Y7zSDDVJkmPE5XyWXKTG(5IvypWG0F4dhP9BXIvVhF8G8jvexTt(nF9LM4BAw9et6vtqjHVVYwXTaEivOSoSpDSxCxTsAwF0bRoWe33I1LV)(7F3OGhes19A(NyDFFQ(LjGKbP6vU9PtBlH2URwb2zHTESBxn5ORV6NP6bA0yu8qcbxn8N)E8KcwvNwO8zX)nm7x(NxvBzRXwMgdCl)Z56s8NY5voMy7UX8onDj2GY6)MnOwLgj2PxWdNchYMYkobUX74X45Q7CwcDwXzFJ(TUHUAfWpml8vQRfpH9TFxPXg)TqY2088UdWu95NetulxycVOGV8aocUodZ81Zvfx5Hdw0Sz8EYRZ4WuQ3suSmi3tmBfR8RvPEso2sI4EiQMWCW7GpIozgktTIX1DJ7xKbHCc99LkaWXM)3C0LMtA1EcD0vVzSTsp2Lo0TBzhLqN2bPuAKiuitYvs)xVkRek3vXsp9l0LKyg0z19Xy3W4bCTmC1InvBJVIV9nSzCJC0KVDvsrCAsmvEESApPnkeWFMYlGm8Fd",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary["Cast - Shining Green [P]"] = { --2024 June 30
		Revision = 3,
		ScriptType = "script",
		String = "9Mv6YPnYw43f(ZiQjOOvwCvZpWgVLB8snYjzsfhzesTaDJqnxTeBQPgE2VNtRTwGeGdmEycwQxoRFNLUXu28btd6IypAqe84TS3Fy5cI5TDnn(pKL5ZkBA8zl)eyCjtJBTMtmnUJnXQXWuxBtdGVdIjHUw2Khh64Cxq0J37BbJ8O3CRPKOhtj0tt8Tc(HPXisKTPHzS5TkL8uVcpvY5PbqOLrRgBTA8eVPWFdasMY8NNrGVJNrwn22kkE14OyRWyX1LrLxNm6BnH4ZlJQvKXnODMyEos8mPjAbX3F14ayPRgtdZg46rWlUzlXiDjE5kairRg)qO30PivMqFb1uyOzEGE1cMTL462NdsP0AYzR1SZw7aD2672zFHVv0StYzm7Tdur7wYuGn3y9ca0fvYxXv0Nxn2NgaalVOmxHlY1vJxa4oIttOSiWDCJxayLeHyGlcTSr2BEAP1tSFMoYO3OKqgQ91PnbjZNqcRyownUGuG21Ru7K5z3zuFAyUSWITX)xH9Tk7Bn8741iD22EnIOD6wsnNS9ZHYtDGGC2Vj4wVMHB9oq42GAIBnMz9dsbAJ92jh14kzPnXBsI65l5l1dMEhBSqYVLMOlAUfMCicfpUCey(KfOuWwoIxJiXXEbtHNazooK6dpnJdsdmigOXEawvYScmEEmaRgPcppyvwUMyrPkHIrGsujyKjp5IpVWpPq415f9HZx47fN4qocYEjTqHxztHVFvH3L5rlf7vJNt)zPXVEPxtIx8ViK8)sib2lpcIFjTqXxTXQ7QBP8U6bgdkR1uoF5IcngJOGzByED9IS)vh(qJl13mtPdnEZ8KxOl1VRMCFnjLU96P0TRPBhDv0N30mQnot1CSm95qZWo05)MuGYSxlDlOqycKqAc26q1CgmJqnfdvKQL0p75epBdshtHEtGCoypkUy2fm30sAsihJYH7DKLQO5)1QX356czSkGB5fiFjF8FfipxifQH92wkMkA4mI30zXhUkYuHLRPAQvJ1)1JLzMUVwy6qvSXAPWmBejNfrEybXdQWXkeUKFRjih2XcKEZ5O8BTvvr5nNJQV5w1Mt)pOi9)zSYMNAfUr1NbhysFfUK(AzSpjIGmCIvyLC)NMZ8pfbPckePFPe2tO0cXGrU0w9MGKJLYwKjCD3SIeUWtxtYsRk1ttUx3bQ6sQdK0u1yvy046OxA9QnhMkuTR(AeFGpXu7FscJWuCqRDsW)zAy54GmjLMMgSZCyeJ6OrKDO3cyBQzNhb0I(skmvqtRVIwFMEOPRcLrzkJQApfTbiW5wvfnLbQiQ9wTbqDw8GpWUgOPRJsIsUm2boy9mVapSfYldjyV2F7(VBAOVt9gT8pbQ4trP7)PP42fxem10abXaxGZJ8aj02Jcj0HWNRGYh(PLqGw2blXsOwX8f0WyRG4CFU1If(lzItebwIf0vpX1LyJvA8cWAnSspfolXSBciARxpGRhX3bkcH9q5MeyNgUier8DHJgKe4fFTt2dqvO545fib)8bRj(4JPoc2BTx9HvJt)KVarOm4WY7y5pwno1qjI3dZiU5ekiVygSfOTEv6lcqoxVPI5DAv)Sz1)RFYSkRCsAnY8Pw2)ykRTN0lqaLvHA3sMYWw2T51ZpLg6G2vbElMKOKE79C7olxBZTALsHE61kfflLjPSNYAAxOqNkhDBkIbj(mUKgxqdny2WCWqnw01Yaw)I4ZeXbFQvu60zeDUxGvmRz0amg0YH(8Ck(8PjHEiS)sM7jQCxEU8A7tg5xr2FaqozDnvLETzG)aowYV1pb2WRiw(XZesr8Tt3B54q3F5t1iPAqAYp2Akj7kbPQK2jn(3W183Yiqk7FY)tdUI1(qG2))WwhS6k(a8kKnrVA2KAtt0PJxqejetWrDyDrhswJsWRWhtdi1D)EqJW9X2YLh0twwgkiBGNP8yL0AZWHy6IDMKQ2uDT3KM7rIgKFc7iehxZUdXRH7C2szLJNrRth7qcyTy1TIjVeNaUq25EsWMvCXOyRIRbDcbki6u5oRWobkOMp1gdVNagMllnmpKt2I6hNCgJPxJLBl1GV9nU6YND11N)5ZV58BF4I)C4nN)4NUUZq7zEqHZ5KG4od9bCxNl9Pp)9VJkhqHtUKe)f8KQcT)DnjUbVID4oyufC0wtkCByE5)ghtts696Yk5rw9KEVIE3)HZmvVgDcevFQp4zUHb)fAnC0Ow71UgfA98hTwscfAD3Np)p)4WVIYsV9AV3t9WEkeAztqZvRmnfvTSr2lY8zWasEHLAriZRCVviKZbhjsOMesLxMC7DZHR8CicnuHihYXGrC)goZsMKI9Mr9DQEb8CRkk9MSi7oIKH4AEseBxbpwe)Ffkic1RzVRsCz2N8WrHTKiUjxXm6Z1Tnaw9UJkJ2WJux6)9XJTpUKSmbUwoKRd2mYNRPsHMCqiGE4hV)QHicxU(AKv(5uEFraC7AfK7sIpcsIY(kjSI17WEAHPrNdNfO4wIzzCREBD1a05lHSUgvP8cFXGAK6k3W)wwsXTFVL1uCfZVdn3(reU)kLBpG(Oz)bFjRm9LzP0I4f32ny4sw4ucet5oVnldAYAezCen9x94zkMVmGG)aEGH(9HeFQfhMpfKYslx0PNWUDXTRsbaDDiK4vOKr)G5BFDkznqhX7GZqcTQ7x4DzGPDIb2pIY118UHE7hjlqyBLMLRkRvw5JzpM89HjLEjlM))p",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary ["Add - Health Markers [P]"] = { --2024 June 29
		Revision = 3,
		ScriptType = "script",
		String = "nJvBVjooq4)l9tWQchHcTBR0Es7lAVsVTuKc3EFOTPXKmawRXjYXS0UN28B)gBNxiabiS0txtlK4xM5zEEgpXUowodDSdcL0aEeEBF9ZdFjeC631XUpzg4yFNU7yxlh7VsyZXwEVVFS7mI4BGik2LYLbXUYPqS7uGWKtJDhreylyRcygLJd(LG5XUKrbZLyNbrrQhOmQKcQBXgz0X48dbHhWLnDS)t4LuGH(TNxah)KlbXyIh8acG74rpmGrWwEGoJmbIEWm6NyKraZX(tqKNJTJ0PF78y680yAeJW)MYRCinQ63kXRvZDAlTS7ol3DwPU7RGqs9iSy3VGEm29JbSarQJ10U6326ppt)zh1NYeeHuioBzGizEvbFEMPyWxVudf7QBVPcWDYbCBh7BjpRb(AtGWcNsqL5wkh5QMwRIT3R6pNmBEXLLf9jJSkrbF(SraggFwq8un48bfY7wqzteVC1Cds9VKYEEbLv7UXugB)ftdG(moNSuGdwknwjxfVylQOzSffWIOzvXRDbQ(GKQm(XyBPIaKbEFhRzOSAFlRw4po2eFFLXn2YXwtA2svGyh5jOH40ulPWVANu5PrS71jfAUnTi09dE0XU7oXOPa1tzjTo2DmsMDBRoVTtlLBUaDdWaHIABmmqmzkjcB(Cng9W8xsAXVTx7lXjyxlMc8KrnNtXQDlmI3ucFIQQh6a8l9Qs0vOdWrtNfgiKeo(yuiWyOWz1bj05Cpt54AraB8Pgl2Zp5gu0Mb49a)7djJyQBnKO(P6X3e7AUA0GYJW1LQuiFn6fqEVPtV5Ff6JrqclxlZdOHaSS(nQlexDlIRdWHfS3LOG0fP73IFFH1LD6IAdQ9wND8cF6y0czZOPr7mHzDTsXxcBjxBE4xDn1hQvF3d)omZNrEzTXRd8SOpHrBF8c1nOQQx2oW8Q2y33f7(pk5XxqMeWhZOtMkxpAU3S(4rZ4B39NNQMdWNGRpaCnPNGSaxZS(eZB5NBct53LhVz48Jcil7RqY3(jnASUAxFGiUYy3HWZY5cOgNYWG5KaJ(CYEB(RSbPUkEQHSqZO)RsMWM(dZu3es)dqEnOuKA1RVnUDhjDVAmrAs9VcvSKnoaUWSYzFYMkVw2QiKfO3TsYoC1ZwZGBAb09zn(u)qVEF6X1nNUyZYgR0smRaafg)YkRvZDN5DGz99BiB3Qv52CS69l0tZ2KT6fu4FHekYgRGo)GYTt6v4sGkCFbXA1FleE)EML2jdTrdYdKLTsRYgCTIM7DXOYTKFfC)EpYYQSmnyrTkGUKuUfuF1MyExPlb)B1aQIHlVY3GaC7t1oHbJLNS518QQrPDRr2BsYpWNBv)1GntOHKsGQ6rAYiHwEZMYABSuw7bZklve0WWlHGJJz3bBBKffHlu1yvdP1RglxEoH6SIWZ63LuZS19RgqerGULOL3Bzt8mjJPtAw8WX1pkzM6JSSvNPhX)jCZssy1jNSZNw)4KevkXKDqVxfora4Uk2JI3BTeRQt9Ew9nVm8MQJRTCSb1P28lnNQxKQEmxTZL989qv80gh6Pp2lgSqJzNxPiJT2fEkgR)NEE1wM)Fmo)7",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary ["Aura is Shield [P]"] = {
		Revision = 5,
		ScriptType = "script",
		String = "fBvBVPTpq8VoePvuEGwOtQVGw6(VW2)0QzM6lMMjgYLIv9SJsCOJPj)zFNtcqGwgADtB6KcoxU73VZ3tcQhDcLOY0CLSapQPeTA(siVavqJ88CDD9Pewsc(k5wbtd5uIh(f0WvzaLumpNNHUfGEJAJc6f0RVlnYNg1ZpW3FGfteIHL5mtmVWetwWbrIj(t3(zk5uA0zEU96Jw0RM)(uY7GvfzGqCYWVLZewMpJsilupAIZupc5M4zm8XJlGCaXuJGUKjkHA81lWdZktt3OTtzrjtSYexGyirRK7yLwPeAEMdEX6rjPLY520b6wbisFLjUuY1HjnhEto7laEgKlNWMjShRtbvV5ygBIRLtoHllGCTjEUkb5Qky38vZyqMGVIcs7PuIj0e2M6DXm0khaXQVv)BnMHuY50ObbuYaSK03)u3GGZpFaYtWFRRNqnNjQr8wBf7sB96Iwu0nBT6n(024x)wEc0Xz3SK))MIJ3FoA3EIJ9DDU7M7ME7hUz81xnzA4iu93XuuBL))WWO3hgDTtv)QSfqnsoOlZLTbUoYFcFnfK5kPMllz2lZe1dTHSXIcHcNN2xBQQuMupcJHyktuaphlPkSmZRSXdtc9CnXjQNg1nGYq8cLPQk7VA6hXmPLIIU)hOVeNmhX0SlxfktGV2zDQTBLzHJq05opf5Q06ACpywB)RSDxtysvyS23URvEqNROARRxST83DkPs9O1ba2UjbiXUPXeFpOB2(OZ53FVDB2r5ABB7Wz4oy(syZA0J6Zlzu8NENLk9EdRHf2LZYoohnJVVSdmeqBlUDQNTCook72RFi5OwSBZToVeoUpndEJ)Lcny3XM9Kz5a7HNXP2iDGP7T1Ln3Ldwk(D6hQ45fw6F217h)YIpWDWU2)BHMs)Xd",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary ["Cast - Frontal Cone"] = { --2024 June 30
		Revision = 17,
		ScriptType = "script",
		String = "nJvBVPnsq4)l8LZif4872uD5KiVCxtVwcQM2(HM6WI9AWkgVi7L8YD643(nZU2Gn2qBA6j1Gc2E3zNzEM9zNzm(A(t89yR4XS0C42rINN80kQ)iBFV)I(u5SA(EFKKSggx13Bezj137AXeBMctDvalf(oLtZIib0BgggEDA(nJtiWi3eVKmNMFJur3olHKENV3f08aFpFU)i9D20QMn1lTP34mw46aA(MPeWG0OiAaFZuoBZ040W4aWkWtlGVYxrts2m9Hy87fXGqRsiprZYrj3mnkJLcJXIkeNMsx(u)9bK(ZdqjKz0KQaY4qaYClGUe1CDFof8bW1Ykg4QlQ4NEsrqiiEgCNntNKfpFoQLzShXatybI7aZ2PbOmFHGY8qmdJdZmmEHmdRD2e2tEh5rKGwmVhLxemijRwqQeSwYUpoDomEwg7byzXPvCTH4GqaexZohVVd4Q)rgja9d)ZEEUD66LZOzfXeHrLANJrQddGjXlfSwcIdYDi5oc39rgor6LibNNrUNMiOUllaiomS3VG3Vb6sbxtg7bkdnScc1)rbqWesDd4Zzh(mlMpKMt4RZa1mug)LEWSsx8d5ac(equrASuINfhHX2slVkcpbtMLqdpPKlidCbSemuktdmdgFNxf2hDC3AS56Sw3Qe6keD3xiBEqTGL0MNVGKoF3bC5GsRFwHXNjLriHC(V34vPXAM1rq0eul6JCmOckIgIHUeydc8Dn1DoVrPZpI(qREoq0G0SKKcaKx65taL)88EUyffNxq)lyDoNTm(VrNRccaxeKJZcUhs1Jm8rAAQWFaDnmenNu7(EAIdICehE5bzXRGLzil8nY0qZCGjkWitDBxBveQJmnD11WROaMMQoyAj42boUdqYdoQRUjEwyKPLHMTgYUGrTu10XnDuwlvBrme0gmUk6EIf64aZJIzAPzzcwryjJb26W8AOjn1mCHRAwf3JJJg10b0kCVWQ2oO(0CfERMkooOxdDdndyEDei6AdSH5r9AyO5GYQRlVhht3aLXshVIGXWuvdda6wI16AGXfB8EvRbWvDh8EtdH8UOEGOaQtPDnrzmuLJ7GYI2WY2wUo8Eh9bc7J(pevqDiSXavHoSeY4AJYG4v3svSweVMd0e6gXRURUkkZab2TnXym(VoSwCmmUabmyBg23pNKdS7EBMwqq3m9CwkWQ(SKE8fFpRVkZma0XTZiz3gvsYXkJG(DakknliMbP6GCkxWkBxHSlPSibpQH8Ym)KYEzq2DuPBrYOKgTPuu2p)O9cefttGuCEa5XlADAG0Uk50Kiih560y(vHf3aLdwspb1(9tWKOWTYJeIN6U5nBMw8z7DjSa09woCYMPNwrl9Vvw0vKqhpMVoJ226Hf(kOWDHekF(Z7c2JVCYzdNm5Tx6DZyk)mcNNq75XjCmFr(x(s3gAXdsdOOzJUnGUx9Nu(RPyvrLUDBZINZyzHkRtxrcUt5FuHLPz9Rg64vx5vdv46)2YQhd7hPCrqSVaVxd5zG(kBk5fzKhEl2WPshMuMoNGt70uurtckvI49bGgfpV)UwiAr)7QJ12s3R4B3T7an2jQR5ZtOKSHjjJzXP8CLwIa4ekDsOr8ofbC4Y2N7j2gupgNrIQDhfovO7(7n82vvFCb0rCb33AiRSPKUhtdxhfLtLBJiB5tXH8fkDpOJJUxbTERwGCbpP0Q0Xr4XSMU2(LV7ko2wbPLFeSl8Kr5jK20wTAPv8dk09FlovVExq5K4KCbR9bw2DV6c6S1Z)yCE8S4Ky(tkakr98gPgk(a5pSQN)O1ed96fNMtZ4ydxHqQOf06h73QtFpixSJfKtYfRzPbfpDvH6xEq9UFAst12(n0tXQ673vWeu4()bNVxV5BF1MmAeestdOvkgu(Ub77(LGUjc)Usvd7TGfX3NmeQKL(lyBHpglQC9eLd4iaQrHnXNcEt9tbPmEB(Xbz(hWLfNtpxyLYcgPXjyAhsgh5YyMh5i2DBQ1JJyr(NJeioWbQ9ywFBHYkbLMuSdgvkmflfZ5iSwjxtPf0wlF9c2dkDRLTVvu1SOW(MgP)ct)TB8xhhsFrgVLyKWfKTHvqi2o1RxptrSMtkdvNSZX7(nPDmF7BzSvWyGQ68(lhF5WjDQT6dWgQVXwVGZxBFTL6HTJqWeT404XaEgjnpr8iEuqdRK1xxTsdrfL4AP8CLWrlEYHQkVxCOwnJ9)a5h1(5j5E5Qipou(ZfDAnl1S3RJ0(6ZRZTg(Wk4TeO4pd5PTthH9TXzS5z088J0QXwT8BYD9VgF7E8vZf2C)wc6)ocFb81Q3JnQCEcz5kO7s1DSj8)Ya3jB9)2zt7Ipcd29yN4Pj506y53rB6(dhk9DloEubfQF)i5azdKnWTiJHV6YhwfkQocoPA7LxRzcTUIttWzg8hhaEDs))7p",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	--[=[
	PlaterScriptLibrary["@"] = {
		Revision = 1,
		ScriptType = "script",
		String = "",
		Enabled = true,
		OverrideTriggers = "merge",
	}
	--]=]

end

--place a red background texture around the PlateFrame when the unit is casting a spell and has a Buff or Debuff up
--this is useful in cases where the buff the unit has avoid the spell cast to be interrupted
PlaterScriptLibrary ["Aura While Casting [P]"] = {
	Revision = 1,
	ScriptType = "script",
	String = "9wv3UPnmu43LEfrAfiek)uPDbG0uPx0HMzRxGWlUjhiw11gz702Tl8Z(oobiue0bttftIpX2NVZ35VeAiDkLOwz5kPbfTuIvL8mOn4c07cBI)ArjS0u8rYebZcAkje3bp4VwbuIjrZxHQfHAJRExu3wDBhrVR1AX(4m(Vx7(rrE4r0gKRzU47Z4cWfpIzSC5sx8SjZPKRqfJ60QzFkPDjD6sjt5AMKXUCWV1mHNhDOKB4lZe4L1fBZqyKSNGvE65IvlCXi(5soU5lzG0fNXmfRLaAlJJlmmFbEQAwnF5sqhGBktDXglt7buHNePvHkMvGqGUCBkzrUmXhOqfnGyXNkTX401cFrJCaLb5Ztzpi8ILbNINcC36IlhxEjxAaVLsuPiHZanuTR7wa5YT(bA2ROe3y34Dn9BXCSFCeel2RCUeZXucMpc7rj9WPoDXmeEdDTWOpk3BJ61VHNcdzjpUuRYLP12AIG3gaA9Xf33ijujmHlUOCQaCx8N3Xu1NuTXb0M7lSKk7UauF49J(53G0k)nOOUvUdaRhVNsf8O6axpsdO8u4vBUgQj5c01V4HTh)IGZd(RjGDGqmrXLwtTGDZzPhYt)ByTHyZMnwIV3yblbAmin9RstJY3K04jM5rtX9W5ZdorK9fo7YUkPQcLTvzKm1lhPkB)qZ)uA)edf)al7GxhPekDTqml1CZv92NDsc9Oti5CGyX70XDwmy)eqbd22ZUzG9UH))6D3R)QS(P(39yzw)jKALihC0wRZPOaeg4Dq4ecL7LxWhXist)3iTu6F(",
	Enabled = true,
	OverrideTriggers = "merge",
}

PlaterScriptLibrary ["Add - Explode on Die [P]"] = {
	Revision = 1,
	ScriptType = "script",
	String = "vF1wtnUnu4)l7tjDigBcoqY0(axwkB7Sbgmt7dLkSW(KenrroRKmqEX)27rYoXgIZvyFORNLOyD5C5778PtiEK7jbjt1SeHch23(97Nnfi9pMe0Nobib3bpdsfKfEnq56rzHNtLKG)IYtbYtKG)eMrcsvqXYibFlkrG)vOb5aAe8WzXX3iupClNIV5b2e6qq9qUnF8PKeoj4sqfrciAs)JkTFN52)g7sZc7m3O9DlSA(H0zhnjNkgx1MTRjM)QG(ehd5Gr0XqnbBX7)iH6XLM9isW3PVAY(fZFDYlzHkTmrmmlKPYc1JqNrzmQdUwMaZboU(Z9wR3KfE2KPCMongktuohv4Z29wzb7INlsN8eGq(vsAK5fKZn(V)Y()PUVjagqv6QUEw4KKNb18iW7DU)vs4hPGiA2c3)e3QEFL5)4EFN1q0ozfeTt(GeTtQHOfmYKPUdInLvrJhktsfXZT)5LeUQtUVSU6TLgFc0jrMQxt6PVNl(pesPXXg7KFSKaptLsG24(bQijBkUntPd(bUy0hYcBLf(1xNYtIr00KiVKHd(NB)xsasvzZ93dThS6WP2d(WjqmJEOKgZsESdMxooxhkWR7XN213sU8C9pXTT1((D97EQn)5FABVUgRJWY1PPdh2ctAXs64Xa61iOI7dx2GuruoS2qb8bhKfMky6VfxmazftaCmiE(Etjpomp4SFRz2FKfM)0QftOajsOJSX3iqcLZwoINer5MPnALOszw4VvXsoLVVM9Ygy8YsZ7Ga9a2qNs11M26jrLnx8S4C7fa6IfFfJZBOLPvddqexNLB1Q0frO0IIg2WncedZRpRzxZtAoxibel)Bw8qqRA0SU1UPZ35gjBitq5lePSzUAYgVvkBpSWLPsAoLanGRJ3rU7XHSqnATUz5Q2n4US(CLi(A80YD3ZuZ)gaz32nOpJpDeTHBvkexb77bEnlgA8E6yoNSYdw56)2k39QKCX5sc6AK1qnbu6WRtNUTp2TTpkU71()dceRS2EaLRGMRKATjU8MPw9WlgMAhvCh92CMlRseVpU4NwjW2X5k4Dh95rikhvEIBHI5c6uKDjzHuKrHMusx0g1GezrFvcCc79OlFa28RirVznTvMF3wrrlfoVpHE5bw9CMdwTq5Cn5d2cj)d2c92dmTFIvhv(0f)VN5tSZz7hMVK71o)oOVnb7qrv1DBwdS8wY8si9oL83cg(oX0xLssbMCp8Qovcnemog4F5Pf77ln)Ggo)EcEEgSrnEWNHbUiHNiNhdEf4Pft3em9obOIs)wTY7WSiRP05)Ip1psPCUDABxN2PNqfy13lZKtmty7b1(EoOqjFBDPDctlPlpr9pOyJ3pdXgl1BHoZJ5)O9Bbzeiq64VMf67Us6wXDtuZD(244sqtzCL1nEjroU33PtVJkgcxWPtMcXnmaGVfjC8lWJvy7MBtDZo2wI1r)KAnP(EDwZDxRlh7H0kQPIS(27wVSBbkuv0tcBjC446AQn8mGH3CfVFsiYhRV9WFzPqC)n((3n(Md8E4DeZ2XMG2ebAfnGurBW18JG1eY)b",
	Enabled = true,
	OverrideTriggers = "merge",
}

PlaterScriptLibrary ["Add - Important [P]"] = {
	Revision = 4,
	ScriptType = "script",
	String = "vNv3sTTss43fUYU2yhR)LPQCbeozpKToeQsCo7facnsASLkKL8oZOCWCHE23UNr)zB5eWqvz34GzKMwD)190t3FJWxZ)gFVI1I0ICom8k513Szn1)kBFVRiRO(ENNrYFSkWBnjcU6VizLWSZ89(x0nnpRPV3Lrf5W35ckBbi4DNfh)TC(DxNrG7Cx6kYsk)oL0peIA037ckpY3Zx4FLENzTAm73KYwfy3ytVFdvEvGiHwfKVoc(ceSkOGjV8Y4QG086PpbmFvWnS0LlPStQcclEQkGKd3ljvOM(KPB5c2VoxiJesZ67cgBf52o20fZgkI(MICMDM1Sr9FoHKVecc4vRrTuf85IScwdqoVgFrs5ALQwMxfCkkAdcr1wvua)WkRh1ExCvjsAbbUi3IATguFi0kZkX)RJrqio)fthddT5MZNPBoxZW0YFXeld0)bPe1(w(BWRuWS2T2dwcCbUf(6(E)b5j5AUs(08igLWBC58UhpHMUmbs(c3GZLYRc(UkV(psZLjhFHrIqa4h2MYymq0Xl9z47VTybNkEDowE5QqkB3ieQVATb(MZVM8y3bYiUOqC4CHVyBQ7AB74A5mZXwx3SolWqMLy6)fRzo66ggoZ0SC0TN5QMVj)iUqWFRPg9Wh4bZ)1u6uB2a1o)TNemcu)J(KOKr7kGUZT7bdqnhF9VD0lIkTTQljnepP4VLsUdScBqThiqvWUG8yRhnO2qOPpqQw98)G0nxdd7zoM2ZmnCDCm1X0jZU0TELE4pwML9wZT2bqiUn2VQJwJ4NLToH0vjr5u13SjTBQEVsmN)gQCiDqLYrCzUpU0BxeIizTv4MA2xb1t1IU2nn1tCmWRN7HiRxBgNMQERJ2Fjw(LN2CBltxj4xuWOCXsgLM3qprjHLL7SHKWOtcx9bLWSVeAdjHvJeUZDDThsc7AjCSMBpOaonQyM(mT5vbdjJBRzC0SMpKeZBHQP7CNHKqw0rzitDRH8grBJlKOMmKxfCo05dU(YlEL1As5IMekyreO5X7ybE5fFOUrAV7hPSh2ItHfrr03PmoMAaGh(haysCmIbLjbxr2TvGzlE8iw6A4XWLv4xGWs(KtQcUC16cMGKdv(V96799SoStSIgNsUtMRhwKt5pyd5)M7NS1Kvz0L(y2LNy1Lqy3UY70SeJlNTRKZ7wYWY5nRnAY1jndDBzXpuD22ZLfua51nbyb(iOYlFoDvrmDYzpZizyOXUJlz)WAnp6LjzkcnKTO5uSaLawm6IuqCzQ87A9uMJKW7yVlZjq27sUJOecfZ9AI74Tj4tVcYXaA7qjhVfL5rQdimItZw8bLwVmUEaujyffgtZ)(nKWmCOArvE14QVwfO(KcWDuJutbAbNLdzFOMhlXsENOnFuRVtHKQ1x0t(rT2DAcLKjsoNW6HGD0DRwPq0SZe9U9apwvWNAnp8RnVaZRVTNpf23TiD50w(pW0gWpMJ7B8UrtMCycTCKiARKzfqD7EZ)710D7qCC401SIfPakKs8qnwO50vBGTY14(bWIfRcj4wm977mWa(3PEurJDgTNL)h9IIxTpB3Xd5VDg5pX0PMCypCxCDp5trMfJgpC0QElYAwAblvS509Jp4jv9G878LYyJOGlVOlh8b52HXdKkS9r16hA)NuH8ENV56AlpQ)UGbsaAAeEBpaD)beDlZoEF3ENDtdOID5(DW9wVO4pv8xuMG(KepJuHGtVMW4keYhebTSYgp(OnRK0Zb1UC2Jx5sEphu5YzpELxpC0T322U6JQ2vFuf)(OSD1hFc6sD)9hPD(CgLWoll76cOuoF0XJwPcgDcd3hFYhgCRpC3tYOlKtpblYn7ne5HAcJ0DXQLUhRw2PManJtpon97PX0r)8(dtMWkZOaHNfyLaEXkfDi(H6S9qDt2pbfnKSeSA2dcQQmNlqPaf9Fkjzz4d(06mGma04fQKgVblx9U4oVRnrd(PHPdvqAO391blkD8LUhOw5)Jxu)Ga(GlHxqZ3ivIIR4wyeFrGhoxwDz9hGwN1206gKVgsiHdv)r2OXY3QgJoOo99aoUwoaHxGMTMTdWg2WXfPtB8Qzp2Z(Vt5TbhIUfEiQc2)3X26hYk4yQt8csUwqGISJ3AjhpFZ71jd(r7q)PBO(rQPJc6pvx9e94IRsl8IKd9Swbp9ZaNFbTH1qEAg2VnKe94swrzE8jJFRRZ1lAtMC7NUfhOzzAzBkpJDmnSe7281)Kll1YxtZYU8IMEDRkZePtYG0HscE0uE5A0qsLipvT0Nj5rPu8WNHmyycKmqIiXqQpO)sitsEgm1rV)a2repTDZGzsnKx8ysziOFsyHGwclPQdIlNmmJ8mnedfaQsvBAxv9v55ZLcCbf36fJV83uO0n8W1VtgyopuyWxwIZ)TWSuitNi6N0OosVs4ewk9rzG4FNqZwJOgpKVk3b1eVKP(dViORq7Gh7xoBCj)X)MiqVNdXc2gCw8fbiNnPihk0eldvs8lDqBBLzdtZJBI(KhXsnurcHLwYraGV1aPymYsPuu8fWHcL1k1Kj3)P7B3yQ9(TXCRZBLqJEu1MpcFRdB93BQx1ZOT3u(UqlOPvavS9dmAiVz6Uk9L2uCM6Dl7)Fp",
	Enabled = true,
	OverrideTriggers = "merge",
}

PlaterScriptLibrary ["Add - Non Elite Trash [P]"] = {
	Revision = 4,
	ScriptType = "script",
	String = "nB17VTPou0)DALEKceceEs7dRTRVUUnALC17lRZfhWjXketKTj6Xx4V9DTnuYpOrTtBsVIuRXC5Co3Z5IvXE4hXOYnkwjxcltm3)y9gkojaJsiRPy0vlj8f0Mu9DBkiky5vLfLcm6Fjfvu8mm6l0AmQssFPK2c(Cwjh(nxrfZjz0N(yE(9C5tpOlr8eBnzbv(KL(NNvwwGrxtLzNGsfoXVxIETmZpGwRUmTtI7i3q)OGjEUErbXtJJ0im0UJX3egn1BAS30OXUrX(XH45otc1obaKQZoo2gEpDzM9vST5qT34(2lSJY7nVBtAqxRL4225wudENoDbHVQtdAod2l1pkmrzKcAh1xEIXI2c)nM6webjoPxI(y03i)Nj9pYgBvW3y8EpsUR8HKFkgDJGKPPx3nVh1YRwpJkgysOtNWuIQmBlvi1ON45c)a6LKNRjXIjg5PJzKs3nG6eSnWRPZD4pqXGaAsDaBqh5FQGPX)rbrUSj97p8dmAcgX6u7fgKLxyKH4I10Cg5I8QSvphcjzG9BaKxCqOVVX58ID9DNy43loAC8utKhf56gQPpcJUTQAXchWTYfKvROGSH5qOAOS5v8m7K4zsAX8)QjTIZuFoVDb4QRPWAkF7JKzf6L2UZC35n31K2E9Yk2Cnw9fnccJ5SfJo6SKZBsvlP8DWO9QJSr7xFt6hAsT(9O)HQm7Dz9dcwPGPQpBx5oa98d4(iwBr(AkV2uID0DpyvIQD7zkp)42VF1lV5OLusHA5LeXONLKT087fSfmoPWmIzARbQ9VHE0uWz)Y2S51FvBEiorDCoaYslA71(7im7TTxWW1K9hUgCQXXHXLuHQjnRmhCILubDqmXOyyS3dg8HPBVWi3a)OPJHp79g)Nyg2XrqLkyUIVOjLOJ5m7eOuzoBWSL0ME0TG5AIJCMuJOM31K6zuJX3Kcrrnv0)yyvLfzZJZkxpJO65(nmhoNui3v4NmjFJJHNFQS0)3Nj)MJ8M7CCqzLISLfgZYEI3X7Qp8tVR9Spni3wXxiQBs)kCaly8WZmhgQzuSrcCkxXuGhBq4UdVG217)NNl2ozaj7HhmE2qAAuYRDK3R9Ll06U2)Xi8pp",
	Enabled = true,
	OverrideTriggers = "merge",
}

PlaterScriptLibrary ["Add - Tag Number [P]"] = {
	Revision = 2,
	ScriptType = "script",
	String = "TNrBZPTn4FlJ9fZ1yITdqs6107YlxAz3gT3mT7dH4yHTa8HWItsoPz7g)23JK8BagWW62(YQBsLLFErpp6596z7nWZLUqerJ5WsHNRGg8mMXHn86BBb)XXZffgcV6(zcsGzEU2E9pda81fypxEalAbG2zASbGVomCPV5s)bOjl97NmFeMT0)Hp)ONBhp3OyGcJrb4tv0KF6cfnpnAoAcMl38Pi4Vbs21gizFBGDx2X(Sl867ix6CzNok2BFPLZLT9632Z98UDSVqY9Z9C)ysYKjMFfrczOzZWaz6ch8eXsF0s)40tdAe9z8s)5jer0ccMd7egYpjda49XucH(YsFXuCeGadZxGEjEPFuylG1aphNehi1Al9n4yYya3K4irVW0f3ZqZXWAC8ZdqJiYLAnL6TMl)PL(Pp5RIgd0kh3wGA0vYZE3na)nrcdqsEAIlHA6ZoW5TFmkeB0Cp40du31ds915gWIJdRsIkjXTUMXqXtW9xeOPbVKOgd)szB9fyRp8LE3vP(HqdqeqhOLSBqbZMWOjaN9VAN6GckSbQV1flCJ(DSHJdCbzB1CxWElbJyxtiFMcgXCJM7HUkWmAmIke05SOjtfnkBB0AkgretVbXGDBiOlYbXsEuQudujF(feFMXdp0lZXAiOa(umFO2zD4C4ZC1VFIphrimCGaUii4NuuahA)4J7tusvK)dZLVIzW(3sjuMHvlBh7osLrlB7Z7QxaU7Bv1uSY0SwQPtVDksFtC6x6zkFr6fy(rQWDLJQPz2Qg1b3g7WYfP9020EvTBo0PGTd7TmikSYi4XkBNneDPXv2hL24wvtgLtGT16obvjczr0VQYqdRq90Of7uqsHPquY9dQuwY)Q56sZDybkIWvNNxOSzssEpnwlA5mAtjuh7cEG46DwnU(Ecyxo8gyZd6aUsT8h)52GkgejaSFdjZ(aqAvnyVaFFq0CnmowvX7IJ5UdYUE00vVovj16PJGczXaNwJZLzQem(cseKZ0OHPuzROsfKPm(cQo5Pr6MsnD3kWzZDuj(sXARj5k8hdMIdMPXsmncu5YFKj3Xq(6xuQw6yDg9Ttgfp)aeAduZGfP)736f1Epr15IUeNEZwURpi6VM52wXD1eZ79MynZJr94xdHYrHV(P4btX)CexO44yeHJpg6oMcboOkAyd2h)yLIuiD)6cTjZMy)a9XhSFeyWvPgT19Yl7zBISGLuJRODQUpY7cLOgtfvE2okJZmDvvQ)3O0EGrLu7DsUh(HAIvTSUXocfR5uMOQlZtkcZziK2lcNMYsXHScqCpH9doWz9DYTvRaEwRWnqbcLdB0GqPlAaAxCakbmRlfuHLehhfdDXGrbtHpOcjlJ0aPyu9TKsKqOaNFOoSwz)NxTBpOWOVbILIuQ8wa9K9ySafbHU1Lw1ccDa5oDNsFjwTdKaT5UDss9EZZoRUqlysRIpCeMJMMtWcLvNMdA)SADyuaUADdBu5)rhvrwmt43Hilff6OqwNAScNhf)E8qOxU4NrBzKQ9hyQEXclPFVkNBhC0VYck0(E)m7CJYT0MXQtsv6npGORq0Rz)7ggDfW3sFQvxm1wva7r4ltJBbbwGLvcefc(n87PSJIMBPOPuJEKSj401Vx6bS6wVd26I9AlSRPiiJ(y0SM4Q7P4qWiRhG9GZEdYiDSs75x6Nv0W2WHdqmq)dbZvmD4qOVTFfffMVT8q)eKfOvRm12rCmQqnu08CXH7qvlAAySnBJJ3c)7L1zrjkhZ4Rw7smFUiRLQOy)J3aP6zhLt5wko9PNXmc613Q1ozxFXrez)Nu9hLnfP3PtZ6ywM33)FlE1Tw8Qud67KBQMJfmW4Vcg24da8si6tzZrKgAUFOzOoMGn6YT34IQ(oDz5yxDQk1WtldX1NKXwD0wFgcMMknlCWnTmDSUOJPTPTTvBht7oN5aVkNM(9xC3no3OkdLHI01xgMmF(RPfYav4jdijPMEW3QrBqJrQD9VL9kxa30QplhgoGndfqNtdahrcjro5E9xLZhhmDOZMMms2upCtgG4cPOzAQMzouIBKirA3i7yEengZ1ZcrppKl96B312Z9c5)29YZAB1UTCi8N9)J)ExJ)oFIsPtvY57N6Y0mkMJzqK2aAiw6GxE(2Roml7)ByRL8)ZgHN3F9d",
	Enabled = false,
	OverrideTriggers = "merge",
}

PlaterScriptLibrary ["Add - Warning [P]"] = {
	Revision = 5,
	ScriptType = "script",
	String = "TA1wVTTnu4)l9L5am7OR2YbOpSKSS6va3aWGThAkRyKOSicnPajD88l63(oKsYYUYjlPl3SOep8C(((oxKX(47WizLHjfAy5s393TRIIxgHrljRPy0vLeXkADQ9UkoXalVsYLkm6Vi8nu8Ly0NP7WOnA6EtAnyrMuaFkmuvbjJE)VLN)fH((BTMOUNTMSIQVVj8F)bPKJrxt1zVqin4Lb9q0VnYLuc3uEjrDeUC0X(xa(MzZ9dc8M55nn0dwKGlghhHxgIVjjyACuOxuc8zu40UDISN00jbdP(BHzznhPHANIsH9uAAxiVKtepwNIQaV3XOLETeUXXXVrb26XoyydB0rj7UC4nCIU8GCBdCCp9GeYpFUDGNaKe3JKzTiruLnmB6(a5NmpzEOnVIKC2t0Cf5HUkd3(Z98tMnC)W29NpFEqWWTJ6oECyqs8W9J72hkwoX57lwQYwCDDQr(tvSWzAtNuTOaCtjuPaIrDktl(ftDQuyFitxNAn9xRtHCwRz50cYgoyJRIRovtH1mr7UFY1LuNc9j91EqSmYSNOkneCGEEWpaXi55wi3GqGYwXdzSjiKotXQGJzvt4cymqN60X1P)nrjyIv1PF92VHrq1jRJXN78N(CxcxD(AAoJCo9FY4K1ehRNcfGrdtFDz6W9jTO96peBOw5tB2SA1yOebYcp(ifW80(XhoA3QfsqlRtbCaoaCsXgrMnY1PJ0uEHvgfmZI82f3OGujSMkE6oYdC7YgE7U7S6)06m7V7nEIuGkLBbT4o5NzCEBz(h)VnXIUgHEYvkkCT95J6p4(bCao8Meedx8H))W2sMH(HdGt)kwHLA9yEcudwWwnPRd)mN8io4OVkgDbG0DJoiIur(Bm8h)sINfhCzgH7k9xKJmkxH1hTTvA3nJ6snt(URH7SHEyVfhhrNBAf8)GACp7YD3QysfZSB0HP)tqGU5sF9aG9TtB6XVw6eaSfextf7CM0u3EecmQn0FuTBK8b)ANCDCH9jRyhpMj0uLBkro0Fusv0dZG79o0Zb9JtH2We71zErbZG3vcHj89R)PF1RqmkiC9RV57cyYw1OZEgU5h8(rIxTKoECZWnyuTIavjm7yD74F3wUHD2b2fqxcmsDBjLxz3Xn7Ro93FqkGrMBbTIK94A73HWEm34qqCGHPuDZGUTsyqTV)7hd))3o3MEruZXhy0PWXKF0PVqdG9fcnFzn8)(d",
	Enabled = true,
	OverrideTriggers = "merge",
}

PlaterScriptLibrary ["Cast - Effect After Cast [P]"] = {
	Revision = 2,
	ScriptType = "script",
	String = "fF1EVTTnq8plZ)LdMTGLFKuxGoaNSUvvm4uafS)jj0IwIYIlYKcKuTnRO6Z(oskl5hYpYJ1gcfZx397(D6UJuix0niFEMIYzsORc5R4HFMiKWeOPU9G)6J8XrrWq)pLIvebY3fnfMu9ygb5ldf0mqSbG0tHfCh72)nd1kc2YvyPQiOBrW7JJjHq3jXGckcSZF7NUh5pcezWW(9hJ8hAnGlq(FipFXIU)nonsGF4bca95iFFfwasr(QsGlccnQyowilcI5GojgiGrylgQeYQDrHzbcqCkc8jQ8SYfjLgfNveCn88bAemRLqoalhI8JZzHAFtrqBjjnUtrqoJQ8Ik78hc8sc0NW(8n45P6UwXnJoR4Jfb2w3UuMKOn)qUgKeIGuVAXhjSiyi0ayhH8l8k8wh6n1PNUThnAwZ(RvNEi)XOPdaN6Bap95x4278ZVOhGH7Gxp6rJbnSAxoZ8ZiPPE)ErW7ExrGnG4mJpNTgNlB2ykh49YKuLoU4sSODf4oML32oCc5Sy6IAbG1g6Crp4N)KOUHUK0(So1iVdM7oZvZ0sjCmXNTbDncKFL3PDtQ4)jAmYzWjtd4f8ZKCfb)Afu)my5WNalpgBgTfjQJCDcTa2)T6mB9sn7X2CwBAZ6zMqUs)xVCLM61TRKOwRKfuwtNxR9BRBy7XHc5zfbFBxErHnEduUmhQmO3sRwD27Mc5CrKvr9CCbJVNZyZ)l7)99i6K0SeSro39SdF6)AH3DyNtjAvbwS1CVKZx(lnzZ6TuP2XNSwx5hU9wpge7eJdj3njk6AM8oBG9D0L4fe5DG7F2CC4dle8Cw0933acH8uU1X3sstHdmBDsMbvEvcMXiPu2cJ0X4ujPj9JzgJuKNPo4g3DMecDrIvO(niWxOrQeZQLzZrZDYe8ykezLPNzMn(YHWilFKLf6KqWPQKzuwiF5CS6w37pj7qQpfykKvmHfMu6S(M0Cgl0Baex9vtpD(7JMED73uyMsNU3OogDuD89dL1vNrxLA5NW)YAL2a27XI5BLIxL3hMlv8L6YrvdmxsPHAmqgoO6nUvIojF3ae9jPLW6yyUx0Ep7CvlLhItnk865)J5kn1VDHASxYLstnZDv8EvPXoQu4rTGgnFbzjMYGi9tw8TiK2m)lsSLpvgJ16nhHvpN0E5WURDOYPdNXQRb73kcE5uyvtax4u8eKBZJFEjB647OmrVQI7kwZG48xd9Vr0GPCGha5ZnAywh7Z2hRbVWTx4eqPj0ozCkDhBR)1hF83mqv6xmITA9dle4PCJoR12zNuXnl(bFpLyNmZo1bxylohS6tJK7WU2NfrQlGBT6nQpUjTAMbNSFxZO9)s5aZyCfvFEy5Ni6(Z5lt7P)cFfc9Fd",
	Enabled = false,
}

PlaterScriptLibrary ["Cast - Shield Interrupt"] = {
	Revision = 2,
	ScriptType = "script",
	String = "LF12UTnpm43LCLZWYb30M1vGnGSmSTmG2vmLUErB1SsmtSqvSmKv6HB8Z(OKTJDsD(T7)6Uyy1OjYuKFK6tKukux6ukrgP5YWyCOMs0Y53bQyua9m3(4FhqjmFF8vY5cMguuIl9muO(XiGsINR4rOzdqRpdNyWBgm84JnaHQmMfRt86K4rc4GWpXBsicGADek9QZVHsoIs4grlyZHEwVe3lY6LE8vSLqCV5ie)CgtzHHnlwQMrjhMgQVHs(Y61lx25hmHVID7TagKdPKldGWepDaK4zmhqJdyXO5jEXzbcle)qgkEmX7(cTZNLJkRGvY7a)s4y(e1Cg(kpFDa(iDCiLSyD4CdjM45edIfVoXBDixpXpBWNuSvaogcVBkBMWmmL4SV1o5RjEPp8ficHs0xxGM9zqpvQzIr21DCBBWewOD(Jc0RvLKd4QRqPnJeY5mbYfatOd(GHtFxPWRBH8kSDZKDt3eWrNqcK370E)6qIyQBFIw1GjUKHhWLd4C1vtYZnU(7mUVnkVonvQZN4cXn30yyhlaMAKqCUe36IXWPPbJ1aNwAzKawOB96skIJllVV5)2nfWzsTwUQsm3EQDHTwhmsefWCCBQjDpL9aw)SgSzdvK15KMjJuMeZy6xdy8WcWqDtZeXhSm5OTltQm)VthEymOm1AsFW4dfuEHucV3A6p5sjhJFpC4BhCWrh6IV6o4LRA8V06YVW9HMKINwFMPD1KS7bVCSzD7TVe0rX(ufeZE3NQqxRtlKBD93WdgfShpzScWJOYBtfYfMQwz6KTA3i4)n6Zv)gFD5B7NKSzenMMSA)NKOYoaPAQYC5cE4su7RVysNI36yTQrC2g8)GaPQtXSsNwJ(4hBEOvdHVPqkRyY9F(wt)UxzilEwv(mR)Zd121Y5Rvkiu))7eVDi9TX692ZP3dDNh37C84UQTxdJa1C0vw722T9kXgpJopJLsLVJ5YfzqNDvd3M3)6sUVoWztK9QskEYNZNUD7MSk3BHz2TLQ8Es5cRlcS)0b3H7EpQNemGigEw9zFMlNg2D20wO70afElqbCrKp2b9jPlB3zP8d2LPV5hIPP0Fn",
	Enabled = true,
	OverrideTriggers = "merge",
}

PlaterScriptLibrary ["Cast - Stop Casting"] = {
	Revision = 4,
	ScriptType = "script",
	String = "nR1EVjooq8VlC)ty3cnjq4rL2vILEDFCTasHBVvQTzXLyGOleJCcBVENo(SFJDEqE4qCU2kTlQQHypZ8Bg)BSNXDT0SMBzs2f4q88HhNW)(8N2HTMOBzEd6VGFRAzEj2FPL5em2(Wc0HfNtXUeKnmbhpRjgWiOTylZrBj79coSGS6Wct86TyVaFlZVIC3JdvZvu0sMPSEWY8ZlHFB(zVamDfAj(Ur22t98VBMlcEZDoBrRX(3fISV7TF7dyQL5VHFYY0psZHwZkGH0eqRfJfZDi6FEyXyIlHgJbU)D1GEAd6z0PRAxJo962FG1QwgDykbgCshy8HQA6D01v72BGHUwVOX7YgpigdmThP764ildfjmCYGEhbq)JUKhfI8(97yymSBpJUQ91613ib5Wi9vhQ1xvTR6qv9EdzJ0LPDMpLb5RbL)caCqDbKL)at9zlNt0uH)begKTntNHQWYuJZIcyUNP)sQZoqSoHoZKo9zWLh37mqZaIZC4oe8UOO9WH917XSeOJXiFGy1c4vbKDqWb(QJ36dlUD29wMgL7fBX2oO78bH(EVUwMDbJdkSpeZX0LoeGh2ZY8l7zk3NR5LHAgWom9v79481dlu8XURo7WI9EobF2o6bGoVfdpJ9(XC0dUShd9s(3AE4lhwe(XLSe5gQ7pGOhw8UuY3o(TjZowDXJ8ho2bB4cf9Il(ioG)sLu2iAS2CI)fM4GVIPb4)IVwRCjoa546Zn4Jey8ziQpMpMVskm3gOeRCw3(i)UzktuWHa9hSNIndO4GLByBoKXZwHDh5b8iwiSDH5MOS8JCH5gYJPDTIt455Dj5anRWiJcCr(kn(2miWY8KwtPiV145uWCnoLSJDXGeUUZioWovv5l8zP0G6SEtqJZYTucFVXsmJEZgsL9tfQ7tyMIusrwIEtvU7hCXE23qSXkngD5LGdUOIWJ7Unif12gvO3lPOhVg9eMQ0GaBz4IEI5k9fYSwrG8dhorslB(uc3mZ()mzSjP0Kqg6PiMZdNI)To3xunrYNNXXGwYpnpPyWwMi4zy3iBLa6ESGzxk6JwcNrOH7cjClGZRogjHftHytN)gRK10V14SmMwaHsKRlCDVxZ6GNYZKI)4avBOWymVtc6cWPd2G9eGGIWVK0swczY7YNpMShURpUogXfVkVnIFLItlTMVj76b8ADrw1ZUMR1rPWNyD8toW(b1zjRTpWD5kFk1gw7pr(XXPEjldbCSC7Mu68nzpCfLSfeq)0jH5eAojm7vo7mfwPD8uQEbV0Cy7ipBUZ2WTHkCAfKp9b8F7GPHCbGkFUemzgo4UUABvn(VeLyLdeCaGEWxjnQAjw0wTejmmx2q24h2VUoKceJOjhPizQPifQgYiaJqujJ(40NtIpbRBZA7l61Wz0Z4nXXZMSajlEkHWMbikCucSfAkXLqUurK2gsjrsqPz6ksTfDw9Xduz1ohvt(3ku(MGkBhVNsbQ88uNoRjyAtGXNbfQJdpNNnlvv2tYKGicaSQ45h4N74ji4YsfZxwcF6jfuxR5hVTzyOl3hO7cJSDxiSTHwTC88HQoGJfGIYoSydMM(qLJ62YCi0gUk0kZaOVPE91n06QnamHwNxUMy(PVgT8NuvcR91T3LiqiBUsHtxRKQMQskvzOQPMFNsMFH81cKwGjP)AWKQxJXVwvfNvVH12MxTXv8E69btZAobH6Wcwg0)8VIugVCwpsG0KXslPvwYCApDmfdDQeLUP454YQenffk8ngvNLjYnsZ8La1PNEAq2Mp80qqjjI73uwlLQO8JTDxGuktV5vBNyuF7TLD)v3K((RU)(APDEFCA9yf72tEbLCx0kPPXBzxx6zSC8v8mPiLwxwUZJ0vfFCZjo2PE0FHDWkNxXoaJzWeJxYNVu)rskLdm6hPK97sBO0VLfTsAVM7Wj4KpdLMvg7qzeOedvQsYkDyrNx54HCdR8m8wsQT)xuRxti7aoTsJjtN8RnA(mcQLLSoE6n3mDYDjxqOWmuX6AmHqTzDVoCOAyxCQA5EORMXq50xHBU7zWF49(g2Oy2iAoUIsdZXJU(KX1cTtphrxJduIE)ZcM8owKcMJUE2Ngjdmp2y4lmm1FfWPUuanZU3LSv(jR8tMpq1HA)0uDyq6ZpQ6mMYoylPd0VZoxmPf03lU30spIlcsEPBJnUj2A2cBvxkH)TL0C99fRVxwjpUx(fZy38GuxsI4M3Fxzd82CHNtOqbxAqPJ92mxOq5OTvRDuwTEIa3zLQFPcezjsfapG(FjOQAKQmOoCG47E(0g)9Vm2E4W)FB4eNwqOBrUqrQ2cPjzt9opmT51Pl(iLTJv2Vu3rBbOhx(p7W7Cxh9j(l(DIB9pclVPK)CW5B1i31gSHsccCX)(oB4iMW7TLV3oStTA4)BaS(Vd",
	Enabled = true,
	OverrideTriggers = "merge",
}

--scripts
	PlaterScriptLibrary ["Auto Set Skull"] = {
		Revision = 11,
		ScriptType = "script",
		String = "ntvxVPnpu4)oTsducnK1EzvNwfmT0xnZwVb5gtYjqegBMTt76Ui)2Fphhcj0o1w2fvtwc8hNZ5558rE4H8zCMERRuRS42e)5zpUf4jJ5SeXgGZUX)CDAiN9dHScV5YkNUo1cU6urDQruMxN6eML0fS1vszDk5GBfuNwPkDd5SVap2cegNjzAf(RYbMcrgm)Y88Bu25)NuG3mVCJyjyN3y9DsXcqYzFcSzCg3Xtg1XX4NYXrTCmj4amhDCyUqkuR7J5zDygThtL8X60se1R0BwiCTqVOfz89jQ23ok4169zmJkQ(k5gHznvy9Ow0R8IhTnejZd2qKXiIoD29GXIbKNCrqqawde55elAaLZcPeJ5O0IzZmLBrVOmf)BuBxMTVPYzJ7Na3QnY8nITZVwQFWBWDXrxBOmpQzuIfgF24rbuhJ2ghEUhVW4OXbXeiFebbKGrl1MbZ0MLRew864dMWSnduu275mw)lQuzn97tSGS4dnLHj5728zd2FW9G6(zIfsABt25pDA9060M1GbLklyCuHlhlMRad09AR7dVAfKT(R(Q)jphimEGkhD7fxiXhFiX)lyupK4SlWXFSAI10W4GO4lIJIOs(zVxLNdit4O3py7SlJAm1PfAtZ8HT7XoYCmnY9GSBrFMDIsJu5AW9nuNBMxLBIkh(1UiC6P(Vevp35dcsVuDiQeuuUCyF9HxnipNrFhH)YIcatt1YMO8MP0txgWvzEd2tD8xlytFjNNE8UX6x57ABN)hAxpNEtpa89dSdg0inHdr(Xh7dAm9tT)SsKpqcICWSZiu0YB0V1sCgPc1zvqMrVrOYqBOxMrYWj0LUYS60BfRHgFjvoVfOTLKswMyRtqY0d89hsdg1ZXg6w622VKc)hwFdPxaPS748))",
		Enabled = false,
	}--

	PlaterScriptLibrary ["Aura - Buff Alert"] = {
		Revision = 15,
		ScriptType = "script",
		String = "vB1YUTToq0)LSkg4kd9(XfOlCItAtlGBbOr3uxgslrzlufsdj5K6n8BVdPKSKsKrGrtw0OaBsoKZzMZz4iJTWlXiXUQmbVegUqpF5HDm8cFm6lSdTwTWOVtZ3dRBIrlOpWWORYP8FjjOD0yy2DXco8jVIvKclSAwsYx5LR(wofwzv2d0nSYv1(6(1QtIrZzLXyeUcVWUdwVbWA3cl6gLNLKQTmjPChlpxs4qyijIIMfUBomjTzlxTpfgMXBMcrJKSSiBZgLtwl(TKq5WsBZQKKlaRxmTnT(QgyjX(8YPC6AwE)CY5uuPZ7kv62bRBdSBYfpDdNUoNL0c96wK)iytsoA9SGwigKWEDiB1d5Rf5IIwC1Ly3gyh47A6Az6eAhffeItn8Cvvb366zBz7BgAA7eefezdw8nvCjWvq(ahUAyK349ZjUJRpsxG7pqPgtr60RH64FLsf8sLkruv(mL6Q2iAoy7nsPchOu9D)lfl1)GW4bIrOVNRPJPBKLzuJKnuyoMdVbQc4Ukr8JSIsWk4Ft4p4kjnjr5ZAxGr64dvPsfuzCr2o4yonbUtuOLNoUGZnBFbvsmABmmlNva38)rTF(jg59QXzgKm3tb3GrQ7yGBdasKveNjegOd5ps50smcQG0nB0TDwRbRUp1XErv9AdbDDSaXpDppUURZLLS80)ts2ZZQUlPzWTfGhGXm(JlvYpmSoz1ZMi)SK08CCuwQYxDBAke9PzBM2RxWeD8W7D6MNwyMQcFLgQUQ9)OTINUShwmO)5zaCVs7xhyyZZ4aVxZjFqsQLIPWxhM3ZwlB5pKr6JPUuSzlot6hPplbQN28aYI3qzzu(2WiJxQRKIfjG0ULvWg1Nyue0CXbkedHAtF)ih7alxq5TC(3q9)uwc7Dw9B0y4A)UX04rloE9islcapB)EWZggXfmiQHoNq3Ln63irle75Tnaunn6hIJqT667tyr9BBAOLR1a1zQnfoHkRl7N8sAW6SPHjJZQNMPnRFBa(pd",
		Enabled = true,
		OverrideTriggers = "merge",
	}--



	PlaterScriptLibrary ["Fixate by Unit Buff [P]"] = {
		Revision = 2,
		ScriptType = "script",
		String = "ftvxVPnmu0FlJNaPckjajPpY6uLsNuAvD3EzmJnj3awk1gz70n2d(3(UogrdQQpSPjnSK)G79EohF4IPX0NOe1bRqjn42Y(ZpD8a43s(mCKsK8NHdTClCJQvPPKVYB7GqULr0Ye6TlJIxMLnplkjDruuEcTz6Y50Y5(i5PlIZxGrYYsst9rYOLl8fBPKse6WCpbo2jkkQusCwAbDdVcwVQU(EPz9d(K0RfpZ3bM1bvVPkuYNatfLCZEUChIJDpobs45JoM8v47ZfJQ8zimN)IFShKowJ4NCRqUZXoQ6(aQpuHwv1lG2GeHsoc)Kqj86AV8cQHsI7TkR3ZiMkT4aw2C0FWfm5B9GIuVfvYxKcRJ9XUMgh7Bp8Dkz5WlzXn3xswVAROvypUjux9gIfx28iutjlcGMHxwHLxR0tx9lnV1RLukzvlOr05BvD(fhRRNTMaooMsEYwqV4iOdkQZ0FFXS32RQZjDY78ymdVIlOKMozL3WDSXgOT5QqWI6tBUvJ28v(cF5j(2w)2Gz0FAI7ohlmMovin9sTsvJmTh0WRrD3bYA8ioqAr)Xv4kgs9Lyw4hVdI9XcRbmlOKRXUY5uso(twAAEEE6YORrEM)wE(RUI)PYjo5)JVg)VJwb21m23yxy8ZJdO4yZM5yJSC9oWoclEuORB0Kj9nyYbk70i83PzeWwEXdoJhkNbAyg(grJy3SlFEAGYGwd8U08i0ObZ(3JQHW49TZM3BhODgfEoJ(7p",
		Enabled = true,
		OverrideTriggers = "merge",
	}--

	PlaterScriptLibrary ["Aura - Debuff Alert"] = {
		Revision = 12,
		ScriptType = "script",
		String = "1AvBVPnmq4)l9tfPbkV)YK2hOL2n2KOtYO9LXCTjXHgTuBuEPD8f)BFNDsAswbHqdiiHJpF3ZDpp(ob2eVeJOXXcog99mAjlhJkfrVWYlsH9wyAaFSWityjyz3wggveLNUTeJeBlHZuaryHomlvwx4HrFJTR1k40pOzvW(gy0c6ZG73Kr5)wsqBPrWBZJuqpNdiNaBSAAC8d8Iv15YQ0NPByfRQJ1JRvEIrZyfryeUeVWQdw3bWA1cl6ovKLKYNyssXwwwMKWH0qse5nBmFg8ssZrUPkbwMYBEfYgjzzE6MnQGSw8hjHYHTEkTusUcSE1K2Y6bnWsI1Pvtz01SS(1K9HOs7lkv60bRtdSBYeVEhNUoJf3c96wK)mytsEZ6jbTqmOGD7q2ShY3kYe5T4QVIDVVLVNJHJPHDGvyOFaozSRJ6wW9oUwMwEgbgw2(H(HwGfpdfxcCfupGZLdZ8MOFk5DuTlDjU3aLAFksNEnuh)Vuk)3RuXIYI)rPUPnJMb2otkvWaLQF4FVyP(ccJligbEUog2goHMgHns2qH5TA4mOkq4GoWPv5ujzSKmJTw3rpnJLdTS)Sog)cJCpkaPqw8ifcegPAoGa7dvplpkvigJ2L9cLtlWiq61tj0ZlIBGREeZBJrk7nbbgyeceGxagfa1VNxOTLVPdiL21OycltQ4r1JtUUGLL8bjPINwopUzX95q8H1m(llv6kSSEOS(TrYVkj1pPjQi0zAcutjPBM0R1EKoh5D(0(0g8jQssjjQoNpIEs8619qGbJd7C9Oa37M6Xbgo8uoOg1mXNKKAbAc8ZUz9S1YrEd5H(yQVz1Ce7r9ZuDbuxfWdq)2Np6)skeFjnMDHfIg6g(dbB3hDVxD64z0q226sW2JhhLZGChMmbJb2ON4tZfv82(uvVD)eDpeS(c3bSO(VdnKZTAG6m1wchqR13dhDiYW8KjJdgkJ6zR4)(",
		Enabled = true,
		OverrideTriggers = "merge",
	}--

	PlaterScriptLibrary ["Aura - Blink Time Left"] = {
		Revision = 13,
		ScriptType = "script",
		String = "fNvBtTnss4)l8fSRY2RK8RKCzRcyxsyVe2uRCD3hcrizPXgvrEghj5qGRo9B)6EMrVps2gm3wa2inT6UF6PFDKLU1Clt2MyFgnc(3B4xp)XneRBMyzEJZAIL5fbo0VLyBUXXfU6F5eSfwvZY8FsEm9z1HlV2LrHpPXKWLaL3EUN3FsJU9ZboWDU1FTZks0TcYVBbYslZFJe5AzAfBDJrUChNk3)KtBIT(0uPA(7i3tSJVNKyhTHeeKytbAtSzHYBC9VLy7tLKaQqI98q)vRWNAb7Nj2ou4w37hNyFcS6jdkdJPhgmcCwqckcJHLmFvmq5wov21xK5BuUChLZEFK9)o1zraXlv8xivRf4QzRDqcNXYWCebmKXSe7tx6eerovCHNFeYxWIJcb1VXk0V3hWEOr1BfS4RT2HYic1Ujk0UlV3HUcicVIlOe7lzbSWQkQlNoKQnivsAE5ACC42ufMqf6lnvij2UOyGV4chHW0Ciyyz(jNFcFRLYvmEiIaQKxupicy5sIBCKmezHWlHWVjehrdaq9jFkMkqGWy)1KaYY45mUhvMF8qlZRcDCrmGwJdbY0TRxqctn1ZLcqG2ls9zMvhsdtreQtcYDzR3eqqBItgycySnsqOnyCrhEZnKCFneHhheid1eChu9ZQR66PQ(AhiluCOdnAJtiH6(yH8vouqkIKEigsS7Opqdwh2SwUft2X2489TKUzGtVi4a5CEWM7DYZ0myYrgHFcvEHqaycj1YWPEfklfSWlSG)AW)Ci)Zr4NXfbWZi4Xv8ictRmQGTSOVnxr1vOO3KhovxzVAS(4PAtgQRzmvF0OX6wl7pEecGRgn2q3yI2mnJHtpB6zgWkt04GsRcOOVGScLaw9iFFaJxQi1JWzbtEWXTXFt1J0hQiLkgNhkn2nM4hJSd5K8AN(xK8mQq4xv)hrwgzQjYpJ5iB0ZntBnUJCSEQ2pcI7F7es9PRY2IMv0eMy)rUgLr0ZjQUqwbeuJvKW6ydQld9J9DDckwaPoQYP6iaRjkc7LMTMZqD10zJ0hprFQ2iDJPq0og6puza(dcEDKYB9W9eQcppcYqINWpfkY9qkaEIrfr5tvaZu7yl4C8WjZo7SPgAgZG8zAdrCorjoDLm71fOyMRujzHbBMXm3FqcJWn0BottxdCjD88qHlKLLjhmMXi2nJGhEd8uyUh4lWr(8THGbRVSPcOGauSTOZ2xeS5RwMJ3jE8bqFNdWW7eLvmhjedoYWt(RzEK(N)uOtaQDtKLb7LMLrIwHBQCiKQj1hiNxHtPhzX2Ll5jNa9KBPkmgdqQjMCdYWfdUcryFBixOrqMF3y(WqCJbmEdKWYC5wQROTIorKGLGATL6hFTN8FGOM1KEON2pMJ5g7L(48R6M8hj2YFY(VushWngZHO(THK3akLP)tePyEZ7fx2PBjwqaW)h4pGUnUSUPuO977tJiHXia9iOXiK0a)od8ENc8Cgg7Bmz4mWZ(mqmdpEMGYa)80g2Ed4RUPt3DzG(GVhPZlHB85I4zGRrJWDf3dUIrJLvz5GDWLqvrp2d0b8sW9sPDG3IbBczl9bgZ9S5fFVdZHlIB7wE3Y41WtQF)CV4oHKVV1pu0m)VescyoEyfh(q)ep)yEEph6JzU(fyPhRa7ZyUCKaEehA8QttMT9IcJeNy)UsQ(ai4AP)QbfhBUfw9(8XxBItRksslSsDxEQ5PQHrFBl8EUS0SC0UMyBLjaF7USH85GA1cYP4TTI7lYMiOvojX4o5u6WrTYSuIANF73EbTYUGcoQYFfd(sBRQ9nUsDj32wxfc3d)HSEKAMPfiBF8WYBhPDwMsxR8emrCiD3o0ZITN1(wAol3LIwQvO9ExnWpkw0LS8qkJedJ4VIYkvnRQIDnNapZ0J2euQ)Jcrk)5l6gFLtdoaypuWBJejtJ8XJjHFCjRDQvdTgBgwKn1O7)wSWKNQK6ftVVj0)hyxo7irnorlLf3qLtEBr0wmuLj(DzLdVmKaFFn2dxEnRtob(qx(3jmOhZaNhpP7EYESe7Nz8gZ6CQlV98tb(OH)T38OANan79eW4UJmkGOh5qlTiSYNVDn)E2dWtzFGp3a3SmDQYpRaYETGdSXLxioKwpB1b1E7At488ZzRQNs2sFy7cy)vP47LUB0lfokaGAUwJLzRGEIN)Xp)HZt9nvwt9xsSnK(AQRVDS1eJDOjQ1Igcf63x5MtlBx597w27R495J7GT5kdKf3r2IRm(hYElEFd8uanOAhOmpgsilIu9Q7olrLeWzTRlBzx)1OLDzKCAn7YwP7(lYAhFSUlFsBLLeCVN4(nXHyM)Q84V5Ui6Pa)wq4v1fvhlGp8b60yTXVKRdY791Unv3iKabY0DwhltvRDyf8bkIIDctDa5j1k(kvkCy(CIDcIW3xrfOx9aq(1e7NiHSkyUtddPGsw1qhDLYmFl6x5rKnyn4YiN2)rZJi0ilQnXL8nk1iHL3llcRDkJsSqrpd5ZrFDeMMgCMWZGyp56UMnh5yBvSATo0ETy)(8jvpqty5T)9dRTKr65Q61Exf7P6RAo39ghYuXqJzvhoRJQCCdQkMddSKGiYrpc4i45UVNM0)FDgLPIu5QDDe6SrFoqCFks2EdHE7r2)yXRSQIJCzOQyw8JCU30zs3Pv6qocWwM9TRAx(9qtLdK)ARO5IzNns2AO6RZrMEiUAWLqxAAIx2I1)7",
		Enabled = true,
	}--

	PlaterScriptLibrary ["Cast - Small Alert"] = {
		Revision = 12,
		ScriptType = "script",
		String = "fB1xZjksq8Vl5jTQiRacQPQ9b3KZlU3TAQB8UxUCegHrLAhNXIbsIVWN9R7bqLeX)Cz36crCy6MU)19VU7rptVPEe56KiPqblhRFE6M1mVXUEKFJTPuQPh5VO8uy)2EKX0vmpYeTGmFq0OaPaUlsyXZPbShhegorOE8bof25XOv0fm1J5g6PzCQ47EK7yQapIxI3yRD(0PIpTk9jbm0gvMpnZxTIY5Wkby0C3)YsgCpzjlZpGQsavsOXjgVfLwxgk50zm((O0UckFNTla6VGgVanQ1meQcq1mFzCXgJUdEyEHkKCvIkdaarz(tJJwSaTYm5RyKcBTmcIRRaPxz82m0hkO6uhDBxpDB)bPBND(eG)3OVcvDgwLACV8LmFUuSaYkQISYCovTmZFnueWcRJWvqM5BrcaWgqb5WyAa6EVVSlqmCldLH5g8U0yDn0LfqI0vZyXfzln02ANemnUn6m3xNBLCzCjw0nA4)w67267DW7jVbIfV2LGVG8xjpDQF)9k40Mf8c4NezWZSyfI7XMTH)aoGggIok3UEencjjy0qubXrRHxZUa92DD75Khc29DB3PJooS7z6y2vhm2DT7BBH8nOq3ETnXKZyR29mDHT6I62XSpOypublNUG0(GP73RRtBesOgD71bZoM61DWVnbtAzAA1h11wRVtFWGMD0R7BJF7KV2fZVU4ZUDTSWGgcNB11mTGMV8rjd4SyyJ)opO)hpIZjZ0yz3tZOqgcBGaZ2f4CwCqKu2ISH)mvqvEe3cwKvwhN75VqJlRHPBhsSDcqszZppcvg7bWxZOy2G6OdmMhX4HqFaKliZtfb5nSnum(8RZ8tfrjJclwaniRyWAM45P0zCCzodRFQz2xZ8lU2UQuvdDIthAdkhdFF6SBWH0nQ8Mmy21xXlasovH0b9vRwrcLMncKHq0TKfZQXEa77c0lPhYWUqHMthOIHave)pe5qV066JCRFgqQvRIPIHfdF2jIldOqnYTtgpC0V(0WFFa5(NU7p)JbthnzCM)NRyBdyWY8OfgvMJDy)TIksHOFdqoXmOBqx(kyW46e2RjPX4GAzC1r27oMERHIGrrneYKdMvNMBPMARSpoQNiMw68pFCXi0Y7IV5wn(hH9Yaw2sagyBn0D28s87newIEi7wh1WeOp9Nl2qd48hKrIe1(ft5LsNlH8UeVFQkcpnnNwW48fz83pt(y)Q8ssX)9r173POgukWHcAUPSfOXbYkNt2zP8LghmHgEr4zyKicgjh(Jat3hfY(4yIUxowJQkvPdQiTr9O56YS917hMhReuxQmsCeFcoCF0Dn(Bq5RxsVQOc)GJy(KfiPn8XW9KEFsAY)r3BDu3JGRDZZHeorrVgDvyOt1x(20l2xxoyTXjN86)ji0AwN1G01piZDoZXkiLhOXkMwKQwhQf38WNaU7col08NXzH1DWB78FrT3)(d",
		Enabled = true,
		OverrideTriggers = "merge",
	}--

	PlaterScriptLibrary ["Countdown"] = {
		Revision = 12,
		ScriptType = "script",
		String = "TRXAVTTT2Flx)PyCTnSKTJJhwVa5r3QdwthQsX(qsueTeTfVrMYGuoPzDv)235qkjljlhl7KgSvuiSmYJjpV45fpS2g2xABfUiIfYLWWiBROq37PcjaW(cdJUD7AABr88GPw)EajIkSTmSVOhSWhxqTTKUc2cyB907gw8PHl5rEHpaByGT1yoSLPex61h759bU8AnsUE8CYmQ8A30fF7eI4wMlsM(aQUWaiZH97Bo0(ct9qJ(kYcdnoAG9f9vdhCiSGb4Wb97EeYbdTToMgqfHbHI2xgkM5tKa4dTTScNtJDwYzrYyhaASJCb1LrcIDO3t5i0hyr(HlJIDiXoUbuIaarEm2jkewSF4dDIDU0NH7uj2W688KQvlPaV7b7cOwSZeCN4My8PHI5WyFK0skaMmrrbwuhGTbPy6sUlQ)JDoqsdM2sZIJ9sg8lcYCkmMYV)sYKaCOM4QznJpp2r)fe6IIcFH7yGOXoVz1E6Ka8Qma3Eba5SBwT7vJytbojdleuOsM1rlKNcI4jertLuXZHIkqqhp6KLtNEjBoDZBOWg12hDUaK6f4W3rKhVuaA4dYRnQc9Bf)RlRB6lvxsqlM3SICkaBD3TBpJgLCMRzqycWIb0PrFRPDYUjGktQ2EI(8xPrFc0FOQuUst2S2i0d2iALIwIFEbtpb17BhdGhqSZTT0mf6se7SGWeYdumjCQ5fwJZSC2i4(6KOFEtQMQMh9L(sflLQsH3mi7mUkPxYW4UQVk)nrqj3v)Trbp2ZFrwuDqts8eli44XbrjHgs9(lfcllU2gnMAN(lpHHjnqwdLOkwsgX74QzmZFASezv(b7q0IsEwAPCSxjVRvspmASxoARwtDD3kW)5PvUibzGBUVM9jS9PykUChBptEgnQQ3sp)Ldv7ibQ0W)PnP2hJ8k0AfOSAc8hOeGbflbOYC7TBZ4qXdqsf3qpi0IpvKNHpxJB4Z2AeuWupOSIJGAOgAoAWrdm6ncitVxUknEAUz3ST06aZxlMBTYLapxRf0GGSAMkcatDLYzhivWpRP27KhgPQGebL4h6iOrlfW)NZcsSHtiJKPq(P3QWDN8ePeAXvwezsMkzxlfABPMJfkp(m9ym0gg7upBoJ)rcFw6mYNZnlHq6jHc2mgNemwHQeUv9N2TDdNVacdpHfWIESkLx5clvc3xw3M)kDn83O)9cLpQafjwI8gwCKgGz30Pjby7zAy2FyRYXDBy0OvUAKACsy48)tJV2c5EiDjNnhSX8WQ3fcgEi2gk6iGmBjDkjiOcF9QzDJ(FdyDZ6X64fK2t(gUG0ZHVngnQVX68DpKVf05egNXNPGniVKuWOwJKMAX6TU(0a01gKM3bYbuzAiyQFCuiNohU5vDLl42EBtUkXZEIW5eU8bOQcFK9ZDFHKZOEDhmAZsH6NB2k1r3nPsrnCTWnMpdlR99eWv3hbGAtbhVtO7J4DaQNWH3F9zzSzo0OIdT(70HMcjjhAWb1Dm8seGa9r6ubXvzwAX4bSz(rpRdZ2TVY0CWOHhUJhNFAck)wrc2DuuWw)a14WH9oAZsO(Nx)avdxl4re(DynQZN)yTKeJbGHz9cuKkhxsXUeaROrfMSGenddQVhUBRBOQGRLlfIZi(bgnBaSWFuGBIDo7K3JR9S3EYN(1nkTh1DxDdZltLpYm723SV5gfTJmmhnCDjtb(zlyFTQSBTBlZU)oY0QU5a0DkB2A1pKaEd5)W80xs)mKhpjypi)BArUHHcT66lD7GEYD7ms93KXFDdB94Gf(eTr8gwHf7p1K3OFR64DgbCC(CtTQEjzODuTXAQE4QR2uFbz6(cIDdCcX9UzIWLCVBUPck4ID4tZMswW9urJAXgm5P(eoNgK6ubjwL0QWpHRysXYfrp5cxhIpvhHenURydpW8I8ZF9rVjDwicNYGcQu986wTvvhker9rOeRo(uWHY)wghQmBcj6kJBQfFO8yWoPDm31prz9fjZtFi0dSR(SAeMm5r1O2MvzMPIDvjogSvC81kyVSrRk6Fp7KG7szu48KYF1tSIiIOMvf7c7GBo3ADBARWUsP7ZCcE6(VvOzNjX4361YtIDaK)dt()u3OsTs4KqPufECDe)09ondH1UXafy)SKn7BVrq283WMCIYtgZ0jPSL)BEys8usvdbiWOWEWU2CKve7)T6qA)fH0VKBD9pY2Tv40klD4(EAHTKf)VYjPkK9TcQvB6K4jvg)5NVDnxT623wOyJgVAhrjEXw5BiyL9(Ovk32AnxLIHY0nHOKNtRk7g4lzxV2lbzv4ynxxi(vrXQAjO269QpUwdYz0iclqQy0hcf39txkGuoaRJMhv0F4oi88jBw15yWT4pWe3qGkmSLXHnRSDEgFV)IE)7lj3RtN7l3X(4)QQw2N4xG9o8f91jEHAs9ofvu3K(Z3bNwiIZ3bVo8pEF3F8(UFp8(UPVnbMootKklLTZPeFXkHDBH)0rjRi9SQmuRvm8pNJ9FvIzw81RZr7V1fyQQwZ5hp89pE47xYh(EdVjDx8FaEr22)9",
		Enabled = true,
		OverrideTriggers = true,
	}

	PlaterScriptLibrary ["Fixate On You"] = {
		Revision = 12,
		ScriptType = "script",
		String = "LI16UTTnu43f)NAheBehNlozO)OTbPZgTEfvoByiiAIsIwIi0KcKuX1zy6zFNdPKTKVfxuyeytkYZLVZ35IIFF)P(EK4yPW37BCIHQ89mYOxOknd2Bs)(ND2zN7713FYa4jlZO(E6iflZ47jZmWz0GeGfWzUN9dqafb)HOi4VL5fbp6K4t(Ex6pz4f9hmeKXfW5N033BeNNJ6GOwwe8N58mMaLZ1(EtPrcz3p8QIWrZ6kFV)kLcYKa)rf05W5Z4KiQg2QiiMgMpBg(04IaTHOmW(gzrqukrdwZszEVIGPPmyBNLBFKibVVjfoHGmNMXTMEKKlvLYYQd79vUZa7hkFHU9TiGKwq58E(E34p58RVX3Bi4JxF(nxo8YlohGMbLoToJSa8cjyVjVlnphqy4P655jjCkOZifzrIfQ1uvcLiaJnKWeHkwCc1FYf(EHGz9SrknPw)HKLbXSjx67XusHHfd2tIIkiXmCFa8MrbGeedxkJ1liQ54(amtbOkvrsWLd99qvZPGRoNjanb(GI(kXgt6dQDwUicd3fbT1u(StlcYfmZO4YFCVcGJtX4ZltjHCANIXfbLFgtb4Cm(be1GFfrvTvphvBkbWiZTEuZu6paKQDRwV5H)DaHA3W6268J0UBaXJ3xemJWbA0ooVJC3770zkQoDsfD4toku7vUsNMaaeV721iJL3ceNyqhISOIawmWHMHxCEo3W4a)mhcnqiopltQm4L)vcbv)QBxn1yyIe9oCCef)asXNSMBdiqRtoPws9jN0AhxDt3hVgqdPIw72k4Kqk3LNQtLlkZPm2W4UZYoCC1Qrxe52pPOW3FXPHAXHF7iisFtYewMuO0yKZBvhB7LsjCt6hjky3wgzg(0ZG)gCwDzx3nJKZZiM17WLryU4NPgVmOGXiXmP1YBUbcGvb72A7(31b4iqvdHeSUYTSqeewuutUc(wW4ONfVsnAMv4F6FSYUxDLSHyXt2uyAwpHJpbI9u7AwKum6o3VJiAZuM95WkOKX3XkQLRi)O2Qsf5wivSeMGWhzfvP16Yo2b6zza27dvgbfIzKHlRyg20grfZbeCcw9IZ0acjO04Y2aH0AhZ9uGyGuUQY2BfESQ8l2JcW3)wZ4k)84GZ7p8M(p5453d88xbHpLKueyjuqCd5gD7UJMCW2fbFDQ32sTB3h7F11dgEzPCFieDipW1EM6eNHiEg64Lph6bU66)3UbVWCgpUHBVGH9mS(i7vellHwmoR3BUXD2(RAhuutx2IvRdUuXdEw21eBNs0pZimLglwvbNazlwUTFxI6RmSAIzRuJ182TeZ(S7h3LGrJVHj7WCJkVrLM9qmXzosSbYnAD)2O4JTgtaMkCHVsw0AxADv7cGp8(hlgpjlA0D6Blg3FWvxCvFOTH36Pi(SDkcaxMV0KYGmICEmtvTFhNyE69p5A)u2cQ)Vw78A9swqYqkgRmxZ6iblSfsyaJd3FwzV0ntYyhxxwOgAkn65sICCfmAxbngwIPiPyMSB(pk1vqJiw6ai4G66x0E2qkAH2b8wvsbTv013Yqj5kIUw)fSo6dWb)aUFJ28nsnyiwI3TwYqBRSoCAqzvxB9oxJu8svfJT)wdJKgrFOHXUnYTfcYMvIBYfcu0Yznqvx4Axar1huaT3lXw4YISXHkR3Uan0rAR5g029Kv8ToDkB8STJ0SnqLnUzG)0JiKI9EWrewnrrZzmSoRB)9AfV1KNhygQo)0sfgiQ9bUvjneu((h680dmD2beDZKYnQl9MmTg8e7KkBpt9BgVFJXXFdBQjeDpNuBY8pkJxUbg1YvDc7U278dgOI3)ddH5nFEx9JIpu65EBUSz262VEkYRDVcls1ZTfAfVZSUwRR83CPQguToOulitCZFD0bPUDvUx3zF2249ejoM3sAxkBDER9Ddg)ZMx24nc3pZ94E3VnczRERUJ9d069m8FdGX3)))",
		Enabled = true,
		OverrideTriggers = true,
	}

	PlaterScriptLibrary ["Fixate"] = {
		Revision = 11,
		ScriptType = "script",
		String = "Lsv0UPnmu0)fEcKkrjbinW0EPi1nQ6IQKzpvT7SjXbSKXg5yOLx83(UjbOanJ2nKfbBNZ9Co3RVXqamfi6vwHwvGtTaXQt3Wnf4gqYqFF)qGWYYWvKNKml3aKaiPhIB7koqksnIvyu9QdgbFV4veMJ(Cn8FbKbqsGF4WBdIbsFexsaYr0Gbr(LHClqgZLcMQlzRCdtXkaseqil0V4OSz6nix2f4dfBjFLSI7xwODurXUxGBULBC08kLZqY7dK81Q0YSYrBxWL534ORvc7KSDtU3GSHZ5QntzZK8oUhC0DJh4QmCjoqQgCkvvP75r0TRqvWnwhnvNHgAb3WBKV9dGmescJgcKySAe53pS3W4yFuUExJZ3VLx9zWuMzo3o67ImE7)oQjPA1bmhN5Hxxr8IMYr)QJw3GmASHJ))iBgxI6CG3oF5Jsmc3(KwOqYA3AM2A1lBDSX8UBDE(El2YQxv(wF8xGpY9785flqV3VtwYMZp2ViXH9IcIJlviA)Jwy)Rb7pBDH0P6eO5KPXe)S0P))u28)3u0TB9hTv1IVPnlLc1Ch9rMzdd)gWr)XuY5T5bbxttKuNYWEcBLLtqyvs)tmO6fTRjYr98kljvWoPqlYrqVfENQlmuhvLovOFJ2ivYkkoOZ46vFOq7hNz16ogp8SDk)v7yTuBUB7L48MJPOjbA800ZISxj4Bb3qSFs2gvE1B7pH419TNdUSBPXBs9lV43cWFo",
		Enabled = true,
		OverrideTriggers = true,
	}

	PlaterScriptLibrary ["Unit - Show Energy"] = {
		Revision = 11,
		ScriptType = "script",
		String = "1A1FVTTnq0VlgyyodXUsww2oTidiRlblzTUfqPddiPAIwMYMi0KcIuoj7p0N9DhjLTvICtYslmGm1P7U37(PuSF8LXrYCntkuWXPM7V8(CA80rXrtjROXrFY84Qe)4O)IWlHh5fh9N07RneKFEQuaxfAArgjLE9jZN)jH66pZjGKRzRilOQRTA)pZ4eXnXr)ovLghfRJNoylMH1yQsly56QK5gTSWgfTuEBvIEjTkjxElTOkrM5UVuWaTjZKRPojcWp5i(9Bq2Gxgz5Kzu(UKnObzB6yhnb)1GvitaQwyV)C4HmHtHogDVSGTybTOtvsgJYbbebCjVGQuwv60VoVqm(2Q)Rmsg(nk1d2tPEWRSuhUfZH1yARQeirnX7NSL0tf0If3xZHFZrbfO4hquEHKqk3e3NdoNkiZ405h6kbudwvj3kf)mWbLMuG)byXelWsMMXBuoxsuoQAnTpgyJAKmBMX2MjFus(vLmhVftWvFKCh0DoOwHlP3HHb7FX()pYeXtN44vMuOJa5BiM)MYV1i7dFjutuUAgwwoRGKIcINH8BYw(5xJWza4vjVxYLf14B26C24bd99M4pomyIVFWKrXz9cdWaBFpjyVpzi6q9orRdUxseLAnXMln2VZYgnKMmv9JAPD(ut7fmuBYLFQuZzc6dBLL1I)o2iRnawQOq7PZ)ijHeHwMUMwOWcZ0J888gy2JGaBXjoYhZNrAmsCREJJWnDWFGYFX033d6mmJQN6MyUYA9xJJcHmEWiVHql2qB9mYF0WHEJmDMMJJni4pAGVNNjBbh9o6iZwu4yWGJmtoGUHHtqChd5DkNre9IUNVMiiQ4OrnEhq9KlzLSu8n2(7dOLvksTtDDvuE2H17IDhGg3v0drxU(smPchTPbZDhuDrvI9xTc9TjHtmq)wKuDbTOWE7lWFaOHnbTvV1RhtOO4(Mu5CG1lPf0TpTH)G0ZGaidobNx9ggeoEyiMqd(rhB)bBo9HX2GFWGwLCCvIT76TVVGc))b8Txaw767oDGl(JWtkgh6W7CW7EYkfv)zjdrOBNzsTwUQZdyChTmhL5HoFc4XnvJhFQvm6JRCWfVMOyNOUpmRNXw0VEb8ZXpP2vp73r2DtpHNCRd2NFQF8fTfRU6EVExD8v4b7GTXvrlly0BmVN0kESvmVC(cAgtPrX4aVr8nf3Fht5MpxlHxvWKLkJkWIaJklWrAcuNVHGxHnokIyrPH6ZP56Lw1HLfg1)BYAN7(IiJW5uHXg9stlJBJDob(AlG(F9yyrLV)3Vo3TN4YuKUPLffub0Fz(00JrwXS311IqRgZao2TPPMp)RPOFfAipWeSIDCst8xrURfSHVlWn30KanTnNwKsDdEzCj2Z9as9MDb4xGzdpVwC3JL0EhP9LvhJdXvj97VHaV754stkRL(4nFG4EZupiQj88Ledn6Ujb0BcMOHamC)MV1o3P3yYhphdGCyxC1IrYb73I9U(6e0WUpL5Tuh4k6)B4873wX2UA4jrENTtTYHNUd5IgiU5nr7(dMT9SF3x8)b",
		Enabled = true,
		OverrideTriggers = true,
	}

	PlaterScriptLibrary ["Spiteful Affix"] = {
		Revision = 3,
		ScriptType = "script",
		String = "nJ1(VTTnq4)xmWqT3A80dBl5aSFOnzPpgQBqv6ggqGQOLOSfISObfDBsXG(BF3jQhwYs2sjzfd2wwpiV77(UJFKu2Q23yBX2kcyrXWPlsV(Mh2sTxm12AbzdfUmydnXrWsCUmaU8pjH7o8U)b9HCdPQzB9oxweCmsq5(ex6TVYZ7JrX3EDibUZTbBiROX3kB(xcjlPH2wxsJDTTSf2l0kbbyQpqUhaJsrdS(qqeau4gxXjUOfSxMJQfAgzqz5Q)kWtSUFijA3MLuEEClnaGh9s8OM)WxtCVBfNTlYlX5cwiJNdHus8QjtNoBQPU6un95M6MtS9pBQogoxnvXC2evZjkAZmm0MndFYm0hq3wmbpkkcHmd3NqWv2LsYCYHKP2KAKPrJCPzgoe07fwbFN(u4YBaBK4KAfbwADiHkBXHuj(fPnTz6k6kaHAyOObPzjHcFvQrBiCFoiUzLGCwL6BJcgsjh8Fm9bjog9ZNldjr3TVpnAA4hHVIkcIwvo0R8o7pSt9joSZS05tYSC83ceURL(tIgjeEDo4SwZ(wIJSbjobrXckbgrW8tCKnOx0bJvbqZpeq7IPfrFLALceDXAs0kAwLeajajI8EK483SDpnmb6o7x7kR4AersHGwgUJv0tnvMRRQROnx3aKlASIolMEEILdkXvvRuJxTwgRNkRZFcfA1RYHWsWC)kLhJ6nlMROOaktepp0KslyBPImHLaHMvSlpyl0luhg(dLX(fqmzBGG6VdYotHirF68jWqMjsA3s1yIHHo2AyiP1dBiasDp7vFNtcrVmB)5V8cOLwlXH47hCpybOKZFxKRKmggtd9FzIZUOaX78Yob0m3qHZPrF9gYYq8ujutVAuY7tCKFo7myKbLdJqCzEGZwt50YNM39XFERhe85ibM(bY0dlCeypkmBZ7Xpa8MwfEpc)wXEZbAZeOft4)zQqb7ettibOQ)JIfWI7YGDCCglGtlSJdMXrSMgTh4Z(0Cpo)TbE0HJ6AZbhK3JcUP9EYzHuS(VdoruOCEqJt5(IeqrAv7hfFxJ5JyIJWo9K(HEK48B7)01usOy9Rj8ZVGtHI8SwnmkieW)agOgesEyaCU8oZ6vUZIkUMfejg(cEWQ1Ixagqb)1xJGRpzOMb0v1j9TVPA05H1yDWgPhuXtmAWyD18NGiVIfjSeCycHg4YbVb6c2Ifm(gs4Gwi2lPcsqyCQd(gJFhgoyVUcu2BDqjAEnq5EqNjQY00G000GxEekfnFrRotRxzt0rVFxSiW)H3M7REMbYhJxL9pEX7OojAuscHu)ACqrYfnB(JpDSxQY0iC7vjsxLZowyKhRvYHTfgpcn6h7Kas12d8BPEB3Nj(0rriZLaRMatLRGFlHFK00JCfoNFnHhttfnI3F27XaV5hSAC2M)EsQqv89JslSrGLUV4MRBp)nuXBPykF4OrTXmzeqMitQFAvIPbaKVD0rNYYPCrVnDB0ERzy3DConccBKdAtTE8fvAvB2Ad5((yhy389aOsJCnL7cgi1b1G(Vwba)mm5LIsRwtaRF(g2LbsnhFu9aed(PXQ(X4W9AodmTzV0VX)hw4JNGUX54wu73sbBRhhEhCPtnuhvFBZTT6PAu6wS8nfs1s)xx(GwTXjTUiBt6GL)myzex7n4icoK6g8z3WUdGRZ4XGaUSBW8co4wq7uph9yqz6QqZXibFTA5xK8paKhmy0PyXAX7xGQq3qsCCriFbEvVI5t6RuuN6LodV8p7LpoybyW2PtbRuoNjhmK2(8GQdyR60D9oHuFImys9cM8nC2UTFcUt8RIJdwfr9(pGwLEmTuqEQSqyXhx87dEUz7pLTKL6Cn64FCuDPaqvsSyPDzrXjnKCIWSLXumMT08hjKAmuAo(6QC4bV0UoQhkJwQxrz37IXJ9Oudxbke1pq5hRQR89QH(QB1vzmSLuGpLzZcTH7Vj9MwKrfQ4yzIWyANbYNO(CA86QG54lzTZj88xvHTf(Q)()8lftr(AtT)3",
		Enabled = true,
		OverrideTriggers = true,
	}

	PlaterScriptLibrary ["Cast - Alert + Timer [P]"] = {
		Revision = 4,
		ScriptType = "script",
		String = "1Q1EtjUsw8pll)Zc1ambue1QM)aFGYE9XutCMBTLAKMKgtV20HnjOd7Tg(SVNt)ijiDa0XB59cH0N(C(DEF6UgVwE345gnnLfjsGhVs(7BMpL6D1EEU)bDUz1wEU)GWNbV3XZ9kYeQN7rCI4PfdVGjGFmWpsaFksPXJj(076feCTi5UVYjWBUJnH8in5ofREyeUrp3tOj(EUEPEx1oxQDwsQTns19yss6IHjPKy4lIayiUo8gAAkt8yIbuxpv9(2VniXjJO8IqANYme7wQHWDkiLFtlXU5IDxTyNLqrLFej(4iEuSr8hzKUYYCejEXqjblgEQGmItdEJqjkkZa8NHuWesvSP(IH(Hebq6IHPHu4xsbocfOpkW6iW7Kd8wAG7Bb1Yqm8)A71VB3Uoh0QRJZUoh40EVd8g3OZUOLhSSG2duLwMo(2unF1wu6M2gfn(1Attun2Rm3E3)oJ)7MlviU9sYpLgXI(IcqvMda(cg88yojjCXWyYuwaFo4Pib)NzirHrVaRkPpJoAsZfdLkb8sGbtyColHcapiPjiwMauUMoDm6xFfZpzwSmxl3a00eAkzB(6VfBGy2KruWP0pM4l39rOHyFlgchJLyGWpMssSfhgszpgI)yoUgQCpRkBOuklHrNR3XLrbzkwNcbUarks(nvRrOADWB3)wx(Uy6)e0fc8Yjeoh(kK8e69m7qaQ1ueh1n6TPEiMBksJJ4j6GbEK4rvWqkWJco8wgRJRI5w83T1ggP4)i93GZ1IdpZJFoc8eqlKq343LOWG)2lzRnqE)IaU3KPCw6Sa67dXlzCY5fI(wRI(9xg8QuWCydzDrpNB9Bzf976ue(9JP)3zuH)8pa4NZle(fA721q4nSjui9OkiFLj3DkLZheGnDdwQ8bszT866PAmNIm4cwYBmXHl3HYYLjBLDBja8CoaKRsMentKQRNdIUqLDPQa4c4BAK)Z04e0mJXxooG7IeeGWtHgpxzpj3u0A4M4hZMcBBhLE12u5ObeaWP4eiFsZ(fdV9R3752zJQjMB)auR6HOySxQN7UkEdg(BOX(SOOgUZ5pteeyuM9KWAoYEIyPXDEXA1cOUUREYiLvi2cLJzcMUjGl1euQmzz1t0tccHNTGA8JNj8vITAcLpgQXmtWsheOFaICNGfEOINVbNuaEuz4K)Q2I)1IH6)YEQrdOA18S(wzkwsojgU1S)mohQcl7cDiAoQwclZ2H)S4yQi1uA)lfGztDn9dpJQxVmUfttsJIzyfhPjjGoMmJJwA2)d(zvre8mMgXIPb4Bf(uvDvchApfmhxfzrr7AilGASofKldcvRMb)RJzpYeeUcF1KBvuaK6)qxXHU0m1SCguWMgyxzz6wQR2rvQTzuYJ8j882SFrJcRgZsGJCxAgyblROvgz9PcC84InMH0mRUqvExtGxAYpkkoGgRN7Zej3c()MTnFaJ0yLxzXpYaq5t6kP5w983UDWrcK(rXUYObdEkK50ekBoM9yZxn4VDI8xMcdQScLmiFeX)PhJHcNbBk7ALeOMWPCIFk3tvDTPylXtvuOL)GQnDwUAJ1Yiy4AIS6RFeMoHJh9k(75Ea2xR1oEU7dpSxxN2o70Tdmoa(Qp(6zRQ8wtmF4evrKvsmlQCqnJPz5HqjCIzKblrJqdTPVROr7vxr2znf(1bkVMW)EcuYTj(Hu)Nu1jlonSUf3ymHwp2loKWk1R009fRzozdQCBAemJjuXVGdtn1Zj1U3gUKLTLBV0I0BiwDfwwimiR3So1wojpa4vjwRL6Lr18VSiddObYUH(Z0zyJjG0kvQVrI9JGsNkgdNtqwN8a5N6N)1gyrp(0qIC)T2aLUYMRiH7UgklFLuqZuQL7u2t4reHtlgnbCQ)J1PN42Ye9(VBjBSP3E7gMcehaCuwo193Vgj6R6xH2(M7H9PY(WP5()6DbvwYXHeHGYLt38f80j8e66WarivO4ztt3Qnu(kfgDOZAyWlSG0qjv6(MbJAonoAmdskLh09bD2lvqNmxm1VziLWtdFGHU7rK0BBD)7cFYci4rG6j8dng(e5yBWt7aM9FkFYbEAU8PgTxNxqwEWkV6S186xBtfJ85l6XnJyuOwRCztNnLTRUgDW3cgx9zTYRUOyzB7Zt3E19zwPjwT5WJ5usCpo)RrmrAs1ABIEqpKKcvyRanB40XPvQNte8yLrrPPrtmRGgrN1X2PWXRGtf8wrtXT9kqfJHY2rv2sLblL7c5y)iHS2tvBIe29(LpaVLjPGjCA)XnHd05nV5JAUz15j9XZJosE0gDDbAGTbhko4AznGlo6Q92)6JjgOVXPv6VF81x1FWzpCuVJ)JZ(21F)QtEO)f9Cp)Ht((36DZGRVQmjV09wAx0KGGLUkr4hrLEVJ21)INuzD2Gm6kzgi4eAPu5CpQBtYC45rrpV6b3w)KEsyuYkOJsxm5yPi1V3ejHxnS(GtvEjKLsRuBJaE5bzndSv8IlTb4cd2M1i4qnMko0BXqAl22LUTY1qs2D6TgAYU4S6znbZ(2rBv0gi10rAl5z6khjfHBTnB4YMQaJ6MLySDKmV)iAiteuU7xNHGdBCw(a8fhaCj76aC(KCF9sdYC85do9hNE5PxDt)V17YtV77dA0ZpKrFMobQw1qEJynoJh9copt2fd8NyN8Q1(0Eo1x92c(uhhznZSrHWsM)f(UDDC(CNwTnM1UoFUDN9(vbdMDnclOEehQlEPCC7Qv6DYjip7Uv78KyYlxG33w1kx)Jt)2f9(3B)EZAmGLUPXv0AlQE63Sz2ComBq1neuOUTZ8BcmC2iv0rye3eh86RvdHImSLU5Z2TCPHvwmV6GoIPNriNJaPQDnRUTjwmnPS1(Dt27WOxSTnWXx)dvqR4rS1iEB8y)oUKMJjb0bI16zYOPChuXRh4v7gJs7DXxpVxfDnSn1r9ZMmZMD7uBR1azoMUqC1nlI30LxjfX1Zs3Svss0VVzQ92AMAPgb8nRjFewRc3kEjx236irFnpREMJT(PLMqfMnT1h5TVLXCGXoQ)Dc49))d",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary ["Cast - Castbar is Timer [P]"] = {
		Revision = 2,
		ScriptType = "script",
		String = "1Q16YPTss4NLL)SqfqrGbJTRk)aJVXESXUICYP2YoygKgS06HrSsc7WEQWZ(29CrAeib2o(uKaJ00t3F9LP7EMKrnhD7iNW5jbH8yy4qXZ3UCoD0W9h5mKmJoY5ygH)0QXxgWHh(oHTaM0EKZFqxQxAZrodCd5W38eA0uIl9(EEExZJV)ggbEZ9bZipsJVxs9dtqgoY5eAS7iNrjJg2ktQD0s9AbTRg3sltN(K4KvJJtirWpeoWtjfX0KKa(JX5GuR3gKyKjuMjK2RCdHZCGBLyjA)BAjANj22AXk17JjrRg3pKfc)CkNmHr90y4yfewetrANqIe09gHsyyQb4p9PGDLkLs9vJD9jCG0vJt8PWtc8mbXJlkN6iW7Kb8MLbCnEfXz4FAn6SUD7AFyZU22TTp0U1(hoAAJoTrZpyybtaqvIs7CF3QMRCjsDtzcdNUU2yHQX(VR4)U)ME9UzsfIBVI8tHr00xyavXgaWxeaJNYiX(RghrMh4XwcEkI3)zbsKF4lWSc6tPJgBTASa)WlbgmlGXcIPaW9ITaXgWb9YYg2bEweXfrkgzPvyR2kvwWRtwej2992uC(IztOrA76zsWNYkWqCqbgcBTLya3nIsIlko0Ng8Op(WsCou5EwMZqQugA0KunQJrCfeJEHGf)o6Jr4(fk8CvOhQwh(29V1fVlI(pbDHaVCgHXGF8jpHEp9k4GGNJiRUwV1jdX9M8KOqwSkyGfYFugmKa8WWH3Se)DlL9riZpc)TJe8M(BW5wGdp1JFbc8yqleqx73fasJ)wRX9EZMZcsw4LTv9at9Wy63JIyegHOV5MO)G8GxUfmd2WUUWNZS(nxd9Nfr)VlOC3LPOVTTj8nM)da(gLD7QKssWmA0LbXj5Yvl(YzVo2TBjYA70rx1w((oDpOR49n7ORDkMO9bDAUNCI26QBfnrI2mClk(vJRcyr6WDMtzSbEy9EVCjVqkR9gRXlulPZjvasxtoP8CMueZsMfUGNOkzaI1O4HaVsfij09zAumADhEOTiiM45HOtcgqvfkCcAVDIDJcMdRszQgMzBhQnNG9rzNa6APtV0acXzuSdOpPe)QX3DZpqxYUmdy6LhG0LpegHLZh5GUdG3GV)wAKBqyydNLSNjCc0k1(cCVezpHNRDRxkmHfuAXr1zM0kfvaLtd4bQ6qou9(cPjnnLMQzulrOHZ0fCxPyRgtztH0Cl4bjd8udGa6zyUpk)5BXMvGHslR4PAR(xRgR(KoQrdiH5Y0sNPkwCgjAUzD2cgdYNlkuDeAoQwcltxH7IOikprN))lgW0svO5OZPQ5lJBr04KWOamPNWK4rNswWqlDW)dESkpegJzccIOE4B5UuzQDcdQq6TeNfzHPD1pWJQTogYnacLRMc)RJcEmGtys8vtSuUbivFqxXro0u1SCgyyt9kwzduv13SOUqBtPKf6syzv6)IcffAmlboIvPyqbyzdTslRpzWX(MDlaBZk0fk33zb8sr(XHrE0ivRN6i5MWFTAP)cAWQqELg)icafJuflYS6zVTKiQ40DBUL1(l8CieQrIGwDLjiajeYzlLXiUywGjIakq1IwmpHAQ7nAi1zieCbYhLadItLOG76azzMbitbN(Yg99WdX3Jr24AGi5mEPsntGxCn)ciI2AtTnFe9d9j8bAixAaTyngzoSGYktdE0ATtuv66xpecsfMSi(ysQlxADo6gseWr8DXMGmNmQTj7ZT5PKDsPm7yI7tpgbLS82vERnsnzbhTn6PS9av3AYRC8uIQc(iAkixE8ctqJjcIf11CdXevyVVRX)rohI9Cbhp05ayW(T609W9ADa2eXE)DuPytLVWuEpCImQEJuE52aMeopDhhuCKO7hSG95qReZFx7ZlUUfYUctoUEGY6e(3tGsMnX1N6(KCVN5rDunpmvK0qEMgS9SnQeOO7l5CK6nUP9XExsiCacOwQHdt2u5j1(rr4sKkqS8s3TVJy1nyzH5HLB5fhtda8MeR0s10OA(xLN3jai7w6ptwGL8bsRuP(oj2nekkjzmCiqrfOdfFRg)RDWIES5(eX6BUdkDeTTGe2Eluw(mjGMjvlN5bpHN)Fa3nCg4u)hBtpXLLk6dE3swBtV7UD0Fn2A9K09u)4hBrIQAIOT3AFSdG0VSTo4xVlOge33NW5uMOVXVGh9Kft3ggmkm(Qwq5Zy0uwNTWGxc8s8fuPAqYBI18OWPbWMsXTy8GA3lLtNTKp31YNsyj(peGU7jKK7A(J3f(ejqWty2J76Rn8XIgIHr7bM9FkgzdJwkg1O128cI0dfYRoVAE9RxtgJSgj7X09sAKRvmTUYM02vxHoSpQaM87ALNDrYYwfFsLwBUo9mwy2MJ6ZOKOEm2nHqxHXvRTl6b9qqkKHTcuSHrNMuPEgrWWktctscNPNbnI2BJTZHdUcN36TIgZLTgOIWq5Irv6uLblvxEahplKlY9uTircR(GYpAubDsbD406JRdhOYBwXhz7PY(X3rp(f2UAzfGnVT(Il)RoaUN66a3O(E)RhE2GZF44E9)JZ)61FB4jpC2L9CU4Ht(2x7D7GRhwMKZD)0flAIN3ANOapPrjxQCX6V5za3MniLUs6bco7Bcv03J8Qc1xlXKWN38iXBVtpbmkzg0rPsM0xis171rs49(RosALx8dsOvQTtaNVrwDdBM3kDra2OX20cbhPWKztVMH0fyBZDR0BHK0l8Dl0KERQ1tlcM(RTYQOmqYUJuwYZvzoInHBTDB4s7QaJ6weRTDKuV)eQFa3RC3VAhc2SX5znWB2ayo76aS)KmFDUgz6FXGt)(PxD6WBp7R9U607)2Gg9C9dOptNbzRAiURXgNZcFb7Nj9kx(tSsE1AFAF76BEpmFQJTiNzARqykZ)cFxBB7p3PzlTzTR9NB1z)FzyWkwJWeQhZG8IxjA3UALENCcYZUVQvEse5LlXBYSALR)(PF9YE)7x)AtlmGPUPrvuAlQEQ3SB2Gxtr1DeuiVN5S7y1FXez0HFithhS(fwIqre2s39z7YNAyJjZYoOIy6PfYfiqQwSMvVOow0fPkQ87US3(HVuT4B)O(hQG2WJuuH4xJh73XLynL4rhW3QNjLMYDqMxpWARgJs7D5nx0RIkh2UQO(z9otRUDQ9Q1aXEmvI4Q7we1ElxELqexViz3wjbr)(MPwVwZutzlGVzn5JWAz8V3qjx232irDnpBEMJx9OCDOc9M28J823szoWyB5))pg9))d",
		Enabled = true,
		OverrideTriggers = true,
	}

	PlaterScriptLibrary ["Cast - Important Target [P]"] = {
		Revision = 2,
		ScriptType = "script",
		String = "9Q162Pnss43f(ZkoRHije385KFa(sSZMy7ZisMzoXHqd0aATqIvseBN5S8MTN9rAFf2Q6wx6gAbclNmmbRlDx1xDTRUAgAmCWqB)vro(EHWL3WUFWZROdVP1q7BilPdTVL96nJmgA)zI7A4v6dT)h0NtMi88RN47bF7frdMrMqVV30P36fE)DUe4j37SKmNgEpF0FBSlX7HH2NtdNm0Ey0WBmZ4zZT5PzcpTTx4)y4MrrlOWxKG50OnJ8GXUzKdmoYMrH0vKaGFBgn2)jjaAECa0LmM6kcWgsauMWXO7cKYXOlCf11nbC(bXp46ZHBMfpeB(qqKZUhGZMrdcCMphPcGFqI8GhTWbKYkWBRuxHMPucL1ES0w5yPTkPLUPcl9LUKWfP6r2DN(QA9ALXuGuFK8e4Lx3mzex5)4MrU(EZbRrI71meeBgTYL8mfmcpUGMyNMqcbdsi4)ffcwKp64bQO6qaWLbKji7h2pt1vVJKmUz05Rb)thMOCecK36LJPbXQeg0sPdiDTZKoJTy3z(U(bjWHfBJ)Vj77gSVTWVJejD8Cog8nHpfU6KnFbhDU1fWzN94U1oh3T2L0DR7HJBTxqEGEAcGy3vs3nd9D930R3mzi)UANPtyplG(3c55YwsW8dHiEestGPuwHOGnC0FnKgf54nhUcWCuGVlC1cbx6imz5d0c4SAkPeEvCwzWx0z1WqrSOUuOyiiesbJmIKaFrWpof8n3c69wUY1jA9uAzXEgHqWBUl47id(zmlAgS3mAP)3Zu(QrVL(wW)Ya6)An1BYZLf(zecHFJ9T0EJ8wBVrjJbnSuKZ)CFqn1ZdMk3dloyu(XYRcyyv24YMkYuY44U5jVSPENwwgDS0nB1UTzRwdNvRzd0SN3BAK7BKYXo1pQSzy7n9FUo1lBYwPBb6Jjqc8xJvpiNZGPeuSyOPUss)OZ0Of7q6iFO8eiNdwMYmm7cMB6z)1bcmkXDVMHUKE(p2m62zZGmwP(ADKdiEXE7pftxucBVVumss4cQZ8frLxezq45TeTgsI(FMj6VeHuqjHIOQ1sJd8uhe3PSbXDL44wKoJNsqPC7jq)xohn(vRvnn)LZXg)Y1Qw7zZDGBvsQ)ZyRC2NeiJQULmPVPqsFRe2)PqiwpLHBL)VFmawhsXHmMe8csyp23pfgmUXl1BmYnwk76mW1sXks5Hl(6sTTmA3QBJM6n6QB1WITgJLqn96BTEdY3(VirqUQELWVDEotMT31zkDBRLTOEZo5wvFQpS9G4geCBCNn2geDkRFv3DxLPr6EkJxCOJYY9ms9dhqFcGOTZpktDQ8wHGeKriSBf6s(8C)a0Q1)5ZGDJfk4PlgpGVk1N7L6SZ4VHKBnhLGOw8TJkQEkRRldrMkqetV1FUcuPZqLEwa1LD60QRrJ2gDBA1Qv7MM8s7srAFYKhMhxZ1RcEBKpE77hmLgueulQl5Z6vcDwkQWQL(wo)GxOkV)UPjeGxI9h73XYmlT)pJyCsHiSzXIoLaYvSQbtbQP(UmiziLUeoGgr(t(onieFcuFk8Fa(itNIeMtNH2SOd7iumSdNe4ScMg6za)XmjNCTnJUE5k)GiIhCxsAVVC3xhA38GqexD4Bqw9VXLXH2wCQ3gDywoMm9)9F)p(169JaIlIlij)vGcWLx18onIfamKUz2AVj8KSAHu3zNSz0ApNORNgFbtpcxt9((aYyx8sUOXUR6M3Vzu8N0RCGYZ1sgF9pTAkicCbTV)tAIeLZPQvzGZtGw7qZKpPKnleM3bsqr9Sw1IqcUkToBA3KS)GK4nj4PxxVz1JKmtFElIuPcNsTBwi0LovMeXUkUldzQ0SNwiskBp(2zepMBwW6vr5R5fNRGbVoejnZzE9TQ26G0j5d6IDQnncIsJwhMuPdWdU6807ibaLXNfQMXIfivTA(mKc52FFHEy2tKF9753k8bcyAkhWOmsOwnhVqAqew71u22wdOkP7q7UqAT2qIToygzOoXgDBHL6GnX51pUm2JfYKTc2JBABBY8wRhLeLkq46tfgBvfEzV)GXMih1ucPmVDCmh2BFpCxHuC6votPiJf04gM)muT1QnjGYoklceja1bToGYBmXASwTzOloj9Ckgtx4K2UNSDAKxQupSHezI3yq7(UmT7ao3Gfv45yZnuSWuyZO3M5UC6zmb7ACbOm91x(IWkvND11x85l(4f3m4YFR3hV4(pDDTEtw4q)oDj1lQwpxiwO27C9F8RF9K4maVJgXw8xR6F3sx4H8fSHNAIpTY4uhjmj6FHpZsx)nnnmXCQW)mAR)gZMT(3vZnio5kx)jexupRs0zsCX1pPev9aX8B9DbC8rw4VwLENFELQfzwNhqE8dKNPbAvU9Zx8BFO3FIYD7cn378DWkk0QmHIMMkXAvung)KdtMK4L95GZCAjjjeGSBRhZ90x47ov(84egviVX20dNTGzlY)LyKKKNzAUPRqGOPwYor16IjPb02ZYi5PVx4)OQPbg9tEvz0owevE5fXIvetsCmYmYu61Em7GAnTy25TmqO7wVpC3v9q)pd5mNjlHlDKOVjnuUQsGC76OxbKywuKGqw)WP4NaPjciPhAel)UCZ7v4OlU822sK0sFIlcPa1sNs3Egs6HHTNXKEItNGQB3qQWF1t0hqzWS)G3exeX7It4ekc3Q5O4wZ2cq6jGGCxuNf7AYktAuOp)qqF0hZM5rXZZhu0VjG66te855oPSKMXAc11lULjUQmfaVRYqIJqidFGzBpoHuHRt9BdCM74rCtTUmNPd6dumIMPiE7HD9kgjt9W2lnZg1HtLLShw0Vl5xTd(lWzVvnLwuybQpkDSmileGQvzg(NkIfkILTG7)dYspQEDiPJntet3KpVMHkBvBzfmB10a)vdOlz5lQuTqiIT3jNFq16GrNM6fFwCttey6iAvgC7TFyW13vuMM3Qq5WkwMbTkU0z7k3bybEvIZUOFCBjwMljAqT)IoDo9shxEKGyPP9xhf57fE)VF11dUOZF0HvakoAufYgnMsB8CLtoUdmNtJioUHjTGjRKugXIsMzuWAA89zexQW0ckoSD2Qvhxms4RohpHeA8OMEIcFRfApkL(nSiT3QMXXrjqcnWhZXBUMNJlAVjbrp6h8aAXR8oyk4iUXpyjXTGoF3W2DyQt1U1YMtb)zBY7yAf1UqkUweoE(eBuPkb8swmp)TvYD24GtvFFk(gnrAw8o5KqRxCVBepBHc34M4QvWejGfK7vLJ1cn1pUWrDonvw8untshkOrdso)HyCkPRojBA7RdqqvmV2YLcTz6jLCSnJkFZCbIgq9JwbucYIhBLJJt6KoTQQhfw3nR2Un5tlxEgFspvF58umb4XXzHzE08pNDg(IS2O0W7tsUGn7GuoEfvC3w2pT5d6fjrz1HfhyFfjuSZJyhUXLkuvLwHtmPSpLIztqUuG(D2uDaqYpam1Vn(3XK6xg)lm6NzEHd0Pk0i)zAaKI6yIcY(Dfx9fz2dOai84LeDmZxsBSBV4hABy8ZO3Thv5bJYPr(g68JVD4))d",
		Enabled = true,
		OverrideTriggers = "merge",
	}

	--for abilities that channel and while channeling throws something at players or do damage over time
	PlaterScriptLibrary ["Cast - On Going Cast [P]"] = {
		Revision = 2,
		ScriptType = "script",
		String = "nFvBVnkoq4)l5tePgeqETv6(q2w1DZDxFrICRUvxpwCatcxDSrgt307d8B)g)cjql5LUDxPRPHyWZm(5zg7zgcCdMh4ZYePmAom8w19ZFodlh6)B4Nd8JzIlzegpW)ZisbwlL8Fp11(QRdcUE8qNHUto3zK74jJhn48GKEdheic8VfTgh4FftKxgAS0SigfUsfyEckc)W0447O5pCpbbp5H01OL48h0W6RrAvUcNh10kcje2cxVa)BqBaW40u2)Sm8UKKCmaKBsPb32tkW1CuK04blQy1Tog6UPs63cgPfRxG5nP6Ufwi9shfOFPnGw3G1eyhMRZKVheR48Z7a6GDaDu1YFNsLYWbVYzPn2G32sVGGOpwXD5AoSfNt18tJ)NICrz4k23kdtqYHIv4YWfKu6JP0LLHSOOcEUXP5y7zGwEgghVdW2dQyZhKAwg6RN)7XNT1N)bj6hDa0dyQmeTMvqbCZsaSZr08mehtJEUotkdJqGORqpHRyIHhRtPtjzRq199niIAnmI8(zZ4dXg0M3bBQTo7IkdRyjAZ7Gcn9hsuQngWNjnsO1qW9Lv76HJg6oC8iphVZNmCW4(Ymztuz6CKhqaPegyRy77nNMsFJdT5wBbEJOGJdKNm9fSONW8CPheYDa)b(ouCSCr1RrGVc((cjB9ZJ4PzGA9nuR)e4VrQS2EoNpA8iPnbPVuDMQhKBbIyFKPwx9Z(R7)7a)HaJD6pX1b8EYCdGsJbGNkqXmEVP)lhrKiaYvmxHDu0Jl5WoK4AeIcE9mjenCdYLHkd5yqMin3tPXPriHM0svIuiifKCbw90mWRY4RXX2LH)rooPGasY2QPuLvikftusdh(jeq5ynFIrsVpGiWbksxJTbxfKpiPGgPZSzLJjjNvgwqtfZIndGnSRXWym9P5Ofe5qTtvDx3YFTm08z7iPzSV7Jx(v1wS56W3fxsWi(uc5EanICRUhtEFSqjQvhblJGteDotlk8t9h5i)(gS2cMqWwZtxUQHfFXJFPv3nIWIqevGdezjhJPNjJOfGN9xkd1BcV4EephR2sNBvZDzdNossxAV7eZPa8pdXl8gL4wVEzpeivRJkhVcCTGevbIJheNsHJUYDj2ZOsiDvbxDR1UvO7X19UcXXv(vKaY9RTJmB2(4rvbIxRnAZjOTjX7B3rCnNTwPQvdy29u1FoZODDyE6UYAlFtdCY0WyOT4ypS4OgsAKFNXYGunwD44mms05484c48YZwTUovjCSHwV3kVBTdz2sDVQ2Kv5V8oR1GCvl8TpRPJ32N00Ay3JHoBtTQz0eM(O1nferAgjfZvi3XU)jZvV)xZvVJYv36mftH2mDHI1LZkNvVKtZAjZKF61lLMd58KfgJH0QRWCC1C6FbRjhe4Fo0Rw)aFOVexOy(5od96dvZD7)ZVSwTn(qXO23cBIDsbAl21(EOU)ySJx3xAfvqaUf(aUiVFgUOE9I4yvFiqQ2eckF1223kd)2Q0i4(hX4S6T3bpMGB2WdGOL6EwaWD46J6m6TpJSNk5uxCPcuMNBrtjYc(Y2GGdvDoLkWQZsv67cAR(EkAQZQ6CeVLI8OQqNS(oRaCsjsg0E3WhDBzloMAZjnSPvfTZz7CFQyHvRSbyC1ggy3((ym8gQYzHDANK8FkngBKV7BR47H4NA69trR9OMCxbsgV6yIWWBMPU2)fr7tQQ6bbOA(3jc92Iqnw9AjZX(o97(J70)EYw36Y6OFTXG)7d",
		Enabled = GetExpansionLevel() ~= 10,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary ["Cast - Ultra Important"] = {
		Revision = 14,
		ScriptType = "script",
		String = "DN162nkYr43f)lRKrSCrasZ5m)q2A9ANSJSpd25YzSXcbTSidciaAMrZp0Bwo5rkVcPQ(cxKAqYJC(twVEmOU6Q(Q7v3YvZ9ExNK0IWK4C4XP03VFtkXDQLRZuVvexNBPlVDMMRZFXlAnSKQRZFMSrSr4ZVXpjg(34cs2cpFYJJdcUno)X7I8Gp5XWvEVqYFKr9ZZJ8I)IRZesUVRJBH7u9kzAURm1fY0b41M8TZ82olpL4h6fbphdCMrx(YKVfg)Y2zfljBNr(EAusoDHIWveLgWv)1b3iV5KO6W1OdtKrlMiJt0enOsMa8)O33PYMT(nX(zeVCsox5xs8IkwUD2CVm8LWxwwaVSbxneO5RmZ5hdJPGKH)R575cCpxZ3ZhtckvhdU647LxaeXi51PuXRxnNK56CvMNp(bUZrnZSsZgiqZLl9IFb0e8TuKvBNDzsusManxWbZ6CsjjCcEvw5KKshBRISaT0LqutaX2Ggnfc)FD3Rm1Tmunu1m1TTv11TDx030anLGDhuwGQcUIWCzGD9Nql8zBHPgYGVDhXR2TeVAFIXRdB4vfoRlHGN5LkzPVKbPhYrqduWJcprhQduqaRqa)MLrFCEYxbjixmaKh1WlxpyVvhSLQT5GbdmSThnyGQLb6Gn31bZdPpjfRHpwg41uB4KB6jR8W758pjNSMMKc3JrR97lRAlETgISoX6VA67hCHL)PIAVWkwCaFT36GjA924QCUMDH8PokAz40SKxYi55kufWy)Q5AcrnMlGO0LEk7wMMV4yCXk)QIj3kqbhFXtQY8fuykPPdy7BIZ)AyqXsbohuhh0vkb5Wg19)PqxdtaJ7iknpcuYAxvdMn4LOzwfuR0I3UgDAwDnAvBdoODQtoOzljjDsceyowm9uv26EFEDKCQZnPnusFuQeBVdQ5atl1HJm1hPnCK1G27GgKuCQ1vhh8pwJjSSCxCLTZswWFpaXz58MS04rsI8ufCJQy)TTZUDXICsbpYRpUE98aUpxK48Db1)85h7ixC8A1dIZ)UmCwJF1wVAEWtnFMQXBQHZATtSl7BY8d)EyoFiwNusu0nbnIwO)JJUQQ1qDQog4L9LCu2ZrA4hXaPrBKUHQnLMxsIciXzWmU8z6zRBn0yiD9vEzjGsXh(MTOXqD7sbaf0jXIryzRpqDGX(RBjw30YwJX8jF6HBMigodxZyK5qZr01(0T)2d)QBrzOn2g5Ni2ocmzvhriNKjcTZzwWTZcJ5FciM3Hr3bnd(XgB1OIzWP4QiX)RKm8awyOe8FaS9ccqWXWcOSuDPa9Mo5(zHPW24w5PgGnwNAOGh1TSvPP0gdhAAytZRnS1hAQHw2PcVQfMWXCE24Jm)0q8rMxze(iZbarVW(gna)RgcenTbwdO9fMAyPPnuL2eEQWHOHIK7a0Wb4mhAORslzdqb4PjTokGqlBtBALmGp2MQQ0QaanW49uSIpBbqgns6Ir16dtDgvKbNC9MvPjzfEXWh(57EY1X8Got05)mmcXZzeiMhJebodzhxKSAUxW)5F)Vs6p(hzErOP3Ioen4eXok4gPNi0de2kVViMwzvYC(5JdG3q3mGS48fjzRaF9IgJUK6LdhReABcgiNfRJ9znRopNeTacywhhwCta)bOAWkc8mj(R37npcFK52PV1B7FA7m(pLpjivbMLkdoDVtkK18ECwRZLspIUZl3KJyKVEumhxBh7Y)IKu2CO7YBseCAGJyFxhgqASpivrcazUoLRI8YxwEsSlsYciGz(86wjvfvZEh52d2SZMp7mghSn72SMVYlkckFerQAPJ3IICRB)(H8lsqYCTH)OMDkkXhV9LY1f3xWhkvHG5kWeVlcbqqPaA0gVi8ffsmz1M4uFf2bEFgKighJPd6pvjGsLvP8GXV3HuiKZ57j5)ynTU0Y5aGM1D54J(uwwPlYKIzNCcgsyC1vsvzoqJ(KARDUefeCP6nZzu4gnXOnYxLpYG8f30H(Z9I(WmpjR4Tz)GuUu2a6Zfj5fzWbCQYcFM1pEsVN6iHa8Dxw7O0xLK5qLIOqIezUZTf8UDak(Bli9IQTiqz7vtKl5MxQuR1xe5bP(3e4qTlulOeJ0uGKj96Osttjwp253imB)fBUllmjlSytJAbsuGMxMuVDL5(OGlPjK4n0TWUlSgIPiBnzFojjtOrDr4vCQNM9oK2ual(WgrXN2xAjjJSdNGxHFCDG(TwJG(ryFBy0b7rQwMqRw8GsVvTOeHTq9)JiTvA6)ROH3(nxou7N9q6NilYi1AAWJIQa8RVrbQ8))wJIUmHDf9VWdMtOxJOq80WV9te1VpuTUaQDKlXljPXwxvSlVLEjSQC2P2yq59PjzZJlVLP22D19qjxjXONIYVVICmlalBYU)SMtGYV3m8yi5HbejFfhDNDrHylRGPimV)7VKIOBWzURN2ufw17GJTskUiccq(iT(15NnEYKZo0Mu(gElwuiQz9kMmX4Ge7v6EugDiAliFVynuUfP(ZF(aNhH6SmE6PoRNikC104x9PNQHVAE(J0Ol2qndEBHT0lwSlwuZp0gpAnVRKjv(hzPvDSX2Cwx8W93F7uNhPu1FsY3I7)qQC3euKbl1x)Rp9OAj0eUsjyphB5AxVE(b9VY3z9Z8jrO45HCUC8V)R4HI0ehmI)m9xf1H8)8MklDjYsvzKj)p9Kz4pMJMDiY6QXmRWk9lj3hSY4voKVKE2)f0t63SB9(EDQVXHTJpSJrQ(AhAeuQqNSoty1AJKXRsJclwh0fBUkJ8pxtI93iAex7VQv(CMDhFPAW57scJXlbP2CqsCl1nGRtdOgq(1GHOOUTl)lu1NoD6SCOHviui4Bj495etWBEbm4)sgjkXlOtRRYTzHVeg7fvAaAVrCDZ0XXuHHVtEws0rXYsNqN8SIQQrLQ(bgAs7TBOPD8vPKmFsCXr0LMguGnlIilko7DYhIecEOncW8X)q9QcpJNk9oUWM9lq4NQAV(JWGVEhvpXgqyEsbCM2oacwXb25BhuP3g5aS812zTuebc39RgoJA8ztNjm4OZdc0TuV(h4iy1Vcn0LQC)YmqVIipWPhIyu)FZjWRUFHMB4CzHsk7Y0oo2AJOwv2x0K7)9d",
		Enabled = GetExpansionLevel() ~= 10,
		OverrideTriggers = "merge",
	}--

	PlaterScriptLibrary ["Cast - Very Important"] = {
		Revision = 15,
		ScriptType = "script",
		String = "9M162Pnss43f(ZkoBGO7s4Zz(by8TzJX5mYjZoN4qudQb0AHAwjrSzNZO3S9Sps7RWwvRBTWIlEWBmjGOv3v)vv9vxAXyLX3p2HTkXNfgdxoI)973SIoEK5yNrKL0Xo3XVDQRYyNptcwd3sESZFJUPyHW43mLfcVhMqJMrMsFOVN3DHXp8XacmYd(ljZPXpKn7VnjGe(4yNH04PJDgNmEKA1EAS9EQwSNoGS2eN6ssDN4ph(meKA2CEAbfEpzbn1Dkjoj1noHeL0TggvFDymGmHgiIrTAySUGZb4fOKZXr8kAqqQBiOlPUSO8bUzi8Lz5tXjBk(fqhGtQ79r(ZNJszc7zuhHHw4dAul4UT62GX5Kuk994S13HZw)eD2gn4SVmGeVO0oY)2zVPEpZQnfe1TKNbIEx1IzCn7Pu3awiWQ8JZ9gZqqK6UciDuVDrXIbpYT(HGjQRsnDj1D46io7SYk21gUzezkF0bVofkC9Yj0OCtchALYh0oRkTBByColGfvGbE4n(pv(7A831X3tefD(AEn4BA2sYmN81lq0Z8UaoT3dDZAh0nRtKU17WXTolipspRaq8VDI0nf5xY3K7AumLFTzY074Jfr)lzz5IxsW8dXiEestGPuwHOGpDKVgtts8dNdxbyojIfaxTqGsdBqciJMiRozcVbYQ6BezLdFrYQIsdXIY1cfJbLOwWixifWFBW3F5Qa)K1E0s0BiG9jNk2RepcE1xcE76GFg3Jwb7u3LSVxz83g9xgr)NRPHt3uIED53s4xjFe(A7R6U2UkVRDIXGk6nKZFidmt9lkIxgmwF46vbu0p14sJgYuY3XxMN8sdzBtDfBDzvtllvtZXZ6yOHU9DDhTDENA5y9yjNAg2(E)J1LSSPBLUfKpMajITg7EOEodUrOHIHQYnk6N89sw8crNWG2tGCoyBkZWSlyUPnS1rcBubDVJYwS5CgMDnR)Fp19UzZG8yNaB)5CjGAO1(sXutdxq9NVi50vrbL53QuMCLvlhIBofLuWiIQyt1sZd8Aoi2(udI7vBh3s0v7znOCAhlq(h(oQ8J2QQQ(dFh1(HBv13Z57aAvrQ)Z5vohqIQJQENysFvHK(6fB)NIHy9YnCR8)dYbW6ykoLjKO)ejSNWyLWGVBzT6nb3nEk7UCWz2qfPDHRS6sw6kwM90mK16jRRPZRXOl0tV8w1BW9DWFkvOEx9naFylsyt)onkgtmb5yH)GeUeppCtYK5yh(boCsqD0jEAK)kyzA5hgrZstgube9AwQ2MAzhlXu302mtpm0KTurIdEPj0SfWAHKrM69SWt(msZg(ZeROaxAPOBG98dxQRzAWt7dRtfMoVZZrA9SvmK5nYHJBlRW7kcg3Y2YM3QcEDpf(wJ5z1un5icg3uZKxCbGQPILcpl8iWryABXZpIQGLMbpZfxZW5QY3vvDBB0CPwyi7K6(zA0Mu3BwUIfLqcHX(sMf7RJDmoOlc9QFd8gFZJe9ilIeohSUyGgSjWzMgWwoH49F)p)BwN()Risa6pGO9RHQDbzv8Gty8Doa8RaqgfLSAvWgFSb8ykmfcCie6Sz0PyHr)qS0iVszjlTB(ZUiEVpqJz(0apOMj2e3S1HtZc)LIPbZGtYSo0p5gV8lGsDlXJ3qd)(9Kjb4Lz8g(3AN(ZPUzVkMqxOQD)QNh0pL6MzS6IpZOHc3tQu8DZdlazBux(DHiKz(Z7w0NwZ3nVDJMVzEHEbK2aMhqM(4CExAzpWdeRsnUKCLHpTrfTFmGf5H2vjrlMCxzJ2h5Y92S1IB1ktcwgnIIYPYrk)Q8ZWivQtvJUpfXHMCUqsPlzroCBybzObl6wPIBEsIz6eOpncLoDgYw6hss49odKga1ESNwYWRhSoYhP9xXDpXvRYFMO2(nNIhQ3pbuofdDnvR2CYFOWwkU0pb2WRPKGKfszm(2zRTACOz1IBTtrTd0uCk7mrAkRBllFqz8)dxZVRGeP8)R8h7WvS1lkCALFEVdY)c8gKdXOEoKgto0PJFymnctRX84T6hrfzczYgEn2bsDBRcD)GfamT061t3Sh0ceEW33QuvVmiiHT6GPMAmbx7xkZJi9cUFshiWgNZHdSBy3fSLqL13mJwNotJOG1IxTkH(CYAWfYpC2ASJQzySlP8z1oHUWV8iVvDBvkTa2umOEcyyUQYWCFHylRAC258n9gSqBLg8LViur(8RV5IpFXTxm6(l)L(3EXdF6Mo9NUWhkxUKgM0PFaW76Cva7PV(vu5ajC2v0KFfpoTu7)QUSWGxZpbkmQkoARjLUnmB8VJJPll)Edf1I4jl53RAy(hcMPM1OZGy5bbGN5wo9xQv)HdBDuRAye5Ppq2qJKAD3NV4x(q)FdXI1rT2pY8XojKAnLIMRw5AkQA5JCuIb6nc838eks5ELpsIGmn4iXsnKgQ6rx3(W7W1(EuPDuxOGYXPrc)ktlwpjJ7TGf4v)xjqywXzpUn6HJi5mUDFtKBxJpwg)FncePM1S3vlUm)vr4O0Es)UlxXc2tnTmGw9U30n6fEKMQaCmESJXLKNjygXJEt4lJ8fALuAxoiKq3)dF86(idxP5kJ1(HAEFzaC7gbYDRtEdqI6XIeEj6dypjyA0LWjakFu28mU1FKInq0flHSTgvR8IyXGgqDTF7G9mLYhr)EMt5Zb)DO5oiMk8PCH9a6EM)b(L8Y0xLNslweUT3HHB9kVkIy2UlAZYPM8grCJzz)0mpXW8LHu8xzem0VpIgWicC(mskpTCz)Dsh2f3UUea21PiIxHsg)i33(6uYgOoDVdo5i0GEqP3LtMoih44eQqVYhM6DCISKHTxzwnR8wzvEl7XuSpm5Shc04)3p",
		Enabled = GetExpansionLevel() ~= 10,
		OverrideTriggers = "merge",
	}--

	PlaterScriptLibrary ["Cast - Glowing [P]"] = {
		Revision = 10,
		ScriptType = "script",
		String = "vRXAVPTs2)lSFbUTqTn2y7k1RukztBUBlbjZE3vkjUmbpaw14bn2CBtxT8BFpNXJn2GFrE8HTO0yMZmN3phhxv3zUoSTX(SWi4XjIVp7XTu3jAUoFL8t43kUoxsJw46mHs92pNSF(740agXd2GFO7edxNR4KfioCFW15pjb7GJB668pOp66erxTHgghDXg2UWyxNRxaBZ56WykFjzb9Ul88Ujm6UPbeyL783qwrJUlHJ(w4Unpq5aHjBOUojyy)C2Y9ZDKy1ngz0mEwnDVoBj8VVF(ywaJNYscX7kRrQwJmgQROBmCKUPL7Y(gdrKaaNmeGBROQnuttrFKLHM6ijCDeECQmHyxI7ZrEwKCKeTjY6dlH1)ua7hLY5MMdnmS1hzORyQoY0iJZbiMk2QMkk6k2kAJSri6i2rzQaNVcq(lbJRFGXntz8XKOyjJVF(dpcgPT0GGRVSGui(pNHwgG2x4JTHWzaJiTJiqvBltdLeG(EH(Rwh)aEEP(sC(rkwYTe4VHMYriinvntlDbipkDB03Fm9WgP7qX02QC8pkJfSvgk0ToRybEiiZ8G0laYkdXk2GYhbX4KWvcuANYY26gQAcG(HE(RyiqvLmOMwwQLX1Qz6m7rkAjS93xt(Upam1QUa08pbRAGFuCQr96WikhmFXRPsd3(5xF5(5(HY1Iz7NdedI)dtscSiXqhc2ECBiCXgtm2cMlMT4VO8imXaiQW)aEN45HCycdbQtHafJEsorl4(BHJjTYtgAoAKUqvdpour1u4sp0AKPvIF9qlDlTHOLf2GgeEGwWjPox42T1gABHwiydqWZi0EaBWuf3RkQnvsS0Qi9KEvcZK0nsf9cKomQ43LEgQgYNX1qpzPTxWKstTkswPHvfPBQfubzhD9HkOsslnYP)(5ySVF4Q9ZVD69UognAird)3EGW)ggx76GXaagHiYzu(cFgKnEeKlCnMqbSyE(lxs5umhkjeWa6eSF(s0kkSCleSbGUbGDr31z5UWfj7PBeny5B3pFxOF81EYhGK(BOWZ0W)Ag5Ha8XelO4B92)h7Nl)K9K)sjUgSynjmKgacBpb1dZTD5honEhpm)XPGRxjynGTGeKW(FKacZhYXFdsxnhssy3ui)lFV41Idjx49FIglwSBozqcBGOWY7DOX)jeUq)PiQR7L0yIFqKGG)GbWNs4rubSOU50jdGGZL(RgCO(rVE1iqa(bna1jg0elwJ1ElizlPbxKAghCYEZq2XqEp6pKx0oDdppPlRgtVgiYfXbKOUD(3tbflkj9VrK1CghixN6o74akCIGGPmiVtutYIyxD7WXe9DE7rMs47DwqXOmeKc(tdO7ZuerDZ5SixPjX9JbG)7xzE0UDU4YlbbCEdQNGTRjDvgy0aEVKt(Xxips5D7WG0TbKhrrXSuplrWUVWrsTy8AMVzH(1WZ4Xon2SOhADoMZs2s0T(3FkA63xIHNRpxm6ZCAevrT2Xeb1az)u)XGIKe4zi3Rx3y(oAj7UsLK0tzkJNKmT0mnVRztrlOyoo2X)x0Ufj9BmEBbsxIFBzIEPUxJ6Do8t1bSfQmGoMFOfELvwYOe2VIOFmUpBTJd7ZkveerphIeqxEmnsxQRFF1E)wr7bSSwzuTqvU2yRLzkQXo(zFiTZ5yYgeb(UcKFd3dS91eFCyRxIriGGDusRk3Vd(WvC2g4aA1heE0HMXsIEBhDUbS0(HDB2GxzmSNuYM5VjjB3jjOG4Pps)LpLN4laUYVRfEYiFieDLbkQIFvwG1rmHGbipe1npx1V8JwT2HGonTZaNT1CgyfJ2Ca042O35HTpJLw0t)8LfTZqy0kinP6XEyfjqp2Md7et4qzbiDyUJ3IZLtJmWOvNitP0RXoHZ6TD8oo2O)SC1NvlzBta4tHrfOjv6XDPOGp1gF36AfFxumBJ8QakpJE2mR3gZII5WGaDZyRVjV5GE5AzizWNbG(yCssuXHVIXDe4oDcfS48BpIbWFQGdsXtUXyaTCI2TIpWSrgfNnQ0HE633xos9cOLV9ZxdtELxJLrdxhy0qdDyOnlCustndvDvBfGmdF1gbR8E1KZ23qJCvw89LQ3Yx4Emli4sK1ydeTU(zD1SlSyfrSpzZXXtcuPi9IomzzkZMzHkNEPk16PAUAdjLHLAVgXlN3Ll8A1YFr8M04(XOnTD(YKIQ8W(q1GWO5)Z)TsF2qw8Z33ST(F5L0XCkujqgY3n0paBZo3KjjRy0RDHE1jgnMXRHZjy7cQWkBK5OCNAkIuJqrKnKFc5bY9Mps9qGThj245K)880HJQjHxlYeJemJ4v85poFiznibe9tC2UT5ju(vf3Rz6aOcboJpf7OU85sDhPWbQGqvIKINoPvUR8djbj9ZLCpcNT8Fkw)cJTf7FQZKBM83707zOuf8O0R42BpC5ZJV5RF9Mj3LDtD3FFV2IRXmg3dNVZ2wjzohf1JEqx1WUD47KRq7z4)iMomzuQIA0J8v62Xz8fFPw96jdCoJWxrJp0TXZXnh9vAfBEXxM(5lAdBEyCRxy2u7vGp1AfJ2MwTkT77Z5d0IH6))8wrouERSX9Ac)VSVZLQE1grTPR(kfUdZlIJeMnh7VxVedfvPuowCahjdNvKTzlbRr9dF8fbb1(QSj6W8Zl)KNwUPRZi62kMJ)(tE3nT(KhQx9(P4DwuAmuz3kWhQcWBosDudcl52iQe2BkCtfvRRk6bCcfas83IBQ)TgLCBRYVu46j(V)YqBB7NwEUuFvgFdjW)xuVsTLfJzExIV8RZBGuIST4fJ2Qlp9ewp9kBXEgo6EIR5n(vZ1Xl5LFRIxh8XxpC2tIS0ZwZzXXb0)5wpOYMqIueLuGcekj)124()c",
		Enabled = GetExpansionLevel() ~= 10,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary ["Cast - Big Alert"] = {
		Revision = 14,
		ScriptType = "script",
		String = "vNvBZjoos4)l8LHutG12GXqQkFGqEJDtiPIZmBD3KXbHTa8ngzozBYWD1XV9RBzjJbSHKjzVQUIDMXwwQF9rpDlTo6op6yhop2pKfbpoq8(JlNtDg0YX(pOlvFv3X(RKGeyCnh7bKzuh7ZciSFSA4n(m4L(UHm4VzXu(yIl9PUEE3XIE6(acmYt(ZitOrpLkQNhHl0X(CAKRJTtSZaJ1A1CdTAO0Q998qVexA0QHKvdzHXKrb0vdPJhtDJxn0NTAy8uyaxse86icF1WxMszIzhnNgeSA4yE4m5S(0JC)jtO8OpbFnMWJbXghMU66k37oHfSAOXBZ5ciJOb5DUgL5CnYCUlqjlTnP1YaBy1WqUCG(NdVmwof70PK50G5SAO0LaNp8NGBZGHM6dXIkWxRSJt14D6unldN0SuCI9CqlVtGI5A12uQ2KiApiTbP8EHbHCL6ptP9EceXziIqmHvdVGHGhV3OPegMfa(tbYIMkMJbyZucBccn3gc6Ik8y0WBT2W1LgUBbwTyhi(FgoxAzzP1r3stRPwhnJwDCgxZSjcNGil49WSIlZhFBUMB6ss9nzmkdRL5n1r3WQS0U1FL0dTxRvyZ4TKFkcI5Zf5mv1(ze7poGenD1qozUVxWsitr8(hj4KMg(c8vX8ZMhnQ(QHcNageeWm)Ga)iky4ErW(NB9zGZvxd2dFjN4IwkcYuED9Mk)(YuLEEcNiM0BY3zjZgr5YqRWSYKdei6uqGqtfj6ZC5usur4WPu)jtXxwIFdDUfPepPovopAuMhzwa46APCUn07D4wOHbIlvyOBb(WBobFSymo9tPveIMrqkXOPKFqZXmISOZrd6yLJhrJJ9ztIWnNSyEyqKeneeYMKIgIbzKlJRxsc3qfGStv6hqcxy(5t466fLXZs5xJgEe4fctxL4fsrz)BBLDNnpWpoXJM5jT3m9)(m(1IhTEJDT(2BA8P7bxB2W2UWfRJ(6Bz9xYP)ZekZDzM13u7J08xlFeyAhh6Ua6safng210aVG45HAivGo2cUA7y0hTJC5(ZHL1qYJ3OtRwG9btyqdldRMneS3nSSA0UJGchMqBiib71g0OD7gDmqAv4rRoMMizl8ylZMTWCeUmtTgihamAZ2ATf7BWzOz0uGuWf2s3ue3fpRbRuhwIHHjcAgOdZZqxVPgwJXm9zlC8w4ZMnBaZvh0QEhdZw4ZOo60UJzh8FX1y0ghZaxJzlllX6q3OTbQlddC8gMO9y0q4EAwO(tDvnXArFTPPbekhy0s4wDmXyKLiizaRdIGgkANAaZJpaU7gq5WRFlnS)DhBZdMKr2INb6VNd5y5zhBSNfq2qPQhPCx)WWA2ldwqyKih7wsEBGN4SWeMlv2c1duVS(geO0EPKxyBwCpAwBMYMnH)4pBEipMWIv8v4(YPK5ZPmG3PUSBTO92c3yFAGhShasy2JbRjTNTQr0GXGbMW8J77jFaW(Zq2nkBXJy)iWJPWqXBhT63xnu(l7PA1ae8NalJ(tQBsm2MjdluehhqNWbV3ls69eo0Kt06v6dDfufA(E1W0qD9(r2a5j4xYWYJ0O4JeUelNMZVA5c)7HmAFgqLdHAKGy1Wtpf6vvOWkP99U)zoFX8x18yWWvk1Ku)404eEbFNcrHFVWxYhoHkmlZA2GWa8N48u5xzAYP(Ljbbqysa1obm8LvljdLTc3eoetIvvEpnxwVUSq6jxrLFVmPXH0si3hRsiqBE0XKKaSwQ))IQsPi1NphX7r(InayTqsa0tH3s8ROiYxBDQVhvb2oAlmsM5FhaP9zKGu7R08aISpXMM5MLlGdNn8L9bTBBqcVnBMbHUKG19gDQ0kkmywI5iwLuafyl74vkD95CsSx(UHaAGctHsmoil50ptW(ijMued6WFQBO(lOL0cLvg(raafpjRUUoQVE0squqBuQ4Bzhyi9i1Ee(pW9PifmOHqwWYumIlswosaOaxJNmpMM33Rvl1NbiyckhPc9JY0Oq6kGC2H9z0x2PrrwiooISX1ai51YArA)(eyG7yxdi6676TBIOFUhH1xzY7NRlhrCDOTKX(tQV1PvpiXKcczhtItIoJKLYtJoNCpHdsehlkVrUHoo6xJxBhmNqAxgYTfULc0DyNS4j5U5muMEH4Tm)6mI7pslrDik0DyjRBphGIR3owDV8OBiZ0auj)GQ0MBwLUWYViVuKOhg3qK3ep7Yw6WXg7XsVdu0hB8QLLMHwJwqpF2qtC)f0hW7RA(VExe)FE)afGo9EviWIlW985PCy7uGBd624W5z8RZOCI64sfWQdNAz(VeREXDPGIRWsHBVxC7j()S9IW(dJpU9h1QjzMYk0unT4Ybkyvi3BABf7N8R4mUSBsp5LbStBl9UBWL9V65Z627pU6H7(YGZF(YB6AF9ZN)Lh6(y)7guMM34oLkw1e8SiBuEelBwYDkvS)NVHM9fdYMxXwc2ihYSquxuGQh7rHl2T)U9dKfMrjFjhTrpHkLJRqs41(j7VQYlt9JrgKdzWBUpD44StqMDNufzW523EQYMorAt53tNhsxqSDJlsAptj76A2ZCYUtKJXSqqen3)QjJkYaKwD8fzKe2bFFiSxjkV5E0HdCX0FcKVsuxsKk2rYY(JOt9zELN(L7qgb8txTMF6rLy3oU2hVUG156V9TC3RqVR7FXxV42lg84Lp092lE6l9R11DQpDbDgCOSAIBLO2vbHV89VF86Zp8N(EXtRE0NBPD8UhQ4ZM4OvgLXEwbE9FJJ1ut73m1nuHvlTFZWS1)jxaRypcPrpla4fVv0yr1kDp)CuMwVQvEoN8YnKLuE1k391lE4MU)Tx)AfPxuJUumKvr6TO7jh5WIb75U6bafIeD25QbQNKrPOJPHbkCW2N(gnfbSLE4sxBsnSZhxZoirmDvk5A0qQwSNDCEFr9tvKQ6rL37rzXBO1SQf3k)XFOkANmsrT58AYyVNus9XepO9T9MzYMt5jO8D)S1QruA3BU)6UvKCyhQI6VP2zw3Y8OxThi2JjjIREyv8Mo(Jqf3LeF4OKysV)WKXRnmjQjC0B3t(iIw5U8SsoU4(MISl2DK6R)Pn6qf6nv)J8SBzcheSw6)pGD(Vp",
		Enabled = GetExpansionLevel() ~= 10,
		OverrideTriggers = "merge",
	}--

	PlaterScriptLibrary ["Explosion Affix M+"] = {
		Revision = 14,
		ScriptType = "script",
		String = "DJv3YPnYs43fFfEtqRKaXpUQ9cWeFSZUg7kYzpNTSJcdOrG2i0OsseBYf6nBR9rAFf2UhPrAema2bNBo4KcHMP7(R7P)6PNXXW5ohBwuQplmbECm)33ToI6m20X(AYtoJ74ypIMmZX(QWzXuscnjBs6cA2KzKK0SjtjXztwq9NVa)XACmFygFLeSIcAWp0zSUJ9Vsx7yJcmKeFjFYo2)oFkJB5yFrmzgcbNPGvMbFd2kLg7rMrFyGR7nHjpCBabEZd(ljZPjpKJ4phUA5uASJ9yYsWwNZXZqepxwGNRzUoPORu6vg1XY5SawSakC)h)NPZfwMDAP3s3WYSBxDtZUoEnTAHGf8MXTXzLQWUfQ7L4dZYfjpeF(cs4Cvby(SGxZeXxwivdDTwvUwNcxlxXDldW6cGEdFGSjDFziCAaj8lceI2SDLnTQzZocBApioM94zcdl(1lXQbKP0azRAvz12fwnzb7rUUf2DOWI2Wiztkg7f5SmwPvZvcbIyeurWxtzFLwS4ec2jc1q2eeg(HZ3EvlkMnpMMKWxP6Sn1YqyPbf6piAbrBdwd32dWrkxrnKOmdpgktHDZ1oGXUkWO5gG8)67MUqaY21jVf4R3g6NlY3hoRcb5kjf1(HbzEbajuwPNnk)071Q8tnlJ4S)UOMgT2n3eh7OiNg67IDIbPc65igKIoieufoqjpDRxFuewdJTl76Ys3DjxR2wD0713YSVrV(DAVNsUCGESfBh4(NRqQAoRnValZR43UOfiIqbNaByQiXtxOnoK(FztUXZlHMwK410qWIFs8(If(21Cfj5(EsaLsGrC26G48puHtfe5wfOF9XGoj)SYUioBxJGSbpONmhrolU3XsqSQrqYn74QQ51YpvmGmw6ESuKoBVP2QeAPrRHLPLnCW7siBY2y77DNUDQreJDRrJ3F8sMp3PtB9o6g9B32c(y0h5ZwBYN5U8ckjiDrv7yF3u6l5kQwZyyQMDkB2xPXjyYnqfGpaVG46IwjxPo2CmBNIUPDYSy)iqSwf(JzB92T7GtyCREwTA1N7fg97P3Tl3vmn0n7yG5tJBbLWS6Igfu37EkkGLWtOh455)e0r6BYMCFUn)KJTfkAxllDGOHSbqkiLAiB5uI7)83)fR5GVftcqyceKbrrbq)1juWvibsvNG2bFCbnSOYfTYMS4PI(rssjXP8(gbbbySgAJCw2KrRG1D8Dp6JXTnXlewG0sVvHZYzLnsObEVnBYQq)0RClEaQBSKcptd)6DKPb4J5bq(Von79ztY)tmbnOlQ4aYA7is8xod7YQH0SQEYhkg3OuiBrZENYD0qjj2u)PSO8wo3u30qxvgkF9q7IasYIYm7HSyxkKg1q2h110To9zkU76ne(KtY1qxlLUBj8twsccGtOeqR2lgSXA1rPMn9loyMIot9)gTAMbSzyEt54Itj9lLUG7unONvpFae8zaSRqp)5A0q6Y1HrZ0YzQFgSiMJcYEV5NQmqPZQvYOpZMMkStJTS8BK86YiNna68Dj2FysolsBrLVOYkw7vtWM9LrA5Wbg0hjnwdfoiSKAwpJxRiOj61r9OfneOEW17X)lWgexpx6mSxWIT56rqrtJxrvRC5J(krB3nfuHo2AtQdtkRpF5W8)HMhOgU(2yFwSF66A0gfMV(ggNUTvl08iA4A(uY3GRMAXa0gLgQRK3NxTq6pOCOv9YHkRZHmYeACk2vPlfVDKyQCWTuVo2WojW(jo29WEb6QBQBa7VaMP1Rxvxr(cuu8zKlRKt885HNDPVlTHQA(L1K3CgBH0pq9GdnVyZ8Lka)YREIo))Vv9CFHW9L37rcsWqOuwiEYWxR0n5qlucl1pCEIIvjfv75HYDxVQioSTQkBmyxkO8AIui8GYBxzxsxD)lQDsm7jT8o7sqwq(f1LWV(iP7esCDqqz1WeFxrg3IIMwXRmA)Sloe3XiifjF1)SZ5i6kSnzzAtvA1H7jJMomasqUMx)QXjdgn6KdjK2J4f0WHOrNxW21To4KjLlpA9p0CtPpLUck3IZ((7pWri4lwT(0N2B9erHR6b)Q3ESb(QMvFMbDHasb8DL2YVZS9PcP1HDPJDY7kvs16JkA1EeCxlwd)4D3DZy7h4ZQ5i2JHn)yK6LjOidwQx60qpVTeQdxLtyRf2YXUC10dU(Qws5d0OWO4HeSpFWV9o8KcgItlu8m))A69k(6v1wMkSLUwFRIVovvG)5CELdnTT3yERMU4Bqz8JzdQvrU8D651HJOXZOHPpJAJ3Y8dXDKpjG6LEYBvV1n0vlN(HrHFsET4ZyF73wySj)meS11pTzFmuF6ZQsunimLLMYwUhGGRZGKVEqfcCztAJjnzt2rC1JbIuULiFziFpX4vIRPqe6jjylj42JeHaZb0bVebzmoNsfJR7A3TigC5a6hluaWJ1)XC0LQtAvxGgQY302uPh6shk6Ne6Z2oIsD5oczAIuWF0Q4cICtj785pqxs8dH(QUZh7fgpERHM1bowROw7vHEmTe0GxVki1pkWNMFwSsCuNbcCp98RQZ5F)",
		Enabled = GetExpansionLevel() ~= 10,
		OverrideTriggers = "merge",
	}--

	PlaterScriptLibrary ["Cast - Quick Flash"] = {
		Revision = 2,
		ScriptType = "script",
		String = "TN122Pnsw0)fEj4vaI4UTxl)axm20TV1rKK10XrwfsfG6iurkjzhMz16BVpNsLKkajWo2Z80esSHs1L9(CzFofXOUXedD2QahMNp82BeFEY6vuJB6yO)701jpTUH(NjUHW4Ag63qwsn077s8(EK5voEWhgBX8GF6fq5Ziw077zBFRN)935sGrU3zjzo1)(4T6HP4cn0hs9Tm0ncmUPr2P2EJtTrYPQFhNzhAr9JmjrMESaYuxAK50WGiZzeF4N0zZOwWVD8ImdwapZsm8ucpY8PfupXc9xrDDHvWzlLZ6Dt4oZNt5(VdEAaHhaNqalE11sy6TcWez24LXtxYuQRkpBwepBMYZZXDwInjA9amezY4Ybgpe(Wm5u0JNskPb4ezkPeqE2pbA7bdTWbSfLGNwAhs18vsQwffY0QWqg9vWP8kJzANDSTKhBOpDa42ax(aMlJNC89to9bIiI(yeHycrMN7HXr2VqOWyPgGViISOXBtfiSzbXBogLUDiOfEGvqG3jd41LahNx)TqTize)BdJrD72v7K6D10APDIwJoNymRA7wy4eyzb2dZkOio(YOMv8sI5M0gLgRLYMAin6wKBV7)nvkoo7uHKXRj)uyev9fkqnjFgJ9N5s8xezYjRCSDxdEkI9FfItAb7PejK05r9RfzkibmiSblDCDD8PaWT9H8NRD8aYvtljhwSMHHCcI5m2xdq4ioXsmA)xgX9cxoLYtSFJIbF6ragItYXqOLyjg7zXPe)8IdxqDMVa)WA8zi5Emw4jMuBgqEPyYQ(Zu(m91WhLG0lL45AMnslGdVyhCfXyC67Ilo4VKGsI(liFNQOmIQORqOvjH4(0GahV5(yYPxaN56lJgCzEZJJgcG9qXJNKVk27CC41FRC46XGx1HxV(UwMgAPU8lrG7dSqa9ehVaOj4VUMk87TCLRtqOnnf)nAV1XRmLFfQOeRG4VXU4)4nHFCwygWHep2Jz2)nS(J40Fes9SwNc)MABbFLP8QHpKeeWSEe6tahbmLWFawqSTXnoEFm0fQ16bih19T4oRGL1uQK38KgDAPHtaEB3Jp(yCpBKKlunY8pcDSarszU(xV7Bg6TpiMX8GhGe7h(bUAHquTG5edDSQmCaGy8ek3YHXQQV29rIhX3qVJaXRfzlaLwNy5LAKpLBAgWoOo7SqpR42gk7tDNb5sHEobJTLVbSzlXemQ3JtWsIWBJTdIpDu0VfzkFL(UQvbt47Wg4(j1kma70Xd1QccCPZ5SqqYv2ddHd1z9ZwPduyQCS5O2FY8OJ9aG6zrXySiZZodA4rSKsXnpT)zU6XvLosWApfukFXPbHCLXPaCYLkReMvPDK4bojrN1QRm2WuBuORliak82NIEJYfyDsxHvihytqIG5zkw8As96tVGkFEr7gN6hW4oOiHWbBtNrcDrFSZ)g(yzOZAKUq0eNAJJcwPyPqIlusXEn(uCluLwx4yttC0hTL)jf(3cnL64rCJXxHMAmQ6uDAknlEdoS3WrwgC3QGc2MotxMfXnR04zsuKRXSa4iwLCdYbl7WQKZ69k74a1IUq2EUUqzumSxYP3NXTPCzVAjjL1H)vRrYp0Q1k39kn(reakENu6mZQNn6ZdocGmIX1frdj4rreOgifpZzETTAwp)jP2ySISsUqjfY9jwFpw54qzx7KavdUzc)7zEQY7nfBJ9mokmNxGWz7nfoZvredx9P8aSBemDc7OzR93q)eOM5XGM(XqjLoDoPzJwnpgklwV5)xzotlyhIShhE(snpmmwwChPgvJdOcUkvzzjLts6AjN8lO5Hv)s5x5xVa3UCfL2o0F7j()KqFiESXBx8y1QwXYeY7qd7xCdkwemAuuhcIE4HRcO25ztuvzIf3ZxNjDo56TL10TLDKVtXJb3EZOXx8q)Ed(9l(4TF6MHpm6QE6x(WWp9XEtgF7nfDYBC3X8pAc(D6OCxT4VGQcUyx(8xTSY(SbPZlFKGLtrDaYwDmsMc9PVdK2FqSagf8efrHbIJuoEsKeE3BzvUspTWjGw6Odc4nZrnNX4BFXW8aSso7zjy6ujMuZNvdPZX2UXfg3ZusVX1EMt61AQGEbxFQYV1KwfPbcUrALuljK9EhdYv8vH7rh2Wfq)jOXkJ6c9tSDKuV)u6chp7ID)YmKPG20fzAtts22TTRJXB2K5R)6xvUc0GlhF(Np)6ZVzYOp276ZV)tJR2ZAHd9r6sO14Q9CHcOvVWL903(wLSU4(IJDWIYh9(oAv2T1U33ghT00uLZsWh)p4yT00(q76nsmRD1(qJ2D(Bfdw(mcLq77cAIxlQJxUuVHdl9Sw1qo5PRiRP8YLU9ZN)XR69VqS09zTwHRfpnlkAUkjzksn5ihEBUe6JV8bcieo50B2aYoHtJJmwWCtIb2((piueHS0dxYAtzHDEyMYGmAPxYHCjcKY5ZSkB0nG8vsbQny8wVkYEVG9uEldC6vEtpOD8i5DLNNJh714sQnJydnMTxpt6Ck2bP21ZwRgJs7D1Dx2RKu)6qvt)qswzTUTp6zZaroMueU8HpIx0TmehXTHbh2kjM0R3m145AMe1do6LZK3cRLYxFrb3kBFtr296E6N)qVlTZuON06VL3rsDJ1I)pGX4Fc",
		Enabled = GetExpansionLevel() ~= 10,
		OverrideTriggers = "merge",
	}

	PlaterScriptLibrary ["Cast - Circular Swipe"] = {
		Revision = 4,
		ScriptType = "script",
		String = "1I1xZTjsm8Vl5j8m1E4p2yCM5EinTDQ7DNBMdp9LMs8gyDmtiGNDXnn5b(SFs7UagdydUPLAN1WkPF6N0kjBpdVLEUjBtdtI5WYfIpV8LTuVfMEU)l5xEl0hz55(bk33Z9)ssj4wZw9HDmXkypHX4Em8CxqEI28E(gjAhvSRjEUFIr8f3(9EUZ9XhppoLYwt8P3EvqWxJ53EtebUZTHprEGYVvcV7I3909uMN7FtFXZLPSsHnsraxGDB12KIoPeb5O8RBLyCs)WW9rK4hZzd0Mw15lJrtY3XvXG4sd5MsyP15TQ0rbpzLJZJPHZM8iGsfABF2BCdEsUFSK(R0DmA2QRI2UHKT65nuaqPBG7qkbixcWTrKxcJF4D4gc5zRORxt9H7hgJVsPXb0a4zjzR8jP(Bu6bLIYa9Lc74KmKHYtsLat4mcSDESIKRl8sftlviqntQKyvlbQm3QAo3VvILDtjwM1ciU(KiAXHq76UI85fjwoVrN)YjEH6b4oTZzpLX1dGQ6PLr43sGwelDkb6bjrxNeLWYTVOui(FtX7wI3hJVNwd4kb7de9LICa)ivukAI0e)FszC07xyOd)dyvsqaAbPc9CfGZnfDfxUplCliMLc4wotMzylqVLJTUTLWfSCCCmnf(H1ulDNPyQ9cRztN6mbZ4alz7ypgJMlmMzzBRJ8fS0Xe1WmudtNzOJBevH(uBui0EtNagewlm4yll8(GiM6ZgRJ02yXARPO6aBzAawh(lIrRz266OStfyXzgyhdhbWbLIMhxBozYeKyax(AchoDoe4RqMFeM5K8XSvF)MF45o5KbaFqMDre2D8NdrMdl7bQDQN773LsE91DrdHmGag5XhPazBl47xG6svk1Txbq(wAu0Ev544gHABk7OqhHLSloqjIp4au2iieo2ZD9UyFPs140O1qzZDXHPZdulGdbprH104FUKCFeUugSfFAq2xYwPUkwLV1rxZOGR7IoQkh7Q4GIokCTc93OAIsGd3zRudhKT6VQy5rq2(6WhoIGqr0hOPIkeTi8O9RI0KMgoueLYwXkgQiq1YQ(Ml8MrycIWRl81r5tLCPlTORNwdi6W5kgCuyLMFYLtttHEE8JIgvmaHW3OmqwX5Dnz(5L3qyCzniUw7uLyddg0v7iywT9IeDwsrbZJaeXZhuLxAs3IEPhemeYEQirTHug0B1)jwYtNYpkhDO)6FzshzPEZqIy1FogQq9Iflt2pd5Dvo5EcS)X4GtICyQ)bDt265fvLTYjWkdB2qXpSSDv9VF9UAAm7lWGPWhHlOUm0hjBE289RnxTO7C8A4WWyofHHFsaufydLrZFM8VsDo3Zf7Jzd9UW(F2t1hB6Od91CHEKVznak8Cy4HTT75v8tZ)e9Fk1yhdgL6OdLM2K8Sw3ePWwxIM)4c1WPKAsjjUU4UNic0omQDMOvOF9DldFcgI4Q1qZd4CIPX7kHstc0lcdDGZuj5bQphgqBsfalEwC6znmJ6kCnKD3owhiMllUD3LrHTf3OV0Gq1UJAGi(EMumrubIUu6CQNPfhgbbZlsGVbae9VObhIFq36Cj)(3714V)4hDq33KaFRDTl8POMVaaMo(Qdc6g(kvZEmSB7XNA7TLT0NAdYPm3)gDqDdhwoBz5a(9Q8IWUQP4KbYIh95D3RXRKP1Vcxal(pjjBHoCAxWOBbDFrpvXOYFpUwrP2XuaMjMtry03q9YYwFq3iyrRASjD3i4gkf3dgUsvqEdDooOaupg5RBmydIJuib1qo)bLRvNJm6nuk)cvNlu4OgQcfJrwLVlH1jdSnfQxhghY3G)(EDkuxRDx)c0Y6KTeUvvuoz4ULXq7gdxt4wc1gTuY8Kts)BaJMcZ5VYd3T3jUykXJDbtqAuFs5ZAkY(oqT4xHYl1Z7)d",
		Enabled = GetExpansionLevel() ~= 10,
		OverrideTriggers = "merge",
	}

	-------------------------------------
	--hooks

	PlaterScriptLibrary ["Aura Reorder"] = {
		Revision = 3,
		ScriptType = "hook",
		String = "9Av3oTnmu43fUIkbvjzWyDABsmHyQirhcxTDbftCJDsTWXoY2bOmT8SVJJtPbAAHjqqKqhF835)p7ACiEmgfIrhwQjvXNZuAktxfFXzcILPVeJSZlyy0mL6Am6dy0diMwMMAQIjsAvmL1SkvjeQB5YSQy7mwvSHzTWktTuvmx2OprjnwDzIvP7Jrry0qjeTuscBYHu6pLMj(4pHNtYyMjCWGRiqkEL2hFmAF8OWd2lmyquWN2hJ2dJoIBjuLE3dVxtekjgDaabJ(iE0ErW2dCv6qj3Yjc(9el3bjTuM4KQI3oxrhtMky9QoPkU57bjHkHiGQqPTFF(yEoudFfQfDjBfmC5nmTfbixpgzrcIvq0qnspwRYHQDURPUc(Ls7U7TZ4jZGoo0gGgAMI5A4CTXUdO0y4zqvaZWBicWdXBtKZHavMpLP7biMYZYCHOz7wMVs2vO5kn3oVoF(tRKP57IT(fjVGR5jvXJvLjZ26YAO7hStxGrZGXYTvX)gMCFUk(mcx2yquuNgCk3rQog6jlCCNWoJBSkiDbYPDZzWPe91mQJEcnGJye7ImEWGoX)dIwRSSfG6o8Nxwyl1paAn1opJdPOkTUEYzDLN)T7Xnuy1COLuuqfvbZufO1667lH7pU0NoTFHwLYfS(1NwmDZc7sAzyA8L7gHHUdQU044LNtCooChppmQ3Qf9csuyDGxWLUO2S(OcMqmKcDb3OORnhbDPMT9AbAGQ0ousz35vhU(ygTAmJ2umJ6mMrVOyUQgE66pzdx7j7WhTS0xTdnTTQ(2165TpVE8UB2Nl(0mGMcdUuIWWwpCgSBDbSiADMlV(04jmXNMfqqo5fPS72F7lORt4AA4x9uJNFg0(U7)VYYFSO)rW)9NtCbnOjjg08xBA95SC4Iq4hh9jRBJGEvXFRXvrVyxfTgxTXj97FH9L3HcRtYZgR2x3q3rU(sn36nQz7C43Egh(SNqEmIt8lFd(Wwm6tUhrzjcM0csGImTQSWlMiGxH4fZjfxXPnl0kbZlvCtrBBnfSKgiWl)8smzIQ09yWL2tst53vlclSQeyAzCpEBuyyqyqaaGsDVLZ)7wyKQWXUmnwG)h",
		Enabled = false,
	}

	PlaterScriptLibrary ["Hide Neutral Units"] = {
		Revision = 1,
		ScriptType = "hook",
		String = "TJvBVPTpq8Vl9vdPbATL2v2uFbJXePQkDcOAs)NMBCtUqSAWok2bgvt5Z(ohNeEOeEyLPP)silahN7oF)U73DobYPKHe7tjd6X8GuhBirftdtDUNZuYuNV)1qQcI)bX(muQwTExRRArSpVqCEH4jAXFBQJmqmn1zAaWX5qi4Qap9YakSka)YvWLQ4exLigx2nMfPsD81xiIum8Mni2njdSEMnw4b1B)mAEbNyFbU9x080lF3LN1eDLlj2V)C8J21TVcHWafne4kCMImyuSijYm1nKkLMPJPrpW8YViwecMzrtIwuxze4AMr99z)0mf4UIeogiwWauxJbue7wAh4wGobbyhX4hP499t4UAaL68gmq4)wtmYYlFYxIPJbCoWNmK(yiul9MuhZG5J6uktdo(vwwqNs6d0CRE91ZvUr)UT7m06o7hS7E)W(TVTww0Mp3MLJxSs96rzP4uhAymq9ML6eq5EHzjmM8LkSI7HU2miUdLZfQ2kf19PQ388rmOsIxZ9bUx1(568C3aW9jJhHEQJGhotZJ0KVPI4qVkC(YW2DOcw87qf(wM4ouThyO8n(pbhSqYkL7cdNfHXJ0FHX8t446NSRy0z9OCFqNP4idAmUUasZV2gYgG1HwCdxCR(APw6IABmPMXiwmlxBlWi7cZk4GmybJ02Zd8EnLdhlm2BkZXcInwqKdRIlVv4(KNyk)n1(BNG2RcTLT58QRIbzWqA8iarthKxo6yr2XtFowSToiK9CNAkJ2K5e4TXRkP9wstv2UFiQg876HOBOvrOeoWNyVP(sRH6V9(plSX9HXIj)FOf0ELM2uiyj4FFKh(7bc(1RBE)PIoJ(motgasDLeAMSTsxtMZS5LUXnVG6pLHDrleSytnb4SLcaAOk4tuDnUFEl3fmO(15s0DMEulldFso(kzPYWPLSx29RmWVssTCN)GLuNk2LgchONtTYeAxEw8(1)gChpn94PP)RFxU95yOn(UCDM)p2CO6VjbLIXhjxCtRknIPjC3HpUgzx(XmEPGl1quJI1THRwULzOMvyLc4JeuLiRLiKt0m)XxR0uTuZ5HT)OEy5SyTk9M3XExu5ZmPE36XgfeIFuBLiSs78YWAL9q3ae3hkyU)QvzpHyx(RhH(0LECRnEmH(F8J87d",
		Enabled = false,
	}

	PlaterScriptLibrary ["Players Targetting Amount"] = {
		Revision = 4,
		ScriptType = "hook",
		String = "LR1wVTTnu4)l(LzJzN142CPnRpKMUv4IwVI6uShgMQOLOSfImPafTtChM(TVZHu3f1L4Kc0GvJMqkDi55Yhp3CSo26AR5hBT4tbK9uruS91eXkQ0NTk2MKol2(VG3lPI)2A(uG8xE6PNC(zwZFU1IfR53gBR(XgcBFSTG47cJPBwQ2oIGgBlZ3t5Ay(wMV0A(lSwm7B(B4U0jx(nbjGZSMFcS7N8IZNE25tNchWPW0ZHt8mKhNFoWRlKKaktcJKwlwj4Bd1dDcirr6HBiHF13nzIG4q1Jc3fwCTrHuh9iINN)D6HuMdFlde0cBapqVbah)sKb(aLSdKHR4BwsG37TL5i95Sy7Hr0aVXAPBMBYGFxq2qHXu2URjldOJIFFST(t6Jo6kctRgFDSThjiIEHbI0wIl3G83RwqLxtVdSldhma2rkZfwb8XAXC44crBvS9LUUu3hcdMpAYKBxtzkebl)a8r7lEiGzLNyAJCeuKsN1uNBas8sEEOcFPxJp(EL6l)eqchoJP1QFG7CJl)w2WrJulNvGNY4iZ744shTdjNvikvxSn3lfqgvFBnAtQ(WIMIHJUO(UuW8bwZEEkjw(IlwzwRVNDdjkYti6OeU4Z0n8DpwiJ7hZ0liFt45Ve6c)(rdrNbnbiRFOmboheWVnfqhP4qfnTcEMmbKaEDmpYmDG4RRqiGSB)fyLx65rDqNM67eaXAPS57eMULu9YWwLsSfPY2JJ6GCN1oCEaEze0hyKauusEolsk26i5ImDObgyjetWL6r2galwhfjLlIs2PcUuO7Ocybtp5zBIatyPfxHBq96uGguZ7l)PGGAc3wEzHlB7p(xMQFobfkqqCB5oQg2Dv25(6wE3pd7D9TQSLU6A(1A73mmc0osqZg6KpcQCRWW7n71PzysU1sqvg5QQ6egsFTibs1accE2kIFlmDBk2NDyC9QmEUxo5t)eWDqzsVMlAMUY2VzSpdP40PTj9tkhve2mF7gT7Yi9MLC3w54Au)e6UPabbv58preY9pASUA3mX7pqUU713RSI6AtA62J5WV3d4OrFSsKZAhILPVXBc92k9G0fpoQBnJp6rtvwIC1Kcze8BmviKhE(3fdGxnmzFd9)aZxSCYamUS(IBeh0h7UDtQrTQ8Q8q4wlWSyaVHReK9jOv7a)BuWy)0c5GCy2avqfLKMIlenqX0ITyXbribUaEcI6V1pWnn)kQetJjDrljr(oqAgj2nvghIesxZ53GS2JJr1LcvfkY5Gy7DeHpUGOxLtxsuauIVIhGScychWfe2k6Glms3c)VrvKD8uJwZesrquQdEGyqttVObIE7w404SoP7sbLrmM1CjYEdrkdOy5Xm3UP(pcPS)KlcmYMgW6LZsrTiqpakCkXznmUq(DzzlwSSrJjR1wC7QSnH5SoXq9p1Vye57QToNogzQJ1sfpmG6jvChmvp(5QXl5sjFJ(jVOWtITpP0mH)Q1ajNQEyYKZs38K5NNoVoBDN6vVqXt3HsQhMQvnY2Rtesr2(6K9Vgnnfr9)a9VUyvp8ECX7ILCjlO54dT)i5ASoOB9dcA0dDifn0MB5Kj3TfCOC0AkjqU(nerjxQ3phWkRNUmNxDLsc(azjnOyws5NdyKhmyCUpLXfCdzQVc699iWh)Lj3agAKjgNEfX0M0L8woewP30vNjGIQXcDjqofzL6DRFywHEP7AhTpqXbDYM)Wd(7izNjtaNg7uq8SWsGbfuu7tX4lrGBe2oIm)OC4Nz1BhHecHNzPbPX4NhChgnvpMj6kesRX9kR4aJ935jQ9kpLfJYsPaAPkj8sAMYiuGbka3s0cBrEUovSeVd7U917dPdh1qpfMLu)yl9jTnRx1i9nVKAgZ(uH67BSIuKVvs3bY41qu9HZ1s7bX0he3D)l9TxxEASejtqsTxHCeMdNjf8GOcnP0ypaludu12bMNnFMpjmDh96vhx1EbAaGBSWO(0qZKea)6y84JKquokEdbM667557SnqUF2BhRPO4)tP(JKq17tNRGHz5Z)oQCwYlMX849JNuq6I56RkZPi7PlPFa(vJnO)a(E4fOsRmuy8oWk9soYkhPjrjebOpnKLKsMAssi4RFAijLRQRrtZUWNgItHYoBswyCg97JWyQNU6O1hC7sBx)0QEQNkV0tqfuOhU)n3x80V4uT3(Q1iPCRlY0gQl6T6lV9Mz)(wB6Etn9x1riFDlwgRCldNIYU(r9FybGPf7(uxT2xlrz(EJTp6i1(I)AGw(h0bgb)Q4E3xM92eXAKgzMxDc2ydvToPeEiTxpDO5V)OhtOdPFvY1HDwDXy43vR7euvC)SX6Gs)p2ixxJOUQ3Oo47KS3BzgfRUtp(qXY4F3d4F2ow)3p",
		Enabled = false,
	}

	PlaterScriptLibrary ["Target Color"] = {
		Revision = 3,
		ScriptType = "hook",
		String = "9svBRTnmq4)lzFPbA9QDJ7lBmgLcgY(GzmN9PX0SI9zhdQsgj5U(cX)23PxQDcjPTWGgrIoD6UN75oD5iHKfK0qs2nDsjW195lOYAa3VrWeY(8F9DgvdYFtsJiPxEXLrHHK0Zq7xr51GQpxVcWF8ov4Csl869NvM7A4dk5kTSRqBVQq20QdiPZizZFS5wrjCY1pkPmbNKgJuloo6S4zNhEfj9Cs6vNrsVWq40lrINPPmK0OKMKvlfDToXcgvPCI3sB)ttP)GuWaNu7DTB6RKw4VGwv1CVte4fIooM8JaOAHcRKgPIHaP0BHwtfQp)6YsOKKv1Xl0ncmzpsbSQJ7Z74n65LEHej6bkd87wqxYGP9FRp3TEwvWpBlre9pahn4fAkWl3kMolFxI6qFH9H)DiKO97zHDEJTp)pKyu6Kt6u0A4tdTRC0j0NG6(8jsOCcU9aWyI)o5ZJT4g48g9uigItnFx7pyvSgTEfCp2JRLn8ARXbiwFij5u8Jb2KeJ8K9XQHIKRW7lsFbDQTt2YGjBMah2yBWssEBw)uuC0hJIJnS3VhfpZiTEFuCS4)gErhCFGgL4ucUWm1W2sT9idrL)ClivcoL1NVKk3fMg0UJSOmeSG5QmSxyQfa(UUSBISl3ASHVr5Ag8)BZXVNhu(8mVrMYOpaYVEyyTCDKMgKTtxNRCpeVoJ9l3m5GmqpmlyNs(X7VfAQl)K1lpCyaMcEDsGGavsqTYN(BuOCVHV104hoyoCQm9fOQDoXlPCBl2EWIDqo5F",
		Enabled = false,
	}

	PlaterScriptLibrary ["Combo Points"] = {
		Revision = 6,
		ScriptType = "hook",
		String = "vVvBVTnos4FlNVpC2hIvTCEztdUEaUoPBDrBIrKlkwKnkMwI2wOYscs0jnTx8V9BiPExuwukY7HdcjMwICMhoZWzgoIwxvFMUMQU2y3nlC3nFQRLdjy387MAJiy)711ip7H11w76(DDTJ11GwpTBUbV3EH9gTW9r8U5K1W)CqBWE0bVB(sx)DZV0FRL5U5Fa7JSHE6aTV1D1wCGIU2q9Rvp(0tgEMU2PqZZgQ(2Jpv9eGnNORn5NwBCnX9h9tyKUo6A)g0fDTZ0VE45WJFlf4xNWSX(y4ttDTLBDmiwUo7M3naBV8ODZ36yrMyg24d(WyG2yNhNHwyJ7T7t7MhEf3QFF)To0PPtaXFRbX1)VL(HPU)U5wGaa)dSXwG77M76y)m9)gaKEAn2HoLHBey4B5rGhSmumrfO7MdCjqjnaWG85t0RmZTrMMT3mZyn2ayTfGehmfYB9mzCHHl0g3ToHanNwoau9ojuIsGUr8s5ZOacyZ8m2FgYg7q(Air)3j4H1h(97X4wkIfDf3xE)ywLmBYrmC1n1CIkQkm9YbVyXIc1SKztpjygYFfMeAl64ssj9uMeObs2QHxcWyJ7c6YI0GRY5tGOENAYzhGRb7)OLjwcztkRRiHW41iNvheJlYA6kJuUdOFLzJzS13htnYiCq8)L6SwqdjsZu2LUgF1f1f9t0p4GR26nOj4vnQPIIskmz7Aq9r7rzWmWT)U5VJ1LsxELQNmft6rcdTZ4B(Y7V5HP3m56zADc7Zbt9UFTvwXDgbFgxT3I3aXYAP1dsBnKzP5L4OGl)Vdfzn54U0BSnxj(k2FCNcbEcdNY6TxiWmyEVO(vyieAqJih4HnSq2w)eXa5NAqWL04mafNCdXAdovqCBiGweVJaJa2vwSryjYVJjZaAkM1zSkgNKZXRrbathmHy5SkOW6EKJXAx)agU(vXfA)QZcxcXDtN0mrzngztw)EKpC3oexp6tha)n8KxokHgViA6fY2aRFIlLPpzzswZEO6WJk(41yRvRjL)8aGdCbTQKOHG)bzRF5aAbY47R8bZfZz8EY64D3nXbsxEjYa)Nt)8O)4QB)WTJ(Yv)5yWcj4MhX(G2pLNP7V)OkO8yxxFZqqm4nQdpNksvdBOoiU1WH0wVC0(YLi6YigaTn0Zq50q)4iCEEyJZJq(BplpWFjBWLVDZ3Ey6T38PRgp7Hjxc39)8US38lJMC9NNC9vLfyOkn5HxJwPM93IelV98eD8zNaFEc9Zx2dnl)jho1CLQB1bdInmhi7m6LkJshU0Cj1HZNXpIT5ROhmyG4(Or8reeRtDwdoi6SV9j0VVNV1Ju)XX3Y0Tikb)MGNxCHnfXyinUJtugVeQhxPYmmuQ9IqUXc6uAiptbH82dpRzeOsqrU85xrZtdLvIKeiNLkheeELZgw0XOO9vAglagl2AzBkw0hf2cIeMdh(XpJjTC5ZabttwQS5s6Kx(JCjmvAoO5mcx7gWhataZlmr4372HHAAushl70rs7vozJPx(m4cM66AxQru0vfZk24tGCPKPS0iFTJ)cnmrJhNUllxafwu7EnX3x)(xIjil7agLFY1)7xmYZZ(zncyoI8nFp4j2031lDLlkQK733eVy7QetlkSAgCqowByzHguPvJRdDfkDtPJIget0MkxVyQTpHtAhwErvBcY0NoDIPl1M3I8pc4(vG0bRMGSLjXK4cWVXueDB8D7LUTcDtfXtGlMemLt)U9QC1t(R6Ylny(2vcjt2Om1wPUF4vwrfKJ5YzJKzA3A2ibSk7(xInsgJ8dSnswE1k2iPRUM8AokRBnnN45D4g6LezVotrdwyTrj(3YnBsssukdr6yywGv23ecRu0zjpc3fJZcUpUDrgePuih5Je6)LhLwc8lMTz5zEk3HfMJMjGkDpZkQH7CEq4Dupu8fz7TgLLVkNEizy8eDymdvvgM8Fj5TSMrSGD1XmQ4QYxTzugsEKWL)TK0opNezwf9hZ86qXxbMvQvWVg6bs4gcI3pGSuH92jTa1ndPdyB7tcBSOnAkrU9LNIzLCzjlRyAANrjfZQe2rHLltHx4ljieXYja7teNWBaqVL1IivSxcHBqrsMiTOxCbBwgAUgFVUCLqNKU3rcuuG4ufrcnJkQKsH(9kOnRekmHRhI(2ZkHl8kT0RPmQnSMes4P8LFD7yGPLyQtBQRfxmRs11iFcDtFYaHcuUefDH(9kOD5kAbLuRxRihfcL2WuqiHBGPqr6iml2AmLLW7QYKGrqIQpgAoHe(UCBcDf7BQ4DLGuIn9lE32WiPqU8Dx2EHTX7v6U3YkvvPR(lOytLw32MekSwInb7YSgvnDFsGpKQs6DtkREVgqLOAT3nvL37jd(s2QynpJmLfGiiQC2PjqhEzZ7WE7KSdzW(8j1V)xbLA4bSi9yVYz7gLPrNUH0McnQmLXPEYtrowamZLGSZyNj6vruIKGwD7KXYiUyB37SUVnCAWQ1dmj(xVlNwO2fXHEG6sNip2HcAt5jqsf8ZkeIDZxBifN5Bw6LTys0n6jtXKQGOzIfr83IRpfLFeYv8tPjlwUiNLOOnTcAIM(aRKZwv5dHsw2eooSA5kRXzd8Sjomw7eoqWP0rSNW4dw23Ip9i8q0kMlu88DxAbuN9smFWW1zP1kfSdEZZoEgHhNLhSCOgQiYDQ3x7iqXHq(c6hTquKqUaBsa7)i2ud25a3iQB(Pz)OC4dp0m)ZmyJLq9BYb3Mv9LW3eo)errdzTVJnC1jwvmQxUikncKrVV5O3H3YMNWyO8nNaVxZi2hdpYsDhoOjuySng5pY2U6eKYLKXFp(4DvJCkIeEVl(0HjvYd7B(hTfX49aZjCVET07BzF2eYlSeN5KmsorJeeAfpSL1C8YR4BOR7CIaJgMgQr1PGkLne7TpYphXQ1nWEcgYuucB8ssN9uxw6MeI6tg)TVzOKfoVEPdvFycIU(Q3tXPp1lsbGklmBN3aEA8FyET3c(PJu1HwQgevQ9Bkz(l97BbX9zN6y8R6N1YR9xsq2J2orx7C6puk(HfdAb3GwjkpEtd6P)J(8R4B5s)96AxE7xNCjTXT387F9kOb0VniVhSmd4dY31gZB59OxActpeASFozdoMo(eAsheyDY7fgYTAlT6GjueTCP1pynHVqCnEe7ha5cQF9WbNoqfEUPj9hagpjoDnxpwvQchG()9p",
		Enabled = false,
	}

	PlaterScriptLibrary ["Extra Border"] = {
		Revision = 2,
		ScriptType = "hook",
		String = "fBvYUTnmq0VL6t2ajgnnloja9qwrDoOgu52lfvL0sJJjknPajLxYb9T3HuYsYrs2oPbOWibJih(4Bgo8Xj4OGrbEhf4F3sJIMsUwQIavk5NpYPgq9RaVpHtF8XND(fbEhh4FvuukHkKMPwVgN79cMzAkzMubPKWeTroJ9m1WKcD)uYOPmDPRHubcaxlXHqVNrfS4e7EH4oEvkjhzDOIfB09d8ojWFeekKhE1Zkkxkc8ofz0PNm4KpEXhhGS6m8Zb4)gyJdVZX4X3q5GWGwMa)NuYK4mZqovRZmNrJ)nlk)dfneYSINhxDTkjpFc6KjSLzMGiuMiWKtja6yi0zzc8UWsap6mi2gvPKBuGn6c8NKicT5KusxnWNCqkjrWmdJYnUxHRbTbX8r0XCOx6dPK8FfwhEOkbbieZSgvsOrQ(qv3are(5w(TbZWZY)nEXMGRz949hQVtynI6LsWdrrfIv1)cmXf4J7xRE38U4pvU4RIhbLwkO8RPQDU(1)kGiRg3XHlTW1Tx7lg4A4nc9xyracnzlG7oUEv74RkiS4)IcOn3YhQ6r9cKVbZKZFVkD3woQPs4a)BH1f5)VyWnL3ZEVU)wOdk5sv5eCziLVwL8g3CKpNs6Sc4C5IonJLM9mEkjN4UbuiX2mM(oFripQzSq1FHoMQq1TvTaXv84P0THbKD)3LGmiPqn(juB5mHHFUsMGKvWrr(fur(8j2zDShYEaAD(HjE5Bb9Qrl2AfhhPWdkOfETmwQmLy3LAtQBM1CSX(IeYOgFkQxve3CQ8x1WvEzvNkv6McuUzkkw13fLz1F1U2UhRam)augyzEfsxfwW9e(34xlmxxuuGSVBzjs9KmgA35YFRBnyRP6imlIDhGpXBBuOwcoox3ghLwVsviRORVJnkwXMBfPkgc356QM1gz9oblQeozpr7YyyYOZeRrhmRky8QxUlZM4ODS6KUMKUpHZZaBemZPC2PrT46IpUnVKk7b9lCEBNHhu9oF7F0BBW)94imqCy34ZJTLylkiDX2TGHY4AxWUqQ(ZLpsvAWv8wsz3N92rS2sz)bBOnTxeT9ojYooSfVBwiUhG66r5f3u2zJj74A6UQoAS7HwOMlQy7SbTA5OHBOWMjM)w7yz42uRBkMAOxLS3LT9zh83)",
		Enabled = false,
	}

	PlaterScriptLibrary ["Reorder Nameplate"] = {
		Revision = 4,
		ScriptType = "hook",
		String = "1MX6sTno33L8Nnzxsws6v(MHFaSqlT7MYutN(XYGDuSLXAqXYJKcH0D28SVhDX2Y3cjDgMae5J15(vj8h7FTV3yFVVIz8imFZSPOf4mksI3m72RuFZVZ3tUod77LWyp479kFVlwMgkjS0nZm7y03YIGV1p4r(bGAmNTO4T0LOnZWpLX4sC0Mzs2MzIqorMjg57nXF6BE3RHF89EJ)0XV5O3(UJg)(xFOVha5ZiHmgrPdp5hCeLL679oyp(EV1F6rGCCKs4De4tIIWr(EB(0MpnCOllJFgbU)GwezGgYeIyZm1VXmW2GIEeLgQi4sbMdqxLqctGVqPsHrX452rzciqPLYwmhwdKqQFfb2rewq4yLWQ(ukI9fyA8bapsjYlJSlUqHoSgN(41O5u8aaNz2pfRgommbh(aiXXAUWX)ciwGXx5)2mJfBOfSkv9ELEvkHfuHYcr0nZ0qVWi1h7ie)VpGLxH44uzFhHqXX(PmPlEJqHsg)AG3d0ItQJmB)WXYLCh440O2vS7XaPHibRHvBnv6gS)zHOqfmbtjQpI4eLbs0qHo5SR)YxV(MRop48PN)x3eC1FEYnN)vTY1dNIxSgK81yEVMwcolMqnMbB8r08r5qRV7)4ufLV(8GZ(Y0lU8dASS7DK22eeYsJj33arI4Y0ZylMRcrk50LfqDn3wukmWgU0ILVnRPf5cpADKlFrDusWiQm5ueVAiXOs41XieYGBU)COnS0SvyEZTxaU((NVmowVLX1W408x0nkt6cLjThbcP8GpcsCcT(O5itjaiUwdp7XSA5dT6qMD8XDfl2zAIMA9Tre)nlfFzQqQkfvsXEa77bz28IiNo2Nk1f1BGn3Pw06itoWiGybi6k0Araj1OWDkCfcz14xjFjU5MRKGV9SDDIUnxXu)1uYsBkT10ATO1zACeAPOr24TfEI72ohFaVw5JfQY926PA6VwvDx3wOmwOJOEJG8z86dCsDCbUaLIkE2nRhQX(rKirdTFPHDWZzUwrIKjwxl0L5(ezEJTvjO8nPAEbLlvirsTWyzQMpGwLHsX0Ut8)UIbUQZhTCPA(9sHKT4JvqYeBw1bDBtRYD3o(Ud2cTY53osSj31LZjxtSpUf94mheALX1D3DOdNvLt7eHAr(ZRgMRa5pVfn4QABPfwxjuSdfy)jJR4xzofenCPzWit4xCSoE0MMJnUfDn2dYZ7v)gb10G)UeBM2Q6oH)OMWknmHXZh0uYYO4yPnLaEIRf9oIj(sCShw()12W(j1cFhwn0bQh(7BMnz7K6MYERwBKU3hiSbwv(5mpMTjCnnAhUrJ7k245uKkXqDPjvjMrvoC38Nc9PaIWpsqMHA1sFMsrABmKIrykl)9TcWoTrRpWPdU6wGyzVoBt1wfRgW(1wMWBeq2atX0abiY4TqBRf(4MG6KY6s2DryNELubUnDEbjDP4LqRbcZ4Vq6TH2TQ5DotG5Kl2Jrn0uoqxZqLMpViWt)At4hsu21o)OmfeS88mNrXi(ju6vmcCmo3PSl3de)36oAnhiNTgtHT0KPSKkPsrdx8uQ1kI6OnMjUmAdiZ6tAw0HoeoXLkTNf38WLWmDWP86VsDKpafv5UWqCMQSXcMEW1qkj8bXGwogWtM0BtPIslL6yEAxO6SXdR7x7QKX6UjMjyRo1mqBqox7JOy6MkguTHSCFfuCl(ZRipHPFtsOJazu)A3QJqJME22f9QDQBx4f2RFR8CD3tzZruBj9GNGDnC9ZUT17LKnNjHoW6UxnKUAVB4UjI7Ne2UhXP3RXFy6ZQZ)kqW2rCFDmw0Qz(BXOK)QQnXRd4M9JFfwZT5fg(tYY8cVo8SYyODHN5Y1YXA0LWzvQJ6pjPovFTvEjemnQ5qXqr8XJEDxWF2OeNbw2sys(4g7BCsoE7EGsTPKAa5M9KL7wSYpnxlIwCyB1H(7Wd4A3rQodjKOi11vmFTA4Sy0sQkErKWwz6Au)EdnJ9N3pvpdhr2YmyTDiHV7Cu0TFqIohEPiIWZmpyfUPwnyhMBaTKJkUWWg3gu84tSnMB7Y9gPqoqJ74aBh8sFKz3QrdSKOF59rbM1)rqImt1wWLrkqQEi1aRlhxd2AtHz3JoOiVrAcwBRr)Vh069Wbq73H2CpNTkiIWX2RBwj4tgyMMCYGTCFHZJNSJ2Qj7LTAsnB1K2TvtAXwn5L1wnzpmwM4p4JV0379Q)XesyU2ujScaa0zzMzzifjeMLlqzbKi7dCyEpZQShZCXLZO2xGIJjpzwItdzlvdewsargouVcwlzHpI5cqM9N((dF1HhcihfP(hOy0uFp7f(yrW))(d",
		Enabled = false,
	}

	PlaterScriptLibrary ["Color Automation"] = {
		Revision = 1,
		ScriptType = "hook",
		String = "Dxvxpnoou0)lLxajsv5RPtrAFanSiXUJcRubnpqXexNBsJgh7iBNPDge53(CVXUHuANDaP9PLisVX(47hN75MWoIDll(i20pPLAttYf1oDj3vOvnj3)psUdmpWIpMn9AfAMXfWSlstVrzN53CwrjphSZe0XFCo3WIpHn9p52V3KSKJ3C6MeXcUkhq7f4nHpq6SMeogKAvHBytYnvGQdGY6m1chbZkmfvocAAtsMwk1ldWGv8YkjyhYIpLn9V5wxgxkJU4hgUuRyXNHL1zNo(Kjhp5e0(d4kJyXJPIn(Jyrp1XLGYHwo20CJUUYBkKCR1BwYRESin8GbRDVv13Q6FwBfi8w8SSIvEtqj01eL1ZbAP3bow8ekbI5LqfXInj3vLI)MYMMvReE2FFliZo0tqxNgmUYGNbTb13ULpxch08xnjHRoROiUZbLeTrSFo42K6Zm6YWkKp7wxwyDV4fPwWLD79hVeZHXvIw1IfLiDj1qfERvtChUevAFwVefpyN28(p778y42xN(WU5IISnREyfwMwKdTD8YcGlDlAsq57AyDoGo((TRDqlAvVOeU8tcdNcUUoAyAA)(9SGt6ooGs6EzS)XDErtNDZe)xPrA72TJHQkHnmHHfyXAoG4ibnIohPOcLfmOc98(UG4FVlErm9B2gDejTqLb5ClSbESlE5V0F9rgALDzhpnfWSNBpFhOO0a3izGbshG10GVd0RrgSdOlGveW9U6Qr4FTGrB6PDH2rSlI)PJqGJO)F(WWtTR882PE)U)2sBCi7PTLxBVsu06x(rTCBHkFdk2Z7VIOrKgiVwss8(Ww32dIOlp)TKa3p42f1QuWG5nE8VuOsnahFEWdTvXAQokkKDDHUupFJihOskF4wcx6UIMRF0egEEKe4vDHRhL3pO9Lz9Iw7Eua96GDeVXNnEYOqLS3OrT9)(oULU2wQ6JratUbOVOrf1REJY)wF1pMfCQcw2sywsyAG3uN5)BR8C78MutTqrT1rF5kOzMJFr(RG7x(o02V0Y(5p",
		Enabled = false,
	}

	PlaterScriptLibrary ["Attacking Specific Unit"] = {
		Revision = 2,
		ScriptType = "hook",
		String = "9EvBtTnoq4)l5(WbZazY7P0z4d0YqhOTHBQHBMBaewyVoXdkwEKuOq7G)TF7kPK4qSbcT3vtH1sp6rp7APDLyTzNXcAZcoWy4r3MMnUimihIstsJkcppl1ueEXFj4gqDflW8qoWcMiL3Yc6Yc(4eE2yOi0mb)vgFkKtalcJKcPQimnX31mlnP6Iq(YzHxeQxmroeI0Br0FvMD7FIyp9EukgUzg2gr3HQzPXuhNPaEMr3Si8FKZkcNYFOieIjc((K0Ojo2qCulgfoFOzMxkrYmTrnlYqmQJuP5MMSGoSGJZqxmHhbxEqC8Pz6lDo9LPt5Jb9LP4aVEH6VMMbwqF2O2d60Q7WH4pSGESGpZ1MeUqS7b)qXfYmwWqedlyaBu3byeBpkAFmo4uUi9hCtkbjzwwezveU1uz8z8BeW2fNue6E2DxrQg9ejgnZYJOGywS1Bsv(qTEh0GJJ)gGCvnOmq87ltb9XXrXYpiVq32yMq(DGMfUgwbFE0XhwlFLr6xkSqD84yavpx)(kqrYa7iSHcIBG(uJhabQGgvaDcCpb8po6Ow4)SGrB6TQqBOykI)NTrGTO))4o(3ST846sFP18VjnJSl3)ax9rhR7xUpzws64NcPwoKQy4LPPeQ1zsbAWy7uxjhL7)58QVGRUonzKDLfsZplb2)CXG2T7n4QQvknb7qH6gsr6DqdR9uClmU9YV51TAzDAB3Q7760zt4nMsbqBQPeapdX972FJ4vpHpLwHccykKz4IkiDV(Tg(MiDmQwdTlc4kZKYtsToWG2T6p4Tmx5kmFLydMQLT8yXjaMy5e6HfmAz28ZZJX)gVsEknis2XTV)4yVXrkCmOnKDNvX7Su8LsNrffYKM5J1MajBDDPaZmvP2DsBX(6XGXN65tNVsMidxz7RMutczefmCOCdDFxzo3lBnxvnXQlnCWASDv7Fi)yRL8SDDoY6Tuw9pnrQx(RngVU9Wrj7Qo18tGze12rk5uVhuwt1Xd5LJS589EV7Lx07RMLV4ksSpTJxHvhB6RAS1CaB)6clrtaBT6KQco0PhwEoIf1Zrm05gOcK1QZO1ZZwoP3f255k3HmQgXCh5vbYgoU614YKNoVcv1lEkbS2Yqp)qN)4xWeaMfBT9JFRYBETYz76PBL9HVgzwUs3MQ0vg8VpzUGOMloq38J8EUTl50VkJTlyWJkcRtei0a5RVwIShyR6c3B(39)dcO)o)E)2ww(nibdltQFP5)dFRXZTRR6JDz6TVG)IHN()D0z5XARybw0cBySsol3zgj4ATZCkp)60y)lkPaCw53LxES8KK079yWlH4SGSi5m6EjljGUYK1cTnYO7aLMUdXO9Wtb3hPjoMUrHlQYcK5u9AAOJS3Z7m6(B09rOanE)nkkZc(BUyg4WCuV(DA3zqR31Qt3H7nCVoSKD73LnQtT9G)0InQhnyusFgEaDEhThhrs5fUxLtHx7hYHGoIfGeHt4c52BHC9x3exJveUI2)W8zEL1GBMeUrkfLvq3Ntb29rpre3SQiwUv7xth9QqhFJsH4NE9tdcLYV8lnZ0d7Fd",
		Enabled = false,
	}

	PlaterScriptLibrary ["Execute Range"] = {
		Revision = 1,
		ScriptType = "hook",
		String = "1IvBVnQrq4)lUQsMkhxNx8DPrnFiNVMMls1nQox7hQkLnWGzBWl0LLyNuD8BVZS8UnGDSZDOlEHD3zEMN5Tfmp28EZPhBo7Nwb2XkiX63yI54p)5D(mfi)lZPNGZF64thFU50tnNDLJtIfSsjz4pUUGTkkXsfqpltassadtSMb4nkp8p2bIiLm2wfitSISL8qvILlDtqOIJto0C6zOO9wYo6QxKm)aH50XOAhF27pB07gFgQ63zo98ZmN(EcStphb9mfZhekCKYC2CzqCy6qBFwuu6WfSW)M7KDJmWhshf(uy19kz2ztWCD5Rshcc7GybsaLcikeS1JuMt)bcatzlGqILsS(COd(RJ5m3yHnzsjw9JaF3bjwXcU6tozdUwI7bhdINUN9GpyKCBIv2vXiUlU78vm8ZrWK4ivWImp0DG0gXUHMBfv2)gYj)6OJwWeXm)elhqbPWBJf5hytRWdy(kVpWqFZLvG8WYNVXo1WTy(HtILseF3OFqI13xrM1N7xyRsS(XlljJH7QfMDvsreflY2Dw8B)cSBSPeaHZ2PTYNa(rWUr0SykvOdAwtwL0ADu)v2I7YcRn9TP32YL5SjL5ZVnr8hDur1JcUBqkzH6jVmsELJLCFksLjC8ZNQy7HPXovf9spoToxg5fTslRLleYFTGP4ySV)ZKY4ZNtZwxO6kAvf5ZbXyTlbTLLmuB6cGranWJNvpmf4CKxSzKIdClvUiqvyPI5nRoSQjMSyRqLC7M()MlkOtAtn0M42mYjJzxhefCXGCZqBkEvyvTHXW1)eSvokMmAxzWIeRxazq6EdeuSWOHNmkv6W)QRlrtDYOVnLK0YLcDWIsCxObRVbJwlYgJSqpBWYClkpeIuOTxkpR1NOSwUDGp1AAjLjwfmAgr0UjxaVjmXeTSNKkPlZcgQaQA62lRu5duv3mTRJG0qEFHdQK0DAZWv9aKfGYIUOH1qMpoHvpj40d9q9EgiARxdl1dwrl8BU(6r4)0lght310QveJGR))oM870))YGS70p5lT7ElzVEZLai61S)9HaPduqCD4n(GEHLsDT8KInS(60CsZ62J7K7eDaxwSVQ0B6WFIhrIGrnBQ5OlCzCHdw6r1iUVbLDAJYpMlPMsUlYKrS4auvtMZ)GLgwtLfObdcO09O9hxvX0v(HESSeWXBBXvOuSMSc616gYIa(uomQQMJhVZBRIcDyYhBZpwLodL8N0vb6ZPt)jOQt5D4IQ07YjyZ2PLDc3)(0vlra2pMwPwNbxRKrHNATO(gpUrlfM26PnYVs7AnCgOkoXBgZ2VPo81YFn66WmoDO7xRjvjRDpmSA58nBv1uWxxJAJu)D2IA4a7zJMeR(vx3lir33OlO0LOGkbY5IARcQdYQ5Zv36HE1VK1A1e3PSPDakn532YHM7kVFVH6()EyB3iBjMyMxWYUCKTTnq97GubRYtB(iOyC)inqxgiF8I7yYO0Yar1cV3OPGXEP9SUc97O1KXHrt1I33DAQ(2omAQXEAg7fmAHVASzRXHxf7v)Hl2nh)eFGHy0)UaSdD0UuaQfg51lO9gZi5pJ)cu97KCXpdQBa(CpvFJbv2y1NBCikuBwOg7rKoi7vvj0H29bxvV118FWDuEu)HVR1x3Io1(BmxTEG69uYc2Ufr)ObDce61imoevLs1T5yoirx4a2GPRs)J2r(Ch0JKaDnfvlOG0AwSWB3byQT8n)ks6VwQ5)p",
		Enabled = false,
	}

	PlaterScriptLibrary ["Dont Have Aura"] = {
		Revision = 1,
		ScriptType = "hook",
		String = "LA1xVTTnq8VlEpmhGyV4K42KcShksrqDFqyyo9PIQkAQtreHIuGKkoPfrF23DKYY02YiBlXi2NipE8397(NsNLExAYS0LFsR(DxB2NzpcTzFSXWAZ(2FjzoW890KZrvU4DNF27ttUiD5nLm19OwUs8lfRcQj9AZ4AP20MTUeuTzSD2kxdwCbnEdL(BWFwgEn4YwaxwO6wKRvwNPH7iBz5grTBAAYLPlx8trLohM8XFAysTknzoIQ5ZVC2fxD1LO87WvUon59K7KCf6wlDmjOCOKlD59gDtDqKlzwBqSIv)drE3dgTecs1pwhFwdJ3TbROq8uqeuCDJc5NTgWwdCVKln5AcajBzGVwNJ)MNUSOrXDcn6UJTGS402SgLWTiVt4wdEgugupEhBLeoP9lTzDF6LMmjx7PZsH6EK7k64o8UEgqAty9btIt56Qvm32Js6o2hicr3PlSlu34vA8jN4TJk6k7(yaxJrfdbqL)FbzKR9Vex9SW0na71G1Bfu7ZEokNuwSh4IWLDjU9Bhv8sG)Wo1c9Bk1CMKkwSHAX)SnRGjTWqgQGQuOZNesD(rGHRzcd6AJ3Kjn9omp(bKbilApHkkpe7EpTlZOp79ZBqX44m0n34XZA28j2lWsB44AUYaShoC7DyWJqNBtG6UUJcRo3Bj469WBcTUgpuf40D1kQGe2nGedK(dFR2WH)gkmGTCFd9k0whoh8WXy9KyA4Ou2bew7xWLXU5B73(wAonzYIQATXXuUpGPVcf1W36ygNVMBTWvszCn4PWFz2sAFMX3WVQcB1spsW0VMpowJhUntVPAnmly4kj)ieS8MkL1Djz(aXZ6Myt2y9OXvI5zUUjw2OHpLatsaDfZeZEVASCOu7i4TxhNdMgYuph5OfAPuV2duFxHtdTKwlKyhHvGVYgh8KVHv7gB6HHuy97ScqtedbAJWDGtPKYEIcBjG2NZubthyAsJW8BmrGZSasWkRWjEKs2O7zREl(0am1oTA8KZVomfDYKVnkrCFPBLKLdJ(EpjEkTxiAk8PfOLFIvvtPo9rW9W5qwF21ZVC(5)pTBSFDym9LHd0Rlf8Y(GX(VGegbdSm3)gu57mliCK(ablpNIJm7hgqlYM4gzJmq(i0Rg9mqPmJgq1s4jsXF72Bpd)ZRmktpnK2ok6H6)RzOINr))YPDp5x5LHCAFnwfdtHXjuAIkr8)hEF20xJDyoYavqJQfQhgTFlk69Ps)N",
		Enabled = false,
	}

	PlaterScriptLibrary ["Cast Bar Icon Config"] = {
		Revision = 2,
		ScriptType = "hook",
		String = "TN1wVTTnu4)l(HnBSAxFpxaYdojlTUTXXOYP7HLXAAj6yTYikqsL00h8V9D4frlhjFpydyOWnUsIKh(9DUXJog1anc51a5DbwiNp(CmF(4((SO5J9iszy09I5J)ZH)fYt(Cmb5nJX(gYRfY7A2JK5JLZGVc1tNn1ERiMqPZh7RLNKzFkLmfULbsNhE)m4sryajZQIWpqIPyjPgYRjYRFKKWNI9j31li4MiXDdvJXVl8b89eXDkHpbZ)QARrEDqdA05KJQFYrn7EmYRnY7YqjoGXR27hCmvnLJGPG86Ig0QnmJtuC2q4BJdabJ8MMe5ldvePSGqN(M5JtIcL9dSxCfhWhCnj6Xr4jusL5Fy(y7h3vPdwZiuLACiteAfRtmzwRARQnAgNjLuIzvZhF28XvBKv(KOa4w4tkO9KyU81bZUjwtPtbZFTZz8ac3BwiHgCk4eCjh)0NWpt4Llb76tm(3kv5q4Cg(SQpapzrcjpXxY47mpHlFGfSAkxTAmp8raSNU4zl2I9Gq2puMp264RdJoRaT7kxLji6m3YRPdcx1SJy6aeEsSCe57YeozP1M1eMxg5FsiefwovNvd24PH3xtmJ9Kcev0rOfGf3QHjD6fucM3JshYcJKIYvw90xJGkcgkPFt0NG0hEqgJncM1kReb5Qek1l8hBVGwILq4GMGGSljzX6uzLY6gwBgbtLZaJa8u1uu59kLXJmlTgIdcGmSRyufkVz6ubrw5aq5ei1c7HcaQ1xrbtZC2oKw9vdQBEMeQG8AkVD0uMrd9tdzrMNOGTGpF4WSU)RehNQXwDyStV)FR5ppqZz93sK()1441QH(PHCNJJxFq(h2eT)JWa5mG267Fhr(EIIvLRuztlfk(OOIiwVRKEPVhktOWLgDy1c5k0cdccQatUOElFCKRESnMqkFTBRKTBwpBRhuAe0qSszFwXUmJYmNvkVxkOm3F69IKjLl923Q8jl92svoePC3DBwk7MkKSOs4Yz2Vk7HuUGb1pdIPoaXgWF6))1RI2aIad7g8Yfb29DRpeRyiF5cbULB3bEOCXW4leUuP8OQ3YV8LejoKk0j3uV04PdXCbrpQOauAnz6Xxx2H9mFuXiwLMC1yrN76nUO8SPVMp(3YhKzxMzoxZc2nxVT)fOkMlUdy8jQrlTa4QaTvvtyAKI9nCvo778o3JgpdVA1OE4DovEbB1wLyxFd8fsI8ow1MhjMcke4k4b3ZzjXMl9PyHWC5d44VggyVHJ9jMRIFmo7A5mQDa80PHF3CjjYNLOW5cbiIj(6RGRLm)hjCbOyrdoUER61HfheO6hLPDwipwSsTRw6aDJ4gP6Y2GoiVpsEoD02iVVGPjeK3YnM7uK3ai46Lp2C)gBHMr2FLINqOipifIpYdW8GMlGrBlms7eqkoopDJvNBzAx4UTPtym3EAKHUhG2U6L2mKNuPebdQYNszph0kp0wU7a5aOrZO(7t6(pAM0(c1(tDWbWOuvjG)mvYUSTbnAPgEQ6Y5BC98KbJWFkuquSP9sSXG3BHqIXNhEFQs1qNjwYM51EELirgGpdlsBGRoRORZSMg5QTlX0K0jzEbj4PkQ0zbvAI8Ug)DTlSz)Ukms1O4KOLBxSqtIRdHiJ6VWpwV9MQxt1aQ5aNKOBrNY6UlKpk5HjQqnN)YIIJvyV7AWUxmiCG7e5tes0s4xxe4Y6hlDQ2jZEzRtplpYYv3W7dHCkKjkEC0cE0DP0hDZV5NtXrFd00k6TJEsQvMnDXXRkRvhxwRlWr)kOHC5ZNponJUtzKBOdmj2jfNeZj8cZJTxB9kdTeAzIDf)A)Tq0)2iz8B8nkNjkhRuTGjBxJ6lirRmUuzQJFXbdoS(UpFZTdV6Z9U(3V72(v13v96E9hmQ3Gp2)IBgKszxXYg5SluwrihLJeqvFwgfRR3FQlJOL5AY0iVfjFHP5mmouMPe3d1(mboux9th4SlHcJ1kszcatbf7dbh)I6aOqPb9zouSHf9zlynf36tXv)RP(7w6VBJUQtN6DBF8jDA2Q1rnR3QjAA1oTvfi8cwAf2UWpFZsS5RiuIFQ1W3uiUlpEwRrR8j9auzLsVG)orixEvGYqvnSnfxJCi)pmJAt00O(szN2)01zRexd825bEJUPaF0sawBwj2FdYjPN(iaCNEeN7epxkCWTy6lpVAgXC4TA2pHJ0EGMe9n6UmmDv(NpJRtr9ER00Z6GY6FUwH0z3TKX2I9tPHA(VmPGBkfC(7RGb1jFP2(L3MUEgi54irmMdLF)8IIiYwGqQJ4YBR(vr2p0)cfKrss9h0)a",
		Enabled = false,
	}


--[=[ --template
	PlaterScriptLibrary [""] = {
		Revision = 1,
		String = "",
	}
--]=]

end


do

	--[=[
		Patch library are a set of functions to run after a Plater update.
		These patches are intented to add or remove spells from the aura filters for the current world of warcraft relevant content.
	--]=]

	PlaterPatchLibrary = {}

	-- #1
	tinsert (PlaterPatchLibrary, { --deprecated
		Deprecated = true,
		Notes = {
			--"- Added 'Soul Harvest' to buff track (Soulbound Goliath from Waycrest Manor).",
		},
		Func = function()
			--testing
			--Soul Harvest, Soulbound Goliath, Waycrest Manor, BFA Dungeon
			--Plater.db.profile.aura_tracker.buff_tracked [260512] = true
	end})

	-- #2
	tinsert (PlaterPatchLibrary, { --deprecated
		Deprecated = true,
		Notes = {
			--"- Added 'Symbiote of G'huun' to Special Auras.",
		},
		Func = function()
			--add symbiote of g'huun to extra icons
			--tinsert (Plater.db.profile.extra_icon_auras, 277242)
	end})

	-- #3
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Border thickness set to 1, border color has been reset.",
		},
		Func = function()
			--adjust border color for the new unit frame
			Plater.db.profile.border_thickness = 1
			local borderColor = Plater.db.profile.border_color
			borderColor[1] = 0
			borderColor[2] = 0
			borderColor[3] = 0
			borderColor[4] = .834
	end})

	-- #4
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Adjusting new value for UIParent Scale Fine Tune if the UIParent feature is enabled.",
		},
		Func = function()
			-- disable this, as it leads to issues with profile resets!
			
			--if (Plater.db.profile.use_ui_parent) then
			--	--@Ariani - march 9
			--	Plater.db.profile.ui_parent_scale_tune = 1 / UIParent:GetEffectiveScale()
			--	Plater:Msg ("Scale Fine Tune adjusted to " .. Plater.db.profile.ui_parent_scale_tune)
			--end
		end
	})

	-- #5 (replace parts of a script)
	tinsert (PlaterPatchLibrary, { --deprecated
		Deprecated = true,
		Notes = {
			"- Replacing some parts of Aura Reorder mod.",
		},
		Func = function()
			--aura reorder fix
			--[[
			local hookData = Plater.db.profile.hook_data
			for i = 1, #hookData do
				local hook = hookData [i]
				if (hook.Name == "Aura Reorder [Plater]") then
					hook.Hooks ["Nameplate Updated"] = "function (self, unitId, unitFrame, envTable)\n    \n    local auraContainers = {unitFrame.BuffFrame.PlaterBuffList}\n\n    if (Plater.db.profile.buffs_on_aura2) then\n        auraContainers [2] = unitFrame.BuffFrame2.PlaterBuffList\n    end\n    \n    for containerID = 1, #auraContainers do\n        \n        local auraContainer = auraContainers [containerID]\n        local aurasShown = {}\n        local aurasDuplicated = {}\n        \n        --build the list of auras shown in the buff frame and check for each aura priority\n        --also check if the consolidate (stack) auras with the same name is enabled\n        for index, auraIcon in ipairs (auraContainer) do\n            if (auraIcon:IsShown()) then\n                if (envTable.consolidadeRepeatedAuras) then\n                    --is this aura already shown?\n                    local iconShownIndex = aurasDuplicated [auraIcon.SpellName]\n                    if (iconShownIndex) then\n                        --get the table with information about the shown icon\n                        local auraShownTable = aurasShown [iconShownIndex]\n                        --get the icon already in the table\n                        local icon = auraShownTable[1]\n                        --increase the amount of stacks\n                        auraShownTable[3] = auraShownTable[3] + 1\n                        \n                        --check if the remaining time of the icon already added in the table is lower than the current\n                        if (auraIcon.RemainingTime > icon.RemainingTime) then\n                            --replace the icon for the icon with bigger duration\n                            auraShownTable[1] = auraIcon\n                            icon:Hide()\n                        else\n                            auraIcon:Hide()\n                        end\n                    else    \n                        local priority = envTable.priority[auraIcon.SpellName] or envTable.priority[auraIcon.spellId] or 1\n                        tinsert (aurasShown, {auraIcon, priority, 1}) --icon frame, priority, stack amount\n                        aurasDuplicated [auraIcon.SpellName] = #aurasShown\n                    end\n                else\n                    --not stacking similar auras\n                    local priority = envTable.priority[auraIcon.SpellName] or envTable.priority[auraIcon.spellId] or 1\n                    tinsert (aurasShown, {auraIcon, priority})\n                    \n                end           \n            end\n        end\n        \n        --sort auras by priority\n        table.sort (aurasShown, DetailsFramework.SortOrder2)\n        \n        local growDirection\n        if (containerID == 1) then --debuff container\n            growDirection = Plater.db.profile.aura_grow_direction\n            --force to grow to right if it is anchored to center\n            if (growDirection == 2) then\n                growDirection = 3\n            end\n            -- \"Left\", \"Center\", \"Right\" - 1  2  3\n            \n        elseif (containerID == 2) then --buff container\n            growDirection = Plater.db.profile.aura2_grow_direction\n            --force to grow to left if it is anchored to center\n            if (growDirection == 2) then\n                growDirection = 1\n            end\n            \n        end\n        \n        local padding = envTable.padding\n        local framersPerRow = envTable.maxAurasPerRow + 1\n        \n        --first icon is where the row starts\n        local firstIcon = aurasShown[1] and aurasShown[1][1]\n        \n        if (firstIcon) then\n            local anchorPoint = firstIcon:GetParent() --anchor point is the BuffFrame\n            anchorPoint:SetSize (1, 1)\n            \n            firstIcon:ClearAllPoints()\n            firstIcon:SetPoint (\"center\", anchorPoint, \"center\", 0, 5)\n            \n            --check the consolidaded stacks, this is not the regular buff stacks\n            local firstIconStacks = aurasShown[1][3]\n            if (firstIconStacks and firstIconStacks > 1) then\n                firstIcon.StackText:SetText (firstIconStacks)\n                firstIcon.StackText:Show()\n            end\n            \n            --> left to right\n            if (growDirection == 3) then\n                --> iterate among all aura icons\n                for i = 2, #aurasShown do\n                    local auraIcon = aurasShown [i][1]\n                    auraIcon:ClearAllPoints()\n                    \n                    if (i == framersPerRow) then\n                        auraIcon:SetPoint (\"bottomleft\", firstIcon, \"topleft\", 0, envTable.rowPadding)\n                        framersPerRow = framersPerRow + framersPerRow\n                        \n                    else\n                        auraIcon:SetPoint (\"topleft\", aurasShown [i-1][1], \"topright\", padding, 0)\n                    end\n                    \n                    local stacks = aurasShown[i][3]\n                    if (stacks and stacks > 1) then\n                        auraIcon.StackText:SetText (stacks)\n                        auraIcon.StackText:Show()\n                    end\n                end        \n                \n                --right to left\n            elseif (growDirection == 1) then\n                --> iterate among all aura icons\n                for i = 2, #aurasShown do\n                    local auraIcon = aurasShown [i][1]\n                    auraIcon:ClearAllPoints()\n                    \n                    if (i == framersPerRow) then\n                        auraIcon:SetPoint (\"bottomright\", firstIcon, \"topright\", 0, envTable.rowPadding)\n                        framersPerRow = framersPerRow + framersPerRow\n                        \n                    else\n                        auraIcon:SetPoint (\"topright\", aurasShown [i-1][1], \"topleft\", -padding, 0)\n                    end\n                    \n                    local stacks = aurasShown[i][3]\n                    if (stacks and stacks > 1) then\n                        auraIcon.StackText:SetText (stacks)\n                        auraIcon.StackText:Show()\n                    end\n                    \n                end                    \n            end\n            \n        end\n    end\nend\n\n\n"
					if (hook.HooksTemp) then
						hook.HooksTemp ["Nameplate Updated"] = "function (self, unitId, unitFrame, envTable)\n    \n    local auraContainers = {unitFrame.BuffFrame.PlaterBuffList}\n\n    if (Plater.db.profile.buffs_on_aura2) then\n        auraContainers [2] = unitFrame.BuffFrame2.PlaterBuffList\n    end\n    \n    for containerID = 1, #auraContainers do\n        \n        local auraContainer = auraContainers [containerID]\n        local aurasShown = {}\n        local aurasDuplicated = {}\n        \n        --build the list of auras shown in the buff frame and check for each aura priority\n        --also check if the consolidate (stack) auras with the same name is enabled\n        for index, auraIcon in ipairs (auraContainer) do\n            if (auraIcon:IsShown()) then\n                if (envTable.consolidadeRepeatedAuras) then\n                    --is this aura already shown?\n                    local iconShownIndex = aurasDuplicated [auraIcon.SpellName]\n                    if (iconShownIndex) then\n                        --get the table with information about the shown icon\n                        local auraShownTable = aurasShown [iconShownIndex]\n                        --get the icon already in the table\n                        local icon = auraShownTable[1]\n                        --increase the amount of stacks\n                        auraShownTable[3] = auraShownTable[3] + 1\n                        \n                        --check if the remaining time of the icon already added in the table is lower than the current\n                        if (auraIcon.RemainingTime > icon.RemainingTime) then\n                            --replace the icon for the icon with bigger duration\n                            auraShownTable[1] = auraIcon\n                            icon:Hide()\n                        else\n                            auraIcon:Hide()\n                        end\n                    else    \n                        local priority = envTable.priority[auraIcon.SpellName] or envTable.priority[auraIcon.spellId] or 1\n                        tinsert (aurasShown, {auraIcon, priority, 1}) --icon frame, priority, stack amount\n                        aurasDuplicated [auraIcon.SpellName] = #aurasShown\n                    end\n                else\n                    --not stacking similar auras\n                    local priority = envTable.priority[auraIcon.SpellName] or envTable.priority[auraIcon.spellId] or 1\n                    tinsert (aurasShown, {auraIcon, priority})\n                    \n                end           \n            end\n        end\n        \n        --sort auras by priority\n        table.sort (aurasShown, DetailsFramework.SortOrder2)\n        \n        local growDirection\n        if (containerID == 1) then --debuff container\n            growDirection = Plater.db.profile.aura_grow_direction\n            --force to grow to right if it is anchored to center\n            if (growDirection == 2) then\n                growDirection = 3\n            end\n            -- \"Left\", \"Center\", \"Right\" - 1  2  3\n            \n        elseif (containerID == 2) then --buff container\n            growDirection = Plater.db.profile.aura2_grow_direction\n            --force to grow to left if it is anchored to center\n            if (growDirection == 2) then\n                growDirection = 1\n            end\n            \n        end\n        \n        local padding = envTable.padding\n        local framersPerRow = envTable.maxAurasPerRow + 1\n        \n        --first icon is where the row starts\n        local firstIcon = aurasShown[1] and aurasShown[1][1]\n        \n        if (firstIcon) then\n            local anchorPoint = firstIcon:GetParent() --anchor point is the BuffFrame\n            anchorPoint:SetSize (1, 1)\n            \n            firstIcon:ClearAllPoints()\n            firstIcon:SetPoint (\"center\", anchorPoint, \"center\", 0, 5)\n            \n            --check the consolidaded stacks, this is not the regular buff stacks\n            local firstIconStacks = aurasShown[1][3]\n            if (firstIconStacks and firstIconStacks > 1) then\n                firstIcon.StackText:SetText (firstIconStacks)\n                firstIcon.StackText:Show()\n            end\n            \n            --> left to right\n            if (growDirection == 3) then\n                --> iterate among all aura icons\n                for i = 2, #aurasShown do\n                    local auraIcon = aurasShown [i][1]\n                    auraIcon:ClearAllPoints()\n                    \n                    if (i == framersPerRow) then\n                        auraIcon:SetPoint (\"bottomleft\", firstIcon, \"topleft\", 0, envTable.rowPadding)\n                        framersPerRow = framersPerRow + framersPerRow\n                        \n                    else\n                        auraIcon:SetPoint (\"topleft\", aurasShown [i-1][1], \"topright\", padding, 0)\n                    end\n                    \n                    local stacks = aurasShown[i][3]\n                    if (stacks and stacks > 1) then\n                        auraIcon.StackText:SetText (stacks)\n                        auraIcon.StackText:Show()\n                    end\n                end        \n                \n                --right to left\n            elseif (growDirection == 1) then\n                --> iterate among all aura icons\n                for i = 2, #aurasShown do\n                    local auraIcon = aurasShown [i][1]\n                    auraIcon:ClearAllPoints()\n                    \n                    if (i == framersPerRow) then\n                        auraIcon:SetPoint (\"bottomright\", firstIcon, \"topright\", 0, envTable.rowPadding)\n                        framersPerRow = framersPerRow + framersPerRow\n                        \n                    else\n                        auraIcon:SetPoint (\"topright\", aurasShown [i-1][1], \"topleft\", -padding, 0)\n                    end\n                    \n                    local stacks = aurasShown[i][3]\n                    if (stacks and stacks > 1) then\n                        auraIcon.StackText:SetText (stacks)\n                        auraIcon.StackText:Show()\n                    end\n                    \n                end                    \n            end\n            \n        end\n    end\nend\n\n\n"
					end
				end
			end
			]]--
		end
	})

	-- #6 (add bolstering into the buff tracker)
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Adding 'Bolster' into the buff tracking auras (automatic tracking)."
		},
		Func = function()
			--add bolster to aura tracker
			local buffTrackerTable = Plater.db.profile and Plater.db.profile.aura_tracker and Plater.db.profile.aura_tracker.buff_tracked
			if (buffTrackerTable) then
				--buff tracker is a hash table
				--check if bolster isn't in the list already (there's three spells with the same name, at least in english)
				if (not buffTrackerTable[280001] and not buffTrackerTable[209859] and not buffTrackerTable[275337]) then
					buffTrackerTable[209859] = true
				end
			end
		end
	})

	-- #7 (change scripts for 8.2 patch, editing the frameshake stuff)
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Update on scripts for 8.2 wow patch."
		},
		Func = function()
			local scriptData = Plater.db.profile.script_data
			for i = 1, #scriptData do
				local script = scriptData [i]
				if (script.Name == "Cast - Very Important [Plater]") then

					--replace the frameshake in the cast bar and apply the frameshake in the unitFrame instead
					script ["ConstructorCode"] = script ["ConstructorCode"]:gsub ("CreateFrameShake %(self", "CreateFrameShake %(unitFrame")
					--replace the automatic GetPoint with preset points from Plater
					script ["ConstructorCode"] = script ["ConstructorCode"]:gsub ("0%.05%, 0%.1%, true", "0%.05%, 0%.1%, Plater.GetPoints %(unitFrame%)")
					--replace the castbar with unitFrame
					script ["OnShowCode"] = script ["OnShowCode"]:gsub ("self%:PlayFrameShake", "unitFrame%:PlayFrameShake")
					script ["OnHideCode"] = script ["OnHideCode"]:gsub ("self%:StopFrameShake", "unitFrame%:StopFrameShake")

				elseif (script.Name == "Cast - Big Alert [Plater]") then

					--replace the frameshake in the cast bar and apply the frameshake in the unitFrame instead
					script ["ConstructorCode"] = script ["ConstructorCode"]:gsub ("CreateFrameShake %(self", "CreateFrameShake %(unitFrame")
					--replace the automatic GetPoint with preset points from Plater
					script ["ConstructorCode"] = script ["ConstructorCode"]:gsub ("0%.05%, 0%.1%, true", "0%.05%, 0%.1%, Plater.GetPoints %(unitFrame%)")

					--replace the castbar with unitFrame
					script ["OnShowCode"] = script ["OnShowCode"]:gsub ("self%:PlayFrameShake", "unitFrame%:PlayFrameShake")
					script ["OnHideCode"] = script ["OnHideCode"]:gsub ("self%:StopFrameShake", "unitFrame%:StopFrameShake")

				end
			end
		end
	})

	--#8 dummy patch, due to some patch deleted
	tinsert (PlaterPatchLibrary, {
		Deprecated = true,
		Notes = {""},
		Func = function()end
	})

	-- #9 (replace parts of a script)
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Removing deprecated mod 'No Target Alpha [Plater]', please use 'Units which isn't your target' in the General Settings tab.",
		},
		Func = function()
			--aura reorder fix
			local hookData = Plater.db.profile.hook_data
			for i = 1, #hookData do
				local hook = hookData [i]
				if (hook.Name == "No Target Alpha [Plater]") then
					tremove (Plater.db.profile.hook_data, i)
					break
				end
			end
		end
	})

	-- #10 --migrate buff frame sizes and anchors
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Buff Settings have been changed to support anchoring of both Buff Frames. The offsets and anchors were migrated automatically.",
		},
		Func = function()
			--migrate BuffFrame2 sizes
			Plater.db.profile.aura_width2 = Plater.db.profile.aura_width
			Plater.db.profile.aura_height2 = Plater.db.profile.aura_height

			--migrate BuffFrame1 and BuffFrame2 anchors/offsets
			local hasNonDefaultValues = Plater.db.profile.aura_x_offset or Plater.db.profile.aura_y_offset or Plater.db.profile.aura2_x_offset or Plater.db.profile.aura2_y_offset

			local heightOffset = 5
			local hbHeight = Plater.db.profile.plate_config.enemynpc.health_incombat[2] or 16
			--local hbWidth = Plater.db.profile.plate_config.enemynpc.health_incombat[1] or 100
			if Plater.db.profile.use_ui_parent then
				local clickHeight = Plater.db.profile.click_space[2] / UIParent:GetEffectiveScale()
				heightOffset = ((clickHeight - hbHeight) / 2) - (Plater.db.profile.aura_height / 2) + 5
				heightOffset = math.floor(heightOffset*10+0.5)/10
			end


			if Plater.db.profile.aura_grow_direction ~= 2 and (Plater.db.profile.aura_x_offset or 0) < -20 then -- assume left anchor
				if (Plater.db.profile.aura_y_offset or 0) < -(hbHeight + Plater.db.profile.aura_height + heightOffset)  then
					Plater.db.profile.aura_frame1_anchor.side = 3
					Plater.db.profile.aura_frame1_anchor.y = (Plater.db.profile.aura_y_offset or 0) + heightOffset
					Plater.db.profile.aura_frame1_anchor.x = 0
				elseif (Plater.db.profile.aura_y_offset or 0) < -heightOffset then
					Plater.db.profile.aura_frame1_anchor.side = 2
					Plater.db.profile.aura_frame1_anchor.y = -5
					Plater.db.profile.aura_frame1_anchor.x = -5
				else
					Plater.db.profile.aura_frame1_anchor.side = 1
					Plater.db.profile.aura_frame1_anchor.y = (Plater.db.profile.aura_y_offset or 0) + heightOffset
					Plater.db.profile.aura_frame1_anchor.x = 0
				end
			elseif Plater.db.profile.aura_grow_direction ~= 2 and (Plater.db.profile.aura_x_offset or 0) > 20 then -- assume right anchor
				if (Plater.db.profile.aura_y_offset or 0) < -(hbHeight + Plater.db.profile.aura_height + heightOffset)  then
					Plater.db.profile.aura_frame1_anchor.side = 5
					Plater.db.profile.aura_frame1_anchor.y = (Plater.db.profile.aura_y_offset or 0) + heightOffset
					Plater.db.profile.aura_frame1_anchor.x = 0
				elseif (Plater.db.profile.aura_y_offset or 0) < -heightOffset then
					Plater.db.profile.aura_frame1_anchor.side = 6
					Plater.db.profile.aura_frame1_anchor.y = -5
					Plater.db.profile.aura_frame1_anchor.x = 5
				else
					Plater.db.profile.aura_frame1_anchor.side = 7
					Plater.db.profile.aura_frame1_anchor.y = (Plater.db.profile.aura_y_offset or 0) + heightOffset
					Plater.db.profile.aura_frame1_anchor.x = 0
				end
			else
				Plater.db.profile.aura_frame1_anchor.side = 8
				Plater.db.profile.aura_frame1_anchor.x = Plater.db.profile.aura_x_offset or 0
			end
			Plater.db.profile.aura_x_offset = Plater.db.profile.aura_frame1_anchor.x
			Plater.db.profile.aura_y_offset = Plater.db.profile.aura_frame1_anchor.y


			if Plater.db.profile.aura2_grow_direction ~= 2 and (Plater.db.profile.aura2_x_offset or 0) < -20 then -- assume left anchor
				if (Plater.db.profile.aura2_y_offset or 0) < -(hbHeight + Plater.db.profile.aura_height + heightOffset)  then
					Plater.db.profile.aura_frame2_anchor.side = 3
					Plater.db.profile.aura_frame2_anchor.y = (Plater.db.profile.aura2_y_offset or 0) + heightOffset
					Plater.db.profile.aura_frame2_anchor.x = 0
				elseif (Plater.db.profile.aura2_y_offset or 0) < -heightOffset then
					Plater.db.profile.aura_frame2_anchor.side = 2
					Plater.db.profile.aura_frame2_anchor.y = -5
					Plater.db.profile.aura_frame2_anchor.x = -5
				else
					Plater.db.profile.aura_frame2_anchor.side = 1
					Plater.db.profile.aura_frame2_anchor.y = (Plater.db.profile.aura2_y_offset or 0) + heightOffset
					Plater.db.profile.aura_frame2_anchor.x = 0
				end
			elseif Plater.db.profile.aura2_grow_direction ~= 2 and (Plater.db.profile.aura2_x_offset or 0) > 20 then -- assume right anchor
				if (Plater.db.profile.aura2_y_offset or 0) < -(hbHeight + Plater.db.profile.aura_height + heightOffset)  then
					Plater.db.profile.aura_frame2_anchor.side = 5
					Plater.db.profile.aura_frame2_anchor.y = (Plater.db.profile.aura2_y_offset or 0) + heightOffset
					Plater.db.profile.aura_frame2_anchor.x = 0
				elseif (Plater.db.profile.aura2_y_offset or 0) < -heightOffset then
					Plater.db.profile.aura_frame2_anchor.side = 6
					Plater.db.profile.aura_frame2_anchor.y = -5
					Plater.db.profile.aura_frame2_anchor.x = 5
				else
					Plater.db.profile.aura_frame2_anchor.side = 7
					Plater.db.profile.aura_frame2_anchor.y = (Plater.db.profile.aura2_y_offset or 0) + heightOffset
					Plater.db.profile.aura_frame2_anchor.x = 0
				end
			else
				Plater.db.profile.aura_frame2_anchor.side = 8
				Plater.db.profile.aura_frame2_anchor.x = Plater.db.profile.aura2_x_offset or 0
			end
			Plater.db.profile.aura2_x_offset = Plater.db.profile.aura_frame2_anchor.x
			Plater.db.profile.aura2_y_offset = Plater.db.profile.aura_frame2_anchor.y

			if hasNonDefaultValues then
				C_Timer.After (10, function() DetailsFramework:ShowErrorMessage ("Buff Settings have been changed to support anchoring of both Buff Frames and the offsets and anchors were migrated automatically.\nPlease check the Buff Settings tab and adjust your Buff Frame anchors and offsets if needed.", "ATTENTION: Important Plater Profile Changes") end)
			end
		end
	})

	--#11 disable the Jaina, Stormwall, and M+ Bwonsamdi afix
	tinsert (PlaterPatchLibrary, {
		Notes = {"- Disabling 8.0 deprecated mods."},
		Func = function()
			local hookData = Plater.db.profile.hook_data
			for i = 1, #hookData do
				local hook = hookData [i]
				if (hook.Name == "Jaina Encounter [Plater]") then
					hook.Enabled = false
				elseif (hook.Name == "M+ Bwonsamdi Reaping") then
					hook.Enabled = false
				elseif (hook.Name == "Stormwall Encounter [Plater]") then
					hook.Enabled = false
				end
			end
		end
	})

	--#12 disable the "Cast Bar Icon Config" by default
	tinsert (PlaterPatchLibrary, {
		Notes = {"- Disabling 'Cast Bar Icon Config' by default."},
		Func = function()
			local hookData = Plater.db.profile.hook_data
			for i = 1, #hookData do
				local hook = hookData [i]
				if (hook.Name == "Cast Bar Icon Settings [P]") then
					hook.Enabled = false
				end
			end
		end
	})

	--#13 (add breath of coldheart - torghast - into the ignored buffs)
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Adding 'Breath of Coldheart' into the ignored buffs (automatic tracking)."
		},
		Func = function()
			--add breath of coldheart to ignore
			local buffIgnoreTable = Plater.db.profile and Plater.db.profile.aura_tracker and Plater.db.profile.aura_tracker.buff_banned
			if (buffIgnoreTable) then
				--add the buff to be ignored
				buffIgnoreTable[333553] = true
			end
		end
	})

	--#14 cleanup of npc_cache, npc_colors of string-indexed values
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Cleanup wrong indexes in npc_cache and npc_colors."
		},
		Func = function()
			--clean up npc_cache
			local npc_cache = Plater.db.profile.npc_cache
			local copy = DetailsFramework.table.copy({},npc_cache)
			for n,v in pairs(copy) do
				if tonumber(n) then
					npc_cache[n] = nil
					npc_cache[tonumber(n)] = v
				end
			end

			--clean up npc_colors
			local npc_colors = Plater.db.profile.npc_colors
			local copy = DetailsFramework.table.copy({},npc_colors)
			for n,v in pairs(copy) do
				if tonumber(n) then
					npc_colors[n] = nil
					npc_colors[tonumber(n)] = v
				end
			end
		end
	})

	--#15 add new triggers on 9.1, sanctum of domination
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Adding Sanctum of Domination triggers for scripts."
		},
		Func = function()
			local scriptData = Plater.db.profile.script_data
			for i = 1, #scriptData do
				local script = scriptData[i]
				--if (script.Name == "Unit - Main Target [P]") then --deprecated
				--	script.NpcNames[#script.NpcNames+1] = 179124

				if (script.Name == "Cast - Small Alert [Plater]") then
					script.SpellIds[#script.SpellIds+1] = 350554
					script.SpellIds[#script.SpellIds+1] = 348513
					script.SpellIds[#script.SpellIds+1] = 351779

					--add 350554 --call of eternity
					--348513 --reverberating hammer
					--351779 --agonizing nova

				elseif (script.Name == "Cast - Very Important [Plater]") then
					--350687/word-of-recall
					script.SpellIds[#script.SpellIds+1] = 350687

				elseif (script.Name == "Cast - Big Alert [Plater]") then
					--add 350421 --fated conjunction
					--352158 --torment
					--349985/tormented-eruptions
					script.SpellIds[#script.SpellIds+1] = 350421
					script.SpellIds[#script.SpellIds+1] = 352158
					script.SpellIds[#script.SpellIds+1] = 349985


				elseif (script.Name == "Cast - Frontal Cone [Plater]") then
					--add spell=352833 --disintegration
					script.SpellIds[#script.SpellIds+1] = 352833

				elseif (script.Name == "Cast - Castbar is Timer [P]") then


				end
			end
		end
	})

	--#16 wipe profile.captured_casts due to it not include player spells any more
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Wipe on captured casts due to a backend change."
		},
		Func = function()
			wipe(Plater.db.profile.captured_casts)
			wipe(Plater.db.profile.captured_spells)
			wipe(Plater.db.profile.cast_colors)
		end,
	})

	--#17 disable the change nameplate color from "Blink by Time Left" script
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Disable the change nameplate color from 'Blink by Time Left' script."
		},
		Func = function()
			local scriptData = Plater.db.profile.script_data
			for i = 1, #scriptData do
				local script = scriptData[i]
				if (script.Name == "Aura - Blink by Time Left [Plater]") then
					for _, scriptOptions in ipairs(script.Options) do
						if (scriptOptions.Key == "changeNameplateColor") then
							scriptOptions.Value = false
						end
					end

					if (script.OptionsValues and script.OptionsValues["changeNameplateColor"]) then
						script.OptionsValues["changeNameplateColor"] = false
					end

					break
				end
			end
		end
	})

	--#18 9.1.5 spell trigger additions
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Added Wing Buffet spell to frontal cone script."
		},
		Func = function()
			--scripts
			local scriptData = Plater.db.profile.script_data
			for i = 1, #scriptData do
				local script = scriptData[i]
				if (script.Name == "Cast - Frontal Cone [Plater]") then
					--add Wing Buffet spell from Plagueroc on Plaguefall
					script.SpellIds[#script.SpellIds+1] = 330403
					break

				elseif (script.Name == "Cast - Big Alert [Plater]") then
					--add Creepy Crawlers spell from Decaying Flesh Giant
					script.SpellIds[#script.SpellIds+1] = 329239
					--Stealthlings
					script.SpellIds[#script.SpellIds+1] = 328400

				elseif (script.Name == "Cast - Small Alert [Plater]") then
					--Gripping Infection
					script.SpellIds[#script.SpellIds+1] = 328180
					--Vile Spit
					script.SpellIds[#script.SpellIds+1] = 319898
				end
			end
		end
	})

	--#19 9.2 add default ghost auras
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Added default ghost aura spells."
		},
		Func = function()
			local auraTable = Plater.db.profile.ghost_auras.auras
			auraTable["PRIEST"][3][589] = true --shadow word: pain
			auraTable["PRIEST"][3][34914] = true --vampiric touch
			auraTable["WARLOCK"][1][172] = true --corruption
			auraTable["WARLOCK"][1][980] = true --agony
		end
	})

	--#20 9.2.5 Season 4 Dungeons Spells - all spellIds entries has been removed, script deprecated
	tinsert (PlaterPatchLibrary, {
		Deprecated = true,
		Notes = {
			"- Added Season 4 Dungeon Spells Into Scripts."
		},
		Func = function()
			local addUnique = DetailsFramework.table.addunique

			--aura tracker
			local buffTrackerTable = Plater.db.profile and Plater.db.profile.aura_tracker and Plater.db.profile.aura_tracker.buff_tracked
			if (buffTrackerTable) then
			end

			--scripts
			local scriptData = Plater.db.profile.script_data
			for i = 1, #scriptData do
				local script = scriptData[i]
			end
		end
	})

	--#21 script "Add - Tag Number [P]" doesn't work as intended due to if some nameplate isn't in the screen it will show wrong ids
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Disabling 'Add - Tag Number [P]' script.",
		},
		Func = function()
			local scriptData = Plater.db.profile.script_data
			for i = 1, #scriptData do
				local script = scriptData[i]
				if (script.Name == "Add - Tag Number [P]") then
					script.Enabled = false
					break
				end
			end
		end
	})
	
	--#22 cleanup of cast_colors, cast_audiocues of string-indexed values
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Cleanup wrong indexes in cast_colors and cast_audiocues."
		},
		Func = function()
			-- cleanup cast colors/sounds
			local castColors = Plater.db.profile.cast_colors
			local castColorsTemp = DetailsFramework.table.copy({}, castColors)
			for n, v in pairs(castColorsTemp) do
				if tonumber(n) then 
					castColors[n] = nil
					castColors[tonumber(n)] = v 
				end
			end

			local audioCues = Plater.db.profile.cast_audiocues
			local audioCuesTemp = DetailsFramework.table.copy({}, audioCues)
			for n, v in pairs(audioCuesTemp) do
				if tonumber(n) then 
					audioCues[n] = nil
					audioCues[tonumber(n)] = v 
				end
			end
		end
	})

	--#23 script trigger updates
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Patching scripts for Ruby Life Pools Season 1 Dragonflight."
		},
		Func = function()
			--fixes for ruby life pools
			Plater.AddTriggerToScript(372735, "cast", "Cast - Very Important [Plater]")
			Plater.AddTriggerToScript(384194, "cast", "Cast - Big Alert [Plater]")
			Plater.AddTriggerToScript(373017, "cast", "Cast - Very Important [Plater]")
			Plater.AddTriggerToScript(372107, "cast", "Cast - Ultra Important [P]")
			Plater.AddTriggerToScript(392488, "cast", "Cast - Very Important [Plater]")
			Plater.AddTriggerToScript(391050, "cast", "Cast - Shield Interrupt [P]")
			Plater.AddTriggerToScript(392451, "cast", "Cast - Big Alert [Plater]")
			Plater.AddTriggerToScript(392924, "cast", "Cast - Big Alert [Plater]")
		end
	})

	--#24 script trigger updates
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Patching scripts for Temple of the Jade Serpent Season 1 Dragonflight."
		},
		Func = function()
			Plater.AddTriggerToScript(200388, "npc", "Add - Explode on Die [P]") --little sha add which explodes on death
			Plater.AddTriggerToScript(397889, "cast", "Cast - Big Alert [Plater]") --tidal burtal
		end
	})


	--#25 script trigger updates
	tinsert (PlaterPatchLibrary, {
		Notes = {
			"- Patching scripts triggers for season of Dragonflight Mythic+."
		},
		Func = function()
			Plater.AddTriggerToScript(388923, "cast", "Cast - Ultra Important [P]") --Burst Forth
			Plater.AddTriggerToScript(377912, "cast", "Cast - Circle AoE [P]") --Expel Intruders
			Plater.AddTriggerToScript(377912, "cast", "Cast - On Going Cast [P]") --Arcane Rain
			Plater.AddTriggerToScript(209495, "cast", "Cast - Frontal Cone [Plater]") --Charged Smash
			Plater.AddTriggerToScript(209033, "cast", "Cast - Quick Flash [P]") --Fortification
			Plater.AddTriggerToScript(209413, "cast", "Cast - Big Alert [Plater]") --Suppress
			Plater.AddTriggerToScript(207980, "cast", "Cast - Big Alert [Plater]") --Disintegration Beam
		end,
		NotEssential = false,
	})


	--#26 test for the non-essential patches
	tinsert (PlaterPatchLibrary, {
		NotEssential = true,

		Notes = {
			"- test patch."
		},
		Func = function()
		end,
	})

	--#27 triggers for 10.1 season 2 dragonflight m+ dungeons
	tinsert (PlaterPatchLibrary, {
		NotEssential = true,

		Notes = {
			"- Added support for season 2 mythic dungeons."
		},
		Func = function()
			local addTriggers = {
				["Add - Explode on Die [P]"] = {189299, 131402, npc = true},
				["Add - Important [P]"] = {190381, 92538, 192464, npc = true},
				["Add - Warning [P]"] = {129758, 190426, 186696, 101075, 100818, 98081, 52019, npc = true},
				["Aura - Buff Alert [Plater]"] = {377738, 378149},
				["Cast - Big Alert [Plater]"] = {257397, 257736, 382787, 374699, 377402, 369602, 369465, 369400, 381593, 265091, 265433, 382791, 376780},
				["Cast - Circle AoE [P]"] = {258672, 258777, 257756, 257784, 256405, 256589, 393793, 388046, 375079, 390290, 369811, 369703, 226287, 410999, 372561},
				["Cast - Frontal Cone [Plater]"] = {257426, 255952, 257870, 413147, 383107, 377559, 388060, 376170, 384524, 375351, 390111, 369791, 369573, 369563, 369335, 369061, 375727, 265016, 265019, 260793, 260292, 272457, 272609, 269843, 183465, 226296, 188169, 183088, 410873, 411012, 88308, 382708, 375251, 375439, 372311, 373742, 372201, 374533, 377204},
				["Cast - Glowing [P]"] = {384353, 265376, 193941, 411002},
				["Cast - Quick Flash [P]"] = {385029, 374563, 377341, 369675, 369365, 369411, 278961, 202108, 88186},
				["Cast - Small Alert [Plater]"] = {281420, 274383, 259092, 367521, 374544, 385039, 382474, 369823, 377500, 260879, 186269, 378818, 371875, 372225},
				["Cast - Ultra Important [P]"] = {376934, 384899, 373960, 374724, 385551, 259732, 373424, 373084, 87618},
				["Cast - Very Important [Plater]"] = {257732, 256060, 257899, 384633, 374339, 395694, 391634, 372701, 369328, 265487, 413044, 183526, 88194, 87762, 413385, 411001, 378282, 384161},
			}

			for scriptName, triggerList in pairs(addTriggers) do
				if (triggerList.npc) then
					for _, npcId in ipairs(triggerList) do
						Plater.AddTriggerToScript(npcId, "npc", scriptName)
					end
				else
					for _, spellId in ipairs(triggerList) do
						Plater.AddTriggerToScript(spellId, "cast", scriptName)
					end
				end
			end
		end,
	})

	--#28 modify the castbar color option of "Cast - Ultra Important [P]" from red to yellow
	tinsert(PlaterPatchLibrary, {
		Notes = {
			"- Modifying the default cast bar color of 'Cast - Ultra Important [P]' to yellow."
		},
		Func = function()
			local scriptData = Plater.db.profile.script_data
			for i = 1, #scriptData do
				local script = scriptData[i]
				if (script.Name == "Cast - Ultra Important [P]") then
					for _, scriptOptions in ipairs(script.Options) do
						if (scriptOptions.Key == "castBarColor") then
							local color = scriptOptions.Value
							if (type(color) == "boolean") then
								scriptOptions.Value = {}
								color = scriptOptions.Value
							end
							color[1] = 1 --red
							color[2] = 0.431372 --green
							color[3] = 0 --blue
							color[4] = 1 --alpha
						end
					end
					break
				end
			end
		end
	})
	
	--#29 ensure auto-function for "hide blizzard healthbars" is setup properly
	tinsert (PlaterPatchLibrary, {
		NotEssential = false,

		Notes = {
			"- Setup auto-toggle for 'Hide Blizzard Healthbars'."
		},
		Func = function()
			if GetCVarBool ("nameplateShowOnlyNames") or Plater.db.profile.saved_cvars.nameplateShowOnlyNames == "1" then
				Plater.db.profile.auto_toggle_combat.blizz_healthbar_ic = true
				Plater.db.profile.auto_toggle_combat.blizz_healthbar_ooc = true
			end
		end,
	})
	
	--#30 cleanup of renamed npcs string-indexed values
	tinsert (PlaterPatchLibrary, {
		NotEssential = false,
		
		Notes = {
			"- Cleanup wrong indexes in npcs_renamed."
		},
		Func = function()
			local renamedNPCs = Plater.db.profile.npcs_renamed
			local renamedNPCsTemp = DetailsFramework.table.copy({}, renamedNPCs)
			
			for npcId, renamedName in pairs(renamedNPCsTemp) do
				if tonumber(npcId) then 
					renamedNPCs[tonumber(npcId)] = renamedNPCs[npcId] or renamedName -- ensure not to overwrite already existing (changed) after import
					renamedNPCs[npcId] = nil
				end
			end
		end
	})
	
	--#31 adjust level text and bar sizes for hardcore
	tinsert (PlaterPatchLibrary, {
		NotEssential = true,
		
		Notes = {
			"- Adjust level text and bar sizes for hardcore realms."
		},
		Func = function()
			if (C_GameRules and C_GameRules.IsHardcoreActive and C_GameRules.IsHardcoreActive()) then
				Plater.db.profile.plate_config.enemyplayer.level_text_alpha = 1
				Plater.db.profile.plate_config.enemynpc.level_text_alpha = 1
				Plater.db.profile.plate_config.friendlyplayer.level_text_alpha = 1
				Plater.db.profile.plate_config.friendlynpc.level_text_alpha = 1
				
				if (not Plater.db.profile.first_run3) then
					Plater.db.profile.plate_config.enemynpc.health[1] = 90
					Plater.db.profile.plate_config.enemynpc.health[2] = 10
					Plater.db.profile.plate_config.enemynpc.health_incombat[1] = 100
					Plater.db.profile.plate_config.enemynpc.health_incombat[2] = 12
				end
			end
		end
	})
	
	--#32 Cleanup Ghost Auras indexes to be numbers again and remove trash.
	tinsert (PlaterPatchLibrary, {
		NotEssential = false,
		
		Notes = {
			"- Cleanup and repair Ghost Auras data."
		},
		Func = function()
			--cleanup is needed for proper number indexing. will remove crap as well.
			
			local ghostAuras = Plater.db.profile.ghost_auras.auras
			local ghostAurasTemp = DetailsFramework.table.copy({}, ghostAuras)
			local ghostAurasDefault = PLATER_DEFAULT_SETTINGS.profile.ghost_auras.auras
			
			for class, specs in pairs(ghostAurasTemp) do
				for specID, specData in pairs(specs) do
					ghostAuras[class][specID] = nil
					if ghostAurasDefault[class][tonumber(specID)] then
						ghostAuras[class][tonumber(specID)] = ghostAuras[class][tonumber(specID)] or {}
						for spellId, enabled in pairs(specData) do
							if tonumber(spellId) then
								ghostAuras[class][tonumber(specID)][tonumber(spellId)] = enabled 
							end
						end
					end
				end
			end
		end
	})
	
	--#33 Reset range check values if necessary....
	tinsert (PlaterPatchLibrary, {
		NotEssential = false,
		
		Notes = {
			"- Reset range check distance settings if necessary."
		},
		Func = function()
			--range check spells
			local LibRangeCheck = LibStub:GetLibrary ("LibRangeCheck-3.0")
			LibRangeCheck.RegisterCallback(PlaterPatchLibrary, LibRangeCheck.CHECKERS_CHANGED, function() 
				local harmCheckers = {}
				for range, func in LibRangeCheck:GetHarmCheckers(true) do
					harmCheckers[range] = func
				end
				local friendCheckers = {}
				for range, func in LibRangeCheck:GetFriendCheckers(true) do
					friendCheckers[range] = func
				end
				if WOW_PROJECT_ID == WOW_PROJECT_MAINLINE then
					for specID, _ in pairs (Plater.SpecList [select (2, UnitClass ("player"))]) do
						if harmCheckers then
							if (PlaterDBChr.spellRangeCheckRangeEnemy [specID] == nil or not harmCheckers[PlaterDBChr.spellRangeCheckRangeEnemy [specID]]) then
								PlaterDBChr.spellRangeCheckRangeEnemy [specID] = Plater.DefaultSpellRangeList [specID]
							end
						end
						if friendCheckers then
							if (PlaterDBChr.spellRangeCheckRangeFriendly [specID] == nil or not friendCheckers[PlaterDBChr.spellRangeCheckRangeFriendly [specID]]) then
								PlaterDBChr.spellRangeCheckRangeFriendly [specID] = Plater.DefaultSpellRangeListF [specID]
							end
						end
					end
				else
					local playerClass = select (3, UnitClass ("player"))
					if harmCheckers then
						if (PlaterDBChr.spellRangeCheckRangeEnemy [playerClass] == nil or not harmCheckers[PlaterDBChr.spellRangeCheckRangeEnemy [playerClass]]) then
							PlaterDBChr.spellRangeCheckRangeEnemy [playerClass] = Plater.DefaultSpellRangeList [playerClass]
						end
					end
					if friendCheckers then
						if (PlaterDBChr.spellRangeCheckRangeFriendly [playerClass] == nil or not friendCheckers[PlaterDBChr.spellRangeCheckRangeFriendly [playerClass]]) then
							PlaterDBChr.spellRangeCheckRangeFriendly [playerClass] = Plater.DefaultSpellRangeListF [playerClass]
						end
					end
				end
				Plater.GetSpellForRangeCheck()
			end)
		end
	})

	--#34 triggers for 10.2 season 3 dragonflight m+ dungeons
	tinsert (PlaterPatchLibrary, {
		NotEssential = true,

		Notes = {
			"- Added support for season 3 mythic dungeons."
		},
		Func = function()
			local addTriggers = {
				["Add - Explode on Die [P]"] = {135052, npc = true},
				["Add - Health Percent Text"] = {125977, npc = true},
				["Add - Important [P]"] = {131009, 127315, 133361, 136330, 214117, 212483, 101008, npc = true},
				["Add - Warning [P]"] = {npc = true},
				["Aura - Big Stack Counter"] = {260512},
				["Aura - Buff Alert [Plater]"] = {},
				["Cast - Big Alert [Plater]"] = {225573, 278444, 164887, 168082, 76813, 227913, 265368},
				["Fixate by Unit Buff [P]"] = {426662, 426663},
				["Cast - Circle AoE [P]"] = {256882, 172578, 412063},
				["Cast - Frontal Cone [Plater]"] = {201226, 204667, 198379, 200768, 253239, 250258, 255567, 194956, 427510, 426645, 412505, 412129, 419351, 401482, 404916, 200345, 200261, 198641, 265372, 271174, 264694, 264923},
				["Cast - Glowing [P]"] = {169445},
				["Cast - Quick Flash [P]"] = {255824, 252781, 250096, 200248, 197797, 264520, 418202, 201839, 412012, 411958},
				["Cast - Small Alert [Plater]"] = {200658, 266036, 265407, 164965, 429176, 428526, 418200, 407124, 200630, 415437, 264050, 267824},
				["Cast - Stop Casting [P]"] = {200291, 268202},
				["Cast - Ultra Important [P]"] = {255041, 428926, 76634, 200050, 197546, 198079, 199193, 266181},
				["Cast - Very Important [Plater]"] = {259572, 255371, 427460, 429172, 426500, 413607, 412922, 417481, 201399, 411994, 415770, 260907, 260703, 260741, 265876, 263959, 266225},
			}

			for scriptName, triggerList in pairs(addTriggers) do
				if (triggerList.npc) then
					for _, npcId in ipairs(triggerList) do
						Plater.AddTriggerToScript(npcId, "npc", scriptName)
					end
				else
					for _, spellId in ipairs(triggerList) do
						Plater.AddTriggerToScript(spellId, "cast", scriptName)
					end
				end
			end
		end,
	})

	--#35 triggers for 10.2 season 3 dragonflight m+ dungeons, part 2
	tinsert (PlaterPatchLibrary, {
		NotEssential = true,

		Notes = {
			"- Added support for season 3 mythic dungeons."
		},
		Func = function()
			local addTriggers = {
				["Cast - Ultra Important [P]"] = {253544},
				["Cast - Very Important [Plater]"] = {253517},
			}

			for scriptName, triggerList in pairs(addTriggers) do
				if (triggerList.npc) then
					for _, npcId in ipairs(triggerList) do
						Plater.AddTriggerToScript(npcId, "npc", scriptName)
					end
				else
					for _, spellId in ipairs(triggerList) do
						Plater.AddTriggerToScript(spellId, "cast", scriptName)
					end
				end
			end
		end,
	})

	--#36 triggers for 10.2.7 season 4 dragonflight m+ dungeons
	tinsert (PlaterPatchLibrary, {
		NotEssential = true,

		Notes = {
			"- Applied adjustments for season 4 mythic dungeons."
		},
		Func = function()
			local addTriggers = {
				--script name			  trigger list
				["Add - Important [P]"] = {194745, 190426, npc = true}, --Rotfang Hyena, Decay Totem
				["Explosion Affix M+ [Plater]"] = {389446}, --Nullifying Pulse, 
				["Cast - Very Important [Plater]"] = {377488}, --Icy Bindings
			}

			for scriptName, triggerList in pairs(addTriggers) do
				if (triggerList.npc) then
					for _, npcId in ipairs(triggerList) do
						Plater.AddTriggerToScript(npcId, "npc", scriptName)
					end
				else
					for _, spellId in ipairs(triggerList) do
						Plater.AddTriggerToScript(spellId, "cast", scriptName)
					end
				end
			end
		end,
	})
	
	--#37 cleanup of spell animation IDs
	tinsert (PlaterPatchLibrary, {
		NotEssential = false,
		
		Notes = {
			"- Cleanup wrong indexes in spell_animation_list."
		},
		Func = function()
			local spellAnimations = Plater.db.profile.spell_animation_list
			local spellAnimationsTemp = DetailsFramework.table.copy({}, spellAnimations)

			for spellId, animation in pairs(spellAnimationsTemp) do
				if tonumber(spellId) then 
					spellAnimations[spellId] = nil
					spellAnimations[tonumber(spellId)] = animation 
				end
			end
		end
	})
	
	--#38 fix aura swipe
	tinsert (PlaterPatchLibrary, {
		NotEssential = false,
		
		Notes = {
			"- Fix broken aura swipe texture."
		},
		Func = function()
			if Plater.db.profile.aura_cooldown_edge_texture == "Interface\\GLUES\\loadingOld" then
				Plater.db.profile.aura_cooldown_edge_texture = [[Interface\AddOns\Plater\images\transparent]]
			end
		end
	})

	--#39 add spell to wow 11.1
	tinsert (PlaterPatchLibrary, {
		NotEssential = true,

		Notes = {
			"- Added spells to 11.1 dungeons."
		},
		Func = function()
			local addTriggers = {
				--script name			  trigger list
				["Add - Explode on Die [P]"] = {130653, 231497, npc = true},
				["Add - Important [P]"] = {152033, 170234, 220368, 231176, 213751, npc = true},
				["Aura - Buff Alert [Plater]"] = {282801},
				["Cast - AoE Hit All [P]"] = {258622, 269429, 271456, 1215102, 1215409, 291946, 297128, 1215741, 330716, 463206, 442995, 435622, 465827, 460156, 1218117, 428266, 427404, 1214628, 424431, 448791},
				["Cast - AoE With Range [P]"] = {267354, 1214754, 260280, 293861, 285454, 317605, 339415, 331223, 318406, 442589, 423501, 440652, 424621},
				["Cast - Frontal Cone [Plater]"] = {1217279, 267551, 275907, 259940, 283421, 293986, 291865, 292264, 1215738, 334023, 317231, 320729, 333294, 330614, 323608, 432198, 441119, 448619, 436592, 473220, 472452, 465682, 465754, 473114, 1217496, 422122, 426261, 421277, 427025, 426893, 474018, 1214546, 445457, 447270},
				["Cast - Heal Cut [P]"] = {293729, 341902, 341977, 441351, 441627, 463058, 471733, 425536, 427356, 424419, 423051},
				["Cast - Important Target [P]"] = {270042, 260813},
				["Cast - Shining Green [P]"] = {268702, 268797, 330562, 330868, 341969, 440687, 1214780, 1214468, 426295, 422541, 427011, 427157, 427601, 424420, 444743},
				["Cast - Simple Interrupt [P]"] = {269302, 263215, 342675, 453909, 462771, 424322, 426145, 427260},
				["Cast - Small Alert [Plater]"] = {271579, 301088, 423479},
				["Cast - Special Ability [P]"] = {282801, 1215412, 474298, 339573, 468841, 444034},
				["Cast - Voidzone [P]"] = {472041, 473168, 473304, 1216431, 320182, 1215850, 331237, 434706, 434998, 439365, 473070, 427484, 424462, 424429, 423062},
				["Fixate On You [Plater]"] = {129802, 133482, 235631, 231014, npc = true},
				--[""] = {},
				--[""] = {},
			}

			for scriptName, triggerList in pairs(addTriggers) do
				if (triggerList.npc) then
					for _, npcId in ipairs(triggerList) do
						Plater.AddTriggerToScript(npcId, "npc", scriptName)
					end
				else
					for _, spellId in ipairs(triggerList) do
						Plater.AddTriggerToScript(spellId, "cast", scriptName)
					end
				end
			end
		end,
	})

	--[=[
	tinsert (PlaterPatchLibrary, {

	})
	--]=]

	--to tag an update as non-essential, add "NotEssential = true," to the table
	--/run Plater.db.profile.patch_version = 30
end --end of patch library

local listOfTriggersToDeprecateOnExpansion = {
	[9] = { --9 = dragonflight (this probably can be removed on patch 10.2 - expansion mid tier)
		--this is a complete list of Shadowlands default triggers on all bundled scripts
		[323149] = true, [324392] = true, [342189] = true, [333227] = true, [227931] = true, [233210] = true, [300207] = true, [297133] = true,
		[337220] = true, [337253] = true, [337251] = true,
		[227548] = true,
		[163520] = true, [163618] = true, [164506] = true,
		[355787] = true,
		[338353] = true, [334748] = true, [334749] = true, [320784] = true, [341352] = true, [341520] = true, [341522] = true, [336005] = true, [339777] = true, [331933] = true, [326617] = true, [324914] = true, [324776] = true, [326046] = true, [340634] = true, [319070] = true, [328295] = true, [317936] = true, [327413] = true, [319654] = true, [323821] = true, [320772] = true, [324293] = true, [330562] = true, [330868] = true, [341902] = true, [342139] = true, [342675] = true, [323190] = true, [332836] = true, [327648] = true, [328217] = true, [322938] = true, [340544] = true, [325876] = true, [325700] = true, [323552] = true, [332666] = true, [332612] = true, [332706] = true, [340026] = true, [294171] = true, [292910] = true, [294165] = true, [338871] = true, [330813] = true, [335694] = true, [327461] = true, [329787] = true, [304946] = true, [15245] = true, [276754] = true, [304831] = true, [277036] = true, [320657] = true, [294362] = true, [270248] = true, [292926] = true, [350421] = true, [352158] = true, [349985] = true, [329239] = true, [328400] = true, [164192] = true, [176032] = true, [166387] = true, [162066] = true, [163689] = true, [227592] = true, [228254] = true, [227999] = true, [227987] = true, [232115] = true, [29580] = true, [227616] = true, [241828] = true, [228606] = true, [227800] = true, [228239] = true, [229706] = true, [294884] = true, [301629] = true, [284219] = true, [301689] = true, [300650] = true, [297835] = true, [300171] = true, [300087] = true, [300414] = true, [300436] = true, [301088] = true, [293729] = true, [291928] = true,
		[323489] = true, [323496] = true, [319941] = true, [319592] = true, [334266] = true, [325258] = true, [334913] = true, [326221] = true, [322936] = true, [323236] = true, [321834] = true, [336752] = true, [325418] = true, [324667] = true, [327233] = true, [324368] = true, [324205] = true, [323943] = true, [319713] = true, [320596] = true, [320729] = true, [323608] = true, [330614] = true, [320063] = true, [332708] = true, [334023] = true, [317231] = true, [317943] = true, [320966] = true, [334053] = true, [328458] = true, [321968] = true, [331718] = true, [325793] = true, [330453] = true, [326997] = true, [334051] = true, [292903] = true, [330843] = true, [294173] = true, [189200] = true, [352833] = true, [330403] = true, [166675] = true, [176127] = true, [166380] = true, [162058] = true, [167516] = true, [178299] = true, [172982] = true, [163390] = true, [173384] = true, [173514] = true, [29513] = true, [227672] = true, [228603] = true, [227339] = true, [227493] = true, [241774] = true, [229611] = true, [229151] = true, [300188] = true, [299475] = true, [299502] = true, [300777] = true, [301681] = true, [298946] = true, [298940] = true, [300424] = true, [283422] = true, [294290] = true, [291973] = true, [293986] = true, [291878] = true, [292264] = true,
		[373429] = true,
		[354173] = true,
		[320170] = true, [320171] = true, [320462] = true, [330712] = true, [332170] = true, [333875] = true, [326836] = true, [342135] = true, [333861] = true, [341969] = true, [317963] = true, [327481] = true, [328331] = true, [322614] = true, [325701] = true, [326438] = true, [323538] = true, [321764] = true, [296523] = true, [330755] = true, [295929] = true, [296019] = true, [335685] = true, [170751] = true, [342207] = true, [350554] = true, [348513] = true, [351779] = true, [328180] = true, [319898] = true, [166335] = true, [172810] = true, [172943] = true, [173148] = true, [163376] = true, [228011] = true, [228277] = true, [29928] = true, [228559] = true, [230050] = true, [374743] = true, [227615] = true, [229716] = true, [229083] = true, [299525] = true, [300514] = true, [285388] = true, [294324] = true, [294180] = true, [293827] = true, [297128] = true, [294015] = true, [291865] = true,
		[321828] = true,
		[332329] = true, [320103] = true, [321406] = true, [335817] = true, [321061] = true, [320141] = true, [326171] = true, [163966] = true, [227966] = true,
		[321247] = true, [334522] = true, [320232] = true, [319962] = true, [325879] = true, [324427] = true, [322999] = true, [325360] = true, [322903] = true, [324103] = true, [333294] = true, [333540] = true, [319521] = true, [326021] = true, [326450] = true, [322711] = true, [329104] = true, [295000] = true, [242391] = true, [320197] = true, [329608] = true, [350687] = true, [161090] = true, [156301] = true, [166341] = true, [163379] = true, [166923] = true, [172952] = true, [164426] = true, [163665] = true, [227578] = true, [228528] = true, [227789] = true, [227779] = true, [229608] = true, [227925] = true, [300129] = true, [296522] = true, [294349] = true, [293854] = true, [297834] = true, [299588] = true, [302682] = true, [291946] = true, [295169] = true, [285440] = true, [291613] = true, [283551] = true,
		[164427] = true, [164414] = true, [164185] = true, [164567] = true, [165408] = true,
		[165560] = true,
		[185685] = true, [185680] = true, [185683] = true,
		[164451] = true, [164463] = true, [164461] = true, [165946] = true, [164501] = true, [164218] = true,
		[164362] = true, [168882] = true, [168988] = true, [170234] = true, [165905] = true, [170452] = true, [80875] = true, [163746] = true, [152033] = true,
		[156212] = true, [168098] = true, [179124] = true,
		[164406] = true, [164407] = true, [162100] = true, [162099] = true, [162329] = true, [164558] = true, [150159] = true,
	},
}

local listOfScriptsToDeprecateOnExpasion = {
	[9] = { --9 = dragonflight (this probably can be removed on patch 10.2 - expansion mid tier)
		--this is a complete list of Shadowlands default scripts made only for that expansion
		["Relics 9.2 M Dungeons"] = true,
		["Cast - Tank Interrupt [P]"] = true,
		["Unit - Main Target [P]"] = true,
		["Unit - Important [Plater]"] = true,
		["Unit - Health Markers [P]"] = true,
	}
}

local listOfTriggersToDeprecateOnExpansionAsArray = { --v10 deprecated triggers
	194895, 105703, 59598, 58319, 200388, 189299, 131402, 135052, 197697, 59544, 186227, 184020, 91005, 196548, 195580, 195820, 195821, 189886, 75966, 102019, 187159, 194897, 104251, 101326, 189669, 192464, 190381, 92538, 192464, 131009, 127315, 133361, 136330, 214117, 212483, 101008, 194745, 190426,
	194622, 190205, 197398, 77006, 190187, 189893, 99922, 104822, 129758, 186696, 101075, 100818, 98081, 52019, 398151, 377738, 378149, 372743, 372749, 384933, 350421, 355787, 348513, 396640, 372743, 377389, 396812, 388392, 387955, 386546, 377503, 384808, 386024, 387615, 387606, 225100, 211401, 211470, 215433, 192563, 198959, 152818, 156776, 398206, 153524, 396073, 396018, 345202, 377950, 372223, 350421, 352158, 349985, 329239, 328400, 384194, 392451, 392924, 397889, 209413, 207980, 257397, 257736, 382787, 374699, 377402, 369602, 369465, 369400, 381593, 265091, 265433, 382791, 376780, 225573, 278444, 164887, 168082, 76813, 227913, 265368, 
	385916, 386063, 388822, 373087, 397785, 106864, 193660, 198263, 387910, 370766, 375591, 384336, 209404, 209378, 210875, 396001, 397899, 386559, 382555, 258672, 258777, 257756, 257784, 256405, 256589, 393793, 388046, 375079, 390290, 369811, 369703, 226287, 410999, 372561, 256882, 172578, 412063,
	375943, 385958, 388623, 377034, 374361, 381525, 386660, 385578, 384699, 153501, 153686, 154442, 192018, 219488, 372087, 391726, 391723, 377383, 388976, 370764, 387067, 391118, 391136, 382233, 209027, 212031, 207261, 207979, 198888, 199805, 199050, 191508, 152792, 153395, 352833, 330403, 209495, 257426, 255952, 257870, 413147, 383107, 377559, 388060, 376170, 384524, 375351, 390111, 369791, 369573, 369563, 369335, 369061, 375727, 265016, 265019, 260793, 260292, 272457, 272609, 269843, 183465, 226296, 188169, 183088, 410873, 411012, 88308, 382708, 375251, 375439, 372311, 373742, 372201, 374533, 377204, 201226, 204667, 198379, 200768, 253239, 250258, 255567, 194956, 427510, 426645, 412505, 412129, 419351, 401482, 404916, 200345, 200261, 198641, 265372, 271174, 264694, 264923,
	376644, 386781, 384823, 385536, 392398, 375596, 387135, 360850, 212784, 199033, 199034, 200969, 394512, 397881, 396020, 374430, 384353, 265376, 193941, 411002, 169445,
	388886, 209676, 377912, 392640, 397888, 209033, 385029, 374563, 377341, 369675, 369365, 369411, 278961, 202108, 88186, 255824, 252781, 250096, 200248, 197797, 264520, 418202, 201839, 412012, 411958, 373688, 391050,
	376851, 396044, 381517, 373932, 397801, 208165, 392576, 198750, 387843, 387411, 211299, 198595, 198934, 198962, 156722, 350554, 348513, 351779, 328180, 319898, 281420, 274383, 259092, 367521, 374544, 385039, 382474, 369823, 377500, 260879, 186269, 378818, 371875, 372225, 200658, 266036, 265407, 164965, 429176, 428526, 418200, 407124, 200630, 415437, 264050, 267824, 
	377004, 381516, 196543, 199726, 200291, 268202, 383823, 382670, 388537, 372851, 200682, 192307, 196838, 193827, 194043, 209410, 211464, 361180, 156718, 395859, 358320, 374045, 386757, 367500, 370225, 376200, 372107, 388923, 376934, 384899, 373960, 374724, 385551, 259732, 373424, 373084, 87618, 255041, 428926, 76634, 200050, 197546, 198079, 199193, 266181, 253544, 
	373046, 372863, 164686, 153072, 153680, 196497, 388886, 387145, 384365, 152964, 398150, 152801, 397878, 397914, 183263, 3636, 376171, 350687, 372735, 373017, 350687, 392488, 257732, 256060, 257899, 384633, 374339, 395694, 391634, 372701, 369328, 265487, 413044, 183526, 88194, 87762, 413385, 411001, 378282, 384161, 259572, 255371, 427460, 429172, 426500, 413607, 412922, 417481, 201399, 411994, 415770, 260907, 260703, 260741, 265876, 263959, 266225, 253517, 377488, 
	164427, 164414, 164185, 164567, 165408, 240446, 385339, 198077, 210261, 360857, 389446, 165560, 426662, 426663, 164406, 164407, 162100, 162099, 162329, 164558, 195138, 192955, 190294, 76518, 163520, 163618, 164506, 163520, 163618, 164506,
}


--create namespace
platerInternal.ScriptTriggers = {}

--this function run at the beggining of Plater.OnInit() and Plater.RefreshConfig()
--run before Plater.UpdateFromLibrary(), UpdateFromLibrary() runs on OnInit and OnProfileCreated()
function platerInternal.ScriptTriggers.WipeDeprecatedScriptTriggersFromProfile(profile)
	local currentExpansion = GetExpansionLevel()

	if (not profile.expansion_triggerwipe[currentExpansion]) then
		if (currentExpansion == 10) then --tww
			---@type scriptdata[]
			local scriptList = profile.script_data

			--convert the list of triggers to be removed into a table for faster lookup
			local triggersToBeRemoved = {}
			for i = 1, #listOfTriggersToDeprecateOnExpansionAsArray do
				triggersToBeRemoved[listOfTriggersToDeprecateOnExpansionAsArray[i]] = true
			end

			--> remove the triggers that scripts has by default (added by plater)
				for i = 1, #scriptList do
					local scriptObject = scriptList[i]
					local scriptName = scriptObject.Name
					local npcIdTriggers = scriptObject.NpcNames
					local spellIdTriggers = scriptObject.SpellIds

					for o = #npcIdTriggers, 1, -1 do
						if (triggersToBeRemoved[tonumber(npcIdTriggers[o])]) then
							tremove(npcIdTriggers, o)
						end
					end

					for o = #spellIdTriggers, 1, -1 do
						if (triggersToBeRemoved[spellIdTriggers[o]]) then
							tremove(spellIdTriggers, o)
						end
					end
				end

			--> disable some scripts which won't be used in this expansion | on new profiles, these scripts will be disabled by default
				local deprecatedScripts = {
					["Explosion Affix M+ [Plater]"] = true,
					["Cast - Glowing [P]"] = true,
					["Cast - Effect After Cast [P]"] = true,
					["Cast - Big Alert [Plater]"] = true,
					["Cast - Circle AoE [P]"] = true,
					["Cast - On Going Cast [P]"] = true,
					["Cast - Very Important [Plater]"] = true,
					["Cast - Ultra Important [P]"] = true,
					["Cast - Quick Flash [P]"] = true,
				}

				for i = 1, #scriptList do
					local scriptObject = scriptList[i]
					if (deprecatedScripts[scriptObject.Name]) then
						scriptObject.Enabled = false
					end
				end

			profile.expansion_triggerwipe[currentExpansion] = true

		else --dragonflight
			local deprecatedTriggerListForExpansion = listOfTriggersToDeprecateOnExpansion[currentExpansion]
			if (deprecatedTriggerListForExpansion) then
				local scriptList = profile.script_data
				for i = 1, #scriptList do
					local scriptObject = scriptList[i]
					local npcIdTriggers = scriptObject.NpcNames
					local spellIdTriggers = scriptObject.SpellIds

					for o = #npcIdTriggers, 1, -1 do
						local npcId = tonumber(npcIdTriggers[o])
						if (deprecatedTriggerListForExpansion[npcId]) then
							tremove(npcIdTriggers, o)
						end
					end

					for o = #spellIdTriggers, 1, -1 do
						local spellIdId = spellIdTriggers[o]
						if (deprecatedTriggerListForExpansion[spellIdId]) then
							tremove(spellIdTriggers, o)
						end
					end
				end
			end

			local deprecatedScripts = listOfScriptsToDeprecateOnExpasion[currentExpansion]
			if (deprecatedScripts) then
				Plater:Msg("Checking for deprecated scritps")
				local scriptList = profile.script_data
				for i = #scriptList, 1, -1 do
					local scriptObject = scriptList[i]
					if (deprecatedScripts[scriptObject.Name]) then
						--set the time when the script has been moved to trash
						scriptObject.__TrashAt = time()
						tinsert (Plater.db.profile.script_data_trash, scriptObject)
						tremove (Plater.db.profile.script_data, i)
						Plater:Msg("Script", scriptObject.Name, "removed because is deprecated, you can restore from the trashcan.")
					end
				end
				Plater:Msg("Finished checking for deprecated scritps")
				Plater.WipeAndRecompileAllScripts("script")
			end
		end

		profile.expansion_triggerwipe[currentExpansion] = true
	end
end

--set the patch version to
-- /run Plater.db.profile.patch_version =

--Patches to apply only when the profile is running for the first time
do
	PlaterPatchLibraryForNewProfiles = {}

	-- #1 - enable the mod 'Cast Bar Icon Config' on new profiles
	tinsert (PlaterPatchLibraryForNewProfiles, {
		Notes = {
			"- Enabling 'Cast Bar Icon Config' mod.",
		},
		Func = function()
			local hookData = Plater.db.profile.hook_data
			for i = 1, #hookData do
				local hook = hookData [i]
				if (hook.Name == "Cast Bar Icon Settings [P]") then
					hook.Enabled = false --true, plater now have default castbar icon settings, this mod can be always disabled by default
					Plater.WipeAndRecompileAllScripts("hook")
				end
			end
		end
	})
end